// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__62102_62271 = cljs.core.seq.call(null,servers);
var chunk__62103_62272 = null;
var count__62104_62273 = (0);
var i__62105_62274 = (0);
while(true){
if((i__62105_62274 < count__62104_62273)){
var server_62275 = cljs.core._nth.call(null,chunk__62103_62272,i__62105_62274);
var healthcheck_uri_62276 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62275),"/fdb/health"].join('');
var resp_chan_62277 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_62276,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2748__auto___62278 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62278,healthcheck_uri_62276,resp_chan_62277,server_62275){
return (function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = ((function (seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62278,healthcheck_uri_62276,resp_chan_62277,server_62275){
return (function (state_62166){
var state_val_62167 = (state_62166[(1)]);
if((state_val_62167 === (1))){
var state_62166__$1 = state_62166;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62166__$1,(2),resp_chan_62277);
} else {
if((state_val_62167 === (2))){
var inst_62155 = (state_62166[(7)]);
var inst_62155__$1 = (state_62166[(2)]);
var inst_62156 = fluree.db.util.core.exception_QMARK_.call(null,inst_62155__$1);
var state_62166__$1 = (function (){var statearr_62168 = state_62166;
(statearr_62168[(7)] = inst_62155__$1);

return statearr_62168;
})();
if(inst_62156){
var statearr_62169_62279 = state_62166__$1;
(statearr_62169_62279[(1)] = (3));

} else {
var statearr_62170_62280 = state_62166__$1;
(statearr_62170_62280[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62167 === (3))){
var inst_62155 = (state_62166[(7)]);
var inst_62158 = cljs.core.ex_message.call(null,inst_62155);
var inst_62159 = cljs.core.ex_data.call(null,inst_62155);
var inst_62160 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_62158,inst_62159);
var state_62166__$1 = state_62166;
var statearr_62171_62281 = state_62166__$1;
(statearr_62171_62281[(2)] = inst_62160);

(statearr_62171_62281[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62167 === (4))){
var inst_62162 = cljs.core.async.put_BANG_.call(null,promise_chan,server_62275);
var state_62166__$1 = state_62166;
var statearr_62172_62282 = state_62166__$1;
(statearr_62172_62282[(2)] = inst_62162);

(statearr_62172_62282[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62167 === (5))){
var inst_62164 = (state_62166[(2)]);
var state_62166__$1 = state_62166;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62166__$1,inst_62164);
} else {
return null;
}
}
}
}
}
});})(seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62278,healthcheck_uri_62276,resp_chan_62277,server_62275))
;
return ((function (seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,switch__2725__auto__,c__2748__auto___62278,healthcheck_uri_62276,resp_chan_62277,server_62275){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0 = (function (){
var statearr_62173 = [null,null,null,null,null,null,null,null];
(statearr_62173[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__);

(statearr_62173[(1)] = (1));

return statearr_62173;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1 = (function (state_62166){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62166);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62174){var ex__2729__auto__ = e62174;
var statearr_62175_62283 = state_62166;
(statearr_62175_62283[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62166[(4)]))){
var statearr_62176_62284 = state_62166;
(statearr_62176_62284[(1)] = cljs.core.first.call(null,(state_62166[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62285 = state_62166;
state_62166 = G__62285;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__ = function(state_62166){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1.call(this,state_62166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__;
})()
;})(seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,switch__2725__auto__,c__2748__auto___62278,healthcheck_uri_62276,resp_chan_62277,server_62275))
})();
var state__2750__auto__ = (function (){var statearr_62177 = f__2749__auto__.call(null);
(statearr_62177[(6)] = c__2748__auto___62278);

return statearr_62177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
});})(seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62278,healthcheck_uri_62276,resp_chan_62277,server_62275))
);



var G__62286 = seq__62102_62271;
var G__62287 = chunk__62103_62272;
var G__62288 = count__62104_62273;
var G__62289 = (i__62105_62274 + (1));
seq__62102_62271 = G__62286;
chunk__62103_62272 = G__62287;
count__62104_62273 = G__62288;
i__62105_62274 = G__62289;
continue;
} else {
var temp__5753__auto___62290 = cljs.core.seq.call(null,seq__62102_62271);
if(temp__5753__auto___62290){
var seq__62102_62291__$1 = temp__5753__auto___62290;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62102_62291__$1)){
var c__4649__auto___62292 = cljs.core.chunk_first.call(null,seq__62102_62291__$1);
var G__62293 = cljs.core.chunk_rest.call(null,seq__62102_62291__$1);
var G__62294 = c__4649__auto___62292;
var G__62295 = cljs.core.count.call(null,c__4649__auto___62292);
var G__62296 = (0);
seq__62102_62271 = G__62293;
chunk__62103_62272 = G__62294;
count__62104_62273 = G__62295;
i__62105_62274 = G__62296;
continue;
} else {
var server_62297 = cljs.core.first.call(null,seq__62102_62291__$1);
var healthcheck_uri_62298 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_62297),"/fdb/health"].join('');
var resp_chan_62299 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_62298,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2748__auto___62300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62300,healthcheck_uri_62298,resp_chan_62299,server_62297,seq__62102_62291__$1,temp__5753__auto___62290){
return (function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = ((function (seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62300,healthcheck_uri_62298,resp_chan_62299,server_62297,seq__62102_62291__$1,temp__5753__auto___62290){
return (function (state_62190){
var state_val_62191 = (state_62190[(1)]);
if((state_val_62191 === (1))){
var state_62190__$1 = state_62190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62190__$1,(2),resp_chan_62299);
} else {
if((state_val_62191 === (2))){
var inst_62179 = (state_62190[(7)]);
var inst_62179__$1 = (state_62190[(2)]);
var inst_62180 = fluree.db.util.core.exception_QMARK_.call(null,inst_62179__$1);
var state_62190__$1 = (function (){var statearr_62192 = state_62190;
(statearr_62192[(7)] = inst_62179__$1);

return statearr_62192;
})();
if(inst_62180){
var statearr_62193_62301 = state_62190__$1;
(statearr_62193_62301[(1)] = (3));

} else {
var statearr_62194_62302 = state_62190__$1;
(statearr_62194_62302[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62191 === (3))){
var inst_62179 = (state_62190[(7)]);
var inst_62182 = cljs.core.ex_message.call(null,inst_62179);
var inst_62183 = cljs.core.ex_data.call(null,inst_62179);
var inst_62184 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_62182,inst_62183);
var state_62190__$1 = state_62190;
var statearr_62195_62303 = state_62190__$1;
(statearr_62195_62303[(2)] = inst_62184);

(statearr_62195_62303[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62191 === (4))){
var inst_62186 = cljs.core.async.put_BANG_.call(null,promise_chan,server_62297);
var state_62190__$1 = state_62190;
var statearr_62196_62304 = state_62190__$1;
(statearr_62196_62304[(2)] = inst_62186);

(statearr_62196_62304[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62191 === (5))){
var inst_62188 = (state_62190[(2)]);
var state_62190__$1 = state_62190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62190__$1,inst_62188);
} else {
return null;
}
}
}
}
}
});})(seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62300,healthcheck_uri_62298,resp_chan_62299,server_62297,seq__62102_62291__$1,temp__5753__auto___62290))
;
return ((function (seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,switch__2725__auto__,c__2748__auto___62300,healthcheck_uri_62298,resp_chan_62299,server_62297,seq__62102_62291__$1,temp__5753__auto___62290){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0 = (function (){
var statearr_62197 = [null,null,null,null,null,null,null,null];
(statearr_62197[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__);

(statearr_62197[(1)] = (1));

return statearr_62197;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1 = (function (state_62190){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62198){var ex__2729__auto__ = e62198;
var statearr_62199_62305 = state_62190;
(statearr_62199_62305[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62190[(4)]))){
var statearr_62200_62306 = state_62190;
(statearr_62200_62306[(1)] = cljs.core.first.call(null,(state_62190[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62307 = state_62190;
state_62190 = G__62307;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__ = function(state_62190){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1.call(this,state_62190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__;
})()
;})(seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,switch__2725__auto__,c__2748__auto___62300,healthcheck_uri_62298,resp_chan_62299,server_62297,seq__62102_62291__$1,temp__5753__auto___62290))
})();
var state__2750__auto__ = (function (){var statearr_62201 = f__2749__auto__.call(null);
(statearr_62201[(6)] = c__2748__auto___62300);

return statearr_62201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
});})(seq__62102_62271,chunk__62103_62272,count__62104_62273,i__62105_62274,c__2748__auto___62300,healthcheck_uri_62298,resp_chan_62299,server_62297,seq__62102_62291__$1,temp__5753__auto___62290))
);



var G__62308 = cljs.core.next.call(null,seq__62102_62291__$1);
var G__62309 = null;
var G__62310 = (0);
var G__62311 = (0);
seq__62102_62271 = G__62308;
chunk__62103_62272 = G__62309;
count__62104_62273 = G__62310;
i__62105_62274 = G__62311;
continue;
}
} else {
}
}
break;
}

var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_62245){
var state_val_62246 = (state_62245[(1)]);
if((state_val_62246 === (7))){
var inst_62217 = (state_62245[(7)]);
var inst_62224 = cljs.core._EQ_.call(null,inst_62217,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_62245__$1 = state_62245;
if(inst_62224){
var statearr_62247_62312 = state_62245__$1;
(statearr_62247_62312[(1)] = (9));

} else {
var statearr_62248_62313 = state_62245__$1;
(statearr_62248_62313[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (1))){
var inst_62210 = (state_62245[(8)]);
var inst_62209 = (state_62245[(9)]);
var inst_62209__$1 = promise_chan;
var inst_62210__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_62211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62212 = [inst_62209__$1,inst_62210__$1];
var inst_62213 = (new cljs.core.PersistentVector(null,2,(5),inst_62211,inst_62212,null));
var state_62245__$1 = (function (){var statearr_62249 = state_62245;
(statearr_62249[(8)] = inst_62210__$1);

(statearr_62249[(9)] = inst_62209__$1);

return statearr_62249;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62245__$1,(2),inst_62213);
} else {
if((state_val_62246 === (4))){
var inst_62210 = (state_62245[(8)]);
var inst_62217 = (state_62245[(7)]);
var inst_62221 = cljs.core._EQ_.call(null,inst_62217,inst_62210);
var state_62245__$1 = state_62245;
if(inst_62221){
var statearr_62250_62314 = state_62245__$1;
(statearr_62250_62314[(1)] = (6));

} else {
var statearr_62251_62315 = state_62245__$1;
(statearr_62251_62315[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (13))){
var state_62245__$1 = state_62245;
var statearr_62252_62316 = state_62245__$1;
(statearr_62252_62316[(2)] = null);

(statearr_62252_62316[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (6))){
var state_62245__$1 = state_62245;
var statearr_62253_62317 = state_62245__$1;
(statearr_62253_62317[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_62253_62317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (3))){
var state_62245__$1 = state_62245;
var statearr_62254_62318 = state_62245__$1;
(statearr_62254_62318[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_62254_62318[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (12))){
var inst_62235 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_62236 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62237 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_62238 = cljs.core.PersistentHashMap.fromArrays(inst_62236,inst_62237);
var inst_62239 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_62238);
var inst_62240 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_62239);
var state_62245__$1 = (function (){var statearr_62255 = state_62245;
(statearr_62255[(10)] = inst_62235);

return statearr_62255;
})();
var statearr_62256_62319 = state_62245__$1;
(statearr_62256_62319[(2)] = inst_62240);

(statearr_62256_62319[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (2))){
var inst_62209 = (state_62245[(9)]);
var inst_62217 = (state_62245[(7)]);
var inst_62215 = (state_62245[(2)]);
var inst_62216 = cljs.core.nth.call(null,inst_62215,(0),null);
var inst_62217__$1 = cljs.core.nth.call(null,inst_62215,(1),null);
var inst_62218 = cljs.core._EQ_.call(null,inst_62217__$1,inst_62209);
var state_62245__$1 = (function (){var statearr_62257 = state_62245;
(statearr_62257[(11)] = inst_62216);

(statearr_62257[(7)] = inst_62217__$1);

return statearr_62257;
})();
if(inst_62218){
var statearr_62258_62320 = state_62245__$1;
(statearr_62258_62320[(1)] = (3));

} else {
var statearr_62259_62321 = state_62245__$1;
(statearr_62259_62321[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (11))){
var inst_62228 = (state_62245[(2)]);
var state_62245__$1 = state_62245;
var statearr_62260_62322 = state_62245__$1;
(statearr_62260_62322[(2)] = inst_62228);

(statearr_62260_62322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (9))){
var inst_62216 = (state_62245[(11)]);
var state_62245__$1 = state_62245;
var statearr_62261_62323 = state_62245__$1;
(statearr_62261_62323[(2)] = inst_62216);

(statearr_62261_62323[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (5))){
var inst_62232 = (state_62245[(2)]);
var inst_62233 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_62232);
var state_62245__$1 = state_62245;
if(inst_62233){
var statearr_62262_62324 = state_62245__$1;
(statearr_62262_62324[(1)] = (12));

} else {
var statearr_62263_62325 = state_62245__$1;
(statearr_62263_62325[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (14))){
var inst_62243 = (state_62245[(2)]);
var state_62245__$1 = state_62245;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62245__$1,inst_62243);
} else {
if((state_val_62246 === (10))){
var state_62245__$1 = state_62245;
var statearr_62264_62326 = state_62245__$1;
(statearr_62264_62326[(2)] = null);

(statearr_62264_62326[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62246 === (8))){
var inst_62230 = (state_62245[(2)]);
var state_62245__$1 = state_62245;
var statearr_62265_62327 = state_62245__$1;
(statearr_62265_62327[(2)] = inst_62230);

(statearr_62265_62327[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0 = (function (){
var statearr_62266 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62266[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__);

(statearr_62266[(1)] = (1));

return statearr_62266;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1 = (function (state_62245){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62245);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62267){var ex__2729__auto__ = e62267;
var statearr_62268_62328 = state_62245;
(statearr_62268_62328[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62245[(4)]))){
var statearr_62269_62329 = state_62245;
(statearr_62269_62329[(1)] = cljs.core.first.call(null,(state_62245[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62330 = state_62245;
state_62245 = G__62330;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__ = function(state_62245){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1.call(this,state_62245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_62270 = f__2749__auto__.call(null);
(statearr_62270[(6)] = c__2748__auto__);

return statearr_62270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_62374){
var state_val_62375 = (state_62374[(1)]);
if((state_val_62375 === (7))){
var state_62374__$1 = state_62374;
var statearr_62376_62402 = state_62374__$1;
(statearr_62376_62402[(2)] = null);

(statearr_62376_62402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (1))){
var state_62374__$1 = state_62374;
var statearr_62377_62403 = state_62374__$1;
(statearr_62377_62403[(2)] = null);

(statearr_62377_62403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (4))){
var inst_62331 = (state_62374[(2)]);
var state_62374__$1 = state_62374;
var statearr_62378_62404 = state_62374__$1;
(statearr_62378_62404[(2)] = inst_62331);

(statearr_62378_62404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (6))){
var inst_62353 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_62374__$1 = state_62374;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62374__$1,(9),inst_62353);
} else {
if((state_val_62375 === (3))){
var inst_62372 = (state_62374[(2)]);
var state_62374__$1 = state_62374;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62374__$1,inst_62372);
} else {
if((state_val_62375 === (12))){
var inst_62366 = (state_62374[(2)]);
var state_62374__$1 = state_62374;
var statearr_62379_62405 = state_62374__$1;
(statearr_62379_62405[(2)] = inst_62366);

(statearr_62379_62405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (2))){
var inst_62337 = (state_62374[(7)]);
var inst_62342 = (state_62374[(8)]);
var inst_62347 = (state_62374[(9)]);
var _ = (function (){var statearr_62380 = state_62374;
(statearr_62380[(4)] = cljs.core.cons.call(null,(5),(state_62374[(4)])));

return statearr_62380;
})();
var inst_62337__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_62338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62339 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_62340 = (new cljs.core.PersistentVector(null,2,(5),inst_62338,inst_62339,null));
var inst_62341 = (function (){var lock_id = inst_62337__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_62342__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_62340,inst_62341);
var inst_62343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62344 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_62345 = (new cljs.core.PersistentVector(null,3,(5),inst_62343,inst_62344,null));
var inst_62346 = cljs.core.get_in.call(null,inst_62342__$1,inst_62345);
var inst_62347__$1 = cljs.core._EQ_.call(null,inst_62337__$1,inst_62346);
var inst_62348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62349 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62350 = (new cljs.core.PersistentVector(null,3,(5),inst_62348,inst_62349,null));
var inst_62351 = cljs.core.get_in.call(null,inst_62342__$1,inst_62350);
var state_62374__$1 = (function (){var statearr_62381 = state_62374;
(statearr_62381[(10)] = inst_62351);

(statearr_62381[(7)] = inst_62337__$1);

(statearr_62381[(8)] = inst_62342__$1);

(statearr_62381[(9)] = inst_62347__$1);

return statearr_62381;
})();
if(inst_62347__$1){
var statearr_62382_62406 = state_62374__$1;
(statearr_62382_62406[(1)] = (6));

} else {
var statearr_62383_62407 = state_62374__$1;
(statearr_62383_62407[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (11))){
var inst_62357 = (state_62374[(11)]);
var inst_62351 = (state_62374[(10)]);
var inst_62358 = (state_62374[(12)]);
var inst_62364 = fluree.db.util.xhttp.try_socket.call(null,inst_62357,sub_chan,pub_chan,inst_62351,(60000),inst_62358);
var state_62374__$1 = state_62374;
var statearr_62385_62408 = state_62374__$1;
(statearr_62385_62408[(2)] = inst_62364);

(statearr_62385_62408[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (9))){
var inst_62357 = (state_62374[(11)]);
var inst_62351 = (state_62374[(10)]);
var inst_62337 = (state_62374[(7)]);
var inst_62355 = (state_62374[(13)]);
var inst_62342 = (state_62374[(8)]);
var inst_62347 = (state_62374[(9)]);
var inst_62355__$1 = (state_62374[(2)]);
var inst_62356 = clojure.string.replace.call(null,inst_62355__$1,"http","ws");
var inst_62357__$1 = [inst_62356,"/fdb/ws"].join('');
var inst_62358 = (function (){var lock_id = inst_62337;
var state = inst_62342;
var have_lock_QMARK_ = inst_62347;
var resp_chan = inst_62351;
var healthy_server = inst_62355__$1;
var ws_url = inst_62357__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_62359 = fluree.db.util.core.exception_QMARK_.call(null,inst_62355__$1);
var state_62374__$1 = (function (){var statearr_62386 = state_62374;
(statearr_62386[(11)] = inst_62357__$1);

(statearr_62386[(13)] = inst_62355__$1);

(statearr_62386[(12)] = inst_62358);

return statearr_62386;
})();
if(inst_62359){
var statearr_62387_62409 = state_62374__$1;
(statearr_62387_62409[(1)] = (10));

} else {
var statearr_62388_62410 = state_62374__$1;
(statearr_62388_62410[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (5))){
var _ = (function (){var statearr_62389 = state_62374;
(statearr_62389[(4)] = cljs.core.rest.call(null,(state_62374[(4)])));

return statearr_62389;
})();
var state_62374__$1 = state_62374;
var ex62384 = (state_62374__$1[(2)]);
var statearr_62390_62411 = state_62374__$1;
(statearr_62390_62411[(5)] = ex62384);


if((ex62384 instanceof Error)){
var statearr_62391_62412 = state_62374__$1;
(statearr_62391_62412[(1)] = (4));

(statearr_62391_62412[(5)] = null);

} else {
throw ex62384;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (10))){
var inst_62351 = (state_62374[(10)]);
var inst_62355 = (state_62374[(13)]);
var inst_62361 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_62362 = cljs.core.async.put_BANG_.call(null,inst_62351,inst_62355);
var state_62374__$1 = (function (){var statearr_62392 = state_62374;
(statearr_62392[(14)] = inst_62361);

return statearr_62392;
})();
var statearr_62393_62413 = state_62374__$1;
(statearr_62393_62413[(2)] = inst_62362);

(statearr_62393_62413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (8))){
var inst_62351 = (state_62374[(10)]);
var inst_62369 = (state_62374[(2)]);
var _ = (function (){var statearr_62394 = state_62374;
(statearr_62394[(4)] = cljs.core.rest.call(null,(state_62374[(4)])));

return statearr_62394;
})();
var state_62374__$1 = (function (){var statearr_62395 = state_62374;
(statearr_62395[(15)] = inst_62369);

return statearr_62395;
})();
var statearr_62396_62414 = state_62374__$1;
(statearr_62396_62414[(2)] = inst_62351);

(statearr_62396_62414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2726__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2726__auto____0 = (function (){
var statearr_62397 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62397[(0)] = fluree$db$connection$establish_socket_$_state_machine__2726__auto__);

(statearr_62397[(1)] = (1));

return statearr_62397;
});
var fluree$db$connection$establish_socket_$_state_machine__2726__auto____1 = (function (state_62374){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62374);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62398){var ex__2729__auto__ = e62398;
var statearr_62399_62415 = state_62374;
(statearr_62399_62415[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62374[(4)]))){
var statearr_62400_62416 = state_62374;
(statearr_62400_62416[(1)] = cljs.core.first.call(null,(state_62374[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62417 = state_62374;
state_62374 = G__62417;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2726__auto__ = function(state_62374){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2726__auto____1.call(this,state_62374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2726__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2726__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_62401 = f__2749__auto__.call(null);
(statearr_62401[(6)] = c__2748__auto__);

return statearr_62401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k62419,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__62423 = k62419;
var G__62423__$1 = (((G__62423 instanceof cljs.core.Keyword))?G__62423.fqn:null);
switch (G__62423__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k62419,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4495__auto__,p__62424){
var vec__62425 = p__62424;
var k__4496__auto__ = cljs.core.nth.call(null,vec__62425,(0),null);
var v__4497__auto__ = cljs.core.nth.call(null,vec__62425,(1),null);
return f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__);
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__62418){
var self__ = this;
var G__62418__$1 = this;
return (new cljs.core.RecordIter((0),G__62418__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4469__auto__));
}).call(null,this__4468__auto____$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this62420,other62421){
var self__ = this;
var this62420__$1 = this;
return (((!((other62421 == null)))) && ((((this62420__$1.constructor === other62421.constructor)) && (((cljs.core._EQ_.call(null,this62420__$1.id,other62421.id)) && (((cljs.core._EQ_.call(null,this62420__$1.servers,other62421.servers)) && (((cljs.core._EQ_.call(null,this62420__$1.state,other62421.state)) && (((cljs.core._EQ_.call(null,this62420__$1.req_chan,other62421.req_chan)) && (((cljs.core._EQ_.call(null,this62420__$1.sub_chan,other62421.sub_chan)) && (((cljs.core._EQ_.call(null,this62420__$1.pub_chan,other62421.pub_chan)) && (((cljs.core._EQ_.call(null,this62420__$1.storage_read,other62421.storage_read)) && (((cljs.core._EQ_.call(null,this62420__$1.storage_write,other62421.storage_write)) && (((cljs.core._EQ_.call(null,this62420__$1.object_cache,other62421.object_cache)) && (((cljs.core._EQ_.call(null,this62420__$1.parallelism,other62421.parallelism)) && (((cljs.core._EQ_.call(null,this62420__$1.serializer,other62421.serializer)) && (((cljs.core._EQ_.call(null,this62420__$1.default_network,other62421.default_network)) && (((cljs.core._EQ_.call(null,this62420__$1.transactor_QMARK_,other62421.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this62420__$1.publish,other62421.publish)) && (((cljs.core._EQ_.call(null,this62420__$1.transact_handler,other62421.transact_handler)) && (((cljs.core._EQ_.call(null,this62420__$1.tx_private_key,other62421.tx_private_key)) && (((cljs.core._EQ_.call(null,this62420__$1.tx_key_id,other62421.tx_key_id)) && (((cljs.core._EQ_.call(null,this62420__$1.meta,other62421.meta)) && (((cljs.core._EQ_.call(null,this62420__$1.add_listener,other62421.add_listener)) && (((cljs.core._EQ_.call(null,this62420__$1.remove_listener,other62421.remove_listener)) && (((cljs.core._EQ_.call(null,this62420__$1.close,other62421.close)) && (cljs.core._EQ_.call(null,this62420__$1.__extmap,other62421.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k62419){
var self__ = this;
var this__4479__auto____$1 = this;
var G__62428 = k62419;
var G__62428__$1 = (((G__62428 instanceof cljs.core.Keyword))?G__62428.fqn:null);
switch (G__62428__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k62419);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__62418){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__62429 = cljs.core.keyword_identical_QMARK_;
var expr__62430 = k__4481__auto__;
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__62430))){
return (new fluree.db.connection.Connection(G__62418,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,G__62418,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__62418,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__62418,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__62418,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__62418,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__62418,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__62418,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__62418,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__62418,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__62418,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__62418,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__62418,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__62418,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__62418,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__62418,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__62418,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__62418,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__62418,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__62418,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__62429.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__62430))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__62418,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4481__auto__,G__62418),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__62418){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__62418,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4478__auto__,(0)),cljs.core._nth.call(null,entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write.call(null,writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__62422){
var extmap__4512__auto__ = (function (){var G__62432 = cljs.core.dissoc.call(null,G__62422,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__62422)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__62432);
} else {
return G__62432;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__62422),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__62422),null,cljs.core.not_empty.call(null,extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__62438 = servers_STAR_;
var vec__62439 = G__62438;
var seq__62440 = cljs.core.seq.call(null,vec__62439);
var first__62441 = cljs.core.first.call(null,seq__62440);
var seq__62440__$1 = cljs.core.next.call(null,seq__62440);
var server = first__62441;
var r = seq__62440__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__62438__$1 = G__62438;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__62445 = G__62438__$1;
var seq__62446 = cljs.core.seq.call(null,vec__62445);
var first__62447 = cljs.core.first.call(null,seq__62446);
var seq__62446__$1 = cljs.core.next.call(null,seq__62446);
var server__$1 = first__62447;
var r__$1 = seq__62446__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__62448 = r__$1;
var G__62449 = is_https_QMARK_;
var G__62450 = result_STAR_;
G__62438__$1 = G__62448;
https_QMARK___$1 = G__62449;
result__$1 = G__62450;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__62451 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__62451 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__62451);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_62480){
var state_val_62481 = (state_62480[(1)]);
if((state_val_62481 === (7))){
var inst_62466 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62467 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62468 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62469 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62470 = fluree.db.connection.establish_socket.call(null,inst_62466,inst_62467,inst_62468,inst_62469);
var state_62480__$1 = state_62480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62480__$1,(9),inst_62470);
} else {
if((state_val_62481 === (1))){
var state_62480__$1 = state_62480;
var statearr_62482_62501 = state_62480__$1;
(statearr_62482_62501[(2)] = null);

(statearr_62482_62501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62481 === (4))){
var inst_62452 = (state_62480[(2)]);
var state_62480__$1 = state_62480;
var statearr_62483_62502 = state_62480__$1;
(statearr_62483_62502[(2)] = inst_62452);

(statearr_62483_62502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62481 === (6))){
var inst_62463 = (state_62480[(7)]);
var state_62480__$1 = state_62480;
var statearr_62484_62503 = state_62480__$1;
(statearr_62484_62503[(2)] = inst_62463);

(statearr_62484_62503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62481 === (3))){
var inst_62478 = (state_62480[(2)]);
var state_62480__$1 = state_62480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62480__$1,inst_62478);
} else {
if((state_val_62481 === (2))){
var inst_62463 = (state_62480[(7)]);
var _ = (function (){var statearr_62486 = state_62480;
(statearr_62486[(4)] = cljs.core.cons.call(null,(5),(state_62480[(4)])));

return statearr_62486;
})();
var inst_62458 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_62459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62460 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62461 = [inst_62460,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_62462 = (new cljs.core.PersistentVector(null,3,(5),inst_62459,inst_62461,null));
var inst_62463__$1 = cljs.core.get_in.call(null,inst_62458,inst_62462);
var state_62480__$1 = (function (){var statearr_62487 = state_62480;
(statearr_62487[(7)] = inst_62463__$1);

return statearr_62487;
})();
if(cljs.core.truth_(inst_62463__$1)){
var statearr_62488_62504 = state_62480__$1;
(statearr_62488_62504[(1)] = (6));

} else {
var statearr_62489_62505 = state_62480__$1;
(statearr_62489_62505[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62481 === (9))){
var inst_62472 = (state_62480[(2)]);
var inst_62473 = fluree.db.util.async.throw_err.call(null,inst_62472);
var state_62480__$1 = state_62480;
var statearr_62490_62506 = state_62480__$1;
(statearr_62490_62506[(2)] = inst_62473);

(statearr_62490_62506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62481 === (5))){
var _ = (function (){var statearr_62491 = state_62480;
(statearr_62491[(4)] = cljs.core.rest.call(null,(state_62480[(4)])));

return statearr_62491;
})();
var state_62480__$1 = state_62480;
var ex62485 = (state_62480__$1[(2)]);
var statearr_62492_62507 = state_62480__$1;
(statearr_62492_62507[(5)] = ex62485);


if((ex62485 instanceof Error)){
var statearr_62493_62508 = state_62480__$1;
(statearr_62493_62508[(1)] = (4));

(statearr_62493_62508[(5)] = null);

} else {
throw ex62485;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62481 === (8))){
var inst_62475 = (state_62480[(2)]);
var _ = (function (){var statearr_62494 = state_62480;
(statearr_62494[(4)] = cljs.core.rest.call(null,(state_62480[(4)])));

return statearr_62494;
})();
var state_62480__$1 = state_62480;
var statearr_62495_62509 = state_62480__$1;
(statearr_62495_62509[(2)] = inst_62475);

(statearr_62495_62509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2726__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2726__auto____0 = (function (){
var statearr_62496 = [null,null,null,null,null,null,null,null];
(statearr_62496[(0)] = fluree$db$connection$get_socket_$_state_machine__2726__auto__);

(statearr_62496[(1)] = (1));

return statearr_62496;
});
var fluree$db$connection$get_socket_$_state_machine__2726__auto____1 = (function (state_62480){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62497){var ex__2729__auto__ = e62497;
var statearr_62498_62510 = state_62480;
(statearr_62498_62510[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62480[(4)]))){
var statearr_62499_62511 = state_62480;
(statearr_62499_62511[(1)] = cljs.core.first.call(null,(state_62480[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62512 = state_62480;
state_62480 = G__62512;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2726__auto__ = function(state_62480){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2726__auto____1.call(this,state_62480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2726__auto____0;
fluree$db$connection$get_socket_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2726__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_62500 = f__2749__auto__.call(null);
(statearr_62500[(6)] = c__2748__auto__);

return statearr_62500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e62513){var e = e62513;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_62640){
var state_val_62641 = (state_62640[(1)]);
if((state_val_62641 === (7))){
var inst_62636 = (state_62640[(2)]);
var state_62640__$1 = state_62640;
var statearr_62643_62713 = state_62640__$1;
(statearr_62643_62713[(2)] = inst_62636);

(statearr_62643_62713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (20))){
var _ = (function (){var statearr_62644 = state_62640;
(statearr_62644[(4)] = cljs.core.rest.call(null,(state_62640[(4)])));

return statearr_62644;
})();
var state_62640__$1 = state_62640;
var ex62642 = (state_62640__$1[(2)]);
var statearr_62645_62714 = state_62640__$1;
(statearr_62645_62714[(5)] = ex62642);


var statearr_62646_62715 = state_62640__$1;
(statearr_62646_62715[(1)] = (10));

(statearr_62646_62715[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (27))){
var inst_62628 = (state_62640[(2)]);
var _ = (function (){var statearr_62647 = state_62640;
(statearr_62647[(4)] = cljs.core.rest.call(null,(state_62640[(4)])));

return statearr_62647;
})();
var state_62640__$1 = state_62640;
var statearr_62648_62716 = state_62640__$1;
(statearr_62648_62716[(2)] = inst_62628);

(statearr_62648_62716[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (1))){
var inst_62515 = (0);
var state_62640__$1 = (function (){var statearr_62649 = state_62640;
(statearr_62649[(7)] = inst_62515);

return statearr_62649;
})();
var statearr_62650_62717 = state_62640__$1;
(statearr_62650_62717[(2)] = null);

(statearr_62650_62717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (24))){
var inst_62606 = (state_62640[(8)]);
var inst_62606__$1 = (state_62640[(2)]);
var inst_62607 = inst_62606__$1 === true;
var state_62640__$1 = (function (){var statearr_62651 = state_62640;
(statearr_62651[(8)] = inst_62606__$1);

return statearr_62651;
})();
if(cljs.core.truth_(inst_62607)){
var statearr_62652_62718 = state_62640__$1;
(statearr_62652_62718[(1)] = (25));

} else {
var statearr_62653_62719 = state_62640__$1;
(statearr_62653_62719[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (4))){
var inst_62518 = (state_62640[(9)]);
var inst_62518__$1 = (state_62640[(2)]);
var state_62640__$1 = (function (){var statearr_62654 = state_62640;
(statearr_62654[(9)] = inst_62518__$1);

return statearr_62654;
})();
if(cljs.core.truth_(inst_62518__$1)){
var statearr_62655_62720 = state_62640__$1;
(statearr_62655_62720[(1)] = (5));

} else {
var statearr_62656_62721 = state_62640__$1;
(statearr_62656_62721[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (15))){
var inst_62531 = (state_62640[(10)]);
var state_62640__$1 = state_62640;
var statearr_62657_62722 = state_62640__$1;
(statearr_62657_62722[(2)] = inst_62531);

(statearr_62657_62722[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (21))){
var inst_62515 = (state_62640[(7)]);
var inst_62558 = (state_62640[(11)]);
var inst_62562 = (state_62640[(12)]);
var inst_62518 = (state_62640[(9)]);
var inst_62563 = (state_62640[(13)]);
var inst_62554 = (state_62640[(14)]);
var inst_62559 = (state_62640[(15)]);
var inst_62555 = (state_62640[(16)]);
var inst_62557 = (state_62640[(17)]);
var inst_62556 = (state_62640[(18)]);
var inst_62565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62566 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62562];
var inst_62567 = (new cljs.core.PersistentVector(null,2,(5),inst_62565,inst_62566,null));
var inst_62568 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_62567,inst_62557);
var inst_62595 = cljs.core.async.chan.call(null,(1));
var inst_62596 = (function (){var resp_chan = inst_62557;
var c__2748__auto____$1 = inst_62595;
var timeout = inst_62563;
var i = inst_62515;
var data = inst_62556;
var vec__62550 = inst_62518;
var _ = inst_62554;
var req_id = inst_62562;
var operation = inst_62555;
var msg = inst_62518;
var map__62553 = inst_62559;
var opts = inst_62558;
return (function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_62593){
var state_val_62594 = (state_62593[(1)]);
if((state_val_62594 === (1))){
var inst_62572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62573 = cljs.core.async.timeout.call(null,timeout);
var inst_62574 = [resp_chan,inst_62573];
var inst_62575 = (new cljs.core.PersistentVector(null,2,(5),inst_62572,inst_62574,null));
var state_62593__$1 = state_62593;
return cljs.core.async.ioc_alts_BANG_.call(null,state_62593__$1,(2),inst_62575);
} else {
if((state_val_62594 === (2))){
var inst_62578 = (state_62593[(7)]);
var inst_62577 = (state_62593[(2)]);
var inst_62578__$1 = cljs.core.nth.call(null,inst_62577,(0),null);
var inst_62579 = cljs.core.nth.call(null,inst_62577,(1),null);
var inst_62580 = (function (){var vec__62569 = inst_62577;
var resp = inst_62578__$1;
var c = inst_62579;
return (function (p1__62514_SHARP_){
return cljs.core.dissoc.call(null,p1__62514_SHARP_,req_id);
});
})();
var inst_62581 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_62580);
var inst_62582 = cljs.core._EQ_.call(null,inst_62579,resp_chan);
var state_62593__$1 = (function (){var statearr_62658 = state_62593;
(statearr_62658[(8)] = inst_62581);

(statearr_62658[(7)] = inst_62578__$1);

return statearr_62658;
})();
if(inst_62582){
var statearr_62659_62723 = state_62593__$1;
(statearr_62659_62723[(1)] = (3));

} else {
var statearr_62660_62724 = state_62593__$1;
(statearr_62660_62724[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62594 === (3))){
var inst_62578 = (state_62593[(7)]);
var state_62593__$1 = state_62593;
var statearr_62661_62725 = state_62593__$1;
(statearr_62661_62725[(2)] = inst_62578);

(statearr_62661_62725[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62594 === (4))){
var inst_62585 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_62586 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62587 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_62588 = cljs.core.PersistentHashMap.fromArrays(inst_62586,inst_62587);
var inst_62589 = cljs.core.ex_info.call(null,inst_62585,inst_62588);
var state_62593__$1 = state_62593;
var statearr_62662_62726 = state_62593__$1;
(statearr_62662_62726[(2)] = inst_62589);

(statearr_62662_62726[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62594 === (5))){
var inst_62591 = (state_62593[(2)]);
var state_62593__$1 = state_62593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62593__$1,inst_62591);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2726__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2726__auto____0 = (function (){
var statearr_62663 = [null,null,null,null,null,null,null,null,null];
(statearr_62663[(0)] = fluree$db$connection$msg_producer_$_state_machine__2726__auto__);

(statearr_62663[(1)] = (1));

return statearr_62663;
});
var fluree$db$connection$msg_producer_$_state_machine__2726__auto____1 = (function (state_62593){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62664){var ex__2729__auto__ = e62664;
var statearr_62665_62727 = state_62593;
(statearr_62665_62727[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62593[(4)]))){
var statearr_62666_62728 = state_62593;
(statearr_62666_62728[(1)] = cljs.core.first.call(null,(state_62593[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62729 = state_62593;
state_62593 = G__62729;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2726__auto__ = function(state_62593){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2726__auto____1.call(this,state_62593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2726__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2726__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_62667 = f__2749__auto__.call(null);
(statearr_62667[(6)] = c__2748__auto____$1);

return statearr_62667;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
});
})();
var inst_62597 = cljs.core.async.impl.dispatch.run.call(null,inst_62596);
var state_62640__$1 = (function (){var statearr_62668 = state_62640;
(statearr_62668[(19)] = inst_62597);

(statearr_62668[(20)] = inst_62568);

return statearr_62668;
})();
var statearr_62669_62730 = state_62640__$1;
(statearr_62669_62730[(2)] = inst_62595);

(statearr_62669_62730[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (31))){
var inst_62616 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_62640__$1 = state_62640;
var statearr_62670_62731 = state_62640__$1;
(statearr_62670_62731[(2)] = inst_62616);

(statearr_62670_62731[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (32))){
var state_62640__$1 = state_62640;
var statearr_62671_62732 = state_62640__$1;
(statearr_62671_62732[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (33))){
var inst_62624 = (state_62640[(2)]);
var state_62640__$1 = state_62640;
var statearr_62673_62733 = state_62640__$1;
(statearr_62673_62733[(2)] = inst_62624);

(statearr_62673_62733[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (13))){
var inst_62531 = (state_62640[(10)]);
var inst_62528 = (state_62640[(2)]);
var inst_62529 = cljs.core.nth.call(null,inst_62528,(0),null);
var inst_62530 = cljs.core.nth.call(null,inst_62528,(1),null);
var inst_62531__$1 = cljs.core.nth.call(null,inst_62528,(2),null);
var state_62640__$1 = (function (){var statearr_62674 = state_62640;
(statearr_62674[(21)] = inst_62529);

(statearr_62674[(10)] = inst_62531__$1);

(statearr_62674[(22)] = inst_62530);

return statearr_62674;
})();
if(cljs.core.truth_(inst_62531__$1)){
var statearr_62675_62734 = state_62640__$1;
(statearr_62675_62734[(1)] = (14));

} else {
var statearr_62676_62735 = state_62640__$1;
(statearr_62676_62735[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (22))){
var state_62640__$1 = state_62640;
var statearr_62677_62736 = state_62640__$1;
(statearr_62677_62736[(2)] = null);

(statearr_62677_62736[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (36))){
var inst_62622 = (state_62640[(2)]);
var state_62640__$1 = state_62640;
var statearr_62678_62737 = state_62640__$1;
(statearr_62678_62737[(2)] = inst_62622);

(statearr_62678_62737[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (29))){
var inst_62606 = (state_62640[(8)]);
var inst_62614 = (inst_62606 == null);
var state_62640__$1 = state_62640;
if(cljs.core.truth_(inst_62614)){
var statearr_62679_62738 = state_62640__$1;
(statearr_62679_62738[(1)] = (31));

} else {
var statearr_62680_62739 = state_62640__$1;
(statearr_62680_62739[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (6))){
var state_62640__$1 = state_62640;
var statearr_62681_62740 = state_62640__$1;
(statearr_62681_62740[(2)] = null);

(statearr_62681_62740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (28))){
var inst_62606 = (state_62640[(8)]);
var inst_62612 = fluree.db.util.log.error.call(null,inst_62606,"Error processing message in producer.");
var state_62640__$1 = state_62640;
var statearr_62682_62741 = state_62640__$1;
(statearr_62682_62741[(2)] = inst_62612);

(statearr_62682_62741[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (25))){
var state_62640__$1 = state_62640;
var statearr_62683_62742 = state_62640__$1;
(statearr_62683_62742[(2)] = null);

(statearr_62683_62742[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (34))){
var inst_62606 = (state_62640[(8)]);
var inst_62619 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_62606);
var state_62640__$1 = state_62640;
var statearr_62684_62743 = state_62640__$1;
(statearr_62684_62743[(2)] = inst_62619);

(statearr_62684_62743[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (17))){
var inst_62531 = (state_62640[(10)]);
var inst_62520 = (state_62640[(23)]);
var inst_62538 = cljs.core.async.put_BANG_.call(null,inst_62531,inst_62520);
var state_62640__$1 = state_62640;
var statearr_62685_62744 = state_62640__$1;
(statearr_62685_62744[(2)] = inst_62538);

(statearr_62685_62744[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (3))){
var inst_62638 = (state_62640[(2)]);
var state_62640__$1 = state_62640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62640__$1,inst_62638);
} else {
if((state_val_62641 === (12))){
var state_62640__$1 = state_62640;
var statearr_62686_62745 = state_62640__$1;
(statearr_62686_62745[(2)] = null);

(statearr_62686_62745[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (2))){
var state_62640__$1 = state_62640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62640__$1,(4),req_chan);
} else {
if((state_val_62641 === (23))){
var inst_62562 = (state_62640[(12)]);
var inst_62555 = (state_62640[(16)]);
var inst_62556 = (state_62640[(18)]);
var inst_62600 = (state_62640[(2)]);
var inst_62601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62602 = [inst_62555,inst_62562,inst_62556];
var inst_62603 = (new cljs.core.PersistentVector(null,3,(5),inst_62601,inst_62602,null));
var inst_62604 = publish_fn.call(null,conn,inst_62603);
var state_62640__$1 = (function (){var statearr_62687 = state_62640;
(statearr_62687[(24)] = inst_62600);

return statearr_62687;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62640__$1,(24),inst_62604);
} else {
if((state_val_62641 === (35))){
var state_62640__$1 = state_62640;
var statearr_62688_62746 = state_62640__$1;
(statearr_62688_62746[(2)] = null);

(statearr_62688_62746[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (19))){
var inst_62544 = (state_62640[(2)]);
var state_62640__$1 = state_62640;
var statearr_62689_62747 = state_62640__$1;
(statearr_62689_62747[(2)] = inst_62544);

(statearr_62689_62747[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (11))){
var inst_62518 = (state_62640[(9)]);
var state_62640__$1 = state_62640;
var statearr_62690_62748 = state_62640__$1;
(statearr_62690_62748[(2)] = inst_62518);

(statearr_62690_62748[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (9))){
var inst_62515 = (state_62640[(7)]);
var inst_62631 = (state_62640[(2)]);
var inst_62632 = (inst_62515 + (1));
var inst_62515__$1 = inst_62632;
var state_62640__$1 = (function (){var statearr_62691 = state_62640;
(statearr_62691[(7)] = inst_62515__$1);

(statearr_62691[(25)] = inst_62631);

return statearr_62691;
})();
var statearr_62692_62749 = state_62640__$1;
(statearr_62692_62749[(2)] = null);

(statearr_62692_62749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (5))){
var state_62640__$1 = state_62640;
var statearr_62693_62750 = state_62640__$1;
(statearr_62693_62750[(2)] = null);

(statearr_62693_62750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (14))){
var inst_62531 = (state_62640[(10)]);
var inst_62533 = fluree.db.util.async.channel_QMARK_.call(null,inst_62531);
var state_62640__$1 = state_62640;
var statearr_62694_62751 = state_62640__$1;
(statearr_62694_62751[(2)] = inst_62533);

(statearr_62694_62751[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (26))){
var inst_62606 = (state_62640[(8)]);
var inst_62610 = fluree.db.util.core.exception_QMARK_.call(null,inst_62606);
var state_62640__$1 = state_62640;
if(inst_62610){
var statearr_62695_62752 = state_62640__$1;
(statearr_62695_62752[(1)] = (28));

} else {
var statearr_62696_62753 = state_62640__$1;
(statearr_62696_62753[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (16))){
var inst_62536 = (state_62640[(2)]);
var state_62640__$1 = state_62640;
if(cljs.core.truth_(inst_62536)){
var statearr_62697_62754 = state_62640__$1;
(statearr_62697_62754[(1)] = (17));

} else {
var statearr_62698_62755 = state_62640__$1;
(statearr_62698_62755[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (30))){
var inst_62626 = (state_62640[(2)]);
var state_62640__$1 = state_62640;
var statearr_62699_62756 = state_62640__$1;
(statearr_62699_62756[(2)] = inst_62626);

(statearr_62699_62756[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (10))){
var inst_62518 = (state_62640[(9)]);
var inst_62520 = (state_62640[(2)]);
var inst_62524 = cljs.core.sequential_QMARK_.call(null,inst_62518);
var state_62640__$1 = (function (){var statearr_62700 = state_62640;
(statearr_62700[(23)] = inst_62520);

return statearr_62700;
})();
if(inst_62524){
var statearr_62701_62757 = state_62640__$1;
(statearr_62701_62757[(1)] = (11));

} else {
var statearr_62702_62758 = state_62640__$1;
(statearr_62702_62758[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (18))){
var inst_62518 = (state_62640[(9)]);
var inst_62520 = (state_62640[(23)]);
var inst_62540 = cljs.core.pr_str.call(null,inst_62518);
var inst_62541 = ["Error processing ledger request, no valid return channel: ",inst_62540].join('');
var inst_62542 = fluree.db.util.log.error.call(null,inst_62520,inst_62541);
var state_62640__$1 = state_62640;
var statearr_62703_62759 = state_62640__$1;
(statearr_62703_62759[(2)] = inst_62542);

(statearr_62703_62759[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62641 === (8))){
var inst_62558 = (state_62640[(11)]);
var inst_62518 = (state_62640[(9)]);
var inst_62559 = (state_62640[(15)]);
var inst_62557 = (state_62640[(17)]);
var _ = (function (){var statearr_62704 = state_62640;
(statearr_62704[(4)] = cljs.core.cons.call(null,(20),(state_62640[(4)])));

return statearr_62704;
})();
var inst_62554 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_62518);
var inst_62555 = cljs.core.nth.call(null,inst_62518,(0),null);
var inst_62556 = cljs.core.nth.call(null,inst_62518,(1),null);
var inst_62557__$1 = cljs.core.nth.call(null,inst_62518,(2),null);
var inst_62558__$1 = cljs.core.nth.call(null,inst_62518,(3),null);
var inst_62559__$1 = cljs.core.__destructure_map.call(null,inst_62558__$1);
var inst_62560 = fluree.db.util.core.random_uuid.call(null);
var inst_62561 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62560);
var inst_62562 = cljs.core.get.call(null,inst_62559__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_62561);
var inst_62563 = cljs.core.get.call(null,inst_62559__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62640__$1 = (function (){var statearr_62705 = state_62640;
(statearr_62705[(11)] = inst_62558__$1);

(statearr_62705[(12)] = inst_62562);

(statearr_62705[(13)] = inst_62563);

(statearr_62705[(14)] = inst_62554);

(statearr_62705[(15)] = inst_62559__$1);

(statearr_62705[(16)] = inst_62555);

(statearr_62705[(17)] = inst_62557__$1);

(statearr_62705[(18)] = inst_62556);

return statearr_62705;
})();
if(cljs.core.truth_(inst_62557__$1)){
var statearr_62706_62760 = state_62640__$1;
(statearr_62706_62760[(1)] = (21));

} else {
var statearr_62707_62761 = state_62640__$1;
(statearr_62707_62761[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2726__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2726__auto____0 = (function (){
var statearr_62708 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62708[(0)] = fluree$db$connection$msg_producer_$_state_machine__2726__auto__);

(statearr_62708[(1)] = (1));

return statearr_62708;
});
var fluree$db$connection$msg_producer_$_state_machine__2726__auto____1 = (function (state_62640){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62709){var ex__2729__auto__ = e62709;
var statearr_62710_62762 = state_62640;
(statearr_62710_62762[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62640[(4)]))){
var statearr_62711_62763 = state_62640;
(statearr_62711_62763[(1)] = cljs.core.first.call(null,(state_62640[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62764 = state_62640;
state_62640 = G__62764;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2726__auto__ = function(state_62640){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2726__auto____1.call(this,state_62640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2726__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2726__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_62712 = f__2749__auto__.call(null);
(statearr_62712[(6)] = c__2748__auto__);

return statearr_62712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62765 = conn;
var map__62765__$1 = cljs.core.__destructure_map.call(null,map__62765);
var sub_chan = cljs.core.get.call(null,map__62765__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_62847){
var state_val_62848 = (state_62847[(1)]);
if((state_val_62848 === (7))){
var inst_62843 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62849_62900 = state_62847__$1;
(statearr_62849_62900[(2)] = inst_62843);

(statearr_62849_62900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (20))){
var inst_62784 = (state_62847[(7)]);
var inst_62798 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62799 = [inst_62784];
var inst_62800 = cljs.core.PersistentHashMap.fromArrays(inst_62798,inst_62799);
var inst_62801 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_62800);
var state_62847__$1 = state_62847;
var statearr_62850_62901 = state_62847__$1;
(statearr_62850_62901[(2)] = inst_62801);

(statearr_62850_62901[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (27))){
var state_62847__$1 = state_62847;
var statearr_62851_62902 = state_62847__$1;
(statearr_62851_62902[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (1))){
var inst_62766 = (0);
var state_62847__$1 = (function (){var statearr_62853 = state_62847;
(statearr_62853[(8)] = inst_62766);

return statearr_62853;
})();
var statearr_62854_62903 = state_62847__$1;
(statearr_62854_62903[(2)] = null);

(statearr_62854_62903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (24))){
var inst_62777 = (state_62847[(9)]);
var inst_62826 = fluree.db.util.core.exception_QMARK_.call(null,inst_62777);
var state_62847__$1 = state_62847;
if(inst_62826){
var statearr_62855_62904 = state_62847__$1;
(statearr_62855_62904[(1)] = (26));

} else {
var statearr_62856_62905 = state_62847__$1;
(statearr_62856_62905[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (4))){
var inst_62771 = (state_62847[(10)]);
var inst_62776 = (state_62847[(2)]);
var inst_62777 = cljs.core.nth.call(null,inst_62776,(0),null);
var inst_62778 = cljs.core.nth.call(null,inst_62776,(1),null);
var inst_62779 = cljs.core._EQ_.call(null,inst_62778,inst_62771);
var state_62847__$1 = (function (){var statearr_62857 = state_62847;
(statearr_62857[(9)] = inst_62777);

return statearr_62857;
})();
if(inst_62779){
var statearr_62858_62906 = state_62847__$1;
(statearr_62858_62906[(1)] = (5));

} else {
var statearr_62859_62907 = state_62847__$1;
(statearr_62859_62907[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (15))){
var inst_62784 = (state_62847[(7)]);
var inst_62793 = typeof inst_62784 === 'string';
var state_62847__$1 = state_62847;
if(cljs.core.truth_(inst_62793)){
var statearr_62860_62908 = state_62847__$1;
(statearr_62860_62908[(1)] = (17));

} else {
var statearr_62861_62909 = state_62847__$1;
(statearr_62861_62909[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (21))){
var state_62847__$1 = state_62847;
var statearr_62862_62910 = state_62847__$1;
(statearr_62862_62910[(2)] = null);

(statearr_62862_62910[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (31))){
var inst_62837 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62863_62911 = state_62847__$1;
(statearr_62863_62911[(2)] = inst_62837);

(statearr_62863_62911[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (13))){
var inst_62810 = (state_62847[(2)]);
var inst_62811 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62812 = fluree.db.connection.close_websocket.call(null,inst_62811);
var inst_62813 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62814 = fluree.db.session.close_all_sessions.call(null,inst_62813);
var state_62847__$1 = (function (){var statearr_62864 = state_62847;
(statearr_62864[(11)] = inst_62810);

(statearr_62864[(12)] = inst_62812);

return statearr_62864;
})();
var statearr_62865_62912 = state_62847__$1;
(statearr_62865_62912[(2)] = inst_62814);

(statearr_62865_62912[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (22))){
var inst_62804 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62866_62913 = state_62847__$1;
(statearr_62866_62913[(2)] = inst_62804);

(statearr_62866_62913[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (29))){
var inst_62777 = (state_62847[(9)]);
var inst_62832 = fluree.db.util.json.parse.call(null,inst_62777);
var inst_62833 = fluree.db.conn_events.process_events.call(null,conn,inst_62832);
var inst_62766 = (0);
var state_62847__$1 = (function (){var statearr_62867 = state_62847;
(statearr_62867[(13)] = inst_62833);

(statearr_62867[(8)] = inst_62766);

return statearr_62867;
})();
var statearr_62868_62914 = state_62847__$1;
(statearr_62868_62914[(2)] = null);

(statearr_62868_62914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (6))){
var inst_62777 = (state_62847[(9)]);
var inst_62822 = (inst_62777 == null);
var state_62847__$1 = state_62847;
if(cljs.core.truth_(inst_62822)){
var statearr_62869_62915 = state_62847__$1;
(statearr_62869_62915[(1)] = (23));

} else {
var statearr_62870_62916 = state_62847__$1;
(statearr_62870_62916[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (28))){
var inst_62839 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62871_62917 = state_62847__$1;
(statearr_62871_62917[(2)] = inst_62839);

(statearr_62871_62917[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (25))){
var inst_62841 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62872_62918 = state_62847__$1;
(statearr_62872_62918[(2)] = inst_62841);

(statearr_62872_62918[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (17))){
var inst_62784 = (state_62847[(7)]);
var inst_62795 = cljs.core.eval.call(null,inst_62784);
var state_62847__$1 = state_62847;
var statearr_62873_62919 = state_62847__$1;
(statearr_62873_62919[(2)] = inst_62795);

(statearr_62873_62919[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (3))){
var inst_62845 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62847__$1,inst_62845);
} else {
if((state_val_62848 === (12))){
var inst_62784 = (state_62847[(7)]);
var inst_62789 = cljs.core.fn_QMARK_.call(null,inst_62784);
var state_62847__$1 = state_62847;
if(inst_62789){
var statearr_62874_62920 = state_62847__$1;
(statearr_62874_62920[(1)] = (14));

} else {
var statearr_62875_62921 = state_62847__$1;
(statearr_62875_62921[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (2))){
var inst_62771 = (state_62847[(10)]);
var inst_62771__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_62772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62773 = [sub_chan,inst_62771__$1];
var inst_62774 = (new cljs.core.PersistentVector(null,2,(5),inst_62772,inst_62773,null));
var state_62847__$1 = (function (){var statearr_62876 = state_62847;
(statearr_62876[(10)] = inst_62771__$1);

return statearr_62876;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62847__$1,(4),inst_62774);
} else {
if((state_val_62848 === (23))){
var inst_62824 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_62847__$1 = state_62847;
var statearr_62877_62922 = state_62847__$1;
(statearr_62877_62922[(2)] = inst_62824);

(statearr_62877_62922[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (19))){
var inst_62806 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62878_62923 = state_62847__$1;
(statearr_62878_62923[(2)] = inst_62806);

(statearr_62878_62923[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (11))){
var inst_62787 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_62847__$1 = state_62847;
var statearr_62879_62924 = state_62847__$1;
(statearr_62879_62924[(2)] = inst_62787);

(statearr_62879_62924[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (9))){
var inst_62766 = (state_62847[(8)]);
var inst_62816 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_62817 = (inst_62766 + (1));
var inst_62766__$1 = inst_62817;
var state_62847__$1 = (function (){var statearr_62880 = state_62847;
(statearr_62880[(8)] = inst_62766__$1);

(statearr_62880[(14)] = inst_62816);

return statearr_62880;
})();
var statearr_62881_62925 = state_62847__$1;
(statearr_62881_62925[(2)] = null);

(statearr_62881_62925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (5))){
var inst_62766 = (state_62847[(8)]);
var inst_62781 = cljs.core._EQ_.call(null,(2),inst_62766);
var state_62847__$1 = state_62847;
if(inst_62781){
var statearr_62882_62926 = state_62847__$1;
(statearr_62882_62926[(1)] = (8));

} else {
var statearr_62883_62927 = state_62847__$1;
(statearr_62883_62927[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (14))){
var inst_62784 = (state_62847[(7)]);
var inst_62791 = inst_62784.call(null);
var state_62847__$1 = state_62847;
var statearr_62884_62928 = state_62847__$1;
(statearr_62884_62928[(2)] = inst_62791);

(statearr_62884_62928[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (26))){
var inst_62777 = (state_62847[(9)]);
var inst_62828 = fluree.db.util.log.error.call(null,inst_62777);
var inst_62766 = (0);
var state_62847__$1 = (function (){var statearr_62885 = state_62847;
(statearr_62885[(15)] = inst_62828);

(statearr_62885[(8)] = inst_62766);

return statearr_62885;
})();
var statearr_62886_62929 = state_62847__$1;
(statearr_62886_62929[(2)] = null);

(statearr_62886_62929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (16))){
var inst_62808 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62887_62930 = state_62847__$1;
(statearr_62887_62930[(2)] = inst_62808);

(statearr_62887_62930[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (30))){
var state_62847__$1 = state_62847;
var statearr_62888_62931 = state_62847__$1;
(statearr_62888_62931[(2)] = null);

(statearr_62888_62931[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (10))){
var inst_62820 = (state_62847[(2)]);
var state_62847__$1 = state_62847;
var statearr_62889_62932 = state_62847__$1;
(statearr_62889_62932[(2)] = inst_62820);

(statearr_62889_62932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (18))){
var state_62847__$1 = state_62847;
var statearr_62890_62933 = state_62847__$1;
(statearr_62890_62933[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62848 === (8))){
var inst_62784 = (state_62847[(7)]);
var inst_62783 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_62784__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62785 = (inst_62784__$1 == null);
var state_62847__$1 = (function (){var statearr_62892 = state_62847;
(statearr_62892[(7)] = inst_62784__$1);

(statearr_62892[(16)] = inst_62783);

return statearr_62892;
})();
if(cljs.core.truth_(inst_62785)){
var statearr_62893_62934 = state_62847__$1;
(statearr_62893_62934[(1)] = (11));

} else {
var statearr_62894_62935 = state_62847__$1;
(statearr_62894_62935[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2726__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2726__auto____0 = (function (){
var statearr_62895 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62895[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2726__auto__);

(statearr_62895[(1)] = (1));

return statearr_62895;
});
var fluree$db$connection$msg_consumer_$_state_machine__2726__auto____1 = (function (state_62847){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e62896){var ex__2729__auto__ = e62896;
var statearr_62897_62936 = state_62847;
(statearr_62897_62936[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62847[(4)]))){
var statearr_62898_62937 = state_62847;
(statearr_62898_62937[(1)] = cljs.core.first.call(null,(state_62847[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62938 = state_62847;
state_62847 = G__62938;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2726__auto__ = function(state_62847){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2726__auto____1.call(this,state_62847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2726__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2726__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_62899 = f__2749__auto__.call(null);
(statearr_62899[(6)] = c__2748__auto__);

return statearr_62899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62940 = arguments.length;
switch (G__62940) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62941 = opts;
var map__62941__$1 = cljs.core.__destructure_map.call(null,map__62941);
var private$ = cljs.core.get.call(null,map__62941__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__62941__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_62993){
var state_val_62994 = (state_62993[(1)]);
if((state_val_62994 === (7))){
var inst_62951 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_62952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62953 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62954 = (new cljs.core.PersistentVector(null,2,(5),inst_62952,inst_62953,null));
var inst_62955 = cljs.core.get_in.call(null,inst_62951,inst_62954);
var state_62993__$1 = state_62993;
var statearr_62995_63026 = state_62993__$1;
(statearr_62995_63026[(2)] = inst_62955);

(statearr_62995_63026[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (1))){
var state_62993__$1 = state_62993;
var statearr_62996_63027 = state_62993__$1;
(statearr_62996_63027[(2)] = null);

(statearr_62996_63027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (4))){
var inst_62942 = (state_62993[(2)]);
var state_62993__$1 = state_62993;
var statearr_62997_63028 = state_62993__$1;
(statearr_62997_63028[(2)] = inst_62942);

(statearr_62997_63028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (15))){
var inst_62962 = (state_62993[(7)]);
var inst_62981 = (state_62993[(2)]);
var inst_62982 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62983 = [(5000),inst_62981,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_62984 = cljs.core.PersistentHashMap.fromArrays(inst_62982,inst_62983);
var inst_62985 = fluree.db.util.xhttp.get.call(null,inst_62962,inst_62984);
var state_62993__$1 = state_62993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62993__$1,(16),inst_62985);
} else {
if((state_val_62994 === (13))){
var inst_62972 = (state_62993[(8)]);
var inst_62962 = (state_62993[(7)]);
var inst_62974 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62975 = [inst_62972];
var inst_62976 = cljs.core.PersistentHashMap.fromArrays(inst_62974,inst_62975);
var inst_62977 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_62962,inst_62976,private$);
var inst_62978 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62977);
var state_62993__$1 = state_62993;
var statearr_62998_63029 = state_62993__$1;
(statearr_62998_63029[(2)] = inst_62978);

(statearr_62998_63029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (6))){
var inst_62948 = (state_62993[(9)]);
var state_62993__$1 = state_62993;
var statearr_62999_63030 = state_62993__$1;
(statearr_62999_63030[(2)] = inst_62948);

(statearr_62999_63030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (3))){
var inst_62991 = (state_62993[(2)]);
var state_62993__$1 = state_62993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62993__$1,inst_62991);
} else {
if((state_val_62994 === (12))){
var inst_62972 = (state_62993[(2)]);
var state_62993__$1 = (function (){var statearr_63000 = state_62993;
(statearr_63000[(8)] = inst_62972);

return statearr_63000;
})();
if(cljs.core.truth_(private$)){
var statearr_63001_63031 = state_62993__$1;
(statearr_63001_63031[(1)] = (13));

} else {
var statearr_63002_63032 = state_62993__$1;
(statearr_63002_63032[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (2))){
var inst_62948 = (state_62993[(9)]);
var _ = (function (){var statearr_63003 = state_62993;
(statearr_63003[(4)] = cljs.core.cons.call(null,(5),(state_62993[(4)])));

return statearr_63003;
})();
var inst_62948__$1 = jwt;
var state_62993__$1 = (function (){var statearr_63004 = state_62993;
(statearr_63004[(9)] = inst_62948__$1);

return statearr_63004;
})();
if(cljs.core.truth_(inst_62948__$1)){
var statearr_63005_63033 = state_62993__$1;
(statearr_63005_63033[(1)] = (6));

} else {
var statearr_63006_63034 = state_62993__$1;
(statearr_63006_63034[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (11))){
var inst_62966 = (state_62993[(10)]);
var state_62993__$1 = state_62993;
var statearr_63008_63035 = state_62993__$1;
(statearr_63008_63035[(2)] = inst_62966);

(statearr_63008_63035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (9))){
var inst_62957 = (state_62993[(11)]);
var inst_62958 = (state_62993[(12)]);
var inst_62961 = (state_62993[(2)]);
var inst_62962 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62961),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62958)].join('');
var inst_62964 = ["Accept"];
var inst_62965 = ["application/json"];
var inst_62966 = cljs.core.PersistentHashMap.fromArrays(inst_62964,inst_62965);
var state_62993__$1 = (function (){var statearr_63009 = state_62993;
(statearr_63009[(7)] = inst_62962);

(statearr_63009[(10)] = inst_62966);

return statearr_63009;
})();
if(cljs.core.truth_(inst_62957)){
var statearr_63010_63036 = state_62993__$1;
(statearr_63010_63036[(1)] = (10));

} else {
var statearr_63011_63037 = state_62993__$1;
(statearr_63011_63037[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (5))){
var _ = (function (){var statearr_63012 = state_62993;
(statearr_63012[(4)] = cljs.core.rest.call(null,(state_62993[(4)])));

return statearr_63012;
})();
var state_62993__$1 = state_62993;
var ex63007 = (state_62993__$1[(2)]);
var statearr_63013_63038 = state_62993__$1;
(statearr_63013_63038[(5)] = ex63007);


if((ex63007 instanceof Error)){
var statearr_63014_63039 = state_62993__$1;
(statearr_63014_63039[(1)] = (4));

(statearr_63014_63039[(5)] = null);

} else {
throw ex63007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (14))){
var inst_62972 = (state_62993[(8)]);
var state_62993__$1 = state_62993;
var statearr_63015_63040 = state_62993__$1;
(statearr_63015_63040[(2)] = inst_62972);

(statearr_63015_63040[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (16))){
var inst_62987 = (state_62993[(2)]);
var inst_62988 = fluree.db.util.async.throw_err.call(null,inst_62987);
var _ = (function (){var statearr_63016 = state_62993;
(statearr_63016[(4)] = cljs.core.rest.call(null,(state_62993[(4)])));

return statearr_63016;
})();
var state_62993__$1 = state_62993;
var statearr_63017_63041 = state_62993__$1;
(statearr_63017_63041[(2)] = inst_62988);

(statearr_63017_63041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (10))){
var inst_62957 = (state_62993[(11)]);
var inst_62966 = (state_62993[(10)]);
var inst_62968 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62957)].join('');
var inst_62969 = cljs.core.assoc.call(null,inst_62966,"Authorization",inst_62968);
var state_62993__$1 = state_62993;
var statearr_63018_63042 = state_62993__$1;
(statearr_63018_63042[(2)] = inst_62969);

(statearr_63018_63042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62994 === (8))){
var inst_62957 = (state_62993[(2)]);
var inst_62958 = clojure.string.replace.call(null,k,"_","/");
var inst_62959 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_62993__$1 = (function (){var statearr_63019 = state_62993;
(statearr_63019[(11)] = inst_62957);

(statearr_63019[(12)] = inst_62958);

return statearr_63019;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62993__$1,(9),inst_62959);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2726__auto__ = null;
var fluree$db$connection$state_machine__2726__auto____0 = (function (){
var statearr_63020 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63020[(0)] = fluree$db$connection$state_machine__2726__auto__);

(statearr_63020[(1)] = (1));

return statearr_63020;
});
var fluree$db$connection$state_machine__2726__auto____1 = (function (state_62993){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_62993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63021){var ex__2729__auto__ = e63021;
var statearr_63022_63043 = state_62993;
(statearr_63022_63043[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_62993[(4)]))){
var statearr_63023_63044 = state_62993;
(statearr_63023_63044[(1)] = cljs.core.first.call(null,(state_62993[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63045 = state_62993;
state_62993 = G__63045;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2726__auto__ = function(state_62993){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2726__auto____1.call(this,state_62993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2726__auto____0;
fluree$db$connection$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2726__auto____1;
return fluree$db$connection$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63024 = f__2749__auto__.call(null);
(statearr_63024[(6)] = c__2748__auto__);

return statearr_63024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__63046_SHARP_){
if(cljs.core.truth_(p1__63046_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__63047_SHARP_){
var or__4223__auto__ = p1__63047_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e63048){var e = e63048;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__63049 = opts;
var map__63049__$1 = cljs.core.__destructure_map.call(null,map__63049);
var sub_chan = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__63049__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___63090 = arguments.length;
var i__4830__auto___63091 = (0);
while(true){
if((i__4830__auto___63091 < len__4829__auto___63090)){
args__4835__auto__.push((arguments[i__4830__auto___63091]));

var G__63092 = (i__4830__auto___63091 + (1));
i__4830__auto___63091 = G__63092;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__63052){
var vec__63053 = p__63052;
var opts = cljs.core.nth.call(null,vec__63053,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2748__auto___63093 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63073){
var state_val_63074 = (state_63073[(1)]);
if((state_val_63074 === (1))){
var inst_63056 = fluree.db.connection.get_socket.call(null,conn);
var state_63073__$1 = state_63073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63073__$1,(2),inst_63056);
} else {
if((state_val_63074 === (2))){
var inst_63058 = (state_63073[(7)]);
var inst_63059 = (state_63073[(8)]);
var inst_63058__$1 = (state_63073[(2)]);
var inst_63059__$1 = (inst_63058__$1 == null);
var state_63073__$1 = (function (){var statearr_63075 = state_63073;
(statearr_63075[(7)] = inst_63058__$1);

(statearr_63075[(8)] = inst_63059__$1);

return statearr_63075;
})();
if(cljs.core.truth_(inst_63059__$1)){
var statearr_63076_63094 = state_63073__$1;
(statearr_63076_63094[(1)] = (3));

} else {
var statearr_63077_63095 = state_63073__$1;
(statearr_63077_63095[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63074 === (3))){
var inst_63059 = (state_63073[(8)]);
var state_63073__$1 = state_63073;
var statearr_63078_63096 = state_63073__$1;
(statearr_63078_63096[(2)] = inst_63059);

(statearr_63078_63096[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63074 === (4))){
var inst_63058 = (state_63073[(7)]);
var inst_63062 = fluree.db.util.core.exception_QMARK_.call(null,inst_63058);
var state_63073__$1 = state_63073;
var statearr_63079_63097 = state_63073__$1;
(statearr_63079_63097[(2)] = inst_63062);

(statearr_63079_63097[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63074 === (5))){
var inst_63064 = (state_63073[(2)]);
var state_63073__$1 = state_63073;
if(cljs.core.truth_(inst_63064)){
var statearr_63080_63098 = state_63073__$1;
(statearr_63080_63098[(1)] = (6));

} else {
var statearr_63081_63099 = state_63073__$1;
(statearr_63081_63099[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63074 === (6))){
var inst_63066 = fluree.db.util.log.warn.call(null,"Cannot establish connection to a healthy server, disconnecting.");
var inst_63067 = cljs.core.async.close_BANG_.call(null,conn);
var state_63073__$1 = (function (){var statearr_63082 = state_63073;
(statearr_63082[(9)] = inst_63066);

return statearr_63082;
})();
var statearr_63083_63100 = state_63073__$1;
(statearr_63083_63100[(2)] = inst_63067);

(statearr_63083_63100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63074 === (7))){
var inst_63069 = fluree.db.connection.msg_consumer.call(null,conn);
var state_63073__$1 = state_63073;
var statearr_63084_63101 = state_63073__$1;
(statearr_63084_63101[(2)] = inst_63069);

(statearr_63084_63101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63074 === (8))){
var inst_63071 = (state_63073[(2)]);
var state_63073__$1 = state_63073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63073__$1,inst_63071);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2726__auto__ = null;
var fluree$db$connection$state_machine__2726__auto____0 = (function (){
var statearr_63085 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63085[(0)] = fluree$db$connection$state_machine__2726__auto__);

(statearr_63085[(1)] = (1));

return statearr_63085;
});
var fluree$db$connection$state_machine__2726__auto____1 = (function (state_63073){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63086){var ex__2729__auto__ = e63086;
var statearr_63087_63102 = state_63073;
(statearr_63087_63102[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63073[(4)]))){
var statearr_63088_63103 = state_63073;
(statearr_63088_63103[(1)] = cljs.core.first.call(null,(state_63073[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63104 = state_63073;
state_63073 = G__63104;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2726__auto__ = function(state_63073){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2726__auto____1.call(this,state_63073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2726__auto____0;
fluree$db$connection$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2726__auto____1;
return fluree$db$connection$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63089 = f__2749__auto__.call(null);
(statearr_63089[(6)] = c__2748__auto___63093);

return statearr_63089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq63050){
var G__63051 = cljs.core.first.call(null,seq63050);
var seq63050__$1 = cljs.core.next.call(null,seq63050);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63051,seq63050__$1);
}));

