// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___53808 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_53859){
var state_val_53860 = (state_53859[(1)]);
if((state_val_53860 === (7))){
var inst_53854 = (state_53859[(2)]);
var _ = (function (){var statearr_53861 = state_53859;
(statearr_53861[(4)] = cljs.core.rest.call(null,(state_53859[(4)])));

return statearr_53861;
})();
var state_53859__$1 = state_53859;
var statearr_53862_53889 = state_53859__$1;
(statearr_53862_53889[(2)] = inst_53854);

(statearr_53862_53889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (1))){
var state_53859__$1 = state_53859;
var statearr_53863_53890 = state_53859__$1;
(statearr_53863_53890[(2)] = null);

(statearr_53863_53890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (4))){
var inst_53809 = (state_53859[(2)]);
var state_53859__$1 = state_53859;
var statearr_53864_53891 = state_53859__$1;
(statearr_53864_53891[(2)] = inst_53809);

(statearr_53864_53891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (13))){
var inst_53850 = (state_53859[(2)]);
var state_53859__$1 = state_53859;
var statearr_53865_53892 = state_53859__$1;
(statearr_53865_53892[(2)] = inst_53850);

(statearr_53865_53892[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (6))){
var inst_53834 = (state_53859[(7)]);
var inst_53827 = (state_53859[(8)]);
var inst_53833 = cljs.core.seq.call(null,inst_53827);
var inst_53834__$1 = cljs.core.first.call(null,inst_53833);
var inst_53835 = cljs.core.next.call(null,inst_53833);
var inst_53836 = cljs.core.not.call(null,inst_53834__$1);
var state_53859__$1 = (function (){var statearr_53866 = state_53859;
(statearr_53866[(7)] = inst_53834__$1);

(statearr_53866[(9)] = inst_53835);

return statearr_53866;
})();
if(inst_53836){
var statearr_53867_53893 = state_53859__$1;
(statearr_53867_53893[(1)] = (8));

} else {
var statearr_53868_53894 = state_53859__$1;
(statearr_53868_53894[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (3))){
var inst_53857 = (state_53859[(2)]);
var state_53859__$1 = state_53859;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53859__$1,inst_53857);
} else {
if((state_val_53860 === (12))){
var inst_53834 = (state_53859[(7)]);
var inst_53835 = (state_53859[(9)]);
var inst_53828 = (state_53859[(10)]);
var inst_53847 = cljs.core.conj.call(null,inst_53828,inst_53834);
var inst_53827 = inst_53835;
var inst_53828__$1 = inst_53847;
var state_53859__$1 = (function (){var statearr_53869 = state_53859;
(statearr_53869[(8)] = inst_53827);

(statearr_53869[(10)] = inst_53828__$1);

return statearr_53869;
})();
var statearr_53870_53895 = state_53859__$1;
(statearr_53870_53895[(2)] = null);

(statearr_53870_53895[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (2))){
var _ = (function (){var statearr_53871 = state_53859;
(statearr_53871[(4)] = cljs.core.cons.call(null,(5),(state_53859[(4)])));

return statearr_53871;
})();
var inst_53822 = args;
var inst_53823 = cljs.core.seq.call(null,inst_53822);
var inst_53824 = cljs.core.first.call(null,inst_53823);
var inst_53825 = cljs.core.next.call(null,inst_53823);
var inst_53826 = cljs.core.PersistentVector.EMPTY;
var inst_53827 = inst_53822;
var inst_53828 = inst_53826;
var state_53859__$1 = (function (){var statearr_53872 = state_53859;
(statearr_53872[(8)] = inst_53827);

(statearr_53872[(11)] = inst_53825);

(statearr_53872[(10)] = inst_53828);

(statearr_53872[(12)] = inst_53824);

return statearr_53872;
})();
var statearr_53873_53896 = state_53859__$1;
(statearr_53873_53896[(2)] = null);

(statearr_53873_53896[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (11))){
var inst_53834 = (state_53859[(7)]);
var state_53859__$1 = state_53859;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53859__$1,(14),inst_53834);
} else {
if((state_val_53860 === (9))){
var inst_53834 = (state_53859[(7)]);
var inst_53839 = fluree.db.util.async.channel_QMARK_.call(null,inst_53834);
var state_53859__$1 = state_53859;
if(inst_53839){
var statearr_53875_53897 = state_53859__$1;
(statearr_53875_53897[(1)] = (11));

} else {
var statearr_53876_53898 = state_53859__$1;
(statearr_53876_53898[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (5))){
var _ = (function (){var statearr_53877 = state_53859;
(statearr_53877[(4)] = cljs.core.rest.call(null,(state_53859[(4)])));

return statearr_53877;
})();
var state_53859__$1 = state_53859;
var ex53874 = (state_53859__$1[(2)]);
var statearr_53878_53899 = state_53859__$1;
(statearr_53878_53899[(5)] = ex53874);


if((ex53874 instanceof Error)){
var statearr_53879_53900 = state_53859__$1;
(statearr_53879_53900[(1)] = (4));

(statearr_53879_53900[(5)] = null);

} else {
throw ex53874;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (14))){
var inst_53835 = (state_53859[(9)]);
var inst_53828 = (state_53859[(10)]);
var inst_53842 = (state_53859[(2)]);
var inst_53843 = fluree.db.util.async.throw_err.call(null,inst_53842);
var inst_53844 = cljs.core.conj.call(null,inst_53828,inst_53843);
var inst_53827 = inst_53835;
var inst_53828__$1 = inst_53844;
var state_53859__$1 = (function (){var statearr_53880 = state_53859;
(statearr_53880[(8)] = inst_53827);

(statearr_53880[(10)] = inst_53828__$1);

return statearr_53880;
})();
var statearr_53881_53901 = state_53859__$1;
(statearr_53881_53901[(2)] = null);

(statearr_53881_53901[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (10))){
var inst_53852 = (state_53859[(2)]);
var state_53859__$1 = state_53859;
var statearr_53882_53902 = state_53859__$1;
(statearr_53882_53902[(2)] = inst_53852);

(statearr_53882_53902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53860 === (8))){
var inst_53828 = (state_53859[(10)]);
var state_53859__$1 = state_53859;
var statearr_53883_53903 = state_53859__$1;
(statearr_53883_53903[(2)] = inst_53828);

(statearr_53883_53903[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto____0 = (function (){
var statearr_53884 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53884[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto__);

(statearr_53884[(1)] = (1));

return statearr_53884;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto____1 = (function (state_53859){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_53859);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e53885){var ex__2729__auto__ = e53885;
var statearr_53886_53904 = state_53859;
(statearr_53886_53904[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_53859[(4)]))){
var statearr_53887_53905 = state_53859;
(statearr_53887_53905[(1)] = cljs.core.first.call(null,(state_53859[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53906 = state_53859;
state_53859 = G__53906;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto__ = function(state_53859){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto____1.call(this,state_53859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_53888 = f__2749__auto__.call(null);
(statearr_53888[(6)] = c__2748__auto__);

return statearr_53888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53907 = entry;
var res = cljs.core.nth.call(null,vec__53907,(0),null);
var cost = cljs.core.nth.call(null,vec__53907,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_53955){
var state_val_53956 = (state_53955[(1)]);
if((state_val_53956 === (7))){
var state_53955__$1 = state_53955;
var statearr_53957_53986 = state_53955__$1;
(statearr_53957_53986[(2)] = coll);

(statearr_53957_53986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (1))){
var state_53955__$1 = state_53955;
var statearr_53958_53987 = state_53955__$1;
(statearr_53958_53987[(2)] = null);

(statearr_53958_53987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (4))){
var inst_53910 = (state_53955[(2)]);
var state_53955__$1 = state_53955;
var statearr_53959_53988 = state_53955__$1;
(statearr_53959_53988[(2)] = inst_53910);

(statearr_53959_53988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (15))){
var inst_53929 = (state_53955[(7)]);
var inst_53937 = (state_53955[(2)]);
var inst_53938 = fluree.db.dbfunctions.internal.nth.call(null,inst_53929,inst_53937);
var inst_53939 = cljs.core.count.call(null,inst_53929);
var inst_53940 = ((9) + inst_53939);
var inst_53941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53942 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53944 = [inst_53929,inst_53937];
var inst_53945 = (new cljs.core.PersistentVector(null,2,(5),inst_53943,inst_53944,null));
var inst_53946 = ["nth",inst_53945,inst_53938];
var inst_53947 = cljs.core.PersistentHashMap.fromArrays(inst_53942,inst_53946);
var inst_53948 = [inst_53947,inst_53940];
var inst_53949 = (new cljs.core.PersistentVector(null,2,(5),inst_53941,inst_53948,null));
var inst_53950 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53949);
var _ = (function (){var statearr_53960 = state_53955;
(statearr_53960[(4)] = cljs.core.rest.call(null,(state_53955[(4)])));

return statearr_53960;
})();
var state_53955__$1 = (function (){var statearr_53961 = state_53955;
(statearr_53961[(8)] = inst_53950);

return statearr_53961;
})();
var statearr_53962_53989 = state_53955__$1;
(statearr_53962_53989[(2)] = inst_53938);

(statearr_53962_53989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (13))){
var state_53955__$1 = state_53955;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53955__$1,(16),key);
} else {
if((state_val_53956 === (6))){
var state_53955__$1 = state_53955;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53955__$1,(9),coll);
} else {
if((state_val_53956 === (3))){
var inst_53953 = (state_53955[(2)]);
var state_53955__$1 = state_53955;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53955__$1,inst_53953);
} else {
if((state_val_53956 === (12))){
var inst_53929 = (state_53955[(2)]);
var inst_53930 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_53955__$1 = (function (){var statearr_53963 = state_53955;
(statearr_53963[(7)] = inst_53929);

return statearr_53963;
})();
if(inst_53930){
var statearr_53964_53990 = state_53955__$1;
(statearr_53964_53990[(1)] = (13));

} else {
var statearr_53965_53991 = state_53955__$1;
(statearr_53965_53991[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (2))){
var _ = (function (){var statearr_53966 = state_53955;
(statearr_53966[(4)] = cljs.core.cons.call(null,(5),(state_53955[(4)])));

return statearr_53966;
})();
var inst_53916 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53955__$1 = state_53955;
if(inst_53916){
var statearr_53967_53992 = state_53955__$1;
(statearr_53967_53992[(1)] = (6));

} else {
var statearr_53968_53993 = state_53955__$1;
(statearr_53968_53993[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (11))){
var inst_53923 = (state_53955[(9)]);
var state_53955__$1 = state_53955;
var statearr_53970_53994 = state_53955__$1;
(statearr_53970_53994[(2)] = inst_53923);

(statearr_53970_53994[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (9))){
var inst_53919 = (state_53955[(2)]);
var inst_53920 = fluree.db.util.async.throw_err.call(null,inst_53919);
var state_53955__$1 = state_53955;
var statearr_53971_53995 = state_53955__$1;
(statearr_53971_53995[(2)] = inst_53920);

(statearr_53971_53995[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (5))){
var _ = (function (){var statearr_53972 = state_53955;
(statearr_53972[(4)] = cljs.core.rest.call(null,(state_53955[(4)])));

return statearr_53972;
})();
var state_53955__$1 = state_53955;
var ex53969 = (state_53955__$1[(2)]);
var statearr_53973_53996 = state_53955__$1;
(statearr_53973_53996[(5)] = ex53969);


if((ex53969 instanceof Error)){
var statearr_53974_53997 = state_53955__$1;
(statearr_53974_53997[(1)] = (4));

(statearr_53974_53997[(5)] = null);

} else {
throw ex53969;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (14))){
var state_53955__$1 = state_53955;
var statearr_53975_53998 = state_53955__$1;
(statearr_53975_53998[(2)] = key);

(statearr_53975_53998[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (16))){
var inst_53933 = (state_53955[(2)]);
var inst_53934 = fluree.db.util.async.throw_err.call(null,inst_53933);
var state_53955__$1 = state_53955;
var statearr_53976_53999 = state_53955__$1;
(statearr_53976_53999[(2)] = inst_53934);

(statearr_53976_53999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (10))){
var inst_53923 = (state_53955[(9)]);
var inst_53926 = cljs.core.vec.call(null,inst_53923);
var state_53955__$1 = state_53955;
var statearr_53977_54000 = state_53955__$1;
(statearr_53977_54000[(2)] = inst_53926);

(statearr_53977_54000[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53956 === (8))){
var inst_53923 = (state_53955[(9)]);
var inst_53923__$1 = (state_53955[(2)]);
var inst_53924 = cljs.core.set_QMARK_.call(null,inst_53923__$1);
var state_53955__$1 = (function (){var statearr_53978 = state_53955;
(statearr_53978[(9)] = inst_53923__$1);

return statearr_53978;
})();
if(inst_53924){
var statearr_53979_54001 = state_53955__$1;
(statearr_53979_54001[(1)] = (10));

} else {
var statearr_53980_54002 = state_53955__$1;
(statearr_53980_54002[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto____0 = (function (){
var statearr_53981 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53981[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto__);

(statearr_53981[(1)] = (1));

return statearr_53981;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto____1 = (function (state_53955){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_53955);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e53982){var ex__2729__auto__ = e53982;
var statearr_53983_54003 = state_53955;
(statearr_53983_54003[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_53955[(4)]))){
var statearr_53984_54004 = state_53955;
(statearr_53984_54004[(1)] = cljs.core.first.call(null,(state_53955[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54005 = state_53955;
state_53955 = G__54005;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto__ = function(state_53955){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto____1.call(this,state_53955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_53985 = f__2749__auto__.call(null);
(statearr_53985[(6)] = c__2748__auto__);

return statearr_53985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54066){
var state_val_54067 = (state_54066[(1)]);
if((state_val_54067 === (7))){
var state_54066__$1 = state_54066;
var statearr_54068_54102 = state_54066__$1;
(statearr_54068_54102[(2)] = test);

(statearr_54068_54102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (20))){
var inst_54040 = (state_54066[(2)]);
var inst_54041 = fluree.db.util.async.throw_err.call(null,inst_54040);
var state_54066__$1 = state_54066;
var statearr_54069_54103 = state_54066__$1;
(statearr_54069_54103[(2)] = inst_54041);

(statearr_54069_54103[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (1))){
var state_54066__$1 = state_54066;
var statearr_54070_54104 = state_54066__$1;
(statearr_54070_54104[(2)] = null);

(statearr_54070_54104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (4))){
var inst_54006 = (state_54066[(2)]);
var state_54066__$1 = state_54066;
var statearr_54071_54105 = state_54066__$1;
(statearr_54071_54105[(2)] = inst_54006);

(statearr_54071_54105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (15))){
var inst_54024 = (state_54066[(7)]);
var inst_54032 = (state_54066[(2)]);
var inst_54033 = [inst_54032,f];
var inst_54034 = (new cljs.core.PersistentVector(null,2,(5),inst_54024,inst_54033,null));
var state_54066__$1 = state_54066;
var statearr_54072_54106 = state_54066__$1;
(statearr_54072_54106[(2)] = inst_54034);

(statearr_54072_54106[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (13))){
var state_54066__$1 = state_54066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54066__$1,(16),t);
} else {
if((state_val_54067 === (6))){
var state_54066__$1 = state_54066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54066__$1,(9),test);
} else {
if((state_val_54067 === (17))){
var state_54066__$1 = state_54066;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54066__$1,(20),f);
} else {
if((state_val_54067 === (3))){
var inst_54064 = (state_54066[(2)]);
var state_54066__$1 = state_54066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54066__$1,inst_54064);
} else {
if((state_val_54067 === (12))){
var inst_54022 = (state_54066[(8)]);
var inst_54048 = (state_54066[(2)]);
var inst_54049 = cljs.core.nth.call(null,inst_54048,(0),null);
var inst_54050 = cljs.core.nth.call(null,inst_54048,(1),null);
var inst_54051 = fluree.db.dbfunctions.internal.if_else.call(null,inst_54022,inst_54049,inst_54050);
var inst_54052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54053 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54055 = [inst_54022,inst_54049,inst_54050];
var inst_54056 = (new cljs.core.PersistentVector(null,3,(5),inst_54054,inst_54055,null));
var inst_54057 = ["if-else",inst_54056,inst_54051];
var inst_54058 = cljs.core.PersistentHashMap.fromArrays(inst_54053,inst_54057);
var inst_54059 = [inst_54058,(10)];
var inst_54060 = (new cljs.core.PersistentVector(null,2,(5),inst_54052,inst_54059,null));
var inst_54061 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54060);
var _ = (function (){var statearr_54073 = state_54066;
(statearr_54073[(4)] = cljs.core.rest.call(null,(state_54066[(4)])));

return statearr_54073;
})();
var state_54066__$1 = (function (){var statearr_54074 = state_54066;
(statearr_54074[(9)] = inst_54061);

return statearr_54074;
})();
var statearr_54075_54107 = state_54066__$1;
(statearr_54075_54107[(2)] = inst_54051);

(statearr_54075_54107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (2))){
var _ = (function (){var statearr_54076 = state_54066;
(statearr_54076[(4)] = cljs.core.cons.call(null,(5),(state_54066[(4)])));

return statearr_54076;
})();
var inst_54015 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_54066__$1 = state_54066;
if(inst_54015){
var statearr_54077_54108 = state_54066__$1;
(statearr_54077_54108[(1)] = (6));

} else {
var statearr_54078_54109 = state_54066__$1;
(statearr_54078_54109[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (19))){
var inst_54036 = (state_54066[(10)]);
var inst_54044 = (state_54066[(2)]);
var inst_54045 = [f,inst_54044];
var inst_54046 = (new cljs.core.PersistentVector(null,2,(5),inst_54036,inst_54045,null));
var state_54066__$1 = state_54066;
var statearr_54079_54110 = state_54066__$1;
(statearr_54079_54110[(2)] = inst_54046);

(statearr_54079_54110[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (11))){
var inst_54036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54037 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_54066__$1 = (function (){var statearr_54081 = state_54066;
(statearr_54081[(10)] = inst_54036);

return statearr_54081;
})();
if(inst_54037){
var statearr_54082_54111 = state_54066__$1;
(statearr_54082_54111[(1)] = (17));

} else {
var statearr_54083_54112 = state_54066__$1;
(statearr_54083_54112[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (9))){
var inst_54018 = (state_54066[(2)]);
var inst_54019 = fluree.db.util.async.throw_err.call(null,inst_54018);
var state_54066__$1 = state_54066;
var statearr_54084_54113 = state_54066__$1;
(statearr_54084_54113[(2)] = inst_54019);

(statearr_54084_54113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (5))){
var _ = (function (){var statearr_54085 = state_54066;
(statearr_54085[(4)] = cljs.core.rest.call(null,(state_54066[(4)])));

return statearr_54085;
})();
var state_54066__$1 = state_54066;
var ex54080 = (state_54066__$1[(2)]);
var statearr_54086_54114 = state_54066__$1;
(statearr_54086_54114[(5)] = ex54080);


if((ex54080 instanceof Error)){
var statearr_54087_54115 = state_54066__$1;
(statearr_54087_54115[(1)] = (4));

(statearr_54087_54115[(5)] = null);

} else {
throw ex54080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (14))){
var state_54066__$1 = state_54066;
var statearr_54088_54116 = state_54066__$1;
(statearr_54088_54116[(2)] = t);

(statearr_54088_54116[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (16))){
var inst_54028 = (state_54066[(2)]);
var inst_54029 = fluree.db.util.async.throw_err.call(null,inst_54028);
var state_54066__$1 = state_54066;
var statearr_54089_54117 = state_54066__$1;
(statearr_54089_54117[(2)] = inst_54029);

(statearr_54089_54117[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (10))){
var inst_54024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54025 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_54066__$1 = (function (){var statearr_54090 = state_54066;
(statearr_54090[(7)] = inst_54024);

return statearr_54090;
})();
if(inst_54025){
var statearr_54091_54118 = state_54066__$1;
(statearr_54091_54118[(1)] = (13));

} else {
var statearr_54092_54119 = state_54066__$1;
(statearr_54092_54119[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (18))){
var state_54066__$1 = state_54066;
var statearr_54093_54120 = state_54066__$1;
(statearr_54093_54120[(2)] = f);

(statearr_54093_54120[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54067 === (8))){
var inst_54022 = (state_54066[(8)]);
var inst_54022__$1 = (state_54066[(2)]);
var state_54066__$1 = (function (){var statearr_54094 = state_54066;
(statearr_54094[(8)] = inst_54022__$1);

return statearr_54094;
})();
if(cljs.core.truth_(inst_54022__$1)){
var statearr_54095_54121 = state_54066__$1;
(statearr_54095_54121[(1)] = (10));

} else {
var statearr_54096_54122 = state_54066__$1;
(statearr_54096_54122[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto____0 = (function (){
var statearr_54097 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54097[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto__);

(statearr_54097[(1)] = (1));

return statearr_54097;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto____1 = (function (state_54066){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54098){var ex__2729__auto__ = e54098;
var statearr_54099_54123 = state_54066;
(statearr_54099_54123[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54066[(4)]))){
var statearr_54100_54124 = state_54066;
(statearr_54100_54124[(1)] = cljs.core.first.call(null,(state_54066[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54125 = state_54066;
state_54066 = G__54125;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto__ = function(state_54066){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto____1.call(this,state_54066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54101 = f__2749__auto__.call(null);
(statearr_54101[(6)] = c__2748__auto__);

return statearr_54101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54155){
var state_val_54156 = (state_54155[(1)]);
if((state_val_54156 === (7))){
var state_54155__$1 = state_54155;
var statearr_54157_54176 = state_54155__$1;
(statearr_54157_54176[(2)] = arg);

(statearr_54157_54176[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (1))){
var state_54155__$1 = state_54155;
var statearr_54158_54177 = state_54155__$1;
(statearr_54158_54177[(2)] = null);

(statearr_54158_54177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (4))){
var inst_54126 = (state_54155[(2)]);
var state_54155__$1 = state_54155;
var statearr_54159_54178 = state_54155__$1;
(statearr_54159_54178[(2)] = inst_54126);

(statearr_54159_54178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (6))){
var state_54155__$1 = state_54155;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54155__$1,(9),arg);
} else {
if((state_val_54156 === (3))){
var inst_54153 = (state_54155[(2)]);
var state_54155__$1 = state_54155;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54155__$1,inst_54153);
} else {
if((state_val_54156 === (2))){
var _ = (function (){var statearr_54161 = state_54155;
(statearr_54161[(4)] = cljs.core.cons.call(null,(5),(state_54155[(4)])));

return statearr_54161;
})();
var inst_54132 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54155__$1 = state_54155;
if(inst_54132){
var statearr_54162_54179 = state_54155__$1;
(statearr_54162_54179[(1)] = (6));

} else {
var statearr_54163_54180 = state_54155__$1;
(statearr_54163_54180[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (9))){
var inst_54135 = (state_54155[(2)]);
var inst_54136 = fluree.db.util.async.throw_err.call(null,inst_54135);
var state_54155__$1 = state_54155;
var statearr_54164_54181 = state_54155__$1;
(statearr_54164_54181[(2)] = inst_54136);

(statearr_54164_54181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (5))){
var _ = (function (){var statearr_54165 = state_54155;
(statearr_54165[(4)] = cljs.core.rest.call(null,(state_54155[(4)])));

return statearr_54165;
})();
var state_54155__$1 = state_54155;
var ex54160 = (state_54155__$1[(2)]);
var statearr_54166_54182 = state_54155__$1;
(statearr_54166_54182[(5)] = ex54160);


if((ex54160 instanceof Error)){
var statearr_54167_54183 = state_54155__$1;
(statearr_54167_54183[(1)] = (4));

(statearr_54167_54183[(5)] = null);

} else {
throw ex54160;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (8))){
var inst_54139 = (state_54155[(2)]);
var inst_54140 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_54139);
var inst_54141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54142 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54144 = [inst_54139];
var inst_54145 = (new cljs.core.PersistentVector(null,1,(5),inst_54143,inst_54144,null));
var inst_54146 = ["nil?",inst_54145,inst_54140];
var inst_54147 = cljs.core.PersistentHashMap.fromArrays(inst_54142,inst_54146);
var inst_54148 = [inst_54147,(10)];
var inst_54149 = (new cljs.core.PersistentVector(null,2,(5),inst_54141,inst_54148,null));
var inst_54150 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54149);
var _ = (function (){var statearr_54168 = state_54155;
(statearr_54168[(4)] = cljs.core.rest.call(null,(state_54155[(4)])));

return statearr_54168;
})();
var state_54155__$1 = (function (){var statearr_54169 = state_54155;
(statearr_54169[(7)] = inst_54150);

return statearr_54169;
})();
var statearr_54170_54184 = state_54155__$1;
(statearr_54170_54184[(2)] = inst_54140);

(statearr_54170_54184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_54171 = [null,null,null,null,null,null,null,null];
(statearr_54171[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto__);

(statearr_54171[(1)] = (1));

return statearr_54171;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto____1 = (function (state_54155){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54155);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54172){var ex__2729__auto__ = e54172;
var statearr_54173_54185 = state_54155;
(statearr_54173_54185[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54155[(4)]))){
var statearr_54174_54186 = state_54155;
(statearr_54174_54186[(1)] = cljs.core.first.call(null,(state_54155[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54187 = state_54155;
state_54155 = G__54187;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto__ = function(state_54155){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto____1.call(this,state_54155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54175 = f__2749__auto__.call(null);
(statearr_54175[(6)] = c__2748__auto__);

return statearr_54175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54217){
var state_val_54218 = (state_54217[(1)]);
if((state_val_54218 === (7))){
var state_54217__$1 = state_54217;
var statearr_54219_54238 = state_54217__$1;
(statearr_54219_54238[(2)] = arg);

(statearr_54219_54238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (1))){
var state_54217__$1 = state_54217;
var statearr_54220_54239 = state_54217__$1;
(statearr_54220_54239[(2)] = null);

(statearr_54220_54239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (4))){
var inst_54188 = (state_54217[(2)]);
var state_54217__$1 = state_54217;
var statearr_54221_54240 = state_54217__$1;
(statearr_54221_54240[(2)] = inst_54188);

(statearr_54221_54240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (6))){
var state_54217__$1 = state_54217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54217__$1,(9),arg);
} else {
if((state_val_54218 === (3))){
var inst_54215 = (state_54217[(2)]);
var state_54217__$1 = state_54217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54217__$1,inst_54215);
} else {
if((state_val_54218 === (2))){
var _ = (function (){var statearr_54223 = state_54217;
(statearr_54223[(4)] = cljs.core.cons.call(null,(5),(state_54217[(4)])));

return statearr_54223;
})();
var inst_54194 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54217__$1 = state_54217;
if(inst_54194){
var statearr_54224_54241 = state_54217__$1;
(statearr_54224_54241[(1)] = (6));

} else {
var statearr_54225_54242 = state_54217__$1;
(statearr_54225_54242[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (9))){
var inst_54197 = (state_54217[(2)]);
var inst_54198 = fluree.db.util.async.throw_err.call(null,inst_54197);
var state_54217__$1 = state_54217;
var statearr_54226_54243 = state_54217__$1;
(statearr_54226_54243[(2)] = inst_54198);

(statearr_54226_54243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (5))){
var _ = (function (){var statearr_54227 = state_54217;
(statearr_54227[(4)] = cljs.core.rest.call(null,(state_54217[(4)])));

return statearr_54227;
})();
var state_54217__$1 = state_54217;
var ex54222 = (state_54217__$1[(2)]);
var statearr_54228_54244 = state_54217__$1;
(statearr_54228_54244[(5)] = ex54222);


if((ex54222 instanceof Error)){
var statearr_54229_54245 = state_54217__$1;
(statearr_54229_54245[(1)] = (4));

(statearr_54229_54245[(5)] = null);

} else {
throw ex54222;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54218 === (8))){
var inst_54201 = (state_54217[(2)]);
var inst_54202 = fluree.db.dbfunctions.internal.not.call(null,inst_54201);
var inst_54203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54204 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54206 = [inst_54201];
var inst_54207 = (new cljs.core.PersistentVector(null,1,(5),inst_54205,inst_54206,null));
var inst_54208 = ["not?",inst_54207,inst_54202];
var inst_54209 = cljs.core.PersistentHashMap.fromArrays(inst_54204,inst_54208);
var inst_54210 = [inst_54209,(10)];
var inst_54211 = (new cljs.core.PersistentVector(null,2,(5),inst_54203,inst_54210,null));
var inst_54212 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54211);
var _ = (function (){var statearr_54230 = state_54217;
(statearr_54230[(4)] = cljs.core.rest.call(null,(state_54217[(4)])));

return statearr_54230;
})();
var state_54217__$1 = (function (){var statearr_54231 = state_54217;
(statearr_54231[(7)] = inst_54212);

return statearr_54231;
})();
var statearr_54232_54246 = state_54217__$1;
(statearr_54232_54246[(2)] = inst_54202);

(statearr_54232_54246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto____0 = (function (){
var statearr_54233 = [null,null,null,null,null,null,null,null];
(statearr_54233[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto__);

(statearr_54233[(1)] = (1));

return statearr_54233;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto____1 = (function (state_54217){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54234){var ex__2729__auto__ = e54234;
var statearr_54235_54247 = state_54217;
(statearr_54235_54247[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54217[(4)]))){
var statearr_54236_54248 = state_54217;
(statearr_54236_54248[(1)] = cljs.core.first.call(null,(state_54217[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54249 = state_54217;
state_54217 = G__54249;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto__ = function(state_54217){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto____1.call(this,state_54217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54237 = f__2749__auto__.call(null);
(statearr_54237[(6)] = c__2748__auto__);

return statearr_54237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54279){
var state_val_54280 = (state_54279[(1)]);
if((state_val_54280 === (7))){
var state_54279__$1 = state_54279;
var statearr_54281_54300 = state_54279__$1;
(statearr_54281_54300[(2)] = arg);

(statearr_54281_54300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54280 === (1))){
var state_54279__$1 = state_54279;
var statearr_54282_54301 = state_54279__$1;
(statearr_54282_54301[(2)] = null);

(statearr_54282_54301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54280 === (4))){
var inst_54250 = (state_54279[(2)]);
var state_54279__$1 = state_54279;
var statearr_54283_54302 = state_54279__$1;
(statearr_54283_54302[(2)] = inst_54250);

(statearr_54283_54302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54280 === (6))){
var state_54279__$1 = state_54279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54279__$1,(9),arg);
} else {
if((state_val_54280 === (3))){
var inst_54277 = (state_54279[(2)]);
var state_54279__$1 = state_54279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54279__$1,inst_54277);
} else {
if((state_val_54280 === (2))){
var _ = (function (){var statearr_54285 = state_54279;
(statearr_54285[(4)] = cljs.core.cons.call(null,(5),(state_54279[(4)])));

return statearr_54285;
})();
var inst_54256 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54279__$1 = state_54279;
if(inst_54256){
var statearr_54286_54303 = state_54279__$1;
(statearr_54286_54303[(1)] = (6));

} else {
var statearr_54287_54304 = state_54279__$1;
(statearr_54287_54304[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54280 === (9))){
var inst_54259 = (state_54279[(2)]);
var inst_54260 = fluree.db.util.async.throw_err.call(null,inst_54259);
var state_54279__$1 = state_54279;
var statearr_54288_54305 = state_54279__$1;
(statearr_54288_54305[(2)] = inst_54260);

(statearr_54288_54305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54280 === (5))){
var _ = (function (){var statearr_54289 = state_54279;
(statearr_54289[(4)] = cljs.core.rest.call(null,(state_54279[(4)])));

return statearr_54289;
})();
var state_54279__$1 = state_54279;
var ex54284 = (state_54279__$1[(2)]);
var statearr_54290_54306 = state_54279__$1;
(statearr_54290_54306[(5)] = ex54284);


if((ex54284 instanceof Error)){
var statearr_54291_54307 = state_54279__$1;
(statearr_54291_54307[(1)] = (4));

(statearr_54291_54307[(5)] = null);

} else {
throw ex54284;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54280 === (8))){
var inst_54263 = (state_54279[(2)]);
var inst_54264 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_54263);
var inst_54265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54266 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54268 = [inst_54263];
var inst_54269 = (new cljs.core.PersistentVector(null,1,(5),inst_54267,inst_54268,null));
var inst_54270 = ["empty?",inst_54269,inst_54264];
var inst_54271 = cljs.core.PersistentHashMap.fromArrays(inst_54266,inst_54270);
var inst_54272 = [inst_54271,(10)];
var inst_54273 = (new cljs.core.PersistentVector(null,2,(5),inst_54265,inst_54272,null));
var inst_54274 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54273);
var _ = (function (){var statearr_54292 = state_54279;
(statearr_54292[(4)] = cljs.core.rest.call(null,(state_54279[(4)])));

return statearr_54292;
})();
var state_54279__$1 = (function (){var statearr_54293 = state_54279;
(statearr_54293[(7)] = inst_54274);

return statearr_54293;
})();
var statearr_54294_54308 = state_54279__$1;
(statearr_54294_54308[(2)] = inst_54264);

(statearr_54294_54308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_54295 = [null,null,null,null,null,null,null,null];
(statearr_54295[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto__);

(statearr_54295[(1)] = (1));

return statearr_54295;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto____1 = (function (state_54279){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54296){var ex__2729__auto__ = e54296;
var statearr_54297_54309 = state_54279;
(statearr_54297_54309[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54279[(4)]))){
var statearr_54298_54310 = state_54279;
(statearr_54298_54310[(1)] = cljs.core.first.call(null,(state_54279[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54311 = state_54279;
state_54279 = G__54311;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto__ = function(state_54279){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto____1.call(this,state_54279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54299 = f__2749__auto__.call(null);
(statearr_54299[(6)] = c__2748__auto__);

return statearr_54299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54356 = arguments.length;
var i__4830__auto___54357 = (0);
while(true){
if((i__4830__auto___54357 < len__4829__auto___54356)){
args__4835__auto__.push((arguments[i__4830__auto___54357]));

var G__54358 = (i__4830__auto___54357 + (1));
i__4830__auto___54357 = G__54358;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54339){
var state_val_54340 = (state_54339[(1)]);
if((state_val_54340 === (1))){
var state_54339__$1 = state_54339;
var statearr_54341_54359 = state_54339__$1;
(statearr_54341_54359[(2)] = null);

(statearr_54341_54359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54340 === (2))){
var _ = (function (){var statearr_54342 = state_54339;
(statearr_54342[(4)] = cljs.core.cons.call(null,(5),(state_54339[(4)])));

return statearr_54342;
})();
var inst_54320 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54339__$1 = state_54339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54339__$1,(6),inst_54320);
} else {
if((state_val_54340 === (3))){
var inst_54337 = (state_54339[(2)]);
var state_54339__$1 = state_54339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54339__$1,inst_54337);
} else {
if((state_val_54340 === (4))){
var inst_54314 = (state_54339[(2)]);
var state_54339__$1 = state_54339;
var statearr_54344_54360 = state_54339__$1;
(statearr_54344_54360[(2)] = inst_54314);

(statearr_54344_54360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54340 === (5))){
var _ = (function (){var statearr_54345 = state_54339;
(statearr_54345[(4)] = cljs.core.rest.call(null,(state_54339[(4)])));

return statearr_54345;
})();
var state_54339__$1 = state_54339;
var ex54343 = (state_54339__$1[(2)]);
var statearr_54346_54361 = state_54339__$1;
(statearr_54346_54361[(5)] = ex54343);


if((ex54343 instanceof Error)){
var statearr_54347_54362 = state_54339__$1;
(statearr_54347_54362[(1)] = (4));

(statearr_54347_54362[(5)] = null);

} else {
throw ex54343;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54340 === (6))){
var inst_54322 = (state_54339[(2)]);
var inst_54323 = fluree.db.util.async.throw_err.call(null,inst_54322);
var inst_54324 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_54323);
var inst_54325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54326 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54328 = [inst_54323];
var inst_54329 = (new cljs.core.PersistentVector(null,1,(5),inst_54327,inst_54328,null));
var inst_54330 = ["str",inst_54329,inst_54324];
var inst_54331 = cljs.core.PersistentHashMap.fromArrays(inst_54326,inst_54330);
var inst_54332 = [inst_54331,(10)];
var inst_54333 = (new cljs.core.PersistentVector(null,2,(5),inst_54325,inst_54332,null));
var inst_54334 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54333);
var _ = (function (){var statearr_54348 = state_54339;
(statearr_54348[(4)] = cljs.core.rest.call(null,(state_54339[(4)])));

return statearr_54348;
})();
var state_54339__$1 = (function (){var statearr_54349 = state_54339;
(statearr_54349[(7)] = inst_54334);

return statearr_54349;
})();
var statearr_54350_54363 = state_54339__$1;
(statearr_54350_54363[(2)] = inst_54324);

(statearr_54350_54363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_54351 = [null,null,null,null,null,null,null,null];
(statearr_54351[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_54351[(1)] = (1));

return statearr_54351;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_54339){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54352){var ex__2729__auto__ = e54352;
var statearr_54353_54364 = state_54339;
(statearr_54353_54364[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54339[(4)]))){
var statearr_54354_54365 = state_54339;
(statearr_54354_54365[(1)] = cljs.core.first.call(null,(state_54339[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54366 = state_54339;
state_54339 = G__54366;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_54339){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_54339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54355 = f__2749__auto__.call(null);
(statearr_54355[(6)] = c__2748__auto__);

return statearr_54355;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54312){
var G__54313 = cljs.core.first.call(null,seq54312);
var seq54312__$1 = cljs.core.next.call(null,seq54312);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54313,seq54312__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54392){
var state_val_54393 = (state_54392[(1)]);
if((state_val_54393 === (1))){
var state_54392__$1 = state_54392;
var statearr_54394_54409 = state_54392__$1;
(statearr_54394_54409[(2)] = null);

(statearr_54394_54409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54393 === (2))){
var _ = (function (){var statearr_54395 = state_54392;
(statearr_54395[(4)] = cljs.core.cons.call(null,(5),(state_54392[(4)])));

return statearr_54395;
})();
var inst_54373 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54392__$1 = state_54392;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54392__$1,(6),inst_54373);
} else {
if((state_val_54393 === (3))){
var inst_54390 = (state_54392[(2)]);
var state_54392__$1 = state_54392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54392__$1,inst_54390);
} else {
if((state_val_54393 === (4))){
var inst_54367 = (state_54392[(2)]);
var state_54392__$1 = state_54392;
var statearr_54397_54410 = state_54392__$1;
(statearr_54397_54410[(2)] = inst_54367);

(statearr_54397_54410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54393 === (5))){
var _ = (function (){var statearr_54398 = state_54392;
(statearr_54398[(4)] = cljs.core.rest.call(null,(state_54392[(4)])));

return statearr_54398;
})();
var state_54392__$1 = state_54392;
var ex54396 = (state_54392__$1[(2)]);
var statearr_54399_54411 = state_54392__$1;
(statearr_54399_54411[(5)] = ex54396);


if((ex54396 instanceof Error)){
var statearr_54400_54412 = state_54392__$1;
(statearr_54400_54412[(1)] = (4));

(statearr_54400_54412[(5)] = null);

} else {
throw ex54396;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54393 === (6))){
var inst_54375 = (state_54392[(2)]);
var inst_54376 = fluree.db.util.async.throw_err.call(null,inst_54375);
var inst_54377 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_54376);
var inst_54378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54379 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54381 = [inst_54376];
var inst_54382 = (new cljs.core.PersistentVector(null,1,(5),inst_54380,inst_54381,null));
var inst_54383 = ["subs",inst_54382,inst_54377];
var inst_54384 = cljs.core.PersistentHashMap.fromArrays(inst_54379,inst_54383);
var inst_54385 = [inst_54384,(30)];
var inst_54386 = (new cljs.core.PersistentVector(null,2,(5),inst_54378,inst_54385,null));
var inst_54387 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54386);
var _ = (function (){var statearr_54401 = state_54392;
(statearr_54401[(4)] = cljs.core.rest.call(null,(state_54392[(4)])));

return statearr_54401;
})();
var state_54392__$1 = (function (){var statearr_54402 = state_54392;
(statearr_54402[(7)] = inst_54387);

return statearr_54402;
})();
var statearr_54403_54413 = state_54392__$1;
(statearr_54403_54413[(2)] = inst_54377);

(statearr_54403_54413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto____0 = (function (){
var statearr_54404 = [null,null,null,null,null,null,null,null];
(statearr_54404[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto__);

(statearr_54404[(1)] = (1));

return statearr_54404;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto____1 = (function (state_54392){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54405){var ex__2729__auto__ = e54405;
var statearr_54406_54414 = state_54392;
(statearr_54406_54414[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54392[(4)]))){
var statearr_54407_54415 = state_54392;
(statearr_54407_54415[(1)] = cljs.core.first.call(null,(state_54392[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54416 = state_54392;
state_54392 = G__54416;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto__ = function(state_54392){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto____1.call(this,state_54392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54408 = f__2749__auto__.call(null);
(statearr_54408[(6)] = c__2748__auto__);

return statearr_54408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54446){
var state_val_54447 = (state_54446[(1)]);
if((state_val_54447 === (7))){
var state_54446__$1 = state_54446;
var statearr_54448_54467 = state_54446__$1;
(statearr_54448_54467[(2)] = str);

(statearr_54448_54467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54447 === (1))){
var state_54446__$1 = state_54446;
var statearr_54449_54468 = state_54446__$1;
(statearr_54449_54468[(2)] = null);

(statearr_54449_54468[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54447 === (4))){
var inst_54417 = (state_54446[(2)]);
var state_54446__$1 = state_54446;
var statearr_54450_54469 = state_54446__$1;
(statearr_54450_54469[(2)] = inst_54417);

(statearr_54450_54469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54447 === (6))){
var state_54446__$1 = state_54446;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54446__$1,(9),str);
} else {
if((state_val_54447 === (3))){
var inst_54444 = (state_54446[(2)]);
var state_54446__$1 = state_54446;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54446__$1,inst_54444);
} else {
if((state_val_54447 === (2))){
var _ = (function (){var statearr_54452 = state_54446;
(statearr_54452[(4)] = cljs.core.cons.call(null,(5),(state_54446[(4)])));

return statearr_54452;
})();
var inst_54423 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54446__$1 = state_54446;
if(inst_54423){
var statearr_54453_54470 = state_54446__$1;
(statearr_54453_54470[(1)] = (6));

} else {
var statearr_54454_54471 = state_54446__$1;
(statearr_54454_54471[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54447 === (9))){
var inst_54426 = (state_54446[(2)]);
var inst_54427 = fluree.db.util.async.throw_err.call(null,inst_54426);
var state_54446__$1 = state_54446;
var statearr_54455_54472 = state_54446__$1;
(statearr_54455_54472[(2)] = inst_54427);

(statearr_54455_54472[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54447 === (5))){
var _ = (function (){var statearr_54456 = state_54446;
(statearr_54456[(4)] = cljs.core.rest.call(null,(state_54446[(4)])));

return statearr_54456;
})();
var state_54446__$1 = state_54446;
var ex54451 = (state_54446__$1[(2)]);
var statearr_54457_54473 = state_54446__$1;
(statearr_54457_54473[(5)] = ex54451);


if((ex54451 instanceof Error)){
var statearr_54458_54474 = state_54446__$1;
(statearr_54458_54474[(1)] = (4));

(statearr_54458_54474[(5)] = null);

} else {
throw ex54451;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54447 === (8))){
var inst_54430 = (state_54446[(2)]);
var inst_54431 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_54430);
var inst_54432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54433 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54435 = [inst_54430];
var inst_54436 = (new cljs.core.PersistentVector(null,1,(5),inst_54434,inst_54435,null));
var inst_54437 = ["lower-case",inst_54436,inst_54431];
var inst_54438 = cljs.core.PersistentHashMap.fromArrays(inst_54433,inst_54437);
var inst_54439 = [inst_54438,(10)];
var inst_54440 = (new cljs.core.PersistentVector(null,2,(5),inst_54432,inst_54439,null));
var inst_54441 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54440);
var _ = (function (){var statearr_54459 = state_54446;
(statearr_54459[(4)] = cljs.core.rest.call(null,(state_54446[(4)])));

return statearr_54459;
})();
var state_54446__$1 = (function (){var statearr_54460 = state_54446;
(statearr_54460[(7)] = inst_54441);

return statearr_54460;
})();
var statearr_54461_54475 = state_54446__$1;
(statearr_54461_54475[(2)] = inst_54431);

(statearr_54461_54475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto____0 = (function (){
var statearr_54462 = [null,null,null,null,null,null,null,null];
(statearr_54462[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto__);

(statearr_54462[(1)] = (1));

return statearr_54462;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto____1 = (function (state_54446){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54463){var ex__2729__auto__ = e54463;
var statearr_54464_54476 = state_54446;
(statearr_54464_54476[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54446[(4)]))){
var statearr_54465_54477 = state_54446;
(statearr_54465_54477[(1)] = cljs.core.first.call(null,(state_54446[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54478 = state_54446;
state_54446 = G__54478;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto__ = function(state_54446){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto____1.call(this,state_54446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54466 = f__2749__auto__.call(null);
(statearr_54466[(6)] = c__2748__auto__);

return statearr_54466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54508){
var state_val_54509 = (state_54508[(1)]);
if((state_val_54509 === (7))){
var state_54508__$1 = state_54508;
var statearr_54510_54529 = state_54508__$1;
(statearr_54510_54529[(2)] = str);

(statearr_54510_54529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54509 === (1))){
var state_54508__$1 = state_54508;
var statearr_54511_54530 = state_54508__$1;
(statearr_54511_54530[(2)] = null);

(statearr_54511_54530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54509 === (4))){
var inst_54479 = (state_54508[(2)]);
var state_54508__$1 = state_54508;
var statearr_54512_54531 = state_54508__$1;
(statearr_54512_54531[(2)] = inst_54479);

(statearr_54512_54531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54509 === (6))){
var state_54508__$1 = state_54508;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54508__$1,(9),str);
} else {
if((state_val_54509 === (3))){
var inst_54506 = (state_54508[(2)]);
var state_54508__$1 = state_54508;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54508__$1,inst_54506);
} else {
if((state_val_54509 === (2))){
var _ = (function (){var statearr_54514 = state_54508;
(statearr_54514[(4)] = cljs.core.cons.call(null,(5),(state_54508[(4)])));

return statearr_54514;
})();
var inst_54485 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54508__$1 = state_54508;
if(inst_54485){
var statearr_54515_54532 = state_54508__$1;
(statearr_54515_54532[(1)] = (6));

} else {
var statearr_54516_54533 = state_54508__$1;
(statearr_54516_54533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54509 === (9))){
var inst_54488 = (state_54508[(2)]);
var inst_54489 = fluree.db.util.async.throw_err.call(null,inst_54488);
var state_54508__$1 = state_54508;
var statearr_54517_54534 = state_54508__$1;
(statearr_54517_54534[(2)] = inst_54489);

(statearr_54517_54534[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54509 === (5))){
var _ = (function (){var statearr_54518 = state_54508;
(statearr_54518[(4)] = cljs.core.rest.call(null,(state_54508[(4)])));

return statearr_54518;
})();
var state_54508__$1 = state_54508;
var ex54513 = (state_54508__$1[(2)]);
var statearr_54519_54535 = state_54508__$1;
(statearr_54519_54535[(5)] = ex54513);


if((ex54513 instanceof Error)){
var statearr_54520_54536 = state_54508__$1;
(statearr_54520_54536[(1)] = (4));

(statearr_54520_54536[(5)] = null);

} else {
throw ex54513;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54509 === (8))){
var inst_54492 = (state_54508[(2)]);
var inst_54493 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_54492);
var inst_54494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54495 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54497 = [inst_54492];
var inst_54498 = (new cljs.core.PersistentVector(null,1,(5),inst_54496,inst_54497,null));
var inst_54499 = ["upper-case",inst_54498,inst_54493];
var inst_54500 = cljs.core.PersistentHashMap.fromArrays(inst_54495,inst_54499);
var inst_54501 = [inst_54500,(10)];
var inst_54502 = (new cljs.core.PersistentVector(null,2,(5),inst_54494,inst_54501,null));
var inst_54503 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54502);
var _ = (function (){var statearr_54521 = state_54508;
(statearr_54521[(4)] = cljs.core.rest.call(null,(state_54508[(4)])));

return statearr_54521;
})();
var state_54508__$1 = (function (){var statearr_54522 = state_54508;
(statearr_54522[(7)] = inst_54503);

return statearr_54522;
})();
var statearr_54523_54537 = state_54508__$1;
(statearr_54523_54537[(2)] = inst_54493);

(statearr_54523_54537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto____0 = (function (){
var statearr_54524 = [null,null,null,null,null,null,null,null];
(statearr_54524[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto__);

(statearr_54524[(1)] = (1));

return statearr_54524;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto____1 = (function (state_54508){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54508);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54525){var ex__2729__auto__ = e54525;
var statearr_54526_54538 = state_54508;
(statearr_54526_54538[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54508[(4)]))){
var statearr_54527_54539 = state_54508;
(statearr_54527_54539[(1)] = cljs.core.first.call(null,(state_54508[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54540 = state_54508;
state_54508 = G__54540;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto__ = function(state_54508){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto____1.call(this,state_54508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54528 = f__2749__auto__.call(null);
(statearr_54528[(6)] = c__2748__auto__);

return statearr_54528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54542 = arguments.length;
switch (G__54542) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54570){
var state_val_54571 = (state_54570[(1)]);
if((state_val_54571 === (1))){
var state_54570__$1 = state_54570;
var statearr_54572_54588 = state_54570__$1;
(statearr_54572_54588[(2)] = null);

(statearr_54572_54588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54571 === (2))){
var _ = (function (){var statearr_54573 = state_54570;
(statearr_54573[(4)] = cljs.core.cons.call(null,(5),(state_54570[(4)])));

return statearr_54573;
})();
var inst_54552 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_54570__$1 = state_54570;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54570__$1,(6),inst_54552);
} else {
if((state_val_54571 === (3))){
var inst_54568 = (state_54570[(2)]);
var state_54570__$1 = state_54570;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54570__$1,inst_54568);
} else {
if((state_val_54571 === (4))){
var inst_54543 = (state_54570[(2)]);
var state_54570__$1 = state_54570;
var statearr_54575_54589 = state_54570__$1;
(statearr_54575_54589[(2)] = inst_54543);

(statearr_54575_54589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54571 === (5))){
var _ = (function (){var statearr_54576 = state_54570;
(statearr_54576[(4)] = cljs.core.rest.call(null,(state_54570[(4)])));

return statearr_54576;
})();
var state_54570__$1 = state_54570;
var ex54574 = (state_54570__$1[(2)]);
var statearr_54577_54590 = state_54570__$1;
(statearr_54577_54590[(5)] = ex54574);


if((ex54574 instanceof Error)){
var statearr_54578_54591 = state_54570__$1;
(statearr_54578_54591[(1)] = (4));

(statearr_54578_54591[(5)] = null);

} else {
throw ex54574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54571 === (6))){
var inst_54554 = (state_54570[(2)]);
var inst_54555 = fluree.db.util.async.throw_err.call(null,inst_54554);
var inst_54556 = cljs.core.nth.call(null,inst_54555,(0),null);
var inst_54557 = cljs.core.nth.call(null,inst_54555,(1),null);
var inst_54558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54559 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54560 = ["?s","?ctx",inst_54556];
var inst_54561 = cljs.core.PersistentHashMap.fromArrays(inst_54559,inst_54560);
var inst_54562 = ((10) + inst_54557);
var inst_54563 = [inst_54561,inst_54562];
var inst_54564 = (new cljs.core.PersistentVector(null,2,(5),inst_54558,inst_54563,null));
var inst_54565 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54564);
var _ = (function (){var statearr_54579 = state_54570;
(statearr_54579[(4)] = cljs.core.rest.call(null,(state_54570[(4)])));

return statearr_54579;
})();
var state_54570__$1 = (function (){var statearr_54580 = state_54570;
(statearr_54580[(7)] = inst_54565);

return statearr_54580;
})();
var statearr_54581_54592 = state_54570__$1;
(statearr_54581_54592[(2)] = inst_54556);

(statearr_54581_54592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_54582 = [null,null,null,null,null,null,null,null];
(statearr_54582[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_54582[(1)] = (1));

return statearr_54582;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_54570){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54570);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54583){var ex__2729__auto__ = e54583;
var statearr_54584_54593 = state_54570;
(statearr_54584_54593[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54570[(4)]))){
var statearr_54585_54594 = state_54570;
(statearr_54585_54594[(1)] = cljs.core.first.call(null,(state_54570[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54595 = state_54570;
state_54570 = G__54595;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_54570){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_54570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54586 = f__2749__auto__.call(null);
(statearr_54586[(6)] = c__2748__auto__);

return statearr_54586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54597 = arguments.length;
switch (G__54597) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54635){
var state_val_54636 = (state_54635[(1)]);
if((state_val_54636 === (7))){
var inst_54628 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54635__$1 = state_54635;
var statearr_54637_54657 = state_54635__$1;
(statearr_54637_54657[(2)] = inst_54628);

(statearr_54637_54657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54636 === (1))){
var state_54635__$1 = state_54635;
var statearr_54638_54658 = state_54635__$1;
(statearr_54638_54658[(2)] = null);

(statearr_54638_54658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54636 === (4))){
var inst_54598 = (state_54635[(2)]);
var state_54635__$1 = state_54635;
var statearr_54639_54659 = state_54635__$1;
(statearr_54639_54659[(2)] = inst_54598);

(statearr_54639_54659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54636 === (6))){
var inst_54609 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_54635__$1 = state_54635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54635__$1,(10),inst_54609);
} else {
if((state_val_54636 === (3))){
var inst_54633 = (state_54635[(2)]);
var state_54635__$1 = state_54635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54635__$1,inst_54633);
} else {
if((state_val_54636 === (2))){
var _ = (function (){var statearr_54641 = state_54635;
(statearr_54641[(4)] = cljs.core.cons.call(null,(5),(state_54635[(4)])));

return statearr_54641;
})();
var inst_54604 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54635__$1 = state_54635;
if(cljs.core.truth_(inst_54604)){
var statearr_54642_54660 = state_54635__$1;
(statearr_54642_54660[(1)] = (6));

} else {
var statearr_54643_54661 = state_54635__$1;
(statearr_54643_54661[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54636 === (9))){
var inst_54615 = (state_54635[(2)]);
var inst_54616 = fluree.db.util.async.throw_err.call(null,inst_54615);
var inst_54617 = cljs.core.nth.call(null,inst_54616,(0),null);
var inst_54618 = cljs.core.nth.call(null,inst_54616,(1),null);
var inst_54619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54620 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54621 = ["?p","?ctx",inst_54617];
var inst_54622 = cljs.core.PersistentHashMap.fromArrays(inst_54620,inst_54621);
var inst_54623 = ((10) + inst_54618);
var inst_54624 = [inst_54622,inst_54623];
var inst_54625 = (new cljs.core.PersistentVector(null,2,(5),inst_54619,inst_54624,null));
var inst_54626 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54625);
var state_54635__$1 = (function (){var statearr_54644 = state_54635;
(statearr_54644[(7)] = inst_54626);

return statearr_54644;
})();
var statearr_54645_54662 = state_54635__$1;
(statearr_54645_54662[(2)] = inst_54617);

(statearr_54645_54662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54636 === (5))){
var _ = (function (){var statearr_54646 = state_54635;
(statearr_54646[(4)] = cljs.core.rest.call(null,(state_54635[(4)])));

return statearr_54646;
})();
var state_54635__$1 = state_54635;
var ex54640 = (state_54635__$1[(2)]);
var statearr_54647_54663 = state_54635__$1;
(statearr_54647_54663[(5)] = ex54640);


if((ex54640 instanceof Error)){
var statearr_54648_54664 = state_54635__$1;
(statearr_54648_54664[(1)] = (4));

(statearr_54648_54664[(5)] = null);

} else {
throw ex54640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54636 === (10))){
var inst_54611 = (state_54635[(2)]);
var inst_54612 = fluree.db.util.async.throw_err.call(null,inst_54611);
var inst_54613 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_54612);
var state_54635__$1 = state_54635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54635__$1,(9),inst_54613);
} else {
if((state_val_54636 === (8))){
var inst_54630 = (state_54635[(2)]);
var _ = (function (){var statearr_54649 = state_54635;
(statearr_54649[(4)] = cljs.core.rest.call(null,(state_54635[(4)])));

return statearr_54649;
})();
var state_54635__$1 = state_54635;
var statearr_54650_54665 = state_54635__$1;
(statearr_54650_54665[(2)] = inst_54630);

(statearr_54650_54665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_54651 = [null,null,null,null,null,null,null,null];
(statearr_54651[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_54651[(1)] = (1));

return statearr_54651;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_54635){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54652){var ex__2729__auto__ = e54652;
var statearr_54653_54666 = state_54635;
(statearr_54653_54666[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54635[(4)]))){
var statearr_54654_54667 = state_54635;
(statearr_54654_54667[(1)] = cljs.core.first.call(null,(state_54635[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54668 = state_54635;
state_54635 = G__54668;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_54635){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_54635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54655 = f__2749__auto__.call(null);
(statearr_54655[(6)] = c__2748__auto__);

return statearr_54655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54717 = arguments.length;
var i__4830__auto___54718 = (0);
while(true){
if((i__4830__auto___54718 < len__4829__auto___54717)){
args__4835__auto__.push((arguments[i__4830__auto___54718]));

var G__54719 = (i__4830__auto___54718 + (1));
i__4830__auto___54718 = G__54719;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54700){
var state_val_54701 = (state_54700[(1)]);
if((state_val_54701 === (1))){
var state_54700__$1 = state_54700;
var statearr_54702_54720 = state_54700__$1;
(statearr_54702_54720[(2)] = null);

(statearr_54702_54720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54701 === (2))){
var _ = (function (){var statearr_54703 = state_54700;
(statearr_54703[(4)] = cljs.core.cons.call(null,(5),(state_54700[(4)])));

return statearr_54703;
})();
var inst_54677 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54700__$1 = state_54700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54700__$1,(6),inst_54677);
} else {
if((state_val_54701 === (3))){
var inst_54698 = (state_54700[(2)]);
var state_54700__$1 = state_54700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54700__$1,inst_54698);
} else {
if((state_val_54701 === (4))){
var inst_54671 = (state_54700[(2)]);
var state_54700__$1 = state_54700;
var statearr_54705_54721 = state_54700__$1;
(statearr_54705_54721[(2)] = inst_54671);

(statearr_54705_54721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54701 === (5))){
var _ = (function (){var statearr_54706 = state_54700;
(statearr_54706[(4)] = cljs.core.rest.call(null,(state_54700[(4)])));

return statearr_54706;
})();
var state_54700__$1 = state_54700;
var ex54704 = (state_54700__$1[(2)]);
var statearr_54707_54722 = state_54700__$1;
(statearr_54707_54722[(5)] = ex54704);


if((ex54704 instanceof Error)){
var statearr_54708_54723 = state_54700__$1;
(statearr_54708_54723[(1)] = (4));

(statearr_54708_54723[(5)] = null);

} else {
throw ex54704;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54701 === (6))){
var inst_54679 = (state_54700[(2)]);
var inst_54680 = fluree.db.util.async.throw_err.call(null,inst_54679);
var inst_54681 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_54680);
var inst_54682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54683 = [inst_54680];
var inst_54684 = (new cljs.core.PersistentVector(null,1,(5),inst_54682,inst_54683,null));
var inst_54685 = cljs.core.count.call(null,inst_54684);
var inst_54686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54687 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54689 = [inst_54680];
var inst_54690 = (new cljs.core.PersistentVector(null,1,(5),inst_54688,inst_54689,null));
var inst_54691 = ["and",inst_54690,inst_54681];
var inst_54692 = cljs.core.PersistentHashMap.fromArrays(inst_54687,inst_54691);
var inst_54693 = [inst_54692,inst_54685];
var inst_54694 = (new cljs.core.PersistentVector(null,2,(5),inst_54686,inst_54693,null));
var inst_54695 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54694);
var _ = (function (){var statearr_54709 = state_54700;
(statearr_54709[(4)] = cljs.core.rest.call(null,(state_54700[(4)])));

return statearr_54709;
})();
var state_54700__$1 = (function (){var statearr_54710 = state_54700;
(statearr_54710[(7)] = inst_54695);

return statearr_54710;
})();
var statearr_54711_54724 = state_54700__$1;
(statearr_54711_54724[(2)] = inst_54681);

(statearr_54711_54724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_54712 = [null,null,null,null,null,null,null,null];
(statearr_54712[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_54712[(1)] = (1));

return statearr_54712;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_54700){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54713){var ex__2729__auto__ = e54713;
var statearr_54714_54725 = state_54700;
(statearr_54714_54725[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54700[(4)]))){
var statearr_54715_54726 = state_54700;
(statearr_54715_54726[(1)] = cljs.core.first.call(null,(state_54700[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54727 = state_54700;
state_54700 = G__54727;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_54700){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_54700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54716 = f__2749__auto__.call(null);
(statearr_54716[(6)] = c__2748__auto__);

return statearr_54716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54669){
var G__54670 = cljs.core.first.call(null,seq54669);
var seq54669__$1 = cljs.core.next.call(null,seq54669);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54670,seq54669__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54776 = arguments.length;
var i__4830__auto___54777 = (0);
while(true){
if((i__4830__auto___54777 < len__4829__auto___54776)){
args__4835__auto__.push((arguments[i__4830__auto___54777]));

var G__54778 = (i__4830__auto___54777 + (1));
i__4830__auto___54777 = G__54778;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54759){
var state_val_54760 = (state_54759[(1)]);
if((state_val_54760 === (1))){
var state_54759__$1 = state_54759;
var statearr_54761_54779 = state_54759__$1;
(statearr_54761_54779[(2)] = null);

(statearr_54761_54779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54760 === (2))){
var _ = (function (){var statearr_54762 = state_54759;
(statearr_54762[(4)] = cljs.core.cons.call(null,(5),(state_54759[(4)])));

return statearr_54762;
})();
var inst_54736 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54759__$1 = state_54759;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54759__$1,(6),inst_54736);
} else {
if((state_val_54760 === (3))){
var inst_54757 = (state_54759[(2)]);
var state_54759__$1 = state_54759;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54759__$1,inst_54757);
} else {
if((state_val_54760 === (4))){
var inst_54730 = (state_54759[(2)]);
var state_54759__$1 = state_54759;
var statearr_54764_54780 = state_54759__$1;
(statearr_54764_54780[(2)] = inst_54730);

(statearr_54764_54780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54760 === (5))){
var _ = (function (){var statearr_54765 = state_54759;
(statearr_54765[(4)] = cljs.core.rest.call(null,(state_54759[(4)])));

return statearr_54765;
})();
var state_54759__$1 = state_54759;
var ex54763 = (state_54759__$1[(2)]);
var statearr_54766_54781 = state_54759__$1;
(statearr_54766_54781[(5)] = ex54763);


if((ex54763 instanceof Error)){
var statearr_54767_54782 = state_54759__$1;
(statearr_54767_54782[(1)] = (4));

(statearr_54767_54782[(5)] = null);

} else {
throw ex54763;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54760 === (6))){
var inst_54738 = (state_54759[(2)]);
var inst_54739 = fluree.db.util.async.throw_err.call(null,inst_54738);
var inst_54740 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_54739);
var inst_54741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54742 = [inst_54739];
var inst_54743 = (new cljs.core.PersistentVector(null,1,(5),inst_54741,inst_54742,null));
var inst_54744 = cljs.core.count.call(null,inst_54743);
var inst_54745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54746 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54748 = [inst_54739];
var inst_54749 = (new cljs.core.PersistentVector(null,1,(5),inst_54747,inst_54748,null));
var inst_54750 = ["or",inst_54749,inst_54740];
var inst_54751 = cljs.core.PersistentHashMap.fromArrays(inst_54746,inst_54750);
var inst_54752 = [inst_54751,inst_54744];
var inst_54753 = (new cljs.core.PersistentVector(null,2,(5),inst_54745,inst_54752,null));
var inst_54754 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54753);
var _ = (function (){var statearr_54768 = state_54759;
(statearr_54768[(4)] = cljs.core.rest.call(null,(state_54759[(4)])));

return statearr_54768;
})();
var state_54759__$1 = (function (){var statearr_54769 = state_54759;
(statearr_54769[(7)] = inst_54754);

return statearr_54769;
})();
var statearr_54770_54783 = state_54759__$1;
(statearr_54770_54783[(2)] = inst_54740);

(statearr_54770_54783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_54771 = [null,null,null,null,null,null,null,null];
(statearr_54771[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_54771[(1)] = (1));

return statearr_54771;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_54759){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54759);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54772){var ex__2729__auto__ = e54772;
var statearr_54773_54784 = state_54759;
(statearr_54773_54784[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54759[(4)]))){
var statearr_54774_54785 = state_54759;
(statearr_54774_54785[(1)] = cljs.core.first.call(null,(state_54759[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54786 = state_54759;
state_54759 = G__54786;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_54759){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_54759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54775 = f__2749__auto__.call(null);
(statearr_54775[(6)] = c__2748__auto__);

return statearr_54775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54728){
var G__54729 = cljs.core.first.call(null,seq54728);
var seq54728__$1 = cljs.core.next.call(null,seq54728);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54729,seq54728__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54824){
var state_val_54825 = (state_54824[(1)]);
if((state_val_54825 === (7))){
var inst_54800 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54824__$1 = state_54824;
if(inst_54800){
var statearr_54826_54849 = state_54824__$1;
(statearr_54826_54849[(1)] = (10));

} else {
var statearr_54827_54850 = state_54824__$1;
(statearr_54827_54850[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (1))){
var state_54824__$1 = state_54824;
var statearr_54828_54851 = state_54824__$1;
(statearr_54828_54851[(2)] = null);

(statearr_54828_54851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (4))){
var inst_54787 = (state_54824[(2)]);
var state_54824__$1 = state_54824;
var statearr_54829_54852 = state_54824__$1;
(statearr_54829_54852[(2)] = inst_54787);

(statearr_54829_54852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (13))){
var inst_54803 = (state_54824[(2)]);
var inst_54804 = fluree.db.util.async.throw_err.call(null,inst_54803);
var state_54824__$1 = state_54824;
var statearr_54830_54853 = state_54824__$1;
(statearr_54830_54853[(2)] = inst_54804);

(statearr_54830_54853[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (6))){
var inst_54795 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_54824__$1 = state_54824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54824__$1,(9),inst_54795);
} else {
if((state_val_54825 === (3))){
var inst_54822 = (state_54824[(2)]);
var state_54824__$1 = state_54824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54824__$1,inst_54822);
} else {
if((state_val_54825 === (12))){
var inst_54807 = (state_54824[(2)]);
var state_54824__$1 = state_54824;
var statearr_54831_54854 = state_54824__$1;
(statearr_54831_54854[(2)] = inst_54807);

(statearr_54831_54854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (2))){
var _ = (function (){var statearr_54832 = state_54824;
(statearr_54832[(4)] = cljs.core.cons.call(null,(5),(state_54824[(4)])));

return statearr_54832;
})();
var inst_54793 = cljs.core.vector_QMARK_.call(null,coll);
var state_54824__$1 = state_54824;
if(inst_54793){
var statearr_54833_54855 = state_54824__$1;
(statearr_54833_54855[(1)] = (6));

} else {
var statearr_54834_54856 = state_54824__$1;
(statearr_54834_54856[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (11))){
var state_54824__$1 = state_54824;
var statearr_54836_54857 = state_54824__$1;
(statearr_54836_54857[(2)] = coll);

(statearr_54836_54857[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (9))){
var inst_54797 = (state_54824[(2)]);
var inst_54798 = fluree.db.util.async.throw_err.call(null,inst_54797);
var state_54824__$1 = state_54824;
var statearr_54837_54858 = state_54824__$1;
(statearr_54837_54858[(2)] = inst_54798);

(statearr_54837_54858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (5))){
var _ = (function (){var statearr_54838 = state_54824;
(statearr_54838[(4)] = cljs.core.rest.call(null,(state_54824[(4)])));

return statearr_54838;
})();
var state_54824__$1 = state_54824;
var ex54835 = (state_54824__$1[(2)]);
var statearr_54839_54859 = state_54824__$1;
(statearr_54839_54859[(5)] = ex54835);


if((ex54835 instanceof Error)){
var statearr_54840_54860 = state_54824__$1;
(statearr_54840_54860[(1)] = (4));

(statearr_54840_54860[(5)] = null);

} else {
throw ex54835;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54825 === (10))){
var state_54824__$1 = state_54824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54824__$1,(13),coll);
} else {
if((state_val_54825 === (8))){
var inst_54809 = (state_54824[(2)]);
var inst_54810 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_54809);
var inst_54811 = cljs.core.count.call(null,inst_54810);
var inst_54812 = ((9) + inst_54811);
var inst_54813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54814 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54815 = ["count",inst_54809,inst_54811];
var inst_54816 = cljs.core.PersistentHashMap.fromArrays(inst_54814,inst_54815);
var inst_54817 = [inst_54816,inst_54812];
var inst_54818 = (new cljs.core.PersistentVector(null,2,(5),inst_54813,inst_54817,null));
var inst_54819 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54818);
var _ = (function (){var statearr_54841 = state_54824;
(statearr_54841[(4)] = cljs.core.rest.call(null,(state_54824[(4)])));

return statearr_54841;
})();
var state_54824__$1 = (function (){var statearr_54842 = state_54824;
(statearr_54842[(7)] = inst_54819);

return statearr_54842;
})();
var statearr_54843_54861 = state_54824__$1;
(statearr_54843_54861[(2)] = inst_54811);

(statearr_54843_54861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto____0 = (function (){
var statearr_54844 = [null,null,null,null,null,null,null,null];
(statearr_54844[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto__);

(statearr_54844[(1)] = (1));

return statearr_54844;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto____1 = (function (state_54824){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54845){var ex__2729__auto__ = e54845;
var statearr_54846_54862 = state_54824;
(statearr_54846_54862[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54824[(4)]))){
var statearr_54847_54863 = state_54824;
(statearr_54847_54863[(1)] = cljs.core.first.call(null,(state_54824[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54864 = state_54824;
state_54824 = G__54864;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto__ = function(state_54824){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto____1.call(this,state_54824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54848 = f__2749__auto__.call(null);
(statearr_54848[(6)] = c__2748__auto__);

return statearr_54848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_54914){
var state_val_54915 = (state_54914[(1)]);
if((state_val_54915 === (7))){
var state_54914__$1 = state_54914;
var statearr_54916_54949 = state_54914__$1;
(statearr_54916_54949[(2)] = subject);

(statearr_54916_54949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (1))){
var state_54914__$1 = state_54914;
var statearr_54917_54950 = state_54914__$1;
(statearr_54917_54950[(2)] = null);

(statearr_54917_54950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (4))){
var inst_54865 = (state_54914[(2)]);
var state_54914__$1 = state_54914;
var statearr_54918_54951 = state_54914__$1;
(statearr_54918_54951[(2)] = inst_54865);

(statearr_54918_54951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (15))){
var inst_54878 = (state_54914[(7)]);
var state_54914__$1 = state_54914;
var statearr_54919_54952 = state_54914__$1;
(statearr_54919_54952[(2)] = inst_54878);

(statearr_54919_54952[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (13))){
var inst_54882 = (state_54914[(2)]);
var inst_54883 = fluree.db.util.async.throw_err.call(null,inst_54882);
var state_54914__$1 = state_54914;
var statearr_54920_54953 = state_54914__$1;
(statearr_54920_54953[(2)] = inst_54883);

(statearr_54920_54953[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (6))){
var state_54914__$1 = state_54914;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54914__$1,(9),subject);
} else {
if((state_val_54915 === (17))){
var inst_54878 = (state_54914[(7)]);
var inst_54892 = cljs.core.first.call(null,inst_54878);
var state_54914__$1 = state_54914;
var statearr_54921_54954 = state_54914__$1;
(statearr_54921_54954[(2)] = inst_54892);

(statearr_54921_54954[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (3))){
var inst_54912 = (state_54914[(2)]);
var state_54914__$1 = state_54914;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54914__$1,inst_54912);
} else {
if((state_val_54915 === (12))){
var inst_54878 = (state_54914[(7)]);
var inst_54886 = (state_54914[(2)]);
var inst_54887 = cljs.core.vector_QMARK_.call(null,inst_54878);
var state_54914__$1 = (function (){var statearr_54922 = state_54914;
(statearr_54922[(8)] = inst_54886);

return statearr_54922;
})();
if(inst_54887){
var statearr_54923_54955 = state_54914__$1;
(statearr_54923_54955[(1)] = (14));

} else {
var statearr_54924_54956 = state_54914__$1;
(statearr_54924_54956[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (2))){
var _ = (function (){var statearr_54925 = state_54914;
(statearr_54925[(4)] = cljs.core.cons.call(null,(5),(state_54914[(4)])));

return statearr_54925;
})();
var inst_54871 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54914__$1 = state_54914;
if(inst_54871){
var statearr_54926_54957 = state_54914__$1;
(statearr_54926_54957[(1)] = (6));

} else {
var statearr_54927_54958 = state_54914__$1;
(statearr_54927_54958[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (19))){
var inst_54895 = (state_54914[(2)]);
var state_54914__$1 = state_54914;
var statearr_54928_54959 = state_54914__$1;
(statearr_54928_54959[(2)] = inst_54895);

(statearr_54928_54959[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (11))){
var state_54914__$1 = state_54914;
var statearr_54930_54960 = state_54914__$1;
(statearr_54930_54960[(2)] = pred);

(statearr_54930_54960[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (9))){
var inst_54874 = (state_54914[(2)]);
var inst_54875 = fluree.db.util.async.throw_err.call(null,inst_54874);
var state_54914__$1 = state_54914;
var statearr_54931_54961 = state_54914__$1;
(statearr_54931_54961[(2)] = inst_54875);

(statearr_54931_54961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (5))){
var _ = (function (){var statearr_54932 = state_54914;
(statearr_54932[(4)] = cljs.core.rest.call(null,(state_54914[(4)])));

return statearr_54932;
})();
var state_54914__$1 = state_54914;
var ex54929 = (state_54914__$1[(2)]);
var statearr_54933_54962 = state_54914__$1;
(statearr_54933_54962[(5)] = ex54929);


if((ex54929 instanceof Error)){
var statearr_54934_54963 = state_54914__$1;
(statearr_54934_54963[(1)] = (4));

(statearr_54934_54963[(5)] = null);

} else {
throw ex54929;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (14))){
var inst_54878 = (state_54914[(7)]);
var inst_54889 = cljs.core.count.call(null,inst_54878);
var inst_54890 = cljs.core._EQ_.call(null,(1),inst_54889);
var state_54914__$1 = state_54914;
if(inst_54890){
var statearr_54935_54964 = state_54914__$1;
(statearr_54935_54964[(1)] = (17));

} else {
var statearr_54936_54965 = state_54914__$1;
(statearr_54936_54965[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (16))){
var inst_54886 = (state_54914[(8)]);
var inst_54878 = (state_54914[(7)]);
var inst_54898 = (state_54914[(2)]);
var inst_54899 = fluree.db.dbfunctions.internal.get.call(null,inst_54898,inst_54886);
var inst_54900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54901 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54903 = [inst_54878,inst_54886];
var inst_54904 = (new cljs.core.PersistentVector(null,2,(5),inst_54902,inst_54903,null));
var inst_54905 = ["get",inst_54904,inst_54899];
var inst_54906 = cljs.core.PersistentHashMap.fromArrays(inst_54901,inst_54905);
var inst_54907 = [inst_54906,(10)];
var inst_54908 = (new cljs.core.PersistentVector(null,2,(5),inst_54900,inst_54907,null));
var inst_54909 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54908);
var _ = (function (){var statearr_54937 = state_54914;
(statearr_54937[(4)] = cljs.core.rest.call(null,(state_54914[(4)])));

return statearr_54937;
})();
var state_54914__$1 = (function (){var statearr_54938 = state_54914;
(statearr_54938[(9)] = inst_54909);

return statearr_54938;
})();
var statearr_54939_54966 = state_54914__$1;
(statearr_54939_54966[(2)] = inst_54899);

(statearr_54939_54966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (10))){
var state_54914__$1 = state_54914;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54914__$1,(13),pred);
} else {
if((state_val_54915 === (18))){
var inst_54878 = (state_54914[(7)]);
var state_54914__$1 = state_54914;
var statearr_54940_54967 = state_54914__$1;
(statearr_54940_54967[(2)] = inst_54878);

(statearr_54940_54967[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54915 === (8))){
var inst_54878 = (state_54914[(2)]);
var inst_54879 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_54914__$1 = (function (){var statearr_54941 = state_54914;
(statearr_54941[(7)] = inst_54878);

return statearr_54941;
})();
if(inst_54879){
var statearr_54942_54968 = state_54914__$1;
(statearr_54942_54968[(1)] = (10));

} else {
var statearr_54943_54969 = state_54914__$1;
(statearr_54943_54969[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto____0 = (function (){
var statearr_54944 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54944[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto__);

(statearr_54944[(1)] = (1));

return statearr_54944;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto____1 = (function (state_54914){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_54914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e54945){var ex__2729__auto__ = e54945;
var statearr_54946_54970 = state_54914;
(statearr_54946_54970[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_54914[(4)]))){
var statearr_54947_54971 = state_54914;
(statearr_54947_54971[(1)] = cljs.core.first.call(null,(state_54914[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54972 = state_54914;
state_54914 = G__54972;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto__ = function(state_54914){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto____1.call(this,state_54914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_54948 = f__2749__auto__.call(null);
(statearr_54948[(6)] = c__2748__auto__);

return statearr_54948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55011){
var state_val_55012 = (state_55011[(1)]);
if((state_val_55012 === (7))){
var inst_54979 = (state_55011[(7)]);
var state_55011__$1 = state_55011;
var statearr_55013_55037 = state_55011__$1;
(statearr_55013_55037[(2)] = inst_54979);

(statearr_55013_55037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (1))){
var state_55011__$1 = state_55011;
var statearr_55014_55038 = state_55011__$1;
(statearr_55014_55038[(2)] = null);

(statearr_55014_55038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (4))){
var inst_54973 = (state_55011[(2)]);
var state_55011__$1 = state_55011;
var statearr_55015_55039 = state_55011__$1;
(statearr_55015_55039[(2)] = inst_54973);

(statearr_55015_55039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (6))){
var inst_54981 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55011__$1 = state_55011;
var statearr_55016_55040 = state_55011__$1;
(statearr_55016_55040[(2)] = inst_54981);

(statearr_55016_55040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (3))){
var inst_55009 = (state_55011[(2)]);
var state_55011__$1 = state_55011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55011__$1,inst_55009);
} else {
if((state_val_55012 === (12))){
var inst_54991 = (state_55011[(2)]);
var inst_54992 = fluree.db.util.async.throw_err.call(null,inst_54991);
var inst_54993 = cljs.core.nth.call(null,inst_54992,(0),null);
var inst_54994 = cljs.core.nth.call(null,inst_54992,(1),null);
var inst_54995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54996 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54997 = ["?pO","?ctx",inst_54993];
var inst_54998 = cljs.core.PersistentHashMap.fromArrays(inst_54996,inst_54997);
var inst_54999 = ((10) + inst_54994);
var inst_55000 = [inst_54998,inst_54999];
var inst_55001 = (new cljs.core.PersistentVector(null,2,(5),inst_54995,inst_55000,null));
var inst_55002 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55001);
var state_55011__$1 = (function (){var statearr_55017 = state_55011;
(statearr_55017[(8)] = inst_55002);

return statearr_55017;
})();
var statearr_55018_55041 = state_55011__$1;
(statearr_55018_55041[(2)] = inst_54993);

(statearr_55018_55041[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (2))){
var inst_54979 = (state_55011[(7)]);
var _ = (function (){var statearr_55019 = state_55011;
(statearr_55019[(4)] = cljs.core.cons.call(null,(5),(state_55011[(4)])));

return statearr_55019;
})();
var inst_54979__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55011__$1 = (function (){var statearr_55020 = state_55011;
(statearr_55020[(7)] = inst_54979__$1);

return statearr_55020;
})();
if(cljs.core.truth_(inst_54979__$1)){
var statearr_55021_55042 = state_55011__$1;
(statearr_55021_55042[(1)] = (6));

} else {
var statearr_55022_55043 = state_55011__$1;
(statearr_55022_55043[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (11))){
var inst_55006 = (state_55011[(2)]);
var _ = (function (){var statearr_55024 = state_55011;
(statearr_55024[(4)] = cljs.core.rest.call(null,(state_55011[(4)])));

return statearr_55024;
})();
var state_55011__$1 = state_55011;
var statearr_55025_55044 = state_55011__$1;
(statearr_55025_55044[(2)] = inst_55006);

(statearr_55025_55044[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (9))){
var inst_54989 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_55011__$1 = state_55011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55011__$1,(12),inst_54989);
} else {
if((state_val_55012 === (5))){
var _ = (function (){var statearr_55026 = state_55011;
(statearr_55026[(4)] = cljs.core.rest.call(null,(state_55011[(4)])));

return statearr_55026;
})();
var state_55011__$1 = state_55011;
var ex55023 = (state_55011__$1[(2)]);
var statearr_55027_55045 = state_55011__$1;
(statearr_55027_55045[(5)] = ex55023);


if((ex55023 instanceof Error)){
var statearr_55028_55046 = state_55011__$1;
(statearr_55028_55046[(1)] = (4));

(statearr_55028_55046[(5)] = null);

} else {
throw ex55023;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (10))){
var inst_55004 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55011__$1 = state_55011;
var statearr_55029_55047 = state_55011__$1;
(statearr_55029_55047[(2)] = inst_55004);

(statearr_55029_55047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55012 === (8))){
var inst_54984 = (state_55011[(2)]);
var state_55011__$1 = state_55011;
if(cljs.core.truth_(inst_54984)){
var statearr_55030_55048 = state_55011__$1;
(statearr_55030_55048[(1)] = (9));

} else {
var statearr_55031_55049 = state_55011__$1;
(statearr_55031_55049[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto____0 = (function (){
var statearr_55032 = [null,null,null,null,null,null,null,null,null];
(statearr_55032[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto__);

(statearr_55032[(1)] = (1));

return statearr_55032;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto____1 = (function (state_55011){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55033){var ex__2729__auto__ = e55033;
var statearr_55034_55050 = state_55011;
(statearr_55034_55050[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55011[(4)]))){
var statearr_55035_55051 = state_55011;
(statearr_55035_55051[(1)] = cljs.core.first.call(null,(state_55011[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55052 = state_55011;
state_55011 = G__55052;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto__ = function(state_55011){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto____1.call(this,state_55011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55036 = f__2749__auto__.call(null);
(statearr_55036[(6)] = c__2748__auto__);

return statearr_55036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55104){
var state_val_55105 = (state_55104[(1)]);
if((state_val_55105 === (7))){
var state_55104__$1 = state_55104;
var statearr_55106_55139 = state_55104__$1;
(statearr_55106_55139[(2)] = subject);

(statearr_55106_55139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (1))){
var state_55104__$1 = state_55104;
var statearr_55107_55140 = state_55104__$1;
(statearr_55107_55140[(2)] = null);

(statearr_55107_55140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (4))){
var inst_55053 = (state_55104[(2)]);
var state_55104__$1 = state_55104;
var statearr_55108_55141 = state_55104__$1;
(statearr_55108_55141[(2)] = inst_55053);

(statearr_55108_55141[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (15))){
var inst_55066 = (state_55104[(7)]);
var state_55104__$1 = state_55104;
var statearr_55109_55142 = state_55104__$1;
(statearr_55109_55142[(2)] = inst_55066);

(statearr_55109_55142[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (13))){
var inst_55070 = (state_55104[(2)]);
var inst_55071 = fluree.db.util.async.throw_err.call(null,inst_55070);
var state_55104__$1 = state_55104;
var statearr_55110_55143 = state_55104__$1;
(statearr_55110_55143[(2)] = inst_55071);

(statearr_55110_55143[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (6))){
var state_55104__$1 = state_55104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55104__$1,(9),subject);
} else {
if((state_val_55105 === (17))){
var inst_55066 = (state_55104[(7)]);
var inst_55080 = cljs.core.first.call(null,inst_55066);
var state_55104__$1 = state_55104;
var statearr_55111_55144 = state_55104__$1;
(statearr_55111_55144[(2)] = inst_55080);

(statearr_55111_55144[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (3))){
var inst_55102 = (state_55104[(2)]);
var state_55104__$1 = state_55104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55104__$1,inst_55102);
} else {
if((state_val_55105 === (12))){
var inst_55066 = (state_55104[(7)]);
var inst_55074 = (state_55104[(2)]);
var inst_55075 = cljs.core.vector_QMARK_.call(null,inst_55066);
var state_55104__$1 = (function (){var statearr_55112 = state_55104;
(statearr_55112[(8)] = inst_55074);

return statearr_55112;
})();
if(inst_55075){
var statearr_55113_55145 = state_55104__$1;
(statearr_55113_55145[(1)] = (14));

} else {
var statearr_55114_55146 = state_55104__$1;
(statearr_55114_55146[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (2))){
var _ = (function (){var statearr_55115 = state_55104;
(statearr_55115[(4)] = cljs.core.cons.call(null,(5),(state_55104[(4)])));

return statearr_55115;
})();
var inst_55059 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55104__$1 = state_55104;
if(inst_55059){
var statearr_55116_55147 = state_55104__$1;
(statearr_55116_55147[(1)] = (6));

} else {
var statearr_55117_55148 = state_55104__$1;
(statearr_55117_55148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (19))){
var inst_55083 = (state_55104[(2)]);
var state_55104__$1 = state_55104;
var statearr_55118_55149 = state_55104__$1;
(statearr_55118_55149[(2)] = inst_55083);

(statearr_55118_55149[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (11))){
var state_55104__$1 = state_55104;
var statearr_55120_55150 = state_55104__$1;
(statearr_55120_55150[(2)] = path);

(statearr_55120_55150[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (9))){
var inst_55062 = (state_55104[(2)]);
var inst_55063 = fluree.db.util.async.throw_err.call(null,inst_55062);
var state_55104__$1 = state_55104;
var statearr_55121_55151 = state_55104__$1;
(statearr_55121_55151[(2)] = inst_55063);

(statearr_55121_55151[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (5))){
var _ = (function (){var statearr_55122 = state_55104;
(statearr_55122[(4)] = cljs.core.rest.call(null,(state_55104[(4)])));

return statearr_55122;
})();
var state_55104__$1 = state_55104;
var ex55119 = (state_55104__$1[(2)]);
var statearr_55123_55152 = state_55104__$1;
(statearr_55123_55152[(5)] = ex55119);


if((ex55119 instanceof Error)){
var statearr_55124_55153 = state_55104__$1;
(statearr_55124_55153[(1)] = (4));

(statearr_55124_55153[(5)] = null);

} else {
throw ex55119;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (14))){
var inst_55066 = (state_55104[(7)]);
var inst_55077 = cljs.core.count.call(null,inst_55066);
var inst_55078 = cljs.core._EQ_.call(null,(1),inst_55077);
var state_55104__$1 = state_55104;
if(inst_55078){
var statearr_55125_55154 = state_55104__$1;
(statearr_55125_55154[(1)] = (17));

} else {
var statearr_55126_55155 = state_55104__$1;
(statearr_55126_55155[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (16))){
var inst_55066 = (state_55104[(7)]);
var inst_55074 = (state_55104[(8)]);
var inst_55086 = (state_55104[(2)]);
var inst_55087 = fluree.db.dbfunctions.internal.get_all.call(null,inst_55086,inst_55074);
var inst_55088 = cljs.core.count.call(null,inst_55074);
var inst_55089 = ((9) + inst_55088);
var inst_55090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55091 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55093 = [inst_55066,inst_55074];
var inst_55094 = (new cljs.core.PersistentVector(null,2,(5),inst_55092,inst_55093,null));
var inst_55095 = ["get-all",inst_55094,inst_55087];
var inst_55096 = cljs.core.PersistentHashMap.fromArrays(inst_55091,inst_55095);
var inst_55097 = [inst_55096,inst_55089];
var inst_55098 = (new cljs.core.PersistentVector(null,2,(5),inst_55090,inst_55097,null));
var inst_55099 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55098);
var _ = (function (){var statearr_55127 = state_55104;
(statearr_55127[(4)] = cljs.core.rest.call(null,(state_55104[(4)])));

return statearr_55127;
})();
var state_55104__$1 = (function (){var statearr_55128 = state_55104;
(statearr_55128[(9)] = inst_55099);

return statearr_55128;
})();
var statearr_55129_55156 = state_55104__$1;
(statearr_55129_55156[(2)] = inst_55087);

(statearr_55129_55156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (10))){
var state_55104__$1 = state_55104;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55104__$1,(13),path);
} else {
if((state_val_55105 === (18))){
var inst_55066 = (state_55104[(7)]);
var state_55104__$1 = state_55104;
var statearr_55130_55157 = state_55104__$1;
(statearr_55130_55157[(2)] = inst_55066);

(statearr_55130_55157[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (8))){
var inst_55066 = (state_55104[(2)]);
var inst_55067 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55104__$1 = (function (){var statearr_55131 = state_55104;
(statearr_55131[(7)] = inst_55066);

return statearr_55131;
})();
if(inst_55067){
var statearr_55132_55158 = state_55104__$1;
(statearr_55132_55158[(1)] = (10));

} else {
var statearr_55133_55159 = state_55104__$1;
(statearr_55133_55159[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto____0 = (function (){
var statearr_55134 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55134[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto__);

(statearr_55134[(1)] = (1));

return statearr_55134;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto____1 = (function (state_55104){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55135){var ex__2729__auto__ = e55135;
var statearr_55136_55160 = state_55104;
(statearr_55136_55160[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55104[(4)]))){
var statearr_55137_55161 = state_55104;
(statearr_55137_55161[(1)] = cljs.core.first.call(null,(state_55104[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55162 = state_55104;
state_55104 = G__55162;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto__ = function(state_55104){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto____1.call(this,state_55104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55138 = f__2749__auto__.call(null);
(statearr_55138[(6)] = c__2748__auto__);

return statearr_55138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55201){
var state_val_55202 = (state_55201[(1)]);
if((state_val_55202 === (7))){
var state_55201__$1 = state_55201;
var statearr_55203_55227 = state_55201__$1;
(statearr_55203_55227[(2)] = subject);

(statearr_55203_55227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (1))){
var state_55201__$1 = state_55201;
var statearr_55204_55228 = state_55201__$1;
(statearr_55204_55228[(2)] = null);

(statearr_55204_55228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (4))){
var inst_55163 = (state_55201[(2)]);
var state_55201__$1 = state_55201;
var statearr_55205_55229 = state_55201__$1;
(statearr_55205_55229[(2)] = inst_55163);

(statearr_55205_55229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (13))){
var inst_55180 = (state_55201[(2)]);
var inst_55181 = fluree.db.util.async.throw_err.call(null,inst_55180);
var state_55201__$1 = state_55201;
var statearr_55206_55230 = state_55201__$1;
(statearr_55206_55230[(2)] = inst_55181);

(statearr_55206_55230[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (6))){
var state_55201__$1 = state_55201;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55201__$1,(9),subject);
} else {
if((state_val_55202 === (3))){
var inst_55199 = (state_55201[(2)]);
var state_55201__$1 = state_55201;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55201__$1,inst_55199);
} else {
if((state_val_55202 === (12))){
var inst_55176 = (state_55201[(7)]);
var inst_55184 = (state_55201[(2)]);
var inst_55185 = fluree.db.dbfunctions.internal.get_in.call(null,inst_55176,inst_55184);
var inst_55186 = cljs.core.count.call(null,inst_55184);
var inst_55187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55188 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55190 = [inst_55176,inst_55184];
var inst_55191 = (new cljs.core.PersistentVector(null,2,(5),inst_55189,inst_55190,null));
var inst_55192 = ["get-in",inst_55191,inst_55185];
var inst_55193 = cljs.core.PersistentHashMap.fromArrays(inst_55188,inst_55192);
var inst_55194 = [inst_55193,inst_55186];
var inst_55195 = (new cljs.core.PersistentVector(null,2,(5),inst_55187,inst_55194,null));
var inst_55196 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55195);
var _ = (function (){var statearr_55207 = state_55201;
(statearr_55207[(4)] = cljs.core.rest.call(null,(state_55201[(4)])));

return statearr_55207;
})();
var state_55201__$1 = (function (){var statearr_55208 = state_55201;
(statearr_55208[(8)] = inst_55196);

return statearr_55208;
})();
var statearr_55209_55231 = state_55201__$1;
(statearr_55209_55231[(2)] = inst_55185);

(statearr_55209_55231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (2))){
var _ = (function (){var statearr_55210 = state_55201;
(statearr_55210[(4)] = cljs.core.cons.call(null,(5),(state_55201[(4)])));

return statearr_55210;
})();
var inst_55169 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55201__$1 = state_55201;
if(inst_55169){
var statearr_55211_55232 = state_55201__$1;
(statearr_55211_55232[(1)] = (6));

} else {
var statearr_55212_55233 = state_55201__$1;
(statearr_55212_55233[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (11))){
var state_55201__$1 = state_55201;
var statearr_55214_55234 = state_55201__$1;
(statearr_55214_55234[(2)] = path);

(statearr_55214_55234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (9))){
var inst_55172 = (state_55201[(2)]);
var inst_55173 = fluree.db.util.async.throw_err.call(null,inst_55172);
var state_55201__$1 = state_55201;
var statearr_55215_55235 = state_55201__$1;
(statearr_55215_55235[(2)] = inst_55173);

(statearr_55215_55235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (5))){
var _ = (function (){var statearr_55216 = state_55201;
(statearr_55216[(4)] = cljs.core.rest.call(null,(state_55201[(4)])));

return statearr_55216;
})();
var state_55201__$1 = state_55201;
var ex55213 = (state_55201__$1[(2)]);
var statearr_55217_55236 = state_55201__$1;
(statearr_55217_55236[(5)] = ex55213);


if((ex55213 instanceof Error)){
var statearr_55218_55237 = state_55201__$1;
(statearr_55218_55237[(1)] = (4));

(statearr_55218_55237[(5)] = null);

} else {
throw ex55213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55202 === (10))){
var state_55201__$1 = state_55201;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55201__$1,(13),path);
} else {
if((state_val_55202 === (8))){
var inst_55176 = (state_55201[(2)]);
var inst_55177 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55201__$1 = (function (){var statearr_55219 = state_55201;
(statearr_55219[(7)] = inst_55176);

return statearr_55219;
})();
if(inst_55177){
var statearr_55220_55238 = state_55201__$1;
(statearr_55220_55238[(1)] = (10));

} else {
var statearr_55221_55239 = state_55201__$1;
(statearr_55221_55239[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto____0 = (function (){
var statearr_55222 = [null,null,null,null,null,null,null,null,null];
(statearr_55222[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto__);

(statearr_55222[(1)] = (1));

return statearr_55222;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto____1 = (function (state_55201){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55201);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55223){var ex__2729__auto__ = e55223;
var statearr_55224_55240 = state_55201;
(statearr_55224_55240[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55201[(4)]))){
var statearr_55225_55241 = state_55201;
(statearr_55225_55241[(1)] = cljs.core.first.call(null,(state_55201[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55242 = state_55201;
state_55201 = G__55242;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto__ = function(state_55201){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto____1.call(this,state_55201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55226 = f__2749__auto__.call(null);
(statearr_55226[(6)] = c__2748__auto__);

return statearr_55226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55287){
var state_val_55288 = (state_55287[(1)]);
if((state_val_55288 === (7))){
var state_55287__$1 = state_55287;
var statearr_55289_55318 = state_55287__$1;
(statearr_55289_55318[(2)] = coll);

(statearr_55289_55318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (1))){
var state_55287__$1 = state_55287;
var statearr_55290_55319 = state_55287__$1;
(statearr_55290_55319[(2)] = null);

(statearr_55290_55319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (4))){
var inst_55243 = (state_55287[(2)]);
var state_55287__$1 = state_55287;
var statearr_55291_55320 = state_55287__$1;
(statearr_55291_55320[(2)] = inst_55243);

(statearr_55291_55320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (15))){
var inst_55263 = (state_55287[(7)]);
var inst_55271 = (state_55287[(2)]);
var inst_55272 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_55263,inst_55271);
var inst_55273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55274 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55276 = [inst_55263,inst_55271];
var inst_55277 = (new cljs.core.PersistentVector(null,2,(5),inst_55275,inst_55276,null));
var inst_55278 = ["contains?",inst_55277,inst_55272];
var inst_55279 = cljs.core.PersistentHashMap.fromArrays(inst_55274,inst_55278);
var inst_55280 = [inst_55279,(10)];
var inst_55281 = (new cljs.core.PersistentVector(null,2,(5),inst_55273,inst_55280,null));
var inst_55282 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55281);
var _ = (function (){var statearr_55292 = state_55287;
(statearr_55292[(4)] = cljs.core.rest.call(null,(state_55287[(4)])));

return statearr_55292;
})();
var state_55287__$1 = (function (){var statearr_55293 = state_55287;
(statearr_55293[(8)] = inst_55282);

return statearr_55293;
})();
var statearr_55294_55321 = state_55287__$1;
(statearr_55294_55321[(2)] = inst_55272);

(statearr_55294_55321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (13))){
var state_55287__$1 = state_55287;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55287__$1,(16),key);
} else {
if((state_val_55288 === (6))){
var state_55287__$1 = state_55287;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55287__$1,(9),coll);
} else {
if((state_val_55288 === (3))){
var inst_55285 = (state_55287[(2)]);
var state_55287__$1 = state_55287;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55287__$1,inst_55285);
} else {
if((state_val_55288 === (12))){
var inst_55263 = (state_55287[(2)]);
var inst_55264 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_55287__$1 = (function (){var statearr_55295 = state_55287;
(statearr_55295[(7)] = inst_55263);

return statearr_55295;
})();
if(inst_55264){
var statearr_55296_55322 = state_55287__$1;
(statearr_55296_55322[(1)] = (13));

} else {
var statearr_55297_55323 = state_55287__$1;
(statearr_55297_55323[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (2))){
var _ = (function (){var statearr_55298 = state_55287;
(statearr_55298[(4)] = cljs.core.cons.call(null,(5),(state_55287[(4)])));

return statearr_55298;
})();
var inst_55249 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55287__$1 = state_55287;
if(inst_55249){
var statearr_55299_55324 = state_55287__$1;
(statearr_55299_55324[(1)] = (6));

} else {
var statearr_55300_55325 = state_55287__$1;
(statearr_55300_55325[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (11))){
var inst_55256 = (state_55287[(9)]);
var inst_55260 = cljs.core.flatten.call(null,inst_55256);
var inst_55261 = cljs.core.set.call(null,inst_55260);
var state_55287__$1 = state_55287;
var statearr_55302_55326 = state_55287__$1;
(statearr_55302_55326[(2)] = inst_55261);

(statearr_55302_55326[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (9))){
var inst_55252 = (state_55287[(2)]);
var inst_55253 = fluree.db.util.async.throw_err.call(null,inst_55252);
var state_55287__$1 = state_55287;
var statearr_55303_55327 = state_55287__$1;
(statearr_55303_55327[(2)] = inst_55253);

(statearr_55303_55327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (5))){
var _ = (function (){var statearr_55304 = state_55287;
(statearr_55304[(4)] = cljs.core.rest.call(null,(state_55287[(4)])));

return statearr_55304;
})();
var state_55287__$1 = state_55287;
var ex55301 = (state_55287__$1[(2)]);
var statearr_55305_55328 = state_55287__$1;
(statearr_55305_55328[(5)] = ex55301);


if((ex55301 instanceof Error)){
var statearr_55306_55329 = state_55287__$1;
(statearr_55306_55329[(1)] = (4));

(statearr_55306_55329[(5)] = null);

} else {
throw ex55301;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (14))){
var state_55287__$1 = state_55287;
var statearr_55307_55330 = state_55287__$1;
(statearr_55307_55330[(2)] = key);

(statearr_55307_55330[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (16))){
var inst_55267 = (state_55287[(2)]);
var inst_55268 = fluree.db.util.async.throw_err.call(null,inst_55267);
var state_55287__$1 = state_55287;
var statearr_55308_55331 = state_55287__$1;
(statearr_55308_55331[(2)] = inst_55268);

(statearr_55308_55331[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (10))){
var inst_55256 = (state_55287[(9)]);
var state_55287__$1 = state_55287;
var statearr_55309_55332 = state_55287__$1;
(statearr_55309_55332[(2)] = inst_55256);

(statearr_55309_55332[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55288 === (8))){
var inst_55256 = (state_55287[(9)]);
var inst_55256__$1 = (state_55287[(2)]);
var inst_55257 = cljs.core.set_QMARK_.call(null,inst_55256__$1);
var state_55287__$1 = (function (){var statearr_55310 = state_55287;
(statearr_55310[(9)] = inst_55256__$1);

return statearr_55310;
})();
if(inst_55257){
var statearr_55311_55333 = state_55287__$1;
(statearr_55311_55333[(1)] = (10));

} else {
var statearr_55312_55334 = state_55287__$1;
(statearr_55312_55334[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_55313 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55313[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto__);

(statearr_55313[(1)] = (1));

return statearr_55313;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto____1 = (function (state_55287){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55287);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55314){var ex__2729__auto__ = e55314;
var statearr_55315_55335 = state_55287;
(statearr_55315_55335[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55287[(4)]))){
var statearr_55316_55336 = state_55287;
(statearr_55316_55336[(1)] = cljs.core.first.call(null,(state_55287[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55337 = state_55287;
state_55287 = G__55337;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto__ = function(state_55287){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto____1.call(this,state_55287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55317 = f__2749__auto__.call(null);
(statearr_55317[(6)] = c__2748__auto__);

return statearr_55317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55409 = arguments.length;
var i__4830__auto___55410 = (0);
while(true){
if((i__4830__auto___55410 < len__4829__auto___55409)){
args__4835__auto__.push((arguments[i__4830__auto___55410]));

var G__55411 = (i__4830__auto___55410 + (1));
i__4830__auto___55410 = G__55411;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55383){
var state_val_55384 = (state_55383[(1)]);
if((state_val_55384 === (7))){
var inst_55349 = (state_55383[(7)]);
var inst_55353 = cljs.core.first.call(null,inst_55349);
var inst_55354 = cljs.core.coll_QMARK_.call(null,inst_55353);
var state_55383__$1 = state_55383;
var statearr_55385_55412 = state_55383__$1;
(statearr_55385_55412[(2)] = inst_55354);

(statearr_55385_55412[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (1))){
var state_55383__$1 = state_55383;
var statearr_55386_55413 = state_55383__$1;
(statearr_55386_55413[(2)] = null);

(statearr_55386_55413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (4))){
var inst_55340 = (state_55383[(2)]);
var state_55383__$1 = state_55383;
var statearr_55387_55414 = state_55383__$1;
(statearr_55387_55414[(2)] = inst_55340);

(statearr_55387_55414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (6))){
var inst_55349 = (state_55383[(7)]);
var inst_55351 = (state_55383[(8)]);
var inst_55348 = (state_55383[(2)]);
var inst_55349__$1 = fluree.db.util.async.throw_err.call(null,inst_55348);
var inst_55350 = cljs.core.count.call(null,inst_55349__$1);
var inst_55351__$1 = cljs.core._EQ_.call(null,(1),inst_55350);
var state_55383__$1 = (function (){var statearr_55388 = state_55383;
(statearr_55388[(7)] = inst_55349__$1);

(statearr_55388[(8)] = inst_55351__$1);

return statearr_55388;
})();
if(inst_55351__$1){
var statearr_55389_55415 = state_55383__$1;
(statearr_55389_55415[(1)] = (7));

} else {
var statearr_55390_55416 = state_55383__$1;
(statearr_55390_55416[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (3))){
var inst_55381 = (state_55383[(2)]);
var state_55383__$1 = state_55383;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55383__$1,inst_55381);
} else {
if((state_val_55384 === (12))){
var inst_55362 = (state_55383[(2)]);
var inst_55363 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_55362);
var inst_55364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55365 = [inst_55362];
var inst_55366 = (new cljs.core.PersistentVector(null,1,(5),inst_55364,inst_55365,null));
var inst_55367 = cljs.core.count.call(null,inst_55366);
var inst_55368 = ((9) + inst_55367);
var inst_55369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55370 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55372 = [inst_55362];
var inst_55373 = (new cljs.core.PersistentVector(null,1,(5),inst_55371,inst_55372,null));
var inst_55374 = ["hash-set",inst_55373,inst_55363];
var inst_55375 = cljs.core.PersistentHashMap.fromArrays(inst_55370,inst_55374);
var inst_55376 = [inst_55375,inst_55368];
var inst_55377 = (new cljs.core.PersistentVector(null,2,(5),inst_55369,inst_55376,null));
var inst_55378 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55377);
var _ = (function (){var statearr_55391 = state_55383;
(statearr_55391[(4)] = cljs.core.rest.call(null,(state_55383[(4)])));

return statearr_55391;
})();
var state_55383__$1 = (function (){var statearr_55392 = state_55383;
(statearr_55392[(9)] = inst_55378);

return statearr_55392;
})();
var statearr_55393_55417 = state_55383__$1;
(statearr_55393_55417[(2)] = inst_55363);

(statearr_55393_55417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (2))){
var _ = (function (){var statearr_55394 = state_55383;
(statearr_55394[(4)] = cljs.core.cons.call(null,(5),(state_55383[(4)])));

return statearr_55394;
})();
var inst_55346 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55383__$1 = state_55383;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55383__$1,(6),inst_55346);
} else {
if((state_val_55384 === (11))){
var inst_55349 = (state_55383[(7)]);
var state_55383__$1 = state_55383;
var statearr_55396_55418 = state_55383__$1;
(statearr_55396_55418[(2)] = inst_55349);

(statearr_55396_55418[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (9))){
var inst_55357 = (state_55383[(2)]);
var state_55383__$1 = state_55383;
if(cljs.core.truth_(inst_55357)){
var statearr_55397_55419 = state_55383__$1;
(statearr_55397_55419[(1)] = (10));

} else {
var statearr_55398_55420 = state_55383__$1;
(statearr_55398_55420[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (5))){
var _ = (function (){var statearr_55399 = state_55383;
(statearr_55399[(4)] = cljs.core.rest.call(null,(state_55383[(4)])));

return statearr_55399;
})();
var state_55383__$1 = state_55383;
var ex55395 = (state_55383__$1[(2)]);
var statearr_55400_55421 = state_55383__$1;
(statearr_55400_55421[(5)] = ex55395);


if((ex55395 instanceof Error)){
var statearr_55401_55422 = state_55383__$1;
(statearr_55401_55422[(1)] = (4));

(statearr_55401_55422[(5)] = null);

} else {
throw ex55395;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (10))){
var inst_55349 = (state_55383[(7)]);
var inst_55359 = cljs.core.first.call(null,inst_55349);
var state_55383__$1 = state_55383;
var statearr_55402_55423 = state_55383__$1;
(statearr_55402_55423[(2)] = inst_55359);

(statearr_55402_55423[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55384 === (8))){
var inst_55351 = (state_55383[(8)]);
var state_55383__$1 = state_55383;
var statearr_55403_55424 = state_55383__$1;
(statearr_55403_55424[(2)] = inst_55351);

(statearr_55403_55424[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55404 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55404[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55404[(1)] = (1));

return statearr_55404;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55383){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55383);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55405){var ex__2729__auto__ = e55405;
var statearr_55406_55425 = state_55383;
(statearr_55406_55425[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55383[(4)]))){
var statearr_55407_55426 = state_55383;
(statearr_55407_55426[(1)] = cljs.core.first.call(null,(state_55383[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55427 = state_55383;
state_55383 = G__55427;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55383){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55408 = f__2749__auto__.call(null);
(statearr_55408[(6)] = c__2748__auto__);

return statearr_55408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55338){
var G__55339 = cljs.core.first.call(null,seq55338);
var seq55338__$1 = cljs.core.next.call(null,seq55338);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55339,seq55338__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55477 = arguments.length;
var i__4830__auto___55478 = (0);
while(true){
if((i__4830__auto___55478 < len__4829__auto___55477)){
args__4835__auto__.push((arguments[i__4830__auto___55478]));

var G__55479 = (i__4830__auto___55478 + (1));
i__4830__auto___55478 = G__55479;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55460){
var state_val_55461 = (state_55460[(1)]);
if((state_val_55461 === (1))){
var state_55460__$1 = state_55460;
var statearr_55462_55480 = state_55460__$1;
(statearr_55462_55480[(2)] = null);

(statearr_55462_55480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55461 === (2))){
var _ = (function (){var statearr_55463 = state_55460;
(statearr_55463[(4)] = cljs.core.cons.call(null,(5),(state_55460[(4)])));

return statearr_55463;
})();
var inst_55436 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55460__$1 = state_55460;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55460__$1,(6),inst_55436);
} else {
if((state_val_55461 === (3))){
var inst_55458 = (state_55460[(2)]);
var state_55460__$1 = state_55460;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55460__$1,inst_55458);
} else {
if((state_val_55461 === (4))){
var inst_55430 = (state_55460[(2)]);
var state_55460__$1 = state_55460;
var statearr_55465_55481 = state_55460__$1;
(statearr_55465_55481[(2)] = inst_55430);

(statearr_55465_55481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55461 === (5))){
var _ = (function (){var statearr_55466 = state_55460;
(statearr_55466[(4)] = cljs.core.rest.call(null,(state_55460[(4)])));

return statearr_55466;
})();
var state_55460__$1 = state_55460;
var ex55464 = (state_55460__$1[(2)]);
var statearr_55467_55482 = state_55460__$1;
(statearr_55467_55482[(5)] = ex55464);


if((ex55464 instanceof Error)){
var statearr_55468_55483 = state_55460__$1;
(statearr_55468_55483[(1)] = (4));

(statearr_55468_55483[(5)] = null);

} else {
throw ex55464;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55461 === (6))){
var inst_55438 = (state_55460[(2)]);
var inst_55439 = fluree.db.util.async.throw_err.call(null,inst_55438);
var inst_55440 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_55439);
var inst_55441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55442 = [inst_55439];
var inst_55443 = (new cljs.core.PersistentVector(null,1,(5),inst_55441,inst_55442,null));
var inst_55444 = cljs.core.count.call(null,inst_55443);
var inst_55445 = ((9) + inst_55444);
var inst_55446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55447 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55449 = [inst_55439];
var inst_55450 = (new cljs.core.PersistentVector(null,1,(5),inst_55448,inst_55449,null));
var inst_55451 = ["==",inst_55450,inst_55440];
var inst_55452 = cljs.core.PersistentHashMap.fromArrays(inst_55447,inst_55451);
var inst_55453 = [inst_55452,inst_55445];
var inst_55454 = (new cljs.core.PersistentVector(null,2,(5),inst_55446,inst_55453,null));
var inst_55455 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55454);
var _ = (function (){var statearr_55469 = state_55460;
(statearr_55469[(4)] = cljs.core.rest.call(null,(state_55460[(4)])));

return statearr_55469;
})();
var state_55460__$1 = (function (){var statearr_55470 = state_55460;
(statearr_55470[(7)] = inst_55455);

return statearr_55470;
})();
var statearr_55471_55484 = state_55460__$1;
(statearr_55471_55484[(2)] = inst_55440);

(statearr_55471_55484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55472 = [null,null,null,null,null,null,null,null];
(statearr_55472[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55472[(1)] = (1));

return statearr_55472;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55460){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55460);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55473){var ex__2729__auto__ = e55473;
var statearr_55474_55485 = state_55460;
(statearr_55474_55485[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55460[(4)]))){
var statearr_55475_55486 = state_55460;
(statearr_55475_55486[(1)] = cljs.core.first.call(null,(state_55460[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55487 = state_55460;
state_55460 = G__55487;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55460){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55476 = f__2749__auto__.call(null);
(statearr_55476[(6)] = c__2748__auto__);

return statearr_55476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55428){
var G__55429 = cljs.core.first.call(null,seq55428);
var seq55428__$1 = cljs.core.next.call(null,seq55428);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55429,seq55428__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55537 = arguments.length;
var i__4830__auto___55538 = (0);
while(true){
if((i__4830__auto___55538 < len__4829__auto___55537)){
args__4835__auto__.push((arguments[i__4830__auto___55538]));

var G__55539 = (i__4830__auto___55538 + (1));
i__4830__auto___55538 = G__55539;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55520){
var state_val_55521 = (state_55520[(1)]);
if((state_val_55521 === (1))){
var state_55520__$1 = state_55520;
var statearr_55522_55540 = state_55520__$1;
(statearr_55522_55540[(2)] = null);

(statearr_55522_55540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55521 === (2))){
var _ = (function (){var statearr_55523 = state_55520;
(statearr_55523[(4)] = cljs.core.cons.call(null,(5),(state_55520[(4)])));

return statearr_55523;
})();
var inst_55496 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55520__$1 = state_55520;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55520__$1,(6),inst_55496);
} else {
if((state_val_55521 === (3))){
var inst_55518 = (state_55520[(2)]);
var state_55520__$1 = state_55520;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55520__$1,inst_55518);
} else {
if((state_val_55521 === (4))){
var inst_55490 = (state_55520[(2)]);
var state_55520__$1 = state_55520;
var statearr_55525_55541 = state_55520__$1;
(statearr_55525_55541[(2)] = inst_55490);

(statearr_55525_55541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55521 === (5))){
var _ = (function (){var statearr_55526 = state_55520;
(statearr_55526[(4)] = cljs.core.rest.call(null,(state_55520[(4)])));

return statearr_55526;
})();
var state_55520__$1 = state_55520;
var ex55524 = (state_55520__$1[(2)]);
var statearr_55527_55542 = state_55520__$1;
(statearr_55527_55542[(5)] = ex55524);


if((ex55524 instanceof Error)){
var statearr_55528_55543 = state_55520__$1;
(statearr_55528_55543[(1)] = (4));

(statearr_55528_55543[(5)] = null);

} else {
throw ex55524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55521 === (6))){
var inst_55498 = (state_55520[(2)]);
var inst_55499 = fluree.db.util.async.throw_err.call(null,inst_55498);
var inst_55500 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_55499);
var inst_55501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55502 = [inst_55499];
var inst_55503 = (new cljs.core.PersistentVector(null,1,(5),inst_55501,inst_55502,null));
var inst_55504 = cljs.core.count.call(null,inst_55503);
var inst_55505 = ((9) + inst_55504);
var inst_55506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55507 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55509 = [inst_55499];
var inst_55510 = (new cljs.core.PersistentVector(null,1,(5),inst_55508,inst_55509,null));
var inst_55511 = [">",inst_55510,inst_55500];
var inst_55512 = cljs.core.PersistentHashMap.fromArrays(inst_55507,inst_55511);
var inst_55513 = [inst_55512,inst_55505];
var inst_55514 = (new cljs.core.PersistentVector(null,2,(5),inst_55506,inst_55513,null));
var inst_55515 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55514);
var _ = (function (){var statearr_55529 = state_55520;
(statearr_55529[(4)] = cljs.core.rest.call(null,(state_55520[(4)])));

return statearr_55529;
})();
var state_55520__$1 = (function (){var statearr_55530 = state_55520;
(statearr_55530[(7)] = inst_55515);

return statearr_55530;
})();
var statearr_55531_55544 = state_55520__$1;
(statearr_55531_55544[(2)] = inst_55500);

(statearr_55531_55544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55532 = [null,null,null,null,null,null,null,null];
(statearr_55532[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55532[(1)] = (1));

return statearr_55532;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55520){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55520);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55533){var ex__2729__auto__ = e55533;
var statearr_55534_55545 = state_55520;
(statearr_55534_55545[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55520[(4)]))){
var statearr_55535_55546 = state_55520;
(statearr_55535_55546[(1)] = cljs.core.first.call(null,(state_55520[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55547 = state_55520;
state_55520 = G__55547;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55520){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55536 = f__2749__auto__.call(null);
(statearr_55536[(6)] = c__2748__auto__);

return statearr_55536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55488){
var G__55489 = cljs.core.first.call(null,seq55488);
var seq55488__$1 = cljs.core.next.call(null,seq55488);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55489,seq55488__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55597 = arguments.length;
var i__4830__auto___55598 = (0);
while(true){
if((i__4830__auto___55598 < len__4829__auto___55597)){
args__4835__auto__.push((arguments[i__4830__auto___55598]));

var G__55599 = (i__4830__auto___55598 + (1));
i__4830__auto___55598 = G__55599;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55580){
var state_val_55581 = (state_55580[(1)]);
if((state_val_55581 === (1))){
var state_55580__$1 = state_55580;
var statearr_55582_55600 = state_55580__$1;
(statearr_55582_55600[(2)] = null);

(statearr_55582_55600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55581 === (2))){
var _ = (function (){var statearr_55583 = state_55580;
(statearr_55583[(4)] = cljs.core.cons.call(null,(5),(state_55580[(4)])));

return statearr_55583;
})();
var inst_55556 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55580__$1 = state_55580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55580__$1,(6),inst_55556);
} else {
if((state_val_55581 === (3))){
var inst_55578 = (state_55580[(2)]);
var state_55580__$1 = state_55580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55580__$1,inst_55578);
} else {
if((state_val_55581 === (4))){
var inst_55550 = (state_55580[(2)]);
var state_55580__$1 = state_55580;
var statearr_55585_55601 = state_55580__$1;
(statearr_55585_55601[(2)] = inst_55550);

(statearr_55585_55601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55581 === (5))){
var _ = (function (){var statearr_55586 = state_55580;
(statearr_55586[(4)] = cljs.core.rest.call(null,(state_55580[(4)])));

return statearr_55586;
})();
var state_55580__$1 = state_55580;
var ex55584 = (state_55580__$1[(2)]);
var statearr_55587_55602 = state_55580__$1;
(statearr_55587_55602[(5)] = ex55584);


if((ex55584 instanceof Error)){
var statearr_55588_55603 = state_55580__$1;
(statearr_55588_55603[(1)] = (4));

(statearr_55588_55603[(5)] = null);

} else {
throw ex55584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55581 === (6))){
var inst_55558 = (state_55580[(2)]);
var inst_55559 = fluree.db.util.async.throw_err.call(null,inst_55558);
var inst_55560 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_55559);
var inst_55561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55562 = [inst_55559];
var inst_55563 = (new cljs.core.PersistentVector(null,1,(5),inst_55561,inst_55562,null));
var inst_55564 = cljs.core.count.call(null,inst_55563);
var inst_55565 = ((9) + inst_55564);
var inst_55566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55567 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55569 = [inst_55559];
var inst_55570 = (new cljs.core.PersistentVector(null,1,(5),inst_55568,inst_55569,null));
var inst_55571 = ["<",inst_55570,inst_55560];
var inst_55572 = cljs.core.PersistentHashMap.fromArrays(inst_55567,inst_55571);
var inst_55573 = [inst_55572,inst_55565];
var inst_55574 = (new cljs.core.PersistentVector(null,2,(5),inst_55566,inst_55573,null));
var inst_55575 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55574);
var _ = (function (){var statearr_55589 = state_55580;
(statearr_55589[(4)] = cljs.core.rest.call(null,(state_55580[(4)])));

return statearr_55589;
})();
var state_55580__$1 = (function (){var statearr_55590 = state_55580;
(statearr_55590[(7)] = inst_55575);

return statearr_55590;
})();
var statearr_55591_55604 = state_55580__$1;
(statearr_55591_55604[(2)] = inst_55560);

(statearr_55591_55604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55592 = [null,null,null,null,null,null,null,null];
(statearr_55592[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55592[(1)] = (1));

return statearr_55592;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55580){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55593){var ex__2729__auto__ = e55593;
var statearr_55594_55605 = state_55580;
(statearr_55594_55605[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55580[(4)]))){
var statearr_55595_55606 = state_55580;
(statearr_55595_55606[(1)] = cljs.core.first.call(null,(state_55580[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55607 = state_55580;
state_55580 = G__55607;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55580){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55596 = f__2749__auto__.call(null);
(statearr_55596[(6)] = c__2748__auto__);

return statearr_55596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55548){
var G__55549 = cljs.core.first.call(null,seq55548);
var seq55548__$1 = cljs.core.next.call(null,seq55548);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55549,seq55548__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55657 = arguments.length;
var i__4830__auto___55658 = (0);
while(true){
if((i__4830__auto___55658 < len__4829__auto___55657)){
args__4835__auto__.push((arguments[i__4830__auto___55658]));

var G__55659 = (i__4830__auto___55658 + (1));
i__4830__auto___55658 = G__55659;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55640){
var state_val_55641 = (state_55640[(1)]);
if((state_val_55641 === (1))){
var state_55640__$1 = state_55640;
var statearr_55642_55660 = state_55640__$1;
(statearr_55642_55660[(2)] = null);

(statearr_55642_55660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55641 === (2))){
var _ = (function (){var statearr_55643 = state_55640;
(statearr_55643[(4)] = cljs.core.cons.call(null,(5),(state_55640[(4)])));

return statearr_55643;
})();
var inst_55616 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55640__$1 = state_55640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55640__$1,(6),inst_55616);
} else {
if((state_val_55641 === (3))){
var inst_55638 = (state_55640[(2)]);
var state_55640__$1 = state_55640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55640__$1,inst_55638);
} else {
if((state_val_55641 === (4))){
var inst_55610 = (state_55640[(2)]);
var state_55640__$1 = state_55640;
var statearr_55645_55661 = state_55640__$1;
(statearr_55645_55661[(2)] = inst_55610);

(statearr_55645_55661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55641 === (5))){
var _ = (function (){var statearr_55646 = state_55640;
(statearr_55646[(4)] = cljs.core.rest.call(null,(state_55640[(4)])));

return statearr_55646;
})();
var state_55640__$1 = state_55640;
var ex55644 = (state_55640__$1[(2)]);
var statearr_55647_55662 = state_55640__$1;
(statearr_55647_55662[(5)] = ex55644);


if((ex55644 instanceof Error)){
var statearr_55648_55663 = state_55640__$1;
(statearr_55648_55663[(1)] = (4));

(statearr_55648_55663[(5)] = null);

} else {
throw ex55644;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55641 === (6))){
var inst_55618 = (state_55640[(2)]);
var inst_55619 = fluree.db.util.async.throw_err.call(null,inst_55618);
var inst_55620 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_55619);
var inst_55621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55622 = [inst_55619];
var inst_55623 = (new cljs.core.PersistentVector(null,1,(5),inst_55621,inst_55622,null));
var inst_55624 = cljs.core.count.call(null,inst_55623);
var inst_55625 = ((9) + inst_55624);
var inst_55626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55627 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55629 = [inst_55619];
var inst_55630 = (new cljs.core.PersistentVector(null,1,(5),inst_55628,inst_55629,null));
var inst_55631 = ["<=",inst_55630,inst_55620];
var inst_55632 = cljs.core.PersistentHashMap.fromArrays(inst_55627,inst_55631);
var inst_55633 = [inst_55632,inst_55625];
var inst_55634 = (new cljs.core.PersistentVector(null,2,(5),inst_55626,inst_55633,null));
var inst_55635 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55634);
var _ = (function (){var statearr_55649 = state_55640;
(statearr_55649[(4)] = cljs.core.rest.call(null,(state_55640[(4)])));

return statearr_55649;
})();
var state_55640__$1 = (function (){var statearr_55650 = state_55640;
(statearr_55650[(7)] = inst_55635);

return statearr_55650;
})();
var statearr_55651_55664 = state_55640__$1;
(statearr_55651_55664[(2)] = inst_55620);

(statearr_55651_55664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55652 = [null,null,null,null,null,null,null,null];
(statearr_55652[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55652[(1)] = (1));

return statearr_55652;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55640){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55653){var ex__2729__auto__ = e55653;
var statearr_55654_55665 = state_55640;
(statearr_55654_55665[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55640[(4)]))){
var statearr_55655_55666 = state_55640;
(statearr_55655_55666[(1)] = cljs.core.first.call(null,(state_55640[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55667 = state_55640;
state_55640 = G__55667;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55640){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55656 = f__2749__auto__.call(null);
(statearr_55656[(6)] = c__2748__auto__);

return statearr_55656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55608){
var G__55609 = cljs.core.first.call(null,seq55608);
var seq55608__$1 = cljs.core.next.call(null,seq55608);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55609,seq55608__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55717 = arguments.length;
var i__4830__auto___55718 = (0);
while(true){
if((i__4830__auto___55718 < len__4829__auto___55717)){
args__4835__auto__.push((arguments[i__4830__auto___55718]));

var G__55719 = (i__4830__auto___55718 + (1));
i__4830__auto___55718 = G__55719;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55700){
var state_val_55701 = (state_55700[(1)]);
if((state_val_55701 === (1))){
var state_55700__$1 = state_55700;
var statearr_55702_55720 = state_55700__$1;
(statearr_55702_55720[(2)] = null);

(statearr_55702_55720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55701 === (2))){
var _ = (function (){var statearr_55703 = state_55700;
(statearr_55703[(4)] = cljs.core.cons.call(null,(5),(state_55700[(4)])));

return statearr_55703;
})();
var inst_55676 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55700__$1 = state_55700;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55700__$1,(6),inst_55676);
} else {
if((state_val_55701 === (3))){
var inst_55698 = (state_55700[(2)]);
var state_55700__$1 = state_55700;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55700__$1,inst_55698);
} else {
if((state_val_55701 === (4))){
var inst_55670 = (state_55700[(2)]);
var state_55700__$1 = state_55700;
var statearr_55705_55721 = state_55700__$1;
(statearr_55705_55721[(2)] = inst_55670);

(statearr_55705_55721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55701 === (5))){
var _ = (function (){var statearr_55706 = state_55700;
(statearr_55706[(4)] = cljs.core.rest.call(null,(state_55700[(4)])));

return statearr_55706;
})();
var state_55700__$1 = state_55700;
var ex55704 = (state_55700__$1[(2)]);
var statearr_55707_55722 = state_55700__$1;
(statearr_55707_55722[(5)] = ex55704);


if((ex55704 instanceof Error)){
var statearr_55708_55723 = state_55700__$1;
(statearr_55708_55723[(1)] = (4));

(statearr_55708_55723[(5)] = null);

} else {
throw ex55704;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55701 === (6))){
var inst_55678 = (state_55700[(2)]);
var inst_55679 = fluree.db.util.async.throw_err.call(null,inst_55678);
var inst_55680 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_55679);
var inst_55681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55682 = [inst_55679];
var inst_55683 = (new cljs.core.PersistentVector(null,1,(5),inst_55681,inst_55682,null));
var inst_55684 = cljs.core.count.call(null,inst_55683);
var inst_55685 = ((9) + inst_55684);
var inst_55686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55687 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55689 = [inst_55679];
var inst_55690 = (new cljs.core.PersistentVector(null,1,(5),inst_55688,inst_55689,null));
var inst_55691 = [">=",inst_55690,inst_55680];
var inst_55692 = cljs.core.PersistentHashMap.fromArrays(inst_55687,inst_55691);
var inst_55693 = [inst_55692,inst_55685];
var inst_55694 = (new cljs.core.PersistentVector(null,2,(5),inst_55686,inst_55693,null));
var inst_55695 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55694);
var _ = (function (){var statearr_55709 = state_55700;
(statearr_55709[(4)] = cljs.core.rest.call(null,(state_55700[(4)])));

return statearr_55709;
})();
var state_55700__$1 = (function (){var statearr_55710 = state_55700;
(statearr_55710[(7)] = inst_55695);

return statearr_55710;
})();
var statearr_55711_55724 = state_55700__$1;
(statearr_55711_55724[(2)] = inst_55680);

(statearr_55711_55724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55712 = [null,null,null,null,null,null,null,null];
(statearr_55712[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55712[(1)] = (1));

return statearr_55712;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55700){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55700);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55713){var ex__2729__auto__ = e55713;
var statearr_55714_55725 = state_55700;
(statearr_55714_55725[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55700[(4)]))){
var statearr_55715_55726 = state_55700;
(statearr_55715_55726[(1)] = cljs.core.first.call(null,(state_55700[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55727 = state_55700;
state_55700 = G__55727;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55700){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55716 = f__2749__auto__.call(null);
(statearr_55716[(6)] = c__2748__auto__);

return statearr_55716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55668){
var G__55669 = cljs.core.first.call(null,seq55668);
var seq55668__$1 = cljs.core.next.call(null,seq55668);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55669,seq55668__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55777 = arguments.length;
var i__4830__auto___55778 = (0);
while(true){
if((i__4830__auto___55778 < len__4829__auto___55777)){
args__4835__auto__.push((arguments[i__4830__auto___55778]));

var G__55779 = (i__4830__auto___55778 + (1));
i__4830__auto___55778 = G__55779;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55760){
var state_val_55761 = (state_55760[(1)]);
if((state_val_55761 === (1))){
var state_55760__$1 = state_55760;
var statearr_55762_55780 = state_55760__$1;
(statearr_55762_55780[(2)] = null);

(statearr_55762_55780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55761 === (2))){
var _ = (function (){var statearr_55763 = state_55760;
(statearr_55763[(4)] = cljs.core.cons.call(null,(5),(state_55760[(4)])));

return statearr_55763;
})();
var inst_55736 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55760__$1 = state_55760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55760__$1,(6),inst_55736);
} else {
if((state_val_55761 === (3))){
var inst_55758 = (state_55760[(2)]);
var state_55760__$1 = state_55760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55760__$1,inst_55758);
} else {
if((state_val_55761 === (4))){
var inst_55730 = (state_55760[(2)]);
var state_55760__$1 = state_55760;
var statearr_55765_55781 = state_55760__$1;
(statearr_55765_55781[(2)] = inst_55730);

(statearr_55765_55781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55761 === (5))){
var _ = (function (){var statearr_55766 = state_55760;
(statearr_55766[(4)] = cljs.core.rest.call(null,(state_55760[(4)])));

return statearr_55766;
})();
var state_55760__$1 = state_55760;
var ex55764 = (state_55760__$1[(2)]);
var statearr_55767_55782 = state_55760__$1;
(statearr_55767_55782[(5)] = ex55764);


if((ex55764 instanceof Error)){
var statearr_55768_55783 = state_55760__$1;
(statearr_55768_55783[(1)] = (4));

(statearr_55768_55783[(5)] = null);

} else {
throw ex55764;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55761 === (6))){
var inst_55738 = (state_55760[(2)]);
var inst_55739 = fluree.db.util.async.throw_err.call(null,inst_55738);
var inst_55740 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_55739);
var inst_55741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55742 = [inst_55739];
var inst_55743 = (new cljs.core.PersistentVector(null,1,(5),inst_55741,inst_55742,null));
var inst_55744 = cljs.core.count.call(null,inst_55743);
var inst_55745 = ((9) + inst_55744);
var inst_55746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55747 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55749 = [inst_55739];
var inst_55750 = (new cljs.core.PersistentVector(null,1,(5),inst_55748,inst_55749,null));
var inst_55751 = ["not=",inst_55750,inst_55740];
var inst_55752 = cljs.core.PersistentHashMap.fromArrays(inst_55747,inst_55751);
var inst_55753 = [inst_55752,inst_55745];
var inst_55754 = (new cljs.core.PersistentVector(null,2,(5),inst_55746,inst_55753,null));
var inst_55755 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55754);
var _ = (function (){var statearr_55769 = state_55760;
(statearr_55769[(4)] = cljs.core.rest.call(null,(state_55760[(4)])));

return statearr_55769;
})();
var state_55760__$1 = (function (){var statearr_55770 = state_55760;
(statearr_55770[(7)] = inst_55755);

return statearr_55770;
})();
var statearr_55771_55784 = state_55760__$1;
(statearr_55771_55784[(2)] = inst_55740);

(statearr_55771_55784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55772 = [null,null,null,null,null,null,null,null];
(statearr_55772[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55772[(1)] = (1));

return statearr_55772;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55760){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55773){var ex__2729__auto__ = e55773;
var statearr_55774_55785 = state_55760;
(statearr_55774_55785[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55760[(4)]))){
var statearr_55775_55786 = state_55760;
(statearr_55775_55786[(1)] = cljs.core.first.call(null,(state_55760[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55787 = state_55760;
state_55760 = G__55787;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55760){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55776 = f__2749__auto__.call(null);
(statearr_55776[(6)] = c__2748__auto__);

return statearr_55776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55728){
var G__55729 = cljs.core.first.call(null,seq55728);
var seq55728__$1 = cljs.core.next.call(null,seq55728);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55729,seq55728__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55837 = arguments.length;
var i__4830__auto___55838 = (0);
while(true){
if((i__4830__auto___55838 < len__4829__auto___55837)){
args__4835__auto__.push((arguments[i__4830__auto___55838]));

var G__55839 = (i__4830__auto___55838 + (1));
i__4830__auto___55838 = G__55839;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55820){
var state_val_55821 = (state_55820[(1)]);
if((state_val_55821 === (1))){
var state_55820__$1 = state_55820;
var statearr_55822_55840 = state_55820__$1;
(statearr_55822_55840[(2)] = null);

(statearr_55822_55840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (2))){
var _ = (function (){var statearr_55823 = state_55820;
(statearr_55823[(4)] = cljs.core.cons.call(null,(5),(state_55820[(4)])));

return statearr_55823;
})();
var inst_55796 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55820__$1 = state_55820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55820__$1,(6),inst_55796);
} else {
if((state_val_55821 === (3))){
var inst_55818 = (state_55820[(2)]);
var state_55820__$1 = state_55820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55820__$1,inst_55818);
} else {
if((state_val_55821 === (4))){
var inst_55790 = (state_55820[(2)]);
var state_55820__$1 = state_55820;
var statearr_55825_55841 = state_55820__$1;
(statearr_55825_55841[(2)] = inst_55790);

(statearr_55825_55841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (5))){
var _ = (function (){var statearr_55826 = state_55820;
(statearr_55826[(4)] = cljs.core.rest.call(null,(state_55820[(4)])));

return statearr_55826;
})();
var state_55820__$1 = state_55820;
var ex55824 = (state_55820__$1[(2)]);
var statearr_55827_55842 = state_55820__$1;
(statearr_55827_55842[(5)] = ex55824);


if((ex55824 instanceof Error)){
var statearr_55828_55843 = state_55820__$1;
(statearr_55828_55843[(1)] = (4));

(statearr_55828_55843[(5)] = null);

} else {
throw ex55824;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55821 === (6))){
var inst_55798 = (state_55820[(2)]);
var inst_55799 = fluree.db.util.async.throw_err.call(null,inst_55798);
var inst_55800 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_55799);
var inst_55801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55802 = [inst_55799];
var inst_55803 = (new cljs.core.PersistentVector(null,1,(5),inst_55801,inst_55802,null));
var inst_55804 = cljs.core.count.call(null,inst_55803);
var inst_55805 = ((9) + inst_55804);
var inst_55806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55807 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55809 = [inst_55799];
var inst_55810 = (new cljs.core.PersistentVector(null,1,(5),inst_55808,inst_55809,null));
var inst_55811 = ["max",inst_55810,inst_55800];
var inst_55812 = cljs.core.PersistentHashMap.fromArrays(inst_55807,inst_55811);
var inst_55813 = [inst_55812,inst_55805];
var inst_55814 = (new cljs.core.PersistentVector(null,2,(5),inst_55806,inst_55813,null));
var inst_55815 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55814);
var _ = (function (){var statearr_55829 = state_55820;
(statearr_55829[(4)] = cljs.core.rest.call(null,(state_55820[(4)])));

return statearr_55829;
})();
var state_55820__$1 = (function (){var statearr_55830 = state_55820;
(statearr_55830[(7)] = inst_55815);

return statearr_55830;
})();
var statearr_55831_55844 = state_55820__$1;
(statearr_55831_55844[(2)] = inst_55800);

(statearr_55831_55844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55832 = [null,null,null,null,null,null,null,null];
(statearr_55832[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55832[(1)] = (1));

return statearr_55832;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55820){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55833){var ex__2729__auto__ = e55833;
var statearr_55834_55845 = state_55820;
(statearr_55834_55845[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55820[(4)]))){
var statearr_55835_55846 = state_55820;
(statearr_55835_55846[(1)] = cljs.core.first.call(null,(state_55820[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55847 = state_55820;
state_55820 = G__55847;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55820){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55836 = f__2749__auto__.call(null);
(statearr_55836[(6)] = c__2748__auto__);

return statearr_55836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55788){
var G__55789 = cljs.core.first.call(null,seq55788);
var seq55788__$1 = cljs.core.next.call(null,seq55788);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55789,seq55788__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55897 = arguments.length;
var i__4830__auto___55898 = (0);
while(true){
if((i__4830__auto___55898 < len__4829__auto___55897)){
args__4835__auto__.push((arguments[i__4830__auto___55898]));

var G__55899 = (i__4830__auto___55898 + (1));
i__4830__auto___55898 = G__55899;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55880){
var state_val_55881 = (state_55880[(1)]);
if((state_val_55881 === (1))){
var state_55880__$1 = state_55880;
var statearr_55882_55900 = state_55880__$1;
(statearr_55882_55900[(2)] = null);

(statearr_55882_55900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55881 === (2))){
var _ = (function (){var statearr_55883 = state_55880;
(statearr_55883[(4)] = cljs.core.cons.call(null,(5),(state_55880[(4)])));

return statearr_55883;
})();
var inst_55856 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55880__$1 = state_55880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55880__$1,(6),inst_55856);
} else {
if((state_val_55881 === (3))){
var inst_55878 = (state_55880[(2)]);
var state_55880__$1 = state_55880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55880__$1,inst_55878);
} else {
if((state_val_55881 === (4))){
var inst_55850 = (state_55880[(2)]);
var state_55880__$1 = state_55880;
var statearr_55885_55901 = state_55880__$1;
(statearr_55885_55901[(2)] = inst_55850);

(statearr_55885_55901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55881 === (5))){
var _ = (function (){var statearr_55886 = state_55880;
(statearr_55886[(4)] = cljs.core.rest.call(null,(state_55880[(4)])));

return statearr_55886;
})();
var state_55880__$1 = state_55880;
var ex55884 = (state_55880__$1[(2)]);
var statearr_55887_55902 = state_55880__$1;
(statearr_55887_55902[(5)] = ex55884);


if((ex55884 instanceof Error)){
var statearr_55888_55903 = state_55880__$1;
(statearr_55888_55903[(1)] = (4));

(statearr_55888_55903[(5)] = null);

} else {
throw ex55884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55881 === (6))){
var inst_55858 = (state_55880[(2)]);
var inst_55859 = fluree.db.util.async.throw_err.call(null,inst_55858);
var inst_55860 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_55859);
var inst_55861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55862 = [inst_55859];
var inst_55863 = (new cljs.core.PersistentVector(null,1,(5),inst_55861,inst_55862,null));
var inst_55864 = cljs.core.count.call(null,inst_55863);
var inst_55865 = ((9) + inst_55864);
var inst_55866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55867 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55869 = [inst_55859];
var inst_55870 = (new cljs.core.PersistentVector(null,1,(5),inst_55868,inst_55869,null));
var inst_55871 = ["min",inst_55870,inst_55860];
var inst_55872 = cljs.core.PersistentHashMap.fromArrays(inst_55867,inst_55871);
var inst_55873 = [inst_55872,inst_55865];
var inst_55874 = (new cljs.core.PersistentVector(null,2,(5),inst_55866,inst_55873,null));
var inst_55875 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55874);
var _ = (function (){var statearr_55889 = state_55880;
(statearr_55889[(4)] = cljs.core.rest.call(null,(state_55880[(4)])));

return statearr_55889;
})();
var state_55880__$1 = (function (){var statearr_55890 = state_55880;
(statearr_55890[(7)] = inst_55875);

return statearr_55890;
})();
var statearr_55891_55904 = state_55880__$1;
(statearr_55891_55904[(2)] = inst_55860);

(statearr_55891_55904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55892 = [null,null,null,null,null,null,null,null];
(statearr_55892[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55892[(1)] = (1));

return statearr_55892;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55880){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55893){var ex__2729__auto__ = e55893;
var statearr_55894_55905 = state_55880;
(statearr_55894_55905[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55880[(4)]))){
var statearr_55895_55906 = state_55880;
(statearr_55895_55906[(1)] = cljs.core.first.call(null,(state_55880[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55907 = state_55880;
state_55880 = G__55907;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55880){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55896 = f__2749__auto__.call(null);
(statearr_55896[(6)] = c__2748__auto__);

return statearr_55896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55848){
var G__55849 = cljs.core.first.call(null,seq55848);
var seq55848__$1 = cljs.core.next.call(null,seq55848);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55849,seq55848__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55909 = arguments.length;
switch (G__55909) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_55954){
var state_val_55955 = (state_55954[(1)]);
if((state_val_55955 === (7))){
var state_55954__$1 = state_55954;
var statearr_55956_56093 = state_55954__$1;
(statearr_55956_56093[(2)] = query_map);

(statearr_55956_56093[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (1))){
var state_55954__$1 = state_55954;
var statearr_55957_56094 = state_55954__$1;
(statearr_55957_56094[(2)] = null);

(statearr_55957_56094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (4))){
var inst_55910 = (state_55954[(2)]);
var state_55954__$1 = state_55954;
var statearr_55958_56095 = state_55954__$1;
(statearr_55958_56095[(2)] = inst_55910);

(statearr_55958_56095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (13))){
var inst_55932 = (state_55954[(7)]);
var inst_55936 = (state_55954[(2)]);
var inst_55937 = fluree.db.util.async.throw_err.call(null,inst_55936);
var inst_55938 = cljs.core.nth.call(null,inst_55937,(0),null);
var inst_55939 = cljs.core.nth.call(null,inst_55937,(1),null);
var inst_55940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55941 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55943 = [inst_55932];
var inst_55944 = (new cljs.core.PersistentVector(null,1,(5),inst_55942,inst_55943,null));
var inst_55945 = ["query",inst_55944,inst_55938];
var inst_55946 = cljs.core.PersistentHashMap.fromArrays(inst_55941,inst_55945);
var inst_55947 = [inst_55946,inst_55939];
var inst_55948 = (new cljs.core.PersistentVector(null,2,(5),inst_55940,inst_55947,null));
var inst_55949 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55948);
var _ = (function (){var statearr_55959 = state_55954;
(statearr_55959[(4)] = cljs.core.rest.call(null,(state_55954[(4)])));

return statearr_55959;
})();
var state_55954__$1 = (function (){var statearr_55960 = state_55954;
(statearr_55960[(8)] = inst_55949);

return statearr_55960;
})();
var statearr_55961_56096 = state_55954__$1;
(statearr_55961_56096[(2)] = inst_55938);

(statearr_55961_56096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (6))){
var state_55954__$1 = state_55954;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55954__$1,(9),query_map);
} else {
if((state_val_55955 === (3))){
var inst_55952 = (state_55954[(2)]);
var state_55954__$1 = state_55954;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55954__$1,inst_55952);
} else {
if((state_val_55955 === (12))){
var inst_55932 = (state_55954[(7)]);
var inst_55932__$1 = (state_55954[(2)]);
var inst_55933 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55934 = fluree.db.dbfunctions.internal.query.call(null,inst_55933,inst_55932__$1);
var state_55954__$1 = (function (){var statearr_55962 = state_55954;
(statearr_55962[(7)] = inst_55932__$1);

return statearr_55962;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55954__$1,(13),inst_55934);
} else {
if((state_val_55955 === (2))){
var _ = (function (){var statearr_55963 = state_55954;
(statearr_55963[(4)] = cljs.core.cons.call(null,(5),(state_55954[(4)])));

return statearr_55963;
})();
var inst_55919 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_55954__$1 = state_55954;
if(inst_55919){
var statearr_55964_56097 = state_55954__$1;
(statearr_55964_56097[(1)] = (6));

} else {
var statearr_55965_56098 = state_55954__$1;
(statearr_55965_56098[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (11))){
var inst_55926 = (state_55954[(9)]);
var state_55954__$1 = state_55954;
var statearr_55967_56099 = state_55954__$1;
(statearr_55967_56099[(2)] = inst_55926);

(statearr_55967_56099[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (9))){
var inst_55922 = (state_55954[(2)]);
var inst_55923 = fluree.db.util.async.throw_err.call(null,inst_55922);
var state_55954__$1 = state_55954;
var statearr_55968_56100 = state_55954__$1;
(statearr_55968_56100[(2)] = inst_55923);

(statearr_55968_56100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (5))){
var _ = (function (){var statearr_55969 = state_55954;
(statearr_55969[(4)] = cljs.core.rest.call(null,(state_55954[(4)])));

return statearr_55969;
})();
var state_55954__$1 = state_55954;
var ex55966 = (state_55954__$1[(2)]);
var statearr_55970_56101 = state_55954__$1;
(statearr_55970_56101[(5)] = ex55966);


if((ex55966 instanceof Error)){
var statearr_55971_56102 = state_55954__$1;
(statearr_55971_56102[(1)] = (4));

(statearr_55971_56102[(5)] = null);

} else {
throw ex55966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (10))){
var inst_55926 = (state_55954[(9)]);
var inst_55929 = fluree.db.util.json.parse.call(null,inst_55926);
var state_55954__$1 = state_55954;
var statearr_55972_56103 = state_55954__$1;
(statearr_55972_56103[(2)] = inst_55929);

(statearr_55972_56103[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55955 === (8))){
var inst_55926 = (state_55954[(9)]);
var inst_55926__$1 = (state_55954[(2)]);
var inst_55927 = typeof inst_55926__$1 === 'string';
var state_55954__$1 = (function (){var statearr_55973 = state_55954;
(statearr_55973[(9)] = inst_55926__$1);

return statearr_55973;
})();
if(cljs.core.truth_(inst_55927)){
var statearr_55974_56104 = state_55954__$1;
(statearr_55974_56104[(1)] = (10));

} else {
var statearr_55975_56105 = state_55954__$1;
(statearr_55975_56105[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_55976 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55976[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_55976[(1)] = (1));

return statearr_55976;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_55954){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_55954);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e55977){var ex__2729__auto__ = e55977;
var statearr_55978_56106 = state_55954;
(statearr_55978_56106[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_55954[(4)]))){
var statearr_55979_56107 = state_55954;
(statearr_55979_56107[(1)] = cljs.core.first.call(null,(state_55954[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56108 = state_55954;
state_55954 = G__56108;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_55954){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_55954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_55980 = f__2749__auto__.call(null);
(statearr_55980[(6)] = c__2748__auto__);

return statearr_55980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56051){
var state_val_56052 = (state_56051[(1)]);
if((state_val_56052 === (7))){
var state_56051__$1 = state_56051;
var statearr_56053_56109 = state_56051__$1;
(statearr_56053_56109[(2)] = select);

(statearr_56053_56109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (20))){
var inst_56021 = (state_56051[(2)]);
var inst_56022 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_56051__$1 = (function (){var statearr_56054 = state_56051;
(statearr_56054[(7)] = inst_56021);

return statearr_56054;
})();
if(inst_56022){
var statearr_56055_56110 = state_56051__$1;
(statearr_56055_56110[(1)] = (22));

} else {
var statearr_56056_56111 = state_56051__$1;
(statearr_56056_56111[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (1))){
var state_56051__$1 = state_56051;
var statearr_56057_56112 = state_56051__$1;
(statearr_56057_56112[(2)] = null);

(statearr_56057_56112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (24))){
var inst_56021 = (state_56051[(7)]);
var inst_56013 = (state_56051[(8)]);
var inst_56005 = (state_56051[(9)]);
var inst_55997 = (state_56051[(10)]);
var inst_56029 = (state_56051[(2)]);
var inst_56030 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56031 = fluree.db.dbfunctions.internal.query.call(null,inst_56030,inst_55997,inst_56005,inst_56013,inst_56021,inst_56029);
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56051__$1,(26),inst_56031);
} else {
if((state_val_56052 === (4))){
var inst_55981 = (state_56051[(2)]);
var state_56051__$1 = state_56051;
var statearr_56058_56113 = state_56051__$1;
(statearr_56058_56113[(2)] = inst_55981);

(statearr_56058_56113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (15))){
var state_56051__$1 = state_56051;
var statearr_56059_56114 = state_56051__$1;
(statearr_56059_56114[(2)] = where);

(statearr_56059_56114[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (21))){
var inst_56017 = (state_56051[(2)]);
var inst_56018 = fluree.db.util.async.throw_err.call(null,inst_56017);
var state_56051__$1 = state_56051;
var statearr_56060_56115 = state_56051__$1;
(statearr_56060_56115[(2)] = inst_56018);

(statearr_56060_56115[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (13))){
var inst_56001 = (state_56051[(2)]);
var inst_56002 = fluree.db.util.async.throw_err.call(null,inst_56001);
var state_56051__$1 = state_56051;
var statearr_56061_56116 = state_56051__$1;
(statearr_56061_56116[(2)] = inst_56002);

(statearr_56061_56116[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (22))){
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56051__$1,(25),limit);
} else {
if((state_val_56052 === (6))){
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56051__$1,(9),select);
} else {
if((state_val_56052 === (25))){
var inst_56025 = (state_56051[(2)]);
var inst_56026 = fluree.db.util.async.throw_err.call(null,inst_56025);
var state_56051__$1 = state_56051;
var statearr_56062_56117 = state_56051__$1;
(statearr_56062_56117[(2)] = inst_56026);

(statearr_56062_56117[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (17))){
var inst_56009 = (state_56051[(2)]);
var inst_56010 = fluree.db.util.async.throw_err.call(null,inst_56009);
var state_56051__$1 = state_56051;
var statearr_56063_56118 = state_56051__$1;
(statearr_56063_56118[(2)] = inst_56010);

(statearr_56063_56118[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (3))){
var inst_56049 = (state_56051[(2)]);
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56051__$1,inst_56049);
} else {
if((state_val_56052 === (12))){
var inst_56005 = (state_56051[(2)]);
var inst_56006 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_56051__$1 = (function (){var statearr_56064 = state_56051;
(statearr_56064[(9)] = inst_56005);

return statearr_56064;
})();
if(inst_56006){
var statearr_56065_56119 = state_56051__$1;
(statearr_56065_56119[(1)] = (14));

} else {
var statearr_56066_56120 = state_56051__$1;
(statearr_56066_56120[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (2))){
var _ = (function (){var statearr_56067 = state_56051;
(statearr_56067[(4)] = cljs.core.cons.call(null,(5),(state_56051[(4)])));

return statearr_56067;
})();
var inst_55990 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_56051__$1 = state_56051;
if(inst_55990){
var statearr_56068_56121 = state_56051__$1;
(statearr_56068_56121[(1)] = (6));

} else {
var statearr_56069_56122 = state_56051__$1;
(statearr_56069_56122[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (23))){
var state_56051__$1 = state_56051;
var statearr_56070_56123 = state_56051__$1;
(statearr_56070_56123[(2)] = limit);

(statearr_56070_56123[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (19))){
var state_56051__$1 = state_56051;
var statearr_56071_56124 = state_56051__$1;
(statearr_56071_56124[(2)] = block);

(statearr_56071_56124[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (11))){
var state_56051__$1 = state_56051;
var statearr_56073_56125 = state_56051__$1;
(statearr_56073_56125[(2)] = from);

(statearr_56073_56125[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (9))){
var inst_55993 = (state_56051[(2)]);
var inst_55994 = fluree.db.util.async.throw_err.call(null,inst_55993);
var state_56051__$1 = state_56051;
var statearr_56074_56126 = state_56051__$1;
(statearr_56074_56126[(2)] = inst_55994);

(statearr_56074_56126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (5))){
var _ = (function (){var statearr_56075 = state_56051;
(statearr_56075[(4)] = cljs.core.rest.call(null,(state_56051[(4)])));

return statearr_56075;
})();
var state_56051__$1 = state_56051;
var ex56072 = (state_56051__$1[(2)]);
var statearr_56076_56127 = state_56051__$1;
(statearr_56076_56127[(5)] = ex56072);


if((ex56072 instanceof Error)){
var statearr_56077_56128 = state_56051__$1;
(statearr_56077_56128[(1)] = (4));

(statearr_56077_56128[(5)] = null);

} else {
throw ex56072;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (14))){
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56051__$1,(17),where);
} else {
if((state_val_56052 === (26))){
var inst_56021 = (state_56051[(7)]);
var inst_56013 = (state_56051[(8)]);
var inst_56005 = (state_56051[(9)]);
var inst_55997 = (state_56051[(10)]);
var inst_56033 = (state_56051[(2)]);
var inst_56034 = fluree.db.util.async.throw_err.call(null,inst_56033);
var inst_56035 = cljs.core.nth.call(null,inst_56034,(0),null);
var inst_56036 = cljs.core.nth.call(null,inst_56034,(1),null);
var inst_56037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56038 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56040 = [inst_55997,inst_56005,inst_56013,inst_56021];
var inst_56041 = (new cljs.core.PersistentVector(null,4,(5),inst_56039,inst_56040,null));
var inst_56042 = ["query",inst_56041,inst_56035];
var inst_56043 = cljs.core.PersistentHashMap.fromArrays(inst_56038,inst_56042);
var inst_56044 = [inst_56043,inst_56036];
var inst_56045 = (new cljs.core.PersistentVector(null,2,(5),inst_56037,inst_56044,null));
var inst_56046 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56045);
var _ = (function (){var statearr_56078 = state_56051;
(statearr_56078[(4)] = cljs.core.rest.call(null,(state_56051[(4)])));

return statearr_56078;
})();
var state_56051__$1 = (function (){var statearr_56079 = state_56051;
(statearr_56079[(11)] = inst_56046);

return statearr_56079;
})();
var statearr_56080_56129 = state_56051__$1;
(statearr_56080_56129[(2)] = inst_56035);

(statearr_56080_56129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (16))){
var inst_56013 = (state_56051[(2)]);
var inst_56014 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_56051__$1 = (function (){var statearr_56081 = state_56051;
(statearr_56081[(8)] = inst_56013);

return statearr_56081;
})();
if(inst_56014){
var statearr_56082_56130 = state_56051__$1;
(statearr_56082_56130[(1)] = (18));

} else {
var statearr_56083_56131 = state_56051__$1;
(statearr_56083_56131[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (10))){
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56051__$1,(13),from);
} else {
if((state_val_56052 === (18))){
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56051__$1,(21),block);
} else {
if((state_val_56052 === (8))){
var inst_55997 = (state_56051[(2)]);
var inst_55998 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_56051__$1 = (function (){var statearr_56084 = state_56051;
(statearr_56084[(10)] = inst_55997);

return statearr_56084;
})();
if(inst_55998){
var statearr_56085_56132 = state_56051__$1;
(statearr_56085_56132[(1)] = (10));

} else {
var statearr_56086_56133 = state_56051__$1;
(statearr_56086_56133[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_56087 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56087[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_56087[(1)] = (1));

return statearr_56087;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_56051){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56088){var ex__2729__auto__ = e56088;
var statearr_56089_56134 = state_56051;
(statearr_56089_56134[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56051[(4)]))){
var statearr_56090_56135 = state_56051;
(statearr_56090_56135[(1)] = cljs.core.first.call(null,(state_56051[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56136 = state_56051;
state_56051 = G__56136;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_56051){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_56051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56091 = f__2749__auto__.call(null);
(statearr_56091[(6)] = c__2748__auto__);

return statearr_56091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56192){
var state_val_56193 = (state_56192[(1)]);
if((state_val_56193 === (7))){
var state_56192__$1 = state_56192;
var statearr_56194_56225 = state_56192__$1;
(statearr_56194_56225[(2)] = startSubject);

(statearr_56194_56225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (1))){
var state_56192__$1 = state_56192;
var statearr_56195_56226 = state_56192__$1;
(statearr_56195_56226[(2)] = null);

(statearr_56195_56226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (4))){
var inst_56137 = (state_56192[(2)]);
var state_56192__$1 = state_56192;
var statearr_56196_56227 = state_56192__$1;
(statearr_56196_56227[(2)] = inst_56137);

(statearr_56196_56227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (15))){
var inst_56169 = (state_56192[(2)]);
var inst_56170 = fluree.db.util.async.throw_err.call(null,inst_56169);
var inst_56171 = cljs.core.nth.call(null,inst_56170,(0),null);
var inst_56172 = cljs.core.nth.call(null,inst_56170,(1),null);
var inst_56173 = cljs.core.empty_QMARK_.call(null,inst_56171);
var state_56192__$1 = (function (){var statearr_56197 = state_56192;
(statearr_56197[(7)] = inst_56172);

return statearr_56197;
})();
if(inst_56173){
var statearr_56198_56228 = state_56192__$1;
(statearr_56198_56228[(1)] = (16));

} else {
var statearr_56199_56229 = state_56192__$1;
(statearr_56199_56229[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (13))){
var inst_56165 = (state_56192[(8)]);
var inst_56157 = (state_56192[(9)]);
var inst_56153 = (state_56192[(10)]);
var inst_56165__$1 = (state_56192[(2)]);
var inst_56166 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56167 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_56166,inst_56153,inst_56157,inst_56165__$1);
var state_56192__$1 = (function (){var statearr_56200 = state_56192;
(statearr_56200[(8)] = inst_56165__$1);

return statearr_56200;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56192__$1,(15),inst_56167);
} else {
if((state_val_56193 === (6))){
var state_56192__$1 = state_56192;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56192__$1,(9),startSubject);
} else {
if((state_val_56193 === (17))){
var state_56192__$1 = state_56192;
var statearr_56201_56230 = state_56192__$1;
(statearr_56201_56230[(2)] = true);

(statearr_56201_56230[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (3))){
var inst_56190 = (state_56192[(2)]);
var state_56192__$1 = state_56192;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56192__$1,inst_56190);
} else {
if((state_val_56193 === (12))){
var state_56192__$1 = state_56192;
var statearr_56202_56231 = state_56192__$1;
(statearr_56202_56231[(2)] = endSubject);

(statearr_56202_56231[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (2))){
var _ = (function (){var statearr_56203 = state_56192;
(statearr_56203[(4)] = cljs.core.cons.call(null,(5),(state_56192[(4)])));

return statearr_56203;
})();
var inst_56146 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_56192__$1 = state_56192;
if(inst_56146){
var statearr_56204_56232 = state_56192__$1;
(statearr_56204_56232[(1)] = (6));

} else {
var statearr_56205_56233 = state_56192__$1;
(statearr_56205_56233[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (11))){
var state_56192__$1 = state_56192;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56192__$1,(14),endSubject);
} else {
if((state_val_56193 === (9))){
var inst_56149 = (state_56192[(2)]);
var inst_56150 = fluree.db.util.async.throw_err.call(null,inst_56149);
var state_56192__$1 = state_56192;
var statearr_56207_56234 = state_56192__$1;
(statearr_56207_56234[(2)] = inst_56150);

(statearr_56207_56234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (5))){
var _ = (function (){var statearr_56208 = state_56192;
(statearr_56208[(4)] = cljs.core.rest.call(null,(state_56192[(4)])));

return statearr_56208;
})();
var state_56192__$1 = state_56192;
var ex56206 = (state_56192__$1[(2)]);
var statearr_56209_56235 = state_56192__$1;
(statearr_56209_56235[(5)] = ex56206);


if((ex56206 instanceof Error)){
var statearr_56210_56236 = state_56192__$1;
(statearr_56210_56236[(1)] = (4));

(statearr_56210_56236[(5)] = null);

} else {
throw ex56206;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (14))){
var inst_56161 = (state_56192[(2)]);
var inst_56162 = fluree.db.util.async.throw_err.call(null,inst_56161);
var state_56192__$1 = state_56192;
var statearr_56211_56237 = state_56192__$1;
(statearr_56211_56237[(2)] = inst_56162);

(statearr_56211_56237[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (16))){
var state_56192__$1 = state_56192;
var statearr_56212_56238 = state_56192__$1;
(statearr_56212_56238[(2)] = false);

(statearr_56212_56238[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (10))){
var inst_56156 = (state_56192[(2)]);
var inst_56157 = fluree.db.util.async.throw_err.call(null,inst_56156);
var inst_56158 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_56192__$1 = (function (){var statearr_56213 = state_56192;
(statearr_56213[(9)] = inst_56157);

return statearr_56213;
})();
if(inst_56158){
var statearr_56214_56239 = state_56192__$1;
(statearr_56214_56239[(1)] = (11));

} else {
var statearr_56215_56240 = state_56192__$1;
(statearr_56215_56240[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (18))){
var inst_56172 = (state_56192[(7)]);
var inst_56165 = (state_56192[(8)]);
var inst_56157 = (state_56192[(9)]);
var inst_56153 = (state_56192[(10)]);
var inst_56177 = (state_56192[(2)]);
var inst_56178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56179 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56181 = [inst_56153,inst_56157,inst_56165];
var inst_56182 = (new cljs.core.PersistentVector(null,3,(5),inst_56180,inst_56181,null));
var inst_56183 = ["relationship?",inst_56182,inst_56177];
var inst_56184 = cljs.core.PersistentHashMap.fromArrays(inst_56179,inst_56183);
var inst_56185 = [inst_56184,inst_56172];
var inst_56186 = (new cljs.core.PersistentVector(null,2,(5),inst_56178,inst_56185,null));
var inst_56187 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56186);
var _ = (function (){var statearr_56216 = state_56192;
(statearr_56216[(4)] = cljs.core.rest.call(null,(state_56192[(4)])));

return statearr_56216;
})();
var state_56192__$1 = (function (){var statearr_56217 = state_56192;
(statearr_56217[(11)] = inst_56187);

return statearr_56217;
})();
var statearr_56218_56241 = state_56192__$1;
(statearr_56218_56241[(2)] = inst_56177);

(statearr_56218_56241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56193 === (8))){
var inst_56153 = (state_56192[(2)]);
var inst_56154 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_56192__$1 = (function (){var statearr_56219 = state_56192;
(statearr_56219[(10)] = inst_56153);

return statearr_56219;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56192__$1,(10),inst_56154);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_56220 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56220[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto__);

(statearr_56220[(1)] = (1));

return statearr_56220;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto____1 = (function (state_56192){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56192);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56221){var ex__2729__auto__ = e56221;
var statearr_56222_56242 = state_56192;
(statearr_56222_56242[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56192[(4)]))){
var statearr_56223_56243 = state_56192;
(statearr_56223_56243[(1)] = cljs.core.first.call(null,(state_56192[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56244 = state_56192;
state_56192 = G__56244;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto__ = function(state_56192){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto____1.call(this,state_56192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56224 = f__2749__auto__.call(null);
(statearr_56224[(6)] = c__2748__auto__);

return statearr_56224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56281){
var state_val_56282 = (state_56281[(1)]);
if((state_val_56282 === (7))){
var state_56281__$1 = state_56281;
var statearr_56283_56303 = state_56281__$1;
(statearr_56283_56303[(2)] = pred_name);

(statearr_56283_56303[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56282 === (1))){
var state_56281__$1 = state_56281;
var statearr_56284_56304 = state_56281__$1;
(statearr_56284_56304[(2)] = null);

(statearr_56284_56304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56282 === (4))){
var inst_56245 = (state_56281[(2)]);
var state_56281__$1 = state_56281;
var statearr_56285_56305 = state_56281__$1;
(statearr_56285_56305[(2)] = inst_56245);

(statearr_56285_56305[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56282 === (6))){
var state_56281__$1 = state_56281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56281__$1,(9),pred_name);
} else {
if((state_val_56282 === (3))){
var inst_56279 = (state_56281[(2)]);
var state_56281__$1 = state_56281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56281__$1,inst_56279);
} else {
if((state_val_56282 === (2))){
var _ = (function (){var statearr_56287 = state_56281;
(statearr_56287[(4)] = cljs.core.cons.call(null,(5),(state_56281[(4)])));

return statearr_56287;
})();
var inst_56254 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_56281__$1 = state_56281;
if(inst_56254){
var statearr_56288_56306 = state_56281__$1;
(statearr_56288_56306[(1)] = (6));

} else {
var statearr_56289_56307 = state_56281__$1;
(statearr_56289_56307[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56282 === (9))){
var inst_56257 = (state_56281[(2)]);
var inst_56258 = fluree.db.util.async.throw_err.call(null,inst_56257);
var state_56281__$1 = state_56281;
var statearr_56290_56308 = state_56281__$1;
(statearr_56290_56308[(2)] = inst_56258);

(statearr_56290_56308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56282 === (5))){
var _ = (function (){var statearr_56291 = state_56281;
(statearr_56291[(4)] = cljs.core.rest.call(null,(state_56281[(4)])));

return statearr_56291;
})();
var state_56281__$1 = state_56281;
var ex56286 = (state_56281__$1[(2)]);
var statearr_56292_56309 = state_56281__$1;
(statearr_56292_56309[(5)] = ex56286);


if((ex56286 instanceof Error)){
var statearr_56293_56310 = state_56281__$1;
(statearr_56293_56310[(1)] = (4));

(statearr_56293_56310[(5)] = null);

} else {
throw ex56286;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56282 === (10))){
var inst_56261 = (state_56281[(7)]);
var inst_56265 = (state_56281[(2)]);
var inst_56266 = fluree.db.util.async.throw_err.call(null,inst_56265);
var inst_56267 = cljs.core.nth.call(null,inst_56266,(0),null);
var inst_56268 = cljs.core.nth.call(null,inst_56266,(1),null);
var inst_56269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56270 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56271 = ["max-pred-val",inst_56261,inst_56267];
var inst_56272 = cljs.core.PersistentHashMap.fromArrays(inst_56270,inst_56271);
var inst_56273 = (inst_56268 + (10));
var inst_56274 = [inst_56272,inst_56273];
var inst_56275 = (new cljs.core.PersistentVector(null,2,(5),inst_56269,inst_56274,null));
var inst_56276 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56275);
var _ = (function (){var statearr_56294 = state_56281;
(statearr_56294[(4)] = cljs.core.rest.call(null,(state_56281[(4)])));

return statearr_56294;
})();
var state_56281__$1 = (function (){var statearr_56295 = state_56281;
(statearr_56295[(8)] = inst_56276);

return statearr_56295;
})();
var statearr_56296_56311 = state_56281__$1;
(statearr_56296_56311[(2)] = inst_56267);

(statearr_56296_56311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56282 === (8))){
var inst_56261 = (state_56281[(7)]);
var inst_56261__$1 = (state_56281[(2)]);
var inst_56262 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56263 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_56262,inst_56261__$1,null);
var state_56281__$1 = (function (){var statearr_56297 = state_56281;
(statearr_56297[(7)] = inst_56261__$1);

return statearr_56297;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56281__$1,(10),inst_56263);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto____0 = (function (){
var statearr_56298 = [null,null,null,null,null,null,null,null,null];
(statearr_56298[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto__);

(statearr_56298[(1)] = (1));

return statearr_56298;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto____1 = (function (state_56281){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56299){var ex__2729__auto__ = e56299;
var statearr_56300_56312 = state_56281;
(statearr_56300_56312[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56281[(4)]))){
var statearr_56301_56313 = state_56281;
(statearr_56301_56313[(1)] = cljs.core.first.call(null,(state_56281[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56314 = state_56281;
state_56281 = G__56314;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto__ = function(state_56281){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto____1.call(this,state_56281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56302 = f__2749__auto__.call(null);
(statearr_56302[(6)] = c__2748__auto__);

return statearr_56302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56341){
var state_val_56342 = (state_56341[(1)]);
if((state_val_56342 === (7))){
var state_56341__$1 = state_56341;
var statearr_56343_56362 = state_56341__$1;
(statearr_56343_56362[(2)] = n);

(statearr_56343_56362[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56342 === (1))){
var state_56341__$1 = state_56341;
var statearr_56344_56363 = state_56341__$1;
(statearr_56344_56363[(2)] = null);

(statearr_56344_56363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56342 === (4))){
var inst_56315 = (state_56341[(2)]);
var state_56341__$1 = state_56341;
var statearr_56345_56364 = state_56341__$1;
(statearr_56345_56364[(2)] = inst_56315);

(statearr_56345_56364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56342 === (6))){
var state_56341__$1 = state_56341;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56341__$1,(9),n);
} else {
if((state_val_56342 === (3))){
var inst_56339 = (state_56341[(2)]);
var state_56341__$1 = state_56341;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56341__$1,inst_56339);
} else {
if((state_val_56342 === (2))){
var _ = (function (){var statearr_56347 = state_56341;
(statearr_56347[(4)] = cljs.core.cons.call(null,(5),(state_56341[(4)])));

return statearr_56347;
})();
var inst_56321 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56341__$1 = state_56341;
if(inst_56321){
var statearr_56348_56365 = state_56341__$1;
(statearr_56348_56365[(1)] = (6));

} else {
var statearr_56349_56366 = state_56341__$1;
(statearr_56349_56366[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56342 === (9))){
var inst_56324 = (state_56341[(2)]);
var inst_56325 = fluree.db.util.async.throw_err.call(null,inst_56324);
var state_56341__$1 = state_56341;
var statearr_56350_56367 = state_56341__$1;
(statearr_56350_56367[(2)] = inst_56325);

(statearr_56350_56367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56342 === (5))){
var _ = (function (){var statearr_56351 = state_56341;
(statearr_56351[(4)] = cljs.core.rest.call(null,(state_56341[(4)])));

return statearr_56351;
})();
var state_56341__$1 = state_56341;
var ex56346 = (state_56341__$1[(2)]);
var statearr_56352_56368 = state_56341__$1;
(statearr_56352_56368[(5)] = ex56346);


if((ex56346 instanceof Error)){
var statearr_56353_56369 = state_56341__$1;
(statearr_56353_56369[(1)] = (4));

(statearr_56353_56369[(5)] = null);

} else {
throw ex56346;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56342 === (8))){
var inst_56328 = (state_56341[(2)]);
var inst_56329 = fluree.db.dbfunctions.internal.inc.call(null,inst_56328);
var inst_56330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56331 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56332 = ["inc",inst_56328,inst_56329];
var inst_56333 = cljs.core.PersistentHashMap.fromArrays(inst_56331,inst_56332);
var inst_56334 = [inst_56333,(10)];
var inst_56335 = (new cljs.core.PersistentVector(null,2,(5),inst_56330,inst_56334,null));
var inst_56336 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56335);
var _ = (function (){var statearr_56354 = state_56341;
(statearr_56354[(4)] = cljs.core.rest.call(null,(state_56341[(4)])));

return statearr_56354;
})();
var state_56341__$1 = (function (){var statearr_56355 = state_56341;
(statearr_56355[(7)] = inst_56336);

return statearr_56355;
})();
var statearr_56356_56370 = state_56341__$1;
(statearr_56356_56370[(2)] = inst_56329);

(statearr_56356_56370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto____0 = (function (){
var statearr_56357 = [null,null,null,null,null,null,null,null];
(statearr_56357[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto__);

(statearr_56357[(1)] = (1));

return statearr_56357;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto____1 = (function (state_56341){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56341);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56358){var ex__2729__auto__ = e56358;
var statearr_56359_56371 = state_56341;
(statearr_56359_56371[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56341[(4)]))){
var statearr_56360_56372 = state_56341;
(statearr_56360_56372[(1)] = cljs.core.first.call(null,(state_56341[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56373 = state_56341;
state_56341 = G__56373;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto__ = function(state_56341){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto____1.call(this,state_56341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56361 = f__2749__auto__.call(null);
(statearr_56361[(6)] = c__2748__auto__);

return statearr_56361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56400){
var state_val_56401 = (state_56400[(1)]);
if((state_val_56401 === (7))){
var state_56400__$1 = state_56400;
var statearr_56402_56421 = state_56400__$1;
(statearr_56402_56421[(2)] = n);

(statearr_56402_56421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56401 === (1))){
var state_56400__$1 = state_56400;
var statearr_56403_56422 = state_56400__$1;
(statearr_56403_56422[(2)] = null);

(statearr_56403_56422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56401 === (4))){
var inst_56374 = (state_56400[(2)]);
var state_56400__$1 = state_56400;
var statearr_56404_56423 = state_56400__$1;
(statearr_56404_56423[(2)] = inst_56374);

(statearr_56404_56423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56401 === (6))){
var state_56400__$1 = state_56400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56400__$1,(9),n);
} else {
if((state_val_56401 === (3))){
var inst_56398 = (state_56400[(2)]);
var state_56400__$1 = state_56400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56400__$1,inst_56398);
} else {
if((state_val_56401 === (2))){
var _ = (function (){var statearr_56406 = state_56400;
(statearr_56406[(4)] = cljs.core.cons.call(null,(5),(state_56400[(4)])));

return statearr_56406;
})();
var inst_56380 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56400__$1 = state_56400;
if(inst_56380){
var statearr_56407_56424 = state_56400__$1;
(statearr_56407_56424[(1)] = (6));

} else {
var statearr_56408_56425 = state_56400__$1;
(statearr_56408_56425[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56401 === (9))){
var inst_56383 = (state_56400[(2)]);
var inst_56384 = fluree.db.util.async.throw_err.call(null,inst_56383);
var state_56400__$1 = state_56400;
var statearr_56409_56426 = state_56400__$1;
(statearr_56409_56426[(2)] = inst_56384);

(statearr_56409_56426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56401 === (5))){
var _ = (function (){var statearr_56410 = state_56400;
(statearr_56410[(4)] = cljs.core.rest.call(null,(state_56400[(4)])));

return statearr_56410;
})();
var state_56400__$1 = state_56400;
var ex56405 = (state_56400__$1[(2)]);
var statearr_56411_56427 = state_56400__$1;
(statearr_56411_56427[(5)] = ex56405);


if((ex56405 instanceof Error)){
var statearr_56412_56428 = state_56400__$1;
(statearr_56412_56428[(1)] = (4));

(statearr_56412_56428[(5)] = null);

} else {
throw ex56405;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56401 === (8))){
var inst_56387 = (state_56400[(2)]);
var inst_56388 = fluree.db.dbfunctions.internal.dec.call(null,inst_56387);
var inst_56389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56390 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56391 = ["dec",inst_56387,inst_56388];
var inst_56392 = cljs.core.PersistentHashMap.fromArrays(inst_56390,inst_56391);
var inst_56393 = [inst_56392,(10)];
var inst_56394 = (new cljs.core.PersistentVector(null,2,(5),inst_56389,inst_56393,null));
var inst_56395 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56394);
var _ = (function (){var statearr_56413 = state_56400;
(statearr_56413[(4)] = cljs.core.rest.call(null,(state_56400[(4)])));

return statearr_56413;
})();
var state_56400__$1 = (function (){var statearr_56414 = state_56400;
(statearr_56414[(7)] = inst_56395);

return statearr_56414;
})();
var statearr_56415_56429 = state_56400__$1;
(statearr_56415_56429[(2)] = inst_56388);

(statearr_56415_56429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto____0 = (function (){
var statearr_56416 = [null,null,null,null,null,null,null,null];
(statearr_56416[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto__);

(statearr_56416[(1)] = (1));

return statearr_56416;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto____1 = (function (state_56400){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56417){var ex__2729__auto__ = e56417;
var statearr_56418_56430 = state_56400;
(statearr_56418_56430[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56400[(4)]))){
var statearr_56419_56431 = state_56400;
(statearr_56419_56431[(1)] = cljs.core.first.call(null,(state_56400[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56432 = state_56400;
state_56400 = G__56432;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto__ = function(state_56400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto____1.call(this,state_56400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56420 = f__2749__auto__.call(null);
(statearr_56420[(6)] = c__2748__auto__);

return statearr_56420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56482 = arguments.length;
var i__4830__auto___56483 = (0);
while(true){
if((i__4830__auto___56483 < len__4829__auto___56482)){
args__4835__auto__.push((arguments[i__4830__auto___56483]));

var G__56484 = (i__4830__auto___56483 + (1));
i__4830__auto___56483 = G__56484;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56465){
var state_val_56466 = (state_56465[(1)]);
if((state_val_56466 === (1))){
var state_56465__$1 = state_56465;
var statearr_56467_56485 = state_56465__$1;
(statearr_56467_56485[(2)] = null);

(statearr_56467_56485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56466 === (2))){
var _ = (function (){var statearr_56468 = state_56465;
(statearr_56468[(4)] = cljs.core.cons.call(null,(5),(state_56465[(4)])));

return statearr_56468;
})();
var inst_56441 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56465__$1 = state_56465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56465__$1,(6),inst_56441);
} else {
if((state_val_56466 === (3))){
var inst_56463 = (state_56465[(2)]);
var state_56465__$1 = state_56465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56465__$1,inst_56463);
} else {
if((state_val_56466 === (4))){
var inst_56435 = (state_56465[(2)]);
var state_56465__$1 = state_56465;
var statearr_56470_56486 = state_56465__$1;
(statearr_56470_56486[(2)] = inst_56435);

(statearr_56470_56486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56466 === (5))){
var _ = (function (){var statearr_56471 = state_56465;
(statearr_56471[(4)] = cljs.core.rest.call(null,(state_56465[(4)])));

return statearr_56471;
})();
var state_56465__$1 = state_56465;
var ex56469 = (state_56465__$1[(2)]);
var statearr_56472_56487 = state_56465__$1;
(statearr_56472_56487[(5)] = ex56469);


if((ex56469 instanceof Error)){
var statearr_56473_56488 = state_56465__$1;
(statearr_56473_56488[(1)] = (4));

(statearr_56473_56488[(5)] = null);

} else {
throw ex56469;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56466 === (6))){
var inst_56443 = (state_56465[(2)]);
var inst_56444 = fluree.db.util.async.throw_err.call(null,inst_56443);
var inst_56445 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_56444);
var inst_56446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56447 = [inst_56444];
var inst_56448 = (new cljs.core.PersistentVector(null,1,(5),inst_56446,inst_56447,null));
var inst_56449 = cljs.core.count.call(null,inst_56448);
var inst_56450 = ((9) + inst_56449);
var inst_56451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56452 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56454 = [inst_56444];
var inst_56455 = (new cljs.core.PersistentVector(null,1,(5),inst_56453,inst_56454,null));
var inst_56456 = ["+",inst_56455,inst_56445];
var inst_56457 = cljs.core.PersistentHashMap.fromArrays(inst_56452,inst_56456);
var inst_56458 = [inst_56457,inst_56450];
var inst_56459 = (new cljs.core.PersistentVector(null,2,(5),inst_56451,inst_56458,null));
var inst_56460 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56459);
var _ = (function (){var statearr_56474 = state_56465;
(statearr_56474[(4)] = cljs.core.rest.call(null,(state_56465[(4)])));

return statearr_56474;
})();
var state_56465__$1 = (function (){var statearr_56475 = state_56465;
(statearr_56475[(7)] = inst_56460);

return statearr_56475;
})();
var statearr_56476_56489 = state_56465__$1;
(statearr_56476_56489[(2)] = inst_56445);

(statearr_56476_56489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_56477 = [null,null,null,null,null,null,null,null];
(statearr_56477[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_56477[(1)] = (1));

return statearr_56477;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_56465){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56478){var ex__2729__auto__ = e56478;
var statearr_56479_56490 = state_56465;
(statearr_56479_56490[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56465[(4)]))){
var statearr_56480_56491 = state_56465;
(statearr_56480_56491[(1)] = cljs.core.first.call(null,(state_56465[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56492 = state_56465;
state_56465 = G__56492;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_56465){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_56465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56481 = f__2749__auto__.call(null);
(statearr_56481[(6)] = c__2748__auto__);

return statearr_56481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56433){
var G__56434 = cljs.core.first.call(null,seq56433);
var seq56433__$1 = cljs.core.next.call(null,seq56433);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56434,seq56433__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56542 = arguments.length;
var i__4830__auto___56543 = (0);
while(true){
if((i__4830__auto___56543 < len__4829__auto___56542)){
args__4835__auto__.push((arguments[i__4830__auto___56543]));

var G__56544 = (i__4830__auto___56543 + (1));
i__4830__auto___56543 = G__56544;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56525){
var state_val_56526 = (state_56525[(1)]);
if((state_val_56526 === (1))){
var state_56525__$1 = state_56525;
var statearr_56527_56545 = state_56525__$1;
(statearr_56527_56545[(2)] = null);

(statearr_56527_56545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56526 === (2))){
var _ = (function (){var statearr_56528 = state_56525;
(statearr_56528[(4)] = cljs.core.cons.call(null,(5),(state_56525[(4)])));

return statearr_56528;
})();
var inst_56501 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56525__$1 = state_56525;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56525__$1,(6),inst_56501);
} else {
if((state_val_56526 === (3))){
var inst_56523 = (state_56525[(2)]);
var state_56525__$1 = state_56525;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56525__$1,inst_56523);
} else {
if((state_val_56526 === (4))){
var inst_56495 = (state_56525[(2)]);
var state_56525__$1 = state_56525;
var statearr_56530_56546 = state_56525__$1;
(statearr_56530_56546[(2)] = inst_56495);

(statearr_56530_56546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56526 === (5))){
var _ = (function (){var statearr_56531 = state_56525;
(statearr_56531[(4)] = cljs.core.rest.call(null,(state_56525[(4)])));

return statearr_56531;
})();
var state_56525__$1 = state_56525;
var ex56529 = (state_56525__$1[(2)]);
var statearr_56532_56547 = state_56525__$1;
(statearr_56532_56547[(5)] = ex56529);


if((ex56529 instanceof Error)){
var statearr_56533_56548 = state_56525__$1;
(statearr_56533_56548[(1)] = (4));

(statearr_56533_56548[(5)] = null);

} else {
throw ex56529;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56526 === (6))){
var inst_56503 = (state_56525[(2)]);
var inst_56504 = fluree.db.util.async.throw_err.call(null,inst_56503);
var inst_56505 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_56504);
var inst_56506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56507 = [inst_56504];
var inst_56508 = (new cljs.core.PersistentVector(null,1,(5),inst_56506,inst_56507,null));
var inst_56509 = cljs.core.count.call(null,inst_56508);
var inst_56510 = ((9) + inst_56509);
var inst_56511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56512 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56514 = [inst_56504];
var inst_56515 = (new cljs.core.PersistentVector(null,1,(5),inst_56513,inst_56514,null));
var inst_56516 = ["-",inst_56515,inst_56505];
var inst_56517 = cljs.core.PersistentHashMap.fromArrays(inst_56512,inst_56516);
var inst_56518 = [inst_56517,inst_56510];
var inst_56519 = (new cljs.core.PersistentVector(null,2,(5),inst_56511,inst_56518,null));
var inst_56520 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56519);
var _ = (function (){var statearr_56534 = state_56525;
(statearr_56534[(4)] = cljs.core.rest.call(null,(state_56525[(4)])));

return statearr_56534;
})();
var state_56525__$1 = (function (){var statearr_56535 = state_56525;
(statearr_56535[(7)] = inst_56520);

return statearr_56535;
})();
var statearr_56536_56549 = state_56525__$1;
(statearr_56536_56549[(2)] = inst_56505);

(statearr_56536_56549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_56537 = [null,null,null,null,null,null,null,null];
(statearr_56537[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_56537[(1)] = (1));

return statearr_56537;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_56525){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56525);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56538){var ex__2729__auto__ = e56538;
var statearr_56539_56550 = state_56525;
(statearr_56539_56550[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56525[(4)]))){
var statearr_56540_56551 = state_56525;
(statearr_56540_56551[(1)] = cljs.core.first.call(null,(state_56525[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56552 = state_56525;
state_56525 = G__56552;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_56525){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_56525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56541 = f__2749__auto__.call(null);
(statearr_56541[(6)] = c__2748__auto__);

return statearr_56541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56493){
var G__56494 = cljs.core.first.call(null,seq56493);
var seq56493__$1 = cljs.core.next.call(null,seq56493);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56494,seq56493__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56602 = arguments.length;
var i__4830__auto___56603 = (0);
while(true){
if((i__4830__auto___56603 < len__4829__auto___56602)){
args__4835__auto__.push((arguments[i__4830__auto___56603]));

var G__56604 = (i__4830__auto___56603 + (1));
i__4830__auto___56603 = G__56604;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56585){
var state_val_56586 = (state_56585[(1)]);
if((state_val_56586 === (1))){
var state_56585__$1 = state_56585;
var statearr_56587_56605 = state_56585__$1;
(statearr_56587_56605[(2)] = null);

(statearr_56587_56605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56586 === (2))){
var _ = (function (){var statearr_56588 = state_56585;
(statearr_56588[(4)] = cljs.core.cons.call(null,(5),(state_56585[(4)])));

return statearr_56588;
})();
var inst_56561 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56585__$1 = state_56585;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56585__$1,(6),inst_56561);
} else {
if((state_val_56586 === (3))){
var inst_56583 = (state_56585[(2)]);
var state_56585__$1 = state_56585;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56585__$1,inst_56583);
} else {
if((state_val_56586 === (4))){
var inst_56555 = (state_56585[(2)]);
var state_56585__$1 = state_56585;
var statearr_56590_56606 = state_56585__$1;
(statearr_56590_56606[(2)] = inst_56555);

(statearr_56590_56606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56586 === (5))){
var _ = (function (){var statearr_56591 = state_56585;
(statearr_56591[(4)] = cljs.core.rest.call(null,(state_56585[(4)])));

return statearr_56591;
})();
var state_56585__$1 = state_56585;
var ex56589 = (state_56585__$1[(2)]);
var statearr_56592_56607 = state_56585__$1;
(statearr_56592_56607[(5)] = ex56589);


if((ex56589 instanceof Error)){
var statearr_56593_56608 = state_56585__$1;
(statearr_56593_56608[(1)] = (4));

(statearr_56593_56608[(5)] = null);

} else {
throw ex56589;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56586 === (6))){
var inst_56563 = (state_56585[(2)]);
var inst_56564 = fluree.db.util.async.throw_err.call(null,inst_56563);
var inst_56565 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_56564);
var inst_56566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56567 = [inst_56564];
var inst_56568 = (new cljs.core.PersistentVector(null,1,(5),inst_56566,inst_56567,null));
var inst_56569 = cljs.core.count.call(null,inst_56568);
var inst_56570 = ((9) + inst_56569);
var inst_56571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56572 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56574 = [inst_56564];
var inst_56575 = (new cljs.core.PersistentVector(null,1,(5),inst_56573,inst_56574,null));
var inst_56576 = ["*",inst_56575,inst_56565];
var inst_56577 = cljs.core.PersistentHashMap.fromArrays(inst_56572,inst_56576);
var inst_56578 = [inst_56577,inst_56570];
var inst_56579 = (new cljs.core.PersistentVector(null,2,(5),inst_56571,inst_56578,null));
var inst_56580 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56579);
var _ = (function (){var statearr_56594 = state_56585;
(statearr_56594[(4)] = cljs.core.rest.call(null,(state_56585[(4)])));

return statearr_56594;
})();
var state_56585__$1 = (function (){var statearr_56595 = state_56585;
(statearr_56595[(7)] = inst_56580);

return statearr_56595;
})();
var statearr_56596_56609 = state_56585__$1;
(statearr_56596_56609[(2)] = inst_56565);

(statearr_56596_56609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_56597 = [null,null,null,null,null,null,null,null];
(statearr_56597[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_56597[(1)] = (1));

return statearr_56597;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_56585){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56585);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56598){var ex__2729__auto__ = e56598;
var statearr_56599_56610 = state_56585;
(statearr_56599_56610[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56585[(4)]))){
var statearr_56600_56611 = state_56585;
(statearr_56600_56611[(1)] = cljs.core.first.call(null,(state_56585[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56612 = state_56585;
state_56585 = G__56612;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_56585){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_56585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56601 = f__2749__auto__.call(null);
(statearr_56601[(6)] = c__2748__auto__);

return statearr_56601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56553){
var G__56554 = cljs.core.first.call(null,seq56553);
var seq56553__$1 = cljs.core.next.call(null,seq56553);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56554,seq56553__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56662 = arguments.length;
var i__4830__auto___56663 = (0);
while(true){
if((i__4830__auto___56663 < len__4829__auto___56662)){
args__4835__auto__.push((arguments[i__4830__auto___56663]));

var G__56664 = (i__4830__auto___56663 + (1));
i__4830__auto___56663 = G__56664;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56645){
var state_val_56646 = (state_56645[(1)]);
if((state_val_56646 === (1))){
var state_56645__$1 = state_56645;
var statearr_56647_56665 = state_56645__$1;
(statearr_56647_56665[(2)] = null);

(statearr_56647_56665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56646 === (2))){
var _ = (function (){var statearr_56648 = state_56645;
(statearr_56648[(4)] = cljs.core.cons.call(null,(5),(state_56645[(4)])));

return statearr_56648;
})();
var inst_56621 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56645__$1 = state_56645;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56645__$1,(6),inst_56621);
} else {
if((state_val_56646 === (3))){
var inst_56643 = (state_56645[(2)]);
var state_56645__$1 = state_56645;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56645__$1,inst_56643);
} else {
if((state_val_56646 === (4))){
var inst_56615 = (state_56645[(2)]);
var state_56645__$1 = state_56645;
var statearr_56650_56666 = state_56645__$1;
(statearr_56650_56666[(2)] = inst_56615);

(statearr_56650_56666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56646 === (5))){
var _ = (function (){var statearr_56651 = state_56645;
(statearr_56651[(4)] = cljs.core.rest.call(null,(state_56645[(4)])));

return statearr_56651;
})();
var state_56645__$1 = state_56645;
var ex56649 = (state_56645__$1[(2)]);
var statearr_56652_56667 = state_56645__$1;
(statearr_56652_56667[(5)] = ex56649);


if((ex56649 instanceof Error)){
var statearr_56653_56668 = state_56645__$1;
(statearr_56653_56668[(1)] = (4));

(statearr_56653_56668[(5)] = null);

} else {
throw ex56649;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56646 === (6))){
var inst_56623 = (state_56645[(2)]);
var inst_56624 = fluree.db.util.async.throw_err.call(null,inst_56623);
var inst_56625 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_56624);
var inst_56626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56627 = [inst_56624];
var inst_56628 = (new cljs.core.PersistentVector(null,1,(5),inst_56626,inst_56627,null));
var inst_56629 = cljs.core.count.call(null,inst_56628);
var inst_56630 = ((9) + inst_56629);
var inst_56631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56632 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56634 = [inst_56624];
var inst_56635 = (new cljs.core.PersistentVector(null,1,(5),inst_56633,inst_56634,null));
var inst_56636 = ["/",inst_56635,inst_56625];
var inst_56637 = cljs.core.PersistentHashMap.fromArrays(inst_56632,inst_56636);
var inst_56638 = [inst_56637,inst_56630];
var inst_56639 = (new cljs.core.PersistentVector(null,2,(5),inst_56631,inst_56638,null));
var inst_56640 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56639);
var _ = (function (){var statearr_56654 = state_56645;
(statearr_56654[(4)] = cljs.core.rest.call(null,(state_56645[(4)])));

return statearr_56654;
})();
var state_56645__$1 = (function (){var statearr_56655 = state_56645;
(statearr_56655[(7)] = inst_56640);

return statearr_56655;
})();
var statearr_56656_56669 = state_56645__$1;
(statearr_56656_56669[(2)] = inst_56625);

(statearr_56656_56669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_56657 = [null,null,null,null,null,null,null,null];
(statearr_56657[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_56657[(1)] = (1));

return statearr_56657;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_56645){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56645);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56658){var ex__2729__auto__ = e56658;
var statearr_56659_56670 = state_56645;
(statearr_56659_56670[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56645[(4)]))){
var statearr_56660_56671 = state_56645;
(statearr_56660_56671[(1)] = cljs.core.first.call(null,(state_56645[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56672 = state_56645;
state_56645 = G__56672;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_56645){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_56645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56661 = f__2749__auto__.call(null);
(statearr_56661[(6)] = c__2748__auto__);

return statearr_56661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56613){
var G__56614 = cljs.core.first.call(null,seq56613);
var seq56613__$1 = cljs.core.next.call(null,seq56613);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56614,seq56613__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56710){
var state_val_56711 = (state_56710[(1)]);
if((state_val_56711 === (7))){
var state_56710__$1 = state_56710;
var statearr_56712_56736 = state_56710__$1;
(statearr_56712_56736[(2)] = n);

(statearr_56712_56736[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (1))){
var state_56710__$1 = state_56710;
var statearr_56713_56737 = state_56710__$1;
(statearr_56713_56737[(2)] = null);

(statearr_56713_56737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (4))){
var inst_56673 = (state_56710[(2)]);
var state_56710__$1 = state_56710;
var statearr_56714_56738 = state_56710__$1;
(statearr_56714_56738[(2)] = inst_56673);

(statearr_56714_56738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (13))){
var inst_56690 = (state_56710[(2)]);
var inst_56691 = fluree.db.util.async.throw_err.call(null,inst_56690);
var state_56710__$1 = state_56710;
var statearr_56715_56739 = state_56710__$1;
(statearr_56715_56739[(2)] = inst_56691);

(statearr_56715_56739[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (6))){
var state_56710__$1 = state_56710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56710__$1,(9),n);
} else {
if((state_val_56711 === (3))){
var inst_56708 = (state_56710[(2)]);
var state_56710__$1 = state_56710;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56710__$1,inst_56708);
} else {
if((state_val_56711 === (12))){
var inst_56686 = (state_56710[(7)]);
var inst_56694 = (state_56710[(2)]);
var inst_56695 = fluree.db.dbfunctions.internal.quot.call(null,inst_56686,inst_56694);
var inst_56696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56697 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56699 = [inst_56686,inst_56694];
var inst_56700 = (new cljs.core.PersistentVector(null,2,(5),inst_56698,inst_56699,null));
var inst_56701 = ["quot",inst_56700,inst_56695];
var inst_56702 = cljs.core.PersistentHashMap.fromArrays(inst_56697,inst_56701);
var inst_56703 = [inst_56702,(2)];
var inst_56704 = (new cljs.core.PersistentVector(null,2,(5),inst_56696,inst_56703,null));
var inst_56705 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56704);
var _ = (function (){var statearr_56716 = state_56710;
(statearr_56716[(4)] = cljs.core.rest.call(null,(state_56710[(4)])));

return statearr_56716;
})();
var state_56710__$1 = (function (){var statearr_56717 = state_56710;
(statearr_56717[(8)] = inst_56705);

return statearr_56717;
})();
var statearr_56718_56740 = state_56710__$1;
(statearr_56718_56740[(2)] = inst_56695);

(statearr_56718_56740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (2))){
var _ = (function (){var statearr_56719 = state_56710;
(statearr_56719[(4)] = cljs.core.cons.call(null,(5),(state_56710[(4)])));

return statearr_56719;
})();
var inst_56679 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56710__$1 = state_56710;
if(inst_56679){
var statearr_56720_56741 = state_56710__$1;
(statearr_56720_56741[(1)] = (6));

} else {
var statearr_56721_56742 = state_56710__$1;
(statearr_56721_56742[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (11))){
var state_56710__$1 = state_56710;
var statearr_56723_56743 = state_56710__$1;
(statearr_56723_56743[(2)] = d);

(statearr_56723_56743[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (9))){
var inst_56682 = (state_56710[(2)]);
var inst_56683 = fluree.db.util.async.throw_err.call(null,inst_56682);
var state_56710__$1 = state_56710;
var statearr_56724_56744 = state_56710__$1;
(statearr_56724_56744[(2)] = inst_56683);

(statearr_56724_56744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (5))){
var _ = (function (){var statearr_56725 = state_56710;
(statearr_56725[(4)] = cljs.core.rest.call(null,(state_56710[(4)])));

return statearr_56725;
})();
var state_56710__$1 = state_56710;
var ex56722 = (state_56710__$1[(2)]);
var statearr_56726_56745 = state_56710__$1;
(statearr_56726_56745[(5)] = ex56722);


if((ex56722 instanceof Error)){
var statearr_56727_56746 = state_56710__$1;
(statearr_56727_56746[(1)] = (4));

(statearr_56727_56746[(5)] = null);

} else {
throw ex56722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56711 === (10))){
var state_56710__$1 = state_56710;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56710__$1,(13),d);
} else {
if((state_val_56711 === (8))){
var inst_56686 = (state_56710[(2)]);
var inst_56687 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56710__$1 = (function (){var statearr_56728 = state_56710;
(statearr_56728[(7)] = inst_56686);

return statearr_56728;
})();
if(inst_56687){
var statearr_56729_56747 = state_56710__$1;
(statearr_56729_56747[(1)] = (10));

} else {
var statearr_56730_56748 = state_56710__$1;
(statearr_56730_56748[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto____0 = (function (){
var statearr_56731 = [null,null,null,null,null,null,null,null,null];
(statearr_56731[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto__);

(statearr_56731[(1)] = (1));

return statearr_56731;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto____1 = (function (state_56710){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56732){var ex__2729__auto__ = e56732;
var statearr_56733_56749 = state_56710;
(statearr_56733_56749[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56710[(4)]))){
var statearr_56734_56750 = state_56710;
(statearr_56734_56750[(1)] = cljs.core.first.call(null,(state_56710[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56751 = state_56710;
state_56710 = G__56751;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto__ = function(state_56710){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto____1.call(this,state_56710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56735 = f__2749__auto__.call(null);
(statearr_56735[(6)] = c__2748__auto__);

return statearr_56735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56789){
var state_val_56790 = (state_56789[(1)]);
if((state_val_56790 === (7))){
var state_56789__$1 = state_56789;
var statearr_56791_56815 = state_56789__$1;
(statearr_56791_56815[(2)] = n);

(statearr_56791_56815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (1))){
var state_56789__$1 = state_56789;
var statearr_56792_56816 = state_56789__$1;
(statearr_56792_56816[(2)] = null);

(statearr_56792_56816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (4))){
var inst_56752 = (state_56789[(2)]);
var state_56789__$1 = state_56789;
var statearr_56793_56817 = state_56789__$1;
(statearr_56793_56817[(2)] = inst_56752);

(statearr_56793_56817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (13))){
var inst_56769 = (state_56789[(2)]);
var inst_56770 = fluree.db.util.async.throw_err.call(null,inst_56769);
var state_56789__$1 = state_56789;
var statearr_56794_56818 = state_56789__$1;
(statearr_56794_56818[(2)] = inst_56770);

(statearr_56794_56818[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (6))){
var state_56789__$1 = state_56789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56789__$1,(9),n);
} else {
if((state_val_56790 === (3))){
var inst_56787 = (state_56789[(2)]);
var state_56789__$1 = state_56789;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56789__$1,inst_56787);
} else {
if((state_val_56790 === (12))){
var inst_56765 = (state_56789[(7)]);
var inst_56773 = (state_56789[(2)]);
var inst_56774 = fluree.db.dbfunctions.internal.mod.call(null,inst_56765,inst_56773);
var inst_56775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56776 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56778 = [inst_56765,inst_56773];
var inst_56779 = (new cljs.core.PersistentVector(null,2,(5),inst_56777,inst_56778,null));
var inst_56780 = ["mod",inst_56779,inst_56774];
var inst_56781 = cljs.core.PersistentHashMap.fromArrays(inst_56776,inst_56780);
var inst_56782 = [inst_56781,(2)];
var inst_56783 = (new cljs.core.PersistentVector(null,2,(5),inst_56775,inst_56782,null));
var inst_56784 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56783);
var _ = (function (){var statearr_56795 = state_56789;
(statearr_56795[(4)] = cljs.core.rest.call(null,(state_56789[(4)])));

return statearr_56795;
})();
var state_56789__$1 = (function (){var statearr_56796 = state_56789;
(statearr_56796[(8)] = inst_56784);

return statearr_56796;
})();
var statearr_56797_56819 = state_56789__$1;
(statearr_56797_56819[(2)] = inst_56774);

(statearr_56797_56819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (2))){
var _ = (function (){var statearr_56798 = state_56789;
(statearr_56798[(4)] = cljs.core.cons.call(null,(5),(state_56789[(4)])));

return statearr_56798;
})();
var inst_56758 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56789__$1 = state_56789;
if(inst_56758){
var statearr_56799_56820 = state_56789__$1;
(statearr_56799_56820[(1)] = (6));

} else {
var statearr_56800_56821 = state_56789__$1;
(statearr_56800_56821[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (11))){
var state_56789__$1 = state_56789;
var statearr_56802_56822 = state_56789__$1;
(statearr_56802_56822[(2)] = d);

(statearr_56802_56822[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (9))){
var inst_56761 = (state_56789[(2)]);
var inst_56762 = fluree.db.util.async.throw_err.call(null,inst_56761);
var state_56789__$1 = state_56789;
var statearr_56803_56823 = state_56789__$1;
(statearr_56803_56823[(2)] = inst_56762);

(statearr_56803_56823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (5))){
var _ = (function (){var statearr_56804 = state_56789;
(statearr_56804[(4)] = cljs.core.rest.call(null,(state_56789[(4)])));

return statearr_56804;
})();
var state_56789__$1 = state_56789;
var ex56801 = (state_56789__$1[(2)]);
var statearr_56805_56824 = state_56789__$1;
(statearr_56805_56824[(5)] = ex56801);


if((ex56801 instanceof Error)){
var statearr_56806_56825 = state_56789__$1;
(statearr_56806_56825[(1)] = (4));

(statearr_56806_56825[(5)] = null);

} else {
throw ex56801;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56790 === (10))){
var state_56789__$1 = state_56789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56789__$1,(13),d);
} else {
if((state_val_56790 === (8))){
var inst_56765 = (state_56789[(2)]);
var inst_56766 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56789__$1 = (function (){var statearr_56807 = state_56789;
(statearr_56807[(7)] = inst_56765);

return statearr_56807;
})();
if(inst_56766){
var statearr_56808_56826 = state_56789__$1;
(statearr_56808_56826[(1)] = (10));

} else {
var statearr_56809_56827 = state_56789__$1;
(statearr_56809_56827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto____0 = (function (){
var statearr_56810 = [null,null,null,null,null,null,null,null,null];
(statearr_56810[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto__);

(statearr_56810[(1)] = (1));

return statearr_56810;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto____1 = (function (state_56789){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56789);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56811){var ex__2729__auto__ = e56811;
var statearr_56812_56828 = state_56789;
(statearr_56812_56828[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56789[(4)]))){
var statearr_56813_56829 = state_56789;
(statearr_56813_56829[(1)] = cljs.core.first.call(null,(state_56789[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56830 = state_56789;
state_56789 = G__56830;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto__ = function(state_56789){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto____1.call(this,state_56789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56814 = f__2749__auto__.call(null);
(statearr_56814[(6)] = c__2748__auto__);

return statearr_56814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56868){
var state_val_56869 = (state_56868[(1)]);
if((state_val_56869 === (7))){
var state_56868__$1 = state_56868;
var statearr_56870_56894 = state_56868__$1;
(statearr_56870_56894[(2)] = n);

(statearr_56870_56894[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (1))){
var state_56868__$1 = state_56868;
var statearr_56871_56895 = state_56868__$1;
(statearr_56871_56895[(2)] = null);

(statearr_56871_56895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (4))){
var inst_56831 = (state_56868[(2)]);
var state_56868__$1 = state_56868;
var statearr_56872_56896 = state_56868__$1;
(statearr_56872_56896[(2)] = inst_56831);

(statearr_56872_56896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (13))){
var inst_56848 = (state_56868[(2)]);
var inst_56849 = fluree.db.util.async.throw_err.call(null,inst_56848);
var state_56868__$1 = state_56868;
var statearr_56873_56897 = state_56868__$1;
(statearr_56873_56897[(2)] = inst_56849);

(statearr_56873_56897[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (6))){
var state_56868__$1 = state_56868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56868__$1,(9),n);
} else {
if((state_val_56869 === (3))){
var inst_56866 = (state_56868[(2)]);
var state_56868__$1 = state_56868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56868__$1,inst_56866);
} else {
if((state_val_56869 === (12))){
var inst_56844 = (state_56868[(7)]);
var inst_56852 = (state_56868[(2)]);
var inst_56853 = fluree.db.dbfunctions.internal.rem.call(null,inst_56844,inst_56852);
var inst_56854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56855 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56857 = [inst_56844,inst_56852];
var inst_56858 = (new cljs.core.PersistentVector(null,2,(5),inst_56856,inst_56857,null));
var inst_56859 = ["rem",inst_56858,inst_56853];
var inst_56860 = cljs.core.PersistentHashMap.fromArrays(inst_56855,inst_56859);
var inst_56861 = [inst_56860,(2)];
var inst_56862 = (new cljs.core.PersistentVector(null,2,(5),inst_56854,inst_56861,null));
var inst_56863 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56862);
var _ = (function (){var statearr_56874 = state_56868;
(statearr_56874[(4)] = cljs.core.rest.call(null,(state_56868[(4)])));

return statearr_56874;
})();
var state_56868__$1 = (function (){var statearr_56875 = state_56868;
(statearr_56875[(8)] = inst_56863);

return statearr_56875;
})();
var statearr_56876_56898 = state_56868__$1;
(statearr_56876_56898[(2)] = inst_56853);

(statearr_56876_56898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (2))){
var _ = (function (){var statearr_56877 = state_56868;
(statearr_56877[(4)] = cljs.core.cons.call(null,(5),(state_56868[(4)])));

return statearr_56877;
})();
var inst_56837 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56868__$1 = state_56868;
if(inst_56837){
var statearr_56878_56899 = state_56868__$1;
(statearr_56878_56899[(1)] = (6));

} else {
var statearr_56879_56900 = state_56868__$1;
(statearr_56879_56900[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (11))){
var state_56868__$1 = state_56868;
var statearr_56881_56901 = state_56868__$1;
(statearr_56881_56901[(2)] = d);

(statearr_56881_56901[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (9))){
var inst_56840 = (state_56868[(2)]);
var inst_56841 = fluree.db.util.async.throw_err.call(null,inst_56840);
var state_56868__$1 = state_56868;
var statearr_56882_56902 = state_56868__$1;
(statearr_56882_56902[(2)] = inst_56841);

(statearr_56882_56902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (5))){
var _ = (function (){var statearr_56883 = state_56868;
(statearr_56883[(4)] = cljs.core.rest.call(null,(state_56868[(4)])));

return statearr_56883;
})();
var state_56868__$1 = state_56868;
var ex56880 = (state_56868__$1[(2)]);
var statearr_56884_56903 = state_56868__$1;
(statearr_56884_56903[(5)] = ex56880);


if((ex56880 instanceof Error)){
var statearr_56885_56904 = state_56868__$1;
(statearr_56885_56904[(1)] = (4));

(statearr_56885_56904[(5)] = null);

} else {
throw ex56880;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56869 === (10))){
var state_56868__$1 = state_56868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56868__$1,(13),d);
} else {
if((state_val_56869 === (8))){
var inst_56844 = (state_56868[(2)]);
var inst_56845 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_56868__$1 = (function (){var statearr_56886 = state_56868;
(statearr_56886[(7)] = inst_56844);

return statearr_56886;
})();
if(inst_56845){
var statearr_56887_56905 = state_56868__$1;
(statearr_56887_56905[(1)] = (10));

} else {
var statearr_56888_56906 = state_56868__$1;
(statearr_56888_56906[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto____0 = (function (){
var statearr_56889 = [null,null,null,null,null,null,null,null,null];
(statearr_56889[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto__);

(statearr_56889[(1)] = (1));

return statearr_56889;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto____1 = (function (state_56868){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56890){var ex__2729__auto__ = e56890;
var statearr_56891_56907 = state_56868;
(statearr_56891_56907[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56868[(4)]))){
var statearr_56892_56908 = state_56868;
(statearr_56892_56908[(1)] = cljs.core.first.call(null,(state_56868[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56909 = state_56868;
state_56868 = G__56909;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto__ = function(state_56868){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto____1.call(this,state_56868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56893 = f__2749__auto__.call(null);
(statearr_56893[(6)] = c__2748__auto__);

return statearr_56893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_56936){
var state_val_56937 = (state_56936[(1)]);
if((state_val_56937 === (7))){
var state_56936__$1 = state_56936;
var statearr_56938_56957 = state_56936__$1;
(statearr_56938_56957[(2)] = x);

(statearr_56938_56957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56937 === (1))){
var state_56936__$1 = state_56936;
var statearr_56939_56958 = state_56936__$1;
(statearr_56939_56958[(2)] = null);

(statearr_56939_56958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56937 === (4))){
var inst_56910 = (state_56936[(2)]);
var state_56936__$1 = state_56936;
var statearr_56940_56959 = state_56936__$1;
(statearr_56940_56959[(2)] = inst_56910);

(statearr_56940_56959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56937 === (6))){
var state_56936__$1 = state_56936;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56936__$1,(9),x);
} else {
if((state_val_56937 === (3))){
var inst_56934 = (state_56936[(2)]);
var state_56936__$1 = state_56936;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56936__$1,inst_56934);
} else {
if((state_val_56937 === (2))){
var _ = (function (){var statearr_56942 = state_56936;
(statearr_56942[(4)] = cljs.core.cons.call(null,(5),(state_56936[(4)])));

return statearr_56942;
})();
var inst_56916 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_56936__$1 = state_56936;
if(inst_56916){
var statearr_56943_56960 = state_56936__$1;
(statearr_56943_56960[(1)] = (6));

} else {
var statearr_56944_56961 = state_56936__$1;
(statearr_56944_56961[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56937 === (9))){
var inst_56919 = (state_56936[(2)]);
var inst_56920 = fluree.db.util.async.throw_err.call(null,inst_56919);
var state_56936__$1 = state_56936;
var statearr_56945_56962 = state_56936__$1;
(statearr_56945_56962[(2)] = inst_56920);

(statearr_56945_56962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56937 === (5))){
var _ = (function (){var statearr_56946 = state_56936;
(statearr_56946[(4)] = cljs.core.rest.call(null,(state_56936[(4)])));

return statearr_56946;
})();
var state_56936__$1 = state_56936;
var ex56941 = (state_56936__$1[(2)]);
var statearr_56947_56963 = state_56936__$1;
(statearr_56947_56963[(5)] = ex56941);


if((ex56941 instanceof Error)){
var statearr_56948_56964 = state_56936__$1;
(statearr_56948_56964[(1)] = (4));

(statearr_56948_56964[(5)] = null);

} else {
throw ex56941;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56937 === (8))){
var inst_56923 = (state_56936[(2)]);
var inst_56924 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_56923);
var inst_56925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56926 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56927 = ["boolean",inst_56923,inst_56924];
var inst_56928 = cljs.core.PersistentHashMap.fromArrays(inst_56926,inst_56927);
var inst_56929 = [inst_56928,(10)];
var inst_56930 = (new cljs.core.PersistentVector(null,2,(5),inst_56925,inst_56929,null));
var inst_56931 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56930);
var _ = (function (){var statearr_56949 = state_56936;
(statearr_56949[(4)] = cljs.core.rest.call(null,(state_56936[(4)])));

return statearr_56949;
})();
var state_56936__$1 = (function (){var statearr_56950 = state_56936;
(statearr_56950[(7)] = inst_56931);

return statearr_56950;
})();
var statearr_56951_56965 = state_56936__$1;
(statearr_56951_56965[(2)] = inst_56924);

(statearr_56951_56965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto____0 = (function (){
var statearr_56952 = [null,null,null,null,null,null,null,null];
(statearr_56952[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto__);

(statearr_56952[(1)] = (1));

return statearr_56952;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto____1 = (function (state_56936){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_56936);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e56953){var ex__2729__auto__ = e56953;
var statearr_56954_56966 = state_56936;
(statearr_56954_56966[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_56936[(4)]))){
var statearr_56955_56967 = state_56936;
(statearr_56955_56967[(1)] = cljs.core.first.call(null,(state_56936[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56968 = state_56936;
state_56936 = G__56968;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto__ = function(state_56936){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto____1.call(this,state_56936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_56956 = f__2749__auto__.call(null);
(statearr_56956[(6)] = c__2748__auto__);

return statearr_56956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57006){
var state_val_57007 = (state_57006[(1)]);
if((state_val_57007 === (7))){
var state_57006__$1 = state_57006;
var statearr_57008_57032 = state_57006__$1;
(statearr_57008_57032[(2)] = pattern);

(statearr_57008_57032[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (1))){
var state_57006__$1 = state_57006;
var statearr_57009_57033 = state_57006__$1;
(statearr_57009_57033[(2)] = null);

(statearr_57009_57033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (4))){
var inst_56969 = (state_57006[(2)]);
var state_57006__$1 = state_57006;
var statearr_57010_57034 = state_57006__$1;
(statearr_57010_57034[(2)] = inst_56969);

(statearr_57010_57034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (13))){
var inst_56986 = (state_57006[(2)]);
var inst_56987 = fluree.db.util.async.throw_err.call(null,inst_56986);
var state_57006__$1 = state_57006;
var statearr_57011_57035 = state_57006__$1;
(statearr_57011_57035[(2)] = inst_56987);

(statearr_57011_57035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (6))){
var state_57006__$1 = state_57006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57006__$1,(9),pattern);
} else {
if((state_val_57007 === (3))){
var inst_57004 = (state_57006[(2)]);
var state_57006__$1 = state_57006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57006__$1,inst_57004);
} else {
if((state_val_57007 === (12))){
var inst_56982 = (state_57006[(7)]);
var inst_56990 = (state_57006[(2)]);
var inst_56991 = fluree.db.dbfunctions.internal.re_find.call(null,inst_56982,inst_56990);
var inst_56992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56993 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56995 = [inst_56982,inst_56990];
var inst_56996 = (new cljs.core.PersistentVector(null,2,(5),inst_56994,inst_56995,null));
var inst_56997 = ["re-find",inst_56996,inst_56991];
var inst_56998 = cljs.core.PersistentHashMap.fromArrays(inst_56993,inst_56997);
var inst_56999 = [inst_56998,(10)];
var inst_57000 = (new cljs.core.PersistentVector(null,2,(5),inst_56992,inst_56999,null));
var inst_57001 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57000);
var _ = (function (){var statearr_57012 = state_57006;
(statearr_57012[(4)] = cljs.core.rest.call(null,(state_57006[(4)])));

return statearr_57012;
})();
var state_57006__$1 = (function (){var statearr_57013 = state_57006;
(statearr_57013[(8)] = inst_57001);

return statearr_57013;
})();
var statearr_57014_57036 = state_57006__$1;
(statearr_57014_57036[(2)] = inst_56991);

(statearr_57014_57036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (2))){
var _ = (function (){var statearr_57015 = state_57006;
(statearr_57015[(4)] = cljs.core.cons.call(null,(5),(state_57006[(4)])));

return statearr_57015;
})();
var inst_56975 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_57006__$1 = state_57006;
if(inst_56975){
var statearr_57016_57037 = state_57006__$1;
(statearr_57016_57037[(1)] = (6));

} else {
var statearr_57017_57038 = state_57006__$1;
(statearr_57017_57038[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (11))){
var state_57006__$1 = state_57006;
var statearr_57019_57039 = state_57006__$1;
(statearr_57019_57039[(2)] = string);

(statearr_57019_57039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (9))){
var inst_56978 = (state_57006[(2)]);
var inst_56979 = fluree.db.util.async.throw_err.call(null,inst_56978);
var state_57006__$1 = state_57006;
var statearr_57020_57040 = state_57006__$1;
(statearr_57020_57040[(2)] = inst_56979);

(statearr_57020_57040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (5))){
var _ = (function (){var statearr_57021 = state_57006;
(statearr_57021[(4)] = cljs.core.rest.call(null,(state_57006[(4)])));

return statearr_57021;
})();
var state_57006__$1 = state_57006;
var ex57018 = (state_57006__$1[(2)]);
var statearr_57022_57041 = state_57006__$1;
(statearr_57022_57041[(5)] = ex57018);


if((ex57018 instanceof Error)){
var statearr_57023_57042 = state_57006__$1;
(statearr_57023_57042[(1)] = (4));

(statearr_57023_57042[(5)] = null);

} else {
throw ex57018;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57007 === (10))){
var state_57006__$1 = state_57006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57006__$1,(13),string);
} else {
if((state_val_57007 === (8))){
var inst_56982 = (state_57006[(2)]);
var inst_56983 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_57006__$1 = (function (){var statearr_57024 = state_57006;
(statearr_57024[(7)] = inst_56982);

return statearr_57024;
})();
if(inst_56983){
var statearr_57025_57043 = state_57006__$1;
(statearr_57025_57043[(1)] = (10));

} else {
var statearr_57026_57044 = state_57006__$1;
(statearr_57026_57044[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto____0 = (function (){
var statearr_57027 = [null,null,null,null,null,null,null,null,null];
(statearr_57027[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto__);

(statearr_57027[(1)] = (1));

return statearr_57027;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto____1 = (function (state_57006){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57028){var ex__2729__auto__ = e57028;
var statearr_57029_57045 = state_57006;
(statearr_57029_57045[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57006[(4)]))){
var statearr_57030_57046 = state_57006;
(statearr_57030_57046[(1)] = cljs.core.first.call(null,(state_57006[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57047 = state_57006;
state_57006 = G__57047;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto__ = function(state_57006){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto____1.call(this,state_57006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57031 = f__2749__auto__.call(null);
(statearr_57031[(6)] = c__2748__auto__);

return statearr_57031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57074){
var state_val_57075 = (state_57074[(1)]);
if((state_val_57075 === (7))){
var state_57074__$1 = state_57074;
var statearr_57076_57095 = state_57074__$1;
(statearr_57076_57095[(2)] = email);

(statearr_57076_57095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57075 === (1))){
var state_57074__$1 = state_57074;
var statearr_57077_57096 = state_57074__$1;
(statearr_57077_57096[(2)] = null);

(statearr_57077_57096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57075 === (4))){
var inst_57048 = (state_57074[(2)]);
var state_57074__$1 = state_57074;
var statearr_57078_57097 = state_57074__$1;
(statearr_57078_57097[(2)] = inst_57048);

(statearr_57078_57097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57075 === (6))){
var state_57074__$1 = state_57074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57074__$1,(9),email);
} else {
if((state_val_57075 === (3))){
var inst_57072 = (state_57074[(2)]);
var state_57074__$1 = state_57074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57074__$1,inst_57072);
} else {
if((state_val_57075 === (2))){
var _ = (function (){var statearr_57080 = state_57074;
(statearr_57080[(4)] = cljs.core.cons.call(null,(5),(state_57074[(4)])));

return statearr_57080;
})();
var inst_57054 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_57074__$1 = state_57074;
if(inst_57054){
var statearr_57081_57098 = state_57074__$1;
(statearr_57081_57098[(1)] = (6));

} else {
var statearr_57082_57099 = state_57074__$1;
(statearr_57082_57099[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57075 === (9))){
var inst_57057 = (state_57074[(2)]);
var inst_57058 = fluree.db.util.async.throw_err.call(null,inst_57057);
var state_57074__$1 = state_57074;
var statearr_57083_57100 = state_57074__$1;
(statearr_57083_57100[(2)] = inst_57058);

(statearr_57083_57100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57075 === (5))){
var _ = (function (){var statearr_57084 = state_57074;
(statearr_57084[(4)] = cljs.core.rest.call(null,(state_57074[(4)])));

return statearr_57084;
})();
var state_57074__$1 = state_57074;
var ex57079 = (state_57074__$1[(2)]);
var statearr_57085_57101 = state_57074__$1;
(statearr_57085_57101[(5)] = ex57079);


if((ex57079 instanceof Error)){
var statearr_57086_57102 = state_57074__$1;
(statearr_57086_57102[(1)] = (4));

(statearr_57086_57102[(5)] = null);

} else {
throw ex57079;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57075 === (8))){
var inst_57061 = (state_57074[(2)]);
var inst_57062 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_57061);
var inst_57063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57064 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57065 = ["re-find",inst_57061,inst_57062];
var inst_57066 = cljs.core.PersistentHashMap.fromArrays(inst_57064,inst_57065);
var inst_57067 = [inst_57066,(10)];
var inst_57068 = (new cljs.core.PersistentVector(null,2,(5),inst_57063,inst_57067,null));
var inst_57069 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57068);
var _ = (function (){var statearr_57087 = state_57074;
(statearr_57087[(4)] = cljs.core.rest.call(null,(state_57074[(4)])));

return statearr_57087;
})();
var state_57074__$1 = (function (){var statearr_57088 = state_57074;
(statearr_57088[(7)] = inst_57069);

return statearr_57088;
})();
var statearr_57089_57103 = state_57074__$1;
(statearr_57089_57103[(2)] = inst_57062);

(statearr_57089_57103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_57090 = [null,null,null,null,null,null,null,null];
(statearr_57090[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto__);

(statearr_57090[(1)] = (1));

return statearr_57090;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto____1 = (function (state_57074){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57091){var ex__2729__auto__ = e57091;
var statearr_57092_57104 = state_57074;
(statearr_57092_57104[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57074[(4)]))){
var statearr_57093_57105 = state_57074;
(statearr_57093_57105[(1)] = cljs.core.first.call(null,(state_57074[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57106 = state_57074;
state_57074 = G__57106;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto__ = function(state_57074){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto____1.call(this,state_57074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57094 = f__2749__auto__.call(null);
(statearr_57094[(6)] = c__2748__auto__);

return statearr_57094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57153){
var state_val_57154 = (state_57153[(1)]);
if((state_val_57154 === (7))){
var inst_57123 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57153__$1 = state_57153;
if(cljs.core.truth_(inst_57123)){
var statearr_57155_57182 = state_57153__$1;
(statearr_57155_57182[(1)] = (9));

} else {
var statearr_57156_57183 = state_57153__$1;
(statearr_57156_57183[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (1))){
var state_57153__$1 = state_57153;
var statearr_57157_57184 = state_57153__$1;
(statearr_57157_57184[(2)] = null);

(statearr_57157_57184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (4))){
var inst_57107 = (state_57153[(2)]);
var state_57153__$1 = state_57153;
var statearr_57158_57185 = state_57153__$1;
(statearr_57158_57185[(2)] = inst_57107);

(statearr_57158_57185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (15))){
var inst_57134 = (state_57153[(2)]);
var state_57153__$1 = state_57153;
var statearr_57159_57186 = state_57153__$1;
(statearr_57159_57186[(2)] = inst_57134);

(statearr_57159_57186[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (13))){
var inst_57131 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57153__$1 = state_57153;
var statearr_57160_57187 = state_57153__$1;
(statearr_57160_57187[(2)] = inst_57131);

(statearr_57160_57187[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (6))){
var inst_57118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57119 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57120 = [inst_57119,(0)];
var inst_57121 = (new cljs.core.PersistentVector(null,2,(5),inst_57118,inst_57120,null));
var state_57153__$1 = state_57153;
var statearr_57161_57188 = state_57153__$1;
(statearr_57161_57188[(2)] = inst_57121);

(statearr_57161_57188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (3))){
var inst_57151 = (state_57153[(2)]);
var state_57153__$1 = state_57153;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57153__$1,inst_57151);
} else {
if((state_val_57154 === (12))){
var inst_57127 = (state_57153[(2)]);
var inst_57128 = fluree.db.util.async.throw_err.call(null,inst_57127);
var state_57153__$1 = state_57153;
var statearr_57162_57189 = state_57153__$1;
(statearr_57162_57189[(2)] = inst_57128);

(statearr_57162_57189[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (2))){
var _ = (function (){var statearr_57163 = state_57153;
(statearr_57163[(4)] = cljs.core.cons.call(null,(5),(state_57153[(4)])));

return statearr_57163;
})();
var inst_57116 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57153__$1 = state_57153;
if(cljs.core.truth_(inst_57116)){
var statearr_57164_57190 = state_57153__$1;
(statearr_57164_57190[(1)] = (6));

} else {
var statearr_57165_57191 = state_57153__$1;
(statearr_57165_57191[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (11))){
var inst_57136 = (state_57153[(2)]);
var state_57153__$1 = state_57153;
var statearr_57167_57192 = state_57153__$1;
(statearr_57167_57192[(2)] = inst_57136);

(statearr_57167_57192[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (9))){
var inst_57125 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_57153__$1 = state_57153;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57153__$1,(12),inst_57125);
} else {
if((state_val_57154 === (5))){
var _ = (function (){var statearr_57168 = state_57153;
(statearr_57168[(4)] = cljs.core.rest.call(null,(state_57153[(4)])));

return statearr_57168;
})();
var state_57153__$1 = state_57153;
var ex57166 = (state_57153__$1[(2)]);
var statearr_57169_57193 = state_57153__$1;
(statearr_57169_57193[(5)] = ex57166);


if((ex57166 instanceof Error)){
var statearr_57170_57194 = state_57153__$1;
(statearr_57170_57194[(1)] = (4));

(statearr_57170_57194[(5)] = null);

} else {
throw ex57166;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (14))){
var state_57153__$1 = state_57153;
var statearr_57171_57195 = state_57153__$1;
(statearr_57171_57195[(2)] = null);

(statearr_57171_57195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (10))){
var state_57153__$1 = state_57153;
var statearr_57172_57196 = state_57153__$1;
(statearr_57172_57196[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57154 === (8))){
var inst_57138 = (state_57153[(2)]);
var inst_57139 = cljs.core.nth.call(null,inst_57138,(0),null);
var inst_57140 = cljs.core.nth.call(null,inst_57138,(1),null);
var inst_57141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57142 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57143 = ["?user_id","?ctx",inst_57139];
var inst_57144 = cljs.core.PersistentHashMap.fromArrays(inst_57142,inst_57143);
var inst_57145 = ((10) + inst_57140);
var inst_57146 = [inst_57144,inst_57145];
var inst_57147 = (new cljs.core.PersistentVector(null,2,(5),inst_57141,inst_57146,null));
var inst_57148 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57147);
var _ = (function (){var statearr_57174 = state_57153;
(statearr_57174[(4)] = cljs.core.rest.call(null,(state_57153[(4)])));

return statearr_57174;
})();
var state_57153__$1 = (function (){var statearr_57175 = state_57153;
(statearr_57175[(7)] = inst_57148);

return statearr_57175;
})();
var statearr_57176_57197 = state_57153__$1;
(statearr_57176_57197[(2)] = inst_57139);

(statearr_57176_57197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto____0 = (function (){
var statearr_57177 = [null,null,null,null,null,null,null,null];
(statearr_57177[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto__);

(statearr_57177[(1)] = (1));

return statearr_57177;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto____1 = (function (state_57153){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57153);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57178){var ex__2729__auto__ = e57178;
var statearr_57179_57198 = state_57153;
(statearr_57179_57198[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57153[(4)]))){
var statearr_57180_57199 = state_57153;
(statearr_57180_57199[(1)] = cljs.core.first.call(null,(state_57153[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57200 = state_57153;
state_57153 = G__57200;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto__ = function(state_57153){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto____1.call(this,state_57153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57181 = f__2749__auto__.call(null);
(statearr_57181[(6)] = c__2748__auto__);

return statearr_57181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57228){
var state_val_57229 = (state_57228[(1)]);
if((state_val_57229 === (7))){
var inst_57221 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57228__$1 = state_57228;
var statearr_57230_57249 = state_57228__$1;
(statearr_57230_57249[(2)] = inst_57221);

(statearr_57230_57249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57229 === (1))){
var state_57228__$1 = state_57228;
var statearr_57231_57250 = state_57228__$1;
(statearr_57231_57250[(2)] = null);

(statearr_57231_57250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57229 === (4))){
var inst_57201 = (state_57228[(2)]);
var state_57228__$1 = state_57228;
var statearr_57232_57251 = state_57228__$1;
(statearr_57232_57251[(2)] = inst_57201);

(statearr_57232_57251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57229 === (6))){
var inst_57209 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_57228__$1 = state_57228;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57228__$1,(9),inst_57209);
} else {
if((state_val_57229 === (3))){
var inst_57226 = (state_57228[(2)]);
var state_57228__$1 = state_57228;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57228__$1,inst_57226);
} else {
if((state_val_57229 === (2))){
var _ = (function (){var statearr_57234 = state_57228;
(statearr_57234[(4)] = cljs.core.cons.call(null,(5),(state_57228[(4)])));

return statearr_57234;
})();
var inst_57207 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57228__$1 = state_57228;
if(cljs.core.truth_(inst_57207)){
var statearr_57235_57252 = state_57228__$1;
(statearr_57235_57252[(1)] = (6));

} else {
var statearr_57236_57253 = state_57228__$1;
(statearr_57236_57253[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57229 === (9))){
var inst_57211 = (state_57228[(2)]);
var inst_57212 = fluree.db.util.async.throw_err.call(null,inst_57211);
var inst_57213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57214 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57215 = ["?auth_id","?ctx",inst_57212];
var inst_57216 = cljs.core.PersistentHashMap.fromArrays(inst_57214,inst_57215);
var inst_57217 = [inst_57216,(10)];
var inst_57218 = (new cljs.core.PersistentVector(null,2,(5),inst_57213,inst_57217,null));
var inst_57219 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57218);
var state_57228__$1 = (function (){var statearr_57237 = state_57228;
(statearr_57237[(7)] = inst_57219);

return statearr_57237;
})();
var statearr_57238_57254 = state_57228__$1;
(statearr_57238_57254[(2)] = inst_57212);

(statearr_57238_57254[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57229 === (5))){
var _ = (function (){var statearr_57239 = state_57228;
(statearr_57239[(4)] = cljs.core.rest.call(null,(state_57228[(4)])));

return statearr_57239;
})();
var state_57228__$1 = state_57228;
var ex57233 = (state_57228__$1[(2)]);
var statearr_57240_57255 = state_57228__$1;
(statearr_57240_57255[(5)] = ex57233);


if((ex57233 instanceof Error)){
var statearr_57241_57256 = state_57228__$1;
(statearr_57241_57256[(1)] = (4));

(statearr_57241_57256[(5)] = null);

} else {
throw ex57233;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57229 === (8))){
var inst_57223 = (state_57228[(2)]);
var _ = (function (){var statearr_57242 = state_57228;
(statearr_57242[(4)] = cljs.core.rest.call(null,(state_57228[(4)])));

return statearr_57242;
})();
var state_57228__$1 = state_57228;
var statearr_57243_57257 = state_57228__$1;
(statearr_57243_57257[(2)] = inst_57223);

(statearr_57243_57257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto____0 = (function (){
var statearr_57244 = [null,null,null,null,null,null,null,null];
(statearr_57244[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto__);

(statearr_57244[(1)] = (1));

return statearr_57244;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto____1 = (function (state_57228){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57228);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57245){var ex__2729__auto__ = e57245;
var statearr_57246_57258 = state_57228;
(statearr_57246_57258[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57228[(4)]))){
var statearr_57247_57259 = state_57228;
(statearr_57247_57259[(1)] = cljs.core.first.call(null,(state_57228[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57260 = state_57228;
state_57228 = G__57260;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto__ = function(state_57228){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto____1.call(this,state_57228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57248 = f__2749__auto__.call(null);
(statearr_57248[(6)] = c__2748__auto__);

return statearr_57248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57262 = arguments.length;
switch (G__57262) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57304){
var state_val_57305 = (state_57304[(1)]);
if((state_val_57305 === (7))){
var state_57304__$1 = state_57304;
var statearr_57306_57336 = state_57304__$1;
(statearr_57306_57336[(2)] = seed);

(statearr_57306_57336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (1))){
var state_57304__$1 = state_57304;
var statearr_57307_57337 = state_57304__$1;
(statearr_57307_57337[(2)] = null);

(statearr_57307_57337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (4))){
var inst_57263 = (state_57304[(2)]);
var state_57304__$1 = state_57304;
var statearr_57308_57338 = state_57304__$1;
(statearr_57308_57338[(2)] = inst_57263);

(statearr_57308_57338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (15))){
var state_57304__$1 = state_57304;
var statearr_57309_57339 = state_57304__$1;
(statearr_57309_57339[(2)] = (10));

(statearr_57309_57339[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (13))){
var inst_57280 = (state_57304[(2)]);
var inst_57281 = fluree.db.util.async.throw_err.call(null,inst_57280);
var state_57304__$1 = state_57304;
var statearr_57310_57340 = state_57304__$1;
(statearr_57310_57340[(2)] = inst_57281);

(statearr_57310_57340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (6))){
var state_57304__$1 = state_57304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57304__$1,(9),seed);
} else {
if((state_val_57305 === (3))){
var inst_57302 = (state_57304[(2)]);
var state_57304__$1 = state_57304;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57304__$1,inst_57302);
} else {
if((state_val_57305 === (12))){
var inst_57284 = (state_57304[(7)]);
var inst_57284__$1 = (state_57304[(2)]);
var state_57304__$1 = (function (){var statearr_57311 = state_57304;
(statearr_57311[(7)] = inst_57284__$1);

return statearr_57311;
})();
if(cljs.core.truth_(inst_57284__$1)){
var statearr_57312_57341 = state_57304__$1;
(statearr_57312_57341[(1)] = (14));

} else {
var statearr_57313_57342 = state_57304__$1;
(statearr_57313_57342[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (2))){
var _ = (function (){var statearr_57314 = state_57304;
(statearr_57314[(4)] = cljs.core.cons.call(null,(5),(state_57304[(4)])));

return statearr_57314;
})();
var inst_57269 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_57304__$1 = state_57304;
if(inst_57269){
var statearr_57315_57343 = state_57304__$1;
(statearr_57315_57343[(1)] = (6));

} else {
var statearr_57316_57344 = state_57304__$1;
(statearr_57316_57344[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (11))){
var state_57304__$1 = state_57304;
var statearr_57318_57345 = state_57304__$1;
(statearr_57318_57345[(2)] = max);

(statearr_57318_57345[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (9))){
var inst_57272 = (state_57304[(2)]);
var inst_57273 = fluree.db.util.async.throw_err.call(null,inst_57272);
var state_57304__$1 = state_57304;
var statearr_57319_57346 = state_57304__$1;
(statearr_57319_57346[(2)] = inst_57273);

(statearr_57319_57346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (5))){
var _ = (function (){var statearr_57320 = state_57304;
(statearr_57320[(4)] = cljs.core.rest.call(null,(state_57304[(4)])));

return statearr_57320;
})();
var state_57304__$1 = state_57304;
var ex57317 = (state_57304__$1[(2)]);
var statearr_57321_57347 = state_57304__$1;
(statearr_57321_57347[(5)] = ex57317);


if((ex57317 instanceof Error)){
var statearr_57322_57348 = state_57304__$1;
(statearr_57322_57348[(1)] = (4));

(statearr_57322_57348[(5)] = null);

} else {
throw ex57317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (14))){
var inst_57284 = (state_57304[(7)]);
var state_57304__$1 = state_57304;
var statearr_57323_57349 = state_57304__$1;
(statearr_57323_57349[(2)] = inst_57284);

(statearr_57323_57349[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (16))){
var inst_57276 = (state_57304[(8)]);
var inst_57288 = (state_57304[(2)]);
var inst_57289 = fluree.db.dbfunctions.internal.rand.call(null,inst_57276,inst_57288);
var inst_57290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57291 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57293 = [max,seed];
var inst_57294 = (new cljs.core.PersistentVector(null,2,(5),inst_57292,inst_57293,null));
var inst_57295 = ["rand",inst_57294,inst_57289];
var inst_57296 = cljs.core.PersistentHashMap.fromArrays(inst_57291,inst_57295);
var inst_57297 = [inst_57296,(10)];
var inst_57298 = (new cljs.core.PersistentVector(null,2,(5),inst_57290,inst_57297,null));
var inst_57299 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57298);
var _ = (function (){var statearr_57324 = state_57304;
(statearr_57324[(4)] = cljs.core.rest.call(null,(state_57304[(4)])));

return statearr_57324;
})();
var state_57304__$1 = (function (){var statearr_57325 = state_57304;
(statearr_57325[(9)] = inst_57299);

return statearr_57325;
})();
var statearr_57326_57350 = state_57304__$1;
(statearr_57326_57350[(2)] = inst_57289);

(statearr_57326_57350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57305 === (10))){
var state_57304__$1 = state_57304;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57304__$1,(13),max);
} else {
if((state_val_57305 === (8))){
var inst_57276 = (state_57304[(2)]);
var inst_57277 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_57304__$1 = (function (){var statearr_57327 = state_57304;
(statearr_57327[(8)] = inst_57276);

return statearr_57327;
})();
if(inst_57277){
var statearr_57328_57351 = state_57304__$1;
(statearr_57328_57351[(1)] = (10));

} else {
var statearr_57329_57352 = state_57304__$1;
(statearr_57329_57352[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2726__auto____0 = (function (){
var statearr_57330 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57330[(0)] = fluree$db$dbfunctions$fns$state_machine__2726__auto__);

(statearr_57330[(1)] = (1));

return statearr_57330;
});
var fluree$db$dbfunctions$fns$state_machine__2726__auto____1 = (function (state_57304){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57304);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57331){var ex__2729__auto__ = e57331;
var statearr_57332_57353 = state_57304;
(statearr_57332_57353[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57304[(4)]))){
var statearr_57333_57354 = state_57304;
(statearr_57333_57354[(1)] = cljs.core.first.call(null,(state_57304[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57355 = state_57304;
state_57304 = G__57355;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2726__auto__ = function(state_57304){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2726__auto____1.call(this,state_57304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57334 = f__2749__auto__.call(null);
(statearr_57334[(6)] = c__2748__auto__);

return statearr_57334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57376){
var state_val_57377 = (state_57376[(1)]);
if((state_val_57377 === (1))){
var state_57376__$1 = state_57376;
var statearr_57378_57393 = state_57376__$1;
(statearr_57378_57393[(2)] = null);

(statearr_57378_57393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57377 === (2))){
var _ = (function (){var statearr_57379 = state_57376;
(statearr_57379[(4)] = cljs.core.cons.call(null,(5),(state_57376[(4)])));

return statearr_57379;
})();
var inst_57362 = fluree.db.util.core.random_uuid.call(null);
var inst_57363 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57362);
var inst_57364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57365 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57366 = cljs.core.PersistentVector.EMPTY;
var inst_57367 = ["uuid",inst_57366,inst_57363];
var inst_57368 = cljs.core.PersistentHashMap.fromArrays(inst_57365,inst_57367);
var inst_57369 = [inst_57368,(10)];
var inst_57370 = (new cljs.core.PersistentVector(null,2,(5),inst_57364,inst_57369,null));
var inst_57371 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57370);
var ___$1 = (function (){var statearr_57380 = state_57376;
(statearr_57380[(4)] = cljs.core.rest.call(null,(state_57376[(4)])));

return statearr_57380;
})();
var state_57376__$1 = (function (){var statearr_57381 = state_57376;
(statearr_57381[(7)] = inst_57371);

return statearr_57381;
})();
var statearr_57382_57394 = state_57376__$1;
(statearr_57382_57394[(2)] = inst_57363);

(statearr_57382_57394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57377 === (3))){
var inst_57374 = (state_57376[(2)]);
var state_57376__$1 = state_57376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57376__$1,inst_57374);
} else {
if((state_val_57377 === (4))){
var inst_57356 = (state_57376[(2)]);
var state_57376__$1 = state_57376;
var statearr_57384_57395 = state_57376__$1;
(statearr_57384_57395[(2)] = inst_57356);

(statearr_57384_57395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57377 === (5))){
var _ = (function (){var statearr_57385 = state_57376;
(statearr_57385[(4)] = cljs.core.rest.call(null,(state_57376[(4)])));

return statearr_57385;
})();
var state_57376__$1 = state_57376;
var ex57383 = (state_57376__$1[(2)]);
var statearr_57386_57396 = state_57376__$1;
(statearr_57386_57396[(5)] = ex57383);


if((ex57383 instanceof Error)){
var statearr_57387_57397 = state_57376__$1;
(statearr_57387_57397[(1)] = (4));

(statearr_57387_57397[(5)] = null);

} else {
throw ex57383;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto____0 = (function (){
var statearr_57388 = [null,null,null,null,null,null,null,null];
(statearr_57388[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto__);

(statearr_57388[(1)] = (1));

return statearr_57388;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto____1 = (function (state_57376){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57389){var ex__2729__auto__ = e57389;
var statearr_57390_57398 = state_57376;
(statearr_57390_57398[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57376[(4)]))){
var statearr_57391_57399 = state_57376;
(statearr_57391_57399[(1)] = cljs.core.first.call(null,(state_57376[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57400 = state_57376;
state_57376 = G__57400;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto__ = function(state_57376){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto____1.call(this,state_57376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57392 = f__2749__auto__.call(null);
(statearr_57392[(6)] = c__2748__auto__);

return statearr_57392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57430){
var state_val_57431 = (state_57430[(1)]);
if((state_val_57431 === (7))){
var state_57430__$1 = state_57430;
var statearr_57432_57451 = state_57430__$1;
(statearr_57432_57451[(2)] = num);

(statearr_57432_57451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (1))){
var state_57430__$1 = state_57430;
var statearr_57433_57452 = state_57430__$1;
(statearr_57433_57452[(2)] = null);

(statearr_57433_57452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (4))){
var inst_57401 = (state_57430[(2)]);
var state_57430__$1 = state_57430;
var statearr_57434_57453 = state_57430__$1;
(statearr_57434_57453[(2)] = inst_57401);

(statearr_57434_57453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (6))){
var state_57430__$1 = state_57430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57430__$1,(9),num);
} else {
if((state_val_57431 === (3))){
var inst_57428 = (state_57430[(2)]);
var state_57430__$1 = state_57430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57430__$1,inst_57428);
} else {
if((state_val_57431 === (2))){
var _ = (function (){var statearr_57436 = state_57430;
(statearr_57436[(4)] = cljs.core.cons.call(null,(5),(state_57430[(4)])));

return statearr_57436;
})();
var inst_57407 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57430__$1 = state_57430;
if(inst_57407){
var statearr_57437_57454 = state_57430__$1;
(statearr_57437_57454[(1)] = (6));

} else {
var statearr_57438_57455 = state_57430__$1;
(statearr_57438_57455[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (9))){
var inst_57410 = (state_57430[(2)]);
var inst_57411 = fluree.db.util.async.throw_err.call(null,inst_57410);
var state_57430__$1 = state_57430;
var statearr_57439_57456 = state_57430__$1;
(statearr_57439_57456[(2)] = inst_57411);

(statearr_57439_57456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (5))){
var _ = (function (){var statearr_57440 = state_57430;
(statearr_57440[(4)] = cljs.core.rest.call(null,(state_57430[(4)])));

return statearr_57440;
})();
var state_57430__$1 = state_57430;
var ex57435 = (state_57430__$1[(2)]);
var statearr_57441_57457 = state_57430__$1;
(statearr_57441_57457[(5)] = ex57435);


if((ex57435 instanceof Error)){
var statearr_57442_57458 = state_57430__$1;
(statearr_57442_57458[(1)] = (4));

(statearr_57442_57458[(5)] = null);

} else {
throw ex57435;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57431 === (8))){
var inst_57414 = (state_57430[(2)]);
var inst_57415 = fluree.db.dbfunctions.internal.ceil.call(null,inst_57414);
var inst_57416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57417 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57419 = [fluree.db.dbfunctions.fns.ceil];
var inst_57420 = (new cljs.core.PersistentVector(null,1,(5),inst_57418,inst_57419,null));
var inst_57421 = ["",inst_57420,inst_57415];
var inst_57422 = cljs.core.PersistentHashMap.fromArrays(inst_57417,inst_57421);
var inst_57423 = [inst_57422,(10)];
var inst_57424 = (new cljs.core.PersistentVector(null,2,(5),inst_57416,inst_57423,null));
var inst_57425 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57424);
var _ = (function (){var statearr_57443 = state_57430;
(statearr_57443[(4)] = cljs.core.rest.call(null,(state_57430[(4)])));

return statearr_57443;
})();
var state_57430__$1 = (function (){var statearr_57444 = state_57430;
(statearr_57444[(7)] = inst_57425);

return statearr_57444;
})();
var statearr_57445_57459 = state_57430__$1;
(statearr_57445_57459[(2)] = inst_57415);

(statearr_57445_57459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto____0 = (function (){
var statearr_57446 = [null,null,null,null,null,null,null,null];
(statearr_57446[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto__);

(statearr_57446[(1)] = (1));

return statearr_57446;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto____1 = (function (state_57430){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57447){var ex__2729__auto__ = e57447;
var statearr_57448_57460 = state_57430;
(statearr_57448_57460[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57430[(4)]))){
var statearr_57449_57461 = state_57430;
(statearr_57449_57461[(1)] = cljs.core.first.call(null,(state_57430[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57462 = state_57430;
state_57430 = G__57462;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto__ = function(state_57430){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto____1.call(this,state_57430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57450 = f__2749__auto__.call(null);
(statearr_57450[(6)] = c__2748__auto__);

return statearr_57450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57492){
var state_val_57493 = (state_57492[(1)]);
if((state_val_57493 === (7))){
var state_57492__$1 = state_57492;
var statearr_57494_57513 = state_57492__$1;
(statearr_57494_57513[(2)] = num);

(statearr_57494_57513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57493 === (1))){
var state_57492__$1 = state_57492;
var statearr_57495_57514 = state_57492__$1;
(statearr_57495_57514[(2)] = null);

(statearr_57495_57514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57493 === (4))){
var inst_57463 = (state_57492[(2)]);
var state_57492__$1 = state_57492;
var statearr_57496_57515 = state_57492__$1;
(statearr_57496_57515[(2)] = inst_57463);

(statearr_57496_57515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57493 === (6))){
var state_57492__$1 = state_57492;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57492__$1,(9),num);
} else {
if((state_val_57493 === (3))){
var inst_57490 = (state_57492[(2)]);
var state_57492__$1 = state_57492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57492__$1,inst_57490);
} else {
if((state_val_57493 === (2))){
var _ = (function (){var statearr_57498 = state_57492;
(statearr_57498[(4)] = cljs.core.cons.call(null,(5),(state_57492[(4)])));

return statearr_57498;
})();
var inst_57469 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57492__$1 = state_57492;
if(inst_57469){
var statearr_57499_57516 = state_57492__$1;
(statearr_57499_57516[(1)] = (6));

} else {
var statearr_57500_57517 = state_57492__$1;
(statearr_57500_57517[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57493 === (9))){
var inst_57472 = (state_57492[(2)]);
var inst_57473 = fluree.db.util.async.throw_err.call(null,inst_57472);
var state_57492__$1 = state_57492;
var statearr_57501_57518 = state_57492__$1;
(statearr_57501_57518[(2)] = inst_57473);

(statearr_57501_57518[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57493 === (5))){
var _ = (function (){var statearr_57502 = state_57492;
(statearr_57502[(4)] = cljs.core.rest.call(null,(state_57492[(4)])));

return statearr_57502;
})();
var state_57492__$1 = state_57492;
var ex57497 = (state_57492__$1[(2)]);
var statearr_57503_57519 = state_57492__$1;
(statearr_57503_57519[(5)] = ex57497);


if((ex57497 instanceof Error)){
var statearr_57504_57520 = state_57492__$1;
(statearr_57504_57520[(1)] = (4));

(statearr_57504_57520[(5)] = null);

} else {
throw ex57497;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57493 === (8))){
var inst_57476 = (state_57492[(2)]);
var inst_57477 = fluree.db.dbfunctions.internal.floor.call(null,inst_57476);
var inst_57478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57479 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57481 = [fluree.db.dbfunctions.fns.floor];
var inst_57482 = (new cljs.core.PersistentVector(null,1,(5),inst_57480,inst_57481,null));
var inst_57483 = ["",inst_57482,inst_57477];
var inst_57484 = cljs.core.PersistentHashMap.fromArrays(inst_57479,inst_57483);
var inst_57485 = [inst_57484,(10)];
var inst_57486 = (new cljs.core.PersistentVector(null,2,(5),inst_57478,inst_57485,null));
var inst_57487 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57486);
var _ = (function (){var statearr_57505 = state_57492;
(statearr_57505[(4)] = cljs.core.rest.call(null,(state_57492[(4)])));

return statearr_57505;
})();
var state_57492__$1 = (function (){var statearr_57506 = state_57492;
(statearr_57506[(7)] = inst_57487);

return statearr_57506;
})();
var statearr_57507_57521 = state_57492__$1;
(statearr_57507_57521[(2)] = inst_57477);

(statearr_57507_57521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto____0 = (function (){
var statearr_57508 = [null,null,null,null,null,null,null,null];
(statearr_57508[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto__);

(statearr_57508[(1)] = (1));

return statearr_57508;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto____1 = (function (state_57492){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57509){var ex__2729__auto__ = e57509;
var statearr_57510_57522 = state_57492;
(statearr_57510_57522[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57492[(4)]))){
var statearr_57511_57523 = state_57492;
(statearr_57511_57523[(1)] = cljs.core.first.call(null,(state_57492[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57524 = state_57492;
state_57492 = G__57524;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto__ = function(state_57492){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto____1.call(this,state_57492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57512 = f__2749__auto__.call(null);
(statearr_57512[(6)] = c__2748__auto__);

return statearr_57512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_57549){
var state_val_57550 = (state_57549[(1)]);
if((state_val_57550 === (1))){
var state_57549__$1 = state_57549;
var statearr_57551_57566 = state_57549__$1;
(statearr_57551_57566[(2)] = null);

(statearr_57551_57566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57550 === (2))){
var _ = (function (){var statearr_57552 = state_57549;
(statearr_57552[(4)] = cljs.core.cons.call(null,(5),(state_57549[(4)])));

return statearr_57552;
})();
var inst_57531 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_57549__$1 = state_57549;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57549__$1,(6),inst_57531);
} else {
if((state_val_57550 === (3))){
var inst_57547 = (state_57549[(2)]);
var state_57549__$1 = state_57549;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57549__$1,inst_57547);
} else {
if((state_val_57550 === (4))){
var inst_57525 = (state_57549[(2)]);
var state_57549__$1 = state_57549;
var statearr_57554_57567 = state_57549__$1;
(statearr_57554_57567[(2)] = inst_57525);

(statearr_57554_57567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57550 === (5))){
var _ = (function (){var statearr_57555 = state_57549;
(statearr_57555[(4)] = cljs.core.rest.call(null,(state_57549[(4)])));

return statearr_57555;
})();
var state_57549__$1 = state_57549;
var ex57553 = (state_57549__$1[(2)]);
var statearr_57556_57568 = state_57549__$1;
(statearr_57556_57568[(5)] = ex57553);


if((ex57553 instanceof Error)){
var statearr_57557_57569 = state_57549__$1;
(statearr_57557_57569[(1)] = (4));

(statearr_57557_57569[(5)] = null);

} else {
throw ex57553;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57550 === (6))){
var inst_57533 = (state_57549[(2)]);
var inst_57534 = fluree.db.util.async.throw_err.call(null,inst_57533);
var inst_57535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57536 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57538 = [compare_val,new_val];
var inst_57539 = (new cljs.core.PersistentVector(null,2,(5),inst_57537,inst_57538,null));
var inst_57540 = ["",inst_57539,inst_57534];
var inst_57541 = cljs.core.PersistentHashMap.fromArrays(inst_57536,inst_57540);
var inst_57542 = [inst_57541,(10)];
var inst_57543 = (new cljs.core.PersistentVector(null,2,(5),inst_57535,inst_57542,null));
var inst_57544 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57543);
var _ = (function (){var statearr_57558 = state_57549;
(statearr_57558[(4)] = cljs.core.rest.call(null,(state_57549[(4)])));

return statearr_57558;
})();
var state_57549__$1 = (function (){var statearr_57559 = state_57549;
(statearr_57559[(7)] = inst_57544);

return statearr_57559;
})();
var statearr_57560_57570 = state_57549__$1;
(statearr_57560_57570[(2)] = inst_57534);

(statearr_57560_57570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto____0 = (function (){
var statearr_57561 = [null,null,null,null,null,null,null,null];
(statearr_57561[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto__);

(statearr_57561[(1)] = (1));

return statearr_57561;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto____1 = (function (state_57549){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_57549);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e57562){var ex__2729__auto__ = e57562;
var statearr_57563_57571 = state_57549;
(statearr_57563_57571[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_57549[(4)]))){
var statearr_57564_57572 = state_57549;
(statearr_57564_57572[(1)] = cljs.core.first.call(null,(state_57549[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57573 = state_57549;
state_57549 = G__57573;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto__ = function(state_57549){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto____1.call(this,state_57549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_57565 = f__2749__auto__.call(null);
(statearr_57565[(6)] = c__2748__auto__);

return statearr_57565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
