// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28121 = arguments.length;
var i__4830__auto___28122 = (0);
while(true){
if((i__4830__auto___28122 < len__4829__auto___28121)){
args__4835__auto__.push((arguments[i__4830__auto___28122]));

var G__28123 = (i__4830__auto___28122 + (1));
i__4830__auto___28122 = G__28123;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28118){
var G__28119 = cljs.core.first.call(null,seq28118);
var seq28118__$1 = cljs.core.next.call(null,seq28118);
var G__28120 = cljs.core.first.call(null,seq28118__$1);
var seq28118__$2 = cljs.core.next.call(null,seq28118__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28119,G__28120,seq28118__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e28124){var e = e28124;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28125){var e = e28125;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e28126){var e = e28126;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28127){var e = e28127;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28128){var e = e28128;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28131 = arguments.length;
var i__4830__auto___28132 = (0);
while(true){
if((i__4830__auto___28132 < len__4829__auto___28131)){
args__4835__auto__.push((arguments[i__4830__auto___28132]));

var G__28133 = (i__4830__auto___28132 + (1));
i__4830__auto___28132 = G__28133;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28130){var e = e28130;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28129){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28129));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28136 = arguments.length;
var i__4830__auto___28137 = (0);
while(true){
if((i__4830__auto___28137 < len__4829__auto___28136)){
args__4835__auto__.push((arguments[i__4830__auto___28137]));

var G__28138 = (i__4830__auto___28137 + (1));
i__4830__auto___28137 = G__28138;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28135){var e = e28135;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28134){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28134));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e28139){var e = e28139;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28142 = arguments.length;
var i__4830__auto___28143 = (0);
while(true){
if((i__4830__auto___28143 < len__4829__auto___28142)){
args__4835__auto__.push((arguments[i__4830__auto___28143]));

var G__28144 = (i__4830__auto___28143 + (1));
i__4830__auto___28143 = G__28144;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e28141){var e = e28141;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28140){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28140));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28147 = arguments.length;
var i__4830__auto___28148 = (0);
while(true){
if((i__4830__auto___28148 < len__4829__auto___28147)){
args__4835__auto__.push((arguments[i__4830__auto___28148]));

var G__28149 = (i__4830__auto___28148 + (1));
i__4830__auto___28148 = G__28149;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e28146){var e = e28146;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28145){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28145));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e28150){var e = e28150;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e28151){var e = e28151;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28154 = arguments.length;
var i__4830__auto___28155 = (0);
while(true){
if((i__4830__auto___28155 < len__4829__auto___28154)){
args__4835__auto__.push((arguments[i__4830__auto___28155]));

var G__28156 = (i__4830__auto___28155 + (1));
i__4830__auto___28155 = G__28156;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28153){var e = e28153;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28152){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28152));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28159 = arguments.length;
var i__4830__auto___28160 = (0);
while(true){
if((i__4830__auto___28160 < len__4829__auto___28159)){
args__4835__auto__.push((arguments[i__4830__auto___28160]));

var G__28161 = (i__4830__auto___28160 + (1));
i__4830__auto___28160 = G__28161;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28158){var e = e28158;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28157){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28157));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28164 = arguments.length;
var i__4830__auto___28165 = (0);
while(true){
if((i__4830__auto___28165 < len__4829__auto___28164)){
args__4835__auto__.push((arguments[i__4830__auto___28165]));

var G__28166 = (i__4830__auto___28165 + (1));
i__4830__auto___28165 = G__28166;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e28163){var e = e28163;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28162){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28162));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28169 = arguments.length;
var i__4830__auto___28170 = (0);
while(true){
if((i__4830__auto___28170 < len__4829__auto___28169)){
args__4835__auto__.push((arguments[i__4830__auto___28170]));

var G__28171 = (i__4830__auto___28170 + (1));
i__4830__auto___28170 = G__28171;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e28168){var e = e28168;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28167){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28167));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28174 = arguments.length;
var i__4830__auto___28175 = (0);
while(true){
if((i__4830__auto___28175 < len__4829__auto___28174)){
args__4835__auto__.push((arguments[i__4830__auto___28175]));

var G__28176 = (i__4830__auto___28175 + (1));
i__4830__auto___28175 = G__28176;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e28173){var e = e28173;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28172){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28172));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28179 = arguments.length;
var i__4830__auto___28180 = (0);
while(true){
if((i__4830__auto___28180 < len__4829__auto___28179)){
args__4835__auto__.push((arguments[i__4830__auto___28180]));

var G__28181 = (i__4830__auto___28180 + (1));
i__4830__auto___28180 = G__28181;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e28178){var e = e28178;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28177){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28177));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28184 = arguments.length;
var i__4830__auto___28185 = (0);
while(true){
if((i__4830__auto___28185 < len__4829__auto___28184)){
args__4835__auto__.push((arguments[i__4830__auto___28185]));

var G__28186 = (i__4830__auto___28185 + (1));
i__4830__auto___28185 = G__28186;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e28183){var e = e28183;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28182){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28182));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28188 = arguments.length;
switch (G__28188) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28216){
var state_val_28217 = (state_28216[(1)]);
if((state_val_28217 === (7))){
var inst_28201 = (state_28216[(7)]);
var inst_28204 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28201,"query",query_map);
var state_28216__$1 = state_28216;
var statearr_28218_28304 = state_28216__$1;
(statearr_28218_28304[(2)] = inst_28204);

(statearr_28218_28304[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28217 === (1))){
var state_28216__$1 = state_28216;
var statearr_28219_28305 = state_28216__$1;
(statearr_28219_28305[(2)] = null);

(statearr_28219_28305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28217 === (4))){
var inst_28189 = (state_28216[(2)]);
var state_28216__$1 = state_28216;
var statearr_28220_28306 = state_28216__$1;
(statearr_28220_28306[(2)] = inst_28189);

(statearr_28220_28306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28217 === (6))){
var inst_28201 = (state_28216[(7)]);
var inst_28201__$1 = (state_28216[(2)]);
var inst_28202 = fluree.db.util.core.exception_QMARK_.call(null,inst_28201__$1);
var state_28216__$1 = (function (){var statearr_28221 = state_28216;
(statearr_28221[(7)] = inst_28201__$1);

return statearr_28221;
})();
if(inst_28202){
var statearr_28222_28307 = state_28216__$1;
(statearr_28222_28307[(1)] = (7));

} else {
var statearr_28223_28308 = state_28216__$1;
(statearr_28223_28308[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28217 === (3))){
var inst_28214 = (state_28216[(2)]);
var state_28216__$1 = state_28216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28216__$1,inst_28214);
} else {
if((state_val_28217 === (2))){
var inst_28195 = (state_28216[(8)]);
var _ = (function (){var statearr_28225 = state_28216;
(statearr_28225[(4)] = cljs.core.cons.call(null,(5),(state_28216[(4)])));

return statearr_28225;
})();
var inst_28195__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28196 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28197 = cljs.core.assoc.call(null,inst_28196,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28195__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_28198 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28197);
var inst_28199 = fluree.db.query.fql.query.call(null,db,inst_28198);
var state_28216__$1 = (function (){var statearr_28226 = state_28216;
(statearr_28226[(8)] = inst_28195__$1);

return statearr_28226;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28216__$1,(6),inst_28199);
} else {
if((state_val_28217 === (9))){
var inst_28211 = (state_28216[(2)]);
var _ = (function (){var statearr_28227 = state_28216;
(statearr_28227[(4)] = cljs.core.rest.call(null,(state_28216[(4)])));

return statearr_28227;
})();
var state_28216__$1 = state_28216;
var statearr_28228_28309 = state_28216__$1;
(statearr_28228_28309[(2)] = inst_28211);

(statearr_28228_28309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28217 === (5))){
var _ = (function (){var statearr_28229 = state_28216;
(statearr_28229[(4)] = cljs.core.rest.call(null,(state_28216[(4)])));

return statearr_28229;
})();
var state_28216__$1 = state_28216;
var ex28224 = (state_28216__$1[(2)]);
var statearr_28230_28310 = state_28216__$1;
(statearr_28230_28310[(5)] = ex28224);


if((ex28224 instanceof Error)){
var statearr_28231_28311 = state_28216__$1;
(statearr_28231_28311[(1)] = (4));

(statearr_28231_28311[(5)] = null);

} else {
throw ex28224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28217 === (8))){
var inst_28195 = (state_28216[(8)]);
var inst_28201 = (state_28216[(7)]);
var inst_28206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28207 = cljs.core.deref.call(null,inst_28195);
var inst_28208 = [inst_28201,inst_28207];
var inst_28209 = (new cljs.core.PersistentVector(null,2,(5),inst_28206,inst_28208,null));
var state_28216__$1 = state_28216;
var statearr_28232_28312 = state_28216__$1;
(statearr_28232_28312[(2)] = inst_28209);

(statearr_28232_28312[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2726__auto____0 = (function (){
var statearr_28233 = [null,null,null,null,null,null,null,null,null];
(statearr_28233[(0)] = fluree$db$dbfunctions$internal$state_machine__2726__auto__);

(statearr_28233[(1)] = (1));

return statearr_28233;
});
var fluree$db$dbfunctions$internal$state_machine__2726__auto____1 = (function (state_28216){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28234){var ex__2729__auto__ = e28234;
var statearr_28235_28313 = state_28216;
(statearr_28235_28313[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28216[(4)]))){
var statearr_28236_28314 = state_28216;
(statearr_28236_28314[(1)] = cljs.core.first.call(null,(state_28216[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28315 = state_28216;
state_28216 = G__28315;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2726__auto__ = function(state_28216){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____1.call(this,state_28216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28237 = f__2749__auto__.call(null);
(statearr_28237[(6)] = c__2748__auto__);

return statearr_28237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28282){
var state_val_28283 = (state_28282[(1)]);
if((state_val_28283 === (7))){
var inst_28268 = (state_28282[(2)]);
var inst_28269 = fluree.db.query.fql.query.call(null,db,inst_28268);
var state_28282__$1 = state_28282;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28282__$1,(8),inst_28269);
} else {
if((state_val_28283 === (1))){
var inst_28238 = typeof select === 'string';
var state_28282__$1 = state_28282;
if(cljs.core.truth_(inst_28238)){
var statearr_28284_28316 = state_28282__$1;
(statearr_28284_28316[(1)] = (2));

} else {
var statearr_28285_28317 = state_28282__$1;
(statearr_28285_28317[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (4))){
var inst_28244 = (state_28282[(7)]);
var inst_28251 = (state_28282[(8)]);
var inst_28243 = (state_28282[(2)]);
var inst_28244__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28245 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28246 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28247 = [inst_28244__$1,(100000)];
var inst_28248 = cljs.core.PersistentHashMap.fromArrays(inst_28246,inst_28247);
var inst_28249 = [inst_28243,from,where,block,limit,inst_28248];
var inst_28250 = cljs.core.PersistentHashMap.fromArrays(inst_28245,inst_28249);
var inst_28251__$1 = fluree.db.util.core.without_nils.call(null,inst_28250);
var inst_28252 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28251__$1);
var inst_28253 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28251__$1);
var inst_28254 = cljs.core.first.call(null,inst_28253);
var inst_28255 = fluree.db.dbfunctions.internal.str.call(null,inst_28254);
var inst_28256 = cljs.core._EQ_.call(null,"[",inst_28255);
var inst_28257 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28251__$1);
var inst_28258 = cljs.core.last.call(null,inst_28257);
var inst_28259 = fluree.db.dbfunctions.internal.str.call(null,inst_28258);
var inst_28260 = cljs.core._EQ_.call(null,"]",inst_28259);
var inst_28261 = fluree.db.dbfunctions.internal.and.call(null,inst_28252,inst_28256,inst_28260);
var state_28282__$1 = (function (){var statearr_28286 = state_28282;
(statearr_28286[(7)] = inst_28244__$1);

(statearr_28286[(8)] = inst_28251__$1);

return statearr_28286;
})();
if(cljs.core.truth_(inst_28261)){
var statearr_28287_28318 = state_28282__$1;
(statearr_28287_28318[(1)] = (5));

} else {
var statearr_28288_28319 = state_28282__$1;
(statearr_28288_28319[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (6))){
var inst_28251 = (state_28282[(8)]);
var state_28282__$1 = state_28282;
var statearr_28289_28320 = state_28282__$1;
(statearr_28289_28320[(2)] = inst_28251);

(statearr_28289_28320[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (3))){
var state_28282__$1 = state_28282;
var statearr_28290_28321 = state_28282__$1;
(statearr_28290_28321[(2)] = select);

(statearr_28290_28321[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (2))){
var inst_28240 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_28282__$1 = state_28282;
var statearr_28291_28322 = state_28282__$1;
(statearr_28291_28322[(2)] = inst_28240);

(statearr_28291_28322[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (11))){
var inst_28280 = (state_28282[(2)]);
var state_28282__$1 = state_28282;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28282__$1,inst_28280);
} else {
if((state_val_28283 === (9))){
var inst_28271 = (state_28282[(9)]);
var state_28282__$1 = state_28282;
var statearr_28292_28323 = state_28282__$1;
(statearr_28292_28323[(2)] = inst_28271);

(statearr_28292_28323[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (5))){
var inst_28251 = (state_28282[(8)]);
var inst_28263 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28251);
var inst_28264 = cljs.reader.read_string.call(null,inst_28263);
var inst_28265 = cljs.core.assoc.call(null,inst_28251,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28264);
var state_28282__$1 = state_28282;
var statearr_28293_28324 = state_28282__$1;
(statearr_28293_28324[(2)] = inst_28265);

(statearr_28293_28324[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (10))){
var inst_28244 = (state_28282[(7)]);
var inst_28271 = (state_28282[(9)]);
var inst_28275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28276 = cljs.core.deref.call(null,inst_28244);
var inst_28277 = [inst_28271,inst_28276];
var inst_28278 = (new cljs.core.PersistentVector(null,2,(5),inst_28275,inst_28277,null));
var state_28282__$1 = state_28282;
var statearr_28294_28325 = state_28282__$1;
(statearr_28294_28325[(2)] = inst_28278);

(statearr_28294_28325[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28283 === (8))){
var inst_28271 = (state_28282[(9)]);
var inst_28271__$1 = (state_28282[(2)]);
var inst_28272 = fluree.db.util.core.exception_QMARK_.call(null,inst_28271__$1);
var state_28282__$1 = (function (){var statearr_28295 = state_28282;
(statearr_28295[(9)] = inst_28271__$1);

return statearr_28295;
})();
if(inst_28272){
var statearr_28296_28326 = state_28282__$1;
(statearr_28296_28326[(1)] = (9));

} else {
var statearr_28297_28327 = state_28282__$1;
(statearr_28297_28327[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2726__auto____0 = (function (){
var statearr_28298 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28298[(0)] = fluree$db$dbfunctions$internal$state_machine__2726__auto__);

(statearr_28298[(1)] = (1));

return statearr_28298;
});
var fluree$db$dbfunctions$internal$state_machine__2726__auto____1 = (function (state_28282){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28282);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28299){var ex__2729__auto__ = e28299;
var statearr_28300_28328 = state_28282;
(statearr_28300_28328[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28282[(4)]))){
var statearr_28301_28329 = state_28282;
(statearr_28301_28329[(1)] = cljs.core.first.call(null,(state_28282[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28330 = state_28282;
state_28282 = G__28330;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2726__auto__ = function(state_28282){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____1.call(this,state_28282);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28302 = f__2749__auto__.call(null);
(statearr_28302[(6)] = c__2748__auto__);

return statearr_28302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28334 = path;
var vec__28335 = G__28334;
var seq__28336 = cljs.core.seq.call(null,vec__28335);
var first__28337 = cljs.core.first.call(null,seq__28336);
var seq__28336__$1 = cljs.core.next.call(null,seq__28336);
var var$ = first__28337;
var r = seq__28336__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28334__$1 = G__28334;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28341 = G__28334__$1;
var seq__28342 = cljs.core.seq.call(null,vec__28341);
var first__28343 = cljs.core.first.call(null,seq__28342);
var seq__28342__$1 = cljs.core.next.call(null,seq__28342);
var var$__$1 = first__28343;
var r__$1 = seq__28342__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__28344 = r__$1;
var G__28345 = n__$2;
var G__28346 = next_clauses;
G__28334__$1 = G__28344;
n__$1 = G__28345;
where_clauses__$1 = G__28346;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__28347 = r__$1;
var G__28348 = next_n;
var G__28349 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__28334__$1 = G__28347;
n__$1 = G__28348;
where_clauses__$1 = G__28349;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28386){
var state_val_28387 = (state_28386[(1)]);
if((state_val_28387 === (7))){
var inst_28359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28360 = [path];
var inst_28361 = (new cljs.core.PersistentVector(null,1,(5),inst_28359,inst_28360,null));
var state_28386__$1 = state_28386;
var statearr_28388_28416 = state_28386__$1;
(statearr_28388_28416[(2)] = inst_28361);

(statearr_28388_28416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (1))){
var state_28386__$1 = state_28386;
var statearr_28389_28417 = state_28386__$1;
(statearr_28389_28417[(2)] = null);

(statearr_28389_28417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (4))){
var inst_28350 = (state_28386[(2)]);
var state_28386__$1 = state_28386;
var statearr_28390_28418 = state_28386__$1;
(statearr_28390_28418[(2)] = inst_28350);

(statearr_28390_28418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (13))){
var inst_28377 = (state_28386[(2)]);
var inst_28378 = fluree.db.util.async.throw_err.call(null,inst_28377);
var _ = (function (){var statearr_28391 = state_28386;
(statearr_28391[(4)] = cljs.core.rest.call(null,(state_28386[(4)])));

return statearr_28391;
})();
var state_28386__$1 = state_28386;
var statearr_28392_28419 = state_28386__$1;
(statearr_28392_28419[(2)] = inst_28378);

(statearr_28392_28419[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (6))){
var state_28386__$1 = state_28386;
var statearr_28394_28420 = state_28386__$1;
(statearr_28394_28420[(2)] = path);

(statearr_28394_28420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (3))){
var inst_28384 = (state_28386[(2)]);
var state_28386__$1 = state_28386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28386__$1,inst_28384);
} else {
if((state_val_28387 === (12))){
var _ = (function (){var statearr_28395 = state_28386;
(statearr_28395[(4)] = cljs.core.rest.call(null,(state_28386[(4)])));

return statearr_28395;
})();
var state_28386__$1 = state_28386;
var ex28393 = (state_28386__$1[(2)]);
var statearr_28396_28421 = state_28386__$1;
(statearr_28396_28421[(5)] = ex28393);


var statearr_28397_28422 = state_28386__$1;
(statearr_28397_28422[(1)] = (11));

(statearr_28397_28422[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (2))){
var _ = (function (){var statearr_28398 = state_28386;
(statearr_28398[(4)] = cljs.core.cons.call(null,(5),(state_28386[(4)])));

return statearr_28398;
})();
var inst_28356 = cljs.core.vector_QMARK_.call(null,path);
var state_28386__$1 = state_28386;
if(inst_28356){
var statearr_28399_28423 = state_28386__$1;
(statearr_28399_28423[(1)] = (6));

} else {
var statearr_28400_28424 = state_28386__$1;
(statearr_28400_28424[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (11))){
var inst_28363 = (state_28386[(7)]);
var inst_28368 = (state_28386[(2)]);
var inst_28369 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28368,"relationship?",startSubject,inst_28363,endSubject);
var state_28386__$1 = state_28386;
var statearr_28402_28425 = state_28386__$1;
(statearr_28402_28425[(2)] = inst_28369);

(statearr_28402_28425[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (9))){
var inst_28367 = (state_28386[(8)]);
var _ = (function (){var statearr_28403 = state_28386;
(statearr_28403[(4)] = cljs.core.cons.call(null,(12),(state_28386[(4)])));

return statearr_28403;
})();
var inst_28375 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28367);
var state_28386__$1 = state_28386;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28386__$1,(13),inst_28375);
} else {
if((state_val_28387 === (5))){
var _ = (function (){var statearr_28404 = state_28386;
(statearr_28404[(4)] = cljs.core.rest.call(null,(state_28386[(4)])));

return statearr_28404;
})();
var state_28386__$1 = state_28386;
var ex28401 = (state_28386__$1[(2)]);
var statearr_28405_28426 = state_28386__$1;
(statearr_28405_28426[(5)] = ex28401);


if((ex28401 instanceof Error)){
var statearr_28406_28427 = state_28386__$1;
(statearr_28406_28427[(1)] = (4));

(statearr_28406_28427[(5)] = null);

} else {
throw ex28401;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (10))){
var inst_28381 = (state_28386[(2)]);
var _ = (function (){var statearr_28407 = state_28386;
(statearr_28407[(4)] = cljs.core.rest.call(null,(state_28386[(4)])));

return statearr_28407;
})();
var state_28386__$1 = state_28386;
var statearr_28408_28428 = state_28386__$1;
(statearr_28408_28428[(2)] = inst_28381);

(statearr_28408_28428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28387 === (8))){
var inst_28363 = (state_28386[(7)]);
var inst_28363__$1 = (state_28386[(2)]);
var inst_28364 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_28363__$1,endSubject);
var inst_28365 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28366 = ["?var1",inst_28364];
var inst_28367 = cljs.core.PersistentHashMap.fromArrays(inst_28365,inst_28366);
var state_28386__$1 = (function (){var statearr_28409 = state_28386;
(statearr_28409[(7)] = inst_28363__$1);

(statearr_28409[(8)] = inst_28367);

return statearr_28409;
})();
var statearr_28410_28429 = state_28386__$1;
(statearr_28410_28429[(2)] = null);

(statearr_28410_28429[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_28411 = [null,null,null,null,null,null,null,null,null];
(statearr_28411[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto__);

(statearr_28411[(1)] = (1));

return statearr_28411;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto____1 = (function (state_28386){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28412){var ex__2729__auto__ = e28412;
var statearr_28413_28430 = state_28386;
(statearr_28413_28430[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28386[(4)]))){
var statearr_28414_28431 = state_28386;
(statearr_28414_28431[(1)] = cljs.core.first.call(null,(state_28386[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28432 = state_28386;
state_28386 = G__28432;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto__ = function(state_28386){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto____1.call(this,state_28386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28415 = f__2749__auto__.call(null);
(statearr_28415[(6)] = c__2748__auto__);

return statearr_28415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e28433){var e = e28433;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28434){var e = e28434;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e28435){var e = e28435;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e28436){var e = e28436;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28439 = arguments.length;
var i__4830__auto___28440 = (0);
while(true){
if((i__4830__auto___28440 < len__4829__auto___28439)){
args__4835__auto__.push((arguments[i__4830__auto___28440]));

var G__28441 = (i__4830__auto___28440 + (1));
i__4830__auto___28440 = G__28441;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e28438){var e = e28438;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28437){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28437));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28444 = arguments.length;
var i__4830__auto___28445 = (0);
while(true){
if((i__4830__auto___28445 < len__4829__auto___28444)){
args__4835__auto__.push((arguments[i__4830__auto___28445]));

var G__28446 = (i__4830__auto___28445 + (1));
i__4830__auto___28445 = G__28446;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e28443){var e = e28443;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28442){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28442));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28449 = arguments.length;
var i__4830__auto___28450 = (0);
while(true){
if((i__4830__auto___28450 < len__4829__auto___28449)){
args__4835__auto__.push((arguments[i__4830__auto___28450]));

var G__28451 = (i__4830__auto___28450 + (1));
i__4830__auto___28450 = G__28451;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e28448){var e = e28448;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28447){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28447));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28454 = arguments.length;
var i__4830__auto___28455 = (0);
while(true){
if((i__4830__auto___28455 < len__4829__auto___28454)){
args__4835__auto__.push((arguments[i__4830__auto___28455]));

var G__28456 = (i__4830__auto___28455 + (1));
i__4830__auto___28455 = G__28456;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e28453){var e = e28453;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28452){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28452));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e28457){var e = e28457;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e28458){var e = e28458;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e28459){var e = e28459;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28460){var e = e28460;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28461){var e = e28461;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28467 = path;
var vec__28468 = G__28467;
var seq__28469 = cljs.core.seq.call(null,vec__28468);
var first__28470 = cljs.core.first.call(null,seq__28469);
var seq__28469__$1 = cljs.core.next.call(null,seq__28469);
var pred = first__28470;
var r = seq__28469__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28467__$1 = G__28467;
var subjects__$1 = subjects;
while(true){
var vec__28474 = G__28467__$1;
var seq__28475 = cljs.core.seq.call(null,vec__28474);
var first__28476 = cljs.core.first.call(null,seq__28475);
var seq__28475__$1 = cljs.core.next.call(null,seq__28475);
var pred__$1 = first__28476;
var r__$1 = seq__28475__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__28467__$1,subjects__$1,vec__28474,seq__28475,first__28476,seq__28475__$1,pred__$1,r__$1,subjects__$2,G__28467,vec__28468,seq__28469,first__28470,seq__28469__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__28467__$1,subjects__$1,vec__28474,seq__28475,first__28476,seq__28475__$1,pred__$1,r__$1,subjects__$2,G__28467,vec__28468,seq__28469,first__28470,seq__28469__$1,pred,r,subjects){
return (function (p1__28462_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__28462_SHARP_,pred__$1);
});})(G__28467__$1,subjects__$1,vec__28474,seq__28475,first__28476,seq__28475__$1,pred__$1,r__$1,subjects__$2,G__28467,vec__28468,seq__28469,first__28470,seq__28469__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__28467__$1,subjects__$1,vec__28474,seq__28475,first__28476,seq__28475__$1,pred__$1,r__$1,subjects__$2,G__28467,vec__28468,seq__28469,first__28470,seq__28469__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__28477 = r__$1;
var G__28478 = next_subjects;
G__28467__$1 = G__28477;
subjects__$1 = G__28478;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28463){var e = e28463;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e28479){var e = e28479;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e28480){var e = e28480;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28483 = arguments.length;
var i__4830__auto___28484 = (0);
while(true){
if((i__4830__auto___28484 < len__4829__auto___28483)){
args__4835__auto__.push((arguments[i__4830__auto___28484]));

var G__28485 = (i__4830__auto___28484 + (1));
i__4830__auto___28484 = G__28485;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e28482){var e = e28482;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28481){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28481));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e28486){var e = e28486;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28489 = arguments.length;
var i__4830__auto___28490 = (0);
while(true){
if((i__4830__auto___28490 < len__4829__auto___28489)){
args__4835__auto__.push((arguments[i__4830__auto___28490]));

var G__28491 = (i__4830__auto___28490 + (1));
i__4830__auto___28490 = G__28491;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e28488){var e = e28488;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28487){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28487));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e28492){var e = e28492;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28547){
var state_val_28548 = (state_28547[(1)]);
if((state_val_28548 === (7))){
var inst_28494 = (state_28547[(2)]);
var state_28547__$1 = state_28547;
var statearr_28549_28582 = state_28547__$1;
(statearr_28549_28582[(2)] = inst_28494);

(statearr_28549_28582[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (1))){
var state_28547__$1 = state_28547;
var statearr_28550_28583 = state_28547__$1;
(statearr_28550_28583[(2)] = null);

(statearr_28550_28583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (4))){
var inst_28493 = (state_28547[(2)]);
var state_28547__$1 = (function (){var statearr_28551 = state_28547;
(statearr_28551[(7)] = inst_28493);

return statearr_28551;
})();
var statearr_28552_28584 = state_28547__$1;
(statearr_28552_28584[(2)] = null);

(statearr_28552_28584[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (15))){
var inst_28531 = (state_28547[(8)]);
var inst_28535 = inst_28531.o;
var state_28547__$1 = state_28547;
var statearr_28553_28585 = state_28547__$1;
(statearr_28553_28585[(2)] = inst_28535);

(statearr_28553_28585[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (13))){
var inst_28531 = (state_28547[(8)]);
var inst_28527 = (state_28547[(2)]);
var inst_28528 = fluree.db.util.async.throw_err.call(null,inst_28527);
var inst_28529 = fluree.db.dbfunctions.internal.count.call(null,inst_28528);
var inst_28531__$1 = cljs.core.first.call(null,inst_28528);
var inst_28532 = (inst_28531__$1 == null);
var state_28547__$1 = (function (){var statearr_28554 = state_28547;
(statearr_28554[(9)] = inst_28529);

(statearr_28554[(8)] = inst_28531__$1);

return statearr_28554;
})();
if(cljs.core.truth_(inst_28532)){
var statearr_28555_28586 = state_28547__$1;
(statearr_28555_28586[(1)] = (14));

} else {
var statearr_28556_28587 = state_28547__$1;
(statearr_28556_28587[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (6))){
var inst_28503 = (state_28547[(2)]);
var state_28547__$1 = state_28547;
var statearr_28557_28588 = state_28547__$1;
(statearr_28557_28588[(2)] = inst_28503);

(statearr_28557_28588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (3))){
var inst_28545 = (state_28547[(2)]);
var state_28547__$1 = state_28547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28547__$1,inst_28545);
} else {
if((state_val_28548 === (12))){
var inst_28542 = (state_28547[(2)]);
var _ = (function (){var statearr_28558 = state_28547;
(statearr_28558[(4)] = cljs.core.rest.call(null,(state_28547[(4)])));

return statearr_28558;
})();
var state_28547__$1 = state_28547;
var statearr_28559_28589 = state_28547__$1;
(statearr_28559_28589[(2)] = inst_28542);

(statearr_28559_28589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (2))){
var _ = (function (){var statearr_28561 = state_28547;
(statearr_28561[(4)] = cljs.core.cons.call(null,(9),(state_28547[(4)])));

return statearr_28561;
})();
var inst_28509 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28510 = typeof inst_28509 === 'string';
var state_28547__$1 = state_28547;
if(cljs.core.truth_(inst_28510)){
var statearr_28562_28590 = state_28547__$1;
(statearr_28562_28590[(1)] = (10));

} else {
var statearr_28563_28591 = state_28547__$1;
(statearr_28563_28591[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (11))){
var inst_28516 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28517 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28516);
var inst_28518 = fluree.db.dbfunctions.internal.inc.call(null,inst_28517);
var inst_28519 = cljs.core.assoc.call(null,inst_28516,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28518);
var inst_28520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28521 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28522 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28523 = [inst_28521,inst_28522];
var inst_28524 = (new cljs.core.PersistentVector(null,2,(5),inst_28520,inst_28523,null));
var inst_28525 = fluree.db.dbproto._search.call(null,inst_28519,inst_28524);
var state_28547__$1 = state_28547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28547__$1,(13),inst_28525);
} else {
if((state_val_28548 === (9))){
var _ = (function (){var statearr_28564 = state_28547;
(statearr_28564[(4)] = cljs.core.rest.call(null,(state_28547[(4)])));

return statearr_28564;
})();
var state_28547__$1 = state_28547;
var ex28560 = (state_28547__$1[(2)]);
var statearr_28565_28592 = state_28547__$1;
(statearr_28565_28592[(5)] = ex28560);


var statearr_28566_28593 = state_28547__$1;
(statearr_28566_28593[(1)] = (4));

(statearr_28566_28593[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (5))){
var inst_28493 = (state_28547[(7)]);
var _ = (function (){var statearr_28567 = state_28547;
(statearr_28567[(4)] = cljs.core.cons.call(null,(8),(state_28547[(4)])));

return statearr_28567;
})();
var inst_28500 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28493,"?pO","Context Object");
var ___$1 = (function (){var statearr_28568 = state_28547;
(statearr_28568[(4)] = cljs.core.rest.call(null,(state_28547[(4)])));

return statearr_28568;
})();
var state_28547__$1 = state_28547;
var statearr_28569_28594 = state_28547__$1;
(statearr_28569_28594[(2)] = inst_28500);

(statearr_28569_28594[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (14))){
var state_28547__$1 = state_28547;
var statearr_28570_28595 = state_28547__$1;
(statearr_28570_28595[(2)] = null);

(statearr_28570_28595[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (16))){
var inst_28529 = (state_28547[(9)]);
var inst_28537 = (state_28547[(2)]);
var inst_28538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28539 = [inst_28537,inst_28529];
var inst_28540 = (new cljs.core.PersistentVector(null,2,(5),inst_28538,inst_28539,null));
var state_28547__$1 = state_28547;
var statearr_28572_28596 = state_28547__$1;
(statearr_28572_28596[(2)] = inst_28540);

(statearr_28572_28596[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (10))){
var inst_28512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28513 = [null,(0)];
var inst_28514 = (new cljs.core.PersistentVector(null,2,(5),inst_28512,inst_28513,null));
var state_28547__$1 = state_28547;
var statearr_28573_28597 = state_28547__$1;
(statearr_28573_28597[(2)] = inst_28514);

(statearr_28573_28597[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28548 === (8))){
var _ = (function (){var statearr_28574 = state_28547;
(statearr_28574[(4)] = cljs.core.rest.call(null,(state_28547[(4)])));

return statearr_28574;
})();
var state_28547__$1 = state_28547;
var ex28571 = (state_28547__$1[(2)]);
var statearr_28575_28598 = state_28547__$1;
(statearr_28575_28598[(5)] = ex28571);


var statearr_28576_28599 = state_28547__$1;
(statearr_28576_28599[(1)] = (7));

(statearr_28576_28599[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto____0 = (function (){
var statearr_28577 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28577[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto__);

(statearr_28577[(1)] = (1));

return statearr_28577;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto____1 = (function (state_28547){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28578){var ex__2729__auto__ = e28578;
var statearr_28579_28600 = state_28547;
(statearr_28579_28600[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28547[(4)]))){
var statearr_28580_28601 = state_28547;
(statearr_28580_28601[(1)] = cljs.core.first.call(null,(state_28547[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28602 = state_28547;
state_28547 = G__28602;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto__ = function(state_28547){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto____1.call(this,state_28547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28581 = f__2749__auto__.call(null);
(statearr_28581[(6)] = c__2748__auto__);

return statearr_28581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28654){
var state_val_28655 = (state_28654[(1)]);
if((state_val_28655 === (7))){
var inst_28604 = (state_28654[(2)]);
var state_28654__$1 = state_28654;
var statearr_28656_28685 = state_28654__$1;
(statearr_28656_28685[(2)] = inst_28604);

(statearr_28656_28685[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (1))){
var state_28654__$1 = state_28654;
var statearr_28657_28686 = state_28654__$1;
(statearr_28657_28686[(2)] = null);

(statearr_28657_28686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (4))){
var inst_28603 = (state_28654[(2)]);
var state_28654__$1 = (function (){var statearr_28658 = state_28654;
(statearr_28658[(7)] = inst_28603);

return statearr_28658;
})();
var statearr_28659_28687 = state_28654__$1;
(statearr_28659_28687[(2)] = null);

(statearr_28659_28687[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (13))){
var inst_28649 = (state_28654[(2)]);
var _ = (function (){var statearr_28660 = state_28654;
(statearr_28660[(4)] = cljs.core.rest.call(null,(state_28654[(4)])));

return statearr_28660;
})();
var state_28654__$1 = state_28654;
var statearr_28661_28688 = state_28654__$1;
(statearr_28661_28688[(2)] = inst_28649);

(statearr_28661_28688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (6))){
var inst_28613 = (state_28654[(2)]);
var state_28654__$1 = state_28654;
var statearr_28662_28689 = state_28654__$1;
(statearr_28662_28689[(2)] = inst_28613);

(statearr_28662_28689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (3))){
var inst_28652 = (state_28654[(2)]);
var state_28654__$1 = state_28654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28654__$1,inst_28652);
} else {
if((state_val_28655 === (12))){
var inst_28636 = (state_28654[(8)]);
var inst_28645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28646 = [null,inst_28636];
var inst_28647 = (new cljs.core.PersistentVector(null,2,(5),inst_28645,inst_28646,null));
var state_28654__$1 = state_28654;
var statearr_28663_28690 = state_28654__$1;
(statearr_28663_28690[(2)] = inst_28647);

(statearr_28663_28690[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (2))){
var _ = (function (){var statearr_28665 = state_28654;
(statearr_28665[(4)] = cljs.core.cons.call(null,(9),(state_28654[(4)])));

return statearr_28665;
})();
var inst_28622 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28625 = [null,pred_name,"?o"];
var inst_28626 = (new cljs.core.PersistentVector(null,3,(5),inst_28624,inst_28625,null));
var inst_28627 = [inst_28626];
var inst_28628 = (new cljs.core.PersistentVector(null,1,(5),inst_28623,inst_28627,null));
var inst_28629 = ["?o",inst_28628,opts];
var inst_28630 = cljs.core.PersistentHashMap.fromArrays(inst_28622,inst_28629);
var inst_28631 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28630);
var state_28654__$1 = state_28654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28654__$1,(10),inst_28631);
} else {
if((state_val_28655 === (11))){
var inst_28636 = (state_28654[(8)]);
var inst_28635 = (state_28654[(9)]);
var inst_28640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28641 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_28635);
var inst_28642 = [inst_28641,inst_28636];
var inst_28643 = (new cljs.core.PersistentVector(null,2,(5),inst_28640,inst_28642,null));
var state_28654__$1 = state_28654;
var statearr_28666_28691 = state_28654__$1;
(statearr_28666_28691[(2)] = inst_28643);

(statearr_28666_28691[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (9))){
var _ = (function (){var statearr_28667 = state_28654;
(statearr_28667[(4)] = cljs.core.rest.call(null,(state_28654[(4)])));

return statearr_28667;
})();
var state_28654__$1 = state_28654;
var ex28664 = (state_28654__$1[(2)]);
var statearr_28668_28692 = state_28654__$1;
(statearr_28668_28692[(5)] = ex28664);


var statearr_28669_28693 = state_28654__$1;
(statearr_28669_28693[(1)] = (4));

(statearr_28669_28693[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (5))){
var inst_28603 = (state_28654[(7)]);
var _ = (function (){var statearr_28671 = state_28654;
(statearr_28671[(4)] = cljs.core.cons.call(null,(8),(state_28654[(4)])));

return statearr_28671;
})();
var inst_28610 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28603,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_28672 = state_28654;
(statearr_28672[(4)] = cljs.core.rest.call(null,(state_28654[(4)])));

return statearr_28672;
})();
var state_28654__$1 = state_28654;
var statearr_28673_28694 = state_28654__$1;
(statearr_28673_28694[(2)] = inst_28610);

(statearr_28673_28694[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (10))){
var inst_28635 = (state_28654[(9)]);
var inst_28633 = (state_28654[(2)]);
var inst_28634 = fluree.db.util.async.throw_err.call(null,inst_28633);
var inst_28635__$1 = cljs.core.nth.call(null,inst_28634,(0),null);
var inst_28636 = cljs.core.nth.call(null,inst_28634,(1),null);
var inst_28637 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_28635__$1);
var inst_28638 = cljs.core.not.call(null,inst_28637);
var state_28654__$1 = (function (){var statearr_28674 = state_28654;
(statearr_28674[(8)] = inst_28636);

(statearr_28674[(9)] = inst_28635__$1);

return statearr_28674;
})();
if(inst_28638){
var statearr_28675_28695 = state_28654__$1;
(statearr_28675_28695[(1)] = (11));

} else {
var statearr_28676_28696 = state_28654__$1;
(statearr_28676_28696[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28655 === (8))){
var _ = (function (){var statearr_28677 = state_28654;
(statearr_28677[(4)] = cljs.core.rest.call(null,(state_28654[(4)])));

return statearr_28677;
})();
var state_28654__$1 = state_28654;
var ex28670 = (state_28654__$1[(2)]);
var statearr_28678_28697 = state_28654__$1;
(statearr_28678_28697[(5)] = ex28670);


var statearr_28679_28698 = state_28654__$1;
(statearr_28679_28698[(1)] = (7));

(statearr_28679_28698[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto____0 = (function (){
var statearr_28680 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28680[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto__);

(statearr_28680[(1)] = (1));

return statearr_28680;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto____1 = (function (state_28654){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28681){var ex__2729__auto__ = e28681;
var statearr_28682_28699 = state_28654;
(statearr_28682_28699[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28654[(4)]))){
var statearr_28683_28700 = state_28654;
(statearr_28683_28700[(1)] = cljs.core.first.call(null,(state_28654[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28701 = state_28654;
state_28654 = G__28701;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto__ = function(state_28654){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto____1.call(this,state_28654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28684 = f__2749__auto__.call(null);
(statearr_28684[(6)] = c__2748__auto__);

return statearr_28684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e28702){var e = e28702;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28704 = arguments.length;
switch (G__28704) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28774){
var state_val_28775 = (state_28774[(1)]);
if((state_val_28775 === (7))){
var inst_28706 = (state_28774[(2)]);
var state_28774__$1 = state_28774;
var statearr_28776_28820 = state_28774__$1;
(statearr_28776_28820[(2)] = inst_28706);

(statearr_28776_28820[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (20))){
var inst_28750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28751 = ["*"];
var inst_28752 = (new cljs.core.PersistentVector(null,1,(5),inst_28750,inst_28751,null));
var state_28774__$1 = state_28774;
var statearr_28777_28821 = state_28774__$1;
(statearr_28777_28821[(2)] = inst_28752);

(statearr_28777_28821[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (1))){
var state_28774__$1 = state_28774;
var statearr_28778_28822 = state_28774__$1;
(statearr_28778_28822[(2)] = null);

(statearr_28778_28822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (4))){
var inst_28705 = (state_28774[(2)]);
var state_28774__$1 = (function (){var statearr_28779 = state_28774;
(statearr_28779[(7)] = inst_28705);

return statearr_28779;
})();
var statearr_28780_28823 = state_28774__$1;
(statearr_28780_28823[(2)] = null);

(statearr_28780_28823[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (15))){
var inst_28769 = (state_28774[(2)]);
var _ = (function (){var statearr_28781 = state_28774;
(statearr_28781[(4)] = cljs.core.rest.call(null,(state_28774[(4)])));

return statearr_28781;
})();
var state_28774__$1 = state_28774;
var statearr_28782_28824 = state_28774__$1;
(statearr_28782_28824[(2)] = inst_28769);

(statearr_28782_28824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (21))){
var inst_28740 = (state_28774[(8)]);
var inst_28733 = (state_28774[(9)]);
var inst_28754 = (state_28774[(2)]);
var inst_28755 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28756 = cljs.core.PersistentHashMap.EMPTY;
var inst_28757 = [inst_28754,inst_28740,inst_28756];
var inst_28758 = cljs.core.PersistentHashMap.fromArrays(inst_28755,inst_28757);
var inst_28759 = fluree.db.dbfunctions.internal.query.call(null,inst_28733,inst_28758);
var state_28774__$1 = state_28774;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28774__$1,(22),inst_28759);
} else {
if((state_val_28775 === (13))){
var inst_28728 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28774__$1 = state_28774;
var statearr_28783_28825 = state_28774__$1;
(statearr_28783_28825[(2)] = inst_28728);

(statearr_28783_28825[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (22))){
var inst_28761 = (state_28774[(2)]);
var inst_28762 = fluree.db.util.async.throw_err.call(null,inst_28761);
var inst_28763 = cljs.core.nth.call(null,inst_28762,(0),null);
var inst_28764 = cljs.core.nth.call(null,inst_28762,(1),null);
var inst_28765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28766 = [inst_28763,inst_28764];
var inst_28767 = (new cljs.core.PersistentVector(null,2,(5),inst_28765,inst_28766,null));
var state_28774__$1 = state_28774;
var statearr_28784_28826 = state_28774__$1;
(statearr_28784_28826[(2)] = inst_28767);

(statearr_28784_28826[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (6))){
var inst_28715 = (state_28774[(2)]);
var state_28774__$1 = state_28774;
var statearr_28785_28827 = state_28774__$1;
(statearr_28785_28827[(2)] = inst_28715);

(statearr_28785_28827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (17))){
var inst_28737 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28738 = fluree.db.dbfunctions.internal.get.call(null,inst_28737,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28774__$1 = state_28774;
var statearr_28786_28828 = state_28774__$1;
(statearr_28786_28828[(2)] = inst_28738);

(statearr_28786_28828[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (3))){
var inst_28772 = (state_28774[(2)]);
var state_28774__$1 = state_28774;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28774__$1,inst_28772);
} else {
if((state_val_28775 === (12))){
var inst_28726 = (state_28774[(2)]);
var state_28774__$1 = state_28774;
if(cljs.core.truth_(inst_28726)){
var statearr_28787_28829 = state_28774__$1;
(statearr_28787_28829[(1)] = (13));

} else {
var statearr_28788_28830 = state_28774__$1;
(statearr_28788_28830[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (2))){
var inst_28721 = (state_28774[(10)]);
var _ = (function (){var statearr_28789 = state_28774;
(statearr_28789[(4)] = cljs.core.cons.call(null,(9),(state_28774[(4)])));

return statearr_28789;
})();
var inst_28721__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28774__$1 = (function (){var statearr_28790 = state_28774;
(statearr_28790[(10)] = inst_28721__$1);

return statearr_28790;
})();
if(cljs.core.truth_(inst_28721__$1)){
var statearr_28791_28831 = state_28774__$1;
(statearr_28791_28831[(1)] = (10));

} else {
var statearr_28792_28832 = state_28774__$1;
(statearr_28792_28832[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (19))){
var inst_28742 = cljs.core.PersistentVector.EMPTY;
var inst_28743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28744 = ["*"];
var inst_28745 = (new cljs.core.PersistentVector(null,1,(5),inst_28743,inst_28744,null));
var inst_28746 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28747 = cljs.core.concat.call(null,inst_28745,inst_28746);
var inst_28748 = cljs.core.into.call(null,inst_28742,inst_28747);
var state_28774__$1 = state_28774;
var statearr_28794_28833 = state_28774__$1;
(statearr_28794_28833[(2)] = inst_28748);

(statearr_28794_28833[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (11))){
var inst_28721 = (state_28774[(10)]);
var state_28774__$1 = state_28774;
var statearr_28795_28834 = state_28774__$1;
(statearr_28795_28834[(2)] = inst_28721);

(statearr_28795_28834[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (9))){
var _ = (function (){var statearr_28796 = state_28774;
(statearr_28796[(4)] = cljs.core.rest.call(null,(state_28774[(4)])));

return statearr_28796;
})();
var state_28774__$1 = state_28774;
var ex28793 = (state_28774__$1[(2)]);
var statearr_28797_28835 = state_28774__$1;
(statearr_28797_28835[(5)] = ex28793);


var statearr_28798_28836 = state_28774__$1;
(statearr_28798_28836[(1)] = (4));

(statearr_28798_28836[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (5))){
var inst_28705 = (state_28774[(7)]);
var _ = (function (){var statearr_28799 = state_28774;
(statearr_28799[(4)] = cljs.core.cons.call(null,(8),(state_28774[(4)])));

return statearr_28799;
})();
var inst_28712 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28705,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_28800 = state_28774;
(statearr_28800[(4)] = cljs.core.rest.call(null,(state_28774[(4)])));

return statearr_28800;
})();
var state_28774__$1 = state_28774;
var statearr_28801_28837 = state_28774__$1;
(statearr_28801_28837[(2)] = inst_28712);

(statearr_28801_28837[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (14))){
var inst_28734 = (state_28774[(11)]);
var inst_28733 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28734__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28774__$1 = (function (){var statearr_28802 = state_28774;
(statearr_28802[(9)] = inst_28733);

(statearr_28802[(11)] = inst_28734__$1);

return statearr_28802;
})();
if(cljs.core.truth_(inst_28734__$1)){
var statearr_28803_28838 = state_28774__$1;
(statearr_28803_28838[(1)] = (16));

} else {
var statearr_28804_28839 = state_28774__$1;
(statearr_28804_28839[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (16))){
var inst_28734 = (state_28774[(11)]);
var state_28774__$1 = state_28774;
var statearr_28805_28840 = state_28774__$1;
(statearr_28805_28840[(2)] = inst_28734);

(statearr_28805_28840[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (10))){
var inst_28723 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_28774__$1 = state_28774;
var statearr_28807_28841 = state_28774__$1;
(statearr_28807_28841[(2)] = inst_28723);

(statearr_28807_28841[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (18))){
var inst_28740 = (state_28774[(2)]);
var state_28774__$1 = (function (){var statearr_28808 = state_28774;
(statearr_28808[(8)] = inst_28740);

return statearr_28808;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28809_28842 = state_28774__$1;
(statearr_28809_28842[(1)] = (19));

} else {
var statearr_28810_28843 = state_28774__$1;
(statearr_28810_28843[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28775 === (8))){
var _ = (function (){var statearr_28811 = state_28774;
(statearr_28811[(4)] = cljs.core.rest.call(null,(state_28774[(4)])));

return statearr_28811;
})();
var state_28774__$1 = state_28774;
var ex28806 = (state_28774__$1[(2)]);
var statearr_28812_28844 = state_28774__$1;
(statearr_28812_28844[(5)] = ex28806);


var statearr_28813_28845 = state_28774__$1;
(statearr_28813_28845[(1)] = (7));

(statearr_28813_28845[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2726__auto____0 = (function (){
var statearr_28814 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28814[(0)] = fluree$db$dbfunctions$internal$state_machine__2726__auto__);

(statearr_28814[(1)] = (1));

return statearr_28814;
});
var fluree$db$dbfunctions$internal$state_machine__2726__auto____1 = (function (state_28774){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28774);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28815){var ex__2729__auto__ = e28815;
var statearr_28816_28846 = state_28774;
(statearr_28816_28846[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28774[(4)]))){
var statearr_28817_28847 = state_28774;
(statearr_28817_28847[(1)] = cljs.core.first.call(null,(state_28774[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28848 = state_28774;
state_28774 = G__28848;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2726__auto__ = function(state_28774){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____1.call(this,state_28774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28818 = f__2749__auto__.call(null);
(statearr_28818[(6)] = c__2748__auto__);

return statearr_28818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28850 = arguments.length;
switch (G__28850) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28894){
var state_val_28895 = (state_28894[(1)]);
if((state_val_28895 === (7))){
var inst_28872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28873 = ["*"];
var inst_28874 = (new cljs.core.PersistentVector(null,1,(5),inst_28872,inst_28873,null));
var state_28894__$1 = state_28894;
var statearr_28896_28916 = state_28894__$1;
(statearr_28896_28916[(2)] = inst_28874);

(statearr_28896_28916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28895 === (1))){
var state_28894__$1 = state_28894;
var statearr_28897_28917 = state_28894__$1;
(statearr_28897_28917[(2)] = null);

(statearr_28897_28917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28895 === (4))){
var inst_28851 = (state_28894[(2)]);
var inst_28852 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28851,"?p","Context Object",additional_params);
var state_28894__$1 = state_28894;
var statearr_28898_28918 = state_28894__$1;
(statearr_28898_28918[(2)] = inst_28852);

(statearr_28898_28918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28895 === (6))){
var inst_28864 = cljs.core.PersistentVector.EMPTY;
var inst_28865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28866 = ["*"];
var inst_28867 = (new cljs.core.PersistentVector(null,1,(5),inst_28865,inst_28866,null));
var inst_28868 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28869 = cljs.core.concat.call(null,inst_28867,inst_28868);
var inst_28870 = cljs.core.into.call(null,inst_28864,inst_28869);
var state_28894__$1 = state_28894;
var statearr_28899_28919 = state_28894__$1;
(statearr_28899_28919[(2)] = inst_28870);

(statearr_28899_28919[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28895 === (3))){
var inst_28892 = (state_28894[(2)]);
var state_28894__$1 = state_28894;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28894__$1,inst_28892);
} else {
if((state_val_28895 === (2))){
var _ = (function (){var statearr_28901 = state_28894;
(statearr_28901[(4)] = cljs.core.cons.call(null,(5),(state_28894[(4)])));

return statearr_28901;
})();
var inst_28861 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28862 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28894__$1 = (function (){var statearr_28902 = state_28894;
(statearr_28902[(7)] = inst_28862);

(statearr_28902[(8)] = inst_28861);

return statearr_28902;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28903_28920 = state_28894__$1;
(statearr_28903_28920[(1)] = (6));

} else {
var statearr_28904_28921 = state_28894__$1;
(statearr_28904_28921[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28895 === (9))){
var inst_28883 = (state_28894[(2)]);
var inst_28884 = fluree.db.util.async.throw_err.call(null,inst_28883);
var inst_28885 = cljs.core.nth.call(null,inst_28884,(0),null);
var inst_28886 = cljs.core.nth.call(null,inst_28884,(1),null);
var inst_28887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28888 = [inst_28885,inst_28886];
var inst_28889 = (new cljs.core.PersistentVector(null,2,(5),inst_28887,inst_28888,null));
var _ = (function (){var statearr_28905 = state_28894;
(statearr_28905[(4)] = cljs.core.rest.call(null,(state_28894[(4)])));

return statearr_28905;
})();
var state_28894__$1 = state_28894;
var statearr_28906_28922 = state_28894__$1;
(statearr_28906_28922[(2)] = inst_28889);

(statearr_28906_28922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28895 === (5))){
var _ = (function (){var statearr_28907 = state_28894;
(statearr_28907[(4)] = cljs.core.rest.call(null,(state_28894[(4)])));

return statearr_28907;
})();
var state_28894__$1 = state_28894;
var ex28900 = (state_28894__$1[(2)]);
var statearr_28908_28923 = state_28894__$1;
(statearr_28908_28923[(5)] = ex28900);


var statearr_28909_28924 = state_28894__$1;
(statearr_28909_28924[(1)] = (4));

(statearr_28909_28924[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28895 === (8))){
var inst_28862 = (state_28894[(7)]);
var inst_28861 = (state_28894[(8)]);
var inst_28876 = (state_28894[(2)]);
var inst_28877 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28878 = cljs.core.PersistentHashMap.EMPTY;
var inst_28879 = [inst_28876,inst_28862,inst_28878];
var inst_28880 = cljs.core.PersistentHashMap.fromArrays(inst_28877,inst_28879);
var inst_28881 = fluree.db.dbfunctions.internal.query.call(null,inst_28861,inst_28880);
var state_28894__$1 = state_28894;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28894__$1,(9),inst_28881);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2726__auto____0 = (function (){
var statearr_28910 = [null,null,null,null,null,null,null,null,null];
(statearr_28910[(0)] = fluree$db$dbfunctions$internal$state_machine__2726__auto__);

(statearr_28910[(1)] = (1));

return statearr_28910;
});
var fluree$db$dbfunctions$internal$state_machine__2726__auto____1 = (function (state_28894){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28894);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28911){var ex__2729__auto__ = e28911;
var statearr_28912_28925 = state_28894;
(statearr_28912_28925[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28894[(4)]))){
var statearr_28913_28926 = state_28894;
(statearr_28913_28926[(1)] = cljs.core.first.call(null,(state_28894[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28927 = state_28894;
state_28894 = G__28927;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2726__auto__ = function(state_28894){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2726__auto____1.call(this,state_28894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28914 = f__2749__auto__.call(null);
(statearr_28914[(6)] = c__2748__auto__);

return statearr_28914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_28971){
var state_val_28972 = (state_28971[(1)]);
if((state_val_28972 === (1))){
var state_28971__$1 = state_28971;
var statearr_28973_28987 = state_28971__$1;
(statearr_28973_28987[(2)] = null);

(statearr_28973_28987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (2))){
var _ = (function (){var statearr_28974 = state_28971;
(statearr_28974[(4)] = cljs.core.cons.call(null,(5),(state_28971[(4)])));

return statearr_28974;
})();
var inst_28938 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28940 = ["_user/_auth"];
var inst_28941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28942 = ["*"];
var inst_28943 = (new cljs.core.PersistentVector(null,1,(5),inst_28941,inst_28942,null));
var inst_28944 = [inst_28943];
var inst_28945 = cljs.core.PersistentHashMap.fromArrays(inst_28940,inst_28944);
var inst_28946 = [inst_28945];
var inst_28947 = (new cljs.core.PersistentVector(null,1,(5),inst_28939,inst_28946,null));
var inst_28948 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28949 = cljs.core.PersistentHashMap.EMPTY;
var inst_28950 = [inst_28947,inst_28948,inst_28949];
var inst_28951 = cljs.core.PersistentHashMap.fromArrays(inst_28938,inst_28950);
var inst_28952 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28953 = fluree.db.dbfunctions.internal.query.call(null,inst_28952,inst_28951);
var state_28971__$1 = state_28971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28971__$1,(6),inst_28953);
} else {
if((state_val_28972 === (3))){
var inst_28969 = (state_28971[(2)]);
var state_28971__$1 = state_28971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28971__$1,inst_28969);
} else {
if((state_val_28972 === (4))){
var inst_28928 = (state_28971[(2)]);
var inst_28929 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28928,"?user_id-from-auth","Context Object");
var state_28971__$1 = state_28971;
var statearr_28976_28988 = state_28971__$1;
(statearr_28976_28988[(2)] = inst_28929);

(statearr_28976_28988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (5))){
var _ = (function (){var statearr_28977 = state_28971;
(statearr_28977[(4)] = cljs.core.rest.call(null,(state_28971[(4)])));

return statearr_28977;
})();
var state_28971__$1 = state_28971;
var ex28975 = (state_28971__$1[(2)]);
var statearr_28978_28989 = state_28971__$1;
(statearr_28978_28989[(5)] = ex28975);


var statearr_28979_28990 = state_28971__$1;
(statearr_28979_28990[(1)] = (4));

(statearr_28979_28990[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28972 === (6))){
var inst_28955 = (state_28971[(2)]);
var inst_28956 = fluree.db.util.async.throw_err.call(null,inst_28955);
var inst_28957 = cljs.core.nth.call(null,inst_28956,(0),null);
var inst_28958 = cljs.core.nth.call(null,inst_28956,(1),null);
var inst_28959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28960 = ["_user/_auth","_id"];
var inst_28961 = (new cljs.core.PersistentVector(null,2,(5),inst_28959,inst_28960,null));
var inst_28962 = fluree.db.dbfunctions.internal.get_in.call(null,inst_28957,inst_28961);
var inst_28963 = cljs.core.first.call(null,inst_28962);
var inst_28964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28965 = [inst_28963,inst_28958];
var inst_28966 = (new cljs.core.PersistentVector(null,2,(5),inst_28964,inst_28965,null));
var _ = (function (){var statearr_28980 = state_28971;
(statearr_28980[(4)] = cljs.core.rest.call(null,(state_28971[(4)])));

return statearr_28980;
})();
var state_28971__$1 = state_28971;
var statearr_28981_28991 = state_28971__$1;
(statearr_28981_28991[(2)] = inst_28966);

(statearr_28981_28991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto____0 = (function (){
var statearr_28982 = [null,null,null,null,null,null,null];
(statearr_28982[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto__);

(statearr_28982[(1)] = (1));

return statearr_28982;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto____1 = (function (state_28971){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_28971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28983){var ex__2729__auto__ = e28983;
var statearr_28984_28992 = state_28971;
(statearr_28984_28992[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_28971[(4)]))){
var statearr_28985_28993 = state_28971;
(statearr_28985_28993[(1)] = cljs.core.first.call(null,(state_28971[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28994 = state_28971;
state_28971 = G__28994;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto__ = function(state_28971){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto____1.call(this,state_28971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28986 = f__2749__auto__.call(null);
(statearr_28986[(6)] = c__2748__auto__);

return statearr_28986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_29011){
var state_val_29012 = (state_29011[(1)]);
if((state_val_29012 === (1))){
var state_29011__$1 = state_29011;
var statearr_29013_29027 = state_29011__$1;
(statearr_29013_29027[(2)] = null);

(statearr_29013_29027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29012 === (2))){
var _ = (function (){var statearr_29014 = state_29011;
(statearr_29014[(4)] = cljs.core.cons.call(null,(5),(state_29011[(4)])));

return statearr_29014;
})();
var inst_29001 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29002 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29003 = fluree.db.dbproto._subid.call(null,inst_29002,inst_29001);
var state_29011__$1 = state_29011;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29011__$1,(6),inst_29003);
} else {
if((state_val_29012 === (3))){
var inst_29009 = (state_29011[(2)]);
var state_29011__$1 = state_29011;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29011__$1,inst_29009);
} else {
if((state_val_29012 === (4))){
var inst_28995 = (state_29011[(2)]);
var state_29011__$1 = state_29011;
var statearr_29016_29028 = state_29011__$1;
(statearr_29016_29028[(2)] = inst_28995);

(statearr_29016_29028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29012 === (5))){
var _ = (function (){var statearr_29017 = state_29011;
(statearr_29017[(4)] = cljs.core.rest.call(null,(state_29011[(4)])));

return statearr_29017;
})();
var state_29011__$1 = state_29011;
var ex29015 = (state_29011__$1[(2)]);
var statearr_29018_29029 = state_29011__$1;
(statearr_29018_29029[(5)] = ex29015);


if((ex29015 instanceof Error)){
var statearr_29019_29030 = state_29011__$1;
(statearr_29019_29030[(1)] = (4));

(statearr_29019_29030[(5)] = null);

} else {
throw ex29015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29012 === (6))){
var inst_29005 = (state_29011[(2)]);
var inst_29006 = fluree.db.util.async.throw_err.call(null,inst_29005);
var _ = (function (){var statearr_29020 = state_29011;
(statearr_29020[(4)] = cljs.core.rest.call(null,(state_29011[(4)])));

return statearr_29020;
})();
var state_29011__$1 = state_29011;
var statearr_29021_29031 = state_29011__$1;
(statearr_29021_29031[(2)] = inst_29006);

(statearr_29021_29031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto____0 = (function (){
var statearr_29022 = [null,null,null,null,null,null,null];
(statearr_29022[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto__);

(statearr_29022[(1)] = (1));

return statearr_29022;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto____1 = (function (state_29011){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_29011);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e29023){var ex__2729__auto__ = e29023;
var statearr_29024_29032 = state_29011;
(statearr_29024_29032[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_29011[(4)]))){
var statearr_29025_29033 = state_29011;
(statearr_29025_29033[(1)] = cljs.core.first.call(null,(state_29011[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29034 = state_29011;
state_29011 = G__29034;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto__ = function(state_29011){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto____1.call(this,state_29011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_29026 = f__2749__auto__.call(null);
(statearr_29026[(6)] = c__2748__auto__);

return statearr_29026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__29035_SHARP_){
return p1__29035_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29036_SHARP_){
return p1__29036_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29037){var e = e29037;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__29038_SHARP_){
return p1__29038_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29039_SHARP_){
return p1__29039_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29040){var e = e29040;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e29041){var e = e29041;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_29121){
var state_val_29122 = (state_29121[(1)]);
if((state_val_29122 === (7))){
var inst_29060 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_29061 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29062 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29063 = cljs.core.PersistentHashMap.fromArrays(inst_29061,inst_29062);
var inst_29064 = cljs.core.ex_info.call(null,inst_29060,inst_29063);
var inst_29065 = (function(){throw inst_29064})();
var state_29121__$1 = state_29121;
var statearr_29123_29158 = state_29121__$1;
(statearr_29123_29158[(2)] = inst_29065);

(statearr_29123_29158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (1))){
var state_29121__$1 = state_29121;
var statearr_29124_29159 = state_29121__$1;
(statearr_29124_29159[(2)] = null);

(statearr_29124_29159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (4))){
var inst_29042 = (state_29121[(2)]);
var state_29121__$1 = state_29121;
var statearr_29125_29160 = state_29121__$1;
(statearr_29125_29160[(2)] = inst_29042);

(statearr_29125_29160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (15))){
var inst_29105 = (state_29121[(7)]);
var inst_29101 = (state_29121[(2)]);
var inst_29102 = fluree.db.util.async.throw_err.call(null,inst_29101);
var inst_29103 = cljs.core.nth.call(null,inst_29102,(0),null);
var inst_29104 = cljs.core.nth.call(null,inst_29102,(1),null);
var inst_29105__$1 = cljs.core.first.call(null,inst_29103);
var inst_29106 = cljs.core._EQ_.call(null,inst_29105__$1,compare_val);
var state_29121__$1 = (function (){var statearr_29126 = state_29121;
(statearr_29126[(7)] = inst_29105__$1);

(statearr_29126[(8)] = inst_29104);

return statearr_29126;
})();
if(inst_29106){
var statearr_29127_29161 = state_29121__$1;
(statearr_29127_29161[(1)] = (16));

} else {
var statearr_29128_29162 = state_29121__$1;
(statearr_29128_29162[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (13))){
var state_29121__$1 = state_29121;
var statearr_29129_29163 = state_29121__$1;
(statearr_29129_29163[(2)] = null);

(statearr_29129_29163[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (6))){
var state_29121__$1 = state_29121;
var statearr_29130_29164 = state_29121__$1;
(statearr_29130_29164[(2)] = null);

(statearr_29130_29164[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (17))){
var inst_29105 = (state_29121[(7)]);
var inst_29109 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29105)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29110 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29111 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29112 = cljs.core.PersistentHashMap.fromArrays(inst_29110,inst_29111);
var inst_29113 = cljs.core.ex_info.call(null,inst_29109,inst_29112);
var inst_29114 = (function(){throw inst_29113})();
var state_29121__$1 = state_29121;
var statearr_29131_29165 = state_29121__$1;
(statearr_29131_29165[(2)] = inst_29114);

(statearr_29131_29165[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (3))){
var inst_29119 = (state_29121[(2)]);
var state_29121__$1 = state_29121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29121__$1,inst_29119);
} else {
if((state_val_29122 === (12))){
var inst_29057 = (state_29121[(9)]);
var inst_29080 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_29057);
var inst_29081 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29082 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29083 = cljs.core.PersistentHashMap.fromArrays(inst_29081,inst_29082);
var inst_29084 = cljs.core.ex_info.call(null,inst_29080,inst_29083);
var inst_29085 = (function(){throw inst_29084})();
var state_29121__$1 = state_29121;
var statearr_29132_29166 = state_29121__$1;
(statearr_29132_29166[(2)] = inst_29085);

(statearr_29132_29166[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (2))){
var inst_29056 = (state_29121[(10)]);
var inst_29055 = (state_29121[(11)]);
var inst_29054 = (state_29121[(12)]);
var _ = (function (){var statearr_29133 = state_29121;
(statearr_29133[(4)] = cljs.core.cons.call(null,(5),(state_29121[(4)])));

return statearr_29133;
})();
var inst_29052 = _QMARK_ctx;
var inst_29053 = cljs.core.__destructure_map.call(null,inst_29052);
var inst_29054__$1 = cljs.core.get.call(null,inst_29053,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29055__$1 = cljs.core.get.call(null,inst_29053,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29056__$1 = cljs.core.get.call(null,inst_29053,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29057 = fluree.db.dbproto._p_prop.call(null,inst_29056__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29055__$1);
var state_29121__$1 = (function (){var statearr_29134 = state_29121;
(statearr_29134[(9)] = inst_29057);

(statearr_29134[(10)] = inst_29056__$1);

(statearr_29134[(11)] = inst_29055__$1);

(statearr_29134[(12)] = inst_29054__$1);

return statearr_29134;
})();
if(cljs.core.truth_(inst_29054__$1)){
var statearr_29135_29167 = state_29121__$1;
(statearr_29135_29167[(1)] = (6));

} else {
var statearr_29136_29168 = state_29121__$1;
(statearr_29136_29168[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (11))){
var inst_29056 = (state_29121[(10)]);
var inst_29055 = (state_29121[(11)]);
var inst_29077 = (state_29121[(2)]);
var inst_29078 = fluree.db.dbproto._p_prop.call(null,inst_29056,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29055);
var state_29121__$1 = (function (){var statearr_29138 = state_29121;
(statearr_29138[(13)] = inst_29077);

return statearr_29138;
})();
if(cljs.core.truth_(inst_29078)){
var statearr_29139_29169 = state_29121__$1;
(statearr_29139_29169[(1)] = (12));

} else {
var statearr_29140_29170 = state_29121__$1;
(statearr_29140_29170[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (9))){
var state_29121__$1 = state_29121;
var statearr_29141_29171 = state_29121__$1;
(statearr_29141_29171[(2)] = null);

(statearr_29141_29171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (5))){
var _ = (function (){var statearr_29142 = state_29121;
(statearr_29142[(4)] = cljs.core.rest.call(null,(state_29121[(4)])));

return statearr_29142;
})();
var state_29121__$1 = state_29121;
var ex29137 = (state_29121__$1[(2)]);
var statearr_29143_29172 = state_29121__$1;
(statearr_29143_29172[(5)] = ex29137);


if((ex29137 instanceof Error)){
var statearr_29144_29173 = state_29121__$1;
(statearr_29144_29173[(1)] = (4));

(statearr_29144_29173[(5)] = null);

} else {
throw ex29137;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (14))){
var inst_29057 = (state_29121[(9)]);
var inst_29056 = (state_29121[(10)]);
var inst_29054 = (state_29121[(12)]);
var inst_29088 = (state_29121[(2)]);
var inst_29089 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29092 = [inst_29054,inst_29057,"?current-val"];
var inst_29093 = (new cljs.core.PersistentVector(null,3,(5),inst_29091,inst_29092,null));
var inst_29094 = [inst_29093];
var inst_29095 = (new cljs.core.PersistentVector(null,1,(5),inst_29090,inst_29094,null));
var inst_29096 = cljs.core.PersistentHashMap.EMPTY;
var inst_29097 = ["?current-val",inst_29095,inst_29096];
var inst_29098 = cljs.core.PersistentHashMap.fromArrays(inst_29089,inst_29097);
var inst_29099 = fluree.db.dbfunctions.internal.query.call(null,inst_29056,inst_29098);
var state_29121__$1 = (function (){var statearr_29145 = state_29121;
(statearr_29145[(14)] = inst_29088);

return statearr_29145;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29121__$1,(15),inst_29099);
} else {
if((state_val_29122 === (16))){
var state_29121__$1 = state_29121;
var statearr_29146_29174 = state_29121__$1;
(statearr_29146_29174[(2)] = new_val);

(statearr_29146_29174[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (10))){
var inst_29070 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_29071 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29072 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29073 = cljs.core.PersistentHashMap.fromArrays(inst_29071,inst_29072);
var inst_29074 = cljs.core.ex_info.call(null,inst_29070,inst_29073);
var inst_29075 = (function(){throw inst_29074})();
var state_29121__$1 = state_29121;
var statearr_29147_29175 = state_29121__$1;
(statearr_29147_29175[(2)] = inst_29075);

(statearr_29147_29175[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (18))){
var inst_29116 = (state_29121[(2)]);
var _ = (function (){var statearr_29148 = state_29121;
(statearr_29148[(4)] = cljs.core.rest.call(null,(state_29121[(4)])));

return statearr_29148;
})();
var state_29121__$1 = state_29121;
var statearr_29149_29176 = state_29121__$1;
(statearr_29149_29176[(2)] = inst_29116);

(statearr_29149_29176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29122 === (8))){
var inst_29057 = (state_29121[(9)]);
var inst_29067 = (state_29121[(2)]);
var state_29121__$1 = (function (){var statearr_29150 = state_29121;
(statearr_29150[(15)] = inst_29067);

return statearr_29150;
})();
if(cljs.core.truth_(inst_29057)){
var statearr_29151_29177 = state_29121__$1;
(statearr_29151_29177[(1)] = (9));

} else {
var statearr_29152_29178 = state_29121__$1;
(statearr_29152_29178[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto____0 = (function (){
var statearr_29153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29153[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto__);

(statearr_29153[(1)] = (1));

return statearr_29153;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto____1 = (function (state_29121){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_29121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e29154){var ex__2729__auto__ = e29154;
var statearr_29155_29179 = state_29121;
(statearr_29155_29179[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_29121[(4)]))){
var statearr_29156_29180 = state_29121;
(statearr_29156_29180[(1)] = cljs.core.first.call(null,(state_29121[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29181 = state_29121;
state_29121 = G__29181;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto__ = function(state_29121){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto____1.call(this,state_29121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_29157 = f__2749__auto__.call(null);
(statearr_29157[(6)] = c__2748__auto__);

return statearr_29157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
