// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26062 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__26062,(0),null);
var network = cljs.core.nth.call(null,vec__26062,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__26062,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26065){
var map__26066 = p__26065;
var map__26066__$1 = cljs.core.__destructure_map.call(null,map__26066);
var opts = map__26066__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__26066__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_26126){
var state_val_26127 = (state_26126[(1)]);
if((state_val_26127 === (7))){
var inst_26097 = cljs.core.not.call(null,reindex_QMARK_);
var state_26126__$1 = state_26126;
var statearr_26128_26152 = state_26126__$1;
(statearr_26128_26152[(2)] = inst_26097);

(statearr_26128_26152[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (1))){
var state_26126__$1 = state_26126;
var statearr_26129_26153 = state_26126__$1;
(statearr_26129_26153[(2)] = null);

(statearr_26129_26153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (4))){
var inst_26067 = (state_26126[(2)]);
var state_26126__$1 = state_26126;
var statearr_26130_26154 = state_26126__$1;
(statearr_26130_26154[(2)] = inst_26067);

(statearr_26130_26154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (6))){
var inst_26095 = (state_26126[(7)]);
var inst_26081 = (state_26126[(8)]);
var inst_26087 = (state_26126[(9)]);
var inst_26080 = (state_26126[(2)]);
var inst_26081__$1 = fluree.db.util.async.throw_err.call(null,inst_26080);
var inst_26082 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26083 = cljs.core.__destructure_map.call(null,inst_26082);
var inst_26084 = cljs.core.get.call(null,inst_26083,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26085 = cljs.core.get.call(null,inst_26083,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26086 = fluree.db.flake.size_bytes.call(null,inst_26081__$1);
var inst_26087__$1 = (inst_26085 + inst_26086);
var inst_26088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26089 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26090 = (new cljs.core.PersistentVector(null,2,(5),inst_26088,inst_26089,null));
var inst_26091 = cljs.core.get_in.call(null,db,inst_26090);
var inst_26092 = cljs.core.__destructure_map.call(null,inst_26091);
var inst_26093 = cljs.core.get.call(null,inst_26092,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26094 = cljs.core.get.call(null,inst_26092,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26095__$1 = (inst_26087__$1 > inst_26094);
var state_26126__$1 = (function (){var statearr_26131 = state_26126;
(statearr_26131[(7)] = inst_26095__$1);

(statearr_26131[(10)] = inst_26084);

(statearr_26131[(11)] = inst_26093);

(statearr_26131[(8)] = inst_26081__$1);

(statearr_26131[(9)] = inst_26087__$1);

return statearr_26131;
})();
if(cljs.core.truth_(inst_26095__$1)){
var statearr_26132_26155 = state_26126__$1;
(statearr_26132_26155[(1)] = (7));

} else {
var statearr_26133_26156 = state_26126__$1;
(statearr_26133_26156[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (3))){
var inst_26124 = (state_26126[(2)]);
var state_26126__$1 = state_26126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26126__$1,inst_26124);
} else {
if((state_val_26127 === (12))){
var inst_26084 = (state_26126[(10)]);
var inst_26081 = (state_26126[(8)]);
var inst_26087 = (state_26126[(9)]);
var inst_26110 = (state_26126[(2)]);
var inst_26111 = cljs.core.into.call(null,inst_26084,inst_26081);
var inst_26112 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26113 = cljs.core.swap_BANG_.call(null,inst_26112,cljs.core.empty);
var inst_26114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26115 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26116 = (new cljs.core.PersistentVector(null,2,(5),inst_26114,inst_26115,null));
var inst_26117 = cljs.core.assoc_in.call(null,db,inst_26116,inst_26111);
var inst_26118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26119 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26120 = (new cljs.core.PersistentVector(null,2,(5),inst_26118,inst_26119,null));
var inst_26121 = cljs.core.assoc_in.call(null,inst_26117,inst_26120,inst_26087);
var _ = (function (){var statearr_26134 = state_26126;
(statearr_26134[(4)] = cljs.core.rest.call(null,(state_26126[(4)])));

return statearr_26134;
})();
var state_26126__$1 = (function (){var statearr_26135 = state_26126;
(statearr_26135[(12)] = inst_26110);

(statearr_26135[(13)] = inst_26113);

return statearr_26135;
})();
var statearr_26136_26157 = state_26126__$1;
(statearr_26136_26157[(2)] = inst_26121);

(statearr_26136_26157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (2))){
var _ = (function (){var statearr_26137 = state_26126;
(statearr_26137[(4)] = cljs.core.cons.call(null,(5),(state_26126[(4)])));

return statearr_26137;
})();
var inst_26075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26076 = [pred_id];
var inst_26077 = (new cljs.core.PersistentVector(null,1,(5),inst_26075,inst_26076,null));
var inst_26078 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26077);
var state_26126__$1 = state_26126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26126__$1,(6),inst_26078);
} else {
if((state_val_26127 === (11))){
var state_26126__$1 = state_26126;
var statearr_26139_26158 = state_26126__$1;
(statearr_26139_26158[(2)] = null);

(statearr_26139_26158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (9))){
var inst_26100 = (state_26126[(2)]);
var state_26126__$1 = state_26126;
if(cljs.core.truth_(inst_26100)){
var statearr_26140_26159 = state_26126__$1;
(statearr_26140_26159[(1)] = (10));

} else {
var statearr_26141_26160 = state_26126__$1;
(statearr_26141_26160[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (5))){
var _ = (function (){var statearr_26142 = state_26126;
(statearr_26142[(4)] = cljs.core.rest.call(null,(state_26126[(4)])));

return statearr_26142;
})();
var state_26126__$1 = state_26126;
var ex26138 = (state_26126__$1[(2)]);
var statearr_26143_26161 = state_26126__$1;
(statearr_26143_26161[(5)] = ex26138);


if((ex26138 instanceof Error)){
var statearr_26144_26162 = state_26126__$1;
(statearr_26144_26162[(1)] = (4));

(statearr_26144_26162[(5)] = null);

} else {
throw ex26138;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (10))){
var inst_26102 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26103 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26104 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26105 = cljs.core.PersistentHashMap.fromArrays(inst_26103,inst_26104);
var inst_26106 = cljs.core.ex_info.call(null,inst_26102,inst_26105);
var inst_26107 = (function(){throw inst_26106})();
var state_26126__$1 = state_26126;
var statearr_26145_26163 = state_26126__$1;
(statearr_26145_26163[(2)] = inst_26107);

(statearr_26145_26163[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26127 === (8))){
var inst_26095 = (state_26126[(7)]);
var state_26126__$1 = state_26126;
var statearr_26146_26164 = state_26126__$1;
(statearr_26146_26164[(2)] = inst_26095);

(statearr_26146_26164[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto____0 = (function (){
var statearr_26147 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26147[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto__);

(statearr_26147[(1)] = (1));

return statearr_26147;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto____1 = (function (state_26126){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_26126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e26148){var ex__2729__auto__ = e26148;
var statearr_26149_26165 = state_26126;
(statearr_26149_26165[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_26126[(4)]))){
var statearr_26150_26166 = state_26126;
(statearr_26150_26166[(1)] = cljs.core.first.call(null,(state_26126[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26167 = state_26126;
state_26126 = G__26167;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto__ = function(state_26126){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto____1.call(this,state_26126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_26151 = f__2749__auto__.call(null);
(statearr_26151[(6)] = c__2748__auto__);

return statearr_26151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26172 = arguments.length;
switch (G__26172) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_26368){
var state_val_26369 = (state_26368[(1)]);
if((state_val_26369 === (7))){
var state_26368__$1 = state_26368;
var statearr_26370_26437 = state_26368__$1;
(statearr_26370_26437[(2)] = null);

(statearr_26370_26437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (20))){
var inst_26211 = (state_26368[(7)]);
var inst_26261 = (state_26368[(8)]);
var inst_26293 = (state_26368[(9)]);
var inst_26294 = (state_26368[(10)]);
var inst_26292 = (state_26368[(11)]);
var inst_26290 = (state_26368[(12)]);
var inst_26210 = (state_26368[(13)]);
var inst_26291 = (state_26368[(14)]);
var inst_26304 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26306 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26307 = (new cljs.core.PersistentVector(null,2,(5),inst_26305,inst_26306,null));
var inst_26308 = cljs.core.get_in.call(null,inst_26261,inst_26307);
var inst_26309 = (inst_26210 + inst_26308);
var inst_26310 = [inst_26290,inst_26291,inst_26292,inst_26293,inst_26309];
var inst_26311 = cljs.core.PersistentHashMap.fromArrays(inst_26304,inst_26310);
var inst_26312 = cljs.core.assoc.call(null,inst_26261,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26294,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26311);
var state_26368__$1 = (function (){var statearr_26371 = state_26368;
(statearr_26371[(15)] = inst_26312);

return statearr_26371;
})();
if(cljs.core.truth_(inst_26211)){
var statearr_26372_26438 = state_26368__$1;
(statearr_26372_26438[(1)] = (23));

} else {
var statearr_26373_26439 = state_26368__$1;
(statearr_26373_26439[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (27))){
var inst_26312 = (state_26368[(15)]);
var state_26368__$1 = state_26368;
var statearr_26374_26440 = state_26368__$1;
(statearr_26374_26440[(2)] = inst_26312);

(statearr_26374_26440[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (1))){
var state_26368__$1 = state_26368;
var statearr_26375_26441 = state_26368__$1;
(statearr_26375_26441[(2)] = null);

(statearr_26375_26441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (24))){
var inst_26312 = (state_26368[(15)]);
var inst_26315 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26312);
var inst_26316 = (inst_26315 == null);
var state_26368__$1 = state_26368;
var statearr_26376_26442 = state_26368__$1;
(statearr_26376_26442[(2)] = inst_26316);

(statearr_26376_26442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (39))){
var inst_26301 = (state_26368[(16)]);
var inst_26342 = (state_26368[(17)]);
var inst_26344 = (state_26368[(18)]);
var inst_26343 = (state_26368[(19)]);
var inst_26351 = (state_26368[(20)]);
var inst_26358 = (state_26368[(2)]);
var inst_26289 = inst_26301;
var inst_26290 = inst_26343;
var inst_26291 = inst_26344;
var inst_26292 = inst_26351;
var inst_26293 = inst_26358;
var inst_26294 = inst_26342;
var state_26368__$1 = (function (){var statearr_26377 = state_26368;
(statearr_26377[(9)] = inst_26293);

(statearr_26377[(10)] = inst_26294);

(statearr_26377[(11)] = inst_26292);

(statearr_26377[(12)] = inst_26290);

(statearr_26377[(21)] = inst_26289);

(statearr_26377[(14)] = inst_26291);

return statearr_26377;
})();
var statearr_26378_26443 = state_26368__$1;
(statearr_26378_26443[(2)] = null);

(statearr_26378_26443[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (4))){
var inst_26173 = (state_26368[(2)]);
var state_26368__$1 = state_26368;
var statearr_26379_26444 = state_26368__$1;
(statearr_26379_26444[(2)] = inst_26173);

(statearr_26379_26444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (15))){
var inst_26233 = (state_26368[(22)]);
var state_26368__$1 = state_26368;
var statearr_26380_26445 = state_26368__$1;
(statearr_26380_26445[(2)] = inst_26233);

(statearr_26380_26445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (21))){
var inst_26301 = (state_26368[(16)]);
var inst_26180 = (state_26368[(23)]);
var inst_26211 = (state_26368[(7)]);
var inst_26270 = (state_26368[(24)]);
var inst_26195 = (state_26368[(25)]);
var inst_26261 = (state_26368[(8)]);
var inst_26212 = (state_26368[(26)]);
var inst_26293 = (state_26368[(9)]);
var inst_26294 = (state_26368[(10)]);
var inst_26205 = (state_26368[(27)]);
var inst_26209 = (state_26368[(28)]);
var inst_26292 = (state_26368[(11)]);
var inst_26290 = (state_26368[(12)]);
var inst_26214 = (state_26368[(29)]);
var inst_26210 = (state_26368[(13)]);
var inst_26300 = (state_26368[(30)]);
var inst_26289 = (state_26368[(21)]);
var inst_26291 = (state_26368[(14)]);
var inst_26271 = (state_26368[(31)]);
var inst_26197 = (state_26368[(32)]);
var inst_26220 = (state_26368[(33)]);
var inst_26201 = (state_26368[(34)]);
var inst_26339 = inst_26300.s;
var inst_26340 = fluree.db.flake.sid__GT_cid.call(null,inst_26339);
var inst_26341 = (function (){var flakes_bytes = inst_26210;
var t = inst_26180;
var vec__26296 = inst_26289;
var spot = inst_26290;
var add_flakes = inst_26197;
var seq__26297 = inst_26301;
var root_setting_change_QMARK_ = inst_26212;
var ref_QMARK__map = inst_26209;
var r = inst_26301;
var psot = inst_26291;
var add_pred_to_idx_QMARK_ = inst_26220;
var _ = inst_26195;
var cid = inst_26340;
var ecount = inst_26294;
var pred_ecount = inst_26214;
var vec__26266 = inst_26197;
var db_STAR_ = inst_26261;
var schema_change_QMARK_ = inst_26211;
var G__26265 = inst_26289;
var add_preds = inst_26201;
var first__26298 = inst_26300;
var opst = inst_26293;
var seq__26267 = inst_26271;
var idx_QMARK__map = inst_26205;
var first__26268 = inst_26270;
var post = inst_26292;
var f = inst_26300;
return (function (p1__26170_SHARP_){
if(cljs.core.truth_(p1__26170_SHARP_)){
var x__4306__auto__ = p1__26170_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_26342 = cljs.core.update.call(null,inst_26294,inst_26340,inst_26341);
var inst_26343 = cljs.core.conj.call(null,inst_26290,inst_26300);
var inst_26344 = cljs.core.conj.call(null,inst_26291,inst_26300);
var inst_26345 = inst_26300.p;
var inst_26346 = cljs.core.get.call(null,inst_26205,inst_26345);
var state_26368__$1 = (function (){var statearr_26381 = state_26368;
(statearr_26381[(17)] = inst_26342);

(statearr_26381[(18)] = inst_26344);

(statearr_26381[(19)] = inst_26343);

return statearr_26381;
})();
if(cljs.core.truth_(inst_26346)){
var statearr_26382_26446 = state_26368__$1;
(statearr_26382_26446[(1)] = (34));

} else {
var statearr_26383_26447 = state_26368__$1;
(statearr_26383_26447[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (31))){
var inst_26327 = (state_26368[(35)]);
var state_26368__$1 = state_26368;
var statearr_26384_26448 = state_26368__$1;
(statearr_26384_26448[(2)] = inst_26327);

(statearr_26384_26448[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (32))){
var inst_26337 = (state_26368[(2)]);
var state_26368__$1 = state_26368;
var statearr_26385_26449 = state_26368__$1;
(statearr_26385_26449[(2)] = inst_26337);

(statearr_26385_26449[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (33))){
var inst_26327 = (state_26368[(35)]);
var inst_26332 = (state_26368[(2)]);
var inst_26333 = fluree.db.util.async.throw_err.call(null,inst_26332);
var inst_26334 = cljs.core.assoc.call(null,inst_26327,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26333);
var state_26368__$1 = state_26368;
var statearr_26386_26450 = state_26368__$1;
(statearr_26386_26450[(2)] = inst_26334);

(statearr_26386_26450[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (13))){
var inst_26180 = (state_26368[(23)]);
var inst_26261 = (state_26368[(8)]);
var inst_26210 = (state_26368[(13)]);
var inst_26197 = (state_26368[(32)]);
var inst_26251 = (state_26368[(2)]);
var inst_26252 = cljs.core.assoc.call(null,inst_26251,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26180);
var inst_26253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26254 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26255 = (new cljs.core.PersistentVector(null,2,(5),inst_26253,inst_26254,null));
var inst_26256 = cljs.core.update_in.call(null,inst_26252,inst_26255,cljs.core._PLUS_,inst_26210);
var inst_26257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26258 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26259 = (new cljs.core.PersistentVector(null,2,(5),inst_26257,inst_26258,null));
var inst_26260 = cljs.core.count.call(null,inst_26197);
var inst_26261__$1 = cljs.core.update_in.call(null,inst_26256,inst_26259,cljs.core._PLUS_,inst_26260);
var inst_26269 = cljs.core.seq.call(null,inst_26197);
var inst_26270 = cljs.core.first.call(null,inst_26269);
var inst_26271 = cljs.core.next.call(null,inst_26269);
var inst_26272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26273 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26274 = (new cljs.core.PersistentVector(null,2,(5),inst_26272,inst_26273,null));
var inst_26275 = cljs.core.get_in.call(null,inst_26261__$1,inst_26274);
var inst_26276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26277 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26278 = (new cljs.core.PersistentVector(null,2,(5),inst_26276,inst_26277,null));
var inst_26279 = cljs.core.get_in.call(null,inst_26261__$1,inst_26278);
var inst_26280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26281 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26282 = (new cljs.core.PersistentVector(null,2,(5),inst_26280,inst_26281,null));
var inst_26283 = cljs.core.get_in.call(null,inst_26261__$1,inst_26282);
var inst_26284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26285 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26286 = (new cljs.core.PersistentVector(null,2,(5),inst_26284,inst_26285,null));
var inst_26287 = cljs.core.get_in.call(null,inst_26261__$1,inst_26286);
var inst_26288 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26289 = inst_26197;
var inst_26290 = inst_26275;
var inst_26291 = inst_26279;
var inst_26292 = inst_26283;
var inst_26293 = inst_26287;
var inst_26294 = inst_26288;
var state_26368__$1 = (function (){var statearr_26387 = state_26368;
(statearr_26387[(24)] = inst_26270);

(statearr_26387[(8)] = inst_26261__$1);

(statearr_26387[(9)] = inst_26293);

(statearr_26387[(10)] = inst_26294);

(statearr_26387[(11)] = inst_26292);

(statearr_26387[(12)] = inst_26290);

(statearr_26387[(21)] = inst_26289);

(statearr_26387[(14)] = inst_26291);

(statearr_26387[(31)] = inst_26271);

return statearr_26387;
})();
var statearr_26388_26451 = state_26368__$1;
(statearr_26388_26451[(2)] = null);

(statearr_26388_26451[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (22))){
var inst_26361 = (state_26368[(2)]);
var state_26368__$1 = state_26368;
var statearr_26389_26452 = state_26368__$1;
(statearr_26389_26452[(2)] = inst_26361);

(statearr_26389_26452[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (36))){
var inst_26209 = (state_26368[(28)]);
var inst_26300 = (state_26368[(30)]);
var inst_26351 = (state_26368[(2)]);
var inst_26352 = inst_26300.p;
var inst_26353 = cljs.core.get.call(null,inst_26209,inst_26352);
var state_26368__$1 = (function (){var statearr_26390 = state_26368;
(statearr_26390[(20)] = inst_26351);

return statearr_26390;
})();
if(cljs.core.truth_(inst_26353)){
var statearr_26391_26453 = state_26368__$1;
(statearr_26391_26453[(1)] = (37));

} else {
var statearr_26392_26454 = state_26368__$1;
(statearr_26392_26454[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (29))){
var inst_26312 = (state_26368[(15)]);
var inst_26322 = (state_26368[(2)]);
var inst_26323 = fluree.db.util.async.throw_err.call(null,inst_26322);
var inst_26324 = cljs.core.assoc.call(null,inst_26312,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26323);
var state_26368__$1 = state_26368;
var statearr_26393_26455 = state_26368__$1;
(statearr_26393_26455[(2)] = inst_26324);

(statearr_26393_26455[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (6))){
var inst_26180 = (state_26368[(23)]);
var inst_26185 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26186 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26187 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26185)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26186)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26180),"."].join('');
var inst_26188 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26189 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26190 = cljs.core.PersistentHashMap.fromArrays(inst_26188,inst_26189);
var inst_26191 = cljs.core.ex_info.call(null,inst_26187,inst_26190);
var inst_26192 = (function(){throw inst_26191})();
var state_26368__$1 = state_26368;
var statearr_26394_26456 = state_26368__$1;
(statearr_26394_26456[(2)] = inst_26192);

(statearr_26394_26456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (28))){
var inst_26212 = (state_26368[(26)]);
var inst_26327 = (state_26368[(2)]);
var state_26368__$1 = (function (){var statearr_26395 = state_26368;
(statearr_26395[(35)] = inst_26327);

return statearr_26395;
})();
if(cljs.core.truth_(inst_26212)){
var statearr_26396_26457 = state_26368__$1;
(statearr_26396_26457[(1)] = (30));

} else {
var statearr_26397_26458 = state_26368__$1;
(statearr_26397_26458[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (25))){
var inst_26318 = (state_26368[(2)]);
var state_26368__$1 = state_26368;
if(cljs.core.truth_(inst_26318)){
var statearr_26398_26459 = state_26368__$1;
(statearr_26398_26459[(1)] = (26));

} else {
var statearr_26399_26460 = state_26368__$1;
(statearr_26399_26460[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (34))){
var inst_26292 = (state_26368[(11)]);
var inst_26300 = (state_26368[(30)]);
var inst_26348 = cljs.core.conj.call(null,inst_26292,inst_26300);
var state_26368__$1 = state_26368;
var statearr_26400_26461 = state_26368__$1;
(statearr_26400_26461[(2)] = inst_26348);

(statearr_26400_26461[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (17))){
var inst_26240 = (state_26368[(36)]);
var inst_26244 = (state_26368[(2)]);
var inst_26245 = fluree.db.util.async.throw_err.call(null,inst_26244);
var inst_26232 = inst_26240;
var inst_26233 = inst_26245;
var state_26368__$1 = (function (){var statearr_26401 = state_26368;
(statearr_26401[(37)] = inst_26232);

(statearr_26401[(22)] = inst_26233);

return statearr_26401;
})();
var statearr_26402_26462 = state_26368__$1;
(statearr_26402_26462[(2)] = null);

(statearr_26402_26462[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (3))){
var inst_26366 = (state_26368[(2)]);
var state_26368__$1 = state_26368;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26368__$1,inst_26366);
} else {
if((state_val_26369 === (12))){
var inst_26239 = (state_26368[(38)]);
var inst_26232 = (state_26368[(37)]);
var inst_26238 = cljs.core.seq.call(null,inst_26232);
var inst_26239__$1 = cljs.core.first.call(null,inst_26238);
var inst_26240 = cljs.core.next.call(null,inst_26238);
var state_26368__$1 = (function (){var statearr_26403 = state_26368;
(statearr_26403[(36)] = inst_26240);

(statearr_26403[(38)] = inst_26239__$1);

return statearr_26403;
})();
if(cljs.core.truth_(inst_26239__$1)){
var statearr_26404_26463 = state_26368__$1;
(statearr_26404_26463[(1)] = (14));

} else {
var statearr_26405_26464 = state_26368__$1;
(statearr_26405_26464[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (2))){
var inst_26180 = (state_26368[(23)]);
var _ = (function (){var statearr_26406 = state_26368;
(statearr_26406[(4)] = cljs.core.cons.call(null,(5),(state_26368[(4)])));

return statearr_26406;
})();
var inst_26179 = cljs.core.first.call(null,flakes);
var inst_26180__$1 = inst_26179.t;
var inst_26181 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26182 = (inst_26181 - (1));
var inst_26183 = cljs.core.not_EQ_.call(null,inst_26180__$1,inst_26182);
var state_26368__$1 = (function (){var statearr_26407 = state_26368;
(statearr_26407[(23)] = inst_26180__$1);

return statearr_26407;
})();
if(inst_26183){
var statearr_26408_26465 = state_26368__$1;
(statearr_26408_26465[(1)] = (6));

} else {
var statearr_26409_26466 = state_26368__$1;
(statearr_26409_26466[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (23))){
var inst_26211 = (state_26368[(7)]);
var state_26368__$1 = state_26368;
var statearr_26410_26467 = state_26368__$1;
(statearr_26410_26467[(2)] = inst_26211);

(statearr_26410_26467[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (35))){
var inst_26292 = (state_26368[(11)]);
var state_26368__$1 = state_26368;
var statearr_26411_26468 = state_26368__$1;
(statearr_26411_26468[(2)] = inst_26292);

(statearr_26411_26468[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (19))){
var inst_26363 = (state_26368[(2)]);
var _ = (function (){var statearr_26412 = state_26368;
(statearr_26412[(4)] = cljs.core.rest.call(null,(state_26368[(4)])));

return statearr_26412;
})();
var state_26368__$1 = state_26368;
var statearr_26413_26469 = state_26368__$1;
(statearr_26413_26469[(2)] = inst_26363);

(statearr_26413_26469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (11))){
var inst_26220 = (state_26368[(33)]);
var inst_26220__$1 = (state_26368[(2)]);
var inst_26228 = cljs.core.seq.call(null,inst_26220__$1);
var inst_26229 = cljs.core.first.call(null,inst_26228);
var inst_26230 = cljs.core.next.call(null,inst_26228);
var inst_26231 = db;
var inst_26232 = inst_26220__$1;
var inst_26233 = inst_26231;
var state_26368__$1 = (function (){var statearr_26415 = state_26368;
(statearr_26415[(39)] = inst_26230);

(statearr_26415[(40)] = inst_26229);

(statearr_26415[(37)] = inst_26232);

(statearr_26415[(33)] = inst_26220__$1);

(statearr_26415[(22)] = inst_26233);

return statearr_26415;
})();
var statearr_26416_26470 = state_26368__$1;
(statearr_26416_26470[(2)] = null);

(statearr_26416_26470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (9))){
var inst_26214 = (state_26368[(29)]);
var inst_26197 = (state_26368[(32)]);
var inst_26216 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_26197,inst_26214);
var state_26368__$1 = state_26368;
var statearr_26417_26471 = state_26368__$1;
(statearr_26417_26471[(2)] = inst_26216);

(statearr_26417_26471[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (5))){
var _ = (function (){var statearr_26418 = state_26368;
(statearr_26418[(4)] = cljs.core.rest.call(null,(state_26368[(4)])));

return statearr_26418;
})();
var state_26368__$1 = state_26368;
var ex26414 = (state_26368__$1[(2)]);
var statearr_26419_26472 = state_26368__$1;
(statearr_26419_26472[(5)] = ex26414);


if((ex26414 instanceof Error)){
var statearr_26420_26473 = state_26368__$1;
(statearr_26420_26473[(1)] = (4));

(statearr_26420_26473[(5)] = null);

} else {
throw ex26414;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (14))){
var inst_26239 = (state_26368[(38)]);
var inst_26233 = (state_26368[(22)]);
var inst_26242 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_26233,inst_26239,opts);
var state_26368__$1 = state_26368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26368__$1,(17),inst_26242);
} else {
if((state_val_26369 === (26))){
var inst_26312 = (state_26368[(15)]);
var inst_26320 = fluree.db.query.schema.schema_map.call(null,inst_26312);
var state_26368__$1 = state_26368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26368__$1,(29),inst_26320);
} else {
if((state_val_26369 === (16))){
var inst_26249 = (state_26368[(2)]);
var state_26368__$1 = state_26368;
var statearr_26421_26474 = state_26368__$1;
(statearr_26421_26474[(2)] = inst_26249);

(statearr_26421_26474[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (38))){
var inst_26293 = (state_26368[(9)]);
var state_26368__$1 = state_26368;
var statearr_26422_26475 = state_26368__$1;
(statearr_26422_26475[(2)] = inst_26293);

(statearr_26422_26475[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (30))){
var inst_26327 = (state_26368[(35)]);
var inst_26330 = fluree.db.query.schema.setting_map.call(null,inst_26327);
var state_26368__$1 = state_26368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26368__$1,(33),inst_26330);
} else {
if((state_val_26369 === (10))){
var inst_26218 = cljs.core.PersistentVector.EMPTY;
var state_26368__$1 = state_26368;
var statearr_26423_26476 = state_26368__$1;
(statearr_26423_26476[(2)] = inst_26218);

(statearr_26423_26476[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (18))){
var inst_26300 = (state_26368[(30)]);
var inst_26289 = (state_26368[(21)]);
var inst_26299 = cljs.core.seq.call(null,inst_26289);
var inst_26300__$1 = cljs.core.first.call(null,inst_26299);
var inst_26301 = cljs.core.next.call(null,inst_26299);
var inst_26302 = cljs.core.not.call(null,inst_26300__$1);
var state_26368__$1 = (function (){var statearr_26424 = state_26368;
(statearr_26424[(16)] = inst_26301);

(statearr_26424[(30)] = inst_26300__$1);

return statearr_26424;
})();
if(inst_26302){
var statearr_26425_26477 = state_26368__$1;
(statearr_26425_26477[(1)] = (20));

} else {
var statearr_26426_26478 = state_26368__$1;
(statearr_26426_26478[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (37))){
var inst_26293 = (state_26368[(9)]);
var inst_26300 = (state_26368[(30)]);
var inst_26355 = cljs.core.conj.call(null,inst_26293,inst_26300);
var state_26368__$1 = state_26368;
var statearr_26427_26479 = state_26368__$1;
(statearr_26427_26479[(2)] = inst_26355);

(statearr_26427_26479[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26369 === (8))){
var inst_26180 = (state_26368[(23)]);
var inst_26211 = (state_26368[(7)]);
var inst_26195 = (state_26368[(25)]);
var inst_26205 = (state_26368[(27)]);
var inst_26197 = (state_26368[(32)]);
var inst_26201 = (state_26368[(34)]);
var inst_26195__$1 = (state_26368[(2)]);
var inst_26196 = (function (){var t = inst_26180;
var _ = inst_26195__$1;
return (function (p1__26168_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__26168_SHARP_.p));
});
})();
var inst_26197__$1 = cljs.core.filter.call(null,inst_26196,flakes);
var inst_26198 = cljs.core.PersistentHashSet.EMPTY;
var inst_26199 = (function (){var t = inst_26180;
var _ = inst_26195__$1;
var add_flakes = inst_26197__$1;
return (function (p1__26169_SHARP_){
return p1__26169_SHARP_.p;
});
})();
var inst_26200 = cljs.core.map.call(null,inst_26199,inst_26197__$1);
var inst_26201__$1 = cljs.core.into.call(null,inst_26198,inst_26200);
var inst_26202 = cljs.core.PersistentHashMap.EMPTY;
var inst_26203 = (function (){var t = inst_26180;
var _ = inst_26195__$1;
var add_flakes = inst_26197__$1;
var add_preds = inst_26201__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26204 = cljs.core.map.call(null,inst_26203,inst_26201__$1);
var inst_26205__$1 = cljs.core.into.call(null,inst_26202,inst_26204);
var inst_26206 = cljs.core.PersistentHashMap.EMPTY;
var inst_26207 = (function (){var t = inst_26180;
var _ = inst_26195__$1;
var add_flakes = inst_26197__$1;
var add_preds = inst_26201__$1;
var idx_QMARK__map = inst_26205__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26208 = cljs.core.map.call(null,inst_26207,inst_26201__$1);
var inst_26209 = cljs.core.into.call(null,inst_26206,inst_26208);
var inst_26210 = fluree.db.flake.size_bytes.call(null,inst_26197__$1);
var inst_26211__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_26197__$1);
var inst_26212 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_26197__$1);
var inst_26213 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26214 = cljs.core.get.call(null,inst_26213,(0));
var state_26368__$1 = (function (){var statearr_26428 = state_26368;
(statearr_26428[(7)] = inst_26211__$1);

(statearr_26428[(25)] = inst_26195__$1);

(statearr_26428[(26)] = inst_26212);

(statearr_26428[(27)] = inst_26205__$1);

(statearr_26428[(28)] = inst_26209);

(statearr_26428[(29)] = inst_26214);

(statearr_26428[(13)] = inst_26210);

(statearr_26428[(32)] = inst_26197__$1);

(statearr_26428[(34)] = inst_26201__$1);

return statearr_26428;
})();
if(cljs.core.truth_(inst_26211__$1)){
var statearr_26429_26480 = state_26368__$1;
(statearr_26429_26480[(1)] = (9));

} else {
var statearr_26430_26481 = state_26368__$1;
(statearr_26430_26481[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2726__auto__ = null;
var fluree$db$graphdb$state_machine__2726__auto____0 = (function (){
var statearr_26431 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26431[(0)] = fluree$db$graphdb$state_machine__2726__auto__);

(statearr_26431[(1)] = (1));

return statearr_26431;
});
var fluree$db$graphdb$state_machine__2726__auto____1 = (function (state_26368){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_26368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e26432){var ex__2729__auto__ = e26432;
var statearr_26433_26482 = state_26368;
(statearr_26433_26482[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_26368[(4)]))){
var statearr_26434_26483 = state_26368;
(statearr_26434_26483[(1)] = cljs.core.first.call(null,(state_26368[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26484 = state_26368;
state_26368 = G__26484;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2726__auto__ = function(state_26368){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2726__auto____1.call(this,state_26368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2726__auto____0;
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2726__auto____1;
return fluree$db$graphdb$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_26435 = f__2749__auto__.call(null);
(statearr_26435[(6)] = c__2748__auto__);

return statearr_26435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26486 = arguments.length;
switch (G__26486) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2748__auto___26633 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_26582){
var state_val_26583 = (state_26582[(1)]);
if((state_val_26583 === (7))){
var state_26582__$1 = state_26582;
var statearr_26584_26634 = state_26582__$1;
(statearr_26584_26634[(2)] = null);

(statearr_26584_26634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (20))){
var inst_26531 = (state_26582[(7)]);
var inst_26530 = (state_26582[(8)]);
var inst_26532 = (state_26582[(9)]);
var inst_26551 = (inst_26530 + (1));
var inst_26552 = cljs.core.assoc.call(null,inst_26532,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26551);
var inst_26553 = fluree.db.graphdb.with_t.call(null,inst_26552,inst_26531,opts);
var state_26582__$1 = state_26582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26582__$1,(23),inst_26553);
} else {
if((state_val_26583 === (1))){
var state_26582__$1 = state_26582;
var statearr_26585_26635 = state_26582__$1;
(statearr_26585_26635[(2)] = null);

(statearr_26585_26635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (24))){
var inst_26556 = (state_26582[(10)]);
var inst_26559 = cljs.core.assoc.call(null,inst_26556,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26582__$1 = state_26582;
var statearr_26586_26636 = state_26582__$1;
(statearr_26586_26636[(2)] = inst_26559);

(statearr_26586_26636[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (4))){
var inst_26487 = (state_26582[(2)]);
var inst_26488 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26487);
var state_26582__$1 = state_26582;
var statearr_26587_26637 = state_26582__$1;
(statearr_26587_26637[(2)] = inst_26488);

(statearr_26587_26637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (15))){
var inst_26538 = (state_26582[(11)]);
var state_26582__$1 = state_26582;
var statearr_26588_26638 = state_26582__$1;
(statearr_26588_26638[(2)] = inst_26538);

(statearr_26588_26638[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (21))){
var state_26582__$1 = state_26582;
var statearr_26589_26639 = state_26582__$1;
(statearr_26589_26639[(2)] = null);

(statearr_26589_26639[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (13))){
var inst_26574 = (state_26582[(2)]);
var inst_26575 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26574);
var state_26582__$1 = state_26582;
var statearr_26590_26640 = state_26582__$1;
(statearr_26590_26640[(2)] = inst_26575);

(statearr_26590_26640[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (22))){
var inst_26570 = (state_26582[(2)]);
var state_26582__$1 = state_26582;
var statearr_26591_26641 = state_26582__$1;
(statearr_26591_26641[(2)] = inst_26570);

(statearr_26591_26641[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (6))){
var inst_26498 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26499 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26500 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26498)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26499)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26501 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26502 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26503 = cljs.core.PersistentHashMap.fromArrays(inst_26501,inst_26502);
var inst_26504 = cljs.core.ex_info.call(null,inst_26500,inst_26503);
var inst_26505 = (function(){throw inst_26504})();
var state_26582__$1 = state_26582;
var statearr_26594_26642 = state_26582__$1;
(statearr_26594_26642[(2)] = inst_26505);

(statearr_26594_26642[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (25))){
var inst_26538 = (state_26582[(11)]);
var inst_26556 = (state_26582[(10)]);
var inst_26539 = (state_26582[(12)]);
var inst_26561 = inst_26538.t;
var inst_26562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26563 = [inst_26538];
var inst_26564 = (new cljs.core.PersistentVector(null,1,(5),inst_26562,inst_26563,null));
var inst_26529 = inst_26539;
var inst_26530 = inst_26561;
var inst_26531 = inst_26564;
var inst_26532 = inst_26556;
var state_26582__$1 = (function (){var statearr_26595 = state_26582;
(statearr_26595[(7)] = inst_26531);

(statearr_26595[(8)] = inst_26530);

(statearr_26595[(9)] = inst_26532);

(statearr_26595[(13)] = inst_26529);

return statearr_26595;
})();
var statearr_26596_26643 = state_26582__$1;
(statearr_26596_26643[(2)] = null);

(statearr_26596_26643[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (17))){
var inst_26538 = (state_26582[(11)]);
var inst_26539 = (state_26582[(12)]);
var inst_26531 = (state_26582[(7)]);
var inst_26530 = (state_26582[(8)]);
var inst_26532 = (state_26582[(9)]);
var inst_26547 = cljs.core.conj.call(null,inst_26531,inst_26538);
var tmp26592 = inst_26530;
var tmp26593 = inst_26532;
var inst_26529 = inst_26539;
var inst_26530__$1 = tmp26592;
var inst_26531__$1 = inst_26547;
var inst_26532__$1 = tmp26593;
var state_26582__$1 = (function (){var statearr_26597 = state_26582;
(statearr_26597[(7)] = inst_26531__$1);

(statearr_26597[(8)] = inst_26530__$1);

(statearr_26597[(9)] = inst_26532__$1);

(statearr_26597[(13)] = inst_26529);

return statearr_26597;
})();
var statearr_26598_26644 = state_26582__$1;
(statearr_26598_26644[(2)] = null);

(statearr_26598_26644[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (3))){
var inst_26580 = (state_26582[(2)]);
var state_26582__$1 = state_26582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26582__$1,inst_26580);
} else {
if((state_val_26583 === (12))){
var inst_26538 = (state_26582[(11)]);
var inst_26529 = (state_26582[(13)]);
var inst_26537 = cljs.core.seq.call(null,inst_26529);
var inst_26538__$1 = cljs.core.first.call(null,inst_26537);
var inst_26539 = cljs.core.next.call(null,inst_26537);
var state_26582__$1 = (function (){var statearr_26599 = state_26582;
(statearr_26599[(11)] = inst_26538__$1);

(statearr_26599[(12)] = inst_26539);

return statearr_26599;
})();
if(cljs.core.truth_(inst_26538__$1)){
var statearr_26600_26645 = state_26582__$1;
(statearr_26600_26645[(1)] = (14));

} else {
var statearr_26601_26646 = state_26582__$1;
(statearr_26601_26646[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (2))){
var _ = (function (){var statearr_26602 = state_26582;
(statearr_26602[(4)] = cljs.core.cons.call(null,(5),(state_26582[(4)])));

return statearr_26602;
})();
var inst_26494 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26495 = (inst_26494 + (1));
var inst_26496 = cljs.core.not_EQ_.call(null,block,inst_26495);
var state_26582__$1 = state_26582;
if(inst_26496){
var statearr_26603_26647 = state_26582__$1;
(statearr_26603_26647[(1)] = (6));

} else {
var statearr_26604_26648 = state_26582__$1;
(statearr_26604_26648[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (23))){
var inst_26538 = (state_26582[(11)]);
var inst_26555 = (state_26582[(2)]);
var inst_26556 = fluree.db.util.async.throw_err.call(null,inst_26555);
var inst_26557 = (inst_26538 == null);
var state_26582__$1 = (function (){var statearr_26605 = state_26582;
(statearr_26605[(10)] = inst_26556);

return statearr_26605;
})();
if(cljs.core.truth_(inst_26557)){
var statearr_26606_26649 = state_26582__$1;
(statearr_26606_26649[(1)] = (24));

} else {
var statearr_26607_26650 = state_26582__$1;
(statearr_26607_26650[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (19))){
var inst_26572 = (state_26582[(2)]);
var state_26582__$1 = state_26582;
var statearr_26608_26651 = state_26582__$1;
(statearr_26608_26651[(2)] = inst_26572);

(statearr_26608_26651[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (11))){
var inst_26577 = (state_26582[(2)]);
var _ = (function (){var statearr_26610 = state_26582;
(statearr_26610[(4)] = cljs.core.rest.call(null,(state_26582[(4)])));

return statearr_26610;
})();
var state_26582__$1 = state_26582;
var statearr_26611_26652 = state_26582__$1;
(statearr_26611_26652[(2)] = inst_26577);

(statearr_26611_26652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (9))){
var inst_26511 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26512 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26511);
var state_26582__$1 = state_26582;
var statearr_26612_26653 = state_26582__$1;
(statearr_26612_26653[(2)] = inst_26512);

(statearr_26612_26653[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (5))){
var _ = (function (){var statearr_26613 = state_26582;
(statearr_26613[(4)] = cljs.core.rest.call(null,(state_26582[(4)])));

return statearr_26613;
})();
var state_26582__$1 = state_26582;
var ex26609 = (state_26582__$1[(2)]);
var statearr_26614_26654 = state_26582__$1;
(statearr_26614_26654[(5)] = ex26609);


var statearr_26615_26655 = state_26582__$1;
(statearr_26615_26655[(1)] = (4));

(statearr_26615_26655[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (14))){
var inst_26538 = (state_26582[(11)]);
var inst_26530 = (state_26582[(8)]);
var inst_26541 = inst_26538.t;
var inst_26542 = cljs.core._EQ_.call(null,inst_26530,inst_26541);
var state_26582__$1 = state_26582;
var statearr_26616_26656 = state_26582__$1;
(statearr_26616_26656[(2)] = inst_26542);

(statearr_26616_26656[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (26))){
var inst_26567 = (state_26582[(2)]);
var state_26582__$1 = state_26582;
var statearr_26617_26657 = state_26582__$1;
(statearr_26617_26657[(2)] = inst_26567);

(statearr_26617_26657[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (16))){
var inst_26545 = (state_26582[(2)]);
var state_26582__$1 = state_26582;
if(cljs.core.truth_(inst_26545)){
var statearr_26618_26658 = state_26582__$1;
(statearr_26618_26658[(1)] = (17));

} else {
var statearr_26619_26659 = state_26582__$1;
(statearr_26619_26659[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (10))){
var inst_26514 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26522 = cljs.core.seq.call(null,inst_26514);
var inst_26523 = cljs.core.first.call(null,inst_26522);
var inst_26524 = cljs.core.next.call(null,inst_26522);
var inst_26525 = cljs.core.first.call(null,inst_26514);
var inst_26526 = inst_26525.t;
var inst_26527 = cljs.core.PersistentVector.EMPTY;
var inst_26528 = db;
var inst_26529 = inst_26514;
var inst_26530 = inst_26526;
var inst_26531 = inst_26527;
var inst_26532 = inst_26528;
var state_26582__$1 = (function (){var statearr_26620 = state_26582;
(statearr_26620[(7)] = inst_26531);

(statearr_26620[(8)] = inst_26530);

(statearr_26620[(14)] = inst_26524);

(statearr_26620[(9)] = inst_26532);

(statearr_26620[(13)] = inst_26529);

(statearr_26620[(15)] = inst_26523);

return statearr_26620;
})();
var statearr_26621_26660 = state_26582__$1;
(statearr_26621_26660[(2)] = null);

(statearr_26621_26660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (18))){
var state_26582__$1 = state_26582;
var statearr_26622_26661 = state_26582__$1;
(statearr_26622_26661[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26583 === (8))){
var inst_26508 = (state_26582[(2)]);
var inst_26509 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26582__$1 = (function (){var statearr_26624 = state_26582;
(statearr_26624[(16)] = inst_26508);

return statearr_26624;
})();
if(inst_26509){
var statearr_26625_26662 = state_26582__$1;
(statearr_26625_26662[(1)] = (9));

} else {
var statearr_26626_26663 = state_26582__$1;
(statearr_26626_26663[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2726__auto__ = null;
var fluree$db$graphdb$state_machine__2726__auto____0 = (function (){
var statearr_26627 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26627[(0)] = fluree$db$graphdb$state_machine__2726__auto__);

(statearr_26627[(1)] = (1));

return statearr_26627;
});
var fluree$db$graphdb$state_machine__2726__auto____1 = (function (state_26582){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_26582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e26628){var ex__2729__auto__ = e26628;
var statearr_26629_26664 = state_26582;
(statearr_26629_26664[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_26582[(4)]))){
var statearr_26630_26665 = state_26582;
(statearr_26630_26665[(1)] = cljs.core.first.call(null,(state_26582[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26666 = state_26582;
state_26582 = G__26666;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2726__auto__ = function(state_26582){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2726__auto____1.call(this,state_26582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2726__auto____0;
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2726__auto____1;
return fluree$db$graphdb$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_26631 = f__2749__auto__.call(null);
(statearr_26631[(6)] = c__2748__auto___26633);

return statearr_26631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_26722){
var state_val_26723 = (state_26722[(1)]);
if((state_val_26723 === (7))){
var state_26722__$1 = state_26722;
var statearr_26724_26751 = state_26722__$1;
(statearr_26724_26751[(2)] = tt_id);

(statearr_26724_26751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (1))){
var state_26722__$1 = state_26722;
var statearr_26725_26752 = state_26722__$1;
(statearr_26725_26752[(2)] = null);

(statearr_26725_26752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (4))){
var inst_26667 = (state_26722[(2)]);
var state_26722__$1 = state_26722;
var statearr_26726_26753 = state_26722__$1;
(statearr_26726_26753[(2)] = inst_26667);

(statearr_26726_26753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (13))){
var inst_26715 = (state_26722[(2)]);
var state_26722__$1 = state_26722;
var statearr_26727_26754 = state_26722__$1;
(statearr_26727_26754[(2)] = inst_26715);

(statearr_26727_26754[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (6))){
var inst_26675 = fluree.db.util.core.random_uuid.call(null);
var state_26722__$1 = state_26722;
var statearr_26728_26755 = state_26722__$1;
(statearr_26728_26755[(2)] = inst_26675);

(statearr_26728_26755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (3))){
var inst_26720 = (state_26722[(2)]);
var state_26722__$1 = state_26722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26722__$1,inst_26720);
} else {
if((state_val_26723 === (12))){
var inst_26698 = (state_26722[(7)]);
var state_26722__$1 = state_26722;
var statearr_26729_26756 = state_26722__$1;
(statearr_26729_26756[(2)] = inst_26698);

(statearr_26729_26756[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (2))){
var _ = (function (){var statearr_26730 = state_26722;
(statearr_26730[(4)] = cljs.core.cons.call(null,(5),(state_26722[(4)])));

return statearr_26730;
})();
var inst_26673 = (tt_id == null);
var state_26722__$1 = state_26722;
if(cljs.core.truth_(inst_26673)){
var statearr_26731_26757 = state_26722__$1;
(statearr_26731_26757[(1)] = (6));

} else {
var statearr_26732_26758 = state_26722__$1;
(statearr_26732_26758[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (11))){
var inst_26698 = (state_26722[(7)]);
var inst_26705 = (state_26722[(8)]);
var inst_26708 = fluree.db.graphdb.with_t.call(null,inst_26698,inst_26705);
var state_26722__$1 = state_26722;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26722__$1,(14),inst_26708);
} else {
if((state_val_26723 === (9))){
var inst_26699 = (state_26722[(9)]);
var inst_26705 = (state_26722[(8)]);
var inst_26704 = cljs.core.seq.call(null,inst_26699);
var inst_26705__$1 = cljs.core.first.call(null,inst_26704);
var inst_26706 = cljs.core.next.call(null,inst_26704);
var state_26722__$1 = (function (){var statearr_26734 = state_26722;
(statearr_26734[(10)] = inst_26706);

(statearr_26734[(8)] = inst_26705__$1);

return statearr_26734;
})();
if(cljs.core.truth_(inst_26705__$1)){
var statearr_26735_26759 = state_26722__$1;
(statearr_26735_26759[(1)] = (11));

} else {
var statearr_26736_26760 = state_26722__$1;
(statearr_26736_26760[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (5))){
var _ = (function (){var statearr_26737 = state_26722;
(statearr_26737[(4)] = cljs.core.rest.call(null,(state_26722[(4)])));

return statearr_26737;
})();
var state_26722__$1 = state_26722;
var ex26733 = (state_26722__$1[(2)]);
var statearr_26738_26761 = state_26722__$1;
(statearr_26738_26761[(5)] = ex26733);


if((ex26733 instanceof Error)){
var statearr_26739_26762 = state_26722__$1;
(statearr_26739_26762[(1)] = (4));

(statearr_26739_26762[(5)] = null);

} else {
throw ex26733;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (14))){
var inst_26706 = (state_26722[(10)]);
var inst_26710 = (state_26722[(2)]);
var inst_26711 = fluree.db.util.async.throw_err.call(null,inst_26710);
var inst_26698 = inst_26711;
var inst_26699 = inst_26706;
var state_26722__$1 = (function (){var statearr_26740 = state_26722;
(statearr_26740[(7)] = inst_26698);

(statearr_26740[(9)] = inst_26699);

return statearr_26740;
})();
var statearr_26741_26763 = state_26722__$1;
(statearr_26741_26763[(2)] = null);

(statearr_26741_26763[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (10))){
var inst_26717 = (state_26722[(2)]);
var _ = (function (){var statearr_26742 = state_26722;
(statearr_26742[(4)] = cljs.core.rest.call(null,(state_26722[(4)])));

return statearr_26742;
})();
var state_26722__$1 = state_26722;
var statearr_26743_26764 = state_26722__$1;
(statearr_26743_26764[(2)] = inst_26717);

(statearr_26743_26764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26723 === (8))){
var inst_26678 = (state_26722[(2)]);
var inst_26679 = (function (){var tt_id_SINGLEQUOTE_ = inst_26678;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26680 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26678);
var inst_26681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26682 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26683 = (new cljs.core.PersistentVector(null,4,(5),inst_26681,inst_26682,null));
var inst_26684 = cljs.core.reduce.call(null,inst_26679,inst_26680,inst_26683);
var inst_26685 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26686 = cljs.core.reverse.call(null,inst_26685);
var inst_26687 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26686);
var inst_26695 = cljs.core.seq.call(null,inst_26687);
var inst_26696 = cljs.core.first.call(null,inst_26695);
var inst_26697 = cljs.core.next.call(null,inst_26695);
var inst_26698 = inst_26684;
var inst_26699 = inst_26687;
var state_26722__$1 = (function (){var statearr_26744 = state_26722;
(statearr_26744[(7)] = inst_26698);

(statearr_26744[(11)] = inst_26696);

(statearr_26744[(9)] = inst_26699);

(statearr_26744[(12)] = inst_26697);

return statearr_26744;
})();
var statearr_26745_26765 = state_26722__$1;
(statearr_26745_26765[(2)] = null);

(statearr_26745_26765[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto____0 = (function (){
var statearr_26746 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26746[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto__);

(statearr_26746[(1)] = (1));

return statearr_26746;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto____1 = (function (state_26722){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_26722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e26747){var ex__2729__auto__ = e26747;
var statearr_26748_26766 = state_26722;
(statearr_26748_26766[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_26722[(4)]))){
var statearr_26749_26767 = state_26722;
(statearr_26749_26767[(1)] = cljs.core.first.call(null,(state_26722[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26768 = state_26722;
state_26722 = G__26768;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto__ = function(state_26722){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto____1.call(this,state_26722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_26750 = f__2749__auto__.call(null);
(statearr_26750[(6)] = c__2748__auto__);

return statearr_26750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2748__auto___26955 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_26886){
var state_val_26887 = (state_26886[(1)]);
if((state_val_26887 === (7))){
var inst_26796 = (state_26886[(7)]);
var inst_26796__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26886__$1 = (function (){var statearr_26888 = state_26886;
(statearr_26888[(7)] = inst_26796__$1);

return statearr_26888;
})();
if(inst_26796__$1){
var statearr_26889_26956 = state_26886__$1;
(statearr_26889_26956[(1)] = (13));

} else {
var statearr_26890_26957 = state_26886__$1;
(statearr_26890_26957[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (20))){
var state_26886__$1 = state_26886;
var statearr_26891_26958 = state_26886__$1;
(statearr_26891_26958[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (27))){
var inst_26832 = (state_26886[(8)]);
var inst_26836 = inst_26832.s;
var state_26886__$1 = state_26886;
var statearr_26893_26959 = state_26886__$1;
(statearr_26893_26959[(2)] = inst_26836);

(statearr_26893_26959[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (1))){
var state_26886__$1 = state_26886;
var statearr_26894_26960 = state_26886__$1;
(statearr_26894_26960[(2)] = null);

(statearr_26894_26960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (24))){
var inst_26826 = (state_26886[(9)]);
var inst_26830 = cljs.core.first.call(null,inst_26826);
var state_26886__$1 = state_26886;
var statearr_26895_26961 = state_26886__$1;
(statearr_26895_26961[(2)] = inst_26830);

(statearr_26895_26961[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (39))){
var state_26886__$1 = state_26886;
var statearr_26896_26962 = state_26886__$1;
(statearr_26896_26962[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (4))){
var inst_26769 = (state_26886[(2)]);
var inst_26770 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26771 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26772 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26773 = cljs.core.PersistentHashMap.fromArrays(inst_26771,inst_26772);
var inst_26774 = cljs.core.ex_info.call(null,inst_26770,inst_26773,inst_26769);
var inst_26775 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26774);
var state_26886__$1 = state_26886;
var statearr_26898_26963 = state_26886__$1;
(statearr_26898_26963[(2)] = inst_26775);

(statearr_26898_26963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (15))){
var inst_26803 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
if(cljs.core.truth_(inst_26803)){
var statearr_26899_26964 = state_26886__$1;
(statearr_26899_26964[(1)] = (16));

} else {
var statearr_26900_26965 = state_26886__$1;
(statearr_26900_26965[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (21))){
var inst_26852 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26901_26966 = state_26886__$1;
(statearr_26901_26966[(2)] = inst_26852);

(statearr_26901_26966[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (31))){
var inst_26850 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26902_26967 = state_26886__$1;
(statearr_26902_26967[(2)] = inst_26850);

(statearr_26902_26967[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (32))){
var inst_26856 = (state_26886[(10)]);
var inst_26858 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26856);
var state_26886__$1 = state_26886;
var statearr_26903_26968 = state_26886__$1;
(statearr_26903_26968[(2)] = inst_26858);

(statearr_26903_26968[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (40))){
var inst_26879 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26904_26969 = state_26886__$1;
(statearr_26904_26969[(2)] = inst_26879);

(statearr_26904_26969[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (33))){
var inst_26860 = (state_26886[(11)]);
var inst_26856 = (state_26886[(10)]);
var inst_26860__$1 = (inst_26856 == null);
var state_26886__$1 = (function (){var statearr_26905 = state_26886;
(statearr_26905[(11)] = inst_26860__$1);

return statearr_26905;
})();
if(cljs.core.truth_(inst_26860__$1)){
var statearr_26906_26970 = state_26886__$1;
(statearr_26906_26970[(1)] = (35));

} else {
var statearr_26907_26971 = state_26886__$1;
(statearr_26907_26971[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (13))){
var inst_26798 = cljs.core.first.call(null,ident);
var inst_26799 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26798);
var inst_26800 = (inst_26799 == null);
var state_26886__$1 = state_26886;
var statearr_26908_26972 = state_26886__$1;
(statearr_26908_26972[(2)] = inst_26800);

(statearr_26908_26972[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (22))){
var inst_26826 = (state_26886[(9)]);
var inst_26825 = (state_26886[(2)]);
var inst_26826__$1 = fluree.db.util.async.throw_err.call(null,inst_26825);
var inst_26827 = (inst_26826__$1 == null);
var state_26886__$1 = (function (){var statearr_26909 = state_26886;
(statearr_26909[(9)] = inst_26826__$1);

return statearr_26909;
})();
if(cljs.core.truth_(inst_26827)){
var statearr_26910_26973 = state_26886__$1;
(statearr_26910_26973[(1)] = (23));

} else {
var statearr_26911_26974 = state_26886__$1;
(statearr_26911_26974[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (36))){
var inst_26860 = (state_26886[(11)]);
var state_26886__$1 = state_26886;
var statearr_26912_26975 = state_26886__$1;
(statearr_26912_26975[(2)] = inst_26860);

(statearr_26912_26975[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (41))){
var inst_26874 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_26886__$1 = state_26886;
var statearr_26913_26976 = state_26886__$1;
(statearr_26913_26976[(2)] = inst_26874);

(statearr_26913_26976[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (43))){
var inst_26877 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26914_26977 = state_26886__$1;
(statearr_26914_26977[(2)] = inst_26877);

(statearr_26914_26977[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (29))){
var inst_26841 = cljs.core.pr_str.call(null,ident);
var inst_26842 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26841].join('');
var inst_26843 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26844 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26845 = cljs.core.PersistentHashMap.fromArrays(inst_26843,inst_26844);
var inst_26846 = cljs.core.ex_info.call(null,inst_26842,inst_26845);
var inst_26847 = (function(){throw inst_26846})();
var state_26886__$1 = state_26886;
var statearr_26915_26978 = state_26886__$1;
(statearr_26915_26978[(2)] = inst_26847);

(statearr_26915_26978[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (6))){
var inst_26783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26784 = [ident];
var inst_26785 = (new cljs.core.PersistentVector(null,1,(5),inst_26783,inst_26784,null));
var inst_26786 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26785);
var state_26886__$1 = state_26886;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26886__$1,(9),inst_26786);
} else {
if((state_val_26887 === (28))){
var inst_26838 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26916_26979 = state_26886__$1;
(statearr_26916_26979[(2)] = inst_26838);

(statearr_26916_26979[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (25))){
var inst_26832 = (state_26886[(8)]);
var inst_26832__$1 = (state_26886[(2)]);
var inst_26833 = (inst_26832__$1 == null);
var state_26886__$1 = (function (){var statearr_26917 = state_26886;
(statearr_26917[(8)] = inst_26832__$1);

return statearr_26917;
})();
if(cljs.core.truth_(inst_26833)){
var statearr_26918_26980 = state_26886__$1;
(statearr_26918_26980[(1)] = (26));

} else {
var statearr_26919_26981 = state_26886__$1;
(statearr_26919_26981[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (34))){
var inst_26881 = (state_26886[(2)]);
var _ = (function (){var statearr_26920 = state_26886;
(statearr_26920[(4)] = cljs.core.rest.call(null,(state_26886[(4)])));

return statearr_26920;
})();
var state_26886__$1 = state_26886;
var statearr_26921_26982 = state_26886__$1;
(statearr_26921_26982[(2)] = inst_26881);

(statearr_26921_26982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (17))){
var inst_26814 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_26886__$1 = state_26886;
if(inst_26814){
var statearr_26922_26983 = state_26886__$1;
(statearr_26922_26983[(1)] = (19));

} else {
var statearr_26923_26984 = state_26886__$1;
(statearr_26923_26984[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (3))){
var inst_26884 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26886__$1,inst_26884);
} else {
if((state_val_26887 === (12))){
var inst_26794 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26924_26985 = state_26886__$1;
(statearr_26924_26985[(2)] = inst_26794);

(statearr_26924_26985[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (2))){
var _ = (function (){var statearr_26925 = state_26886;
(statearr_26925[(4)] = cljs.core.cons.call(null,(5),(state_26886[(4)])));

return statearr_26925;
})();
var inst_26781 = typeof ident === 'number';
var state_26886__$1 = state_26886;
if(cljs.core.truth_(inst_26781)){
var statearr_26926_26986 = state_26886__$1;
(statearr_26926_26986[(1)] = (6));

} else {
var statearr_26927_26987 = state_26886__$1;
(statearr_26927_26987[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (23))){
var state_26886__$1 = state_26886;
var statearr_26928_26988 = state_26886__$1;
(statearr_26928_26988[(2)] = null);

(statearr_26928_26988[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (35))){
var state_26886__$1 = state_26886;
var statearr_26929_26989 = state_26886__$1;
(statearr_26929_26989[(2)] = strict_QMARK_);

(statearr_26929_26989[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (19))){
var inst_26817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26818 = cljs.core.first.call(null,ident);
var inst_26819 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26818);
var inst_26820 = cljs.core.second.call(null,ident);
var inst_26821 = [inst_26819,inst_26820];
var inst_26822 = (new cljs.core.PersistentVector(null,2,(5),inst_26817,inst_26821,null));
var inst_26823 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26822);
var state_26886__$1 = state_26886;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26886__$1,(22),inst_26823);
} else {
if((state_val_26887 === (11))){
var state_26886__$1 = state_26886;
var statearr_26931_26990 = state_26886__$1;
(statearr_26931_26990[(2)] = null);

(statearr_26931_26990[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (9))){
var inst_26788 = (state_26886[(2)]);
var inst_26789 = fluree.db.util.async.throw_err.call(null,inst_26788);
var inst_26790 = cljs.core.not_empty.call(null,inst_26789);
var state_26886__$1 = state_26886;
if(cljs.core.truth_(inst_26790)){
var statearr_26932_26991 = state_26886__$1;
(statearr_26932_26991[(1)] = (10));

} else {
var statearr_26933_26992 = state_26886__$1;
(statearr_26933_26992[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (5))){
var _ = (function (){var statearr_26934 = state_26886;
(statearr_26934[(4)] = cljs.core.rest.call(null,(state_26886[(4)])));

return statearr_26934;
})();
var state_26886__$1 = state_26886;
var ex26930 = (state_26886__$1[(2)]);
var statearr_26935_26993 = state_26886__$1;
(statearr_26935_26993[(5)] = ex26930);


var statearr_26936_26994 = state_26886__$1;
(statearr_26936_26994[(1)] = (4));

(statearr_26936_26994[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (14))){
var inst_26796 = (state_26886[(7)]);
var state_26886__$1 = state_26886;
var statearr_26937_26995 = state_26886__$1;
(statearr_26937_26995[(2)] = inst_26796);

(statearr_26937_26995[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (26))){
var state_26886__$1 = state_26886;
var statearr_26938_26996 = state_26886__$1;
(statearr_26938_26996[(2)] = null);

(statearr_26938_26996[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (16))){
var inst_26805 = cljs.core.first.call(null,ident);
var inst_26806 = cljs.core.pr_str.call(null,inst_26805);
var inst_26807 = ["Subject ID lookup failed. The predicate ",inst_26806," does not exist."].join('');
var inst_26808 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26809 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26810 = cljs.core.PersistentHashMap.fromArrays(inst_26808,inst_26809);
var inst_26811 = cljs.core.ex_info.call(null,inst_26807,inst_26810);
var inst_26812 = (function(){throw inst_26811})();
var state_26886__$1 = state_26886;
var statearr_26939_26997 = state_26886__$1;
(statearr_26939_26997[(2)] = inst_26812);

(statearr_26939_26997[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (38))){
var inst_26866 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26867 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26868 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26869 = cljs.core.PersistentHashMap.fromArrays(inst_26867,inst_26868);
var inst_26870 = cljs.core.ex_info.call(null,inst_26866,inst_26869);
var inst_26871 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26870);
var state_26886__$1 = state_26886;
var statearr_26940_26998 = state_26886__$1;
(statearr_26940_26998[(2)] = inst_26871);

(statearr_26940_26998[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (30))){
var state_26886__$1 = state_26886;
var statearr_26941_26999 = state_26886__$1;
(statearr_26941_26999[(2)] = null);

(statearr_26941_26999[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (10))){
var state_26886__$1 = state_26886;
var statearr_26942_27000 = state_26886__$1;
(statearr_26942_27000[(2)] = ident);

(statearr_26942_27000[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (18))){
var inst_26854 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26943_27001 = state_26886__$1;
(statearr_26943_27001[(2)] = inst_26854);

(statearr_26943_27001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (42))){
var state_26886__$1 = state_26886;
var statearr_26944_27002 = state_26886__$1;
(statearr_26944_27002[(2)] = null);

(statearr_26944_27002[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (37))){
var inst_26864 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
if(cljs.core.truth_(inst_26864)){
var statearr_26945_27003 = state_26886__$1;
(statearr_26945_27003[(1)] = (38));

} else {
var statearr_26946_27004 = state_26886__$1;
(statearr_26946_27004[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (8))){
var inst_26856 = (state_26886[(10)]);
var inst_26856__$1 = (state_26886[(2)]);
var state_26886__$1 = (function (){var statearr_26947 = state_26886;
(statearr_26947[(10)] = inst_26856__$1);

return statearr_26947;
})();
if(cljs.core.truth_(inst_26856__$1)){
var statearr_26948_27005 = state_26886__$1;
(statearr_26948_27005[(1)] = (32));

} else {
var statearr_26949_27006 = state_26886__$1;
(statearr_26949_27006[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2726__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2726__auto____0 = (function (){
var statearr_26950 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26950[(0)] = fluree$db$graphdb$subid_$_state_machine__2726__auto__);

(statearr_26950[(1)] = (1));

return statearr_26950;
});
var fluree$db$graphdb$subid_$_state_machine__2726__auto____1 = (function (state_26886){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_26886);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e26951){var ex__2729__auto__ = e26951;
var statearr_26952_27007 = state_26886;
(statearr_26952_27007[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_26886[(4)]))){
var statearr_26953_27008 = state_26886;
(statearr_26953_27008[(1)] = cljs.core.first.call(null,(state_26886[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27009 = state_26886;
state_26886 = G__27009;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2726__auto__ = function(state_26886){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2726__auto____1.call(this,state_26886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2726__auto____0;
fluree$db$graphdb$subid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2726__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_26954 = f__2749__auto__.call(null);
(statearr_26954[(6)] = c__2748__auto___26955);

return statearr_26954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k27011,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__27015 = k27011;
var G__27015__$1 = (((G__27015 instanceof cljs.core.Keyword))?G__27015.fqn:null);
switch (G__27015__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27011,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4495__auto__,p__27016){
var vec__27017 = p__27016;
var k__4496__auto__ = cljs.core.nth.call(null,vec__27017,(0),null);
var v__4497__auto__ = cljs.core.nth.call(null,vec__27017,(1),null);
return f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__);
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27010){
var self__ = this;
var G__27010__$1 = this;
return (new cljs.core.RecordIter((0),G__27010__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4469__auto__));
}).call(null,this__4468__auto____$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27012,other27013){
var self__ = this;
var this27012__$1 = this;
return (((!((other27013 == null)))) && ((((this27012__$1.constructor === other27013.constructor)) && (((cljs.core._EQ_.call(null,this27012__$1.conn,other27013.conn)) && (((cljs.core._EQ_.call(null,this27012__$1.network,other27013.network)) && (((cljs.core._EQ_.call(null,this27012__$1.dbid,other27013.dbid)) && (((cljs.core._EQ_.call(null,this27012__$1.block,other27013.block)) && (((cljs.core._EQ_.call(null,this27012__$1.t,other27013.t)) && (((cljs.core._EQ_.call(null,this27012__$1.tt_id,other27013.tt_id)) && (((cljs.core._EQ_.call(null,this27012__$1.stats,other27013.stats)) && (((cljs.core._EQ_.call(null,this27012__$1.spot,other27013.spot)) && (((cljs.core._EQ_.call(null,this27012__$1.psot,other27013.psot)) && (((cljs.core._EQ_.call(null,this27012__$1.post,other27013.post)) && (((cljs.core._EQ_.call(null,this27012__$1.opst,other27013.opst)) && (((cljs.core._EQ_.call(null,this27012__$1.schema,other27013.schema)) && (((cljs.core._EQ_.call(null,this27012__$1.settings,other27013.settings)) && (((cljs.core._EQ_.call(null,this27012__$1.index_configs,other27013.index_configs)) && (((cljs.core._EQ_.call(null,this27012__$1.schema_cache,other27013.schema_cache)) && (((cljs.core._EQ_.call(null,this27012__$1.novelty,other27013.novelty)) && (((cljs.core._EQ_.call(null,this27012__$1.permissions,other27013.permissions)) && (((cljs.core._EQ_.call(null,this27012__$1.fork,other27013.fork)) && (((cljs.core._EQ_.call(null,this27012__$1.fork_block,other27013.fork_block)) && (((cljs.core._EQ_.call(null,this27012__$1.current_db_fn,other27013.current_db_fn)) && (cljs.core._EQ_.call(null,this27012__$1.__extmap,other27013.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k27011){
var self__ = this;
var this__4479__auto____$1 = this;
var G__27020 = k27011;
var G__27020__$1 = (((G__27020 instanceof cljs.core.Keyword))?G__27020.fqn:null);
switch (G__27020__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27011);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__27010){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__27021 = cljs.core.keyword_identical_QMARK_;
var expr__27022 = k__4481__auto__;
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27022))){
return (new fluree.db.graphdb.GraphDb(G__27010,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27010,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27010,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27010,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27010,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27010,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27010,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27010,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27010,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27010,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27010,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27010,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27010,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27010,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27010,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27010,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27010,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27010,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27010,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27021.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27022))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27010,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4481__auto__,G__27010),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__27010){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27010,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4478__auto__,(0)),cljs.core._nth.call(null,entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27039){
var state_val_27040 = (state_27039[(1)]);
if((state_val_27040 === (1))){
var state_27039__$1 = state_27039;
var statearr_27041_27306 = state_27039__$1;
(statearr_27041_27306[(2)] = null);

(statearr_27041_27306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27040 === (2))){
var _ = (function (){var statearr_27042 = state_27039;
(statearr_27042[(4)] = cljs.core.cons.call(null,(5),(state_27039[(4)])));

return statearr_27042;
})();
var inst_27030 = self__.current_db_fn.call(null);
var state_27039__$1 = state_27039;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27039__$1,(6),inst_27030);
} else {
if((state_val_27040 === (3))){
var inst_27037 = (state_27039[(2)]);
var state_27039__$1 = state_27039;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27039__$1,inst_27037);
} else {
if((state_val_27040 === (4))){
var inst_27024 = (state_27039[(2)]);
var state_27039__$1 = state_27039;
var statearr_27044_27307 = state_27039__$1;
(statearr_27044_27307[(2)] = inst_27024);

(statearr_27044_27307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27040 === (5))){
var _ = (function (){var statearr_27045 = state_27039;
(statearr_27045[(4)] = cljs.core.rest.call(null,(state_27039[(4)])));

return statearr_27045;
})();
var state_27039__$1 = state_27039;
var ex27043 = (state_27039__$1[(2)]);
var statearr_27046_27308 = state_27039__$1;
(statearr_27046_27308[(5)] = ex27043);


if((ex27043 instanceof Error)){
var statearr_27047_27309 = state_27039__$1;
(statearr_27047_27309[(1)] = (4));

(statearr_27047_27309[(5)] = null);

} else {
throw ex27043;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27040 === (6))){
var inst_27032 = (state_27039[(2)]);
var inst_27033 = fluree.db.util.async.throw_err.call(null,inst_27032);
var inst_27034 = cljs.core.assoc.call(null,inst_27033,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_27048 = state_27039;
(statearr_27048[(4)] = cljs.core.rest.call(null,(state_27039[(4)])));

return statearr_27048;
})();
var state_27039__$1 = state_27039;
var statearr_27049_27310 = state_27039__$1;
(statearr_27049_27310[(2)] = inst_27034);

(statearr_27049_27310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2726__auto__ = null;
var fluree$db$graphdb$state_machine__2726__auto____0 = (function (){
var statearr_27050 = [null,null,null,null,null,null,null];
(statearr_27050[(0)] = fluree$db$graphdb$state_machine__2726__auto__);

(statearr_27050[(1)] = (1));

return statearr_27050;
});
var fluree$db$graphdb$state_machine__2726__auto____1 = (function (state_27039){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27039);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27051){var ex__2729__auto__ = e27051;
var statearr_27052_27311 = state_27039;
(statearr_27052_27311[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27039[(4)]))){
var statearr_27053_27312 = state_27039;
(statearr_27053_27312[(1)] = cljs.core.first.call(null,(state_27039[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27313 = state_27039;
state_27039 = G__27313;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2726__auto__ = function(state_27039){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2726__auto____1.call(this,state_27039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2726__auto____0;
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2726__auto____1;
return fluree$db$graphdb$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27054 = f__2749__auto__.call(null);
(statearr_27054[(6)] = c__2748__auto__);

return statearr_27054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27055 = cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27055);
} else {
return G__27055;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27087){
var state_val_27088 = (state_27087[(1)]);
if((state_val_27088 === (7))){
var state_27087__$1 = state_27087;
var statearr_27089_27314 = state_27087__$1;
(statearr_27089_27314[(2)] = null);

(statearr_27089_27314[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (1))){
var state_27087__$1 = state_27087;
var statearr_27090_27315 = state_27087__$1;
(statearr_27090_27315[(2)] = null);

(statearr_27090_27315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (4))){
var inst_27056 = (state_27087[(2)]);
var state_27087__$1 = state_27087;
var statearr_27091_27316 = state_27087__$1;
(statearr_27091_27316[(2)] = inst_27056);

(statearr_27091_27316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (6))){
var inst_27070 = (state_27087[(7)]);
var inst_27069 = (state_27087[(2)]);
var inst_27070__$1 = fluree.db.util.async.throw_err.call(null,inst_27069);
var inst_27071 = (inst_27070__$1 == null);
var state_27087__$1 = (function (){var statearr_27092 = state_27087;
(statearr_27092[(7)] = inst_27070__$1);

return statearr_27092;
})();
if(cljs.core.truth_(inst_27071)){
var statearr_27093_27317 = state_27087__$1;
(statearr_27093_27317[(1)] = (7));

} else {
var statearr_27094_27318 = state_27087__$1;
(statearr_27094_27318[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (3))){
var inst_27085 = (state_27087[(2)]);
var state_27087__$1 = state_27087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27087__$1,inst_27085);
} else {
if((state_val_27088 === (12))){
var inst_27082 = (state_27087[(2)]);
var _ = (function (){var statearr_27095 = state_27087;
(statearr_27095[(4)] = cljs.core.rest.call(null,(state_27087[(4)])));

return statearr_27095;
})();
var state_27087__$1 = state_27087;
var statearr_27096_27319 = state_27087__$1;
(statearr_27096_27319[(2)] = inst_27082);

(statearr_27096_27319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (2))){
var _ = (function (){var statearr_27097 = state_27087;
(statearr_27097[(4)] = cljs.core.cons.call(null,(5),(state_27087[(4)])));

return statearr_27097;
})();
var inst_27063 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_27064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27065 = [tag_id,(30)];
var inst_27066 = (new cljs.core.PersistentVector(null,2,(5),inst_27064,inst_27065,null));
var inst_27067 = fluree.db.query.range.index_range.call(null,inst_27063,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27066);
var state_27087__$1 = state_27087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27087__$1,(6),inst_27067);
} else {
if((state_val_27088 === (11))){
var inst_27076 = (state_27087[(8)]);
var inst_27080 = inst_27076.o;
var state_27087__$1 = state_27087;
var statearr_27099_27320 = state_27087__$1;
(statearr_27099_27320[(2)] = inst_27080);

(statearr_27099_27320[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (9))){
var inst_27076 = (state_27087[(8)]);
var inst_27076__$1 = (state_27087[(2)]);
var inst_27077 = (inst_27076__$1 == null);
var state_27087__$1 = (function (){var statearr_27100 = state_27087;
(statearr_27100[(8)] = inst_27076__$1);

return statearr_27100;
})();
if(cljs.core.truth_(inst_27077)){
var statearr_27101_27321 = state_27087__$1;
(statearr_27101_27321[(1)] = (10));

} else {
var statearr_27102_27322 = state_27087__$1;
(statearr_27102_27322[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (5))){
var _ = (function (){var statearr_27103 = state_27087;
(statearr_27103[(4)] = cljs.core.rest.call(null,(state_27087[(4)])));

return statearr_27103;
})();
var state_27087__$1 = state_27087;
var ex27098 = (state_27087__$1[(2)]);
var statearr_27104_27323 = state_27087__$1;
(statearr_27104_27323[(5)] = ex27098);


if((ex27098 instanceof Error)){
var statearr_27105_27324 = state_27087__$1;
(statearr_27105_27324[(1)] = (4));

(statearr_27105_27324[(5)] = null);

} else {
throw ex27098;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (10))){
var state_27087__$1 = state_27087;
var statearr_27106_27325 = state_27087__$1;
(statearr_27106_27325[(2)] = null);

(statearr_27106_27325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27088 === (8))){
var inst_27070 = (state_27087[(7)]);
var inst_27074 = cljs.core.first.call(null,inst_27070);
var state_27087__$1 = state_27087;
var statearr_27107_27326 = state_27087__$1;
(statearr_27107_27326[(2)] = inst_27074);

(statearr_27107_27326[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2726__auto__ = null;
var fluree$db$graphdb$state_machine__2726__auto____0 = (function (){
var statearr_27108 = [null,null,null,null,null,null,null,null,null];
(statearr_27108[(0)] = fluree$db$graphdb$state_machine__2726__auto__);

(statearr_27108[(1)] = (1));

return statearr_27108;
});
var fluree$db$graphdb$state_machine__2726__auto____1 = (function (state_27087){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27109){var ex__2729__auto__ = e27109;
var statearr_27110_27327 = state_27087;
(statearr_27110_27327[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27087[(4)]))){
var statearr_27111_27328 = state_27087;
(statearr_27111_27328[(1)] = cljs.core.first.call(null,(state_27087[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27329 = state_27087;
state_27087 = G__27329;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2726__auto__ = function(state_27087){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2726__auto____1.call(this,state_27087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2726__auto____0;
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2726__auto____1;
return fluree$db$graphdb$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27112 = f__2749__auto__.call(null);
(statearr_27112[(6)] = c__2748__auto__);

return statearr_27112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27148){
var state_val_27149 = (state_27148[(1)]);
if((state_val_27149 === (7))){
var inst_27122 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27148__$1 = state_27148;
var statearr_27150_27330 = state_27148__$1;
(statearr_27150_27330[(2)] = inst_27122);

(statearr_27150_27330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (1))){
var state_27148__$1 = state_27148;
var statearr_27151_27331 = state_27148__$1;
(statearr_27151_27331[(2)] = null);

(statearr_27151_27331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (4))){
var inst_27113 = (state_27148[(2)]);
var state_27148__$1 = state_27148;
var statearr_27152_27332 = state_27148__$1;
(statearr_27152_27332[(2)] = inst_27113);

(statearr_27152_27332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (15))){
var inst_27143 = (state_27148[(2)]);
var _ = (function (){var statearr_27153 = state_27148;
(statearr_27153[(4)] = cljs.core.rest.call(null,(state_27148[(4)])));

return statearr_27153;
})();
var state_27148__$1 = state_27148;
var statearr_27154_27333 = state_27148__$1;
(statearr_27154_27333[(2)] = inst_27143);

(statearr_27154_27333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (13))){
var inst_27128 = (state_27148[(7)]);
var inst_27134 = clojure.string.includes_QMARK_.call(null,inst_27128,":");
var state_27148__$1 = state_27148;
if(inst_27134){
var statearr_27155_27334 = state_27148__$1;
(statearr_27155_27334[(1)] = (16));

} else {
var statearr_27156_27335 = state_27148__$1;
(statearr_27156_27335[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (6))){
var state_27148__$1 = state_27148;
var statearr_27157_27336 = state_27148__$1;
(statearr_27157_27336[(2)] = pred);

(statearr_27157_27336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (17))){
var inst_27128 = (state_27148[(7)]);
var state_27148__$1 = state_27148;
var statearr_27158_27337 = state_27148__$1;
(statearr_27158_27337[(2)] = inst_27128);

(statearr_27158_27337[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (3))){
var inst_27146 = (state_27148[(2)]);
var state_27148__$1 = state_27148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27148__$1,inst_27146);
} else {
if((state_val_27149 === (12))){
var inst_27132 = (state_27148[(2)]);
var state_27148__$1 = state_27148;
if(cljs.core.truth_(inst_27132)){
var statearr_27159_27338 = state_27148__$1;
(statearr_27159_27338[(1)] = (13));

} else {
var statearr_27160_27339 = state_27148__$1;
(statearr_27160_27339[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (2))){
var _ = (function (){var statearr_27161 = state_27148;
(statearr_27161[(4)] = cljs.core.cons.call(null,(5),(state_27148[(4)])));

return statearr_27161;
})();
var inst_27119 = typeof pred === 'string';
var state_27148__$1 = state_27148;
if(cljs.core.truth_(inst_27119)){
var statearr_27162_27340 = state_27148__$1;
(statearr_27162_27340[(1)] = (6));

} else {
var statearr_27163_27341 = state_27148__$1;
(statearr_27163_27341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (11))){
var inst_27124 = (state_27148[(8)]);
var state_27148__$1 = state_27148;
var statearr_27165_27342 = state_27148__$1;
(statearr_27165_27342[(2)] = inst_27124);

(statearr_27165_27342[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (9))){
var inst_27124 = (state_27148[(8)]);
var inst_27127 = (state_27148[(2)]);
var inst_27128 = fluree.db.util.async.throw_err.call(null,inst_27127);
var state_27148__$1 = (function (){var statearr_27166 = state_27148;
(statearr_27166[(7)] = inst_27128);

return statearr_27166;
})();
if(cljs.core.truth_(inst_27124)){
var statearr_27167_27343 = state_27148__$1;
(statearr_27167_27343[(1)] = (10));

} else {
var statearr_27168_27344 = state_27148__$1;
(statearr_27168_27344[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (5))){
var _ = (function (){var statearr_27169 = state_27148;
(statearr_27169[(4)] = cljs.core.rest.call(null,(state_27148[(4)])));

return statearr_27169;
})();
var state_27148__$1 = state_27148;
var ex27164 = (state_27148__$1[(2)]);
var statearr_27170_27345 = state_27148__$1;
(statearr_27170_27345[(5)] = ex27164);


if((ex27164 instanceof Error)){
var statearr_27171_27346 = state_27148__$1;
(statearr_27171_27346[(1)] = (4));

(statearr_27171_27346[(5)] = null);

} else {
throw ex27164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (14))){
var state_27148__$1 = state_27148;
var statearr_27172_27347 = state_27148__$1;
(statearr_27172_27347[(2)] = null);

(statearr_27172_27347[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (16))){
var inst_27128 = (state_27148[(7)]);
var inst_27136 = clojure.string.split.call(null,inst_27128,/:/);
var inst_27137 = cljs.core.second.call(null,inst_27136);
var state_27148__$1 = state_27148;
var statearr_27173_27348 = state_27148__$1;
(statearr_27173_27348[(2)] = inst_27137);

(statearr_27173_27348[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (10))){
var inst_27128 = (state_27148[(7)]);
var state_27148__$1 = state_27148;
var statearr_27174_27349 = state_27148__$1;
(statearr_27174_27349[(2)] = inst_27128);

(statearr_27174_27349[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (18))){
var inst_27140 = (state_27148[(2)]);
var state_27148__$1 = state_27148;
var statearr_27175_27350 = state_27148__$1;
(statearr_27175_27350[(2)] = inst_27140);

(statearr_27175_27350[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27149 === (8))){
var inst_27124 = (state_27148[(2)]);
var inst_27125 = fluree.db.dbproto._tag.call(null,this$__$1,tag_id);
var state_27148__$1 = (function (){var statearr_27176 = state_27148;
(statearr_27176[(8)] = inst_27124);

return statearr_27176;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27148__$1,(9),inst_27125);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2726__auto__ = null;
var fluree$db$graphdb$state_machine__2726__auto____0 = (function (){
var statearr_27177 = [null,null,null,null,null,null,null,null,null];
(statearr_27177[(0)] = fluree$db$graphdb$state_machine__2726__auto__);

(statearr_27177[(1)] = (1));

return statearr_27177;
});
var fluree$db$graphdb$state_machine__2726__auto____1 = (function (state_27148){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27178){var ex__2729__auto__ = e27178;
var statearr_27179_27351 = state_27148;
(statearr_27179_27351[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27148[(4)]))){
var statearr_27180_27352 = state_27148;
(statearr_27180_27352[(1)] = cljs.core.first.call(null,(state_27148[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27353 = state_27148;
state_27148 = G__27353;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2726__auto__ = function(state_27148){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2726__auto____1.call(this,state_27148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2726__auto____0;
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2726__auto____1;
return fluree$db$graphdb$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27181 = f__2749__auto__.call(null);
(statearr_27181[(6)] = c__2748__auto__);

return statearr_27181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27214){
var state_val_27215 = (state_27214[(1)]);
if((state_val_27215 === (7))){
var state_27214__$1 = state_27214;
var statearr_27216_27354 = state_27214__$1;
(statearr_27216_27354[(2)] = null);

(statearr_27216_27354[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (1))){
var state_27214__$1 = state_27214;
var statearr_27217_27355 = state_27214__$1;
(statearr_27217_27355[(2)] = null);

(statearr_27217_27355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (4))){
var inst_27182 = (state_27214[(2)]);
var state_27214__$1 = state_27214;
var statearr_27218_27356 = state_27214__$1;
(statearr_27218_27356[(2)] = inst_27182);

(statearr_27218_27356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (6))){
var inst_27197 = (state_27214[(7)]);
var inst_27196 = (state_27214[(2)]);
var inst_27197__$1 = fluree.db.util.async.throw_err.call(null,inst_27196);
var inst_27198 = (inst_27197__$1 == null);
var state_27214__$1 = (function (){var statearr_27219 = state_27214;
(statearr_27219[(7)] = inst_27197__$1);

return statearr_27219;
})();
if(cljs.core.truth_(inst_27198)){
var statearr_27220_27357 = state_27214__$1;
(statearr_27220_27357[(1)] = (7));

} else {
var statearr_27221_27358 = state_27214__$1;
(statearr_27221_27358[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (3))){
var inst_27212 = (state_27214[(2)]);
var state_27214__$1 = state_27214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27214__$1,inst_27212);
} else {
if((state_val_27215 === (12))){
var inst_27209 = (state_27214[(2)]);
var _ = (function (){var statearr_27222 = state_27214;
(statearr_27222[(4)] = cljs.core.rest.call(null,(state_27214[(4)])));

return statearr_27222;
})();
var state_27214__$1 = state_27214;
var statearr_27223_27359 = state_27214__$1;
(statearr_27223_27359[(2)] = inst_27209);

(statearr_27223_27359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (2))){
var _ = (function (){var statearr_27224 = state_27214;
(statearr_27224[(4)] = cljs.core.cons.call(null,(5),(state_27214[(4)])));

return statearr_27224;
})();
var inst_27188 = (30);
var inst_27190 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_27191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27192 = [inst_27188,tag_name];
var inst_27193 = (new cljs.core.PersistentVector(null,2,(5),inst_27191,inst_27192,null));
var inst_27194 = fluree.db.query.range.index_range.call(null,inst_27190,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27193);
var state_27214__$1 = state_27214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27214__$1,(6),inst_27194);
} else {
if((state_val_27215 === (11))){
var inst_27203 = (state_27214[(8)]);
var inst_27207 = inst_27203.s;
var state_27214__$1 = state_27214;
var statearr_27226_27360 = state_27214__$1;
(statearr_27226_27360[(2)] = inst_27207);

(statearr_27226_27360[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (9))){
var inst_27203 = (state_27214[(8)]);
var inst_27203__$1 = (state_27214[(2)]);
var inst_27204 = (inst_27203__$1 == null);
var state_27214__$1 = (function (){var statearr_27227 = state_27214;
(statearr_27227[(8)] = inst_27203__$1);

return statearr_27227;
})();
if(cljs.core.truth_(inst_27204)){
var statearr_27228_27361 = state_27214__$1;
(statearr_27228_27361[(1)] = (10));

} else {
var statearr_27229_27362 = state_27214__$1;
(statearr_27229_27362[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (5))){
var _ = (function (){var statearr_27230 = state_27214;
(statearr_27230[(4)] = cljs.core.rest.call(null,(state_27214[(4)])));

return statearr_27230;
})();
var state_27214__$1 = state_27214;
var ex27225 = (state_27214__$1[(2)]);
var statearr_27231_27363 = state_27214__$1;
(statearr_27231_27363[(5)] = ex27225);


if((ex27225 instanceof Error)){
var statearr_27232_27364 = state_27214__$1;
(statearr_27232_27364[(1)] = (4));

(statearr_27232_27364[(5)] = null);

} else {
throw ex27225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (10))){
var state_27214__$1 = state_27214;
var statearr_27233_27365 = state_27214__$1;
(statearr_27233_27365[(2)] = null);

(statearr_27233_27365[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (8))){
var inst_27197 = (state_27214[(7)]);
var inst_27201 = cljs.core.first.call(null,inst_27197);
var state_27214__$1 = state_27214;
var statearr_27234_27366 = state_27214__$1;
(statearr_27234_27366[(2)] = inst_27201);

(statearr_27234_27366[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2726__auto__ = null;
var fluree$db$graphdb$state_machine__2726__auto____0 = (function (){
var statearr_27235 = [null,null,null,null,null,null,null,null,null];
(statearr_27235[(0)] = fluree$db$graphdb$state_machine__2726__auto__);

(statearr_27235[(1)] = (1));

return statearr_27235;
});
var fluree$db$graphdb$state_machine__2726__auto____1 = (function (state_27214){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27236){var ex__2729__auto__ = e27236;
var statearr_27237_27367 = state_27214;
(statearr_27237_27367[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27214[(4)]))){
var statearr_27238_27368 = state_27214;
(statearr_27238_27368[(1)] = cljs.core.first.call(null,(state_27214[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27369 = state_27214;
state_27214 = G__27369;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2726__auto__ = function(state_27214){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2726__auto____1.call(this,state_27214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2726__auto____0;
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2726__auto____1;
return fluree$db$graphdb$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27239 = f__2749__auto__.call(null);
(statearr_27239[(6)] = c__2748__auto__);

return statearr_27239;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27274){
var state_val_27275 = (state_27274[(1)]);
if((state_val_27275 === (7))){
var inst_27253 = typeof pred === 'string';
var state_27274__$1 = state_27274;
if(cljs.core.truth_(inst_27253)){
var statearr_27276_27370 = state_27274__$1;
(statearr_27276_27370[(1)] = (10));

} else {
var statearr_27277_27371 = state_27274__$1;
(statearr_27277_27371[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (1))){
var state_27274__$1 = state_27274;
var statearr_27278_27372 = state_27274__$1;
(statearr_27278_27372[(2)] = null);

(statearr_27278_27372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (4))){
var inst_27240 = (state_27274[(2)]);
var state_27274__$1 = state_27274;
var statearr_27279_27373 = state_27274__$1;
(statearr_27279_27373[(2)] = inst_27240);

(statearr_27279_27373[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (15))){
var inst_27267 = (state_27274[(2)]);
var state_27274__$1 = state_27274;
var statearr_27280_27374 = state_27274__$1;
(statearr_27280_27374[(2)] = inst_27267);

(statearr_27280_27374[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (13))){
var inst_27258 = (state_27274[(7)]);
var inst_27260 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27258),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27261 = fluree.db.dbproto._tag_id.call(null,this$__$1,inst_27260);
var state_27274__$1 = state_27274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27274__$1,(16),inst_27261);
} else {
if((state_val_27275 === (6))){
var inst_27248 = fluree.db.dbproto._tag_id.call(null,this$__$1,tag_name);
var state_27274__$1 = state_27274;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27274__$1,(9),inst_27248);
} else {
if((state_val_27275 === (3))){
var inst_27272 = (state_27274[(2)]);
var state_27274__$1 = state_27274;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27274__$1,inst_27272);
} else {
if((state_val_27275 === (12))){
var inst_27258 = (state_27274[(7)]);
var inst_27258__$1 = (state_27274[(2)]);
var state_27274__$1 = (function (){var statearr_27281 = state_27274;
(statearr_27281[(7)] = inst_27258__$1);

return statearr_27281;
})();
if(cljs.core.truth_(inst_27258__$1)){
var statearr_27282_27375 = state_27274__$1;
(statearr_27282_27375[(1)] = (13));

} else {
var statearr_27283_27376 = state_27274__$1;
(statearr_27283_27376[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (2))){
var _ = (function (){var statearr_27284 = state_27274;
(statearr_27284[(4)] = cljs.core.cons.call(null,(5),(state_27274[(4)])));

return statearr_27284;
})();
var inst_27246 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27274__$1 = state_27274;
if(inst_27246){
var statearr_27285_27377 = state_27274__$1;
(statearr_27285_27377[(1)] = (6));

} else {
var statearr_27286_27378 = state_27274__$1;
(statearr_27286_27378[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (11))){
var inst_27256 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27274__$1 = state_27274;
var statearr_27288_27379 = state_27274__$1;
(statearr_27288_27379[(2)] = inst_27256);

(statearr_27288_27379[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (9))){
var inst_27250 = (state_27274[(2)]);
var inst_27251 = fluree.db.util.async.throw_err.call(null,inst_27250);
var state_27274__$1 = state_27274;
var statearr_27289_27380 = state_27274__$1;
(statearr_27289_27380[(2)] = inst_27251);

(statearr_27289_27380[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (5))){
var _ = (function (){var statearr_27290 = state_27274;
(statearr_27290[(4)] = cljs.core.rest.call(null,(state_27274[(4)])));

return statearr_27290;
})();
var state_27274__$1 = state_27274;
var ex27287 = (state_27274__$1[(2)]);
var statearr_27291_27381 = state_27274__$1;
(statearr_27291_27381[(5)] = ex27287);


if((ex27287 instanceof Error)){
var statearr_27292_27382 = state_27274__$1;
(statearr_27292_27382[(1)] = (4));

(statearr_27292_27382[(5)] = null);

} else {
throw ex27287;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (14))){
var state_27274__$1 = state_27274;
var statearr_27293_27383 = state_27274__$1;
(statearr_27293_27383[(2)] = null);

(statearr_27293_27383[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (16))){
var inst_27263 = (state_27274[(2)]);
var inst_27264 = fluree.db.util.async.throw_err.call(null,inst_27263);
var state_27274__$1 = state_27274;
var statearr_27294_27384 = state_27274__$1;
(statearr_27294_27384[(2)] = inst_27264);

(statearr_27294_27384[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (10))){
var state_27274__$1 = state_27274;
var statearr_27295_27385 = state_27274__$1;
(statearr_27295_27385[(2)] = pred);

(statearr_27295_27385[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27275 === (8))){
var inst_27269 = (state_27274[(2)]);
var _ = (function (){var statearr_27296 = state_27274;
(statearr_27296[(4)] = cljs.core.rest.call(null,(state_27274[(4)])));

return statearr_27296;
})();
var state_27274__$1 = state_27274;
var statearr_27297_27386 = state_27274__$1;
(statearr_27297_27386[(2)] = inst_27269);

(statearr_27297_27386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2726__auto__ = null;
var fluree$db$graphdb$state_machine__2726__auto____0 = (function (){
var statearr_27298 = [null,null,null,null,null,null,null,null];
(statearr_27298[(0)] = fluree$db$graphdb$state_machine__2726__auto__);

(statearr_27298[(1)] = (1));

return statearr_27298;
});
var fluree$db$graphdb$state_machine__2726__auto____1 = (function (state_27274){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27274);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27299){var ex__2729__auto__ = e27299;
var statearr_27300_27387 = state_27274;
(statearr_27300_27387[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27274[(4)]))){
var statearr_27301_27388 = state_27274;
(statearr_27301_27388[(1)] = cljs.core.first.call(null,(state_27274[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27389 = state_27274;
state_27274 = G__27389;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2726__auto__ = function(state_27274){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2726__auto____1.call(this,state_27274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2726__auto____0;
fluree$db$graphdb$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2726__auto____1;
return fluree$db$graphdb$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27302 = f__2749__auto__.call(null);
(statearr_27302[(6)] = c__2748__auto__);

return statearr_27302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write.call(null,writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27014){
var extmap__4512__auto__ = (function (){var G__27303 = cljs.core.dissoc.call(null,G__27014,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27014)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27303);
} else {
return G__27303;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27014),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27014),null,cljs.core.not_empty.call(null,extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
