// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__21911 = arguments.length;
switch (G__21911) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__21914 = arguments.length;
switch (G__21914) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2748__auto___21967 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21945){
var state_val_21946 = (state_21945[(1)]);
if((state_val_21946 === (1))){
var state_21945__$1 = state_21945;
var statearr_21947_21968 = state_21945__$1;
(statearr_21947_21968[(2)] = null);

(statearr_21947_21968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (2))){
var _ = (function (){var statearr_21948 = state_21945;
(statearr_21948[(4)] = cljs.core.cons.call(null,(5),(state_21945[(4)])));

return statearr_21948;
})();
var inst_21922 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_21945__$1 = state_21945;
if(cljs.core.truth_(inst_21922)){
var statearr_21949_21969 = state_21945__$1;
(statearr_21949_21969[(1)] = (6));

} else {
var statearr_21950_21970 = state_21945__$1;
(statearr_21950_21970[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (3))){
var inst_21943 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21945__$1,inst_21943);
} else {
if((state_val_21946 === (4))){
var inst_21915 = (state_21945[(2)]);
var inst_21916 = cljs.core.async.put_BANG_.call(null,pc,inst_21915);
var state_21945__$1 = state_21945;
var statearr_21952_21971 = state_21945__$1;
(statearr_21952_21971[(2)] = inst_21916);

(statearr_21952_21971[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (5))){
var _ = (function (){var statearr_21953 = state_21945;
(statearr_21953[(4)] = cljs.core.rest.call(null,(state_21945[(4)])));

return statearr_21953;
})();
var state_21945__$1 = state_21945;
var ex21951 = (state_21945__$1[(2)]);
var statearr_21954_21972 = state_21945__$1;
(statearr_21954_21972[(5)] = ex21951);


var statearr_21955_21973 = state_21945__$1;
(statearr_21955_21973[(1)] = (4));

(statearr_21955_21973[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (6))){
var inst_21924 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21925 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_21926 = cljs.core.PersistentHashMap.fromArrays(inst_21924,inst_21925);
var inst_21927 = cljs.core.ex_info.call(null,"Connection was closed.",inst_21926);
var inst_21928 = (function(){throw inst_21927})();
var state_21945__$1 = state_21945;
var statearr_21956_21974 = state_21945__$1;
(statearr_21956_21974[(2)] = inst_21928);

(statearr_21956_21974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (7))){
var inst_21930 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21932 = [operation,data,pc,opts];
var inst_21933 = (new cljs.core.PersistentVector(null,4,(5),inst_21931,inst_21932,null));
var inst_21934 = cljs.core.async.put_BANG_.call(null,inst_21930,inst_21933);
var inst_21935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21936 = [operation,data,pc,opts];
var inst_21937 = (new cljs.core.PersistentVector(null,4,(5),inst_21935,inst_21936,null));
var inst_21938 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_21937);
var state_21945__$1 = (function (){var statearr_21957 = state_21945;
(statearr_21957[(7)] = inst_21934);

return statearr_21957;
})();
var statearr_21958_21975 = state_21945__$1;
(statearr_21958_21975[(2)] = inst_21938);

(statearr_21958_21975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (8))){
var inst_21940 = (state_21945[(2)]);
var _ = (function (){var statearr_21959 = state_21945;
(statearr_21959[(4)] = cljs.core.rest.call(null,(state_21945[(4)])));

return statearr_21959;
})();
var state_21945__$1 = state_21945;
var statearr_21960_21976 = state_21945__$1;
(statearr_21960_21976[(2)] = inst_21940);

(statearr_21960_21976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2726__auto__ = null;
var fluree$db$operations$state_machine__2726__auto____0 = (function (){
var statearr_21961 = [null,null,null,null,null,null,null,null];
(statearr_21961[(0)] = fluree$db$operations$state_machine__2726__auto__);

(statearr_21961[(1)] = (1));

return statearr_21961;
});
var fluree$db$operations$state_machine__2726__auto____1 = (function (state_21945){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21945);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21962){var ex__2729__auto__ = e21962;
var statearr_21963_21977 = state_21945;
(statearr_21963_21977[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21945[(4)]))){
var statearr_21964_21978 = state_21945;
(statearr_21964_21978[(1)] = cljs.core.first.call(null,(state_21945[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21979 = state_21945;
state_21945 = G__21979;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2726__auto__ = function(state_21945){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2726__auto____1.call(this,state_21945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2726__auto____0;
fluree$db$operations$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2726__auto____1;
return fluree$db$operations$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21965 = f__2749__auto__.call(null);
(statearr_21965[(6)] = c__2748__auto___21967);

return statearr_21965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__21981 = arguments.length;
switch (G__21981) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__21982){
var map__21983 = p__21982;
var map__21983__$1 = cljs.core.__destructure_map.call(null,map__21983);
var opts = map__21983__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__21983__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__21984 = session;
var map__21984__$1 = cljs.core.__destructure_map.call(null,map__21984);
var dbid = cljs.core.get.call(null,map__21984__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__21984__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__21984__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4835__auto__ = [];
var len__4829__auto___22011 = arguments.length;
var i__4830__auto___22012 = (0);
while(true){
if((i__4830__auto___22012 < len__4829__auto___22011)){
args__4835__auto__.push((arguments[i__4830__auto___22012]));

var G__22013 = (i__4830__auto___22012 + (1));
i__4830__auto___22012 = G__22013;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__21988){
var vec__21989 = p__21988;
var map__21992 = cljs.core.nth.call(null,vec__21989,(0),null);
var map__21992__$1 = cljs.core.__destructure_map.call(null,map__21992);
var toBlock = cljs.core.get.call(null,map__21992__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__21992__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__21989;
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_22004){
var state_val_22005 = (state_22004[(1)]);
if((state_val_22005 === (1))){
var inst_21994 = session;
var inst_21995 = cljs.core.__destructure_map.call(null,inst_21994);
var inst_21996 = cljs.core.get.call(null,inst_21995,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_21997 = cljs.core.get.call(null,inst_21995,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_21998 = cljs.core.get.call(null,inst_21995,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_21999 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_22000 = [inst_21996,inst_21997,toBlock,toTime];
var inst_22001 = cljs.core.PersistentHashMap.fromArrays(inst_21999,inst_22000);
var inst_22002 = fluree.db.operations.send_operation.call(null,inst_21998,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_22001);
var state_22004__$1 = state_22004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22004__$1,inst_22002);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2726__auto__ = null;
var fluree$db$operations$state_machine__2726__auto____0 = (function (){
var statearr_22006 = [null,null,null,null,null,null,null];
(statearr_22006[(0)] = fluree$db$operations$state_machine__2726__auto__);

(statearr_22006[(1)] = (1));

return statearr_22006;
});
var fluree$db$operations$state_machine__2726__auto____1 = (function (state_22004){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_22004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e22007){var ex__2729__auto__ = e22007;
var statearr_22008_22014 = state_22004;
(statearr_22008_22014[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_22004[(4)]))){
var statearr_22009_22015 = state_22004;
(statearr_22009_22015[(1)] = cljs.core.first.call(null,(state_22004[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22016 = state_22004;
state_22004 = G__22016;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2726__auto__ = function(state_22004){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2726__auto____1.call(this,state_22004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2726__auto____0;
fluree$db$operations$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2726__auto____1;
return fluree$db$operations$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_22010 = f__2749__auto__.call(null);
(statearr_22010[(6)] = c__2748__auto__);

return statearr_22010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq21986){
var G__21987 = cljs.core.first.call(null,seq21986);
var seq21986__$1 = cljs.core.next.call(null,seq21986);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21987,seq21986__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__22017 = session;
var map__22017__$1 = cljs.core.__destructure_map.call(null,map__22017);
var network = cljs.core.get.call(null,map__22017__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__22017__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__22017__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__22019 = arguments.length;
switch (G__22019) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__22020 = opts;
var map__22020__$1 = cljs.core.__destructure_map.call(null,map__22020);
var auth = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4223__auto__ = auth;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
