// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22199 = arguments.length;
switch (G__22199) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22201 = null;
var G__22201__0 = (function (){
return xf.call(null);
});
var G__22201__1 = (function (result){
return xf.call(null,result);
});
var G__22201__2 = (function (result,flake){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22201 = function(result,flake){
switch(arguments.length){
case 0:
return G__22201__0.call(this);
case 1:
return G__22201__1.call(this,result);
case 2:
return G__22201__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22201.cljs$core$IFn$_invoke$arity$0 = G__22201__0;
G__22201.cljs$core$IFn$_invoke$arity$1 = G__22201__1;
G__22201.cljs$core$IFn$_invoke$arity$2 = G__22201__2;
return G__22201;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22202 = null;
var G__22202__0 = (function (){
return xf.call(null);
});
var G__22202__1 = (function (result){
return xf.call(null,result);
});
var G__22202__2 = (function (result,flakes){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + cljs.core.count.call(null,flakes)));

return xf.call(null,result,flakes);
});
G__22202 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22202__0.call(this);
case 1:
return G__22202__1.call(this,result);
case 2:
return G__22202__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22202.cljs$core$IFn$_invoke$arity$0 = G__22202__0;
G__22202.cljs$core$IFn$_invoke$arity$1 = G__22202__1;
G__22202.cljs$core$IFn$_invoke$arity$2 = G__22202__2;
return G__22202;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + n));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc_in.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__22204 = res;
var G__22204__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__22203_SHARP_){
return cljs.core.get.call(null,p1__22203_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22204):G__22204);
var G__22204__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__22204__$1):G__22204__$1);
var G__22204__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__22204__$2):G__22204__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__22204__$3);
} else {
return G__22204__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22206 = arguments.length;
switch (G__22206) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_22505){
var state_val_22506 = (state_22505[(1)]);
if((state_val_22506 === (65))){
var inst_22363 = (state_22505[(7)]);
var inst_22246 = (state_22505[(8)]);
var inst_22356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22357 = cljs.core.deref.call(null,cache);
var inst_22358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22359 = flake.o;
var inst_22360 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22246);
var inst_22361 = [inst_22359,inst_22360];
var inst_22362 = (new cljs.core.PersistentVector(null,2,(5),inst_22358,inst_22361,null));
var inst_22363__$1 = cljs.core.get.call(null,inst_22357,inst_22362);
var state_22505__$1 = (function (){var statearr_22507 = state_22505;
(statearr_22507[(7)] = inst_22363__$1);

(statearr_22507[(9)] = inst_22356);

return statearr_22507;
})();
if(cljs.core.truth_(inst_22363__$1)){
var statearr_22508_22671 = state_22505__$1;
(statearr_22508_22671[(1)] = (68));

} else {
var statearr_22509_22672 = state_22505__$1;
(statearr_22509_22672[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (70))){
var inst_22356 = (state_22505[(9)]);
var inst_22381 = (state_22505[(2)]);
var inst_22382 = [inst_22381,offset_map];
var inst_22383 = (new cljs.core.PersistentVector(null,2,(5),inst_22356,inst_22382,null));
var state_22505__$1 = state_22505;
var statearr_22510_22673 = state_22505__$1;
(statearr_22510_22673[(2)] = inst_22383);

(statearr_22510_22673[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (62))){
var inst_22261 = (state_22505[(10)]);
var inst_22231 = (state_22505[(11)]);
var inst_22259 = (state_22505[(12)]);
var inst_22260 = (state_22505[(13)]);
var inst_22264 = (state_22505[(14)]);
var inst_22258 = (state_22505[(15)]);
var inst_22263 = (state_22505[(16)]);
var inst_22246 = (state_22505[(8)]);
var inst_22262 = (state_22505[(17)]);
var inst_22325 = (state_22505[(18)]);
var inst_22341 = (state_22505[(19)]);
var inst_22217 = (state_22505[(20)]);
var inst_22257 = (state_22505[(21)]);
var inst_22343 = (function (){var G__22327 = inst_22341;
var p = inst_22264;
var pred_spec__$1 = inst_22231;
var orderBy = inst_22262;
var nested_select_spec = inst_22325;
var multi_QMARK_ = inst_22259;
var limit = inst_22261;
var offset = inst_22263;
var map__22213 = inst_22258;
var k = inst_22257;
var compact_QMARK_ = inst_22217;
var pred_spec_SINGLEQUOTE_ = inst_22246;
var ref_QMARK_ = inst_22260;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n);
});
})();
var inst_22344 = inst_22343.call(null,inst_22341);
var state_22505__$1 = state_22505;
var statearr_22511_22674 = state_22505__$1;
(statearr_22511_22674[(2)] = inst_22344);

(statearr_22511_22674[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (74))){
var inst_22390 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22390)){
var statearr_22512_22675 = state_22505__$1;
(statearr_22512_22675[(1)] = (75));

} else {
var statearr_22513_22676 = state_22505__$1;
(statearr_22513_22676[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (7))){
var inst_22218 = (state_22505[(22)]);
var state_22505__$1 = state_22505;
var statearr_22514_22677 = state_22505__$1;
(statearr_22514_22677[(2)] = inst_22218);

(statearr_22514_22677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (59))){
var inst_22335 = (state_22505[(23)]);
var inst_22337 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22338 = cljs.core.sequence.call(null,inst_22337,inst_22335);
var state_22505__$1 = state_22505;
var statearr_22515_22678 = state_22505__$1;
(statearr_22515_22678[(2)] = inst_22338);

(statearr_22515_22678[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (86))){
var inst_22261 = (state_22505[(10)]);
var inst_22421 = (state_22505[(24)]);
var inst_22403 = (state_22505[(25)]);
var inst_22231 = (state_22505[(11)]);
var inst_22259 = (state_22505[(12)]);
var inst_22260 = (state_22505[(13)]);
var inst_22264 = (state_22505[(14)]);
var inst_22258 = (state_22505[(15)]);
var inst_22263 = (state_22505[(16)]);
var inst_22246 = (state_22505[(8)]);
var inst_22262 = (state_22505[(17)]);
var inst_22217 = (state_22505[(20)]);
var inst_22257 = (state_22505[(21)]);
var inst_22423 = (function (){var p = inst_22264;
var pred_spec__$1 = inst_22231;
var orderBy = inst_22262;
var children = inst_22403;
var multi_QMARK_ = inst_22259;
var limit = inst_22261;
var offset = inst_22263;
var map__22213 = inst_22258;
var k = inst_22257;
var compact_QMARK_ = inst_22217;
var pred_spec_SINGLEQUOTE_ = inst_22246;
var G__22415 = inst_22421;
var ref_QMARK_ = inst_22260;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true,new cljs.core.Keyword(null,"compact?","compact?",1216893298),compact_QMARK_], null),n);
});
})();
var inst_22424 = inst_22423.call(null,inst_22421);
var state_22505__$1 = state_22505;
var statearr_22516_22679 = state_22505__$1;
(statearr_22516_22679[(2)] = inst_22424);

(statearr_22516_22679[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (20))){
var inst_22259 = (state_22505[(12)]);
var inst_22258 = (state_22505[(15)]);
var inst_22246 = (state_22505[(8)]);
var inst_22257 = (state_22505[(2)]);
var inst_22258__$1 = cljs.core.__destructure_map.call(null,inst_22246);
var inst_22259__$1 = cljs.core.get.call(null,inst_22258__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22260 = cljs.core.get.call(null,inst_22258__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22261 = cljs.core.get.call(null,inst_22258__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22262 = cljs.core.get.call(null,inst_22258__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22263 = cljs.core.get.call(null,inst_22258__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22264 = cljs.core.get.call(null,inst_22258__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22505__$1 = (function (){var statearr_22517 = state_22505;
(statearr_22517[(10)] = inst_22261);

(statearr_22517[(12)] = inst_22259__$1);

(statearr_22517[(13)] = inst_22260);

(statearr_22517[(14)] = inst_22264);

(statearr_22517[(15)] = inst_22258__$1);

(statearr_22517[(16)] = inst_22263);

(statearr_22517[(17)] = inst_22262);

(statearr_22517[(21)] = inst_22257);

return statearr_22517;
})();
if(cljs.core.truth_(inst_22259__$1)){
var statearr_22518_22680 = state_22505__$1;
(statearr_22518_22680[(1)] = (24));

} else {
var statearr_22519_22681 = state_22505__$1;
(statearr_22519_22681[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (72))){
var inst_22246 = (state_22505[(8)]);
var inst_22387 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22246);
var state_22505__$1 = state_22505;
var statearr_22520_22682 = state_22505__$1;
(statearr_22520_22682[(2)] = inst_22387);

(statearr_22520_22682[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (58))){
var inst_22334 = (state_22505[(2)]);
var inst_22335 = fluree.db.util.async.throw_err.call(null,inst_22334);
var state_22505__$1 = (function (){var statearr_22521 = state_22505;
(statearr_22521[(23)] = inst_22335);

return statearr_22521;
})();
if(cljs.core.truth_(fuel)){
var statearr_22522_22683 = state_22505__$1;
(statearr_22522_22683[(1)] = (59));

} else {
var statearr_22523_22684 = state_22505__$1;
(statearr_22523_22684[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (60))){
var inst_22335 = (state_22505[(23)]);
var state_22505__$1 = state_22505;
var statearr_22524_22685 = state_22505__$1;
(statearr_22524_22685[(2)] = inst_22335);

(statearr_22524_22685[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (27))){
var inst_22267 = (state_22505[(26)]);
var inst_22263 = (state_22505[(16)]);
var inst_22267__$1 = cljs.core.not_EQ_.call(null,(0),inst_22263);
var state_22505__$1 = (function (){var statearr_22525 = state_22505;
(statearr_22525[(26)] = inst_22267__$1);

return statearr_22525;
})();
if(inst_22267__$1){
var statearr_22526_22686 = state_22505__$1;
(statearr_22526_22686[(1)] = (30));

} else {
var statearr_22527_22687 = state_22505__$1;
(statearr_22527_22687[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (1))){
var state_22505__$1 = state_22505;
var statearr_22528_22688 = state_22505__$1;
(statearr_22528_22688[(2)] = null);

(statearr_22528_22688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (69))){
var inst_22246 = (state_22505[(8)]);
var inst_22366 = flake.o;
var inst_22367 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22246);
var inst_22368 = fluree.db.dbproto._tag.call(null,db,inst_22366,inst_22367);
var state_22505__$1 = state_22505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22505__$1,(71),inst_22368);
} else {
if((state_val_22506 === (101))){
var inst_22465 = (state_22505[(27)]);
var inst_22466 = (state_22505[(28)]);
var inst_22257 = (state_22505[(21)]);
var inst_22485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22486 = cljs.core.assoc.call(null,acc,inst_22257,inst_22465);
var inst_22487 = [inst_22486,inst_22466];
var inst_22488 = (new cljs.core.PersistentVector(null,2,(5),inst_22485,inst_22487,null));
var state_22505__$1 = state_22505;
var statearr_22529_22689 = state_22505__$1;
(statearr_22529_22689[(2)] = inst_22488);

(statearr_22529_22689[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (24))){
var inst_22263 = (state_22505[(16)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22263)){
var statearr_22530_22690 = state_22505__$1;
(statearr_22530_22690[(1)] = (27));

} else {
var statearr_22531_22691 = state_22505__$1;
(statearr_22531_22691[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (102))){
var state_22505__$1 = state_22505;
var statearr_22532_22692 = state_22505__$1;
(statearr_22532_22692[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (55))){
var inst_22246 = (state_22505[(8)]);
var inst_22354 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22246);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22354)){
var statearr_22534_22693 = state_22505__$1;
(statearr_22534_22693[(1)] = (65));

} else {
var statearr_22535_22694 = state_22505__$1;
(statearr_22535_22694[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (85))){
var inst_22421 = (state_22505[(2)]);
var state_22505__$1 = (function (){var statearr_22536 = state_22505;
(statearr_22536[(24)] = inst_22421);

return statearr_22536;
})();
var statearr_22537_22695 = state_22505__$1;
(statearr_22537_22695[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (39))){
var inst_22262 = (state_22505[(17)]);
var inst_22294 = (state_22505[(29)]);
var inst_22294__$1 = cljs.core.not.call(null,inst_22262);
var state_22505__$1 = (function (){var statearr_22539 = state_22505;
(statearr_22539[(29)] = inst_22294__$1);

return statearr_22539;
})();
if(inst_22294__$1){
var statearr_22540_22696 = state_22505__$1;
(statearr_22540_22696[(1)] = (42));

} else {
var statearr_22541_22697 = state_22505__$1;
(statearr_22541_22697[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (88))){
var inst_22427 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22505__$1,(82),inst_22427);
} else {
if((state_val_22506 === (46))){
var inst_22310 = (state_22505[(30)]);
var inst_22310__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_22505__$1 = (function (){var statearr_22542 = state_22505;
(statearr_22542[(30)] = inst_22310__$1);

return statearr_22542;
})();
if(inst_22310__$1){
var statearr_22543_22698 = state_22505__$1;
(statearr_22543_22698[(1)] = (48));

} else {
var statearr_22544_22699 = state_22505__$1;
(statearr_22544_22699[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (4))){
var inst_22207 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22545_22700 = state_22505__$1;
(statearr_22545_22700[(2)] = inst_22207);

(statearr_22545_22700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (77))){
var inst_22456 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22546_22701 = state_22505__$1;
(statearr_22546_22701[(2)] = inst_22456);

(statearr_22546_22701[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (106))){
var inst_22496 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22547_22702 = state_22505__$1;
(statearr_22547_22702[(2)] = inst_22496);

(statearr_22547_22702[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (95))){
var inst_22259 = (state_22505[(12)]);
var state_22505__$1 = state_22505;
var statearr_22548_22703 = state_22505__$1;
(statearr_22548_22703[(2)] = inst_22259);

(statearr_22548_22703[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (54))){
var inst_22246 = (state_22505[(8)]);
var inst_22322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22323 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22324 = (new cljs.core.PersistentVector(null,3,(5),inst_22322,inst_22323,null));
var inst_22325 = cljs.core.select_keys.call(null,inst_22246,inst_22324);
var inst_22326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22328 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22329 = flake.o;
var inst_22330 = [inst_22329];
var inst_22331 = (new cljs.core.PersistentVector(null,1,(5),inst_22328,inst_22330,null));
var inst_22332 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22331);
var state_22505__$1 = (function (){var statearr_22549 = state_22505;
(statearr_22549[(31)] = inst_22326);

(statearr_22549[(18)] = inst_22325);

return statearr_22549;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22505__$1,(58),inst_22332);
} else {
if((state_val_22506 === (92))){
var inst_22446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22447 = flake.o;
var inst_22448 = [inst_22447,offset_map];
var inst_22449 = (new cljs.core.PersistentVector(null,2,(5),inst_22446,inst_22448,null));
var state_22505__$1 = state_22505;
var statearr_22550_22704 = state_22505__$1;
(statearr_22550_22704[(2)] = inst_22449);

(statearr_22550_22704[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (104))){
var inst_22466 = (state_22505[(28)]);
var inst_22491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22492 = [acc,inst_22466];
var inst_22493 = (new cljs.core.PersistentVector(null,2,(5),inst_22491,inst_22492,null));
var state_22505__$1 = state_22505;
var statearr_22551_22705 = state_22505__$1;
(statearr_22551_22705[(2)] = inst_22493);

(statearr_22551_22705[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (15))){
var inst_22239 = (state_22505[(32)]);
var inst_22217 = (state_22505[(20)]);
var inst_22243 = cljs.core.assoc.call(null,inst_22239,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22217);
var state_22505__$1 = state_22505;
var statearr_22552_22706 = state_22505__$1;
(statearr_22552_22706[(2)] = inst_22243);

(statearr_22552_22706[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (48))){
var inst_22312 = (state_22505[(33)]);
var inst_22246 = (state_22505[(8)]);
var inst_22312__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22246);
var state_22505__$1 = (function (){var statearr_22553 = state_22505;
(statearr_22553[(33)] = inst_22312__$1);

return statearr_22553;
})();
if(cljs.core.truth_(inst_22312__$1)){
var statearr_22554_22707 = state_22505__$1;
(statearr_22554_22707[(1)] = (51));

} else {
var statearr_22555_22708 = state_22505__$1;
(statearr_22555_22708[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (50))){
var inst_22320 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22320)){
var statearr_22556_22709 = state_22505__$1;
(statearr_22556_22709[(1)] = (54));

} else {
var statearr_22557_22710 = state_22505__$1;
(statearr_22557_22710[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (75))){
var inst_22246 = (state_22505[(8)]);
var inst_22392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22393 = flake.o;
var inst_22394 = [inst_22393];
var inst_22395 = (new cljs.core.PersistentVector(null,1,(5),inst_22392,inst_22394,null));
var inst_22396 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22397 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22246);
var inst_22398 = [inst_22397];
var inst_22399 = cljs.core.PersistentHashMap.fromArrays(inst_22396,inst_22398);
var inst_22400 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22395,inst_22399);
var state_22505__$1 = state_22505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22505__$1,(78),inst_22400);
} else {
if((state_val_22506 === (99))){
var inst_22465 = (state_22505[(27)]);
var inst_22482 = (inst_22465 == null);
var inst_22483 = cljs.core.not.call(null,inst_22482);
var state_22505__$1 = state_22505;
if(inst_22483){
var statearr_22558_22711 = state_22505__$1;
(statearr_22558_22711[(1)] = (101));

} else {
var statearr_22559_22712 = state_22505__$1;
(statearr_22559_22712[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (21))){
var inst_22250 = (state_22505[(34)]);
var state_22505__$1 = state_22505;
var statearr_22560_22713 = state_22505__$1;
(statearr_22560_22713[(2)] = inst_22250);

(statearr_22560_22713[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (31))){
var inst_22267 = (state_22505[(26)]);
var state_22505__$1 = state_22505;
var statearr_22561_22714 = state_22505__$1;
(statearr_22561_22714[(2)] = inst_22267);

(statearr_22561_22714[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (32))){
var inst_22273 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22562_22715 = state_22505__$1;
(statearr_22562_22715[(2)] = inst_22273);

(statearr_22562_22715[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (40))){
var inst_22259 = (state_22505[(12)]);
var state_22505__$1 = state_22505;
var statearr_22563_22716 = state_22505__$1;
(statearr_22563_22716[(2)] = inst_22259);

(statearr_22563_22716[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (91))){
var inst_22454 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22564_22717 = state_22505__$1;
(statearr_22564_22717[(2)] = inst_22454);

(statearr_22564_22717[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (56))){
var inst_22460 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22565_22718 = state_22505__$1;
(statearr_22565_22718[(2)] = inst_22460);

(statearr_22565_22718[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (33))){
var inst_22264 = (state_22505[(14)]);
var inst_22281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22282 = cljs.core.get.call(null,offset_map,inst_22264);
var state_22505__$1 = (function (){var statearr_22566 = state_22505;
(statearr_22566[(35)] = inst_22281);

return statearr_22566;
})();
if(cljs.core.truth_(inst_22282)){
var statearr_22567_22719 = state_22505__$1;
(statearr_22567_22719[(1)] = (36));

} else {
var statearr_22568_22720 = state_22505__$1;
(statearr_22568_22720[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (13))){
var inst_22231 = (state_22505[(11)]);
var state_22505__$1 = state_22505;
var statearr_22569_22721 = state_22505__$1;
(statearr_22569_22721[(2)] = inst_22231);

(statearr_22569_22721[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (22))){
var inst_22246 = (state_22505[(8)]);
var inst_22253 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22246);
var state_22505__$1 = state_22505;
var statearr_22570_22722 = state_22505__$1;
(statearr_22570_22722[(2)] = inst_22253);

(statearr_22570_22722[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (90))){
var state_22505__$1 = state_22505;
var statearr_22571_22723 = state_22505__$1;
(statearr_22571_22723[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (36))){
var inst_22264 = (state_22505[(14)]);
var inst_22284 = cljs.core.update.call(null,offset_map,inst_22264,cljs.core.dec);
var state_22505__$1 = state_22505;
var statearr_22573_22724 = state_22505__$1;
(statearr_22573_22724[(2)] = inst_22284);

(statearr_22573_22724[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (41))){
var inst_22304 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22304)){
var statearr_22574_22725 = state_22505__$1;
(statearr_22574_22725[(1)] = (45));

} else {
var statearr_22575_22726 = state_22505__$1;
(statearr_22575_22726[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (89))){
var inst_22437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22438 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22439 = flake.o;
var inst_22440 = [inst_22439];
var inst_22441 = cljs.core.PersistentHashMap.fromArrays(inst_22438,inst_22440);
var inst_22442 = [inst_22441,offset_map];
var inst_22443 = (new cljs.core.PersistentVector(null,2,(5),inst_22437,inst_22442,null));
var state_22505__$1 = state_22505;
var statearr_22576_22727 = state_22505__$1;
(statearr_22576_22727[(2)] = inst_22443);

(statearr_22576_22727[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (100))){
var inst_22500 = (state_22505[(2)]);
var _ = (function (){var statearr_22577 = state_22505;
(statearr_22577[(4)] = cljs.core.rest.call(null,(state_22505[(4)])));

return statearr_22577;
})();
var state_22505__$1 = state_22505;
var statearr_22578_22728 = state_22505__$1;
(statearr_22578_22728[(2)] = inst_22500);

(statearr_22578_22728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (43))){
var inst_22294 = (state_22505[(29)]);
var state_22505__$1 = state_22505;
var statearr_22579_22729 = state_22505__$1;
(statearr_22579_22729[(2)] = inst_22294);

(statearr_22579_22729[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (61))){
var inst_22341 = (state_22505[(2)]);
var state_22505__$1 = (function (){var statearr_22580 = state_22505;
(statearr_22580[(19)] = inst_22341);

return statearr_22580;
})();
var statearr_22581_22730 = state_22505__$1;
(statearr_22581_22730[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (29))){
var inst_22276 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22583_22731 = state_22505__$1;
(statearr_22583_22731[(2)] = inst_22276);

(statearr_22583_22731[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (44))){
var inst_22301 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22584_22732 = state_22505__$1;
(statearr_22584_22732[(2)] = inst_22301);

(statearr_22584_22732[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (93))){
var state_22505__$1 = state_22505;
var statearr_22585_22733 = state_22505__$1;
(statearr_22585_22733[(2)] = null);

(statearr_22585_22733[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (6))){
var inst_22220 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22221 = (inst_22220 == null);
var state_22505__$1 = state_22505;
var statearr_22586_22734 = state_22505__$1;
(statearr_22586_22734[(2)] = inst_22221);

(statearr_22586_22734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (28))){
var inst_22263 = (state_22505[(16)]);
var state_22505__$1 = state_22505;
var statearr_22587_22735 = state_22505__$1;
(statearr_22587_22735[(2)] = inst_22263);

(statearr_22587_22735[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (64))){
var inst_22347 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22505__$1,(57),inst_22347);
} else {
if((state_val_22506 === (103))){
var inst_22498 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22588_22736 = state_22505__$1;
(statearr_22588_22736[(2)] = inst_22498);

(statearr_22588_22736[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (51))){
var inst_22312 = (state_22505[(33)]);
var state_22505__$1 = state_22505;
var statearr_22589_22737 = state_22505__$1;
(statearr_22589_22737[(2)] = inst_22312);

(statearr_22589_22737[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (25))){
var inst_22259 = (state_22505[(12)]);
var state_22505__$1 = state_22505;
var statearr_22590_22738 = state_22505__$1;
(statearr_22590_22738[(2)] = inst_22259);

(statearr_22590_22738[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (34))){
var inst_22259 = (state_22505[(12)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22259)){
var statearr_22591_22739 = state_22505__$1;
(statearr_22591_22739[(1)] = (39));

} else {
var statearr_22592_22740 = state_22505__$1;
(statearr_22592_22740[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (17))){
var inst_22247 = (state_22505[(36)]);
var inst_22246 = (state_22505[(8)]);
var inst_22246__$1 = (state_22505[(2)]);
var inst_22247__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22246__$1);
var state_22505__$1 = (function (){var statearr_22593 = state_22505;
(statearr_22593[(36)] = inst_22247__$1);

(statearr_22593[(8)] = inst_22246__$1);

return statearr_22593;
})();
if(cljs.core.truth_(inst_22247__$1)){
var statearr_22594_22741 = state_22505__$1;
(statearr_22594_22741[(1)] = (18));

} else {
var statearr_22595_22742 = state_22505__$1;
(statearr_22595_22742[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (3))){
var inst_22503 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22505__$1,inst_22503);
} else {
if((state_val_22506 === (12))){
var inst_22231 = (state_22505[(11)]);
var inst_22236 = cljs.core.assoc.call(null,inst_22231,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22505__$1 = state_22505;
var statearr_22596_22743 = state_22505__$1;
(statearr_22596_22743[(2)] = inst_22236);

(statearr_22596_22743[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (2))){
var inst_22218 = (state_22505[(22)]);
var _ = (function (){var statearr_22597 = state_22505;
(statearr_22597[(4)] = cljs.core.cons.call(null,(5),(state_22505[(4)])));

return statearr_22597;
})();
var inst_22217 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22218__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22505__$1 = (function (){var statearr_22598 = state_22505;
(statearr_22598[(22)] = inst_22218__$1);

(statearr_22598[(20)] = inst_22217);

return statearr_22598;
})();
if(cljs.core.truth_(inst_22218__$1)){
var statearr_22599_22744 = state_22505__$1;
(statearr_22599_22744[(1)] = (6));

} else {
var statearr_22600_22745 = state_22505__$1;
(statearr_22600_22745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (66))){
var inst_22385 = (state_22505[(37)]);
var inst_22385__$1 = componentFollow_QMARK_;
var state_22505__$1 = (function (){var statearr_22601 = state_22505;
(statearr_22601[(37)] = inst_22385__$1);

return statearr_22601;
})();
if(cljs.core.truth_(inst_22385__$1)){
var statearr_22602_22746 = state_22505__$1;
(statearr_22602_22746[(1)] = (72));

} else {
var statearr_22603_22747 = state_22505__$1;
(statearr_22603_22747[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (23))){
var inst_22255 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22604_22748 = state_22505__$1;
(statearr_22604_22748[(2)] = inst_22255);

(statearr_22604_22748[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (47))){
var inst_22462 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22605_22749 = state_22505__$1;
(statearr_22605_22749[(2)] = inst_22462);

(statearr_22605_22749[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (35))){
var inst_22465 = (state_22505[(27)]);
var inst_22468 = (state_22505[(38)]);
var inst_22464 = (state_22505[(2)]);
var inst_22465__$1 = cljs.core.nth.call(null,inst_22464,(0),null);
var inst_22466 = cljs.core.nth.call(null,inst_22464,(1),null);
var inst_22467 = (inst_22465__$1 == null);
var inst_22468__$1 = cljs.core.not.call(null,inst_22467);
var state_22505__$1 = (function (){var statearr_22606 = state_22505;
(statearr_22606[(27)] = inst_22465__$1);

(statearr_22606[(28)] = inst_22466);

(statearr_22606[(38)] = inst_22468__$1);

return statearr_22606;
})();
if(inst_22468__$1){
var statearr_22607_22750 = state_22505__$1;
(statearr_22607_22750[(1)] = (95));

} else {
var statearr_22608_22751 = state_22505__$1;
(statearr_22608_22751[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (82))){
var inst_22414 = (state_22505[(39)]);
var inst_22429 = (state_22505[(2)]);
var inst_22430 = fluree.db.util.async.throw_err.call(null,inst_22429);
var inst_22431 = [inst_22430,offset_map];
var inst_22432 = (new cljs.core.PersistentVector(null,2,(5),inst_22414,inst_22431,null));
var state_22505__$1 = state_22505;
var statearr_22609_22752 = state_22505__$1;
(statearr_22609_22752[(2)] = inst_22432);

(statearr_22609_22752[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (76))){
var inst_22260 = (state_22505[(13)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22260)){
var statearr_22610_22753 = state_22505__$1;
(statearr_22610_22753[(1)] = (89));

} else {
var statearr_22611_22754 = state_22505__$1;
(statearr_22611_22754[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (97))){
var inst_22472 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22472)){
var statearr_22612_22755 = state_22505__$1;
(statearr_22612_22755[(1)] = (98));

} else {
var statearr_22613_22756 = state_22505__$1;
(statearr_22613_22756[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (19))){
var inst_22250 = (state_22505[(34)]);
var inst_22246 = (state_22505[(8)]);
var inst_22250__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22246);
var state_22505__$1 = (function (){var statearr_22614 = state_22505;
(statearr_22614[(34)] = inst_22250__$1);

return statearr_22614;
})();
if(cljs.core.truth_(inst_22250__$1)){
var statearr_22615_22757 = state_22505__$1;
(statearr_22615_22757[(1)] = (21));

} else {
var statearr_22616_22758 = state_22505__$1;
(statearr_22616_22758[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (57))){
var inst_22326 = (state_22505[(31)]);
var inst_22349 = (state_22505[(2)]);
var inst_22350 = fluree.db.util.async.throw_err.call(null,inst_22349);
var inst_22351 = [inst_22350,offset_map];
var inst_22352 = (new cljs.core.PersistentVector(null,2,(5),inst_22326,inst_22351,null));
var state_22505__$1 = state_22505;
var statearr_22617_22759 = state_22505__$1;
(statearr_22617_22759[(2)] = inst_22352);

(statearr_22617_22759[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (68))){
var inst_22363 = (state_22505[(7)]);
var state_22505__$1 = state_22505;
var statearr_22618_22760 = state_22505__$1;
(statearr_22618_22760[(2)] = inst_22363);

(statearr_22618_22760[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (11))){
var inst_22231 = (state_22505[(11)]);
var inst_22231__$1 = (state_22505[(2)]);
var inst_22233 = cljs.core.contains_QMARK_.call(null,inst_22231__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22234 = (!(inst_22233));
var state_22505__$1 = (function (){var statearr_22620 = state_22505;
(statearr_22620[(11)] = inst_22231__$1);

return statearr_22620;
})();
if(inst_22234){
var statearr_22621_22761 = state_22505__$1;
(statearr_22621_22761[(1)] = (12));

} else {
var statearr_22622_22762 = state_22505__$1;
(statearr_22622_22762[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (9))){
var inst_22226 = flake.p;
var inst_22227 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22228 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_22226,inst_22227);
var state_22505__$1 = state_22505;
var statearr_22623_22763 = state_22505__$1;
(statearr_22623_22763[(2)] = inst_22228);

(statearr_22623_22763[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (5))){
var _ = (function (){var statearr_22624 = state_22505;
(statearr_22624[(4)] = cljs.core.rest.call(null,(state_22505[(4)])));

return statearr_22624;
})();
var state_22505__$1 = state_22505;
var ex22619 = (state_22505__$1[(2)]);
var statearr_22625_22764 = state_22505__$1;
(statearr_22625_22764[(5)] = ex22619);


if((ex22619 instanceof Error)){
var statearr_22626_22765 = state_22505__$1;
(statearr_22626_22765[(1)] = (4));

(statearr_22626_22765[(5)] = null);

} else {
throw ex22619;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (83))){
var inst_22403 = (state_22505[(25)]);
var inst_22417 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22418 = cljs.core.sequence.call(null,inst_22417,inst_22403);
var state_22505__$1 = state_22505;
var statearr_22627_22766 = state_22505__$1;
(statearr_22627_22766[(2)] = inst_22418);

(statearr_22627_22766[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (14))){
var inst_22231 = (state_22505[(11)]);
var inst_22239 = (state_22505[(2)]);
var inst_22240 = cljs.core.contains_QMARK_.call(null,inst_22231,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22241 = (!(inst_22240));
var state_22505__$1 = (function (){var statearr_22628 = state_22505;
(statearr_22628[(32)] = inst_22239);

return statearr_22628;
})();
if(inst_22241){
var statearr_22629_22767 = state_22505__$1;
(statearr_22629_22767[(1)] = (15));

} else {
var statearr_22630_22768 = state_22505__$1;
(statearr_22630_22768[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (45))){
var inst_22306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22307 = [null,offset_map];
var inst_22308 = (new cljs.core.PersistentVector(null,2,(5),inst_22306,inst_22307,null));
var state_22505__$1 = state_22505;
var statearr_22631_22769 = state_22505__$1;
(statearr_22631_22769[(2)] = inst_22308);

(statearr_22631_22769[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (53))){
var inst_22317 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22632_22770 = state_22505__$1;
(statearr_22632_22770[(2)] = inst_22317);

(statearr_22632_22770[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (78))){
var inst_22403 = (state_22505[(25)]);
var inst_22402 = (state_22505[(2)]);
var inst_22403__$1 = fluree.db.util.async.throw_err.call(null,inst_22402);
var inst_22404 = cljs.core.empty_QMARK_.call(null,inst_22403__$1);
var state_22505__$1 = (function (){var statearr_22633 = state_22505;
(statearr_22633[(25)] = inst_22403__$1);

return statearr_22633;
})();
if(inst_22404){
var statearr_22634_22771 = state_22505__$1;
(statearr_22634_22771[(1)] = (79));

} else {
var statearr_22635_22772 = state_22505__$1;
(statearr_22635_22772[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (26))){
var inst_22279 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22279)){
var statearr_22636_22773 = state_22505__$1;
(statearr_22636_22773[(1)] = (33));

} else {
var statearr_22637_22774 = state_22505__$1;
(statearr_22637_22774[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (16))){
var inst_22239 = (state_22505[(32)]);
var state_22505__$1 = state_22505;
var statearr_22638_22775 = state_22505__$1;
(statearr_22638_22775[(2)] = inst_22239);

(statearr_22638_22775[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (81))){
var inst_22434 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22639_22776 = state_22505__$1;
(statearr_22639_22776[(2)] = inst_22434);

(statearr_22639_22776[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (79))){
var inst_22406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22407 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22408 = flake.o;
var inst_22409 = [inst_22408];
var inst_22410 = cljs.core.PersistentHashMap.fromArrays(inst_22407,inst_22409);
var inst_22411 = [inst_22410,offset_map];
var inst_22412 = (new cljs.core.PersistentVector(null,2,(5),inst_22406,inst_22411,null));
var state_22505__$1 = state_22505;
var statearr_22640_22777 = state_22505__$1;
(statearr_22640_22777[(2)] = inst_22412);

(statearr_22640_22777[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (38))){
var inst_22281 = (state_22505[(35)]);
var inst_22289 = (state_22505[(2)]);
var inst_22290 = [null,inst_22289];
var inst_22291 = (new cljs.core.PersistentVector(null,2,(5),inst_22281,inst_22290,null));
var state_22505__$1 = state_22505;
var statearr_22641_22778 = state_22505__$1;
(statearr_22641_22778[(2)] = inst_22291);

(statearr_22641_22778[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (98))){
var inst_22465 = (state_22505[(27)]);
var inst_22466 = (state_22505[(28)]);
var inst_22257 = (state_22505[(21)]);
var inst_22474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22475 = cljs.core.PersistentVector.EMPTY;
var inst_22476 = cljs.core.get.call(null,acc,inst_22257,inst_22475);
var inst_22477 = cljs.core.conj.call(null,inst_22476,inst_22465);
var inst_22478 = cljs.core.assoc.call(null,acc,inst_22257,inst_22477);
var inst_22479 = [inst_22478,inst_22466];
var inst_22480 = (new cljs.core.PersistentVector(null,2,(5),inst_22474,inst_22479,null));
var state_22505__$1 = state_22505;
var statearr_22642_22779 = state_22505__$1;
(statearr_22642_22779[(2)] = inst_22480);

(statearr_22642_22779[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (87))){
var inst_22421 = (state_22505[(24)]);
var state_22505__$1 = state_22505;
var statearr_22643_22780 = state_22505__$1;
(statearr_22643_22780[(2)] = inst_22421);

(statearr_22643_22780[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (30))){
var inst_22264 = (state_22505[(14)]);
var inst_22269 = cljs.core.get.call(null,offset_map,inst_22264);
var inst_22270 = cljs.core.not_EQ_.call(null,(0),inst_22269);
var state_22505__$1 = state_22505;
var statearr_22644_22781 = state_22505__$1;
(statearr_22644_22781[(2)] = inst_22270);

(statearr_22644_22781[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (73))){
var inst_22385 = (state_22505[(37)]);
var state_22505__$1 = state_22505;
var statearr_22645_22782 = state_22505__$1;
(statearr_22645_22782[(2)] = inst_22385);

(statearr_22645_22782[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (96))){
var inst_22468 = (state_22505[(38)]);
var state_22505__$1 = state_22505;
var statearr_22646_22783 = state_22505__$1;
(statearr_22646_22783[(2)] = inst_22468);

(statearr_22646_22783[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (10))){
var state_22505__$1 = state_22505;
var statearr_22647_22784 = state_22505__$1;
(statearr_22647_22784[(2)] = pred_spec);

(statearr_22647_22784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (18))){
var inst_22247 = (state_22505[(36)]);
var state_22505__$1 = state_22505;
var statearr_22648_22785 = state_22505__$1;
(statearr_22648_22785[(2)] = inst_22247);

(statearr_22648_22785[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (105))){
var state_22505__$1 = state_22505;
var statearr_22649_22786 = state_22505__$1;
(statearr_22649_22786[(2)] = null);

(statearr_22649_22786[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (52))){
var inst_22246 = (state_22505[(8)]);
var inst_22315 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22246);
var state_22505__$1 = state_22505;
var statearr_22650_22787 = state_22505__$1;
(statearr_22650_22787[(2)] = inst_22315);

(statearr_22650_22787[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (67))){
var inst_22458 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22651_22788 = state_22505__$1;
(statearr_22651_22788[(2)] = inst_22458);

(statearr_22651_22788[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (71))){
var inst_22246 = (state_22505[(8)]);
var inst_22370 = (state_22505[(2)]);
var inst_22371 = fluree.db.util.async.throw_err.call(null,inst_22370);
var inst_22372 = cljs.core._deref.call(null,cache);
var inst_22373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22374 = flake.o;
var inst_22375 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22246);
var inst_22376 = [inst_22374,inst_22375];
var inst_22377 = (new cljs.core.PersistentVector(null,2,(5),inst_22373,inst_22376,null));
var inst_22378 = cljs.core.assoc.call(null,inst_22372,inst_22377,inst_22371);
var inst_22379 = cljs.core._vreset_BANG_.call(null,cache,inst_22378);
var state_22505__$1 = (function (){var statearr_22652 = state_22505;
(statearr_22652[(40)] = inst_22379);

return statearr_22652;
})();
var statearr_22653_22789 = state_22505__$1;
(statearr_22653_22789[(2)] = inst_22371);

(statearr_22653_22789[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (42))){
var inst_22261 = (state_22505[(10)]);
var inst_22257 = (state_22505[(21)]);
var inst_22296 = cljs.core.get.call(null,acc,inst_22257);
var inst_22297 = cljs.core.count.call(null,inst_22296);
var inst_22298 = (inst_22297 >= inst_22261);
var state_22505__$1 = state_22505;
var statearr_22654_22790 = state_22505__$1;
(statearr_22654_22790[(2)] = inst_22298);

(statearr_22654_22790[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (80))){
var inst_22414 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22505__$1 = (function (){var statearr_22655 = state_22505;
(statearr_22655[(39)] = inst_22414);

return statearr_22655;
})();
if(cljs.core.truth_(fuel)){
var statearr_22656_22791 = state_22505__$1;
(statearr_22656_22791[(1)] = (83));

} else {
var statearr_22657_22792 = state_22505__$1;
(statearr_22657_22792[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (37))){
var inst_22264 = (state_22505[(14)]);
var inst_22263 = (state_22505[(16)]);
var inst_22286 = (inst_22263 - (1));
var inst_22287 = cljs.core.assoc.call(null,offset_map,inst_22264,inst_22286);
var state_22505__$1 = state_22505;
var statearr_22658_22793 = state_22505__$1;
(statearr_22658_22793[(2)] = inst_22287);

(statearr_22658_22793[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (63))){
var inst_22341 = (state_22505[(19)]);
var state_22505__$1 = state_22505;
var statearr_22659_22794 = state_22505__$1;
(statearr_22659_22794[(2)] = inst_22341);

(statearr_22659_22794[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (94))){
var inst_22452 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
var statearr_22660_22795 = state_22505__$1;
(statearr_22660_22795[(2)] = inst_22452);

(statearr_22660_22795[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (8))){
var inst_22224 = (state_22505[(2)]);
var state_22505__$1 = state_22505;
if(cljs.core.truth_(inst_22224)){
var statearr_22661_22796 = state_22505__$1;
(statearr_22661_22796[(1)] = (9));

} else {
var statearr_22662_22797 = state_22505__$1;
(statearr_22662_22797[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (49))){
var inst_22310 = (state_22505[(30)]);
var state_22505__$1 = state_22505;
var statearr_22663_22798 = state_22505__$1;
(statearr_22663_22798[(2)] = inst_22310);

(statearr_22663_22798[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22506 === (84))){
var inst_22403 = (state_22505[(25)]);
var state_22505__$1 = state_22505;
var statearr_22664_22799 = state_22505__$1;
(statearr_22664_22799[(2)] = inst_22403);

(statearr_22664_22799[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2726__auto__ = null;
var fluree$db$query$fql$state_machine__2726__auto____0 = (function (){
var statearr_22665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22665[(0)] = fluree$db$query$fql$state_machine__2726__auto__);

(statearr_22665[(1)] = (1));

return statearr_22665;
});
var fluree$db$query$fql$state_machine__2726__auto____1 = (function (state_22505){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_22505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e22666){var ex__2729__auto__ = e22666;
var statearr_22667_22800 = state_22505;
(statearr_22667_22800[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_22505[(4)]))){
var statearr_22668_22801 = state_22505;
(statearr_22668_22801[(1)] = cljs.core.first.call(null,(state_22505[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22802 = state_22505;
state_22505 = G__22802;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2726__auto__ = function(state_22505){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2726__auto____1.call(this,state_22505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2726__auto____0;
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2726__auto____1;
return fluree$db$query$fql$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_22669 = f__2749__auto__.call(null);
(statearr_22669[(6)] = c__2748__auto__);

return statearr_22669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4223__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_22962){
var state_val_22963 = (state_22962[(1)]);
if((state_val_22963 === (7))){
var inst_22957 = (state_22962[(2)]);
var _ = (function (){var statearr_22964 = state_22962;
(statearr_22964[(4)] = cljs.core.rest.call(null,(state_22962[(4)])));

return statearr_22964;
})();
var state_22962__$1 = state_22962;
var statearr_22965_23047 = state_22962__$1;
(statearr_22965_23047[(2)] = inst_22957);

(statearr_22965_23047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (20))){
var inst_22884 = (state_22962[(7)]);
var state_22962__$1 = state_22962;
var statearr_22966_23048 = state_22962__$1;
(statearr_22966_23048[(2)] = inst_22884);

(statearr_22966_23048[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (27))){
var inst_22839 = (state_22962[(8)]);
var state_22962__$1 = state_22962;
if(cljs.core.truth_(inst_22839)){
var statearr_22967_23049 = state_22962__$1;
(statearr_22967_23049[(1)] = (29));

} else {
var statearr_22968_23050 = state_22962__$1;
(statearr_22968_23050[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (1))){
var state_22962__$1 = state_22962;
var statearr_22969_23051 = state_22962__$1;
(statearr_22969_23051[(2)] = null);

(statearr_22969_23051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (24))){
var inst_22840 = (state_22962[(9)]);
var state_22962__$1 = state_22962;
var statearr_22970_23052 = state_22962__$1;
(statearr_22970_23052[(2)] = inst_22840);

(statearr_22970_23052[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (39))){
var inst_22876 = (state_22962[(10)]);
var state_22962__$1 = state_22962;
var statearr_22971_23053 = state_22962__$1;
(statearr_22971_23053[(2)] = inst_22876);

(statearr_22971_23053[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (46))){
var inst_22841 = (state_22962[(11)]);
var state_22962__$1 = state_22962;
var statearr_22972_23054 = state_22962__$1;
(statearr_22972_23054[(2)] = inst_22841);

(statearr_22972_23054[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (4))){
var inst_22803 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
var statearr_22973_23055 = state_22962__$1;
(statearr_22973_23055[(2)] = inst_22803);

(statearr_22973_23055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (15))){
var inst_22852 = (state_22962[(12)]);
var inst_22858 = cljs.core.count.call(null,inst_22852);
var inst_22859 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22858,max_fuel);
var state_22962__$1 = state_22962;
var statearr_22974_23056 = state_22962__$1;
(statearr_22974_23056[(2)] = inst_22859);

(statearr_22974_23056[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (48))){
var inst_22828 = (state_22962[(13)]);
var inst_22821 = (state_22962[(14)]);
var inst_22943 = (state_22962[(15)]);
var inst_22951 = (state_22962[(2)]);
var inst_22952 = cljs.core.assoc.call(null,inst_22821,inst_22951,inst_22943);
var inst_22820 = inst_22828;
var inst_22821__$1 = inst_22952;
var state_22962__$1 = (function (){var statearr_22975 = state_22962;
(statearr_22975[(14)] = inst_22821__$1);

(statearr_22975[(16)] = inst_22820);

return statearr_22975;
})();
var statearr_22976_23057 = state_22962__$1;
(statearr_22976_23057[(2)] = null);

(statearr_22976_23057[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (50))){
var inst_22843 = (state_22962[(17)]);
var state_22962__$1 = state_22962;
var statearr_22977_23058 = state_22962__$1;
(statearr_22977_23058[(2)] = inst_22843);

(statearr_22977_23058[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (21))){
var inst_22840 = (state_22962[(9)]);
var state_22962__$1 = state_22962;
if(cljs.core.truth_(inst_22840)){
var statearr_22979_23059 = state_22962__$1;
(statearr_22979_23059[(1)] = (23));

} else {
var statearr_22980_23060 = state_22962__$1;
(statearr_22980_23060[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (31))){
var inst_22900 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
if(cljs.core.truth_(inst_22900)){
var statearr_22981_23061 = state_22962__$1;
(statearr_22981_23061[(1)] = (32));

} else {
var statearr_22982_23062 = state_22962__$1;
(statearr_22982_23062[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (32))){
var inst_22876 = (state_22962[(10)]);
var inst_22875 = (state_22962[(18)]);
var inst_22883 = (state_22962[(19)]);
var inst_22902 = (inst_22875 + (1));
var tmp22978 = inst_22876;
var inst_22874 = inst_22883;
var inst_22875__$1 = inst_22902;
var inst_22876__$1 = tmp22978;
var state_22962__$1 = (function (){var statearr_22983 = state_22962;
(statearr_22983[(20)] = inst_22874);

(statearr_22983[(10)] = inst_22876__$1);

(statearr_22983[(18)] = inst_22875__$1);

return statearr_22983;
})();
var statearr_22984_23063 = state_22962__$1;
(statearr_22984_23063[(2)] = null);

(statearr_22984_23063[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (40))){
var state_22962__$1 = state_22962;
if(cljs.core.truth_(fuel)){
var statearr_22985_23064 = state_22962__$1;
(statearr_22985_23064[(1)] = (42));

} else {
var statearr_22986_23065 = state_22962__$1;
(statearr_22986_23065[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (33))){
var state_22962__$1 = state_22962;
var statearr_22987_23066 = state_22962__$1;
(statearr_22987_23066[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (13))){
var inst_22852 = (state_22962[(12)]);
var state_22962__$1 = state_22962;
var statearr_22989_23067 = state_22962__$1;
(statearr_22989_23067[(2)] = inst_22852);

(statearr_22989_23067[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (22))){
var inst_22893 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
if(cljs.core.truth_(inst_22893)){
var statearr_22990_23068 = state_22962__$1;
(statearr_22990_23068[(1)] = (26));

} else {
var statearr_22991_23069 = state_22962__$1;
(statearr_22991_23069[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (36))){
var state_22962__$1 = state_22962;
var statearr_22992_23070 = state_22962__$1;
(statearr_22992_23070[(2)] = null);

(statearr_22992_23070[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (41))){
var inst_22875 = (state_22962[(18)]);
var inst_22883 = (state_22962[(19)]);
var inst_22932 = (state_22962[(2)]);
var inst_22933 = (inst_22875 + (1));
var inst_22874 = inst_22883;
var inst_22875__$1 = inst_22933;
var inst_22876 = inst_22932;
var state_22962__$1 = (function (){var statearr_22993 = state_22962;
(statearr_22993[(20)] = inst_22874);

(statearr_22993[(10)] = inst_22876);

(statearr_22993[(18)] = inst_22875__$1);

return statearr_22993;
})();
var statearr_22994_23071 = state_22962__$1;
(statearr_22994_23071[(2)] = null);

(statearr_22994_23071[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (43))){
var state_22962__$1 = state_22962;
var statearr_22995_23072 = state_22962__$1;
(statearr_22995_23072[(2)] = null);

(statearr_22995_23072[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (29))){
var inst_22839 = (state_22962[(8)]);
var inst_22875 = (state_22962[(18)]);
var inst_22897 = (inst_22875 < inst_22839);
var state_22962__$1 = state_22962;
var statearr_22996_23073 = state_22962__$1;
(statearr_22996_23073[(2)] = inst_22897);

(statearr_22996_23073[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (44))){
var inst_22912 = (state_22962[(21)]);
var inst_22916 = (state_22962[(22)]);
var inst_22925 = (state_22962[(2)]);
var inst_22926 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22916,inst_22912);
var state_22962__$1 = (function (){var statearr_22997 = state_22962;
(statearr_22997[(23)] = inst_22925);

return statearr_22997;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22962__$1,(45),inst_22926);
} else {
if((state_val_22963 === (6))){
var inst_22827 = (state_22962[(24)]);
var inst_22820 = (state_22962[(16)]);
var inst_22826 = cljs.core.seq.call(null,inst_22820);
var inst_22827__$1 = cljs.core.first.call(null,inst_22826);
var inst_22828 = cljs.core.next.call(null,inst_22826);
var inst_22829 = cljs.core.not.call(null,inst_22827__$1);
var state_22962__$1 = (function (){var statearr_22998 = state_22962;
(statearr_22998[(13)] = inst_22828);

(statearr_22998[(24)] = inst_22827__$1);

return statearr_22998;
})();
if(inst_22829){
var statearr_22999_23074 = state_22962__$1;
(statearr_22999_23074[(1)] = (8));

} else {
var statearr_23000_23075 = state_22962__$1;
(statearr_23000_23075[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (28))){
var inst_22941 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
var statearr_23001_23076 = state_22962__$1;
(statearr_23001_23076[(2)] = inst_22941);

(statearr_23001_23076[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (51))){
var inst_22949 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
var statearr_23002_23077 = state_22962__$1;
(statearr_23002_23077[(2)] = inst_22949);

(statearr_23002_23077[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (25))){
var inst_22891 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
var statearr_23003_23078 = state_22962__$1;
(statearr_23003_23078[(2)] = inst_22891);

(statearr_23003_23078[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (34))){
var inst_22939 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
var statearr_23004_23079 = state_22962__$1;
(statearr_23004_23079[(2)] = inst_22939);

(statearr_23004_23079[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (17))){
var inst_22852 = (state_22962[(12)]);
var inst_22862 = (state_22962[(2)]);
var inst_22870 = cljs.core.seq.call(null,inst_22852);
var inst_22871 = cljs.core.first.call(null,inst_22870);
var inst_22872 = cljs.core.next.call(null,inst_22870);
var inst_22873 = cljs.core.PersistentVector.EMPTY;
var inst_22874 = inst_22852;
var inst_22875 = (0);
var inst_22876 = inst_22873;
var state_22962__$1 = (function (){var statearr_23005 = state_22962;
(statearr_23005[(25)] = inst_22862);

(statearr_23005[(20)] = inst_22874);

(statearr_23005[(10)] = inst_22876);

(statearr_23005[(26)] = inst_22871);

(statearr_23005[(18)] = inst_22875);

(statearr_23005[(27)] = inst_22872);

return statearr_23005;
})();
var statearr_23006_23080 = state_22962__$1;
(statearr_23006_23080[(2)] = null);

(statearr_23006_23080[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (3))){
var inst_22960 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22962__$1,inst_22960);
} else {
if((state_val_22963 === (12))){
var state_22962__$1 = state_22962;
var statearr_23007_23081 = state_22962__$1;
(statearr_23007_23081[(2)] = fuel);

(statearr_23007_23081[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (2))){
var _ = (function (){var statearr_23008 = state_22962;
(statearr_23008[(4)] = cljs.core.cons.call(null,(5),(state_22962[(4)])));

return statearr_23008;
})();
var inst_22816 = reverse_refs_specs;
var inst_22817 = cljs.core.seq.call(null,inst_22816);
var inst_22818 = cljs.core.first.call(null,inst_22817);
var inst_22819 = cljs.core.next.call(null,inst_22817);
var inst_22820 = inst_22816;
var inst_22821 = null;
var state_22962__$1 = (function (){var statearr_23009 = state_22962;
(statearr_23009[(28)] = inst_22819);

(statearr_23009[(29)] = inst_22818);

(statearr_23009[(14)] = inst_22821);

(statearr_23009[(16)] = inst_22820);

return statearr_23009;
})();
var statearr_23010_23082 = state_22962__$1;
(statearr_23010_23082[(2)] = null);

(statearr_23010_23082[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (23))){
var inst_22840 = (state_22962[(9)]);
var inst_22875 = (state_22962[(18)]);
var inst_22888 = (inst_22875 >= inst_22840);
var state_22962__$1 = state_22962;
var statearr_23011_23083 = state_22962__$1;
(statearr_23011_23083[(2)] = inst_22888);

(statearr_23011_23083[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (47))){
var inst_22842 = (state_22962[(30)]);
var state_22962__$1 = state_22962;
if(cljs.core.truth_(inst_22842)){
var statearr_23012_23084 = state_22962__$1;
(statearr_23012_23084[(1)] = (49));

} else {
var statearr_23013_23085 = state_22962__$1;
(statearr_23013_23085[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (35))){
var inst_22882 = (state_22962[(31)]);
var inst_22906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22907 = [inst_22882];
var inst_22908 = (new cljs.core.PersistentVector(null,1,(5),inst_22906,inst_22907,null));
var inst_22909 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22908);
var state_22962__$1 = state_22962;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22962__$1,(38),inst_22909);
} else {
if((state_val_22963 === (19))){
var inst_22841 = (state_22962[(11)]);
var inst_22943 = (state_22962[(2)]);
var state_22962__$1 = (function (){var statearr_23014 = state_22962;
(statearr_23014[(15)] = inst_22943);

return statearr_23014;
})();
if(cljs.core.truth_(inst_22841)){
var statearr_23015_23086 = state_22962__$1;
(statearr_23015_23086[(1)] = (46));

} else {
var statearr_23016_23087 = state_22962__$1;
(statearr_23016_23087[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (11))){
var inst_22852 = (state_22962[(12)]);
var inst_22849 = (state_22962[(2)]);
var inst_22850 = fluree.db.util.async.throw_err.call(null,inst_22849);
var inst_22851 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_22850);
var inst_22852__$1 = cljs.core.not_empty.call(null,inst_22851);
var state_22962__$1 = (function (){var statearr_23018 = state_22962;
(statearr_23018[(12)] = inst_22852__$1);

return statearr_23018;
})();
if(cljs.core.truth_(inst_22852__$1)){
var statearr_23019_23088 = state_22962__$1;
(statearr_23019_23088[(1)] = (12));

} else {
var statearr_23020_23089 = state_22962__$1;
(statearr_23020_23089[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (9))){
var inst_22837 = (state_22962[(32)]);
var inst_22827 = (state_22962[(24)]);
var inst_22836 = cljs.core.nth.call(null,inst_22827,(0),null);
var inst_22837__$1 = cljs.core.nth.call(null,inst_22827,(1),null);
var inst_22838 = cljs.core.__destructure_map.call(null,inst_22837__$1);
var inst_22839 = cljs.core.get.call(null,inst_22838,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22840 = cljs.core.get.call(null,inst_22838,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22841 = cljs.core.get.call(null,inst_22838,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22842 = cljs.core.get.call(null,inst_22838,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22843 = cljs.core.get.call(null,inst_22838,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22845 = [subject_id,inst_22836];
var inst_22846 = (new cljs.core.PersistentVector(null,2,(5),inst_22844,inst_22845,null));
var inst_22847 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22846);
var state_22962__$1 = (function (){var statearr_23021 = state_22962;
(statearr_23021[(17)] = inst_22843);

(statearr_23021[(30)] = inst_22842);

(statearr_23021[(32)] = inst_22837__$1);

(statearr_23021[(9)] = inst_22840);

(statearr_23021[(8)] = inst_22839);

(statearr_23021[(11)] = inst_22841);

return statearr_23021;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22962__$1,(11),inst_22847);
} else {
if((state_val_22963 === (5))){
var _ = (function (){var statearr_23022 = state_22962;
(statearr_23022[(4)] = cljs.core.rest.call(null,(state_22962[(4)])));

return statearr_23022;
})();
var state_22962__$1 = state_22962;
var ex23017 = (state_22962__$1[(2)]);
var statearr_23023_23090 = state_22962__$1;
(statearr_23023_23090[(5)] = ex23017);


if((ex23017 instanceof Error)){
var statearr_23024_23091 = state_22962__$1;
(statearr_23024_23091[(1)] = (4));

(statearr_23024_23091[(5)] = null);

} else {
throw ex23017;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (14))){
var inst_22856 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
if(cljs.core.truth_(inst_22856)){
var statearr_23025_23092 = state_22962__$1;
(statearr_23025_23092[(1)] = (15));

} else {
var statearr_23026_23093 = state_22962__$1;
(statearr_23026_23093[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (45))){
var inst_22876 = (state_22962[(10)]);
var inst_22928 = (state_22962[(2)]);
var inst_22929 = fluree.db.util.async.throw_err.call(null,inst_22928);
var inst_22930 = cljs.core.conj.call(null,inst_22876,inst_22929);
var state_22962__$1 = state_22962;
var statearr_23027_23094 = state_22962__$1;
(statearr_23027_23094[(2)] = inst_22930);

(statearr_23027_23094[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (26))){
var inst_22876 = (state_22962[(10)]);
var state_22962__$1 = state_22962;
var statearr_23028_23095 = state_22962__$1;
(statearr_23028_23095[(2)] = inst_22876);

(statearr_23028_23095[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (16))){
var state_22962__$1 = state_22962;
var statearr_23029_23096 = state_22962__$1;
(statearr_23029_23096[(2)] = null);

(statearr_23029_23096[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (38))){
var inst_22912 = (state_22962[(21)]);
var inst_22837 = (state_22962[(32)]);
var inst_22911 = (state_22962[(2)]);
var inst_22912__$1 = fluree.db.util.async.throw_err.call(null,inst_22911);
var inst_22913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22914 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22915 = (new cljs.core.PersistentVector(null,4,(5),inst_22913,inst_22914,null));
var inst_22916 = cljs.core.select_keys.call(null,inst_22837,inst_22915);
var inst_22917 = cljs.core.empty_QMARK_.call(null,inst_22912__$1);
var state_22962__$1 = (function (){var statearr_23030 = state_22962;
(statearr_23030[(21)] = inst_22912__$1);

(statearr_23030[(22)] = inst_22916);

return statearr_23030;
})();
if(inst_22917){
var statearr_23031_23097 = state_22962__$1;
(statearr_23031_23097[(1)] = (39));

} else {
var statearr_23032_23098 = state_22962__$1;
(statearr_23032_23098[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (30))){
var inst_22839 = (state_22962[(8)]);
var state_22962__$1 = state_22962;
var statearr_23033_23099 = state_22962__$1;
(statearr_23033_23099[(2)] = inst_22839);

(statearr_23033_23099[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (10))){
var inst_22955 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
var statearr_23034_23100 = state_22962__$1;
(statearr_23034_23100[(2)] = inst_22955);

(statearr_23034_23100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (18))){
var inst_22874 = (state_22962[(20)]);
var inst_22882 = (state_22962[(31)]);
var inst_22884 = (state_22962[(7)]);
var inst_22881 = cljs.core.seq.call(null,inst_22874);
var inst_22882__$1 = cljs.core.first.call(null,inst_22881);
var inst_22883 = cljs.core.next.call(null,inst_22881);
var inst_22884__$1 = cljs.core.not.call(null,inst_22882__$1);
var state_22962__$1 = (function (){var statearr_23035 = state_22962;
(statearr_23035[(31)] = inst_22882__$1);

(statearr_23035[(7)] = inst_22884__$1);

(statearr_23035[(19)] = inst_22883);

return statearr_23035;
})();
if(inst_22884__$1){
var statearr_23036_23101 = state_22962__$1;
(statearr_23036_23101[(1)] = (20));

} else {
var statearr_23037_23102 = state_22962__$1;
(statearr_23037_23102[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (42))){
var inst_22912 = (state_22962[(21)]);
var inst_22921 = cljs.core.count.call(null,inst_22912);
var inst_22922 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22921,max_fuel);
var state_22962__$1 = state_22962;
var statearr_23038_23103 = state_22962__$1;
(statearr_23038_23103[(2)] = inst_22922);

(statearr_23038_23103[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (37))){
var inst_22937 = (state_22962[(2)]);
var state_22962__$1 = state_22962;
var statearr_23039_23104 = state_22962__$1;
(statearr_23039_23104[(2)] = inst_22937);

(statearr_23039_23104[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (8))){
var inst_22821 = (state_22962[(14)]);
var state_22962__$1 = state_22962;
var statearr_23040_23105 = state_22962__$1;
(statearr_23040_23105[(2)] = inst_22821);

(statearr_23040_23105[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22963 === (49))){
var inst_22842 = (state_22962[(30)]);
var state_22962__$1 = state_22962;
var statearr_23041_23106 = state_22962__$1;
(statearr_23041_23106[(2)] = inst_22842);

(statearr_23041_23106[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto____0 = (function (){
var statearr_23042 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23042[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto__);

(statearr_23042[(1)] = (1));

return statearr_23042;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto____1 = (function (state_22962){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_22962);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e23043){var ex__2729__auto__ = e23043;
var statearr_23044_23107 = state_22962;
(statearr_23044_23107[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_22962[(4)]))){
var statearr_23045_23108 = state_22962;
(statearr_23045_23108[(1)] = cljs.core.first.call(null,(state_22962[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23109 = state_22962;
state_22962 = G__23109;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto__ = function(state_22962){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto____1.call(this,state_22962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_23046 = f__2749__auto__.call(null);
(statearr_23046[(6)] = c__2748__auto__);

return statearr_23046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23110 = select_spec;
var map__23110__$1 = cljs.core.__destructure_map.call(null,map__23110);
var recur_seen = cljs.core.get.call(null,map__23110__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__23110__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_23172){
var state_val_23173 = (state_23172[(1)]);
if((state_val_23173 === (7))){
var inst_23136 = (state_23172[(7)]);
var inst_23138 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_23139 = cljs.core.sequence.call(null,inst_23138,inst_23136);
var state_23172__$1 = state_23172;
var statearr_23174_23213 = state_23172__$1;
(statearr_23174_23213[(2)] = inst_23139);

(statearr_23174_23213[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (20))){
var inst_23142 = (state_23172[(8)]);
var inst_23160 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,flake);
var inst_23161 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23160,inst_23142);
var state_23172__$1 = state_23172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23172__$1,(22),inst_23161);
} else {
if((state_val_23173 === (1))){
var state_23172__$1 = state_23172;
var statearr_23175_23214 = state_23172__$1;
(statearr_23175_23214[(2)] = null);

(statearr_23175_23214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (4))){
var inst_23111 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23176_23215 = state_23172__$1;
(statearr_23176_23215[(2)] = inst_23111);

(statearr_23176_23215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (15))){
var inst_23149 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
var statearr_23177_23216 = state_23172__$1;
(statearr_23177_23216[(2)] = inst_23149);

(statearr_23177_23216[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (21))){
var inst_23167 = (state_23172[(2)]);
var _ = (function (){var statearr_23178 = state_23172;
(statearr_23178[(4)] = cljs.core.rest.call(null,(state_23172[(4)])));

return statearr_23178;
})();
var state_23172__$1 = state_23172;
var statearr_23179_23217 = state_23172__$1;
(statearr_23179_23217[(2)] = inst_23167);

(statearr_23179_23217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (13))){
var inst_23128 = (state_23172[(9)]);
var state_23172__$1 = state_23172;
var statearr_23180_23218 = state_23172__$1;
(statearr_23180_23218[(2)] = inst_23128);

(statearr_23180_23218[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (22))){
var inst_23157 = (state_23172[(10)]);
var inst_23122 = (state_23172[(11)]);
var inst_23163 = (state_23172[(2)]);
var inst_23164 = fluree.db.util.async.throw_err.call(null,inst_23163);
var inst_23165 = inst_23157.call(null,acc,inst_23122,inst_23164);
var state_23172__$1 = state_23172;
var statearr_23181_23219 = state_23172__$1;
(statearr_23181_23219[(2)] = inst_23165);

(statearr_23181_23219[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (6))){
var inst_23135 = (state_23172[(2)]);
var inst_23136 = fluree.db.util.async.throw_err.call(null,inst_23135);
var state_23172__$1 = (function (){var statearr_23182 = state_23172;
(statearr_23182[(7)] = inst_23136);

return statearr_23182;
})();
if(cljs.core.truth_(fuel)){
var statearr_23183_23220 = state_23172__$1;
(statearr_23183_23220[(1)] = (7));

} else {
var statearr_23184_23221 = state_23172__$1;
(statearr_23184_23221[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (17))){
var inst_23124 = (state_23172[(12)]);
var inst_23125 = (state_23172[(13)]);
var inst_23128 = (state_23172[(9)]);
var inst_23118 = (state_23172[(14)]);
var inst_23142 = (state_23172[(8)]);
var inst_23121 = (state_23172[(15)]);
var inst_23123 = (state_23172[(16)]);
var inst_23151 = (state_23172[(17)]);
var inst_23122 = (state_23172[(11)]);
var inst_23120 = (state_23172[(18)]);
var inst_23126 = (state_23172[(19)]);
var inst_23127 = (state_23172[(20)]);
var inst_23155 = (function (){var recur_seen = inst_23124;
var map__23117 = inst_23120;
var recur_subject = inst_23118;
var sub_flakes = inst_23142;
var seen_QMARK_ = inst_23127;
var multi_QMARK_ = inst_23121;
var limit = inst_23126;
var recur_depth = inst_23125;
var as = inst_23122;
var max_depth_QMARK_ = inst_23128;
var recur = inst_23123;
var stop_QMARK_ = inst_23151;
return (function (results,as__$1,new_result){
return cljs.core.assoc.call(null,results,as__$1,new_result);
});
})();
var state_23172__$1 = state_23172;
var statearr_23185_23222 = state_23172__$1;
(statearr_23185_23222[(2)] = inst_23155);

(statearr_23185_23222[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (3))){
var inst_23170 = (state_23172[(2)]);
var state_23172__$1 = state_23172;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23172__$1,inst_23170);
} else {
if((state_val_23173 === (12))){
var inst_23121 = (state_23172[(15)]);
var inst_23151 = (state_23172[(2)]);
var state_23172__$1 = (function (){var statearr_23186 = state_23172;
(statearr_23186[(17)] = inst_23151);

return statearr_23186;
})();
if(cljs.core.truth_(inst_23121)){
var statearr_23187_23223 = state_23172__$1;
(statearr_23187_23223[(1)] = (16));

} else {
var statearr_23188_23224 = state_23172__$1;
(statearr_23188_23224[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (2))){
var inst_23124 = (state_23172[(12)]);
var inst_23125 = (state_23172[(13)]);
var inst_23118 = (state_23172[(14)]);
var inst_23123 = (state_23172[(16)]);
var inst_23120 = (state_23172[(18)]);
var _ = (function (){var statearr_23189 = state_23172;
(statearr_23189[(4)] = cljs.core.cons.call(null,(5),(state_23172[(4)])));

return statearr_23189;
})();
var inst_23118__$1 = flake.o;
var inst_23119 = select_spec;
var inst_23120__$1 = cljs.core.__destructure_map.call(null,inst_23119);
var inst_23121 = cljs.core.get.call(null,inst_23120__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23122 = cljs.core.get.call(null,inst_23120__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23123__$1 = cljs.core.get.call(null,inst_23120__$1,new cljs.core.Keyword(null,"recur","recur",-437573268));
var inst_23124__$1 = cljs.core.get.call(null,inst_23120__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23125__$1 = cljs.core.get.call(null,inst_23120__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23126 = cljs.core.get.call(null,inst_23120__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23127 = cljs.core.contains_QMARK_.call(null,inst_23124__$1,inst_23118__$1);
var inst_23128 = (inst_23125__$1 > inst_23123__$1);
var inst_23130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23131 = [inst_23118__$1];
var inst_23132 = (new cljs.core.PersistentVector(null,1,(5),inst_23130,inst_23131,null));
var inst_23133 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23132);
var state_23172__$1 = (function (){var statearr_23190 = state_23172;
(statearr_23190[(12)] = inst_23124__$1);

(statearr_23190[(13)] = inst_23125__$1);

(statearr_23190[(9)] = inst_23128);

(statearr_23190[(14)] = inst_23118__$1);

(statearr_23190[(15)] = inst_23121);

(statearr_23190[(16)] = inst_23123__$1);

(statearr_23190[(11)] = inst_23122);

(statearr_23190[(18)] = inst_23120__$1);

(statearr_23190[(19)] = inst_23126);

(statearr_23190[(20)] = inst_23127);

return statearr_23190;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23172__$1,(6),inst_23133);
} else {
if((state_val_23173 === (19))){
var state_23172__$1 = state_23172;
var statearr_23191_23225 = state_23172__$1;
(statearr_23191_23225[(2)] = acc);

(statearr_23191_23225[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (11))){
var inst_23128 = (state_23172[(9)]);
var state_23172__$1 = state_23172;
if(cljs.core.truth_(inst_23128)){
var statearr_23193_23226 = state_23172__$1;
(statearr_23193_23226[(1)] = (13));

} else {
var statearr_23194_23227 = state_23172__$1;
(statearr_23194_23227[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (9))){
var inst_23127 = (state_23172[(20)]);
var inst_23142 = (state_23172[(2)]);
var state_23172__$1 = (function (){var statearr_23195 = state_23172;
(statearr_23195[(8)] = inst_23142);

return statearr_23195;
})();
if(cljs.core.truth_(inst_23127)){
var statearr_23196_23228 = state_23172__$1;
(statearr_23196_23228[(1)] = (10));

} else {
var statearr_23197_23229 = state_23172__$1;
(statearr_23197_23229[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (5))){
var _ = (function (){var statearr_23198 = state_23172;
(statearr_23198[(4)] = cljs.core.rest.call(null,(state_23172[(4)])));

return statearr_23198;
})();
var state_23172__$1 = state_23172;
var ex23192 = (state_23172__$1[(2)]);
var statearr_23199_23230 = state_23172__$1;
(statearr_23199_23230[(5)] = ex23192);


if((ex23192 instanceof Error)){
var statearr_23200_23231 = state_23172__$1;
(statearr_23200_23231[(1)] = (4));

(statearr_23200_23231[(5)] = null);

} else {
throw ex23192;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (14))){
var inst_23142 = (state_23172[(8)]);
var inst_23147 = cljs.core.empty_QMARK_.call(null,inst_23142);
var state_23172__$1 = state_23172;
var statearr_23201_23232 = state_23172__$1;
(statearr_23201_23232[(2)] = inst_23147);

(statearr_23201_23232[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (16))){
var inst_23124 = (state_23172[(12)]);
var inst_23125 = (state_23172[(13)]);
var inst_23128 = (state_23172[(9)]);
var inst_23118 = (state_23172[(14)]);
var inst_23142 = (state_23172[(8)]);
var inst_23121 = (state_23172[(15)]);
var inst_23123 = (state_23172[(16)]);
var inst_23151 = (state_23172[(17)]);
var inst_23122 = (state_23172[(11)]);
var inst_23120 = (state_23172[(18)]);
var inst_23126 = (state_23172[(19)]);
var inst_23127 = (state_23172[(20)]);
var inst_23153 = (function (){var recur_seen = inst_23124;
var map__23117 = inst_23120;
var recur_subject = inst_23118;
var sub_flakes = inst_23142;
var seen_QMARK_ = inst_23127;
var multi_QMARK_ = inst_23121;
var limit = inst_23126;
var recur_depth = inst_23125;
var as = inst_23122;
var max_depth_QMARK_ = inst_23128;
var recur = inst_23123;
var stop_QMARK_ = inst_23151;
return (function (results,as__$1,new_result){
return cljs.core.update.call(null,results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_23172__$1 = state_23172;
var statearr_23202_23233 = state_23172__$1;
(statearr_23202_23233[(2)] = inst_23153);

(statearr_23202_23233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (10))){
var inst_23127 = (state_23172[(20)]);
var state_23172__$1 = state_23172;
var statearr_23203_23234 = state_23172__$1;
(statearr_23203_23234[(2)] = inst_23127);

(statearr_23203_23234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (18))){
var inst_23151 = (state_23172[(17)]);
var inst_23157 = (state_23172[(2)]);
var state_23172__$1 = (function (){var statearr_23204 = state_23172;
(statearr_23204[(10)] = inst_23157);

return statearr_23204;
})();
if(cljs.core.truth_(inst_23151)){
var statearr_23205_23235 = state_23172__$1;
(statearr_23205_23235[(1)] = (19));

} else {
var statearr_23206_23236 = state_23172__$1;
(statearr_23206_23236[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23173 === (8))){
var inst_23136 = (state_23172[(7)]);
var state_23172__$1 = state_23172;
var statearr_23207_23237 = state_23172__$1;
(statearr_23207_23237[(2)] = inst_23136);

(statearr_23207_23237[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto____0 = (function (){
var statearr_23208 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23208[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto__);

(statearr_23208[(1)] = (1));

return statearr_23208;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto____1 = (function (state_23172){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_23172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e23209){var ex__2729__auto__ = e23209;
var statearr_23210_23238 = state_23172;
(statearr_23210_23238[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_23172[(4)]))){
var statearr_23211_23239 = state_23172;
(statearr_23211_23239[(1)] = cljs.core.first.call(null,(state_23172[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23240 = state_23172;
state_23172 = G__23240;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto__ = function(state_23172){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto____1.call(this,state_23172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_23212 = f__2749__auto__.call(null);
(statearr_23212[(6)] = c__2748__auto__);

return statearr_23212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_23418){
var state_val_23419 = (state_23418[(1)]);
if((state_val_23419 === (7))){
var state_23418__$1 = state_23418;
var statearr_23420_23506 = state_23418__$1;
(statearr_23420_23506[(2)] = null);

(statearr_23420_23506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (20))){
var inst_23279 = cljs.core.PersistentHashMap.EMPTY;
var state_23418__$1 = state_23418;
var statearr_23421_23507 = state_23418__$1;
(statearr_23421_23507[(2)] = inst_23279);

(statearr_23421_23507[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (27))){
var inst_23267 = (state_23418[(7)]);
var inst_23297 = (state_23418[(8)]);
var inst_23281 = (state_23418[(9)]);
var inst_23261 = (state_23418[(10)]);
var inst_23397 = (state_23418[(2)]);
var inst_23398 = (function (){var top_level_subject = inst_23261;
var select_spec = inst_23267;
var base_acc = inst_23281;
var acc_PLUS_refs = inst_23297;
var result = inst_23397;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23399 = cljs.core.PersistentVector.EMPTY;
var inst_23400 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23267);
var inst_23401 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23400);
var inst_23402 = cljs.core.vals.call(null,inst_23401);
var inst_23403 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23267);
var inst_23404 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23403);
var inst_23405 = cljs.core.vals.call(null,inst_23404);
var inst_23406 = cljs.core.concat.call(null,inst_23402,inst_23405);
var inst_23407 = cljs.core.reduce.call(null,inst_23398,inst_23399,inst_23406);
var inst_23409 = (function (){var top_level_subject = inst_23261;
var select_spec = inst_23267;
var base_acc = inst_23281;
var acc_PLUS_refs = inst_23297;
var result = inst_23397;
var sort_preds = inst_23407;
return (function (acc,p__23408){
var vec__23422 = p__23408;
var selectPred = cljs.core.nth.call(null,vec__23422,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23422,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23422,(2),null);
var limit = cljs.core.nth.call(null,vec__23422,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23410 = cljs.core.reduce.call(null,inst_23409,inst_23397,inst_23407);
var state_23418__$1 = state_23418;
var statearr_23425_23508 = state_23418__$1;
(statearr_23425_23508[(2)] = inst_23410);

(statearr_23425_23508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (1))){
var state_23418__$1 = state_23418;
var statearr_23426_23509 = state_23418__$1;
(statearr_23426_23509[(2)] = null);

(statearr_23426_23509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (24))){
var inst_23297 = (state_23418[(8)]);
var inst_23297__$1 = (state_23418[(2)]);
var inst_23298 = flakes;
var inst_23299 = cljs.core.PersistentHashMap.EMPTY;
var inst_23300 = inst_23298;
var inst_23301 = inst_23297__$1;
var inst_23302 = inst_23299;
var state_23418__$1 = (function (){var statearr_23427 = state_23418;
(statearr_23427[(11)] = inst_23302);

(statearr_23427[(12)] = inst_23300);

(statearr_23427[(8)] = inst_23297__$1);

(statearr_23427[(13)] = inst_23301);

return statearr_23427;
})();
var statearr_23428_23510 = state_23418__$1;
(statearr_23428_23510[(2)] = null);

(statearr_23428_23510[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (39))){
var inst_23310 = (state_23418[(14)]);
var inst_23316 = (state_23418[(15)]);
var inst_23267 = (state_23418[(7)]);
var inst_23301 = (state_23418[(13)]);
var inst_23345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23346 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23301,inst_23267,inst_23310,inst_23316,false);
var state_23418__$1 = (function (){var statearr_23429 = state_23418;
(statearr_23429[(16)] = inst_23345);

return statearr_23429;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23418__$1,(42),inst_23346);
} else {
if((state_val_23419 === (46))){
var inst_23310 = (state_23418[(14)]);
var inst_23302 = (state_23418[(11)]);
var inst_23300 = (state_23418[(12)]);
var inst_23363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23364 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23365 = inst_23310.s;
var inst_23366 = [inst_23365];
var inst_23367 = cljs.core.PersistentHashMap.fromArrays(inst_23364,inst_23366);
var inst_23368 = cljs.core.rest.call(null,inst_23300);
var inst_23369 = [inst_23367,inst_23368,inst_23302];
var inst_23370 = (new cljs.core.PersistentVector(null,3,(5),inst_23363,inst_23369,null));
var state_23418__$1 = state_23418;
var statearr_23430_23511 = state_23418__$1;
(statearr_23430_23511[(2)] = inst_23370);

(statearr_23430_23511[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (4))){
var inst_23241 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
var statearr_23431_23512 = state_23418__$1;
(statearr_23431_23512[(2)] = inst_23241);

(statearr_23431_23512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (15))){
var inst_23268 = (state_23418[(17)]);
var inst_23267 = (state_23418[(7)]);
var inst_23267__$1 = (state_23418[(2)]);
var inst_23268__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23267__$1);
var state_23418__$1 = (function (){var statearr_23432 = state_23418;
(statearr_23432[(17)] = inst_23268__$1);

(statearr_23432[(7)] = inst_23267__$1);

return statearr_23432;
})();
if(cljs.core.truth_(inst_23268__$1)){
var statearr_23433_23513 = state_23418__$1;
(statearr_23433_23513[(1)] = (16));

} else {
var statearr_23434_23514 = state_23418__$1;
(statearr_23434_23514[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (48))){
var inst_23381 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
var statearr_23435_23515 = state_23418__$1;
(statearr_23435_23515[(2)] = inst_23381);

(statearr_23435_23515[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (50))){
var state_23418__$1 = state_23418;
var statearr_23436_23516 = state_23418__$1;
(statearr_23436_23516[(2)] = null);

(statearr_23436_23516[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (21))){
var inst_23267 = (state_23418[(7)]);
var inst_23281 = (state_23418[(2)]);
var inst_23282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23283 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23284 = (new cljs.core.PersistentVector(null,2,(5),inst_23282,inst_23283,null));
var inst_23285 = cljs.core.get_in.call(null,inst_23267,inst_23284);
var state_23418__$1 = (function (){var statearr_23437 = state_23418;
(statearr_23437[(9)] = inst_23281);

return statearr_23437;
})();
if(cljs.core.truth_(inst_23285)){
var statearr_23438_23517 = state_23418__$1;
(statearr_23438_23517[(1)] = (22));

} else {
var statearr_23439_23518 = state_23418__$1;
(statearr_23439_23518[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (31))){
var inst_23315 = (state_23418[(18)]);
var inst_23310 = (state_23418[(14)]);
var inst_23301 = (state_23418[(13)]);
var inst_23319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23320 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_23310,inst_23315,inst_23301,fuel,max_fuel,cache);
var state_23418__$1 = (function (){var statearr_23440 = state_23418;
(statearr_23440[(19)] = inst_23319);

return statearr_23440;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23418__$1,(34),inst_23320);
} else {
if((state_val_23419 === (32))){
var inst_23315 = (state_23418[(18)]);
var state_23418__$1 = state_23418;
if(cljs.core.truth_(inst_23315)){
var statearr_23441_23519 = state_23418__$1;
(statearr_23441_23519[(1)] = (35));

} else {
var statearr_23442_23520 = state_23418__$1;
(statearr_23442_23520[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (40))){
var inst_23267 = (state_23418[(7)]);
var inst_23356 = (state_23418[(20)]);
var inst_23355 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23267);
var inst_23356__$1 = cljs.core.empty_QMARK_.call(null,inst_23355);
var state_23418__$1 = (function (){var statearr_23443 = state_23418;
(statearr_23443[(20)] = inst_23356__$1);

return statearr_23443;
})();
if(inst_23356__$1){
var statearr_23444_23521 = state_23418__$1;
(statearr_23444_23521[(1)] = (43));

} else {
var statearr_23445_23522 = state_23418__$1;
(statearr_23445_23522[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (33))){
var inst_23310 = (state_23418[(14)]);
var inst_23387 = (state_23418[(2)]);
var inst_23388 = cljs.core.nth.call(null,inst_23387,(0),null);
var inst_23389 = cljs.core.nth.call(null,inst_23387,(1),null);
var inst_23390 = cljs.core.nth.call(null,inst_23387,(2),null);
var inst_23391 = inst_23310.s;
var inst_23392 = cljs.core.assoc.call(null,inst_23388,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23391);
var inst_23300 = inst_23389;
var inst_23301 = inst_23392;
var inst_23302 = inst_23390;
var state_23418__$1 = (function (){var statearr_23446 = state_23418;
(statearr_23446[(11)] = inst_23302);

(statearr_23446[(12)] = inst_23300);

(statearr_23446[(13)] = inst_23301);

return statearr_23446;
})();
var statearr_23447_23523 = state_23418__$1;
(statearr_23447_23523[(2)] = null);

(statearr_23447_23523[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (13))){
var inst_23261 = (state_23418[(10)]);
var inst_23264 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_23261);
var state_23418__$1 = state_23418;
var statearr_23448_23524 = state_23418__$1;
(statearr_23448_23524[(2)] = inst_23264);

(statearr_23448_23524[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (22))){
var inst_23267 = (state_23418[(7)]);
var inst_23287 = cljs.core.first.call(null,flakes);
var inst_23288 = fluree.db.query.fql.s.call(null,inst_23287);
var inst_23289 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_23267);
var inst_23290 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23288,inst_23289);
var state_23418__$1 = state_23418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23418__$1,(25),inst_23290);
} else {
if((state_val_23419 === (36))){
var inst_23267 = (state_23418[(7)]);
var inst_23343 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23267);
var state_23418__$1 = state_23418;
if(cljs.core.truth_(inst_23343)){
var statearr_23449_23525 = state_23418__$1;
(statearr_23449_23525[(1)] = (39));

} else {
var statearr_23450_23526 = state_23418__$1;
(statearr_23450_23526[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (41))){
var inst_23383 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
var statearr_23451_23527 = state_23418__$1;
(statearr_23451_23527[(2)] = inst_23383);

(statearr_23451_23527[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (43))){
var inst_23267 = (state_23418[(7)]);
var inst_23358 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23267);
var state_23418__$1 = state_23418;
var statearr_23452_23528 = state_23418__$1;
(statearr_23452_23528[(2)] = inst_23358);

(statearr_23452_23528[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (29))){
var inst_23315 = (state_23418[(18)]);
var inst_23310 = (state_23418[(14)]);
var inst_23267 = (state_23418[(7)]);
var inst_23300 = (state_23418[(12)]);
var inst_23310__$1 = cljs.core.first.call(null,inst_23300);
var inst_23311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23312 = inst_23310__$1.p;
var inst_23313 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23312];
var inst_23314 = (new cljs.core.PersistentVector(null,3,(5),inst_23311,inst_23313,null));
var inst_23315__$1 = cljs.core.get_in.call(null,inst_23267,inst_23314);
var inst_23316 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_23315__$1,inst_23267);
var inst_23317 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23315__$1);
var state_23418__$1 = (function (){var statearr_23453 = state_23418;
(statearr_23453[(18)] = inst_23315__$1);

(statearr_23453[(14)] = inst_23310__$1);

(statearr_23453[(15)] = inst_23316);

return statearr_23453;
})();
if(cljs.core.truth_(inst_23317)){
var statearr_23454_23529 = state_23418__$1;
(statearr_23454_23529[(1)] = (31));

} else {
var statearr_23455_23530 = state_23418__$1;
(statearr_23455_23530[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (44))){
var inst_23356 = (state_23418[(20)]);
var state_23418__$1 = state_23418;
var statearr_23456_23531 = state_23418__$1;
(statearr_23456_23531[(2)] = inst_23356);

(statearr_23456_23531[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (6))){
var state_23418__$1 = state_23418;
var statearr_23457_23532 = state_23418__$1;
(statearr_23457_23532[(2)] = null);

(statearr_23457_23532[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (28))){
var inst_23301 = (state_23418[(13)]);
var state_23418__$1 = state_23418;
var statearr_23458_23533 = state_23418__$1;
(statearr_23458_23533[(2)] = inst_23301);

(statearr_23458_23533[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (51))){
var inst_23379 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
var statearr_23459_23534 = state_23418__$1;
(statearr_23459_23534[(2)] = inst_23379);

(statearr_23459_23534[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (25))){
var inst_23281 = (state_23418[(9)]);
var inst_23292 = (state_23418[(2)]);
var inst_23293 = fluree.db.util.async.throw_err.call(null,inst_23292);
var inst_23294 = cljs.core.merge.call(null,inst_23281,inst_23293);
var state_23418__$1 = state_23418;
var statearr_23460_23535 = state_23418__$1;
(statearr_23460_23535[(2)] = inst_23294);

(statearr_23460_23535[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (34))){
var inst_23302 = (state_23418[(11)]);
var inst_23300 = (state_23418[(12)]);
var inst_23319 = (state_23418[(19)]);
var inst_23322 = (state_23418[(2)]);
var inst_23323 = fluree.db.util.async.throw_err.call(null,inst_23322);
var inst_23324 = cljs.core.rest.call(null,inst_23300);
var inst_23325 = [inst_23323,inst_23324,inst_23302];
var inst_23326 = (new cljs.core.PersistentVector(null,3,(5),inst_23319,inst_23325,null));
var state_23418__$1 = state_23418;
var statearr_23461_23536 = state_23418__$1;
(statearr_23461_23536[(2)] = inst_23326);

(statearr_23461_23536[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (17))){
var inst_23267 = (state_23418[(7)]);
var inst_23271 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23267);
var state_23418__$1 = state_23418;
var statearr_23463_23537 = state_23418__$1;
(statearr_23463_23537[(2)] = inst_23271);

(statearr_23463_23537[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (3))){
var inst_23416 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23418__$1,inst_23416);
} else {
if((state_val_23419 === (12))){
var _ = (function (){var statearr_23464 = state_23418;
(statearr_23464[(4)] = cljs.core.rest.call(null,(state_23418[(4)])));

return statearr_23464;
})();
var state_23418__$1 = state_23418;
var ex23462 = (state_23418__$1[(2)]);
var statearr_23465_23538 = state_23418__$1;
(statearr_23465_23538[(5)] = ex23462);


var statearr_23466_23539 = state_23418__$1;
(statearr_23466_23539[(1)] = (11));

(statearr_23466_23539[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (2))){
var _ = (function (){var statearr_23467 = state_23418;
(statearr_23467[(4)] = cljs.core.cons.call(null,(5),(state_23418[(4)])));

return statearr_23467;
})();
var inst_23247 = cljs.core.not_empty.call(null,flakes);
var state_23418__$1 = state_23418;
if(cljs.core.truth_(inst_23247)){
var statearr_23468_23540 = state_23418__$1;
(statearr_23468_23540[(1)] = (6));

} else {
var statearr_23469_23541 = state_23418__$1;
(statearr_23469_23541[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (23))){
var inst_23281 = (state_23418[(9)]);
var state_23418__$1 = state_23418;
var statearr_23470_23542 = state_23418__$1;
(statearr_23470_23542[(2)] = inst_23281);

(statearr_23470_23542[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (47))){
var state_23418__$1 = state_23418;
var statearr_23471_23543 = state_23418__$1;
(statearr_23471_23543[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (35))){
var inst_23315 = (state_23418[(18)]);
var inst_23310 = (state_23418[(14)]);
var inst_23316 = (state_23418[(15)]);
var inst_23302 = (state_23418[(11)]);
var inst_23301 = (state_23418[(13)]);
var inst_23332 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23301,inst_23315,inst_23310,inst_23316,false,inst_23302);
var state_23418__$1 = state_23418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23418__$1,(38),inst_23332);
} else {
if((state_val_23419 === (19))){
var inst_23261 = (state_23418[(10)]);
var inst_23275 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23276 = [inst_23261];
var inst_23277 = cljs.core.PersistentHashMap.fromArrays(inst_23275,inst_23276);
var state_23418__$1 = state_23418;
var statearr_23473_23544 = state_23418__$1;
(statearr_23473_23544[(2)] = inst_23277);

(statearr_23473_23544[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (11))){
var inst_23249 = (state_23418[(2)]);
var inst_23250 = fluree.db.util.log.error.call(null,inst_23249);
var inst_23251 = (function(){throw inst_23249})();
var state_23418__$1 = (function (){var statearr_23475 = state_23418;
(statearr_23475[(21)] = inst_23250);

return statearr_23475;
})();
var statearr_23476_23545 = state_23418__$1;
(statearr_23476_23545[(2)] = inst_23251);

(statearr_23476_23545[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (9))){
var _ = (function (){var statearr_23477 = state_23418;
(statearr_23477[(4)] = cljs.core.cons.call(null,(12),(state_23418[(4)])));

return statearr_23477;
})();
var inst_23257 = cljs.core.first.call(null,flakes);
var inst_23258 = fluree.db.query.fql.s.call(null,inst_23257);
var ___$1 = (function (){var statearr_23478 = state_23418;
(statearr_23478[(4)] = cljs.core.rest.call(null,(state_23418[(4)])));

return statearr_23478;
})();
var state_23418__$1 = state_23418;
var statearr_23479_23546 = state_23418__$1;
(statearr_23479_23546[(2)] = inst_23258);

(statearr_23479_23546[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (5))){
var _ = (function (){var statearr_23480 = state_23418;
(statearr_23480[(4)] = cljs.core.rest.call(null,(state_23418[(4)])));

return statearr_23480;
})();
var state_23418__$1 = state_23418;
var ex23474 = (state_23418__$1[(2)]);
var statearr_23481_23547 = state_23418__$1;
(statearr_23481_23547[(5)] = ex23474);


if((ex23474 instanceof Error)){
var statearr_23482_23548 = state_23418__$1;
(statearr_23482_23548[(1)] = (4));

(statearr_23482_23548[(5)] = null);

} else {
throw ex23474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (14))){
var state_23418__$1 = state_23418;
var statearr_23483_23549 = state_23418__$1;
(statearr_23483_23549[(2)] = base_select_spec);

(statearr_23483_23549[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (45))){
var inst_23361 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
if(cljs.core.truth_(inst_23361)){
var statearr_23484_23550 = state_23418__$1;
(statearr_23484_23550[(1)] = (46));

} else {
var statearr_23485_23551 = state_23418__$1;
(statearr_23485_23551[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (26))){
var inst_23300 = (state_23418[(12)]);
var inst_23304 = cljs.core.empty_QMARK_.call(null,inst_23300);
var state_23418__$1 = state_23418;
if(inst_23304){
var statearr_23486_23552 = state_23418__$1;
(statearr_23486_23552[(1)] = (28));

} else {
var statearr_23487_23553 = state_23418__$1;
(statearr_23487_23553[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (16))){
var inst_23268 = (state_23418[(17)]);
var state_23418__$1 = state_23418;
var statearr_23488_23554 = state_23418__$1;
(statearr_23488_23554[(2)] = inst_23268);

(statearr_23488_23554[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (38))){
var inst_23300 = (state_23418[(12)]);
var inst_23334 = (state_23418[(2)]);
var inst_23335 = fluree.db.util.async.throw_err.call(null,inst_23334);
var inst_23336 = cljs.core.nth.call(null,inst_23335,(0),null);
var inst_23337 = cljs.core.nth.call(null,inst_23335,(1),null);
var inst_23338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23339 = cljs.core.rest.call(null,inst_23300);
var inst_23340 = [inst_23336,inst_23339,inst_23337];
var inst_23341 = (new cljs.core.PersistentVector(null,3,(5),inst_23338,inst_23340,null));
var state_23418__$1 = state_23418;
var statearr_23489_23555 = state_23418__$1;
(statearr_23489_23555[(2)] = inst_23341);

(statearr_23489_23555[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (30))){
var inst_23395 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
var statearr_23490_23556 = state_23418__$1;
(statearr_23490_23556[(2)] = inst_23395);

(statearr_23490_23556[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (10))){
var inst_23261 = (state_23418[(2)]);
var inst_23262 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23418__$1 = (function (){var statearr_23491 = state_23418;
(statearr_23491[(10)] = inst_23261);

return statearr_23491;
})();
if(cljs.core.truth_(inst_23262)){
var statearr_23492_23557 = state_23418__$1;
(statearr_23492_23557[(1)] = (13));

} else {
var statearr_23493_23558 = state_23418__$1;
(statearr_23493_23558[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (18))){
var inst_23273 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
if(cljs.core.truth_(inst_23273)){
var statearr_23494_23559 = state_23418__$1;
(statearr_23494_23559[(1)] = (19));

} else {
var statearr_23495_23560 = state_23418__$1;
(statearr_23495_23560[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (42))){
var inst_23302 = (state_23418[(11)]);
var inst_23300 = (state_23418[(12)]);
var inst_23345 = (state_23418[(16)]);
var inst_23348 = (state_23418[(2)]);
var inst_23349 = fluree.db.util.async.throw_err.call(null,inst_23348);
var inst_23350 = cljs.core.first.call(null,inst_23349);
var inst_23351 = cljs.core.rest.call(null,inst_23300);
var inst_23352 = [inst_23350,inst_23351,inst_23302];
var inst_23353 = (new cljs.core.PersistentVector(null,3,(5),inst_23345,inst_23352,null));
var state_23418__$1 = state_23418;
var statearr_23496_23561 = state_23418__$1;
(statearr_23496_23561[(2)] = inst_23353);

(statearr_23496_23561[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (37))){
var inst_23385 = (state_23418[(2)]);
var state_23418__$1 = state_23418;
var statearr_23497_23562 = state_23418__$1;
(statearr_23497_23562[(2)] = inst_23385);

(statearr_23497_23562[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (8))){
var inst_23413 = (state_23418[(2)]);
var _ = (function (){var statearr_23498 = state_23418;
(statearr_23498[(4)] = cljs.core.rest.call(null,(state_23418[(4)])));

return statearr_23498;
})();
var state_23418__$1 = state_23418;
var statearr_23499_23563 = state_23418__$1;
(statearr_23499_23563[(2)] = inst_23413);

(statearr_23499_23563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23419 === (49))){
var inst_23302 = (state_23418[(11)]);
var inst_23300 = (state_23418[(12)]);
var inst_23301 = (state_23418[(13)]);
var inst_23373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23374 = cljs.core.rest.call(null,inst_23300);
var inst_23375 = [inst_23301,inst_23374,inst_23302];
var inst_23376 = (new cljs.core.PersistentVector(null,3,(5),inst_23373,inst_23375,null));
var state_23418__$1 = state_23418;
var statearr_23500_23564 = state_23418__$1;
(statearr_23500_23564[(2)] = inst_23376);

(statearr_23500_23564[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto____0 = (function (){
var statearr_23501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23501[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto__);

(statearr_23501[(1)] = (1));

return statearr_23501;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto____1 = (function (state_23418){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_23418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e23502){var ex__2729__auto__ = e23502;
var statearr_23503_23565 = state_23418;
(statearr_23503_23565[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_23418[(4)]))){
var statearr_23504_23566 = state_23418;
(statearr_23504_23566[(1)] = cljs.core.first.call(null,(state_23418[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23567 = state_23418;
state_23418 = G__23567;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto__ = function(state_23418){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto____1.call(this,state_23418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_23505 = f__2749__auto__.call(null);
(statearr_23505[(6)] = c__2748__auto__);

return statearr_23505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23570 = arguments.length;
switch (G__23570) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_23612){
var state_val_23613 = (state_23612[(1)]);
if((state_val_23613 === (7))){
var inst_23578 = (state_23612[(7)]);
var state_23612__$1 = state_23612;
var statearr_23614_23644 = state_23612__$1;
(statearr_23614_23644[(2)] = inst_23578);

(statearr_23614_23644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (1))){
var state_23612__$1 = state_23612;
var statearr_23615_23645 = state_23612__$1;
(statearr_23615_23645[(2)] = null);

(statearr_23615_23645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (4))){
var inst_23571 = (state_23612[(2)]);
var state_23612__$1 = state_23612;
var statearr_23616_23646 = state_23612__$1;
(statearr_23616_23646[(2)] = inst_23571);

(statearr_23616_23646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (15))){
var inst_23606 = (state_23612[(2)]);
var inst_23607 = fluree.db.util.async.throw_err.call(null,inst_23606);
var _ = (function (){var statearr_23617 = state_23612;
(statearr_23617[(4)] = cljs.core.rest.call(null,(state_23612[(4)])));

return statearr_23617;
})();
var state_23612__$1 = state_23612;
var statearr_23618_23647 = state_23612__$1;
(statearr_23618_23647[(2)] = inst_23607);

(statearr_23618_23647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (13))){
var inst_23590 = (state_23612[(8)]);
var state_23612__$1 = state_23612;
var statearr_23619_23648 = state_23612__$1;
(statearr_23619_23648[(2)] = inst_23590);

(statearr_23619_23648[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (6))){
var inst_23578 = (state_23612[(7)]);
var inst_23580 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_23581 = cljs.core.comp.call(null,inst_23578,inst_23580);
var state_23612__$1 = state_23612;
var statearr_23620_23649 = state_23612__$1;
(statearr_23620_23649[(2)] = inst_23581);

(statearr_23620_23649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (3))){
var inst_23610 = (state_23612[(2)]);
var state_23612__$1 = state_23612;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23612__$1,inst_23610);
} else {
if((state_val_23613 === (12))){
var inst_23590 = (state_23612[(8)]);
var inst_23592 = cljs.core.take.call(null,limit);
var inst_23593 = cljs.core.comp.call(null,inst_23590,inst_23592);
var state_23612__$1 = state_23612;
var statearr_23621_23650 = state_23612__$1;
(statearr_23621_23650[(2)] = inst_23593);

(statearr_23621_23650[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (2))){
var _ = (function (){var statearr_23622 = state_23612;
(statearr_23622[(4)] = cljs.core.cons.call(null,(5),(state_23612[(4)])));

return statearr_23622;
})();
var inst_23578 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_23612__$1 = (function (){var statearr_23623 = state_23612;
(statearr_23623[(7)] = inst_23578);

return statearr_23623;
})();
if(cljs.core.truth_(fuel)){
var statearr_23624_23651 = state_23612__$1;
(statearr_23624_23651[(1)] = (6));

} else {
var statearr_23625_23652 = state_23612__$1;
(statearr_23625_23652[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (11))){
var inst_23590 = (state_23612[(2)]);
var state_23612__$1 = (function (){var statearr_23627 = state_23612;
(statearr_23627[(8)] = inst_23590);

return statearr_23627;
})();
if(cljs.core.truth_(limit)){
var statearr_23628_23653 = state_23612__$1;
(statearr_23628_23653[(1)] = (12));

} else {
var statearr_23629_23654 = state_23612__$1;
(statearr_23629_23654[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (9))){
var inst_23584 = (state_23612[(9)]);
var inst_23586 = cljs.core.drop.call(null,offset);
var inst_23587 = cljs.core.comp.call(null,inst_23584,inst_23586);
var state_23612__$1 = state_23612;
var statearr_23630_23655 = state_23612__$1;
(statearr_23630_23655[(2)] = inst_23587);

(statearr_23630_23655[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (5))){
var _ = (function (){var statearr_23631 = state_23612;
(statearr_23631[(4)] = cljs.core.rest.call(null,(state_23612[(4)])));

return statearr_23631;
})();
var state_23612__$1 = state_23612;
var ex23626 = (state_23612__$1[(2)]);
var statearr_23632_23656 = state_23612__$1;
(statearr_23632_23656[(5)] = ex23626);


if((ex23626 instanceof Error)){
var statearr_23633_23657 = state_23612__$1;
(statearr_23633_23657[(1)] = (4));

(statearr_23633_23657[(5)] = null);

} else {
throw ex23626;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (14))){
var inst_23596 = (state_23612[(2)]);
var inst_23597 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_23598 = cljs.core.halt_when.call(null,inst_23597);
var inst_23599 = cljs.core.comp.call(null,inst_23596,inst_23598);
var inst_23600 = cljs.core.sequence.call(null,inst_23599,flakes);
var inst_23601 = cljs.core.PersistentVector.EMPTY;
var inst_23602 = (function (){var xf = inst_23599;
var flakes_by_sub = inst_23600;
return (function (p1__23568_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__23568_SHARP_);
});
})();
var inst_23603 = cljs.core.map.call(null,inst_23602,inst_23600);
var inst_23604 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_23601,inst_23603);
var state_23612__$1 = state_23612;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23612__$1,(15),inst_23604);
} else {
if((state_val_23613 === (10))){
var inst_23584 = (state_23612[(9)]);
var state_23612__$1 = state_23612;
var statearr_23634_23658 = state_23612__$1;
(statearr_23634_23658[(2)] = inst_23584);

(statearr_23634_23658[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23613 === (8))){
var inst_23584 = (state_23612[(2)]);
var state_23612__$1 = (function (){var statearr_23635 = state_23612;
(statearr_23635[(9)] = inst_23584);

return statearr_23635;
})();
if(cljs.core.truth_(offset)){
var statearr_23636_23659 = state_23612__$1;
(statearr_23636_23659[(1)] = (9));

} else {
var statearr_23637_23660 = state_23612__$1;
(statearr_23637_23660[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2726__auto__ = null;
var fluree$db$query$fql$state_machine__2726__auto____0 = (function (){
var statearr_23638 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23638[(0)] = fluree$db$query$fql$state_machine__2726__auto__);

(statearr_23638[(1)] = (1));

return statearr_23638;
});
var fluree$db$query$fql$state_machine__2726__auto____1 = (function (state_23612){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_23612);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e23639){var ex__2729__auto__ = e23639;
var statearr_23640_23661 = state_23612;
(statearr_23640_23661[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_23612[(4)]))){
var statearr_23641_23662 = state_23612;
(statearr_23641_23662[(1)] = cljs.core.first.call(null,(state_23612[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23663 = state_23612;
state_23612 = G__23663;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2726__auto__ = function(state_23612){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2726__auto____1.call(this,state_23612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2726__auto____0;
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2726__auto____1;
return fluree$db$query$fql$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_23642 = f__2749__auto__.call(null);
(statearr_23642[(6)] = c__2748__auto__);

return statearr_23642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23665 = arguments.length;
switch (G__23665) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_23746){
var state_val_23747 = (state_23746[(1)]);
if((state_val_23747 === (7))){
var inst_23741 = (state_23746[(2)]);
var _ = (function (){var statearr_23749 = state_23746;
(statearr_23749[(4)] = cljs.core.rest.call(null,(state_23746[(4)])));

return statearr_23749;
})();
var state_23746__$1 = state_23746;
var statearr_23750_23797 = state_23746__$1;
(statearr_23750_23797[(2)] = inst_23741);

(statearr_23750_23797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (20))){
var inst_23693 = (state_23746[(7)]);
var inst_23685 = (state_23746[(8)]);
var inst_23686 = (state_23746[(9)]);
var inst_23714 = (inst_23685 + (1));
var tmp23748 = inst_23686;
var inst_23684 = inst_23693;
var inst_23685__$1 = inst_23714;
var inst_23686__$1 = tmp23748;
var state_23746__$1 = (function (){var statearr_23751 = state_23746;
(statearr_23751[(10)] = inst_23684);

(statearr_23751[(8)] = inst_23685__$1);

(statearr_23751[(9)] = inst_23686__$1);

return statearr_23751;
})();
var statearr_23752_23798 = state_23746__$1;
(statearr_23752_23798[(2)] = null);

(statearr_23752_23798[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (27))){
var inst_23719 = (state_23746[(11)]);
var inst_23725 = (state_23746[(2)]);
var inst_23726 = fluree.db.util.async.throw_err.call(null,inst_23725);
var inst_23727 = inst_23719.call(null,inst_23726);
var state_23746__$1 = state_23746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23746__$1,(26),inst_23727);
} else {
if((state_val_23747 === (1))){
var state_23746__$1 = state_23746;
var statearr_23753_23799 = state_23746__$1;
(statearr_23753_23799[(2)] = null);

(statearr_23753_23799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (24))){
var state_23746__$1 = state_23746;
var statearr_23754_23800 = state_23746__$1;
(statearr_23754_23800[(2)] = null);

(statearr_23754_23800[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (4))){
var inst_23666 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
var statearr_23755_23801 = state_23746__$1;
(statearr_23755_23801[(2)] = inst_23666);

(statearr_23755_23801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (15))){
var inst_23707 = (state_23746[(12)]);
var inst_23707__$1 = offset;
var state_23746__$1 = (function (){var statearr_23756 = state_23746;
(statearr_23756[(12)] = inst_23707__$1);

return statearr_23756;
})();
if(cljs.core.truth_(inst_23707__$1)){
var statearr_23757_23802 = state_23746__$1;
(statearr_23757_23802[(1)] = (17));

} else {
var statearr_23758_23803 = state_23746__$1;
(statearr_23758_23803[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (21))){
var state_23746__$1 = state_23746;
var statearr_23759_23804 = state_23746__$1;
(statearr_23759_23804[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (13))){
var inst_23702 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
var statearr_23761_23805 = state_23746__$1;
(statearr_23761_23805[(2)] = inst_23702);

(statearr_23761_23805[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (22))){
var inst_23737 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
var statearr_23762_23806 = state_23746__$1;
(statearr_23762_23806[(2)] = inst_23737);

(statearr_23762_23806[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (6))){
var inst_23684 = (state_23746[(10)]);
var inst_23694 = (state_23746[(13)]);
var inst_23692 = (state_23746[(14)]);
var inst_23691 = cljs.core.seq.call(null,inst_23684);
var inst_23692__$1 = cljs.core.first.call(null,inst_23691);
var inst_23693 = cljs.core.next.call(null,inst_23691);
var inst_23694__$1 = (inst_23692__$1 == null);
var state_23746__$1 = (function (){var statearr_23763 = state_23746;
(statearr_23763[(7)] = inst_23693);

(statearr_23763[(13)] = inst_23694__$1);

(statearr_23763[(14)] = inst_23692__$1);

return statearr_23763;
})();
if(cljs.core.truth_(inst_23694__$1)){
var statearr_23764_23807 = state_23746__$1;
(statearr_23764_23807[(1)] = (8));

} else {
var statearr_23765_23808 = state_23746__$1;
(statearr_23765_23808[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (25))){
var inst_23735 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
var statearr_23766_23809 = state_23746__$1;
(statearr_23766_23809[(2)] = inst_23735);

(statearr_23766_23809[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (17))){
var inst_23685 = (state_23746[(8)]);
var inst_23709 = (inst_23685 < offset);
var state_23746__$1 = state_23746;
var statearr_23767_23810 = state_23746__$1;
(statearr_23767_23810[(2)] = inst_23709);

(statearr_23767_23810[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (3))){
var inst_23744 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23746__$1,inst_23744);
} else {
if((state_val_23747 === (12))){
var inst_23697 = (state_23746[(15)]);
var state_23746__$1 = state_23746;
var statearr_23768_23811 = state_23746__$1;
(statearr_23768_23811[(2)] = inst_23697);

(statearr_23768_23811[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (2))){
var inst_23679 = (state_23746[(16)]);
var _ = (function (){var statearr_23769 = state_23746;
(statearr_23769[(4)] = cljs.core.cons.call(null,(5),(state_23746[(4)])));

return statearr_23769;
})();
var inst_23679__$1 = subjects;
var inst_23680 = cljs.core.seq.call(null,inst_23679__$1);
var inst_23681 = cljs.core.first.call(null,inst_23680);
var inst_23682 = cljs.core.next.call(null,inst_23680);
var inst_23683 = cljs.core.PersistentVector.EMPTY;
var inst_23684 = inst_23679__$1;
var inst_23685 = (0);
var inst_23686 = inst_23683;
var state_23746__$1 = (function (){var statearr_23770 = state_23746;
(statearr_23770[(16)] = inst_23679__$1);

(statearr_23770[(17)] = inst_23682);

(statearr_23770[(10)] = inst_23684);

(statearr_23770[(8)] = inst_23685);

(statearr_23770[(9)] = inst_23686);

(statearr_23770[(18)] = inst_23681);

return statearr_23770;
})();
var statearr_23771_23812 = state_23746__$1;
(statearr_23771_23812[(2)] = null);

(statearr_23771_23812[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (23))){
var inst_23679 = (state_23746[(16)]);
var inst_23682 = (state_23746[(17)]);
var inst_23684 = (state_23746[(10)]);
var inst_23693 = (state_23746[(7)]);
var inst_23685 = (state_23746[(8)]);
var inst_23686 = (state_23746[(9)]);
var inst_23692 = (state_23746[(14)]);
var inst_23681 = (state_23746[(18)]);
var inst_23718 = (inst_23685 + (1));
var inst_23719 = (function (){var first__23678 = inst_23681;
var seq__23677 = inst_23682;
var r = inst_23693;
var vec__23688 = inst_23684;
var vec__23676 = inst_23679;
var first__23690 = inst_23692;
var acc = inst_23686;
var n = inst_23685;
var G__23675 = inst_23684;
var s = inst_23692;
var seq__23689 = inst_23693;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23721 = [inst_23692];
var inst_23722 = (new cljs.core.PersistentVector(null,1,(5),inst_23720,inst_23721,null));
var inst_23723 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23722);
var state_23746__$1 = (function (){var statearr_23772 = state_23746;
(statearr_23772[(19)] = inst_23718);

(statearr_23772[(11)] = inst_23719);

return statearr_23772;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23746__$1,(27),inst_23723);
} else {
if((state_val_23747 === (19))){
var inst_23712 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
if(cljs.core.truth_(inst_23712)){
var statearr_23773_23813 = state_23746__$1;
(statearr_23773_23813[(1)] = (20));

} else {
var statearr_23774_23814 = state_23746__$1;
(statearr_23774_23814[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (11))){
var inst_23685 = (state_23746[(8)]);
var inst_23699 = (inst_23685 > limit);
var state_23746__$1 = state_23746;
var statearr_23776_23815 = state_23746__$1;
(statearr_23776_23815[(2)] = inst_23699);

(statearr_23776_23815[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (9))){
var inst_23697 = (state_23746[(15)]);
var inst_23697__$1 = limit;
var state_23746__$1 = (function (){var statearr_23777 = state_23746;
(statearr_23777[(15)] = inst_23697__$1);

return statearr_23777;
})();
if(cljs.core.truth_(inst_23697__$1)){
var statearr_23778_23816 = state_23746__$1;
(statearr_23778_23816[(1)] = (11));

} else {
var statearr_23779_23817 = state_23746__$1;
(statearr_23779_23817[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (5))){
var _ = (function (){var statearr_23780 = state_23746;
(statearr_23780[(4)] = cljs.core.rest.call(null,(state_23746[(4)])));

return statearr_23780;
})();
var state_23746__$1 = state_23746;
var ex23775 = (state_23746__$1[(2)]);
var statearr_23781_23818 = state_23746__$1;
(statearr_23781_23818[(5)] = ex23775);


if((ex23775 instanceof Error)){
var statearr_23782_23819 = state_23746__$1;
(statearr_23782_23819[(1)] = (4));

(statearr_23782_23819[(5)] = null);

} else {
throw ex23775;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (14))){
var inst_23686 = (state_23746[(9)]);
var state_23746__$1 = state_23746;
var statearr_23783_23820 = state_23746__$1;
(statearr_23783_23820[(2)] = inst_23686);

(statearr_23783_23820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (26))){
var inst_23693 = (state_23746[(7)]);
var inst_23718 = (state_23746[(19)]);
var inst_23686 = (state_23746[(9)]);
var inst_23729 = (state_23746[(2)]);
var inst_23730 = fluree.db.util.async.throw_err.call(null,inst_23729);
var inst_23731 = cljs.core.conj.call(null,inst_23686,inst_23730);
var inst_23684 = inst_23693;
var inst_23685 = inst_23718;
var inst_23686__$1 = inst_23731;
var state_23746__$1 = (function (){var statearr_23784 = state_23746;
(statearr_23784[(10)] = inst_23684);

(statearr_23784[(8)] = inst_23685);

(statearr_23784[(9)] = inst_23686__$1);

return statearr_23784;
})();
var statearr_23785_23821 = state_23746__$1;
(statearr_23785_23821[(2)] = null);

(statearr_23785_23821[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (16))){
var inst_23739 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
var statearr_23786_23822 = state_23746__$1;
(statearr_23786_23822[(2)] = inst_23739);

(statearr_23786_23822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (10))){
var inst_23704 = (state_23746[(2)]);
var state_23746__$1 = state_23746;
if(cljs.core.truth_(inst_23704)){
var statearr_23787_23823 = state_23746__$1;
(statearr_23787_23823[(1)] = (14));

} else {
var statearr_23788_23824 = state_23746__$1;
(statearr_23788_23824[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (18))){
var inst_23707 = (state_23746[(12)]);
var state_23746__$1 = state_23746;
var statearr_23789_23825 = state_23746__$1;
(statearr_23789_23825[(2)] = inst_23707);

(statearr_23789_23825[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23747 === (8))){
var inst_23694 = (state_23746[(13)]);
var state_23746__$1 = state_23746;
var statearr_23790_23826 = state_23746__$1;
(statearr_23790_23826[(2)] = inst_23694);

(statearr_23790_23826[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2726__auto__ = null;
var fluree$db$query$fql$state_machine__2726__auto____0 = (function (){
var statearr_23791 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23791[(0)] = fluree$db$query$fql$state_machine__2726__auto__);

(statearr_23791[(1)] = (1));

return statearr_23791;
});
var fluree$db$query$fql$state_machine__2726__auto____1 = (function (state_23746){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_23746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e23792){var ex__2729__auto__ = e23792;
var statearr_23793_23827 = state_23746;
(statearr_23793_23827[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_23746[(4)]))){
var statearr_23794_23828 = state_23746;
(statearr_23794_23828[(1)] = cljs.core.first.call(null,(state_23746[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23829 = state_23746;
state_23746 = G__23829;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2726__auto__ = function(state_23746){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2726__auto____1.call(this,state_23746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2726__auto____0;
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2726__auto____1;
return fluree$db$query$fql$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_23795 = f__2749__auto__.call(null);
(statearr_23795[(6)] = c__2748__auto__);

return statearr_23795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__23831 = arguments.length;
switch (G__23831) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_24022){
var state_val_24023 = (state_24022[(1)]);
if((state_val_24023 === (7))){
var state_24022__$1 = state_24022;
var statearr_24024_24099 = state_24022__$1;
(statearr_24024_24099[(2)] = null);

(statearr_24024_24099[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (20))){
var inst_23872 = (state_24022[(7)]);
var inst_23874 = (state_24022[(8)]);
var inst_23902 = (state_24022[(2)]);
var inst_23903 = fluree.db.util.async.throw_err.call(null,inst_23902);
var inst_23904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23905 = [inst_23872];
var inst_23906 = (new cljs.core.PersistentVector(null,1,(5),inst_23904,inst_23905,null));
var inst_23907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23908 = [inst_23872,inst_23874];
var inst_23909 = (new cljs.core.PersistentVector(null,2,(5),inst_23907,inst_23908,null));
var inst_23910 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23906,cljs.core._LT_,inst_23909);
var state_24022__$1 = (function (){var statearr_24025 = state_24022;
(statearr_24025[(9)] = inst_23903);

return statearr_24025;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24022__$1,(21),inst_23910);
} else {
if((state_val_24023 === (27))){
var inst_23891 = (state_24022[(10)]);
var inst_23873 = (state_24022[(11)]);
var inst_23939 = inst_23891.call(null,cljs.core._GT__EQ_,inst_23873);
var state_24022__$1 = state_24022;
if(cljs.core.truth_(inst_23939)){
var statearr_24026_24100 = state_24022__$1;
(statearr_24026_24100[(1)] = (30));

} else {
var statearr_24027_24101 = state_24022__$1;
(statearr_24027_24101[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (1))){
var state_24022__$1 = state_24022;
var statearr_24028_24102 = state_24022__$1;
(statearr_24028_24102[(2)] = null);

(statearr_24028_24102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (24))){
var inst_23988 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24029_24103 = state_24022__$1;
(statearr_24029_24103[(2)] = inst_23988);

(statearr_24029_24103[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (39))){
var inst_23978 = null;
var state_24022__$1 = state_24022;
var statearr_24030_24104 = state_24022__$1;
(statearr_24030_24104[(2)] = inst_23978);

(statearr_24030_24104[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (46))){
var inst_24000 = (state_24022[(12)]);
var state_24022__$1 = state_24022;
var statearr_24031_24105 = state_24022__$1;
(statearr_24031_24105[(2)] = inst_24000);

(statearr_24031_24105[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (4))){
var inst_23832 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24032_24106 = state_24022__$1;
(statearr_24032_24106[(2)] = inst_23832);

(statearr_24032_24106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (15))){
var state_24022__$1 = state_24022;
var statearr_24033_24107 = state_24022__$1;
(statearr_24033_24107[(2)] = null);

(statearr_24033_24107[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (48))){
var inst_23999 = (state_24022[(13)]);
var state_24022__$1 = state_24022;
var statearr_24034_24108 = state_24022__$1;
(statearr_24034_24108[(2)] = inst_23999);

(statearr_24034_24108[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (50))){
var inst_24010 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24035_24109 = state_24022__$1;
(statearr_24035_24109[(2)] = inst_24010);

(statearr_24035_24109[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (21))){
var inst_23903 = (state_24022[(9)]);
var inst_23912 = (state_24022[(2)]);
var inst_23913 = fluree.db.util.async.throw_err.call(null,inst_23912);
var inst_23914 = cljs.core.concat.call(null,inst_23903,inst_23913);
var state_24022__$1 = state_24022;
var statearr_24036_24110 = state_24022__$1;
(statearr_24036_24110[(2)] = inst_23914);

(statearr_24036_24110[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (31))){
var inst_23891 = (state_24022[(10)]);
var inst_23873 = (state_24022[(11)]);
var inst_23952 = inst_23891.call(null,cljs.core._LT_,inst_23873);
var state_24022__$1 = state_24022;
if(cljs.core.truth_(inst_23952)){
var statearr_24037_24111 = state_24022__$1;
(statearr_24037_24111[(1)] = (34));

} else {
var statearr_24038_24112 = state_24022__$1;
(statearr_24038_24112[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (32))){
var inst_23984 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24039_24113 = state_24022__$1;
(statearr_24039_24113[(2)] = inst_23984);

(statearr_24039_24113[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (40))){
var inst_23980 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24040_24114 = state_24022__$1;
(statearr_24040_24114[(2)] = inst_23980);

(statearr_24040_24114[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (33))){
var inst_23949 = (state_24022[(2)]);
var inst_23950 = fluree.db.util.async.throw_err.call(null,inst_23949);
var state_24022__$1 = state_24022;
var statearr_24041_24115 = state_24022__$1;
(statearr_24041_24115[(2)] = inst_23950);

(statearr_24041_24115[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (13))){
var inst_24012 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24042_24116 = state_24022__$1;
(statearr_24042_24116[(2)] = inst_24012);

(statearr_24042_24116[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (22))){
var inst_23872 = (state_24022[(7)]);
var inst_23874 = (state_24022[(8)]);
var inst_23918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23919 = [inst_23872,inst_23874];
var inst_23920 = (new cljs.core.PersistentVector(null,2,(5),inst_23918,inst_23919,null));
var inst_23921 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_23920);
var state_24022__$1 = state_24022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24022__$1,(25),inst_23921);
} else {
if((state_val_24023 === (36))){
var inst_23982 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24043_24117 = state_24022__$1;
(statearr_24043_24117[(2)] = inst_23982);

(statearr_24043_24117[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (41))){
var inst_23975 = (state_24022[(2)]);
var inst_23976 = fluree.db.util.async.throw_err.call(null,inst_23975);
var state_24022__$1 = state_24022;
var statearr_24044_24118 = state_24022__$1;
(statearr_24044_24118[(2)] = inst_23976);

(statearr_24044_24118[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (43))){
var inst_23858 = (state_24022[(14)]);
var inst_23991 = (state_24022[(15)]);
var inst_23992 = cljs.core.into.call(null,inst_23858,inst_23991);
var state_24022__$1 = state_24022;
var statearr_24045_24119 = state_24022__$1;
(statearr_24045_24119[(2)] = inst_23992);

(statearr_24045_24119[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (29))){
var inst_23936 = (state_24022[(2)]);
var inst_23937 = fluree.db.util.async.throw_err.call(null,inst_23936);
var state_24022__$1 = state_24022;
var statearr_24046_24120 = state_24022__$1;
(statearr_24046_24120[(2)] = inst_23937);

(statearr_24046_24120[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (44))){
var inst_23858 = (state_24022[(14)]);
var inst_23991 = (state_24022[(15)]);
var inst_23994 = cljs.core.PersistentHashSet.EMPTY;
var inst_23995 = cljs.core.into.call(null,inst_23994,inst_23991);
var inst_23996 = clojure.set.intersection.call(null,inst_23858,inst_23995);
var state_24022__$1 = state_24022;
var statearr_24047_24121 = state_24022__$1;
(statearr_24047_24121[(2)] = inst_23996);

(statearr_24047_24121[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (6))){
var inst_23843 = (state_24022[(16)]);
var inst_23853 = cljs.core.seq.call(null,inst_23843);
var inst_23854 = cljs.core.first.call(null,inst_23853);
var inst_23855 = cljs.core.next.call(null,inst_23853);
var inst_23856 = cljs.core.PersistentHashSet.EMPTY;
var inst_23857 = inst_23843;
var inst_23858 = inst_23856;
var state_24022__$1 = (function (){var statearr_24048 = state_24022;
(statearr_24048[(14)] = inst_23858);

(statearr_24048[(17)] = inst_23854);

(statearr_24048[(18)] = inst_23857);

(statearr_24048[(19)] = inst_23855);

return statearr_24048;
})();
var statearr_24049_24122 = state_24022__$1;
(statearr_24049_24122[(2)] = null);

(statearr_24049_24122[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (28))){
var inst_23986 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24050_24123 = state_24022__$1;
(statearr_24050_24123[(2)] = inst_23986);

(statearr_24050_24123[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (25))){
var inst_23923 = (state_24022[(2)]);
var inst_23924 = fluree.db.util.async.throw_err.call(null,inst_23923);
var state_24022__$1 = state_24022;
var statearr_24051_24124 = state_24022__$1;
(statearr_24051_24124[(2)] = inst_23924);

(statearr_24051_24124[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (34))){
var inst_23872 = (state_24022[(7)]);
var inst_23874 = (state_24022[(8)]);
var inst_23954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23955 = [inst_23872];
var inst_23956 = (new cljs.core.PersistentVector(null,1,(5),inst_23954,inst_23955,null));
var inst_23957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23958 = [inst_23872,inst_23874];
var inst_23959 = (new cljs.core.PersistentVector(null,2,(5),inst_23957,inst_23958,null));
var inst_23960 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23956,cljs.core._LT_,inst_23959);
var state_24022__$1 = state_24022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24022__$1,(37),inst_23960);
} else {
if((state_val_24023 === (17))){
var inst_23872 = (state_24022[(7)]);
var inst_23874 = (state_24022[(8)]);
var inst_23894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23895 = [inst_23872,inst_23874];
var inst_23896 = (new cljs.core.PersistentVector(null,2,(5),inst_23894,inst_23895,null));
var inst_23897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23898 = [inst_23872];
var inst_23899 = (new cljs.core.PersistentVector(null,1,(5),inst_23897,inst_23898,null));
var inst_23900 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23896,cljs.core._LT__EQ_,inst_23899);
var state_24022__$1 = state_24022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24022__$1,(20),inst_23900);
} else {
if((state_val_24023 === (3))){
var inst_24020 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24022__$1,inst_24020);
} else {
if((state_val_24023 === (12))){
var inst_23864 = (state_24022[(20)]);
var inst_23872 = (state_24022[(7)]);
var inst_23872__$1 = cljs.core.nth.call(null,inst_23864,(0),null);
var inst_23873 = cljs.core.nth.call(null,inst_23864,(1),null);
var inst_23874 = cljs.core.nth.call(null,inst_23864,(2),null);
var inst_23875 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_23872__$1);
var inst_23876 = cljs.core.not.call(null,inst_23875);
var state_24022__$1 = (function (){var statearr_24052 = state_24022;
(statearr_24052[(11)] = inst_23873);

(statearr_24052[(7)] = inst_23872__$1);

(statearr_24052[(8)] = inst_23874);

return statearr_24052;
})();
if(inst_23876){
var statearr_24053_24125 = state_24022__$1;
(statearr_24053_24125[(1)] = (14));

} else {
var statearr_24054_24126 = state_24022__$1;
(statearr_24054_24126[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (2))){
var inst_23843 = (state_24022[(16)]);
var _ = (function (){var statearr_24055 = state_24022;
(statearr_24055[(4)] = cljs.core.cons.call(null,(5),(state_24022[(4)])));

return statearr_24055;
})();
var inst_23841 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_23842 = cljs.core.nth.call(null,inst_23841,(0),null);
var inst_23843__$1 = cljs.core.nth.call(null,inst_23841,(1),null);
var inst_23844 = cljs.core.not_empty.call(null,inst_23843__$1);
var state_24022__$1 = (function (){var statearr_24056 = state_24022;
(statearr_24056[(16)] = inst_23843__$1);

(statearr_24056[(21)] = inst_23842);

return statearr_24056;
})();
if(cljs.core.truth_(inst_23844)){
var statearr_24057_24127 = state_24022__$1;
(statearr_24057_24127[(1)] = (6));

} else {
var statearr_24058_24128 = state_24022__$1;
(statearr_24058_24128[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (23))){
var inst_23891 = (state_24022[(10)]);
var inst_23873 = (state_24022[(11)]);
var inst_23926 = inst_23891.call(null,cljs.core._GT_,inst_23873);
var state_24022__$1 = state_24022;
if(cljs.core.truth_(inst_23926)){
var statearr_24059_24129 = state_24022__$1;
(statearr_24059_24129[(1)] = (26));

} else {
var statearr_24060_24130 = state_24022__$1;
(statearr_24060_24130[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (47))){
var inst_24005 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
if(cljs.core.truth_(inst_24005)){
var statearr_24061_24131 = state_24022__$1;
(statearr_24061_24131[(1)] = (48));

} else {
var statearr_24062_24132 = state_24022__$1;
(statearr_24062_24132[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (35))){
var inst_23891 = (state_24022[(10)]);
var inst_23873 = (state_24022[(11)]);
var inst_23965 = inst_23891.call(null,cljs.core._LT__EQ_,inst_23873);
var state_24022__$1 = state_24022;
if(cljs.core.truth_(inst_23965)){
var statearr_24063_24133 = state_24022__$1;
(statearr_24063_24133[(1)] = (38));

} else {
var statearr_24064_24134 = state_24022__$1;
(statearr_24064_24134[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (19))){
var inst_23842 = (state_24022[(21)]);
var inst_23990 = (state_24022[(2)]);
var inst_23991 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_23990);
var state_24022__$1 = (function (){var statearr_24065 = state_24022;
(statearr_24065[(15)] = inst_23991);

return statearr_24065;
})();
var G__24066_24135 = inst_23842;
var G__24066_24136__$1 = (((G__24066_24135 instanceof cljs.core.Keyword))?G__24066_24135.fqn:null);
switch (G__24066_24136__$1) {
case "or":
var statearr_24067_24138 = state_24022__$1;
(statearr_24067_24138[(1)] = (43));


break;
case "and":
var statearr_24068_24139 = state_24022__$1;
(statearr_24068_24139[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24066_24136__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (11))){
var inst_23858 = (state_24022[(14)]);
var state_24022__$1 = state_24022;
var statearr_24070_24140 = state_24022__$1;
(statearr_24070_24140[(2)] = inst_23858);

(statearr_24070_24140[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (9))){
var inst_23864 = (state_24022[(20)]);
var inst_23857 = (state_24022[(18)]);
var inst_23863 = cljs.core.seq.call(null,inst_23857);
var inst_23864__$1 = cljs.core.first.call(null,inst_23863);
var inst_23865 = cljs.core.next.call(null,inst_23863);
var inst_23866 = cljs.core.not.call(null,inst_23864__$1);
var state_24022__$1 = (function (){var statearr_24071 = state_24022;
(statearr_24071[(22)] = inst_23865);

(statearr_24071[(20)] = inst_23864__$1);

return statearr_24071;
})();
if(inst_23866){
var statearr_24072_24141 = state_24022__$1;
(statearr_24072_24141[(1)] = (11));

} else {
var statearr_24073_24142 = state_24022__$1;
(statearr_24073_24142[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (5))){
var _ = (function (){var statearr_24074 = state_24022;
(statearr_24074[(4)] = cljs.core.rest.call(null,(state_24022[(4)])));

return statearr_24074;
})();
var state_24022__$1 = state_24022;
var ex24069 = (state_24022__$1[(2)]);
var statearr_24075_24143 = state_24022__$1;
(statearr_24075_24143[(5)] = ex24069);


if((ex24069 instanceof Error)){
var statearr_24076_24144 = state_24022__$1;
(statearr_24076_24144[(1)] = (4));

(statearr_24076_24144[(5)] = null);

} else {
throw ex24069;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (14))){
var inst_23872 = (state_24022[(7)]);
var inst_23878 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23872);
var inst_23879 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23878)].join('');
var inst_23880 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23881 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23882 = cljs.core.PersistentHashMap.fromArrays(inst_23880,inst_23881);
var inst_23883 = cljs.core.ex_info.call(null,inst_23879,inst_23882);
var inst_23884 = (function(){throw inst_23883})();
var state_24022__$1 = state_24022;
var statearr_24077_24145 = state_24022__$1;
(statearr_24077_24145[(2)] = inst_23884);

(statearr_24077_24145[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (45))){
var inst_23999 = (state_24022[(13)]);
var inst_24002 = cljs.core.empty_QMARK_.call(null,inst_23999);
var state_24022__$1 = state_24022;
var statearr_24078_24146 = state_24022__$1;
(statearr_24078_24146[(2)] = inst_24002);

(statearr_24078_24146[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (26))){
var inst_23872 = (state_24022[(7)]);
var inst_23874 = (state_24022[(8)]);
var inst_23928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23929 = [inst_23872,inst_23874];
var inst_23930 = (new cljs.core.PersistentVector(null,2,(5),inst_23928,inst_23929,null));
var inst_23931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23932 = [inst_23872];
var inst_23933 = (new cljs.core.PersistentVector(null,1,(5),inst_23931,inst_23932,null));
var inst_23934 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23930,cljs.core._LT__EQ_,inst_23933);
var state_24022__$1 = state_24022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24022__$1,(29),inst_23934);
} else {
if((state_val_24023 === (16))){
var inst_23891 = (state_24022[(10)]);
var inst_23873 = (state_24022[(11)]);
var inst_23887 = (state_24022[(2)]);
var inst_23891__$1 = cljs.core.identical_QMARK_;
var inst_23892 = inst_23891__$1.call(null,cljs.core.not_EQ_,inst_23873);
var state_24022__$1 = (function (){var statearr_24079 = state_24022;
(statearr_24079[(10)] = inst_23891__$1);

(statearr_24079[(23)] = inst_23887);

return statearr_24079;
})();
if(cljs.core.truth_(inst_23892)){
var statearr_24080_24147 = state_24022__$1;
(statearr_24080_24147[(1)] = (17));

} else {
var statearr_24081_24148 = state_24022__$1;
(statearr_24081_24148[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (38))){
var inst_23872 = (state_24022[(7)]);
var inst_23874 = (state_24022[(8)]);
var inst_23967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23968 = [inst_23872];
var inst_23969 = (new cljs.core.PersistentVector(null,1,(5),inst_23967,inst_23968,null));
var inst_23970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23971 = [inst_23872,inst_23874];
var inst_23972 = (new cljs.core.PersistentVector(null,2,(5),inst_23970,inst_23971,null));
var inst_23973 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23969,cljs.core._LT__EQ_,inst_23972);
var state_24022__$1 = state_24022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24022__$1,(41),inst_23973);
} else {
if((state_val_24023 === (30))){
var inst_23872 = (state_24022[(7)]);
var inst_23874 = (state_24022[(8)]);
var inst_23941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23942 = [inst_23872,inst_23874];
var inst_23943 = (new cljs.core.PersistentVector(null,2,(5),inst_23941,inst_23942,null));
var inst_23944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23945 = [inst_23872];
var inst_23946 = (new cljs.core.PersistentVector(null,1,(5),inst_23944,inst_23945,null));
var inst_23947 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23943,cljs.core._LT__EQ_,inst_23946);
var state_24022__$1 = state_24022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24022__$1,(33),inst_23947);
} else {
if((state_val_24023 === (10))){
var inst_24014 = (state_24022[(2)]);
var state_24022__$1 = state_24022;
var statearr_24082_24149 = state_24022__$1;
(statearr_24082_24149[(2)] = inst_24014);

(statearr_24082_24149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (18))){
var inst_23891 = (state_24022[(10)]);
var inst_23873 = (state_24022[(11)]);
var inst_23916 = inst_23891.call(null,cljs.core._EQ_,inst_23873);
var state_24022__$1 = state_24022;
if(cljs.core.truth_(inst_23916)){
var statearr_24083_24150 = state_24022__$1;
(statearr_24083_24150[(1)] = (22));

} else {
var statearr_24084_24151 = state_24022__$1;
(statearr_24084_24151[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (42))){
var inst_24000 = (state_24022[(12)]);
var inst_23842 = (state_24022[(21)]);
var inst_23999 = (state_24022[(2)]);
var inst_24000__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_23842);
var state_24022__$1 = (function (){var statearr_24085 = state_24022;
(statearr_24085[(12)] = inst_24000__$1);

(statearr_24085[(13)] = inst_23999);

return statearr_24085;
})();
if(inst_24000__$1){
var statearr_24086_24152 = state_24022__$1;
(statearr_24086_24152[(1)] = (45));

} else {
var statearr_24087_24153 = state_24022__$1;
(statearr_24087_24153[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (37))){
var inst_23962 = (state_24022[(2)]);
var inst_23963 = fluree.db.util.async.throw_err.call(null,inst_23962);
var state_24022__$1 = state_24022;
var statearr_24088_24154 = state_24022__$1;
(statearr_24088_24154[(2)] = inst_23963);

(statearr_24088_24154[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (8))){
var inst_24017 = (state_24022[(2)]);
var _ = (function (){var statearr_24089 = state_24022;
(statearr_24089[(4)] = cljs.core.rest.call(null,(state_24022[(4)])));

return statearr_24089;
})();
var state_24022__$1 = state_24022;
var statearr_24090_24155 = state_24022__$1;
(statearr_24090_24155[(2)] = inst_24017);

(statearr_24090_24155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24023 === (49))){
var inst_23865 = (state_24022[(22)]);
var inst_23999 = (state_24022[(13)]);
var inst_23857 = inst_23865;
var inst_23858 = inst_23999;
var state_24022__$1 = (function (){var statearr_24091 = state_24022;
(statearr_24091[(14)] = inst_23858);

(statearr_24091[(18)] = inst_23857);

return statearr_24091;
})();
var statearr_24092_24156 = state_24022__$1;
(statearr_24092_24156[(2)] = null);

(statearr_24092_24156[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2726__auto__ = null;
var fluree$db$query$fql$state_machine__2726__auto____0 = (function (){
var statearr_24093 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24093[(0)] = fluree$db$query$fql$state_machine__2726__auto__);

(statearr_24093[(1)] = (1));

return statearr_24093;
});
var fluree$db$query$fql$state_machine__2726__auto____1 = (function (state_24022){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_24022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e24094){var ex__2729__auto__ = e24094;
var statearr_24095_24157 = state_24022;
(statearr_24095_24157[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_24022[(4)]))){
var statearr_24096_24158 = state_24022;
(statearr_24096_24158[(1)] = cljs.core.first.call(null,(state_24022[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24159 = state_24022;
state_24022 = G__24159;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2726__auto__ = function(state_24022){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2726__auto____1.call(this,state_24022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2726__auto____0;
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2726__auto____1;
return fluree$db$query$fql$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_24097 = f__2749__auto__.call(null);
(statearr_24097[(6)] = c__2748__auto__);

return statearr_24097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__24160_SHARP_){
return ((typeof p1__24160_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__24160_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24161_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24161_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24165 = vars;
var vec__24166 = G__24165;
var seq__24167 = cljs.core.seq.call(null,vec__24166);
var first__24168 = cljs.core.first.call(null,seq__24167);
var seq__24167__$1 = cljs.core.next.call(null,seq__24167);
var var$ = first__24168;
var r = seq__24167__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24165__$1 = G__24165;
var all_vars__$1 = all_vars;
while(true){
var vec__24172 = G__24165__$1;
var seq__24173 = cljs.core.seq.call(null,vec__24172);
var first__24174 = cljs.core.first.call(null,seq__24173);
var seq__24173__$1 = cljs.core.next.call(null,seq__24173);
var var$__$1 = first__24174;
var r__$1 = seq__24173__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24175 = r__$1;
var G__24176 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24165__$1 = G__24175;
all_vars__$1 = G__24176;
continue;
} else {
var G__24177 = r__$1;
var G__24178 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24165__$1 = G__24177;
all_vars__$1 = G__24178;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_24213){
var state_val_24214 = (state_24213[(1)]);
if((state_val_24214 === (1))){
var inst_24186 = functionArray;
var inst_24187 = cljs.core.seq.call(null,inst_24186);
var inst_24188 = cljs.core.first.call(null,inst_24187);
var inst_24189 = cljs.core.next.call(null,inst_24187);
var inst_24190 = cljs.core.PersistentVector.EMPTY;
var inst_24191 = inst_24186;
var inst_24192 = inst_24190;
var state_24213__$1 = (function (){var statearr_24215 = state_24213;
(statearr_24215[(7)] = inst_24189);

(statearr_24215[(8)] = inst_24188);

(statearr_24215[(9)] = inst_24192);

(statearr_24215[(10)] = inst_24191);

return statearr_24215;
})();
var statearr_24216_24229 = state_24213__$1;
(statearr_24216_24229[(2)] = null);

(statearr_24216_24229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24214 === (2))){
var inst_24198 = (state_24213[(11)]);
var inst_24191 = (state_24213[(10)]);
var inst_24197 = cljs.core.seq.call(null,inst_24191);
var inst_24198__$1 = cljs.core.first.call(null,inst_24197);
var inst_24199 = cljs.core.next.call(null,inst_24197);
var state_24213__$1 = (function (){var statearr_24217 = state_24213;
(statearr_24217[(12)] = inst_24199);

(statearr_24217[(11)] = inst_24198__$1);

return statearr_24217;
})();
if(cljs.core.truth_(inst_24198__$1)){
var statearr_24218_24230 = state_24213__$1;
(statearr_24218_24230[(1)] = (4));

} else {
var statearr_24219_24231 = state_24213__$1;
(statearr_24219_24231[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24214 === (3))){
var inst_24211 = (state_24213[(2)]);
var state_24213__$1 = state_24213;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24213__$1,inst_24211);
} else {
if((state_val_24214 === (4))){
var inst_24198 = (state_24213[(11)]);
var inst_24201 = inst_24198.call(null,tuple);
var state_24213__$1 = state_24213;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24213__$1,(7),inst_24201);
} else {
if((state_val_24214 === (5))){
var inst_24192 = (state_24213[(9)]);
var state_24213__$1 = state_24213;
var statearr_24220_24232 = state_24213__$1;
(statearr_24220_24232[(2)] = inst_24192);

(statearr_24220_24232[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24214 === (6))){
var inst_24209 = (state_24213[(2)]);
var state_24213__$1 = state_24213;
var statearr_24221_24233 = state_24213__$1;
(statearr_24221_24233[(2)] = inst_24209);

(statearr_24221_24233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24214 === (7))){
var inst_24199 = (state_24213[(12)]);
var inst_24192 = (state_24213[(9)]);
var inst_24203 = (state_24213[(2)]);
var inst_24204 = fluree.db.util.async.throw_err.call(null,inst_24203);
var inst_24205 = cljs.core.conj.call(null,inst_24192,inst_24204);
var inst_24191 = inst_24199;
var inst_24192__$1 = inst_24205;
var state_24213__$1 = (function (){var statearr_24222 = state_24213;
(statearr_24222[(9)] = inst_24192__$1);

(statearr_24222[(10)] = inst_24191);

return statearr_24222;
})();
var statearr_24223_24234 = state_24213__$1;
(statearr_24223_24234[(2)] = null);

(statearr_24223_24234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2726__auto____0 = (function (){
var statearr_24224 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24224[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2726__auto__);

(statearr_24224[(1)] = (1));

return statearr_24224;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2726__auto____1 = (function (state_24213){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_24213);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e24225){var ex__2729__auto__ = e24225;
var statearr_24226_24235 = state_24213;
(statearr_24226_24235[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_24213[(4)]))){
var statearr_24227_24236 = state_24213;
(statearr_24227_24236[(1)] = cljs.core.first.call(null,(state_24213[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24237 = state_24213;
state_24213 = G__24237;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2726__auto__ = function(state_24213){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2726__auto____1.call(this,state_24213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2726__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2726__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_24228 = f__2749__auto__.call(null);
(statearr_24228[(6)] = c__2748__auto__);

return statearr_24228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24238){
var vec__24239 = p__24238;
var tuple_index = cljs.core.nth.call(null,vec__24239,(0),null);
var query_map = cljs.core.nth.call(null,vec__24239,(1),null);
var temp__5753__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_24253){
var state_val_24254 = (state_24253[(1)]);
if((state_val_24254 === (1))){
var inst_24242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24243 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24244 = [query_map,_id,query_opts];
var inst_24245 = cljs.core.PersistentHashMap.fromArrays(inst_24243,inst_24244);
var inst_24246 = fluree.db.query.fql.query.call(null,db,inst_24245);
var state_24253__$1 = (function (){var statearr_24255 = state_24253;
(statearr_24255[(7)] = inst_24242);

return statearr_24255;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24253__$1,(2),inst_24246);
} else {
if((state_val_24254 === (2))){
var inst_24242 = (state_24253[(7)]);
var inst_24248 = (state_24253[(2)]);
var inst_24249 = fluree.db.util.async.throw_err.call(null,inst_24248);
var inst_24250 = [tuple_index,inst_24249];
var inst_24251 = (new cljs.core.PersistentVector(null,2,(5),inst_24242,inst_24250,null));
var state_24253__$1 = state_24253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24253__$1,inst_24251);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2726__auto____0 = (function (){
var statearr_24256 = [null,null,null,null,null,null,null,null];
(statearr_24256[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2726__auto__);

(statearr_24256[(1)] = (1));

return statearr_24256;
});
var fluree$db$query$fql$expand_map_$_state_machine__2726__auto____1 = (function (state_24253){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_24253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e24257){var ex__2729__auto__ = e24257;
var statearr_24258_24261 = state_24253;
(statearr_24258_24261[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_24253[(4)]))){
var statearr_24259_24262 = state_24253;
(statearr_24259_24262[(1)] = cljs.core.first.call(null,(state_24253[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24263 = state_24253;
state_24253 = G__24263;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2726__auto__ = function(state_24253){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2726__auto____1.call(this,state_24253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2726__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2726__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_24260 = f__2749__auto__.call(null);
(statearr_24260[(6)] = c__2748__auto__);

return statearr_24260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24264 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24264,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24264,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_24329){
var state_val_24330 = (state_24329[(1)]);
if((state_val_24330 === (7))){
var inst_24324 = (state_24329[(2)]);
var _ = (function (){var statearr_24331 = state_24329;
(statearr_24331[(4)] = cljs.core.rest.call(null,(state_24329[(4)])));

return statearr_24331;
})();
var state_24329__$1 = state_24329;
var statearr_24332_24423 = state_24329__$1;
(statearr_24332_24423[(2)] = inst_24324);

(statearr_24332_24423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (20))){
var inst_24315 = (state_24329[(2)]);
var state_24329__$1 = state_24329;
var statearr_24333_24424 = state_24329__$1;
(statearr_24333_24424[(2)] = inst_24315);

(statearr_24333_24424[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (1))){
var state_24329__$1 = state_24329;
var statearr_24334_24425 = state_24329__$1;
(statearr_24334_24425[(2)] = null);

(statearr_24334_24425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (4))){
var inst_24269 = (state_24329[(2)]);
var state_24329__$1 = state_24329;
var statearr_24335_24426 = state_24329__$1;
(statearr_24335_24426[(2)] = inst_24269);

(statearr_24335_24426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (15))){
var inst_24289 = (state_24329[(7)]);
var inst_24298 = cljs.core._deref.call(null,fuel);
var inst_24299 = cljs.core.second.call(null,inst_24289);
var inst_24300 = (inst_24298 + inst_24299);
var inst_24301 = cljs.core._vreset_BANG_.call(null,fuel,inst_24300);
var inst_24302 = (inst_24301 > max_fuel);
var state_24329__$1 = state_24329;
if(cljs.core.truth_(inst_24302)){
var statearr_24336_24427 = state_24329__$1;
(statearr_24336_24427[(1)] = (18));

} else {
var statearr_24337_24428 = state_24329__$1;
(statearr_24337_24428[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (13))){
var state_24329__$1 = state_24329;
var statearr_24338_24429 = state_24329__$1;
(statearr_24338_24429[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (6))){
var inst_24277 = (state_24329[(8)]);
var state_24329__$1 = state_24329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24329__$1,(8),inst_24277);
} else {
if((state_val_24330 === (17))){
var inst_24318 = (state_24329[(2)]);
var state_24329__$1 = state_24329;
var statearr_24340_24430 = state_24329__$1;
(statearr_24340_24430[(2)] = inst_24318);

(statearr_24340_24430[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (3))){
var inst_24327 = (state_24329[(2)]);
var state_24329__$1 = state_24329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24329__$1,inst_24327);
} else {
if((state_val_24330 === (12))){
var inst_24289 = (state_24329[(7)]);
var inst_24278 = (state_24329[(9)]);
var inst_24295 = inst_24278.call(null);
var state_24329__$1 = (function (){var statearr_24341 = state_24329;
(statearr_24341[(10)] = inst_24295);

return statearr_24341;
})();
var statearr_24342_24431 = state_24329__$1;
(statearr_24342_24431[(2)] = inst_24289);

(statearr_24342_24431[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (2))){
var inst_24278 = (state_24329[(9)]);
var inst_24277 = (state_24329[(8)]);
var _ = (function (){var statearr_24343 = state_24329;
(statearr_24343[(4)] = cljs.core.cons.call(null,(5),(state_24329[(4)])));

return statearr_24343;
})();
var inst_24275 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24276 = cljs.core.async.chan.call(null);
var inst_24277__$1 = cljs.core.async.chan.call(null);
var inst_24278__$1 = (function (){var expandMaps = inst_24275;
var queue_ch = inst_24276;
var res_ch = inst_24277__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24279 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24280 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24281 = cljs.core.assoc.call(null,inst_24279,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24280);
var inst_24282 = (function (){var expandMaps = inst_24275;
var queue_ch = inst_24276;
var res_ch = inst_24277__$1;
var stop_BANG_ = inst_24278__$1;
var opts_STAR_ = inst_24281;
return (function (tuple_res,port){
var c__2748__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_24376){
var state_val_24377 = (state_24376[(1)]);
if((state_val_24377 === (7))){
var state_24376__$1 = state_24376;
var statearr_24378_24432 = state_24376__$1;
(statearr_24378_24432[(2)] = tuple_res);

(statearr_24378_24432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (1))){
var state_24376__$1 = state_24376;
var statearr_24379_24433 = state_24376__$1;
(statearr_24379_24433[(2)] = null);

(statearr_24379_24433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (4))){
var inst_24344 = (state_24376[(2)]);
var inst_24345 = cljs.core.async.put_BANG_.call(null,port,inst_24344);
var inst_24346 = cljs.core.async.close_BANG_.call(null,port);
var state_24376__$1 = (function (){var statearr_24380 = state_24376;
(statearr_24380[(7)] = inst_24345);

return statearr_24380;
})();
var statearr_24381_24434 = state_24376__$1;
(statearr_24381_24434[(2)] = inst_24346);

(statearr_24381_24434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (6))){
var inst_24353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24354 = [tuple_res];
var inst_24355 = (new cljs.core.PersistentVector(null,1,(5),inst_24353,inst_24354,null));
var state_24376__$1 = state_24376;
var statearr_24382_24435 = state_24376__$1;
(statearr_24382_24435[(2)] = inst_24355);

(statearr_24382_24435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (3))){
var inst_24374 = (state_24376[(2)]);
var state_24376__$1 = state_24376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24376__$1,inst_24374);
} else {
if((state_val_24377 === (2))){
var ___$1 = (function (){var statearr_24384 = state_24376;
(statearr_24384[(4)] = cljs.core.cons.call(null,(5),(state_24376[(4)])));

return statearr_24384;
})();
var state_24376__$1 = state_24376;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24385_24436 = state_24376__$1;
(statearr_24385_24436[(1)] = (6));

} else {
var statearr_24386_24437 = state_24376__$1;
(statearr_24386_24437[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (9))){
var inst_24360 = (state_24376[(8)]);
var inst_24358 = (state_24376[(9)]);
var inst_24367 = (state_24376[(2)]);
var inst_24368 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24358,inst_24367);
var inst_24369 = inst_24360.call(null,inst_24368);
var inst_24370 = cljs.core.async.put_BANG_.call(null,port,inst_24369);
var inst_24371 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24387 = state_24376;
(statearr_24387[(4)] = cljs.core.rest.call(null,(state_24376[(4)])));

return statearr_24387;
})();
var state_24376__$1 = (function (){var statearr_24388 = state_24376;
(statearr_24388[(10)] = inst_24370);

return statearr_24388;
})();
var statearr_24389_24438 = state_24376__$1;
(statearr_24389_24438[(2)] = inst_24371);

(statearr_24389_24438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (5))){
var ___$1 = (function (){var statearr_24390 = state_24376;
(statearr_24390[(4)] = cljs.core.rest.call(null,(state_24376[(4)])));

return statearr_24390;
})();
var state_24376__$1 = state_24376;
var ex24383 = (state_24376__$1[(2)]);
var statearr_24391_24439 = state_24376__$1;
(statearr_24391_24439[(5)] = ex24383);


var statearr_24392_24440 = state_24376__$1;
(statearr_24392_24440[(1)] = (4));

(statearr_24392_24440[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (8))){
var inst_24358 = (state_24376[(9)]);
var inst_24358__$1 = (state_24376[(2)]);
var inst_24359 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24360 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24358__$1;
var query_fuel = inst_24359;
return (function (p1__24268_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24268_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24268_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24361 = cljs.core.PersistentVector.EMPTY;
var inst_24362 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24358__$1;
var query_fuel = inst_24359;
return (function (p1__24267_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24267_SHARP_);
});
})();
var inst_24363 = cljs.core.keep.call(null,inst_24362,expandMaps);
var inst_24364 = cljs.core.async.merge.call(null,inst_24363);
var inst_24365 = cljs.core.async.into.call(null,inst_24361,inst_24364);
var state_24376__$1 = (function (){var statearr_24393 = state_24376;
(statearr_24393[(8)] = inst_24360);

(statearr_24393[(9)] = inst_24358__$1);

return statearr_24393;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24376__$1,(9),inst_24365);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____0 = (function (){
var statearr_24394 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24394[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__);

(statearr_24394[(1)] = (1));

return statearr_24394;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____1 = (function (state_24376){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_24376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e24395){var ex__2729__auto__ = e24395;
var statearr_24396_24441 = state_24376;
(statearr_24396_24441[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_24376[(4)]))){
var statearr_24397_24442 = state_24376;
(statearr_24397_24442[(1)] = cljs.core.first.call(null,(state_24376[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24443 = state_24376;
state_24376 = G__24443;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__ = function(state_24376){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____1.call(this,state_24376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_24398 = f__2749__auto__.call(null);
(statearr_24398[(6)] = c__2748__auto____$1);

return statearr_24398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto____$1;
});
})();
var inst_24283 = cljs.core.async.onto_chan_BANG_.call(null,inst_24276,tuples_res);
var inst_24284 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24277__$1,inst_24282,inst_24276);
var inst_24285 = cljs.core.PersistentVector.EMPTY;
var inst_24286 = inst_24285;
var state_24329__$1 = (function (){var statearr_24399 = state_24329;
(statearr_24399[(11)] = inst_24286);

(statearr_24399[(12)] = inst_24284);

(statearr_24399[(9)] = inst_24278__$1);

(statearr_24399[(8)] = inst_24277__$1);

(statearr_24399[(13)] = inst_24283);

return statearr_24399;
})();
var statearr_24400_24444 = state_24329__$1;
(statearr_24400_24444[(2)] = null);

(statearr_24400_24444[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (19))){
var inst_24289 = (state_24329[(7)]);
var inst_24286 = (state_24329[(11)]);
var inst_24311 = cljs.core.first.call(null,inst_24289);
var inst_24312 = cljs.core.conj.call(null,inst_24286,inst_24311);
var inst_24286__$1 = inst_24312;
var state_24329__$1 = (function (){var statearr_24401 = state_24329;
(statearr_24401[(11)] = inst_24286__$1);

return statearr_24401;
})();
var statearr_24402_24445 = state_24329__$1;
(statearr_24402_24445[(2)] = null);

(statearr_24402_24445[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (11))){
var inst_24322 = (state_24329[(2)]);
var state_24329__$1 = state_24329;
var statearr_24404_24446 = state_24329__$1;
(statearr_24404_24446[(2)] = inst_24322);

(statearr_24404_24446[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (9))){
var inst_24286 = (state_24329[(11)]);
var state_24329__$1 = state_24329;
var statearr_24405_24447 = state_24329__$1;
(statearr_24405_24447[(2)] = inst_24286);

(statearr_24405_24447[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (5))){
var _ = (function (){var statearr_24406 = state_24329;
(statearr_24406[(4)] = cljs.core.rest.call(null,(state_24329[(4)])));

return statearr_24406;
})();
var state_24329__$1 = state_24329;
var ex24403 = (state_24329__$1[(2)]);
var statearr_24407_24448 = state_24329__$1;
(statearr_24407_24448[(5)] = ex24403);


if((ex24403 instanceof Error)){
var statearr_24408_24449 = state_24329__$1;
(statearr_24408_24449[(1)] = (4));

(statearr_24408_24449[(5)] = null);

} else {
throw ex24403;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (14))){
var inst_24320 = (state_24329[(2)]);
var state_24329__$1 = state_24329;
var statearr_24409_24450 = state_24329__$1;
(statearr_24409_24450[(2)] = inst_24320);

(statearr_24409_24450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (16))){
var state_24329__$1 = state_24329;
var statearr_24410_24451 = state_24329__$1;
(statearr_24410_24451[(2)] = null);

(statearr_24410_24451[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (10))){
var inst_24289 = (state_24329[(7)]);
var inst_24293 = fluree.db.util.core.exception_QMARK_.call(null,inst_24289);
var state_24329__$1 = state_24329;
if(inst_24293){
var statearr_24411_24452 = state_24329__$1;
(statearr_24411_24452[(1)] = (12));

} else {
var statearr_24412_24453 = state_24329__$1;
(statearr_24412_24453[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (18))){
var inst_24278 = (state_24329[(9)]);
var inst_24304 = inst_24278.call(null);
var inst_24305 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24306 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24307 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24308 = cljs.core.PersistentHashMap.fromArrays(inst_24306,inst_24307);
var inst_24309 = cljs.core.ex_info.call(null,inst_24305,inst_24308);
var state_24329__$1 = (function (){var statearr_24413 = state_24329;
(statearr_24413[(14)] = inst_24304);

return statearr_24413;
})();
var statearr_24414_24454 = state_24329__$1;
(statearr_24414_24454[(2)] = inst_24309);

(statearr_24414_24454[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24330 === (8))){
var inst_24289 = (state_24329[(7)]);
var inst_24289__$1 = (state_24329[(2)]);
var inst_24290 = (inst_24289__$1 == null);
var state_24329__$1 = (function (){var statearr_24415 = state_24329;
(statearr_24415[(7)] = inst_24289__$1);

return statearr_24415;
})();
if(cljs.core.truth_(inst_24290)){
var statearr_24416_24455 = state_24329__$1;
(statearr_24416_24455[(1)] = (9));

} else {
var statearr_24417_24456 = state_24329__$1;
(statearr_24417_24456[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____0 = (function (){
var statearr_24418 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24418[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__);

(statearr_24418[(1)] = (1));

return statearr_24418;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____1 = (function (state_24329){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_24329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e24419){var ex__2729__auto__ = e24419;
var statearr_24420_24457 = state_24329;
(statearr_24420_24457[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_24329[(4)]))){
var statearr_24421_24458 = state_24329;
(statearr_24421_24458[(1)] = cljs.core.first.call(null,(state_24329[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24459 = state_24329;
state_24329 = G__24459;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__ = function(state_24329){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____1.call(this,state_24329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_24422 = f__2749__auto__.call(null);
(statearr_24422[(6)] = c__2748__auto__);

return statearr_24422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24460 = select;
var map__24460__$1 = cljs.core.__destructure_map.call(null,map__24460);
var as = cljs.core.get.call(null,map__24460__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__24460__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__24460__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24463 = orderBy;
var order = cljs.core.nth.call(null,vec__24463,(0),null);
var var$ = cljs.core.nth.call(null,vec__24463,(1),null);
var option = cljs.core.nth.call(null,vec__24463,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24461_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__24461_SHARP_,compare_idx));
}):(function (p1__24462_SHARP_){
return cljs.core.nth.call(null,p1__24462_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24468 = arguments.length;
switch (G__24468) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24469,p__24470,group_limit,opts){
var map__24471 = p__24469;
var map__24471__$1 = cljs.core.__destructure_map.call(null,map__24471);
var res = map__24471__$1;
var vars = cljs.core.get.call(null,map__24471__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24472 = p__24470;
var map__24472__$1 = cljs.core.__destructure_map.call(null,map__24472);
var select_spec = map__24472__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24472__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_24609){
var state_val_24610 = (state_24609[(1)]);
if((state_val_24610 === (7))){
var inst_24479 = (state_24609[(7)]);
var state_24609__$1 = state_24609;
var statearr_24611_24713 = state_24609__$1;
(statearr_24611_24713[(2)] = inst_24479);

(statearr_24611_24713[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (59))){
var inst_24602 = (state_24609[(2)]);
var state_24609__$1 = state_24609;
var statearr_24612_24714 = state_24609__$1;
(statearr_24612_24714[(2)] = inst_24602);

(statearr_24612_24714[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (20))){
var inst_24515 = (state_24609[(8)]);
var inst_24518 = (state_24609[(9)]);
var inst_24514 = (state_24609[(2)]);
var inst_24515__$1 = cljs.core.__destructure_map.call(null,inst_24514);
var inst_24516 = cljs.core.get.call(null,inst_24515__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24517 = cljs.core.get.call(null,inst_24515__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24518__$1 = offset;
var state_24609__$1 = (function (){var statearr_24613 = state_24609;
(statearr_24613[(10)] = inst_24516);

(statearr_24613[(8)] = inst_24515__$1);

(statearr_24613[(11)] = inst_24517);

(statearr_24613[(9)] = inst_24518__$1);

return statearr_24613;
})();
if(cljs.core.truth_(inst_24518__$1)){
var statearr_24614_24715 = state_24609__$1;
(statearr_24614_24715[(1)] = (21));

} else {
var statearr_24615_24716 = state_24609__$1;
(statearr_24615_24716[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (58))){
var inst_24594 = (state_24609[(12)]);
var state_24609__$1 = state_24609;
var statearr_24616_24717 = state_24609__$1;
(statearr_24616_24717[(2)] = inst_24594);

(statearr_24616_24717[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (60))){
var inst_24598 = (state_24609[(2)]);
var inst_24599 = fluree.db.util.async.throw_err.call(null,inst_24598);
var state_24609__$1 = state_24609;
var statearr_24617_24718 = state_24609__$1;
(statearr_24617_24718[(2)] = inst_24599);

(statearr_24617_24718[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (27))){
var inst_24530 = cljs.core.not.call(null,inVector_QMARK_);
var state_24609__$1 = state_24609;
var statearr_24618_24719 = state_24609__$1;
(statearr_24618_24719[(2)] = inst_24530);

(statearr_24618_24719[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (1))){
var state_24609__$1 = state_24609;
var statearr_24619_24720 = state_24609__$1;
(statearr_24619_24720[(2)] = null);

(statearr_24619_24720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (24))){
var state_24609__$1 = state_24609;
var statearr_24620_24721 = state_24609__$1;
(statearr_24620_24721[(2)] = offset);

(statearr_24620_24721[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (55))){
var inst_24588 = (state_24609[(13)]);
var state_24609__$1 = state_24609;
var statearr_24621_24722 = state_24609__$1;
(statearr_24621_24722[(2)] = inst_24588);

(statearr_24621_24722[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (39))){
var inst_24556 = (state_24609[(14)]);
var inst_24558 = cljs.core.distinct.call(null);
var inst_24559 = cljs.core.conj.call(null,inst_24556,inst_24558);
var state_24609__$1 = state_24609;
var statearr_24622_24723 = state_24609__$1;
(statearr_24622_24723[(2)] = inst_24559);

(statearr_24622_24723[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (46))){
var inst_24568 = (state_24609[(15)]);
var state_24609__$1 = state_24609;
var statearr_24623_24724 = state_24609__$1;
(statearr_24623_24724[(2)] = inst_24568);

(statearr_24623_24724[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (4))){
var inst_24473 = (state_24609[(2)]);
var state_24609__$1 = state_24609;
var statearr_24624_24725 = state_24609__$1;
(statearr_24624_24725[(2)] = inst_24473);

(statearr_24624_24725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (54))){
var inst_24588 = (state_24609[(13)]);
var inst_24582 = (state_24609[(16)]);
var inst_24590 = cljs.core.PersistentVector.EMPTY;
var inst_24591 = cljs.core.into.call(null,inst_24590,inst_24582,inst_24588);
var state_24609__$1 = state_24609;
var statearr_24625_24726 = state_24609__$1;
(statearr_24625_24726[(2)] = inst_24591);

(statearr_24625_24726[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (15))){
var inst_24500 = (state_24609[(17)]);
var inst_24502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24503 = [inst_24500];
var inst_24504 = (new cljs.core.PersistentVector(null,1,(5),inst_24502,inst_24503,null));
var state_24609__$1 = state_24609;
var statearr_24626_24727 = state_24609__$1;
(statearr_24626_24727[(2)] = inst_24504);

(statearr_24626_24727[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (48))){
var inst_24516 = (state_24609[(10)]);
var inst_24515 = (state_24609[(8)]);
var inst_24517 = (state_24609[(11)]);
var inst_24538 = (state_24609[(18)]);
var inst_24527 = (state_24609[(19)]);
var inst_24574 = (state_24609[(20)]);
var inst_24533 = (state_24609[(21)]);
var inst_24576 = (function (){var map__24509 = inst_24515;
var headers = inst_24516;
var tuples = inst_24517;
var offset_SINGLEQUOTE_ = inst_24527;
var single_result_QMARK_ = inst_24533;
var pp_keys = inst_24538;
var G__24539 = inst_24574;
return (function (p1__24466_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__24466_SHARP_);
});
})();
var inst_24577 = cljs.core.map.call(null,inst_24576);
var inst_24578 = cljs.core.conj.call(null,inst_24574,inst_24577);
var state_24609__$1 = state_24609;
var statearr_24627_24728 = state_24609__$1;
(statearr_24627_24728[(2)] = inst_24578);

(statearr_24627_24728[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (50))){
var inst_24581 = (state_24609[(2)]);
var inst_24582 = cljs.core.apply.call(null,cljs.core.comp,inst_24581);
var state_24609__$1 = (function (){var statearr_24628 = state_24609;
(statearr_24628[(16)] = inst_24582);

return statearr_24628;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24629_24729 = state_24609__$1;
(statearr_24629_24729[(1)] = (51));

} else {
var statearr_24630_24730 = state_24609__$1;
(statearr_24630_24730[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (21))){
var inst_24520 = cljs.core.not.call(null,groupBy);
var state_24609__$1 = state_24609;
var statearr_24631_24731 = state_24609__$1;
(statearr_24631_24731[(2)] = inst_24520);

(statearr_24631_24731[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (31))){
var state_24609__$1 = state_24609;
var statearr_24632_24732 = state_24609__$1;
(statearr_24632_24732[(2)] = null);

(statearr_24632_24732[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (32))){
var inst_24516 = (state_24609[(10)]);
var inst_24533 = (state_24609[(21)]);
var inst_24538 = (state_24609[(2)]);
var inst_24540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24541 = fluree.db.query.fql.select_tuples_fn.call(null,inst_24516,vars,select);
var inst_24542 = cljs.core.map.call(null,inst_24541);
var inst_24543 = [inst_24542];
var inst_24544 = (new cljs.core.PersistentVector(null,1,(5),inst_24540,inst_24543,null));
var state_24609__$1 = (function (){var statearr_24633 = state_24609;
(statearr_24633[(18)] = inst_24538);

(statearr_24633[(22)] = inst_24544);

return statearr_24633;
})();
if(cljs.core.truth_(inst_24533)){
var statearr_24634_24733 = state_24609__$1;
(statearr_24634_24733[(1)] = (33));

} else {
var statearr_24635_24734 = state_24609__$1;
(statearr_24635_24734[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (40))){
var inst_24556 = (state_24609[(14)]);
var state_24609__$1 = state_24609;
var statearr_24636_24735 = state_24609__$1;
(statearr_24636_24735[(2)] = inst_24556);

(statearr_24636_24735[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (56))){
var inst_24594 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24637 = state_24609;
(statearr_24637[(12)] = inst_24594);

return statearr_24637;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24638_24736 = state_24609__$1;
(statearr_24638_24736[(1)] = (57));

} else {
var statearr_24639_24737 = state_24609__$1;
(statearr_24639_24737[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (33))){
var inst_24544 = (state_24609[(22)]);
var inst_24546 = cljs.core.map.call(null,cljs.core.first);
var inst_24547 = cljs.core.conj.call(null,inst_24544,inst_24546);
var state_24609__$1 = state_24609;
var statearr_24640_24738 = state_24609__$1;
(statearr_24640_24738[(2)] = inst_24547);

(statearr_24640_24738[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (13))){
var inst_24489 = (state_24609[(23)]);
var state_24609__$1 = state_24609;
var statearr_24641_24739 = state_24609__$1;
(statearr_24641_24739[(2)] = inst_24489);

(statearr_24641_24739[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (22))){
var inst_24518 = (state_24609[(9)]);
var state_24609__$1 = state_24609;
var statearr_24642_24740 = state_24609__$1;
(statearr_24642_24740[(2)] = inst_24518);

(statearr_24642_24740[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (36))){
var inst_24550 = (state_24609[(24)]);
var inst_24552 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_24553 = cljs.core.conj.call(null,inst_24550,inst_24552);
var state_24609__$1 = state_24609;
var statearr_24643_24741 = state_24609__$1;
(statearr_24643_24741[(2)] = inst_24553);

(statearr_24643_24741[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (41))){
var inst_24527 = (state_24609[(19)]);
var inst_24562 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24644 = state_24609;
(statearr_24644[(25)] = inst_24562);

return statearr_24644;
})();
if(cljs.core.truth_(inst_24527)){
var statearr_24645_24742 = state_24609__$1;
(statearr_24645_24742[(1)] = (42));

} else {
var statearr_24646_24743 = state_24609__$1;
(statearr_24646_24743[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (43))){
var inst_24562 = (state_24609[(25)]);
var state_24609__$1 = state_24609;
var statearr_24647_24744 = state_24609__$1;
(statearr_24647_24744[(2)] = inst_24562);

(statearr_24647_24744[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (29))){
var inst_24533 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24648 = state_24609;
(statearr_24648[(21)] = inst_24533);

return statearr_24648;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24649_24745 = state_24609__$1;
(statearr_24649_24745[(1)] = (30));

} else {
var statearr_24650_24746 = state_24609__$1;
(statearr_24650_24746[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (44))){
var inst_24568 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24651 = state_24609;
(statearr_24651[(15)] = inst_24568);

return statearr_24651;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24652_24747 = state_24609__$1;
(statearr_24652_24747[(1)] = (45));

} else {
var statearr_24653_24748 = state_24609__$1;
(statearr_24653_24748[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (6))){
var inst_24481 = cljs.core.count.call(null,select);
var inst_24482 = cljs.core._EQ_.call(null,(1),inst_24481);
var state_24609__$1 = state_24609;
var statearr_24654_24749 = state_24609__$1;
(statearr_24654_24749[(2)] = inst_24482);

(statearr_24654_24749[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (28))){
var inst_24528 = (state_24609[(26)]);
var state_24609__$1 = state_24609;
var statearr_24655_24750 = state_24609__$1;
(statearr_24655_24750[(2)] = inst_24528);

(statearr_24655_24750[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (51))){
var inst_24516 = (state_24609[(10)]);
var inst_24517 = (state_24609[(11)]);
var inst_24585 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_24516,orderBy,inst_24517);
var state_24609__$1 = state_24609;
var statearr_24656_24751 = state_24609__$1;
(statearr_24656_24751[(2)] = inst_24585);

(statearr_24656_24751[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (25))){
var state_24609__$1 = state_24609;
var statearr_24657_24752 = state_24609__$1;
(statearr_24657_24752[(2)] = null);

(statearr_24657_24752[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (34))){
var inst_24544 = (state_24609[(22)]);
var state_24609__$1 = state_24609;
var statearr_24658_24753 = state_24609__$1;
(statearr_24658_24753[(2)] = inst_24544);

(statearr_24658_24753[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (17))){
var inst_24507 = (state_24609[(2)]);
var state_24609__$1 = state_24609;
var statearr_24659_24754 = state_24609__$1;
(statearr_24659_24754[(2)] = inst_24507);

(statearr_24659_24754[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (3))){
var inst_24607 = (state_24609[(2)]);
var state_24609__$1 = state_24609;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24609__$1,inst_24607);
} else {
if((state_val_24610 === (12))){
var inst_24489 = (state_24609[(23)]);
var inst_24491 = cljs.core.first.call(null,select);
var inst_24492 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24491);
var inst_24493 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24492);
var inst_24494 = cljs.core.subs.call(null,inst_24493,(1));
var inst_24495 = [inst_24494];
var inst_24496 = [inst_24489];
var inst_24497 = cljs.core.PersistentHashMap.fromArrays(inst_24495,inst_24496);
var state_24609__$1 = state_24609;
var statearr_24660_24755 = state_24609__$1;
(statearr_24660_24755[(2)] = inst_24497);

(statearr_24660_24755[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (2))){
var inst_24479 = (state_24609[(7)]);
var _ = (function (){var statearr_24661 = state_24609;
(statearr_24661[(4)] = cljs.core.cons.call(null,(5),(state_24609[(4)])));

return statearr_24661;
})();
var inst_24479__$1 = aggregates;
var state_24609__$1 = (function (){var statearr_24662 = state_24609;
(statearr_24662[(7)] = inst_24479__$1);

return statearr_24662;
})();
if(cljs.core.truth_(inst_24479__$1)){
var statearr_24663_24756 = state_24609__$1;
(statearr_24663_24756[(1)] = (6));

} else {
var statearr_24664_24757 = state_24609__$1;
(statearr_24664_24757[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (23))){
var inst_24523 = (state_24609[(2)]);
var state_24609__$1 = state_24609;
if(cljs.core.truth_(inst_24523)){
var statearr_24665_24758 = state_24609__$1;
(statearr_24665_24758[(1)] = (24));

} else {
var statearr_24666_24759 = state_24609__$1;
(statearr_24666_24759[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (47))){
var inst_24574 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24667 = state_24609;
(statearr_24667[(20)] = inst_24574);

return statearr_24667;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24668_24760 = state_24609__$1;
(statearr_24668_24760[(1)] = (48));

} else {
var statearr_24669_24761 = state_24609__$1;
(statearr_24669_24761[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (35))){
var inst_24550 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24670 = state_24609;
(statearr_24670[(24)] = inst_24550);

return statearr_24670;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24671_24762 = state_24609__$1;
(statearr_24671_24762[(1)] = (36));

} else {
var statearr_24672_24763 = state_24609__$1;
(statearr_24672_24763[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (19))){
var state_24609__$1 = state_24609;
var statearr_24673_24764 = state_24609__$1;
(statearr_24673_24764[(2)] = res);

(statearr_24673_24764[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (57))){
var inst_24538 = (state_24609[(18)]);
var inst_24594 = (state_24609[(12)]);
var inst_24533 = (state_24609[(21)]);
var inst_24596 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_24538,inst_24533,db,fuel,max_fuel,opts,(8),inst_24594);
var state_24609__$1 = state_24609;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24609__$1,(60),inst_24596);
} else {
if((state_val_24610 === (11))){
var inst_24604 = (state_24609[(2)]);
var _ = (function (){var statearr_24675 = state_24609;
(statearr_24675[(4)] = cljs.core.rest.call(null,(state_24609[(4)])));

return statearr_24675;
})();
var state_24609__$1 = state_24609;
var statearr_24676_24765 = state_24609__$1;
(statearr_24676_24765[(2)] = inst_24604);

(statearr_24676_24765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (9))){
var inst_24487 = cljs.core.first.call(null,aggregates);
var inst_24488 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24487);
var inst_24489 = cljs.core.second.call(null,inst_24488);
var state_24609__$1 = (function (){var statearr_24677 = state_24609;
(statearr_24677[(23)] = inst_24489);

return statearr_24677;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24678_24766 = state_24609__$1;
(statearr_24678_24766[(1)] = (12));

} else {
var statearr_24679_24767 = state_24609__$1;
(statearr_24679_24767[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (5))){
var _ = (function (){var statearr_24680 = state_24609;
(statearr_24680[(4)] = cljs.core.rest.call(null,(state_24609[(4)])));

return statearr_24680;
})();
var state_24609__$1 = state_24609;
var ex24674 = (state_24609__$1[(2)]);
var statearr_24681_24768 = state_24609__$1;
(statearr_24681_24768[(5)] = ex24674);


if((ex24674 instanceof Error)){
var statearr_24682_24769 = state_24609__$1;
(statearr_24682_24769[(1)] = (4));

(statearr_24682_24769[(5)] = null);

} else {
throw ex24674;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (14))){
var inst_24500 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24683 = state_24609;
(statearr_24683[(17)] = inst_24500);

return statearr_24683;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24684_24770 = state_24609__$1;
(statearr_24684_24770[(1)] = (15));

} else {
var statearr_24685_24771 = state_24609__$1;
(statearr_24685_24771[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (45))){
var inst_24568 = (state_24609[(15)]);
var inst_24570 = cljs.core.take.call(null,group_limit);
var inst_24571 = cljs.core.conj.call(null,inst_24568,inst_24570);
var state_24609__$1 = state_24609;
var statearr_24686_24772 = state_24609__$1;
(statearr_24686_24772[(2)] = inst_24571);

(statearr_24686_24772[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (53))){
var inst_24588 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24687 = state_24609;
(statearr_24687[(13)] = inst_24588);

return statearr_24687;
})();
var statearr_24688_24773 = state_24609__$1;
(statearr_24688_24773[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (26))){
var inst_24528 = (state_24609[(26)]);
var inst_24527 = (state_24609[(2)]);
var inst_24528__$1 = cljs.core.not.call(null,prettyPrint);
var state_24609__$1 = (function (){var statearr_24690 = state_24609;
(statearr_24690[(26)] = inst_24528__$1);

(statearr_24690[(19)] = inst_24527);

return statearr_24690;
})();
if(inst_24528__$1){
var statearr_24691_24774 = state_24609__$1;
(statearr_24691_24774[(1)] = (27));

} else {
var statearr_24692_24775 = state_24609__$1;
(statearr_24692_24775[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (16))){
var inst_24500 = (state_24609[(17)]);
var state_24609__$1 = state_24609;
var statearr_24693_24776 = state_24609__$1;
(statearr_24693_24776[(2)] = inst_24500);

(statearr_24693_24776[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (38))){
var inst_24556 = (state_24609[(2)]);
var state_24609__$1 = (function (){var statearr_24694 = state_24609;
(statearr_24694[(14)] = inst_24556);

return statearr_24694;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24695_24777 = state_24609__$1;
(statearr_24695_24777[(1)] = (39));

} else {
var statearr_24696_24778 = state_24609__$1;
(statearr_24696_24778[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (30))){
var inst_24535 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24609__$1 = state_24609;
var statearr_24697_24779 = state_24609__$1;
(statearr_24697_24779[(2)] = inst_24535);

(statearr_24697_24779[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (10))){
var state_24609__$1 = state_24609;
if(cljs.core.truth_(aggregates)){
var statearr_24698_24780 = state_24609__$1;
(statearr_24698_24780[(1)] = (18));

} else {
var statearr_24699_24781 = state_24609__$1;
(statearr_24699_24781[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (18))){
var inst_24511 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24609__$1 = state_24609;
var statearr_24700_24782 = state_24609__$1;
(statearr_24700_24782[(2)] = inst_24511);

(statearr_24700_24782[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (52))){
var inst_24517 = (state_24609[(11)]);
var state_24609__$1 = state_24609;
var statearr_24701_24783 = state_24609__$1;
(statearr_24701_24783[(2)] = inst_24517);

(statearr_24701_24783[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (42))){
var inst_24562 = (state_24609[(25)]);
var inst_24527 = (state_24609[(19)]);
var inst_24564 = cljs.core.drop.call(null,inst_24527);
var inst_24565 = cljs.core.conj.call(null,inst_24562,inst_24564);
var state_24609__$1 = state_24609;
var statearr_24702_24784 = state_24609__$1;
(statearr_24702_24784[(2)] = inst_24565);

(statearr_24702_24784[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (37))){
var inst_24550 = (state_24609[(24)]);
var state_24609__$1 = state_24609;
var statearr_24703_24785 = state_24609__$1;
(statearr_24703_24785[(2)] = inst_24550);

(statearr_24703_24785[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (8))){
var inst_24485 = (state_24609[(2)]);
var state_24609__$1 = state_24609;
if(cljs.core.truth_(inst_24485)){
var statearr_24704_24786 = state_24609__$1;
(statearr_24704_24786[(1)] = (9));

} else {
var statearr_24705_24787 = state_24609__$1;
(statearr_24705_24787[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24610 === (49))){
var inst_24574 = (state_24609[(20)]);
var state_24609__$1 = state_24609;
var statearr_24706_24788 = state_24609__$1;
(statearr_24706_24788[(2)] = inst_24574);

(statearr_24706_24788[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2726__auto__ = null;
var fluree$db$query$fql$state_machine__2726__auto____0 = (function (){
var statearr_24707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24707[(0)] = fluree$db$query$fql$state_machine__2726__auto__);

(statearr_24707[(1)] = (1));

return statearr_24707;
});
var fluree$db$query$fql$state_machine__2726__auto____1 = (function (state_24609){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_24609);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e24708){var ex__2729__auto__ = e24708;
var statearr_24709_24789 = state_24609;
(statearr_24709_24789[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_24609[(4)]))){
var statearr_24710_24790 = state_24609;
(statearr_24710_24790[(1)] = cljs.core.first.call(null,(state_24609[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24791 = state_24609;
state_24609 = G__24791;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2726__auto__ = function(state_24609){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2726__auto____1.call(this,state_24609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2726__auto____0;
fluree$db$query$fql$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2726__auto____1;
return fluree$db$query$fql$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_24711 = f__2749__auto__.call(null);
(statearr_24711[(6)] = c__2748__auto__);

return statearr_24711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24794,groupBy){
var map__24795 = p__24794;
var map__24795__$1 = cljs.core.__destructure_map.call(null,map__24795);
var res = map__24795__$1;
var headers = cljs.core.get.call(null,map__24795__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__24795__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24796 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__24796,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__24796,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__24792_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__24792_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__24793_SHARP_){
return cljs.core.nth.call(null,tuple,p1__24793_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__24799 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__24799,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__24799,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__24802,p__24803,opts){
var map__24804 = p__24802;
var map__24804__$1 = cljs.core.__destructure_map.call(null,map__24804);
var res = map__24804__$1;
var headers = cljs.core.get.call(null,map__24804__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__24804__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24805 = p__24803;
var map__24805__$1 = cljs.core.__destructure_map.call(null,map__24805);
var select_spec = map__24805__$1;
var groupBy = cljs.core.get.call(null,map__24805__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__24805__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24805__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__24805__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24805__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__24805__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__24805__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_25023){
var state_val_25024 = (state_25023[(1)]);
if((state_val_25024 === (65))){
var inst_24936 = (state_25023[(7)]);
var inst_24964 = cljs.core.empty_QMARK_.call(null,inst_24936);
var state_25023__$1 = state_25023;
var statearr_25025_25158 = state_25023__$1;
(statearr_25025_25158[(2)] = inst_24964);

(statearr_25025_25158[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (70))){
var state_25023__$1 = state_25023;
var statearr_25026_25159 = state_25023__$1;
(statearr_25026_25159[(2)] = (1));

(statearr_25026_25159[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (62))){
var state_25023__$1 = state_25023;
var statearr_25027_25160 = state_25023__$1;
(statearr_25027_25160[(2)] = null);

(statearr_25027_25160[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (74))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25028_25161 = state_25023__$1;
(statearr_25028_25161[(1)] = (77));

} else {
var statearr_25029_25162 = state_25023__$1;
(statearr_25029_25162[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (7))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25030_25163 = state_25023__$1;
(statearr_25030_25163[(1)] = (70));

} else {
var statearr_25031_25164 = state_25023__$1;
(statearr_25031_25164[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (59))){
var state_25023__$1 = state_25023;
var statearr_25032_25165 = state_25023__$1;
(statearr_25032_25165[(1)] = (61));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (20))){
var state_25023__$1 = state_25023;
var statearr_25034_25166 = state_25023__$1;
(statearr_25034_25166[(2)] = (0));

(statearr_25034_25166[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (72))){
var inst_24990 = (state_25023[(2)]);
var inst_24991 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_24990,opts);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(73),inst_24991);
} else {
if((state_val_25024 === (58))){
var inst_24874 = (state_25023[(8)]);
var inst_24948 = (inst_24874 - (1));
var state_25023__$1 = state_25023;
var statearr_25035_25167 = state_25023__$1;
(statearr_25035_25167[(2)] = inst_24948);

(statearr_25035_25167[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (60))){
var inst_24958 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25036_25168 = state_25023__$1;
(statearr_25036_25168[(2)] = inst_24958);

(statearr_25036_25168[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (27))){
var inst_24873 = (state_25023[(9)]);
var inst_24897 = (inst_24873 < (1));
var state_25023__$1 = state_25023;
var statearr_25037_25169 = state_25023__$1;
(statearr_25037_25169[(2)] = inst_24897);

(statearr_25037_25169[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (1))){
var state_25023__$1 = state_25023;
var statearr_25038_25170 = state_25023__$1;
(statearr_25038_25170[(2)] = null);

(statearr_25038_25170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (69))){
var inst_24888 = (state_25023[(10)]);
var inst_24943 = (state_25023[(11)]);
var inst_24885 = (state_25023[(12)]);
var inst_24960 = (state_25023[(13)]);
var inst_24971 = (state_25023[(2)]);
var inst_24871 = inst_24885;
var inst_24872 = inst_24888;
var inst_24873 = inst_24943;
var inst_24874 = inst_24960;
var inst_24875 = inst_24971;
var state_25023__$1 = (function (){var statearr_25039 = state_25023;
(statearr_25039[(14)] = inst_24872);

(statearr_25039[(9)] = inst_24873);

(statearr_25039[(8)] = inst_24874);

(statearr_25039[(15)] = inst_24875);

(statearr_25039[(16)] = inst_24871);

return statearr_25039;
})();
var statearr_25040_25171 = state_25023__$1;
(statearr_25040_25171[(2)] = null);

(statearr_25040_25171[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (24))){
var inst_24875 = (state_25023[(15)]);
var state_25023__$1 = state_25023;
var statearr_25041_25172 = state_25023__$1;
(statearr_25041_25172[(2)] = inst_24875);

(statearr_25041_25172[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (55))){
var state_25023__$1 = state_25023;
var statearr_25042_25173 = state_25023__$1;
(statearr_25042_25173[(2)] = (0));

(statearr_25042_25173[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (85))){
var inst_25012 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25043_25174 = state_25023__$1;
(statearr_25043_25174[(2)] = inst_25012);

(statearr_25043_25174[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (39))){
var inst_24892 = (state_25023[(17)]);
var inst_24915 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_24916 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_24917 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_24892,inst_24915,inst_24916);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(42),inst_24917);
} else {
if((state_val_25024 === (46))){
var inst_24873 = (state_25023[(9)]);
var inst_24928 = ((0) < inst_24873);
var state_25023__$1 = state_25023;
var statearr_25044_25175 = state_25023__$1;
(statearr_25044_25175[(2)] = inst_24928);

(statearr_25044_25175[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (4))){
var inst_24806 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25045_25176 = state_25023__$1;
(statearr_25045_25176[(2)] = inst_24806);

(statearr_25045_25176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (77))){
var inst_24994 = (state_25023[(18)]);
var inst_24999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25000 = [inst_24994];
var inst_25001 = (new cljs.core.PersistentVector(null,1,(5),inst_24999,inst_25000,null));
var state_25023__$1 = state_25023;
var statearr_25046_25177 = state_25023__$1;
(statearr_25046_25177[(2)] = inst_25001);

(statearr_25046_25177[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (54))){
var inst_24874 = (state_25023[(8)]);
var inst_24943 = (state_25023[(2)]);
var inst_24944 = (inst_24874 <= (0));
var state_25023__$1 = (function (){var statearr_25047 = state_25023;
(statearr_25047[(11)] = inst_24943);

return statearr_25047;
})();
if(cljs.core.truth_(inst_24944)){
var statearr_25048_25178 = state_25023__$1;
(statearr_25048_25178[(1)] = (55));

} else {
var statearr_25049_25179 = state_25023__$1;
(statearr_25049_25179[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (15))){
var inst_24824 = (state_25023[(19)]);
var inst_24832 = (state_25023[(2)]);
var inst_24833 = fluree.db.util.async.throw_err.call(null,inst_24832);
var inst_24834 = [inst_24824];
var inst_24835 = [inst_24833];
var inst_24836 = cljs.core.PersistentHashMap.fromArrays(inst_24834,inst_24835);
var state_25023__$1 = state_25023;
var statearr_25050_25180 = state_25023__$1;
(statearr_25050_25180[(2)] = inst_24836);

(statearr_25050_25180[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (48))){
var inst_24931 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24931)){
var statearr_25051_25181 = state_25023__$1;
(statearr_25051_25181[(1)] = (49));

} else {
var statearr_25052_25182 = state_25023__$1;
(statearr_25052_25182[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (50))){
var inst_24926 = (state_25023[(20)]);
var state_25023__$1 = state_25023;
var statearr_25053_25183 = state_25023__$1;
(statearr_25053_25183[(2)] = inst_24926);

(statearr_25053_25183[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (75))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25054_25184 = state_25023__$1;
(statearr_25054_25184[(1)] = (80));

} else {
var statearr_25055_25185 = state_25023__$1;
(statearr_25055_25185[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (21))){
var inst_24856 = (state_25023[(21)]);
var inst_24864 = (state_25023[(22)]);
var inst_24852 = (state_25023[(23)]);
var inst_24869 = (state_25023[(2)]);
var inst_24870 = cljs.core.PersistentHashMap.EMPTY;
var inst_24871 = inst_24852;
var inst_24872 = inst_24856;
var inst_24873 = inst_24864;
var inst_24874 = inst_24869;
var inst_24875 = inst_24870;
var state_25023__$1 = (function (){var statearr_25056 = state_25023;
(statearr_25056[(14)] = inst_24872);

(statearr_25056[(9)] = inst_24873);

(statearr_25056[(8)] = inst_24874);

(statearr_25056[(15)] = inst_24875);

(statearr_25056[(16)] = inst_24871);

return statearr_25056;
})();
var statearr_25057_25186 = state_25023__$1;
(statearr_25057_25186[(2)] = null);

(statearr_25057_25186[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (31))){
var inst_24874 = (state_25023[(8)]);
var inst_24889 = (state_25023[(24)]);
var inst_24903 = (inst_24874 >= inst_24889);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24903)){
var statearr_25058_25187 = state_25023__$1;
(statearr_25058_25187[(1)] = (33));

} else {
var statearr_25059_25188 = state_25023__$1;
(statearr_25059_25188[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (32))){
var inst_24979 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25060_25189 = state_25023__$1;
(statearr_25060_25189[(2)] = inst_24979);

(statearr_25060_25189[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (40))){
var state_25023__$1 = state_25023;
var statearr_25061_25190 = state_25023__$1;
(statearr_25061_25190[(2)] = null);

(statearr_25061_25190[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (56))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25062_25191 = state_25023__$1;
(statearr_25062_25191[(1)] = (58));

} else {
var statearr_25063_25192 = state_25023__$1;
(statearr_25063_25192[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (33))){
var state_25023__$1 = state_25023;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25064_25193 = state_25023__$1;
(statearr_25064_25193[(1)] = (36));

} else {
var statearr_25065_25194 = state_25023__$1;
(statearr_25065_25194[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (13))){
var inst_24856 = (state_25023[(21)]);
var inst_24821 = (state_25023[(25)]);
var inst_24852 = (state_25023[(23)]);
var inst_24852__$1 = cljs.core.keys.call(null,inst_24821);
var inst_24853 = cljs.core.seq.call(null,inst_24852__$1);
var inst_24854 = cljs.core.first.call(null,inst_24853);
var inst_24855 = cljs.core.next.call(null,inst_24853);
var inst_24856__$1 = cljs.core.vals.call(null,inst_24821);
var inst_24857 = cljs.core.seq.call(null,inst_24856__$1);
var inst_24858 = cljs.core.first.call(null,inst_24857);
var inst_24859 = cljs.core.next.call(null,inst_24857);
var inst_24860 = cljs.core._EQ_.call(null,(0),limit);
var state_25023__$1 = (function (){var statearr_25066 = state_25023;
(statearr_25066[(26)] = inst_24858);

(statearr_25066[(27)] = inst_24859);

(statearr_25066[(28)] = inst_24854);

(statearr_25066[(21)] = inst_24856__$1);

(statearr_25066[(29)] = inst_24855);

(statearr_25066[(23)] = inst_24852__$1);

return statearr_25066;
})();
if(inst_24860){
var statearr_25067_25195 = state_25023__$1;
(statearr_25067_25195[(1)] = (16));

} else {
var statearr_25068_25196 = state_25023__$1;
(statearr_25068_25196[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (22))){
var inst_24872 = (state_25023[(14)]);
var inst_24871 = (state_25023[(16)]);
var inst_24883 = cljs.core.seq.call(null,inst_24871);
var inst_24884 = cljs.core.first.call(null,inst_24883);
var inst_24885 = cljs.core.next.call(null,inst_24883);
var inst_24886 = cljs.core.seq.call(null,inst_24872);
var inst_24887 = cljs.core.first.call(null,inst_24886);
var inst_24888 = cljs.core.next.call(null,inst_24886);
var inst_24889 = cljs.core.count.call(null,inst_24887);
var inst_24890 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24891 = [headers,vars,inst_24887];
var inst_24892 = cljs.core.PersistentHashMap.fromArrays(inst_24890,inst_24891);
var inst_24893 = (inst_24887 == null);
var state_25023__$1 = (function (){var statearr_25069 = state_25023;
(statearr_25069[(10)] = inst_24888);

(statearr_25069[(24)] = inst_24889);

(statearr_25069[(12)] = inst_24885);

(statearr_25069[(17)] = inst_24892);

(statearr_25069[(30)] = inst_24884);

return statearr_25069;
})();
if(cljs.core.truth_(inst_24893)){
var statearr_25070_25197 = state_25023__$1;
(statearr_25070_25197[(1)] = (24));

} else {
var statearr_25071_25198 = state_25023__$1;
(statearr_25071_25198[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (36))){
var inst_24874 = (state_25023[(8)]);
var inst_24906 = (inst_24874 - (1));
var state_25023__$1 = state_25023;
var statearr_25072_25199 = state_25023__$1;
(statearr_25072_25199[(2)] = inst_24906);

(statearr_25072_25199[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (41))){
var inst_24975 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25073_25200 = state_25023__$1;
(statearr_25073_25200[(2)] = inst_24975);

(statearr_25073_25200[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (43))){
var inst_24874 = (state_25023[(8)]);
var inst_24920 = (state_25023[(31)]);
var inst_24923 = cljs.core.drop.call(null,inst_24874,inst_24920);
var state_25023__$1 = state_25023;
var statearr_25074_25201 = state_25023__$1;
(statearr_25074_25201[(2)] = inst_24923);

(statearr_25074_25201[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (61))){
var inst_24936 = (state_25023[(7)]);
var inst_24874 = (state_25023[(8)]);
var inst_24889 = (state_25023[(24)]);
var inst_24951 = cljs.core.count.call(null,inst_24936);
var inst_24952 = (inst_24889 - inst_24951);
var inst_24953 = (inst_24874 - inst_24952);
var state_25023__$1 = state_25023;
var statearr_25075_25202 = state_25023__$1;
(statearr_25075_25202[(2)] = inst_24953);

(statearr_25075_25202[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (29))){
var inst_24900 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24900)){
var statearr_25076_25203 = state_25023__$1;
(statearr_25076_25203[(1)] = (30));

} else {
var statearr_25077_25204 = state_25023__$1;
(statearr_25077_25204[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (44))){
var inst_24920 = (state_25023[(31)]);
var state_25023__$1 = state_25023;
var statearr_25078_25205 = state_25023__$1;
(statearr_25078_25205[(2)] = inst_24920);

(statearr_25078_25205[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (6))){
var inst_24813 = (state_25023[(32)]);
var inst_24813__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_24815 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25023__$1 = (function (){var statearr_25079 = state_25023;
(statearr_25079[(33)] = inst_24815);

(statearr_25079[(32)] = inst_24813__$1);

return statearr_25079;
})();
if(cljs.core.truth_(inst_24813__$1)){
var statearr_25080_25206 = state_25023__$1;
(statearr_25080_25206[(1)] = (9));

} else {
var statearr_25081_25207 = state_25023__$1;
(statearr_25081_25207[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (28))){
var inst_24873 = (state_25023[(9)]);
var state_25023__$1 = state_25023;
var statearr_25082_25208 = state_25023__$1;
(statearr_25082_25208[(2)] = inst_24873);

(statearr_25082_25208[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (64))){
var inst_24961 = (state_25023[(34)]);
var state_25023__$1 = state_25023;
var statearr_25083_25209 = state_25023__$1;
(statearr_25083_25209[(2)] = inst_24961);

(statearr_25083_25209[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (51))){
var inst_24873 = (state_25023[(9)]);
var inst_24936 = (state_25023[(2)]);
var inst_24937 = (inst_24873 == null);
var state_25023__$1 = (function (){var statearr_25084 = state_25023;
(statearr_25084[(7)] = inst_24936);

return statearr_25084;
})();
if(cljs.core.truth_(inst_24937)){
var statearr_25085_25210 = state_25023__$1;
(statearr_25085_25210[(1)] = (52));

} else {
var statearr_25086_25211 = state_25023__$1;
(statearr_25086_25211[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (25))){
var inst_24873 = (state_25023[(9)]);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24873)){
var statearr_25087_25212 = state_25023__$1;
(statearr_25087_25212[(1)] = (27));

} else {
var statearr_25088_25213 = state_25023__$1;
(statearr_25088_25213[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (34))){
var state_25023__$1 = state_25023;
var statearr_25089_25214 = state_25023__$1;
(statearr_25089_25214[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (17))){
var state_25023__$1 = state_25023;
var statearr_25091_25215 = state_25023__$1;
(statearr_25091_25215[(2)] = limit);

(statearr_25091_25215[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (3))){
var inst_25021 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25023__$1,inst_25021);
} else {
if((state_val_25024 === (12))){
var inst_24821 = (state_25023[(25)]);
var inst_24823 = cljs.core.keys.call(null,inst_24821);
var inst_24824 = cljs.core.first.call(null,inst_24823);
var inst_24825 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24826 = cljs.core.vals.call(null,inst_24821);
var inst_24827 = cljs.core.first.call(null,inst_24826);
var inst_24828 = [headers,vars,inst_24827];
var inst_24829 = cljs.core.PersistentHashMap.fromArrays(inst_24825,inst_24828);
var inst_24830 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_24829,select_spec,limit,opts);
var state_25023__$1 = (function (){var statearr_25092 = state_25023;
(statearr_25092[(19)] = inst_24824);

return statearr_25092;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25023__$1,(15),inst_24830);
} else {
if((state_val_25024 === (2))){
var _ = (function (){var statearr_25093 = state_25023;
(statearr_25093[(4)] = cljs.core.cons.call(null,(5),(state_25023[(4)])));

return statearr_25093;
})();
var state_25023__$1 = state_25023;
if(cljs.core.truth_(groupBy)){
var statearr_25094_25216 = state_25023__$1;
(statearr_25094_25216[(1)] = (6));

} else {
var statearr_25095_25217 = state_25023__$1;
(statearr_25095_25217[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (66))){
var inst_24966 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
if(cljs.core.truth_(inst_24966)){
var statearr_25096_25218 = state_25023__$1;
(statearr_25096_25218[(1)] = (67));

} else {
var statearr_25097_25219 = state_25023__$1;
(statearr_25097_25219[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (23))){
var inst_24983 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25098_25220 = state_25023__$1;
(statearr_25098_25220[(2)] = inst_24983);

(statearr_25098_25220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (47))){
var inst_24873 = (state_25023[(9)]);
var state_25023__$1 = state_25023;
var statearr_25099_25221 = state_25023__$1;
(statearr_25099_25221[(2)] = inst_24873);

(statearr_25099_25221[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (35))){
var inst_24977 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25100_25222 = state_25023__$1;
(statearr_25100_25222[(2)] = inst_24977);

(statearr_25100_25222[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (82))){
var inst_25014 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25101_25223 = state_25023__$1;
(statearr_25101_25223[(2)] = inst_25014);

(statearr_25101_25223[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (76))){
var inst_25016 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25102_25224 = state_25023__$1;
(statearr_25102_25224[(2)] = inst_25016);

(statearr_25102_25224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (19))){
var inst_24865 = (state_25023[(35)]);
var state_25023__$1 = state_25023;
var statearr_25103_25225 = state_25023__$1;
(statearr_25103_25225[(2)] = inst_24865);

(statearr_25103_25225[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (57))){
var inst_24936 = (state_25023[(7)]);
var inst_24961 = (state_25023[(34)]);
var inst_24960 = (state_25023[(2)]);
var inst_24961__$1 = (inst_24936 == null);
var state_25023__$1 = (function (){var statearr_25104 = state_25023;
(statearr_25104[(34)] = inst_24961__$1);

(statearr_25104[(13)] = inst_24960);

return statearr_25104;
})();
if(cljs.core.truth_(inst_24961__$1)){
var statearr_25105_25226 = state_25023__$1;
(statearr_25105_25226[(1)] = (64));

} else {
var statearr_25106_25227 = state_25023__$1;
(statearr_25106_25227[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (68))){
var inst_24936 = (state_25023[(7)]);
var inst_24875 = (state_25023[(15)]);
var inst_24884 = (state_25023[(30)]);
var inst_24969 = cljs.core.assoc.call(null,inst_24875,inst_24884,inst_24936);
var state_25023__$1 = state_25023;
var statearr_25107_25228 = state_25023__$1;
(statearr_25107_25228[(2)] = inst_24969);

(statearr_25107_25228[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (11))){
var inst_24821 = (state_25023[(2)]);
var state_25023__$1 = (function (){var statearr_25109 = state_25023;
(statearr_25109[(25)] = inst_24821);

return statearr_25109;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25110_25229 = state_25023__$1;
(statearr_25110_25229[(1)] = (12));

} else {
var statearr_25111_25230 = state_25023__$1;
(statearr_25111_25230[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (9))){
var inst_24815 = (state_25023[(33)]);
var inst_24813 = (state_25023[(32)]);
var inst_24817 = cljs.core.sorted_map_by.call(null,inst_24813);
var inst_24818 = cljs.core.into.call(null,inst_24817,inst_24815);
var state_25023__$1 = state_25023;
var statearr_25112_25231 = state_25023__$1;
(statearr_25112_25231[(2)] = inst_24818);

(statearr_25112_25231[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (5))){
var _ = (function (){var statearr_25113 = state_25023;
(statearr_25113[(4)] = cljs.core.rest.call(null,(state_25023[(4)])));

return statearr_25113;
})();
var state_25023__$1 = state_25023;
var ex25108 = (state_25023__$1[(2)]);
var statearr_25114_25232 = state_25023__$1;
(statearr_25114_25232[(5)] = ex25108);


if((ex25108 instanceof Error)){
var statearr_25115_25233 = state_25023__$1;
(statearr_25115_25233[(1)] = (4));

(statearr_25115_25233[(5)] = null);

} else {
throw ex25108;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (83))){
var inst_24994 = (state_25023[(18)]);
var state_25023__$1 = state_25023;
var statearr_25116_25234 = state_25023__$1;
(statearr_25116_25234[(2)] = inst_24994);

(statearr_25116_25234[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (14))){
var inst_24985 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25117_25235 = state_25023__$1;
(statearr_25117_25235[(2)] = inst_24985);

(statearr_25117_25235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (45))){
var inst_24873 = (state_25023[(9)]);
var inst_24926 = (state_25023[(2)]);
var state_25023__$1 = (function (){var statearr_25118 = state_25023;
(statearr_25118[(20)] = inst_24926);

return statearr_25118;
})();
if(cljs.core.truth_(inst_24873)){
var statearr_25119_25236 = state_25023__$1;
(statearr_25119_25236[(1)] = (46));

} else {
var statearr_25120_25237 = state_25023__$1;
(statearr_25120_25237[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (53))){
var inst_24936 = (state_25023[(7)]);
var inst_24873 = (state_25023[(9)]);
var inst_24940 = cljs.core.count.call(null,inst_24936);
var inst_24941 = (inst_24873 - inst_24940);
var state_25023__$1 = state_25023;
var statearr_25121_25238 = state_25023__$1;
(statearr_25121_25238[(2)] = inst_24941);

(statearr_25121_25238[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (78))){
var inst_24994 = (state_25023[(18)]);
var state_25023__$1 = state_25023;
var statearr_25122_25239 = state_25023__$1;
(statearr_25122_25239[(2)] = inst_24994);

(statearr_25122_25239[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (26))){
var inst_24981 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25123_25240 = state_25023__$1;
(statearr_25123_25240[(2)] = inst_24981);

(statearr_25123_25240[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (16))){
var state_25023__$1 = state_25023;
var statearr_25124_25241 = state_25023__$1;
(statearr_25124_25241[(2)] = null);

(statearr_25124_25241[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (81))){
var state_25023__$1 = state_25023;
var statearr_25127_25242 = state_25023__$1;
(statearr_25127_25242[(1)] = (83));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (79))){
var inst_25004 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25129_25243 = state_25023__$1;
(statearr_25129_25243[(2)] = inst_25004);

(statearr_25129_25243[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (38))){
var inst_24888 = (state_25023[(10)]);
var inst_24873 = (state_25023[(9)]);
var inst_24885 = (state_25023[(12)]);
var inst_24875 = (state_25023[(15)]);
var inst_24910 = (state_25023[(2)]);
var tmp25125 = inst_24873;
var tmp25126 = inst_24875;
var inst_24871 = inst_24885;
var inst_24872 = inst_24888;
var inst_24873__$1 = tmp25125;
var inst_24874 = inst_24910;
var inst_24875__$1 = tmp25126;
var state_25023__$1 = (function (){var statearr_25130 = state_25023;
(statearr_25130[(14)] = inst_24872);

(statearr_25130[(9)] = inst_24873__$1);

(statearr_25130[(8)] = inst_24874);

(statearr_25130[(15)] = inst_24875__$1);

(statearr_25130[(16)] = inst_24871);

return statearr_25130;
})();
var statearr_25131_25244 = state_25023__$1;
(statearr_25131_25244[(2)] = null);

(statearr_25131_25244[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (30))){
var inst_24875 = (state_25023[(15)]);
var state_25023__$1 = state_25023;
var statearr_25132_25245 = state_25023__$1;
(statearr_25132_25245[(2)] = inst_24875);

(statearr_25132_25245[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (73))){
var inst_24994 = (state_25023[(18)]);
var inst_24993 = (state_25023[(2)]);
var inst_24994__$1 = fluree.db.util.async.throw_err.call(null,inst_24993);
var inst_24995 = cljs.core.coll_QMARK_.call(null,inst_24994__$1);
var inst_24996 = (!(inst_24995));
var state_25023__$1 = (function (){var statearr_25133 = state_25023;
(statearr_25133[(18)] = inst_24994__$1);

return statearr_25133;
})();
if(inst_24996){
var statearr_25134_25246 = state_25023__$1;
(statearr_25134_25246[(1)] = (74));

} else {
var statearr_25135_25247 = state_25023__$1;
(statearr_25135_25247[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (10))){
var inst_24815 = (state_25023[(33)]);
var state_25023__$1 = state_25023;
var statearr_25136_25248 = state_25023__$1;
(statearr_25136_25248[(2)] = inst_24815);

(statearr_25136_25248[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (18))){
var inst_24865 = (state_25023[(35)]);
var inst_24864 = (state_25023[(2)]);
var inst_24865__$1 = offset;
var state_25023__$1 = (function (){var statearr_25137 = state_25023;
(statearr_25137[(35)] = inst_24865__$1);

(statearr_25137[(22)] = inst_24864);

return statearr_25137;
})();
if(cljs.core.truth_(inst_24865__$1)){
var statearr_25138_25249 = state_25023__$1;
(statearr_25138_25249[(1)] = (19));

} else {
var statearr_25139_25250 = state_25023__$1;
(statearr_25139_25250[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (52))){
var state_25023__$1 = state_25023;
var statearr_25140_25251 = state_25023__$1;
(statearr_25140_25251[(2)] = null);

(statearr_25140_25251[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (67))){
var inst_24875 = (state_25023[(15)]);
var state_25023__$1 = state_25023;
var statearr_25141_25252 = state_25023__$1;
(statearr_25141_25252[(2)] = inst_24875);

(statearr_25141_25252[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (71))){
var state_25023__$1 = state_25023;
var statearr_25142_25253 = state_25023__$1;
(statearr_25142_25253[(2)] = limit);

(statearr_25142_25253[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (42))){
var inst_24874 = (state_25023[(8)]);
var inst_24919 = (state_25023[(2)]);
var inst_24920 = fluree.db.util.async.throw_err.call(null,inst_24919);
var inst_24921 = ((0) < inst_24874);
var state_25023__$1 = (function (){var statearr_25143 = state_25023;
(statearr_25143[(31)] = inst_24920);

return statearr_25143;
})();
if(cljs.core.truth_(inst_24921)){
var statearr_25144_25254 = state_25023__$1;
(statearr_25144_25254[(1)] = (43));

} else {
var statearr_25145_25255 = state_25023__$1;
(statearr_25145_25255[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (80))){
var inst_24994 = (state_25023[(18)]);
var inst_25007 = cljs.core.first.call(null,inst_24994);
var state_25023__$1 = state_25023;
var statearr_25146_25256 = state_25023__$1;
(statearr_25146_25256[(2)] = inst_25007);

(statearr_25146_25256[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (37))){
var inst_24874 = (state_25023[(8)]);
var inst_24889 = (state_25023[(24)]);
var inst_24908 = (inst_24874 - inst_24889);
var state_25023__$1 = state_25023;
var statearr_25147_25257 = state_25023__$1;
(statearr_25147_25257[(2)] = inst_24908);

(statearr_25147_25257[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (63))){
var inst_24956 = (state_25023[(2)]);
var state_25023__$1 = state_25023;
var statearr_25148_25258 = state_25023__$1;
(statearr_25148_25258[(2)] = inst_24956);

(statearr_25148_25258[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (8))){
var inst_25018 = (state_25023[(2)]);
var _ = (function (){var statearr_25149 = state_25023;
(statearr_25149[(4)] = cljs.core.rest.call(null,(state_25023[(4)])));

return statearr_25149;
})();
var state_25023__$1 = state_25023;
var statearr_25150_25259 = state_25023__$1;
(statearr_25150_25259[(2)] = inst_25018);

(statearr_25150_25259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (49))){
var inst_24873 = (state_25023[(9)]);
var inst_24926 = (state_25023[(20)]);
var inst_24933 = cljs.core.take.call(null,inst_24873,inst_24926);
var state_25023__$1 = state_25023;
var statearr_25151_25260 = state_25023__$1;
(statearr_25151_25260[(2)] = inst_24933);

(statearr_25151_25260[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25024 === (84))){
var state_25023__$1 = state_25023;
var statearr_25152_25261 = state_25023__$1;
(statearr_25152_25261[(2)] = null);

(statearr_25152_25261[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto____0 = (function (){
var statearr_25153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25153[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto__);

(statearr_25153[(1)] = (1));

return statearr_25153;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto____1 = (function (state_25023){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_25023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e25154){var ex__2729__auto__ = e25154;
var statearr_25155_25262 = state_25023;
(statearr_25155_25262[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_25023[(4)]))){
var statearr_25156_25263 = state_25023;
(statearr_25156_25263[(1)] = cljs.core.first.call(null,(state_25023[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25264 = state_25023;
state_25023 = G__25264;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto__ = function(state_25023){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto____1.call(this,state_25023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_25157 = f__2749__auto__.call(null);
(statearr_25157[(6)] = c__2748__auto__);

return statearr_25157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25267,opts){
var map__25268 = p__25267;
var map__25268__$1 = cljs.core.__destructure_map.call(null,map__25268);
var selectOne = cljs.core.get.call(null,map__25268__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__25268__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__25268__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__25268__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__25265_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25265_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__25266_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25266_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__4221__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25269,p__25270){
var map__25271 = p__25269;
var map__25271__$1 = cljs.core.__destructure_map.call(null,map__25271);
var query_map = map__25271__$1;
var construct = cljs.core.get.call(null,map__25271__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25272 = p__25270;
var map__25272__$1 = cljs.core.__destructure_map.call(null,map__25272);
var where_result = map__25272__$1;
var headers = cljs.core.get.call(null,map__25272__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25272__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25273 = cljs.core.map.call(null,(function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__25273,(0),null);
var fn2 = cljs.core.nth.call(null,vec__25273,(1),null);
var fn3 = cljs.core.nth.call(null,vec__25273,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_25306){
var state_val_25307 = (state_25306[(1)]);
if((state_val_25307 === (7))){
var inst_25285 = (state_25306[(7)]);
var state_25306__$1 = state_25306;
var statearr_25308_25331 = state_25306__$1;
(statearr_25308_25331[(2)] = inst_25285);

(statearr_25308_25331[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (1))){
var state_25306__$1 = state_25306;
var statearr_25309_25332 = state_25306__$1;
(statearr_25309_25332[(2)] = null);

(statearr_25309_25332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (4))){
var inst_25276 = (state_25306[(2)]);
var state_25306__$1 = state_25306;
var statearr_25310_25333 = state_25306__$1;
(statearr_25310_25333[(2)] = inst_25276);

(statearr_25310_25333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (13))){
var inst_25295 = (state_25306[(2)]);
var inst_25296 = fluree.db.util.async.throw_err.call(null,inst_25295);
var state_25306__$1 = state_25306;
var statearr_25311_25334 = state_25306__$1;
(statearr_25311_25334[(2)] = inst_25296);

(statearr_25311_25334[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (6))){
var inst_25285 = (state_25306[(7)]);
var inst_25284 = (state_25306[(2)]);
var inst_25285__$1 = fluree.db.util.async.throw_err.call(null,inst_25284);
var inst_25286 = fluree.db.util.core.exception_QMARK_.call(null,inst_25285__$1);
var state_25306__$1 = (function (){var statearr_25312 = state_25306;
(statearr_25312[(7)] = inst_25285__$1);

return statearr_25312;
})();
if(inst_25286){
var statearr_25313_25335 = state_25306__$1;
(statearr_25313_25335[(1)] = (7));

} else {
var statearr_25314_25336 = state_25306__$1;
(statearr_25314_25336[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (3))){
var inst_25304 = (state_25306[(2)]);
var state_25306__$1 = state_25306;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25306__$1,inst_25304);
} else {
if((state_val_25307 === (12))){
var inst_25299 = (state_25306[(2)]);
var state_25306__$1 = state_25306;
var statearr_25315_25337 = state_25306__$1;
(statearr_25315_25337[(2)] = inst_25299);

(statearr_25315_25337[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (2))){
var _ = (function (){var statearr_25316 = state_25306;
(statearr_25316[(4)] = cljs.core.cons.call(null,(5),(state_25306[(4)])));

return statearr_25316;
})();
var inst_25282 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_25306__$1 = state_25306;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25306__$1,(6),inst_25282);
} else {
if((state_val_25307 === (11))){
var state_25306__$1 = state_25306;
var statearr_25318_25338 = state_25306__$1;
(statearr_25318_25338[(2)] = null);

(statearr_25318_25338[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (9))){
var inst_25301 = (state_25306[(2)]);
var _ = (function (){var statearr_25319 = state_25306;
(statearr_25319[(4)] = cljs.core.rest.call(null,(state_25306[(4)])));

return statearr_25319;
})();
var state_25306__$1 = state_25306;
var statearr_25320_25339 = state_25306__$1;
(statearr_25320_25339[(2)] = inst_25301);

(statearr_25320_25339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (5))){
var _ = (function (){var statearr_25321 = state_25306;
(statearr_25321[(4)] = cljs.core.rest.call(null,(state_25306[(4)])));

return statearr_25321;
})();
var state_25306__$1 = state_25306;
var ex25317 = (state_25306__$1[(2)]);
var statearr_25322_25340 = state_25306__$1;
(statearr_25322_25340[(5)] = ex25317);


if((ex25317 instanceof Error)){
var statearr_25323_25341 = state_25306__$1;
(statearr_25323_25341[(1)] = (4));

(statearr_25323_25341[(5)] = null);

} else {
throw ex25317;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25307 === (10))){
var inst_25285 = (state_25306[(7)]);
var inst_25290 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25285);
var inst_25291 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25285);
var inst_25292 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_25290,inst_25291,query_map,opts);
var inst_25293 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_25285,inst_25292,opts);
var state_25306__$1 = state_25306;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25306__$1,(13),inst_25293);
} else {
if((state_val_25307 === (8))){
var state_25306__$1 = state_25306;
var statearr_25324_25342 = state_25306__$1;
(statearr_25324_25342[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto____0 = (function (){
var statearr_25326 = [null,null,null,null,null,null,null,null];
(statearr_25326[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto__);

(statearr_25326[(1)] = (1));

return statearr_25326;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto____1 = (function (state_25306){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_25306);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e25327){var ex__2729__auto__ = e25327;
var statearr_25328_25343 = state_25306;
(statearr_25328_25343[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_25306[(4)]))){
var statearr_25329_25344 = state_25306;
(statearr_25329_25344[(1)] = cljs.core.first.call(null,(state_25306[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25345 = state_25306;
state_25306 = G__25345;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto__ = function(state_25306){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto____1.call(this,state_25306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_25330 = f__2749__auto__.call(null);
(statearr_25330[(6)] = c__2748__auto__);

return statearr_25330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__25346 = query_map;
var map__25346__$1 = cljs.core.__destructure_map.call(null,map__25346);
var select = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__25346__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25347 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__25347,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25347;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_25704){
var state_val_25705 = (state_25704[(1)]);
if((state_val_25705 === (121))){
var inst_25665 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25706_25901 = state_25704__$1;
(statearr_25706_25901[(2)] = inst_25665);

(statearr_25706_25901[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (65))){
var inst_25538 = typeof from === 'string';
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25538)){
var statearr_25707_25902 = state_25704__$1;
(statearr_25707_25902[(1)] = (72));

} else {
var statearr_25708_25903 = state_25704__$1;
(statearr_25708_25903[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (70))){
var inst_25409 = (state_25704[(7)]);
var inst_25407 = (state_25704[(8)]);
var inst_25531 = (state_25704[(2)]);
var inst_25532 = fluree.db.util.async.throw_err.call(null,inst_25531);
var inst_25533 = fluree.db.query.fql.flake_select.call(null,db,inst_25409,fuel,max_fuel,inst_25407,inst_25532);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(71),inst_25533);
} else {
if((state_val_25705 === (62))){
var inst_25511 = (state_25704[(9)]);
var state_25704__$1 = state_25704;
var statearr_25709_25904 = state_25704__$1;
(statearr_25709_25904[(2)] = inst_25511);

(statearr_25709_25904[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (74))){
var inst_25671 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25710_25905 = state_25704__$1;
(statearr_25710_25905[(2)] = inst_25671);

(statearr_25710_25905[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (110))){
var inst_25604 = (state_25704[(10)]);
var state_25704__$1 = state_25704;
var statearr_25711_25906 = state_25704__$1;
(statearr_25711_25906[(2)] = inst_25604);

(statearr_25711_25906[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (130))){
var inst_25691 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25712_25907 = state_25704__$1;
(statearr_25712_25907[(2)] = inst_25691);

(statearr_25712_25907[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (128))){
var inst_25682 = (state_25704[(11)]);
var inst_25687 = fluree.db.util.core.exception_QMARK_.call(null,inst_25682);
var inst_25688 = (!(inst_25687));
var state_25704__$1 = state_25704;
var statearr_25713_25908 = state_25704__$1;
(statearr_25713_25908[(2)] = inst_25688);

(statearr_25713_25908[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (7))){
var inst_25377 = (state_25704[(12)]);
var inst_25377__$1 = selectOne;
var state_25704__$1 = (function (){var statearr_25714 = state_25704;
(statearr_25714[(12)] = inst_25377__$1);

return statearr_25714;
})();
if(cljs.core.truth_(inst_25377__$1)){
var statearr_25715_25909 = state_25704__$1;
(statearr_25715_25909[(1)] = (9));

} else {
var statearr_25716_25910 = state_25704__$1;
(statearr_25716_25910[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (59))){
var inst_25489 = (state_25704[(13)]);
var inst_25397 = (state_25704[(14)]);
var inst_25409 = (state_25704[(7)]);
var inst_25407 = (state_25704[(8)]);
var inst_25503 = (state_25704[(2)]);
var inst_25504 = fluree.db.util.async.throw_err.call(null,inst_25503);
var inst_25505 = cljs.core.sequence.call(null,inst_25489,inst_25504);
var inst_25506 = fluree.db.query.fql.subject_select.call(null,db,inst_25409,fuel,max_fuel,inst_25407,inst_25505,inst_25397);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(60),inst_25506);
} else {
if((state_val_25705 === (86))){
var inst_25399 = (state_25704[(15)]);
var inst_25397 = (state_25704[(14)]);
var inst_25409 = (state_25704[(7)]);
var inst_25407 = (state_25704[(8)]);
var inst_25571 = (state_25704[(2)]);
var inst_25572 = fluree.db.query.fql.subject_select.call(null,db,inst_25409,fuel,max_fuel,inst_25407,inst_25571,inst_25397,inst_25399);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(87),inst_25572);
} else {
if((state_val_25705 === (20))){
var inst_25441 = (state_25704[(2)]);
var inst_25442 = cljs.core.nth.call(null,inst_25441,(0),null);
var inst_25443 = cljs.core.nth.call(null,inst_25441,(1),null);
var inst_25444 = typeof where === 'string';
var state_25704__$1 = (function (){var statearr_25717 = state_25704;
(statearr_25717[(16)] = inst_25442);

(statearr_25717[(17)] = inst_25443);

return statearr_25717;
})();
if(cljs.core.truth_(inst_25444)){
var statearr_25718_25911 = state_25704__$1;
(statearr_25718_25911[(1)] = (30));

} else {
var statearr_25719_25912 = state_25704__$1;
(statearr_25719_25912[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (72))){
var inst_25396 = (state_25704[(18)]);
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25396)){
var statearr_25720_25913 = state_25704__$1;
(statearr_25720_25913[(1)] = (75));

} else {
var statearr_25721_25914 = state_25704__$1;
(statearr_25721_25914[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (58))){
var inst_25497 = (state_25704[(2)]);
var inst_25498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25499 = [from];
var inst_25500 = (new cljs.core.PersistentVector(null,1,(5),inst_25498,inst_25499,null));
var inst_25501 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25500,inst_25497);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(59),inst_25501);
} else {
if((state_val_25705 === (60))){
var inst_25508 = (state_25704[(2)]);
var inst_25509 = fluree.db.util.async.throw_err.call(null,inst_25508);
var state_25704__$1 = state_25704;
var statearr_25722_25915 = state_25704__$1;
(statearr_25722_25915[(2)] = inst_25509);

(statearr_25722_25915[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (27))){
var inst_25426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25427 = [null,null];
var inst_25428 = (new cljs.core.PersistentVector(null,2,(5),inst_25426,inst_25427,null));
var state_25704__$1 = state_25704;
var statearr_25723_25916 = state_25704__$1;
(statearr_25723_25916[(2)] = inst_25428);

(statearr_25723_25916[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (1))){
var state_25704__$1 = state_25704;
var statearr_25724_25917 = state_25704__$1;
(statearr_25724_25917[(2)] = null);

(statearr_25724_25917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (69))){
var inst_25528 = (state_25704[(2)]);
var inst_25529 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_25528);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(70),inst_25529);
} else {
if((state_val_25705 === (101))){
var inst_25638 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25725_25918 = state_25704__$1;
(statearr_25725_25918[(2)] = inst_25638);

(statearr_25725_25918[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (24))){
var inst_25396 = (state_25704[(18)]);
var inst_25421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25422 = [inst_25396,"ASC"];
var inst_25423 = (new cljs.core.PersistentVector(null,2,(5),inst_25421,inst_25422,null));
var state_25704__$1 = state_25704;
var statearr_25726_25919 = state_25704__$1;
(statearr_25726_25919[(2)] = inst_25423);

(statearr_25726_25919[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (102))){
var inst_25610 = (state_25704[(19)]);
var state_25704__$1 = state_25704;
var statearr_25727_25920 = state_25704__$1;
(statearr_25727_25920[(2)] = inst_25610);

(statearr_25727_25920[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (55))){
var inst_25396 = (state_25704[(18)]);
var inst_25489 = (state_25704[(2)]);
var state_25704__$1 = (function (){var statearr_25728 = state_25704;
(statearr_25728[(13)] = inst_25489);

return statearr_25728;
})();
if(cljs.core.truth_(inst_25396)){
var statearr_25729_25921 = state_25704__$1;
(statearr_25729_25921[(1)] = (56));

} else {
var statearr_25730_25922 = state_25704__$1;
(statearr_25730_25922[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (85))){
var inst_25563 = (state_25704[(20)]);
var inst_25567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25568 = [inst_25563];
var inst_25569 = (new cljs.core.PersistentVector(null,1,(5),inst_25567,inst_25568,null));
var state_25704__$1 = state_25704;
var statearr_25731_25923 = state_25704__$1;
(statearr_25731_25923[(2)] = inst_25569);

(statearr_25731_25923[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (39))){
var inst_25397 = (state_25704[(14)]);
var state_25704__$1 = state_25704;
var statearr_25732_25924 = state_25704__$1;
(statearr_25732_25924[(2)] = inst_25397);

(statearr_25732_25924[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (88))){
var inst_25577 = cljs.core._deref.call(null,fuel);
var inst_25578 = (inst_25577 + (1));
var inst_25579 = cljs.core._vreset_BANG_.call(null,fuel,inst_25578);
var state_25704__$1 = state_25704;
var statearr_25733_25925 = state_25704__$1;
(statearr_25733_25925[(2)] = inst_25579);

(statearr_25733_25925[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (46))){
var inst_25474 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25474)){
var statearr_25734_25926 = state_25704__$1;
(statearr_25734_25926[(1)] = (47));

} else {
var statearr_25735_25927 = state_25704__$1;
(statearr_25735_25927[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (4))){
var inst_25364 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25736_25928 = state_25704__$1;
(statearr_25736_25928[(2)] = inst_25364);

(statearr_25736_25928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (77))){
var inst_25547 = (state_25704[(2)]);
var inst_25548 = fluree.db.query.range.collection.call(null,db,from,inst_25547);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(78),inst_25548);
} else {
if((state_val_25705 === (106))){
var state_25704__$1 = state_25704;
var statearr_25737_25929 = state_25704__$1;
(statearr_25737_25929[(2)] = null);

(statearr_25737_25929[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (119))){
var inst_25657 = cljs.core.pr_str.call(null,query_map);
var inst_25658 = ["Invalid 'from' in query:",inst_25657].join('');
var inst_25659 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25660 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25661 = cljs.core.PersistentHashMap.fromArrays(inst_25659,inst_25660);
var inst_25662 = cljs.core.ex_info.call(null,inst_25658,inst_25661);
var state_25704__$1 = state_25704;
var statearr_25738_25930 = state_25704__$1;
(statearr_25738_25930[(2)] = inst_25662);

(statearr_25738_25930[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (95))){
var state_25704__$1 = state_25704;
var statearr_25739_25931 = state_25704__$1;
(statearr_25739_25931[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (54))){
var inst_25483 = (state_25704[(21)]);
var state_25704__$1 = state_25704;
var statearr_25741_25932 = state_25704__$1;
(statearr_25741_25932[(2)] = inst_25483);

(statearr_25741_25932[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (92))){
var inst_25584 = (state_25704[(22)]);
var state_25704__$1 = state_25704;
var statearr_25742_25933 = state_25704__$1;
(statearr_25742_25933[(2)] = inst_25584);

(statearr_25742_25933[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (104))){
var inst_25630 = (state_25704[(23)]);
var inst_25630__$1 = (state_25704[(2)]);
var state_25704__$1 = (function (){var statearr_25743 = state_25704;
(statearr_25743[(23)] = inst_25630__$1);

return statearr_25743;
})();
if(cljs.core.truth_(inst_25630__$1)){
var statearr_25744_25934 = state_25704__$1;
(statearr_25744_25934[(1)] = (109));

} else {
var statearr_25745_25935 = state_25704__$1;
(statearr_25745_25935[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (15))){
var inst_25400 = (state_25704[(24)]);
var inst_25398 = (state_25704[(25)]);
var inst_25404 = cljs.core.assoc.call(null,inst_25400,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25398);
var state_25704__$1 = state_25704;
var statearr_25746_25936 = state_25704__$1;
(statearr_25746_25936[(2)] = inst_25404);

(statearr_25746_25936[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (48))){
var inst_25511 = (state_25704[(9)]);
var inst_25511__$1 = typeof from === 'string';
var state_25704__$1 = (function (){var statearr_25747 = state_25704;
(statearr_25747[(9)] = inst_25511__$1);

return statearr_25747;
})();
if(cljs.core.truth_(inst_25511__$1)){
var statearr_25748_25937 = state_25704__$1;
(statearr_25748_25937[(1)] = (61));

} else {
var statearr_25749_25938 = state_25704__$1;
(statearr_25749_25938[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (50))){
var inst_25477 = (state_25704[(26)]);
var inst_25479 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_25480 = cljs.core.comp.call(null,inst_25477,inst_25479);
var state_25704__$1 = state_25704;
var statearr_25750_25939 = state_25704__$1;
(statearr_25750_25939[(2)] = inst_25480);

(statearr_25750_25939[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (116))){
var state_25704__$1 = state_25704;
var statearr_25751_25940 = state_25704__$1;
(statearr_25751_25940[(2)] = null);

(statearr_25751_25940[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (75))){
var inst_25541 = cljs.core.PersistentHashMap.EMPTY;
var state_25704__$1 = state_25704;
var statearr_25752_25941 = state_25704__$1;
(statearr_25752_25941[(2)] = inst_25541);

(statearr_25752_25941[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (99))){
var inst_25604 = (state_25704[(10)]);
var state_25704__$1 = state_25704;
var statearr_25753_25942 = state_25704__$1;
(statearr_25753_25942[(2)] = inst_25604);

(statearr_25753_25942[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (21))){
var inst_25396 = (state_25704[(18)]);
var inst_25413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25414 = cljs.core.second.call(null,inst_25396);
var inst_25415 = cljs.core.first.call(null,inst_25396);
var inst_25416 = [inst_25414,inst_25415];
var inst_25417 = (new cljs.core.PersistentVector(null,2,(5),inst_25413,inst_25416,null));
var state_25704__$1 = state_25704;
var statearr_25754_25943 = state_25704__$1;
(statearr_25754_25943[(2)] = inst_25417);

(statearr_25754_25943[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (31))){
var inst_25468 = (state_25704[(27)]);
var inst_25468__$1 = typeof from === 'string';
var state_25704__$1 = (function (){var statearr_25755 = state_25704;
(statearr_25755[(27)] = inst_25468__$1);

return statearr_25755;
})();
if(cljs.core.truth_(inst_25468__$1)){
var statearr_25756_25944 = state_25704__$1;
(statearr_25756_25944[(1)] = (44));

} else {
var statearr_25757_25945 = state_25704__$1;
(statearr_25757_25945[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (113))){
var state_25704__$1 = state_25704;
var statearr_25758_25946 = state_25704__$1;
(statearr_25758_25946[(2)] = null);

(statearr_25758_25946[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (32))){
var inst_25442 = (state_25704[(16)]);
var inst_25677 = (state_25704[(2)]);
var state_25704__$1 = (function (){var statearr_25759 = state_25704;
(statearr_25759[(28)] = inst_25677);

return statearr_25759;
})();
if(cljs.core.truth_(inst_25442)){
var statearr_25760_25947 = state_25704__$1;
(statearr_25760_25947[(1)] = (122));

} else {
var statearr_25761_25948 = state_25704__$1;
(statearr_25761_25948[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (40))){
var inst_25396 = (state_25704[(18)]);
var inst_25458 = (state_25704[(2)]);
var state_25704__$1 = (function (){var statearr_25762 = state_25704;
(statearr_25762[(29)] = inst_25458);

return statearr_25762;
})();
if(cljs.core.truth_(inst_25396)){
var statearr_25763_25949 = state_25704__$1;
(statearr_25763_25949[(1)] = (41));

} else {
var statearr_25764_25950 = state_25704__$1;
(statearr_25764_25950[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (129))){
var inst_25685 = (state_25704[(30)]);
var state_25704__$1 = state_25704;
var statearr_25765_25951 = state_25704__$1;
(statearr_25765_25951[(2)] = inst_25685);

(statearr_25765_25951[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (91))){
var inst_25586 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_25704__$1 = state_25704;
var statearr_25766_25952 = state_25704__$1;
(statearr_25766_25952[(2)] = inst_25586);

(statearr_25766_25952[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (117))){
var inst_25399 = (state_25704[(15)]);
var state_25704__$1 = state_25704;
var statearr_25767_25953 = state_25704__$1;
(statearr_25767_25953[(2)] = inst_25399);

(statearr_25767_25953[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (108))){
var inst_25627 = (state_25704[(2)]);
var inst_25628 = fluree.db.util.async.throw_err.call(null,inst_25627);
var state_25704__$1 = state_25704;
var statearr_25768_25954 = state_25704__$1;
(statearr_25768_25954[(2)] = inst_25628);

(statearr_25768_25954[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (56))){
var inst_25491 = cljs.core.PersistentHashMap.EMPTY;
var state_25704__$1 = state_25704;
var statearr_25769_25955 = state_25704__$1;
(statearr_25769_25955[(2)] = inst_25491);

(statearr_25769_25955[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (33))){
var state_25704__$1 = state_25704;
var statearr_25770_25956 = state_25704__$1;
(statearr_25770_25956[(2)] = from);

(statearr_25770_25956[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (13))){
var inst_25383 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25384 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25385 = cljs.core.PersistentHashMap.fromArrays(inst_25383,inst_25384);
var inst_25386 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_25385);
var inst_25387 = (function(){throw inst_25386})();
var state_25704__$1 = state_25704;
var statearr_25771_25957 = state_25704__$1;
(statearr_25771_25957[(2)] = inst_25387);

(statearr_25771_25957[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (22))){
var inst_25396 = (state_25704[(18)]);
var inst_25419 = typeof inst_25396 === 'string';
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25419)){
var statearr_25772_25958 = state_25704__$1;
(statearr_25772_25958[(1)] = (24));

} else {
var statearr_25773_25959 = state_25704__$1;
(statearr_25773_25959[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (90))){
var inst_25575 = (state_25704[(31)]);
var inst_25582 = (state_25704[(2)]);
var state_25704__$1 = (function (){var statearr_25774 = state_25704;
(statearr_25774[(32)] = inst_25582);

return statearr_25774;
})();
var statearr_25775_25960 = state_25704__$1;
(statearr_25775_25960[(2)] = inst_25575);

(statearr_25775_25960[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (109))){
var inst_25604 = (state_25704[(10)]);
var inst_25630 = (state_25704[(23)]);
var inst_25632 = cljs.core.conj.call(null,inst_25604,inst_25630);
var state_25704__$1 = state_25704;
var statearr_25776_25961 = state_25704__$1;
(statearr_25776_25961[(2)] = inst_25632);

(statearr_25776_25961[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (36))){
var inst_25396 = (state_25704[(18)]);
var inst_25453 = (state_25704[(2)]);
var inst_25454 = fluree.db.util.async.throw_err.call(null,inst_25453);
var state_25704__$1 = (function (){var statearr_25777 = state_25704;
(statearr_25777[(33)] = inst_25454);

return statearr_25777;
})();
if(cljs.core.truth_(inst_25396)){
var statearr_25778_25962 = state_25704__$1;
(statearr_25778_25962[(1)] = (38));

} else {
var statearr_25779_25963 = state_25704__$1;
(statearr_25779_25963[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (41))){
var state_25704__$1 = state_25704;
var statearr_25780_25964 = state_25704__$1;
(statearr_25780_25964[(2)] = null);

(statearr_25780_25964[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (118))){
var inst_25642 = (state_25704[(34)]);
var inst_25646 = (state_25704[(35)]);
var inst_25409 = (state_25704[(7)]);
var inst_25407 = (state_25704[(8)]);
var inst_25650 = (state_25704[(2)]);
var inst_25651 = fluree.db.query.fql.subject_select.call(null,db,inst_25409,fuel,max_fuel,inst_25407,inst_25642,inst_25646,inst_25650);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(112),inst_25651);
} else {
if((state_val_25705 === (89))){
var state_25704__$1 = state_25704;
var statearr_25781_25965 = state_25704__$1;
(statearr_25781_25965[(2)] = null);

(statearr_25781_25965[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (100))){
var inst_25610 = (state_25704[(19)]);
var inst_25615 = cljs.core.int_QMARK_.call(null,inst_25610);
var state_25704__$1 = state_25704;
if(inst_25615){
var statearr_25782_25966 = state_25704__$1;
(statearr_25782_25966[(1)] = (102));

} else {
var statearr_25783_25967 = state_25704__$1;
(statearr_25783_25967[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (131))){
var inst_25682 = (state_25704[(11)]);
var inst_25696 = cljs.core.first.call(null,inst_25682);
var state_25704__$1 = state_25704;
var statearr_25784_25968 = state_25704__$1;
(statearr_25784_25968[(2)] = inst_25696);

(statearr_25784_25968[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (122))){
var inst_25399 = (state_25704[(15)]);
var inst_25677 = (state_25704[(28)]);
var inst_25442 = (state_25704[(16)]);
var inst_25397 = (state_25704[(14)]);
var inst_25443 = (state_25704[(17)]);
var inst_25679 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_25442,inst_25443,inst_25399,inst_25397,inst_25677);
var state_25704__$1 = state_25704;
var statearr_25785_25969 = state_25704__$1;
(statearr_25785_25969[(2)] = inst_25679);

(statearr_25785_25969[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (43))){
var inst_25458 = (state_25704[(29)]);
var inst_25454 = (state_25704[(33)]);
var inst_25409 = (state_25704[(7)]);
var inst_25407 = (state_25704[(8)]);
var inst_25462 = (state_25704[(2)]);
var inst_25463 = fluree.db.query.fql.subject_select.call(null,db,inst_25409,fuel,max_fuel,inst_25407,inst_25454,inst_25458,inst_25462);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(37),inst_25463);
} else {
if((state_val_25705 === (61))){
var inst_25513 = ["_tx",null,"_block",null];
var inst_25514 = (new cljs.core.PersistentArrayMap(null,2,inst_25513,null));
var inst_25515 = (new cljs.core.PersistentHashSet(null,inst_25514,null));
var inst_25516 = inst_25515.call(null,from);
var state_25704__$1 = state_25704;
var statearr_25786_25970 = state_25704__$1;
(statearr_25786_25970[(2)] = inst_25516);

(statearr_25786_25970[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (29))){
var inst_25431 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25787_25971 = state_25704__$1;
(statearr_25787_25971[(2)] = inst_25431);

(statearr_25787_25971[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (44))){
var inst_25470 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25471 = clojure.string.includes_QMARK_.call(null,inst_25470,"/");
var state_25704__$1 = state_25704;
var statearr_25788_25972 = state_25704__$1;
(statearr_25788_25972[(2)] = inst_25471);

(statearr_25788_25972[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (93))){
var inst_25589 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25589)){
var statearr_25789_25973 = state_25704__$1;
(statearr_25789_25973[(1)] = (94));

} else {
var statearr_25790_25974 = state_25704__$1;
(statearr_25790_25974[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (6))){
var inst_25374 = (state_25704[(36)]);
var state_25704__$1 = state_25704;
var statearr_25791_25975 = state_25704__$1;
(statearr_25791_25975[(2)] = inst_25374);

(statearr_25791_25975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (111))){
var inst_25611 = (state_25704[(37)]);
var inst_25635 = (state_25704[(2)]);
var inst_25603 = inst_25611;
var inst_25604 = inst_25635;
var state_25704__$1 = (function (){var statearr_25792 = state_25704;
(statearr_25792[(38)] = inst_25603);

(statearr_25792[(10)] = inst_25604);

return statearr_25792;
})();
var statearr_25793_25976 = state_25704__$1;
(statearr_25793_25976[(2)] = null);

(statearr_25793_25976[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (28))){
var state_25704__$1 = state_25704;
var statearr_25794_25977 = state_25704__$1;
(statearr_25794_25977[(2)] = null);

(statearr_25794_25977[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (64))){
var inst_25396 = (state_25704[(18)]);
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25396)){
var statearr_25795_25978 = state_25704__$1;
(statearr_25795_25978[(1)] = (67));

} else {
var statearr_25796_25979 = state_25704__$1;
(statearr_25796_25979[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (103))){
var state_25704__$1 = state_25704;
if(cljs.core.truth_(fuel)){
var statearr_25797_25980 = state_25704__$1;
(statearr_25797_25980[(1)] = (105));

} else {
var statearr_25798_25981 = state_25704__$1;
(statearr_25798_25981[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (51))){
var inst_25477 = (state_25704[(26)]);
var state_25704__$1 = state_25704;
var statearr_25799_25982 = state_25704__$1;
(statearr_25799_25982[(2)] = inst_25477);

(statearr_25799_25982[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (25))){
var state_25704__$1 = state_25704;
var statearr_25800_25983 = state_25704__$1;
(statearr_25800_25983[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (34))){
var state_25704__$1 = state_25704;
var statearr_25802_25984 = state_25704__$1;
(statearr_25802_25984[(2)] = null);

(statearr_25802_25984[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (125))){
var inst_25685 = (state_25704[(30)]);
var inst_25682 = (state_25704[(11)]);
var inst_25685__$1 = cljs.core.coll_QMARK_.call(null,inst_25682);
var state_25704__$1 = (function (){var statearr_25803 = state_25704;
(statearr_25803[(30)] = inst_25685__$1);

return statearr_25803;
})();
if(inst_25685__$1){
var statearr_25804_25985 = state_25704__$1;
(statearr_25804_25985[(1)] = (128));

} else {
var statearr_25805_25986 = state_25704__$1;
(statearr_25805_25986[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (17))){
var inst_25396 = (state_25704[(18)]);
var inst_25407 = (state_25704[(2)]);
var inst_25408 = cljs.core.PersistentHashMap.EMPTY;
var inst_25409 = cljs.core.volatile_BANG_.call(null,inst_25408);
var state_25704__$1 = (function (){var statearr_25806 = state_25704;
(statearr_25806[(7)] = inst_25409);

(statearr_25806[(8)] = inst_25407);

return statearr_25806;
})();
if(cljs.core.truth_(inst_25396)){
var statearr_25807_25987 = state_25704__$1;
(statearr_25807_25987[(1)] = (18));

} else {
var statearr_25808_25988 = state_25704__$1;
(statearr_25808_25988[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (3))){
var inst_25702 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25704__$1,inst_25702);
} else {
if((state_val_25705 === (12))){
var inst_25380 = (state_25704[(39)]);
var state_25704__$1 = state_25704;
var statearr_25809_25989 = state_25704__$1;
(statearr_25809_25989[(2)] = inst_25380);

(statearr_25809_25989[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (2))){
var inst_25374 = (state_25704[(36)]);
var _ = (function (){var statearr_25810 = state_25704;
(statearr_25810[(4)] = cljs.core.cons.call(null,(5),(state_25704[(4)])));

return statearr_25810;
})();
var inst_25374__$1 = select;
var state_25704__$1 = (function (){var statearr_25811 = state_25704;
(statearr_25811[(36)] = inst_25374__$1);

return statearr_25811;
})();
if(cljs.core.truth_(inst_25374__$1)){
var statearr_25812_25990 = state_25704__$1;
(statearr_25812_25990[(1)] = (6));

} else {
var statearr_25813_25991 = state_25704__$1;
(statearr_25813_25991[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (66))){
var inst_25673 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25814_25992 = state_25704__$1;
(statearr_25814_25992[(2)] = inst_25673);

(statearr_25814_25992[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (107))){
var inst_25610 = (state_25704[(19)]);
var inst_25624 = (state_25704[(2)]);
var inst_25625 = fluree.db.dbproto._subid.call(null,db,inst_25610,false);
var state_25704__$1 = (function (){var statearr_25815 = state_25704;
(statearr_25815[(40)] = inst_25624);

return statearr_25815;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(108),inst_25625);
} else {
if((state_val_25705 === (23))){
var inst_25435 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25816_25993 = state_25704__$1;
(statearr_25816_25993[(2)] = inst_25435);

(statearr_25816_25993[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (47))){
var inst_25477 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_25704__$1 = (function (){var statearr_25817 = state_25704;
(statearr_25817[(26)] = inst_25477);

return statearr_25817;
})();
if(cljs.core.truth_(fuel)){
var statearr_25818_25994 = state_25704__$1;
(statearr_25818_25994[(1)] = (50));

} else {
var statearr_25819_25995 = state_25704__$1;
(statearr_25819_25995[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (35))){
var inst_25450 = (state_25704[(2)]);
var inst_25451 = fluree.db.query.fql.where_filter.call(null,db,where,inst_25450);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(36),inst_25451);
} else {
if((state_val_25705 === (127))){
var inst_25694 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25694)){
var statearr_25820_25996 = state_25704__$1;
(statearr_25820_25996[(1)] = (131));

} else {
var statearr_25821_25997 = state_25704__$1;
(statearr_25821_25997[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (82))){
var inst_25669 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25822_25998 = state_25704__$1;
(statearr_25822_25998[(2)] = inst_25669);

(statearr_25822_25998[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (76))){
var inst_25399 = (state_25704[(15)]);
var inst_25397 = (state_25704[(14)]);
var inst_25543 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25544 = [inst_25397,inst_25399];
var inst_25545 = cljs.core.PersistentHashMap.fromArrays(inst_25543,inst_25544);
var state_25704__$1 = state_25704;
var statearr_25823_25999 = state_25704__$1;
(statearr_25823_25999[(2)] = inst_25545);

(statearr_25823_25999[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (97))){
var inst_25603 = (state_25704[(38)]);
var inst_25610 = (state_25704[(19)]);
var inst_25609 = cljs.core.seq.call(null,inst_25603);
var inst_25610__$1 = cljs.core.first.call(null,inst_25609);
var inst_25611 = cljs.core.next.call(null,inst_25609);
var inst_25612 = cljs.core.not.call(null,inst_25610__$1);
var state_25704__$1 = (function (){var statearr_25824 = state_25704;
(statearr_25824[(37)] = inst_25611);

(statearr_25824[(19)] = inst_25610__$1);

return statearr_25824;
})();
if(inst_25612){
var statearr_25825_26000 = state_25704__$1;
(statearr_25825_26000[(1)] = (99));

} else {
var statearr_25826_26001 = state_25704__$1;
(statearr_25826_26001[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (19))){
var inst_25437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25438 = [null,null];
var inst_25439 = (new cljs.core.PersistentVector(null,2,(5),inst_25437,inst_25438,null));
var state_25704__$1 = state_25704;
var statearr_25827_26002 = state_25704__$1;
(statearr_25827_26002[(2)] = inst_25439);

(statearr_25827_26002[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (57))){
var inst_25399 = (state_25704[(15)]);
var inst_25397 = (state_25704[(14)]);
var inst_25493 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25494 = [inst_25397,inst_25399];
var inst_25495 = cljs.core.PersistentHashMap.fromArrays(inst_25493,inst_25494);
var state_25704__$1 = state_25704;
var statearr_25828_26003 = state_25704__$1;
(statearr_25828_26003[(2)] = inst_25495);

(statearr_25828_26003[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (68))){
var inst_25399 = (state_25704[(15)]);
var inst_25397 = (state_25704[(14)]);
var inst_25524 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25525 = [inst_25397,inst_25399];
var inst_25526 = cljs.core.PersistentHashMap.fromArrays(inst_25524,inst_25525);
var state_25704__$1 = state_25704;
var statearr_25829_26004 = state_25704__$1;
(statearr_25829_26004[(2)] = inst_25526);

(statearr_25829_26004[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (11))){
var inst_25391 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25830_26005 = state_25704__$1;
(statearr_25830_26005[(2)] = inst_25391);

(statearr_25830_26005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (115))){
var inst_25396 = (state_25704[(18)]);
var inst_25646 = (state_25704[(2)]);
var state_25704__$1 = (function (){var statearr_25832 = state_25704;
(statearr_25832[(35)] = inst_25646);

return statearr_25832;
})();
if(cljs.core.truth_(inst_25396)){
var statearr_25833_26006 = state_25704__$1;
(statearr_25833_26006[(1)] = (116));

} else {
var statearr_25834_26007 = state_25704__$1;
(statearr_25834_26007[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (9))){
var inst_25377 = (state_25704[(12)]);
var state_25704__$1 = state_25704;
var statearr_25835_26008 = state_25704__$1;
(statearr_25835_26008[(2)] = inst_25377);

(statearr_25835_26008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (5))){
var _ = (function (){var statearr_25836 = state_25704;
(statearr_25836[(4)] = cljs.core.rest.call(null,(state_25704[(4)])));

return statearr_25836;
})();
var state_25704__$1 = state_25704;
var ex25831 = (state_25704__$1[(2)]);
var statearr_25837_26009 = state_25704__$1;
(statearr_25837_26009[(5)] = ex25831);


if((ex25831 instanceof Error)){
var statearr_25838_26010 = state_25704__$1;
(statearr_25838_26010[(1)] = (4));

(statearr_25838_26010[(5)] = null);

} else {
throw ex25831;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (112))){
var inst_25653 = (state_25704[(2)]);
var inst_25654 = fluree.db.util.async.throw_err.call(null,inst_25653);
var state_25704__$1 = state_25704;
var statearr_25839_26011 = state_25704__$1;
(statearr_25839_26011[(2)] = inst_25654);

(statearr_25839_26011[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (83))){
var inst_25563 = (state_25704[(20)]);
var inst_25562 = (state_25704[(2)]);
var inst_25563__$1 = fluree.db.util.async.throw_err.call(null,inst_25562);
var inst_25564 = (inst_25563__$1 == null);
var state_25704__$1 = (function (){var statearr_25840 = state_25704;
(statearr_25840[(20)] = inst_25563__$1);

return statearr_25840;
})();
if(cljs.core.truth_(inst_25564)){
var statearr_25841_26012 = state_25704__$1;
(statearr_25841_26012[(1)] = (84));

} else {
var statearr_25842_26013 = state_25704__$1;
(statearr_25842_26013[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (14))){
var inst_25389 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25843_26014 = state_25704__$1;
(statearr_25843_26014[(2)] = inst_25389);

(statearr_25843_26014[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (45))){
var inst_25468 = (state_25704[(27)]);
var state_25704__$1 = state_25704;
var statearr_25844_26015 = state_25704__$1;
(statearr_25844_26015[(2)] = inst_25468);

(statearr_25844_26015[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (53))){
var inst_25483 = (state_25704[(21)]);
var inst_25485 = cljs.core.distinct.call(null);
var inst_25486 = cljs.core.comp.call(null,inst_25483,inst_25485);
var state_25704__$1 = state_25704;
var statearr_25845_26016 = state_25704__$1;
(statearr_25845_26016[(2)] = inst_25486);

(statearr_25845_26016[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (78))){
var inst_25409 = (state_25704[(7)]);
var inst_25407 = (state_25704[(8)]);
var inst_25550 = (state_25704[(2)]);
var inst_25551 = fluree.db.util.async.throw_err.call(null,inst_25550);
var inst_25552 = fluree.db.query.fql.flake_select.call(null,db,inst_25409,fuel,max_fuel,inst_25407,inst_25551);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(79),inst_25552);
} else {
if((state_val_25705 === (132))){
var inst_25682 = (state_25704[(11)]);
var state_25704__$1 = state_25704;
var statearr_25846_26017 = state_25704__$1;
(statearr_25846_26017[(2)] = inst_25682);

(statearr_25846_26017[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (26))){
var inst_25433 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25847_26018 = state_25704__$1;
(statearr_25847_26018[(2)] = inst_25433);

(statearr_25847_26018[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (123))){
var inst_25677 = (state_25704[(28)]);
var state_25704__$1 = state_25704;
var statearr_25848_26019 = state_25704__$1;
(statearr_25848_26019[(2)] = inst_25677);

(statearr_25848_26019[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (16))){
var inst_25400 = (state_25704[(24)]);
var state_25704__$1 = state_25704;
var statearr_25849_26020 = state_25704__$1;
(statearr_25849_26020[(2)] = inst_25400);

(statearr_25849_26020[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (133))){
var inst_25699 = (state_25704[(2)]);
var _ = (function (){var statearr_25850 = state_25704;
(statearr_25850[(4)] = cljs.core.rest.call(null,(state_25704[(4)])));

return statearr_25850;
})();
var state_25704__$1 = state_25704;
var statearr_25851_26021 = state_25704__$1;
(statearr_25851_26021[(2)] = inst_25699);

(statearr_25851_26021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (81))){
var inst_25584 = (state_25704[(22)]);
var inst_25584__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_25704__$1 = (function (){var statearr_25852 = state_25704;
(statearr_25852[(22)] = inst_25584__$1);

return statearr_25852;
})();
if(inst_25584__$1){
var statearr_25853_26022 = state_25704__$1;
(statearr_25853_26022[(1)] = (91));

} else {
var statearr_25854_26023 = state_25704__$1;
(statearr_25854_26023[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (120))){
var state_25704__$1 = state_25704;
var statearr_25855_26024 = state_25704__$1;
(statearr_25855_26024[(2)] = null);

(statearr_25855_26024[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (79))){
var inst_25554 = (state_25704[(2)]);
var inst_25555 = fluree.db.util.async.throw_err.call(null,inst_25554);
var state_25704__$1 = state_25704;
var statearr_25856_26025 = state_25704__$1;
(statearr_25856_26025[(2)] = inst_25555);

(statearr_25856_26025[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (38))){
var state_25704__$1 = state_25704;
var statearr_25857_26026 = state_25704__$1;
(statearr_25857_26026[(2)] = null);

(statearr_25857_26026[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (126))){
var inst_25683 = (state_25704[(41)]);
var state_25704__$1 = state_25704;
var statearr_25858_26027 = state_25704__$1;
(statearr_25858_26027[(2)] = inst_25683);

(statearr_25858_26027[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (98))){
var inst_25396 = (state_25704[(18)]);
var inst_25640 = (state_25704[(2)]);
var inst_25641 = cljs.core.PersistentVector.EMPTY;
var inst_25642 = cljs.core.into.call(null,inst_25641,inst_25640);
var state_25704__$1 = (function (){var statearr_25859 = state_25704;
(statearr_25859[(34)] = inst_25642);

return statearr_25859;
})();
if(cljs.core.truth_(inst_25396)){
var statearr_25860_26028 = state_25704__$1;
(statearr_25860_26028[(1)] = (113));

} else {
var statearr_25861_26029 = state_25704__$1;
(statearr_25861_26029[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (124))){
var inst_25683 = (state_25704[(41)]);
var inst_25682 = (state_25704[(2)]);
var inst_25683__$1 = selectOne;
var state_25704__$1 = (function (){var statearr_25862 = state_25704;
(statearr_25862[(11)] = inst_25682);

(statearr_25862[(41)] = inst_25683__$1);

return statearr_25862;
})();
if(cljs.core.truth_(inst_25683__$1)){
var statearr_25863_26030 = state_25704__$1;
(statearr_25863_26030[(1)] = (125));

} else {
var statearr_25864_26031 = state_25704__$1;
(statearr_25864_26031[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (87))){
var inst_25574 = (state_25704[(2)]);
var inst_25575 = fluree.db.util.async.throw_err.call(null,inst_25574);
var state_25704__$1 = (function (){var statearr_25865 = state_25704;
(statearr_25865[(31)] = inst_25575);

return statearr_25865;
})();
if(cljs.core.truth_(fuel)){
var statearr_25866_26032 = state_25704__$1;
(statearr_25866_26032[(1)] = (88));

} else {
var statearr_25867_26033 = state_25704__$1;
(statearr_25867_26033[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (30))){
var inst_25446 = typeof from === 'string';
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25446)){
var statearr_25868_26034 = state_25704__$1;
(statearr_25868_26034[(1)] = (33));

} else {
var statearr_25869_26035 = state_25704__$1;
(statearr_25869_26035[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (73))){
var inst_25557 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_25704__$1 = state_25704;
if(inst_25557){
var statearr_25870_26036 = state_25704__$1;
(statearr_25870_26036[(1)] = (80));

} else {
var statearr_25871_26037 = state_25704__$1;
(statearr_25871_26037[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (96))){
var inst_25667 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25872_26038 = state_25704__$1;
(statearr_25872_26038[(2)] = inst_25667);

(statearr_25872_26038[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (10))){
var inst_25380 = (state_25704[(39)]);
var inst_25380__$1 = selectDistinct;
var state_25704__$1 = (function (){var statearr_25873 = state_25704;
(statearr_25873[(39)] = inst_25380__$1);

return statearr_25873;
})();
if(cljs.core.truth_(inst_25380__$1)){
var statearr_25874_26039 = state_25704__$1;
(statearr_25874_26039[(1)] = (12));

} else {
var statearr_25875_26040 = state_25704__$1;
(statearr_25875_26040[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (18))){
var inst_25396 = (state_25704[(18)]);
var inst_25411 = cljs.core.vector_QMARK_.call(null,inst_25396);
var state_25704__$1 = state_25704;
if(inst_25411){
var statearr_25876_26041 = state_25704__$1;
(statearr_25876_26041[(1)] = (21));

} else {
var statearr_25877_26042 = state_25704__$1;
(statearr_25877_26042[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (105))){
var inst_25619 = cljs.core._deref.call(null,fuel);
var inst_25620 = (inst_25619 + (1));
var inst_25621 = cljs.core._vreset_BANG_.call(null,fuel,inst_25620);
var state_25704__$1 = state_25704;
var statearr_25878_26043 = state_25704__$1;
(statearr_25878_26043[(2)] = inst_25621);

(statearr_25878_26043[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (52))){
var inst_25483 = (state_25704[(2)]);
var state_25704__$1 = (function (){var statearr_25879 = state_25704;
(statearr_25879[(21)] = inst_25483);

return statearr_25879;
})();
var statearr_25880_26044 = state_25704__$1;
(statearr_25880_26044[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (114))){
var inst_25397 = (state_25704[(14)]);
var state_25704__$1 = state_25704;
var statearr_25882_26045 = state_25704__$1;
(statearr_25882_26045[(2)] = inst_25397);

(statearr_25882_26045[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (67))){
var inst_25522 = cljs.core.PersistentHashMap.EMPTY;
var state_25704__$1 = state_25704;
var statearr_25883_26046 = state_25704__$1;
(statearr_25883_26046[(2)] = inst_25522);

(statearr_25883_26046[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (71))){
var inst_25535 = (state_25704[(2)]);
var inst_25536 = fluree.db.util.async.throw_err.call(null,inst_25535);
var state_25704__$1 = state_25704;
var statearr_25884_26047 = state_25704__$1;
(statearr_25884_26047[(2)] = inst_25536);

(statearr_25884_26047[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (42))){
var inst_25399 = (state_25704[(15)]);
var state_25704__$1 = state_25704;
var statearr_25885_26048 = state_25704__$1;
(statearr_25885_26048[(2)] = inst_25399);

(statearr_25885_26048[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (80))){
var inst_25560 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_25704__$1 = state_25704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25704__$1,(83),inst_25560);
} else {
if((state_val_25705 === (37))){
var inst_25465 = (state_25704[(2)]);
var inst_25466 = fluree.db.util.async.throw_err.call(null,inst_25465);
var state_25704__$1 = state_25704;
var statearr_25886_26049 = state_25704__$1;
(statearr_25886_26049[(2)] = inst_25466);

(statearr_25886_26049[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (63))){
var inst_25519 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
if(cljs.core.truth_(inst_25519)){
var statearr_25887_26050 = state_25704__$1;
(statearr_25887_26050[(1)] = (64));

} else {
var statearr_25888_26051 = state_25704__$1;
(statearr_25888_26051[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (94))){
var inst_25598 = from;
var inst_25599 = cljs.core.seq.call(null,inst_25598);
var inst_25600 = cljs.core.first.call(null,inst_25599);
var inst_25601 = cljs.core.next.call(null,inst_25599);
var inst_25602 = cljs.core.PersistentVector.EMPTY;
var inst_25603 = inst_25598;
var inst_25604 = inst_25602;
var state_25704__$1 = (function (){var statearr_25889 = state_25704;
(statearr_25889[(38)] = inst_25603);

(statearr_25889[(10)] = inst_25604);

(statearr_25889[(42)] = inst_25600);

(statearr_25889[(43)] = inst_25601);

return statearr_25889;
})();
var statearr_25890_26052 = state_25704__$1;
(statearr_25890_26052[(2)] = null);

(statearr_25890_26052[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (8))){
var inst_25398 = (state_25704[(25)]);
var inst_25393 = (state_25704[(2)]);
var inst_25394 = opts_SINGLEQUOTE_;
var inst_25395 = cljs.core.__destructure_map.call(null,inst_25394);
var inst_25396 = cljs.core.get.call(null,inst_25395,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25397 = cljs.core.get.call(null,inst_25395,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25398__$1 = cljs.core.get.call(null,inst_25395,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25399 = cljs.core.get.call(null,inst_25395,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25400 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_25393,opts_SINGLEQUOTE_);
var inst_25401 = (inst_25398__$1 == null);
var inst_25402 = cljs.core.not.call(null,inst_25401);
var state_25704__$1 = (function (){var statearr_25891 = state_25704;
(statearr_25891[(15)] = inst_25399);

(statearr_25891[(18)] = inst_25396);

(statearr_25891[(24)] = inst_25400);

(statearr_25891[(14)] = inst_25397);

(statearr_25891[(25)] = inst_25398__$1);

return statearr_25891;
})();
if(inst_25402){
var statearr_25892_26053 = state_25704__$1;
(statearr_25892_26053[(1)] = (15));

} else {
var statearr_25893_26054 = state_25704__$1;
(statearr_25893_26054[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (49))){
var inst_25675 = (state_25704[(2)]);
var state_25704__$1 = state_25704;
var statearr_25894_26055 = state_25704__$1;
(statearr_25894_26055[(2)] = inst_25675);

(statearr_25894_26055[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25705 === (84))){
var state_25704__$1 = state_25704;
var statearr_25895_26056 = state_25704__$1;
(statearr_25895_26056[(2)] = null);

(statearr_25895_26056[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2726__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2726__auto____0 = (function (){
var statearr_25896 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25896[(0)] = fluree$db$query$fql$query_$_state_machine__2726__auto__);

(statearr_25896[(1)] = (1));

return statearr_25896;
});
var fluree$db$query$fql$query_$_state_machine__2726__auto____1 = (function (state_25704){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_25704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e25897){var ex__2729__auto__ = e25897;
var statearr_25898_26057 = state_25704;
(statearr_25898_26057[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_25704[(4)]))){
var statearr_25899_26058 = state_25704;
(statearr_25899_26058[(1)] = cljs.core.first.call(null,(state_25704[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26059 = state_25704;
state_25704 = G__26059;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2726__auto__ = function(state_25704){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2726__auto____1.call(this,state_25704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2726__auto____0;
fluree$db$query$fql$query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2726__auto____1;
return fluree$db$query$fql$query_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_25900 = f__2749__auto__.call(null);
(statearr_25900[(6)] = c__2748__auto__);

return statearr_25900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}

});
