// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (((cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4223__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14005 = match;
var p1 = cljs.core.nth.call(null,vec__14005,(0),null);
var p2 = cljs.core.nth.call(null,vec__14005,(1),null);
var p3 = cljs.core.nth.call(null,vec__14005,(2),null);
var t = cljs.core.nth.call(null,vec__14005,(3),null);
var op = cljs.core.nth.call(null,vec__14005,(4),null);
var m = cljs.core.nth.call(null,vec__14005,(5),null);
var G__14008 = idx;
var G__14008__$1 = (((G__14008 instanceof cljs.core.Keyword))?G__14008.fqn:null);
switch (G__14008__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14008__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14010 = idx;
var G__14010__$1 = (((G__14010 instanceof cljs.core.Keyword))?G__14010.fqn:null);
switch (G__14010__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14010__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14012 = idx;
var G__14012__$1 = (((G__14012 instanceof cljs.core.Keyword))?G__14012.fqn:null);
switch (G__14012__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14012__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14015 = arguments.length;
switch (G__14015) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14016 = (function (){var pred__14019 = cljs.core.identical_QMARK_;
var expr__14020 = test;
if(cljs.core.truth_(pred__14019.call(null,cljs.core._EQ_,expr__14020))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14019.call(null,cljs.core._LT_,expr__14020))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14019.call(null,cljs.core._LT__EQ_,expr__14020))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14019.call(null,cljs.core._GT_,expr__14020))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14019.call(null,cljs.core._GT__EQ_,expr__14020))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14020)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__14016,(0),null);
var start_match = cljs.core.nth.call(null,vec__14016,(1),null);
var end_test = cljs.core.nth.call(null,vec__14016,(2),null);
var end_match = cljs.core.nth.call(null,vec__14016,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_14259){
var state_val_14260 = (state_14259[(1)]);
if((state_val_14260 === (65))){
var inst_14230 = (state_14259[(7)]);
var inst_14174 = (state_14259[(8)]);
var inst_14230__$1 = (state_14259[(2)]);
var inst_14231 = cljs.core.count.call(null,inst_14230__$1);
var state_14259__$1 = (function (){var statearr_14261 = state_14259;
(statearr_14261[(7)] = inst_14230__$1);

(statearr_14261[(9)] = inst_14231);

return statearr_14261;
})();
if(cljs.core.truth_(inst_14174)){
var statearr_14262_14399 = state_14259__$1;
(statearr_14262_14399[(1)] = (81));

} else {
var statearr_14263_14400 = state_14259__$1;
(statearr_14263_14400[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (70))){
var inst_14205 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
if(cljs.core.truth_(inst_14205)){
var statearr_14264_14401 = state_14259__$1;
(statearr_14264_14401[(1)] = (71));

} else {
var statearr_14265_14402 = state_14259__$1;
(statearr_14265_14402[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (62))){
var inst_14144 = (state_14259[(10)]);
var inst_14158 = (state_14259[(11)]);
var inst_14173 = (state_14259[(2)]);
var inst_14174 = fluree.db.dbproto._rhs.call(null,inst_14158);
var state_14259__$1 = (function (){var statearr_14266 = state_14259;
(statearr_14266[(12)] = inst_14173);

(statearr_14266[(8)] = inst_14174);

return statearr_14266;
})();
if(cljs.core.truth_(inst_14144)){
var statearr_14267_14403 = state_14259__$1;
(statearr_14267_14403[(1)] = (63));

} else {
var statearr_14268_14404 = state_14259__$1;
(statearr_14268_14404[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (74))){
var inst_14198 = (state_14259[(13)]);
var inst_14212 = fluree.db.permissions_validate.allow_flake_QMARK_.call(null,db,inst_14198);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(77),inst_14212);
} else {
if((state_val_14260 === (7))){
var inst_14035 = (state_14259[(14)]);
var state_14259__$1 = state_14259;
var statearr_14269_14405 = state_14259__$1;
(statearr_14269_14405[(2)] = inst_14035);

(statearr_14269_14405[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (59))){
var inst_14121 = (state_14259[(15)]);
var inst_14165 = (state_14259[(16)]);
var inst_14120 = (state_14259[(17)]);
var inst_14164 = (state_14259[(2)]);
var inst_14165__$1 = fluree.db.util.async.throw_err.call(null,inst_14164);
var inst_14166 = fluree.db.flake.subrange.call(null,inst_14165__$1,start_test,inst_14120,end_test,inst_14121);
var inst_14167 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_14120,inst_14121);
var state_14259__$1 = (function (){var statearr_14270 = state_14259;
(statearr_14270[(18)] = inst_14166);

(statearr_14270[(16)] = inst_14165__$1);

return statearr_14270;
})();
if(inst_14167){
var statearr_14271_14406 = state_14259__$1;
(statearr_14271_14406[(1)] = (60));

} else {
var statearr_14272_14407 = state_14259__$1;
(statearr_14272_14407[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (86))){
var inst_14239 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14273_14408 = state_14259__$1;
(statearr_14273_14408[(2)] = inst_14239);

(statearr_14273_14408[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (20))){
var inst_14036 = (state_14259[(19)]);
var inst_14084 = (state_14259[(20)]);
var inst_14083 = (state_14259[(2)]);
var inst_14084__$1 = (inst_14036 == null);
var state_14259__$1 = (function (){var statearr_14274 = state_14259;
(statearr_14274[(21)] = inst_14083);

(statearr_14274[(20)] = inst_14084__$1);

return statearr_14274;
})();
if(cljs.core.truth_(inst_14084__$1)){
var statearr_14275_14409 = state_14259__$1;
(statearr_14275_14409[(1)] = (22));

} else {
var statearr_14276_14410 = state_14259__$1;
(statearr_14276_14410[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (72))){
var inst_14191 = (state_14259[(22)]);
var inst_14209 = (inst_14191 + (1));
var inst_14210 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14259__$1 = (function (){var statearr_14277 = state_14259;
(statearr_14277[(23)] = inst_14209);

return statearr_14277;
})();
if(cljs.core.truth_(inst_14210)){
var statearr_14278_14411 = state_14259__$1;
(statearr_14278_14411[(1)] = (74));

} else {
var statearr_14279_14412 = state_14259__$1;
(statearr_14279_14412[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (58))){
var inst_14254 = (state_14259[(2)]);
var _ = (function (){var statearr_14280 = state_14259;
(statearr_14280[(4)] = cljs.core.rest.call(null,(state_14259[(4)])));

return statearr_14280;
})();
var state_14259__$1 = state_14259;
var statearr_14281_14413 = state_14259__$1;
(statearr_14281_14413[(2)] = inst_14254);

(statearr_14281_14413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (60))){
var inst_14137 = (state_14259[(24)]);
var inst_14045 = (state_14259[(25)]);
var inst_14160 = (state_14259[(26)]);
var inst_14101 = (state_14259[(27)]);
var inst_14038 = (state_14259[(28)]);
var inst_14046 = (state_14259[(29)]);
var inst_14144 = (state_14259[(10)]);
var inst_14041 = (state_14259[(30)]);
var inst_14056 = (state_14259[(31)]);
var inst_14121 = (state_14259[(15)]);
var inst_14119 = (state_14259[(32)]);
var inst_14083 = (state_14259[(21)]);
var inst_14166 = (state_14259[(18)]);
var inst_14034 = (state_14259[(33)]);
var inst_14159 = (state_14259[(34)]);
var inst_14126 = (state_14259[(35)]);
var inst_14039 = (state_14259[(36)]);
var inst_14148 = (state_14259[(37)]);
var inst_14110 = (state_14259[(38)]);
var inst_14065 = (state_14259[(39)]);
var inst_14165 = (state_14259[(16)]);
var inst_14074 = (state_14259[(40)]);
var inst_14120 = (state_14259[(17)]);
var inst_14127 = (state_14259[(41)]);
var inst_14158 = (state_14259[(11)]);
var inst_14092 = (state_14259[(42)]);
var inst_14138 = (state_14259[(43)]);
var inst_14153 = (state_14259[(44)]);
var inst_14131 = (state_14259[(45)]);
var inst_14169 = (function (){var no_filter_QMARK_ = inst_14144;
var next_node = inst_14158;
var flakes = inst_14165;
var s1 = inst_14056;
var o2 = inst_14083;
var t1 = inst_14038;
var i = inst_14159;
var m1 = inst_14110;
var root_node = inst_14153;
var to_t = inst_14138;
var s2 = inst_14065;
var p2 = inst_14101;
var permissions = inst_14127;
var vec__14028 = inst_14034;
var limit = inst_14126;
var start_flake = inst_14120;
var vec__14031 = inst_14041;
var acc = inst_14160;
var t2 = inst_14045;
var op1 = inst_14039;
var o1 = inst_14074;
var end_flake = inst_14121;
var base_result = inst_14166;
var p1 = inst_14092;
var idx_compare = inst_14131;
var op2 = inst_14046;
var from_t = inst_14137;
var m2 = inst_14119;
var novelty = inst_14148;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_14170 = cljs.core.reduce.call(null,inst_14169,inst_14166,inst_14166);
var state_14259__$1 = state_14259;
var statearr_14282_14414 = state_14259__$1;
(statearr_14282_14414[(2)] = inst_14170);

(statearr_14282_14414[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (27))){
var inst_14043 = (state_14259[(46)]);
var inst_14093 = (state_14259[(47)]);
var inst_14092 = (state_14259[(2)]);
var inst_14093__$1 = (inst_14043 == null);
var state_14259__$1 = (function (){var statearr_14283 = state_14259;
(statearr_14283[(47)] = inst_14093__$1);

(statearr_14283[(42)] = inst_14092);

return statearr_14283;
})();
if(cljs.core.truth_(inst_14093__$1)){
var statearr_14284_14415 = state_14259__$1;
(statearr_14284_14415[(1)] = (28));

} else {
var statearr_14285_14416 = state_14259__$1;
(statearr_14285_14416[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (1))){
var state_14259__$1 = state_14259;
var statearr_14286_14417 = state_14259__$1;
(statearr_14286_14417[(2)] = null);

(statearr_14286_14417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (69))){
var inst_14126 = (state_14259[(35)]);
var inst_14191 = (state_14259[(22)]);
var inst_14203 = (inst_14191 > inst_14126);
var state_14259__$1 = state_14259;
var statearr_14287_14418 = state_14259__$1;
(statearr_14287_14418[(2)] = inst_14203);

(statearr_14287_14418[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (24))){
var inst_14088 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
if(cljs.core.truth_(inst_14088)){
var statearr_14288_14419 = state_14259__$1;
(statearr_14288_14419[(1)] = (25));

} else {
var statearr_14289_14420 = state_14259__$1;
(statearr_14289_14420[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (55))){
var inst_14120 = (state_14259[(17)]);
var inst_14153 = (state_14259[(44)]);
var inst_14152 = (state_14259[(2)]);
var inst_14153__$1 = fluree.db.util.async.throw_err.call(null,inst_14152);
var inst_14154 = fluree.db.dbproto._lookup_leaf.call(null,inst_14153__$1,inst_14120);
var state_14259__$1 = (function (){var statearr_14290 = state_14259;
(statearr_14290[(44)] = inst_14153__$1);

return statearr_14290;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(56),inst_14154);
} else {
if((state_val_14260 === (85))){
var inst_14234 = (state_14259[(48)]);
var state_14259__$1 = state_14259;
var statearr_14291_14421 = state_14259__$1;
(statearr_14291_14421[(2)] = inst_14234);

(statearr_14291_14421[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (39))){
var inst_14108 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14292_14422 = state_14259__$1;
(statearr_14292_14422[(2)] = inst_14108);

(statearr_14292_14422[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (88))){
var inst_14153 = (state_14259[(44)]);
var inst_14174 = (state_14259[(8)]);
var inst_14246 = fluree.db.dbproto._lookup_leaf.call(null,inst_14153,inst_14174);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(90),inst_14246);
} else {
if((state_val_14260 === (46))){
var inst_14122 = (state_14259[(49)]);
var state_14259__$1 = state_14259;
var statearr_14293_14423 = state_14259__$1;
(statearr_14293_14423[(2)] = inst_14122);

(statearr_14293_14423[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (4))){
var inst_14022 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14294_14424 = state_14259__$1;
(statearr_14294_14424[(2)] = inst_14022);

(statearr_14294_14424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (77))){
var inst_14214 = (state_14259[(2)]);
var inst_14215 = fluree.db.util.async.throw_err.call(null,inst_14214);
var state_14259__$1 = state_14259;
if(cljs.core.truth_(inst_14215)){
var statearr_14295_14425 = state_14259__$1;
(statearr_14295_14425[(1)] = (78));

} else {
var statearr_14296_14426 = state_14259__$1;
(statearr_14296_14426[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (54))){
var inst_14144 = (state_14259[(2)]);
var inst_14145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14146 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14147 = (new cljs.core.PersistentVector(null,2,(5),inst_14145,inst_14146,null));
var inst_14148 = cljs.core.get_in.call(null,db,inst_14147);
var inst_14149 = cljs.core.get.call(null,db,idx);
var inst_14150 = fluree.db.dbproto._resolve.call(null,inst_14149);
var state_14259__$1 = (function (){var statearr_14297 = state_14259;
(statearr_14297[(10)] = inst_14144);

(statearr_14297[(37)] = inst_14148);

return statearr_14297;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(55),inst_14150);
} else {
if((state_val_14260 === (15))){
var inst_14037 = (state_14259[(50)]);
var state_14259__$1 = state_14259;
var statearr_14298_14427 = state_14259__$1;
(statearr_14298_14427[(2)] = inst_14037);

(statearr_14298_14427[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (48))){
var inst_14132 = (state_14259[(51)]);
var inst_14126 = (state_14259[(2)]);
var inst_14127 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14129 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14130 = (new cljs.core.PersistentVector(null,3,(5),inst_14128,inst_14129,null));
var inst_14131 = cljs.core.get_in.call(null,db,inst_14130);
var inst_14132__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14259__$1 = (function (){var statearr_14299 = state_14259;
(statearr_14299[(35)] = inst_14126);

(statearr_14299[(41)] = inst_14127);

(statearr_14299[(45)] = inst_14131);

(statearr_14299[(51)] = inst_14132__$1);

return statearr_14299;
})();
if(cljs.core.truth_(inst_14132__$1)){
var statearr_14300_14428 = state_14259__$1;
(statearr_14300_14428[(1)] = (49));

} else {
var statearr_14301_14429 = state_14259__$1;
(statearr_14301_14429[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (50))){
var inst_14135 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14259__$1 = state_14259;
var statearr_14302_14430 = state_14259__$1;
(statearr_14302_14430[(2)] = inst_14135);

(statearr_14302_14430[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (75))){
var inst_14192 = (state_14259[(52)]);
var state_14259__$1 = state_14259;
var statearr_14303_14431 = state_14259__$1;
(statearr_14303_14431[(2)] = inst_14192);

(statearr_14303_14431[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (21))){
var inst_14079 = (state_14259[(2)]);
var inst_14080 = fluree.db.util.async.throw_err.call(null,inst_14079);
var state_14259__$1 = state_14259;
var statearr_14304_14432 = state_14259__$1;
(statearr_14304_14432[(2)] = inst_14080);

(statearr_14304_14432[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (31))){
var state_14259__$1 = state_14259;
var statearr_14305_14433 = state_14259__$1;
(statearr_14305_14433[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14305_14433[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (32))){
var inst_14043 = (state_14259[(46)]);
var state_14259__$1 = state_14259;
var statearr_14306_14434 = state_14259__$1;
(statearr_14306_14434[(2)] = inst_14043);

(statearr_14306_14434[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (40))){
var inst_14047 = (state_14259[(53)]);
var state_14259__$1 = state_14259;
var statearr_14307_14435 = state_14259__$1;
(statearr_14307_14435[(2)] = inst_14047);

(statearr_14307_14435[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (56))){
var inst_14156 = (state_14259[(2)]);
var inst_14157 = fluree.db.util.async.throw_err.call(null,inst_14156);
var inst_14158 = inst_14157;
var inst_14159 = (0);
var inst_14160 = null;
var state_14259__$1 = (function (){var statearr_14308 = state_14259;
(statearr_14308[(26)] = inst_14160);

(statearr_14308[(34)] = inst_14159);

(statearr_14308[(11)] = inst_14158);

return statearr_14308;
})();
var statearr_14309_14436 = state_14259__$1;
(statearr_14309_14436[(2)] = null);

(statearr_14309_14436[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (33))){
var inst_14040 = (state_14259[(54)]);
var inst_14101 = (state_14259[(2)]);
var state_14259__$1 = (function (){var statearr_14310 = state_14259;
(statearr_14310[(27)] = inst_14101);

return statearr_14310;
})();
if(cljs.core.truth_(inst_14040)){
var statearr_14311_14437 = state_14259__$1;
(statearr_14311_14437[(1)] = (34));

} else {
var statearr_14312_14438 = state_14259__$1;
(statearr_14312_14438[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (13))){
var inst_14061 = (state_14259[(2)]);
var inst_14062 = fluree.db.util.async.throw_err.call(null,inst_14061);
var state_14259__$1 = state_14259;
var statearr_14313_14439 = state_14259__$1;
(statearr_14313_14439[(2)] = inst_14062);

(statearr_14313_14439[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (22))){
var inst_14074 = (state_14259[(40)]);
var state_14259__$1 = state_14259;
var statearr_14314_14440 = state_14259__$1;
(statearr_14314_14440[(2)] = inst_14074);

(statearr_14314_14440[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (90))){
var inst_14230 = (state_14259[(7)]);
var inst_14231 = (state_14259[(9)]);
var inst_14248 = (state_14259[(2)]);
var inst_14249 = fluree.db.util.async.throw_err.call(null,inst_14248);
var inst_14158 = inst_14249;
var inst_14159 = inst_14231;
var inst_14160 = inst_14230;
var state_14259__$1 = (function (){var statearr_14315 = state_14259;
(statearr_14315[(26)] = inst_14160);

(statearr_14315[(34)] = inst_14159);

(statearr_14315[(11)] = inst_14158);

return statearr_14315;
})();
var statearr_14316_14441 = state_14259__$1;
(statearr_14316_14441[(2)] = null);

(statearr_14316_14441[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (36))){
var inst_14047 = (state_14259[(53)]);
var inst_14110 = (state_14259[(2)]);
var state_14259__$1 = (function (){var statearr_14317 = state_14259;
(statearr_14317[(38)] = inst_14110);

return statearr_14317;
})();
if(cljs.core.truth_(inst_14047)){
var statearr_14318_14442 = state_14259__$1;
(statearr_14318_14442[(1)] = (40));

} else {
var statearr_14319_14443 = state_14259__$1;
(statearr_14319_14443[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (41))){
var inst_14113 = (cljs.core._LT__EQ_ === end_test);
var state_14259__$1 = state_14259;
if(cljs.core.truth_(inst_14113)){
var statearr_14320_14444 = state_14259__$1;
(statearr_14320_14444[(1)] = (43));

} else {
var statearr_14321_14445 = state_14259__$1;
(statearr_14321_14445[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (89))){
var inst_14252 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14322_14446 = state_14259__$1;
(statearr_14322_14446[(2)] = inst_14252);

(statearr_14322_14446[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (43))){
var state_14259__$1 = state_14259;
var statearr_14323_14447 = state_14259__$1;
(statearr_14323_14447[(2)] = (2147483647));

(statearr_14323_14447[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (61))){
var inst_14166 = (state_14259[(18)]);
var state_14259__$1 = state_14259;
var statearr_14324_14448 = state_14259__$1;
(statearr_14324_14448[(2)] = inst_14166);

(statearr_14324_14448[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (29))){
var inst_14093 = (state_14259[(47)]);
var state_14259__$1 = state_14259;
var statearr_14325_14449 = state_14259__$1;
(statearr_14325_14449[(2)] = inst_14093);

(statearr_14325_14449[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (44))){
var state_14259__$1 = state_14259;
var statearr_14326_14450 = state_14259__$1;
(statearr_14326_14450[(2)] = fluree.db.util.core.min_integer);

(statearr_14326_14450[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (6))){
var inst_14035 = (state_14259[(14)]);
var inst_14050 = fluree.db.dbproto._subid.call(null,db,inst_14035);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(9),inst_14050);
} else {
if((state_val_14260 === (28))){
var inst_14083 = (state_14259[(21)]);
var state_14259__$1 = state_14259;
var statearr_14327_14451 = state_14259__$1;
(statearr_14327_14451[(2)] = inst_14083);

(statearr_14327_14451[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (64))){
var inst_14173 = (state_14259[(12)]);
var inst_14159 = (state_14259[(34)]);
var inst_14187 = cljs.core.seq.call(null,inst_14173);
var inst_14188 = cljs.core.first.call(null,inst_14187);
var inst_14189 = cljs.core.next.call(null,inst_14187);
var inst_14190 = inst_14173;
var inst_14191 = inst_14159;
var inst_14192 = inst_14173;
var state_14259__$1 = (function (){var statearr_14328 = state_14259;
(statearr_14328[(55)] = inst_14190);

(statearr_14328[(56)] = inst_14188);

(statearr_14328[(22)] = inst_14191);

(statearr_14328[(57)] = inst_14189);

(statearr_14328[(52)] = inst_14192);

return statearr_14328;
})();
var statearr_14329_14452 = state_14259__$1;
(statearr_14329_14452[(2)] = null);

(statearr_14329_14452[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (51))){
var inst_14137 = (state_14259[(2)]);
var inst_14138 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_14139 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14259__$1 = (function (){var statearr_14330 = state_14259;
(statearr_14330[(24)] = inst_14137);

(statearr_14330[(43)] = inst_14138);

return statearr_14330;
})();
if(cljs.core.truth_(inst_14139)){
var statearr_14331_14453 = state_14259__$1;
(statearr_14331_14453[(1)] = (52));

} else {
var statearr_14332_14454 = state_14259__$1;
(statearr_14332_14454[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (25))){
var state_14259__$1 = state_14259;
var statearr_14333_14455 = state_14259__$1;
(statearr_14333_14455[(2)] = (-1));

(statearr_14333_14455[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (34))){
var inst_14040 = (state_14259[(54)]);
var state_14259__$1 = state_14259;
var statearr_14334_14456 = state_14259__$1;
(statearr_14334_14456[(2)] = inst_14040);

(statearr_14334_14456[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (17))){
var inst_14070 = (state_14259[(2)]);
var inst_14071 = fluree.db.util.async.throw_err.call(null,inst_14070);
var state_14259__$1 = state_14259;
var statearr_14335_14457 = state_14259__$1;
(statearr_14335_14457[(2)] = inst_14071);

(statearr_14335_14457[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (3))){
var inst_14257 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14259__$1,inst_14257);
} else {
if((state_val_14260 === (12))){
var inst_14037 = (state_14259[(50)]);
var inst_14065 = (state_14259[(2)]);
var inst_14066 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14037);
var state_14259__$1 = (function (){var statearr_14336 = state_14259;
(statearr_14336[(39)] = inst_14065);

return statearr_14336;
})();
if(inst_14066){
var statearr_14337_14458 = state_14259__$1;
(statearr_14337_14458[(1)] = (14));

} else {
var statearr_14338_14459 = state_14259__$1;
(statearr_14338_14459[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (2))){
var inst_14035 = (state_14259[(14)]);
var inst_14041 = (state_14259[(30)]);
var inst_14034 = (state_14259[(33)]);
var _ = (function (){var statearr_14339 = state_14259;
(statearr_14339[(4)] = cljs.core.cons.call(null,(5),(state_14259[(4)])));

return statearr_14339;
})();
var inst_14034__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_14035__$1 = cljs.core.nth.call(null,inst_14034__$1,(0),null);
var inst_14036 = cljs.core.nth.call(null,inst_14034__$1,(1),null);
var inst_14037 = cljs.core.nth.call(null,inst_14034__$1,(2),null);
var inst_14038 = cljs.core.nth.call(null,inst_14034__$1,(3),null);
var inst_14039 = cljs.core.nth.call(null,inst_14034__$1,(4),null);
var inst_14040 = cljs.core.nth.call(null,inst_14034__$1,(5),null);
var inst_14041__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_14042 = cljs.core.nth.call(null,inst_14041__$1,(0),null);
var inst_14043 = cljs.core.nth.call(null,inst_14041__$1,(1),null);
var inst_14044 = cljs.core.nth.call(null,inst_14041__$1,(2),null);
var inst_14045 = cljs.core.nth.call(null,inst_14041__$1,(3),null);
var inst_14046 = cljs.core.nth.call(null,inst_14041__$1,(4),null);
var inst_14047 = cljs.core.nth.call(null,inst_14041__$1,(5),null);
var inst_14048 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14035__$1);
var state_14259__$1 = (function (){var statearr_14340 = state_14259;
(statearr_14340[(25)] = inst_14045);

(statearr_14340[(58)] = inst_14044);

(statearr_14340[(46)] = inst_14043);

(statearr_14340[(28)] = inst_14038);

(statearr_14340[(14)] = inst_14035__$1);

(statearr_14340[(29)] = inst_14046);

(statearr_14340[(30)] = inst_14041__$1);

(statearr_14340[(19)] = inst_14036);

(statearr_14340[(33)] = inst_14034__$1);

(statearr_14340[(54)] = inst_14040);

(statearr_14340[(36)] = inst_14039);

(statearr_14340[(53)] = inst_14047);

(statearr_14340[(59)] = inst_14042);

(statearr_14340[(50)] = inst_14037);

return statearr_14340;
})();
if(inst_14048){
var statearr_14341_14460 = state_14259__$1;
(statearr_14341_14460[(1)] = (6));

} else {
var statearr_14342_14461 = state_14259__$1;
(statearr_14342_14461[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (66))){
var inst_14190 = (state_14259[(55)]);
var inst_14198 = (state_14259[(13)]);
var inst_14200 = (state_14259[(60)]);
var inst_14197 = cljs.core.seq.call(null,inst_14190);
var inst_14198__$1 = cljs.core.first.call(null,inst_14197);
var inst_14199 = cljs.core.next.call(null,inst_14197);
var inst_14200__$1 = (inst_14198__$1 == null);
var state_14259__$1 = (function (){var statearr_14343 = state_14259;
(statearr_14343[(61)] = inst_14199);

(statearr_14343[(13)] = inst_14198__$1);

(statearr_14343[(60)] = inst_14200__$1);

return statearr_14343;
})();
if(cljs.core.truth_(inst_14200__$1)){
var statearr_14344_14462 = state_14259__$1;
(statearr_14344_14462[(1)] = (68));

} else {
var statearr_14345_14463 = state_14259__$1;
(statearr_14345_14463[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (23))){
var inst_14084 = (state_14259[(20)]);
var state_14259__$1 = state_14259;
var statearr_14346_14464 = state_14259__$1;
(statearr_14346_14464[(2)] = inst_14084);

(statearr_14346_14464[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (47))){
var state_14259__$1 = state_14259;
var statearr_14347_14465 = state_14259__$1;
(statearr_14347_14465[(2)] = fluree.db.util.core.max_long);

(statearr_14347_14465[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (35))){
var inst_14104 = (cljs.core._GT__EQ_ === start_test);
var state_14259__$1 = state_14259;
if(cljs.core.truth_(inst_14104)){
var statearr_14348_14466 = state_14259__$1;
(statearr_14348_14466[(1)] = (37));

} else {
var statearr_14349_14467 = state_14259__$1;
(statearr_14349_14467[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (82))){
var inst_14174 = (state_14259[(8)]);
var state_14259__$1 = state_14259;
var statearr_14350_14468 = state_14259__$1;
(statearr_14350_14468[(2)] = inst_14174);

(statearr_14350_14468[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (76))){
var inst_14199 = (state_14259[(61)]);
var inst_14209 = (state_14259[(23)]);
var inst_14223 = (state_14259[(2)]);
var inst_14190 = inst_14199;
var inst_14191 = inst_14209;
var inst_14192 = inst_14223;
var state_14259__$1 = (function (){var statearr_14351 = state_14259;
(statearr_14351[(55)] = inst_14190);

(statearr_14351[(22)] = inst_14191);

(statearr_14351[(52)] = inst_14192);

return statearr_14351;
})();
var statearr_14352_14469 = state_14259__$1;
(statearr_14352_14469[(2)] = null);

(statearr_14352_14469[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (19))){
var inst_14044 = (state_14259[(58)]);
var state_14259__$1 = state_14259;
var statearr_14353_14470 = state_14259__$1;
(statearr_14353_14470[(2)] = inst_14044);

(statearr_14353_14470[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (57))){
var inst_14137 = (state_14259[(24)]);
var inst_14148 = (state_14259[(37)]);
var inst_14158 = (state_14259[(11)]);
var inst_14138 = (state_14259[(43)]);
var inst_14162 = fluree.db.dbproto._resolve_history_range.call(null,inst_14158,inst_14137,inst_14138,inst_14148);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(59),inst_14162);
} else {
if((state_val_14260 === (68))){
var inst_14200 = (state_14259[(60)]);
var state_14259__$1 = state_14259;
var statearr_14354_14471 = state_14259__$1;
(statearr_14354_14471[(2)] = inst_14200);

(statearr_14354_14471[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (11))){
var inst_14042 = (state_14259[(59)]);
var state_14259__$1 = state_14259;
var statearr_14356_14472 = state_14259__$1;
(statearr_14356_14472[(2)] = inst_14042);

(statearr_14356_14472[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (9))){
var inst_14052 = (state_14259[(2)]);
var inst_14053 = fluree.db.util.async.throw_err.call(null,inst_14052);
var state_14259__$1 = state_14259;
var statearr_14357_14473 = state_14259__$1;
(statearr_14357_14473[(2)] = inst_14053);

(statearr_14357_14473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (5))){
var _ = (function (){var statearr_14358 = state_14259;
(statearr_14358[(4)] = cljs.core.rest.call(null,(state_14259[(4)])));

return statearr_14358;
})();
var state_14259__$1 = state_14259;
var ex14355 = (state_14259__$1[(2)]);
var statearr_14359_14474 = state_14259__$1;
(statearr_14359_14474[(5)] = ex14355);


if((ex14355 instanceof Error)){
var statearr_14360_14475 = state_14259__$1;
(statearr_14360_14475[(1)] = (4));

(statearr_14360_14475[(5)] = null);

} else {
throw ex14355;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (83))){
var inst_14242 = (state_14259[(2)]);
var inst_14243 = cljs.core.not.call(null,inst_14242);
var state_14259__$1 = state_14259;
if(inst_14243){
var statearr_14361_14476 = state_14259__$1;
(statearr_14361_14476[(1)] = (87));

} else {
var statearr_14362_14477 = state_14259__$1;
(statearr_14362_14477[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (14))){
var inst_14037 = (state_14259[(50)]);
var inst_14068 = fluree.db.dbproto._subid.call(null,db,inst_14037);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(17),inst_14068);
} else {
if((state_val_14260 === (45))){
var inst_14117 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14363_14478 = state_14259__$1;
(statearr_14363_14478[(2)] = inst_14117);

(statearr_14363_14478[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (53))){
var state_14259__$1 = state_14259;
var statearr_14364_14479 = state_14259__$1;
(statearr_14364_14479[(2)] = true);

(statearr_14364_14479[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (78))){
var inst_14192 = (state_14259[(52)]);
var state_14259__$1 = state_14259;
var statearr_14365_14480 = state_14259__$1;
(statearr_14365_14480[(2)] = inst_14192);

(statearr_14365_14480[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (26))){
var inst_14036 = (state_14259[(19)]);
var state_14259__$1 = state_14259;
var statearr_14366_14481 = state_14259__$1;
(statearr_14366_14481[(2)] = inst_14036);

(statearr_14366_14481[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (16))){
var inst_14044 = (state_14259[(58)]);
var inst_14074 = (state_14259[(2)]);
var inst_14075 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14044);
var state_14259__$1 = (function (){var statearr_14367 = state_14259;
(statearr_14367[(40)] = inst_14074);

return statearr_14367;
})();
if(inst_14075){
var statearr_14368_14482 = state_14259__$1;
(statearr_14368_14482[(1)] = (18));

} else {
var statearr_14369_14483 = state_14259__$1;
(statearr_14369_14483[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (81))){
var inst_14121 = (state_14259[(15)]);
var inst_14234 = (state_14259[(48)]);
var inst_14174 = (state_14259[(8)]);
var inst_14131 = (state_14259[(45)]);
var inst_14233 = inst_14131.call(null,inst_14174,inst_14121);
var inst_14234__$1 = (inst_14233 < (0));
var state_14259__$1 = (function (){var statearr_14370 = state_14259;
(statearr_14370[(48)] = inst_14234__$1);

return statearr_14370;
})();
if(cljs.core.truth_(inst_14234__$1)){
var statearr_14371_14484 = state_14259__$1;
(statearr_14371_14484[(1)] = (84));

} else {
var statearr_14372_14485 = state_14259__$1;
(statearr_14372_14485[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (79))){
var inst_14198 = (state_14259[(13)]);
var inst_14192 = (state_14259[(52)]);
var inst_14218 = cljs.core.disj.call(null,inst_14192,inst_14198);
var state_14259__$1 = state_14259;
var statearr_14373_14486 = state_14259__$1;
(statearr_14373_14486[(2)] = inst_14218);

(statearr_14373_14486[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (38))){
var state_14259__$1 = state_14259;
var statearr_14374_14487 = state_14259__$1;
(statearr_14374_14487[(2)] = (2147483647));

(statearr_14374_14487[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (87))){
var inst_14230 = (state_14259[(7)]);
var state_14259__$1 = state_14259;
var statearr_14375_14488 = state_14259__$1;
(statearr_14375_14488[(2)] = inst_14230);

(statearr_14375_14488[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (30))){
var inst_14097 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
if(cljs.core.truth_(inst_14097)){
var statearr_14376_14489 = state_14259__$1;
(statearr_14376_14489[(1)] = (31));

} else {
var statearr_14377_14490 = state_14259__$1;
(statearr_14377_14490[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (73))){
var inst_14226 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14378_14491 = state_14259__$1;
(statearr_14378_14491[(2)] = inst_14226);

(statearr_14378_14491[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (10))){
var inst_14042 = (state_14259[(59)]);
var inst_14059 = fluree.db.dbproto._subid.call(null,db,inst_14042);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(13),inst_14059);
} else {
if((state_val_14260 === (18))){
var inst_14044 = (state_14259[(58)]);
var inst_14077 = fluree.db.dbproto._subid.call(null,db,inst_14044);
var state_14259__$1 = state_14259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14259__$1,(21),inst_14077);
} else {
if((state_val_14260 === (52))){
var inst_14101 = (state_14259[(27)]);
var inst_14056 = (state_14259[(31)]);
var inst_14065 = (state_14259[(39)]);
var inst_14127 = (state_14259[(41)]);
var inst_14092 = (state_14259[(42)]);
var inst_14141 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_14127,inst_14056,inst_14065,inst_14092,inst_14101);
var state_14259__$1 = state_14259;
var statearr_14379_14492 = state_14259__$1;
(statearr_14379_14492[(2)] = inst_14141);

(statearr_14379_14492[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (67))){
var inst_14228 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14380_14493 = state_14259__$1;
(statearr_14380_14493[(2)] = inst_14228);

(statearr_14380_14493[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (71))){
var inst_14160 = (state_14259[(26)]);
var inst_14192 = (state_14259[(52)]);
var inst_14207 = cljs.core.into.call(null,inst_14192,inst_14160);
var state_14259__$1 = state_14259;
var statearr_14381_14494 = state_14259__$1;
(statearr_14381_14494[(2)] = inst_14207);

(statearr_14381_14494[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (42))){
var inst_14045 = (state_14259[(25)]);
var inst_14101 = (state_14259[(27)]);
var inst_14038 = (state_14259[(28)]);
var inst_14046 = (state_14259[(29)]);
var inst_14056 = (state_14259[(31)]);
var inst_14119 = (state_14259[(32)]);
var inst_14083 = (state_14259[(21)]);
var inst_14122 = (state_14259[(49)]);
var inst_14039 = (state_14259[(36)]);
var inst_14110 = (state_14259[(38)]);
var inst_14065 = (state_14259[(39)]);
var inst_14074 = (state_14259[(40)]);
var inst_14092 = (state_14259[(42)]);
var inst_14119__$1 = (state_14259[(2)]);
var inst_14120 = fluree.db.flake.__GT_Flake.call(null,inst_14056,inst_14092,inst_14074,inst_14038,inst_14039,inst_14110);
var inst_14121 = fluree.db.flake.__GT_Flake.call(null,inst_14065,inst_14101,inst_14083,inst_14045,inst_14046,inst_14119__$1);
var inst_14122__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14259__$1 = (function (){var statearr_14382 = state_14259;
(statearr_14382[(15)] = inst_14121);

(statearr_14382[(32)] = inst_14119__$1);

(statearr_14382[(49)] = inst_14122__$1);

(statearr_14382[(17)] = inst_14120);

return statearr_14382;
})();
if(cljs.core.truth_(inst_14122__$1)){
var statearr_14383_14495 = state_14259__$1;
(statearr_14383_14495[(1)] = (46));

} else {
var statearr_14384_14496 = state_14259__$1;
(statearr_14384_14496[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (80))){
var inst_14220 = (state_14259[(2)]);
var state_14259__$1 = state_14259;
var statearr_14385_14497 = state_14259__$1;
(statearr_14385_14497[(2)] = inst_14220);

(statearr_14385_14497[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (37))){
var state_14259__$1 = state_14259;
var statearr_14386_14498 = state_14259__$1;
(statearr_14386_14498[(2)] = fluree.db.util.core.min_integer);

(statearr_14386_14498[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (63))){
var inst_14173 = (state_14259[(12)]);
var inst_14160 = (state_14259[(26)]);
var inst_14159 = (state_14259[(34)]);
var inst_14126 = (state_14259[(35)]);
var inst_14176 = (inst_14126 - inst_14159);
var inst_14177 = fluree.db.flake.take.call(null,inst_14176,inst_14173);
var inst_14178 = cljs.core.into.call(null,inst_14177,inst_14160);
var state_14259__$1 = state_14259;
var statearr_14387_14499 = state_14259__$1;
(statearr_14387_14499[(2)] = inst_14178);

(statearr_14387_14499[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (8))){
var inst_14042 = (state_14259[(59)]);
var inst_14056 = (state_14259[(2)]);
var inst_14057 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14042);
var state_14259__$1 = (function (){var statearr_14388 = state_14259;
(statearr_14388[(31)] = inst_14056);

return statearr_14388;
})();
if(inst_14057){
var statearr_14389_14500 = state_14259__$1;
(statearr_14389_14500[(1)] = (10));

} else {
var statearr_14390_14501 = state_14259__$1;
(statearr_14390_14501[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (49))){
var inst_14132 = (state_14259[(51)]);
var state_14259__$1 = state_14259;
var statearr_14391_14502 = state_14259__$1;
(statearr_14391_14502[(2)] = inst_14132);

(statearr_14391_14502[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14260 === (84))){
var inst_14126 = (state_14259[(35)]);
var inst_14231 = (state_14259[(9)]);
var inst_14236 = (inst_14231 < inst_14126);
var state_14259__$1 = state_14259;
var statearr_14392_14503 = state_14259__$1;
(statearr_14392_14503[(2)] = inst_14236);

(statearr_14392_14503[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2726__auto__ = null;
var fluree$db$query$range$state_machine__2726__auto____0 = (function (){
var statearr_14393 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14393[(0)] = fluree$db$query$range$state_machine__2726__auto__);

(statearr_14393[(1)] = (1));

return statearr_14393;
});
var fluree$db$query$range$state_machine__2726__auto____1 = (function (state_14259){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_14259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e14394){var ex__2729__auto__ = e14394;
var statearr_14395_14504 = state_14259;
(statearr_14395_14504[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_14259[(4)]))){
var statearr_14396_14505 = state_14259;
(statearr_14396_14505[(1)] = cljs.core.first.call(null,(state_14259[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14506 = state_14259;
state_14259 = G__14506;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2726__auto__ = function(state_14259){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2726__auto____1.call(this,state_14259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2726__auto____0;
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2726__auto____1;
return fluree$db$query$range$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_14397 = f__2749__auto__.call(null);
(statearr_14397[(6)] = c__2748__auto__);

return statearr_14397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_14581){
var state_val_14582 = (state_14581[(1)]);
if((state_val_14582 === (7))){
var inst_14576 = (state_14581[(2)]);
var _ = (function (){var statearr_14583 = state_14581;
(statearr_14583[(4)] = cljs.core.rest.call(null,(state_14581[(4)])));

return statearr_14583;
})();
var state_14581__$1 = state_14581;
var statearr_14584_14624 = state_14581__$1;
(statearr_14584_14624[(2)] = inst_14576);

(statearr_14584_14624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (20))){
var inst_14558 = (state_14581[(2)]);
var inst_14559 = fluree.db.util.async.throw_err.call(null,inst_14558);
var state_14581__$1 = state_14581;
var statearr_14585_14625 = state_14581__$1;
(statearr_14585_14625[(2)] = inst_14559);

(statearr_14585_14625[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (1))){
var state_14581__$1 = state_14581;
var statearr_14586_14626 = state_14581__$1;
(statearr_14586_14626[(2)] = null);

(statearr_14586_14626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (4))){
var inst_14507 = (state_14581[(2)]);
var state_14581__$1 = state_14581;
var statearr_14587_14627 = state_14581__$1;
(statearr_14587_14627[(2)] = inst_14507);

(statearr_14587_14627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (15))){
var inst_14554 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14581__$1 = state_14581;
if(cljs.core.truth_(inst_14554)){
var statearr_14588_14628 = state_14581__$1;
(statearr_14588_14628[(1)] = (17));

} else {
var statearr_14589_14629 = state_14581__$1;
(statearr_14589_14629[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (21))){
var state_14581__$1 = state_14581;
var statearr_14590_14630 = state_14581__$1;
(statearr_14590_14630[(2)] = (0));

(statearr_14590_14630[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (13))){
var inst_14546 = (state_14581[(2)]);
var state_14581__$1 = state_14581;
var statearr_14591_14631 = state_14581__$1;
(statearr_14591_14631[(2)] = inst_14546);

(statearr_14591_14631[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (22))){
var state_14581__$1 = state_14581;
var statearr_14592_14632 = state_14581__$1;
(statearr_14592_14632[(2)] = (1));

(statearr_14592_14632[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (6))){
var inst_14527 = (state_14581[(7)]);
var inst_14536 = (state_14581[(8)]);
var inst_14538 = (state_14581[(9)]);
var inst_14535 = cljs.core.seq.call(null,inst_14527);
var inst_14536__$1 = cljs.core.first.call(null,inst_14535);
var inst_14537 = cljs.core.next.call(null,inst_14535);
var inst_14538__$1 = (inst_14536__$1 == null);
var state_14581__$1 = (function (){var statearr_14593 = state_14581;
(statearr_14593[(10)] = inst_14537);

(statearr_14593[(8)] = inst_14536__$1);

(statearr_14593[(9)] = inst_14538__$1);

return statearr_14593;
})();
if(cljs.core.truth_(inst_14538__$1)){
var statearr_14594_14633 = state_14581__$1;
(statearr_14594_14633[(1)] = (8));

} else {
var statearr_14595_14634 = state_14581__$1;
(statearr_14595_14634[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (17))){
var inst_14536 = (state_14581[(8)]);
var inst_14556 = fluree.db.permissions_validate.allow_flakes_QMARK_.call(null,db,inst_14536);
var state_14581__$1 = state_14581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14581__$1,(20),inst_14556);
} else {
if((state_val_14582 === (3))){
var inst_14579 = (state_14581[(2)]);
var state_14581__$1 = state_14581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14581__$1,inst_14579);
} else {
if((state_val_14582 === (12))){
var inst_14529 = (state_14581[(11)]);
var inst_14544 = (inst_14529 >= subject_limit);
var state_14581__$1 = state_14581;
var statearr_14596_14635 = state_14581__$1;
(statearr_14596_14635[(2)] = inst_14544);

(statearr_14596_14635[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (2))){
var _ = (function (){var statearr_14597 = state_14581;
(statearr_14597[(4)] = cljs.core.cons.call(null,(5),(state_14581[(4)])));

return statearr_14597;
})();
var inst_14520 = subject_groups;
var inst_14521 = cljs.core.seq.call(null,inst_14520);
var inst_14522 = cljs.core.first.call(null,inst_14521);
var inst_14523 = cljs.core.next.call(null,inst_14521);
var inst_14524 = flake_start;
var inst_14525 = subject_start;
var inst_14526 = cljs.core.PersistentVector.EMPTY;
var inst_14527 = inst_14520;
var inst_14528 = inst_14524;
var inst_14529 = inst_14525;
var inst_14530 = inst_14526;
var state_14581__$1 = (function (){var statearr_14598 = state_14581;
(statearr_14598[(11)] = inst_14529);

(statearr_14598[(12)] = inst_14528);

(statearr_14598[(13)] = inst_14522);

(statearr_14598[(7)] = inst_14527);

(statearr_14598[(14)] = inst_14523);

(statearr_14598[(15)] = inst_14530);

return statearr_14598;
})();
var statearr_14599_14636 = state_14581__$1;
(statearr_14599_14636[(2)] = null);

(statearr_14599_14636[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (23))){
var inst_14562 = (state_14581[(16)]);
var inst_14529 = (state_14581[(11)]);
var inst_14528 = (state_14581[(12)]);
var inst_14563 = (state_14581[(17)]);
var inst_14537 = (state_14581[(10)]);
var inst_14530 = (state_14581[(15)]);
var inst_14568 = (state_14581[(2)]);
var inst_14569 = (inst_14528 + inst_14563);
var inst_14570 = (inst_14529 + inst_14568);
var inst_14571 = cljs.core.into.call(null,inst_14530,inst_14562);
var inst_14527 = inst_14537;
var inst_14528__$1 = inst_14569;
var inst_14529__$1 = inst_14570;
var inst_14530__$1 = inst_14571;
var state_14581__$1 = (function (){var statearr_14600 = state_14581;
(statearr_14600[(11)] = inst_14529__$1);

(statearr_14600[(12)] = inst_14528__$1);

(statearr_14600[(7)] = inst_14527);

(statearr_14600[(15)] = inst_14530__$1);

return statearr_14600;
})();
var statearr_14601_14637 = state_14581__$1;
(statearr_14601_14637[(2)] = null);

(statearr_14601_14637[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (19))){
var inst_14562 = (state_14581[(16)]);
var inst_14563 = (state_14581[(17)]);
var inst_14562__$1 = (state_14581[(2)]);
var inst_14563__$1 = cljs.core.count.call(null,inst_14562__$1);
var inst_14564 = cljs.core._EQ_.call(null,(0),inst_14563__$1);
var state_14581__$1 = (function (){var statearr_14602 = state_14581;
(statearr_14602[(16)] = inst_14562__$1);

(statearr_14602[(17)] = inst_14563__$1);

return statearr_14602;
})();
if(inst_14564){
var statearr_14603_14638 = state_14581__$1;
(statearr_14603_14638[(1)] = (21));

} else {
var statearr_14604_14639 = state_14581__$1;
(statearr_14604_14639[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (11))){
var inst_14541 = (state_14581[(18)]);
var state_14581__$1 = state_14581;
var statearr_14606_14640 = state_14581__$1;
(statearr_14606_14640[(2)] = inst_14541);

(statearr_14606_14640[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (9))){
var inst_14528 = (state_14581[(12)]);
var inst_14541 = (state_14581[(18)]);
var inst_14541__$1 = (inst_14528 >= flake_limit);
var state_14581__$1 = (function (){var statearr_14607 = state_14581;
(statearr_14607[(18)] = inst_14541__$1);

return statearr_14607;
})();
if(cljs.core.truth_(inst_14541__$1)){
var statearr_14608_14641 = state_14581__$1;
(statearr_14608_14641[(1)] = (11));

} else {
var statearr_14609_14642 = state_14581__$1;
(statearr_14609_14642[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (5))){
var _ = (function (){var statearr_14610 = state_14581;
(statearr_14610[(4)] = cljs.core.rest.call(null,(state_14581[(4)])));

return statearr_14610;
})();
var state_14581__$1 = state_14581;
var ex14605 = (state_14581__$1[(2)]);
var statearr_14611_14643 = state_14581__$1;
(statearr_14611_14643[(5)] = ex14605);


if((ex14605 instanceof Error)){
var statearr_14612_14644 = state_14581__$1;
(statearr_14612_14644[(1)] = (4));

(statearr_14612_14644[(5)] = null);

} else {
throw ex14605;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (14))){
var inst_14529 = (state_14581[(11)]);
var inst_14528 = (state_14581[(12)]);
var inst_14530 = (state_14581[(15)]);
var inst_14550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14551 = [inst_14528,inst_14529,inst_14530];
var inst_14552 = (new cljs.core.PersistentVector(null,3,(5),inst_14550,inst_14551,null));
var state_14581__$1 = state_14581;
var statearr_14613_14645 = state_14581__$1;
(statearr_14613_14645[(2)] = inst_14552);

(statearr_14613_14645[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (16))){
var inst_14574 = (state_14581[(2)]);
var state_14581__$1 = state_14581;
var statearr_14614_14646 = state_14581__$1;
(statearr_14614_14646[(2)] = inst_14574);

(statearr_14614_14646[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (10))){
var inst_14548 = (state_14581[(2)]);
var state_14581__$1 = state_14581;
if(cljs.core.truth_(inst_14548)){
var statearr_14615_14647 = state_14581__$1;
(statearr_14615_14647[(1)] = (14));

} else {
var statearr_14616_14648 = state_14581__$1;
(statearr_14616_14648[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (18))){
var inst_14536 = (state_14581[(8)]);
var state_14581__$1 = state_14581;
var statearr_14617_14649 = state_14581__$1;
(statearr_14617_14649[(2)] = inst_14536);

(statearr_14617_14649[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14582 === (8))){
var inst_14538 = (state_14581[(9)]);
var state_14581__$1 = state_14581;
var statearr_14618_14650 = state_14581__$1;
(statearr_14618_14650[(2)] = inst_14538);

(statearr_14618_14650[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto____0 = (function (){
var statearr_14619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14619[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto__);

(statearr_14619[(1)] = (1));

return statearr_14619;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto____1 = (function (state_14581){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_14581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e14620){var ex__2729__auto__ = e14620;
var statearr_14621_14651 = state_14581;
(statearr_14621_14651[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_14581[(4)]))){
var statearr_14622_14652 = state_14581;
(statearr_14622_14652[(1)] = cljs.core.first.call(null,(state_14581[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14653 = state_14581;
state_14581 = G__14653;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto__ = function(state_14581){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto____1.call(this,state_14581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_14623 = f__2749__auto__.call(null);
(statearr_14623[(6)] = c__2748__auto__);

return statearr_14623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_14699){
var state_val_14700 = (state_14699[(1)]);
if((state_val_14700 === (7))){
var state_14699__$1 = state_14699;
var statearr_14701_14739 = state_14699__$1;
(statearr_14701_14739[(2)] = null);

(statearr_14701_14739[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (20))){
var inst_14685 = (state_14699[(2)]);
var inst_14686 = fluree.db.util.async.throw_err.call(null,inst_14685);
var inst_14664 = inst_14686;
var state_14699__$1 = (function (){var statearr_14702 = state_14699;
(statearr_14702[(7)] = inst_14664);

return statearr_14702;
})();
var statearr_14703_14740 = state_14699__$1;
(statearr_14703_14740[(2)] = null);

(statearr_14703_14740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (1))){
var state_14699__$1 = state_14699;
var statearr_14704_14741 = state_14699__$1;
(statearr_14704_14741[(2)] = null);

(statearr_14704_14741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (4))){
var inst_14654 = (state_14699[(2)]);
var state_14699__$1 = state_14699;
var statearr_14705_14742 = state_14699__$1;
(statearr_14705_14742[(2)] = inst_14654);

(statearr_14705_14742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (15))){
var inst_14681 = (state_14699[(8)]);
var inst_14664 = (state_14699[(7)]);
var inst_14681__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14664);
var state_14699__$1 = (function (){var statearr_14706 = state_14699;
(statearr_14706[(8)] = inst_14681__$1);

return statearr_14706;
})();
if(cljs.core.truth_(inst_14681__$1)){
var statearr_14707_14743 = state_14699__$1;
(statearr_14707_14743[(1)] = (17));

} else {
var statearr_14708_14744 = state_14699__$1;
(statearr_14708_14744[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (13))){
var inst_14674 = (state_14699[(2)]);
var inst_14675 = fluree.db.util.async.throw_err.call(null,inst_14674);
var _ = (function (){var statearr_14709 = state_14699;
(statearr_14709[(4)] = cljs.core.rest.call(null,(state_14699[(4)])));

return statearr_14709;
})();
var state_14699__$1 = state_14699;
var statearr_14710_14745 = state_14699__$1;
(statearr_14710_14745[(2)] = inst_14675);

(statearr_14710_14745[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (6))){
var inst_14662 = (state_14699[(2)]);
var inst_14663 = fluree.db.util.async.throw_err.call(null,inst_14662);
var inst_14664 = inst_14663;
var state_14699__$1 = (function (){var statearr_14711 = state_14699;
(statearr_14711[(7)] = inst_14664);

return statearr_14711;
})();
var statearr_14712_14746 = state_14699__$1;
(statearr_14712_14746[(2)] = null);

(statearr_14712_14746[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (17))){
var inst_14681 = (state_14699[(8)]);
var inst_14683 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_14681);
var state_14699__$1 = state_14699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14699__$1,(20),inst_14683);
} else {
if((state_val_14700 === (3))){
var inst_14697 = (state_14699[(2)]);
var state_14699__$1 = state_14699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14699__$1,inst_14697);
} else {
if((state_val_14700 === (12))){
var _ = (function (){var statearr_14714 = state_14699;
(statearr_14714[(4)] = cljs.core.rest.call(null,(state_14699[(4)])));

return statearr_14714;
})();
var state_14699__$1 = state_14699;
var ex14713 = (state_14699__$1[(2)]);
var statearr_14715_14747 = state_14699__$1;
(statearr_14715_14747[(5)] = ex14713);


var statearr_14716_14748 = state_14699__$1;
(statearr_14716_14748[(1)] = (11));

(statearr_14716_14748[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (2))){
var _ = (function (){var statearr_14717 = state_14699;
(statearr_14717[(4)] = cljs.core.cons.call(null,(5),(state_14699[(4)])));

return statearr_14717;
})();
var inst_14660 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_14699__$1 = state_14699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14699__$1,(6),inst_14660);
} else {
if((state_val_14700 === (19))){
var inst_14690 = (state_14699[(2)]);
var state_14699__$1 = state_14699;
var statearr_14718_14749 = state_14699__$1;
(statearr_14718_14749[(2)] = inst_14690);

(statearr_14718_14749[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (11))){
var inst_14666 = (state_14699[(2)]);
var state_14699__$1 = (function (){var statearr_14720 = state_14699;
(statearr_14720[(9)] = inst_14666);

return statearr_14720;
})();
var statearr_14721_14750 = state_14699__$1;
(statearr_14721_14750[(2)] = null);

(statearr_14721_14750[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (9))){
var inst_14664 = (state_14699[(7)]);
var _ = (function (){var statearr_14722 = state_14699;
(statearr_14722[(4)] = cljs.core.cons.call(null,(12),(state_14699[(4)])));

return statearr_14722;
})();
var inst_14672 = fluree.db.dbproto._resolve_to_t.call(null,inst_14664,t,novelty,fast_forward_db_QMARK_);
var state_14699__$1 = state_14699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14699__$1,(13),inst_14672);
} else {
if((state_val_14700 === (5))){
var _ = (function (){var statearr_14723 = state_14699;
(statearr_14723[(4)] = cljs.core.rest.call(null,(state_14699[(4)])));

return statearr_14723;
})();
var state_14699__$1 = state_14699;
var ex14719 = (state_14699__$1[(2)]);
var statearr_14724_14751 = state_14699__$1;
(statearr_14724_14751[(5)] = ex14719);


if((ex14719 instanceof Error)){
var statearr_14725_14752 = state_14699__$1;
(statearr_14725_14752[(1)] = (4));

(statearr_14725_14752[(5)] = null);

} else {
throw ex14719;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (14))){
var inst_14678 = (state_14699[(10)]);
var state_14699__$1 = state_14699;
var statearr_14726_14753 = state_14699__$1;
(statearr_14726_14753[(2)] = inst_14678);

(statearr_14726_14753[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (16))){
var inst_14692 = (state_14699[(2)]);
var state_14699__$1 = state_14699;
var statearr_14727_14754 = state_14699__$1;
(statearr_14727_14754[(2)] = inst_14692);

(statearr_14727_14754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (10))){
var inst_14678 = (state_14699[(10)]);
var inst_14678__$1 = (state_14699[(2)]);
var state_14699__$1 = (function (){var statearr_14728 = state_14699;
(statearr_14728[(10)] = inst_14678__$1);

return statearr_14728;
})();
if(cljs.core.truth_(inst_14678__$1)){
var statearr_14729_14755 = state_14699__$1;
(statearr_14729_14755[(1)] = (14));

} else {
var statearr_14730_14756 = state_14699__$1;
(statearr_14730_14756[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (18))){
var state_14699__$1 = state_14699;
var statearr_14731_14757 = state_14699__$1;
(statearr_14731_14757[(2)] = null);

(statearr_14731_14757[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14700 === (8))){
var inst_14694 = (state_14699[(2)]);
var _ = (function (){var statearr_14732 = state_14699;
(statearr_14732[(4)] = cljs.core.rest.call(null,(state_14699[(4)])));

return statearr_14732;
})();
var state_14699__$1 = state_14699;
var statearr_14733_14758 = state_14699__$1;
(statearr_14733_14758[(2)] = inst_14694);

(statearr_14733_14758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto____0 = (function (){
var statearr_14734 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14734[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto__);

(statearr_14734[(1)] = (1));

return statearr_14734;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto____1 = (function (state_14699){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_14699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e14735){var ex__2729__auto__ = e14735;
var statearr_14736_14759 = state_14699;
(statearr_14736_14759[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_14699[(4)]))){
var statearr_14737_14760 = state_14699;
(statearr_14737_14760[(1)] = cljs.core.first.call(null,(state_14699[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14761 = state_14699;
state_14699 = G__14761;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto__ = function(state_14699){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto____1.call(this,state_14699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_14738 = f__2749__auto__.call(null);
(statearr_14738[(6)] = c__2748__auto__);

return statearr_14738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14768 = arguments.length;
switch (G__14768) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14769 = (function (){var pred__14772 = cljs.core.identical_QMARK_;
var expr__14773 = test;
if(cljs.core.truth_(pred__14772.call(null,cljs.core._EQ_,expr__14773))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14772.call(null,cljs.core._LT_,expr__14773))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14772.call(null,cljs.core._LT__EQ_,expr__14773))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14772.call(null,cljs.core._GT_,expr__14773))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14772.call(null,cljs.core._GT__EQ_,expr__14773))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14773)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__14769,(0),null);
var start_match = cljs.core.nth.call(null,vec__14769,(1),null);
var end_test = cljs.core.nth.call(null,vec__14769,(2),null);
var end_match = cljs.core.nth.call(null,vec__14769,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_15145){
var state_val_15146 = (state_15145[(1)]);
if((state_val_15146 === (121))){
var inst_15101 = (state_15145[(7)]);
var state_15145__$1 = state_15145;
var statearr_15147_15340 = state_15145__$1;
(statearr_15147_15340[(2)] = inst_15101);

(statearr_15147_15340[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (65))){
var inst_14953 = (state_15145[(8)]);
var inst_14959 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15148 = state_15145;
(statearr_15148[(9)] = inst_14959);

return statearr_15148;
})();
if(cljs.core.truth_(inst_14953)){
var statearr_15149_15341 = state_15145__$1;
(statearr_15149_15341[(1)] = (66));

} else {
var statearr_15150_15342 = state_15145__$1;
(statearr_15150_15342[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (70))){
var inst_15137 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15151_15343 = state_15145__$1;
(statearr_15151_15343[(2)] = inst_15137);

(statearr_15151_15343[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (62))){
var inst_14952 = (state_15145[(2)]);
var inst_14953 = fluree.db.util.async.throw_err.call(null,inst_14952);
var inst_14954 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15145__$1 = (function (){var statearr_15152 = state_15145;
(statearr_15152[(8)] = inst_14953);

return statearr_15152;
})();
if(cljs.core.truth_(inst_14954)){
var statearr_15153_15344 = state_15145__$1;
(statearr_15153_15344[(1)] = (63));

} else {
var statearr_15154_15345 = state_15145__$1;
(statearr_15154_15345[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (74))){
var inst_14966 = (state_15145[(10)]);
var inst_14962 = (state_15145[(11)]);
var inst_14943 = (state_15145[(12)]);
var inst_14939 = (state_15145[(13)]);
var inst_14963 = (state_15145[(14)]);
var inst_14903 = (state_15145[(15)]);
var inst_14949 = (state_15145[(16)]);
var inst_14932 = (state_15145[(17)]);
var inst_14925 = (state_15145[(18)]);
var inst_14867 = (state_15145[(19)]);
var inst_14864 = (state_15145[(20)]);
var inst_14831 = (state_15145[(21)]);
var inst_14972 = (state_15145[(22)]);
var inst_14964 = (state_15145[(23)]);
var inst_14812 = (state_15145[(24)]);
var inst_14944 = (state_15145[(25)]);
var inst_14938 = (state_15145[(26)]);
var inst_14799 = (state_15145[(27)]);
var inst_14795 = (state_15145[(28)]);
var inst_14802 = (state_15145[(29)]);
var inst_14912 = (state_15145[(30)]);
var inst_14810 = (state_15145[(31)]);
var inst_14980 = (state_15145[(32)]);
var inst_14933 = (state_15145[(33)]);
var inst_14926 = (state_15145[(34)]);
var inst_14923 = (state_15145[(35)]);
var inst_14811 = (state_15145[(36)]);
var inst_14863 = (state_15145[(37)]);
var inst_14822 = (state_15145[(38)]);
var inst_14806 = (state_15145[(39)]);
var inst_14885 = (state_15145[(40)]);
var inst_14934 = (state_15145[(41)]);
var inst_14953 = (state_15145[(8)]);
var inst_14807 = (state_15145[(42)]);
var inst_14800 = (state_15145[(43)]);
var inst_14921 = (state_15145[(44)]);
var inst_14965 = (state_15145[(45)]);
var inst_14959 = (state_15145[(9)]);
var inst_14876 = (state_15145[(46)]);
var inst_14894 = (state_15145[(47)]);
var inst_14922 = (state_15145[(48)]);
var inst_14982 = (function (){var no_filter_QMARK_ = inst_14959;
var t = inst_14939;
var max_limit_QMARK_ = inst_14933;
var next_node = inst_14962;
var fast_forward_db_QMARK_ = inst_14944;
var s1 = inst_14822;
var o2 = inst_14885;
var t1 = inst_14799;
var predicate_fn = inst_14812;
var i = inst_14964;
var vec__14791 = inst_14864;
var m1 = inst_14912;
var root_node = inst_14949;
var s2 = inst_14831;
var p2 = inst_14903;
var permissions = inst_14934;
var limit = inst_14932;
var map__14794 = inst_14925;
var start_flake = inst_14922;
var vec__14788 = inst_14863;
var flake_limit = inst_14926;
var offset = inst_14963;
var acc = inst_14966;
var vec__14784 = inst_14802;
var t2 = inst_14806;
var G__14973 = inst_14980;
var op1 = inst_14800;
var o1 = inst_14876;
var end_flake = inst_14923;
var map__14787 = inst_14810;
var base_result = inst_14972;
var s = inst_14965;
var node_start = inst_14953;
var p1 = inst_14894;
var subject_fn = inst_14811;
var vec__14781 = inst_14795;
var object_fn = inst_14867;
var idx_compare = inst_14938;
var op2 = inst_14807;
var m2 = inst_14921;
var novelty = inst_14943;
return (function (p1__14763_SHARP_){
return subject_fn.call(null,p1__14763_SHARP_.s);
});
})();
var inst_14983 = cljs.core.filter.call(null,inst_14982,inst_14980);
var state_15145__$1 = state_15145;
var statearr_15155_15346 = state_15145__$1;
(statearr_15155_15346[(2)] = inst_14983);

(statearr_15155_15346[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (110))){
var inst_15114 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15156_15347 = state_15145__$1;
(statearr_15156_15347[(2)] = inst_15114);

(statearr_15156_15347[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (7))){
var inst_14796 = (state_15145[(49)]);
var state_15145__$1 = state_15145;
var statearr_15157_15348 = state_15145__$1;
(statearr_15157_15348[(2)] = inst_14796);

(statearr_15157_15348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (59))){
var state_15145__$1 = state_15145;
var statearr_15158_15349 = state_15145__$1;
(statearr_15158_15349[(2)] = fluree.db.util.core.max_long);

(statearr_15158_15349[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (86))){
var inst_14959 = (state_15145[(9)]);
var state_15145__$1 = state_15145;
var statearr_15159_15350 = state_15145__$1;
(statearr_15159_15350[(2)] = inst_14959);

(statearr_15159_15350[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (20))){
var state_15145__$1 = state_15145;
var statearr_15160_15351 = state_15145__$1;
(statearr_15160_15351[(2)] = null);

(statearr_15160_15351[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (72))){
var inst_14972 = (state_15145[(22)]);
var state_15145__$1 = state_15145;
var statearr_15161_15352 = state_15145__$1;
(statearr_15161_15352[(2)] = inst_14972);

(statearr_15161_15352[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (58))){
var inst_14927 = (state_15145[(50)]);
var state_15145__$1 = state_15145;
var statearr_15162_15353 = state_15145__$1;
(statearr_15162_15353[(2)] = inst_14927);

(statearr_15162_15353[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (60))){
var inst_14932 = (state_15145[(17)]);
var inst_14932__$1 = (state_15145[(2)]);
var inst_14933 = cljs.core._EQ_.call(null,inst_14932__$1,fluree.db.util.core.max_long);
var inst_14934 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14936 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14937 = (new cljs.core.PersistentVector(null,3,(5),inst_14935,inst_14936,null));
var inst_14938 = cljs.core.get_in.call(null,db,inst_14937);
var inst_14939 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14941 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14942 = (new cljs.core.PersistentVector(null,2,(5),inst_14940,inst_14941,null));
var inst_14943 = cljs.core.get_in.call(null,db,inst_14942);
var inst_14944 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14945 = cljs.core.get.call(null,db,idx);
var inst_14946 = fluree.db.dbproto._resolve.call(null,inst_14945);
var state_15145__$1 = (function (){var statearr_15163 = state_15145;
(statearr_15163[(12)] = inst_14943);

(statearr_15163[(13)] = inst_14939);

(statearr_15163[(17)] = inst_14932__$1);

(statearr_15163[(25)] = inst_14944);

(statearr_15163[(26)] = inst_14938);

(statearr_15163[(33)] = inst_14933);

(statearr_15163[(41)] = inst_14934);

return statearr_15163;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(61),inst_14946);
} else {
if((state_val_15146 === (27))){
var inst_14865 = (state_15145[(51)]);
var state_15145__$1 = state_15145;
var statearr_15164_15354 = state_15145__$1;
(statearr_15164_15354[(2)] = inst_14865);

(statearr_15164_15354[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (1))){
var state_15145__$1 = state_15145;
var statearr_15165_15355 = state_15145__$1;
(statearr_15165_15355[(2)] = null);

(statearr_15165_15355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (69))){
var inst_14962 = (state_15145[(11)]);
var inst_14923 = (state_15145[(35)]);
var inst_14922 = (state_15145[(48)]);
var inst_14971 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14962);
var inst_14972 = fluree.db.flake.subrange.call(null,inst_14971,start_test,inst_14922,end_test,inst_14923);
var inst_14974 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_14922,inst_14923);
var state_15145__$1 = (function (){var statearr_15166 = state_15145;
(statearr_15166[(22)] = inst_14972);

return statearr_15166;
})();
if(inst_14974){
var statearr_15167_15356 = state_15145__$1;
(statearr_15167_15356[(1)] = (71));

} else {
var statearr_15168_15357 = state_15145__$1;
(statearr_15168_15357[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (101))){
var inst_15060 = (state_15145[(52)]);
var inst_15059 = (state_15145[(53)]);
var inst_15058 = (state_15145[(54)]);
var inst_14926 = (state_15145[(34)]);
var inst_15063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15064 = (inst_15060 - inst_14926);
var inst_15065 = (inst_15059 - inst_15064);
var inst_15066 = cljs.core.take.call(null,inst_15065,inst_15058);
var inst_15067 = [inst_14926,inst_15066];
var inst_15068 = (new cljs.core.PersistentVector(null,2,(5),inst_15063,inst_15067,null));
var state_15145__$1 = state_15145;
var statearr_15169_15358 = state_15145__$1;
(statearr_15169_15358[(2)] = inst_15068);

(statearr_15169_15358[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (24))){
var inst_14813 = (state_15145[(55)]);
var inst_14797 = (state_15145[(56)]);
var inst_14801 = (state_15145[(57)]);
var inst_14831 = (state_15145[(21)]);
var inst_14804 = (state_15145[(58)]);
var inst_14845 = (state_15145[(59)]);
var inst_14805 = (state_15145[(60)]);
var inst_14808 = (state_15145[(61)]);
var inst_14812 = (state_15145[(24)]);
var inst_14799 = (state_15145[(27)]);
var inst_14795 = (state_15145[(28)]);
var inst_14802 = (state_15145[(29)]);
var inst_14810 = (state_15145[(31)]);
var inst_14811 = (state_15145[(36)]);
var inst_14822 = (state_15145[(38)]);
var inst_14806 = (state_15145[(39)]);
var inst_14807 = (state_15145[(42)]);
var inst_14800 = (state_15145[(43)]);
var inst_14798 = (state_15145[(62)]);
var inst_14855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14857 = [null,null];
var inst_14858 = (new cljs.core.PersistentVector(null,2,(5),inst_14856,inst_14857,null));
var inst_14859 = (function (){var bool = inst_14845;
var s1 = inst_14822;
var o2 = inst_14805;
var t1 = inst_14799;
var predicate_fn = inst_14812;
var m1 = inst_14801;
var s2 = inst_14831;
var p2 = inst_14804;
var vec__14784 = inst_14802;
var t2 = inst_14806;
var op1 = inst_14800;
var o1 = inst_14798;
var map__14787 = inst_14810;
var p1 = inst_14797;
var subject_fn = inst_14811;
var vec__14781 = inst_14795;
var object_fn = inst_14813;
var op2 = inst_14807;
var m2 = inst_14808;
var temp__5755__auto__ = inst_14845;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_14860 = [inst_14858,inst_14859];
var inst_14861 = (new cljs.core.PersistentVector(null,2,(5),inst_14855,inst_14860,null));
var state_15145__$1 = state_15145;
var statearr_15170_15359 = state_15145__$1;
(statearr_15170_15359[(2)] = inst_14861);

(statearr_15170_15359[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (102))){
var inst_15060 = (state_15145[(52)]);
var inst_15058 = (state_15145[(54)]);
var inst_15070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15071 = [inst_15060,inst_15058];
var inst_15072 = (new cljs.core.PersistentVector(null,2,(5),inst_15070,inst_15071,null));
var state_15145__$1 = state_15145;
var statearr_15171_15360 = state_15145__$1;
(statearr_15171_15360[(2)] = inst_15072);

(statearr_15171_15360[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (55))){
var state_15145__$1 = state_15145;
var statearr_15172_15361 = state_15145__$1;
(statearr_15172_15361[(2)] = (2147483647));

(statearr_15172_15361[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (85))){
var inst_15008 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
if(cljs.core.truth_(inst_15008)){
var statearr_15173_15362 = state_15145__$1;
(statearr_15173_15362[(1)] = (89));

} else {
var statearr_15174_15363 = state_15145__$1;
(statearr_15174_15363[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (39))){
var inst_14804 = (state_15145[(58)]);
var inst_14895 = (state_15145[(63)]);
var inst_14894 = (state_15145[(2)]);
var inst_14895__$1 = (inst_14804 == null);
var state_15145__$1 = (function (){var statearr_15175 = state_15145;
(statearr_15175[(63)] = inst_14895__$1);

(statearr_15175[(47)] = inst_14894);

return statearr_15175;
})();
if(cljs.core.truth_(inst_14895__$1)){
var statearr_15176_15364 = state_15145__$1;
(statearr_15176_15364[(1)] = (40));

} else {
var statearr_15177_15365 = state_15145__$1;
(statearr_15177_15365[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (88))){
var inst_15005 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15178_15366 = state_15145__$1;
(statearr_15178_15366[(2)] = inst_15005);

(statearr_15178_15366[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (46))){
var inst_14801 = (state_15145[(57)]);
var state_15145__$1 = state_15145;
var statearr_15179_15367 = state_15145__$1;
(statearr_15179_15367[(2)] = inst_14801);

(statearr_15179_15367[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (4))){
var inst_14775 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15180_15368 = state_15145__$1;
(statearr_15180_15368[(2)] = inst_14775);

(statearr_15180_15368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (77))){
var inst_14966 = (state_15145[(10)]);
var inst_14962 = (state_15145[(11)]);
var inst_14943 = (state_15145[(12)]);
var inst_14939 = (state_15145[(13)]);
var inst_14963 = (state_15145[(14)]);
var inst_14903 = (state_15145[(15)]);
var inst_14949 = (state_15145[(16)]);
var inst_14932 = (state_15145[(17)]);
var inst_14925 = (state_15145[(18)]);
var inst_14867 = (state_15145[(19)]);
var inst_14864 = (state_15145[(20)]);
var inst_14831 = (state_15145[(21)]);
var inst_14972 = (state_15145[(22)]);
var inst_14964 = (state_15145[(23)]);
var inst_14812 = (state_15145[(24)]);
var inst_14944 = (state_15145[(25)]);
var inst_14938 = (state_15145[(26)]);
var inst_14799 = (state_15145[(27)]);
var inst_14795 = (state_15145[(28)]);
var inst_14802 = (state_15145[(29)]);
var inst_14912 = (state_15145[(30)]);
var inst_14810 = (state_15145[(31)]);
var inst_14933 = (state_15145[(33)]);
var inst_14926 = (state_15145[(34)]);
var inst_14923 = (state_15145[(35)]);
var inst_14811 = (state_15145[(36)]);
var inst_14863 = (state_15145[(37)]);
var inst_14822 = (state_15145[(38)]);
var inst_14806 = (state_15145[(39)]);
var inst_14986 = (state_15145[(64)]);
var inst_14885 = (state_15145[(40)]);
var inst_14934 = (state_15145[(41)]);
var inst_14953 = (state_15145[(8)]);
var inst_14807 = (state_15145[(42)]);
var inst_14800 = (state_15145[(43)]);
var inst_14921 = (state_15145[(44)]);
var inst_14965 = (state_15145[(45)]);
var inst_14959 = (state_15145[(9)]);
var inst_14876 = (state_15145[(46)]);
var inst_14894 = (state_15145[(47)]);
var inst_14922 = (state_15145[(48)]);
var inst_14988 = (function (){var no_filter_QMARK_ = inst_14959;
var t = inst_14939;
var max_limit_QMARK_ = inst_14933;
var next_node = inst_14962;
var fast_forward_db_QMARK_ = inst_14944;
var s1 = inst_14822;
var o2 = inst_14885;
var t1 = inst_14799;
var predicate_fn = inst_14812;
var i = inst_14964;
var vec__14791 = inst_14864;
var m1 = inst_14912;
var root_node = inst_14949;
var s2 = inst_14831;
var p2 = inst_14903;
var permissions = inst_14934;
var limit = inst_14932;
var map__14794 = inst_14925;
var start_flake = inst_14922;
var vec__14788 = inst_14863;
var flake_limit = inst_14926;
var offset = inst_14963;
var acc = inst_14966;
var vec__14784 = inst_14802;
var t2 = inst_14806;
var G__14973 = inst_14986;
var op1 = inst_14800;
var o1 = inst_14876;
var end_flake = inst_14923;
var map__14787 = inst_14810;
var base_result = inst_14972;
var s = inst_14965;
var node_start = inst_14953;
var p1 = inst_14894;
var subject_fn = inst_14811;
var vec__14781 = inst_14795;
var object_fn = inst_14867;
var idx_compare = inst_14938;
var op2 = inst_14807;
var m2 = inst_14921;
var novelty = inst_14943;
return (function (p1__14764_SHARP_){
return predicate_fn.call(null,p1__14764_SHARP_.p);
});
})();
var inst_14989 = cljs.core.filter.call(null,inst_14988,inst_14986);
var state_15145__$1 = state_15145;
var statearr_15181_15369 = state_15145__$1;
(statearr_15181_15369[(2)] = inst_14989);

(statearr_15181_15369[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (106))){
var inst_14999 = (state_15145[(65)]);
var state_15145__$1 = state_15145;
var statearr_15182_15370 = state_15145__$1;
(statearr_15182_15370[(2)] = inst_14999);

(statearr_15182_15370[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (119))){
var inst_15117 = (state_15145[(66)]);
var state_15145__$1 = state_15145;
var statearr_15183_15371 = state_15145__$1;
(statearr_15183_15371[(2)] = inst_15117);

(statearr_15183_15371[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (95))){
var inst_15040 = (state_15145[(67)]);
var inst_14932 = (state_15145[(17)]);
var inst_15042 = (state_15145[(68)]);
var inst_15032 = (state_15145[(69)]);
var inst_14965 = (state_15145[(45)]);
var inst_15041 = (state_15145[(70)]);
var inst_15040__$1 = cljs.core.count.call(null,inst_15032);
var inst_15041__$1 = (inst_14965 + inst_15040__$1);
var inst_15042__$1 = (inst_15041__$1 - inst_14932);
var inst_15043 = cljs.core.pos_int_QMARK_.call(null,inst_15042__$1);
var state_15145__$1 = (function (){var statearr_15184 = state_15145;
(statearr_15184[(67)] = inst_15040__$1);

(statearr_15184[(68)] = inst_15042__$1);

(statearr_15184[(70)] = inst_15041__$1);

return statearr_15184;
})();
if(inst_15043){
var statearr_15185_15372 = state_15145__$1;
(statearr_15185_15372[(1)] = (98));

} else {
var statearr_15186_15373 = state_15145__$1;
(statearr_15186_15373[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (54))){
var inst_14903 = (state_15145[(15)]);
var inst_14925 = (state_15145[(18)]);
var inst_14831 = (state_15145[(21)]);
var inst_14799 = (state_15145[(27)]);
var inst_14912 = (state_15145[(30)]);
var inst_14822 = (state_15145[(38)]);
var inst_14806 = (state_15145[(39)]);
var inst_14885 = (state_15145[(40)]);
var inst_14807 = (state_15145[(42)]);
var inst_14800 = (state_15145[(43)]);
var inst_14921 = (state_15145[(44)]);
var inst_14876 = (state_15145[(46)]);
var inst_14894 = (state_15145[(47)]);
var inst_14927 = (state_15145[(50)]);
var inst_14921__$1 = (state_15145[(2)]);
var inst_14922 = fluree.db.flake.__GT_Flake.call(null,inst_14822,inst_14894,inst_14876,inst_14799,inst_14800,inst_14912);
var inst_14923 = fluree.db.flake.__GT_Flake.call(null,inst_14831,inst_14903,inst_14885,inst_14806,inst_14807,inst_14921__$1);
var inst_14924 = opts;
var inst_14925__$1 = cljs.core.__destructure_map.call(null,inst_14924);
var inst_14926 = cljs.core.get.call(null,inst_14925__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14927__$1 = cljs.core.get.call(null,inst_14925__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14928 = cljs.core.get.call(null,inst_14925__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_15145__$1 = (function (){var statearr_15187 = state_15145;
(statearr_15187[(18)] = inst_14925__$1);

(statearr_15187[(34)] = inst_14926);

(statearr_15187[(35)] = inst_14923);

(statearr_15187[(71)] = inst_14928);

(statearr_15187[(44)] = inst_14921__$1);

(statearr_15187[(48)] = inst_14922);

(statearr_15187[(50)] = inst_14927__$1);

return statearr_15187;
})();
if(cljs.core.truth_(inst_14927__$1)){
var statearr_15188_15374 = state_15145__$1;
(statearr_15188_15374[(1)] = (58));

} else {
var statearr_15189_15375 = state_15145__$1;
(statearr_15189_15375[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (92))){
var inst_14966 = (state_15145[(10)]);
var inst_14963 = (state_15145[(14)]);
var inst_15021 = (state_15145[(72)]);
var inst_14964 = (state_15145[(23)]);
var inst_14965 = (state_15145[(45)]);
var inst_15024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15025 = (inst_14963 - inst_15021);
var inst_15026 = [inst_15025,inst_14964,inst_14965,inst_14966];
var inst_15027 = (new cljs.core.PersistentVector(null,4,(5),inst_15024,inst_15026,null));
var state_15145__$1 = state_15145;
var statearr_15190_15376 = state_15145__$1;
(statearr_15190_15376[(2)] = inst_15027);

(statearr_15190_15376[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (104))){
var inst_15083 = (state_15145[(2)]);
var inst_15084 = fluree.db.util.async.throw_err.call(null,inst_15083);
var state_15145__$1 = state_15145;
var statearr_15191_15377 = state_15145__$1;
(statearr_15191_15377[(2)] = inst_15084);

(statearr_15191_15377[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (15))){
var inst_14805 = (state_15145[(60)]);
var inst_14835 = cljs.core.boolean_QMARK_.call(null,inst_14805);
var state_15145__$1 = state_15145;
if(inst_14835){
var statearr_15192_15378 = state_15145__$1;
(statearr_15192_15378[(1)] = (17));

} else {
var statearr_15193_15379 = state_15145__$1;
(statearr_15193_15379[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (48))){
var inst_14808 = (state_15145[(61)]);
var inst_14912 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15194 = state_15145;
(statearr_15194[(30)] = inst_14912);

return statearr_15194;
})();
if(cljs.core.truth_(inst_14808)){
var statearr_15195_15380 = state_15145__$1;
(statearr_15195_15380[(1)] = (52));

} else {
var statearr_15196_15381 = state_15145__$1;
(statearr_15196_15381[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (50))){
var state_15145__$1 = state_15145;
var statearr_15197_15382 = state_15145__$1;
(statearr_15197_15382[(2)] = (2147483647));

(statearr_15197_15382[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (116))){
var inst_15117 = (state_15145[(66)]);
var inst_15125 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15198 = state_15145;
(statearr_15198[(73)] = inst_15125);

return statearr_15198;
})();
if(cljs.core.truth_(inst_15117)){
var statearr_15199_15383 = state_15145__$1;
(statearr_15199_15383[(1)] = (118));

} else {
var statearr_15200_15384 = state_15145__$1;
(statearr_15200_15384[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (75))){
var inst_14980 = (state_15145[(32)]);
var state_15145__$1 = state_15145;
var statearr_15201_15385 = state_15145__$1;
(statearr_15201_15385[(2)] = inst_14980);

(statearr_15201_15385[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (99))){
var inst_15041 = (state_15145[(70)]);
var inst_15050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15051 = [inst_15041,inst_15041];
var inst_15052 = (new cljs.core.PersistentVector(null,2,(5),inst_15050,inst_15051,null));
var state_15145__$1 = state_15145;
var statearr_15202_15386 = state_15145__$1;
(statearr_15202_15386[(2)] = inst_15052);

(statearr_15202_15386[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (21))){
var state_15145__$1 = state_15145;
var statearr_15203_15387 = state_15145__$1;
(statearr_15203_15387[(2)] = null);

(statearr_15203_15387[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (31))){
var inst_14866 = (state_15145[(74)]);
var state_15145__$1 = state_15145;
var statearr_15204_15388 = state_15145__$1;
(statearr_15204_15388[(2)] = inst_14866);

(statearr_15204_15388[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (113))){
var inst_15111 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15205_15389 = state_15145__$1;
(statearr_15205_15389[(2)] = inst_15111);

(statearr_15205_15389[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (32))){
var inst_14886 = (state_15145[(75)]);
var inst_14797 = (state_15145[(56)]);
var inst_14885 = (state_15145[(2)]);
var inst_14886__$1 = (inst_14797 == null);
var state_15145__$1 = (function (){var statearr_15206 = state_15145;
(statearr_15206[(75)] = inst_14886__$1);

(statearr_15206[(40)] = inst_14885);

return statearr_15206;
})();
if(cljs.core.truth_(inst_14886__$1)){
var statearr_15207_15390 = state_15145__$1;
(statearr_15207_15390[(1)] = (34));

} else {
var statearr_15208_15391 = state_15145__$1;
(statearr_15208_15391[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (40))){
var inst_14885 = (state_15145[(40)]);
var state_15145__$1 = state_15145;
var statearr_15209_15392 = state_15145__$1;
(statearr_15209_15392[(2)] = inst_14885);

(statearr_15209_15392[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (91))){
var inst_14999 = (state_15145[(65)]);
var inst_15097 = (state_15145[(2)]);
var inst_15098 = cljs.core.nth.call(null,inst_15097,(0),null);
var inst_15099 = cljs.core.nth.call(null,inst_15097,(1),null);
var inst_15100 = cljs.core.nth.call(null,inst_15097,(2),null);
var inst_15101 = cljs.core.nth.call(null,inst_15097,(3),null);
var state_15145__$1 = (function (){var statearr_15210 = state_15145;
(statearr_15210[(76)] = inst_15099);

(statearr_15210[(77)] = inst_15100);

(statearr_15210[(7)] = inst_15101);

(statearr_15210[(78)] = inst_15098);

return statearr_15210;
})();
if(cljs.core.truth_(inst_14999)){
var statearr_15211_15393 = state_15145__$1;
(statearr_15211_15393[(1)] = (105));

} else {
var statearr_15212_15394 = state_15145__$1;
(statearr_15212_15394[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (117))){
var inst_15121 = (state_15145[(2)]);
var inst_15122 = fluree.db.util.async.throw_err.call(null,inst_15121);
var state_15145__$1 = state_15145;
var statearr_15213_15395 = state_15145__$1;
(statearr_15213_15395[(2)] = inst_15122);

(statearr_15213_15395[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (108))){
var inst_15106 = (state_15145[(79)]);
var inst_15099 = (state_15145[(76)]);
var inst_14926 = (state_15145[(34)]);
var inst_15106__$1 = (inst_15099 < inst_14926);
var state_15145__$1 = (function (){var statearr_15214 = state_15145;
(statearr_15214[(79)] = inst_15106__$1);

return statearr_15214;
})();
if(cljs.core.truth_(inst_15106__$1)){
var statearr_15215_15396 = state_15145__$1;
(statearr_15215_15396[(1)] = (111));

} else {
var statearr_15216_15397 = state_15145__$1;
(statearr_15216_15397[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (56))){
var state_15145__$1 = state_15145;
var statearr_15217_15398 = state_15145__$1;
(statearr_15217_15398[(2)] = fluree.db.util.core.min_integer);

(statearr_15217_15398[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (33))){
var inst_14881 = (state_15145[(2)]);
var inst_14882 = fluree.db.util.async.throw_err.call(null,inst_14881);
var state_15145__$1 = state_15145;
var statearr_15218_15399 = state_15145__$1;
(statearr_15218_15399[(2)] = inst_14882);

(statearr_15218_15399[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (13))){
var inst_14827 = (state_15145[(2)]);
var inst_14828 = fluree.db.util.async.throw_err.call(null,inst_14827);
var state_15145__$1 = state_15145;
var statearr_15219_15400 = state_15145__$1;
(statearr_15219_15400[(2)] = inst_14828);

(statearr_15219_15400[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (22))){
var inst_14841 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15220_15401 = state_15145__$1;
(statearr_15220_15401[(2)] = inst_14841);

(statearr_15220_15401[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (90))){
var inst_14966 = (state_15145[(10)]);
var inst_14962 = (state_15145[(11)]);
var inst_14943 = (state_15145[(12)]);
var inst_14939 = (state_15145[(13)]);
var inst_14963 = (state_15145[(14)]);
var inst_14903 = (state_15145[(15)]);
var inst_14949 = (state_15145[(16)]);
var inst_14932 = (state_15145[(17)]);
var inst_14925 = (state_15145[(18)]);
var inst_15021 = (state_15145[(72)]);
var inst_14867 = (state_15145[(19)]);
var inst_14864 = (state_15145[(20)]);
var inst_14831 = (state_15145[(21)]);
var inst_14972 = (state_15145[(22)]);
var inst_14964 = (state_15145[(23)]);
var inst_15020 = (state_15145[(80)]);
var inst_14812 = (state_15145[(24)]);
var inst_14944 = (state_15145[(25)]);
var inst_14998 = (state_15145[(81)]);
var inst_14938 = (state_15145[(26)]);
var inst_14799 = (state_15145[(27)]);
var inst_14795 = (state_15145[(28)]);
var inst_14802 = (state_15145[(29)]);
var inst_14912 = (state_15145[(30)]);
var inst_14810 = (state_15145[(31)]);
var inst_14933 = (state_15145[(33)]);
var inst_14926 = (state_15145[(34)]);
var inst_14923 = (state_15145[(35)]);
var inst_14811 = (state_15145[(36)]);
var inst_14863 = (state_15145[(37)]);
var inst_14822 = (state_15145[(38)]);
var inst_14806 = (state_15145[(39)]);
var inst_14885 = (state_15145[(40)]);
var inst_14934 = (state_15145[(41)]);
var inst_14953 = (state_15145[(8)]);
var inst_14807 = (state_15145[(42)]);
var inst_14800 = (state_15145[(43)]);
var inst_14921 = (state_15145[(44)]);
var inst_14965 = (state_15145[(45)]);
var inst_14959 = (state_15145[(9)]);
var inst_14999 = (state_15145[(65)]);
var inst_14876 = (state_15145[(46)]);
var inst_14894 = (state_15145[(47)]);
var inst_14922 = (state_15145[(48)]);
var inst_15019 = (function (){var no_filter_QMARK_ = inst_14959;
var base_result_SINGLEQUOTE_ = inst_14998;
var t = inst_14939;
var max_limit_QMARK_ = inst_14933;
var next_node = inst_14962;
var fast_forward_db_QMARK_ = inst_14944;
var s1 = inst_14822;
var o2 = inst_14885;
var t1 = inst_14799;
var predicate_fn = inst_14812;
var i = inst_14964;
var rhs = inst_14999;
var vec__14791 = inst_14864;
var m1 = inst_14912;
var root_node = inst_14949;
var s2 = inst_14831;
var p2 = inst_14903;
var permissions = inst_14934;
var limit = inst_14932;
var map__14794 = inst_14925;
var start_flake = inst_14922;
var vec__14788 = inst_14863;
var flake_limit = inst_14926;
var offset = inst_14963;
var acc = inst_14966;
var vec__14784 = inst_14802;
var t2 = inst_14806;
var op1 = inst_14800;
var o1 = inst_14876;
var end_flake = inst_14923;
var map__14787 = inst_14810;
var base_result = inst_14972;
var s = inst_14965;
var node_start = inst_14953;
var p1 = inst_14894;
var subject_fn = inst_14811;
var vec__14781 = inst_14795;
var object_fn = inst_14867;
var idx_compare = inst_14938;
var op2 = inst_14807;
var m2 = inst_14921;
var novelty = inst_14943;
return (function (p1__14766_SHARP_){
return p1__14766_SHARP_.s;
});
})();
var inst_15020__$1 = cljs.core.partition_by.call(null,inst_15019,inst_14998);
var inst_15021__$1 = cljs.core.count.call(null,inst_15020__$1);
var inst_15022 = (inst_14963 > inst_15021__$1);
var state_15145__$1 = (function (){var statearr_15221 = state_15145;
(statearr_15221[(72)] = inst_15021__$1);

(statearr_15221[(80)] = inst_15020__$1);

return statearr_15221;
})();
if(cljs.core.truth_(inst_15022)){
var statearr_15222_15402 = state_15145__$1;
(statearr_15222_15402[(1)] = (92));

} else {
var statearr_15223_15403 = state_15145__$1;
(statearr_15223_15403[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (109))){
var inst_15104 = (state_15145[(82)]);
var state_15145__$1 = state_15145;
var statearr_15224_15404 = state_15145__$1;
(statearr_15224_15404[(2)] = inst_15104);

(statearr_15224_15404[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (36))){
var inst_14890 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
if(cljs.core.truth_(inst_14890)){
var statearr_15225_15405 = state_15145__$1;
(statearr_15225_15405[(1)] = (37));

} else {
var statearr_15226_15406 = state_15145__$1;
(statearr_15226_15406[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (41))){
var inst_14895 = (state_15145[(63)]);
var state_15145__$1 = state_15145;
var statearr_15227_15407 = state_15145__$1;
(statearr_15227_15407[(2)] = inst_14895);

(statearr_15227_15407[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (118))){
var inst_15125 = (state_15145[(73)]);
var state_15145__$1 = state_15145;
var statearr_15228_15408 = state_15145__$1;
(statearr_15228_15408[(2)] = inst_15125);

(statearr_15228_15408[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (89))){
var inst_14966 = (state_15145[(10)]);
var inst_14964 = (state_15145[(23)]);
var inst_14998 = (state_15145[(81)]);
var inst_14926 = (state_15145[(34)]);
var inst_14965 = (state_15145[(45)]);
var inst_15010 = cljs.core.count.call(null,inst_14998);
var inst_15011 = (inst_14926 - inst_14964);
var inst_15012 = cljs.core.take.call(null,inst_15011,inst_14998);
var inst_15013 = cljs.core.into.call(null,inst_14966,inst_15012);
var inst_15014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15015 = (inst_14964 + inst_15010);
var inst_15016 = [(0),inst_15015,inst_14965,inst_15013];
var inst_15017 = (new cljs.core.PersistentVector(null,4,(5),inst_15014,inst_15016,null));
var state_15145__$1 = state_15145;
var statearr_15229_15409 = state_15145__$1;
(statearr_15229_15409[(2)] = inst_15017);

(statearr_15229_15409[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (100))){
var inst_15060 = (state_15145[(52)]);
var inst_14964 = (state_15145[(23)]);
var inst_15059 = (state_15145[(53)]);
var inst_15058 = (state_15145[(54)]);
var inst_14926 = (state_15145[(34)]);
var inst_15032 = (state_15145[(69)]);
var inst_15054 = (state_15145[(2)]);
var inst_15055 = cljs.core.nth.call(null,inst_15054,(0),null);
var inst_15056 = cljs.core.nth.call(null,inst_15054,(1),null);
var inst_15057 = cljs.core.take.call(null,inst_15056,inst_15032);
var inst_15058__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_15057);
var inst_15059__$1 = cljs.core.count.call(null,inst_15058__$1);
var inst_15060__$1 = (inst_14964 + inst_15059__$1);
var inst_15061 = (inst_15060__$1 > inst_14926);
var state_15145__$1 = (function (){var statearr_15230 = state_15145;
(statearr_15230[(52)] = inst_15060__$1);

(statearr_15230[(53)] = inst_15059__$1);

(statearr_15230[(54)] = inst_15058__$1);

(statearr_15230[(83)] = inst_15055);

return statearr_15230;
})();
if(cljs.core.truth_(inst_15061)){
var statearr_15231_15410 = state_15145__$1;
(statearr_15231_15410[(1)] = (101));

} else {
var statearr_15232_15411 = state_15145__$1;
(statearr_15232_15411[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (122))){
var inst_15099 = (state_15145[(76)]);
var inst_15100 = (state_15145[(77)]);
var inst_15101 = (state_15145[(7)]);
var inst_15098 = (state_15145[(78)]);
var inst_15125 = (state_15145[(73)]);
var inst_14962 = inst_15125;
var inst_14963 = inst_15098;
var inst_14964 = inst_15099;
var inst_14965 = inst_15100;
var inst_14966 = inst_15101;
var state_15145__$1 = (function (){var statearr_15233 = state_15145;
(statearr_15233[(10)] = inst_14966);

(statearr_15233[(11)] = inst_14962);

(statearr_15233[(14)] = inst_14963);

(statearr_15233[(23)] = inst_14964);

(statearr_15233[(45)] = inst_14965);

return statearr_15233;
})();
var statearr_15234_15412 = state_15145__$1;
(statearr_15234_15412[(2)] = null);

(statearr_15234_15412[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (43))){
var state_15145__$1 = state_15145;
var statearr_15235_15413 = state_15145__$1;
(statearr_15235_15413[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15235_15413[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (61))){
var inst_14943 = (state_15145[(12)]);
var inst_14939 = (state_15145[(13)]);
var inst_14949 = (state_15145[(16)]);
var inst_14944 = (state_15145[(25)]);
var inst_14922 = (state_15145[(48)]);
var inst_14948 = (state_15145[(2)]);
var inst_14949__$1 = fluree.db.util.async.throw_err.call(null,inst_14948);
var inst_14950 = fluree.db.query.range.find_next_valid_node.call(null,inst_14949__$1,inst_14922,inst_14939,inst_14943,inst_14944);
var state_15145__$1 = (function (){var statearr_15236 = state_15145;
(statearr_15236[(16)] = inst_14949__$1);

return statearr_15236;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(62),inst_14950);
} else {
if((state_val_15146 === (29))){
var inst_14872 = (state_15145[(2)]);
var inst_14873 = fluree.db.util.async.throw_err.call(null,inst_14872);
var state_15145__$1 = state_15145;
var statearr_15237_15414 = state_15145__$1;
(statearr_15237_15414[(2)] = inst_14873);

(statearr_15237_15414[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (44))){
var inst_14804 = (state_15145[(58)]);
var state_15145__$1 = state_15145;
var statearr_15238_15415 = state_15145__$1;
(statearr_15238_15415[(2)] = inst_14804);

(statearr_15238_15415[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (93))){
var inst_14963 = (state_15145[(14)]);
var inst_15020 = (state_15145[(80)]);
var inst_14959 = (state_15145[(9)]);
var inst_15032 = cljs.core.drop.call(null,inst_14963,inst_15020);
var state_15145__$1 = (function (){var statearr_15239 = state_15145;
(statearr_15239[(69)] = inst_15032);

return statearr_15239;
})();
if(cljs.core.truth_(inst_14959)){
var statearr_15240_15416 = state_15145__$1;
(statearr_15240_15416[(1)] = (95));

} else {
var statearr_15241_15417 = state_15145__$1;
(statearr_15241_15417[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (6))){
var inst_14796 = (state_15145[(49)]);
var inst_14816 = fluree.db.dbproto._subid.call(null,db,inst_14796);
var state_15145__$1 = state_15145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(9),inst_14816);
} else {
if((state_val_15146 === (111))){
var inst_14932 = (state_15145[(17)]);
var inst_15100 = (state_15145[(77)]);
var inst_15108 = (inst_15100 < inst_14932);
var state_15145__$1 = state_15145;
var statearr_15242_15418 = state_15145__$1;
(statearr_15242_15418[(2)] = inst_15108);

(statearr_15242_15418[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (28))){
var inst_14866 = (state_15145[(74)]);
var inst_14876 = (state_15145[(2)]);
var inst_14877 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14866);
var state_15145__$1 = (function (){var statearr_15243 = state_15145;
(statearr_15243[(46)] = inst_14876);

return statearr_15243;
})();
if(inst_14877){
var statearr_15244_15419 = state_15145__$1;
(statearr_15244_15419[(1)] = (30));

} else {
var statearr_15245_15420 = state_15145__$1;
(statearr_15245_15420[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (64))){
var state_15145__$1 = state_15145;
var statearr_15246_15421 = state_15145__$1;
(statearr_15246_15421[(2)] = true);

(statearr_15246_15421[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (103))){
var inst_15055 = (state_15145[(83)]);
var inst_15074 = (state_15145[(2)]);
var inst_15075 = cljs.core.nth.call(null,inst_15074,(0),null);
var inst_15076 = cljs.core.nth.call(null,inst_15074,(1),null);
var inst_15077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15078 = [inst_15075,inst_15055,inst_15076];
var inst_15079 = (new cljs.core.PersistentVector(null,3,(5),inst_15077,inst_15078,null));
var state_15145__$1 = state_15145;
var statearr_15247_15422 = state_15145__$1;
(statearr_15247_15422[(2)] = inst_15079);

(statearr_15247_15422[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (51))){
var inst_14910 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15248_15423 = state_15145__$1;
(statearr_15248_15423[(2)] = inst_14910);

(statearr_15248_15423[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (25))){
var inst_14864 = (state_15145[(20)]);
var inst_14865 = (state_15145[(51)]);
var inst_14863 = (state_15145[(37)]);
var inst_14863__$1 = (state_15145[(2)]);
var inst_14864__$1 = cljs.core.nth.call(null,inst_14863__$1,(0),null);
var inst_14865__$1 = cljs.core.nth.call(null,inst_14864__$1,(0),null);
var inst_14866 = cljs.core.nth.call(null,inst_14864__$1,(1),null);
var inst_14867 = cljs.core.nth.call(null,inst_14863__$1,(1),null);
var inst_14868 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14865__$1);
var state_15145__$1 = (function (){var statearr_15249 = state_15145;
(statearr_15249[(19)] = inst_14867);

(statearr_15249[(20)] = inst_14864__$1);

(statearr_15249[(51)] = inst_14865__$1);

(statearr_15249[(74)] = inst_14866);

(statearr_15249[(37)] = inst_14863__$1);

return statearr_15249;
})();
if(inst_14868){
var statearr_15250_15424 = state_15145__$1;
(statearr_15250_15424[(1)] = (26));

} else {
var statearr_15251_15425 = state_15145__$1;
(statearr_15251_15425[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (34))){
var inst_14876 = (state_15145[(46)]);
var state_15145__$1 = state_15145;
var statearr_15252_15426 = state_15145__$1;
(statearr_15252_15426[(2)] = inst_14876);

(statearr_15252_15426[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (17))){
var inst_14805 = (state_15145[(60)]);
var state_15145__$1 = state_15145;
var statearr_15253_15427 = state_15145__$1;
(statearr_15253_15427[(2)] = inst_14805);

(statearr_15253_15427[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (3))){
var inst_15143 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15145__$1,inst_15143);
} else {
if((state_val_15146 === (12))){
var inst_14798 = (state_15145[(62)]);
var inst_14831 = (state_15145[(2)]);
var inst_14832 = cljs.core.boolean_QMARK_.call(null,inst_14798);
var state_15145__$1 = (function (){var statearr_15254 = state_15145;
(statearr_15254[(21)] = inst_14831);

return statearr_15254;
})();
if(inst_14832){
var statearr_15255_15428 = state_15145__$1;
(statearr_15255_15428[(1)] = (14));

} else {
var statearr_15256_15429 = state_15145__$1;
(statearr_15256_15429[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (2))){
var inst_14796 = (state_15145[(49)]);
var inst_14795 = (state_15145[(28)]);
var inst_14802 = (state_15145[(29)]);
var inst_14810 = (state_15145[(31)]);
var _ = (function (){var statearr_15257 = state_15145;
(statearr_15257[(4)] = cljs.core.cons.call(null,(5),(state_15145[(4)])));

return statearr_15257;
})();
var inst_14795__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_14796__$1 = cljs.core.nth.call(null,inst_14795__$1,(0),null);
var inst_14797 = cljs.core.nth.call(null,inst_14795__$1,(1),null);
var inst_14798 = cljs.core.nth.call(null,inst_14795__$1,(2),null);
var inst_14799 = cljs.core.nth.call(null,inst_14795__$1,(3),null);
var inst_14800 = cljs.core.nth.call(null,inst_14795__$1,(4),null);
var inst_14801 = cljs.core.nth.call(null,inst_14795__$1,(5),null);
var inst_14802__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_14803 = cljs.core.nth.call(null,inst_14802__$1,(0),null);
var inst_14804 = cljs.core.nth.call(null,inst_14802__$1,(1),null);
var inst_14805 = cljs.core.nth.call(null,inst_14802__$1,(2),null);
var inst_14806 = cljs.core.nth.call(null,inst_14802__$1,(3),null);
var inst_14807 = cljs.core.nth.call(null,inst_14802__$1,(4),null);
var inst_14808 = cljs.core.nth.call(null,inst_14802__$1,(5),null);
var inst_14809 = opts;
var inst_14810__$1 = cljs.core.__destructure_map.call(null,inst_14809);
var inst_14811 = cljs.core.get.call(null,inst_14810__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14812 = cljs.core.get.call(null,inst_14810__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14813 = cljs.core.get.call(null,inst_14810__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14814 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14796__$1);
var state_15145__$1 = (function (){var statearr_15258 = state_15145;
(statearr_15258[(55)] = inst_14813);

(statearr_15258[(56)] = inst_14797);

(statearr_15258[(57)] = inst_14801);

(statearr_15258[(58)] = inst_14804);

(statearr_15258[(60)] = inst_14805);

(statearr_15258[(61)] = inst_14808);

(statearr_15258[(24)] = inst_14812);

(statearr_15258[(49)] = inst_14796__$1);

(statearr_15258[(84)] = inst_14803);

(statearr_15258[(27)] = inst_14799);

(statearr_15258[(28)] = inst_14795__$1);

(statearr_15258[(29)] = inst_14802__$1);

(statearr_15258[(31)] = inst_14810__$1);

(statearr_15258[(36)] = inst_14811);

(statearr_15258[(39)] = inst_14806);

(statearr_15258[(42)] = inst_14807);

(statearr_15258[(43)] = inst_14800);

(statearr_15258[(62)] = inst_14798);

return statearr_15258;
})();
if(inst_14814){
var statearr_15259_15430 = state_15145__$1;
(statearr_15259_15430[(1)] = (6));

} else {
var statearr_15260_15431 = state_15145__$1;
(statearr_15260_15431[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (66))){
var inst_14928 = (state_15145[(71)]);
var inst_14953 = (state_15145[(8)]);
var inst_14961 = cljs.core.PersistentVector.EMPTY;
var inst_14962 = inst_14953;
var inst_14963 = inst_14928;
var inst_14964 = (0);
var inst_14965 = (0);
var inst_14966 = inst_14961;
var state_15145__$1 = (function (){var statearr_15261 = state_15145;
(statearr_15261[(10)] = inst_14966);

(statearr_15261[(11)] = inst_14962);

(statearr_15261[(14)] = inst_14963);

(statearr_15261[(23)] = inst_14964);

(statearr_15261[(45)] = inst_14965);

return statearr_15261;
})();
var statearr_15262_15432 = state_15145__$1;
(statearr_15262_15432[(2)] = null);

(statearr_15262_15432[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (107))){
var inst_15117 = (state_15145[(66)]);
var inst_15117__$1 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15263 = state_15145;
(statearr_15263[(66)] = inst_15117__$1);

return statearr_15263;
})();
if(cljs.core.truth_(inst_15117__$1)){
var statearr_15264_15433 = state_15145__$1;
(statearr_15264_15433[(1)] = (114));

} else {
var statearr_15265_15434 = state_15145__$1;
(statearr_15265_15434[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (23))){
var inst_14813 = (state_15145[(55)]);
var inst_14805 = (state_15145[(60)]);
var inst_14798 = (state_15145[(62)]);
var inst_14848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14850 = [inst_14798,inst_14805];
var inst_14851 = (new cljs.core.PersistentVector(null,2,(5),inst_14849,inst_14850,null));
var inst_14852 = [inst_14851,inst_14813];
var inst_14853 = (new cljs.core.PersistentVector(null,2,(5),inst_14848,inst_14852,null));
var state_15145__$1 = state_15145;
var statearr_15266_15435 = state_15145__$1;
(statearr_15266_15435[(2)] = inst_14853);

(statearr_15266_15435[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (47))){
var inst_14906 = (cljs.core._GT__EQ_ === start_test);
var state_15145__$1 = state_15145;
if(cljs.core.truth_(inst_14906)){
var statearr_15267_15436 = state_15145__$1;
(statearr_15267_15436[(1)] = (49));

} else {
var statearr_15268_15437 = state_15145__$1;
(statearr_15268_15437[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (35))){
var inst_14886 = (state_15145[(75)]);
var state_15145__$1 = state_15145;
var statearr_15269_15438 = state_15145__$1;
(statearr_15269_15438[(2)] = inst_14886);

(statearr_15269_15438[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (82))){
var inst_14962 = (state_15145[(11)]);
var inst_14933 = (state_15145[(33)]);
var inst_14998 = (state_15145[(2)]);
var inst_14999 = fluree.db.dbproto._rhs.call(null,inst_14962);
var state_15145__$1 = (function (){var statearr_15270 = state_15145;
(statearr_15270[(81)] = inst_14998);

(statearr_15270[(65)] = inst_14999);

return statearr_15270;
})();
if(cljs.core.truth_(inst_14933)){
var statearr_15271_15439 = state_15145__$1;
(statearr_15271_15439[(1)] = (83));

} else {
var statearr_15272_15440 = state_15145__$1;
(statearr_15272_15440[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (76))){
var inst_14812 = (state_15145[(24)]);
var inst_14986 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15273 = state_15145;
(statearr_15273[(64)] = inst_14986);

return statearr_15273;
})();
if(cljs.core.truth_(inst_14812)){
var statearr_15274_15441 = state_15145__$1;
(statearr_15274_15441[(1)] = (77));

} else {
var statearr_15275_15442 = state_15145__$1;
(statearr_15275_15442[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (97))){
var inst_14966 = (state_15145[(10)]);
var inst_15086 = (state_15145[(2)]);
var inst_15087 = cljs.core.nth.call(null,inst_15086,(0),null);
var inst_15088 = cljs.core.nth.call(null,inst_15086,(1),null);
var inst_15089 = cljs.core.nth.call(null,inst_15086,(2),null);
var inst_15090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15091 = cljs.core.into.call(null,inst_14966,inst_15089);
var inst_15092 = [(0),inst_15087,inst_15088,inst_15091];
var inst_15093 = (new cljs.core.PersistentVector(null,4,(5),inst_15090,inst_15092,null));
var state_15145__$1 = state_15145;
var statearr_15276_15443 = state_15145__$1;
(statearr_15276_15443[(2)] = inst_15093);

(statearr_15276_15443[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (19))){
var inst_14843 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15277_15444 = state_15145__$1;
(statearr_15277_15444[(2)] = inst_14843);

(statearr_15277_15444[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (57))){
var inst_14919 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15278_15445 = state_15145__$1;
(statearr_15278_15445[(2)] = inst_14919);

(statearr_15278_15445[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (68))){
var inst_15140 = (state_15145[(2)]);
var _ = (function (){var statearr_15279 = state_15145;
(statearr_15279[(4)] = cljs.core.rest.call(null,(state_15145[(4)])));

return statearr_15279;
})();
var state_15145__$1 = state_15145;
var statearr_15280_15446 = state_15145__$1;
(statearr_15280_15446[(2)] = inst_15140);

(statearr_15280_15446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (11))){
var inst_14803 = (state_15145[(84)]);
var state_15145__$1 = state_15145;
var statearr_15281_15447 = state_15145__$1;
(statearr_15281_15447[(2)] = inst_14803);

(statearr_15281_15447[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (115))){
var state_15145__$1 = state_15145;
var statearr_15283_15448 = state_15145__$1;
(statearr_15283_15448[(2)] = null);

(statearr_15283_15448[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (9))){
var inst_14818 = (state_15145[(2)]);
var inst_14819 = fluree.db.util.async.throw_err.call(null,inst_14818);
var state_15145__$1 = state_15145;
var statearr_15284_15449 = state_15145__$1;
(statearr_15284_15449[(2)] = inst_14819);

(statearr_15284_15449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (5))){
var _ = (function (){var statearr_15285 = state_15145;
(statearr_15285[(4)] = cljs.core.rest.call(null,(state_15145[(4)])));

return statearr_15285;
})();
var state_15145__$1 = state_15145;
var ex15282 = (state_15145__$1[(2)]);
var statearr_15286_15450 = state_15145__$1;
(statearr_15286_15450[(5)] = ex15282);


if((ex15282 instanceof Error)){
var statearr_15287_15451 = state_15145__$1;
(statearr_15287_15451[(1)] = (4));

(statearr_15287_15451[(5)] = null);

} else {
throw ex15282;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (112))){
var inst_15106 = (state_15145[(79)]);
var state_15145__$1 = state_15145;
var statearr_15288_15452 = state_15145__$1;
(statearr_15288_15452[(2)] = inst_15106);

(statearr_15288_15452[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (83))){
var inst_14963 = (state_15145[(14)]);
var inst_15001 = (state_15145[(85)]);
var inst_15001__$1 = cljs.core._EQ_.call(null,(0),inst_14963);
var state_15145__$1 = (function (){var statearr_15289 = state_15145;
(statearr_15289[(85)] = inst_15001__$1);

return statearr_15289;
})();
if(inst_15001__$1){
var statearr_15290_15453 = state_15145__$1;
(statearr_15290_15453[(1)] = (86));

} else {
var statearr_15291_15454 = state_15145__$1;
(statearr_15291_15454[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (14))){
var inst_14798 = (state_15145[(62)]);
var state_15145__$1 = state_15145;
var statearr_15292_15455 = state_15145__$1;
(statearr_15292_15455[(2)] = inst_14798);

(statearr_15292_15455[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (45))){
var inst_14801 = (state_15145[(57)]);
var inst_14903 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15293 = state_15145;
(statearr_15293[(15)] = inst_14903);

return statearr_15293;
})();
if(cljs.core.truth_(inst_14801)){
var statearr_15294_15456 = state_15145__$1;
(statearr_15294_15456[(1)] = (46));

} else {
var statearr_15295_15457 = state_15145__$1;
(statearr_15295_15457[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (53))){
var inst_14915 = (cljs.core._LT__EQ_ === end_test);
var state_15145__$1 = state_15145;
if(cljs.core.truth_(inst_14915)){
var statearr_15296_15458 = state_15145__$1;
(statearr_15296_15458[(1)] = (55));

} else {
var statearr_15297_15459 = state_15145__$1;
(statearr_15297_15459[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (78))){
var inst_14986 = (state_15145[(64)]);
var state_15145__$1 = state_15145;
var statearr_15298_15460 = state_15145__$1;
(statearr_15298_15460[(2)] = inst_14986);

(statearr_15298_15460[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (26))){
var inst_14865 = (state_15145[(51)]);
var inst_14870 = fluree.db.dbproto._subid.call(null,db,inst_14865);
var state_15145__$1 = state_15145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(29),inst_14870);
} else {
if((state_val_15146 === (123))){
var inst_15135 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15299_15461 = state_15145__$1;
(statearr_15299_15461[(2)] = inst_15135);

(statearr_15299_15461[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (16))){
var inst_14845 = (state_15145[(59)]);
var inst_14845__$1 = (state_15145[(2)]);
var inst_14846 = (inst_14845__$1 == null);
var state_15145__$1 = (function (){var statearr_15300 = state_15145;
(statearr_15300[(59)] = inst_14845__$1);

return statearr_15300;
})();
if(cljs.core.truth_(inst_14846)){
var statearr_15301_15462 = state_15145__$1;
(statearr_15301_15462[(1)] = (23));

} else {
var statearr_15302_15463 = state_15145__$1;
(statearr_15302_15463[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (81))){
var inst_14992 = (state_15145[(86)]);
var state_15145__$1 = state_15145;
var statearr_15303_15464 = state_15145__$1;
(statearr_15303_15464[(2)] = inst_14992);

(statearr_15303_15464[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (120))){
var inst_15129 = (state_15145[(2)]);
var inst_15130 = cljs.core.not.call(null,inst_15129);
var state_15145__$1 = state_15145;
if(inst_15130){
var statearr_15304_15465 = state_15145__$1;
(statearr_15304_15465[(1)] = (121));

} else {
var statearr_15305_15466 = state_15145__$1;
(statearr_15305_15466[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (79))){
var inst_14867 = (state_15145[(19)]);
var inst_14992 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15306 = state_15145;
(statearr_15306[(86)] = inst_14992);

return statearr_15306;
})();
if(cljs.core.truth_(inst_14867)){
var statearr_15307_15467 = state_15145__$1;
(statearr_15307_15467[(1)] = (80));

} else {
var statearr_15308_15468 = state_15145__$1;
(statearr_15308_15468[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (38))){
var inst_14797 = (state_15145[(56)]);
var state_15145__$1 = state_15145;
var statearr_15309_15469 = state_15145__$1;
(statearr_15309_15469[(2)] = inst_14797);

(statearr_15309_15469[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (98))){
var inst_15040 = (state_15145[(67)]);
var inst_14932 = (state_15145[(17)]);
var inst_15042 = (state_15145[(68)]);
var inst_15045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15046 = (inst_15040 - inst_15042);
var inst_15047 = [inst_14932,inst_15046];
var inst_15048 = (new cljs.core.PersistentVector(null,2,(5),inst_15045,inst_15047,null));
var state_15145__$1 = state_15145;
var statearr_15310_15470 = state_15145__$1;
(statearr_15310_15470[(2)] = inst_15048);

(statearr_15310_15470[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (87))){
var inst_15001 = (state_15145[(85)]);
var state_15145__$1 = state_15145;
var statearr_15311_15471 = state_15145__$1;
(statearr_15311_15471[(2)] = inst_15001);

(statearr_15311_15471[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (30))){
var inst_14866 = (state_15145[(74)]);
var inst_14879 = fluree.db.dbproto._subid.call(null,db,inst_14866);
var state_15145__$1 = state_15145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(33),inst_14879);
} else {
if((state_val_15146 === (73))){
var inst_14811 = (state_15145[(36)]);
var inst_14980 = (state_15145[(2)]);
var state_15145__$1 = (function (){var statearr_15312 = state_15145;
(statearr_15312[(32)] = inst_14980);

return statearr_15312;
})();
if(cljs.core.truth_(inst_14811)){
var statearr_15313_15472 = state_15145__$1;
(statearr_15313_15472[(1)] = (74));

} else {
var statearr_15314_15473 = state_15145__$1;
(statearr_15314_15473[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (96))){
var inst_14932 = (state_15145[(17)]);
var inst_14964 = (state_15145[(23)]);
var inst_14926 = (state_15145[(34)]);
var inst_15032 = (state_15145[(69)]);
var inst_14965 = (state_15145[(45)]);
var inst_15081 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_15032,inst_14964,inst_14965,inst_14926,inst_14932);
var state_15145__$1 = state_15145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(104),inst_15081);
} else {
if((state_val_15146 === (10))){
var inst_14803 = (state_15145[(84)]);
var inst_14825 = fluree.db.dbproto._subid.call(null,db,inst_14803);
var state_15145__$1 = state_15145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(13),inst_14825);
} else {
if((state_val_15146 === (18))){
var state_15145__$1 = state_15145;
var statearr_15315_15474 = state_15145__$1;
(statearr_15315_15474[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (105))){
var inst_14938 = (state_15145[(26)]);
var inst_14923 = (state_15145[(35)]);
var inst_15104 = (state_15145[(82)]);
var inst_14999 = (state_15145[(65)]);
var inst_15103 = inst_14938.call(null,inst_14999,inst_14923);
var inst_15104__$1 = (inst_15103 < (0));
var state_15145__$1 = (function (){var statearr_15317 = state_15145;
(statearr_15317[(82)] = inst_15104__$1);

return statearr_15317;
})();
if(cljs.core.truth_(inst_15104__$1)){
var statearr_15318_15475 = state_15145__$1;
(statearr_15318_15475[(1)] = (108));

} else {
var statearr_15319_15476 = state_15145__$1;
(statearr_15319_15476[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (52))){
var inst_14808 = (state_15145[(61)]);
var state_15145__$1 = state_15145;
var statearr_15320_15477 = state_15145__$1;
(statearr_15320_15477[(2)] = inst_14808);

(statearr_15320_15477[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (114))){
var inst_14943 = (state_15145[(12)]);
var inst_14939 = (state_15145[(13)]);
var inst_14949 = (state_15145[(16)]);
var inst_14944 = (state_15145[(25)]);
var inst_14999 = (state_15145[(65)]);
var inst_15119 = fluree.db.query.range.find_next_valid_node.call(null,inst_14949,inst_14999,inst_14939,inst_14943,inst_14944);
var state_15145__$1 = state_15145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15145__$1,(117),inst_15119);
} else {
if((state_val_15146 === (67))){
var state_15145__$1 = state_15145;
var statearr_15321_15478 = state_15145__$1;
(statearr_15321_15478[(2)] = null);

(statearr_15321_15478[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (71))){
var inst_14966 = (state_15145[(10)]);
var inst_14962 = (state_15145[(11)]);
var inst_14943 = (state_15145[(12)]);
var inst_14939 = (state_15145[(13)]);
var inst_14963 = (state_15145[(14)]);
var inst_14903 = (state_15145[(15)]);
var inst_14949 = (state_15145[(16)]);
var inst_14932 = (state_15145[(17)]);
var inst_14925 = (state_15145[(18)]);
var inst_14867 = (state_15145[(19)]);
var inst_14864 = (state_15145[(20)]);
var inst_14831 = (state_15145[(21)]);
var inst_14972 = (state_15145[(22)]);
var inst_14964 = (state_15145[(23)]);
var inst_14812 = (state_15145[(24)]);
var inst_14944 = (state_15145[(25)]);
var inst_14938 = (state_15145[(26)]);
var inst_14799 = (state_15145[(27)]);
var inst_14795 = (state_15145[(28)]);
var inst_14802 = (state_15145[(29)]);
var inst_14912 = (state_15145[(30)]);
var inst_14810 = (state_15145[(31)]);
var inst_14933 = (state_15145[(33)]);
var inst_14926 = (state_15145[(34)]);
var inst_14923 = (state_15145[(35)]);
var inst_14811 = (state_15145[(36)]);
var inst_14863 = (state_15145[(37)]);
var inst_14822 = (state_15145[(38)]);
var inst_14806 = (state_15145[(39)]);
var inst_14885 = (state_15145[(40)]);
var inst_14934 = (state_15145[(41)]);
var inst_14953 = (state_15145[(8)]);
var inst_14807 = (state_15145[(42)]);
var inst_14800 = (state_15145[(43)]);
var inst_14921 = (state_15145[(44)]);
var inst_14965 = (state_15145[(45)]);
var inst_14959 = (state_15145[(9)]);
var inst_14876 = (state_15145[(46)]);
var inst_14894 = (state_15145[(47)]);
var inst_14922 = (state_15145[(48)]);
var inst_14976 = (function (){var no_filter_QMARK_ = inst_14959;
var t = inst_14939;
var max_limit_QMARK_ = inst_14933;
var next_node = inst_14962;
var fast_forward_db_QMARK_ = inst_14944;
var s1 = inst_14822;
var o2 = inst_14885;
var t1 = inst_14799;
var predicate_fn = inst_14812;
var i = inst_14964;
var vec__14791 = inst_14864;
var m1 = inst_14912;
var root_node = inst_14949;
var s2 = inst_14831;
var p2 = inst_14903;
var permissions = inst_14934;
var limit = inst_14932;
var map__14794 = inst_14925;
var start_flake = inst_14922;
var vec__14788 = inst_14863;
var flake_limit = inst_14926;
var offset = inst_14963;
var acc = inst_14966;
var vec__14784 = inst_14802;
var t2 = inst_14806;
var G__14973 = inst_14972;
var op1 = inst_14800;
var o1 = inst_14876;
var end_flake = inst_14923;
var map__14787 = inst_14810;
var base_result = inst_14972;
var s = inst_14965;
var node_start = inst_14953;
var p1 = inst_14894;
var subject_fn = inst_14811;
var vec__14781 = inst_14795;
var object_fn = inst_14867;
var idx_compare = inst_14938;
var op2 = inst_14807;
var m2 = inst_14921;
var novelty = inst_14943;
return (function (p1__14762_SHARP_){
return cljs.core._EQ_.call(null,p1__14762_SHARP_.o,start_flake.o);
});
})();
var inst_14977 = cljs.core.filter.call(null,inst_14976,inst_14972);
var state_15145__$1 = state_15145;
var statearr_15322_15479 = state_15145__$1;
(statearr_15322_15479[(2)] = inst_14977);

(statearr_15322_15479[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (42))){
var inst_14899 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
if(cljs.core.truth_(inst_14899)){
var statearr_15323_15480 = state_15145__$1;
(statearr_15323_15480[(1)] = (43));

} else {
var statearr_15324_15481 = state_15145__$1;
(statearr_15324_15481[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (80))){
var inst_14966 = (state_15145[(10)]);
var inst_14962 = (state_15145[(11)]);
var inst_14943 = (state_15145[(12)]);
var inst_14939 = (state_15145[(13)]);
var inst_14963 = (state_15145[(14)]);
var inst_14903 = (state_15145[(15)]);
var inst_14949 = (state_15145[(16)]);
var inst_14932 = (state_15145[(17)]);
var inst_14925 = (state_15145[(18)]);
var inst_14867 = (state_15145[(19)]);
var inst_14864 = (state_15145[(20)]);
var inst_14831 = (state_15145[(21)]);
var inst_14972 = (state_15145[(22)]);
var inst_14964 = (state_15145[(23)]);
var inst_14812 = (state_15145[(24)]);
var inst_14944 = (state_15145[(25)]);
var inst_14938 = (state_15145[(26)]);
var inst_14799 = (state_15145[(27)]);
var inst_14795 = (state_15145[(28)]);
var inst_14802 = (state_15145[(29)]);
var inst_14912 = (state_15145[(30)]);
var inst_14810 = (state_15145[(31)]);
var inst_14933 = (state_15145[(33)]);
var inst_14926 = (state_15145[(34)]);
var inst_14923 = (state_15145[(35)]);
var inst_14811 = (state_15145[(36)]);
var inst_14863 = (state_15145[(37)]);
var inst_14822 = (state_15145[(38)]);
var inst_14806 = (state_15145[(39)]);
var inst_14992 = (state_15145[(86)]);
var inst_14885 = (state_15145[(40)]);
var inst_14934 = (state_15145[(41)]);
var inst_14953 = (state_15145[(8)]);
var inst_14807 = (state_15145[(42)]);
var inst_14800 = (state_15145[(43)]);
var inst_14921 = (state_15145[(44)]);
var inst_14965 = (state_15145[(45)]);
var inst_14959 = (state_15145[(9)]);
var inst_14876 = (state_15145[(46)]);
var inst_14894 = (state_15145[(47)]);
var inst_14922 = (state_15145[(48)]);
var inst_14994 = (function (){var no_filter_QMARK_ = inst_14959;
var t = inst_14939;
var max_limit_QMARK_ = inst_14933;
var next_node = inst_14962;
var fast_forward_db_QMARK_ = inst_14944;
var s1 = inst_14822;
var o2 = inst_14885;
var t1 = inst_14799;
var predicate_fn = inst_14812;
var i = inst_14964;
var vec__14791 = inst_14864;
var m1 = inst_14912;
var root_node = inst_14949;
var s2 = inst_14831;
var p2 = inst_14903;
var permissions = inst_14934;
var limit = inst_14932;
var map__14794 = inst_14925;
var start_flake = inst_14922;
var vec__14788 = inst_14863;
var flake_limit = inst_14926;
var offset = inst_14963;
var acc = inst_14966;
var vec__14784 = inst_14802;
var t2 = inst_14806;
var G__14973 = inst_14992;
var op1 = inst_14800;
var o1 = inst_14876;
var end_flake = inst_14923;
var map__14787 = inst_14810;
var base_result = inst_14972;
var s = inst_14965;
var node_start = inst_14953;
var p1 = inst_14894;
var subject_fn = inst_14811;
var vec__14781 = inst_14795;
var object_fn = inst_14867;
var idx_compare = inst_14938;
var op2 = inst_14807;
var m2 = inst_14921;
var novelty = inst_14943;
return (function (p1__14765_SHARP_){
return object_fn.call(null,p1__14765_SHARP_.o);
});
})();
var inst_14995 = cljs.core.filter.call(null,inst_14994,inst_14992);
var state_15145__$1 = state_15145;
var statearr_15325_15482 = state_15145__$1;
(statearr_15325_15482[(2)] = inst_14995);

(statearr_15325_15482[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (37))){
var state_15145__$1 = state_15145;
var statearr_15326_15483 = state_15145__$1;
(statearr_15326_15483[(2)] = (-1));

(statearr_15326_15483[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (63))){
var inst_14903 = (state_15145[(15)]);
var inst_14831 = (state_15145[(21)]);
var inst_14822 = (state_15145[(38)]);
var inst_14934 = (state_15145[(41)]);
var inst_14894 = (state_15145[(47)]);
var inst_14956 = fluree.db.permissions_validate.no_filter_QMARK_.call(null,inst_14934,inst_14822,inst_14831,inst_14894,inst_14903);
var state_15145__$1 = state_15145;
var statearr_15327_15484 = state_15145__$1;
(statearr_15327_15484[(2)] = inst_14956);

(statearr_15327_15484[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (94))){
var inst_15095 = (state_15145[(2)]);
var state_15145__$1 = state_15145;
var statearr_15328_15485 = state_15145__$1;
(statearr_15328_15485[(2)] = inst_15095);

(statearr_15328_15485[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (8))){
var inst_14803 = (state_15145[(84)]);
var inst_14822 = (state_15145[(2)]);
var inst_14823 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14803);
var state_15145__$1 = (function (){var statearr_15329 = state_15145;
(statearr_15329[(38)] = inst_14822);

return statearr_15329;
})();
if(inst_14823){
var statearr_15330_15486 = state_15145__$1;
(statearr_15330_15486[(1)] = (10));

} else {
var statearr_15331_15487 = state_15145__$1;
(statearr_15331_15487[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (49))){
var state_15145__$1 = state_15145;
var statearr_15332_15488 = state_15145__$1;
(statearr_15332_15488[(2)] = fluree.db.util.core.min_integer);

(statearr_15332_15488[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15146 === (84))){
var inst_14933 = (state_15145[(33)]);
var state_15145__$1 = state_15145;
var statearr_15333_15489 = state_15145__$1;
(statearr_15333_15489[(2)] = inst_14933);

(statearr_15333_15489[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2726__auto__ = null;
var fluree$db$query$range$state_machine__2726__auto____0 = (function (){
var statearr_15334 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15334[(0)] = fluree$db$query$range$state_machine__2726__auto__);

(statearr_15334[(1)] = (1));

return statearr_15334;
});
var fluree$db$query$range$state_machine__2726__auto____1 = (function (state_15145){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_15145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e15335){var ex__2729__auto__ = e15335;
var statearr_15336_15490 = state_15145;
(statearr_15336_15490[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_15145[(4)]))){
var statearr_15337_15491 = state_15145;
(statearr_15337_15491[(1)] = cljs.core.first.call(null,(state_15145[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15492 = state_15145;
state_15145 = G__15492;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2726__auto__ = function(state_15145){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2726__auto____1.call(this,state_15145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2726__auto____0;
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2726__auto____1;
return fluree$db$query$range$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_15338 = f__2749__auto__.call(null);
(statearr_15338[(6)] = c__2748__auto__);

return statearr_15338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_15548){
var state_val_15549 = (state_15548[(1)]);
if((state_val_15549 === (7))){
var inst_15512 = (state_15548[(7)]);
var inst_15522 = (state_15548[(8)]);
var inst_15520 = fluree.db.flake.Flake__GT_parts.call(null,inst_15512);
var inst_15521 = cljs.core.nth.call(null,inst_15520,(0),null);
var inst_15522__$1 = cljs.core.nth.call(null,inst_15520,(1),null);
var inst_15523 = cljs.core.nth.call(null,inst_15520,(2),null);
var inst_15524 = cljs.core.nth.call(null,inst_15520,(3),null);
var inst_15525 = cljs.core.nth.call(null,inst_15520,(4),null);
var inst_15526 = cljs.core.nth.call(null,inst_15520,(5),null);
var inst_15527 = fluree.db.dbproto._tag.call(null,db,inst_15523,inst_15522__$1);
var state_15548__$1 = (function (){var statearr_15550 = state_15548;
(statearr_15550[(8)] = inst_15522__$1);

(statearr_15550[(9)] = inst_15524);

(statearr_15550[(10)] = inst_15525);

(statearr_15550[(11)] = inst_15526);

(statearr_15550[(12)] = inst_15521);

return statearr_15550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15548__$1,(10),inst_15527);
} else {
if((state_val_15549 === (1))){
var inst_15500 = flakes;
var inst_15501 = cljs.core.seq.call(null,inst_15500);
var inst_15502 = cljs.core.first.call(null,inst_15501);
var inst_15503 = cljs.core.next.call(null,inst_15501);
var inst_15504 = cljs.core.PersistentVector.EMPTY;
var inst_15505 = inst_15500;
var inst_15506 = inst_15504;
var state_15548__$1 = (function (){var statearr_15551 = state_15548;
(statearr_15551[(13)] = inst_15506);

(statearr_15551[(14)] = inst_15505);

(statearr_15551[(15)] = inst_15503);

(statearr_15551[(16)] = inst_15502);

return statearr_15551;
})();
var statearr_15552_15570 = state_15548__$1;
(statearr_15552_15570[(2)] = null);

(statearr_15552_15570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (4))){
var inst_15512 = (state_15548[(7)]);
var inst_15515 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_15512);
var state_15548__$1 = state_15548;
if(inst_15515){
var statearr_15553_15571 = state_15548__$1;
(statearr_15553_15571[(1)] = (7));

} else {
var statearr_15554_15572 = state_15548__$1;
(statearr_15554_15572[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (6))){
var inst_15544 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15555_15573 = state_15548__$1;
(statearr_15555_15573[(2)] = inst_15544);

(statearr_15555_15573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (3))){
var inst_15546 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15548__$1,inst_15546);
} else {
if((state_val_15549 === (2))){
var inst_15512 = (state_15548[(7)]);
var inst_15505 = (state_15548[(14)]);
var inst_15511 = cljs.core.seq.call(null,inst_15505);
var inst_15512__$1 = cljs.core.first.call(null,inst_15511);
var inst_15513 = cljs.core.next.call(null,inst_15511);
var state_15548__$1 = (function (){var statearr_15556 = state_15548;
(statearr_15556[(7)] = inst_15512__$1);

(statearr_15556[(17)] = inst_15513);

return statearr_15556;
})();
if(cljs.core.truth_(inst_15512__$1)){
var statearr_15557_15574 = state_15548__$1;
(statearr_15557_15574[(1)] = (4));

} else {
var statearr_15558_15575 = state_15548__$1;
(statearr_15558_15575[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (9))){
var inst_15541 = (state_15548[(2)]);
var state_15548__$1 = state_15548;
var statearr_15559_15576 = state_15548__$1;
(statearr_15559_15576[(2)] = inst_15541);

(statearr_15559_15576[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (5))){
var inst_15506 = (state_15548[(13)]);
var state_15548__$1 = state_15548;
var statearr_15560_15577 = state_15548__$1;
(statearr_15560_15577[(2)] = inst_15506);

(statearr_15560_15577[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (10))){
var inst_15522 = (state_15548[(8)]);
var inst_15506 = (state_15548[(13)]);
var inst_15524 = (state_15548[(9)]);
var inst_15513 = (state_15548[(17)]);
var inst_15525 = (state_15548[(10)]);
var inst_15526 = (state_15548[(11)]);
var inst_15521 = (state_15548[(12)]);
var inst_15529 = (state_15548[(2)]);
var inst_15530 = fluree.db.util.async.throw_err.call(null,inst_15529);
var inst_15531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15532 = [inst_15521,inst_15522,inst_15530,inst_15524,inst_15525,inst_15526];
var inst_15533 = (new cljs.core.PersistentVector(null,6,(5),inst_15531,inst_15532,null));
var inst_15534 = fluree.db.flake.parts__GT_Flake.call(null,inst_15533);
var inst_15535 = cljs.core.conj.call(null,inst_15506,inst_15534);
var inst_15505 = inst_15513;
var inst_15506__$1 = inst_15535;
var state_15548__$1 = (function (){var statearr_15561 = state_15548;
(statearr_15561[(13)] = inst_15506__$1);

(statearr_15561[(14)] = inst_15505);

return statearr_15561;
})();
var statearr_15562_15578 = state_15548__$1;
(statearr_15562_15578[(2)] = null);

(statearr_15562_15578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15549 === (8))){
var inst_15512 = (state_15548[(7)]);
var inst_15506 = (state_15548[(13)]);
var inst_15513 = (state_15548[(17)]);
var inst_15538 = cljs.core.conj.call(null,inst_15506,inst_15512);
var inst_15505 = inst_15513;
var inst_15506__$1 = inst_15538;
var state_15548__$1 = (function (){var statearr_15563 = state_15548;
(statearr_15563[(13)] = inst_15506__$1);

(statearr_15563[(14)] = inst_15505);

return statearr_15563;
})();
var statearr_15564_15579 = state_15548__$1;
(statearr_15564_15579[(2)] = null);

(statearr_15564_15579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto____0 = (function (){
var statearr_15565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15565[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto__);

(statearr_15565[(1)] = (1));

return statearr_15565;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto____1 = (function (state_15548){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_15548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e15566){var ex__2729__auto__ = e15566;
var statearr_15567_15580 = state_15548;
(statearr_15567_15580[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_15548[(4)]))){
var statearr_15568_15581 = state_15548;
(statearr_15568_15581[(1)] = cljs.core.first.call(null,(state_15548[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15582 = state_15548;
state_15548 = G__15582;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto__ = function(state_15548){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto____1.call(this,state_15548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_15569 = f__2749__auto__.call(null);
(statearr_15569[(6)] = c__2748__auto__);

return statearr_15569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15584 = arguments.length;
switch (G__15584) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_15754){
var state_val_15755 = (state_15754[(1)]);
if((state_val_15755 === (65))){
var state_15754__$1 = state_15754;
var statearr_15756_15856 = state_15754__$1;
(statearr_15756_15856[(2)] = null);

(statearr_15756_15856[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (70))){
var inst_15749 = (state_15754[(2)]);
var _ = (function (){var statearr_15757 = state_15754;
(statearr_15757[(4)] = cljs.core.rest.call(null,(state_15754[(4)])));

return statearr_15757;
})();
var state_15754__$1 = state_15754;
var statearr_15758_15857 = state_15754__$1;
(statearr_15758_15857[(2)] = inst_15749);

(statearr_15758_15857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (62))){
var inst_15735 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15759_15858 = state_15754__$1;
(statearr_15759_15858[(2)] = inst_15735);

(statearr_15759_15858[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (7))){
var state_15754__$1 = state_15754;
var statearr_15760_15859 = state_15754__$1;
(statearr_15760_15859[(2)] = false);

(statearr_15760_15859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (59))){
var inst_15709 = (state_15754[(2)]);
var inst_15710 = fluree.db.util.async.throw_err.call(null,inst_15709);
var state_15754__$1 = state_15754;
var statearr_15761_15860 = state_15754__$1;
(statearr_15761_15860[(2)] = inst_15710);

(statearr_15761_15860[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (20))){
var state_15754__$1 = state_15754;
var statearr_15762_15861 = state_15754__$1;
(statearr_15762_15861[(2)] = null);

(statearr_15762_15861[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (58))){
var inst_15699 = (state_15754[(2)]);
var inst_15700 = fluree.db.util.async.throw_err.call(null,inst_15699);
var inst_15701 = cljs.core.take.call(null,(1),inst_15700);
var state_15754__$1 = state_15754;
var statearr_15763_15862 = state_15754__$1;
(statearr_15763_15862[(2)] = inst_15701);

(statearr_15763_15862[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (60))){
var inst_15595 = (state_15754[(7)]);
var inst_15598 = (state_15754[(8)]);
var inst_15635 = (state_15754[(9)]);
var inst_15596 = (state_15754[(10)]);
var inst_15715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15716 = [inst_15596,inst_15595,inst_15635,inst_15598];
var inst_15717 = (new cljs.core.PersistentVector(null,4,(5),inst_15715,inst_15716,null));
var inst_15718 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15717,opts);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(63),inst_15718);
} else {
if((state_val_15755 === (27))){
var inst_15646 = (state_15754[(11)]);
var inst_15635 = (state_15754[(9)]);
var inst_15646__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_15635);
var state_15754__$1 = (function (){var statearr_15764 = state_15754;
(statearr_15764[(11)] = inst_15646__$1);

return statearr_15764;
})();
if(inst_15646__$1){
var statearr_15765_15863 = state_15754__$1;
(statearr_15765_15863[(1)] = (30));

} else {
var statearr_15766_15864 = state_15754__$1;
(statearr_15766_15864[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (1))){
var state_15754__$1 = state_15754;
var statearr_15767_15865 = state_15754__$1;
(statearr_15767_15865[(2)] = null);

(statearr_15767_15865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (69))){
var inst_15741 = (state_15754[(12)]);
var state_15754__$1 = state_15754;
var statearr_15768_15866 = state_15754__$1;
(statearr_15768_15866[(2)] = inst_15741);

(statearr_15768_15866[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (24))){
var inst_15596 = (state_15754[(10)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15596)){
var statearr_15769_15867 = state_15754__$1;
(statearr_15769_15867[(1)] = (27));

} else {
var statearr_15770_15868 = state_15754__$1;
(statearr_15770_15868[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (55))){
var inst_15635 = (state_15754[(9)]);
var inst_15693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15694 = [inst_15635];
var inst_15695 = (new cljs.core.PersistentVector(null,1,(5),inst_15693,inst_15694,null));
var inst_15696 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15697 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15695,inst_15696);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(58),inst_15697);
} else {
if((state_val_15755 === (39))){
var inst_15666 = (state_15754[(2)]);
var inst_15667 = fluree.db.util.async.throw_err.call(null,inst_15666);
var state_15754__$1 = state_15754;
var statearr_15771_15869 = state_15754__$1;
(statearr_15771_15869[(2)] = inst_15667);

(statearr_15771_15869[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (46))){
var inst_15679 = (state_15754[(13)]);
var inst_15679__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15754__$1 = (function (){var statearr_15772 = state_15754;
(statearr_15772[(13)] = inst_15679__$1);

return statearr_15772;
})();
if(cljs.core.truth_(inst_15679__$1)){
var statearr_15773_15870 = state_15754__$1;
(statearr_15773_15870[(1)] = (49));

} else {
var statearr_15774_15871 = state_15754__$1;
(statearr_15774_15871[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (4))){
var inst_15585 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15775_15872 = state_15754__$1;
(statearr_15775_15872[(2)] = inst_15585);

(statearr_15775_15872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (54))){
var inst_15691 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15691)){
var statearr_15776_15873 = state_15754__$1;
(statearr_15776_15873[(1)] = (55));

} else {
var statearr_15777_15874 = state_15754__$1;
(statearr_15777_15874[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (15))){
var inst_15597 = (state_15754[(14)]);
var inst_15616 = fluree.db.dbproto._tag_id.call(null,db,inst_15597);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(18),inst_15616);
} else {
if((state_val_15755 === (48))){
var inst_15737 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15778_15875 = state_15754__$1;
(statearr_15778_15875[(2)] = inst_15737);

(statearr_15778_15875[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (50))){
var inst_15594 = (state_15754[(15)]);
var inst_15610 = (state_15754[(16)]);
var inst_15679 = (state_15754[(13)]);
var inst_15595 = (state_15754[(7)]);
var inst_15598 = (state_15754[(8)]);
var inst_15635 = (state_15754[(9)]);
var inst_15596 = (state_15754[(10)]);
var inst_15605 = (state_15754[(17)]);
var inst_15599 = (state_15754[(18)]);
var inst_15683 = (function (){var t = inst_15598;
var p = inst_15596;
var idx_predicate_QMARK_ = inst_15599;
var o = inst_15635;
var tag_predicate_QMARK_ = inst_15605;
var temp__5751__auto__ = inst_15679;
var vec__15591 = inst_15594;
var s = inst_15595;
var o_coerce_QMARK_ = inst_15610;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_15754__$1 = state_15754;
var statearr_15779_15876 = state_15754__$1;
(statearr_15779_15876[(2)] = inst_15683);

(statearr_15779_15876[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (21))){
var inst_15631 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15780_15877 = state_15754__$1;
(statearr_15780_15877[(2)] = inst_15631);

(statearr_15780_15877[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (31))){
var inst_15646 = (state_15754[(11)]);
var state_15754__$1 = state_15754;
var statearr_15781_15878 = state_15754__$1;
(statearr_15781_15878[(2)] = inst_15646);

(statearr_15781_15878[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (32))){
var inst_15656 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15782_15879 = state_15754__$1;
(statearr_15782_15879[(2)] = inst_15656);

(statearr_15782_15879[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (40))){
var inst_15670 = (state_15754[(19)]);
var inst_15599 = (state_15754[(18)]);
var inst_15670__$1 = cljs.core.not.call(null,inst_15599);
var state_15754__$1 = (function (){var statearr_15783 = state_15754;
(statearr_15783[(19)] = inst_15670__$1);

return statearr_15783;
})();
if(inst_15670__$1){
var statearr_15784_15880 = state_15754__$1;
(statearr_15784_15880[(1)] = (43));

} else {
var statearr_15785_15881 = state_15754__$1;
(statearr_15785_15881[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (56))){
var inst_15595 = (state_15754[(7)]);
var inst_15598 = (state_15754[(8)]);
var inst_15685 = (state_15754[(20)]);
var inst_15596 = (state_15754[(10)]);
var inst_15703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15704 = [inst_15596,inst_15595,null,inst_15598];
var inst_15705 = (new cljs.core.PersistentVector(null,4,(5),inst_15703,inst_15704,null));
var inst_15706 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15685);
var inst_15707 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15705,inst_15706);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(59),inst_15707);
} else {
if((state_val_15755 === (33))){
var inst_15635 = (state_15754[(9)]);
var inst_15649 = cljs.core.fn_QMARK_.call(null,inst_15635);
var inst_15650 = (!(inst_15649));
var state_15754__$1 = state_15754;
var statearr_15786_15882 = state_15754__$1;
(statearr_15786_15882[(2)] = inst_15650);

(statearr_15786_15882[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (13))){
var inst_15597 = (state_15754[(14)]);
var inst_15614 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_15597);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15614)){
var statearr_15787_15883 = state_15754__$1;
(statearr_15787_15883[(1)] = (15));

} else {
var statearr_15788_15884 = state_15754__$1;
(statearr_15788_15884[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (22))){
var inst_15627 = (state_15754[(2)]);
var inst_15628 = fluree.db.util.async.throw_err.call(null,inst_15627);
var state_15754__$1 = state_15754;
var statearr_15789_15885 = state_15754__$1;
(statearr_15789_15885[(2)] = inst_15628);

(statearr_15789_15885[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (36))){
var inst_15595 = (state_15754[(7)]);
var inst_15598 = (state_15754[(8)]);
var inst_15635 = (state_15754[(9)]);
var inst_15596 = (state_15754[(10)]);
var inst_15661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15662 = [inst_15596,inst_15635,inst_15595,inst_15598];
var inst_15663 = (new cljs.core.PersistentVector(null,4,(5),inst_15661,inst_15662,null));
var inst_15664 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15663,opts);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(39),inst_15664);
} else {
if((state_val_15755 === (41))){
var inst_15596 = (state_15754[(10)]);
var state_15754__$1 = state_15754;
var statearr_15790_15886 = state_15754__$1;
(statearr_15790_15886[(2)] = inst_15596);

(statearr_15790_15886[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (43))){
var inst_15635 = (state_15754[(9)]);
var state_15754__$1 = state_15754;
var statearr_15791_15887 = state_15754__$1;
(statearr_15791_15887[(2)] = inst_15635);

(statearr_15791_15887[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (61))){
var inst_15635 = (state_15754[(9)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15635)){
var statearr_15792_15888 = state_15754__$1;
(statearr_15792_15888[(1)] = (64));

} else {
var statearr_15793_15889 = state_15754__$1;
(statearr_15793_15889[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (29))){
var inst_15659 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15659)){
var statearr_15794_15890 = state_15754__$1;
(statearr_15794_15890[(1)] = (36));

} else {
var statearr_15795_15891 = state_15754__$1;
(statearr_15795_15891[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (44))){
var inst_15670 = (state_15754[(19)]);
var state_15754__$1 = state_15754;
var statearr_15796_15892 = state_15754__$1;
(statearr_15796_15892[(2)] = inst_15670);

(statearr_15796_15892[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (6))){
var inst_15596 = (state_15754[(10)]);
var inst_15601 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15596);
var inst_15602 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15601);
var state_15754__$1 = state_15754;
var statearr_15797_15893 = state_15754__$1;
(statearr_15797_15893[(2)] = inst_15602);

(statearr_15797_15893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (28))){
var inst_15596 = (state_15754[(10)]);
var state_15754__$1 = state_15754;
var statearr_15798_15894 = state_15754__$1;
(statearr_15798_15894[(2)] = inst_15596);

(statearr_15798_15894[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (64))){
var inst_15595 = (state_15754[(7)]);
var inst_15598 = (state_15754[(8)]);
var inst_15635 = (state_15754[(9)]);
var inst_15596 = (state_15754[(10)]);
var inst_15724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15725 = [inst_15635,inst_15596,inst_15595,inst_15598];
var inst_15726 = (new cljs.core.PersistentVector(null,4,(5),inst_15724,inst_15725,null));
var inst_15727 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15726,opts);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(67),inst_15727);
} else {
if((state_val_15755 === (51))){
var inst_15596 = (state_15754[(10)]);
var inst_15686 = (state_15754[(21)]);
var inst_15685 = (state_15754[(2)]);
var inst_15686__$1 = cljs.core._EQ_.call(null,"_id",inst_15596);
var state_15754__$1 = (function (){var statearr_15799 = state_15754;
(statearr_15799[(20)] = inst_15685);

(statearr_15799[(21)] = inst_15686__$1);

return statearr_15799;
})();
if(inst_15686__$1){
var statearr_15800_15895 = state_15754__$1;
(statearr_15800_15895[(1)] = (52));

} else {
var statearr_15801_15896 = state_15754__$1;
(statearr_15801_15896[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (25))){
var inst_15605 = (state_15754[(17)]);
var inst_15741 = (state_15754[(2)]);
var state_15754__$1 = (function (){var statearr_15802 = state_15754;
(statearr_15802[(12)] = inst_15741);

return statearr_15802;
})();
if(cljs.core.truth_(inst_15605)){
var statearr_15803_15897 = state_15754__$1;
(statearr_15803_15897[(1)] = (68));

} else {
var statearr_15804_15898 = state_15754__$1;
(statearr_15804_15898[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (34))){
var inst_15599 = (state_15754[(18)]);
var state_15754__$1 = state_15754;
var statearr_15805_15899 = state_15754__$1;
(statearr_15805_15899[(2)] = inst_15599);

(statearr_15805_15899[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (17))){
var inst_15633 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15806_15900 = state_15754__$1;
(statearr_15806_15900[(2)] = inst_15633);

(statearr_15806_15900[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (3))){
var inst_15752 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15754__$1,inst_15752);
} else {
if((state_val_15755 === (12))){
var inst_15597 = (state_15754[(14)]);
var state_15754__$1 = state_15754;
var statearr_15807_15901 = state_15754__$1;
(statearr_15807_15901[(2)] = inst_15597);

(statearr_15807_15901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (2))){
var inst_15594 = (state_15754[(15)]);
var inst_15596 = (state_15754[(10)]);
var _ = (function (){var statearr_15808 = state_15754;
(statearr_15808[(4)] = cljs.core.cons.call(null,(5),(state_15754[(4)])));

return statearr_15808;
})();
var inst_15594__$1 = fparts;
var inst_15595 = cljs.core.nth.call(null,inst_15594__$1,(0),null);
var inst_15596__$1 = cljs.core.nth.call(null,inst_15594__$1,(1),null);
var inst_15597 = cljs.core.nth.call(null,inst_15594__$1,(2),null);
var inst_15598 = cljs.core.nth.call(null,inst_15594__$1,(3),null);
var inst_15599 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15596__$1);
var state_15754__$1 = (function (){var statearr_15809 = state_15754;
(statearr_15809[(15)] = inst_15594__$1);

(statearr_15809[(14)] = inst_15597);

(statearr_15809[(7)] = inst_15595);

(statearr_15809[(8)] = inst_15598);

(statearr_15809[(10)] = inst_15596__$1);

(statearr_15809[(18)] = inst_15599);

return statearr_15809;
})();
if(cljs.core.truth_(inst_15596__$1)){
var statearr_15810_15902 = state_15754__$1;
(statearr_15810_15902[(1)] = (6));

} else {
var statearr_15811_15903 = state_15754__$1;
(statearr_15811_15903[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (66))){
var inst_15733 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15812_15904 = state_15754__$1;
(statearr_15812_15904[(2)] = inst_15733);

(statearr_15812_15904[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (23))){
var inst_15595 = (state_15754[(7)]);
var inst_15598 = (state_15754[(8)]);
var inst_15635 = (state_15754[(9)]);
var inst_15596 = (state_15754[(10)]);
var inst_15637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15638 = [inst_15595,inst_15596,inst_15635,inst_15598];
var inst_15639 = (new cljs.core.PersistentVector(null,4,(5),inst_15637,inst_15638,null));
var inst_15640 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15639,opts);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(26),inst_15640);
} else {
if((state_val_15755 === (47))){
var inst_15596 = (state_15754[(10)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15596)){
var statearr_15813_15905 = state_15754__$1;
(statearr_15813_15905[(1)] = (60));

} else {
var statearr_15814_15906 = state_15754__$1;
(statearr_15814_15906[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (35))){
var inst_15653 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15815_15907 = state_15754__$1;
(statearr_15815_15907[(2)] = inst_15653);

(statearr_15815_15907[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (19))){
var inst_15597 = (state_15754[(14)]);
var inst_15596 = (state_15754[(10)]);
var inst_15623 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15596);
var inst_15624 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15623),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15597)].join('');
var inst_15625 = fluree.db.dbproto._tag_id.call(null,db,inst_15624);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(22),inst_15625);
} else {
if((state_val_15755 === (57))){
var inst_15712 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15816_15908 = state_15754__$1;
(statearr_15816_15908[(2)] = inst_15712);

(statearr_15816_15908[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (68))){
var inst_15741 = (state_15754[(12)]);
var inst_15743 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_15741);
var state_15754__$1 = state_15754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15754__$1,(71),inst_15743);
} else {
if((state_val_15755 === (11))){
var inst_15610 = (state_15754[(16)]);
var inst_15610__$1 = (state_15754[(2)]);
var inst_15611 = cljs.core.not.call(null,inst_15610__$1);
var state_15754__$1 = (function (){var statearr_15818 = state_15754;
(statearr_15818[(16)] = inst_15610__$1);

return statearr_15818;
})();
if(inst_15611){
var statearr_15819_15909 = state_15754__$1;
(statearr_15819_15909[(1)] = (12));

} else {
var statearr_15820_15910 = state_15754__$1;
(statearr_15820_15910[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (9))){
var inst_15597 = (state_15754[(14)]);
var inst_15607 = typeof inst_15597 === 'string';
var state_15754__$1 = state_15754;
var statearr_15821_15911 = state_15754__$1;
(statearr_15821_15911[(2)] = inst_15607);

(statearr_15821_15911[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (5))){
var _ = (function (){var statearr_15822 = state_15754;
(statearr_15822[(4)] = cljs.core.rest.call(null,(state_15754[(4)])));

return statearr_15822;
})();
var state_15754__$1 = state_15754;
var ex15817 = (state_15754__$1[(2)]);
var statearr_15823_15912 = state_15754__$1;
(statearr_15823_15912[(5)] = ex15817);


if((ex15817 instanceof Error)){
var statearr_15824_15913 = state_15754__$1;
(statearr_15824_15913[(1)] = (4));

(statearr_15824_15913[(5)] = null);

} else {
throw ex15817;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (14))){
var inst_15595 = (state_15754[(7)]);
var inst_15635 = (state_15754[(2)]);
var state_15754__$1 = (function (){var statearr_15825 = state_15754;
(statearr_15825[(9)] = inst_15635);

return statearr_15825;
})();
if(cljs.core.truth_(inst_15595)){
var statearr_15826_15914 = state_15754__$1;
(statearr_15826_15914[(1)] = (23));

} else {
var statearr_15827_15915 = state_15754__$1;
(statearr_15827_15915[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (45))){
var inst_15674 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15828_15916 = state_15754__$1;
(statearr_15828_15916[(2)] = inst_15674);

(statearr_15828_15916[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (53))){
var inst_15686 = (state_15754[(21)]);
var state_15754__$1 = state_15754;
var statearr_15829_15917 = state_15754__$1;
(statearr_15829_15917[(2)] = inst_15686);

(statearr_15829_15917[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (26))){
var inst_15642 = (state_15754[(2)]);
var inst_15643 = fluree.db.util.async.throw_err.call(null,inst_15642);
var state_15754__$1 = state_15754;
var statearr_15830_15918 = state_15754__$1;
(statearr_15830_15918[(2)] = inst_15643);

(statearr_15830_15918[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (16))){
var inst_15597 = (state_15754[(14)]);
var inst_15621 = typeof inst_15597 === 'string';
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15621)){
var statearr_15831_15919 = state_15754__$1;
(statearr_15831_15919[(1)] = (19));

} else {
var statearr_15832_15920 = state_15754__$1;
(statearr_15832_15920[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (38))){
var inst_15739 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
var statearr_15833_15921 = state_15754__$1;
(statearr_15833_15921[(2)] = inst_15739);

(statearr_15833_15921[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (30))){
var inst_15599 = (state_15754[(18)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15599)){
var statearr_15834_15922 = state_15754__$1;
(statearr_15834_15922[(1)] = (33));

} else {
var statearr_15835_15923 = state_15754__$1;
(statearr_15835_15923[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (10))){
var inst_15605 = (state_15754[(17)]);
var state_15754__$1 = state_15754;
var statearr_15836_15924 = state_15754__$1;
(statearr_15836_15924[(2)] = inst_15605);

(statearr_15836_15924[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (18))){
var inst_15618 = (state_15754[(2)]);
var inst_15619 = fluree.db.util.async.throw_err.call(null,inst_15618);
var state_15754__$1 = state_15754;
var statearr_15837_15925 = state_15754__$1;
(statearr_15837_15925[(2)] = inst_15619);

(statearr_15837_15925[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (52))){
var inst_15635 = (state_15754[(9)]);
var inst_15688 = cljs.core.int_QMARK_.call(null,inst_15635);
var state_15754__$1 = state_15754;
var statearr_15838_15926 = state_15754__$1;
(statearr_15838_15926[(2)] = inst_15688);

(statearr_15838_15926[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (67))){
var inst_15729 = (state_15754[(2)]);
var inst_15730 = fluree.db.util.async.throw_err.call(null,inst_15729);
var state_15754__$1 = state_15754;
var statearr_15839_15927 = state_15754__$1;
(statearr_15839_15927[(2)] = inst_15730);

(statearr_15839_15927[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (71))){
var inst_15745 = (state_15754[(2)]);
var inst_15746 = fluree.db.util.async.throw_err.call(null,inst_15745);
var state_15754__$1 = state_15754;
var statearr_15840_15928 = state_15754__$1;
(statearr_15840_15928[(2)] = inst_15746);

(statearr_15840_15928[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (42))){
var inst_15677 = (state_15754[(2)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15677)){
var statearr_15841_15929 = state_15754__$1;
(statearr_15841_15929[(1)] = (46));

} else {
var statearr_15842_15930 = state_15754__$1;
(statearr_15842_15930[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (37))){
var inst_15596 = (state_15754[(10)]);
var state_15754__$1 = state_15754;
if(cljs.core.truth_(inst_15596)){
var statearr_15843_15931 = state_15754__$1;
(statearr_15843_15931[(1)] = (40));

} else {
var statearr_15844_15932 = state_15754__$1;
(statearr_15844_15932[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (63))){
var inst_15720 = (state_15754[(2)]);
var inst_15721 = fluree.db.util.async.throw_err.call(null,inst_15720);
var state_15754__$1 = state_15754;
var statearr_15845_15933 = state_15754__$1;
(statearr_15845_15933[(2)] = inst_15721);

(statearr_15845_15933[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (8))){
var inst_15605 = (state_15754[(17)]);
var inst_15605__$1 = (state_15754[(2)]);
var state_15754__$1 = (function (){var statearr_15846 = state_15754;
(statearr_15846[(17)] = inst_15605__$1);

return statearr_15846;
})();
if(cljs.core.truth_(inst_15605__$1)){
var statearr_15847_15934 = state_15754__$1;
(statearr_15847_15934[(1)] = (9));

} else {
var statearr_15848_15935 = state_15754__$1;
(statearr_15848_15935[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15755 === (49))){
var inst_15594 = (state_15754[(15)]);
var inst_15610 = (state_15754[(16)]);
var inst_15679 = (state_15754[(13)]);
var inst_15595 = (state_15754[(7)]);
var inst_15598 = (state_15754[(8)]);
var inst_15635 = (state_15754[(9)]);
var inst_15596 = (state_15754[(10)]);
var inst_15605 = (state_15754[(17)]);
var inst_15599 = (state_15754[(18)]);
var inst_15681 = (function (){var obj_fn = inst_15679;
var t = inst_15598;
var p = inst_15596;
var idx_predicate_QMARK_ = inst_15599;
var o = inst_15635;
var tag_predicate_QMARK_ = inst_15605;
var temp__5751__auto__ = inst_15679;
var vec__15591 = inst_15594;
var s = inst_15595;
var o_coerce_QMARK_ = inst_15610;
return (function (x){
var and__4221__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4221__auto__;
}
});
})();
var state_15754__$1 = state_15754;
var statearr_15849_15936 = state_15754__$1;
(statearr_15849_15936[(2)] = inst_15681);

(statearr_15849_15936[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2726__auto__ = null;
var fluree$db$query$range$state_machine__2726__auto____0 = (function (){
var statearr_15850 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15850[(0)] = fluree$db$query$range$state_machine__2726__auto__);

(statearr_15850[(1)] = (1));

return statearr_15850;
});
var fluree$db$query$range$state_machine__2726__auto____1 = (function (state_15754){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_15754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e15851){var ex__2729__auto__ = e15851;
var statearr_15852_15937 = state_15754;
(statearr_15852_15937[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_15754[(4)]))){
var statearr_15853_15938 = state_15754;
(statearr_15853_15938[(1)] = cljs.core.first.call(null,(state_15754[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15939 = state_15754;
state_15754 = G__15939;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2726__auto__ = function(state_15754){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2726__auto____1.call(this,state_15754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2726__auto____0;
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2726__auto____1;
return fluree$db$query$range$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_15854 = f__2749__auto__.call(null);
(statearr_15854[(6)] = c__2748__auto__);

return statearr_15854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15941 = arguments.length;
switch (G__15941) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_15976){
var state_val_15977 = (state_15976[(1)]);
if((state_val_15977 === (7))){
var inst_15963 = cljs.core.pr_str.call(null,name);
var inst_15964 = ["Invalid collection name: ",inst_15963].join('');
var inst_15965 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15966 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15967 = cljs.core.PersistentHashMap.fromArrays(inst_15965,inst_15966);
var inst_15968 = cljs.core.ex_info.call(null,inst_15964,inst_15967);
var inst_15969 = (function(){throw inst_15968})();
var state_15976__$1 = state_15976;
var statearr_15978_15998 = state_15976__$1;
(statearr_15978_15998[(2)] = inst_15969);

(statearr_15978_15998[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15977 === (1))){
var state_15976__$1 = state_15976;
var statearr_15979_15999 = state_15976__$1;
(statearr_15979_15999[(2)] = null);

(statearr_15979_15999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15977 === (4))){
var inst_15942 = (state_15976[(2)]);
var state_15976__$1 = state_15976;
var statearr_15980_16000 = state_15976__$1;
(statearr_15980_16000[(2)] = inst_15942);

(statearr_15980_16000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15977 === (6))){
var inst_15948 = (state_15976[(7)]);
var inst_15950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15951 = fluree.db.flake.max_subject_id.call(null,inst_15948);
var inst_15952 = [inst_15951];
var inst_15953 = (new cljs.core.PersistentVector(null,1,(5),inst_15950,inst_15952,null));
var inst_15954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15955 = fluree.db.flake.min_subject_id.call(null,inst_15948);
var inst_15956 = [inst_15955];
var inst_15957 = (new cljs.core.PersistentVector(null,1,(5),inst_15954,inst_15956,null));
var inst_15958 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15953,cljs.core._LT__EQ_,inst_15957,opts);
var state_15976__$1 = state_15976;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15976__$1,(9),inst_15958);
} else {
if((state_val_15977 === (3))){
var inst_15974 = (state_15976[(2)]);
var state_15976__$1 = state_15976;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15976__$1,inst_15974);
} else {
if((state_val_15977 === (2))){
var inst_15948 = (state_15976[(7)]);
var _ = (function (){var statearr_15982 = state_15976;
(statearr_15982[(4)] = cljs.core.cons.call(null,(5),(state_15976[(4)])));

return statearr_15982;
})();
var inst_15948__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_15976__$1 = (function (){var statearr_15983 = state_15976;
(statearr_15983[(7)] = inst_15948__$1);

return statearr_15983;
})();
if(cljs.core.truth_(inst_15948__$1)){
var statearr_15984_16001 = state_15976__$1;
(statearr_15984_16001[(1)] = (6));

} else {
var statearr_15985_16002 = state_15976__$1;
(statearr_15985_16002[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15977 === (9))){
var inst_15960 = (state_15976[(2)]);
var inst_15961 = fluree.db.util.async.throw_err.call(null,inst_15960);
var state_15976__$1 = state_15976;
var statearr_15986_16003 = state_15976__$1;
(statearr_15986_16003[(2)] = inst_15961);

(statearr_15986_16003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15977 === (5))){
var _ = (function (){var statearr_15987 = state_15976;
(statearr_15987[(4)] = cljs.core.rest.call(null,(state_15976[(4)])));

return statearr_15987;
})();
var state_15976__$1 = state_15976;
var ex15981 = (state_15976__$1[(2)]);
var statearr_15988_16004 = state_15976__$1;
(statearr_15988_16004[(5)] = ex15981);


var statearr_15989_16005 = state_15976__$1;
(statearr_15989_16005[(1)] = (4));

(statearr_15989_16005[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15977 === (8))){
var inst_15971 = (state_15976[(2)]);
var _ = (function (){var statearr_15990 = state_15976;
(statearr_15990[(4)] = cljs.core.rest.call(null,(state_15976[(4)])));

return statearr_15990;
})();
var state_15976__$1 = state_15976;
var statearr_15991_16006 = state_15976__$1;
(statearr_15991_16006[(2)] = inst_15971);

(statearr_15991_16006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2726__auto__ = null;
var fluree$db$query$range$state_machine__2726__auto____0 = (function (){
var statearr_15992 = [null,null,null,null,null,null,null,null];
(statearr_15992[(0)] = fluree$db$query$range$state_machine__2726__auto__);

(statearr_15992[(1)] = (1));

return statearr_15992;
});
var fluree$db$query$range$state_machine__2726__auto____1 = (function (state_15976){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_15976);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e15993){var ex__2729__auto__ = e15993;
var statearr_15994_16007 = state_15976;
(statearr_15994_16007[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_15976[(4)]))){
var statearr_15995_16008 = state_15976;
(statearr_15995_16008[(1)] = cljs.core.first.call(null,(state_15976[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16009 = state_15976;
state_15976 = G__16009;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2726__auto__ = function(state_15976){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2726__auto____1.call(this,state_15976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2726__auto____0;
fluree$db$query$range$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2726__auto____1;
return fluree$db$query$range$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_15996 = f__2749__auto__.call(null);
(statearr_15996[(6)] = c__2748__auto__);

return statearr_15996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__16013 = flakes;
var vec__16014 = G__16013;
var seq__16015 = cljs.core.seq.call(null,vec__16014);
var first__16016 = cljs.core.first.call(null,seq__16015);
var seq__16015__$1 = cljs.core.next.call(null,seq__16015);
var flake_SINGLEQUOTE_ = first__16016;
var r = seq__16015__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16013__$1 = G__16013;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16022 = G__16013__$1;
var seq__16023 = cljs.core.seq.call(null,vec__16022);
var first__16024 = cljs.core.first.call(null,seq__16023);
var seq__16023__$1 = cljs.core.next.call(null,seq__16023);
var flake_SINGLEQUOTE___$1 = first__16024;
var r__$1 = seq__16023__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e16026){var e = e16026;
return null;
}})();
var map__16025 = cmd_map;
var map__16025__$1 = cljs.core.__destructure_map.call(null,map__16025);
var type = cljs.core.get.call(null,map__16025__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__16025__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__16025__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__16025__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__16025__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__16025__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16027 = r__$1;
var G__16028 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__16013__$1 = G__16027;
result_STAR___$1 = G__16028;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16037 = blocks;
var vec__16038 = G__16037;
var seq__16039 = cljs.core.seq.call(null,vec__16038);
var first__16040 = cljs.core.first.call(null,seq__16039);
var seq__16039__$1 = cljs.core.next.call(null,seq__16039);
var block_SINGLEQUOTE_ = first__16040;
var r = seq__16039__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16037__$1 = G__16037;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16045 = G__16037__$1;
var seq__16046 = cljs.core.seq.call(null,vec__16045);
var first__16047 = cljs.core.first.call(null,seq__16046);
var seq__16046__$1 = cljs.core.next.call(null,seq__16046);
var block_SINGLEQUOTE___$1 = first__16047;
var r__$1 = seq__16046__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16048 = block_SINGLEQUOTE___$1;
var map__16048__$1 = cljs.core.__destructure_map.call(null,map__16048);
var block = cljs.core.get.call(null,map__16048__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__16048__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__16048__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16029_SHARP_){
if(cljs.core._EQ_.call(null,p1__16029_SHARP_.p,(2))){
return p1__16029_SHARP_.o;
} else {
return null;
}
});})(G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16030_SHARP_){
if(cljs.core._EQ_.call(null,p1__16030_SHARP_.p,(1))){
return p1__16030_SHARP_.o;
} else {
return null;
}
});})(G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,hash,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16031_SHARP_){
if(cljs.core._EQ_.call(null,p1__16031_SHARP_.p,(5))){
return p1__16031_SHARP_.o;
} else {
return null;
}
});})(G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,hash,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,hash,instant,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16032_SHARP_){
if(cljs.core._EQ_.call(null,p1__16032_SHARP_.p,(7))){
return p1__16032_SHARP_.o;
} else {
return null;
}
});})(G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,hash,instant,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16033_SHARP_){
return cljs.core._EQ_.call(null,p1__16033_SHARP_.p,(106));
});})(G__16037__$1,result_STAR___$1,map__16048,map__16048__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16045,seq__16046,first__16047,seq__16046__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16037,vec__16038,seq__16039,first__16040,seq__16039__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__16049 = r__$1;
var G__16050 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16037__$1 = G__16049;
result_STAR___$1 = G__16050;
continue;
}
break;
}
});
