// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20424){
var state_val_20425 = (state_20424[(1)]);
if((state_val_20425 === (7))){
var inst_20413 = (state_20424[(7)]);
var inst_20415 = fluree.db.storage.core.serde.call(null,conn);
var inst_20416 = fluree.db.serde.protocol._deserialize_block.call(null,inst_20415,inst_20413);
var state_20424__$1 = state_20424;
var statearr_20426_20445 = state_20424__$1;
(statearr_20426_20445[(2)] = inst_20416);

(statearr_20426_20445[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20425 === (1))){
var state_20424__$1 = state_20424;
var statearr_20427_20446 = state_20424__$1;
(statearr_20427_20446[(2)] = null);

(statearr_20427_20446[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20425 === (4))){
var inst_20403 = (state_20424[(2)]);
var state_20424__$1 = state_20424;
var statearr_20428_20447 = state_20424__$1;
(statearr_20428_20447[(2)] = inst_20403);

(statearr_20428_20447[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20425 === (6))){
var inst_20413 = (state_20424[(7)]);
var inst_20412 = (state_20424[(2)]);
var inst_20413__$1 = fluree.db.util.async.throw_err.call(null,inst_20412);
var state_20424__$1 = (function (){var statearr_20429 = state_20424;
(statearr_20429[(7)] = inst_20413__$1);

return statearr_20429;
})();
if(cljs.core.truth_(inst_20413__$1)){
var statearr_20430_20448 = state_20424__$1;
(statearr_20430_20448[(1)] = (7));

} else {
var statearr_20431_20449 = state_20424__$1;
(statearr_20431_20449[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20425 === (3))){
var inst_20422 = (state_20424[(2)]);
var state_20424__$1 = state_20424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20424__$1,inst_20422);
} else {
if((state_val_20425 === (2))){
var _ = (function (){var statearr_20433 = state_20424;
(statearr_20433[(4)] = cljs.core.cons.call(null,(5),(state_20424[(4)])));

return statearr_20433;
})();
var inst_20409 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_20410 = fluree.db.storage.core.storage_read.call(null,conn,inst_20409);
var state_20424__$1 = state_20424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20424__$1,(6),inst_20410);
} else {
if((state_val_20425 === (9))){
var inst_20419 = (state_20424[(2)]);
var _ = (function (){var statearr_20434 = state_20424;
(statearr_20434[(4)] = cljs.core.rest.call(null,(state_20424[(4)])));

return statearr_20434;
})();
var state_20424__$1 = state_20424;
var statearr_20435_20450 = state_20424__$1;
(statearr_20435_20450[(2)] = inst_20419);

(statearr_20435_20450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20425 === (5))){
var _ = (function (){var statearr_20436 = state_20424;
(statearr_20436[(4)] = cljs.core.rest.call(null,(state_20424[(4)])));

return statearr_20436;
})();
var state_20424__$1 = state_20424;
var ex20432 = (state_20424__$1[(2)]);
var statearr_20437_20451 = state_20424__$1;
(statearr_20437_20451[(5)] = ex20432);


if((ex20432 instanceof Error)){
var statearr_20438_20452 = state_20424__$1;
(statearr_20438_20452[(1)] = (4));

(statearr_20438_20452[(5)] = null);

} else {
throw ex20432;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20425 === (8))){
var state_20424__$1 = state_20424;
var statearr_20439_20453 = state_20424__$1;
(statearr_20439_20453[(2)] = null);

(statearr_20439_20453[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2726__auto____0 = (function (){
var statearr_20440 = [null,null,null,null,null,null,null,null];
(statearr_20440[(0)] = fluree$db$storage$core$read_block_$_state_machine__2726__auto__);

(statearr_20440[(1)] = (1));

return statearr_20440;
});
var fluree$db$storage$core$read_block_$_state_machine__2726__auto____1 = (function (state_20424){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20441){var ex__2729__auto__ = e20441;
var statearr_20442_20454 = state_20424;
(statearr_20442_20454[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20424[(4)]))){
var statearr_20443_20455 = state_20424;
(statearr_20443_20455[(1)] = cljs.core.first.call(null,(state_20424[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20456 = state_20424;
state_20424 = G__20456;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2726__auto__ = function(state_20424){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2726__auto____1.call(this,state_20424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2726__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2726__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20444 = f__2749__auto__.call(null);
(statearr_20444[(6)] = c__2748__auto__);

return statearr_20444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20479){
var state_val_20480 = (state_20479[(1)]);
if((state_val_20480 === (7))){
var inst_20468 = (state_20479[(7)]);
var inst_20470 = fluree.db.storage.core.serde.call(null,conn);
var inst_20471 = fluree.db.serde.protocol._deserialize_block.call(null,inst_20470,inst_20468);
var state_20479__$1 = state_20479;
var statearr_20481_20500 = state_20479__$1;
(statearr_20481_20500[(2)] = inst_20471);

(statearr_20481_20500[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20480 === (1))){
var state_20479__$1 = state_20479;
var statearr_20482_20501 = state_20479__$1;
(statearr_20482_20501[(2)] = null);

(statearr_20482_20501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20480 === (4))){
var inst_20457 = (state_20479[(2)]);
var state_20479__$1 = state_20479;
var statearr_20483_20502 = state_20479__$1;
(statearr_20483_20502[(2)] = inst_20457);

(statearr_20483_20502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20480 === (6))){
var inst_20468 = (state_20479[(7)]);
var inst_20467 = (state_20479[(2)]);
var inst_20468__$1 = fluree.db.util.async.throw_err.call(null,inst_20467);
var state_20479__$1 = (function (){var statearr_20484 = state_20479;
(statearr_20484[(7)] = inst_20468__$1);

return statearr_20484;
})();
if(cljs.core.truth_(inst_20468__$1)){
var statearr_20485_20503 = state_20479__$1;
(statearr_20485_20503[(1)] = (7));

} else {
var statearr_20486_20504 = state_20479__$1;
(statearr_20486_20504[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20480 === (3))){
var inst_20477 = (state_20479[(2)]);
var state_20479__$1 = state_20479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20479__$1,inst_20477);
} else {
if((state_val_20480 === (2))){
var _ = (function (){var statearr_20488 = state_20479;
(statearr_20488[(4)] = cljs.core.cons.call(null,(5),(state_20479[(4)])));

return statearr_20488;
})();
var inst_20463 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_20464 = [inst_20463,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_20465 = fluree.db.storage.core.storage_read.call(null,conn,inst_20464);
var state_20479__$1 = state_20479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20479__$1,(6),inst_20465);
} else {
if((state_val_20480 === (9))){
var inst_20474 = (state_20479[(2)]);
var _ = (function (){var statearr_20489 = state_20479;
(statearr_20489[(4)] = cljs.core.rest.call(null,(state_20479[(4)])));

return statearr_20489;
})();
var state_20479__$1 = state_20479;
var statearr_20490_20505 = state_20479__$1;
(statearr_20490_20505[(2)] = inst_20474);

(statearr_20490_20505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20480 === (5))){
var _ = (function (){var statearr_20491 = state_20479;
(statearr_20491[(4)] = cljs.core.rest.call(null,(state_20479[(4)])));

return statearr_20491;
})();
var state_20479__$1 = state_20479;
var ex20487 = (state_20479__$1[(2)]);
var statearr_20492_20506 = state_20479__$1;
(statearr_20492_20506[(5)] = ex20487);


if((ex20487 instanceof Error)){
var statearr_20493_20507 = state_20479__$1;
(statearr_20493_20507[(1)] = (4));

(statearr_20493_20507[(5)] = null);

} else {
throw ex20487;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20480 === (8))){
var state_20479__$1 = state_20479;
var statearr_20494_20508 = state_20479__$1;
(statearr_20494_20508[(2)] = null);

(statearr_20494_20508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2726__auto____0 = (function (){
var statearr_20495 = [null,null,null,null,null,null,null,null];
(statearr_20495[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2726__auto__);

(statearr_20495[(1)] = (1));

return statearr_20495;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2726__auto____1 = (function (state_20479){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20496){var ex__2729__auto__ = e20496;
var statearr_20497_20509 = state_20479;
(statearr_20497_20509[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20479[(4)]))){
var statearr_20498_20510 = state_20479;
(statearr_20498_20510[(1)] = cljs.core.first.call(null,(state_20479[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20511 = state_20479;
state_20479 = G__20511;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2726__auto__ = function(state_20479){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2726__auto____1.call(this,state_20479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2726__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2726__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20499 = f__2749__auto__.call(null);
(statearr_20499[(6)] = c__2748__auto__);

return statearr_20499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20535){
var state_val_20536 = (state_20535[(1)]);
if((state_val_20536 === (1))){
var state_20535__$1 = state_20535;
var statearr_20537_20551 = state_20535__$1;
(statearr_20537_20551[(2)] = null);

(statearr_20537_20551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (2))){
var _ = (function (){var statearr_20538 = state_20535;
(statearr_20538[(4)] = cljs.core.cons.call(null,(5),(state_20535[(4)])));

return statearr_20538;
})();
var inst_20518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20519 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20520 = (new cljs.core.PersistentVector(null,3,(5),inst_20518,inst_20519,null));
var inst_20521 = cljs.core.select_keys.call(null,block_data,inst_20520);
var inst_20522 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20521);
var inst_20523 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_20522);
var inst_20524 = [inst_20523,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_20525 = fluree.db.storage.core.serde.call(null,conn);
var inst_20526 = fluree.db.serde.protocol._serialize_block.call(null,inst_20525,inst_20521);
var inst_20527 = fluree.db.storage.core.storage_write.call(null,conn,inst_20524,inst_20526);
var state_20535__$1 = state_20535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20535__$1,(6),inst_20527);
} else {
if((state_val_20536 === (3))){
var inst_20533 = (state_20535[(2)]);
var state_20535__$1 = state_20535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20535__$1,inst_20533);
} else {
if((state_val_20536 === (4))){
var inst_20512 = (state_20535[(2)]);
var state_20535__$1 = state_20535;
var statearr_20540_20552 = state_20535__$1;
(statearr_20540_20552[(2)] = inst_20512);

(statearr_20540_20552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (5))){
var _ = (function (){var statearr_20541 = state_20535;
(statearr_20541[(4)] = cljs.core.rest.call(null,(state_20535[(4)])));

return statearr_20541;
})();
var state_20535__$1 = state_20535;
var ex20539 = (state_20535__$1[(2)]);
var statearr_20542_20553 = state_20535__$1;
(statearr_20542_20553[(5)] = ex20539);


if((ex20539 instanceof Error)){
var statearr_20543_20554 = state_20535__$1;
(statearr_20543_20554[(1)] = (4));

(statearr_20543_20554[(5)] = null);

} else {
throw ex20539;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20536 === (6))){
var inst_20529 = (state_20535[(2)]);
var inst_20530 = fluree.db.util.async.throw_err.call(null,inst_20529);
var _ = (function (){var statearr_20544 = state_20535;
(statearr_20544[(4)] = cljs.core.rest.call(null,(state_20535[(4)])));

return statearr_20544;
})();
var state_20535__$1 = state_20535;
var statearr_20545_20555 = state_20535__$1;
(statearr_20545_20555[(2)] = inst_20530);

(statearr_20545_20555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2726__auto____0 = (function (){
var statearr_20546 = [null,null,null,null,null,null,null];
(statearr_20546[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2726__auto__);

(statearr_20546[(1)] = (1));

return statearr_20546;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2726__auto____1 = (function (state_20535){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20547){var ex__2729__auto__ = e20547;
var statearr_20548_20556 = state_20535;
(statearr_20548_20556[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20535[(4)]))){
var statearr_20549_20557 = state_20535;
(statearr_20549_20557[(1)] = cljs.core.first.call(null,(state_20535[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20558 = state_20535;
state_20535 = G__20558;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2726__auto__ = function(state_20535){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2726__auto____1.call(this,state_20535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2726__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2726__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20550 = f__2749__auto__.call(null);
(statearr_20550[(6)] = c__2748__auto__);

return statearr_20550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20581){
var state_val_20582 = (state_20581[(1)]);
if((state_val_20582 === (1))){
var state_20581__$1 = state_20581;
var statearr_20583_20597 = state_20581__$1;
(statearr_20583_20597[(2)] = null);

(statearr_20583_20597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (2))){
var _ = (function (){var statearr_20584 = state_20581;
(statearr_20584[(4)] = cljs.core.cons.call(null,(5),(state_20581[(4)])));

return statearr_20584;
})();
var inst_20565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20566 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20567 = (new cljs.core.PersistentVector(null,3,(5),inst_20565,inst_20566,null));
var inst_20568 = cljs.core.select_keys.call(null,block_data,inst_20567);
var inst_20569 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20568);
var inst_20570 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_20569);
var inst_20571 = fluree.db.storage.core.serde.call(null,conn);
var inst_20572 = fluree.db.serde.protocol._serialize_block.call(null,inst_20571,inst_20568);
var inst_20573 = fluree.db.storage.core.storage_write.call(null,conn,inst_20570,inst_20572);
var state_20581__$1 = state_20581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20581__$1,(6),inst_20573);
} else {
if((state_val_20582 === (3))){
var inst_20579 = (state_20581[(2)]);
var state_20581__$1 = state_20581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20581__$1,inst_20579);
} else {
if((state_val_20582 === (4))){
var inst_20559 = (state_20581[(2)]);
var state_20581__$1 = state_20581;
var statearr_20586_20598 = state_20581__$1;
(statearr_20586_20598[(2)] = inst_20559);

(statearr_20586_20598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (5))){
var _ = (function (){var statearr_20587 = state_20581;
(statearr_20587[(4)] = cljs.core.rest.call(null,(state_20581[(4)])));

return statearr_20587;
})();
var state_20581__$1 = state_20581;
var ex20585 = (state_20581__$1[(2)]);
var statearr_20588_20599 = state_20581__$1;
(statearr_20588_20599[(5)] = ex20585);


if((ex20585 instanceof Error)){
var statearr_20589_20600 = state_20581__$1;
(statearr_20589_20600[(1)] = (4));

(statearr_20589_20600[(5)] = null);

} else {
throw ex20585;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20582 === (6))){
var inst_20575 = (state_20581[(2)]);
var inst_20576 = fluree.db.util.async.throw_err.call(null,inst_20575);
var _ = (function (){var statearr_20590 = state_20581;
(statearr_20590[(4)] = cljs.core.rest.call(null,(state_20581[(4)])));

return statearr_20590;
})();
var state_20581__$1 = state_20581;
var statearr_20591_20601 = state_20581__$1;
(statearr_20591_20601[(2)] = inst_20576);

(statearr_20591_20601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2726__auto____0 = (function (){
var statearr_20592 = [null,null,null,null,null,null,null];
(statearr_20592[(0)] = fluree$db$storage$core$write_block_$_state_machine__2726__auto__);

(statearr_20592[(1)] = (1));

return statearr_20592;
});
var fluree$db$storage$core$write_block_$_state_machine__2726__auto____1 = (function (state_20581){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20593){var ex__2729__auto__ = e20593;
var statearr_20594_20602 = state_20581;
(statearr_20594_20602[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20581[(4)]))){
var statearr_20595_20603 = state_20581;
(statearr_20595_20603[(1)] = cljs.core.first.call(null,(state_20581[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20604 = state_20581;
state_20581 = G__20604;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2726__auto__ = function(state_20581){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2726__auto____1.call(this,state_20581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2726__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2726__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20596 = f__2749__auto__.call(null);
(statearr_20596[(6)] = c__2748__auto__);

return statearr_20596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20624){
var state_val_20625 = (state_20624[(1)]);
if((state_val_20625 === (1))){
var state_20624__$1 = state_20624;
var statearr_20626_20640 = state_20624__$1;
(statearr_20626_20640[(2)] = null);

(statearr_20626_20640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20625 === (2))){
var _ = (function (){var statearr_20627 = state_20624;
(statearr_20627[(4)] = cljs.core.cons.call(null,(5),(state_20624[(4)])));

return statearr_20627;
})();
var inst_20611 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20612 = [history,next_his_key];
var inst_20613 = cljs.core.PersistentHashMap.fromArrays(inst_20611,inst_20612);
var inst_20614 = fluree.db.storage.core.serde.call(null,conn);
var inst_20615 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_20614,inst_20613);
var inst_20616 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_20615);
var state_20624__$1 = state_20624;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20624__$1,(6),inst_20616);
} else {
if((state_val_20625 === (3))){
var inst_20622 = (state_20624[(2)]);
var state_20624__$1 = state_20624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20624__$1,inst_20622);
} else {
if((state_val_20625 === (4))){
var inst_20605 = (state_20624[(2)]);
var state_20624__$1 = state_20624;
var statearr_20629_20641 = state_20624__$1;
(statearr_20629_20641[(2)] = inst_20605);

(statearr_20629_20641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20625 === (5))){
var _ = (function (){var statearr_20630 = state_20624;
(statearr_20630[(4)] = cljs.core.rest.call(null,(state_20624[(4)])));

return statearr_20630;
})();
var state_20624__$1 = state_20624;
var ex20628 = (state_20624__$1[(2)]);
var statearr_20631_20642 = state_20624__$1;
(statearr_20631_20642[(5)] = ex20628);


if((ex20628 instanceof Error)){
var statearr_20632_20643 = state_20624__$1;
(statearr_20632_20643[(1)] = (4));

(statearr_20632_20643[(5)] = null);

} else {
throw ex20628;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20625 === (6))){
var inst_20618 = (state_20624[(2)]);
var inst_20619 = fluree.db.util.async.throw_err.call(null,inst_20618);
var _ = (function (){var statearr_20633 = state_20624;
(statearr_20633[(4)] = cljs.core.rest.call(null,(state_20624[(4)])));

return statearr_20633;
})();
var state_20624__$1 = state_20624;
var statearr_20634_20644 = state_20624__$1;
(statearr_20634_20644[(2)] = inst_20619);

(statearr_20634_20644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2726__auto____0 = (function (){
var statearr_20635 = [null,null,null,null,null,null,null];
(statearr_20635[(0)] = fluree$db$storage$core$write_history_$_state_machine__2726__auto__);

(statearr_20635[(1)] = (1));

return statearr_20635;
});
var fluree$db$storage$core$write_history_$_state_machine__2726__auto____1 = (function (state_20624){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20636){var ex__2729__auto__ = e20636;
var statearr_20637_20645 = state_20624;
(statearr_20637_20645[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20624[(4)]))){
var statearr_20638_20646 = state_20624;
(statearr_20638_20646[(1)] = cljs.core.first.call(null,(state_20624[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20647 = state_20624;
state_20624 = G__20647;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2726__auto__ = function(state_20624){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2726__auto____1.call(this,state_20624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2726__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2726__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20639 = f__2749__auto__.call(null);
(statearr_20639[(6)] = c__2748__auto__);

return statearr_20639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20673){
var state_val_20674 = (state_20673[(1)]);
if((state_val_20674 === (1))){
var state_20673__$1 = state_20673;
var statearr_20675_20692 = state_20673__$1;
(statearr_20675_20692[(2)] = null);

(statearr_20675_20692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20674 === (2))){
var inst_20654 = (state_20673[(7)]);
var _ = (function (){var statearr_20676 = state_20673;
(statearr_20676[(4)] = cljs.core.cons.call(null,(5),(state_20673[(4)])));

return statearr_20676;
})();
var inst_20654__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_20655 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20654__$1),"-his"].join('');
var inst_20656 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20657 = [flakes,inst_20655];
var inst_20658 = cljs.core.PersistentHashMap.fromArrays(inst_20656,inst_20657);
var inst_20659 = fluree.db.storage.core.serde.call(null,conn);
var inst_20660 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_20659,inst_20658);
var inst_20661 = fluree.db.storage.core.write_history.call(null,conn,history,inst_20655,null);
var inst_20662 = fluree.db.storage.core.storage_write.call(null,conn,inst_20654__$1,inst_20660);
var state_20673__$1 = (function (){var statearr_20677 = state_20673;
(statearr_20677[(8)] = inst_20662);

(statearr_20677[(7)] = inst_20654__$1);

return statearr_20677;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20673__$1,(6),inst_20661);
} else {
if((state_val_20674 === (3))){
var inst_20671 = (state_20673[(2)]);
var state_20673__$1 = state_20673;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20673__$1,inst_20671);
} else {
if((state_val_20674 === (4))){
var inst_20648 = (state_20673[(2)]);
var state_20673__$1 = state_20673;
var statearr_20679_20693 = state_20673__$1;
(statearr_20679_20693[(2)] = inst_20648);

(statearr_20679_20693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20674 === (5))){
var _ = (function (){var statearr_20680 = state_20673;
(statearr_20680[(4)] = cljs.core.rest.call(null,(state_20673[(4)])));

return statearr_20680;
})();
var state_20673__$1 = state_20673;
var ex20678 = (state_20673__$1[(2)]);
var statearr_20681_20694 = state_20673__$1;
(statearr_20681_20694[(5)] = ex20678);


if((ex20678 instanceof Error)){
var statearr_20682_20695 = state_20673__$1;
(statearr_20682_20695[(1)] = (4));

(statearr_20682_20695[(5)] = null);

} else {
throw ex20678;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20674 === (6))){
var inst_20662 = (state_20673[(8)]);
var inst_20664 = (state_20673[(2)]);
var inst_20665 = fluree.db.util.async.throw_err.call(null,inst_20664);
var state_20673__$1 = (function (){var statearr_20683 = state_20673;
(statearr_20683[(9)] = inst_20665);

return statearr_20683;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20673__$1,(7),inst_20662);
} else {
if((state_val_20674 === (7))){
var inst_20654 = (state_20673[(7)]);
var inst_20667 = (state_20673[(2)]);
var inst_20668 = fluree.db.util.async.throw_err.call(null,inst_20667);
var _ = (function (){var statearr_20684 = state_20673;
(statearr_20684[(4)] = cljs.core.rest.call(null,(state_20673[(4)])));

return statearr_20684;
})();
var state_20673__$1 = (function (){var statearr_20685 = state_20673;
(statearr_20685[(10)] = inst_20668);

return statearr_20685;
})();
var statearr_20686_20696 = state_20673__$1;
(statearr_20686_20696[(2)] = inst_20654);

(statearr_20686_20696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2726__auto____0 = (function (){
var statearr_20687 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20687[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2726__auto__);

(statearr_20687[(1)] = (1));

return statearr_20687;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2726__auto____1 = (function (state_20673){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20688){var ex__2729__auto__ = e20688;
var statearr_20689_20697 = state_20673;
(statearr_20689_20697[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20673[(4)]))){
var statearr_20690_20698 = state_20673;
(statearr_20690_20698[(1)] = cljs.core.first.call(null,(state_20673[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20699 = state_20673;
state_20673 = G__20699;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2726__auto__ = function(state_20673){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2726__auto____1.call(this,state_20673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2726__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2726__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20691 = f__2749__auto__.call(null);
(statearr_20691[(6)] = c__2748__auto__);

return statearr_20691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20716){
var state_val_20717 = (state_20716[(1)]);
if((state_val_20717 === (1))){
var state_20716__$1 = state_20716;
var statearr_20718_20733 = state_20716__$1;
(statearr_20718_20733[(2)] = null);

(statearr_20718_20733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20717 === (2))){
var _ = (function (){var statearr_20719 = state_20716;
(statearr_20719[(4)] = cljs.core.cons.call(null,(5),(state_20716[(4)])));

return statearr_20719;
})();
var inst_20706 = fluree.db.storage.core.serde.call(null,conn);
var inst_20707 = fluree.db.serde.protocol._serialize_branch.call(null,inst_20706,data);
var inst_20708 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_20707);
var state_20716__$1 = state_20716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20716__$1,(6),inst_20708);
} else {
if((state_val_20717 === (3))){
var inst_20714 = (state_20716[(2)]);
var state_20716__$1 = state_20716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20716__$1,inst_20714);
} else {
if((state_val_20717 === (4))){
var inst_20700 = (state_20716[(2)]);
var state_20716__$1 = state_20716;
var statearr_20721_20734 = state_20716__$1;
(statearr_20721_20734[(2)] = inst_20700);

(statearr_20721_20734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20717 === (5))){
var _ = (function (){var statearr_20722 = state_20716;
(statearr_20722[(4)] = cljs.core.rest.call(null,(state_20716[(4)])));

return statearr_20722;
})();
var state_20716__$1 = state_20716;
var ex20720 = (state_20716__$1[(2)]);
var statearr_20723_20735 = state_20716__$1;
(statearr_20723_20735[(5)] = ex20720);


if((ex20720 instanceof Error)){
var statearr_20724_20736 = state_20716__$1;
(statearr_20724_20736[(1)] = (4));

(statearr_20724_20736[(5)] = null);

} else {
throw ex20720;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20717 === (6))){
var inst_20710 = (state_20716[(2)]);
var inst_20711 = fluree.db.util.async.throw_err.call(null,inst_20710);
var _ = (function (){var statearr_20725 = state_20716;
(statearr_20725[(4)] = cljs.core.rest.call(null,(state_20716[(4)])));

return statearr_20725;
})();
var state_20716__$1 = (function (){var statearr_20726 = state_20716;
(statearr_20726[(7)] = inst_20711);

return statearr_20726;
})();
var statearr_20727_20737 = state_20716__$1;
(statearr_20727_20737[(2)] = key);

(statearr_20727_20737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto____0 = (function (){
var statearr_20728 = [null,null,null,null,null,null,null,null];
(statearr_20728[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto__);

(statearr_20728[(1)] = (1));

return statearr_20728;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto____1 = (function (state_20716){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20729){var ex__2729__auto__ = e20729;
var statearr_20730_20738 = state_20716;
(statearr_20730_20738[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20716[(4)]))){
var statearr_20731_20739 = state_20716;
(statearr_20731_20739[(1)] = cljs.core.first.call(null,(state_20716[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20740 = state_20716;
state_20716 = G__20740;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto__ = function(state_20716){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto____1.call(this,state_20716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20732 = f__2749__auto__.call(null);
(statearr_20732[(6)] = c__2748__auto__);

return statearr_20732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__20741_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__20741_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__20742){
var map__20743 = p__20742;
var map__20743__$1 = cljs.core.__destructure_map.call(null,map__20743);
var progress = map__20743__$1;
var garbage = cljs.core.get.call(null,map__20743__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20771){
var state_val_20772 = (state_20771[(1)]);
if((state_val_20772 === (1))){
var state_20771__$1 = state_20771;
var statearr_20773_20789 = state_20771__$1;
(statearr_20773_20789[(2)] = null);

(statearr_20773_20789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20772 === (2))){
var inst_20757 = (state_20771[(7)]);
var _ = (function (){var statearr_20774 = state_20771;
(statearr_20774[(4)] = cljs.core.cons.call(null,(5),(state_20771[(4)])));

return statearr_20774;
})();
var inst_20751 = db;
var inst_20752 = cljs.core.__destructure_map.call(null,inst_20751);
var inst_20753 = cljs.core.get.call(null,inst_20752,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20754 = cljs.core.get.call(null,inst_20752,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20755 = cljs.core.get.call(null,inst_20752,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20756 = cljs.core.get.call(null,inst_20752,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20757__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_20754,inst_20755,inst_20756);
var inst_20758 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_20759 = [inst_20755,inst_20756,garbage];
var inst_20760 = cljs.core.PersistentHashMap.fromArrays(inst_20758,inst_20759);
var inst_20761 = fluree.db.storage.core.serde.call(null,inst_20753);
var inst_20762 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_20761,inst_20760);
var inst_20763 = fluree.db.storage.core.storage_write.call(null,inst_20753,inst_20757__$1,inst_20762);
var state_20771__$1 = (function (){var statearr_20775 = state_20771;
(statearr_20775[(7)] = inst_20757__$1);

return statearr_20775;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20771__$1,(6),inst_20763);
} else {
if((state_val_20772 === (3))){
var inst_20769 = (state_20771[(2)]);
var state_20771__$1 = state_20771;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20771__$1,inst_20769);
} else {
if((state_val_20772 === (4))){
var inst_20744 = (state_20771[(2)]);
var state_20771__$1 = state_20771;
var statearr_20777_20790 = state_20771__$1;
(statearr_20777_20790[(2)] = inst_20744);

(statearr_20777_20790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20772 === (5))){
var _ = (function (){var statearr_20778 = state_20771;
(statearr_20778[(4)] = cljs.core.rest.call(null,(state_20771[(4)])));

return statearr_20778;
})();
var state_20771__$1 = state_20771;
var ex20776 = (state_20771__$1[(2)]);
var statearr_20779_20791 = state_20771__$1;
(statearr_20779_20791[(5)] = ex20776);


if((ex20776 instanceof Error)){
var statearr_20780_20792 = state_20771__$1;
(statearr_20780_20792[(1)] = (4));

(statearr_20780_20792[(5)] = null);

} else {
throw ex20776;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20772 === (6))){
var inst_20757 = (state_20771[(7)]);
var inst_20765 = (state_20771[(2)]);
var inst_20766 = fluree.db.util.async.throw_err.call(null,inst_20765);
var _ = (function (){var statearr_20781 = state_20771;
(statearr_20781[(4)] = cljs.core.rest.call(null,(state_20771[(4)])));

return statearr_20781;
})();
var state_20771__$1 = (function (){var statearr_20782 = state_20771;
(statearr_20782[(8)] = inst_20766);

return statearr_20782;
})();
var statearr_20783_20793 = state_20771__$1;
(statearr_20783_20793[(2)] = inst_20757);

(statearr_20783_20793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2726__auto____0 = (function (){
var statearr_20784 = [null,null,null,null,null,null,null,null,null];
(statearr_20784[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2726__auto__);

(statearr_20784[(1)] = (1));

return statearr_20784;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2726__auto____1 = (function (state_20771){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20771);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20785){var ex__2729__auto__ = e20785;
var statearr_20786_20794 = state_20771;
(statearr_20786_20794[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20771[(4)]))){
var statearr_20787_20795 = state_20771;
(statearr_20787_20795[(1)] = cljs.core.first.call(null,(state_20771[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20796 = state_20771;
state_20771 = G__20796;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2726__auto__ = function(state_20771){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2726__auto____1.call(this,state_20771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2726__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2726__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20788 = f__2749__auto__.call(null);
(statearr_20788[(6)] = c__2748__auto__);

return statearr_20788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__20798 = arguments.length;
switch (G__20798) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20854){
var state_val_20855 = (state_20854[(1)]);
if((state_val_20855 === (7))){
var state_20854__$1 = state_20854;
var statearr_20856_20882 = state_20854__$1;
(statearr_20856_20882[(2)] = (0));

(statearr_20856_20882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (1))){
var state_20854__$1 = state_20854;
var statearr_20857_20883 = state_20854__$1;
(statearr_20857_20883[(2)] = null);

(statearr_20857_20883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (4))){
var inst_20799 = (state_20854[(2)]);
var state_20854__$1 = state_20854;
var statearr_20858_20884 = state_20854__$1;
(statearr_20858_20884[(2)] = inst_20799);

(statearr_20858_20884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (6))){
var inst_20824 = (state_20854[(7)]);
var state_20854__$1 = state_20854;
var statearr_20859_20885 = state_20854__$1;
(statearr_20859_20885[(2)] = inst_20824);

(statearr_20859_20885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (3))){
var inst_20852 = (state_20854[(2)]);
var state_20854__$1 = state_20854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20854__$1,inst_20852);
} else {
if((state_val_20855 === (12))){
var inst_20821 = (state_20854[(8)]);
var inst_20848 = (state_20854[(2)]);
var inst_20849 = fluree.db.util.async.throw_err.call(null,inst_20848);
var _ = (function (){var statearr_20860 = state_20854;
(statearr_20860[(4)] = cljs.core.rest.call(null,(state_20854[(4)])));

return statearr_20860;
})();
var state_20854__$1 = (function (){var statearr_20861 = state_20854;
(statearr_20861[(9)] = inst_20849);

return statearr_20861;
})();
var statearr_20862_20886 = state_20854__$1;
(statearr_20862_20886[(2)] = inst_20821);

(statearr_20862_20886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (2))){
var inst_20824 = (state_20854[(7)]);
var inst_20816 = (state_20854[(10)]);
var inst_20814 = (state_20854[(11)]);
var inst_20812 = (state_20854[(12)]);
var _ = (function (){var statearr_20863 = state_20854;
(statearr_20863[(4)] = cljs.core.cons.call(null,(5),(state_20854[(4)])));

return statearr_20863;
})();
var inst_20806 = db;
var inst_20807 = cljs.core.__destructure_map.call(null,inst_20806);
var inst_20808 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20809 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_20810 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_20811 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_20812__$1 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_20813 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20814__$1 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20815 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_20816__$1 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20817 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_20818 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_20819 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_20820 = cljs.core.get.call(null,inst_20807,new cljs.core.Keyword(null,"post","post",269697687));
var inst_20821 = fluree.db.storage.core.ledger_root_key.call(null,inst_20808,inst_20816__$1,inst_20814__$1);
var inst_20822 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_20823 = fluree.db.storage.core.child_data.call(null,inst_20815);
var inst_20824__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_20812__$1);
var state_20854__$1 = (function (){var statearr_20864 = state_20854;
(statearr_20864[(13)] = inst_20822);

(statearr_20864[(14)] = inst_20818);

(statearr_20864[(15)] = inst_20823);

(statearr_20864[(16)] = inst_20817);

(statearr_20864[(17)] = inst_20813);

(statearr_20864[(7)] = inst_20824__$1);

(statearr_20864[(18)] = inst_20819);

(statearr_20864[(19)] = inst_20810);

(statearr_20864[(20)] = inst_20811);

(statearr_20864[(10)] = inst_20816__$1);

(statearr_20864[(21)] = inst_20820);

(statearr_20864[(11)] = inst_20814__$1);

(statearr_20864[(22)] = inst_20809);

(statearr_20864[(12)] = inst_20812__$1);

(statearr_20864[(8)] = inst_20821);

return statearr_20864;
})();
if(cljs.core.truth_(inst_20824__$1)){
var statearr_20865_20887 = state_20854__$1;
(statearr_20865_20887[(1)] = (6));

} else {
var statearr_20866_20888 = state_20854__$1;
(statearr_20866_20888[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (11))){
var inst_20822 = (state_20854[(13)]);
var inst_20818 = (state_20854[(14)]);
var inst_20828 = (state_20854[(23)]);
var inst_20823 = (state_20854[(15)]);
var inst_20813 = (state_20854[(17)]);
var inst_20819 = (state_20854[(18)]);
var inst_20810 = (state_20854[(19)]);
var inst_20811 = (state_20854[(20)]);
var inst_20816 = (state_20854[(10)]);
var inst_20820 = (state_20854[(21)]);
var inst_20814 = (state_20854[(11)]);
var inst_20809 = (state_20854[(22)]);
var inst_20812 = (state_20854[(12)]);
var inst_20821 = (state_20854[(8)]);
var inst_20833 = (state_20854[(2)]);
var inst_20834 = fluree.db.storage.core.child_data.call(null,inst_20818);
var inst_20835 = fluree.db.storage.core.child_data.call(null,inst_20820);
var inst_20836 = fluree.db.util.core.current_time_millis.call(null);
var inst_20837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20838 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_20839 = (new cljs.core.PersistentVector(null,2,(5),inst_20837,inst_20838,null));
var inst_20840 = cljs.core.select_keys.call(null,inst_20812,inst_20839);
var inst_20841 = fluree.db.storage.core.child_data.call(null,inst_20811);
var inst_20842 = [inst_20814,inst_20823,inst_20816,inst_20828,inst_20833,inst_20834,inst_20835,inst_20809,inst_20836,inst_20810,inst_20819,inst_20840,inst_20841];
var inst_20843 = cljs.core.PersistentHashMap.fromArrays(inst_20822,inst_20842);
var inst_20844 = fluree.db.storage.core.serde.call(null,inst_20813);
var inst_20845 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_20844,inst_20843);
var inst_20846 = fluree.db.storage.core.storage_write.call(null,inst_20813,inst_20821,inst_20845);
var state_20854__$1 = state_20854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20854__$1,(12),inst_20846);
} else {
if((state_val_20855 === (9))){
var inst_20829 = (state_20854[(24)]);
var state_20854__$1 = state_20854;
var statearr_20868_20889 = state_20854__$1;
(statearr_20868_20889[(2)] = inst_20829);

(statearr_20868_20889[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (5))){
var _ = (function (){var statearr_20869 = state_20854;
(statearr_20869[(4)] = cljs.core.rest.call(null,(state_20854[(4)])));

return statearr_20869;
})();
var state_20854__$1 = state_20854;
var ex20867 = (state_20854__$1[(2)]);
var statearr_20870_20890 = state_20854__$1;
(statearr_20870_20890[(5)] = ex20867);


if((ex20867 instanceof Error)){
var statearr_20871_20891 = state_20854__$1;
(statearr_20871_20891[(1)] = (4));

(statearr_20871_20891[(5)] = null);

} else {
throw ex20867;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (10))){
var inst_20817 = (state_20854[(16)]);
var state_20854__$1 = state_20854;
var statearr_20872_20892 = state_20854__$1;
(statearr_20872_20892[(2)] = inst_20817);

(statearr_20872_20892[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20855 === (8))){
var inst_20829 = (state_20854[(24)]);
var inst_20828 = (state_20854[(2)]);
var inst_20829__$1 = custom_ecount;
var state_20854__$1 = (function (){var statearr_20873 = state_20854;
(statearr_20873[(23)] = inst_20828);

(statearr_20873[(24)] = inst_20829__$1);

return statearr_20873;
})();
if(cljs.core.truth_(inst_20829__$1)){
var statearr_20874_20893 = state_20854__$1;
(statearr_20874_20893[(1)] = (9));

} else {
var statearr_20875_20894 = state_20854__$1;
(statearr_20875_20894[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2726__auto__ = null;
var fluree$db$storage$core$state_machine__2726__auto____0 = (function (){
var statearr_20876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20876[(0)] = fluree$db$storage$core$state_machine__2726__auto__);

(statearr_20876[(1)] = (1));

return statearr_20876;
});
var fluree$db$storage$core$state_machine__2726__auto____1 = (function (state_20854){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20877){var ex__2729__auto__ = e20877;
var statearr_20878_20895 = state_20854;
(statearr_20878_20895[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20854[(4)]))){
var statearr_20879_20896 = state_20854;
(statearr_20879_20896[(1)] = cljs.core.first.call(null,(state_20854[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20897 = state_20854;
state_20854 = G__20897;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2726__auto__ = function(state_20854){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2726__auto____1.call(this,state_20854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2726__auto____0;
fluree$db$storage$core$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2726__auto____1;
return fluree$db$storage$core$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20880 = f__2749__auto__.call(null);
(statearr_20880[(6)] = c__2748__auto__);

return statearr_20880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2748__auto___20956 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20930){
var state_val_20931 = (state_20930[(1)]);
if((state_val_20931 === (7))){
var inst_20910 = (state_20930[(7)]);
var state_20930__$1 = state_20930;
var statearr_20932_20957 = state_20930__$1;
(statearr_20932_20957[(2)] = inst_20910);

(statearr_20932_20957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (1))){
var state_20930__$1 = state_20930;
var statearr_20933_20958 = state_20930__$1;
(statearr_20933_20958[(2)] = null);

(statearr_20933_20958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (4))){
var inst_20898 = (state_20930[(2)]);
var inst_20899 = error_fn.call(null);
var inst_20900 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20898);
var inst_20901 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20930__$1 = (function (){var statearr_20934 = state_20930;
(statearr_20934[(8)] = inst_20900);

(statearr_20934[(9)] = inst_20899);

return statearr_20934;
})();
var statearr_20935_20959 = state_20930__$1;
(statearr_20935_20959[(2)] = inst_20901);

(statearr_20935_20959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (6))){
var inst_20910 = (state_20930[(7)]);
var inst_20909 = (state_20930[(10)]);
var inst_20909__$1 = (state_20930[(2)]);
var inst_20910__$1 = (inst_20909__$1 == null);
var state_20930__$1 = (function (){var statearr_20936 = state_20930;
(statearr_20936[(7)] = inst_20910__$1);

(statearr_20936[(10)] = inst_20909__$1);

return statearr_20936;
})();
if(cljs.core.truth_(inst_20910__$1)){
var statearr_20937_20960 = state_20930__$1;
(statearr_20937_20960[(1)] = (7));

} else {
var statearr_20938_20961 = state_20930__$1;
(statearr_20938_20961[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (3))){
var inst_20928 = (state_20930[(2)]);
var state_20930__$1 = state_20930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20930__$1,inst_20928);
} else {
if((state_val_20931 === (12))){
var inst_20925 = (state_20930[(2)]);
var _ = (function (){var statearr_20939 = state_20930;
(statearr_20939[(4)] = cljs.core.rest.call(null,(state_20930[(4)])));

return statearr_20939;
})();
var state_20930__$1 = state_20930;
var statearr_20940_20962 = state_20930__$1;
(statearr_20940_20962[(2)] = inst_20925);

(statearr_20940_20962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (2))){
var _ = (function (){var statearr_20941 = state_20930;
(statearr_20941[(4)] = cljs.core.cons.call(null,(5),(state_20930[(4)])));

return statearr_20941;
})();
var inst_20907 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_20930__$1 = state_20930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20930__$1,(6),inst_20907);
} else {
if((state_val_20931 === (11))){
var inst_20909 = (state_20930[(10)]);
var inst_20919 = fluree.db.storage.core.serde.call(null,conn);
var inst_20920 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_20919,inst_20909);
var inst_20921 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20920);
var inst_20922 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_20921);
var inst_20923 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20922);
var state_20930__$1 = state_20930;
var statearr_20943_20963 = state_20930__$1;
(statearr_20943_20963[(2)] = inst_20923);

(statearr_20943_20963[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (9))){
var inst_20915 = (state_20930[(2)]);
var state_20930__$1 = state_20930;
if(cljs.core.truth_(inst_20915)){
var statearr_20944_20964 = state_20930__$1;
(statearr_20944_20964[(1)] = (10));

} else {
var statearr_20945_20965 = state_20930__$1;
(statearr_20945_20965[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (5))){
var _ = (function (){var statearr_20946 = state_20930;
(statearr_20946[(4)] = cljs.core.rest.call(null,(state_20930[(4)])));

return statearr_20946;
})();
var state_20930__$1 = state_20930;
var ex20942 = (state_20930__$1[(2)]);
var statearr_20947_20966 = state_20930__$1;
(statearr_20947_20966[(5)] = ex20942);


var statearr_20948_20967 = state_20930__$1;
(statearr_20948_20967[(1)] = (4));

(statearr_20948_20967[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (10))){
var inst_20917 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20930__$1 = state_20930;
var statearr_20949_20968 = state_20930__$1;
(statearr_20949_20968[(2)] = inst_20917);

(statearr_20949_20968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20931 === (8))){
var inst_20909 = (state_20930[(10)]);
var inst_20913 = (inst_20909 instanceof Error);
var state_20930__$1 = state_20930;
var statearr_20950_20969 = state_20930__$1;
(statearr_20950_20969[(2)] = inst_20913);

(statearr_20950_20969[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2726__auto____0 = (function (){
var statearr_20951 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20951[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2726__auto__);

(statearr_20951[(1)] = (1));

return statearr_20951;
});
var fluree$db$storage$core$reify_history_$_state_machine__2726__auto____1 = (function (state_20930){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20952){var ex__2729__auto__ = e20952;
var statearr_20953_20970 = state_20930;
(statearr_20953_20970[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20930[(4)]))){
var statearr_20954_20971 = state_20930;
(statearr_20954_20971[(1)] = cljs.core.first.call(null,(state_20930[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20972 = state_20930;
state_20930 = G__20972;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2726__auto__ = function(state_20930){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2726__auto____1.call(this,state_20930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2726__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2726__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20955 = f__2749__auto__.call(null);
(statearr_20955[(6)] = c__2748__auto___20956);

return statearr_20955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__20974 = arguments.length;
switch (G__20974) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4221__auto__ = (rhs == null);
if(and__4221__auto__){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2748__auto___21084 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21037){
var state_val_21038 = (state_21037[(1)]);
if((state_val_21038 === (7))){
var state_21037__$1 = state_21037;
var statearr_21039_21085 = state_21037__$1;
(statearr_21039_21085[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_21039_21085[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (20))){
var inst_21016 = cljs.core.PersistentVector.EMPTY;
var state_21037__$1 = state_21037;
var statearr_21040_21086 = state_21037__$1;
(statearr_21040_21086[(2)] = inst_21016);

(statearr_21040_21086[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (1))){
var state_21037__$1 = state_21037;
var statearr_21041_21087 = state_21037__$1;
(statearr_21041_21087[(2)] = null);

(statearr_21041_21087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (24))){
var state_21037__$1 = state_21037;
var statearr_21042_21088 = state_21037__$1;
(statearr_21042_21088[(2)] = null);

(statearr_21042_21088[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (4))){
var inst_20977 = (state_21037[(2)]);
var inst_20978 = error_fn.call(null);
var inst_20979 = cljs.core.async.put_BANG_.call(null,result_ch,inst_20977);
var inst_20980 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_21037__$1 = (function (){var statearr_21043 = state_21037;
(statearr_21043[(7)] = inst_20979);

(statearr_21043[(8)] = inst_20978);

return statearr_21043;
})();
var statearr_21044_21089 = state_21037__$1;
(statearr_21044_21089[(2)] = inst_20980);

(statearr_21044_21089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (15))){
var inst_21002 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
var statearr_21045_21090 = state_21037__$1;
(statearr_21045_21090[(2)] = inst_21002);

(statearr_21045_21090[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (21))){
var inst_20989 = (state_21037[(9)]);
var inst_20990 = (state_21037[(10)]);
var inst_21006 = (state_21037[(11)]);
var inst_20991 = (state_21037[(12)]);
var inst_21019 = (state_21037[(13)]);
var inst_21026 = (state_21037[(2)]);
var inst_21027 = (function (){var base_node = inst_20989;
var first_flake = inst_20990;
var node_t = inst_20991;
var source = inst_21006;
var coll = inst_21019;
var conj_QMARK_ = inst_21026;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4223__auto__ = remove_preds;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_21028 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20989);
var inst_21029 = cljs.core.reduce.call(null,inst_21027,inst_21028,inst_21019);
var inst_21030 = cljs.core.doall.call(null,inst_21029);
var inst_21031 = cljs.core.assoc.call(null,inst_20989,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_21030);
var inst_21032 = cljs.core.async.put_BANG_.call(null,result_ch,inst_21031);
var _ = (function (){var statearr_21046 = state_21037;
(statearr_21046[(4)] = cljs.core.rest.call(null,(state_21037[(4)])));

return statearr_21046;
})();
var state_21037__$1 = state_21037;
var statearr_21047_21091 = state_21037__$1;
(statearr_21047_21091[(2)] = inst_21032);

(statearr_21047_21091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (13))){
var state_21037__$1 = state_21037;
var statearr_21048_21092 = state_21037__$1;
(statearr_21048_21092[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_21048_21092[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (22))){
var inst_20989 = (state_21037[(9)]);
var inst_20990 = (state_21037[(10)]);
var inst_21006 = (state_21037[(11)]);
var inst_20991 = (state_21037[(12)]);
var inst_21019 = (state_21037[(13)]);
var inst_21020 = (function (){var base_node = inst_20989;
var first_flake = inst_20990;
var node_t = inst_20991;
var source = inst_21006;
var coll = inst_21019;
return (function (f){
return f.op === true;
});
})();
var state_21037__$1 = state_21037;
var statearr_21049_21093 = state_21037__$1;
(statearr_21049_21093[(2)] = inst_21020);

(statearr_21049_21093[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (6))){
var inst_20989 = (state_21037[(9)]);
var inst_20991 = (state_21037[(12)]);
var inst_20988 = (state_21037[(2)]);
var inst_20989__$1 = fluree.db.util.async.throw_err.call(null,inst_20988);
var inst_20990 = fluree.db.dbproto._first_flake.call(null,inst_20989__$1);
var inst_20991__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_20989__$1);
var inst_20992 = (inst_20991__$1 > t);
var state_21037__$1 = (function (){var statearr_21050 = state_21037;
(statearr_21050[(9)] = inst_20989__$1);

(statearr_21050[(10)] = inst_20990);

(statearr_21050[(12)] = inst_20991__$1);

return statearr_21050;
})();
if(cljs.core.truth_(inst_20992)){
var statearr_21051_21094 = state_21037__$1;
(statearr_21051_21094[(1)] = (7));

} else {
var statearr_21052_21095 = state_21037__$1;
(statearr_21052_21095[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (17))){
var inst_20990 = (state_21037[(10)]);
var inst_21007 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_20990,rhs,leftmost_QMARK_,t);
var state_21037__$1 = state_21037;
var statearr_21053_21096 = state_21037__$1;
(statearr_21053_21096[(2)] = inst_21007);

(statearr_21053_21096[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (3))){
var inst_21035 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21037__$1,inst_21035);
} else {
if((state_val_21038 === (12))){
var inst_21004 = (state_21037[(2)]);
var state_21037__$1 = state_21037;
var statearr_21054_21097 = state_21037__$1;
(statearr_21054_21097[(2)] = inst_21004);

(statearr_21054_21097[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (2))){
var _ = (function (){var statearr_21055 = state_21037;
(statearr_21055[(4)] = cljs.core.cons.call(null,(5),(state_21037[(4)])));

return statearr_21055;
})();
var inst_20986 = fluree.db.dbproto._resolve.call(null,node);
var state_21037__$1 = state_21037;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21037__$1,(6),inst_20986);
} else {
if((state_val_21038 === (23))){
var inst_20989 = (state_21037[(9)]);
var inst_20990 = (state_21037[(10)]);
var inst_21006 = (state_21037[(11)]);
var inst_20991 = (state_21037[(12)]);
var inst_21019 = (state_21037[(13)]);
var inst_21022 = (function (){var base_node = inst_20989;
var first_flake = inst_20990;
var node_t = inst_20991;
var source = inst_21006;
var coll = inst_21019;
return (function (f){
return f.op === false;
});
})();
var state_21037__$1 = state_21037;
var statearr_21056_21098 = state_21037__$1;
(statearr_21056_21098[(2)] = inst_21022);

(statearr_21056_21098[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (19))){
var inst_21009 = (state_21037[(14)]);
var inst_21012 = (state_21037[(2)]);
var inst_21013 = fluree.db.util.async.throw_err.call(null,inst_21012);
var inst_21014 = cljs.core.take_while.call(null,inst_21009,inst_21013);
var state_21037__$1 = state_21037;
var statearr_21057_21099 = state_21037__$1;
(statearr_21057_21099[(2)] = inst_21014);

(statearr_21057_21099[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (11))){
var inst_20991 = (state_21037[(12)]);
var inst_20998 = cljs.core._EQ_.call(null,inst_20991,t);
var state_21037__$1 = state_21037;
if(inst_20998){
var statearr_21059_21100 = state_21037__$1;
(statearr_21059_21100[(1)] = (13));

} else {
var statearr_21060_21101 = state_21037__$1;
(statearr_21060_21101[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (9))){
var inst_21006 = (state_21037[(11)]);
var inst_21006__$1 = (state_21037[(2)]);
var state_21037__$1 = (function (){var statearr_21061 = state_21037;
(statearr_21061[(11)] = inst_21006__$1);

return statearr_21061;
})();
var G__21062_21102 = inst_21006__$1;
var G__21062_21103__$1 = (((G__21062_21102 instanceof cljs.core.Keyword))?G__21062_21102.fqn:null);
switch (G__21062_21103__$1) {
case "novelty":
var statearr_21063_21105 = state_21037__$1;
(statearr_21063_21105[(1)] = (17));


break;
case "history":
var statearr_21064_21106 = state_21037__$1;
(statearr_21064_21106[(1)] = (18));


break;
case "none":
var statearr_21065_21107 = state_21037__$1;
(statearr_21065_21107[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21062_21103__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (5))){
var _ = (function (){var statearr_21066 = state_21037;
(statearr_21066[(4)] = cljs.core.rest.call(null,(state_21037[(4)])));

return statearr_21066;
})();
var state_21037__$1 = state_21037;
var ex21058 = (state_21037__$1[(2)]);
var statearr_21067_21108 = state_21037__$1;
(statearr_21067_21108[(5)] = ex21058);


var statearr_21068_21109 = state_21037__$1;
(statearr_21068_21109[(1)] = (4));

(statearr_21068_21109[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (14))){
var state_21037__$1 = state_21037;
var statearr_21069_21110 = state_21037__$1;
(statearr_21069_21110[(2)] = null);

(statearr_21069_21110[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (16))){
var inst_21006 = (state_21037[(11)]);
var inst_21019 = (state_21037[(2)]);
var state_21037__$1 = (function (){var statearr_21070 = state_21037;
(statearr_21070[(13)] = inst_21019);

return statearr_21070;
})();
var G__21071_21111 = inst_21006;
var G__21071_21112__$1 = (((G__21071_21111 instanceof cljs.core.Keyword))?G__21071_21111.fqn:null);
switch (G__21071_21112__$1) {
case "novelty":
var statearr_21072_21114 = state_21037__$1;
(statearr_21072_21114[(1)] = (22));


break;
case "history":
var statearr_21073_21115 = state_21037__$1;
(statearr_21073_21115[(1)] = (23));


break;
case "none":
var statearr_21074_21116 = state_21037__$1;
(statearr_21074_21116[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__21071_21112__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (10))){
var state_21037__$1 = state_21037;
var statearr_21075_21117 = state_21037__$1;
(statearr_21075_21117[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_21075_21117[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21038 === (18))){
var inst_20989 = (state_21037[(9)]);
var inst_20990 = (state_21037[(10)]);
var inst_21006 = (state_21037[(11)]);
var inst_20991 = (state_21037[(12)]);
var inst_21009 = (function (){var base_node = inst_20989;
var first_flake = inst_20990;
var node_t = inst_20991;
var source = inst_21006;
return (function (p1__20976_SHARP_){
return (p1__20976_SHARP_.t <= t);
});
})();
var inst_21010 = fluree.db.dbproto._resolve_history.call(null,node);
var state_21037__$1 = (function (){var statearr_21076 = state_21037;
(statearr_21076[(14)] = inst_21009);

return statearr_21076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21037__$1,(19),inst_21010);
} else {
if((state_val_21038 === (8))){
var inst_20991 = (state_21037[(12)]);
var inst_20995 = (inst_20991 < t);
var state_21037__$1 = state_21037;
if(cljs.core.truth_(inst_20995)){
var statearr_21077_21118 = state_21037__$1;
(statearr_21077_21118[(1)] = (10));

} else {
var statearr_21078_21119 = state_21037__$1;
(statearr_21078_21119[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2726__auto____0 = (function (){
var statearr_21079 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21079[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2726__auto__);

(statearr_21079[(1)] = (1));

return statearr_21079;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2726__auto____1 = (function (state_21037){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21037);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21080){var ex__2729__auto__ = e21080;
var statearr_21081_21120 = state_21037;
(statearr_21081_21120[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21037[(4)]))){
var statearr_21082_21121 = state_21037;
(statearr_21082_21121[(1)] = cljs.core.first.call(null,(state_21037[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21122 = state_21037;
state_21037 = G__21122;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2726__auto__ = function(state_21037){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2726__auto____1.call(this,state_21037);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2726__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2726__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21083 = f__2749__auto__.call(null);
(statearr_21083[(6)] = c__2748__auto___21084);

return statearr_21083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21182){
var state_val_21183 = (state_21182[(1)]);
if((state_val_21183 === (7))){
var inst_21133 = (state_21182[(7)]);
var inst_21137 = (inst_21133 <= from_t);
var state_21182__$1 = state_21182;
var statearr_21184_21224 = state_21182__$1;
(statearr_21184_21224[(2)] = inst_21137);

(statearr_21184_21224[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (20))){
var inst_21167 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_21168 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21167)].join('');
var inst_21169 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21170 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_21171 = cljs.core.PersistentHashMap.fromArrays(inst_21169,inst_21170);
var inst_21172 = cljs.core.ex_info.call(null,inst_21168,inst_21171);
var inst_21173 = (function(){throw inst_21172})();
var state_21182__$1 = state_21182;
var statearr_21185_21225 = state_21182__$1;
(statearr_21185_21225[(2)] = inst_21173);

(statearr_21185_21225[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (1))){
var state_21182__$1 = state_21182;
var statearr_21186_21226 = state_21182__$1;
(statearr_21186_21226[(2)] = null);

(statearr_21186_21226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (4))){
var inst_21125 = (state_21182[(2)]);
var inst_21126 = fluree.db.util.log.error.call(null,inst_21125);
var inst_21127 = (function(){throw inst_21125})();
var state_21182__$1 = (function (){var statearr_21187 = state_21182;
(statearr_21187[(8)] = inst_21126);

return statearr_21187;
})();
var statearr_21188_21227 = state_21182__$1;
(statearr_21188_21227[(2)] = inst_21127);

(statearr_21188_21227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (15))){
var inst_21152 = (state_21182[(2)]);
var state_21182__$1 = (function (){var statearr_21189 = state_21182;
(statearr_21189[(9)] = inst_21152);

return statearr_21189;
})();
if(cljs.core.truth_(from_t)){
var statearr_21190_21228 = state_21182__$1;
(statearr_21190_21228[(1)] = (16));

} else {
var statearr_21191_21229 = state_21182__$1;
(statearr_21191_21229[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (21))){
var inst_21163 = (state_21182[(10)]);
var inst_21162 = (state_21182[(11)]);
var inst_21161 = (state_21182[(12)]);
var inst_21175 = (state_21182[(2)]);
var inst_21176 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_21162,inst_21163,leftmost_QMARK_,to_t);
var inst_21177 = cljs.core.into.call(null,inst_21176,inst_21161);
var _ = (function (){var statearr_21192 = state_21182;
(statearr_21192[(4)] = cljs.core.rest.call(null,(state_21182[(4)])));

return statearr_21192;
})();
var state_21182__$1 = (function (){var statearr_21193 = state_21182;
(statearr_21193[(13)] = inst_21175);

return statearr_21193;
})();
var statearr_21194_21230 = state_21182__$1;
(statearr_21194_21230[(2)] = inst_21177);

(statearr_21194_21230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (13))){
var inst_21145 = (state_21182[(14)]);
var inst_21133 = (state_21182[(7)]);
var inst_21148 = (function (){var node_t = inst_21133;
var G__21141 = inst_21145;
return (function (p1__21123_SHARP_){
return (p1__21123_SHARP_.t < to_t);
});
})();
var inst_21149 = cljs.core.drop_while.call(null,inst_21148,inst_21145);
var state_21182__$1 = state_21182;
var statearr_21195_21231 = state_21182__$1;
(statearr_21195_21231[(2)] = inst_21149);

(statearr_21195_21231[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (6))){
var inst_21134 = (state_21182[(15)]);
var state_21182__$1 = state_21182;
var statearr_21196_21232 = state_21182__$1;
(statearr_21196_21232[(2)] = inst_21134);

(statearr_21196_21232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (17))){
var inst_21152 = (state_21182[(9)]);
var state_21182__$1 = state_21182;
var statearr_21197_21233 = state_21182__$1;
(statearr_21197_21233[(2)] = inst_21152);

(statearr_21197_21233[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (3))){
var inst_21180 = (state_21182[(2)]);
var state_21182__$1 = state_21182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21182__$1,inst_21180);
} else {
if((state_val_21183 === (12))){
var inst_21133 = (state_21182[(7)]);
var inst_21144 = (state_21182[(2)]);
var inst_21145 = fluree.db.util.async.throw_err.call(null,inst_21144);
var inst_21146 = (to_t > inst_21133);
var state_21182__$1 = (function (){var statearr_21198 = state_21182;
(statearr_21198[(14)] = inst_21145);

return statearr_21198;
})();
if(cljs.core.truth_(inst_21146)){
var statearr_21199_21234 = state_21182__$1;
(statearr_21199_21234[(1)] = (13));

} else {
var statearr_21200_21235 = state_21182__$1;
(statearr_21200_21235[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (2))){
var inst_21134 = (state_21182[(15)]);
var _ = (function (){var statearr_21201 = state_21182;
(statearr_21201[(4)] = cljs.core.cons.call(null,(5),(state_21182[(4)])));

return statearr_21201;
})();
var inst_21133 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_21134__$1 = (from_t == null);
var state_21182__$1 = (function (){var statearr_21202 = state_21182;
(statearr_21202[(15)] = inst_21134__$1);

(statearr_21202[(7)] = inst_21133);

return statearr_21202;
})();
if(cljs.core.truth_(inst_21134__$1)){
var statearr_21203_21236 = state_21182__$1;
(statearr_21203_21236[(1)] = (6));

} else {
var statearr_21204_21237 = state_21182__$1;
(statearr_21204_21237[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (19))){
var state_21182__$1 = state_21182;
var statearr_21205_21238 = state_21182__$1;
(statearr_21205_21238[(2)] = null);

(statearr_21205_21238[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (11))){
var inst_21161 = (state_21182[(2)]);
var inst_21162 = fluree.db.dbproto._first_flake.call(null,node);
var inst_21163 = fluree.db.dbproto._rhs.call(null,node);
var inst_21164 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_21182__$1 = (function (){var statearr_21207 = state_21182;
(statearr_21207[(10)] = inst_21163);

(statearr_21207[(11)] = inst_21162);

(statearr_21207[(12)] = inst_21161);

return statearr_21207;
})();
if(cljs.core.truth_(inst_21164)){
var statearr_21208_21239 = state_21182__$1;
(statearr_21208_21239[(1)] = (19));

} else {
var statearr_21209_21240 = state_21182__$1;
(statearr_21209_21240[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (9))){
var inst_21142 = fluree.db.dbproto._resolve_history.call(null,node);
var state_21182__$1 = state_21182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21182__$1,(12),inst_21142);
} else {
if((state_val_21183 === (5))){
var _ = (function (){var statearr_21210 = state_21182;
(statearr_21210[(4)] = cljs.core.rest.call(null,(state_21182[(4)])));

return statearr_21210;
})();
var state_21182__$1 = state_21182;
var ex21206 = (state_21182__$1[(2)]);
var statearr_21211_21241 = state_21182__$1;
(statearr_21211_21241[(5)] = ex21206);


var statearr_21212_21242 = state_21182__$1;
(statearr_21212_21242[(1)] = (4));

(statearr_21212_21242[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (14))){
var inst_21145 = (state_21182[(14)]);
var state_21182__$1 = state_21182;
var statearr_21213_21243 = state_21182__$1;
(statearr_21213_21243[(2)] = inst_21145);

(statearr_21213_21243[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (16))){
var inst_21152 = (state_21182[(9)]);
var inst_21133 = (state_21182[(7)]);
var inst_21154 = (function (){var node_t = inst_21133;
var G__21141 = inst_21152;
return (function (p1__21124_SHARP_){
return (p1__21124_SHARP_.t <= from_t);
});
})();
var inst_21155 = cljs.core.take_while.call(null,inst_21154,inst_21152);
var state_21182__$1 = state_21182;
var statearr_21214_21244 = state_21182__$1;
(statearr_21214_21244[(2)] = inst_21155);

(statearr_21214_21244[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (10))){
var state_21182__$1 = state_21182;
var statearr_21215_21245 = state_21182__$1;
(statearr_21215_21245[(2)] = null);

(statearr_21215_21245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (18))){
var inst_21158 = (state_21182[(2)]);
var state_21182__$1 = state_21182;
var statearr_21216_21246 = state_21182__$1;
(statearr_21216_21246[(2)] = inst_21158);

(statearr_21216_21246[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21183 === (8))){
var inst_21139 = (state_21182[(2)]);
var state_21182__$1 = state_21182;
if(cljs.core.truth_(inst_21139)){
var statearr_21217_21247 = state_21182__$1;
(statearr_21217_21247[(1)] = (9));

} else {
var statearr_21218_21248 = state_21182__$1;
(statearr_21218_21248[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto____0 = (function (){
var statearr_21219 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21219[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto__);

(statearr_21219[(1)] = (1));

return statearr_21219;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto____1 = (function (state_21182){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21220){var ex__2729__auto__ = e21220;
var statearr_21221_21249 = state_21182;
(statearr_21221_21249[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21182[(4)]))){
var statearr_21222_21250 = state_21182;
(statearr_21222_21250[(1)] = cljs.core.first.call(null,(state_21182[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21251 = state_21182;
state_21182 = G__21251;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto__ = function(state_21182){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto____1.call(this,state_21182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21223 = f__2749__auto__.call(null);
(statearr_21223[(6)] = c__2748__auto__);

return statearr_21223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4223__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21272){
var state_val_21273 = (state_21272[(1)]);
if((state_val_21273 === (7))){
var state_21272__$1 = state_21272;
var statearr_21274_21294 = state_21272__$1;
(statearr_21274_21294[(2)] = null);

(statearr_21274_21294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (1))){
var state_21272__$1 = state_21272;
var statearr_21275_21295 = state_21272__$1;
(statearr_21275_21295[(2)] = null);

(statearr_21275_21295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (4))){
var inst_21252 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
var statearr_21276_21296 = state_21272__$1;
(statearr_21276_21296[(2)] = inst_21252);

(statearr_21276_21296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (6))){
var inst_21258 = (state_21272[(7)]);
var inst_21260 = fluree.db.storage.core.serde.call(null,conn);
var state_21272__$1 = (function (){var statearr_21277 = state_21272;
(statearr_21277[(8)] = inst_21260);

return statearr_21277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21272__$1,(9),inst_21258);
} else {
if((state_val_21273 === (3))){
var inst_21270 = (state_21272[(2)]);
var state_21272__$1 = state_21272;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21272__$1,inst_21270);
} else {
if((state_val_21273 === (2))){
var inst_21258 = (state_21272[(7)]);
var _ = (function (){var statearr_21279 = state_21272;
(statearr_21279[(4)] = cljs.core.cons.call(null,(5),(state_21272[(4)])));

return statearr_21279;
})();
var inst_21258__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_21272__$1 = (function (){var statearr_21280 = state_21272;
(statearr_21280[(7)] = inst_21258__$1);

return statearr_21280;
})();
if(cljs.core.truth_(inst_21258__$1)){
var statearr_21281_21297 = state_21272__$1;
(statearr_21281_21297[(1)] = (6));

} else {
var statearr_21282_21298 = state_21272__$1;
(statearr_21282_21298[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (9))){
var inst_21260 = (state_21272[(8)]);
var inst_21262 = (state_21272[(2)]);
var inst_21263 = fluree.db.util.async.throw_err.call(null,inst_21262);
var inst_21264 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_21260,inst_21263);
var state_21272__$1 = state_21272;
var statearr_21283_21299 = state_21272__$1;
(statearr_21283_21299[(2)] = inst_21264);

(statearr_21283_21299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (5))){
var _ = (function (){var statearr_21284 = state_21272;
(statearr_21284[(4)] = cljs.core.rest.call(null,(state_21272[(4)])));

return statearr_21284;
})();
var state_21272__$1 = state_21272;
var ex21278 = (state_21272__$1[(2)]);
var statearr_21285_21300 = state_21272__$1;
(statearr_21285_21300[(5)] = ex21278);


if((ex21278 instanceof Error)){
var statearr_21286_21301 = state_21272__$1;
(statearr_21286_21301[(1)] = (4));

(statearr_21286_21301[(5)] = null);

} else {
throw ex21278;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21273 === (8))){
var inst_21267 = (state_21272[(2)]);
var _ = (function (){var statearr_21287 = state_21272;
(statearr_21287[(4)] = cljs.core.rest.call(null,(state_21272[(4)])));

return statearr_21287;
})();
var state_21272__$1 = state_21272;
var statearr_21288_21302 = state_21272__$1;
(statearr_21288_21302[(2)] = inst_21267);

(statearr_21288_21302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2726__auto____0 = (function (){
var statearr_21289 = [null,null,null,null,null,null,null,null,null];
(statearr_21289[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2726__auto__);

(statearr_21289[(1)] = (1));

return statearr_21289;
});
var fluree$db$storage$core$read_branch_$_state_machine__2726__auto____1 = (function (state_21272){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21272);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21290){var ex__2729__auto__ = e21290;
var statearr_21291_21303 = state_21272;
(statearr_21291_21303[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21272[(4)]))){
var statearr_21292_21304 = state_21272;
(statearr_21292_21304[(1)] = cljs.core.first.call(null,(state_21272[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21305 = state_21272;
state_21272 = G__21305;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2726__auto__ = function(state_21272){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2726__auto____1.call(this,state_21272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2726__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2726__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21293 = f__2749__auto__.call(null);
(statearr_21293[(6)] = c__2748__auto__);

return statearr_21293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2748__auto___21384 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21356){
var state_val_21357 = (state_21356[(1)]);
if((state_val_21357 === (7))){
var inst_21323 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_21324 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21325 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_21326 = cljs.core.PersistentHashMap.fromArrays(inst_21324,inst_21325);
var inst_21327 = cljs.core.ex_info.call(null,inst_21323,inst_21326);
var inst_21328 = (function(){throw inst_21327})();
var state_21356__$1 = state_21356;
var statearr_21358_21385 = state_21356__$1;
(statearr_21358_21385[(2)] = inst_21328);

(statearr_21358_21385[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (1))){
var state_21356__$1 = state_21356;
var statearr_21359_21386 = state_21356__$1;
(statearr_21359_21386[(2)] = null);

(statearr_21359_21386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (4))){
var inst_21306 = (state_21356[(2)]);
var inst_21307 = error_fn.call(null);
var inst_21308 = cljs.core.async.put_BANG_.call(null,return_ch,inst_21306);
var inst_21309 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_21356__$1 = (function (){var statearr_21360 = state_21356;
(statearr_21360[(7)] = inst_21307);

(statearr_21360[(8)] = inst_21308);

return statearr_21360;
})();
var statearr_21361_21387 = state_21356__$1;
(statearr_21361_21387[(2)] = inst_21309);

(statearr_21361_21387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (6))){
var inst_21320 = (state_21356[(9)]);
var inst_21319 = (state_21356[(2)]);
var inst_21320__$1 = fluree.db.util.async.throw_err.call(null,inst_21319);
var inst_21321 = (inst_21320__$1 == null);
var state_21356__$1 = (function (){var statearr_21362 = state_21356;
(statearr_21362[(9)] = inst_21320__$1);

return statearr_21362;
})();
if(cljs.core.truth_(inst_21321)){
var statearr_21363_21388 = state_21356__$1;
(statearr_21363_21388[(1)] = (7));

} else {
var statearr_21364_21389 = state_21356__$1;
(statearr_21364_21389[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (3))){
var inst_21354 = (state_21356[(2)]);
var state_21356__$1 = state_21356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21356__$1,inst_21354);
} else {
if((state_val_21357 === (12))){
var inst_21320 = (state_21356[(9)]);
var inst_21337 = (state_21356[(2)]);
var inst_21338 = cljs.core.__destructure_map.call(null,inst_21320);
var inst_21339 = cljs.core.get.call(null,inst_21338,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_21340 = cljs.core.get.call(null,inst_21338,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_21341 = config;
var inst_21342 = cljs.core.__destructure_map.call(null,inst_21341);
var inst_21343 = cljs.core.get.call(null,inst_21342,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_21345 = (function (){var data = inst_21320;
var _ = inst_21337;
var map__21315 = inst_21338;
var children = inst_21339;
var rhs = inst_21340;
var map__21316 = inst_21342;
var comparator = inst_21343;
return (function (idx,p__21344){
var map__21365 = p__21344;
var map__21365__$1 = cljs.core.__destructure_map.call(null,map__21365);
var child = map__21365__$1;
var id = cljs.core.get.call(null,map__21365__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__21365__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__21365__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__21365__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__21365__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4221__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (idx === (0));
} else {
return and__4221__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_21346 = cljs.core.map_indexed.call(null,inst_21345,inst_21339);
var inst_21347 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_21346);
var inst_21348 = cljs.core.interleave.call(null,inst_21347,inst_21346);
var inst_21349 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_21343,inst_21348);
var inst_21350 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_21340,inst_21349,config,leftmost_QMARK_);
var inst_21351 = cljs.core.async.put_BANG_.call(null,return_ch,inst_21350);
var _ = (function (){var statearr_21366 = state_21356;
(statearr_21366[(4)] = cljs.core.rest.call(null,(state_21356[(4)])));

return statearr_21366;
})();
var state_21356__$1 = state_21356;
var statearr_21367_21390 = state_21356__$1;
(statearr_21367_21390[(2)] = inst_21351);

(statearr_21367_21390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (2))){
var _ = (function (){var statearr_21368 = state_21356;
(statearr_21368[(4)] = cljs.core.cons.call(null,(5),(state_21356[(4)])));

return statearr_21368;
})();
var inst_21317 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_21356__$1 = state_21356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21356__$1,(6),inst_21317);
} else {
if((state_val_21357 === (11))){
var state_21356__$1 = state_21356;
var statearr_21370_21391 = state_21356__$1;
(statearr_21370_21391[(2)] = null);

(statearr_21370_21391[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (9))){
var inst_21320 = (state_21356[(9)]);
var inst_21331 = (state_21356[(2)]);
var inst_21332 = fluree.db.util.core.exception_QMARK_.call(null,inst_21320);
var state_21356__$1 = (function (){var statearr_21371 = state_21356;
(statearr_21371[(10)] = inst_21331);

return statearr_21371;
})();
if(inst_21332){
var statearr_21372_21392 = state_21356__$1;
(statearr_21372_21392[(1)] = (10));

} else {
var statearr_21373_21393 = state_21356__$1;
(statearr_21373_21393[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (5))){
var _ = (function (){var statearr_21374 = state_21356;
(statearr_21374[(4)] = cljs.core.rest.call(null,(state_21356[(4)])));

return statearr_21374;
})();
var state_21356__$1 = state_21356;
var ex21369 = (state_21356__$1[(2)]);
var statearr_21375_21394 = state_21356__$1;
(statearr_21375_21394[(5)] = ex21369);


var statearr_21376_21395 = state_21356__$1;
(statearr_21376_21395[(1)] = (4));

(statearr_21376_21395[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (10))){
var inst_21320 = (state_21356[(9)]);
var inst_21334 = (function(){throw inst_21320})();
var state_21356__$1 = state_21356;
var statearr_21377_21396 = state_21356__$1;
(statearr_21377_21396[(2)] = inst_21334);

(statearr_21377_21396[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21357 === (8))){
var state_21356__$1 = state_21356;
var statearr_21378_21397 = state_21356__$1;
(statearr_21378_21397[(2)] = null);

(statearr_21378_21397[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2726__auto____0 = (function (){
var statearr_21379 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21379[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2726__auto__);

(statearr_21379[(1)] = (1));

return statearr_21379;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2726__auto____1 = (function (state_21356){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21380){var ex__2729__auto__ = e21380;
var statearr_21381_21398 = state_21356;
(statearr_21381_21398[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21356[(4)]))){
var statearr_21382_21399 = state_21356;
(statearr_21382_21399[(1)] = cljs.core.first.call(null,(state_21356[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21400 = state_21356;
state_21356 = G__21400;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2726__auto__ = function(state_21356){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2726__auto____1.call(this,state_21356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2726__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2726__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21383 = f__2749__auto__.call(null);
(statearr_21383[(6)] = c__2748__auto___21384);

return statearr_21383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21421){
var state_val_21422 = (state_21421[(1)]);
if((state_val_21422 === (7))){
var state_21421__$1 = state_21421;
var statearr_21423_21443 = state_21421__$1;
(statearr_21423_21443[(2)] = null);

(statearr_21423_21443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21422 === (1))){
var state_21421__$1 = state_21421;
var statearr_21424_21444 = state_21421__$1;
(statearr_21424_21444[(2)] = null);

(statearr_21424_21444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21422 === (4))){
var inst_21401 = (state_21421[(2)]);
var state_21421__$1 = state_21421;
var statearr_21425_21445 = state_21421__$1;
(statearr_21425_21445[(2)] = inst_21401);

(statearr_21425_21445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21422 === (6))){
var inst_21407 = (state_21421[(7)]);
var inst_21409 = fluree.db.storage.core.serde.call(null,conn);
var state_21421__$1 = (function (){var statearr_21426 = state_21421;
(statearr_21426[(8)] = inst_21409);

return statearr_21426;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21421__$1,(9),inst_21407);
} else {
if((state_val_21422 === (3))){
var inst_21419 = (state_21421[(2)]);
var state_21421__$1 = state_21421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21421__$1,inst_21419);
} else {
if((state_val_21422 === (2))){
var inst_21407 = (state_21421[(7)]);
var _ = (function (){var statearr_21428 = state_21421;
(statearr_21428[(4)] = cljs.core.cons.call(null,(5),(state_21421[(4)])));

return statearr_21428;
})();
var inst_21407__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_21421__$1 = (function (){var statearr_21429 = state_21421;
(statearr_21429[(7)] = inst_21407__$1);

return statearr_21429;
})();
if(cljs.core.truth_(inst_21407__$1)){
var statearr_21430_21446 = state_21421__$1;
(statearr_21430_21446[(1)] = (6));

} else {
var statearr_21431_21447 = state_21421__$1;
(statearr_21431_21447[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21422 === (9))){
var inst_21409 = (state_21421[(8)]);
var inst_21411 = (state_21421[(2)]);
var inst_21412 = fluree.db.util.async.throw_err.call(null,inst_21411);
var inst_21413 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_21409,inst_21412);
var state_21421__$1 = state_21421;
var statearr_21432_21448 = state_21421__$1;
(statearr_21432_21448[(2)] = inst_21413);

(statearr_21432_21448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21422 === (5))){
var _ = (function (){var statearr_21433 = state_21421;
(statearr_21433[(4)] = cljs.core.rest.call(null,(state_21421[(4)])));

return statearr_21433;
})();
var state_21421__$1 = state_21421;
var ex21427 = (state_21421__$1[(2)]);
var statearr_21434_21449 = state_21421__$1;
(statearr_21434_21449[(5)] = ex21427);


if((ex21427 instanceof Error)){
var statearr_21435_21450 = state_21421__$1;
(statearr_21435_21450[(1)] = (4));

(statearr_21435_21450[(5)] = null);

} else {
throw ex21427;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21422 === (8))){
var inst_21416 = (state_21421[(2)]);
var _ = (function (){var statearr_21436 = state_21421;
(statearr_21436[(4)] = cljs.core.rest.call(null,(state_21421[(4)])));

return statearr_21436;
})();
var state_21421__$1 = state_21421;
var statearr_21437_21451 = state_21421__$1;
(statearr_21437_21451[(2)] = inst_21416);

(statearr_21437_21451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2726__auto____0 = (function (){
var statearr_21438 = [null,null,null,null,null,null,null,null,null];
(statearr_21438[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2726__auto__);

(statearr_21438[(1)] = (1));

return statearr_21438;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2726__auto____1 = (function (state_21421){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21439){var ex__2729__auto__ = e21439;
var statearr_21440_21452 = state_21421;
(statearr_21440_21452[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21421[(4)]))){
var statearr_21441_21453 = state_21421;
(statearr_21441_21453[(1)] = cljs.core.first.call(null,(state_21421[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21454 = state_21421;
state_21421 = G__21454;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2726__auto__ = function(state_21421){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2726__auto____1.call(this,state_21421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2726__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2726__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21442 = f__2749__auto__.call(null);
(statearr_21442[(6)] = c__2748__auto__);

return statearr_21442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2748__auto___21527 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21499){
var state_val_21500 = (state_21499[(1)]);
if((state_val_21500 === (7))){
var inst_21471 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_21472 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21473 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_21474 = cljs.core.PersistentHashMap.fromArrays(inst_21472,inst_21473);
var inst_21475 = cljs.core.ex_info.call(null,inst_21471,inst_21474);
var inst_21476 = (function(){throw inst_21475})();
var state_21499__$1 = state_21499;
var statearr_21501_21528 = state_21499__$1;
(statearr_21501_21528[(2)] = inst_21476);

(statearr_21501_21528[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (1))){
var state_21499__$1 = state_21499;
var statearr_21502_21529 = state_21499__$1;
(statearr_21502_21529[(2)] = null);

(statearr_21502_21529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (4))){
var inst_21455 = (state_21499[(2)]);
var inst_21456 = error_fn.call(null);
var inst_21457 = cljs.core.async.put_BANG_.call(null,return_ch,inst_21455);
var inst_21458 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_21499__$1 = (function (){var statearr_21503 = state_21499;
(statearr_21503[(7)] = inst_21456);

(statearr_21503[(8)] = inst_21457);

return statearr_21503;
})();
var statearr_21504_21530 = state_21499__$1;
(statearr_21504_21530[(2)] = inst_21458);

(statearr_21504_21530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (6))){
var inst_21468 = (state_21499[(9)]);
var inst_21468__$1 = (state_21499[(2)]);
var inst_21469 = (inst_21468__$1 == null);
var state_21499__$1 = (function (){var statearr_21505 = state_21499;
(statearr_21505[(9)] = inst_21468__$1);

return statearr_21505;
})();
if(cljs.core.truth_(inst_21469)){
var statearr_21506_21531 = state_21499__$1;
(statearr_21506_21531[(1)] = (7));

} else {
var statearr_21507_21532 = state_21499__$1;
(statearr_21507_21532[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (3))){
var inst_21497 = (state_21499[(2)]);
var state_21499__$1 = state_21499;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21499__$1,inst_21497);
} else {
if((state_val_21500 === (12))){
var inst_21468 = (state_21499[(9)]);
var inst_21485 = (state_21499[(2)]);
var inst_21486 = cljs.core.__destructure_map.call(null,inst_21468);
var inst_21487 = cljs.core.get.call(null,inst_21486,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_21488 = cljs.core.get.call(null,inst_21486,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_21489 = config;
var inst_21490 = cljs.core.__destructure_map.call(null,inst_21489);
var inst_21491 = cljs.core.get.call(null,inst_21490,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_21492 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_21491,inst_21487);
var inst_21493 = fluree.db.index.data_node.call(null,block,t,inst_21492,rhs,config);
var inst_21494 = cljs.core.async.put_BANG_.call(null,return_ch,inst_21493);
var _ = (function (){var statearr_21508 = state_21499;
(statearr_21508[(4)] = cljs.core.rest.call(null,(state_21499[(4)])));

return statearr_21508;
})();
var state_21499__$1 = (function (){var statearr_21509 = state_21499;
(statearr_21509[(10)] = inst_21488);

(statearr_21509[(11)] = inst_21485);

return statearr_21509;
})();
var statearr_21510_21533 = state_21499__$1;
(statearr_21510_21533[(2)] = inst_21494);

(statearr_21510_21533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (2))){
var _ = (function (){var statearr_21511 = state_21499;
(statearr_21511[(4)] = cljs.core.cons.call(null,(5),(state_21499[(4)])));

return statearr_21511;
})();
var inst_21466 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_21499__$1 = state_21499;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21499__$1,(6),inst_21466);
} else {
if((state_val_21500 === (11))){
var state_21499__$1 = state_21499;
var statearr_21513_21534 = state_21499__$1;
(statearr_21513_21534[(2)] = null);

(statearr_21513_21534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (9))){
var inst_21468 = (state_21499[(9)]);
var inst_21479 = (state_21499[(2)]);
var inst_21480 = fluree.db.util.core.exception_QMARK_.call(null,inst_21468);
var state_21499__$1 = (function (){var statearr_21514 = state_21499;
(statearr_21514[(12)] = inst_21479);

return statearr_21514;
})();
if(inst_21480){
var statearr_21515_21535 = state_21499__$1;
(statearr_21515_21535[(1)] = (10));

} else {
var statearr_21516_21536 = state_21499__$1;
(statearr_21516_21536[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (5))){
var _ = (function (){var statearr_21517 = state_21499;
(statearr_21517[(4)] = cljs.core.rest.call(null,(state_21499[(4)])));

return statearr_21517;
})();
var state_21499__$1 = state_21499;
var ex21512 = (state_21499__$1[(2)]);
var statearr_21518_21537 = state_21499__$1;
(statearr_21518_21537[(5)] = ex21512);


var statearr_21519_21538 = state_21499__$1;
(statearr_21519_21538[(1)] = (4));

(statearr_21519_21538[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (10))){
var inst_21468 = (state_21499[(9)]);
var inst_21482 = (function(){throw inst_21468})();
var state_21499__$1 = state_21499;
var statearr_21520_21539 = state_21499__$1;
(statearr_21520_21539[(2)] = inst_21482);

(statearr_21520_21539[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21500 === (8))){
var state_21499__$1 = state_21499;
var statearr_21521_21540 = state_21499__$1;
(statearr_21521_21540[(2)] = null);

(statearr_21521_21540[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto____0 = (function (){
var statearr_21522 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21522[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto__);

(statearr_21522[(1)] = (1));

return statearr_21522;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto____1 = (function (state_21499){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21499);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21523){var ex__2729__auto__ = e21523;
var statearr_21524_21541 = state_21499;
(statearr_21524_21541[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21499[(4)]))){
var statearr_21525_21542 = state_21499;
(statearr_21525_21542[(1)] = cljs.core.first.call(null,(state_21499[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21543 = state_21499;
state_21499 = G__21543;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto__ = function(state_21499){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto____1.call(this,state_21499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21526 = f__2749__auto__.call(null);
(statearr_21526[(6)] = c__2748__auto___21527);

return statearr_21526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k21545,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__21549 = k21545;
var G__21549__$1 = (((G__21549 instanceof cljs.core.Keyword))?G__21549.fqn:null);
switch (G__21549__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k21545,else__4475__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4495__auto__,p__21550){
var vec__21551 = p__21550;
var k__4496__auto__ = cljs.core.nth.call(null,vec__21551,(0),null);
var v__4497__auto__ = cljs.core.nth.call(null,vec__21551,(1),null);
return f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__);
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4489__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21544){
var self__ = this;
var G__21544__$1 = this;
return (new cljs.core.RecordIter((0),G__21544__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (coll__4469__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4469__auto__));
}).call(null,this__4468__auto____$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21546,other21547){
var self__ = this;
var this21546__$1 = this;
return (((!((other21547 == null)))) && ((((this21546__$1.constructor === other21547.constructor)) && (((cljs.core._EQ_.call(null,this21546__$1.conn,other21547.conn)) && (((cljs.core._EQ_.call(null,this21546__$1.config,other21547.config)) && (((cljs.core._EQ_.call(null,this21546__$1.network,other21547.network)) && (((cljs.core._EQ_.call(null,this21546__$1.dbid,other21547.dbid)) && (((cljs.core._EQ_.call(null,this21546__$1.id,other21547.id)) && (((cljs.core._EQ_.call(null,this21546__$1.leaf,other21547.leaf)) && (((cljs.core._EQ_.call(null,this21546__$1.first,other21547.first)) && (((cljs.core._EQ_.call(null,this21546__$1.rhs,other21547.rhs)) && (((cljs.core._EQ_.call(null,this21546__$1.size,other21547.size)) && (((cljs.core._EQ_.call(null,this21546__$1.block,other21547.block)) && (((cljs.core._EQ_.call(null,this21546__$1.t,other21547.t)) && (((cljs.core._EQ_.call(null,this21546__$1.tt_id,other21547.tt_id)) && (((cljs.core._EQ_.call(null,this21546__$1.leftmost_QMARK_,other21547.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this21546__$1.tempid,other21547.tempid)) && (cljs.core._EQ_.call(null,this21546__$1.__extmap,other21547.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k21545){
var self__ = this;
var this__4479__auto____$1 = this;
var G__21554 = k21545;
var G__21554__$1 = (((G__21554 instanceof cljs.core.Keyword))?G__21554.fqn:null);
switch (G__21554__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k21545);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__21544){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__21555 = cljs.core.keyword_identical_QMARK_;
var expr__21556 = k__4481__auto__;
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(G__21544,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__21544,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__21544,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__21544,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__21544,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__21544,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__21544,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__21544,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__21544,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__21544,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__21544,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__21544,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__21544,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21555.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__21556))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__21544,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4481__auto__,G__21544),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__21544){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__21544,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4478__auto__,(0)),cljs.core._nth.call(null,entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write.call(null,writer__4517__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__21548){
var extmap__4512__auto__ = (function (){var G__21558 = cljs.core.dissoc.call(null,G__21548,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__21548)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__21558);
} else {
return G__21558;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__21548),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__21548),null,cljs.core.not_empty.call(null,extmap__4512__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4223__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__21561 = blank_db;
var map__21561__$1 = cljs.core.__destructure_map.call(null,map__21561);
var network = cljs.core.get.call(null,map__21561__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__21561__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__21561__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__21562 = root_data;
var map__21562__$1 = cljs.core.__destructure_map.call(null,map__21562);
var block = cljs.core.get.call(null,map__21562__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__21562__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__21562__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__21562__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21584){
var state_val_21585 = (state_21584[(1)]);
if((state_val_21585 === (7))){
var state_21584__$1 = state_21584;
var statearr_21586_21606 = state_21584__$1;
(statearr_21586_21606[(2)] = null);

(statearr_21586_21606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21585 === (1))){
var state_21584__$1 = state_21584;
var statearr_21587_21607 = state_21584__$1;
(statearr_21587_21607[(2)] = null);

(statearr_21587_21607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21585 === (4))){
var inst_21563 = (state_21584[(2)]);
var state_21584__$1 = state_21584;
var statearr_21588_21608 = state_21584__$1;
(statearr_21588_21608[(2)] = inst_21563);

(statearr_21588_21608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21585 === (6))){
var inst_21570 = (state_21584[(7)]);
var inst_21572 = fluree.db.storage.core.serde.call(null,conn);
var state_21584__$1 = (function (){var statearr_21589 = state_21584;
(statearr_21589[(8)] = inst_21572);

return statearr_21589;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21584__$1,(9),inst_21570);
} else {
if((state_val_21585 === (3))){
var inst_21582 = (state_21584[(2)]);
var state_21584__$1 = state_21584;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21584__$1,inst_21582);
} else {
if((state_val_21585 === (2))){
var inst_21570 = (state_21584[(7)]);
var _ = (function (){var statearr_21591 = state_21584;
(statearr_21591[(4)] = cljs.core.cons.call(null,(5),(state_21584[(4)])));

return statearr_21591;
})();
var inst_21569 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_21570__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_21569);
var state_21584__$1 = (function (){var statearr_21592 = state_21584;
(statearr_21592[(7)] = inst_21570__$1);

return statearr_21592;
})();
if(cljs.core.truth_(inst_21570__$1)){
var statearr_21593_21609 = state_21584__$1;
(statearr_21593_21609[(1)] = (6));

} else {
var statearr_21594_21610 = state_21584__$1;
(statearr_21594_21610[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21585 === (9))){
var inst_21572 = (state_21584[(8)]);
var inst_21574 = (state_21584[(2)]);
var inst_21575 = fluree.db.util.async.throw_err.call(null,inst_21574);
var inst_21576 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_21572,inst_21575);
var state_21584__$1 = state_21584;
var statearr_21595_21611 = state_21584__$1;
(statearr_21595_21611[(2)] = inst_21576);

(statearr_21595_21611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21585 === (5))){
var _ = (function (){var statearr_21596 = state_21584;
(statearr_21596[(4)] = cljs.core.rest.call(null,(state_21584[(4)])));

return statearr_21596;
})();
var state_21584__$1 = state_21584;
var ex21590 = (state_21584__$1[(2)]);
var statearr_21597_21612 = state_21584__$1;
(statearr_21597_21612[(5)] = ex21590);


if((ex21590 instanceof Error)){
var statearr_21598_21613 = state_21584__$1;
(statearr_21598_21613[(1)] = (4));

(statearr_21598_21613[(5)] = null);

} else {
throw ex21590;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21585 === (8))){
var inst_21579 = (state_21584[(2)]);
var _ = (function (){var statearr_21599 = state_21584;
(statearr_21599[(4)] = cljs.core.rest.call(null,(state_21584[(4)])));

return statearr_21599;
})();
var state_21584__$1 = state_21584;
var statearr_21600_21614 = state_21584__$1;
(statearr_21600_21614[(2)] = inst_21579);

(statearr_21600_21614[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2726__auto____0 = (function (){
var statearr_21601 = [null,null,null,null,null,null,null,null,null];
(statearr_21601[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2726__auto__);

(statearr_21601[(1)] = (1));

return statearr_21601;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2726__auto____1 = (function (state_21584){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21602){var ex__2729__auto__ = e21602;
var statearr_21603_21615 = state_21584;
(statearr_21603_21615[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21584[(4)]))){
var statearr_21604_21616 = state_21584;
(statearr_21604_21616[(1)] = cljs.core.first.call(null,(state_21584[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21617 = state_21584;
state_21584 = G__21617;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2726__auto__ = function(state_21584){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2726__auto____1.call(this,state_21584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2726__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2726__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21605 = f__2749__auto__.call(null);
(statearr_21605[(6)] = c__2748__auto__);

return statearr_21605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21639){
var state_val_21640 = (state_21639[(1)]);
if((state_val_21640 === (7))){
var state_21639__$1 = state_21639;
var statearr_21641_21661 = state_21639__$1;
(statearr_21641_21661[(2)] = null);

(statearr_21641_21661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (1))){
var state_21639__$1 = state_21639;
var statearr_21642_21662 = state_21639__$1;
(statearr_21642_21662[(2)] = null);

(statearr_21642_21662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (4))){
var inst_21618 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
var statearr_21643_21663 = state_21639__$1;
(statearr_21643_21663[(2)] = inst_21618);

(statearr_21643_21663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (6))){
var inst_21625 = (state_21639[(7)]);
var inst_21627 = fluree.db.storage.core.serde.call(null,conn);
var state_21639__$1 = (function (){var statearr_21644 = state_21639;
(statearr_21644[(8)] = inst_21627);

return statearr_21644;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21639__$1,(9),inst_21625);
} else {
if((state_val_21640 === (3))){
var inst_21637 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21639__$1,inst_21637);
} else {
if((state_val_21640 === (2))){
var inst_21625 = (state_21639[(7)]);
var _ = (function (){var statearr_21646 = state_21639;
(statearr_21646[(4)] = cljs.core.cons.call(null,(5),(state_21639[(4)])));

return statearr_21646;
})();
var inst_21624 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_21625__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_21624);
var state_21639__$1 = (function (){var statearr_21647 = state_21639;
(statearr_21647[(7)] = inst_21625__$1);

return statearr_21647;
})();
if(cljs.core.truth_(inst_21625__$1)){
var statearr_21648_21664 = state_21639__$1;
(statearr_21648_21664[(1)] = (6));

} else {
var statearr_21649_21665 = state_21639__$1;
(statearr_21649_21665[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (9))){
var inst_21627 = (state_21639[(8)]);
var inst_21629 = (state_21639[(2)]);
var inst_21630 = fluree.db.util.async.throw_err.call(null,inst_21629);
var inst_21631 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_21627,inst_21630);
var state_21639__$1 = state_21639;
var statearr_21650_21666 = state_21639__$1;
(statearr_21650_21666[(2)] = inst_21631);

(statearr_21650_21666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (5))){
var _ = (function (){var statearr_21651 = state_21639;
(statearr_21651[(4)] = cljs.core.rest.call(null,(state_21639[(4)])));

return statearr_21651;
})();
var state_21639__$1 = state_21639;
var ex21645 = (state_21639__$1[(2)]);
var statearr_21652_21667 = state_21639__$1;
(statearr_21652_21667[(5)] = ex21645);


if((ex21645 instanceof Error)){
var statearr_21653_21668 = state_21639__$1;
(statearr_21653_21668[(1)] = (4));

(statearr_21653_21668[(5)] = null);

} else {
throw ex21645;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (8))){
var inst_21634 = (state_21639[(2)]);
var _ = (function (){var statearr_21654 = state_21639;
(statearr_21654[(4)] = cljs.core.rest.call(null,(state_21639[(4)])));

return statearr_21654;
})();
var state_21639__$1 = state_21639;
var statearr_21655_21669 = state_21639__$1;
(statearr_21655_21669[(2)] = inst_21634);

(statearr_21655_21669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2726__auto____0 = (function (){
var statearr_21656 = [null,null,null,null,null,null,null,null,null];
(statearr_21656[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2726__auto__);

(statearr_21656[(1)] = (1));

return statearr_21656;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2726__auto____1 = (function (state_21639){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21639);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21657){var ex__2729__auto__ = e21657;
var statearr_21658_21670 = state_21639;
(statearr_21658_21670[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21639[(4)]))){
var statearr_21659_21671 = state_21639;
(statearr_21659_21671[(1)] = cljs.core.first.call(null,(state_21639[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21672 = state_21639;
state_21639 = G__21672;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2726__auto__ = function(state_21639){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2726__auto____1.call(this,state_21639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2726__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2726__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21660 = f__2749__auto__.call(null);
(statearr_21660[(6)] = c__2748__auto__);

return statearr_21660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21708){
var state_val_21709 = (state_21708[(1)]);
if((state_val_21709 === (7))){
var inst_21682 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_21683 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21684 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_21685 = cljs.core.PersistentHashMap.fromArrays(inst_21683,inst_21684);
var inst_21686 = cljs.core.ex_info.call(null,inst_21682,inst_21685);
var inst_21687 = (function(){throw inst_21686})();
var state_21708__$1 = state_21708;
var statearr_21710_21732 = state_21708__$1;
(statearr_21710_21732[(2)] = inst_21687);

(statearr_21710_21732[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21709 === (1))){
var state_21708__$1 = state_21708;
var statearr_21711_21733 = state_21708__$1;
(statearr_21711_21733[(2)] = null);

(statearr_21711_21733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21709 === (4))){
var inst_21673 = (state_21708[(2)]);
var state_21708__$1 = state_21708;
var statearr_21712_21734 = state_21708__$1;
(statearr_21712_21734[(2)] = inst_21673);

(statearr_21712_21734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21709 === (6))){
var state_21708__$1 = state_21708;
var statearr_21713_21735 = state_21708__$1;
(statearr_21713_21735[(2)] = null);

(statearr_21713_21735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21709 === (3))){
var inst_21706 = (state_21708[(2)]);
var state_21708__$1 = state_21708;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21708__$1,inst_21706);
} else {
if((state_val_21709 === (2))){
var inst_21679 = (state_21708[(7)]);
var _ = (function (){var statearr_21714 = state_21708;
(statearr_21714[(4)] = cljs.core.cons.call(null,(5),(state_21708[(4)])));

return statearr_21714;
})();
var inst_21679__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_21708__$1 = (function (){var statearr_21715 = state_21708;
(statearr_21715[(7)] = inst_21679__$1);

return statearr_21715;
})();
if(cljs.core.truth_(inst_21679__$1)){
var statearr_21716_21736 = state_21708__$1;
(statearr_21716_21736[(1)] = (6));

} else {
var statearr_21717_21737 = state_21708__$1;
(statearr_21717_21737[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21709 === (11))){
var inst_21698 = (state_21708[(8)]);
var inst_21701 = (state_21708[(2)]);
var inst_21702 = fluree.db.util.async.throw_err.call(null,inst_21701);
var inst_21703 = cljs.core.assoc.call(null,inst_21698,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_21702);
var _ = (function (){var statearr_21719 = state_21708;
(statearr_21719[(4)] = cljs.core.rest.call(null,(state_21708[(4)])));

return statearr_21719;
})();
var state_21708__$1 = state_21708;
var statearr_21720_21738 = state_21708__$1;
(statearr_21720_21738[(2)] = inst_21703);

(statearr_21720_21738[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21709 === (9))){
var inst_21693 = (state_21708[(9)]);
var inst_21691 = (state_21708[(2)]);
var inst_21692 = fluree.db.util.async.throw_err.call(null,inst_21691);
var inst_21693__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_21692);
var inst_21694 = fluree.db.query.schema.schema_map.call(null,inst_21693__$1);
var state_21708__$1 = (function (){var statearr_21721 = state_21708;
(statearr_21721[(9)] = inst_21693__$1);

return statearr_21721;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21708__$1,(10),inst_21694);
} else {
if((state_val_21709 === (5))){
var _ = (function (){var statearr_21722 = state_21708;
(statearr_21722[(4)] = cljs.core.rest.call(null,(state_21708[(4)])));

return statearr_21722;
})();
var state_21708__$1 = state_21708;
var ex21718 = (state_21708__$1[(2)]);
var statearr_21723_21739 = state_21708__$1;
(statearr_21723_21739[(5)] = ex21718);


if((ex21718 instanceof Error)){
var statearr_21724_21740 = state_21708__$1;
(statearr_21724_21740[(1)] = (4));

(statearr_21724_21740[(5)] = null);

} else {
throw ex21718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21709 === (10))){
var inst_21693 = (state_21708[(9)]);
var inst_21698 = (state_21708[(8)]);
var inst_21696 = (state_21708[(2)]);
var inst_21697 = fluree.db.util.async.throw_err.call(null,inst_21696);
var inst_21698__$1 = cljs.core.assoc.call(null,inst_21693,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_21697);
var inst_21699 = fluree.db.query.schema.setting_map.call(null,inst_21698__$1);
var state_21708__$1 = (function (){var statearr_21725 = state_21708;
(statearr_21725[(8)] = inst_21698__$1);

return statearr_21725;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21708__$1,(11),inst_21699);
} else {
if((state_val_21709 === (8))){
var inst_21679 = (state_21708[(7)]);
var inst_21689 = (state_21708[(2)]);
var state_21708__$1 = (function (){var statearr_21726 = state_21708;
(statearr_21726[(10)] = inst_21689);

return statearr_21726;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21708__$1,(9),inst_21679);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2726__auto____0 = (function (){
var statearr_21727 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21727[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2726__auto__);

(statearr_21727[(1)] = (1));

return statearr_21727;
});
var fluree$db$storage$core$reify_db_$_state_machine__2726__auto____1 = (function (state_21708){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21708);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21728){var ex__2729__auto__ = e21728;
var statearr_21729_21741 = state_21708;
(statearr_21729_21741[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21708[(4)]))){
var statearr_21730_21742 = state_21708;
(statearr_21730_21742[(1)] = cljs.core.first.call(null,(state_21708[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21743 = state_21708;
state_21708 = G__21743;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2726__auto__ = function(state_21708){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2726__auto____1.call(this,state_21708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2726__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2726__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21731 = f__2749__auto__.call(null);
(statearr_21731[(6)] = c__2748__auto__);

return statearr_21731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__21745 = arguments.length;
switch (G__21745) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21798){
var state_val_21799 = (state_21798[(1)]);
if((state_val_21799 === (7))){
var inst_21755 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_21756 = (new Error(inst_21755));
var inst_21757 = (function(){throw inst_21756})();
var state_21798__$1 = state_21798;
var statearr_21800_21840 = state_21798__$1;
(statearr_21800_21840[(2)] = inst_21757);

(statearr_21800_21840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (20))){
var inst_21789 = (state_21798[(2)]);
var state_21798__$1 = state_21798;
var statearr_21801_21841 = state_21798__$1;
(statearr_21801_21841[(2)] = inst_21789);

(statearr_21801_21841[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (1))){
var state_21798__$1 = state_21798;
var statearr_21802_21842 = state_21798__$1;
(statearr_21802_21842[(2)] = null);

(statearr_21802_21842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (4))){
var inst_21746 = (state_21798[(2)]);
var state_21798__$1 = state_21798;
var statearr_21803_21843 = state_21798__$1;
(statearr_21803_21843[(2)] = inst_21746);

(statearr_21803_21843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (15))){
var inst_21764 = (state_21798[(7)]);
var state_21798__$1 = state_21798;
var statearr_21804_21844 = state_21798__$1;
(statearr_21804_21844[(2)] = inst_21764);

(statearr_21804_21844[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (21))){
var inst_21764 = (state_21798[(7)]);
var inst_21763 = (state_21798[(8)]);
var inst_21768 = (state_21798[(9)]);
var inst_21782 = (inst_21763 + (1));
var inst_21783 = cljs.core.conj.call(null,inst_21764,inst_21768);
var inst_21763__$1 = inst_21782;
var inst_21764__$1 = inst_21783;
var state_21798__$1 = (function (){var statearr_21805 = state_21798;
(statearr_21805[(7)] = inst_21764__$1);

(statearr_21805[(8)] = inst_21763__$1);

return statearr_21805;
})();
var statearr_21806_21845 = state_21798__$1;
(statearr_21806_21845[(2)] = null);

(statearr_21806_21845[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (13))){
var inst_21768 = (state_21798[(9)]);
var inst_21772 = (inst_21768 instanceof Error);
var state_21798__$1 = state_21798;
var statearr_21807_21846 = state_21798__$1;
(statearr_21807_21846[(2)] = inst_21772);

(statearr_21807_21846[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (22))){
var state_21798__$1 = state_21798;
var statearr_21808_21847 = state_21798__$1;
(statearr_21808_21847[(2)] = null);

(statearr_21808_21847[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (6))){
var state_21798__$1 = state_21798;
var statearr_21809_21848 = state_21798__$1;
(statearr_21809_21848[(2)] = null);

(statearr_21809_21848[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (17))){
var inst_21791 = (state_21798[(2)]);
var state_21798__$1 = state_21798;
var statearr_21810_21849 = state_21798__$1;
(statearr_21810_21849[(2)] = inst_21791);

(statearr_21810_21849[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (3))){
var inst_21796 = (state_21798[(2)]);
var state_21798__$1 = state_21798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21798__$1,inst_21796);
} else {
if((state_val_21799 === (12))){
var inst_21769 = (state_21798[(10)]);
var state_21798__$1 = state_21798;
var statearr_21811_21850 = state_21798__$1;
(statearr_21811_21850[(2)] = inst_21769);

(statearr_21811_21850[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (2))){
var _ = (function (){var statearr_21812 = state_21798;
(statearr_21812[(4)] = cljs.core.cons.call(null,(5),(state_21798[(4)])));

return statearr_21812;
})();
var inst_21752 = (end >= start);
var state_21798__$1 = state_21798;
if(cljs.core.truth_(inst_21752)){
var statearr_21813_21851 = state_21798__$1;
(statearr_21813_21851[(1)] = (6));

} else {
var statearr_21814_21852 = state_21798__$1;
(statearr_21814_21852[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (23))){
var inst_21787 = (state_21798[(2)]);
var state_21798__$1 = state_21798;
var statearr_21815_21853 = state_21798__$1;
(statearr_21815_21853[(2)] = inst_21787);

(statearr_21815_21853[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (19))){
var state_21798__$1 = state_21798;
var statearr_21816_21854 = state_21798__$1;
(statearr_21816_21854[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (11))){
var inst_21769 = (state_21798[(10)]);
var inst_21768 = (state_21798[(9)]);
var inst_21768__$1 = (state_21798[(2)]);
var inst_21769__$1 = (inst_21768__$1 == null);
var state_21798__$1 = (function (){var statearr_21819 = state_21798;
(statearr_21819[(10)] = inst_21769__$1);

(statearr_21819[(9)] = inst_21768__$1);

return statearr_21819;
})();
if(cljs.core.truth_(inst_21769__$1)){
var statearr_21820_21855 = state_21798__$1;
(statearr_21820_21855[(1)] = (12));

} else {
var statearr_21821_21856 = state_21798__$1;
(statearr_21821_21856[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (9))){
var inst_21763 = (state_21798[(8)]);
var inst_21766 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_21763);
var state_21798__$1 = state_21798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21798__$1,(11),inst_21766);
} else {
if((state_val_21799 === (5))){
var _ = (function (){var statearr_21822 = state_21798;
(statearr_21822[(4)] = cljs.core.rest.call(null,(state_21798[(4)])));

return statearr_21822;
})();
var state_21798__$1 = state_21798;
var ex21818 = (state_21798__$1[(2)]);
var statearr_21823_21857 = state_21798__$1;
(statearr_21823_21857[(5)] = ex21818);


if((ex21818 instanceof Error)){
var statearr_21824_21858 = state_21798__$1;
(statearr_21824_21858[(1)] = (4));

(statearr_21824_21858[(5)] = null);

} else {
throw ex21818;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (14))){
var inst_21774 = (state_21798[(2)]);
var state_21798__$1 = state_21798;
if(cljs.core.truth_(inst_21774)){
var statearr_21825_21859 = state_21798__$1;
(statearr_21825_21859[(1)] = (15));

} else {
var statearr_21826_21860 = state_21798__$1;
(statearr_21826_21860[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (16))){
var inst_21763 = (state_21798[(8)]);
var inst_21777 = cljs.core._EQ_.call(null,inst_21763,end);
var state_21798__$1 = state_21798;
if(inst_21777){
var statearr_21827_21861 = state_21798__$1;
(statearr_21827_21861[(1)] = (18));

} else {
var statearr_21828_21862 = state_21798__$1;
(statearr_21828_21862[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (10))){
var inst_21793 = (state_21798[(2)]);
var _ = (function (){var statearr_21829 = state_21798;
(statearr_21829[(4)] = cljs.core.rest.call(null,(state_21798[(4)])));

return statearr_21829;
})();
var state_21798__$1 = state_21798;
var statearr_21830_21863 = state_21798__$1;
(statearr_21830_21863[(2)] = inst_21793);

(statearr_21830_21863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (18))){
var inst_21764 = (state_21798[(7)]);
var inst_21768 = (state_21798[(9)]);
var inst_21779 = cljs.core.conj.call(null,inst_21764,inst_21768);
var state_21798__$1 = state_21798;
var statearr_21831_21864 = state_21798__$1;
(statearr_21831_21864[(2)] = inst_21779);

(statearr_21831_21864[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21799 === (8))){
var inst_21759 = (state_21798[(2)]);
var inst_21760 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21761 = start;
var inst_21762 = cljs.core.PersistentVector.EMPTY;
var inst_21763 = inst_21761;
var inst_21764 = inst_21762;
var state_21798__$1 = (function (){var statearr_21832 = state_21798;
(statearr_21832[(11)] = inst_21760);

(statearr_21832[(12)] = inst_21759);

(statearr_21832[(7)] = inst_21764);

(statearr_21832[(8)] = inst_21763);

return statearr_21832;
})();
var statearr_21833_21865 = state_21798__$1;
(statearr_21833_21865[(2)] = null);

(statearr_21833_21865[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2726__auto__ = null;
var fluree$db$storage$core$state_machine__2726__auto____0 = (function (){
var statearr_21834 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21834[(0)] = fluree$db$storage$core$state_machine__2726__auto__);

(statearr_21834[(1)] = (1));

return statearr_21834;
});
var fluree$db$storage$core$state_machine__2726__auto____1 = (function (state_21798){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21835){var ex__2729__auto__ = e21835;
var statearr_21836_21866 = state_21798;
(statearr_21836_21866[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21798[(4)]))){
var statearr_21837_21867 = state_21798;
(statearr_21837_21867[(1)] = cljs.core.first.call(null,(state_21798[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21868 = state_21798;
state_21798 = G__21868;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2726__auto__ = function(state_21798){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2726__auto____1.call(this,state_21798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2726__auto____0;
fluree$db$storage$core$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2726__auto____1;
return fluree$db$storage$core$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21838 = f__2749__auto__.call(null);
(statearr_21838[(6)] = c__2748__auto__);

return statearr_21838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_21884){
var state_val_21885 = (state_21884[(1)]);
if((state_val_21885 === (1))){
var state_21884__$1 = state_21884;
var statearr_21886_21900 = state_21884__$1;
(statearr_21886_21900[(2)] = null);

(statearr_21886_21900[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21885 === (2))){
var _ = (function (){var statearr_21887 = state_21884;
(statearr_21887[(4)] = cljs.core.cons.call(null,(5),(state_21884[(4)])));

return statearr_21887;
})();
var inst_21875 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_21884__$1 = state_21884;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21884__$1,(6),inst_21875);
} else {
if((state_val_21885 === (3))){
var inst_21882 = (state_21884[(2)]);
var state_21884__$1 = state_21884;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21884__$1,inst_21882);
} else {
if((state_val_21885 === (4))){
var inst_21869 = (state_21884[(2)]);
var state_21884__$1 = state_21884;
var statearr_21889_21901 = state_21884__$1;
(statearr_21889_21901[(2)] = inst_21869);

(statearr_21889_21901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21885 === (5))){
var _ = (function (){var statearr_21890 = state_21884;
(statearr_21890[(4)] = cljs.core.rest.call(null,(state_21884[(4)])));

return statearr_21890;
})();
var state_21884__$1 = state_21884;
var ex21888 = (state_21884__$1[(2)]);
var statearr_21891_21902 = state_21884__$1;
(statearr_21891_21902[(5)] = ex21888);


if((ex21888 instanceof Error)){
var statearr_21892_21903 = state_21884__$1;
(statearr_21892_21903[(1)] = (4));

(statearr_21892_21903[(5)] = null);

} else {
throw ex21888;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21885 === (6))){
var inst_21877 = (state_21884[(2)]);
var inst_21878 = fluree.db.util.async.throw_err.call(null,inst_21877);
var inst_21879 = cljs.core.first.call(null,inst_21878);
var _ = (function (){var statearr_21893 = state_21884;
(statearr_21893[(4)] = cljs.core.rest.call(null,(state_21884[(4)])));

return statearr_21893;
})();
var state_21884__$1 = state_21884;
var statearr_21894_21904 = state_21884__$1;
(statearr_21894_21904[(2)] = inst_21879);

(statearr_21894_21904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2726__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2726__auto____0 = (function (){
var statearr_21895 = [null,null,null,null,null,null,null];
(statearr_21895[(0)] = fluree$db$storage$core$block_$_state_machine__2726__auto__);

(statearr_21895[(1)] = (1));

return statearr_21895;
});
var fluree$db$storage$core$block_$_state_machine__2726__auto____1 = (function (state_21884){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_21884);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e21896){var ex__2729__auto__ = e21896;
var statearr_21897_21905 = state_21884;
(statearr_21897_21905[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_21884[(4)]))){
var statearr_21898_21906 = state_21884;
(statearr_21898_21906[(1)] = cljs.core.first.call(null,(state_21884[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21907 = state_21884;
state_21884 = G__21907;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2726__auto__ = function(state_21884){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2726__auto____1.call(this,state_21884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2726__auto____0;
fluree$db$storage$core$block_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2726__auto____1;
return fluree$db$storage$core$block_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_21899 = f__2749__auto__.call(null);
(statearr_21899[(6)] = c__2748__auto__);

return statearr_21899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
