// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4223__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_11474){
var state_val_11475 = (state_11474[(1)]);
if((state_val_11475 === (7))){
var inst_11469 = (state_11474[(2)]);
var _ = (function (){var statearr_11476 = state_11474;
(statearr_11476[(4)] = cljs.core.rest.call(null,(state_11474[(4)])));

return statearr_11476;
})();
var state_11474__$1 = state_11474;
var statearr_11477_11499 = state_11474__$1;
(statearr_11477_11499[(2)] = inst_11469);

(statearr_11477_11499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (1))){
var state_11474__$1 = state_11474;
var statearr_11478_11500 = state_11474__$1;
(statearr_11478_11500[(2)] = null);

(statearr_11478_11500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (4))){
var inst_11431 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
var statearr_11479_11501 = state_11474__$1;
(statearr_11479_11501[(2)] = inst_11431);

(statearr_11479_11501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (6))){
var inst_11449 = (state_11474[(7)]);
var inst_11456 = (state_11474[(8)]);
var inst_11455 = cljs.core.seq.call(null,inst_11449);
var inst_11456__$1 = cljs.core.first.call(null,inst_11455);
var inst_11457 = cljs.core.next.call(null,inst_11455);
var inst_11458 = cljs.core.not.call(null,inst_11456__$1);
var state_11474__$1 = (function (){var statearr_11480 = state_11474;
(statearr_11480[(8)] = inst_11456__$1);

(statearr_11480[(9)] = inst_11457);

return statearr_11480;
})();
if(inst_11458){
var statearr_11481_11502 = state_11474__$1;
(statearr_11481_11502[(1)] = (8));

} else {
var statearr_11482_11503 = state_11474__$1;
(statearr_11482_11503[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (3))){
var inst_11472 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11474__$1,inst_11472);
} else {
if((state_val_11475 === (2))){
var _ = (function (){var statearr_11483 = state_11474;
(statearr_11483[(4)] = cljs.core.cons.call(null,(5),(state_11474[(4)])));

return statearr_11483;
})();
var inst_11444 = chs;
var inst_11445 = cljs.core.seq.call(null,inst_11444);
var inst_11446 = cljs.core.first.call(null,inst_11445);
var inst_11447 = cljs.core.next.call(null,inst_11445);
var inst_11448 = coll;
var inst_11449 = inst_11444;
var inst_11450 = inst_11448;
var state_11474__$1 = (function (){var statearr_11484 = state_11474;
(statearr_11484[(7)] = inst_11449);

(statearr_11484[(10)] = inst_11447);

(statearr_11484[(11)] = inst_11450);

(statearr_11484[(12)] = inst_11446);

return statearr_11484;
})();
var statearr_11485_11504 = state_11474__$1;
(statearr_11485_11504[(2)] = null);

(statearr_11485_11504[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (11))){
var inst_11450 = (state_11474[(11)]);
var inst_11457 = (state_11474[(9)]);
var inst_11462 = (state_11474[(2)]);
var inst_11463 = fluree.db.util.async.throw_err.call(null,inst_11462);
var inst_11464 = cljs.core.conj.call(null,inst_11450,inst_11463);
var inst_11449 = inst_11457;
var inst_11450__$1 = inst_11464;
var state_11474__$1 = (function (){var statearr_11487 = state_11474;
(statearr_11487[(7)] = inst_11449);

(statearr_11487[(11)] = inst_11450__$1);

return statearr_11487;
})();
var statearr_11488_11505 = state_11474__$1;
(statearr_11488_11505[(2)] = null);

(statearr_11488_11505[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (9))){
var inst_11456 = (state_11474[(8)]);
var state_11474__$1 = state_11474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11474__$1,(11),inst_11456);
} else {
if((state_val_11475 === (5))){
var _ = (function (){var statearr_11489 = state_11474;
(statearr_11489[(4)] = cljs.core.rest.call(null,(state_11474[(4)])));

return statearr_11489;
})();
var state_11474__$1 = state_11474;
var ex11486 = (state_11474__$1[(2)]);
var statearr_11490_11506 = state_11474__$1;
(statearr_11490_11506[(5)] = ex11486);


var statearr_11491_11507 = state_11474__$1;
(statearr_11491_11507[(1)] = (4));

(statearr_11491_11507[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (10))){
var inst_11467 = (state_11474[(2)]);
var state_11474__$1 = state_11474;
var statearr_11492_11508 = state_11474__$1;
(statearr_11492_11508[(2)] = inst_11467);

(statearr_11492_11508[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11475 === (8))){
var inst_11450 = (state_11474[(11)]);
var state_11474__$1 = state_11474;
var statearr_11493_11509 = state_11474__$1;
(statearr_11493_11509[(2)] = inst_11450);

(statearr_11493_11509[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_11494 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11494[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto__);

(statearr_11494[(1)] = (1));

return statearr_11494;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto____1 = (function (state_11474){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_11474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e11495){var ex__2729__auto__ = e11495;
var statearr_11496_11510 = state_11474;
(statearr_11496_11510[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_11474[(4)]))){
var statearr_11497_11511 = state_11474;
(statearr_11497_11511[(1)] = cljs.core.first.call(null,(state_11474[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11512 = state_11474;
state_11474 = G__11512;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto__ = function(state_11474){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto____1.call(this,state_11474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_11498 = f__2749__auto__.call(null);
(statearr_11498[(6)] = c__2748__auto__);

return statearr_11498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_11538){
var state_val_11539 = (state_11538[(1)]);
if((state_val_11539 === (7))){
var inst_11533 = (state_11538[(2)]);
var _ = (function (){var statearr_11540 = state_11538;
(statearr_11540[(4)] = cljs.core.rest.call(null,(state_11538[(4)])));

return statearr_11540;
})();
var state_11538__$1 = state_11538;
var statearr_11541_11563 = state_11538__$1;
(statearr_11541_11563[(2)] = inst_11533);

(statearr_11541_11563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (1))){
var state_11538__$1 = state_11538;
var statearr_11542_11564 = state_11538__$1;
(statearr_11542_11564[(2)] = null);

(statearr_11542_11564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (4))){
var inst_11513 = (state_11538[(2)]);
var state_11538__$1 = state_11538;
var statearr_11543_11565 = state_11538__$1;
(statearr_11543_11565[(2)] = inst_11513);

(statearr_11543_11565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (6))){
var state_11538__$1 = state_11538;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11538__$1,(8),chan);
} else {
if((state_val_11539 === (3))){
var inst_11536 = (state_11538[(2)]);
var state_11538__$1 = state_11538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11538__$1,inst_11536);
} else {
if((state_val_11539 === (2))){
var _ = (function (){var statearr_11544 = state_11538;
(statearr_11544[(4)] = cljs.core.cons.call(null,(5),(state_11538[(4)])));

return statearr_11544;
})();
var inst_11519 = coll;
var inst_11520 = inst_11519;
var state_11538__$1 = (function (){var statearr_11545 = state_11538;
(statearr_11545[(7)] = inst_11520);

return statearr_11545;
})();
var statearr_11546_11566 = state_11538__$1;
(statearr_11546_11566[(2)] = null);

(statearr_11546_11566[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (11))){
var inst_11531 = (state_11538[(2)]);
var state_11538__$1 = state_11538;
var statearr_11548_11567 = state_11538__$1;
(statearr_11548_11567[(2)] = inst_11531);

(statearr_11548_11567[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (9))){
var inst_11520 = (state_11538[(7)]);
var state_11538__$1 = state_11538;
var statearr_11549_11568 = state_11538__$1;
(statearr_11549_11568[(2)] = inst_11520);

(statearr_11549_11568[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (5))){
var _ = (function (){var statearr_11550 = state_11538;
(statearr_11550[(4)] = cljs.core.rest.call(null,(state_11538[(4)])));

return statearr_11550;
})();
var state_11538__$1 = state_11538;
var ex11547 = (state_11538__$1[(2)]);
var statearr_11551_11569 = state_11538__$1;
(statearr_11551_11569[(5)] = ex11547);


var statearr_11552_11570 = state_11538__$1;
(statearr_11552_11570[(1)] = (4));

(statearr_11552_11570[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (10))){
var inst_11520 = (state_11538[(7)]);
var inst_11524 = (state_11538[(8)]);
var inst_11528 = cljs.core.conj.call(null,inst_11520,inst_11524);
var inst_11520__$1 = inst_11528;
var state_11538__$1 = (function (){var statearr_11553 = state_11538;
(statearr_11553[(7)] = inst_11520__$1);

return statearr_11553;
})();
var statearr_11554_11571 = state_11538__$1;
(statearr_11554_11571[(2)] = null);

(statearr_11554_11571[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11539 === (8))){
var inst_11524 = (state_11538[(8)]);
var inst_11523 = (state_11538[(2)]);
var inst_11524__$1 = fluree.db.util.async.throw_err.call(null,inst_11523);
var inst_11525 = (inst_11524__$1 == null);
var state_11538__$1 = (function (){var statearr_11555 = state_11538;
(statearr_11555[(8)] = inst_11524__$1);

return statearr_11555;
})();
if(cljs.core.truth_(inst_11525)){
var statearr_11556_11572 = state_11538__$1;
(statearr_11556_11572[(1)] = (9));

} else {
var statearr_11557_11573 = state_11538__$1;
(statearr_11557_11573[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_11558 = [null,null,null,null,null,null,null,null,null];
(statearr_11558[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2726__auto__);

(statearr_11558[(1)] = (1));

return statearr_11558;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2726__auto____1 = (function (state_11538){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_11538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e11559){var ex__2729__auto__ = e11559;
var statearr_11560_11574 = state_11538;
(statearr_11560_11574[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_11538[(4)]))){
var statearr_11561_11575 = state_11538;
(statearr_11561_11575[(1)] = cljs.core.first.call(null,(state_11538[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11576 = state_11538;
state_11538 = G__11576;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2726__auto__ = function(state_11538){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2726__auto____1.call(this,state_11538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2726__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2726__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_11562 = f__2749__auto__.call(null);
(statearr_11562[(6)] = c__2748__auto__);

return statearr_11562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
