// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__9890 = s;
var map__9890__$1 = cljs.core.__destructure_map(map__9890);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9890__$1,cljs.core.cst$kw$info);
var d = (0);
var G__9892 = info;
var map__9893 = G__9892;
var map__9893__$1 = cljs.core.__destructure_map(map__9893);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9893__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__9892__$1 = G__9892;
while(true){
var d__$2 = d__$1;
var map__9895 = G__9892__$1;
var map__9895__$1 = cljs.core.__destructure_map(map__9895);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9895__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__9896 = (d__$2 + (1));
var G__9897 = shadow__$1;
d__$1 = G__9896;
G__9892__$1 = G__9897;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__9898){
var map__9899 = p__9898;
var map__9899__$1 = cljs.core.__destructure_map(map__9899);
var name_var = map__9899__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9899__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9899__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__9900 = info;
var map__9900__$1 = cljs.core.__destructure_map(map__9900);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9900__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9900__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__9901 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__9901) : cljs.compiler.munge.call(null,G__9901));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__9903 = arguments.length;
switch (G__9903) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__9904 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11639,11639,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__9904.cljs$core$IFn$_invoke$arity$1 ? fexpr__9904.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__9904.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__9906 = cp;
switch (G__9906) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__9908_9912 = cljs.core.seq(s);
var chunk__9909_9913 = null;
var count__9910_9914 = (0);
var i__9911_9915 = (0);
while(true){
if((i__9911_9915 < count__9910_9914)){
var c_9916 = chunk__9909_9913.cljs$core$IIndexed$_nth$arity$2(null,i__9911_9915);
sb.append(cljs.compiler.escape_char(c_9916));


var G__9917 = seq__9908_9912;
var G__9918 = chunk__9909_9913;
var G__9919 = count__9910_9914;
var G__9920 = (i__9911_9915 + (1));
seq__9908_9912 = G__9917;
chunk__9909_9913 = G__9918;
count__9910_9914 = G__9919;
i__9911_9915 = G__9920;
continue;
} else {
var temp__5753__auto___9921 = cljs.core.seq(seq__9908_9912);
if(temp__5753__auto___9921){
var seq__9908_9922__$1 = temp__5753__auto___9921;
if(cljs.core.chunked_seq_QMARK_(seq__9908_9922__$1)){
var c__4649__auto___9923 = cljs.core.chunk_first(seq__9908_9922__$1);
var G__9924 = cljs.core.chunk_rest(seq__9908_9922__$1);
var G__9925 = c__4649__auto___9923;
var G__9926 = cljs.core.count(c__4649__auto___9923);
var G__9927 = (0);
seq__9908_9912 = G__9924;
chunk__9909_9913 = G__9925;
count__9910_9914 = G__9926;
i__9911_9915 = G__9927;
continue;
} else {
var c_9928 = cljs.core.first(seq__9908_9922__$1);
sb.append(cljs.compiler.escape_char(c_9928));


var G__9929 = cljs.core.next(seq__9908_9922__$1);
var G__9930 = null;
var G__9931 = (0);
var G__9932 = (0);
seq__9908_9912 = G__9929;
chunk__9909_9913 = G__9930;
count__9910_9914 = G__9931;
i__9911_9915 = G__9932;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__9933 = cljs.core.get_global_hierarchy;
return (fexpr__9933.cljs$core$IFn$_invoke$arity$0 ? fexpr__9933.cljs$core$IFn$_invoke$arity$0() : fexpr__9933.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__9934_9939 = ast;
var map__9934_9940__$1 = cljs.core.__destructure_map(map__9934_9939);
var env_9941 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9934_9940__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_9941))){
var map__9935_9942 = env_9941;
var map__9935_9943__$1 = cljs.core.__destructure_map(map__9935_9942);
var line_9944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9935_9943__$1,cljs.core.cst$kw$line);
var column_9945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9935_9943__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__9936 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__9938 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__9937 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__9937.cljs$core$IFn$_invoke$arity$1 ? fexpr__9937.cljs$core$IFn$_invoke$arity$1(G__9938) : fexpr__9937.call(null,G__9938));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__9936,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__9936;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_9944 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_9945)?(column_9945 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__9954 = arguments.length;
switch (G__9954) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___9961 = arguments.length;
var i__4830__auto___9962 = (0);
while(true){
if((i__4830__auto___9962 < len__4829__auto___9961)){
args_arr__4850__auto__.push((arguments[i__4830__auto___9962]));

var G__9963 = (i__4830__auto___9962 + (1));
i__4830__auto___9962 = G__9963;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_9964 = (function (){var G__9955 = a;
if((!(typeof a === 'string'))){
return G__9955.toString();
} else {
return G__9955;
}
})();
var temp__5757__auto___9965 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___9965 == null)){
} else {
var sm_data_9966 = temp__5757__auto___9965;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_9966,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__9946_SHARP_){
return (p1__9946_SHARP_ + s_9964.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_9964], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9956 = cljs.core.seq(xs);
var chunk__9957 = null;
var count__9958 = (0);
var i__9959 = (0);
while(true){
if((i__9959 < count__9958)){
var x = chunk__9957.cljs$core$IIndexed$_nth$arity$2(null,i__9959);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9967 = seq__9956;
var G__9968 = chunk__9957;
var G__9969 = count__9958;
var G__9970 = (i__9959 + (1));
seq__9956 = G__9967;
chunk__9957 = G__9968;
count__9958 = G__9969;
i__9959 = G__9970;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__9956);
if(temp__5753__auto__){
var seq__9956__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9956__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__9956__$1);
var G__9971 = cljs.core.chunk_rest(seq__9956__$1);
var G__9972 = c__4649__auto__;
var G__9973 = cljs.core.count(c__4649__auto__);
var G__9974 = (0);
seq__9956 = G__9971;
chunk__9957 = G__9972;
count__9958 = G__9973;
i__9959 = G__9974;
continue;
} else {
var x = cljs.core.first(seq__9956__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__9975 = cljs.core.next(seq__9956__$1);
var G__9976 = null;
var G__9977 = (0);
var G__9978 = (0);
seq__9956 = G__9975;
chunk__9957 = G__9976;
count__9958 = G__9977;
i__9959 = G__9978;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq9948){
var G__9949 = cljs.core.first(seq9948);
var seq9948__$1 = cljs.core.next(seq9948);
var G__9950 = cljs.core.first(seq9948__$1);
var seq9948__$2 = cljs.core.next(seq9948__$1);
var G__9951 = cljs.core.first(seq9948__$2);
var seq9948__$3 = cljs.core.next(seq9948__$2);
var G__9952 = cljs.core.first(seq9948__$3);
var seq9948__$4 = cljs.core.next(seq9948__$3);
var G__9953 = cljs.core.first(seq9948__$4);
var seq9948__$5 = cljs.core.next(seq9948__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9949,G__9950,G__9951,G__9952,G__9953,seq9948__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__9979){
var map__9980 = p__9979;
var map__9980__$1 = cljs.core.__destructure_map(map__9980);
var m = map__9980__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__9980__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__9988 = arguments.length;
switch (G__9988) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___9994 = arguments.length;
var i__4830__auto___9995 = (0);
while(true){
if((i__4830__auto___9995 < len__4829__auto___9994)){
args_arr__4850__auto__.push((arguments[i__4830__auto___9995]));

var G__9996 = (i__4830__auto___9995 + (1));
i__4830__auto___9995 = G__9996;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__9989_9997 = cljs.core.seq(xs);
var chunk__9990_9998 = null;
var count__9991_9999 = (0);
var i__9992_10000 = (0);
while(true){
if((i__9992_10000 < count__9991_9999)){
var x_10001 = chunk__9990_9998.cljs$core$IIndexed$_nth$arity$2(null,i__9992_10000);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_10001);


var G__10002 = seq__9989_9997;
var G__10003 = chunk__9990_9998;
var G__10004 = count__9991_9999;
var G__10005 = (i__9992_10000 + (1));
seq__9989_9997 = G__10002;
chunk__9990_9998 = G__10003;
count__9991_9999 = G__10004;
i__9992_10000 = G__10005;
continue;
} else {
var temp__5753__auto___10006 = cljs.core.seq(seq__9989_9997);
if(temp__5753__auto___10006){
var seq__9989_10007__$1 = temp__5753__auto___10006;
if(cljs.core.chunked_seq_QMARK_(seq__9989_10007__$1)){
var c__4649__auto___10008 = cljs.core.chunk_first(seq__9989_10007__$1);
var G__10009 = cljs.core.chunk_rest(seq__9989_10007__$1);
var G__10010 = c__4649__auto___10008;
var G__10011 = cljs.core.count(c__4649__auto___10008);
var G__10012 = (0);
seq__9989_9997 = G__10009;
chunk__9990_9998 = G__10010;
count__9991_9999 = G__10011;
i__9992_10000 = G__10012;
continue;
} else {
var x_10013 = cljs.core.first(seq__9989_10007__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_10013);


var G__10014 = cljs.core.next(seq__9989_10007__$1);
var G__10015 = null;
var G__10016 = (0);
var G__10017 = (0);
seq__9989_9997 = G__10014;
chunk__9990_9998 = G__10015;
count__9991_9999 = G__10016;
i__9992_10000 = G__10017;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq9982){
var G__9983 = cljs.core.first(seq9982);
var seq9982__$1 = cljs.core.next(seq9982);
var G__9984 = cljs.core.first(seq9982__$1);
var seq9982__$2 = cljs.core.next(seq9982__$1);
var G__9985 = cljs.core.first(seq9982__$2);
var seq9982__$3 = cljs.core.next(seq9982__$2);
var G__9986 = cljs.core.first(seq9982__$3);
var seq9982__$4 = cljs.core.next(seq9982__$3);
var G__9987 = cljs.core.first(seq9982__$4);
var seq9982__$5 = cljs.core.next(seq9982__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9983,G__9984,G__9985,G__9986,G__9987,seq9982__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__10018_10022 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__10019_10023 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__10020_10024 = true;
var _STAR_print_fn_STAR__temp_val__10021_10025 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__10020_10024);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__10021_10025);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__10019_10023);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__10018_10022);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__10026 = cljs.core.get_global_hierarchy;
return (fexpr__10026.cljs$core$IFn$_invoke$arity$0 ? fexpr__10026.cljs$core$IFn$_invoke$arity$0() : fexpr__10026.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__10027 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10027,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10027,(1),null);
var G__10030 = ns;
var G__10031 = name;
var G__10032 = (function (){
var G__10033 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__10033) : cljs.compiler.emit_constant.call(null,G__10033));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__10030,G__10031,G__10032) : cljs.compiler.emit_record_value.call(null,G__10030,G__10031,G__10032));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__10034 = cljs.core.keys(x);
var G__10035 = cljs.core.vals(x);
var G__10036 = cljs.compiler.emit_constants_comma_sep;
var G__10037 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__10034,G__10035,G__10036,G__10037) : cljs.compiler.emit_map.call(null,G__10034,G__10035,G__10036,G__10037));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__10038 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__10039 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__10038,G__10039) : cljs.compiler.emit_with_meta.call(null,G__10038,G__10039));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__10040 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10040,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10040,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10040,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__10043 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__10043) : x.call(null,G__10043));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__10044 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__10044) : x.call(null,G__10044));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__10046 = items;
var G__10047 = (function (p1__10045_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__10045_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__10046,G__10047) : cljs.compiler.emit_js_object.call(null,G__10046,G__10047));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__10049){
var map__10050 = p__10049;
var map__10050__$1 = cljs.core.__destructure_map(map__10050);
var ast = map__10050__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10050__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10050__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10050__$1,cljs.core.cst$kw$form);
var temp__5751__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__10051 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__10051__$1 = cljs.core.__destructure_map(map__10051);
var cenv = map__10051__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10051__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4223__auto__ = js_module_name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__10052 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4221__auto__ = (function (){var G__10053 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__10053) : cljs.compiler.es5_GT__EQ_.call(null,G__10053));
})();
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4221__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__10052,cljs.analyzer.es5_allowed);
} else {
return G__10052;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4223__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__10054 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__10054,reserved);
} else {
return G__10054;
}
})();
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__10055_10056 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__10055_10057__$1 = (((G__10055_10056 instanceof cljs.core.Keyword))?G__10055_10056.fqn:null);
switch (G__10055_10057__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4221__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__10059){
var map__10060 = p__10059;
var map__10060__$1 = cljs.core.__destructure_map(map__10060);
var arg = map__10060__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10060__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10060__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10060__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10060__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__10061 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__10061__$1 = cljs.core.__destructure_map(map__10061);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10061__$1,cljs.core.cst$kw$name);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__10062){
var map__10063 = p__10062;
var map__10063__$1 = cljs.core.__destructure_map(map__10063);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10063__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10063__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10063__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__10064_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__10064_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__10065 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__10065) : comma_sep.call(null,G__10065));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__10066 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__10066) : comma_sep.call(null,G__10066));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__10067){
var map__10068 = p__10067;
var map__10068__$1 = cljs.core.__destructure_map(map__10068);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10068__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10068__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10068__$1,cljs.core.cst$kw$vals);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__10069){
var map__10070 = p__10069;
var map__10070__$1 = cljs.core.__destructure_map(map__10070);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10070__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10070__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__10071_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__10071_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__10072 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__10072) : comma_sep.call(null,G__10072));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__10073){
var map__10074 = p__10073;
var map__10074__$1 = cljs.core.__destructure_map(map__10074);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10074__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10074__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___10097 = cljs.core.seq(items);
if(temp__5753__auto___10097){
var items_10098__$1 = temp__5753__auto___10097;
var vec__10075_10099 = items_10098__$1;
var seq__10076_10100 = cljs.core.seq(vec__10075_10099);
var first__10077_10101 = cljs.core.first(seq__10076_10100);
var seq__10076_10102__$1 = cljs.core.next(seq__10076_10100);
var vec__10078_10103 = first__10077_10101;
var k_10104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10078_10103,(0),null);
var v_10105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10078_10103,(1),null);
var r_10106 = seq__10076_10102__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_10104),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10105) : emit_js_object_val.call(null,v_10105)));

var seq__10081_10107 = cljs.core.seq(r_10106);
var chunk__10082_10108 = null;
var count__10083_10109 = (0);
var i__10084_10110 = (0);
while(true){
if((i__10084_10110 < count__10083_10109)){
var vec__10091_10111 = chunk__10082_10108.cljs$core$IIndexed$_nth$arity$2(null,i__10084_10110);
var k_10112__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10091_10111,(0),null);
var v_10113__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10091_10111,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_10112__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10113__$1) : emit_js_object_val.call(null,v_10113__$1)));


var G__10114 = seq__10081_10107;
var G__10115 = chunk__10082_10108;
var G__10116 = count__10083_10109;
var G__10117 = (i__10084_10110 + (1));
seq__10081_10107 = G__10114;
chunk__10082_10108 = G__10115;
count__10083_10109 = G__10116;
i__10084_10110 = G__10117;
continue;
} else {
var temp__5753__auto___10118__$1 = cljs.core.seq(seq__10081_10107);
if(temp__5753__auto___10118__$1){
var seq__10081_10119__$1 = temp__5753__auto___10118__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10081_10119__$1)){
var c__4649__auto___10120 = cljs.core.chunk_first(seq__10081_10119__$1);
var G__10121 = cljs.core.chunk_rest(seq__10081_10119__$1);
var G__10122 = c__4649__auto___10120;
var G__10123 = cljs.core.count(c__4649__auto___10120);
var G__10124 = (0);
seq__10081_10107 = G__10121;
chunk__10082_10108 = G__10122;
count__10083_10109 = G__10123;
i__10084_10110 = G__10124;
continue;
} else {
var vec__10094_10125 = cljs.core.first(seq__10081_10119__$1);
var k_10126__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10094_10125,(0),null);
var v_10127__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10094_10125,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_10126__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_10127__$1) : emit_js_object_val.call(null,v_10127__$1)));


var G__10128 = cljs.core.next(seq__10081_10119__$1);
var G__10129 = null;
var G__10130 = (0);
var G__10131 = (0);
seq__10081_10107 = G__10128;
chunk__10082_10108 = G__10129;
count__10083_10109 = G__10130;
i__10084_10110 = G__10131;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__10132){
var map__10133 = p__10132;
var map__10133__$1 = cljs.core.__destructure_map(map__10133);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10133__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10133__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10133__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__10134){
var map__10135 = p__10134;
var map__10135__$1 = cljs.core.__destructure_map(map__10135);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10135__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10135__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__10136){
var map__10137 = p__10136;
var map__10137__$1 = cljs.core.__destructure_map(map__10137);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10137__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__10138){
var map__10139 = p__10138;
var map__10139__$1 = cljs.core.__destructure_map(map__10139);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10139__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10139__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__10140 = cljs.analyzer.unwrap_quote(expr);
var map__10140__$1 = cljs.core.__destructure_map(map__10140);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10140__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10140__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10140__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4221__auto__){
var and__4221__auto____$1 = form;
if(cljs.core.truth_(and__4221__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__10141 = cljs.analyzer.unwrap_quote(expr);
var map__10141__$1 = cljs.core.__destructure_map(map__10141);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10141__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10141__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10141__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4223__auto__ = (function (){var fexpr__10142 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__10142.cljs$core$IFn$_invoke$arity$1 ? fexpr__10142.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__10142.call(null,tag));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__10143){
var map__10144 = p__10143;
var map__10144__$1 = cljs.core.__destructure_map(map__10144);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10144__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10144__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10144__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10144__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10144__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4223__auto__ = unchecked;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__10145){
var map__10146 = p__10145;
var map__10146__$1 = cljs.core.__destructure_map(map__10146);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10146__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10146__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10146__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10146__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__10147_10175 = cljs.core.seq(nodes);
var chunk__10148_10176 = null;
var count__10149_10177 = (0);
var i__10150_10178 = (0);
while(true){
if((i__10150_10178 < count__10149_10177)){
var map__10163_10179 = chunk__10148_10176.cljs$core$IIndexed$_nth$arity$2(null,i__10150_10178);
var map__10163_10180__$1 = cljs.core.__destructure_map(map__10163_10179);
var ts_10181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10163_10180__$1,cljs.core.cst$kw$tests);
var map__10164_10182 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10163_10180__$1,cljs.core.cst$kw$then);
var map__10164_10183__$1 = cljs.core.__destructure_map(map__10164_10182);
var then_10184 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10164_10183__$1,cljs.core.cst$kw$then);
var seq__10165_10185 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_10181));
var chunk__10166_10186 = null;
var count__10167_10187 = (0);
var i__10168_10188 = (0);
while(true){
if((i__10168_10188 < count__10167_10187)){
var test_10189 = chunk__10166_10186.cljs$core$IIndexed$_nth$arity$2(null,i__10168_10188);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10189,":");


var G__10190 = seq__10165_10185;
var G__10191 = chunk__10166_10186;
var G__10192 = count__10167_10187;
var G__10193 = (i__10168_10188 + (1));
seq__10165_10185 = G__10190;
chunk__10166_10186 = G__10191;
count__10167_10187 = G__10192;
i__10168_10188 = G__10193;
continue;
} else {
var temp__5753__auto___10194 = cljs.core.seq(seq__10165_10185);
if(temp__5753__auto___10194){
var seq__10165_10195__$1 = temp__5753__auto___10194;
if(cljs.core.chunked_seq_QMARK_(seq__10165_10195__$1)){
var c__4649__auto___10196 = cljs.core.chunk_first(seq__10165_10195__$1);
var G__10197 = cljs.core.chunk_rest(seq__10165_10195__$1);
var G__10198 = c__4649__auto___10196;
var G__10199 = cljs.core.count(c__4649__auto___10196);
var G__10200 = (0);
seq__10165_10185 = G__10197;
chunk__10166_10186 = G__10198;
count__10167_10187 = G__10199;
i__10168_10188 = G__10200;
continue;
} else {
var test_10201 = cljs.core.first(seq__10165_10195__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10201,":");


var G__10202 = cljs.core.next(seq__10165_10195__$1);
var G__10203 = null;
var G__10204 = (0);
var G__10205 = (0);
seq__10165_10185 = G__10202;
chunk__10166_10186 = G__10203;
count__10167_10187 = G__10204;
i__10168_10188 = G__10205;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_10184);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_10184);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__10206 = seq__10147_10175;
var G__10207 = chunk__10148_10176;
var G__10208 = count__10149_10177;
var G__10209 = (i__10150_10178 + (1));
seq__10147_10175 = G__10206;
chunk__10148_10176 = G__10207;
count__10149_10177 = G__10208;
i__10150_10178 = G__10209;
continue;
} else {
var temp__5753__auto___10210 = cljs.core.seq(seq__10147_10175);
if(temp__5753__auto___10210){
var seq__10147_10211__$1 = temp__5753__auto___10210;
if(cljs.core.chunked_seq_QMARK_(seq__10147_10211__$1)){
var c__4649__auto___10212 = cljs.core.chunk_first(seq__10147_10211__$1);
var G__10213 = cljs.core.chunk_rest(seq__10147_10211__$1);
var G__10214 = c__4649__auto___10212;
var G__10215 = cljs.core.count(c__4649__auto___10212);
var G__10216 = (0);
seq__10147_10175 = G__10213;
chunk__10148_10176 = G__10214;
count__10149_10177 = G__10215;
i__10150_10178 = G__10216;
continue;
} else {
var map__10169_10217 = cljs.core.first(seq__10147_10211__$1);
var map__10169_10218__$1 = cljs.core.__destructure_map(map__10169_10217);
var ts_10219 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10169_10218__$1,cljs.core.cst$kw$tests);
var map__10170_10220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10169_10218__$1,cljs.core.cst$kw$then);
var map__10170_10221__$1 = cljs.core.__destructure_map(map__10170_10220);
var then_10222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10170_10221__$1,cljs.core.cst$kw$then);
var seq__10171_10223 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_10219));
var chunk__10172_10224 = null;
var count__10173_10225 = (0);
var i__10174_10226 = (0);
while(true){
if((i__10174_10226 < count__10173_10225)){
var test_10227 = chunk__10172_10224.cljs$core$IIndexed$_nth$arity$2(null,i__10174_10226);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10227,":");


var G__10228 = seq__10171_10223;
var G__10229 = chunk__10172_10224;
var G__10230 = count__10173_10225;
var G__10231 = (i__10174_10226 + (1));
seq__10171_10223 = G__10228;
chunk__10172_10224 = G__10229;
count__10173_10225 = G__10230;
i__10174_10226 = G__10231;
continue;
} else {
var temp__5753__auto___10232__$1 = cljs.core.seq(seq__10171_10223);
if(temp__5753__auto___10232__$1){
var seq__10171_10233__$1 = temp__5753__auto___10232__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10171_10233__$1)){
var c__4649__auto___10234 = cljs.core.chunk_first(seq__10171_10233__$1);
var G__10235 = cljs.core.chunk_rest(seq__10171_10233__$1);
var G__10236 = c__4649__auto___10234;
var G__10237 = cljs.core.count(c__4649__auto___10234);
var G__10238 = (0);
seq__10171_10223 = G__10235;
chunk__10172_10224 = G__10236;
count__10173_10225 = G__10237;
i__10174_10226 = G__10238;
continue;
} else {
var test_10239 = cljs.core.first(seq__10171_10233__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_10239,":");


var G__10240 = cljs.core.next(seq__10171_10233__$1);
var G__10241 = null;
var G__10242 = (0);
var G__10243 = (0);
seq__10171_10223 = G__10240;
chunk__10172_10224 = G__10241;
count__10173_10225 = G__10242;
i__10174_10226 = G__10243;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_10222);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_10222);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__10244 = cljs.core.next(seq__10147_10211__$1);
var G__10245 = null;
var G__10246 = (0);
var G__10247 = (0);
seq__10147_10175 = G__10244;
chunk__10148_10176 = G__10245;
count__10149_10177 = G__10246;
i__10150_10178 = G__10247;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__10248){
var map__10249 = p__10248;
var map__10249__$1 = cljs.core.__destructure_map(map__10249);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10249__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10249__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__10253 = env;
var G__10254 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__10253,G__10254) : cljs.compiler.resolve_type.call(null,G__10253,G__10254));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__10255 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10255,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10255,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__10250_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__10250_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__10250_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__10258 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__10258,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__10258;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__10261 = env;
var G__10262 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__10261,G__10262) : cljs.compiler.resolve_type.call(null,G__10261,G__10262));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10263_SHARP_){
return cljs.compiler.resolve_type(env,p1__10263_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__10264 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__10265 = cljs.core.seq(vec__10264);
var first__10266 = cljs.core.first(seq__10265);
var seq__10265__$1 = cljs.core.next(seq__10265);
var p = first__10266;
var first__10266__$1 = cljs.core.first(seq__10265__$1);
var seq__10265__$2 = cljs.core.next(seq__10265__$1);
var ts = first__10266__$1;
var first__10266__$2 = cljs.core.first(seq__10265__$2);
var seq__10265__$3 = cljs.core.next(seq__10265__$2);
var n = first__10266__$2;
var xs = seq__10265__$3;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__10267 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__10268 = cljs.core.seq(vec__10267);
var first__10269 = cljs.core.first(seq__10268);
var seq__10268__$1 = cljs.core.next(seq__10268);
var p = first__10269;
var first__10269__$1 = cljs.core.first(seq__10268__$1);
var seq__10268__$2 = cljs.core.next(seq__10268__$1);
var ts = first__10269__$1;
var xs = seq__10268__$2;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__10271 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__10270 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__10270.cljs$core$IFn$_invoke$arity$1 ? fexpr__10270.cljs$core$IFn$_invoke$arity$1(G__10271) : fexpr__10270.call(null,G__10271));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__10274 = arguments.length;
switch (G__10274) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__10282 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10272_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__10272_SHARP_);
} else {
return p1__10272_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__10283 = cljs.core.seq(vec__10282);
var first__10284 = cljs.core.first(seq__10283);
var seq__10283__$1 = cljs.core.next(seq__10283);
var x = first__10284;
var ys = seq__10283__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__10285 = cljs.core.seq(ys);
var chunk__10286 = null;
var count__10287 = (0);
var i__10288 = (0);
while(true){
if((i__10288 < count__10287)){
var next_line = chunk__10286.cljs$core$IIndexed$_nth$arity$2(null,i__10288);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10294 = seq__10285;
var G__10295 = chunk__10286;
var G__10296 = count__10287;
var G__10297 = (i__10288 + (1));
seq__10285 = G__10294;
chunk__10286 = G__10295;
count__10287 = G__10296;
i__10288 = G__10297;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10285);
if(temp__5753__auto__){
var seq__10285__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10285__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__10285__$1);
var G__10298 = cljs.core.chunk_rest(seq__10285__$1);
var G__10299 = c__4649__auto__;
var G__10300 = cljs.core.count(c__4649__auto__);
var G__10301 = (0);
seq__10285 = G__10298;
chunk__10286 = G__10299;
count__10287 = G__10300;
i__10288 = G__10301;
continue;
} else {
var next_line = cljs.core.first(seq__10285__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__10302 = cljs.core.next(seq__10285__$1);
var G__10303 = null;
var G__10304 = (0);
var G__10305 = (0);
seq__10285 = G__10302;
chunk__10286 = G__10303;
count__10287 = G__10304;
i__10288 = G__10305;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__10289_10306 = cljs.core.seq(docs__$2);
var chunk__10290_10307 = null;
var count__10291_10308 = (0);
var i__10292_10309 = (0);
while(true){
if((i__10292_10309 < count__10291_10308)){
var e_10310 = chunk__10290_10307.cljs$core$IIndexed$_nth$arity$2(null,i__10292_10309);
if(cljs.core.truth_(e_10310)){
print_comment_lines(e_10310);
} else {
}


var G__10311 = seq__10289_10306;
var G__10312 = chunk__10290_10307;
var G__10313 = count__10291_10308;
var G__10314 = (i__10292_10309 + (1));
seq__10289_10306 = G__10311;
chunk__10290_10307 = G__10312;
count__10291_10308 = G__10313;
i__10292_10309 = G__10314;
continue;
} else {
var temp__5753__auto___10315 = cljs.core.seq(seq__10289_10306);
if(temp__5753__auto___10315){
var seq__10289_10316__$1 = temp__5753__auto___10315;
if(cljs.core.chunked_seq_QMARK_(seq__10289_10316__$1)){
var c__4649__auto___10317 = cljs.core.chunk_first(seq__10289_10316__$1);
var G__10318 = cljs.core.chunk_rest(seq__10289_10316__$1);
var G__10319 = c__4649__auto___10317;
var G__10320 = cljs.core.count(c__4649__auto___10317);
var G__10321 = (0);
seq__10289_10306 = G__10318;
chunk__10290_10307 = G__10319;
count__10291_10308 = G__10320;
i__10292_10309 = G__10321;
continue;
} else {
var e_10322 = cljs.core.first(seq__10289_10316__$1);
if(cljs.core.truth_(e_10322)){
print_comment_lines(e_10322);
} else {
}


var G__10323 = cljs.core.next(seq__10289_10316__$1);
var G__10324 = null;
var G__10325 = (0);
var G__10326 = (0);
seq__10289_10306 = G__10323;
chunk__10290_10307 = G__10324;
count__10291_10308 = G__10325;
i__10292_10309 = G__10326;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4221__auto__ = cljs.core.some((function (p1__10328_SHARP_){
return goog.string.startsWith(p1__10328_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = opts;
if(cljs.core.truth_(and__4221__auto____$1)){
var and__4221__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4221__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4221__auto____$2;
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__10329){
var map__10330 = p__10329;
var map__10330__$1 = cljs.core.__destructure_map(map__10330);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10330__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4223__auto__ = init;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
return test;
} else {
return and__4221__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__10331){
var map__10332 = p__10331;
var map__10332__$1 = cljs.core.__destructure_map(map__10332);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10332__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10332__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10332__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__10333_10357 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__10334_10358 = null;
var count__10335_10359 = (0);
var i__10336_10360 = (0);
while(true){
if((i__10336_10360 < count__10335_10359)){
var vec__10343_10361 = chunk__10334_10358.cljs$core$IIndexed$_nth$arity$2(null,i__10336_10360);
var i_10362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10343_10361,(0),null);
var param_10363 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10343_10361,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10363);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10364 = seq__10333_10357;
var G__10365 = chunk__10334_10358;
var G__10366 = count__10335_10359;
var G__10367 = (i__10336_10360 + (1));
seq__10333_10357 = G__10364;
chunk__10334_10358 = G__10365;
count__10335_10359 = G__10366;
i__10336_10360 = G__10367;
continue;
} else {
var temp__5753__auto___10368 = cljs.core.seq(seq__10333_10357);
if(temp__5753__auto___10368){
var seq__10333_10369__$1 = temp__5753__auto___10368;
if(cljs.core.chunked_seq_QMARK_(seq__10333_10369__$1)){
var c__4649__auto___10370 = cljs.core.chunk_first(seq__10333_10369__$1);
var G__10371 = cljs.core.chunk_rest(seq__10333_10369__$1);
var G__10372 = c__4649__auto___10370;
var G__10373 = cljs.core.count(c__4649__auto___10370);
var G__10374 = (0);
seq__10333_10357 = G__10371;
chunk__10334_10358 = G__10372;
count__10335_10359 = G__10373;
i__10336_10360 = G__10374;
continue;
} else {
var vec__10346_10375 = cljs.core.first(seq__10333_10369__$1);
var i_10376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10346_10375,(0),null);
var param_10377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10346_10375,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_10377);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__10378 = cljs.core.next(seq__10333_10369__$1);
var G__10379 = null;
var G__10380 = (0);
var G__10381 = (0);
seq__10333_10357 = G__10378;
chunk__10334_10358 = G__10379;
count__10335_10359 = G__10380;
i__10336_10360 = G__10381;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10349_10382 = cljs.core.seq(params);
var chunk__10350_10383 = null;
var count__10351_10384 = (0);
var i__10352_10385 = (0);
while(true){
if((i__10352_10385 < count__10351_10384)){
var param_10386 = chunk__10350_10383.cljs$core$IIndexed$_nth$arity$2(null,i__10352_10385);
cljs.compiler.emit(param_10386);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10386,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10387 = seq__10349_10382;
var G__10388 = chunk__10350_10383;
var G__10389 = count__10351_10384;
var G__10390 = (i__10352_10385 + (1));
seq__10349_10382 = G__10387;
chunk__10350_10383 = G__10388;
count__10351_10384 = G__10389;
i__10352_10385 = G__10390;
continue;
} else {
var temp__5753__auto___10391 = cljs.core.seq(seq__10349_10382);
if(temp__5753__auto___10391){
var seq__10349_10392__$1 = temp__5753__auto___10391;
if(cljs.core.chunked_seq_QMARK_(seq__10349_10392__$1)){
var c__4649__auto___10393 = cljs.core.chunk_first(seq__10349_10392__$1);
var G__10394 = cljs.core.chunk_rest(seq__10349_10392__$1);
var G__10395 = c__4649__auto___10393;
var G__10396 = cljs.core.count(c__4649__auto___10393);
var G__10397 = (0);
seq__10349_10382 = G__10394;
chunk__10350_10383 = G__10395;
count__10351_10384 = G__10396;
i__10352_10385 = G__10397;
continue;
} else {
var param_10398 = cljs.core.first(seq__10349_10392__$1);
cljs.compiler.emit(param_10398);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10398,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10399 = cljs.core.next(seq__10349_10392__$1);
var G__10400 = null;
var G__10401 = (0);
var G__10402 = (0);
seq__10349_10382 = G__10399;
chunk__10350_10383 = G__10400;
count__10351_10384 = G__10401;
i__10352_10385 = G__10402;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__10353_10403 = cljs.core.seq(params);
var chunk__10354_10404 = null;
var count__10355_10405 = (0);
var i__10356_10406 = (0);
while(true){
if((i__10356_10406 < count__10355_10405)){
var param_10407 = chunk__10354_10404.cljs$core$IIndexed$_nth$arity$2(null,i__10356_10406);
cljs.compiler.emit(param_10407);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10407,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10408 = seq__10353_10403;
var G__10409 = chunk__10354_10404;
var G__10410 = count__10355_10405;
var G__10411 = (i__10356_10406 + (1));
seq__10353_10403 = G__10408;
chunk__10354_10404 = G__10409;
count__10355_10405 = G__10410;
i__10356_10406 = G__10411;
continue;
} else {
var temp__5753__auto___10412 = cljs.core.seq(seq__10353_10403);
if(temp__5753__auto___10412){
var seq__10353_10413__$1 = temp__5753__auto___10412;
if(cljs.core.chunked_seq_QMARK_(seq__10353_10413__$1)){
var c__4649__auto___10414 = cljs.core.chunk_first(seq__10353_10413__$1);
var G__10415 = cljs.core.chunk_rest(seq__10353_10413__$1);
var G__10416 = c__4649__auto___10414;
var G__10417 = cljs.core.count(c__4649__auto___10414);
var G__10418 = (0);
seq__10353_10403 = G__10415;
chunk__10354_10404 = G__10416;
count__10355_10405 = G__10417;
i__10356_10406 = G__10418;
continue;
} else {
var param_10419 = cljs.core.first(seq__10353_10413__$1);
cljs.compiler.emit(param_10419);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10419,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10420 = cljs.core.next(seq__10353_10413__$1);
var G__10421 = null;
var G__10422 = (0);
var G__10423 = (0);
seq__10353_10403 = G__10420;
chunk__10354_10404 = G__10421;
count__10355_10405 = G__10422;
i__10356_10406 = G__10423;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__10424 = cljs.core.seq(params);
var chunk__10425 = null;
var count__10426 = (0);
var i__10427 = (0);
while(true){
if((i__10427 < count__10426)){
var param = chunk__10425.cljs$core$IIndexed$_nth$arity$2(null,i__10427);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10428 = seq__10424;
var G__10429 = chunk__10425;
var G__10430 = count__10426;
var G__10431 = (i__10427 + (1));
seq__10424 = G__10428;
chunk__10425 = G__10429;
count__10426 = G__10430;
i__10427 = G__10431;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10424);
if(temp__5753__auto__){
var seq__10424__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10424__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__10424__$1);
var G__10432 = cljs.core.chunk_rest(seq__10424__$1);
var G__10433 = c__4649__auto__;
var G__10434 = cljs.core.count(c__4649__auto__);
var G__10435 = (0);
seq__10424 = G__10432;
chunk__10425 = G__10433;
count__10426 = G__10434;
i__10427 = G__10435;
continue;
} else {
var param = cljs.core.first(seq__10424__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10436 = cljs.core.next(seq__10424__$1);
var G__10437 = null;
var G__10438 = (0);
var G__10439 = (0);
seq__10424 = G__10436;
chunk__10425 = G__10437;
count__10426 = G__10438;
i__10427 = G__10439;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__10440){
var map__10441 = p__10440;
var map__10441__$1 = cljs.core.__destructure_map(map__10441);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10441__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10441__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10441__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10441__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10441__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10441__$1,cljs.core.cst$kw$recurs);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__10442){
var map__10443 = p__10442;
var map__10443__$1 = cljs.core.__destructure_map(map__10443);
var f = map__10443__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10443__$1,cljs.core.cst$kw$recurs);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_10452__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10453 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10452__$1);
var delegate_name_10454 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10453),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_10454," = function (");

var seq__10444_10455 = cljs.core.seq(params);
var chunk__10445_10456 = null;
var count__10446_10457 = (0);
var i__10447_10458 = (0);
while(true){
if((i__10447_10458 < count__10446_10457)){
var param_10459 = chunk__10445_10456.cljs$core$IIndexed$_nth$arity$2(null,i__10447_10458);
cljs.compiler.emit(param_10459);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10459,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10460 = seq__10444_10455;
var G__10461 = chunk__10445_10456;
var G__10462 = count__10446_10457;
var G__10463 = (i__10447_10458 + (1));
seq__10444_10455 = G__10460;
chunk__10445_10456 = G__10461;
count__10446_10457 = G__10462;
i__10447_10458 = G__10463;
continue;
} else {
var temp__5753__auto___10464 = cljs.core.seq(seq__10444_10455);
if(temp__5753__auto___10464){
var seq__10444_10465__$1 = temp__5753__auto___10464;
if(cljs.core.chunked_seq_QMARK_(seq__10444_10465__$1)){
var c__4649__auto___10466 = cljs.core.chunk_first(seq__10444_10465__$1);
var G__10467 = cljs.core.chunk_rest(seq__10444_10465__$1);
var G__10468 = c__4649__auto___10466;
var G__10469 = cljs.core.count(c__4649__auto___10466);
var G__10470 = (0);
seq__10444_10455 = G__10467;
chunk__10445_10456 = G__10468;
count__10446_10457 = G__10469;
i__10447_10458 = G__10470;
continue;
} else {
var param_10471 = cljs.core.first(seq__10444_10465__$1);
cljs.compiler.emit(param_10471);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10471,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10472 = cljs.core.next(seq__10444_10465__$1);
var G__10473 = null;
var G__10474 = (0);
var G__10475 = (0);
seq__10444_10455 = G__10472;
chunk__10445_10456 = G__10473;
count__10446_10457 = G__10474;
i__10447_10458 = G__10475;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_10453," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_10476 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_10476,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_10454,".call(this,");

var seq__10448_10477 = cljs.core.seq(params);
var chunk__10449_10478 = null;
var count__10450_10479 = (0);
var i__10451_10480 = (0);
while(true){
if((i__10451_10480 < count__10450_10479)){
var param_10481 = chunk__10449_10478.cljs$core$IIndexed$_nth$arity$2(null,i__10451_10480);
cljs.compiler.emit(param_10481);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10481,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10482 = seq__10448_10477;
var G__10483 = chunk__10449_10478;
var G__10484 = count__10450_10479;
var G__10485 = (i__10451_10480 + (1));
seq__10448_10477 = G__10482;
chunk__10449_10478 = G__10483;
count__10450_10479 = G__10484;
i__10451_10480 = G__10485;
continue;
} else {
var temp__5753__auto___10486 = cljs.core.seq(seq__10448_10477);
if(temp__5753__auto___10486){
var seq__10448_10487__$1 = temp__5753__auto___10486;
if(cljs.core.chunked_seq_QMARK_(seq__10448_10487__$1)){
var c__4649__auto___10488 = cljs.core.chunk_first(seq__10448_10487__$1);
var G__10489 = cljs.core.chunk_rest(seq__10448_10487__$1);
var G__10490 = c__4649__auto___10488;
var G__10491 = cljs.core.count(c__4649__auto___10488);
var G__10492 = (0);
seq__10448_10477 = G__10489;
chunk__10449_10478 = G__10490;
count__10450_10479 = G__10491;
i__10451_10480 = G__10492;
continue;
} else {
var param_10493 = cljs.core.first(seq__10448_10487__$1);
cljs.compiler.emit(param_10493);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_10493,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__10494 = cljs.core.next(seq__10448_10487__$1);
var G__10495 = null;
var G__10496 = (0);
var G__10497 = (0);
seq__10448_10477 = G__10494;
chunk__10449_10478 = G__10495;
count__10450_10479 = G__10496;
i__10451_10480 = G__10497;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10453,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_10453,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_10452__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10453,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_10454,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10453,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__10501){
var map__10502 = p__10501;
var map__10502__$1 = cljs.core.__destructure_map(map__10502);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10502__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10498_SHARP_){
var and__4221__auto__ = p1__10498_SHARP_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__10498_SHARP_));
} else {
return and__4221__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4223__auto__ = in_loop;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_10554__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_10555 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_10554__$1);
var maxparams_10556 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_10557 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_10555),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_10558 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__10499_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__10499_SHARP_)));
}),cljs.core.seq(mmap_10557));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_10555," = null;");

var seq__10503_10559 = cljs.core.seq(ms_10558);
var chunk__10504_10560 = null;
var count__10505_10561 = (0);
var i__10506_10562 = (0);
while(true){
if((i__10506_10562 < count__10505_10561)){
var vec__10513_10563 = chunk__10504_10560.cljs$core$IIndexed$_nth$arity$2(null,i__10506_10562);
var n_10564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10513_10563,(0),null);
var meth_10565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10513_10563,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10564," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10565))){
cljs.compiler.emit_variadic_fn_method(meth_10565);
} else {
cljs.compiler.emit_fn_method(meth_10565);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10566 = seq__10503_10559;
var G__10567 = chunk__10504_10560;
var G__10568 = count__10505_10561;
var G__10569 = (i__10506_10562 + (1));
seq__10503_10559 = G__10566;
chunk__10504_10560 = G__10567;
count__10505_10561 = G__10568;
i__10506_10562 = G__10569;
continue;
} else {
var temp__5753__auto___10570 = cljs.core.seq(seq__10503_10559);
if(temp__5753__auto___10570){
var seq__10503_10571__$1 = temp__5753__auto___10570;
if(cljs.core.chunked_seq_QMARK_(seq__10503_10571__$1)){
var c__4649__auto___10572 = cljs.core.chunk_first(seq__10503_10571__$1);
var G__10573 = cljs.core.chunk_rest(seq__10503_10571__$1);
var G__10574 = c__4649__auto___10572;
var G__10575 = cljs.core.count(c__4649__auto___10572);
var G__10576 = (0);
seq__10503_10559 = G__10573;
chunk__10504_10560 = G__10574;
count__10505_10561 = G__10575;
i__10506_10562 = G__10576;
continue;
} else {
var vec__10516_10577 = cljs.core.first(seq__10503_10571__$1);
var n_10578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10516_10577,(0),null);
var meth_10579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10516_10577,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_10578," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10579))){
cljs.compiler.emit_variadic_fn_method(meth_10579);
} else {
cljs.compiler.emit_fn_method(meth_10579);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__10580 = cljs.core.next(seq__10503_10571__$1);
var G__10581 = null;
var G__10582 = (0);
var G__10583 = (0);
seq__10503_10559 = G__10580;
chunk__10504_10560 = G__10581;
count__10505_10561 = G__10582;
i__10506_10562 = G__10583;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10555," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_10556),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_10556)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_10556));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__10519_10584 = cljs.core.seq(ms_10558);
var chunk__10520_10585 = null;
var count__10521_10586 = (0);
var i__10522_10587 = (0);
while(true){
if((i__10522_10587 < count__10521_10586)){
var vec__10529_10588 = chunk__10520_10585.cljs$core$IIndexed$_nth$arity$2(null,i__10522_10587);
var n_10589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10529_10588,(0),null);
var meth_10590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10529_10588,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10590))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10591 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10591," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10592 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10591," = new cljs.core.IndexedSeq(",a_10592,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10589,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10556)),(((cljs.core.count(maxparams_10556) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10591,");"], 0));
} else {
var pcnt_10593 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10590));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10593,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10589,".call(this",(((pcnt_10593 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10593,maxparams_10556)),null,(1),null)),(2),null))),");");
}


var G__10594 = seq__10519_10584;
var G__10595 = chunk__10520_10585;
var G__10596 = count__10521_10586;
var G__10597 = (i__10522_10587 + (1));
seq__10519_10584 = G__10594;
chunk__10520_10585 = G__10595;
count__10521_10586 = G__10596;
i__10522_10587 = G__10597;
continue;
} else {
var temp__5753__auto___10598 = cljs.core.seq(seq__10519_10584);
if(temp__5753__auto___10598){
var seq__10519_10599__$1 = temp__5753__auto___10598;
if(cljs.core.chunked_seq_QMARK_(seq__10519_10599__$1)){
var c__4649__auto___10600 = cljs.core.chunk_first(seq__10519_10599__$1);
var G__10601 = cljs.core.chunk_rest(seq__10519_10599__$1);
var G__10602 = c__4649__auto___10600;
var G__10603 = cljs.core.count(c__4649__auto___10600);
var G__10604 = (0);
seq__10519_10584 = G__10601;
chunk__10520_10585 = G__10602;
count__10521_10586 = G__10603;
i__10522_10587 = G__10604;
continue;
} else {
var vec__10532_10605 = cljs.core.first(seq__10519_10599__$1);
var n_10606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10532_10605,(0),null);
var meth_10607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10532_10605,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10607))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_10608 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_10608," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_10609 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_10608," = new cljs.core.IndexedSeq(",a_10609,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_10606,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_10556)),(((cljs.core.count(maxparams_10556) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_10608,");"], 0));
} else {
var pcnt_10610 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10607));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_10610,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_10606,".call(this",(((pcnt_10610 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_10610,maxparams_10556)),null,(1),null)),(2),null))),");");
}


var G__10611 = cljs.core.next(seq__10519_10599__$1);
var G__10612 = null;
var G__10613 = (0);
var G__10614 = (0);
seq__10519_10584 = G__10611;
chunk__10520_10585 = G__10612;
count__10521_10586 = G__10613;
i__10522_10587 = G__10614;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_10615 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_10558)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_10615,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10555,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10555,".cljs$lang$applyTo = ",cljs.core.some((function (p1__10500_SHARP_){
var vec__10535 = p1__10500_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10535,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10535,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_10558),".cljs$lang$applyTo;");
} else {
}

var seq__10538_10616 = cljs.core.seq(ms_10558);
var chunk__10539_10617 = null;
var count__10540_10618 = (0);
var i__10541_10619 = (0);
while(true){
if((i__10541_10619 < count__10540_10618)){
var vec__10548_10620 = chunk__10539_10617.cljs$core$IIndexed$_nth$arity$2(null,i__10541_10619);
var n_10621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10548_10620,(0),null);
var meth_10622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10548_10620,(1),null);
var c_10623 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10622));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10622))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10555,".cljs$core$IFn$_invoke$arity$variadic = ",n_10621,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10555,".cljs$core$IFn$_invoke$arity$",c_10623," = ",n_10621,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10624 = seq__10538_10616;
var G__10625 = chunk__10539_10617;
var G__10626 = count__10540_10618;
var G__10627 = (i__10541_10619 + (1));
seq__10538_10616 = G__10624;
chunk__10539_10617 = G__10625;
count__10540_10618 = G__10626;
i__10541_10619 = G__10627;
continue;
} else {
var temp__5753__auto___10628 = cljs.core.seq(seq__10538_10616);
if(temp__5753__auto___10628){
var seq__10538_10629__$1 = temp__5753__auto___10628;
if(cljs.core.chunked_seq_QMARK_(seq__10538_10629__$1)){
var c__4649__auto___10630 = cljs.core.chunk_first(seq__10538_10629__$1);
var G__10631 = cljs.core.chunk_rest(seq__10538_10629__$1);
var G__10632 = c__4649__auto___10630;
var G__10633 = cljs.core.count(c__4649__auto___10630);
var G__10634 = (0);
seq__10538_10616 = G__10631;
chunk__10539_10617 = G__10632;
count__10540_10618 = G__10633;
i__10541_10619 = G__10634;
continue;
} else {
var vec__10551_10635 = cljs.core.first(seq__10538_10629__$1);
var n_10636 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10551_10635,(0),null);
var meth_10637 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10551_10635,(1),null);
var c_10638 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_10637));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_10637))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_10555,".cljs$core$IFn$_invoke$arity$variadic = ",n_10636,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_10555,".cljs$core$IFn$_invoke$arity$",c_10638," = ",n_10636,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__10639 = cljs.core.next(seq__10538_10629__$1);
var G__10640 = null;
var G__10641 = (0);
var G__10642 = (0);
seq__10538_10616 = G__10639;
chunk__10539_10617 = G__10640;
count__10540_10618 = G__10641;
i__10541_10619 = G__10642;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_10555,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__10643){
var map__10644 = p__10643;
var map__10644__$1 = cljs.core.__destructure_map(map__10644);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10644__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10644__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10644__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10645_10649 = cljs.core.seq(statements);
var chunk__10646_10650 = null;
var count__10647_10651 = (0);
var i__10648_10652 = (0);
while(true){
if((i__10648_10652 < count__10647_10651)){
var s_10653 = chunk__10646_10650.cljs$core$IIndexed$_nth$arity$2(null,i__10648_10652);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10653);


var G__10654 = seq__10645_10649;
var G__10655 = chunk__10646_10650;
var G__10656 = count__10647_10651;
var G__10657 = (i__10648_10652 + (1));
seq__10645_10649 = G__10654;
chunk__10646_10650 = G__10655;
count__10647_10651 = G__10656;
i__10648_10652 = G__10657;
continue;
} else {
var temp__5753__auto___10658 = cljs.core.seq(seq__10645_10649);
if(temp__5753__auto___10658){
var seq__10645_10659__$1 = temp__5753__auto___10658;
if(cljs.core.chunked_seq_QMARK_(seq__10645_10659__$1)){
var c__4649__auto___10660 = cljs.core.chunk_first(seq__10645_10659__$1);
var G__10661 = cljs.core.chunk_rest(seq__10645_10659__$1);
var G__10662 = c__4649__auto___10660;
var G__10663 = cljs.core.count(c__4649__auto___10660);
var G__10664 = (0);
seq__10645_10649 = G__10661;
chunk__10646_10650 = G__10662;
count__10647_10651 = G__10663;
i__10648_10652 = G__10664;
continue;
} else {
var s_10665 = cljs.core.first(seq__10645_10659__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_10665);


var G__10666 = cljs.core.next(seq__10645_10659__$1);
var G__10667 = null;
var G__10668 = (0);
var G__10669 = (0);
seq__10645_10649 = G__10666;
chunk__10646_10650 = G__10667;
count__10647_10651 = G__10668;
i__10648_10652 = G__10669;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__10670){
var map__10671 = p__10670;
var map__10671__$1 = cljs.core.__destructure_map(map__10671);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10671__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10671__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10671__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10671__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10671__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__10672,is_loop){
var map__10673 = p__10672;
var map__10673__$1 = cljs.core.__destructure_map(map__10673);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10673__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10673__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10673__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__10674_10684 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__10675_10685 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__10675_10685);

try{var seq__10676_10686 = cljs.core.seq(bindings);
var chunk__10677_10687 = null;
var count__10678_10688 = (0);
var i__10679_10689 = (0);
while(true){
if((i__10679_10689 < count__10678_10688)){
var map__10682_10690 = chunk__10677_10687.cljs$core$IIndexed$_nth$arity$2(null,i__10679_10689);
var map__10682_10691__$1 = cljs.core.__destructure_map(map__10682_10690);
var binding_10692 = map__10682_10691__$1;
var init_10693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10682_10691__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10692);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10693,";");


var G__10694 = seq__10676_10686;
var G__10695 = chunk__10677_10687;
var G__10696 = count__10678_10688;
var G__10697 = (i__10679_10689 + (1));
seq__10676_10686 = G__10694;
chunk__10677_10687 = G__10695;
count__10678_10688 = G__10696;
i__10679_10689 = G__10697;
continue;
} else {
var temp__5753__auto___10698 = cljs.core.seq(seq__10676_10686);
if(temp__5753__auto___10698){
var seq__10676_10699__$1 = temp__5753__auto___10698;
if(cljs.core.chunked_seq_QMARK_(seq__10676_10699__$1)){
var c__4649__auto___10700 = cljs.core.chunk_first(seq__10676_10699__$1);
var G__10701 = cljs.core.chunk_rest(seq__10676_10699__$1);
var G__10702 = c__4649__auto___10700;
var G__10703 = cljs.core.count(c__4649__auto___10700);
var G__10704 = (0);
seq__10676_10686 = G__10701;
chunk__10677_10687 = G__10702;
count__10678_10688 = G__10703;
i__10679_10689 = G__10704;
continue;
} else {
var map__10683_10705 = cljs.core.first(seq__10676_10699__$1);
var map__10683_10706__$1 = cljs.core.__destructure_map(map__10683_10705);
var binding_10707 = map__10683_10706__$1;
var init_10708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10683_10706__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_10707);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_10708,";");


var G__10709 = cljs.core.next(seq__10676_10699__$1);
var G__10710 = null;
var G__10711 = (0);
var G__10712 = (0);
seq__10676_10686 = G__10709;
chunk__10677_10687 = G__10710;
count__10678_10688 = G__10711;
i__10679_10689 = G__10712;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__10674_10684);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__10713){
var map__10714 = p__10713;
var map__10714__$1 = cljs.core.__destructure_map(map__10714);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10714__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10714__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10714__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4706__auto___10715 = cljs.core.count(exprs);
var i_10716 = (0);
while(true){
if((i_10716 < n__4706__auto___10715)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10716) : temps.call(null,i_10716))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_10716) : exprs.call(null,i_10716)),";");

var G__10717 = (i_10716 + (1));
i_10716 = G__10717;
continue;
} else {
}
break;
}

var n__4706__auto___10718 = cljs.core.count(exprs);
var i_10719 = (0);
while(true){
if((i_10719 < n__4706__auto___10718)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_10719) : params.call(null,i_10719)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_10719) : temps.call(null,i_10719)),";");

var G__10720 = (i_10719 + (1));
i_10719 = G__10720;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__10721){
var map__10722 = p__10721;
var map__10722__$1 = cljs.core.__destructure_map(map__10722);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10722__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10722__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10722__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__10723_10731 = cljs.core.seq(bindings);
var chunk__10724_10732 = null;
var count__10725_10733 = (0);
var i__10726_10734 = (0);
while(true){
if((i__10726_10734 < count__10725_10733)){
var map__10729_10735 = chunk__10724_10732.cljs$core$IIndexed$_nth$arity$2(null,i__10726_10734);
var map__10729_10736__$1 = cljs.core.__destructure_map(map__10729_10735);
var binding_10737 = map__10729_10736__$1;
var init_10738 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10729_10736__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10737)," = ",init_10738,";");


var G__10739 = seq__10723_10731;
var G__10740 = chunk__10724_10732;
var G__10741 = count__10725_10733;
var G__10742 = (i__10726_10734 + (1));
seq__10723_10731 = G__10739;
chunk__10724_10732 = G__10740;
count__10725_10733 = G__10741;
i__10726_10734 = G__10742;
continue;
} else {
var temp__5753__auto___10743 = cljs.core.seq(seq__10723_10731);
if(temp__5753__auto___10743){
var seq__10723_10744__$1 = temp__5753__auto___10743;
if(cljs.core.chunked_seq_QMARK_(seq__10723_10744__$1)){
var c__4649__auto___10745 = cljs.core.chunk_first(seq__10723_10744__$1);
var G__10746 = cljs.core.chunk_rest(seq__10723_10744__$1);
var G__10747 = c__4649__auto___10745;
var G__10748 = cljs.core.count(c__4649__auto___10745);
var G__10749 = (0);
seq__10723_10731 = G__10746;
chunk__10724_10732 = G__10747;
count__10725_10733 = G__10748;
i__10726_10734 = G__10749;
continue;
} else {
var map__10730_10750 = cljs.core.first(seq__10723_10744__$1);
var map__10730_10751__$1 = cljs.core.__destructure_map(map__10730_10750);
var binding_10752 = map__10730_10751__$1;
var init_10753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10730_10751__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_10752)," = ",init_10753,";");


var G__10754 = cljs.core.next(seq__10723_10744__$1);
var G__10755 = null;
var G__10756 = (0);
var G__10757 = (0);
seq__10723_10731 = G__10754;
chunk__10724_10732 = G__10755;
count__10725_10733 = G__10756;
i__10726_10734 = G__10757;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__10760){
var map__10761 = p__10760;
var map__10761__$1 = cljs.core.__destructure_map(map__10761);
var expr = map__10761__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10761__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10761__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10761__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4221__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4221__auto__ = protocol;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = tag;
if(cljs.core.truth_(and__4221__auto____$1)){
var or__4223__auto__ = (function (){var and__4221__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto____$2)){
var and__4221__auto____$3 = protocol;
if(cljs.core.truth_(and__4221__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4221__auto____$3;
}
} else {
return and__4221__auto____$2;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto____$2 = (function (){var or__4223__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4221__auto____$2)){
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
var and__4221__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4221__auto____$3){
var and__4221__auto____$4 = cljs.core.not((function (){var fexpr__10765 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__10765.cljs$core$IFn$_invoke$arity$1 ? fexpr__10765.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__10765.call(null,tag));
})());
if(and__4221__auto____$4){
var temp__5753__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4221__auto____$4;
}
} else {
return and__4221__auto____$3;
}
}
} else {
return and__4221__auto____$2;
}
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__10766 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__10766.cljs$core$IFn$_invoke$arity$1 ? fexpr__10766.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__10766.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__10762 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (arity > mfa);
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__10758_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10758_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__10759_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__10759_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10762,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10762,(1),null);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_10769 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_10769,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_10770 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_10770,args)),(((mfa_10770 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_10770,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var G__10768 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__10767 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__10767.cljs$core$IFn$_invoke$arity$1 ? fexpr__10767.cljs$core$IFn$_invoke$arity$1(G__10768) : fexpr__10767.call(null,G__10768));
} else {
return and__4221__auto__;
}
})())){
var fprop_10771 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10771," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10771,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_10771," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_10771,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__10772){
var map__10773 = p__10772;
var map__10773__$1 = cljs.core.__destructure_map(map__10773);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10773__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10773__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10773__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__10774){
var map__10775 = p__10774;
var map__10775__$1 = cljs.core.__destructure_map(map__10775);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10775__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10775__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10775__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10776_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__10776_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__10777 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10777,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10777,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__10780 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__10780__$1 = cljs.core.__destructure_map(map__10780);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10780__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10780__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__10781 = options;
var map__10781__$1 = cljs.core.__destructure_map(map__10781);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10781__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10781__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10781__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__10782 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__10785 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__10785__$1 = cljs.core.__destructure_map(map__10785);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10785__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10785__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10782,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10782,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__10786_10814 = cljs.core.seq(libs_to_load);
var chunk__10787_10815 = null;
var count__10788_10816 = (0);
var i__10789_10817 = (0);
while(true){
if((i__10789_10817 < count__10788_10816)){
var lib_10818 = chunk__10787_10815.cljs$core$IIndexed$_nth$arity$2(null,i__10789_10817);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10818)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10818),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10818),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10818),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10818),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10818,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10818),"');");
}

}
}
}


var G__10819 = seq__10786_10814;
var G__10820 = chunk__10787_10815;
var G__10821 = count__10788_10816;
var G__10822 = (i__10789_10817 + (1));
seq__10786_10814 = G__10819;
chunk__10787_10815 = G__10820;
count__10788_10816 = G__10821;
i__10789_10817 = G__10822;
continue;
} else {
var temp__5753__auto___10823 = cljs.core.seq(seq__10786_10814);
if(temp__5753__auto___10823){
var seq__10786_10824__$1 = temp__5753__auto___10823;
if(cljs.core.chunked_seq_QMARK_(seq__10786_10824__$1)){
var c__4649__auto___10825 = cljs.core.chunk_first(seq__10786_10824__$1);
var G__10826 = cljs.core.chunk_rest(seq__10786_10824__$1);
var G__10827 = c__4649__auto___10825;
var G__10828 = cljs.core.count(c__4649__auto___10825);
var G__10829 = (0);
seq__10786_10814 = G__10826;
chunk__10787_10815 = G__10827;
count__10788_10816 = G__10828;
i__10789_10817 = G__10829;
continue;
} else {
var lib_10830 = cljs.core.first(seq__10786_10824__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_10830)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10830),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10830),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_10830),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10830),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_10830,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_10830),"');");
}

}
}
}


var G__10831 = cljs.core.next(seq__10786_10824__$1);
var G__10832 = null;
var G__10833 = (0);
var G__10834 = (0);
seq__10786_10814 = G__10831;
chunk__10787_10815 = G__10832;
count__10788_10816 = G__10833;
i__10789_10817 = G__10834;
continue;
}
} else {
}
}
break;
}

var seq__10790_10835 = cljs.core.seq(node_libs);
var chunk__10791_10836 = null;
var count__10792_10837 = (0);
var i__10793_10838 = (0);
while(true){
if((i__10793_10838 < count__10792_10837)){
var lib_10839 = chunk__10791_10836.cljs$core$IIndexed$_nth$arity$2(null,i__10793_10838);
var vec__10800_10840 = cljs.analyzer.lib_AMPERSAND_sublib(lib_10839);
var lib_SINGLEQUOTE__10841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10800_10840,(0),null);
var sublib_10842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10800_10840,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10839)," = require('",lib_SINGLEQUOTE__10841,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_10842),";"], 0));


var G__10843 = seq__10790_10835;
var G__10844 = chunk__10791_10836;
var G__10845 = count__10792_10837;
var G__10846 = (i__10793_10838 + (1));
seq__10790_10835 = G__10843;
chunk__10791_10836 = G__10844;
count__10792_10837 = G__10845;
i__10793_10838 = G__10846;
continue;
} else {
var temp__5753__auto___10847 = cljs.core.seq(seq__10790_10835);
if(temp__5753__auto___10847){
var seq__10790_10848__$1 = temp__5753__auto___10847;
if(cljs.core.chunked_seq_QMARK_(seq__10790_10848__$1)){
var c__4649__auto___10849 = cljs.core.chunk_first(seq__10790_10848__$1);
var G__10850 = cljs.core.chunk_rest(seq__10790_10848__$1);
var G__10851 = c__4649__auto___10849;
var G__10852 = cljs.core.count(c__4649__auto___10849);
var G__10853 = (0);
seq__10790_10835 = G__10850;
chunk__10791_10836 = G__10851;
count__10792_10837 = G__10852;
i__10793_10838 = G__10853;
continue;
} else {
var lib_10854 = cljs.core.first(seq__10790_10848__$1);
var vec__10803_10855 = cljs.analyzer.lib_AMPERSAND_sublib(lib_10854);
var lib_SINGLEQUOTE__10856 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10803_10855,(0),null);
var sublib_10857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10803_10855,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_10854)," = require('",lib_SINGLEQUOTE__10856,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_10857),";"], 0));


var G__10858 = cljs.core.next(seq__10790_10848__$1);
var G__10859 = null;
var G__10860 = (0);
var G__10861 = (0);
seq__10790_10835 = G__10858;
chunk__10791_10836 = G__10859;
count__10792_10837 = G__10860;
i__10793_10838 = G__10861;
continue;
}
} else {
}
}
break;
}

var seq__10806_10862 = cljs.core.seq(global_exports_libs);
var chunk__10807_10863 = null;
var count__10808_10864 = (0);
var i__10809_10865 = (0);
while(true){
if((i__10809_10865 < count__10808_10864)){
var lib_10866 = chunk__10807_10863.cljs$core$IIndexed$_nth$arity$2(null,i__10809_10865);
var map__10812_10867 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_10866))));
var map__10812_10868__$1 = cljs.core.__destructure_map(map__10812_10867);
var global_exports_10869 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10812_10868__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_10869,lib_10866);


var G__10870 = seq__10806_10862;
var G__10871 = chunk__10807_10863;
var G__10872 = count__10808_10864;
var G__10873 = (i__10809_10865 + (1));
seq__10806_10862 = G__10870;
chunk__10807_10863 = G__10871;
count__10808_10864 = G__10872;
i__10809_10865 = G__10873;
continue;
} else {
var temp__5753__auto___10874 = cljs.core.seq(seq__10806_10862);
if(temp__5753__auto___10874){
var seq__10806_10875__$1 = temp__5753__auto___10874;
if(cljs.core.chunked_seq_QMARK_(seq__10806_10875__$1)){
var c__4649__auto___10876 = cljs.core.chunk_first(seq__10806_10875__$1);
var G__10877 = cljs.core.chunk_rest(seq__10806_10875__$1);
var G__10878 = c__4649__auto___10876;
var G__10879 = cljs.core.count(c__4649__auto___10876);
var G__10880 = (0);
seq__10806_10862 = G__10877;
chunk__10807_10863 = G__10878;
count__10808_10864 = G__10879;
i__10809_10865 = G__10880;
continue;
} else {
var lib_10881 = cljs.core.first(seq__10806_10875__$1);
var map__10813_10882 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_10881))));
var map__10813_10883__$1 = cljs.core.__destructure_map(map__10813_10882);
var global_exports_10884 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10813_10883__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_10884,lib_10881);


var G__10885 = cljs.core.next(seq__10806_10875__$1);
var G__10886 = null;
var G__10887 = (0);
var G__10888 = (0);
seq__10806_10862 = G__10885;
chunk__10807_10863 = G__10886;
count__10808_10864 = G__10887;
i__10809_10865 = G__10888;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__10889){
var map__10890 = p__10889;
var map__10890__$1 = cljs.core.__destructure_map(map__10890);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10890__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10890__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10890__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10890__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10890__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10890__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10890__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__10891){
var map__10892 = p__10891;
var map__10892__$1 = cljs.core.__destructure_map(map__10892);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10892__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10892__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10892__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10892__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10892__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10892__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10892__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__10893){
var map__10894 = p__10893;
var map__10894__$1 = cljs.core.__destructure_map(map__10894);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10894__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10895_10919 = cljs.core.seq(protocols);
var chunk__10896_10920 = null;
var count__10897_10921 = (0);
var i__10898_10922 = (0);
while(true){
if((i__10898_10922 < count__10897_10921)){
var protocol_10923 = chunk__10896_10920.cljs$core$IIndexed$_nth$arity$2(null,i__10898_10922);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10923)),"}");


var G__10924 = seq__10895_10919;
var G__10925 = chunk__10896_10920;
var G__10926 = count__10897_10921;
var G__10927 = (i__10898_10922 + (1));
seq__10895_10919 = G__10924;
chunk__10896_10920 = G__10925;
count__10897_10921 = G__10926;
i__10898_10922 = G__10927;
continue;
} else {
var temp__5753__auto___10928 = cljs.core.seq(seq__10895_10919);
if(temp__5753__auto___10928){
var seq__10895_10929__$1 = temp__5753__auto___10928;
if(cljs.core.chunked_seq_QMARK_(seq__10895_10929__$1)){
var c__4649__auto___10930 = cljs.core.chunk_first(seq__10895_10929__$1);
var G__10931 = cljs.core.chunk_rest(seq__10895_10929__$1);
var G__10932 = c__4649__auto___10930;
var G__10933 = cljs.core.count(c__4649__auto___10930);
var G__10934 = (0);
seq__10895_10919 = G__10931;
chunk__10896_10920 = G__10932;
count__10897_10921 = G__10933;
i__10898_10922 = G__10934;
continue;
} else {
var protocol_10935 = cljs.core.first(seq__10895_10929__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_10935)),"}");


var G__10936 = cljs.core.next(seq__10895_10929__$1);
var G__10937 = null;
var G__10938 = (0);
var G__10939 = (0);
seq__10895_10919 = G__10936;
chunk__10896_10920 = G__10937;
count__10897_10921 = G__10938;
i__10898_10922 = G__10939;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10899_10940 = cljs.core.seq(fields__$1);
var chunk__10900_10941 = null;
var count__10901_10942 = (0);
var i__10902_10943 = (0);
while(true){
if((i__10902_10943 < count__10901_10942)){
var fld_10944 = chunk__10900_10941.cljs$core$IIndexed$_nth$arity$2(null,i__10902_10943);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10944," = ",fld_10944,";");


var G__10945 = seq__10899_10940;
var G__10946 = chunk__10900_10941;
var G__10947 = count__10901_10942;
var G__10948 = (i__10902_10943 + (1));
seq__10899_10940 = G__10945;
chunk__10900_10941 = G__10946;
count__10901_10942 = G__10947;
i__10902_10943 = G__10948;
continue;
} else {
var temp__5753__auto___10949 = cljs.core.seq(seq__10899_10940);
if(temp__5753__auto___10949){
var seq__10899_10950__$1 = temp__5753__auto___10949;
if(cljs.core.chunked_seq_QMARK_(seq__10899_10950__$1)){
var c__4649__auto___10951 = cljs.core.chunk_first(seq__10899_10950__$1);
var G__10952 = cljs.core.chunk_rest(seq__10899_10950__$1);
var G__10953 = c__4649__auto___10951;
var G__10954 = cljs.core.count(c__4649__auto___10951);
var G__10955 = (0);
seq__10899_10940 = G__10952;
chunk__10900_10941 = G__10953;
count__10901_10942 = G__10954;
i__10902_10943 = G__10955;
continue;
} else {
var fld_10956 = cljs.core.first(seq__10899_10950__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_10956," = ",fld_10956,";");


var G__10957 = cljs.core.next(seq__10899_10950__$1);
var G__10958 = null;
var G__10959 = (0);
var G__10960 = (0);
seq__10899_10940 = G__10957;
chunk__10900_10941 = G__10958;
count__10901_10942 = G__10959;
i__10902_10943 = G__10960;
continue;
}
} else {
}
}
break;
}

var seq__10903_10961 = cljs.core.seq(pmasks);
var chunk__10904_10962 = null;
var count__10905_10963 = (0);
var i__10906_10964 = (0);
while(true){
if((i__10906_10964 < count__10905_10963)){
var vec__10913_10965 = chunk__10904_10962.cljs$core$IIndexed$_nth$arity$2(null,i__10906_10964);
var pno_10966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10913_10965,(0),null);
var pmask_10967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10913_10965,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10966,"$ = ",pmask_10967,";");


var G__10968 = seq__10903_10961;
var G__10969 = chunk__10904_10962;
var G__10970 = count__10905_10963;
var G__10971 = (i__10906_10964 + (1));
seq__10903_10961 = G__10968;
chunk__10904_10962 = G__10969;
count__10905_10963 = G__10970;
i__10906_10964 = G__10971;
continue;
} else {
var temp__5753__auto___10972 = cljs.core.seq(seq__10903_10961);
if(temp__5753__auto___10972){
var seq__10903_10973__$1 = temp__5753__auto___10972;
if(cljs.core.chunked_seq_QMARK_(seq__10903_10973__$1)){
var c__4649__auto___10974 = cljs.core.chunk_first(seq__10903_10973__$1);
var G__10975 = cljs.core.chunk_rest(seq__10903_10973__$1);
var G__10976 = c__4649__auto___10974;
var G__10977 = cljs.core.count(c__4649__auto___10974);
var G__10978 = (0);
seq__10903_10961 = G__10975;
chunk__10904_10962 = G__10976;
count__10905_10963 = G__10977;
i__10906_10964 = G__10978;
continue;
} else {
var vec__10916_10979 = cljs.core.first(seq__10903_10973__$1);
var pno_10980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10916_10979,(0),null);
var pmask_10981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10916_10979,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_10980,"$ = ",pmask_10981,";");


var G__10982 = cljs.core.next(seq__10903_10973__$1);
var G__10983 = null;
var G__10984 = (0);
var G__10985 = (0);
seq__10903_10961 = G__10982;
chunk__10904_10962 = G__10983;
count__10905_10963 = G__10984;
i__10906_10964 = G__10985;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__10986){
var map__10987 = p__10986;
var map__10987__$1 = cljs.core.__destructure_map(map__10987);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10987__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10987__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10987__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10987__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10987__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__10988_11012 = cljs.core.seq(protocols);
var chunk__10989_11013 = null;
var count__10990_11014 = (0);
var i__10991_11015 = (0);
while(true){
if((i__10991_11015 < count__10990_11014)){
var protocol_11016 = chunk__10989_11013.cljs$core$IIndexed$_nth$arity$2(null,i__10991_11015);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11016)),"}");


var G__11017 = seq__10988_11012;
var G__11018 = chunk__10989_11013;
var G__11019 = count__10990_11014;
var G__11020 = (i__10991_11015 + (1));
seq__10988_11012 = G__11017;
chunk__10989_11013 = G__11018;
count__10990_11014 = G__11019;
i__10991_11015 = G__11020;
continue;
} else {
var temp__5753__auto___11021 = cljs.core.seq(seq__10988_11012);
if(temp__5753__auto___11021){
var seq__10988_11022__$1 = temp__5753__auto___11021;
if(cljs.core.chunked_seq_QMARK_(seq__10988_11022__$1)){
var c__4649__auto___11023 = cljs.core.chunk_first(seq__10988_11022__$1);
var G__11024 = cljs.core.chunk_rest(seq__10988_11022__$1);
var G__11025 = c__4649__auto___11023;
var G__11026 = cljs.core.count(c__4649__auto___11023);
var G__11027 = (0);
seq__10988_11012 = G__11024;
chunk__10989_11013 = G__11025;
count__10990_11014 = G__11026;
i__10991_11015 = G__11027;
continue;
} else {
var protocol_11028 = cljs.core.first(seq__10988_11022__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_11028)),"}");


var G__11029 = cljs.core.next(seq__10988_11022__$1);
var G__11030 = null;
var G__11031 = (0);
var G__11032 = (0);
seq__10988_11012 = G__11029;
chunk__10989_11013 = G__11030;
count__10990_11014 = G__11031;
i__10991_11015 = G__11032;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__10992_11033 = cljs.core.seq(fields__$1);
var chunk__10993_11034 = null;
var count__10994_11035 = (0);
var i__10995_11036 = (0);
while(true){
if((i__10995_11036 < count__10994_11035)){
var fld_11037 = chunk__10993_11034.cljs$core$IIndexed$_nth$arity$2(null,i__10995_11036);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11037," = ",fld_11037,";");


var G__11038 = seq__10992_11033;
var G__11039 = chunk__10993_11034;
var G__11040 = count__10994_11035;
var G__11041 = (i__10995_11036 + (1));
seq__10992_11033 = G__11038;
chunk__10993_11034 = G__11039;
count__10994_11035 = G__11040;
i__10995_11036 = G__11041;
continue;
} else {
var temp__5753__auto___11042 = cljs.core.seq(seq__10992_11033);
if(temp__5753__auto___11042){
var seq__10992_11043__$1 = temp__5753__auto___11042;
if(cljs.core.chunked_seq_QMARK_(seq__10992_11043__$1)){
var c__4649__auto___11044 = cljs.core.chunk_first(seq__10992_11043__$1);
var G__11045 = cljs.core.chunk_rest(seq__10992_11043__$1);
var G__11046 = c__4649__auto___11044;
var G__11047 = cljs.core.count(c__4649__auto___11044);
var G__11048 = (0);
seq__10992_11033 = G__11045;
chunk__10993_11034 = G__11046;
count__10994_11035 = G__11047;
i__10995_11036 = G__11048;
continue;
} else {
var fld_11049 = cljs.core.first(seq__10992_11043__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_11049," = ",fld_11049,";");


var G__11050 = cljs.core.next(seq__10992_11043__$1);
var G__11051 = null;
var G__11052 = (0);
var G__11053 = (0);
seq__10992_11033 = G__11050;
chunk__10993_11034 = G__11051;
count__10994_11035 = G__11052;
i__10995_11036 = G__11053;
continue;
}
} else {
}
}
break;
}

var seq__10996_11054 = cljs.core.seq(pmasks);
var chunk__10997_11055 = null;
var count__10998_11056 = (0);
var i__10999_11057 = (0);
while(true){
if((i__10999_11057 < count__10998_11056)){
var vec__11006_11058 = chunk__10997_11055.cljs$core$IIndexed$_nth$arity$2(null,i__10999_11057);
var pno_11059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11006_11058,(0),null);
var pmask_11060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11006_11058,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11059,"$ = ",pmask_11060,";");


var G__11061 = seq__10996_11054;
var G__11062 = chunk__10997_11055;
var G__11063 = count__10998_11056;
var G__11064 = (i__10999_11057 + (1));
seq__10996_11054 = G__11061;
chunk__10997_11055 = G__11062;
count__10998_11056 = G__11063;
i__10999_11057 = G__11064;
continue;
} else {
var temp__5753__auto___11065 = cljs.core.seq(seq__10996_11054);
if(temp__5753__auto___11065){
var seq__10996_11066__$1 = temp__5753__auto___11065;
if(cljs.core.chunked_seq_QMARK_(seq__10996_11066__$1)){
var c__4649__auto___11067 = cljs.core.chunk_first(seq__10996_11066__$1);
var G__11068 = cljs.core.chunk_rest(seq__10996_11066__$1);
var G__11069 = c__4649__auto___11067;
var G__11070 = cljs.core.count(c__4649__auto___11067);
var G__11071 = (0);
seq__10996_11054 = G__11068;
chunk__10997_11055 = G__11069;
count__10998_11056 = G__11070;
i__10999_11057 = G__11071;
continue;
} else {
var vec__11009_11072 = cljs.core.first(seq__10996_11066__$1);
var pno_11073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11009_11072,(0),null);
var pmask_11074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11009_11072,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_11073,"$ = ",pmask_11074,";");


var G__11075 = cljs.core.next(seq__10996_11066__$1);
var G__11076 = null;
var G__11077 = (0);
var G__11078 = (0);
seq__10996_11054 = G__11075;
chunk__10997_11055 = G__11076;
count__10998_11056 = G__11077;
i__10999_11057 = G__11078;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__11079){
var map__11080 = p__11079;
var map__11080__$1 = cljs.core.__destructure_map(map__11080);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11080__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11080__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11080__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11080__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11080__$1,cljs.core.cst$kw$env);
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__11081){
var map__11082 = p__11081;
var map__11082__$1 = cljs.core.__destructure_map(map__11082);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11082__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11082__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11082__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11082__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11082__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4221__auto__ = code;
if(cljs.core.truth_(and__4221__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4221__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__9882__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__9882__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__11087 = cljs.core.seq(table);
var chunk__11088 = null;
var count__11089 = (0);
var i__11090 = (0);
while(true){
if((i__11090 < count__11089)){
var vec__11097 = chunk__11088.cljs$core$IIndexed$_nth$arity$2(null,i__11090);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11097,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11097,(1),null);
var ns_11103 = cljs.core.namespace(sym);
var name_11104 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__11105 = seq__11087;
var G__11106 = chunk__11088;
var G__11107 = count__11089;
var G__11108 = (i__11090 + (1));
seq__11087 = G__11105;
chunk__11088 = G__11106;
count__11089 = G__11107;
i__11090 = G__11108;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11087);
if(temp__5753__auto__){
var seq__11087__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11087__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__11087__$1);
var G__11109 = cljs.core.chunk_rest(seq__11087__$1);
var G__11110 = c__4649__auto__;
var G__11111 = cljs.core.count(c__4649__auto__);
var G__11112 = (0);
seq__11087 = G__11109;
chunk__11088 = G__11110;
count__11089 = G__11111;
i__11090 = G__11112;
continue;
} else {
var vec__11100 = cljs.core.first(seq__11087__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11100,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11100,(1),null);
var ns_11113 = cljs.core.namespace(sym);
var name_11114 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__11115 = cljs.core.next(seq__11087__$1);
var G__11116 = null;
var G__11117 = (0);
var G__11118 = (0);
seq__11087 = G__11115;
chunk__11088 = G__11116;
count__11089 = G__11117;
i__11090 = G__11118;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__11120 = arguments.length;
switch (G__11120) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_11125 = cljs.core.first(ks);
var vec__11121_11126 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_11125);
var top_11127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11121_11126,(0),null);
var prefix_SINGLEQUOTE__11128 = vec__11121_11126;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_11125)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__11128) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_11127)) || (cljs.core.contains_QMARK_(known_externs,top_11127)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__11128)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_11127);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__11128)),";");
}
} else {
}

var m_11129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_11125);
if(cljs.core.empty_QMARK_(m_11129)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__11128,m_11129,top_level,known_externs);
}

var G__11130 = cljs.core.next(ks);
ks = G__11130;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

