// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__14912 = arguments.length;
switch (G__14912) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14913 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14913 = (function (f,blockable,meta14914){
this.f = f;
this.blockable = blockable;
this.meta14914 = meta14914;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14913.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14915,meta14914__$1){
var self__ = this;
var _14915__$1 = this;
return (new cljs.core.async.t_cljs$core$async14913(self__.f,self__.blockable,meta14914__$1));
}));

(cljs.core.async.t_cljs$core$async14913.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14915){
var self__ = this;
var _14915__$1 = this;
return self__.meta14914;
}));

(cljs.core.async.t_cljs$core$async14913.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14913.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14913.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async14913.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async14913.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta14914], null);
}));

(cljs.core.async.t_cljs$core$async14913.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14913.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14913");

(cljs.core.async.t_cljs$core$async14913.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async14913");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14913.
 */
cljs.core.async.__GT_t_cljs$core$async14913 = (function cljs$core$async$__GT_t_cljs$core$async14913(f__$1,blockable__$1,meta14914){
return (new cljs.core.async.t_cljs$core$async14913(f__$1,blockable__$1,meta14914));
});

}

return (new cljs.core.async.t_cljs$core$async14913(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__14919 = arguments.length;
switch (G__14919) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__14922 = arguments.length;
switch (G__14922) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__14925 = arguments.length;
switch (G__14925) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_14927 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14927) : fn1.call(null,val_14927));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14927) : fn1.call(null,val_14927));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__14929 = arguments.length;
switch (G__14929) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4706__auto___14931 = n;
var x_14932 = (0);
while(true){
if((x_14932 < n__4706__auto___14931)){
(a[x_14932] = x_14932);

var G__14933 = (x_14932 + (1));
x_14932 = G__14933;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14934 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14934 = (function (flag,meta14935){
this.flag = flag;
this.meta14935 = meta14935;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14934.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14936,meta14935__$1){
var self__ = this;
var _14936__$1 = this;
return (new cljs.core.async.t_cljs$core$async14934(self__.flag,meta14935__$1));
}));

(cljs.core.async.t_cljs$core$async14934.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14936){
var self__ = this;
var _14936__$1 = this;
return self__.meta14935;
}));

(cljs.core.async.t_cljs$core$async14934.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14934.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14934.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14934.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async14934.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta14935], null);
}));

(cljs.core.async.t_cljs$core$async14934.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14934.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14934");

(cljs.core.async.t_cljs$core$async14934.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async14934");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14934.
 */
cljs.core.async.__GT_t_cljs$core$async14934 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14934(flag__$1,meta14935){
return (new cljs.core.async.t_cljs$core$async14934(flag__$1,meta14935));
});

}

return (new cljs.core.async.t_cljs$core$async14934(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14937 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14937 = (function (flag,cb,meta14938){
this.flag = flag;
this.cb = cb;
this.meta14938 = meta14938;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14937.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14939,meta14938__$1){
var self__ = this;
var _14939__$1 = this;
return (new cljs.core.async.t_cljs$core$async14937(self__.flag,self__.cb,meta14938__$1));
}));

(cljs.core.async.t_cljs$core$async14937.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14939){
var self__ = this;
var _14939__$1 = this;
return self__.meta14938;
}));

(cljs.core.async.t_cljs$core$async14937.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14937.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14937.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14937.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async14937.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta14938], null);
}));

(cljs.core.async.t_cljs$core$async14937.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14937.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14937");

(cljs.core.async.t_cljs$core$async14937.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async14937");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14937.
 */
cljs.core.async.__GT_t_cljs$core$async14937 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14937(flag__$1,cb__$1,meta14938){
return (new cljs.core.async.t_cljs$core$async14937(flag__$1,cb__$1,meta14938));
});

}

return (new cljs.core.async.t_cljs$core$async14937(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14940_SHARP_){
var G__14942 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14940_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14942) : fret.call(null,G__14942));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14941_SHARP_){
var G__14943 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14941_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14943) : fret.call(null,G__14943));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4223__auto__ = wport;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14944 = (i + (1));
i = G__14944;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4223__auto__ = ret;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4221__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4221__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___14949 = arguments.length;
var i__4830__auto___14950 = (0);
while(true){
if((i__4830__auto___14950 < len__4829__auto___14949)){
args__4835__auto__.push((arguments[i__4830__auto___14950]));

var G__14951 = (i__4830__auto___14950 + (1));
i__4830__auto___14950 = G__14951;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14947){
var map__14948 = p__14947;
var map__14948__$1 = cljs.core.__destructure_map(map__14948);
var opts = map__14948__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14945){
var G__14946 = cljs.core.first(seq14945);
var seq14945__$1 = cljs.core.next(seq14945);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14946,seq14945__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__14953 = arguments.length;
switch (G__14953) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__14852__auto___15000 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_14977){
var state_val_14978 = (state_14977[(1)]);
if((state_val_14978 === (7))){
var inst_14973 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
var statearr_14979_15001 = state_14977__$1;
(statearr_14979_15001[(2)] = inst_14973);

(statearr_14979_15001[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (1))){
var state_14977__$1 = state_14977;
var statearr_14980_15002 = state_14977__$1;
(statearr_14980_15002[(2)] = null);

(statearr_14980_15002[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (4))){
var inst_14956 = (state_14977[(7)]);
var inst_14956__$1 = (state_14977[(2)]);
var inst_14957 = (inst_14956__$1 == null);
var state_14977__$1 = (function (){var statearr_14981 = state_14977;
(statearr_14981[(7)] = inst_14956__$1);

return statearr_14981;
})();
if(cljs.core.truth_(inst_14957)){
var statearr_14982_15003 = state_14977__$1;
(statearr_14982_15003[(1)] = (5));

} else {
var statearr_14983_15004 = state_14977__$1;
(statearr_14983_15004[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (13))){
var state_14977__$1 = state_14977;
var statearr_14984_15005 = state_14977__$1;
(statearr_14984_15005[(2)] = null);

(statearr_14984_15005[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (6))){
var inst_14956 = (state_14977[(7)]);
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14977__$1,(11),to,inst_14956);
} else {
if((state_val_14978 === (3))){
var inst_14975 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14977__$1,inst_14975);
} else {
if((state_val_14978 === (12))){
var state_14977__$1 = state_14977;
var statearr_14985_15006 = state_14977__$1;
(statearr_14985_15006[(2)] = null);

(statearr_14985_15006[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (2))){
var state_14977__$1 = state_14977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14977__$1,(4),from);
} else {
if((state_val_14978 === (11))){
var inst_14966 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
if(cljs.core.truth_(inst_14966)){
var statearr_14986_15007 = state_14977__$1;
(statearr_14986_15007[(1)] = (12));

} else {
var statearr_14987_15008 = state_14977__$1;
(statearr_14987_15008[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (9))){
var state_14977__$1 = state_14977;
var statearr_14988_15009 = state_14977__$1;
(statearr_14988_15009[(2)] = null);

(statearr_14988_15009[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (5))){
var state_14977__$1 = state_14977;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14989_15010 = state_14977__$1;
(statearr_14989_15010[(1)] = (8));

} else {
var statearr_14990_15011 = state_14977__$1;
(statearr_14990_15011[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (14))){
var inst_14971 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
var statearr_14991_15012 = state_14977__$1;
(statearr_14991_15012[(2)] = inst_14971);

(statearr_14991_15012[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (10))){
var inst_14963 = (state_14977[(2)]);
var state_14977__$1 = state_14977;
var statearr_14992_15013 = state_14977__$1;
(statearr_14992_15013[(2)] = inst_14963);

(statearr_14992_15013[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14978 === (8))){
var inst_14960 = cljs.core.async.close_BANG_(to);
var state_14977__$1 = state_14977;
var statearr_14993_15014 = state_14977__$1;
(statearr_14993_15014[(2)] = inst_14960);

(statearr_14993_15014[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_14994 = [null,null,null,null,null,null,null,null];
(statearr_14994[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_14994[(1)] = (1));

return statearr_14994;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_14977){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_14977);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e14995){var ex__14781__auto__ = e14995;
var statearr_14996_15015 = state_14977;
(statearr_14996_15015[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_14977[(4)]))){
var statearr_14997_15016 = state_14977;
(statearr_14997_15016[(1)] = cljs.core.first((state_14977[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15017 = state_14977;
state_14977 = G__15017;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_14977){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_14977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_14998 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_14998[(6)] = c__14852__auto___15000);

return statearr_14998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__15018){
var vec__15019 = p__15018;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15019,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15019,(1),null);
var job = vec__15019;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__14852__auto___15195 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15026){
var state_val_15027 = (state_15026[(1)]);
if((state_val_15027 === (1))){
var state_15026__$1 = state_15026;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15026__$1,(2),res,v);
} else {
if((state_val_15027 === (2))){
var inst_15023 = (state_15026[(2)]);
var inst_15024 = cljs.core.async.close_BANG_(res);
var state_15026__$1 = (function (){var statearr_15028 = state_15026;
(statearr_15028[(7)] = inst_15023);

return statearr_15028;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15026__$1,inst_15024);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0 = (function (){
var statearr_15029 = [null,null,null,null,null,null,null,null];
(statearr_15029[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__);

(statearr_15029[(1)] = (1));

return statearr_15029;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1 = (function (state_15026){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15026);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15030){var ex__14781__auto__ = e15030;
var statearr_15031_15196 = state_15026;
(statearr_15031_15196[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15026[(4)]))){
var statearr_15032_15197 = state_15026;
(statearr_15032_15197[(1)] = cljs.core.first((state_15026[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15198 = state_15026;
state_15026 = G__15198;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = function(state_15026){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1.call(this,state_15026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15033 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15033[(6)] = c__14852__auto___15195);

return statearr_15033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__15034){
var vec__15035 = p__15034;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15035,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15035,(1),null);
var job = vec__15035;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4706__auto___15199 = n;
var __15200 = (0);
while(true){
if((__15200 < n__4706__auto___15199)){
var G__15038_15201 = type;
var G__15038_15202__$1 = (((G__15038_15201 instanceof cljs.core.Keyword))?G__15038_15201.fqn:null);
switch (G__15038_15202__$1) {
case "compute":
var c__14852__auto___15204 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15200,c__14852__auto___15204,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async){
return (function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = ((function (__15200,c__14852__auto___15204,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async){
return (function (state_15051){
var state_val_15052 = (state_15051[(1)]);
if((state_val_15052 === (1))){
var state_15051__$1 = state_15051;
var statearr_15053_15205 = state_15051__$1;
(statearr_15053_15205[(2)] = null);

(statearr_15053_15205[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15052 === (2))){
var state_15051__$1 = state_15051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15051__$1,(4),jobs);
} else {
if((state_val_15052 === (3))){
var inst_15049 = (state_15051[(2)]);
var state_15051__$1 = state_15051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15051__$1,inst_15049);
} else {
if((state_val_15052 === (4))){
var inst_15041 = (state_15051[(2)]);
var inst_15042 = process(inst_15041);
var state_15051__$1 = state_15051;
if(cljs.core.truth_(inst_15042)){
var statearr_15054_15206 = state_15051__$1;
(statearr_15054_15206[(1)] = (5));

} else {
var statearr_15055_15207 = state_15051__$1;
(statearr_15055_15207[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15052 === (5))){
var state_15051__$1 = state_15051;
var statearr_15056_15208 = state_15051__$1;
(statearr_15056_15208[(2)] = null);

(statearr_15056_15208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15052 === (6))){
var state_15051__$1 = state_15051;
var statearr_15057_15209 = state_15051__$1;
(statearr_15057_15209[(2)] = null);

(statearr_15057_15209[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15052 === (7))){
var inst_15047 = (state_15051[(2)]);
var state_15051__$1 = state_15051;
var statearr_15058_15210 = state_15051__$1;
(statearr_15058_15210[(2)] = inst_15047);

(statearr_15058_15210[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15200,c__14852__auto___15204,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async))
;
return ((function (__15200,switch__14777__auto__,c__14852__auto___15204,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0 = (function (){
var statearr_15059 = [null,null,null,null,null,null,null];
(statearr_15059[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__);

(statearr_15059[(1)] = (1));

return statearr_15059;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1 = (function (state_15051){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15051);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15060){var ex__14781__auto__ = e15060;
var statearr_15061_15211 = state_15051;
(statearr_15061_15211[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15051[(4)]))){
var statearr_15062_15212 = state_15051;
(statearr_15062_15212[(1)] = cljs.core.first((state_15051[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15213 = state_15051;
state_15051 = G__15213;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = function(state_15051){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1.call(this,state_15051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__;
})()
;})(__15200,switch__14777__auto__,c__14852__auto___15204,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async))
})();
var state__14854__auto__ = (function (){var statearr_15063 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15063[(6)] = c__14852__auto___15204);

return statearr_15063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
});})(__15200,c__14852__auto___15204,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async))
);


break;
case "async":
var c__14852__auto___15214 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15200,c__14852__auto___15214,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async){
return (function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = ((function (__15200,c__14852__auto___15214,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async){
return (function (state_15076){
var state_val_15077 = (state_15076[(1)]);
if((state_val_15077 === (1))){
var state_15076__$1 = state_15076;
var statearr_15078_15215 = state_15076__$1;
(statearr_15078_15215[(2)] = null);

(statearr_15078_15215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15077 === (2))){
var state_15076__$1 = state_15076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15076__$1,(4),jobs);
} else {
if((state_val_15077 === (3))){
var inst_15074 = (state_15076[(2)]);
var state_15076__$1 = state_15076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15076__$1,inst_15074);
} else {
if((state_val_15077 === (4))){
var inst_15066 = (state_15076[(2)]);
var inst_15067 = async(inst_15066);
var state_15076__$1 = state_15076;
if(cljs.core.truth_(inst_15067)){
var statearr_15079_15216 = state_15076__$1;
(statearr_15079_15216[(1)] = (5));

} else {
var statearr_15080_15217 = state_15076__$1;
(statearr_15080_15217[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15077 === (5))){
var state_15076__$1 = state_15076;
var statearr_15081_15218 = state_15076__$1;
(statearr_15081_15218[(2)] = null);

(statearr_15081_15218[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15077 === (6))){
var state_15076__$1 = state_15076;
var statearr_15082_15219 = state_15076__$1;
(statearr_15082_15219[(2)] = null);

(statearr_15082_15219[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15077 === (7))){
var inst_15072 = (state_15076[(2)]);
var state_15076__$1 = state_15076;
var statearr_15083_15220 = state_15076__$1;
(statearr_15083_15220[(2)] = inst_15072);

(statearr_15083_15220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15200,c__14852__auto___15214,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async))
;
return ((function (__15200,switch__14777__auto__,c__14852__auto___15214,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0 = (function (){
var statearr_15084 = [null,null,null,null,null,null,null];
(statearr_15084[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__);

(statearr_15084[(1)] = (1));

return statearr_15084;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1 = (function (state_15076){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15076);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15085){var ex__14781__auto__ = e15085;
var statearr_15086_15221 = state_15076;
(statearr_15086_15221[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15076[(4)]))){
var statearr_15087_15222 = state_15076;
(statearr_15087_15222[(1)] = cljs.core.first((state_15076[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15223 = state_15076;
state_15076 = G__15223;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = function(state_15076){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1.call(this,state_15076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__;
})()
;})(__15200,switch__14777__auto__,c__14852__auto___15214,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async))
})();
var state__14854__auto__ = (function (){var statearr_15088 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15088[(6)] = c__14852__auto___15214);

return statearr_15088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
});})(__15200,c__14852__auto___15214,G__15038_15201,G__15038_15202__$1,n__4706__auto___15199,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__15038_15202__$1)].join('')));

}

var G__15224 = (__15200 + (1));
__15200 = G__15224;
continue;
} else {
}
break;
}

var c__14852__auto___15225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15110){
var state_val_15111 = (state_15110[(1)]);
if((state_val_15111 === (7))){
var inst_15106 = (state_15110[(2)]);
var state_15110__$1 = state_15110;
var statearr_15112_15226 = state_15110__$1;
(statearr_15112_15226[(2)] = inst_15106);

(statearr_15112_15226[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15111 === (1))){
var state_15110__$1 = state_15110;
var statearr_15113_15227 = state_15110__$1;
(statearr_15113_15227[(2)] = null);

(statearr_15113_15227[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15111 === (4))){
var inst_15091 = (state_15110[(7)]);
var inst_15091__$1 = (state_15110[(2)]);
var inst_15092 = (inst_15091__$1 == null);
var state_15110__$1 = (function (){var statearr_15114 = state_15110;
(statearr_15114[(7)] = inst_15091__$1);

return statearr_15114;
})();
if(cljs.core.truth_(inst_15092)){
var statearr_15115_15228 = state_15110__$1;
(statearr_15115_15228[(1)] = (5));

} else {
var statearr_15116_15229 = state_15110__$1;
(statearr_15116_15229[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15111 === (6))){
var inst_15096 = (state_15110[(8)]);
var inst_15091 = (state_15110[(7)]);
var inst_15096__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15098 = [inst_15091,inst_15096__$1];
var inst_15099 = (new cljs.core.PersistentVector(null,2,(5),inst_15097,inst_15098,null));
var state_15110__$1 = (function (){var statearr_15117 = state_15110;
(statearr_15117[(8)] = inst_15096__$1);

return statearr_15117;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15110__$1,(8),jobs,inst_15099);
} else {
if((state_val_15111 === (3))){
var inst_15108 = (state_15110[(2)]);
var state_15110__$1 = state_15110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15110__$1,inst_15108);
} else {
if((state_val_15111 === (2))){
var state_15110__$1 = state_15110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15110__$1,(4),from);
} else {
if((state_val_15111 === (9))){
var inst_15103 = (state_15110[(2)]);
var state_15110__$1 = (function (){var statearr_15118 = state_15110;
(statearr_15118[(9)] = inst_15103);

return statearr_15118;
})();
var statearr_15119_15230 = state_15110__$1;
(statearr_15119_15230[(2)] = null);

(statearr_15119_15230[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15111 === (5))){
var inst_15094 = cljs.core.async.close_BANG_(jobs);
var state_15110__$1 = state_15110;
var statearr_15120_15231 = state_15110__$1;
(statearr_15120_15231[(2)] = inst_15094);

(statearr_15120_15231[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15111 === (8))){
var inst_15096 = (state_15110[(8)]);
var inst_15101 = (state_15110[(2)]);
var state_15110__$1 = (function (){var statearr_15121 = state_15110;
(statearr_15121[(10)] = inst_15101);

return statearr_15121;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15110__$1,(9),results,inst_15096);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0 = (function (){
var statearr_15122 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15122[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__);

(statearr_15122[(1)] = (1));

return statearr_15122;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1 = (function (state_15110){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15110);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15123){var ex__14781__auto__ = e15123;
var statearr_15124_15232 = state_15110;
(statearr_15124_15232[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15110[(4)]))){
var statearr_15125_15233 = state_15110;
(statearr_15125_15233[(1)] = cljs.core.first((state_15110[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15234 = state_15110;
state_15110 = G__15234;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = function(state_15110){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1.call(this,state_15110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15126 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15126[(6)] = c__14852__auto___15225);

return statearr_15126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15164){
var state_val_15165 = (state_15164[(1)]);
if((state_val_15165 === (7))){
var inst_15160 = (state_15164[(2)]);
var state_15164__$1 = state_15164;
var statearr_15166_15235 = state_15164__$1;
(statearr_15166_15235[(2)] = inst_15160);

(statearr_15166_15235[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (20))){
var state_15164__$1 = state_15164;
var statearr_15167_15236 = state_15164__$1;
(statearr_15167_15236[(2)] = null);

(statearr_15167_15236[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (1))){
var state_15164__$1 = state_15164;
var statearr_15168_15237 = state_15164__$1;
(statearr_15168_15237[(2)] = null);

(statearr_15168_15237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (4))){
var inst_15129 = (state_15164[(7)]);
var inst_15129__$1 = (state_15164[(2)]);
var inst_15130 = (inst_15129__$1 == null);
var state_15164__$1 = (function (){var statearr_15169 = state_15164;
(statearr_15169[(7)] = inst_15129__$1);

return statearr_15169;
})();
if(cljs.core.truth_(inst_15130)){
var statearr_15170_15238 = state_15164__$1;
(statearr_15170_15238[(1)] = (5));

} else {
var statearr_15171_15239 = state_15164__$1;
(statearr_15171_15239[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (15))){
var inst_15142 = (state_15164[(8)]);
var state_15164__$1 = state_15164;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15164__$1,(18),to,inst_15142);
} else {
if((state_val_15165 === (21))){
var inst_15155 = (state_15164[(2)]);
var state_15164__$1 = state_15164;
var statearr_15172_15240 = state_15164__$1;
(statearr_15172_15240[(2)] = inst_15155);

(statearr_15172_15240[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (13))){
var inst_15157 = (state_15164[(2)]);
var state_15164__$1 = (function (){var statearr_15173 = state_15164;
(statearr_15173[(9)] = inst_15157);

return statearr_15173;
})();
var statearr_15174_15241 = state_15164__$1;
(statearr_15174_15241[(2)] = null);

(statearr_15174_15241[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (6))){
var inst_15129 = (state_15164[(7)]);
var state_15164__$1 = state_15164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15164__$1,(11),inst_15129);
} else {
if((state_val_15165 === (17))){
var inst_15150 = (state_15164[(2)]);
var state_15164__$1 = state_15164;
if(cljs.core.truth_(inst_15150)){
var statearr_15175_15242 = state_15164__$1;
(statearr_15175_15242[(1)] = (19));

} else {
var statearr_15176_15243 = state_15164__$1;
(statearr_15176_15243[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (3))){
var inst_15162 = (state_15164[(2)]);
var state_15164__$1 = state_15164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15164__$1,inst_15162);
} else {
if((state_val_15165 === (12))){
var inst_15139 = (state_15164[(10)]);
var state_15164__$1 = state_15164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15164__$1,(14),inst_15139);
} else {
if((state_val_15165 === (2))){
var state_15164__$1 = state_15164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15164__$1,(4),results);
} else {
if((state_val_15165 === (19))){
var state_15164__$1 = state_15164;
var statearr_15177_15244 = state_15164__$1;
(statearr_15177_15244[(2)] = null);

(statearr_15177_15244[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (11))){
var inst_15139 = (state_15164[(2)]);
var state_15164__$1 = (function (){var statearr_15178 = state_15164;
(statearr_15178[(10)] = inst_15139);

return statearr_15178;
})();
var statearr_15179_15245 = state_15164__$1;
(statearr_15179_15245[(2)] = null);

(statearr_15179_15245[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (9))){
var state_15164__$1 = state_15164;
var statearr_15180_15246 = state_15164__$1;
(statearr_15180_15246[(2)] = null);

(statearr_15180_15246[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (5))){
var state_15164__$1 = state_15164;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15181_15247 = state_15164__$1;
(statearr_15181_15247[(1)] = (8));

} else {
var statearr_15182_15248 = state_15164__$1;
(statearr_15182_15248[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (14))){
var inst_15142 = (state_15164[(8)]);
var inst_15144 = (state_15164[(11)]);
var inst_15142__$1 = (state_15164[(2)]);
var inst_15143 = (inst_15142__$1 == null);
var inst_15144__$1 = cljs.core.not(inst_15143);
var state_15164__$1 = (function (){var statearr_15183 = state_15164;
(statearr_15183[(8)] = inst_15142__$1);

(statearr_15183[(11)] = inst_15144__$1);

return statearr_15183;
})();
if(inst_15144__$1){
var statearr_15184_15249 = state_15164__$1;
(statearr_15184_15249[(1)] = (15));

} else {
var statearr_15185_15250 = state_15164__$1;
(statearr_15185_15250[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (16))){
var inst_15144 = (state_15164[(11)]);
var state_15164__$1 = state_15164;
var statearr_15186_15251 = state_15164__$1;
(statearr_15186_15251[(2)] = inst_15144);

(statearr_15186_15251[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (10))){
var inst_15136 = (state_15164[(2)]);
var state_15164__$1 = state_15164;
var statearr_15187_15252 = state_15164__$1;
(statearr_15187_15252[(2)] = inst_15136);

(statearr_15187_15252[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (18))){
var inst_15147 = (state_15164[(2)]);
var state_15164__$1 = state_15164;
var statearr_15188_15253 = state_15164__$1;
(statearr_15188_15253[(2)] = inst_15147);

(statearr_15188_15253[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15165 === (8))){
var inst_15133 = cljs.core.async.close_BANG_(to);
var state_15164__$1 = state_15164;
var statearr_15189_15254 = state_15164__$1;
(statearr_15189_15254[(2)] = inst_15133);

(statearr_15189_15254[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0 = (function (){
var statearr_15190 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15190[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__);

(statearr_15190[(1)] = (1));

return statearr_15190;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1 = (function (state_15164){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15164);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15191){var ex__14781__auto__ = e15191;
var statearr_15192_15255 = state_15164;
(statearr_15192_15255[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15164[(4)]))){
var statearr_15193_15256 = state_15164;
(statearr_15193_15256[(1)] = cljs.core.first((state_15164[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15257 = state_15164;
state_15164 = G__15257;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__ = function(state_15164){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1.call(this,state_15164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14778__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15194 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15194[(6)] = c__14852__auto__);

return statearr_15194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__15259 = arguments.length;
switch (G__15259) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__15262 = arguments.length;
switch (G__15262) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__15265 = arguments.length;
switch (G__15265) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__14852__auto___15315 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15291){
var state_val_15292 = (state_15291[(1)]);
if((state_val_15292 === (7))){
var inst_15287 = (state_15291[(2)]);
var state_15291__$1 = state_15291;
var statearr_15293_15316 = state_15291__$1;
(statearr_15293_15316[(2)] = inst_15287);

(statearr_15293_15316[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (1))){
var state_15291__$1 = state_15291;
var statearr_15294_15317 = state_15291__$1;
(statearr_15294_15317[(2)] = null);

(statearr_15294_15317[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (4))){
var inst_15268 = (state_15291[(7)]);
var inst_15268__$1 = (state_15291[(2)]);
var inst_15269 = (inst_15268__$1 == null);
var state_15291__$1 = (function (){var statearr_15295 = state_15291;
(statearr_15295[(7)] = inst_15268__$1);

return statearr_15295;
})();
if(cljs.core.truth_(inst_15269)){
var statearr_15296_15318 = state_15291__$1;
(statearr_15296_15318[(1)] = (5));

} else {
var statearr_15297_15319 = state_15291__$1;
(statearr_15297_15319[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (13))){
var state_15291__$1 = state_15291;
var statearr_15298_15320 = state_15291__$1;
(statearr_15298_15320[(2)] = null);

(statearr_15298_15320[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (6))){
var inst_15268 = (state_15291[(7)]);
var inst_15274 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15268) : p.call(null,inst_15268));
var state_15291__$1 = state_15291;
if(cljs.core.truth_(inst_15274)){
var statearr_15299_15321 = state_15291__$1;
(statearr_15299_15321[(1)] = (9));

} else {
var statearr_15300_15322 = state_15291__$1;
(statearr_15300_15322[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (3))){
var inst_15289 = (state_15291[(2)]);
var state_15291__$1 = state_15291;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15291__$1,inst_15289);
} else {
if((state_val_15292 === (12))){
var state_15291__$1 = state_15291;
var statearr_15301_15323 = state_15291__$1;
(statearr_15301_15323[(2)] = null);

(statearr_15301_15323[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (2))){
var state_15291__$1 = state_15291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15291__$1,(4),ch);
} else {
if((state_val_15292 === (11))){
var inst_15268 = (state_15291[(7)]);
var inst_15278 = (state_15291[(2)]);
var state_15291__$1 = state_15291;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15291__$1,(8),inst_15278,inst_15268);
} else {
if((state_val_15292 === (9))){
var state_15291__$1 = state_15291;
var statearr_15302_15324 = state_15291__$1;
(statearr_15302_15324[(2)] = tc);

(statearr_15302_15324[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (5))){
var inst_15271 = cljs.core.async.close_BANG_(tc);
var inst_15272 = cljs.core.async.close_BANG_(fc);
var state_15291__$1 = (function (){var statearr_15303 = state_15291;
(statearr_15303[(8)] = inst_15271);

return statearr_15303;
})();
var statearr_15304_15325 = state_15291__$1;
(statearr_15304_15325[(2)] = inst_15272);

(statearr_15304_15325[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (14))){
var inst_15285 = (state_15291[(2)]);
var state_15291__$1 = state_15291;
var statearr_15305_15326 = state_15291__$1;
(statearr_15305_15326[(2)] = inst_15285);

(statearr_15305_15326[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (10))){
var state_15291__$1 = state_15291;
var statearr_15306_15327 = state_15291__$1;
(statearr_15306_15327[(2)] = fc);

(statearr_15306_15327[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15292 === (8))){
var inst_15280 = (state_15291[(2)]);
var state_15291__$1 = state_15291;
if(cljs.core.truth_(inst_15280)){
var statearr_15307_15328 = state_15291__$1;
(statearr_15307_15328[(1)] = (12));

} else {
var statearr_15308_15329 = state_15291__$1;
(statearr_15308_15329[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_15309 = [null,null,null,null,null,null,null,null,null];
(statearr_15309[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_15309[(1)] = (1));

return statearr_15309;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_15291){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15291);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15310){var ex__14781__auto__ = e15310;
var statearr_15311_15330 = state_15291;
(statearr_15311_15330[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15291[(4)]))){
var statearr_15312_15331 = state_15291;
(statearr_15312_15331[(1)] = cljs.core.first((state_15291[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15332 = state_15291;
state_15291 = G__15332;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_15291){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_15291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15313 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15313[(6)] = c__14852__auto___15315);

return statearr_15313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15354){
var state_val_15355 = (state_15354[(1)]);
if((state_val_15355 === (7))){
var inst_15350 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
var statearr_15356_15375 = state_15354__$1;
(statearr_15356_15375[(2)] = inst_15350);

(statearr_15356_15375[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15355 === (1))){
var inst_15333 = init;
var inst_15334 = inst_15333;
var state_15354__$1 = (function (){var statearr_15357 = state_15354;
(statearr_15357[(7)] = inst_15334);

return statearr_15357;
})();
var statearr_15358_15376 = state_15354__$1;
(statearr_15358_15376[(2)] = null);

(statearr_15358_15376[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15355 === (4))){
var inst_15337 = (state_15354[(8)]);
var inst_15337__$1 = (state_15354[(2)]);
var inst_15338 = (inst_15337__$1 == null);
var state_15354__$1 = (function (){var statearr_15359 = state_15354;
(statearr_15359[(8)] = inst_15337__$1);

return statearr_15359;
})();
if(cljs.core.truth_(inst_15338)){
var statearr_15360_15377 = state_15354__$1;
(statearr_15360_15377[(1)] = (5));

} else {
var statearr_15361_15378 = state_15354__$1;
(statearr_15361_15378[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15355 === (6))){
var inst_15341 = (state_15354[(9)]);
var inst_15334 = (state_15354[(7)]);
var inst_15337 = (state_15354[(8)]);
var inst_15341__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15334,inst_15337) : f.call(null,inst_15334,inst_15337));
var inst_15342 = cljs.core.reduced_QMARK_(inst_15341__$1);
var state_15354__$1 = (function (){var statearr_15362 = state_15354;
(statearr_15362[(9)] = inst_15341__$1);

return statearr_15362;
})();
if(inst_15342){
var statearr_15363_15379 = state_15354__$1;
(statearr_15363_15379[(1)] = (8));

} else {
var statearr_15364_15380 = state_15354__$1;
(statearr_15364_15380[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15355 === (3))){
var inst_15352 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15354__$1,inst_15352);
} else {
if((state_val_15355 === (2))){
var state_15354__$1 = state_15354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15354__$1,(4),ch);
} else {
if((state_val_15355 === (9))){
var inst_15341 = (state_15354[(9)]);
var inst_15334 = inst_15341;
var state_15354__$1 = (function (){var statearr_15365 = state_15354;
(statearr_15365[(7)] = inst_15334);

return statearr_15365;
})();
var statearr_15366_15381 = state_15354__$1;
(statearr_15366_15381[(2)] = null);

(statearr_15366_15381[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15355 === (5))){
var inst_15334 = (state_15354[(7)]);
var state_15354__$1 = state_15354;
var statearr_15367_15382 = state_15354__$1;
(statearr_15367_15382[(2)] = inst_15334);

(statearr_15367_15382[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15355 === (10))){
var inst_15348 = (state_15354[(2)]);
var state_15354__$1 = state_15354;
var statearr_15368_15383 = state_15354__$1;
(statearr_15368_15383[(2)] = inst_15348);

(statearr_15368_15383[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15355 === (8))){
var inst_15341 = (state_15354[(9)]);
var inst_15344 = cljs.core.deref(inst_15341);
var state_15354__$1 = state_15354;
var statearr_15369_15384 = state_15354__$1;
(statearr_15369_15384[(2)] = inst_15344);

(statearr_15369_15384[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__14778__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14778__auto____0 = (function (){
var statearr_15370 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15370[(0)] = cljs$core$async$reduce_$_state_machine__14778__auto__);

(statearr_15370[(1)] = (1));

return statearr_15370;
});
var cljs$core$async$reduce_$_state_machine__14778__auto____1 = (function (state_15354){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15354);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15371){var ex__14781__auto__ = e15371;
var statearr_15372_15385 = state_15354;
(statearr_15372_15385[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15354[(4)]))){
var statearr_15373_15386 = state_15354;
(statearr_15373_15386[(1)] = cljs.core.first((state_15354[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15387 = state_15354;
state_15354 = G__15387;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14778__auto__ = function(state_15354){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14778__auto____1.call(this,state_15354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14778__auto____0;
cljs$core$async$reduce_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14778__auto____1;
return cljs$core$async$reduce_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15374 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15374[(6)] = c__14852__auto__);

return statearr_15374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15393){
var state_val_15394 = (state_15393[(1)]);
if((state_val_15394 === (1))){
var inst_15388 = cljs.core.async.reduce(f__$1,init,ch);
var state_15393__$1 = state_15393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15393__$1,(2),inst_15388);
} else {
if((state_val_15394 === (2))){
var inst_15390 = (state_15393[(2)]);
var inst_15391 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_15390) : f__$1.call(null,inst_15390));
var state_15393__$1 = state_15393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15393__$1,inst_15391);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__14778__auto__ = null;
var cljs$core$async$transduce_$_state_machine__14778__auto____0 = (function (){
var statearr_15395 = [null,null,null,null,null,null,null];
(statearr_15395[(0)] = cljs$core$async$transduce_$_state_machine__14778__auto__);

(statearr_15395[(1)] = (1));

return statearr_15395;
});
var cljs$core$async$transduce_$_state_machine__14778__auto____1 = (function (state_15393){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15393);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15396){var ex__14781__auto__ = e15396;
var statearr_15397_15400 = state_15393;
(statearr_15397_15400[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15393[(4)]))){
var statearr_15398_15401 = state_15393;
(statearr_15398_15401[(1)] = cljs.core.first((state_15393[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15402 = state_15393;
state_15393 = G__15402;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__14778__auto__ = function(state_15393){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__14778__auto____1.call(this,state_15393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__14778__auto____0;
cljs$core$async$transduce_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__14778__auto____1;
return cljs$core$async$transduce_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15399 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15399[(6)] = c__14852__auto__);

return statearr_15399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__15404 = arguments.length;
switch (G__15404) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15429){
var state_val_15430 = (state_15429[(1)]);
if((state_val_15430 === (7))){
var inst_15411 = (state_15429[(2)]);
var state_15429__$1 = state_15429;
var statearr_15431_15453 = state_15429__$1;
(statearr_15431_15453[(2)] = inst_15411);

(statearr_15431_15453[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (1))){
var inst_15405 = cljs.core.seq(coll);
var inst_15406 = inst_15405;
var state_15429__$1 = (function (){var statearr_15432 = state_15429;
(statearr_15432[(7)] = inst_15406);

return statearr_15432;
})();
var statearr_15433_15454 = state_15429__$1;
(statearr_15433_15454[(2)] = null);

(statearr_15433_15454[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (4))){
var inst_15406 = (state_15429[(7)]);
var inst_15409 = cljs.core.first(inst_15406);
var state_15429__$1 = state_15429;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15429__$1,(7),ch,inst_15409);
} else {
if((state_val_15430 === (13))){
var inst_15423 = (state_15429[(2)]);
var state_15429__$1 = state_15429;
var statearr_15434_15455 = state_15429__$1;
(statearr_15434_15455[(2)] = inst_15423);

(statearr_15434_15455[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (6))){
var inst_15414 = (state_15429[(2)]);
var state_15429__$1 = state_15429;
if(cljs.core.truth_(inst_15414)){
var statearr_15435_15456 = state_15429__$1;
(statearr_15435_15456[(1)] = (8));

} else {
var statearr_15436_15457 = state_15429__$1;
(statearr_15436_15457[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (3))){
var inst_15427 = (state_15429[(2)]);
var state_15429__$1 = state_15429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15429__$1,inst_15427);
} else {
if((state_val_15430 === (12))){
var state_15429__$1 = state_15429;
var statearr_15437_15458 = state_15429__$1;
(statearr_15437_15458[(2)] = null);

(statearr_15437_15458[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (2))){
var inst_15406 = (state_15429[(7)]);
var state_15429__$1 = state_15429;
if(cljs.core.truth_(inst_15406)){
var statearr_15438_15459 = state_15429__$1;
(statearr_15438_15459[(1)] = (4));

} else {
var statearr_15439_15460 = state_15429__$1;
(statearr_15439_15460[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (11))){
var inst_15420 = cljs.core.async.close_BANG_(ch);
var state_15429__$1 = state_15429;
var statearr_15440_15461 = state_15429__$1;
(statearr_15440_15461[(2)] = inst_15420);

(statearr_15440_15461[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (9))){
var state_15429__$1 = state_15429;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15441_15462 = state_15429__$1;
(statearr_15441_15462[(1)] = (11));

} else {
var statearr_15442_15463 = state_15429__$1;
(statearr_15442_15463[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (5))){
var inst_15406 = (state_15429[(7)]);
var state_15429__$1 = state_15429;
var statearr_15443_15464 = state_15429__$1;
(statearr_15443_15464[(2)] = inst_15406);

(statearr_15443_15464[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (10))){
var inst_15425 = (state_15429[(2)]);
var state_15429__$1 = state_15429;
var statearr_15444_15465 = state_15429__$1;
(statearr_15444_15465[(2)] = inst_15425);

(statearr_15444_15465[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15430 === (8))){
var inst_15406 = (state_15429[(7)]);
var inst_15416 = cljs.core.next(inst_15406);
var inst_15406__$1 = inst_15416;
var state_15429__$1 = (function (){var statearr_15445 = state_15429;
(statearr_15445[(7)] = inst_15406__$1);

return statearr_15445;
})();
var statearr_15446_15466 = state_15429__$1;
(statearr_15446_15466[(2)] = null);

(statearr_15446_15466[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_15447 = [null,null,null,null,null,null,null,null];
(statearr_15447[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_15447[(1)] = (1));

return statearr_15447;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_15429){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15429);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15448){var ex__14781__auto__ = e15448;
var statearr_15449_15467 = state_15429;
(statearr_15449_15467[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15429[(4)]))){
var statearr_15450_15468 = state_15429;
(statearr_15450_15468[(1)] = cljs.core.first((state_15429[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15469 = state_15429;
state_15429 = G__15469;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_15429){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_15429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15451 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15451[(6)] = c__14852__auto__);

return statearr_15451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__15471 = arguments.length;
switch (G__15471) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_15473 = (function (_){
var x__4521__auto__ = (((_ == null))?null:_);
var m__4522__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4522__auto__.call(null,_));
} else {
var m__4519__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4519__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_15473(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_15474 = (function (m,ch,close_QMARK_){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4522__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4519__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_15474(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_15475 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_15475(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_15476 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_15476(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15477 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15477 = (function (ch,cs,meta15478){
this.ch = ch;
this.cs = cs;
this.meta15478 = meta15478;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15479,meta15478__$1){
var self__ = this;
var _15479__$1 = this;
return (new cljs.core.async.t_cljs$core$async15477(self__.ch,self__.cs,meta15478__$1));
}));

(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15479){
var self__ = this;
var _15479__$1 = this;
return self__.meta15478;
}));

(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async15477.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async15477.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta15478], null);
}));

(cljs.core.async.t_cljs$core$async15477.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15477.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15477");

(cljs.core.async.t_cljs$core$async15477.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async15477");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15477.
 */
cljs.core.async.__GT_t_cljs$core$async15477 = (function cljs$core$async$mult_$___GT_t_cljs$core$async15477(ch__$1,cs__$1,meta15478){
return (new cljs.core.async.t_cljs$core$async15477(ch__$1,cs__$1,meta15478));
});

}

return (new cljs.core.async.t_cljs$core$async15477(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__14852__auto___15696 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15612){
var state_val_15613 = (state_15612[(1)]);
if((state_val_15613 === (7))){
var inst_15608 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15614_15697 = state_15612__$1;
(statearr_15614_15697[(2)] = inst_15608);

(statearr_15614_15697[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (20))){
var inst_15513 = (state_15612[(7)]);
var inst_15525 = cljs.core.first(inst_15513);
var inst_15526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15525,(0),null);
var inst_15527 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15525,(1),null);
var state_15612__$1 = (function (){var statearr_15615 = state_15612;
(statearr_15615[(8)] = inst_15526);

return statearr_15615;
})();
if(cljs.core.truth_(inst_15527)){
var statearr_15616_15698 = state_15612__$1;
(statearr_15616_15698[(1)] = (22));

} else {
var statearr_15617_15699 = state_15612__$1;
(statearr_15617_15699[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (27))){
var inst_15555 = (state_15612[(9)]);
var inst_15557 = (state_15612[(10)]);
var inst_15562 = (state_15612[(11)]);
var inst_15482 = (state_15612[(12)]);
var inst_15562__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15555,inst_15557);
var inst_15563 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15562__$1,inst_15482,done);
var state_15612__$1 = (function (){var statearr_15618 = state_15612;
(statearr_15618[(11)] = inst_15562__$1);

return statearr_15618;
})();
if(cljs.core.truth_(inst_15563)){
var statearr_15619_15700 = state_15612__$1;
(statearr_15619_15700[(1)] = (30));

} else {
var statearr_15620_15701 = state_15612__$1;
(statearr_15620_15701[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (1))){
var state_15612__$1 = state_15612;
var statearr_15621_15702 = state_15612__$1;
(statearr_15621_15702[(2)] = null);

(statearr_15621_15702[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (24))){
var inst_15513 = (state_15612[(7)]);
var inst_15532 = (state_15612[(2)]);
var inst_15533 = cljs.core.next(inst_15513);
var inst_15491 = inst_15533;
var inst_15492 = null;
var inst_15493 = (0);
var inst_15494 = (0);
var state_15612__$1 = (function (){var statearr_15622 = state_15612;
(statearr_15622[(13)] = inst_15532);

(statearr_15622[(14)] = inst_15491);

(statearr_15622[(15)] = inst_15493);

(statearr_15622[(16)] = inst_15494);

(statearr_15622[(17)] = inst_15492);

return statearr_15622;
})();
var statearr_15623_15703 = state_15612__$1;
(statearr_15623_15703[(2)] = null);

(statearr_15623_15703[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (39))){
var state_15612__$1 = state_15612;
var statearr_15627_15704 = state_15612__$1;
(statearr_15627_15704[(2)] = null);

(statearr_15627_15704[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (4))){
var inst_15482 = (state_15612[(12)]);
var inst_15482__$1 = (state_15612[(2)]);
var inst_15483 = (inst_15482__$1 == null);
var state_15612__$1 = (function (){var statearr_15628 = state_15612;
(statearr_15628[(12)] = inst_15482__$1);

return statearr_15628;
})();
if(cljs.core.truth_(inst_15483)){
var statearr_15629_15705 = state_15612__$1;
(statearr_15629_15705[(1)] = (5));

} else {
var statearr_15630_15706 = state_15612__$1;
(statearr_15630_15706[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (15))){
var inst_15491 = (state_15612[(14)]);
var inst_15493 = (state_15612[(15)]);
var inst_15494 = (state_15612[(16)]);
var inst_15492 = (state_15612[(17)]);
var inst_15509 = (state_15612[(2)]);
var inst_15510 = (inst_15494 + (1));
var tmp15624 = inst_15491;
var tmp15625 = inst_15493;
var tmp15626 = inst_15492;
var inst_15491__$1 = tmp15624;
var inst_15492__$1 = tmp15626;
var inst_15493__$1 = tmp15625;
var inst_15494__$1 = inst_15510;
var state_15612__$1 = (function (){var statearr_15631 = state_15612;
(statearr_15631[(18)] = inst_15509);

(statearr_15631[(14)] = inst_15491__$1);

(statearr_15631[(15)] = inst_15493__$1);

(statearr_15631[(16)] = inst_15494__$1);

(statearr_15631[(17)] = inst_15492__$1);

return statearr_15631;
})();
var statearr_15632_15707 = state_15612__$1;
(statearr_15632_15707[(2)] = null);

(statearr_15632_15707[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (21))){
var inst_15536 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15636_15708 = state_15612__$1;
(statearr_15636_15708[(2)] = inst_15536);

(statearr_15636_15708[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (31))){
var inst_15562 = (state_15612[(11)]);
var inst_15566 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15562);
var state_15612__$1 = state_15612;
var statearr_15637_15709 = state_15612__$1;
(statearr_15637_15709[(2)] = inst_15566);

(statearr_15637_15709[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (32))){
var inst_15556 = (state_15612[(19)]);
var inst_15554 = (state_15612[(20)]);
var inst_15555 = (state_15612[(9)]);
var inst_15557 = (state_15612[(10)]);
var inst_15568 = (state_15612[(2)]);
var inst_15569 = (inst_15557 + (1));
var tmp15633 = inst_15556;
var tmp15634 = inst_15554;
var tmp15635 = inst_15555;
var inst_15554__$1 = tmp15634;
var inst_15555__$1 = tmp15635;
var inst_15556__$1 = tmp15633;
var inst_15557__$1 = inst_15569;
var state_15612__$1 = (function (){var statearr_15638 = state_15612;
(statearr_15638[(21)] = inst_15568);

(statearr_15638[(19)] = inst_15556__$1);

(statearr_15638[(20)] = inst_15554__$1);

(statearr_15638[(9)] = inst_15555__$1);

(statearr_15638[(10)] = inst_15557__$1);

return statearr_15638;
})();
var statearr_15639_15710 = state_15612__$1;
(statearr_15639_15710[(2)] = null);

(statearr_15639_15710[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (40))){
var inst_15581 = (state_15612[(22)]);
var inst_15585 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_15581);
var state_15612__$1 = state_15612;
var statearr_15640_15711 = state_15612__$1;
(statearr_15640_15711[(2)] = inst_15585);

(statearr_15640_15711[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (33))){
var inst_15572 = (state_15612[(23)]);
var inst_15574 = cljs.core.chunked_seq_QMARK_(inst_15572);
var state_15612__$1 = state_15612;
if(inst_15574){
var statearr_15641_15712 = state_15612__$1;
(statearr_15641_15712[(1)] = (36));

} else {
var statearr_15642_15713 = state_15612__$1;
(statearr_15642_15713[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (13))){
var inst_15503 = (state_15612[(24)]);
var inst_15506 = cljs.core.async.close_BANG_(inst_15503);
var state_15612__$1 = state_15612;
var statearr_15643_15714 = state_15612__$1;
(statearr_15643_15714[(2)] = inst_15506);

(statearr_15643_15714[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (22))){
var inst_15526 = (state_15612[(8)]);
var inst_15529 = cljs.core.async.close_BANG_(inst_15526);
var state_15612__$1 = state_15612;
var statearr_15644_15715 = state_15612__$1;
(statearr_15644_15715[(2)] = inst_15529);

(statearr_15644_15715[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (36))){
var inst_15572 = (state_15612[(23)]);
var inst_15576 = cljs.core.chunk_first(inst_15572);
var inst_15577 = cljs.core.chunk_rest(inst_15572);
var inst_15578 = cljs.core.count(inst_15576);
var inst_15554 = inst_15577;
var inst_15555 = inst_15576;
var inst_15556 = inst_15578;
var inst_15557 = (0);
var state_15612__$1 = (function (){var statearr_15645 = state_15612;
(statearr_15645[(19)] = inst_15556);

(statearr_15645[(20)] = inst_15554);

(statearr_15645[(9)] = inst_15555);

(statearr_15645[(10)] = inst_15557);

return statearr_15645;
})();
var statearr_15646_15716 = state_15612__$1;
(statearr_15646_15716[(2)] = null);

(statearr_15646_15716[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (41))){
var inst_15572 = (state_15612[(23)]);
var inst_15587 = (state_15612[(2)]);
var inst_15588 = cljs.core.next(inst_15572);
var inst_15554 = inst_15588;
var inst_15555 = null;
var inst_15556 = (0);
var inst_15557 = (0);
var state_15612__$1 = (function (){var statearr_15647 = state_15612;
(statearr_15647[(19)] = inst_15556);

(statearr_15647[(25)] = inst_15587);

(statearr_15647[(20)] = inst_15554);

(statearr_15647[(9)] = inst_15555);

(statearr_15647[(10)] = inst_15557);

return statearr_15647;
})();
var statearr_15648_15717 = state_15612__$1;
(statearr_15648_15717[(2)] = null);

(statearr_15648_15717[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (43))){
var state_15612__$1 = state_15612;
var statearr_15649_15718 = state_15612__$1;
(statearr_15649_15718[(2)] = null);

(statearr_15649_15718[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (29))){
var inst_15596 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15650_15719 = state_15612__$1;
(statearr_15650_15719[(2)] = inst_15596);

(statearr_15650_15719[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (44))){
var inst_15605 = (state_15612[(2)]);
var state_15612__$1 = (function (){var statearr_15651 = state_15612;
(statearr_15651[(26)] = inst_15605);

return statearr_15651;
})();
var statearr_15652_15720 = state_15612__$1;
(statearr_15652_15720[(2)] = null);

(statearr_15652_15720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (6))){
var inst_15546 = (state_15612[(27)]);
var inst_15545 = cljs.core.deref(cs);
var inst_15546__$1 = cljs.core.keys(inst_15545);
var inst_15547 = cljs.core.count(inst_15546__$1);
var inst_15548 = cljs.core.reset_BANG_(dctr,inst_15547);
var inst_15553 = cljs.core.seq(inst_15546__$1);
var inst_15554 = inst_15553;
var inst_15555 = null;
var inst_15556 = (0);
var inst_15557 = (0);
var state_15612__$1 = (function (){var statearr_15653 = state_15612;
(statearr_15653[(27)] = inst_15546__$1);

(statearr_15653[(19)] = inst_15556);

(statearr_15653[(20)] = inst_15554);

(statearr_15653[(9)] = inst_15555);

(statearr_15653[(28)] = inst_15548);

(statearr_15653[(10)] = inst_15557);

return statearr_15653;
})();
var statearr_15654_15721 = state_15612__$1;
(statearr_15654_15721[(2)] = null);

(statearr_15654_15721[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (28))){
var inst_15572 = (state_15612[(23)]);
var inst_15554 = (state_15612[(20)]);
var inst_15572__$1 = cljs.core.seq(inst_15554);
var state_15612__$1 = (function (){var statearr_15655 = state_15612;
(statearr_15655[(23)] = inst_15572__$1);

return statearr_15655;
})();
if(inst_15572__$1){
var statearr_15656_15722 = state_15612__$1;
(statearr_15656_15722[(1)] = (33));

} else {
var statearr_15657_15723 = state_15612__$1;
(statearr_15657_15723[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (25))){
var inst_15556 = (state_15612[(19)]);
var inst_15557 = (state_15612[(10)]);
var inst_15559 = (inst_15557 < inst_15556);
var inst_15560 = inst_15559;
var state_15612__$1 = state_15612;
if(cljs.core.truth_(inst_15560)){
var statearr_15658_15724 = state_15612__$1;
(statearr_15658_15724[(1)] = (27));

} else {
var statearr_15659_15725 = state_15612__$1;
(statearr_15659_15725[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (34))){
var state_15612__$1 = state_15612;
var statearr_15660_15726 = state_15612__$1;
(statearr_15660_15726[(2)] = null);

(statearr_15660_15726[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (17))){
var state_15612__$1 = state_15612;
var statearr_15661_15727 = state_15612__$1;
(statearr_15661_15727[(2)] = null);

(statearr_15661_15727[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (3))){
var inst_15610 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15612__$1,inst_15610);
} else {
if((state_val_15613 === (12))){
var inst_15541 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15662_15728 = state_15612__$1;
(statearr_15662_15728[(2)] = inst_15541);

(statearr_15662_15728[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (2))){
var state_15612__$1 = state_15612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15612__$1,(4),ch);
} else {
if((state_val_15613 === (23))){
var state_15612__$1 = state_15612;
var statearr_15663_15729 = state_15612__$1;
(statearr_15663_15729[(2)] = null);

(statearr_15663_15729[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (35))){
var inst_15594 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15664_15730 = state_15612__$1;
(statearr_15664_15730[(2)] = inst_15594);

(statearr_15664_15730[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (19))){
var inst_15513 = (state_15612[(7)]);
var inst_15517 = cljs.core.chunk_first(inst_15513);
var inst_15518 = cljs.core.chunk_rest(inst_15513);
var inst_15519 = cljs.core.count(inst_15517);
var inst_15491 = inst_15518;
var inst_15492 = inst_15517;
var inst_15493 = inst_15519;
var inst_15494 = (0);
var state_15612__$1 = (function (){var statearr_15665 = state_15612;
(statearr_15665[(14)] = inst_15491);

(statearr_15665[(15)] = inst_15493);

(statearr_15665[(16)] = inst_15494);

(statearr_15665[(17)] = inst_15492);

return statearr_15665;
})();
var statearr_15666_15731 = state_15612__$1;
(statearr_15666_15731[(2)] = null);

(statearr_15666_15731[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (11))){
var inst_15491 = (state_15612[(14)]);
var inst_15513 = (state_15612[(7)]);
var inst_15513__$1 = cljs.core.seq(inst_15491);
var state_15612__$1 = (function (){var statearr_15667 = state_15612;
(statearr_15667[(7)] = inst_15513__$1);

return statearr_15667;
})();
if(inst_15513__$1){
var statearr_15668_15732 = state_15612__$1;
(statearr_15668_15732[(1)] = (16));

} else {
var statearr_15669_15733 = state_15612__$1;
(statearr_15669_15733[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (9))){
var inst_15543 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15670_15734 = state_15612__$1;
(statearr_15670_15734[(2)] = inst_15543);

(statearr_15670_15734[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (5))){
var inst_15489 = cljs.core.deref(cs);
var inst_15490 = cljs.core.seq(inst_15489);
var inst_15491 = inst_15490;
var inst_15492 = null;
var inst_15493 = (0);
var inst_15494 = (0);
var state_15612__$1 = (function (){var statearr_15671 = state_15612;
(statearr_15671[(14)] = inst_15491);

(statearr_15671[(15)] = inst_15493);

(statearr_15671[(16)] = inst_15494);

(statearr_15671[(17)] = inst_15492);

return statearr_15671;
})();
var statearr_15672_15735 = state_15612__$1;
(statearr_15672_15735[(2)] = null);

(statearr_15672_15735[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (14))){
var state_15612__$1 = state_15612;
var statearr_15673_15736 = state_15612__$1;
(statearr_15673_15736[(2)] = null);

(statearr_15673_15736[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (45))){
var inst_15602 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15674_15737 = state_15612__$1;
(statearr_15674_15737[(2)] = inst_15602);

(statearr_15674_15737[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (26))){
var inst_15546 = (state_15612[(27)]);
var inst_15598 = (state_15612[(2)]);
var inst_15599 = cljs.core.seq(inst_15546);
var state_15612__$1 = (function (){var statearr_15675 = state_15612;
(statearr_15675[(29)] = inst_15598);

return statearr_15675;
})();
if(inst_15599){
var statearr_15676_15738 = state_15612__$1;
(statearr_15676_15738[(1)] = (42));

} else {
var statearr_15677_15739 = state_15612__$1;
(statearr_15677_15739[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (16))){
var inst_15513 = (state_15612[(7)]);
var inst_15515 = cljs.core.chunked_seq_QMARK_(inst_15513);
var state_15612__$1 = state_15612;
if(inst_15515){
var statearr_15678_15740 = state_15612__$1;
(statearr_15678_15740[(1)] = (19));

} else {
var statearr_15679_15741 = state_15612__$1;
(statearr_15679_15741[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (38))){
var inst_15591 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15680_15742 = state_15612__$1;
(statearr_15680_15742[(2)] = inst_15591);

(statearr_15680_15742[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (30))){
var state_15612__$1 = state_15612;
var statearr_15681_15743 = state_15612__$1;
(statearr_15681_15743[(2)] = null);

(statearr_15681_15743[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (10))){
var inst_15494 = (state_15612[(16)]);
var inst_15492 = (state_15612[(17)]);
var inst_15502 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15492,inst_15494);
var inst_15503 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15502,(0),null);
var inst_15504 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15502,(1),null);
var state_15612__$1 = (function (){var statearr_15682 = state_15612;
(statearr_15682[(24)] = inst_15503);

return statearr_15682;
})();
if(cljs.core.truth_(inst_15504)){
var statearr_15683_15744 = state_15612__$1;
(statearr_15683_15744[(1)] = (13));

} else {
var statearr_15684_15745 = state_15612__$1;
(statearr_15684_15745[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (18))){
var inst_15539 = (state_15612[(2)]);
var state_15612__$1 = state_15612;
var statearr_15685_15746 = state_15612__$1;
(statearr_15685_15746[(2)] = inst_15539);

(statearr_15685_15746[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (42))){
var state_15612__$1 = state_15612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15612__$1,(45),dchan);
} else {
if((state_val_15613 === (37))){
var inst_15572 = (state_15612[(23)]);
var inst_15581 = (state_15612[(22)]);
var inst_15482 = (state_15612[(12)]);
var inst_15581__$1 = cljs.core.first(inst_15572);
var inst_15582 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_15581__$1,inst_15482,done);
var state_15612__$1 = (function (){var statearr_15686 = state_15612;
(statearr_15686[(22)] = inst_15581__$1);

return statearr_15686;
})();
if(cljs.core.truth_(inst_15582)){
var statearr_15687_15747 = state_15612__$1;
(statearr_15687_15747[(1)] = (39));

} else {
var statearr_15688_15748 = state_15612__$1;
(statearr_15688_15748[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15613 === (8))){
var inst_15493 = (state_15612[(15)]);
var inst_15494 = (state_15612[(16)]);
var inst_15496 = (inst_15494 < inst_15493);
var inst_15497 = inst_15496;
var state_15612__$1 = state_15612;
if(cljs.core.truth_(inst_15497)){
var statearr_15689_15749 = state_15612__$1;
(statearr_15689_15749[(1)] = (10));

} else {
var statearr_15690_15750 = state_15612__$1;
(statearr_15690_15750[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__14778__auto__ = null;
var cljs$core$async$mult_$_state_machine__14778__auto____0 = (function (){
var statearr_15691 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15691[(0)] = cljs$core$async$mult_$_state_machine__14778__auto__);

(statearr_15691[(1)] = (1));

return statearr_15691;
});
var cljs$core$async$mult_$_state_machine__14778__auto____1 = (function (state_15612){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15612);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15692){var ex__14781__auto__ = e15692;
var statearr_15693_15751 = state_15612;
(statearr_15693_15751[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15612[(4)]))){
var statearr_15694_15752 = state_15612;
(statearr_15694_15752[(1)] = cljs.core.first((state_15612[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15753 = state_15612;
state_15612 = G__15753;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14778__auto__ = function(state_15612){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14778__auto____1.call(this,state_15612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14778__auto____0;
cljs$core$async$mult_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14778__auto____1;
return cljs$core$async$mult_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15695 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15695[(6)] = c__14852__auto___15696);

return statearr_15695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__15755 = arguments.length;
switch (G__15755) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_15757 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_15757(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_15758 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_15758(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_15759 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_15759(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_15760 = (function (m,state_map){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4522__auto__.call(null,m,state_map));
} else {
var m__4519__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4519__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_15760(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_15761 = (function (m,mode){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4522__auto__.call(null,m,mode));
} else {
var m__4519__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4519__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_15761(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___15771 = arguments.length;
var i__4830__auto___15772 = (0);
while(true){
if((i__4830__auto___15772 < len__4829__auto___15771)){
args__4835__auto__.push((arguments[i__4830__auto___15772]));

var G__15773 = (i__4830__auto___15772 + (1));
i__4830__auto___15772 = G__15773;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((3) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4836__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__15766){
var map__15767 = p__15766;
var map__15767__$1 = cljs.core.__destructure_map(map__15767);
var opts = map__15767__$1;
var statearr_15768_15774 = state;
(statearr_15768_15774[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_15769_15775 = state;
(statearr_15769_15775[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_15770_15776 = state;
(statearr_15770_15776[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq15762){
var G__15763 = cljs.core.first(seq15762);
var seq15762__$1 = cljs.core.next(seq15762);
var G__15764 = cljs.core.first(seq15762__$1);
var seq15762__$2 = cljs.core.next(seq15762__$1);
var G__15765 = cljs.core.first(seq15762__$2);
var seq15762__$3 = cljs.core.next(seq15762__$2);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__15763,G__15764,G__15765,seq15762__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15777 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15777 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta15778){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta15778 = meta15778;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15779,meta15778__$1){
var self__ = this;
var _15779__$1 = this;
return (new cljs.core.async.t_cljs$core$async15777(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta15778__$1));
}));

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15779){
var self__ = this;
var _15779__$1 = this;
return self__.meta15778;
}));

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15777.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async15777.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta15778], null);
}));

(cljs.core.async.t_cljs$core$async15777.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15777.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15777");

(cljs.core.async.t_cljs$core$async15777.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async15777");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15777.
 */
cljs.core.async.__GT_t_cljs$core$async15777 = (function cljs$core$async$mix_$___GT_t_cljs$core$async15777(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15778){
return (new cljs.core.async.t_cljs$core$async15777(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta15778));
});

}

return (new cljs.core.async.t_cljs$core$async15777(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14852__auto___15892 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_15847){
var state_val_15848 = (state_15847[(1)]);
if((state_val_15848 === (7))){
var inst_15807 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
if(cljs.core.truth_(inst_15807)){
var statearr_15849_15893 = state_15847__$1;
(statearr_15849_15893[(1)] = (8));

} else {
var statearr_15850_15894 = state_15847__$1;
(statearr_15850_15894[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (20))){
var inst_15800 = (state_15847[(7)]);
var state_15847__$1 = state_15847;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15847__$1,(23),out,inst_15800);
} else {
if((state_val_15848 === (1))){
var inst_15783 = calc_state();
var inst_15784 = cljs.core.__destructure_map(inst_15783);
var inst_15785 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15784,cljs.core.cst$kw$solos);
var inst_15786 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15784,cljs.core.cst$kw$mutes);
var inst_15787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15784,cljs.core.cst$kw$reads);
var inst_15788 = inst_15783;
var state_15847__$1 = (function (){var statearr_15851 = state_15847;
(statearr_15851[(8)] = inst_15787);

(statearr_15851[(9)] = inst_15786);

(statearr_15851[(10)] = inst_15788);

(statearr_15851[(11)] = inst_15785);

return statearr_15851;
})();
var statearr_15852_15895 = state_15847__$1;
(statearr_15852_15895[(2)] = null);

(statearr_15852_15895[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (24))){
var inst_15791 = (state_15847[(12)]);
var inst_15788 = inst_15791;
var state_15847__$1 = (function (){var statearr_15853 = state_15847;
(statearr_15853[(10)] = inst_15788);

return statearr_15853;
})();
var statearr_15854_15896 = state_15847__$1;
(statearr_15854_15896[(2)] = null);

(statearr_15854_15896[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (4))){
var inst_15800 = (state_15847[(7)]);
var inst_15802 = (state_15847[(13)]);
var inst_15799 = (state_15847[(2)]);
var inst_15800__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15799,(0),null);
var inst_15801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15799,(1),null);
var inst_15802__$1 = (inst_15800__$1 == null);
var state_15847__$1 = (function (){var statearr_15855 = state_15847;
(statearr_15855[(7)] = inst_15800__$1);

(statearr_15855[(13)] = inst_15802__$1);

(statearr_15855[(14)] = inst_15801);

return statearr_15855;
})();
if(cljs.core.truth_(inst_15802__$1)){
var statearr_15856_15897 = state_15847__$1;
(statearr_15856_15897[(1)] = (5));

} else {
var statearr_15857_15898 = state_15847__$1;
(statearr_15857_15898[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (15))){
var inst_15792 = (state_15847[(15)]);
var inst_15821 = (state_15847[(16)]);
var inst_15821__$1 = cljs.core.empty_QMARK_(inst_15792);
var state_15847__$1 = (function (){var statearr_15858 = state_15847;
(statearr_15858[(16)] = inst_15821__$1);

return statearr_15858;
})();
if(inst_15821__$1){
var statearr_15859_15899 = state_15847__$1;
(statearr_15859_15899[(1)] = (17));

} else {
var statearr_15860_15900 = state_15847__$1;
(statearr_15860_15900[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (21))){
var inst_15791 = (state_15847[(12)]);
var inst_15788 = inst_15791;
var state_15847__$1 = (function (){var statearr_15861 = state_15847;
(statearr_15861[(10)] = inst_15788);

return statearr_15861;
})();
var statearr_15862_15901 = state_15847__$1;
(statearr_15862_15901[(2)] = null);

(statearr_15862_15901[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (13))){
var inst_15814 = (state_15847[(2)]);
var inst_15815 = calc_state();
var inst_15788 = inst_15815;
var state_15847__$1 = (function (){var statearr_15863 = state_15847;
(statearr_15863[(17)] = inst_15814);

(statearr_15863[(10)] = inst_15788);

return statearr_15863;
})();
var statearr_15864_15902 = state_15847__$1;
(statearr_15864_15902[(2)] = null);

(statearr_15864_15902[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (22))){
var inst_15841 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
var statearr_15865_15903 = state_15847__$1;
(statearr_15865_15903[(2)] = inst_15841);

(statearr_15865_15903[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (6))){
var inst_15801 = (state_15847[(14)]);
var inst_15805 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15801,change);
var state_15847__$1 = state_15847;
var statearr_15866_15904 = state_15847__$1;
(statearr_15866_15904[(2)] = inst_15805);

(statearr_15866_15904[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (25))){
var state_15847__$1 = state_15847;
var statearr_15867_15905 = state_15847__$1;
(statearr_15867_15905[(2)] = null);

(statearr_15867_15905[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (17))){
var inst_15793 = (state_15847[(18)]);
var inst_15801 = (state_15847[(14)]);
var inst_15823 = (inst_15793.cljs$core$IFn$_invoke$arity$1 ? inst_15793.cljs$core$IFn$_invoke$arity$1(inst_15801) : inst_15793.call(null,inst_15801));
var inst_15824 = cljs.core.not(inst_15823);
var state_15847__$1 = state_15847;
var statearr_15868_15906 = state_15847__$1;
(statearr_15868_15906[(2)] = inst_15824);

(statearr_15868_15906[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (3))){
var inst_15845 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15847__$1,inst_15845);
} else {
if((state_val_15848 === (12))){
var state_15847__$1 = state_15847;
var statearr_15869_15907 = state_15847__$1;
(statearr_15869_15907[(2)] = null);

(statearr_15869_15907[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (2))){
var inst_15791 = (state_15847[(12)]);
var inst_15788 = (state_15847[(10)]);
var inst_15791__$1 = cljs.core.__destructure_map(inst_15788);
var inst_15792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15791__$1,cljs.core.cst$kw$solos);
var inst_15793 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15791__$1,cljs.core.cst$kw$mutes);
var inst_15794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15791__$1,cljs.core.cst$kw$reads);
var state_15847__$1 = (function (){var statearr_15870 = state_15847;
(statearr_15870[(15)] = inst_15792);

(statearr_15870[(12)] = inst_15791__$1);

(statearr_15870[(18)] = inst_15793);

return statearr_15870;
})();
return cljs.core.async.ioc_alts_BANG_(state_15847__$1,(4),inst_15794);
} else {
if((state_val_15848 === (23))){
var inst_15832 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
if(cljs.core.truth_(inst_15832)){
var statearr_15871_15908 = state_15847__$1;
(statearr_15871_15908[(1)] = (24));

} else {
var statearr_15872_15909 = state_15847__$1;
(statearr_15872_15909[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (19))){
var inst_15827 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
var statearr_15873_15910 = state_15847__$1;
(statearr_15873_15910[(2)] = inst_15827);

(statearr_15873_15910[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (11))){
var inst_15801 = (state_15847[(14)]);
var inst_15811 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_15801);
var state_15847__$1 = state_15847;
var statearr_15874_15911 = state_15847__$1;
(statearr_15874_15911[(2)] = inst_15811);

(statearr_15874_15911[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (9))){
var inst_15792 = (state_15847[(15)]);
var inst_15818 = (state_15847[(19)]);
var inst_15801 = (state_15847[(14)]);
var inst_15818__$1 = (inst_15792.cljs$core$IFn$_invoke$arity$1 ? inst_15792.cljs$core$IFn$_invoke$arity$1(inst_15801) : inst_15792.call(null,inst_15801));
var state_15847__$1 = (function (){var statearr_15875 = state_15847;
(statearr_15875[(19)] = inst_15818__$1);

return statearr_15875;
})();
if(cljs.core.truth_(inst_15818__$1)){
var statearr_15876_15912 = state_15847__$1;
(statearr_15876_15912[(1)] = (14));

} else {
var statearr_15877_15913 = state_15847__$1;
(statearr_15877_15913[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (5))){
var inst_15802 = (state_15847[(13)]);
var state_15847__$1 = state_15847;
var statearr_15878_15914 = state_15847__$1;
(statearr_15878_15914[(2)] = inst_15802);

(statearr_15878_15914[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (14))){
var inst_15818 = (state_15847[(19)]);
var state_15847__$1 = state_15847;
var statearr_15879_15915 = state_15847__$1;
(statearr_15879_15915[(2)] = inst_15818);

(statearr_15879_15915[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (26))){
var inst_15837 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
var statearr_15880_15916 = state_15847__$1;
(statearr_15880_15916[(2)] = inst_15837);

(statearr_15880_15916[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (16))){
var inst_15829 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
if(cljs.core.truth_(inst_15829)){
var statearr_15881_15917 = state_15847__$1;
(statearr_15881_15917[(1)] = (20));

} else {
var statearr_15882_15918 = state_15847__$1;
(statearr_15882_15918[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (10))){
var inst_15843 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
var statearr_15883_15919 = state_15847__$1;
(statearr_15883_15919[(2)] = inst_15843);

(statearr_15883_15919[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (18))){
var inst_15821 = (state_15847[(16)]);
var state_15847__$1 = state_15847;
var statearr_15884_15920 = state_15847__$1;
(statearr_15884_15920[(2)] = inst_15821);

(statearr_15884_15920[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15848 === (8))){
var inst_15800 = (state_15847[(7)]);
var inst_15809 = (inst_15800 == null);
var state_15847__$1 = state_15847;
if(cljs.core.truth_(inst_15809)){
var statearr_15885_15921 = state_15847__$1;
(statearr_15885_15921[(1)] = (11));

} else {
var statearr_15886_15922 = state_15847__$1;
(statearr_15886_15922[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__14778__auto__ = null;
var cljs$core$async$mix_$_state_machine__14778__auto____0 = (function (){
var statearr_15887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15887[(0)] = cljs$core$async$mix_$_state_machine__14778__auto__);

(statearr_15887[(1)] = (1));

return statearr_15887;
});
var cljs$core$async$mix_$_state_machine__14778__auto____1 = (function (state_15847){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_15847);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e15888){var ex__14781__auto__ = e15888;
var statearr_15889_15923 = state_15847;
(statearr_15889_15923[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_15847[(4)]))){
var statearr_15890_15924 = state_15847;
(statearr_15890_15924[(1)] = cljs.core.first((state_15847[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__15925 = state_15847;
state_15847 = G__15925;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14778__auto__ = function(state_15847){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14778__auto____1.call(this,state_15847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14778__auto____0;
cljs$core$async$mix_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14778__auto____1;
return cljs$core$async$mix_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_15891 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_15891[(6)] = c__14852__auto___15892);

return statearr_15891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_15928 = (function (p,v,ch,close_QMARK_){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4522__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4519__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_15928(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_15929 = (function (p,v,ch){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4522__auto__.call(null,p,v,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4519__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_15929(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_15930 = (function() {
var G__15931 = null;
var G__15931__1 = (function (p){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4522__auto__.call(null,p));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4519__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__15931__2 = (function (p,v){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4522__auto__.call(null,p,v));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4519__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__15931 = function(p,v){
switch(arguments.length){
case 1:
return G__15931__1.call(this,p);
case 2:
return G__15931__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__15931.cljs$core$IFn$_invoke$arity$1 = G__15931__1;
G__15931.cljs$core$IFn$_invoke$arity$2 = G__15931__2;
return G__15931;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__15927 = arguments.length;
switch (G__15927) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15930.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15930.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__15935 = arguments.length;
switch (G__15935) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__15933_SHARP_){
if(cljs.core.truth_((p1__15933_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15933_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__15933_SHARP_.call(null,topic)))){
return p1__15933_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__15933_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15936 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15936 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15937){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15937 = meta15937;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15938,meta15937__$1){
var self__ = this;
var _15938__$1 = this;
return (new cljs.core.async.t_cljs$core$async15936(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15937__$1));
}));

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15938){
var self__ = this;
var _15938__$1 = this;
return self__.meta15937;
}));

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async15936.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async15936.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta15937], null);
}));

(cljs.core.async.t_cljs$core$async15936.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15936.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15936");

(cljs.core.async.t_cljs$core$async15936.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async15936");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15936.
 */
cljs.core.async.__GT_t_cljs$core$async15936 = (function cljs$core$async$__GT_t_cljs$core$async15936(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15937){
return (new cljs.core.async.t_cljs$core$async15936(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15937));
});

}

return (new cljs.core.async.t_cljs$core$async15936(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__14852__auto___16057 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16010){
var state_val_16011 = (state_16010[(1)]);
if((state_val_16011 === (7))){
var inst_16006 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
var statearr_16012_16058 = state_16010__$1;
(statearr_16012_16058[(2)] = inst_16006);

(statearr_16012_16058[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (20))){
var state_16010__$1 = state_16010;
var statearr_16013_16059 = state_16010__$1;
(statearr_16013_16059[(2)] = null);

(statearr_16013_16059[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (1))){
var state_16010__$1 = state_16010;
var statearr_16014_16060 = state_16010__$1;
(statearr_16014_16060[(2)] = null);

(statearr_16014_16060[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (24))){
var inst_15989 = (state_16010[(7)]);
var inst_15998 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_15989);
var state_16010__$1 = state_16010;
var statearr_16015_16061 = state_16010__$1;
(statearr_16015_16061[(2)] = inst_15998);

(statearr_16015_16061[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (4))){
var inst_15941 = (state_16010[(8)]);
var inst_15941__$1 = (state_16010[(2)]);
var inst_15942 = (inst_15941__$1 == null);
var state_16010__$1 = (function (){var statearr_16016 = state_16010;
(statearr_16016[(8)] = inst_15941__$1);

return statearr_16016;
})();
if(cljs.core.truth_(inst_15942)){
var statearr_16017_16062 = state_16010__$1;
(statearr_16017_16062[(1)] = (5));

} else {
var statearr_16018_16063 = state_16010__$1;
(statearr_16018_16063[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (15))){
var inst_15983 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
var statearr_16019_16064 = state_16010__$1;
(statearr_16019_16064[(2)] = inst_15983);

(statearr_16019_16064[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (21))){
var inst_16003 = (state_16010[(2)]);
var state_16010__$1 = (function (){var statearr_16020 = state_16010;
(statearr_16020[(9)] = inst_16003);

return statearr_16020;
})();
var statearr_16021_16065 = state_16010__$1;
(statearr_16021_16065[(2)] = null);

(statearr_16021_16065[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (13))){
var inst_15965 = (state_16010[(10)]);
var inst_15967 = cljs.core.chunked_seq_QMARK_(inst_15965);
var state_16010__$1 = state_16010;
if(inst_15967){
var statearr_16022_16066 = state_16010__$1;
(statearr_16022_16066[(1)] = (16));

} else {
var statearr_16023_16067 = state_16010__$1;
(statearr_16023_16067[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (22))){
var inst_15995 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
if(cljs.core.truth_(inst_15995)){
var statearr_16024_16068 = state_16010__$1;
(statearr_16024_16068[(1)] = (23));

} else {
var statearr_16025_16069 = state_16010__$1;
(statearr_16025_16069[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (6))){
var inst_15991 = (state_16010[(11)]);
var inst_15989 = (state_16010[(7)]);
var inst_15941 = (state_16010[(8)]);
var inst_15989__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_15941) : topic_fn.call(null,inst_15941));
var inst_15990 = cljs.core.deref(mults);
var inst_15991__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15990,inst_15989__$1);
var state_16010__$1 = (function (){var statearr_16026 = state_16010;
(statearr_16026[(11)] = inst_15991__$1);

(statearr_16026[(7)] = inst_15989__$1);

return statearr_16026;
})();
if(cljs.core.truth_(inst_15991__$1)){
var statearr_16027_16070 = state_16010__$1;
(statearr_16027_16070[(1)] = (19));

} else {
var statearr_16028_16071 = state_16010__$1;
(statearr_16028_16071[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (25))){
var inst_16000 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
var statearr_16029_16072 = state_16010__$1;
(statearr_16029_16072[(2)] = inst_16000);

(statearr_16029_16072[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (17))){
var inst_15965 = (state_16010[(10)]);
var inst_15974 = cljs.core.first(inst_15965);
var inst_15975 = cljs.core.async.muxch_STAR_(inst_15974);
var inst_15976 = cljs.core.async.close_BANG_(inst_15975);
var inst_15977 = cljs.core.next(inst_15965);
var inst_15951 = inst_15977;
var inst_15952 = null;
var inst_15953 = (0);
var inst_15954 = (0);
var state_16010__$1 = (function (){var statearr_16030 = state_16010;
(statearr_16030[(12)] = inst_15953);

(statearr_16030[(13)] = inst_15976);

(statearr_16030[(14)] = inst_15954);

(statearr_16030[(15)] = inst_15951);

(statearr_16030[(16)] = inst_15952);

return statearr_16030;
})();
var statearr_16031_16073 = state_16010__$1;
(statearr_16031_16073[(2)] = null);

(statearr_16031_16073[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (3))){
var inst_16008 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16010__$1,inst_16008);
} else {
if((state_val_16011 === (12))){
var inst_15985 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
var statearr_16032_16074 = state_16010__$1;
(statearr_16032_16074[(2)] = inst_15985);

(statearr_16032_16074[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (2))){
var state_16010__$1 = state_16010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16010__$1,(4),ch);
} else {
if((state_val_16011 === (23))){
var state_16010__$1 = state_16010;
var statearr_16033_16075 = state_16010__$1;
(statearr_16033_16075[(2)] = null);

(statearr_16033_16075[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (19))){
var inst_15991 = (state_16010[(11)]);
var inst_15941 = (state_16010[(8)]);
var inst_15993 = cljs.core.async.muxch_STAR_(inst_15991);
var state_16010__$1 = state_16010;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16010__$1,(22),inst_15993,inst_15941);
} else {
if((state_val_16011 === (11))){
var inst_15951 = (state_16010[(15)]);
var inst_15965 = (state_16010[(10)]);
var inst_15965__$1 = cljs.core.seq(inst_15951);
var state_16010__$1 = (function (){var statearr_16034 = state_16010;
(statearr_16034[(10)] = inst_15965__$1);

return statearr_16034;
})();
if(inst_15965__$1){
var statearr_16035_16076 = state_16010__$1;
(statearr_16035_16076[(1)] = (13));

} else {
var statearr_16036_16077 = state_16010__$1;
(statearr_16036_16077[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (9))){
var inst_15987 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
var statearr_16037_16078 = state_16010__$1;
(statearr_16037_16078[(2)] = inst_15987);

(statearr_16037_16078[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (5))){
var inst_15948 = cljs.core.deref(mults);
var inst_15949 = cljs.core.vals(inst_15948);
var inst_15950 = cljs.core.seq(inst_15949);
var inst_15951 = inst_15950;
var inst_15952 = null;
var inst_15953 = (0);
var inst_15954 = (0);
var state_16010__$1 = (function (){var statearr_16038 = state_16010;
(statearr_16038[(12)] = inst_15953);

(statearr_16038[(14)] = inst_15954);

(statearr_16038[(15)] = inst_15951);

(statearr_16038[(16)] = inst_15952);

return statearr_16038;
})();
var statearr_16039_16079 = state_16010__$1;
(statearr_16039_16079[(2)] = null);

(statearr_16039_16079[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (14))){
var state_16010__$1 = state_16010;
var statearr_16043_16080 = state_16010__$1;
(statearr_16043_16080[(2)] = null);

(statearr_16043_16080[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (16))){
var inst_15965 = (state_16010[(10)]);
var inst_15969 = cljs.core.chunk_first(inst_15965);
var inst_15970 = cljs.core.chunk_rest(inst_15965);
var inst_15971 = cljs.core.count(inst_15969);
var inst_15951 = inst_15970;
var inst_15952 = inst_15969;
var inst_15953 = inst_15971;
var inst_15954 = (0);
var state_16010__$1 = (function (){var statearr_16044 = state_16010;
(statearr_16044[(12)] = inst_15953);

(statearr_16044[(14)] = inst_15954);

(statearr_16044[(15)] = inst_15951);

(statearr_16044[(16)] = inst_15952);

return statearr_16044;
})();
var statearr_16045_16081 = state_16010__$1;
(statearr_16045_16081[(2)] = null);

(statearr_16045_16081[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (10))){
var inst_15953 = (state_16010[(12)]);
var inst_15954 = (state_16010[(14)]);
var inst_15951 = (state_16010[(15)]);
var inst_15952 = (state_16010[(16)]);
var inst_15959 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15952,inst_15954);
var inst_15960 = cljs.core.async.muxch_STAR_(inst_15959);
var inst_15961 = cljs.core.async.close_BANG_(inst_15960);
var inst_15962 = (inst_15954 + (1));
var tmp16040 = inst_15953;
var tmp16041 = inst_15951;
var tmp16042 = inst_15952;
var inst_15951__$1 = tmp16041;
var inst_15952__$1 = tmp16042;
var inst_15953__$1 = tmp16040;
var inst_15954__$1 = inst_15962;
var state_16010__$1 = (function (){var statearr_16046 = state_16010;
(statearr_16046[(12)] = inst_15953__$1);

(statearr_16046[(14)] = inst_15954__$1);

(statearr_16046[(15)] = inst_15951__$1);

(statearr_16046[(16)] = inst_15952__$1);

(statearr_16046[(17)] = inst_15961);

return statearr_16046;
})();
var statearr_16047_16082 = state_16010__$1;
(statearr_16047_16082[(2)] = null);

(statearr_16047_16082[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (18))){
var inst_15980 = (state_16010[(2)]);
var state_16010__$1 = state_16010;
var statearr_16048_16083 = state_16010__$1;
(statearr_16048_16083[(2)] = inst_15980);

(statearr_16048_16083[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16011 === (8))){
var inst_15953 = (state_16010[(12)]);
var inst_15954 = (state_16010[(14)]);
var inst_15956 = (inst_15954 < inst_15953);
var inst_15957 = inst_15956;
var state_16010__$1 = state_16010;
if(cljs.core.truth_(inst_15957)){
var statearr_16049_16084 = state_16010__$1;
(statearr_16049_16084[(1)] = (10));

} else {
var statearr_16050_16085 = state_16010__$1;
(statearr_16050_16085[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16051[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16051[(1)] = (1));

return statearr_16051;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16010){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16010);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16052){var ex__14781__auto__ = e16052;
var statearr_16053_16086 = state_16010;
(statearr_16053_16086[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16010[(4)]))){
var statearr_16054_16087 = state_16010;
(statearr_16054_16087[(1)] = cljs.core.first((state_16010[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16088 = state_16010;
state_16010 = G__16088;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16010){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16055 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16055[(6)] = c__14852__auto___16057);

return statearr_16055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__16090 = arguments.length;
switch (G__16090) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__16093 = arguments.length;
switch (G__16093) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__16096 = arguments.length;
switch (G__16096) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__14852__auto___16174 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16139){
var state_val_16140 = (state_16139[(1)]);
if((state_val_16140 === (7))){
var state_16139__$1 = state_16139;
var statearr_16141_16175 = state_16139__$1;
(statearr_16141_16175[(2)] = null);

(statearr_16141_16175[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (1))){
var state_16139__$1 = state_16139;
var statearr_16142_16176 = state_16139__$1;
(statearr_16142_16176[(2)] = null);

(statearr_16142_16176[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (4))){
var inst_16099 = (state_16139[(7)]);
var inst_16100 = (state_16139[(8)]);
var inst_16102 = (inst_16100 < inst_16099);
var state_16139__$1 = state_16139;
if(cljs.core.truth_(inst_16102)){
var statearr_16143_16177 = state_16139__$1;
(statearr_16143_16177[(1)] = (6));

} else {
var statearr_16144_16178 = state_16139__$1;
(statearr_16144_16178[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (15))){
var inst_16125 = (state_16139[(9)]);
var inst_16130 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_16125);
var state_16139__$1 = state_16139;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16139__$1,(17),out,inst_16130);
} else {
if((state_val_16140 === (13))){
var inst_16125 = (state_16139[(9)]);
var inst_16125__$1 = (state_16139[(2)]);
var inst_16126 = cljs.core.some(cljs.core.nil_QMARK_,inst_16125__$1);
var state_16139__$1 = (function (){var statearr_16145 = state_16139;
(statearr_16145[(9)] = inst_16125__$1);

return statearr_16145;
})();
if(cljs.core.truth_(inst_16126)){
var statearr_16146_16179 = state_16139__$1;
(statearr_16146_16179[(1)] = (14));

} else {
var statearr_16147_16180 = state_16139__$1;
(statearr_16147_16180[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (6))){
var state_16139__$1 = state_16139;
var statearr_16148_16181 = state_16139__$1;
(statearr_16148_16181[(2)] = null);

(statearr_16148_16181[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (17))){
var inst_16132 = (state_16139[(2)]);
var state_16139__$1 = (function (){var statearr_16150 = state_16139;
(statearr_16150[(10)] = inst_16132);

return statearr_16150;
})();
var statearr_16151_16182 = state_16139__$1;
(statearr_16151_16182[(2)] = null);

(statearr_16151_16182[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (3))){
var inst_16137 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16139__$1,inst_16137);
} else {
if((state_val_16140 === (12))){
var _ = (function (){var statearr_16152 = state_16139;
(statearr_16152[(4)] = cljs.core.rest((state_16139[(4)])));

return statearr_16152;
})();
var state_16139__$1 = state_16139;
var ex16149 = (state_16139__$1[(2)]);
var statearr_16153_16183 = state_16139__$1;
(statearr_16153_16183[(5)] = ex16149);


if((ex16149 instanceof Object)){
var statearr_16154_16184 = state_16139__$1;
(statearr_16154_16184[(1)] = (11));

(statearr_16154_16184[(5)] = null);

} else {
throw ex16149;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (2))){
var inst_16098 = cljs.core.reset_BANG_(dctr,cnt);
var inst_16099 = cnt;
var inst_16100 = (0);
var state_16139__$1 = (function (){var statearr_16155 = state_16139;
(statearr_16155[(7)] = inst_16099);

(statearr_16155[(8)] = inst_16100);

(statearr_16155[(11)] = inst_16098);

return statearr_16155;
})();
var statearr_16156_16185 = state_16139__$1;
(statearr_16156_16185[(2)] = null);

(statearr_16156_16185[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (11))){
var inst_16104 = (state_16139[(2)]);
var inst_16105 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_16139__$1 = (function (){var statearr_16157 = state_16139;
(statearr_16157[(12)] = inst_16104);

return statearr_16157;
})();
var statearr_16158_16186 = state_16139__$1;
(statearr_16158_16186[(2)] = inst_16105);

(statearr_16158_16186[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (9))){
var inst_16100 = (state_16139[(8)]);
var _ = (function (){var statearr_16159 = state_16139;
(statearr_16159[(4)] = cljs.core.cons((12),(state_16139[(4)])));

return statearr_16159;
})();
var inst_16111 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_16100) : chs__$1.call(null,inst_16100));
var inst_16112 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_16100) : done.call(null,inst_16100));
var inst_16113 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_16111,inst_16112);
var ___$1 = (function (){var statearr_16160 = state_16139;
(statearr_16160[(4)] = cljs.core.rest((state_16139[(4)])));

return statearr_16160;
})();
var state_16139__$1 = state_16139;
var statearr_16161_16187 = state_16139__$1;
(statearr_16161_16187[(2)] = inst_16113);

(statearr_16161_16187[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (5))){
var inst_16123 = (state_16139[(2)]);
var state_16139__$1 = (function (){var statearr_16162 = state_16139;
(statearr_16162[(13)] = inst_16123);

return statearr_16162;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16139__$1,(13),dchan);
} else {
if((state_val_16140 === (14))){
var inst_16128 = cljs.core.async.close_BANG_(out);
var state_16139__$1 = state_16139;
var statearr_16163_16188 = state_16139__$1;
(statearr_16163_16188[(2)] = inst_16128);

(statearr_16163_16188[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (16))){
var inst_16135 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
var statearr_16164_16189 = state_16139__$1;
(statearr_16164_16189[(2)] = inst_16135);

(statearr_16164_16189[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (10))){
var inst_16100 = (state_16139[(8)]);
var inst_16116 = (state_16139[(2)]);
var inst_16117 = (inst_16100 + (1));
var inst_16100__$1 = inst_16117;
var state_16139__$1 = (function (){var statearr_16165 = state_16139;
(statearr_16165[(14)] = inst_16116);

(statearr_16165[(8)] = inst_16100__$1);

return statearr_16165;
})();
var statearr_16166_16190 = state_16139__$1;
(statearr_16166_16190[(2)] = null);

(statearr_16166_16190[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16140 === (8))){
var inst_16121 = (state_16139[(2)]);
var state_16139__$1 = state_16139;
var statearr_16167_16191 = state_16139__$1;
(statearr_16167_16191[(2)] = inst_16121);

(statearr_16167_16191[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16168[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16168[(1)] = (1));

return statearr_16168;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16139){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16139);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16169){var ex__14781__auto__ = e16169;
var statearr_16170_16192 = state_16139;
(statearr_16170_16192[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16139[(4)]))){
var statearr_16171_16193 = state_16139;
(statearr_16171_16193[(1)] = cljs.core.first((state_16139[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16194 = state_16139;
state_16139 = G__16194;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16139){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16172 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16172[(6)] = c__14852__auto___16174);

return statearr_16172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__16197 = arguments.length;
switch (G__16197) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14852__auto___16252 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16229){
var state_val_16230 = (state_16229[(1)]);
if((state_val_16230 === (7))){
var inst_16208 = (state_16229[(7)]);
var inst_16209 = (state_16229[(8)]);
var inst_16208__$1 = (state_16229[(2)]);
var inst_16209__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16208__$1,(0),null);
var inst_16210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16208__$1,(1),null);
var inst_16211 = (inst_16209__$1 == null);
var state_16229__$1 = (function (){var statearr_16231 = state_16229;
(statearr_16231[(7)] = inst_16208__$1);

(statearr_16231[(8)] = inst_16209__$1);

(statearr_16231[(9)] = inst_16210);

return statearr_16231;
})();
if(cljs.core.truth_(inst_16211)){
var statearr_16232_16253 = state_16229__$1;
(statearr_16232_16253[(1)] = (8));

} else {
var statearr_16233_16254 = state_16229__$1;
(statearr_16233_16254[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16230 === (1))){
var inst_16198 = cljs.core.vec(chs);
var inst_16199 = inst_16198;
var state_16229__$1 = (function (){var statearr_16234 = state_16229;
(statearr_16234[(10)] = inst_16199);

return statearr_16234;
})();
var statearr_16235_16255 = state_16229__$1;
(statearr_16235_16255[(2)] = null);

(statearr_16235_16255[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16230 === (4))){
var inst_16199 = (state_16229[(10)]);
var state_16229__$1 = state_16229;
return cljs.core.async.ioc_alts_BANG_(state_16229__$1,(7),inst_16199);
} else {
if((state_val_16230 === (6))){
var inst_16225 = (state_16229[(2)]);
var state_16229__$1 = state_16229;
var statearr_16236_16256 = state_16229__$1;
(statearr_16236_16256[(2)] = inst_16225);

(statearr_16236_16256[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16230 === (3))){
var inst_16227 = (state_16229[(2)]);
var state_16229__$1 = state_16229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16229__$1,inst_16227);
} else {
if((state_val_16230 === (2))){
var inst_16199 = (state_16229[(10)]);
var inst_16201 = cljs.core.count(inst_16199);
var inst_16202 = (inst_16201 > (0));
var state_16229__$1 = state_16229;
if(cljs.core.truth_(inst_16202)){
var statearr_16238_16257 = state_16229__$1;
(statearr_16238_16257[(1)] = (4));

} else {
var statearr_16239_16258 = state_16229__$1;
(statearr_16239_16258[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16230 === (11))){
var inst_16199 = (state_16229[(10)]);
var inst_16218 = (state_16229[(2)]);
var tmp16237 = inst_16199;
var inst_16199__$1 = tmp16237;
var state_16229__$1 = (function (){var statearr_16240 = state_16229;
(statearr_16240[(10)] = inst_16199__$1);

(statearr_16240[(11)] = inst_16218);

return statearr_16240;
})();
var statearr_16241_16259 = state_16229__$1;
(statearr_16241_16259[(2)] = null);

(statearr_16241_16259[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16230 === (9))){
var inst_16209 = (state_16229[(8)]);
var state_16229__$1 = state_16229;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16229__$1,(11),out,inst_16209);
} else {
if((state_val_16230 === (5))){
var inst_16223 = cljs.core.async.close_BANG_(out);
var state_16229__$1 = state_16229;
var statearr_16242_16260 = state_16229__$1;
(statearr_16242_16260[(2)] = inst_16223);

(statearr_16242_16260[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16230 === (10))){
var inst_16221 = (state_16229[(2)]);
var state_16229__$1 = state_16229;
var statearr_16243_16261 = state_16229__$1;
(statearr_16243_16261[(2)] = inst_16221);

(statearr_16243_16261[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16230 === (8))){
var inst_16208 = (state_16229[(7)]);
var inst_16199 = (state_16229[(10)]);
var inst_16209 = (state_16229[(8)]);
var inst_16210 = (state_16229[(9)]);
var inst_16213 = (function (){var cs = inst_16199;
var vec__16204 = inst_16208;
var v = inst_16209;
var c = inst_16210;
return (function (p1__16195_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__16195_SHARP_);
});
})();
var inst_16214 = cljs.core.filterv(inst_16213,inst_16199);
var inst_16199__$1 = inst_16214;
var state_16229__$1 = (function (){var statearr_16244 = state_16229;
(statearr_16244[(10)] = inst_16199__$1);

return statearr_16244;
})();
var statearr_16245_16262 = state_16229__$1;
(statearr_16245_16262[(2)] = null);

(statearr_16245_16262[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16246 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16246[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16246[(1)] = (1));

return statearr_16246;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16229){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16229);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16247){var ex__14781__auto__ = e16247;
var statearr_16248_16263 = state_16229;
(statearr_16248_16263[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16229[(4)]))){
var statearr_16249_16264 = state_16229;
(statearr_16249_16264[(1)] = cljs.core.first((state_16229[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16265 = state_16229;
state_16229 = G__16265;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16229){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16250 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16250[(6)] = c__14852__auto___16252);

return statearr_16250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__16267 = arguments.length;
switch (G__16267) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14852__auto___16313 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16291){
var state_val_16292 = (state_16291[(1)]);
if((state_val_16292 === (7))){
var inst_16273 = (state_16291[(7)]);
var inst_16273__$1 = (state_16291[(2)]);
var inst_16274 = (inst_16273__$1 == null);
var inst_16275 = cljs.core.not(inst_16274);
var state_16291__$1 = (function (){var statearr_16293 = state_16291;
(statearr_16293[(7)] = inst_16273__$1);

return statearr_16293;
})();
if(inst_16275){
var statearr_16294_16314 = state_16291__$1;
(statearr_16294_16314[(1)] = (8));

} else {
var statearr_16295_16315 = state_16291__$1;
(statearr_16295_16315[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (1))){
var inst_16268 = (0);
var state_16291__$1 = (function (){var statearr_16296 = state_16291;
(statearr_16296[(8)] = inst_16268);

return statearr_16296;
})();
var statearr_16297_16316 = state_16291__$1;
(statearr_16297_16316[(2)] = null);

(statearr_16297_16316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (4))){
var state_16291__$1 = state_16291;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16291__$1,(7),ch);
} else {
if((state_val_16292 === (6))){
var inst_16286 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16298_16317 = state_16291__$1;
(statearr_16298_16317[(2)] = inst_16286);

(statearr_16298_16317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (3))){
var inst_16288 = (state_16291[(2)]);
var inst_16289 = cljs.core.async.close_BANG_(out);
var state_16291__$1 = (function (){var statearr_16299 = state_16291;
(statearr_16299[(9)] = inst_16288);

return statearr_16299;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16291__$1,inst_16289);
} else {
if((state_val_16292 === (2))){
var inst_16268 = (state_16291[(8)]);
var inst_16270 = (inst_16268 < n);
var state_16291__$1 = state_16291;
if(cljs.core.truth_(inst_16270)){
var statearr_16300_16318 = state_16291__$1;
(statearr_16300_16318[(1)] = (4));

} else {
var statearr_16301_16319 = state_16291__$1;
(statearr_16301_16319[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (11))){
var inst_16268 = (state_16291[(8)]);
var inst_16278 = (state_16291[(2)]);
var inst_16279 = (inst_16268 + (1));
var inst_16268__$1 = inst_16279;
var state_16291__$1 = (function (){var statearr_16302 = state_16291;
(statearr_16302[(8)] = inst_16268__$1);

(statearr_16302[(10)] = inst_16278);

return statearr_16302;
})();
var statearr_16303_16320 = state_16291__$1;
(statearr_16303_16320[(2)] = null);

(statearr_16303_16320[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (9))){
var state_16291__$1 = state_16291;
var statearr_16304_16321 = state_16291__$1;
(statearr_16304_16321[(2)] = null);

(statearr_16304_16321[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (5))){
var state_16291__$1 = state_16291;
var statearr_16305_16322 = state_16291__$1;
(statearr_16305_16322[(2)] = null);

(statearr_16305_16322[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (10))){
var inst_16283 = (state_16291[(2)]);
var state_16291__$1 = state_16291;
var statearr_16306_16323 = state_16291__$1;
(statearr_16306_16323[(2)] = inst_16283);

(statearr_16306_16323[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16292 === (8))){
var inst_16273 = (state_16291[(7)]);
var state_16291__$1 = state_16291;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16291__$1,(11),out,inst_16273);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16307 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16307[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16307[(1)] = (1));

return statearr_16307;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16291){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16291);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16308){var ex__14781__auto__ = e16308;
var statearr_16309_16324 = state_16291;
(statearr_16309_16324[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16291[(4)]))){
var statearr_16310_16325 = state_16291;
(statearr_16310_16325[(1)] = cljs.core.first((state_16291[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16326 = state_16291;
state_16291 = G__16326;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16291){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16311 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16311[(6)] = c__14852__auto___16313);

return statearr_16311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16328 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16328 = (function (f,ch,meta16329){
this.f = f;
this.ch = ch;
this.meta16329 = meta16329;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16330,meta16329__$1){
var self__ = this;
var _16330__$1 = this;
return (new cljs.core.async.t_cljs$core$async16328(self__.f,self__.ch,meta16329__$1));
}));

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16330){
var self__ = this;
var _16330__$1 = this;
return self__.meta16329;
}));

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16331 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16331 = (function (f,ch,meta16329,_,fn1,meta16332){
this.f = f;
this.ch = ch;
this.meta16329 = meta16329;
this._ = _;
this.fn1 = fn1;
this.meta16332 = meta16332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16333,meta16332__$1){
var self__ = this;
var _16333__$1 = this;
return (new cljs.core.async.t_cljs$core$async16331(self__.f,self__.ch,self__.meta16329,self__._,self__.fn1,meta16332__$1));
}));

(cljs.core.async.t_cljs$core$async16331.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16333){
var self__ = this;
var _16333__$1 = this;
return self__.meta16332;
}));

(cljs.core.async.t_cljs$core$async16331.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16331.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async16331.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async16331.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__16327_SHARP_){
var G__16334 = (((p1__16327_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__16327_SHARP_) : self__.f.call(null,p1__16327_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__16334) : f1.call(null,G__16334));
});
}));

(cljs.core.async.t_cljs$core$async16331.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16329,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async16328], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta16332], null);
}));

(cljs.core.async.t_cljs$core$async16331.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16331");

(cljs.core.async.t_cljs$core$async16331.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16331");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16331.
 */
cljs.core.async.__GT_t_cljs$core$async16331 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16331(f__$1,ch__$1,meta16329__$1,___$2,fn1__$1,meta16332){
return (new cljs.core.async.t_cljs$core$async16331(f__$1,ch__$1,meta16329__$1,___$2,fn1__$1,meta16332));
});

}

return (new cljs.core.async.t_cljs$core$async16331(self__.f,self__.ch,self__.meta16329,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4221__auto__ = ret;
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4221__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__16335 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__16335) : self__.f.call(null,G__16335));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16328.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async16328.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16329], null);
}));

(cljs.core.async.t_cljs$core$async16328.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16328.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16328");

(cljs.core.async.t_cljs$core$async16328.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16328");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16328.
 */
cljs.core.async.__GT_t_cljs$core$async16328 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async16328(f__$1,ch__$1,meta16329){
return (new cljs.core.async.t_cljs$core$async16328(f__$1,ch__$1,meta16329));
});

}

return (new cljs.core.async.t_cljs$core$async16328(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16336 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16336 = (function (f,ch,meta16337){
this.f = f;
this.ch = ch;
this.meta16337 = meta16337;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16338,meta16337__$1){
var self__ = this;
var _16338__$1 = this;
return (new cljs.core.async.t_cljs$core$async16336(self__.f,self__.ch,meta16337__$1));
}));

(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16338){
var self__ = this;
var _16338__$1 = this;
return self__.meta16337;
}));

(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16336.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async16336.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16337], null);
}));

(cljs.core.async.t_cljs$core$async16336.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16336.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16336");

(cljs.core.async.t_cljs$core$async16336.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16336");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16336.
 */
cljs.core.async.__GT_t_cljs$core$async16336 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async16336(f__$1,ch__$1,meta16337){
return (new cljs.core.async.t_cljs$core$async16336(f__$1,ch__$1,meta16337));
});

}

return (new cljs.core.async.t_cljs$core$async16336(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async16339 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16339 = (function (p,ch,meta16340){
this.p = p;
this.ch = ch;
this.meta16340 = meta16340;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16341,meta16340__$1){
var self__ = this;
var _16341__$1 = this;
return (new cljs.core.async.t_cljs$core$async16339(self__.p,self__.ch,meta16340__$1));
}));

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16341){
var self__ = this;
var _16341__$1 = this;
return self__.meta16340;
}));

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async16339.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async16339.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta16340], null);
}));

(cljs.core.async.t_cljs$core$async16339.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async16339.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16339");

(cljs.core.async.t_cljs$core$async16339.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async16339");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async16339.
 */
cljs.core.async.__GT_t_cljs$core$async16339 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async16339(p__$1,ch__$1,meta16340){
return (new cljs.core.async.t_cljs$core$async16339(p__$1,ch__$1,meta16340));
});

}

return (new cljs.core.async.t_cljs$core$async16339(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__16343 = arguments.length;
switch (G__16343) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14852__auto___16384 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16364){
var state_val_16365 = (state_16364[(1)]);
if((state_val_16365 === (7))){
var inst_16360 = (state_16364[(2)]);
var state_16364__$1 = state_16364;
var statearr_16366_16385 = state_16364__$1;
(statearr_16366_16385[(2)] = inst_16360);

(statearr_16366_16385[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (1))){
var state_16364__$1 = state_16364;
var statearr_16367_16386 = state_16364__$1;
(statearr_16367_16386[(2)] = null);

(statearr_16367_16386[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (4))){
var inst_16346 = (state_16364[(7)]);
var inst_16346__$1 = (state_16364[(2)]);
var inst_16347 = (inst_16346__$1 == null);
var state_16364__$1 = (function (){var statearr_16368 = state_16364;
(statearr_16368[(7)] = inst_16346__$1);

return statearr_16368;
})();
if(cljs.core.truth_(inst_16347)){
var statearr_16369_16387 = state_16364__$1;
(statearr_16369_16387[(1)] = (5));

} else {
var statearr_16370_16388 = state_16364__$1;
(statearr_16370_16388[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (6))){
var inst_16346 = (state_16364[(7)]);
var inst_16351 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_16346) : p.call(null,inst_16346));
var state_16364__$1 = state_16364;
if(cljs.core.truth_(inst_16351)){
var statearr_16371_16389 = state_16364__$1;
(statearr_16371_16389[(1)] = (8));

} else {
var statearr_16372_16390 = state_16364__$1;
(statearr_16372_16390[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (3))){
var inst_16362 = (state_16364[(2)]);
var state_16364__$1 = state_16364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16364__$1,inst_16362);
} else {
if((state_val_16365 === (2))){
var state_16364__$1 = state_16364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16364__$1,(4),ch);
} else {
if((state_val_16365 === (11))){
var inst_16354 = (state_16364[(2)]);
var state_16364__$1 = state_16364;
var statearr_16373_16391 = state_16364__$1;
(statearr_16373_16391[(2)] = inst_16354);

(statearr_16373_16391[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (9))){
var state_16364__$1 = state_16364;
var statearr_16374_16392 = state_16364__$1;
(statearr_16374_16392[(2)] = null);

(statearr_16374_16392[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (5))){
var inst_16349 = cljs.core.async.close_BANG_(out);
var state_16364__$1 = state_16364;
var statearr_16375_16393 = state_16364__$1;
(statearr_16375_16393[(2)] = inst_16349);

(statearr_16375_16393[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (10))){
var inst_16357 = (state_16364[(2)]);
var state_16364__$1 = (function (){var statearr_16376 = state_16364;
(statearr_16376[(8)] = inst_16357);

return statearr_16376;
})();
var statearr_16377_16394 = state_16364__$1;
(statearr_16377_16394[(2)] = null);

(statearr_16377_16394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16365 === (8))){
var inst_16346 = (state_16364[(7)]);
var state_16364__$1 = state_16364;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16364__$1,(11),out,inst_16346);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16378 = [null,null,null,null,null,null,null,null,null];
(statearr_16378[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16378[(1)] = (1));

return statearr_16378;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16364){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16364);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16379){var ex__14781__auto__ = e16379;
var statearr_16380_16395 = state_16364;
(statearr_16380_16395[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16364[(4)]))){
var statearr_16381_16396 = state_16364;
(statearr_16381_16396[(1)] = cljs.core.first((state_16364[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16397 = state_16364;
state_16364 = G__16397;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16364){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16382 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16382[(6)] = c__14852__auto___16384);

return statearr_16382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__16399 = arguments.length;
switch (G__16399) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16462){
var state_val_16463 = (state_16462[(1)]);
if((state_val_16463 === (7))){
var inst_16458 = (state_16462[(2)]);
var state_16462__$1 = state_16462;
var statearr_16464_16503 = state_16462__$1;
(statearr_16464_16503[(2)] = inst_16458);

(statearr_16464_16503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (20))){
var inst_16428 = (state_16462[(7)]);
var inst_16439 = (state_16462[(2)]);
var inst_16440 = cljs.core.next(inst_16428);
var inst_16414 = inst_16440;
var inst_16415 = null;
var inst_16416 = (0);
var inst_16417 = (0);
var state_16462__$1 = (function (){var statearr_16465 = state_16462;
(statearr_16465[(8)] = inst_16415);

(statearr_16465[(9)] = inst_16414);

(statearr_16465[(10)] = inst_16439);

(statearr_16465[(11)] = inst_16417);

(statearr_16465[(12)] = inst_16416);

return statearr_16465;
})();
var statearr_16466_16504 = state_16462__$1;
(statearr_16466_16504[(2)] = null);

(statearr_16466_16504[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (1))){
var state_16462__$1 = state_16462;
var statearr_16467_16505 = state_16462__$1;
(statearr_16467_16505[(2)] = null);

(statearr_16467_16505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (4))){
var inst_16403 = (state_16462[(13)]);
var inst_16403__$1 = (state_16462[(2)]);
var inst_16404 = (inst_16403__$1 == null);
var state_16462__$1 = (function (){var statearr_16468 = state_16462;
(statearr_16468[(13)] = inst_16403__$1);

return statearr_16468;
})();
if(cljs.core.truth_(inst_16404)){
var statearr_16469_16506 = state_16462__$1;
(statearr_16469_16506[(1)] = (5));

} else {
var statearr_16470_16507 = state_16462__$1;
(statearr_16470_16507[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (15))){
var state_16462__$1 = state_16462;
var statearr_16474_16508 = state_16462__$1;
(statearr_16474_16508[(2)] = null);

(statearr_16474_16508[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (21))){
var state_16462__$1 = state_16462;
var statearr_16475_16509 = state_16462__$1;
(statearr_16475_16509[(2)] = null);

(statearr_16475_16509[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (13))){
var inst_16415 = (state_16462[(8)]);
var inst_16414 = (state_16462[(9)]);
var inst_16417 = (state_16462[(11)]);
var inst_16416 = (state_16462[(12)]);
var inst_16424 = (state_16462[(2)]);
var inst_16425 = (inst_16417 + (1));
var tmp16471 = inst_16415;
var tmp16472 = inst_16414;
var tmp16473 = inst_16416;
var inst_16414__$1 = tmp16472;
var inst_16415__$1 = tmp16471;
var inst_16416__$1 = tmp16473;
var inst_16417__$1 = inst_16425;
var state_16462__$1 = (function (){var statearr_16476 = state_16462;
(statearr_16476[(14)] = inst_16424);

(statearr_16476[(8)] = inst_16415__$1);

(statearr_16476[(9)] = inst_16414__$1);

(statearr_16476[(11)] = inst_16417__$1);

(statearr_16476[(12)] = inst_16416__$1);

return statearr_16476;
})();
var statearr_16477_16510 = state_16462__$1;
(statearr_16477_16510[(2)] = null);

(statearr_16477_16510[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (22))){
var state_16462__$1 = state_16462;
var statearr_16478_16511 = state_16462__$1;
(statearr_16478_16511[(2)] = null);

(statearr_16478_16511[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (6))){
var inst_16403 = (state_16462[(13)]);
var inst_16412 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16403) : f.call(null,inst_16403));
var inst_16413 = cljs.core.seq(inst_16412);
var inst_16414 = inst_16413;
var inst_16415 = null;
var inst_16416 = (0);
var inst_16417 = (0);
var state_16462__$1 = (function (){var statearr_16479 = state_16462;
(statearr_16479[(8)] = inst_16415);

(statearr_16479[(9)] = inst_16414);

(statearr_16479[(11)] = inst_16417);

(statearr_16479[(12)] = inst_16416);

return statearr_16479;
})();
var statearr_16480_16512 = state_16462__$1;
(statearr_16480_16512[(2)] = null);

(statearr_16480_16512[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (17))){
var inst_16428 = (state_16462[(7)]);
var inst_16432 = cljs.core.chunk_first(inst_16428);
var inst_16433 = cljs.core.chunk_rest(inst_16428);
var inst_16434 = cljs.core.count(inst_16432);
var inst_16414 = inst_16433;
var inst_16415 = inst_16432;
var inst_16416 = inst_16434;
var inst_16417 = (0);
var state_16462__$1 = (function (){var statearr_16481 = state_16462;
(statearr_16481[(8)] = inst_16415);

(statearr_16481[(9)] = inst_16414);

(statearr_16481[(11)] = inst_16417);

(statearr_16481[(12)] = inst_16416);

return statearr_16481;
})();
var statearr_16482_16513 = state_16462__$1;
(statearr_16482_16513[(2)] = null);

(statearr_16482_16513[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (3))){
var inst_16460 = (state_16462[(2)]);
var state_16462__$1 = state_16462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16462__$1,inst_16460);
} else {
if((state_val_16463 === (12))){
var inst_16448 = (state_16462[(2)]);
var state_16462__$1 = state_16462;
var statearr_16483_16514 = state_16462__$1;
(statearr_16483_16514[(2)] = inst_16448);

(statearr_16483_16514[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (2))){
var state_16462__$1 = state_16462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16462__$1,(4),in$);
} else {
if((state_val_16463 === (23))){
var inst_16456 = (state_16462[(2)]);
var state_16462__$1 = state_16462;
var statearr_16484_16515 = state_16462__$1;
(statearr_16484_16515[(2)] = inst_16456);

(statearr_16484_16515[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (19))){
var inst_16443 = (state_16462[(2)]);
var state_16462__$1 = state_16462;
var statearr_16485_16516 = state_16462__$1;
(statearr_16485_16516[(2)] = inst_16443);

(statearr_16485_16516[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (11))){
var inst_16414 = (state_16462[(9)]);
var inst_16428 = (state_16462[(7)]);
var inst_16428__$1 = cljs.core.seq(inst_16414);
var state_16462__$1 = (function (){var statearr_16486 = state_16462;
(statearr_16486[(7)] = inst_16428__$1);

return statearr_16486;
})();
if(inst_16428__$1){
var statearr_16487_16517 = state_16462__$1;
(statearr_16487_16517[(1)] = (14));

} else {
var statearr_16488_16518 = state_16462__$1;
(statearr_16488_16518[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (9))){
var inst_16450 = (state_16462[(2)]);
var inst_16451 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_16462__$1 = (function (){var statearr_16489 = state_16462;
(statearr_16489[(15)] = inst_16450);

return statearr_16489;
})();
if(cljs.core.truth_(inst_16451)){
var statearr_16490_16519 = state_16462__$1;
(statearr_16490_16519[(1)] = (21));

} else {
var statearr_16491_16520 = state_16462__$1;
(statearr_16491_16520[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (5))){
var inst_16406 = cljs.core.async.close_BANG_(out);
var state_16462__$1 = state_16462;
var statearr_16492_16521 = state_16462__$1;
(statearr_16492_16521[(2)] = inst_16406);

(statearr_16492_16521[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (14))){
var inst_16428 = (state_16462[(7)]);
var inst_16430 = cljs.core.chunked_seq_QMARK_(inst_16428);
var state_16462__$1 = state_16462;
if(inst_16430){
var statearr_16493_16522 = state_16462__$1;
(statearr_16493_16522[(1)] = (17));

} else {
var statearr_16494_16523 = state_16462__$1;
(statearr_16494_16523[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (16))){
var inst_16446 = (state_16462[(2)]);
var state_16462__$1 = state_16462;
var statearr_16495_16524 = state_16462__$1;
(statearr_16495_16524[(2)] = inst_16446);

(statearr_16495_16524[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16463 === (10))){
var inst_16415 = (state_16462[(8)]);
var inst_16417 = (state_16462[(11)]);
var inst_16422 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16415,inst_16417);
var state_16462__$1 = state_16462;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16462__$1,(13),out,inst_16422);
} else {
if((state_val_16463 === (18))){
var inst_16428 = (state_16462[(7)]);
var inst_16437 = cljs.core.first(inst_16428);
var state_16462__$1 = state_16462;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16462__$1,(20),out,inst_16437);
} else {
if((state_val_16463 === (8))){
var inst_16417 = (state_16462[(11)]);
var inst_16416 = (state_16462[(12)]);
var inst_16419 = (inst_16417 < inst_16416);
var inst_16420 = inst_16419;
var state_16462__$1 = state_16462;
if(cljs.core.truth_(inst_16420)){
var statearr_16496_16525 = state_16462__$1;
(statearr_16496_16525[(1)] = (10));

} else {
var statearr_16497_16526 = state_16462__$1;
(statearr_16497_16526[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14778__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14778__auto____0 = (function (){
var statearr_16498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16498[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14778__auto__);

(statearr_16498[(1)] = (1));

return statearr_16498;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14778__auto____1 = (function (state_16462){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16462);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16499){var ex__14781__auto__ = e16499;
var statearr_16500_16527 = state_16462;
(statearr_16500_16527[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16462[(4)]))){
var statearr_16501_16528 = state_16462;
(statearr_16501_16528[(1)] = cljs.core.first((state_16462[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16529 = state_16462;
state_16462 = G__16529;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14778__auto__ = function(state_16462){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14778__auto____1.call(this,state_16462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14778__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14778__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16502 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16502[(6)] = c__14852__auto__);

return statearr_16502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__16531 = arguments.length;
switch (G__16531) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__16534 = arguments.length;
switch (G__16534) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__16537 = arguments.length;
switch (G__16537) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14852__auto___16585 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16561){
var state_val_16562 = (state_16561[(1)]);
if((state_val_16562 === (7))){
var inst_16556 = (state_16561[(2)]);
var state_16561__$1 = state_16561;
var statearr_16563_16586 = state_16561__$1;
(statearr_16563_16586[(2)] = inst_16556);

(statearr_16563_16586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16562 === (1))){
var inst_16538 = null;
var state_16561__$1 = (function (){var statearr_16564 = state_16561;
(statearr_16564[(7)] = inst_16538);

return statearr_16564;
})();
var statearr_16565_16587 = state_16561__$1;
(statearr_16565_16587[(2)] = null);

(statearr_16565_16587[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16562 === (4))){
var inst_16541 = (state_16561[(8)]);
var inst_16541__$1 = (state_16561[(2)]);
var inst_16542 = (inst_16541__$1 == null);
var inst_16543 = cljs.core.not(inst_16542);
var state_16561__$1 = (function (){var statearr_16566 = state_16561;
(statearr_16566[(8)] = inst_16541__$1);

return statearr_16566;
})();
if(inst_16543){
var statearr_16567_16588 = state_16561__$1;
(statearr_16567_16588[(1)] = (5));

} else {
var statearr_16568_16589 = state_16561__$1;
(statearr_16568_16589[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16562 === (6))){
var state_16561__$1 = state_16561;
var statearr_16569_16590 = state_16561__$1;
(statearr_16569_16590[(2)] = null);

(statearr_16569_16590[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16562 === (3))){
var inst_16558 = (state_16561[(2)]);
var inst_16559 = cljs.core.async.close_BANG_(out);
var state_16561__$1 = (function (){var statearr_16570 = state_16561;
(statearr_16570[(9)] = inst_16558);

return statearr_16570;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_16561__$1,inst_16559);
} else {
if((state_val_16562 === (2))){
var state_16561__$1 = state_16561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16561__$1,(4),ch);
} else {
if((state_val_16562 === (11))){
var inst_16541 = (state_16561[(8)]);
var inst_16550 = (state_16561[(2)]);
var inst_16538 = inst_16541;
var state_16561__$1 = (function (){var statearr_16571 = state_16561;
(statearr_16571[(10)] = inst_16550);

(statearr_16571[(7)] = inst_16538);

return statearr_16571;
})();
var statearr_16572_16591 = state_16561__$1;
(statearr_16572_16591[(2)] = null);

(statearr_16572_16591[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16562 === (9))){
var inst_16541 = (state_16561[(8)]);
var state_16561__$1 = state_16561;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16561__$1,(11),out,inst_16541);
} else {
if((state_val_16562 === (5))){
var inst_16538 = (state_16561[(7)]);
var inst_16541 = (state_16561[(8)]);
var inst_16545 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16541,inst_16538);
var state_16561__$1 = state_16561;
if(inst_16545){
var statearr_16574_16592 = state_16561__$1;
(statearr_16574_16592[(1)] = (8));

} else {
var statearr_16575_16593 = state_16561__$1;
(statearr_16575_16593[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16562 === (10))){
var inst_16553 = (state_16561[(2)]);
var state_16561__$1 = state_16561;
var statearr_16576_16594 = state_16561__$1;
(statearr_16576_16594[(2)] = inst_16553);

(statearr_16576_16594[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16562 === (8))){
var inst_16538 = (state_16561[(7)]);
var tmp16573 = inst_16538;
var inst_16538__$1 = tmp16573;
var state_16561__$1 = (function (){var statearr_16577 = state_16561;
(statearr_16577[(7)] = inst_16538__$1);

return statearr_16577;
})();
var statearr_16578_16595 = state_16561__$1;
(statearr_16578_16595[(2)] = null);

(statearr_16578_16595[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16579 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16579[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16579[(1)] = (1));

return statearr_16579;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16561){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16561);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16580){var ex__14781__auto__ = e16580;
var statearr_16581_16596 = state_16561;
(statearr_16581_16596[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16561[(4)]))){
var statearr_16582_16597 = state_16561;
(statearr_16582_16597[(1)] = cljs.core.first((state_16561[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16598 = state_16561;
state_16561 = G__16598;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16561){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16583 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16583[(6)] = c__14852__auto___16585);

return statearr_16583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__16600 = arguments.length;
switch (G__16600) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14852__auto___16667 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16638){
var state_val_16639 = (state_16638[(1)]);
if((state_val_16639 === (7))){
var inst_16634 = (state_16638[(2)]);
var state_16638__$1 = state_16638;
var statearr_16640_16668 = state_16638__$1;
(statearr_16640_16668[(2)] = inst_16634);

(statearr_16640_16668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (1))){
var inst_16601 = (new Array(n));
var inst_16602 = inst_16601;
var inst_16603 = (0);
var state_16638__$1 = (function (){var statearr_16641 = state_16638;
(statearr_16641[(7)] = inst_16603);

(statearr_16641[(8)] = inst_16602);

return statearr_16641;
})();
var statearr_16642_16669 = state_16638__$1;
(statearr_16642_16669[(2)] = null);

(statearr_16642_16669[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (4))){
var inst_16606 = (state_16638[(9)]);
var inst_16606__$1 = (state_16638[(2)]);
var inst_16607 = (inst_16606__$1 == null);
var inst_16608 = cljs.core.not(inst_16607);
var state_16638__$1 = (function (){var statearr_16643 = state_16638;
(statearr_16643[(9)] = inst_16606__$1);

return statearr_16643;
})();
if(inst_16608){
var statearr_16644_16670 = state_16638__$1;
(statearr_16644_16670[(1)] = (5));

} else {
var statearr_16645_16671 = state_16638__$1;
(statearr_16645_16671[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (15))){
var inst_16628 = (state_16638[(2)]);
var state_16638__$1 = state_16638;
var statearr_16646_16672 = state_16638__$1;
(statearr_16646_16672[(2)] = inst_16628);

(statearr_16646_16672[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (13))){
var state_16638__$1 = state_16638;
var statearr_16647_16673 = state_16638__$1;
(statearr_16647_16673[(2)] = null);

(statearr_16647_16673[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (6))){
var inst_16603 = (state_16638[(7)]);
var inst_16624 = (inst_16603 > (0));
var state_16638__$1 = state_16638;
if(cljs.core.truth_(inst_16624)){
var statearr_16648_16674 = state_16638__$1;
(statearr_16648_16674[(1)] = (12));

} else {
var statearr_16649_16675 = state_16638__$1;
(statearr_16649_16675[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (3))){
var inst_16636 = (state_16638[(2)]);
var state_16638__$1 = state_16638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16638__$1,inst_16636);
} else {
if((state_val_16639 === (12))){
var inst_16602 = (state_16638[(8)]);
var inst_16626 = cljs.core.vec(inst_16602);
var state_16638__$1 = state_16638;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16638__$1,(15),out,inst_16626);
} else {
if((state_val_16639 === (2))){
var state_16638__$1 = state_16638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16638__$1,(4),ch);
} else {
if((state_val_16639 === (11))){
var inst_16618 = (state_16638[(2)]);
var inst_16619 = (new Array(n));
var inst_16602 = inst_16619;
var inst_16603 = (0);
var state_16638__$1 = (function (){var statearr_16650 = state_16638;
(statearr_16650[(7)] = inst_16603);

(statearr_16650[(10)] = inst_16618);

(statearr_16650[(8)] = inst_16602);

return statearr_16650;
})();
var statearr_16651_16676 = state_16638__$1;
(statearr_16651_16676[(2)] = null);

(statearr_16651_16676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (9))){
var inst_16602 = (state_16638[(8)]);
var inst_16616 = cljs.core.vec(inst_16602);
var state_16638__$1 = state_16638;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16638__$1,(11),out,inst_16616);
} else {
if((state_val_16639 === (5))){
var inst_16606 = (state_16638[(9)]);
var inst_16603 = (state_16638[(7)]);
var inst_16611 = (state_16638[(11)]);
var inst_16602 = (state_16638[(8)]);
var inst_16610 = (inst_16602[inst_16603] = inst_16606);
var inst_16611__$1 = (inst_16603 + (1));
var inst_16612 = (inst_16611__$1 < n);
var state_16638__$1 = (function (){var statearr_16652 = state_16638;
(statearr_16652[(12)] = inst_16610);

(statearr_16652[(11)] = inst_16611__$1);

return statearr_16652;
})();
if(cljs.core.truth_(inst_16612)){
var statearr_16653_16677 = state_16638__$1;
(statearr_16653_16677[(1)] = (8));

} else {
var statearr_16654_16678 = state_16638__$1;
(statearr_16654_16678[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (14))){
var inst_16631 = (state_16638[(2)]);
var inst_16632 = cljs.core.async.close_BANG_(out);
var state_16638__$1 = (function (){var statearr_16656 = state_16638;
(statearr_16656[(13)] = inst_16631);

return statearr_16656;
})();
var statearr_16657_16679 = state_16638__$1;
(statearr_16657_16679[(2)] = inst_16632);

(statearr_16657_16679[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (10))){
var inst_16622 = (state_16638[(2)]);
var state_16638__$1 = state_16638;
var statearr_16658_16680 = state_16638__$1;
(statearr_16658_16680[(2)] = inst_16622);

(statearr_16658_16680[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16639 === (8))){
var inst_16611 = (state_16638[(11)]);
var inst_16602 = (state_16638[(8)]);
var tmp16655 = inst_16602;
var inst_16602__$1 = tmp16655;
var inst_16603 = inst_16611;
var state_16638__$1 = (function (){var statearr_16659 = state_16638;
(statearr_16659[(7)] = inst_16603);

(statearr_16659[(8)] = inst_16602__$1);

return statearr_16659;
})();
var statearr_16660_16681 = state_16638__$1;
(statearr_16660_16681[(2)] = null);

(statearr_16660_16681[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16661 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16661[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16661[(1)] = (1));

return statearr_16661;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16638){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16638);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16662){var ex__14781__auto__ = e16662;
var statearr_16663_16682 = state_16638;
(statearr_16663_16682[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16638[(4)]))){
var statearr_16664_16683 = state_16638;
(statearr_16664_16683[(1)] = cljs.core.first((state_16638[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16684 = state_16638;
state_16638 = G__16684;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16638){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16665 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16665[(6)] = c__14852__auto___16667);

return statearr_16665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__16686 = arguments.length;
switch (G__16686) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__14852__auto___16764 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_16731){
var state_val_16732 = (state_16731[(1)]);
if((state_val_16732 === (7))){
var inst_16727 = (state_16731[(2)]);
var state_16731__$1 = state_16731;
var statearr_16733_16765 = state_16731__$1;
(statearr_16733_16765[(2)] = inst_16727);

(statearr_16733_16765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (1))){
var inst_16687 = [];
var inst_16688 = inst_16687;
var inst_16689 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_16731__$1 = (function (){var statearr_16734 = state_16731;
(statearr_16734[(7)] = inst_16688);

(statearr_16734[(8)] = inst_16689);

return statearr_16734;
})();
var statearr_16735_16766 = state_16731__$1;
(statearr_16735_16766[(2)] = null);

(statearr_16735_16766[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (4))){
var inst_16692 = (state_16731[(9)]);
var inst_16692__$1 = (state_16731[(2)]);
var inst_16693 = (inst_16692__$1 == null);
var inst_16694 = cljs.core.not(inst_16693);
var state_16731__$1 = (function (){var statearr_16736 = state_16731;
(statearr_16736[(9)] = inst_16692__$1);

return statearr_16736;
})();
if(inst_16694){
var statearr_16737_16767 = state_16731__$1;
(statearr_16737_16767[(1)] = (5));

} else {
var statearr_16738_16768 = state_16731__$1;
(statearr_16738_16768[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (15))){
var inst_16688 = (state_16731[(7)]);
var inst_16719 = cljs.core.vec(inst_16688);
var state_16731__$1 = state_16731;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16731__$1,(18),out,inst_16719);
} else {
if((state_val_16732 === (13))){
var inst_16714 = (state_16731[(2)]);
var state_16731__$1 = state_16731;
var statearr_16739_16769 = state_16731__$1;
(statearr_16739_16769[(2)] = inst_16714);

(statearr_16739_16769[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (6))){
var inst_16688 = (state_16731[(7)]);
var inst_16716 = inst_16688.length;
var inst_16717 = (inst_16716 > (0));
var state_16731__$1 = state_16731;
if(cljs.core.truth_(inst_16717)){
var statearr_16740_16770 = state_16731__$1;
(statearr_16740_16770[(1)] = (15));

} else {
var statearr_16741_16771 = state_16731__$1;
(statearr_16741_16771[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (17))){
var inst_16724 = (state_16731[(2)]);
var inst_16725 = cljs.core.async.close_BANG_(out);
var state_16731__$1 = (function (){var statearr_16742 = state_16731;
(statearr_16742[(10)] = inst_16724);

return statearr_16742;
})();
var statearr_16743_16772 = state_16731__$1;
(statearr_16743_16772[(2)] = inst_16725);

(statearr_16743_16772[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (3))){
var inst_16729 = (state_16731[(2)]);
var state_16731__$1 = state_16731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16731__$1,inst_16729);
} else {
if((state_val_16732 === (12))){
var inst_16688 = (state_16731[(7)]);
var inst_16707 = cljs.core.vec(inst_16688);
var state_16731__$1 = state_16731;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16731__$1,(14),out,inst_16707);
} else {
if((state_val_16732 === (2))){
var state_16731__$1 = state_16731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16731__$1,(4),ch);
} else {
if((state_val_16732 === (11))){
var inst_16688 = (state_16731[(7)]);
var inst_16696 = (state_16731[(11)]);
var inst_16692 = (state_16731[(9)]);
var inst_16704 = inst_16688.push(inst_16692);
var tmp16744 = inst_16688;
var inst_16688__$1 = tmp16744;
var inst_16689 = inst_16696;
var state_16731__$1 = (function (){var statearr_16745 = state_16731;
(statearr_16745[(7)] = inst_16688__$1);

(statearr_16745[(8)] = inst_16689);

(statearr_16745[(12)] = inst_16704);

return statearr_16745;
})();
var statearr_16746_16773 = state_16731__$1;
(statearr_16746_16773[(2)] = null);

(statearr_16746_16773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (9))){
var inst_16689 = (state_16731[(8)]);
var inst_16700 = cljs.core.keyword_identical_QMARK_(inst_16689,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_16731__$1 = state_16731;
var statearr_16747_16774 = state_16731__$1;
(statearr_16747_16774[(2)] = inst_16700);

(statearr_16747_16774[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (5))){
var inst_16697 = (state_16731[(13)]);
var inst_16696 = (state_16731[(11)]);
var inst_16692 = (state_16731[(9)]);
var inst_16689 = (state_16731[(8)]);
var inst_16696__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_16692) : f.call(null,inst_16692));
var inst_16697__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16696__$1,inst_16689);
var state_16731__$1 = (function (){var statearr_16748 = state_16731;
(statearr_16748[(13)] = inst_16697__$1);

(statearr_16748[(11)] = inst_16696__$1);

return statearr_16748;
})();
if(inst_16697__$1){
var statearr_16749_16775 = state_16731__$1;
(statearr_16749_16775[(1)] = (8));

} else {
var statearr_16750_16776 = state_16731__$1;
(statearr_16750_16776[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (14))){
var inst_16696 = (state_16731[(11)]);
var inst_16692 = (state_16731[(9)]);
var inst_16709 = (state_16731[(2)]);
var inst_16710 = [];
var inst_16711 = inst_16710.push(inst_16692);
var inst_16688 = inst_16710;
var inst_16689 = inst_16696;
var state_16731__$1 = (function (){var statearr_16751 = state_16731;
(statearr_16751[(14)] = inst_16709);

(statearr_16751[(7)] = inst_16688);

(statearr_16751[(15)] = inst_16711);

(statearr_16751[(8)] = inst_16689);

return statearr_16751;
})();
var statearr_16752_16777 = state_16731__$1;
(statearr_16752_16777[(2)] = null);

(statearr_16752_16777[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (16))){
var state_16731__$1 = state_16731;
var statearr_16753_16778 = state_16731__$1;
(statearr_16753_16778[(2)] = null);

(statearr_16753_16778[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (10))){
var inst_16702 = (state_16731[(2)]);
var state_16731__$1 = state_16731;
if(cljs.core.truth_(inst_16702)){
var statearr_16754_16779 = state_16731__$1;
(statearr_16754_16779[(1)] = (11));

} else {
var statearr_16755_16780 = state_16731__$1;
(statearr_16755_16780[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (18))){
var inst_16721 = (state_16731[(2)]);
var state_16731__$1 = state_16731;
var statearr_16756_16781 = state_16731__$1;
(statearr_16756_16781[(2)] = inst_16721);

(statearr_16756_16781[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16732 === (8))){
var inst_16697 = (state_16731[(13)]);
var state_16731__$1 = state_16731;
var statearr_16757_16782 = state_16731__$1;
(statearr_16757_16782[(2)] = inst_16697);

(statearr_16757_16782[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__14778__auto__ = null;
var cljs$core$async$state_machine__14778__auto____0 = (function (){
var statearr_16758 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16758[(0)] = cljs$core$async$state_machine__14778__auto__);

(statearr_16758[(1)] = (1));

return statearr_16758;
});
var cljs$core$async$state_machine__14778__auto____1 = (function (state_16731){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_16731);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e16759){var ex__14781__auto__ = e16759;
var statearr_16760_16783 = state_16731;
(statearr_16760_16783[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_16731[(4)]))){
var statearr_16761_16784 = state_16731;
(statearr_16761_16784[(1)] = cljs.core.first((state_16731[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__16785 = state_16731;
state_16731 = G__16785;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
cljs$core$async$state_machine__14778__auto__ = function(state_16731){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14778__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14778__auto____1.call(this,state_16731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14778__auto____0;
cljs$core$async$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14778__auto____1;
return cljs$core$async$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_16762 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_16762[(6)] = c__14852__auto___16764);

return statearr_16762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

