// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__75821_75990 = cljs.core.seq(servers);
var chunk__75822_75991 = null;
var count__75823_75992 = (0);
var i__75824_75993 = (0);
while(true){
if((i__75824_75993 < count__75823_75992)){
var server_75994 = chunk__75822_75991.cljs$core$IIndexed$_nth$arity$2(null,i__75824_75993);
var healthcheck_uri_75995 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_75994),"/fdb/health"].join('');
var resp_chan_75996 = fluree.db.util.xhttp.post_json(healthcheck_uri_75995,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__14852__auto___75997 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___75997,healthcheck_uri_75995,resp_chan_75996,server_75994){
return (function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = ((function (seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___75997,healthcheck_uri_75995,resp_chan_75996,server_75994){
return (function (state_75885){
var state_val_75886 = (state_75885[(1)]);
if((state_val_75886 === (1))){
var state_75885__$1 = state_75885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75885__$1,(2),resp_chan_75996);
} else {
if((state_val_75886 === (2))){
var inst_75874 = (state_75885[(7)]);
var inst_75874__$1 = (state_75885[(2)]);
var inst_75875 = fluree.db.util.core.exception_QMARK_(inst_75874__$1);
var state_75885__$1 = (function (){var statearr_75887 = state_75885;
(statearr_75887[(7)] = inst_75874__$1);

return statearr_75887;
})();
if(inst_75875){
var statearr_75888_75998 = state_75885__$1;
(statearr_75888_75998[(1)] = (3));

} else {
var statearr_75889_75999 = state_75885__$1;
(statearr_75889_75999[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75886 === (3))){
var inst_75874 = (state_75885[(7)]);
var inst_75877 = cljs.core.ex_message(inst_75874);
var inst_75878 = cljs.core.ex_data(inst_75874);
var inst_75879 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_75877,inst_75878], 0));
var state_75885__$1 = state_75885;
var statearr_75890_76000 = state_75885__$1;
(statearr_75890_76000[(2)] = inst_75879);

(statearr_75890_76000[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75886 === (4))){
var inst_75881 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_75994);
var state_75885__$1 = state_75885;
var statearr_75891_76001 = state_75885__$1;
(statearr_75891_76001[(2)] = inst_75881);

(statearr_75891_76001[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75886 === (5))){
var inst_75883 = (state_75885[(2)]);
var state_75885__$1 = state_75885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75885__$1,inst_75883);
} else {
return null;
}
}
}
}
}
});})(seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___75997,healthcheck_uri_75995,resp_chan_75996,server_75994))
;
return ((function (seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,switch__14777__auto__,c__14852__auto___75997,healthcheck_uri_75995,resp_chan_75996,server_75994){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0 = (function (){
var statearr_75892 = [null,null,null,null,null,null,null,null];
(statearr_75892[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__);

(statearr_75892[(1)] = (1));

return statearr_75892;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1 = (function (state_75885){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_75885);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e75893){var ex__14781__auto__ = e75893;
var statearr_75894_76002 = state_75885;
(statearr_75894_76002[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_75885[(4)]))){
var statearr_75895_76003 = state_75885;
(statearr_75895_76003[(1)] = cljs.core.first((state_75885[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76004 = state_75885;
state_75885 = G__76004;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__ = function(state_75885){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1.call(this,state_75885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__;
})()
;})(seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,switch__14777__auto__,c__14852__auto___75997,healthcheck_uri_75995,resp_chan_75996,server_75994))
})();
var state__14854__auto__ = (function (){var statearr_75896 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_75896[(6)] = c__14852__auto___75997);

return statearr_75896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
});})(seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___75997,healthcheck_uri_75995,resp_chan_75996,server_75994))
);



var G__76005 = seq__75821_75990;
var G__76006 = chunk__75822_75991;
var G__76007 = count__75823_75992;
var G__76008 = (i__75824_75993 + (1));
seq__75821_75990 = G__76005;
chunk__75822_75991 = G__76006;
count__75823_75992 = G__76007;
i__75824_75993 = G__76008;
continue;
} else {
var temp__5753__auto___76009 = cljs.core.seq(seq__75821_75990);
if(temp__5753__auto___76009){
var seq__75821_76010__$1 = temp__5753__auto___76009;
if(cljs.core.chunked_seq_QMARK_(seq__75821_76010__$1)){
var c__4649__auto___76011 = cljs.core.chunk_first(seq__75821_76010__$1);
var G__76012 = cljs.core.chunk_rest(seq__75821_76010__$1);
var G__76013 = c__4649__auto___76011;
var G__76014 = cljs.core.count(c__4649__auto___76011);
var G__76015 = (0);
seq__75821_75990 = G__76012;
chunk__75822_75991 = G__76013;
count__75823_75992 = G__76014;
i__75824_75993 = G__76015;
continue;
} else {
var server_76016 = cljs.core.first(seq__75821_76010__$1);
var healthcheck_uri_76017 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_76016),"/fdb/health"].join('');
var resp_chan_76018 = fluree.db.util.xhttp.post_json(healthcheck_uri_76017,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__14852__auto___76019 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___76019,healthcheck_uri_76017,resp_chan_76018,server_76016,seq__75821_76010__$1,temp__5753__auto___76009){
return (function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = ((function (seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___76019,healthcheck_uri_76017,resp_chan_76018,server_76016,seq__75821_76010__$1,temp__5753__auto___76009){
return (function (state_75909){
var state_val_75910 = (state_75909[(1)]);
if((state_val_75910 === (1))){
var state_75909__$1 = state_75909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75909__$1,(2),resp_chan_76018);
} else {
if((state_val_75910 === (2))){
var inst_75898 = (state_75909[(7)]);
var inst_75898__$1 = (state_75909[(2)]);
var inst_75899 = fluree.db.util.core.exception_QMARK_(inst_75898__$1);
var state_75909__$1 = (function (){var statearr_75911 = state_75909;
(statearr_75911[(7)] = inst_75898__$1);

return statearr_75911;
})();
if(inst_75899){
var statearr_75912_76020 = state_75909__$1;
(statearr_75912_76020[(1)] = (3));

} else {
var statearr_75913_76021 = state_75909__$1;
(statearr_75913_76021[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75910 === (3))){
var inst_75898 = (state_75909[(7)]);
var inst_75901 = cljs.core.ex_message(inst_75898);
var inst_75902 = cljs.core.ex_data(inst_75898);
var inst_75903 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_75901,inst_75902], 0));
var state_75909__$1 = state_75909;
var statearr_75914_76022 = state_75909__$1;
(statearr_75914_76022[(2)] = inst_75903);

(statearr_75914_76022[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75910 === (4))){
var inst_75905 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_76016);
var state_75909__$1 = state_75909;
var statearr_75915_76023 = state_75909__$1;
(statearr_75915_76023[(2)] = inst_75905);

(statearr_75915_76023[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75910 === (5))){
var inst_75907 = (state_75909[(2)]);
var state_75909__$1 = state_75909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75909__$1,inst_75907);
} else {
return null;
}
}
}
}
}
});})(seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___76019,healthcheck_uri_76017,resp_chan_76018,server_76016,seq__75821_76010__$1,temp__5753__auto___76009))
;
return ((function (seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,switch__14777__auto__,c__14852__auto___76019,healthcheck_uri_76017,resp_chan_76018,server_76016,seq__75821_76010__$1,temp__5753__auto___76009){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0 = (function (){
var statearr_75916 = [null,null,null,null,null,null,null,null];
(statearr_75916[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__);

(statearr_75916[(1)] = (1));

return statearr_75916;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1 = (function (state_75909){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_75909);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e75917){var ex__14781__auto__ = e75917;
var statearr_75918_76024 = state_75909;
(statearr_75918_76024[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_75909[(4)]))){
var statearr_75919_76025 = state_75909;
(statearr_75919_76025[(1)] = cljs.core.first((state_75909[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76026 = state_75909;
state_75909 = G__76026;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__ = function(state_75909){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1.call(this,state_75909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__;
})()
;})(seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,switch__14777__auto__,c__14852__auto___76019,healthcheck_uri_76017,resp_chan_76018,server_76016,seq__75821_76010__$1,temp__5753__auto___76009))
})();
var state__14854__auto__ = (function (){var statearr_75920 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_75920[(6)] = c__14852__auto___76019);

return statearr_75920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
});})(seq__75821_75990,chunk__75822_75991,count__75823_75992,i__75824_75993,c__14852__auto___76019,healthcheck_uri_76017,resp_chan_76018,server_76016,seq__75821_76010__$1,temp__5753__auto___76009))
);



var G__76027 = cljs.core.next(seq__75821_76010__$1);
var G__76028 = null;
var G__76029 = (0);
var G__76030 = (0);
seq__75821_75990 = G__76027;
chunk__75822_75991 = G__76028;
count__75823_75992 = G__76029;
i__75824_75993 = G__76030;
continue;
}
} else {
}
}
break;
}

var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_75964){
var state_val_75965 = (state_75964[(1)]);
if((state_val_75965 === (7))){
var inst_75936 = (state_75964[(7)]);
var inst_75943 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75936,cljs.core.cst$kw$default);
var state_75964__$1 = state_75964;
if(inst_75943){
var statearr_75966_76031 = state_75964__$1;
(statearr_75966_76031[(1)] = (9));

} else {
var statearr_75967_76032 = state_75964__$1;
(statearr_75967_76032[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (1))){
var inst_75929 = (state_75964[(8)]);
var inst_75928 = (state_75964[(9)]);
var inst_75928__$1 = promise_chan;
var inst_75929__$1 = cljs.core.async.timeout((60000));
var inst_75930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75931 = [inst_75928__$1,inst_75929__$1];
var inst_75932 = (new cljs.core.PersistentVector(null,2,(5),inst_75930,inst_75931,null));
var state_75964__$1 = (function (){var statearr_75968 = state_75964;
(statearr_75968[(8)] = inst_75929__$1);

(statearr_75968[(9)] = inst_75928__$1);

return statearr_75968;
})();
return cljs.core.async.ioc_alts_BANG_(state_75964__$1,(2),inst_75932);
} else {
if((state_val_75965 === (4))){
var inst_75929 = (state_75964[(8)]);
var inst_75936 = (state_75964[(7)]);
var inst_75940 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75936,inst_75929);
var state_75964__$1 = state_75964;
if(inst_75940){
var statearr_75969_76033 = state_75964__$1;
(statearr_75969_76033[(1)] = (6));

} else {
var statearr_75970_76034 = state_75964__$1;
(statearr_75970_76034[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (13))){
var state_75964__$1 = state_75964;
var statearr_75971_76035 = state_75964__$1;
(statearr_75971_76035[(2)] = null);

(statearr_75971_76035[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (6))){
var state_75964__$1 = state_75964;
var statearr_75972_76036 = state_75964__$1;
(statearr_75972_76036[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_75972_76036[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (3))){
var state_75964__$1 = state_75964;
var statearr_75973_76037 = state_75964__$1;
(statearr_75973_76037[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_75973_76037[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (12))){
var inst_75954 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_75955 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75956 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_75957 = cljs.core.PersistentHashMap.fromArrays(inst_75955,inst_75956);
var inst_75958 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_75957);
var inst_75959 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_75958);
var state_75964__$1 = (function (){var statearr_75974 = state_75964;
(statearr_75974[(10)] = inst_75954);

return statearr_75974;
})();
var statearr_75975_76038 = state_75964__$1;
(statearr_75975_76038[(2)] = inst_75959);

(statearr_75975_76038[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (2))){
var inst_75928 = (state_75964[(9)]);
var inst_75936 = (state_75964[(7)]);
var inst_75934 = (state_75964[(2)]);
var inst_75935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75934,(0),null);
var inst_75936__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75934,(1),null);
var inst_75937 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75936__$1,inst_75928);
var state_75964__$1 = (function (){var statearr_75976 = state_75964;
(statearr_75976[(7)] = inst_75936__$1);

(statearr_75976[(11)] = inst_75935);

return statearr_75976;
})();
if(inst_75937){
var statearr_75977_76039 = state_75964__$1;
(statearr_75977_76039[(1)] = (3));

} else {
var statearr_75978_76040 = state_75964__$1;
(statearr_75978_76040[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (11))){
var inst_75947 = (state_75964[(2)]);
var state_75964__$1 = state_75964;
var statearr_75979_76041 = state_75964__$1;
(statearr_75979_76041[(2)] = inst_75947);

(statearr_75979_76041[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (9))){
var inst_75935 = (state_75964[(11)]);
var state_75964__$1 = state_75964;
var statearr_75980_76042 = state_75964__$1;
(statearr_75980_76042[(2)] = inst_75935);

(statearr_75980_76042[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (5))){
var inst_75951 = (state_75964[(2)]);
var inst_75952 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_75951);
var state_75964__$1 = state_75964;
if(inst_75952){
var statearr_75981_76043 = state_75964__$1;
(statearr_75981_76043[(1)] = (12));

} else {
var statearr_75982_76044 = state_75964__$1;
(statearr_75982_76044[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (14))){
var inst_75962 = (state_75964[(2)]);
var state_75964__$1 = state_75964;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75964__$1,inst_75962);
} else {
if((state_val_75965 === (10))){
var state_75964__$1 = state_75964;
var statearr_75983_76045 = state_75964__$1;
(statearr_75983_76045[(2)] = null);

(statearr_75983_76045[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75965 === (8))){
var inst_75949 = (state_75964[(2)]);
var state_75964__$1 = state_75964;
var statearr_75984_76046 = state_75964__$1;
(statearr_75984_76046[(2)] = inst_75949);

(statearr_75984_76046[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0 = (function (){
var statearr_75985 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75985[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__);

(statearr_75985[(1)] = (1));

return statearr_75985;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1 = (function (state_75964){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_75964);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e75986){var ex__14781__auto__ = e75986;
var statearr_75987_76047 = state_75964;
(statearr_75987_76047[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_75964[(4)]))){
var statearr_75988_76048 = state_75964;
(statearr_75988_76048[(1)] = cljs.core.first((state_75964[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76049 = state_75964;
state_75964 = G__76049;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__ = function(state_75964){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1.call(this,state_75964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_75989 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_75989[(6)] = c__14852__auto__);

return statearr_75989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_76093){
var state_val_76094 = (state_76093[(1)]);
if((state_val_76094 === (7))){
var state_76093__$1 = state_76093;
var statearr_76095_76121 = state_76093__$1;
(statearr_76095_76121[(2)] = null);

(statearr_76095_76121[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (1))){
var state_76093__$1 = state_76093;
var statearr_76096_76122 = state_76093__$1;
(statearr_76096_76122[(2)] = null);

(statearr_76096_76122[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (4))){
var inst_76050 = (state_76093[(2)]);
var state_76093__$1 = state_76093;
var statearr_76097_76123 = state_76093__$1;
(statearr_76097_76123[(2)] = inst_76050);

(statearr_76097_76123[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (6))){
var inst_76072 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_76093__$1 = state_76093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76093__$1,(9),inst_76072);
} else {
if((state_val_76094 === (3))){
var inst_76091 = (state_76093[(2)]);
var state_76093__$1 = state_76093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76093__$1,inst_76091);
} else {
if((state_val_76094 === (12))){
var inst_76085 = (state_76093[(2)]);
var state_76093__$1 = state_76093;
var statearr_76098_76124 = state_76093__$1;
(statearr_76098_76124[(2)] = inst_76085);

(statearr_76098_76124[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (2))){
var inst_76061 = (state_76093[(7)]);
var inst_76066 = (state_76093[(8)]);
var inst_76056 = (state_76093[(9)]);
var _ = (function (){var statearr_76099 = state_76093;
(statearr_76099[(4)] = cljs.core.cons((5),(state_76093[(4)])));

return statearr_76099;
})();
var inst_76056__$1 = fluree.db.util.core.random_uuid();
var inst_76057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76058 = [conn_id,cljs.core.cst$kw$ws];
var inst_76059 = (new cljs.core.PersistentVector(null,2,(5),inst_76057,inst_76058,null));
var inst_76060 = (function (){var lock_id = inst_76056__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_76061__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_76059,inst_76060);
var inst_76062 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76063 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_76064 = (new cljs.core.PersistentVector(null,3,(5),inst_76062,inst_76063,null));
var inst_76065 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76061__$1,inst_76064);
var inst_76066__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76056__$1,inst_76065);
var inst_76067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76068 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_76069 = (new cljs.core.PersistentVector(null,3,(5),inst_76067,inst_76068,null));
var inst_76070 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76061__$1,inst_76069);
var state_76093__$1 = (function (){var statearr_76100 = state_76093;
(statearr_76100[(7)] = inst_76061__$1);

(statearr_76100[(8)] = inst_76066__$1);

(statearr_76100[(9)] = inst_76056__$1);

(statearr_76100[(10)] = inst_76070);

return statearr_76100;
})();
if(inst_76066__$1){
var statearr_76101_76125 = state_76093__$1;
(statearr_76101_76125[(1)] = (6));

} else {
var statearr_76102_76126 = state_76093__$1;
(statearr_76102_76126[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (11))){
var inst_76077 = (state_76093[(11)]);
var inst_76076 = (state_76093[(12)]);
var inst_76070 = (state_76093[(10)]);
var inst_76083 = fluree.db.util.xhttp.try_socket(inst_76076,sub_chan,pub_chan,inst_76070,(60000),inst_76077);
var state_76093__$1 = state_76093;
var statearr_76104_76127 = state_76093__$1;
(statearr_76104_76127[(2)] = inst_76083);

(statearr_76104_76127[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (9))){
var inst_76061 = (state_76093[(7)]);
var inst_76074 = (state_76093[(13)]);
var inst_76066 = (state_76093[(8)]);
var inst_76056 = (state_76093[(9)]);
var inst_76076 = (state_76093[(12)]);
var inst_76070 = (state_76093[(10)]);
var inst_76074__$1 = (state_76093[(2)]);
var inst_76075 = clojure.string.replace(inst_76074__$1,"http","ws");
var inst_76076__$1 = [inst_76075,"/fdb/ws"].join('');
var inst_76077 = (function (){var lock_id = inst_76056;
var state = inst_76061;
var have_lock_QMARK_ = inst_76066;
var resp_chan = inst_76070;
var healthy_server = inst_76074__$1;
var ws_url = inst_76076__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_76078 = fluree.db.util.core.exception_QMARK_(inst_76074__$1);
var state_76093__$1 = (function (){var statearr_76105 = state_76093;
(statearr_76105[(11)] = inst_76077);

(statearr_76105[(13)] = inst_76074__$1);

(statearr_76105[(12)] = inst_76076__$1);

return statearr_76105;
})();
if(inst_76078){
var statearr_76106_76128 = state_76093__$1;
(statearr_76106_76128[(1)] = (10));

} else {
var statearr_76107_76129 = state_76093__$1;
(statearr_76107_76129[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (5))){
var _ = (function (){var statearr_76108 = state_76093;
(statearr_76108[(4)] = cljs.core.rest((state_76093[(4)])));

return statearr_76108;
})();
var state_76093__$1 = state_76093;
var ex76103 = (state_76093__$1[(2)]);
var statearr_76109_76130 = state_76093__$1;
(statearr_76109_76130[(5)] = ex76103);


if((ex76103 instanceof Error)){
var statearr_76110_76131 = state_76093__$1;
(statearr_76110_76131[(1)] = (4));

(statearr_76110_76131[(5)] = null);

} else {
throw ex76103;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (10))){
var inst_76074 = (state_76093[(13)]);
var inst_76070 = (state_76093[(10)]);
var inst_76080 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_76081 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_76070,inst_76074);
var state_76093__$1 = (function (){var statearr_76111 = state_76093;
(statearr_76111[(14)] = inst_76080);

return statearr_76111;
})();
var statearr_76112_76132 = state_76093__$1;
(statearr_76112_76132[(2)] = inst_76081);

(statearr_76112_76132[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76094 === (8))){
var inst_76070 = (state_76093[(10)]);
var inst_76088 = (state_76093[(2)]);
var _ = (function (){var statearr_76113 = state_76093;
(statearr_76113[(4)] = cljs.core.rest((state_76093[(4)])));

return statearr_76113;
})();
var state_76093__$1 = (function (){var statearr_76114 = state_76093;
(statearr_76114[(15)] = inst_76088);

return statearr_76114;
})();
var statearr_76115_76133 = state_76093__$1;
(statearr_76115_76133[(2)] = inst_76070);

(statearr_76115_76133[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__14778__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__14778__auto____0 = (function (){
var statearr_76116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76116[(0)] = fluree$db$connection$establish_socket_$_state_machine__14778__auto__);

(statearr_76116[(1)] = (1));

return statearr_76116;
});
var fluree$db$connection$establish_socket_$_state_machine__14778__auto____1 = (function (state_76093){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_76093);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e76117){var ex__14781__auto__ = e76117;
var statearr_76118_76134 = state_76093;
(statearr_76118_76134[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_76093[(4)]))){
var statearr_76119_76135 = state_76093;
(statearr_76119_76135[(1)] = cljs.core.first((state_76093[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76136 = state_76093;
state_76093 = G__76136;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__14778__auto__ = function(state_76093){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__14778__auto____1.call(this,state_76093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__14778__auto____0;
fluree$db$connection$establish_socket_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__14778__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_76120 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_76120[(6)] = c__14852__auto__);

return statearr_76120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k76138,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__76142 = k76138;
var G__76142__$1 = (((G__76142 instanceof cljs.core.Keyword))?G__76142.fqn:null);
switch (G__76142__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k76138,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__76143){
var vec__76144 = p__76143;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76144,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76144,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__76137){
var self__ = this;
var G__76137__$1 = this;
return (new cljs.core.RecordIter((0),G__76137__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__76147 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__76147(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this76139,other76140){
var self__ = this;
var this76139__$1 = this;
return (((!((other76140 == null)))) && ((((this76139__$1.constructor === other76140.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.id,other76140.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.servers,other76140.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.state,other76140.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.req_chan,other76140.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.sub_chan,other76140.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.pub_chan,other76140.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.storage_read,other76140.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.storage_write,other76140.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.object_cache,other76140.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.parallelism,other76140.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.serializer,other76140.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.default_network,other76140.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.transactor_QMARK_,other76140.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.publish,other76140.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.transact_handler,other76140.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.tx_private_key,other76140.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.tx_key_id,other76140.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.meta,other76140.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.add_listener,other76140.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.remove_listener,other76140.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.close,other76140.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this76139__$1.__extmap,other76140.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k76138){
var self__ = this;
var this__4479__auto____$1 = this;
var G__76148 = k76138;
var G__76148__$1 = (((G__76148 instanceof cljs.core.Keyword))?G__76148.fqn:null);
switch (G__76148__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k76138);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__76137){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__76149 = cljs.core.keyword_identical_QMARK_;
var expr__76150 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__76152 = cljs.core.cst$kw$id;
var G__76153 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76152,G__76153) : pred__76149.call(null,G__76152,G__76153));
})())){
return (new fluree.db.connection.Connection(G__76137,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76154 = cljs.core.cst$kw$servers;
var G__76155 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76154,G__76155) : pred__76149.call(null,G__76154,G__76155));
})())){
return (new fluree.db.connection.Connection(self__.id,G__76137,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76156 = cljs.core.cst$kw$state;
var G__76157 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76156,G__76157) : pred__76149.call(null,G__76156,G__76157));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__76137,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76158 = cljs.core.cst$kw$req_DASH_chan;
var G__76159 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76158,G__76159) : pred__76149.call(null,G__76158,G__76159));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__76137,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76160 = cljs.core.cst$kw$sub_DASH_chan;
var G__76161 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76160,G__76161) : pred__76149.call(null,G__76160,G__76161));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__76137,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76162 = cljs.core.cst$kw$pub_DASH_chan;
var G__76163 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76162,G__76163) : pred__76149.call(null,G__76162,G__76163));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__76137,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76164 = cljs.core.cst$kw$storage_DASH_read;
var G__76165 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76164,G__76165) : pred__76149.call(null,G__76164,G__76165));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__76137,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76166 = cljs.core.cst$kw$storage_DASH_write;
var G__76167 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76166,G__76167) : pred__76149.call(null,G__76166,G__76167));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__76137,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76168 = cljs.core.cst$kw$object_DASH_cache;
var G__76169 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76168,G__76169) : pred__76149.call(null,G__76168,G__76169));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__76137,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76170 = cljs.core.cst$kw$parallelism;
var G__76171 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76170,G__76171) : pred__76149.call(null,G__76170,G__76171));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__76137,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76172 = cljs.core.cst$kw$serializer;
var G__76173 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76172,G__76173) : pred__76149.call(null,G__76172,G__76173));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__76137,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76174 = cljs.core.cst$kw$default_DASH_network;
var G__76175 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76174,G__76175) : pred__76149.call(null,G__76174,G__76175));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__76137,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76176 = cljs.core.cst$kw$transactor_QMARK_;
var G__76177 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76176,G__76177) : pred__76149.call(null,G__76176,G__76177));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__76137,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76178 = cljs.core.cst$kw$publish;
var G__76179 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76178,G__76179) : pred__76149.call(null,G__76178,G__76179));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__76137,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76180 = cljs.core.cst$kw$transact_DASH_handler;
var G__76181 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76180,G__76181) : pred__76149.call(null,G__76180,G__76181));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__76137,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76182 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__76183 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76182,G__76183) : pred__76149.call(null,G__76182,G__76183));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__76137,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76184 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__76185 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76184,G__76185) : pred__76149.call(null,G__76184,G__76185));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__76137,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76186 = cljs.core.cst$kw$meta;
var G__76187 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76186,G__76187) : pred__76149.call(null,G__76186,G__76187));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__76137,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76188 = cljs.core.cst$kw$add_DASH_listener;
var G__76189 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76188,G__76189) : pred__76149.call(null,G__76188,G__76189));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__76137,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76190 = cljs.core.cst$kw$remove_DASH_listener;
var G__76191 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76190,G__76191) : pred__76149.call(null,G__76190,G__76191));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__76137,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__76192 = cljs.core.cst$kw$close;
var G__76193 = expr__76150;
return (pred__76149.cljs$core$IFn$_invoke$arity$2 ? pred__76149.cljs$core$IFn$_invoke$arity$2(G__76192,G__76193) : pred__76149.call(null,G__76192,G__76193));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__76137,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__76137),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__76137){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__76137,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__76141){
var extmap__4512__auto__ = (function (){var G__76194 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__76141,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__76141)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__76194);
} else {
return G__76194;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__76141),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__76141),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__76200 = servers_STAR_;
var vec__76201 = G__76200;
var seq__76202 = cljs.core.seq(vec__76201);
var first__76203 = cljs.core.first(seq__76202);
var seq__76202__$1 = cljs.core.next(seq__76202);
var server = first__76203;
var r = seq__76202__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__76200__$1 = G__76200;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__76207 = G__76200__$1;
var seq__76208 = cljs.core.seq(vec__76207);
var first__76209 = cljs.core.first(seq__76208);
var seq__76208__$1 = cljs.core.next(seq__76208);
var server__$1 = first__76209;
var r__$1 = seq__76208__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__76210 = r__$1;
var G__76211 = is_https_QMARK_;
var G__76212 = result_STAR_;
G__76200__$1 = G__76210;
https_QMARK___$1 = G__76211;
result__$1 = G__76212;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__76213 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__76213 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__76213);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_76242){
var state_val_76243 = (state_76242[(1)]);
if((state_val_76243 === (7))){
var inst_76228 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76229 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76230 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76231 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76232 = fluree.db.connection.establish_socket(inst_76228,inst_76229,inst_76230,inst_76231);
var state_76242__$1 = state_76242;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76242__$1,(9),inst_76232);
} else {
if((state_val_76243 === (1))){
var state_76242__$1 = state_76242;
var statearr_76244_76263 = state_76242__$1;
(statearr_76244_76263[(2)] = null);

(statearr_76244_76263[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76243 === (4))){
var inst_76214 = (state_76242[(2)]);
var state_76242__$1 = state_76242;
var statearr_76245_76264 = state_76242__$1;
(statearr_76245_76264[(2)] = inst_76214);

(statearr_76245_76264[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76243 === (6))){
var inst_76225 = (state_76242[(7)]);
var state_76242__$1 = state_76242;
var statearr_76246_76265 = state_76242__$1;
(statearr_76246_76265[(2)] = inst_76225);

(statearr_76246_76265[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76243 === (3))){
var inst_76240 = (state_76242[(2)]);
var state_76242__$1 = state_76242;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76242__$1,inst_76240);
} else {
if((state_val_76243 === (2))){
var inst_76225 = (state_76242[(7)]);
var _ = (function (){var statearr_76248 = state_76242;
(statearr_76248[(4)] = cljs.core.cons((5),(state_76242[(4)])));

return statearr_76248;
})();
var inst_76220 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_76221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76222 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76223 = [inst_76222,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_76224 = (new cljs.core.PersistentVector(null,3,(5),inst_76221,inst_76223,null));
var inst_76225__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76220,inst_76224);
var state_76242__$1 = (function (){var statearr_76249 = state_76242;
(statearr_76249[(7)] = inst_76225__$1);

return statearr_76249;
})();
if(cljs.core.truth_(inst_76225__$1)){
var statearr_76250_76266 = state_76242__$1;
(statearr_76250_76266[(1)] = (6));

} else {
var statearr_76251_76267 = state_76242__$1;
(statearr_76251_76267[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76243 === (9))){
var inst_76234 = (state_76242[(2)]);
var inst_76235 = fluree.db.util.async.throw_err(inst_76234);
var state_76242__$1 = state_76242;
var statearr_76252_76268 = state_76242__$1;
(statearr_76252_76268[(2)] = inst_76235);

(statearr_76252_76268[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76243 === (5))){
var _ = (function (){var statearr_76253 = state_76242;
(statearr_76253[(4)] = cljs.core.rest((state_76242[(4)])));

return statearr_76253;
})();
var state_76242__$1 = state_76242;
var ex76247 = (state_76242__$1[(2)]);
var statearr_76254_76269 = state_76242__$1;
(statearr_76254_76269[(5)] = ex76247);


if((ex76247 instanceof Error)){
var statearr_76255_76270 = state_76242__$1;
(statearr_76255_76270[(1)] = (4));

(statearr_76255_76270[(5)] = null);

} else {
throw ex76247;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76243 === (8))){
var inst_76237 = (state_76242[(2)]);
var _ = (function (){var statearr_76256 = state_76242;
(statearr_76256[(4)] = cljs.core.rest((state_76242[(4)])));

return statearr_76256;
})();
var state_76242__$1 = state_76242;
var statearr_76257_76271 = state_76242__$1;
(statearr_76257_76271[(2)] = inst_76237);

(statearr_76257_76271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__14778__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__14778__auto____0 = (function (){
var statearr_76258 = [null,null,null,null,null,null,null,null];
(statearr_76258[(0)] = fluree$db$connection$get_socket_$_state_machine__14778__auto__);

(statearr_76258[(1)] = (1));

return statearr_76258;
});
var fluree$db$connection$get_socket_$_state_machine__14778__auto____1 = (function (state_76242){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_76242);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e76259){var ex__14781__auto__ = e76259;
var statearr_76260_76272 = state_76242;
(statearr_76260_76272[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_76242[(4)]))){
var statearr_76261_76273 = state_76242;
(statearr_76261_76273[(1)] = cljs.core.first((state_76242[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76274 = state_76242;
state_76242 = G__76274;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__14778__auto__ = function(state_76242){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__14778__auto____1.call(this,state_76242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__14778__auto____0;
fluree$db$connection$get_socket_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__14778__auto____1;
return fluree$db$connection$get_socket_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_76262 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_76262[(6)] = c__14852__auto__);

return statearr_76262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e76275){var e = e76275;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_76402){
var state_val_76403 = (state_76402[(1)]);
if((state_val_76403 === (7))){
var inst_76398 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
var statearr_76405_76475 = state_76402__$1;
(statearr_76405_76475[(2)] = inst_76398);

(statearr_76405_76475[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (20))){
var _ = (function (){var statearr_76406 = state_76402;
(statearr_76406[(4)] = cljs.core.rest((state_76402[(4)])));

return statearr_76406;
})();
var state_76402__$1 = state_76402;
var ex76404 = (state_76402__$1[(2)]);
var statearr_76407_76476 = state_76402__$1;
(statearr_76407_76476[(5)] = ex76404);


var statearr_76408_76477 = state_76402__$1;
(statearr_76408_76477[(1)] = (10));

(statearr_76408_76477[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (27))){
var inst_76390 = (state_76402[(2)]);
var _ = (function (){var statearr_76409 = state_76402;
(statearr_76409[(4)] = cljs.core.rest((state_76402[(4)])));

return statearr_76409;
})();
var state_76402__$1 = state_76402;
var statearr_76410_76478 = state_76402__$1;
(statearr_76410_76478[(2)] = inst_76390);

(statearr_76410_76478[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (1))){
var inst_76277 = (0);
var state_76402__$1 = (function (){var statearr_76411 = state_76402;
(statearr_76411[(7)] = inst_76277);

return statearr_76411;
})();
var statearr_76412_76479 = state_76402__$1;
(statearr_76412_76479[(2)] = null);

(statearr_76412_76479[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (24))){
var inst_76368 = (state_76402[(8)]);
var inst_76368__$1 = (state_76402[(2)]);
var inst_76369 = inst_76368__$1 === true;
var state_76402__$1 = (function (){var statearr_76413 = state_76402;
(statearr_76413[(8)] = inst_76368__$1);

return statearr_76413;
})();
if(cljs.core.truth_(inst_76369)){
var statearr_76414_76480 = state_76402__$1;
(statearr_76414_76480[(1)] = (25));

} else {
var statearr_76415_76481 = state_76402__$1;
(statearr_76415_76481[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (4))){
var inst_76280 = (state_76402[(9)]);
var inst_76280__$1 = (state_76402[(2)]);
var state_76402__$1 = (function (){var statearr_76416 = state_76402;
(statearr_76416[(9)] = inst_76280__$1);

return statearr_76416;
})();
if(cljs.core.truth_(inst_76280__$1)){
var statearr_76417_76482 = state_76402__$1;
(statearr_76417_76482[(1)] = (5));

} else {
var statearr_76418_76483 = state_76402__$1;
(statearr_76418_76483[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (15))){
var inst_76293 = (state_76402[(10)]);
var state_76402__$1 = state_76402;
var statearr_76419_76484 = state_76402__$1;
(statearr_76419_76484[(2)] = inst_76293);

(statearr_76419_76484[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (21))){
var inst_76321 = (state_76402[(11)]);
var inst_76317 = (state_76402[(12)]);
var inst_76316 = (state_76402[(13)]);
var inst_76324 = (state_76402[(14)]);
var inst_76318 = (state_76402[(15)]);
var inst_76319 = (state_76402[(16)]);
var inst_76325 = (state_76402[(17)]);
var inst_76277 = (state_76402[(7)]);
var inst_76280 = (state_76402[(9)]);
var inst_76320 = (state_76402[(18)]);
var inst_76327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76328 = [cljs.core.cst$kw$pending_DASH_req,inst_76324];
var inst_76329 = (new cljs.core.PersistentVector(null,2,(5),inst_76327,inst_76328,null));
var inst_76330 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_76329,inst_76319);
var inst_76357 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_76358 = (function (){var resp_chan = inst_76319;
var timeout = inst_76325;
var i = inst_76277;
var data = inst_76318;
var c__14852__auto____$1 = inst_76357;
var _ = inst_76316;
var req_id = inst_76324;
var operation = inst_76317;
var vec__76312 = inst_76280;
var map__76315 = inst_76321;
var msg = inst_76280;
var opts = inst_76320;
return (function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_76355){
var state_val_76356 = (state_76355[(1)]);
if((state_val_76356 === (1))){
var inst_76334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76335 = cljs.core.async.timeout(timeout);
var inst_76336 = [resp_chan,inst_76335];
var inst_76337 = (new cljs.core.PersistentVector(null,2,(5),inst_76334,inst_76336,null));
var state_76355__$1 = state_76355;
return cljs.core.async.ioc_alts_BANG_(state_76355__$1,(2),inst_76337);
} else {
if((state_val_76356 === (2))){
var inst_76340 = (state_76355[(7)]);
var inst_76339 = (state_76355[(2)]);
var inst_76340__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76339,(0),null);
var inst_76341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76339,(1),null);
var inst_76342 = (function (){var vec__76331 = inst_76339;
var resp = inst_76340__$1;
var c = inst_76341;
return (function (p1__76276_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__76276_SHARP_,req_id);
});
})();
var inst_76343 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_76342);
var inst_76344 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76341,resp_chan);
var state_76355__$1 = (function (){var statearr_76420 = state_76355;
(statearr_76420[(7)] = inst_76340__$1);

(statearr_76420[(8)] = inst_76343);

return statearr_76420;
})();
if(inst_76344){
var statearr_76421_76485 = state_76355__$1;
(statearr_76421_76485[(1)] = (3));

} else {
var statearr_76422_76486 = state_76355__$1;
(statearr_76422_76486[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76356 === (3))){
var inst_76340 = (state_76355[(7)]);
var state_76355__$1 = state_76355;
var statearr_76423_76487 = state_76355__$1;
(statearr_76423_76487[(2)] = inst_76340);

(statearr_76423_76487[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76356 === (4))){
var inst_76347 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_76348 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_76349 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_76350 = cljs.core.PersistentHashMap.fromArrays(inst_76348,inst_76349);
var inst_76351 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_76347,inst_76350);
var state_76355__$1 = state_76355;
var statearr_76424_76488 = state_76355__$1;
(statearr_76424_76488[(2)] = inst_76351);

(statearr_76424_76488[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76356 === (5))){
var inst_76353 = (state_76355[(2)]);
var state_76355__$1 = state_76355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76355__$1,inst_76353);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__14778__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__14778__auto____0 = (function (){
var statearr_76425 = [null,null,null,null,null,null,null,null,null];
(statearr_76425[(0)] = fluree$db$connection$msg_producer_$_state_machine__14778__auto__);

(statearr_76425[(1)] = (1));

return statearr_76425;
});
var fluree$db$connection$msg_producer_$_state_machine__14778__auto____1 = (function (state_76355){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_76355);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e76426){var ex__14781__auto__ = e76426;
var statearr_76427_76489 = state_76355;
(statearr_76427_76489[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_76355[(4)]))){
var statearr_76428_76490 = state_76355;
(statearr_76428_76490[(1)] = cljs.core.first((state_76355[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76491 = state_76355;
state_76355 = G__76491;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__14778__auto__ = function(state_76355){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__14778__auto____1.call(this,state_76355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__14778__auto____0;
fluree$db$connection$msg_producer_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__14778__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_76429 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_76429[(6)] = c__14852__auto____$1);

return statearr_76429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
});
})();
var inst_76359 = cljs.core.async.impl.dispatch.run(inst_76358);
var state_76402__$1 = (function (){var statearr_76430 = state_76402;
(statearr_76430[(19)] = inst_76359);

(statearr_76430[(20)] = inst_76330);

return statearr_76430;
})();
var statearr_76431_76492 = state_76402__$1;
(statearr_76431_76492[(2)] = inst_76357);

(statearr_76431_76492[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (31))){
var inst_76378 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_76402__$1 = state_76402;
var statearr_76432_76493 = state_76402__$1;
(statearr_76432_76493[(2)] = inst_76378);

(statearr_76432_76493[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (32))){
var state_76402__$1 = state_76402;
var statearr_76433_76494 = state_76402__$1;
(statearr_76433_76494[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (33))){
var inst_76386 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
var statearr_76435_76495 = state_76402__$1;
(statearr_76435_76495[(2)] = inst_76386);

(statearr_76435_76495[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (13))){
var inst_76293 = (state_76402[(10)]);
var inst_76290 = (state_76402[(2)]);
var inst_76291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76290,(0),null);
var inst_76292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76290,(1),null);
var inst_76293__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76290,(2),null);
var state_76402__$1 = (function (){var statearr_76436 = state_76402;
(statearr_76436[(21)] = inst_76291);

(statearr_76436[(22)] = inst_76292);

(statearr_76436[(10)] = inst_76293__$1);

return statearr_76436;
})();
if(cljs.core.truth_(inst_76293__$1)){
var statearr_76437_76496 = state_76402__$1;
(statearr_76437_76496[(1)] = (14));

} else {
var statearr_76438_76497 = state_76402__$1;
(statearr_76438_76497[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (22))){
var state_76402__$1 = state_76402;
var statearr_76439_76498 = state_76402__$1;
(statearr_76439_76498[(2)] = null);

(statearr_76439_76498[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (36))){
var inst_76384 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
var statearr_76440_76499 = state_76402__$1;
(statearr_76440_76499[(2)] = inst_76384);

(statearr_76440_76499[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (29))){
var inst_76368 = (state_76402[(8)]);
var inst_76376 = (inst_76368 == null);
var state_76402__$1 = state_76402;
if(cljs.core.truth_(inst_76376)){
var statearr_76441_76500 = state_76402__$1;
(statearr_76441_76500[(1)] = (31));

} else {
var statearr_76442_76501 = state_76402__$1;
(statearr_76442_76501[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (6))){
var state_76402__$1 = state_76402;
var statearr_76443_76502 = state_76402__$1;
(statearr_76443_76502[(2)] = null);

(statearr_76443_76502[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (28))){
var inst_76368 = (state_76402[(8)]);
var inst_76374 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76368,"Error processing message in producer."], 0));
var state_76402__$1 = state_76402;
var statearr_76444_76503 = state_76402__$1;
(statearr_76444_76503[(2)] = inst_76374);

(statearr_76444_76503[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (25))){
var state_76402__$1 = state_76402;
var statearr_76445_76504 = state_76402__$1;
(statearr_76445_76504[(2)] = null);

(statearr_76445_76504[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (34))){
var inst_76368 = (state_76402[(8)]);
var inst_76381 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_76368], 0));
var state_76402__$1 = state_76402;
var statearr_76446_76505 = state_76402__$1;
(statearr_76446_76505[(2)] = inst_76381);

(statearr_76446_76505[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (17))){
var inst_76282 = (state_76402[(23)]);
var inst_76293 = (state_76402[(10)]);
var inst_76300 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_76293,inst_76282);
var state_76402__$1 = state_76402;
var statearr_76447_76506 = state_76402__$1;
(statearr_76447_76506[(2)] = inst_76300);

(statearr_76447_76506[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (3))){
var inst_76400 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76402__$1,inst_76400);
} else {
if((state_val_76403 === (12))){
var state_76402__$1 = state_76402;
var statearr_76448_76507 = state_76402__$1;
(statearr_76448_76507[(2)] = null);

(statearr_76448_76507[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (2))){
var state_76402__$1 = state_76402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76402__$1,(4),req_chan);
} else {
if((state_val_76403 === (23))){
var inst_76317 = (state_76402[(12)]);
var inst_76324 = (state_76402[(14)]);
var inst_76318 = (state_76402[(15)]);
var inst_76362 = (state_76402[(2)]);
var inst_76363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76364 = [inst_76317,inst_76324,inst_76318];
var inst_76365 = (new cljs.core.PersistentVector(null,3,(5),inst_76363,inst_76364,null));
var inst_76366 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_76365) : publish_fn.call(null,conn,inst_76365));
var state_76402__$1 = (function (){var statearr_76449 = state_76402;
(statearr_76449[(24)] = inst_76362);

return statearr_76449;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76402__$1,(24),inst_76366);
} else {
if((state_val_76403 === (35))){
var state_76402__$1 = state_76402;
var statearr_76450_76508 = state_76402__$1;
(statearr_76450_76508[(2)] = null);

(statearr_76450_76508[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (19))){
var inst_76306 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
var statearr_76451_76509 = state_76402__$1;
(statearr_76451_76509[(2)] = inst_76306);

(statearr_76451_76509[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (11))){
var inst_76280 = (state_76402[(9)]);
var state_76402__$1 = state_76402;
var statearr_76452_76510 = state_76402__$1;
(statearr_76452_76510[(2)] = inst_76280);

(statearr_76452_76510[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (9))){
var inst_76277 = (state_76402[(7)]);
var inst_76393 = (state_76402[(2)]);
var inst_76394 = (inst_76277 + (1));
var inst_76277__$1 = inst_76394;
var state_76402__$1 = (function (){var statearr_76453 = state_76402;
(statearr_76453[(25)] = inst_76393);

(statearr_76453[(7)] = inst_76277__$1);

return statearr_76453;
})();
var statearr_76454_76511 = state_76402__$1;
(statearr_76454_76511[(2)] = null);

(statearr_76454_76511[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (5))){
var state_76402__$1 = state_76402;
var statearr_76455_76512 = state_76402__$1;
(statearr_76455_76512[(2)] = null);

(statearr_76455_76512[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (14))){
var inst_76293 = (state_76402[(10)]);
var inst_76295 = fluree.db.util.async.channel_QMARK_(inst_76293);
var state_76402__$1 = state_76402;
var statearr_76456_76513 = state_76402__$1;
(statearr_76456_76513[(2)] = inst_76295);

(statearr_76456_76513[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (26))){
var inst_76368 = (state_76402[(8)]);
var inst_76372 = fluree.db.util.core.exception_QMARK_(inst_76368);
var state_76402__$1 = state_76402;
if(inst_76372){
var statearr_76457_76514 = state_76402__$1;
(statearr_76457_76514[(1)] = (28));

} else {
var statearr_76458_76515 = state_76402__$1;
(statearr_76458_76515[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (16))){
var inst_76298 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
if(cljs.core.truth_(inst_76298)){
var statearr_76459_76516 = state_76402__$1;
(statearr_76459_76516[(1)] = (17));

} else {
var statearr_76460_76517 = state_76402__$1;
(statearr_76460_76517[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (30))){
var inst_76388 = (state_76402[(2)]);
var state_76402__$1 = state_76402;
var statearr_76461_76518 = state_76402__$1;
(statearr_76461_76518[(2)] = inst_76388);

(statearr_76461_76518[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (10))){
var inst_76280 = (state_76402[(9)]);
var inst_76282 = (state_76402[(2)]);
var inst_76286 = cljs.core.sequential_QMARK_(inst_76280);
var state_76402__$1 = (function (){var statearr_76462 = state_76402;
(statearr_76462[(23)] = inst_76282);

return statearr_76462;
})();
if(inst_76286){
var statearr_76463_76519 = state_76402__$1;
(statearr_76463_76519[(1)] = (11));

} else {
var statearr_76464_76520 = state_76402__$1;
(statearr_76464_76520[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (18))){
var inst_76282 = (state_76402[(23)]);
var inst_76280 = (state_76402[(9)]);
var inst_76302 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76280], 0));
var inst_76303 = ["Error processing ledger request, no valid return channel: ",inst_76302].join('');
var inst_76304 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76282,inst_76303], 0));
var state_76402__$1 = state_76402;
var statearr_76465_76521 = state_76402__$1;
(statearr_76465_76521[(2)] = inst_76304);

(statearr_76465_76521[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76403 === (8))){
var inst_76321 = (state_76402[(11)]);
var inst_76319 = (state_76402[(16)]);
var inst_76280 = (state_76402[(9)]);
var inst_76320 = (state_76402[(18)]);
var _ = (function (){var statearr_76466 = state_76402;
(statearr_76466[(4)] = cljs.core.cons((20),(state_76402[(4)])));

return statearr_76466;
})();
var inst_76316 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_76280], 0));
var inst_76317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76280,(0),null);
var inst_76318 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76280,(1),null);
var inst_76319__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76280,(2),null);
var inst_76320__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76280,(3),null);
var inst_76321__$1 = cljs.core.__destructure_map(inst_76320__$1);
var inst_76322 = fluree.db.util.core.random_uuid();
var inst_76323 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76322);
var inst_76324 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76321__$1,cljs.core.cst$kw$req_DASH_id,inst_76323);
var inst_76325 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_76321__$1,cljs.core.cst$kw$timeout,(60000));
var state_76402__$1 = (function (){var statearr_76467 = state_76402;
(statearr_76467[(11)] = inst_76321__$1);

(statearr_76467[(12)] = inst_76317);

(statearr_76467[(13)] = inst_76316);

(statearr_76467[(14)] = inst_76324);

(statearr_76467[(15)] = inst_76318);

(statearr_76467[(16)] = inst_76319__$1);

(statearr_76467[(17)] = inst_76325);

(statearr_76467[(18)] = inst_76320__$1);

return statearr_76467;
})();
if(cljs.core.truth_(inst_76319__$1)){
var statearr_76468_76522 = state_76402__$1;
(statearr_76468_76522[(1)] = (21));

} else {
var statearr_76469_76523 = state_76402__$1;
(statearr_76469_76523[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__14778__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__14778__auto____0 = (function (){
var statearr_76470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76470[(0)] = fluree$db$connection$msg_producer_$_state_machine__14778__auto__);

(statearr_76470[(1)] = (1));

return statearr_76470;
});
var fluree$db$connection$msg_producer_$_state_machine__14778__auto____1 = (function (state_76402){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_76402);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e76471){var ex__14781__auto__ = e76471;
var statearr_76472_76524 = state_76402;
(statearr_76472_76524[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_76402[(4)]))){
var statearr_76473_76525 = state_76402;
(statearr_76473_76525[(1)] = cljs.core.first((state_76402[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76526 = state_76402;
state_76402 = G__76526;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__14778__auto__ = function(state_76402){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__14778__auto____1.call(this,state_76402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__14778__auto____0;
fluree$db$connection$msg_producer_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__14778__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_76474 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_76474[(6)] = c__14852__auto__);

return statearr_76474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__76527 = conn;
var map__76527__$1 = cljs.core.__destructure_map(map__76527);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76527__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_76609){
var state_val_76610 = (state_76609[(1)]);
if((state_val_76610 === (7))){
var inst_76605 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76611_76662 = state_76609__$1;
(statearr_76611_76662[(2)] = inst_76605);

(statearr_76611_76662[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (20))){
var inst_76546 = (state_76609[(7)]);
var inst_76560 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_76561 = [inst_76546];
var inst_76562 = cljs.core.PersistentHashMap.fromArrays(inst_76560,inst_76561);
var inst_76563 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_76562], 0));
var state_76609__$1 = state_76609;
var statearr_76612_76663 = state_76609__$1;
(statearr_76612_76663[(2)] = inst_76563);

(statearr_76612_76663[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (27))){
var state_76609__$1 = state_76609;
var statearr_76613_76664 = state_76609__$1;
(statearr_76613_76664[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (1))){
var inst_76528 = (0);
var state_76609__$1 = (function (){var statearr_76615 = state_76609;
(statearr_76615[(8)] = inst_76528);

return statearr_76615;
})();
var statearr_76616_76665 = state_76609__$1;
(statearr_76616_76665[(2)] = null);

(statearr_76616_76665[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (24))){
var inst_76539 = (state_76609[(9)]);
var inst_76588 = fluree.db.util.core.exception_QMARK_(inst_76539);
var state_76609__$1 = state_76609;
if(inst_76588){
var statearr_76617_76666 = state_76609__$1;
(statearr_76617_76666[(1)] = (26));

} else {
var statearr_76618_76667 = state_76609__$1;
(statearr_76618_76667[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (4))){
var inst_76533 = (state_76609[(10)]);
var inst_76538 = (state_76609[(2)]);
var inst_76539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76538,(0),null);
var inst_76540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_76538,(1),null);
var inst_76541 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_76540,inst_76533);
var state_76609__$1 = (function (){var statearr_76619 = state_76609;
(statearr_76619[(9)] = inst_76539);

return statearr_76619;
})();
if(inst_76541){
var statearr_76620_76668 = state_76609__$1;
(statearr_76620_76668[(1)] = (5));

} else {
var statearr_76621_76669 = state_76609__$1;
(statearr_76621_76669[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (15))){
var inst_76546 = (state_76609[(7)]);
var inst_76555 = typeof inst_76546 === 'string';
var state_76609__$1 = state_76609;
if(cljs.core.truth_(inst_76555)){
var statearr_76622_76670 = state_76609__$1;
(statearr_76622_76670[(1)] = (17));

} else {
var statearr_76623_76671 = state_76609__$1;
(statearr_76623_76671[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (21))){
var state_76609__$1 = state_76609;
var statearr_76624_76672 = state_76609__$1;
(statearr_76624_76672[(2)] = null);

(statearr_76624_76672[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (31))){
var inst_76599 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76625_76673 = state_76609__$1;
(statearr_76625_76673[(2)] = inst_76599);

(statearr_76625_76673[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (13))){
var inst_76572 = (state_76609[(2)]);
var inst_76573 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76574 = fluree.db.connection.close_websocket(inst_76573);
var inst_76575 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76576 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_76575);
var state_76609__$1 = (function (){var statearr_76626 = state_76609;
(statearr_76626[(11)] = inst_76574);

(statearr_76626[(12)] = inst_76572);

return statearr_76626;
})();
var statearr_76627_76674 = state_76609__$1;
(statearr_76627_76674[(2)] = inst_76576);

(statearr_76627_76674[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (22))){
var inst_76566 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76628_76675 = state_76609__$1;
(statearr_76628_76675[(2)] = inst_76566);

(statearr_76628_76675[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (29))){
var inst_76539 = (state_76609[(9)]);
var inst_76594 = fluree.db.util.json.parse(inst_76539);
var inst_76595 = fluree.db.conn_events.process_events(conn,inst_76594);
var inst_76528 = (0);
var state_76609__$1 = (function (){var statearr_76629 = state_76609;
(statearr_76629[(13)] = inst_76595);

(statearr_76629[(8)] = inst_76528);

return statearr_76629;
})();
var statearr_76630_76676 = state_76609__$1;
(statearr_76630_76676[(2)] = null);

(statearr_76630_76676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (6))){
var inst_76539 = (state_76609[(9)]);
var inst_76584 = (inst_76539 == null);
var state_76609__$1 = state_76609;
if(cljs.core.truth_(inst_76584)){
var statearr_76631_76677 = state_76609__$1;
(statearr_76631_76677[(1)] = (23));

} else {
var statearr_76632_76678 = state_76609__$1;
(statearr_76632_76678[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (28))){
var inst_76601 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76633_76679 = state_76609__$1;
(statearr_76633_76679[(2)] = inst_76601);

(statearr_76633_76679[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (25))){
var inst_76603 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76634_76680 = state_76609__$1;
(statearr_76634_76680[(2)] = inst_76603);

(statearr_76634_76680[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (17))){
var inst_76546 = (state_76609[(7)]);
var inst_76557 = cljs.core.eval(inst_76546);
var state_76609__$1 = state_76609;
var statearr_76635_76681 = state_76609__$1;
(statearr_76635_76681[(2)] = inst_76557);

(statearr_76635_76681[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (3))){
var inst_76607 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76609__$1,inst_76607);
} else {
if((state_val_76610 === (12))){
var inst_76546 = (state_76609[(7)]);
var inst_76551 = cljs.core.fn_QMARK_(inst_76546);
var state_76609__$1 = state_76609;
if(inst_76551){
var statearr_76636_76682 = state_76609__$1;
(statearr_76636_76682[(1)] = (14));

} else {
var statearr_76637_76683 = state_76609__$1;
(statearr_76637_76683[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (2))){
var inst_76533 = (state_76609[(10)]);
var inst_76533__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_76534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76535 = [sub_chan,inst_76533__$1];
var inst_76536 = (new cljs.core.PersistentVector(null,2,(5),inst_76534,inst_76535,null));
var state_76609__$1 = (function (){var statearr_76638 = state_76609;
(statearr_76638[(10)] = inst_76533__$1);

return statearr_76638;
})();
return cljs.core.async.ioc_alts_BANG_(state_76609__$1,(4),inst_76536);
} else {
if((state_val_76610 === (23))){
var inst_76586 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_76609__$1 = state_76609;
var statearr_76639_76684 = state_76609__$1;
(statearr_76639_76684[(2)] = inst_76586);

(statearr_76639_76684[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (19))){
var inst_76568 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76640_76685 = state_76609__$1;
(statearr_76640_76685[(2)] = inst_76568);

(statearr_76640_76685[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (11))){
var inst_76549 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_76609__$1 = state_76609;
var statearr_76641_76686 = state_76609__$1;
(statearr_76641_76686[(2)] = inst_76549);

(statearr_76641_76686[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (9))){
var inst_76528 = (state_76609[(8)]);
var inst_76578 = fluree.db.connection.ping_transactor(conn);
var inst_76579 = (inst_76528 + (1));
var inst_76528__$1 = inst_76579;
var state_76609__$1 = (function (){var statearr_76642 = state_76609;
(statearr_76642[(14)] = inst_76578);

(statearr_76642[(8)] = inst_76528__$1);

return statearr_76642;
})();
var statearr_76643_76687 = state_76609__$1;
(statearr_76643_76687[(2)] = null);

(statearr_76643_76687[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (5))){
var inst_76528 = (state_76609[(8)]);
var inst_76543 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_76528);
var state_76609__$1 = state_76609;
if(inst_76543){
var statearr_76644_76688 = state_76609__$1;
(statearr_76644_76688[(1)] = (8));

} else {
var statearr_76645_76689 = state_76609__$1;
(statearr_76645_76689[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (14))){
var inst_76546 = (state_76609[(7)]);
var inst_76553 = (inst_76546.cljs$core$IFn$_invoke$arity$0 ? inst_76546.cljs$core$IFn$_invoke$arity$0() : inst_76546.call(null));
var state_76609__$1 = state_76609;
var statearr_76646_76690 = state_76609__$1;
(statearr_76646_76690[(2)] = inst_76553);

(statearr_76646_76690[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (26))){
var inst_76539 = (state_76609[(9)]);
var inst_76590 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_76539], 0));
var inst_76528 = (0);
var state_76609__$1 = (function (){var statearr_76647 = state_76609;
(statearr_76647[(15)] = inst_76590);

(statearr_76647[(8)] = inst_76528);

return statearr_76647;
})();
var statearr_76648_76691 = state_76609__$1;
(statearr_76648_76691[(2)] = null);

(statearr_76648_76691[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (16))){
var inst_76570 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76649_76692 = state_76609__$1;
(statearr_76649_76692[(2)] = inst_76570);

(statearr_76649_76692[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (30))){
var state_76609__$1 = state_76609;
var statearr_76650_76693 = state_76609__$1;
(statearr_76650_76693[(2)] = null);

(statearr_76650_76693[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (10))){
var inst_76582 = (state_76609[(2)]);
var state_76609__$1 = state_76609;
var statearr_76651_76694 = state_76609__$1;
(statearr_76651_76694[(2)] = inst_76582);

(statearr_76651_76694[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (18))){
var state_76609__$1 = state_76609;
var statearr_76652_76695 = state_76609__$1;
(statearr_76652_76695[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_76610 === (8))){
var inst_76546 = (state_76609[(7)]);
var inst_76545 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_76546__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_76547 = (inst_76546__$1 == null);
var state_76609__$1 = (function (){var statearr_76654 = state_76609;
(statearr_76654[(7)] = inst_76546__$1);

(statearr_76654[(16)] = inst_76545);

return statearr_76654;
})();
if(cljs.core.truth_(inst_76547)){
var statearr_76655_76696 = state_76609__$1;
(statearr_76655_76696[(1)] = (11));

} else {
var statearr_76656_76697 = state_76609__$1;
(statearr_76656_76697[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__14778__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__14778__auto____0 = (function (){
var statearr_76657 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76657[(0)] = fluree$db$connection$msg_consumer_$_state_machine__14778__auto__);

(statearr_76657[(1)] = (1));

return statearr_76657;
});
var fluree$db$connection$msg_consumer_$_state_machine__14778__auto____1 = (function (state_76609){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_76609);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e76658){var ex__14781__auto__ = e76658;
var statearr_76659_76698 = state_76609;
(statearr_76659_76698[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_76609[(4)]))){
var statearr_76660_76699 = state_76609;
(statearr_76660_76699[(1)] = cljs.core.first((state_76609[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76700 = state_76609;
state_76609 = G__76700;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__14778__auto__ = function(state_76609){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__14778__auto____1.call(this,state_76609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__14778__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__14778__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_76661 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_76661[(6)] = c__14852__auto__);

return statearr_76661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__76702 = arguments.length;
switch (G__76702) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__76703 = opts;
var map__76703__$1 = cljs.core.__destructure_map(map__76703);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76703__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76703__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_76755){
var state_val_76756 = (state_76755[(1)]);
if((state_val_76756 === (7))){
var inst_76713 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_76714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76715 = [conn_id,cljs.core.cst$kw$token];
var inst_76716 = (new cljs.core.PersistentVector(null,2,(5),inst_76714,inst_76715,null));
var inst_76717 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_76713,inst_76716);
var state_76755__$1 = state_76755;
var statearr_76757_76788 = state_76755__$1;
(statearr_76757_76788[(2)] = inst_76717);

(statearr_76757_76788[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (1))){
var state_76755__$1 = state_76755;
var statearr_76758_76789 = state_76755__$1;
(statearr_76758_76789[(2)] = null);

(statearr_76758_76789[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (4))){
var inst_76704 = (state_76755[(2)]);
var state_76755__$1 = state_76755;
var statearr_76759_76790 = state_76755__$1;
(statearr_76759_76790[(2)] = inst_76704);

(statearr_76759_76790[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (15))){
var inst_76724 = (state_76755[(7)]);
var inst_76743 = (state_76755[(2)]);
var inst_76744 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_76745 = [(5000),inst_76743,cljs.core.cst$kw$text];
var inst_76746 = cljs.core.PersistentHashMap.fromArrays(inst_76744,inst_76745);
var inst_76747 = fluree.db.util.xhttp.get(inst_76724,inst_76746);
var state_76755__$1 = state_76755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76755__$1,(16),inst_76747);
} else {
if((state_val_76756 === (13))){
var inst_76724 = (state_76755[(7)]);
var inst_76734 = (state_76755[(8)]);
var inst_76736 = [cljs.core.cst$kw$headers];
var inst_76737 = [inst_76734];
var inst_76738 = cljs.core.PersistentHashMap.fromArrays(inst_76736,inst_76737);
var inst_76739 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_76724,inst_76738,private$);
var inst_76740 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_76739);
var state_76755__$1 = state_76755;
var statearr_76760_76791 = state_76755__$1;
(statearr_76760_76791[(2)] = inst_76740);

(statearr_76760_76791[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (6))){
var inst_76710 = (state_76755[(9)]);
var state_76755__$1 = state_76755;
var statearr_76761_76792 = state_76755__$1;
(statearr_76761_76792[(2)] = inst_76710);

(statearr_76761_76792[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (3))){
var inst_76753 = (state_76755[(2)]);
var state_76755__$1 = state_76755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76755__$1,inst_76753);
} else {
if((state_val_76756 === (12))){
var inst_76734 = (state_76755[(2)]);
var state_76755__$1 = (function (){var statearr_76762 = state_76755;
(statearr_76762[(8)] = inst_76734);

return statearr_76762;
})();
if(cljs.core.truth_(private$)){
var statearr_76763_76793 = state_76755__$1;
(statearr_76763_76793[(1)] = (13));

} else {
var statearr_76764_76794 = state_76755__$1;
(statearr_76764_76794[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (2))){
var inst_76710 = (state_76755[(9)]);
var _ = (function (){var statearr_76765 = state_76755;
(statearr_76765[(4)] = cljs.core.cons((5),(state_76755[(4)])));

return statearr_76765;
})();
var inst_76710__$1 = jwt;
var state_76755__$1 = (function (){var statearr_76766 = state_76755;
(statearr_76766[(9)] = inst_76710__$1);

return statearr_76766;
})();
if(cljs.core.truth_(inst_76710__$1)){
var statearr_76767_76795 = state_76755__$1;
(statearr_76767_76795[(1)] = (6));

} else {
var statearr_76768_76796 = state_76755__$1;
(statearr_76768_76796[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (11))){
var inst_76728 = (state_76755[(10)]);
var state_76755__$1 = state_76755;
var statearr_76770_76797 = state_76755__$1;
(statearr_76770_76797[(2)] = inst_76728);

(statearr_76770_76797[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (9))){
var inst_76719 = (state_76755[(11)]);
var inst_76720 = (state_76755[(12)]);
var inst_76723 = (state_76755[(2)]);
var inst_76724 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76723),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76720)].join('');
var inst_76726 = ["Accept"];
var inst_76727 = ["application/json"];
var inst_76728 = cljs.core.PersistentHashMap.fromArrays(inst_76726,inst_76727);
var state_76755__$1 = (function (){var statearr_76771 = state_76755;
(statearr_76771[(10)] = inst_76728);

(statearr_76771[(7)] = inst_76724);

return statearr_76771;
})();
if(cljs.core.truth_(inst_76719)){
var statearr_76772_76798 = state_76755__$1;
(statearr_76772_76798[(1)] = (10));

} else {
var statearr_76773_76799 = state_76755__$1;
(statearr_76773_76799[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (5))){
var _ = (function (){var statearr_76774 = state_76755;
(statearr_76774[(4)] = cljs.core.rest((state_76755[(4)])));

return statearr_76774;
})();
var state_76755__$1 = state_76755;
var ex76769 = (state_76755__$1[(2)]);
var statearr_76775_76800 = state_76755__$1;
(statearr_76775_76800[(5)] = ex76769);


if((ex76769 instanceof Error)){
var statearr_76776_76801 = state_76755__$1;
(statearr_76776_76801[(1)] = (4));

(statearr_76776_76801[(5)] = null);

} else {
throw ex76769;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (14))){
var inst_76734 = (state_76755[(8)]);
var state_76755__$1 = state_76755;
var statearr_76777_76802 = state_76755__$1;
(statearr_76777_76802[(2)] = inst_76734);

(statearr_76777_76802[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (16))){
var inst_76749 = (state_76755[(2)]);
var inst_76750 = fluree.db.util.async.throw_err(inst_76749);
var _ = (function (){var statearr_76778 = state_76755;
(statearr_76778[(4)] = cljs.core.rest((state_76755[(4)])));

return statearr_76778;
})();
var state_76755__$1 = state_76755;
var statearr_76779_76803 = state_76755__$1;
(statearr_76779_76803[(2)] = inst_76750);

(statearr_76779_76803[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (10))){
var inst_76728 = (state_76755[(10)]);
var inst_76719 = (state_76755[(11)]);
var inst_76730 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76719)].join('');
var inst_76731 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_76728,"Authorization",inst_76730);
var state_76755__$1 = state_76755;
var statearr_76780_76804 = state_76755__$1;
(statearr_76780_76804[(2)] = inst_76731);

(statearr_76780_76804[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76756 === (8))){
var inst_76719 = (state_76755[(2)]);
var inst_76720 = clojure.string.replace(k,"_","/");
var inst_76721 = fluree.db.connection.get_server(conn_id,servers);
var state_76755__$1 = (function (){var statearr_76781 = state_76755;
(statearr_76781[(11)] = inst_76719);

(statearr_76781[(12)] = inst_76720);

return statearr_76781;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76755__$1,(9),inst_76721);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__14778__auto__ = null;
var fluree$db$connection$state_machine__14778__auto____0 = (function (){
var statearr_76782 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76782[(0)] = fluree$db$connection$state_machine__14778__auto__);

(statearr_76782[(1)] = (1));

return statearr_76782;
});
var fluree$db$connection$state_machine__14778__auto____1 = (function (state_76755){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_76755);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e76783){var ex__14781__auto__ = e76783;
var statearr_76784_76805 = state_76755;
(statearr_76784_76805[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_76755[(4)]))){
var statearr_76785_76806 = state_76755;
(statearr_76785_76806[(1)] = cljs.core.first((state_76755[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76807 = state_76755;
state_76755 = G__76807;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$state_machine__14778__auto__ = function(state_76755){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__14778__auto____1.call(this,state_76755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__14778__auto____0;
fluree$db$connection$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__14778__auto____1;
return fluree$db$connection$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_76786 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_76786[(6)] = c__14852__auto__);

return statearr_76786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__76808_SHARP_){
if(cljs.core.truth_(p1__76808_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__76809_SHARP_){
var or__4223__auto__ = p1__76809_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e76810){var e = e76810;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__76811 = opts;
var map__76811__$1 = cljs.core.__destructure_map(map__76811);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__76811__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76811__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__76812_76813 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__76812_76813.cljs$core$IFn$_invoke$arity$0 ? fexpr__76812_76813.cljs$core$IFn$_invoke$arity$0() : fexpr__76812_76813.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___76854 = arguments.length;
var i__4830__auto___76855 = (0);
while(true){
if((i__4830__auto___76855 < len__4829__auto___76854)){
args__4835__auto__.push((arguments[i__4830__auto___76855]));

var G__76856 = (i__4830__auto___76855 + (1));
i__4830__auto___76855 = G__76856;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__76816){
var vec__76817 = p__76816;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__76817,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__14852__auto___76857 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_76837){
var state_val_76838 = (state_76837[(1)]);
if((state_val_76838 === (1))){
var inst_76820 = fluree.db.connection.get_socket(conn);
var state_76837__$1 = state_76837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76837__$1,(2),inst_76820);
} else {
if((state_val_76838 === (2))){
var inst_76823 = (state_76837[(7)]);
var inst_76822 = (state_76837[(8)]);
var inst_76822__$1 = (state_76837[(2)]);
var inst_76823__$1 = (inst_76822__$1 == null);
var state_76837__$1 = (function (){var statearr_76839 = state_76837;
(statearr_76839[(7)] = inst_76823__$1);

(statearr_76839[(8)] = inst_76822__$1);

return statearr_76839;
})();
if(cljs.core.truth_(inst_76823__$1)){
var statearr_76840_76858 = state_76837__$1;
(statearr_76840_76858[(1)] = (3));

} else {
var statearr_76841_76859 = state_76837__$1;
(statearr_76841_76859[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76838 === (3))){
var inst_76823 = (state_76837[(7)]);
var state_76837__$1 = state_76837;
var statearr_76842_76860 = state_76837__$1;
(statearr_76842_76860[(2)] = inst_76823);

(statearr_76842_76860[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76838 === (4))){
var inst_76822 = (state_76837[(8)]);
var inst_76826 = fluree.db.util.core.exception_QMARK_(inst_76822);
var state_76837__$1 = state_76837;
var statearr_76843_76861 = state_76837__$1;
(statearr_76843_76861[(2)] = inst_76826);

(statearr_76843_76861[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76838 === (5))){
var inst_76828 = (state_76837[(2)]);
var state_76837__$1 = state_76837;
if(cljs.core.truth_(inst_76828)){
var statearr_76844_76862 = state_76837__$1;
(statearr_76844_76862[(1)] = (6));

} else {
var statearr_76845_76863 = state_76837__$1;
(statearr_76845_76863[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76838 === (6))){
var inst_76830 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_76831 = cljs.core.async.close_BANG_(conn);
var state_76837__$1 = (function (){var statearr_76846 = state_76837;
(statearr_76846[(9)] = inst_76830);

return statearr_76846;
})();
var statearr_76847_76864 = state_76837__$1;
(statearr_76847_76864[(2)] = inst_76831);

(statearr_76847_76864[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76838 === (7))){
var inst_76833 = fluree.db.connection.msg_consumer(conn);
var state_76837__$1 = state_76837;
var statearr_76848_76865 = state_76837__$1;
(statearr_76848_76865[(2)] = inst_76833);

(statearr_76848_76865[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76838 === (8))){
var inst_76835 = (state_76837[(2)]);
var state_76837__$1 = state_76837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76837__$1,inst_76835);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__14778__auto__ = null;
var fluree$db$connection$state_machine__14778__auto____0 = (function (){
var statearr_76849 = [null,null,null,null,null,null,null,null,null,null];
(statearr_76849[(0)] = fluree$db$connection$state_machine__14778__auto__);

(statearr_76849[(1)] = (1));

return statearr_76849;
});
var fluree$db$connection$state_machine__14778__auto____1 = (function (state_76837){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_76837);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e76850){var ex__14781__auto__ = e76850;
var statearr_76851_76866 = state_76837;
(statearr_76851_76866[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_76837[(4)]))){
var statearr_76852_76867 = state_76837;
(statearr_76852_76867[(1)] = cljs.core.first((state_76837[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__76868 = state_76837;
state_76837 = G__76868;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$connection$state_machine__14778__auto__ = function(state_76837){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__14778__auto____1.call(this,state_76837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__14778__auto____0;
fluree$db$connection$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__14778__auto____1;
return fluree$db$connection$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_76853 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_76853[(6)] = c__14852__auto___76857);

return statearr_76853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq76814){
var G__76815 = cljs.core.first(seq76814);
var seq76814__$1 = cljs.core.next(seq76814);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__76815,seq76814__$1);
}));

