// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4221__auto__ = typeof value === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4221__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,300,null,300,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,714,null,714,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,230,null,230,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,157,null,157,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,812,null,812,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,521,null,521,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,427,null,427,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,145,null,145,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,388,null,388,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,256,null,256,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,86,null,86,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,726,null,726,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,533,null,533,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,607,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,620,null,620,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,750,null,750,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,169,null,169,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,778,null,778,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,414,null,414,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,466,null,466,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,73,null,73,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,188,null,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,659,null,659,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,453,null,453,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,594,null,594,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,506,null,506,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,332,332,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,545,null,545,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,800,null,800,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,440,null,440,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,270,null,270,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,121,null,121,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,401,null,401,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,581,null,581,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,347,347,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,214,null,214,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,58,null,58,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,133,null,133,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,633,null,633,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,201,null,201,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,646,null,646,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,479,null,479,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,288,null,288,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,738,null,738,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,243,null,243,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__74795 = cljs.core.meta(f);
var map__74795__$1 = cljs.core.__destructure_map(map__74795);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74795__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74795__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4221__auto__ = (function (){var G__74797 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__74796 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__74796.cljs$core$IFn$_invoke$arity$1 ? fexpr__74796.cljs$core$IFn$_invoke$arity$1(G__74797) : fexpr__74796.call(null,G__74797));
})();
if(cljs.core.truth_(and__4221__auto__)){
var G__74799 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__74798 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__74798.cljs$core$IFn$_invoke$arity$1 ? fexpr__74798.cljs$core$IFn$_invoke$arity$1(G__74799) : fexpr__74798.call(null,G__74799));
} else {
return and__4221__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__74794_SHARP_){
return (cljs.core.count(p1__74794_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_74884){
var state_val_74885 = (state_74884[(1)]);
if((state_val_74885 === (7))){
var inst_74809 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_74810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74811 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_74812 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_74813 = [fn_name,inst_74811,inst_74812];
var inst_74814 = (new cljs.core.PersistentVector(null,3,(5),inst_74810,inst_74813,null));
var inst_74815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74809,inst_74814);
var state_74884__$1 = state_74884;
var statearr_74886_74923 = state_74884__$1;
(statearr_74886_74923[(2)] = inst_74815);

(statearr_74886_74923[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (1))){
var state_74884__$1 = state_74884;
var statearr_74887_74924 = state_74884__$1;
(statearr_74887_74924[(2)] = null);

(statearr_74887_74924[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (4))){
var inst_74800 = (state_74884[(2)]);
var state_74884__$1 = state_74884;
var statearr_74888_74925 = state_74884__$1;
(statearr_74888_74925[(2)] = inst_74800);

(statearr_74888_74925[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (15))){
var inst_74847 = (state_74884[(7)]);
var inst_74833 = (state_74884[(8)]);
var inst_74845 = (state_74884[(2)]);
var inst_74846 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74833,"_fn/params");
var inst_74847__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_74846);
var inst_74848 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74833,"_fn/code");
var inst_74849 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_74848);
var inst_74850 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74849,funType,inst_74847__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_74849,funType,inst_74847__$1));
var state_74884__$1 = (function (){var statearr_74889 = state_74884;
(statearr_74889[(7)] = inst_74847__$1);

(statearr_74889[(9)] = inst_74845);

return statearr_74889;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74884__$1,(16),inst_74850);
} else {
if((state_val_74885 === (13))){
var inst_74836 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_74837 = ["Unknown function: ",inst_74836].join('');
var inst_74838 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74839 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_74840 = cljs.core.PersistentHashMap.fromArrays(inst_74838,inst_74839);
var inst_74841 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74837,inst_74840);
var inst_74842 = (function(){throw inst_74841})();
var state_74884__$1 = state_74884;
var statearr_74890_74926 = state_74884__$1;
(statearr_74890_74926[(2)] = inst_74842);

(statearr_74890_74926[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (6))){
var state_74884__$1 = state_74884;
var statearr_74891_74927 = state_74884__$1;
(statearr_74891_74927[(2)] = null);

(statearr_74891_74927[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (17))){
var state_74884__$1 = state_74884;
var statearr_74892_74928 = state_74884__$1;
(statearr_74892_74928[(2)] = null);

(statearr_74892_74928[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (3))){
var inst_74882 = (state_74884[(2)]);
var state_74884__$1 = state_74884;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74884__$1,inst_74882);
} else {
if((state_val_74885 === (12))){
var inst_74833 = (state_74884[(8)]);
var inst_74832 = (state_74884[(2)]);
var inst_74833__$1 = fluree.db.util.async.throw_err(inst_74832);
var inst_74834 = cljs.core.empty_QMARK_(inst_74833__$1);
var state_74884__$1 = (function (){var statearr_74893 = state_74884;
(statearr_74893[(8)] = inst_74833__$1);

return statearr_74893;
})();
if(inst_74834){
var statearr_74894_74929 = state_74884__$1;
(statearr_74894_74929[(1)] = (13));

} else {
var statearr_74895_74930 = state_74884__$1;
(statearr_74895_74930[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (2))){
var inst_74806 = (state_74884[(10)]);
var _ = (function (){var statearr_74896 = state_74884;
(statearr_74896[(4)] = cljs.core.cons((5),(state_74884[(4)])));

return statearr_74896;
})();
var inst_74806__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_74884__$1 = (function (){var statearr_74897 = state_74884;
(statearr_74897[(10)] = inst_74806__$1);

return statearr_74897;
})();
if(cljs.core.truth_(inst_74806__$1)){
var statearr_74898_74931 = state_74884__$1;
(statearr_74898_74931[(1)] = (6));

} else {
var statearr_74899_74932 = state_74884__$1;
(statearr_74899_74932[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (19))){
var inst_74867 = (state_74884[(11)]);
var inst_74877 = (state_74884[(2)]);
var state_74884__$1 = (function (){var statearr_74900 = state_74884;
(statearr_74900[(12)] = inst_74877);

return statearr_74900;
})();
var statearr_74901_74933 = state_74884__$1;
(statearr_74901_74933[(2)] = inst_74867);

(statearr_74901_74933[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (11))){
var inst_74879 = (state_74884[(2)]);
var _ = (function (){var statearr_74903 = state_74884;
(statearr_74903[(4)] = cljs.core.rest((state_74884[(4)])));

return statearr_74903;
})();
var state_74884__$1 = state_74884;
var statearr_74904_74934 = state_74884__$1;
(statearr_74904_74934[(2)] = inst_74879);

(statearr_74904_74934[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (9))){
var inst_74817 = (state_74884[(13)]);
var state_74884__$1 = state_74884;
var statearr_74905_74935 = state_74884__$1;
(statearr_74905_74935[(2)] = inst_74817);

(statearr_74905_74935[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (5))){
var _ = (function (){var statearr_74906 = state_74884;
(statearr_74906[(4)] = cljs.core.rest((state_74884[(4)])));

return statearr_74906;
})();
var state_74884__$1 = state_74884;
var ex74902 = (state_74884__$1[(2)]);
var statearr_74907_74936 = state_74884__$1;
(statearr_74907_74936[(5)] = ex74902);


if((ex74902 instanceof Error)){
var statearr_74908_74937 = state_74884__$1;
(statearr_74908_74937[(1)] = (4));

(statearr_74908_74937[(5)] = null);

} else {
throw ex74902;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (14))){
var state_74884__$1 = state_74884;
var statearr_74909_74938 = state_74884__$1;
(statearr_74909_74938[(2)] = null);

(statearr_74909_74938[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (16))){
var inst_74847 = (state_74884[(7)]);
var inst_74829 = (state_74884[(14)]);
var inst_74817 = (state_74884[(13)]);
var inst_74845 = (state_74884[(9)]);
var inst_74833 = (state_74884[(8)]);
var inst_74806 = (state_74884[(10)]);
var inst_74852 = (state_74884[(2)]);
var inst_74853 = fluree.db.util.async.throw_err(inst_74852);
var inst_74854 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_74833,"_fn/spec");
var inst_74855 = cljs.core.PersistentVector.EMPTY;
var inst_74856 = cljs.core.cst$sym$_QMARK_ctx;
var inst_74857 = (function (){var forward_time_travel_db_QMARK_ = inst_74806;
var or__4223__auto__ = inst_74817;
var query = inst_74829;
var res = inst_74833;
var _ = inst_74845;
var params = inst_74847;
var code = inst_74853;
var spec = inst_74854;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_74858 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_74857,inst_74847);
var inst_74859 = cljs.core.cons(inst_74856,inst_74858);
var inst_74860 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_74855,inst_74859);
var inst_74861 = fluree.db.dbfunctions.core.build_fn(inst_74860,inst_74853);
var inst_74862 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_74863 = cljs.core.count(inst_74847);
var inst_74864 = [inst_74863];
var inst_74865 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_74864);
var inst_74866 = [inst_74861,inst_74847,inst_74865,false,inst_74854,null];
var inst_74867 = cljs.core.PersistentHashMap.fromArrays(inst_74862,inst_74866);
var state_74884__$1 = (function (){var statearr_74910 = state_74884;
(statearr_74910[(11)] = inst_74867);

return statearr_74910;
})();
if(cljs.core.truth_(inst_74806)){
var statearr_74911_74939 = state_74884__$1;
(statearr_74911_74939[(1)] = (17));

} else {
var statearr_74912_74940 = state_74884__$1;
(statearr_74912_74940[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (10))){
var inst_74829 = (state_74884[(14)]);
var inst_74820 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_74821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74822 = ["_fn/params","_fn/code","_fn/spec"];
var inst_74823 = (new cljs.core.PersistentVector(null,3,(5),inst_74821,inst_74822,null));
var inst_74824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74825 = cljs.core.name(fn_name);
var inst_74826 = ["_fn/name",inst_74825];
var inst_74827 = (new cljs.core.PersistentVector(null,2,(5),inst_74824,inst_74826,null));
var inst_74828 = [inst_74823,inst_74827];
var inst_74829__$1 = cljs.core.PersistentHashMap.fromArrays(inst_74820,inst_74828);
var inst_74830 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_74829__$1);
var state_74884__$1 = (function (){var statearr_74913 = state_74884;
(statearr_74913[(14)] = inst_74829__$1);

return statearr_74913;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74884__$1,(12),inst_74830);
} else {
if((state_val_74885 === (18))){
var inst_74867 = (state_74884[(11)]);
var inst_74870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74871 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_74872 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_74873 = [fn_name,inst_74871,inst_74872];
var inst_74874 = (new cljs.core.PersistentVector(null,3,(5),inst_74870,inst_74873,null));
var inst_74875 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_74874,inst_74867);
var state_74884__$1 = state_74884;
var statearr_74914_74941 = state_74884__$1;
(statearr_74914_74941[(2)] = inst_74875);

(statearr_74914_74941[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74885 === (8))){
var inst_74817 = (state_74884[(13)]);
var inst_74817__$1 = (state_74884[(2)]);
var state_74884__$1 = (function (){var statearr_74915 = state_74884;
(statearr_74915[(13)] = inst_74817__$1);

return statearr_74915;
})();
if(cljs.core.truth_(inst_74817__$1)){
var statearr_74916_74942 = state_74884__$1;
(statearr_74916_74942[(1)] = (9));

} else {
var statearr_74917_74943 = state_74884__$1;
(statearr_74917_74943[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto____0 = (function (){
var statearr_74918 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74918[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto__);

(statearr_74918[(1)] = (1));

return statearr_74918;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto____1 = (function (state_74884){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_74884);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e74919){var ex__14781__auto__ = e74919;
var statearr_74920_74944 = state_74884;
(statearr_74920_74944[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_74884[(4)]))){
var statearr_74921_74945 = state_74884;
(statearr_74921_74945[(1)] = cljs.core.first((state_74884[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__74946 = state_74884;
state_74884 = G__74946;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto__ = function(state_74884){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto____1.call(this,state_74884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_74922 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_74922[(6)] = c__14852__auto__);

return statearr_74922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__74948 = arguments.length;
switch (G__74948) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__74952 = arguments.length;
switch (G__74952) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_75082){
var state_val_75083 = (state_75082[(1)]);
if((state_val_75083 === (7))){
var inst_75077 = (state_75082[(2)]);
var _ = (function (){var statearr_75084 = state_75082;
(statearr_75084[(4)] = cljs.core.rest((state_75082[(4)])));

return statearr_75084;
})();
var state_75082__$1 = state_75082;
var statearr_75085_75165 = state_75082__$1;
(statearr_75085_75165[(2)] = inst_75077);

(statearr_75085_75165[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (20))){
var inst_74991 = (state_75082[(7)]);
var state_75082__$1 = state_75082;
var statearr_75086_75166 = state_75082__$1;
(statearr_75086_75166[(2)] = inst_74991);

(statearr_75086_75166[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (27))){
var inst_74978 = (state_75082[(8)]);
var inst_75004 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_75005 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74978)," used in function.",inst_75004].join('');
var inst_75006 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75007 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_75008 = cljs.core.PersistentHashMap.fromArrays(inst_75006,inst_75007);
var inst_75009 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75005,inst_75008);
var inst_75010 = (function(){throw inst_75009})();
var state_75082__$1 = state_75082;
var statearr_75087_75167 = state_75082__$1;
(statearr_75087_75167[(2)] = inst_75010);

(statearr_75087_75167[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (1))){
var state_75082__$1 = state_75082;
var statearr_75088_75168 = state_75082__$1;
(statearr_75088_75168[(2)] = null);

(statearr_75088_75168[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (24))){
var inst_75001 = (state_75082[(9)]);
var inst_75001__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_75082__$1 = (function (){var statearr_75089 = state_75082;
(statearr_75089[(9)] = inst_75001__$1);

return statearr_75089;
})();
if(inst_75001__$1){
var statearr_75090_75169 = state_75082__$1;
(statearr_75090_75169[(1)] = (26));

} else {
var statearr_75091_75170 = state_75082__$1;
(statearr_75091_75170[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (39))){
var inst_74978 = (state_75082[(8)]);
var inst_75038 = (inst_74978 == null);
var state_75082__$1 = state_75082;
if(cljs.core.truth_(inst_75038)){
var statearr_75092_75171 = state_75082__$1;
(statearr_75092_75171[(1)] = (42));

} else {
var statearr_75093_75172 = state_75082__$1;
(statearr_75093_75172[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (46))){
var state_75082__$1 = state_75082;
var statearr_75094_75173 = state_75082__$1;
(statearr_75094_75173[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (4))){
var inst_74953 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75096_75174 = state_75082__$1;
(statearr_75096_75174[(2)] = inst_74953);

(statearr_75096_75174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (15))){
var inst_74978 = (state_75082[(8)]);
var inst_74989 = (inst_74978 instanceof cljs.core.Symbol);
var state_75082__$1 = state_75082;
if(cljs.core.truth_(inst_74989)){
var statearr_75097_75175 = state_75082__$1;
(statearr_75097_75175[(1)] = (17));

} else {
var statearr_75098_75176 = state_75082__$1;
(statearr_75098_75176[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (48))){
var inst_75045 = (state_75082[(2)]);
var inst_75046 = fluree.db.util.async.throw_err(inst_75045);
var state_75082__$1 = state_75082;
var statearr_75099_75177 = state_75082__$1;
(statearr_75099_75177[(2)] = inst_75046);

(statearr_75099_75177[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (50))){
var state_75082__$1 = state_75082;
var statearr_75100_75178 = state_75082__$1;
(statearr_75100_75178[(2)] = null);

(statearr_75100_75178[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (21))){
var inst_74991 = (state_75082[(7)]);
var inst_74968 = (state_75082[(10)]);
var inst_74966 = (state_75082[(11)]);
var inst_74979 = (state_75082[(12)]);
var inst_74978 = (state_75082[(8)]);
var inst_74969 = (state_75082[(13)]);
var inst_74998 = (state_75082[(14)]);
var inst_74971 = (state_75082[(15)]);
var inst_74972 = (state_75082[(16)]);
var inst_74994 = [inst_74978];
var inst_74995 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_74994);
var inst_74996 = (function (){var x = inst_74978;
var vec__74974 = inst_74971;
var r = inst_74979;
var acc = inst_74972;
var or__4223__auto__ = inst_74991;
var seq__74975 = inst_74979;
var first__74976 = inst_74978;
var seq__74964 = inst_74969;
var vec__74963 = inst_74966;
var first__74965 = inst_74968;
var G__74962 = inst_74971;
return (function (p1__74950_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__74950_SHARP_);
});
})();
var inst_74997 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_74996,params);
var inst_74998__$1 = cljs.core.some(inst_74995,inst_74997);
var state_75082__$1 = (function (){var statearr_75101 = state_75082;
(statearr_75101[(14)] = inst_74998__$1);

return statearr_75101;
})();
if(cljs.core.truth_(inst_74998__$1)){
var statearr_75102_75179 = state_75082__$1;
(statearr_75102_75179[(1)] = (23));

} else {
var statearr_75103_75180 = state_75082__$1;
(statearr_75103_75180[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (31))){
var inst_75028 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
if(cljs.core.truth_(inst_75028)){
var statearr_75104_75181 = state_75082__$1;
(statearr_75104_75181[(1)] = (35));

} else {
var statearr_75105_75182 = state_75082__$1;
(statearr_75105_75182[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (32))){
var inst_75021 = (state_75082[(17)]);
var state_75082__$1 = state_75082;
var statearr_75106_75183 = state_75082__$1;
(statearr_75106_75183[(2)] = inst_75021);

(statearr_75106_75183[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (40))){
var inst_75063 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75107_75184 = state_75082__$1;
(statearr_75107_75184[(2)] = inst_75063);

(statearr_75107_75184[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (33))){
var inst_74978 = (state_75082[(8)]);
var inst_75024 = (inst_74978 == null);
var state_75082__$1 = state_75082;
var statearr_75108_75185 = state_75082__$1;
(statearr_75108_75185[(2)] = inst_75024);

(statearr_75108_75185[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (13))){
var inst_74979 = (state_75082[(12)]);
var inst_74972 = (state_75082[(16)]);
var inst_75071 = (state_75082[(2)]);
var inst_75072 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_74972,inst_75071);
var inst_74971 = inst_74979;
var inst_74972__$1 = inst_75072;
var state_75082__$1 = (function (){var statearr_75109 = state_75082;
(statearr_75109[(15)] = inst_74971);

(statearr_75109[(16)] = inst_74972__$1);

return statearr_75109;
})();
var statearr_75110_75186 = state_75082__$1;
(statearr_75110_75186[(2)] = null);

(statearr_75110_75186[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (22))){
var inst_75016 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75111_75187 = state_75082__$1;
(statearr_75111_75187[(2)] = inst_75016);

(statearr_75111_75187[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (36))){
var inst_74978 = (state_75082[(8)]);
var inst_75031 = cljs.core.vector_QMARK_(inst_74978);
var state_75082__$1 = state_75082;
if(inst_75031){
var statearr_75112_75188 = state_75082__$1;
(statearr_75112_75188[(1)] = (38));

} else {
var statearr_75113_75189 = state_75082__$1;
(statearr_75113_75189[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (41))){
var inst_75035 = (state_75082[(2)]);
var inst_75036 = fluree.db.util.async.throw_err(inst_75035);
var state_75082__$1 = state_75082;
var statearr_75114_75190 = state_75082__$1;
(statearr_75114_75190[(2)] = inst_75036);

(statearr_75114_75190[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (43))){
var inst_74978 = (state_75082[(8)]);
var inst_75041 = cljs.core.list_QMARK_(inst_74978);
var state_75082__$1 = state_75082;
if(inst_75041){
var statearr_75115_75191 = state_75082__$1;
(statearr_75115_75191[(1)] = (45));

} else {
var statearr_75116_75192 = state_75082__$1;
(statearr_75116_75192[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (29))){
var inst_75018 = (state_75082[(18)]);
var state_75082__$1 = state_75082;
var statearr_75117_75193 = state_75082__$1;
(statearr_75117_75193[(2)] = inst_75018);

(statearr_75117_75193[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (44))){
var inst_75061 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75118_75194 = state_75082__$1;
(statearr_75118_75194[(2)] = inst_75061);

(statearr_75118_75194[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (6))){
var inst_74978 = (state_75082[(8)]);
var inst_74971 = (state_75082[(15)]);
var inst_74977 = cljs.core.seq(inst_74971);
var inst_74978__$1 = cljs.core.first(inst_74977);
var inst_74979 = cljs.core.next(inst_74977);
var inst_74980 = (inst_74978__$1 == null);
var state_75082__$1 = (function (){var statearr_75119 = state_75082;
(statearr_75119[(12)] = inst_74979);

(statearr_75119[(8)] = inst_74978__$1);

return statearr_75119;
})();
if(cljs.core.truth_(inst_74980)){
var statearr_75120_75195 = state_75082__$1;
(statearr_75120_75195[(1)] = (8));

} else {
var statearr_75121_75196 = state_75082__$1;
(statearr_75121_75196[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (28))){
var inst_75012 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75122_75197 = state_75082__$1;
(statearr_75122_75197[(2)] = inst_75012);

(statearr_75122_75197[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (51))){
var inst_75057 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75123_75198 = state_75082__$1;
(statearr_75123_75198[(2)] = inst_75057);

(statearr_75123_75198[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (25))){
var inst_75014 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75124_75199 = state_75082__$1;
(statearr_75124_75199[(2)] = inst_75014);

(statearr_75124_75199[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (34))){
var inst_75026 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75125_75200 = state_75082__$1;
(statearr_75125_75200[(2)] = inst_75026);

(statearr_75125_75200[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (17))){
var inst_74991 = (state_75082[(7)]);
var inst_74978 = (state_75082[(8)]);
var inst_74991__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_74978) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_74978));
var state_75082__$1 = (function (){var statearr_75126 = state_75082;
(statearr_75126[(7)] = inst_74991__$1);

return statearr_75126;
})();
if(cljs.core.truth_(inst_74991__$1)){
var statearr_75127_75201 = state_75082__$1;
(statearr_75127_75201[(1)] = (20));

} else {
var statearr_75128_75202 = state_75082__$1;
(statearr_75128_75202[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (3))){
var inst_75080 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75082__$1,inst_75080);
} else {
if((state_val_75083 === (12))){
var inst_74978 = (state_75082[(8)]);
var inst_74986 = typeof inst_74978 === 'number';
var state_75082__$1 = state_75082;
if(cljs.core.truth_(inst_74986)){
var statearr_75129_75203 = state_75082__$1;
(statearr_75129_75203[(1)] = (14));

} else {
var statearr_75130_75204 = state_75082__$1;
(statearr_75130_75204[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (2))){
var inst_74966 = (state_75082[(11)]);
var _ = (function (){var statearr_75131 = state_75082;
(statearr_75131[(4)] = cljs.core.cons((5),(state_75082[(4)])));

return statearr_75131;
})();
var inst_74966__$1 = vec;
var inst_74967 = cljs.core.seq(inst_74966__$1);
var inst_74968 = cljs.core.first(inst_74967);
var inst_74969 = cljs.core.next(inst_74967);
var inst_74970 = cljs.core.PersistentVector.EMPTY;
var inst_74971 = inst_74966__$1;
var inst_74972 = inst_74970;
var state_75082__$1 = (function (){var statearr_75132 = state_75082;
(statearr_75132[(10)] = inst_74968);

(statearr_75132[(11)] = inst_74966__$1);

(statearr_75132[(13)] = inst_74969);

(statearr_75132[(15)] = inst_74971);

(statearr_75132[(16)] = inst_74972);

return statearr_75132;
})();
var statearr_75133_75205 = state_75082__$1;
(statearr_75133_75205[(2)] = null);

(statearr_75133_75205[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (23))){
var inst_74998 = (state_75082[(14)]);
var state_75082__$1 = state_75082;
var statearr_75134_75206 = state_75082__$1;
(statearr_75134_75206[(2)] = inst_74998);

(statearr_75134_75206[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (47))){
var inst_75059 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75135_75207 = state_75082__$1;
(statearr_75135_75207[(2)] = inst_75059);

(statearr_75135_75207[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (35))){
var inst_74978 = (state_75082[(8)]);
var state_75082__$1 = state_75082;
var statearr_75136_75208 = state_75082__$1;
(statearr_75136_75208[(2)] = inst_74978);

(statearr_75136_75208[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (19))){
var inst_75067 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75137_75209 = state_75082__$1;
(statearr_75137_75209[(2)] = inst_75067);

(statearr_75137_75209[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (11))){
var inst_74978 = (state_75082[(8)]);
var state_75082__$1 = state_75082;
var statearr_75139_75210 = state_75082__$1;
(statearr_75139_75210[(2)] = inst_74978);

(statearr_75139_75210[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (9))){
var inst_74978 = (state_75082[(8)]);
var inst_74983 = typeof inst_74978 === 'string';
var state_75082__$1 = state_75082;
if(cljs.core.truth_(inst_74983)){
var statearr_75140_75211 = state_75082__$1;
(statearr_75140_75211[(1)] = (11));

} else {
var statearr_75141_75212 = state_75082__$1;
(statearr_75141_75212[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (5))){
var _ = (function (){var statearr_75142 = state_75082;
(statearr_75142[(4)] = cljs.core.rest((state_75082[(4)])));

return statearr_75142;
})();
var state_75082__$1 = state_75082;
var ex75138 = (state_75082__$1[(2)]);
var statearr_75143_75213 = state_75082__$1;
(statearr_75143_75213[(5)] = ex75138);


if((ex75138 instanceof Error)){
var statearr_75144_75214 = state_75082__$1;
(statearr_75144_75214[(1)] = (4));

(statearr_75144_75214[(5)] = null);

} else {
throw ex75138;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (14))){
var inst_74978 = (state_75082[(8)]);
var state_75082__$1 = state_75082;
var statearr_75145_75215 = state_75082__$1;
(statearr_75145_75215[(2)] = inst_74978);

(statearr_75145_75215[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (45))){
var inst_74978 = (state_75082[(8)]);
var inst_75043 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_74978,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_74978,funType,params));
var state_75082__$1 = state_75082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75082__$1,(48),inst_75043);
} else {
if((state_val_75083 === (26))){
var inst_75001 = (state_75082[(9)]);
var state_75082__$1 = state_75082;
var statearr_75146_75216 = state_75082__$1;
(statearr_75146_75216[(2)] = inst_75001);

(statearr_75146_75216[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (16))){
var inst_75069 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75147_75217 = state_75082__$1;
(statearr_75147_75217[(2)] = inst_75069);

(statearr_75147_75217[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (38))){
var inst_74978 = (state_75082[(8)]);
var inst_75033 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_74978,funType,params);
var state_75082__$1 = state_75082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75082__$1,(41),inst_75033);
} else {
if((state_val_75083 === (30))){
var inst_75021 = (state_75082[(17)]);
var inst_74978 = (state_75082[(8)]);
var inst_75021__$1 = inst_74978 === false;
var state_75082__$1 = (function (){var statearr_75148 = state_75082;
(statearr_75148[(17)] = inst_75021__$1);

return statearr_75148;
})();
if(cljs.core.truth_(inst_75021__$1)){
var statearr_75149_75218 = state_75082__$1;
(statearr_75149_75218[(1)] = (32));

} else {
var statearr_75150_75219 = state_75082__$1;
(statearr_75150_75219[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (10))){
var inst_75075 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75151_75220 = state_75082__$1;
(statearr_75151_75220[(2)] = inst_75075);

(statearr_75151_75220[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (18))){
var inst_75018 = (state_75082[(18)]);
var inst_74978 = (state_75082[(8)]);
var inst_75018__$1 = inst_74978 === true;
var state_75082__$1 = (function (){var statearr_75152 = state_75082;
(statearr_75152[(18)] = inst_75018__$1);

return statearr_75152;
})();
if(cljs.core.truth_(inst_75018__$1)){
var statearr_75153_75221 = state_75082__$1;
(statearr_75153_75221[(1)] = (29));

} else {
var statearr_75154_75222 = state_75082__$1;
(statearr_75154_75222[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (42))){
var inst_74978 = (state_75082[(8)]);
var state_75082__$1 = state_75082;
var statearr_75155_75223 = state_75082__$1;
(statearr_75155_75223[(2)] = inst_74978);

(statearr_75155_75223[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (37))){
var inst_75065 = (state_75082[(2)]);
var state_75082__$1 = state_75082;
var statearr_75156_75224 = state_75082__$1;
(statearr_75156_75224[(2)] = inst_75065);

(statearr_75156_75224[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (8))){
var inst_74972 = (state_75082[(16)]);
var state_75082__$1 = state_75082;
var statearr_75157_75225 = state_75082__$1;
(statearr_75157_75225[(2)] = inst_74972);

(statearr_75157_75225[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75083 === (49))){
var inst_74978 = (state_75082[(8)]);
var inst_75049 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74978], 0));
var inst_75050 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_75051 = ["Illegal element (",inst_75049,") in vector: ",inst_75050,"."].join('');
var inst_75052 = cljs.core.PersistentHashMap.EMPTY;
var inst_75053 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75051,inst_75052);
var inst_75054 = (function(){throw inst_75053})();
var state_75082__$1 = state_75082;
var statearr_75158_75226 = state_75082__$1;
(statearr_75158_75226[(2)] = inst_75054);

(statearr_75158_75226[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__14778__auto____0 = (function (){
var statearr_75159 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75159[(0)] = fluree$db$dbfunctions$core$state_machine__14778__auto__);

(statearr_75159[(1)] = (1));

return statearr_75159;
});
var fluree$db$dbfunctions$core$state_machine__14778__auto____1 = (function (state_75082){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_75082);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e75160){var ex__14781__auto__ = e75160;
var statearr_75161_75227 = state_75082;
(statearr_75161_75227[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_75082[(4)]))){
var statearr_75162_75228 = state_75082;
(statearr_75162_75228[(1)] = cljs.core.first((state_75082[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__75229 = state_75082;
state_75082 = G__75229;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__14778__auto__ = function(state_75082){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__14778__auto____1.call(this,state_75082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__14778__auto____0;
fluree$db$dbfunctions$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__14778__auto____1;
return fluree$db$dbfunctions$core$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_75163 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_75163[(6)] = c__14852__auto__);

return statearr_75163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__75232 = arguments.length;
switch (G__75232) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_75396){
var state_val_75397 = (state_75396[(1)]);
if((state_val_75397 === (7))){
var inst_75240 = (state_75396[(7)]);
var inst_75246 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_75240,type);
var state_75396__$1 = state_75396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75396__$1,(9),inst_75246);
} else {
if((state_val_75397 === (59))){
var inst_75289 = (state_75396[(8)]);
var inst_75360 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75289], 0));
var inst_75361 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_75289) : type.call(null,inst_75289));
var inst_75362 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_75363 = ["Illegal element (",inst_75360,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75361),") in function argument: ",inst_75362,"."].join('');
var inst_75364 = cljs.core.PersistentHashMap.EMPTY;
var inst_75365 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75363,inst_75364);
var inst_75366 = (function(){throw inst_75365})();
var state_75396__$1 = state_75396;
var statearr_75398_75493 = state_75396__$1;
(statearr_75398_75493[(2)] = inst_75366);

(statearr_75398_75493[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (20))){
var inst_75295 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
if(cljs.core.truth_(inst_75295)){
var statearr_75399_75494 = state_75396__$1;
(statearr_75399_75494[(1)] = (21));

} else {
var statearr_75400_75495 = state_75396__$1;
(statearr_75400_75495[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (58))){
var inst_75356 = (state_75396[(2)]);
var inst_75357 = fluree.db.util.async.throw_err(inst_75356);
var state_75396__$1 = state_75396;
var statearr_75401_75496 = state_75396__$1;
(statearr_75401_75496[(2)] = inst_75357);

(statearr_75401_75496[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (60))){
var state_75396__$1 = state_75396;
var statearr_75402_75497 = state_75396__$1;
(statearr_75402_75497[(2)] = null);

(statearr_75402_75497[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (27))){
var inst_75301 = (state_75396[(2)]);
var inst_75302 = fluree.db.util.async.throw_err(inst_75301);
var state_75396__$1 = state_75396;
var statearr_75403_75498 = state_75396__$1;
(statearr_75403_75498[(2)] = inst_75302);

(statearr_75403_75498[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (1))){
var state_75396__$1 = state_75396;
var statearr_75404_75499 = state_75396__$1;
(statearr_75404_75499[(2)] = null);

(statearr_75404_75499[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (24))){
var inst_75289 = (state_75396[(8)]);
var inst_75299 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_75289,type,params);
var state_75396__$1 = state_75396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75396__$1,(27),inst_75299);
} else {
if((state_val_75397 === (55))){
var inst_75289 = (state_75396[(8)]);
var inst_75354 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_75289,type,params);
var state_75396__$1 = state_75396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75396__$1,(58),inst_75354);
} else {
if((state_val_75397 === (39))){
var inst_75337 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75405_75500 = state_75396__$1;
(statearr_75405_75500[(2)] = inst_75337);

(statearr_75405_75500[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (46))){
var inst_75339 = (state_75396[(9)]);
var state_75396__$1 = state_75396;
var statearr_75406_75501 = state_75396__$1;
(statearr_75406_75501[(2)] = inst_75339);

(statearr_75406_75501[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (4))){
var inst_75233 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75407_75502 = state_75396__$1;
(statearr_75407_75502[(2)] = inst_75233);

(statearr_75407_75502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (54))){
var inst_75373 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75408_75503 = state_75396__$1;
(statearr_75408_75503[(2)] = inst_75373);

(statearr_75408_75503[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (15))){
var inst_75241 = (state_75396[(10)]);
var inst_75270 = (state_75396[(2)]);
var inst_75278 = cljs.core.seq(inst_75241);
var inst_75279 = cljs.core.first(inst_75278);
var inst_75280 = cljs.core.next(inst_75278);
var inst_75281 = cljs.core.PersistentVector.EMPTY;
var inst_75282 = inst_75241;
var inst_75283 = inst_75281;
var state_75396__$1 = (function (){var statearr_75409 = state_75396;
(statearr_75409[(11)] = inst_75279);

(statearr_75409[(12)] = inst_75282);

(statearr_75409[(13)] = inst_75270);

(statearr_75409[(14)] = inst_75283);

(statearr_75409[(15)] = inst_75280);

return statearr_75409;
})();
var statearr_75410_75504 = state_75396__$1;
(statearr_75410_75504[(2)] = null);

(statearr_75410_75504[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (48))){
var inst_75349 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
if(cljs.core.truth_(inst_75349)){
var statearr_75411_75505 = state_75396__$1;
(statearr_75411_75505[(1)] = (52));

} else {
var statearr_75412_75506 = state_75396__$1;
(statearr_75412_75506[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (50))){
var inst_75289 = (state_75396[(8)]);
var inst_75345 = (inst_75289 == null);
var state_75396__$1 = state_75396;
var statearr_75413_75507 = state_75396__$1;
(statearr_75413_75507[(2)] = inst_75345);

(statearr_75413_75507[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (21))){
var inst_75289 = (state_75396[(8)]);
var inst_75297 = cljs.core.list_QMARK_(inst_75289);
var state_75396__$1 = state_75396;
if(inst_75297){
var statearr_75414_75508 = state_75396__$1;
(statearr_75414_75508[(1)] = (24));

} else {
var statearr_75415_75509 = state_75396__$1;
(statearr_75415_75509[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (31))){
var inst_75289 = (state_75396[(8)]);
var state_75396__$1 = state_75396;
var statearr_75416_75510 = state_75396__$1;
(statearr_75416_75510[(2)] = inst_75289);

(statearr_75416_75510[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (32))){
var inst_75289 = (state_75396[(8)]);
var inst_75310 = (inst_75289 instanceof cljs.core.Symbol);
var state_75396__$1 = state_75396;
if(cljs.core.truth_(inst_75310)){
var statearr_75417_75511 = state_75396__$1;
(statearr_75417_75511[(1)] = (34));

} else {
var statearr_75418_75512 = state_75396__$1;
(statearr_75418_75512[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (40))){
var inst_75319 = (state_75396[(16)]);
var state_75396__$1 = state_75396;
var statearr_75419_75513 = state_75396__$1;
(statearr_75419_75513[(2)] = inst_75319);

(statearr_75419_75513[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (56))){
var state_75396__$1 = state_75396;
var statearr_75420_75514 = state_75396__$1;
(statearr_75420_75514[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (33))){
var inst_75377 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75422_75515 = state_75396__$1;
(statearr_75422_75515[(2)] = inst_75377);

(statearr_75422_75515[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (13))){
var inst_75240 = (state_75396[(7)]);
var inst_75254 = (state_75396[(17)]);
var inst_75242 = (state_75396[(18)]);
var inst_75264 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75240),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75254),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75242),"."].join('');
var inst_75265 = cljs.core.PersistentHashMap.EMPTY;
var inst_75266 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75264,inst_75265);
var inst_75267 = (function(){throw inst_75266})();
var state_75396__$1 = state_75396;
var statearr_75423_75516 = state_75396__$1;
(statearr_75423_75516[(2)] = inst_75267);

(statearr_75423_75516[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (22))){
var inst_75283 = (state_75396[(14)]);
var state_75396__$1 = state_75396;
var statearr_75424_75517 = state_75396__$1;
(statearr_75424_75517[(2)] = inst_75283);

(statearr_75424_75517[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (36))){
var inst_75375 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75425_75518 = state_75396__$1;
(statearr_75425_75518[(2)] = inst_75375);

(statearr_75425_75518[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (41))){
var inst_75322 = (state_75396[(19)]);
var inst_75322__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_75396__$1 = (function (){var statearr_75426 = state_75396;
(statearr_75426[(19)] = inst_75322__$1);

return statearr_75426;
})();
if(inst_75322__$1){
var statearr_75427_75519 = state_75396__$1;
(statearr_75427_75519[(1)] = (43));

} else {
var statearr_75428_75520 = state_75396__$1;
(statearr_75428_75520[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (43))){
var inst_75322 = (state_75396[(19)]);
var state_75396__$1 = state_75396;
var statearr_75429_75521 = state_75396__$1;
(statearr_75429_75521[(2)] = inst_75322);

(statearr_75429_75521[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (61))){
var inst_75369 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75430_75522 = state_75396__$1;
(statearr_75430_75522[(2)] = inst_75369);

(statearr_75430_75522[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (29))){
var inst_75289 = (state_75396[(8)]);
var inst_75307 = typeof inst_75289 === 'number';
var state_75396__$1 = state_75396;
if(cljs.core.truth_(inst_75307)){
var statearr_75431_75523 = state_75396__$1;
(statearr_75431_75523[(1)] = (31));

} else {
var statearr_75432_75524 = state_75396__$1;
(statearr_75432_75524[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (44))){
var inst_75289 = (state_75396[(8)]);
var inst_75325 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_75326 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75289)," used in function argument: ",inst_75325].join('');
var inst_75327 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75328 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_75329 = cljs.core.PersistentHashMap.fromArrays(inst_75327,inst_75328);
var inst_75330 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75326,inst_75329);
var inst_75331 = (function(){throw inst_75330})();
var state_75396__$1 = state_75396;
var statearr_75433_75525 = state_75396__$1;
(statearr_75433_75525[(2)] = inst_75331);

(statearr_75433_75525[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (6))){
var inst_75243 = (state_75396[(20)]);
var state_75396__$1 = state_75396;
var statearr_75434_75526 = state_75396__$1;
(statearr_75434_75526[(2)] = inst_75243);

(statearr_75434_75526[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (28))){
var inst_75289 = (state_75396[(8)]);
var state_75396__$1 = state_75396;
var statearr_75435_75527 = state_75396__$1;
(statearr_75435_75527[(2)] = inst_75289);

(statearr_75435_75527[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (51))){
var inst_75347 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75436_75528 = state_75396__$1;
(statearr_75436_75528[(2)] = inst_75347);

(statearr_75436_75528[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (25))){
var inst_75289 = (state_75396[(8)]);
var inst_75304 = typeof inst_75289 === 'string';
var state_75396__$1 = state_75396;
if(cljs.core.truth_(inst_75304)){
var statearr_75437_75529 = state_75396__$1;
(statearr_75437_75529[(1)] = (28));

} else {
var statearr_75438_75530 = state_75396__$1;
(statearr_75438_75530[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (34))){
var inst_75289 = (state_75396[(8)]);
var inst_75312 = (state_75396[(21)]);
var inst_75312__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_75289) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_75289));
var state_75396__$1 = (function (){var statearr_75439 = state_75396;
(statearr_75439[(21)] = inst_75312__$1);

return statearr_75439;
})();
if(cljs.core.truth_(inst_75312__$1)){
var statearr_75440_75531 = state_75396__$1;
(statearr_75440_75531[(1)] = (37));

} else {
var statearr_75441_75532 = state_75396__$1;
(statearr_75441_75532[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (17))){
var inst_75253 = (state_75396[(22)]);
var inst_75388 = (state_75396[(2)]);
var inst_75389 = cljs.core.cst$sym$_QMARK_ctx;
var inst_75390 = cljs.core.cons(inst_75389,inst_75388);
var inst_75391 = cljs.core.cons(inst_75253,inst_75390);
var _ = (function (){var statearr_75442 = state_75396;
(statearr_75442[(4)] = cljs.core.rest((state_75396[(4)])));

return statearr_75442;
})();
var state_75396__$1 = state_75396;
var statearr_75443_75533 = state_75396__$1;
(statearr_75443_75533[(2)] = inst_75391);

(statearr_75443_75533[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (3))){
var inst_75394 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75396__$1,inst_75394);
} else {
if((state_val_75397 === (12))){
var inst_75261 = (state_75396[(2)]);
var inst_75262 = cljs.core.not(inst_75261);
var state_75396__$1 = state_75396;
if(inst_75262){
var statearr_75444_75534 = state_75396__$1;
(statearr_75444_75534[(1)] = (13));

} else {
var statearr_75445_75535 = state_75396__$1;
(statearr_75445_75535[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (2))){
var inst_75240 = (state_75396[(7)]);
var inst_75241 = (state_75396[(10)]);
var inst_75243 = (state_75396[(20)]);
var _ = (function (){var statearr_75446 = state_75396;
(statearr_75446[(4)] = cljs.core.cons((5),(state_75396[(4)])));

return statearr_75446;
})();
var inst_75240__$1 = cljs.core.first(form);
var inst_75241__$1 = cljs.core.rest(form);
var inst_75242 = cljs.core.count(inst_75241__$1);
var inst_75243__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_75240__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_75240__$1));
var state_75396__$1 = (function (){var statearr_75447 = state_75396;
(statearr_75447[(7)] = inst_75240__$1);

(statearr_75447[(10)] = inst_75241__$1);

(statearr_75447[(18)] = inst_75242);

(statearr_75447[(20)] = inst_75243__$1);

return statearr_75447;
})();
if(cljs.core.truth_(inst_75243__$1)){
var statearr_75448_75536 = state_75396__$1;
(statearr_75448_75536[(1)] = (6));

} else {
var statearr_75449_75537 = state_75396__$1;
(statearr_75449_75537[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (23))){
var inst_75386 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75450_75538 = state_75396__$1;
(statearr_75450_75538[(2)] = inst_75386);

(statearr_75450_75538[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (47))){
var inst_75289 = (state_75396[(8)]);
var inst_75342 = (state_75396[(23)]);
var inst_75342__$1 = inst_75289 === false;
var state_75396__$1 = (function (){var statearr_75451 = state_75396;
(statearr_75451[(23)] = inst_75342__$1);

return statearr_75451;
})();
if(cljs.core.truth_(inst_75342__$1)){
var statearr_75452_75539 = state_75396__$1;
(statearr_75452_75539[(1)] = (49));

} else {
var statearr_75453_75540 = state_75396__$1;
(statearr_75453_75540[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (35))){
var inst_75339 = (state_75396[(9)]);
var inst_75289 = (state_75396[(8)]);
var inst_75339__$1 = inst_75289 === true;
var state_75396__$1 = (function (){var statearr_75454 = state_75396;
(statearr_75454[(9)] = inst_75339__$1);

return statearr_75454;
})();
if(cljs.core.truth_(inst_75339__$1)){
var statearr_75455_75541 = state_75396__$1;
(statearr_75455_75541[(1)] = (46));

} else {
var statearr_75456_75542 = state_75396__$1;
(statearr_75456_75542[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (19))){
var inst_75289 = (state_75396[(8)]);
var inst_75293 = inst_75289 === false;
var state_75396__$1 = state_75396;
var statearr_75457_75543 = state_75396__$1;
(statearr_75457_75543[(2)] = inst_75293);

(statearr_75457_75543[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (57))){
var inst_75371 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75458_75544 = state_75396__$1;
(statearr_75458_75544[(2)] = inst_75371);

(statearr_75458_75544[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (11))){
var inst_75254 = (state_75396[(17)]);
var inst_75242 = (state_75396[(18)]);
var inst_75259 = (inst_75254.cljs$core$IFn$_invoke$arity$1 ? inst_75254.cljs$core$IFn$_invoke$arity$1(inst_75242) : inst_75254.call(null,inst_75242));
var state_75396__$1 = state_75396;
var statearr_75460_75545 = state_75396__$1;
(statearr_75460_75545[(2)] = inst_75259);

(statearr_75460_75545[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (9))){
var inst_75248 = (state_75396[(2)]);
var inst_75249 = fluree.db.util.async.throw_err(inst_75248);
var state_75396__$1 = state_75396;
var statearr_75461_75546 = state_75396__$1;
(statearr_75461_75546[(2)] = inst_75249);

(statearr_75461_75546[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (5))){
var _ = (function (){var statearr_75462 = state_75396;
(statearr_75462[(4)] = cljs.core.rest((state_75396[(4)])));

return statearr_75462;
})();
var state_75396__$1 = state_75396;
var ex75459 = (state_75396__$1[(2)]);
var statearr_75463_75547 = state_75396__$1;
(statearr_75463_75547[(5)] = ex75459);


if((ex75459 instanceof Error)){
var statearr_75464_75548 = state_75396__$1;
(statearr_75464_75548[(1)] = (4));

(statearr_75464_75548[(5)] = null);

} else {
throw ex75459;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (14))){
var state_75396__$1 = state_75396;
var statearr_75465_75549 = state_75396__$1;
(statearr_75465_75549[(2)] = null);

(statearr_75465_75549[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (45))){
var inst_75333 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75466_75550 = state_75396__$1;
(statearr_75466_75550[(2)] = inst_75333);

(statearr_75466_75550[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (53))){
var inst_75289 = (state_75396[(8)]);
var inst_75352 = cljs.core.vector_QMARK_(inst_75289);
var state_75396__$1 = state_75396;
if(inst_75352){
var statearr_75467_75551 = state_75396__$1;
(statearr_75467_75551[(1)] = (55));

} else {
var statearr_75468_75552 = state_75396__$1;
(statearr_75468_75552[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (26))){
var inst_75290 = (state_75396[(24)]);
var inst_75283 = (state_75396[(14)]);
var inst_75381 = (state_75396[(2)]);
var inst_75382 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_75283,inst_75381);
var inst_75282 = inst_75290;
var inst_75283__$1 = inst_75382;
var state_75396__$1 = (function (){var statearr_75469 = state_75396;
(statearr_75469[(12)] = inst_75282);

(statearr_75469[(14)] = inst_75283__$1);

return statearr_75469;
})();
var statearr_75470_75553 = state_75396__$1;
(statearr_75470_75553[(2)] = null);

(statearr_75470_75553[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (16))){
var inst_75282 = (state_75396[(12)]);
var inst_75289 = (state_75396[(8)]);
var inst_75288 = cljs.core.seq(inst_75282);
var inst_75289__$1 = cljs.core.first(inst_75288);
var inst_75290 = cljs.core.next(inst_75288);
var state_75396__$1 = (function (){var statearr_75471 = state_75396;
(statearr_75471[(8)] = inst_75289__$1);

(statearr_75471[(24)] = inst_75290);

return statearr_75471;
})();
if(cljs.core.truth_(inst_75289__$1)){
var statearr_75472_75554 = state_75396__$1;
(statearr_75472_75554[(1)] = (18));

} else {
var statearr_75473_75555 = state_75396__$1;
(statearr_75473_75555[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (38))){
var inst_75240 = (state_75396[(7)]);
var inst_75254 = (state_75396[(17)]);
var inst_75253 = (state_75396[(22)]);
var inst_75251 = (state_75396[(25)]);
var inst_75279 = (state_75396[(11)]);
var inst_75282 = (state_75396[(12)]);
var inst_75289 = (state_75396[(8)]);
var inst_75290 = (state_75396[(24)]);
var inst_75241 = (state_75396[(10)]);
var inst_75256 = (state_75396[(26)]);
var inst_75242 = (state_75396[(18)]);
var inst_75319 = (state_75396[(16)]);
var inst_75252 = (state_75396[(27)]);
var inst_75255 = (state_75396[(28)]);
var inst_75270 = (state_75396[(13)]);
var inst_75283 = (state_75396[(14)]);
var inst_75280 = (state_75396[(15)]);
var inst_75312 = (state_75396[(21)]);
var inst_75315 = [inst_75289];
var inst_75316 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_75315);
var inst_75317 = (function (){var arity = inst_75254;
var args_n = inst_75242;
var fn_map = inst_75251;
var vec__75275 = inst_75241;
var args = inst_75241;
var r = inst_75290;
var first__75277 = inst_75279;
var vec__75285 = inst_75282;
var _ = inst_75270;
var acc = inst_75283;
var seq__75286 = inst_75290;
var arglist = inst_75255;
var G__75274 = inst_75282;
var fn_name = inst_75240;
var map__75239 = inst_75252;
var first__75287 = inst_75289;
var _AMPERSAND_args_QMARK_ = inst_75256;
var or__4223__auto__ = inst_75312;
var seq__75276 = inst_75280;
var arg = inst_75289;
var f = inst_75253;
return (function (p1__75230_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__75230_SHARP_);
});
})();
var inst_75318 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_75317,params);
var inst_75319__$1 = cljs.core.some(inst_75316,inst_75318);
var state_75396__$1 = (function (){var statearr_75474 = state_75396;
(statearr_75474[(16)] = inst_75319__$1);

return statearr_75474;
})();
if(cljs.core.truth_(inst_75319__$1)){
var statearr_75475_75556 = state_75396__$1;
(statearr_75475_75556[(1)] = (40));

} else {
var statearr_75476_75557 = state_75396__$1;
(statearr_75476_75557[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (30))){
var inst_75379 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75477_75558 = state_75396__$1;
(statearr_75477_75558[(2)] = inst_75379);

(statearr_75477_75558[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (10))){
var inst_75256 = (state_75396[(26)]);
var state_75396__$1 = state_75396;
var statearr_75478_75559 = state_75396__$1;
(statearr_75478_75559[(2)] = inst_75256);

(statearr_75478_75559[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (18))){
var inst_75289 = (state_75396[(8)]);
var state_75396__$1 = state_75396;
var statearr_75479_75560 = state_75396__$1;
(statearr_75479_75560[(2)] = inst_75289);

(statearr_75479_75560[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (52))){
var inst_75289 = (state_75396[(8)]);
var state_75396__$1 = state_75396;
var statearr_75480_75561 = state_75396__$1;
(statearr_75480_75561[(2)] = inst_75289);

(statearr_75480_75561[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (42))){
var inst_75335 = (state_75396[(2)]);
var state_75396__$1 = state_75396;
var statearr_75481_75562 = state_75396__$1;
(statearr_75481_75562[(2)] = inst_75335);

(statearr_75481_75562[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (37))){
var inst_75312 = (state_75396[(21)]);
var state_75396__$1 = state_75396;
var statearr_75482_75563 = state_75396__$1;
(statearr_75482_75563[(2)] = inst_75312);

(statearr_75482_75563[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (8))){
var inst_75251 = (state_75396[(25)]);
var inst_75256 = (state_75396[(26)]);
var inst_75252 = (state_75396[(27)]);
var inst_75251__$1 = (state_75396[(2)]);
var inst_75252__$1 = cljs.core.__destructure_map(inst_75251__$1);
var inst_75253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252__$1,cljs.core.cst$kw$f);
var inst_75254 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252__$1,cljs.core.cst$kw$arity);
var inst_75255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252__$1,cljs.core.cst$kw$arglist);
var inst_75256__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_75252__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_75396__$1 = (function (){var statearr_75483 = state_75396;
(statearr_75483[(17)] = inst_75254);

(statearr_75483[(22)] = inst_75253);

(statearr_75483[(25)] = inst_75251__$1);

(statearr_75483[(26)] = inst_75256__$1);

(statearr_75483[(27)] = inst_75252__$1);

(statearr_75483[(28)] = inst_75255);

return statearr_75483;
})();
if(cljs.core.truth_(inst_75256__$1)){
var statearr_75484_75564 = state_75396__$1;
(statearr_75484_75564[(1)] = (10));

} else {
var statearr_75485_75565 = state_75396__$1;
(statearr_75485_75565[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75397 === (49))){
var inst_75342 = (state_75396[(23)]);
var state_75396__$1 = state_75396;
var statearr_75486_75566 = state_75396__$1;
(statearr_75486_75566[(2)] = inst_75342);

(statearr_75486_75566[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__14778__auto____0 = (function (){
var statearr_75487 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75487[(0)] = fluree$db$dbfunctions$core$state_machine__14778__auto__);

(statearr_75487[(1)] = (1));

return statearr_75487;
});
var fluree$db$dbfunctions$core$state_machine__14778__auto____1 = (function (state_75396){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_75396);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e75488){var ex__14781__auto__ = e75488;
var statearr_75489_75567 = state_75396;
(statearr_75489_75567[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_75396[(4)]))){
var statearr_75490_75568 = state_75396;
(statearr_75490_75568[(1)] = cljs.core.first((state_75396[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__75569 = state_75396;
state_75396 = G__75569;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__14778__auto__ = function(state_75396){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__14778__auto____1.call(this,state_75396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__14778__auto____0;
fluree$db$dbfunctions$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__14778__auto____1;
return fluree$db$dbfunctions$core$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_75491 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_75491[(6)] = c__14852__auto__);

return statearr_75491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__75571 = arguments.length;
switch (G__75571) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_75653){
var state_val_75654 = (state_75653[(1)]);
if((state_val_75654 === (7))){
var inst_75581 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_75653__$1 = state_75653;
var statearr_75655_75703 = state_75653__$1;
(statearr_75655_75703[(2)] = inst_75581);

(statearr_75655_75703[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (20))){
var inst_75631 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_75653__$1 = state_75653;
var statearr_75656_75704 = state_75653__$1;
(statearr_75656_75704[(2)] = inst_75631);

(statearr_75656_75704[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (1))){
var state_75653__$1 = state_75653;
var statearr_75657_75705 = state_75653__$1;
(statearr_75657_75705[(2)] = null);

(statearr_75657_75705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (24))){
var inst_75628 = (state_75653[(7)]);
var inst_75637 = cljs.core.eval(inst_75628);
var state_75653__$1 = state_75653;
var statearr_75659_75706 = state_75653__$1;
(statearr_75659_75706[(2)] = inst_75637);

(statearr_75659_75706[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (4))){
var inst_75572 = (state_75653[(2)]);
var state_75653__$1 = state_75653;
var statearr_75660_75707 = state_75653__$1;
(statearr_75660_75707[(2)] = inst_75572);

(statearr_75660_75707[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (15))){
var _ = (function (){var statearr_75661 = state_75653;
(statearr_75661[(4)] = cljs.core.rest((state_75653[(4)])));

return statearr_75661;
})();
var state_75653__$1 = state_75653;
var ex75658 = (state_75653__$1[(2)]);
var statearr_75662_75708 = state_75653__$1;
(statearr_75662_75708[(5)] = ex75658);


var statearr_75663_75709 = state_75653__$1;
(statearr_75663_75709[(1)] = (14));

(statearr_75663_75709[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (21))){
var inst_75629 = (state_75653[(8)]);
var state_75653__$1 = state_75653;
var statearr_75664_75710 = state_75653__$1;
(statearr_75664_75710[(2)] = inst_75629);

(statearr_75664_75710[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (13))){
var inst_75646 = (state_75653[(2)]);
var state_75653__$1 = state_75653;
var statearr_75665_75711 = state_75653__$1;
(statearr_75665_75711[(2)] = inst_75646);

(statearr_75665_75711[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (22))){
var inst_75634 = (state_75653[(2)]);
var state_75653__$1 = state_75653;
if(cljs.core.truth_(inst_75634)){
var statearr_75666_75712 = state_75653__$1;
(statearr_75666_75712[(1)] = (23));

} else {
var statearr_75667_75713 = state_75653__$1;
(statearr_75667_75713[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (6))){
var inst_75578 = (state_75653[(9)]);
var state_75653__$1 = state_75653;
var statearr_75668_75714 = state_75653__$1;
(statearr_75668_75714[(2)] = inst_75578);

(statearr_75668_75714[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (25))){
var inst_75639 = (state_75653[(2)]);
var inst_75640 = [cljs.core.cst$kw$fnstr];
var inst_75641 = [fn_str];
var inst_75642 = cljs.core.PersistentHashMap.fromArrays(inst_75640,inst_75641);
var inst_75643 = cljs.core.with_meta(inst_75639,inst_75642);
var _ = (function (){var statearr_75669 = state_75653;
(statearr_75669[(4)] = cljs.core.rest((state_75653[(4)])));

return statearr_75669;
})();
var state_75653__$1 = state_75653;
var statearr_75670_75715 = state_75653__$1;
(statearr_75670_75715[(2)] = inst_75643);

(statearr_75670_75715[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (17))){
var inst_75604 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75605 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_75606 = cljs.core.PersistentHashMap.fromArrays(inst_75604,inst_75605);
var inst_75607 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_75606);
var inst_75608 = (function(){throw inst_75607})();
var state_75653__$1 = state_75653;
var statearr_75671_75716 = state_75653__$1;
(statearr_75671_75716[(2)] = inst_75608);

(statearr_75671_75716[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (3))){
var inst_75651 = (state_75653[(2)]);
var state_75653__$1 = state_75653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75653__$1,inst_75651);
} else {
if((state_val_75654 === (12))){
var _ = (function (){var statearr_75672 = state_75653;
(statearr_75672[(4)] = cljs.core.cons((15),(state_75653[(4)])));

return statearr_75672;
})();
var inst_75601 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_75653__$1 = state_75653;
if(cljs.core.truth_(inst_75601)){
var statearr_75673_75717 = state_75653__$1;
(statearr_75673_75717[(1)] = (16));

} else {
var statearr_75674_75718 = state_75653__$1;
(statearr_75674_75718[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (2))){
var inst_75578 = (state_75653[(9)]);
var _ = (function (){var statearr_75675 = state_75653;
(statearr_75675[(4)] = cljs.core.cons((5),(state_75653[(4)])));

return statearr_75675;
})();
var inst_75578__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_75653__$1 = (function (){var statearr_75676 = state_75653;
(statearr_75676[(9)] = inst_75578__$1);

return statearr_75676;
})();
if(inst_75578__$1){
var statearr_75677_75719 = state_75653__$1;
(statearr_75677_75719[(1)] = (6));

} else {
var statearr_75678_75720 = state_75653__$1;
(statearr_75678_75720[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (23))){
var inst_75628 = (state_75653[(7)]);
var state_75653__$1 = state_75653;
var statearr_75679_75721 = state_75653__$1;
(statearr_75679_75721[(2)] = inst_75628);

(statearr_75679_75721[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (19))){
var inst_75629 = (state_75653[(8)]);
var inst_75614 = (state_75653[(2)]);
var inst_75615 = fluree.db.util.async.throw_err(inst_75614);
var inst_75616 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_75617 = (new cljs.core.List(null,inst_75616,null,(1),null));
var inst_75618 = cljs.core.cst$sym$_QMARK_ctx;
var inst_75619 = (new cljs.core.List(null,inst_75618,null,(1),null));
var inst_75620 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_75619);
var inst_75621 = cljs.core.seq(inst_75620);
var inst_75622 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_75621);
var inst_75623 = cljs.core.vec(inst_75622);
var inst_75624 = (new cljs.core.List(null,inst_75623,null,(1),null));
var inst_75625 = (new cljs.core.List(null,inst_75615,null,(1),null));
var inst_75626 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_75617,inst_75624,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75625], 0));
var inst_75627 = cljs.core.seq(inst_75626);
var inst_75628 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_75627);
var inst_75629__$1 = params;
var state_75653__$1 = (function (){var statearr_75680 = state_75653;
(statearr_75680[(7)] = inst_75628);

(statearr_75680[(8)] = inst_75629__$1);

return statearr_75680;
})();
if(cljs.core.truth_(inst_75629__$1)){
var statearr_75681_75722 = state_75653__$1;
(statearr_75681_75722[(1)] = (20));

} else {
var statearr_75682_75723 = state_75653__$1;
(statearr_75682_75723[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (11))){
var inst_75648 = (state_75653[(2)]);
var _ = (function (){var statearr_75684 = state_75653;
(statearr_75684[(4)] = cljs.core.rest((state_75653[(4)])));

return statearr_75684;
})();
var state_75653__$1 = state_75653;
var statearr_75685_75724 = state_75653__$1;
(statearr_75685_75724[(2)] = inst_75648);

(statearr_75685_75724[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (9))){
var inst_75585 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_75586 = fluree.db.dbfunctions.core.true_or_false = inst_75585;
var state_75653__$1 = state_75653;
var statearr_75686_75725 = state_75653__$1;
(statearr_75686_75725[(2)] = inst_75586);

(statearr_75686_75725[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (5))){
var _ = (function (){var statearr_75687 = state_75653;
(statearr_75687[(4)] = cljs.core.rest((state_75653[(4)])));

return statearr_75687;
})();
var state_75653__$1 = state_75653;
var ex75683 = (state_75653__$1[(2)]);
var statearr_75688_75726 = state_75653__$1;
(statearr_75688_75726[(5)] = ex75683);


if((ex75683 instanceof Error)){
var statearr_75689_75727 = state_75653__$1;
(statearr_75689_75727[(1)] = (4));

(statearr_75689_75727[(5)] = null);

} else {
throw ex75683;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (14))){
var inst_75588 = (state_75653[(2)]);
var inst_75589 = (function(){throw inst_75588})();
var inst_75590 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_75591 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_75592 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_75593 = cljs.core.PersistentHashMap.fromArrays(inst_75591,inst_75592);
var inst_75594 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_75590,inst_75593);
var inst_75595 = (function(){throw inst_75594})();
var state_75653__$1 = (function (){var statearr_75690 = state_75653;
(statearr_75690[(10)] = inst_75589);

return statearr_75690;
})();
var statearr_75691_75728 = state_75653__$1;
(statearr_75691_75728[(2)] = inst_75595);

(statearr_75691_75728[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (16))){
var state_75653__$1 = state_75653;
var statearr_75692_75729 = state_75653__$1;
(statearr_75692_75729[(2)] = null);

(statearr_75692_75729[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (10))){
var state_75653__$1 = state_75653;
var statearr_75693_75730 = state_75653__$1;
(statearr_75693_75730[(2)] = null);

(statearr_75693_75730[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75654 === (18))){
var inst_75610 = (state_75653[(2)]);
var inst_75611 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_75612 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_75611,type,params);
var state_75653__$1 = (function (){var statearr_75694 = state_75653;
(statearr_75694[(11)] = inst_75610);

return statearr_75694;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75653__$1,(19),inst_75612);
} else {
if((state_val_75654 === (8))){
var inst_75583 = (state_75653[(2)]);
var state_75653__$1 = state_75653;
if(cljs.core.truth_(inst_75583)){
var statearr_75695_75731 = state_75653__$1;
(statearr_75695_75731[(1)] = (9));

} else {
var statearr_75696_75732 = state_75653__$1;
(statearr_75696_75732[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__14778__auto____0 = (function (){
var statearr_75697 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75697[(0)] = fluree$db$dbfunctions$core$state_machine__14778__auto__);

(statearr_75697[(1)] = (1));

return statearr_75697;
});
var fluree$db$dbfunctions$core$state_machine__14778__auto____1 = (function (state_75653){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_75653);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e75698){var ex__14781__auto__ = e75698;
var statearr_75699_75733 = state_75653;
(statearr_75699_75733[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_75653[(4)]))){
var statearr_75700_75734 = state_75653;
(statearr_75700_75734[(1)] = cljs.core.first((state_75653[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__75735 = state_75653;
state_75653 = G__75735;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__14778__auto__ = function(state_75653){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__14778__auto____1.call(this,state_75653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__14778__auto____0;
fluree$db$dbfunctions$core$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__14778__auto____1;
return fluree$db$dbfunctions$core$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_75701 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_75701[(6)] = c__14852__auto__);

return statearr_75701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_75763){
var state_val_75764 = (state_75763[(1)]);
if((state_val_75764 === (7))){
var inst_75750 = (state_75763[(7)]);
var state_75763__$1 = state_75763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75763__$1,(10),inst_75750);
} else {
if((state_val_75764 === (1))){
var state_75763__$1 = state_75763;
var statearr_75765_75785 = state_75763__$1;
(statearr_75765_75785[(2)] = null);

(statearr_75765_75785[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75764 === (4))){
var inst_75736 = (state_75763[(2)]);
var state_75763__$1 = state_75763;
var statearr_75766_75786 = state_75763__$1;
(statearr_75766_75786[(2)] = inst_75736);

(statearr_75766_75786[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75764 === (6))){
var inst_75750 = (state_75763[(7)]);
var inst_75745 = (state_75763[(8)]);
var inst_75748 = (state_75763[(2)]);
var inst_75749 = fluree.db.util.async.throw_err(inst_75748);
var inst_75750__$1 = (inst_75749.cljs$core$IFn$_invoke$arity$1 ? inst_75749.cljs$core$IFn$_invoke$arity$1(inst_75745) : inst_75749.call(null,inst_75745));
var inst_75751 = fluree.db.util.async.channel_QMARK_(inst_75750__$1);
var state_75763__$1 = (function (){var statearr_75767 = state_75763;
(statearr_75767[(7)] = inst_75750__$1);

return statearr_75767;
})();
if(inst_75751){
var statearr_75768_75787 = state_75763__$1;
(statearr_75768_75787[(1)] = (7));

} else {
var statearr_75769_75788 = state_75763__$1;
(statearr_75769_75788[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75764 === (3))){
var inst_75761 = (state_75763[(2)]);
var state_75763__$1 = state_75763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75763__$1,inst_75761);
} else {
if((state_val_75764 === (2))){
var _ = (function (){var statearr_75771 = state_75763;
(statearr_75771[(4)] = cljs.core.cons((5),(state_75763[(4)])));

return statearr_75771;
})();
var inst_75742 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_75743 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_75744 = [db,block_instant,s,p,auth_id,fuel];
var inst_75745 = cljs.core.PersistentHashMap.fromArrays(inst_75743,inst_75744);
var inst_75746 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_75742,"txn",null);
var state_75763__$1 = (function (){var statearr_75772 = state_75763;
(statearr_75772[(8)] = inst_75745);

return statearr_75772;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75763__$1,(6),inst_75746);
} else {
if((state_val_75764 === (9))){
var inst_75758 = (state_75763[(2)]);
var _ = (function (){var statearr_75773 = state_75763;
(statearr_75773[(4)] = cljs.core.rest((state_75763[(4)])));

return statearr_75773;
})();
var state_75763__$1 = state_75763;
var statearr_75774_75789 = state_75763__$1;
(statearr_75774_75789[(2)] = inst_75758);

(statearr_75774_75789[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75764 === (5))){
var _ = (function (){var statearr_75775 = state_75763;
(statearr_75775[(4)] = cljs.core.rest((state_75763[(4)])));

return statearr_75775;
})();
var state_75763__$1 = state_75763;
var ex75770 = (state_75763__$1[(2)]);
var statearr_75776_75790 = state_75763__$1;
(statearr_75776_75790[(5)] = ex75770);


if((ex75770 instanceof Error)){
var statearr_75777_75791 = state_75763__$1;
(statearr_75777_75791[(1)] = (4));

(statearr_75777_75791[(5)] = null);

} else {
throw ex75770;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75764 === (10))){
var inst_75754 = (state_75763[(2)]);
var inst_75755 = fluree.db.util.async.throw_err(inst_75754);
var state_75763__$1 = state_75763;
var statearr_75778_75792 = state_75763__$1;
(statearr_75778_75792[(2)] = inst_75755);

(statearr_75778_75792[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75764 === (8))){
var inst_75750 = (state_75763[(7)]);
var state_75763__$1 = state_75763;
var statearr_75779_75793 = state_75763__$1;
(statearr_75779_75793[(2)] = inst_75750);

(statearr_75779_75793[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto____0 = (function (){
var statearr_75780 = [null,null,null,null,null,null,null,null,null];
(statearr_75780[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto__);

(statearr_75780[(1)] = (1));

return statearr_75780;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto____1 = (function (state_75763){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_75763);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e75781){var ex__14781__auto__ = e75781;
var statearr_75782_75794 = state_75763;
(statearr_75782_75794[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_75763[(4)]))){
var statearr_75783_75795 = state_75763;
(statearr_75783_75795[(1)] = cljs.core.first((state_75763[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__75796 = state_75763;
state_75763 = G__75796;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto__ = function(state_75763){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto____1.call(this,state_75763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_75784 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_75784[(6)] = c__14852__auto__);

return statearr_75784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
