// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__40179 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40179,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40179,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40179,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__40182){
var map__40183 = p__40182;
var map__40183__$1 = cljs.core.__destructure_map(map__40183);
var opts = map__40183__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40183__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_40243){
var state_val_40244 = (state_40243[(1)]);
if((state_val_40244 === (7))){
var inst_40214 = cljs.core.not(reindex_QMARK_);
var state_40243__$1 = state_40243;
var statearr_40245_40269 = state_40243__$1;
(statearr_40245_40269[(2)] = inst_40214);

(statearr_40245_40269[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (1))){
var state_40243__$1 = state_40243;
var statearr_40246_40270 = state_40243__$1;
(statearr_40246_40270[(2)] = null);

(statearr_40246_40270[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (4))){
var inst_40184 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
var statearr_40247_40271 = state_40243__$1;
(statearr_40247_40271[(2)] = inst_40184);

(statearr_40247_40271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (6))){
var inst_40204 = (state_40243[(7)]);
var inst_40198 = (state_40243[(8)]);
var inst_40212 = (state_40243[(9)]);
var inst_40197 = (state_40243[(2)]);
var inst_40198__$1 = fluree.db.util.async.throw_err(inst_40197);
var inst_40199 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_40200 = cljs.core.__destructure_map(inst_40199);
var inst_40201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40200,cljs.core.cst$kw$post);
var inst_40202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40200,cljs.core.cst$kw$size);
var inst_40203 = fluree.db.flake.size_bytes(inst_40198__$1);
var inst_40204__$1 = (inst_40202 + inst_40203);
var inst_40205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40206 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_40207 = (new cljs.core.PersistentVector(null,2,(5),inst_40205,inst_40206,null));
var inst_40208 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_40207);
var inst_40209 = cljs.core.__destructure_map(inst_40208);
var inst_40210 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40209,cljs.core.cst$kw$novelty_DASH_min);
var inst_40211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40209,cljs.core.cst$kw$novelty_DASH_max);
var inst_40212__$1 = (inst_40204__$1 > inst_40211);
var state_40243__$1 = (function (){var statearr_40248 = state_40243;
(statearr_40248[(7)] = inst_40204__$1);

(statearr_40248[(10)] = inst_40201);

(statearr_40248[(8)] = inst_40198__$1);

(statearr_40248[(11)] = inst_40210);

(statearr_40248[(9)] = inst_40212__$1);

return statearr_40248;
})();
if(cljs.core.truth_(inst_40212__$1)){
var statearr_40249_40272 = state_40243__$1;
(statearr_40249_40272[(1)] = (7));

} else {
var statearr_40250_40273 = state_40243__$1;
(statearr_40250_40273[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (3))){
var inst_40241 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40243__$1,inst_40241);
} else {
if((state_val_40244 === (12))){
var inst_40204 = (state_40243[(7)]);
var inst_40201 = (state_40243[(10)]);
var inst_40198 = (state_40243[(8)]);
var inst_40227 = (state_40243[(2)]);
var inst_40228 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40201,inst_40198);
var inst_40229 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_40230 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_40229,cljs.core.empty);
var inst_40231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40232 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_40233 = (new cljs.core.PersistentVector(null,2,(5),inst_40231,inst_40232,null));
var inst_40234 = cljs.core.assoc_in(db,inst_40233,inst_40228);
var inst_40235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40236 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_40237 = (new cljs.core.PersistentVector(null,2,(5),inst_40235,inst_40236,null));
var inst_40238 = cljs.core.assoc_in(inst_40234,inst_40237,inst_40204);
var _ = (function (){var statearr_40251 = state_40243;
(statearr_40251[(4)] = cljs.core.rest((state_40243[(4)])));

return statearr_40251;
})();
var state_40243__$1 = (function (){var statearr_40252 = state_40243;
(statearr_40252[(12)] = inst_40230);

(statearr_40252[(13)] = inst_40227);

return statearr_40252;
})();
var statearr_40253_40274 = state_40243__$1;
(statearr_40253_40274[(2)] = inst_40238);

(statearr_40253_40274[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (2))){
var _ = (function (){var statearr_40254 = state_40243;
(statearr_40254[(4)] = cljs.core.cons((5),(state_40243[(4)])));

return statearr_40254;
})();
var inst_40192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40193 = [pred_id];
var inst_40194 = (new cljs.core.PersistentVector(null,1,(5),inst_40192,inst_40193,null));
var inst_40195 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_40194);
var state_40243__$1 = state_40243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40243__$1,(6),inst_40195);
} else {
if((state_val_40244 === (11))){
var state_40243__$1 = state_40243;
var statearr_40256_40275 = state_40243__$1;
(statearr_40256_40275[(2)] = null);

(statearr_40256_40275[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (9))){
var inst_40217 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
if(cljs.core.truth_(inst_40217)){
var statearr_40257_40276 = state_40243__$1;
(statearr_40257_40276[(1)] = (10));

} else {
var statearr_40258_40277 = state_40243__$1;
(statearr_40258_40277[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (5))){
var _ = (function (){var statearr_40259 = state_40243;
(statearr_40259[(4)] = cljs.core.rest((state_40243[(4)])));

return statearr_40259;
})();
var state_40243__$1 = state_40243;
var ex40255 = (state_40243__$1[(2)]);
var statearr_40260_40278 = state_40243__$1;
(statearr_40260_40278[(5)] = ex40255);


if((ex40255 instanceof Error)){
var statearr_40261_40279 = state_40243__$1;
(statearr_40261_40279[(1)] = (4));

(statearr_40261_40279[(5)] = null);

} else {
throw ex40255;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (10))){
var inst_40219 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_40220 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_40221 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_40222 = cljs.core.PersistentHashMap.fromArrays(inst_40220,inst_40221);
var inst_40223 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40219,inst_40222);
var inst_40224 = (function(){throw inst_40223})();
var state_40243__$1 = state_40243;
var statearr_40262_40280 = state_40243__$1;
(statearr_40262_40280[(2)] = inst_40224);

(statearr_40262_40280[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (8))){
var inst_40212 = (state_40243[(9)]);
var state_40243__$1 = state_40243;
var statearr_40263_40281 = state_40243__$1;
(statearr_40263_40281[(2)] = inst_40212);

(statearr_40263_40281[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto____0 = (function (){
var statearr_40264 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40264[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto__);

(statearr_40264[(1)] = (1));

return statearr_40264;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto____1 = (function (state_40243){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_40243);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e40265){var ex__14781__auto__ = e40265;
var statearr_40266_40282 = state_40243;
(statearr_40266_40282[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_40243[(4)]))){
var statearr_40267_40283 = state_40243;
(statearr_40267_40283[(1)] = cljs.core.first((state_40243[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__40284 = state_40243;
state_40243 = G__40284;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto__ = function(state_40243){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto____1.call(this,state_40243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_40268 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_40268[(6)] = c__14852__auto__);

return statearr_40268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__40289 = arguments.length;
switch (G__40289) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_40485){
var state_val_40486 = (state_40485[(1)]);
if((state_val_40486 === (7))){
var state_40485__$1 = state_40485;
var statearr_40487_40555 = state_40485__$1;
(statearr_40487_40555[(2)] = null);

(statearr_40487_40555[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (20))){
var inst_40409 = (state_40485[(7)]);
var inst_40328 = (state_40485[(8)]);
var inst_40411 = (state_40485[(9)]);
var inst_40378 = (state_40485[(10)]);
var inst_40407 = (state_40485[(11)]);
var inst_40410 = (state_40485[(12)]);
var inst_40408 = (state_40485[(13)]);
var inst_40327 = (state_40485[(14)]);
var inst_40421 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_40422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40423 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_40424 = (new cljs.core.PersistentVector(null,2,(5),inst_40422,inst_40423,null));
var inst_40425 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_40378,inst_40424);
var inst_40426 = (inst_40327 + inst_40425);
var inst_40427 = [inst_40407,inst_40408,inst_40409,inst_40410,inst_40426];
var inst_40428 = cljs.core.PersistentHashMap.fromArrays(inst_40421,inst_40427);
var inst_40429 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_40378,cljs.core.cst$kw$ecount,inst_40411,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_40428], 0));
var state_40485__$1 = (function (){var statearr_40488 = state_40485;
(statearr_40488[(15)] = inst_40429);

return statearr_40488;
})();
if(cljs.core.truth_(inst_40328)){
var statearr_40489_40556 = state_40485__$1;
(statearr_40489_40556[(1)] = (23));

} else {
var statearr_40490_40557 = state_40485__$1;
(statearr_40490_40557[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (27))){
var inst_40429 = (state_40485[(15)]);
var state_40485__$1 = state_40485;
var statearr_40491_40558 = state_40485__$1;
(statearr_40491_40558[(2)] = inst_40429);

(statearr_40491_40558[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (1))){
var state_40485__$1 = state_40485;
var statearr_40492_40559 = state_40485__$1;
(statearr_40492_40559[(2)] = null);

(statearr_40492_40559[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (24))){
var inst_40429 = (state_40485[(15)]);
var inst_40432 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_40429);
var inst_40433 = (inst_40432 == null);
var state_40485__$1 = state_40485;
var statearr_40493_40560 = state_40485__$1;
(statearr_40493_40560[(2)] = inst_40433);

(statearr_40493_40560[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (39))){
var inst_40461 = (state_40485[(16)]);
var inst_40459 = (state_40485[(17)]);
var inst_40418 = (state_40485[(18)]);
var inst_40460 = (state_40485[(19)]);
var inst_40468 = (state_40485[(20)]);
var inst_40475 = (state_40485[(2)]);
var inst_40406 = inst_40418;
var inst_40407 = inst_40460;
var inst_40408 = inst_40461;
var inst_40409 = inst_40468;
var inst_40410 = inst_40475;
var inst_40411 = inst_40459;
var state_40485__$1 = (function (){var statearr_40494 = state_40485;
(statearr_40494[(7)] = inst_40409);

(statearr_40494[(9)] = inst_40411);

(statearr_40494[(21)] = inst_40406);

(statearr_40494[(11)] = inst_40407);

(statearr_40494[(12)] = inst_40410);

(statearr_40494[(13)] = inst_40408);

return statearr_40494;
})();
var statearr_40495_40561 = state_40485__$1;
(statearr_40495_40561[(2)] = null);

(statearr_40495_40561[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (4))){
var inst_40290 = (state_40485[(2)]);
var state_40485__$1 = state_40485;
var statearr_40496_40562 = state_40485__$1;
(statearr_40496_40562[(2)] = inst_40290);

(statearr_40496_40562[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (15))){
var inst_40350 = (state_40485[(22)]);
var state_40485__$1 = state_40485;
var statearr_40497_40563 = state_40485__$1;
(statearr_40497_40563[(2)] = inst_40350);

(statearr_40497_40563[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (21))){
var inst_40331 = (state_40485[(23)]);
var inst_40387 = (state_40485[(24)]);
var inst_40312 = (state_40485[(25)]);
var inst_40417 = (state_40485[(26)]);
var inst_40409 = (state_40485[(7)]);
var inst_40337 = (state_40485[(27)]);
var inst_40297 = (state_40485[(28)]);
var inst_40328 = (state_40485[(8)]);
var inst_40411 = (state_40485[(9)]);
var inst_40318 = (state_40485[(29)]);
var inst_40406 = (state_40485[(21)]);
var inst_40378 = (state_40485[(10)]);
var inst_40418 = (state_40485[(18)]);
var inst_40407 = (state_40485[(11)]);
var inst_40329 = (state_40485[(30)]);
var inst_40326 = (state_40485[(31)]);
var inst_40388 = (state_40485[(32)]);
var inst_40314 = (state_40485[(33)]);
var inst_40410 = (state_40485[(12)]);
var inst_40322 = (state_40485[(34)]);
var inst_40408 = (state_40485[(13)]);
var inst_40327 = (state_40485[(14)]);
var inst_40456 = inst_40417.s;
var inst_40457 = fluree.db.flake.sid__GT_cid(inst_40456);
var inst_40458 = (function (){var flakes_bytes = inst_40327;
var t = inst_40297;
var seq__40384 = inst_40388;
var spot = inst_40407;
var add_flakes = inst_40314;
var root_setting_change_QMARK_ = inst_40329;
var vec__40383 = inst_40314;
var ref_QMARK__map = inst_40326;
var G__40382 = inst_40406;
var r = inst_40418;
var first__40385 = inst_40387;
var psot = inst_40408;
var vec__40413 = inst_40406;
var add_pred_to_idx_QMARK_ = inst_40337;
var _ = inst_40312;
var cid = inst_40457;
var ecount = inst_40411;
var pred_ecount = inst_40331;
var db_STAR_ = inst_40378;
var schema_change_QMARK_ = inst_40328;
var first__40415 = inst_40417;
var add_preds = inst_40318;
var opst = inst_40410;
var idx_QMARK__map = inst_40322;
var seq__40414 = inst_40418;
var post = inst_40409;
var f = inst_40417;
return (function (p1__40287_SHARP_){
if(cljs.core.truth_(p1__40287_SHARP_)){
var x__4306__auto__ = p1__40287_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_40459 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_40411,inst_40457,inst_40458);
var inst_40460 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40407,inst_40417);
var inst_40461 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40408,inst_40417);
var inst_40462 = inst_40417.p;
var inst_40463 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40322,inst_40462);
var state_40485__$1 = (function (){var statearr_40498 = state_40485;
(statearr_40498[(16)] = inst_40461);

(statearr_40498[(17)] = inst_40459);

(statearr_40498[(19)] = inst_40460);

return statearr_40498;
})();
if(cljs.core.truth_(inst_40463)){
var statearr_40499_40564 = state_40485__$1;
(statearr_40499_40564[(1)] = (34));

} else {
var statearr_40500_40565 = state_40485__$1;
(statearr_40500_40565[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (31))){
var inst_40444 = (state_40485[(35)]);
var state_40485__$1 = state_40485;
var statearr_40501_40566 = state_40485__$1;
(statearr_40501_40566[(2)] = inst_40444);

(statearr_40501_40566[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (32))){
var inst_40454 = (state_40485[(2)]);
var state_40485__$1 = state_40485;
var statearr_40502_40567 = state_40485__$1;
(statearr_40502_40567[(2)] = inst_40454);

(statearr_40502_40567[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (33))){
var inst_40444 = (state_40485[(35)]);
var inst_40449 = (state_40485[(2)]);
var inst_40450 = fluree.db.util.async.throw_err(inst_40449);
var inst_40451 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40444,cljs.core.cst$kw$settings,inst_40450);
var state_40485__$1 = state_40485;
var statearr_40503_40568 = state_40485__$1;
(statearr_40503_40568[(2)] = inst_40451);

(statearr_40503_40568[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (13))){
var inst_40297 = (state_40485[(28)]);
var inst_40378 = (state_40485[(10)]);
var inst_40314 = (state_40485[(33)]);
var inst_40327 = (state_40485[(14)]);
var inst_40368 = (state_40485[(2)]);
var inst_40369 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40368,cljs.core.cst$kw$t,inst_40297);
var inst_40370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40371 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_40372 = (new cljs.core.PersistentVector(null,2,(5),inst_40370,inst_40371,null));
var inst_40373 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_40369,inst_40372,cljs.core._PLUS_,inst_40327);
var inst_40374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40375 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_40376 = (new cljs.core.PersistentVector(null,2,(5),inst_40374,inst_40375,null));
var inst_40377 = cljs.core.count(inst_40314);
var inst_40378__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_40373,inst_40376,cljs.core._PLUS_,inst_40377);
var inst_40386 = cljs.core.seq(inst_40314);
var inst_40387 = cljs.core.first(inst_40386);
var inst_40388 = cljs.core.next(inst_40386);
var inst_40389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40390 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_40391 = (new cljs.core.PersistentVector(null,2,(5),inst_40389,inst_40390,null));
var inst_40392 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_40378__$1,inst_40391);
var inst_40393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40394 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_40395 = (new cljs.core.PersistentVector(null,2,(5),inst_40393,inst_40394,null));
var inst_40396 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_40378__$1,inst_40395);
var inst_40397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40398 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_40399 = (new cljs.core.PersistentVector(null,2,(5),inst_40397,inst_40398,null));
var inst_40400 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_40378__$1,inst_40399);
var inst_40401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40402 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_40403 = (new cljs.core.PersistentVector(null,2,(5),inst_40401,inst_40402,null));
var inst_40404 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_40378__$1,inst_40403);
var inst_40405 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_40406 = inst_40314;
var inst_40407 = inst_40392;
var inst_40408 = inst_40396;
var inst_40409 = inst_40400;
var inst_40410 = inst_40404;
var inst_40411 = inst_40405;
var state_40485__$1 = (function (){var statearr_40504 = state_40485;
(statearr_40504[(24)] = inst_40387);

(statearr_40504[(7)] = inst_40409);

(statearr_40504[(9)] = inst_40411);

(statearr_40504[(21)] = inst_40406);

(statearr_40504[(10)] = inst_40378__$1);

(statearr_40504[(11)] = inst_40407);

(statearr_40504[(32)] = inst_40388);

(statearr_40504[(12)] = inst_40410);

(statearr_40504[(13)] = inst_40408);

return statearr_40504;
})();
var statearr_40505_40569 = state_40485__$1;
(statearr_40505_40569[(2)] = null);

(statearr_40505_40569[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (22))){
var inst_40478 = (state_40485[(2)]);
var state_40485__$1 = state_40485;
var statearr_40506_40570 = state_40485__$1;
(statearr_40506_40570[(2)] = inst_40478);

(statearr_40506_40570[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (36))){
var inst_40417 = (state_40485[(26)]);
var inst_40326 = (state_40485[(31)]);
var inst_40468 = (state_40485[(2)]);
var inst_40469 = inst_40417.p;
var inst_40470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40326,inst_40469);
var state_40485__$1 = (function (){var statearr_40507 = state_40485;
(statearr_40507[(20)] = inst_40468);

return statearr_40507;
})();
if(cljs.core.truth_(inst_40470)){
var statearr_40508_40571 = state_40485__$1;
(statearr_40508_40571[(1)] = (37));

} else {
var statearr_40509_40572 = state_40485__$1;
(statearr_40509_40572[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (29))){
var inst_40429 = (state_40485[(15)]);
var inst_40439 = (state_40485[(2)]);
var inst_40440 = fluree.db.util.async.throw_err(inst_40439);
var inst_40441 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40429,cljs.core.cst$kw$schema,inst_40440);
var state_40485__$1 = state_40485;
var statearr_40510_40573 = state_40485__$1;
(statearr_40510_40573[(2)] = inst_40441);

(statearr_40510_40573[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (6))){
var inst_40297 = (state_40485[(28)]);
var inst_40302 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_40303 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_40304 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40302)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40303)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40297),"."].join('');
var inst_40305 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40306 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_40307 = cljs.core.PersistentHashMap.fromArrays(inst_40305,inst_40306);
var inst_40308 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40304,inst_40307);
var inst_40309 = (function(){throw inst_40308})();
var state_40485__$1 = state_40485;
var statearr_40511_40574 = state_40485__$1;
(statearr_40511_40574[(2)] = inst_40309);

(statearr_40511_40574[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (28))){
var inst_40329 = (state_40485[(30)]);
var inst_40444 = (state_40485[(2)]);
var state_40485__$1 = (function (){var statearr_40512 = state_40485;
(statearr_40512[(35)] = inst_40444);

return statearr_40512;
})();
if(cljs.core.truth_(inst_40329)){
var statearr_40513_40575 = state_40485__$1;
(statearr_40513_40575[(1)] = (30));

} else {
var statearr_40514_40576 = state_40485__$1;
(statearr_40514_40576[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (25))){
var inst_40435 = (state_40485[(2)]);
var state_40485__$1 = state_40485;
if(cljs.core.truth_(inst_40435)){
var statearr_40515_40577 = state_40485__$1;
(statearr_40515_40577[(1)] = (26));

} else {
var statearr_40516_40578 = state_40485__$1;
(statearr_40516_40578[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (34))){
var inst_40417 = (state_40485[(26)]);
var inst_40409 = (state_40485[(7)]);
var inst_40465 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40409,inst_40417);
var state_40485__$1 = state_40485;
var statearr_40517_40579 = state_40485__$1;
(statearr_40517_40579[(2)] = inst_40465);

(statearr_40517_40579[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (17))){
var inst_40357 = (state_40485[(36)]);
var inst_40361 = (state_40485[(2)]);
var inst_40362 = fluree.db.util.async.throw_err(inst_40361);
var inst_40349 = inst_40357;
var inst_40350 = inst_40362;
var state_40485__$1 = (function (){var statearr_40518 = state_40485;
(statearr_40518[(37)] = inst_40349);

(statearr_40518[(22)] = inst_40350);

return statearr_40518;
})();
var statearr_40519_40580 = state_40485__$1;
(statearr_40519_40580[(2)] = null);

(statearr_40519_40580[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (3))){
var inst_40483 = (state_40485[(2)]);
var state_40485__$1 = state_40485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40485__$1,inst_40483);
} else {
if((state_val_40486 === (12))){
var inst_40356 = (state_40485[(38)]);
var inst_40349 = (state_40485[(37)]);
var inst_40355 = cljs.core.seq(inst_40349);
var inst_40356__$1 = cljs.core.first(inst_40355);
var inst_40357 = cljs.core.next(inst_40355);
var state_40485__$1 = (function (){var statearr_40520 = state_40485;
(statearr_40520[(38)] = inst_40356__$1);

(statearr_40520[(36)] = inst_40357);

return statearr_40520;
})();
if(cljs.core.truth_(inst_40356__$1)){
var statearr_40521_40581 = state_40485__$1;
(statearr_40521_40581[(1)] = (14));

} else {
var statearr_40522_40582 = state_40485__$1;
(statearr_40522_40582[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (2))){
var inst_40297 = (state_40485[(28)]);
var _ = (function (){var statearr_40523 = state_40485;
(statearr_40523[(4)] = cljs.core.cons((5),(state_40485[(4)])));

return statearr_40523;
})();
var inst_40296 = cljs.core.first(flakes);
var inst_40297__$1 = inst_40296.t;
var inst_40298 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_40299 = (inst_40298 - (1));
var inst_40300 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_40297__$1,inst_40299);
var state_40485__$1 = (function (){var statearr_40524 = state_40485;
(statearr_40524[(28)] = inst_40297__$1);

return statearr_40524;
})();
if(inst_40300){
var statearr_40525_40583 = state_40485__$1;
(statearr_40525_40583[(1)] = (6));

} else {
var statearr_40526_40584 = state_40485__$1;
(statearr_40526_40584[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (23))){
var inst_40328 = (state_40485[(8)]);
var state_40485__$1 = state_40485;
var statearr_40527_40585 = state_40485__$1;
(statearr_40527_40585[(2)] = inst_40328);

(statearr_40527_40585[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (35))){
var inst_40409 = (state_40485[(7)]);
var state_40485__$1 = state_40485;
var statearr_40528_40586 = state_40485__$1;
(statearr_40528_40586[(2)] = inst_40409);

(statearr_40528_40586[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (19))){
var inst_40480 = (state_40485[(2)]);
var _ = (function (){var statearr_40529 = state_40485;
(statearr_40529[(4)] = cljs.core.rest((state_40485[(4)])));

return statearr_40529;
})();
var state_40485__$1 = state_40485;
var statearr_40530_40587 = state_40485__$1;
(statearr_40530_40587[(2)] = inst_40480);

(statearr_40530_40587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (11))){
var inst_40337 = (state_40485[(27)]);
var inst_40337__$1 = (state_40485[(2)]);
var inst_40345 = cljs.core.seq(inst_40337__$1);
var inst_40346 = cljs.core.first(inst_40345);
var inst_40347 = cljs.core.next(inst_40345);
var inst_40348 = db;
var inst_40349 = inst_40337__$1;
var inst_40350 = inst_40348;
var state_40485__$1 = (function (){var statearr_40532 = state_40485;
(statearr_40532[(27)] = inst_40337__$1);

(statearr_40532[(39)] = inst_40346);

(statearr_40532[(37)] = inst_40349);

(statearr_40532[(22)] = inst_40350);

(statearr_40532[(40)] = inst_40347);

return statearr_40532;
})();
var statearr_40533_40588 = state_40485__$1;
(statearr_40533_40588[(2)] = null);

(statearr_40533_40588[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (9))){
var inst_40331 = (state_40485[(23)]);
var inst_40314 = (state_40485[(33)]);
var inst_40333 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_40314,inst_40331);
var state_40485__$1 = state_40485;
var statearr_40534_40589 = state_40485__$1;
(statearr_40534_40589[(2)] = inst_40333);

(statearr_40534_40589[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (5))){
var _ = (function (){var statearr_40535 = state_40485;
(statearr_40535[(4)] = cljs.core.rest((state_40485[(4)])));

return statearr_40535;
})();
var state_40485__$1 = state_40485;
var ex40531 = (state_40485__$1[(2)]);
var statearr_40536_40590 = state_40485__$1;
(statearr_40536_40590[(5)] = ex40531);


if((ex40531 instanceof Error)){
var statearr_40537_40591 = state_40485__$1;
(statearr_40537_40591[(1)] = (4));

(statearr_40537_40591[(5)] = null);

} else {
throw ex40531;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (14))){
var inst_40356 = (state_40485[(38)]);
var inst_40350 = (state_40485[(22)]);
var inst_40359 = fluree.db.graphdb.add_predicate_to_idx(inst_40350,inst_40356,opts);
var state_40485__$1 = state_40485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40485__$1,(17),inst_40359);
} else {
if((state_val_40486 === (26))){
var inst_40429 = (state_40485[(15)]);
var inst_40437 = fluree.db.query.schema.schema_map(inst_40429);
var state_40485__$1 = state_40485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40485__$1,(29),inst_40437);
} else {
if((state_val_40486 === (16))){
var inst_40366 = (state_40485[(2)]);
var state_40485__$1 = state_40485;
var statearr_40538_40592 = state_40485__$1;
(statearr_40538_40592[(2)] = inst_40366);

(statearr_40538_40592[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (38))){
var inst_40410 = (state_40485[(12)]);
var state_40485__$1 = state_40485;
var statearr_40539_40593 = state_40485__$1;
(statearr_40539_40593[(2)] = inst_40410);

(statearr_40539_40593[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (30))){
var inst_40444 = (state_40485[(35)]);
var inst_40447 = fluree.db.query.schema.setting_map(inst_40444);
var state_40485__$1 = state_40485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40485__$1,(33),inst_40447);
} else {
if((state_val_40486 === (10))){
var inst_40335 = cljs.core.PersistentVector.EMPTY;
var state_40485__$1 = state_40485;
var statearr_40540_40594 = state_40485__$1;
(statearr_40540_40594[(2)] = inst_40335);

(statearr_40540_40594[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (18))){
var inst_40417 = (state_40485[(26)]);
var inst_40406 = (state_40485[(21)]);
var inst_40416 = cljs.core.seq(inst_40406);
var inst_40417__$1 = cljs.core.first(inst_40416);
var inst_40418 = cljs.core.next(inst_40416);
var inst_40419 = cljs.core.not(inst_40417__$1);
var state_40485__$1 = (function (){var statearr_40541 = state_40485;
(statearr_40541[(26)] = inst_40417__$1);

(statearr_40541[(18)] = inst_40418);

return statearr_40541;
})();
if(inst_40419){
var statearr_40542_40595 = state_40485__$1;
(statearr_40542_40595[(1)] = (20));

} else {
var statearr_40543_40596 = state_40485__$1;
(statearr_40543_40596[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (37))){
var inst_40417 = (state_40485[(26)]);
var inst_40410 = (state_40485[(12)]);
var inst_40472 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40410,inst_40417);
var state_40485__$1 = state_40485;
var statearr_40544_40597 = state_40485__$1;
(statearr_40544_40597[(2)] = inst_40472);

(statearr_40544_40597[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40486 === (8))){
var inst_40312 = (state_40485[(25)]);
var inst_40297 = (state_40485[(28)]);
var inst_40328 = (state_40485[(8)]);
var inst_40318 = (state_40485[(29)]);
var inst_40314 = (state_40485[(33)]);
var inst_40322 = (state_40485[(34)]);
var inst_40312__$1 = (state_40485[(2)]);
var inst_40313 = (function (){var t = inst_40297;
var _ = inst_40312__$1;
return (function (p1__40285_SHARP_){
return cljs.core.not((function (){var G__40545 = p1__40285_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__40545) : fluree.db.graphdb.exclude_predicates.call(null,G__40545));
})());
});
})();
var inst_40314__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_40313,flakes);
var inst_40315 = cljs.core.PersistentHashSet.EMPTY;
var inst_40316 = (function (){var t = inst_40297;
var _ = inst_40312__$1;
var add_flakes = inst_40314__$1;
return (function (p1__40286_SHARP_){
return p1__40286_SHARP_.p;
});
})();
var inst_40317 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40316,inst_40314__$1);
var inst_40318__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40315,inst_40317);
var inst_40319 = cljs.core.PersistentHashMap.EMPTY;
var inst_40320 = (function (){var t = inst_40297;
var _ = inst_40312__$1;
var add_flakes = inst_40314__$1;
var add_preds = inst_40318__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_40321 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40320,inst_40318__$1);
var inst_40322__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40319,inst_40321);
var inst_40323 = cljs.core.PersistentHashMap.EMPTY;
var inst_40324 = (function (){var t = inst_40297;
var _ = inst_40312__$1;
var add_flakes = inst_40314__$1;
var add_preds = inst_40318__$1;
var idx_QMARK__map = inst_40322__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_40325 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40324,inst_40318__$1);
var inst_40326 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40323,inst_40325);
var inst_40327 = fluree.db.flake.size_bytes(inst_40314__$1);
var inst_40328__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_40314__$1);
var inst_40329 = fluree.db.util.schema.setting_change_QMARK_(inst_40314__$1);
var inst_40330 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_40331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40330,(0));
var state_40485__$1 = (function (){var statearr_40546 = state_40485;
(statearr_40546[(23)] = inst_40331);

(statearr_40546[(25)] = inst_40312__$1);

(statearr_40546[(8)] = inst_40328__$1);

(statearr_40546[(29)] = inst_40318__$1);

(statearr_40546[(30)] = inst_40329);

(statearr_40546[(31)] = inst_40326);

(statearr_40546[(33)] = inst_40314__$1);

(statearr_40546[(34)] = inst_40322__$1);

(statearr_40546[(14)] = inst_40327);

return statearr_40546;
})();
if(cljs.core.truth_(inst_40328__$1)){
var statearr_40547_40598 = state_40485__$1;
(statearr_40547_40598[(1)] = (9));

} else {
var statearr_40548_40599 = state_40485__$1;
(statearr_40548_40599[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__14778__auto__ = null;
var fluree$db$graphdb$state_machine__14778__auto____0 = (function (){
var statearr_40549 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40549[(0)] = fluree$db$graphdb$state_machine__14778__auto__);

(statearr_40549[(1)] = (1));

return statearr_40549;
});
var fluree$db$graphdb$state_machine__14778__auto____1 = (function (state_40485){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_40485);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e40550){var ex__14781__auto__ = e40550;
var statearr_40551_40600 = state_40485;
(statearr_40551_40600[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_40485[(4)]))){
var statearr_40552_40601 = state_40485;
(statearr_40552_40601[(1)] = cljs.core.first((state_40485[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__40602 = state_40485;
state_40485 = G__40602;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__14778__auto__ = function(state_40485){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__14778__auto____1.call(this,state_40485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__14778__auto____0;
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__14778__auto____1;
return fluree$db$graphdb$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_40553 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_40553[(6)] = c__14852__auto__);

return statearr_40553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__40604 = arguments.length;
switch (G__40604) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___40751 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_40700){
var state_val_40701 = (state_40700[(1)]);
if((state_val_40701 === (7))){
var state_40700__$1 = state_40700;
var statearr_40702_40752 = state_40700__$1;
(statearr_40702_40752[(2)] = null);

(statearr_40702_40752[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (20))){
var inst_40648 = (state_40700[(7)]);
var inst_40649 = (state_40700[(8)]);
var inst_40650 = (state_40700[(9)]);
var inst_40669 = (inst_40648 + (1));
var inst_40670 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40650,cljs.core.cst$kw$t,inst_40669);
var inst_40671 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_40670,inst_40649,opts);
var state_40700__$1 = state_40700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40700__$1,(23),inst_40671);
} else {
if((state_val_40701 === (1))){
var state_40700__$1 = state_40700;
var statearr_40703_40753 = state_40700__$1;
(statearr_40703_40753[(2)] = null);

(statearr_40703_40753[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (24))){
var inst_40674 = (state_40700[(10)]);
var inst_40677 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40674,cljs.core.cst$kw$block,block);
var state_40700__$1 = state_40700;
var statearr_40704_40754 = state_40700__$1;
(statearr_40704_40754[(2)] = inst_40677);

(statearr_40704_40754[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (4))){
var inst_40605 = (state_40700[(2)]);
var inst_40606 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_40605);
var state_40700__$1 = state_40700;
var statearr_40705_40755 = state_40700__$1;
(statearr_40705_40755[(2)] = inst_40606);

(statearr_40705_40755[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (15))){
var inst_40656 = (state_40700[(11)]);
var state_40700__$1 = state_40700;
var statearr_40706_40756 = state_40700__$1;
(statearr_40706_40756[(2)] = inst_40656);

(statearr_40706_40756[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (21))){
var state_40700__$1 = state_40700;
var statearr_40707_40757 = state_40700__$1;
(statearr_40707_40757[(2)] = null);

(statearr_40707_40757[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (13))){
var inst_40692 = (state_40700[(2)]);
var inst_40693 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_40692);
var state_40700__$1 = state_40700;
var statearr_40708_40758 = state_40700__$1;
(statearr_40708_40758[(2)] = inst_40693);

(statearr_40708_40758[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (22))){
var inst_40688 = (state_40700[(2)]);
var state_40700__$1 = state_40700;
var statearr_40709_40759 = state_40700__$1;
(statearr_40709_40759[(2)] = inst_40688);

(statearr_40709_40759[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (6))){
var inst_40616 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_40617 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_40618 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40616)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40617)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_40619 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40620 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_40621 = cljs.core.PersistentHashMap.fromArrays(inst_40619,inst_40620);
var inst_40622 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40618,inst_40621);
var inst_40623 = (function(){throw inst_40622})();
var state_40700__$1 = state_40700;
var statearr_40712_40760 = state_40700__$1;
(statearr_40712_40760[(2)] = inst_40623);

(statearr_40712_40760[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (25))){
var inst_40656 = (state_40700[(11)]);
var inst_40674 = (state_40700[(10)]);
var inst_40657 = (state_40700[(12)]);
var inst_40679 = inst_40656.t;
var inst_40680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40681 = [inst_40656];
var inst_40682 = (new cljs.core.PersistentVector(null,1,(5),inst_40680,inst_40681,null));
var inst_40647 = inst_40657;
var inst_40648 = inst_40679;
var inst_40649 = inst_40682;
var inst_40650 = inst_40674;
var state_40700__$1 = (function (){var statearr_40713 = state_40700;
(statearr_40713[(7)] = inst_40648);

(statearr_40713[(8)] = inst_40649);

(statearr_40713[(9)] = inst_40650);

(statearr_40713[(13)] = inst_40647);

return statearr_40713;
})();
var statearr_40714_40761 = state_40700__$1;
(statearr_40714_40761[(2)] = null);

(statearr_40714_40761[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (17))){
var inst_40656 = (state_40700[(11)]);
var inst_40648 = (state_40700[(7)]);
var inst_40649 = (state_40700[(8)]);
var inst_40650 = (state_40700[(9)]);
var inst_40657 = (state_40700[(12)]);
var inst_40665 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40649,inst_40656);
var tmp40710 = inst_40648;
var tmp40711 = inst_40650;
var inst_40647 = inst_40657;
var inst_40648__$1 = tmp40710;
var inst_40649__$1 = inst_40665;
var inst_40650__$1 = tmp40711;
var state_40700__$1 = (function (){var statearr_40715 = state_40700;
(statearr_40715[(7)] = inst_40648__$1);

(statearr_40715[(8)] = inst_40649__$1);

(statearr_40715[(9)] = inst_40650__$1);

(statearr_40715[(13)] = inst_40647);

return statearr_40715;
})();
var statearr_40716_40762 = state_40700__$1;
(statearr_40716_40762[(2)] = null);

(statearr_40716_40762[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (3))){
var inst_40698 = (state_40700[(2)]);
var state_40700__$1 = state_40700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40700__$1,inst_40698);
} else {
if((state_val_40701 === (12))){
var inst_40656 = (state_40700[(11)]);
var inst_40647 = (state_40700[(13)]);
var inst_40655 = cljs.core.seq(inst_40647);
var inst_40656__$1 = cljs.core.first(inst_40655);
var inst_40657 = cljs.core.next(inst_40655);
var state_40700__$1 = (function (){var statearr_40717 = state_40700;
(statearr_40717[(11)] = inst_40656__$1);

(statearr_40717[(12)] = inst_40657);

return statearr_40717;
})();
if(cljs.core.truth_(inst_40656__$1)){
var statearr_40718_40763 = state_40700__$1;
(statearr_40718_40763[(1)] = (14));

} else {
var statearr_40719_40764 = state_40700__$1;
(statearr_40719_40764[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (2))){
var _ = (function (){var statearr_40720 = state_40700;
(statearr_40720[(4)] = cljs.core.cons((5),(state_40700[(4)])));

return statearr_40720;
})();
var inst_40612 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_40613 = (inst_40612 + (1));
var inst_40614 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_40613);
var state_40700__$1 = state_40700;
if(inst_40614){
var statearr_40721_40765 = state_40700__$1;
(statearr_40721_40765[(1)] = (6));

} else {
var statearr_40722_40766 = state_40700__$1;
(statearr_40722_40766[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (23))){
var inst_40656 = (state_40700[(11)]);
var inst_40673 = (state_40700[(2)]);
var inst_40674 = fluree.db.util.async.throw_err(inst_40673);
var inst_40675 = (inst_40656 == null);
var state_40700__$1 = (function (){var statearr_40723 = state_40700;
(statearr_40723[(10)] = inst_40674);

return statearr_40723;
})();
if(cljs.core.truth_(inst_40675)){
var statearr_40724_40767 = state_40700__$1;
(statearr_40724_40767[(1)] = (24));

} else {
var statearr_40725_40768 = state_40700__$1;
(statearr_40725_40768[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (19))){
var inst_40690 = (state_40700[(2)]);
var state_40700__$1 = state_40700;
var statearr_40726_40769 = state_40700__$1;
(statearr_40726_40769[(2)] = inst_40690);

(statearr_40726_40769[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (11))){
var inst_40695 = (state_40700[(2)]);
var _ = (function (){var statearr_40728 = state_40700;
(statearr_40728[(4)] = cljs.core.rest((state_40700[(4)])));

return statearr_40728;
})();
var state_40700__$1 = state_40700;
var statearr_40729_40770 = state_40700__$1;
(statearr_40729_40770[(2)] = inst_40695);

(statearr_40729_40770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (9))){
var inst_40629 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_40630 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_40629);
var state_40700__$1 = state_40700;
var statearr_40730_40771 = state_40700__$1;
(statearr_40730_40771[(2)] = inst_40630);

(statearr_40730_40771[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (5))){
var _ = (function (){var statearr_40731 = state_40700;
(statearr_40731[(4)] = cljs.core.rest((state_40700[(4)])));

return statearr_40731;
})();
var state_40700__$1 = state_40700;
var ex40727 = (state_40700__$1[(2)]);
var statearr_40732_40772 = state_40700__$1;
(statearr_40732_40772[(5)] = ex40727);


var statearr_40733_40773 = state_40700__$1;
(statearr_40733_40773[(1)] = (4));

(statearr_40733_40773[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (14))){
var inst_40656 = (state_40700[(11)]);
var inst_40648 = (state_40700[(7)]);
var inst_40659 = inst_40656.t;
var inst_40660 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40648,inst_40659);
var state_40700__$1 = state_40700;
var statearr_40734_40774 = state_40700__$1;
(statearr_40734_40774[(2)] = inst_40660);

(statearr_40734_40774[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (26))){
var inst_40685 = (state_40700[(2)]);
var state_40700__$1 = state_40700;
var statearr_40735_40775 = state_40700__$1;
(statearr_40735_40775[(2)] = inst_40685);

(statearr_40735_40775[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (16))){
var inst_40663 = (state_40700[(2)]);
var state_40700__$1 = state_40700;
if(cljs.core.truth_(inst_40663)){
var statearr_40736_40776 = state_40700__$1;
(statearr_40736_40776[(1)] = (17));

} else {
var statearr_40737_40777 = state_40700__$1;
(statearr_40737_40777[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (10))){
var inst_40632 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_40640 = cljs.core.seq(inst_40632);
var inst_40641 = cljs.core.first(inst_40640);
var inst_40642 = cljs.core.next(inst_40640);
var inst_40643 = cljs.core.first(inst_40632);
var inst_40644 = inst_40643.t;
var inst_40645 = cljs.core.PersistentVector.EMPTY;
var inst_40646 = db;
var inst_40647 = inst_40632;
var inst_40648 = inst_40644;
var inst_40649 = inst_40645;
var inst_40650 = inst_40646;
var state_40700__$1 = (function (){var statearr_40738 = state_40700;
(statearr_40738[(7)] = inst_40648);

(statearr_40738[(8)] = inst_40649);

(statearr_40738[(14)] = inst_40642);

(statearr_40738[(15)] = inst_40641);

(statearr_40738[(9)] = inst_40650);

(statearr_40738[(13)] = inst_40647);

return statearr_40738;
})();
var statearr_40739_40778 = state_40700__$1;
(statearr_40739_40778[(2)] = null);

(statearr_40739_40778[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (18))){
var state_40700__$1 = state_40700;
var statearr_40740_40779 = state_40700__$1;
(statearr_40740_40779[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40701 === (8))){
var inst_40626 = (state_40700[(2)]);
var inst_40627 = cljs.core.empty_QMARK_(flakes);
var state_40700__$1 = (function (){var statearr_40742 = state_40700;
(statearr_40742[(16)] = inst_40626);

return statearr_40742;
})();
if(inst_40627){
var statearr_40743_40780 = state_40700__$1;
(statearr_40743_40780[(1)] = (9));

} else {
var statearr_40744_40781 = state_40700__$1;
(statearr_40744_40781[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__14778__auto__ = null;
var fluree$db$graphdb$state_machine__14778__auto____0 = (function (){
var statearr_40745 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40745[(0)] = fluree$db$graphdb$state_machine__14778__auto__);

(statearr_40745[(1)] = (1));

return statearr_40745;
});
var fluree$db$graphdb$state_machine__14778__auto____1 = (function (state_40700){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_40700);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e40746){var ex__14781__auto__ = e40746;
var statearr_40747_40782 = state_40700;
(statearr_40747_40782[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_40700[(4)]))){
var statearr_40748_40783 = state_40700;
(statearr_40748_40783[(1)] = cljs.core.first((state_40700[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__40784 = state_40700;
state_40700 = G__40784;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__14778__auto__ = function(state_40700){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__14778__auto____1.call(this,state_40700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__14778__auto____0;
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__14778__auto____1;
return fluree$db$graphdb$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_40749 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_40749[(6)] = c__14852__auto___40751);

return statearr_40749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_40840){
var state_val_40841 = (state_40840[(1)]);
if((state_val_40841 === (7))){
var state_40840__$1 = state_40840;
var statearr_40842_40869 = state_40840__$1;
(statearr_40842_40869[(2)] = tt_id);

(statearr_40842_40869[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (1))){
var state_40840__$1 = state_40840;
var statearr_40843_40870 = state_40840__$1;
(statearr_40843_40870[(2)] = null);

(statearr_40843_40870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (4))){
var inst_40785 = (state_40840[(2)]);
var state_40840__$1 = state_40840;
var statearr_40844_40871 = state_40840__$1;
(statearr_40844_40871[(2)] = inst_40785);

(statearr_40844_40871[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (13))){
var inst_40833 = (state_40840[(2)]);
var state_40840__$1 = state_40840;
var statearr_40845_40872 = state_40840__$1;
(statearr_40845_40872[(2)] = inst_40833);

(statearr_40845_40872[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (6))){
var inst_40793 = fluree.db.util.core.random_uuid();
var state_40840__$1 = state_40840;
var statearr_40846_40873 = state_40840__$1;
(statearr_40846_40873[(2)] = inst_40793);

(statearr_40846_40873[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (3))){
var inst_40838 = (state_40840[(2)]);
var state_40840__$1 = state_40840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40840__$1,inst_40838);
} else {
if((state_val_40841 === (12))){
var inst_40816 = (state_40840[(7)]);
var state_40840__$1 = state_40840;
var statearr_40847_40874 = state_40840__$1;
(statearr_40847_40874[(2)] = inst_40816);

(statearr_40847_40874[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (2))){
var _ = (function (){var statearr_40848 = state_40840;
(statearr_40848[(4)] = cljs.core.cons((5),(state_40840[(4)])));

return statearr_40848;
})();
var inst_40791 = (tt_id == null);
var state_40840__$1 = state_40840;
if(cljs.core.truth_(inst_40791)){
var statearr_40849_40875 = state_40840__$1;
(statearr_40849_40875[(1)] = (6));

} else {
var statearr_40850_40876 = state_40840__$1;
(statearr_40850_40876[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (11))){
var inst_40816 = (state_40840[(7)]);
var inst_40823 = (state_40840[(8)]);
var inst_40826 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_40816,inst_40823);
var state_40840__$1 = state_40840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40840__$1,(14),inst_40826);
} else {
if((state_val_40841 === (9))){
var inst_40823 = (state_40840[(8)]);
var inst_40817 = (state_40840[(9)]);
var inst_40822 = cljs.core.seq(inst_40817);
var inst_40823__$1 = cljs.core.first(inst_40822);
var inst_40824 = cljs.core.next(inst_40822);
var state_40840__$1 = (function (){var statearr_40852 = state_40840;
(statearr_40852[(10)] = inst_40824);

(statearr_40852[(8)] = inst_40823__$1);

return statearr_40852;
})();
if(cljs.core.truth_(inst_40823__$1)){
var statearr_40853_40877 = state_40840__$1;
(statearr_40853_40877[(1)] = (11));

} else {
var statearr_40854_40878 = state_40840__$1;
(statearr_40854_40878[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (5))){
var _ = (function (){var statearr_40855 = state_40840;
(statearr_40855[(4)] = cljs.core.rest((state_40840[(4)])));

return statearr_40855;
})();
var state_40840__$1 = state_40840;
var ex40851 = (state_40840__$1[(2)]);
var statearr_40856_40879 = state_40840__$1;
(statearr_40856_40879[(5)] = ex40851);


if((ex40851 instanceof Error)){
var statearr_40857_40880 = state_40840__$1;
(statearr_40857_40880[(1)] = (4));

(statearr_40857_40880[(5)] = null);

} else {
throw ex40851;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (14))){
var inst_40824 = (state_40840[(10)]);
var inst_40828 = (state_40840[(2)]);
var inst_40829 = fluree.db.util.async.throw_err(inst_40828);
var inst_40816 = inst_40829;
var inst_40817 = inst_40824;
var state_40840__$1 = (function (){var statearr_40858 = state_40840;
(statearr_40858[(7)] = inst_40816);

(statearr_40858[(9)] = inst_40817);

return statearr_40858;
})();
var statearr_40859_40881 = state_40840__$1;
(statearr_40859_40881[(2)] = null);

(statearr_40859_40881[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (10))){
var inst_40835 = (state_40840[(2)]);
var _ = (function (){var statearr_40860 = state_40840;
(statearr_40860[(4)] = cljs.core.rest((state_40840[(4)])));

return statearr_40860;
})();
var state_40840__$1 = state_40840;
var statearr_40861_40882 = state_40840__$1;
(statearr_40861_40882[(2)] = inst_40835);

(statearr_40861_40882[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (8))){
var inst_40796 = (state_40840[(2)]);
var inst_40797 = (function (){var tt_id_SINGLEQUOTE_ = inst_40796;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_40798 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_40796);
var inst_40799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40800 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_40801 = (new cljs.core.PersistentVector(null,4,(5),inst_40799,inst_40800,null));
var inst_40802 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_40797,inst_40798,inst_40801);
var inst_40803 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_40804 = cljs.core.reverse(inst_40803);
var inst_40805 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_40804);
var inst_40813 = cljs.core.seq(inst_40805);
var inst_40814 = cljs.core.first(inst_40813);
var inst_40815 = cljs.core.next(inst_40813);
var inst_40816 = inst_40802;
var inst_40817 = inst_40805;
var state_40840__$1 = (function (){var statearr_40862 = state_40840;
(statearr_40862[(7)] = inst_40816);

(statearr_40862[(11)] = inst_40814);

(statearr_40862[(12)] = inst_40815);

(statearr_40862[(9)] = inst_40817);

return statearr_40862;
})();
var statearr_40863_40883 = state_40840__$1;
(statearr_40863_40883[(2)] = null);

(statearr_40863_40883[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto____0 = (function (){
var statearr_40864 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40864[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto__);

(statearr_40864[(1)] = (1));

return statearr_40864;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto____1 = (function (state_40840){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_40840);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e40865){var ex__14781__auto__ = e40865;
var statearr_40866_40884 = state_40840;
(statearr_40866_40884[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_40840[(4)]))){
var statearr_40867_40885 = state_40840;
(statearr_40867_40885[(1)] = cljs.core.first((state_40840[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__40886 = state_40840;
state_40840 = G__40886;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto__ = function(state_40840){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto____1.call(this,state_40840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_40868 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_40868[(6)] = c__14852__auto__);

return statearr_40868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__14852__auto___41073 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41004){
var state_val_41005 = (state_41004[(1)]);
if((state_val_41005 === (7))){
var inst_40914 = (state_41004[(7)]);
var inst_40914__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_41004__$1 = (function (){var statearr_41006 = state_41004;
(statearr_41006[(7)] = inst_40914__$1);

return statearr_41006;
})();
if(inst_40914__$1){
var statearr_41007_41074 = state_41004__$1;
(statearr_41007_41074[(1)] = (13));

} else {
var statearr_41008_41075 = state_41004__$1;
(statearr_41008_41075[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (20))){
var state_41004__$1 = state_41004;
var statearr_41009_41076 = state_41004__$1;
(statearr_41009_41076[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (27))){
var inst_40950 = (state_41004[(8)]);
var inst_40954 = inst_40950.s;
var state_41004__$1 = state_41004;
var statearr_41011_41077 = state_41004__$1;
(statearr_41011_41077[(2)] = inst_40954);

(statearr_41011_41077[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (1))){
var state_41004__$1 = state_41004;
var statearr_41012_41078 = state_41004__$1;
(statearr_41012_41078[(2)] = null);

(statearr_41012_41078[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (24))){
var inst_40944 = (state_41004[(9)]);
var inst_40948 = cljs.core.first(inst_40944);
var state_41004__$1 = state_41004;
var statearr_41013_41079 = state_41004__$1;
(statearr_41013_41079[(2)] = inst_40948);

(statearr_41013_41079[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (39))){
var state_41004__$1 = state_41004;
var statearr_41014_41080 = state_41004__$1;
(statearr_41014_41080[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (4))){
var inst_40887 = (state_41004[(2)]);
var inst_40888 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_40889 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40890 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_40891 = cljs.core.PersistentHashMap.fromArrays(inst_40889,inst_40890);
var inst_40892 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_40888,inst_40891,inst_40887);
var inst_40893 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_40892);
var state_41004__$1 = state_41004;
var statearr_41016_41081 = state_41004__$1;
(statearr_41016_41081[(2)] = inst_40893);

(statearr_41016_41081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (15))){
var inst_40921 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
if(cljs.core.truth_(inst_40921)){
var statearr_41017_41082 = state_41004__$1;
(statearr_41017_41082[(1)] = (16));

} else {
var statearr_41018_41083 = state_41004__$1;
(statearr_41018_41083[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (21))){
var inst_40970 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
var statearr_41019_41084 = state_41004__$1;
(statearr_41019_41084[(2)] = inst_40970);

(statearr_41019_41084[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (31))){
var inst_40968 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
var statearr_41020_41085 = state_41004__$1;
(statearr_41020_41085[(2)] = inst_40968);

(statearr_41020_41085[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (32))){
var inst_40974 = (state_41004[(10)]);
var inst_40976 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_40974);
var state_41004__$1 = state_41004;
var statearr_41021_41086 = state_41004__$1;
(statearr_41021_41086[(2)] = inst_40976);

(statearr_41021_41086[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (40))){
var inst_40997 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
var statearr_41022_41087 = state_41004__$1;
(statearr_41022_41087[(2)] = inst_40997);

(statearr_41022_41087[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (33))){
var inst_40974 = (state_41004[(10)]);
var inst_40978 = (state_41004[(11)]);
var inst_40978__$1 = (inst_40974 == null);
var state_41004__$1 = (function (){var statearr_41023 = state_41004;
(statearr_41023[(11)] = inst_40978__$1);

return statearr_41023;
})();
if(cljs.core.truth_(inst_40978__$1)){
var statearr_41024_41088 = state_41004__$1;
(statearr_41024_41088[(1)] = (35));

} else {
var statearr_41025_41089 = state_41004__$1;
(statearr_41025_41089[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (13))){
var inst_40916 = cljs.core.first(ident);
var inst_40917 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_40916);
var inst_40918 = (inst_40917 == null);
var state_41004__$1 = state_41004;
var statearr_41026_41090 = state_41004__$1;
(statearr_41026_41090[(2)] = inst_40918);

(statearr_41026_41090[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (22))){
var inst_40944 = (state_41004[(9)]);
var inst_40943 = (state_41004[(2)]);
var inst_40944__$1 = fluree.db.util.async.throw_err(inst_40943);
var inst_40945 = (inst_40944__$1 == null);
var state_41004__$1 = (function (){var statearr_41027 = state_41004;
(statearr_41027[(9)] = inst_40944__$1);

return statearr_41027;
})();
if(cljs.core.truth_(inst_40945)){
var statearr_41028_41091 = state_41004__$1;
(statearr_41028_41091[(1)] = (23));

} else {
var statearr_41029_41092 = state_41004__$1;
(statearr_41029_41092[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (36))){
var inst_40978 = (state_41004[(11)]);
var state_41004__$1 = state_41004;
var statearr_41030_41093 = state_41004__$1;
(statearr_41030_41093[(2)] = inst_40978);

(statearr_41030_41093[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (41))){
var inst_40992 = cljs.core.async.close_BANG_(return_chan);
var state_41004__$1 = state_41004;
var statearr_41031_41094 = state_41004__$1;
(statearr_41031_41094[(2)] = inst_40992);

(statearr_41031_41094[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (43))){
var inst_40995 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
var statearr_41032_41095 = state_41004__$1;
(statearr_41032_41095[(2)] = inst_40995);

(statearr_41032_41095[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (29))){
var inst_40959 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_40960 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_40959].join('');
var inst_40961 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40962 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_40963 = cljs.core.PersistentHashMap.fromArrays(inst_40961,inst_40962);
var inst_40964 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40960,inst_40963);
var inst_40965 = (function(){throw inst_40964})();
var state_41004__$1 = state_41004;
var statearr_41033_41096 = state_41004__$1;
(statearr_41033_41096[(2)] = inst_40965);

(statearr_41033_41096[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (6))){
var inst_40901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40902 = [ident];
var inst_40903 = (new cljs.core.PersistentVector(null,1,(5),inst_40901,inst_40902,null));
var inst_40904 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_40903);
var state_41004__$1 = state_41004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41004__$1,(9),inst_40904);
} else {
if((state_val_41005 === (28))){
var inst_40956 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
var statearr_41034_41097 = state_41004__$1;
(statearr_41034_41097[(2)] = inst_40956);

(statearr_41034_41097[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (25))){
var inst_40950 = (state_41004[(8)]);
var inst_40950__$1 = (state_41004[(2)]);
var inst_40951 = (inst_40950__$1 == null);
var state_41004__$1 = (function (){var statearr_41035 = state_41004;
(statearr_41035[(8)] = inst_40950__$1);

return statearr_41035;
})();
if(cljs.core.truth_(inst_40951)){
var statearr_41036_41098 = state_41004__$1;
(statearr_41036_41098[(1)] = (26));

} else {
var statearr_41037_41099 = state_41004__$1;
(statearr_41037_41099[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (34))){
var inst_40999 = (state_41004[(2)]);
var _ = (function (){var statearr_41038 = state_41004;
(statearr_41038[(4)] = cljs.core.rest((state_41004[(4)])));

return statearr_41038;
})();
var state_41004__$1 = state_41004;
var statearr_41039_41100 = state_41004__$1;
(statearr_41039_41100[(2)] = inst_40999);

(statearr_41039_41100[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (17))){
var inst_40932 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_41004__$1 = state_41004;
if(inst_40932){
var statearr_41040_41101 = state_41004__$1;
(statearr_41040_41101[(1)] = (19));

} else {
var statearr_41041_41102 = state_41004__$1;
(statearr_41041_41102[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (3))){
var inst_41002 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41004__$1,inst_41002);
} else {
if((state_val_41005 === (12))){
var inst_40912 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
var statearr_41042_41103 = state_41004__$1;
(statearr_41042_41103[(2)] = inst_40912);

(statearr_41042_41103[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (2))){
var _ = (function (){var statearr_41043 = state_41004;
(statearr_41043[(4)] = cljs.core.cons((5),(state_41004[(4)])));

return statearr_41043;
})();
var inst_40899 = typeof ident === 'number';
var state_41004__$1 = state_41004;
if(cljs.core.truth_(inst_40899)){
var statearr_41044_41104 = state_41004__$1;
(statearr_41044_41104[(1)] = (6));

} else {
var statearr_41045_41105 = state_41004__$1;
(statearr_41045_41105[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (23))){
var state_41004__$1 = state_41004;
var statearr_41046_41106 = state_41004__$1;
(statearr_41046_41106[(2)] = null);

(statearr_41046_41106[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (35))){
var state_41004__$1 = state_41004;
var statearr_41047_41107 = state_41004__$1;
(statearr_41047_41107[(2)] = strict_QMARK_);

(statearr_41047_41107[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (19))){
var inst_40935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40936 = cljs.core.first(ident);
var inst_40937 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_40936);
var inst_40938 = cljs.core.second(ident);
var inst_40939 = [inst_40937,inst_40938];
var inst_40940 = (new cljs.core.PersistentVector(null,2,(5),inst_40935,inst_40939,null));
var inst_40941 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_40940);
var state_41004__$1 = state_41004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41004__$1,(22),inst_40941);
} else {
if((state_val_41005 === (11))){
var state_41004__$1 = state_41004;
var statearr_41049_41108 = state_41004__$1;
(statearr_41049_41108[(2)] = null);

(statearr_41049_41108[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (9))){
var inst_40906 = (state_41004[(2)]);
var inst_40907 = fluree.db.util.async.throw_err(inst_40906);
var inst_40908 = cljs.core.not_empty(inst_40907);
var state_41004__$1 = state_41004;
if(cljs.core.truth_(inst_40908)){
var statearr_41050_41109 = state_41004__$1;
(statearr_41050_41109[(1)] = (10));

} else {
var statearr_41051_41110 = state_41004__$1;
(statearr_41051_41110[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (5))){
var _ = (function (){var statearr_41052 = state_41004;
(statearr_41052[(4)] = cljs.core.rest((state_41004[(4)])));

return statearr_41052;
})();
var state_41004__$1 = state_41004;
var ex41048 = (state_41004__$1[(2)]);
var statearr_41053_41111 = state_41004__$1;
(statearr_41053_41111[(5)] = ex41048);


var statearr_41054_41112 = state_41004__$1;
(statearr_41054_41112[(1)] = (4));

(statearr_41054_41112[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (14))){
var inst_40914 = (state_41004[(7)]);
var state_41004__$1 = state_41004;
var statearr_41055_41113 = state_41004__$1;
(statearr_41055_41113[(2)] = inst_40914);

(statearr_41055_41113[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (26))){
var state_41004__$1 = state_41004;
var statearr_41056_41114 = state_41004__$1;
(statearr_41056_41114[(2)] = null);

(statearr_41056_41114[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (16))){
var inst_40923 = cljs.core.first(ident);
var inst_40924 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40923], 0));
var inst_40925 = ["Subject ID lookup failed. The predicate ",inst_40924," does not exist."].join('');
var inst_40926 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40927 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_40928 = cljs.core.PersistentHashMap.fromArrays(inst_40926,inst_40927);
var inst_40929 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40925,inst_40928);
var inst_40930 = (function(){throw inst_40929})();
var state_41004__$1 = state_41004;
var statearr_41057_41115 = state_41004__$1;
(statearr_41057_41115[(2)] = inst_40930);

(statearr_41057_41115[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (38))){
var inst_40984 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_40985 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40986 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_40987 = cljs.core.PersistentHashMap.fromArrays(inst_40985,inst_40986);
var inst_40988 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40984,inst_40987);
var inst_40989 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_40988);
var state_41004__$1 = state_41004;
var statearr_41058_41116 = state_41004__$1;
(statearr_41058_41116[(2)] = inst_40989);

(statearr_41058_41116[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (30))){
var state_41004__$1 = state_41004;
var statearr_41059_41117 = state_41004__$1;
(statearr_41059_41117[(2)] = null);

(statearr_41059_41117[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (10))){
var state_41004__$1 = state_41004;
var statearr_41060_41118 = state_41004__$1;
(statearr_41060_41118[(2)] = ident);

(statearr_41060_41118[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (18))){
var inst_40972 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
var statearr_41061_41119 = state_41004__$1;
(statearr_41061_41119[(2)] = inst_40972);

(statearr_41061_41119[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (42))){
var state_41004__$1 = state_41004;
var statearr_41062_41120 = state_41004__$1;
(statearr_41062_41120[(2)] = null);

(statearr_41062_41120[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (37))){
var inst_40982 = (state_41004[(2)]);
var state_41004__$1 = state_41004;
if(cljs.core.truth_(inst_40982)){
var statearr_41063_41121 = state_41004__$1;
(statearr_41063_41121[(1)] = (38));

} else {
var statearr_41064_41122 = state_41004__$1;
(statearr_41064_41122[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41005 === (8))){
var inst_40974 = (state_41004[(10)]);
var inst_40974__$1 = (state_41004[(2)]);
var state_41004__$1 = (function (){var statearr_41065 = state_41004;
(statearr_41065[(10)] = inst_40974__$1);

return statearr_41065;
})();
if(cljs.core.truth_(inst_40974__$1)){
var statearr_41066_41123 = state_41004__$1;
(statearr_41066_41123[(1)] = (32));

} else {
var statearr_41067_41124 = state_41004__$1;
(statearr_41067_41124[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__14778__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__14778__auto____0 = (function (){
var statearr_41068 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41068[(0)] = fluree$db$graphdb$subid_$_state_machine__14778__auto__);

(statearr_41068[(1)] = (1));

return statearr_41068;
});
var fluree$db$graphdb$subid_$_state_machine__14778__auto____1 = (function (state_41004){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41004);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41069){var ex__14781__auto__ = e41069;
var statearr_41070_41125 = state_41004;
(statearr_41070_41125[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41004[(4)]))){
var statearr_41071_41126 = state_41004;
(statearr_41071_41126[(1)] = cljs.core.first((state_41004[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41127 = state_41004;
state_41004 = G__41127;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__14778__auto__ = function(state_41004){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__14778__auto____1.call(this,state_41004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__14778__auto____0;
fluree$db$graphdb$subid_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__14778__auto____1;
return fluree$db$graphdb$subid_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41072 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41072[(6)] = c__14852__auto___41073);

return statearr_41072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k41129,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__41133 = k41129;
var G__41133__$1 = (((G__41133 instanceof cljs.core.Keyword))?G__41133.fqn:null);
switch (G__41133__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k41129,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__41134){
var vec__41135 = p__41134;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41135,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41135,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__41128){
var self__ = this;
var G__41128__$1 = this;
return (new cljs.core.RecordIter((0),G__41128__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__41138 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__41138(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this41130,other41131){
var self__ = this;
var this41130__$1 = this;
return (((!((other41131 == null)))) && ((((this41130__$1.constructor === other41131.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.conn,other41131.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.network,other41131.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.dbid,other41131.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.block,other41131.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.t,other41131.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.tt_id,other41131.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.stats,other41131.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.spot,other41131.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.psot,other41131.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.post,other41131.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.opst,other41131.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.schema,other41131.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.settings,other41131.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.index_configs,other41131.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.schema_cache,other41131.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.novelty,other41131.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.permissions,other41131.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.fork,other41131.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.fork_block,other41131.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.current_db_fn,other41131.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this41130__$1.__extmap,other41131.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k41129){
var self__ = this;
var this__4479__auto____$1 = this;
var G__41139 = k41129;
var G__41139__$1 = (((G__41139 instanceof cljs.core.Keyword))?G__41139.fqn:null);
switch (G__41139__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k41129);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__41128){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__41140 = cljs.core.keyword_identical_QMARK_;
var expr__41141 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__41143 = cljs.core.cst$kw$conn;
var G__41144 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41143,G__41144) : pred__41140.call(null,G__41143,G__41144));
})())){
return (new fluree.db.graphdb.GraphDb(G__41128,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41145 = cljs.core.cst$kw$network;
var G__41146 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41145,G__41146) : pred__41140.call(null,G__41145,G__41146));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__41128,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41147 = cljs.core.cst$kw$dbid;
var G__41148 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41147,G__41148) : pred__41140.call(null,G__41147,G__41148));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__41128,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41149 = cljs.core.cst$kw$block;
var G__41150 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41149,G__41150) : pred__41140.call(null,G__41149,G__41150));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__41128,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41151 = cljs.core.cst$kw$t;
var G__41152 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41151,G__41152) : pred__41140.call(null,G__41151,G__41152));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__41128,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41153 = cljs.core.cst$kw$tt_DASH_id;
var G__41154 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41153,G__41154) : pred__41140.call(null,G__41153,G__41154));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__41128,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41155 = cljs.core.cst$kw$stats;
var G__41156 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41155,G__41156) : pred__41140.call(null,G__41155,G__41156));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__41128,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41157 = cljs.core.cst$kw$spot;
var G__41158 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41157,G__41158) : pred__41140.call(null,G__41157,G__41158));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__41128,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41159 = cljs.core.cst$kw$psot;
var G__41160 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41159,G__41160) : pred__41140.call(null,G__41159,G__41160));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__41128,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41161 = cljs.core.cst$kw$post;
var G__41162 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41161,G__41162) : pred__41140.call(null,G__41161,G__41162));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__41128,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41163 = cljs.core.cst$kw$opst;
var G__41164 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41163,G__41164) : pred__41140.call(null,G__41163,G__41164));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__41128,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41165 = cljs.core.cst$kw$schema;
var G__41166 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41165,G__41166) : pred__41140.call(null,G__41165,G__41166));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__41128,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41167 = cljs.core.cst$kw$settings;
var G__41168 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41167,G__41168) : pred__41140.call(null,G__41167,G__41168));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__41128,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41169 = cljs.core.cst$kw$index_DASH_configs;
var G__41170 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41169,G__41170) : pred__41140.call(null,G__41169,G__41170));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__41128,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41171 = cljs.core.cst$kw$schema_DASH_cache;
var G__41172 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41171,G__41172) : pred__41140.call(null,G__41171,G__41172));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__41128,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41173 = cljs.core.cst$kw$novelty;
var G__41174 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41173,G__41174) : pred__41140.call(null,G__41173,G__41174));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__41128,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41175 = cljs.core.cst$kw$permissions;
var G__41176 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41175,G__41176) : pred__41140.call(null,G__41175,G__41176));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__41128,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41177 = cljs.core.cst$kw$fork;
var G__41178 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41177,G__41178) : pred__41140.call(null,G__41177,G__41178));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__41128,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41179 = cljs.core.cst$kw$fork_DASH_block;
var G__41180 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41179,G__41180) : pred__41140.call(null,G__41179,G__41180));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__41128,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__41181 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__41182 = expr__41141;
return (pred__41140.cljs$core$IFn$_invoke$arity$2 ? pred__41140.cljs$core$IFn$_invoke$arity$2(G__41181,G__41182) : pred__41140.call(null,G__41181,G__41182));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__41128,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__41128),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__41128){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__41128,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41198){
var state_val_41199 = (state_41198[(1)]);
if((state_val_41199 === (1))){
var state_41198__$1 = state_41198;
var statearr_41200_41467 = state_41198__$1;
(statearr_41200_41467[(2)] = null);

(statearr_41200_41467[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41199 === (2))){
var _ = (function (){var statearr_41201 = state_41198;
(statearr_41201[(4)] = cljs.core.cons((5),(state_41198[(4)])));

return statearr_41201;
})();
var inst_41189 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_41198__$1 = state_41198;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41198__$1,(6),inst_41189);
} else {
if((state_val_41199 === (3))){
var inst_41196 = (state_41198[(2)]);
var state_41198__$1 = state_41198;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41198__$1,inst_41196);
} else {
if((state_val_41199 === (4))){
var inst_41183 = (state_41198[(2)]);
var state_41198__$1 = state_41198;
var statearr_41203_41468 = state_41198__$1;
(statearr_41203_41468[(2)] = inst_41183);

(statearr_41203_41468[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41199 === (5))){
var _ = (function (){var statearr_41204 = state_41198;
(statearr_41204[(4)] = cljs.core.rest((state_41198[(4)])));

return statearr_41204;
})();
var state_41198__$1 = state_41198;
var ex41202 = (state_41198__$1[(2)]);
var statearr_41205_41469 = state_41198__$1;
(statearr_41205_41469[(5)] = ex41202);


if((ex41202 instanceof Error)){
var statearr_41206_41470 = state_41198__$1;
(statearr_41206_41470[(1)] = (4));

(statearr_41206_41470[(5)] = null);

} else {
throw ex41202;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41199 === (6))){
var inst_41191 = (state_41198[(2)]);
var inst_41192 = fluree.db.util.async.throw_err(inst_41191);
var inst_41193 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41192,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_41207 = state_41198;
(statearr_41207[(4)] = cljs.core.rest((state_41198[(4)])));

return statearr_41207;
})();
var state_41198__$1 = state_41198;
var statearr_41208_41471 = state_41198__$1;
(statearr_41208_41471[(2)] = inst_41193);

(statearr_41208_41471[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__14778__auto__ = null;
var fluree$db$graphdb$state_machine__14778__auto____0 = (function (){
var statearr_41209 = [null,null,null,null,null,null,null];
(statearr_41209[(0)] = fluree$db$graphdb$state_machine__14778__auto__);

(statearr_41209[(1)] = (1));

return statearr_41209;
});
var fluree$db$graphdb$state_machine__14778__auto____1 = (function (state_41198){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41198);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41210){var ex__14781__auto__ = e41210;
var statearr_41211_41472 = state_41198;
(statearr_41211_41472[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41198[(4)]))){
var statearr_41212_41473 = state_41198;
(statearr_41212_41473[(1)] = cljs.core.first((state_41198[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41474 = state_41198;
state_41198 = G__41474;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__14778__auto__ = function(state_41198){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__14778__auto____1.call(this,state_41198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__14778__auto____0;
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__14778__auto____1;
return fluree$db$graphdb$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41213 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41213[(6)] = c__14852__auto__);

return statearr_41213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__41214 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__41214.cljs$core$IFn$_invoke$arity$1 ? fexpr__41214.cljs$core$IFn$_invoke$arity$1(property) : fexpr__41214.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__41215 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__41215.cljs$core$IFn$_invoke$arity$1 ? fexpr__41215.cljs$core$IFn$_invoke$arity$1(property) : fexpr__41215.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__41216 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$partition,G__41216);
} else {
return G__41216;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41248){
var state_val_41249 = (state_41248[(1)]);
if((state_val_41249 === (7))){
var state_41248__$1 = state_41248;
var statearr_41250_41475 = state_41248__$1;
(statearr_41250_41475[(2)] = null);

(statearr_41250_41475[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (1))){
var state_41248__$1 = state_41248;
var statearr_41251_41476 = state_41248__$1;
(statearr_41251_41476[(2)] = null);

(statearr_41251_41476[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (4))){
var inst_41217 = (state_41248[(2)]);
var state_41248__$1 = state_41248;
var statearr_41252_41477 = state_41248__$1;
(statearr_41252_41477[(2)] = inst_41217);

(statearr_41252_41477[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (6))){
var inst_41231 = (state_41248[(7)]);
var inst_41230 = (state_41248[(2)]);
var inst_41231__$1 = fluree.db.util.async.throw_err(inst_41230);
var inst_41232 = (inst_41231__$1 == null);
var state_41248__$1 = (function (){var statearr_41253 = state_41248;
(statearr_41253[(7)] = inst_41231__$1);

return statearr_41253;
})();
if(cljs.core.truth_(inst_41232)){
var statearr_41254_41478 = state_41248__$1;
(statearr_41254_41478[(1)] = (7));

} else {
var statearr_41255_41479 = state_41248__$1;
(statearr_41255_41479[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (3))){
var inst_41246 = (state_41248[(2)]);
var state_41248__$1 = state_41248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41248__$1,inst_41246);
} else {
if((state_val_41249 === (12))){
var inst_41243 = (state_41248[(2)]);
var _ = (function (){var statearr_41256 = state_41248;
(statearr_41256[(4)] = cljs.core.rest((state_41248[(4)])));

return statearr_41256;
})();
var state_41248__$1 = state_41248;
var statearr_41257_41480 = state_41248__$1;
(statearr_41257_41480[(2)] = inst_41243);

(statearr_41257_41480[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (2))){
var _ = (function (){var statearr_41258 = state_41248;
(statearr_41258[(4)] = cljs.core.cons((5),(state_41248[(4)])));

return statearr_41258;
})();
var inst_41224 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_41225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41226 = [tag_id,(30)];
var inst_41227 = (new cljs.core.PersistentVector(null,2,(5),inst_41225,inst_41226,null));
var inst_41228 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_41224,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_41227);
var state_41248__$1 = state_41248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41248__$1,(6),inst_41228);
} else {
if((state_val_41249 === (11))){
var inst_41237 = (state_41248[(8)]);
var inst_41241 = inst_41237.o;
var state_41248__$1 = state_41248;
var statearr_41260_41481 = state_41248__$1;
(statearr_41260_41481[(2)] = inst_41241);

(statearr_41260_41481[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (9))){
var inst_41237 = (state_41248[(8)]);
var inst_41237__$1 = (state_41248[(2)]);
var inst_41238 = (inst_41237__$1 == null);
var state_41248__$1 = (function (){var statearr_41261 = state_41248;
(statearr_41261[(8)] = inst_41237__$1);

return statearr_41261;
})();
if(cljs.core.truth_(inst_41238)){
var statearr_41262_41482 = state_41248__$1;
(statearr_41262_41482[(1)] = (10));

} else {
var statearr_41263_41483 = state_41248__$1;
(statearr_41263_41483[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (5))){
var _ = (function (){var statearr_41264 = state_41248;
(statearr_41264[(4)] = cljs.core.rest((state_41248[(4)])));

return statearr_41264;
})();
var state_41248__$1 = state_41248;
var ex41259 = (state_41248__$1[(2)]);
var statearr_41265_41484 = state_41248__$1;
(statearr_41265_41484[(5)] = ex41259);


if((ex41259 instanceof Error)){
var statearr_41266_41485 = state_41248__$1;
(statearr_41266_41485[(1)] = (4));

(statearr_41266_41485[(5)] = null);

} else {
throw ex41259;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (10))){
var state_41248__$1 = state_41248;
var statearr_41267_41486 = state_41248__$1;
(statearr_41267_41486[(2)] = null);

(statearr_41267_41486[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41249 === (8))){
var inst_41231 = (state_41248[(7)]);
var inst_41235 = cljs.core.first(inst_41231);
var state_41248__$1 = state_41248;
var statearr_41268_41487 = state_41248__$1;
(statearr_41268_41487[(2)] = inst_41235);

(statearr_41268_41487[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__14778__auto__ = null;
var fluree$db$graphdb$state_machine__14778__auto____0 = (function (){
var statearr_41269 = [null,null,null,null,null,null,null,null,null];
(statearr_41269[(0)] = fluree$db$graphdb$state_machine__14778__auto__);

(statearr_41269[(1)] = (1));

return statearr_41269;
});
var fluree$db$graphdb$state_machine__14778__auto____1 = (function (state_41248){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41248);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41270){var ex__14781__auto__ = e41270;
var statearr_41271_41488 = state_41248;
(statearr_41271_41488[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41248[(4)]))){
var statearr_41272_41489 = state_41248;
(statearr_41272_41489[(1)] = cljs.core.first((state_41248[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41490 = state_41248;
state_41248 = G__41490;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__14778__auto__ = function(state_41248){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__14778__auto____1.call(this,state_41248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__14778__auto____0;
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__14778__auto____1;
return fluree$db$graphdb$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41273 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41273[(6)] = c__14852__auto__);

return statearr_41273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41309){
var state_val_41310 = (state_41309[(1)]);
if((state_val_41310 === (7))){
var inst_41283 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_41309__$1 = state_41309;
var statearr_41311_41491 = state_41309__$1;
(statearr_41311_41491[(2)] = inst_41283);

(statearr_41311_41491[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (1))){
var state_41309__$1 = state_41309;
var statearr_41312_41492 = state_41309__$1;
(statearr_41312_41492[(2)] = null);

(statearr_41312_41492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (4))){
var inst_41274 = (state_41309[(2)]);
var state_41309__$1 = state_41309;
var statearr_41313_41493 = state_41309__$1;
(statearr_41313_41493[(2)] = inst_41274);

(statearr_41313_41493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (15))){
var inst_41304 = (state_41309[(2)]);
var _ = (function (){var statearr_41314 = state_41309;
(statearr_41314[(4)] = cljs.core.rest((state_41309[(4)])));

return statearr_41314;
})();
var state_41309__$1 = state_41309;
var statearr_41315_41494 = state_41309__$1;
(statearr_41315_41494[(2)] = inst_41304);

(statearr_41315_41494[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (13))){
var inst_41289 = (state_41309[(7)]);
var inst_41295 = clojure.string.includes_QMARK_(inst_41289,":");
var state_41309__$1 = state_41309;
if(inst_41295){
var statearr_41316_41495 = state_41309__$1;
(statearr_41316_41495[(1)] = (16));

} else {
var statearr_41317_41496 = state_41309__$1;
(statearr_41317_41496[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (6))){
var state_41309__$1 = state_41309;
var statearr_41318_41497 = state_41309__$1;
(statearr_41318_41497[(2)] = pred);

(statearr_41318_41497[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (17))){
var inst_41289 = (state_41309[(7)]);
var state_41309__$1 = state_41309;
var statearr_41319_41498 = state_41309__$1;
(statearr_41319_41498[(2)] = inst_41289);

(statearr_41319_41498[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (3))){
var inst_41307 = (state_41309[(2)]);
var state_41309__$1 = state_41309;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41309__$1,inst_41307);
} else {
if((state_val_41310 === (12))){
var inst_41293 = (state_41309[(2)]);
var state_41309__$1 = state_41309;
if(cljs.core.truth_(inst_41293)){
var statearr_41320_41499 = state_41309__$1;
(statearr_41320_41499[(1)] = (13));

} else {
var statearr_41321_41500 = state_41309__$1;
(statearr_41321_41500[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (2))){
var _ = (function (){var statearr_41322 = state_41309;
(statearr_41322[(4)] = cljs.core.cons((5),(state_41309[(4)])));

return statearr_41322;
})();
var inst_41280 = typeof pred === 'string';
var state_41309__$1 = state_41309;
if(cljs.core.truth_(inst_41280)){
var statearr_41323_41501 = state_41309__$1;
(statearr_41323_41501[(1)] = (6));

} else {
var statearr_41324_41502 = state_41309__$1;
(statearr_41324_41502[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (11))){
var inst_41285 = (state_41309[(8)]);
var state_41309__$1 = state_41309;
var statearr_41326_41503 = state_41309__$1;
(statearr_41326_41503[(2)] = inst_41285);

(statearr_41326_41503[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (9))){
var inst_41285 = (state_41309[(8)]);
var inst_41288 = (state_41309[(2)]);
var inst_41289 = fluree.db.util.async.throw_err(inst_41288);
var state_41309__$1 = (function (){var statearr_41327 = state_41309;
(statearr_41327[(7)] = inst_41289);

return statearr_41327;
})();
if(cljs.core.truth_(inst_41285)){
var statearr_41328_41504 = state_41309__$1;
(statearr_41328_41504[(1)] = (10));

} else {
var statearr_41329_41505 = state_41309__$1;
(statearr_41329_41505[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (5))){
var _ = (function (){var statearr_41330 = state_41309;
(statearr_41330[(4)] = cljs.core.rest((state_41309[(4)])));

return statearr_41330;
})();
var state_41309__$1 = state_41309;
var ex41325 = (state_41309__$1[(2)]);
var statearr_41331_41506 = state_41309__$1;
(statearr_41331_41506[(5)] = ex41325);


if((ex41325 instanceof Error)){
var statearr_41332_41507 = state_41309__$1;
(statearr_41332_41507[(1)] = (4));

(statearr_41332_41507[(5)] = null);

} else {
throw ex41325;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (14))){
var state_41309__$1 = state_41309;
var statearr_41333_41508 = state_41309__$1;
(statearr_41333_41508[(2)] = null);

(statearr_41333_41508[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (16))){
var inst_41289 = (state_41309[(7)]);
var inst_41297 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_41289,/:/);
var inst_41298 = cljs.core.second(inst_41297);
var state_41309__$1 = state_41309;
var statearr_41334_41509 = state_41309__$1;
(statearr_41334_41509[(2)] = inst_41298);

(statearr_41334_41509[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (10))){
var inst_41289 = (state_41309[(7)]);
var state_41309__$1 = state_41309;
var statearr_41335_41510 = state_41309__$1;
(statearr_41335_41510[(2)] = inst_41289);

(statearr_41335_41510[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (18))){
var inst_41301 = (state_41309[(2)]);
var state_41309__$1 = state_41309;
var statearr_41336_41511 = state_41309__$1;
(statearr_41336_41511[(2)] = inst_41301);

(statearr_41336_41511[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41310 === (8))){
var inst_41285 = (state_41309[(2)]);
var inst_41286 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_41309__$1 = (function (){var statearr_41337 = state_41309;
(statearr_41337[(8)] = inst_41285);

return statearr_41337;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41309__$1,(9),inst_41286);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__14778__auto__ = null;
var fluree$db$graphdb$state_machine__14778__auto____0 = (function (){
var statearr_41338 = [null,null,null,null,null,null,null,null,null];
(statearr_41338[(0)] = fluree$db$graphdb$state_machine__14778__auto__);

(statearr_41338[(1)] = (1));

return statearr_41338;
});
var fluree$db$graphdb$state_machine__14778__auto____1 = (function (state_41309){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41309);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41339){var ex__14781__auto__ = e41339;
var statearr_41340_41512 = state_41309;
(statearr_41340_41512[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41309[(4)]))){
var statearr_41341_41513 = state_41309;
(statearr_41341_41513[(1)] = cljs.core.first((state_41309[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41514 = state_41309;
state_41309 = G__41514;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__14778__auto__ = function(state_41309){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__14778__auto____1.call(this,state_41309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__14778__auto____0;
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__14778__auto____1;
return fluree$db$graphdb$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41342 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41342[(6)] = c__14852__auto__);

return statearr_41342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41375){
var state_val_41376 = (state_41375[(1)]);
if((state_val_41376 === (7))){
var state_41375__$1 = state_41375;
var statearr_41377_41515 = state_41375__$1;
(statearr_41377_41515[(2)] = null);

(statearr_41377_41515[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (1))){
var state_41375__$1 = state_41375;
var statearr_41378_41516 = state_41375__$1;
(statearr_41378_41516[(2)] = null);

(statearr_41378_41516[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (4))){
var inst_41343 = (state_41375[(2)]);
var state_41375__$1 = state_41375;
var statearr_41379_41517 = state_41375__$1;
(statearr_41379_41517[(2)] = inst_41343);

(statearr_41379_41517[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (6))){
var inst_41358 = (state_41375[(7)]);
var inst_41357 = (state_41375[(2)]);
var inst_41358__$1 = fluree.db.util.async.throw_err(inst_41357);
var inst_41359 = (inst_41358__$1 == null);
var state_41375__$1 = (function (){var statearr_41380 = state_41375;
(statearr_41380[(7)] = inst_41358__$1);

return statearr_41380;
})();
if(cljs.core.truth_(inst_41359)){
var statearr_41381_41518 = state_41375__$1;
(statearr_41381_41518[(1)] = (7));

} else {
var statearr_41382_41519 = state_41375__$1;
(statearr_41382_41519[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (3))){
var inst_41373 = (state_41375[(2)]);
var state_41375__$1 = state_41375;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41375__$1,inst_41373);
} else {
if((state_val_41376 === (12))){
var inst_41370 = (state_41375[(2)]);
var _ = (function (){var statearr_41383 = state_41375;
(statearr_41383[(4)] = cljs.core.rest((state_41375[(4)])));

return statearr_41383;
})();
var state_41375__$1 = state_41375;
var statearr_41384_41520 = state_41375__$1;
(statearr_41384_41520[(2)] = inst_41370);

(statearr_41384_41520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (2))){
var _ = (function (){var statearr_41385 = state_41375;
(statearr_41385[(4)] = cljs.core.cons((5),(state_41375[(4)])));

return statearr_41385;
})();
var inst_41349 = (30);
var inst_41351 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_41352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41353 = [inst_41349,tag_name];
var inst_41354 = (new cljs.core.PersistentVector(null,2,(5),inst_41352,inst_41353,null));
var inst_41355 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_41351,cljs.core.cst$kw$post,cljs.core._EQ_,inst_41354);
var state_41375__$1 = state_41375;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41375__$1,(6),inst_41355);
} else {
if((state_val_41376 === (11))){
var inst_41364 = (state_41375[(8)]);
var inst_41368 = inst_41364.s;
var state_41375__$1 = state_41375;
var statearr_41387_41521 = state_41375__$1;
(statearr_41387_41521[(2)] = inst_41368);

(statearr_41387_41521[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (9))){
var inst_41364 = (state_41375[(8)]);
var inst_41364__$1 = (state_41375[(2)]);
var inst_41365 = (inst_41364__$1 == null);
var state_41375__$1 = (function (){var statearr_41388 = state_41375;
(statearr_41388[(8)] = inst_41364__$1);

return statearr_41388;
})();
if(cljs.core.truth_(inst_41365)){
var statearr_41389_41522 = state_41375__$1;
(statearr_41389_41522[(1)] = (10));

} else {
var statearr_41390_41523 = state_41375__$1;
(statearr_41390_41523[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (5))){
var _ = (function (){var statearr_41391 = state_41375;
(statearr_41391[(4)] = cljs.core.rest((state_41375[(4)])));

return statearr_41391;
})();
var state_41375__$1 = state_41375;
var ex41386 = (state_41375__$1[(2)]);
var statearr_41392_41524 = state_41375__$1;
(statearr_41392_41524[(5)] = ex41386);


if((ex41386 instanceof Error)){
var statearr_41393_41525 = state_41375__$1;
(statearr_41393_41525[(1)] = (4));

(statearr_41393_41525[(5)] = null);

} else {
throw ex41386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (10))){
var state_41375__$1 = state_41375;
var statearr_41394_41526 = state_41375__$1;
(statearr_41394_41526[(2)] = null);

(statearr_41394_41526[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41376 === (8))){
var inst_41358 = (state_41375[(7)]);
var inst_41362 = cljs.core.first(inst_41358);
var state_41375__$1 = state_41375;
var statearr_41395_41527 = state_41375__$1;
(statearr_41395_41527[(2)] = inst_41362);

(statearr_41395_41527[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__14778__auto__ = null;
var fluree$db$graphdb$state_machine__14778__auto____0 = (function (){
var statearr_41396 = [null,null,null,null,null,null,null,null,null];
(statearr_41396[(0)] = fluree$db$graphdb$state_machine__14778__auto__);

(statearr_41396[(1)] = (1));

return statearr_41396;
});
var fluree$db$graphdb$state_machine__14778__auto____1 = (function (state_41375){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41375);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41397){var ex__14781__auto__ = e41397;
var statearr_41398_41528 = state_41375;
(statearr_41398_41528[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41375[(4)]))){
var statearr_41399_41529 = state_41375;
(statearr_41399_41529[(1)] = cljs.core.first((state_41375[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41530 = state_41375;
state_41375 = G__41530;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__14778__auto__ = function(state_41375){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__14778__auto____1.call(this,state_41375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__14778__auto____0;
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__14778__auto____1;
return fluree$db$graphdb$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41400 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41400[(6)] = c__14852__auto__);

return statearr_41400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_41435){
var state_val_41436 = (state_41435[(1)]);
if((state_val_41436 === (7))){
var inst_41414 = typeof pred === 'string';
var state_41435__$1 = state_41435;
if(cljs.core.truth_(inst_41414)){
var statearr_41437_41531 = state_41435__$1;
(statearr_41437_41531[(1)] = (10));

} else {
var statearr_41438_41532 = state_41435__$1;
(statearr_41438_41532[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (1))){
var state_41435__$1 = state_41435;
var statearr_41439_41533 = state_41435__$1;
(statearr_41439_41533[(2)] = null);

(statearr_41439_41533[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (4))){
var inst_41401 = (state_41435[(2)]);
var state_41435__$1 = state_41435;
var statearr_41440_41534 = state_41435__$1;
(statearr_41440_41534[(2)] = inst_41401);

(statearr_41440_41534[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (15))){
var inst_41428 = (state_41435[(2)]);
var state_41435__$1 = state_41435;
var statearr_41441_41535 = state_41435__$1;
(statearr_41441_41535[(2)] = inst_41428);

(statearr_41441_41535[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (13))){
var inst_41419 = (state_41435[(7)]);
var inst_41421 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41419),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_41422 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_41421);
var state_41435__$1 = state_41435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41435__$1,(16),inst_41422);
} else {
if((state_val_41436 === (6))){
var inst_41409 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_41435__$1 = state_41435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41435__$1,(9),inst_41409);
} else {
if((state_val_41436 === (3))){
var inst_41433 = (state_41435[(2)]);
var state_41435__$1 = state_41435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41435__$1,inst_41433);
} else {
if((state_val_41436 === (12))){
var inst_41419 = (state_41435[(7)]);
var inst_41419__$1 = (state_41435[(2)]);
var state_41435__$1 = (function (){var statearr_41442 = state_41435;
(statearr_41442[(7)] = inst_41419__$1);

return statearr_41442;
})();
if(cljs.core.truth_(inst_41419__$1)){
var statearr_41443_41536 = state_41435__$1;
(statearr_41443_41536[(1)] = (13));

} else {
var statearr_41444_41537 = state_41435__$1;
(statearr_41444_41537[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (2))){
var _ = (function (){var statearr_41445 = state_41435;
(statearr_41445[(4)] = cljs.core.cons((5),(state_41435[(4)])));

return statearr_41445;
})();
var inst_41407 = clojure.string.includes_QMARK_(tag_name,"/");
var state_41435__$1 = state_41435;
if(inst_41407){
var statearr_41446_41538 = state_41435__$1;
(statearr_41446_41538[(1)] = (6));

} else {
var statearr_41447_41539 = state_41435__$1;
(statearr_41447_41539[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (11))){
var inst_41417 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_41435__$1 = state_41435;
var statearr_41449_41540 = state_41435__$1;
(statearr_41449_41540[(2)] = inst_41417);

(statearr_41449_41540[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (9))){
var inst_41411 = (state_41435[(2)]);
var inst_41412 = fluree.db.util.async.throw_err(inst_41411);
var state_41435__$1 = state_41435;
var statearr_41450_41541 = state_41435__$1;
(statearr_41450_41541[(2)] = inst_41412);

(statearr_41450_41541[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (5))){
var _ = (function (){var statearr_41451 = state_41435;
(statearr_41451[(4)] = cljs.core.rest((state_41435[(4)])));

return statearr_41451;
})();
var state_41435__$1 = state_41435;
var ex41448 = (state_41435__$1[(2)]);
var statearr_41452_41542 = state_41435__$1;
(statearr_41452_41542[(5)] = ex41448);


if((ex41448 instanceof Error)){
var statearr_41453_41543 = state_41435__$1;
(statearr_41453_41543[(1)] = (4));

(statearr_41453_41543[(5)] = null);

} else {
throw ex41448;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (14))){
var state_41435__$1 = state_41435;
var statearr_41454_41544 = state_41435__$1;
(statearr_41454_41544[(2)] = null);

(statearr_41454_41544[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (16))){
var inst_41424 = (state_41435[(2)]);
var inst_41425 = fluree.db.util.async.throw_err(inst_41424);
var state_41435__$1 = state_41435;
var statearr_41455_41545 = state_41435__$1;
(statearr_41455_41545[(2)] = inst_41425);

(statearr_41455_41545[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (10))){
var state_41435__$1 = state_41435;
var statearr_41456_41546 = state_41435__$1;
(statearr_41456_41546[(2)] = pred);

(statearr_41456_41546[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41436 === (8))){
var inst_41430 = (state_41435[(2)]);
var _ = (function (){var statearr_41457 = state_41435;
(statearr_41457[(4)] = cljs.core.rest((state_41435[(4)])));

return statearr_41457;
})();
var state_41435__$1 = state_41435;
var statearr_41458_41547 = state_41435__$1;
(statearr_41458_41547[(2)] = inst_41430);

(statearr_41458_41547[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__14778__auto__ = null;
var fluree$db$graphdb$state_machine__14778__auto____0 = (function (){
var statearr_41459 = [null,null,null,null,null,null,null,null];
(statearr_41459[(0)] = fluree$db$graphdb$state_machine__14778__auto__);

(statearr_41459[(1)] = (1));

return statearr_41459;
});
var fluree$db$graphdb$state_machine__14778__auto____1 = (function (state_41435){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_41435);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e41460){var ex__14781__auto__ = e41460;
var statearr_41461_41548 = state_41435;
(statearr_41461_41548[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_41435[(4)]))){
var statearr_41462_41549 = state_41435;
(statearr_41462_41549[(1)] = cljs.core.first((state_41435[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__41550 = state_41435;
state_41435 = G__41550;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__14778__auto__ = function(state_41435){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__14778__auto____1.call(this,state_41435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__14778__auto____0;
fluree$db$graphdb$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__14778__auto____1;
return fluree$db$graphdb$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_41463 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_41463[(6)] = c__14852__auto__);

return statearr_41463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__41132){
var extmap__4512__auto__ = (function (){var G__41464 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__41132,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__41132)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__41464);
} else {
return G__41464;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__41132),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__41132),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
