// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k38387,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__38391 = k38387;
var G__38391__$1 = (((G__38391 instanceof cljs.core.Keyword))?G__38391.fqn:null);
switch (G__38391__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k38387,else__4475__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__38392){
var vec__38393 = p__38392;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38393,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38393,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38386){
var self__ = this;
var G__38386__$1 = this;
return (new cljs.core.RecordIter((0),G__38386__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__38396 = (function (coll__4469__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__38396(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38388,other38389){
var self__ = this;
var this38388__$1 = this;
return (((!((other38389 == null)))) && ((((this38388__$1.constructor === other38389.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38388__$1.index_type,other38389.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38388__$1.comparator,other38389.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38388__$1.historyComparator,other38389.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38388__$1.__extmap,other38389.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k38387){
var self__ = this;
var this__4479__auto____$1 = this;
var G__38397 = k38387;
var G__38397__$1 = (((G__38397 instanceof cljs.core.Keyword))?G__38397.fqn:null);
switch (G__38397__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k38387);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__38386){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__38398 = cljs.core.keyword_identical_QMARK_;
var expr__38399 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__38401 = cljs.core.cst$kw$index_DASH_type;
var G__38402 = expr__38399;
return (pred__38398.cljs$core$IFn$_invoke$arity$2 ? pred__38398.cljs$core$IFn$_invoke$arity$2(G__38401,G__38402) : pred__38398.call(null,G__38401,G__38402));
})())){
return (new fluree.db.index.IndexConfig(G__38386,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38403 = cljs.core.cst$kw$comparator;
var G__38404 = expr__38399;
return (pred__38398.cljs$core$IFn$_invoke$arity$2 ? pred__38398.cljs$core$IFn$_invoke$arity$2(G__38403,G__38404) : pred__38398.call(null,G__38403,G__38404));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__38386,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38405 = cljs.core.cst$kw$historyComparator;
var G__38406 = expr__38399;
return (pred__38398.cljs$core$IFn$_invoke$arity$2 ? pred__38398.cljs$core$IFn$_invoke$arity$2(G__38405,G__38406) : pred__38398.call(null,G__38405,G__38406));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__38386,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__38386),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__38386){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__38386,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__38390){
var extmap__4512__auto__ = (function (){var G__38407 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__38390,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__38390)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__38407);
} else {
return G__38407;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__38390),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__38390),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__38390),null,cljs.core.not_empty(extmap__4512__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k38411,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__38415 = k38411;
var G__38415__$1 = (((G__38415 instanceof cljs.core.Keyword))?G__38415.fqn:null);
switch (G__38415__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k38411,else__4475__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__38416){
var vec__38417 = p__38416;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38417,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38417,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38410){
var self__ = this;
var G__38410__$1 = this;
return (new cljs.core.RecordIter((0),G__38410__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38421){
var state_val_38422 = (state_38421[(1)]);
if((state_val_38422 === (1))){
var state_38421__$1 = state_38421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38421__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__14778__auto__ = null;
var fluree$db$index$state_machine__14778__auto____0 = (function (){
var statearr_38423 = [null,null,null,null,null,null,null];
(statearr_38423[(0)] = fluree$db$index$state_machine__14778__auto__);

(statearr_38423[(1)] = (1));

return statearr_38423;
});
var fluree$db$index$state_machine__14778__auto____1 = (function (state_38421){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38421);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38424){var ex__14781__auto__ = e38424;
var statearr_38425_38537 = state_38421;
(statearr_38425_38537[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38421[(4)]))){
var statearr_38426_38538 = state_38421;
(statearr_38426_38538[(1)] = cljs.core.first((state_38421[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38539 = state_38421;
state_38421 = G__38539;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$index$state_machine__14778__auto__ = function(state_38421){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__14778__auto____1.call(this,state_38421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__14778__auto____0;
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__14778__auto____1;
return fluree$db$index$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38427 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38427[(6)] = c__14852__auto__);

return statearr_38427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38452){
var state_val_38453 = (state_38452[(1)]);
if((state_val_38453 === (7))){
var inst_38434 = (state_38452[(7)]);
var inst_38438 = fluree.db.dbproto._resolve(inst_38434);
var state_38452__$1 = state_38452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38452__$1,(10),inst_38438);
} else {
if((state_val_38453 === (1))){
var state_38452__$1 = state_38452;
var statearr_38454_38540 = state_38452__$1;
(statearr_38454_38540[(2)] = null);

(statearr_38454_38540[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (4))){
var inst_38428 = (state_38452[(2)]);
var state_38452__$1 = state_38452;
var statearr_38455_38541 = state_38452__$1;
(statearr_38455_38541[(2)] = inst_38428);

(statearr_38455_38541[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (6))){
var inst_38434 = (state_38452[(7)]);
var state_38452__$1 = state_38452;
var statearr_38456_38542 = state_38452__$1;
(statearr_38456_38542[(2)] = inst_38434);

(statearr_38456_38542[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (3))){
var inst_38450 = (state_38452[(2)]);
var state_38452__$1 = state_38452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38452__$1,inst_38450);
} else {
if((state_val_38453 === (2))){
var inst_38434 = (state_38452[(7)]);
var _ = (function (){var statearr_38458 = state_38452;
(statearr_38458[(4)] = cljs.core.cons((5),(state_38452[(4)])));

return statearr_38458;
})();
var inst_38434__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_38435 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_38434__$1);
var state_38452__$1 = (function (){var statearr_38459 = state_38452;
(statearr_38459[(7)] = inst_38434__$1);

return statearr_38459;
})();
if(cljs.core.truth_(inst_38435)){
var statearr_38460_38543 = state_38452__$1;
(statearr_38460_38543[(1)] = (6));

} else {
var statearr_38461_38544 = state_38452__$1;
(statearr_38461_38544[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (9))){
var inst_38444 = (state_38452[(2)]);
var inst_38445 = fluree.db.util.async.throw_err(inst_38444);
var state_38452__$1 = state_38452;
var statearr_38462_38545 = state_38452__$1;
(statearr_38462_38545[(2)] = inst_38445);

(statearr_38462_38545[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (5))){
var _ = (function (){var statearr_38463 = state_38452;
(statearr_38463[(4)] = cljs.core.rest((state_38452[(4)])));

return statearr_38463;
})();
var state_38452__$1 = state_38452;
var ex38457 = (state_38452__$1[(2)]);
var statearr_38464_38546 = state_38452__$1;
(statearr_38464_38546[(5)] = ex38457);


if((ex38457 instanceof Error)){
var statearr_38465_38547 = state_38452__$1;
(statearr_38465_38547[(1)] = (4));

(statearr_38465_38547[(5)] = null);

} else {
throw ex38457;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38453 === (10))){
var inst_38440 = (state_38452[(2)]);
var inst_38441 = fluree.db.util.async.throw_err(inst_38440);
var inst_38442 = fluree.db.dbproto._lookup_leaf(inst_38441,flake);
var state_38452__$1 = state_38452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38452__$1,(9),inst_38442);
} else {
if((state_val_38453 === (8))){
var inst_38447 = (state_38452[(2)]);
var _ = (function (){var statearr_38466 = state_38452;
(statearr_38466[(4)] = cljs.core.rest((state_38452[(4)])));

return statearr_38466;
})();
var state_38452__$1 = state_38452;
var statearr_38467_38548 = state_38452__$1;
(statearr_38467_38548[(2)] = inst_38447);

(statearr_38467_38548[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__14778__auto__ = null;
var fluree$db$index$state_machine__14778__auto____0 = (function (){
var statearr_38468 = [null,null,null,null,null,null,null,null];
(statearr_38468[(0)] = fluree$db$index$state_machine__14778__auto__);

(statearr_38468[(1)] = (1));

return statearr_38468;
});
var fluree$db$index$state_machine__14778__auto____1 = (function (state_38452){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38452);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38469){var ex__14781__auto__ = e38469;
var statearr_38470_38549 = state_38452;
(statearr_38470_38549[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38452[(4)]))){
var statearr_38471_38550 = state_38452;
(statearr_38471_38550[(1)] = cljs.core.first((state_38452[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38551 = state_38452;
state_38452 = G__38551;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$index$state_machine__14778__auto__ = function(state_38452){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__14778__auto____1.call(this,state_38452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__14778__auto____0;
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__14778__auto____1;
return fluree$db$index$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38472 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38472[(6)] = c__14852__auto__);

return statearr_38472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38497){
var state_val_38498 = (state_38497[(1)]);
if((state_val_38498 === (7))){
var inst_38479 = (state_38497[(7)]);
var inst_38483 = fluree.db.dbproto._resolve(inst_38479);
var state_38497__$1 = state_38497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38497__$1,(10),inst_38483);
} else {
if((state_val_38498 === (1))){
var state_38497__$1 = state_38497;
var statearr_38499_38552 = state_38497__$1;
(statearr_38499_38552[(2)] = null);

(statearr_38499_38552[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38498 === (4))){
var inst_38473 = (state_38497[(2)]);
var state_38497__$1 = state_38497;
var statearr_38500_38553 = state_38497__$1;
(statearr_38500_38553[(2)] = inst_38473);

(statearr_38500_38553[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38498 === (6))){
var inst_38479 = (state_38497[(7)]);
var state_38497__$1 = state_38497;
var statearr_38501_38554 = state_38497__$1;
(statearr_38501_38554[(2)] = inst_38479);

(statearr_38501_38554[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38498 === (3))){
var inst_38495 = (state_38497[(2)]);
var state_38497__$1 = state_38497;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38497__$1,inst_38495);
} else {
if((state_val_38498 === (2))){
var inst_38479 = (state_38497[(7)]);
var _ = (function (){var statearr_38503 = state_38497;
(statearr_38503[(4)] = cljs.core.cons((5),(state_38497[(4)])));

return statearr_38503;
})();
var inst_38479__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_38480 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_38479__$1);
var state_38497__$1 = (function (){var statearr_38504 = state_38497;
(statearr_38504[(7)] = inst_38479__$1);

return statearr_38504;
})();
if(cljs.core.truth_(inst_38480)){
var statearr_38505_38555 = state_38497__$1;
(statearr_38505_38555[(1)] = (6));

} else {
var statearr_38506_38556 = state_38497__$1;
(statearr_38506_38556[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38498 === (9))){
var inst_38489 = (state_38497[(2)]);
var inst_38490 = fluree.db.util.async.throw_err(inst_38489);
var state_38497__$1 = state_38497;
var statearr_38507_38557 = state_38497__$1;
(statearr_38507_38557[(2)] = inst_38490);

(statearr_38507_38557[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38498 === (5))){
var _ = (function (){var statearr_38508 = state_38497;
(statearr_38508[(4)] = cljs.core.rest((state_38497[(4)])));

return statearr_38508;
})();
var state_38497__$1 = state_38497;
var ex38502 = (state_38497__$1[(2)]);
var statearr_38509_38558 = state_38497__$1;
(statearr_38509_38558[(5)] = ex38502);


if((ex38502 instanceof Error)){
var statearr_38510_38559 = state_38497__$1;
(statearr_38510_38559[(1)] = (4));

(statearr_38510_38559[(5)] = null);

} else {
throw ex38502;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38498 === (10))){
var inst_38485 = (state_38497[(2)]);
var inst_38486 = fluree.db.util.async.throw_err(inst_38485);
var inst_38487 = fluree.db.dbproto._lookup_leaf_after(inst_38486,flake);
var state_38497__$1 = state_38497;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38497__$1,(9),inst_38487);
} else {
if((state_val_38498 === (8))){
var inst_38492 = (state_38497[(2)]);
var _ = (function (){var statearr_38511 = state_38497;
(statearr_38511[(4)] = cljs.core.rest((state_38497[(4)])));

return statearr_38511;
})();
var state_38497__$1 = state_38497;
var statearr_38512_38560 = state_38497__$1;
(statearr_38512_38560[(2)] = inst_38492);

(statearr_38512_38560[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__14778__auto__ = null;
var fluree$db$index$state_machine__14778__auto____0 = (function (){
var statearr_38513 = [null,null,null,null,null,null,null,null];
(statearr_38513[(0)] = fluree$db$index$state_machine__14778__auto__);

(statearr_38513[(1)] = (1));

return statearr_38513;
});
var fluree$db$index$state_machine__14778__auto____1 = (function (state_38497){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38497);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38514){var ex__14781__auto__ = e38514;
var statearr_38515_38561 = state_38497;
(statearr_38515_38561[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38497[(4)]))){
var statearr_38516_38562 = state_38497;
(statearr_38516_38562[(1)] = cljs.core.first((state_38497[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38563 = state_38497;
state_38497 = G__38563;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$index$state_machine__14778__auto__ = function(state_38497){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__14778__auto____1.call(this,state_38497);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__14778__auto____0;
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__14778__auto____1;
return fluree$db$index$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38517 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38517[(6)] = c__14852__auto__);

return statearr_38517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__38518 = (function (coll__4469__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__38518(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38412,other38413){
var self__ = this;
var this38412__$1 = this;
return (((!((other38413 == null)))) && ((((this38412__$1.constructor === other38413.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38412__$1.block,other38413.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38412__$1.t,other38413.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38412__$1.rhs,other38413.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38412__$1.children,other38413.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38412__$1.config,other38413.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38412__$1.leftmost_QMARK_,other38413.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38412__$1.__extmap,other38413.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k38411){
var self__ = this;
var this__4479__auto____$1 = this;
var G__38519 = k38411;
var G__38519__$1 = (((G__38519 instanceof cljs.core.Keyword))?G__38519.fqn:null);
switch (G__38519__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k38411);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__38410){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__38520 = cljs.core.keyword_identical_QMARK_;
var expr__38521 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__38523 = cljs.core.cst$kw$block;
var G__38524 = expr__38521;
return (pred__38520.cljs$core$IFn$_invoke$arity$2 ? pred__38520.cljs$core$IFn$_invoke$arity$2(G__38523,G__38524) : pred__38520.call(null,G__38523,G__38524));
})())){
return (new fluree.db.index.IndexNode(G__38410,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38525 = cljs.core.cst$kw$t;
var G__38526 = expr__38521;
return (pred__38520.cljs$core$IFn$_invoke$arity$2 ? pred__38520.cljs$core$IFn$_invoke$arity$2(G__38525,G__38526) : pred__38520.call(null,G__38525,G__38526));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__38410,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38527 = cljs.core.cst$kw$rhs;
var G__38528 = expr__38521;
return (pred__38520.cljs$core$IFn$_invoke$arity$2 ? pred__38520.cljs$core$IFn$_invoke$arity$2(G__38527,G__38528) : pred__38520.call(null,G__38527,G__38528));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__38410,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38529 = cljs.core.cst$kw$children;
var G__38530 = expr__38521;
return (pred__38520.cljs$core$IFn$_invoke$arity$2 ? pred__38520.cljs$core$IFn$_invoke$arity$2(G__38529,G__38530) : pred__38520.call(null,G__38529,G__38530));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__38410,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38531 = cljs.core.cst$kw$config;
var G__38532 = expr__38521;
return (pred__38520.cljs$core$IFn$_invoke$arity$2 ? pred__38520.cljs$core$IFn$_invoke$arity$2(G__38531,G__38532) : pred__38520.call(null,G__38531,G__38532));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__38410,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38533 = cljs.core.cst$kw$leftmost_QMARK_;
var G__38534 = expr__38521;
return (pred__38520.cljs$core$IFn$_invoke$arity$2 ? pred__38520.cljs$core$IFn$_invoke$arity$2(G__38533,G__38534) : pred__38520.call(null,G__38533,G__38534));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__38410,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__38410),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__38410){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__38410,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__38414){
var extmap__4512__auto__ = (function (){var G__38535 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__38414,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__38414)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__38535);
} else {
return G__38535;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__38414),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__38414),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__38414),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__38414),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__38414),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__38414),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k38566,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__38570 = k38566;
var G__38570__$1 = (((G__38570 instanceof cljs.core.Keyword))?G__38570.fqn:null);
switch (G__38570__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k38566,else__4475__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__38571){
var vec__38572 = p__38571;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38572,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38572,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38565){
var self__ = this;
var G__38565__$1 = this;
return (new cljs.core.RecordIter((0),G__38565__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38576){
var state_val_38577 = (state_38576[(1)]);
if((state_val_38577 === (1))){
var state_38576__$1 = state_38576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38576__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__14778__auto__ = null;
var fluree$db$index$state_machine__14778__auto____0 = (function (){
var statearr_38578 = [null,null,null,null,null,null,null];
(statearr_38578[(0)] = fluree$db$index$state_machine__14778__auto__);

(statearr_38578[(1)] = (1));

return statearr_38578;
});
var fluree$db$index$state_machine__14778__auto____1 = (function (state_38576){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38576);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38579){var ex__14781__auto__ = e38579;
var statearr_38580_38612 = state_38576;
(statearr_38580_38612[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38576[(4)]))){
var statearr_38581_38613 = state_38576;
(statearr_38581_38613[(1)] = cljs.core.first((state_38576[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38614 = state_38576;
state_38576 = G__38614;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$index$state_machine__14778__auto__ = function(state_38576){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__14778__auto____1.call(this,state_38576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__14778__auto____0;
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__14778__auto____1;
return fluree$db$index$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38582 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38582[(6)] = c__14852__auto__);

return statearr_38582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38588){
var state_val_38589 = (state_38588[(1)]);
if((state_val_38589 === (1))){
var inst_38583 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38584 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_38585 = cljs.core.PersistentHashMap.fromArrays(inst_38583,inst_38584);
var inst_38586 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_38585);
var state_38588__$1 = state_38588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38588__$1,inst_38586);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__14778__auto__ = null;
var fluree$db$index$state_machine__14778__auto____0 = (function (){
var statearr_38590 = [null,null,null,null,null,null,null];
(statearr_38590[(0)] = fluree$db$index$state_machine__14778__auto__);

(statearr_38590[(1)] = (1));

return statearr_38590;
});
var fluree$db$index$state_machine__14778__auto____1 = (function (state_38588){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38588);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38591){var ex__14781__auto__ = e38591;
var statearr_38592_38615 = state_38588;
(statearr_38592_38615[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38588[(4)]))){
var statearr_38593_38616 = state_38588;
(statearr_38593_38616[(1)] = cljs.core.first((state_38588[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38617 = state_38588;
state_38588 = G__38617;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$index$state_machine__14778__auto__ = function(state_38588){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__14778__auto____1.call(this,state_38588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__14778__auto____0;
fluree$db$index$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__14778__auto____1;
return fluree$db$index$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38594 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38594[(6)] = c__14852__auto__);

return statearr_38594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__38595 = (function (coll__4469__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__38595(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38567,other38568){
var self__ = this;
var this38567__$1 = this;
return (((!((other38568 == null)))) && ((((this38567__$1.constructor === other38568.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38567__$1.block,other38568.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38567__$1.t,other38568.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38567__$1.flakes,other38568.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38567__$1.rhs,other38568.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38567__$1.config,other38568.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this38567__$1.__extmap,other38568.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k38566){
var self__ = this;
var this__4479__auto____$1 = this;
var G__38596 = k38566;
var G__38596__$1 = (((G__38596 instanceof cljs.core.Keyword))?G__38596.fqn:null);
switch (G__38596__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k38566);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__38565){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__38597 = cljs.core.keyword_identical_QMARK_;
var expr__38598 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__38600 = cljs.core.cst$kw$block;
var G__38601 = expr__38598;
return (pred__38597.cljs$core$IFn$_invoke$arity$2 ? pred__38597.cljs$core$IFn$_invoke$arity$2(G__38600,G__38601) : pred__38597.call(null,G__38600,G__38601));
})())){
return (new fluree.db.index.DataNode(G__38565,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38602 = cljs.core.cst$kw$t;
var G__38603 = expr__38598;
return (pred__38597.cljs$core$IFn$_invoke$arity$2 ? pred__38597.cljs$core$IFn$_invoke$arity$2(G__38602,G__38603) : pred__38597.call(null,G__38602,G__38603));
})())){
return (new fluree.db.index.DataNode(self__.block,G__38565,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38604 = cljs.core.cst$kw$flakes;
var G__38605 = expr__38598;
return (pred__38597.cljs$core$IFn$_invoke$arity$2 ? pred__38597.cljs$core$IFn$_invoke$arity$2(G__38604,G__38605) : pred__38597.call(null,G__38604,G__38605));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__38565,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38606 = cljs.core.cst$kw$rhs;
var G__38607 = expr__38598;
return (pred__38597.cljs$core$IFn$_invoke$arity$2 ? pred__38597.cljs$core$IFn$_invoke$arity$2(G__38606,G__38607) : pred__38597.call(null,G__38606,G__38607));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__38565,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__38608 = cljs.core.cst$kw$config;
var G__38609 = expr__38598;
return (pred__38597.cljs$core$IFn$_invoke$arity$2 ? pred__38597.cljs$core$IFn$_invoke$arity$2(G__38608,G__38609) : pred__38597.call(null,G__38608,G__38609));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__38565,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__38565),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__38565){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__38565,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__38569){
var extmap__4512__auto__ = (function (){var G__38610 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__38569,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__38569)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__38610);
} else {
return G__38610;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__38569),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__38569),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__38569),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__38569),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__38569),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
