// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e31328){var e = e31328;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__31329_SHARP_){
var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__31329_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__31329_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__31329_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__31329_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31330_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31330_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31331_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31331_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4221__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4223__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__31336 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31336,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31336,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31332_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31332_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4221__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4221__auto__;
}
})())){
var vec__31339 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31339,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31339,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4223__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31333_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31333_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31334_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31334_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31335_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31335_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31342_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__31342_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (add_amount > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fuel;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4221__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__31343 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__31343) : intersecting_vars.call(null,G__31343));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__31346,optional_QMARK_,fuel,max_fuel){
var map__31347 = p__31346;
var map__31347__$1 = cljs.core.__destructure_map(map__31347);
var res = map__31347__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31347__$1,cljs.core.cst$kw$vars);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31413){
var state_val_31414 = (state_31413[(1)]);
if((state_val_31414 === (7))){
var inst_31402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31403 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_31404 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31403,clause);
var inst_31405 = [null,inst_31404];
var inst_31406 = (new cljs.core.PersistentVector(null,2,(5),inst_31402,inst_31405,null));
var state_31413__$1 = state_31413;
var statearr_31415_31443 = state_31413__$1;
(statearr_31415_31443[(2)] = inst_31406);

(statearr_31415_31443[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (1))){
var state_31413__$1 = state_31413;
var statearr_31416_31444 = state_31413__$1;
(statearr_31416_31444[(2)] = null);

(statearr_31416_31444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (4))){
var inst_31348 = (state_31413[(2)]);
var state_31413__$1 = state_31413;
var statearr_31417_31445 = state_31413__$1;
(statearr_31417_31445[(2)] = inst_31348);

(statearr_31417_31445[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (15))){
var inst_31391 = (state_31413[(2)]);
var inst_31392 = fluree.db.util.async.throw_err(inst_31391);
var inst_31393 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_31392);
var inst_31394 = cljs.core.count(inst_31393);
var inst_31395 = fluree.db.query.analytical.add_fuel(inst_31394,fuel,max_fuel);
var inst_31396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31397 = [inst_31392,r];
var inst_31398 = (new cljs.core.PersistentVector(null,2,(5),inst_31396,inst_31397,null));
var state_31413__$1 = (function (){var statearr_31418 = state_31413;
(statearr_31418[(7)] = inst_31395);

return statearr_31418;
})();
var statearr_31419_31446 = state_31413__$1;
(statearr_31419_31446[(2)] = inst_31398);

(statearr_31419_31446[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (13))){
var inst_31357 = (state_31413[(8)]);
var inst_31370 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_31371 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_31370);
var inst_31372 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_31357);
var inst_31373 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31372);
var inst_31374 = cljs.core.set(inst_31373);
var inst_31375 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_31371);
var inst_31376 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31375);
var inst_31377 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31374,inst_31376);
var inst_31378 = (function (){var all_wd = inst_31357;
var optional = inst_31371;
var all_wd_vars = inst_31374;
var all_vars = inst_31377;
return (function (p1__31344_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__31344_SHARP_) : all_vars.call(null,p1__31344_SHARP_));
});
})();
var inst_31379 = cljs.core.keys(vars);
var inst_31380 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31378,inst_31379);
var inst_31381 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_31380);
var inst_31382 = cljs.core.set(inst_31381);
var inst_31383 = (function (){var all_wd = inst_31357;
var optional = inst_31371;
var all_wd_vars = inst_31374;
var all_vars = inst_31377;
var intersecting_vars = inst_31382;
return (function (p1__31345_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__31345_SHARP_);
});
})();
var inst_31384 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31383,inst_31357);
var inst_31385 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_31384);
var inst_31386 = fluree.db.query.analytical.select_from_tuples(inst_31385,res);
var inst_31387 = fluree.db.query.analytical.replace_vars_wikidata(inst_31357,inst_31382,vars);
var inst_31388 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_31382,inst_31377);
var inst_31389 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_31387,inst_31385,inst_31386,inst_31388,inst_31371);
var state_31413__$1 = state_31413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31413__$1,(15),inst_31389);
} else {
if((state_val_31414 === (6))){
var inst_31358 = (state_31413[(9)]);
var inst_31356 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_31357 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_31356);
var inst_31358__$1 = optional_QMARK_;
var state_31413__$1 = (function (){var statearr_31420 = state_31413;
(statearr_31420[(8)] = inst_31357);

(statearr_31420[(9)] = inst_31358__$1);

return statearr_31420;
})();
if(cljs.core.truth_(inst_31358__$1)){
var statearr_31421_31447 = state_31413__$1;
(statearr_31421_31447[(1)] = (9));

} else {
var statearr_31422_31448 = state_31413__$1;
(statearr_31422_31448[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (3))){
var inst_31411 = (state_31413[(2)]);
var state_31413__$1 = state_31413;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31413__$1,inst_31411);
} else {
if((state_val_31414 === (12))){
var inst_31366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31367 = [null,r];
var inst_31368 = (new cljs.core.PersistentVector(null,2,(5),inst_31366,inst_31367,null));
var state_31413__$1 = state_31413;
var statearr_31423_31449 = state_31413__$1;
(statearr_31423_31449[(2)] = inst_31368);

(statearr_31423_31449[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (2))){
var _ = (function (){var statearr_31424 = state_31413;
(statearr_31424[(4)] = cljs.core.cons((5),(state_31413[(4)])));

return statearr_31424;
})();
var inst_31354 = (r == null);
var state_31413__$1 = state_31413;
if(cljs.core.truth_(inst_31354)){
var statearr_31425_31450 = state_31413__$1;
(statearr_31425_31450[(1)] = (6));

} else {
var statearr_31426_31451 = state_31413__$1;
(statearr_31426_31451[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (11))){
var inst_31364 = (state_31413[(2)]);
var state_31413__$1 = state_31413;
if(cljs.core.truth_(inst_31364)){
var statearr_31428_31452 = state_31413__$1;
(statearr_31428_31452[(1)] = (12));

} else {
var statearr_31429_31453 = state_31413__$1;
(statearr_31429_31453[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (9))){
var inst_31357 = (state_31413[(8)]);
var inst_31360 = cljs.core.empty_QMARK_(inst_31357);
var inst_31361 = (!(inst_31360));
var state_31413__$1 = state_31413;
var statearr_31430_31454 = state_31413__$1;
(statearr_31430_31454[(2)] = inst_31361);

(statearr_31430_31454[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (5))){
var _ = (function (){var statearr_31431 = state_31413;
(statearr_31431[(4)] = cljs.core.rest((state_31413[(4)])));

return statearr_31431;
})();
var state_31413__$1 = state_31413;
var ex31427 = (state_31413__$1[(2)]);
var statearr_31432_31455 = state_31413__$1;
(statearr_31432_31455[(5)] = ex31427);


if((ex31427 instanceof Error)){
var statearr_31433_31456 = state_31413__$1;
(statearr_31433_31456[(1)] = (4));

(statearr_31433_31456[(5)] = null);

} else {
throw ex31427;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (14))){
var inst_31400 = (state_31413[(2)]);
var state_31413__$1 = state_31413;
var statearr_31434_31457 = state_31413__$1;
(statearr_31434_31457[(2)] = inst_31400);

(statearr_31434_31457[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (10))){
var inst_31358 = (state_31413[(9)]);
var state_31413__$1 = state_31413;
var statearr_31435_31458 = state_31413__$1;
(statearr_31435_31458[(2)] = inst_31358);

(statearr_31435_31458[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31414 === (8))){
var inst_31408 = (state_31413[(2)]);
var _ = (function (){var statearr_31436 = state_31413;
(statearr_31436[(4)] = cljs.core.rest((state_31413[(4)])));

return statearr_31436;
})();
var state_31413__$1 = state_31413;
var statearr_31437_31459 = state_31413__$1;
(statearr_31437_31459[(2)] = inst_31408);

(statearr_31437_31459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto____0 = (function (){
var statearr_31438 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31438[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto__);

(statearr_31438[(1)] = (1));

return statearr_31438;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto____1 = (function (state_31413){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31413);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31439){var ex__14781__auto__ = e31439;
var statearr_31440_31460 = state_31413;
(statearr_31440_31460[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31413[(4)]))){
var statearr_31441_31461 = state_31413;
(statearr_31441_31461[(1)] = cljs.core.first((state_31413[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31462 = state_31413;
state_31413 = G__31462;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto__ = function(state_31413){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto____1.call(this,state_31413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31442 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31442[(6)] = c__14852__auto__);

return statearr_31442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__31464 = arguments.length;
switch (G__31464) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31558){
var state_val_31559 = (state_31558[(1)]);
if((state_val_31559 === (7))){
var inst_31471 = (state_31558[(7)]);
var inst_31481 = clojure.string.starts_with_QMARK_(inst_31471,"$fdb");
var state_31558__$1 = state_31558;
if(inst_31481){
var statearr_31560_31609 = state_31558__$1;
(statearr_31560_31609[(1)] = (9));

} else {
var statearr_31561_31610 = state_31558__$1;
(statearr_31561_31610[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (20))){
var state_31558__$1 = state_31558;
var statearr_31562_31611 = state_31558__$1;
(statearr_31562_31611[(2)] = null);

(statearr_31562_31611[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (27))){
var inst_31521 = (state_31558[(8)]);
var state_31558__$1 = state_31558;
var statearr_31563_31612 = state_31558__$1;
(statearr_31563_31612[(2)] = inst_31521);

(statearr_31563_31612[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (1))){
var state_31558__$1 = state_31558;
var statearr_31564_31613 = state_31558__$1;
(statearr_31564_31613[(2)] = null);

(statearr_31564_31613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (24))){
var inst_31544 = (state_31558[(2)]);
var state_31558__$1 = state_31558;
var statearr_31565_31614 = state_31558__$1;
(statearr_31565_31614[(2)] = inst_31544);

(statearr_31565_31614[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (4))){
var inst_31465 = (state_31558[(2)]);
var state_31558__$1 = state_31558;
var statearr_31566_31615 = state_31558__$1;
(statearr_31566_31615[(2)] = inst_31465);

(statearr_31566_31615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (15))){
var inst_31488 = (state_31558[(9)]);
var inst_31494 = (state_31558[(2)]);
var inst_31495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31496 = cljs.core.PersistentVector.EMPTY;
var inst_31497 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31498 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31496,inst_31497);
var inst_31499 = [inst_31488,inst_31498];
var inst_31500 = (new cljs.core.PersistentVector(null,2,(5),inst_31495,inst_31499,null));
var state_31558__$1 = (function (){var statearr_31567 = state_31558;
(statearr_31567[(10)] = inst_31494);

return statearr_31567;
})();
var statearr_31568_31616 = state_31558__$1;
(statearr_31568_31616[(2)] = inst_31500);

(statearr_31568_31616[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (21))){
var inst_31547 = (state_31558[(2)]);
var state_31558__$1 = state_31558;
var statearr_31569_31617 = state_31558__$1;
(statearr_31569_31617[(2)] = inst_31547);

(statearr_31569_31617[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (13))){
var inst_31488 = (state_31558[(9)]);
var inst_31491 = (function(){throw inst_31488})();
var state_31558__$1 = state_31558;
var statearr_31570_31618 = state_31558__$1;
(statearr_31570_31618[(2)] = inst_31491);

(statearr_31570_31618[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (22))){
var inst_31512 = (state_31558[(11)]);
var inst_31510 = (state_31558[(12)]);
var inst_31514 = fluree.db.query.analytical.parse_block_from_source(inst_31510);
var inst_31515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31516 = [cljs.core.cst$kw$sources,inst_31512];
var inst_31517 = (new cljs.core.PersistentVector(null,2,(5),inst_31515,inst_31516,null));
var inst_31518 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_31517);
var state_31558__$1 = (function (){var statearr_31571 = state_31558;
(statearr_31571[(13)] = inst_31514);

return statearr_31571;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31558__$1,(25),inst_31518);
} else {
if((state_val_31559 === (29))){
var inst_31525 = (state_31558[(2)]);
var inst_31526 = fluree.db.util.async.throw_err(inst_31525);
var state_31558__$1 = state_31558;
var statearr_31572_31619 = state_31558__$1;
(statearr_31572_31619[(2)] = inst_31526);

(statearr_31572_31619[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (6))){
var inst_31474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31475 = cljs.core.PersistentVector.EMPTY;
var inst_31476 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31477 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31475,inst_31476);
var inst_31478 = [db,inst_31477];
var inst_31479 = (new cljs.core.PersistentVector(null,2,(5),inst_31474,inst_31478,null));
var state_31558__$1 = state_31558;
var statearr_31573_31620 = state_31558__$1;
(statearr_31573_31620[(2)] = inst_31479);

(statearr_31573_31620[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (28))){
var inst_31529 = (state_31558[(2)]);
var inst_31530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31531 = cljs.core.PersistentVector.EMPTY;
var inst_31532 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_31533 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31531,inst_31532);
var inst_31534 = [inst_31529,inst_31533];
var inst_31535 = (new cljs.core.PersistentVector(null,2,(5),inst_31530,inst_31534,null));
var state_31558__$1 = state_31558;
var statearr_31574_31621 = state_31558__$1;
(statearr_31574_31621[(2)] = inst_31535);

(statearr_31574_31621[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (25))){
var inst_31514 = (state_31558[(13)]);
var inst_31520 = (state_31558[(2)]);
var inst_31521 = fluree.db.util.async.throw_err(inst_31520);
var state_31558__$1 = (function (){var statearr_31575 = state_31558;
(statearr_31575[(8)] = inst_31521);

return statearr_31575;
})();
if(cljs.core.truth_(inst_31514)){
var statearr_31576_31622 = state_31558__$1;
(statearr_31576_31622[(1)] = (26));

} else {
var statearr_31577_31623 = state_31558__$1;
(statearr_31577_31623[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (17))){
var state_31558__$1 = state_31558;
var statearr_31578_31624 = state_31558__$1;
(statearr_31578_31624[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (3))){
var inst_31556 = (state_31558[(2)]);
var state_31558__$1 = state_31558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31558__$1,inst_31556);
} else {
if((state_val_31559 === (12))){
var inst_31488 = (state_31558[(9)]);
var inst_31487 = (state_31558[(2)]);
var inst_31488__$1 = fluree.db.util.async.throw_err(inst_31487);
var inst_31489 = fluree.db.util.core.exception_QMARK_(inst_31488__$1);
var state_31558__$1 = (function (){var statearr_31580 = state_31558;
(statearr_31580[(9)] = inst_31488__$1);

return statearr_31580;
})();
if(inst_31489){
var statearr_31581_31625 = state_31558__$1;
(statearr_31581_31625[(1)] = (13));

} else {
var statearr_31582_31626 = state_31558__$1;
(statearr_31582_31626[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (2))){
var inst_31471 = (state_31558[(7)]);
var _ = (function (){var statearr_31583 = state_31558;
(statearr_31583[(4)] = cljs.core.cons((5),(state_31558[(4)])));

return statearr_31583;
})();
var inst_31471__$1 = cljs.core.first(clause);
var inst_31472 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_31471__$1);
var state_31558__$1 = (function (){var statearr_31584 = state_31558;
(statearr_31584[(7)] = inst_31471__$1);

return statearr_31584;
})();
if(inst_31472){
var statearr_31585_31627 = state_31558__$1;
(statearr_31585_31627[(1)] = (6));

} else {
var statearr_31586_31628 = state_31558__$1;
(statearr_31586_31628[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (23))){
var inst_31471 = (state_31558[(7)]);
var inst_31537 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31471)," is not supported in Fluree"].join('');
var inst_31538 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31539 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_31540 = cljs.core.PersistentHashMap.fromArrays(inst_31538,inst_31539);
var inst_31541 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31537,inst_31540);
var inst_31542 = (function(){throw inst_31541})();
var state_31558__$1 = state_31558;
var statearr_31587_31629 = state_31558__$1;
(statearr_31587_31629[(2)] = inst_31542);

(statearr_31587_31629[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (19))){
var inst_31512 = (state_31558[(11)]);
var inst_31471 = (state_31558[(7)]);
var inst_31509 = fluree.db.query.analytical.isolate_source_name(inst_31471);
var inst_31510 = fluree.db.query.analytical.isolate_source_block(inst_31471);
var inst_31511 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_31509);
var inst_31512__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_31511);
var state_31558__$1 = (function (){var statearr_31588 = state_31558;
(statearr_31588[(11)] = inst_31512__$1);

(statearr_31588[(12)] = inst_31510);

return statearr_31588;
})();
if(cljs.core.truth_(inst_31512__$1)){
var statearr_31589_31630 = state_31558__$1;
(statearr_31589_31630[(1)] = (22));

} else {
var statearr_31590_31631 = state_31558__$1;
(statearr_31590_31631[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (11))){
var inst_31551 = (state_31558[(2)]);
var state_31558__$1 = state_31558;
var statearr_31592_31632 = state_31558__$1;
(statearr_31592_31632[(2)] = inst_31551);

(statearr_31592_31632[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (9))){
var inst_31471 = (state_31558[(7)]);
var inst_31483 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_31471,(4));
var inst_31484 = fluree.db.query.analytical.parse_block_from_source(inst_31483);
var inst_31485 = fluree.db.time_travel.as_of_block(db,inst_31484);
var state_31558__$1 = state_31558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31558__$1,(12),inst_31485);
} else {
if((state_val_31559 === (5))){
var _ = (function (){var statearr_31593 = state_31558;
(statearr_31593[(4)] = cljs.core.rest((state_31558[(4)])));

return statearr_31593;
})();
var state_31558__$1 = state_31558;
var ex31591 = (state_31558__$1[(2)]);
var statearr_31594_31633 = state_31558__$1;
(statearr_31594_31633[(5)] = ex31591);


if((ex31591 instanceof Error)){
var statearr_31595_31634 = state_31558__$1;
(statearr_31595_31634[(1)] = (4));

(statearr_31595_31634[(5)] = null);

} else {
throw ex31591;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (14))){
var state_31558__$1 = state_31558;
var statearr_31596_31635 = state_31558__$1;
(statearr_31596_31635[(2)] = null);

(statearr_31596_31635[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (26))){
var inst_31521 = (state_31558[(8)]);
var inst_31514 = (state_31558[(13)]);
var inst_31523 = fluree.db.time_travel.as_of_block(inst_31521,inst_31514);
var state_31558__$1 = state_31558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31558__$1,(29),inst_31523);
} else {
if((state_val_31559 === (16))){
var inst_31504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31505 = ["$wd",clause];
var inst_31506 = (new cljs.core.PersistentVector(null,2,(5),inst_31504,inst_31505,null));
var state_31558__$1 = state_31558;
var statearr_31597_31636 = state_31558__$1;
(statearr_31597_31636[(2)] = inst_31506);

(statearr_31597_31636[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (10))){
var inst_31471 = (state_31558[(7)]);
var inst_31502 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_31471);
var state_31558__$1 = state_31558;
if(inst_31502){
var statearr_31598_31637 = state_31558__$1;
(statearr_31598_31637[(1)] = (16));

} else {
var statearr_31599_31638 = state_31558__$1;
(statearr_31599_31638[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (18))){
var inst_31549 = (state_31558[(2)]);
var state_31558__$1 = state_31558;
var statearr_31600_31639 = state_31558__$1;
(statearr_31600_31639[(2)] = inst_31549);

(statearr_31600_31639[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31559 === (8))){
var inst_31553 = (state_31558[(2)]);
var _ = (function (){var statearr_31601 = state_31558;
(statearr_31601[(4)] = cljs.core.rest((state_31558[(4)])));

return statearr_31601;
})();
var state_31558__$1 = state_31558;
var statearr_31602_31640 = state_31558__$1;
(statearr_31602_31640[(2)] = inst_31553);

(statearr_31602_31640[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__14778__auto__ = null;
var fluree$db$query$analytical$state_machine__14778__auto____0 = (function (){
var statearr_31603 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31603[(0)] = fluree$db$query$analytical$state_machine__14778__auto__);

(statearr_31603[(1)] = (1));

return statearr_31603;
});
var fluree$db$query$analytical$state_machine__14778__auto____1 = (function (state_31558){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31558);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31604){var ex__14781__auto__ = e31604;
var statearr_31605_31641 = state_31558;
(statearr_31605_31641[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31558[(4)]))){
var statearr_31606_31642 = state_31558;
(statearr_31606_31642[(1)] = cljs.core.first((state_31558[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31643 = state_31558;
state_31558 = G__31643;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__14778__auto__ = function(state_31558){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__14778__auto____1.call(this,state_31558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__14778__auto____0;
fluree$db$query$analytical$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__14778__auto____1;
return fluree$db$query$analytical$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31607 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31607[(6)] = c__14852__auto__);

return statearr_31607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__31644){
var vec__31645 = p__31644;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31645,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31645,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31648_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__31648_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__31652 = subjects;
var vec__31653 = G__31652;
var seq__31654 = cljs.core.seq(vec__31653);
var first__31655 = cljs.core.first(seq__31654);
var seq__31654__$1 = cljs.core.next(seq__31654);
var subject = first__31655;
var r = seq__31654__$1;
var acc = expanded_map;
var G__31652__$1 = G__31652;
var acc__$1 = acc;
while(true){
var vec__31659 = G__31652__$1;
var seq__31660 = cljs.core.seq(vec__31659);
var first__31661 = cljs.core.first(seq__31660);
var seq__31660__$1 = cljs.core.next(seq__31660);
var subject__$1 = first__31661;
var r__$1 = seq__31660__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__31662 = r__$1;
var G__31663 = acc__$2;
G__31652__$1 = G__31662;
acc__$1 = G__31663;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__31652__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__31659,seq__31660,first__31661,seq__31660__$1,subject__$1,r__$1,acc__$2,G__31652,vec__31653,seq__31654,first__31655,seq__31654__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4223__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__31652__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31659,seq__31660,first__31661,seq__31660__$1,subject__$1,r__$1,acc__$2,G__31652,vec__31653,seq__31654,first__31655,seq__31654__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__31652__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31659,seq__31660,first__31661,seq__31660__$1,subject__$1,r__$1,acc__$2,G__31652,vec__31653,seq__31654,first__31655,seq__31654__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__31652__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31659,seq__31660,first__31661,seq__31660__$1,subject__$1,r__$1,acc__$2,G__31652,vec__31653,seq__31654,first__31655,seq__31654__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__31652__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__31659,seq__31660,first__31661,seq__31660__$1,subject__$1,r__$1,acc__$2,G__31652,vec__31653,seq__31654,first__31655,seq__31654__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__31652__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__31659,seq__31660,first__31661,seq__31660__$1,subject__$1,r__$1,acc__$2,G__31652,vec__31653,seq__31654,first__31655,seq__31654__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__31664 = r__$1;
var G__31665 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__31652__$1 = G__31664;
acc__$1 = G__31665;
continue;
} else {
var G__31666 = subjects;
var G__31667 = acc_STAR_;
G__31652__$1 = G__31666;
acc__$1 = G__31667;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31668_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__31668_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31759){
var state_val_31760 = (state_31759[(1)]);
if((state_val_31760 === (7))){
var state_31759__$1 = state_31759;
var statearr_31761_31807 = state_31759__$1;
(statearr_31761_31807[(2)] = (100));

(statearr_31761_31807[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (20))){
var inst_31708 = (state_31759[(7)]);
var state_31759__$1 = state_31759;
var statearr_31762_31808 = state_31759__$1;
(statearr_31762_31808[(2)] = inst_31708);

(statearr_31762_31808[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (1))){
var state_31759__$1 = state_31759;
var statearr_31763_31809 = state_31759__$1;
(statearr_31763_31809[(2)] = null);

(statearr_31763_31809[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (24))){
var inst_31745 = (state_31759[(8)]);
var inst_31680 = (state_31759[(9)]);
var inst_31746 = (state_31759[(10)]);
var inst_31747 = (state_31759[(11)]);
var inst_31750 = (function (){var max_depth = inst_31680;
var recur_map__$1 = inst_31746;
var subjects = inst_31745;
var tuples = inst_31747;
return (function (p1__31669_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__31669_SHARP_)],null));
});
})();
var inst_31751 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31750,inst_31747);
var inst_31752 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_31751);
var state_31759__$1 = state_31759;
var statearr_31764_31810 = state_31759__$1;
(statearr_31764_31810[(2)] = inst_31752);

(statearr_31764_31810[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (4))){
var inst_31670 = (state_31759[(2)]);
var state_31759__$1 = state_31759;
var statearr_31765_31811 = state_31759__$1;
(statearr_31765_31811[(2)] = inst_31670);

(statearr_31765_31811[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (15))){
var inst_31693 = (state_31759[(12)]);
var inst_31704 = cljs.core.PersistentVector.EMPTY;
var inst_31705 = cljs.core.seq(inst_31693);
var inst_31706 = cljs.core.first(inst_31705);
var inst_31707 = cljs.core.next(inst_31705);
var inst_31708 = inst_31704;
var inst_31709 = inst_31693;
var state_31759__$1 = (function (){var statearr_31766 = state_31759;
(statearr_31766[(13)] = inst_31707);

(statearr_31766[(7)] = inst_31708);

(statearr_31766[(14)] = inst_31709);

(statearr_31766[(15)] = inst_31706);

return statearr_31766;
})();
var statearr_31767_31812 = state_31759__$1;
(statearr_31767_31812[(2)] = null);

(statearr_31767_31812[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (21))){
var inst_31729 = (state_31759[(2)]);
var state_31759__$1 = state_31759;
var statearr_31768_31813 = state_31759__$1;
(statearr_31768_31813[(2)] = inst_31729);

(statearr_31768_31813[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (13))){
var inst_31742 = (state_31759[(2)]);
var state_31759__$1 = state_31759;
var statearr_31769_31814 = state_31759__$1;
(statearr_31769_31814[(2)] = inst_31742);

(statearr_31769_31814[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (22))){
var inst_31708 = (state_31759[(7)]);
var inst_31716 = (state_31759[(16)]);
var inst_31723 = (state_31759[(2)]);
var inst_31724 = fluree.db.util.async.throw_err(inst_31723);
var inst_31725 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_31708,inst_31724);
var inst_31708__$1 = inst_31725;
var inst_31709 = inst_31716;
var state_31759__$1 = (function (){var statearr_31770 = state_31759;
(statearr_31770[(7)] = inst_31708__$1);

(statearr_31770[(14)] = inst_31709);

return statearr_31770;
})();
var statearr_31771_31815 = state_31759__$1;
(statearr_31771_31815[(2)] = null);

(statearr_31771_31815[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (6))){
var inst_31676 = (state_31759[(17)]);
var state_31759__$1 = state_31759;
var statearr_31772_31816 = state_31759__$1;
(statearr_31772_31816[(2)] = inst_31676);

(statearr_31772_31816[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (25))){
var inst_31754 = (state_31759[(2)]);
var _ = (function (){var statearr_31773 = state_31759;
(statearr_31773[(4)] = cljs.core.rest((state_31759[(4)])));

return statearr_31773;
})();
var state_31759__$1 = state_31759;
var statearr_31774_31817 = state_31759__$1;
(statearr_31774_31817[(2)] = inst_31754);

(statearr_31774_31817[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (17))){
var inst_31709 = (state_31759[(14)]);
var inst_31715 = (state_31759[(18)]);
var inst_31714 = cljs.core.seq(inst_31709);
var inst_31715__$1 = cljs.core.first(inst_31714);
var inst_31716 = cljs.core.next(inst_31714);
var state_31759__$1 = (function (){var statearr_31775 = state_31759;
(statearr_31775[(16)] = inst_31716);

(statearr_31775[(18)] = inst_31715__$1);

return statearr_31775;
})();
if(cljs.core.truth_(inst_31715__$1)){
var statearr_31776_31818 = state_31759__$1;
(statearr_31776_31818[(1)] = (19));

} else {
var statearr_31777_31819 = state_31759__$1;
(statearr_31777_31819[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (3))){
var inst_31757 = (state_31759[(2)]);
var state_31759__$1 = state_31759;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31759__$1,inst_31757);
} else {
if((state_val_31760 === (12))){
var inst_31682 = (state_31759[(19)]);
var inst_31693 = (state_31759[(12)]);
var inst_31688 = cljs.core.vals(inst_31682);
var inst_31689 = cljs.core.flatten(inst_31688);
var inst_31690 = cljs.core.set(inst_31689);
var inst_31691 = cljs.core.keys(inst_31682);
var inst_31692 = cljs.core.set(inst_31691);
var inst_31693__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_31690,inst_31692);
var inst_31694 = cljs.core.empty_QMARK_(inst_31693__$1);
var state_31759__$1 = (function (){var statearr_31778 = state_31759;
(statearr_31778[(12)] = inst_31693__$1);

return statearr_31778;
})();
if(inst_31694){
var statearr_31779_31820 = state_31759__$1;
(statearr_31779_31820[(1)] = (14));

} else {
var statearr_31780_31821 = state_31759__$1;
(statearr_31780_31821[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (2))){
var inst_31676 = (state_31759[(17)]);
var _ = (function (){var statearr_31781 = state_31759;
(statearr_31781[(4)] = cljs.core.cons((5),(state_31759[(4)])));

return statearr_31781;
})();
var inst_31676__$1 = depth;
var state_31759__$1 = (function (){var statearr_31782 = state_31759;
(statearr_31782[(17)] = inst_31676__$1);

return statearr_31782;
})();
if(cljs.core.truth_(inst_31676__$1)){
var statearr_31783_31822 = state_31759__$1;
(statearr_31783_31822[(1)] = (6));

} else {
var statearr_31784_31823 = state_31759__$1;
(statearr_31784_31823[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (23))){
var inst_31747 = (state_31759[(11)]);
var state_31759__$1 = state_31759;
var statearr_31785_31824 = state_31759__$1;
(statearr_31785_31824[(2)] = inst_31747);

(statearr_31785_31824[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (19))){
var inst_31715 = (state_31759[(18)]);
var inst_31718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31719 = [inst_31715,predicate];
var inst_31720 = (new cljs.core.PersistentVector(null,2,(5),inst_31718,inst_31719,null));
var inst_31721 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31720);
var state_31759__$1 = state_31759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31759__$1,(22),inst_31721);
} else {
if((state_val_31760 === (11))){
var inst_31682 = (state_31759[(19)]);
var state_31759__$1 = state_31759;
var statearr_31787_31825 = state_31759__$1;
(statearr_31787_31825[(2)] = inst_31682);

(statearr_31787_31825[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (9))){
var inst_31680 = (state_31759[(9)]);
var inst_31683 = (state_31759[(20)]);
var inst_31685 = (inst_31683 >= inst_31680);
var state_31759__$1 = state_31759;
if(cljs.core.truth_(inst_31685)){
var statearr_31788_31826 = state_31759__$1;
(statearr_31788_31826[(1)] = (11));

} else {
var statearr_31789_31827 = state_31759__$1;
(statearr_31789_31827[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (5))){
var _ = (function (){var statearr_31790 = state_31759;
(statearr_31790[(4)] = cljs.core.rest((state_31759[(4)])));

return statearr_31790;
})();
var state_31759__$1 = state_31759;
var ex31786 = (state_31759__$1[(2)]);
var statearr_31791_31828 = state_31759__$1;
(statearr_31791_31828[(5)] = ex31786);


if((ex31786 instanceof Error)){
var statearr_31792_31829 = state_31759__$1;
(statearr_31792_31829[(1)] = (4));

(statearr_31792_31829[(5)] = null);

} else {
throw ex31786;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (14))){
var inst_31682 = (state_31759[(19)]);
var state_31759__$1 = state_31759;
var statearr_31793_31830 = state_31759__$1;
(statearr_31793_31830[(2)] = inst_31682);

(statearr_31793_31830[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (16))){
var inst_31740 = (state_31759[(2)]);
var state_31759__$1 = state_31759;
var statearr_31794_31831 = state_31759__$1;
(statearr_31794_31831[(2)] = inst_31740);

(statearr_31794_31831[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (10))){
var inst_31745 = (state_31759[(8)]);
var inst_31746 = (state_31759[(10)]);
var inst_31744 = (state_31759[(2)]);
var inst_31745__$1 = cljs.core.keys(inst_31744);
var inst_31746__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_31745__$1,inst_31744);
var inst_31747 = fluree.db.query.analytical.recur_map__GT_tuples(inst_31745__$1,inst_31746__$1);
var state_31759__$1 = (function (){var statearr_31795 = state_31759;
(statearr_31795[(8)] = inst_31745__$1);

(statearr_31795[(10)] = inst_31746__$1);

(statearr_31795[(11)] = inst_31747);

return statearr_31795;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_31796_31832 = state_31759__$1;
(statearr_31796_31832[(1)] = (23));

} else {
var statearr_31797_31833 = state_31759__$1;
(statearr_31797_31833[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (18))){
var inst_31682 = (state_31759[(19)]);
var inst_31683 = (state_31759[(20)]);
var inst_31731 = (state_31759[(2)]);
var inst_31732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31733 = [(0),(2)];
var inst_31734 = (new cljs.core.PersistentVector(null,2,(5),inst_31732,inst_31733,null));
var inst_31735 = fluree.db.query.analytical.get_ns_arrays(inst_31734,inst_31731);
var inst_31736 = fluree.db.query.analytical.tuples__GT_map(inst_31682,inst_31735);
var inst_31737 = (inst_31683 + (1));
var inst_31682__$1 = inst_31736;
var inst_31683__$1 = inst_31737;
var state_31759__$1 = (function (){var statearr_31798 = state_31759;
(statearr_31798[(19)] = inst_31682__$1);

(statearr_31798[(20)] = inst_31683__$1);

return statearr_31798;
})();
var statearr_31799_31834 = state_31759__$1;
(statearr_31799_31834[(2)] = null);

(statearr_31799_31834[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31760 === (8))){
var inst_31680 = (state_31759[(2)]);
var inst_31681 = recur_map;
var inst_31682 = inst_31681;
var inst_31683 = (1);
var state_31759__$1 = (function (){var statearr_31800 = state_31759;
(statearr_31800[(19)] = inst_31682);

(statearr_31800[(9)] = inst_31680);

(statearr_31800[(20)] = inst_31683);

return statearr_31800;
})();
var statearr_31801_31835 = state_31759__$1;
(statearr_31801_31835[(2)] = null);

(statearr_31801_31835[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto____0 = (function (){
var statearr_31802 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31802[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto__);

(statearr_31802[(1)] = (1));

return statearr_31802;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto____1 = (function (state_31759){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31759);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31803){var ex__14781__auto__ = e31803;
var statearr_31804_31836 = state_31759;
(statearr_31804_31836[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31759[(4)]))){
var statearr_31805_31837 = state_31759;
(statearr_31805_31837[(1)] = cljs.core.first((state_31759[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31838 = state_31759;
state_31759 = G__31838;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto__ = function(state_31759){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto____1.call(this,state_31759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31806 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31806[(6)] = c__14852__auto__);

return statearr_31806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__31839,clause,fuel,max_fuel){
var map__31840 = p__31839;
var map__31840__$1 = cljs.core.__destructure_map(map__31840);
var res = map__31840__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31840__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31840__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31840__$1,cljs.core.cst$kw$vars);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31951){
var state_val_31952 = (state_31951[(1)]);
if((state_val_31952 === (7))){
var inst_31857 = (state_31951[(7)]);
var state_31951__$1 = state_31951;
var statearr_31953_32006 = state_31951__$1;
(statearr_31953_32006[(2)] = inst_31857);

(statearr_31953_32006[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (20))){
var inst_31885 = (state_31951[(8)]);
var inst_31916 = typeof inst_31885 === 'number';
var state_31951__$1 = state_31951;
if(cljs.core.truth_(inst_31916)){
var statearr_31954_32007 = state_31951__$1;
(statearr_31954_32007[(1)] = (22));

} else {
var statearr_31955_32008 = state_31951__$1;
(statearr_31955_32008[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (27))){
var inst_31931 = (state_31951[(2)]);
var state_31951__$1 = state_31951;
var statearr_31956_32009 = state_31951__$1;
(statearr_31956_32009[(2)] = inst_31931);

(statearr_31956_32009[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (1))){
var state_31951__$1 = state_31951;
var statearr_31957_32010 = state_31951__$1;
(statearr_31957_32010[(2)] = null);

(statearr_31957_32010[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (24))){
var inst_31933 = (state_31951[(2)]);
var state_31951__$1 = state_31951;
var statearr_31958_32011 = state_31951__$1;
(statearr_31958_32011[(2)] = inst_31933);

(statearr_31958_32011[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (4))){
var inst_31841 = (state_31951[(2)]);
var state_31951__$1 = state_31951;
var statearr_31959_32012 = state_31951__$1;
(statearr_31959_32012[(2)] = inst_31841);

(statearr_31959_32012[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (15))){
var inst_31899 = (state_31951[(2)]);
var inst_31900 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_31901 = fluree.db.query.analytical.variable_QMARK_(inst_31900);
var state_31951__$1 = (function (){var statearr_31960 = state_31951;
(statearr_31960[(9)] = inst_31899);

return statearr_31960;
})();
if(cljs.core.truth_(inst_31901)){
var statearr_31961_32013 = state_31951__$1;
(statearr_31961_32013[(1)] = (16));

} else {
var statearr_31962_32014 = state_31951__$1;
(statearr_31962_32014[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (21))){
var inst_31888 = (state_31951[(10)]);
var inst_31858 = (state_31951[(11)]);
var inst_31887 = (state_31951[(12)]);
var inst_31935 = (state_31951[(2)]);
var inst_31936 = fluree.db.query.analytical.tuples__GT_recur(db,inst_31888,inst_31935,inst_31858,inst_31887);
var state_31951__$1 = state_31951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31951__$1,(28),inst_31936);
} else {
if((state_val_31952 === (13))){
var inst_31867 = (state_31951[(13)]);
var inst_31891 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31867)].join('');
var inst_31892 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31893 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_31894 = cljs.core.PersistentHashMap.fromArrays(inst_31892,inst_31893);
var inst_31895 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31891,inst_31894);
var inst_31896 = (function(){throw inst_31895})();
var state_31951__$1 = state_31951;
var statearr_31963_32015 = state_31951__$1;
(statearr_31963_32015[(2)] = inst_31896);

(statearr_31963_32015[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (22))){
var inst_31883 = (state_31951[(14)]);
var inst_31885 = (state_31951[(8)]);
var inst_31918 = cljs.core.PersistentHashMap.EMPTY;
var inst_31919 = cljs.core.flatten(inst_31883);
var inst_31920 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31918,inst_31885,inst_31919);
var state_31951__$1 = state_31951;
var statearr_31964_32016 = state_31951__$1;
(statearr_31964_32016[(2)] = inst_31920);

(statearr_31964_32016[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (6))){
var inst_31869 = (state_31951[(15)]);
var state_31951__$1 = state_31951;
var statearr_31965_32017 = state_31951__$1;
(statearr_31965_32017[(2)] = inst_31869);

(statearr_31965_32017[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (28))){
var inst_31938 = (state_31951[(2)]);
var inst_31939 = fluree.db.util.async.throw_err(inst_31938);
var state_31951__$1 = state_31951;
var statearr_31966_32018 = state_31951__$1;
(statearr_31966_32018[(2)] = inst_31939);

(statearr_31966_32018[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (25))){
var inst_31879 = (state_31951[(16)]);
var inst_31883 = (state_31951[(14)]);
var inst_31924 = cljs.core.PersistentHashMap.EMPTY;
var inst_31925 = cljs.core.first(inst_31879);
var inst_31926 = cljs.core.first(inst_31925);
var inst_31927 = cljs.core.flatten(inst_31883);
var inst_31928 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31924,inst_31926,inst_31927);
var state_31951__$1 = state_31951;
var statearr_31967_32019 = state_31951__$1;
(statearr_31967_32019[(2)] = inst_31928);

(statearr_31967_32019[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (17))){
var inst_31867 = (state_31951[(13)]);
var inst_31904 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31867)].join('');
var inst_31905 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31906 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_31907 = cljs.core.PersistentHashMap.fromArrays(inst_31905,inst_31906);
var inst_31908 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31904,inst_31907);
var inst_31909 = (function(){throw inst_31908})();
var state_31951__$1 = state_31951;
var statearr_31968_32020 = state_31951__$1;
(statearr_31968_32020[(2)] = inst_31909);

(statearr_31968_32020[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (3))){
var inst_31949 = (state_31951[(2)]);
var state_31951__$1 = state_31951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31951__$1,inst_31949);
} else {
if((state_val_31952 === (12))){
var inst_31854 = (state_31951[(17)]);
var inst_31942 = (state_31951[(2)]);
var inst_31943 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_31944 = cljs.core.keys(inst_31854);
var inst_31945 = [inst_31944,vars,inst_31942];
var inst_31946 = cljs.core.PersistentHashMap.fromArrays(inst_31943,inst_31945);
var _ = (function (){var statearr_31969 = state_31951;
(statearr_31969[(4)] = cljs.core.rest((state_31951[(4)])));

return statearr_31969;
})();
var state_31951__$1 = state_31951;
var statearr_31970_32021 = state_31951__$1;
(statearr_31970_32021[(2)] = inst_31946);

(statearr_31970_32021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (2))){
var inst_31857 = (state_31951[(7)]);
var inst_31869 = (state_31951[(15)]);
var inst_31858 = (state_31951[(11)]);
var inst_31854 = (state_31951[(17)]);
var _ = (function (){var statearr_31971 = state_31951;
(statearr_31971[(4)] = cljs.core.cons((5),(state_31951[(4)])));

return statearr_31971;
})();
var inst_31851 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_31852 = cljs.core.__destructure_map(inst_31851);
var inst_31853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31852,cljs.core.cst$kw$search);
var inst_31854__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31852,cljs.core.cst$kw$rel);
var inst_31855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31852,cljs.core.cst$kw$opts);
var inst_31856 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_31857__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_31855);
var inst_31858__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_31855);
var inst_31860 = (function (){var map__31847 = inst_31852;
var search = inst_31853;
var rel = inst_31854__$1;
var opts = inst_31855;
var common_keys = inst_31856;
var object_fn = inst_31857__$1;
var recur_depth = inst_31858__$1;
return (function (p__31859,common_key){
var vec__31972 = p__31859;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31972,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31972,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__31975 = cljs.core._EQ_;
var expr__31976 = idx_of;
if(cljs.core.truth_((pred__31975.cljs$core$IFn$_invoke$arity$2 ? pred__31975.cljs$core$IFn$_invoke$arity$2((0),expr__31976) : pred__31975.call(null,(0),expr__31976)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__31975.cljs$core$IFn$_invoke$arity$2 ? pred__31975.cljs$core$IFn$_invoke$arity$2((1),expr__31976) : pred__31975.call(null,(1),expr__31976)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__31975.cljs$core$IFn$_invoke$arity$2 ? pred__31975.cljs$core$IFn$_invoke$arity$2((2),expr__31976) : pred__31975.call(null,(2),expr__31976)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31976)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4221__auto__ = (!(single_v_QMARK_));
if(and__4221__auto__){
var and__4221__auto____$1 = object_fn;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_31861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31862 = cljs.core.PersistentHashMap.EMPTY;
var inst_31863 = [inst_31862,inst_31853];
var inst_31864 = (new cljs.core.PersistentVector(null,2,(5),inst_31861,inst_31863,null));
var inst_31865 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31860,inst_31864,inst_31856);
var inst_31866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31865,(0),null);
var inst_31867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31865,(1),null);
var inst_31868 = [cljs.core.cst$kw$object_DASH_fn];
var inst_31869__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_31866);
var state_31951__$1 = (function (){var statearr_31978 = state_31951;
(statearr_31978[(7)] = inst_31857__$1);

(statearr_31978[(15)] = inst_31869__$1);

(statearr_31978[(13)] = inst_31867);

(statearr_31978[(11)] = inst_31858__$1);

(statearr_31978[(17)] = inst_31854__$1);

(statearr_31978[(18)] = inst_31868);

return statearr_31978;
})();
if(cljs.core.truth_(inst_31869__$1)){
var statearr_31979_32022 = state_31951__$1;
(statearr_31979_32022[(1)] = (6));

} else {
var statearr_31980_32023 = state_31951__$1;
(statearr_31980_32023[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (23))){
var inst_31885 = (state_31951[(8)]);
var inst_31922 = cljs.core.coll_QMARK_(inst_31885);
var state_31951__$1 = state_31951;
if(inst_31922){
var statearr_31981_32024 = state_31951__$1;
(statearr_31981_32024[(1)] = (25));

} else {
var statearr_31982_32025 = state_31951__$1;
(statearr_31982_32025[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (19))){
var inst_31883 = (state_31951[(14)]);
var inst_31913 = cljs.core.PersistentHashMap.EMPTY;
var inst_31914 = fluree.db.query.analytical.tuples__GT_map(inst_31913,inst_31883);
var state_31951__$1 = state_31951;
var statearr_31983_32026 = state_31951__$1;
(statearr_31983_32026[(2)] = inst_31914);

(statearr_31983_32026[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (11))){
var inst_31883 = (state_31951[(14)]);
var state_31951__$1 = state_31951;
var statearr_31985_32027 = state_31951__$1;
(statearr_31985_32027[(2)] = inst_31883);

(statearr_31985_32027[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (9))){
var inst_31879 = (state_31951[(16)]);
var inst_31858 = (state_31951[(11)]);
var inst_31854 = (state_31951[(17)]);
var inst_31878 = (state_31951[(2)]);
var inst_31879__$1 = fluree.db.util.async.throw_err(inst_31878);
var inst_31880 = cljs.core.count(inst_31879__$1);
var inst_31881 = fluree.db.query.analytical.add_fuel(inst_31880,fuel,max_fuel);
var inst_31882 = cljs.core.vals(inst_31854);
var inst_31883 = fluree.db.query.analytical.get_ns_arrays(inst_31882,inst_31879__$1);
var state_31951__$1 = (function (){var statearr_31986 = state_31951;
(statearr_31986[(16)] = inst_31879__$1);

(statearr_31986[(14)] = inst_31883);

(statearr_31986[(19)] = inst_31881);

return statearr_31986;
})();
if(cljs.core.truth_(inst_31858)){
var statearr_31987_32028 = state_31951__$1;
(statearr_31987_32028[(1)] = (10));

} else {
var statearr_31988_32029 = state_31951__$1;
(statearr_31988_32029[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (5))){
var _ = (function (){var statearr_31989 = state_31951;
(statearr_31989[(4)] = cljs.core.rest((state_31951[(4)])));

return statearr_31989;
})();
var state_31951__$1 = state_31951;
var ex31984 = (state_31951__$1[(2)]);
var statearr_31990_32030 = state_31951__$1;
(statearr_31990_32030[(5)] = ex31984);


if((ex31984 instanceof Error)){
var statearr_31991_32031 = state_31951__$1;
(statearr_31991_32031[(1)] = (4));

(statearr_31991_32031[(5)] = null);

} else {
throw ex31984;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (14))){
var state_31951__$1 = state_31951;
var statearr_31992_32032 = state_31951__$1;
(statearr_31992_32032[(2)] = null);

(statearr_31992_32032[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (26))){
var state_31951__$1 = state_31951;
var statearr_31993_32033 = state_31951__$1;
(statearr_31993_32033[(2)] = null);

(statearr_31993_32033[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (16))){
var state_31951__$1 = state_31951;
var statearr_31994_32034 = state_31951__$1;
(statearr_31994_32034[(2)] = null);

(statearr_31994_32034[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (10))){
var inst_31888 = (state_31951[(10)]);
var inst_31867 = (state_31951[(13)]);
var inst_31885 = cljs.core.first(inst_31867);
var inst_31886 = cljs.core.first(clause);
var inst_31887 = fluree.db.query.analytical.variable_QMARK_(inst_31886);
var inst_31888__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_31867,(1));
var inst_31889 = fluree.db.query.analytical.variable_QMARK_(inst_31888__$1);
var state_31951__$1 = (function (){var statearr_31995 = state_31951;
(statearr_31995[(10)] = inst_31888__$1);

(statearr_31995[(8)] = inst_31885);

(statearr_31995[(12)] = inst_31887);

return statearr_31995;
})();
if(cljs.core.truth_(inst_31889)){
var statearr_31996_32035 = state_31951__$1;
(statearr_31996_32035[(1)] = (13));

} else {
var statearr_31997_32036 = state_31951__$1;
(statearr_31997_32036[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (18))){
var inst_31887 = (state_31951[(12)]);
var inst_31911 = (state_31951[(2)]);
var state_31951__$1 = (function (){var statearr_31998 = state_31951;
(statearr_31998[(20)] = inst_31911);

return statearr_31998;
})();
if(cljs.core.truth_(inst_31887)){
var statearr_31999_32037 = state_31951__$1;
(statearr_31999_32037[(1)] = (19));

} else {
var statearr_32000_32038 = state_31951__$1;
(statearr_32000_32038[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31952 === (8))){
var inst_31867 = (state_31951[(13)]);
var inst_31868 = (state_31951[(18)]);
var inst_31873 = (state_31951[(2)]);
var inst_31874 = [inst_31873];
var inst_31875 = cljs.core.PersistentHashMap.fromArrays(inst_31868,inst_31874);
var inst_31876 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_31867,inst_31875);
var state_31951__$1 = state_31951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31951__$1,(9),inst_31876);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto____0 = (function (){
var statearr_32001 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32001[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto__);

(statearr_32001[(1)] = (1));

return statearr_32001;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto____1 = (function (state_31951){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31951);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e32002){var ex__14781__auto__ = e32002;
var statearr_32003_32039 = state_31951;
(statearr_32003_32039[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31951[(4)]))){
var statearr_32004_32040 = state_31951;
(statearr_32004_32040[(1)] = cljs.core.first((state_31951[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__32041 = state_31951;
state_31951 = G__32041;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto__ = function(state_31951){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto____1.call(this,state_31951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_32005 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_32005[(6)] = c__14852__auto__);

return statearr_32005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__32042,res,clause){
var map__32043 = p__32042;
var map__32043__$1 = cljs.core.__destructure_map(map__32043);
var db = map__32043__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32043__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32043__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32043__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_32142){
var state_val_32143 = (state_32142[(1)]);
if((state_val_32143 === (7))){
var inst_32053 = (state_32142[(7)]);
var state_32142__$1 = state_32142;
var statearr_32144_32184 = state_32142__$1;
(statearr_32144_32184[(2)] = inst_32053);

(statearr_32144_32184[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (20))){
var inst_32133 = (state_32142[(2)]);
var state_32142__$1 = state_32142;
var statearr_32145_32185 = state_32142__$1;
(statearr_32145_32185[(2)] = inst_32133);

(statearr_32145_32185[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (1))){
var state_32142__$1 = state_32142;
var statearr_32146_32186 = state_32142__$1;
(statearr_32146_32186[(2)] = null);

(statearr_32146_32186[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (24))){
var inst_32112 = (state_32142[(2)]);
var inst_32113 = fluree.db.util.async.throw_err(inst_32112);
var state_32142__$1 = state_32142;
var statearr_32147_32187 = state_32142__$1;
(statearr_32147_32187[(2)] = inst_32113);

(statearr_32147_32187[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (4))){
var inst_32046 = (state_32142[(2)]);
var state_32142__$1 = state_32142;
var statearr_32148_32188 = state_32142__$1;
(statearr_32148_32188[(2)] = inst_32046);

(statearr_32148_32188[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (15))){
var inst_32055 = (state_32142[(8)]);
var inst_32053 = (state_32142[(7)]);
var inst_32074 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_32075 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_32076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32077 = [inst_32053];
var inst_32078 = (new cljs.core.PersistentVector(null,1,(5),inst_32076,inst_32077,null));
var inst_32079 = (function (){var subject_var = inst_32053;
var object_var = inst_32055;
var min_sid = inst_32074;
var max_sid = (0);
return (function (p1__32044_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__32044_SHARP_);
});
})();
var inst_32080 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_32074,(0));
var inst_32081 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32079,inst_32080);
var inst_32082 = cljs.core.PersistentHashMap.EMPTY;
var inst_32083 = [inst_32078,inst_32081,inst_32082];
var inst_32084 = cljs.core.PersistentHashMap.fromArrays(inst_32075,inst_32083);
var state_32142__$1 = state_32142;
var statearr_32149_32189 = state_32142__$1;
(statearr_32149_32189[(2)] = inst_32084);

(statearr_32149_32189[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (21))){
var inst_32106 = (state_32142[(9)]);
var state_32142__$1 = state_32142;
var statearr_32150_32190 = state_32142__$1;
(statearr_32150_32190[(2)] = inst_32106);

(statearr_32150_32190[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (13))){
var inst_32055 = (state_32142[(8)]);
var state_32142__$1 = state_32142;
if(cljs.core.truth_(inst_32055)){
var statearr_32151_32191 = state_32142__$1;
(statearr_32151_32191[(1)] = (18));

} else {
var statearr_32152_32192 = state_32142__$1;
(statearr_32152_32192[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (22))){
var inst_32106 = (state_32142[(9)]);
var inst_32110 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32106);
var state_32142__$1 = state_32142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32142__$1,(24),inst_32110);
} else {
if((state_val_32143 === (6))){
var inst_32055 = (state_32142[(8)]);
var state_32142__$1 = state_32142;
var statearr_32153_32193 = state_32142__$1;
(statearr_32153_32193[(2)] = inst_32055);

(statearr_32153_32193[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (17))){
var inst_32103 = (state_32142[(2)]);
var state_32142__$1 = state_32142;
var statearr_32154_32194 = state_32142__$1;
(statearr_32154_32194[(2)] = inst_32103);

(statearr_32154_32194[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (3))){
var inst_32140 = (state_32142[(2)]);
var state_32142__$1 = state_32142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32142__$1,inst_32140);
} else {
if((state_val_32143 === (12))){
var inst_32068 = ["_tx",null,"_block",null];
var inst_32069 = (new cljs.core.PersistentArrayMap(null,2,inst_32068,null));
var inst_32070 = (new cljs.core.PersistentHashSet(null,inst_32069,null));
var inst_32071 = cljs.core.last(clause);
var inst_32072 = (inst_32070.cljs$core$IFn$_invoke$arity$1 ? inst_32070.cljs$core$IFn$_invoke$arity$1(inst_32071) : inst_32070.call(null,inst_32071));
var state_32142__$1 = state_32142;
if(cljs.core.truth_(inst_32072)){
var statearr_32155_32195 = state_32142__$1;
(statearr_32155_32195[(1)] = (15));

} else {
var statearr_32156_32196 = state_32142__$1;
(statearr_32156_32196[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (2))){
var inst_32053 = (state_32142[(7)]);
var _ = (function (){var statearr_32157 = state_32142;
(statearr_32157[(4)] = cljs.core.cons((5),(state_32142[(4)])));

return statearr_32157;
})();
var inst_32052 = cljs.core.first(clause);
var inst_32053__$1 = fluree.db.query.analytical.variable_QMARK_(inst_32052);
var inst_32054 = cljs.core.last(clause);
var inst_32055 = fluree.db.query.analytical.variable_QMARK_(inst_32054);
var state_32142__$1 = (function (){var statearr_32158 = state_32142;
(statearr_32158[(8)] = inst_32055);

(statearr_32158[(7)] = inst_32053__$1);

return statearr_32158;
})();
if(cljs.core.truth_(inst_32053__$1)){
var statearr_32159_32197 = state_32142__$1;
(statearr_32159_32197[(1)] = (6));

} else {
var statearr_32160_32198 = state_32142__$1;
(statearr_32160_32198[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (23))){
var inst_32055 = (state_32142[(8)]);
var inst_32115 = (state_32142[(2)]);
var inst_32116 = fluree.db.flake.sid__GT_cid(inst_32115);
var inst_32117 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_32116);
var inst_32118 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_32119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32120 = [inst_32055];
var inst_32121 = (new cljs.core.PersistentVector(null,1,(5),inst_32119,inst_32120,null));
var inst_32122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32124 = [inst_32117];
var inst_32125 = (new cljs.core.PersistentVector(null,1,(5),inst_32123,inst_32124,null));
var inst_32126 = [inst_32125];
var inst_32127 = (new cljs.core.PersistentVector(null,1,(5),inst_32122,inst_32126,null));
var inst_32128 = cljs.core.PersistentHashMap.EMPTY;
var inst_32129 = [inst_32121,inst_32127,inst_32128];
var inst_32130 = cljs.core.PersistentHashMap.fromArrays(inst_32118,inst_32129);
var state_32142__$1 = state_32142;
var statearr_32161_32199 = state_32142__$1;
(statearr_32161_32199[(2)] = inst_32130);

(statearr_32161_32199[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (19))){
var state_32142__$1 = state_32142;
var statearr_32162_32200 = state_32142__$1;
(statearr_32162_32200[(2)] = null);

(statearr_32162_32200[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (11))){
var inst_32137 = (state_32142[(2)]);
var _ = (function (){var statearr_32164 = state_32142;
(statearr_32164[(4)] = cljs.core.rest((state_32142[(4)])));

return statearr_32164;
})();
var state_32142__$1 = state_32142;
var statearr_32165_32201 = state_32142__$1;
(statearr_32165_32201[(2)] = inst_32137);

(statearr_32165_32201[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (9))){
var inst_32061 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32062 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_32063 = cljs.core.PersistentHashMap.fromArrays(inst_32061,inst_32062);
var inst_32064 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_32063);
var inst_32065 = (function(){throw inst_32064})();
var state_32142__$1 = state_32142;
var statearr_32166_32202 = state_32142__$1;
(statearr_32166_32202[(2)] = inst_32065);

(statearr_32166_32202[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (5))){
var _ = (function (){var statearr_32167 = state_32142;
(statearr_32167[(4)] = cljs.core.rest((state_32142[(4)])));

return statearr_32167;
})();
var state_32142__$1 = state_32142;
var ex32163 = (state_32142__$1[(2)]);
var statearr_32168_32203 = state_32142__$1;
(statearr_32168_32203[(5)] = ex32163);


if((ex32163 instanceof Error)){
var statearr_32169_32204 = state_32142__$1;
(statearr_32169_32204[(1)] = (4));

(statearr_32169_32204[(5)] = null);

} else {
throw ex32163;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (14))){
var inst_32135 = (state_32142[(2)]);
var state_32142__$1 = state_32142;
var statearr_32170_32205 = state_32142__$1;
(statearr_32170_32205[(2)] = inst_32135);

(statearr_32170_32205[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (16))){
var inst_32055 = (state_32142[(8)]);
var inst_32053 = (state_32142[(7)]);
var inst_32086 = cljs.core.last(clause);
var inst_32087 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_32086);
var inst_32088 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_32089 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32088,inst_32087);
var inst_32090 = fluree.db.flake.min_subject_id(inst_32087);
var inst_32091 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_32092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32093 = [inst_32053];
var inst_32094 = (new cljs.core.PersistentVector(null,1,(5),inst_32092,inst_32093,null));
var inst_32095 = (function (){var subject_var = inst_32053;
var object_var = inst_32055;
var partition = inst_32087;
var max_sid = inst_32089;
var min_sid = inst_32090;
return (function (p1__32045_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__32045_SHARP_);
});
})();
var inst_32096 = (inst_32089 + (1));
var inst_32097 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_32090,inst_32096);
var inst_32098 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32095,inst_32097);
var inst_32099 = cljs.core.PersistentHashMap.EMPTY;
var inst_32100 = [inst_32094,inst_32098,inst_32099];
var inst_32101 = cljs.core.PersistentHashMap.fromArrays(inst_32091,inst_32100);
var state_32142__$1 = state_32142;
var statearr_32171_32206 = state_32142__$1;
(statearr_32171_32206[(2)] = inst_32101);

(statearr_32171_32206[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (10))){
var inst_32053 = (state_32142[(7)]);
var state_32142__$1 = state_32142;
if(cljs.core.truth_(inst_32053)){
var statearr_32172_32207 = state_32142__$1;
(statearr_32172_32207[(1)] = (12));

} else {
var statearr_32173_32208 = state_32142__$1;
(statearr_32173_32208[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (18))){
var inst_32106 = (state_32142[(9)]);
var inst_32106__$1 = cljs.core.first(clause);
var inst_32107 = typeof inst_32106__$1 === 'number';
var state_32142__$1 = (function (){var statearr_32174 = state_32142;
(statearr_32174[(9)] = inst_32106__$1);

return statearr_32174;
})();
if(cljs.core.truth_(inst_32107)){
var statearr_32175_32209 = state_32142__$1;
(statearr_32175_32209[(1)] = (21));

} else {
var statearr_32176_32210 = state_32142__$1;
(statearr_32176_32210[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32143 === (8))){
var inst_32059 = (state_32142[(2)]);
var state_32142__$1 = state_32142;
if(cljs.core.truth_(inst_32059)){
var statearr_32177_32211 = state_32142__$1;
(statearr_32177_32211[(1)] = (9));

} else {
var statearr_32178_32212 = state_32142__$1;
(statearr_32178_32212[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto____0 = (function (){
var statearr_32179 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32179[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto__);

(statearr_32179[(1)] = (1));

return statearr_32179;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto____1 = (function (state_32142){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_32142);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e32180){var ex__14781__auto__ = e32180;
var statearr_32181_32213 = state_32142;
(statearr_32181_32213[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_32142[(4)]))){
var statearr_32182_32214 = state_32142;
(statearr_32182_32214[(1)] = cljs.core.first((state_32142[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__32215 = state_32142;
state_32142 = G__32215;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto__ = function(state_32142){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto____1.call(this,state_32142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_32183 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_32183[(6)] = c__14852__auto__);

return statearr_32183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__32222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__32222 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__32222;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4622__auto__ = (function fluree$db$query$analytical$variance_$_iter__32223(s__32224){
return (new cljs.core.LazySeq(null,(function (){
var s__32224__$1 = s__32224;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__32224__$1);
if(temp__5753__auto__){
var s__32224__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32224__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__32224__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__32226 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__32225 = (0);
while(true){
if((i__32225 < size__4621__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__32225);
var delta = (x - mean);
cljs.core.chunk_append(b__32226,(delta * delta));

var G__32228 = (i__32225 + (1));
i__32225 = G__32228;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32226),fluree$db$query$analytical$variance_$_iter__32223(cljs.core.chunk_rest(s__32224__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32226),null);
}
} else {
var x = cljs.core.first(s__32224__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__32223(cljs.core.rest(s__32224__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__32227 = variance(coll);
return Math.sqrt(G__32227);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4306__auto__ = n;
var y__4307__auto__ = (- n);
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
}),(function() {
var G__32229 = null;
var G__32229__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__32229__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__32229 = function(n,coll){
switch(arguments.length){
case 1:
return G__32229__1.call(this,n);
case 2:
return G__32229__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32229.cljs$core$IFn$_invoke$arity$1 = G__32229__1;
G__32229.cljs$core$IFn$_invoke$arity$2 = G__32229__2;
return G__32229;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__32230 = null;
var G__32230__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__32230__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__32230 = function(n,coll){
switch(arguments.length){
case 1:
return G__32230__1.call(this,n);
case 2:
return G__32230__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32230.cljs$core$IFn$_invoke$arity$1 = G__32230__1;
G__32230.cljs$core$IFn$_invoke$arity$2 = G__32230__2;
return G__32230;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__32231 = null;
var G__32231__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__32231__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__32231 = function(n,coll){
switch(arguments.length){
case 1:
return G__32231__1.call(this,n);
case 2:
return G__32231__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32231.cljs$core$IFn$_invoke$arity$1 = G__32231__1;
G__32231.cljs$core$IFn$_invoke$arity$2 = G__32231__2;
return G__32231;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__32232 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32232,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32232,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32232,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__32235 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__32238 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__32238) : agg_fn.call(null,G__32238));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32235,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32235,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__32239 = agg;
var map__32239__$1 = cljs.core.__destructure_map(map__32239);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32239__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32239__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32239__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__32241 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32241,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32241,(1),null);
var map__32244 = res__$1;
var map__32244__$1 = cljs.core.__destructure_map(map__32244);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32244__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32244__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32240_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__32240_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32245_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__32245_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32246_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__32246_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__32247_SHARP_,p2__32248_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__32247_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__32248_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32249_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__32249_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__32252,row,b_tuple){
var vec__32253 = p__32252;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32253,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32253,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32250_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__32250_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = acc;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32251_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__32251_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32256_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__32256_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32257_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__32257_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__32262 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__32264 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__32263 = (function (p1__32258_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__32258_SHARP_);
});
return fexpr__32263(G__32264);
})()),cljs.core.set(b_idxs));
var fexpr__32261 = (function (p1__32259_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__32259_SHARP_);
});
return fexpr__32261(G__32262);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32260_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__32260_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32265_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__32265_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32266_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32266_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__32271 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__32273 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__32272 = (function (p1__32267_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__32267_SHARP_);
});
return fexpr__32272(G__32273);
})()),cljs.core.set(b_idxs));
var fexpr__32270 = (function (p1__32268_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__32268_SHARP_);
});
return fexpr__32270(G__32271);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32269_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32269_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32274_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__32274_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32275_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32275_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__32284 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__32286 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__32285 = (function (p1__32276_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__32276_SHARP_);
});
return fexpr__32285(G__32286);
})()),cljs.core.set(b_idxs));
var fexpr__32283 = (function (p1__32277_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__32277_SHARP_);
});
return fexpr__32283(G__32284);
})();
var vec__32280 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32287,a_tuple){
var vec__32288 = p__32287;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32288,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32288,(1),null);
var vec__32291 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32291,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32291,(1),null);
var matches__$1 = (function (){var or__4223__auto__ = matches;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32280,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32280,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32278_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32278_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32279_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32279_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__32295 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32295,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32295,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__32294_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__32294_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__32300 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32300,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32300,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32298_SHARP_){
return fluree.db.util.core.index_of(headers,p1__32298_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__32299_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__32299_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__32303,filters,optional_QMARK_){
var map__32304 = p__32303;
var map__32304__$1 = cljs.core.__destructure_map(map__32304);
var tuple_map = map__32304__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32304__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32304__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32304__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__32305 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32305,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32305,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__32308 = res;
var map__32308__$1 = cljs.core.__destructure_map(map__32308);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32308__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32308__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_32364){
var state_val_32365 = (state_32364[(1)]);
if((state_val_32365 === (7))){
var inst_32338 = (state_32364[(7)]);
var inst_32336 = (state_32364[(2)]);
var inst_32337 = fluree.db.util.async.throw_err(inst_32336);
var inst_32338__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32337,(0),null);
var inst_32339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32337,(1),null);
var inst_32340 = (inst_32338__$1 == null);
var state_32364__$1 = (function (){var statearr_32366 = state_32364;
(statearr_32366[(7)] = inst_32338__$1);

(statearr_32366[(8)] = inst_32339);

return statearr_32366;
})();
if(cljs.core.truth_(inst_32340)){
var statearr_32367_32396 = state_32364__$1;
(statearr_32367_32396[(1)] = (8));

} else {
var statearr_32368_32397 = state_32364__$1;
(statearr_32368_32397[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (1))){
var inst_32316 = optional_clauses;
var inst_32317 = cljs.core.seq(inst_32316);
var inst_32318 = cljs.core.first(inst_32317);
var inst_32319 = cljs.core.next(inst_32317);
var inst_32320 = where_tuples;
var inst_32321 = inst_32316;
var inst_32322 = inst_32320;
var state_32364__$1 = (function (){var statearr_32369 = state_32364;
(statearr_32369[(9)] = inst_32319);

(statearr_32369[(10)] = inst_32318);

(statearr_32369[(11)] = inst_32321);

(statearr_32369[(12)] = inst_32322);

return statearr_32369;
})();
var statearr_32370_32398 = state_32364__$1;
(statearr_32370_32398[(2)] = null);

(statearr_32370_32398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (4))){
var inst_32328 = (state_32364[(13)]);
var inst_32322 = (state_32364[(12)]);
var inst_32329 = (state_32364[(14)]);
var inst_32334 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_32322,inst_32328,inst_32329,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_32322,inst_32328,inst_32329,true,fuel,max_fuel,opts));
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32364__$1,(7),inst_32334);
} else {
if((state_val_32365 === (15))){
var state_32364__$1 = state_32364;
var statearr_32371_32399 = state_32364__$1;
(statearr_32371_32399[(2)] = null);

(statearr_32371_32399[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (13))){
var inst_32355 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32372_32400 = state_32364__$1;
(statearr_32372_32400[(2)] = inst_32355);

(statearr_32372_32400[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (6))){
var inst_32360 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32373_32401 = state_32364__$1;
(statearr_32373_32401[(2)] = inst_32360);

(statearr_32373_32401[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (3))){
var inst_32362 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32364__$1,inst_32362);
} else {
if((state_val_32365 === (12))){
var state_32364__$1 = state_32364;
var statearr_32374_32402 = state_32364__$1;
(statearr_32374_32402[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (2))){
var inst_32328 = (state_32364[(13)]);
var inst_32321 = (state_32364[(11)]);
var inst_32327 = cljs.core.seq(inst_32321);
var inst_32328__$1 = cljs.core.first(inst_32327);
var inst_32329 = cljs.core.next(inst_32327);
var state_32364__$1 = (function (){var statearr_32376 = state_32364;
(statearr_32376[(13)] = inst_32328__$1);

(statearr_32376[(14)] = inst_32329);

return statearr_32376;
})();
if(cljs.core.truth_(inst_32328__$1)){
var statearr_32377_32403 = state_32364__$1;
(statearr_32377_32403[(1)] = (4));

} else {
var statearr_32378_32404 = state_32364__$1;
(statearr_32378_32404[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (11))){
var inst_32338 = (state_32364[(7)]);
var inst_32339 = (state_32364[(8)]);
var inst_32321 = inst_32339;
var inst_32322 = inst_32338;
var state_32364__$1 = (function (){var statearr_32379 = state_32364;
(statearr_32379[(11)] = inst_32321);

(statearr_32379[(12)] = inst_32322);

return statearr_32379;
})();
var statearr_32380_32405 = state_32364__$1;
(statearr_32380_32405[(2)] = null);

(statearr_32380_32405[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (9))){
var inst_32328 = (state_32364[(13)]);
var inst_32344 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_32328);
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32344)){
var statearr_32381_32406 = state_32364__$1;
(statearr_32381_32406[(1)] = (11));

} else {
var statearr_32382_32407 = state_32364__$1;
(statearr_32382_32407[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (5))){
var inst_32322 = (state_32364[(12)]);
var state_32364__$1 = state_32364;
var statearr_32383_32408 = state_32364__$1;
(statearr_32383_32408[(2)] = inst_32322);

(statearr_32383_32408[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (14))){
var inst_32322 = (state_32364[(12)]);
var inst_32338 = (state_32364[(7)]);
var inst_32339 = (state_32364[(8)]);
var inst_32349 = fluree.db.query.analytical.left_outer_join(inst_32322,inst_32338);
var inst_32321 = inst_32339;
var inst_32322__$1 = inst_32349;
var state_32364__$1 = (function (){var statearr_32384 = state_32364;
(statearr_32384[(11)] = inst_32321);

(statearr_32384[(12)] = inst_32322__$1);

return statearr_32384;
})();
var statearr_32385_32409 = state_32364__$1;
(statearr_32385_32409[(2)] = null);

(statearr_32385_32409[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (16))){
var inst_32353 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32387_32410 = state_32364__$1;
(statearr_32387_32410[(2)] = inst_32353);

(statearr_32387_32410[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (10))){
var inst_32357 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32388_32411 = state_32364__$1;
(statearr_32388_32411[(2)] = inst_32357);

(statearr_32388_32411[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (8))){
var inst_32322 = (state_32364[(12)]);
var inst_32339 = (state_32364[(8)]);
var tmp32386 = inst_32322;
var inst_32321 = inst_32339;
var inst_32322__$1 = tmp32386;
var state_32364__$1 = (function (){var statearr_32389 = state_32364;
(statearr_32389[(11)] = inst_32321);

(statearr_32389[(12)] = inst_32322__$1);

return statearr_32389;
})();
var statearr_32390_32412 = state_32364__$1;
(statearr_32390_32412[(2)] = null);

(statearr_32390_32412[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto____0 = (function (){
var statearr_32391 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32391[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto__);

(statearr_32391[(1)] = (1));

return statearr_32391;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto____1 = (function (state_32364){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_32364);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e32392){var ex__14781__auto__ = e32392;
var statearr_32393_32413 = state_32364;
(statearr_32393_32413[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_32364[(4)]))){
var statearr_32394_32414 = state_32364;
(statearr_32394_32414[(1)] = cljs.core.first((state_32364[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__32415 = state_32364;
state_32364 = G__32415;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto__ = function(state_32364){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto____1.call(this,state_32364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_32395 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_32395[(6)] = c__14852__auto__);

return statearr_32395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__32417){
var vec__32418 = p__32417;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32418,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32418,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32416_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__32416_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__32422,p__32423,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__32424 = p__32422;
var map__32424__$1 = cljs.core.__destructure_map(map__32424);
var q_map = map__32424__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32424__$1,cljs.core.cst$kw$prefixes);
var map__32425 = p__32423;
var map__32425__$1 = cljs.core.__destructure_map(map__32425);
var res = map__32425__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32425__$1,cljs.core.cst$kw$vars);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_32638){
var state_val_32639 = (state_32638[(1)]);
if((state_val_32639 === (65))){
var inst_32607 = (state_32638[(7)]);
var inst_32610 = (state_32638[(2)]);
var inst_32611 = fluree.db.util.async.throw_err(inst_32610);
var inst_32612 = [inst_32611,r];
var inst_32613 = (new cljs.core.PersistentVector(null,2,(5),inst_32607,inst_32612,null));
var state_32638__$1 = state_32638;
var statearr_32640_32745 = state_32638__$1;
(statearr_32640_32745[(2)] = inst_32613);

(statearr_32640_32745[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (62))){
var inst_32589 = (state_32638[(8)]);
var inst_32590 = (state_32638[(9)]);
var inst_32607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32608 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_32589,res,inst_32590,fuel,max_fuel);
var state_32638__$1 = (function (){var statearr_32641 = state_32638;
(statearr_32641[(7)] = inst_32607);

return statearr_32641;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32638__$1,(65),inst_32608);
} else {
if((state_val_32639 === (7))){
var inst_32531 = (state_32638[(10)]);
var inst_32530 = cljs.core.count(clause);
var inst_32531__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32530);
var state_32638__$1 = (function (){var statearr_32642 = state_32638;
(statearr_32642[(10)] = inst_32531__$1);

return statearr_32642;
})();
if(inst_32531__$1){
var statearr_32643_32746 = state_32638__$1;
(statearr_32643_32746[(1)] = (31));

} else {
var statearr_32644_32747 = state_32638__$1;
(statearr_32644_32747[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (59))){
var inst_32589 = (state_32638[(8)]);
var inst_32590 = (state_32638[(9)]);
var inst_32601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32602 = fluree.db.query.analytical.full_text__GT_tuples(inst_32589,res,inst_32590);
var inst_32603 = [inst_32602,r];
var inst_32604 = (new cljs.core.PersistentVector(null,2,(5),inst_32601,inst_32603,null));
var state_32638__$1 = state_32638;
var statearr_32645_32748 = state_32638__$1;
(statearr_32645_32748[(2)] = inst_32604);

(statearr_32645_32748[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (20))){
var inst_32494 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32646_32749 = state_32638__$1;
(statearr_32646_32749[(2)] = inst_32494);

(statearr_32646_32749[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (58))){
var inst_32595 = (state_32638[(2)]);
var inst_32596 = fluree.db.util.async.throw_err(inst_32595);
var state_32638__$1 = state_32638;
var statearr_32647_32750 = state_32638__$1;
(statearr_32647_32750[(2)] = inst_32596);

(statearr_32647_32750[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (60))){
var state_32638__$1 = state_32638;
var statearr_32648_32751 = state_32638__$1;
(statearr_32648_32751[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (27))){
var inst_32524 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32650_32752 = state_32638__$1;
(statearr_32650_32752[(2)] = inst_32524);

(statearr_32650_32752[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (1))){
var state_32638__$1 = state_32638;
var statearr_32651_32753 = state_32638__$1;
(statearr_32651_32753[(2)] = null);

(statearr_32651_32753[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (24))){
var inst_32488 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32652_32754 = state_32638__$1;
(statearr_32652_32754[(2)] = inst_32488);

(statearr_32652_32754[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (55))){
var inst_32590 = (state_32638[(9)]);
var inst_32593 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_32590,r,res,optional_QMARK_,fuel,max_fuel);
var state_32638__$1 = state_32638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32638__$1,(58),inst_32593);
} else {
if((state_val_32639 === (39))){
var inst_32551 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
if(cljs.core.truth_(inst_32551)){
var statearr_32653_32755 = state_32638__$1;
(statearr_32653_32755[(1)] = (40));

} else {
var statearr_32654_32756 = state_32638__$1;
(statearr_32654_32756[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (46))){
var inst_32627 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32655_32757 = state_32638__$1;
(statearr_32655_32757[(2)] = inst_32627);

(statearr_32655_32757[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (4))){
var inst_32426 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32656_32758 = state_32638__$1;
(statearr_32656_32758[(2)] = inst_32426);

(statearr_32656_32758[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (54))){
var inst_32589 = (state_32638[(8)]);
var inst_32587 = (state_32638[(2)]);
var inst_32588 = fluree.db.util.async.throw_err(inst_32587);
var inst_32589__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32588,(0),null);
var inst_32590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32588,(1),null);
var inst_32591 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_32589__$1);
var state_32638__$1 = (function (){var statearr_32657 = state_32638;
(statearr_32657[(8)] = inst_32589__$1);

(statearr_32657[(9)] = inst_32590);

return statearr_32657;
})();
if(inst_32591){
var statearr_32658_32759 = state_32638__$1;
(statearr_32658_32759[(1)] = (55));

} else {
var statearr_32659_32760 = state_32638__$1;
(statearr_32659_32760[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (15))){
var inst_32526 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32660_32761 = state_32638__$1;
(statearr_32660_32761[(2)] = inst_32526);

(statearr_32660_32761[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (48))){
var inst_32575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32576 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_32577 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_32576);
var inst_32578 = [inst_32577,r];
var inst_32579 = (new cljs.core.PersistentVector(null,2,(5),inst_32575,inst_32578,null));
var state_32638__$1 = state_32638;
var statearr_32661_32762 = state_32638__$1;
(statearr_32661_32762[(2)] = inst_32579);

(statearr_32661_32762[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (50))){
var inst_32625 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32662_32763 = state_32638__$1;
(statearr_32662_32763[(2)] = inst_32625);

(statearr_32662_32763[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (21))){
var inst_32460 = (state_32638[(11)]);
var inst_32465 = (state_32638[(12)]);
var inst_32462 = (state_32638[(13)]);
var inst_32464 = (state_32638[(14)]);
var inst_32439 = (state_32638[(15)]);
var inst_32471 = (state_32638[(16)]);
var inst_32463 = (state_32638[(17)]);
var inst_32472 = (state_32638[(18)]);
var inst_32435 = (state_32638[(19)]);
var inst_32476 = (state_32638[(2)]);
var inst_32477 = fluree.db.util.async.throw_err(inst_32476);
var inst_32478 = (function (){var new_res = inst_32477;
var first__32459 = inst_32462;
var rest = inst_32472;
var vec__32457 = inst_32460;
var tuples = inst_32465;
var seq__32468 = inst_32472;
var pred__32436 = inst_32439;
var expr__32437 = inst_32435;
var seq__32458 = inst_32463;
var G__32456 = inst_32464;
var segment_type = inst_32435;
var first__32469 = inst_32471;
var clause_group = inst_32471;
var vec__32467 = inst_32464;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_32479 = cljs.core.keys(vars);
var inst_32480 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32478,inst_32477,inst_32479);
var inst_32481 = fluree.db.query.analytical.res_absorb_vars(inst_32480);
var state_32638__$1 = (function (){var statearr_32663 = state_32638;
(statearr_32663[(20)] = inst_32481);

return statearr_32663;
})();
if(cljs.core.truth_(inst_32465)){
var statearr_32664_32764 = state_32638__$1;
(statearr_32664_32764[(1)] = (22));

} else {
var statearr_32665_32765 = state_32638__$1;
(statearr_32665_32765[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (31))){
var inst_32533 = cljs.core.second(clause);
var inst_32534 = clojure.string.starts_with_QMARK_(inst_32533,"fullText:");
var state_32638__$1 = state_32638;
var statearr_32666_32766 = state_32638__$1;
(statearr_32666_32766[(2)] = inst_32534);

(statearr_32666_32766[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (32))){
var inst_32531 = (state_32638[(10)]);
var state_32638__$1 = state_32638;
var statearr_32667_32767 = state_32638__$1;
(statearr_32667_32767[(2)] = inst_32531);

(statearr_32667_32767[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (40))){
var inst_32553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32554 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_32638__$1 = (function (){var statearr_32668 = state_32638;
(statearr_32668[(21)] = inst_32553);

return statearr_32668;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32638__$1,(43),inst_32554);
} else {
if((state_val_32639 === (56))){
var inst_32590 = (state_32638[(9)]);
var inst_32598 = cljs.core.second(inst_32590);
var inst_32599 = clojure.string.starts_with_QMARK_(inst_32598,"fullText:");
var state_32638__$1 = state_32638;
if(inst_32599){
var statearr_32669_32768 = state_32638__$1;
(statearr_32669_32768[(1)] = (59));

} else {
var statearr_32670_32769 = state_32638__$1;
(statearr_32670_32769[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (33))){
var inst_32537 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
if(cljs.core.truth_(inst_32537)){
var statearr_32671_32770 = state_32638__$1;
(statearr_32671_32770[(1)] = (34));

} else {
var statearr_32672_32771 = state_32638__$1;
(statearr_32672_32771[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (13))){
var inst_32460 = (state_32638[(11)]);
var inst_32460__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_32461 = cljs.core.seq(inst_32460__$1);
var inst_32462 = cljs.core.first(inst_32461);
var inst_32463 = cljs.core.next(inst_32461);
var inst_32464 = inst_32460__$1;
var inst_32465 = null;
var state_32638__$1 = (function (){var statearr_32673 = state_32638;
(statearr_32673[(11)] = inst_32460__$1);

(statearr_32673[(12)] = inst_32465);

(statearr_32673[(13)] = inst_32462);

(statearr_32673[(14)] = inst_32464);

(statearr_32673[(17)] = inst_32463);

return statearr_32673;
})();
var statearr_32674_32772 = state_32638__$1;
(statearr_32674_32772[(2)] = null);

(statearr_32674_32772[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (22))){
var inst_32465 = (state_32638[(12)]);
var inst_32481 = (state_32638[(20)]);
var inst_32472 = (state_32638[(18)]);
var inst_32483 = fluree.db.query.analytical.outer_union(inst_32465,inst_32481);
var inst_32464 = inst_32472;
var inst_32465__$1 = inst_32483;
var state_32638__$1 = (function (){var statearr_32675 = state_32638;
(statearr_32675[(12)] = inst_32465__$1);

(statearr_32675[(14)] = inst_32464);

return statearr_32675;
})();
var statearr_32676_32773 = state_32638__$1;
(statearr_32676_32773[(2)] = null);

(statearr_32676_32773[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (36))){
var inst_32631 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32677_32774 = state_32638__$1;
(statearr_32677_32774[(2)] = inst_32631);

(statearr_32677_32774[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (41))){
var inst_32561 = cljs.core.count(clause);
var inst_32562 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32561);
var state_32638__$1 = state_32638;
if(inst_32562){
var statearr_32678_32775 = state_32638__$1;
(statearr_32678_32775[(1)] = (44));

} else {
var statearr_32679_32776 = state_32638__$1;
(statearr_32679_32776[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (43))){
var inst_32553 = (state_32638[(21)]);
var inst_32556 = (state_32638[(2)]);
var inst_32557 = fluree.db.util.async.throw_err(inst_32556);
var inst_32558 = [inst_32557,r];
var inst_32559 = (new cljs.core.PersistentVector(null,2,(5),inst_32553,inst_32558,null));
var state_32638__$1 = state_32638;
var statearr_32680_32777 = state_32638__$1;
(statearr_32680_32777[(2)] = inst_32559);

(statearr_32680_32777[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (61))){
var inst_32618 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32681_32778 = state_32638__$1;
(statearr_32681_32778[(2)] = inst_32618);

(statearr_32681_32778[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (29))){
var inst_32435 = (state_32638[(19)]);
var inst_32518 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32435)].join('');
var inst_32519 = (new Error(inst_32518));
var inst_32520 = (function(){throw inst_32519})();
var state_32638__$1 = state_32638;
var statearr_32682_32779 = state_32638__$1;
(statearr_32682_32779[(2)] = inst_32520);

(statearr_32682_32779[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (44))){
var inst_32564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32565 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_32638__$1 = (function (){var statearr_32683 = state_32638;
(statearr_32683[(22)] = inst_32564);

return statearr_32683;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32638__$1,(47),inst_32565);
} else {
if((state_val_32639 === (6))){
var inst_32439 = (state_32638[(15)]);
var inst_32435 = (state_32638[(19)]);
var inst_32434 = cljs.core.keys(clause);
var inst_32435__$1 = cljs.core.first(inst_32434);
var inst_32439__$1 = cljs.core._EQ_;
var inst_32440 = (function (){var G__32684 = cljs.core.cst$kw$optional;
var G__32685 = inst_32435__$1;
return (inst_32439__$1.cljs$core$IFn$_invoke$arity$2 ? inst_32439__$1.cljs$core$IFn$_invoke$arity$2(G__32684,G__32685) : inst_32439__$1.call(null,G__32684,G__32685));
})();
var state_32638__$1 = (function (){var statearr_32686 = state_32638;
(statearr_32686[(15)] = inst_32439__$1);

(statearr_32686[(19)] = inst_32435__$1);

return statearr_32686;
})();
if(cljs.core.truth_(inst_32440)){
var statearr_32687_32780 = state_32638__$1;
(statearr_32687_32780[(1)] = (9));

} else {
var statearr_32688_32781 = state_32638__$1;
(statearr_32688_32781[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (28))){
var inst_32512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32513 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_32514 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_32513,optional_QMARK_);
var inst_32515 = [inst_32514,r];
var inst_32516 = (new cljs.core.PersistentVector(null,2,(5),inst_32512,inst_32515,null));
var state_32638__$1 = state_32638;
var statearr_32689_32782 = state_32638__$1;
(statearr_32689_32782[(2)] = inst_32516);

(statearr_32689_32782[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (64))){
var inst_32616 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32690_32783 = state_32638__$1;
(statearr_32690_32783[(2)] = inst_32616);

(statearr_32690_32783[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (51))){
var inst_32585 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_32638__$1 = state_32638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32638__$1,(54),inst_32585);
} else {
if((state_val_32639 === (25))){
var inst_32439 = (state_32638[(15)]);
var inst_32435 = (state_32638[(19)]);
var inst_32500 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_32501 = (function (){var segment_type = inst_32435;
var pred__32436 = inst_32439;
var expr__32437 = inst_32435;
var bindings = inst_32500;
return (function (p1__32421_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__32421_SHARP_);
});
})();
var inst_32502 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32501,inst_32500);
var inst_32503 = cljs.core.PersistentHashMap.EMPTY;
var inst_32504 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32503,inst_32502);
var inst_32505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32506 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_32504);
var inst_32507 = [inst_32506,r];
var inst_32508 = (new cljs.core.PersistentVector(null,2,(5),inst_32505,inst_32507,null));
var state_32638__$1 = state_32638;
var statearr_32691_32784 = state_32638__$1;
(statearr_32691_32784[(2)] = inst_32508);

(statearr_32691_32784[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (34))){
var inst_32539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32540 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_32541 = [inst_32540,r];
var inst_32542 = (new cljs.core.PersistentVector(null,2,(5),inst_32539,inst_32541,null));
var state_32638__$1 = state_32638;
var statearr_32692_32785 = state_32638__$1;
(statearr_32692_32785[(2)] = inst_32542);

(statearr_32692_32785[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (17))){
var inst_32496 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32693_32786 = state_32638__$1;
(statearr_32693_32786[(2)] = inst_32496);

(statearr_32693_32786[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (3))){
var inst_32636 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32638__$1,inst_32636);
} else {
if((state_val_32639 === (12))){
var inst_32442 = (state_32638[(23)]);
var inst_32446 = (state_32638[(2)]);
var inst_32447 = fluree.db.util.async.throw_err(inst_32446);
var inst_32448 = [inst_32447,r];
var inst_32449 = (new cljs.core.PersistentVector(null,2,(5),inst_32442,inst_32448,null));
var state_32638__$1 = state_32638;
var statearr_32694_32787 = state_32638__$1;
(statearr_32694_32787[(2)] = inst_32449);

(statearr_32694_32787[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (2))){
var _ = (function (){var statearr_32695 = state_32638;
(statearr_32695[(4)] = cljs.core.cons((5),(state_32638[(4)])));

return statearr_32695;
})();
var inst_32432 = cljs.core.map_QMARK_(clause);
var state_32638__$1 = state_32638;
if(inst_32432){
var statearr_32696_32788 = state_32638__$1;
(statearr_32696_32788[(1)] = (6));

} else {
var statearr_32697_32789 = state_32638__$1;
(statearr_32697_32789[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (23))){
var inst_32481 = (state_32638[(20)]);
var inst_32472 = (state_32638[(18)]);
var inst_32464 = inst_32472;
var inst_32465 = inst_32481;
var state_32638__$1 = (function (){var statearr_32698 = state_32638;
(statearr_32698[(12)] = inst_32465);

(statearr_32698[(14)] = inst_32464);

return statearr_32698;
})();
var statearr_32699_32790 = state_32638__$1;
(statearr_32699_32790[(2)] = null);

(statearr_32699_32790[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (47))){
var inst_32564 = (state_32638[(22)]);
var inst_32567 = (state_32638[(2)]);
var inst_32568 = fluree.db.util.async.throw_err(inst_32567);
var inst_32569 = [inst_32568,r];
var inst_32570 = (new cljs.core.PersistentVector(null,2,(5),inst_32564,inst_32569,null));
var state_32638__$1 = state_32638;
var statearr_32700_32791 = state_32638__$1;
(statearr_32700_32791[(2)] = inst_32570);

(statearr_32700_32791[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (35))){
var inst_32545 = (state_32638[(24)]);
var inst_32544 = cljs.core.count(clause);
var inst_32545__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_32544);
var state_32638__$1 = (function (){var statearr_32701 = state_32638;
(statearr_32701[(24)] = inst_32545__$1);

return statearr_32701;
})();
if(inst_32545__$1){
var statearr_32702_32792 = state_32638__$1;
(statearr_32702_32792[(1)] = (37));

} else {
var statearr_32703_32793 = state_32638__$1;
(statearr_32703_32793[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (19))){
var inst_32465 = (state_32638[(12)]);
var inst_32490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32491 = [inst_32465,r];
var inst_32492 = (new cljs.core.PersistentVector(null,2,(5),inst_32490,inst_32491,null));
var state_32638__$1 = state_32638;
var statearr_32704_32794 = state_32638__$1;
(statearr_32704_32794[(2)] = inst_32492);

(statearr_32704_32794[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (57))){
var inst_32620 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32705_32795 = state_32638__$1;
(statearr_32705_32795[(2)] = inst_32620);

(statearr_32705_32795[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (11))){
var inst_32528 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32707_32796 = state_32638__$1;
(statearr_32707_32796[(2)] = inst_32528);

(statearr_32707_32796[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (9))){
var inst_32442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32443 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_32444 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_32443,res,fuel,max_fuel,opts);
var state_32638__$1 = (function (){var statearr_32708 = state_32638;
(statearr_32708[(23)] = inst_32442);

return statearr_32708;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32638__$1,(12),inst_32444);
} else {
if((state_val_32639 === (5))){
var _ = (function (){var statearr_32709 = state_32638;
(statearr_32709[(4)] = cljs.core.rest((state_32638[(4)])));

return statearr_32709;
})();
var state_32638__$1 = state_32638;
var ex32706 = (state_32638__$1[(2)]);
var statearr_32710_32797 = state_32638__$1;
(statearr_32710_32797[(5)] = ex32706);


if((ex32706 instanceof Error)){
var statearr_32711_32798 = state_32638__$1;
(statearr_32711_32798[(1)] = (4));

(statearr_32711_32798[(5)] = null);

} else {
throw ex32706;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (14))){
var inst_32439 = (state_32638[(15)]);
var inst_32435 = (state_32638[(19)]);
var inst_32498 = (function (){var G__32712 = cljs.core.cst$kw$bind;
var G__32713 = inst_32435;
return (inst_32439.cljs$core$IFn$_invoke$arity$2 ? inst_32439.cljs$core$IFn$_invoke$arity$2(G__32712,G__32713) : inst_32439.call(null,G__32712,G__32713));
})();
var state_32638__$1 = state_32638;
if(cljs.core.truth_(inst_32498)){
var statearr_32714_32799 = state_32638__$1;
(statearr_32714_32799[(1)] = (25));

} else {
var statearr_32715_32800 = state_32638__$1;
(statearr_32715_32800[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (45))){
var inst_32572 = cljs.core.count(clause);
var inst_32573 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_32572);
var state_32638__$1 = state_32638;
if(inst_32573){
var statearr_32716_32801 = state_32638__$1;
(statearr_32716_32801[(1)] = (48));

} else {
var statearr_32717_32802 = state_32638__$1;
(statearr_32717_32802[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (53))){
var inst_32623 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32718_32803 = state_32638__$1;
(statearr_32718_32803[(2)] = inst_32623);

(statearr_32718_32803[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (26))){
var inst_32439 = (state_32638[(15)]);
var inst_32435 = (state_32638[(19)]);
var inst_32510 = (function (){var G__32719 = cljs.core.cst$kw$filter;
var G__32720 = inst_32435;
return (inst_32439.cljs$core$IFn$_invoke$arity$2 ? inst_32439.cljs$core$IFn$_invoke$arity$2(G__32719,G__32720) : inst_32439.call(null,G__32719,G__32720));
})();
var state_32638__$1 = state_32638;
if(cljs.core.truth_(inst_32510)){
var statearr_32721_32804 = state_32638__$1;
(statearr_32721_32804[(1)] = (28));

} else {
var statearr_32722_32805 = state_32638__$1;
(statearr_32722_32805[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (16))){
var inst_32464 = (state_32638[(14)]);
var inst_32471 = (state_32638[(16)]);
var inst_32470 = cljs.core.seq(inst_32464);
var inst_32471__$1 = cljs.core.first(inst_32470);
var inst_32472 = cljs.core.next(inst_32470);
var state_32638__$1 = (function (){var statearr_32723 = state_32638;
(statearr_32723[(16)] = inst_32471__$1);

(statearr_32723[(18)] = inst_32472);

return statearr_32723;
})();
if(cljs.core.truth_(inst_32471__$1)){
var statearr_32724_32806 = state_32638__$1;
(statearr_32724_32806[(1)] = (18));

} else {
var statearr_32725_32807 = state_32638__$1;
(statearr_32725_32807[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (38))){
var inst_32545 = (state_32638[(24)]);
var state_32638__$1 = state_32638;
var statearr_32726_32808 = state_32638__$1;
(statearr_32726_32808[(2)] = inst_32545);

(statearr_32726_32808[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (30))){
var inst_32522 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32727_32809 = state_32638__$1;
(statearr_32727_32809[(2)] = inst_32522);

(statearr_32727_32809[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (10))){
var inst_32439 = (state_32638[(15)]);
var inst_32435 = (state_32638[(19)]);
var inst_32451 = (function (){var G__32728 = cljs.core.cst$kw$union;
var G__32729 = inst_32435;
return (inst_32439.cljs$core$IFn$_invoke$arity$2 ? inst_32439.cljs$core$IFn$_invoke$arity$2(G__32728,G__32729) : inst_32439.call(null,G__32728,G__32729));
})();
var state_32638__$1 = state_32638;
if(cljs.core.truth_(inst_32451)){
var statearr_32730_32810 = state_32638__$1;
(statearr_32730_32810[(1)] = (13));

} else {
var statearr_32731_32811 = state_32638__$1;
(statearr_32731_32811[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (18))){
var inst_32471 = (state_32638[(16)]);
var inst_32474 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_32471,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_32471,q_map,vars,fuel,max_fuel,opts));
var state_32638__$1 = state_32638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32638__$1,(21),inst_32474);
} else {
if((state_val_32639 === (52))){
var state_32638__$1 = state_32638;
var statearr_32732_32812 = state_32638__$1;
(statearr_32732_32812[(2)] = null);

(statearr_32732_32812[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (42))){
var inst_32629 = (state_32638[(2)]);
var state_32638__$1 = state_32638;
var statearr_32733_32813 = state_32638__$1;
(statearr_32733_32813[(2)] = inst_32629);

(statearr_32733_32813[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (37))){
var inst_32547 = cljs.core.second(clause);
var inst_32548 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32547,"rdf:type");
var state_32638__$1 = state_32638;
var statearr_32734_32814 = state_32638__$1;
(statearr_32734_32814[(2)] = inst_32548);

(statearr_32734_32814[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (63))){
var state_32638__$1 = state_32638;
var statearr_32735_32815 = state_32638__$1;
(statearr_32735_32815[(2)] = null);

(statearr_32735_32815[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (8))){
var inst_32633 = (state_32638[(2)]);
var _ = (function (){var statearr_32736 = state_32638;
(statearr_32736[(4)] = cljs.core.rest((state_32638[(4)])));

return statearr_32736;
})();
var state_32638__$1 = state_32638;
var statearr_32737_32816 = state_32638__$1;
(statearr_32737_32816[(2)] = inst_32633);

(statearr_32737_32816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32639 === (49))){
var state_32638__$1 = state_32638;
var statearr_32738_32817 = state_32638__$1;
(statearr_32738_32817[(1)] = (51));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto____0 = (function (){
var statearr_32740 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32740[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto__);

(statearr_32740[(1)] = (1));

return statearr_32740;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto____1 = (function (state_32638){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_32638);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e32741){var ex__14781__auto__ = e32741;
var statearr_32742_32818 = state_32638;
(statearr_32742_32818[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_32638[(4)]))){
var statearr_32743_32819 = state_32638;
(statearr_32743_32819[(1)] = cljs.core.first((state_32638[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__32820 = state_32638;
state_32638 = G__32820;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto__ = function(state_32638){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto____1.call(this,state_32638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_32744 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_32744[(6)] = c__14852__auto__);

return statearr_32744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__32822 = arguments.length;
switch (G__32822) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_32902){
var state_val_32903 = (state_32902[(1)]);
if((state_val_32903 === (7))){
var inst_32897 = (state_32902[(2)]);
var _ = (function (){var statearr_32904 = state_32902;
(statearr_32904[(4)] = cljs.core.rest((state_32902[(4)])));

return statearr_32904;
})();
var state_32902__$1 = state_32902;
var statearr_32905_32953 = state_32902__$1;
(statearr_32905_32953[(2)] = inst_32897);

(statearr_32905_32953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (20))){
var inst_32862 = (state_32902[(7)]);
var inst_32874 = (state_32902[(2)]);
var inst_32844 = inst_32862;
var inst_32845 = inst_32874;
var state_32902__$1 = (function (){var statearr_32906 = state_32902;
(statearr_32906[(8)] = inst_32844);

(statearr_32906[(9)] = inst_32845);

return statearr_32906;
})();
var statearr_32907_32954 = state_32902__$1;
(statearr_32907_32954[(2)] = null);

(statearr_32907_32954[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (1))){
var state_32902__$1 = state_32902;
var statearr_32908_32955 = state_32902__$1;
(statearr_32908_32955[(2)] = null);

(statearr_32908_32955[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (24))){
var inst_32861 = (state_32902[(10)]);
var inst_32845 = (state_32902[(9)]);
var inst_32862 = (state_32902[(7)]);
var inst_32882 = fluree.db.query.analytical.inner_join(inst_32845,inst_32861);
var inst_32844 = inst_32862;
var inst_32845__$1 = inst_32882;
var state_32902__$1 = (function (){var statearr_32909 = state_32902;
(statearr_32909[(8)] = inst_32844);

(statearr_32909[(9)] = inst_32845__$1);

return statearr_32909;
})();
var statearr_32910_32956 = state_32902__$1;
(statearr_32910_32956[(2)] = null);

(statearr_32910_32956[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (4))){
var inst_32823 = (state_32902[(2)]);
var state_32902__$1 = state_32902;
var statearr_32912_32957 = state_32902__$1;
(statearr_32912_32957[(2)] = inst_32823);

(statearr_32912_32957[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (15))){
var inst_32861 = (state_32902[(10)]);
var state_32902__$1 = state_32902;
if(cljs.core.truth_(inst_32861)){
var statearr_32913_32958 = state_32902__$1;
(statearr_32913_32958[(1)] = (18));

} else {
var statearr_32914_32959 = state_32902__$1;
(statearr_32914_32959[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (21))){
var inst_32845 = (state_32902[(9)]);
var inst_32862 = (state_32902[(7)]);
var tmp32911 = inst_32845;
var inst_32844 = inst_32862;
var inst_32845__$1 = tmp32911;
var state_32902__$1 = (function (){var statearr_32915 = state_32902;
(statearr_32915[(8)] = inst_32844);

(statearr_32915[(9)] = inst_32845__$1);

return statearr_32915;
})();
var statearr_32916_32960 = state_32902__$1;
(statearr_32916_32960[(2)] = null);

(statearr_32916_32960[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (13))){
var inst_32845 = (state_32902[(9)]);
var inst_32868 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_32845,cljs.core.cst$kw$vars);
var inst_32869 = cljs.core.empty_QMARK_(inst_32868);
var state_32902__$1 = state_32902;
if(inst_32869){
var statearr_32917_32961 = state_32902__$1;
(statearr_32917_32961[(1)] = (15));

} else {
var statearr_32918_32962 = state_32902__$1;
(statearr_32918_32962[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (22))){
var state_32902__$1 = state_32902;
var statearr_32919_32963 = state_32902__$1;
(statearr_32919_32963[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (6))){
var inst_32844 = (state_32902[(8)]);
var inst_32851 = (state_32902[(11)]);
var inst_32850 = cljs.core.seq(inst_32844);
var inst_32851__$1 = cljs.core.first(inst_32850);
var inst_32852 = cljs.core.next(inst_32850);
var state_32902__$1 = (function (){var statearr_32921 = state_32902;
(statearr_32921[(11)] = inst_32851__$1);

(statearr_32921[(12)] = inst_32852);

return statearr_32921;
})();
if(cljs.core.truth_(inst_32851__$1)){
var statearr_32922_32964 = state_32902__$1;
(statearr_32922_32964[(1)] = (8));

} else {
var statearr_32923_32965 = state_32902__$1;
(statearr_32923_32965[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (25))){
var state_32902__$1 = state_32902;
var statearr_32924_32966 = state_32902__$1;
(statearr_32924_32966[(2)] = null);

(statearr_32924_32966[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (17))){
var inst_32890 = (state_32902[(2)]);
var state_32902__$1 = state_32902;
var statearr_32925_32967 = state_32902__$1;
(statearr_32925_32967[(2)] = inst_32890);

(statearr_32925_32967[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (3))){
var inst_32900 = (state_32902[(2)]);
var state_32902__$1 = state_32902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32902__$1,inst_32900);
} else {
if((state_val_32903 === (12))){
var inst_32861 = (state_32902[(10)]);
var inst_32862 = (state_32902[(7)]);
var inst_32844 = inst_32862;
var inst_32845 = inst_32861;
var state_32902__$1 = (function (){var statearr_32926 = state_32902;
(statearr_32926[(8)] = inst_32844);

(statearr_32926[(9)] = inst_32845);

return statearr_32926;
})();
var statearr_32927_32968 = state_32902__$1;
(statearr_32927_32968[(2)] = null);

(statearr_32927_32968[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (2))){
var _ = (function (){var statearr_32928 = state_32902;
(statearr_32928[(4)] = cljs.core.cons((5),(state_32902[(4)])));

return statearr_32928;
})();
var inst_32836 = where;
var inst_32837 = cljs.core.seq(inst_32836);
var inst_32838 = cljs.core.first(inst_32837);
var inst_32839 = cljs.core.next(inst_32837);
var inst_32840 = [cljs.core.cst$kw$vars];
var inst_32841 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_32842 = [inst_32841];
var inst_32843 = cljs.core.PersistentHashMap.fromArrays(inst_32840,inst_32842);
var inst_32844 = inst_32836;
var inst_32845 = inst_32843;
var state_32902__$1 = (function (){var statearr_32929 = state_32902;
(statearr_32929[(8)] = inst_32844);

(statearr_32929[(13)] = inst_32838);

(statearr_32929[(9)] = inst_32845);

(statearr_32929[(14)] = inst_32839);

return statearr_32929;
})();
var statearr_32930_32969 = state_32902__$1;
(statearr_32930_32969[(2)] = null);

(statearr_32930_32969[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (23))){
var inst_32888 = (state_32902[(2)]);
var state_32902__$1 = state_32902;
var statearr_32931_32970 = state_32902__$1;
(statearr_32931_32970[(2)] = inst_32888);

(statearr_32931_32970[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (19))){
var inst_32845 = (state_32902[(9)]);
var state_32902__$1 = state_32902;
var statearr_32932_32971 = state_32902__$1;
(statearr_32932_32971[(2)] = inst_32845);

(statearr_32932_32971[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (11))){
var inst_32851 = (state_32902[(11)]);
var inst_32859 = (state_32902[(2)]);
var inst_32860 = fluree.db.util.async.throw_err(inst_32859);
var inst_32861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32860,(0),null);
var inst_32862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32860,(1),null);
var inst_32863 = cljs.core.count(inst_32851);
var inst_32864 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_32863);
var state_32902__$1 = (function (){var statearr_32934 = state_32902;
(statearr_32934[(10)] = inst_32861);

(statearr_32934[(7)] = inst_32862);

return statearr_32934;
})();
if(inst_32864){
var statearr_32935_32972 = state_32902__$1;
(statearr_32935_32972[(1)] = (12));

} else {
var statearr_32936_32973 = state_32902__$1;
(statearr_32936_32973[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (9))){
var inst_32845 = (state_32902[(9)]);
var state_32902__$1 = state_32902;
var statearr_32937_32974 = state_32902__$1;
(statearr_32937_32974[(2)] = inst_32845);

(statearr_32937_32974[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (5))){
var _ = (function (){var statearr_32938 = state_32902;
(statearr_32938[(4)] = cljs.core.rest((state_32902[(4)])));

return statearr_32938;
})();
var state_32902__$1 = state_32902;
var ex32933 = (state_32902__$1[(2)]);
var statearr_32939_32975 = state_32902__$1;
(statearr_32939_32975[(5)] = ex32933);


if((ex32933 instanceof Error)){
var statearr_32940_32976 = state_32902__$1;
(statearr_32940_32976[(1)] = (4));

(statearr_32940_32976[(5)] = null);

} else {
throw ex32933;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (14))){
var inst_32892 = (state_32902[(2)]);
var state_32902__$1 = state_32902;
var statearr_32941_32977 = state_32902__$1;
(statearr_32941_32977[(2)] = inst_32892);

(statearr_32941_32977[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (26))){
var inst_32886 = (state_32902[(2)]);
var state_32902__$1 = state_32902;
var statearr_32942_32978 = state_32902__$1;
(statearr_32942_32978[(2)] = inst_32886);

(statearr_32942_32978[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (16))){
var inst_32861 = (state_32902[(10)]);
var inst_32877 = (inst_32861 == null);
var state_32902__$1 = state_32902;
if(cljs.core.truth_(inst_32877)){
var statearr_32943_32979 = state_32902__$1;
(statearr_32943_32979[(1)] = (21));

} else {
var statearr_32944_32980 = state_32902__$1;
(statearr_32944_32980[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (10))){
var inst_32895 = (state_32902[(2)]);
var state_32902__$1 = state_32902;
var statearr_32945_32981 = state_32902__$1;
(statearr_32945_32981[(2)] = inst_32895);

(statearr_32945_32981[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (18))){
var inst_32861 = (state_32902[(10)]);
var state_32902__$1 = state_32902;
var statearr_32946_32982 = state_32902__$1;
(statearr_32946_32982[(2)] = inst_32861);

(statearr_32946_32982[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32903 === (8))){
var inst_32845 = (state_32902[(9)]);
var inst_32851 = (state_32902[(11)]);
var inst_32852 = (state_32902[(12)]);
var inst_32857 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_32845,inst_32851,inst_32852,false,fuel,max_fuel,opts);
var state_32902__$1 = state_32902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32902__$1,(11),inst_32857);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__14778__auto__ = null;
var fluree$db$query$analytical$state_machine__14778__auto____0 = (function (){
var statearr_32947 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32947[(0)] = fluree$db$query$analytical$state_machine__14778__auto__);

(statearr_32947[(1)] = (1));

return statearr_32947;
});
var fluree$db$query$analytical$state_machine__14778__auto____1 = (function (state_32902){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_32902);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e32948){var ex__14781__auto__ = e32948;
var statearr_32949_32983 = state_32902;
(statearr_32949_32983[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_32902[(4)]))){
var statearr_32950_32984 = state_32902;
(statearr_32950_32984[(1)] = cljs.core.first((state_32902[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__32985 = state_32902;
state_32902 = G__32985;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__14778__auto__ = function(state_32902){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__14778__auto____1.call(this,state_32902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__14778__auto____0;
fluree$db$query$analytical$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__14778__auto____1;
return fluree$db$query$analytical$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_32951 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_32951[(6)] = c__14852__auto__);

return statearr_32951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_33020){
var state_val_33021 = (state_33020[(1)]);
if((state_val_33021 === (7))){
var inst_33002 = (state_33020[(7)]);
var inst_32997 = (state_33020[(8)]);
var inst_33004 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_32997,inst_33002,fuel,max_fuel,opts);
var state_33020__$1 = state_33020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33020__$1,(10),inst_33004);
} else {
if((state_val_33021 === (1))){
var state_33020__$1 = state_33020;
var statearr_33022_33047 = state_33020__$1;
(statearr_33022_33047[(2)] = null);

(statearr_33022_33047[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (4))){
var inst_32986 = (state_33020[(2)]);
var state_33020__$1 = state_33020;
var statearr_33023_33048 = state_33020__$1;
(statearr_33023_33048[(2)] = inst_32986);

(statearr_33023_33048[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (13))){
var inst_33015 = (state_33020[(2)]);
var _ = (function (){var statearr_33024 = state_33020;
(statearr_33024[(4)] = cljs.core.rest((state_33020[(4)])));

return statearr_33024;
})();
var state_33020__$1 = state_33020;
var statearr_33025_33049 = state_33020__$1;
(statearr_33025_33049[(2)] = inst_33015);

(statearr_33025_33049[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (6))){
var inst_32997 = (state_33020[(8)]);
var inst_33001 = (state_33020[(2)]);
var inst_33002 = fluree.db.util.async.throw_err(inst_33001);
var state_33020__$1 = (function (){var statearr_33026 = state_33020;
(statearr_33026[(7)] = inst_33002);

return statearr_33026;
})();
if(cljs.core.truth_(inst_32997)){
var statearr_33027_33050 = state_33020__$1;
(statearr_33027_33050[(1)] = (7));

} else {
var statearr_33028_33051 = state_33020__$1;
(statearr_33028_33051[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (3))){
var inst_33018 = (state_33020[(2)]);
var state_33020__$1 = state_33020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33020__$1,inst_33018);
} else {
if((state_val_33021 === (12))){
var inst_33010 = (state_33020[(9)]);
var state_33020__$1 = state_33020;
var statearr_33029_33052 = state_33020__$1;
(statearr_33029_33052[(2)] = inst_33010);

(statearr_33029_33052[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (2))){
var _ = (function (){var statearr_33030 = state_33020;
(statearr_33030[(4)] = cljs.core.cons((5),(state_33020[(4)])));

return statearr_33030;
})();
var inst_32993 = q_map;
var inst_32994 = cljs.core.__destructure_map(inst_32993);
var inst_32995 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32994,cljs.core.cst$kw$vars);
var inst_32996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32994,cljs.core.cst$kw$where);
var inst_32997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32994,cljs.core.cst$kw$optional);
var inst_32998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32994,cljs.core.cst$kw$filter);
var inst_32999 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_32996,q_map,inst_32995,fuel,max_fuel,opts);
var state_33020__$1 = (function (){var statearr_33031 = state_33020;
(statearr_33031[(8)] = inst_32997);

(statearr_33031[(10)] = inst_32998);

return statearr_33031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33020__$1,(6),inst_32999);
} else {
if((state_val_33021 === (11))){
var inst_33010 = (state_33020[(9)]);
var inst_32998 = (state_33020[(10)]);
var inst_33012 = fluree.db.query.analytical.tuples__GT_filtered(inst_33010,inst_32998,null);
var state_33020__$1 = state_33020;
var statearr_33033_33053 = state_33020__$1;
(statearr_33033_33053[(2)] = inst_33012);

(statearr_33033_33053[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (9))){
var inst_32998 = (state_33020[(10)]);
var inst_33010 = (state_33020[(2)]);
var state_33020__$1 = (function (){var statearr_33034 = state_33020;
(statearr_33034[(9)] = inst_33010);

return statearr_33034;
})();
if(cljs.core.truth_(inst_32998)){
var statearr_33035_33054 = state_33020__$1;
(statearr_33035_33054[(1)] = (11));

} else {
var statearr_33036_33055 = state_33020__$1;
(statearr_33036_33055[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (5))){
var _ = (function (){var statearr_33037 = state_33020;
(statearr_33037[(4)] = cljs.core.rest((state_33020[(4)])));

return statearr_33037;
})();
var state_33020__$1 = state_33020;
var ex33032 = (state_33020__$1[(2)]);
var statearr_33038_33056 = state_33020__$1;
(statearr_33038_33056[(5)] = ex33032);


if((ex33032 instanceof Error)){
var statearr_33039_33057 = state_33020__$1;
(statearr_33039_33057[(1)] = (4));

(statearr_33039_33057[(5)] = null);

} else {
throw ex33032;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (10))){
var inst_33006 = (state_33020[(2)]);
var inst_33007 = fluree.db.util.async.throw_err(inst_33006);
var state_33020__$1 = state_33020;
var statearr_33040_33058 = state_33020__$1;
(statearr_33040_33058[(2)] = inst_33007);

(statearr_33040_33058[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33021 === (8))){
var inst_33002 = (state_33020[(7)]);
var state_33020__$1 = state_33020;
var statearr_33041_33059 = state_33020__$1;
(statearr_33041_33059[(2)] = inst_33002);

(statearr_33041_33059[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__14778__auto____0 = (function (){
var statearr_33042 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33042[(0)] = fluree$db$query$analytical$q_$_state_machine__14778__auto__);

(statearr_33042[(1)] = (1));

return statearr_33042;
});
var fluree$db$query$analytical$q_$_state_machine__14778__auto____1 = (function (state_33020){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_33020);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e33043){var ex__14781__auto__ = e33043;
var statearr_33044_33060 = state_33020;
(statearr_33044_33060[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_33020[(4)]))){
var statearr_33045_33061 = state_33020;
(statearr_33045_33061[(1)] = cljs.core.first((state_33020[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__33062 = state_33020;
state_33020 = G__33062;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__14778__auto__ = function(state_33020){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__14778__auto____1.call(this,state_33020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__14778__auto____0;
fluree$db$query$analytical$q_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__14778__auto____1;
return fluree$db$query$analytical$q_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_33046 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_33046[(6)] = c__14852__auto__);

return statearr_33046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
