// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31112_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31112_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__31116 = coll;
var vec__31117 = G__31116;
var seq__31118 = cljs.core.seq(vec__31117);
var first__31119 = cljs.core.first(seq__31118);
var seq__31118__$1 = cljs.core.next(seq__31118);
var clause = first__31119;
var r = seq__31118__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31116__$1 = G__31116;
var res__$1 = res;
while(true){
var vec__31123 = G__31116__$1;
var seq__31124 = cljs.core.seq(vec__31123);
var first__31125 = cljs.core.first(seq__31124);
var seq__31124__$1 = cljs.core.next(seq__31124);
var clause__$1 = first__31125;
var r__$1 = seq__31124__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31126 = r__$1;
var G__31127 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__31116__$1 = G__31126;
res__$1 = G__31127;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__31128){
var map__31129 = p__31128;
var map__31129__$1 = cljs.core.__destructure_map(map__31129);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31129__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__31133 = coll;
var vec__31134 = G__31133;
var seq__31135 = cljs.core.seq(vec__31134);
var first__31136 = cljs.core.first(seq__31135);
var seq__31135__$1 = cljs.core.next(seq__31135);
var clause = first__31136;
var r = seq__31135__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31133__$1 = G__31133;
var res__$1 = res;
while(true){
var vec__31140 = G__31133__$1;
var seq__31141 = cljs.core.seq(vec__31140);
var first__31142 = cljs.core.first(seq__31141);
var seq__31141__$1 = cljs.core.next(seq__31141);
var clause__$1 = first__31142;
var r__$1 = seq__31141__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31143 = r__$1;
var G__31144 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__31133__$1 = G__31143;
res__$1 = G__31144;
continue;
} else {
var G__31145 = r__$1;
var G__31146 = res__$2;
G__31133__$1 = G__31145;
res__$1 = G__31146;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__31150 = coll;
var vec__31151 = G__31150;
var seq__31152 = cljs.core.seq(vec__31151);
var first__31153 = cljs.core.first(seq__31152);
var seq__31152__$1 = cljs.core.next(seq__31152);
var clause = first__31153;
var r = seq__31152__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31150__$1 = G__31150;
var res__$1 = res;
while(true){
var vec__31157 = G__31150__$1;
var seq__31158 = cljs.core.seq(vec__31157);
var first__31159 = cljs.core.first(seq__31158);
var seq__31158__$1 = cljs.core.next(seq__31158);
var clause__$1 = first__31159;
var r__$1 = seq__31158__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31160 = r__$1;
var G__31161 = res__$2;
G__31150__$1 = G__31160;
res__$1 = G__31161;
continue;
} else {
var G__31162 = r__$1;
var G__31163 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__31150__$1 = G__31162;
res__$1 = G__31163;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4221__auto__ = typeof string === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4221__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__31164 = clause;
var G__31164__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__31164):G__31164);
var G__31164__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__31164__$1)
;
var G__31164__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__31164__$2)
;
var G__31164__$4 = goog.string.format("%s .",G__31164__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__31164__$4);
} else {
return G__31164__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__31168 = opts;
var map__31168__$1 = cljs.core.__destructure_map(map__31168);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31168__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31168__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31168__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31168__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31168__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31165_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31165_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__31166_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__31166_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__31167_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__31167_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = language;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31182){
var state_val_31183 = (state_31182[(1)]);
if((state_val_31183 === (1))){
var inst_31169 = fluree.db.util.core.url_encode(query);
var inst_31170 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31169)].join('');
var inst_31171 = ["User-Agent","Accept"];
var inst_31172 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_31173 = cljs.core.PersistentHashMap.fromArrays(inst_31171,inst_31172);
var inst_31174 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_31175 = [inst_31173,(30000),cljs.core.cst$kw$wikidata];
var inst_31176 = cljs.core.PersistentHashMap.fromArrays(inst_31174,inst_31175);
var inst_31177 = fluree.db.util.xhttp.get(inst_31170,inst_31176);
var state_31182__$1 = state_31182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31182__$1,(2),inst_31177);
} else {
if((state_val_31183 === (2))){
var inst_31179 = (state_31182[(2)]);
var inst_31180 = fluree.db.util.async.throw_err(inst_31179);
var state_31182__$1 = state_31182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31182__$1,inst_31180);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto____0 = (function (){
var statearr_31184 = [null,null,null,null,null,null,null];
(statearr_31184[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto__);

(statearr_31184[(1)] = (1));

return statearr_31184;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto____1 = (function (state_31182){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31182);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31185){var ex__14781__auto__ = e31185;
var statearr_31186_31189 = state_31182;
(statearr_31186_31189[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31182[(4)]))){
var statearr_31187_31190 = state_31182;
(statearr_31187_31190[(1)] = cljs.core.first((state_31182[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31191 = state_31182;
state_31182 = G__31191;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto__ = function(state_31182){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto____1.call(this,state_31182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31188 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31188[(6)] = c__14852__auto__);

return statearr_31188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31209){
var state_val_31210 = (state_31209[(1)]);
if((state_val_31210 === (1))){
var inst_31192 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_31209__$1 = state_31209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31209__$1,(2),inst_31192);
} else {
if((state_val_31210 === (2))){
var inst_31195 = (state_31209[(7)]);
var inst_31194 = (state_31209[(2)]);
var inst_31195__$1 = fluree.db.util.async.throw_err(inst_31194);
var inst_31196 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_31195__$1);
var inst_31197 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_31196);
var state_31209__$1 = (function (){var statearr_31211 = state_31209;
(statearr_31211[(7)] = inst_31195__$1);

return statearr_31211;
})();
if(inst_31197){
var statearr_31212_31221 = state_31209__$1;
(statearr_31212_31221[(1)] = (3));

} else {
var statearr_31213_31222 = state_31209__$1;
(statearr_31213_31222[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31210 === (3))){
var inst_31195 = (state_31209[(7)]);
var state_31209__$1 = state_31209;
var statearr_31214_31223 = state_31209__$1;
(statearr_31214_31223[(2)] = inst_31195);

(statearr_31214_31223[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31210 === (4))){
var inst_31195 = (state_31209[(7)]);
var inst_31200 = (function (){var body = inst_31195;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_31201 = cljs.core.second(inst_31195);
var inst_31202 = cljs.core.second(inst_31201);
var inst_31203 = cljs.core.first(inst_31202);
var inst_31204 = cljs.core.second(inst_31203);
var inst_31205 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_31200,inst_31204);
var state_31209__$1 = state_31209;
var statearr_31215_31224 = state_31209__$1;
(statearr_31215_31224[(2)] = inst_31205);

(statearr_31215_31224[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31210 === (5))){
var inst_31207 = (state_31209[(2)]);
var state_31209__$1 = state_31209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31209__$1,inst_31207);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto____0 = (function (){
var statearr_31216 = [null,null,null,null,null,null,null,null];
(statearr_31216[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto__);

(statearr_31216[(1)] = (1));

return statearr_31216;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto____1 = (function (state_31209){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31209);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31217){var ex__14781__auto__ = e31217;
var statearr_31218_31225 = state_31209;
(statearr_31218_31225[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31209[(4)]))){
var statearr_31219_31226 = state_31209;
(statearr_31219_31226[(1)] = cljs.core.first((state_31209[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31227 = state_31209;
state_31209 = G__31227;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto__ = function(state_31209){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto____1.call(this,state_31209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31220 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31220[(6)] = c__14852__auto__);

return statearr_31220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31228_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31228_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31229_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31229_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31230_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__31230_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31230_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__31230_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_31276){
var state_val_31277 = (state_31276[(1)]);
if((state_val_31277 === (7))){
var inst_31241 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_31276__$1 = state_31276;
var statearr_31278_31306 = state_31276__$1;
(statearr_31278_31306[(2)] = inst_31241);

(statearr_31278_31306[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (1))){
var state_31276__$1 = state_31276;
var statearr_31279_31307 = state_31276__$1;
(statearr_31279_31307[(2)] = null);

(statearr_31279_31307[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (4))){
var inst_31231 = (state_31276[(2)]);
var state_31276__$1 = state_31276;
var statearr_31280_31308 = state_31276__$1;
(statearr_31280_31308[(2)] = inst_31231);

(statearr_31280_31308[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (15))){
var inst_31255 = (state_31276[(7)]);
var inst_31249 = (state_31276[(8)]);
var inst_31250 = (state_31276[(9)]);
var inst_31260 = (state_31276[(2)]);
var inst_31261 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_31255,(0),inst_31260);
var inst_31262 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31263 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_31249);
var inst_31264 = [inst_31250,inst_31263];
var inst_31265 = cljs.core.PersistentHashMap.fromArrays(inst_31262,inst_31264);
var inst_31266 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31261,inst_31265);
var inst_31267 = (function(){throw inst_31266})();
var state_31276__$1 = state_31276;
var statearr_31281_31309 = state_31276__$1;
(statearr_31281_31309[(2)] = inst_31267);

(statearr_31281_31309[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (13))){
var inst_31254 = (state_31276[(10)]);
var state_31276__$1 = state_31276;
var statearr_31282_31310 = state_31276__$1;
(statearr_31282_31310[(2)] = inst_31254);

(statearr_31282_31310[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (6))){
var state_31276__$1 = state_31276;
var statearr_31283_31311 = state_31276__$1;
(statearr_31283_31311[(2)] = null);

(statearr_31283_31311[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (3))){
var inst_31274 = (state_31276[(2)]);
var state_31276__$1 = state_31276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31276__$1,inst_31274);
} else {
if((state_val_31277 === (12))){
var inst_31271 = (state_31276[(2)]);
var _ = (function (){var statearr_31284 = state_31276;
(statearr_31284[(4)] = cljs.core.rest((state_31276[(4)])));

return statearr_31284;
})();
var state_31276__$1 = state_31276;
var statearr_31285_31312 = state_31276__$1;
(statearr_31285_31312[(2)] = inst_31271);

(statearr_31285_31312[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (2))){
var _ = (function (){var statearr_31286 = state_31276;
(statearr_31286[(4)] = cljs.core.cons((5),(state_31276[(4)])));

return statearr_31286;
})();
var inst_31238 = cljs.core.empty_QMARK_(matching_vars);
var state_31276__$1 = state_31276;
if(inst_31238){
var statearr_31287_31313 = state_31276__$1;
(statearr_31287_31313[(1)] = (6));

} else {
var statearr_31288_31314 = state_31276__$1;
(statearr_31288_31314[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (11))){
var inst_31249 = (state_31276[(8)]);
var inst_31269 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_31249,all_vars);
var state_31276__$1 = state_31276;
var statearr_31290_31315 = state_31276__$1;
(statearr_31290_31315[(2)] = inst_31269);

(statearr_31290_31315[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (9))){
var inst_31249 = (state_31276[(8)]);
var inst_31250 = (state_31276[(9)]);
var inst_31247 = (state_31276[(2)]);
var inst_31248 = fluree.db.util.async.throw_err(inst_31247);
var inst_31249__$1 = cljs.core.__destructure_map(inst_31248);
var inst_31250__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31249__$1,cljs.core.cst$kw$status);
var inst_31251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31249__$1,cljs.core.cst$kw$message);
var inst_31252 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_31250__$1);
var state_31276__$1 = (function (){var statearr_31291 = state_31276;
(statearr_31291[(11)] = inst_31251);

(statearr_31291[(8)] = inst_31249__$1);

(statearr_31291[(9)] = inst_31250__$1);

return statearr_31291;
})();
if(inst_31252){
var statearr_31292_31316 = state_31276__$1;
(statearr_31292_31316[(1)] = (10));

} else {
var statearr_31293_31317 = state_31276__$1;
(statearr_31293_31317[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (5))){
var _ = (function (){var statearr_31294 = state_31276;
(statearr_31294[(4)] = cljs.core.rest((state_31276[(4)])));

return statearr_31294;
})();
var state_31276__$1 = state_31276;
var ex31289 = (state_31276__$1[(2)]);
var statearr_31295_31318 = state_31276__$1;
(statearr_31295_31318[(5)] = ex31289);


if((ex31289 instanceof Error)){
var statearr_31296_31319 = state_31276__$1;
(statearr_31296_31319[(1)] = (4));

(statearr_31296_31319[(5)] = null);

} else {
throw ex31289;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (14))){
var state_31276__$1 = state_31276;
var statearr_31297_31320 = state_31276__$1;
(statearr_31297_31320[(2)] = (1000));

(statearr_31297_31320[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (10))){
var inst_31251 = (state_31276[(11)]);
var inst_31249 = (state_31276[(8)]);
var inst_31254 = (state_31276[(10)]);
var inst_31254__$1 = cljs.core.count(inst_31251);
var inst_31255 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_31249);
var inst_31256 = (inst_31254__$1 < (1000));
var state_31276__$1 = (function (){var statearr_31298 = state_31276;
(statearr_31298[(7)] = inst_31255);

(statearr_31298[(10)] = inst_31254__$1);

return statearr_31298;
})();
if(cljs.core.truth_(inst_31256)){
var statearr_31299_31321 = state_31276__$1;
(statearr_31299_31321[(1)] = (13));

} else {
var statearr_31300_31322 = state_31276__$1;
(statearr_31300_31322[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31277 === (8))){
var inst_31243 = (state_31276[(2)]);
var inst_31244 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_31243,optional_clauses);
var inst_31245 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_31244);
var state_31276__$1 = state_31276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31276__$1,(9),inst_31245);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto____0 = (function (){
var statearr_31301 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31301[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto__);

(statearr_31301[(1)] = (1));

return statearr_31301;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto____1 = (function (state_31276){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_31276);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e31302){var ex__14781__auto__ = e31302;
var statearr_31303_31323 = state_31276;
(statearr_31303_31323[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_31276[(4)]))){
var statearr_31304_31324 = state_31276;
(statearr_31304_31324[(1)] = cljs.core.first((state_31276[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__31325 = state_31276;
state_31276 = G__31325;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto__ = function(state_31276){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto____1.call(this,state_31276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_31305 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_31305[(6)] = c__14852__auto__);

return statearr_31305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
