// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__34497 = arguments.length;
switch (G__34497) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__34499 = null;
var G__34499__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__34499__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__34499__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__34499 = function(result,flake){
switch(arguments.length){
case 0:
return G__34499__0.call(this);
case 1:
return G__34499__1.call(this,result);
case 2:
return G__34499__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34499.cljs$core$IFn$_invoke$arity$0 = G__34499__0;
G__34499.cljs$core$IFn$_invoke$arity$1 = G__34499__1;
G__34499.cljs$core$IFn$_invoke$arity$2 = G__34499__2;
return G__34499;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__34500 = null;
var G__34500__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__34500__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__34500__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__34500 = function(result,flakes){
switch(arguments.length){
case 0:
return G__34500__0.call(this);
case 1:
return G__34500__1.call(this,result);
case 2:
return G__34500__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34500.cljs$core$IFn$_invoke$arity$0 = G__34500__0;
G__34500.cljs$core$IFn$_invoke$arity$1 = G__34500__1;
G__34500.cljs$core$IFn$_invoke$arity$2 = G__34500__2;
return G__34500;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__34502 = res;
var G__34502__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__34501_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__34501_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__34502):G__34502);
var G__34502__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__34502__$1):G__34502__$1);
var G__34502__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__34502__$2):G__34502__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__34502__$3);
} else {
return G__34502__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__34504 = arguments.length;
switch (G__34504) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_34803){
var state_val_34804 = (state_34803[(1)]);
if((state_val_34804 === (65))){
var inst_34544 = (state_34803[(7)]);
var inst_34661 = (state_34803[(8)]);
var inst_34654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34655 = cljs.core.deref(cache);
var inst_34656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34657 = flake.o;
var inst_34658 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_34544);
var inst_34659 = [inst_34657,inst_34658];
var inst_34660 = (new cljs.core.PersistentVector(null,2,(5),inst_34656,inst_34659,null));
var inst_34661__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34655,inst_34660);
var state_34803__$1 = (function (){var statearr_34805 = state_34803;
(statearr_34805[(9)] = inst_34654);

(statearr_34805[(8)] = inst_34661__$1);

return statearr_34805;
})();
if(cljs.core.truth_(inst_34661__$1)){
var statearr_34806_34975 = state_34803__$1;
(statearr_34806_34975[(1)] = (68));

} else {
var statearr_34807_34976 = state_34803__$1;
(statearr_34807_34976[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (70))){
var inst_34654 = (state_34803[(9)]);
var inst_34679 = (state_34803[(2)]);
var inst_34680 = [inst_34679,offset_map];
var inst_34681 = (new cljs.core.PersistentVector(null,2,(5),inst_34654,inst_34680,null));
var state_34803__$1 = state_34803;
var statearr_34808_34977 = state_34803__$1;
(statearr_34808_34977[(2)] = inst_34681);

(statearr_34808_34977[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (62))){
var inst_34560 = (state_34803[(10)]);
var inst_34529 = (state_34803[(11)]);
var inst_34558 = (state_34803[(12)]);
var inst_34639 = (state_34803[(13)]);
var inst_34515 = (state_34803[(14)]);
var inst_34544 = (state_34803[(7)]);
var inst_34559 = (state_34803[(15)]);
var inst_34555 = (state_34803[(16)]);
var inst_34556 = (state_34803[(17)]);
var inst_34561 = (state_34803[(18)]);
var inst_34557 = (state_34803[(19)]);
var inst_34562 = (state_34803[(20)]);
var inst_34623 = (state_34803[(21)]);
var inst_34641 = (function (){var map__34511 = inst_34556;
var G__34625 = inst_34639;
var p = inst_34562;
var pred_spec__$1 = inst_34529;
var orderBy = inst_34560;
var nested_select_spec = inst_34623;
var multi_QMARK_ = inst_34557;
var limit = inst_34559;
var offset = inst_34561;
var k = inst_34555;
var compact_QMARK_ = inst_34515;
var pred_spec_SINGLEQUOTE_ = inst_34544;
var ref_QMARK_ = inst_34558;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_34642 = (inst_34641.cljs$core$IFn$_invoke$arity$1 ? inst_34641.cljs$core$IFn$_invoke$arity$1(inst_34639) : inst_34641.call(null,inst_34639));
var state_34803__$1 = state_34803;
var statearr_34809_34978 = state_34803__$1;
(statearr_34809_34978[(2)] = inst_34642);

(statearr_34809_34978[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (74))){
var inst_34688 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34688)){
var statearr_34810_34979 = state_34803__$1;
(statearr_34810_34979[(1)] = (75));

} else {
var statearr_34811_34980 = state_34803__$1;
(statearr_34811_34980[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (7))){
var inst_34516 = (state_34803[(22)]);
var state_34803__$1 = state_34803;
var statearr_34812_34981 = state_34803__$1;
(statearr_34812_34981[(2)] = inst_34516);

(statearr_34812_34981[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (59))){
var inst_34633 = (state_34803[(23)]);
var inst_34635 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_34636 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_34635,inst_34633);
var state_34803__$1 = state_34803;
var statearr_34813_34982 = state_34803__$1;
(statearr_34813_34982[(2)] = inst_34636);

(statearr_34813_34982[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (86))){
var inst_34560 = (state_34803[(10)]);
var inst_34529 = (state_34803[(11)]);
var inst_34558 = (state_34803[(12)]);
var inst_34515 = (state_34803[(14)]);
var inst_34544 = (state_34803[(7)]);
var inst_34559 = (state_34803[(15)]);
var inst_34555 = (state_34803[(16)]);
var inst_34556 = (state_34803[(17)]);
var inst_34719 = (state_34803[(24)]);
var inst_34561 = (state_34803[(18)]);
var inst_34557 = (state_34803[(19)]);
var inst_34701 = (state_34803[(25)]);
var inst_34562 = (state_34803[(20)]);
var inst_34721 = (function (){var map__34511 = inst_34556;
var p = inst_34562;
var pred_spec__$1 = inst_34529;
var orderBy = inst_34560;
var children = inst_34701;
var multi_QMARK_ = inst_34557;
var limit = inst_34559;
var offset = inst_34561;
var G__34713 = inst_34719;
var k = inst_34555;
var compact_QMARK_ = inst_34515;
var pred_spec_SINGLEQUOTE_ = inst_34544;
var ref_QMARK_ = inst_34558;
return (function (n){
var G__34814 = db;
var G__34815 = cache;
var G__34816 = fuel;
var G__34817 = max_fuel;
var G__34818 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$wildcard_QMARK_,true,cljs.core.cst$kw$compact_QMARK_,compact_QMARK_], null);
var G__34819 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__34814,G__34815,G__34816,G__34817,G__34818,G__34819) : fluree.db.query.fql.flakes__GT_res.call(null,G__34814,G__34815,G__34816,G__34817,G__34818,G__34819));
});
})();
var inst_34722 = (inst_34721.cljs$core$IFn$_invoke$arity$1 ? inst_34721.cljs$core$IFn$_invoke$arity$1(inst_34719) : inst_34721.call(null,inst_34719));
var state_34803__$1 = state_34803;
var statearr_34820_34983 = state_34803__$1;
(statearr_34820_34983[(2)] = inst_34722);

(statearr_34820_34983[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (20))){
var inst_34544 = (state_34803[(7)]);
var inst_34556 = (state_34803[(17)]);
var inst_34557 = (state_34803[(19)]);
var inst_34555 = (state_34803[(2)]);
var inst_34556__$1 = cljs.core.__destructure_map(inst_34544);
var inst_34557__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34556__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_34558 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34556__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_34559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34556__$1,cljs.core.cst$kw$limit);
var inst_34560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34556__$1,cljs.core.cst$kw$orderBy);
var inst_34561 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34556__$1,cljs.core.cst$kw$offset);
var inst_34562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34556__$1,cljs.core.cst$kw$p);
var state_34803__$1 = (function (){var statearr_34821 = state_34803;
(statearr_34821[(10)] = inst_34560);

(statearr_34821[(12)] = inst_34558);

(statearr_34821[(15)] = inst_34559);

(statearr_34821[(16)] = inst_34555);

(statearr_34821[(17)] = inst_34556__$1);

(statearr_34821[(18)] = inst_34561);

(statearr_34821[(19)] = inst_34557__$1);

(statearr_34821[(20)] = inst_34562);

return statearr_34821;
})();
if(cljs.core.truth_(inst_34557__$1)){
var statearr_34822_34984 = state_34803__$1;
(statearr_34822_34984[(1)] = (24));

} else {
var statearr_34823_34985 = state_34803__$1;
(statearr_34823_34985[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (72))){
var inst_34544 = (state_34803[(7)]);
var inst_34685 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_34544);
var state_34803__$1 = state_34803;
var statearr_34824_34986 = state_34803__$1;
(statearr_34824_34986[(2)] = inst_34685);

(statearr_34824_34986[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (58))){
var inst_34632 = (state_34803[(2)]);
var inst_34633 = fluree.db.util.async.throw_err(inst_34632);
var state_34803__$1 = (function (){var statearr_34825 = state_34803;
(statearr_34825[(23)] = inst_34633);

return statearr_34825;
})();
if(cljs.core.truth_(fuel)){
var statearr_34826_34987 = state_34803__$1;
(statearr_34826_34987[(1)] = (59));

} else {
var statearr_34827_34988 = state_34803__$1;
(statearr_34827_34988[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (60))){
var inst_34633 = (state_34803[(23)]);
var state_34803__$1 = state_34803;
var statearr_34828_34989 = state_34803__$1;
(statearr_34828_34989[(2)] = inst_34633);

(statearr_34828_34989[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (27))){
var inst_34565 = (state_34803[(26)]);
var inst_34561 = (state_34803[(18)]);
var inst_34565__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_34561);
var state_34803__$1 = (function (){var statearr_34829 = state_34803;
(statearr_34829[(26)] = inst_34565__$1);

return statearr_34829;
})();
if(inst_34565__$1){
var statearr_34830_34990 = state_34803__$1;
(statearr_34830_34990[(1)] = (30));

} else {
var statearr_34831_34991 = state_34803__$1;
(statearr_34831_34991[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (1))){
var state_34803__$1 = state_34803;
var statearr_34832_34992 = state_34803__$1;
(statearr_34832_34992[(2)] = null);

(statearr_34832_34992[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (69))){
var inst_34544 = (state_34803[(7)]);
var inst_34664 = flake.o;
var inst_34665 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_34544);
var inst_34666 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_34664,inst_34665);
var state_34803__$1 = state_34803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34803__$1,(71),inst_34666);
} else {
if((state_val_34804 === (101))){
var inst_34555 = (state_34803[(16)]);
var inst_34763 = (state_34803[(27)]);
var inst_34764 = (state_34803[(28)]);
var inst_34783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34784 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_34555,inst_34763);
var inst_34785 = [inst_34784,inst_34764];
var inst_34786 = (new cljs.core.PersistentVector(null,2,(5),inst_34783,inst_34785,null));
var state_34803__$1 = state_34803;
var statearr_34833_34993 = state_34803__$1;
(statearr_34833_34993[(2)] = inst_34786);

(statearr_34833_34993[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (24))){
var inst_34561 = (state_34803[(18)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34561)){
var statearr_34834_34994 = state_34803__$1;
(statearr_34834_34994[(1)] = (27));

} else {
var statearr_34835_34995 = state_34803__$1;
(statearr_34835_34995[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (102))){
var state_34803__$1 = state_34803;
var statearr_34836_34996 = state_34803__$1;
(statearr_34836_34996[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (55))){
var inst_34544 = (state_34803[(7)]);
var inst_34652 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_34544);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34652)){
var statearr_34838_34997 = state_34803__$1;
(statearr_34838_34997[(1)] = (65));

} else {
var statearr_34839_34998 = state_34803__$1;
(statearr_34839_34998[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (85))){
var inst_34719 = (state_34803[(2)]);
var state_34803__$1 = (function (){var statearr_34840 = state_34803;
(statearr_34840[(24)] = inst_34719);

return statearr_34840;
})();
var statearr_34841_34999 = state_34803__$1;
(statearr_34841_34999[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (39))){
var inst_34560 = (state_34803[(10)]);
var inst_34592 = (state_34803[(29)]);
var inst_34592__$1 = cljs.core.not(inst_34560);
var state_34803__$1 = (function (){var statearr_34843 = state_34803;
(statearr_34843[(29)] = inst_34592__$1);

return statearr_34843;
})();
if(inst_34592__$1){
var statearr_34844_35000 = state_34803__$1;
(statearr_34844_35000[(1)] = (42));

} else {
var statearr_34845_35001 = state_34803__$1;
(statearr_34845_35001[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (88))){
var inst_34725 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34803__$1,(82),inst_34725);
} else {
if((state_val_34804 === (46))){
var inst_34608 = (state_34803[(30)]);
var inst_34608__$1 = cljs.core.not(recur_QMARK_);
var state_34803__$1 = (function (){var statearr_34846 = state_34803;
(statearr_34846[(30)] = inst_34608__$1);

return statearr_34846;
})();
if(inst_34608__$1){
var statearr_34847_35002 = state_34803__$1;
(statearr_34847_35002[(1)] = (48));

} else {
var statearr_34848_35003 = state_34803__$1;
(statearr_34848_35003[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (4))){
var inst_34505 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34849_35004 = state_34803__$1;
(statearr_34849_35004[(2)] = inst_34505);

(statearr_34849_35004[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (77))){
var inst_34754 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34850_35005 = state_34803__$1;
(statearr_34850_35005[(2)] = inst_34754);

(statearr_34850_35005[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (106))){
var inst_34794 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34851_35006 = state_34803__$1;
(statearr_34851_35006[(2)] = inst_34794);

(statearr_34851_35006[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (95))){
var inst_34557 = (state_34803[(19)]);
var state_34803__$1 = state_34803;
var statearr_34852_35007 = state_34803__$1;
(statearr_34852_35007[(2)] = inst_34557);

(statearr_34852_35007[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (54))){
var inst_34544 = (state_34803[(7)]);
var inst_34620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34621 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_34622 = (new cljs.core.PersistentVector(null,3,(5),inst_34620,inst_34621,null));
var inst_34623 = cljs.core.select_keys(inst_34544,inst_34622);
var inst_34624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34627 = flake.o;
var inst_34628 = [inst_34627];
var inst_34629 = (new cljs.core.PersistentVector(null,1,(5),inst_34626,inst_34628,null));
var inst_34630 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34629);
var state_34803__$1 = (function (){var statearr_34853 = state_34803;
(statearr_34853[(31)] = inst_34624);

(statearr_34853[(21)] = inst_34623);

return statearr_34853;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34803__$1,(58),inst_34630);
} else {
if((state_val_34804 === (92))){
var inst_34744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34745 = flake.o;
var inst_34746 = [inst_34745,offset_map];
var inst_34747 = (new cljs.core.PersistentVector(null,2,(5),inst_34744,inst_34746,null));
var state_34803__$1 = state_34803;
var statearr_34854_35008 = state_34803__$1;
(statearr_34854_35008[(2)] = inst_34747);

(statearr_34854_35008[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (104))){
var inst_34764 = (state_34803[(28)]);
var inst_34789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34790 = [acc,inst_34764];
var inst_34791 = (new cljs.core.PersistentVector(null,2,(5),inst_34789,inst_34790,null));
var state_34803__$1 = state_34803;
var statearr_34855_35009 = state_34803__$1;
(statearr_34855_35009[(2)] = inst_34791);

(statearr_34855_35009[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (15))){
var inst_34515 = (state_34803[(14)]);
var inst_34537 = (state_34803[(32)]);
var inst_34541 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34537,cljs.core.cst$kw$compact_QMARK_,inst_34515);
var state_34803__$1 = state_34803;
var statearr_34856_35010 = state_34803__$1;
(statearr_34856_35010[(2)] = inst_34541);

(statearr_34856_35010[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (48))){
var inst_34544 = (state_34803[(7)]);
var inst_34610 = (state_34803[(33)]);
var inst_34610__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_34544);
var state_34803__$1 = (function (){var statearr_34857 = state_34803;
(statearr_34857[(33)] = inst_34610__$1);

return statearr_34857;
})();
if(cljs.core.truth_(inst_34610__$1)){
var statearr_34858_35011 = state_34803__$1;
(statearr_34858_35011[(1)] = (51));

} else {
var statearr_34859_35012 = state_34803__$1;
(statearr_34859_35012[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (50))){
var inst_34618 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34618)){
var statearr_34860_35013 = state_34803__$1;
(statearr_34860_35013[(1)] = (54));

} else {
var statearr_34861_35014 = state_34803__$1;
(statearr_34861_35014[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (75))){
var inst_34544 = (state_34803[(7)]);
var inst_34690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34691 = flake.o;
var inst_34692 = [inst_34691];
var inst_34693 = (new cljs.core.PersistentVector(null,1,(5),inst_34690,inst_34692,null));
var inst_34694 = [cljs.core.cst$kw$limit];
var inst_34695 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_34544);
var inst_34696 = [inst_34695];
var inst_34697 = cljs.core.PersistentHashMap.fromArrays(inst_34694,inst_34696);
var inst_34698 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34693,inst_34697);
var state_34803__$1 = state_34803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34803__$1,(78),inst_34698);
} else {
if((state_val_34804 === (99))){
var inst_34763 = (state_34803[(27)]);
var inst_34780 = (inst_34763 == null);
var inst_34781 = cljs.core.not(inst_34780);
var state_34803__$1 = state_34803;
if(inst_34781){
var statearr_34862_35015 = state_34803__$1;
(statearr_34862_35015[(1)] = (101));

} else {
var statearr_34863_35016 = state_34803__$1;
(statearr_34863_35016[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (21))){
var inst_34548 = (state_34803[(34)]);
var state_34803__$1 = state_34803;
var statearr_34864_35017 = state_34803__$1;
(statearr_34864_35017[(2)] = inst_34548);

(statearr_34864_35017[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (31))){
var inst_34565 = (state_34803[(26)]);
var state_34803__$1 = state_34803;
var statearr_34865_35018 = state_34803__$1;
(statearr_34865_35018[(2)] = inst_34565);

(statearr_34865_35018[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (32))){
var inst_34571 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34866_35019 = state_34803__$1;
(statearr_34866_35019[(2)] = inst_34571);

(statearr_34866_35019[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (40))){
var inst_34557 = (state_34803[(19)]);
var state_34803__$1 = state_34803;
var statearr_34867_35020 = state_34803__$1;
(statearr_34867_35020[(2)] = inst_34557);

(statearr_34867_35020[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (91))){
var inst_34752 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34868_35021 = state_34803__$1;
(statearr_34868_35021[(2)] = inst_34752);

(statearr_34868_35021[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (56))){
var inst_34758 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34869_35022 = state_34803__$1;
(statearr_34869_35022[(2)] = inst_34758);

(statearr_34869_35022[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (33))){
var inst_34562 = (state_34803[(20)]);
var inst_34579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34580 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_34562);
var state_34803__$1 = (function (){var statearr_34870 = state_34803;
(statearr_34870[(35)] = inst_34579);

return statearr_34870;
})();
if(cljs.core.truth_(inst_34580)){
var statearr_34871_35023 = state_34803__$1;
(statearr_34871_35023[(1)] = (36));

} else {
var statearr_34872_35024 = state_34803__$1;
(statearr_34872_35024[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (13))){
var inst_34529 = (state_34803[(11)]);
var state_34803__$1 = state_34803;
var statearr_34873_35025 = state_34803__$1;
(statearr_34873_35025[(2)] = inst_34529);

(statearr_34873_35025[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (22))){
var inst_34544 = (state_34803[(7)]);
var inst_34551 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_34544);
var state_34803__$1 = state_34803;
var statearr_34874_35026 = state_34803__$1;
(statearr_34874_35026[(2)] = inst_34551);

(statearr_34874_35026[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (90))){
var state_34803__$1 = state_34803;
var statearr_34875_35027 = state_34803__$1;
(statearr_34875_35027[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (36))){
var inst_34562 = (state_34803[(20)]);
var inst_34582 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_34562,cljs.core.dec);
var state_34803__$1 = state_34803;
var statearr_34877_35028 = state_34803__$1;
(statearr_34877_35028[(2)] = inst_34582);

(statearr_34877_35028[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (41))){
var inst_34602 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34602)){
var statearr_34878_35029 = state_34803__$1;
(statearr_34878_35029[(1)] = (45));

} else {
var statearr_34879_35030 = state_34803__$1;
(statearr_34879_35030[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (89))){
var inst_34735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34736 = [cljs.core.cst$kw$_id];
var inst_34737 = flake.o;
var inst_34738 = [inst_34737];
var inst_34739 = cljs.core.PersistentHashMap.fromArrays(inst_34736,inst_34738);
var inst_34740 = [inst_34739,offset_map];
var inst_34741 = (new cljs.core.PersistentVector(null,2,(5),inst_34735,inst_34740,null));
var state_34803__$1 = state_34803;
var statearr_34880_35031 = state_34803__$1;
(statearr_34880_35031[(2)] = inst_34741);

(statearr_34880_35031[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (100))){
var inst_34798 = (state_34803[(2)]);
var _ = (function (){var statearr_34881 = state_34803;
(statearr_34881[(4)] = cljs.core.rest((state_34803[(4)])));

return statearr_34881;
})();
var state_34803__$1 = state_34803;
var statearr_34882_35032 = state_34803__$1;
(statearr_34882_35032[(2)] = inst_34798);

(statearr_34882_35032[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (43))){
var inst_34592 = (state_34803[(29)]);
var state_34803__$1 = state_34803;
var statearr_34883_35033 = state_34803__$1;
(statearr_34883_35033[(2)] = inst_34592);

(statearr_34883_35033[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (61))){
var inst_34639 = (state_34803[(2)]);
var state_34803__$1 = (function (){var statearr_34884 = state_34803;
(statearr_34884[(13)] = inst_34639);

return statearr_34884;
})();
var statearr_34885_35034 = state_34803__$1;
(statearr_34885_35034[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (29))){
var inst_34574 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34887_35035 = state_34803__$1;
(statearr_34887_35035[(2)] = inst_34574);

(statearr_34887_35035[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (44))){
var inst_34599 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34888_35036 = state_34803__$1;
(statearr_34888_35036[(2)] = inst_34599);

(statearr_34888_35036[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (93))){
var state_34803__$1 = state_34803;
var statearr_34889_35037 = state_34803__$1;
(statearr_34889_35037[(2)] = null);

(statearr_34889_35037[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (6))){
var inst_34518 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_34519 = (inst_34518 == null);
var state_34803__$1 = state_34803;
var statearr_34890_35038 = state_34803__$1;
(statearr_34890_35038[(2)] = inst_34519);

(statearr_34890_35038[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (28))){
var inst_34561 = (state_34803[(18)]);
var state_34803__$1 = state_34803;
var statearr_34891_35039 = state_34803__$1;
(statearr_34891_35039[(2)] = inst_34561);

(statearr_34891_35039[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (64))){
var inst_34645 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34803__$1,(57),inst_34645);
} else {
if((state_val_34804 === (103))){
var inst_34796 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34892_35040 = state_34803__$1;
(statearr_34892_35040[(2)] = inst_34796);

(statearr_34892_35040[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (51))){
var inst_34610 = (state_34803[(33)]);
var state_34803__$1 = state_34803;
var statearr_34893_35041 = state_34803__$1;
(statearr_34893_35041[(2)] = inst_34610);

(statearr_34893_35041[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (25))){
var inst_34557 = (state_34803[(19)]);
var state_34803__$1 = state_34803;
var statearr_34894_35042 = state_34803__$1;
(statearr_34894_35042[(2)] = inst_34557);

(statearr_34894_35042[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (34))){
var inst_34557 = (state_34803[(19)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34557)){
var statearr_34895_35043 = state_34803__$1;
(statearr_34895_35043[(1)] = (39));

} else {
var statearr_34896_35044 = state_34803__$1;
(statearr_34896_35044[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (17))){
var inst_34544 = (state_34803[(7)]);
var inst_34545 = (state_34803[(36)]);
var inst_34544__$1 = (state_34803[(2)]);
var inst_34545__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_34544__$1);
var state_34803__$1 = (function (){var statearr_34897 = state_34803;
(statearr_34897[(7)] = inst_34544__$1);

(statearr_34897[(36)] = inst_34545__$1);

return statearr_34897;
})();
if(cljs.core.truth_(inst_34545__$1)){
var statearr_34898_35045 = state_34803__$1;
(statearr_34898_35045[(1)] = (18));

} else {
var statearr_34899_35046 = state_34803__$1;
(statearr_34899_35046[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (3))){
var inst_34801 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34803__$1,inst_34801);
} else {
if((state_val_34804 === (12))){
var inst_34529 = (state_34803[(11)]);
var inst_34534 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34529,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_34803__$1 = state_34803;
var statearr_34900_35047 = state_34803__$1;
(statearr_34900_35047[(2)] = inst_34534);

(statearr_34900_35047[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (2))){
var inst_34516 = (state_34803[(22)]);
var _ = (function (){var statearr_34901 = state_34803;
(statearr_34901[(4)] = cljs.core.cons((5),(state_34803[(4)])));

return statearr_34901;
})();
var inst_34515 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_34516__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_34803__$1 = (function (){var statearr_34902 = state_34803;
(statearr_34902[(14)] = inst_34515);

(statearr_34902[(22)] = inst_34516__$1);

return statearr_34902;
})();
if(cljs.core.truth_(inst_34516__$1)){
var statearr_34903_35048 = state_34803__$1;
(statearr_34903_35048[(1)] = (6));

} else {
var statearr_34904_35049 = state_34803__$1;
(statearr_34904_35049[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (66))){
var inst_34683 = (state_34803[(37)]);
var inst_34683__$1 = componentFollow_QMARK_;
var state_34803__$1 = (function (){var statearr_34905 = state_34803;
(statearr_34905[(37)] = inst_34683__$1);

return statearr_34905;
})();
if(cljs.core.truth_(inst_34683__$1)){
var statearr_34906_35050 = state_34803__$1;
(statearr_34906_35050[(1)] = (72));

} else {
var statearr_34907_35051 = state_34803__$1;
(statearr_34907_35051[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (23))){
var inst_34553 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34908_35052 = state_34803__$1;
(statearr_34908_35052[(2)] = inst_34553);

(statearr_34908_35052[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (47))){
var inst_34760 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34909_35053 = state_34803__$1;
(statearr_34909_35053[(2)] = inst_34760);

(statearr_34909_35053[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (35))){
var inst_34763 = (state_34803[(27)]);
var inst_34766 = (state_34803[(38)]);
var inst_34762 = (state_34803[(2)]);
var inst_34763__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34762,(0),null);
var inst_34764 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34762,(1),null);
var inst_34765 = (inst_34763__$1 == null);
var inst_34766__$1 = cljs.core.not(inst_34765);
var state_34803__$1 = (function (){var statearr_34910 = state_34803;
(statearr_34910[(27)] = inst_34763__$1);

(statearr_34910[(28)] = inst_34764);

(statearr_34910[(38)] = inst_34766__$1);

return statearr_34910;
})();
if(inst_34766__$1){
var statearr_34911_35054 = state_34803__$1;
(statearr_34911_35054[(1)] = (95));

} else {
var statearr_34912_35055 = state_34803__$1;
(statearr_34912_35055[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (82))){
var inst_34712 = (state_34803[(39)]);
var inst_34727 = (state_34803[(2)]);
var inst_34728 = fluree.db.util.async.throw_err(inst_34727);
var inst_34729 = [inst_34728,offset_map];
var inst_34730 = (new cljs.core.PersistentVector(null,2,(5),inst_34712,inst_34729,null));
var state_34803__$1 = state_34803;
var statearr_34913_35056 = state_34803__$1;
(statearr_34913_35056[(2)] = inst_34730);

(statearr_34913_35056[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (76))){
var inst_34558 = (state_34803[(12)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34558)){
var statearr_34914_35057 = state_34803__$1;
(statearr_34914_35057[(1)] = (89));

} else {
var statearr_34915_35058 = state_34803__$1;
(statearr_34915_35058[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (97))){
var inst_34770 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34770)){
var statearr_34916_35059 = state_34803__$1;
(statearr_34916_35059[(1)] = (98));

} else {
var statearr_34917_35060 = state_34803__$1;
(statearr_34917_35060[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (19))){
var inst_34544 = (state_34803[(7)]);
var inst_34548 = (state_34803[(34)]);
var inst_34548__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_34544);
var state_34803__$1 = (function (){var statearr_34918 = state_34803;
(statearr_34918[(34)] = inst_34548__$1);

return statearr_34918;
})();
if(cljs.core.truth_(inst_34548__$1)){
var statearr_34919_35061 = state_34803__$1;
(statearr_34919_35061[(1)] = (21));

} else {
var statearr_34920_35062 = state_34803__$1;
(statearr_34920_35062[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (57))){
var inst_34624 = (state_34803[(31)]);
var inst_34647 = (state_34803[(2)]);
var inst_34648 = fluree.db.util.async.throw_err(inst_34647);
var inst_34649 = [inst_34648,offset_map];
var inst_34650 = (new cljs.core.PersistentVector(null,2,(5),inst_34624,inst_34649,null));
var state_34803__$1 = state_34803;
var statearr_34921_35063 = state_34803__$1;
(statearr_34921_35063[(2)] = inst_34650);

(statearr_34921_35063[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (68))){
var inst_34661 = (state_34803[(8)]);
var state_34803__$1 = state_34803;
var statearr_34922_35064 = state_34803__$1;
(statearr_34922_35064[(2)] = inst_34661);

(statearr_34922_35064[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (11))){
var inst_34529 = (state_34803[(11)]);
var inst_34529__$1 = (state_34803[(2)]);
var inst_34531 = cljs.core.contains_QMARK_(inst_34529__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_34532 = (!(inst_34531));
var state_34803__$1 = (function (){var statearr_34924 = state_34803;
(statearr_34924[(11)] = inst_34529__$1);

return statearr_34924;
})();
if(inst_34532){
var statearr_34925_35065 = state_34803__$1;
(statearr_34925_35065[(1)] = (12));

} else {
var statearr_34926_35066 = state_34803__$1;
(statearr_34926_35066[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (9))){
var inst_34524 = flake.p;
var inst_34525 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_34526 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_34524,inst_34525);
var state_34803__$1 = state_34803;
var statearr_34927_35067 = state_34803__$1;
(statearr_34927_35067[(2)] = inst_34526);

(statearr_34927_35067[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (5))){
var _ = (function (){var statearr_34928 = state_34803;
(statearr_34928[(4)] = cljs.core.rest((state_34803[(4)])));

return statearr_34928;
})();
var state_34803__$1 = state_34803;
var ex34923 = (state_34803__$1[(2)]);
var statearr_34929_35068 = state_34803__$1;
(statearr_34929_35068[(5)] = ex34923);


if((ex34923 instanceof Error)){
var statearr_34930_35069 = state_34803__$1;
(statearr_34930_35069[(1)] = (4));

(statearr_34930_35069[(5)] = null);

} else {
throw ex34923;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (83))){
var inst_34701 = (state_34803[(25)]);
var inst_34715 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_34716 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_34715,inst_34701);
var state_34803__$1 = state_34803;
var statearr_34931_35070 = state_34803__$1;
(statearr_34931_35070[(2)] = inst_34716);

(statearr_34931_35070[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (14))){
var inst_34529 = (state_34803[(11)]);
var inst_34537 = (state_34803[(2)]);
var inst_34538 = cljs.core.contains_QMARK_(inst_34529,cljs.core.cst$kw$compact_QMARK_);
var inst_34539 = (!(inst_34538));
var state_34803__$1 = (function (){var statearr_34932 = state_34803;
(statearr_34932[(32)] = inst_34537);

return statearr_34932;
})();
if(inst_34539){
var statearr_34933_35071 = state_34803__$1;
(statearr_34933_35071[(1)] = (15));

} else {
var statearr_34934_35072 = state_34803__$1;
(statearr_34934_35072[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (45))){
var inst_34604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34605 = [null,offset_map];
var inst_34606 = (new cljs.core.PersistentVector(null,2,(5),inst_34604,inst_34605,null));
var state_34803__$1 = state_34803;
var statearr_34935_35073 = state_34803__$1;
(statearr_34935_35073[(2)] = inst_34606);

(statearr_34935_35073[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (53))){
var inst_34615 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34936_35074 = state_34803__$1;
(statearr_34936_35074[(2)] = inst_34615);

(statearr_34936_35074[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (78))){
var inst_34701 = (state_34803[(25)]);
var inst_34700 = (state_34803[(2)]);
var inst_34701__$1 = fluree.db.util.async.throw_err(inst_34700);
var inst_34702 = cljs.core.empty_QMARK_(inst_34701__$1);
var state_34803__$1 = (function (){var statearr_34937 = state_34803;
(statearr_34937[(25)] = inst_34701__$1);

return statearr_34937;
})();
if(inst_34702){
var statearr_34938_35075 = state_34803__$1;
(statearr_34938_35075[(1)] = (79));

} else {
var statearr_34939_35076 = state_34803__$1;
(statearr_34939_35076[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (26))){
var inst_34577 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34577)){
var statearr_34940_35077 = state_34803__$1;
(statearr_34940_35077[(1)] = (33));

} else {
var statearr_34941_35078 = state_34803__$1;
(statearr_34941_35078[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (16))){
var inst_34537 = (state_34803[(32)]);
var state_34803__$1 = state_34803;
var statearr_34942_35079 = state_34803__$1;
(statearr_34942_35079[(2)] = inst_34537);

(statearr_34942_35079[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (81))){
var inst_34732 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34943_35080 = state_34803__$1;
(statearr_34943_35080[(2)] = inst_34732);

(statearr_34943_35080[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (79))){
var inst_34704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34705 = [cljs.core.cst$kw$_id];
var inst_34706 = flake.o;
var inst_34707 = [inst_34706];
var inst_34708 = cljs.core.PersistentHashMap.fromArrays(inst_34705,inst_34707);
var inst_34709 = [inst_34708,offset_map];
var inst_34710 = (new cljs.core.PersistentVector(null,2,(5),inst_34704,inst_34709,null));
var state_34803__$1 = state_34803;
var statearr_34944_35081 = state_34803__$1;
(statearr_34944_35081[(2)] = inst_34710);

(statearr_34944_35081[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (38))){
var inst_34579 = (state_34803[(35)]);
var inst_34587 = (state_34803[(2)]);
var inst_34588 = [null,inst_34587];
var inst_34589 = (new cljs.core.PersistentVector(null,2,(5),inst_34579,inst_34588,null));
var state_34803__$1 = state_34803;
var statearr_34945_35082 = state_34803__$1;
(statearr_34945_35082[(2)] = inst_34589);

(statearr_34945_35082[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (98))){
var inst_34555 = (state_34803[(16)]);
var inst_34763 = (state_34803[(27)]);
var inst_34764 = (state_34803[(28)]);
var inst_34772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34773 = cljs.core.PersistentVector.EMPTY;
var inst_34774 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_34555,inst_34773);
var inst_34775 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34774,inst_34763);
var inst_34776 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_34555,inst_34775);
var inst_34777 = [inst_34776,inst_34764];
var inst_34778 = (new cljs.core.PersistentVector(null,2,(5),inst_34772,inst_34777,null));
var state_34803__$1 = state_34803;
var statearr_34946_35083 = state_34803__$1;
(statearr_34946_35083[(2)] = inst_34778);

(statearr_34946_35083[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (87))){
var inst_34719 = (state_34803[(24)]);
var state_34803__$1 = state_34803;
var statearr_34947_35084 = state_34803__$1;
(statearr_34947_35084[(2)] = inst_34719);

(statearr_34947_35084[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (30))){
var inst_34562 = (state_34803[(20)]);
var inst_34567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_34562);
var inst_34568 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_34567);
var state_34803__$1 = state_34803;
var statearr_34948_35085 = state_34803__$1;
(statearr_34948_35085[(2)] = inst_34568);

(statearr_34948_35085[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (73))){
var inst_34683 = (state_34803[(37)]);
var state_34803__$1 = state_34803;
var statearr_34949_35086 = state_34803__$1;
(statearr_34949_35086[(2)] = inst_34683);

(statearr_34949_35086[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (96))){
var inst_34766 = (state_34803[(38)]);
var state_34803__$1 = state_34803;
var statearr_34950_35087 = state_34803__$1;
(statearr_34950_35087[(2)] = inst_34766);

(statearr_34950_35087[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (10))){
var state_34803__$1 = state_34803;
var statearr_34951_35088 = state_34803__$1;
(statearr_34951_35088[(2)] = pred_spec);

(statearr_34951_35088[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (18))){
var inst_34545 = (state_34803[(36)]);
var state_34803__$1 = state_34803;
var statearr_34952_35089 = state_34803__$1;
(statearr_34952_35089[(2)] = inst_34545);

(statearr_34952_35089[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (105))){
var state_34803__$1 = state_34803;
var statearr_34953_35090 = state_34803__$1;
(statearr_34953_35090[(2)] = null);

(statearr_34953_35090[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (52))){
var inst_34544 = (state_34803[(7)]);
var inst_34613 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_34544);
var state_34803__$1 = state_34803;
var statearr_34954_35091 = state_34803__$1;
(statearr_34954_35091[(2)] = inst_34613);

(statearr_34954_35091[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (67))){
var inst_34756 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34955_35092 = state_34803__$1;
(statearr_34955_35092[(2)] = inst_34756);

(statearr_34955_35092[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (71))){
var inst_34544 = (state_34803[(7)]);
var inst_34668 = (state_34803[(2)]);
var inst_34669 = fluree.db.util.async.throw_err(inst_34668);
var inst_34670 = cljs.core._deref(cache);
var inst_34671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34672 = flake.o;
var inst_34673 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_34544);
var inst_34674 = [inst_34672,inst_34673];
var inst_34675 = (new cljs.core.PersistentVector(null,2,(5),inst_34671,inst_34674,null));
var inst_34676 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34670,inst_34675,inst_34669);
var inst_34677 = cljs.core._vreset_BANG_(cache,inst_34676);
var state_34803__$1 = (function (){var statearr_34956 = state_34803;
(statearr_34956[(40)] = inst_34677);

return statearr_34956;
})();
var statearr_34957_35093 = state_34803__$1;
(statearr_34957_35093[(2)] = inst_34669);

(statearr_34957_35093[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (42))){
var inst_34559 = (state_34803[(15)]);
var inst_34555 = (state_34803[(16)]);
var inst_34594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_34555);
var inst_34595 = cljs.core.count(inst_34594);
var inst_34596 = (inst_34595 >= inst_34559);
var state_34803__$1 = state_34803;
var statearr_34958_35094 = state_34803__$1;
(statearr_34958_35094[(2)] = inst_34596);

(statearr_34958_35094[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (80))){
var inst_34712 = cljs.core.PersistentVector.EMPTY_NODE;
var state_34803__$1 = (function (){var statearr_34959 = state_34803;
(statearr_34959[(39)] = inst_34712);

return statearr_34959;
})();
if(cljs.core.truth_(fuel)){
var statearr_34960_35095 = state_34803__$1;
(statearr_34960_35095[(1)] = (83));

} else {
var statearr_34961_35096 = state_34803__$1;
(statearr_34961_35096[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (37))){
var inst_34561 = (state_34803[(18)]);
var inst_34562 = (state_34803[(20)]);
var inst_34584 = (inst_34561 - (1));
var inst_34585 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_34562,inst_34584);
var state_34803__$1 = state_34803;
var statearr_34962_35097 = state_34803__$1;
(statearr_34962_35097[(2)] = inst_34585);

(statearr_34962_35097[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (63))){
var inst_34639 = (state_34803[(13)]);
var state_34803__$1 = state_34803;
var statearr_34963_35098 = state_34803__$1;
(statearr_34963_35098[(2)] = inst_34639);

(statearr_34963_35098[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (94))){
var inst_34750 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
var statearr_34964_35099 = state_34803__$1;
(statearr_34964_35099[(2)] = inst_34750);

(statearr_34964_35099[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (8))){
var inst_34522 = (state_34803[(2)]);
var state_34803__$1 = state_34803;
if(cljs.core.truth_(inst_34522)){
var statearr_34965_35100 = state_34803__$1;
(statearr_34965_35100[(1)] = (9));

} else {
var statearr_34966_35101 = state_34803__$1;
(statearr_34966_35101[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (49))){
var inst_34608 = (state_34803[(30)]);
var state_34803__$1 = state_34803;
var statearr_34967_35102 = state_34803__$1;
(statearr_34967_35102[(2)] = inst_34608);

(statearr_34967_35102[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34804 === (84))){
var inst_34701 = (state_34803[(25)]);
var state_34803__$1 = state_34803;
var statearr_34968_35103 = state_34803__$1;
(statearr_34968_35103[(2)] = inst_34701);

(statearr_34968_35103[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__14778__auto__ = null;
var fluree$db$query$fql$state_machine__14778__auto____0 = (function (){
var statearr_34969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34969[(0)] = fluree$db$query$fql$state_machine__14778__auto__);

(statearr_34969[(1)] = (1));

return statearr_34969;
});
var fluree$db$query$fql$state_machine__14778__auto____1 = (function (state_34803){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_34803);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e34970){var ex__14781__auto__ = e34970;
var statearr_34971_35104 = state_34803;
(statearr_34971_35104[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_34803[(4)]))){
var statearr_34972_35105 = state_34803;
(statearr_34972_35105[(1)] = cljs.core.first((state_34803[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__35106 = state_34803;
state_34803 = G__35106;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__14778__auto__ = function(state_34803){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__14778__auto____1.call(this,state_34803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__14778__auto____0;
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__14778__auto____1;
return fluree$db$query$fql$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_34973 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_34973[(6)] = c__14852__auto__);

return statearr_34973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_35266){
var state_val_35267 = (state_35266[(1)]);
if((state_val_35267 === (7))){
var inst_35261 = (state_35266[(2)]);
var _ = (function (){var statearr_35268 = state_35266;
(statearr_35268[(4)] = cljs.core.rest((state_35266[(4)])));

return statearr_35268;
})();
var state_35266__$1 = state_35266;
var statearr_35269_35351 = state_35266__$1;
(statearr_35269_35351[(2)] = inst_35261);

(statearr_35269_35351[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (20))){
var inst_35188 = (state_35266[(7)]);
var state_35266__$1 = state_35266;
var statearr_35270_35352 = state_35266__$1;
(statearr_35270_35352[(2)] = inst_35188);

(statearr_35270_35352[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (27))){
var inst_35143 = (state_35266[(8)]);
var state_35266__$1 = state_35266;
if(cljs.core.truth_(inst_35143)){
var statearr_35271_35353 = state_35266__$1;
(statearr_35271_35353[(1)] = (29));

} else {
var statearr_35272_35354 = state_35266__$1;
(statearr_35272_35354[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (1))){
var state_35266__$1 = state_35266;
var statearr_35273_35355 = state_35266__$1;
(statearr_35273_35355[(2)] = null);

(statearr_35273_35355[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (24))){
var inst_35144 = (state_35266[(9)]);
var state_35266__$1 = state_35266;
var statearr_35274_35356 = state_35266__$1;
(statearr_35274_35356[(2)] = inst_35144);

(statearr_35274_35356[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (39))){
var inst_35180 = (state_35266[(10)]);
var state_35266__$1 = state_35266;
var statearr_35275_35357 = state_35266__$1;
(statearr_35275_35357[(2)] = inst_35180);

(statearr_35275_35357[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (46))){
var inst_35145 = (state_35266[(11)]);
var state_35266__$1 = state_35266;
var statearr_35276_35358 = state_35266__$1;
(statearr_35276_35358[(2)] = inst_35145);

(statearr_35276_35358[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (4))){
var inst_35107 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
var statearr_35277_35359 = state_35266__$1;
(statearr_35277_35359[(2)] = inst_35107);

(statearr_35277_35359[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (15))){
var inst_35156 = (state_35266[(12)]);
var inst_35162 = cljs.core.count(inst_35156);
var inst_35163 = fluree.db.query.fql.add_fuel(fuel,inst_35162,max_fuel);
var state_35266__$1 = state_35266;
var statearr_35278_35360 = state_35266__$1;
(statearr_35278_35360[(2)] = inst_35163);

(statearr_35278_35360[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (48))){
var inst_35247 = (state_35266[(13)]);
var inst_35132 = (state_35266[(14)]);
var inst_35125 = (state_35266[(15)]);
var inst_35255 = (state_35266[(2)]);
var inst_35256 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35125,inst_35255,inst_35247);
var inst_35124 = inst_35132;
var inst_35125__$1 = inst_35256;
var state_35266__$1 = (function (){var statearr_35279 = state_35266;
(statearr_35279[(16)] = inst_35124);

(statearr_35279[(15)] = inst_35125__$1);

return statearr_35279;
})();
var statearr_35280_35361 = state_35266__$1;
(statearr_35280_35361[(2)] = null);

(statearr_35280_35361[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (50))){
var inst_35147 = (state_35266[(17)]);
var state_35266__$1 = state_35266;
var statearr_35281_35362 = state_35266__$1;
(statearr_35281_35362[(2)] = inst_35147);

(statearr_35281_35362[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (21))){
var inst_35144 = (state_35266[(9)]);
var state_35266__$1 = state_35266;
if(cljs.core.truth_(inst_35144)){
var statearr_35283_35363 = state_35266__$1;
(statearr_35283_35363[(1)] = (23));

} else {
var statearr_35284_35364 = state_35266__$1;
(statearr_35284_35364[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (31))){
var inst_35204 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
if(cljs.core.truth_(inst_35204)){
var statearr_35285_35365 = state_35266__$1;
(statearr_35285_35365[(1)] = (32));

} else {
var statearr_35286_35366 = state_35266__$1;
(statearr_35286_35366[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (32))){
var inst_35187 = (state_35266[(18)]);
var inst_35180 = (state_35266[(10)]);
var inst_35179 = (state_35266[(19)]);
var inst_35206 = (inst_35179 + (1));
var tmp35282 = inst_35180;
var inst_35178 = inst_35187;
var inst_35179__$1 = inst_35206;
var inst_35180__$1 = tmp35282;
var state_35266__$1 = (function (){var statearr_35287 = state_35266;
(statearr_35287[(10)] = inst_35180__$1);

(statearr_35287[(19)] = inst_35179__$1);

(statearr_35287[(20)] = inst_35178);

return statearr_35287;
})();
var statearr_35288_35367 = state_35266__$1;
(statearr_35288_35367[(2)] = null);

(statearr_35288_35367[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (40))){
var state_35266__$1 = state_35266;
if(cljs.core.truth_(fuel)){
var statearr_35289_35368 = state_35266__$1;
(statearr_35289_35368[(1)] = (42));

} else {
var statearr_35290_35369 = state_35266__$1;
(statearr_35290_35369[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (33))){
var state_35266__$1 = state_35266;
var statearr_35291_35370 = state_35266__$1;
(statearr_35291_35370[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (13))){
var inst_35156 = (state_35266[(12)]);
var state_35266__$1 = state_35266;
var statearr_35293_35371 = state_35266__$1;
(statearr_35293_35371[(2)] = inst_35156);

(statearr_35293_35371[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (22))){
var inst_35197 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
if(cljs.core.truth_(inst_35197)){
var statearr_35294_35372 = state_35266__$1;
(statearr_35294_35372[(1)] = (26));

} else {
var statearr_35295_35373 = state_35266__$1;
(statearr_35295_35373[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (36))){
var state_35266__$1 = state_35266;
var statearr_35296_35374 = state_35266__$1;
(statearr_35296_35374[(2)] = null);

(statearr_35296_35374[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (41))){
var inst_35187 = (state_35266[(18)]);
var inst_35179 = (state_35266[(19)]);
var inst_35236 = (state_35266[(2)]);
var inst_35237 = (inst_35179 + (1));
var inst_35178 = inst_35187;
var inst_35179__$1 = inst_35237;
var inst_35180 = inst_35236;
var state_35266__$1 = (function (){var statearr_35297 = state_35266;
(statearr_35297[(10)] = inst_35180);

(statearr_35297[(19)] = inst_35179__$1);

(statearr_35297[(20)] = inst_35178);

return statearr_35297;
})();
var statearr_35298_35375 = state_35266__$1;
(statearr_35298_35375[(2)] = null);

(statearr_35298_35375[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (43))){
var state_35266__$1 = state_35266;
var statearr_35299_35376 = state_35266__$1;
(statearr_35299_35376[(2)] = null);

(statearr_35299_35376[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (29))){
var inst_35179 = (state_35266[(19)]);
var inst_35143 = (state_35266[(8)]);
var inst_35201 = (inst_35179 < inst_35143);
var state_35266__$1 = state_35266;
var statearr_35300_35377 = state_35266__$1;
(statearr_35300_35377[(2)] = inst_35201);

(statearr_35300_35377[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (44))){
var inst_35216 = (state_35266[(21)]);
var inst_35220 = (state_35266[(22)]);
var inst_35229 = (state_35266[(2)]);
var inst_35230 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_35220,inst_35216) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_35220,inst_35216));
var state_35266__$1 = (function (){var statearr_35301 = state_35266;
(statearr_35301[(23)] = inst_35229);

return statearr_35301;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35266__$1,(45),inst_35230);
} else {
if((state_val_35267 === (6))){
var inst_35131 = (state_35266[(24)]);
var inst_35124 = (state_35266[(16)]);
var inst_35130 = cljs.core.seq(inst_35124);
var inst_35131__$1 = cljs.core.first(inst_35130);
var inst_35132 = cljs.core.next(inst_35130);
var inst_35133 = cljs.core.not(inst_35131__$1);
var state_35266__$1 = (function (){var statearr_35302 = state_35266;
(statearr_35302[(24)] = inst_35131__$1);

(statearr_35302[(14)] = inst_35132);

return statearr_35302;
})();
if(inst_35133){
var statearr_35303_35378 = state_35266__$1;
(statearr_35303_35378[(1)] = (8));

} else {
var statearr_35304_35379 = state_35266__$1;
(statearr_35304_35379[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (28))){
var inst_35245 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
var statearr_35305_35380 = state_35266__$1;
(statearr_35305_35380[(2)] = inst_35245);

(statearr_35305_35380[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (51))){
var inst_35253 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
var statearr_35306_35381 = state_35266__$1;
(statearr_35306_35381[(2)] = inst_35253);

(statearr_35306_35381[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (25))){
var inst_35195 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
var statearr_35307_35382 = state_35266__$1;
(statearr_35307_35382[(2)] = inst_35195);

(statearr_35307_35382[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (34))){
var inst_35243 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
var statearr_35308_35383 = state_35266__$1;
(statearr_35308_35383[(2)] = inst_35243);

(statearr_35308_35383[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (17))){
var inst_35156 = (state_35266[(12)]);
var inst_35166 = (state_35266[(2)]);
var inst_35174 = cljs.core.seq(inst_35156);
var inst_35175 = cljs.core.first(inst_35174);
var inst_35176 = cljs.core.next(inst_35174);
var inst_35177 = cljs.core.PersistentVector.EMPTY;
var inst_35178 = inst_35156;
var inst_35179 = (0);
var inst_35180 = inst_35177;
var state_35266__$1 = (function (){var statearr_35309 = state_35266;
(statearr_35309[(10)] = inst_35180);

(statearr_35309[(19)] = inst_35179);

(statearr_35309[(25)] = inst_35166);

(statearr_35309[(26)] = inst_35175);

(statearr_35309[(20)] = inst_35178);

(statearr_35309[(27)] = inst_35176);

return statearr_35309;
})();
var statearr_35310_35384 = state_35266__$1;
(statearr_35310_35384[(2)] = null);

(statearr_35310_35384[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (3))){
var inst_35264 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35266__$1,inst_35264);
} else {
if((state_val_35267 === (12))){
var state_35266__$1 = state_35266;
var statearr_35311_35385 = state_35266__$1;
(statearr_35311_35385[(2)] = fuel);

(statearr_35311_35385[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (2))){
var _ = (function (){var statearr_35312 = state_35266;
(statearr_35312[(4)] = cljs.core.cons((5),(state_35266[(4)])));

return statearr_35312;
})();
var inst_35120 = reverse_refs_specs;
var inst_35121 = cljs.core.seq(inst_35120);
var inst_35122 = cljs.core.first(inst_35121);
var inst_35123 = cljs.core.next(inst_35121);
var inst_35124 = inst_35120;
var inst_35125 = null;
var state_35266__$1 = (function (){var statearr_35313 = state_35266;
(statearr_35313[(28)] = inst_35122);

(statearr_35313[(29)] = inst_35123);

(statearr_35313[(16)] = inst_35124);

(statearr_35313[(15)] = inst_35125);

return statearr_35313;
})();
var statearr_35314_35386 = state_35266__$1;
(statearr_35314_35386[(2)] = null);

(statearr_35314_35386[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (23))){
var inst_35144 = (state_35266[(9)]);
var inst_35179 = (state_35266[(19)]);
var inst_35192 = (inst_35179 >= inst_35144);
var state_35266__$1 = state_35266;
var statearr_35315_35387 = state_35266__$1;
(statearr_35315_35387[(2)] = inst_35192);

(statearr_35315_35387[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (47))){
var inst_35146 = (state_35266[(30)]);
var state_35266__$1 = state_35266;
if(cljs.core.truth_(inst_35146)){
var statearr_35316_35388 = state_35266__$1;
(statearr_35316_35388[(1)] = (49));

} else {
var statearr_35317_35389 = state_35266__$1;
(statearr_35317_35389[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (35))){
var inst_35186 = (state_35266[(31)]);
var inst_35210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35211 = [inst_35186];
var inst_35212 = (new cljs.core.PersistentVector(null,1,(5),inst_35210,inst_35211,null));
var inst_35213 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35212);
var state_35266__$1 = state_35266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35266__$1,(38),inst_35213);
} else {
if((state_val_35267 === (19))){
var inst_35145 = (state_35266[(11)]);
var inst_35247 = (state_35266[(2)]);
var state_35266__$1 = (function (){var statearr_35318 = state_35266;
(statearr_35318[(13)] = inst_35247);

return statearr_35318;
})();
if(cljs.core.truth_(inst_35145)){
var statearr_35319_35390 = state_35266__$1;
(statearr_35319_35390[(1)] = (46));

} else {
var statearr_35320_35391 = state_35266__$1;
(statearr_35320_35391[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (11))){
var inst_35156 = (state_35266[(12)]);
var inst_35153 = (state_35266[(2)]);
var inst_35154 = fluree.db.util.async.throw_err(inst_35153);
var inst_35155 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_35154);
var inst_35156__$1 = cljs.core.not_empty(inst_35155);
var state_35266__$1 = (function (){var statearr_35322 = state_35266;
(statearr_35322[(12)] = inst_35156__$1);

return statearr_35322;
})();
if(cljs.core.truth_(inst_35156__$1)){
var statearr_35323_35392 = state_35266__$1;
(statearr_35323_35392[(1)] = (12));

} else {
var statearr_35324_35393 = state_35266__$1;
(statearr_35324_35393[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (9))){
var inst_35131 = (state_35266[(24)]);
var inst_35141 = (state_35266[(32)]);
var inst_35140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35131,(0),null);
var inst_35141__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35131,(1),null);
var inst_35142 = cljs.core.__destructure_map(inst_35141__$1);
var inst_35143 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35142,cljs.core.cst$kw$offset);
var inst_35144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35142,cljs.core.cst$kw$limit);
var inst_35145 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35142,cljs.core.cst$kw$as);
var inst_35146 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35142,cljs.core.cst$kw$name);
var inst_35147 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35142,cljs.core.cst$kw$p);
var inst_35148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35149 = [subject_id,inst_35140];
var inst_35150 = (new cljs.core.PersistentVector(null,2,(5),inst_35148,inst_35149,null));
var inst_35151 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_35150);
var state_35266__$1 = (function (){var statearr_35325 = state_35266;
(statearr_35325[(9)] = inst_35144);

(statearr_35325[(11)] = inst_35145);

(statearr_35325[(30)] = inst_35146);

(statearr_35325[(8)] = inst_35143);

(statearr_35325[(17)] = inst_35147);

(statearr_35325[(32)] = inst_35141__$1);

return statearr_35325;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35266__$1,(11),inst_35151);
} else {
if((state_val_35267 === (5))){
var _ = (function (){var statearr_35326 = state_35266;
(statearr_35326[(4)] = cljs.core.rest((state_35266[(4)])));

return statearr_35326;
})();
var state_35266__$1 = state_35266;
var ex35321 = (state_35266__$1[(2)]);
var statearr_35327_35394 = state_35266__$1;
(statearr_35327_35394[(5)] = ex35321);


if((ex35321 instanceof Error)){
var statearr_35328_35395 = state_35266__$1;
(statearr_35328_35395[(1)] = (4));

(statearr_35328_35395[(5)] = null);

} else {
throw ex35321;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (14))){
var inst_35160 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
if(cljs.core.truth_(inst_35160)){
var statearr_35329_35396 = state_35266__$1;
(statearr_35329_35396[(1)] = (15));

} else {
var statearr_35330_35397 = state_35266__$1;
(statearr_35330_35397[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (45))){
var inst_35180 = (state_35266[(10)]);
var inst_35232 = (state_35266[(2)]);
var inst_35233 = fluree.db.util.async.throw_err(inst_35232);
var inst_35234 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35180,inst_35233);
var state_35266__$1 = state_35266;
var statearr_35331_35398 = state_35266__$1;
(statearr_35331_35398[(2)] = inst_35234);

(statearr_35331_35398[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (26))){
var inst_35180 = (state_35266[(10)]);
var state_35266__$1 = state_35266;
var statearr_35332_35399 = state_35266__$1;
(statearr_35332_35399[(2)] = inst_35180);

(statearr_35332_35399[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (16))){
var state_35266__$1 = state_35266;
var statearr_35333_35400 = state_35266__$1;
(statearr_35333_35400[(2)] = null);

(statearr_35333_35400[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (38))){
var inst_35216 = (state_35266[(21)]);
var inst_35141 = (state_35266[(32)]);
var inst_35215 = (state_35266[(2)]);
var inst_35216__$1 = fluree.db.util.async.throw_err(inst_35215);
var inst_35217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35218 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_35219 = (new cljs.core.PersistentVector(null,4,(5),inst_35217,inst_35218,null));
var inst_35220 = cljs.core.select_keys(inst_35141,inst_35219);
var inst_35221 = cljs.core.empty_QMARK_(inst_35216__$1);
var state_35266__$1 = (function (){var statearr_35334 = state_35266;
(statearr_35334[(21)] = inst_35216__$1);

(statearr_35334[(22)] = inst_35220);

return statearr_35334;
})();
if(inst_35221){
var statearr_35335_35401 = state_35266__$1;
(statearr_35335_35401[(1)] = (39));

} else {
var statearr_35336_35402 = state_35266__$1;
(statearr_35336_35402[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (30))){
var inst_35143 = (state_35266[(8)]);
var state_35266__$1 = state_35266;
var statearr_35337_35403 = state_35266__$1;
(statearr_35337_35403[(2)] = inst_35143);

(statearr_35337_35403[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (10))){
var inst_35259 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
var statearr_35338_35404 = state_35266__$1;
(statearr_35338_35404[(2)] = inst_35259);

(statearr_35338_35404[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (18))){
var inst_35188 = (state_35266[(7)]);
var inst_35186 = (state_35266[(31)]);
var inst_35178 = (state_35266[(20)]);
var inst_35185 = cljs.core.seq(inst_35178);
var inst_35186__$1 = cljs.core.first(inst_35185);
var inst_35187 = cljs.core.next(inst_35185);
var inst_35188__$1 = cljs.core.not(inst_35186__$1);
var state_35266__$1 = (function (){var statearr_35339 = state_35266;
(statearr_35339[(18)] = inst_35187);

(statearr_35339[(7)] = inst_35188__$1);

(statearr_35339[(31)] = inst_35186__$1);

return statearr_35339;
})();
if(inst_35188__$1){
var statearr_35340_35405 = state_35266__$1;
(statearr_35340_35405[(1)] = (20));

} else {
var statearr_35341_35406 = state_35266__$1;
(statearr_35341_35406[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (42))){
var inst_35216 = (state_35266[(21)]);
var inst_35225 = cljs.core.count(inst_35216);
var inst_35226 = fluree.db.query.fql.add_fuel(fuel,inst_35225,max_fuel);
var state_35266__$1 = state_35266;
var statearr_35342_35407 = state_35266__$1;
(statearr_35342_35407[(2)] = inst_35226);

(statearr_35342_35407[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (37))){
var inst_35241 = (state_35266[(2)]);
var state_35266__$1 = state_35266;
var statearr_35343_35408 = state_35266__$1;
(statearr_35343_35408[(2)] = inst_35241);

(statearr_35343_35408[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (8))){
var inst_35125 = (state_35266[(15)]);
var state_35266__$1 = state_35266;
var statearr_35344_35409 = state_35266__$1;
(statearr_35344_35409[(2)] = inst_35125);

(statearr_35344_35409[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35267 === (49))){
var inst_35146 = (state_35266[(30)]);
var state_35266__$1 = state_35266;
var statearr_35345_35410 = state_35266__$1;
(statearr_35345_35410[(2)] = inst_35146);

(statearr_35345_35410[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto____0 = (function (){
var statearr_35346 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35346[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto__);

(statearr_35346[(1)] = (1));

return statearr_35346;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto____1 = (function (state_35266){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_35266);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e35347){var ex__14781__auto__ = e35347;
var statearr_35348_35411 = state_35266;
(statearr_35348_35411[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_35266[(4)]))){
var statearr_35349_35412 = state_35266;
(statearr_35349_35412[(1)] = cljs.core.first((state_35266[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__35413 = state_35266;
state_35266 = G__35413;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto__ = function(state_35266){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto____1.call(this,state_35266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_35350 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_35350[(6)] = c__14852__auto__);

return statearr_35350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__35414 = select_spec;
var map__35414__$1 = cljs.core.__destructure_map(map__35414);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35414__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35414__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_35476){
var state_val_35477 = (state_35476[(1)]);
if((state_val_35477 === (7))){
var inst_35440 = (state_35476[(7)]);
var inst_35442 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_35443 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35442,inst_35440);
var state_35476__$1 = state_35476;
var statearr_35478_35517 = state_35476__$1;
(statearr_35478_35517[(2)] = inst_35443);

(statearr_35478_35517[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (20))){
var inst_35446 = (state_35476[(8)]);
var inst_35464 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_35465 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_35464,inst_35446) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_35464,inst_35446));
var state_35476__$1 = state_35476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35476__$1,(22),inst_35465);
} else {
if((state_val_35477 === (1))){
var state_35476__$1 = state_35476;
var statearr_35479_35518 = state_35476__$1;
(statearr_35479_35518[(2)] = null);

(statearr_35479_35518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (4))){
var inst_35415 = (state_35476[(2)]);
var state_35476__$1 = state_35476;
var statearr_35480_35519 = state_35476__$1;
(statearr_35480_35519[(2)] = inst_35415);

(statearr_35480_35519[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (15))){
var inst_35453 = (state_35476[(2)]);
var state_35476__$1 = state_35476;
var statearr_35481_35520 = state_35476__$1;
(statearr_35481_35520[(2)] = inst_35453);

(statearr_35481_35520[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (21))){
var inst_35471 = (state_35476[(2)]);
var _ = (function (){var statearr_35482 = state_35476;
(statearr_35482[(4)] = cljs.core.rest((state_35476[(4)])));

return statearr_35482;
})();
var state_35476__$1 = state_35476;
var statearr_35483_35521 = state_35476__$1;
(statearr_35483_35521[(2)] = inst_35471);

(statearr_35483_35521[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (13))){
var inst_35432 = (state_35476[(9)]);
var state_35476__$1 = state_35476;
var statearr_35484_35522 = state_35476__$1;
(statearr_35484_35522[(2)] = inst_35432);

(statearr_35484_35522[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (22))){
var inst_35461 = (state_35476[(10)]);
var inst_35426 = (state_35476[(11)]);
var inst_35467 = (state_35476[(2)]);
var inst_35468 = fluree.db.util.async.throw_err(inst_35467);
var inst_35469 = (inst_35461.cljs$core$IFn$_invoke$arity$3 ? inst_35461.cljs$core$IFn$_invoke$arity$3(acc,inst_35426,inst_35468) : inst_35461.call(null,acc,inst_35426,inst_35468));
var state_35476__$1 = state_35476;
var statearr_35485_35523 = state_35476__$1;
(statearr_35485_35523[(2)] = inst_35469);

(statearr_35485_35523[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (6))){
var inst_35439 = (state_35476[(2)]);
var inst_35440 = fluree.db.util.async.throw_err(inst_35439);
var state_35476__$1 = (function (){var statearr_35486 = state_35476;
(statearr_35486[(7)] = inst_35440);

return statearr_35486;
})();
if(cljs.core.truth_(fuel)){
var statearr_35487_35524 = state_35476__$1;
(statearr_35487_35524[(1)] = (7));

} else {
var statearr_35488_35525 = state_35476__$1;
(statearr_35488_35525[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (17))){
var inst_35428 = (state_35476[(12)]);
var inst_35446 = (state_35476[(8)]);
var inst_35424 = (state_35476[(13)]);
var inst_35431 = (state_35476[(14)]);
var inst_35422 = (state_35476[(15)]);
var inst_35426 = (state_35476[(11)]);
var inst_35455 = (state_35476[(16)]);
var inst_35427 = (state_35476[(17)]);
var inst_35430 = (state_35476[(18)]);
var inst_35432 = (state_35476[(9)]);
var inst_35429 = (state_35476[(19)]);
var inst_35425 = (state_35476[(20)]);
var inst_35459 = (function (){var recur_seen = inst_35428;
var recur_subject = inst_35422;
var sub_flakes = inst_35446;
var seen_QMARK_ = inst_35431;
var multi_QMARK_ = inst_35425;
var limit = inst_35430;
var recur_depth = inst_35429;
var as = inst_35426;
var max_depth_QMARK_ = inst_35432;
var recur = inst_35427;
var stop_QMARK_ = inst_35455;
var map__35421 = inst_35424;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_35476__$1 = state_35476;
var statearr_35489_35526 = state_35476__$1;
(statearr_35489_35526[(2)] = inst_35459);

(statearr_35489_35526[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (3))){
var inst_35474 = (state_35476[(2)]);
var state_35476__$1 = state_35476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35476__$1,inst_35474);
} else {
if((state_val_35477 === (12))){
var inst_35425 = (state_35476[(20)]);
var inst_35455 = (state_35476[(2)]);
var state_35476__$1 = (function (){var statearr_35490 = state_35476;
(statearr_35490[(16)] = inst_35455);

return statearr_35490;
})();
if(cljs.core.truth_(inst_35425)){
var statearr_35491_35527 = state_35476__$1;
(statearr_35491_35527[(1)] = (16));

} else {
var statearr_35492_35528 = state_35476__$1;
(statearr_35492_35528[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (2))){
var inst_35428 = (state_35476[(12)]);
var inst_35424 = (state_35476[(13)]);
var inst_35422 = (state_35476[(15)]);
var inst_35427 = (state_35476[(17)]);
var inst_35429 = (state_35476[(19)]);
var _ = (function (){var statearr_35493 = state_35476;
(statearr_35493[(4)] = cljs.core.cons((5),(state_35476[(4)])));

return statearr_35493;
})();
var inst_35422__$1 = flake.o;
var inst_35423 = select_spec;
var inst_35424__$1 = cljs.core.__destructure_map(inst_35423);
var inst_35425 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35424__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_35426 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35424__$1,cljs.core.cst$kw$as);
var inst_35427__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35424__$1,cljs.core.cst$kw$recur);
var inst_35428__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35424__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_35429__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35424__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_35430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35424__$1,cljs.core.cst$kw$limit);
var inst_35431 = cljs.core.contains_QMARK_(inst_35428__$1,inst_35422__$1);
var inst_35432 = (inst_35429__$1 > inst_35427__$1);
var inst_35434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35435 = [inst_35422__$1];
var inst_35436 = (new cljs.core.PersistentVector(null,1,(5),inst_35434,inst_35435,null));
var inst_35437 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35436);
var state_35476__$1 = (function (){var statearr_35494 = state_35476;
(statearr_35494[(12)] = inst_35428__$1);

(statearr_35494[(13)] = inst_35424__$1);

(statearr_35494[(14)] = inst_35431);

(statearr_35494[(15)] = inst_35422__$1);

(statearr_35494[(11)] = inst_35426);

(statearr_35494[(17)] = inst_35427__$1);

(statearr_35494[(18)] = inst_35430);

(statearr_35494[(9)] = inst_35432);

(statearr_35494[(19)] = inst_35429__$1);

(statearr_35494[(20)] = inst_35425);

return statearr_35494;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35476__$1,(6),inst_35437);
} else {
if((state_val_35477 === (19))){
var state_35476__$1 = state_35476;
var statearr_35495_35529 = state_35476__$1;
(statearr_35495_35529[(2)] = acc);

(statearr_35495_35529[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (11))){
var inst_35432 = (state_35476[(9)]);
var state_35476__$1 = state_35476;
if(cljs.core.truth_(inst_35432)){
var statearr_35497_35530 = state_35476__$1;
(statearr_35497_35530[(1)] = (13));

} else {
var statearr_35498_35531 = state_35476__$1;
(statearr_35498_35531[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (9))){
var inst_35431 = (state_35476[(14)]);
var inst_35446 = (state_35476[(2)]);
var state_35476__$1 = (function (){var statearr_35499 = state_35476;
(statearr_35499[(8)] = inst_35446);

return statearr_35499;
})();
if(cljs.core.truth_(inst_35431)){
var statearr_35500_35532 = state_35476__$1;
(statearr_35500_35532[(1)] = (10));

} else {
var statearr_35501_35533 = state_35476__$1;
(statearr_35501_35533[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (5))){
var _ = (function (){var statearr_35502 = state_35476;
(statearr_35502[(4)] = cljs.core.rest((state_35476[(4)])));

return statearr_35502;
})();
var state_35476__$1 = state_35476;
var ex35496 = (state_35476__$1[(2)]);
var statearr_35503_35534 = state_35476__$1;
(statearr_35503_35534[(5)] = ex35496);


if((ex35496 instanceof Error)){
var statearr_35504_35535 = state_35476__$1;
(statearr_35504_35535[(1)] = (4));

(statearr_35504_35535[(5)] = null);

} else {
throw ex35496;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (14))){
var inst_35446 = (state_35476[(8)]);
var inst_35451 = cljs.core.empty_QMARK_(inst_35446);
var state_35476__$1 = state_35476;
var statearr_35505_35536 = state_35476__$1;
(statearr_35505_35536[(2)] = inst_35451);

(statearr_35505_35536[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (16))){
var inst_35428 = (state_35476[(12)]);
var inst_35446 = (state_35476[(8)]);
var inst_35424 = (state_35476[(13)]);
var inst_35431 = (state_35476[(14)]);
var inst_35422 = (state_35476[(15)]);
var inst_35426 = (state_35476[(11)]);
var inst_35455 = (state_35476[(16)]);
var inst_35427 = (state_35476[(17)]);
var inst_35430 = (state_35476[(18)]);
var inst_35432 = (state_35476[(9)]);
var inst_35429 = (state_35476[(19)]);
var inst_35425 = (state_35476[(20)]);
var inst_35457 = (function (){var recur_seen = inst_35428;
var recur_subject = inst_35422;
var sub_flakes = inst_35446;
var seen_QMARK_ = inst_35431;
var multi_QMARK_ = inst_35425;
var limit = inst_35430;
var recur_depth = inst_35429;
var as = inst_35426;
var max_depth_QMARK_ = inst_35432;
var recur = inst_35427;
var stop_QMARK_ = inst_35455;
var map__35421 = inst_35424;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_35476__$1 = state_35476;
var statearr_35506_35537 = state_35476__$1;
(statearr_35506_35537[(2)] = inst_35457);

(statearr_35506_35537[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (10))){
var inst_35431 = (state_35476[(14)]);
var state_35476__$1 = state_35476;
var statearr_35507_35538 = state_35476__$1;
(statearr_35507_35538[(2)] = inst_35431);

(statearr_35507_35538[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (18))){
var inst_35455 = (state_35476[(16)]);
var inst_35461 = (state_35476[(2)]);
var state_35476__$1 = (function (){var statearr_35508 = state_35476;
(statearr_35508[(10)] = inst_35461);

return statearr_35508;
})();
if(cljs.core.truth_(inst_35455)){
var statearr_35509_35539 = state_35476__$1;
(statearr_35509_35539[(1)] = (19));

} else {
var statearr_35510_35540 = state_35476__$1;
(statearr_35510_35540[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35477 === (8))){
var inst_35440 = (state_35476[(7)]);
var state_35476__$1 = state_35476;
var statearr_35511_35541 = state_35476__$1;
(statearr_35511_35541[(2)] = inst_35440);

(statearr_35511_35541[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto____0 = (function (){
var statearr_35512 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35512[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto__);

(statearr_35512[(1)] = (1));

return statearr_35512;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto____1 = (function (state_35476){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_35476);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e35513){var ex__14781__auto__ = e35513;
var statearr_35514_35542 = state_35476;
(statearr_35514_35542[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_35476[(4)]))){
var statearr_35515_35543 = state_35476;
(statearr_35515_35543[(1)] = cljs.core.first((state_35476[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__35544 = state_35476;
state_35476 = G__35544;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto__ = function(state_35476){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto____1.call(this,state_35476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_35516 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_35516[(6)] = c__14852__auto__);

return statearr_35516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_35722){
var state_val_35723 = (state_35722[(1)]);
if((state_val_35723 === (7))){
var state_35722__$1 = state_35722;
var statearr_35724_35810 = state_35722__$1;
(statearr_35724_35810[(2)] = null);

(statearr_35724_35810[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (20))){
var inst_35583 = cljs.core.PersistentHashMap.EMPTY;
var state_35722__$1 = state_35722;
var statearr_35725_35811 = state_35722__$1;
(statearr_35725_35811[(2)] = inst_35583);

(statearr_35725_35811[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (27))){
var inst_35571 = (state_35722[(7)]);
var inst_35585 = (state_35722[(8)]);
var inst_35601 = (state_35722[(9)]);
var inst_35565 = (state_35722[(10)]);
var inst_35701 = (state_35722[(2)]);
var inst_35702 = (function (){var top_level_subject = inst_35565;
var select_spec = inst_35571;
var base_acc = inst_35585;
var acc_PLUS_refs = inst_35601;
var result = inst_35701;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_35703 = cljs.core.PersistentVector.EMPTY;
var inst_35704 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_35571);
var inst_35705 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_35704);
var inst_35706 = cljs.core.vals(inst_35705);
var inst_35707 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_35571);
var inst_35708 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_35707);
var inst_35709 = cljs.core.vals(inst_35708);
var inst_35710 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35706,inst_35709);
var inst_35711 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35702,inst_35703,inst_35710);
var inst_35713 = (function (){var top_level_subject = inst_35565;
var select_spec = inst_35571;
var base_acc = inst_35585;
var acc_PLUS_refs = inst_35601;
var result = inst_35701;
var sort_preds = inst_35711;
return (function (acc,p__35712){
var vec__35726 = p__35712;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35726,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35726,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35726,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35726,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_35714 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35713,inst_35701,inst_35711);
var state_35722__$1 = state_35722;
var statearr_35729_35812 = state_35722__$1;
(statearr_35729_35812[(2)] = inst_35714);

(statearr_35729_35812[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (1))){
var state_35722__$1 = state_35722;
var statearr_35730_35813 = state_35722__$1;
(statearr_35730_35813[(2)] = null);

(statearr_35730_35813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (24))){
var inst_35601 = (state_35722[(9)]);
var inst_35601__$1 = (state_35722[(2)]);
var inst_35602 = flakes;
var inst_35603 = cljs.core.PersistentHashMap.EMPTY;
var inst_35604 = inst_35602;
var inst_35605 = inst_35601__$1;
var inst_35606 = inst_35603;
var state_35722__$1 = (function (){var statearr_35731 = state_35722;
(statearr_35731[(11)] = inst_35605);

(statearr_35731[(9)] = inst_35601__$1);

(statearr_35731[(12)] = inst_35606);

(statearr_35731[(13)] = inst_35604);

return statearr_35731;
})();
var statearr_35732_35814 = state_35722__$1;
(statearr_35732_35814[(2)] = null);

(statearr_35732_35814[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (39))){
var inst_35605 = (state_35722[(11)]);
var inst_35571 = (state_35722[(7)]);
var inst_35614 = (state_35722[(14)]);
var inst_35620 = (state_35722[(15)]);
var inst_35649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35650 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_35605,inst_35571,inst_35614,inst_35620,false);
var state_35722__$1 = (function (){var statearr_35733 = state_35722;
(statearr_35733[(16)] = inst_35649);

return statearr_35733;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35722__$1,(42),inst_35650);
} else {
if((state_val_35723 === (46))){
var inst_35614 = (state_35722[(14)]);
var inst_35606 = (state_35722[(12)]);
var inst_35604 = (state_35722[(13)]);
var inst_35667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35668 = [cljs.core.cst$kw$_id];
var inst_35669 = inst_35614.s;
var inst_35670 = [inst_35669];
var inst_35671 = cljs.core.PersistentHashMap.fromArrays(inst_35668,inst_35670);
var inst_35672 = cljs.core.rest(inst_35604);
var inst_35673 = [inst_35671,inst_35672,inst_35606];
var inst_35674 = (new cljs.core.PersistentVector(null,3,(5),inst_35667,inst_35673,null));
var state_35722__$1 = state_35722;
var statearr_35734_35815 = state_35722__$1;
(statearr_35734_35815[(2)] = inst_35674);

(statearr_35734_35815[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (4))){
var inst_35545 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35735_35816 = state_35722__$1;
(statearr_35735_35816[(2)] = inst_35545);

(statearr_35735_35816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (15))){
var inst_35571 = (state_35722[(7)]);
var inst_35572 = (state_35722[(17)]);
var inst_35571__$1 = (state_35722[(2)]);
var inst_35572__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35571__$1);
var state_35722__$1 = (function (){var statearr_35736 = state_35722;
(statearr_35736[(7)] = inst_35571__$1);

(statearr_35736[(17)] = inst_35572__$1);

return statearr_35736;
})();
if(cljs.core.truth_(inst_35572__$1)){
var statearr_35737_35817 = state_35722__$1;
(statearr_35737_35817[(1)] = (16));

} else {
var statearr_35738_35818 = state_35722__$1;
(statearr_35738_35818[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (48))){
var inst_35685 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35739_35819 = state_35722__$1;
(statearr_35739_35819[(2)] = inst_35685);

(statearr_35739_35819[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (50))){
var state_35722__$1 = state_35722;
var statearr_35740_35820 = state_35722__$1;
(statearr_35740_35820[(2)] = null);

(statearr_35740_35820[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (21))){
var inst_35571 = (state_35722[(7)]);
var inst_35585 = (state_35722[(2)]);
var inst_35586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35587 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_35588 = (new cljs.core.PersistentVector(null,2,(5),inst_35586,inst_35587,null));
var inst_35589 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35571,inst_35588);
var state_35722__$1 = (function (){var statearr_35741 = state_35722;
(statearr_35741[(8)] = inst_35585);

return statearr_35741;
})();
if(cljs.core.truth_(inst_35589)){
var statearr_35742_35821 = state_35722__$1;
(statearr_35742_35821[(1)] = (22));

} else {
var statearr_35743_35822 = state_35722__$1;
(statearr_35743_35822[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (31))){
var inst_35605 = (state_35722[(11)]);
var inst_35614 = (state_35722[(14)]);
var inst_35619 = (state_35722[(18)]);
var inst_35623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35624 = fluree.db.query.fql.flake__GT_recur(db,inst_35614,inst_35619,inst_35605,fuel,max_fuel,cache);
var state_35722__$1 = (function (){var statearr_35744 = state_35722;
(statearr_35744[(19)] = inst_35623);

return statearr_35744;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35722__$1,(34),inst_35624);
} else {
if((state_val_35723 === (32))){
var inst_35619 = (state_35722[(18)]);
var state_35722__$1 = state_35722;
if(cljs.core.truth_(inst_35619)){
var statearr_35745_35823 = state_35722__$1;
(statearr_35745_35823[(1)] = (35));

} else {
var statearr_35746_35824 = state_35722__$1;
(statearr_35746_35824[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (40))){
var inst_35571 = (state_35722[(7)]);
var inst_35660 = (state_35722[(20)]);
var inst_35659 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_35571);
var inst_35660__$1 = cljs.core.empty_QMARK_(inst_35659);
var state_35722__$1 = (function (){var statearr_35747 = state_35722;
(statearr_35747[(20)] = inst_35660__$1);

return statearr_35747;
})();
if(inst_35660__$1){
var statearr_35748_35825 = state_35722__$1;
(statearr_35748_35825[(1)] = (43));

} else {
var statearr_35749_35826 = state_35722__$1;
(statearr_35749_35826[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (33))){
var inst_35614 = (state_35722[(14)]);
var inst_35691 = (state_35722[(2)]);
var inst_35692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35691,(0),null);
var inst_35693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35691,(1),null);
var inst_35694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35691,(2),null);
var inst_35695 = inst_35614.s;
var inst_35696 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35692,cljs.core.cst$kw$_id,inst_35695);
var inst_35604 = inst_35693;
var inst_35605 = inst_35696;
var inst_35606 = inst_35694;
var state_35722__$1 = (function (){var statearr_35750 = state_35722;
(statearr_35750[(11)] = inst_35605);

(statearr_35750[(12)] = inst_35606);

(statearr_35750[(13)] = inst_35604);

return statearr_35750;
})();
var statearr_35751_35827 = state_35722__$1;
(statearr_35751_35827[(2)] = null);

(statearr_35751_35827[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (13))){
var inst_35565 = (state_35722[(10)]);
var inst_35568 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_35565);
var state_35722__$1 = state_35722;
var statearr_35752_35828 = state_35722__$1;
(statearr_35752_35828[(2)] = inst_35568);

(statearr_35752_35828[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (22))){
var inst_35571 = (state_35722[(7)]);
var inst_35591 = cljs.core.first(flakes);
var inst_35592 = fluree.db.query.fql.s(inst_35591);
var inst_35593 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_35571);
var inst_35594 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_35592,inst_35593);
var state_35722__$1 = state_35722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35722__$1,(25),inst_35594);
} else {
if((state_val_35723 === (36))){
var inst_35571 = (state_35722[(7)]);
var inst_35647 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35571);
var state_35722__$1 = state_35722;
if(cljs.core.truth_(inst_35647)){
var statearr_35753_35829 = state_35722__$1;
(statearr_35753_35829[(1)] = (39));

} else {
var statearr_35754_35830 = state_35722__$1;
(statearr_35754_35830[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (41))){
var inst_35687 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35755_35831 = state_35722__$1;
(statearr_35755_35831[(2)] = inst_35687);

(statearr_35755_35831[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (43))){
var inst_35571 = (state_35722[(7)]);
var inst_35662 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35571);
var state_35722__$1 = state_35722;
var statearr_35756_35832 = state_35722__$1;
(statearr_35756_35832[(2)] = inst_35662);

(statearr_35756_35832[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (29))){
var inst_35571 = (state_35722[(7)]);
var inst_35614 = (state_35722[(14)]);
var inst_35604 = (state_35722[(13)]);
var inst_35619 = (state_35722[(18)]);
var inst_35614__$1 = cljs.core.first(inst_35604);
var inst_35615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35616 = inst_35614__$1.p;
var inst_35617 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_35616];
var inst_35618 = (new cljs.core.PersistentVector(null,3,(5),inst_35615,inst_35617,null));
var inst_35619__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35571,inst_35618);
var inst_35620 = fluree.db.query.fql.component_follow_QMARK_(inst_35619__$1,inst_35571);
var inst_35621 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_35619__$1);
var state_35722__$1 = (function (){var statearr_35757 = state_35722;
(statearr_35757[(14)] = inst_35614__$1);

(statearr_35757[(15)] = inst_35620);

(statearr_35757[(18)] = inst_35619__$1);

return statearr_35757;
})();
if(cljs.core.truth_(inst_35621)){
var statearr_35758_35833 = state_35722__$1;
(statearr_35758_35833[(1)] = (31));

} else {
var statearr_35759_35834 = state_35722__$1;
(statearr_35759_35834[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (44))){
var inst_35660 = (state_35722[(20)]);
var state_35722__$1 = state_35722;
var statearr_35760_35835 = state_35722__$1;
(statearr_35760_35835[(2)] = inst_35660);

(statearr_35760_35835[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (6))){
var state_35722__$1 = state_35722;
var statearr_35761_35836 = state_35722__$1;
(statearr_35761_35836[(2)] = null);

(statearr_35761_35836[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (28))){
var inst_35605 = (state_35722[(11)]);
var state_35722__$1 = state_35722;
var statearr_35762_35837 = state_35722__$1;
(statearr_35762_35837[(2)] = inst_35605);

(statearr_35762_35837[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (51))){
var inst_35683 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35763_35838 = state_35722__$1;
(statearr_35763_35838[(2)] = inst_35683);

(statearr_35763_35838[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (25))){
var inst_35585 = (state_35722[(8)]);
var inst_35596 = (state_35722[(2)]);
var inst_35597 = fluree.db.util.async.throw_err(inst_35596);
var inst_35598 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35585,inst_35597], 0));
var state_35722__$1 = state_35722;
var statearr_35764_35839 = state_35722__$1;
(statearr_35764_35839[(2)] = inst_35598);

(statearr_35764_35839[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (34))){
var inst_35623 = (state_35722[(19)]);
var inst_35606 = (state_35722[(12)]);
var inst_35604 = (state_35722[(13)]);
var inst_35626 = (state_35722[(2)]);
var inst_35627 = fluree.db.util.async.throw_err(inst_35626);
var inst_35628 = cljs.core.rest(inst_35604);
var inst_35629 = [inst_35627,inst_35628,inst_35606];
var inst_35630 = (new cljs.core.PersistentVector(null,3,(5),inst_35623,inst_35629,null));
var state_35722__$1 = state_35722;
var statearr_35765_35840 = state_35722__$1;
(statearr_35765_35840[(2)] = inst_35630);

(statearr_35765_35840[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (17))){
var inst_35571 = (state_35722[(7)]);
var inst_35575 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35571);
var state_35722__$1 = state_35722;
var statearr_35767_35841 = state_35722__$1;
(statearr_35767_35841[(2)] = inst_35575);

(statearr_35767_35841[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (3))){
var inst_35720 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35722__$1,inst_35720);
} else {
if((state_val_35723 === (12))){
var _ = (function (){var statearr_35768 = state_35722;
(statearr_35768[(4)] = cljs.core.rest((state_35722[(4)])));

return statearr_35768;
})();
var state_35722__$1 = state_35722;
var ex35766 = (state_35722__$1[(2)]);
var statearr_35769_35842 = state_35722__$1;
(statearr_35769_35842[(5)] = ex35766);


var statearr_35770_35843 = state_35722__$1;
(statearr_35770_35843[(1)] = (11));

(statearr_35770_35843[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (2))){
var _ = (function (){var statearr_35771 = state_35722;
(statearr_35771[(4)] = cljs.core.cons((5),(state_35722[(4)])));

return statearr_35771;
})();
var inst_35551 = cljs.core.not_empty(flakes);
var state_35722__$1 = state_35722;
if(cljs.core.truth_(inst_35551)){
var statearr_35772_35844 = state_35722__$1;
(statearr_35772_35844[(1)] = (6));

} else {
var statearr_35773_35845 = state_35722__$1;
(statearr_35773_35845[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (23))){
var inst_35585 = (state_35722[(8)]);
var state_35722__$1 = state_35722;
var statearr_35774_35846 = state_35722__$1;
(statearr_35774_35846[(2)] = inst_35585);

(statearr_35774_35846[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (47))){
var state_35722__$1 = state_35722;
var statearr_35775_35847 = state_35722__$1;
(statearr_35775_35847[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (35))){
var inst_35605 = (state_35722[(11)]);
var inst_35614 = (state_35722[(14)]);
var inst_35606 = (state_35722[(12)]);
var inst_35620 = (state_35722[(15)]);
var inst_35619 = (state_35722[(18)]);
var inst_35636 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_35605,inst_35619,inst_35614,inst_35620,false,inst_35606);
var state_35722__$1 = state_35722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35722__$1,(38),inst_35636);
} else {
if((state_val_35723 === (19))){
var inst_35565 = (state_35722[(10)]);
var inst_35579 = [cljs.core.cst$kw$_id];
var inst_35580 = [inst_35565];
var inst_35581 = cljs.core.PersistentHashMap.fromArrays(inst_35579,inst_35580);
var state_35722__$1 = state_35722;
var statearr_35777_35848 = state_35722__$1;
(statearr_35777_35848[(2)] = inst_35581);

(statearr_35777_35848[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (11))){
var inst_35553 = (state_35722[(2)]);
var inst_35554 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35553], 0));
var inst_35555 = (function(){throw inst_35553})();
var state_35722__$1 = (function (){var statearr_35779 = state_35722;
(statearr_35779[(21)] = inst_35554);

return statearr_35779;
})();
var statearr_35780_35849 = state_35722__$1;
(statearr_35780_35849[(2)] = inst_35555);

(statearr_35780_35849[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (9))){
var _ = (function (){var statearr_35781 = state_35722;
(statearr_35781[(4)] = cljs.core.cons((12),(state_35722[(4)])));

return statearr_35781;
})();
var inst_35561 = cljs.core.first(flakes);
var inst_35562 = fluree.db.query.fql.s(inst_35561);
var ___$1 = (function (){var statearr_35782 = state_35722;
(statearr_35782[(4)] = cljs.core.rest((state_35722[(4)])));

return statearr_35782;
})();
var state_35722__$1 = state_35722;
var statearr_35783_35850 = state_35722__$1;
(statearr_35783_35850[(2)] = inst_35562);

(statearr_35783_35850[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (5))){
var _ = (function (){var statearr_35784 = state_35722;
(statearr_35784[(4)] = cljs.core.rest((state_35722[(4)])));

return statearr_35784;
})();
var state_35722__$1 = state_35722;
var ex35778 = (state_35722__$1[(2)]);
var statearr_35785_35851 = state_35722__$1;
(statearr_35785_35851[(5)] = ex35778);


if((ex35778 instanceof Error)){
var statearr_35786_35852 = state_35722__$1;
(statearr_35786_35852[(1)] = (4));

(statearr_35786_35852[(5)] = null);

} else {
throw ex35778;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (14))){
var state_35722__$1 = state_35722;
var statearr_35787_35853 = state_35722__$1;
(statearr_35787_35853[(2)] = base_select_spec);

(statearr_35787_35853[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (45))){
var inst_35665 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
if(cljs.core.truth_(inst_35665)){
var statearr_35788_35854 = state_35722__$1;
(statearr_35788_35854[(1)] = (46));

} else {
var statearr_35789_35855 = state_35722__$1;
(statearr_35789_35855[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (26))){
var inst_35604 = (state_35722[(13)]);
var inst_35608 = cljs.core.empty_QMARK_(inst_35604);
var state_35722__$1 = state_35722;
if(inst_35608){
var statearr_35790_35856 = state_35722__$1;
(statearr_35790_35856[(1)] = (28));

} else {
var statearr_35791_35857 = state_35722__$1;
(statearr_35791_35857[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (16))){
var inst_35572 = (state_35722[(17)]);
var state_35722__$1 = state_35722;
var statearr_35792_35858 = state_35722__$1;
(statearr_35792_35858[(2)] = inst_35572);

(statearr_35792_35858[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (38))){
var inst_35604 = (state_35722[(13)]);
var inst_35638 = (state_35722[(2)]);
var inst_35639 = fluree.db.util.async.throw_err(inst_35638);
var inst_35640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35639,(0),null);
var inst_35641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35639,(1),null);
var inst_35642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35643 = cljs.core.rest(inst_35604);
var inst_35644 = [inst_35640,inst_35643,inst_35641];
var inst_35645 = (new cljs.core.PersistentVector(null,3,(5),inst_35642,inst_35644,null));
var state_35722__$1 = state_35722;
var statearr_35793_35859 = state_35722__$1;
(statearr_35793_35859[(2)] = inst_35645);

(statearr_35793_35859[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (30))){
var inst_35699 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35794_35860 = state_35722__$1;
(statearr_35794_35860[(2)] = inst_35699);

(statearr_35794_35860[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (10))){
var inst_35565 = (state_35722[(2)]);
var inst_35566 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_35722__$1 = (function (){var statearr_35795 = state_35722;
(statearr_35795[(10)] = inst_35565);

return statearr_35795;
})();
if(cljs.core.truth_(inst_35566)){
var statearr_35796_35861 = state_35722__$1;
(statearr_35796_35861[(1)] = (13));

} else {
var statearr_35797_35862 = state_35722__$1;
(statearr_35797_35862[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (18))){
var inst_35577 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
if(cljs.core.truth_(inst_35577)){
var statearr_35798_35863 = state_35722__$1;
(statearr_35798_35863[(1)] = (19));

} else {
var statearr_35799_35864 = state_35722__$1;
(statearr_35799_35864[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (42))){
var inst_35649 = (state_35722[(16)]);
var inst_35606 = (state_35722[(12)]);
var inst_35604 = (state_35722[(13)]);
var inst_35652 = (state_35722[(2)]);
var inst_35653 = fluree.db.util.async.throw_err(inst_35652);
var inst_35654 = cljs.core.first(inst_35653);
var inst_35655 = cljs.core.rest(inst_35604);
var inst_35656 = [inst_35654,inst_35655,inst_35606];
var inst_35657 = (new cljs.core.PersistentVector(null,3,(5),inst_35649,inst_35656,null));
var state_35722__$1 = state_35722;
var statearr_35800_35865 = state_35722__$1;
(statearr_35800_35865[(2)] = inst_35657);

(statearr_35800_35865[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (37))){
var inst_35689 = (state_35722[(2)]);
var state_35722__$1 = state_35722;
var statearr_35801_35866 = state_35722__$1;
(statearr_35801_35866[(2)] = inst_35689);

(statearr_35801_35866[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (8))){
var inst_35717 = (state_35722[(2)]);
var _ = (function (){var statearr_35802 = state_35722;
(statearr_35802[(4)] = cljs.core.rest((state_35722[(4)])));

return statearr_35802;
})();
var state_35722__$1 = state_35722;
var statearr_35803_35867 = state_35722__$1;
(statearr_35803_35867[(2)] = inst_35717);

(statearr_35803_35867[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35723 === (49))){
var inst_35605 = (state_35722[(11)]);
var inst_35606 = (state_35722[(12)]);
var inst_35604 = (state_35722[(13)]);
var inst_35677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35678 = cljs.core.rest(inst_35604);
var inst_35679 = [inst_35605,inst_35678,inst_35606];
var inst_35680 = (new cljs.core.PersistentVector(null,3,(5),inst_35677,inst_35679,null));
var state_35722__$1 = state_35722;
var statearr_35804_35868 = state_35722__$1;
(statearr_35804_35868[(2)] = inst_35680);

(statearr_35804_35868[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto____0 = (function (){
var statearr_35805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35805[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto__);

(statearr_35805[(1)] = (1));

return statearr_35805;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto____1 = (function (state_35722){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_35722);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e35806){var ex__14781__auto__ = e35806;
var statearr_35807_35869 = state_35722;
(statearr_35807_35869[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_35722[(4)]))){
var statearr_35808_35870 = state_35722;
(statearr_35808_35870[(1)] = cljs.core.first((state_35722[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__35871 = state_35722;
state_35722 = G__35871;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto__ = function(state_35722){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto____1.call(this,state_35722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_35809 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_35809[(6)] = c__14852__auto__);

return statearr_35809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__35874 = arguments.length;
switch (G__35874) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_35916){
var state_val_35917 = (state_35916[(1)]);
if((state_val_35917 === (7))){
var inst_35882 = (state_35916[(7)]);
var state_35916__$1 = state_35916;
var statearr_35918_35948 = state_35916__$1;
(statearr_35918_35948[(2)] = inst_35882);

(statearr_35918_35948[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (1))){
var state_35916__$1 = state_35916;
var statearr_35919_35949 = state_35916__$1;
(statearr_35919_35949[(2)] = null);

(statearr_35919_35949[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (4))){
var inst_35875 = (state_35916[(2)]);
var state_35916__$1 = state_35916;
var statearr_35920_35950 = state_35916__$1;
(statearr_35920_35950[(2)] = inst_35875);

(statearr_35920_35950[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (15))){
var inst_35910 = (state_35916[(2)]);
var inst_35911 = fluree.db.util.async.throw_err(inst_35910);
var _ = (function (){var statearr_35921 = state_35916;
(statearr_35921[(4)] = cljs.core.rest((state_35916[(4)])));

return statearr_35921;
})();
var state_35916__$1 = state_35916;
var statearr_35922_35951 = state_35916__$1;
(statearr_35922_35951[(2)] = inst_35911);

(statearr_35922_35951[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (13))){
var inst_35894 = (state_35916[(8)]);
var state_35916__$1 = state_35916;
var statearr_35923_35952 = state_35916__$1;
(statearr_35923_35952[(2)] = inst_35894);

(statearr_35923_35952[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (6))){
var inst_35882 = (state_35916[(7)]);
var inst_35884 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_35885 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35882,inst_35884);
var state_35916__$1 = state_35916;
var statearr_35924_35953 = state_35916__$1;
(statearr_35924_35953[(2)] = inst_35885);

(statearr_35924_35953[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (3))){
var inst_35914 = (state_35916[(2)]);
var state_35916__$1 = state_35916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35916__$1,inst_35914);
} else {
if((state_val_35917 === (12))){
var inst_35894 = (state_35916[(8)]);
var inst_35896 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_35897 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35894,inst_35896);
var state_35916__$1 = state_35916;
var statearr_35925_35954 = state_35916__$1;
(statearr_35925_35954[(2)] = inst_35897);

(statearr_35925_35954[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (2))){
var _ = (function (){var statearr_35926 = state_35916;
(statearr_35926[(4)] = cljs.core.cons((5),(state_35916[(4)])));

return statearr_35926;
})();
var inst_35882 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_35916__$1 = (function (){var statearr_35927 = state_35916;
(statearr_35927[(7)] = inst_35882);

return statearr_35927;
})();
if(cljs.core.truth_(fuel)){
var statearr_35928_35955 = state_35916__$1;
(statearr_35928_35955[(1)] = (6));

} else {
var statearr_35929_35956 = state_35916__$1;
(statearr_35929_35956[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (11))){
var inst_35894 = (state_35916[(2)]);
var state_35916__$1 = (function (){var statearr_35931 = state_35916;
(statearr_35931[(8)] = inst_35894);

return statearr_35931;
})();
if(cljs.core.truth_(limit)){
var statearr_35932_35957 = state_35916__$1;
(statearr_35932_35957[(1)] = (12));

} else {
var statearr_35933_35958 = state_35916__$1;
(statearr_35933_35958[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (9))){
var inst_35888 = (state_35916[(9)]);
var inst_35890 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_35891 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35888,inst_35890);
var state_35916__$1 = state_35916;
var statearr_35934_35959 = state_35916__$1;
(statearr_35934_35959[(2)] = inst_35891);

(statearr_35934_35959[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (5))){
var _ = (function (){var statearr_35935 = state_35916;
(statearr_35935[(4)] = cljs.core.rest((state_35916[(4)])));

return statearr_35935;
})();
var state_35916__$1 = state_35916;
var ex35930 = (state_35916__$1[(2)]);
var statearr_35936_35960 = state_35916__$1;
(statearr_35936_35960[(5)] = ex35930);


if((ex35930 instanceof Error)){
var statearr_35937_35961 = state_35916__$1;
(statearr_35937_35961[(1)] = (4));

(statearr_35937_35961[(5)] = null);

} else {
throw ex35930;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (14))){
var inst_35900 = (state_35916[(2)]);
var inst_35901 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_35902 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_35901);
var inst_35903 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35900,inst_35902);
var inst_35904 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35903,flakes);
var inst_35905 = cljs.core.PersistentVector.EMPTY;
var inst_35906 = (function (){var xf = inst_35903;
var flakes_by_sub = inst_35904;
return (function (p1__35872_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__35872_SHARP_);
});
})();
var inst_35907 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35906,inst_35904);
var inst_35908 = fluree.db.util.async.merge_into_QMARK_(inst_35905,inst_35907);
var state_35916__$1 = state_35916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35916__$1,(15),inst_35908);
} else {
if((state_val_35917 === (10))){
var inst_35888 = (state_35916[(9)]);
var state_35916__$1 = state_35916;
var statearr_35938_35962 = state_35916__$1;
(statearr_35938_35962[(2)] = inst_35888);

(statearr_35938_35962[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35917 === (8))){
var inst_35888 = (state_35916[(2)]);
var state_35916__$1 = (function (){var statearr_35939 = state_35916;
(statearr_35939[(9)] = inst_35888);

return statearr_35939;
})();
if(cljs.core.truth_(offset)){
var statearr_35940_35963 = state_35916__$1;
(statearr_35940_35963[(1)] = (9));

} else {
var statearr_35941_35964 = state_35916__$1;
(statearr_35941_35964[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__14778__auto__ = null;
var fluree$db$query$fql$state_machine__14778__auto____0 = (function (){
var statearr_35942 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35942[(0)] = fluree$db$query$fql$state_machine__14778__auto__);

(statearr_35942[(1)] = (1));

return statearr_35942;
});
var fluree$db$query$fql$state_machine__14778__auto____1 = (function (state_35916){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_35916);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e35943){var ex__14781__auto__ = e35943;
var statearr_35944_35965 = state_35916;
(statearr_35944_35965[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_35916[(4)]))){
var statearr_35945_35966 = state_35916;
(statearr_35945_35966[(1)] = cljs.core.first((state_35916[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__35967 = state_35916;
state_35916 = G__35967;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__14778__auto__ = function(state_35916){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__14778__auto____1.call(this,state_35916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__14778__auto____0;
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__14778__auto____1;
return fluree$db$query$fql$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_35946 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_35946[(6)] = c__14852__auto__);

return statearr_35946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__35969 = arguments.length;
switch (G__35969) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_36050){
var state_val_36051 = (state_36050[(1)]);
if((state_val_36051 === (7))){
var inst_36045 = (state_36050[(2)]);
var _ = (function (){var statearr_36053 = state_36050;
(statearr_36053[(4)] = cljs.core.rest((state_36050[(4)])));

return statearr_36053;
})();
var state_36050__$1 = state_36050;
var statearr_36054_36101 = state_36050__$1;
(statearr_36054_36101[(2)] = inst_36045);

(statearr_36054_36101[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (20))){
var inst_35989 = (state_36050[(7)]);
var inst_35997 = (state_36050[(8)]);
var inst_35990 = (state_36050[(9)]);
var inst_36018 = (inst_35989 + (1));
var tmp36052 = inst_35990;
var inst_35988 = inst_35997;
var inst_35989__$1 = inst_36018;
var inst_35990__$1 = tmp36052;
var state_36050__$1 = (function (){var statearr_36055 = state_36050;
(statearr_36055[(7)] = inst_35989__$1);

(statearr_36055[(10)] = inst_35988);

(statearr_36055[(9)] = inst_35990__$1);

return statearr_36055;
})();
var statearr_36056_36102 = state_36050__$1;
(statearr_36056_36102[(2)] = null);

(statearr_36056_36102[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (27))){
var inst_36023 = (state_36050[(11)]);
var inst_36029 = (state_36050[(2)]);
var inst_36030 = fluree.db.util.async.throw_err(inst_36029);
var inst_36031 = (inst_36023.cljs$core$IFn$_invoke$arity$1 ? inst_36023.cljs$core$IFn$_invoke$arity$1(inst_36030) : inst_36023.call(null,inst_36030));
var state_36050__$1 = state_36050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36050__$1,(26),inst_36031);
} else {
if((state_val_36051 === (1))){
var state_36050__$1 = state_36050;
var statearr_36057_36103 = state_36050__$1;
(statearr_36057_36103[(2)] = null);

(statearr_36057_36103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (24))){
var state_36050__$1 = state_36050;
var statearr_36058_36104 = state_36050__$1;
(statearr_36058_36104[(2)] = null);

(statearr_36058_36104[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (4))){
var inst_35970 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
var statearr_36059_36105 = state_36050__$1;
(statearr_36059_36105[(2)] = inst_35970);

(statearr_36059_36105[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (15))){
var inst_36011 = (state_36050[(12)]);
var inst_36011__$1 = offset;
var state_36050__$1 = (function (){var statearr_36060 = state_36050;
(statearr_36060[(12)] = inst_36011__$1);

return statearr_36060;
})();
if(cljs.core.truth_(inst_36011__$1)){
var statearr_36061_36106 = state_36050__$1;
(statearr_36061_36106[(1)] = (17));

} else {
var statearr_36062_36107 = state_36050__$1;
(statearr_36062_36107[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (21))){
var state_36050__$1 = state_36050;
var statearr_36063_36108 = state_36050__$1;
(statearr_36063_36108[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (13))){
var inst_36006 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
var statearr_36065_36109 = state_36050__$1;
(statearr_36065_36109[(2)] = inst_36006);

(statearr_36065_36109[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (22))){
var inst_36041 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
var statearr_36066_36110 = state_36050__$1;
(statearr_36066_36110[(2)] = inst_36041);

(statearr_36066_36110[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (6))){
var inst_35998 = (state_36050[(13)]);
var inst_35988 = (state_36050[(10)]);
var inst_35996 = (state_36050[(14)]);
var inst_35995 = cljs.core.seq(inst_35988);
var inst_35996__$1 = cljs.core.first(inst_35995);
var inst_35997 = cljs.core.next(inst_35995);
var inst_35998__$1 = (inst_35996__$1 == null);
var state_36050__$1 = (function (){var statearr_36067 = state_36050;
(statearr_36067[(13)] = inst_35998__$1);

(statearr_36067[(8)] = inst_35997);

(statearr_36067[(14)] = inst_35996__$1);

return statearr_36067;
})();
if(cljs.core.truth_(inst_35998__$1)){
var statearr_36068_36111 = state_36050__$1;
(statearr_36068_36111[(1)] = (8));

} else {
var statearr_36069_36112 = state_36050__$1;
(statearr_36069_36112[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (25))){
var inst_36039 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
var statearr_36070_36113 = state_36050__$1;
(statearr_36070_36113[(2)] = inst_36039);

(statearr_36070_36113[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (17))){
var inst_35989 = (state_36050[(7)]);
var inst_36013 = (inst_35989 < offset);
var state_36050__$1 = state_36050;
var statearr_36071_36114 = state_36050__$1;
(statearr_36071_36114[(2)] = inst_36013);

(statearr_36071_36114[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (3))){
var inst_36048 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36050__$1,inst_36048);
} else {
if((state_val_36051 === (12))){
var inst_36001 = (state_36050[(15)]);
var state_36050__$1 = state_36050;
var statearr_36072_36115 = state_36050__$1;
(statearr_36072_36115[(2)] = inst_36001);

(statearr_36072_36115[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (2))){
var inst_35983 = (state_36050[(16)]);
var _ = (function (){var statearr_36073 = state_36050;
(statearr_36073[(4)] = cljs.core.cons((5),(state_36050[(4)])));

return statearr_36073;
})();
var inst_35983__$1 = subjects;
var inst_35984 = cljs.core.seq(inst_35983__$1);
var inst_35985 = cljs.core.first(inst_35984);
var inst_35986 = cljs.core.next(inst_35984);
var inst_35987 = cljs.core.PersistentVector.EMPTY;
var inst_35988 = inst_35983__$1;
var inst_35989 = (0);
var inst_35990 = inst_35987;
var state_36050__$1 = (function (){var statearr_36074 = state_36050;
(statearr_36074[(7)] = inst_35989);

(statearr_36074[(17)] = inst_35985);

(statearr_36074[(10)] = inst_35988);

(statearr_36074[(18)] = inst_35986);

(statearr_36074[(9)] = inst_35990);

(statearr_36074[(16)] = inst_35983__$1);

return statearr_36074;
})();
var statearr_36075_36116 = state_36050__$1;
(statearr_36075_36116[(2)] = null);

(statearr_36075_36116[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (23))){
var inst_35989 = (state_36050[(7)]);
var inst_35985 = (state_36050[(17)]);
var inst_35997 = (state_36050[(8)]);
var inst_35988 = (state_36050[(10)]);
var inst_35996 = (state_36050[(14)]);
var inst_35986 = (state_36050[(18)]);
var inst_35990 = (state_36050[(9)]);
var inst_35983 = (state_36050[(16)]);
var inst_36022 = (inst_35989 + (1));
var inst_36023 = (function (){var first__35982 = inst_35985;
var vec__35980 = inst_35983;
var seq__35981 = inst_35986;
var r = inst_35997;
var G__35979 = inst_35988;
var acc = inst_35990;
var n = inst_35989;
var first__35994 = inst_35996;
var s = inst_35996;
var vec__35992 = inst_35988;
var seq__35993 = inst_35997;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_36024 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36025 = [inst_35996];
var inst_36026 = (new cljs.core.PersistentVector(null,1,(5),inst_36024,inst_36025,null));
var inst_36027 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36026);
var state_36050__$1 = (function (){var statearr_36076 = state_36050;
(statearr_36076[(19)] = inst_36022);

(statearr_36076[(11)] = inst_36023);

return statearr_36076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36050__$1,(27),inst_36027);
} else {
if((state_val_36051 === (19))){
var inst_36016 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
if(cljs.core.truth_(inst_36016)){
var statearr_36077_36117 = state_36050__$1;
(statearr_36077_36117[(1)] = (20));

} else {
var statearr_36078_36118 = state_36050__$1;
(statearr_36078_36118[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (11))){
var inst_35989 = (state_36050[(7)]);
var inst_36003 = (inst_35989 > limit);
var state_36050__$1 = state_36050;
var statearr_36080_36119 = state_36050__$1;
(statearr_36080_36119[(2)] = inst_36003);

(statearr_36080_36119[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (9))){
var inst_36001 = (state_36050[(15)]);
var inst_36001__$1 = limit;
var state_36050__$1 = (function (){var statearr_36081 = state_36050;
(statearr_36081[(15)] = inst_36001__$1);

return statearr_36081;
})();
if(cljs.core.truth_(inst_36001__$1)){
var statearr_36082_36120 = state_36050__$1;
(statearr_36082_36120[(1)] = (11));

} else {
var statearr_36083_36121 = state_36050__$1;
(statearr_36083_36121[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (5))){
var _ = (function (){var statearr_36084 = state_36050;
(statearr_36084[(4)] = cljs.core.rest((state_36050[(4)])));

return statearr_36084;
})();
var state_36050__$1 = state_36050;
var ex36079 = (state_36050__$1[(2)]);
var statearr_36085_36122 = state_36050__$1;
(statearr_36085_36122[(5)] = ex36079);


if((ex36079 instanceof Error)){
var statearr_36086_36123 = state_36050__$1;
(statearr_36086_36123[(1)] = (4));

(statearr_36086_36123[(5)] = null);

} else {
throw ex36079;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (14))){
var inst_35990 = (state_36050[(9)]);
var state_36050__$1 = state_36050;
var statearr_36087_36124 = state_36050__$1;
(statearr_36087_36124[(2)] = inst_35990);

(statearr_36087_36124[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (26))){
var inst_35997 = (state_36050[(8)]);
var inst_36022 = (state_36050[(19)]);
var inst_35990 = (state_36050[(9)]);
var inst_36033 = (state_36050[(2)]);
var inst_36034 = fluree.db.util.async.throw_err(inst_36033);
var inst_36035 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35990,inst_36034);
var inst_35988 = inst_35997;
var inst_35989 = inst_36022;
var inst_35990__$1 = inst_36035;
var state_36050__$1 = (function (){var statearr_36088 = state_36050;
(statearr_36088[(7)] = inst_35989);

(statearr_36088[(10)] = inst_35988);

(statearr_36088[(9)] = inst_35990__$1);

return statearr_36088;
})();
var statearr_36089_36125 = state_36050__$1;
(statearr_36089_36125[(2)] = null);

(statearr_36089_36125[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (16))){
var inst_36043 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
var statearr_36090_36126 = state_36050__$1;
(statearr_36090_36126[(2)] = inst_36043);

(statearr_36090_36126[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (10))){
var inst_36008 = (state_36050[(2)]);
var state_36050__$1 = state_36050;
if(cljs.core.truth_(inst_36008)){
var statearr_36091_36127 = state_36050__$1;
(statearr_36091_36127[(1)] = (14));

} else {
var statearr_36092_36128 = state_36050__$1;
(statearr_36092_36128[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (18))){
var inst_36011 = (state_36050[(12)]);
var state_36050__$1 = state_36050;
var statearr_36093_36129 = state_36050__$1;
(statearr_36093_36129[(2)] = inst_36011);

(statearr_36093_36129[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36051 === (8))){
var inst_35998 = (state_36050[(13)]);
var state_36050__$1 = state_36050;
var statearr_36094_36130 = state_36050__$1;
(statearr_36094_36130[(2)] = inst_35998);

(statearr_36094_36130[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__14778__auto__ = null;
var fluree$db$query$fql$state_machine__14778__auto____0 = (function (){
var statearr_36095 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36095[(0)] = fluree$db$query$fql$state_machine__14778__auto__);

(statearr_36095[(1)] = (1));

return statearr_36095;
});
var fluree$db$query$fql$state_machine__14778__auto____1 = (function (state_36050){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_36050);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e36096){var ex__14781__auto__ = e36096;
var statearr_36097_36131 = state_36050;
(statearr_36097_36131[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_36050[(4)]))){
var statearr_36098_36132 = state_36050;
(statearr_36098_36132[(1)] = cljs.core.first((state_36050[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__36133 = state_36050;
state_36050 = G__36133;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__14778__auto__ = function(state_36050){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__14778__auto____1.call(this,state_36050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__14778__auto____0;
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__14778__auto____1;
return fluree$db$query$fql$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_36099 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_36099[(6)] = c__14852__auto__);

return statearr_36099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__36135 = arguments.length;
switch (G__36135) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_36326){
var state_val_36327 = (state_36326[(1)]);
if((state_val_36327 === (7))){
var state_36326__$1 = state_36326;
var statearr_36328_36403 = state_36326__$1;
(statearr_36328_36403[(2)] = null);

(statearr_36328_36403[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (20))){
var inst_36176 = (state_36326[(7)]);
var inst_36178 = (state_36326[(8)]);
var inst_36206 = (state_36326[(2)]);
var inst_36207 = fluree.db.util.async.throw_err(inst_36206);
var inst_36208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36209 = [inst_36176];
var inst_36210 = (new cljs.core.PersistentVector(null,1,(5),inst_36208,inst_36209,null));
var inst_36211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36212 = [inst_36176,inst_36178];
var inst_36213 = (new cljs.core.PersistentVector(null,2,(5),inst_36211,inst_36212,null));
var inst_36214 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_36210,cljs.core._LT_,inst_36213);
var state_36326__$1 = (function (){var statearr_36329 = state_36326;
(statearr_36329[(9)] = inst_36207);

return statearr_36329;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36326__$1,(21),inst_36214);
} else {
if((state_val_36327 === (27))){
var inst_36195 = (state_36326[(10)]);
var inst_36177 = (state_36326[(11)]);
var inst_36243 = (inst_36195.cljs$core$IFn$_invoke$arity$2 ? inst_36195.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_36177) : inst_36195.call(null,cljs.core._GT__EQ_,inst_36177));
var state_36326__$1 = state_36326;
if(cljs.core.truth_(inst_36243)){
var statearr_36330_36404 = state_36326__$1;
(statearr_36330_36404[(1)] = (30));

} else {
var statearr_36331_36405 = state_36326__$1;
(statearr_36331_36405[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (1))){
var state_36326__$1 = state_36326;
var statearr_36332_36406 = state_36326__$1;
(statearr_36332_36406[(2)] = null);

(statearr_36332_36406[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (24))){
var inst_36292 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36333_36407 = state_36326__$1;
(statearr_36333_36407[(2)] = inst_36292);

(statearr_36333_36407[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (39))){
var inst_36282 = null;
var state_36326__$1 = state_36326;
var statearr_36334_36408 = state_36326__$1;
(statearr_36334_36408[(2)] = inst_36282);

(statearr_36334_36408[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (46))){
var inst_36304 = (state_36326[(12)]);
var state_36326__$1 = state_36326;
var statearr_36335_36409 = state_36326__$1;
(statearr_36335_36409[(2)] = inst_36304);

(statearr_36335_36409[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (4))){
var inst_36136 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36336_36410 = state_36326__$1;
(statearr_36336_36410[(2)] = inst_36136);

(statearr_36336_36410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (15))){
var state_36326__$1 = state_36326;
var statearr_36337_36411 = state_36326__$1;
(statearr_36337_36411[(2)] = null);

(statearr_36337_36411[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (48))){
var inst_36303 = (state_36326[(13)]);
var state_36326__$1 = state_36326;
var statearr_36338_36412 = state_36326__$1;
(statearr_36338_36412[(2)] = inst_36303);

(statearr_36338_36412[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (50))){
var inst_36314 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36339_36413 = state_36326__$1;
(statearr_36339_36413[(2)] = inst_36314);

(statearr_36339_36413[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (21))){
var inst_36207 = (state_36326[(9)]);
var inst_36216 = (state_36326[(2)]);
var inst_36217 = fluree.db.util.async.throw_err(inst_36216);
var inst_36218 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36207,inst_36217);
var state_36326__$1 = state_36326;
var statearr_36340_36414 = state_36326__$1;
(statearr_36340_36414[(2)] = inst_36218);

(statearr_36340_36414[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (31))){
var inst_36195 = (state_36326[(10)]);
var inst_36177 = (state_36326[(11)]);
var inst_36256 = (inst_36195.cljs$core$IFn$_invoke$arity$2 ? inst_36195.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_36177) : inst_36195.call(null,cljs.core._LT_,inst_36177));
var state_36326__$1 = state_36326;
if(cljs.core.truth_(inst_36256)){
var statearr_36341_36415 = state_36326__$1;
(statearr_36341_36415[(1)] = (34));

} else {
var statearr_36342_36416 = state_36326__$1;
(statearr_36342_36416[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (32))){
var inst_36288 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36343_36417 = state_36326__$1;
(statearr_36343_36417[(2)] = inst_36288);

(statearr_36343_36417[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (40))){
var inst_36284 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36344_36418 = state_36326__$1;
(statearr_36344_36418[(2)] = inst_36284);

(statearr_36344_36418[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (33))){
var inst_36253 = (state_36326[(2)]);
var inst_36254 = fluree.db.util.async.throw_err(inst_36253);
var state_36326__$1 = state_36326;
var statearr_36345_36419 = state_36326__$1;
(statearr_36345_36419[(2)] = inst_36254);

(statearr_36345_36419[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (13))){
var inst_36316 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36346_36420 = state_36326__$1;
(statearr_36346_36420[(2)] = inst_36316);

(statearr_36346_36420[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (22))){
var inst_36176 = (state_36326[(7)]);
var inst_36178 = (state_36326[(8)]);
var inst_36222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36223 = [inst_36176,inst_36178];
var inst_36224 = (new cljs.core.PersistentVector(null,2,(5),inst_36222,inst_36223,null));
var inst_36225 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_36224);
var state_36326__$1 = state_36326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36326__$1,(25),inst_36225);
} else {
if((state_val_36327 === (36))){
var inst_36286 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36347_36421 = state_36326__$1;
(statearr_36347_36421[(2)] = inst_36286);

(statearr_36347_36421[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (41))){
var inst_36279 = (state_36326[(2)]);
var inst_36280 = fluree.db.util.async.throw_err(inst_36279);
var state_36326__$1 = state_36326;
var statearr_36348_36422 = state_36326__$1;
(statearr_36348_36422[(2)] = inst_36280);

(statearr_36348_36422[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (43))){
var inst_36162 = (state_36326[(14)]);
var inst_36295 = (state_36326[(15)]);
var inst_36296 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36162,inst_36295);
var state_36326__$1 = state_36326;
var statearr_36349_36423 = state_36326__$1;
(statearr_36349_36423[(2)] = inst_36296);

(statearr_36349_36423[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (29))){
var inst_36240 = (state_36326[(2)]);
var inst_36241 = fluree.db.util.async.throw_err(inst_36240);
var state_36326__$1 = state_36326;
var statearr_36350_36424 = state_36326__$1;
(statearr_36350_36424[(2)] = inst_36241);

(statearr_36350_36424[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (44))){
var inst_36162 = (state_36326[(14)]);
var inst_36295 = (state_36326[(15)]);
var inst_36298 = cljs.core.PersistentHashSet.EMPTY;
var inst_36299 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36298,inst_36295);
var inst_36300 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_36162,inst_36299);
var state_36326__$1 = state_36326;
var statearr_36351_36425 = state_36326__$1;
(statearr_36351_36425[(2)] = inst_36300);

(statearr_36351_36425[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (6))){
var inst_36147 = (state_36326[(16)]);
var inst_36157 = cljs.core.seq(inst_36147);
var inst_36158 = cljs.core.first(inst_36157);
var inst_36159 = cljs.core.next(inst_36157);
var inst_36160 = cljs.core.PersistentHashSet.EMPTY;
var inst_36161 = inst_36147;
var inst_36162 = inst_36160;
var state_36326__$1 = (function (){var statearr_36352 = state_36326;
(statearr_36352[(17)] = inst_36158);

(statearr_36352[(14)] = inst_36162);

(statearr_36352[(18)] = inst_36161);

(statearr_36352[(19)] = inst_36159);

return statearr_36352;
})();
var statearr_36353_36426 = state_36326__$1;
(statearr_36353_36426[(2)] = null);

(statearr_36353_36426[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (28))){
var inst_36290 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36354_36427 = state_36326__$1;
(statearr_36354_36427[(2)] = inst_36290);

(statearr_36354_36427[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (25))){
var inst_36227 = (state_36326[(2)]);
var inst_36228 = fluree.db.util.async.throw_err(inst_36227);
var state_36326__$1 = state_36326;
var statearr_36355_36428 = state_36326__$1;
(statearr_36355_36428[(2)] = inst_36228);

(statearr_36355_36428[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (34))){
var inst_36176 = (state_36326[(7)]);
var inst_36178 = (state_36326[(8)]);
var inst_36258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36259 = [inst_36176];
var inst_36260 = (new cljs.core.PersistentVector(null,1,(5),inst_36258,inst_36259,null));
var inst_36261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36262 = [inst_36176,inst_36178];
var inst_36263 = (new cljs.core.PersistentVector(null,2,(5),inst_36261,inst_36262,null));
var inst_36264 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_36260,cljs.core._LT_,inst_36263);
var state_36326__$1 = state_36326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36326__$1,(37),inst_36264);
} else {
if((state_val_36327 === (17))){
var inst_36176 = (state_36326[(7)]);
var inst_36178 = (state_36326[(8)]);
var inst_36198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36199 = [inst_36176,inst_36178];
var inst_36200 = (new cljs.core.PersistentVector(null,2,(5),inst_36198,inst_36199,null));
var inst_36201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36202 = [inst_36176];
var inst_36203 = (new cljs.core.PersistentVector(null,1,(5),inst_36201,inst_36202,null));
var inst_36204 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_36200,cljs.core._LT__EQ_,inst_36203);
var state_36326__$1 = state_36326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36326__$1,(20),inst_36204);
} else {
if((state_val_36327 === (3))){
var inst_36324 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36326__$1,inst_36324);
} else {
if((state_val_36327 === (12))){
var inst_36176 = (state_36326[(7)]);
var inst_36168 = (state_36326[(20)]);
var inst_36176__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36168,(0),null);
var inst_36177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36168,(1),null);
var inst_36178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36168,(2),null);
var inst_36179 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_36176__$1);
var inst_36180 = cljs.core.not(inst_36179);
var state_36326__$1 = (function (){var statearr_36356 = state_36326;
(statearr_36356[(7)] = inst_36176__$1);

(statearr_36356[(11)] = inst_36177);

(statearr_36356[(8)] = inst_36178);

return statearr_36356;
})();
if(inst_36180){
var statearr_36357_36429 = state_36326__$1;
(statearr_36357_36429[(1)] = (14));

} else {
var statearr_36358_36430 = state_36326__$1;
(statearr_36358_36430[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (2))){
var inst_36147 = (state_36326[(16)]);
var _ = (function (){var statearr_36359 = state_36326;
(statearr_36359[(4)] = cljs.core.cons((5),(state_36326[(4)])));

return statearr_36359;
})();
var inst_36145 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_36146 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36145,(0),null);
var inst_36147__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36145,(1),null);
var inst_36148 = cljs.core.not_empty(inst_36147__$1);
var state_36326__$1 = (function (){var statearr_36360 = state_36326;
(statearr_36360[(16)] = inst_36147__$1);

(statearr_36360[(21)] = inst_36146);

return statearr_36360;
})();
if(cljs.core.truth_(inst_36148)){
var statearr_36361_36431 = state_36326__$1;
(statearr_36361_36431[(1)] = (6));

} else {
var statearr_36362_36432 = state_36326__$1;
(statearr_36362_36432[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (23))){
var inst_36195 = (state_36326[(10)]);
var inst_36177 = (state_36326[(11)]);
var inst_36230 = (inst_36195.cljs$core$IFn$_invoke$arity$2 ? inst_36195.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_36177) : inst_36195.call(null,cljs.core._GT_,inst_36177));
var state_36326__$1 = state_36326;
if(cljs.core.truth_(inst_36230)){
var statearr_36363_36433 = state_36326__$1;
(statearr_36363_36433[(1)] = (26));

} else {
var statearr_36364_36434 = state_36326__$1;
(statearr_36364_36434[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (47))){
var inst_36309 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
if(cljs.core.truth_(inst_36309)){
var statearr_36365_36435 = state_36326__$1;
(statearr_36365_36435[(1)] = (48));

} else {
var statearr_36366_36436 = state_36326__$1;
(statearr_36366_36436[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (35))){
var inst_36195 = (state_36326[(10)]);
var inst_36177 = (state_36326[(11)]);
var inst_36269 = (inst_36195.cljs$core$IFn$_invoke$arity$2 ? inst_36195.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_36177) : inst_36195.call(null,cljs.core._LT__EQ_,inst_36177));
var state_36326__$1 = state_36326;
if(cljs.core.truth_(inst_36269)){
var statearr_36367_36437 = state_36326__$1;
(statearr_36367_36437[(1)] = (38));

} else {
var statearr_36368_36438 = state_36326__$1;
(statearr_36368_36438[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (19))){
var inst_36146 = (state_36326[(21)]);
var inst_36294 = (state_36326[(2)]);
var inst_36295 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_36294);
var state_36326__$1 = (function (){var statearr_36369 = state_36326;
(statearr_36369[(15)] = inst_36295);

return statearr_36369;
})();
var G__36370_36439 = inst_36146;
var G__36370_36440__$1 = (((G__36370_36439 instanceof cljs.core.Keyword))?G__36370_36439.fqn:null);
switch (G__36370_36440__$1) {
case "or":
var statearr_36371_36442 = state_36326__$1;
(statearr_36371_36442[(1)] = (43));


break;
case "and":
var statearr_36372_36443 = state_36326__$1;
(statearr_36372_36443[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36370_36440__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (11))){
var inst_36162 = (state_36326[(14)]);
var state_36326__$1 = state_36326;
var statearr_36374_36444 = state_36326__$1;
(statearr_36374_36444[(2)] = inst_36162);

(statearr_36374_36444[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (9))){
var inst_36161 = (state_36326[(18)]);
var inst_36168 = (state_36326[(20)]);
var inst_36167 = cljs.core.seq(inst_36161);
var inst_36168__$1 = cljs.core.first(inst_36167);
var inst_36169 = cljs.core.next(inst_36167);
var inst_36170 = cljs.core.not(inst_36168__$1);
var state_36326__$1 = (function (){var statearr_36375 = state_36326;
(statearr_36375[(22)] = inst_36169);

(statearr_36375[(20)] = inst_36168__$1);

return statearr_36375;
})();
if(inst_36170){
var statearr_36376_36445 = state_36326__$1;
(statearr_36376_36445[(1)] = (11));

} else {
var statearr_36377_36446 = state_36326__$1;
(statearr_36377_36446[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (5))){
var _ = (function (){var statearr_36378 = state_36326;
(statearr_36378[(4)] = cljs.core.rest((state_36326[(4)])));

return statearr_36378;
})();
var state_36326__$1 = state_36326;
var ex36373 = (state_36326__$1[(2)]);
var statearr_36379_36447 = state_36326__$1;
(statearr_36379_36447[(5)] = ex36373);


if((ex36373 instanceof Error)){
var statearr_36380_36448 = state_36326__$1;
(statearr_36380_36448[(1)] = (4));

(statearr_36380_36448[(5)] = null);

} else {
throw ex36373;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (14))){
var inst_36176 = (state_36326[(7)]);
var inst_36182 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_36176);
var inst_36183 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36182)].join('');
var inst_36184 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36185 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36186 = cljs.core.PersistentHashMap.fromArrays(inst_36184,inst_36185);
var inst_36187 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36183,inst_36186);
var inst_36188 = (function(){throw inst_36187})();
var state_36326__$1 = state_36326;
var statearr_36381_36449 = state_36326__$1;
(statearr_36381_36449[(2)] = inst_36188);

(statearr_36381_36449[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (45))){
var inst_36303 = (state_36326[(13)]);
var inst_36306 = cljs.core.empty_QMARK_(inst_36303);
var state_36326__$1 = state_36326;
var statearr_36382_36450 = state_36326__$1;
(statearr_36382_36450[(2)] = inst_36306);

(statearr_36382_36450[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (26))){
var inst_36176 = (state_36326[(7)]);
var inst_36178 = (state_36326[(8)]);
var inst_36232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36233 = [inst_36176,inst_36178];
var inst_36234 = (new cljs.core.PersistentVector(null,2,(5),inst_36232,inst_36233,null));
var inst_36235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36236 = [inst_36176];
var inst_36237 = (new cljs.core.PersistentVector(null,1,(5),inst_36235,inst_36236,null));
var inst_36238 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_36234,cljs.core._LT__EQ_,inst_36237);
var state_36326__$1 = state_36326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36326__$1,(29),inst_36238);
} else {
if((state_val_36327 === (16))){
var inst_36195 = (state_36326[(10)]);
var inst_36177 = (state_36326[(11)]);
var inst_36191 = (state_36326[(2)]);
var inst_36195__$1 = cljs.core.identical_QMARK_;
var inst_36196 = (inst_36195__$1.cljs$core$IFn$_invoke$arity$2 ? inst_36195__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_36177) : inst_36195__$1.call(null,cljs.core.not_EQ_,inst_36177));
var state_36326__$1 = (function (){var statearr_36383 = state_36326;
(statearr_36383[(10)] = inst_36195__$1);

(statearr_36383[(23)] = inst_36191);

return statearr_36383;
})();
if(cljs.core.truth_(inst_36196)){
var statearr_36384_36451 = state_36326__$1;
(statearr_36384_36451[(1)] = (17));

} else {
var statearr_36385_36452 = state_36326__$1;
(statearr_36385_36452[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (38))){
var inst_36176 = (state_36326[(7)]);
var inst_36178 = (state_36326[(8)]);
var inst_36271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36272 = [inst_36176];
var inst_36273 = (new cljs.core.PersistentVector(null,1,(5),inst_36271,inst_36272,null));
var inst_36274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36275 = [inst_36176,inst_36178];
var inst_36276 = (new cljs.core.PersistentVector(null,2,(5),inst_36274,inst_36275,null));
var inst_36277 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_36273,cljs.core._LT__EQ_,inst_36276);
var state_36326__$1 = state_36326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36326__$1,(41),inst_36277);
} else {
if((state_val_36327 === (30))){
var inst_36176 = (state_36326[(7)]);
var inst_36178 = (state_36326[(8)]);
var inst_36245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36246 = [inst_36176,inst_36178];
var inst_36247 = (new cljs.core.PersistentVector(null,2,(5),inst_36245,inst_36246,null));
var inst_36248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36249 = [inst_36176];
var inst_36250 = (new cljs.core.PersistentVector(null,1,(5),inst_36248,inst_36249,null));
var inst_36251 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_36247,cljs.core._LT__EQ_,inst_36250);
var state_36326__$1 = state_36326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36326__$1,(33),inst_36251);
} else {
if((state_val_36327 === (10))){
var inst_36318 = (state_36326[(2)]);
var state_36326__$1 = state_36326;
var statearr_36386_36453 = state_36326__$1;
(statearr_36386_36453[(2)] = inst_36318);

(statearr_36386_36453[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (18))){
var inst_36195 = (state_36326[(10)]);
var inst_36177 = (state_36326[(11)]);
var inst_36220 = (inst_36195.cljs$core$IFn$_invoke$arity$2 ? inst_36195.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_36177) : inst_36195.call(null,cljs.core._EQ_,inst_36177));
var state_36326__$1 = state_36326;
if(cljs.core.truth_(inst_36220)){
var statearr_36387_36454 = state_36326__$1;
(statearr_36387_36454[(1)] = (22));

} else {
var statearr_36388_36455 = state_36326__$1;
(statearr_36388_36455[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (42))){
var inst_36146 = (state_36326[(21)]);
var inst_36304 = (state_36326[(12)]);
var inst_36303 = (state_36326[(2)]);
var inst_36304__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_36146);
var state_36326__$1 = (function (){var statearr_36389 = state_36326;
(statearr_36389[(12)] = inst_36304__$1);

(statearr_36389[(13)] = inst_36303);

return statearr_36389;
})();
if(inst_36304__$1){
var statearr_36390_36456 = state_36326__$1;
(statearr_36390_36456[(1)] = (45));

} else {
var statearr_36391_36457 = state_36326__$1;
(statearr_36391_36457[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (37))){
var inst_36266 = (state_36326[(2)]);
var inst_36267 = fluree.db.util.async.throw_err(inst_36266);
var state_36326__$1 = state_36326;
var statearr_36392_36458 = state_36326__$1;
(statearr_36392_36458[(2)] = inst_36267);

(statearr_36392_36458[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (8))){
var inst_36321 = (state_36326[(2)]);
var _ = (function (){var statearr_36393 = state_36326;
(statearr_36393[(4)] = cljs.core.rest((state_36326[(4)])));

return statearr_36393;
})();
var state_36326__$1 = state_36326;
var statearr_36394_36459 = state_36326__$1;
(statearr_36394_36459[(2)] = inst_36321);

(statearr_36394_36459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36327 === (49))){
var inst_36169 = (state_36326[(22)]);
var inst_36303 = (state_36326[(13)]);
var inst_36161 = inst_36169;
var inst_36162 = inst_36303;
var state_36326__$1 = (function (){var statearr_36395 = state_36326;
(statearr_36395[(14)] = inst_36162);

(statearr_36395[(18)] = inst_36161);

return statearr_36395;
})();
var statearr_36396_36460 = state_36326__$1;
(statearr_36396_36460[(2)] = null);

(statearr_36396_36460[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__14778__auto__ = null;
var fluree$db$query$fql$state_machine__14778__auto____0 = (function (){
var statearr_36397 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36397[(0)] = fluree$db$query$fql$state_machine__14778__auto__);

(statearr_36397[(1)] = (1));

return statearr_36397;
});
var fluree$db$query$fql$state_machine__14778__auto____1 = (function (state_36326){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_36326);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e36398){var ex__14781__auto__ = e36398;
var statearr_36399_36461 = state_36326;
(statearr_36399_36461[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_36326[(4)]))){
var statearr_36400_36462 = state_36326;
(statearr_36400_36462[(1)] = cljs.core.first((state_36326[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__36463 = state_36326;
state_36326 = G__36463;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__14778__auto__ = function(state_36326){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__14778__auto____1.call(this,state_36326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__14778__auto____0;
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__14778__auto____1;
return fluree$db$query$fql$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_36401 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_36401[(6)] = c__14852__auto__);

return statearr_36401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_((function (p1__36464_SHARP_){
return ((typeof p1__36464_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__36464_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__36465_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__36465_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__36469 = vars;
var vec__36470 = G__36469;
var seq__36471 = cljs.core.seq(vec__36470);
var first__36472 = cljs.core.first(seq__36471);
var seq__36471__$1 = cljs.core.next(seq__36471);
var var$ = first__36472;
var r = seq__36471__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__36469__$1 = G__36469;
var all_vars__$1 = all_vars;
while(true){
var vec__36477 = G__36469__$1;
var seq__36478 = cljs.core.seq(vec__36477);
var first__36479 = cljs.core.first(seq__36478);
var seq__36478__$1 = cljs.core.next(seq__36478);
var var$__$1 = first__36479;
var r__$1 = seq__36478__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__36480 = cljs.core.set(all_vars__$2);
return (fexpr__36480.cljs$core$IFn$_invoke$arity$1 ? fexpr__36480.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__36480.call(null,var$__$1));
})())){
var G__36481 = r__$1;
var G__36482 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__36469__$1 = G__36481;
all_vars__$1 = G__36482;
continue;
} else {
var G__36483 = r__$1;
var G__36484 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__36469__$1 = G__36483;
all_vars__$1 = G__36484;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_36519){
var state_val_36520 = (state_36519[(1)]);
if((state_val_36520 === (1))){
var inst_36492 = functionArray;
var inst_36493 = cljs.core.seq(inst_36492);
var inst_36494 = cljs.core.first(inst_36493);
var inst_36495 = cljs.core.next(inst_36493);
var inst_36496 = cljs.core.PersistentVector.EMPTY;
var inst_36497 = inst_36492;
var inst_36498 = inst_36496;
var state_36519__$1 = (function (){var statearr_36521 = state_36519;
(statearr_36521[(7)] = inst_36494);

(statearr_36521[(8)] = inst_36495);

(statearr_36521[(9)] = inst_36497);

(statearr_36521[(10)] = inst_36498);

return statearr_36521;
})();
var statearr_36522_36535 = state_36519__$1;
(statearr_36522_36535[(2)] = null);

(statearr_36522_36535[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36520 === (2))){
var inst_36504 = (state_36519[(11)]);
var inst_36497 = (state_36519[(9)]);
var inst_36503 = cljs.core.seq(inst_36497);
var inst_36504__$1 = cljs.core.first(inst_36503);
var inst_36505 = cljs.core.next(inst_36503);
var state_36519__$1 = (function (){var statearr_36523 = state_36519;
(statearr_36523[(12)] = inst_36505);

(statearr_36523[(11)] = inst_36504__$1);

return statearr_36523;
})();
if(cljs.core.truth_(inst_36504__$1)){
var statearr_36524_36536 = state_36519__$1;
(statearr_36524_36536[(1)] = (4));

} else {
var statearr_36525_36537 = state_36519__$1;
(statearr_36525_36537[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36520 === (3))){
var inst_36517 = (state_36519[(2)]);
var state_36519__$1 = state_36519;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36519__$1,inst_36517);
} else {
if((state_val_36520 === (4))){
var inst_36504 = (state_36519[(11)]);
var inst_36507 = (inst_36504.cljs$core$IFn$_invoke$arity$1 ? inst_36504.cljs$core$IFn$_invoke$arity$1(tuple) : inst_36504.call(null,tuple));
var state_36519__$1 = state_36519;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36519__$1,(7),inst_36507);
} else {
if((state_val_36520 === (5))){
var inst_36498 = (state_36519[(10)]);
var state_36519__$1 = state_36519;
var statearr_36526_36538 = state_36519__$1;
(statearr_36526_36538[(2)] = inst_36498);

(statearr_36526_36538[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36520 === (6))){
var inst_36515 = (state_36519[(2)]);
var state_36519__$1 = state_36519;
var statearr_36527_36539 = state_36519__$1;
(statearr_36527_36539[(2)] = inst_36515);

(statearr_36527_36539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36520 === (7))){
var inst_36505 = (state_36519[(12)]);
var inst_36498 = (state_36519[(10)]);
var inst_36509 = (state_36519[(2)]);
var inst_36510 = fluree.db.util.async.throw_err(inst_36509);
var inst_36511 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36498,inst_36510);
var inst_36497 = inst_36505;
var inst_36498__$1 = inst_36511;
var state_36519__$1 = (function (){var statearr_36528 = state_36519;
(statearr_36528[(9)] = inst_36497);

(statearr_36528[(10)] = inst_36498__$1);

return statearr_36528;
})();
var statearr_36529_36540 = state_36519__$1;
(statearr_36529_36540[(2)] = null);

(statearr_36529_36540[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__14778__auto____0 = (function (){
var statearr_36530 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36530[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__14778__auto__);

(statearr_36530[(1)] = (1));

return statearr_36530;
});
var fluree$db$query$fql$format_tuple_$_state_machine__14778__auto____1 = (function (state_36519){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_36519);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e36531){var ex__14781__auto__ = e36531;
var statearr_36532_36541 = state_36519;
(statearr_36532_36541[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_36519[(4)]))){
var statearr_36533_36542 = state_36519;
(statearr_36533_36542[(1)] = cljs.core.first((state_36519[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__36543 = state_36519;
state_36519 = G__36543;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__14778__auto__ = function(state_36519){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__14778__auto____1.call(this,state_36519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__14778__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__14778__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_36534 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_36534[(6)] = c__14852__auto__);

return statearr_36534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__36544){
var vec__36545 = p__36544;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36545,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36545,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_36559){
var state_val_36560 = (state_36559[(1)]);
if((state_val_36560 === (1))){
var inst_36548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36549 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_36550 = [query_map,_id,query_opts];
var inst_36551 = cljs.core.PersistentHashMap.fromArrays(inst_36549,inst_36550);
var inst_36552 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_36551) : fluree.db.query.fql.query.call(null,db,inst_36551));
var state_36559__$1 = (function (){var statearr_36561 = state_36559;
(statearr_36561[(7)] = inst_36548);

return statearr_36561;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36559__$1,(2),inst_36552);
} else {
if((state_val_36560 === (2))){
var inst_36548 = (state_36559[(7)]);
var inst_36554 = (state_36559[(2)]);
var inst_36555 = fluree.db.util.async.throw_err(inst_36554);
var inst_36556 = [tuple_index,inst_36555];
var inst_36557 = (new cljs.core.PersistentVector(null,2,(5),inst_36548,inst_36556,null));
var state_36559__$1 = state_36559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36559__$1,inst_36557);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__14778__auto____0 = (function (){
var statearr_36562 = [null,null,null,null,null,null,null,null];
(statearr_36562[(0)] = fluree$db$query$fql$expand_map_$_state_machine__14778__auto__);

(statearr_36562[(1)] = (1));

return statearr_36562;
});
var fluree$db$query$fql$expand_map_$_state_machine__14778__auto____1 = (function (state_36559){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_36559);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e36563){var ex__14781__auto__ = e36563;
var statearr_36564_36567 = state_36559;
(statearr_36564_36567[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_36559[(4)]))){
var statearr_36565_36568 = state_36559;
(statearr_36565_36568[(1)] = cljs.core.first((state_36559[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__36569 = state_36559;
state_36559 = G__36569;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__14778__auto__ = function(state_36559){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__14778__auto____1.call(this,state_36559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__14778__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__14778__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_36566 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_36566[(6)] = c__14852__auto__);

return statearr_36566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__36570 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36570,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36570,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_36635){
var state_val_36636 = (state_36635[(1)]);
if((state_val_36636 === (7))){
var inst_36630 = (state_36635[(2)]);
var _ = (function (){var statearr_36637 = state_36635;
(statearr_36637[(4)] = cljs.core.rest((state_36635[(4)])));

return statearr_36637;
})();
var state_36635__$1 = state_36635;
var statearr_36638_36729 = state_36635__$1;
(statearr_36638_36729[(2)] = inst_36630);

(statearr_36638_36729[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (20))){
var inst_36621 = (state_36635[(2)]);
var state_36635__$1 = state_36635;
var statearr_36639_36730 = state_36635__$1;
(statearr_36639_36730[(2)] = inst_36621);

(statearr_36639_36730[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (1))){
var state_36635__$1 = state_36635;
var statearr_36640_36731 = state_36635__$1;
(statearr_36640_36731[(2)] = null);

(statearr_36640_36731[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (4))){
var inst_36575 = (state_36635[(2)]);
var state_36635__$1 = state_36635;
var statearr_36641_36732 = state_36635__$1;
(statearr_36641_36732[(2)] = inst_36575);

(statearr_36641_36732[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (15))){
var inst_36595 = (state_36635[(7)]);
var inst_36604 = cljs.core._deref(fuel);
var inst_36605 = cljs.core.second(inst_36595);
var inst_36606 = (inst_36604 + inst_36605);
var inst_36607 = cljs.core._vreset_BANG_(fuel,inst_36606);
var inst_36608 = (inst_36607 > max_fuel);
var state_36635__$1 = state_36635;
if(cljs.core.truth_(inst_36608)){
var statearr_36642_36733 = state_36635__$1;
(statearr_36642_36733[(1)] = (18));

} else {
var statearr_36643_36734 = state_36635__$1;
(statearr_36643_36734[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (13))){
var state_36635__$1 = state_36635;
var statearr_36644_36735 = state_36635__$1;
(statearr_36644_36735[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (6))){
var inst_36583 = (state_36635[(8)]);
var state_36635__$1 = state_36635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36635__$1,(8),inst_36583);
} else {
if((state_val_36636 === (17))){
var inst_36624 = (state_36635[(2)]);
var state_36635__$1 = state_36635;
var statearr_36646_36736 = state_36635__$1;
(statearr_36646_36736[(2)] = inst_36624);

(statearr_36646_36736[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (3))){
var inst_36633 = (state_36635[(2)]);
var state_36635__$1 = state_36635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36635__$1,inst_36633);
} else {
if((state_val_36636 === (12))){
var inst_36595 = (state_36635[(7)]);
var inst_36584 = (state_36635[(9)]);
var inst_36601 = (inst_36584.cljs$core$IFn$_invoke$arity$0 ? inst_36584.cljs$core$IFn$_invoke$arity$0() : inst_36584.call(null));
var state_36635__$1 = (function (){var statearr_36647 = state_36635;
(statearr_36647[(10)] = inst_36601);

return statearr_36647;
})();
var statearr_36648_36737 = state_36635__$1;
(statearr_36648_36737[(2)] = inst_36595);

(statearr_36648_36737[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (2))){
var inst_36583 = (state_36635[(8)]);
var inst_36584 = (state_36635[(9)]);
var _ = (function (){var statearr_36649 = state_36635;
(statearr_36649[(4)] = cljs.core.cons((5),(state_36635[(4)])));

return statearr_36649;
})();
var inst_36581 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_36582 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_36583__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_36584__$1 = (function (){var expandMaps = inst_36581;
var queue_ch = inst_36582;
var res_ch = inst_36583__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_36585 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_36586 = cljs.core.volatile_BANG_((0));
var inst_36587 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36585,cljs.core.cst$kw$fuel,inst_36586);
var inst_36588 = (function (){var expandMaps = inst_36581;
var queue_ch = inst_36582;
var res_ch = inst_36583__$1;
var stop_BANG_ = inst_36584__$1;
var opts_STAR_ = inst_36587;
return (function (tuple_res,port){
var c__14852__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_36682){
var state_val_36683 = (state_36682[(1)]);
if((state_val_36683 === (7))){
var state_36682__$1 = state_36682;
var statearr_36684_36738 = state_36682__$1;
(statearr_36684_36738[(2)] = tuple_res);

(statearr_36684_36738[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36683 === (1))){
var state_36682__$1 = state_36682;
var statearr_36685_36739 = state_36682__$1;
(statearr_36685_36739[(2)] = null);

(statearr_36685_36739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36683 === (4))){
var inst_36650 = (state_36682[(2)]);
var inst_36651 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_36650);
var inst_36652 = cljs.core.async.close_BANG_(port);
var state_36682__$1 = (function (){var statearr_36686 = state_36682;
(statearr_36686[(7)] = inst_36651);

return statearr_36686;
})();
var statearr_36687_36740 = state_36682__$1;
(statearr_36687_36740[(2)] = inst_36652);

(statearr_36687_36740[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36683 === (6))){
var inst_36659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36660 = [tuple_res];
var inst_36661 = (new cljs.core.PersistentVector(null,1,(5),inst_36659,inst_36660,null));
var state_36682__$1 = state_36682;
var statearr_36688_36741 = state_36682__$1;
(statearr_36688_36741[(2)] = inst_36661);

(statearr_36688_36741[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36683 === (3))){
var inst_36680 = (state_36682[(2)]);
var state_36682__$1 = state_36682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36682__$1,inst_36680);
} else {
if((state_val_36683 === (2))){
var ___$1 = (function (){var statearr_36690 = state_36682;
(statearr_36690[(4)] = cljs.core.cons((5),(state_36682[(4)])));

return statearr_36690;
})();
var state_36682__$1 = state_36682;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_36691_36742 = state_36682__$1;
(statearr_36691_36742[(1)] = (6));

} else {
var statearr_36692_36743 = state_36682__$1;
(statearr_36692_36743[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36683 === (9))){
var inst_36664 = (state_36682[(8)]);
var inst_36666 = (state_36682[(9)]);
var inst_36673 = (state_36682[(2)]);
var inst_36674 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_36664,inst_36673);
var inst_36675 = (inst_36666.cljs$core$IFn$_invoke$arity$1 ? inst_36666.cljs$core$IFn$_invoke$arity$1(inst_36674) : inst_36666.call(null,inst_36674));
var inst_36676 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_36675);
var inst_36677 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_36693 = state_36682;
(statearr_36693[(4)] = cljs.core.rest((state_36682[(4)])));

return statearr_36693;
})();
var state_36682__$1 = (function (){var statearr_36694 = state_36682;
(statearr_36694[(10)] = inst_36676);

return statearr_36694;
})();
var statearr_36695_36744 = state_36682__$1;
(statearr_36695_36744[(2)] = inst_36677);

(statearr_36695_36744[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36683 === (5))){
var ___$1 = (function (){var statearr_36696 = state_36682;
(statearr_36696[(4)] = cljs.core.rest((state_36682[(4)])));

return statearr_36696;
})();
var state_36682__$1 = state_36682;
var ex36689 = (state_36682__$1[(2)]);
var statearr_36697_36745 = state_36682__$1;
(statearr_36697_36745[(5)] = ex36689);


var statearr_36698_36746 = state_36682__$1;
(statearr_36698_36746[(1)] = (4));

(statearr_36698_36746[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36683 === (8))){
var inst_36664 = (state_36682[(8)]);
var inst_36664__$1 = (state_36682[(2)]);
var inst_36665 = cljs.core.volatile_BANG_((0));
var inst_36666 = (function (){var tuple_res_SINGLEQUOTE_ = inst_36664__$1;
var query_fuel = inst_36665;
return (function (p1__36574_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__36574_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36574_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_36667 = cljs.core.PersistentVector.EMPTY;
var inst_36668 = (function (){var tuple_res_SINGLEQUOTE_ = inst_36664__$1;
var query_fuel = inst_36665;
return (function (p1__36573_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__36573_SHARP_);
});
})();
var inst_36669 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_36668,expandMaps);
var inst_36670 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_36669);
var inst_36671 = cljs.core.async.into(inst_36667,inst_36670);
var state_36682__$1 = (function (){var statearr_36699 = state_36682;
(statearr_36699[(8)] = inst_36664__$1);

(statearr_36699[(9)] = inst_36666);

return statearr_36699;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36682__$1,(9),inst_36671);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____0 = (function (){
var statearr_36700 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36700[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__);

(statearr_36700[(1)] = (1));

return statearr_36700;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____1 = (function (state_36682){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_36682);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e36701){var ex__14781__auto__ = e36701;
var statearr_36702_36747 = state_36682;
(statearr_36702_36747[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_36682[(4)]))){
var statearr_36703_36748 = state_36682;
(statearr_36703_36748[(1)] = cljs.core.first((state_36682[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__36749 = state_36682;
state_36682 = G__36749;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__ = function(state_36682){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____1.call(this,state_36682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_36704 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_36704[(6)] = c__14852__auto____$1);

return statearr_36704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto____$1;
});
})();
var inst_36589 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_36582,tuples_res);
var inst_36590 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_36583__$1,inst_36588,inst_36582);
var inst_36591 = cljs.core.PersistentVector.EMPTY;
var inst_36592 = inst_36591;
var state_36635__$1 = (function (){var statearr_36705 = state_36635;
(statearr_36705[(8)] = inst_36583__$1);

(statearr_36705[(11)] = inst_36592);

(statearr_36705[(9)] = inst_36584__$1);

(statearr_36705[(12)] = inst_36589);

(statearr_36705[(13)] = inst_36590);

return statearr_36705;
})();
var statearr_36706_36750 = state_36635__$1;
(statearr_36706_36750[(2)] = null);

(statearr_36706_36750[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (19))){
var inst_36592 = (state_36635[(11)]);
var inst_36595 = (state_36635[(7)]);
var inst_36617 = cljs.core.first(inst_36595);
var inst_36618 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36592,inst_36617);
var inst_36592__$1 = inst_36618;
var state_36635__$1 = (function (){var statearr_36707 = state_36635;
(statearr_36707[(11)] = inst_36592__$1);

return statearr_36707;
})();
var statearr_36708_36751 = state_36635__$1;
(statearr_36708_36751[(2)] = null);

(statearr_36708_36751[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (11))){
var inst_36628 = (state_36635[(2)]);
var state_36635__$1 = state_36635;
var statearr_36710_36752 = state_36635__$1;
(statearr_36710_36752[(2)] = inst_36628);

(statearr_36710_36752[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (9))){
var inst_36592 = (state_36635[(11)]);
var state_36635__$1 = state_36635;
var statearr_36711_36753 = state_36635__$1;
(statearr_36711_36753[(2)] = inst_36592);

(statearr_36711_36753[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (5))){
var _ = (function (){var statearr_36712 = state_36635;
(statearr_36712[(4)] = cljs.core.rest((state_36635[(4)])));

return statearr_36712;
})();
var state_36635__$1 = state_36635;
var ex36709 = (state_36635__$1[(2)]);
var statearr_36713_36754 = state_36635__$1;
(statearr_36713_36754[(5)] = ex36709);


if((ex36709 instanceof Error)){
var statearr_36714_36755 = state_36635__$1;
(statearr_36714_36755[(1)] = (4));

(statearr_36714_36755[(5)] = null);

} else {
throw ex36709;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (14))){
var inst_36626 = (state_36635[(2)]);
var state_36635__$1 = state_36635;
var statearr_36715_36756 = state_36635__$1;
(statearr_36715_36756[(2)] = inst_36626);

(statearr_36715_36756[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (16))){
var state_36635__$1 = state_36635;
var statearr_36716_36757 = state_36635__$1;
(statearr_36716_36757[(2)] = null);

(statearr_36716_36757[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (10))){
var inst_36595 = (state_36635[(7)]);
var inst_36599 = fluree.db.util.core.exception_QMARK_(inst_36595);
var state_36635__$1 = state_36635;
if(inst_36599){
var statearr_36717_36758 = state_36635__$1;
(statearr_36717_36758[(1)] = (12));

} else {
var statearr_36718_36759 = state_36635__$1;
(statearr_36718_36759[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (18))){
var inst_36584 = (state_36635[(9)]);
var inst_36610 = (inst_36584.cljs$core$IFn$_invoke$arity$0 ? inst_36584.cljs$core$IFn$_invoke$arity$0() : inst_36584.call(null));
var inst_36611 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_36612 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_36613 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_36614 = cljs.core.PersistentHashMap.fromArrays(inst_36612,inst_36613);
var inst_36615 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36611,inst_36614);
var state_36635__$1 = (function (){var statearr_36719 = state_36635;
(statearr_36719[(14)] = inst_36610);

return statearr_36719;
})();
var statearr_36720_36760 = state_36635__$1;
(statearr_36720_36760[(2)] = inst_36615);

(statearr_36720_36760[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36636 === (8))){
var inst_36595 = (state_36635[(7)]);
var inst_36595__$1 = (state_36635[(2)]);
var inst_36596 = (inst_36595__$1 == null);
var state_36635__$1 = (function (){var statearr_36721 = state_36635;
(statearr_36721[(7)] = inst_36595__$1);

return statearr_36721;
})();
if(cljs.core.truth_(inst_36596)){
var statearr_36722_36761 = state_36635__$1;
(statearr_36722_36761[(1)] = (9));

} else {
var statearr_36723_36762 = state_36635__$1;
(statearr_36723_36762[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____0 = (function (){
var statearr_36724 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36724[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__);

(statearr_36724[(1)] = (1));

return statearr_36724;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____1 = (function (state_36635){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_36635);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e36725){var ex__14781__auto__ = e36725;
var statearr_36726_36763 = state_36635;
(statearr_36726_36763[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_36635[(4)]))){
var statearr_36727_36764 = state_36635;
(statearr_36727_36764[(1)] = cljs.core.first((state_36635[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__36765 = state_36635;
state_36635 = G__36765;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__ = function(state_36635){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____1.call(this,state_36635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_36728 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_36728[(6)] = c__14852__auto__);

return statearr_36728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__36766 = select;
var map__36766__$1 = cljs.core.__destructure_map(map__36766);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36766__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36766__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36766__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__36769 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36769,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36769,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36769,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__36767_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__36767_SHARP_,compare_idx));
}):(function (p1__36768_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__36768_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__36774 = arguments.length;
switch (G__36774) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__36775,p__36776,group_limit,opts){
var map__36777 = p__36775;
var map__36777__$1 = cljs.core.__destructure_map(map__36777);
var res = map__36777__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36777__$1,cljs.core.cst$kw$vars);
var map__36778 = p__36776;
var map__36778__$1 = cljs.core.__destructure_map(map__36778);
var select_spec = map__36778__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36778__$1,cljs.core.cst$kw$groupBy);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_36915){
var state_val_36916 = (state_36915[(1)]);
if((state_val_36916 === (7))){
var inst_36785 = (state_36915[(7)]);
var state_36915__$1 = state_36915;
var statearr_36917_37019 = state_36915__$1;
(statearr_36917_37019[(2)] = inst_36785);

(statearr_36917_37019[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (59))){
var inst_36908 = (state_36915[(2)]);
var state_36915__$1 = state_36915;
var statearr_36918_37020 = state_36915__$1;
(statearr_36918_37020[(2)] = inst_36908);

(statearr_36918_37020[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (20))){
var inst_36824 = (state_36915[(8)]);
var inst_36821 = (state_36915[(9)]);
var inst_36820 = (state_36915[(2)]);
var inst_36821__$1 = cljs.core.__destructure_map(inst_36820);
var inst_36822 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36821__$1,cljs.core.cst$kw$headers);
var inst_36823 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36821__$1,cljs.core.cst$kw$tuples);
var inst_36824__$1 = offset;
var state_36915__$1 = (function (){var statearr_36919 = state_36915;
(statearr_36919[(8)] = inst_36824__$1);

(statearr_36919[(9)] = inst_36821__$1);

(statearr_36919[(10)] = inst_36822);

(statearr_36919[(11)] = inst_36823);

return statearr_36919;
})();
if(cljs.core.truth_(inst_36824__$1)){
var statearr_36920_37021 = state_36915__$1;
(statearr_36920_37021[(1)] = (21));

} else {
var statearr_36921_37022 = state_36915__$1;
(statearr_36921_37022[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (58))){
var inst_36900 = (state_36915[(12)]);
var state_36915__$1 = state_36915;
var statearr_36922_37023 = state_36915__$1;
(statearr_36922_37023[(2)] = inst_36900);

(statearr_36922_37023[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (60))){
var inst_36904 = (state_36915[(2)]);
var inst_36905 = fluree.db.util.async.throw_err(inst_36904);
var state_36915__$1 = state_36915;
var statearr_36923_37024 = state_36915__$1;
(statearr_36923_37024[(2)] = inst_36905);

(statearr_36923_37024[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (27))){
var inst_36836 = cljs.core.not(inVector_QMARK_);
var state_36915__$1 = state_36915;
var statearr_36924_37025 = state_36915__$1;
(statearr_36924_37025[(2)] = inst_36836);

(statearr_36924_37025[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (1))){
var state_36915__$1 = state_36915;
var statearr_36925_37026 = state_36915__$1;
(statearr_36925_37026[(2)] = null);

(statearr_36925_37026[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (24))){
var state_36915__$1 = state_36915;
var statearr_36926_37027 = state_36915__$1;
(statearr_36926_37027[(2)] = offset);

(statearr_36926_37027[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (55))){
var inst_36894 = (state_36915[(13)]);
var state_36915__$1 = state_36915;
var statearr_36927_37028 = state_36915__$1;
(statearr_36927_37028[(2)] = inst_36894);

(statearr_36927_37028[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (39))){
var inst_36862 = (state_36915[(14)]);
var inst_36864 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_36865 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36862,inst_36864);
var state_36915__$1 = state_36915;
var statearr_36928_37029 = state_36915__$1;
(statearr_36928_37029[(2)] = inst_36865);

(statearr_36928_37029[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (46))){
var inst_36874 = (state_36915[(15)]);
var state_36915__$1 = state_36915;
var statearr_36929_37030 = state_36915__$1;
(statearr_36929_37030[(2)] = inst_36874);

(statearr_36929_37030[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (4))){
var inst_36779 = (state_36915[(2)]);
var state_36915__$1 = state_36915;
var statearr_36930_37031 = state_36915__$1;
(statearr_36930_37031[(2)] = inst_36779);

(statearr_36930_37031[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (54))){
var inst_36894 = (state_36915[(13)]);
var inst_36888 = (state_36915[(16)]);
var inst_36896 = cljs.core.PersistentVector.EMPTY;
var inst_36897 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_36896,inst_36888,inst_36894);
var state_36915__$1 = state_36915;
var statearr_36931_37032 = state_36915__$1;
(statearr_36931_37032[(2)] = inst_36897);

(statearr_36931_37032[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (15))){
var inst_36806 = (state_36915[(17)]);
var inst_36808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36809 = [inst_36806];
var inst_36810 = (new cljs.core.PersistentVector(null,1,(5),inst_36808,inst_36809,null));
var state_36915__$1 = state_36915;
var statearr_36932_37033 = state_36915__$1;
(statearr_36932_37033[(2)] = inst_36810);

(statearr_36932_37033[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (48))){
var inst_36833 = (state_36915[(18)]);
var inst_36821 = (state_36915[(9)]);
var inst_36839 = (state_36915[(19)]);
var inst_36822 = (state_36915[(10)]);
var inst_36823 = (state_36915[(11)]);
var inst_36844 = (state_36915[(20)]);
var inst_36880 = (state_36915[(21)]);
var inst_36882 = (function (){var map__36815 = inst_36821;
var headers = inst_36822;
var tuples = inst_36823;
var offset_SINGLEQUOTE_ = inst_36833;
var single_result_QMARK_ = inst_36839;
var pp_keys = inst_36844;
var G__36845 = inst_36880;
return (function (p1__36772_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__36772_SHARP_);
});
})();
var inst_36883 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_36882);
var inst_36884 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36880,inst_36883);
var state_36915__$1 = state_36915;
var statearr_36933_37034 = state_36915__$1;
(statearr_36933_37034[(2)] = inst_36884);

(statearr_36933_37034[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (50))){
var inst_36887 = (state_36915[(2)]);
var inst_36888 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_36887);
var state_36915__$1 = (function (){var statearr_36934 = state_36915;
(statearr_36934[(16)] = inst_36888);

return statearr_36934;
})();
if(cljs.core.truth_(orderBy)){
var statearr_36935_37035 = state_36915__$1;
(statearr_36935_37035[(1)] = (51));

} else {
var statearr_36936_37036 = state_36915__$1;
(statearr_36936_37036[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (21))){
var inst_36826 = cljs.core.not(groupBy);
var state_36915__$1 = state_36915;
var statearr_36937_37037 = state_36915__$1;
(statearr_36937_37037[(2)] = inst_36826);

(statearr_36937_37037[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (31))){
var state_36915__$1 = state_36915;
var statearr_36938_37038 = state_36915__$1;
(statearr_36938_37038[(2)] = null);

(statearr_36938_37038[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (32))){
var inst_36839 = (state_36915[(19)]);
var inst_36822 = (state_36915[(10)]);
var inst_36844 = (state_36915[(2)]);
var inst_36846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36847 = fluree.db.query.fql.select_tuples_fn(inst_36822,vars,select);
var inst_36848 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_36847);
var inst_36849 = [inst_36848];
var inst_36850 = (new cljs.core.PersistentVector(null,1,(5),inst_36846,inst_36849,null));
var state_36915__$1 = (function (){var statearr_36939 = state_36915;
(statearr_36939[(22)] = inst_36850);

(statearr_36939[(20)] = inst_36844);

return statearr_36939;
})();
if(cljs.core.truth_(inst_36839)){
var statearr_36940_37039 = state_36915__$1;
(statearr_36940_37039[(1)] = (33));

} else {
var statearr_36941_37040 = state_36915__$1;
(statearr_36941_37040[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (40))){
var inst_36862 = (state_36915[(14)]);
var state_36915__$1 = state_36915;
var statearr_36942_37041 = state_36915__$1;
(statearr_36942_37041[(2)] = inst_36862);

(statearr_36942_37041[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (56))){
var inst_36900 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36943 = state_36915;
(statearr_36943[(12)] = inst_36900);

return statearr_36943;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_36944_37042 = state_36915__$1;
(statearr_36944_37042[(1)] = (57));

} else {
var statearr_36945_37043 = state_36915__$1;
(statearr_36945_37043[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (33))){
var inst_36850 = (state_36915[(22)]);
var inst_36852 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_36853 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36850,inst_36852);
var state_36915__$1 = state_36915;
var statearr_36946_37044 = state_36915__$1;
(statearr_36946_37044[(2)] = inst_36853);

(statearr_36946_37044[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (13))){
var inst_36795 = (state_36915[(23)]);
var state_36915__$1 = state_36915;
var statearr_36947_37045 = state_36915__$1;
(statearr_36947_37045[(2)] = inst_36795);

(statearr_36947_37045[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (22))){
var inst_36824 = (state_36915[(8)]);
var state_36915__$1 = state_36915;
var statearr_36948_37046 = state_36915__$1;
(statearr_36948_37046[(2)] = inst_36824);

(statearr_36948_37046[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (36))){
var inst_36856 = (state_36915[(24)]);
var inst_36858 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_36859 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36856,inst_36858);
var state_36915__$1 = state_36915;
var statearr_36949_37047 = state_36915__$1;
(statearr_36949_37047[(2)] = inst_36859);

(statearr_36949_37047[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (41))){
var inst_36833 = (state_36915[(18)]);
var inst_36868 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36950 = state_36915;
(statearr_36950[(25)] = inst_36868);

return statearr_36950;
})();
if(cljs.core.truth_(inst_36833)){
var statearr_36951_37048 = state_36915__$1;
(statearr_36951_37048[(1)] = (42));

} else {
var statearr_36952_37049 = state_36915__$1;
(statearr_36952_37049[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (43))){
var inst_36868 = (state_36915[(25)]);
var state_36915__$1 = state_36915;
var statearr_36953_37050 = state_36915__$1;
(statearr_36953_37050[(2)] = inst_36868);

(statearr_36953_37050[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (29))){
var inst_36839 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36954 = state_36915;
(statearr_36954[(19)] = inst_36839);

return statearr_36954;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36955_37051 = state_36915__$1;
(statearr_36955_37051[(1)] = (30));

} else {
var statearr_36956_37052 = state_36915__$1;
(statearr_36956_37052[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (44))){
var inst_36874 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36957 = state_36915;
(statearr_36957[(15)] = inst_36874);

return statearr_36957;
})();
if(cljs.core.truth_(group_limit)){
var statearr_36958_37053 = state_36915__$1;
(statearr_36958_37053[(1)] = (45));

} else {
var statearr_36959_37054 = state_36915__$1;
(statearr_36959_37054[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (6))){
var inst_36787 = cljs.core.count(select);
var inst_36788 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_36787);
var state_36915__$1 = state_36915;
var statearr_36960_37055 = state_36915__$1;
(statearr_36960_37055[(2)] = inst_36788);

(statearr_36960_37055[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (28))){
var inst_36834 = (state_36915[(26)]);
var state_36915__$1 = state_36915;
var statearr_36961_37056 = state_36915__$1;
(statearr_36961_37056[(2)] = inst_36834);

(statearr_36961_37056[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (51))){
var inst_36822 = (state_36915[(10)]);
var inst_36823 = (state_36915[(11)]);
var inst_36891 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_36822,orderBy,inst_36823);
var state_36915__$1 = state_36915;
var statearr_36962_37057 = state_36915__$1;
(statearr_36962_37057[(2)] = inst_36891);

(statearr_36962_37057[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (25))){
var state_36915__$1 = state_36915;
var statearr_36963_37058 = state_36915__$1;
(statearr_36963_37058[(2)] = null);

(statearr_36963_37058[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (34))){
var inst_36850 = (state_36915[(22)]);
var state_36915__$1 = state_36915;
var statearr_36964_37059 = state_36915__$1;
(statearr_36964_37059[(2)] = inst_36850);

(statearr_36964_37059[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (17))){
var inst_36813 = (state_36915[(2)]);
var state_36915__$1 = state_36915;
var statearr_36965_37060 = state_36915__$1;
(statearr_36965_37060[(2)] = inst_36813);

(statearr_36965_37060[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (3))){
var inst_36913 = (state_36915[(2)]);
var state_36915__$1 = state_36915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36915__$1,inst_36913);
} else {
if((state_val_36916 === (12))){
var inst_36795 = (state_36915[(23)]);
var inst_36797 = cljs.core.first(select);
var inst_36798 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_36797);
var inst_36799 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36798);
var inst_36800 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_36799,(1));
var inst_36801 = [inst_36800];
var inst_36802 = [inst_36795];
var inst_36803 = cljs.core.PersistentHashMap.fromArrays(inst_36801,inst_36802);
var state_36915__$1 = state_36915;
var statearr_36966_37061 = state_36915__$1;
(statearr_36966_37061[(2)] = inst_36803);

(statearr_36966_37061[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (2))){
var inst_36785 = (state_36915[(7)]);
var _ = (function (){var statearr_36967 = state_36915;
(statearr_36967[(4)] = cljs.core.cons((5),(state_36915[(4)])));

return statearr_36967;
})();
var inst_36785__$1 = aggregates;
var state_36915__$1 = (function (){var statearr_36968 = state_36915;
(statearr_36968[(7)] = inst_36785__$1);

return statearr_36968;
})();
if(cljs.core.truth_(inst_36785__$1)){
var statearr_36969_37062 = state_36915__$1;
(statearr_36969_37062[(1)] = (6));

} else {
var statearr_36970_37063 = state_36915__$1;
(statearr_36970_37063[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (23))){
var inst_36829 = (state_36915[(2)]);
var state_36915__$1 = state_36915;
if(cljs.core.truth_(inst_36829)){
var statearr_36971_37064 = state_36915__$1;
(statearr_36971_37064[(1)] = (24));

} else {
var statearr_36972_37065 = state_36915__$1;
(statearr_36972_37065[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (47))){
var inst_36880 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36973 = state_36915;
(statearr_36973[(21)] = inst_36880);

return statearr_36973;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36974_37066 = state_36915__$1;
(statearr_36974_37066[(1)] = (48));

} else {
var statearr_36975_37067 = state_36915__$1;
(statearr_36975_37067[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (35))){
var inst_36856 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36976 = state_36915;
(statearr_36976[(24)] = inst_36856);

return statearr_36976;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36977_37068 = state_36915__$1;
(statearr_36977_37068[(1)] = (36));

} else {
var statearr_36978_37069 = state_36915__$1;
(statearr_36978_37069[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (19))){
var state_36915__$1 = state_36915;
var statearr_36979_37070 = state_36915__$1;
(statearr_36979_37070[(2)] = res);

(statearr_36979_37070[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (57))){
var inst_36900 = (state_36915[(12)]);
var inst_36839 = (state_36915[(19)]);
var inst_36844 = (state_36915[(20)]);
var inst_36902 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_36844,inst_36839,db,fuel,max_fuel,opts,(8),inst_36900);
var state_36915__$1 = state_36915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36915__$1,(60),inst_36902);
} else {
if((state_val_36916 === (11))){
var inst_36910 = (state_36915[(2)]);
var _ = (function (){var statearr_36981 = state_36915;
(statearr_36981[(4)] = cljs.core.rest((state_36915[(4)])));

return statearr_36981;
})();
var state_36915__$1 = state_36915;
var statearr_36982_37071 = state_36915__$1;
(statearr_36982_37071[(2)] = inst_36910);

(statearr_36982_37071[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (9))){
var inst_36793 = cljs.core.first(aggregates);
var inst_36794 = fluree.db.query.analytical.calculate_aggregate(res,inst_36793);
var inst_36795 = cljs.core.second(inst_36794);
var state_36915__$1 = (function (){var statearr_36983 = state_36915;
(statearr_36983[(23)] = inst_36795);

return statearr_36983;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36984_37072 = state_36915__$1;
(statearr_36984_37072[(1)] = (12));

} else {
var statearr_36985_37073 = state_36915__$1;
(statearr_36985_37073[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (5))){
var _ = (function (){var statearr_36986 = state_36915;
(statearr_36986[(4)] = cljs.core.rest((state_36915[(4)])));

return statearr_36986;
})();
var state_36915__$1 = state_36915;
var ex36980 = (state_36915__$1[(2)]);
var statearr_36987_37074 = state_36915__$1;
(statearr_36987_37074[(5)] = ex36980);


if((ex36980 instanceof Error)){
var statearr_36988_37075 = state_36915__$1;
(statearr_36988_37075[(1)] = (4));

(statearr_36988_37075[(5)] = null);

} else {
throw ex36980;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (14))){
var inst_36806 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36989 = state_36915;
(statearr_36989[(17)] = inst_36806);

return statearr_36989;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_36990_37076 = state_36915__$1;
(statearr_36990_37076[(1)] = (15));

} else {
var statearr_36991_37077 = state_36915__$1;
(statearr_36991_37077[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (45))){
var inst_36874 = (state_36915[(15)]);
var inst_36876 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_36877 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36874,inst_36876);
var state_36915__$1 = state_36915;
var statearr_36992_37078 = state_36915__$1;
(statearr_36992_37078[(2)] = inst_36877);

(statearr_36992_37078[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (53))){
var inst_36894 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_36993 = state_36915;
(statearr_36993[(13)] = inst_36894);

return statearr_36993;
})();
var statearr_36994_37079 = state_36915__$1;
(statearr_36994_37079[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (26))){
var inst_36834 = (state_36915[(26)]);
var inst_36833 = (state_36915[(2)]);
var inst_36834__$1 = cljs.core.not(prettyPrint);
var state_36915__$1 = (function (){var statearr_36996 = state_36915;
(statearr_36996[(18)] = inst_36833);

(statearr_36996[(26)] = inst_36834__$1);

return statearr_36996;
})();
if(inst_36834__$1){
var statearr_36997_37080 = state_36915__$1;
(statearr_36997_37080[(1)] = (27));

} else {
var statearr_36998_37081 = state_36915__$1;
(statearr_36998_37081[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (16))){
var inst_36806 = (state_36915[(17)]);
var state_36915__$1 = state_36915;
var statearr_36999_37082 = state_36915__$1;
(statearr_36999_37082[(2)] = inst_36806);

(statearr_36999_37082[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (38))){
var inst_36862 = (state_36915[(2)]);
var state_36915__$1 = (function (){var statearr_37000 = state_36915;
(statearr_37000[(14)] = inst_36862);

return statearr_37000;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37001_37083 = state_36915__$1;
(statearr_37001_37083[(1)] = (39));

} else {
var statearr_37002_37084 = state_36915__$1;
(statearr_37002_37084[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (30))){
var inst_36841 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_36915__$1 = state_36915;
var statearr_37003_37085 = state_36915__$1;
(statearr_37003_37085[(2)] = inst_36841);

(statearr_37003_37085[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (10))){
var state_36915__$1 = state_36915;
if(cljs.core.truth_(aggregates)){
var statearr_37004_37086 = state_36915__$1;
(statearr_37004_37086[(1)] = (18));

} else {
var statearr_37005_37087 = state_36915__$1;
(statearr_37005_37087[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (18))){
var inst_36817 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_36915__$1 = state_36915;
var statearr_37006_37088 = state_36915__$1;
(statearr_37006_37088[(2)] = inst_36817);

(statearr_37006_37088[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (52))){
var inst_36823 = (state_36915[(11)]);
var state_36915__$1 = state_36915;
var statearr_37007_37089 = state_36915__$1;
(statearr_37007_37089[(2)] = inst_36823);

(statearr_37007_37089[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (42))){
var inst_36833 = (state_36915[(18)]);
var inst_36868 = (state_36915[(25)]);
var inst_36870 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_36833);
var inst_36871 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36868,inst_36870);
var state_36915__$1 = state_36915;
var statearr_37008_37090 = state_36915__$1;
(statearr_37008_37090[(2)] = inst_36871);

(statearr_37008_37090[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (37))){
var inst_36856 = (state_36915[(24)]);
var state_36915__$1 = state_36915;
var statearr_37009_37091 = state_36915__$1;
(statearr_37009_37091[(2)] = inst_36856);

(statearr_37009_37091[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (8))){
var inst_36791 = (state_36915[(2)]);
var state_36915__$1 = state_36915;
if(cljs.core.truth_(inst_36791)){
var statearr_37010_37092 = state_36915__$1;
(statearr_37010_37092[(1)] = (9));

} else {
var statearr_37011_37093 = state_36915__$1;
(statearr_37011_37093[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36916 === (49))){
var inst_36880 = (state_36915[(21)]);
var state_36915__$1 = state_36915;
var statearr_37012_37094 = state_36915__$1;
(statearr_37012_37094[(2)] = inst_36880);

(statearr_37012_37094[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__14778__auto__ = null;
var fluree$db$query$fql$state_machine__14778__auto____0 = (function (){
var statearr_37013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37013[(0)] = fluree$db$query$fql$state_machine__14778__auto__);

(statearr_37013[(1)] = (1));

return statearr_37013;
});
var fluree$db$query$fql$state_machine__14778__auto____1 = (function (state_36915){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_36915);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e37014){var ex__14781__auto__ = e37014;
var statearr_37015_37095 = state_36915;
(statearr_37015_37095[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_36915[(4)]))){
var statearr_37016_37096 = state_36915;
(statearr_37016_37096[(1)] = cljs.core.first((state_36915[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__37097 = state_36915;
state_36915 = G__37097;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__14778__auto__ = function(state_36915){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__14778__auto____1.call(this,state_36915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__14778__auto____0;
fluree$db$query$fql$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__14778__auto____1;
return fluree$db$query$fql$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_37017 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_37017[(6)] = c__14852__auto__);

return statearr_37017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__37100,groupBy){
var map__37101 = p__37100;
var map__37101__$1 = cljs.core.__destructure_map(map__37101);
var res = map__37101__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37101__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37101__$1,cljs.core.cst$kw$tuples);
var vec__37102 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37102,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37102,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37098_SHARP_){
return fluree.db.util.core.index_of(headers,p1__37098_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__37099_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__37099_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__37105 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37105,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37105,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__37108,p__37109,opts){
var map__37110 = p__37108;
var map__37110__$1 = cljs.core.__destructure_map(map__37110);
var res = map__37110__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37110__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37110__$1,cljs.core.cst$kw$vars);
var map__37111 = p__37109;
var map__37111__$1 = cljs.core.__destructure_map(map__37111);
var select_spec = map__37111__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37111__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37111__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37111__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37111__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37111__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37111__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37111__$1,cljs.core.cst$kw$offset);
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_37329){
var state_val_37330 = (state_37329[(1)]);
if((state_val_37330 === (65))){
var inst_37242 = (state_37329[(7)]);
var inst_37270 = cljs.core.empty_QMARK_(inst_37242);
var state_37329__$1 = state_37329;
var statearr_37331_37464 = state_37329__$1;
(statearr_37331_37464[(2)] = inst_37270);

(statearr_37331_37464[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (70))){
var state_37329__$1 = state_37329;
var statearr_37332_37465 = state_37329__$1;
(statearr_37332_37465[(2)] = (1));

(statearr_37332_37465[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (62))){
var state_37329__$1 = state_37329;
var statearr_37333_37466 = state_37329__$1;
(statearr_37333_37466[(2)] = null);

(statearr_37333_37466[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (74))){
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_37334_37467 = state_37329__$1;
(statearr_37334_37467[(1)] = (77));

} else {
var statearr_37335_37468 = state_37329__$1;
(statearr_37335_37468[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (7))){
var state_37329__$1 = state_37329;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37336_37469 = state_37329__$1;
(statearr_37336_37469[(1)] = (70));

} else {
var statearr_37337_37470 = state_37329__$1;
(statearr_37337_37470[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (59))){
var state_37329__$1 = state_37329;
var statearr_37338_37471 = state_37329__$1;
(statearr_37338_37471[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (20))){
var state_37329__$1 = state_37329;
var statearr_37340_37472 = state_37329__$1;
(statearr_37340_37472[(2)] = (0));

(statearr_37340_37472[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (72))){
var inst_37296 = (state_37329[(2)]);
var inst_37297 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_37296,opts);
var state_37329__$1 = state_37329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37329__$1,(73),inst_37297);
} else {
if((state_val_37330 === (58))){
var inst_37180 = (state_37329[(8)]);
var inst_37254 = (inst_37180 - (1));
var state_37329__$1 = state_37329;
var statearr_37341_37473 = state_37329__$1;
(statearr_37341_37473[(2)] = inst_37254);

(statearr_37341_37473[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (60))){
var inst_37264 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37342_37474 = state_37329__$1;
(statearr_37342_37474[(2)] = inst_37264);

(statearr_37342_37474[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (27))){
var inst_37179 = (state_37329[(9)]);
var inst_37203 = (inst_37179 < (1));
var state_37329__$1 = state_37329;
var statearr_37343_37475 = state_37329__$1;
(statearr_37343_37475[(2)] = inst_37203);

(statearr_37343_37475[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (1))){
var state_37329__$1 = state_37329;
var statearr_37344_37476 = state_37329__$1;
(statearr_37344_37476[(2)] = null);

(statearr_37344_37476[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (69))){
var inst_37266 = (state_37329[(10)]);
var inst_37194 = (state_37329[(11)]);
var inst_37249 = (state_37329[(12)]);
var inst_37191 = (state_37329[(13)]);
var inst_37277 = (state_37329[(2)]);
var inst_37177 = inst_37191;
var inst_37178 = inst_37194;
var inst_37179 = inst_37249;
var inst_37180 = inst_37266;
var inst_37181 = inst_37277;
var state_37329__$1 = (function (){var statearr_37345 = state_37329;
(statearr_37345[(8)] = inst_37180);

(statearr_37345[(14)] = inst_37177);

(statearr_37345[(9)] = inst_37179);

(statearr_37345[(15)] = inst_37178);

(statearr_37345[(16)] = inst_37181);

return statearr_37345;
})();
var statearr_37346_37477 = state_37329__$1;
(statearr_37346_37477[(2)] = null);

(statearr_37346_37477[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (24))){
var inst_37181 = (state_37329[(16)]);
var state_37329__$1 = state_37329;
var statearr_37347_37478 = state_37329__$1;
(statearr_37347_37478[(2)] = inst_37181);

(statearr_37347_37478[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (55))){
var state_37329__$1 = state_37329;
var statearr_37348_37479 = state_37329__$1;
(statearr_37348_37479[(2)] = (0));

(statearr_37348_37479[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (85))){
var inst_37318 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37349_37480 = state_37329__$1;
(statearr_37349_37480[(2)] = inst_37318);

(statearr_37349_37480[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (39))){
var inst_37198 = (state_37329[(17)]);
var inst_37221 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_37222 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_37223 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_37198,inst_37221,inst_37222);
var state_37329__$1 = state_37329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37329__$1,(42),inst_37223);
} else {
if((state_val_37330 === (46))){
var inst_37179 = (state_37329[(9)]);
var inst_37234 = ((0) < inst_37179);
var state_37329__$1 = state_37329;
var statearr_37350_37481 = state_37329__$1;
(statearr_37350_37481[(2)] = inst_37234);

(statearr_37350_37481[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (4))){
var inst_37112 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37351_37482 = state_37329__$1;
(statearr_37351_37482[(2)] = inst_37112);

(statearr_37351_37482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (77))){
var inst_37300 = (state_37329[(18)]);
var inst_37305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37306 = [inst_37300];
var inst_37307 = (new cljs.core.PersistentVector(null,1,(5),inst_37305,inst_37306,null));
var state_37329__$1 = state_37329;
var statearr_37352_37483 = state_37329__$1;
(statearr_37352_37483[(2)] = inst_37307);

(statearr_37352_37483[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (54))){
var inst_37180 = (state_37329[(8)]);
var inst_37249 = (state_37329[(2)]);
var inst_37250 = (inst_37180 <= (0));
var state_37329__$1 = (function (){var statearr_37353 = state_37329;
(statearr_37353[(12)] = inst_37249);

return statearr_37353;
})();
if(cljs.core.truth_(inst_37250)){
var statearr_37354_37484 = state_37329__$1;
(statearr_37354_37484[(1)] = (55));

} else {
var statearr_37355_37485 = state_37329__$1;
(statearr_37355_37485[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (15))){
var inst_37130 = (state_37329[(19)]);
var inst_37138 = (state_37329[(2)]);
var inst_37139 = fluree.db.util.async.throw_err(inst_37138);
var inst_37140 = [inst_37130];
var inst_37141 = [inst_37139];
var inst_37142 = cljs.core.PersistentHashMap.fromArrays(inst_37140,inst_37141);
var state_37329__$1 = state_37329;
var statearr_37356_37486 = state_37329__$1;
(statearr_37356_37486[(2)] = inst_37142);

(statearr_37356_37486[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (48))){
var inst_37237 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inst_37237)){
var statearr_37357_37487 = state_37329__$1;
(statearr_37357_37487[(1)] = (49));

} else {
var statearr_37358_37488 = state_37329__$1;
(statearr_37358_37488[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (50))){
var inst_37232 = (state_37329[(20)]);
var state_37329__$1 = state_37329;
var statearr_37359_37489 = state_37329__$1;
(statearr_37359_37489[(2)] = inst_37232);

(statearr_37359_37489[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (75))){
var state_37329__$1 = state_37329;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37360_37490 = state_37329__$1;
(statearr_37360_37490[(1)] = (80));

} else {
var statearr_37361_37491 = state_37329__$1;
(statearr_37361_37491[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (21))){
var inst_37170 = (state_37329[(21)]);
var inst_37158 = (state_37329[(22)]);
var inst_37162 = (state_37329[(23)]);
var inst_37175 = (state_37329[(2)]);
var inst_37176 = cljs.core.PersistentHashMap.EMPTY;
var inst_37177 = inst_37158;
var inst_37178 = inst_37162;
var inst_37179 = inst_37170;
var inst_37180 = inst_37175;
var inst_37181 = inst_37176;
var state_37329__$1 = (function (){var statearr_37362 = state_37329;
(statearr_37362[(8)] = inst_37180);

(statearr_37362[(14)] = inst_37177);

(statearr_37362[(9)] = inst_37179);

(statearr_37362[(15)] = inst_37178);

(statearr_37362[(16)] = inst_37181);

return statearr_37362;
})();
var statearr_37363_37492 = state_37329__$1;
(statearr_37363_37492[(2)] = null);

(statearr_37363_37492[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (31))){
var inst_37180 = (state_37329[(8)]);
var inst_37195 = (state_37329[(24)]);
var inst_37209 = (inst_37180 >= inst_37195);
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inst_37209)){
var statearr_37364_37493 = state_37329__$1;
(statearr_37364_37493[(1)] = (33));

} else {
var statearr_37365_37494 = state_37329__$1;
(statearr_37365_37494[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (32))){
var inst_37285 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37366_37495 = state_37329__$1;
(statearr_37366_37495[(2)] = inst_37285);

(statearr_37366_37495[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (40))){
var state_37329__$1 = state_37329;
var statearr_37367_37496 = state_37329__$1;
(statearr_37367_37496[(2)] = null);

(statearr_37367_37496[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (56))){
var state_37329__$1 = state_37329;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37368_37497 = state_37329__$1;
(statearr_37368_37497[(1)] = (58));

} else {
var statearr_37369_37498 = state_37329__$1;
(statearr_37369_37498[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (33))){
var state_37329__$1 = state_37329;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37370_37499 = state_37329__$1;
(statearr_37370_37499[(1)] = (36));

} else {
var statearr_37371_37500 = state_37329__$1;
(statearr_37371_37500[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (13))){
var inst_37158 = (state_37329[(22)]);
var inst_37162 = (state_37329[(23)]);
var inst_37127 = (state_37329[(25)]);
var inst_37158__$1 = cljs.core.keys(inst_37127);
var inst_37159 = cljs.core.seq(inst_37158__$1);
var inst_37160 = cljs.core.first(inst_37159);
var inst_37161 = cljs.core.next(inst_37159);
var inst_37162__$1 = cljs.core.vals(inst_37127);
var inst_37163 = cljs.core.seq(inst_37162__$1);
var inst_37164 = cljs.core.first(inst_37163);
var inst_37165 = cljs.core.next(inst_37163);
var inst_37166 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_37329__$1 = (function (){var statearr_37372 = state_37329;
(statearr_37372[(26)] = inst_37165);

(statearr_37372[(27)] = inst_37160);

(statearr_37372[(22)] = inst_37158__$1);

(statearr_37372[(23)] = inst_37162__$1);

(statearr_37372[(28)] = inst_37161);

(statearr_37372[(29)] = inst_37164);

return statearr_37372;
})();
if(inst_37166){
var statearr_37373_37501 = state_37329__$1;
(statearr_37373_37501[(1)] = (16));

} else {
var statearr_37374_37502 = state_37329__$1;
(statearr_37374_37502[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (22))){
var inst_37177 = (state_37329[(14)]);
var inst_37178 = (state_37329[(15)]);
var inst_37189 = cljs.core.seq(inst_37177);
var inst_37190 = cljs.core.first(inst_37189);
var inst_37191 = cljs.core.next(inst_37189);
var inst_37192 = cljs.core.seq(inst_37178);
var inst_37193 = cljs.core.first(inst_37192);
var inst_37194 = cljs.core.next(inst_37192);
var inst_37195 = cljs.core.count(inst_37193);
var inst_37196 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_37197 = [headers,vars,inst_37193];
var inst_37198 = cljs.core.PersistentHashMap.fromArrays(inst_37196,inst_37197);
var inst_37199 = (inst_37193 == null);
var state_37329__$1 = (function (){var statearr_37375 = state_37329;
(statearr_37375[(24)] = inst_37195);

(statearr_37375[(30)] = inst_37190);

(statearr_37375[(17)] = inst_37198);

(statearr_37375[(11)] = inst_37194);

(statearr_37375[(13)] = inst_37191);

return statearr_37375;
})();
if(cljs.core.truth_(inst_37199)){
var statearr_37376_37503 = state_37329__$1;
(statearr_37376_37503[(1)] = (24));

} else {
var statearr_37377_37504 = state_37329__$1;
(statearr_37377_37504[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (36))){
var inst_37180 = (state_37329[(8)]);
var inst_37212 = (inst_37180 - (1));
var state_37329__$1 = state_37329;
var statearr_37378_37505 = state_37329__$1;
(statearr_37378_37505[(2)] = inst_37212);

(statearr_37378_37505[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (41))){
var inst_37281 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37379_37506 = state_37329__$1;
(statearr_37379_37506[(2)] = inst_37281);

(statearr_37379_37506[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (43))){
var inst_37180 = (state_37329[(8)]);
var inst_37226 = (state_37329[(31)]);
var inst_37229 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_37180,inst_37226);
var state_37329__$1 = state_37329;
var statearr_37380_37507 = state_37329__$1;
(statearr_37380_37507[(2)] = inst_37229);

(statearr_37380_37507[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (61))){
var inst_37180 = (state_37329[(8)]);
var inst_37195 = (state_37329[(24)]);
var inst_37242 = (state_37329[(7)]);
var inst_37257 = cljs.core.count(inst_37242);
var inst_37258 = (inst_37195 - inst_37257);
var inst_37259 = (inst_37180 - inst_37258);
var state_37329__$1 = state_37329;
var statearr_37381_37508 = state_37329__$1;
(statearr_37381_37508[(2)] = inst_37259);

(statearr_37381_37508[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (29))){
var inst_37206 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inst_37206)){
var statearr_37382_37509 = state_37329__$1;
(statearr_37382_37509[(1)] = (30));

} else {
var statearr_37383_37510 = state_37329__$1;
(statearr_37383_37510[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (44))){
var inst_37226 = (state_37329[(31)]);
var state_37329__$1 = state_37329;
var statearr_37384_37511 = state_37329__$1;
(statearr_37384_37511[(2)] = inst_37226);

(statearr_37384_37511[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (6))){
var inst_37119 = (state_37329[(32)]);
var inst_37119__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_37121 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_37329__$1 = (function (){var statearr_37385 = state_37329;
(statearr_37385[(33)] = inst_37121);

(statearr_37385[(32)] = inst_37119__$1);

return statearr_37385;
})();
if(cljs.core.truth_(inst_37119__$1)){
var statearr_37386_37512 = state_37329__$1;
(statearr_37386_37512[(1)] = (9));

} else {
var statearr_37387_37513 = state_37329__$1;
(statearr_37387_37513[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (28))){
var inst_37179 = (state_37329[(9)]);
var state_37329__$1 = state_37329;
var statearr_37388_37514 = state_37329__$1;
(statearr_37388_37514[(2)] = inst_37179);

(statearr_37388_37514[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (64))){
var inst_37267 = (state_37329[(34)]);
var state_37329__$1 = state_37329;
var statearr_37389_37515 = state_37329__$1;
(statearr_37389_37515[(2)] = inst_37267);

(statearr_37389_37515[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (51))){
var inst_37179 = (state_37329[(9)]);
var inst_37242 = (state_37329[(2)]);
var inst_37243 = (inst_37179 == null);
var state_37329__$1 = (function (){var statearr_37390 = state_37329;
(statearr_37390[(7)] = inst_37242);

return statearr_37390;
})();
if(cljs.core.truth_(inst_37243)){
var statearr_37391_37516 = state_37329__$1;
(statearr_37391_37516[(1)] = (52));

} else {
var statearr_37392_37517 = state_37329__$1;
(statearr_37392_37517[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (25))){
var inst_37179 = (state_37329[(9)]);
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inst_37179)){
var statearr_37393_37518 = state_37329__$1;
(statearr_37393_37518[(1)] = (27));

} else {
var statearr_37394_37519 = state_37329__$1;
(statearr_37394_37519[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (34))){
var state_37329__$1 = state_37329;
var statearr_37395_37520 = state_37329__$1;
(statearr_37395_37520[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (17))){
var state_37329__$1 = state_37329;
var statearr_37397_37521 = state_37329__$1;
(statearr_37397_37521[(2)] = limit);

(statearr_37397_37521[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (3))){
var inst_37327 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37329__$1,inst_37327);
} else {
if((state_val_37330 === (12))){
var inst_37127 = (state_37329[(25)]);
var inst_37129 = cljs.core.keys(inst_37127);
var inst_37130 = cljs.core.first(inst_37129);
var inst_37131 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_37132 = cljs.core.vals(inst_37127);
var inst_37133 = cljs.core.first(inst_37132);
var inst_37134 = [headers,vars,inst_37133];
var inst_37135 = cljs.core.PersistentHashMap.fromArrays(inst_37131,inst_37134);
var inst_37136 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_37135,select_spec,limit,opts);
var state_37329__$1 = (function (){var statearr_37398 = state_37329;
(statearr_37398[(19)] = inst_37130);

return statearr_37398;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37329__$1,(15),inst_37136);
} else {
if((state_val_37330 === (2))){
var _ = (function (){var statearr_37399 = state_37329;
(statearr_37399[(4)] = cljs.core.cons((5),(state_37329[(4)])));

return statearr_37399;
})();
var state_37329__$1 = state_37329;
if(cljs.core.truth_(groupBy)){
var statearr_37400_37522 = state_37329__$1;
(statearr_37400_37522[(1)] = (6));

} else {
var statearr_37401_37523 = state_37329__$1;
(statearr_37401_37523[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (66))){
var inst_37272 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
if(cljs.core.truth_(inst_37272)){
var statearr_37402_37524 = state_37329__$1;
(statearr_37402_37524[(1)] = (67));

} else {
var statearr_37403_37525 = state_37329__$1;
(statearr_37403_37525[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (23))){
var inst_37289 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37404_37526 = state_37329__$1;
(statearr_37404_37526[(2)] = inst_37289);

(statearr_37404_37526[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (47))){
var inst_37179 = (state_37329[(9)]);
var state_37329__$1 = state_37329;
var statearr_37405_37527 = state_37329__$1;
(statearr_37405_37527[(2)] = inst_37179);

(statearr_37405_37527[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (35))){
var inst_37283 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37406_37528 = state_37329__$1;
(statearr_37406_37528[(2)] = inst_37283);

(statearr_37406_37528[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (82))){
var inst_37320 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37407_37529 = state_37329__$1;
(statearr_37407_37529[(2)] = inst_37320);

(statearr_37407_37529[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (76))){
var inst_37322 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37408_37530 = state_37329__$1;
(statearr_37408_37530[(2)] = inst_37322);

(statearr_37408_37530[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (19))){
var inst_37171 = (state_37329[(35)]);
var state_37329__$1 = state_37329;
var statearr_37409_37531 = state_37329__$1;
(statearr_37409_37531[(2)] = inst_37171);

(statearr_37409_37531[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (57))){
var inst_37242 = (state_37329[(7)]);
var inst_37267 = (state_37329[(34)]);
var inst_37266 = (state_37329[(2)]);
var inst_37267__$1 = (inst_37242 == null);
var state_37329__$1 = (function (){var statearr_37410 = state_37329;
(statearr_37410[(10)] = inst_37266);

(statearr_37410[(34)] = inst_37267__$1);

return statearr_37410;
})();
if(cljs.core.truth_(inst_37267__$1)){
var statearr_37411_37532 = state_37329__$1;
(statearr_37411_37532[(1)] = (64));

} else {
var statearr_37412_37533 = state_37329__$1;
(statearr_37412_37533[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (68))){
var inst_37190 = (state_37329[(30)]);
var inst_37242 = (state_37329[(7)]);
var inst_37181 = (state_37329[(16)]);
var inst_37275 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37181,inst_37190,inst_37242);
var state_37329__$1 = state_37329;
var statearr_37413_37534 = state_37329__$1;
(statearr_37413_37534[(2)] = inst_37275);

(statearr_37413_37534[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (11))){
var inst_37127 = (state_37329[(2)]);
var state_37329__$1 = (function (){var statearr_37415 = state_37329;
(statearr_37415[(25)] = inst_37127);

return statearr_37415;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37416_37535 = state_37329__$1;
(statearr_37416_37535[(1)] = (12));

} else {
var statearr_37417_37536 = state_37329__$1;
(statearr_37417_37536[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (9))){
var inst_37121 = (state_37329[(33)]);
var inst_37119 = (state_37329[(32)]);
var inst_37123 = cljs.core.sorted_map_by(inst_37119);
var inst_37124 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37123,inst_37121);
var state_37329__$1 = state_37329;
var statearr_37418_37537 = state_37329__$1;
(statearr_37418_37537[(2)] = inst_37124);

(statearr_37418_37537[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (5))){
var _ = (function (){var statearr_37419 = state_37329;
(statearr_37419[(4)] = cljs.core.rest((state_37329[(4)])));

return statearr_37419;
})();
var state_37329__$1 = state_37329;
var ex37414 = (state_37329__$1[(2)]);
var statearr_37420_37538 = state_37329__$1;
(statearr_37420_37538[(5)] = ex37414);


if((ex37414 instanceof Error)){
var statearr_37421_37539 = state_37329__$1;
(statearr_37421_37539[(1)] = (4));

(statearr_37421_37539[(5)] = null);

} else {
throw ex37414;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (83))){
var inst_37300 = (state_37329[(18)]);
var state_37329__$1 = state_37329;
var statearr_37422_37540 = state_37329__$1;
(statearr_37422_37540[(2)] = inst_37300);

(statearr_37422_37540[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (14))){
var inst_37291 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37423_37541 = state_37329__$1;
(statearr_37423_37541[(2)] = inst_37291);

(statearr_37423_37541[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (45))){
var inst_37179 = (state_37329[(9)]);
var inst_37232 = (state_37329[(2)]);
var state_37329__$1 = (function (){var statearr_37424 = state_37329;
(statearr_37424[(20)] = inst_37232);

return statearr_37424;
})();
if(cljs.core.truth_(inst_37179)){
var statearr_37425_37542 = state_37329__$1;
(statearr_37425_37542[(1)] = (46));

} else {
var statearr_37426_37543 = state_37329__$1;
(statearr_37426_37543[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (53))){
var inst_37179 = (state_37329[(9)]);
var inst_37242 = (state_37329[(7)]);
var inst_37246 = cljs.core.count(inst_37242);
var inst_37247 = (inst_37179 - inst_37246);
var state_37329__$1 = state_37329;
var statearr_37427_37544 = state_37329__$1;
(statearr_37427_37544[(2)] = inst_37247);

(statearr_37427_37544[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (78))){
var inst_37300 = (state_37329[(18)]);
var state_37329__$1 = state_37329;
var statearr_37428_37545 = state_37329__$1;
(statearr_37428_37545[(2)] = inst_37300);

(statearr_37428_37545[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (26))){
var inst_37287 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37429_37546 = state_37329__$1;
(statearr_37429_37546[(2)] = inst_37287);

(statearr_37429_37546[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (16))){
var state_37329__$1 = state_37329;
var statearr_37430_37547 = state_37329__$1;
(statearr_37430_37547[(2)] = null);

(statearr_37430_37547[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (81))){
var state_37329__$1 = state_37329;
var statearr_37433_37548 = state_37329__$1;
(statearr_37433_37548[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (79))){
var inst_37310 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37435_37549 = state_37329__$1;
(statearr_37435_37549[(2)] = inst_37310);

(statearr_37435_37549[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (38))){
var inst_37179 = (state_37329[(9)]);
var inst_37194 = (state_37329[(11)]);
var inst_37181 = (state_37329[(16)]);
var inst_37191 = (state_37329[(13)]);
var inst_37216 = (state_37329[(2)]);
var tmp37431 = inst_37179;
var tmp37432 = inst_37181;
var inst_37177 = inst_37191;
var inst_37178 = inst_37194;
var inst_37179__$1 = tmp37431;
var inst_37180 = inst_37216;
var inst_37181__$1 = tmp37432;
var state_37329__$1 = (function (){var statearr_37436 = state_37329;
(statearr_37436[(8)] = inst_37180);

(statearr_37436[(14)] = inst_37177);

(statearr_37436[(9)] = inst_37179__$1);

(statearr_37436[(15)] = inst_37178);

(statearr_37436[(16)] = inst_37181__$1);

return statearr_37436;
})();
var statearr_37437_37550 = state_37329__$1;
(statearr_37437_37550[(2)] = null);

(statearr_37437_37550[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (30))){
var inst_37181 = (state_37329[(16)]);
var state_37329__$1 = state_37329;
var statearr_37438_37551 = state_37329__$1;
(statearr_37438_37551[(2)] = inst_37181);

(statearr_37438_37551[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (73))){
var inst_37300 = (state_37329[(18)]);
var inst_37299 = (state_37329[(2)]);
var inst_37300__$1 = fluree.db.util.async.throw_err(inst_37299);
var inst_37301 = cljs.core.coll_QMARK_(inst_37300__$1);
var inst_37302 = (!(inst_37301));
var state_37329__$1 = (function (){var statearr_37439 = state_37329;
(statearr_37439[(18)] = inst_37300__$1);

return statearr_37439;
})();
if(inst_37302){
var statearr_37440_37552 = state_37329__$1;
(statearr_37440_37552[(1)] = (74));

} else {
var statearr_37441_37553 = state_37329__$1;
(statearr_37441_37553[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (10))){
var inst_37121 = (state_37329[(33)]);
var state_37329__$1 = state_37329;
var statearr_37442_37554 = state_37329__$1;
(statearr_37442_37554[(2)] = inst_37121);

(statearr_37442_37554[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (18))){
var inst_37171 = (state_37329[(35)]);
var inst_37170 = (state_37329[(2)]);
var inst_37171__$1 = offset;
var state_37329__$1 = (function (){var statearr_37443 = state_37329;
(statearr_37443[(21)] = inst_37170);

(statearr_37443[(35)] = inst_37171__$1);

return statearr_37443;
})();
if(cljs.core.truth_(inst_37171__$1)){
var statearr_37444_37555 = state_37329__$1;
(statearr_37444_37555[(1)] = (19));

} else {
var statearr_37445_37556 = state_37329__$1;
(statearr_37445_37556[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (52))){
var state_37329__$1 = state_37329;
var statearr_37446_37557 = state_37329__$1;
(statearr_37446_37557[(2)] = null);

(statearr_37446_37557[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (67))){
var inst_37181 = (state_37329[(16)]);
var state_37329__$1 = state_37329;
var statearr_37447_37558 = state_37329__$1;
(statearr_37447_37558[(2)] = inst_37181);

(statearr_37447_37558[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (71))){
var state_37329__$1 = state_37329;
var statearr_37448_37559 = state_37329__$1;
(statearr_37448_37559[(2)] = limit);

(statearr_37448_37559[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (42))){
var inst_37180 = (state_37329[(8)]);
var inst_37225 = (state_37329[(2)]);
var inst_37226 = fluree.db.util.async.throw_err(inst_37225);
var inst_37227 = ((0) < inst_37180);
var state_37329__$1 = (function (){var statearr_37449 = state_37329;
(statearr_37449[(31)] = inst_37226);

return statearr_37449;
})();
if(cljs.core.truth_(inst_37227)){
var statearr_37450_37560 = state_37329__$1;
(statearr_37450_37560[(1)] = (43));

} else {
var statearr_37451_37561 = state_37329__$1;
(statearr_37451_37561[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (80))){
var inst_37300 = (state_37329[(18)]);
var inst_37313 = cljs.core.first(inst_37300);
var state_37329__$1 = state_37329;
var statearr_37452_37562 = state_37329__$1;
(statearr_37452_37562[(2)] = inst_37313);

(statearr_37452_37562[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (37))){
var inst_37180 = (state_37329[(8)]);
var inst_37195 = (state_37329[(24)]);
var inst_37214 = (inst_37180 - inst_37195);
var state_37329__$1 = state_37329;
var statearr_37453_37563 = state_37329__$1;
(statearr_37453_37563[(2)] = inst_37214);

(statearr_37453_37563[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (63))){
var inst_37262 = (state_37329[(2)]);
var state_37329__$1 = state_37329;
var statearr_37454_37564 = state_37329__$1;
(statearr_37454_37564[(2)] = inst_37262);

(statearr_37454_37564[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (8))){
var inst_37324 = (state_37329[(2)]);
var _ = (function (){var statearr_37455 = state_37329;
(statearr_37455[(4)] = cljs.core.rest((state_37329[(4)])));

return statearr_37455;
})();
var state_37329__$1 = state_37329;
var statearr_37456_37565 = state_37329__$1;
(statearr_37456_37565[(2)] = inst_37324);

(statearr_37456_37565[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (49))){
var inst_37232 = (state_37329[(20)]);
var inst_37179 = (state_37329[(9)]);
var inst_37239 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_37179,inst_37232);
var state_37329__$1 = state_37329;
var statearr_37457_37566 = state_37329__$1;
(statearr_37457_37566[(2)] = inst_37239);

(statearr_37457_37566[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37330 === (84))){
var state_37329__$1 = state_37329;
var statearr_37458_37567 = state_37329__$1;
(statearr_37458_37567[(2)] = null);

(statearr_37458_37567[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto____0 = (function (){
var statearr_37459 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37459[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto__);

(statearr_37459[(1)] = (1));

return statearr_37459;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto____1 = (function (state_37329){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_37329);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e37460){var ex__14781__auto__ = e37460;
var statearr_37461_37568 = state_37329;
(statearr_37461_37568[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_37329[(4)]))){
var statearr_37462_37569 = state_37329;
(statearr_37462_37569[(1)] = cljs.core.first((state_37329[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__37570 = state_37329;
state_37329 = G__37570;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto__ = function(state_37329){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto____1.call(this,state_37329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_37463 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_37463[(6)] = c__14852__auto__);

return statearr_37463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__37573,opts){
var map__37574 = p__37573;
var map__37574__$1 = cljs.core.__destructure_map(map__37574);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37574__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37574__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37574__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37574__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__37571_SHARP_){
return cljs.core.contains_QMARK_(p1__37571_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__37572_SHARP_){
return cljs.core.contains_QMARK_(p1__37572_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4221__auto__){
var G__37576 = cljs.core.first(orderBy);
var fexpr__37575 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__37575.cljs$core$IFn$_invoke$arity$1 ? fexpr__37575.cljs$core$IFn$_invoke$arity$1(G__37576) : fexpr__37575.call(null,G__37576));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4223__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4223__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__37577,p__37578){
var map__37579 = p__37577;
var map__37579__$1 = cljs.core.__destructure_map(map__37579);
var query_map = map__37579__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37579__$1,cljs.core.cst$kw$construct);
var map__37580 = p__37578;
var map__37580__$1 = cljs.core.__destructure_map(map__37580);
var where_result = map__37580__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37580__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37580__$1,cljs.core.cst$kw$tuples);
var vec__37581 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37581,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37581,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37581,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_37614){
var state_val_37615 = (state_37614[(1)]);
if((state_val_37615 === (7))){
var inst_37593 = (state_37614[(7)]);
var state_37614__$1 = state_37614;
var statearr_37616_37639 = state_37614__$1;
(statearr_37616_37639[(2)] = inst_37593);

(statearr_37616_37639[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (1))){
var state_37614__$1 = state_37614;
var statearr_37617_37640 = state_37614__$1;
(statearr_37617_37640[(2)] = null);

(statearr_37617_37640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (4))){
var inst_37584 = (state_37614[(2)]);
var state_37614__$1 = state_37614;
var statearr_37618_37641 = state_37614__$1;
(statearr_37618_37641[(2)] = inst_37584);

(statearr_37618_37641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (13))){
var inst_37603 = (state_37614[(2)]);
var inst_37604 = fluree.db.util.async.throw_err(inst_37603);
var state_37614__$1 = state_37614;
var statearr_37619_37642 = state_37614__$1;
(statearr_37619_37642[(2)] = inst_37604);

(statearr_37619_37642[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (6))){
var inst_37593 = (state_37614[(7)]);
var inst_37592 = (state_37614[(2)]);
var inst_37593__$1 = fluree.db.util.async.throw_err(inst_37592);
var inst_37594 = fluree.db.util.core.exception_QMARK_(inst_37593__$1);
var state_37614__$1 = (function (){var statearr_37620 = state_37614;
(statearr_37620[(7)] = inst_37593__$1);

return statearr_37620;
})();
if(inst_37594){
var statearr_37621_37643 = state_37614__$1;
(statearr_37621_37643[(1)] = (7));

} else {
var statearr_37622_37644 = state_37614__$1;
(statearr_37622_37644[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (3))){
var inst_37612 = (state_37614[(2)]);
var state_37614__$1 = state_37614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37614__$1,inst_37612);
} else {
if((state_val_37615 === (12))){
var inst_37607 = (state_37614[(2)]);
var state_37614__$1 = state_37614;
var statearr_37623_37645 = state_37614__$1;
(statearr_37623_37645[(2)] = inst_37607);

(statearr_37623_37645[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (2))){
var _ = (function (){var statearr_37624 = state_37614;
(statearr_37624[(4)] = cljs.core.cons((5),(state_37614[(4)])));

return statearr_37624;
})();
var inst_37590 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_37614__$1 = state_37614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37614__$1,(6),inst_37590);
} else {
if((state_val_37615 === (11))){
var state_37614__$1 = state_37614;
var statearr_37626_37646 = state_37614__$1;
(statearr_37626_37646[(2)] = null);

(statearr_37626_37646[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (9))){
var inst_37609 = (state_37614[(2)]);
var _ = (function (){var statearr_37627 = state_37614;
(statearr_37627[(4)] = cljs.core.rest((state_37614[(4)])));

return statearr_37627;
})();
var state_37614__$1 = state_37614;
var statearr_37628_37647 = state_37614__$1;
(statearr_37628_37647[(2)] = inst_37609);

(statearr_37628_37647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (5))){
var _ = (function (){var statearr_37629 = state_37614;
(statearr_37629[(4)] = cljs.core.rest((state_37614[(4)])));

return statearr_37629;
})();
var state_37614__$1 = state_37614;
var ex37625 = (state_37614__$1[(2)]);
var statearr_37630_37648 = state_37614__$1;
(statearr_37630_37648[(5)] = ex37625);


if((ex37625 instanceof Error)){
var statearr_37631_37649 = state_37614__$1;
(statearr_37631_37649[(1)] = (4));

(statearr_37631_37649[(5)] = null);

} else {
throw ex37625;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37615 === (10))){
var inst_37593 = (state_37614[(7)]);
var inst_37598 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_37593);
var inst_37599 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_37593);
var inst_37600 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_37598,inst_37599,query_map,opts);
var inst_37601 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_37593,inst_37600,opts);
var state_37614__$1 = state_37614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37614__$1,(13),inst_37601);
} else {
if((state_val_37615 === (8))){
var state_37614__$1 = state_37614;
var statearr_37632_37650 = state_37614__$1;
(statearr_37632_37650[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto____0 = (function (){
var statearr_37634 = [null,null,null,null,null,null,null,null];
(statearr_37634[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto__);

(statearr_37634[(1)] = (1));

return statearr_37634;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto____1 = (function (state_37614){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_37614);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e37635){var ex__14781__auto__ = e37635;
var statearr_37636_37651 = state_37614;
(statearr_37636_37651[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_37614[(4)]))){
var statearr_37637_37652 = state_37614;
(statearr_37637_37652[(1)] = cljs.core.first((state_37614[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__37653 = state_37614;
state_37614 = G__37653;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto__ = function(state_37614){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto____1.call(this,state_37614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_37638 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_37638[(6)] = c__14852__auto__);

return statearr_37638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__37654 = query_map;
var map__37654__$1 = cljs.core.__destructure_map(map__37654);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37654__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__37655 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__37655,cljs.core.cst$kw$limit,(1));
} else {
return G__37655;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_38014){
var state_val_38015 = (state_38014[(1)]);
if((state_val_38015 === (121))){
var inst_37975 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38016_38211 = state_38014__$1;
(statearr_38016_38211[(2)] = inst_37975);

(statearr_38016_38211[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (65))){
var inst_37848 = typeof from === 'string';
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37848)){
var statearr_38017_38212 = state_38014__$1;
(statearr_38017_38212[(1)] = (72));

} else {
var statearr_38018_38213 = state_38014__$1;
(statearr_38018_38213[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (70))){
var inst_37717 = (state_38014[(7)]);
var inst_37719 = (state_38014[(8)]);
var inst_37841 = (state_38014[(2)]);
var inst_37842 = fluree.db.util.async.throw_err(inst_37841);
var inst_37843 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_37719,fuel,max_fuel,inst_37717,inst_37842);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(71),inst_37843);
} else {
if((state_val_38015 === (62))){
var inst_37821 = (state_38014[(9)]);
var state_38014__$1 = state_38014;
var statearr_38019_38214 = state_38014__$1;
(statearr_38019_38214[(2)] = inst_37821);

(statearr_38019_38214[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (74))){
var inst_37981 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38020_38215 = state_38014__$1;
(statearr_38020_38215[(2)] = inst_37981);

(statearr_38020_38215[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (110))){
var inst_37914 = (state_38014[(10)]);
var state_38014__$1 = state_38014;
var statearr_38021_38216 = state_38014__$1;
(statearr_38021_38216[(2)] = inst_37914);

(statearr_38021_38216[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (130))){
var inst_38001 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38022_38217 = state_38014__$1;
(statearr_38022_38217[(2)] = inst_38001);

(statearr_38022_38217[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (128))){
var inst_37992 = (state_38014[(11)]);
var inst_37997 = fluree.db.util.core.exception_QMARK_(inst_37992);
var inst_37998 = (!(inst_37997));
var state_38014__$1 = state_38014;
var statearr_38023_38218 = state_38014__$1;
(statearr_38023_38218[(2)] = inst_37998);

(statearr_38023_38218[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (7))){
var inst_37687 = (state_38014[(12)]);
var inst_37687__$1 = selectOne;
var state_38014__$1 = (function (){var statearr_38024 = state_38014;
(statearr_38024[(12)] = inst_37687__$1);

return statearr_38024;
})();
if(cljs.core.truth_(inst_37687__$1)){
var statearr_38025_38219 = state_38014__$1;
(statearr_38025_38219[(1)] = (9));

} else {
var statearr_38026_38220 = state_38014__$1;
(statearr_38026_38220[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (59))){
var inst_37717 = (state_38014[(7)]);
var inst_37707 = (state_38014[(13)]);
var inst_37799 = (state_38014[(14)]);
var inst_37719 = (state_38014[(8)]);
var inst_37813 = (state_38014[(2)]);
var inst_37814 = fluree.db.util.async.throw_err(inst_37813);
var inst_37815 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37799,inst_37814);
var inst_37816 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_37719,fuel,max_fuel,inst_37717,inst_37815,inst_37707);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(60),inst_37816);
} else {
if((state_val_38015 === (86))){
var inst_37717 = (state_38014[(7)]);
var inst_37707 = (state_38014[(13)]);
var inst_37719 = (state_38014[(8)]);
var inst_37709 = (state_38014[(15)]);
var inst_37881 = (state_38014[(2)]);
var inst_37882 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37719,fuel,max_fuel,inst_37717,inst_37881,inst_37707,inst_37709);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(87),inst_37882);
} else {
if((state_val_38015 === (20))){
var inst_37751 = (state_38014[(2)]);
var inst_37752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37751,(0),null);
var inst_37753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37751,(1),null);
var inst_37754 = typeof where === 'string';
var state_38014__$1 = (function (){var statearr_38027 = state_38014;
(statearr_38027[(16)] = inst_37752);

(statearr_38027[(17)] = inst_37753);

return statearr_38027;
})();
if(cljs.core.truth_(inst_37754)){
var statearr_38028_38221 = state_38014__$1;
(statearr_38028_38221[(1)] = (30));

} else {
var statearr_38029_38222 = state_38014__$1;
(statearr_38029_38222[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (72))){
var inst_37706 = (state_38014[(18)]);
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37706)){
var statearr_38030_38223 = state_38014__$1;
(statearr_38030_38223[(1)] = (75));

} else {
var statearr_38031_38224 = state_38014__$1;
(statearr_38031_38224[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (58))){
var inst_37807 = (state_38014[(2)]);
var inst_37808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37809 = [from];
var inst_37810 = (new cljs.core.PersistentVector(null,1,(5),inst_37808,inst_37809,null));
var inst_37811 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_37810,inst_37807);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(59),inst_37811);
} else {
if((state_val_38015 === (60))){
var inst_37818 = (state_38014[(2)]);
var inst_37819 = fluree.db.util.async.throw_err(inst_37818);
var state_38014__$1 = state_38014;
var statearr_38032_38225 = state_38014__$1;
(statearr_38032_38225[(2)] = inst_37819);

(statearr_38032_38225[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (27))){
var inst_37736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37737 = [null,null];
var inst_37738 = (new cljs.core.PersistentVector(null,2,(5),inst_37736,inst_37737,null));
var state_38014__$1 = state_38014;
var statearr_38033_38226 = state_38014__$1;
(statearr_38033_38226[(2)] = inst_37738);

(statearr_38033_38226[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (1))){
var state_38014__$1 = state_38014;
var statearr_38034_38227 = state_38014__$1;
(statearr_38034_38227[(2)] = null);

(statearr_38034_38227[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (69))){
var inst_37838 = (state_38014[(2)]);
var inst_37839 = fluree.db.query.range._block_or_tx_collection(db,inst_37838);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(70),inst_37839);
} else {
if((state_val_38015 === (101))){
var inst_37948 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38035_38228 = state_38014__$1;
(statearr_38035_38228[(2)] = inst_37948);

(statearr_38035_38228[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (24))){
var inst_37706 = (state_38014[(18)]);
var inst_37731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37732 = [inst_37706,"ASC"];
var inst_37733 = (new cljs.core.PersistentVector(null,2,(5),inst_37731,inst_37732,null));
var state_38014__$1 = state_38014;
var statearr_38036_38229 = state_38014__$1;
(statearr_38036_38229[(2)] = inst_37733);

(statearr_38036_38229[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (102))){
var inst_37920 = (state_38014[(19)]);
var state_38014__$1 = state_38014;
var statearr_38037_38230 = state_38014__$1;
(statearr_38037_38230[(2)] = inst_37920);

(statearr_38037_38230[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (55))){
var inst_37706 = (state_38014[(18)]);
var inst_37799 = (state_38014[(2)]);
var state_38014__$1 = (function (){var statearr_38038 = state_38014;
(statearr_38038[(14)] = inst_37799);

return statearr_38038;
})();
if(cljs.core.truth_(inst_37706)){
var statearr_38039_38231 = state_38014__$1;
(statearr_38039_38231[(1)] = (56));

} else {
var statearr_38040_38232 = state_38014__$1;
(statearr_38040_38232[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (85))){
var inst_37873 = (state_38014[(20)]);
var inst_37877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37878 = [inst_37873];
var inst_37879 = (new cljs.core.PersistentVector(null,1,(5),inst_37877,inst_37878,null));
var state_38014__$1 = state_38014;
var statearr_38041_38233 = state_38014__$1;
(statearr_38041_38233[(2)] = inst_37879);

(statearr_38041_38233[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (39))){
var inst_37707 = (state_38014[(13)]);
var state_38014__$1 = state_38014;
var statearr_38042_38234 = state_38014__$1;
(statearr_38042_38234[(2)] = inst_37707);

(statearr_38042_38234[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (88))){
var inst_37887 = cljs.core._deref(fuel);
var inst_37888 = (inst_37887 + (1));
var inst_37889 = cljs.core._vreset_BANG_(fuel,inst_37888);
var state_38014__$1 = state_38014;
var statearr_38043_38235 = state_38014__$1;
(statearr_38043_38235[(2)] = inst_37889);

(statearr_38043_38235[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (46))){
var inst_37784 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37784)){
var statearr_38044_38236 = state_38014__$1;
(statearr_38044_38236[(1)] = (47));

} else {
var statearr_38045_38237 = state_38014__$1;
(statearr_38045_38237[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (4))){
var inst_37674 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38046_38238 = state_38014__$1;
(statearr_38046_38238[(2)] = inst_37674);

(statearr_38046_38238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (77))){
var inst_37857 = (state_38014[(2)]);
var inst_37858 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_37857);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(78),inst_37858);
} else {
if((state_val_38015 === (106))){
var state_38014__$1 = state_38014;
var statearr_38047_38239 = state_38014__$1;
(statearr_38047_38239[(2)] = null);

(statearr_38047_38239[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (119))){
var inst_37967 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_37968 = ["Invalid 'from' in query:",inst_37967].join('');
var inst_37969 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37970 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37971 = cljs.core.PersistentHashMap.fromArrays(inst_37969,inst_37970);
var inst_37972 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37968,inst_37971);
var state_38014__$1 = state_38014;
var statearr_38048_38240 = state_38014__$1;
(statearr_38048_38240[(2)] = inst_37972);

(statearr_38048_38240[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (95))){
var state_38014__$1 = state_38014;
var statearr_38049_38241 = state_38014__$1;
(statearr_38049_38241[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (54))){
var inst_37793 = (state_38014[(21)]);
var state_38014__$1 = state_38014;
var statearr_38051_38242 = state_38014__$1;
(statearr_38051_38242[(2)] = inst_37793);

(statearr_38051_38242[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (92))){
var inst_37894 = (state_38014[(22)]);
var state_38014__$1 = state_38014;
var statearr_38052_38243 = state_38014__$1;
(statearr_38052_38243[(2)] = inst_37894);

(statearr_38052_38243[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (104))){
var inst_37940 = (state_38014[(23)]);
var inst_37940__$1 = (state_38014[(2)]);
var state_38014__$1 = (function (){var statearr_38053 = state_38014;
(statearr_38053[(23)] = inst_37940__$1);

return statearr_38053;
})();
if(cljs.core.truth_(inst_37940__$1)){
var statearr_38054_38244 = state_38014__$1;
(statearr_38054_38244[(1)] = (109));

} else {
var statearr_38055_38245 = state_38014__$1;
(statearr_38055_38245[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (15))){
var inst_37708 = (state_38014[(24)]);
var inst_37710 = (state_38014[(25)]);
var inst_37714 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37710,cljs.core.cst$kw$componentFollow_QMARK_,inst_37708);
var state_38014__$1 = state_38014;
var statearr_38056_38246 = state_38014__$1;
(statearr_38056_38246[(2)] = inst_37714);

(statearr_38056_38246[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (48))){
var inst_37821 = (state_38014[(9)]);
var inst_37821__$1 = typeof from === 'string';
var state_38014__$1 = (function (){var statearr_38057 = state_38014;
(statearr_38057[(9)] = inst_37821__$1);

return statearr_38057;
})();
if(cljs.core.truth_(inst_37821__$1)){
var statearr_38058_38247 = state_38014__$1;
(statearr_38058_38247[(1)] = (61));

} else {
var statearr_38059_38248 = state_38014__$1;
(statearr_38059_38248[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (50))){
var inst_37787 = (state_38014[(26)]);
var inst_37789 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_37790 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37787,inst_37789);
var state_38014__$1 = state_38014;
var statearr_38060_38249 = state_38014__$1;
(statearr_38060_38249[(2)] = inst_37790);

(statearr_38060_38249[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (116))){
var state_38014__$1 = state_38014;
var statearr_38061_38250 = state_38014__$1;
(statearr_38061_38250[(2)] = null);

(statearr_38061_38250[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (75))){
var inst_37851 = cljs.core.PersistentHashMap.EMPTY;
var state_38014__$1 = state_38014;
var statearr_38062_38251 = state_38014__$1;
(statearr_38062_38251[(2)] = inst_37851);

(statearr_38062_38251[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (99))){
var inst_37914 = (state_38014[(10)]);
var state_38014__$1 = state_38014;
var statearr_38063_38252 = state_38014__$1;
(statearr_38063_38252[(2)] = inst_37914);

(statearr_38063_38252[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (21))){
var inst_37706 = (state_38014[(18)]);
var inst_37723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37724 = cljs.core.second(inst_37706);
var inst_37725 = cljs.core.first(inst_37706);
var inst_37726 = [inst_37724,inst_37725];
var inst_37727 = (new cljs.core.PersistentVector(null,2,(5),inst_37723,inst_37726,null));
var state_38014__$1 = state_38014;
var statearr_38064_38253 = state_38014__$1;
(statearr_38064_38253[(2)] = inst_37727);

(statearr_38064_38253[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (31))){
var inst_37778 = (state_38014[(27)]);
var inst_37778__$1 = typeof from === 'string';
var state_38014__$1 = (function (){var statearr_38065 = state_38014;
(statearr_38065[(27)] = inst_37778__$1);

return statearr_38065;
})();
if(cljs.core.truth_(inst_37778__$1)){
var statearr_38066_38254 = state_38014__$1;
(statearr_38066_38254[(1)] = (44));

} else {
var statearr_38067_38255 = state_38014__$1;
(statearr_38067_38255[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (113))){
var state_38014__$1 = state_38014;
var statearr_38068_38256 = state_38014__$1;
(statearr_38068_38256[(2)] = null);

(statearr_38068_38256[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (32))){
var inst_37752 = (state_38014[(16)]);
var inst_37987 = (state_38014[(2)]);
var state_38014__$1 = (function (){var statearr_38069 = state_38014;
(statearr_38069[(28)] = inst_37987);

return statearr_38069;
})();
if(cljs.core.truth_(inst_37752)){
var statearr_38070_38257 = state_38014__$1;
(statearr_38070_38257[(1)] = (122));

} else {
var statearr_38071_38258 = state_38014__$1;
(statearr_38071_38258[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (40))){
var inst_37706 = (state_38014[(18)]);
var inst_37768 = (state_38014[(2)]);
var state_38014__$1 = (function (){var statearr_38072 = state_38014;
(statearr_38072[(29)] = inst_37768);

return statearr_38072;
})();
if(cljs.core.truth_(inst_37706)){
var statearr_38073_38259 = state_38014__$1;
(statearr_38073_38259[(1)] = (41));

} else {
var statearr_38074_38260 = state_38014__$1;
(statearr_38074_38260[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (129))){
var inst_37995 = (state_38014[(30)]);
var state_38014__$1 = state_38014;
var statearr_38075_38261 = state_38014__$1;
(statearr_38075_38261[(2)] = inst_37995);

(statearr_38075_38261[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (91))){
var inst_37896 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_38014__$1 = state_38014;
var statearr_38076_38262 = state_38014__$1;
(statearr_38076_38262[(2)] = inst_37896);

(statearr_38076_38262[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (117))){
var inst_37709 = (state_38014[(15)]);
var state_38014__$1 = state_38014;
var statearr_38077_38263 = state_38014__$1;
(statearr_38077_38263[(2)] = inst_37709);

(statearr_38077_38263[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (108))){
var inst_37937 = (state_38014[(2)]);
var inst_37938 = fluree.db.util.async.throw_err(inst_37937);
var state_38014__$1 = state_38014;
var statearr_38078_38264 = state_38014__$1;
(statearr_38078_38264[(2)] = inst_37938);

(statearr_38078_38264[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (56))){
var inst_37801 = cljs.core.PersistentHashMap.EMPTY;
var state_38014__$1 = state_38014;
var statearr_38079_38265 = state_38014__$1;
(statearr_38079_38265[(2)] = inst_37801);

(statearr_38079_38265[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (33))){
var state_38014__$1 = state_38014;
var statearr_38080_38266 = state_38014__$1;
(statearr_38080_38266[(2)] = from);

(statearr_38080_38266[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (13))){
var inst_37693 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37694 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37695 = cljs.core.PersistentHashMap.fromArrays(inst_37693,inst_37694);
var inst_37696 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_37695);
var inst_37697 = (function(){throw inst_37696})();
var state_38014__$1 = state_38014;
var statearr_38081_38267 = state_38014__$1;
(statearr_38081_38267[(2)] = inst_37697);

(statearr_38081_38267[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (22))){
var inst_37706 = (state_38014[(18)]);
var inst_37729 = typeof inst_37706 === 'string';
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37729)){
var statearr_38082_38268 = state_38014__$1;
(statearr_38082_38268[(1)] = (24));

} else {
var statearr_38083_38269 = state_38014__$1;
(statearr_38083_38269[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (90))){
var inst_37885 = (state_38014[(31)]);
var inst_37892 = (state_38014[(2)]);
var state_38014__$1 = (function (){var statearr_38084 = state_38014;
(statearr_38084[(32)] = inst_37892);

return statearr_38084;
})();
var statearr_38085_38270 = state_38014__$1;
(statearr_38085_38270[(2)] = inst_37885);

(statearr_38085_38270[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (109))){
var inst_37940 = (state_38014[(23)]);
var inst_37914 = (state_38014[(10)]);
var inst_37942 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37914,inst_37940);
var state_38014__$1 = state_38014;
var statearr_38086_38271 = state_38014__$1;
(statearr_38086_38271[(2)] = inst_37942);

(statearr_38086_38271[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (36))){
var inst_37706 = (state_38014[(18)]);
var inst_37763 = (state_38014[(2)]);
var inst_37764 = fluree.db.util.async.throw_err(inst_37763);
var state_38014__$1 = (function (){var statearr_38087 = state_38014;
(statearr_38087[(33)] = inst_37764);

return statearr_38087;
})();
if(cljs.core.truth_(inst_37706)){
var statearr_38088_38272 = state_38014__$1;
(statearr_38088_38272[(1)] = (38));

} else {
var statearr_38089_38273 = state_38014__$1;
(statearr_38089_38273[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (41))){
var state_38014__$1 = state_38014;
var statearr_38090_38274 = state_38014__$1;
(statearr_38090_38274[(2)] = null);

(statearr_38090_38274[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (118))){
var inst_37717 = (state_38014[(7)]);
var inst_37952 = (state_38014[(34)]);
var inst_37719 = (state_38014[(8)]);
var inst_37956 = (state_38014[(35)]);
var inst_37960 = (state_38014[(2)]);
var inst_37961 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37719,fuel,max_fuel,inst_37717,inst_37952,inst_37956,inst_37960);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(112),inst_37961);
} else {
if((state_val_38015 === (89))){
var state_38014__$1 = state_38014;
var statearr_38091_38275 = state_38014__$1;
(statearr_38091_38275[(2)] = null);

(statearr_38091_38275[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (100))){
var inst_37920 = (state_38014[(19)]);
var inst_37925 = cljs.core.int_QMARK_(inst_37920);
var state_38014__$1 = state_38014;
if(inst_37925){
var statearr_38092_38276 = state_38014__$1;
(statearr_38092_38276[(1)] = (102));

} else {
var statearr_38093_38277 = state_38014__$1;
(statearr_38093_38277[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (131))){
var inst_37992 = (state_38014[(11)]);
var inst_38006 = cljs.core.first(inst_37992);
var state_38014__$1 = state_38014;
var statearr_38094_38278 = state_38014__$1;
(statearr_38094_38278[(2)] = inst_38006);

(statearr_38094_38278[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (122))){
var inst_37752 = (state_38014[(16)]);
var inst_37987 = (state_38014[(28)]);
var inst_37753 = (state_38014[(17)]);
var inst_37707 = (state_38014[(13)]);
var inst_37709 = (state_38014[(15)]);
var inst_37989 = fluree.db.query.fql.sort_offset_and_limit_res(inst_37752,inst_37753,inst_37709,inst_37707,inst_37987);
var state_38014__$1 = state_38014;
var statearr_38095_38279 = state_38014__$1;
(statearr_38095_38279[(2)] = inst_37989);

(statearr_38095_38279[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (43))){
var inst_37764 = (state_38014[(33)]);
var inst_37717 = (state_38014[(7)]);
var inst_37768 = (state_38014[(29)]);
var inst_37719 = (state_38014[(8)]);
var inst_37772 = (state_38014[(2)]);
var inst_37773 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37719,fuel,max_fuel,inst_37717,inst_37764,inst_37768,inst_37772);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(37),inst_37773);
} else {
if((state_val_38015 === (61))){
var inst_37823 = ["_tx",null,"_block",null];
var inst_37824 = (new cljs.core.PersistentArrayMap(null,2,inst_37823,null));
var inst_37825 = (new cljs.core.PersistentHashSet(null,inst_37824,null));
var inst_37826 = (inst_37825.cljs$core$IFn$_invoke$arity$1 ? inst_37825.cljs$core$IFn$_invoke$arity$1(from) : inst_37825.call(null,from));
var state_38014__$1 = state_38014;
var statearr_38096_38280 = state_38014__$1;
(statearr_38096_38280[(2)] = inst_37826);

(statearr_38096_38280[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (29))){
var inst_37741 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38097_38281 = state_38014__$1;
(statearr_38097_38281[(2)] = inst_37741);

(statearr_38097_38281[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (44))){
var inst_37780 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_37781 = clojure.string.includes_QMARK_(inst_37780,"/");
var state_38014__$1 = state_38014;
var statearr_38098_38282 = state_38014__$1;
(statearr_38098_38282[(2)] = inst_37781);

(statearr_38098_38282[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (93))){
var inst_37899 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37899)){
var statearr_38099_38283 = state_38014__$1;
(statearr_38099_38283[(1)] = (94));

} else {
var statearr_38100_38284 = state_38014__$1;
(statearr_38100_38284[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (6))){
var inst_37684 = (state_38014[(36)]);
var state_38014__$1 = state_38014;
var statearr_38101_38285 = state_38014__$1;
(statearr_38101_38285[(2)] = inst_37684);

(statearr_38101_38285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (111))){
var inst_37921 = (state_38014[(37)]);
var inst_37945 = (state_38014[(2)]);
var inst_37913 = inst_37921;
var inst_37914 = inst_37945;
var state_38014__$1 = (function (){var statearr_38102 = state_38014;
(statearr_38102[(38)] = inst_37913);

(statearr_38102[(10)] = inst_37914);

return statearr_38102;
})();
var statearr_38103_38286 = state_38014__$1;
(statearr_38103_38286[(2)] = null);

(statearr_38103_38286[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (28))){
var state_38014__$1 = state_38014;
var statearr_38104_38287 = state_38014__$1;
(statearr_38104_38287[(2)] = null);

(statearr_38104_38287[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (64))){
var inst_37706 = (state_38014[(18)]);
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37706)){
var statearr_38105_38288 = state_38014__$1;
(statearr_38105_38288[(1)] = (67));

} else {
var statearr_38106_38289 = state_38014__$1;
(statearr_38106_38289[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (103))){
var state_38014__$1 = state_38014;
if(cljs.core.truth_(fuel)){
var statearr_38107_38290 = state_38014__$1;
(statearr_38107_38290[(1)] = (105));

} else {
var statearr_38108_38291 = state_38014__$1;
(statearr_38108_38291[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (51))){
var inst_37787 = (state_38014[(26)]);
var state_38014__$1 = state_38014;
var statearr_38109_38292 = state_38014__$1;
(statearr_38109_38292[(2)] = inst_37787);

(statearr_38109_38292[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (25))){
var state_38014__$1 = state_38014;
var statearr_38110_38293 = state_38014__$1;
(statearr_38110_38293[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (34))){
var state_38014__$1 = state_38014;
var statearr_38112_38294 = state_38014__$1;
(statearr_38112_38294[(2)] = null);

(statearr_38112_38294[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (125))){
var inst_37995 = (state_38014[(30)]);
var inst_37992 = (state_38014[(11)]);
var inst_37995__$1 = cljs.core.coll_QMARK_(inst_37992);
var state_38014__$1 = (function (){var statearr_38113 = state_38014;
(statearr_38113[(30)] = inst_37995__$1);

return statearr_38113;
})();
if(inst_37995__$1){
var statearr_38114_38295 = state_38014__$1;
(statearr_38114_38295[(1)] = (128));

} else {
var statearr_38115_38296 = state_38014__$1;
(statearr_38115_38296[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (17))){
var inst_37706 = (state_38014[(18)]);
var inst_37717 = (state_38014[(2)]);
var inst_37718 = cljs.core.PersistentHashMap.EMPTY;
var inst_37719 = cljs.core.volatile_BANG_(inst_37718);
var state_38014__$1 = (function (){var statearr_38116 = state_38014;
(statearr_38116[(7)] = inst_37717);

(statearr_38116[(8)] = inst_37719);

return statearr_38116;
})();
if(cljs.core.truth_(inst_37706)){
var statearr_38117_38297 = state_38014__$1;
(statearr_38117_38297[(1)] = (18));

} else {
var statearr_38118_38298 = state_38014__$1;
(statearr_38118_38298[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (3))){
var inst_38012 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38014__$1,inst_38012);
} else {
if((state_val_38015 === (12))){
var inst_37690 = (state_38014[(39)]);
var state_38014__$1 = state_38014;
var statearr_38119_38299 = state_38014__$1;
(statearr_38119_38299[(2)] = inst_37690);

(statearr_38119_38299[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (2))){
var inst_37684 = (state_38014[(36)]);
var _ = (function (){var statearr_38120 = state_38014;
(statearr_38120[(4)] = cljs.core.cons((5),(state_38014[(4)])));

return statearr_38120;
})();
var inst_37684__$1 = select;
var state_38014__$1 = (function (){var statearr_38121 = state_38014;
(statearr_38121[(36)] = inst_37684__$1);

return statearr_38121;
})();
if(cljs.core.truth_(inst_37684__$1)){
var statearr_38122_38300 = state_38014__$1;
(statearr_38122_38300[(1)] = (6));

} else {
var statearr_38123_38301 = state_38014__$1;
(statearr_38123_38301[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (66))){
var inst_37983 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38124_38302 = state_38014__$1;
(statearr_38124_38302[(2)] = inst_37983);

(statearr_38124_38302[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (107))){
var inst_37920 = (state_38014[(19)]);
var inst_37934 = (state_38014[(2)]);
var inst_37935 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_37920,false);
var state_38014__$1 = (function (){var statearr_38125 = state_38014;
(statearr_38125[(40)] = inst_37934);

return statearr_38125;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(108),inst_37935);
} else {
if((state_val_38015 === (23))){
var inst_37745 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38126_38303 = state_38014__$1;
(statearr_38126_38303[(2)] = inst_37745);

(statearr_38126_38303[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (47))){
var inst_37787 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_38014__$1 = (function (){var statearr_38127 = state_38014;
(statearr_38127[(26)] = inst_37787);

return statearr_38127;
})();
if(cljs.core.truth_(fuel)){
var statearr_38128_38304 = state_38014__$1;
(statearr_38128_38304[(1)] = (50));

} else {
var statearr_38129_38305 = state_38014__$1;
(statearr_38129_38305[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (35))){
var inst_37760 = (state_38014[(2)]);
var inst_37761 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_37760);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(36),inst_37761);
} else {
if((state_val_38015 === (127))){
var inst_38004 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_38004)){
var statearr_38130_38306 = state_38014__$1;
(statearr_38130_38306[(1)] = (131));

} else {
var statearr_38131_38307 = state_38014__$1;
(statearr_38131_38307[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (82))){
var inst_37979 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38132_38308 = state_38014__$1;
(statearr_38132_38308[(2)] = inst_37979);

(statearr_38132_38308[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (76))){
var inst_37707 = (state_38014[(13)]);
var inst_37709 = (state_38014[(15)]);
var inst_37853 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_37854 = [inst_37707,inst_37709];
var inst_37855 = cljs.core.PersistentHashMap.fromArrays(inst_37853,inst_37854);
var state_38014__$1 = state_38014;
var statearr_38133_38309 = state_38014__$1;
(statearr_38133_38309[(2)] = inst_37855);

(statearr_38133_38309[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (97))){
var inst_37920 = (state_38014[(19)]);
var inst_37913 = (state_38014[(38)]);
var inst_37919 = cljs.core.seq(inst_37913);
var inst_37920__$1 = cljs.core.first(inst_37919);
var inst_37921 = cljs.core.next(inst_37919);
var inst_37922 = cljs.core.not(inst_37920__$1);
var state_38014__$1 = (function (){var statearr_38134 = state_38014;
(statearr_38134[(19)] = inst_37920__$1);

(statearr_38134[(37)] = inst_37921);

return statearr_38134;
})();
if(inst_37922){
var statearr_38135_38310 = state_38014__$1;
(statearr_38135_38310[(1)] = (99));

} else {
var statearr_38136_38311 = state_38014__$1;
(statearr_38136_38311[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (19))){
var inst_37747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37748 = [null,null];
var inst_37749 = (new cljs.core.PersistentVector(null,2,(5),inst_37747,inst_37748,null));
var state_38014__$1 = state_38014;
var statearr_38137_38312 = state_38014__$1;
(statearr_38137_38312[(2)] = inst_37749);

(statearr_38137_38312[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (57))){
var inst_37707 = (state_38014[(13)]);
var inst_37709 = (state_38014[(15)]);
var inst_37803 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_37804 = [inst_37707,inst_37709];
var inst_37805 = cljs.core.PersistentHashMap.fromArrays(inst_37803,inst_37804);
var state_38014__$1 = state_38014;
var statearr_38138_38313 = state_38014__$1;
(statearr_38138_38313[(2)] = inst_37805);

(statearr_38138_38313[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (68))){
var inst_37707 = (state_38014[(13)]);
var inst_37709 = (state_38014[(15)]);
var inst_37834 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_37835 = [inst_37707,inst_37709];
var inst_37836 = cljs.core.PersistentHashMap.fromArrays(inst_37834,inst_37835);
var state_38014__$1 = state_38014;
var statearr_38139_38314 = state_38014__$1;
(statearr_38139_38314[(2)] = inst_37836);

(statearr_38139_38314[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (11))){
var inst_37701 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38140_38315 = state_38014__$1;
(statearr_38140_38315[(2)] = inst_37701);

(statearr_38140_38315[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (115))){
var inst_37706 = (state_38014[(18)]);
var inst_37956 = (state_38014[(2)]);
var state_38014__$1 = (function (){var statearr_38142 = state_38014;
(statearr_38142[(35)] = inst_37956);

return statearr_38142;
})();
if(cljs.core.truth_(inst_37706)){
var statearr_38143_38316 = state_38014__$1;
(statearr_38143_38316[(1)] = (116));

} else {
var statearr_38144_38317 = state_38014__$1;
(statearr_38144_38317[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (9))){
var inst_37687 = (state_38014[(12)]);
var state_38014__$1 = state_38014;
var statearr_38145_38318 = state_38014__$1;
(statearr_38145_38318[(2)] = inst_37687);

(statearr_38145_38318[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (5))){
var _ = (function (){var statearr_38146 = state_38014;
(statearr_38146[(4)] = cljs.core.rest((state_38014[(4)])));

return statearr_38146;
})();
var state_38014__$1 = state_38014;
var ex38141 = (state_38014__$1[(2)]);
var statearr_38147_38319 = state_38014__$1;
(statearr_38147_38319[(5)] = ex38141);


if((ex38141 instanceof Error)){
var statearr_38148_38320 = state_38014__$1;
(statearr_38148_38320[(1)] = (4));

(statearr_38148_38320[(5)] = null);

} else {
throw ex38141;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (112))){
var inst_37963 = (state_38014[(2)]);
var inst_37964 = fluree.db.util.async.throw_err(inst_37963);
var state_38014__$1 = state_38014;
var statearr_38149_38321 = state_38014__$1;
(statearr_38149_38321[(2)] = inst_37964);

(statearr_38149_38321[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (83))){
var inst_37873 = (state_38014[(20)]);
var inst_37872 = (state_38014[(2)]);
var inst_37873__$1 = fluree.db.util.async.throw_err(inst_37872);
var inst_37874 = (inst_37873__$1 == null);
var state_38014__$1 = (function (){var statearr_38150 = state_38014;
(statearr_38150[(20)] = inst_37873__$1);

return statearr_38150;
})();
if(cljs.core.truth_(inst_37874)){
var statearr_38151_38322 = state_38014__$1;
(statearr_38151_38322[(1)] = (84));

} else {
var statearr_38152_38323 = state_38014__$1;
(statearr_38152_38323[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (14))){
var inst_37699 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38153_38324 = state_38014__$1;
(statearr_38153_38324[(2)] = inst_37699);

(statearr_38153_38324[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (45))){
var inst_37778 = (state_38014[(27)]);
var state_38014__$1 = state_38014;
var statearr_38154_38325 = state_38014__$1;
(statearr_38154_38325[(2)] = inst_37778);

(statearr_38154_38325[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (53))){
var inst_37793 = (state_38014[(21)]);
var inst_37795 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_37796 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37793,inst_37795);
var state_38014__$1 = state_38014;
var statearr_38155_38326 = state_38014__$1;
(statearr_38155_38326[(2)] = inst_37796);

(statearr_38155_38326[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (78))){
var inst_37717 = (state_38014[(7)]);
var inst_37719 = (state_38014[(8)]);
var inst_37860 = (state_38014[(2)]);
var inst_37861 = fluree.db.util.async.throw_err(inst_37860);
var inst_37862 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_37719,fuel,max_fuel,inst_37717,inst_37861);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(79),inst_37862);
} else {
if((state_val_38015 === (132))){
var inst_37992 = (state_38014[(11)]);
var state_38014__$1 = state_38014;
var statearr_38156_38327 = state_38014__$1;
(statearr_38156_38327[(2)] = inst_37992);

(statearr_38156_38327[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (26))){
var inst_37743 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38157_38328 = state_38014__$1;
(statearr_38157_38328[(2)] = inst_37743);

(statearr_38157_38328[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (123))){
var inst_37987 = (state_38014[(28)]);
var state_38014__$1 = state_38014;
var statearr_38158_38329 = state_38014__$1;
(statearr_38158_38329[(2)] = inst_37987);

(statearr_38158_38329[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (16))){
var inst_37710 = (state_38014[(25)]);
var state_38014__$1 = state_38014;
var statearr_38159_38330 = state_38014__$1;
(statearr_38159_38330[(2)] = inst_37710);

(statearr_38159_38330[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (133))){
var inst_38009 = (state_38014[(2)]);
var _ = (function (){var statearr_38160 = state_38014;
(statearr_38160[(4)] = cljs.core.rest((state_38014[(4)])));

return statearr_38160;
})();
var state_38014__$1 = state_38014;
var statearr_38161_38331 = state_38014__$1;
(statearr_38161_38331[(2)] = inst_38009);

(statearr_38161_38331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (81))){
var inst_37894 = (state_38014[(22)]);
var inst_37894__$1 = cljs.core.sequential_QMARK_(from);
var state_38014__$1 = (function (){var statearr_38162 = state_38014;
(statearr_38162[(22)] = inst_37894__$1);

return statearr_38162;
})();
if(inst_37894__$1){
var statearr_38163_38332 = state_38014__$1;
(statearr_38163_38332[(1)] = (91));

} else {
var statearr_38164_38333 = state_38014__$1;
(statearr_38164_38333[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (120))){
var state_38014__$1 = state_38014;
var statearr_38165_38334 = state_38014__$1;
(statearr_38165_38334[(2)] = null);

(statearr_38165_38334[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (79))){
var inst_37864 = (state_38014[(2)]);
var inst_37865 = fluree.db.util.async.throw_err(inst_37864);
var state_38014__$1 = state_38014;
var statearr_38166_38335 = state_38014__$1;
(statearr_38166_38335[(2)] = inst_37865);

(statearr_38166_38335[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (38))){
var state_38014__$1 = state_38014;
var statearr_38167_38336 = state_38014__$1;
(statearr_38167_38336[(2)] = null);

(statearr_38167_38336[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (126))){
var inst_37993 = (state_38014[(41)]);
var state_38014__$1 = state_38014;
var statearr_38168_38337 = state_38014__$1;
(statearr_38168_38337[(2)] = inst_37993);

(statearr_38168_38337[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (98))){
var inst_37706 = (state_38014[(18)]);
var inst_37950 = (state_38014[(2)]);
var inst_37951 = cljs.core.PersistentVector.EMPTY;
var inst_37952 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37951,inst_37950);
var state_38014__$1 = (function (){var statearr_38169 = state_38014;
(statearr_38169[(34)] = inst_37952);

return statearr_38169;
})();
if(cljs.core.truth_(inst_37706)){
var statearr_38170_38338 = state_38014__$1;
(statearr_38170_38338[(1)] = (113));

} else {
var statearr_38171_38339 = state_38014__$1;
(statearr_38171_38339[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (124))){
var inst_37993 = (state_38014[(41)]);
var inst_37992 = (state_38014[(2)]);
var inst_37993__$1 = selectOne;
var state_38014__$1 = (function (){var statearr_38172 = state_38014;
(statearr_38172[(11)] = inst_37992);

(statearr_38172[(41)] = inst_37993__$1);

return statearr_38172;
})();
if(cljs.core.truth_(inst_37993__$1)){
var statearr_38173_38340 = state_38014__$1;
(statearr_38173_38340[(1)] = (125));

} else {
var statearr_38174_38341 = state_38014__$1;
(statearr_38174_38341[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (87))){
var inst_37884 = (state_38014[(2)]);
var inst_37885 = fluree.db.util.async.throw_err(inst_37884);
var state_38014__$1 = (function (){var statearr_38175 = state_38014;
(statearr_38175[(31)] = inst_37885);

return statearr_38175;
})();
if(cljs.core.truth_(fuel)){
var statearr_38176_38342 = state_38014__$1;
(statearr_38176_38342[(1)] = (88));

} else {
var statearr_38177_38343 = state_38014__$1;
(statearr_38177_38343[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (30))){
var inst_37756 = typeof from === 'string';
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37756)){
var statearr_38178_38344 = state_38014__$1;
(statearr_38178_38344[(1)] = (33));

} else {
var statearr_38179_38345 = state_38014__$1;
(statearr_38179_38345[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (73))){
var inst_37867 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_38014__$1 = state_38014;
if(inst_37867){
var statearr_38180_38346 = state_38014__$1;
(statearr_38180_38346[(1)] = (80));

} else {
var statearr_38181_38347 = state_38014__$1;
(statearr_38181_38347[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (96))){
var inst_37977 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38182_38348 = state_38014__$1;
(statearr_38182_38348[(2)] = inst_37977);

(statearr_38182_38348[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (10))){
var inst_37690 = (state_38014[(39)]);
var inst_37690__$1 = selectDistinct;
var state_38014__$1 = (function (){var statearr_38183 = state_38014;
(statearr_38183[(39)] = inst_37690__$1);

return statearr_38183;
})();
if(cljs.core.truth_(inst_37690__$1)){
var statearr_38184_38349 = state_38014__$1;
(statearr_38184_38349[(1)] = (12));

} else {
var statearr_38185_38350 = state_38014__$1;
(statearr_38185_38350[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (18))){
var inst_37706 = (state_38014[(18)]);
var inst_37721 = cljs.core.vector_QMARK_(inst_37706);
var state_38014__$1 = state_38014;
if(inst_37721){
var statearr_38186_38351 = state_38014__$1;
(statearr_38186_38351[(1)] = (21));

} else {
var statearr_38187_38352 = state_38014__$1;
(statearr_38187_38352[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (105))){
var inst_37929 = cljs.core._deref(fuel);
var inst_37930 = (inst_37929 + (1));
var inst_37931 = cljs.core._vreset_BANG_(fuel,inst_37930);
var state_38014__$1 = state_38014;
var statearr_38188_38353 = state_38014__$1;
(statearr_38188_38353[(2)] = inst_37931);

(statearr_38188_38353[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (52))){
var inst_37793 = (state_38014[(2)]);
var state_38014__$1 = (function (){var statearr_38189 = state_38014;
(statearr_38189[(21)] = inst_37793);

return statearr_38189;
})();
var statearr_38190_38354 = state_38014__$1;
(statearr_38190_38354[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (114))){
var inst_37707 = (state_38014[(13)]);
var state_38014__$1 = state_38014;
var statearr_38192_38355 = state_38014__$1;
(statearr_38192_38355[(2)] = inst_37707);

(statearr_38192_38355[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (67))){
var inst_37832 = cljs.core.PersistentHashMap.EMPTY;
var state_38014__$1 = state_38014;
var statearr_38193_38356 = state_38014__$1;
(statearr_38193_38356[(2)] = inst_37832);

(statearr_38193_38356[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (71))){
var inst_37845 = (state_38014[(2)]);
var inst_37846 = fluree.db.util.async.throw_err(inst_37845);
var state_38014__$1 = state_38014;
var statearr_38194_38357 = state_38014__$1;
(statearr_38194_38357[(2)] = inst_37846);

(statearr_38194_38357[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (42))){
var inst_37709 = (state_38014[(15)]);
var state_38014__$1 = state_38014;
var statearr_38195_38358 = state_38014__$1;
(statearr_38195_38358[(2)] = inst_37709);

(statearr_38195_38358[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (80))){
var inst_37870 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_38014__$1 = state_38014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38014__$1,(83),inst_37870);
} else {
if((state_val_38015 === (37))){
var inst_37775 = (state_38014[(2)]);
var inst_37776 = fluree.db.util.async.throw_err(inst_37775);
var state_38014__$1 = state_38014;
var statearr_38196_38359 = state_38014__$1;
(statearr_38196_38359[(2)] = inst_37776);

(statearr_38196_38359[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (63))){
var inst_37829 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
if(cljs.core.truth_(inst_37829)){
var statearr_38197_38360 = state_38014__$1;
(statearr_38197_38360[(1)] = (64));

} else {
var statearr_38198_38361 = state_38014__$1;
(statearr_38198_38361[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (94))){
var inst_37908 = from;
var inst_37909 = cljs.core.seq(inst_37908);
var inst_37910 = cljs.core.first(inst_37909);
var inst_37911 = cljs.core.next(inst_37909);
var inst_37912 = cljs.core.PersistentVector.EMPTY;
var inst_37913 = inst_37908;
var inst_37914 = inst_37912;
var state_38014__$1 = (function (){var statearr_38199 = state_38014;
(statearr_38199[(42)] = inst_37910);

(statearr_38199[(43)] = inst_37911);

(statearr_38199[(38)] = inst_37913);

(statearr_38199[(10)] = inst_37914);

return statearr_38199;
})();
var statearr_38200_38362 = state_38014__$1;
(statearr_38200_38362[(2)] = null);

(statearr_38200_38362[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (8))){
var inst_37708 = (state_38014[(24)]);
var inst_37703 = (state_38014[(2)]);
var inst_37704 = opts_SINGLEQUOTE_;
var inst_37705 = cljs.core.__destructure_map(inst_37704);
var inst_37706 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37705,cljs.core.cst$kw$orderBy);
var inst_37707 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37705,cljs.core.cst$kw$limit);
var inst_37708__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37705,cljs.core.cst$kw$component);
var inst_37709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37705,cljs.core.cst$kw$offset);
var inst_37710 = fluree.db.query.fql_parser.parse_db(db,inst_37703,opts_SINGLEQUOTE_);
var inst_37711 = (inst_37708__$1 == null);
var inst_37712 = cljs.core.not(inst_37711);
var state_38014__$1 = (function (){var statearr_38201 = state_38014;
(statearr_38201[(18)] = inst_37706);

(statearr_38201[(24)] = inst_37708__$1);

(statearr_38201[(25)] = inst_37710);

(statearr_38201[(13)] = inst_37707);

(statearr_38201[(15)] = inst_37709);

return statearr_38201;
})();
if(inst_37712){
var statearr_38202_38363 = state_38014__$1;
(statearr_38202_38363[(1)] = (15));

} else {
var statearr_38203_38364 = state_38014__$1;
(statearr_38203_38364[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (49))){
var inst_37985 = (state_38014[(2)]);
var state_38014__$1 = state_38014;
var statearr_38204_38365 = state_38014__$1;
(statearr_38204_38365[(2)] = inst_37985);

(statearr_38204_38365[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38015 === (84))){
var state_38014__$1 = state_38014;
var statearr_38205_38366 = state_38014__$1;
(statearr_38205_38366[(2)] = null);

(statearr_38205_38366[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__14778__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__14778__auto____0 = (function (){
var statearr_38206 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38206[(0)] = fluree$db$query$fql$query_$_state_machine__14778__auto__);

(statearr_38206[(1)] = (1));

return statearr_38206;
});
var fluree$db$query$fql$query_$_state_machine__14778__auto____1 = (function (state_38014){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_38014);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e38207){var ex__14781__auto__ = e38207;
var statearr_38208_38367 = state_38014;
(statearr_38208_38367[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_38014[(4)]))){
var statearr_38209_38368 = state_38014;
(statearr_38209_38368[(1)] = cljs.core.first((state_38014[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__38369 = state_38014;
state_38014 = G__38369;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__14778__auto__ = function(state_38014){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__14778__auto____1.call(this,state_38014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__14778__auto____0;
fluree$db$query$fql$query_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__14778__auto____1;
return fluree$db$query$fql$query_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_38210 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_38210[(6)] = c__14852__auto__);

return statearr_38210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}

});
