// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__28074 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28074,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28074,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28074,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28074,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28074,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28074,(5),null);
var G__28077 = idx;
var G__28077__$1 = (((G__28077 instanceof cljs.core.Keyword))?G__28077.fqn:null);
switch (G__28077__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28077__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__28079 = idx;
var G__28079__$1 = (((G__28079 instanceof cljs.core.Keyword))?G__28079.fqn:null);
switch (G__28079__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28079__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__28081 = idx;
var G__28081__$1 = (((G__28081 instanceof cljs.core.Keyword))?G__28081.fqn:null);
switch (G__28081__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28081__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__28084 = arguments.length;
switch (G__28084) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__28085 = (function (){var pred__28088 = cljs.core.identical_QMARK_;
var expr__28089 = test;
if(cljs.core.truth_((pred__28088.cljs$core$IFn$_invoke$arity$2 ? pred__28088.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__28089) : pred__28088.call(null,cljs.core._EQ_,expr__28089)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28088.cljs$core$IFn$_invoke$arity$2 ? pred__28088.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__28089) : pred__28088.call(null,cljs.core._LT_,expr__28089)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__28088.cljs$core$IFn$_invoke$arity$2 ? pred__28088.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__28089) : pred__28088.call(null,cljs.core._LT__EQ_,expr__28089)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28088.cljs$core$IFn$_invoke$arity$2 ? pred__28088.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__28089) : pred__28088.call(null,cljs.core._GT_,expr__28089)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__28088.cljs$core$IFn$_invoke$arity$2 ? pred__28088.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__28089) : pred__28088.call(null,cljs.core._GT__EQ_,expr__28089)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__28089)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28085,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28085,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28085,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28085,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_28328){
var state_val_28329 = (state_28328[(1)]);
if((state_val_28329 === (65))){
var inst_28243 = (state_28328[(7)]);
var inst_28299 = (state_28328[(8)]);
var inst_28299__$1 = (state_28328[(2)]);
var inst_28300 = cljs.core.count(inst_28299__$1);
var state_28328__$1 = (function (){var statearr_28330 = state_28328;
(statearr_28330[(9)] = inst_28300);

(statearr_28330[(8)] = inst_28299__$1);

return statearr_28330;
})();
if(cljs.core.truth_(inst_28243)){
var statearr_28331_28468 = state_28328__$1;
(statearr_28331_28468[(1)] = (81));

} else {
var statearr_28332_28469 = state_28328__$1;
(statearr_28332_28469[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (70))){
var inst_28274 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
if(cljs.core.truth_(inst_28274)){
var statearr_28333_28470 = state_28328__$1;
(statearr_28333_28470[(1)] = (71));

} else {
var statearr_28334_28471 = state_28328__$1;
(statearr_28334_28471[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (62))){
var inst_28213 = (state_28328[(10)]);
var inst_28227 = (state_28328[(11)]);
var inst_28242 = (state_28328[(2)]);
var inst_28243 = fluree.db.dbproto._rhs(inst_28227);
var state_28328__$1 = (function (){var statearr_28335 = state_28328;
(statearr_28335[(7)] = inst_28243);

(statearr_28335[(12)] = inst_28242);

return statearr_28335;
})();
if(cljs.core.truth_(inst_28213)){
var statearr_28336_28472 = state_28328__$1;
(statearr_28336_28472[(1)] = (63));

} else {
var statearr_28337_28473 = state_28328__$1;
(statearr_28337_28473[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (74))){
var inst_28267 = (state_28328[(13)]);
var inst_28281 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_28267);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(77),inst_28281);
} else {
if((state_val_28329 === (7))){
var inst_28104 = (state_28328[(14)]);
var state_28328__$1 = state_28328;
var statearr_28338_28474 = state_28328__$1;
(statearr_28338_28474[(2)] = inst_28104);

(statearr_28338_28474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (59))){
var inst_28234 = (state_28328[(15)]);
var inst_28189 = (state_28328[(16)]);
var inst_28190 = (state_28328[(17)]);
var inst_28233 = (state_28328[(2)]);
var inst_28234__$1 = fluree.db.util.async.throw_err(inst_28233);
var inst_28235 = fluree.db.flake.subrange(inst_28234__$1,start_test,inst_28189,end_test,inst_28190);
var inst_28236 = fluree.db.query.range.value_with_nil_pred(idx,inst_28189,inst_28190);
var state_28328__$1 = (function (){var statearr_28339 = state_28328;
(statearr_28339[(15)] = inst_28234__$1);

(statearr_28339[(18)] = inst_28235);

return statearr_28339;
})();
if(inst_28236){
var statearr_28340_28475 = state_28328__$1;
(statearr_28340_28475[(1)] = (60));

} else {
var statearr_28341_28476 = state_28328__$1;
(statearr_28341_28476[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (86))){
var inst_28308 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28342_28477 = state_28328__$1;
(statearr_28342_28477[(2)] = inst_28308);

(statearr_28342_28477[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (20))){
var inst_28153 = (state_28328[(19)]);
var inst_28105 = (state_28328[(20)]);
var inst_28152 = (state_28328[(2)]);
var inst_28153__$1 = (inst_28105 == null);
var state_28328__$1 = (function (){var statearr_28343 = state_28328;
(statearr_28343[(21)] = inst_28152);

(statearr_28343[(19)] = inst_28153__$1);

return statearr_28343;
})();
if(cljs.core.truth_(inst_28153__$1)){
var statearr_28344_28478 = state_28328__$1;
(statearr_28344_28478[(1)] = (22));

} else {
var statearr_28345_28479 = state_28328__$1;
(statearr_28345_28479[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (72))){
var inst_28260 = (state_28328[(22)]);
var inst_28278 = (inst_28260 + (1));
var inst_28279 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28328__$1 = (function (){var statearr_28346 = state_28328;
(statearr_28346[(23)] = inst_28278);

return statearr_28346;
})();
if(cljs.core.truth_(inst_28279)){
var statearr_28347_28480 = state_28328__$1;
(statearr_28347_28480[(1)] = (74));

} else {
var statearr_28348_28481 = state_28328__$1;
(statearr_28348_28481[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (58))){
var inst_28323 = (state_28328[(2)]);
var _ = (function (){var statearr_28349 = state_28328;
(statearr_28349[(4)] = cljs.core.rest((state_28328[(4)])));

return statearr_28349;
})();
var state_28328__$1 = state_28328;
var statearr_28350_28482 = state_28328__$1;
(statearr_28350_28482[(2)] = inst_28323);

(statearr_28350_28482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (60))){
var inst_28143 = (state_28328[(24)]);
var inst_28234 = (state_28328[(15)]);
var inst_28206 = (state_28328[(25)]);
var inst_28134 = (state_28328[(26)]);
var inst_28110 = (state_28328[(27)]);
var inst_28222 = (state_28328[(28)]);
var inst_28213 = (state_28328[(10)]);
var inst_28196 = (state_28328[(29)]);
var inst_28189 = (state_28328[(16)]);
var inst_28170 = (state_28328[(30)]);
var inst_28188 = (state_28328[(31)]);
var inst_28207 = (state_28328[(32)]);
var inst_28217 = (state_28328[(33)]);
var inst_28152 = (state_28328[(21)]);
var inst_28179 = (state_28328[(34)]);
var inst_28229 = (state_28328[(35)]);
var inst_28190 = (state_28328[(17)]);
var inst_28227 = (state_28328[(11)]);
var inst_28103 = (state_28328[(36)]);
var inst_28115 = (state_28328[(37)]);
var inst_28200 = (state_28328[(38)]);
var inst_28195 = (state_28328[(39)]);
var inst_28228 = (state_28328[(40)]);
var inst_28108 = (state_28328[(41)]);
var inst_28235 = (state_28328[(18)]);
var inst_28114 = (state_28328[(42)]);
var inst_28107 = (state_28328[(43)]);
var inst_28161 = (state_28328[(44)]);
var inst_28125 = (state_28328[(45)]);
var inst_28238 = (function (){var no_filter_QMARK_ = inst_28213;
var next_node = inst_28227;
var vec__28100 = inst_28110;
var flakes = inst_28234;
var s1 = inst_28125;
var o2 = inst_28152;
var t1 = inst_28107;
var i = inst_28228;
var m1 = inst_28179;
var root_node = inst_28222;
var to_t = inst_28207;
var s2 = inst_28134;
var p2 = inst_28170;
var vec__28097 = inst_28103;
var permissions = inst_28196;
var limit = inst_28195;
var start_flake = inst_28189;
var acc = inst_28229;
var t2 = inst_28114;
var op1 = inst_28108;
var o1 = inst_28143;
var end_flake = inst_28190;
var base_result = inst_28235;
var p1 = inst_28161;
var idx_compare = inst_28200;
var op2 = inst_28115;
var from_t = inst_28206;
var m2 = inst_28188;
var novelty = inst_28217;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_28239 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28238,inst_28235,inst_28235);
var state_28328__$1 = state_28328;
var statearr_28351_28483 = state_28328__$1;
(statearr_28351_28483[(2)] = inst_28239);

(statearr_28351_28483[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (27))){
var inst_28112 = (state_28328[(46)]);
var inst_28162 = (state_28328[(47)]);
var inst_28161 = (state_28328[(2)]);
var inst_28162__$1 = (inst_28112 == null);
var state_28328__$1 = (function (){var statearr_28352 = state_28328;
(statearr_28352[(47)] = inst_28162__$1);

(statearr_28352[(44)] = inst_28161);

return statearr_28352;
})();
if(cljs.core.truth_(inst_28162__$1)){
var statearr_28353_28484 = state_28328__$1;
(statearr_28353_28484[(1)] = (28));

} else {
var statearr_28354_28485 = state_28328__$1;
(statearr_28354_28485[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (1))){
var state_28328__$1 = state_28328;
var statearr_28355_28486 = state_28328__$1;
(statearr_28355_28486[(2)] = null);

(statearr_28355_28486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (69))){
var inst_28260 = (state_28328[(22)]);
var inst_28195 = (state_28328[(39)]);
var inst_28272 = (inst_28260 > inst_28195);
var state_28328__$1 = state_28328;
var statearr_28356_28487 = state_28328__$1;
(statearr_28356_28487[(2)] = inst_28272);

(statearr_28356_28487[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (24))){
var inst_28157 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
if(cljs.core.truth_(inst_28157)){
var statearr_28357_28488 = state_28328__$1;
(statearr_28357_28488[(1)] = (25));

} else {
var statearr_28358_28489 = state_28328__$1;
(statearr_28358_28489[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (55))){
var inst_28222 = (state_28328[(28)]);
var inst_28189 = (state_28328[(16)]);
var inst_28221 = (state_28328[(2)]);
var inst_28222__$1 = fluree.db.util.async.throw_err(inst_28221);
var inst_28223 = fluree.db.dbproto._lookup_leaf(inst_28222__$1,inst_28189);
var state_28328__$1 = (function (){var statearr_28359 = state_28328;
(statearr_28359[(28)] = inst_28222__$1);

return statearr_28359;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(56),inst_28223);
} else {
if((state_val_28329 === (85))){
var inst_28303 = (state_28328[(48)]);
var state_28328__$1 = state_28328;
var statearr_28360_28490 = state_28328__$1;
(statearr_28360_28490[(2)] = inst_28303);

(statearr_28360_28490[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (39))){
var inst_28177 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28361_28491 = state_28328__$1;
(statearr_28361_28491[(2)] = inst_28177);

(statearr_28361_28491[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (88))){
var inst_28222 = (state_28328[(28)]);
var inst_28243 = (state_28328[(7)]);
var inst_28315 = fluree.db.dbproto._lookup_leaf(inst_28222,inst_28243);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(90),inst_28315);
} else {
if((state_val_28329 === (46))){
var inst_28191 = (state_28328[(49)]);
var state_28328__$1 = state_28328;
var statearr_28362_28492 = state_28328__$1;
(statearr_28362_28492[(2)] = inst_28191);

(statearr_28362_28492[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (4))){
var inst_28091 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28363_28493 = state_28328__$1;
(statearr_28363_28493[(2)] = inst_28091);

(statearr_28363_28493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (77))){
var inst_28283 = (state_28328[(2)]);
var inst_28284 = fluree.db.util.async.throw_err(inst_28283);
var state_28328__$1 = state_28328;
if(cljs.core.truth_(inst_28284)){
var statearr_28364_28494 = state_28328__$1;
(statearr_28364_28494[(1)] = (78));

} else {
var statearr_28365_28495 = state_28328__$1;
(statearr_28365_28495[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (54))){
var inst_28213 = (state_28328[(2)]);
var inst_28214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28215 = [cljs.core.cst$kw$novelty,idx];
var inst_28216 = (new cljs.core.PersistentVector(null,2,(5),inst_28214,inst_28215,null));
var inst_28217 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_28216);
var inst_28218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_28219 = fluree.db.dbproto._resolve(inst_28218);
var state_28328__$1 = (function (){var statearr_28366 = state_28328;
(statearr_28366[(10)] = inst_28213);

(statearr_28366[(33)] = inst_28217);

return statearr_28366;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(55),inst_28219);
} else {
if((state_val_28329 === (15))){
var inst_28106 = (state_28328[(50)]);
var state_28328__$1 = state_28328;
var statearr_28367_28496 = state_28328__$1;
(statearr_28367_28496[(2)] = inst_28106);

(statearr_28367_28496[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (48))){
var inst_28201 = (state_28328[(51)]);
var inst_28195 = (state_28328[(2)]);
var inst_28196 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_28197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28198 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_28199 = (new cljs.core.PersistentVector(null,3,(5),inst_28197,inst_28198,null));
var inst_28200 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_28199);
var inst_28201__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_28328__$1 = (function (){var statearr_28368 = state_28328;
(statearr_28368[(29)] = inst_28196);

(statearr_28368[(38)] = inst_28200);

(statearr_28368[(39)] = inst_28195);

(statearr_28368[(51)] = inst_28201__$1);

return statearr_28368;
})();
if(cljs.core.truth_(inst_28201__$1)){
var statearr_28369_28497 = state_28328__$1;
(statearr_28369_28497[(1)] = (49));

} else {
var statearr_28370_28498 = state_28328__$1;
(statearr_28370_28498[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (50))){
var inst_28204 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_28328__$1 = state_28328;
var statearr_28371_28499 = state_28328__$1;
(statearr_28371_28499[(2)] = inst_28204);

(statearr_28371_28499[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (75))){
var inst_28261 = (state_28328[(52)]);
var state_28328__$1 = state_28328;
var statearr_28372_28500 = state_28328__$1;
(statearr_28372_28500[(2)] = inst_28261);

(statearr_28372_28500[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (21))){
var inst_28148 = (state_28328[(2)]);
var inst_28149 = fluree.db.util.async.throw_err(inst_28148);
var state_28328__$1 = state_28328;
var statearr_28373_28501 = state_28328__$1;
(statearr_28373_28501[(2)] = inst_28149);

(statearr_28373_28501[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (31))){
var state_28328__$1 = state_28328;
var statearr_28374_28502 = state_28328__$1;
(statearr_28374_28502[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_28374_28502[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (32))){
var inst_28112 = (state_28328[(46)]);
var state_28328__$1 = state_28328;
var statearr_28375_28503 = state_28328__$1;
(statearr_28375_28503[(2)] = inst_28112);

(statearr_28375_28503[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (40))){
var inst_28116 = (state_28328[(53)]);
var state_28328__$1 = state_28328;
var statearr_28376_28504 = state_28328__$1;
(statearr_28376_28504[(2)] = inst_28116);

(statearr_28376_28504[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (56))){
var inst_28225 = (state_28328[(2)]);
var inst_28226 = fluree.db.util.async.throw_err(inst_28225);
var inst_28227 = inst_28226;
var inst_28228 = (0);
var inst_28229 = null;
var state_28328__$1 = (function (){var statearr_28377 = state_28328;
(statearr_28377[(35)] = inst_28229);

(statearr_28377[(11)] = inst_28227);

(statearr_28377[(40)] = inst_28228);

return statearr_28377;
})();
var statearr_28378_28505 = state_28328__$1;
(statearr_28378_28505[(2)] = null);

(statearr_28378_28505[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (33))){
var inst_28109 = (state_28328[(54)]);
var inst_28170 = (state_28328[(2)]);
var state_28328__$1 = (function (){var statearr_28379 = state_28328;
(statearr_28379[(30)] = inst_28170);

return statearr_28379;
})();
if(cljs.core.truth_(inst_28109)){
var statearr_28380_28506 = state_28328__$1;
(statearr_28380_28506[(1)] = (34));

} else {
var statearr_28381_28507 = state_28328__$1;
(statearr_28381_28507[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (13))){
var inst_28130 = (state_28328[(2)]);
var inst_28131 = fluree.db.util.async.throw_err(inst_28130);
var state_28328__$1 = state_28328;
var statearr_28382_28508 = state_28328__$1;
(statearr_28382_28508[(2)] = inst_28131);

(statearr_28382_28508[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (22))){
var inst_28143 = (state_28328[(24)]);
var state_28328__$1 = state_28328;
var statearr_28383_28509 = state_28328__$1;
(statearr_28383_28509[(2)] = inst_28143);

(statearr_28383_28509[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (90))){
var inst_28300 = (state_28328[(9)]);
var inst_28299 = (state_28328[(8)]);
var inst_28317 = (state_28328[(2)]);
var inst_28318 = fluree.db.util.async.throw_err(inst_28317);
var inst_28227 = inst_28318;
var inst_28228 = inst_28300;
var inst_28229 = inst_28299;
var state_28328__$1 = (function (){var statearr_28384 = state_28328;
(statearr_28384[(35)] = inst_28229);

(statearr_28384[(11)] = inst_28227);

(statearr_28384[(40)] = inst_28228);

return statearr_28384;
})();
var statearr_28385_28510 = state_28328__$1;
(statearr_28385_28510[(2)] = null);

(statearr_28385_28510[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (36))){
var inst_28116 = (state_28328[(53)]);
var inst_28179 = (state_28328[(2)]);
var state_28328__$1 = (function (){var statearr_28386 = state_28328;
(statearr_28386[(34)] = inst_28179);

return statearr_28386;
})();
if(cljs.core.truth_(inst_28116)){
var statearr_28387_28511 = state_28328__$1;
(statearr_28387_28511[(1)] = (40));

} else {
var statearr_28388_28512 = state_28328__$1;
(statearr_28388_28512[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (41))){
var inst_28182 = (cljs.core._LT__EQ_ === end_test);
var state_28328__$1 = state_28328;
if(cljs.core.truth_(inst_28182)){
var statearr_28389_28513 = state_28328__$1;
(statearr_28389_28513[(1)] = (43));

} else {
var statearr_28390_28514 = state_28328__$1;
(statearr_28390_28514[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (89))){
var inst_28321 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28391_28515 = state_28328__$1;
(statearr_28391_28515[(2)] = inst_28321);

(statearr_28391_28515[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (43))){
var state_28328__$1 = state_28328;
var statearr_28392_28516 = state_28328__$1;
(statearr_28392_28516[(2)] = (2147483647));

(statearr_28392_28516[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (61))){
var inst_28235 = (state_28328[(18)]);
var state_28328__$1 = state_28328;
var statearr_28393_28517 = state_28328__$1;
(statearr_28393_28517[(2)] = inst_28235);

(statearr_28393_28517[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (29))){
var inst_28162 = (state_28328[(47)]);
var state_28328__$1 = state_28328;
var statearr_28394_28518 = state_28328__$1;
(statearr_28394_28518[(2)] = inst_28162);

(statearr_28394_28518[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (44))){
var state_28328__$1 = state_28328;
var statearr_28395_28519 = state_28328__$1;
(statearr_28395_28519[(2)] = fluree.db.util.core.min_integer);

(statearr_28395_28519[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (6))){
var inst_28104 = (state_28328[(14)]);
var inst_28119 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28104);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(9),inst_28119);
} else {
if((state_val_28329 === (28))){
var inst_28152 = (state_28328[(21)]);
var state_28328__$1 = state_28328;
var statearr_28396_28520 = state_28328__$1;
(statearr_28396_28520[(2)] = inst_28152);

(statearr_28396_28520[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (64))){
var inst_28228 = (state_28328[(40)]);
var inst_28242 = (state_28328[(12)]);
var inst_28256 = cljs.core.seq(inst_28242);
var inst_28257 = cljs.core.first(inst_28256);
var inst_28258 = cljs.core.next(inst_28256);
var inst_28259 = inst_28242;
var inst_28260 = inst_28228;
var inst_28261 = inst_28242;
var state_28328__$1 = (function (){var statearr_28397 = state_28328;
(statearr_28397[(52)] = inst_28261);

(statearr_28397[(55)] = inst_28258);

(statearr_28397[(56)] = inst_28259);

(statearr_28397[(57)] = inst_28257);

(statearr_28397[(22)] = inst_28260);

return statearr_28397;
})();
var statearr_28398_28521 = state_28328__$1;
(statearr_28398_28521[(2)] = null);

(statearr_28398_28521[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (51))){
var inst_28206 = (state_28328[(2)]);
var inst_28207 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_28208 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28328__$1 = (function (){var statearr_28399 = state_28328;
(statearr_28399[(25)] = inst_28206);

(statearr_28399[(32)] = inst_28207);

return statearr_28399;
})();
if(cljs.core.truth_(inst_28208)){
var statearr_28400_28522 = state_28328__$1;
(statearr_28400_28522[(1)] = (52));

} else {
var statearr_28401_28523 = state_28328__$1;
(statearr_28401_28523[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (25))){
var state_28328__$1 = state_28328;
var statearr_28402_28524 = state_28328__$1;
(statearr_28402_28524[(2)] = (-1));

(statearr_28402_28524[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (34))){
var inst_28109 = (state_28328[(54)]);
var state_28328__$1 = state_28328;
var statearr_28403_28525 = state_28328__$1;
(statearr_28403_28525[(2)] = inst_28109);

(statearr_28403_28525[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (17))){
var inst_28139 = (state_28328[(2)]);
var inst_28140 = fluree.db.util.async.throw_err(inst_28139);
var state_28328__$1 = state_28328;
var statearr_28404_28526 = state_28328__$1;
(statearr_28404_28526[(2)] = inst_28140);

(statearr_28404_28526[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (3))){
var inst_28326 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28328__$1,inst_28326);
} else {
if((state_val_28329 === (12))){
var inst_28106 = (state_28328[(50)]);
var inst_28134 = (state_28328[(2)]);
var inst_28135 = fluree.db.util.core.pred_ident_QMARK_(inst_28106);
var state_28328__$1 = (function (){var statearr_28405 = state_28328;
(statearr_28405[(26)] = inst_28134);

return statearr_28405;
})();
if(inst_28135){
var statearr_28406_28527 = state_28328__$1;
(statearr_28406_28527[(1)] = (14));

} else {
var statearr_28407_28528 = state_28328__$1;
(statearr_28407_28528[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (2))){
var inst_28104 = (state_28328[(14)]);
var inst_28110 = (state_28328[(27)]);
var inst_28103 = (state_28328[(36)]);
var _ = (function (){var statearr_28408 = state_28328;
(statearr_28408[(4)] = cljs.core.cons((5),(state_28328[(4)])));

return statearr_28408;
})();
var inst_28103__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_28104__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28103__$1,(0),null);
var inst_28105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28103__$1,(1),null);
var inst_28106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28103__$1,(2),null);
var inst_28107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28103__$1,(3),null);
var inst_28108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28103__$1,(4),null);
var inst_28109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28103__$1,(5),null);
var inst_28110__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_28111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28110__$1,(0),null);
var inst_28112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28110__$1,(1),null);
var inst_28113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28110__$1,(2),null);
var inst_28114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28110__$1,(3),null);
var inst_28115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28110__$1,(4),null);
var inst_28116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28110__$1,(5),null);
var inst_28117 = fluree.db.util.core.pred_ident_QMARK_(inst_28104__$1);
var state_28328__$1 = (function (){var statearr_28409 = state_28328;
(statearr_28409[(58)] = inst_28111);

(statearr_28409[(46)] = inst_28112);

(statearr_28409[(14)] = inst_28104__$1);

(statearr_28409[(27)] = inst_28110__$1);

(statearr_28409[(59)] = inst_28113);

(statearr_28409[(36)] = inst_28103__$1);

(statearr_28409[(37)] = inst_28115);

(statearr_28409[(41)] = inst_28108);

(statearr_28409[(42)] = inst_28114);

(statearr_28409[(50)] = inst_28106);

(statearr_28409[(43)] = inst_28107);

(statearr_28409[(53)] = inst_28116);

(statearr_28409[(54)] = inst_28109);

(statearr_28409[(20)] = inst_28105);

return statearr_28409;
})();
if(inst_28117){
var statearr_28410_28529 = state_28328__$1;
(statearr_28410_28529[(1)] = (6));

} else {
var statearr_28411_28530 = state_28328__$1;
(statearr_28411_28530[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (66))){
var inst_28259 = (state_28328[(56)]);
var inst_28269 = (state_28328[(60)]);
var inst_28267 = (state_28328[(13)]);
var inst_28266 = cljs.core.seq(inst_28259);
var inst_28267__$1 = cljs.core.first(inst_28266);
var inst_28268 = cljs.core.next(inst_28266);
var inst_28269__$1 = (inst_28267__$1 == null);
var state_28328__$1 = (function (){var statearr_28412 = state_28328;
(statearr_28412[(61)] = inst_28268);

(statearr_28412[(60)] = inst_28269__$1);

(statearr_28412[(13)] = inst_28267__$1);

return statearr_28412;
})();
if(cljs.core.truth_(inst_28269__$1)){
var statearr_28413_28531 = state_28328__$1;
(statearr_28413_28531[(1)] = (68));

} else {
var statearr_28414_28532 = state_28328__$1;
(statearr_28414_28532[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (23))){
var inst_28153 = (state_28328[(19)]);
var state_28328__$1 = state_28328;
var statearr_28415_28533 = state_28328__$1;
(statearr_28415_28533[(2)] = inst_28153);

(statearr_28415_28533[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (47))){
var state_28328__$1 = state_28328;
var statearr_28416_28534 = state_28328__$1;
(statearr_28416_28534[(2)] = fluree.db.util.core.max_long);

(statearr_28416_28534[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (35))){
var inst_28173 = (cljs.core._GT__EQ_ === start_test);
var state_28328__$1 = state_28328;
if(cljs.core.truth_(inst_28173)){
var statearr_28417_28535 = state_28328__$1;
(statearr_28417_28535[(1)] = (37));

} else {
var statearr_28418_28536 = state_28328__$1;
(statearr_28418_28536[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (82))){
var inst_28243 = (state_28328[(7)]);
var state_28328__$1 = state_28328;
var statearr_28419_28537 = state_28328__$1;
(statearr_28419_28537[(2)] = inst_28243);

(statearr_28419_28537[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (76))){
var inst_28268 = (state_28328[(61)]);
var inst_28278 = (state_28328[(23)]);
var inst_28292 = (state_28328[(2)]);
var inst_28259 = inst_28268;
var inst_28260 = inst_28278;
var inst_28261 = inst_28292;
var state_28328__$1 = (function (){var statearr_28420 = state_28328;
(statearr_28420[(52)] = inst_28261);

(statearr_28420[(56)] = inst_28259);

(statearr_28420[(22)] = inst_28260);

return statearr_28420;
})();
var statearr_28421_28538 = state_28328__$1;
(statearr_28421_28538[(2)] = null);

(statearr_28421_28538[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (19))){
var inst_28113 = (state_28328[(59)]);
var state_28328__$1 = state_28328;
var statearr_28422_28539 = state_28328__$1;
(statearr_28422_28539[(2)] = inst_28113);

(statearr_28422_28539[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (57))){
var inst_28206 = (state_28328[(25)]);
var inst_28207 = (state_28328[(32)]);
var inst_28217 = (state_28328[(33)]);
var inst_28227 = (state_28328[(11)]);
var inst_28231 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_28227,inst_28206,inst_28207,inst_28217);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(59),inst_28231);
} else {
if((state_val_28329 === (68))){
var inst_28269 = (state_28328[(60)]);
var state_28328__$1 = state_28328;
var statearr_28423_28540 = state_28328__$1;
(statearr_28423_28540[(2)] = inst_28269);

(statearr_28423_28540[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (11))){
var inst_28111 = (state_28328[(58)]);
var state_28328__$1 = state_28328;
var statearr_28425_28541 = state_28328__$1;
(statearr_28425_28541[(2)] = inst_28111);

(statearr_28425_28541[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (9))){
var inst_28121 = (state_28328[(2)]);
var inst_28122 = fluree.db.util.async.throw_err(inst_28121);
var state_28328__$1 = state_28328;
var statearr_28426_28542 = state_28328__$1;
(statearr_28426_28542[(2)] = inst_28122);

(statearr_28426_28542[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (5))){
var _ = (function (){var statearr_28427 = state_28328;
(statearr_28427[(4)] = cljs.core.rest((state_28328[(4)])));

return statearr_28427;
})();
var state_28328__$1 = state_28328;
var ex28424 = (state_28328__$1[(2)]);
var statearr_28428_28543 = state_28328__$1;
(statearr_28428_28543[(5)] = ex28424);


if((ex28424 instanceof Error)){
var statearr_28429_28544 = state_28328__$1;
(statearr_28429_28544[(1)] = (4));

(statearr_28429_28544[(5)] = null);

} else {
throw ex28424;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (83))){
var inst_28311 = (state_28328[(2)]);
var inst_28312 = cljs.core.not(inst_28311);
var state_28328__$1 = state_28328;
if(inst_28312){
var statearr_28430_28545 = state_28328__$1;
(statearr_28430_28545[(1)] = (87));

} else {
var statearr_28431_28546 = state_28328__$1;
(statearr_28431_28546[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (14))){
var inst_28106 = (state_28328[(50)]);
var inst_28137 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28106);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(17),inst_28137);
} else {
if((state_val_28329 === (45))){
var inst_28186 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28432_28547 = state_28328__$1;
(statearr_28432_28547[(2)] = inst_28186);

(statearr_28432_28547[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (53))){
var state_28328__$1 = state_28328;
var statearr_28433_28548 = state_28328__$1;
(statearr_28433_28548[(2)] = true);

(statearr_28433_28548[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (78))){
var inst_28261 = (state_28328[(52)]);
var state_28328__$1 = state_28328;
var statearr_28434_28549 = state_28328__$1;
(statearr_28434_28549[(2)] = inst_28261);

(statearr_28434_28549[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (26))){
var inst_28105 = (state_28328[(20)]);
var state_28328__$1 = state_28328;
var statearr_28435_28550 = state_28328__$1;
(statearr_28435_28550[(2)] = inst_28105);

(statearr_28435_28550[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (16))){
var inst_28113 = (state_28328[(59)]);
var inst_28143 = (state_28328[(2)]);
var inst_28144 = fluree.db.util.core.pred_ident_QMARK_(inst_28113);
var state_28328__$1 = (function (){var statearr_28436 = state_28328;
(statearr_28436[(24)] = inst_28143);

return statearr_28436;
})();
if(inst_28144){
var statearr_28437_28551 = state_28328__$1;
(statearr_28437_28551[(1)] = (18));

} else {
var statearr_28438_28552 = state_28328__$1;
(statearr_28438_28552[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (81))){
var inst_28303 = (state_28328[(48)]);
var inst_28243 = (state_28328[(7)]);
var inst_28190 = (state_28328[(17)]);
var inst_28200 = (state_28328[(38)]);
var inst_28302 = (inst_28200.cljs$core$IFn$_invoke$arity$2 ? inst_28200.cljs$core$IFn$_invoke$arity$2(inst_28243,inst_28190) : inst_28200.call(null,inst_28243,inst_28190));
var inst_28303__$1 = (inst_28302 < (0));
var state_28328__$1 = (function (){var statearr_28439 = state_28328;
(statearr_28439[(48)] = inst_28303__$1);

return statearr_28439;
})();
if(cljs.core.truth_(inst_28303__$1)){
var statearr_28440_28553 = state_28328__$1;
(statearr_28440_28553[(1)] = (84));

} else {
var statearr_28441_28554 = state_28328__$1;
(statearr_28441_28554[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (79))){
var inst_28261 = (state_28328[(52)]);
var inst_28267 = (state_28328[(13)]);
var inst_28287 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_28261,inst_28267);
var state_28328__$1 = state_28328;
var statearr_28442_28555 = state_28328__$1;
(statearr_28442_28555[(2)] = inst_28287);

(statearr_28442_28555[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (38))){
var state_28328__$1 = state_28328;
var statearr_28443_28556 = state_28328__$1;
(statearr_28443_28556[(2)] = (2147483647));

(statearr_28443_28556[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (87))){
var inst_28299 = (state_28328[(8)]);
var state_28328__$1 = state_28328;
var statearr_28444_28557 = state_28328__$1;
(statearr_28444_28557[(2)] = inst_28299);

(statearr_28444_28557[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (30))){
var inst_28166 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
if(cljs.core.truth_(inst_28166)){
var statearr_28445_28558 = state_28328__$1;
(statearr_28445_28558[(1)] = (31));

} else {
var statearr_28446_28559 = state_28328__$1;
(statearr_28446_28559[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (73))){
var inst_28295 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28447_28560 = state_28328__$1;
(statearr_28447_28560[(2)] = inst_28295);

(statearr_28447_28560[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (10))){
var inst_28111 = (state_28328[(58)]);
var inst_28128 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28111);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(13),inst_28128);
} else {
if((state_val_28329 === (18))){
var inst_28113 = (state_28328[(59)]);
var inst_28146 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28113);
var state_28328__$1 = state_28328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28328__$1,(21),inst_28146);
} else {
if((state_val_28329 === (52))){
var inst_28134 = (state_28328[(26)]);
var inst_28196 = (state_28328[(29)]);
var inst_28170 = (state_28328[(30)]);
var inst_28161 = (state_28328[(44)]);
var inst_28125 = (state_28328[(45)]);
var inst_28210 = fluree.db.permissions_validate.no_filter_QMARK_(inst_28196,inst_28125,inst_28134,inst_28161,inst_28170);
var state_28328__$1 = state_28328;
var statearr_28448_28561 = state_28328__$1;
(statearr_28448_28561[(2)] = inst_28210);

(statearr_28448_28561[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (67))){
var inst_28297 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28449_28562 = state_28328__$1;
(statearr_28449_28562[(2)] = inst_28297);

(statearr_28449_28562[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (71))){
var inst_28261 = (state_28328[(52)]);
var inst_28229 = (state_28328[(35)]);
var inst_28276 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28261,inst_28229);
var state_28328__$1 = state_28328;
var statearr_28450_28563 = state_28328__$1;
(statearr_28450_28563[(2)] = inst_28276);

(statearr_28450_28563[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (42))){
var inst_28143 = (state_28328[(24)]);
var inst_28134 = (state_28328[(26)]);
var inst_28170 = (state_28328[(30)]);
var inst_28188 = (state_28328[(31)]);
var inst_28152 = (state_28328[(21)]);
var inst_28179 = (state_28328[(34)]);
var inst_28191 = (state_28328[(49)]);
var inst_28115 = (state_28328[(37)]);
var inst_28108 = (state_28328[(41)]);
var inst_28114 = (state_28328[(42)]);
var inst_28107 = (state_28328[(43)]);
var inst_28161 = (state_28328[(44)]);
var inst_28125 = (state_28328[(45)]);
var inst_28188__$1 = (state_28328[(2)]);
var inst_28189 = fluree.db.flake.__GT_Flake(inst_28125,inst_28161,inst_28143,inst_28107,inst_28108,inst_28179);
var inst_28190 = fluree.db.flake.__GT_Flake(inst_28134,inst_28170,inst_28152,inst_28114,inst_28115,inst_28188__$1);
var inst_28191__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_28328__$1 = (function (){var statearr_28451 = state_28328;
(statearr_28451[(16)] = inst_28189);

(statearr_28451[(31)] = inst_28188__$1);

(statearr_28451[(49)] = inst_28191__$1);

(statearr_28451[(17)] = inst_28190);

return statearr_28451;
})();
if(cljs.core.truth_(inst_28191__$1)){
var statearr_28452_28564 = state_28328__$1;
(statearr_28452_28564[(1)] = (46));

} else {
var statearr_28453_28565 = state_28328__$1;
(statearr_28453_28565[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (80))){
var inst_28289 = (state_28328[(2)]);
var state_28328__$1 = state_28328;
var statearr_28454_28566 = state_28328__$1;
(statearr_28454_28566[(2)] = inst_28289);

(statearr_28454_28566[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (37))){
var state_28328__$1 = state_28328;
var statearr_28455_28567 = state_28328__$1;
(statearr_28455_28567[(2)] = fluree.db.util.core.min_integer);

(statearr_28455_28567[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (63))){
var inst_28229 = (state_28328[(35)]);
var inst_28195 = (state_28328[(39)]);
var inst_28228 = (state_28328[(40)]);
var inst_28242 = (state_28328[(12)]);
var inst_28245 = (inst_28195 - inst_28228);
var inst_28246 = fluree.db.flake.take(inst_28245,inst_28242);
var inst_28247 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28246,inst_28229);
var state_28328__$1 = state_28328;
var statearr_28456_28568 = state_28328__$1;
(statearr_28456_28568[(2)] = inst_28247);

(statearr_28456_28568[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (8))){
var inst_28111 = (state_28328[(58)]);
var inst_28125 = (state_28328[(2)]);
var inst_28126 = fluree.db.util.core.pred_ident_QMARK_(inst_28111);
var state_28328__$1 = (function (){var statearr_28457 = state_28328;
(statearr_28457[(45)] = inst_28125);

return statearr_28457;
})();
if(inst_28126){
var statearr_28458_28569 = state_28328__$1;
(statearr_28458_28569[(1)] = (10));

} else {
var statearr_28459_28570 = state_28328__$1;
(statearr_28459_28570[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (49))){
var inst_28201 = (state_28328[(51)]);
var state_28328__$1 = state_28328;
var statearr_28460_28571 = state_28328__$1;
(statearr_28460_28571[(2)] = inst_28201);

(statearr_28460_28571[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28329 === (84))){
var inst_28300 = (state_28328[(9)]);
var inst_28195 = (state_28328[(39)]);
var inst_28305 = (inst_28300 < inst_28195);
var state_28328__$1 = state_28328;
var statearr_28461_28572 = state_28328__$1;
(statearr_28461_28572[(2)] = inst_28305);

(statearr_28461_28572[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__14778__auto__ = null;
var fluree$db$query$range$state_machine__14778__auto____0 = (function (){
var statearr_28462 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28462[(0)] = fluree$db$query$range$state_machine__14778__auto__);

(statearr_28462[(1)] = (1));

return statearr_28462;
});
var fluree$db$query$range$state_machine__14778__auto____1 = (function (state_28328){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_28328);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e28463){var ex__14781__auto__ = e28463;
var statearr_28464_28573 = state_28328;
(statearr_28464_28573[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_28328[(4)]))){
var statearr_28465_28574 = state_28328;
(statearr_28465_28574[(1)] = cljs.core.first((state_28328[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__28575 = state_28328;
state_28328 = G__28575;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__14778__auto__ = function(state_28328){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__14778__auto____1.call(this,state_28328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__14778__auto____0;
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__14778__auto____1;
return fluree$db$query$range$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_28466 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_28466[(6)] = c__14852__auto__);

return statearr_28466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_28650){
var state_val_28651 = (state_28650[(1)]);
if((state_val_28651 === (7))){
var inst_28645 = (state_28650[(2)]);
var _ = (function (){var statearr_28652 = state_28650;
(statearr_28652[(4)] = cljs.core.rest((state_28650[(4)])));

return statearr_28652;
})();
var state_28650__$1 = state_28650;
var statearr_28653_28693 = state_28650__$1;
(statearr_28653_28693[(2)] = inst_28645);

(statearr_28653_28693[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (20))){
var inst_28627 = (state_28650[(2)]);
var inst_28628 = fluree.db.util.async.throw_err(inst_28627);
var state_28650__$1 = state_28650;
var statearr_28654_28694 = state_28650__$1;
(statearr_28654_28694[(2)] = inst_28628);

(statearr_28654_28694[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (1))){
var state_28650__$1 = state_28650;
var statearr_28655_28695 = state_28650__$1;
(statearr_28655_28695[(2)] = null);

(statearr_28655_28695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (4))){
var inst_28576 = (state_28650[(2)]);
var state_28650__$1 = state_28650;
var statearr_28656_28696 = state_28650__$1;
(statearr_28656_28696[(2)] = inst_28576);

(statearr_28656_28696[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (15))){
var inst_28623 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28650__$1 = state_28650;
if(cljs.core.truth_(inst_28623)){
var statearr_28657_28697 = state_28650__$1;
(statearr_28657_28697[(1)] = (17));

} else {
var statearr_28658_28698 = state_28650__$1;
(statearr_28658_28698[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (21))){
var state_28650__$1 = state_28650;
var statearr_28659_28699 = state_28650__$1;
(statearr_28659_28699[(2)] = (0));

(statearr_28659_28699[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (13))){
var inst_28615 = (state_28650[(2)]);
var state_28650__$1 = state_28650;
var statearr_28660_28700 = state_28650__$1;
(statearr_28660_28700[(2)] = inst_28615);

(statearr_28660_28700[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (22))){
var state_28650__$1 = state_28650;
var statearr_28661_28701 = state_28650__$1;
(statearr_28661_28701[(2)] = (1));

(statearr_28661_28701[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (6))){
var inst_28605 = (state_28650[(7)]);
var inst_28607 = (state_28650[(8)]);
var inst_28596 = (state_28650[(9)]);
var inst_28604 = cljs.core.seq(inst_28596);
var inst_28605__$1 = cljs.core.first(inst_28604);
var inst_28606 = cljs.core.next(inst_28604);
var inst_28607__$1 = (inst_28605__$1 == null);
var state_28650__$1 = (function (){var statearr_28662 = state_28650;
(statearr_28662[(7)] = inst_28605__$1);

(statearr_28662[(8)] = inst_28607__$1);

(statearr_28662[(10)] = inst_28606);

return statearr_28662;
})();
if(cljs.core.truth_(inst_28607__$1)){
var statearr_28663_28702 = state_28650__$1;
(statearr_28663_28702[(1)] = (8));

} else {
var statearr_28664_28703 = state_28650__$1;
(statearr_28664_28703[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (17))){
var inst_28605 = (state_28650[(7)]);
var inst_28625 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_28605);
var state_28650__$1 = state_28650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28650__$1,(20),inst_28625);
} else {
if((state_val_28651 === (3))){
var inst_28648 = (state_28650[(2)]);
var state_28650__$1 = state_28650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28650__$1,inst_28648);
} else {
if((state_val_28651 === (12))){
var inst_28598 = (state_28650[(11)]);
var inst_28613 = (inst_28598 >= subject_limit);
var state_28650__$1 = state_28650;
var statearr_28665_28704 = state_28650__$1;
(statearr_28665_28704[(2)] = inst_28613);

(statearr_28665_28704[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (2))){
var _ = (function (){var statearr_28666 = state_28650;
(statearr_28666[(4)] = cljs.core.cons((5),(state_28650[(4)])));

return statearr_28666;
})();
var inst_28589 = subject_groups;
var inst_28590 = cljs.core.seq(inst_28589);
var inst_28591 = cljs.core.first(inst_28590);
var inst_28592 = cljs.core.next(inst_28590);
var inst_28593 = flake_start;
var inst_28594 = subject_start;
var inst_28595 = cljs.core.PersistentVector.EMPTY;
var inst_28596 = inst_28589;
var inst_28597 = inst_28593;
var inst_28598 = inst_28594;
var inst_28599 = inst_28595;
var state_28650__$1 = (function (){var statearr_28667 = state_28650;
(statearr_28667[(12)] = inst_28592);

(statearr_28667[(13)] = inst_28591);

(statearr_28667[(14)] = inst_28599);

(statearr_28667[(9)] = inst_28596);

(statearr_28667[(11)] = inst_28598);

(statearr_28667[(15)] = inst_28597);

return statearr_28667;
})();
var statearr_28668_28705 = state_28650__$1;
(statearr_28668_28705[(2)] = null);

(statearr_28668_28705[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (23))){
var inst_28631 = (state_28650[(16)]);
var inst_28632 = (state_28650[(17)]);
var inst_28606 = (state_28650[(10)]);
var inst_28599 = (state_28650[(14)]);
var inst_28598 = (state_28650[(11)]);
var inst_28597 = (state_28650[(15)]);
var inst_28637 = (state_28650[(2)]);
var inst_28638 = (inst_28597 + inst_28632);
var inst_28639 = (inst_28598 + inst_28637);
var inst_28640 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28599,inst_28631);
var inst_28596 = inst_28606;
var inst_28597__$1 = inst_28638;
var inst_28598__$1 = inst_28639;
var inst_28599__$1 = inst_28640;
var state_28650__$1 = (function (){var statearr_28669 = state_28650;
(statearr_28669[(14)] = inst_28599__$1);

(statearr_28669[(9)] = inst_28596);

(statearr_28669[(11)] = inst_28598__$1);

(statearr_28669[(15)] = inst_28597__$1);

return statearr_28669;
})();
var statearr_28670_28706 = state_28650__$1;
(statearr_28670_28706[(2)] = null);

(statearr_28670_28706[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (19))){
var inst_28631 = (state_28650[(16)]);
var inst_28632 = (state_28650[(17)]);
var inst_28631__$1 = (state_28650[(2)]);
var inst_28632__$1 = cljs.core.count(inst_28631__$1);
var inst_28633 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_28632__$1);
var state_28650__$1 = (function (){var statearr_28671 = state_28650;
(statearr_28671[(16)] = inst_28631__$1);

(statearr_28671[(17)] = inst_28632__$1);

return statearr_28671;
})();
if(inst_28633){
var statearr_28672_28707 = state_28650__$1;
(statearr_28672_28707[(1)] = (21));

} else {
var statearr_28673_28708 = state_28650__$1;
(statearr_28673_28708[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (11))){
var inst_28610 = (state_28650[(18)]);
var state_28650__$1 = state_28650;
var statearr_28675_28709 = state_28650__$1;
(statearr_28675_28709[(2)] = inst_28610);

(statearr_28675_28709[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (9))){
var inst_28610 = (state_28650[(18)]);
var inst_28597 = (state_28650[(15)]);
var inst_28610__$1 = (inst_28597 >= flake_limit);
var state_28650__$1 = (function (){var statearr_28676 = state_28650;
(statearr_28676[(18)] = inst_28610__$1);

return statearr_28676;
})();
if(cljs.core.truth_(inst_28610__$1)){
var statearr_28677_28710 = state_28650__$1;
(statearr_28677_28710[(1)] = (11));

} else {
var statearr_28678_28711 = state_28650__$1;
(statearr_28678_28711[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (5))){
var _ = (function (){var statearr_28679 = state_28650;
(statearr_28679[(4)] = cljs.core.rest((state_28650[(4)])));

return statearr_28679;
})();
var state_28650__$1 = state_28650;
var ex28674 = (state_28650__$1[(2)]);
var statearr_28680_28712 = state_28650__$1;
(statearr_28680_28712[(5)] = ex28674);


if((ex28674 instanceof Error)){
var statearr_28681_28713 = state_28650__$1;
(statearr_28681_28713[(1)] = (4));

(statearr_28681_28713[(5)] = null);

} else {
throw ex28674;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (14))){
var inst_28599 = (state_28650[(14)]);
var inst_28598 = (state_28650[(11)]);
var inst_28597 = (state_28650[(15)]);
var inst_28619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28620 = [inst_28597,inst_28598,inst_28599];
var inst_28621 = (new cljs.core.PersistentVector(null,3,(5),inst_28619,inst_28620,null));
var state_28650__$1 = state_28650;
var statearr_28682_28714 = state_28650__$1;
(statearr_28682_28714[(2)] = inst_28621);

(statearr_28682_28714[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (16))){
var inst_28643 = (state_28650[(2)]);
var state_28650__$1 = state_28650;
var statearr_28683_28715 = state_28650__$1;
(statearr_28683_28715[(2)] = inst_28643);

(statearr_28683_28715[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (10))){
var inst_28617 = (state_28650[(2)]);
var state_28650__$1 = state_28650;
if(cljs.core.truth_(inst_28617)){
var statearr_28684_28716 = state_28650__$1;
(statearr_28684_28716[(1)] = (14));

} else {
var statearr_28685_28717 = state_28650__$1;
(statearr_28685_28717[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (18))){
var inst_28605 = (state_28650[(7)]);
var state_28650__$1 = state_28650;
var statearr_28686_28718 = state_28650__$1;
(statearr_28686_28718[(2)] = inst_28605);

(statearr_28686_28718[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28651 === (8))){
var inst_28607 = (state_28650[(8)]);
var state_28650__$1 = state_28650;
var statearr_28687_28719 = state_28650__$1;
(statearr_28687_28719[(2)] = inst_28607);

(statearr_28687_28719[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto____0 = (function (){
var statearr_28688 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28688[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto__);

(statearr_28688[(1)] = (1));

return statearr_28688;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto____1 = (function (state_28650){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_28650);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e28689){var ex__14781__auto__ = e28689;
var statearr_28690_28720 = state_28650;
(statearr_28690_28720[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_28650[(4)]))){
var statearr_28691_28721 = state_28650;
(statearr_28691_28721[(1)] = cljs.core.first((state_28650[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__28722 = state_28650;
state_28650 = G__28722;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto__ = function(state_28650){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto____1.call(this,state_28650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_28692 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_28692[(6)] = c__14852__auto__);

return statearr_28692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_28768){
var state_val_28769 = (state_28768[(1)]);
if((state_val_28769 === (7))){
var state_28768__$1 = state_28768;
var statearr_28770_28808 = state_28768__$1;
(statearr_28770_28808[(2)] = null);

(statearr_28770_28808[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (20))){
var inst_28754 = (state_28768[(2)]);
var inst_28755 = fluree.db.util.async.throw_err(inst_28754);
var inst_28733 = inst_28755;
var state_28768__$1 = (function (){var statearr_28771 = state_28768;
(statearr_28771[(7)] = inst_28733);

return statearr_28771;
})();
var statearr_28772_28809 = state_28768__$1;
(statearr_28772_28809[(2)] = null);

(statearr_28772_28809[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (1))){
var state_28768__$1 = state_28768;
var statearr_28773_28810 = state_28768__$1;
(statearr_28773_28810[(2)] = null);

(statearr_28773_28810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (4))){
var inst_28723 = (state_28768[(2)]);
var state_28768__$1 = state_28768;
var statearr_28774_28811 = state_28768__$1;
(statearr_28774_28811[(2)] = inst_28723);

(statearr_28774_28811[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (15))){
var inst_28733 = (state_28768[(7)]);
var inst_28750 = (state_28768[(8)]);
var inst_28750__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_28733);
var state_28768__$1 = (function (){var statearr_28775 = state_28768;
(statearr_28775[(8)] = inst_28750__$1);

return statearr_28775;
})();
if(cljs.core.truth_(inst_28750__$1)){
var statearr_28776_28812 = state_28768__$1;
(statearr_28776_28812[(1)] = (17));

} else {
var statearr_28777_28813 = state_28768__$1;
(statearr_28777_28813[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (13))){
var inst_28743 = (state_28768[(2)]);
var inst_28744 = fluree.db.util.async.throw_err(inst_28743);
var _ = (function (){var statearr_28778 = state_28768;
(statearr_28778[(4)] = cljs.core.rest((state_28768[(4)])));

return statearr_28778;
})();
var state_28768__$1 = state_28768;
var statearr_28779_28814 = state_28768__$1;
(statearr_28779_28814[(2)] = inst_28744);

(statearr_28779_28814[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (6))){
var inst_28731 = (state_28768[(2)]);
var inst_28732 = fluree.db.util.async.throw_err(inst_28731);
var inst_28733 = inst_28732;
var state_28768__$1 = (function (){var statearr_28780 = state_28768;
(statearr_28780[(7)] = inst_28733);

return statearr_28780;
})();
var statearr_28781_28815 = state_28768__$1;
(statearr_28781_28815[(2)] = null);

(statearr_28781_28815[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (17))){
var inst_28750 = (state_28768[(8)]);
var inst_28752 = fluree.db.dbproto._lookup_leaf(root_node,inst_28750);
var state_28768__$1 = state_28768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28768__$1,(20),inst_28752);
} else {
if((state_val_28769 === (3))){
var inst_28766 = (state_28768[(2)]);
var state_28768__$1 = state_28768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28768__$1,inst_28766);
} else {
if((state_val_28769 === (12))){
var _ = (function (){var statearr_28783 = state_28768;
(statearr_28783[(4)] = cljs.core.rest((state_28768[(4)])));

return statearr_28783;
})();
var state_28768__$1 = state_28768;
var ex28782 = (state_28768__$1[(2)]);
var statearr_28784_28816 = state_28768__$1;
(statearr_28784_28816[(5)] = ex28782);


var statearr_28785_28817 = state_28768__$1;
(statearr_28785_28817[(1)] = (11));

(statearr_28785_28817[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (2))){
var _ = (function (){var statearr_28786 = state_28768;
(statearr_28786[(4)] = cljs.core.cons((5),(state_28768[(4)])));

return statearr_28786;
})();
var inst_28729 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_28768__$1 = state_28768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28768__$1,(6),inst_28729);
} else {
if((state_val_28769 === (19))){
var inst_28759 = (state_28768[(2)]);
var state_28768__$1 = state_28768;
var statearr_28787_28818 = state_28768__$1;
(statearr_28787_28818[(2)] = inst_28759);

(statearr_28787_28818[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (11))){
var inst_28735 = (state_28768[(2)]);
var state_28768__$1 = (function (){var statearr_28789 = state_28768;
(statearr_28789[(9)] = inst_28735);

return statearr_28789;
})();
var statearr_28790_28819 = state_28768__$1;
(statearr_28790_28819[(2)] = null);

(statearr_28790_28819[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (9))){
var inst_28733 = (state_28768[(7)]);
var _ = (function (){var statearr_28791 = state_28768;
(statearr_28791[(4)] = cljs.core.cons((12),(state_28768[(4)])));

return statearr_28791;
})();
var inst_28741 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_28733,t,novelty,fast_forward_db_QMARK_);
var state_28768__$1 = state_28768;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28768__$1,(13),inst_28741);
} else {
if((state_val_28769 === (5))){
var _ = (function (){var statearr_28792 = state_28768;
(statearr_28792[(4)] = cljs.core.rest((state_28768[(4)])));

return statearr_28792;
})();
var state_28768__$1 = state_28768;
var ex28788 = (state_28768__$1[(2)]);
var statearr_28793_28820 = state_28768__$1;
(statearr_28793_28820[(5)] = ex28788);


if((ex28788 instanceof Error)){
var statearr_28794_28821 = state_28768__$1;
(statearr_28794_28821[(1)] = (4));

(statearr_28794_28821[(5)] = null);

} else {
throw ex28788;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (14))){
var inst_28747 = (state_28768[(10)]);
var state_28768__$1 = state_28768;
var statearr_28795_28822 = state_28768__$1;
(statearr_28795_28822[(2)] = inst_28747);

(statearr_28795_28822[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (16))){
var inst_28761 = (state_28768[(2)]);
var state_28768__$1 = state_28768;
var statearr_28796_28823 = state_28768__$1;
(statearr_28796_28823[(2)] = inst_28761);

(statearr_28796_28823[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (10))){
var inst_28747 = (state_28768[(10)]);
var inst_28747__$1 = (state_28768[(2)]);
var state_28768__$1 = (function (){var statearr_28797 = state_28768;
(statearr_28797[(10)] = inst_28747__$1);

return statearr_28797;
})();
if(cljs.core.truth_(inst_28747__$1)){
var statearr_28798_28824 = state_28768__$1;
(statearr_28798_28824[(1)] = (14));

} else {
var statearr_28799_28825 = state_28768__$1;
(statearr_28799_28825[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (18))){
var state_28768__$1 = state_28768;
var statearr_28800_28826 = state_28768__$1;
(statearr_28800_28826[(2)] = null);

(statearr_28800_28826[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28769 === (8))){
var inst_28763 = (state_28768[(2)]);
var _ = (function (){var statearr_28801 = state_28768;
(statearr_28801[(4)] = cljs.core.rest((state_28768[(4)])));

return statearr_28801;
})();
var state_28768__$1 = state_28768;
var statearr_28802_28827 = state_28768__$1;
(statearr_28802_28827[(2)] = inst_28763);

(statearr_28802_28827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto____0 = (function (){
var statearr_28803 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28803[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto__);

(statearr_28803[(1)] = (1));

return statearr_28803;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto____1 = (function (state_28768){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_28768);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e28804){var ex__14781__auto__ = e28804;
var statearr_28805_28828 = state_28768;
(statearr_28805_28828[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_28768[(4)]))){
var statearr_28806_28829 = state_28768;
(statearr_28806_28829[(1)] = cljs.core.first((state_28768[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__28830 = state_28768;
state_28768 = G__28830;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto__ = function(state_28768){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto____1.call(this,state_28768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_28807 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_28807[(6)] = c__14852__auto__);

return statearr_28807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__28837 = arguments.length;
switch (G__28837) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__28838 = (function (){var pred__28841 = cljs.core.identical_QMARK_;
var expr__28842 = test;
if(cljs.core.truth_((pred__28841.cljs$core$IFn$_invoke$arity$2 ? pred__28841.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__28842) : pred__28841.call(null,cljs.core._EQ_,expr__28842)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28841.cljs$core$IFn$_invoke$arity$2 ? pred__28841.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__28842) : pred__28841.call(null,cljs.core._LT_,expr__28842)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__28841.cljs$core$IFn$_invoke$arity$2 ? pred__28841.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__28842) : pred__28841.call(null,cljs.core._LT__EQ_,expr__28842)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28841.cljs$core$IFn$_invoke$arity$2 ? pred__28841.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__28842) : pred__28841.call(null,cljs.core._GT_,expr__28842)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__28841.cljs$core$IFn$_invoke$arity$2 ? pred__28841.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__28842) : pred__28841.call(null,cljs.core._GT__EQ_,expr__28842)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__28842)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28838,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28838,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28838,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28838,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_29214){
var state_val_29215 = (state_29214[(1)]);
if((state_val_29215 === (121))){
var inst_29170 = (state_29214[(7)]);
var state_29214__$1 = state_29214;
var statearr_29216_29412 = state_29214__$1;
(statearr_29216_29412[(2)] = inst_29170);

(statearr_29216_29412[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (65))){
var inst_29022 = (state_29214[(8)]);
var inst_29028 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29217 = state_29214;
(statearr_29217[(9)] = inst_29028);

return statearr_29217;
})();
if(cljs.core.truth_(inst_29022)){
var statearr_29218_29413 = state_29214__$1;
(statearr_29218_29413[(1)] = (66));

} else {
var statearr_29219_29414 = state_29214__$1;
(statearr_29219_29414[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (70))){
var inst_29206 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29220_29415 = state_29214__$1;
(statearr_29220_29415[(2)] = inst_29206);

(statearr_29220_29415[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (62))){
var inst_29021 = (state_29214[(2)]);
var inst_29022 = fluree.db.util.async.throw_err(inst_29021);
var inst_29023 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29214__$1 = (function (){var statearr_29221 = state_29214;
(statearr_29221[(8)] = inst_29022);

return statearr_29221;
})();
if(cljs.core.truth_(inst_29023)){
var statearr_29222_29416 = state_29214__$1;
(statearr_29222_29416[(1)] = (63));

} else {
var statearr_29223_29417 = state_29214__$1;
(statearr_29223_29417[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (74))){
var inst_28864 = (state_29214[(10)]);
var inst_29034 = (state_29214[(11)]);
var inst_28869 = (state_29214[(12)]);
var inst_29001 = (state_29214[(13)]);
var inst_28963 = (state_29214[(14)]);
var inst_29018 = (state_29214[(15)]);
var inst_29035 = (state_29214[(16)]);
var inst_28994 = (state_29214[(17)]);
var inst_29008 = (state_29214[(18)]);
var inst_29022 = (state_29214[(8)]);
var inst_28900 = (state_29214[(19)]);
var inst_29031 = (state_29214[(20)]);
var inst_28871 = (state_29214[(21)]);
var inst_28891 = (state_29214[(22)]);
var inst_29007 = (state_29214[(23)]);
var inst_28879 = (state_29214[(24)]);
var inst_28881 = (state_29214[(25)]);
var inst_28991 = (state_29214[(26)]);
var inst_29041 = (state_29214[(27)]);
var inst_29049 = (state_29214[(28)]);
var inst_28932 = (state_29214[(29)]);
var inst_29002 = (state_29214[(30)]);
var inst_28876 = (state_29214[(31)]);
var inst_28972 = (state_29214[(32)]);
var inst_28945 = (state_29214[(33)]);
var inst_29032 = (state_29214[(34)]);
var inst_28995 = (state_29214[(35)]);
var inst_28936 = (state_29214[(36)]);
var inst_29013 = (state_29214[(37)]);
var inst_29028 = (state_29214[(9)]);
var inst_28954 = (state_29214[(38)]);
var inst_28933 = (state_29214[(39)]);
var inst_28992 = (state_29214[(40)]);
var inst_28990 = (state_29214[(41)]);
var inst_29012 = (state_29214[(42)]);
var inst_29003 = (state_29214[(43)]);
var inst_29033 = (state_29214[(44)]);
var inst_28875 = (state_29214[(45)]);
var inst_28880 = (state_29214[(46)]);
var inst_28868 = (state_29214[(47)]);
var inst_28981 = (state_29214[(48)]);
var inst_29051 = (function (){var no_filter_QMARK_ = inst_29028;
var t = inst_29008;
var max_limit_QMARK_ = inst_29002;
var next_node = inst_29031;
var fast_forward_db_QMARK_ = inst_29013;
var s1 = inst_28891;
var o2 = inst_28954;
var t1 = inst_28868;
var predicate_fn = inst_28881;
var i = inst_29033;
var vec__28857 = inst_28932;
var m1 = inst_28981;
var root_node = inst_29018;
var vec__28853 = inst_28871;
var s2 = inst_28900;
var vec__28850 = inst_28864;
var p2 = inst_28972;
var map__28863 = inst_28994;
var permissions = inst_29003;
var G__29042 = inst_29049;
var limit = inst_29001;
var start_flake = inst_28991;
var flake_limit = inst_28995;
var offset = inst_29032;
var map__28856 = inst_28879;
var acc = inst_29035;
var t2 = inst_28875;
var op1 = inst_28869;
var o1 = inst_28945;
var vec__28860 = inst_28933;
var end_flake = inst_28992;
var base_result = inst_29041;
var s = inst_29034;
var node_start = inst_29022;
var p1 = inst_28963;
var subject_fn = inst_28880;
var object_fn = inst_28936;
var idx_compare = inst_29007;
var op2 = inst_28876;
var m2 = inst_28990;
var novelty = inst_29012;
return (function (p1__28832_SHARP_){
var G__29224 = p1__28832_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__29224) : subject_fn.call(null,G__29224));
});
})();
var inst_29052 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29051,inst_29049);
var state_29214__$1 = state_29214;
var statearr_29225_29418 = state_29214__$1;
(statearr_29225_29418[(2)] = inst_29052);

(statearr_29225_29418[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (110))){
var inst_29183 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29226_29419 = state_29214__$1;
(statearr_29226_29419[(2)] = inst_29183);

(statearr_29226_29419[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (7))){
var inst_28865 = (state_29214[(49)]);
var state_29214__$1 = state_29214;
var statearr_29227_29420 = state_29214__$1;
(statearr_29227_29420[(2)] = inst_28865);

(statearr_29227_29420[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (59))){
var state_29214__$1 = state_29214;
var statearr_29228_29421 = state_29214__$1;
(statearr_29228_29421[(2)] = fluree.db.util.core.max_long);

(statearr_29228_29421[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (86))){
var inst_29028 = (state_29214[(9)]);
var state_29214__$1 = state_29214;
var statearr_29229_29422 = state_29214__$1;
(statearr_29229_29422[(2)] = inst_29028);

(statearr_29229_29422[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (20))){
var state_29214__$1 = state_29214;
var statearr_29230_29423 = state_29214__$1;
(statearr_29230_29423[(2)] = null);

(statearr_29230_29423[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (72))){
var inst_29041 = (state_29214[(27)]);
var state_29214__$1 = state_29214;
var statearr_29231_29424 = state_29214__$1;
(statearr_29231_29424[(2)] = inst_29041);

(statearr_29231_29424[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (58))){
var inst_28996 = (state_29214[(50)]);
var state_29214__$1 = state_29214;
var statearr_29232_29425 = state_29214__$1;
(statearr_29232_29425[(2)] = inst_28996);

(statearr_29232_29425[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (60))){
var inst_29001 = (state_29214[(13)]);
var inst_29001__$1 = (state_29214[(2)]);
var inst_29002 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29001__$1,fluree.db.util.core.max_long);
var inst_29003 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_29004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29005 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_29006 = (new cljs.core.PersistentVector(null,3,(5),inst_29004,inst_29005,null));
var inst_29007 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29006);
var inst_29008 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_29009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29010 = [cljs.core.cst$kw$novelty,idx];
var inst_29011 = (new cljs.core.PersistentVector(null,2,(5),inst_29009,inst_29010,null));
var inst_29012 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29011);
var inst_29013 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_29014 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_29015 = fluree.db.dbproto._resolve(inst_29014);
var state_29214__$1 = (function (){var statearr_29233 = state_29214;
(statearr_29233[(13)] = inst_29001__$1);

(statearr_29233[(18)] = inst_29008);

(statearr_29233[(23)] = inst_29007);

(statearr_29233[(30)] = inst_29002);

(statearr_29233[(37)] = inst_29013);

(statearr_29233[(42)] = inst_29012);

(statearr_29233[(43)] = inst_29003);

return statearr_29233;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(61),inst_29015);
} else {
if((state_val_29215 === (27))){
var inst_28934 = (state_29214[(51)]);
var state_29214__$1 = state_29214;
var statearr_29234_29426 = state_29214__$1;
(statearr_29234_29426[(2)] = inst_28934);

(statearr_29234_29426[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (1))){
var state_29214__$1 = state_29214;
var statearr_29235_29427 = state_29214__$1;
(statearr_29235_29427[(2)] = null);

(statearr_29235_29427[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (69))){
var inst_29031 = (state_29214[(20)]);
var inst_28991 = (state_29214[(26)]);
var inst_28992 = (state_29214[(40)]);
var inst_29040 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_29031);
var inst_29041 = fluree.db.flake.subrange(inst_29040,start_test,inst_28991,end_test,inst_28992);
var inst_29043 = fluree.db.query.range.value_with_nil_pred(idx,inst_28991,inst_28992);
var state_29214__$1 = (function (){var statearr_29236 = state_29214;
(statearr_29236[(27)] = inst_29041);

return statearr_29236;
})();
if(inst_29043){
var statearr_29237_29428 = state_29214__$1;
(statearr_29237_29428[(1)] = (71));

} else {
var statearr_29238_29429 = state_29214__$1;
(statearr_29238_29429[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (101))){
var inst_29127 = (state_29214[(52)]);
var inst_29128 = (state_29214[(53)]);
var inst_29129 = (state_29214[(54)]);
var inst_28995 = (state_29214[(35)]);
var inst_29132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29133 = (inst_29129 - inst_28995);
var inst_29134 = (inst_29128 - inst_29133);
var inst_29135 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_29134,inst_29127);
var inst_29136 = [inst_28995,inst_29135];
var inst_29137 = (new cljs.core.PersistentVector(null,2,(5),inst_29132,inst_29136,null));
var state_29214__$1 = state_29214;
var statearr_29239_29430 = state_29214__$1;
(statearr_29239_29430[(2)] = inst_29137);

(statearr_29239_29430[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (24))){
var inst_28867 = (state_29214[(55)]);
var inst_28864 = (state_29214[(10)]);
var inst_28869 = (state_29214[(12)]);
var inst_28870 = (state_29214[(56)]);
var inst_28914 = (state_29214[(57)]);
var inst_28900 = (state_29214[(19)]);
var inst_28871 = (state_29214[(21)]);
var inst_28891 = (state_29214[(22)]);
var inst_28879 = (state_29214[(24)]);
var inst_28877 = (state_29214[(58)]);
var inst_28866 = (state_29214[(59)]);
var inst_28881 = (state_29214[(25)]);
var inst_28873 = (state_29214[(60)]);
var inst_28882 = (state_29214[(61)]);
var inst_28874 = (state_29214[(62)]);
var inst_28876 = (state_29214[(31)]);
var inst_28875 = (state_29214[(45)]);
var inst_28880 = (state_29214[(46)]);
var inst_28868 = (state_29214[(47)]);
var inst_28924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28926 = [null,null];
var inst_28927 = (new cljs.core.PersistentVector(null,2,(5),inst_28925,inst_28926,null));
var inst_28928 = (function (){var bool = inst_28914;
var s1 = inst_28891;
var o2 = inst_28874;
var t1 = inst_28868;
var predicate_fn = inst_28881;
var m1 = inst_28870;
var vec__28853 = inst_28871;
var s2 = inst_28900;
var vec__28850 = inst_28864;
var p2 = inst_28873;
var map__28856 = inst_28879;
var t2 = inst_28875;
var op1 = inst_28869;
var o1 = inst_28867;
var p1 = inst_28866;
var subject_fn = inst_28880;
var object_fn = inst_28882;
var op2 = inst_28876;
var m2 = inst_28877;
var temp__5755__auto__ = inst_28914;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_28929 = [inst_28927,inst_28928];
var inst_28930 = (new cljs.core.PersistentVector(null,2,(5),inst_28924,inst_28929,null));
var state_29214__$1 = state_29214;
var statearr_29240_29431 = state_29214__$1;
(statearr_29240_29431[(2)] = inst_28930);

(statearr_29240_29431[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (102))){
var inst_29127 = (state_29214[(52)]);
var inst_29129 = (state_29214[(54)]);
var inst_29139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29140 = [inst_29129,inst_29127];
var inst_29141 = (new cljs.core.PersistentVector(null,2,(5),inst_29139,inst_29140,null));
var state_29214__$1 = state_29214;
var statearr_29241_29432 = state_29214__$1;
(statearr_29241_29432[(2)] = inst_29141);

(statearr_29241_29432[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (55))){
var state_29214__$1 = state_29214;
var statearr_29242_29433 = state_29214__$1;
(statearr_29242_29433[(2)] = (2147483647));

(statearr_29242_29433[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (85))){
var inst_29077 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
if(cljs.core.truth_(inst_29077)){
var statearr_29243_29434 = state_29214__$1;
(statearr_29243_29434[(1)] = (89));

} else {
var statearr_29244_29435 = state_29214__$1;
(statearr_29244_29435[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (39))){
var inst_28964 = (state_29214[(63)]);
var inst_28873 = (state_29214[(60)]);
var inst_28963 = (state_29214[(2)]);
var inst_28964__$1 = (inst_28873 == null);
var state_29214__$1 = (function (){var statearr_29245 = state_29214;
(statearr_29245[(14)] = inst_28963);

(statearr_29245[(63)] = inst_28964__$1);

return statearr_29245;
})();
if(cljs.core.truth_(inst_28964__$1)){
var statearr_29246_29436 = state_29214__$1;
(statearr_29246_29436[(1)] = (40));

} else {
var statearr_29247_29437 = state_29214__$1;
(statearr_29247_29437[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (88))){
var inst_29074 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29248_29438 = state_29214__$1;
(statearr_29248_29438[(2)] = inst_29074);

(statearr_29248_29438[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (46))){
var inst_28870 = (state_29214[(56)]);
var state_29214__$1 = state_29214;
var statearr_29249_29439 = state_29214__$1;
(statearr_29249_29439[(2)] = inst_28870);

(statearr_29249_29439[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (4))){
var inst_28844 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29250_29440 = state_29214__$1;
(statearr_29250_29440[(2)] = inst_28844);

(statearr_29250_29440[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (77))){
var inst_28864 = (state_29214[(10)]);
var inst_29034 = (state_29214[(11)]);
var inst_28869 = (state_29214[(12)]);
var inst_29001 = (state_29214[(13)]);
var inst_28963 = (state_29214[(14)]);
var inst_29018 = (state_29214[(15)]);
var inst_29035 = (state_29214[(16)]);
var inst_28994 = (state_29214[(17)]);
var inst_29008 = (state_29214[(18)]);
var inst_29022 = (state_29214[(8)]);
var inst_28900 = (state_29214[(19)]);
var inst_29031 = (state_29214[(20)]);
var inst_28871 = (state_29214[(21)]);
var inst_28891 = (state_29214[(22)]);
var inst_29007 = (state_29214[(23)]);
var inst_28879 = (state_29214[(24)]);
var inst_28881 = (state_29214[(25)]);
var inst_28991 = (state_29214[(26)]);
var inst_29041 = (state_29214[(27)]);
var inst_28932 = (state_29214[(29)]);
var inst_29002 = (state_29214[(30)]);
var inst_28876 = (state_29214[(31)]);
var inst_28972 = (state_29214[(32)]);
var inst_28945 = (state_29214[(33)]);
var inst_29032 = (state_29214[(34)]);
var inst_28995 = (state_29214[(35)]);
var inst_28936 = (state_29214[(36)]);
var inst_29013 = (state_29214[(37)]);
var inst_29028 = (state_29214[(9)]);
var inst_28954 = (state_29214[(38)]);
var inst_28933 = (state_29214[(39)]);
var inst_29055 = (state_29214[(64)]);
var inst_28992 = (state_29214[(40)]);
var inst_28990 = (state_29214[(41)]);
var inst_29012 = (state_29214[(42)]);
var inst_29003 = (state_29214[(43)]);
var inst_29033 = (state_29214[(44)]);
var inst_28875 = (state_29214[(45)]);
var inst_28880 = (state_29214[(46)]);
var inst_28868 = (state_29214[(47)]);
var inst_28981 = (state_29214[(48)]);
var inst_29057 = (function (){var no_filter_QMARK_ = inst_29028;
var t = inst_29008;
var max_limit_QMARK_ = inst_29002;
var next_node = inst_29031;
var fast_forward_db_QMARK_ = inst_29013;
var s1 = inst_28891;
var o2 = inst_28954;
var t1 = inst_28868;
var predicate_fn = inst_28881;
var i = inst_29033;
var vec__28857 = inst_28932;
var m1 = inst_28981;
var root_node = inst_29018;
var vec__28853 = inst_28871;
var s2 = inst_28900;
var vec__28850 = inst_28864;
var p2 = inst_28972;
var map__28863 = inst_28994;
var permissions = inst_29003;
var G__29042 = inst_29055;
var limit = inst_29001;
var start_flake = inst_28991;
var flake_limit = inst_28995;
var offset = inst_29032;
var map__28856 = inst_28879;
var acc = inst_29035;
var t2 = inst_28875;
var op1 = inst_28869;
var o1 = inst_28945;
var vec__28860 = inst_28933;
var end_flake = inst_28992;
var base_result = inst_29041;
var s = inst_29034;
var node_start = inst_29022;
var p1 = inst_28963;
var subject_fn = inst_28880;
var object_fn = inst_28936;
var idx_compare = inst_29007;
var op2 = inst_28876;
var m2 = inst_28990;
var novelty = inst_29012;
return (function (p1__28833_SHARP_){
var G__29251 = p1__28833_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__29251) : predicate_fn.call(null,G__29251));
});
})();
var inst_29058 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29057,inst_29055);
var state_29214__$1 = state_29214;
var statearr_29252_29441 = state_29214__$1;
(statearr_29252_29441[(2)] = inst_29058);

(statearr_29252_29441[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (106))){
var inst_29068 = (state_29214[(65)]);
var state_29214__$1 = state_29214;
var statearr_29253_29442 = state_29214__$1;
(statearr_29253_29442[(2)] = inst_29068);

(statearr_29253_29442[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (119))){
var inst_29186 = (state_29214[(66)]);
var state_29214__$1 = state_29214;
var statearr_29254_29443 = state_29214__$1;
(statearr_29254_29443[(2)] = inst_29186);

(statearr_29254_29443[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (95))){
var inst_29034 = (state_29214[(11)]);
var inst_29109 = (state_29214[(67)]);
var inst_29001 = (state_29214[(13)]);
var inst_29110 = (state_29214[(68)]);
var inst_29101 = (state_29214[(69)]);
var inst_29111 = (state_29214[(70)]);
var inst_29109__$1 = cljs.core.count(inst_29101);
var inst_29110__$1 = (inst_29034 + inst_29109__$1);
var inst_29111__$1 = (inst_29110__$1 - inst_29001);
var inst_29112 = cljs.core.pos_int_QMARK_(inst_29111__$1);
var state_29214__$1 = (function (){var statearr_29255 = state_29214;
(statearr_29255[(67)] = inst_29109__$1);

(statearr_29255[(68)] = inst_29110__$1);

(statearr_29255[(70)] = inst_29111__$1);

return statearr_29255;
})();
if(inst_29112){
var statearr_29256_29444 = state_29214__$1;
(statearr_29256_29444[(1)] = (98));

} else {
var statearr_29257_29445 = state_29214__$1;
(statearr_29257_29445[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (54))){
var inst_28869 = (state_29214[(12)]);
var inst_28996 = (state_29214[(50)]);
var inst_28963 = (state_29214[(14)]);
var inst_28994 = (state_29214[(17)]);
var inst_28900 = (state_29214[(19)]);
var inst_28891 = (state_29214[(22)]);
var inst_28876 = (state_29214[(31)]);
var inst_28972 = (state_29214[(32)]);
var inst_28945 = (state_29214[(33)]);
var inst_28954 = (state_29214[(38)]);
var inst_28990 = (state_29214[(41)]);
var inst_28875 = (state_29214[(45)]);
var inst_28868 = (state_29214[(47)]);
var inst_28981 = (state_29214[(48)]);
var inst_28990__$1 = (state_29214[(2)]);
var inst_28991 = fluree.db.flake.__GT_Flake(inst_28891,inst_28963,inst_28945,inst_28868,inst_28869,inst_28981);
var inst_28992 = fluree.db.flake.__GT_Flake(inst_28900,inst_28972,inst_28954,inst_28875,inst_28876,inst_28990__$1);
var inst_28993 = opts;
var inst_28994__$1 = cljs.core.__destructure_map(inst_28993);
var inst_28995 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_28994__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_28996__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28994__$1,cljs.core.cst$kw$limit);
var inst_28997 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_28994__$1,cljs.core.cst$kw$offset,(0));
var state_29214__$1 = (function (){var statearr_29258 = state_29214;
(statearr_29258[(50)] = inst_28996__$1);

(statearr_29258[(17)] = inst_28994__$1);

(statearr_29258[(26)] = inst_28991);

(statearr_29258[(71)] = inst_28997);

(statearr_29258[(35)] = inst_28995);

(statearr_29258[(40)] = inst_28992);

(statearr_29258[(41)] = inst_28990__$1);

return statearr_29258;
})();
if(cljs.core.truth_(inst_28996__$1)){
var statearr_29259_29446 = state_29214__$1;
(statearr_29259_29446[(1)] = (58));

} else {
var statearr_29260_29447 = state_29214__$1;
(statearr_29260_29447[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (92))){
var inst_29034 = (state_29214[(11)]);
var inst_29035 = (state_29214[(16)]);
var inst_29032 = (state_29214[(34)]);
var inst_29090 = (state_29214[(72)]);
var inst_29033 = (state_29214[(44)]);
var inst_29093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29094 = (inst_29032 - inst_29090);
var inst_29095 = [inst_29094,inst_29033,inst_29034,inst_29035];
var inst_29096 = (new cljs.core.PersistentVector(null,4,(5),inst_29093,inst_29095,null));
var state_29214__$1 = state_29214;
var statearr_29261_29448 = state_29214__$1;
(statearr_29261_29448[(2)] = inst_29096);

(statearr_29261_29448[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (104))){
var inst_29152 = (state_29214[(2)]);
var inst_29153 = fluree.db.util.async.throw_err(inst_29152);
var state_29214__$1 = state_29214;
var statearr_29262_29449 = state_29214__$1;
(statearr_29262_29449[(2)] = inst_29153);

(statearr_29262_29449[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (15))){
var inst_28874 = (state_29214[(62)]);
var inst_28904 = cljs.core.boolean_QMARK_(inst_28874);
var state_29214__$1 = state_29214;
if(inst_28904){
var statearr_29263_29450 = state_29214__$1;
(statearr_29263_29450[(1)] = (17));

} else {
var statearr_29264_29451 = state_29214__$1;
(statearr_29264_29451[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (48))){
var inst_28877 = (state_29214[(58)]);
var inst_28981 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29265 = state_29214;
(statearr_29265[(48)] = inst_28981);

return statearr_29265;
})();
if(cljs.core.truth_(inst_28877)){
var statearr_29266_29452 = state_29214__$1;
(statearr_29266_29452[(1)] = (52));

} else {
var statearr_29267_29453 = state_29214__$1;
(statearr_29267_29453[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (50))){
var state_29214__$1 = state_29214;
var statearr_29268_29454 = state_29214__$1;
(statearr_29268_29454[(2)] = (2147483647));

(statearr_29268_29454[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (116))){
var inst_29186 = (state_29214[(66)]);
var inst_29194 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29269 = state_29214;
(statearr_29269[(73)] = inst_29194);

return statearr_29269;
})();
if(cljs.core.truth_(inst_29186)){
var statearr_29270_29455 = state_29214__$1;
(statearr_29270_29455[(1)] = (118));

} else {
var statearr_29271_29456 = state_29214__$1;
(statearr_29271_29456[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (75))){
var inst_29049 = (state_29214[(28)]);
var state_29214__$1 = state_29214;
var statearr_29272_29457 = state_29214__$1;
(statearr_29272_29457[(2)] = inst_29049);

(statearr_29272_29457[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (99))){
var inst_29110 = (state_29214[(68)]);
var inst_29119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29120 = [inst_29110,inst_29110];
var inst_29121 = (new cljs.core.PersistentVector(null,2,(5),inst_29119,inst_29120,null));
var state_29214__$1 = state_29214;
var statearr_29273_29458 = state_29214__$1;
(statearr_29273_29458[(2)] = inst_29121);

(statearr_29273_29458[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (21))){
var state_29214__$1 = state_29214;
var statearr_29274_29459 = state_29214__$1;
(statearr_29274_29459[(2)] = null);

(statearr_29274_29459[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (31))){
var inst_28935 = (state_29214[(74)]);
var state_29214__$1 = state_29214;
var statearr_29275_29460 = state_29214__$1;
(statearr_29275_29460[(2)] = inst_28935);

(statearr_29275_29460[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (113))){
var inst_29180 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29276_29461 = state_29214__$1;
(statearr_29276_29461[(2)] = inst_29180);

(statearr_29276_29461[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (32))){
var inst_28955 = (state_29214[(75)]);
var inst_28866 = (state_29214[(59)]);
var inst_28954 = (state_29214[(2)]);
var inst_28955__$1 = (inst_28866 == null);
var state_29214__$1 = (function (){var statearr_29277 = state_29214;
(statearr_29277[(75)] = inst_28955__$1);

(statearr_29277[(38)] = inst_28954);

return statearr_29277;
})();
if(cljs.core.truth_(inst_28955__$1)){
var statearr_29278_29462 = state_29214__$1;
(statearr_29278_29462[(1)] = (34));

} else {
var statearr_29279_29463 = state_29214__$1;
(statearr_29279_29463[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (40))){
var inst_28954 = (state_29214[(38)]);
var state_29214__$1 = state_29214;
var statearr_29280_29464 = state_29214__$1;
(statearr_29280_29464[(2)] = inst_28954);

(statearr_29280_29464[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (91))){
var inst_29068 = (state_29214[(65)]);
var inst_29166 = (state_29214[(2)]);
var inst_29167 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29166,(0),null);
var inst_29168 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29166,(1),null);
var inst_29169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29166,(2),null);
var inst_29170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29166,(3),null);
var state_29214__$1 = (function (){var statearr_29281 = state_29214;
(statearr_29281[(76)] = inst_29167);

(statearr_29281[(77)] = inst_29168);

(statearr_29281[(7)] = inst_29170);

(statearr_29281[(78)] = inst_29169);

return statearr_29281;
})();
if(cljs.core.truth_(inst_29068)){
var statearr_29282_29465 = state_29214__$1;
(statearr_29282_29465[(1)] = (105));

} else {
var statearr_29283_29466 = state_29214__$1;
(statearr_29283_29466[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (117))){
var inst_29190 = (state_29214[(2)]);
var inst_29191 = fluree.db.util.async.throw_err(inst_29190);
var state_29214__$1 = state_29214;
var statearr_29284_29467 = state_29214__$1;
(statearr_29284_29467[(2)] = inst_29191);

(statearr_29284_29467[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (108))){
var inst_28995 = (state_29214[(35)]);
var inst_29168 = (state_29214[(77)]);
var inst_29175 = (state_29214[(79)]);
var inst_29175__$1 = (inst_29168 < inst_28995);
var state_29214__$1 = (function (){var statearr_29285 = state_29214;
(statearr_29285[(79)] = inst_29175__$1);

return statearr_29285;
})();
if(cljs.core.truth_(inst_29175__$1)){
var statearr_29286_29468 = state_29214__$1;
(statearr_29286_29468[(1)] = (111));

} else {
var statearr_29287_29469 = state_29214__$1;
(statearr_29287_29469[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (56))){
var state_29214__$1 = state_29214;
var statearr_29288_29470 = state_29214__$1;
(statearr_29288_29470[(2)] = fluree.db.util.core.min_integer);

(statearr_29288_29470[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (33))){
var inst_28950 = (state_29214[(2)]);
var inst_28951 = fluree.db.util.async.throw_err(inst_28950);
var state_29214__$1 = state_29214;
var statearr_29289_29471 = state_29214__$1;
(statearr_29289_29471[(2)] = inst_28951);

(statearr_29289_29471[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (13))){
var inst_28896 = (state_29214[(2)]);
var inst_28897 = fluree.db.util.async.throw_err(inst_28896);
var state_29214__$1 = state_29214;
var statearr_29290_29472 = state_29214__$1;
(statearr_29290_29472[(2)] = inst_28897);

(statearr_29290_29472[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (22))){
var inst_28910 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29291_29473 = state_29214__$1;
(statearr_29291_29473[(2)] = inst_28910);

(statearr_29291_29473[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (90))){
var inst_28864 = (state_29214[(10)]);
var inst_29034 = (state_29214[(11)]);
var inst_28869 = (state_29214[(12)]);
var inst_29001 = (state_29214[(13)]);
var inst_28963 = (state_29214[(14)]);
var inst_29018 = (state_29214[(15)]);
var inst_29067 = (state_29214[(80)]);
var inst_29035 = (state_29214[(16)]);
var inst_28994 = (state_29214[(17)]);
var inst_29008 = (state_29214[(18)]);
var inst_29022 = (state_29214[(8)]);
var inst_28900 = (state_29214[(19)]);
var inst_29031 = (state_29214[(20)]);
var inst_29068 = (state_29214[(65)]);
var inst_28871 = (state_29214[(21)]);
var inst_28891 = (state_29214[(22)]);
var inst_29007 = (state_29214[(23)]);
var inst_28879 = (state_29214[(24)]);
var inst_28881 = (state_29214[(25)]);
var inst_28991 = (state_29214[(26)]);
var inst_29041 = (state_29214[(27)]);
var inst_28932 = (state_29214[(29)]);
var inst_29002 = (state_29214[(30)]);
var inst_28876 = (state_29214[(31)]);
var inst_28972 = (state_29214[(32)]);
var inst_28945 = (state_29214[(33)]);
var inst_29032 = (state_29214[(34)]);
var inst_28995 = (state_29214[(35)]);
var inst_28936 = (state_29214[(36)]);
var inst_29013 = (state_29214[(37)]);
var inst_29028 = (state_29214[(9)]);
var inst_28954 = (state_29214[(38)]);
var inst_28933 = (state_29214[(39)]);
var inst_29090 = (state_29214[(72)]);
var inst_28992 = (state_29214[(40)]);
var inst_28990 = (state_29214[(41)]);
var inst_29012 = (state_29214[(42)]);
var inst_29089 = (state_29214[(81)]);
var inst_29003 = (state_29214[(43)]);
var inst_29033 = (state_29214[(44)]);
var inst_28875 = (state_29214[(45)]);
var inst_28880 = (state_29214[(46)]);
var inst_28868 = (state_29214[(47)]);
var inst_28981 = (state_29214[(48)]);
var inst_29088 = (function (){var no_filter_QMARK_ = inst_29028;
var base_result_SINGLEQUOTE_ = inst_29067;
var t = inst_29008;
var max_limit_QMARK_ = inst_29002;
var next_node = inst_29031;
var fast_forward_db_QMARK_ = inst_29013;
var s1 = inst_28891;
var o2 = inst_28954;
var t1 = inst_28868;
var predicate_fn = inst_28881;
var i = inst_29033;
var rhs = inst_29068;
var vec__28857 = inst_28932;
var m1 = inst_28981;
var root_node = inst_29018;
var vec__28853 = inst_28871;
var s2 = inst_28900;
var vec__28850 = inst_28864;
var p2 = inst_28972;
var map__28863 = inst_28994;
var permissions = inst_29003;
var limit = inst_29001;
var start_flake = inst_28991;
var flake_limit = inst_28995;
var offset = inst_29032;
var map__28856 = inst_28879;
var acc = inst_29035;
var t2 = inst_28875;
var op1 = inst_28869;
var o1 = inst_28945;
var vec__28860 = inst_28933;
var end_flake = inst_28992;
var base_result = inst_29041;
var s = inst_29034;
var node_start = inst_29022;
var p1 = inst_28963;
var subject_fn = inst_28880;
var object_fn = inst_28936;
var idx_compare = inst_29007;
var op2 = inst_28876;
var m2 = inst_28990;
var novelty = inst_29012;
return (function (p1__28835_SHARP_){
return p1__28835_SHARP_.s;
});
})();
var inst_29089__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_29088,inst_29067);
var inst_29090__$1 = cljs.core.count(inst_29089__$1);
var inst_29091 = (inst_29032 > inst_29090__$1);
var state_29214__$1 = (function (){var statearr_29292 = state_29214;
(statearr_29292[(72)] = inst_29090__$1);

(statearr_29292[(81)] = inst_29089__$1);

return statearr_29292;
})();
if(cljs.core.truth_(inst_29091)){
var statearr_29293_29474 = state_29214__$1;
(statearr_29293_29474[(1)] = (92));

} else {
var statearr_29294_29475 = state_29214__$1;
(statearr_29294_29475[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (109))){
var inst_29173 = (state_29214[(82)]);
var state_29214__$1 = state_29214;
var statearr_29295_29476 = state_29214__$1;
(statearr_29295_29476[(2)] = inst_29173);

(statearr_29295_29476[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (36))){
var inst_28959 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
if(cljs.core.truth_(inst_28959)){
var statearr_29296_29477 = state_29214__$1;
(statearr_29296_29477[(1)] = (37));

} else {
var statearr_29297_29478 = state_29214__$1;
(statearr_29297_29478[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (41))){
var inst_28964 = (state_29214[(63)]);
var state_29214__$1 = state_29214;
var statearr_29298_29479 = state_29214__$1;
(statearr_29298_29479[(2)] = inst_28964);

(statearr_29298_29479[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (118))){
var inst_29194 = (state_29214[(73)]);
var state_29214__$1 = state_29214;
var statearr_29299_29480 = state_29214__$1;
(statearr_29299_29480[(2)] = inst_29194);

(statearr_29299_29480[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (89))){
var inst_29034 = (state_29214[(11)]);
var inst_29067 = (state_29214[(80)]);
var inst_29035 = (state_29214[(16)]);
var inst_28995 = (state_29214[(35)]);
var inst_29033 = (state_29214[(44)]);
var inst_29079 = cljs.core.count(inst_29067);
var inst_29080 = (inst_28995 - inst_29033);
var inst_29081 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_29080,inst_29067);
var inst_29082 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29035,inst_29081);
var inst_29083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29084 = (inst_29033 + inst_29079);
var inst_29085 = [(0),inst_29084,inst_29034,inst_29082];
var inst_29086 = (new cljs.core.PersistentVector(null,4,(5),inst_29083,inst_29085,null));
var state_29214__$1 = state_29214;
var statearr_29300_29481 = state_29214__$1;
(statearr_29300_29481[(2)] = inst_29086);

(statearr_29300_29481[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (100))){
var inst_29127 = (state_29214[(52)]);
var inst_29128 = (state_29214[(53)]);
var inst_29129 = (state_29214[(54)]);
var inst_28995 = (state_29214[(35)]);
var inst_29101 = (state_29214[(69)]);
var inst_29033 = (state_29214[(44)]);
var inst_29123 = (state_29214[(2)]);
var inst_29124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29123,(0),null);
var inst_29125 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29123,(1),null);
var inst_29126 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_29125,inst_29101);
var inst_29127__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_29126);
var inst_29128__$1 = cljs.core.count(inst_29127__$1);
var inst_29129__$1 = (inst_29033 + inst_29128__$1);
var inst_29130 = (inst_29129__$1 > inst_28995);
var state_29214__$1 = (function (){var statearr_29301 = state_29214;
(statearr_29301[(52)] = inst_29127__$1);

(statearr_29301[(53)] = inst_29128__$1);

(statearr_29301[(54)] = inst_29129__$1);

(statearr_29301[(83)] = inst_29124);

return statearr_29301;
})();
if(cljs.core.truth_(inst_29130)){
var statearr_29302_29482 = state_29214__$1;
(statearr_29302_29482[(1)] = (101));

} else {
var statearr_29303_29483 = state_29214__$1;
(statearr_29303_29483[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (122))){
var inst_29194 = (state_29214[(73)]);
var inst_29167 = (state_29214[(76)]);
var inst_29168 = (state_29214[(77)]);
var inst_29170 = (state_29214[(7)]);
var inst_29169 = (state_29214[(78)]);
var inst_29031 = inst_29194;
var inst_29032 = inst_29167;
var inst_29033 = inst_29168;
var inst_29034 = inst_29169;
var inst_29035 = inst_29170;
var state_29214__$1 = (function (){var statearr_29304 = state_29214;
(statearr_29304[(11)] = inst_29034);

(statearr_29304[(16)] = inst_29035);

(statearr_29304[(20)] = inst_29031);

(statearr_29304[(34)] = inst_29032);

(statearr_29304[(44)] = inst_29033);

return statearr_29304;
})();
var statearr_29305_29484 = state_29214__$1;
(statearr_29305_29484[(2)] = null);

(statearr_29305_29484[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (43))){
var state_29214__$1 = state_29214;
var statearr_29306_29485 = state_29214__$1;
(statearr_29306_29485[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_29306_29485[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (61))){
var inst_29018 = (state_29214[(15)]);
var inst_29008 = (state_29214[(18)]);
var inst_28991 = (state_29214[(26)]);
var inst_29013 = (state_29214[(37)]);
var inst_29012 = (state_29214[(42)]);
var inst_29017 = (state_29214[(2)]);
var inst_29018__$1 = fluree.db.util.async.throw_err(inst_29017);
var inst_29019 = fluree.db.query.range.find_next_valid_node(inst_29018__$1,inst_28991,inst_29008,inst_29012,inst_29013);
var state_29214__$1 = (function (){var statearr_29307 = state_29214;
(statearr_29307[(15)] = inst_29018__$1);

return statearr_29307;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(62),inst_29019);
} else {
if((state_val_29215 === (29))){
var inst_28941 = (state_29214[(2)]);
var inst_28942 = fluree.db.util.async.throw_err(inst_28941);
var state_29214__$1 = state_29214;
var statearr_29308_29486 = state_29214__$1;
(statearr_29308_29486[(2)] = inst_28942);

(statearr_29308_29486[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (44))){
var inst_28873 = (state_29214[(60)]);
var state_29214__$1 = state_29214;
var statearr_29309_29487 = state_29214__$1;
(statearr_29309_29487[(2)] = inst_28873);

(statearr_29309_29487[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (93))){
var inst_29032 = (state_29214[(34)]);
var inst_29028 = (state_29214[(9)]);
var inst_29089 = (state_29214[(81)]);
var inst_29101 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_29032,inst_29089);
var state_29214__$1 = (function (){var statearr_29310 = state_29214;
(statearr_29310[(69)] = inst_29101);

return statearr_29310;
})();
if(cljs.core.truth_(inst_29028)){
var statearr_29311_29488 = state_29214__$1;
(statearr_29311_29488[(1)] = (95));

} else {
var statearr_29312_29489 = state_29214__$1;
(statearr_29312_29489[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (6))){
var inst_28865 = (state_29214[(49)]);
var inst_28885 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28865);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(9),inst_28885);
} else {
if((state_val_29215 === (111))){
var inst_29001 = (state_29214[(13)]);
var inst_29169 = (state_29214[(78)]);
var inst_29177 = (inst_29169 < inst_29001);
var state_29214__$1 = state_29214;
var statearr_29313_29490 = state_29214__$1;
(statearr_29313_29490[(2)] = inst_29177);

(statearr_29313_29490[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (28))){
var inst_28935 = (state_29214[(74)]);
var inst_28945 = (state_29214[(2)]);
var inst_28946 = fluree.db.util.core.pred_ident_QMARK_(inst_28935);
var state_29214__$1 = (function (){var statearr_29314 = state_29214;
(statearr_29314[(33)] = inst_28945);

return statearr_29314;
})();
if(inst_28946){
var statearr_29315_29491 = state_29214__$1;
(statearr_29315_29491[(1)] = (30));

} else {
var statearr_29316_29492 = state_29214__$1;
(statearr_29316_29492[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (64))){
var state_29214__$1 = state_29214;
var statearr_29317_29493 = state_29214__$1;
(statearr_29317_29493[(2)] = true);

(statearr_29317_29493[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (103))){
var inst_29124 = (state_29214[(83)]);
var inst_29143 = (state_29214[(2)]);
var inst_29144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29143,(0),null);
var inst_29145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29143,(1),null);
var inst_29146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29147 = [inst_29144,inst_29124,inst_29145];
var inst_29148 = (new cljs.core.PersistentVector(null,3,(5),inst_29146,inst_29147,null));
var state_29214__$1 = state_29214;
var statearr_29318_29494 = state_29214__$1;
(statearr_29318_29494[(2)] = inst_29148);

(statearr_29318_29494[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (51))){
var inst_28979 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29319_29495 = state_29214__$1;
(statearr_29319_29495[(2)] = inst_28979);

(statearr_29319_29495[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (25))){
var inst_28934 = (state_29214[(51)]);
var inst_28932 = (state_29214[(29)]);
var inst_28933 = (state_29214[(39)]);
var inst_28932__$1 = (state_29214[(2)]);
var inst_28933__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28932__$1,(0),null);
var inst_28934__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28933__$1,(0),null);
var inst_28935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28933__$1,(1),null);
var inst_28936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28932__$1,(1),null);
var inst_28937 = fluree.db.util.core.pred_ident_QMARK_(inst_28934__$1);
var state_29214__$1 = (function (){var statearr_29320 = state_29214;
(statearr_29320[(51)] = inst_28934__$1);

(statearr_29320[(29)] = inst_28932__$1);

(statearr_29320[(74)] = inst_28935);

(statearr_29320[(36)] = inst_28936);

(statearr_29320[(39)] = inst_28933__$1);

return statearr_29320;
})();
if(inst_28937){
var statearr_29321_29496 = state_29214__$1;
(statearr_29321_29496[(1)] = (26));

} else {
var statearr_29322_29497 = state_29214__$1;
(statearr_29322_29497[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (34))){
var inst_28945 = (state_29214[(33)]);
var state_29214__$1 = state_29214;
var statearr_29323_29498 = state_29214__$1;
(statearr_29323_29498[(2)] = inst_28945);

(statearr_29323_29498[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (17))){
var inst_28874 = (state_29214[(62)]);
var state_29214__$1 = state_29214;
var statearr_29324_29499 = state_29214__$1;
(statearr_29324_29499[(2)] = inst_28874);

(statearr_29324_29499[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (3))){
var inst_29212 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29214__$1,inst_29212);
} else {
if((state_val_29215 === (12))){
var inst_28867 = (state_29214[(55)]);
var inst_28900 = (state_29214[(2)]);
var inst_28901 = cljs.core.boolean_QMARK_(inst_28867);
var state_29214__$1 = (function (){var statearr_29325 = state_29214;
(statearr_29325[(19)] = inst_28900);

return statearr_29325;
})();
if(inst_28901){
var statearr_29326_29500 = state_29214__$1;
(statearr_29326_29500[(1)] = (14));

} else {
var statearr_29327_29501 = state_29214__$1;
(statearr_29327_29501[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (2))){
var inst_28864 = (state_29214[(10)]);
var inst_28871 = (state_29214[(21)]);
var inst_28879 = (state_29214[(24)]);
var inst_28865 = (state_29214[(49)]);
var _ = (function (){var statearr_29328 = state_29214;
(statearr_29328[(4)] = cljs.core.cons((5),(state_29214[(4)])));

return statearr_29328;
})();
var inst_28864__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_28865__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28864__$1,(0),null);
var inst_28866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28864__$1,(1),null);
var inst_28867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28864__$1,(2),null);
var inst_28868 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28864__$1,(3),null);
var inst_28869 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28864__$1,(4),null);
var inst_28870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28864__$1,(5),null);
var inst_28871__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_28872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28871__$1,(0),null);
var inst_28873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28871__$1,(1),null);
var inst_28874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28871__$1,(2),null);
var inst_28875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28871__$1,(3),null);
var inst_28876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28871__$1,(4),null);
var inst_28877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28871__$1,(5),null);
var inst_28878 = opts;
var inst_28879__$1 = cljs.core.__destructure_map(inst_28878);
var inst_28880 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28879__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_28881 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28879__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_28882 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28879__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_28883 = fluree.db.util.core.pred_ident_QMARK_(inst_28865__$1);
var state_29214__$1 = (function (){var statearr_29329 = state_29214;
(statearr_29329[(55)] = inst_28867);

(statearr_29329[(10)] = inst_28864__$1);

(statearr_29329[(84)] = inst_28872);

(statearr_29329[(12)] = inst_28869);

(statearr_29329[(56)] = inst_28870);

(statearr_29329[(21)] = inst_28871__$1);

(statearr_29329[(24)] = inst_28879__$1);

(statearr_29329[(58)] = inst_28877);

(statearr_29329[(59)] = inst_28866);

(statearr_29329[(25)] = inst_28881);

(statearr_29329[(60)] = inst_28873);

(statearr_29329[(61)] = inst_28882);

(statearr_29329[(62)] = inst_28874);

(statearr_29329[(31)] = inst_28876);

(statearr_29329[(49)] = inst_28865__$1);

(statearr_29329[(45)] = inst_28875);

(statearr_29329[(46)] = inst_28880);

(statearr_29329[(47)] = inst_28868);

return statearr_29329;
})();
if(inst_28883){
var statearr_29330_29502 = state_29214__$1;
(statearr_29330_29502[(1)] = (6));

} else {
var statearr_29331_29503 = state_29214__$1;
(statearr_29331_29503[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (66))){
var inst_29022 = (state_29214[(8)]);
var inst_28997 = (state_29214[(71)]);
var inst_29030 = cljs.core.PersistentVector.EMPTY;
var inst_29031 = inst_29022;
var inst_29032 = inst_28997;
var inst_29033 = (0);
var inst_29034 = (0);
var inst_29035 = inst_29030;
var state_29214__$1 = (function (){var statearr_29332 = state_29214;
(statearr_29332[(11)] = inst_29034);

(statearr_29332[(16)] = inst_29035);

(statearr_29332[(20)] = inst_29031);

(statearr_29332[(34)] = inst_29032);

(statearr_29332[(44)] = inst_29033);

return statearr_29332;
})();
var statearr_29333_29504 = state_29214__$1;
(statearr_29333_29504[(2)] = null);

(statearr_29333_29504[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (107))){
var inst_29186 = (state_29214[(66)]);
var inst_29186__$1 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29334 = state_29214;
(statearr_29334[(66)] = inst_29186__$1);

return statearr_29334;
})();
if(cljs.core.truth_(inst_29186__$1)){
var statearr_29335_29505 = state_29214__$1;
(statearr_29335_29505[(1)] = (114));

} else {
var statearr_29336_29506 = state_29214__$1;
(statearr_29336_29506[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (23))){
var inst_28867 = (state_29214[(55)]);
var inst_28882 = (state_29214[(61)]);
var inst_28874 = (state_29214[(62)]);
var inst_28917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28919 = [inst_28867,inst_28874];
var inst_28920 = (new cljs.core.PersistentVector(null,2,(5),inst_28918,inst_28919,null));
var inst_28921 = [inst_28920,inst_28882];
var inst_28922 = (new cljs.core.PersistentVector(null,2,(5),inst_28917,inst_28921,null));
var state_29214__$1 = state_29214;
var statearr_29337_29507 = state_29214__$1;
(statearr_29337_29507[(2)] = inst_28922);

(statearr_29337_29507[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (47))){
var inst_28975 = (cljs.core._GT__EQ_ === start_test);
var state_29214__$1 = state_29214;
if(cljs.core.truth_(inst_28975)){
var statearr_29338_29508 = state_29214__$1;
(statearr_29338_29508[(1)] = (49));

} else {
var statearr_29339_29509 = state_29214__$1;
(statearr_29339_29509[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (35))){
var inst_28955 = (state_29214[(75)]);
var state_29214__$1 = state_29214;
var statearr_29340_29510 = state_29214__$1;
(statearr_29340_29510[(2)] = inst_28955);

(statearr_29340_29510[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (82))){
var inst_29031 = (state_29214[(20)]);
var inst_29002 = (state_29214[(30)]);
var inst_29067 = (state_29214[(2)]);
var inst_29068 = fluree.db.dbproto._rhs(inst_29031);
var state_29214__$1 = (function (){var statearr_29341 = state_29214;
(statearr_29341[(80)] = inst_29067);

(statearr_29341[(65)] = inst_29068);

return statearr_29341;
})();
if(cljs.core.truth_(inst_29002)){
var statearr_29342_29511 = state_29214__$1;
(statearr_29342_29511[(1)] = (83));

} else {
var statearr_29343_29512 = state_29214__$1;
(statearr_29343_29512[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (76))){
var inst_28881 = (state_29214[(25)]);
var inst_29055 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29344 = state_29214;
(statearr_29344[(64)] = inst_29055);

return statearr_29344;
})();
if(cljs.core.truth_(inst_28881)){
var statearr_29345_29513 = state_29214__$1;
(statearr_29345_29513[(1)] = (77));

} else {
var statearr_29346_29514 = state_29214__$1;
(statearr_29346_29514[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (97))){
var inst_29035 = (state_29214[(16)]);
var inst_29155 = (state_29214[(2)]);
var inst_29156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29155,(0),null);
var inst_29157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29155,(1),null);
var inst_29158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29155,(2),null);
var inst_29159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29160 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29035,inst_29158);
var inst_29161 = [(0),inst_29156,inst_29157,inst_29160];
var inst_29162 = (new cljs.core.PersistentVector(null,4,(5),inst_29159,inst_29161,null));
var state_29214__$1 = state_29214;
var statearr_29347_29515 = state_29214__$1;
(statearr_29347_29515[(2)] = inst_29162);

(statearr_29347_29515[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (19))){
var inst_28912 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29348_29516 = state_29214__$1;
(statearr_29348_29516[(2)] = inst_28912);

(statearr_29348_29516[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (57))){
var inst_28988 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29349_29517 = state_29214__$1;
(statearr_29349_29517[(2)] = inst_28988);

(statearr_29349_29517[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (68))){
var inst_29209 = (state_29214[(2)]);
var _ = (function (){var statearr_29350 = state_29214;
(statearr_29350[(4)] = cljs.core.rest((state_29214[(4)])));

return statearr_29350;
})();
var state_29214__$1 = state_29214;
var statearr_29351_29518 = state_29214__$1;
(statearr_29351_29518[(2)] = inst_29209);

(statearr_29351_29518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (11))){
var inst_28872 = (state_29214[(84)]);
var state_29214__$1 = state_29214;
var statearr_29352_29519 = state_29214__$1;
(statearr_29352_29519[(2)] = inst_28872);

(statearr_29352_29519[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (115))){
var state_29214__$1 = state_29214;
var statearr_29354_29520 = state_29214__$1;
(statearr_29354_29520[(2)] = null);

(statearr_29354_29520[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (9))){
var inst_28887 = (state_29214[(2)]);
var inst_28888 = fluree.db.util.async.throw_err(inst_28887);
var state_29214__$1 = state_29214;
var statearr_29355_29521 = state_29214__$1;
(statearr_29355_29521[(2)] = inst_28888);

(statearr_29355_29521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (5))){
var _ = (function (){var statearr_29356 = state_29214;
(statearr_29356[(4)] = cljs.core.rest((state_29214[(4)])));

return statearr_29356;
})();
var state_29214__$1 = state_29214;
var ex29353 = (state_29214__$1[(2)]);
var statearr_29357_29522 = state_29214__$1;
(statearr_29357_29522[(5)] = ex29353);


if((ex29353 instanceof Error)){
var statearr_29358_29523 = state_29214__$1;
(statearr_29358_29523[(1)] = (4));

(statearr_29358_29523[(5)] = null);

} else {
throw ex29353;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (112))){
var inst_29175 = (state_29214[(79)]);
var state_29214__$1 = state_29214;
var statearr_29359_29524 = state_29214__$1;
(statearr_29359_29524[(2)] = inst_29175);

(statearr_29359_29524[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (83))){
var inst_29070 = (state_29214[(85)]);
var inst_29032 = (state_29214[(34)]);
var inst_29070__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_29032);
var state_29214__$1 = (function (){var statearr_29360 = state_29214;
(statearr_29360[(85)] = inst_29070__$1);

return statearr_29360;
})();
if(inst_29070__$1){
var statearr_29361_29525 = state_29214__$1;
(statearr_29361_29525[(1)] = (86));

} else {
var statearr_29362_29526 = state_29214__$1;
(statearr_29362_29526[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (14))){
var inst_28867 = (state_29214[(55)]);
var state_29214__$1 = state_29214;
var statearr_29363_29527 = state_29214__$1;
(statearr_29363_29527[(2)] = inst_28867);

(statearr_29363_29527[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (45))){
var inst_28870 = (state_29214[(56)]);
var inst_28972 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29364 = state_29214;
(statearr_29364[(32)] = inst_28972);

return statearr_29364;
})();
if(cljs.core.truth_(inst_28870)){
var statearr_29365_29528 = state_29214__$1;
(statearr_29365_29528[(1)] = (46));

} else {
var statearr_29366_29529 = state_29214__$1;
(statearr_29366_29529[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (53))){
var inst_28984 = (cljs.core._LT__EQ_ === end_test);
var state_29214__$1 = state_29214;
if(cljs.core.truth_(inst_28984)){
var statearr_29367_29530 = state_29214__$1;
(statearr_29367_29530[(1)] = (55));

} else {
var statearr_29368_29531 = state_29214__$1;
(statearr_29368_29531[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (78))){
var inst_29055 = (state_29214[(64)]);
var state_29214__$1 = state_29214;
var statearr_29369_29532 = state_29214__$1;
(statearr_29369_29532[(2)] = inst_29055);

(statearr_29369_29532[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (26))){
var inst_28934 = (state_29214[(51)]);
var inst_28939 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28934);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(29),inst_28939);
} else {
if((state_val_29215 === (123))){
var inst_29204 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29370_29533 = state_29214__$1;
(statearr_29370_29533[(2)] = inst_29204);

(statearr_29370_29533[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (16))){
var inst_28914 = (state_29214[(57)]);
var inst_28914__$1 = (state_29214[(2)]);
var inst_28915 = (inst_28914__$1 == null);
var state_29214__$1 = (function (){var statearr_29371 = state_29214;
(statearr_29371[(57)] = inst_28914__$1);

return statearr_29371;
})();
if(cljs.core.truth_(inst_28915)){
var statearr_29372_29534 = state_29214__$1;
(statearr_29372_29534[(1)] = (23));

} else {
var statearr_29373_29535 = state_29214__$1;
(statearr_29373_29535[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (81))){
var inst_29061 = (state_29214[(86)]);
var state_29214__$1 = state_29214;
var statearr_29374_29536 = state_29214__$1;
(statearr_29374_29536[(2)] = inst_29061);

(statearr_29374_29536[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (120))){
var inst_29198 = (state_29214[(2)]);
var inst_29199 = cljs.core.not(inst_29198);
var state_29214__$1 = state_29214;
if(inst_29199){
var statearr_29375_29537 = state_29214__$1;
(statearr_29375_29537[(1)] = (121));

} else {
var statearr_29376_29538 = state_29214__$1;
(statearr_29376_29538[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (79))){
var inst_28936 = (state_29214[(36)]);
var inst_29061 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29377 = state_29214;
(statearr_29377[(86)] = inst_29061);

return statearr_29377;
})();
if(cljs.core.truth_(inst_28936)){
var statearr_29378_29539 = state_29214__$1;
(statearr_29378_29539[(1)] = (80));

} else {
var statearr_29379_29540 = state_29214__$1;
(statearr_29379_29540[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (38))){
var inst_28866 = (state_29214[(59)]);
var state_29214__$1 = state_29214;
var statearr_29380_29541 = state_29214__$1;
(statearr_29380_29541[(2)] = inst_28866);

(statearr_29380_29541[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (98))){
var inst_29109 = (state_29214[(67)]);
var inst_29001 = (state_29214[(13)]);
var inst_29111 = (state_29214[(70)]);
var inst_29114 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29115 = (inst_29109 - inst_29111);
var inst_29116 = [inst_29001,inst_29115];
var inst_29117 = (new cljs.core.PersistentVector(null,2,(5),inst_29114,inst_29116,null));
var state_29214__$1 = state_29214;
var statearr_29381_29542 = state_29214__$1;
(statearr_29381_29542[(2)] = inst_29117);

(statearr_29381_29542[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (87))){
var inst_29070 = (state_29214[(85)]);
var state_29214__$1 = state_29214;
var statearr_29382_29543 = state_29214__$1;
(statearr_29382_29543[(2)] = inst_29070);

(statearr_29382_29543[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (30))){
var inst_28935 = (state_29214[(74)]);
var inst_28948 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28935);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(33),inst_28948);
} else {
if((state_val_29215 === (73))){
var inst_28880 = (state_29214[(46)]);
var inst_29049 = (state_29214[(2)]);
var state_29214__$1 = (function (){var statearr_29383 = state_29214;
(statearr_29383[(28)] = inst_29049);

return statearr_29383;
})();
if(cljs.core.truth_(inst_28880)){
var statearr_29384_29544 = state_29214__$1;
(statearr_29384_29544[(1)] = (74));

} else {
var statearr_29385_29545 = state_29214__$1;
(statearr_29385_29545[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (96))){
var inst_29034 = (state_29214[(11)]);
var inst_29001 = (state_29214[(13)]);
var inst_28995 = (state_29214[(35)]);
var inst_29101 = (state_29214[(69)]);
var inst_29033 = (state_29214[(44)]);
var inst_29150 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_29101,inst_29033,inst_29034,inst_28995,inst_29001);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(104),inst_29150);
} else {
if((state_val_29215 === (10))){
var inst_28872 = (state_29214[(84)]);
var inst_28894 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28872);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(13),inst_28894);
} else {
if((state_val_29215 === (18))){
var state_29214__$1 = state_29214;
var statearr_29386_29546 = state_29214__$1;
(statearr_29386_29546[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (105))){
var inst_29068 = (state_29214[(65)]);
var inst_29173 = (state_29214[(82)]);
var inst_29007 = (state_29214[(23)]);
var inst_28992 = (state_29214[(40)]);
var inst_29172 = (inst_29007.cljs$core$IFn$_invoke$arity$2 ? inst_29007.cljs$core$IFn$_invoke$arity$2(inst_29068,inst_28992) : inst_29007.call(null,inst_29068,inst_28992));
var inst_29173__$1 = (inst_29172 < (0));
var state_29214__$1 = (function (){var statearr_29388 = state_29214;
(statearr_29388[(82)] = inst_29173__$1);

return statearr_29388;
})();
if(cljs.core.truth_(inst_29173__$1)){
var statearr_29389_29547 = state_29214__$1;
(statearr_29389_29547[(1)] = (108));

} else {
var statearr_29390_29548 = state_29214__$1;
(statearr_29390_29548[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (52))){
var inst_28877 = (state_29214[(58)]);
var state_29214__$1 = state_29214;
var statearr_29391_29549 = state_29214__$1;
(statearr_29391_29549[(2)] = inst_28877);

(statearr_29391_29549[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (114))){
var inst_29018 = (state_29214[(15)]);
var inst_29008 = (state_29214[(18)]);
var inst_29068 = (state_29214[(65)]);
var inst_29013 = (state_29214[(37)]);
var inst_29012 = (state_29214[(42)]);
var inst_29188 = fluree.db.query.range.find_next_valid_node(inst_29018,inst_29068,inst_29008,inst_29012,inst_29013);
var state_29214__$1 = state_29214;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29214__$1,(117),inst_29188);
} else {
if((state_val_29215 === (67))){
var state_29214__$1 = state_29214;
var statearr_29392_29550 = state_29214__$1;
(statearr_29392_29550[(2)] = null);

(statearr_29392_29550[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (71))){
var inst_28864 = (state_29214[(10)]);
var inst_29034 = (state_29214[(11)]);
var inst_28869 = (state_29214[(12)]);
var inst_29001 = (state_29214[(13)]);
var inst_28963 = (state_29214[(14)]);
var inst_29018 = (state_29214[(15)]);
var inst_29035 = (state_29214[(16)]);
var inst_28994 = (state_29214[(17)]);
var inst_29008 = (state_29214[(18)]);
var inst_29022 = (state_29214[(8)]);
var inst_28900 = (state_29214[(19)]);
var inst_29031 = (state_29214[(20)]);
var inst_28871 = (state_29214[(21)]);
var inst_28891 = (state_29214[(22)]);
var inst_29007 = (state_29214[(23)]);
var inst_28879 = (state_29214[(24)]);
var inst_28881 = (state_29214[(25)]);
var inst_28991 = (state_29214[(26)]);
var inst_29041 = (state_29214[(27)]);
var inst_28932 = (state_29214[(29)]);
var inst_29002 = (state_29214[(30)]);
var inst_28876 = (state_29214[(31)]);
var inst_28972 = (state_29214[(32)]);
var inst_28945 = (state_29214[(33)]);
var inst_29032 = (state_29214[(34)]);
var inst_28995 = (state_29214[(35)]);
var inst_28936 = (state_29214[(36)]);
var inst_29013 = (state_29214[(37)]);
var inst_29028 = (state_29214[(9)]);
var inst_28954 = (state_29214[(38)]);
var inst_28933 = (state_29214[(39)]);
var inst_28992 = (state_29214[(40)]);
var inst_28990 = (state_29214[(41)]);
var inst_29012 = (state_29214[(42)]);
var inst_29003 = (state_29214[(43)]);
var inst_29033 = (state_29214[(44)]);
var inst_28875 = (state_29214[(45)]);
var inst_28880 = (state_29214[(46)]);
var inst_28868 = (state_29214[(47)]);
var inst_28981 = (state_29214[(48)]);
var inst_29045 = (function (){var no_filter_QMARK_ = inst_29028;
var t = inst_29008;
var max_limit_QMARK_ = inst_29002;
var next_node = inst_29031;
var fast_forward_db_QMARK_ = inst_29013;
var s1 = inst_28891;
var o2 = inst_28954;
var t1 = inst_28868;
var predicate_fn = inst_28881;
var i = inst_29033;
var vec__28857 = inst_28932;
var m1 = inst_28981;
var root_node = inst_29018;
var vec__28853 = inst_28871;
var s2 = inst_28900;
var vec__28850 = inst_28864;
var p2 = inst_28972;
var map__28863 = inst_28994;
var permissions = inst_29003;
var G__29042 = inst_29041;
var limit = inst_29001;
var start_flake = inst_28991;
var flake_limit = inst_28995;
var offset = inst_29032;
var map__28856 = inst_28879;
var acc = inst_29035;
var t2 = inst_28875;
var op1 = inst_28869;
var o1 = inst_28945;
var vec__28860 = inst_28933;
var end_flake = inst_28992;
var base_result = inst_29041;
var s = inst_29034;
var node_start = inst_29022;
var p1 = inst_28963;
var subject_fn = inst_28880;
var object_fn = inst_28936;
var idx_compare = inst_29007;
var op2 = inst_28876;
var m2 = inst_28990;
var novelty = inst_29012;
return (function (p1__28831_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__28831_SHARP_.o,start_flake.o);
});
})();
var inst_29046 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29045,inst_29041);
var state_29214__$1 = state_29214;
var statearr_29393_29551 = state_29214__$1;
(statearr_29393_29551[(2)] = inst_29046);

(statearr_29393_29551[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (42))){
var inst_28968 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
if(cljs.core.truth_(inst_28968)){
var statearr_29394_29552 = state_29214__$1;
(statearr_29394_29552[(1)] = (43));

} else {
var statearr_29395_29553 = state_29214__$1;
(statearr_29395_29553[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (80))){
var inst_28864 = (state_29214[(10)]);
var inst_29034 = (state_29214[(11)]);
var inst_28869 = (state_29214[(12)]);
var inst_29001 = (state_29214[(13)]);
var inst_28963 = (state_29214[(14)]);
var inst_29018 = (state_29214[(15)]);
var inst_29035 = (state_29214[(16)]);
var inst_28994 = (state_29214[(17)]);
var inst_29008 = (state_29214[(18)]);
var inst_29022 = (state_29214[(8)]);
var inst_28900 = (state_29214[(19)]);
var inst_29031 = (state_29214[(20)]);
var inst_28871 = (state_29214[(21)]);
var inst_28891 = (state_29214[(22)]);
var inst_29007 = (state_29214[(23)]);
var inst_28879 = (state_29214[(24)]);
var inst_28881 = (state_29214[(25)]);
var inst_28991 = (state_29214[(26)]);
var inst_29041 = (state_29214[(27)]);
var inst_28932 = (state_29214[(29)]);
var inst_29002 = (state_29214[(30)]);
var inst_28876 = (state_29214[(31)]);
var inst_28972 = (state_29214[(32)]);
var inst_28945 = (state_29214[(33)]);
var inst_29032 = (state_29214[(34)]);
var inst_28995 = (state_29214[(35)]);
var inst_29061 = (state_29214[(86)]);
var inst_28936 = (state_29214[(36)]);
var inst_29013 = (state_29214[(37)]);
var inst_29028 = (state_29214[(9)]);
var inst_28954 = (state_29214[(38)]);
var inst_28933 = (state_29214[(39)]);
var inst_28992 = (state_29214[(40)]);
var inst_28990 = (state_29214[(41)]);
var inst_29012 = (state_29214[(42)]);
var inst_29003 = (state_29214[(43)]);
var inst_29033 = (state_29214[(44)]);
var inst_28875 = (state_29214[(45)]);
var inst_28880 = (state_29214[(46)]);
var inst_28868 = (state_29214[(47)]);
var inst_28981 = (state_29214[(48)]);
var inst_29063 = (function (){var no_filter_QMARK_ = inst_29028;
var t = inst_29008;
var max_limit_QMARK_ = inst_29002;
var next_node = inst_29031;
var fast_forward_db_QMARK_ = inst_29013;
var s1 = inst_28891;
var o2 = inst_28954;
var t1 = inst_28868;
var predicate_fn = inst_28881;
var i = inst_29033;
var vec__28857 = inst_28932;
var m1 = inst_28981;
var root_node = inst_29018;
var vec__28853 = inst_28871;
var s2 = inst_28900;
var vec__28850 = inst_28864;
var p2 = inst_28972;
var map__28863 = inst_28994;
var permissions = inst_29003;
var G__29042 = inst_29061;
var limit = inst_29001;
var start_flake = inst_28991;
var flake_limit = inst_28995;
var offset = inst_29032;
var map__28856 = inst_28879;
var acc = inst_29035;
var t2 = inst_28875;
var op1 = inst_28869;
var o1 = inst_28945;
var vec__28860 = inst_28933;
var end_flake = inst_28992;
var base_result = inst_29041;
var s = inst_29034;
var node_start = inst_29022;
var p1 = inst_28963;
var subject_fn = inst_28880;
var object_fn = inst_28936;
var idx_compare = inst_29007;
var op2 = inst_28876;
var m2 = inst_28990;
var novelty = inst_29012;
return (function (p1__28834_SHARP_){
var G__29396 = p1__28834_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__29396) : object_fn.call(null,G__29396));
});
})();
var inst_29064 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_29063,inst_29061);
var state_29214__$1 = state_29214;
var statearr_29397_29554 = state_29214__$1;
(statearr_29397_29554[(2)] = inst_29064);

(statearr_29397_29554[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (37))){
var state_29214__$1 = state_29214;
var statearr_29398_29555 = state_29214__$1;
(statearr_29398_29555[(2)] = (-1));

(statearr_29398_29555[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (63))){
var inst_28963 = (state_29214[(14)]);
var inst_28900 = (state_29214[(19)]);
var inst_28891 = (state_29214[(22)]);
var inst_28972 = (state_29214[(32)]);
var inst_29003 = (state_29214[(43)]);
var inst_29025 = fluree.db.permissions_validate.no_filter_QMARK_(inst_29003,inst_28891,inst_28900,inst_28963,inst_28972);
var state_29214__$1 = state_29214;
var statearr_29399_29556 = state_29214__$1;
(statearr_29399_29556[(2)] = inst_29025);

(statearr_29399_29556[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (94))){
var inst_29164 = (state_29214[(2)]);
var state_29214__$1 = state_29214;
var statearr_29400_29557 = state_29214__$1;
(statearr_29400_29557[(2)] = inst_29164);

(statearr_29400_29557[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (8))){
var inst_28872 = (state_29214[(84)]);
var inst_28891 = (state_29214[(2)]);
var inst_28892 = fluree.db.util.core.pred_ident_QMARK_(inst_28872);
var state_29214__$1 = (function (){var statearr_29401 = state_29214;
(statearr_29401[(22)] = inst_28891);

return statearr_29401;
})();
if(inst_28892){
var statearr_29402_29558 = state_29214__$1;
(statearr_29402_29558[(1)] = (10));

} else {
var statearr_29403_29559 = state_29214__$1;
(statearr_29403_29559[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (49))){
var state_29214__$1 = state_29214;
var statearr_29404_29560 = state_29214__$1;
(statearr_29404_29560[(2)] = fluree.db.util.core.min_integer);

(statearr_29404_29560[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29215 === (84))){
var inst_29002 = (state_29214[(30)]);
var state_29214__$1 = state_29214;
var statearr_29405_29561 = state_29214__$1;
(statearr_29405_29561[(2)] = inst_29002);

(statearr_29405_29561[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__14778__auto__ = null;
var fluree$db$query$range$state_machine__14778__auto____0 = (function (){
var statearr_29406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29406[(0)] = fluree$db$query$range$state_machine__14778__auto__);

(statearr_29406[(1)] = (1));

return statearr_29406;
});
var fluree$db$query$range$state_machine__14778__auto____1 = (function (state_29214){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_29214);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e29407){var ex__14781__auto__ = e29407;
var statearr_29408_29562 = state_29214;
(statearr_29408_29562[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_29214[(4)]))){
var statearr_29409_29563 = state_29214;
(statearr_29409_29563[(1)] = cljs.core.first((state_29214[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__29564 = state_29214;
state_29214 = G__29564;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__14778__auto__ = function(state_29214){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__14778__auto____1.call(this,state_29214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__14778__auto____0;
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__14778__auto____1;
return fluree$db$query$range$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_29410 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_29410[(6)] = c__14852__auto__);

return statearr_29410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_29620){
var state_val_29621 = (state_29620[(1)]);
if((state_val_29621 === (7))){
var inst_29594 = (state_29620[(7)]);
var inst_29584 = (state_29620[(8)]);
var inst_29592 = fluree.db.flake.Flake__GT_parts(inst_29584);
var inst_29593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29592,(0),null);
var inst_29594__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29592,(1),null);
var inst_29595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29592,(2),null);
var inst_29596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29592,(3),null);
var inst_29597 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29592,(4),null);
var inst_29598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29592,(5),null);
var inst_29599 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_29595,inst_29594__$1);
var state_29620__$1 = (function (){var statearr_29622 = state_29620;
(statearr_29622[(9)] = inst_29596);

(statearr_29622[(10)] = inst_29593);

(statearr_29622[(11)] = inst_29598);

(statearr_29622[(12)] = inst_29597);

(statearr_29622[(7)] = inst_29594__$1);

return statearr_29622;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29620__$1,(10),inst_29599);
} else {
if((state_val_29621 === (1))){
var inst_29572 = flakes;
var inst_29573 = cljs.core.seq(inst_29572);
var inst_29574 = cljs.core.first(inst_29573);
var inst_29575 = cljs.core.next(inst_29573);
var inst_29576 = cljs.core.PersistentVector.EMPTY;
var inst_29577 = inst_29572;
var inst_29578 = inst_29576;
var state_29620__$1 = (function (){var statearr_29623 = state_29620;
(statearr_29623[(13)] = inst_29575);

(statearr_29623[(14)] = inst_29578);

(statearr_29623[(15)] = inst_29577);

(statearr_29623[(16)] = inst_29574);

return statearr_29623;
})();
var statearr_29624_29642 = state_29620__$1;
(statearr_29624_29642[(2)] = null);

(statearr_29624_29642[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29621 === (4))){
var inst_29584 = (state_29620[(8)]);
var inst_29587 = fluree.db.query.range.is_tag_flake_QMARK_(inst_29584);
var state_29620__$1 = state_29620;
if(inst_29587){
var statearr_29625_29643 = state_29620__$1;
(statearr_29625_29643[(1)] = (7));

} else {
var statearr_29626_29644 = state_29620__$1;
(statearr_29626_29644[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29621 === (6))){
var inst_29616 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
var statearr_29627_29645 = state_29620__$1;
(statearr_29627_29645[(2)] = inst_29616);

(statearr_29627_29645[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29621 === (3))){
var inst_29618 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29620__$1,inst_29618);
} else {
if((state_val_29621 === (2))){
var inst_29577 = (state_29620[(15)]);
var inst_29584 = (state_29620[(8)]);
var inst_29583 = cljs.core.seq(inst_29577);
var inst_29584__$1 = cljs.core.first(inst_29583);
var inst_29585 = cljs.core.next(inst_29583);
var state_29620__$1 = (function (){var statearr_29628 = state_29620;
(statearr_29628[(17)] = inst_29585);

(statearr_29628[(8)] = inst_29584__$1);

return statearr_29628;
})();
if(cljs.core.truth_(inst_29584__$1)){
var statearr_29629_29646 = state_29620__$1;
(statearr_29629_29646[(1)] = (4));

} else {
var statearr_29630_29647 = state_29620__$1;
(statearr_29630_29647[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29621 === (9))){
var inst_29613 = (state_29620[(2)]);
var state_29620__$1 = state_29620;
var statearr_29631_29648 = state_29620__$1;
(statearr_29631_29648[(2)] = inst_29613);

(statearr_29631_29648[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29621 === (5))){
var inst_29578 = (state_29620[(14)]);
var state_29620__$1 = state_29620;
var statearr_29632_29649 = state_29620__$1;
(statearr_29632_29649[(2)] = inst_29578);

(statearr_29632_29649[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29621 === (10))){
var inst_29585 = (state_29620[(17)]);
var inst_29596 = (state_29620[(9)]);
var inst_29578 = (state_29620[(14)]);
var inst_29593 = (state_29620[(10)]);
var inst_29598 = (state_29620[(11)]);
var inst_29597 = (state_29620[(12)]);
var inst_29594 = (state_29620[(7)]);
var inst_29601 = (state_29620[(2)]);
var inst_29602 = fluree.db.util.async.throw_err(inst_29601);
var inst_29603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29604 = [inst_29593,inst_29594,inst_29602,inst_29596,inst_29597,inst_29598];
var inst_29605 = (new cljs.core.PersistentVector(null,6,(5),inst_29603,inst_29604,null));
var inst_29606 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_29605);
var inst_29607 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29578,inst_29606);
var inst_29577 = inst_29585;
var inst_29578__$1 = inst_29607;
var state_29620__$1 = (function (){var statearr_29633 = state_29620;
(statearr_29633[(14)] = inst_29578__$1);

(statearr_29633[(15)] = inst_29577);

return statearr_29633;
})();
var statearr_29634_29650 = state_29620__$1;
(statearr_29634_29650[(2)] = null);

(statearr_29634_29650[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29621 === (8))){
var inst_29585 = (state_29620[(17)]);
var inst_29578 = (state_29620[(14)]);
var inst_29584 = (state_29620[(8)]);
var inst_29610 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29578,inst_29584);
var inst_29577 = inst_29585;
var inst_29578__$1 = inst_29610;
var state_29620__$1 = (function (){var statearr_29635 = state_29620;
(statearr_29635[(14)] = inst_29578__$1);

(statearr_29635[(15)] = inst_29577);

return statearr_29635;
})();
var statearr_29636_29651 = state_29620__$1;
(statearr_29636_29651[(2)] = null);

(statearr_29636_29651[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto____0 = (function (){
var statearr_29637 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29637[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto__);

(statearr_29637[(1)] = (1));

return statearr_29637;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto____1 = (function (state_29620){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_29620);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e29638){var ex__14781__auto__ = e29638;
var statearr_29639_29652 = state_29620;
(statearr_29639_29652[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_29620[(4)]))){
var statearr_29640_29653 = state_29620;
(statearr_29640_29653[(1)] = cljs.core.first((state_29620[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__29654 = state_29620;
state_29620 = G__29654;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto__ = function(state_29620){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto____1.call(this,state_29620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_29641 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_29641[(6)] = c__14852__auto__);

return statearr_29641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__29656 = arguments.length;
switch (G__29656) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_29826){
var state_val_29827 = (state_29826[(1)]);
if((state_val_29827 === (65))){
var state_29826__$1 = state_29826;
var statearr_29828_29928 = state_29826__$1;
(statearr_29828_29928[(2)] = null);

(statearr_29828_29928[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (70))){
var inst_29821 = (state_29826[(2)]);
var _ = (function (){var statearr_29829 = state_29826;
(statearr_29829[(4)] = cljs.core.rest((state_29826[(4)])));

return statearr_29829;
})();
var state_29826__$1 = state_29826;
var statearr_29830_29929 = state_29826__$1;
(statearr_29830_29929[(2)] = inst_29821);

(statearr_29830_29929[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (62))){
var inst_29807 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29831_29930 = state_29826__$1;
(statearr_29831_29930[(2)] = inst_29807);

(statearr_29831_29930[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (7))){
var state_29826__$1 = state_29826;
var statearr_29832_29931 = state_29826__$1;
(statearr_29832_29931[(2)] = false);

(statearr_29832_29931[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (59))){
var inst_29781 = (state_29826[(2)]);
var inst_29782 = fluree.db.util.async.throw_err(inst_29781);
var state_29826__$1 = state_29826;
var statearr_29833_29932 = state_29826__$1;
(statearr_29833_29932[(2)] = inst_29782);

(statearr_29833_29932[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (20))){
var state_29826__$1 = state_29826;
var statearr_29834_29933 = state_29826__$1;
(statearr_29834_29933[(2)] = null);

(statearr_29834_29933[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (58))){
var inst_29771 = (state_29826[(2)]);
var inst_29772 = fluree.db.util.async.throw_err(inst_29771);
var inst_29773 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_29772);
var state_29826__$1 = state_29826;
var statearr_29835_29934 = state_29826__$1;
(statearr_29835_29934[(2)] = inst_29773);

(statearr_29835_29934[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (60))){
var inst_29667 = (state_29826[(7)]);
var inst_29668 = (state_29826[(8)]);
var inst_29670 = (state_29826[(9)]);
var inst_29707 = (state_29826[(10)]);
var inst_29787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29788 = [inst_29668,inst_29667,inst_29707,inst_29670];
var inst_29789 = (new cljs.core.PersistentVector(null,4,(5),inst_29787,inst_29788,null));
var inst_29790 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_29789,opts);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(63),inst_29790);
} else {
if((state_val_29827 === (27))){
var inst_29718 = (state_29826[(11)]);
var inst_29707 = (state_29826[(10)]);
var inst_29718__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_29707);
var state_29826__$1 = (function (){var statearr_29836 = state_29826;
(statearr_29836[(11)] = inst_29718__$1);

return statearr_29836;
})();
if(inst_29718__$1){
var statearr_29837_29935 = state_29826__$1;
(statearr_29837_29935[(1)] = (30));

} else {
var statearr_29838_29936 = state_29826__$1;
(statearr_29838_29936[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (1))){
var state_29826__$1 = state_29826;
var statearr_29839_29937 = state_29826__$1;
(statearr_29839_29937[(2)] = null);

(statearr_29839_29937[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (69))){
var inst_29813 = (state_29826[(12)]);
var state_29826__$1 = state_29826;
var statearr_29840_29938 = state_29826__$1;
(statearr_29840_29938[(2)] = inst_29813);

(statearr_29840_29938[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (24))){
var inst_29668 = (state_29826[(8)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29668)){
var statearr_29841_29939 = state_29826__$1;
(statearr_29841_29939[(1)] = (27));

} else {
var statearr_29842_29940 = state_29826__$1;
(statearr_29842_29940[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (55))){
var inst_29707 = (state_29826[(10)]);
var inst_29765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29766 = [inst_29707];
var inst_29767 = (new cljs.core.PersistentVector(null,1,(5),inst_29765,inst_29766,null));
var inst_29768 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_29769 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29767,inst_29768);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(58),inst_29769);
} else {
if((state_val_29827 === (39))){
var inst_29738 = (state_29826[(2)]);
var inst_29739 = fluree.db.util.async.throw_err(inst_29738);
var state_29826__$1 = state_29826;
var statearr_29843_29941 = state_29826__$1;
(statearr_29843_29941[(2)] = inst_29739);

(statearr_29843_29941[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (46))){
var inst_29751 = (state_29826[(13)]);
var inst_29751__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_29826__$1 = (function (){var statearr_29844 = state_29826;
(statearr_29844[(13)] = inst_29751__$1);

return statearr_29844;
})();
if(cljs.core.truth_(inst_29751__$1)){
var statearr_29845_29942 = state_29826__$1;
(statearr_29845_29942[(1)] = (49));

} else {
var statearr_29846_29943 = state_29826__$1;
(statearr_29846_29943[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (4))){
var inst_29657 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29847_29944 = state_29826__$1;
(statearr_29847_29944[(2)] = inst_29657);

(statearr_29847_29944[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (54))){
var inst_29763 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29763)){
var statearr_29848_29945 = state_29826__$1;
(statearr_29848_29945[(1)] = (55));

} else {
var statearr_29849_29946 = state_29826__$1;
(statearr_29849_29946[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (15))){
var inst_29669 = (state_29826[(14)]);
var inst_29688 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_29669);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(18),inst_29688);
} else {
if((state_val_29827 === (48))){
var inst_29809 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29850_29947 = state_29826__$1;
(statearr_29850_29947[(2)] = inst_29809);

(statearr_29850_29947[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (50))){
var inst_29677 = (state_29826[(15)]);
var inst_29666 = (state_29826[(16)]);
var inst_29751 = (state_29826[(13)]);
var inst_29682 = (state_29826[(17)]);
var inst_29667 = (state_29826[(7)]);
var inst_29668 = (state_29826[(8)]);
var inst_29671 = (state_29826[(18)]);
var inst_29670 = (state_29826[(9)]);
var inst_29707 = (state_29826[(10)]);
var inst_29755 = (function (){var t = inst_29670;
var p = inst_29668;
var idx_predicate_QMARK_ = inst_29671;
var o = inst_29707;
var tag_predicate_QMARK_ = inst_29677;
var temp__5751__auto__ = inst_29751;
var s = inst_29667;
var o_coerce_QMARK_ = inst_29682;
var vec__29663 = inst_29666;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_29826__$1 = state_29826;
var statearr_29851_29948 = state_29826__$1;
(statearr_29851_29948[(2)] = inst_29755);

(statearr_29851_29948[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (21))){
var inst_29703 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29852_29949 = state_29826__$1;
(statearr_29852_29949[(2)] = inst_29703);

(statearr_29852_29949[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (31))){
var inst_29718 = (state_29826[(11)]);
var state_29826__$1 = state_29826;
var statearr_29853_29950 = state_29826__$1;
(statearr_29853_29950[(2)] = inst_29718);

(statearr_29853_29950[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (32))){
var inst_29728 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29854_29951 = state_29826__$1;
(statearr_29854_29951[(2)] = inst_29728);

(statearr_29854_29951[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (40))){
var inst_29742 = (state_29826[(19)]);
var inst_29671 = (state_29826[(18)]);
var inst_29742__$1 = cljs.core.not(inst_29671);
var state_29826__$1 = (function (){var statearr_29855 = state_29826;
(statearr_29855[(19)] = inst_29742__$1);

return statearr_29855;
})();
if(inst_29742__$1){
var statearr_29856_29952 = state_29826__$1;
(statearr_29856_29952[(1)] = (43));

} else {
var statearr_29857_29953 = state_29826__$1;
(statearr_29857_29953[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (56))){
var inst_29757 = (state_29826[(20)]);
var inst_29667 = (state_29826[(7)]);
var inst_29668 = (state_29826[(8)]);
var inst_29670 = (state_29826[(9)]);
var inst_29775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29776 = [inst_29668,inst_29667,null,inst_29670];
var inst_29777 = (new cljs.core.PersistentVector(null,4,(5),inst_29775,inst_29776,null));
var inst_29778 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_29757);
var inst_29779 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_29777,inst_29778);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(59),inst_29779);
} else {
if((state_val_29827 === (33))){
var inst_29707 = (state_29826[(10)]);
var inst_29721 = cljs.core.fn_QMARK_(inst_29707);
var inst_29722 = (!(inst_29721));
var state_29826__$1 = state_29826;
var statearr_29858_29954 = state_29826__$1;
(statearr_29858_29954[(2)] = inst_29722);

(statearr_29858_29954[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (13))){
var inst_29669 = (state_29826[(14)]);
var inst_29686 = fluree.db.query.range.tag_string_QMARK_(inst_29669);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29686)){
var statearr_29859_29955 = state_29826__$1;
(statearr_29859_29955[(1)] = (15));

} else {
var statearr_29860_29956 = state_29826__$1;
(statearr_29860_29956[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (22))){
var inst_29699 = (state_29826[(2)]);
var inst_29700 = fluree.db.util.async.throw_err(inst_29699);
var state_29826__$1 = state_29826;
var statearr_29861_29957 = state_29826__$1;
(statearr_29861_29957[(2)] = inst_29700);

(statearr_29861_29957[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (36))){
var inst_29667 = (state_29826[(7)]);
var inst_29668 = (state_29826[(8)]);
var inst_29670 = (state_29826[(9)]);
var inst_29707 = (state_29826[(10)]);
var inst_29733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29734 = [inst_29668,inst_29707,inst_29667,inst_29670];
var inst_29735 = (new cljs.core.PersistentVector(null,4,(5),inst_29733,inst_29734,null));
var inst_29736 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_29735,opts);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(39),inst_29736);
} else {
if((state_val_29827 === (41))){
var inst_29668 = (state_29826[(8)]);
var state_29826__$1 = state_29826;
var statearr_29862_29958 = state_29826__$1;
(statearr_29862_29958[(2)] = inst_29668);

(statearr_29862_29958[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (43))){
var inst_29707 = (state_29826[(10)]);
var state_29826__$1 = state_29826;
var statearr_29863_29959 = state_29826__$1;
(statearr_29863_29959[(2)] = inst_29707);

(statearr_29863_29959[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (61))){
var inst_29707 = (state_29826[(10)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29707)){
var statearr_29864_29960 = state_29826__$1;
(statearr_29864_29960[(1)] = (64));

} else {
var statearr_29865_29961 = state_29826__$1;
(statearr_29865_29961[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (29))){
var inst_29731 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29731)){
var statearr_29866_29962 = state_29826__$1;
(statearr_29866_29962[(1)] = (36));

} else {
var statearr_29867_29963 = state_29826__$1;
(statearr_29867_29963[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (44))){
var inst_29742 = (state_29826[(19)]);
var state_29826__$1 = state_29826;
var statearr_29868_29964 = state_29826__$1;
(statearr_29868_29964[(2)] = inst_29742);

(statearr_29868_29964[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (6))){
var inst_29668 = (state_29826[(8)]);
var inst_29673 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_29668);
var inst_29674 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_29673);
var state_29826__$1 = state_29826;
var statearr_29869_29965 = state_29826__$1;
(statearr_29869_29965[(2)] = inst_29674);

(statearr_29869_29965[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (28))){
var inst_29668 = (state_29826[(8)]);
var state_29826__$1 = state_29826;
var statearr_29870_29966 = state_29826__$1;
(statearr_29870_29966[(2)] = inst_29668);

(statearr_29870_29966[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (64))){
var inst_29667 = (state_29826[(7)]);
var inst_29668 = (state_29826[(8)]);
var inst_29670 = (state_29826[(9)]);
var inst_29707 = (state_29826[(10)]);
var inst_29796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29797 = [inst_29707,inst_29668,inst_29667,inst_29670];
var inst_29798 = (new cljs.core.PersistentVector(null,4,(5),inst_29796,inst_29797,null));
var inst_29799 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_29798,opts);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(67),inst_29799);
} else {
if((state_val_29827 === (51))){
var inst_29758 = (state_29826[(21)]);
var inst_29668 = (state_29826[(8)]);
var inst_29757 = (state_29826[(2)]);
var inst_29758__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_29668);
var state_29826__$1 = (function (){var statearr_29871 = state_29826;
(statearr_29871[(20)] = inst_29757);

(statearr_29871[(21)] = inst_29758__$1);

return statearr_29871;
})();
if(inst_29758__$1){
var statearr_29872_29967 = state_29826__$1;
(statearr_29872_29967[(1)] = (52));

} else {
var statearr_29873_29968 = state_29826__$1;
(statearr_29873_29968[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (25))){
var inst_29677 = (state_29826[(15)]);
var inst_29813 = (state_29826[(2)]);
var state_29826__$1 = (function (){var statearr_29874 = state_29826;
(statearr_29874[(12)] = inst_29813);

return statearr_29874;
})();
if(cljs.core.truth_(inst_29677)){
var statearr_29875_29969 = state_29826__$1;
(statearr_29875_29969[(1)] = (68));

} else {
var statearr_29876_29970 = state_29826__$1;
(statearr_29876_29970[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (34))){
var inst_29671 = (state_29826[(18)]);
var state_29826__$1 = state_29826;
var statearr_29877_29971 = state_29826__$1;
(statearr_29877_29971[(2)] = inst_29671);

(statearr_29877_29971[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (17))){
var inst_29705 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29878_29972 = state_29826__$1;
(statearr_29878_29972[(2)] = inst_29705);

(statearr_29878_29972[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (3))){
var inst_29824 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29826__$1,inst_29824);
} else {
if((state_val_29827 === (12))){
var inst_29669 = (state_29826[(14)]);
var state_29826__$1 = state_29826;
var statearr_29879_29973 = state_29826__$1;
(statearr_29879_29973[(2)] = inst_29669);

(statearr_29879_29973[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (2))){
var inst_29666 = (state_29826[(16)]);
var inst_29668 = (state_29826[(8)]);
var _ = (function (){var statearr_29880 = state_29826;
(statearr_29880[(4)] = cljs.core.cons((5),(state_29826[(4)])));

return statearr_29880;
})();
var inst_29666__$1 = fparts;
var inst_29667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29666__$1,(0),null);
var inst_29668__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29666__$1,(1),null);
var inst_29669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29666__$1,(2),null);
var inst_29670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29666__$1,(3),null);
var inst_29671 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_29668__$1);
var state_29826__$1 = (function (){var statearr_29881 = state_29826;
(statearr_29881[(14)] = inst_29669);

(statearr_29881[(16)] = inst_29666__$1);

(statearr_29881[(7)] = inst_29667);

(statearr_29881[(8)] = inst_29668__$1);

(statearr_29881[(18)] = inst_29671);

(statearr_29881[(9)] = inst_29670);

return statearr_29881;
})();
if(cljs.core.truth_(inst_29668__$1)){
var statearr_29882_29974 = state_29826__$1;
(statearr_29882_29974[(1)] = (6));

} else {
var statearr_29883_29975 = state_29826__$1;
(statearr_29883_29975[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (66))){
var inst_29805 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29884_29976 = state_29826__$1;
(statearr_29884_29976[(2)] = inst_29805);

(statearr_29884_29976[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (23))){
var inst_29667 = (state_29826[(7)]);
var inst_29668 = (state_29826[(8)]);
var inst_29670 = (state_29826[(9)]);
var inst_29707 = (state_29826[(10)]);
var inst_29709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29710 = [inst_29667,inst_29668,inst_29707,inst_29670];
var inst_29711 = (new cljs.core.PersistentVector(null,4,(5),inst_29709,inst_29710,null));
var inst_29712 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29711,opts);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(26),inst_29712);
} else {
if((state_val_29827 === (47))){
var inst_29668 = (state_29826[(8)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29668)){
var statearr_29885_29977 = state_29826__$1;
(statearr_29885_29977[(1)] = (60));

} else {
var statearr_29886_29978 = state_29826__$1;
(statearr_29886_29978[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (35))){
var inst_29725 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29887_29979 = state_29826__$1;
(statearr_29887_29979[(2)] = inst_29725);

(statearr_29887_29979[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (19))){
var inst_29669 = (state_29826[(14)]);
var inst_29668 = (state_29826[(8)]);
var inst_29695 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_29668);
var inst_29696 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29695),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29669)].join('');
var inst_29697 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_29696);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(22),inst_29697);
} else {
if((state_val_29827 === (57))){
var inst_29784 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29888_29980 = state_29826__$1;
(statearr_29888_29980[(2)] = inst_29784);

(statearr_29888_29980[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (68))){
var inst_29813 = (state_29826[(12)]);
var inst_29815 = fluree.db.query.range.coerce_tag_flakes(db,inst_29813);
var state_29826__$1 = state_29826;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29826__$1,(71),inst_29815);
} else {
if((state_val_29827 === (11))){
var inst_29682 = (state_29826[(17)]);
var inst_29682__$1 = (state_29826[(2)]);
var inst_29683 = cljs.core.not(inst_29682__$1);
var state_29826__$1 = (function (){var statearr_29890 = state_29826;
(statearr_29890[(17)] = inst_29682__$1);

return statearr_29890;
})();
if(inst_29683){
var statearr_29891_29981 = state_29826__$1;
(statearr_29891_29981[(1)] = (12));

} else {
var statearr_29892_29982 = state_29826__$1;
(statearr_29892_29982[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (9))){
var inst_29669 = (state_29826[(14)]);
var inst_29679 = typeof inst_29669 === 'string';
var state_29826__$1 = state_29826;
var statearr_29893_29983 = state_29826__$1;
(statearr_29893_29983[(2)] = inst_29679);

(statearr_29893_29983[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (5))){
var _ = (function (){var statearr_29894 = state_29826;
(statearr_29894[(4)] = cljs.core.rest((state_29826[(4)])));

return statearr_29894;
})();
var state_29826__$1 = state_29826;
var ex29889 = (state_29826__$1[(2)]);
var statearr_29895_29984 = state_29826__$1;
(statearr_29895_29984[(5)] = ex29889);


if((ex29889 instanceof Error)){
var statearr_29896_29985 = state_29826__$1;
(statearr_29896_29985[(1)] = (4));

(statearr_29896_29985[(5)] = null);

} else {
throw ex29889;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (14))){
var inst_29667 = (state_29826[(7)]);
var inst_29707 = (state_29826[(2)]);
var state_29826__$1 = (function (){var statearr_29897 = state_29826;
(statearr_29897[(10)] = inst_29707);

return statearr_29897;
})();
if(cljs.core.truth_(inst_29667)){
var statearr_29898_29986 = state_29826__$1;
(statearr_29898_29986[(1)] = (23));

} else {
var statearr_29899_29987 = state_29826__$1;
(statearr_29899_29987[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (45))){
var inst_29746 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29900_29988 = state_29826__$1;
(statearr_29900_29988[(2)] = inst_29746);

(statearr_29900_29988[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (53))){
var inst_29758 = (state_29826[(21)]);
var state_29826__$1 = state_29826;
var statearr_29901_29989 = state_29826__$1;
(statearr_29901_29989[(2)] = inst_29758);

(statearr_29901_29989[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (26))){
var inst_29714 = (state_29826[(2)]);
var inst_29715 = fluree.db.util.async.throw_err(inst_29714);
var state_29826__$1 = state_29826;
var statearr_29902_29990 = state_29826__$1;
(statearr_29902_29990[(2)] = inst_29715);

(statearr_29902_29990[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (16))){
var inst_29669 = (state_29826[(14)]);
var inst_29693 = typeof inst_29669 === 'string';
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29693)){
var statearr_29903_29991 = state_29826__$1;
(statearr_29903_29991[(1)] = (19));

} else {
var statearr_29904_29992 = state_29826__$1;
(statearr_29904_29992[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (38))){
var inst_29811 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
var statearr_29905_29993 = state_29826__$1;
(statearr_29905_29993[(2)] = inst_29811);

(statearr_29905_29993[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (30))){
var inst_29671 = (state_29826[(18)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29671)){
var statearr_29906_29994 = state_29826__$1;
(statearr_29906_29994[(1)] = (33));

} else {
var statearr_29907_29995 = state_29826__$1;
(statearr_29907_29995[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (10))){
var inst_29677 = (state_29826[(15)]);
var state_29826__$1 = state_29826;
var statearr_29908_29996 = state_29826__$1;
(statearr_29908_29996[(2)] = inst_29677);

(statearr_29908_29996[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (18))){
var inst_29690 = (state_29826[(2)]);
var inst_29691 = fluree.db.util.async.throw_err(inst_29690);
var state_29826__$1 = state_29826;
var statearr_29909_29997 = state_29826__$1;
(statearr_29909_29997[(2)] = inst_29691);

(statearr_29909_29997[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (52))){
var inst_29707 = (state_29826[(10)]);
var inst_29760 = cljs.core.int_QMARK_(inst_29707);
var state_29826__$1 = state_29826;
var statearr_29910_29998 = state_29826__$1;
(statearr_29910_29998[(2)] = inst_29760);

(statearr_29910_29998[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (67))){
var inst_29801 = (state_29826[(2)]);
var inst_29802 = fluree.db.util.async.throw_err(inst_29801);
var state_29826__$1 = state_29826;
var statearr_29911_29999 = state_29826__$1;
(statearr_29911_29999[(2)] = inst_29802);

(statearr_29911_29999[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (71))){
var inst_29817 = (state_29826[(2)]);
var inst_29818 = fluree.db.util.async.throw_err(inst_29817);
var state_29826__$1 = state_29826;
var statearr_29912_30000 = state_29826__$1;
(statearr_29912_30000[(2)] = inst_29818);

(statearr_29912_30000[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (42))){
var inst_29749 = (state_29826[(2)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29749)){
var statearr_29913_30001 = state_29826__$1;
(statearr_29913_30001[(1)] = (46));

} else {
var statearr_29914_30002 = state_29826__$1;
(statearr_29914_30002[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (37))){
var inst_29668 = (state_29826[(8)]);
var state_29826__$1 = state_29826;
if(cljs.core.truth_(inst_29668)){
var statearr_29915_30003 = state_29826__$1;
(statearr_29915_30003[(1)] = (40));

} else {
var statearr_29916_30004 = state_29826__$1;
(statearr_29916_30004[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (63))){
var inst_29792 = (state_29826[(2)]);
var inst_29793 = fluree.db.util.async.throw_err(inst_29792);
var state_29826__$1 = state_29826;
var statearr_29917_30005 = state_29826__$1;
(statearr_29917_30005[(2)] = inst_29793);

(statearr_29917_30005[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (8))){
var inst_29677 = (state_29826[(15)]);
var inst_29677__$1 = (state_29826[(2)]);
var state_29826__$1 = (function (){var statearr_29918 = state_29826;
(statearr_29918[(15)] = inst_29677__$1);

return statearr_29918;
})();
if(cljs.core.truth_(inst_29677__$1)){
var statearr_29919_30006 = state_29826__$1;
(statearr_29919_30006[(1)] = (9));

} else {
var statearr_29920_30007 = state_29826__$1;
(statearr_29920_30007[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29827 === (49))){
var inst_29677 = (state_29826[(15)]);
var inst_29666 = (state_29826[(16)]);
var inst_29751 = (state_29826[(13)]);
var inst_29682 = (state_29826[(17)]);
var inst_29667 = (state_29826[(7)]);
var inst_29668 = (state_29826[(8)]);
var inst_29671 = (state_29826[(18)]);
var inst_29670 = (state_29826[(9)]);
var inst_29707 = (state_29826[(10)]);
var inst_29753 = (function (){var obj_fn = inst_29751;
var t = inst_29670;
var p = inst_29668;
var idx_predicate_QMARK_ = inst_29671;
var o = inst_29707;
var tag_predicate_QMARK_ = inst_29677;
var temp__5751__auto__ = inst_29751;
var s = inst_29667;
var o_coerce_QMARK_ = inst_29682;
var vec__29663 = inst_29666;
return (function (x){
var and__4221__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4221__auto__;
}
});
})();
var state_29826__$1 = state_29826;
var statearr_29921_30008 = state_29826__$1;
(statearr_29921_30008[(2)] = inst_29753);

(statearr_29921_30008[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__14778__auto__ = null;
var fluree$db$query$range$state_machine__14778__auto____0 = (function (){
var statearr_29922 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29922[(0)] = fluree$db$query$range$state_machine__14778__auto__);

(statearr_29922[(1)] = (1));

return statearr_29922;
});
var fluree$db$query$range$state_machine__14778__auto____1 = (function (state_29826){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_29826);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e29923){var ex__14781__auto__ = e29923;
var statearr_29924_30009 = state_29826;
(statearr_29924_30009[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_29826[(4)]))){
var statearr_29925_30010 = state_29826;
(statearr_29925_30010[(1)] = cljs.core.first((state_29826[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30011 = state_29826;
state_29826 = G__30011;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__14778__auto__ = function(state_29826){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__14778__auto____1.call(this,state_29826);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__14778__auto____0;
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__14778__auto____1;
return fluree$db$query$range$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_29926 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_29926[(6)] = c__14852__auto__);

return statearr_29926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__30013 = arguments.length;
switch (G__30013) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_30048){
var state_val_30049 = (state_30048[(1)]);
if((state_val_30049 === (7))){
var inst_30035 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_30036 = ["Invalid collection name: ",inst_30035].join('');
var inst_30037 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30038 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_30039 = cljs.core.PersistentHashMap.fromArrays(inst_30037,inst_30038);
var inst_30040 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_30036,inst_30039);
var inst_30041 = (function(){throw inst_30040})();
var state_30048__$1 = state_30048;
var statearr_30050_30070 = state_30048__$1;
(statearr_30050_30070[(2)] = inst_30041);

(statearr_30050_30070[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30049 === (1))){
var state_30048__$1 = state_30048;
var statearr_30051_30071 = state_30048__$1;
(statearr_30051_30071[(2)] = null);

(statearr_30051_30071[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30049 === (4))){
var inst_30014 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
var statearr_30052_30072 = state_30048__$1;
(statearr_30052_30072[(2)] = inst_30014);

(statearr_30052_30072[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30049 === (6))){
var inst_30020 = (state_30048[(7)]);
var inst_30022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30023 = fluree.db.flake.max_subject_id(inst_30020);
var inst_30024 = [inst_30023];
var inst_30025 = (new cljs.core.PersistentVector(null,1,(5),inst_30022,inst_30024,null));
var inst_30026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30027 = fluree.db.flake.min_subject_id(inst_30020);
var inst_30028 = [inst_30027];
var inst_30029 = (new cljs.core.PersistentVector(null,1,(5),inst_30026,inst_30028,null));
var inst_30030 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_30025,cljs.core._LT__EQ_,inst_30029,opts);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30048__$1,(9),inst_30030);
} else {
if((state_val_30049 === (3))){
var inst_30046 = (state_30048[(2)]);
var state_30048__$1 = state_30048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30048__$1,inst_30046);
} else {
if((state_val_30049 === (2))){
var inst_30020 = (state_30048[(7)]);
var _ = (function (){var statearr_30054 = state_30048;
(statearr_30054[(4)] = cljs.core.cons((5),(state_30048[(4)])));

return statearr_30054;
})();
var inst_30020__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_30048__$1 = (function (){var statearr_30055 = state_30048;
(statearr_30055[(7)] = inst_30020__$1);

return statearr_30055;
})();
if(cljs.core.truth_(inst_30020__$1)){
var statearr_30056_30073 = state_30048__$1;
(statearr_30056_30073[(1)] = (6));

} else {
var statearr_30057_30074 = state_30048__$1;
(statearr_30057_30074[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30049 === (9))){
var inst_30032 = (state_30048[(2)]);
var inst_30033 = fluree.db.util.async.throw_err(inst_30032);
var state_30048__$1 = state_30048;
var statearr_30058_30075 = state_30048__$1;
(statearr_30058_30075[(2)] = inst_30033);

(statearr_30058_30075[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30049 === (5))){
var _ = (function (){var statearr_30059 = state_30048;
(statearr_30059[(4)] = cljs.core.rest((state_30048[(4)])));

return statearr_30059;
})();
var state_30048__$1 = state_30048;
var ex30053 = (state_30048__$1[(2)]);
var statearr_30060_30076 = state_30048__$1;
(statearr_30060_30076[(5)] = ex30053);


var statearr_30061_30077 = state_30048__$1;
(statearr_30061_30077[(1)] = (4));

(statearr_30061_30077[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30049 === (8))){
var inst_30043 = (state_30048[(2)]);
var _ = (function (){var statearr_30062 = state_30048;
(statearr_30062[(4)] = cljs.core.rest((state_30048[(4)])));

return statearr_30062;
})();
var state_30048__$1 = state_30048;
var statearr_30063_30078 = state_30048__$1;
(statearr_30063_30078[(2)] = inst_30043);

(statearr_30063_30078[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__14778__auto__ = null;
var fluree$db$query$range$state_machine__14778__auto____0 = (function (){
var statearr_30064 = [null,null,null,null,null,null,null,null];
(statearr_30064[(0)] = fluree$db$query$range$state_machine__14778__auto__);

(statearr_30064[(1)] = (1));

return statearr_30064;
});
var fluree$db$query$range$state_machine__14778__auto____1 = (function (state_30048){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_30048);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e30065){var ex__14781__auto__ = e30065;
var statearr_30066_30079 = state_30048;
(statearr_30066_30079[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_30048[(4)]))){
var statearr_30067_30080 = state_30048;
(statearr_30067_30080[(1)] = cljs.core.first((state_30048[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__30081 = state_30048;
state_30048 = G__30081;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__14778__auto__ = function(state_30048){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__14778__auto____1.call(this,state_30048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__14778__auto____0;
fluree$db$query$range$state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__14778__auto____1;
return fluree$db$query$range$state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_30068 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_30068[(6)] = c__14852__auto__);

return statearr_30068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__30085 = flakes;
var vec__30086 = G__30085;
var seq__30087 = cljs.core.seq(vec__30086);
var first__30088 = cljs.core.first(seq__30087);
var seq__30087__$1 = cljs.core.next(seq__30087);
var flake_SINGLEQUOTE_ = first__30088;
var r = seq__30087__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__30085__$1 = G__30085;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__30094 = G__30085__$1;
var seq__30095 = cljs.core.seq(vec__30094);
var first__30096 = cljs.core.first(seq__30095);
var seq__30095__$1 = cljs.core.next(seq__30095);
var flake_SINGLEQUOTE___$1 = first__30096;
var r__$1 = seq__30095__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e30098){var e = e30098;
return null;
}})();
var map__30097 = cmd_map;
var map__30097__$1 = cljs.core.__destructure_map(map__30097);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30097__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30097__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30097__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30097__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30097__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30097__$1,cljs.core.cst$kw$expire);
var G__30099 = r__$1;
var G__30100 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__30085__$1 = G__30099;
result_STAR___$1 = G__30100;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__30109 = blocks;
var vec__30110 = G__30109;
var seq__30111 = cljs.core.seq(vec__30110);
var first__30112 = cljs.core.first(seq__30111);
var seq__30111__$1 = cljs.core.next(seq__30111);
var block_SINGLEQUOTE_ = first__30112;
var r = seq__30111__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__30109__$1 = G__30109;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__30117 = G__30109__$1;
var seq__30118 = cljs.core.seq(vec__30117);
var first__30119 = cljs.core.first(seq__30118);
var seq__30118__$1 = cljs.core.next(seq__30118);
var block_SINGLEQUOTE___$1 = first__30119;
var r__$1 = seq__30118__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__30120 = block_SINGLEQUOTE___$1;
var map__30120__$1 = cljs.core.__destructure_map(map__30120);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30120__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30120__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30120__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30101_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30101_SHARP_.p,(2))){
return p1__30101_SHARP_.o;
} else {
return null;
}
});})(G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30102_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30102_SHARP_.p,(1))){
return p1__30102_SHARP_.o;
} else {
return null;
}
});})(G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,hash,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30103_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30103_SHARP_.p,(5))){
return p1__30103_SHARP_.o;
} else {
return null;
}
});})(G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,hash,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,hash,instant,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30104_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30104_SHARP_.p,(7))){
return p1__30104_SHARP_.o;
} else {
return null;
}
});})(G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,hash,instant,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__30105_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30105_SHARP_.p,(106));
});})(G__30109__$1,result_STAR___$1,map__30120,map__30120__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__30117,seq__30118,first__30119,seq__30118__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__30109,vec__30110,seq__30111,first__30112,seq__30111__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__30121 = r__$1;
var G__30122 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__30109__$1 = G__30121;
result_STAR___$1 = G__30122;
continue;
}
break;
}
});
