// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4223__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_25308){
var state_val_25309 = (state_25308[(1)]);
if((state_val_25309 === (7))){
var inst_25303 = (state_25308[(2)]);
var _ = (function (){var statearr_25310 = state_25308;
(statearr_25310[(4)] = cljs.core.rest((state_25308[(4)])));

return statearr_25310;
})();
var state_25308__$1 = state_25308;
var statearr_25311_25333 = state_25308__$1;
(statearr_25311_25333[(2)] = inst_25303);

(statearr_25311_25333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (1))){
var state_25308__$1 = state_25308;
var statearr_25312_25334 = state_25308__$1;
(statearr_25312_25334[(2)] = null);

(statearr_25312_25334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (4))){
var inst_25265 = (state_25308[(2)]);
var state_25308__$1 = state_25308;
var statearr_25313_25335 = state_25308__$1;
(statearr_25313_25335[(2)] = inst_25265);

(statearr_25313_25335[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (6))){
var inst_25290 = (state_25308[(7)]);
var inst_25283 = (state_25308[(8)]);
var inst_25289 = cljs.core.seq(inst_25283);
var inst_25290__$1 = cljs.core.first(inst_25289);
var inst_25291 = cljs.core.next(inst_25289);
var inst_25292 = cljs.core.not(inst_25290__$1);
var state_25308__$1 = (function (){var statearr_25314 = state_25308;
(statearr_25314[(9)] = inst_25291);

(statearr_25314[(7)] = inst_25290__$1);

return statearr_25314;
})();
if(inst_25292){
var statearr_25315_25336 = state_25308__$1;
(statearr_25315_25336[(1)] = (8));

} else {
var statearr_25316_25337 = state_25308__$1;
(statearr_25316_25337[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (3))){
var inst_25306 = (state_25308[(2)]);
var state_25308__$1 = state_25308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25308__$1,inst_25306);
} else {
if((state_val_25309 === (2))){
var _ = (function (){var statearr_25317 = state_25308;
(statearr_25317[(4)] = cljs.core.cons((5),(state_25308[(4)])));

return statearr_25317;
})();
var inst_25278 = chs;
var inst_25279 = cljs.core.seq(inst_25278);
var inst_25280 = cljs.core.first(inst_25279);
var inst_25281 = cljs.core.next(inst_25279);
var inst_25282 = coll;
var inst_25283 = inst_25278;
var inst_25284 = inst_25282;
var state_25308__$1 = (function (){var statearr_25318 = state_25308;
(statearr_25318[(10)] = inst_25284);

(statearr_25318[(11)] = inst_25280);

(statearr_25318[(12)] = inst_25281);

(statearr_25318[(8)] = inst_25283);

return statearr_25318;
})();
var statearr_25319_25338 = state_25308__$1;
(statearr_25319_25338[(2)] = null);

(statearr_25319_25338[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (11))){
var inst_25284 = (state_25308[(10)]);
var inst_25291 = (state_25308[(9)]);
var inst_25296 = (state_25308[(2)]);
var inst_25297 = fluree.db.util.async.throw_err(inst_25296);
var inst_25298 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25284,inst_25297);
var inst_25283 = inst_25291;
var inst_25284__$1 = inst_25298;
var state_25308__$1 = (function (){var statearr_25321 = state_25308;
(statearr_25321[(10)] = inst_25284__$1);

(statearr_25321[(8)] = inst_25283);

return statearr_25321;
})();
var statearr_25322_25339 = state_25308__$1;
(statearr_25322_25339[(2)] = null);

(statearr_25322_25339[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (9))){
var inst_25290 = (state_25308[(7)]);
var state_25308__$1 = state_25308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25308__$1,(11),inst_25290);
} else {
if((state_val_25309 === (5))){
var _ = (function (){var statearr_25323 = state_25308;
(statearr_25323[(4)] = cljs.core.rest((state_25308[(4)])));

return statearr_25323;
})();
var state_25308__$1 = state_25308;
var ex25320 = (state_25308__$1[(2)]);
var statearr_25324_25340 = state_25308__$1;
(statearr_25324_25340[(5)] = ex25320);


var statearr_25325_25341 = state_25308__$1;
(statearr_25325_25341[(1)] = (4));

(statearr_25325_25341[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (10))){
var inst_25301 = (state_25308[(2)]);
var state_25308__$1 = state_25308;
var statearr_25326_25342 = state_25308__$1;
(statearr_25326_25342[(2)] = inst_25301);

(statearr_25326_25342[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25309 === (8))){
var inst_25284 = (state_25308[(10)]);
var state_25308__$1 = state_25308;
var statearr_25327_25343 = state_25308__$1;
(statearr_25327_25343[(2)] = inst_25284);

(statearr_25327_25343[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_25328 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25328[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto__);

(statearr_25328[(1)] = (1));

return statearr_25328;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto____1 = (function (state_25308){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_25308);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e25329){var ex__14781__auto__ = e25329;
var statearr_25330_25344 = state_25308;
(statearr_25330_25344[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_25308[(4)]))){
var statearr_25331_25345 = state_25308;
(statearr_25331_25345[(1)] = cljs.core.first((state_25308[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__25346 = state_25308;
state_25308 = G__25346;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto__ = function(state_25308){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto____1.call(this,state_25308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_25332 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_25332[(6)] = c__14852__auto__);

return statearr_25332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__14852__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__14853__auto__ = (function (){var switch__14777__auto__ = (function (state_25372){
var state_val_25373 = (state_25372[(1)]);
if((state_val_25373 === (7))){
var inst_25367 = (state_25372[(2)]);
var _ = (function (){var statearr_25374 = state_25372;
(statearr_25374[(4)] = cljs.core.rest((state_25372[(4)])));

return statearr_25374;
})();
var state_25372__$1 = state_25372;
var statearr_25375_25397 = state_25372__$1;
(statearr_25375_25397[(2)] = inst_25367);

(statearr_25375_25397[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (1))){
var state_25372__$1 = state_25372;
var statearr_25376_25398 = state_25372__$1;
(statearr_25376_25398[(2)] = null);

(statearr_25376_25398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (4))){
var inst_25347 = (state_25372[(2)]);
var state_25372__$1 = state_25372;
var statearr_25377_25399 = state_25372__$1;
(statearr_25377_25399[(2)] = inst_25347);

(statearr_25377_25399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (6))){
var state_25372__$1 = state_25372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25372__$1,(8),chan);
} else {
if((state_val_25373 === (3))){
var inst_25370 = (state_25372[(2)]);
var state_25372__$1 = state_25372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25372__$1,inst_25370);
} else {
if((state_val_25373 === (2))){
var _ = (function (){var statearr_25378 = state_25372;
(statearr_25378[(4)] = cljs.core.cons((5),(state_25372[(4)])));

return statearr_25378;
})();
var inst_25353 = coll;
var inst_25354 = inst_25353;
var state_25372__$1 = (function (){var statearr_25379 = state_25372;
(statearr_25379[(7)] = inst_25354);

return statearr_25379;
})();
var statearr_25380_25400 = state_25372__$1;
(statearr_25380_25400[(2)] = null);

(statearr_25380_25400[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (11))){
var inst_25365 = (state_25372[(2)]);
var state_25372__$1 = state_25372;
var statearr_25382_25401 = state_25372__$1;
(statearr_25382_25401[(2)] = inst_25365);

(statearr_25382_25401[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (9))){
var inst_25354 = (state_25372[(7)]);
var state_25372__$1 = state_25372;
var statearr_25383_25402 = state_25372__$1;
(statearr_25383_25402[(2)] = inst_25354);

(statearr_25383_25402[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (5))){
var _ = (function (){var statearr_25384 = state_25372;
(statearr_25384[(4)] = cljs.core.rest((state_25372[(4)])));

return statearr_25384;
})();
var state_25372__$1 = state_25372;
var ex25381 = (state_25372__$1[(2)]);
var statearr_25385_25403 = state_25372__$1;
(statearr_25385_25403[(5)] = ex25381);


var statearr_25386_25404 = state_25372__$1;
(statearr_25386_25404[(1)] = (4));

(statearr_25386_25404[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (10))){
var inst_25358 = (state_25372[(8)]);
var inst_25354 = (state_25372[(7)]);
var inst_25362 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25354,inst_25358);
var inst_25354__$1 = inst_25362;
var state_25372__$1 = (function (){var statearr_25387 = state_25372;
(statearr_25387[(7)] = inst_25354__$1);

return statearr_25387;
})();
var statearr_25388_25405 = state_25372__$1;
(statearr_25388_25405[(2)] = null);

(statearr_25388_25405[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25373 === (8))){
var inst_25358 = (state_25372[(8)]);
var inst_25357 = (state_25372[(2)]);
var inst_25358__$1 = fluree.db.util.async.throw_err(inst_25357);
var inst_25359 = (inst_25358__$1 == null);
var state_25372__$1 = (function (){var statearr_25389 = state_25372;
(statearr_25389[(8)] = inst_25358__$1);

return statearr_25389;
})();
if(cljs.core.truth_(inst_25359)){
var statearr_25390_25406 = state_25372__$1;
(statearr_25390_25406[(1)] = (9));

} else {
var statearr_25391_25407 = state_25372__$1;
(statearr_25391_25407[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__14778__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__14778__auto____0 = (function (){
var statearr_25392 = [null,null,null,null,null,null,null,null,null];
(statearr_25392[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__14778__auto__);

(statearr_25392[(1)] = (1));

return statearr_25392;
});
var fluree$db$util$async$into_QMARK__$_state_machine__14778__auto____1 = (function (state_25372){
while(true){
var ret_value__14779__auto__ = (function (){try{while(true){
var result__14780__auto__ = switch__14777__auto__(state_25372);
if(cljs.core.keyword_identical_QMARK_(result__14780__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14780__auto__;
}
break;
}
}catch (e25393){var ex__14781__auto__ = e25393;
var statearr_25394_25408 = state_25372;
(statearr_25394_25408[(2)] = ex__14781__auto__);


if(cljs.core.seq((state_25372[(4)]))){
var statearr_25395_25409 = state_25372;
(statearr_25395_25409[(1)] = cljs.core.first((state_25372[(4)])));

} else {
throw ex__14781__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14779__auto__,cljs.core.cst$kw$recur)){
var G__25410 = state_25372;
state_25372 = G__25410;
continue;
} else {
return ret_value__14779__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__14778__auto__ = function(state_25372){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__14778__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__14778__auto____1.call(this,state_25372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__14778__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__14778__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__14778__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__14778__auto__;
})()
})();
var state__14854__auto__ = (function (){var statearr_25396 = (f__14853__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14853__auto__.cljs$core$IFn$_invoke$arity$0() : f__14853__auto__.call(null));
(statearr_25396[(6)] = c__14852__auto__);

return statearr_25396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14854__auto__);
}));

return c__14852__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
