// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__78721 = (line + (1));
var G__78722 = (1);
var G__78723 = (counter + (1));
line = G__78721;
col = G__78722;
counter = G__78723;
continue;
} else {
var G__78724 = line;
var G__78725 = (col + (1));
var G__78726 = (counter + (1));
line = G__78724;
col = G__78725;
counter = G__78726;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__78727 = cljs.core.next(chars);
var G__78728 = (n__$1 - (1));
chars = G__78727;
n__$1 = G__78728;
continue;
} else {
var G__78729 = cljs.core.next(chars);
var G__78730 = n__$1;
chars = G__78729;
n__$1 = G__78730;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__78731){
var map__78732 = p__78731;
var map__78732__$1 = cljs.core.__destructure_map(map__78732);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78732__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78732__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78732__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78732__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__78733_78741 = cljs.core.seq(full_reasons);
var chunk__78734_78742 = null;
var count__78735_78743 = (0);
var i__78736_78744 = (0);
while(true){
if((i__78736_78744 < count__78735_78743)){
var r_78745 = chunk__78734_78742.cljs$core$IIndexed$_nth$arity$2(null,i__78736_78744);
instaparse.failure.print_reason(r_78745);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__78746 = seq__78733_78741;
var G__78747 = chunk__78734_78742;
var G__78748 = count__78735_78743;
var G__78749 = (i__78736_78744 + (1));
seq__78733_78741 = G__78746;
chunk__78734_78742 = G__78747;
count__78735_78743 = G__78748;
i__78736_78744 = G__78749;
continue;
} else {
var temp__5753__auto___78750 = cljs.core.seq(seq__78733_78741);
if(temp__5753__auto___78750){
var seq__78733_78751__$1 = temp__5753__auto___78750;
if(cljs.core.chunked_seq_QMARK_(seq__78733_78751__$1)){
var c__4649__auto___78752 = cljs.core.chunk_first(seq__78733_78751__$1);
var G__78753 = cljs.core.chunk_rest(seq__78733_78751__$1);
var G__78754 = c__4649__auto___78752;
var G__78755 = cljs.core.count(c__4649__auto___78752);
var G__78756 = (0);
seq__78733_78741 = G__78753;
chunk__78734_78742 = G__78754;
count__78735_78743 = G__78755;
i__78736_78744 = G__78756;
continue;
} else {
var r_78757 = cljs.core.first(seq__78733_78751__$1);
instaparse.failure.print_reason(r_78757);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__78758 = cljs.core.next(seq__78733_78751__$1);
var G__78759 = null;
var G__78760 = (0);
var G__78761 = (0);
seq__78733_78741 = G__78758;
chunk__78734_78742 = G__78759;
count__78735_78743 = G__78760;
i__78736_78744 = G__78761;
continue;
}
} else {
}
}
break;
}

var seq__78737 = cljs.core.seq(partial_reasons);
var chunk__78738 = null;
var count__78739 = (0);
var i__78740 = (0);
while(true){
if((i__78740 < count__78739)){
var r = chunk__78738.cljs$core$IIndexed$_nth$arity$2(null,i__78740);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__78762 = seq__78737;
var G__78763 = chunk__78738;
var G__78764 = count__78739;
var G__78765 = (i__78740 + (1));
seq__78737 = G__78762;
chunk__78738 = G__78763;
count__78739 = G__78764;
i__78740 = G__78765;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__78737);
if(temp__5753__auto__){
var seq__78737__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__78737__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__78737__$1);
var G__78766 = cljs.core.chunk_rest(seq__78737__$1);
var G__78767 = c__4649__auto__;
var G__78768 = cljs.core.count(c__4649__auto__);
var G__78769 = (0);
seq__78737 = G__78766;
chunk__78738 = G__78767;
count__78739 = G__78768;
i__78740 = G__78769;
continue;
} else {
var r = cljs.core.first(seq__78737__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__78770 = cljs.core.next(seq__78737__$1);
var G__78771 = null;
var G__78772 = (0);
var G__78773 = (0);
seq__78737 = G__78770;
chunk__78738 = G__78771;
count__78739 = G__78772;
i__78740 = G__78773;
continue;
}
} else {
return null;
}
}
break;
}
});
