// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__41731(s__41732){
return (new cljs.core.LazySeq(null,(function (){
var s__41732__$1 = s__41732;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__41732__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__41737 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41737,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41737,(1),null);
var iterys__4618__auto__ = ((function (s__41732__$1,vec__41737,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__41731_$_iter__41733(s__41734){
return (new cljs.core.LazySeq(null,((function (s__41732__$1,vec__41737,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__41734__$1 = s__41734;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__41734__$1);
if(temp__5753__auto____$1){
var s__41734__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41734__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__41734__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__41736 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__41735 = (0);
while(true){
if((i__41735 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__41735);
cljs.core.chunk_append(b__41736,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__41789 = (i__41735 + (1));
i__41735 = G__41789;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41736),tailrecursion$priority_map$iter__41731_$_iter__41733(cljs.core.chunk_rest(s__41734__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41736),null);
}
} else {
var item = cljs.core.first(s__41734__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__41731_$_iter__41733(cljs.core.rest(s__41734__$2)));
}
} else {
return null;
}
break;
}
});})(s__41732__$1,vec__41737,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__41732__$1,vec__41737,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__41731(cljs.core.rest(s__41732__$1)));
} else {
var G__41790 = cljs.core.rest(s__41732__$1);
s__41732__$1 = G__41790;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__41740(s__41741){
return (new cljs.core.LazySeq(null,(function (){
var s__41741__$1 = s__41741;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__41741__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__41746 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41746,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41746,(1),null);
var iterys__4618__auto__ = ((function (s__41741__$1,vec__41746,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__41740_$_iter__41742(s__41743){
return (new cljs.core.LazySeq(null,((function (s__41741__$1,vec__41746,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__41743__$1 = s__41743;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__41743__$1);
if(temp__5753__auto____$1){
var s__41743__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41743__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__41743__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__41745 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__41744 = (0);
while(true){
if((i__41744 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__41744);
cljs.core.chunk_append(b__41745,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__41791 = (i__41744 + (1));
i__41744 = G__41791;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41745),tailrecursion$priority_map$iter__41740_$_iter__41742(cljs.core.chunk_rest(s__41743__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41745),null);
}
} else {
var item = cljs.core.first(s__41743__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__41740_$_iter__41742(cljs.core.rest(s__41743__$2)));
}
} else {
return null;
}
break;
}
});})(s__41741__$1,vec__41746,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__41741__$1,vec__41746,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__41740(cljs.core.rest(s__41741__$1)));
} else {
var G__41792 = cljs.core.rest(s__41741__$1);
s__41741__$1 = G__41792;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__41749 = item;
var G__41750 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__41749,G__41750) : self__.item__GT_priority.call(null,G__41749,G__41750));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__41751(s__41752){
return (new cljs.core.LazySeq(null,(function (){
var s__41752__$1 = s__41752;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__41752__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__41757 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41757,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41757,(1),null);
var iterys__4618__auto__ = ((function (s__41752__$1,vec__41757,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__41751_$_iter__41753(s__41754){
return (new cljs.core.LazySeq(null,((function (s__41752__$1,vec__41757,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__41754__$1 = s__41754;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__41754__$1);
if(temp__5753__auto____$1){
var s__41754__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41754__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__41754__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__41756 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__41755 = (0);
while(true){
if((i__41755 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__41755);
cljs.core.chunk_append(b__41756,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__41793 = (i__41755 + (1));
i__41755 = G__41793;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41756),tailrecursion$priority_map$iter__41751_$_iter__41753(cljs.core.chunk_rest(s__41754__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41756),null);
}
} else {
var item = cljs.core.first(s__41754__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__41751_$_iter__41753(cljs.core.rest(s__41754__$2)));
}
} else {
return null;
}
break;
}
});})(s__41752__$1,vec__41757,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__41752__$1,vec__41757,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__41751(cljs.core.rest(s__41752__$1)));
} else {
var G__41794 = cljs.core.rest(s__41752__$1);
s__41752__$1 = G__41794;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__41760(s__41761){
return (new cljs.core.LazySeq(null,(function (){
var s__41761__$1 = s__41761;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__41761__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__41766 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41766,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41766,(1),null);
var iterys__4618__auto__ = ((function (s__41761__$1,vec__41766,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__41760_$_iter__41762(s__41763){
return (new cljs.core.LazySeq(null,((function (s__41761__$1,vec__41766,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__41763__$1 = s__41763;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__41763__$1);
if(temp__5753__auto____$1){
var s__41763__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41763__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__41763__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__41765 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__41764 = (0);
while(true){
if((i__41764 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__41764);
cljs.core.chunk_append(b__41765,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__41795 = (i__41764 + (1));
i__41764 = G__41795;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41765),tailrecursion$priority_map$iter__41760_$_iter__41762(cljs.core.chunk_rest(s__41763__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41765),null);
}
} else {
var item = cljs.core.first(s__41763__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__41760_$_iter__41762(cljs.core.rest(s__41763__$2)));
}
} else {
return null;
}
break;
}
});})(s__41761__$1,vec__41766,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__41761__$1,vec__41766,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__41760(cljs.core.rest(s__41761__$1)));
} else {
var G__41796 = cljs.core.rest(s__41761__$1);
s__41761__$1 = G__41796;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__41797 = null;
var G__41797__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__41797__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__41797 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__41797__2.call(this,self__,item);
case 3:
return G__41797__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__41797.cljs$core$IFn$_invoke$arity$2 = G__41797__2;
G__41797.cljs$core$IFn$_invoke$arity$3 = G__41797__3;
return G__41797;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args41730){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args41730)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__41769 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__41769.cljs$core$IFn$_invoke$arity$1 ? fexpr__41769.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__41769.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__41770(s__41771){
return (new cljs.core.LazySeq(null,(function (){
var s__41771__$1 = s__41771;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__41771__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__41776 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41776,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41776,(1),null);
var iterys__4618__auto__ = ((function (s__41771__$1,vec__41776,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__41770_$_iter__41772(s__41773){
return (new cljs.core.LazySeq(null,((function (s__41771__$1,vec__41776,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__41773__$1 = s__41773;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__41773__$1);
if(temp__5753__auto____$1){
var s__41773__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41773__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__41773__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__41775 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__41774 = (0);
while(true){
if((i__41774 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__41774);
cljs.core.chunk_append(b__41775,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__41798 = (i__41774 + (1));
i__41774 = G__41798;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41775),tailrecursion$priority_map$iter__41770_$_iter__41772(cljs.core.chunk_rest(s__41773__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41775),null);
}
} else {
var item = cljs.core.first(s__41773__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__41770_$_iter__41772(cljs.core.rest(s__41773__$2)));
}
} else {
return null;
}
break;
}
});})(s__41771__$1,vec__41776,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__41771__$1,vec__41776,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__41770(cljs.core.rest(s__41771__$1)));
} else {
var G__41799 = cljs.core.rest(s__41771__$1);
s__41771__$1 = G__41799;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__41779(s__41780){
return (new cljs.core.LazySeq(null,(function (){
var s__41780__$1 = s__41780;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__41780__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__41785 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41785,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41785,(1),null);
var iterys__4618__auto__ = ((function (s__41780__$1,vec__41785,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__41779_$_iter__41781(s__41782){
return (new cljs.core.LazySeq(null,((function (s__41780__$1,vec__41785,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__41782__$1 = s__41782;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__41782__$1);
if(temp__5753__auto____$1){
var s__41782__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41782__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__41782__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__41784 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__41783 = (0);
while(true){
if((i__41783 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__41783);
cljs.core.chunk_append(b__41784,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__41800 = (i__41783 + (1));
i__41783 = G__41800;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41784),tailrecursion$priority_map$iter__41779_$_iter__41781(cljs.core.chunk_rest(s__41782__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41784),null);
}
} else {
var item = cljs.core.first(s__41782__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__41779_$_iter__41781(cljs.core.rest(s__41782__$2)));
}
} else {
return null;
}
break;
}
});})(s__41780__$1,vec__41785,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__41780__$1,vec__41785,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__41779(cljs.core.rest(s__41780__$1)));
} else {
var G__41801 = cljs.core.rest(s__41780__$1);
s__41780__$1 = G__41801;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__41788 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__41788) : self__.keyfn.call(null,G__41788));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__41803 = arguments.length;
switch (G__41803) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4835__auto__ = [];
var len__4829__auto___41806 = arguments.length;
var i__4830__auto___41807 = (0);
while(true){
if((i__4830__auto___41807 < len__4829__auto___41806)){
args__4835__auto__.push((arguments[i__4830__auto___41807]));

var G__41808 = (i__4830__auto___41807 + (1));
i__4830__auto___41807 = G__41808;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__41809 = cljs.core.nnext(in$);
var G__41810 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__41809;
out = G__41810;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq41805){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41805));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___41813 = arguments.length;
var i__4830__auto___41814 = (0);
while(true){
if((i__4830__auto___41814 < len__4829__auto___41813)){
args__4835__auto__.push((arguments[i__4830__auto___41814]));

var G__41815 = (i__4830__auto___41814 + (1));
i__4830__auto___41814 = G__41815;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__41816 = cljs.core.nnext(in$);
var G__41817 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__41816;
out = G__41817;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq41811){
var G__41812 = cljs.core.first(seq41811);
var seq41811__$1 = cljs.core.next(seq41811);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41812,seq41811__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4835__auto__ = [];
var len__4829__auto___41820 = arguments.length;
var i__4830__auto___41821 = (0);
while(true){
if((i__4830__auto___41821 < len__4829__auto___41820)){
args__4835__auto__.push((arguments[i__4830__auto___41821]));

var G__41822 = (i__4830__auto___41821 + (1));
i__4830__auto___41821 = G__41822;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__41823 = cljs.core.nnext(in$);
var G__41824 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__41823;
out = G__41824;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq41818){
var G__41819 = cljs.core.first(seq41818);
var seq41818__$1 = cljs.core.next(seq41818);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41819,seq41818__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___41828 = arguments.length;
var i__4830__auto___41829 = (0);
while(true){
if((i__4830__auto___41829 < len__4829__auto___41828)){
args__4835__auto__.push((arguments[i__4830__auto___41829]));

var G__41830 = (i__4830__auto___41829 + (1));
i__4830__auto___41829 = G__41830;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__41831 = cljs.core.nnext(in$);
var G__41832 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__41831;
out = G__41832;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq41825){
var G__41826 = cljs.core.first(seq41825);
var seq41825__$1 = cljs.core.next(seq41825);
var G__41827 = cljs.core.first(seq41825__$1);
var seq41825__$2 = cljs.core.next(seq41825__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41826,G__41827,seq41825__$2);
}));

