// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73129 = arguments.length;
var i__4830__auto___73130 = (0);
while(true){
if((i__4830__auto___73130 < len__4829__auto___73129)){
args__4835__auto__.push((arguments[i__4830__auto___73130]));

var G__73131 = (i__4830__auto___73130 + (1));
i__4830__auto___73130 = G__73131;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__73123){
var vec__73124 = p__73123;
var map__73127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73124,(0),null);
var map__73127__$1 = cljs.core.__destructure_map(map__73127);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73127__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73127__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_(iv,key_ba,ba);
var G__73128 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__73128__$1 = (((G__73128 instanceof cljs.core.Keyword))?G__73128.fqn:null);
switch (G__73128__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73128__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq73120){
var G__73121 = cljs.core.first(seq73120);
var seq73120__$1 = cljs.core.next(seq73120);
var G__73122 = cljs.core.first(seq73120__$1);
var seq73120__$2 = cljs.core.next(seq73120__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73121,G__73122,seq73120__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73144 = arguments.length;
var i__4830__auto___73145 = (0);
while(true){
if((i__4830__auto___73145 < len__4829__auto___73144)){
args__4835__auto__.push((arguments[i__4830__auto___73145]));

var G__73146 = (i__4830__auto___73145 + (1));
i__4830__auto___73145 = G__73146;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__73137){
var vec__73138 = p__73137;
var map__73141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73138,(0),null);
var map__73141__$1 = cljs.core.__destructure_map(map__73141);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73141__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73141__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__73141__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__73142 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__73142__$1 = (((G__73142 instanceof cljs.core.Keyword))?G__73142.fqn:null);
switch (G__73142__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73142__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_(iv,key_ba,x_ba);
var G__73143 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__73143__$1 = (((G__73143 instanceof cljs.core.Keyword))?G__73143.fqn:null);
switch (G__73143__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__73143__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq73134){
var G__73135 = cljs.core.first(seq73134);
var seq73134__$1 = cljs.core.next(seq73134);
var G__73136 = cljs.core.first(seq73134__$1);
var seq73134__$2 = cljs.core.next(seq73134__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73135,G__73136,seq73134__$2);
}));

