// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__63925 = arguments.length;
switch (G__63925) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___63964 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_63946){
var state_val_63947 = (state_63946[(1)]);
if((state_val_63947 === (1))){
var state_63946__$1 = state_63946;
var statearr_63948_63965 = state_63946__$1;
(statearr_63948_63965[(2)] = null);

(statearr_63948_63965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63947 === (2))){
var _ = (function (){var statearr_63949 = state_63946;
(statearr_63949[(4)] = cljs.core.cons((5),(state_63946[(4)])));

return statearr_63949;
})();
var inst_63932 = fluree.db.session.db(conn,ledger,null);
var state_63946__$1 = state_63946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63946__$1,(7),inst_63932);
} else {
if((state_val_63947 === (3))){
var inst_63942 = (state_63946[(2)]);
var inst_63943 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63942);
var inst_63944 = cljs.core.async.close_BANG_(pc);
var state_63946__$1 = (function (){var statearr_63951 = state_63946;
(statearr_63951[(7)] = inst_63943);

return statearr_63951;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63946__$1,inst_63944);
} else {
if((state_val_63947 === (4))){
var inst_63926 = (state_63946[(2)]);
var state_63946__$1 = state_63946;
var statearr_63952_63966 = state_63946__$1;
(statearr_63952_63966[(2)] = inst_63926);

(statearr_63952_63966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63947 === (5))){
var _ = (function (){var statearr_63953 = state_63946;
(statearr_63953[(4)] = cljs.core.rest((state_63946[(4)])));

return statearr_63953;
})();
var state_63946__$1 = state_63946;
var ex63950 = (state_63946__$1[(2)]);
var statearr_63954_63967 = state_63946__$1;
(statearr_63954_63967[(5)] = ex63950);


var statearr_63955_63968 = state_63946__$1;
(statearr_63955_63968[(1)] = (4));

(statearr_63955_63968[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63947 === (6))){
var inst_63938 = (state_63946[(2)]);
var inst_63939 = fluree.db.util.async.throw_err(inst_63938);
var _ = (function (){var statearr_63956 = state_63946;
(statearr_63956[(4)] = cljs.core.rest((state_63946[(4)])));

return statearr_63956;
})();
var state_63946__$1 = state_63946;
var statearr_63957_63969 = state_63946__$1;
(statearr_63957_63969[(2)] = inst_63939);

(statearr_63957_63969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63947 === (7))){
var inst_63934 = (state_63946[(2)]);
var inst_63935 = fluree.db.util.async.throw_err(inst_63934);
var inst_63936 = fluree.db.time_travel.as_of_block(inst_63935,block);
var state_63946__$1 = state_63946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63946__$1,(6),inst_63936);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2733__auto__ = null;
var fluree$db$api$ledger$state_machine__2733__auto____0 = (function (){
var statearr_63958 = [null,null,null,null,null,null,null,null];
(statearr_63958[(0)] = fluree$db$api$ledger$state_machine__2733__auto__);

(statearr_63958[(1)] = (1));

return statearr_63958;
});
var fluree$db$api$ledger$state_machine__2733__auto____1 = (function (state_63946){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_63946);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e63959){var ex__2736__auto__ = e63959;
var statearr_63960_63970 = state_63946;
(statearr_63960_63970[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_63946[(4)]))){
var statearr_63961_63971 = state_63946;
(statearr_63961_63971[(1)] = cljs.core.first((state_63946[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63972 = state_63946;
state_63946 = G__63972;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2733__auto__ = function(state_63946){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2733__auto____1.call(this,state_63946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2733__auto____0;
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2733__auto____1;
return fluree$db$api$ledger$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_63962 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_63962[(6)] = c__2755__auto___63964);

return statearr_63962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64013){
var state_val_64014 = (state_64013[(1)]);
if((state_val_64014 === (7))){
var inst_63982 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64013__$1 = state_64013;
if(inst_63982){
var statearr_64015_64046 = state_64013__$1;
(statearr_64015_64046[(1)] = (9));

} else {
var statearr_64016_64047 = state_64013__$1;
(statearr_64016_64047[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (1))){
var state_64013__$1 = state_64013;
var statearr_64017_64048 = state_64013__$1;
(statearr_64017_64048[(2)] = null);

(statearr_64017_64048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (4))){
var inst_63973 = (state_64013[(2)]);
var state_64013__$1 = state_64013;
var statearr_64018_64049 = state_64013__$1;
(statearr_64018_64049[(2)] = inst_63973);

(statearr_64018_64049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (15))){
var inst_63990 = (state_64013[(7)]);
var inst_63989 = (state_64013[(2)]);
var inst_63990__$1 = fluree.db.util.async.throw_err(inst_63989);
var state_64013__$1 = (function (){var statearr_64019 = state_64013;
(statearr_64019[(7)] = inst_63990__$1);

return statearr_64019;
})();
if(cljs.core.truth_(inst_63990__$1)){
var statearr_64020_64050 = state_64013__$1;
(statearr_64020_64050[(1)] = (16));

} else {
var statearr_64021_64051 = state_64013__$1;
(statearr_64021_64051[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (13))){
var state_64013__$1 = state_64013;
var statearr_64022_64052 = state_64013__$1;
(statearr_64022_64052[(2)] = null);

(statearr_64022_64052[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (6))){
var state_64013__$1 = state_64013;
var statearr_64023_64053 = state_64013__$1;
(statearr_64023_64053[(2)] = db);

(statearr_64023_64053[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (17))){
var inst_63994 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_63995 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63996 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_63997 = cljs.core.PersistentHashMap.fromArrays(inst_63995,inst_63996);
var inst_63998 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_63994,inst_63997);
var inst_63999 = (function(){throw inst_63998})();
var state_64013__$1 = state_64013;
var statearr_64024_64054 = state_64013__$1;
(statearr_64024_64054[(2)] = inst_63999);

(statearr_64024_64054[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (3))){
var inst_64011 = (state_64013[(2)]);
var state_64013__$1 = state_64013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64013__$1,inst_64011);
} else {
if((state_val_64014 === (12))){
var inst_63987 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64013__$1 = state_64013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64013__$1,(15),inst_63987);
} else {
if((state_val_64014 === (2))){
var _ = (function (){var statearr_64025 = state_64013;
(statearr_64025[(4)] = cljs.core.cons((5),(state_64013[(4)])));

return statearr_64025;
})();
var inst_63979 = cljs.core.not(auth);
var state_64013__$1 = state_64013;
if(inst_63979){
var statearr_64026_64055 = state_64013__$1;
(statearr_64026_64055[(1)] = (6));

} else {
var statearr_64027_64056 = state_64013__$1;
(statearr_64027_64056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (11))){
var inst_64006 = (state_64013[(2)]);
var state_64013__$1 = state_64013;
var statearr_64029_64057 = state_64013__$1;
(statearr_64029_64057[(2)] = inst_64006);

(statearr_64029_64057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (9))){
var inst_63984 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_64013__$1 = state_64013;
var statearr_64030_64058 = state_64013__$1;
(statearr_64030_64058[(2)] = inst_63984);

(statearr_64030_64058[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (5))){
var _ = (function (){var statearr_64031 = state_64013;
(statearr_64031[(4)] = cljs.core.rest((state_64013[(4)])));

return statearr_64031;
})();
var state_64013__$1 = state_64013;
var ex64028 = (state_64013__$1[(2)]);
var statearr_64032_64059 = state_64013__$1;
(statearr_64032_64059[(5)] = ex64028);


if((ex64028 instanceof Error)){
var statearr_64033_64060 = state_64013__$1;
(statearr_64033_64060[(1)] = (4));

(statearr_64033_64060[(5)] = null);

} else {
throw ex64028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (14))){
var inst_64004 = (state_64013[(2)]);
var state_64013__$1 = state_64013;
var statearr_64034_64061 = state_64013__$1;
(statearr_64034_64061[(2)] = inst_64004);

(statearr_64034_64061[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (16))){
var inst_63990 = (state_64013[(7)]);
var inst_63992 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_63990);
var state_64013__$1 = state_64013;
var statearr_64035_64062 = state_64013__$1;
(statearr_64035_64062[(2)] = inst_63992);

(statearr_64035_64062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (10))){
var state_64013__$1 = state_64013;
var statearr_64036_64063 = state_64013__$1;
(statearr_64036_64063[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (18))){
var inst_64001 = (state_64013[(2)]);
var state_64013__$1 = state_64013;
var statearr_64038_64064 = state_64013__$1;
(statearr_64038_64064[(2)] = inst_64001);

(statearr_64038_64064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64014 === (8))){
var inst_64008 = (state_64013[(2)]);
var _ = (function (){var statearr_64039 = state_64013;
(statearr_64039[(4)] = cljs.core.rest((state_64013[(4)])));

return statearr_64039;
})();
var state_64013__$1 = state_64013;
var statearr_64040_64065 = state_64013__$1;
(statearr_64040_64065[(2)] = inst_64008);

(statearr_64040_64065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0 = (function (){
var statearr_64041 = [null,null,null,null,null,null,null,null];
(statearr_64041[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__);

(statearr_64041[(1)] = (1));

return statearr_64041;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1 = (function (state_64013){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64013);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64042){var ex__2736__auto__ = e64042;
var statearr_64043_64066 = state_64013;
(statearr_64043_64066[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64013[(4)]))){
var statearr_64044_64067 = state_64013;
(statearr_64044_64067[(1)] = cljs.core.first((state_64013[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64068 = state_64013;
state_64013 = G__64068;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__ = function(state_64013){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1.call(this,state_64013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64045 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64045[(6)] = c__2755__auto__);

return statearr_64045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64132){
var state_val_64133 = (state_64132[(1)]);
if((state_val_64133 === (7))){
var inst_64078 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64132__$1 = state_64132;
if(inst_64078){
var statearr_64134_64183 = state_64132__$1;
(statearr_64134_64183[(1)] = (9));

} else {
var statearr_64135_64184 = state_64132__$1;
(statearr_64135_64184[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (20))){
var inst_64102 = (state_64132[(7)]);
var state_64132__$1 = state_64132;
if(cljs.core.truth_(inst_64102)){
var statearr_64136_64185 = state_64132__$1;
(statearr_64136_64185[(1)] = (22));

} else {
var statearr_64137_64186 = state_64132__$1;
(statearr_64137_64186[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (27))){
var state_64132__$1 = state_64132;
var statearr_64138_64187 = state_64132__$1;
(statearr_64138_64187[(2)] = null);

(statearr_64138_64187[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (1))){
var state_64132__$1 = state_64132;
var statearr_64139_64188 = state_64132__$1;
(statearr_64139_64188[(2)] = null);

(statearr_64139_64188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (24))){
var inst_64116 = (state_64132[(2)]);
var state_64132__$1 = state_64132;
var statearr_64140_64189 = state_64132__$1;
(statearr_64140_64189[(2)] = inst_64116);

(statearr_64140_64189[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (4))){
var inst_64069 = (state_64132[(2)]);
var state_64132__$1 = state_64132;
var statearr_64141_64190 = state_64132__$1;
(statearr_64141_64190[(2)] = inst_64069);

(statearr_64141_64190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (15))){
var inst_64085 = (state_64132[(8)]);
var inst_64084 = (state_64132[(2)]);
var inst_64085__$1 = fluree.db.util.async.throw_err(inst_64084);
var state_64132__$1 = (function (){var statearr_64142 = state_64132;
(statearr_64142[(8)] = inst_64085__$1);

return statearr_64142;
})();
if(cljs.core.truth_(inst_64085__$1)){
var statearr_64143_64191 = state_64132__$1;
(statearr_64143_64191[(1)] = (16));

} else {
var statearr_64144_64192 = state_64132__$1;
(statearr_64144_64192[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (21))){
var inst_64118 = (state_64132[(9)]);
var inst_64118__$1 = (state_64132[(2)]);
var state_64132__$1 = (function (){var statearr_64145 = state_64132;
(statearr_64145[(9)] = inst_64118__$1);

return statearr_64145;
})();
if(cljs.core.truth_(inst_64118__$1)){
var statearr_64146_64193 = state_64132__$1;
(statearr_64146_64193[(1)] = (29));

} else {
var statearr_64147_64194 = state_64132__$1;
(statearr_64147_64194[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (31))){
var inst_64102 = (state_64132[(7)]);
var inst_64118 = (state_64132[(9)]);
var inst_64126 = (state_64132[(2)]);
var inst_64127 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64102,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_64118,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_64126], 0));
var _ = (function (){var statearr_64148 = state_64132;
(statearr_64148[(4)] = cljs.core.rest((state_64132[(4)])));

return statearr_64148;
})();
var state_64132__$1 = state_64132;
var statearr_64149_64195 = state_64132__$1;
(statearr_64149_64195[(2)] = inst_64127);

(statearr_64149_64195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (32))){
var inst_64122 = (state_64132[(2)]);
var inst_64123 = fluree.db.util.async.throw_err(inst_64122);
var state_64132__$1 = state_64132;
var statearr_64150_64196 = state_64132__$1;
(statearr_64150_64196[(2)] = inst_64123);

(statearr_64150_64196[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (13))){
var state_64132__$1 = state_64132;
var statearr_64151_64197 = state_64132__$1;
(statearr_64151_64197[(2)] = null);

(statearr_64151_64197[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (22))){
var inst_64102 = (state_64132[(7)]);
var inst_64106 = fluree.db.auth.roles(db,inst_64102);
var state_64132__$1 = state_64132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64132__$1,(25),inst_64106);
} else {
if((state_val_64133 === (29))){
var inst_64118 = (state_64132[(9)]);
var inst_64120 = fluree.db.permissions.permission_map(db,inst_64118,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64132__$1 = state_64132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64132__$1,(32),inst_64120);
} else {
if((state_val_64133 === (6))){
var state_64132__$1 = state_64132;
var statearr_64152_64198 = state_64132__$1;
(statearr_64152_64198[(2)] = null);

(statearr_64152_64198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (28))){
var inst_64114 = (state_64132[(2)]);
var state_64132__$1 = state_64132;
var statearr_64153_64199 = state_64132__$1;
(statearr_64153_64199[(2)] = inst_64114);

(statearr_64153_64199[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (25))){
var inst_64108 = (state_64132[(2)]);
var inst_64109 = fluree.db.util.async.throw_err(inst_64108);
var state_64132__$1 = state_64132;
var statearr_64154_64200 = state_64132__$1;
(statearr_64154_64200[(2)] = inst_64109);

(statearr_64154_64200[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (17))){
var inst_64088 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64089 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64090 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64091 = cljs.core.PersistentHashMap.fromArrays(inst_64089,inst_64090);
var inst_64092 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64088,inst_64091);
var inst_64093 = (function(){throw inst_64092})();
var state_64132__$1 = state_64132;
var statearr_64155_64201 = state_64132__$1;
(statearr_64155_64201[(2)] = inst_64093);

(statearr_64155_64201[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (3))){
var inst_64130 = (state_64132[(2)]);
var state_64132__$1 = state_64132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64132__$1,inst_64130);
} else {
if((state_val_64133 === (12))){
var inst_64082 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64132__$1 = state_64132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64132__$1,(15),inst_64082);
} else {
if((state_val_64133 === (2))){
var _ = (function (){var statearr_64156 = state_64132;
(statearr_64156[(4)] = cljs.core.cons((5),(state_64132[(4)])));

return statearr_64156;
})();
var inst_64075 = (auth == null);
var state_64132__$1 = state_64132;
if(cljs.core.truth_(inst_64075)){
var statearr_64157_64202 = state_64132__$1;
(statearr_64157_64202[(1)] = (6));

} else {
var statearr_64158_64203 = state_64132__$1;
(statearr_64158_64203[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (23))){
var state_64132__$1 = state_64132;
var statearr_64159_64204 = state_64132__$1;
(statearr_64159_64204[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (19))){
var state_64132__$1 = state_64132;
var statearr_64161_64205 = state_64132__$1;
(statearr_64161_64205[(2)] = roles);

(statearr_64161_64205[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (11))){
var inst_64100 = (state_64132[(2)]);
var state_64132__$1 = state_64132;
var statearr_64163_64206 = state_64132__$1;
(statearr_64163_64206[(2)] = inst_64100);

(statearr_64163_64206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (9))){
var state_64132__$1 = state_64132;
var statearr_64164_64207 = state_64132__$1;
(statearr_64164_64207[(2)] = (0));

(statearr_64164_64207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (5))){
var _ = (function (){var statearr_64165 = state_64132;
(statearr_64165[(4)] = cljs.core.rest((state_64132[(4)])));

return statearr_64165;
})();
var state_64132__$1 = state_64132;
var ex64162 = (state_64132__$1[(2)]);
var statearr_64166_64208 = state_64132__$1;
(statearr_64166_64208[(5)] = ex64162);


if((ex64162 instanceof Error)){
var statearr_64167_64209 = state_64132__$1;
(statearr_64167_64209[(1)] = (4));

(statearr_64167_64209[(5)] = null);

} else {
throw ex64162;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (14))){
var inst_64098 = (state_64132[(2)]);
var state_64132__$1 = state_64132;
var statearr_64168_64210 = state_64132__$1;
(statearr_64168_64210[(2)] = inst_64098);

(statearr_64168_64210[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (26))){
var state_64132__$1 = state_64132;
var statearr_64169_64211 = state_64132__$1;
(statearr_64169_64211[(2)] = null);

(statearr_64169_64211[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (16))){
var inst_64085 = (state_64132[(8)]);
var state_64132__$1 = state_64132;
var statearr_64170_64212 = state_64132__$1;
(statearr_64170_64212[(2)] = inst_64085);

(statearr_64170_64212[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (30))){
var state_64132__$1 = state_64132;
var statearr_64171_64213 = state_64132__$1;
(statearr_64171_64213[(2)] = null);

(statearr_64171_64213[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (10))){
var state_64132__$1 = state_64132;
if(cljs.core.truth_(auth)){
var statearr_64172_64214 = state_64132__$1;
(statearr_64172_64214[(1)] = (12));

} else {
var statearr_64173_64215 = state_64132__$1;
(statearr_64173_64215[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (18))){
var inst_64095 = (state_64132[(2)]);
var state_64132__$1 = state_64132;
var statearr_64174_64216 = state_64132__$1;
(statearr_64174_64216[(2)] = inst_64095);

(statearr_64174_64216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64133 === (8))){
var inst_64102 = (state_64132[(2)]);
var state_64132__$1 = (function (){var statearr_64175 = state_64132;
(statearr_64175[(7)] = inst_64102);

return statearr_64175;
})();
if(cljs.core.truth_(roles)){
var statearr_64176_64217 = state_64132__$1;
(statearr_64176_64217[(1)] = (19));

} else {
var statearr_64177_64218 = state_64132__$1;
(statearr_64177_64218[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0 = (function (){
var statearr_64178 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64178[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__);

(statearr_64178[(1)] = (1));

return statearr_64178;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1 = (function (state_64132){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64132);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64179){var ex__2736__auto__ = e64179;
var statearr_64180_64219 = state_64132;
(statearr_64180_64219[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64132[(4)]))){
var statearr_64181_64220 = state_64132;
(statearr_64181_64220[(1)] = cljs.core.first((state_64132[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64221 = state_64132;
state_64132 = G__64221;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__ = function(state_64132){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1.call(this,state_64132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64182 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64182[(6)] = c__2755__auto__);

return statearr_64182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__64222 = db;
var map__64222__$1 = cljs.core.__destructure_map(map__64222);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64222__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64222__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64222__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64229){
var state_val_64230 = (state_64229[(1)]);
if((state_val_64230 === (1))){
var inst_64223 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64224 = fluree.db.session.db(conn,inst_64223,null);
var state_64229__$1 = state_64229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64229__$1,(2),inst_64224);
} else {
if((state_val_64230 === (2))){
var inst_64226 = (state_64229[(2)]);
var inst_64227 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64226);
var state_64229__$1 = state_64229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64229__$1,inst_64227);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0 = (function (){
var statearr_64231 = [null,null,null,null,null,null,null];
(statearr_64231[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__);

(statearr_64231[(1)] = (1));

return statearr_64231;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1 = (function (state_64229){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64229);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64232){var ex__2736__auto__ = e64232;
var statearr_64233_64260 = state_64229;
(statearr_64233_64260[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64229[(4)]))){
var statearr_64234_64261 = state_64229;
(statearr_64234_64261[(1)] = cljs.core.first((state_64229[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64262 = state_64229;
state_64229 = G__64262;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = function(state_64229){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1.call(this,state_64229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64235 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64235[(6)] = c__2755__auto__);

return statearr_64235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64248){
var state_val_64249 = (state_64248[(1)]);
if((state_val_64249 === (1))){
var inst_64236 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64237 = fluree.db.session.db(conn,inst_64236,null);
var state_64248__$1 = state_64248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64248__$1,(2),inst_64237);
} else {
if((state_val_64249 === (2))){
var inst_64239 = (state_64248[(7)]);
var inst_64239__$1 = (state_64248[(2)]);
var inst_64240 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64239__$1);
var inst_64241 = newer_block_QMARK_(inst_64240);
var state_64248__$1 = (function (){var statearr_64250 = state_64248;
(statearr_64250[(7)] = inst_64239__$1);

return statearr_64250;
})();
if(inst_64241){
var statearr_64251_64263 = state_64248__$1;
(statearr_64251_64263[(1)] = (3));

} else {
var statearr_64252_64264 = state_64248__$1;
(statearr_64252_64264[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (3))){
var inst_64239 = (state_64248[(7)]);
var inst_64243 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64239);
var state_64248__$1 = state_64248;
var statearr_64253_64265 = state_64248__$1;
(statearr_64253_64265[(2)] = inst_64243);

(statearr_64253_64265[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (4))){
var state_64248__$1 = state_64248;
var statearr_64254_64266 = state_64248__$1;
(statearr_64254_64266[(2)] = null);

(statearr_64254_64266[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (5))){
var inst_64246 = (state_64248[(2)]);
var state_64248__$1 = state_64248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64248__$1,inst_64246);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0 = (function (){
var statearr_64255 = [null,null,null,null,null,null,null,null];
(statearr_64255[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__);

(statearr_64255[(1)] = (1));

return statearr_64255;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1 = (function (state_64248){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64248);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64256){var ex__2736__auto__ = e64256;
var statearr_64257_64267 = state_64248;
(statearr_64257_64267[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64248[(4)]))){
var statearr_64258_64268 = state_64248;
(statearr_64258_64268[(1)] = cljs.core.first((state_64248[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64269 = state_64248;
state_64248 = G__64269;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = function(state_64248){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1.call(this,state_64248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64259 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64259[(6)] = c__2755__auto__);

return statearr_64259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__64270 = db;
var map__64270__$1 = cljs.core.__destructure_map(map__64270);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64270__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64270__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64270__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4309__auto__ = syncTimeout;
var y__4310__auto__ = (120000);
return ((x__4309__auto__ < y__4310__auto__) ? x__4309__auto__ : y__4310__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2755__auto___64346 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64320){
var state_val_64321 = (state_64320[(1)]);
if((state_val_64321 === (7))){
var inst_64286 = (state_64320[(7)]);
var inst_64297 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64286,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_64320__$1 = state_64320;
if(inst_64297){
var statearr_64322_64347 = state_64320__$1;
(statearr_64322_64347[(1)] = (9));

} else {
var statearr_64323_64348 = state_64320__$1;
(statearr_64323_64348[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (1))){
var inst_64271 = (state_64320[(8)]);
var inst_64279 = (state_64320[(9)]);
var inst_64271__$1 = cljs.core.async.timeout(timeout);
var inst_64279__$1 = res_port;
var inst_64280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64281 = [inst_64271__$1,inst_64279__$1];
var inst_64282 = (new cljs.core.PersistentVector(null,2,(5),inst_64280,inst_64281,null));
var state_64320__$1 = (function (){var statearr_64324 = state_64320;
(statearr_64324[(8)] = inst_64271__$1);

(statearr_64324[(9)] = inst_64279__$1);

return statearr_64324;
})();
return cljs.core.async.ioc_alts_BANG_(state_64320__$1,(2),inst_64282);
} else {
if((state_val_64321 === (4))){
var inst_64279 = (state_64320[(9)]);
var inst_64286 = (state_64320[(7)]);
var inst_64290 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64286,inst_64279);
var state_64320__$1 = state_64320;
if(inst_64290){
var statearr_64325_64349 = state_64320__$1;
(statearr_64325_64349[(1)] = (6));

} else {
var statearr_64326_64350 = state_64320__$1;
(statearr_64326_64350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (13))){
var inst_64305 = (state_64320[(10)]);
var inst_64316 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64305);
var state_64320__$1 = state_64320;
var statearr_64327_64351 = state_64320__$1;
(statearr_64327_64351[(2)] = inst_64316);

(statearr_64327_64351[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (6))){
var inst_64284 = (state_64320[(11)]);
var inst_64295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64284,(0),null);
var state_64320__$1 = state_64320;
var statearr_64328_64352 = state_64320__$1;
(statearr_64328_64352[(2)] = inst_64295);

(statearr_64328_64352[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (3))){
var state_64320__$1 = state_64320;
var statearr_64329_64353 = state_64320__$1;
(statearr_64329_64353[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_64329_64353[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (12))){
var inst_64309 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_64310 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64311 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_64312 = cljs.core.PersistentHashMap.fromArrays(inst_64310,inst_64311);
var inst_64313 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64309,inst_64312);
var inst_64314 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64313);
var state_64320__$1 = state_64320;
var statearr_64330_64354 = state_64320__$1;
(statearr_64330_64354[(2)] = inst_64314);

(statearr_64330_64354[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (2))){
var inst_64271 = (state_64320[(8)]);
var inst_64284 = (state_64320[(11)]);
var inst_64286 = (state_64320[(7)]);
var inst_64284__$1 = (state_64320[(2)]);
var inst_64285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64284__$1,(0),null);
var inst_64286__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64284__$1,(1),null);
var inst_64287 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64286__$1,inst_64271);
var state_64320__$1 = (function (){var statearr_64331 = state_64320;
(statearr_64331[(11)] = inst_64284__$1);

(statearr_64331[(12)] = inst_64285);

(statearr_64331[(7)] = inst_64286__$1);

return statearr_64331;
})();
if(inst_64287){
var statearr_64332_64355 = state_64320__$1;
(statearr_64332_64355[(1)] = (3));

} else {
var statearr_64333_64356 = state_64320__$1;
(statearr_64333_64356[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (11))){
var inst_64301 = (state_64320[(2)]);
var state_64320__$1 = state_64320;
var statearr_64334_64357 = state_64320__$1;
(statearr_64334_64357[(2)] = inst_64301);

(statearr_64334_64357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (9))){
var inst_64285 = (state_64320[(12)]);
var state_64320__$1 = state_64320;
var statearr_64335_64358 = state_64320__$1;
(statearr_64335_64358[(2)] = inst_64285);

(statearr_64335_64358[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (5))){
var inst_64305 = (state_64320[(10)]);
var inst_64305__$1 = (state_64320[(2)]);
var inst_64306 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_64307 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_64305__$1);
var state_64320__$1 = (function (){var statearr_64336 = state_64320;
(statearr_64336[(13)] = inst_64306);

(statearr_64336[(10)] = inst_64305__$1);

return statearr_64336;
})();
if(inst_64307){
var statearr_64337_64359 = state_64320__$1;
(statearr_64337_64359[(1)] = (12));

} else {
var statearr_64338_64360 = state_64320__$1;
(statearr_64338_64360[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (14))){
var inst_64318 = (state_64320[(2)]);
var state_64320__$1 = state_64320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64320__$1,inst_64318);
} else {
if((state_val_64321 === (10))){
var state_64320__$1 = state_64320;
var statearr_64339_64361 = state_64320__$1;
(statearr_64339_64361[(2)] = null);

(statearr_64339_64361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64321 === (8))){
var inst_64303 = (state_64320[(2)]);
var state_64320__$1 = state_64320;
var statearr_64340_64362 = state_64320__$1;
(statearr_64340_64362[(2)] = inst_64303);

(statearr_64340_64362[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0 = (function (){
var statearr_64341 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64341[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__);

(statearr_64341[(1)] = (1));

return statearr_64341;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1 = (function (state_64320){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64320);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64342){var ex__2736__auto__ = e64342;
var statearr_64343_64363 = state_64320;
(statearr_64343_64363[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64320[(4)]))){
var statearr_64344_64364 = state_64320;
(statearr_64344_64364[(1)] = cljs.core.first((state_64320[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64365 = state_64320;
state_64320 = G__64365;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__ = function(state_64320){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1.call(this,state_64320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64345 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64345[(6)] = c__2755__auto___64346);

return statearr_64345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__64367 = arguments.length;
switch (G__64367) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__64368){
var map__64369 = p__64368;
var map__64369__$1 = cljs.core.__destructure_map(map__64369);
var opts = map__64369__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64369__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64369__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64369__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64369__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64369__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2755__auto___64458 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64420){
var state_val_64421 = (state_64420[(1)]);
if((state_val_64421 === (7))){
var inst_64382 = (state_64420[(7)]);
var inst_64384 = fluree.db.api.ledger.syncTo_db(inst_64382,syncTo,syncTimeout);
var state_64420__$1 = state_64420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64420__$1,(10),inst_64384);
} else {
if((state_val_64421 === (20))){
var inst_64406 = (state_64420[(8)]);
var state_64420__$1 = state_64420;
var statearr_64422_64459 = state_64420__$1;
(statearr_64422_64459[(2)] = inst_64406);

(statearr_64422_64459[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (1))){
var state_64420__$1 = state_64420;
var statearr_64423_64460 = state_64420__$1;
(statearr_64423_64460[(2)] = null);

(statearr_64423_64460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (4))){
var inst_64370 = (state_64420[(2)]);
var inst_64371 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64370);
var inst_64372 = cljs.core.async.close_BANG_(pc);
var state_64420__$1 = (function (){var statearr_64424 = state_64420;
(statearr_64424[(9)] = inst_64371);

return statearr_64424;
})();
var statearr_64425_64461 = state_64420__$1;
(statearr_64425_64461[(2)] = inst_64372);

(statearr_64425_64461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (15))){
var inst_64398 = (state_64420[(10)]);
var inst_64400 = fluree.db.api.ledger.add_db_permissions(inst_64398,auth,roles);
var state_64420__$1 = state_64420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64420__$1,(18),inst_64400);
} else {
if((state_val_64421 === (21))){
var inst_64414 = (state_64420[(2)]);
var inst_64415 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64414);
var _ = (function (){var statearr_64426 = state_64420;
(statearr_64426[(4)] = cljs.core.rest((state_64420[(4)])));

return statearr_64426;
})();
var state_64420__$1 = state_64420;
var statearr_64427_64462 = state_64420__$1;
(statearr_64427_64462[(2)] = inst_64415);

(statearr_64427_64462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (13))){
var inst_64398 = (state_64420[(2)]);
var state_64420__$1 = (function (){var statearr_64428 = state_64420;
(statearr_64428[(10)] = inst_64398);

return statearr_64428;
})();
if(cljs.core.truth_(roles)){
var statearr_64429_64463 = state_64420__$1;
(statearr_64429_64463[(1)] = (15));

} else {
var statearr_64430_64464 = state_64420__$1;
(statearr_64430_64464[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (22))){
var inst_64410 = (state_64420[(2)]);
var inst_64411 = fluree.db.util.async.throw_err(inst_64410);
var state_64420__$1 = state_64420;
var statearr_64431_64465 = state_64420__$1;
(statearr_64431_64465[(2)] = inst_64411);

(statearr_64431_64465[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (6))){
var inst_64381 = (state_64420[(2)]);
var inst_64382 = fluree.db.util.async.throw_err(inst_64381);
var state_64420__$1 = (function (){var statearr_64432 = state_64420;
(statearr_64432[(7)] = inst_64382);

return statearr_64432;
})();
if(cljs.core.truth_(syncTo)){
var statearr_64433_64466 = state_64420__$1;
(statearr_64433_64466[(1)] = (7));

} else {
var statearr_64434_64467 = state_64420__$1;
(statearr_64434_64467[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (17))){
var inst_64406 = (state_64420[(2)]);
var state_64420__$1 = (function (){var statearr_64435 = state_64420;
(statearr_64435[(8)] = inst_64406);

return statearr_64435;
})();
if(cljs.core.truth_(auth)){
var statearr_64436_64468 = state_64420__$1;
(statearr_64436_64468[(1)] = (19));

} else {
var statearr_64437_64469 = state_64420__$1;
(statearr_64437_64469[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (3))){
var inst_64418 = (state_64420[(2)]);
var state_64420__$1 = state_64420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64420__$1,inst_64418);
} else {
if((state_val_64421 === (12))){
var inst_64390 = (state_64420[(11)]);
var state_64420__$1 = state_64420;
var statearr_64438_64470 = state_64420__$1;
(statearr_64438_64470[(2)] = inst_64390);

(statearr_64438_64470[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (2))){
var _ = (function (){var statearr_64439 = state_64420;
(statearr_64439[(4)] = cljs.core.cons((5),(state_64420[(4)])));

return statearr_64439;
})();
var inst_64379 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_64420__$1 = state_64420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64420__$1,(6),inst_64379);
} else {
if((state_val_64421 === (19))){
var inst_64406 = (state_64420[(8)]);
var inst_64408 = fluree.db.api.ledger.add_db_permissions(inst_64406,auth,roles);
var state_64420__$1 = state_64420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64420__$1,(22),inst_64408);
} else {
if((state_val_64421 === (11))){
var inst_64390 = (state_64420[(11)]);
var inst_64392 = fluree.db.time_travel.as_of_block(inst_64390,block);
var state_64420__$1 = state_64420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64420__$1,(14),inst_64392);
} else {
if((state_val_64421 === (9))){
var inst_64390 = (state_64420[(2)]);
var state_64420__$1 = (function (){var statearr_64441 = state_64420;
(statearr_64441[(11)] = inst_64390);

return statearr_64441;
})();
if(cljs.core.truth_(block)){
var statearr_64442_64471 = state_64420__$1;
(statearr_64442_64471[(1)] = (11));

} else {
var statearr_64443_64472 = state_64420__$1;
(statearr_64443_64472[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (5))){
var _ = (function (){var statearr_64444 = state_64420;
(statearr_64444[(4)] = cljs.core.rest((state_64420[(4)])));

return statearr_64444;
})();
var state_64420__$1 = state_64420;
var ex64440 = (state_64420__$1[(2)]);
var statearr_64445_64473 = state_64420__$1;
(statearr_64445_64473[(5)] = ex64440);


var statearr_64446_64474 = state_64420__$1;
(statearr_64446_64474[(1)] = (4));

(statearr_64446_64474[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (14))){
var inst_64394 = (state_64420[(2)]);
var inst_64395 = fluree.db.util.async.throw_err(inst_64394);
var state_64420__$1 = state_64420;
var statearr_64447_64475 = state_64420__$1;
(statearr_64447_64475[(2)] = inst_64395);

(statearr_64447_64475[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (16))){
var inst_64398 = (state_64420[(10)]);
var state_64420__$1 = state_64420;
var statearr_64448_64476 = state_64420__$1;
(statearr_64448_64476[(2)] = inst_64398);

(statearr_64448_64476[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (10))){
var inst_64386 = (state_64420[(2)]);
var inst_64387 = fluree.db.util.async.throw_err(inst_64386);
var state_64420__$1 = state_64420;
var statearr_64449_64477 = state_64420__$1;
(statearr_64449_64477[(2)] = inst_64387);

(statearr_64449_64477[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (18))){
var inst_64402 = (state_64420[(2)]);
var inst_64403 = fluree.db.util.async.throw_err(inst_64402);
var state_64420__$1 = state_64420;
var statearr_64450_64478 = state_64420__$1;
(statearr_64450_64478[(2)] = inst_64403);

(statearr_64450_64478[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64421 === (8))){
var inst_64382 = (state_64420[(7)]);
var state_64420__$1 = state_64420;
var statearr_64451_64479 = state_64420__$1;
(statearr_64451_64479[(2)] = inst_64382);

(statearr_64451_64479[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2733__auto__ = null;
var fluree$db$api$ledger$state_machine__2733__auto____0 = (function (){
var statearr_64452 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64452[(0)] = fluree$db$api$ledger$state_machine__2733__auto__);

(statearr_64452[(1)] = (1));

return statearr_64452;
});
var fluree$db$api$ledger$state_machine__2733__auto____1 = (function (state_64420){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64420);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64453){var ex__2736__auto__ = e64453;
var statearr_64454_64480 = state_64420;
(statearr_64454_64480[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64420[(4)]))){
var statearr_64455_64481 = state_64420;
(statearr_64455_64481[(1)] = cljs.core.first((state_64420[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64482 = state_64420;
state_64420 = G__64482;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2733__auto__ = function(state_64420){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2733__auto____1.call(this,state_64420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2733__auto____0;
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2733__auto____1;
return fluree$db$api$ledger$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64456 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64456[(6)] = c__2755__auto___64458);

return statearr_64456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

