// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e17275){var e = e17275;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__17276_SHARP_){
var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__17276_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__17276_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__17276_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__17276_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17277_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17277_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17278_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17278_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4221__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4223__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17283 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17283,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17283,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17279_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17279_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4221__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4221__auto__;
}
})())){
var vec__17286 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17286,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17286,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4223__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17280_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17280_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17281_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17281_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17282_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__17282_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17289_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__17289_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (add_amount > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fuel;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4221__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__17290 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__17290) : intersecting_vars.call(null,G__17290));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__17293,optional_QMARK_,fuel,max_fuel){
var map__17294 = p__17293;
var map__17294__$1 = cljs.core.__destructure_map(map__17294);
var res = map__17294__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17294__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17360){
var state_val_17361 = (state_17360[(1)]);
if((state_val_17361 === (7))){
var inst_17349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17350 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_17351 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_17350,clause);
var inst_17352 = [null,inst_17351];
var inst_17353 = (new cljs.core.PersistentVector(null,2,(5),inst_17349,inst_17352,null));
var state_17360__$1 = state_17360;
var statearr_17362_17390 = state_17360__$1;
(statearr_17362_17390[(2)] = inst_17353);

(statearr_17362_17390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (1))){
var state_17360__$1 = state_17360;
var statearr_17363_17391 = state_17360__$1;
(statearr_17363_17391[(2)] = null);

(statearr_17363_17391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (4))){
var inst_17295 = (state_17360[(2)]);
var state_17360__$1 = state_17360;
var statearr_17364_17392 = state_17360__$1;
(statearr_17364_17392[(2)] = inst_17295);

(statearr_17364_17392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (15))){
var inst_17338 = (state_17360[(2)]);
var inst_17339 = fluree.db.util.async.throw_err(inst_17338);
var inst_17340 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_17339);
var inst_17341 = cljs.core.count(inst_17340);
var inst_17342 = fluree.db.query.analytical.add_fuel(inst_17341,fuel,max_fuel);
var inst_17343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17344 = [inst_17339,r];
var inst_17345 = (new cljs.core.PersistentVector(null,2,(5),inst_17343,inst_17344,null));
var state_17360__$1 = (function (){var statearr_17365 = state_17360;
(statearr_17365[(7)] = inst_17342);

return statearr_17365;
})();
var statearr_17366_17393 = state_17360__$1;
(statearr_17366_17393[(2)] = inst_17345);

(statearr_17366_17393[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (13))){
var inst_17304 = (state_17360[(8)]);
var inst_17317 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_17318 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_17317);
var inst_17319 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_17304);
var inst_17320 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_17319);
var inst_17321 = cljs.core.set(inst_17320);
var inst_17322 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_17318);
var inst_17323 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_17322);
var inst_17324 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_17321,inst_17323);
var inst_17325 = (function (){var all_wd = inst_17304;
var optional = inst_17318;
var all_wd_vars = inst_17321;
var all_vars = inst_17324;
return (function (p1__17291_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__17291_SHARP_) : all_vars.call(null,p1__17291_SHARP_));
});
})();
var inst_17326 = cljs.core.keys(vars);
var inst_17327 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17325,inst_17326);
var inst_17328 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_17327);
var inst_17329 = cljs.core.set(inst_17328);
var inst_17330 = (function (){var all_wd = inst_17304;
var optional = inst_17318;
var all_wd_vars = inst_17321;
var all_vars = inst_17324;
var intersecting_vars = inst_17329;
return (function (p1__17292_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__17292_SHARP_);
});
})();
var inst_17331 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17330,inst_17304);
var inst_17332 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_17331);
var inst_17333 = fluree.db.query.analytical.select_from_tuples(inst_17332,res);
var inst_17334 = fluree.db.query.analytical.replace_vars_wikidata(inst_17304,inst_17329,vars);
var inst_17335 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_17329,inst_17324);
var inst_17336 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_17334,inst_17332,inst_17333,inst_17335,inst_17318);
var state_17360__$1 = state_17360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17360__$1,(15),inst_17336);
} else {
if((state_val_17361 === (6))){
var inst_17305 = (state_17360[(9)]);
var inst_17303 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_17304 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_17303);
var inst_17305__$1 = optional_QMARK_;
var state_17360__$1 = (function (){var statearr_17367 = state_17360;
(statearr_17367[(9)] = inst_17305__$1);

(statearr_17367[(8)] = inst_17304);

return statearr_17367;
})();
if(cljs.core.truth_(inst_17305__$1)){
var statearr_17368_17394 = state_17360__$1;
(statearr_17368_17394[(1)] = (9));

} else {
var statearr_17369_17395 = state_17360__$1;
(statearr_17369_17395[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (3))){
var inst_17358 = (state_17360[(2)]);
var state_17360__$1 = state_17360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17360__$1,inst_17358);
} else {
if((state_val_17361 === (12))){
var inst_17313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17314 = [null,r];
var inst_17315 = (new cljs.core.PersistentVector(null,2,(5),inst_17313,inst_17314,null));
var state_17360__$1 = state_17360;
var statearr_17370_17396 = state_17360__$1;
(statearr_17370_17396[(2)] = inst_17315);

(statearr_17370_17396[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (2))){
var _ = (function (){var statearr_17371 = state_17360;
(statearr_17371[(4)] = cljs.core.cons((5),(state_17360[(4)])));

return statearr_17371;
})();
var inst_17301 = (r == null);
var state_17360__$1 = state_17360;
if(cljs.core.truth_(inst_17301)){
var statearr_17372_17397 = state_17360__$1;
(statearr_17372_17397[(1)] = (6));

} else {
var statearr_17373_17398 = state_17360__$1;
(statearr_17373_17398[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (11))){
var inst_17311 = (state_17360[(2)]);
var state_17360__$1 = state_17360;
if(cljs.core.truth_(inst_17311)){
var statearr_17375_17399 = state_17360__$1;
(statearr_17375_17399[(1)] = (12));

} else {
var statearr_17376_17400 = state_17360__$1;
(statearr_17376_17400[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (9))){
var inst_17304 = (state_17360[(8)]);
var inst_17307 = cljs.core.empty_QMARK_(inst_17304);
var inst_17308 = (!(inst_17307));
var state_17360__$1 = state_17360;
var statearr_17377_17401 = state_17360__$1;
(statearr_17377_17401[(2)] = inst_17308);

(statearr_17377_17401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (5))){
var _ = (function (){var statearr_17378 = state_17360;
(statearr_17378[(4)] = cljs.core.rest((state_17360[(4)])));

return statearr_17378;
})();
var state_17360__$1 = state_17360;
var ex17374 = (state_17360__$1[(2)]);
var statearr_17379_17402 = state_17360__$1;
(statearr_17379_17402[(5)] = ex17374);


if((ex17374 instanceof Error)){
var statearr_17380_17403 = state_17360__$1;
(statearr_17380_17403[(1)] = (4));

(statearr_17380_17403[(5)] = null);

} else {
throw ex17374;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (14))){
var inst_17347 = (state_17360[(2)]);
var state_17360__$1 = state_17360;
var statearr_17381_17404 = state_17360__$1;
(statearr_17381_17404[(2)] = inst_17347);

(statearr_17381_17404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (10))){
var inst_17305 = (state_17360[(9)]);
var state_17360__$1 = state_17360;
var statearr_17382_17405 = state_17360__$1;
(statearr_17382_17405[(2)] = inst_17305);

(statearr_17382_17405[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17361 === (8))){
var inst_17355 = (state_17360[(2)]);
var _ = (function (){var statearr_17383 = state_17360;
(statearr_17383[(4)] = cljs.core.rest((state_17360[(4)])));

return statearr_17383;
})();
var state_17360__$1 = state_17360;
var statearr_17384_17406 = state_17360__$1;
(statearr_17384_17406[(2)] = inst_17355);

(statearr_17384_17406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_17385 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17385[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__);

(statearr_17385[(1)] = (1));

return statearr_17385;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____1 = (function (state_17360){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17360);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17386){var ex__2736__auto__ = e17386;
var statearr_17387_17407 = state_17360;
(statearr_17387_17407[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17360[(4)]))){
var statearr_17388_17408 = state_17360;
(statearr_17388_17408[(1)] = cljs.core.first((state_17360[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17409 = state_17360;
state_17360 = G__17409;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__ = function(state_17360){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____1.call(this,state_17360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17389 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17389[(6)] = c__2755__auto__);

return statearr_17389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__17411 = arguments.length;
switch (G__17411) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17505){
var state_val_17506 = (state_17505[(1)]);
if((state_val_17506 === (7))){
var inst_17418 = (state_17505[(7)]);
var inst_17428 = clojure.string.starts_with_QMARK_(inst_17418,"$fdb");
var state_17505__$1 = state_17505;
if(inst_17428){
var statearr_17507_17556 = state_17505__$1;
(statearr_17507_17556[(1)] = (9));

} else {
var statearr_17508_17557 = state_17505__$1;
(statearr_17508_17557[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (20))){
var state_17505__$1 = state_17505;
var statearr_17509_17558 = state_17505__$1;
(statearr_17509_17558[(2)] = null);

(statearr_17509_17558[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (27))){
var inst_17468 = (state_17505[(8)]);
var state_17505__$1 = state_17505;
var statearr_17510_17559 = state_17505__$1;
(statearr_17510_17559[(2)] = inst_17468);

(statearr_17510_17559[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (1))){
var state_17505__$1 = state_17505;
var statearr_17511_17560 = state_17505__$1;
(statearr_17511_17560[(2)] = null);

(statearr_17511_17560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (24))){
var inst_17491 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
var statearr_17512_17561 = state_17505__$1;
(statearr_17512_17561[(2)] = inst_17491);

(statearr_17512_17561[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (4))){
var inst_17412 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
var statearr_17513_17562 = state_17505__$1;
(statearr_17513_17562[(2)] = inst_17412);

(statearr_17513_17562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (15))){
var inst_17435 = (state_17505[(9)]);
var inst_17441 = (state_17505[(2)]);
var inst_17442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17443 = cljs.core.PersistentVector.EMPTY;
var inst_17444 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_17445 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_17443,inst_17444);
var inst_17446 = [inst_17435,inst_17445];
var inst_17447 = (new cljs.core.PersistentVector(null,2,(5),inst_17442,inst_17446,null));
var state_17505__$1 = (function (){var statearr_17514 = state_17505;
(statearr_17514[(10)] = inst_17441);

return statearr_17514;
})();
var statearr_17515_17563 = state_17505__$1;
(statearr_17515_17563[(2)] = inst_17447);

(statearr_17515_17563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (21))){
var inst_17494 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
var statearr_17516_17564 = state_17505__$1;
(statearr_17516_17564[(2)] = inst_17494);

(statearr_17516_17564[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (13))){
var inst_17435 = (state_17505[(9)]);
var inst_17438 = (function(){throw inst_17435})();
var state_17505__$1 = state_17505;
var statearr_17517_17565 = state_17505__$1;
(statearr_17517_17565[(2)] = inst_17438);

(statearr_17517_17565[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (22))){
var inst_17459 = (state_17505[(11)]);
var inst_17457 = (state_17505[(12)]);
var inst_17461 = fluree.db.query.analytical.parse_block_from_source(inst_17457);
var inst_17462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17463 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_17459];
var inst_17464 = (new cljs.core.PersistentVector(null,2,(5),inst_17462,inst_17463,null));
var inst_17465 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_17464);
var state_17505__$1 = (function (){var statearr_17518 = state_17505;
(statearr_17518[(13)] = inst_17461);

return statearr_17518;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17505__$1,(25),inst_17465);
} else {
if((state_val_17506 === (29))){
var inst_17472 = (state_17505[(2)]);
var inst_17473 = fluree.db.util.async.throw_err(inst_17472);
var state_17505__$1 = state_17505;
var statearr_17519_17566 = state_17505__$1;
(statearr_17519_17566[(2)] = inst_17473);

(statearr_17519_17566[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (6))){
var inst_17421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17422 = cljs.core.PersistentVector.EMPTY;
var inst_17423 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_17424 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_17422,inst_17423);
var inst_17425 = [db,inst_17424];
var inst_17426 = (new cljs.core.PersistentVector(null,2,(5),inst_17421,inst_17425,null));
var state_17505__$1 = state_17505;
var statearr_17520_17567 = state_17505__$1;
(statearr_17520_17567[(2)] = inst_17426);

(statearr_17520_17567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (28))){
var inst_17476 = (state_17505[(2)]);
var inst_17477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17478 = cljs.core.PersistentVector.EMPTY;
var inst_17479 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_17480 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_17478,inst_17479);
var inst_17481 = [inst_17476,inst_17480];
var inst_17482 = (new cljs.core.PersistentVector(null,2,(5),inst_17477,inst_17481,null));
var state_17505__$1 = state_17505;
var statearr_17521_17568 = state_17505__$1;
(statearr_17521_17568[(2)] = inst_17482);

(statearr_17521_17568[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (25))){
var inst_17461 = (state_17505[(13)]);
var inst_17467 = (state_17505[(2)]);
var inst_17468 = fluree.db.util.async.throw_err(inst_17467);
var state_17505__$1 = (function (){var statearr_17522 = state_17505;
(statearr_17522[(8)] = inst_17468);

return statearr_17522;
})();
if(cljs.core.truth_(inst_17461)){
var statearr_17523_17569 = state_17505__$1;
(statearr_17523_17569[(1)] = (26));

} else {
var statearr_17524_17570 = state_17505__$1;
(statearr_17524_17570[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (17))){
var state_17505__$1 = state_17505;
var statearr_17525_17571 = state_17505__$1;
(statearr_17525_17571[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (3))){
var inst_17503 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17505__$1,inst_17503);
} else {
if((state_val_17506 === (12))){
var inst_17435 = (state_17505[(9)]);
var inst_17434 = (state_17505[(2)]);
var inst_17435__$1 = fluree.db.util.async.throw_err(inst_17434);
var inst_17436 = fluree.db.util.core.exception_QMARK_(inst_17435__$1);
var state_17505__$1 = (function (){var statearr_17527 = state_17505;
(statearr_17527[(9)] = inst_17435__$1);

return statearr_17527;
})();
if(inst_17436){
var statearr_17528_17572 = state_17505__$1;
(statearr_17528_17572[(1)] = (13));

} else {
var statearr_17529_17573 = state_17505__$1;
(statearr_17529_17573[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (2))){
var inst_17418 = (state_17505[(7)]);
var _ = (function (){var statearr_17530 = state_17505;
(statearr_17530[(4)] = cljs.core.cons((5),(state_17505[(4)])));

return statearr_17530;
})();
var inst_17418__$1 = cljs.core.first(clause);
var inst_17419 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_17418__$1);
var state_17505__$1 = (function (){var statearr_17531 = state_17505;
(statearr_17531[(7)] = inst_17418__$1);

return statearr_17531;
})();
if(inst_17419){
var statearr_17532_17574 = state_17505__$1;
(statearr_17532_17574[(1)] = (6));

} else {
var statearr_17533_17575 = state_17505__$1;
(statearr_17533_17575[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (23))){
var inst_17418 = (state_17505[(7)]);
var inst_17484 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17418)," is not supported in Fluree"].join('');
var inst_17485 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17486 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17487 = cljs.core.PersistentHashMap.fromArrays(inst_17485,inst_17486);
var inst_17488 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17484,inst_17487);
var inst_17489 = (function(){throw inst_17488})();
var state_17505__$1 = state_17505;
var statearr_17534_17576 = state_17505__$1;
(statearr_17534_17576[(2)] = inst_17489);

(statearr_17534_17576[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (19))){
var inst_17418 = (state_17505[(7)]);
var inst_17459 = (state_17505[(11)]);
var inst_17456 = fluree.db.query.analytical.isolate_source_name(inst_17418);
var inst_17457 = fluree.db.query.analytical.isolate_source_block(inst_17418);
var inst_17458 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_17456);
var inst_17459__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_17458);
var state_17505__$1 = (function (){var statearr_17535 = state_17505;
(statearr_17535[(11)] = inst_17459__$1);

(statearr_17535[(12)] = inst_17457);

return statearr_17535;
})();
if(cljs.core.truth_(inst_17459__$1)){
var statearr_17536_17577 = state_17505__$1;
(statearr_17536_17577[(1)] = (22));

} else {
var statearr_17537_17578 = state_17505__$1;
(statearr_17537_17578[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (11))){
var inst_17498 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
var statearr_17539_17579 = state_17505__$1;
(statearr_17539_17579[(2)] = inst_17498);

(statearr_17539_17579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (9))){
var inst_17418 = (state_17505[(7)]);
var inst_17430 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_17418,(4));
var inst_17431 = fluree.db.query.analytical.parse_block_from_source(inst_17430);
var inst_17432 = fluree.db.time_travel.as_of_block(db,inst_17431);
var state_17505__$1 = state_17505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17505__$1,(12),inst_17432);
} else {
if((state_val_17506 === (5))){
var _ = (function (){var statearr_17540 = state_17505;
(statearr_17540[(4)] = cljs.core.rest((state_17505[(4)])));

return statearr_17540;
})();
var state_17505__$1 = state_17505;
var ex17538 = (state_17505__$1[(2)]);
var statearr_17541_17580 = state_17505__$1;
(statearr_17541_17580[(5)] = ex17538);


if((ex17538 instanceof Error)){
var statearr_17542_17581 = state_17505__$1;
(statearr_17542_17581[(1)] = (4));

(statearr_17542_17581[(5)] = null);

} else {
throw ex17538;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (14))){
var state_17505__$1 = state_17505;
var statearr_17543_17582 = state_17505__$1;
(statearr_17543_17582[(2)] = null);

(statearr_17543_17582[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (26))){
var inst_17461 = (state_17505[(13)]);
var inst_17468 = (state_17505[(8)]);
var inst_17470 = fluree.db.time_travel.as_of_block(inst_17468,inst_17461);
var state_17505__$1 = state_17505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17505__$1,(29),inst_17470);
} else {
if((state_val_17506 === (16))){
var inst_17451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17452 = ["$wd",clause];
var inst_17453 = (new cljs.core.PersistentVector(null,2,(5),inst_17451,inst_17452,null));
var state_17505__$1 = state_17505;
var statearr_17544_17583 = state_17505__$1;
(statearr_17544_17583[(2)] = inst_17453);

(statearr_17544_17583[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (10))){
var inst_17418 = (state_17505[(7)]);
var inst_17449 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_17418);
var state_17505__$1 = state_17505;
if(inst_17449){
var statearr_17545_17584 = state_17505__$1;
(statearr_17545_17584[(1)] = (16));

} else {
var statearr_17546_17585 = state_17505__$1;
(statearr_17546_17585[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (18))){
var inst_17496 = (state_17505[(2)]);
var state_17505__$1 = state_17505;
var statearr_17547_17586 = state_17505__$1;
(statearr_17547_17586[(2)] = inst_17496);

(statearr_17547_17586[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17506 === (8))){
var inst_17500 = (state_17505[(2)]);
var _ = (function (){var statearr_17548 = state_17505;
(statearr_17548[(4)] = cljs.core.rest((state_17505[(4)])));

return statearr_17548;
})();
var state_17505__$1 = state_17505;
var statearr_17549_17587 = state_17505__$1;
(statearr_17549_17587[(2)] = inst_17500);

(statearr_17549_17587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2733__auto__ = null;
var fluree$db$query$analytical$state_machine__2733__auto____0 = (function (){
var statearr_17550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17550[(0)] = fluree$db$query$analytical$state_machine__2733__auto__);

(statearr_17550[(1)] = (1));

return statearr_17550;
});
var fluree$db$query$analytical$state_machine__2733__auto____1 = (function (state_17505){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17505);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17551){var ex__2736__auto__ = e17551;
var statearr_17552_17588 = state_17505;
(statearr_17552_17588[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17505[(4)]))){
var statearr_17553_17589 = state_17505;
(statearr_17553_17589[(1)] = cljs.core.first((state_17505[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17590 = state_17505;
state_17505 = G__17590;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2733__auto__ = function(state_17505){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2733__auto____1.call(this,state_17505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2733__auto____0;
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2733__auto____1;
return fluree$db$query$analytical$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17554 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17554[(6)] = c__2755__auto__);

return statearr_17554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__17591){
var vec__17592 = p__17591;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17592,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17592,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17595_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__17595_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__17599 = subjects;
var vec__17600 = G__17599;
var seq__17601 = cljs.core.seq(vec__17600);
var first__17602 = cljs.core.first(seq__17601);
var seq__17601__$1 = cljs.core.next(seq__17601);
var subject = first__17602;
var r = seq__17601__$1;
var acc = expanded_map;
var G__17599__$1 = G__17599;
var acc__$1 = acc;
while(true){
var vec__17606 = G__17599__$1;
var seq__17607 = cljs.core.seq(vec__17606);
var first__17608 = cljs.core.first(seq__17607);
var seq__17607__$1 = cljs.core.next(seq__17607);
var subject__$1 = first__17608;
var r__$1 = seq__17607__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__17609 = r__$1;
var G__17610 = acc__$2;
G__17599__$1 = G__17609;
acc__$1 = G__17610;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__17599__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17606,seq__17607,first__17608,seq__17607__$1,subject__$1,r__$1,acc__$2,G__17599,vec__17600,seq__17601,first__17602,seq__17601__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4223__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__17599__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17606,seq__17607,first__17608,seq__17607__$1,subject__$1,r__$1,acc__$2,G__17599,vec__17600,seq__17601,first__17602,seq__17601__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__17599__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17606,seq__17607,first__17608,seq__17607__$1,subject__$1,r__$1,acc__$2,G__17599,vec__17600,seq__17601,first__17602,seq__17601__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__17599__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17606,seq__17607,first__17608,seq__17607__$1,subject__$1,r__$1,acc__$2,G__17599,vec__17600,seq__17601,first__17602,seq__17601__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__17599__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17606,seq__17607,first__17608,seq__17607__$1,subject__$1,r__$1,acc__$2,G__17599,vec__17600,seq__17601,first__17602,seq__17601__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__17599__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17606,seq__17607,first__17608,seq__17607__$1,subject__$1,r__$1,acc__$2,G__17599,vec__17600,seq__17601,first__17602,seq__17601__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__17611 = r__$1;
var G__17612 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__17599__$1 = G__17611;
acc__$1 = G__17612;
continue;
} else {
var G__17613 = subjects;
var G__17614 = acc_STAR_;
G__17599__$1 = G__17613;
acc__$1 = G__17614;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__17615_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__17615_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17706){
var state_val_17707 = (state_17706[(1)]);
if((state_val_17707 === (7))){
var state_17706__$1 = state_17706;
var statearr_17708_17754 = state_17706__$1;
(statearr_17708_17754[(2)] = (100));

(statearr_17708_17754[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (20))){
var inst_17655 = (state_17706[(7)]);
var state_17706__$1 = state_17706;
var statearr_17709_17755 = state_17706__$1;
(statearr_17709_17755[(2)] = inst_17655);

(statearr_17709_17755[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (1))){
var state_17706__$1 = state_17706;
var statearr_17710_17756 = state_17706__$1;
(statearr_17710_17756[(2)] = null);

(statearr_17710_17756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (24))){
var inst_17692 = (state_17706[(8)]);
var inst_17693 = (state_17706[(9)]);
var inst_17694 = (state_17706[(10)]);
var inst_17627 = (state_17706[(11)]);
var inst_17697 = (function (){var max_depth = inst_17627;
var recur_map__$1 = inst_17693;
var subjects = inst_17692;
var tuples = inst_17694;
return (function (p1__17616_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__17616_SHARP_)],null));
});
})();
var inst_17698 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_17697,inst_17694);
var inst_17699 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_17698);
var state_17706__$1 = state_17706;
var statearr_17711_17757 = state_17706__$1;
(statearr_17711_17757[(2)] = inst_17699);

(statearr_17711_17757[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (4))){
var inst_17617 = (state_17706[(2)]);
var state_17706__$1 = state_17706;
var statearr_17712_17758 = state_17706__$1;
(statearr_17712_17758[(2)] = inst_17617);

(statearr_17712_17758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (15))){
var inst_17640 = (state_17706[(12)]);
var inst_17651 = cljs.core.PersistentVector.EMPTY;
var inst_17652 = cljs.core.seq(inst_17640);
var inst_17653 = cljs.core.first(inst_17652);
var inst_17654 = cljs.core.next(inst_17652);
var inst_17655 = inst_17651;
var inst_17656 = inst_17640;
var state_17706__$1 = (function (){var statearr_17713 = state_17706;
(statearr_17713[(13)] = inst_17653);

(statearr_17713[(14)] = inst_17656);

(statearr_17713[(15)] = inst_17654);

(statearr_17713[(7)] = inst_17655);

return statearr_17713;
})();
var statearr_17714_17759 = state_17706__$1;
(statearr_17714_17759[(2)] = null);

(statearr_17714_17759[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (21))){
var inst_17676 = (state_17706[(2)]);
var state_17706__$1 = state_17706;
var statearr_17715_17760 = state_17706__$1;
(statearr_17715_17760[(2)] = inst_17676);

(statearr_17715_17760[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (13))){
var inst_17689 = (state_17706[(2)]);
var state_17706__$1 = state_17706;
var statearr_17716_17761 = state_17706__$1;
(statearr_17716_17761[(2)] = inst_17689);

(statearr_17716_17761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (22))){
var inst_17655 = (state_17706[(7)]);
var inst_17663 = (state_17706[(16)]);
var inst_17670 = (state_17706[(2)]);
var inst_17671 = fluree.db.util.async.throw_err(inst_17670);
var inst_17672 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_17655,inst_17671);
var inst_17655__$1 = inst_17672;
var inst_17656 = inst_17663;
var state_17706__$1 = (function (){var statearr_17717 = state_17706;
(statearr_17717[(14)] = inst_17656);

(statearr_17717[(7)] = inst_17655__$1);

return statearr_17717;
})();
var statearr_17718_17762 = state_17706__$1;
(statearr_17718_17762[(2)] = null);

(statearr_17718_17762[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (6))){
var inst_17623 = (state_17706[(17)]);
var state_17706__$1 = state_17706;
var statearr_17719_17763 = state_17706__$1;
(statearr_17719_17763[(2)] = inst_17623);

(statearr_17719_17763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (25))){
var inst_17701 = (state_17706[(2)]);
var _ = (function (){var statearr_17720 = state_17706;
(statearr_17720[(4)] = cljs.core.rest((state_17706[(4)])));

return statearr_17720;
})();
var state_17706__$1 = state_17706;
var statearr_17721_17764 = state_17706__$1;
(statearr_17721_17764[(2)] = inst_17701);

(statearr_17721_17764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (17))){
var inst_17656 = (state_17706[(14)]);
var inst_17662 = (state_17706[(18)]);
var inst_17661 = cljs.core.seq(inst_17656);
var inst_17662__$1 = cljs.core.first(inst_17661);
var inst_17663 = cljs.core.next(inst_17661);
var state_17706__$1 = (function (){var statearr_17722 = state_17706;
(statearr_17722[(18)] = inst_17662__$1);

(statearr_17722[(16)] = inst_17663);

return statearr_17722;
})();
if(cljs.core.truth_(inst_17662__$1)){
var statearr_17723_17765 = state_17706__$1;
(statearr_17723_17765[(1)] = (19));

} else {
var statearr_17724_17766 = state_17706__$1;
(statearr_17724_17766[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (3))){
var inst_17704 = (state_17706[(2)]);
var state_17706__$1 = state_17706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17706__$1,inst_17704);
} else {
if((state_val_17707 === (12))){
var inst_17640 = (state_17706[(12)]);
var inst_17629 = (state_17706[(19)]);
var inst_17635 = cljs.core.vals(inst_17629);
var inst_17636 = cljs.core.flatten(inst_17635);
var inst_17637 = cljs.core.set(inst_17636);
var inst_17638 = cljs.core.keys(inst_17629);
var inst_17639 = cljs.core.set(inst_17638);
var inst_17640__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_17637,inst_17639);
var inst_17641 = cljs.core.empty_QMARK_(inst_17640__$1);
var state_17706__$1 = (function (){var statearr_17725 = state_17706;
(statearr_17725[(12)] = inst_17640__$1);

return statearr_17725;
})();
if(inst_17641){
var statearr_17726_17767 = state_17706__$1;
(statearr_17726_17767[(1)] = (14));

} else {
var statearr_17727_17768 = state_17706__$1;
(statearr_17727_17768[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (2))){
var inst_17623 = (state_17706[(17)]);
var _ = (function (){var statearr_17728 = state_17706;
(statearr_17728[(4)] = cljs.core.cons((5),(state_17706[(4)])));

return statearr_17728;
})();
var inst_17623__$1 = depth;
var state_17706__$1 = (function (){var statearr_17729 = state_17706;
(statearr_17729[(17)] = inst_17623__$1);

return statearr_17729;
})();
if(cljs.core.truth_(inst_17623__$1)){
var statearr_17730_17769 = state_17706__$1;
(statearr_17730_17769[(1)] = (6));

} else {
var statearr_17731_17770 = state_17706__$1;
(statearr_17731_17770[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (23))){
var inst_17694 = (state_17706[(10)]);
var state_17706__$1 = state_17706;
var statearr_17732_17771 = state_17706__$1;
(statearr_17732_17771[(2)] = inst_17694);

(statearr_17732_17771[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (19))){
var inst_17662 = (state_17706[(18)]);
var inst_17665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17666 = [inst_17662,predicate];
var inst_17667 = (new cljs.core.PersistentVector(null,2,(5),inst_17665,inst_17666,null));
var inst_17668 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17667);
var state_17706__$1 = state_17706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17706__$1,(22),inst_17668);
} else {
if((state_val_17707 === (11))){
var inst_17629 = (state_17706[(19)]);
var state_17706__$1 = state_17706;
var statearr_17734_17772 = state_17706__$1;
(statearr_17734_17772[(2)] = inst_17629);

(statearr_17734_17772[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (9))){
var inst_17630 = (state_17706[(20)]);
var inst_17627 = (state_17706[(11)]);
var inst_17632 = (inst_17630 >= inst_17627);
var state_17706__$1 = state_17706;
if(cljs.core.truth_(inst_17632)){
var statearr_17735_17773 = state_17706__$1;
(statearr_17735_17773[(1)] = (11));

} else {
var statearr_17736_17774 = state_17706__$1;
(statearr_17736_17774[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (5))){
var _ = (function (){var statearr_17737 = state_17706;
(statearr_17737[(4)] = cljs.core.rest((state_17706[(4)])));

return statearr_17737;
})();
var state_17706__$1 = state_17706;
var ex17733 = (state_17706__$1[(2)]);
var statearr_17738_17775 = state_17706__$1;
(statearr_17738_17775[(5)] = ex17733);


if((ex17733 instanceof Error)){
var statearr_17739_17776 = state_17706__$1;
(statearr_17739_17776[(1)] = (4));

(statearr_17739_17776[(5)] = null);

} else {
throw ex17733;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (14))){
var inst_17629 = (state_17706[(19)]);
var state_17706__$1 = state_17706;
var statearr_17740_17777 = state_17706__$1;
(statearr_17740_17777[(2)] = inst_17629);

(statearr_17740_17777[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (16))){
var inst_17687 = (state_17706[(2)]);
var state_17706__$1 = state_17706;
var statearr_17741_17778 = state_17706__$1;
(statearr_17741_17778[(2)] = inst_17687);

(statearr_17741_17778[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (10))){
var inst_17692 = (state_17706[(8)]);
var inst_17693 = (state_17706[(9)]);
var inst_17691 = (state_17706[(2)]);
var inst_17692__$1 = cljs.core.keys(inst_17691);
var inst_17693__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_17692__$1,inst_17691);
var inst_17694 = fluree.db.query.analytical.recur_map__GT_tuples(inst_17692__$1,inst_17693__$1);
var state_17706__$1 = (function (){var statearr_17742 = state_17706;
(statearr_17742[(8)] = inst_17692__$1);

(statearr_17742[(9)] = inst_17693__$1);

(statearr_17742[(10)] = inst_17694);

return statearr_17742;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_17743_17779 = state_17706__$1;
(statearr_17743_17779[(1)] = (23));

} else {
var statearr_17744_17780 = state_17706__$1;
(statearr_17744_17780[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (18))){
var inst_17629 = (state_17706[(19)]);
var inst_17630 = (state_17706[(20)]);
var inst_17678 = (state_17706[(2)]);
var inst_17679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17680 = [(0),(2)];
var inst_17681 = (new cljs.core.PersistentVector(null,2,(5),inst_17679,inst_17680,null));
var inst_17682 = fluree.db.query.analytical.get_ns_arrays(inst_17681,inst_17678);
var inst_17683 = fluree.db.query.analytical.tuples__GT_map(inst_17629,inst_17682);
var inst_17684 = (inst_17630 + (1));
var inst_17629__$1 = inst_17683;
var inst_17630__$1 = inst_17684;
var state_17706__$1 = (function (){var statearr_17745 = state_17706;
(statearr_17745[(19)] = inst_17629__$1);

(statearr_17745[(20)] = inst_17630__$1);

return statearr_17745;
})();
var statearr_17746_17781 = state_17706__$1;
(statearr_17746_17781[(2)] = null);

(statearr_17746_17781[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17707 === (8))){
var inst_17627 = (state_17706[(2)]);
var inst_17628 = recur_map;
var inst_17629 = inst_17628;
var inst_17630 = (1);
var state_17706__$1 = (function (){var statearr_17747 = state_17706;
(statearr_17747[(19)] = inst_17629);

(statearr_17747[(20)] = inst_17630);

(statearr_17747[(11)] = inst_17627);

return statearr_17747;
})();
var statearr_17748_17782 = state_17706__$1;
(statearr_17748_17782[(2)] = null);

(statearr_17748_17782[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____0 = (function (){
var statearr_17749 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17749[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__);

(statearr_17749[(1)] = (1));

return statearr_17749;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____1 = (function (state_17706){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17706);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17750){var ex__2736__auto__ = e17750;
var statearr_17751_17783 = state_17706;
(statearr_17751_17783[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17706[(4)]))){
var statearr_17752_17784 = state_17706;
(statearr_17752_17784[(1)] = cljs.core.first((state_17706[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17785 = state_17706;
state_17706 = G__17785;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__ = function(state_17706){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____1.call(this,state_17706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17753 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17753[(6)] = c__2755__auto__);

return statearr_17753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__17786,clause,fuel,max_fuel){
var map__17787 = p__17786;
var map__17787__$1 = cljs.core.__destructure_map(map__17787);
var res = map__17787__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17787__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17787__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17787__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_17898){
var state_val_17899 = (state_17898[(1)]);
if((state_val_17899 === (7))){
var inst_17804 = (state_17898[(7)]);
var state_17898__$1 = state_17898;
var statearr_17900_17953 = state_17898__$1;
(statearr_17900_17953[(2)] = inst_17804);

(statearr_17900_17953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (20))){
var inst_17832 = (state_17898[(8)]);
var inst_17863 = typeof inst_17832 === 'number';
var state_17898__$1 = state_17898;
if(cljs.core.truth_(inst_17863)){
var statearr_17901_17954 = state_17898__$1;
(statearr_17901_17954[(1)] = (22));

} else {
var statearr_17902_17955 = state_17898__$1;
(statearr_17902_17955[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (27))){
var inst_17878 = (state_17898[(2)]);
var state_17898__$1 = state_17898;
var statearr_17903_17956 = state_17898__$1;
(statearr_17903_17956[(2)] = inst_17878);

(statearr_17903_17956[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (1))){
var state_17898__$1 = state_17898;
var statearr_17904_17957 = state_17898__$1;
(statearr_17904_17957[(2)] = null);

(statearr_17904_17957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (24))){
var inst_17880 = (state_17898[(2)]);
var state_17898__$1 = state_17898;
var statearr_17905_17958 = state_17898__$1;
(statearr_17905_17958[(2)] = inst_17880);

(statearr_17905_17958[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (4))){
var inst_17788 = (state_17898[(2)]);
var state_17898__$1 = state_17898;
var statearr_17906_17959 = state_17898__$1;
(statearr_17906_17959[(2)] = inst_17788);

(statearr_17906_17959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (15))){
var inst_17846 = (state_17898[(2)]);
var inst_17847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_17848 = fluree.db.query.analytical.variable_QMARK_(inst_17847);
var state_17898__$1 = (function (){var statearr_17907 = state_17898;
(statearr_17907[(9)] = inst_17846);

return statearr_17907;
})();
if(cljs.core.truth_(inst_17848)){
var statearr_17908_17960 = state_17898__$1;
(statearr_17908_17960[(1)] = (16));

} else {
var statearr_17909_17961 = state_17898__$1;
(statearr_17909_17961[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (21))){
var inst_17834 = (state_17898[(10)]);
var inst_17835 = (state_17898[(11)]);
var inst_17805 = (state_17898[(12)]);
var inst_17882 = (state_17898[(2)]);
var inst_17883 = fluree.db.query.analytical.tuples__GT_recur(db,inst_17835,inst_17882,inst_17805,inst_17834);
var state_17898__$1 = state_17898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17898__$1,(28),inst_17883);
} else {
if((state_val_17899 === (13))){
var inst_17814 = (state_17898[(13)]);
var inst_17838 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17814)].join('');
var inst_17839 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17840 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17841 = cljs.core.PersistentHashMap.fromArrays(inst_17839,inst_17840);
var inst_17842 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17838,inst_17841);
var inst_17843 = (function(){throw inst_17842})();
var state_17898__$1 = state_17898;
var statearr_17910_17962 = state_17898__$1;
(statearr_17910_17962[(2)] = inst_17843);

(statearr_17910_17962[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (22))){
var inst_17832 = (state_17898[(8)]);
var inst_17830 = (state_17898[(14)]);
var inst_17865 = cljs.core.PersistentHashMap.EMPTY;
var inst_17866 = cljs.core.flatten(inst_17830);
var inst_17867 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17865,inst_17832,inst_17866);
var state_17898__$1 = state_17898;
var statearr_17911_17963 = state_17898__$1;
(statearr_17911_17963[(2)] = inst_17867);

(statearr_17911_17963[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (6))){
var inst_17816 = (state_17898[(15)]);
var state_17898__$1 = state_17898;
var statearr_17912_17964 = state_17898__$1;
(statearr_17912_17964[(2)] = inst_17816);

(statearr_17912_17964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (28))){
var inst_17885 = (state_17898[(2)]);
var inst_17886 = fluree.db.util.async.throw_err(inst_17885);
var state_17898__$1 = state_17898;
var statearr_17913_17965 = state_17898__$1;
(statearr_17913_17965[(2)] = inst_17886);

(statearr_17913_17965[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (25))){
var inst_17826 = (state_17898[(16)]);
var inst_17830 = (state_17898[(14)]);
var inst_17871 = cljs.core.PersistentHashMap.EMPTY;
var inst_17872 = cljs.core.first(inst_17826);
var inst_17873 = cljs.core.first(inst_17872);
var inst_17874 = cljs.core.flatten(inst_17830);
var inst_17875 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17871,inst_17873,inst_17874);
var state_17898__$1 = state_17898;
var statearr_17914_17966 = state_17898__$1;
(statearr_17914_17966[(2)] = inst_17875);

(statearr_17914_17966[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (17))){
var inst_17814 = (state_17898[(13)]);
var inst_17851 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17814)].join('');
var inst_17852 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17853 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17854 = cljs.core.PersistentHashMap.fromArrays(inst_17852,inst_17853);
var inst_17855 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17851,inst_17854);
var inst_17856 = (function(){throw inst_17855})();
var state_17898__$1 = state_17898;
var statearr_17915_17967 = state_17898__$1;
(statearr_17915_17967[(2)] = inst_17856);

(statearr_17915_17967[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (3))){
var inst_17896 = (state_17898[(2)]);
var state_17898__$1 = state_17898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17898__$1,inst_17896);
} else {
if((state_val_17899 === (12))){
var inst_17801 = (state_17898[(17)]);
var inst_17889 = (state_17898[(2)]);
var inst_17890 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_17891 = cljs.core.keys(inst_17801);
var inst_17892 = [inst_17891,vars,inst_17889];
var inst_17893 = cljs.core.PersistentHashMap.fromArrays(inst_17890,inst_17892);
var _ = (function (){var statearr_17916 = state_17898;
(statearr_17916[(4)] = cljs.core.rest((state_17898[(4)])));

return statearr_17916;
})();
var state_17898__$1 = state_17898;
var statearr_17917_17968 = state_17898__$1;
(statearr_17917_17968[(2)] = inst_17893);

(statearr_17917_17968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (2))){
var inst_17804 = (state_17898[(7)]);
var inst_17805 = (state_17898[(12)]);
var inst_17801 = (state_17898[(17)]);
var inst_17816 = (state_17898[(15)]);
var _ = (function (){var statearr_17918 = state_17898;
(statearr_17918[(4)] = cljs.core.cons((5),(state_17898[(4)])));

return statearr_17918;
})();
var inst_17798 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_17799 = cljs.core.__destructure_map(inst_17798);
var inst_17800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17799,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_17801__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17799,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_17802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17799,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_17803 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_17804__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17802);
var inst_17805__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_17802);
var inst_17807 = (function (){var map__17794 = inst_17799;
var search = inst_17800;
var rel = inst_17801__$1;
var opts = inst_17802;
var common_keys = inst_17803;
var object_fn = inst_17804__$1;
var recur_depth = inst_17805__$1;
return (function (p__17806,common_key){
var vec__17919 = p__17806;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17919,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17919,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__17922 = cljs.core._EQ_;
var expr__17923 = idx_of;
if(cljs.core.truth_((pred__17922.cljs$core$IFn$_invoke$arity$2 ? pred__17922.cljs$core$IFn$_invoke$arity$2((0),expr__17923) : pred__17922.call(null,(0),expr__17923)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__17922.cljs$core$IFn$_invoke$arity$2 ? pred__17922.cljs$core$IFn$_invoke$arity$2((1),expr__17923) : pred__17922.call(null,(1),expr__17923)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__17922.cljs$core$IFn$_invoke$arity$2 ? pred__17922.cljs$core$IFn$_invoke$arity$2((2),expr__17923) : pred__17922.call(null,(2),expr__17923)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__17923)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4221__auto__ = (!(single_v_QMARK_));
if(and__4221__auto__){
var and__4221__auto____$1 = object_fn;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_17808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17809 = cljs.core.PersistentHashMap.EMPTY;
var inst_17810 = [inst_17809,inst_17800];
var inst_17811 = (new cljs.core.PersistentVector(null,2,(5),inst_17808,inst_17810,null));
var inst_17812 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17807,inst_17811,inst_17803);
var inst_17813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17812,(0),null);
var inst_17814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17812,(1),null);
var inst_17815 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_17816__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17813);
var state_17898__$1 = (function (){var statearr_17925 = state_17898;
(statearr_17925[(7)] = inst_17804__$1);

(statearr_17925[(12)] = inst_17805__$1);

(statearr_17925[(17)] = inst_17801__$1);

(statearr_17925[(13)] = inst_17814);

(statearr_17925[(18)] = inst_17815);

(statearr_17925[(15)] = inst_17816__$1);

return statearr_17925;
})();
if(cljs.core.truth_(inst_17816__$1)){
var statearr_17926_17969 = state_17898__$1;
(statearr_17926_17969[(1)] = (6));

} else {
var statearr_17927_17970 = state_17898__$1;
(statearr_17927_17970[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (23))){
var inst_17832 = (state_17898[(8)]);
var inst_17869 = cljs.core.coll_QMARK_(inst_17832);
var state_17898__$1 = state_17898;
if(inst_17869){
var statearr_17928_17971 = state_17898__$1;
(statearr_17928_17971[(1)] = (25));

} else {
var statearr_17929_17972 = state_17898__$1;
(statearr_17929_17972[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (19))){
var inst_17830 = (state_17898[(14)]);
var inst_17860 = cljs.core.PersistentHashMap.EMPTY;
var inst_17861 = fluree.db.query.analytical.tuples__GT_map(inst_17860,inst_17830);
var state_17898__$1 = state_17898;
var statearr_17930_17973 = state_17898__$1;
(statearr_17930_17973[(2)] = inst_17861);

(statearr_17930_17973[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (11))){
var inst_17830 = (state_17898[(14)]);
var state_17898__$1 = state_17898;
var statearr_17932_17974 = state_17898__$1;
(statearr_17932_17974[(2)] = inst_17830);

(statearr_17932_17974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (9))){
var inst_17826 = (state_17898[(16)]);
var inst_17805 = (state_17898[(12)]);
var inst_17801 = (state_17898[(17)]);
var inst_17825 = (state_17898[(2)]);
var inst_17826__$1 = fluree.db.util.async.throw_err(inst_17825);
var inst_17827 = cljs.core.count(inst_17826__$1);
var inst_17828 = fluree.db.query.analytical.add_fuel(inst_17827,fuel,max_fuel);
var inst_17829 = cljs.core.vals(inst_17801);
var inst_17830 = fluree.db.query.analytical.get_ns_arrays(inst_17829,inst_17826__$1);
var state_17898__$1 = (function (){var statearr_17933 = state_17898;
(statearr_17933[(19)] = inst_17828);

(statearr_17933[(16)] = inst_17826__$1);

(statearr_17933[(14)] = inst_17830);

return statearr_17933;
})();
if(cljs.core.truth_(inst_17805)){
var statearr_17934_17975 = state_17898__$1;
(statearr_17934_17975[(1)] = (10));

} else {
var statearr_17935_17976 = state_17898__$1;
(statearr_17935_17976[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (5))){
var _ = (function (){var statearr_17936 = state_17898;
(statearr_17936[(4)] = cljs.core.rest((state_17898[(4)])));

return statearr_17936;
})();
var state_17898__$1 = state_17898;
var ex17931 = (state_17898__$1[(2)]);
var statearr_17937_17977 = state_17898__$1;
(statearr_17937_17977[(5)] = ex17931);


if((ex17931 instanceof Error)){
var statearr_17938_17978 = state_17898__$1;
(statearr_17938_17978[(1)] = (4));

(statearr_17938_17978[(5)] = null);

} else {
throw ex17931;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (14))){
var state_17898__$1 = state_17898;
var statearr_17939_17979 = state_17898__$1;
(statearr_17939_17979[(2)] = null);

(statearr_17939_17979[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (26))){
var state_17898__$1 = state_17898;
var statearr_17940_17980 = state_17898__$1;
(statearr_17940_17980[(2)] = null);

(statearr_17940_17980[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (16))){
var state_17898__$1 = state_17898;
var statearr_17941_17981 = state_17898__$1;
(statearr_17941_17981[(2)] = null);

(statearr_17941_17981[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (10))){
var inst_17835 = (state_17898[(11)]);
var inst_17814 = (state_17898[(13)]);
var inst_17832 = cljs.core.first(inst_17814);
var inst_17833 = cljs.core.first(clause);
var inst_17834 = fluree.db.query.analytical.variable_QMARK_(inst_17833);
var inst_17835__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_17814,(1));
var inst_17836 = fluree.db.query.analytical.variable_QMARK_(inst_17835__$1);
var state_17898__$1 = (function (){var statearr_17942 = state_17898;
(statearr_17942[(10)] = inst_17834);

(statearr_17942[(11)] = inst_17835__$1);

(statearr_17942[(8)] = inst_17832);

return statearr_17942;
})();
if(cljs.core.truth_(inst_17836)){
var statearr_17943_17982 = state_17898__$1;
(statearr_17943_17982[(1)] = (13));

} else {
var statearr_17944_17983 = state_17898__$1;
(statearr_17944_17983[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (18))){
var inst_17834 = (state_17898[(10)]);
var inst_17858 = (state_17898[(2)]);
var state_17898__$1 = (function (){var statearr_17945 = state_17898;
(statearr_17945[(20)] = inst_17858);

return statearr_17945;
})();
if(cljs.core.truth_(inst_17834)){
var statearr_17946_17984 = state_17898__$1;
(statearr_17946_17984[(1)] = (19));

} else {
var statearr_17947_17985 = state_17898__$1;
(statearr_17947_17985[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17899 === (8))){
var inst_17814 = (state_17898[(13)]);
var inst_17815 = (state_17898[(18)]);
var inst_17820 = (state_17898[(2)]);
var inst_17821 = [inst_17820];
var inst_17822 = cljs.core.PersistentHashMap.fromArrays(inst_17815,inst_17821);
var inst_17823 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_17814,inst_17822);
var state_17898__$1 = state_17898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17898__$1,(9),inst_17823);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_17948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17948[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__);

(statearr_17948[(1)] = (1));

return statearr_17948;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____1 = (function (state_17898){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_17898);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e17949){var ex__2736__auto__ = e17949;
var statearr_17950_17986 = state_17898;
(statearr_17950_17986[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_17898[(4)]))){
var statearr_17951_17987 = state_17898;
(statearr_17951_17987[(1)] = cljs.core.first((state_17898[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17988 = state_17898;
state_17898 = G__17988;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__ = function(state_17898){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____1.call(this,state_17898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_17952 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_17952[(6)] = c__2755__auto__);

return statearr_17952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__17989,res,clause){
var map__17990 = p__17989;
var map__17990__$1 = cljs.core.__destructure_map(map__17990);
var db = map__17990__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17990__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17990__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17990__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18089){
var state_val_18090 = (state_18089[(1)]);
if((state_val_18090 === (7))){
var inst_18000 = (state_18089[(7)]);
var state_18089__$1 = state_18089;
var statearr_18091_18131 = state_18089__$1;
(statearr_18091_18131[(2)] = inst_18000);

(statearr_18091_18131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (20))){
var inst_18080 = (state_18089[(2)]);
var state_18089__$1 = state_18089;
var statearr_18092_18132 = state_18089__$1;
(statearr_18092_18132[(2)] = inst_18080);

(statearr_18092_18132[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (1))){
var state_18089__$1 = state_18089;
var statearr_18093_18133 = state_18089__$1;
(statearr_18093_18133[(2)] = null);

(statearr_18093_18133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (24))){
var inst_18059 = (state_18089[(2)]);
var inst_18060 = fluree.db.util.async.throw_err(inst_18059);
var state_18089__$1 = state_18089;
var statearr_18094_18134 = state_18089__$1;
(statearr_18094_18134[(2)] = inst_18060);

(statearr_18094_18134[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (4))){
var inst_17993 = (state_18089[(2)]);
var state_18089__$1 = state_18089;
var statearr_18095_18135 = state_18089__$1;
(statearr_18095_18135[(2)] = inst_17993);

(statearr_18095_18135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (15))){
var inst_18000 = (state_18089[(7)]);
var inst_18002 = (state_18089[(8)]);
var inst_18021 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_18022 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18024 = [inst_18000];
var inst_18025 = (new cljs.core.PersistentVector(null,1,(5),inst_18023,inst_18024,null));
var inst_18026 = (function (){var subject_var = inst_18000;
var object_var = inst_18002;
var min_sid = inst_18021;
var max_sid = (0);
return (function (p1__17991_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__17991_SHARP_);
});
})();
var inst_18027 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_18021,(0));
var inst_18028 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18026,inst_18027);
var inst_18029 = cljs.core.PersistentHashMap.EMPTY;
var inst_18030 = [inst_18025,inst_18028,inst_18029];
var inst_18031 = cljs.core.PersistentHashMap.fromArrays(inst_18022,inst_18030);
var state_18089__$1 = state_18089;
var statearr_18096_18136 = state_18089__$1;
(statearr_18096_18136[(2)] = inst_18031);

(statearr_18096_18136[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (21))){
var inst_18053 = (state_18089[(9)]);
var state_18089__$1 = state_18089;
var statearr_18097_18137 = state_18089__$1;
(statearr_18097_18137[(2)] = inst_18053);

(statearr_18097_18137[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (13))){
var inst_18002 = (state_18089[(8)]);
var state_18089__$1 = state_18089;
if(cljs.core.truth_(inst_18002)){
var statearr_18098_18138 = state_18089__$1;
(statearr_18098_18138[(1)] = (18));

} else {
var statearr_18099_18139 = state_18089__$1;
(statearr_18099_18139[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (22))){
var inst_18053 = (state_18089[(9)]);
var inst_18057 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_18053);
var state_18089__$1 = state_18089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18089__$1,(24),inst_18057);
} else {
if((state_val_18090 === (6))){
var inst_18002 = (state_18089[(8)]);
var state_18089__$1 = state_18089;
var statearr_18100_18140 = state_18089__$1;
(statearr_18100_18140[(2)] = inst_18002);

(statearr_18100_18140[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (17))){
var inst_18050 = (state_18089[(2)]);
var state_18089__$1 = state_18089;
var statearr_18101_18141 = state_18089__$1;
(statearr_18101_18141[(2)] = inst_18050);

(statearr_18101_18141[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (3))){
var inst_18087 = (state_18089[(2)]);
var state_18089__$1 = state_18089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18089__$1,inst_18087);
} else {
if((state_val_18090 === (12))){
var inst_18015 = ["_tx",null,"_block",null];
var inst_18016 = (new cljs.core.PersistentArrayMap(null,2,inst_18015,null));
var inst_18017 = (new cljs.core.PersistentHashSet(null,inst_18016,null));
var inst_18018 = cljs.core.last(clause);
var inst_18019 = (inst_18017.cljs$core$IFn$_invoke$arity$1 ? inst_18017.cljs$core$IFn$_invoke$arity$1(inst_18018) : inst_18017.call(null,inst_18018));
var state_18089__$1 = state_18089;
if(cljs.core.truth_(inst_18019)){
var statearr_18102_18142 = state_18089__$1;
(statearr_18102_18142[(1)] = (15));

} else {
var statearr_18103_18143 = state_18089__$1;
(statearr_18103_18143[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (2))){
var inst_18000 = (state_18089[(7)]);
var _ = (function (){var statearr_18104 = state_18089;
(statearr_18104[(4)] = cljs.core.cons((5),(state_18089[(4)])));

return statearr_18104;
})();
var inst_17999 = cljs.core.first(clause);
var inst_18000__$1 = fluree.db.query.analytical.variable_QMARK_(inst_17999);
var inst_18001 = cljs.core.last(clause);
var inst_18002 = fluree.db.query.analytical.variable_QMARK_(inst_18001);
var state_18089__$1 = (function (){var statearr_18105 = state_18089;
(statearr_18105[(7)] = inst_18000__$1);

(statearr_18105[(8)] = inst_18002);

return statearr_18105;
})();
if(cljs.core.truth_(inst_18000__$1)){
var statearr_18106_18144 = state_18089__$1;
(statearr_18106_18144[(1)] = (6));

} else {
var statearr_18107_18145 = state_18089__$1;
(statearr_18107_18145[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (23))){
var inst_18002 = (state_18089[(8)]);
var inst_18062 = (state_18089[(2)]);
var inst_18063 = fluree.db.flake.sid__GT_cid(inst_18062);
var inst_18064 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18063);
var inst_18065 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18067 = [inst_18002];
var inst_18068 = (new cljs.core.PersistentVector(null,1,(5),inst_18066,inst_18067,null));
var inst_18069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18071 = [inst_18064];
var inst_18072 = (new cljs.core.PersistentVector(null,1,(5),inst_18070,inst_18071,null));
var inst_18073 = [inst_18072];
var inst_18074 = (new cljs.core.PersistentVector(null,1,(5),inst_18069,inst_18073,null));
var inst_18075 = cljs.core.PersistentHashMap.EMPTY;
var inst_18076 = [inst_18068,inst_18074,inst_18075];
var inst_18077 = cljs.core.PersistentHashMap.fromArrays(inst_18065,inst_18076);
var state_18089__$1 = state_18089;
var statearr_18108_18146 = state_18089__$1;
(statearr_18108_18146[(2)] = inst_18077);

(statearr_18108_18146[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (19))){
var state_18089__$1 = state_18089;
var statearr_18109_18147 = state_18089__$1;
(statearr_18109_18147[(2)] = null);

(statearr_18109_18147[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (11))){
var inst_18084 = (state_18089[(2)]);
var _ = (function (){var statearr_18111 = state_18089;
(statearr_18111[(4)] = cljs.core.rest((state_18089[(4)])));

return statearr_18111;
})();
var state_18089__$1 = state_18089;
var statearr_18112_18148 = state_18089__$1;
(statearr_18112_18148[(2)] = inst_18084);

(statearr_18112_18148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (9))){
var inst_18008 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18009 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_18010 = cljs.core.PersistentHashMap.fromArrays(inst_18008,inst_18009);
var inst_18011 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_18010);
var inst_18012 = (function(){throw inst_18011})();
var state_18089__$1 = state_18089;
var statearr_18113_18149 = state_18089__$1;
(statearr_18113_18149[(2)] = inst_18012);

(statearr_18113_18149[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (5))){
var _ = (function (){var statearr_18114 = state_18089;
(statearr_18114[(4)] = cljs.core.rest((state_18089[(4)])));

return statearr_18114;
})();
var state_18089__$1 = state_18089;
var ex18110 = (state_18089__$1[(2)]);
var statearr_18115_18150 = state_18089__$1;
(statearr_18115_18150[(5)] = ex18110);


if((ex18110 instanceof Error)){
var statearr_18116_18151 = state_18089__$1;
(statearr_18116_18151[(1)] = (4));

(statearr_18116_18151[(5)] = null);

} else {
throw ex18110;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (14))){
var inst_18082 = (state_18089[(2)]);
var state_18089__$1 = state_18089;
var statearr_18117_18152 = state_18089__$1;
(statearr_18117_18152[(2)] = inst_18082);

(statearr_18117_18152[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (16))){
var inst_18000 = (state_18089[(7)]);
var inst_18002 = (state_18089[(8)]);
var inst_18033 = cljs.core.last(clause);
var inst_18034 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_18033);
var inst_18035 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_18036 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18035,inst_18034);
var inst_18037 = fluree.db.flake.min_subject_id(inst_18034);
var inst_18038 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18040 = [inst_18000];
var inst_18041 = (new cljs.core.PersistentVector(null,1,(5),inst_18039,inst_18040,null));
var inst_18042 = (function (){var subject_var = inst_18000;
var object_var = inst_18002;
var partition = inst_18034;
var max_sid = inst_18036;
var min_sid = inst_18037;
return (function (p1__17992_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__17992_SHARP_);
});
})();
var inst_18043 = (inst_18036 + (1));
var inst_18044 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_18037,inst_18043);
var inst_18045 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18042,inst_18044);
var inst_18046 = cljs.core.PersistentHashMap.EMPTY;
var inst_18047 = [inst_18041,inst_18045,inst_18046];
var inst_18048 = cljs.core.PersistentHashMap.fromArrays(inst_18038,inst_18047);
var state_18089__$1 = state_18089;
var statearr_18118_18153 = state_18089__$1;
(statearr_18118_18153[(2)] = inst_18048);

(statearr_18118_18153[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (10))){
var inst_18000 = (state_18089[(7)]);
var state_18089__$1 = state_18089;
if(cljs.core.truth_(inst_18000)){
var statearr_18119_18154 = state_18089__$1;
(statearr_18119_18154[(1)] = (12));

} else {
var statearr_18120_18155 = state_18089__$1;
(statearr_18120_18155[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (18))){
var inst_18053 = (state_18089[(9)]);
var inst_18053__$1 = cljs.core.first(clause);
var inst_18054 = typeof inst_18053__$1 === 'number';
var state_18089__$1 = (function (){var statearr_18121 = state_18089;
(statearr_18121[(9)] = inst_18053__$1);

return statearr_18121;
})();
if(cljs.core.truth_(inst_18054)){
var statearr_18122_18156 = state_18089__$1;
(statearr_18122_18156[(1)] = (21));

} else {
var statearr_18123_18157 = state_18089__$1;
(statearr_18123_18157[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18090 === (8))){
var inst_18006 = (state_18089[(2)]);
var state_18089__$1 = state_18089;
if(cljs.core.truth_(inst_18006)){
var statearr_18124_18158 = state_18089__$1;
(statearr_18124_18158[(1)] = (9));

} else {
var statearr_18125_18159 = state_18089__$1;
(statearr_18125_18159[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_18126 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18126[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__);

(statearr_18126[(1)] = (1));

return statearr_18126;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____1 = (function (state_18089){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18089);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18127){var ex__2736__auto__ = e18127;
var statearr_18128_18160 = state_18089;
(statearr_18128_18160[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18089[(4)]))){
var statearr_18129_18161 = state_18089;
(statearr_18129_18161[(1)] = cljs.core.first((state_18089[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18162 = state_18089;
state_18089 = G__18162;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__ = function(state_18089){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____1.call(this,state_18089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18130 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18130[(6)] = c__2755__auto__);

return statearr_18130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__18169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__18169 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__18169;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4622__auto__ = (function fluree$db$query$analytical$variance_$_iter__18170(s__18171){
return (new cljs.core.LazySeq(null,(function (){
var s__18171__$1 = s__18171;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__18171__$1);
if(temp__5753__auto__){
var s__18171__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__18171__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__18171__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__18173 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__18172 = (0);
while(true){
if((i__18172 < size__4621__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__18172);
var delta = (x - mean);
cljs.core.chunk_append(b__18173,(delta * delta));

var G__18175 = (i__18172 + (1));
i__18172 = G__18175;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__18173),fluree$db$query$analytical$variance_$_iter__18170(cljs.core.chunk_rest(s__18171__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__18173),null);
}
} else {
var x = cljs.core.first(s__18171__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__18170(cljs.core.rest(s__18171__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__18174 = variance(coll);
return Math.sqrt(G__18174);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4306__auto__ = n;
var y__4307__auto__ = (- n);
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
}),(function() {
var G__18176 = null;
var G__18176__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__18176__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18176 = function(n,coll){
switch(arguments.length){
case 1:
return G__18176__1.call(this,n);
case 2:
return G__18176__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18176.cljs$core$IFn$_invoke$arity$1 = G__18176__1;
G__18176.cljs$core$IFn$_invoke$arity$2 = G__18176__2;
return G__18176;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__18177 = null;
var G__18177__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__18177__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18177 = function(n,coll){
switch(arguments.length){
case 1:
return G__18177__1.call(this,n);
case 2:
return G__18177__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18177.cljs$core$IFn$_invoke$arity$1 = G__18177__1;
G__18177.cljs$core$IFn$_invoke$arity$2 = G__18177__2;
return G__18177;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__18178 = null;
var G__18178__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__18178__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__18178 = function(n,coll){
switch(arguments.length){
case 1:
return G__18178__1.call(this,n);
case 2:
return G__18178__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18178.cljs$core$IFn$_invoke$arity$1 = G__18178__1;
G__18178.cljs$core$IFn$_invoke$arity$2 = G__18178__2;
return G__18178;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__18179 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18179,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18179,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18179,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__18182 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__18185 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__18185) : agg_fn.call(null,G__18185));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18182,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18182,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__18186 = agg;
var map__18186__$1 = cljs.core.__destructure_map(map__18186);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18186__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18186__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18186__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__18188 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18188,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18188,(1),null);
var map__18191 = res__$1;
var map__18191__$1 = cljs.core.__destructure_map(map__18191);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18191__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18191__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18187_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__18187_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18192_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__18192_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18193_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__18193_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__18194_SHARP_,p2__18195_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18194_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__18195_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18196_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__18196_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__18199,row,b_tuple){
var vec__18200 = p__18199;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18200,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18200,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18197_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__18197_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = acc;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18198_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__18198_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18203_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__18203_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18204_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__18204_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__18209 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__18211 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__18210 = (function (p1__18205_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__18205_SHARP_);
});
return fexpr__18210(G__18211);
})()),cljs.core.set(b_idxs));
var fexpr__18208 = (function (p1__18206_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__18206_SHARP_);
});
return fexpr__18208(G__18209);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18207_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__18207_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18212_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__18212_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18213_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18213_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__18218 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__18220 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__18219 = (function (p1__18214_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__18214_SHARP_);
});
return fexpr__18219(G__18220);
})()),cljs.core.set(b_idxs));
var fexpr__18217 = (function (p1__18215_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__18215_SHARP_);
});
return fexpr__18217(G__18218);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18216_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18216_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18221_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__18221_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18222_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18222_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__18231 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__18233 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__18232 = (function (p1__18223_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__18223_SHARP_);
});
return fexpr__18232(G__18233);
})()),cljs.core.set(b_idxs));
var fexpr__18230 = (function (p1__18224_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__18224_SHARP_);
});
return fexpr__18230(G__18231);
})();
var vec__18227 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__18234,a_tuple){
var vec__18235 = p__18234;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18235,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18235,(1),null);
var vec__18238 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18238,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18238,(1),null);
var matches__$1 = (function (){var or__4223__auto__ = matches;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18227,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18227,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18225_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18225_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18226_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18226_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__18242 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18242,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18242,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18241_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__18241_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__18247 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18247,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18247,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18245_SHARP_){
return fluree.db.util.core.index_of(headers,p1__18245_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__18246_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__18246_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__18250,filters,optional_QMARK_){
var map__18251 = p__18250;
var map__18251__$1 = cljs.core.__destructure_map(map__18251);
var tuple_map = map__18251__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18251__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__18252 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18252,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18252,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__18255 = res;
var map__18255__$1 = cljs.core.__destructure_map(map__18255);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18255__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18255__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18311){
var state_val_18312 = (state_18311[(1)]);
if((state_val_18312 === (7))){
var inst_18285 = (state_18311[(7)]);
var inst_18283 = (state_18311[(2)]);
var inst_18284 = fluree.db.util.async.throw_err(inst_18283);
var inst_18285__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18284,(0),null);
var inst_18286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18284,(1),null);
var inst_18287 = (inst_18285__$1 == null);
var state_18311__$1 = (function (){var statearr_18313 = state_18311;
(statearr_18313[(8)] = inst_18286);

(statearr_18313[(7)] = inst_18285__$1);

return statearr_18313;
})();
if(cljs.core.truth_(inst_18287)){
var statearr_18314_18343 = state_18311__$1;
(statearr_18314_18343[(1)] = (8));

} else {
var statearr_18315_18344 = state_18311__$1;
(statearr_18315_18344[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (1))){
var inst_18263 = optional_clauses;
var inst_18264 = cljs.core.seq(inst_18263);
var inst_18265 = cljs.core.first(inst_18264);
var inst_18266 = cljs.core.next(inst_18264);
var inst_18267 = where_tuples;
var inst_18268 = inst_18263;
var inst_18269 = inst_18267;
var state_18311__$1 = (function (){var statearr_18316 = state_18311;
(statearr_18316[(9)] = inst_18269);

(statearr_18316[(10)] = inst_18268);

(statearr_18316[(11)] = inst_18266);

(statearr_18316[(12)] = inst_18265);

return statearr_18316;
})();
var statearr_18317_18345 = state_18311__$1;
(statearr_18317_18345[(2)] = null);

(statearr_18317_18345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (4))){
var inst_18276 = (state_18311[(13)]);
var inst_18269 = (state_18311[(9)]);
var inst_18275 = (state_18311[(14)]);
var inst_18281 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_18269,inst_18275,inst_18276,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_18269,inst_18275,inst_18276,true,fuel,max_fuel,opts));
var state_18311__$1 = state_18311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18311__$1,(7),inst_18281);
} else {
if((state_val_18312 === (15))){
var state_18311__$1 = state_18311;
var statearr_18318_18346 = state_18311__$1;
(statearr_18318_18346[(2)] = null);

(statearr_18318_18346[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (13))){
var inst_18302 = (state_18311[(2)]);
var state_18311__$1 = state_18311;
var statearr_18319_18347 = state_18311__$1;
(statearr_18319_18347[(2)] = inst_18302);

(statearr_18319_18347[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (6))){
var inst_18307 = (state_18311[(2)]);
var state_18311__$1 = state_18311;
var statearr_18320_18348 = state_18311__$1;
(statearr_18320_18348[(2)] = inst_18307);

(statearr_18320_18348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (3))){
var inst_18309 = (state_18311[(2)]);
var state_18311__$1 = state_18311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18311__$1,inst_18309);
} else {
if((state_val_18312 === (12))){
var state_18311__$1 = state_18311;
var statearr_18321_18349 = state_18311__$1;
(statearr_18321_18349[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (2))){
var inst_18268 = (state_18311[(10)]);
var inst_18275 = (state_18311[(14)]);
var inst_18274 = cljs.core.seq(inst_18268);
var inst_18275__$1 = cljs.core.first(inst_18274);
var inst_18276 = cljs.core.next(inst_18274);
var state_18311__$1 = (function (){var statearr_18323 = state_18311;
(statearr_18323[(13)] = inst_18276);

(statearr_18323[(14)] = inst_18275__$1);

return statearr_18323;
})();
if(cljs.core.truth_(inst_18275__$1)){
var statearr_18324_18350 = state_18311__$1;
(statearr_18324_18350[(1)] = (4));

} else {
var statearr_18325_18351 = state_18311__$1;
(statearr_18325_18351[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (11))){
var inst_18286 = (state_18311[(8)]);
var inst_18285 = (state_18311[(7)]);
var inst_18268 = inst_18286;
var inst_18269 = inst_18285;
var state_18311__$1 = (function (){var statearr_18326 = state_18311;
(statearr_18326[(9)] = inst_18269);

(statearr_18326[(10)] = inst_18268);

return statearr_18326;
})();
var statearr_18327_18352 = state_18311__$1;
(statearr_18327_18352[(2)] = null);

(statearr_18327_18352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (9))){
var inst_18275 = (state_18311[(14)]);
var inst_18291 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_18275);
var state_18311__$1 = state_18311;
if(cljs.core.truth_(inst_18291)){
var statearr_18328_18353 = state_18311__$1;
(statearr_18328_18353[(1)] = (11));

} else {
var statearr_18329_18354 = state_18311__$1;
(statearr_18329_18354[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (5))){
var inst_18269 = (state_18311[(9)]);
var state_18311__$1 = state_18311;
var statearr_18330_18355 = state_18311__$1;
(statearr_18330_18355[(2)] = inst_18269);

(statearr_18330_18355[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (14))){
var inst_18286 = (state_18311[(8)]);
var inst_18285 = (state_18311[(7)]);
var inst_18269 = (state_18311[(9)]);
var inst_18296 = fluree.db.query.analytical.left_outer_join(inst_18269,inst_18285);
var inst_18268 = inst_18286;
var inst_18269__$1 = inst_18296;
var state_18311__$1 = (function (){var statearr_18331 = state_18311;
(statearr_18331[(9)] = inst_18269__$1);

(statearr_18331[(10)] = inst_18268);

return statearr_18331;
})();
var statearr_18332_18356 = state_18311__$1;
(statearr_18332_18356[(2)] = null);

(statearr_18332_18356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (16))){
var inst_18300 = (state_18311[(2)]);
var state_18311__$1 = state_18311;
var statearr_18334_18357 = state_18311__$1;
(statearr_18334_18357[(2)] = inst_18300);

(statearr_18334_18357[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (10))){
var inst_18304 = (state_18311[(2)]);
var state_18311__$1 = state_18311;
var statearr_18335_18358 = state_18311__$1;
(statearr_18335_18358[(2)] = inst_18304);

(statearr_18335_18358[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18312 === (8))){
var inst_18286 = (state_18311[(8)]);
var inst_18269 = (state_18311[(9)]);
var tmp18333 = inst_18269;
var inst_18268 = inst_18286;
var inst_18269__$1 = tmp18333;
var state_18311__$1 = (function (){var statearr_18336 = state_18311;
(statearr_18336[(9)] = inst_18269__$1);

(statearr_18336[(10)] = inst_18268);

return statearr_18336;
})();
var statearr_18337_18359 = state_18311__$1;
(statearr_18337_18359[(2)] = null);

(statearr_18337_18359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____0 = (function (){
var statearr_18338 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18338[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__);

(statearr_18338[(1)] = (1));

return statearr_18338;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____1 = (function (state_18311){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18311);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18339){var ex__2736__auto__ = e18339;
var statearr_18340_18360 = state_18311;
(statearr_18340_18360[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18311[(4)]))){
var statearr_18341_18361 = state_18311;
(statearr_18341_18361[(1)] = cljs.core.first((state_18311[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18362 = state_18311;
state_18311 = G__18362;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__ = function(state_18311){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____1.call(this,state_18311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18342 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18342[(6)] = c__2755__auto__);

return statearr_18342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__18364){
var vec__18365 = p__18364;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18365,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18365,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18363_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__18363_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__18369,p__18370,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__18371 = p__18369;
var map__18371__$1 = cljs.core.__destructure_map(map__18371);
var q_map = map__18371__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18371__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__18372 = p__18370;
var map__18372__$1 = cljs.core.__destructure_map(map__18372);
var res = map__18372__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18372__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18585){
var state_val_18586 = (state_18585[(1)]);
if((state_val_18586 === (65))){
var inst_18554 = (state_18585[(7)]);
var inst_18557 = (state_18585[(2)]);
var inst_18558 = fluree.db.util.async.throw_err(inst_18557);
var inst_18559 = [inst_18558,r];
var inst_18560 = (new cljs.core.PersistentVector(null,2,(5),inst_18554,inst_18559,null));
var state_18585__$1 = state_18585;
var statearr_18587_18692 = state_18585__$1;
(statearr_18587_18692[(2)] = inst_18560);

(statearr_18587_18692[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (62))){
var inst_18537 = (state_18585[(8)]);
var inst_18536 = (state_18585[(9)]);
var inst_18554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18555 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_18536,res,inst_18537,fuel,max_fuel);
var state_18585__$1 = (function (){var statearr_18588 = state_18585;
(statearr_18588[(7)] = inst_18554);

return statearr_18588;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(65),inst_18555);
} else {
if((state_val_18586 === (7))){
var inst_18478 = (state_18585[(10)]);
var inst_18477 = cljs.core.count(clause);
var inst_18478__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_18477);
var state_18585__$1 = (function (){var statearr_18589 = state_18585;
(statearr_18589[(10)] = inst_18478__$1);

return statearr_18589;
})();
if(inst_18478__$1){
var statearr_18590_18693 = state_18585__$1;
(statearr_18590_18693[(1)] = (31));

} else {
var statearr_18591_18694 = state_18585__$1;
(statearr_18591_18694[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (59))){
var inst_18537 = (state_18585[(8)]);
var inst_18536 = (state_18585[(9)]);
var inst_18548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18549 = fluree.db.query.analytical.full_text__GT_tuples(inst_18536,res,inst_18537);
var inst_18550 = [inst_18549,r];
var inst_18551 = (new cljs.core.PersistentVector(null,2,(5),inst_18548,inst_18550,null));
var state_18585__$1 = state_18585;
var statearr_18592_18695 = state_18585__$1;
(statearr_18592_18695[(2)] = inst_18551);

(statearr_18592_18695[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (20))){
var inst_18441 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18593_18696 = state_18585__$1;
(statearr_18593_18696[(2)] = inst_18441);

(statearr_18593_18696[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (58))){
var inst_18542 = (state_18585[(2)]);
var inst_18543 = fluree.db.util.async.throw_err(inst_18542);
var state_18585__$1 = state_18585;
var statearr_18594_18697 = state_18585__$1;
(statearr_18594_18697[(2)] = inst_18543);

(statearr_18594_18697[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (60))){
var state_18585__$1 = state_18585;
var statearr_18595_18698 = state_18585__$1;
(statearr_18595_18698[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (27))){
var inst_18471 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18597_18699 = state_18585__$1;
(statearr_18597_18699[(2)] = inst_18471);

(statearr_18597_18699[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (1))){
var state_18585__$1 = state_18585;
var statearr_18598_18700 = state_18585__$1;
(statearr_18598_18700[(2)] = null);

(statearr_18598_18700[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (24))){
var inst_18435 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18599_18701 = state_18585__$1;
(statearr_18599_18701[(2)] = inst_18435);

(statearr_18599_18701[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (55))){
var inst_18537 = (state_18585[(8)]);
var inst_18540 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_18537,r,res,optional_QMARK_,fuel,max_fuel);
var state_18585__$1 = state_18585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(58),inst_18540);
} else {
if((state_val_18586 === (39))){
var inst_18498 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
if(cljs.core.truth_(inst_18498)){
var statearr_18600_18702 = state_18585__$1;
(statearr_18600_18702[(1)] = (40));

} else {
var statearr_18601_18703 = state_18585__$1;
(statearr_18601_18703[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (46))){
var inst_18574 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18602_18704 = state_18585__$1;
(statearr_18602_18704[(2)] = inst_18574);

(statearr_18602_18704[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (4))){
var inst_18373 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18603_18705 = state_18585__$1;
(statearr_18603_18705[(2)] = inst_18373);

(statearr_18603_18705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (54))){
var inst_18536 = (state_18585[(9)]);
var inst_18534 = (state_18585[(2)]);
var inst_18535 = fluree.db.util.async.throw_err(inst_18534);
var inst_18536__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18535,(0),null);
var inst_18537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18535,(1),null);
var inst_18538 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_18536__$1);
var state_18585__$1 = (function (){var statearr_18604 = state_18585;
(statearr_18604[(8)] = inst_18537);

(statearr_18604[(9)] = inst_18536__$1);

return statearr_18604;
})();
if(inst_18538){
var statearr_18605_18706 = state_18585__$1;
(statearr_18605_18706[(1)] = (55));

} else {
var statearr_18606_18707 = state_18585__$1;
(statearr_18606_18707[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (15))){
var inst_18473 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18607_18708 = state_18585__$1;
(statearr_18607_18708[(2)] = inst_18473);

(statearr_18607_18708[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (48))){
var inst_18522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18523 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_18524 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_18523);
var inst_18525 = [inst_18524,r];
var inst_18526 = (new cljs.core.PersistentVector(null,2,(5),inst_18522,inst_18525,null));
var state_18585__$1 = state_18585;
var statearr_18608_18709 = state_18585__$1;
(statearr_18608_18709[(2)] = inst_18526);

(statearr_18608_18709[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (50))){
var inst_18572 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18609_18710 = state_18585__$1;
(statearr_18609_18710[(2)] = inst_18572);

(statearr_18609_18710[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (21))){
var inst_18411 = (state_18585[(11)]);
var inst_18382 = (state_18585[(12)]);
var inst_18386 = (state_18585[(13)]);
var inst_18410 = (state_18585[(14)]);
var inst_18412 = (state_18585[(15)]);
var inst_18419 = (state_18585[(16)]);
var inst_18418 = (state_18585[(17)]);
var inst_18409 = (state_18585[(18)]);
var inst_18407 = (state_18585[(19)]);
var inst_18423 = (state_18585[(2)]);
var inst_18424 = fluree.db.util.async.throw_err(inst_18423);
var inst_18425 = (function (){var new_res = inst_18424;
var rest = inst_18419;
var vec__18404 = inst_18407;
var first__18416 = inst_18418;
var tuples = inst_18412;
var G__18403 = inst_18411;
var seq__18405 = inst_18410;
var seq__18415 = inst_18419;
var expr__18384 = inst_18382;
var segment_type = inst_18382;
var vec__18414 = inst_18411;
var pred__18383 = inst_18386;
var clause_group = inst_18418;
var first__18406 = inst_18409;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_18426 = cljs.core.keys(vars);
var inst_18427 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_18425,inst_18424,inst_18426);
var inst_18428 = fluree.db.query.analytical.res_absorb_vars(inst_18427);
var state_18585__$1 = (function (){var statearr_18610 = state_18585;
(statearr_18610[(20)] = inst_18428);

return statearr_18610;
})();
if(cljs.core.truth_(inst_18412)){
var statearr_18611_18711 = state_18585__$1;
(statearr_18611_18711[(1)] = (22));

} else {
var statearr_18612_18712 = state_18585__$1;
(statearr_18612_18712[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (31))){
var inst_18480 = cljs.core.second(clause);
var inst_18481 = clojure.string.starts_with_QMARK_(inst_18480,"fullText:");
var state_18585__$1 = state_18585;
var statearr_18613_18713 = state_18585__$1;
(statearr_18613_18713[(2)] = inst_18481);

(statearr_18613_18713[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (32))){
var inst_18478 = (state_18585[(10)]);
var state_18585__$1 = state_18585;
var statearr_18614_18714 = state_18585__$1;
(statearr_18614_18714[(2)] = inst_18478);

(statearr_18614_18714[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (40))){
var inst_18500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18501 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_18585__$1 = (function (){var statearr_18615 = state_18585;
(statearr_18615[(21)] = inst_18500);

return statearr_18615;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(43),inst_18501);
} else {
if((state_val_18586 === (56))){
var inst_18537 = (state_18585[(8)]);
var inst_18545 = cljs.core.second(inst_18537);
var inst_18546 = clojure.string.starts_with_QMARK_(inst_18545,"fullText:");
var state_18585__$1 = state_18585;
if(inst_18546){
var statearr_18616_18715 = state_18585__$1;
(statearr_18616_18715[(1)] = (59));

} else {
var statearr_18617_18716 = state_18585__$1;
(statearr_18617_18716[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (33))){
var inst_18484 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
if(cljs.core.truth_(inst_18484)){
var statearr_18618_18717 = state_18585__$1;
(statearr_18618_18717[(1)] = (34));

} else {
var statearr_18619_18718 = state_18585__$1;
(statearr_18619_18718[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (13))){
var inst_18407 = (state_18585[(19)]);
var inst_18407__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18408 = cljs.core.seq(inst_18407__$1);
var inst_18409 = cljs.core.first(inst_18408);
var inst_18410 = cljs.core.next(inst_18408);
var inst_18411 = inst_18407__$1;
var inst_18412 = null;
var state_18585__$1 = (function (){var statearr_18620 = state_18585;
(statearr_18620[(11)] = inst_18411);

(statearr_18620[(14)] = inst_18410);

(statearr_18620[(15)] = inst_18412);

(statearr_18620[(18)] = inst_18409);

(statearr_18620[(19)] = inst_18407__$1);

return statearr_18620;
})();
var statearr_18621_18719 = state_18585__$1;
(statearr_18621_18719[(2)] = null);

(statearr_18621_18719[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (22))){
var inst_18412 = (state_18585[(15)]);
var inst_18419 = (state_18585[(16)]);
var inst_18428 = (state_18585[(20)]);
var inst_18430 = fluree.db.query.analytical.outer_union(inst_18412,inst_18428);
var inst_18411 = inst_18419;
var inst_18412__$1 = inst_18430;
var state_18585__$1 = (function (){var statearr_18622 = state_18585;
(statearr_18622[(11)] = inst_18411);

(statearr_18622[(15)] = inst_18412__$1);

return statearr_18622;
})();
var statearr_18623_18720 = state_18585__$1;
(statearr_18623_18720[(2)] = null);

(statearr_18623_18720[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (36))){
var inst_18578 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18624_18721 = state_18585__$1;
(statearr_18624_18721[(2)] = inst_18578);

(statearr_18624_18721[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (41))){
var inst_18508 = cljs.core.count(clause);
var inst_18509 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_18508);
var state_18585__$1 = state_18585;
if(inst_18509){
var statearr_18625_18722 = state_18585__$1;
(statearr_18625_18722[(1)] = (44));

} else {
var statearr_18626_18723 = state_18585__$1;
(statearr_18626_18723[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (43))){
var inst_18500 = (state_18585[(21)]);
var inst_18503 = (state_18585[(2)]);
var inst_18504 = fluree.db.util.async.throw_err(inst_18503);
var inst_18505 = [inst_18504,r];
var inst_18506 = (new cljs.core.PersistentVector(null,2,(5),inst_18500,inst_18505,null));
var state_18585__$1 = state_18585;
var statearr_18627_18724 = state_18585__$1;
(statearr_18627_18724[(2)] = inst_18506);

(statearr_18627_18724[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (61))){
var inst_18565 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18628_18725 = state_18585__$1;
(statearr_18628_18725[(2)] = inst_18565);

(statearr_18628_18725[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (29))){
var inst_18382 = (state_18585[(12)]);
var inst_18465 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18382)].join('');
var inst_18466 = (new Error(inst_18465));
var inst_18467 = (function(){throw inst_18466})();
var state_18585__$1 = state_18585;
var statearr_18629_18726 = state_18585__$1;
(statearr_18629_18726[(2)] = inst_18467);

(statearr_18629_18726[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (44))){
var inst_18511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18512 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_18585__$1 = (function (){var statearr_18630 = state_18585;
(statearr_18630[(22)] = inst_18511);

return statearr_18630;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(47),inst_18512);
} else {
if((state_val_18586 === (6))){
var inst_18382 = (state_18585[(12)]);
var inst_18386 = (state_18585[(13)]);
var inst_18381 = cljs.core.keys(clause);
var inst_18382__$1 = cljs.core.first(inst_18381);
var inst_18386__$1 = cljs.core._EQ_;
var inst_18387 = (function (){var G__18631 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__18632 = inst_18382__$1;
return (inst_18386__$1.cljs$core$IFn$_invoke$arity$2 ? inst_18386__$1.cljs$core$IFn$_invoke$arity$2(G__18631,G__18632) : inst_18386__$1.call(null,G__18631,G__18632));
})();
var state_18585__$1 = (function (){var statearr_18633 = state_18585;
(statearr_18633[(12)] = inst_18382__$1);

(statearr_18633[(13)] = inst_18386__$1);

return statearr_18633;
})();
if(cljs.core.truth_(inst_18387)){
var statearr_18634_18727 = state_18585__$1;
(statearr_18634_18727[(1)] = (9));

} else {
var statearr_18635_18728 = state_18585__$1;
(statearr_18635_18728[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (28))){
var inst_18459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18460 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18461 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_18460,optional_QMARK_);
var inst_18462 = [inst_18461,r];
var inst_18463 = (new cljs.core.PersistentVector(null,2,(5),inst_18459,inst_18462,null));
var state_18585__$1 = state_18585;
var statearr_18636_18729 = state_18585__$1;
(statearr_18636_18729[(2)] = inst_18463);

(statearr_18636_18729[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (64))){
var inst_18563 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18637_18730 = state_18585__$1;
(statearr_18637_18730[(2)] = inst_18563);

(statearr_18637_18730[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (51))){
var inst_18532 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_18585__$1 = state_18585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(54),inst_18532);
} else {
if((state_val_18586 === (25))){
var inst_18382 = (state_18585[(12)]);
var inst_18386 = (state_18585[(13)]);
var inst_18447 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18448 = (function (){var segment_type = inst_18382;
var pred__18383 = inst_18386;
var expr__18384 = inst_18382;
var bindings = inst_18447;
return (function (p1__18368_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__18368_SHARP_);
});
})();
var inst_18449 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_18448,inst_18447);
var inst_18450 = cljs.core.PersistentHashMap.EMPTY;
var inst_18451 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_18450,inst_18449);
var inst_18452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18453 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_18451);
var inst_18454 = [inst_18453,r];
var inst_18455 = (new cljs.core.PersistentVector(null,2,(5),inst_18452,inst_18454,null));
var state_18585__$1 = state_18585;
var statearr_18638_18731 = state_18585__$1;
(statearr_18638_18731[(2)] = inst_18455);

(statearr_18638_18731[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (34))){
var inst_18486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18487 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_18488 = [inst_18487,r];
var inst_18489 = (new cljs.core.PersistentVector(null,2,(5),inst_18486,inst_18488,null));
var state_18585__$1 = state_18585;
var statearr_18639_18732 = state_18585__$1;
(statearr_18639_18732[(2)] = inst_18489);

(statearr_18639_18732[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (17))){
var inst_18443 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18640_18733 = state_18585__$1;
(statearr_18640_18733[(2)] = inst_18443);

(statearr_18640_18733[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (3))){
var inst_18583 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18585__$1,inst_18583);
} else {
if((state_val_18586 === (12))){
var inst_18389 = (state_18585[(23)]);
var inst_18393 = (state_18585[(2)]);
var inst_18394 = fluree.db.util.async.throw_err(inst_18393);
var inst_18395 = [inst_18394,r];
var inst_18396 = (new cljs.core.PersistentVector(null,2,(5),inst_18389,inst_18395,null));
var state_18585__$1 = state_18585;
var statearr_18641_18734 = state_18585__$1;
(statearr_18641_18734[(2)] = inst_18396);

(statearr_18641_18734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (2))){
var _ = (function (){var statearr_18642 = state_18585;
(statearr_18642[(4)] = cljs.core.cons((5),(state_18585[(4)])));

return statearr_18642;
})();
var inst_18379 = cljs.core.map_QMARK_(clause);
var state_18585__$1 = state_18585;
if(inst_18379){
var statearr_18643_18735 = state_18585__$1;
(statearr_18643_18735[(1)] = (6));

} else {
var statearr_18644_18736 = state_18585__$1;
(statearr_18644_18736[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (23))){
var inst_18419 = (state_18585[(16)]);
var inst_18428 = (state_18585[(20)]);
var inst_18411 = inst_18419;
var inst_18412 = inst_18428;
var state_18585__$1 = (function (){var statearr_18645 = state_18585;
(statearr_18645[(11)] = inst_18411);

(statearr_18645[(15)] = inst_18412);

return statearr_18645;
})();
var statearr_18646_18737 = state_18585__$1;
(statearr_18646_18737[(2)] = null);

(statearr_18646_18737[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (47))){
var inst_18511 = (state_18585[(22)]);
var inst_18514 = (state_18585[(2)]);
var inst_18515 = fluree.db.util.async.throw_err(inst_18514);
var inst_18516 = [inst_18515,r];
var inst_18517 = (new cljs.core.PersistentVector(null,2,(5),inst_18511,inst_18516,null));
var state_18585__$1 = state_18585;
var statearr_18647_18738 = state_18585__$1;
(statearr_18647_18738[(2)] = inst_18517);

(statearr_18647_18738[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (35))){
var inst_18492 = (state_18585[(24)]);
var inst_18491 = cljs.core.count(clause);
var inst_18492__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_18491);
var state_18585__$1 = (function (){var statearr_18648 = state_18585;
(statearr_18648[(24)] = inst_18492__$1);

return statearr_18648;
})();
if(inst_18492__$1){
var statearr_18649_18739 = state_18585__$1;
(statearr_18649_18739[(1)] = (37));

} else {
var statearr_18650_18740 = state_18585__$1;
(statearr_18650_18740[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (19))){
var inst_18412 = (state_18585[(15)]);
var inst_18437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18438 = [inst_18412,r];
var inst_18439 = (new cljs.core.PersistentVector(null,2,(5),inst_18437,inst_18438,null));
var state_18585__$1 = state_18585;
var statearr_18651_18741 = state_18585__$1;
(statearr_18651_18741[(2)] = inst_18439);

(statearr_18651_18741[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (57))){
var inst_18567 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18652_18742 = state_18585__$1;
(statearr_18652_18742[(2)] = inst_18567);

(statearr_18652_18742[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (11))){
var inst_18475 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18654_18743 = state_18585__$1;
(statearr_18654_18743[(2)] = inst_18475);

(statearr_18654_18743[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (9))){
var inst_18389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18390 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18391 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_18390,res,fuel,max_fuel,opts);
var state_18585__$1 = (function (){var statearr_18655 = state_18585;
(statearr_18655[(23)] = inst_18389);

return statearr_18655;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(12),inst_18391);
} else {
if((state_val_18586 === (5))){
var _ = (function (){var statearr_18656 = state_18585;
(statearr_18656[(4)] = cljs.core.rest((state_18585[(4)])));

return statearr_18656;
})();
var state_18585__$1 = state_18585;
var ex18653 = (state_18585__$1[(2)]);
var statearr_18657_18744 = state_18585__$1;
(statearr_18657_18744[(5)] = ex18653);


if((ex18653 instanceof Error)){
var statearr_18658_18745 = state_18585__$1;
(statearr_18658_18745[(1)] = (4));

(statearr_18658_18745[(5)] = null);

} else {
throw ex18653;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (14))){
var inst_18382 = (state_18585[(12)]);
var inst_18386 = (state_18585[(13)]);
var inst_18445 = (function (){var G__18659 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__18660 = inst_18382;
return (inst_18386.cljs$core$IFn$_invoke$arity$2 ? inst_18386.cljs$core$IFn$_invoke$arity$2(G__18659,G__18660) : inst_18386.call(null,G__18659,G__18660));
})();
var state_18585__$1 = state_18585;
if(cljs.core.truth_(inst_18445)){
var statearr_18661_18746 = state_18585__$1;
(statearr_18661_18746[(1)] = (25));

} else {
var statearr_18662_18747 = state_18585__$1;
(statearr_18662_18747[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (45))){
var inst_18519 = cljs.core.count(clause);
var inst_18520 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_18519);
var state_18585__$1 = state_18585;
if(inst_18520){
var statearr_18663_18748 = state_18585__$1;
(statearr_18663_18748[(1)] = (48));

} else {
var statearr_18664_18749 = state_18585__$1;
(statearr_18664_18749[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (53))){
var inst_18570 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18665_18750 = state_18585__$1;
(statearr_18665_18750[(2)] = inst_18570);

(statearr_18665_18750[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (26))){
var inst_18382 = (state_18585[(12)]);
var inst_18386 = (state_18585[(13)]);
var inst_18457 = (function (){var G__18666 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__18667 = inst_18382;
return (inst_18386.cljs$core$IFn$_invoke$arity$2 ? inst_18386.cljs$core$IFn$_invoke$arity$2(G__18666,G__18667) : inst_18386.call(null,G__18666,G__18667));
})();
var state_18585__$1 = state_18585;
if(cljs.core.truth_(inst_18457)){
var statearr_18668_18751 = state_18585__$1;
(statearr_18668_18751[(1)] = (28));

} else {
var statearr_18669_18752 = state_18585__$1;
(statearr_18669_18752[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (16))){
var inst_18411 = (state_18585[(11)]);
var inst_18418 = (state_18585[(17)]);
var inst_18417 = cljs.core.seq(inst_18411);
var inst_18418__$1 = cljs.core.first(inst_18417);
var inst_18419 = cljs.core.next(inst_18417);
var state_18585__$1 = (function (){var statearr_18670 = state_18585;
(statearr_18670[(16)] = inst_18419);

(statearr_18670[(17)] = inst_18418__$1);

return statearr_18670;
})();
if(cljs.core.truth_(inst_18418__$1)){
var statearr_18671_18753 = state_18585__$1;
(statearr_18671_18753[(1)] = (18));

} else {
var statearr_18672_18754 = state_18585__$1;
(statearr_18672_18754[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (38))){
var inst_18492 = (state_18585[(24)]);
var state_18585__$1 = state_18585;
var statearr_18673_18755 = state_18585__$1;
(statearr_18673_18755[(2)] = inst_18492);

(statearr_18673_18755[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (30))){
var inst_18469 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18674_18756 = state_18585__$1;
(statearr_18674_18756[(2)] = inst_18469);

(statearr_18674_18756[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (10))){
var inst_18382 = (state_18585[(12)]);
var inst_18386 = (state_18585[(13)]);
var inst_18398 = (function (){var G__18675 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__18676 = inst_18382;
return (inst_18386.cljs$core$IFn$_invoke$arity$2 ? inst_18386.cljs$core$IFn$_invoke$arity$2(G__18675,G__18676) : inst_18386.call(null,G__18675,G__18676));
})();
var state_18585__$1 = state_18585;
if(cljs.core.truth_(inst_18398)){
var statearr_18677_18757 = state_18585__$1;
(statearr_18677_18757[(1)] = (13));

} else {
var statearr_18678_18758 = state_18585__$1;
(statearr_18678_18758[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (18))){
var inst_18418 = (state_18585[(17)]);
var inst_18421 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_18418,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_18418,q_map,vars,fuel,max_fuel,opts));
var state_18585__$1 = state_18585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18585__$1,(21),inst_18421);
} else {
if((state_val_18586 === (52))){
var state_18585__$1 = state_18585;
var statearr_18679_18759 = state_18585__$1;
(statearr_18679_18759[(2)] = null);

(statearr_18679_18759[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (42))){
var inst_18576 = (state_18585[(2)]);
var state_18585__$1 = state_18585;
var statearr_18680_18760 = state_18585__$1;
(statearr_18680_18760[(2)] = inst_18576);

(statearr_18680_18760[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (37))){
var inst_18494 = cljs.core.second(clause);
var inst_18495 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18494,"rdf:type");
var state_18585__$1 = state_18585;
var statearr_18681_18761 = state_18585__$1;
(statearr_18681_18761[(2)] = inst_18495);

(statearr_18681_18761[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (63))){
var state_18585__$1 = state_18585;
var statearr_18682_18762 = state_18585__$1;
(statearr_18682_18762[(2)] = null);

(statearr_18682_18762[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (8))){
var inst_18580 = (state_18585[(2)]);
var _ = (function (){var statearr_18683 = state_18585;
(statearr_18683[(4)] = cljs.core.rest((state_18585[(4)])));

return statearr_18683;
})();
var state_18585__$1 = state_18585;
var statearr_18684_18763 = state_18585__$1;
(statearr_18684_18763[(2)] = inst_18580);

(statearr_18684_18763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18586 === (49))){
var state_18585__$1 = state_18585;
var statearr_18685_18764 = state_18585__$1;
(statearr_18685_18764[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____0 = (function (){
var statearr_18687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18687[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__);

(statearr_18687[(1)] = (1));

return statearr_18687;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____1 = (function (state_18585){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18585);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18688){var ex__2736__auto__ = e18688;
var statearr_18689_18765 = state_18585;
(statearr_18689_18765[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18585[(4)]))){
var statearr_18690_18766 = state_18585;
(statearr_18690_18766[(1)] = cljs.core.first((state_18585[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18767 = state_18585;
state_18585 = G__18767;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__ = function(state_18585){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____1.call(this,state_18585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18691 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18691[(6)] = c__2755__auto__);

return statearr_18691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__18769 = arguments.length;
switch (G__18769) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18849){
var state_val_18850 = (state_18849[(1)]);
if((state_val_18850 === (7))){
var inst_18844 = (state_18849[(2)]);
var _ = (function (){var statearr_18851 = state_18849;
(statearr_18851[(4)] = cljs.core.rest((state_18849[(4)])));

return statearr_18851;
})();
var state_18849__$1 = state_18849;
var statearr_18852_18900 = state_18849__$1;
(statearr_18852_18900[(2)] = inst_18844);

(statearr_18852_18900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (20))){
var inst_18809 = (state_18849[(7)]);
var inst_18821 = (state_18849[(2)]);
var inst_18791 = inst_18809;
var inst_18792 = inst_18821;
var state_18849__$1 = (function (){var statearr_18853 = state_18849;
(statearr_18853[(8)] = inst_18792);

(statearr_18853[(9)] = inst_18791);

return statearr_18853;
})();
var statearr_18854_18901 = state_18849__$1;
(statearr_18854_18901[(2)] = null);

(statearr_18854_18901[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (1))){
var state_18849__$1 = state_18849;
var statearr_18855_18902 = state_18849__$1;
(statearr_18855_18902[(2)] = null);

(statearr_18855_18902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (24))){
var inst_18792 = (state_18849[(8)]);
var inst_18809 = (state_18849[(7)]);
var inst_18808 = (state_18849[(10)]);
var inst_18829 = fluree.db.query.analytical.inner_join(inst_18792,inst_18808);
var inst_18791 = inst_18809;
var inst_18792__$1 = inst_18829;
var state_18849__$1 = (function (){var statearr_18856 = state_18849;
(statearr_18856[(8)] = inst_18792__$1);

(statearr_18856[(9)] = inst_18791);

return statearr_18856;
})();
var statearr_18857_18903 = state_18849__$1;
(statearr_18857_18903[(2)] = null);

(statearr_18857_18903[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (4))){
var inst_18770 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18859_18904 = state_18849__$1;
(statearr_18859_18904[(2)] = inst_18770);

(statearr_18859_18904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (15))){
var inst_18808 = (state_18849[(10)]);
var state_18849__$1 = state_18849;
if(cljs.core.truth_(inst_18808)){
var statearr_18860_18905 = state_18849__$1;
(statearr_18860_18905[(1)] = (18));

} else {
var statearr_18861_18906 = state_18849__$1;
(statearr_18861_18906[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (21))){
var inst_18792 = (state_18849[(8)]);
var inst_18809 = (state_18849[(7)]);
var tmp18858 = inst_18792;
var inst_18791 = inst_18809;
var inst_18792__$1 = tmp18858;
var state_18849__$1 = (function (){var statearr_18862 = state_18849;
(statearr_18862[(8)] = inst_18792__$1);

(statearr_18862[(9)] = inst_18791);

return statearr_18862;
})();
var statearr_18863_18907 = state_18849__$1;
(statearr_18863_18907[(2)] = null);

(statearr_18863_18907[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (13))){
var inst_18792 = (state_18849[(8)]);
var inst_18815 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_18792,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18816 = cljs.core.empty_QMARK_(inst_18815);
var state_18849__$1 = state_18849;
if(inst_18816){
var statearr_18864_18908 = state_18849__$1;
(statearr_18864_18908[(1)] = (15));

} else {
var statearr_18865_18909 = state_18849__$1;
(statearr_18865_18909[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (22))){
var state_18849__$1 = state_18849;
var statearr_18866_18910 = state_18849__$1;
(statearr_18866_18910[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (6))){
var inst_18798 = (state_18849[(11)]);
var inst_18791 = (state_18849[(9)]);
var inst_18797 = cljs.core.seq(inst_18791);
var inst_18798__$1 = cljs.core.first(inst_18797);
var inst_18799 = cljs.core.next(inst_18797);
var state_18849__$1 = (function (){var statearr_18868 = state_18849;
(statearr_18868[(11)] = inst_18798__$1);

(statearr_18868[(12)] = inst_18799);

return statearr_18868;
})();
if(cljs.core.truth_(inst_18798__$1)){
var statearr_18869_18911 = state_18849__$1;
(statearr_18869_18911[(1)] = (8));

} else {
var statearr_18870_18912 = state_18849__$1;
(statearr_18870_18912[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (25))){
var state_18849__$1 = state_18849;
var statearr_18871_18913 = state_18849__$1;
(statearr_18871_18913[(2)] = null);

(statearr_18871_18913[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (17))){
var inst_18837 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18872_18914 = state_18849__$1;
(statearr_18872_18914[(2)] = inst_18837);

(statearr_18872_18914[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (3))){
var inst_18847 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18849__$1,inst_18847);
} else {
if((state_val_18850 === (12))){
var inst_18809 = (state_18849[(7)]);
var inst_18808 = (state_18849[(10)]);
var inst_18791 = inst_18809;
var inst_18792 = inst_18808;
var state_18849__$1 = (function (){var statearr_18873 = state_18849;
(statearr_18873[(8)] = inst_18792);

(statearr_18873[(9)] = inst_18791);

return statearr_18873;
})();
var statearr_18874_18915 = state_18849__$1;
(statearr_18874_18915[(2)] = null);

(statearr_18874_18915[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (2))){
var _ = (function (){var statearr_18875 = state_18849;
(statearr_18875[(4)] = cljs.core.cons((5),(state_18849[(4)])));

return statearr_18875;
})();
var inst_18783 = where;
var inst_18784 = cljs.core.seq(inst_18783);
var inst_18785 = cljs.core.first(inst_18784);
var inst_18786 = cljs.core.next(inst_18784);
var inst_18787 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18788 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_18789 = [inst_18788];
var inst_18790 = cljs.core.PersistentHashMap.fromArrays(inst_18787,inst_18789);
var inst_18791 = inst_18783;
var inst_18792 = inst_18790;
var state_18849__$1 = (function (){var statearr_18876 = state_18849;
(statearr_18876[(13)] = inst_18786);

(statearr_18876[(14)] = inst_18785);

(statearr_18876[(8)] = inst_18792);

(statearr_18876[(9)] = inst_18791);

return statearr_18876;
})();
var statearr_18877_18916 = state_18849__$1;
(statearr_18877_18916[(2)] = null);

(statearr_18877_18916[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (23))){
var inst_18835 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18878_18917 = state_18849__$1;
(statearr_18878_18917[(2)] = inst_18835);

(statearr_18878_18917[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (19))){
var inst_18792 = (state_18849[(8)]);
var state_18849__$1 = state_18849;
var statearr_18879_18918 = state_18849__$1;
(statearr_18879_18918[(2)] = inst_18792);

(statearr_18879_18918[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (11))){
var inst_18798 = (state_18849[(11)]);
var inst_18806 = (state_18849[(2)]);
var inst_18807 = fluree.db.util.async.throw_err(inst_18806);
var inst_18808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18807,(0),null);
var inst_18809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18807,(1),null);
var inst_18810 = cljs.core.count(inst_18798);
var inst_18811 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_18810);
var state_18849__$1 = (function (){var statearr_18881 = state_18849;
(statearr_18881[(7)] = inst_18809);

(statearr_18881[(10)] = inst_18808);

return statearr_18881;
})();
if(inst_18811){
var statearr_18882_18919 = state_18849__$1;
(statearr_18882_18919[(1)] = (12));

} else {
var statearr_18883_18920 = state_18849__$1;
(statearr_18883_18920[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (9))){
var inst_18792 = (state_18849[(8)]);
var state_18849__$1 = state_18849;
var statearr_18884_18921 = state_18849__$1;
(statearr_18884_18921[(2)] = inst_18792);

(statearr_18884_18921[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (5))){
var _ = (function (){var statearr_18885 = state_18849;
(statearr_18885[(4)] = cljs.core.rest((state_18849[(4)])));

return statearr_18885;
})();
var state_18849__$1 = state_18849;
var ex18880 = (state_18849__$1[(2)]);
var statearr_18886_18922 = state_18849__$1;
(statearr_18886_18922[(5)] = ex18880);


if((ex18880 instanceof Error)){
var statearr_18887_18923 = state_18849__$1;
(statearr_18887_18923[(1)] = (4));

(statearr_18887_18923[(5)] = null);

} else {
throw ex18880;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (14))){
var inst_18839 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18888_18924 = state_18849__$1;
(statearr_18888_18924[(2)] = inst_18839);

(statearr_18888_18924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (26))){
var inst_18833 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18889_18925 = state_18849__$1;
(statearr_18889_18925[(2)] = inst_18833);

(statearr_18889_18925[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (16))){
var inst_18808 = (state_18849[(10)]);
var inst_18824 = (inst_18808 == null);
var state_18849__$1 = state_18849;
if(cljs.core.truth_(inst_18824)){
var statearr_18890_18926 = state_18849__$1;
(statearr_18890_18926[(1)] = (21));

} else {
var statearr_18891_18927 = state_18849__$1;
(statearr_18891_18927[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (10))){
var inst_18842 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18892_18928 = state_18849__$1;
(statearr_18892_18928[(2)] = inst_18842);

(statearr_18892_18928[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (18))){
var inst_18808 = (state_18849[(10)]);
var state_18849__$1 = state_18849;
var statearr_18893_18929 = state_18849__$1;
(statearr_18893_18929[(2)] = inst_18808);

(statearr_18893_18929[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (8))){
var inst_18798 = (state_18849[(11)]);
var inst_18799 = (state_18849[(12)]);
var inst_18792 = (state_18849[(8)]);
var inst_18804 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_18792,inst_18798,inst_18799,false,fuel,max_fuel,opts);
var state_18849__$1 = state_18849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18849__$1,(11),inst_18804);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2733__auto__ = null;
var fluree$db$query$analytical$state_machine__2733__auto____0 = (function (){
var statearr_18894 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18894[(0)] = fluree$db$query$analytical$state_machine__2733__auto__);

(statearr_18894[(1)] = (1));

return statearr_18894;
});
var fluree$db$query$analytical$state_machine__2733__auto____1 = (function (state_18849){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18849);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18895){var ex__2736__auto__ = e18895;
var statearr_18896_18930 = state_18849;
(statearr_18896_18930[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18849[(4)]))){
var statearr_18897_18931 = state_18849;
(statearr_18897_18931[(1)] = cljs.core.first((state_18849[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18932 = state_18849;
state_18849 = G__18932;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2733__auto__ = function(state_18849){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2733__auto____1.call(this,state_18849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2733__auto____0;
fluree$db$query$analytical$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2733__auto____1;
return fluree$db$query$analytical$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18898 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18898[(6)] = c__2755__auto__);

return statearr_18898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18967){
var state_val_18968 = (state_18967[(1)]);
if((state_val_18968 === (7))){
var inst_18944 = (state_18967[(7)]);
var inst_18949 = (state_18967[(8)]);
var inst_18951 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_18944,inst_18949,fuel,max_fuel,opts);
var state_18967__$1 = state_18967;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18967__$1,(10),inst_18951);
} else {
if((state_val_18968 === (1))){
var state_18967__$1 = state_18967;
var statearr_18969_18994 = state_18967__$1;
(statearr_18969_18994[(2)] = null);

(statearr_18969_18994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (4))){
var inst_18933 = (state_18967[(2)]);
var state_18967__$1 = state_18967;
var statearr_18970_18995 = state_18967__$1;
(statearr_18970_18995[(2)] = inst_18933);

(statearr_18970_18995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (13))){
var inst_18962 = (state_18967[(2)]);
var _ = (function (){var statearr_18971 = state_18967;
(statearr_18971[(4)] = cljs.core.rest((state_18967[(4)])));

return statearr_18971;
})();
var state_18967__$1 = state_18967;
var statearr_18972_18996 = state_18967__$1;
(statearr_18972_18996[(2)] = inst_18962);

(statearr_18972_18996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (6))){
var inst_18944 = (state_18967[(7)]);
var inst_18948 = (state_18967[(2)]);
var inst_18949 = fluree.db.util.async.throw_err(inst_18948);
var state_18967__$1 = (function (){var statearr_18973 = state_18967;
(statearr_18973[(8)] = inst_18949);

return statearr_18973;
})();
if(cljs.core.truth_(inst_18944)){
var statearr_18974_18997 = state_18967__$1;
(statearr_18974_18997[(1)] = (7));

} else {
var statearr_18975_18998 = state_18967__$1;
(statearr_18975_18998[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (3))){
var inst_18965 = (state_18967[(2)]);
var state_18967__$1 = state_18967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18967__$1,inst_18965);
} else {
if((state_val_18968 === (12))){
var inst_18957 = (state_18967[(9)]);
var state_18967__$1 = state_18967;
var statearr_18976_18999 = state_18967__$1;
(statearr_18976_18999[(2)] = inst_18957);

(statearr_18976_18999[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (2))){
var _ = (function (){var statearr_18977 = state_18967;
(statearr_18977[(4)] = cljs.core.cons((5),(state_18967[(4)])));

return statearr_18977;
})();
var inst_18940 = q_map;
var inst_18941 = cljs.core.__destructure_map(inst_18940);
var inst_18942 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18941,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18941,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_18944 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18941,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_18945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18941,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_18946 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_18943,q_map,inst_18942,fuel,max_fuel,opts);
var state_18967__$1 = (function (){var statearr_18978 = state_18967;
(statearr_18978[(7)] = inst_18944);

(statearr_18978[(10)] = inst_18945);

return statearr_18978;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18967__$1,(6),inst_18946);
} else {
if((state_val_18968 === (11))){
var inst_18945 = (state_18967[(10)]);
var inst_18957 = (state_18967[(9)]);
var inst_18959 = fluree.db.query.analytical.tuples__GT_filtered(inst_18957,inst_18945,null);
var state_18967__$1 = state_18967;
var statearr_18980_19000 = state_18967__$1;
(statearr_18980_19000[(2)] = inst_18959);

(statearr_18980_19000[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (9))){
var inst_18945 = (state_18967[(10)]);
var inst_18957 = (state_18967[(2)]);
var state_18967__$1 = (function (){var statearr_18981 = state_18967;
(statearr_18981[(9)] = inst_18957);

return statearr_18981;
})();
if(cljs.core.truth_(inst_18945)){
var statearr_18982_19001 = state_18967__$1;
(statearr_18982_19001[(1)] = (11));

} else {
var statearr_18983_19002 = state_18967__$1;
(statearr_18983_19002[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (5))){
var _ = (function (){var statearr_18984 = state_18967;
(statearr_18984[(4)] = cljs.core.rest((state_18967[(4)])));

return statearr_18984;
})();
var state_18967__$1 = state_18967;
var ex18979 = (state_18967__$1[(2)]);
var statearr_18985_19003 = state_18967__$1;
(statearr_18985_19003[(5)] = ex18979);


if((ex18979 instanceof Error)){
var statearr_18986_19004 = state_18967__$1;
(statearr_18986_19004[(1)] = (4));

(statearr_18986_19004[(5)] = null);

} else {
throw ex18979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (10))){
var inst_18953 = (state_18967[(2)]);
var inst_18954 = fluree.db.util.async.throw_err(inst_18953);
var state_18967__$1 = state_18967;
var statearr_18987_19005 = state_18967__$1;
(statearr_18987_19005[(2)] = inst_18954);

(statearr_18987_19005[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18968 === (8))){
var inst_18949 = (state_18967[(8)]);
var state_18967__$1 = state_18967;
var statearr_18988_19006 = state_18967__$1;
(statearr_18988_19006[(2)] = inst_18949);

(statearr_18988_19006[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2733__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2733__auto____0 = (function (){
var statearr_18989 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18989[(0)] = fluree$db$query$analytical$q_$_state_machine__2733__auto__);

(statearr_18989[(1)] = (1));

return statearr_18989;
});
var fluree$db$query$analytical$q_$_state_machine__2733__auto____1 = (function (state_18967){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18967);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18990){var ex__2736__auto__ = e18990;
var statearr_18991_19007 = state_18967;
(statearr_18991_19007[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18967[(4)]))){
var statearr_18992_19008 = state_18967;
(statearr_18992_19008[(1)] = cljs.core.first((state_18967[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19009 = state_18967;
state_18967 = G__19009;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2733__auto__ = function(state_18967){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2733__auto____1.call(this,state_18967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2733__auto____0;
fluree$db$query$analytical$q_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2733__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18993 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18993[(6)] = c__2755__auto__);

return statearr_18993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
