// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__14021 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14021,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14021,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14021,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14021,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14021,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14021,(5),null);
var G__14024 = idx;
var G__14024__$1 = (((G__14024 instanceof cljs.core.Keyword))?G__14024.fqn:null);
switch (G__14024__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14024__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__14026 = idx;
var G__14026__$1 = (((G__14026 instanceof cljs.core.Keyword))?G__14026.fqn:null);
switch (G__14026__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14026__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__14028 = idx;
var G__14028__$1 = (((G__14028 instanceof cljs.core.Keyword))?G__14028.fqn:null);
switch (G__14028__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14028__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__14031 = arguments.length;
switch (G__14031) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14032 = (function (){var pred__14035 = cljs.core.identical_QMARK_;
var expr__14036 = test;
if(cljs.core.truth_((pred__14035.cljs$core$IFn$_invoke$arity$2 ? pred__14035.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14036) : pred__14035.call(null,cljs.core._EQ_,expr__14036)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14035.cljs$core$IFn$_invoke$arity$2 ? pred__14035.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14036) : pred__14035.call(null,cljs.core._LT_,expr__14036)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14035.cljs$core$IFn$_invoke$arity$2 ? pred__14035.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14036) : pred__14035.call(null,cljs.core._LT__EQ_,expr__14036)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14035.cljs$core$IFn$_invoke$arity$2 ? pred__14035.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14036) : pred__14035.call(null,cljs.core._GT_,expr__14036)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14035.cljs$core$IFn$_invoke$arity$2 ? pred__14035.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14036) : pred__14035.call(null,cljs.core._GT__EQ_,expr__14036)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14036)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14032,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14032,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14032,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14032,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_14275){
var state_val_14276 = (state_14275[(1)]);
if((state_val_14276 === (65))){
var inst_14190 = (state_14275[(7)]);
var inst_14246 = (state_14275[(8)]);
var inst_14246__$1 = (state_14275[(2)]);
var inst_14247 = cljs.core.count(inst_14246__$1);
var state_14275__$1 = (function (){var statearr_14277 = state_14275;
(statearr_14277[(8)] = inst_14246__$1);

(statearr_14277[(9)] = inst_14247);

return statearr_14277;
})();
if(cljs.core.truth_(inst_14190)){
var statearr_14278_14415 = state_14275__$1;
(statearr_14278_14415[(1)] = (81));

} else {
var statearr_14279_14416 = state_14275__$1;
(statearr_14279_14416[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (70))){
var inst_14221 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
if(cljs.core.truth_(inst_14221)){
var statearr_14280_14417 = state_14275__$1;
(statearr_14280_14417[(1)] = (71));

} else {
var statearr_14281_14418 = state_14275__$1;
(statearr_14281_14418[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (62))){
var inst_14160 = (state_14275[(10)]);
var inst_14174 = (state_14275[(11)]);
var inst_14189 = (state_14275[(2)]);
var inst_14190 = fluree.db.dbproto._rhs(inst_14174);
var state_14275__$1 = (function (){var statearr_14282 = state_14275;
(statearr_14282[(7)] = inst_14190);

(statearr_14282[(12)] = inst_14189);

return statearr_14282;
})();
if(cljs.core.truth_(inst_14160)){
var statearr_14283_14419 = state_14275__$1;
(statearr_14283_14419[(1)] = (63));

} else {
var statearr_14284_14420 = state_14275__$1;
(statearr_14284_14420[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (74))){
var inst_14214 = (state_14275[(13)]);
var inst_14228 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_14214);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(77),inst_14228);
} else {
if((state_val_14276 === (7))){
var inst_14051 = (state_14275[(14)]);
var state_14275__$1 = state_14275;
var statearr_14285_14421 = state_14275__$1;
(statearr_14285_14421[(2)] = inst_14051);

(statearr_14285_14421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (59))){
var inst_14137 = (state_14275[(15)]);
var inst_14181 = (state_14275[(16)]);
var inst_14136 = (state_14275[(17)]);
var inst_14180 = (state_14275[(2)]);
var inst_14181__$1 = fluree.db.util.async.throw_err(inst_14180);
var inst_14182 = fluree.db.flake.subrange(inst_14181__$1,start_test,inst_14136,end_test,inst_14137);
var inst_14183 = fluree.db.query.range.value_with_nil_pred(idx,inst_14136,inst_14137);
var state_14275__$1 = (function (){var statearr_14286 = state_14275;
(statearr_14286[(16)] = inst_14181__$1);

(statearr_14286[(18)] = inst_14182);

return statearr_14286;
})();
if(inst_14183){
var statearr_14287_14422 = state_14275__$1;
(statearr_14287_14422[(1)] = (60));

} else {
var statearr_14288_14423 = state_14275__$1;
(statearr_14288_14423[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (86))){
var inst_14255 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14289_14424 = state_14275__$1;
(statearr_14289_14424[(2)] = inst_14255);

(statearr_14289_14424[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (20))){
var inst_14052 = (state_14275[(19)]);
var inst_14100 = (state_14275[(20)]);
var inst_14099 = (state_14275[(2)]);
var inst_14100__$1 = (inst_14052 == null);
var state_14275__$1 = (function (){var statearr_14290 = state_14275;
(statearr_14290[(21)] = inst_14099);

(statearr_14290[(20)] = inst_14100__$1);

return statearr_14290;
})();
if(cljs.core.truth_(inst_14100__$1)){
var statearr_14291_14425 = state_14275__$1;
(statearr_14291_14425[(1)] = (22));

} else {
var statearr_14292_14426 = state_14275__$1;
(statearr_14292_14426[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (72))){
var inst_14207 = (state_14275[(22)]);
var inst_14225 = (inst_14207 + (1));
var inst_14226 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14275__$1 = (function (){var statearr_14293 = state_14275;
(statearr_14293[(23)] = inst_14225);

return statearr_14293;
})();
if(cljs.core.truth_(inst_14226)){
var statearr_14294_14427 = state_14275__$1;
(statearr_14294_14427[(1)] = (74));

} else {
var statearr_14295_14428 = state_14275__$1;
(statearr_14295_14428[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (58))){
var inst_14270 = (state_14275[(2)]);
var _ = (function (){var statearr_14296 = state_14275;
(statearr_14296[(4)] = cljs.core.rest((state_14275[(4)])));

return statearr_14296;
})();
var state_14275__$1 = state_14275;
var statearr_14297_14429 = state_14275__$1;
(statearr_14297_14429[(2)] = inst_14270);

(statearr_14297_14429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (60))){
var inst_14137 = (state_14275[(15)]);
var inst_14142 = (state_14275[(24)]);
var inst_14160 = (state_14275[(10)]);
var inst_14143 = (state_14275[(25)]);
var inst_14050 = (state_14275[(26)]);
var inst_14099 = (state_14275[(21)]);
var inst_14147 = (state_14275[(27)]);
var inst_14081 = (state_14275[(28)]);
var inst_14062 = (state_14275[(29)]);
var inst_14176 = (state_14275[(30)]);
var inst_14154 = (state_14275[(31)]);
var inst_14054 = (state_14275[(32)]);
var inst_14126 = (state_14275[(33)]);
var inst_14072 = (state_14275[(34)]);
var inst_14057 = (state_14275[(35)]);
var inst_14090 = (state_14275[(36)]);
var inst_14169 = (state_14275[(37)]);
var inst_14061 = (state_14275[(38)]);
var inst_14175 = (state_14275[(39)]);
var inst_14055 = (state_14275[(40)]);
var inst_14117 = (state_14275[(41)]);
var inst_14164 = (state_14275[(42)]);
var inst_14153 = (state_14275[(43)]);
var inst_14181 = (state_14275[(16)]);
var inst_14135 = (state_14275[(44)]);
var inst_14174 = (state_14275[(11)]);
var inst_14136 = (state_14275[(17)]);
var inst_14182 = (state_14275[(18)]);
var inst_14108 = (state_14275[(45)]);
var inst_14185 = (function (){var no_filter_QMARK_ = inst_14160;
var next_node = inst_14174;
var flakes = inst_14181;
var s1 = inst_14072;
var o2 = inst_14099;
var t1 = inst_14054;
var i = inst_14175;
var vec__14047 = inst_14057;
var m1 = inst_14126;
var root_node = inst_14169;
var to_t = inst_14154;
var s2 = inst_14081;
var p2 = inst_14117;
var permissions = inst_14143;
var limit = inst_14142;
var start_flake = inst_14136;
var acc = inst_14176;
var vec__14044 = inst_14050;
var t2 = inst_14061;
var op1 = inst_14055;
var o1 = inst_14090;
var end_flake = inst_14137;
var base_result = inst_14182;
var p1 = inst_14108;
var idx_compare = inst_14147;
var op2 = inst_14062;
var from_t = inst_14153;
var m2 = inst_14135;
var novelty = inst_14164;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_14186 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_14185,inst_14182,inst_14182);
var state_14275__$1 = state_14275;
var statearr_14298_14430 = state_14275__$1;
(statearr_14298_14430[(2)] = inst_14186);

(statearr_14298_14430[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (27))){
var inst_14059 = (state_14275[(46)]);
var inst_14109 = (state_14275[(47)]);
var inst_14108 = (state_14275[(2)]);
var inst_14109__$1 = (inst_14059 == null);
var state_14275__$1 = (function (){var statearr_14299 = state_14275;
(statearr_14299[(47)] = inst_14109__$1);

(statearr_14299[(45)] = inst_14108);

return statearr_14299;
})();
if(cljs.core.truth_(inst_14109__$1)){
var statearr_14300_14431 = state_14275__$1;
(statearr_14300_14431[(1)] = (28));

} else {
var statearr_14301_14432 = state_14275__$1;
(statearr_14301_14432[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (1))){
var state_14275__$1 = state_14275;
var statearr_14302_14433 = state_14275__$1;
(statearr_14302_14433[(2)] = null);

(statearr_14302_14433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (69))){
var inst_14142 = (state_14275[(24)]);
var inst_14207 = (state_14275[(22)]);
var inst_14219 = (inst_14207 > inst_14142);
var state_14275__$1 = state_14275;
var statearr_14303_14434 = state_14275__$1;
(statearr_14303_14434[(2)] = inst_14219);

(statearr_14303_14434[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (24))){
var inst_14104 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
if(cljs.core.truth_(inst_14104)){
var statearr_14304_14435 = state_14275__$1;
(statearr_14304_14435[(1)] = (25));

} else {
var statearr_14305_14436 = state_14275__$1;
(statearr_14305_14436[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (55))){
var inst_14169 = (state_14275[(37)]);
var inst_14136 = (state_14275[(17)]);
var inst_14168 = (state_14275[(2)]);
var inst_14169__$1 = fluree.db.util.async.throw_err(inst_14168);
var inst_14170 = fluree.db.dbproto._lookup_leaf(inst_14169__$1,inst_14136);
var state_14275__$1 = (function (){var statearr_14306 = state_14275;
(statearr_14306[(37)] = inst_14169__$1);

return statearr_14306;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(56),inst_14170);
} else {
if((state_val_14276 === (85))){
var inst_14250 = (state_14275[(48)]);
var state_14275__$1 = state_14275;
var statearr_14307_14437 = state_14275__$1;
(statearr_14307_14437[(2)] = inst_14250);

(statearr_14307_14437[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (39))){
var inst_14124 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14308_14438 = state_14275__$1;
(statearr_14308_14438[(2)] = inst_14124);

(statearr_14308_14438[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (88))){
var inst_14190 = (state_14275[(7)]);
var inst_14169 = (state_14275[(37)]);
var inst_14262 = fluree.db.dbproto._lookup_leaf(inst_14169,inst_14190);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(90),inst_14262);
} else {
if((state_val_14276 === (46))){
var inst_14138 = (state_14275[(49)]);
var state_14275__$1 = state_14275;
var statearr_14309_14439 = state_14275__$1;
(statearr_14309_14439[(2)] = inst_14138);

(statearr_14309_14439[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (4))){
var inst_14038 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14310_14440 = state_14275__$1;
(statearr_14310_14440[(2)] = inst_14038);

(statearr_14310_14440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (77))){
var inst_14230 = (state_14275[(2)]);
var inst_14231 = fluree.db.util.async.throw_err(inst_14230);
var state_14275__$1 = state_14275;
if(cljs.core.truth_(inst_14231)){
var statearr_14311_14441 = state_14275__$1;
(statearr_14311_14441[(1)] = (78));

} else {
var statearr_14312_14442 = state_14275__$1;
(statearr_14312_14442[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (54))){
var inst_14160 = (state_14275[(2)]);
var inst_14161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14162 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14163 = (new cljs.core.PersistentVector(null,2,(5),inst_14161,inst_14162,null));
var inst_14164 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14163);
var inst_14165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14166 = fluree.db.dbproto._resolve(inst_14165);
var state_14275__$1 = (function (){var statearr_14313 = state_14275;
(statearr_14313[(10)] = inst_14160);

(statearr_14313[(42)] = inst_14164);

return statearr_14313;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(55),inst_14166);
} else {
if((state_val_14276 === (15))){
var inst_14053 = (state_14275[(50)]);
var state_14275__$1 = state_14275;
var statearr_14314_14443 = state_14275__$1;
(statearr_14314_14443[(2)] = inst_14053);

(statearr_14314_14443[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (48))){
var inst_14148 = (state_14275[(51)]);
var inst_14142 = (state_14275[(2)]);
var inst_14143 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14145 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14146 = (new cljs.core.PersistentVector(null,3,(5),inst_14144,inst_14145,null));
var inst_14147 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14146);
var inst_14148__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14275__$1 = (function (){var statearr_14315 = state_14275;
(statearr_14315[(24)] = inst_14142);

(statearr_14315[(25)] = inst_14143);

(statearr_14315[(27)] = inst_14147);

(statearr_14315[(51)] = inst_14148__$1);

return statearr_14315;
})();
if(cljs.core.truth_(inst_14148__$1)){
var statearr_14316_14444 = state_14275__$1;
(statearr_14316_14444[(1)] = (49));

} else {
var statearr_14317_14445 = state_14275__$1;
(statearr_14317_14445[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (50))){
var inst_14151 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14275__$1 = state_14275;
var statearr_14318_14446 = state_14275__$1;
(statearr_14318_14446[(2)] = inst_14151);

(statearr_14318_14446[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (75))){
var inst_14208 = (state_14275[(52)]);
var state_14275__$1 = state_14275;
var statearr_14319_14447 = state_14275__$1;
(statearr_14319_14447[(2)] = inst_14208);

(statearr_14319_14447[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (21))){
var inst_14095 = (state_14275[(2)]);
var inst_14096 = fluree.db.util.async.throw_err(inst_14095);
var state_14275__$1 = state_14275;
var statearr_14320_14448 = state_14275__$1;
(statearr_14320_14448[(2)] = inst_14096);

(statearr_14320_14448[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (31))){
var state_14275__$1 = state_14275;
var statearr_14321_14449 = state_14275__$1;
(statearr_14321_14449[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14321_14449[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (32))){
var inst_14059 = (state_14275[(46)]);
var state_14275__$1 = state_14275;
var statearr_14322_14450 = state_14275__$1;
(statearr_14322_14450[(2)] = inst_14059);

(statearr_14322_14450[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (40))){
var inst_14063 = (state_14275[(53)]);
var state_14275__$1 = state_14275;
var statearr_14323_14451 = state_14275__$1;
(statearr_14323_14451[(2)] = inst_14063);

(statearr_14323_14451[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (56))){
var inst_14172 = (state_14275[(2)]);
var inst_14173 = fluree.db.util.async.throw_err(inst_14172);
var inst_14174 = inst_14173;
var inst_14175 = (0);
var inst_14176 = null;
var state_14275__$1 = (function (){var statearr_14324 = state_14275;
(statearr_14324[(30)] = inst_14176);

(statearr_14324[(39)] = inst_14175);

(statearr_14324[(11)] = inst_14174);

return statearr_14324;
})();
var statearr_14325_14452 = state_14275__$1;
(statearr_14325_14452[(2)] = null);

(statearr_14325_14452[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (33))){
var inst_14056 = (state_14275[(54)]);
var inst_14117 = (state_14275[(2)]);
var state_14275__$1 = (function (){var statearr_14326 = state_14275;
(statearr_14326[(41)] = inst_14117);

return statearr_14326;
})();
if(cljs.core.truth_(inst_14056)){
var statearr_14327_14453 = state_14275__$1;
(statearr_14327_14453[(1)] = (34));

} else {
var statearr_14328_14454 = state_14275__$1;
(statearr_14328_14454[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (13))){
var inst_14077 = (state_14275[(2)]);
var inst_14078 = fluree.db.util.async.throw_err(inst_14077);
var state_14275__$1 = state_14275;
var statearr_14329_14455 = state_14275__$1;
(statearr_14329_14455[(2)] = inst_14078);

(statearr_14329_14455[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (22))){
var inst_14090 = (state_14275[(36)]);
var state_14275__$1 = state_14275;
var statearr_14330_14456 = state_14275__$1;
(statearr_14330_14456[(2)] = inst_14090);

(statearr_14330_14456[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (90))){
var inst_14246 = (state_14275[(8)]);
var inst_14247 = (state_14275[(9)]);
var inst_14264 = (state_14275[(2)]);
var inst_14265 = fluree.db.util.async.throw_err(inst_14264);
var inst_14174 = inst_14265;
var inst_14175 = inst_14247;
var inst_14176 = inst_14246;
var state_14275__$1 = (function (){var statearr_14331 = state_14275;
(statearr_14331[(30)] = inst_14176);

(statearr_14331[(39)] = inst_14175);

(statearr_14331[(11)] = inst_14174);

return statearr_14331;
})();
var statearr_14332_14457 = state_14275__$1;
(statearr_14332_14457[(2)] = null);

(statearr_14332_14457[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (36))){
var inst_14063 = (state_14275[(53)]);
var inst_14126 = (state_14275[(2)]);
var state_14275__$1 = (function (){var statearr_14333 = state_14275;
(statearr_14333[(33)] = inst_14126);

return statearr_14333;
})();
if(cljs.core.truth_(inst_14063)){
var statearr_14334_14458 = state_14275__$1;
(statearr_14334_14458[(1)] = (40));

} else {
var statearr_14335_14459 = state_14275__$1;
(statearr_14335_14459[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (41))){
var inst_14129 = (cljs.core._LT__EQ_ === end_test);
var state_14275__$1 = state_14275;
if(cljs.core.truth_(inst_14129)){
var statearr_14336_14460 = state_14275__$1;
(statearr_14336_14460[(1)] = (43));

} else {
var statearr_14337_14461 = state_14275__$1;
(statearr_14337_14461[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (89))){
var inst_14268 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14338_14462 = state_14275__$1;
(statearr_14338_14462[(2)] = inst_14268);

(statearr_14338_14462[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (43))){
var state_14275__$1 = state_14275;
var statearr_14339_14463 = state_14275__$1;
(statearr_14339_14463[(2)] = (2147483647));

(statearr_14339_14463[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (61))){
var inst_14182 = (state_14275[(18)]);
var state_14275__$1 = state_14275;
var statearr_14340_14464 = state_14275__$1;
(statearr_14340_14464[(2)] = inst_14182);

(statearr_14340_14464[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (29))){
var inst_14109 = (state_14275[(47)]);
var state_14275__$1 = state_14275;
var statearr_14341_14465 = state_14275__$1;
(statearr_14341_14465[(2)] = inst_14109);

(statearr_14341_14465[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (44))){
var state_14275__$1 = state_14275;
var statearr_14342_14466 = state_14275__$1;
(statearr_14342_14466[(2)] = fluree.db.util.core.min_integer);

(statearr_14342_14466[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (6))){
var inst_14051 = (state_14275[(14)]);
var inst_14066 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14051);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(9),inst_14066);
} else {
if((state_val_14276 === (28))){
var inst_14099 = (state_14275[(21)]);
var state_14275__$1 = state_14275;
var statearr_14343_14467 = state_14275__$1;
(statearr_14343_14467[(2)] = inst_14099);

(statearr_14343_14467[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (64))){
var inst_14189 = (state_14275[(12)]);
var inst_14175 = (state_14275[(39)]);
var inst_14203 = cljs.core.seq(inst_14189);
var inst_14204 = cljs.core.first(inst_14203);
var inst_14205 = cljs.core.next(inst_14203);
var inst_14206 = inst_14189;
var inst_14207 = inst_14175;
var inst_14208 = inst_14189;
var state_14275__$1 = (function (){var statearr_14344 = state_14275;
(statearr_14344[(52)] = inst_14208);

(statearr_14344[(22)] = inst_14207);

(statearr_14344[(55)] = inst_14205);

(statearr_14344[(56)] = inst_14206);

(statearr_14344[(57)] = inst_14204);

return statearr_14344;
})();
var statearr_14345_14468 = state_14275__$1;
(statearr_14345_14468[(2)] = null);

(statearr_14345_14468[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (51))){
var inst_14153 = (state_14275[(2)]);
var inst_14154 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_14155 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14275__$1 = (function (){var statearr_14346 = state_14275;
(statearr_14346[(31)] = inst_14154);

(statearr_14346[(43)] = inst_14153);

return statearr_14346;
})();
if(cljs.core.truth_(inst_14155)){
var statearr_14347_14469 = state_14275__$1;
(statearr_14347_14469[(1)] = (52));

} else {
var statearr_14348_14470 = state_14275__$1;
(statearr_14348_14470[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (25))){
var state_14275__$1 = state_14275;
var statearr_14349_14471 = state_14275__$1;
(statearr_14349_14471[(2)] = (-1));

(statearr_14349_14471[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (34))){
var inst_14056 = (state_14275[(54)]);
var state_14275__$1 = state_14275;
var statearr_14350_14472 = state_14275__$1;
(statearr_14350_14472[(2)] = inst_14056);

(statearr_14350_14472[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (17))){
var inst_14086 = (state_14275[(2)]);
var inst_14087 = fluree.db.util.async.throw_err(inst_14086);
var state_14275__$1 = state_14275;
var statearr_14351_14473 = state_14275__$1;
(statearr_14351_14473[(2)] = inst_14087);

(statearr_14351_14473[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (3))){
var inst_14273 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14275__$1,inst_14273);
} else {
if((state_val_14276 === (12))){
var inst_14053 = (state_14275[(50)]);
var inst_14081 = (state_14275[(2)]);
var inst_14082 = fluree.db.util.core.pred_ident_QMARK_(inst_14053);
var state_14275__$1 = (function (){var statearr_14352 = state_14275;
(statearr_14352[(28)] = inst_14081);

return statearr_14352;
})();
if(inst_14082){
var statearr_14353_14474 = state_14275__$1;
(statearr_14353_14474[(1)] = (14));

} else {
var statearr_14354_14475 = state_14275__$1;
(statearr_14354_14475[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (2))){
var inst_14050 = (state_14275[(26)]);
var inst_14051 = (state_14275[(14)]);
var inst_14057 = (state_14275[(35)]);
var _ = (function (){var statearr_14355 = state_14275;
(statearr_14355[(4)] = cljs.core.cons((5),(state_14275[(4)])));

return statearr_14355;
})();
var inst_14050__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14051__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14050__$1,(0),null);
var inst_14052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14050__$1,(1),null);
var inst_14053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14050__$1,(2),null);
var inst_14054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14050__$1,(3),null);
var inst_14055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14050__$1,(4),null);
var inst_14056 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14050__$1,(5),null);
var inst_14057__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14057__$1,(0),null);
var inst_14059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14057__$1,(1),null);
var inst_14060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14057__$1,(2),null);
var inst_14061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14057__$1,(3),null);
var inst_14062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14057__$1,(4),null);
var inst_14063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14057__$1,(5),null);
var inst_14064 = fluree.db.util.core.pred_ident_QMARK_(inst_14051__$1);
var state_14275__$1 = (function (){var statearr_14356 = state_14275;
(statearr_14356[(26)] = inst_14050__$1);

(statearr_14356[(54)] = inst_14056);

(statearr_14356[(19)] = inst_14052);

(statearr_14356[(29)] = inst_14062);

(statearr_14356[(58)] = inst_14058);

(statearr_14356[(14)] = inst_14051__$1);

(statearr_14356[(32)] = inst_14054);

(statearr_14356[(46)] = inst_14059);

(statearr_14356[(35)] = inst_14057__$1);

(statearr_14356[(53)] = inst_14063);

(statearr_14356[(38)] = inst_14061);

(statearr_14356[(40)] = inst_14055);

(statearr_14356[(59)] = inst_14060);

(statearr_14356[(50)] = inst_14053);

return statearr_14356;
})();
if(inst_14064){
var statearr_14357_14476 = state_14275__$1;
(statearr_14357_14476[(1)] = (6));

} else {
var statearr_14358_14477 = state_14275__$1;
(statearr_14358_14477[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (66))){
var inst_14216 = (state_14275[(60)]);
var inst_14206 = (state_14275[(56)]);
var inst_14214 = (state_14275[(13)]);
var inst_14213 = cljs.core.seq(inst_14206);
var inst_14214__$1 = cljs.core.first(inst_14213);
var inst_14215 = cljs.core.next(inst_14213);
var inst_14216__$1 = (inst_14214__$1 == null);
var state_14275__$1 = (function (){var statearr_14359 = state_14275;
(statearr_14359[(60)] = inst_14216__$1);

(statearr_14359[(61)] = inst_14215);

(statearr_14359[(13)] = inst_14214__$1);

return statearr_14359;
})();
if(cljs.core.truth_(inst_14216__$1)){
var statearr_14360_14478 = state_14275__$1;
(statearr_14360_14478[(1)] = (68));

} else {
var statearr_14361_14479 = state_14275__$1;
(statearr_14361_14479[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (23))){
var inst_14100 = (state_14275[(20)]);
var state_14275__$1 = state_14275;
var statearr_14362_14480 = state_14275__$1;
(statearr_14362_14480[(2)] = inst_14100);

(statearr_14362_14480[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (47))){
var state_14275__$1 = state_14275;
var statearr_14363_14481 = state_14275__$1;
(statearr_14363_14481[(2)] = fluree.db.util.core.max_long);

(statearr_14363_14481[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (35))){
var inst_14120 = (cljs.core._GT__EQ_ === start_test);
var state_14275__$1 = state_14275;
if(cljs.core.truth_(inst_14120)){
var statearr_14364_14482 = state_14275__$1;
(statearr_14364_14482[(1)] = (37));

} else {
var statearr_14365_14483 = state_14275__$1;
(statearr_14365_14483[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (82))){
var inst_14190 = (state_14275[(7)]);
var state_14275__$1 = state_14275;
var statearr_14366_14484 = state_14275__$1;
(statearr_14366_14484[(2)] = inst_14190);

(statearr_14366_14484[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (76))){
var inst_14225 = (state_14275[(23)]);
var inst_14215 = (state_14275[(61)]);
var inst_14239 = (state_14275[(2)]);
var inst_14206 = inst_14215;
var inst_14207 = inst_14225;
var inst_14208 = inst_14239;
var state_14275__$1 = (function (){var statearr_14367 = state_14275;
(statearr_14367[(52)] = inst_14208);

(statearr_14367[(22)] = inst_14207);

(statearr_14367[(56)] = inst_14206);

return statearr_14367;
})();
var statearr_14368_14485 = state_14275__$1;
(statearr_14368_14485[(2)] = null);

(statearr_14368_14485[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (19))){
var inst_14060 = (state_14275[(59)]);
var state_14275__$1 = state_14275;
var statearr_14369_14486 = state_14275__$1;
(statearr_14369_14486[(2)] = inst_14060);

(statearr_14369_14486[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (57))){
var inst_14154 = (state_14275[(31)]);
var inst_14164 = (state_14275[(42)]);
var inst_14153 = (state_14275[(43)]);
var inst_14174 = (state_14275[(11)]);
var inst_14178 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_14174,inst_14153,inst_14154,inst_14164);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(59),inst_14178);
} else {
if((state_val_14276 === (68))){
var inst_14216 = (state_14275[(60)]);
var state_14275__$1 = state_14275;
var statearr_14370_14487 = state_14275__$1;
(statearr_14370_14487[(2)] = inst_14216);

(statearr_14370_14487[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (11))){
var inst_14058 = (state_14275[(58)]);
var state_14275__$1 = state_14275;
var statearr_14372_14488 = state_14275__$1;
(statearr_14372_14488[(2)] = inst_14058);

(statearr_14372_14488[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (9))){
var inst_14068 = (state_14275[(2)]);
var inst_14069 = fluree.db.util.async.throw_err(inst_14068);
var state_14275__$1 = state_14275;
var statearr_14373_14489 = state_14275__$1;
(statearr_14373_14489[(2)] = inst_14069);

(statearr_14373_14489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (5))){
var _ = (function (){var statearr_14374 = state_14275;
(statearr_14374[(4)] = cljs.core.rest((state_14275[(4)])));

return statearr_14374;
})();
var state_14275__$1 = state_14275;
var ex14371 = (state_14275__$1[(2)]);
var statearr_14375_14490 = state_14275__$1;
(statearr_14375_14490[(5)] = ex14371);


if((ex14371 instanceof Error)){
var statearr_14376_14491 = state_14275__$1;
(statearr_14376_14491[(1)] = (4));

(statearr_14376_14491[(5)] = null);

} else {
throw ex14371;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (83))){
var inst_14258 = (state_14275[(2)]);
var inst_14259 = cljs.core.not(inst_14258);
var state_14275__$1 = state_14275;
if(inst_14259){
var statearr_14377_14492 = state_14275__$1;
(statearr_14377_14492[(1)] = (87));

} else {
var statearr_14378_14493 = state_14275__$1;
(statearr_14378_14493[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (14))){
var inst_14053 = (state_14275[(50)]);
var inst_14084 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14053);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(17),inst_14084);
} else {
if((state_val_14276 === (45))){
var inst_14133 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14379_14494 = state_14275__$1;
(statearr_14379_14494[(2)] = inst_14133);

(statearr_14379_14494[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (53))){
var state_14275__$1 = state_14275;
var statearr_14380_14495 = state_14275__$1;
(statearr_14380_14495[(2)] = true);

(statearr_14380_14495[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (78))){
var inst_14208 = (state_14275[(52)]);
var state_14275__$1 = state_14275;
var statearr_14381_14496 = state_14275__$1;
(statearr_14381_14496[(2)] = inst_14208);

(statearr_14381_14496[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (26))){
var inst_14052 = (state_14275[(19)]);
var state_14275__$1 = state_14275;
var statearr_14382_14497 = state_14275__$1;
(statearr_14382_14497[(2)] = inst_14052);

(statearr_14382_14497[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (16))){
var inst_14060 = (state_14275[(59)]);
var inst_14090 = (state_14275[(2)]);
var inst_14091 = fluree.db.util.core.pred_ident_QMARK_(inst_14060);
var state_14275__$1 = (function (){var statearr_14383 = state_14275;
(statearr_14383[(36)] = inst_14090);

return statearr_14383;
})();
if(inst_14091){
var statearr_14384_14498 = state_14275__$1;
(statearr_14384_14498[(1)] = (18));

} else {
var statearr_14385_14499 = state_14275__$1;
(statearr_14385_14499[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (81))){
var inst_14137 = (state_14275[(15)]);
var inst_14190 = (state_14275[(7)]);
var inst_14147 = (state_14275[(27)]);
var inst_14250 = (state_14275[(48)]);
var inst_14249 = (inst_14147.cljs$core$IFn$_invoke$arity$2 ? inst_14147.cljs$core$IFn$_invoke$arity$2(inst_14190,inst_14137) : inst_14147.call(null,inst_14190,inst_14137));
var inst_14250__$1 = (inst_14249 < (0));
var state_14275__$1 = (function (){var statearr_14386 = state_14275;
(statearr_14386[(48)] = inst_14250__$1);

return statearr_14386;
})();
if(cljs.core.truth_(inst_14250__$1)){
var statearr_14387_14500 = state_14275__$1;
(statearr_14387_14500[(1)] = (84));

} else {
var statearr_14388_14501 = state_14275__$1;
(statearr_14388_14501[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (79))){
var inst_14208 = (state_14275[(52)]);
var inst_14214 = (state_14275[(13)]);
var inst_14234 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_14208,inst_14214);
var state_14275__$1 = state_14275;
var statearr_14389_14502 = state_14275__$1;
(statearr_14389_14502[(2)] = inst_14234);

(statearr_14389_14502[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (38))){
var state_14275__$1 = state_14275;
var statearr_14390_14503 = state_14275__$1;
(statearr_14390_14503[(2)] = (2147483647));

(statearr_14390_14503[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (87))){
var inst_14246 = (state_14275[(8)]);
var state_14275__$1 = state_14275;
var statearr_14391_14504 = state_14275__$1;
(statearr_14391_14504[(2)] = inst_14246);

(statearr_14391_14504[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (30))){
var inst_14113 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
if(cljs.core.truth_(inst_14113)){
var statearr_14392_14505 = state_14275__$1;
(statearr_14392_14505[(1)] = (31));

} else {
var statearr_14393_14506 = state_14275__$1;
(statearr_14393_14506[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (73))){
var inst_14242 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14394_14507 = state_14275__$1;
(statearr_14394_14507[(2)] = inst_14242);

(statearr_14394_14507[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (10))){
var inst_14058 = (state_14275[(58)]);
var inst_14075 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14058);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(13),inst_14075);
} else {
if((state_val_14276 === (18))){
var inst_14060 = (state_14275[(59)]);
var inst_14093 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14060);
var state_14275__$1 = state_14275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14275__$1,(21),inst_14093);
} else {
if((state_val_14276 === (52))){
var inst_14143 = (state_14275[(25)]);
var inst_14081 = (state_14275[(28)]);
var inst_14072 = (state_14275[(34)]);
var inst_14117 = (state_14275[(41)]);
var inst_14108 = (state_14275[(45)]);
var inst_14157 = fluree.db.permissions_validate.no_filter_QMARK_(inst_14143,inst_14072,inst_14081,inst_14108,inst_14117);
var state_14275__$1 = state_14275;
var statearr_14395_14508 = state_14275__$1;
(statearr_14395_14508[(2)] = inst_14157);

(statearr_14395_14508[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (67))){
var inst_14244 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14396_14509 = state_14275__$1;
(statearr_14396_14509[(2)] = inst_14244);

(statearr_14396_14509[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (71))){
var inst_14208 = (state_14275[(52)]);
var inst_14176 = (state_14275[(30)]);
var inst_14223 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14208,inst_14176);
var state_14275__$1 = state_14275;
var statearr_14397_14510 = state_14275__$1;
(statearr_14397_14510[(2)] = inst_14223);

(statearr_14397_14510[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (42))){
var inst_14099 = (state_14275[(21)]);
var inst_14081 = (state_14275[(28)]);
var inst_14062 = (state_14275[(29)]);
var inst_14054 = (state_14275[(32)]);
var inst_14126 = (state_14275[(33)]);
var inst_14072 = (state_14275[(34)]);
var inst_14090 = (state_14275[(36)]);
var inst_14061 = (state_14275[(38)]);
var inst_14055 = (state_14275[(40)]);
var inst_14117 = (state_14275[(41)]);
var inst_14138 = (state_14275[(49)]);
var inst_14135 = (state_14275[(44)]);
var inst_14108 = (state_14275[(45)]);
var inst_14135__$1 = (state_14275[(2)]);
var inst_14136 = fluree.db.flake.__GT_Flake(inst_14072,inst_14108,inst_14090,inst_14054,inst_14055,inst_14126);
var inst_14137 = fluree.db.flake.__GT_Flake(inst_14081,inst_14117,inst_14099,inst_14061,inst_14062,inst_14135__$1);
var inst_14138__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14275__$1 = (function (){var statearr_14398 = state_14275;
(statearr_14398[(15)] = inst_14137);

(statearr_14398[(49)] = inst_14138__$1);

(statearr_14398[(44)] = inst_14135__$1);

(statearr_14398[(17)] = inst_14136);

return statearr_14398;
})();
if(cljs.core.truth_(inst_14138__$1)){
var statearr_14399_14511 = state_14275__$1;
(statearr_14399_14511[(1)] = (46));

} else {
var statearr_14400_14512 = state_14275__$1;
(statearr_14400_14512[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (80))){
var inst_14236 = (state_14275[(2)]);
var state_14275__$1 = state_14275;
var statearr_14401_14513 = state_14275__$1;
(statearr_14401_14513[(2)] = inst_14236);

(statearr_14401_14513[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (37))){
var state_14275__$1 = state_14275;
var statearr_14402_14514 = state_14275__$1;
(statearr_14402_14514[(2)] = fluree.db.util.core.min_integer);

(statearr_14402_14514[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (63))){
var inst_14142 = (state_14275[(24)]);
var inst_14176 = (state_14275[(30)]);
var inst_14189 = (state_14275[(12)]);
var inst_14175 = (state_14275[(39)]);
var inst_14192 = (inst_14142 - inst_14175);
var inst_14193 = fluree.db.flake.take(inst_14192,inst_14189);
var inst_14194 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14193,inst_14176);
var state_14275__$1 = state_14275;
var statearr_14403_14515 = state_14275__$1;
(statearr_14403_14515[(2)] = inst_14194);

(statearr_14403_14515[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (8))){
var inst_14058 = (state_14275[(58)]);
var inst_14072 = (state_14275[(2)]);
var inst_14073 = fluree.db.util.core.pred_ident_QMARK_(inst_14058);
var state_14275__$1 = (function (){var statearr_14404 = state_14275;
(statearr_14404[(34)] = inst_14072);

return statearr_14404;
})();
if(inst_14073){
var statearr_14405_14516 = state_14275__$1;
(statearr_14405_14516[(1)] = (10));

} else {
var statearr_14406_14517 = state_14275__$1;
(statearr_14406_14517[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (49))){
var inst_14148 = (state_14275[(51)]);
var state_14275__$1 = state_14275;
var statearr_14407_14518 = state_14275__$1;
(statearr_14407_14518[(2)] = inst_14148);

(statearr_14407_14518[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14276 === (84))){
var inst_14142 = (state_14275[(24)]);
var inst_14247 = (state_14275[(9)]);
var inst_14252 = (inst_14247 < inst_14142);
var state_14275__$1 = state_14275;
var statearr_14408_14519 = state_14275__$1;
(statearr_14408_14519[(2)] = inst_14252);

(statearr_14408_14519[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_14409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14409[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_14409[(1)] = (1));

return statearr_14409;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_14275){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_14275);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e14410){var ex__2736__auto__ = e14410;
var statearr_14411_14520 = state_14275;
(statearr_14411_14520[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_14275[(4)]))){
var statearr_14412_14521 = state_14275;
(statearr_14412_14521[(1)] = cljs.core.first((state_14275[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14522 = state_14275;
state_14275 = G__14522;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_14275){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_14275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_14413 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_14413[(6)] = c__2755__auto__);

return statearr_14413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_14597){
var state_val_14598 = (state_14597[(1)]);
if((state_val_14598 === (7))){
var inst_14592 = (state_14597[(2)]);
var _ = (function (){var statearr_14599 = state_14597;
(statearr_14599[(4)] = cljs.core.rest((state_14597[(4)])));

return statearr_14599;
})();
var state_14597__$1 = state_14597;
var statearr_14600_14640 = state_14597__$1;
(statearr_14600_14640[(2)] = inst_14592);

(statearr_14600_14640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (20))){
var inst_14574 = (state_14597[(2)]);
var inst_14575 = fluree.db.util.async.throw_err(inst_14574);
var state_14597__$1 = state_14597;
var statearr_14601_14641 = state_14597__$1;
(statearr_14601_14641[(2)] = inst_14575);

(statearr_14601_14641[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (1))){
var state_14597__$1 = state_14597;
var statearr_14602_14642 = state_14597__$1;
(statearr_14602_14642[(2)] = null);

(statearr_14602_14642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (4))){
var inst_14523 = (state_14597[(2)]);
var state_14597__$1 = state_14597;
var statearr_14603_14643 = state_14597__$1;
(statearr_14603_14643[(2)] = inst_14523);

(statearr_14603_14643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (15))){
var inst_14570 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14597__$1 = state_14597;
if(cljs.core.truth_(inst_14570)){
var statearr_14604_14644 = state_14597__$1;
(statearr_14604_14644[(1)] = (17));

} else {
var statearr_14605_14645 = state_14597__$1;
(statearr_14605_14645[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (21))){
var state_14597__$1 = state_14597;
var statearr_14606_14646 = state_14597__$1;
(statearr_14606_14646[(2)] = (0));

(statearr_14606_14646[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (13))){
var inst_14562 = (state_14597[(2)]);
var state_14597__$1 = state_14597;
var statearr_14607_14647 = state_14597__$1;
(statearr_14607_14647[(2)] = inst_14562);

(statearr_14607_14647[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (22))){
var state_14597__$1 = state_14597;
var statearr_14608_14648 = state_14597__$1;
(statearr_14608_14648[(2)] = (1));

(statearr_14608_14648[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (6))){
var inst_14552 = (state_14597[(7)]);
var inst_14543 = (state_14597[(8)]);
var inst_14554 = (state_14597[(9)]);
var inst_14551 = cljs.core.seq(inst_14543);
var inst_14552__$1 = cljs.core.first(inst_14551);
var inst_14553 = cljs.core.next(inst_14551);
var inst_14554__$1 = (inst_14552__$1 == null);
var state_14597__$1 = (function (){var statearr_14609 = state_14597;
(statearr_14609[(7)] = inst_14552__$1);

(statearr_14609[(10)] = inst_14553);

(statearr_14609[(9)] = inst_14554__$1);

return statearr_14609;
})();
if(cljs.core.truth_(inst_14554__$1)){
var statearr_14610_14649 = state_14597__$1;
(statearr_14610_14649[(1)] = (8));

} else {
var statearr_14611_14650 = state_14597__$1;
(statearr_14611_14650[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (17))){
var inst_14552 = (state_14597[(7)]);
var inst_14572 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_14552);
var state_14597__$1 = state_14597;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14597__$1,(20),inst_14572);
} else {
if((state_val_14598 === (3))){
var inst_14595 = (state_14597[(2)]);
var state_14597__$1 = state_14597;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14597__$1,inst_14595);
} else {
if((state_val_14598 === (12))){
var inst_14545 = (state_14597[(11)]);
var inst_14560 = (inst_14545 >= subject_limit);
var state_14597__$1 = state_14597;
var statearr_14612_14651 = state_14597__$1;
(statearr_14612_14651[(2)] = inst_14560);

(statearr_14612_14651[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (2))){
var _ = (function (){var statearr_14613 = state_14597;
(statearr_14613[(4)] = cljs.core.cons((5),(state_14597[(4)])));

return statearr_14613;
})();
var inst_14536 = subject_groups;
var inst_14537 = cljs.core.seq(inst_14536);
var inst_14538 = cljs.core.first(inst_14537);
var inst_14539 = cljs.core.next(inst_14537);
var inst_14540 = flake_start;
var inst_14541 = subject_start;
var inst_14542 = cljs.core.PersistentVector.EMPTY;
var inst_14543 = inst_14536;
var inst_14544 = inst_14540;
var inst_14545 = inst_14541;
var inst_14546 = inst_14542;
var state_14597__$1 = (function (){var statearr_14614 = state_14597;
(statearr_14614[(11)] = inst_14545);

(statearr_14614[(12)] = inst_14544);

(statearr_14614[(8)] = inst_14543);

(statearr_14614[(13)] = inst_14539);

(statearr_14614[(14)] = inst_14546);

(statearr_14614[(15)] = inst_14538);

return statearr_14614;
})();
var statearr_14615_14652 = state_14597__$1;
(statearr_14615_14652[(2)] = null);

(statearr_14615_14652[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (23))){
var inst_14545 = (state_14597[(11)]);
var inst_14544 = (state_14597[(12)]);
var inst_14579 = (state_14597[(16)]);
var inst_14553 = (state_14597[(10)]);
var inst_14578 = (state_14597[(17)]);
var inst_14546 = (state_14597[(14)]);
var inst_14584 = (state_14597[(2)]);
var inst_14585 = (inst_14544 + inst_14579);
var inst_14586 = (inst_14545 + inst_14584);
var inst_14587 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14546,inst_14578);
var inst_14543 = inst_14553;
var inst_14544__$1 = inst_14585;
var inst_14545__$1 = inst_14586;
var inst_14546__$1 = inst_14587;
var state_14597__$1 = (function (){var statearr_14616 = state_14597;
(statearr_14616[(11)] = inst_14545__$1);

(statearr_14616[(12)] = inst_14544__$1);

(statearr_14616[(8)] = inst_14543);

(statearr_14616[(14)] = inst_14546__$1);

return statearr_14616;
})();
var statearr_14617_14653 = state_14597__$1;
(statearr_14617_14653[(2)] = null);

(statearr_14617_14653[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (19))){
var inst_14579 = (state_14597[(16)]);
var inst_14578 = (state_14597[(17)]);
var inst_14578__$1 = (state_14597[(2)]);
var inst_14579__$1 = cljs.core.count(inst_14578__$1);
var inst_14580 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14579__$1);
var state_14597__$1 = (function (){var statearr_14618 = state_14597;
(statearr_14618[(16)] = inst_14579__$1);

(statearr_14618[(17)] = inst_14578__$1);

return statearr_14618;
})();
if(inst_14580){
var statearr_14619_14654 = state_14597__$1;
(statearr_14619_14654[(1)] = (21));

} else {
var statearr_14620_14655 = state_14597__$1;
(statearr_14620_14655[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (11))){
var inst_14557 = (state_14597[(18)]);
var state_14597__$1 = state_14597;
var statearr_14622_14656 = state_14597__$1;
(statearr_14622_14656[(2)] = inst_14557);

(statearr_14622_14656[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (9))){
var inst_14557 = (state_14597[(18)]);
var inst_14544 = (state_14597[(12)]);
var inst_14557__$1 = (inst_14544 >= flake_limit);
var state_14597__$1 = (function (){var statearr_14623 = state_14597;
(statearr_14623[(18)] = inst_14557__$1);

return statearr_14623;
})();
if(cljs.core.truth_(inst_14557__$1)){
var statearr_14624_14657 = state_14597__$1;
(statearr_14624_14657[(1)] = (11));

} else {
var statearr_14625_14658 = state_14597__$1;
(statearr_14625_14658[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (5))){
var _ = (function (){var statearr_14626 = state_14597;
(statearr_14626[(4)] = cljs.core.rest((state_14597[(4)])));

return statearr_14626;
})();
var state_14597__$1 = state_14597;
var ex14621 = (state_14597__$1[(2)]);
var statearr_14627_14659 = state_14597__$1;
(statearr_14627_14659[(5)] = ex14621);


if((ex14621 instanceof Error)){
var statearr_14628_14660 = state_14597__$1;
(statearr_14628_14660[(1)] = (4));

(statearr_14628_14660[(5)] = null);

} else {
throw ex14621;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (14))){
var inst_14545 = (state_14597[(11)]);
var inst_14544 = (state_14597[(12)]);
var inst_14546 = (state_14597[(14)]);
var inst_14566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14567 = [inst_14544,inst_14545,inst_14546];
var inst_14568 = (new cljs.core.PersistentVector(null,3,(5),inst_14566,inst_14567,null));
var state_14597__$1 = state_14597;
var statearr_14629_14661 = state_14597__$1;
(statearr_14629_14661[(2)] = inst_14568);

(statearr_14629_14661[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (16))){
var inst_14590 = (state_14597[(2)]);
var state_14597__$1 = state_14597;
var statearr_14630_14662 = state_14597__$1;
(statearr_14630_14662[(2)] = inst_14590);

(statearr_14630_14662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (10))){
var inst_14564 = (state_14597[(2)]);
var state_14597__$1 = state_14597;
if(cljs.core.truth_(inst_14564)){
var statearr_14631_14663 = state_14597__$1;
(statearr_14631_14663[(1)] = (14));

} else {
var statearr_14632_14664 = state_14597__$1;
(statearr_14632_14664[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (18))){
var inst_14552 = (state_14597[(7)]);
var state_14597__$1 = state_14597;
var statearr_14633_14665 = state_14597__$1;
(statearr_14633_14665[(2)] = inst_14552);

(statearr_14633_14665[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14598 === (8))){
var inst_14554 = (state_14597[(9)]);
var state_14597__$1 = state_14597;
var statearr_14634_14666 = state_14597__$1;
(statearr_14634_14666[(2)] = inst_14554);

(statearr_14634_14666[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____0 = (function (){
var statearr_14635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14635[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__);

(statearr_14635[(1)] = (1));

return statearr_14635;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____1 = (function (state_14597){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_14597);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e14636){var ex__2736__auto__ = e14636;
var statearr_14637_14667 = state_14597;
(statearr_14637_14667[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_14597[(4)]))){
var statearr_14638_14668 = state_14597;
(statearr_14638_14668[(1)] = cljs.core.first((state_14597[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14669 = state_14597;
state_14597 = G__14669;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__ = function(state_14597){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____1.call(this,state_14597);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_14639 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_14639[(6)] = c__2755__auto__);

return statearr_14639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_14715){
var state_val_14716 = (state_14715[(1)]);
if((state_val_14716 === (7))){
var state_14715__$1 = state_14715;
var statearr_14717_14755 = state_14715__$1;
(statearr_14717_14755[(2)] = null);

(statearr_14717_14755[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (20))){
var inst_14701 = (state_14715[(2)]);
var inst_14702 = fluree.db.util.async.throw_err(inst_14701);
var inst_14680 = inst_14702;
var state_14715__$1 = (function (){var statearr_14718 = state_14715;
(statearr_14718[(7)] = inst_14680);

return statearr_14718;
})();
var statearr_14719_14756 = state_14715__$1;
(statearr_14719_14756[(2)] = null);

(statearr_14719_14756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (1))){
var state_14715__$1 = state_14715;
var statearr_14720_14757 = state_14715__$1;
(statearr_14720_14757[(2)] = null);

(statearr_14720_14757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (4))){
var inst_14670 = (state_14715[(2)]);
var state_14715__$1 = state_14715;
var statearr_14721_14758 = state_14715__$1;
(statearr_14721_14758[(2)] = inst_14670);

(statearr_14721_14758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (15))){
var inst_14697 = (state_14715[(8)]);
var inst_14680 = (state_14715[(7)]);
var inst_14697__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14680);
var state_14715__$1 = (function (){var statearr_14722 = state_14715;
(statearr_14722[(8)] = inst_14697__$1);

return statearr_14722;
})();
if(cljs.core.truth_(inst_14697__$1)){
var statearr_14723_14759 = state_14715__$1;
(statearr_14723_14759[(1)] = (17));

} else {
var statearr_14724_14760 = state_14715__$1;
(statearr_14724_14760[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (13))){
var inst_14690 = (state_14715[(2)]);
var inst_14691 = fluree.db.util.async.throw_err(inst_14690);
var _ = (function (){var statearr_14725 = state_14715;
(statearr_14725[(4)] = cljs.core.rest((state_14715[(4)])));

return statearr_14725;
})();
var state_14715__$1 = state_14715;
var statearr_14726_14761 = state_14715__$1;
(statearr_14726_14761[(2)] = inst_14691);

(statearr_14726_14761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (6))){
var inst_14678 = (state_14715[(2)]);
var inst_14679 = fluree.db.util.async.throw_err(inst_14678);
var inst_14680 = inst_14679;
var state_14715__$1 = (function (){var statearr_14727 = state_14715;
(statearr_14727[(7)] = inst_14680);

return statearr_14727;
})();
var statearr_14728_14762 = state_14715__$1;
(statearr_14728_14762[(2)] = null);

(statearr_14728_14762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (17))){
var inst_14697 = (state_14715[(8)]);
var inst_14699 = fluree.db.dbproto._lookup_leaf(root_node,inst_14697);
var state_14715__$1 = state_14715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14715__$1,(20),inst_14699);
} else {
if((state_val_14716 === (3))){
var inst_14713 = (state_14715[(2)]);
var state_14715__$1 = state_14715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14715__$1,inst_14713);
} else {
if((state_val_14716 === (12))){
var _ = (function (){var statearr_14730 = state_14715;
(statearr_14730[(4)] = cljs.core.rest((state_14715[(4)])));

return statearr_14730;
})();
var state_14715__$1 = state_14715;
var ex14729 = (state_14715__$1[(2)]);
var statearr_14731_14763 = state_14715__$1;
(statearr_14731_14763[(5)] = ex14729);


var statearr_14732_14764 = state_14715__$1;
(statearr_14732_14764[(1)] = (11));

(statearr_14732_14764[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (2))){
var _ = (function (){var statearr_14733 = state_14715;
(statearr_14733[(4)] = cljs.core.cons((5),(state_14715[(4)])));

return statearr_14733;
})();
var inst_14676 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_14715__$1 = state_14715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14715__$1,(6),inst_14676);
} else {
if((state_val_14716 === (19))){
var inst_14706 = (state_14715[(2)]);
var state_14715__$1 = state_14715;
var statearr_14734_14765 = state_14715__$1;
(statearr_14734_14765[(2)] = inst_14706);

(statearr_14734_14765[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (11))){
var inst_14682 = (state_14715[(2)]);
var state_14715__$1 = (function (){var statearr_14736 = state_14715;
(statearr_14736[(9)] = inst_14682);

return statearr_14736;
})();
var statearr_14737_14766 = state_14715__$1;
(statearr_14737_14766[(2)] = null);

(statearr_14737_14766[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (9))){
var inst_14680 = (state_14715[(7)]);
var _ = (function (){var statearr_14738 = state_14715;
(statearr_14738[(4)] = cljs.core.cons((12),(state_14715[(4)])));

return statearr_14738;
})();
var inst_14688 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_14680,t,novelty,fast_forward_db_QMARK_);
var state_14715__$1 = state_14715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14715__$1,(13),inst_14688);
} else {
if((state_val_14716 === (5))){
var _ = (function (){var statearr_14739 = state_14715;
(statearr_14739[(4)] = cljs.core.rest((state_14715[(4)])));

return statearr_14739;
})();
var state_14715__$1 = state_14715;
var ex14735 = (state_14715__$1[(2)]);
var statearr_14740_14767 = state_14715__$1;
(statearr_14740_14767[(5)] = ex14735);


if((ex14735 instanceof Error)){
var statearr_14741_14768 = state_14715__$1;
(statearr_14741_14768[(1)] = (4));

(statearr_14741_14768[(5)] = null);

} else {
throw ex14735;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (14))){
var inst_14694 = (state_14715[(10)]);
var state_14715__$1 = state_14715;
var statearr_14742_14769 = state_14715__$1;
(statearr_14742_14769[(2)] = inst_14694);

(statearr_14742_14769[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (16))){
var inst_14708 = (state_14715[(2)]);
var state_14715__$1 = state_14715;
var statearr_14743_14770 = state_14715__$1;
(statearr_14743_14770[(2)] = inst_14708);

(statearr_14743_14770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (10))){
var inst_14694 = (state_14715[(10)]);
var inst_14694__$1 = (state_14715[(2)]);
var state_14715__$1 = (function (){var statearr_14744 = state_14715;
(statearr_14744[(10)] = inst_14694__$1);

return statearr_14744;
})();
if(cljs.core.truth_(inst_14694__$1)){
var statearr_14745_14771 = state_14715__$1;
(statearr_14745_14771[(1)] = (14));

} else {
var statearr_14746_14772 = state_14715__$1;
(statearr_14746_14772[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (18))){
var state_14715__$1 = state_14715;
var statearr_14747_14773 = state_14715__$1;
(statearr_14747_14773[(2)] = null);

(statearr_14747_14773[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14716 === (8))){
var inst_14710 = (state_14715[(2)]);
var _ = (function (){var statearr_14748 = state_14715;
(statearr_14748[(4)] = cljs.core.rest((state_14715[(4)])));

return statearr_14748;
})();
var state_14715__$1 = state_14715;
var statearr_14749_14774 = state_14715__$1;
(statearr_14749_14774[(2)] = inst_14710);

(statearr_14749_14774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____0 = (function (){
var statearr_14750 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14750[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__);

(statearr_14750[(1)] = (1));

return statearr_14750;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____1 = (function (state_14715){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_14715);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e14751){var ex__2736__auto__ = e14751;
var statearr_14752_14775 = state_14715;
(statearr_14752_14775[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_14715[(4)]))){
var statearr_14753_14776 = state_14715;
(statearr_14753_14776[(1)] = cljs.core.first((state_14715[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14777 = state_14715;
state_14715 = G__14777;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__ = function(state_14715){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____1.call(this,state_14715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_14754 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_14754[(6)] = c__2755__auto__);

return statearr_14754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14784 = arguments.length;
switch (G__14784) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14785 = (function (){var pred__14788 = cljs.core.identical_QMARK_;
var expr__14789 = test;
if(cljs.core.truth_((pred__14788.cljs$core$IFn$_invoke$arity$2 ? pred__14788.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14789) : pred__14788.call(null,cljs.core._EQ_,expr__14789)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14788.cljs$core$IFn$_invoke$arity$2 ? pred__14788.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14789) : pred__14788.call(null,cljs.core._LT_,expr__14789)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14788.cljs$core$IFn$_invoke$arity$2 ? pred__14788.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14789) : pred__14788.call(null,cljs.core._LT__EQ_,expr__14789)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14788.cljs$core$IFn$_invoke$arity$2 ? pred__14788.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14789) : pred__14788.call(null,cljs.core._GT_,expr__14789)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14788.cljs$core$IFn$_invoke$arity$2 ? pred__14788.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14789) : pred__14788.call(null,cljs.core._GT__EQ_,expr__14789)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14789)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14785,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14785,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14785,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14785,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15161){
var state_val_15162 = (state_15161[(1)]);
if((state_val_15162 === (121))){
var inst_15117 = (state_15161[(7)]);
var state_15161__$1 = state_15161;
var statearr_15163_15359 = state_15161__$1;
(statearr_15163_15359[(2)] = inst_15117);

(statearr_15163_15359[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (65))){
var inst_14969 = (state_15161[(8)]);
var inst_14975 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15164 = state_15161;
(statearr_15164[(9)] = inst_14975);

return statearr_15164;
})();
if(cljs.core.truth_(inst_14969)){
var statearr_15165_15360 = state_15161__$1;
(statearr_15165_15360[(1)] = (66));

} else {
var statearr_15166_15361 = state_15161__$1;
(statearr_15166_15361[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (70))){
var inst_15153 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15167_15362 = state_15161__$1;
(statearr_15167_15362[(2)] = inst_15153);

(statearr_15167_15362[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (62))){
var inst_14968 = (state_15161[(2)]);
var inst_14969 = fluree.db.util.async.throw_err(inst_14968);
var inst_14970 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_15161__$1 = (function (){var statearr_15168 = state_15161;
(statearr_15168[(8)] = inst_14969);

return statearr_15168;
})();
if(cljs.core.truth_(inst_14970)){
var statearr_15169_15363 = state_15161__$1;
(statearr_15169_15363[(1)] = (63));

} else {
var statearr_15170_15364 = state_15161__$1;
(statearr_15170_15364[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (74))){
var inst_14950 = (state_15161[(10)]);
var inst_14823 = (state_15161[(11)]);
var inst_14847 = (state_15161[(12)]);
var inst_14879 = (state_15161[(13)]);
var inst_14937 = (state_15161[(14)]);
var inst_14919 = (state_15161[(15)]);
var inst_14939 = (state_15161[(16)]);
var inst_14949 = (state_15161[(17)]);
var inst_14883 = (state_15161[(18)]);
var inst_14954 = (state_15161[(19)]);
var inst_14892 = (state_15161[(20)]);
var inst_14827 = (state_15161[(21)]);
var inst_14982 = (state_15161[(22)]);
var inst_14901 = (state_15161[(23)]);
var inst_14955 = (state_15161[(24)]);
var inst_14828 = (state_15161[(25)]);
var inst_14938 = (state_15161[(26)]);
var inst_14826 = (state_15161[(27)]);
var inst_14988 = (state_15161[(28)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_14975 = (state_15161[(9)]);
var inst_14880 = (state_15161[(31)]);
var inst_14996 = (state_15161[(32)]);
var inst_14979 = (state_15161[(33)]);
var inst_14969 = (state_15161[(8)]);
var inst_14815 = (state_15161[(34)]);
var inst_14816 = (state_15161[(35)]);
var inst_14978 = (state_15161[(36)]);
var inst_14981 = (state_15161[(37)]);
var inst_14960 = (state_15161[(38)]);
var inst_14811 = (state_15161[(39)]);
var inst_14928 = (state_15161[(40)]);
var inst_14838 = (state_15161[(41)]);
var inst_14822 = (state_15161[(42)]);
var inst_14910 = (state_15161[(43)]);
var inst_14965 = (state_15161[(44)]);
var inst_14959 = (state_15161[(45)]);
var inst_14941 = (state_15161[(46)]);
var inst_14818 = (state_15161[(47)]);
var inst_14948 = (state_15161[(48)]);
var inst_14998 = (function (){var no_filter_QMARK_ = inst_14975;
var t = inst_14955;
var max_limit_QMARK_ = inst_14949;
var next_node = inst_14978;
var fast_forward_db_QMARK_ = inst_14960;
var s1 = inst_14838;
var o2 = inst_14901;
var t1 = inst_14815;
var predicate_fn = inst_14828;
var i = inst_14980;
var m1 = inst_14928;
var root_node = inst_14965;
var s2 = inst_14847;
var p2 = inst_14919;
var vec__14804 = inst_14879;
var permissions = inst_14950;
var vec__14800 = inst_14818;
var limit = inst_14948;
var start_flake = inst_14938;
var flake_limit = inst_14942;
var vec__14797 = inst_14811;
var offset = inst_14979;
var acc = inst_14982;
var t2 = inst_14822;
var op1 = inst_14816;
var o1 = inst_14892;
var end_flake = inst_14939;
var base_result = inst_14988;
var s = inst_14981;
var node_start = inst_14969;
var vec__14807 = inst_14880;
var p1 = inst_14910;
var map__14810 = inst_14941;
var subject_fn = inst_14827;
var map__14803 = inst_14826;
var object_fn = inst_14883;
var idx_compare = inst_14954;
var G__14989 = inst_14996;
var op2 = inst_14823;
var m2 = inst_14937;
var novelty = inst_14959;
return (function (p1__14779_SHARP_){
var G__15171 = p1__14779_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__15171) : subject_fn.call(null,G__15171));
});
})();
var inst_14999 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14998,inst_14996);
var state_15161__$1 = state_15161;
var statearr_15172_15365 = state_15161__$1;
(statearr_15172_15365[(2)] = inst_14999);

(statearr_15172_15365[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (110))){
var inst_15130 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15173_15366 = state_15161__$1;
(statearr_15173_15366[(2)] = inst_15130);

(statearr_15173_15366[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (7))){
var inst_14812 = (state_15161[(49)]);
var state_15161__$1 = state_15161;
var statearr_15174_15367 = state_15161__$1;
(statearr_15174_15367[(2)] = inst_14812);

(statearr_15174_15367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (59))){
var state_15161__$1 = state_15161;
var statearr_15175_15368 = state_15161__$1;
(statearr_15175_15368[(2)] = fluree.db.util.core.max_long);

(statearr_15175_15368[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (86))){
var inst_14975 = (state_15161[(9)]);
var state_15161__$1 = state_15161;
var statearr_15176_15369 = state_15161__$1;
(statearr_15176_15369[(2)] = inst_14975);

(statearr_15176_15369[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (20))){
var state_15161__$1 = state_15161;
var statearr_15177_15370 = state_15161__$1;
(statearr_15177_15370[(2)] = null);

(statearr_15177_15370[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (72))){
var inst_14988 = (state_15161[(28)]);
var state_15161__$1 = state_15161;
var statearr_15178_15371 = state_15161__$1;
(statearr_15178_15371[(2)] = inst_14988);

(statearr_15178_15371[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (58))){
var inst_14943 = (state_15161[(50)]);
var state_15161__$1 = state_15161;
var statearr_15179_15372 = state_15161__$1;
(statearr_15179_15372[(2)] = inst_14943);

(statearr_15179_15372[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (60))){
var inst_14948 = (state_15161[(48)]);
var inst_14948__$1 = (state_15161[(2)]);
var inst_14949 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14948__$1,fluree.db.util.core.max_long);
var inst_14950 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14952 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14953 = (new cljs.core.PersistentVector(null,3,(5),inst_14951,inst_14952,null));
var inst_14954 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14953);
var inst_14955 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14957 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14958 = (new cljs.core.PersistentVector(null,2,(5),inst_14956,inst_14957,null));
var inst_14959 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14958);
var inst_14960 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14961 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14962 = fluree.db.dbproto._resolve(inst_14961);
var state_15161__$1 = (function (){var statearr_15180 = state_15161;
(statearr_15180[(10)] = inst_14950);

(statearr_15180[(17)] = inst_14949);

(statearr_15180[(19)] = inst_14954);

(statearr_15180[(24)] = inst_14955);

(statearr_15180[(38)] = inst_14960);

(statearr_15180[(45)] = inst_14959);

(statearr_15180[(48)] = inst_14948__$1);

return statearr_15180;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(61),inst_14962);
} else {
if((state_val_15162 === (27))){
var inst_14881 = (state_15161[(51)]);
var state_15161__$1 = state_15161;
var statearr_15181_15373 = state_15161__$1;
(statearr_15181_15373[(2)] = inst_14881);

(statearr_15181_15373[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (1))){
var state_15161__$1 = state_15161;
var statearr_15182_15374 = state_15161__$1;
(statearr_15182_15374[(2)] = null);

(statearr_15182_15374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (69))){
var inst_14939 = (state_15161[(16)]);
var inst_14938 = (state_15161[(26)]);
var inst_14978 = (state_15161[(36)]);
var inst_14987 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14978);
var inst_14988 = fluree.db.flake.subrange(inst_14987,start_test,inst_14938,end_test,inst_14939);
var inst_14990 = fluree.db.query.range.value_with_nil_pred(idx,inst_14938,inst_14939);
var state_15161__$1 = (function (){var statearr_15183 = state_15161;
(statearr_15183[(28)] = inst_14988);

return statearr_15183;
})();
if(inst_14990){
var statearr_15184_15375 = state_15161__$1;
(statearr_15184_15375[(1)] = (71));

} else {
var statearr_15185_15376 = state_15161__$1;
(statearr_15185_15376[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (101))){
var inst_14942 = (state_15161[(30)]);
var inst_15076 = (state_15161[(52)]);
var inst_15074 = (state_15161[(53)]);
var inst_15075 = (state_15161[(54)]);
var inst_15079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15080 = (inst_15076 - inst_14942);
var inst_15081 = (inst_15075 - inst_15080);
var inst_15082 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15081,inst_15074);
var inst_15083 = [inst_14942,inst_15082];
var inst_15084 = (new cljs.core.PersistentVector(null,2,(5),inst_15079,inst_15083,null));
var state_15161__$1 = state_15161;
var statearr_15186_15377 = state_15161__$1;
(statearr_15186_15377[(2)] = inst_15084);

(statearr_15186_15377[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (24))){
var inst_14813 = (state_15161[(55)]);
var inst_14814 = (state_15161[(56)]);
var inst_14820 = (state_15161[(57)]);
var inst_14823 = (state_15161[(11)]);
var inst_14847 = (state_15161[(12)]);
var inst_14827 = (state_15161[(21)]);
var inst_14828 = (state_15161[(25)]);
var inst_14826 = (state_15161[(27)]);
var inst_14829 = (state_15161[(58)]);
var inst_14861 = (state_15161[(59)]);
var inst_14817 = (state_15161[(60)]);
var inst_14815 = (state_15161[(34)]);
var inst_14821 = (state_15161[(61)]);
var inst_14816 = (state_15161[(35)]);
var inst_14824 = (state_15161[(62)]);
var inst_14811 = (state_15161[(39)]);
var inst_14838 = (state_15161[(41)]);
var inst_14822 = (state_15161[(42)]);
var inst_14818 = (state_15161[(47)]);
var inst_14871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14873 = [null,null];
var inst_14874 = (new cljs.core.PersistentVector(null,2,(5),inst_14872,inst_14873,null));
var inst_14875 = (function (){var bool = inst_14861;
var s1 = inst_14838;
var o2 = inst_14821;
var t1 = inst_14815;
var predicate_fn = inst_14828;
var m1 = inst_14817;
var s2 = inst_14847;
var p2 = inst_14820;
var vec__14800 = inst_14818;
var vec__14797 = inst_14811;
var t2 = inst_14822;
var op1 = inst_14816;
var o1 = inst_14814;
var p1 = inst_14813;
var subject_fn = inst_14827;
var map__14803 = inst_14826;
var object_fn = inst_14829;
var op2 = inst_14823;
var m2 = inst_14824;
var temp__5755__auto__ = inst_14861;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_14876 = [inst_14874,inst_14875];
var inst_14877 = (new cljs.core.PersistentVector(null,2,(5),inst_14871,inst_14876,null));
var state_15161__$1 = state_15161;
var statearr_15187_15378 = state_15161__$1;
(statearr_15187_15378[(2)] = inst_14877);

(statearr_15187_15378[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (102))){
var inst_15076 = (state_15161[(52)]);
var inst_15074 = (state_15161[(53)]);
var inst_15086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15087 = [inst_15076,inst_15074];
var inst_15088 = (new cljs.core.PersistentVector(null,2,(5),inst_15086,inst_15087,null));
var state_15161__$1 = state_15161;
var statearr_15188_15379 = state_15161__$1;
(statearr_15188_15379[(2)] = inst_15088);

(statearr_15188_15379[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (55))){
var state_15161__$1 = state_15161;
var statearr_15189_15380 = state_15161__$1;
(statearr_15189_15380[(2)] = (2147483647));

(statearr_15189_15380[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (85))){
var inst_15024 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
if(cljs.core.truth_(inst_15024)){
var statearr_15190_15381 = state_15161__$1;
(statearr_15190_15381[(1)] = (89));

} else {
var statearr_15191_15382 = state_15161__$1;
(statearr_15191_15382[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (39))){
var inst_14820 = (state_15161[(57)]);
var inst_14911 = (state_15161[(63)]);
var inst_14910 = (state_15161[(2)]);
var inst_14911__$1 = (inst_14820 == null);
var state_15161__$1 = (function (){var statearr_15192 = state_15161;
(statearr_15192[(63)] = inst_14911__$1);

(statearr_15192[(43)] = inst_14910);

return statearr_15192;
})();
if(cljs.core.truth_(inst_14911__$1)){
var statearr_15193_15383 = state_15161__$1;
(statearr_15193_15383[(1)] = (40));

} else {
var statearr_15194_15384 = state_15161__$1;
(statearr_15194_15384[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (88))){
var inst_15021 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15195_15385 = state_15161__$1;
(statearr_15195_15385[(2)] = inst_15021);

(statearr_15195_15385[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (46))){
var inst_14817 = (state_15161[(60)]);
var state_15161__$1 = state_15161;
var statearr_15196_15386 = state_15161__$1;
(statearr_15196_15386[(2)] = inst_14817);

(statearr_15196_15386[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (4))){
var inst_14791 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15197_15387 = state_15161__$1;
(statearr_15197_15387[(2)] = inst_14791);

(statearr_15197_15387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (77))){
var inst_14950 = (state_15161[(10)]);
var inst_14823 = (state_15161[(11)]);
var inst_14847 = (state_15161[(12)]);
var inst_14879 = (state_15161[(13)]);
var inst_14937 = (state_15161[(14)]);
var inst_14919 = (state_15161[(15)]);
var inst_14939 = (state_15161[(16)]);
var inst_14949 = (state_15161[(17)]);
var inst_14883 = (state_15161[(18)]);
var inst_14954 = (state_15161[(19)]);
var inst_14892 = (state_15161[(20)]);
var inst_14827 = (state_15161[(21)]);
var inst_14982 = (state_15161[(22)]);
var inst_14901 = (state_15161[(23)]);
var inst_14955 = (state_15161[(24)]);
var inst_14828 = (state_15161[(25)]);
var inst_14938 = (state_15161[(26)]);
var inst_14826 = (state_15161[(27)]);
var inst_14988 = (state_15161[(28)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_14975 = (state_15161[(9)]);
var inst_14880 = (state_15161[(31)]);
var inst_14979 = (state_15161[(33)]);
var inst_14969 = (state_15161[(8)]);
var inst_14815 = (state_15161[(34)]);
var inst_14816 = (state_15161[(35)]);
var inst_14978 = (state_15161[(36)]);
var inst_14981 = (state_15161[(37)]);
var inst_14960 = (state_15161[(38)]);
var inst_14811 = (state_15161[(39)]);
var inst_14928 = (state_15161[(40)]);
var inst_15002 = (state_15161[(64)]);
var inst_14838 = (state_15161[(41)]);
var inst_14822 = (state_15161[(42)]);
var inst_14910 = (state_15161[(43)]);
var inst_14965 = (state_15161[(44)]);
var inst_14959 = (state_15161[(45)]);
var inst_14941 = (state_15161[(46)]);
var inst_14818 = (state_15161[(47)]);
var inst_14948 = (state_15161[(48)]);
var inst_15004 = (function (){var no_filter_QMARK_ = inst_14975;
var t = inst_14955;
var max_limit_QMARK_ = inst_14949;
var next_node = inst_14978;
var fast_forward_db_QMARK_ = inst_14960;
var s1 = inst_14838;
var o2 = inst_14901;
var t1 = inst_14815;
var predicate_fn = inst_14828;
var i = inst_14980;
var m1 = inst_14928;
var root_node = inst_14965;
var s2 = inst_14847;
var p2 = inst_14919;
var vec__14804 = inst_14879;
var permissions = inst_14950;
var vec__14800 = inst_14818;
var limit = inst_14948;
var start_flake = inst_14938;
var flake_limit = inst_14942;
var vec__14797 = inst_14811;
var offset = inst_14979;
var acc = inst_14982;
var t2 = inst_14822;
var op1 = inst_14816;
var o1 = inst_14892;
var end_flake = inst_14939;
var base_result = inst_14988;
var s = inst_14981;
var node_start = inst_14969;
var vec__14807 = inst_14880;
var p1 = inst_14910;
var map__14810 = inst_14941;
var subject_fn = inst_14827;
var map__14803 = inst_14826;
var object_fn = inst_14883;
var idx_compare = inst_14954;
var G__14989 = inst_15002;
var op2 = inst_14823;
var m2 = inst_14937;
var novelty = inst_14959;
return (function (p1__14780_SHARP_){
var G__15198 = p1__14780_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__15198) : predicate_fn.call(null,G__15198));
});
})();
var inst_15005 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15004,inst_15002);
var state_15161__$1 = state_15161;
var statearr_15199_15388 = state_15161__$1;
(statearr_15199_15388[(2)] = inst_15005);

(statearr_15199_15388[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (106))){
var inst_15015 = (state_15161[(65)]);
var state_15161__$1 = state_15161;
var statearr_15200_15389 = state_15161__$1;
(statearr_15200_15389[(2)] = inst_15015);

(statearr_15200_15389[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (119))){
var inst_15133 = (state_15161[(66)]);
var state_15161__$1 = state_15161;
var statearr_15201_15390 = state_15161__$1;
(statearr_15201_15390[(2)] = inst_15133);

(statearr_15201_15390[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (95))){
var inst_15048 = (state_15161[(67)]);
var inst_15057 = (state_15161[(68)]);
var inst_15058 = (state_15161[(69)]);
var inst_14981 = (state_15161[(37)]);
var inst_15056 = (state_15161[(70)]);
var inst_14948 = (state_15161[(48)]);
var inst_15056__$1 = cljs.core.count(inst_15048);
var inst_15057__$1 = (inst_14981 + inst_15056__$1);
var inst_15058__$1 = (inst_15057__$1 - inst_14948);
var inst_15059 = cljs.core.pos_int_QMARK_(inst_15058__$1);
var state_15161__$1 = (function (){var statearr_15202 = state_15161;
(statearr_15202[(68)] = inst_15057__$1);

(statearr_15202[(69)] = inst_15058__$1);

(statearr_15202[(70)] = inst_15056__$1);

return statearr_15202;
})();
if(inst_15059){
var statearr_15203_15391 = state_15161__$1;
(statearr_15203_15391[(1)] = (98));

} else {
var statearr_15204_15392 = state_15161__$1;
(statearr_15204_15392[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (54))){
var inst_14823 = (state_15161[(11)]);
var inst_14847 = (state_15161[(12)]);
var inst_14943 = (state_15161[(50)]);
var inst_14937 = (state_15161[(14)]);
var inst_14919 = (state_15161[(15)]);
var inst_14892 = (state_15161[(20)]);
var inst_14901 = (state_15161[(23)]);
var inst_14815 = (state_15161[(34)]);
var inst_14816 = (state_15161[(35)]);
var inst_14928 = (state_15161[(40)]);
var inst_14838 = (state_15161[(41)]);
var inst_14822 = (state_15161[(42)]);
var inst_14910 = (state_15161[(43)]);
var inst_14941 = (state_15161[(46)]);
var inst_14937__$1 = (state_15161[(2)]);
var inst_14938 = fluree.db.flake.__GT_Flake(inst_14838,inst_14910,inst_14892,inst_14815,inst_14816,inst_14928);
var inst_14939 = fluree.db.flake.__GT_Flake(inst_14847,inst_14919,inst_14901,inst_14822,inst_14823,inst_14937__$1);
var inst_14940 = opts;
var inst_14941__$1 = cljs.core.__destructure_map(inst_14940);
var inst_14942 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14941__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14943__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14941__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14944 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14941__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_15161__$1 = (function (){var statearr_15205 = state_15161;
(statearr_15205[(50)] = inst_14943__$1);

(statearr_15205[(14)] = inst_14937__$1);

(statearr_15205[(16)] = inst_14939);

(statearr_15205[(71)] = inst_14944);

(statearr_15205[(26)] = inst_14938);

(statearr_15205[(30)] = inst_14942);

(statearr_15205[(46)] = inst_14941__$1);

return statearr_15205;
})();
if(cljs.core.truth_(inst_14943__$1)){
var statearr_15206_15393 = state_15161__$1;
(statearr_15206_15393[(1)] = (58));

} else {
var statearr_15207_15394 = state_15161__$1;
(statearr_15207_15394[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (92))){
var inst_14982 = (state_15161[(22)]);
var inst_14980 = (state_15161[(29)]);
var inst_14979 = (state_15161[(33)]);
var inst_15037 = (state_15161[(72)]);
var inst_14981 = (state_15161[(37)]);
var inst_15040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15041 = (inst_14979 - inst_15037);
var inst_15042 = [inst_15041,inst_14980,inst_14981,inst_14982];
var inst_15043 = (new cljs.core.PersistentVector(null,4,(5),inst_15040,inst_15042,null));
var state_15161__$1 = state_15161;
var statearr_15208_15395 = state_15161__$1;
(statearr_15208_15395[(2)] = inst_15043);

(statearr_15208_15395[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (104))){
var inst_15099 = (state_15161[(2)]);
var inst_15100 = fluree.db.util.async.throw_err(inst_15099);
var state_15161__$1 = state_15161;
var statearr_15209_15396 = state_15161__$1;
(statearr_15209_15396[(2)] = inst_15100);

(statearr_15209_15396[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (15))){
var inst_14821 = (state_15161[(61)]);
var inst_14851 = cljs.core.boolean_QMARK_(inst_14821);
var state_15161__$1 = state_15161;
if(inst_14851){
var statearr_15210_15397 = state_15161__$1;
(statearr_15210_15397[(1)] = (17));

} else {
var statearr_15211_15398 = state_15161__$1;
(statearr_15211_15398[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (48))){
var inst_14824 = (state_15161[(62)]);
var inst_14928 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15212 = state_15161;
(statearr_15212[(40)] = inst_14928);

return statearr_15212;
})();
if(cljs.core.truth_(inst_14824)){
var statearr_15213_15399 = state_15161__$1;
(statearr_15213_15399[(1)] = (52));

} else {
var statearr_15214_15400 = state_15161__$1;
(statearr_15214_15400[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (50))){
var state_15161__$1 = state_15161;
var statearr_15215_15401 = state_15161__$1;
(statearr_15215_15401[(2)] = (2147483647));

(statearr_15215_15401[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (116))){
var inst_15133 = (state_15161[(66)]);
var inst_15141 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15216 = state_15161;
(statearr_15216[(73)] = inst_15141);

return statearr_15216;
})();
if(cljs.core.truth_(inst_15133)){
var statearr_15217_15402 = state_15161__$1;
(statearr_15217_15402[(1)] = (118));

} else {
var statearr_15218_15403 = state_15161__$1;
(statearr_15218_15403[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (75))){
var inst_14996 = (state_15161[(32)]);
var state_15161__$1 = state_15161;
var statearr_15219_15404 = state_15161__$1;
(statearr_15219_15404[(2)] = inst_14996);

(statearr_15219_15404[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (99))){
var inst_15057 = (state_15161[(68)]);
var inst_15066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15067 = [inst_15057,inst_15057];
var inst_15068 = (new cljs.core.PersistentVector(null,2,(5),inst_15066,inst_15067,null));
var state_15161__$1 = state_15161;
var statearr_15220_15405 = state_15161__$1;
(statearr_15220_15405[(2)] = inst_15068);

(statearr_15220_15405[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (21))){
var state_15161__$1 = state_15161;
var statearr_15221_15406 = state_15161__$1;
(statearr_15221_15406[(2)] = null);

(statearr_15221_15406[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (31))){
var inst_14882 = (state_15161[(74)]);
var state_15161__$1 = state_15161;
var statearr_15222_15407 = state_15161__$1;
(statearr_15222_15407[(2)] = inst_14882);

(statearr_15222_15407[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (113))){
var inst_15127 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15223_15408 = state_15161__$1;
(statearr_15223_15408[(2)] = inst_15127);

(statearr_15223_15408[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (32))){
var inst_14813 = (state_15161[(55)]);
var inst_14902 = (state_15161[(75)]);
var inst_14901 = (state_15161[(2)]);
var inst_14902__$1 = (inst_14813 == null);
var state_15161__$1 = (function (){var statearr_15224 = state_15161;
(statearr_15224[(23)] = inst_14901);

(statearr_15224[(75)] = inst_14902__$1);

return statearr_15224;
})();
if(cljs.core.truth_(inst_14902__$1)){
var statearr_15225_15409 = state_15161__$1;
(statearr_15225_15409[(1)] = (34));

} else {
var statearr_15226_15410 = state_15161__$1;
(statearr_15226_15410[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (40))){
var inst_14901 = (state_15161[(23)]);
var state_15161__$1 = state_15161;
var statearr_15227_15411 = state_15161__$1;
(statearr_15227_15411[(2)] = inst_14901);

(statearr_15227_15411[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (91))){
var inst_15015 = (state_15161[(65)]);
var inst_15113 = (state_15161[(2)]);
var inst_15114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15113,(0),null);
var inst_15115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15113,(1),null);
var inst_15116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15113,(2),null);
var inst_15117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15113,(3),null);
var state_15161__$1 = (function (){var statearr_15228 = state_15161;
(statearr_15228[(7)] = inst_15117);

(statearr_15228[(76)] = inst_15116);

(statearr_15228[(77)] = inst_15114);

(statearr_15228[(78)] = inst_15115);

return statearr_15228;
})();
if(cljs.core.truth_(inst_15015)){
var statearr_15229_15412 = state_15161__$1;
(statearr_15229_15412[(1)] = (105));

} else {
var statearr_15230_15413 = state_15161__$1;
(statearr_15230_15413[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (117))){
var inst_15137 = (state_15161[(2)]);
var inst_15138 = fluree.db.util.async.throw_err(inst_15137);
var state_15161__$1 = state_15161;
var statearr_15231_15414 = state_15161__$1;
(statearr_15231_15414[(2)] = inst_15138);

(statearr_15231_15414[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (108))){
var inst_15122 = (state_15161[(79)]);
var inst_14942 = (state_15161[(30)]);
var inst_15115 = (state_15161[(78)]);
var inst_15122__$1 = (inst_15115 < inst_14942);
var state_15161__$1 = (function (){var statearr_15232 = state_15161;
(statearr_15232[(79)] = inst_15122__$1);

return statearr_15232;
})();
if(cljs.core.truth_(inst_15122__$1)){
var statearr_15233_15415 = state_15161__$1;
(statearr_15233_15415[(1)] = (111));

} else {
var statearr_15234_15416 = state_15161__$1;
(statearr_15234_15416[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (56))){
var state_15161__$1 = state_15161;
var statearr_15235_15417 = state_15161__$1;
(statearr_15235_15417[(2)] = fluree.db.util.core.min_integer);

(statearr_15235_15417[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (33))){
var inst_14897 = (state_15161[(2)]);
var inst_14898 = fluree.db.util.async.throw_err(inst_14897);
var state_15161__$1 = state_15161;
var statearr_15236_15418 = state_15161__$1;
(statearr_15236_15418[(2)] = inst_14898);

(statearr_15236_15418[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (13))){
var inst_14843 = (state_15161[(2)]);
var inst_14844 = fluree.db.util.async.throw_err(inst_14843);
var state_15161__$1 = state_15161;
var statearr_15237_15419 = state_15161__$1;
(statearr_15237_15419[(2)] = inst_14844);

(statearr_15237_15419[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (22))){
var inst_14857 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15238_15420 = state_15161__$1;
(statearr_15238_15420[(2)] = inst_14857);

(statearr_15238_15420[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (90))){
var inst_15014 = (state_15161[(80)]);
var inst_14950 = (state_15161[(10)]);
var inst_14823 = (state_15161[(11)]);
var inst_14847 = (state_15161[(12)]);
var inst_14879 = (state_15161[(13)]);
var inst_14937 = (state_15161[(14)]);
var inst_14919 = (state_15161[(15)]);
var inst_14939 = (state_15161[(16)]);
var inst_14949 = (state_15161[(17)]);
var inst_15015 = (state_15161[(65)]);
var inst_14883 = (state_15161[(18)]);
var inst_14954 = (state_15161[(19)]);
var inst_14892 = (state_15161[(20)]);
var inst_14827 = (state_15161[(21)]);
var inst_14982 = (state_15161[(22)]);
var inst_14901 = (state_15161[(23)]);
var inst_14955 = (state_15161[(24)]);
var inst_14828 = (state_15161[(25)]);
var inst_14938 = (state_15161[(26)]);
var inst_14826 = (state_15161[(27)]);
var inst_14988 = (state_15161[(28)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_14975 = (state_15161[(9)]);
var inst_14880 = (state_15161[(31)]);
var inst_14979 = (state_15161[(33)]);
var inst_14969 = (state_15161[(8)]);
var inst_14815 = (state_15161[(34)]);
var inst_15037 = (state_15161[(72)]);
var inst_14816 = (state_15161[(35)]);
var inst_14978 = (state_15161[(36)]);
var inst_14981 = (state_15161[(37)]);
var inst_14960 = (state_15161[(38)]);
var inst_14811 = (state_15161[(39)]);
var inst_14928 = (state_15161[(40)]);
var inst_14838 = (state_15161[(41)]);
var inst_14822 = (state_15161[(42)]);
var inst_15036 = (state_15161[(81)]);
var inst_14910 = (state_15161[(43)]);
var inst_14965 = (state_15161[(44)]);
var inst_14959 = (state_15161[(45)]);
var inst_14941 = (state_15161[(46)]);
var inst_14818 = (state_15161[(47)]);
var inst_14948 = (state_15161[(48)]);
var inst_15035 = (function (){var no_filter_QMARK_ = inst_14975;
var base_result_SINGLEQUOTE_ = inst_15014;
var t = inst_14955;
var max_limit_QMARK_ = inst_14949;
var next_node = inst_14978;
var fast_forward_db_QMARK_ = inst_14960;
var s1 = inst_14838;
var o2 = inst_14901;
var t1 = inst_14815;
var predicate_fn = inst_14828;
var i = inst_14980;
var rhs = inst_15015;
var m1 = inst_14928;
var root_node = inst_14965;
var s2 = inst_14847;
var p2 = inst_14919;
var vec__14804 = inst_14879;
var permissions = inst_14950;
var vec__14800 = inst_14818;
var limit = inst_14948;
var start_flake = inst_14938;
var flake_limit = inst_14942;
var vec__14797 = inst_14811;
var offset = inst_14979;
var acc = inst_14982;
var t2 = inst_14822;
var op1 = inst_14816;
var o1 = inst_14892;
var end_flake = inst_14939;
var base_result = inst_14988;
var s = inst_14981;
var node_start = inst_14969;
var vec__14807 = inst_14880;
var p1 = inst_14910;
var map__14810 = inst_14941;
var subject_fn = inst_14827;
var map__14803 = inst_14826;
var object_fn = inst_14883;
var idx_compare = inst_14954;
var op2 = inst_14823;
var m2 = inst_14937;
var novelty = inst_14959;
return (function (p1__14782_SHARP_){
return p1__14782_SHARP_.s;
});
})();
var inst_15036__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_15035,inst_15014);
var inst_15037__$1 = cljs.core.count(inst_15036__$1);
var inst_15038 = (inst_14979 > inst_15037__$1);
var state_15161__$1 = (function (){var statearr_15239 = state_15161;
(statearr_15239[(72)] = inst_15037__$1);

(statearr_15239[(81)] = inst_15036__$1);

return statearr_15239;
})();
if(cljs.core.truth_(inst_15038)){
var statearr_15240_15421 = state_15161__$1;
(statearr_15240_15421[(1)] = (92));

} else {
var statearr_15241_15422 = state_15161__$1;
(statearr_15241_15422[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (109))){
var inst_15120 = (state_15161[(82)]);
var state_15161__$1 = state_15161;
var statearr_15242_15423 = state_15161__$1;
(statearr_15242_15423[(2)] = inst_15120);

(statearr_15242_15423[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (36))){
var inst_14906 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
if(cljs.core.truth_(inst_14906)){
var statearr_15243_15424 = state_15161__$1;
(statearr_15243_15424[(1)] = (37));

} else {
var statearr_15244_15425 = state_15161__$1;
(statearr_15244_15425[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (41))){
var inst_14911 = (state_15161[(63)]);
var state_15161__$1 = state_15161;
var statearr_15245_15426 = state_15161__$1;
(statearr_15245_15426[(2)] = inst_14911);

(statearr_15245_15426[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (118))){
var inst_15141 = (state_15161[(73)]);
var state_15161__$1 = state_15161;
var statearr_15246_15427 = state_15161__$1;
(statearr_15246_15427[(2)] = inst_15141);

(statearr_15246_15427[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (89))){
var inst_15014 = (state_15161[(80)]);
var inst_14982 = (state_15161[(22)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_14981 = (state_15161[(37)]);
var inst_15026 = cljs.core.count(inst_15014);
var inst_15027 = (inst_14942 - inst_14980);
var inst_15028 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15027,inst_15014);
var inst_15029 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14982,inst_15028);
var inst_15030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15031 = (inst_14980 + inst_15026);
var inst_15032 = [(0),inst_15031,inst_14981,inst_15029];
var inst_15033 = (new cljs.core.PersistentVector(null,4,(5),inst_15030,inst_15032,null));
var state_15161__$1 = state_15161;
var statearr_15247_15428 = state_15161__$1;
(statearr_15247_15428[(2)] = inst_15033);

(statearr_15247_15428[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (100))){
var inst_15048 = (state_15161[(67)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_15076 = (state_15161[(52)]);
var inst_15074 = (state_15161[(53)]);
var inst_15075 = (state_15161[(54)]);
var inst_15070 = (state_15161[(2)]);
var inst_15071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15070,(0),null);
var inst_15072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15070,(1),null);
var inst_15073 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_15072,inst_15048);
var inst_15074__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_15073);
var inst_15075__$1 = cljs.core.count(inst_15074__$1);
var inst_15076__$1 = (inst_14980 + inst_15075__$1);
var inst_15077 = (inst_15076__$1 > inst_14942);
var state_15161__$1 = (function (){var statearr_15248 = state_15161;
(statearr_15248[(83)] = inst_15071);

(statearr_15248[(52)] = inst_15076__$1);

(statearr_15248[(53)] = inst_15074__$1);

(statearr_15248[(54)] = inst_15075__$1);

return statearr_15248;
})();
if(cljs.core.truth_(inst_15077)){
var statearr_15249_15429 = state_15161__$1;
(statearr_15249_15429[(1)] = (101));

} else {
var statearr_15250_15430 = state_15161__$1;
(statearr_15250_15430[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (122))){
var inst_15141 = (state_15161[(73)]);
var inst_15117 = (state_15161[(7)]);
var inst_15116 = (state_15161[(76)]);
var inst_15114 = (state_15161[(77)]);
var inst_15115 = (state_15161[(78)]);
var inst_14978 = inst_15141;
var inst_14979 = inst_15114;
var inst_14980 = inst_15115;
var inst_14981 = inst_15116;
var inst_14982 = inst_15117;
var state_15161__$1 = (function (){var statearr_15251 = state_15161;
(statearr_15251[(22)] = inst_14982);

(statearr_15251[(29)] = inst_14980);

(statearr_15251[(33)] = inst_14979);

(statearr_15251[(36)] = inst_14978);

(statearr_15251[(37)] = inst_14981);

return statearr_15251;
})();
var statearr_15252_15431 = state_15161__$1;
(statearr_15252_15431[(2)] = null);

(statearr_15252_15431[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (43))){
var state_15161__$1 = state_15161;
var statearr_15253_15432 = state_15161__$1;
(statearr_15253_15432[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_15253_15432[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (61))){
var inst_14955 = (state_15161[(24)]);
var inst_14938 = (state_15161[(26)]);
var inst_14960 = (state_15161[(38)]);
var inst_14965 = (state_15161[(44)]);
var inst_14959 = (state_15161[(45)]);
var inst_14964 = (state_15161[(2)]);
var inst_14965__$1 = fluree.db.util.async.throw_err(inst_14964);
var inst_14966 = fluree.db.query.range.find_next_valid_node(inst_14965__$1,inst_14938,inst_14955,inst_14959,inst_14960);
var state_15161__$1 = (function (){var statearr_15254 = state_15161;
(statearr_15254[(44)] = inst_14965__$1);

return statearr_15254;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(62),inst_14966);
} else {
if((state_val_15162 === (29))){
var inst_14888 = (state_15161[(2)]);
var inst_14889 = fluree.db.util.async.throw_err(inst_14888);
var state_15161__$1 = state_15161;
var statearr_15255_15433 = state_15161__$1;
(statearr_15255_15433[(2)] = inst_14889);

(statearr_15255_15433[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (44))){
var inst_14820 = (state_15161[(57)]);
var state_15161__$1 = state_15161;
var statearr_15256_15434 = state_15161__$1;
(statearr_15256_15434[(2)] = inst_14820);

(statearr_15256_15434[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (93))){
var inst_14975 = (state_15161[(9)]);
var inst_14979 = (state_15161[(33)]);
var inst_15036 = (state_15161[(81)]);
var inst_15048 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_14979,inst_15036);
var state_15161__$1 = (function (){var statearr_15257 = state_15161;
(statearr_15257[(67)] = inst_15048);

return statearr_15257;
})();
if(cljs.core.truth_(inst_14975)){
var statearr_15258_15435 = state_15161__$1;
(statearr_15258_15435[(1)] = (95));

} else {
var statearr_15259_15436 = state_15161__$1;
(statearr_15259_15436[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (6))){
var inst_14812 = (state_15161[(49)]);
var inst_14832 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14812);
var state_15161__$1 = state_15161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(9),inst_14832);
} else {
if((state_val_15162 === (111))){
var inst_15116 = (state_15161[(76)]);
var inst_14948 = (state_15161[(48)]);
var inst_15124 = (inst_15116 < inst_14948);
var state_15161__$1 = state_15161;
var statearr_15260_15437 = state_15161__$1;
(statearr_15260_15437[(2)] = inst_15124);

(statearr_15260_15437[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (28))){
var inst_14882 = (state_15161[(74)]);
var inst_14892 = (state_15161[(2)]);
var inst_14893 = fluree.db.util.core.pred_ident_QMARK_(inst_14882);
var state_15161__$1 = (function (){var statearr_15261 = state_15161;
(statearr_15261[(20)] = inst_14892);

return statearr_15261;
})();
if(inst_14893){
var statearr_15262_15438 = state_15161__$1;
(statearr_15262_15438[(1)] = (30));

} else {
var statearr_15263_15439 = state_15161__$1;
(statearr_15263_15439[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (64))){
var state_15161__$1 = state_15161;
var statearr_15264_15440 = state_15161__$1;
(statearr_15264_15440[(2)] = true);

(statearr_15264_15440[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (103))){
var inst_15071 = (state_15161[(83)]);
var inst_15090 = (state_15161[(2)]);
var inst_15091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15090,(0),null);
var inst_15092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15090,(1),null);
var inst_15093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15094 = [inst_15091,inst_15071,inst_15092];
var inst_15095 = (new cljs.core.PersistentVector(null,3,(5),inst_15093,inst_15094,null));
var state_15161__$1 = state_15161;
var statearr_15265_15441 = state_15161__$1;
(statearr_15265_15441[(2)] = inst_15095);

(statearr_15265_15441[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (51))){
var inst_14926 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15266_15442 = state_15161__$1;
(statearr_15266_15442[(2)] = inst_14926);

(statearr_15266_15442[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (25))){
var inst_14879 = (state_15161[(13)]);
var inst_14880 = (state_15161[(31)]);
var inst_14881 = (state_15161[(51)]);
var inst_14879__$1 = (state_15161[(2)]);
var inst_14880__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14879__$1,(0),null);
var inst_14881__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14880__$1,(0),null);
var inst_14882 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14880__$1,(1),null);
var inst_14883 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14879__$1,(1),null);
var inst_14884 = fluree.db.util.core.pred_ident_QMARK_(inst_14881__$1);
var state_15161__$1 = (function (){var statearr_15267 = state_15161;
(statearr_15267[(13)] = inst_14879__$1);

(statearr_15267[(18)] = inst_14883);

(statearr_15267[(74)] = inst_14882);

(statearr_15267[(31)] = inst_14880__$1);

(statearr_15267[(51)] = inst_14881__$1);

return statearr_15267;
})();
if(inst_14884){
var statearr_15268_15443 = state_15161__$1;
(statearr_15268_15443[(1)] = (26));

} else {
var statearr_15269_15444 = state_15161__$1;
(statearr_15269_15444[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (34))){
var inst_14892 = (state_15161[(20)]);
var state_15161__$1 = state_15161;
var statearr_15270_15445 = state_15161__$1;
(statearr_15270_15445[(2)] = inst_14892);

(statearr_15270_15445[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (17))){
var inst_14821 = (state_15161[(61)]);
var state_15161__$1 = state_15161;
var statearr_15271_15446 = state_15161__$1;
(statearr_15271_15446[(2)] = inst_14821);

(statearr_15271_15446[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (3))){
var inst_15159 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15161__$1,inst_15159);
} else {
if((state_val_15162 === (12))){
var inst_14814 = (state_15161[(56)]);
var inst_14847 = (state_15161[(2)]);
var inst_14848 = cljs.core.boolean_QMARK_(inst_14814);
var state_15161__$1 = (function (){var statearr_15272 = state_15161;
(statearr_15272[(12)] = inst_14847);

return statearr_15272;
})();
if(inst_14848){
var statearr_15273_15447 = state_15161__$1;
(statearr_15273_15447[(1)] = (14));

} else {
var statearr_15274_15448 = state_15161__$1;
(statearr_15274_15448[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (2))){
var inst_14812 = (state_15161[(49)]);
var inst_14826 = (state_15161[(27)]);
var inst_14811 = (state_15161[(39)]);
var inst_14818 = (state_15161[(47)]);
var _ = (function (){var statearr_15275 = state_15161;
(statearr_15275[(4)] = cljs.core.cons((5),(state_15161[(4)])));

return statearr_15275;
})();
var inst_14811__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14812__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14811__$1,(0),null);
var inst_14813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14811__$1,(1),null);
var inst_14814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14811__$1,(2),null);
var inst_14815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14811__$1,(3),null);
var inst_14816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14811__$1,(4),null);
var inst_14817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14811__$1,(5),null);
var inst_14818__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14818__$1,(0),null);
var inst_14820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14818__$1,(1),null);
var inst_14821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14818__$1,(2),null);
var inst_14822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14818__$1,(3),null);
var inst_14823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14818__$1,(4),null);
var inst_14824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14818__$1,(5),null);
var inst_14825 = opts;
var inst_14826__$1 = cljs.core.__destructure_map(inst_14825);
var inst_14827 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14826__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14828 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14826__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14826__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14830 = fluree.db.util.core.pred_ident_QMARK_(inst_14812__$1);
var state_15161__$1 = (function (){var statearr_15276 = state_15161;
(statearr_15276[(55)] = inst_14813);

(statearr_15276[(56)] = inst_14814);

(statearr_15276[(57)] = inst_14820);

(statearr_15276[(11)] = inst_14823);

(statearr_15276[(84)] = inst_14819);

(statearr_15276[(21)] = inst_14827);

(statearr_15276[(49)] = inst_14812__$1);

(statearr_15276[(25)] = inst_14828);

(statearr_15276[(27)] = inst_14826__$1);

(statearr_15276[(58)] = inst_14829);

(statearr_15276[(60)] = inst_14817);

(statearr_15276[(34)] = inst_14815);

(statearr_15276[(61)] = inst_14821);

(statearr_15276[(35)] = inst_14816);

(statearr_15276[(62)] = inst_14824);

(statearr_15276[(39)] = inst_14811__$1);

(statearr_15276[(42)] = inst_14822);

(statearr_15276[(47)] = inst_14818__$1);

return statearr_15276;
})();
if(inst_14830){
var statearr_15277_15449 = state_15161__$1;
(statearr_15277_15449[(1)] = (6));

} else {
var statearr_15278_15450 = state_15161__$1;
(statearr_15278_15450[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (66))){
var inst_14944 = (state_15161[(71)]);
var inst_14969 = (state_15161[(8)]);
var inst_14977 = cljs.core.PersistentVector.EMPTY;
var inst_14978 = inst_14969;
var inst_14979 = inst_14944;
var inst_14980 = (0);
var inst_14981 = (0);
var inst_14982 = inst_14977;
var state_15161__$1 = (function (){var statearr_15279 = state_15161;
(statearr_15279[(22)] = inst_14982);

(statearr_15279[(29)] = inst_14980);

(statearr_15279[(33)] = inst_14979);

(statearr_15279[(36)] = inst_14978);

(statearr_15279[(37)] = inst_14981);

return statearr_15279;
})();
var statearr_15280_15451 = state_15161__$1;
(statearr_15280_15451[(2)] = null);

(statearr_15280_15451[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (107))){
var inst_15133 = (state_15161[(66)]);
var inst_15133__$1 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15281 = state_15161;
(statearr_15281[(66)] = inst_15133__$1);

return statearr_15281;
})();
if(cljs.core.truth_(inst_15133__$1)){
var statearr_15282_15452 = state_15161__$1;
(statearr_15282_15452[(1)] = (114));

} else {
var statearr_15283_15453 = state_15161__$1;
(statearr_15283_15453[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (23))){
var inst_14814 = (state_15161[(56)]);
var inst_14829 = (state_15161[(58)]);
var inst_14821 = (state_15161[(61)]);
var inst_14864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14866 = [inst_14814,inst_14821];
var inst_14867 = (new cljs.core.PersistentVector(null,2,(5),inst_14865,inst_14866,null));
var inst_14868 = [inst_14867,inst_14829];
var inst_14869 = (new cljs.core.PersistentVector(null,2,(5),inst_14864,inst_14868,null));
var state_15161__$1 = state_15161;
var statearr_15284_15454 = state_15161__$1;
(statearr_15284_15454[(2)] = inst_14869);

(statearr_15284_15454[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (47))){
var inst_14922 = (cljs.core._GT__EQ_ === start_test);
var state_15161__$1 = state_15161;
if(cljs.core.truth_(inst_14922)){
var statearr_15285_15455 = state_15161__$1;
(statearr_15285_15455[(1)] = (49));

} else {
var statearr_15286_15456 = state_15161__$1;
(statearr_15286_15456[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (35))){
var inst_14902 = (state_15161[(75)]);
var state_15161__$1 = state_15161;
var statearr_15287_15457 = state_15161__$1;
(statearr_15287_15457[(2)] = inst_14902);

(statearr_15287_15457[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (82))){
var inst_14949 = (state_15161[(17)]);
var inst_14978 = (state_15161[(36)]);
var inst_15014 = (state_15161[(2)]);
var inst_15015 = fluree.db.dbproto._rhs(inst_14978);
var state_15161__$1 = (function (){var statearr_15288 = state_15161;
(statearr_15288[(80)] = inst_15014);

(statearr_15288[(65)] = inst_15015);

return statearr_15288;
})();
if(cljs.core.truth_(inst_14949)){
var statearr_15289_15458 = state_15161__$1;
(statearr_15289_15458[(1)] = (83));

} else {
var statearr_15290_15459 = state_15161__$1;
(statearr_15290_15459[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (76))){
var inst_14828 = (state_15161[(25)]);
var inst_15002 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15291 = state_15161;
(statearr_15291[(64)] = inst_15002);

return statearr_15291;
})();
if(cljs.core.truth_(inst_14828)){
var statearr_15292_15460 = state_15161__$1;
(statearr_15292_15460[(1)] = (77));

} else {
var statearr_15293_15461 = state_15161__$1;
(statearr_15293_15461[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (97))){
var inst_14982 = (state_15161[(22)]);
var inst_15102 = (state_15161[(2)]);
var inst_15103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15102,(0),null);
var inst_15104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15102,(1),null);
var inst_15105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15102,(2),null);
var inst_15106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15107 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14982,inst_15105);
var inst_15108 = [(0),inst_15103,inst_15104,inst_15107];
var inst_15109 = (new cljs.core.PersistentVector(null,4,(5),inst_15106,inst_15108,null));
var state_15161__$1 = state_15161;
var statearr_15294_15462 = state_15161__$1;
(statearr_15294_15462[(2)] = inst_15109);

(statearr_15294_15462[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (19))){
var inst_14859 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15295_15463 = state_15161__$1;
(statearr_15295_15463[(2)] = inst_14859);

(statearr_15295_15463[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (57))){
var inst_14935 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15296_15464 = state_15161__$1;
(statearr_15296_15464[(2)] = inst_14935);

(statearr_15296_15464[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (68))){
var inst_15156 = (state_15161[(2)]);
var _ = (function (){var statearr_15297 = state_15161;
(statearr_15297[(4)] = cljs.core.rest((state_15161[(4)])));

return statearr_15297;
})();
var state_15161__$1 = state_15161;
var statearr_15298_15465 = state_15161__$1;
(statearr_15298_15465[(2)] = inst_15156);

(statearr_15298_15465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (11))){
var inst_14819 = (state_15161[(84)]);
var state_15161__$1 = state_15161;
var statearr_15299_15466 = state_15161__$1;
(statearr_15299_15466[(2)] = inst_14819);

(statearr_15299_15466[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (115))){
var state_15161__$1 = state_15161;
var statearr_15301_15467 = state_15161__$1;
(statearr_15301_15467[(2)] = null);

(statearr_15301_15467[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (9))){
var inst_14834 = (state_15161[(2)]);
var inst_14835 = fluree.db.util.async.throw_err(inst_14834);
var state_15161__$1 = state_15161;
var statearr_15302_15468 = state_15161__$1;
(statearr_15302_15468[(2)] = inst_14835);

(statearr_15302_15468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (5))){
var _ = (function (){var statearr_15303 = state_15161;
(statearr_15303[(4)] = cljs.core.rest((state_15161[(4)])));

return statearr_15303;
})();
var state_15161__$1 = state_15161;
var ex15300 = (state_15161__$1[(2)]);
var statearr_15304_15469 = state_15161__$1;
(statearr_15304_15469[(5)] = ex15300);


if((ex15300 instanceof Error)){
var statearr_15305_15470 = state_15161__$1;
(statearr_15305_15470[(1)] = (4));

(statearr_15305_15470[(5)] = null);

} else {
throw ex15300;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (112))){
var inst_15122 = (state_15161[(79)]);
var state_15161__$1 = state_15161;
var statearr_15306_15471 = state_15161__$1;
(statearr_15306_15471[(2)] = inst_15122);

(statearr_15306_15471[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (83))){
var inst_15017 = (state_15161[(85)]);
var inst_14979 = (state_15161[(33)]);
var inst_15017__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14979);
var state_15161__$1 = (function (){var statearr_15307 = state_15161;
(statearr_15307[(85)] = inst_15017__$1);

return statearr_15307;
})();
if(inst_15017__$1){
var statearr_15308_15472 = state_15161__$1;
(statearr_15308_15472[(1)] = (86));

} else {
var statearr_15309_15473 = state_15161__$1;
(statearr_15309_15473[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (14))){
var inst_14814 = (state_15161[(56)]);
var state_15161__$1 = state_15161;
var statearr_15310_15474 = state_15161__$1;
(statearr_15310_15474[(2)] = inst_14814);

(statearr_15310_15474[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (45))){
var inst_14817 = (state_15161[(60)]);
var inst_14919 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15311 = state_15161;
(statearr_15311[(15)] = inst_14919);

return statearr_15311;
})();
if(cljs.core.truth_(inst_14817)){
var statearr_15312_15475 = state_15161__$1;
(statearr_15312_15475[(1)] = (46));

} else {
var statearr_15313_15476 = state_15161__$1;
(statearr_15313_15476[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (53))){
var inst_14931 = (cljs.core._LT__EQ_ === end_test);
var state_15161__$1 = state_15161;
if(cljs.core.truth_(inst_14931)){
var statearr_15314_15477 = state_15161__$1;
(statearr_15314_15477[(1)] = (55));

} else {
var statearr_15315_15478 = state_15161__$1;
(statearr_15315_15478[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (78))){
var inst_15002 = (state_15161[(64)]);
var state_15161__$1 = state_15161;
var statearr_15316_15479 = state_15161__$1;
(statearr_15316_15479[(2)] = inst_15002);

(statearr_15316_15479[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (26))){
var inst_14881 = (state_15161[(51)]);
var inst_14886 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14881);
var state_15161__$1 = state_15161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(29),inst_14886);
} else {
if((state_val_15162 === (123))){
var inst_15151 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15317_15480 = state_15161__$1;
(statearr_15317_15480[(2)] = inst_15151);

(statearr_15317_15480[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (16))){
var inst_14861 = (state_15161[(59)]);
var inst_14861__$1 = (state_15161[(2)]);
var inst_14862 = (inst_14861__$1 == null);
var state_15161__$1 = (function (){var statearr_15318 = state_15161;
(statearr_15318[(59)] = inst_14861__$1);

return statearr_15318;
})();
if(cljs.core.truth_(inst_14862)){
var statearr_15319_15481 = state_15161__$1;
(statearr_15319_15481[(1)] = (23));

} else {
var statearr_15320_15482 = state_15161__$1;
(statearr_15320_15482[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (81))){
var inst_15008 = (state_15161[(86)]);
var state_15161__$1 = state_15161;
var statearr_15321_15483 = state_15161__$1;
(statearr_15321_15483[(2)] = inst_15008);

(statearr_15321_15483[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (120))){
var inst_15145 = (state_15161[(2)]);
var inst_15146 = cljs.core.not(inst_15145);
var state_15161__$1 = state_15161;
if(inst_15146){
var statearr_15322_15484 = state_15161__$1;
(statearr_15322_15484[(1)] = (121));

} else {
var statearr_15323_15485 = state_15161__$1;
(statearr_15323_15485[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (79))){
var inst_14883 = (state_15161[(18)]);
var inst_15008 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15324 = state_15161;
(statearr_15324[(86)] = inst_15008);

return statearr_15324;
})();
if(cljs.core.truth_(inst_14883)){
var statearr_15325_15486 = state_15161__$1;
(statearr_15325_15486[(1)] = (80));

} else {
var statearr_15326_15487 = state_15161__$1;
(statearr_15326_15487[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (38))){
var inst_14813 = (state_15161[(55)]);
var state_15161__$1 = state_15161;
var statearr_15327_15488 = state_15161__$1;
(statearr_15327_15488[(2)] = inst_14813);

(statearr_15327_15488[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (98))){
var inst_15058 = (state_15161[(69)]);
var inst_15056 = (state_15161[(70)]);
var inst_14948 = (state_15161[(48)]);
var inst_15061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15062 = (inst_15056 - inst_15058);
var inst_15063 = [inst_14948,inst_15062];
var inst_15064 = (new cljs.core.PersistentVector(null,2,(5),inst_15061,inst_15063,null));
var state_15161__$1 = state_15161;
var statearr_15328_15489 = state_15161__$1;
(statearr_15328_15489[(2)] = inst_15064);

(statearr_15328_15489[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (87))){
var inst_15017 = (state_15161[(85)]);
var state_15161__$1 = state_15161;
var statearr_15329_15490 = state_15161__$1;
(statearr_15329_15490[(2)] = inst_15017);

(statearr_15329_15490[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (30))){
var inst_14882 = (state_15161[(74)]);
var inst_14895 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14882);
var state_15161__$1 = state_15161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(33),inst_14895);
} else {
if((state_val_15162 === (73))){
var inst_14827 = (state_15161[(21)]);
var inst_14996 = (state_15161[(2)]);
var state_15161__$1 = (function (){var statearr_15330 = state_15161;
(statearr_15330[(32)] = inst_14996);

return statearr_15330;
})();
if(cljs.core.truth_(inst_14827)){
var statearr_15331_15491 = state_15161__$1;
(statearr_15331_15491[(1)] = (74));

} else {
var statearr_15332_15492 = state_15161__$1;
(statearr_15332_15492[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (96))){
var inst_15048 = (state_15161[(67)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_14981 = (state_15161[(37)]);
var inst_14948 = (state_15161[(48)]);
var inst_15097 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_15048,inst_14980,inst_14981,inst_14942,inst_14948);
var state_15161__$1 = state_15161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(104),inst_15097);
} else {
if((state_val_15162 === (10))){
var inst_14819 = (state_15161[(84)]);
var inst_14841 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14819);
var state_15161__$1 = state_15161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(13),inst_14841);
} else {
if((state_val_15162 === (18))){
var state_15161__$1 = state_15161;
var statearr_15333_15493 = state_15161__$1;
(statearr_15333_15493[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (105))){
var inst_15120 = (state_15161[(82)]);
var inst_14939 = (state_15161[(16)]);
var inst_15015 = (state_15161[(65)]);
var inst_14954 = (state_15161[(19)]);
var inst_15119 = (inst_14954.cljs$core$IFn$_invoke$arity$2 ? inst_14954.cljs$core$IFn$_invoke$arity$2(inst_15015,inst_14939) : inst_14954.call(null,inst_15015,inst_14939));
var inst_15120__$1 = (inst_15119 < (0));
var state_15161__$1 = (function (){var statearr_15335 = state_15161;
(statearr_15335[(82)] = inst_15120__$1);

return statearr_15335;
})();
if(cljs.core.truth_(inst_15120__$1)){
var statearr_15336_15494 = state_15161__$1;
(statearr_15336_15494[(1)] = (108));

} else {
var statearr_15337_15495 = state_15161__$1;
(statearr_15337_15495[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (52))){
var inst_14824 = (state_15161[(62)]);
var state_15161__$1 = state_15161;
var statearr_15338_15496 = state_15161__$1;
(statearr_15338_15496[(2)] = inst_14824);

(statearr_15338_15496[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (114))){
var inst_15015 = (state_15161[(65)]);
var inst_14955 = (state_15161[(24)]);
var inst_14960 = (state_15161[(38)]);
var inst_14965 = (state_15161[(44)]);
var inst_14959 = (state_15161[(45)]);
var inst_15135 = fluree.db.query.range.find_next_valid_node(inst_14965,inst_15015,inst_14955,inst_14959,inst_14960);
var state_15161__$1 = state_15161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15161__$1,(117),inst_15135);
} else {
if((state_val_15162 === (67))){
var state_15161__$1 = state_15161;
var statearr_15339_15497 = state_15161__$1;
(statearr_15339_15497[(2)] = null);

(statearr_15339_15497[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (71))){
var inst_14950 = (state_15161[(10)]);
var inst_14823 = (state_15161[(11)]);
var inst_14847 = (state_15161[(12)]);
var inst_14879 = (state_15161[(13)]);
var inst_14937 = (state_15161[(14)]);
var inst_14919 = (state_15161[(15)]);
var inst_14939 = (state_15161[(16)]);
var inst_14949 = (state_15161[(17)]);
var inst_14883 = (state_15161[(18)]);
var inst_14954 = (state_15161[(19)]);
var inst_14892 = (state_15161[(20)]);
var inst_14827 = (state_15161[(21)]);
var inst_14982 = (state_15161[(22)]);
var inst_14901 = (state_15161[(23)]);
var inst_14955 = (state_15161[(24)]);
var inst_14828 = (state_15161[(25)]);
var inst_14938 = (state_15161[(26)]);
var inst_14826 = (state_15161[(27)]);
var inst_14988 = (state_15161[(28)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_14975 = (state_15161[(9)]);
var inst_14880 = (state_15161[(31)]);
var inst_14979 = (state_15161[(33)]);
var inst_14969 = (state_15161[(8)]);
var inst_14815 = (state_15161[(34)]);
var inst_14816 = (state_15161[(35)]);
var inst_14978 = (state_15161[(36)]);
var inst_14981 = (state_15161[(37)]);
var inst_14960 = (state_15161[(38)]);
var inst_14811 = (state_15161[(39)]);
var inst_14928 = (state_15161[(40)]);
var inst_14838 = (state_15161[(41)]);
var inst_14822 = (state_15161[(42)]);
var inst_14910 = (state_15161[(43)]);
var inst_14965 = (state_15161[(44)]);
var inst_14959 = (state_15161[(45)]);
var inst_14941 = (state_15161[(46)]);
var inst_14818 = (state_15161[(47)]);
var inst_14948 = (state_15161[(48)]);
var inst_14992 = (function (){var no_filter_QMARK_ = inst_14975;
var t = inst_14955;
var max_limit_QMARK_ = inst_14949;
var next_node = inst_14978;
var fast_forward_db_QMARK_ = inst_14960;
var s1 = inst_14838;
var o2 = inst_14901;
var t1 = inst_14815;
var predicate_fn = inst_14828;
var i = inst_14980;
var m1 = inst_14928;
var root_node = inst_14965;
var s2 = inst_14847;
var p2 = inst_14919;
var vec__14804 = inst_14879;
var permissions = inst_14950;
var vec__14800 = inst_14818;
var limit = inst_14948;
var start_flake = inst_14938;
var flake_limit = inst_14942;
var vec__14797 = inst_14811;
var offset = inst_14979;
var acc = inst_14982;
var t2 = inst_14822;
var op1 = inst_14816;
var o1 = inst_14892;
var end_flake = inst_14939;
var base_result = inst_14988;
var s = inst_14981;
var node_start = inst_14969;
var vec__14807 = inst_14880;
var p1 = inst_14910;
var map__14810 = inst_14941;
var subject_fn = inst_14827;
var map__14803 = inst_14826;
var object_fn = inst_14883;
var idx_compare = inst_14954;
var G__14989 = inst_14988;
var op2 = inst_14823;
var m2 = inst_14937;
var novelty = inst_14959;
return (function (p1__14778_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__14778_SHARP_.o,start_flake.o);
});
})();
var inst_14993 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14992,inst_14988);
var state_15161__$1 = state_15161;
var statearr_15340_15498 = state_15161__$1;
(statearr_15340_15498[(2)] = inst_14993);

(statearr_15340_15498[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (42))){
var inst_14915 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
if(cljs.core.truth_(inst_14915)){
var statearr_15341_15499 = state_15161__$1;
(statearr_15341_15499[(1)] = (43));

} else {
var statearr_15342_15500 = state_15161__$1;
(statearr_15342_15500[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (80))){
var inst_14950 = (state_15161[(10)]);
var inst_14823 = (state_15161[(11)]);
var inst_14847 = (state_15161[(12)]);
var inst_14879 = (state_15161[(13)]);
var inst_14937 = (state_15161[(14)]);
var inst_14919 = (state_15161[(15)]);
var inst_14939 = (state_15161[(16)]);
var inst_14949 = (state_15161[(17)]);
var inst_14883 = (state_15161[(18)]);
var inst_14954 = (state_15161[(19)]);
var inst_14892 = (state_15161[(20)]);
var inst_14827 = (state_15161[(21)]);
var inst_14982 = (state_15161[(22)]);
var inst_14901 = (state_15161[(23)]);
var inst_14955 = (state_15161[(24)]);
var inst_14828 = (state_15161[(25)]);
var inst_14938 = (state_15161[(26)]);
var inst_14826 = (state_15161[(27)]);
var inst_14988 = (state_15161[(28)]);
var inst_14980 = (state_15161[(29)]);
var inst_14942 = (state_15161[(30)]);
var inst_14975 = (state_15161[(9)]);
var inst_14880 = (state_15161[(31)]);
var inst_14979 = (state_15161[(33)]);
var inst_14969 = (state_15161[(8)]);
var inst_14815 = (state_15161[(34)]);
var inst_14816 = (state_15161[(35)]);
var inst_14978 = (state_15161[(36)]);
var inst_14981 = (state_15161[(37)]);
var inst_14960 = (state_15161[(38)]);
var inst_14811 = (state_15161[(39)]);
var inst_14928 = (state_15161[(40)]);
var inst_14838 = (state_15161[(41)]);
var inst_14822 = (state_15161[(42)]);
var inst_14910 = (state_15161[(43)]);
var inst_14965 = (state_15161[(44)]);
var inst_14959 = (state_15161[(45)]);
var inst_14941 = (state_15161[(46)]);
var inst_15008 = (state_15161[(86)]);
var inst_14818 = (state_15161[(47)]);
var inst_14948 = (state_15161[(48)]);
var inst_15010 = (function (){var no_filter_QMARK_ = inst_14975;
var t = inst_14955;
var max_limit_QMARK_ = inst_14949;
var next_node = inst_14978;
var fast_forward_db_QMARK_ = inst_14960;
var s1 = inst_14838;
var o2 = inst_14901;
var t1 = inst_14815;
var predicate_fn = inst_14828;
var i = inst_14980;
var m1 = inst_14928;
var root_node = inst_14965;
var s2 = inst_14847;
var p2 = inst_14919;
var vec__14804 = inst_14879;
var permissions = inst_14950;
var vec__14800 = inst_14818;
var limit = inst_14948;
var start_flake = inst_14938;
var flake_limit = inst_14942;
var vec__14797 = inst_14811;
var offset = inst_14979;
var acc = inst_14982;
var t2 = inst_14822;
var op1 = inst_14816;
var o1 = inst_14892;
var end_flake = inst_14939;
var base_result = inst_14988;
var s = inst_14981;
var node_start = inst_14969;
var vec__14807 = inst_14880;
var p1 = inst_14910;
var map__14810 = inst_14941;
var subject_fn = inst_14827;
var map__14803 = inst_14826;
var object_fn = inst_14883;
var idx_compare = inst_14954;
var G__14989 = inst_15008;
var op2 = inst_14823;
var m2 = inst_14937;
var novelty = inst_14959;
return (function (p1__14781_SHARP_){
var G__15343 = p1__14781_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15343) : object_fn.call(null,G__15343));
});
})();
var inst_15011 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_15010,inst_15008);
var state_15161__$1 = state_15161;
var statearr_15344_15501 = state_15161__$1;
(statearr_15344_15501[(2)] = inst_15011);

(statearr_15344_15501[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (37))){
var state_15161__$1 = state_15161;
var statearr_15345_15502 = state_15161__$1;
(statearr_15345_15502[(2)] = (-1));

(statearr_15345_15502[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (63))){
var inst_14950 = (state_15161[(10)]);
var inst_14847 = (state_15161[(12)]);
var inst_14919 = (state_15161[(15)]);
var inst_14838 = (state_15161[(41)]);
var inst_14910 = (state_15161[(43)]);
var inst_14972 = fluree.db.permissions_validate.no_filter_QMARK_(inst_14950,inst_14838,inst_14847,inst_14910,inst_14919);
var state_15161__$1 = state_15161;
var statearr_15346_15503 = state_15161__$1;
(statearr_15346_15503[(2)] = inst_14972);

(statearr_15346_15503[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (94))){
var inst_15111 = (state_15161[(2)]);
var state_15161__$1 = state_15161;
var statearr_15347_15504 = state_15161__$1;
(statearr_15347_15504[(2)] = inst_15111);

(statearr_15347_15504[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (8))){
var inst_14819 = (state_15161[(84)]);
var inst_14838 = (state_15161[(2)]);
var inst_14839 = fluree.db.util.core.pred_ident_QMARK_(inst_14819);
var state_15161__$1 = (function (){var statearr_15348 = state_15161;
(statearr_15348[(41)] = inst_14838);

return statearr_15348;
})();
if(inst_14839){
var statearr_15349_15505 = state_15161__$1;
(statearr_15349_15505[(1)] = (10));

} else {
var statearr_15350_15506 = state_15161__$1;
(statearr_15350_15506[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (49))){
var state_15161__$1 = state_15161;
var statearr_15351_15507 = state_15161__$1;
(statearr_15351_15507[(2)] = fluree.db.util.core.min_integer);

(statearr_15351_15507[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15162 === (84))){
var inst_14949 = (state_15161[(17)]);
var state_15161__$1 = state_15161;
var statearr_15352_15508 = state_15161__$1;
(statearr_15352_15508[(2)] = inst_14949);

(statearr_15352_15508[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_15353 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15353[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_15353[(1)] = (1));

return statearr_15353;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_15161){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15161);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15354){var ex__2736__auto__ = e15354;
var statearr_15355_15509 = state_15161;
(statearr_15355_15509[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15161[(4)]))){
var statearr_15356_15510 = state_15161;
(statearr_15356_15510[(1)] = cljs.core.first((state_15161[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15511 = state_15161;
state_15161 = G__15511;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_15161){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_15161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15357 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15357[(6)] = c__2755__auto__);

return statearr_15357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15567){
var state_val_15568 = (state_15567[(1)]);
if((state_val_15568 === (7))){
var inst_15531 = (state_15567[(7)]);
var inst_15541 = (state_15567[(8)]);
var inst_15539 = fluree.db.flake.Flake__GT_parts(inst_15531);
var inst_15540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15539,(0),null);
var inst_15541__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15539,(1),null);
var inst_15542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15539,(2),null);
var inst_15543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15539,(3),null);
var inst_15544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15539,(4),null);
var inst_15545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15539,(5),null);
var inst_15546 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15542,inst_15541__$1);
var state_15567__$1 = (function (){var statearr_15569 = state_15567;
(statearr_15569[(9)] = inst_15545);

(statearr_15569[(8)] = inst_15541__$1);

(statearr_15569[(10)] = inst_15543);

(statearr_15569[(11)] = inst_15544);

(statearr_15569[(12)] = inst_15540);

return statearr_15569;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15567__$1,(10),inst_15546);
} else {
if((state_val_15568 === (1))){
var inst_15519 = flakes;
var inst_15520 = cljs.core.seq(inst_15519);
var inst_15521 = cljs.core.first(inst_15520);
var inst_15522 = cljs.core.next(inst_15520);
var inst_15523 = cljs.core.PersistentVector.EMPTY;
var inst_15524 = inst_15519;
var inst_15525 = inst_15523;
var state_15567__$1 = (function (){var statearr_15570 = state_15567;
(statearr_15570[(13)] = inst_15522);

(statearr_15570[(14)] = inst_15524);

(statearr_15570[(15)] = inst_15525);

(statearr_15570[(16)] = inst_15521);

return statearr_15570;
})();
var statearr_15571_15589 = state_15567__$1;
(statearr_15571_15589[(2)] = null);

(statearr_15571_15589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15568 === (4))){
var inst_15531 = (state_15567[(7)]);
var inst_15534 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15531);
var state_15567__$1 = state_15567;
if(inst_15534){
var statearr_15572_15590 = state_15567__$1;
(statearr_15572_15590[(1)] = (7));

} else {
var statearr_15573_15591 = state_15567__$1;
(statearr_15573_15591[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15568 === (6))){
var inst_15563 = (state_15567[(2)]);
var state_15567__$1 = state_15567;
var statearr_15574_15592 = state_15567__$1;
(statearr_15574_15592[(2)] = inst_15563);

(statearr_15574_15592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15568 === (3))){
var inst_15565 = (state_15567[(2)]);
var state_15567__$1 = state_15567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15567__$1,inst_15565);
} else {
if((state_val_15568 === (2))){
var inst_15531 = (state_15567[(7)]);
var inst_15524 = (state_15567[(14)]);
var inst_15530 = cljs.core.seq(inst_15524);
var inst_15531__$1 = cljs.core.first(inst_15530);
var inst_15532 = cljs.core.next(inst_15530);
var state_15567__$1 = (function (){var statearr_15575 = state_15567;
(statearr_15575[(17)] = inst_15532);

(statearr_15575[(7)] = inst_15531__$1);

return statearr_15575;
})();
if(cljs.core.truth_(inst_15531__$1)){
var statearr_15576_15593 = state_15567__$1;
(statearr_15576_15593[(1)] = (4));

} else {
var statearr_15577_15594 = state_15567__$1;
(statearr_15577_15594[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15568 === (9))){
var inst_15560 = (state_15567[(2)]);
var state_15567__$1 = state_15567;
var statearr_15578_15595 = state_15567__$1;
(statearr_15578_15595[(2)] = inst_15560);

(statearr_15578_15595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15568 === (5))){
var inst_15525 = (state_15567[(15)]);
var state_15567__$1 = state_15567;
var statearr_15579_15596 = state_15567__$1;
(statearr_15579_15596[(2)] = inst_15525);

(statearr_15579_15596[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15568 === (10))){
var inst_15545 = (state_15567[(9)]);
var inst_15532 = (state_15567[(17)]);
var inst_15541 = (state_15567[(8)]);
var inst_15525 = (state_15567[(15)]);
var inst_15543 = (state_15567[(10)]);
var inst_15544 = (state_15567[(11)]);
var inst_15540 = (state_15567[(12)]);
var inst_15548 = (state_15567[(2)]);
var inst_15549 = fluree.db.util.async.throw_err(inst_15548);
var inst_15550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15551 = [inst_15540,inst_15541,inst_15549,inst_15543,inst_15544,inst_15545];
var inst_15552 = (new cljs.core.PersistentVector(null,6,(5),inst_15550,inst_15551,null));
var inst_15553 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15552);
var inst_15554 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15525,inst_15553);
var inst_15524 = inst_15532;
var inst_15525__$1 = inst_15554;
var state_15567__$1 = (function (){var statearr_15580 = state_15567;
(statearr_15580[(14)] = inst_15524);

(statearr_15580[(15)] = inst_15525__$1);

return statearr_15580;
})();
var statearr_15581_15597 = state_15567__$1;
(statearr_15581_15597[(2)] = null);

(statearr_15581_15597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15568 === (8))){
var inst_15532 = (state_15567[(17)]);
var inst_15531 = (state_15567[(7)]);
var inst_15525 = (state_15567[(15)]);
var inst_15557 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15525,inst_15531);
var inst_15524 = inst_15532;
var inst_15525__$1 = inst_15557;
var state_15567__$1 = (function (){var statearr_15582 = state_15567;
(statearr_15582[(14)] = inst_15524);

(statearr_15582[(15)] = inst_15525__$1);

return statearr_15582;
})();
var statearr_15583_15598 = state_15567__$1;
(statearr_15583_15598[(2)] = null);

(statearr_15583_15598[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____0 = (function (){
var statearr_15584 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15584[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__);

(statearr_15584[(1)] = (1));

return statearr_15584;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____1 = (function (state_15567){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15567);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15585){var ex__2736__auto__ = e15585;
var statearr_15586_15599 = state_15567;
(statearr_15586_15599[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15567[(4)]))){
var statearr_15587_15600 = state_15567;
(statearr_15587_15600[(1)] = cljs.core.first((state_15567[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15601 = state_15567;
state_15567 = G__15601;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__ = function(state_15567){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____1.call(this,state_15567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15588 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15588[(6)] = c__2755__auto__);

return statearr_15588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15603 = arguments.length;
switch (G__15603) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15773){
var state_val_15774 = (state_15773[(1)]);
if((state_val_15774 === (65))){
var state_15773__$1 = state_15773;
var statearr_15775_15875 = state_15773__$1;
(statearr_15775_15875[(2)] = null);

(statearr_15775_15875[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (70))){
var inst_15768 = (state_15773[(2)]);
var _ = (function (){var statearr_15776 = state_15773;
(statearr_15776[(4)] = cljs.core.rest((state_15773[(4)])));

return statearr_15776;
})();
var state_15773__$1 = state_15773;
var statearr_15777_15876 = state_15773__$1;
(statearr_15777_15876[(2)] = inst_15768);

(statearr_15777_15876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (62))){
var inst_15754 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15778_15877 = state_15773__$1;
(statearr_15778_15877[(2)] = inst_15754);

(statearr_15778_15877[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (7))){
var state_15773__$1 = state_15773;
var statearr_15779_15878 = state_15773__$1;
(statearr_15779_15878[(2)] = false);

(statearr_15779_15878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (59))){
var inst_15728 = (state_15773[(2)]);
var inst_15729 = fluree.db.util.async.throw_err(inst_15728);
var state_15773__$1 = state_15773;
var statearr_15780_15879 = state_15773__$1;
(statearr_15780_15879[(2)] = inst_15729);

(statearr_15780_15879[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (20))){
var state_15773__$1 = state_15773;
var statearr_15781_15880 = state_15773__$1;
(statearr_15781_15880[(2)] = null);

(statearr_15781_15880[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (58))){
var inst_15718 = (state_15773[(2)]);
var inst_15719 = fluree.db.util.async.throw_err(inst_15718);
var inst_15720 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15719);
var state_15773__$1 = state_15773;
var statearr_15782_15881 = state_15773__$1;
(statearr_15782_15881[(2)] = inst_15720);

(statearr_15782_15881[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (60))){
var inst_15654 = (state_15773[(7)]);
var inst_15617 = (state_15773[(8)]);
var inst_15615 = (state_15773[(9)]);
var inst_15614 = (state_15773[(10)]);
var inst_15734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15735 = [inst_15615,inst_15614,inst_15654,inst_15617];
var inst_15736 = (new cljs.core.PersistentVector(null,4,(5),inst_15734,inst_15735,null));
var inst_15737 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15736,opts);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(63),inst_15737);
} else {
if((state_val_15774 === (27))){
var inst_15654 = (state_15773[(7)]);
var inst_15665 = (state_15773[(11)]);
var inst_15665__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15654);
var state_15773__$1 = (function (){var statearr_15783 = state_15773;
(statearr_15783[(11)] = inst_15665__$1);

return statearr_15783;
})();
if(inst_15665__$1){
var statearr_15784_15882 = state_15773__$1;
(statearr_15784_15882[(1)] = (30));

} else {
var statearr_15785_15883 = state_15773__$1;
(statearr_15785_15883[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (1))){
var state_15773__$1 = state_15773;
var statearr_15786_15884 = state_15773__$1;
(statearr_15786_15884[(2)] = null);

(statearr_15786_15884[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (69))){
var inst_15760 = (state_15773[(12)]);
var state_15773__$1 = state_15773;
var statearr_15787_15885 = state_15773__$1;
(statearr_15787_15885[(2)] = inst_15760);

(statearr_15787_15885[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (24))){
var inst_15615 = (state_15773[(9)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15615)){
var statearr_15788_15886 = state_15773__$1;
(statearr_15788_15886[(1)] = (27));

} else {
var statearr_15789_15887 = state_15773__$1;
(statearr_15789_15887[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (55))){
var inst_15654 = (state_15773[(7)]);
var inst_15712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15713 = [inst_15654];
var inst_15714 = (new cljs.core.PersistentVector(null,1,(5),inst_15712,inst_15713,null));
var inst_15715 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15716 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15714,inst_15715);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(58),inst_15716);
} else {
if((state_val_15774 === (39))){
var inst_15685 = (state_15773[(2)]);
var inst_15686 = fluree.db.util.async.throw_err(inst_15685);
var state_15773__$1 = state_15773;
var statearr_15790_15888 = state_15773__$1;
(statearr_15790_15888[(2)] = inst_15686);

(statearr_15790_15888[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (46))){
var inst_15698 = (state_15773[(13)]);
var inst_15698__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15773__$1 = (function (){var statearr_15791 = state_15773;
(statearr_15791[(13)] = inst_15698__$1);

return statearr_15791;
})();
if(cljs.core.truth_(inst_15698__$1)){
var statearr_15792_15889 = state_15773__$1;
(statearr_15792_15889[(1)] = (49));

} else {
var statearr_15793_15890 = state_15773__$1;
(statearr_15793_15890[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (4))){
var inst_15604 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15794_15891 = state_15773__$1;
(statearr_15794_15891[(2)] = inst_15604);

(statearr_15794_15891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (54))){
var inst_15710 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15710)){
var statearr_15795_15892 = state_15773__$1;
(statearr_15795_15892[(1)] = (55));

} else {
var statearr_15796_15893 = state_15773__$1;
(statearr_15796_15893[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (15))){
var inst_15616 = (state_15773[(14)]);
var inst_15635 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15616);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(18),inst_15635);
} else {
if((state_val_15774 === (48))){
var inst_15756 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15797_15894 = state_15773__$1;
(statearr_15797_15894[(2)] = inst_15756);

(statearr_15797_15894[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (50))){
var inst_15618 = (state_15773[(15)]);
var inst_15629 = (state_15773[(16)]);
var inst_15654 = (state_15773[(7)]);
var inst_15617 = (state_15773[(8)]);
var inst_15613 = (state_15773[(17)]);
var inst_15615 = (state_15773[(9)]);
var inst_15614 = (state_15773[(10)]);
var inst_15624 = (state_15773[(18)]);
var inst_15698 = (state_15773[(13)]);
var inst_15702 = (function (){var t = inst_15617;
var p = inst_15615;
var idx_predicate_QMARK_ = inst_15618;
var o = inst_15654;
var tag_predicate_QMARK_ = inst_15624;
var temp__5751__auto__ = inst_15698;
var s = inst_15614;
var o_coerce_QMARK_ = inst_15629;
var vec__15610 = inst_15613;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15773__$1 = state_15773;
var statearr_15798_15895 = state_15773__$1;
(statearr_15798_15895[(2)] = inst_15702);

(statearr_15798_15895[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (21))){
var inst_15650 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15799_15896 = state_15773__$1;
(statearr_15799_15896[(2)] = inst_15650);

(statearr_15799_15896[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (31))){
var inst_15665 = (state_15773[(11)]);
var state_15773__$1 = state_15773;
var statearr_15800_15897 = state_15773__$1;
(statearr_15800_15897[(2)] = inst_15665);

(statearr_15800_15897[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (32))){
var inst_15675 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15801_15898 = state_15773__$1;
(statearr_15801_15898[(2)] = inst_15675);

(statearr_15801_15898[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (40))){
var inst_15618 = (state_15773[(15)]);
var inst_15689 = (state_15773[(19)]);
var inst_15689__$1 = cljs.core.not(inst_15618);
var state_15773__$1 = (function (){var statearr_15802 = state_15773;
(statearr_15802[(19)] = inst_15689__$1);

return statearr_15802;
})();
if(inst_15689__$1){
var statearr_15803_15899 = state_15773__$1;
(statearr_15803_15899[(1)] = (43));

} else {
var statearr_15804_15900 = state_15773__$1;
(statearr_15804_15900[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (56))){
var inst_15617 = (state_15773[(8)]);
var inst_15615 = (state_15773[(9)]);
var inst_15614 = (state_15773[(10)]);
var inst_15704 = (state_15773[(20)]);
var inst_15722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15723 = [inst_15615,inst_15614,null,inst_15617];
var inst_15724 = (new cljs.core.PersistentVector(null,4,(5),inst_15722,inst_15723,null));
var inst_15725 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15704);
var inst_15726 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15724,inst_15725);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(59),inst_15726);
} else {
if((state_val_15774 === (33))){
var inst_15654 = (state_15773[(7)]);
var inst_15668 = cljs.core.fn_QMARK_(inst_15654);
var inst_15669 = (!(inst_15668));
var state_15773__$1 = state_15773;
var statearr_15805_15901 = state_15773__$1;
(statearr_15805_15901[(2)] = inst_15669);

(statearr_15805_15901[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (13))){
var inst_15616 = (state_15773[(14)]);
var inst_15633 = fluree.db.query.range.tag_string_QMARK_(inst_15616);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15633)){
var statearr_15806_15902 = state_15773__$1;
(statearr_15806_15902[(1)] = (15));

} else {
var statearr_15807_15903 = state_15773__$1;
(statearr_15807_15903[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (22))){
var inst_15646 = (state_15773[(2)]);
var inst_15647 = fluree.db.util.async.throw_err(inst_15646);
var state_15773__$1 = state_15773;
var statearr_15808_15904 = state_15773__$1;
(statearr_15808_15904[(2)] = inst_15647);

(statearr_15808_15904[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (36))){
var inst_15654 = (state_15773[(7)]);
var inst_15617 = (state_15773[(8)]);
var inst_15615 = (state_15773[(9)]);
var inst_15614 = (state_15773[(10)]);
var inst_15680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15681 = [inst_15615,inst_15654,inst_15614,inst_15617];
var inst_15682 = (new cljs.core.PersistentVector(null,4,(5),inst_15680,inst_15681,null));
var inst_15683 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15682,opts);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(39),inst_15683);
} else {
if((state_val_15774 === (41))){
var inst_15615 = (state_15773[(9)]);
var state_15773__$1 = state_15773;
var statearr_15809_15905 = state_15773__$1;
(statearr_15809_15905[(2)] = inst_15615);

(statearr_15809_15905[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (43))){
var inst_15654 = (state_15773[(7)]);
var state_15773__$1 = state_15773;
var statearr_15810_15906 = state_15773__$1;
(statearr_15810_15906[(2)] = inst_15654);

(statearr_15810_15906[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (61))){
var inst_15654 = (state_15773[(7)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15654)){
var statearr_15811_15907 = state_15773__$1;
(statearr_15811_15907[(1)] = (64));

} else {
var statearr_15812_15908 = state_15773__$1;
(statearr_15812_15908[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (29))){
var inst_15678 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15678)){
var statearr_15813_15909 = state_15773__$1;
(statearr_15813_15909[(1)] = (36));

} else {
var statearr_15814_15910 = state_15773__$1;
(statearr_15814_15910[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (44))){
var inst_15689 = (state_15773[(19)]);
var state_15773__$1 = state_15773;
var statearr_15815_15911 = state_15773__$1;
(statearr_15815_15911[(2)] = inst_15689);

(statearr_15815_15911[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (6))){
var inst_15615 = (state_15773[(9)]);
var inst_15620 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15615);
var inst_15621 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15620);
var state_15773__$1 = state_15773;
var statearr_15816_15912 = state_15773__$1;
(statearr_15816_15912[(2)] = inst_15621);

(statearr_15816_15912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (28))){
var inst_15615 = (state_15773[(9)]);
var state_15773__$1 = state_15773;
var statearr_15817_15913 = state_15773__$1;
(statearr_15817_15913[(2)] = inst_15615);

(statearr_15817_15913[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (64))){
var inst_15654 = (state_15773[(7)]);
var inst_15617 = (state_15773[(8)]);
var inst_15615 = (state_15773[(9)]);
var inst_15614 = (state_15773[(10)]);
var inst_15743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15744 = [inst_15654,inst_15615,inst_15614,inst_15617];
var inst_15745 = (new cljs.core.PersistentVector(null,4,(5),inst_15743,inst_15744,null));
var inst_15746 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15745,opts);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(67),inst_15746);
} else {
if((state_val_15774 === (51))){
var inst_15615 = (state_15773[(9)]);
var inst_15705 = (state_15773[(21)]);
var inst_15704 = (state_15773[(2)]);
var inst_15705__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15615);
var state_15773__$1 = (function (){var statearr_15818 = state_15773;
(statearr_15818[(20)] = inst_15704);

(statearr_15818[(21)] = inst_15705__$1);

return statearr_15818;
})();
if(inst_15705__$1){
var statearr_15819_15914 = state_15773__$1;
(statearr_15819_15914[(1)] = (52));

} else {
var statearr_15820_15915 = state_15773__$1;
(statearr_15820_15915[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (25))){
var inst_15624 = (state_15773[(18)]);
var inst_15760 = (state_15773[(2)]);
var state_15773__$1 = (function (){var statearr_15821 = state_15773;
(statearr_15821[(12)] = inst_15760);

return statearr_15821;
})();
if(cljs.core.truth_(inst_15624)){
var statearr_15822_15916 = state_15773__$1;
(statearr_15822_15916[(1)] = (68));

} else {
var statearr_15823_15917 = state_15773__$1;
(statearr_15823_15917[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (34))){
var inst_15618 = (state_15773[(15)]);
var state_15773__$1 = state_15773;
var statearr_15824_15918 = state_15773__$1;
(statearr_15824_15918[(2)] = inst_15618);

(statearr_15824_15918[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (17))){
var inst_15652 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15825_15919 = state_15773__$1;
(statearr_15825_15919[(2)] = inst_15652);

(statearr_15825_15919[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (3))){
var inst_15771 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15773__$1,inst_15771);
} else {
if((state_val_15774 === (12))){
var inst_15616 = (state_15773[(14)]);
var state_15773__$1 = state_15773;
var statearr_15826_15920 = state_15773__$1;
(statearr_15826_15920[(2)] = inst_15616);

(statearr_15826_15920[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (2))){
var inst_15613 = (state_15773[(17)]);
var inst_15615 = (state_15773[(9)]);
var _ = (function (){var statearr_15827 = state_15773;
(statearr_15827[(4)] = cljs.core.cons((5),(state_15773[(4)])));

return statearr_15827;
})();
var inst_15613__$1 = fparts;
var inst_15614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15613__$1,(0),null);
var inst_15615__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15613__$1,(1),null);
var inst_15616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15613__$1,(2),null);
var inst_15617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15613__$1,(3),null);
var inst_15618 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15615__$1);
var state_15773__$1 = (function (){var statearr_15828 = state_15773;
(statearr_15828[(15)] = inst_15618);

(statearr_15828[(14)] = inst_15616);

(statearr_15828[(8)] = inst_15617);

(statearr_15828[(17)] = inst_15613__$1);

(statearr_15828[(9)] = inst_15615__$1);

(statearr_15828[(10)] = inst_15614);

return statearr_15828;
})();
if(cljs.core.truth_(inst_15615__$1)){
var statearr_15829_15921 = state_15773__$1;
(statearr_15829_15921[(1)] = (6));

} else {
var statearr_15830_15922 = state_15773__$1;
(statearr_15830_15922[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (66))){
var inst_15752 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15831_15923 = state_15773__$1;
(statearr_15831_15923[(2)] = inst_15752);

(statearr_15831_15923[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (23))){
var inst_15654 = (state_15773[(7)]);
var inst_15617 = (state_15773[(8)]);
var inst_15615 = (state_15773[(9)]);
var inst_15614 = (state_15773[(10)]);
var inst_15656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15657 = [inst_15614,inst_15615,inst_15654,inst_15617];
var inst_15658 = (new cljs.core.PersistentVector(null,4,(5),inst_15656,inst_15657,null));
var inst_15659 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15658,opts);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(26),inst_15659);
} else {
if((state_val_15774 === (47))){
var inst_15615 = (state_15773[(9)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15615)){
var statearr_15832_15924 = state_15773__$1;
(statearr_15832_15924[(1)] = (60));

} else {
var statearr_15833_15925 = state_15773__$1;
(statearr_15833_15925[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (35))){
var inst_15672 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15834_15926 = state_15773__$1;
(statearr_15834_15926[(2)] = inst_15672);

(statearr_15834_15926[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (19))){
var inst_15616 = (state_15773[(14)]);
var inst_15615 = (state_15773[(9)]);
var inst_15642 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15615);
var inst_15643 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15642),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15616)].join('');
var inst_15644 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15643);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(22),inst_15644);
} else {
if((state_val_15774 === (57))){
var inst_15731 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15835_15927 = state_15773__$1;
(statearr_15835_15927[(2)] = inst_15731);

(statearr_15835_15927[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (68))){
var inst_15760 = (state_15773[(12)]);
var inst_15762 = fluree.db.query.range.coerce_tag_flakes(db,inst_15760);
var state_15773__$1 = state_15773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15773__$1,(71),inst_15762);
} else {
if((state_val_15774 === (11))){
var inst_15629 = (state_15773[(16)]);
var inst_15629__$1 = (state_15773[(2)]);
var inst_15630 = cljs.core.not(inst_15629__$1);
var state_15773__$1 = (function (){var statearr_15837 = state_15773;
(statearr_15837[(16)] = inst_15629__$1);

return statearr_15837;
})();
if(inst_15630){
var statearr_15838_15928 = state_15773__$1;
(statearr_15838_15928[(1)] = (12));

} else {
var statearr_15839_15929 = state_15773__$1;
(statearr_15839_15929[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (9))){
var inst_15616 = (state_15773[(14)]);
var inst_15626 = typeof inst_15616 === 'string';
var state_15773__$1 = state_15773;
var statearr_15840_15930 = state_15773__$1;
(statearr_15840_15930[(2)] = inst_15626);

(statearr_15840_15930[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (5))){
var _ = (function (){var statearr_15841 = state_15773;
(statearr_15841[(4)] = cljs.core.rest((state_15773[(4)])));

return statearr_15841;
})();
var state_15773__$1 = state_15773;
var ex15836 = (state_15773__$1[(2)]);
var statearr_15842_15931 = state_15773__$1;
(statearr_15842_15931[(5)] = ex15836);


if((ex15836 instanceof Error)){
var statearr_15843_15932 = state_15773__$1;
(statearr_15843_15932[(1)] = (4));

(statearr_15843_15932[(5)] = null);

} else {
throw ex15836;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (14))){
var inst_15614 = (state_15773[(10)]);
var inst_15654 = (state_15773[(2)]);
var state_15773__$1 = (function (){var statearr_15844 = state_15773;
(statearr_15844[(7)] = inst_15654);

return statearr_15844;
})();
if(cljs.core.truth_(inst_15614)){
var statearr_15845_15933 = state_15773__$1;
(statearr_15845_15933[(1)] = (23));

} else {
var statearr_15846_15934 = state_15773__$1;
(statearr_15846_15934[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (45))){
var inst_15693 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15847_15935 = state_15773__$1;
(statearr_15847_15935[(2)] = inst_15693);

(statearr_15847_15935[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (53))){
var inst_15705 = (state_15773[(21)]);
var state_15773__$1 = state_15773;
var statearr_15848_15936 = state_15773__$1;
(statearr_15848_15936[(2)] = inst_15705);

(statearr_15848_15936[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (26))){
var inst_15661 = (state_15773[(2)]);
var inst_15662 = fluree.db.util.async.throw_err(inst_15661);
var state_15773__$1 = state_15773;
var statearr_15849_15937 = state_15773__$1;
(statearr_15849_15937[(2)] = inst_15662);

(statearr_15849_15937[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (16))){
var inst_15616 = (state_15773[(14)]);
var inst_15640 = typeof inst_15616 === 'string';
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15640)){
var statearr_15850_15938 = state_15773__$1;
(statearr_15850_15938[(1)] = (19));

} else {
var statearr_15851_15939 = state_15773__$1;
(statearr_15851_15939[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (38))){
var inst_15758 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
var statearr_15852_15940 = state_15773__$1;
(statearr_15852_15940[(2)] = inst_15758);

(statearr_15852_15940[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (30))){
var inst_15618 = (state_15773[(15)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15618)){
var statearr_15853_15941 = state_15773__$1;
(statearr_15853_15941[(1)] = (33));

} else {
var statearr_15854_15942 = state_15773__$1;
(statearr_15854_15942[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (10))){
var inst_15624 = (state_15773[(18)]);
var state_15773__$1 = state_15773;
var statearr_15855_15943 = state_15773__$1;
(statearr_15855_15943[(2)] = inst_15624);

(statearr_15855_15943[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (18))){
var inst_15637 = (state_15773[(2)]);
var inst_15638 = fluree.db.util.async.throw_err(inst_15637);
var state_15773__$1 = state_15773;
var statearr_15856_15944 = state_15773__$1;
(statearr_15856_15944[(2)] = inst_15638);

(statearr_15856_15944[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (52))){
var inst_15654 = (state_15773[(7)]);
var inst_15707 = cljs.core.int_QMARK_(inst_15654);
var state_15773__$1 = state_15773;
var statearr_15857_15945 = state_15773__$1;
(statearr_15857_15945[(2)] = inst_15707);

(statearr_15857_15945[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (67))){
var inst_15748 = (state_15773[(2)]);
var inst_15749 = fluree.db.util.async.throw_err(inst_15748);
var state_15773__$1 = state_15773;
var statearr_15858_15946 = state_15773__$1;
(statearr_15858_15946[(2)] = inst_15749);

(statearr_15858_15946[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (71))){
var inst_15764 = (state_15773[(2)]);
var inst_15765 = fluree.db.util.async.throw_err(inst_15764);
var state_15773__$1 = state_15773;
var statearr_15859_15947 = state_15773__$1;
(statearr_15859_15947[(2)] = inst_15765);

(statearr_15859_15947[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (42))){
var inst_15696 = (state_15773[(2)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15696)){
var statearr_15860_15948 = state_15773__$1;
(statearr_15860_15948[(1)] = (46));

} else {
var statearr_15861_15949 = state_15773__$1;
(statearr_15861_15949[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (37))){
var inst_15615 = (state_15773[(9)]);
var state_15773__$1 = state_15773;
if(cljs.core.truth_(inst_15615)){
var statearr_15862_15950 = state_15773__$1;
(statearr_15862_15950[(1)] = (40));

} else {
var statearr_15863_15951 = state_15773__$1;
(statearr_15863_15951[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (63))){
var inst_15739 = (state_15773[(2)]);
var inst_15740 = fluree.db.util.async.throw_err(inst_15739);
var state_15773__$1 = state_15773;
var statearr_15864_15952 = state_15773__$1;
(statearr_15864_15952[(2)] = inst_15740);

(statearr_15864_15952[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (8))){
var inst_15624 = (state_15773[(18)]);
var inst_15624__$1 = (state_15773[(2)]);
var state_15773__$1 = (function (){var statearr_15865 = state_15773;
(statearr_15865[(18)] = inst_15624__$1);

return statearr_15865;
})();
if(cljs.core.truth_(inst_15624__$1)){
var statearr_15866_15953 = state_15773__$1;
(statearr_15866_15953[(1)] = (9));

} else {
var statearr_15867_15954 = state_15773__$1;
(statearr_15867_15954[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15774 === (49))){
var inst_15618 = (state_15773[(15)]);
var inst_15629 = (state_15773[(16)]);
var inst_15654 = (state_15773[(7)]);
var inst_15617 = (state_15773[(8)]);
var inst_15613 = (state_15773[(17)]);
var inst_15615 = (state_15773[(9)]);
var inst_15614 = (state_15773[(10)]);
var inst_15624 = (state_15773[(18)]);
var inst_15698 = (state_15773[(13)]);
var inst_15700 = (function (){var obj_fn = inst_15698;
var t = inst_15617;
var p = inst_15615;
var idx_predicate_QMARK_ = inst_15618;
var o = inst_15654;
var tag_predicate_QMARK_ = inst_15624;
var temp__5751__auto__ = inst_15698;
var s = inst_15614;
var o_coerce_QMARK_ = inst_15629;
var vec__15610 = inst_15613;
return (function (x){
var and__4221__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4221__auto__;
}
});
})();
var state_15773__$1 = state_15773;
var statearr_15868_15955 = state_15773__$1;
(statearr_15868_15955[(2)] = inst_15700);

(statearr_15868_15955[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_15869 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15869[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_15869[(1)] = (1));

return statearr_15869;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_15773){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15773);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15870){var ex__2736__auto__ = e15870;
var statearr_15871_15956 = state_15773;
(statearr_15871_15956[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15773[(4)]))){
var statearr_15872_15957 = state_15773;
(statearr_15872_15957[(1)] = cljs.core.first((state_15773[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15958 = state_15773;
state_15773 = G__15958;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_15773){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_15773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15873 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15873[(6)] = c__2755__auto__);

return statearr_15873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15960 = arguments.length;
switch (G__15960) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15995){
var state_val_15996 = (state_15995[(1)]);
if((state_val_15996 === (7))){
var inst_15982 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15983 = ["Invalid collection name: ",inst_15982].join('');
var inst_15984 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15985 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15986 = cljs.core.PersistentHashMap.fromArrays(inst_15984,inst_15985);
var inst_15987 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15983,inst_15986);
var inst_15988 = (function(){throw inst_15987})();
var state_15995__$1 = state_15995;
var statearr_15997_16017 = state_15995__$1;
(statearr_15997_16017[(2)] = inst_15988);

(statearr_15997_16017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15996 === (1))){
var state_15995__$1 = state_15995;
var statearr_15998_16018 = state_15995__$1;
(statearr_15998_16018[(2)] = null);

(statearr_15998_16018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15996 === (4))){
var inst_15961 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
var statearr_15999_16019 = state_15995__$1;
(statearr_15999_16019[(2)] = inst_15961);

(statearr_15999_16019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15996 === (6))){
var inst_15967 = (state_15995[(7)]);
var inst_15969 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15970 = fluree.db.flake.max_subject_id(inst_15967);
var inst_15971 = [inst_15970];
var inst_15972 = (new cljs.core.PersistentVector(null,1,(5),inst_15969,inst_15971,null));
var inst_15973 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15974 = fluree.db.flake.min_subject_id(inst_15967);
var inst_15975 = [inst_15974];
var inst_15976 = (new cljs.core.PersistentVector(null,1,(5),inst_15973,inst_15975,null));
var inst_15977 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15972,cljs.core._LT__EQ_,inst_15976,opts);
var state_15995__$1 = state_15995;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15995__$1,(9),inst_15977);
} else {
if((state_val_15996 === (3))){
var inst_15993 = (state_15995[(2)]);
var state_15995__$1 = state_15995;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15995__$1,inst_15993);
} else {
if((state_val_15996 === (2))){
var inst_15967 = (state_15995[(7)]);
var _ = (function (){var statearr_16001 = state_15995;
(statearr_16001[(4)] = cljs.core.cons((5),(state_15995[(4)])));

return statearr_16001;
})();
var inst_15967__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_15995__$1 = (function (){var statearr_16002 = state_15995;
(statearr_16002[(7)] = inst_15967__$1);

return statearr_16002;
})();
if(cljs.core.truth_(inst_15967__$1)){
var statearr_16003_16020 = state_15995__$1;
(statearr_16003_16020[(1)] = (6));

} else {
var statearr_16004_16021 = state_15995__$1;
(statearr_16004_16021[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15996 === (9))){
var inst_15979 = (state_15995[(2)]);
var inst_15980 = fluree.db.util.async.throw_err(inst_15979);
var state_15995__$1 = state_15995;
var statearr_16005_16022 = state_15995__$1;
(statearr_16005_16022[(2)] = inst_15980);

(statearr_16005_16022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15996 === (5))){
var _ = (function (){var statearr_16006 = state_15995;
(statearr_16006[(4)] = cljs.core.rest((state_15995[(4)])));

return statearr_16006;
})();
var state_15995__$1 = state_15995;
var ex16000 = (state_15995__$1[(2)]);
var statearr_16007_16023 = state_15995__$1;
(statearr_16007_16023[(5)] = ex16000);


var statearr_16008_16024 = state_15995__$1;
(statearr_16008_16024[(1)] = (4));

(statearr_16008_16024[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15996 === (8))){
var inst_15990 = (state_15995[(2)]);
var _ = (function (){var statearr_16009 = state_15995;
(statearr_16009[(4)] = cljs.core.rest((state_15995[(4)])));

return statearr_16009;
})();
var state_15995__$1 = state_15995;
var statearr_16010_16025 = state_15995__$1;
(statearr_16010_16025[(2)] = inst_15990);

(statearr_16010_16025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_16011 = [null,null,null,null,null,null,null,null];
(statearr_16011[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_16011[(1)] = (1));

return statearr_16011;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_15995){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15995);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e16012){var ex__2736__auto__ = e16012;
var statearr_16013_16026 = state_15995;
(statearr_16013_16026[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15995[(4)]))){
var statearr_16014_16027 = state_15995;
(statearr_16014_16027[(1)] = cljs.core.first((state_15995[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16028 = state_15995;
state_15995 = G__16028;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_15995){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_15995);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_16015 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_16015[(6)] = c__2755__auto__);

return statearr_16015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__16032 = flakes;
var vec__16033 = G__16032;
var seq__16034 = cljs.core.seq(vec__16033);
var first__16035 = cljs.core.first(seq__16034);
var seq__16034__$1 = cljs.core.next(seq__16034);
var flake_SINGLEQUOTE_ = first__16035;
var r = seq__16034__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16032__$1 = G__16032;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16041 = G__16032__$1;
var seq__16042 = cljs.core.seq(vec__16041);
var first__16043 = cljs.core.first(seq__16042);
var seq__16042__$1 = cljs.core.next(seq__16042);
var flake_SINGLEQUOTE___$1 = first__16043;
var r__$1 = seq__16042__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e16045){var e = e16045;
return null;
}})();
var map__16044 = cmd_map;
var map__16044__$1 = cljs.core.__destructure_map(map__16044);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16044__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16044__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16044__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16044__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16044__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16044__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__16046 = r__$1;
var G__16047 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__16032__$1 = G__16046;
result_STAR___$1 = G__16047;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__16056 = blocks;
var vec__16057 = G__16056;
var seq__16058 = cljs.core.seq(vec__16057);
var first__16059 = cljs.core.first(seq__16058);
var seq__16058__$1 = cljs.core.next(seq__16058);
var block_SINGLEQUOTE_ = first__16059;
var r = seq__16058__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__16056__$1 = G__16056;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__16064 = G__16056__$1;
var seq__16065 = cljs.core.seq(vec__16064);
var first__16066 = cljs.core.first(seq__16065);
var seq__16065__$1 = cljs.core.next(seq__16065);
var block_SINGLEQUOTE___$1 = first__16066;
var r__$1 = seq__16065__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__16067 = block_SINGLEQUOTE___$1;
var map__16067__$1 = cljs.core.__destructure_map(map__16067);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16067__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16067__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16067__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16048_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__16048_SHARP_.p,(2))){
return p1__16048_SHARP_.o;
} else {
return null;
}
});})(G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16049_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__16049_SHARP_.p,(1))){
return p1__16049_SHARP_.o;
} else {
return null;
}
});})(G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,hash,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16050_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__16050_SHARP_.p,(5))){
return p1__16050_SHARP_.o;
} else {
return null;
}
});})(G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,hash,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,hash,instant,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16051_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__16051_SHARP_.p,(7))){
return p1__16051_SHARP_.o;
} else {
return null;
}
});})(G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,hash,instant,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__16052_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__16052_SHARP_.p,(106));
});})(G__16056__$1,result_STAR___$1,map__16067,map__16067__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__16064,seq__16065,first__16066,seq__16065__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__16056,vec__16057,seq__16058,first__16059,seq__16058__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__16068 = r__$1;
var G__16069 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__16056__$1 = G__16068;
result_STAR___$1 = G__16069;
continue;
}
break;
}
});
