// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.object');
goog.require('fluree.db.connection_js');
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__64485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64485__$1 = cljs.core.__destructure_map(map__64485);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64485__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64485__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = goog.object.get(obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__64486 = cljs.core.get_global_hierarchy;
return (fexpr__64486.cljs$core$IFn$_invoke$arity$0 ? fexpr__64486.cljs$core$IFn$_invoke$arity$0() : fexpr__64486.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__64487__delegate = function (conn_id,event,_){
return event;
};
var G__64487 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__64488__i = 0, G__64488__a = new Array(arguments.length -  2);
while (G__64488__i < G__64488__a.length) {G__64488__a[G__64488__i] = arguments[G__64488__i + 2]; ++G__64488__i;}
  _ = new cljs.core.IndexedSeq(G__64488__a,0,null);
} 
return G__64487__delegate.call(this,conn_id,event,_);};
G__64487.cljs$lang$maxFixedArity = 2;
G__64487.cljs$lang$applyTo = (function (arglist__64489){
var conn_id = cljs.core.first(arglist__64489);
arglist__64489 = cljs.core.next(arglist__64489);
var event = cljs.core.first(arglist__64489);
var _ = cljs.core.rest(arglist__64489);
return G__64487__delegate(conn_id,event,_);
});
G__64487.cljs$core$IFn$_invoke$arity$variadic = G__64487__delegate;
return G__64487;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4223__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64507){
var state_val_64508 = (state_64507[(1)]);
if((state_val_64508 === (1))){
var inst_64490 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_64491 = flureeworker.conn_id__GT_db(conn_id,inst_64490);
var inst_64492 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_64493 = fluree.db.api.query.query(inst_64491,inst_64492);
var state_64507__$1 = state_64507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64507__$1,(2),inst_64493);
} else {
if((state_val_64508 === (2))){
var inst_64495 = (state_64507[(7)]);
var inst_64495__$1 = (state_64507[(2)]);
var inst_64496 = fluree.db.util.core.exception_QMARK_(inst_64495__$1);
var state_64507__$1 = (function (){var statearr_64509 = state_64507;
(statearr_64509[(7)] = inst_64495__$1);

return statearr_64509;
})();
if(inst_64496){
var statearr_64510_64523 = state_64507__$1;
(statearr_64510_64523[(1)] = (3));

} else {
var statearr_64511_64524 = state_64507__$1;
(statearr_64511_64524[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64508 === (3))){
var inst_64495 = (state_64507[(7)]);
var inst_64498 = flureeworker.error_return_map(inst_64495);
var state_64507__$1 = state_64507;
var statearr_64512_64525 = state_64507__$1;
(statearr_64512_64525[(2)] = inst_64498);

(statearr_64512_64525[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64508 === (4))){
var inst_64495 = (state_64507[(7)]);
var inst_64500 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64501 = [inst_64495,"loaded"];
var inst_64502 = cljs.core.PersistentHashMap.fromArrays(inst_64500,inst_64501);
var state_64507__$1 = state_64507;
var statearr_64513_64526 = state_64507__$1;
(statearr_64513_64526[(2)] = inst_64502);

(statearr_64513_64526[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64508 === (5))){
var inst_64504 = (state_64507[(2)]);
var inst_64505 = (function (){var G__64514 = conn_id;
var G__64515 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__64516 = id;
var G__64517 = inst_64504;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64514,G__64515,G__64516,G__64517) : flureeworker.worker_action.call(null,G__64514,G__64515,G__64516,G__64517));
})();
var state_64507__$1 = state_64507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64507__$1,inst_64505);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2733__auto__ = null;
var flureeworker$process_query_$_state_machine__2733__auto____0 = (function (){
var statearr_64518 = [null,null,null,null,null,null,null,null];
(statearr_64518[(0)] = flureeworker$process_query_$_state_machine__2733__auto__);

(statearr_64518[(1)] = (1));

return statearr_64518;
});
var flureeworker$process_query_$_state_machine__2733__auto____1 = (function (state_64507){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64507);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64519){var ex__2736__auto__ = e64519;
var statearr_64520_64527 = state_64507;
(statearr_64520_64527[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64507[(4)]))){
var statearr_64521_64528 = state_64507;
(statearr_64521_64528[(1)] = cljs.core.first((state_64507[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64529 = state_64507;
state_64507 = G__64529;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2733__auto__ = function(state_64507){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2733__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2733__auto____1.call(this,state_64507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2733__auto____0;
flureeworker$process_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2733__auto____1;
return flureeworker$process_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64522 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64522[(6)] = c__2755__auto__);

return statearr_64522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__64530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64530__$1 = cljs.core.__destructure_map(map__64530);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64530__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64530__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__64531 = cljs.core.seq(query_ids);
var chunk__64532 = null;
var count__64533 = (0);
var i__64534 = (0);
while(true){
if((i__64534 < count__64533)){
var id = chunk__64532.cljs$core$IIndexed$_nth$arity$2(null,i__64534);
flureeworker.process_query(conn_id,id,opts);


var G__64535 = seq__64531;
var G__64536 = chunk__64532;
var G__64537 = count__64533;
var G__64538 = (i__64534 + (1));
seq__64531 = G__64535;
chunk__64532 = G__64536;
count__64533 = G__64537;
i__64534 = G__64538;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__64531);
if(temp__5753__auto__){
var seq__64531__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64531__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__64531__$1);
var G__64539 = cljs.core.chunk_rest(seq__64531__$1);
var G__64540 = c__4649__auto__;
var G__64541 = cljs.core.count(c__4649__auto__);
var G__64542 = (0);
seq__64531 = G__64539;
chunk__64532 = G__64540;
count__64533 = G__64541;
i__64534 = G__64542;
continue;
} else {
var id = cljs.core.first(seq__64531__$1);
flureeworker.process_query(conn_id,id,opts);


var G__64543 = cljs.core.next(seq__64531__$1);
var G__64544 = null;
var G__64545 = (0);
var G__64546 = (0);
seq__64531 = G__64543;
chunk__64532 = G__64544;
count__64533 = G__64545;
i__64534 = G__64546;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__64547 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64547,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64547,(1),null);
var cb = (function (header,data){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64555){
var state_val_64556 = (state_64555[(1)]);
if((state_val_64556 === (1))){
var inst_64550 = cljs.core.async.timeout((100));
var state_64555__$1 = state_64555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64555__$1,(2),inst_64550);
} else {
if((state_val_64556 === (2))){
var inst_64552 = (state_64555[(2)]);
var inst_64553 = flureeworker.process_all_queries(conn_id);
var state_64555__$1 = (function (){var statearr_64557 = state_64555;
(statearr_64557[(7)] = inst_64552);

return statearr_64557;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64555__$1,inst_64553);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2733__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2733__auto____0 = (function (){
var statearr_64558 = [null,null,null,null,null,null,null,null];
(statearr_64558[(0)] = flureeworker$ledger_listener_$_state_machine__2733__auto__);

(statearr_64558[(1)] = (1));

return statearr_64558;
});
var flureeworker$ledger_listener_$_state_machine__2733__auto____1 = (function (state_64555){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64555);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64559){var ex__2736__auto__ = e64559;
var statearr_64560_64563 = state_64555;
(statearr_64560_64563[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64555[(4)]))){
var statearr_64561_64564 = state_64555;
(statearr_64561_64564[(1)] = cljs.core.first((state_64555[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64565 = state_64555;
state_64555 = G__64565;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2733__auto__ = function(state_64555){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2733__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2733__auto____1.call(this,state_64555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2733__auto____0;
flureeworker$ledger_listener_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2733__auto____1;
return flureeworker$ledger_listener_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64562 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64562[(6)] = c__2755__auto__);

return statearr_64562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__64566 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64566,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64566,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__64569 = config;
var map__64569__$1 = cljs.core.__destructure_map(map__64569);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64569__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64569__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64569__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64569__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64569__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64569__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4223__auto__ = queries;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64570 = conn_data;
var map__64570__$1 = cljs.core.__destructure_map(map__64570);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64570__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64570__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64570__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__64571 = config;
var map__64571__$1 = cljs.core.__destructure_map(map__64571);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64571__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64571__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64571__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64571__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64577){
var state_val_64578 = (state_64577[(1)]);
if((state_val_64578 === (1))){
var inst_64572 = cljs.core.async.timeout((100));
var state_64577__$1 = state_64577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64577__$1,(2),inst_64572);
} else {
if((state_val_64578 === (2))){
var inst_64574 = (state_64577[(2)]);
var inst_64575 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_64577__$1 = (function (){var statearr_64579 = state_64577;
(statearr_64579[(7)] = inst_64574);

return statearr_64579;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64577__$1,inst_64575);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2733__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2733__auto____0 = (function (){
var statearr_64580 = [null,null,null,null,null,null,null,null];
(statearr_64580[(0)] = flureeworker$connect_STAR__$_state_machine__2733__auto__);

(statearr_64580[(1)] = (1));

return statearr_64580;
});
var flureeworker$connect_STAR__$_state_machine__2733__auto____1 = (function (state_64577){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64577);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64581){var ex__2736__auto__ = e64581;
var statearr_64582_64593 = state_64577;
(statearr_64582_64593[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64577[(4)]))){
var statearr_64583_64594 = state_64577;
(statearr_64583_64594[(1)] = cljs.core.first((state_64577[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64595 = state_64577;
state_64577 = G__64595;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2733__auto__ = function(state_64577){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2733__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2733__auto____1.call(this,state_64577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2733__auto____0;
flureeworker$connect_STAR__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2733__auto____1;
return flureeworker$connect_STAR__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64584 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64584[(6)] = c__2755__auto__);

return statearr_64584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__64585_64596 = conn_id;
var G__64586_64597 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64587_64598 = ref;
var G__64588_64599 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64585_64596,G__64586_64597,G__64587_64598,G__64588_64599) : flureeworker.worker_action.call(null,G__64585_64596,G__64586_64597,G__64587_64598,G__64588_64599));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__64589 = conn_id;
var G__64590 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64591 = ref;
var G__64592 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64589,G__64590,G__64591,G__64592) : flureeworker.worker_action.call(null,G__64589,G__64590,G__64591,G__64592));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__64601 = arguments.length;
switch (G__64601) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64602 = conn_data;
var map__64602__$1 = cljs.core.__destructure_map(map__64602);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64602__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64602__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64602__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64602__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__64609 = conn_id;
var G__64610 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64611 = ref;
var G__64612 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64609,G__64610,G__64611,G__64612) : flureeworker.worker_action.call(null,G__64609,G__64610,G__64611,G__64612));
}catch (e64604){var e = e64604;
var msg = (function (){var or__4223__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4223__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64605 = conn_id;
var G__64606 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__64607 = ref;
var G__64608 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64605,G__64606,G__64607,G__64608) : flureeworker.worker_action.call(null,G__64605,G__64606,G__64607,G__64608));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e64613){var e = e64613;
var msg = (function (){var or__4223__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4223__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__64614 = conn_id;
var G__64615 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__64616 = ref;
var G__64617 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64614,G__64615,G__64616,G__64617) : flureeworker.worker_action.call(null,G__64614,G__64615,G__64616,G__64617));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__64618 = config_STAR_;
var map__64618__$1 = cljs.core.__destructure_map(map__64618);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64618__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64618__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64618__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64618__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64624){
var state_val_64625 = (state_64624[(1)]);
if((state_val_64625 === (1))){
var inst_64619 = cljs.core.async.timeout((100));
var state_64624__$1 = state_64624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64624__$1,(2),inst_64619);
} else {
if((state_val_64625 === (2))){
var inst_64621 = (state_64624[(2)]);
var inst_64622 = flureeworker.connect_STAR_(id,ref);
var state_64624__$1 = (function (){var statearr_64626 = state_64624;
(statearr_64626[(7)] = inst_64621);

return statearr_64626;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64624__$1,inst_64622);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2733__auto__ = null;
var flureeworker$connect_p_$_state_machine__2733__auto____0 = (function (){
var statearr_64627 = [null,null,null,null,null,null,null,null];
(statearr_64627[(0)] = flureeworker$connect_p_$_state_machine__2733__auto__);

(statearr_64627[(1)] = (1));

return statearr_64627;
});
var flureeworker$connect_p_$_state_machine__2733__auto____1 = (function (state_64624){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64624);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64628){var ex__2736__auto__ = e64628;
var statearr_64629_64640 = state_64624;
(statearr_64629_64640[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64624[(4)]))){
var statearr_64630_64641 = state_64624;
(statearr_64630_64641[(1)] = cljs.core.first((state_64624[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64642 = state_64624;
state_64624 = G__64642;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2733__auto__ = function(state_64624){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2733__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2733__auto____1.call(this,state_64624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2733__auto____0;
flureeworker$connect_p_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2733__auto____1;
return flureeworker$connect_p_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64631 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64631[(6)] = c__2755__auto__);

return statearr_64631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__64632 = id;
var G__64633 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64634 = ref;
var G__64635 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64632,G__64633,G__64634,G__64635) : flureeworker.worker_action.call(null,G__64632,G__64633,G__64634,G__64635));
})).catch((function (error){
var G__64636 = id;
var G__64637 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__64638 = ref;
var G__64639 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64636,G__64637,G__64638,G__64639) : flureeworker.worker_action.call(null,G__64636,G__64637,G__64638,G__64639));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4835__auto__ = [];
var len__4829__auto___64710 = arguments.length;
var i__4830__auto___64711 = (0);
while(true){
if((i__4830__auto___64711 < len__4829__auto___64710)){
args__4835__auto__.push((arguments[i__4830__auto___64711]));

var G__64712 = (i__4830__auto___64711 + (1));
i__4830__auto___64711 = G__64712;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((4) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4836__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__64648){
var vec__64649 = p__64648;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64649,(0),null);
var map__64652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64652__$1 = cljs.core.__destructure_map(map__64652);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64652__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64652__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64652__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64653 = conn_id;
var G__64654 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64655 = ref;
var G__64656 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64653,G__64654,G__64655,G__64656) : flureeworker.worker_action.call(null,G__64653,G__64654,G__64655,G__64656));
})());
var auth = null;
var c__2755__auto___64713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64677){
var state_val_64678 = (state_64677[(1)]);
if((state_val_64678 === (1))){
var state_64677__$1 = state_64677;
var statearr_64679_64714 = state_64677__$1;
(statearr_64679_64714[(2)] = null);

(statearr_64679_64714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64678 === (2))){
var ___$1 = (function (){var statearr_64680 = state_64677;
(statearr_64680[(4)] = cljs.core.cons((5),(state_64677[(4)])));

return statearr_64680;
})();
var inst_64668 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_64669 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64681 = conn_id;
var G__64682 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64683 = ref;
var G__64684 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64681,G__64682,G__64683,G__64684) : flureeworker.worker_action.call(null,G__64681,G__64682,G__64683,G__64684));
});
})();
var inst_64670 = inst_64668.then(inst_64669);
var inst_64671 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64685){var ___$2 = e64685;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64686 = conn_id;
var G__64687 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64688 = ref;
var G__64689 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64686,G__64687,G__64688,G__64689) : flureeworker.worker_action.call(null,G__64686,G__64687,G__64688,G__64689));
} else {
var G__64690 = conn_id;
var G__64691 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64692 = ref;
var G__64693 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64690,G__64691,G__64692,G__64693) : flureeworker.worker_action.call(null,G__64690,G__64691,G__64692,G__64693));

}
});
})();
var inst_64672 = inst_64670.catch(inst_64671);
var ___$2 = (function (){var statearr_64694 = state_64677;
(statearr_64694[(4)] = cljs.core.rest((state_64677[(4)])));

return statearr_64694;
})();
var state_64677__$1 = state_64677;
var statearr_64695_64715 = state_64677__$1;
(statearr_64695_64715[(2)] = inst_64672);

(statearr_64695_64715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64678 === (3))){
var inst_64675 = (state_64677[(2)]);
var state_64677__$1 = state_64677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64677__$1,inst_64675);
} else {
if((state_val_64678 === (4))){
var inst_64657 = (state_64677[(2)]);
var inst_64658 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64659 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64657);
var inst_64660 = [(400),inst_64659];
var inst_64661 = cljs.core.PersistentHashMap.fromArrays(inst_64658,inst_64660);
var inst_64662 = (function (){var G__64697 = conn_id;
var G__64698 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64699 = ref;
var G__64700 = inst_64661;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64697,G__64698,G__64699,G__64700) : flureeworker.worker_action.call(null,G__64697,G__64698,G__64699,G__64700));
})();
var state_64677__$1 = state_64677;
var statearr_64701_64716 = state_64677__$1;
(statearr_64701_64716[(2)] = inst_64662);

(statearr_64701_64716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64678 === (5))){
var ___$1 = (function (){var statearr_64702 = state_64677;
(statearr_64702[(4)] = cljs.core.rest((state_64677[(4)])));

return statearr_64702;
})();
var state_64677__$1 = state_64677;
var ex64696 = (state_64677__$1[(2)]);
var statearr_64703_64717 = state_64677__$1;
(statearr_64703_64717[(5)] = ex64696);


var statearr_64704_64718 = state_64677__$1;
(statearr_64704_64718[(1)] = (4));

(statearr_64704_64718[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2733__auto__ = null;
var flureeworker$state_machine__2733__auto____0 = (function (){
var statearr_64705 = [null,null,null,null,null,null,null];
(statearr_64705[(0)] = flureeworker$state_machine__2733__auto__);

(statearr_64705[(1)] = (1));

return statearr_64705;
});
var flureeworker$state_machine__2733__auto____1 = (function (state_64677){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64677);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64706){var ex__2736__auto__ = e64706;
var statearr_64707_64719 = state_64677;
(statearr_64707_64719[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64677[(4)]))){
var statearr_64708_64720 = state_64677;
(statearr_64708_64720[(1)] = cljs.core.first((state_64677[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64721 = state_64677;
state_64677 = G__64721;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureeworker$state_machine__2733__auto__ = function(state_64677){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2733__auto____0.call(this);
case 1:
return flureeworker$state_machine__2733__auto____1.call(this,state_64677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2733__auto____0;
flureeworker$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2733__auto____1;
return flureeworker$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64709 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64709[(6)] = c__2755__auto___64713);

return statearr_64709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq64643){
var G__64644 = cljs.core.first(seq64643);
var seq64643__$1 = cljs.core.next(seq64643);
var G__64645 = cljs.core.first(seq64643__$1);
var seq64643__$2 = cljs.core.next(seq64643__$1);
var G__64646 = cljs.core.first(seq64643__$2);
var seq64643__$3 = cljs.core.next(seq64643__$2);
var G__64647 = cljs.core.first(seq64643__$3);
var seq64643__$4 = cljs.core.next(seq64643__$3);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64644,G__64645,G__64646,G__64647,seq64643__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__64722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__64722__$1 = cljs.core.__destructure_map(map__64722);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64722__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64722__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__64724 = conn_id;
var G__64725 = new cljs.core.Keyword(null,"login","login",55217519);
var G__64726 = ref;
var G__64727 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64724,G__64725,G__64726,G__64727) : flureeworker.worker_action.call(null,G__64724,G__64725,G__64726,G__64727));
})());
var map__64723 = map_data;
var map__64723__$1 = cljs.core.__destructure_map(map__64723);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64723__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64723__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64723__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2755__auto___64781 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64748){
var state_val_64749 = (state_64748[(1)]);
if((state_val_64749 === (1))){
var state_64748__$1 = state_64748;
var statearr_64750_64782 = state_64748__$1;
(statearr_64750_64782[(2)] = null);

(statearr_64750_64782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64749 === (2))){
var ___$1 = (function (){var statearr_64751 = state_64748;
(statearr_64751[(4)] = cljs.core.cons((5),(state_64748[(4)])));

return statearr_64751;
})();
var inst_64739 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_64740 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__64752 = conn_id;
var G__64753 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64754 = ref;
var G__64755 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64752,G__64753,G__64754,G__64755) : flureeworker.worker_action.call(null,G__64752,G__64753,G__64754,G__64755));
});
})();
var inst_64741 = inst_64739.then(inst_64740);
var inst_64742 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e64756){var ___$2 = e64756;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__64757 = conn_id;
var G__64758 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64759 = ref;
var G__64760 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64757,G__64758,G__64759,G__64760) : flureeworker.worker_action.call(null,G__64757,G__64758,G__64759,G__64760));
} else {
var G__64761 = conn_id;
var G__64762 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64763 = ref;
var G__64764 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64761,G__64762,G__64763,G__64764) : flureeworker.worker_action.call(null,G__64761,G__64762,G__64763,G__64764));

}
});
})();
var inst_64743 = inst_64741.catch(inst_64742);
var ___$2 = (function (){var statearr_64765 = state_64748;
(statearr_64765[(4)] = cljs.core.rest((state_64748[(4)])));

return statearr_64765;
})();
var state_64748__$1 = state_64748;
var statearr_64766_64783 = state_64748__$1;
(statearr_64766_64783[(2)] = inst_64743);

(statearr_64766_64783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64749 === (3))){
var inst_64746 = (state_64748[(2)]);
var state_64748__$1 = state_64748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64748__$1,inst_64746);
} else {
if((state_val_64749 === (4))){
var inst_64728 = (state_64748[(2)]);
var inst_64729 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_64730 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64728);
var inst_64731 = [(400),inst_64730];
var inst_64732 = cljs.core.PersistentHashMap.fromArrays(inst_64729,inst_64731);
var inst_64733 = (function (){var G__64768 = conn_id;
var G__64769 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__64770 = ref;
var G__64771 = inst_64732;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__64768,G__64769,G__64770,G__64771) : flureeworker.worker_action.call(null,G__64768,G__64769,G__64770,G__64771));
})();
var state_64748__$1 = state_64748;
var statearr_64772_64784 = state_64748__$1;
(statearr_64772_64784[(2)] = inst_64733);

(statearr_64772_64784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64749 === (5))){
var ___$1 = (function (){var statearr_64773 = state_64748;
(statearr_64773[(4)] = cljs.core.rest((state_64748[(4)])));

return statearr_64773;
})();
var state_64748__$1 = state_64748;
var ex64767 = (state_64748__$1[(2)]);
var statearr_64774_64785 = state_64748__$1;
(statearr_64774_64785[(5)] = ex64767);


var statearr_64775_64786 = state_64748__$1;
(statearr_64775_64786[(1)] = (4));

(statearr_64775_64786[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2733__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2733__auto____0 = (function (){
var statearr_64776 = [null,null,null,null,null,null,null];
(statearr_64776[(0)] = flureeworker$pw_generate_$_state_machine__2733__auto__);

(statearr_64776[(1)] = (1));

return statearr_64776;
});
var flureeworker$pw_generate_$_state_machine__2733__auto____1 = (function (state_64748){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64748);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64777){var ex__2736__auto__ = e64777;
var statearr_64778_64787 = state_64748;
(statearr_64778_64787[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64748[(4)]))){
var statearr_64779_64788 = state_64748;
(statearr_64779_64788[(1)] = cljs.core.first((state_64748[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64789 = state_64748;
state_64748 = G__64789;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2733__auto__ = function(state_64748){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2733__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2733__auto____1.call(this,state_64748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2733__auto____0;
flureeworker$pw_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2733__auto____1;
return flureeworker$pw_generate_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64780 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64780[(6)] = c__2755__auto___64781);

return statearr_64780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64790_SHARP_){
return (js_array[p1__64790_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e64791){var e = e64791;
var data = (event["data"]);
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5753__auto___64792 = cljs.core.not(self.document);
if(temp__5753__auto___64792){
var worker_QMARK__64793 = temp__5753__auto___64792;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__64794_64796 = null;
var G__64795_64797 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__64794_64796,G__64795_64797) : flureeworker.worker_action.call(null,G__64794_64796,G__64795_64797));
