// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__12110){
var vec__12111 = p__12110;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12111,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12111,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__12114 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12114,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12114,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12114,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12114,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12114,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5753__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__12117 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12117,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12117,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12117,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12117,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12117,(4),null);
var vec__12120 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12120,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12120,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12120,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12120,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12120,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4223__auto__ = source;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4223__auto__ = line;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4223__auto__ = col;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__12123 = segmap;
var map__12123__$1 = cljs.core.__destructure_map(map__12123);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12123__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12123__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12123__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12123__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12123__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__12125 = arguments.length;
switch (G__12125) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12129 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__12133 = cljs.core.next(segs__$1);
var G__12134 = nrelseg;
var G__12135 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__12133;
relseg__$1 = G__12134;
result__$1 = G__12135;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12129,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12129,(1),null);
var G__12136 = (gline + (1));
var G__12137 = cljs.core.next(lines__$1);
var G__12138 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__12139 = result__$1;
gline = G__12136;
lines__$1 = G__12137;
relseg = G__12138;
result = G__12139;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__12141 = segmap;
var map__12141__$1 = cljs.core.__destructure_map(map__12141);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12141__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12141__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12141__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12141__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12141__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__12140_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__12140_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__12143 = arguments.length;
switch (G__12143) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__12147 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__12151 = cljs.core.next(segs__$1);
var G__12152 = nrelseg;
var G__12153 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__12151;
relseg__$1 = G__12152;
result__$1 = G__12153;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12147,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12147,(1),null);
var G__12154 = (gline + (1));
var G__12155 = cljs.core.next(lines__$1);
var G__12156 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__12157 = result__$1;
gline = G__12154;
lines__$1 = G__12155;
relseg = G__12156;
result = G__12157;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12158){
var vec__12159 = p__12158;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12159,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12159,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12159,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12159,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12159,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__12162){
var vec__12163 = p__12162;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163,(4),null);
var seg = vec__12163;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__12166){
var vec__12167 = p__12166;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12167,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12167,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12167,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12167,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12167,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__12173 = cljs.core.seq(infos);
var chunk__12174 = null;
var count__12175 = (0);
var i__12176 = (0);
while(true){
if((i__12176 < count__12175)){
var info = chunk__12174.cljs$core$IIndexed$_nth$arity$2(null,i__12176);
var segv_12527 = info__GT_segv(info,source_idx,line,col);
var gline_12528 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_12529 = cljs.core.count(cljs.core.deref(lines));
if((gline_12528 > (lc_12529 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12173,chunk__12174,count__12175,i__12176,segv_12527,gline_12528,lc_12529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_12528 - (lc_12529 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_12527], null));
});})(seq__12173,chunk__12174,count__12175,i__12176,segv_12527,gline_12528,lc_12529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12173,chunk__12174,count__12175,i__12176,segv_12527,gline_12528,lc_12529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12528], null),cljs.core.conj,segv_12527);
});})(seq__12173,chunk__12174,count__12175,i__12176,segv_12527,gline_12528,lc_12529,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__12530 = seq__12173;
var G__12531 = chunk__12174;
var G__12532 = count__12175;
var G__12533 = (i__12176 + (1));
seq__12173 = G__12530;
chunk__12174 = G__12531;
count__12175 = G__12532;
i__12176 = G__12533;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__12173);
if(temp__5753__auto__){
var seq__12173__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12173__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__12173__$1);
var G__12534 = cljs.core.chunk_rest(seq__12173__$1);
var G__12535 = c__4649__auto__;
var G__12536 = cljs.core.count(c__4649__auto__);
var G__12537 = (0);
seq__12173 = G__12534;
chunk__12174 = G__12535;
count__12175 = G__12536;
i__12176 = G__12537;
continue;
} else {
var info = cljs.core.first(seq__12173__$1);
var segv_12538 = info__GT_segv(info,source_idx,line,col);
var gline_12539 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_12540 = cljs.core.count(cljs.core.deref(lines));
if((gline_12539 > (lc_12540 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12173,chunk__12174,count__12175,i__12176,segv_12538,gline_12539,lc_12540,info,seq__12173__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_12539 - (lc_12540 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_12538], null));
});})(seq__12173,chunk__12174,count__12175,i__12176,segv_12538,gline_12539,lc_12540,info,seq__12173__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__12173,chunk__12174,count__12175,i__12176,segv_12538,gline_12539,lc_12540,info,seq__12173__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12539], null),cljs.core.conj,segv_12538);
});})(seq__12173,chunk__12174,count__12175,i__12176,segv_12538,gline_12539,lc_12540,info,seq__12173__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__12541 = cljs.core.next(seq__12173__$1);
var G__12542 = null;
var G__12543 = (0);
var G__12544 = (0);
seq__12173 = G__12541;
chunk__12174 = G__12542;
count__12175 = G__12543;
i__12176 = G__12544;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__12177_12545 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__12178_12546 = null;
var count__12179_12547 = (0);
var i__12180_12548 = (0);
while(true){
if((i__12180_12548 < count__12179_12547)){
var vec__12353_12549 = chunk__12178_12546.cljs$core$IIndexed$_nth$arity$2(null,i__12180_12548);
var source_idx_12550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12353_12549,(0),null);
var vec__12356_12551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12353_12549,(1),null);
var __12552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12356_12551,(0),null);
var lines_12553__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12356_12551,(1),null);
var seq__12359_12554 = cljs.core.seq(lines_12553__$1);
var chunk__12360_12555 = null;
var count__12361_12556 = (0);
var i__12362_12557 = (0);
while(true){
if((i__12362_12557 < count__12361_12556)){
var vec__12401_12558 = chunk__12360_12555.cljs$core$IIndexed$_nth$arity$2(null,i__12362_12557);
var line_12559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12401_12558,(0),null);
var cols_12560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12401_12558,(1),null);
var seq__12404_12561 = cljs.core.seq(cols_12560);
var chunk__12405_12562 = null;
var count__12406_12563 = (0);
var i__12407_12564 = (0);
while(true){
if((i__12407_12564 < count__12406_12563)){
var vec__12414_12565 = chunk__12405_12562.cljs$core$IIndexed$_nth$arity$2(null,i__12407_12564);
var col_12566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12414_12565,(0),null);
var infos_12567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12414_12565,(1),null);
encode_cols(infos_12567,source_idx_12550,line_12559,col_12566);


var G__12568 = seq__12404_12561;
var G__12569 = chunk__12405_12562;
var G__12570 = count__12406_12563;
var G__12571 = (i__12407_12564 + (1));
seq__12404_12561 = G__12568;
chunk__12405_12562 = G__12569;
count__12406_12563 = G__12570;
i__12407_12564 = G__12571;
continue;
} else {
var temp__5753__auto___12572 = cljs.core.seq(seq__12404_12561);
if(temp__5753__auto___12572){
var seq__12404_12573__$1 = temp__5753__auto___12572;
if(cljs.core.chunked_seq_QMARK_(seq__12404_12573__$1)){
var c__4649__auto___12574 = cljs.core.chunk_first(seq__12404_12573__$1);
var G__12575 = cljs.core.chunk_rest(seq__12404_12573__$1);
var G__12576 = c__4649__auto___12574;
var G__12577 = cljs.core.count(c__4649__auto___12574);
var G__12578 = (0);
seq__12404_12561 = G__12575;
chunk__12405_12562 = G__12576;
count__12406_12563 = G__12577;
i__12407_12564 = G__12578;
continue;
} else {
var vec__12417_12579 = cljs.core.first(seq__12404_12573__$1);
var col_12580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12417_12579,(0),null);
var infos_12581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12417_12579,(1),null);
encode_cols(infos_12581,source_idx_12550,line_12559,col_12580);


var G__12582 = cljs.core.next(seq__12404_12573__$1);
var G__12583 = null;
var G__12584 = (0);
var G__12585 = (0);
seq__12404_12561 = G__12582;
chunk__12405_12562 = G__12583;
count__12406_12563 = G__12584;
i__12407_12564 = G__12585;
continue;
}
} else {
}
}
break;
}


var G__12586 = seq__12359_12554;
var G__12587 = chunk__12360_12555;
var G__12588 = count__12361_12556;
var G__12589 = (i__12362_12557 + (1));
seq__12359_12554 = G__12586;
chunk__12360_12555 = G__12587;
count__12361_12556 = G__12588;
i__12362_12557 = G__12589;
continue;
} else {
var temp__5753__auto___12590 = cljs.core.seq(seq__12359_12554);
if(temp__5753__auto___12590){
var seq__12359_12591__$1 = temp__5753__auto___12590;
if(cljs.core.chunked_seq_QMARK_(seq__12359_12591__$1)){
var c__4649__auto___12592 = cljs.core.chunk_first(seq__12359_12591__$1);
var G__12593 = cljs.core.chunk_rest(seq__12359_12591__$1);
var G__12594 = c__4649__auto___12592;
var G__12595 = cljs.core.count(c__4649__auto___12592);
var G__12596 = (0);
seq__12359_12554 = G__12593;
chunk__12360_12555 = G__12594;
count__12361_12556 = G__12595;
i__12362_12557 = G__12596;
continue;
} else {
var vec__12420_12597 = cljs.core.first(seq__12359_12591__$1);
var line_12598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12420_12597,(0),null);
var cols_12599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12420_12597,(1),null);
var seq__12423_12600 = cljs.core.seq(cols_12599);
var chunk__12424_12601 = null;
var count__12425_12602 = (0);
var i__12426_12603 = (0);
while(true){
if((i__12426_12603 < count__12425_12602)){
var vec__12433_12604 = chunk__12424_12601.cljs$core$IIndexed$_nth$arity$2(null,i__12426_12603);
var col_12605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12433_12604,(0),null);
var infos_12606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12433_12604,(1),null);
encode_cols(infos_12606,source_idx_12550,line_12598,col_12605);


var G__12607 = seq__12423_12600;
var G__12608 = chunk__12424_12601;
var G__12609 = count__12425_12602;
var G__12610 = (i__12426_12603 + (1));
seq__12423_12600 = G__12607;
chunk__12424_12601 = G__12608;
count__12425_12602 = G__12609;
i__12426_12603 = G__12610;
continue;
} else {
var temp__5753__auto___12611__$1 = cljs.core.seq(seq__12423_12600);
if(temp__5753__auto___12611__$1){
var seq__12423_12612__$1 = temp__5753__auto___12611__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12423_12612__$1)){
var c__4649__auto___12613 = cljs.core.chunk_first(seq__12423_12612__$1);
var G__12614 = cljs.core.chunk_rest(seq__12423_12612__$1);
var G__12615 = c__4649__auto___12613;
var G__12616 = cljs.core.count(c__4649__auto___12613);
var G__12617 = (0);
seq__12423_12600 = G__12614;
chunk__12424_12601 = G__12615;
count__12425_12602 = G__12616;
i__12426_12603 = G__12617;
continue;
} else {
var vec__12436_12618 = cljs.core.first(seq__12423_12612__$1);
var col_12619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12436_12618,(0),null);
var infos_12620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12436_12618,(1),null);
encode_cols(infos_12620,source_idx_12550,line_12598,col_12619);


var G__12621 = cljs.core.next(seq__12423_12612__$1);
var G__12622 = null;
var G__12623 = (0);
var G__12624 = (0);
seq__12423_12600 = G__12621;
chunk__12424_12601 = G__12622;
count__12425_12602 = G__12623;
i__12426_12603 = G__12624;
continue;
}
} else {
}
}
break;
}


var G__12625 = cljs.core.next(seq__12359_12591__$1);
var G__12626 = null;
var G__12627 = (0);
var G__12628 = (0);
seq__12359_12554 = G__12625;
chunk__12360_12555 = G__12626;
count__12361_12556 = G__12627;
i__12362_12557 = G__12628;
continue;
}
} else {
}
}
break;
}


var G__12629 = seq__12177_12545;
var G__12630 = chunk__12178_12546;
var G__12631 = count__12179_12547;
var G__12632 = (i__12180_12548 + (1));
seq__12177_12545 = G__12629;
chunk__12178_12546 = G__12630;
count__12179_12547 = G__12631;
i__12180_12548 = G__12632;
continue;
} else {
var temp__5753__auto___12633 = cljs.core.seq(seq__12177_12545);
if(temp__5753__auto___12633){
var seq__12177_12634__$1 = temp__5753__auto___12633;
if(cljs.core.chunked_seq_QMARK_(seq__12177_12634__$1)){
var c__4649__auto___12635 = cljs.core.chunk_first(seq__12177_12634__$1);
var G__12636 = cljs.core.chunk_rest(seq__12177_12634__$1);
var G__12637 = c__4649__auto___12635;
var G__12638 = cljs.core.count(c__4649__auto___12635);
var G__12639 = (0);
seq__12177_12545 = G__12636;
chunk__12178_12546 = G__12637;
count__12179_12547 = G__12638;
i__12180_12548 = G__12639;
continue;
} else {
var vec__12439_12640 = cljs.core.first(seq__12177_12634__$1);
var source_idx_12641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12439_12640,(0),null);
var vec__12442_12642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12439_12640,(1),null);
var __12643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12442_12642,(0),null);
var lines_12644__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12442_12642,(1),null);
var seq__12445_12645 = cljs.core.seq(lines_12644__$1);
var chunk__12446_12646 = null;
var count__12447_12647 = (0);
var i__12448_12648 = (0);
while(true){
if((i__12448_12648 < count__12447_12647)){
var vec__12487_12649 = chunk__12446_12646.cljs$core$IIndexed$_nth$arity$2(null,i__12448_12648);
var line_12650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12487_12649,(0),null);
var cols_12651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12487_12649,(1),null);
var seq__12490_12652 = cljs.core.seq(cols_12651);
var chunk__12491_12653 = null;
var count__12492_12654 = (0);
var i__12493_12655 = (0);
while(true){
if((i__12493_12655 < count__12492_12654)){
var vec__12500_12656 = chunk__12491_12653.cljs$core$IIndexed$_nth$arity$2(null,i__12493_12655);
var col_12657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12500_12656,(0),null);
var infos_12658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12500_12656,(1),null);
encode_cols(infos_12658,source_idx_12641,line_12650,col_12657);


var G__12659 = seq__12490_12652;
var G__12660 = chunk__12491_12653;
var G__12661 = count__12492_12654;
var G__12662 = (i__12493_12655 + (1));
seq__12490_12652 = G__12659;
chunk__12491_12653 = G__12660;
count__12492_12654 = G__12661;
i__12493_12655 = G__12662;
continue;
} else {
var temp__5753__auto___12663__$1 = cljs.core.seq(seq__12490_12652);
if(temp__5753__auto___12663__$1){
var seq__12490_12664__$1 = temp__5753__auto___12663__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12490_12664__$1)){
var c__4649__auto___12665 = cljs.core.chunk_first(seq__12490_12664__$1);
var G__12666 = cljs.core.chunk_rest(seq__12490_12664__$1);
var G__12667 = c__4649__auto___12665;
var G__12668 = cljs.core.count(c__4649__auto___12665);
var G__12669 = (0);
seq__12490_12652 = G__12666;
chunk__12491_12653 = G__12667;
count__12492_12654 = G__12668;
i__12493_12655 = G__12669;
continue;
} else {
var vec__12503_12670 = cljs.core.first(seq__12490_12664__$1);
var col_12671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12503_12670,(0),null);
var infos_12672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12503_12670,(1),null);
encode_cols(infos_12672,source_idx_12641,line_12650,col_12671);


var G__12673 = cljs.core.next(seq__12490_12664__$1);
var G__12674 = null;
var G__12675 = (0);
var G__12676 = (0);
seq__12490_12652 = G__12673;
chunk__12491_12653 = G__12674;
count__12492_12654 = G__12675;
i__12493_12655 = G__12676;
continue;
}
} else {
}
}
break;
}


var G__12677 = seq__12445_12645;
var G__12678 = chunk__12446_12646;
var G__12679 = count__12447_12647;
var G__12680 = (i__12448_12648 + (1));
seq__12445_12645 = G__12677;
chunk__12446_12646 = G__12678;
count__12447_12647 = G__12679;
i__12448_12648 = G__12680;
continue;
} else {
var temp__5753__auto___12681__$1 = cljs.core.seq(seq__12445_12645);
if(temp__5753__auto___12681__$1){
var seq__12445_12682__$1 = temp__5753__auto___12681__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12445_12682__$1)){
var c__4649__auto___12683 = cljs.core.chunk_first(seq__12445_12682__$1);
var G__12684 = cljs.core.chunk_rest(seq__12445_12682__$1);
var G__12685 = c__4649__auto___12683;
var G__12686 = cljs.core.count(c__4649__auto___12683);
var G__12687 = (0);
seq__12445_12645 = G__12684;
chunk__12446_12646 = G__12685;
count__12447_12647 = G__12686;
i__12448_12648 = G__12687;
continue;
} else {
var vec__12506_12688 = cljs.core.first(seq__12445_12682__$1);
var line_12689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12506_12688,(0),null);
var cols_12690 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12506_12688,(1),null);
var seq__12509_12691 = cljs.core.seq(cols_12690);
var chunk__12510_12692 = null;
var count__12511_12693 = (0);
var i__12512_12694 = (0);
while(true){
if((i__12512_12694 < count__12511_12693)){
var vec__12519_12695 = chunk__12510_12692.cljs$core$IIndexed$_nth$arity$2(null,i__12512_12694);
var col_12696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12519_12695,(0),null);
var infos_12697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12519_12695,(1),null);
encode_cols(infos_12697,source_idx_12641,line_12689,col_12696);


var G__12698 = seq__12509_12691;
var G__12699 = chunk__12510_12692;
var G__12700 = count__12511_12693;
var G__12701 = (i__12512_12694 + (1));
seq__12509_12691 = G__12698;
chunk__12510_12692 = G__12699;
count__12511_12693 = G__12700;
i__12512_12694 = G__12701;
continue;
} else {
var temp__5753__auto___12702__$2 = cljs.core.seq(seq__12509_12691);
if(temp__5753__auto___12702__$2){
var seq__12509_12703__$1 = temp__5753__auto___12702__$2;
if(cljs.core.chunked_seq_QMARK_(seq__12509_12703__$1)){
var c__4649__auto___12704 = cljs.core.chunk_first(seq__12509_12703__$1);
var G__12705 = cljs.core.chunk_rest(seq__12509_12703__$1);
var G__12706 = c__4649__auto___12704;
var G__12707 = cljs.core.count(c__4649__auto___12704);
var G__12708 = (0);
seq__12509_12691 = G__12705;
chunk__12510_12692 = G__12706;
count__12511_12693 = G__12707;
i__12512_12694 = G__12708;
continue;
} else {
var vec__12522_12709 = cljs.core.first(seq__12509_12703__$1);
var col_12710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12522_12709,(0),null);
var infos_12711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12522_12709,(1),null);
encode_cols(infos_12711,source_idx_12641,line_12689,col_12710);


var G__12712 = cljs.core.next(seq__12509_12703__$1);
var G__12713 = null;
var G__12714 = (0);
var G__12715 = (0);
seq__12509_12691 = G__12712;
chunk__12510_12692 = G__12713;
count__12511_12693 = G__12714;
i__12512_12694 = G__12715;
continue;
}
} else {
}
}
break;
}


var G__12716 = cljs.core.next(seq__12445_12682__$1);
var G__12717 = null;
var G__12718 = (0);
var G__12719 = (0);
seq__12445_12645 = G__12716;
chunk__12446_12646 = G__12717;
count__12447_12647 = G__12718;
i__12448_12648 = G__12719;
continue;
}
} else {
}
}
break;
}


var G__12720 = cljs.core.next(seq__12177_12634__$1);
var G__12721 = null;
var G__12722 = (0);
var G__12723 = (0);
seq__12177_12545 = G__12720;
chunk__12178_12546 = G__12721;
count__12179_12547 = G__12722;
i__12180_12548 = G__12723;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__12525 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__12170_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__12170_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__12171_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__12171_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12172_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__12172_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__12526 = G__12525;
goog.object.set(G__12526,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__12526;
} else {
return G__12525;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__12724 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12724,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12724,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__12727 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12727,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12727,(1),null);
var G__12732 = cljs.core.next(col_map_seq);
var G__12733 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__12727,col,infos,vec__12724,line,col_map){
return (function (v,p__12730){
var map__12731 = p__12730;
var map__12731__$1 = cljs.core.__destructure_map(map__12731);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12731__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12731__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__12727,col,infos,vec__12724,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__12732;
new_cols = G__12733;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__12734 = cljs.core.next(line_map_seq);
var G__12735 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__12734;
new_lines = G__12735;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__12736_12944 = cljs.core.seq(reverse_map);
var chunk__12737_12945 = null;
var count__12738_12946 = (0);
var i__12739_12947 = (0);
while(true){
if((i__12739_12947 < count__12738_12946)){
var vec__12842_12948 = chunk__12737_12945.cljs$core$IIndexed$_nth$arity$2(null,i__12739_12947);
var line_12949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12842_12948,(0),null);
var columns_12950 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12842_12948,(1),null);
var seq__12845_12951 = cljs.core.seq(columns_12950);
var chunk__12846_12952 = null;
var count__12847_12953 = (0);
var i__12848_12954 = (0);
while(true){
if((i__12848_12954 < count__12847_12953)){
var vec__12871_12955 = chunk__12846_12952.cljs$core$IIndexed$_nth$arity$2(null,i__12848_12954);
var column_12956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12871_12955,(0),null);
var column_info_12957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12871_12955,(1),null);
var seq__12874_12958 = cljs.core.seq(column_info_12957);
var chunk__12875_12959 = null;
var count__12876_12960 = (0);
var i__12877_12961 = (0);
while(true){
if((i__12877_12961 < count__12876_12960)){
var map__12880_12962 = chunk__12875_12959.cljs$core$IIndexed$_nth$arity$2(null,i__12877_12961);
var map__12880_12963__$1 = cljs.core.__destructure_map(map__12880_12962);
var gline_12964 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12880_12963__$1,cljs.core.cst$kw$gline);
var gcol_12965 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12880_12963__$1,cljs.core.cst$kw$gcol);
var name_12966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12880_12963__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12964], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12874_12958,chunk__12875_12959,count__12876_12960,i__12877_12961,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12880_12962,map__12880_12963__$1,gline_12964,gcol_12965,name_12966,vec__12871_12955,column_12956,column_info_12957,vec__12842_12948,line_12949,columns_12950,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12965], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12949,cljs.core.cst$kw$col,column_12956,cljs.core.cst$kw$name,name_12966], null));
});})(seq__12874_12958,chunk__12875_12959,count__12876_12960,i__12877_12961,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12880_12962,map__12880_12963__$1,gline_12964,gcol_12965,name_12966,vec__12871_12955,column_12956,column_info_12957,vec__12842_12948,line_12949,columns_12950,inverted))
,cljs.core.sorted_map()));


var G__12967 = seq__12874_12958;
var G__12968 = chunk__12875_12959;
var G__12969 = count__12876_12960;
var G__12970 = (i__12877_12961 + (1));
seq__12874_12958 = G__12967;
chunk__12875_12959 = G__12968;
count__12876_12960 = G__12969;
i__12877_12961 = G__12970;
continue;
} else {
var temp__5753__auto___12971 = cljs.core.seq(seq__12874_12958);
if(temp__5753__auto___12971){
var seq__12874_12972__$1 = temp__5753__auto___12971;
if(cljs.core.chunked_seq_QMARK_(seq__12874_12972__$1)){
var c__4649__auto___12973 = cljs.core.chunk_first(seq__12874_12972__$1);
var G__12974 = cljs.core.chunk_rest(seq__12874_12972__$1);
var G__12975 = c__4649__auto___12973;
var G__12976 = cljs.core.count(c__4649__auto___12973);
var G__12977 = (0);
seq__12874_12958 = G__12974;
chunk__12875_12959 = G__12975;
count__12876_12960 = G__12976;
i__12877_12961 = G__12977;
continue;
} else {
var map__12881_12978 = cljs.core.first(seq__12874_12972__$1);
var map__12881_12979__$1 = cljs.core.__destructure_map(map__12881_12978);
var gline_12980 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12881_12979__$1,cljs.core.cst$kw$gline);
var gcol_12981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12881_12979__$1,cljs.core.cst$kw$gcol);
var name_12982 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12881_12979__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_12980], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12874_12958,chunk__12875_12959,count__12876_12960,i__12877_12961,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12881_12978,map__12881_12979__$1,gline_12980,gcol_12981,name_12982,seq__12874_12972__$1,temp__5753__auto___12971,vec__12871_12955,column_12956,column_info_12957,vec__12842_12948,line_12949,columns_12950,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_12981], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12949,cljs.core.cst$kw$col,column_12956,cljs.core.cst$kw$name,name_12982], null));
});})(seq__12874_12958,chunk__12875_12959,count__12876_12960,i__12877_12961,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12881_12978,map__12881_12979__$1,gline_12980,gcol_12981,name_12982,seq__12874_12972__$1,temp__5753__auto___12971,vec__12871_12955,column_12956,column_info_12957,vec__12842_12948,line_12949,columns_12950,inverted))
,cljs.core.sorted_map()));


var G__12983 = cljs.core.next(seq__12874_12972__$1);
var G__12984 = null;
var G__12985 = (0);
var G__12986 = (0);
seq__12874_12958 = G__12983;
chunk__12875_12959 = G__12984;
count__12876_12960 = G__12985;
i__12877_12961 = G__12986;
continue;
}
} else {
}
}
break;
}


var G__12987 = seq__12845_12951;
var G__12988 = chunk__12846_12952;
var G__12989 = count__12847_12953;
var G__12990 = (i__12848_12954 + (1));
seq__12845_12951 = G__12987;
chunk__12846_12952 = G__12988;
count__12847_12953 = G__12989;
i__12848_12954 = G__12990;
continue;
} else {
var temp__5753__auto___12991 = cljs.core.seq(seq__12845_12951);
if(temp__5753__auto___12991){
var seq__12845_12992__$1 = temp__5753__auto___12991;
if(cljs.core.chunked_seq_QMARK_(seq__12845_12992__$1)){
var c__4649__auto___12993 = cljs.core.chunk_first(seq__12845_12992__$1);
var G__12994 = cljs.core.chunk_rest(seq__12845_12992__$1);
var G__12995 = c__4649__auto___12993;
var G__12996 = cljs.core.count(c__4649__auto___12993);
var G__12997 = (0);
seq__12845_12951 = G__12994;
chunk__12846_12952 = G__12995;
count__12847_12953 = G__12996;
i__12848_12954 = G__12997;
continue;
} else {
var vec__12882_12998 = cljs.core.first(seq__12845_12992__$1);
var column_12999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12882_12998,(0),null);
var column_info_13000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12882_12998,(1),null);
var seq__12885_13001 = cljs.core.seq(column_info_13000);
var chunk__12886_13002 = null;
var count__12887_13003 = (0);
var i__12888_13004 = (0);
while(true){
if((i__12888_13004 < count__12887_13003)){
var map__12891_13005 = chunk__12886_13002.cljs$core$IIndexed$_nth$arity$2(null,i__12888_13004);
var map__12891_13006__$1 = cljs.core.__destructure_map(map__12891_13005);
var gline_13007 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12891_13006__$1,cljs.core.cst$kw$gline);
var gcol_13008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12891_13006__$1,cljs.core.cst$kw$gcol);
var name_13009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12891_13006__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13007], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12885_13001,chunk__12886_13002,count__12887_13003,i__12888_13004,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12891_13005,map__12891_13006__$1,gline_13007,gcol_13008,name_13009,vec__12882_12998,column_12999,column_info_13000,seq__12845_12992__$1,temp__5753__auto___12991,vec__12842_12948,line_12949,columns_12950,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_13008], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12949,cljs.core.cst$kw$col,column_12999,cljs.core.cst$kw$name,name_13009], null));
});})(seq__12885_13001,chunk__12886_13002,count__12887_13003,i__12888_13004,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12891_13005,map__12891_13006__$1,gline_13007,gcol_13008,name_13009,vec__12882_12998,column_12999,column_info_13000,seq__12845_12992__$1,temp__5753__auto___12991,vec__12842_12948,line_12949,columns_12950,inverted))
,cljs.core.sorted_map()));


var G__13010 = seq__12885_13001;
var G__13011 = chunk__12886_13002;
var G__13012 = count__12887_13003;
var G__13013 = (i__12888_13004 + (1));
seq__12885_13001 = G__13010;
chunk__12886_13002 = G__13011;
count__12887_13003 = G__13012;
i__12888_13004 = G__13013;
continue;
} else {
var temp__5753__auto___13014__$1 = cljs.core.seq(seq__12885_13001);
if(temp__5753__auto___13014__$1){
var seq__12885_13015__$1 = temp__5753__auto___13014__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12885_13015__$1)){
var c__4649__auto___13016 = cljs.core.chunk_first(seq__12885_13015__$1);
var G__13017 = cljs.core.chunk_rest(seq__12885_13015__$1);
var G__13018 = c__4649__auto___13016;
var G__13019 = cljs.core.count(c__4649__auto___13016);
var G__13020 = (0);
seq__12885_13001 = G__13017;
chunk__12886_13002 = G__13018;
count__12887_13003 = G__13019;
i__12888_13004 = G__13020;
continue;
} else {
var map__12892_13021 = cljs.core.first(seq__12885_13015__$1);
var map__12892_13022__$1 = cljs.core.__destructure_map(map__12892_13021);
var gline_13023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12892_13022__$1,cljs.core.cst$kw$gline);
var gcol_13024 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12892_13022__$1,cljs.core.cst$kw$gcol);
var name_13025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12892_13022__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13023], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12885_13001,chunk__12886_13002,count__12887_13003,i__12888_13004,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12892_13021,map__12892_13022__$1,gline_13023,gcol_13024,name_13025,seq__12885_13015__$1,temp__5753__auto___13014__$1,vec__12882_12998,column_12999,column_info_13000,seq__12845_12992__$1,temp__5753__auto___12991,vec__12842_12948,line_12949,columns_12950,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_13024], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_12949,cljs.core.cst$kw$col,column_12999,cljs.core.cst$kw$name,name_13025], null));
});})(seq__12885_13001,chunk__12886_13002,count__12887_13003,i__12888_13004,seq__12845_12951,chunk__12846_12952,count__12847_12953,i__12848_12954,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12892_13021,map__12892_13022__$1,gline_13023,gcol_13024,name_13025,seq__12885_13015__$1,temp__5753__auto___13014__$1,vec__12882_12998,column_12999,column_info_13000,seq__12845_12992__$1,temp__5753__auto___12991,vec__12842_12948,line_12949,columns_12950,inverted))
,cljs.core.sorted_map()));


var G__13026 = cljs.core.next(seq__12885_13015__$1);
var G__13027 = null;
var G__13028 = (0);
var G__13029 = (0);
seq__12885_13001 = G__13026;
chunk__12886_13002 = G__13027;
count__12887_13003 = G__13028;
i__12888_13004 = G__13029;
continue;
}
} else {
}
}
break;
}


var G__13030 = cljs.core.next(seq__12845_12992__$1);
var G__13031 = null;
var G__13032 = (0);
var G__13033 = (0);
seq__12845_12951 = G__13030;
chunk__12846_12952 = G__13031;
count__12847_12953 = G__13032;
i__12848_12954 = G__13033;
continue;
}
} else {
}
}
break;
}


var G__13034 = seq__12736_12944;
var G__13035 = chunk__12737_12945;
var G__13036 = count__12738_12946;
var G__13037 = (i__12739_12947 + (1));
seq__12736_12944 = G__13034;
chunk__12737_12945 = G__13035;
count__12738_12946 = G__13036;
i__12739_12947 = G__13037;
continue;
} else {
var temp__5753__auto___13038 = cljs.core.seq(seq__12736_12944);
if(temp__5753__auto___13038){
var seq__12736_13039__$1 = temp__5753__auto___13038;
if(cljs.core.chunked_seq_QMARK_(seq__12736_13039__$1)){
var c__4649__auto___13040 = cljs.core.chunk_first(seq__12736_13039__$1);
var G__13041 = cljs.core.chunk_rest(seq__12736_13039__$1);
var G__13042 = c__4649__auto___13040;
var G__13043 = cljs.core.count(c__4649__auto___13040);
var G__13044 = (0);
seq__12736_12944 = G__13041;
chunk__12737_12945 = G__13042;
count__12738_12946 = G__13043;
i__12739_12947 = G__13044;
continue;
} else {
var vec__12893_13045 = cljs.core.first(seq__12736_13039__$1);
var line_13046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12893_13045,(0),null);
var columns_13047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12893_13045,(1),null);
var seq__12896_13048 = cljs.core.seq(columns_13047);
var chunk__12897_13049 = null;
var count__12898_13050 = (0);
var i__12899_13051 = (0);
while(true){
if((i__12899_13051 < count__12898_13050)){
var vec__12922_13052 = chunk__12897_13049.cljs$core$IIndexed$_nth$arity$2(null,i__12899_13051);
var column_13053 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12922_13052,(0),null);
var column_info_13054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12922_13052,(1),null);
var seq__12925_13055 = cljs.core.seq(column_info_13054);
var chunk__12926_13056 = null;
var count__12927_13057 = (0);
var i__12928_13058 = (0);
while(true){
if((i__12928_13058 < count__12927_13057)){
var map__12931_13059 = chunk__12926_13056.cljs$core$IIndexed$_nth$arity$2(null,i__12928_13058);
var map__12931_13060__$1 = cljs.core.__destructure_map(map__12931_13059);
var gline_13061 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12931_13060__$1,cljs.core.cst$kw$gline);
var gcol_13062 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12931_13060__$1,cljs.core.cst$kw$gcol);
var name_13063 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12931_13060__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13061], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12925_13055,chunk__12926_13056,count__12927_13057,i__12928_13058,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12931_13059,map__12931_13060__$1,gline_13061,gcol_13062,name_13063,vec__12922_13052,column_13053,column_info_13054,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_13062], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_13046,cljs.core.cst$kw$col,column_13053,cljs.core.cst$kw$name,name_13063], null));
});})(seq__12925_13055,chunk__12926_13056,count__12927_13057,i__12928_13058,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12931_13059,map__12931_13060__$1,gline_13061,gcol_13062,name_13063,vec__12922_13052,column_13053,column_info_13054,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted))
,cljs.core.sorted_map()));


var G__13064 = seq__12925_13055;
var G__13065 = chunk__12926_13056;
var G__13066 = count__12927_13057;
var G__13067 = (i__12928_13058 + (1));
seq__12925_13055 = G__13064;
chunk__12926_13056 = G__13065;
count__12927_13057 = G__13066;
i__12928_13058 = G__13067;
continue;
} else {
var temp__5753__auto___13068__$1 = cljs.core.seq(seq__12925_13055);
if(temp__5753__auto___13068__$1){
var seq__12925_13069__$1 = temp__5753__auto___13068__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12925_13069__$1)){
var c__4649__auto___13070 = cljs.core.chunk_first(seq__12925_13069__$1);
var G__13071 = cljs.core.chunk_rest(seq__12925_13069__$1);
var G__13072 = c__4649__auto___13070;
var G__13073 = cljs.core.count(c__4649__auto___13070);
var G__13074 = (0);
seq__12925_13055 = G__13071;
chunk__12926_13056 = G__13072;
count__12927_13057 = G__13073;
i__12928_13058 = G__13074;
continue;
} else {
var map__12932_13075 = cljs.core.first(seq__12925_13069__$1);
var map__12932_13076__$1 = cljs.core.__destructure_map(map__12932_13075);
var gline_13077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12932_13076__$1,cljs.core.cst$kw$gline);
var gcol_13078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12932_13076__$1,cljs.core.cst$kw$gcol);
var name_13079 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12932_13076__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13077], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12925_13055,chunk__12926_13056,count__12927_13057,i__12928_13058,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12932_13075,map__12932_13076__$1,gline_13077,gcol_13078,name_13079,seq__12925_13069__$1,temp__5753__auto___13068__$1,vec__12922_13052,column_13053,column_info_13054,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_13078], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_13046,cljs.core.cst$kw$col,column_13053,cljs.core.cst$kw$name,name_13079], null));
});})(seq__12925_13055,chunk__12926_13056,count__12927_13057,i__12928_13058,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12932_13075,map__12932_13076__$1,gline_13077,gcol_13078,name_13079,seq__12925_13069__$1,temp__5753__auto___13068__$1,vec__12922_13052,column_13053,column_info_13054,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted))
,cljs.core.sorted_map()));


var G__13080 = cljs.core.next(seq__12925_13069__$1);
var G__13081 = null;
var G__13082 = (0);
var G__13083 = (0);
seq__12925_13055 = G__13080;
chunk__12926_13056 = G__13081;
count__12927_13057 = G__13082;
i__12928_13058 = G__13083;
continue;
}
} else {
}
}
break;
}


var G__13084 = seq__12896_13048;
var G__13085 = chunk__12897_13049;
var G__13086 = count__12898_13050;
var G__13087 = (i__12899_13051 + (1));
seq__12896_13048 = G__13084;
chunk__12897_13049 = G__13085;
count__12898_13050 = G__13086;
i__12899_13051 = G__13087;
continue;
} else {
var temp__5753__auto___13088__$1 = cljs.core.seq(seq__12896_13048);
if(temp__5753__auto___13088__$1){
var seq__12896_13089__$1 = temp__5753__auto___13088__$1;
if(cljs.core.chunked_seq_QMARK_(seq__12896_13089__$1)){
var c__4649__auto___13090 = cljs.core.chunk_first(seq__12896_13089__$1);
var G__13091 = cljs.core.chunk_rest(seq__12896_13089__$1);
var G__13092 = c__4649__auto___13090;
var G__13093 = cljs.core.count(c__4649__auto___13090);
var G__13094 = (0);
seq__12896_13048 = G__13091;
chunk__12897_13049 = G__13092;
count__12898_13050 = G__13093;
i__12899_13051 = G__13094;
continue;
} else {
var vec__12933_13095 = cljs.core.first(seq__12896_13089__$1);
var column_13096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12933_13095,(0),null);
var column_info_13097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12933_13095,(1),null);
var seq__12936_13098 = cljs.core.seq(column_info_13097);
var chunk__12937_13099 = null;
var count__12938_13100 = (0);
var i__12939_13101 = (0);
while(true){
if((i__12939_13101 < count__12938_13100)){
var map__12942_13102 = chunk__12937_13099.cljs$core$IIndexed$_nth$arity$2(null,i__12939_13101);
var map__12942_13103__$1 = cljs.core.__destructure_map(map__12942_13102);
var gline_13104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12942_13103__$1,cljs.core.cst$kw$gline);
var gcol_13105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12942_13103__$1,cljs.core.cst$kw$gcol);
var name_13106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12942_13103__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13104], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12936_13098,chunk__12937_13099,count__12938_13100,i__12939_13101,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12942_13102,map__12942_13103__$1,gline_13104,gcol_13105,name_13106,vec__12933_13095,column_13096,column_info_13097,seq__12896_13089__$1,temp__5753__auto___13088__$1,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_13105], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_13046,cljs.core.cst$kw$col,column_13096,cljs.core.cst$kw$name,name_13106], null));
});})(seq__12936_13098,chunk__12937_13099,count__12938_13100,i__12939_13101,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12942_13102,map__12942_13103__$1,gline_13104,gcol_13105,name_13106,vec__12933_13095,column_13096,column_info_13097,seq__12896_13089__$1,temp__5753__auto___13088__$1,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted))
,cljs.core.sorted_map()));


var G__13107 = seq__12936_13098;
var G__13108 = chunk__12937_13099;
var G__13109 = count__12938_13100;
var G__13110 = (i__12939_13101 + (1));
seq__12936_13098 = G__13107;
chunk__12937_13099 = G__13108;
count__12938_13100 = G__13109;
i__12939_13101 = G__13110;
continue;
} else {
var temp__5753__auto___13111__$2 = cljs.core.seq(seq__12936_13098);
if(temp__5753__auto___13111__$2){
var seq__12936_13112__$1 = temp__5753__auto___13111__$2;
if(cljs.core.chunked_seq_QMARK_(seq__12936_13112__$1)){
var c__4649__auto___13113 = cljs.core.chunk_first(seq__12936_13112__$1);
var G__13114 = cljs.core.chunk_rest(seq__12936_13112__$1);
var G__13115 = c__4649__auto___13113;
var G__13116 = cljs.core.count(c__4649__auto___13113);
var G__13117 = (0);
seq__12936_13098 = G__13114;
chunk__12937_13099 = G__13115;
count__12938_13100 = G__13116;
i__12939_13101 = G__13117;
continue;
} else {
var map__12943_13118 = cljs.core.first(seq__12936_13112__$1);
var map__12943_13119__$1 = cljs.core.__destructure_map(map__12943_13118);
var gline_13120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12943_13119__$1,cljs.core.cst$kw$gline);
var gcol_13121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12943_13119__$1,cljs.core.cst$kw$gcol);
var name_13122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12943_13119__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_13120], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__12936_13098,chunk__12937_13099,count__12938_13100,i__12939_13101,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12943_13118,map__12943_13119__$1,gline_13120,gcol_13121,name_13122,seq__12936_13112__$1,temp__5753__auto___13111__$2,vec__12933_13095,column_13096,column_info_13097,seq__12896_13089__$1,temp__5753__auto___13088__$1,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_13121], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_13046,cljs.core.cst$kw$col,column_13096,cljs.core.cst$kw$name,name_13122], null));
});})(seq__12936_13098,chunk__12937_13099,count__12938_13100,i__12939_13101,seq__12896_13048,chunk__12897_13049,count__12898_13050,i__12899_13051,seq__12736_12944,chunk__12737_12945,count__12738_12946,i__12739_12947,map__12943_13118,map__12943_13119__$1,gline_13120,gcol_13121,name_13122,seq__12936_13112__$1,temp__5753__auto___13111__$2,vec__12933_13095,column_13096,column_info_13097,seq__12896_13089__$1,temp__5753__auto___13088__$1,vec__12893_13045,line_13046,columns_13047,seq__12736_13039__$1,temp__5753__auto___13038,inverted))
,cljs.core.sorted_map()));


var G__13123 = cljs.core.next(seq__12936_13112__$1);
var G__13124 = null;
var G__13125 = (0);
var G__13126 = (0);
seq__12936_13098 = G__13123;
chunk__12937_13099 = G__13124;
count__12938_13100 = G__13125;
i__12939_13101 = G__13126;
continue;
}
} else {
}
}
break;
}


var G__13127 = cljs.core.next(seq__12896_13089__$1);
var G__13128 = null;
var G__13129 = (0);
var G__13130 = (0);
seq__12896_13048 = G__13127;
chunk__12897_13049 = G__13128;
count__12898_13050 = G__13129;
i__12899_13051 = G__13130;
continue;
}
} else {
}
}
break;
}


var G__13131 = cljs.core.next(seq__12736_13039__$1);
var G__13132 = null;
var G__13133 = (0);
var G__13134 = (0);
seq__12736_12944 = G__13131;
chunk__12737_12945 = G__13132;
count__12738_12946 = G__13133;
i__12739_12947 = G__13134;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
