// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__69823_69992 = cljs.core.seq(servers);
var chunk__69824_69993 = null;
var count__69825_69994 = (0);
var i__69826_69995 = (0);
while(true){
if((i__69826_69995 < count__69825_69994)){
var server_69996 = chunk__69824_69993.cljs$core$IIndexed$_nth$arity$2(null,i__69826_69995);
var healthcheck_uri_69997 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_69996),"/fdb/health"].join('');
var resp_chan_69998 = fluree.db.util.xhttp.post_json(healthcheck_uri_69997,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__10835__auto___69999 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___69999,healthcheck_uri_69997,resp_chan_69998,server_69996){
return (function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = ((function (seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___69999,healthcheck_uri_69997,resp_chan_69998,server_69996){
return (function (state_69887){
var state_val_69888 = (state_69887[(1)]);
if((state_val_69888 === (1))){
var state_69887__$1 = state_69887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69887__$1,(2),resp_chan_69998);
} else {
if((state_val_69888 === (2))){
var inst_69876 = (state_69887[(7)]);
var inst_69876__$1 = (state_69887[(2)]);
var inst_69877 = fluree.db.util.core.exception_QMARK_(inst_69876__$1);
var state_69887__$1 = (function (){var statearr_69889 = state_69887;
(statearr_69889[(7)] = inst_69876__$1);

return statearr_69889;
})();
if(inst_69877){
var statearr_69890_70000 = state_69887__$1;
(statearr_69890_70000[(1)] = (3));

} else {
var statearr_69891_70001 = state_69887__$1;
(statearr_69891_70001[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69888 === (3))){
var inst_69876 = (state_69887[(7)]);
var inst_69879 = cljs.core.ex_message(inst_69876);
var inst_69880 = cljs.core.ex_data(inst_69876);
var inst_69881 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_69879,inst_69880], 0));
var state_69887__$1 = state_69887;
var statearr_69892_70002 = state_69887__$1;
(statearr_69892_70002[(2)] = inst_69881);

(statearr_69892_70002[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69888 === (4))){
var inst_69883 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_69996);
var state_69887__$1 = state_69887;
var statearr_69893_70003 = state_69887__$1;
(statearr_69893_70003[(2)] = inst_69883);

(statearr_69893_70003[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69888 === (5))){
var inst_69885 = (state_69887[(2)]);
var state_69887__$1 = state_69887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69887__$1,inst_69885);
} else {
return null;
}
}
}
}
}
});})(seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___69999,healthcheck_uri_69997,resp_chan_69998,server_69996))
;
return ((function (seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,switch__10797__auto__,c__10835__auto___69999,healthcheck_uri_69997,resp_chan_69998,server_69996){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0 = (function (){
var statearr_69894 = [null,null,null,null,null,null,null,null];
(statearr_69894[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__);

(statearr_69894[(1)] = (1));

return statearr_69894;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1 = (function (state_69887){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_69887);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e69895){var ex__10801__auto__ = e69895;
var statearr_69896_70004 = state_69887;
(statearr_69896_70004[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_69887[(4)]))){
var statearr_69897_70005 = state_69887;
(statearr_69897_70005[(1)] = cljs.core.first((state_69887[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70006 = state_69887;
state_69887 = G__70006;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__ = function(state_69887){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1.call(this,state_69887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__;
})()
;})(seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,switch__10797__auto__,c__10835__auto___69999,healthcheck_uri_69997,resp_chan_69998,server_69996))
})();
var state__10837__auto__ = (function (){var statearr_69898 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_69898[(6)] = c__10835__auto___69999);

return statearr_69898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
});})(seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___69999,healthcheck_uri_69997,resp_chan_69998,server_69996))
);



var G__70007 = seq__69823_69992;
var G__70008 = chunk__69824_69993;
var G__70009 = count__69825_69994;
var G__70010 = (i__69826_69995 + (1));
seq__69823_69992 = G__70007;
chunk__69824_69993 = G__70008;
count__69825_69994 = G__70009;
i__69826_69995 = G__70010;
continue;
} else {
var temp__5753__auto___70011 = cljs.core.seq(seq__69823_69992);
if(temp__5753__auto___70011){
var seq__69823_70012__$1 = temp__5753__auto___70011;
if(cljs.core.chunked_seq_QMARK_(seq__69823_70012__$1)){
var c__4649__auto___70013 = cljs.core.chunk_first(seq__69823_70012__$1);
var G__70014 = cljs.core.chunk_rest(seq__69823_70012__$1);
var G__70015 = c__4649__auto___70013;
var G__70016 = cljs.core.count(c__4649__auto___70013);
var G__70017 = (0);
seq__69823_69992 = G__70014;
chunk__69824_69993 = G__70015;
count__69825_69994 = G__70016;
i__69826_69995 = G__70017;
continue;
} else {
var server_70018 = cljs.core.first(seq__69823_70012__$1);
var healthcheck_uri_70019 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_70018),"/fdb/health"].join('');
var resp_chan_70020 = fluree.db.util.xhttp.post_json(healthcheck_uri_70019,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__10835__auto___70021 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___70021,healthcheck_uri_70019,resp_chan_70020,server_70018,seq__69823_70012__$1,temp__5753__auto___70011){
return (function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = ((function (seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___70021,healthcheck_uri_70019,resp_chan_70020,server_70018,seq__69823_70012__$1,temp__5753__auto___70011){
return (function (state_69911){
var state_val_69912 = (state_69911[(1)]);
if((state_val_69912 === (1))){
var state_69911__$1 = state_69911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69911__$1,(2),resp_chan_70020);
} else {
if((state_val_69912 === (2))){
var inst_69900 = (state_69911[(7)]);
var inst_69900__$1 = (state_69911[(2)]);
var inst_69901 = fluree.db.util.core.exception_QMARK_(inst_69900__$1);
var state_69911__$1 = (function (){var statearr_69913 = state_69911;
(statearr_69913[(7)] = inst_69900__$1);

return statearr_69913;
})();
if(inst_69901){
var statearr_69914_70022 = state_69911__$1;
(statearr_69914_70022[(1)] = (3));

} else {
var statearr_69915_70023 = state_69911__$1;
(statearr_69915_70023[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69912 === (3))){
var inst_69900 = (state_69911[(7)]);
var inst_69903 = cljs.core.ex_message(inst_69900);
var inst_69904 = cljs.core.ex_data(inst_69900);
var inst_69905 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_69903,inst_69904], 0));
var state_69911__$1 = state_69911;
var statearr_69916_70024 = state_69911__$1;
(statearr_69916_70024[(2)] = inst_69905);

(statearr_69916_70024[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69912 === (4))){
var inst_69907 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_70018);
var state_69911__$1 = state_69911;
var statearr_69917_70025 = state_69911__$1;
(statearr_69917_70025[(2)] = inst_69907);

(statearr_69917_70025[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69912 === (5))){
var inst_69909 = (state_69911[(2)]);
var state_69911__$1 = state_69911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69911__$1,inst_69909);
} else {
return null;
}
}
}
}
}
});})(seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___70021,healthcheck_uri_70019,resp_chan_70020,server_70018,seq__69823_70012__$1,temp__5753__auto___70011))
;
return ((function (seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,switch__10797__auto__,c__10835__auto___70021,healthcheck_uri_70019,resp_chan_70020,server_70018,seq__69823_70012__$1,temp__5753__auto___70011){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0 = (function (){
var statearr_69918 = [null,null,null,null,null,null,null,null];
(statearr_69918[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__);

(statearr_69918[(1)] = (1));

return statearr_69918;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1 = (function (state_69911){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_69911);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e69919){var ex__10801__auto__ = e69919;
var statearr_69920_70026 = state_69911;
(statearr_69920_70026[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_69911[(4)]))){
var statearr_69921_70027 = state_69911;
(statearr_69921_70027[(1)] = cljs.core.first((state_69911[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70028 = state_69911;
state_69911 = G__70028;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__ = function(state_69911){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1.call(this,state_69911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__;
})()
;})(seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,switch__10797__auto__,c__10835__auto___70021,healthcheck_uri_70019,resp_chan_70020,server_70018,seq__69823_70012__$1,temp__5753__auto___70011))
})();
var state__10837__auto__ = (function (){var statearr_69922 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_69922[(6)] = c__10835__auto___70021);

return statearr_69922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
});})(seq__69823_69992,chunk__69824_69993,count__69825_69994,i__69826_69995,c__10835__auto___70021,healthcheck_uri_70019,resp_chan_70020,server_70018,seq__69823_70012__$1,temp__5753__auto___70011))
);



var G__70029 = cljs.core.next(seq__69823_70012__$1);
var G__70030 = null;
var G__70031 = (0);
var G__70032 = (0);
seq__69823_69992 = G__70029;
chunk__69824_69993 = G__70030;
count__69825_69994 = G__70031;
i__69826_69995 = G__70032;
continue;
}
} else {
}
}
break;
}

var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_69966){
var state_val_69967 = (state_69966[(1)]);
if((state_val_69967 === (7))){
var inst_69938 = (state_69966[(7)]);
var inst_69945 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69938,cljs.core.cst$kw$default);
var state_69966__$1 = state_69966;
if(inst_69945){
var statearr_69968_70033 = state_69966__$1;
(statearr_69968_70033[(1)] = (9));

} else {
var statearr_69969_70034 = state_69966__$1;
(statearr_69969_70034[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (1))){
var inst_69930 = (state_69966[(8)]);
var inst_69931 = (state_69966[(9)]);
var inst_69930__$1 = promise_chan;
var inst_69931__$1 = cljs.core.async.timeout((60000));
var inst_69932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69933 = [inst_69930__$1,inst_69931__$1];
var inst_69934 = (new cljs.core.PersistentVector(null,2,(5),inst_69932,inst_69933,null));
var state_69966__$1 = (function (){var statearr_69970 = state_69966;
(statearr_69970[(8)] = inst_69930__$1);

(statearr_69970[(9)] = inst_69931__$1);

return statearr_69970;
})();
return cljs.core.async.ioc_alts_BANG_(state_69966__$1,(2),inst_69934);
} else {
if((state_val_69967 === (4))){
var inst_69931 = (state_69966[(9)]);
var inst_69938 = (state_69966[(7)]);
var inst_69942 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69938,inst_69931);
var state_69966__$1 = state_69966;
if(inst_69942){
var statearr_69971_70035 = state_69966__$1;
(statearr_69971_70035[(1)] = (6));

} else {
var statearr_69972_70036 = state_69966__$1;
(statearr_69972_70036[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (13))){
var state_69966__$1 = state_69966;
var statearr_69973_70037 = state_69966__$1;
(statearr_69973_70037[(2)] = null);

(statearr_69973_70037[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (6))){
var state_69966__$1 = state_69966;
var statearr_69974_70038 = state_69966__$1;
(statearr_69974_70038[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_69974_70038[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (3))){
var state_69966__$1 = state_69966;
var statearr_69975_70039 = state_69966__$1;
(statearr_69975_70039[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_69975_70039[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (12))){
var inst_69956 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_69957 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69958 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_69959 = cljs.core.PersistentHashMap.fromArrays(inst_69957,inst_69958);
var inst_69960 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_69959);
var inst_69961 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_69960);
var state_69966__$1 = (function (){var statearr_69976 = state_69966;
(statearr_69976[(10)] = inst_69956);

return statearr_69976;
})();
var statearr_69977_70040 = state_69966__$1;
(statearr_69977_70040[(2)] = inst_69961);

(statearr_69977_70040[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (2))){
var inst_69930 = (state_69966[(8)]);
var inst_69938 = (state_69966[(7)]);
var inst_69936 = (state_69966[(2)]);
var inst_69937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69936,(0),null);
var inst_69938__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69936,(1),null);
var inst_69939 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_69938__$1,inst_69930);
var state_69966__$1 = (function (){var statearr_69978 = state_69966;
(statearr_69978[(11)] = inst_69937);

(statearr_69978[(7)] = inst_69938__$1);

return statearr_69978;
})();
if(inst_69939){
var statearr_69979_70041 = state_69966__$1;
(statearr_69979_70041[(1)] = (3));

} else {
var statearr_69980_70042 = state_69966__$1;
(statearr_69980_70042[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (11))){
var inst_69949 = (state_69966[(2)]);
var state_69966__$1 = state_69966;
var statearr_69981_70043 = state_69966__$1;
(statearr_69981_70043[(2)] = inst_69949);

(statearr_69981_70043[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (9))){
var inst_69937 = (state_69966[(11)]);
var state_69966__$1 = state_69966;
var statearr_69982_70044 = state_69966__$1;
(statearr_69982_70044[(2)] = inst_69937);

(statearr_69982_70044[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (5))){
var inst_69953 = (state_69966[(2)]);
var inst_69954 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_69953);
var state_69966__$1 = state_69966;
if(inst_69954){
var statearr_69983_70045 = state_69966__$1;
(statearr_69983_70045[(1)] = (12));

} else {
var statearr_69984_70046 = state_69966__$1;
(statearr_69984_70046[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (14))){
var inst_69964 = (state_69966[(2)]);
var state_69966__$1 = state_69966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69966__$1,inst_69964);
} else {
if((state_val_69967 === (10))){
var state_69966__$1 = state_69966;
var statearr_69985_70047 = state_69966__$1;
(statearr_69985_70047[(2)] = null);

(statearr_69985_70047[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69967 === (8))){
var inst_69951 = (state_69966[(2)]);
var state_69966__$1 = state_69966;
var statearr_69986_70048 = state_69966__$1;
(statearr_69986_70048[(2)] = inst_69951);

(statearr_69986_70048[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0 = (function (){
var statearr_69987 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69987[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__);

(statearr_69987[(1)] = (1));

return statearr_69987;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1 = (function (state_69966){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_69966);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e69988){var ex__10801__auto__ = e69988;
var statearr_69989_70049 = state_69966;
(statearr_69989_70049[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_69966[(4)]))){
var statearr_69990_70050 = state_69966;
(statearr_69990_70050[(1)] = cljs.core.first((state_69966[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70051 = state_69966;
state_69966 = G__70051;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__ = function(state_69966){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1.call(this,state_69966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_69991 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_69991[(6)] = c__10835__auto__);

return statearr_69991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_70095){
var state_val_70096 = (state_70095[(1)]);
if((state_val_70096 === (7))){
var state_70095__$1 = state_70095;
var statearr_70097_70123 = state_70095__$1;
(statearr_70097_70123[(2)] = null);

(statearr_70097_70123[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (1))){
var state_70095__$1 = state_70095;
var statearr_70098_70124 = state_70095__$1;
(statearr_70098_70124[(2)] = null);

(statearr_70098_70124[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (4))){
var inst_70052 = (state_70095[(2)]);
var state_70095__$1 = state_70095;
var statearr_70099_70125 = state_70095__$1;
(statearr_70099_70125[(2)] = inst_70052);

(statearr_70099_70125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (6))){
var inst_70074 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_70095__$1 = state_70095;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70095__$1,(9),inst_70074);
} else {
if((state_val_70096 === (3))){
var inst_70093 = (state_70095[(2)]);
var state_70095__$1 = state_70095;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70095__$1,inst_70093);
} else {
if((state_val_70096 === (12))){
var inst_70087 = (state_70095[(2)]);
var state_70095__$1 = state_70095;
var statearr_70100_70126 = state_70095__$1;
(statearr_70100_70126[(2)] = inst_70087);

(statearr_70100_70126[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (2))){
var inst_70068 = (state_70095[(7)]);
var inst_70063 = (state_70095[(8)]);
var inst_70058 = (state_70095[(9)]);
var _ = (function (){var statearr_70101 = state_70095;
(statearr_70101[(4)] = cljs.core.cons((5),(state_70095[(4)])));

return statearr_70101;
})();
var inst_70058__$1 = fluree.db.util.core.random_uuid();
var inst_70059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70060 = [conn_id,cljs.core.cst$kw$ws];
var inst_70061 = (new cljs.core.PersistentVector(null,2,(5),inst_70059,inst_70060,null));
var inst_70062 = (function (){var lock_id = inst_70058__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_70063__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_70061,inst_70062);
var inst_70064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70065 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_70066 = (new cljs.core.PersistentVector(null,3,(5),inst_70064,inst_70065,null));
var inst_70067 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_70063__$1,inst_70066);
var inst_70068__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70058__$1,inst_70067);
var inst_70069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70070 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_70071 = (new cljs.core.PersistentVector(null,3,(5),inst_70069,inst_70070,null));
var inst_70072 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_70063__$1,inst_70071);
var state_70095__$1 = (function (){var statearr_70102 = state_70095;
(statearr_70102[(7)] = inst_70068__$1);

(statearr_70102[(8)] = inst_70063__$1);

(statearr_70102[(9)] = inst_70058__$1);

(statearr_70102[(10)] = inst_70072);

return statearr_70102;
})();
if(inst_70068__$1){
var statearr_70103_70127 = state_70095__$1;
(statearr_70103_70127[(1)] = (6));

} else {
var statearr_70104_70128 = state_70095__$1;
(statearr_70104_70128[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (11))){
var inst_70079 = (state_70095[(11)]);
var inst_70072 = (state_70095[(10)]);
var inst_70078 = (state_70095[(12)]);
var inst_70085 = fluree.db.util.xhttp.try_socket(inst_70078,sub_chan,pub_chan,inst_70072,(60000),inst_70079);
var state_70095__$1 = state_70095;
var statearr_70106_70129 = state_70095__$1;
(statearr_70106_70129[(2)] = inst_70085);

(statearr_70106_70129[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (9))){
var inst_70068 = (state_70095[(7)]);
var inst_70076 = (state_70095[(13)]);
var inst_70063 = (state_70095[(8)]);
var inst_70058 = (state_70095[(9)]);
var inst_70072 = (state_70095[(10)]);
var inst_70078 = (state_70095[(12)]);
var inst_70076__$1 = (state_70095[(2)]);
var inst_70077 = clojure.string.replace(inst_70076__$1,"http","ws");
var inst_70078__$1 = [inst_70077,"/fdb/ws"].join('');
var inst_70079 = (function (){var lock_id = inst_70058;
var state = inst_70063;
var have_lock_QMARK_ = inst_70068;
var resp_chan = inst_70072;
var healthy_server = inst_70076__$1;
var ws_url = inst_70078__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_70080 = fluree.db.util.core.exception_QMARK_(inst_70076__$1);
var state_70095__$1 = (function (){var statearr_70107 = state_70095;
(statearr_70107[(13)] = inst_70076__$1);

(statearr_70107[(11)] = inst_70079);

(statearr_70107[(12)] = inst_70078__$1);

return statearr_70107;
})();
if(inst_70080){
var statearr_70108_70130 = state_70095__$1;
(statearr_70108_70130[(1)] = (10));

} else {
var statearr_70109_70131 = state_70095__$1;
(statearr_70109_70131[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (5))){
var _ = (function (){var statearr_70110 = state_70095;
(statearr_70110[(4)] = cljs.core.rest((state_70095[(4)])));

return statearr_70110;
})();
var state_70095__$1 = state_70095;
var ex70105 = (state_70095__$1[(2)]);
var statearr_70111_70132 = state_70095__$1;
(statearr_70111_70132[(5)] = ex70105);


if((ex70105 instanceof Error)){
var statearr_70112_70133 = state_70095__$1;
(statearr_70112_70133[(1)] = (4));

(statearr_70112_70133[(5)] = null);

} else {
throw ex70105;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (10))){
var inst_70076 = (state_70095[(13)]);
var inst_70072 = (state_70095[(10)]);
var inst_70082 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_70083 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70072,inst_70076);
var state_70095__$1 = (function (){var statearr_70113 = state_70095;
(statearr_70113[(14)] = inst_70082);

return statearr_70113;
})();
var statearr_70114_70134 = state_70095__$1;
(statearr_70114_70134[(2)] = inst_70083);

(statearr_70114_70134[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70096 === (8))){
var inst_70072 = (state_70095[(10)]);
var inst_70090 = (state_70095[(2)]);
var _ = (function (){var statearr_70115 = state_70095;
(statearr_70115[(4)] = cljs.core.rest((state_70095[(4)])));

return statearr_70115;
})();
var state_70095__$1 = (function (){var statearr_70116 = state_70095;
(statearr_70116[(15)] = inst_70090);

return statearr_70116;
})();
var statearr_70117_70135 = state_70095__$1;
(statearr_70117_70135[(2)] = inst_70072);

(statearr_70117_70135[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__10798__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__10798__auto____0 = (function (){
var statearr_70118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70118[(0)] = fluree$db$connection$establish_socket_$_state_machine__10798__auto__);

(statearr_70118[(1)] = (1));

return statearr_70118;
});
var fluree$db$connection$establish_socket_$_state_machine__10798__auto____1 = (function (state_70095){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_70095);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e70119){var ex__10801__auto__ = e70119;
var statearr_70120_70136 = state_70095;
(statearr_70120_70136[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_70095[(4)]))){
var statearr_70121_70137 = state_70095;
(statearr_70121_70137[(1)] = cljs.core.first((state_70095[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70138 = state_70095;
state_70095 = G__70138;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__10798__auto__ = function(state_70095){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__10798__auto____1.call(this,state_70095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__10798__auto____0;
fluree$db$connection$establish_socket_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__10798__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_70122 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_70122[(6)] = c__10835__auto__);

return statearr_70122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k70140,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__70144 = k70140;
var G__70144__$1 = (((G__70144 instanceof cljs.core.Keyword))?G__70144.fqn:null);
switch (G__70144__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k70140,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__70145){
var vec__70146 = p__70145;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70146,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70146,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__70139){
var self__ = this;
var G__70139__$1 = this;
return (new cljs.core.RecordIter((0),G__70139__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__70149 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__70149(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this70141,other70142){
var self__ = this;
var this70141__$1 = this;
return (((!((other70142 == null)))) && ((((this70141__$1.constructor === other70142.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.id,other70142.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.servers,other70142.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.state,other70142.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.req_chan,other70142.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.sub_chan,other70142.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.pub_chan,other70142.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.storage_read,other70142.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.storage_write,other70142.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.object_cache,other70142.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.parallelism,other70142.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.serializer,other70142.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.default_network,other70142.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.transactor_QMARK_,other70142.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.publish,other70142.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.transact_handler,other70142.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.tx_private_key,other70142.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.tx_key_id,other70142.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.meta,other70142.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.add_listener,other70142.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.remove_listener,other70142.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.close,other70142.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this70141__$1.__extmap,other70142.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k70140){
var self__ = this;
var this__4479__auto____$1 = this;
var G__70150 = k70140;
var G__70150__$1 = (((G__70150 instanceof cljs.core.Keyword))?G__70150.fqn:null);
switch (G__70150__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k70140);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__70139){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__70151 = cljs.core.keyword_identical_QMARK_;
var expr__70152 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__70154 = cljs.core.cst$kw$id;
var G__70155 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70154,G__70155) : pred__70151.call(null,G__70154,G__70155));
})())){
return (new fluree.db.connection.Connection(G__70139,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70156 = cljs.core.cst$kw$servers;
var G__70157 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70156,G__70157) : pred__70151.call(null,G__70156,G__70157));
})())){
return (new fluree.db.connection.Connection(self__.id,G__70139,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70158 = cljs.core.cst$kw$state;
var G__70159 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70158,G__70159) : pred__70151.call(null,G__70158,G__70159));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__70139,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70160 = cljs.core.cst$kw$req_DASH_chan;
var G__70161 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70160,G__70161) : pred__70151.call(null,G__70160,G__70161));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__70139,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70162 = cljs.core.cst$kw$sub_DASH_chan;
var G__70163 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70162,G__70163) : pred__70151.call(null,G__70162,G__70163));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__70139,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70164 = cljs.core.cst$kw$pub_DASH_chan;
var G__70165 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70164,G__70165) : pred__70151.call(null,G__70164,G__70165));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__70139,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70166 = cljs.core.cst$kw$storage_DASH_read;
var G__70167 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70166,G__70167) : pred__70151.call(null,G__70166,G__70167));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__70139,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70168 = cljs.core.cst$kw$storage_DASH_write;
var G__70169 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70168,G__70169) : pred__70151.call(null,G__70168,G__70169));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__70139,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70170 = cljs.core.cst$kw$object_DASH_cache;
var G__70171 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70170,G__70171) : pred__70151.call(null,G__70170,G__70171));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__70139,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70172 = cljs.core.cst$kw$parallelism;
var G__70173 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70172,G__70173) : pred__70151.call(null,G__70172,G__70173));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__70139,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70174 = cljs.core.cst$kw$serializer;
var G__70175 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70174,G__70175) : pred__70151.call(null,G__70174,G__70175));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__70139,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70176 = cljs.core.cst$kw$default_DASH_network;
var G__70177 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70176,G__70177) : pred__70151.call(null,G__70176,G__70177));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__70139,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70178 = cljs.core.cst$kw$transactor_QMARK_;
var G__70179 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70178,G__70179) : pred__70151.call(null,G__70178,G__70179));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__70139,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70180 = cljs.core.cst$kw$publish;
var G__70181 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70180,G__70181) : pred__70151.call(null,G__70180,G__70181));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__70139,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70182 = cljs.core.cst$kw$transact_DASH_handler;
var G__70183 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70182,G__70183) : pred__70151.call(null,G__70182,G__70183));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__70139,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70184 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__70185 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70184,G__70185) : pred__70151.call(null,G__70184,G__70185));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__70139,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70186 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__70187 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70186,G__70187) : pred__70151.call(null,G__70186,G__70187));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__70139,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70188 = cljs.core.cst$kw$meta;
var G__70189 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70188,G__70189) : pred__70151.call(null,G__70188,G__70189));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__70139,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70190 = cljs.core.cst$kw$add_DASH_listener;
var G__70191 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70190,G__70191) : pred__70151.call(null,G__70190,G__70191));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__70139,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70192 = cljs.core.cst$kw$remove_DASH_listener;
var G__70193 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70192,G__70193) : pred__70151.call(null,G__70192,G__70193));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__70139,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__70194 = cljs.core.cst$kw$close;
var G__70195 = expr__70152;
return (pred__70151.cljs$core$IFn$_invoke$arity$2 ? pred__70151.cljs$core$IFn$_invoke$arity$2(G__70194,G__70195) : pred__70151.call(null,G__70194,G__70195));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__70139,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__70139),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__70139){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__70139,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__70143){
var extmap__4512__auto__ = (function (){var G__70196 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__70143,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__70143)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__70196);
} else {
return G__70196;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__70143),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__70143),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__70202 = servers_STAR_;
var vec__70203 = G__70202;
var seq__70204 = cljs.core.seq(vec__70203);
var first__70205 = cljs.core.first(seq__70204);
var seq__70204__$1 = cljs.core.next(seq__70204);
var server = first__70205;
var r = seq__70204__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__70202__$1 = G__70202;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__70209 = G__70202__$1;
var seq__70210 = cljs.core.seq(vec__70209);
var first__70211 = cljs.core.first(seq__70210);
var seq__70210__$1 = cljs.core.next(seq__70210);
var server__$1 = first__70211;
var r__$1 = seq__70210__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__70212 = r__$1;
var G__70213 = is_https_QMARK_;
var G__70214 = result_STAR_;
G__70202__$1 = G__70212;
https_QMARK___$1 = G__70213;
result__$1 = G__70214;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__70215 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__70215 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__70215);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_70244){
var state_val_70245 = (state_70244[(1)]);
if((state_val_70245 === (7))){
var inst_70230 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70231 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70232 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70233 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70234 = fluree.db.connection.establish_socket(inst_70230,inst_70231,inst_70232,inst_70233);
var state_70244__$1 = state_70244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70244__$1,(9),inst_70234);
} else {
if((state_val_70245 === (1))){
var state_70244__$1 = state_70244;
var statearr_70246_70265 = state_70244__$1;
(statearr_70246_70265[(2)] = null);

(statearr_70246_70265[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70245 === (4))){
var inst_70216 = (state_70244[(2)]);
var state_70244__$1 = state_70244;
var statearr_70247_70266 = state_70244__$1;
(statearr_70247_70266[(2)] = inst_70216);

(statearr_70247_70266[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70245 === (6))){
var inst_70227 = (state_70244[(7)]);
var state_70244__$1 = state_70244;
var statearr_70248_70267 = state_70244__$1;
(statearr_70248_70267[(2)] = inst_70227);

(statearr_70248_70267[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70245 === (3))){
var inst_70242 = (state_70244[(2)]);
var state_70244__$1 = state_70244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70244__$1,inst_70242);
} else {
if((state_val_70245 === (2))){
var inst_70227 = (state_70244[(7)]);
var _ = (function (){var statearr_70250 = state_70244;
(statearr_70250[(4)] = cljs.core.cons((5),(state_70244[(4)])));

return statearr_70250;
})();
var inst_70222 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_70223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70224 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70225 = [inst_70224,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_70226 = (new cljs.core.PersistentVector(null,3,(5),inst_70223,inst_70225,null));
var inst_70227__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_70222,inst_70226);
var state_70244__$1 = (function (){var statearr_70251 = state_70244;
(statearr_70251[(7)] = inst_70227__$1);

return statearr_70251;
})();
if(cljs.core.truth_(inst_70227__$1)){
var statearr_70252_70268 = state_70244__$1;
(statearr_70252_70268[(1)] = (6));

} else {
var statearr_70253_70269 = state_70244__$1;
(statearr_70253_70269[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70245 === (9))){
var inst_70236 = (state_70244[(2)]);
var inst_70237 = fluree.db.util.async.throw_err(inst_70236);
var state_70244__$1 = state_70244;
var statearr_70254_70270 = state_70244__$1;
(statearr_70254_70270[(2)] = inst_70237);

(statearr_70254_70270[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70245 === (5))){
var _ = (function (){var statearr_70255 = state_70244;
(statearr_70255[(4)] = cljs.core.rest((state_70244[(4)])));

return statearr_70255;
})();
var state_70244__$1 = state_70244;
var ex70249 = (state_70244__$1[(2)]);
var statearr_70256_70271 = state_70244__$1;
(statearr_70256_70271[(5)] = ex70249);


if((ex70249 instanceof Error)){
var statearr_70257_70272 = state_70244__$1;
(statearr_70257_70272[(1)] = (4));

(statearr_70257_70272[(5)] = null);

} else {
throw ex70249;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70245 === (8))){
var inst_70239 = (state_70244[(2)]);
var _ = (function (){var statearr_70258 = state_70244;
(statearr_70258[(4)] = cljs.core.rest((state_70244[(4)])));

return statearr_70258;
})();
var state_70244__$1 = state_70244;
var statearr_70259_70273 = state_70244__$1;
(statearr_70259_70273[(2)] = inst_70239);

(statearr_70259_70273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__10798__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__10798__auto____0 = (function (){
var statearr_70260 = [null,null,null,null,null,null,null,null];
(statearr_70260[(0)] = fluree$db$connection$get_socket_$_state_machine__10798__auto__);

(statearr_70260[(1)] = (1));

return statearr_70260;
});
var fluree$db$connection$get_socket_$_state_machine__10798__auto____1 = (function (state_70244){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_70244);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e70261){var ex__10801__auto__ = e70261;
var statearr_70262_70274 = state_70244;
(statearr_70262_70274[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_70244[(4)]))){
var statearr_70263_70275 = state_70244;
(statearr_70263_70275[(1)] = cljs.core.first((state_70244[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70276 = state_70244;
state_70244 = G__70276;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__10798__auto__ = function(state_70244){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__10798__auto____1.call(this,state_70244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__10798__auto____0;
fluree$db$connection$get_socket_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__10798__auto____1;
return fluree$db$connection$get_socket_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_70264 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_70264[(6)] = c__10835__auto__);

return statearr_70264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e70277){var e = e70277;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_70404){
var state_val_70405 = (state_70404[(1)]);
if((state_val_70405 === (7))){
var inst_70400 = (state_70404[(2)]);
var state_70404__$1 = state_70404;
var statearr_70407_70477 = state_70404__$1;
(statearr_70407_70477[(2)] = inst_70400);

(statearr_70407_70477[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (20))){
var _ = (function (){var statearr_70408 = state_70404;
(statearr_70408[(4)] = cljs.core.rest((state_70404[(4)])));

return statearr_70408;
})();
var state_70404__$1 = state_70404;
var ex70406 = (state_70404__$1[(2)]);
var statearr_70409_70478 = state_70404__$1;
(statearr_70409_70478[(5)] = ex70406);


var statearr_70410_70479 = state_70404__$1;
(statearr_70410_70479[(1)] = (10));

(statearr_70410_70479[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (27))){
var inst_70392 = (state_70404[(2)]);
var _ = (function (){var statearr_70411 = state_70404;
(statearr_70411[(4)] = cljs.core.rest((state_70404[(4)])));

return statearr_70411;
})();
var state_70404__$1 = state_70404;
var statearr_70412_70480 = state_70404__$1;
(statearr_70412_70480[(2)] = inst_70392);

(statearr_70412_70480[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (1))){
var inst_70279 = (0);
var state_70404__$1 = (function (){var statearr_70413 = state_70404;
(statearr_70413[(7)] = inst_70279);

return statearr_70413;
})();
var statearr_70414_70481 = state_70404__$1;
(statearr_70414_70481[(2)] = null);

(statearr_70414_70481[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (24))){
var inst_70370 = (state_70404[(8)]);
var inst_70370__$1 = (state_70404[(2)]);
var inst_70371 = inst_70370__$1 === true;
var state_70404__$1 = (function (){var statearr_70415 = state_70404;
(statearr_70415[(8)] = inst_70370__$1);

return statearr_70415;
})();
if(cljs.core.truth_(inst_70371)){
var statearr_70416_70482 = state_70404__$1;
(statearr_70416_70482[(1)] = (25));

} else {
var statearr_70417_70483 = state_70404__$1;
(statearr_70417_70483[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (4))){
var inst_70282 = (state_70404[(9)]);
var inst_70282__$1 = (state_70404[(2)]);
var state_70404__$1 = (function (){var statearr_70418 = state_70404;
(statearr_70418[(9)] = inst_70282__$1);

return statearr_70418;
})();
if(cljs.core.truth_(inst_70282__$1)){
var statearr_70419_70484 = state_70404__$1;
(statearr_70419_70484[(1)] = (5));

} else {
var statearr_70420_70485 = state_70404__$1;
(statearr_70420_70485[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (15))){
var inst_70295 = (state_70404[(10)]);
var state_70404__$1 = state_70404;
var statearr_70421_70486 = state_70404__$1;
(statearr_70421_70486[(2)] = inst_70295);

(statearr_70421_70486[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (21))){
var inst_70318 = (state_70404[(11)]);
var inst_70326 = (state_70404[(12)]);
var inst_70319 = (state_70404[(13)]);
var inst_70321 = (state_70404[(14)]);
var inst_70282 = (state_70404[(9)]);
var inst_70279 = (state_70404[(7)]);
var inst_70320 = (state_70404[(15)]);
var inst_70327 = (state_70404[(16)]);
var inst_70323 = (state_70404[(17)]);
var inst_70322 = (state_70404[(18)]);
var inst_70329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70330 = [cljs.core.cst$kw$pending_DASH_req,inst_70326];
var inst_70331 = (new cljs.core.PersistentVector(null,2,(5),inst_70329,inst_70330,null));
var inst_70332 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_70331,inst_70321);
var inst_70359 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70360 = (function (){var resp_chan = inst_70321;
var timeout = inst_70327;
var i = inst_70279;
var c__10835__auto____$1 = inst_70359;
var data = inst_70320;
var _ = inst_70318;
var vec__70314 = inst_70282;
var req_id = inst_70326;
var operation = inst_70319;
var msg = inst_70282;
var opts = inst_70322;
var map__70317 = inst_70323;
return (function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_70357){
var state_val_70358 = (state_70357[(1)]);
if((state_val_70358 === (1))){
var inst_70336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70337 = cljs.core.async.timeout(timeout);
var inst_70338 = [resp_chan,inst_70337];
var inst_70339 = (new cljs.core.PersistentVector(null,2,(5),inst_70336,inst_70338,null));
var state_70357__$1 = state_70357;
return cljs.core.async.ioc_alts_BANG_(state_70357__$1,(2),inst_70339);
} else {
if((state_val_70358 === (2))){
var inst_70342 = (state_70357[(7)]);
var inst_70341 = (state_70357[(2)]);
var inst_70342__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70341,(0),null);
var inst_70343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70341,(1),null);
var inst_70344 = (function (){var vec__70333 = inst_70341;
var resp = inst_70342__$1;
var c = inst_70343;
return (function (p1__70278_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__70278_SHARP_,req_id);
});
})();
var inst_70345 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_70344);
var inst_70346 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70343,resp_chan);
var state_70357__$1 = (function (){var statearr_70422 = state_70357;
(statearr_70422[(8)] = inst_70345);

(statearr_70422[(7)] = inst_70342__$1);

return statearr_70422;
})();
if(inst_70346){
var statearr_70423_70487 = state_70357__$1;
(statearr_70423_70487[(1)] = (3));

} else {
var statearr_70424_70488 = state_70357__$1;
(statearr_70424_70488[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70358 === (3))){
var inst_70342 = (state_70357[(7)]);
var state_70357__$1 = state_70357;
var statearr_70425_70489 = state_70357__$1;
(statearr_70425_70489[(2)] = inst_70342);

(statearr_70425_70489[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70358 === (4))){
var inst_70349 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_70350 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_70351 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_70352 = cljs.core.PersistentHashMap.fromArrays(inst_70350,inst_70351);
var inst_70353 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70349,inst_70352);
var state_70357__$1 = state_70357;
var statearr_70426_70490 = state_70357__$1;
(statearr_70426_70490[(2)] = inst_70353);

(statearr_70426_70490[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70358 === (5))){
var inst_70355 = (state_70357[(2)]);
var state_70357__$1 = state_70357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70357__$1,inst_70355);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10798__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10798__auto____0 = (function (){
var statearr_70427 = [null,null,null,null,null,null,null,null,null];
(statearr_70427[(0)] = fluree$db$connection$msg_producer_$_state_machine__10798__auto__);

(statearr_70427[(1)] = (1));

return statearr_70427;
});
var fluree$db$connection$msg_producer_$_state_machine__10798__auto____1 = (function (state_70357){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_70357);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e70428){var ex__10801__auto__ = e70428;
var statearr_70429_70491 = state_70357;
(statearr_70429_70491[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_70357[(4)]))){
var statearr_70430_70492 = state_70357;
(statearr_70430_70492[(1)] = cljs.core.first((state_70357[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70493 = state_70357;
state_70357 = G__70493;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10798__auto__ = function(state_70357){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10798__auto____1.call(this,state_70357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10798__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10798__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_70431 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_70431[(6)] = c__10835__auto____$1);

return statearr_70431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
});
})();
var inst_70361 = cljs.core.async.impl.dispatch.run(inst_70360);
var state_70404__$1 = (function (){var statearr_70432 = state_70404;
(statearr_70432[(19)] = inst_70361);

(statearr_70432[(20)] = inst_70332);

return statearr_70432;
})();
var statearr_70433_70494 = state_70404__$1;
(statearr_70433_70494[(2)] = inst_70359);

(statearr_70433_70494[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (31))){
var inst_70380 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_70404__$1 = state_70404;
var statearr_70434_70495 = state_70404__$1;
(statearr_70434_70495[(2)] = inst_70380);

(statearr_70434_70495[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (32))){
var state_70404__$1 = state_70404;
var statearr_70435_70496 = state_70404__$1;
(statearr_70435_70496[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (33))){
var inst_70388 = (state_70404[(2)]);
var state_70404__$1 = state_70404;
var statearr_70437_70497 = state_70404__$1;
(statearr_70437_70497[(2)] = inst_70388);

(statearr_70437_70497[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (13))){
var inst_70295 = (state_70404[(10)]);
var inst_70292 = (state_70404[(2)]);
var inst_70293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70292,(0),null);
var inst_70294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70292,(1),null);
var inst_70295__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70292,(2),null);
var state_70404__$1 = (function (){var statearr_70438 = state_70404;
(statearr_70438[(21)] = inst_70294);

(statearr_70438[(10)] = inst_70295__$1);

(statearr_70438[(22)] = inst_70293);

return statearr_70438;
})();
if(cljs.core.truth_(inst_70295__$1)){
var statearr_70439_70498 = state_70404__$1;
(statearr_70439_70498[(1)] = (14));

} else {
var statearr_70440_70499 = state_70404__$1;
(statearr_70440_70499[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (22))){
var state_70404__$1 = state_70404;
var statearr_70441_70500 = state_70404__$1;
(statearr_70441_70500[(2)] = null);

(statearr_70441_70500[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (36))){
var inst_70386 = (state_70404[(2)]);
var state_70404__$1 = state_70404;
var statearr_70442_70501 = state_70404__$1;
(statearr_70442_70501[(2)] = inst_70386);

(statearr_70442_70501[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (29))){
var inst_70370 = (state_70404[(8)]);
var inst_70378 = (inst_70370 == null);
var state_70404__$1 = state_70404;
if(cljs.core.truth_(inst_70378)){
var statearr_70443_70502 = state_70404__$1;
(statearr_70443_70502[(1)] = (31));

} else {
var statearr_70444_70503 = state_70404__$1;
(statearr_70444_70503[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (6))){
var state_70404__$1 = state_70404;
var statearr_70445_70504 = state_70404__$1;
(statearr_70445_70504[(2)] = null);

(statearr_70445_70504[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (28))){
var inst_70370 = (state_70404[(8)]);
var inst_70376 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70370,"Error processing message in producer."], 0));
var state_70404__$1 = state_70404;
var statearr_70446_70505 = state_70404__$1;
(statearr_70446_70505[(2)] = inst_70376);

(statearr_70446_70505[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (25))){
var state_70404__$1 = state_70404;
var statearr_70447_70506 = state_70404__$1;
(statearr_70447_70506[(2)] = null);

(statearr_70447_70506[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (34))){
var inst_70370 = (state_70404[(8)]);
var inst_70383 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_70370], 0));
var state_70404__$1 = state_70404;
var statearr_70448_70507 = state_70404__$1;
(statearr_70448_70507[(2)] = inst_70383);

(statearr_70448_70507[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (17))){
var inst_70295 = (state_70404[(10)]);
var inst_70284 = (state_70404[(23)]);
var inst_70302 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_70295,inst_70284);
var state_70404__$1 = state_70404;
var statearr_70449_70508 = state_70404__$1;
(statearr_70449_70508[(2)] = inst_70302);

(statearr_70449_70508[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (3))){
var inst_70402 = (state_70404[(2)]);
var state_70404__$1 = state_70404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70404__$1,inst_70402);
} else {
if((state_val_70405 === (12))){
var state_70404__$1 = state_70404;
var statearr_70450_70509 = state_70404__$1;
(statearr_70450_70509[(2)] = null);

(statearr_70450_70509[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (2))){
var state_70404__$1 = state_70404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70404__$1,(4),req_chan);
} else {
if((state_val_70405 === (23))){
var inst_70326 = (state_70404[(12)]);
var inst_70319 = (state_70404[(13)]);
var inst_70320 = (state_70404[(15)]);
var inst_70364 = (state_70404[(2)]);
var inst_70365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70366 = [inst_70319,inst_70326,inst_70320];
var inst_70367 = (new cljs.core.PersistentVector(null,3,(5),inst_70365,inst_70366,null));
var inst_70368 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_70367) : publish_fn.call(null,conn,inst_70367));
var state_70404__$1 = (function (){var statearr_70451 = state_70404;
(statearr_70451[(24)] = inst_70364);

return statearr_70451;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70404__$1,(24),inst_70368);
} else {
if((state_val_70405 === (35))){
var state_70404__$1 = state_70404;
var statearr_70452_70510 = state_70404__$1;
(statearr_70452_70510[(2)] = null);

(statearr_70452_70510[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (19))){
var inst_70308 = (state_70404[(2)]);
var state_70404__$1 = state_70404;
var statearr_70453_70511 = state_70404__$1;
(statearr_70453_70511[(2)] = inst_70308);

(statearr_70453_70511[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (11))){
var inst_70282 = (state_70404[(9)]);
var state_70404__$1 = state_70404;
var statearr_70454_70512 = state_70404__$1;
(statearr_70454_70512[(2)] = inst_70282);

(statearr_70454_70512[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (9))){
var inst_70279 = (state_70404[(7)]);
var inst_70395 = (state_70404[(2)]);
var inst_70396 = (inst_70279 + (1));
var inst_70279__$1 = inst_70396;
var state_70404__$1 = (function (){var statearr_70455 = state_70404;
(statearr_70455[(25)] = inst_70395);

(statearr_70455[(7)] = inst_70279__$1);

return statearr_70455;
})();
var statearr_70456_70513 = state_70404__$1;
(statearr_70456_70513[(2)] = null);

(statearr_70456_70513[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (5))){
var state_70404__$1 = state_70404;
var statearr_70457_70514 = state_70404__$1;
(statearr_70457_70514[(2)] = null);

(statearr_70457_70514[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (14))){
var inst_70295 = (state_70404[(10)]);
var inst_70297 = fluree.db.util.async.channel_QMARK_(inst_70295);
var state_70404__$1 = state_70404;
var statearr_70458_70515 = state_70404__$1;
(statearr_70458_70515[(2)] = inst_70297);

(statearr_70458_70515[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (26))){
var inst_70370 = (state_70404[(8)]);
var inst_70374 = fluree.db.util.core.exception_QMARK_(inst_70370);
var state_70404__$1 = state_70404;
if(inst_70374){
var statearr_70459_70516 = state_70404__$1;
(statearr_70459_70516[(1)] = (28));

} else {
var statearr_70460_70517 = state_70404__$1;
(statearr_70460_70517[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (16))){
var inst_70300 = (state_70404[(2)]);
var state_70404__$1 = state_70404;
if(cljs.core.truth_(inst_70300)){
var statearr_70461_70518 = state_70404__$1;
(statearr_70461_70518[(1)] = (17));

} else {
var statearr_70462_70519 = state_70404__$1;
(statearr_70462_70519[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (30))){
var inst_70390 = (state_70404[(2)]);
var state_70404__$1 = state_70404;
var statearr_70463_70520 = state_70404__$1;
(statearr_70463_70520[(2)] = inst_70390);

(statearr_70463_70520[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (10))){
var inst_70282 = (state_70404[(9)]);
var inst_70284 = (state_70404[(2)]);
var inst_70288 = cljs.core.sequential_QMARK_(inst_70282);
var state_70404__$1 = (function (){var statearr_70464 = state_70404;
(statearr_70464[(23)] = inst_70284);

return statearr_70464;
})();
if(inst_70288){
var statearr_70465_70521 = state_70404__$1;
(statearr_70465_70521[(1)] = (11));

} else {
var statearr_70466_70522 = state_70404__$1;
(statearr_70466_70522[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (18))){
var inst_70282 = (state_70404[(9)]);
var inst_70284 = (state_70404[(23)]);
var inst_70304 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70282], 0));
var inst_70305 = ["Error processing ledger request, no valid return channel: ",inst_70304].join('');
var inst_70306 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70284,inst_70305], 0));
var state_70404__$1 = state_70404;
var statearr_70467_70523 = state_70404__$1;
(statearr_70467_70523[(2)] = inst_70306);

(statearr_70467_70523[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70405 === (8))){
var inst_70321 = (state_70404[(14)]);
var inst_70282 = (state_70404[(9)]);
var inst_70323 = (state_70404[(17)]);
var inst_70322 = (state_70404[(18)]);
var _ = (function (){var statearr_70468 = state_70404;
(statearr_70468[(4)] = cljs.core.cons((20),(state_70404[(4)])));

return statearr_70468;
})();
var inst_70318 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_70282], 0));
var inst_70319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70282,(0),null);
var inst_70320 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70282,(1),null);
var inst_70321__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70282,(2),null);
var inst_70322__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70282,(3),null);
var inst_70323__$1 = cljs.core.__destructure_map(inst_70322__$1);
var inst_70324 = fluree.db.util.core.random_uuid();
var inst_70325 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70324);
var inst_70326 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_70323__$1,cljs.core.cst$kw$req_DASH_id,inst_70325);
var inst_70327 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_70323__$1,cljs.core.cst$kw$timeout,(60000));
var state_70404__$1 = (function (){var statearr_70469 = state_70404;
(statearr_70469[(11)] = inst_70318);

(statearr_70469[(12)] = inst_70326);

(statearr_70469[(13)] = inst_70319);

(statearr_70469[(14)] = inst_70321__$1);

(statearr_70469[(15)] = inst_70320);

(statearr_70469[(16)] = inst_70327);

(statearr_70469[(17)] = inst_70323__$1);

(statearr_70469[(18)] = inst_70322__$1);

return statearr_70469;
})();
if(cljs.core.truth_(inst_70321__$1)){
var statearr_70470_70524 = state_70404__$1;
(statearr_70470_70524[(1)] = (21));

} else {
var statearr_70471_70525 = state_70404__$1;
(statearr_70471_70525[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10798__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10798__auto____0 = (function (){
var statearr_70472 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70472[(0)] = fluree$db$connection$msg_producer_$_state_machine__10798__auto__);

(statearr_70472[(1)] = (1));

return statearr_70472;
});
var fluree$db$connection$msg_producer_$_state_machine__10798__auto____1 = (function (state_70404){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_70404);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e70473){var ex__10801__auto__ = e70473;
var statearr_70474_70526 = state_70404;
(statearr_70474_70526[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_70404[(4)]))){
var statearr_70475_70527 = state_70404;
(statearr_70475_70527[(1)] = cljs.core.first((state_70404[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70528 = state_70404;
state_70404 = G__70528;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10798__auto__ = function(state_70404){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10798__auto____1.call(this,state_70404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10798__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10798__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_70476 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_70476[(6)] = c__10835__auto__);

return statearr_70476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__70529 = conn;
var map__70529__$1 = cljs.core.__destructure_map(map__70529);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70529__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_70611){
var state_val_70612 = (state_70611[(1)]);
if((state_val_70612 === (7))){
var inst_70607 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70613_70664 = state_70611__$1;
(statearr_70613_70664[(2)] = inst_70607);

(statearr_70613_70664[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (20))){
var inst_70548 = (state_70611[(7)]);
var inst_70562 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_70563 = [inst_70548];
var inst_70564 = cljs.core.PersistentHashMap.fromArrays(inst_70562,inst_70563);
var inst_70565 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_70564], 0));
var state_70611__$1 = state_70611;
var statearr_70614_70665 = state_70611__$1;
(statearr_70614_70665[(2)] = inst_70565);

(statearr_70614_70665[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (27))){
var state_70611__$1 = state_70611;
var statearr_70615_70666 = state_70611__$1;
(statearr_70615_70666[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (1))){
var inst_70530 = (0);
var state_70611__$1 = (function (){var statearr_70617 = state_70611;
(statearr_70617[(8)] = inst_70530);

return statearr_70617;
})();
var statearr_70618_70667 = state_70611__$1;
(statearr_70618_70667[(2)] = null);

(statearr_70618_70667[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (24))){
var inst_70541 = (state_70611[(9)]);
var inst_70590 = fluree.db.util.core.exception_QMARK_(inst_70541);
var state_70611__$1 = state_70611;
if(inst_70590){
var statearr_70619_70668 = state_70611__$1;
(statearr_70619_70668[(1)] = (26));

} else {
var statearr_70620_70669 = state_70611__$1;
(statearr_70620_70669[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (4))){
var inst_70535 = (state_70611[(10)]);
var inst_70540 = (state_70611[(2)]);
var inst_70541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70540,(0),null);
var inst_70542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70540,(1),null);
var inst_70543 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70542,inst_70535);
var state_70611__$1 = (function (){var statearr_70621 = state_70611;
(statearr_70621[(9)] = inst_70541);

return statearr_70621;
})();
if(inst_70543){
var statearr_70622_70670 = state_70611__$1;
(statearr_70622_70670[(1)] = (5));

} else {
var statearr_70623_70671 = state_70611__$1;
(statearr_70623_70671[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (15))){
var inst_70548 = (state_70611[(7)]);
var inst_70557 = typeof inst_70548 === 'string';
var state_70611__$1 = state_70611;
if(cljs.core.truth_(inst_70557)){
var statearr_70624_70672 = state_70611__$1;
(statearr_70624_70672[(1)] = (17));

} else {
var statearr_70625_70673 = state_70611__$1;
(statearr_70625_70673[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (21))){
var state_70611__$1 = state_70611;
var statearr_70626_70674 = state_70611__$1;
(statearr_70626_70674[(2)] = null);

(statearr_70626_70674[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (31))){
var inst_70601 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70627_70675 = state_70611__$1;
(statearr_70627_70675[(2)] = inst_70601);

(statearr_70627_70675[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (13))){
var inst_70574 = (state_70611[(2)]);
var inst_70575 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70576 = fluree.db.connection.close_websocket(inst_70575);
var inst_70577 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70578 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_70577);
var state_70611__$1 = (function (){var statearr_70628 = state_70611;
(statearr_70628[(11)] = inst_70574);

(statearr_70628[(12)] = inst_70576);

return statearr_70628;
})();
var statearr_70629_70676 = state_70611__$1;
(statearr_70629_70676[(2)] = inst_70578);

(statearr_70629_70676[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (22))){
var inst_70568 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70630_70677 = state_70611__$1;
(statearr_70630_70677[(2)] = inst_70568);

(statearr_70630_70677[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (29))){
var inst_70541 = (state_70611[(9)]);
var inst_70596 = fluree.db.util.json.parse(inst_70541);
var inst_70597 = fluree.db.conn_events.process_events(conn,inst_70596);
var inst_70530 = (0);
var state_70611__$1 = (function (){var statearr_70631 = state_70611;
(statearr_70631[(13)] = inst_70597);

(statearr_70631[(8)] = inst_70530);

return statearr_70631;
})();
var statearr_70632_70678 = state_70611__$1;
(statearr_70632_70678[(2)] = null);

(statearr_70632_70678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (6))){
var inst_70541 = (state_70611[(9)]);
var inst_70586 = (inst_70541 == null);
var state_70611__$1 = state_70611;
if(cljs.core.truth_(inst_70586)){
var statearr_70633_70679 = state_70611__$1;
(statearr_70633_70679[(1)] = (23));

} else {
var statearr_70634_70680 = state_70611__$1;
(statearr_70634_70680[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (28))){
var inst_70603 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70635_70681 = state_70611__$1;
(statearr_70635_70681[(2)] = inst_70603);

(statearr_70635_70681[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (25))){
var inst_70605 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70636_70682 = state_70611__$1;
(statearr_70636_70682[(2)] = inst_70605);

(statearr_70636_70682[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (17))){
var inst_70548 = (state_70611[(7)]);
var inst_70559 = cljs.core.eval(inst_70548);
var state_70611__$1 = state_70611;
var statearr_70637_70683 = state_70611__$1;
(statearr_70637_70683[(2)] = inst_70559);

(statearr_70637_70683[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (3))){
var inst_70609 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70611__$1,inst_70609);
} else {
if((state_val_70612 === (12))){
var inst_70548 = (state_70611[(7)]);
var inst_70553 = cljs.core.fn_QMARK_(inst_70548);
var state_70611__$1 = state_70611;
if(inst_70553){
var statearr_70638_70684 = state_70611__$1;
(statearr_70638_70684[(1)] = (14));

} else {
var statearr_70639_70685 = state_70611__$1;
(statearr_70639_70685[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (2))){
var inst_70535 = (state_70611[(10)]);
var inst_70535__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_70536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70537 = [sub_chan,inst_70535__$1];
var inst_70538 = (new cljs.core.PersistentVector(null,2,(5),inst_70536,inst_70537,null));
var state_70611__$1 = (function (){var statearr_70640 = state_70611;
(statearr_70640[(10)] = inst_70535__$1);

return statearr_70640;
})();
return cljs.core.async.ioc_alts_BANG_(state_70611__$1,(4),inst_70538);
} else {
if((state_val_70612 === (23))){
var inst_70588 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_70611__$1 = state_70611;
var statearr_70641_70686 = state_70611__$1;
(statearr_70641_70686[(2)] = inst_70588);

(statearr_70641_70686[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (19))){
var inst_70570 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70642_70687 = state_70611__$1;
(statearr_70642_70687[(2)] = inst_70570);

(statearr_70642_70687[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (11))){
var inst_70551 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_70611__$1 = state_70611;
var statearr_70643_70688 = state_70611__$1;
(statearr_70643_70688[(2)] = inst_70551);

(statearr_70643_70688[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (9))){
var inst_70530 = (state_70611[(8)]);
var inst_70580 = fluree.db.connection.ping_transactor(conn);
var inst_70581 = (inst_70530 + (1));
var inst_70530__$1 = inst_70581;
var state_70611__$1 = (function (){var statearr_70644 = state_70611;
(statearr_70644[(14)] = inst_70580);

(statearr_70644[(8)] = inst_70530__$1);

return statearr_70644;
})();
var statearr_70645_70689 = state_70611__$1;
(statearr_70645_70689[(2)] = null);

(statearr_70645_70689[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (5))){
var inst_70530 = (state_70611[(8)]);
var inst_70545 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_70530);
var state_70611__$1 = state_70611;
if(inst_70545){
var statearr_70646_70690 = state_70611__$1;
(statearr_70646_70690[(1)] = (8));

} else {
var statearr_70647_70691 = state_70611__$1;
(statearr_70647_70691[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (14))){
var inst_70548 = (state_70611[(7)]);
var inst_70555 = (inst_70548.cljs$core$IFn$_invoke$arity$0 ? inst_70548.cljs$core$IFn$_invoke$arity$0() : inst_70548.call(null));
var state_70611__$1 = state_70611;
var statearr_70648_70692 = state_70611__$1;
(statearr_70648_70692[(2)] = inst_70555);

(statearr_70648_70692[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (26))){
var inst_70541 = (state_70611[(9)]);
var inst_70592 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70541], 0));
var inst_70530 = (0);
var state_70611__$1 = (function (){var statearr_70649 = state_70611;
(statearr_70649[(15)] = inst_70592);

(statearr_70649[(8)] = inst_70530);

return statearr_70649;
})();
var statearr_70650_70693 = state_70611__$1;
(statearr_70650_70693[(2)] = null);

(statearr_70650_70693[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (16))){
var inst_70572 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70651_70694 = state_70611__$1;
(statearr_70651_70694[(2)] = inst_70572);

(statearr_70651_70694[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (30))){
var state_70611__$1 = state_70611;
var statearr_70652_70695 = state_70611__$1;
(statearr_70652_70695[(2)] = null);

(statearr_70652_70695[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (10))){
var inst_70584 = (state_70611[(2)]);
var state_70611__$1 = state_70611;
var statearr_70653_70696 = state_70611__$1;
(statearr_70653_70696[(2)] = inst_70584);

(statearr_70653_70696[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (18))){
var state_70611__$1 = state_70611;
var statearr_70654_70697 = state_70611__$1;
(statearr_70654_70697[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_70612 === (8))){
var inst_70548 = (state_70611[(7)]);
var inst_70547 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_70548__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_70549 = (inst_70548__$1 == null);
var state_70611__$1 = (function (){var statearr_70656 = state_70611;
(statearr_70656[(16)] = inst_70547);

(statearr_70656[(7)] = inst_70548__$1);

return statearr_70656;
})();
if(cljs.core.truth_(inst_70549)){
var statearr_70657_70698 = state_70611__$1;
(statearr_70657_70698[(1)] = (11));

} else {
var statearr_70658_70699 = state_70611__$1;
(statearr_70658_70699[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__10798__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__10798__auto____0 = (function (){
var statearr_70659 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70659[(0)] = fluree$db$connection$msg_consumer_$_state_machine__10798__auto__);

(statearr_70659[(1)] = (1));

return statearr_70659;
});
var fluree$db$connection$msg_consumer_$_state_machine__10798__auto____1 = (function (state_70611){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_70611);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e70660){var ex__10801__auto__ = e70660;
var statearr_70661_70700 = state_70611;
(statearr_70661_70700[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_70611[(4)]))){
var statearr_70662_70701 = state_70611;
(statearr_70662_70701[(1)] = cljs.core.first((state_70611[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70702 = state_70611;
state_70611 = G__70702;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__10798__auto__ = function(state_70611){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__10798__auto____1.call(this,state_70611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__10798__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__10798__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_70663 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_70663[(6)] = c__10835__auto__);

return statearr_70663;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__70704 = arguments.length;
switch (G__70704) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__70705 = opts;
var map__70705__$1 = cljs.core.__destructure_map(map__70705);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70705__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70705__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_70757){
var state_val_70758 = (state_70757[(1)]);
if((state_val_70758 === (7))){
var inst_70715 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_70716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70717 = [conn_id,cljs.core.cst$kw$token];
var inst_70718 = (new cljs.core.PersistentVector(null,2,(5),inst_70716,inst_70717,null));
var inst_70719 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_70715,inst_70718);
var state_70757__$1 = state_70757;
var statearr_70759_70790 = state_70757__$1;
(statearr_70759_70790[(2)] = inst_70719);

(statearr_70759_70790[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (1))){
var state_70757__$1 = state_70757;
var statearr_70760_70791 = state_70757__$1;
(statearr_70760_70791[(2)] = null);

(statearr_70760_70791[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (4))){
var inst_70706 = (state_70757[(2)]);
var state_70757__$1 = state_70757;
var statearr_70761_70792 = state_70757__$1;
(statearr_70761_70792[(2)] = inst_70706);

(statearr_70761_70792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (15))){
var inst_70726 = (state_70757[(7)]);
var inst_70745 = (state_70757[(2)]);
var inst_70746 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_70747 = [(5000),inst_70745,cljs.core.cst$kw$text];
var inst_70748 = cljs.core.PersistentHashMap.fromArrays(inst_70746,inst_70747);
var inst_70749 = fluree.db.util.xhttp.get(inst_70726,inst_70748);
var state_70757__$1 = state_70757;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70757__$1,(16),inst_70749);
} else {
if((state_val_70758 === (13))){
var inst_70736 = (state_70757[(8)]);
var inst_70726 = (state_70757[(7)]);
var inst_70738 = [cljs.core.cst$kw$headers];
var inst_70739 = [inst_70736];
var inst_70740 = cljs.core.PersistentHashMap.fromArrays(inst_70738,inst_70739);
var inst_70741 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_70726,inst_70740,private$);
var inst_70742 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_70741);
var state_70757__$1 = state_70757;
var statearr_70762_70793 = state_70757__$1;
(statearr_70762_70793[(2)] = inst_70742);

(statearr_70762_70793[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (6))){
var inst_70712 = (state_70757[(9)]);
var state_70757__$1 = state_70757;
var statearr_70763_70794 = state_70757__$1;
(statearr_70763_70794[(2)] = inst_70712);

(statearr_70763_70794[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (3))){
var inst_70755 = (state_70757[(2)]);
var state_70757__$1 = state_70757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70757__$1,inst_70755);
} else {
if((state_val_70758 === (12))){
var inst_70736 = (state_70757[(2)]);
var state_70757__$1 = (function (){var statearr_70764 = state_70757;
(statearr_70764[(8)] = inst_70736);

return statearr_70764;
})();
if(cljs.core.truth_(private$)){
var statearr_70765_70795 = state_70757__$1;
(statearr_70765_70795[(1)] = (13));

} else {
var statearr_70766_70796 = state_70757__$1;
(statearr_70766_70796[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (2))){
var inst_70712 = (state_70757[(9)]);
var _ = (function (){var statearr_70767 = state_70757;
(statearr_70767[(4)] = cljs.core.cons((5),(state_70757[(4)])));

return statearr_70767;
})();
var inst_70712__$1 = jwt;
var state_70757__$1 = (function (){var statearr_70768 = state_70757;
(statearr_70768[(9)] = inst_70712__$1);

return statearr_70768;
})();
if(cljs.core.truth_(inst_70712__$1)){
var statearr_70769_70797 = state_70757__$1;
(statearr_70769_70797[(1)] = (6));

} else {
var statearr_70770_70798 = state_70757__$1;
(statearr_70770_70798[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (11))){
var inst_70730 = (state_70757[(10)]);
var state_70757__$1 = state_70757;
var statearr_70772_70799 = state_70757__$1;
(statearr_70772_70799[(2)] = inst_70730);

(statearr_70772_70799[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (9))){
var inst_70722 = (state_70757[(11)]);
var inst_70721 = (state_70757[(12)]);
var inst_70725 = (state_70757[(2)]);
var inst_70726 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70725),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70722)].join('');
var inst_70728 = ["Accept"];
var inst_70729 = ["application/json"];
var inst_70730 = cljs.core.PersistentHashMap.fromArrays(inst_70728,inst_70729);
var state_70757__$1 = (function (){var statearr_70773 = state_70757;
(statearr_70773[(7)] = inst_70726);

(statearr_70773[(10)] = inst_70730);

return statearr_70773;
})();
if(cljs.core.truth_(inst_70721)){
var statearr_70774_70800 = state_70757__$1;
(statearr_70774_70800[(1)] = (10));

} else {
var statearr_70775_70801 = state_70757__$1;
(statearr_70775_70801[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (5))){
var _ = (function (){var statearr_70776 = state_70757;
(statearr_70776[(4)] = cljs.core.rest((state_70757[(4)])));

return statearr_70776;
})();
var state_70757__$1 = state_70757;
var ex70771 = (state_70757__$1[(2)]);
var statearr_70777_70802 = state_70757__$1;
(statearr_70777_70802[(5)] = ex70771);


if((ex70771 instanceof Error)){
var statearr_70778_70803 = state_70757__$1;
(statearr_70778_70803[(1)] = (4));

(statearr_70778_70803[(5)] = null);

} else {
throw ex70771;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (14))){
var inst_70736 = (state_70757[(8)]);
var state_70757__$1 = state_70757;
var statearr_70779_70804 = state_70757__$1;
(statearr_70779_70804[(2)] = inst_70736);

(statearr_70779_70804[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (16))){
var inst_70751 = (state_70757[(2)]);
var inst_70752 = fluree.db.util.async.throw_err(inst_70751);
var _ = (function (){var statearr_70780 = state_70757;
(statearr_70780[(4)] = cljs.core.rest((state_70757[(4)])));

return statearr_70780;
})();
var state_70757__$1 = state_70757;
var statearr_70781_70805 = state_70757__$1;
(statearr_70781_70805[(2)] = inst_70752);

(statearr_70781_70805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (10))){
var inst_70721 = (state_70757[(12)]);
var inst_70730 = (state_70757[(10)]);
var inst_70732 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70721)].join('');
var inst_70733 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70730,"Authorization",inst_70732);
var state_70757__$1 = state_70757;
var statearr_70782_70806 = state_70757__$1;
(statearr_70782_70806[(2)] = inst_70733);

(statearr_70782_70806[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70758 === (8))){
var inst_70721 = (state_70757[(2)]);
var inst_70722 = clojure.string.replace(k,"_","/");
var inst_70723 = fluree.db.connection.get_server(conn_id,servers);
var state_70757__$1 = (function (){var statearr_70783 = state_70757;
(statearr_70783[(11)] = inst_70722);

(statearr_70783[(12)] = inst_70721);

return statearr_70783;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70757__$1,(9),inst_70723);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10798__auto__ = null;
var fluree$db$connection$state_machine__10798__auto____0 = (function (){
var statearr_70784 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70784[(0)] = fluree$db$connection$state_machine__10798__auto__);

(statearr_70784[(1)] = (1));

return statearr_70784;
});
var fluree$db$connection$state_machine__10798__auto____1 = (function (state_70757){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_70757);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e70785){var ex__10801__auto__ = e70785;
var statearr_70786_70807 = state_70757;
(statearr_70786_70807[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_70757[(4)]))){
var statearr_70787_70808 = state_70757;
(statearr_70787_70808[(1)] = cljs.core.first((state_70757[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70809 = state_70757;
state_70757 = G__70809;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10798__auto__ = function(state_70757){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10798__auto____1.call(this,state_70757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10798__auto____0;
fluree$db$connection$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10798__auto____1;
return fluree$db$connection$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_70788 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_70788[(6)] = c__10835__auto__);

return statearr_70788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__70810_SHARP_){
if(cljs.core.truth_(p1__70810_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__70811_SHARP_){
var or__4223__auto__ = p1__70811_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e70812){var e = e70812;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__70813 = opts;
var map__70813__$1 = cljs.core.__destructure_map(map__70813);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__70813__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70813__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__70814_70815 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__70814_70815.cljs$core$IFn$_invoke$arity$0 ? fexpr__70814_70815.cljs$core$IFn$_invoke$arity$0() : fexpr__70814_70815.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___70856 = arguments.length;
var i__4830__auto___70857 = (0);
while(true){
if((i__4830__auto___70857 < len__4829__auto___70856)){
args__4835__auto__.push((arguments[i__4830__auto___70857]));

var G__70858 = (i__4830__auto___70857 + (1));
i__4830__auto___70857 = G__70858;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__70818){
var vec__70819 = p__70818;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70819,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__10835__auto___70859 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_70839){
var state_val_70840 = (state_70839[(1)]);
if((state_val_70840 === (1))){
var inst_70822 = fluree.db.connection.get_socket(conn);
var state_70839__$1 = state_70839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70839__$1,(2),inst_70822);
} else {
if((state_val_70840 === (2))){
var inst_70824 = (state_70839[(7)]);
var inst_70825 = (state_70839[(8)]);
var inst_70824__$1 = (state_70839[(2)]);
var inst_70825__$1 = (inst_70824__$1 == null);
var state_70839__$1 = (function (){var statearr_70841 = state_70839;
(statearr_70841[(7)] = inst_70824__$1);

(statearr_70841[(8)] = inst_70825__$1);

return statearr_70841;
})();
if(cljs.core.truth_(inst_70825__$1)){
var statearr_70842_70860 = state_70839__$1;
(statearr_70842_70860[(1)] = (3));

} else {
var statearr_70843_70861 = state_70839__$1;
(statearr_70843_70861[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70840 === (3))){
var inst_70825 = (state_70839[(8)]);
var state_70839__$1 = state_70839;
var statearr_70844_70862 = state_70839__$1;
(statearr_70844_70862[(2)] = inst_70825);

(statearr_70844_70862[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70840 === (4))){
var inst_70824 = (state_70839[(7)]);
var inst_70828 = fluree.db.util.core.exception_QMARK_(inst_70824);
var state_70839__$1 = state_70839;
var statearr_70845_70863 = state_70839__$1;
(statearr_70845_70863[(2)] = inst_70828);

(statearr_70845_70863[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70840 === (5))){
var inst_70830 = (state_70839[(2)]);
var state_70839__$1 = state_70839;
if(cljs.core.truth_(inst_70830)){
var statearr_70846_70864 = state_70839__$1;
(statearr_70846_70864[(1)] = (6));

} else {
var statearr_70847_70865 = state_70839__$1;
(statearr_70847_70865[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70840 === (6))){
var inst_70832 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_70833 = cljs.core.async.close_BANG_(conn);
var state_70839__$1 = (function (){var statearr_70848 = state_70839;
(statearr_70848[(9)] = inst_70832);

return statearr_70848;
})();
var statearr_70849_70866 = state_70839__$1;
(statearr_70849_70866[(2)] = inst_70833);

(statearr_70849_70866[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70840 === (7))){
var inst_70835 = fluree.db.connection.msg_consumer(conn);
var state_70839__$1 = state_70839;
var statearr_70850_70867 = state_70839__$1;
(statearr_70850_70867[(2)] = inst_70835);

(statearr_70850_70867[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70840 === (8))){
var inst_70837 = (state_70839[(2)]);
var state_70839__$1 = state_70839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70839__$1,inst_70837);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10798__auto__ = null;
var fluree$db$connection$state_machine__10798__auto____0 = (function (){
var statearr_70851 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70851[(0)] = fluree$db$connection$state_machine__10798__auto__);

(statearr_70851[(1)] = (1));

return statearr_70851;
});
var fluree$db$connection$state_machine__10798__auto____1 = (function (state_70839){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_70839);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e70852){var ex__10801__auto__ = e70852;
var statearr_70853_70868 = state_70839;
(statearr_70853_70868[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_70839[(4)]))){
var statearr_70854_70869 = state_70839;
(statearr_70854_70869[(1)] = cljs.core.first((state_70839[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__70870 = state_70839;
state_70839 = G__70870;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10798__auto__ = function(state_70839){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10798__auto____1.call(this,state_70839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10798__auto____0;
fluree$db$connection$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10798__auto____1;
return fluree$db$connection$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_70855 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_70855[(6)] = c__10835__auto___70859);

return statearr_70855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq70816){
var G__70817 = cljs.core.first(seq70816);
var seq70816__$1 = cljs.core.next(seq70816);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70817,seq70816__$1);
}));

