// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4221__auto__ = typeof value === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4221__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,300,null,300,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,714,null,714,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,230,null,230,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,157,null,157,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,812,null,812,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,521,null,521,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,427,null,427,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,145,null,145,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,388,null,388,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,256,null,256,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,86,null,86,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,726,null,726,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,533,null,533,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,607,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,620,null,620,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,750,null,750,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,169,null,169,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,778,null,778,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,414,null,414,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,466,null,466,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,73,null,73,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,188,null,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,659,null,659,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,453,null,453,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,594,null,594,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,506,null,506,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,332,332,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,545,null,545,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,800,null,800,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,440,null,440,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,270,null,270,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,121,null,121,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,401,null,401,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,581,null,581,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,347,347,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,214,null,214,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,58,null,58,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,133,null,133,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,633,null,633,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,201,null,201,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,646,null,646,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,479,null,479,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,288,null,288,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,738,null,738,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,243,null,243,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__68797 = cljs.core.meta(f);
var map__68797__$1 = cljs.core.__destructure_map(map__68797);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68797__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68797__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4221__auto__ = (function (){var G__68799 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__68798 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__68798.cljs$core$IFn$_invoke$arity$1 ? fexpr__68798.cljs$core$IFn$_invoke$arity$1(G__68799) : fexpr__68798.call(null,G__68799));
})();
if(cljs.core.truth_(and__4221__auto__)){
var G__68801 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__68800 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__68800.cljs$core$IFn$_invoke$arity$1 ? fexpr__68800.cljs$core$IFn$_invoke$arity$1(G__68801) : fexpr__68800.call(null,G__68801));
} else {
return and__4221__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__68796_SHARP_){
return (cljs.core.count(p1__68796_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68886){
var state_val_68887 = (state_68886[(1)]);
if((state_val_68887 === (7))){
var inst_68811 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_68812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68813 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_68814 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_68815 = [fn_name,inst_68813,inst_68814];
var inst_68816 = (new cljs.core.PersistentVector(null,3,(5),inst_68812,inst_68815,null));
var inst_68817 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68811,inst_68816);
var state_68886__$1 = state_68886;
var statearr_68888_68925 = state_68886__$1;
(statearr_68888_68925[(2)] = inst_68817);

(statearr_68888_68925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (1))){
var state_68886__$1 = state_68886;
var statearr_68889_68926 = state_68886__$1;
(statearr_68889_68926[(2)] = null);

(statearr_68889_68926[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (4))){
var inst_68802 = (state_68886[(2)]);
var state_68886__$1 = state_68886;
var statearr_68890_68927 = state_68886__$1;
(statearr_68890_68927[(2)] = inst_68802);

(statearr_68890_68927[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (15))){
var inst_68835 = (state_68886[(7)]);
var inst_68849 = (state_68886[(8)]);
var inst_68847 = (state_68886[(2)]);
var inst_68848 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68835,"_fn/params");
var inst_68849__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_68848);
var inst_68850 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68835,"_fn/code");
var inst_68851 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_68850);
var inst_68852 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_68851,funType,inst_68849__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_68851,funType,inst_68849__$1));
var state_68886__$1 = (function (){var statearr_68891 = state_68886;
(statearr_68891[(9)] = inst_68847);

(statearr_68891[(8)] = inst_68849__$1);

return statearr_68891;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68886__$1,(16),inst_68852);
} else {
if((state_val_68887 === (13))){
var inst_68838 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_68839 = ["Unknown function: ",inst_68838].join('');
var inst_68840 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_68841 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_68842 = cljs.core.PersistentHashMap.fromArrays(inst_68840,inst_68841);
var inst_68843 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68839,inst_68842);
var inst_68844 = (function(){throw inst_68843})();
var state_68886__$1 = state_68886;
var statearr_68892_68928 = state_68886__$1;
(statearr_68892_68928[(2)] = inst_68844);

(statearr_68892_68928[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (6))){
var state_68886__$1 = state_68886;
var statearr_68893_68929 = state_68886__$1;
(statearr_68893_68929[(2)] = null);

(statearr_68893_68929[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (17))){
var state_68886__$1 = state_68886;
var statearr_68894_68930 = state_68886__$1;
(statearr_68894_68930[(2)] = null);

(statearr_68894_68930[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (3))){
var inst_68884 = (state_68886[(2)]);
var state_68886__$1 = state_68886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68886__$1,inst_68884);
} else {
if((state_val_68887 === (12))){
var inst_68835 = (state_68886[(7)]);
var inst_68834 = (state_68886[(2)]);
var inst_68835__$1 = fluree.db.util.async.throw_err(inst_68834);
var inst_68836 = cljs.core.empty_QMARK_(inst_68835__$1);
var state_68886__$1 = (function (){var statearr_68895 = state_68886;
(statearr_68895[(7)] = inst_68835__$1);

return statearr_68895;
})();
if(inst_68836){
var statearr_68896_68931 = state_68886__$1;
(statearr_68896_68931[(1)] = (13));

} else {
var statearr_68897_68932 = state_68886__$1;
(statearr_68897_68932[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (2))){
var inst_68808 = (state_68886[(10)]);
var _ = (function (){var statearr_68898 = state_68886;
(statearr_68898[(4)] = cljs.core.cons((5),(state_68886[(4)])));

return statearr_68898;
})();
var inst_68808__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_68886__$1 = (function (){var statearr_68899 = state_68886;
(statearr_68899[(10)] = inst_68808__$1);

return statearr_68899;
})();
if(cljs.core.truth_(inst_68808__$1)){
var statearr_68900_68933 = state_68886__$1;
(statearr_68900_68933[(1)] = (6));

} else {
var statearr_68901_68934 = state_68886__$1;
(statearr_68901_68934[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (19))){
var inst_68869 = (state_68886[(11)]);
var inst_68879 = (state_68886[(2)]);
var state_68886__$1 = (function (){var statearr_68902 = state_68886;
(statearr_68902[(12)] = inst_68879);

return statearr_68902;
})();
var statearr_68903_68935 = state_68886__$1;
(statearr_68903_68935[(2)] = inst_68869);

(statearr_68903_68935[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (11))){
var inst_68881 = (state_68886[(2)]);
var _ = (function (){var statearr_68905 = state_68886;
(statearr_68905[(4)] = cljs.core.rest((state_68886[(4)])));

return statearr_68905;
})();
var state_68886__$1 = state_68886;
var statearr_68906_68936 = state_68886__$1;
(statearr_68906_68936[(2)] = inst_68881);

(statearr_68906_68936[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (9))){
var inst_68819 = (state_68886[(13)]);
var state_68886__$1 = state_68886;
var statearr_68907_68937 = state_68886__$1;
(statearr_68907_68937[(2)] = inst_68819);

(statearr_68907_68937[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (5))){
var _ = (function (){var statearr_68908 = state_68886;
(statearr_68908[(4)] = cljs.core.rest((state_68886[(4)])));

return statearr_68908;
})();
var state_68886__$1 = state_68886;
var ex68904 = (state_68886__$1[(2)]);
var statearr_68909_68938 = state_68886__$1;
(statearr_68909_68938[(5)] = ex68904);


if((ex68904 instanceof Error)){
var statearr_68910_68939 = state_68886__$1;
(statearr_68910_68939[(1)] = (4));

(statearr_68910_68939[(5)] = null);

} else {
throw ex68904;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (14))){
var state_68886__$1 = state_68886;
var statearr_68911_68940 = state_68886__$1;
(statearr_68911_68940[(2)] = null);

(statearr_68911_68940[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (16))){
var inst_68835 = (state_68886[(7)]);
var inst_68847 = (state_68886[(9)]);
var inst_68819 = (state_68886[(13)]);
var inst_68849 = (state_68886[(8)]);
var inst_68808 = (state_68886[(10)]);
var inst_68831 = (state_68886[(14)]);
var inst_68854 = (state_68886[(2)]);
var inst_68855 = fluree.db.util.async.throw_err(inst_68854);
var inst_68856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_68835,"_fn/spec");
var inst_68857 = cljs.core.PersistentVector.EMPTY;
var inst_68858 = cljs.core.cst$sym$_QMARK_ctx;
var inst_68859 = (function (){var forward_time_travel_db_QMARK_ = inst_68808;
var or__4223__auto__ = inst_68819;
var query = inst_68831;
var res = inst_68835;
var _ = inst_68847;
var params = inst_68849;
var code = inst_68855;
var spec = inst_68856;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_68860 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_68859,inst_68849);
var inst_68861 = cljs.core.cons(inst_68858,inst_68860);
var inst_68862 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_68857,inst_68861);
var inst_68863 = fluree.db.dbfunctions.core.build_fn(inst_68862,inst_68855);
var inst_68864 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_68865 = cljs.core.count(inst_68849);
var inst_68866 = [inst_68865];
var inst_68867 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_68866);
var inst_68868 = [inst_68863,inst_68849,inst_68867,false,inst_68856,null];
var inst_68869 = cljs.core.PersistentHashMap.fromArrays(inst_68864,inst_68868);
var state_68886__$1 = (function (){var statearr_68912 = state_68886;
(statearr_68912[(11)] = inst_68869);

return statearr_68912;
})();
if(cljs.core.truth_(inst_68808)){
var statearr_68913_68941 = state_68886__$1;
(statearr_68913_68941[(1)] = (17));

} else {
var statearr_68914_68942 = state_68886__$1;
(statearr_68914_68942[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (10))){
var inst_68831 = (state_68886[(14)]);
var inst_68822 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_68823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68824 = ["_fn/params","_fn/code","_fn/spec"];
var inst_68825 = (new cljs.core.PersistentVector(null,3,(5),inst_68823,inst_68824,null));
var inst_68826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68827 = cljs.core.name(fn_name);
var inst_68828 = ["_fn/name",inst_68827];
var inst_68829 = (new cljs.core.PersistentVector(null,2,(5),inst_68826,inst_68828,null));
var inst_68830 = [inst_68825,inst_68829];
var inst_68831__$1 = cljs.core.PersistentHashMap.fromArrays(inst_68822,inst_68830);
var inst_68832 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_68831__$1);
var state_68886__$1 = (function (){var statearr_68915 = state_68886;
(statearr_68915[(14)] = inst_68831__$1);

return statearr_68915;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68886__$1,(12),inst_68832);
} else {
if((state_val_68887 === (18))){
var inst_68869 = (state_68886[(11)]);
var inst_68872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68873 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_68874 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_68875 = [fn_name,inst_68873,inst_68874];
var inst_68876 = (new cljs.core.PersistentVector(null,3,(5),inst_68872,inst_68875,null));
var inst_68877 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_68876,inst_68869);
var state_68886__$1 = state_68886;
var statearr_68916_68943 = state_68886__$1;
(statearr_68916_68943[(2)] = inst_68877);

(statearr_68916_68943[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68887 === (8))){
var inst_68819 = (state_68886[(13)]);
var inst_68819__$1 = (state_68886[(2)]);
var state_68886__$1 = (function (){var statearr_68917 = state_68886;
(statearr_68917[(13)] = inst_68819__$1);

return statearr_68917;
})();
if(cljs.core.truth_(inst_68819__$1)){
var statearr_68918_68944 = state_68886__$1;
(statearr_68918_68944[(1)] = (9));

} else {
var statearr_68919_68945 = state_68886__$1;
(statearr_68919_68945[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto____0 = (function (){
var statearr_68920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68920[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto__);

(statearr_68920[(1)] = (1));

return statearr_68920;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto____1 = (function (state_68886){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68886);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68921){var ex__10801__auto__ = e68921;
var statearr_68922_68946 = state_68886;
(statearr_68922_68946[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68886[(4)]))){
var statearr_68923_68947 = state_68886;
(statearr_68923_68947[(1)] = cljs.core.first((state_68886[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68948 = state_68886;
state_68886 = G__68948;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto__ = function(state_68886){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto____1.call(this,state_68886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68924 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68924[(6)] = c__10835__auto__);

return statearr_68924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__68950 = arguments.length;
switch (G__68950) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__68954 = arguments.length;
switch (G__68954) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_69084){
var state_val_69085 = (state_69084[(1)]);
if((state_val_69085 === (7))){
var inst_69079 = (state_69084[(2)]);
var _ = (function (){var statearr_69086 = state_69084;
(statearr_69086[(4)] = cljs.core.rest((state_69084[(4)])));

return statearr_69086;
})();
var state_69084__$1 = state_69084;
var statearr_69087_69167 = state_69084__$1;
(statearr_69087_69167[(2)] = inst_69079);

(statearr_69087_69167[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (20))){
var inst_68993 = (state_69084[(7)]);
var state_69084__$1 = state_69084;
var statearr_69088_69168 = state_69084__$1;
(statearr_69088_69168[(2)] = inst_68993);

(statearr_69088_69168[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (27))){
var inst_68980 = (state_69084[(8)]);
var inst_69006 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_69007 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68980)," used in function.",inst_69006].join('');
var inst_69008 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69009 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_69010 = cljs.core.PersistentHashMap.fromArrays(inst_69008,inst_69009);
var inst_69011 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69007,inst_69010);
var inst_69012 = (function(){throw inst_69011})();
var state_69084__$1 = state_69084;
var statearr_69089_69169 = state_69084__$1;
(statearr_69089_69169[(2)] = inst_69012);

(statearr_69089_69169[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (1))){
var state_69084__$1 = state_69084;
var statearr_69090_69170 = state_69084__$1;
(statearr_69090_69170[(2)] = null);

(statearr_69090_69170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (24))){
var inst_69003 = (state_69084[(9)]);
var inst_69003__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_69084__$1 = (function (){var statearr_69091 = state_69084;
(statearr_69091[(9)] = inst_69003__$1);

return statearr_69091;
})();
if(inst_69003__$1){
var statearr_69092_69171 = state_69084__$1;
(statearr_69092_69171[(1)] = (26));

} else {
var statearr_69093_69172 = state_69084__$1;
(statearr_69093_69172[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (39))){
var inst_68980 = (state_69084[(8)]);
var inst_69040 = (inst_68980 == null);
var state_69084__$1 = state_69084;
if(cljs.core.truth_(inst_69040)){
var statearr_69094_69173 = state_69084__$1;
(statearr_69094_69173[(1)] = (42));

} else {
var statearr_69095_69174 = state_69084__$1;
(statearr_69095_69174[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (46))){
var state_69084__$1 = state_69084;
var statearr_69096_69175 = state_69084__$1;
(statearr_69096_69175[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (4))){
var inst_68955 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69098_69176 = state_69084__$1;
(statearr_69098_69176[(2)] = inst_68955);

(statearr_69098_69176[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (15))){
var inst_68980 = (state_69084[(8)]);
var inst_68991 = (inst_68980 instanceof cljs.core.Symbol);
var state_69084__$1 = state_69084;
if(cljs.core.truth_(inst_68991)){
var statearr_69099_69177 = state_69084__$1;
(statearr_69099_69177[(1)] = (17));

} else {
var statearr_69100_69178 = state_69084__$1;
(statearr_69100_69178[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (48))){
var inst_69047 = (state_69084[(2)]);
var inst_69048 = fluree.db.util.async.throw_err(inst_69047);
var state_69084__$1 = state_69084;
var statearr_69101_69179 = state_69084__$1;
(statearr_69101_69179[(2)] = inst_69048);

(statearr_69101_69179[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (50))){
var state_69084__$1 = state_69084;
var statearr_69102_69180 = state_69084__$1;
(statearr_69102_69180[(2)] = null);

(statearr_69102_69180[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (21))){
var inst_69000 = (state_69084[(10)]);
var inst_68973 = (state_69084[(11)]);
var inst_68968 = (state_69084[(12)]);
var inst_68970 = (state_69084[(13)]);
var inst_68971 = (state_69084[(14)]);
var inst_68981 = (state_69084[(15)]);
var inst_68980 = (state_69084[(8)]);
var inst_68993 = (state_69084[(7)]);
var inst_68974 = (state_69084[(16)]);
var inst_68996 = [inst_68980];
var inst_68997 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_68996);
var inst_68998 = (function (){var x = inst_68980;
var first__68978 = inst_68980;
var r = inst_68981;
var seq__68966 = inst_68971;
var vec__68976 = inst_68973;
var acc = inst_68974;
var first__68967 = inst_68970;
var G__68964 = inst_68973;
var or__4223__auto__ = inst_68993;
var seq__68977 = inst_68981;
var vec__68965 = inst_68968;
return (function (p1__68952_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__68952_SHARP_);
});
})();
var inst_68999 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_68998,params);
var inst_69000__$1 = cljs.core.some(inst_68997,inst_68999);
var state_69084__$1 = (function (){var statearr_69103 = state_69084;
(statearr_69103[(10)] = inst_69000__$1);

return statearr_69103;
})();
if(cljs.core.truth_(inst_69000__$1)){
var statearr_69104_69181 = state_69084__$1;
(statearr_69104_69181[(1)] = (23));

} else {
var statearr_69105_69182 = state_69084__$1;
(statearr_69105_69182[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (31))){
var inst_69030 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
if(cljs.core.truth_(inst_69030)){
var statearr_69106_69183 = state_69084__$1;
(statearr_69106_69183[(1)] = (35));

} else {
var statearr_69107_69184 = state_69084__$1;
(statearr_69107_69184[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (32))){
var inst_69023 = (state_69084[(17)]);
var state_69084__$1 = state_69084;
var statearr_69108_69185 = state_69084__$1;
(statearr_69108_69185[(2)] = inst_69023);

(statearr_69108_69185[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (40))){
var inst_69065 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69109_69186 = state_69084__$1;
(statearr_69109_69186[(2)] = inst_69065);

(statearr_69109_69186[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (33))){
var inst_68980 = (state_69084[(8)]);
var inst_69026 = (inst_68980 == null);
var state_69084__$1 = state_69084;
var statearr_69110_69187 = state_69084__$1;
(statearr_69110_69187[(2)] = inst_69026);

(statearr_69110_69187[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (13))){
var inst_68981 = (state_69084[(15)]);
var inst_68974 = (state_69084[(16)]);
var inst_69073 = (state_69084[(2)]);
var inst_69074 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_68974,inst_69073);
var inst_68973 = inst_68981;
var inst_68974__$1 = inst_69074;
var state_69084__$1 = (function (){var statearr_69111 = state_69084;
(statearr_69111[(11)] = inst_68973);

(statearr_69111[(16)] = inst_68974__$1);

return statearr_69111;
})();
var statearr_69112_69188 = state_69084__$1;
(statearr_69112_69188[(2)] = null);

(statearr_69112_69188[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (22))){
var inst_69018 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69113_69189 = state_69084__$1;
(statearr_69113_69189[(2)] = inst_69018);

(statearr_69113_69189[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (36))){
var inst_68980 = (state_69084[(8)]);
var inst_69033 = cljs.core.vector_QMARK_(inst_68980);
var state_69084__$1 = state_69084;
if(inst_69033){
var statearr_69114_69190 = state_69084__$1;
(statearr_69114_69190[(1)] = (38));

} else {
var statearr_69115_69191 = state_69084__$1;
(statearr_69115_69191[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (41))){
var inst_69037 = (state_69084[(2)]);
var inst_69038 = fluree.db.util.async.throw_err(inst_69037);
var state_69084__$1 = state_69084;
var statearr_69116_69192 = state_69084__$1;
(statearr_69116_69192[(2)] = inst_69038);

(statearr_69116_69192[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (43))){
var inst_68980 = (state_69084[(8)]);
var inst_69043 = cljs.core.list_QMARK_(inst_68980);
var state_69084__$1 = state_69084;
if(inst_69043){
var statearr_69117_69193 = state_69084__$1;
(statearr_69117_69193[(1)] = (45));

} else {
var statearr_69118_69194 = state_69084__$1;
(statearr_69118_69194[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (29))){
var inst_69020 = (state_69084[(18)]);
var state_69084__$1 = state_69084;
var statearr_69119_69195 = state_69084__$1;
(statearr_69119_69195[(2)] = inst_69020);

(statearr_69119_69195[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (44))){
var inst_69063 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69120_69196 = state_69084__$1;
(statearr_69120_69196[(2)] = inst_69063);

(statearr_69120_69196[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (6))){
var inst_68973 = (state_69084[(11)]);
var inst_68980 = (state_69084[(8)]);
var inst_68979 = cljs.core.seq(inst_68973);
var inst_68980__$1 = cljs.core.first(inst_68979);
var inst_68981 = cljs.core.next(inst_68979);
var inst_68982 = (inst_68980__$1 == null);
var state_69084__$1 = (function (){var statearr_69121 = state_69084;
(statearr_69121[(15)] = inst_68981);

(statearr_69121[(8)] = inst_68980__$1);

return statearr_69121;
})();
if(cljs.core.truth_(inst_68982)){
var statearr_69122_69197 = state_69084__$1;
(statearr_69122_69197[(1)] = (8));

} else {
var statearr_69123_69198 = state_69084__$1;
(statearr_69123_69198[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (28))){
var inst_69014 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69124_69199 = state_69084__$1;
(statearr_69124_69199[(2)] = inst_69014);

(statearr_69124_69199[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (51))){
var inst_69059 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69125_69200 = state_69084__$1;
(statearr_69125_69200[(2)] = inst_69059);

(statearr_69125_69200[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (25))){
var inst_69016 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69126_69201 = state_69084__$1;
(statearr_69126_69201[(2)] = inst_69016);

(statearr_69126_69201[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (34))){
var inst_69028 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69127_69202 = state_69084__$1;
(statearr_69127_69202[(2)] = inst_69028);

(statearr_69127_69202[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (17))){
var inst_68980 = (state_69084[(8)]);
var inst_68993 = (state_69084[(7)]);
var inst_68993__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_68980) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_68980));
var state_69084__$1 = (function (){var statearr_69128 = state_69084;
(statearr_69128[(7)] = inst_68993__$1);

return statearr_69128;
})();
if(cljs.core.truth_(inst_68993__$1)){
var statearr_69129_69203 = state_69084__$1;
(statearr_69129_69203[(1)] = (20));

} else {
var statearr_69130_69204 = state_69084__$1;
(statearr_69130_69204[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (3))){
var inst_69082 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69084__$1,inst_69082);
} else {
if((state_val_69085 === (12))){
var inst_68980 = (state_69084[(8)]);
var inst_68988 = typeof inst_68980 === 'number';
var state_69084__$1 = state_69084;
if(cljs.core.truth_(inst_68988)){
var statearr_69131_69205 = state_69084__$1;
(statearr_69131_69205[(1)] = (14));

} else {
var statearr_69132_69206 = state_69084__$1;
(statearr_69132_69206[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (2))){
var inst_68968 = (state_69084[(12)]);
var _ = (function (){var statearr_69133 = state_69084;
(statearr_69133[(4)] = cljs.core.cons((5),(state_69084[(4)])));

return statearr_69133;
})();
var inst_68968__$1 = vec;
var inst_68969 = cljs.core.seq(inst_68968__$1);
var inst_68970 = cljs.core.first(inst_68969);
var inst_68971 = cljs.core.next(inst_68969);
var inst_68972 = cljs.core.PersistentVector.EMPTY;
var inst_68973 = inst_68968__$1;
var inst_68974 = inst_68972;
var state_69084__$1 = (function (){var statearr_69134 = state_69084;
(statearr_69134[(11)] = inst_68973);

(statearr_69134[(12)] = inst_68968__$1);

(statearr_69134[(13)] = inst_68970);

(statearr_69134[(14)] = inst_68971);

(statearr_69134[(16)] = inst_68974);

return statearr_69134;
})();
var statearr_69135_69207 = state_69084__$1;
(statearr_69135_69207[(2)] = null);

(statearr_69135_69207[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (23))){
var inst_69000 = (state_69084[(10)]);
var state_69084__$1 = state_69084;
var statearr_69136_69208 = state_69084__$1;
(statearr_69136_69208[(2)] = inst_69000);

(statearr_69136_69208[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (47))){
var inst_69061 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69137_69209 = state_69084__$1;
(statearr_69137_69209[(2)] = inst_69061);

(statearr_69137_69209[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (35))){
var inst_68980 = (state_69084[(8)]);
var state_69084__$1 = state_69084;
var statearr_69138_69210 = state_69084__$1;
(statearr_69138_69210[(2)] = inst_68980);

(statearr_69138_69210[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (19))){
var inst_69069 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69139_69211 = state_69084__$1;
(statearr_69139_69211[(2)] = inst_69069);

(statearr_69139_69211[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (11))){
var inst_68980 = (state_69084[(8)]);
var state_69084__$1 = state_69084;
var statearr_69141_69212 = state_69084__$1;
(statearr_69141_69212[(2)] = inst_68980);

(statearr_69141_69212[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (9))){
var inst_68980 = (state_69084[(8)]);
var inst_68985 = typeof inst_68980 === 'string';
var state_69084__$1 = state_69084;
if(cljs.core.truth_(inst_68985)){
var statearr_69142_69213 = state_69084__$1;
(statearr_69142_69213[(1)] = (11));

} else {
var statearr_69143_69214 = state_69084__$1;
(statearr_69143_69214[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (5))){
var _ = (function (){var statearr_69144 = state_69084;
(statearr_69144[(4)] = cljs.core.rest((state_69084[(4)])));

return statearr_69144;
})();
var state_69084__$1 = state_69084;
var ex69140 = (state_69084__$1[(2)]);
var statearr_69145_69215 = state_69084__$1;
(statearr_69145_69215[(5)] = ex69140);


if((ex69140 instanceof Error)){
var statearr_69146_69216 = state_69084__$1;
(statearr_69146_69216[(1)] = (4));

(statearr_69146_69216[(5)] = null);

} else {
throw ex69140;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (14))){
var inst_68980 = (state_69084[(8)]);
var state_69084__$1 = state_69084;
var statearr_69147_69217 = state_69084__$1;
(statearr_69147_69217[(2)] = inst_68980);

(statearr_69147_69217[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (45))){
var inst_68980 = (state_69084[(8)]);
var inst_69045 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_68980,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_68980,funType,params));
var state_69084__$1 = state_69084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69084__$1,(48),inst_69045);
} else {
if((state_val_69085 === (26))){
var inst_69003 = (state_69084[(9)]);
var state_69084__$1 = state_69084;
var statearr_69148_69218 = state_69084__$1;
(statearr_69148_69218[(2)] = inst_69003);

(statearr_69148_69218[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (16))){
var inst_69071 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69149_69219 = state_69084__$1;
(statearr_69149_69219[(2)] = inst_69071);

(statearr_69149_69219[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (38))){
var inst_68980 = (state_69084[(8)]);
var inst_69035 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_68980,funType,params);
var state_69084__$1 = state_69084;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69084__$1,(41),inst_69035);
} else {
if((state_val_69085 === (30))){
var inst_68980 = (state_69084[(8)]);
var inst_69023 = (state_69084[(17)]);
var inst_69023__$1 = inst_68980 === false;
var state_69084__$1 = (function (){var statearr_69150 = state_69084;
(statearr_69150[(17)] = inst_69023__$1);

return statearr_69150;
})();
if(cljs.core.truth_(inst_69023__$1)){
var statearr_69151_69220 = state_69084__$1;
(statearr_69151_69220[(1)] = (32));

} else {
var statearr_69152_69221 = state_69084__$1;
(statearr_69152_69221[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (10))){
var inst_69077 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69153_69222 = state_69084__$1;
(statearr_69153_69222[(2)] = inst_69077);

(statearr_69153_69222[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (18))){
var inst_69020 = (state_69084[(18)]);
var inst_68980 = (state_69084[(8)]);
var inst_69020__$1 = inst_68980 === true;
var state_69084__$1 = (function (){var statearr_69154 = state_69084;
(statearr_69154[(18)] = inst_69020__$1);

return statearr_69154;
})();
if(cljs.core.truth_(inst_69020__$1)){
var statearr_69155_69223 = state_69084__$1;
(statearr_69155_69223[(1)] = (29));

} else {
var statearr_69156_69224 = state_69084__$1;
(statearr_69156_69224[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (42))){
var inst_68980 = (state_69084[(8)]);
var state_69084__$1 = state_69084;
var statearr_69157_69225 = state_69084__$1;
(statearr_69157_69225[(2)] = inst_68980);

(statearr_69157_69225[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (37))){
var inst_69067 = (state_69084[(2)]);
var state_69084__$1 = state_69084;
var statearr_69158_69226 = state_69084__$1;
(statearr_69158_69226[(2)] = inst_69067);

(statearr_69158_69226[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (8))){
var inst_68974 = (state_69084[(16)]);
var state_69084__$1 = state_69084;
var statearr_69159_69227 = state_69084__$1;
(statearr_69159_69227[(2)] = inst_68974);

(statearr_69159_69227[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69085 === (49))){
var inst_68980 = (state_69084[(8)]);
var inst_69051 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68980], 0));
var inst_69052 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_69053 = ["Illegal element (",inst_69051,") in vector: ",inst_69052,"."].join('');
var inst_69054 = cljs.core.PersistentHashMap.EMPTY;
var inst_69055 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69053,inst_69054);
var inst_69056 = (function(){throw inst_69055})();
var state_69084__$1 = state_69084;
var statearr_69160_69228 = state_69084__$1;
(statearr_69160_69228[(2)] = inst_69056);

(statearr_69160_69228[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10798__auto____0 = (function (){
var statearr_69161 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69161[(0)] = fluree$db$dbfunctions$core$state_machine__10798__auto__);

(statearr_69161[(1)] = (1));

return statearr_69161;
});
var fluree$db$dbfunctions$core$state_machine__10798__auto____1 = (function (state_69084){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_69084);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e69162){var ex__10801__auto__ = e69162;
var statearr_69163_69229 = state_69084;
(statearr_69163_69229[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_69084[(4)]))){
var statearr_69164_69230 = state_69084;
(statearr_69164_69230[(1)] = cljs.core.first((state_69084[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__69231 = state_69084;
state_69084 = G__69231;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10798__auto__ = function(state_69084){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10798__auto____1.call(this,state_69084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10798__auto____0;
fluree$db$dbfunctions$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10798__auto____1;
return fluree$db$dbfunctions$core$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_69165 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_69165[(6)] = c__10835__auto__);

return statearr_69165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__69234 = arguments.length;
switch (G__69234) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_69398){
var state_val_69399 = (state_69398[(1)]);
if((state_val_69399 === (7))){
var inst_69242 = (state_69398[(7)]);
var inst_69248 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_69242,type);
var state_69398__$1 = state_69398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69398__$1,(9),inst_69248);
} else {
if((state_val_69399 === (59))){
var inst_69291 = (state_69398[(8)]);
var inst_69362 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69291], 0));
var inst_69363 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_69291) : type.call(null,inst_69291));
var inst_69364 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_69365 = ["Illegal element (",inst_69362,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69363),") in function argument: ",inst_69364,"."].join('');
var inst_69366 = cljs.core.PersistentHashMap.EMPTY;
var inst_69367 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69365,inst_69366);
var inst_69368 = (function(){throw inst_69367})();
var state_69398__$1 = state_69398;
var statearr_69400_69495 = state_69398__$1;
(statearr_69400_69495[(2)] = inst_69368);

(statearr_69400_69495[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (20))){
var inst_69297 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
if(cljs.core.truth_(inst_69297)){
var statearr_69401_69496 = state_69398__$1;
(statearr_69401_69496[(1)] = (21));

} else {
var statearr_69402_69497 = state_69398__$1;
(statearr_69402_69497[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (58))){
var inst_69358 = (state_69398[(2)]);
var inst_69359 = fluree.db.util.async.throw_err(inst_69358);
var state_69398__$1 = state_69398;
var statearr_69403_69498 = state_69398__$1;
(statearr_69403_69498[(2)] = inst_69359);

(statearr_69403_69498[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (60))){
var state_69398__$1 = state_69398;
var statearr_69404_69499 = state_69398__$1;
(statearr_69404_69499[(2)] = null);

(statearr_69404_69499[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (27))){
var inst_69303 = (state_69398[(2)]);
var inst_69304 = fluree.db.util.async.throw_err(inst_69303);
var state_69398__$1 = state_69398;
var statearr_69405_69500 = state_69398__$1;
(statearr_69405_69500[(2)] = inst_69304);

(statearr_69405_69500[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (1))){
var state_69398__$1 = state_69398;
var statearr_69406_69501 = state_69398__$1;
(statearr_69406_69501[(2)] = null);

(statearr_69406_69501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (24))){
var inst_69291 = (state_69398[(8)]);
var inst_69301 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_69291,type,params);
var state_69398__$1 = state_69398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69398__$1,(27),inst_69301);
} else {
if((state_val_69399 === (55))){
var inst_69291 = (state_69398[(8)]);
var inst_69356 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_69291,type,params);
var state_69398__$1 = state_69398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69398__$1,(58),inst_69356);
} else {
if((state_val_69399 === (39))){
var inst_69339 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69407_69502 = state_69398__$1;
(statearr_69407_69502[(2)] = inst_69339);

(statearr_69407_69502[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (46))){
var inst_69341 = (state_69398[(9)]);
var state_69398__$1 = state_69398;
var statearr_69408_69503 = state_69398__$1;
(statearr_69408_69503[(2)] = inst_69341);

(statearr_69408_69503[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (4))){
var inst_69235 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69409_69504 = state_69398__$1;
(statearr_69409_69504[(2)] = inst_69235);

(statearr_69409_69504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (54))){
var inst_69375 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69410_69505 = state_69398__$1;
(statearr_69410_69505[(2)] = inst_69375);

(statearr_69410_69505[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (15))){
var inst_69243 = (state_69398[(10)]);
var inst_69272 = (state_69398[(2)]);
var inst_69280 = cljs.core.seq(inst_69243);
var inst_69281 = cljs.core.first(inst_69280);
var inst_69282 = cljs.core.next(inst_69280);
var inst_69283 = cljs.core.PersistentVector.EMPTY;
var inst_69284 = inst_69243;
var inst_69285 = inst_69283;
var state_69398__$1 = (function (){var statearr_69411 = state_69398;
(statearr_69411[(11)] = inst_69282);

(statearr_69411[(12)] = inst_69281);

(statearr_69411[(13)] = inst_69272);

(statearr_69411[(14)] = inst_69284);

(statearr_69411[(15)] = inst_69285);

return statearr_69411;
})();
var statearr_69412_69506 = state_69398__$1;
(statearr_69412_69506[(2)] = null);

(statearr_69412_69506[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (48))){
var inst_69351 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
if(cljs.core.truth_(inst_69351)){
var statearr_69413_69507 = state_69398__$1;
(statearr_69413_69507[(1)] = (52));

} else {
var statearr_69414_69508 = state_69398__$1;
(statearr_69414_69508[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (50))){
var inst_69291 = (state_69398[(8)]);
var inst_69347 = (inst_69291 == null);
var state_69398__$1 = state_69398;
var statearr_69415_69509 = state_69398__$1;
(statearr_69415_69509[(2)] = inst_69347);

(statearr_69415_69509[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (21))){
var inst_69291 = (state_69398[(8)]);
var inst_69299 = cljs.core.list_QMARK_(inst_69291);
var state_69398__$1 = state_69398;
if(inst_69299){
var statearr_69416_69510 = state_69398__$1;
(statearr_69416_69510[(1)] = (24));

} else {
var statearr_69417_69511 = state_69398__$1;
(statearr_69417_69511[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (31))){
var inst_69291 = (state_69398[(8)]);
var state_69398__$1 = state_69398;
var statearr_69418_69512 = state_69398__$1;
(statearr_69418_69512[(2)] = inst_69291);

(statearr_69418_69512[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (32))){
var inst_69291 = (state_69398[(8)]);
var inst_69312 = (inst_69291 instanceof cljs.core.Symbol);
var state_69398__$1 = state_69398;
if(cljs.core.truth_(inst_69312)){
var statearr_69419_69513 = state_69398__$1;
(statearr_69419_69513[(1)] = (34));

} else {
var statearr_69420_69514 = state_69398__$1;
(statearr_69420_69514[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (40))){
var inst_69321 = (state_69398[(16)]);
var state_69398__$1 = state_69398;
var statearr_69421_69515 = state_69398__$1;
(statearr_69421_69515[(2)] = inst_69321);

(statearr_69421_69515[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (56))){
var state_69398__$1 = state_69398;
var statearr_69422_69516 = state_69398__$1;
(statearr_69422_69516[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (33))){
var inst_69379 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69424_69517 = state_69398__$1;
(statearr_69424_69517[(2)] = inst_69379);

(statearr_69424_69517[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (13))){
var inst_69244 = (state_69398[(17)]);
var inst_69242 = (state_69398[(7)]);
var inst_69256 = (state_69398[(18)]);
var inst_69266 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69242),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69256),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69244),"."].join('');
var inst_69267 = cljs.core.PersistentHashMap.EMPTY;
var inst_69268 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69266,inst_69267);
var inst_69269 = (function(){throw inst_69268})();
var state_69398__$1 = state_69398;
var statearr_69425_69518 = state_69398__$1;
(statearr_69425_69518[(2)] = inst_69269);

(statearr_69425_69518[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (22))){
var inst_69285 = (state_69398[(15)]);
var state_69398__$1 = state_69398;
var statearr_69426_69519 = state_69398__$1;
(statearr_69426_69519[(2)] = inst_69285);

(statearr_69426_69519[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (36))){
var inst_69377 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69427_69520 = state_69398__$1;
(statearr_69427_69520[(2)] = inst_69377);

(statearr_69427_69520[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (41))){
var inst_69324 = (state_69398[(19)]);
var inst_69324__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_69398__$1 = (function (){var statearr_69428 = state_69398;
(statearr_69428[(19)] = inst_69324__$1);

return statearr_69428;
})();
if(inst_69324__$1){
var statearr_69429_69521 = state_69398__$1;
(statearr_69429_69521[(1)] = (43));

} else {
var statearr_69430_69522 = state_69398__$1;
(statearr_69430_69522[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (43))){
var inst_69324 = (state_69398[(19)]);
var state_69398__$1 = state_69398;
var statearr_69431_69523 = state_69398__$1;
(statearr_69431_69523[(2)] = inst_69324);

(statearr_69431_69523[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (61))){
var inst_69371 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69432_69524 = state_69398__$1;
(statearr_69432_69524[(2)] = inst_69371);

(statearr_69432_69524[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (29))){
var inst_69291 = (state_69398[(8)]);
var inst_69309 = typeof inst_69291 === 'number';
var state_69398__$1 = state_69398;
if(cljs.core.truth_(inst_69309)){
var statearr_69433_69525 = state_69398__$1;
(statearr_69433_69525[(1)] = (31));

} else {
var statearr_69434_69526 = state_69398__$1;
(statearr_69434_69526[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (44))){
var inst_69291 = (state_69398[(8)]);
var inst_69327 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_69328 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69291)," used in function argument: ",inst_69327].join('');
var inst_69329 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69330 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_69331 = cljs.core.PersistentHashMap.fromArrays(inst_69329,inst_69330);
var inst_69332 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69328,inst_69331);
var inst_69333 = (function(){throw inst_69332})();
var state_69398__$1 = state_69398;
var statearr_69435_69527 = state_69398__$1;
(statearr_69435_69527[(2)] = inst_69333);

(statearr_69435_69527[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (6))){
var inst_69245 = (state_69398[(20)]);
var state_69398__$1 = state_69398;
var statearr_69436_69528 = state_69398__$1;
(statearr_69436_69528[(2)] = inst_69245);

(statearr_69436_69528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (28))){
var inst_69291 = (state_69398[(8)]);
var state_69398__$1 = state_69398;
var statearr_69437_69529 = state_69398__$1;
(statearr_69437_69529[(2)] = inst_69291);

(statearr_69437_69529[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (51))){
var inst_69349 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69438_69530 = state_69398__$1;
(statearr_69438_69530[(2)] = inst_69349);

(statearr_69438_69530[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (25))){
var inst_69291 = (state_69398[(8)]);
var inst_69306 = typeof inst_69291 === 'string';
var state_69398__$1 = state_69398;
if(cljs.core.truth_(inst_69306)){
var statearr_69439_69531 = state_69398__$1;
(statearr_69439_69531[(1)] = (28));

} else {
var statearr_69440_69532 = state_69398__$1;
(statearr_69440_69532[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (34))){
var inst_69314 = (state_69398[(21)]);
var inst_69291 = (state_69398[(8)]);
var inst_69314__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_69291) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_69291));
var state_69398__$1 = (function (){var statearr_69441 = state_69398;
(statearr_69441[(21)] = inst_69314__$1);

return statearr_69441;
})();
if(cljs.core.truth_(inst_69314__$1)){
var statearr_69442_69533 = state_69398__$1;
(statearr_69442_69533[(1)] = (37));

} else {
var statearr_69443_69534 = state_69398__$1;
(statearr_69443_69534[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (17))){
var inst_69255 = (state_69398[(22)]);
var inst_69390 = (state_69398[(2)]);
var inst_69391 = cljs.core.cst$sym$_QMARK_ctx;
var inst_69392 = cljs.core.cons(inst_69391,inst_69390);
var inst_69393 = cljs.core.cons(inst_69255,inst_69392);
var _ = (function (){var statearr_69444 = state_69398;
(statearr_69444[(4)] = cljs.core.rest((state_69398[(4)])));

return statearr_69444;
})();
var state_69398__$1 = state_69398;
var statearr_69445_69535 = state_69398__$1;
(statearr_69445_69535[(2)] = inst_69393);

(statearr_69445_69535[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (3))){
var inst_69396 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69398__$1,inst_69396);
} else {
if((state_val_69399 === (12))){
var inst_69263 = (state_69398[(2)]);
var inst_69264 = cljs.core.not(inst_69263);
var state_69398__$1 = state_69398;
if(inst_69264){
var statearr_69446_69536 = state_69398__$1;
(statearr_69446_69536[(1)] = (13));

} else {
var statearr_69447_69537 = state_69398__$1;
(statearr_69447_69537[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (2))){
var inst_69245 = (state_69398[(20)]);
var inst_69242 = (state_69398[(7)]);
var inst_69243 = (state_69398[(10)]);
var _ = (function (){var statearr_69448 = state_69398;
(statearr_69448[(4)] = cljs.core.cons((5),(state_69398[(4)])));

return statearr_69448;
})();
var inst_69242__$1 = cljs.core.first(form);
var inst_69243__$1 = cljs.core.rest(form);
var inst_69244 = cljs.core.count(inst_69243__$1);
var inst_69245__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_69242__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_69242__$1));
var state_69398__$1 = (function (){var statearr_69449 = state_69398;
(statearr_69449[(20)] = inst_69245__$1);

(statearr_69449[(17)] = inst_69244);

(statearr_69449[(7)] = inst_69242__$1);

(statearr_69449[(10)] = inst_69243__$1);

return statearr_69449;
})();
if(cljs.core.truth_(inst_69245__$1)){
var statearr_69450_69538 = state_69398__$1;
(statearr_69450_69538[(1)] = (6));

} else {
var statearr_69451_69539 = state_69398__$1;
(statearr_69451_69539[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (23))){
var inst_69388 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69452_69540 = state_69398__$1;
(statearr_69452_69540[(2)] = inst_69388);

(statearr_69452_69540[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (47))){
var inst_69344 = (state_69398[(23)]);
var inst_69291 = (state_69398[(8)]);
var inst_69344__$1 = inst_69291 === false;
var state_69398__$1 = (function (){var statearr_69453 = state_69398;
(statearr_69453[(23)] = inst_69344__$1);

return statearr_69453;
})();
if(cljs.core.truth_(inst_69344__$1)){
var statearr_69454_69541 = state_69398__$1;
(statearr_69454_69541[(1)] = (49));

} else {
var statearr_69455_69542 = state_69398__$1;
(statearr_69455_69542[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (35))){
var inst_69291 = (state_69398[(8)]);
var inst_69341 = (state_69398[(9)]);
var inst_69341__$1 = inst_69291 === true;
var state_69398__$1 = (function (){var statearr_69456 = state_69398;
(statearr_69456[(9)] = inst_69341__$1);

return statearr_69456;
})();
if(cljs.core.truth_(inst_69341__$1)){
var statearr_69457_69543 = state_69398__$1;
(statearr_69457_69543[(1)] = (46));

} else {
var statearr_69458_69544 = state_69398__$1;
(statearr_69458_69544[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (19))){
var inst_69291 = (state_69398[(8)]);
var inst_69295 = inst_69291 === false;
var state_69398__$1 = state_69398;
var statearr_69459_69545 = state_69398__$1;
(statearr_69459_69545[(2)] = inst_69295);

(statearr_69459_69545[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (57))){
var inst_69373 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69460_69546 = state_69398__$1;
(statearr_69460_69546[(2)] = inst_69373);

(statearr_69460_69546[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (11))){
var inst_69244 = (state_69398[(17)]);
var inst_69256 = (state_69398[(18)]);
var inst_69261 = (inst_69256.cljs$core$IFn$_invoke$arity$1 ? inst_69256.cljs$core$IFn$_invoke$arity$1(inst_69244) : inst_69256.call(null,inst_69244));
var state_69398__$1 = state_69398;
var statearr_69462_69547 = state_69398__$1;
(statearr_69462_69547[(2)] = inst_69261);

(statearr_69462_69547[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (9))){
var inst_69250 = (state_69398[(2)]);
var inst_69251 = fluree.db.util.async.throw_err(inst_69250);
var state_69398__$1 = state_69398;
var statearr_69463_69548 = state_69398__$1;
(statearr_69463_69548[(2)] = inst_69251);

(statearr_69463_69548[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (5))){
var _ = (function (){var statearr_69464 = state_69398;
(statearr_69464[(4)] = cljs.core.rest((state_69398[(4)])));

return statearr_69464;
})();
var state_69398__$1 = state_69398;
var ex69461 = (state_69398__$1[(2)]);
var statearr_69465_69549 = state_69398__$1;
(statearr_69465_69549[(5)] = ex69461);


if((ex69461 instanceof Error)){
var statearr_69466_69550 = state_69398__$1;
(statearr_69466_69550[(1)] = (4));

(statearr_69466_69550[(5)] = null);

} else {
throw ex69461;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (14))){
var state_69398__$1 = state_69398;
var statearr_69467_69551 = state_69398__$1;
(statearr_69467_69551[(2)] = null);

(statearr_69467_69551[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (45))){
var inst_69335 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69468_69552 = state_69398__$1;
(statearr_69468_69552[(2)] = inst_69335);

(statearr_69468_69552[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (53))){
var inst_69291 = (state_69398[(8)]);
var inst_69354 = cljs.core.vector_QMARK_(inst_69291);
var state_69398__$1 = state_69398;
if(inst_69354){
var statearr_69469_69553 = state_69398__$1;
(statearr_69469_69553[(1)] = (55));

} else {
var statearr_69470_69554 = state_69398__$1;
(statearr_69470_69554[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (26))){
var inst_69292 = (state_69398[(24)]);
var inst_69285 = (state_69398[(15)]);
var inst_69383 = (state_69398[(2)]);
var inst_69384 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69285,inst_69383);
var inst_69284 = inst_69292;
var inst_69285__$1 = inst_69384;
var state_69398__$1 = (function (){var statearr_69471 = state_69398;
(statearr_69471[(14)] = inst_69284);

(statearr_69471[(15)] = inst_69285__$1);

return statearr_69471;
})();
var statearr_69472_69555 = state_69398__$1;
(statearr_69472_69555[(2)] = null);

(statearr_69472_69555[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (16))){
var inst_69291 = (state_69398[(8)]);
var inst_69284 = (state_69398[(14)]);
var inst_69290 = cljs.core.seq(inst_69284);
var inst_69291__$1 = cljs.core.first(inst_69290);
var inst_69292 = cljs.core.next(inst_69290);
var state_69398__$1 = (function (){var statearr_69473 = state_69398;
(statearr_69473[(24)] = inst_69292);

(statearr_69473[(8)] = inst_69291__$1);

return statearr_69473;
})();
if(cljs.core.truth_(inst_69291__$1)){
var statearr_69474_69556 = state_69398__$1;
(statearr_69474_69556[(1)] = (18));

} else {
var statearr_69475_69557 = state_69398__$1;
(statearr_69475_69557[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (38))){
var inst_69282 = (state_69398[(11)]);
var inst_69253 = (state_69398[(25)]);
var inst_69281 = (state_69398[(12)]);
var inst_69292 = (state_69398[(24)]);
var inst_69257 = (state_69398[(26)]);
var inst_69321 = (state_69398[(16)]);
var inst_69254 = (state_69398[(27)]);
var inst_69258 = (state_69398[(28)]);
var inst_69272 = (state_69398[(13)]);
var inst_69314 = (state_69398[(21)]);
var inst_69244 = (state_69398[(17)]);
var inst_69291 = (state_69398[(8)]);
var inst_69242 = (state_69398[(7)]);
var inst_69284 = (state_69398[(14)]);
var inst_69256 = (state_69398[(18)]);
var inst_69285 = (state_69398[(15)]);
var inst_69243 = (state_69398[(10)]);
var inst_69255 = (state_69398[(22)]);
var inst_69317 = [inst_69291];
var inst_69318 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_69317);
var inst_69319 = (function (){var arity = inst_69256;
var args_n = inst_69244;
var fn_map = inst_69253;
var first__69279 = inst_69281;
var args = inst_69243;
var vec__69277 = inst_69243;
var r = inst_69292;
var seq__69288 = inst_69292;
var _ = inst_69272;
var first__69289 = inst_69291;
var acc = inst_69285;
var seq__69278 = inst_69282;
var arglist = inst_69257;
var fn_name = inst_69242;
var vec__69287 = inst_69284;
var G__69276 = inst_69284;
var _AMPERSAND_args_QMARK_ = inst_69258;
var or__4223__auto__ = inst_69314;
var arg = inst_69291;
var map__69241 = inst_69254;
var f = inst_69255;
return (function (p1__69232_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__69232_SHARP_);
});
})();
var inst_69320 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_69319,params);
var inst_69321__$1 = cljs.core.some(inst_69318,inst_69320);
var state_69398__$1 = (function (){var statearr_69476 = state_69398;
(statearr_69476[(16)] = inst_69321__$1);

return statearr_69476;
})();
if(cljs.core.truth_(inst_69321__$1)){
var statearr_69477_69558 = state_69398__$1;
(statearr_69477_69558[(1)] = (40));

} else {
var statearr_69478_69559 = state_69398__$1;
(statearr_69478_69559[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (30))){
var inst_69381 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69479_69560 = state_69398__$1;
(statearr_69479_69560[(2)] = inst_69381);

(statearr_69479_69560[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (10))){
var inst_69258 = (state_69398[(28)]);
var state_69398__$1 = state_69398;
var statearr_69480_69561 = state_69398__$1;
(statearr_69480_69561[(2)] = inst_69258);

(statearr_69480_69561[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (18))){
var inst_69291 = (state_69398[(8)]);
var state_69398__$1 = state_69398;
var statearr_69481_69562 = state_69398__$1;
(statearr_69481_69562[(2)] = inst_69291);

(statearr_69481_69562[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (52))){
var inst_69291 = (state_69398[(8)]);
var state_69398__$1 = state_69398;
var statearr_69482_69563 = state_69398__$1;
(statearr_69482_69563[(2)] = inst_69291);

(statearr_69482_69563[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (42))){
var inst_69337 = (state_69398[(2)]);
var state_69398__$1 = state_69398;
var statearr_69483_69564 = state_69398__$1;
(statearr_69483_69564[(2)] = inst_69337);

(statearr_69483_69564[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (37))){
var inst_69314 = (state_69398[(21)]);
var state_69398__$1 = state_69398;
var statearr_69484_69565 = state_69398__$1;
(statearr_69484_69565[(2)] = inst_69314);

(statearr_69484_69565[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (8))){
var inst_69253 = (state_69398[(25)]);
var inst_69254 = (state_69398[(27)]);
var inst_69258 = (state_69398[(28)]);
var inst_69253__$1 = (state_69398[(2)]);
var inst_69254__$1 = cljs.core.__destructure_map(inst_69253__$1);
var inst_69255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69254__$1,cljs.core.cst$kw$f);
var inst_69256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69254__$1,cljs.core.cst$kw$arity);
var inst_69257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69254__$1,cljs.core.cst$kw$arglist);
var inst_69258__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69254__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_69398__$1 = (function (){var statearr_69485 = state_69398;
(statearr_69485[(25)] = inst_69253__$1);

(statearr_69485[(26)] = inst_69257);

(statearr_69485[(27)] = inst_69254__$1);

(statearr_69485[(28)] = inst_69258__$1);

(statearr_69485[(18)] = inst_69256);

(statearr_69485[(22)] = inst_69255);

return statearr_69485;
})();
if(cljs.core.truth_(inst_69258__$1)){
var statearr_69486_69566 = state_69398__$1;
(statearr_69486_69566[(1)] = (10));

} else {
var statearr_69487_69567 = state_69398__$1;
(statearr_69487_69567[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69399 === (49))){
var inst_69344 = (state_69398[(23)]);
var state_69398__$1 = state_69398;
var statearr_69488_69568 = state_69398__$1;
(statearr_69488_69568[(2)] = inst_69344);

(statearr_69488_69568[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10798__auto____0 = (function (){
var statearr_69489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69489[(0)] = fluree$db$dbfunctions$core$state_machine__10798__auto__);

(statearr_69489[(1)] = (1));

return statearr_69489;
});
var fluree$db$dbfunctions$core$state_machine__10798__auto____1 = (function (state_69398){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_69398);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e69490){var ex__10801__auto__ = e69490;
var statearr_69491_69569 = state_69398;
(statearr_69491_69569[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_69398[(4)]))){
var statearr_69492_69570 = state_69398;
(statearr_69492_69570[(1)] = cljs.core.first((state_69398[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__69571 = state_69398;
state_69398 = G__69571;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10798__auto__ = function(state_69398){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10798__auto____1.call(this,state_69398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10798__auto____0;
fluree$db$dbfunctions$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10798__auto____1;
return fluree$db$dbfunctions$core$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_69493 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_69493[(6)] = c__10835__auto__);

return statearr_69493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__69573 = arguments.length;
switch (G__69573) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_69655){
var state_val_69656 = (state_69655[(1)]);
if((state_val_69656 === (7))){
var inst_69583 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_69655__$1 = state_69655;
var statearr_69657_69705 = state_69655__$1;
(statearr_69657_69705[(2)] = inst_69583);

(statearr_69657_69705[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (20))){
var inst_69633 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_69655__$1 = state_69655;
var statearr_69658_69706 = state_69655__$1;
(statearr_69658_69706[(2)] = inst_69633);

(statearr_69658_69706[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (1))){
var state_69655__$1 = state_69655;
var statearr_69659_69707 = state_69655__$1;
(statearr_69659_69707[(2)] = null);

(statearr_69659_69707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (24))){
var inst_69630 = (state_69655[(7)]);
var inst_69639 = cljs.core.eval(inst_69630);
var state_69655__$1 = state_69655;
var statearr_69661_69708 = state_69655__$1;
(statearr_69661_69708[(2)] = inst_69639);

(statearr_69661_69708[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (4))){
var inst_69574 = (state_69655[(2)]);
var state_69655__$1 = state_69655;
var statearr_69662_69709 = state_69655__$1;
(statearr_69662_69709[(2)] = inst_69574);

(statearr_69662_69709[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (15))){
var _ = (function (){var statearr_69663 = state_69655;
(statearr_69663[(4)] = cljs.core.rest((state_69655[(4)])));

return statearr_69663;
})();
var state_69655__$1 = state_69655;
var ex69660 = (state_69655__$1[(2)]);
var statearr_69664_69710 = state_69655__$1;
(statearr_69664_69710[(5)] = ex69660);


var statearr_69665_69711 = state_69655__$1;
(statearr_69665_69711[(1)] = (14));

(statearr_69665_69711[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (21))){
var inst_69631 = (state_69655[(8)]);
var state_69655__$1 = state_69655;
var statearr_69666_69712 = state_69655__$1;
(statearr_69666_69712[(2)] = inst_69631);

(statearr_69666_69712[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (13))){
var inst_69648 = (state_69655[(2)]);
var state_69655__$1 = state_69655;
var statearr_69667_69713 = state_69655__$1;
(statearr_69667_69713[(2)] = inst_69648);

(statearr_69667_69713[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (22))){
var inst_69636 = (state_69655[(2)]);
var state_69655__$1 = state_69655;
if(cljs.core.truth_(inst_69636)){
var statearr_69668_69714 = state_69655__$1;
(statearr_69668_69714[(1)] = (23));

} else {
var statearr_69669_69715 = state_69655__$1;
(statearr_69669_69715[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (6))){
var inst_69580 = (state_69655[(9)]);
var state_69655__$1 = state_69655;
var statearr_69670_69716 = state_69655__$1;
(statearr_69670_69716[(2)] = inst_69580);

(statearr_69670_69716[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (25))){
var inst_69641 = (state_69655[(2)]);
var inst_69642 = [cljs.core.cst$kw$fnstr];
var inst_69643 = [fn_str];
var inst_69644 = cljs.core.PersistentHashMap.fromArrays(inst_69642,inst_69643);
var inst_69645 = cljs.core.with_meta(inst_69641,inst_69644);
var _ = (function (){var statearr_69671 = state_69655;
(statearr_69671[(4)] = cljs.core.rest((state_69655[(4)])));

return statearr_69671;
})();
var state_69655__$1 = state_69655;
var statearr_69672_69717 = state_69655__$1;
(statearr_69672_69717[(2)] = inst_69645);

(statearr_69672_69717[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (17))){
var inst_69606 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69607 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_69608 = cljs.core.PersistentHashMap.fromArrays(inst_69606,inst_69607);
var inst_69609 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_69608);
var inst_69610 = (function(){throw inst_69609})();
var state_69655__$1 = state_69655;
var statearr_69673_69718 = state_69655__$1;
(statearr_69673_69718[(2)] = inst_69610);

(statearr_69673_69718[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (3))){
var inst_69653 = (state_69655[(2)]);
var state_69655__$1 = state_69655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69655__$1,inst_69653);
} else {
if((state_val_69656 === (12))){
var _ = (function (){var statearr_69674 = state_69655;
(statearr_69674[(4)] = cljs.core.cons((15),(state_69655[(4)])));

return statearr_69674;
})();
var inst_69603 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_69655__$1 = state_69655;
if(cljs.core.truth_(inst_69603)){
var statearr_69675_69719 = state_69655__$1;
(statearr_69675_69719[(1)] = (16));

} else {
var statearr_69676_69720 = state_69655__$1;
(statearr_69676_69720[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (2))){
var inst_69580 = (state_69655[(9)]);
var _ = (function (){var statearr_69677 = state_69655;
(statearr_69677[(4)] = cljs.core.cons((5),(state_69655[(4)])));

return statearr_69677;
})();
var inst_69580__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_69655__$1 = (function (){var statearr_69678 = state_69655;
(statearr_69678[(9)] = inst_69580__$1);

return statearr_69678;
})();
if(inst_69580__$1){
var statearr_69679_69721 = state_69655__$1;
(statearr_69679_69721[(1)] = (6));

} else {
var statearr_69680_69722 = state_69655__$1;
(statearr_69680_69722[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (23))){
var inst_69630 = (state_69655[(7)]);
var state_69655__$1 = state_69655;
var statearr_69681_69723 = state_69655__$1;
(statearr_69681_69723[(2)] = inst_69630);

(statearr_69681_69723[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (19))){
var inst_69631 = (state_69655[(8)]);
var inst_69616 = (state_69655[(2)]);
var inst_69617 = fluree.db.util.async.throw_err(inst_69616);
var inst_69618 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_69619 = (new cljs.core.List(null,inst_69618,null,(1),null));
var inst_69620 = cljs.core.cst$sym$_QMARK_ctx;
var inst_69621 = (new cljs.core.List(null,inst_69620,null,(1),null));
var inst_69622 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_69621);
var inst_69623 = cljs.core.seq(inst_69622);
var inst_69624 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_69623);
var inst_69625 = cljs.core.vec(inst_69624);
var inst_69626 = (new cljs.core.List(null,inst_69625,null,(1),null));
var inst_69627 = (new cljs.core.List(null,inst_69617,null,(1),null));
var inst_69628 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_69619,inst_69626,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_69627], 0));
var inst_69629 = cljs.core.seq(inst_69628);
var inst_69630 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_69629);
var inst_69631__$1 = params;
var state_69655__$1 = (function (){var statearr_69682 = state_69655;
(statearr_69682[(8)] = inst_69631__$1);

(statearr_69682[(7)] = inst_69630);

return statearr_69682;
})();
if(cljs.core.truth_(inst_69631__$1)){
var statearr_69683_69724 = state_69655__$1;
(statearr_69683_69724[(1)] = (20));

} else {
var statearr_69684_69725 = state_69655__$1;
(statearr_69684_69725[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (11))){
var inst_69650 = (state_69655[(2)]);
var _ = (function (){var statearr_69686 = state_69655;
(statearr_69686[(4)] = cljs.core.rest((state_69655[(4)])));

return statearr_69686;
})();
var state_69655__$1 = state_69655;
var statearr_69687_69726 = state_69655__$1;
(statearr_69687_69726[(2)] = inst_69650);

(statearr_69687_69726[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (9))){
var inst_69587 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_69588 = fluree.db.dbfunctions.core.true_or_false = inst_69587;
var state_69655__$1 = state_69655;
var statearr_69688_69727 = state_69655__$1;
(statearr_69688_69727[(2)] = inst_69588);

(statearr_69688_69727[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (5))){
var _ = (function (){var statearr_69689 = state_69655;
(statearr_69689[(4)] = cljs.core.rest((state_69655[(4)])));

return statearr_69689;
})();
var state_69655__$1 = state_69655;
var ex69685 = (state_69655__$1[(2)]);
var statearr_69690_69728 = state_69655__$1;
(statearr_69690_69728[(5)] = ex69685);


if((ex69685 instanceof Error)){
var statearr_69691_69729 = state_69655__$1;
(statearr_69691_69729[(1)] = (4));

(statearr_69691_69729[(5)] = null);

} else {
throw ex69685;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (14))){
var inst_69590 = (state_69655[(2)]);
var inst_69591 = (function(){throw inst_69590})();
var inst_69592 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_69593 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_69594 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_69595 = cljs.core.PersistentHashMap.fromArrays(inst_69593,inst_69594);
var inst_69596 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_69592,inst_69595);
var inst_69597 = (function(){throw inst_69596})();
var state_69655__$1 = (function (){var statearr_69692 = state_69655;
(statearr_69692[(10)] = inst_69591);

return statearr_69692;
})();
var statearr_69693_69730 = state_69655__$1;
(statearr_69693_69730[(2)] = inst_69597);

(statearr_69693_69730[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (16))){
var state_69655__$1 = state_69655;
var statearr_69694_69731 = state_69655__$1;
(statearr_69694_69731[(2)] = null);

(statearr_69694_69731[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (10))){
var state_69655__$1 = state_69655;
var statearr_69695_69732 = state_69655__$1;
(statearr_69695_69732[(2)] = null);

(statearr_69695_69732[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69656 === (18))){
var inst_69612 = (state_69655[(2)]);
var inst_69613 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_69614 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_69613,type,params);
var state_69655__$1 = (function (){var statearr_69696 = state_69655;
(statearr_69696[(11)] = inst_69612);

return statearr_69696;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69655__$1,(19),inst_69614);
} else {
if((state_val_69656 === (8))){
var inst_69585 = (state_69655[(2)]);
var state_69655__$1 = state_69655;
if(cljs.core.truth_(inst_69585)){
var statearr_69697_69733 = state_69655__$1;
(statearr_69697_69733[(1)] = (9));

} else {
var statearr_69698_69734 = state_69655__$1;
(statearr_69698_69734[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10798__auto____0 = (function (){
var statearr_69699 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69699[(0)] = fluree$db$dbfunctions$core$state_machine__10798__auto__);

(statearr_69699[(1)] = (1));

return statearr_69699;
});
var fluree$db$dbfunctions$core$state_machine__10798__auto____1 = (function (state_69655){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_69655);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e69700){var ex__10801__auto__ = e69700;
var statearr_69701_69735 = state_69655;
(statearr_69701_69735[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_69655[(4)]))){
var statearr_69702_69736 = state_69655;
(statearr_69702_69736[(1)] = cljs.core.first((state_69655[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__69737 = state_69655;
state_69655 = G__69737;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10798__auto__ = function(state_69655){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10798__auto____1.call(this,state_69655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10798__auto____0;
fluree$db$dbfunctions$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10798__auto____1;
return fluree$db$dbfunctions$core$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_69703 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_69703[(6)] = c__10835__auto__);

return statearr_69703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_69765){
var state_val_69766 = (state_69765[(1)]);
if((state_val_69766 === (7))){
var inst_69752 = (state_69765[(7)]);
var state_69765__$1 = state_69765;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69765__$1,(10),inst_69752);
} else {
if((state_val_69766 === (1))){
var state_69765__$1 = state_69765;
var statearr_69767_69787 = state_69765__$1;
(statearr_69767_69787[(2)] = null);

(statearr_69767_69787[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69766 === (4))){
var inst_69738 = (state_69765[(2)]);
var state_69765__$1 = state_69765;
var statearr_69768_69788 = state_69765__$1;
(statearr_69768_69788[(2)] = inst_69738);

(statearr_69768_69788[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69766 === (6))){
var inst_69752 = (state_69765[(7)]);
var inst_69747 = (state_69765[(8)]);
var inst_69750 = (state_69765[(2)]);
var inst_69751 = fluree.db.util.async.throw_err(inst_69750);
var inst_69752__$1 = (inst_69751.cljs$core$IFn$_invoke$arity$1 ? inst_69751.cljs$core$IFn$_invoke$arity$1(inst_69747) : inst_69751.call(null,inst_69747));
var inst_69753 = fluree.db.util.async.channel_QMARK_(inst_69752__$1);
var state_69765__$1 = (function (){var statearr_69769 = state_69765;
(statearr_69769[(7)] = inst_69752__$1);

return statearr_69769;
})();
if(inst_69753){
var statearr_69770_69789 = state_69765__$1;
(statearr_69770_69789[(1)] = (7));

} else {
var statearr_69771_69790 = state_69765__$1;
(statearr_69771_69790[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69766 === (3))){
var inst_69763 = (state_69765[(2)]);
var state_69765__$1 = state_69765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69765__$1,inst_69763);
} else {
if((state_val_69766 === (2))){
var _ = (function (){var statearr_69773 = state_69765;
(statearr_69773[(4)] = cljs.core.cons((5),(state_69765[(4)])));

return statearr_69773;
})();
var inst_69744 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_69745 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_69746 = [db,block_instant,s,p,auth_id,fuel];
var inst_69747 = cljs.core.PersistentHashMap.fromArrays(inst_69745,inst_69746);
var inst_69748 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_69744,"txn",null);
var state_69765__$1 = (function (){var statearr_69774 = state_69765;
(statearr_69774[(8)] = inst_69747);

return statearr_69774;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69765__$1,(6),inst_69748);
} else {
if((state_val_69766 === (9))){
var inst_69760 = (state_69765[(2)]);
var _ = (function (){var statearr_69775 = state_69765;
(statearr_69775[(4)] = cljs.core.rest((state_69765[(4)])));

return statearr_69775;
})();
var state_69765__$1 = state_69765;
var statearr_69776_69791 = state_69765__$1;
(statearr_69776_69791[(2)] = inst_69760);

(statearr_69776_69791[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69766 === (5))){
var _ = (function (){var statearr_69777 = state_69765;
(statearr_69777[(4)] = cljs.core.rest((state_69765[(4)])));

return statearr_69777;
})();
var state_69765__$1 = state_69765;
var ex69772 = (state_69765__$1[(2)]);
var statearr_69778_69792 = state_69765__$1;
(statearr_69778_69792[(5)] = ex69772);


if((ex69772 instanceof Error)){
var statearr_69779_69793 = state_69765__$1;
(statearr_69779_69793[(1)] = (4));

(statearr_69779_69793[(5)] = null);

} else {
throw ex69772;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69766 === (10))){
var inst_69756 = (state_69765[(2)]);
var inst_69757 = fluree.db.util.async.throw_err(inst_69756);
var state_69765__$1 = state_69765;
var statearr_69780_69794 = state_69765__$1;
(statearr_69780_69794[(2)] = inst_69757);

(statearr_69780_69794[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69766 === (8))){
var inst_69752 = (state_69765[(7)]);
var state_69765__$1 = state_69765;
var statearr_69781_69795 = state_69765__$1;
(statearr_69781_69795[(2)] = inst_69752);

(statearr_69781_69795[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto____0 = (function (){
var statearr_69782 = [null,null,null,null,null,null,null,null,null];
(statearr_69782[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto__);

(statearr_69782[(1)] = (1));

return statearr_69782;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto____1 = (function (state_69765){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_69765);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e69783){var ex__10801__auto__ = e69783;
var statearr_69784_69796 = state_69765;
(statearr_69784_69796[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_69765[(4)]))){
var statearr_69785_69797 = state_69765;
(statearr_69785_69797[(1)] = cljs.core.first((state_69765[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__69798 = state_69765;
state_69765 = G__69798;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto__ = function(state_69765){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto____1.call(this,state_69765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_69786 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_69786[(6)] = c__10835__auto__);

return statearr_69786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
