// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___65028 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65079){
var state_val_65080 = (state_65079[(1)]);
if((state_val_65080 === (7))){
var inst_65074 = (state_65079[(2)]);
var _ = (function (){var statearr_65081 = state_65079;
(statearr_65081[(4)] = cljs.core.rest((state_65079[(4)])));

return statearr_65081;
})();
var state_65079__$1 = state_65079;
var statearr_65082_65109 = state_65079__$1;
(statearr_65082_65109[(2)] = inst_65074);

(statearr_65082_65109[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (1))){
var state_65079__$1 = state_65079;
var statearr_65083_65110 = state_65079__$1;
(statearr_65083_65110[(2)] = null);

(statearr_65083_65110[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (4))){
var inst_65029 = (state_65079[(2)]);
var state_65079__$1 = state_65079;
var statearr_65084_65111 = state_65079__$1;
(statearr_65084_65111[(2)] = inst_65029);

(statearr_65084_65111[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (13))){
var inst_65070 = (state_65079[(2)]);
var state_65079__$1 = state_65079;
var statearr_65085_65112 = state_65079__$1;
(statearr_65085_65112[(2)] = inst_65070);

(statearr_65085_65112[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (6))){
var inst_65047 = (state_65079[(7)]);
var inst_65054 = (state_65079[(8)]);
var inst_65053 = cljs.core.seq(inst_65047);
var inst_65054__$1 = cljs.core.first(inst_65053);
var inst_65055 = cljs.core.next(inst_65053);
var inst_65056 = cljs.core.not(inst_65054__$1);
var state_65079__$1 = (function (){var statearr_65086 = state_65079;
(statearr_65086[(8)] = inst_65054__$1);

(statearr_65086[(9)] = inst_65055);

return statearr_65086;
})();
if(inst_65056){
var statearr_65087_65113 = state_65079__$1;
(statearr_65087_65113[(1)] = (8));

} else {
var statearr_65088_65114 = state_65079__$1;
(statearr_65088_65114[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (3))){
var inst_65077 = (state_65079[(2)]);
var state_65079__$1 = state_65079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65079__$1,inst_65077);
} else {
if((state_val_65080 === (12))){
var inst_65054 = (state_65079[(8)]);
var inst_65048 = (state_65079[(10)]);
var inst_65055 = (state_65079[(9)]);
var inst_65067 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_65048,inst_65054);
var inst_65047 = inst_65055;
var inst_65048__$1 = inst_65067;
var state_65079__$1 = (function (){var statearr_65089 = state_65079;
(statearr_65089[(7)] = inst_65047);

(statearr_65089[(10)] = inst_65048__$1);

return statearr_65089;
})();
var statearr_65090_65115 = state_65079__$1;
(statearr_65090_65115[(2)] = null);

(statearr_65090_65115[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (2))){
var _ = (function (){var statearr_65091 = state_65079;
(statearr_65091[(4)] = cljs.core.cons((5),(state_65079[(4)])));

return statearr_65091;
})();
var inst_65042 = args;
var inst_65043 = cljs.core.seq(inst_65042);
var inst_65044 = cljs.core.first(inst_65043);
var inst_65045 = cljs.core.next(inst_65043);
var inst_65046 = cljs.core.PersistentVector.EMPTY;
var inst_65047 = inst_65042;
var inst_65048 = inst_65046;
var state_65079__$1 = (function (){var statearr_65092 = state_65079;
(statearr_65092[(7)] = inst_65047);

(statearr_65092[(11)] = inst_65044);

(statearr_65092[(12)] = inst_65045);

(statearr_65092[(10)] = inst_65048);

return statearr_65092;
})();
var statearr_65093_65116 = state_65079__$1;
(statearr_65093_65116[(2)] = null);

(statearr_65093_65116[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (11))){
var inst_65054 = (state_65079[(8)]);
var state_65079__$1 = state_65079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65079__$1,(14),inst_65054);
} else {
if((state_val_65080 === (9))){
var inst_65054 = (state_65079[(8)]);
var inst_65059 = fluree.db.util.async.channel_QMARK_(inst_65054);
var state_65079__$1 = state_65079;
if(inst_65059){
var statearr_65095_65117 = state_65079__$1;
(statearr_65095_65117[(1)] = (11));

} else {
var statearr_65096_65118 = state_65079__$1;
(statearr_65096_65118[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (5))){
var _ = (function (){var statearr_65097 = state_65079;
(statearr_65097[(4)] = cljs.core.rest((state_65079[(4)])));

return statearr_65097;
})();
var state_65079__$1 = state_65079;
var ex65094 = (state_65079__$1[(2)]);
var statearr_65098_65119 = state_65079__$1;
(statearr_65098_65119[(5)] = ex65094);


if((ex65094 instanceof Error)){
var statearr_65099_65120 = state_65079__$1;
(statearr_65099_65120[(1)] = (4));

(statearr_65099_65120[(5)] = null);

} else {
throw ex65094;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (14))){
var inst_65048 = (state_65079[(10)]);
var inst_65055 = (state_65079[(9)]);
var inst_65062 = (state_65079[(2)]);
var inst_65063 = fluree.db.util.async.throw_err(inst_65062);
var inst_65064 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_65048,inst_65063);
var inst_65047 = inst_65055;
var inst_65048__$1 = inst_65064;
var state_65079__$1 = (function (){var statearr_65100 = state_65079;
(statearr_65100[(7)] = inst_65047);

(statearr_65100[(10)] = inst_65048__$1);

return statearr_65100;
})();
var statearr_65101_65121 = state_65079__$1;
(statearr_65101_65121[(2)] = null);

(statearr_65101_65121[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (10))){
var inst_65072 = (state_65079[(2)]);
var state_65079__$1 = state_65079;
var statearr_65102_65122 = state_65079__$1;
(statearr_65102_65122[(2)] = inst_65072);

(statearr_65102_65122[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65080 === (8))){
var inst_65048 = (state_65079[(10)]);
var state_65079__$1 = state_65079;
var statearr_65103_65123 = state_65079__$1;
(statearr_65103_65123[(2)] = inst_65048);

(statearr_65103_65123[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto____0 = (function (){
var statearr_65104 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65104[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto__);

(statearr_65104[(1)] = (1));

return statearr_65104;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto____1 = (function (state_65079){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65079);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65105){var ex__10801__auto__ = e65105;
var statearr_65106_65124 = state_65079;
(statearr_65106_65124[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65079[(4)]))){
var statearr_65107_65125 = state_65079;
(statearr_65107_65125[(1)] = cljs.core.first((state_65079[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65126 = state_65079;
state_65079 = G__65126;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto__ = function(state_65079){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto____1.call(this,state_65079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65108 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65108[(6)] = c__10835__auto__);

return statearr_65108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__65127 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65127,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65127,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65175){
var state_val_65176 = (state_65175[(1)]);
if((state_val_65176 === (7))){
var state_65175__$1 = state_65175;
var statearr_65177_65206 = state_65175__$1;
(statearr_65177_65206[(2)] = coll);

(statearr_65177_65206[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (1))){
var state_65175__$1 = state_65175;
var statearr_65178_65207 = state_65175__$1;
(statearr_65178_65207[(2)] = null);

(statearr_65178_65207[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (4))){
var inst_65130 = (state_65175[(2)]);
var state_65175__$1 = state_65175;
var statearr_65179_65208 = state_65175__$1;
(statearr_65179_65208[(2)] = inst_65130);

(statearr_65179_65208[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (15))){
var inst_65149 = (state_65175[(7)]);
var inst_65157 = (state_65175[(2)]);
var inst_65158 = fluree.db.dbfunctions.internal.nth(inst_65149,inst_65157);
var inst_65159 = cljs.core.count(inst_65149);
var inst_65160 = ((9) + inst_65159);
var inst_65161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65162 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65164 = [inst_65149,inst_65157];
var inst_65165 = (new cljs.core.PersistentVector(null,2,(5),inst_65163,inst_65164,null));
var inst_65166 = ["nth",inst_65165,inst_65158];
var inst_65167 = cljs.core.PersistentHashMap.fromArrays(inst_65162,inst_65166);
var inst_65168 = [inst_65167,inst_65160];
var inst_65169 = (new cljs.core.PersistentVector(null,2,(5),inst_65161,inst_65168,null));
var inst_65170 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65169);
var _ = (function (){var statearr_65180 = state_65175;
(statearr_65180[(4)] = cljs.core.rest((state_65175[(4)])));

return statearr_65180;
})();
var state_65175__$1 = (function (){var statearr_65181 = state_65175;
(statearr_65181[(8)] = inst_65170);

return statearr_65181;
})();
var statearr_65182_65209 = state_65175__$1;
(statearr_65182_65209[(2)] = inst_65158);

(statearr_65182_65209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (13))){
var state_65175__$1 = state_65175;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65175__$1,(16),key);
} else {
if((state_val_65176 === (6))){
var state_65175__$1 = state_65175;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65175__$1,(9),coll);
} else {
if((state_val_65176 === (3))){
var inst_65173 = (state_65175[(2)]);
var state_65175__$1 = state_65175;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65175__$1,inst_65173);
} else {
if((state_val_65176 === (12))){
var inst_65149 = (state_65175[(2)]);
var inst_65150 = fluree.db.util.async.channel_QMARK_(key);
var state_65175__$1 = (function (){var statearr_65183 = state_65175;
(statearr_65183[(7)] = inst_65149);

return statearr_65183;
})();
if(inst_65150){
var statearr_65184_65210 = state_65175__$1;
(statearr_65184_65210[(1)] = (13));

} else {
var statearr_65185_65211 = state_65175__$1;
(statearr_65185_65211[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (2))){
var _ = (function (){var statearr_65186 = state_65175;
(statearr_65186[(4)] = cljs.core.cons((5),(state_65175[(4)])));

return statearr_65186;
})();
var inst_65136 = fluree.db.util.async.channel_QMARK_(coll);
var state_65175__$1 = state_65175;
if(inst_65136){
var statearr_65187_65212 = state_65175__$1;
(statearr_65187_65212[(1)] = (6));

} else {
var statearr_65188_65213 = state_65175__$1;
(statearr_65188_65213[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (11))){
var inst_65143 = (state_65175[(9)]);
var state_65175__$1 = state_65175;
var statearr_65190_65214 = state_65175__$1;
(statearr_65190_65214[(2)] = inst_65143);

(statearr_65190_65214[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (9))){
var inst_65139 = (state_65175[(2)]);
var inst_65140 = fluree.db.util.async.throw_err(inst_65139);
var state_65175__$1 = state_65175;
var statearr_65191_65215 = state_65175__$1;
(statearr_65191_65215[(2)] = inst_65140);

(statearr_65191_65215[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (5))){
var _ = (function (){var statearr_65192 = state_65175;
(statearr_65192[(4)] = cljs.core.rest((state_65175[(4)])));

return statearr_65192;
})();
var state_65175__$1 = state_65175;
var ex65189 = (state_65175__$1[(2)]);
var statearr_65193_65216 = state_65175__$1;
(statearr_65193_65216[(5)] = ex65189);


if((ex65189 instanceof Error)){
var statearr_65194_65217 = state_65175__$1;
(statearr_65194_65217[(1)] = (4));

(statearr_65194_65217[(5)] = null);

} else {
throw ex65189;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (14))){
var state_65175__$1 = state_65175;
var statearr_65195_65218 = state_65175__$1;
(statearr_65195_65218[(2)] = key);

(statearr_65195_65218[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (16))){
var inst_65153 = (state_65175[(2)]);
var inst_65154 = fluree.db.util.async.throw_err(inst_65153);
var state_65175__$1 = state_65175;
var statearr_65196_65219 = state_65175__$1;
(statearr_65196_65219[(2)] = inst_65154);

(statearr_65196_65219[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (10))){
var inst_65143 = (state_65175[(9)]);
var inst_65146 = cljs.core.vec(inst_65143);
var state_65175__$1 = state_65175;
var statearr_65197_65220 = state_65175__$1;
(statearr_65197_65220[(2)] = inst_65146);

(statearr_65197_65220[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65176 === (8))){
var inst_65143 = (state_65175[(9)]);
var inst_65143__$1 = (state_65175[(2)]);
var inst_65144 = cljs.core.set_QMARK_(inst_65143__$1);
var state_65175__$1 = (function (){var statearr_65198 = state_65175;
(statearr_65198[(9)] = inst_65143__$1);

return statearr_65198;
})();
if(inst_65144){
var statearr_65199_65221 = state_65175__$1;
(statearr_65199_65221[(1)] = (10));

} else {
var statearr_65200_65222 = state_65175__$1;
(statearr_65200_65222[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto____0 = (function (){
var statearr_65201 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65201[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto__);

(statearr_65201[(1)] = (1));

return statearr_65201;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto____1 = (function (state_65175){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65175);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65202){var ex__10801__auto__ = e65202;
var statearr_65203_65223 = state_65175;
(statearr_65203_65223[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65175[(4)]))){
var statearr_65204_65224 = state_65175;
(statearr_65204_65224[(1)] = cljs.core.first((state_65175[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65225 = state_65175;
state_65175 = G__65225;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto__ = function(state_65175){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto____1.call(this,state_65175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65205 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65205[(6)] = c__10835__auto__);

return statearr_65205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65286){
var state_val_65287 = (state_65286[(1)]);
if((state_val_65287 === (7))){
var state_65286__$1 = state_65286;
var statearr_65288_65322 = state_65286__$1;
(statearr_65288_65322[(2)] = test);

(statearr_65288_65322[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (20))){
var inst_65260 = (state_65286[(2)]);
var inst_65261 = fluree.db.util.async.throw_err(inst_65260);
var state_65286__$1 = state_65286;
var statearr_65289_65323 = state_65286__$1;
(statearr_65289_65323[(2)] = inst_65261);

(statearr_65289_65323[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (1))){
var state_65286__$1 = state_65286;
var statearr_65290_65324 = state_65286__$1;
(statearr_65290_65324[(2)] = null);

(statearr_65290_65324[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (4))){
var inst_65226 = (state_65286[(2)]);
var state_65286__$1 = state_65286;
var statearr_65291_65325 = state_65286__$1;
(statearr_65291_65325[(2)] = inst_65226);

(statearr_65291_65325[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (15))){
var inst_65244 = (state_65286[(7)]);
var inst_65252 = (state_65286[(2)]);
var inst_65253 = [inst_65252,f];
var inst_65254 = (new cljs.core.PersistentVector(null,2,(5),inst_65244,inst_65253,null));
var state_65286__$1 = state_65286;
var statearr_65292_65326 = state_65286__$1;
(statearr_65292_65326[(2)] = inst_65254);

(statearr_65292_65326[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (13))){
var state_65286__$1 = state_65286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65286__$1,(16),t);
} else {
if((state_val_65287 === (6))){
var state_65286__$1 = state_65286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65286__$1,(9),test);
} else {
if((state_val_65287 === (17))){
var state_65286__$1 = state_65286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65286__$1,(20),f);
} else {
if((state_val_65287 === (3))){
var inst_65284 = (state_65286[(2)]);
var state_65286__$1 = state_65286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65286__$1,inst_65284);
} else {
if((state_val_65287 === (12))){
var inst_65242 = (state_65286[(8)]);
var inst_65268 = (state_65286[(2)]);
var inst_65269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65268,(0),null);
var inst_65270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65268,(1),null);
var inst_65271 = fluree.db.dbfunctions.internal.if_else(inst_65242,inst_65269,inst_65270);
var inst_65272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65273 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65275 = [inst_65242,inst_65269,inst_65270];
var inst_65276 = (new cljs.core.PersistentVector(null,3,(5),inst_65274,inst_65275,null));
var inst_65277 = ["if-else",inst_65276,inst_65271];
var inst_65278 = cljs.core.PersistentHashMap.fromArrays(inst_65273,inst_65277);
var inst_65279 = [inst_65278,(10)];
var inst_65280 = (new cljs.core.PersistentVector(null,2,(5),inst_65272,inst_65279,null));
var inst_65281 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65280);
var _ = (function (){var statearr_65293 = state_65286;
(statearr_65293[(4)] = cljs.core.rest((state_65286[(4)])));

return statearr_65293;
})();
var state_65286__$1 = (function (){var statearr_65294 = state_65286;
(statearr_65294[(9)] = inst_65281);

return statearr_65294;
})();
var statearr_65295_65327 = state_65286__$1;
(statearr_65295_65327[(2)] = inst_65271);

(statearr_65295_65327[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (2))){
var _ = (function (){var statearr_65296 = state_65286;
(statearr_65296[(4)] = cljs.core.cons((5),(state_65286[(4)])));

return statearr_65296;
})();
var inst_65235 = fluree.db.util.async.channel_QMARK_(test);
var state_65286__$1 = state_65286;
if(inst_65235){
var statearr_65297_65328 = state_65286__$1;
(statearr_65297_65328[(1)] = (6));

} else {
var statearr_65298_65329 = state_65286__$1;
(statearr_65298_65329[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (19))){
var inst_65256 = (state_65286[(10)]);
var inst_65264 = (state_65286[(2)]);
var inst_65265 = [f,inst_65264];
var inst_65266 = (new cljs.core.PersistentVector(null,2,(5),inst_65256,inst_65265,null));
var state_65286__$1 = state_65286;
var statearr_65299_65330 = state_65286__$1;
(statearr_65299_65330[(2)] = inst_65266);

(statearr_65299_65330[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (11))){
var inst_65256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65257 = fluree.db.util.async.channel_QMARK_(f);
var state_65286__$1 = (function (){var statearr_65301 = state_65286;
(statearr_65301[(10)] = inst_65256);

return statearr_65301;
})();
if(inst_65257){
var statearr_65302_65331 = state_65286__$1;
(statearr_65302_65331[(1)] = (17));

} else {
var statearr_65303_65332 = state_65286__$1;
(statearr_65303_65332[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (9))){
var inst_65238 = (state_65286[(2)]);
var inst_65239 = fluree.db.util.async.throw_err(inst_65238);
var state_65286__$1 = state_65286;
var statearr_65304_65333 = state_65286__$1;
(statearr_65304_65333[(2)] = inst_65239);

(statearr_65304_65333[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (5))){
var _ = (function (){var statearr_65305 = state_65286;
(statearr_65305[(4)] = cljs.core.rest((state_65286[(4)])));

return statearr_65305;
})();
var state_65286__$1 = state_65286;
var ex65300 = (state_65286__$1[(2)]);
var statearr_65306_65334 = state_65286__$1;
(statearr_65306_65334[(5)] = ex65300);


if((ex65300 instanceof Error)){
var statearr_65307_65335 = state_65286__$1;
(statearr_65307_65335[(1)] = (4));

(statearr_65307_65335[(5)] = null);

} else {
throw ex65300;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (14))){
var state_65286__$1 = state_65286;
var statearr_65308_65336 = state_65286__$1;
(statearr_65308_65336[(2)] = t);

(statearr_65308_65336[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (16))){
var inst_65248 = (state_65286[(2)]);
var inst_65249 = fluree.db.util.async.throw_err(inst_65248);
var state_65286__$1 = state_65286;
var statearr_65309_65337 = state_65286__$1;
(statearr_65309_65337[(2)] = inst_65249);

(statearr_65309_65337[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (10))){
var inst_65244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65245 = fluree.db.util.async.channel_QMARK_(t);
var state_65286__$1 = (function (){var statearr_65310 = state_65286;
(statearr_65310[(7)] = inst_65244);

return statearr_65310;
})();
if(inst_65245){
var statearr_65311_65338 = state_65286__$1;
(statearr_65311_65338[(1)] = (13));

} else {
var statearr_65312_65339 = state_65286__$1;
(statearr_65312_65339[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (18))){
var state_65286__$1 = state_65286;
var statearr_65313_65340 = state_65286__$1;
(statearr_65313_65340[(2)] = f);

(statearr_65313_65340[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65287 === (8))){
var inst_65242 = (state_65286[(8)]);
var inst_65242__$1 = (state_65286[(2)]);
var state_65286__$1 = (function (){var statearr_65314 = state_65286;
(statearr_65314[(8)] = inst_65242__$1);

return statearr_65314;
})();
if(cljs.core.truth_(inst_65242__$1)){
var statearr_65315_65341 = state_65286__$1;
(statearr_65315_65341[(1)] = (10));

} else {
var statearr_65316_65342 = state_65286__$1;
(statearr_65316_65342[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto____0 = (function (){
var statearr_65317 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_65317[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto__);

(statearr_65317[(1)] = (1));

return statearr_65317;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto____1 = (function (state_65286){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65286);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65318){var ex__10801__auto__ = e65318;
var statearr_65319_65343 = state_65286;
(statearr_65319_65343[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65286[(4)]))){
var statearr_65320_65344 = state_65286;
(statearr_65320_65344[(1)] = cljs.core.first((state_65286[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65345 = state_65286;
state_65286 = G__65345;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto__ = function(state_65286){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto____1.call(this,state_65286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65321 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65321[(6)] = c__10835__auto__);

return statearr_65321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65375){
var state_val_65376 = (state_65375[(1)]);
if((state_val_65376 === (7))){
var state_65375__$1 = state_65375;
var statearr_65377_65396 = state_65375__$1;
(statearr_65377_65396[(2)] = arg);

(statearr_65377_65396[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65376 === (1))){
var state_65375__$1 = state_65375;
var statearr_65378_65397 = state_65375__$1;
(statearr_65378_65397[(2)] = null);

(statearr_65378_65397[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65376 === (4))){
var inst_65346 = (state_65375[(2)]);
var state_65375__$1 = state_65375;
var statearr_65379_65398 = state_65375__$1;
(statearr_65379_65398[(2)] = inst_65346);

(statearr_65379_65398[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65376 === (6))){
var state_65375__$1 = state_65375;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65375__$1,(9),arg);
} else {
if((state_val_65376 === (3))){
var inst_65373 = (state_65375[(2)]);
var state_65375__$1 = state_65375;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65375__$1,inst_65373);
} else {
if((state_val_65376 === (2))){
var _ = (function (){var statearr_65381 = state_65375;
(statearr_65381[(4)] = cljs.core.cons((5),(state_65375[(4)])));

return statearr_65381;
})();
var inst_65352 = fluree.db.util.async.channel_QMARK_(arg);
var state_65375__$1 = state_65375;
if(inst_65352){
var statearr_65382_65399 = state_65375__$1;
(statearr_65382_65399[(1)] = (6));

} else {
var statearr_65383_65400 = state_65375__$1;
(statearr_65383_65400[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65376 === (9))){
var inst_65355 = (state_65375[(2)]);
var inst_65356 = fluree.db.util.async.throw_err(inst_65355);
var state_65375__$1 = state_65375;
var statearr_65384_65401 = state_65375__$1;
(statearr_65384_65401[(2)] = inst_65356);

(statearr_65384_65401[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65376 === (5))){
var _ = (function (){var statearr_65385 = state_65375;
(statearr_65385[(4)] = cljs.core.rest((state_65375[(4)])));

return statearr_65385;
})();
var state_65375__$1 = state_65375;
var ex65380 = (state_65375__$1[(2)]);
var statearr_65386_65402 = state_65375__$1;
(statearr_65386_65402[(5)] = ex65380);


if((ex65380 instanceof Error)){
var statearr_65387_65403 = state_65375__$1;
(statearr_65387_65403[(1)] = (4));

(statearr_65387_65403[(5)] = null);

} else {
throw ex65380;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65376 === (8))){
var inst_65359 = (state_65375[(2)]);
var inst_65360 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_65359);
var inst_65361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65362 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65364 = [inst_65359];
var inst_65365 = (new cljs.core.PersistentVector(null,1,(5),inst_65363,inst_65364,null));
var inst_65366 = ["nil?",inst_65365,inst_65360];
var inst_65367 = cljs.core.PersistentHashMap.fromArrays(inst_65362,inst_65366);
var inst_65368 = [inst_65367,(10)];
var inst_65369 = (new cljs.core.PersistentVector(null,2,(5),inst_65361,inst_65368,null));
var inst_65370 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65369);
var _ = (function (){var statearr_65388 = state_65375;
(statearr_65388[(4)] = cljs.core.rest((state_65375[(4)])));

return statearr_65388;
})();
var state_65375__$1 = (function (){var statearr_65389 = state_65375;
(statearr_65389[(7)] = inst_65370);

return statearr_65389;
})();
var statearr_65390_65404 = state_65375__$1;
(statearr_65390_65404[(2)] = inst_65360);

(statearr_65390_65404[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto____0 = (function (){
var statearr_65391 = [null,null,null,null,null,null,null,null];
(statearr_65391[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto__);

(statearr_65391[(1)] = (1));

return statearr_65391;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto____1 = (function (state_65375){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65375);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65392){var ex__10801__auto__ = e65392;
var statearr_65393_65405 = state_65375;
(statearr_65393_65405[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65375[(4)]))){
var statearr_65394_65406 = state_65375;
(statearr_65394_65406[(1)] = cljs.core.first((state_65375[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65407 = state_65375;
state_65375 = G__65407;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto__ = function(state_65375){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto____1.call(this,state_65375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65395 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65395[(6)] = c__10835__auto__);

return statearr_65395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65437){
var state_val_65438 = (state_65437[(1)]);
if((state_val_65438 === (7))){
var state_65437__$1 = state_65437;
var statearr_65439_65458 = state_65437__$1;
(statearr_65439_65458[(2)] = arg);

(statearr_65439_65458[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65438 === (1))){
var state_65437__$1 = state_65437;
var statearr_65440_65459 = state_65437__$1;
(statearr_65440_65459[(2)] = null);

(statearr_65440_65459[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65438 === (4))){
var inst_65408 = (state_65437[(2)]);
var state_65437__$1 = state_65437;
var statearr_65441_65460 = state_65437__$1;
(statearr_65441_65460[(2)] = inst_65408);

(statearr_65441_65460[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65438 === (6))){
var state_65437__$1 = state_65437;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65437__$1,(9),arg);
} else {
if((state_val_65438 === (3))){
var inst_65435 = (state_65437[(2)]);
var state_65437__$1 = state_65437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65437__$1,inst_65435);
} else {
if((state_val_65438 === (2))){
var _ = (function (){var statearr_65443 = state_65437;
(statearr_65443[(4)] = cljs.core.cons((5),(state_65437[(4)])));

return statearr_65443;
})();
var inst_65414 = fluree.db.util.async.channel_QMARK_(arg);
var state_65437__$1 = state_65437;
if(inst_65414){
var statearr_65444_65461 = state_65437__$1;
(statearr_65444_65461[(1)] = (6));

} else {
var statearr_65445_65462 = state_65437__$1;
(statearr_65445_65462[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65438 === (9))){
var inst_65417 = (state_65437[(2)]);
var inst_65418 = fluree.db.util.async.throw_err(inst_65417);
var state_65437__$1 = state_65437;
var statearr_65446_65463 = state_65437__$1;
(statearr_65446_65463[(2)] = inst_65418);

(statearr_65446_65463[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65438 === (5))){
var _ = (function (){var statearr_65447 = state_65437;
(statearr_65447[(4)] = cljs.core.rest((state_65437[(4)])));

return statearr_65447;
})();
var state_65437__$1 = state_65437;
var ex65442 = (state_65437__$1[(2)]);
var statearr_65448_65464 = state_65437__$1;
(statearr_65448_65464[(5)] = ex65442);


if((ex65442 instanceof Error)){
var statearr_65449_65465 = state_65437__$1;
(statearr_65449_65465[(1)] = (4));

(statearr_65449_65465[(5)] = null);

} else {
throw ex65442;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65438 === (8))){
var inst_65421 = (state_65437[(2)]);
var inst_65422 = fluree.db.dbfunctions.internal.not(inst_65421);
var inst_65423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65424 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65426 = [inst_65421];
var inst_65427 = (new cljs.core.PersistentVector(null,1,(5),inst_65425,inst_65426,null));
var inst_65428 = ["not?",inst_65427,inst_65422];
var inst_65429 = cljs.core.PersistentHashMap.fromArrays(inst_65424,inst_65428);
var inst_65430 = [inst_65429,(10)];
var inst_65431 = (new cljs.core.PersistentVector(null,2,(5),inst_65423,inst_65430,null));
var inst_65432 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65431);
var _ = (function (){var statearr_65450 = state_65437;
(statearr_65450[(4)] = cljs.core.rest((state_65437[(4)])));

return statearr_65450;
})();
var state_65437__$1 = (function (){var statearr_65451 = state_65437;
(statearr_65451[(7)] = inst_65432);

return statearr_65451;
})();
var statearr_65452_65466 = state_65437__$1;
(statearr_65452_65466[(2)] = inst_65422);

(statearr_65452_65466[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto____0 = (function (){
var statearr_65453 = [null,null,null,null,null,null,null,null];
(statearr_65453[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto__);

(statearr_65453[(1)] = (1));

return statearr_65453;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto____1 = (function (state_65437){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65437);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65454){var ex__10801__auto__ = e65454;
var statearr_65455_65467 = state_65437;
(statearr_65455_65467[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65437[(4)]))){
var statearr_65456_65468 = state_65437;
(statearr_65456_65468[(1)] = cljs.core.first((state_65437[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65469 = state_65437;
state_65437 = G__65469;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto__ = function(state_65437){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto____1.call(this,state_65437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65457 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65457[(6)] = c__10835__auto__);

return statearr_65457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65499){
var state_val_65500 = (state_65499[(1)]);
if((state_val_65500 === (7))){
var state_65499__$1 = state_65499;
var statearr_65501_65520 = state_65499__$1;
(statearr_65501_65520[(2)] = arg);

(statearr_65501_65520[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65500 === (1))){
var state_65499__$1 = state_65499;
var statearr_65502_65521 = state_65499__$1;
(statearr_65502_65521[(2)] = null);

(statearr_65502_65521[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65500 === (4))){
var inst_65470 = (state_65499[(2)]);
var state_65499__$1 = state_65499;
var statearr_65503_65522 = state_65499__$1;
(statearr_65503_65522[(2)] = inst_65470);

(statearr_65503_65522[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65500 === (6))){
var state_65499__$1 = state_65499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65499__$1,(9),arg);
} else {
if((state_val_65500 === (3))){
var inst_65497 = (state_65499[(2)]);
var state_65499__$1 = state_65499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65499__$1,inst_65497);
} else {
if((state_val_65500 === (2))){
var _ = (function (){var statearr_65505 = state_65499;
(statearr_65505[(4)] = cljs.core.cons((5),(state_65499[(4)])));

return statearr_65505;
})();
var inst_65476 = fluree.db.util.async.channel_QMARK_(arg);
var state_65499__$1 = state_65499;
if(inst_65476){
var statearr_65506_65523 = state_65499__$1;
(statearr_65506_65523[(1)] = (6));

} else {
var statearr_65507_65524 = state_65499__$1;
(statearr_65507_65524[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65500 === (9))){
var inst_65479 = (state_65499[(2)]);
var inst_65480 = fluree.db.util.async.throw_err(inst_65479);
var state_65499__$1 = state_65499;
var statearr_65508_65525 = state_65499__$1;
(statearr_65508_65525[(2)] = inst_65480);

(statearr_65508_65525[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65500 === (5))){
var _ = (function (){var statearr_65509 = state_65499;
(statearr_65509[(4)] = cljs.core.rest((state_65499[(4)])));

return statearr_65509;
})();
var state_65499__$1 = state_65499;
var ex65504 = (state_65499__$1[(2)]);
var statearr_65510_65526 = state_65499__$1;
(statearr_65510_65526[(5)] = ex65504);


if((ex65504 instanceof Error)){
var statearr_65511_65527 = state_65499__$1;
(statearr_65511_65527[(1)] = (4));

(statearr_65511_65527[(5)] = null);

} else {
throw ex65504;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65500 === (8))){
var inst_65483 = (state_65499[(2)]);
var inst_65484 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_65483);
var inst_65485 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65486 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65488 = [inst_65483];
var inst_65489 = (new cljs.core.PersistentVector(null,1,(5),inst_65487,inst_65488,null));
var inst_65490 = ["empty?",inst_65489,inst_65484];
var inst_65491 = cljs.core.PersistentHashMap.fromArrays(inst_65486,inst_65490);
var inst_65492 = [inst_65491,(10)];
var inst_65493 = (new cljs.core.PersistentVector(null,2,(5),inst_65485,inst_65492,null));
var inst_65494 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65493);
var _ = (function (){var statearr_65512 = state_65499;
(statearr_65512[(4)] = cljs.core.rest((state_65499[(4)])));

return statearr_65512;
})();
var state_65499__$1 = (function (){var statearr_65513 = state_65499;
(statearr_65513[(7)] = inst_65494);

return statearr_65513;
})();
var statearr_65514_65528 = state_65499__$1;
(statearr_65514_65528[(2)] = inst_65484);

(statearr_65514_65528[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto____0 = (function (){
var statearr_65515 = [null,null,null,null,null,null,null,null];
(statearr_65515[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto__);

(statearr_65515[(1)] = (1));

return statearr_65515;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto____1 = (function (state_65499){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65499);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65516){var ex__10801__auto__ = e65516;
var statearr_65517_65529 = state_65499;
(statearr_65517_65529[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65499[(4)]))){
var statearr_65518_65530 = state_65499;
(statearr_65518_65530[(1)] = cljs.core.first((state_65499[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65531 = state_65499;
state_65499 = G__65531;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto__ = function(state_65499){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto____1.call(this,state_65499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65519 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65519[(6)] = c__10835__auto__);

return statearr_65519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65576 = arguments.length;
var i__4830__auto___65577 = (0);
while(true){
if((i__4830__auto___65577 < len__4829__auto___65576)){
args__4835__auto__.push((arguments[i__4830__auto___65577]));

var G__65578 = (i__4830__auto___65577 + (1));
i__4830__auto___65577 = G__65578;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65559){
var state_val_65560 = (state_65559[(1)]);
if((state_val_65560 === (1))){
var state_65559__$1 = state_65559;
var statearr_65561_65579 = state_65559__$1;
(statearr_65561_65579[(2)] = null);

(statearr_65561_65579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65560 === (2))){
var _ = (function (){var statearr_65562 = state_65559;
(statearr_65562[(4)] = cljs.core.cons((5),(state_65559[(4)])));

return statearr_65562;
})();
var inst_65540 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65559__$1 = state_65559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65559__$1,(6),inst_65540);
} else {
if((state_val_65560 === (3))){
var inst_65557 = (state_65559[(2)]);
var state_65559__$1 = state_65559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65559__$1,inst_65557);
} else {
if((state_val_65560 === (4))){
var inst_65534 = (state_65559[(2)]);
var state_65559__$1 = state_65559;
var statearr_65564_65580 = state_65559__$1;
(statearr_65564_65580[(2)] = inst_65534);

(statearr_65564_65580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65560 === (5))){
var _ = (function (){var statearr_65565 = state_65559;
(statearr_65565[(4)] = cljs.core.rest((state_65559[(4)])));

return statearr_65565;
})();
var state_65559__$1 = state_65559;
var ex65563 = (state_65559__$1[(2)]);
var statearr_65566_65581 = state_65559__$1;
(statearr_65566_65581[(5)] = ex65563);


if((ex65563 instanceof Error)){
var statearr_65567_65582 = state_65559__$1;
(statearr_65567_65582[(1)] = (4));

(statearr_65567_65582[(5)] = null);

} else {
throw ex65563;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65560 === (6))){
var inst_65542 = (state_65559[(2)]);
var inst_65543 = fluree.db.util.async.throw_err(inst_65542);
var inst_65544 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_65543);
var inst_65545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65546 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65548 = [inst_65543];
var inst_65549 = (new cljs.core.PersistentVector(null,1,(5),inst_65547,inst_65548,null));
var inst_65550 = ["str",inst_65549,inst_65544];
var inst_65551 = cljs.core.PersistentHashMap.fromArrays(inst_65546,inst_65550);
var inst_65552 = [inst_65551,(10)];
var inst_65553 = (new cljs.core.PersistentVector(null,2,(5),inst_65545,inst_65552,null));
var inst_65554 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65553);
var _ = (function (){var statearr_65568 = state_65559;
(statearr_65568[(4)] = cljs.core.rest((state_65559[(4)])));

return statearr_65568;
})();
var state_65559__$1 = (function (){var statearr_65569 = state_65559;
(statearr_65569[(7)] = inst_65554);

return statearr_65569;
})();
var statearr_65570_65583 = state_65559__$1;
(statearr_65570_65583[(2)] = inst_65544);

(statearr_65570_65583[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_65571 = [null,null,null,null,null,null,null,null];
(statearr_65571[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_65571[(1)] = (1));

return statearr_65571;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_65559){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65559);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65572){var ex__10801__auto__ = e65572;
var statearr_65573_65584 = state_65559;
(statearr_65573_65584[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65559[(4)]))){
var statearr_65574_65585 = state_65559;
(statearr_65574_65585[(1)] = cljs.core.first((state_65559[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65586 = state_65559;
state_65559 = G__65586;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_65559){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_65559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65575 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65575[(6)] = c__10835__auto__);

return statearr_65575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq65532){
var G__65533 = cljs.core.first(seq65532);
var seq65532__$1 = cljs.core.next(seq65532);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65533,seq65532__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65612){
var state_val_65613 = (state_65612[(1)]);
if((state_val_65613 === (1))){
var state_65612__$1 = state_65612;
var statearr_65614_65629 = state_65612__$1;
(statearr_65614_65629[(2)] = null);

(statearr_65614_65629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65613 === (2))){
var _ = (function (){var statearr_65615 = state_65612;
(statearr_65615[(4)] = cljs.core.cons((5),(state_65612[(4)])));

return statearr_65615;
})();
var inst_65593 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65612__$1 = state_65612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65612__$1,(6),inst_65593);
} else {
if((state_val_65613 === (3))){
var inst_65610 = (state_65612[(2)]);
var state_65612__$1 = state_65612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65612__$1,inst_65610);
} else {
if((state_val_65613 === (4))){
var inst_65587 = (state_65612[(2)]);
var state_65612__$1 = state_65612;
var statearr_65617_65630 = state_65612__$1;
(statearr_65617_65630[(2)] = inst_65587);

(statearr_65617_65630[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65613 === (5))){
var _ = (function (){var statearr_65618 = state_65612;
(statearr_65618[(4)] = cljs.core.rest((state_65612[(4)])));

return statearr_65618;
})();
var state_65612__$1 = state_65612;
var ex65616 = (state_65612__$1[(2)]);
var statearr_65619_65631 = state_65612__$1;
(statearr_65619_65631[(5)] = ex65616);


if((ex65616 instanceof Error)){
var statearr_65620_65632 = state_65612__$1;
(statearr_65620_65632[(1)] = (4));

(statearr_65620_65632[(5)] = null);

} else {
throw ex65616;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65613 === (6))){
var inst_65595 = (state_65612[(2)]);
var inst_65596 = fluree.db.util.async.throw_err(inst_65595);
var inst_65597 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_65596);
var inst_65598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65599 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65601 = [inst_65596];
var inst_65602 = (new cljs.core.PersistentVector(null,1,(5),inst_65600,inst_65601,null));
var inst_65603 = ["subs",inst_65602,inst_65597];
var inst_65604 = cljs.core.PersistentHashMap.fromArrays(inst_65599,inst_65603);
var inst_65605 = [inst_65604,(30)];
var inst_65606 = (new cljs.core.PersistentVector(null,2,(5),inst_65598,inst_65605,null));
var inst_65607 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65606);
var _ = (function (){var statearr_65621 = state_65612;
(statearr_65621[(4)] = cljs.core.rest((state_65612[(4)])));

return statearr_65621;
})();
var state_65612__$1 = (function (){var statearr_65622 = state_65612;
(statearr_65622[(7)] = inst_65607);

return statearr_65622;
})();
var statearr_65623_65633 = state_65612__$1;
(statearr_65623_65633[(2)] = inst_65597);

(statearr_65623_65633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto____0 = (function (){
var statearr_65624 = [null,null,null,null,null,null,null,null];
(statearr_65624[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto__);

(statearr_65624[(1)] = (1));

return statearr_65624;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto____1 = (function (state_65612){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65612);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65625){var ex__10801__auto__ = e65625;
var statearr_65626_65634 = state_65612;
(statearr_65626_65634[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65612[(4)]))){
var statearr_65627_65635 = state_65612;
(statearr_65627_65635[(1)] = cljs.core.first((state_65612[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65636 = state_65612;
state_65612 = G__65636;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto__ = function(state_65612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto____1.call(this,state_65612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65628 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65628[(6)] = c__10835__auto__);

return statearr_65628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65666){
var state_val_65667 = (state_65666[(1)]);
if((state_val_65667 === (7))){
var state_65666__$1 = state_65666;
var statearr_65668_65687 = state_65666__$1;
(statearr_65668_65687[(2)] = str);

(statearr_65668_65687[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65667 === (1))){
var state_65666__$1 = state_65666;
var statearr_65669_65688 = state_65666__$1;
(statearr_65669_65688[(2)] = null);

(statearr_65669_65688[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65667 === (4))){
var inst_65637 = (state_65666[(2)]);
var state_65666__$1 = state_65666;
var statearr_65670_65689 = state_65666__$1;
(statearr_65670_65689[(2)] = inst_65637);

(statearr_65670_65689[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65667 === (6))){
var state_65666__$1 = state_65666;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65666__$1,(9),str);
} else {
if((state_val_65667 === (3))){
var inst_65664 = (state_65666[(2)]);
var state_65666__$1 = state_65666;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65666__$1,inst_65664);
} else {
if((state_val_65667 === (2))){
var _ = (function (){var statearr_65672 = state_65666;
(statearr_65672[(4)] = cljs.core.cons((5),(state_65666[(4)])));

return statearr_65672;
})();
var inst_65643 = fluree.db.util.async.channel_QMARK_(str);
var state_65666__$1 = state_65666;
if(inst_65643){
var statearr_65673_65690 = state_65666__$1;
(statearr_65673_65690[(1)] = (6));

} else {
var statearr_65674_65691 = state_65666__$1;
(statearr_65674_65691[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65667 === (9))){
var inst_65646 = (state_65666[(2)]);
var inst_65647 = fluree.db.util.async.throw_err(inst_65646);
var state_65666__$1 = state_65666;
var statearr_65675_65692 = state_65666__$1;
(statearr_65675_65692[(2)] = inst_65647);

(statearr_65675_65692[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65667 === (5))){
var _ = (function (){var statearr_65676 = state_65666;
(statearr_65676[(4)] = cljs.core.rest((state_65666[(4)])));

return statearr_65676;
})();
var state_65666__$1 = state_65666;
var ex65671 = (state_65666__$1[(2)]);
var statearr_65677_65693 = state_65666__$1;
(statearr_65677_65693[(5)] = ex65671);


if((ex65671 instanceof Error)){
var statearr_65678_65694 = state_65666__$1;
(statearr_65678_65694[(1)] = (4));

(statearr_65678_65694[(5)] = null);

} else {
throw ex65671;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65667 === (8))){
var inst_65650 = (state_65666[(2)]);
var inst_65651 = fluree.db.dbfunctions.internal.lower_case(inst_65650);
var inst_65652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65653 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65655 = [inst_65650];
var inst_65656 = (new cljs.core.PersistentVector(null,1,(5),inst_65654,inst_65655,null));
var inst_65657 = ["lower-case",inst_65656,inst_65651];
var inst_65658 = cljs.core.PersistentHashMap.fromArrays(inst_65653,inst_65657);
var inst_65659 = [inst_65658,(10)];
var inst_65660 = (new cljs.core.PersistentVector(null,2,(5),inst_65652,inst_65659,null));
var inst_65661 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65660);
var _ = (function (){var statearr_65679 = state_65666;
(statearr_65679[(4)] = cljs.core.rest((state_65666[(4)])));

return statearr_65679;
})();
var state_65666__$1 = (function (){var statearr_65680 = state_65666;
(statearr_65680[(7)] = inst_65661);

return statearr_65680;
})();
var statearr_65681_65695 = state_65666__$1;
(statearr_65681_65695[(2)] = inst_65651);

(statearr_65681_65695[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto____0 = (function (){
var statearr_65682 = [null,null,null,null,null,null,null,null];
(statearr_65682[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto__);

(statearr_65682[(1)] = (1));

return statearr_65682;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto____1 = (function (state_65666){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65666);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65683){var ex__10801__auto__ = e65683;
var statearr_65684_65696 = state_65666;
(statearr_65684_65696[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65666[(4)]))){
var statearr_65685_65697 = state_65666;
(statearr_65685_65697[(1)] = cljs.core.first((state_65666[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65698 = state_65666;
state_65666 = G__65698;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto__ = function(state_65666){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto____1.call(this,state_65666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65686 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65686[(6)] = c__10835__auto__);

return statearr_65686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65728){
var state_val_65729 = (state_65728[(1)]);
if((state_val_65729 === (7))){
var state_65728__$1 = state_65728;
var statearr_65730_65749 = state_65728__$1;
(statearr_65730_65749[(2)] = str);

(statearr_65730_65749[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (1))){
var state_65728__$1 = state_65728;
var statearr_65731_65750 = state_65728__$1;
(statearr_65731_65750[(2)] = null);

(statearr_65731_65750[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (4))){
var inst_65699 = (state_65728[(2)]);
var state_65728__$1 = state_65728;
var statearr_65732_65751 = state_65728__$1;
(statearr_65732_65751[(2)] = inst_65699);

(statearr_65732_65751[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (6))){
var state_65728__$1 = state_65728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65728__$1,(9),str);
} else {
if((state_val_65729 === (3))){
var inst_65726 = (state_65728[(2)]);
var state_65728__$1 = state_65728;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65728__$1,inst_65726);
} else {
if((state_val_65729 === (2))){
var _ = (function (){var statearr_65734 = state_65728;
(statearr_65734[(4)] = cljs.core.cons((5),(state_65728[(4)])));

return statearr_65734;
})();
var inst_65705 = fluree.db.util.async.channel_QMARK_(str);
var state_65728__$1 = state_65728;
if(inst_65705){
var statearr_65735_65752 = state_65728__$1;
(statearr_65735_65752[(1)] = (6));

} else {
var statearr_65736_65753 = state_65728__$1;
(statearr_65736_65753[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (9))){
var inst_65708 = (state_65728[(2)]);
var inst_65709 = fluree.db.util.async.throw_err(inst_65708);
var state_65728__$1 = state_65728;
var statearr_65737_65754 = state_65728__$1;
(statearr_65737_65754[(2)] = inst_65709);

(statearr_65737_65754[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (5))){
var _ = (function (){var statearr_65738 = state_65728;
(statearr_65738[(4)] = cljs.core.rest((state_65728[(4)])));

return statearr_65738;
})();
var state_65728__$1 = state_65728;
var ex65733 = (state_65728__$1[(2)]);
var statearr_65739_65755 = state_65728__$1;
(statearr_65739_65755[(5)] = ex65733);


if((ex65733 instanceof Error)){
var statearr_65740_65756 = state_65728__$1;
(statearr_65740_65756[(1)] = (4));

(statearr_65740_65756[(5)] = null);

} else {
throw ex65733;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (8))){
var inst_65712 = (state_65728[(2)]);
var inst_65713 = fluree.db.dbfunctions.internal.upper_case(inst_65712);
var inst_65714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65715 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65717 = [inst_65712];
var inst_65718 = (new cljs.core.PersistentVector(null,1,(5),inst_65716,inst_65717,null));
var inst_65719 = ["upper-case",inst_65718,inst_65713];
var inst_65720 = cljs.core.PersistentHashMap.fromArrays(inst_65715,inst_65719);
var inst_65721 = [inst_65720,(10)];
var inst_65722 = (new cljs.core.PersistentVector(null,2,(5),inst_65714,inst_65721,null));
var inst_65723 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65722);
var _ = (function (){var statearr_65741 = state_65728;
(statearr_65741[(4)] = cljs.core.rest((state_65728[(4)])));

return statearr_65741;
})();
var state_65728__$1 = (function (){var statearr_65742 = state_65728;
(statearr_65742[(7)] = inst_65723);

return statearr_65742;
})();
var statearr_65743_65757 = state_65728__$1;
(statearr_65743_65757[(2)] = inst_65713);

(statearr_65743_65757[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto____0 = (function (){
var statearr_65744 = [null,null,null,null,null,null,null,null];
(statearr_65744[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto__);

(statearr_65744[(1)] = (1));

return statearr_65744;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto____1 = (function (state_65728){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65728);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65745){var ex__10801__auto__ = e65745;
var statearr_65746_65758 = state_65728;
(statearr_65746_65758[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65728[(4)]))){
var statearr_65747_65759 = state_65728;
(statearr_65747_65759[(1)] = cljs.core.first((state_65728[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65760 = state_65728;
state_65728 = G__65760;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto__ = function(state_65728){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto____1.call(this,state_65728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65748 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65748[(6)] = c__10835__auto__);

return statearr_65748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__65762 = arguments.length;
switch (G__65762) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65790){
var state_val_65791 = (state_65790[(1)]);
if((state_val_65791 === (1))){
var state_65790__$1 = state_65790;
var statearr_65792_65808 = state_65790__$1;
(statearr_65792_65808[(2)] = null);

(statearr_65792_65808[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65791 === (2))){
var _ = (function (){var statearr_65793 = state_65790;
(statearr_65793[(4)] = cljs.core.cons((5),(state_65790[(4)])));

return statearr_65793;
})();
var inst_65772 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_65790__$1 = state_65790;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65790__$1,(6),inst_65772);
} else {
if((state_val_65791 === (3))){
var inst_65788 = (state_65790[(2)]);
var state_65790__$1 = state_65790;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65790__$1,inst_65788);
} else {
if((state_val_65791 === (4))){
var inst_65763 = (state_65790[(2)]);
var state_65790__$1 = state_65790;
var statearr_65795_65809 = state_65790__$1;
(statearr_65795_65809[(2)] = inst_65763);

(statearr_65795_65809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65791 === (5))){
var _ = (function (){var statearr_65796 = state_65790;
(statearr_65796[(4)] = cljs.core.rest((state_65790[(4)])));

return statearr_65796;
})();
var state_65790__$1 = state_65790;
var ex65794 = (state_65790__$1[(2)]);
var statearr_65797_65810 = state_65790__$1;
(statearr_65797_65810[(5)] = ex65794);


if((ex65794 instanceof Error)){
var statearr_65798_65811 = state_65790__$1;
(statearr_65798_65811[(1)] = (4));

(statearr_65798_65811[(5)] = null);

} else {
throw ex65794;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65791 === (6))){
var inst_65774 = (state_65790[(2)]);
var inst_65775 = fluree.db.util.async.throw_err(inst_65774);
var inst_65776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65775,(0),null);
var inst_65777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65775,(1),null);
var inst_65778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65779 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65780 = ["?s","?ctx",inst_65776];
var inst_65781 = cljs.core.PersistentHashMap.fromArrays(inst_65779,inst_65780);
var inst_65782 = ((10) + inst_65777);
var inst_65783 = [inst_65781,inst_65782];
var inst_65784 = (new cljs.core.PersistentVector(null,2,(5),inst_65778,inst_65783,null));
var inst_65785 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65784);
var _ = (function (){var statearr_65799 = state_65790;
(statearr_65799[(4)] = cljs.core.rest((state_65790[(4)])));

return statearr_65799;
})();
var state_65790__$1 = (function (){var statearr_65800 = state_65790;
(statearr_65800[(7)] = inst_65785);

return statearr_65800;
})();
var statearr_65801_65812 = state_65790__$1;
(statearr_65801_65812[(2)] = inst_65776);

(statearr_65801_65812[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_65802 = [null,null,null,null,null,null,null,null];
(statearr_65802[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_65802[(1)] = (1));

return statearr_65802;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_65790){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65790);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65803){var ex__10801__auto__ = e65803;
var statearr_65804_65813 = state_65790;
(statearr_65804_65813[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65790[(4)]))){
var statearr_65805_65814 = state_65790;
(statearr_65805_65814[(1)] = cljs.core.first((state_65790[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65815 = state_65790;
state_65790 = G__65815;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_65790){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_65790);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65806 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65806[(6)] = c__10835__auto__);

return statearr_65806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__65817 = arguments.length;
switch (G__65817) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65855){
var state_val_65856 = (state_65855[(1)]);
if((state_val_65856 === (7))){
var inst_65848 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_65855__$1 = state_65855;
var statearr_65857_65877 = state_65855__$1;
(statearr_65857_65877[(2)] = inst_65848);

(statearr_65857_65877[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65856 === (1))){
var state_65855__$1 = state_65855;
var statearr_65858_65878 = state_65855__$1;
(statearr_65858_65878[(2)] = null);

(statearr_65858_65878[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65856 === (4))){
var inst_65818 = (state_65855[(2)]);
var state_65855__$1 = state_65855;
var statearr_65859_65879 = state_65855__$1;
(statearr_65859_65879[(2)] = inst_65818);

(statearr_65859_65879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65856 === (6))){
var inst_65829 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_65855__$1 = state_65855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65855__$1,(10),inst_65829);
} else {
if((state_val_65856 === (3))){
var inst_65853 = (state_65855[(2)]);
var state_65855__$1 = state_65855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65855__$1,inst_65853);
} else {
if((state_val_65856 === (2))){
var _ = (function (){var statearr_65861 = state_65855;
(statearr_65861[(4)] = cljs.core.cons((5),(state_65855[(4)])));

return statearr_65861;
})();
var inst_65824 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65855__$1 = state_65855;
if(cljs.core.truth_(inst_65824)){
var statearr_65862_65880 = state_65855__$1;
(statearr_65862_65880[(1)] = (6));

} else {
var statearr_65863_65881 = state_65855__$1;
(statearr_65863_65881[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65856 === (9))){
var inst_65835 = (state_65855[(2)]);
var inst_65836 = fluree.db.util.async.throw_err(inst_65835);
var inst_65837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65836,(0),null);
var inst_65838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65836,(1),null);
var inst_65839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65840 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65841 = ["?p","?ctx",inst_65837];
var inst_65842 = cljs.core.PersistentHashMap.fromArrays(inst_65840,inst_65841);
var inst_65843 = ((10) + inst_65838);
var inst_65844 = [inst_65842,inst_65843];
var inst_65845 = (new cljs.core.PersistentVector(null,2,(5),inst_65839,inst_65844,null));
var inst_65846 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65845);
var state_65855__$1 = (function (){var statearr_65864 = state_65855;
(statearr_65864[(7)] = inst_65846);

return statearr_65864;
})();
var statearr_65865_65882 = state_65855__$1;
(statearr_65865_65882[(2)] = inst_65837);

(statearr_65865_65882[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65856 === (5))){
var _ = (function (){var statearr_65866 = state_65855;
(statearr_65866[(4)] = cljs.core.rest((state_65855[(4)])));

return statearr_65866;
})();
var state_65855__$1 = state_65855;
var ex65860 = (state_65855__$1[(2)]);
var statearr_65867_65883 = state_65855__$1;
(statearr_65867_65883[(5)] = ex65860);


if((ex65860 instanceof Error)){
var statearr_65868_65884 = state_65855__$1;
(statearr_65868_65884[(1)] = (4));

(statearr_65868_65884[(5)] = null);

} else {
throw ex65860;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65856 === (10))){
var inst_65831 = (state_65855[(2)]);
var inst_65832 = fluree.db.util.async.throw_err(inst_65831);
var inst_65833 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_65832);
var state_65855__$1 = state_65855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65855__$1,(9),inst_65833);
} else {
if((state_val_65856 === (8))){
var inst_65850 = (state_65855[(2)]);
var _ = (function (){var statearr_65869 = state_65855;
(statearr_65869[(4)] = cljs.core.rest((state_65855[(4)])));

return statearr_65869;
})();
var state_65855__$1 = state_65855;
var statearr_65870_65885 = state_65855__$1;
(statearr_65870_65885[(2)] = inst_65850);

(statearr_65870_65885[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_65871 = [null,null,null,null,null,null,null,null];
(statearr_65871[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_65871[(1)] = (1));

return statearr_65871;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_65855){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65855);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65872){var ex__10801__auto__ = e65872;
var statearr_65873_65886 = state_65855;
(statearr_65873_65886[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65855[(4)]))){
var statearr_65874_65887 = state_65855;
(statearr_65874_65887[(1)] = cljs.core.first((state_65855[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65888 = state_65855;
state_65855 = G__65888;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_65855){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_65855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65875 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65875[(6)] = c__10835__auto__);

return statearr_65875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65937 = arguments.length;
var i__4830__auto___65938 = (0);
while(true){
if((i__4830__auto___65938 < len__4829__auto___65937)){
args__4835__auto__.push((arguments[i__4830__auto___65938]));

var G__65939 = (i__4830__auto___65938 + (1));
i__4830__auto___65938 = G__65939;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65920){
var state_val_65921 = (state_65920[(1)]);
if((state_val_65921 === (1))){
var state_65920__$1 = state_65920;
var statearr_65922_65940 = state_65920__$1;
(statearr_65922_65940[(2)] = null);

(statearr_65922_65940[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65921 === (2))){
var _ = (function (){var statearr_65923 = state_65920;
(statearr_65923[(4)] = cljs.core.cons((5),(state_65920[(4)])));

return statearr_65923;
})();
var inst_65897 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65920__$1 = state_65920;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65920__$1,(6),inst_65897);
} else {
if((state_val_65921 === (3))){
var inst_65918 = (state_65920[(2)]);
var state_65920__$1 = state_65920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65920__$1,inst_65918);
} else {
if((state_val_65921 === (4))){
var inst_65891 = (state_65920[(2)]);
var state_65920__$1 = state_65920;
var statearr_65925_65941 = state_65920__$1;
(statearr_65925_65941[(2)] = inst_65891);

(statearr_65925_65941[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65921 === (5))){
var _ = (function (){var statearr_65926 = state_65920;
(statearr_65926[(4)] = cljs.core.rest((state_65920[(4)])));

return statearr_65926;
})();
var state_65920__$1 = state_65920;
var ex65924 = (state_65920__$1[(2)]);
var statearr_65927_65942 = state_65920__$1;
(statearr_65927_65942[(5)] = ex65924);


if((ex65924 instanceof Error)){
var statearr_65928_65943 = state_65920__$1;
(statearr_65928_65943[(1)] = (4));

(statearr_65928_65943[(5)] = null);

} else {
throw ex65924;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65921 === (6))){
var inst_65899 = (state_65920[(2)]);
var inst_65900 = fluree.db.util.async.throw_err(inst_65899);
var inst_65901 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_65900);
var inst_65902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65903 = [inst_65900];
var inst_65904 = (new cljs.core.PersistentVector(null,1,(5),inst_65902,inst_65903,null));
var inst_65905 = cljs.core.count(inst_65904);
var inst_65906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65907 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65909 = [inst_65900];
var inst_65910 = (new cljs.core.PersistentVector(null,1,(5),inst_65908,inst_65909,null));
var inst_65911 = ["and",inst_65910,inst_65901];
var inst_65912 = cljs.core.PersistentHashMap.fromArrays(inst_65907,inst_65911);
var inst_65913 = [inst_65912,inst_65905];
var inst_65914 = (new cljs.core.PersistentVector(null,2,(5),inst_65906,inst_65913,null));
var inst_65915 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65914);
var _ = (function (){var statearr_65929 = state_65920;
(statearr_65929[(4)] = cljs.core.rest((state_65920[(4)])));

return statearr_65929;
})();
var state_65920__$1 = (function (){var statearr_65930 = state_65920;
(statearr_65930[(7)] = inst_65915);

return statearr_65930;
})();
var statearr_65931_65944 = state_65920__$1;
(statearr_65931_65944[(2)] = inst_65901);

(statearr_65931_65944[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_65932 = [null,null,null,null,null,null,null,null];
(statearr_65932[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_65932[(1)] = (1));

return statearr_65932;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_65920){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65920);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65933){var ex__10801__auto__ = e65933;
var statearr_65934_65945 = state_65920;
(statearr_65934_65945[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65920[(4)]))){
var statearr_65935_65946 = state_65920;
(statearr_65935_65946[(1)] = cljs.core.first((state_65920[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__65947 = state_65920;
state_65920 = G__65947;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_65920){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_65920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65936 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65936[(6)] = c__10835__auto__);

return statearr_65936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq65889){
var G__65890 = cljs.core.first(seq65889);
var seq65889__$1 = cljs.core.next(seq65889);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65890,seq65889__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65996 = arguments.length;
var i__4830__auto___65997 = (0);
while(true){
if((i__4830__auto___65997 < len__4829__auto___65996)){
args__4835__auto__.push((arguments[i__4830__auto___65997]));

var G__65998 = (i__4830__auto___65997 + (1));
i__4830__auto___65997 = G__65998;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_65979){
var state_val_65980 = (state_65979[(1)]);
if((state_val_65980 === (1))){
var state_65979__$1 = state_65979;
var statearr_65981_65999 = state_65979__$1;
(statearr_65981_65999[(2)] = null);

(statearr_65981_65999[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65980 === (2))){
var _ = (function (){var statearr_65982 = state_65979;
(statearr_65982[(4)] = cljs.core.cons((5),(state_65979[(4)])));

return statearr_65982;
})();
var inst_65956 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65979__$1 = state_65979;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65979__$1,(6),inst_65956);
} else {
if((state_val_65980 === (3))){
var inst_65977 = (state_65979[(2)]);
var state_65979__$1 = state_65979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65979__$1,inst_65977);
} else {
if((state_val_65980 === (4))){
var inst_65950 = (state_65979[(2)]);
var state_65979__$1 = state_65979;
var statearr_65984_66000 = state_65979__$1;
(statearr_65984_66000[(2)] = inst_65950);

(statearr_65984_66000[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65980 === (5))){
var _ = (function (){var statearr_65985 = state_65979;
(statearr_65985[(4)] = cljs.core.rest((state_65979[(4)])));

return statearr_65985;
})();
var state_65979__$1 = state_65979;
var ex65983 = (state_65979__$1[(2)]);
var statearr_65986_66001 = state_65979__$1;
(statearr_65986_66001[(5)] = ex65983);


if((ex65983 instanceof Error)){
var statearr_65987_66002 = state_65979__$1;
(statearr_65987_66002[(1)] = (4));

(statearr_65987_66002[(5)] = null);

} else {
throw ex65983;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65980 === (6))){
var inst_65958 = (state_65979[(2)]);
var inst_65959 = fluree.db.util.async.throw_err(inst_65958);
var inst_65960 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_65959);
var inst_65961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65962 = [inst_65959];
var inst_65963 = (new cljs.core.PersistentVector(null,1,(5),inst_65961,inst_65962,null));
var inst_65964 = cljs.core.count(inst_65963);
var inst_65965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65966 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65968 = [inst_65959];
var inst_65969 = (new cljs.core.PersistentVector(null,1,(5),inst_65967,inst_65968,null));
var inst_65970 = ["or",inst_65969,inst_65960];
var inst_65971 = cljs.core.PersistentHashMap.fromArrays(inst_65966,inst_65970);
var inst_65972 = [inst_65971,inst_65964];
var inst_65973 = (new cljs.core.PersistentVector(null,2,(5),inst_65965,inst_65972,null));
var inst_65974 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65973);
var _ = (function (){var statearr_65988 = state_65979;
(statearr_65988[(4)] = cljs.core.rest((state_65979[(4)])));

return statearr_65988;
})();
var state_65979__$1 = (function (){var statearr_65989 = state_65979;
(statearr_65989[(7)] = inst_65974);

return statearr_65989;
})();
var statearr_65990_66003 = state_65979__$1;
(statearr_65990_66003[(2)] = inst_65960);

(statearr_65990_66003[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_65991 = [null,null,null,null,null,null,null,null];
(statearr_65991[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_65991[(1)] = (1));

return statearr_65991;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_65979){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_65979);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e65992){var ex__10801__auto__ = e65992;
var statearr_65993_66004 = state_65979;
(statearr_65993_66004[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_65979[(4)]))){
var statearr_65994_66005 = state_65979;
(statearr_65994_66005[(1)] = cljs.core.first((state_65979[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66006 = state_65979;
state_65979 = G__66006;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_65979){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_65979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_65995 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_65995[(6)] = c__10835__auto__);

return statearr_65995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq65948){
var G__65949 = cljs.core.first(seq65948);
var seq65948__$1 = cljs.core.next(seq65948);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65949,seq65948__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66044){
var state_val_66045 = (state_66044[(1)]);
if((state_val_66045 === (7))){
var inst_66020 = fluree.db.util.async.channel_QMARK_(coll);
var state_66044__$1 = state_66044;
if(inst_66020){
var statearr_66046_66069 = state_66044__$1;
(statearr_66046_66069[(1)] = (10));

} else {
var statearr_66047_66070 = state_66044__$1;
(statearr_66047_66070[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (1))){
var state_66044__$1 = state_66044;
var statearr_66048_66071 = state_66044__$1;
(statearr_66048_66071[(2)] = null);

(statearr_66048_66071[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (4))){
var inst_66007 = (state_66044[(2)]);
var state_66044__$1 = state_66044;
var statearr_66049_66072 = state_66044__$1;
(statearr_66049_66072[(2)] = inst_66007);

(statearr_66049_66072[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (13))){
var inst_66023 = (state_66044[(2)]);
var inst_66024 = fluree.db.util.async.throw_err(inst_66023);
var state_66044__$1 = state_66044;
var statearr_66050_66073 = state_66044__$1;
(statearr_66050_66073[(2)] = inst_66024);

(statearr_66050_66073[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (6))){
var inst_66015 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_66044__$1 = state_66044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66044__$1,(9),inst_66015);
} else {
if((state_val_66045 === (3))){
var inst_66042 = (state_66044[(2)]);
var state_66044__$1 = state_66044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66044__$1,inst_66042);
} else {
if((state_val_66045 === (12))){
var inst_66027 = (state_66044[(2)]);
var state_66044__$1 = state_66044;
var statearr_66051_66074 = state_66044__$1;
(statearr_66051_66074[(2)] = inst_66027);

(statearr_66051_66074[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (2))){
var _ = (function (){var statearr_66052 = state_66044;
(statearr_66052[(4)] = cljs.core.cons((5),(state_66044[(4)])));

return statearr_66052;
})();
var inst_66013 = cljs.core.vector_QMARK_(coll);
var state_66044__$1 = state_66044;
if(inst_66013){
var statearr_66053_66075 = state_66044__$1;
(statearr_66053_66075[(1)] = (6));

} else {
var statearr_66054_66076 = state_66044__$1;
(statearr_66054_66076[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (11))){
var state_66044__$1 = state_66044;
var statearr_66056_66077 = state_66044__$1;
(statearr_66056_66077[(2)] = coll);

(statearr_66056_66077[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (9))){
var inst_66017 = (state_66044[(2)]);
var inst_66018 = fluree.db.util.async.throw_err(inst_66017);
var state_66044__$1 = state_66044;
var statearr_66057_66078 = state_66044__$1;
(statearr_66057_66078[(2)] = inst_66018);

(statearr_66057_66078[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (5))){
var _ = (function (){var statearr_66058 = state_66044;
(statearr_66058[(4)] = cljs.core.rest((state_66044[(4)])));

return statearr_66058;
})();
var state_66044__$1 = state_66044;
var ex66055 = (state_66044__$1[(2)]);
var statearr_66059_66079 = state_66044__$1;
(statearr_66059_66079[(5)] = ex66055);


if((ex66055 instanceof Error)){
var statearr_66060_66080 = state_66044__$1;
(statearr_66060_66080[(1)] = (4));

(statearr_66060_66080[(5)] = null);

} else {
throw ex66055;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66045 === (10))){
var state_66044__$1 = state_66044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66044__$1,(13),coll);
} else {
if((state_val_66045 === (8))){
var inst_66029 = (state_66044[(2)]);
var inst_66030 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_66029);
var inst_66031 = cljs.core.count(inst_66030);
var inst_66032 = ((9) + inst_66031);
var inst_66033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66034 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66035 = ["count",inst_66029,inst_66031];
var inst_66036 = cljs.core.PersistentHashMap.fromArrays(inst_66034,inst_66035);
var inst_66037 = [inst_66036,inst_66032];
var inst_66038 = (new cljs.core.PersistentVector(null,2,(5),inst_66033,inst_66037,null));
var inst_66039 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66038);
var _ = (function (){var statearr_66061 = state_66044;
(statearr_66061[(4)] = cljs.core.rest((state_66044[(4)])));

return statearr_66061;
})();
var state_66044__$1 = (function (){var statearr_66062 = state_66044;
(statearr_66062[(7)] = inst_66039);

return statearr_66062;
})();
var statearr_66063_66081 = state_66044__$1;
(statearr_66063_66081[(2)] = inst_66031);

(statearr_66063_66081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto____0 = (function (){
var statearr_66064 = [null,null,null,null,null,null,null,null];
(statearr_66064[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto__);

(statearr_66064[(1)] = (1));

return statearr_66064;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto____1 = (function (state_66044){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66044);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66065){var ex__10801__auto__ = e66065;
var statearr_66066_66082 = state_66044;
(statearr_66066_66082[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66044[(4)]))){
var statearr_66067_66083 = state_66044;
(statearr_66067_66083[(1)] = cljs.core.first((state_66044[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66084 = state_66044;
state_66044 = G__66084;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto__ = function(state_66044){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto____1.call(this,state_66044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66068 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66068[(6)] = c__10835__auto__);

return statearr_66068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66134){
var state_val_66135 = (state_66134[(1)]);
if((state_val_66135 === (7))){
var state_66134__$1 = state_66134;
var statearr_66136_66169 = state_66134__$1;
(statearr_66136_66169[(2)] = subject);

(statearr_66136_66169[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (1))){
var state_66134__$1 = state_66134;
var statearr_66137_66170 = state_66134__$1;
(statearr_66137_66170[(2)] = null);

(statearr_66137_66170[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (4))){
var inst_66085 = (state_66134[(2)]);
var state_66134__$1 = state_66134;
var statearr_66138_66171 = state_66134__$1;
(statearr_66138_66171[(2)] = inst_66085);

(statearr_66138_66171[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (15))){
var inst_66098 = (state_66134[(7)]);
var state_66134__$1 = state_66134;
var statearr_66139_66172 = state_66134__$1;
(statearr_66139_66172[(2)] = inst_66098);

(statearr_66139_66172[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (13))){
var inst_66102 = (state_66134[(2)]);
var inst_66103 = fluree.db.util.async.throw_err(inst_66102);
var state_66134__$1 = state_66134;
var statearr_66140_66173 = state_66134__$1;
(statearr_66140_66173[(2)] = inst_66103);

(statearr_66140_66173[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (6))){
var state_66134__$1 = state_66134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66134__$1,(9),subject);
} else {
if((state_val_66135 === (17))){
var inst_66098 = (state_66134[(7)]);
var inst_66112 = cljs.core.first(inst_66098);
var state_66134__$1 = state_66134;
var statearr_66141_66174 = state_66134__$1;
(statearr_66141_66174[(2)] = inst_66112);

(statearr_66141_66174[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (3))){
var inst_66132 = (state_66134[(2)]);
var state_66134__$1 = state_66134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66134__$1,inst_66132);
} else {
if((state_val_66135 === (12))){
var inst_66098 = (state_66134[(7)]);
var inst_66106 = (state_66134[(2)]);
var inst_66107 = cljs.core.vector_QMARK_(inst_66098);
var state_66134__$1 = (function (){var statearr_66142 = state_66134;
(statearr_66142[(8)] = inst_66106);

return statearr_66142;
})();
if(inst_66107){
var statearr_66143_66175 = state_66134__$1;
(statearr_66143_66175[(1)] = (14));

} else {
var statearr_66144_66176 = state_66134__$1;
(statearr_66144_66176[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (2))){
var _ = (function (){var statearr_66145 = state_66134;
(statearr_66145[(4)] = cljs.core.cons((5),(state_66134[(4)])));

return statearr_66145;
})();
var inst_66091 = fluree.db.util.async.channel_QMARK_(subject);
var state_66134__$1 = state_66134;
if(inst_66091){
var statearr_66146_66177 = state_66134__$1;
(statearr_66146_66177[(1)] = (6));

} else {
var statearr_66147_66178 = state_66134__$1;
(statearr_66147_66178[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (19))){
var inst_66115 = (state_66134[(2)]);
var state_66134__$1 = state_66134;
var statearr_66148_66179 = state_66134__$1;
(statearr_66148_66179[(2)] = inst_66115);

(statearr_66148_66179[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (11))){
var state_66134__$1 = state_66134;
var statearr_66150_66180 = state_66134__$1;
(statearr_66150_66180[(2)] = pred);

(statearr_66150_66180[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (9))){
var inst_66094 = (state_66134[(2)]);
var inst_66095 = fluree.db.util.async.throw_err(inst_66094);
var state_66134__$1 = state_66134;
var statearr_66151_66181 = state_66134__$1;
(statearr_66151_66181[(2)] = inst_66095);

(statearr_66151_66181[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (5))){
var _ = (function (){var statearr_66152 = state_66134;
(statearr_66152[(4)] = cljs.core.rest((state_66134[(4)])));

return statearr_66152;
})();
var state_66134__$1 = state_66134;
var ex66149 = (state_66134__$1[(2)]);
var statearr_66153_66182 = state_66134__$1;
(statearr_66153_66182[(5)] = ex66149);


if((ex66149 instanceof Error)){
var statearr_66154_66183 = state_66134__$1;
(statearr_66154_66183[(1)] = (4));

(statearr_66154_66183[(5)] = null);

} else {
throw ex66149;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (14))){
var inst_66098 = (state_66134[(7)]);
var inst_66109 = cljs.core.count(inst_66098);
var inst_66110 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66109);
var state_66134__$1 = state_66134;
if(inst_66110){
var statearr_66155_66184 = state_66134__$1;
(statearr_66155_66184[(1)] = (17));

} else {
var statearr_66156_66185 = state_66134__$1;
(statearr_66156_66185[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (16))){
var inst_66098 = (state_66134[(7)]);
var inst_66106 = (state_66134[(8)]);
var inst_66118 = (state_66134[(2)]);
var inst_66119 = fluree.db.dbfunctions.internal.get(inst_66118,inst_66106);
var inst_66120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66121 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66123 = [inst_66098,inst_66106];
var inst_66124 = (new cljs.core.PersistentVector(null,2,(5),inst_66122,inst_66123,null));
var inst_66125 = ["get",inst_66124,inst_66119];
var inst_66126 = cljs.core.PersistentHashMap.fromArrays(inst_66121,inst_66125);
var inst_66127 = [inst_66126,(10)];
var inst_66128 = (new cljs.core.PersistentVector(null,2,(5),inst_66120,inst_66127,null));
var inst_66129 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66128);
var _ = (function (){var statearr_66157 = state_66134;
(statearr_66157[(4)] = cljs.core.rest((state_66134[(4)])));

return statearr_66157;
})();
var state_66134__$1 = (function (){var statearr_66158 = state_66134;
(statearr_66158[(9)] = inst_66129);

return statearr_66158;
})();
var statearr_66159_66186 = state_66134__$1;
(statearr_66159_66186[(2)] = inst_66119);

(statearr_66159_66186[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (10))){
var state_66134__$1 = state_66134;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66134__$1,(13),pred);
} else {
if((state_val_66135 === (18))){
var inst_66098 = (state_66134[(7)]);
var state_66134__$1 = state_66134;
var statearr_66160_66187 = state_66134__$1;
(statearr_66160_66187[(2)] = inst_66098);

(statearr_66160_66187[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66135 === (8))){
var inst_66098 = (state_66134[(2)]);
var inst_66099 = fluree.db.util.async.channel_QMARK_(pred);
var state_66134__$1 = (function (){var statearr_66161 = state_66134;
(statearr_66161[(7)] = inst_66098);

return statearr_66161;
})();
if(inst_66099){
var statearr_66162_66188 = state_66134__$1;
(statearr_66162_66188[(1)] = (10));

} else {
var statearr_66163_66189 = state_66134__$1;
(statearr_66163_66189[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto____0 = (function (){
var statearr_66164 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66164[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto__);

(statearr_66164[(1)] = (1));

return statearr_66164;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto____1 = (function (state_66134){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66134);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66165){var ex__10801__auto__ = e66165;
var statearr_66166_66190 = state_66134;
(statearr_66166_66190[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66134[(4)]))){
var statearr_66167_66191 = state_66134;
(statearr_66167_66191[(1)] = cljs.core.first((state_66134[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66192 = state_66134;
state_66134 = G__66192;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto__ = function(state_66134){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto____1.call(this,state_66134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66168 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66168[(6)] = c__10835__auto__);

return statearr_66168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66231){
var state_val_66232 = (state_66231[(1)]);
if((state_val_66232 === (7))){
var inst_66199 = (state_66231[(7)]);
var state_66231__$1 = state_66231;
var statearr_66233_66257 = state_66231__$1;
(statearr_66233_66257[(2)] = inst_66199);

(statearr_66233_66257[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (1))){
var state_66231__$1 = state_66231;
var statearr_66234_66258 = state_66231__$1;
(statearr_66234_66258[(2)] = null);

(statearr_66234_66258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (4))){
var inst_66193 = (state_66231[(2)]);
var state_66231__$1 = state_66231;
var statearr_66235_66259 = state_66231__$1;
(statearr_66235_66259[(2)] = inst_66193);

(statearr_66235_66259[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (6))){
var inst_66201 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66231__$1 = state_66231;
var statearr_66236_66260 = state_66231__$1;
(statearr_66236_66260[(2)] = inst_66201);

(statearr_66236_66260[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (3))){
var inst_66229 = (state_66231[(2)]);
var state_66231__$1 = state_66231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66231__$1,inst_66229);
} else {
if((state_val_66232 === (12))){
var inst_66211 = (state_66231[(2)]);
var inst_66212 = fluree.db.util.async.throw_err(inst_66211);
var inst_66213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66212,(0),null);
var inst_66214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66212,(1),null);
var inst_66215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66216 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66217 = ["?pO","?ctx",inst_66213];
var inst_66218 = cljs.core.PersistentHashMap.fromArrays(inst_66216,inst_66217);
var inst_66219 = ((10) + inst_66214);
var inst_66220 = [inst_66218,inst_66219];
var inst_66221 = (new cljs.core.PersistentVector(null,2,(5),inst_66215,inst_66220,null));
var inst_66222 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66221);
var state_66231__$1 = (function (){var statearr_66237 = state_66231;
(statearr_66237[(8)] = inst_66222);

return statearr_66237;
})();
var statearr_66238_66261 = state_66231__$1;
(statearr_66238_66261[(2)] = inst_66213);

(statearr_66238_66261[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (2))){
var inst_66199 = (state_66231[(7)]);
var _ = (function (){var statearr_66239 = state_66231;
(statearr_66239[(4)] = cljs.core.cons((5),(state_66231[(4)])));

return statearr_66239;
})();
var inst_66199__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66231__$1 = (function (){var statearr_66240 = state_66231;
(statearr_66240[(7)] = inst_66199__$1);

return statearr_66240;
})();
if(cljs.core.truth_(inst_66199__$1)){
var statearr_66241_66262 = state_66231__$1;
(statearr_66241_66262[(1)] = (6));

} else {
var statearr_66242_66263 = state_66231__$1;
(statearr_66242_66263[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (11))){
var inst_66226 = (state_66231[(2)]);
var _ = (function (){var statearr_66244 = state_66231;
(statearr_66244[(4)] = cljs.core.rest((state_66231[(4)])));

return statearr_66244;
})();
var state_66231__$1 = state_66231;
var statearr_66245_66264 = state_66231__$1;
(statearr_66245_66264[(2)] = inst_66226);

(statearr_66245_66264[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (9))){
var inst_66209 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_66231__$1 = state_66231;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66231__$1,(12),inst_66209);
} else {
if((state_val_66232 === (5))){
var _ = (function (){var statearr_66246 = state_66231;
(statearr_66246[(4)] = cljs.core.rest((state_66231[(4)])));

return statearr_66246;
})();
var state_66231__$1 = state_66231;
var ex66243 = (state_66231__$1[(2)]);
var statearr_66247_66265 = state_66231__$1;
(statearr_66247_66265[(5)] = ex66243);


if((ex66243 instanceof Error)){
var statearr_66248_66266 = state_66231__$1;
(statearr_66248_66266[(1)] = (4));

(statearr_66248_66266[(5)] = null);

} else {
throw ex66243;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (10))){
var inst_66224 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_66231__$1 = state_66231;
var statearr_66249_66267 = state_66231__$1;
(statearr_66249_66267[(2)] = inst_66224);

(statearr_66249_66267[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66232 === (8))){
var inst_66204 = (state_66231[(2)]);
var state_66231__$1 = state_66231;
if(cljs.core.truth_(inst_66204)){
var statearr_66250_66268 = state_66231__$1;
(statearr_66250_66268[(1)] = (9));

} else {
var statearr_66251_66269 = state_66231__$1;
(statearr_66251_66269[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto____0 = (function (){
var statearr_66252 = [null,null,null,null,null,null,null,null,null];
(statearr_66252[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto__);

(statearr_66252[(1)] = (1));

return statearr_66252;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto____1 = (function (state_66231){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66231);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66253){var ex__10801__auto__ = e66253;
var statearr_66254_66270 = state_66231;
(statearr_66254_66270[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66231[(4)]))){
var statearr_66255_66271 = state_66231;
(statearr_66255_66271[(1)] = cljs.core.first((state_66231[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66272 = state_66231;
state_66231 = G__66272;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto__ = function(state_66231){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto____1.call(this,state_66231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66256 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66256[(6)] = c__10835__auto__);

return statearr_66256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66324){
var state_val_66325 = (state_66324[(1)]);
if((state_val_66325 === (7))){
var state_66324__$1 = state_66324;
var statearr_66326_66359 = state_66324__$1;
(statearr_66326_66359[(2)] = subject);

(statearr_66326_66359[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (1))){
var state_66324__$1 = state_66324;
var statearr_66327_66360 = state_66324__$1;
(statearr_66327_66360[(2)] = null);

(statearr_66327_66360[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (4))){
var inst_66273 = (state_66324[(2)]);
var state_66324__$1 = state_66324;
var statearr_66328_66361 = state_66324__$1;
(statearr_66328_66361[(2)] = inst_66273);

(statearr_66328_66361[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (15))){
var inst_66286 = (state_66324[(7)]);
var state_66324__$1 = state_66324;
var statearr_66329_66362 = state_66324__$1;
(statearr_66329_66362[(2)] = inst_66286);

(statearr_66329_66362[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (13))){
var inst_66290 = (state_66324[(2)]);
var inst_66291 = fluree.db.util.async.throw_err(inst_66290);
var state_66324__$1 = state_66324;
var statearr_66330_66363 = state_66324__$1;
(statearr_66330_66363[(2)] = inst_66291);

(statearr_66330_66363[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (6))){
var state_66324__$1 = state_66324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66324__$1,(9),subject);
} else {
if((state_val_66325 === (17))){
var inst_66286 = (state_66324[(7)]);
var inst_66300 = cljs.core.first(inst_66286);
var state_66324__$1 = state_66324;
var statearr_66331_66364 = state_66324__$1;
(statearr_66331_66364[(2)] = inst_66300);

(statearr_66331_66364[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (3))){
var inst_66322 = (state_66324[(2)]);
var state_66324__$1 = state_66324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66324__$1,inst_66322);
} else {
if((state_val_66325 === (12))){
var inst_66286 = (state_66324[(7)]);
var inst_66294 = (state_66324[(2)]);
var inst_66295 = cljs.core.vector_QMARK_(inst_66286);
var state_66324__$1 = (function (){var statearr_66332 = state_66324;
(statearr_66332[(8)] = inst_66294);

return statearr_66332;
})();
if(inst_66295){
var statearr_66333_66365 = state_66324__$1;
(statearr_66333_66365[(1)] = (14));

} else {
var statearr_66334_66366 = state_66324__$1;
(statearr_66334_66366[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (2))){
var _ = (function (){var statearr_66335 = state_66324;
(statearr_66335[(4)] = cljs.core.cons((5),(state_66324[(4)])));

return statearr_66335;
})();
var inst_66279 = fluree.db.util.async.channel_QMARK_(subject);
var state_66324__$1 = state_66324;
if(inst_66279){
var statearr_66336_66367 = state_66324__$1;
(statearr_66336_66367[(1)] = (6));

} else {
var statearr_66337_66368 = state_66324__$1;
(statearr_66337_66368[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (19))){
var inst_66303 = (state_66324[(2)]);
var state_66324__$1 = state_66324;
var statearr_66338_66369 = state_66324__$1;
(statearr_66338_66369[(2)] = inst_66303);

(statearr_66338_66369[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (11))){
var state_66324__$1 = state_66324;
var statearr_66340_66370 = state_66324__$1;
(statearr_66340_66370[(2)] = path);

(statearr_66340_66370[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (9))){
var inst_66282 = (state_66324[(2)]);
var inst_66283 = fluree.db.util.async.throw_err(inst_66282);
var state_66324__$1 = state_66324;
var statearr_66341_66371 = state_66324__$1;
(statearr_66341_66371[(2)] = inst_66283);

(statearr_66341_66371[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (5))){
var _ = (function (){var statearr_66342 = state_66324;
(statearr_66342[(4)] = cljs.core.rest((state_66324[(4)])));

return statearr_66342;
})();
var state_66324__$1 = state_66324;
var ex66339 = (state_66324__$1[(2)]);
var statearr_66343_66372 = state_66324__$1;
(statearr_66343_66372[(5)] = ex66339);


if((ex66339 instanceof Error)){
var statearr_66344_66373 = state_66324__$1;
(statearr_66344_66373[(1)] = (4));

(statearr_66344_66373[(5)] = null);

} else {
throw ex66339;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (14))){
var inst_66286 = (state_66324[(7)]);
var inst_66297 = cljs.core.count(inst_66286);
var inst_66298 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66297);
var state_66324__$1 = state_66324;
if(inst_66298){
var statearr_66345_66374 = state_66324__$1;
(statearr_66345_66374[(1)] = (17));

} else {
var statearr_66346_66375 = state_66324__$1;
(statearr_66346_66375[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (16))){
var inst_66286 = (state_66324[(7)]);
var inst_66294 = (state_66324[(8)]);
var inst_66306 = (state_66324[(2)]);
var inst_66307 = fluree.db.dbfunctions.internal.get_all(inst_66306,inst_66294);
var inst_66308 = cljs.core.count(inst_66294);
var inst_66309 = ((9) + inst_66308);
var inst_66310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66311 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66313 = [inst_66286,inst_66294];
var inst_66314 = (new cljs.core.PersistentVector(null,2,(5),inst_66312,inst_66313,null));
var inst_66315 = ["get-all",inst_66314,inst_66307];
var inst_66316 = cljs.core.PersistentHashMap.fromArrays(inst_66311,inst_66315);
var inst_66317 = [inst_66316,inst_66309];
var inst_66318 = (new cljs.core.PersistentVector(null,2,(5),inst_66310,inst_66317,null));
var inst_66319 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66318);
var _ = (function (){var statearr_66347 = state_66324;
(statearr_66347[(4)] = cljs.core.rest((state_66324[(4)])));

return statearr_66347;
})();
var state_66324__$1 = (function (){var statearr_66348 = state_66324;
(statearr_66348[(9)] = inst_66319);

return statearr_66348;
})();
var statearr_66349_66376 = state_66324__$1;
(statearr_66349_66376[(2)] = inst_66307);

(statearr_66349_66376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (10))){
var state_66324__$1 = state_66324;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66324__$1,(13),path);
} else {
if((state_val_66325 === (18))){
var inst_66286 = (state_66324[(7)]);
var state_66324__$1 = state_66324;
var statearr_66350_66377 = state_66324__$1;
(statearr_66350_66377[(2)] = inst_66286);

(statearr_66350_66377[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66325 === (8))){
var inst_66286 = (state_66324[(2)]);
var inst_66287 = fluree.db.util.async.channel_QMARK_(path);
var state_66324__$1 = (function (){var statearr_66351 = state_66324;
(statearr_66351[(7)] = inst_66286);

return statearr_66351;
})();
if(inst_66287){
var statearr_66352_66378 = state_66324__$1;
(statearr_66352_66378[(1)] = (10));

} else {
var statearr_66353_66379 = state_66324__$1;
(statearr_66353_66379[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto____0 = (function (){
var statearr_66354 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66354[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto__);

(statearr_66354[(1)] = (1));

return statearr_66354;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto____1 = (function (state_66324){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66324);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66355){var ex__10801__auto__ = e66355;
var statearr_66356_66380 = state_66324;
(statearr_66356_66380[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66324[(4)]))){
var statearr_66357_66381 = state_66324;
(statearr_66357_66381[(1)] = cljs.core.first((state_66324[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66382 = state_66324;
state_66324 = G__66382;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto__ = function(state_66324){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto____1.call(this,state_66324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66358 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66358[(6)] = c__10835__auto__);

return statearr_66358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66421){
var state_val_66422 = (state_66421[(1)]);
if((state_val_66422 === (7))){
var state_66421__$1 = state_66421;
var statearr_66423_66447 = state_66421__$1;
(statearr_66423_66447[(2)] = subject);

(statearr_66423_66447[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (1))){
var state_66421__$1 = state_66421;
var statearr_66424_66448 = state_66421__$1;
(statearr_66424_66448[(2)] = null);

(statearr_66424_66448[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (4))){
var inst_66383 = (state_66421[(2)]);
var state_66421__$1 = state_66421;
var statearr_66425_66449 = state_66421__$1;
(statearr_66425_66449[(2)] = inst_66383);

(statearr_66425_66449[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (13))){
var inst_66400 = (state_66421[(2)]);
var inst_66401 = fluree.db.util.async.throw_err(inst_66400);
var state_66421__$1 = state_66421;
var statearr_66426_66450 = state_66421__$1;
(statearr_66426_66450[(2)] = inst_66401);

(statearr_66426_66450[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (6))){
var state_66421__$1 = state_66421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66421__$1,(9),subject);
} else {
if((state_val_66422 === (3))){
var inst_66419 = (state_66421[(2)]);
var state_66421__$1 = state_66421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66421__$1,inst_66419);
} else {
if((state_val_66422 === (12))){
var inst_66396 = (state_66421[(7)]);
var inst_66404 = (state_66421[(2)]);
var inst_66405 = fluree.db.dbfunctions.internal.get_in(inst_66396,inst_66404);
var inst_66406 = cljs.core.count(inst_66404);
var inst_66407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66408 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66410 = [inst_66396,inst_66404];
var inst_66411 = (new cljs.core.PersistentVector(null,2,(5),inst_66409,inst_66410,null));
var inst_66412 = ["get-in",inst_66411,inst_66405];
var inst_66413 = cljs.core.PersistentHashMap.fromArrays(inst_66408,inst_66412);
var inst_66414 = [inst_66413,inst_66406];
var inst_66415 = (new cljs.core.PersistentVector(null,2,(5),inst_66407,inst_66414,null));
var inst_66416 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66415);
var _ = (function (){var statearr_66427 = state_66421;
(statearr_66427[(4)] = cljs.core.rest((state_66421[(4)])));

return statearr_66427;
})();
var state_66421__$1 = (function (){var statearr_66428 = state_66421;
(statearr_66428[(8)] = inst_66416);

return statearr_66428;
})();
var statearr_66429_66451 = state_66421__$1;
(statearr_66429_66451[(2)] = inst_66405);

(statearr_66429_66451[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (2))){
var _ = (function (){var statearr_66430 = state_66421;
(statearr_66430[(4)] = cljs.core.cons((5),(state_66421[(4)])));

return statearr_66430;
})();
var inst_66389 = fluree.db.util.async.channel_QMARK_(subject);
var state_66421__$1 = state_66421;
if(inst_66389){
var statearr_66431_66452 = state_66421__$1;
(statearr_66431_66452[(1)] = (6));

} else {
var statearr_66432_66453 = state_66421__$1;
(statearr_66432_66453[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (11))){
var state_66421__$1 = state_66421;
var statearr_66434_66454 = state_66421__$1;
(statearr_66434_66454[(2)] = path);

(statearr_66434_66454[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (9))){
var inst_66392 = (state_66421[(2)]);
var inst_66393 = fluree.db.util.async.throw_err(inst_66392);
var state_66421__$1 = state_66421;
var statearr_66435_66455 = state_66421__$1;
(statearr_66435_66455[(2)] = inst_66393);

(statearr_66435_66455[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (5))){
var _ = (function (){var statearr_66436 = state_66421;
(statearr_66436[(4)] = cljs.core.rest((state_66421[(4)])));

return statearr_66436;
})();
var state_66421__$1 = state_66421;
var ex66433 = (state_66421__$1[(2)]);
var statearr_66437_66456 = state_66421__$1;
(statearr_66437_66456[(5)] = ex66433);


if((ex66433 instanceof Error)){
var statearr_66438_66457 = state_66421__$1;
(statearr_66438_66457[(1)] = (4));

(statearr_66438_66457[(5)] = null);

} else {
throw ex66433;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66422 === (10))){
var state_66421__$1 = state_66421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66421__$1,(13),path);
} else {
if((state_val_66422 === (8))){
var inst_66396 = (state_66421[(2)]);
var inst_66397 = fluree.db.util.async.channel_QMARK_(path);
var state_66421__$1 = (function (){var statearr_66439 = state_66421;
(statearr_66439[(7)] = inst_66396);

return statearr_66439;
})();
if(inst_66397){
var statearr_66440_66458 = state_66421__$1;
(statearr_66440_66458[(1)] = (10));

} else {
var statearr_66441_66459 = state_66421__$1;
(statearr_66441_66459[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto____0 = (function (){
var statearr_66442 = [null,null,null,null,null,null,null,null,null];
(statearr_66442[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto__);

(statearr_66442[(1)] = (1));

return statearr_66442;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto____1 = (function (state_66421){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66421);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66443){var ex__10801__auto__ = e66443;
var statearr_66444_66460 = state_66421;
(statearr_66444_66460[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66421[(4)]))){
var statearr_66445_66461 = state_66421;
(statearr_66445_66461[(1)] = cljs.core.first((state_66421[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66462 = state_66421;
state_66421 = G__66462;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto__ = function(state_66421){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto____1.call(this,state_66421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66446 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66446[(6)] = c__10835__auto__);

return statearr_66446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66507){
var state_val_66508 = (state_66507[(1)]);
if((state_val_66508 === (7))){
var state_66507__$1 = state_66507;
var statearr_66509_66538 = state_66507__$1;
(statearr_66509_66538[(2)] = coll);

(statearr_66509_66538[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (1))){
var state_66507__$1 = state_66507;
var statearr_66510_66539 = state_66507__$1;
(statearr_66510_66539[(2)] = null);

(statearr_66510_66539[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (4))){
var inst_66463 = (state_66507[(2)]);
var state_66507__$1 = state_66507;
var statearr_66511_66540 = state_66507__$1;
(statearr_66511_66540[(2)] = inst_66463);

(statearr_66511_66540[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (15))){
var inst_66483 = (state_66507[(7)]);
var inst_66491 = (state_66507[(2)]);
var inst_66492 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_66483,inst_66491);
var inst_66493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66494 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66496 = [inst_66483,inst_66491];
var inst_66497 = (new cljs.core.PersistentVector(null,2,(5),inst_66495,inst_66496,null));
var inst_66498 = ["contains?",inst_66497,inst_66492];
var inst_66499 = cljs.core.PersistentHashMap.fromArrays(inst_66494,inst_66498);
var inst_66500 = [inst_66499,(10)];
var inst_66501 = (new cljs.core.PersistentVector(null,2,(5),inst_66493,inst_66500,null));
var inst_66502 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66501);
var _ = (function (){var statearr_66512 = state_66507;
(statearr_66512[(4)] = cljs.core.rest((state_66507[(4)])));

return statearr_66512;
})();
var state_66507__$1 = (function (){var statearr_66513 = state_66507;
(statearr_66513[(8)] = inst_66502);

return statearr_66513;
})();
var statearr_66514_66541 = state_66507__$1;
(statearr_66514_66541[(2)] = inst_66492);

(statearr_66514_66541[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (13))){
var state_66507__$1 = state_66507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66507__$1,(16),key);
} else {
if((state_val_66508 === (6))){
var state_66507__$1 = state_66507;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66507__$1,(9),coll);
} else {
if((state_val_66508 === (3))){
var inst_66505 = (state_66507[(2)]);
var state_66507__$1 = state_66507;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66507__$1,inst_66505);
} else {
if((state_val_66508 === (12))){
var inst_66483 = (state_66507[(2)]);
var inst_66484 = fluree.db.util.async.channel_QMARK_(key);
var state_66507__$1 = (function (){var statearr_66515 = state_66507;
(statearr_66515[(7)] = inst_66483);

return statearr_66515;
})();
if(inst_66484){
var statearr_66516_66542 = state_66507__$1;
(statearr_66516_66542[(1)] = (13));

} else {
var statearr_66517_66543 = state_66507__$1;
(statearr_66517_66543[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (2))){
var _ = (function (){var statearr_66518 = state_66507;
(statearr_66518[(4)] = cljs.core.cons((5),(state_66507[(4)])));

return statearr_66518;
})();
var inst_66469 = fluree.db.util.async.channel_QMARK_(coll);
var state_66507__$1 = state_66507;
if(inst_66469){
var statearr_66519_66544 = state_66507__$1;
(statearr_66519_66544[(1)] = (6));

} else {
var statearr_66520_66545 = state_66507__$1;
(statearr_66520_66545[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (11))){
var inst_66476 = (state_66507[(9)]);
var inst_66480 = cljs.core.flatten(inst_66476);
var inst_66481 = cljs.core.set(inst_66480);
var state_66507__$1 = state_66507;
var statearr_66522_66546 = state_66507__$1;
(statearr_66522_66546[(2)] = inst_66481);

(statearr_66522_66546[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (9))){
var inst_66472 = (state_66507[(2)]);
var inst_66473 = fluree.db.util.async.throw_err(inst_66472);
var state_66507__$1 = state_66507;
var statearr_66523_66547 = state_66507__$1;
(statearr_66523_66547[(2)] = inst_66473);

(statearr_66523_66547[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (5))){
var _ = (function (){var statearr_66524 = state_66507;
(statearr_66524[(4)] = cljs.core.rest((state_66507[(4)])));

return statearr_66524;
})();
var state_66507__$1 = state_66507;
var ex66521 = (state_66507__$1[(2)]);
var statearr_66525_66548 = state_66507__$1;
(statearr_66525_66548[(5)] = ex66521);


if((ex66521 instanceof Error)){
var statearr_66526_66549 = state_66507__$1;
(statearr_66526_66549[(1)] = (4));

(statearr_66526_66549[(5)] = null);

} else {
throw ex66521;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (14))){
var state_66507__$1 = state_66507;
var statearr_66527_66550 = state_66507__$1;
(statearr_66527_66550[(2)] = key);

(statearr_66527_66550[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (16))){
var inst_66487 = (state_66507[(2)]);
var inst_66488 = fluree.db.util.async.throw_err(inst_66487);
var state_66507__$1 = state_66507;
var statearr_66528_66551 = state_66507__$1;
(statearr_66528_66551[(2)] = inst_66488);

(statearr_66528_66551[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (10))){
var inst_66476 = (state_66507[(9)]);
var state_66507__$1 = state_66507;
var statearr_66529_66552 = state_66507__$1;
(statearr_66529_66552[(2)] = inst_66476);

(statearr_66529_66552[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66508 === (8))){
var inst_66476 = (state_66507[(9)]);
var inst_66476__$1 = (state_66507[(2)]);
var inst_66477 = cljs.core.set_QMARK_(inst_66476__$1);
var state_66507__$1 = (function (){var statearr_66530 = state_66507;
(statearr_66530[(9)] = inst_66476__$1);

return statearr_66530;
})();
if(inst_66477){
var statearr_66531_66553 = state_66507__$1;
(statearr_66531_66553[(1)] = (10));

} else {
var statearr_66532_66554 = state_66507__$1;
(statearr_66532_66554[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto____0 = (function (){
var statearr_66533 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66533[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto__);

(statearr_66533[(1)] = (1));

return statearr_66533;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto____1 = (function (state_66507){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66507);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66534){var ex__10801__auto__ = e66534;
var statearr_66535_66555 = state_66507;
(statearr_66535_66555[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66507[(4)]))){
var statearr_66536_66556 = state_66507;
(statearr_66536_66556[(1)] = cljs.core.first((state_66507[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66557 = state_66507;
state_66507 = G__66557;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto__ = function(state_66507){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto____1.call(this,state_66507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66537 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66537[(6)] = c__10835__auto__);

return statearr_66537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66629 = arguments.length;
var i__4830__auto___66630 = (0);
while(true){
if((i__4830__auto___66630 < len__4829__auto___66629)){
args__4835__auto__.push((arguments[i__4830__auto___66630]));

var G__66631 = (i__4830__auto___66630 + (1));
i__4830__auto___66630 = G__66631;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66603){
var state_val_66604 = (state_66603[(1)]);
if((state_val_66604 === (7))){
var inst_66569 = (state_66603[(7)]);
var inst_66573 = cljs.core.first(inst_66569);
var inst_66574 = cljs.core.coll_QMARK_(inst_66573);
var state_66603__$1 = state_66603;
var statearr_66605_66632 = state_66603__$1;
(statearr_66605_66632[(2)] = inst_66574);

(statearr_66605_66632[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (1))){
var state_66603__$1 = state_66603;
var statearr_66606_66633 = state_66603__$1;
(statearr_66606_66633[(2)] = null);

(statearr_66606_66633[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (4))){
var inst_66560 = (state_66603[(2)]);
var state_66603__$1 = state_66603;
var statearr_66607_66634 = state_66603__$1;
(statearr_66607_66634[(2)] = inst_66560);

(statearr_66607_66634[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (6))){
var inst_66571 = (state_66603[(8)]);
var inst_66569 = (state_66603[(7)]);
var inst_66568 = (state_66603[(2)]);
var inst_66569__$1 = fluree.db.util.async.throw_err(inst_66568);
var inst_66570 = cljs.core.count(inst_66569__$1);
var inst_66571__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66570);
var state_66603__$1 = (function (){var statearr_66608 = state_66603;
(statearr_66608[(8)] = inst_66571__$1);

(statearr_66608[(7)] = inst_66569__$1);

return statearr_66608;
})();
if(inst_66571__$1){
var statearr_66609_66635 = state_66603__$1;
(statearr_66609_66635[(1)] = (7));

} else {
var statearr_66610_66636 = state_66603__$1;
(statearr_66610_66636[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (3))){
var inst_66601 = (state_66603[(2)]);
var state_66603__$1 = state_66603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66603__$1,inst_66601);
} else {
if((state_val_66604 === (12))){
var inst_66582 = (state_66603[(2)]);
var inst_66583 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_66582);
var inst_66584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66585 = [inst_66582];
var inst_66586 = (new cljs.core.PersistentVector(null,1,(5),inst_66584,inst_66585,null));
var inst_66587 = cljs.core.count(inst_66586);
var inst_66588 = ((9) + inst_66587);
var inst_66589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66590 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66592 = [inst_66582];
var inst_66593 = (new cljs.core.PersistentVector(null,1,(5),inst_66591,inst_66592,null));
var inst_66594 = ["hash-set",inst_66593,inst_66583];
var inst_66595 = cljs.core.PersistentHashMap.fromArrays(inst_66590,inst_66594);
var inst_66596 = [inst_66595,inst_66588];
var inst_66597 = (new cljs.core.PersistentVector(null,2,(5),inst_66589,inst_66596,null));
var inst_66598 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66597);
var _ = (function (){var statearr_66611 = state_66603;
(statearr_66611[(4)] = cljs.core.rest((state_66603[(4)])));

return statearr_66611;
})();
var state_66603__$1 = (function (){var statearr_66612 = state_66603;
(statearr_66612[(9)] = inst_66598);

return statearr_66612;
})();
var statearr_66613_66637 = state_66603__$1;
(statearr_66613_66637[(2)] = inst_66583);

(statearr_66613_66637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (2))){
var _ = (function (){var statearr_66614 = state_66603;
(statearr_66614[(4)] = cljs.core.cons((5),(state_66603[(4)])));

return statearr_66614;
})();
var inst_66566 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66603__$1 = state_66603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66603__$1,(6),inst_66566);
} else {
if((state_val_66604 === (11))){
var inst_66569 = (state_66603[(7)]);
var state_66603__$1 = state_66603;
var statearr_66616_66638 = state_66603__$1;
(statearr_66616_66638[(2)] = inst_66569);

(statearr_66616_66638[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (9))){
var inst_66577 = (state_66603[(2)]);
var state_66603__$1 = state_66603;
if(cljs.core.truth_(inst_66577)){
var statearr_66617_66639 = state_66603__$1;
(statearr_66617_66639[(1)] = (10));

} else {
var statearr_66618_66640 = state_66603__$1;
(statearr_66618_66640[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (5))){
var _ = (function (){var statearr_66619 = state_66603;
(statearr_66619[(4)] = cljs.core.rest((state_66603[(4)])));

return statearr_66619;
})();
var state_66603__$1 = state_66603;
var ex66615 = (state_66603__$1[(2)]);
var statearr_66620_66641 = state_66603__$1;
(statearr_66620_66641[(5)] = ex66615);


if((ex66615 instanceof Error)){
var statearr_66621_66642 = state_66603__$1;
(statearr_66621_66642[(1)] = (4));

(statearr_66621_66642[(5)] = null);

} else {
throw ex66615;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (10))){
var inst_66569 = (state_66603[(7)]);
var inst_66579 = cljs.core.first(inst_66569);
var state_66603__$1 = state_66603;
var statearr_66622_66643 = state_66603__$1;
(statearr_66622_66643[(2)] = inst_66579);

(statearr_66622_66643[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66604 === (8))){
var inst_66571 = (state_66603[(8)]);
var state_66603__$1 = state_66603;
var statearr_66623_66644 = state_66603__$1;
(statearr_66623_66644[(2)] = inst_66571);

(statearr_66623_66644[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_66624 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66624[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_66624[(1)] = (1));

return statearr_66624;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_66603){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66603);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66625){var ex__10801__auto__ = e66625;
var statearr_66626_66645 = state_66603;
(statearr_66626_66645[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66603[(4)]))){
var statearr_66627_66646 = state_66603;
(statearr_66627_66646[(1)] = cljs.core.first((state_66603[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66647 = state_66603;
state_66603 = G__66647;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_66603){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_66603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66628 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66628[(6)] = c__10835__auto__);

return statearr_66628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq66558){
var G__66559 = cljs.core.first(seq66558);
var seq66558__$1 = cljs.core.next(seq66558);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66559,seq66558__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66697 = arguments.length;
var i__4830__auto___66698 = (0);
while(true){
if((i__4830__auto___66698 < len__4829__auto___66697)){
args__4835__auto__.push((arguments[i__4830__auto___66698]));

var G__66699 = (i__4830__auto___66698 + (1));
i__4830__auto___66698 = G__66699;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66680){
var state_val_66681 = (state_66680[(1)]);
if((state_val_66681 === (1))){
var state_66680__$1 = state_66680;
var statearr_66682_66700 = state_66680__$1;
(statearr_66682_66700[(2)] = null);

(statearr_66682_66700[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66681 === (2))){
var _ = (function (){var statearr_66683 = state_66680;
(statearr_66683[(4)] = cljs.core.cons((5),(state_66680[(4)])));

return statearr_66683;
})();
var inst_66656 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66680__$1 = state_66680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66680__$1,(6),inst_66656);
} else {
if((state_val_66681 === (3))){
var inst_66678 = (state_66680[(2)]);
var state_66680__$1 = state_66680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66680__$1,inst_66678);
} else {
if((state_val_66681 === (4))){
var inst_66650 = (state_66680[(2)]);
var state_66680__$1 = state_66680;
var statearr_66685_66701 = state_66680__$1;
(statearr_66685_66701[(2)] = inst_66650);

(statearr_66685_66701[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66681 === (5))){
var _ = (function (){var statearr_66686 = state_66680;
(statearr_66686[(4)] = cljs.core.rest((state_66680[(4)])));

return statearr_66686;
})();
var state_66680__$1 = state_66680;
var ex66684 = (state_66680__$1[(2)]);
var statearr_66687_66702 = state_66680__$1;
(statearr_66687_66702[(5)] = ex66684);


if((ex66684 instanceof Error)){
var statearr_66688_66703 = state_66680__$1;
(statearr_66688_66703[(1)] = (4));

(statearr_66688_66703[(5)] = null);

} else {
throw ex66684;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66681 === (6))){
var inst_66658 = (state_66680[(2)]);
var inst_66659 = fluree.db.util.async.throw_err(inst_66658);
var inst_66660 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_66659);
var inst_66661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66662 = [inst_66659];
var inst_66663 = (new cljs.core.PersistentVector(null,1,(5),inst_66661,inst_66662,null));
var inst_66664 = cljs.core.count(inst_66663);
var inst_66665 = ((9) + inst_66664);
var inst_66666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66667 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66669 = [inst_66659];
var inst_66670 = (new cljs.core.PersistentVector(null,1,(5),inst_66668,inst_66669,null));
var inst_66671 = ["==",inst_66670,inst_66660];
var inst_66672 = cljs.core.PersistentHashMap.fromArrays(inst_66667,inst_66671);
var inst_66673 = [inst_66672,inst_66665];
var inst_66674 = (new cljs.core.PersistentVector(null,2,(5),inst_66666,inst_66673,null));
var inst_66675 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66674);
var _ = (function (){var statearr_66689 = state_66680;
(statearr_66689[(4)] = cljs.core.rest((state_66680[(4)])));

return statearr_66689;
})();
var state_66680__$1 = (function (){var statearr_66690 = state_66680;
(statearr_66690[(7)] = inst_66675);

return statearr_66690;
})();
var statearr_66691_66704 = state_66680__$1;
(statearr_66691_66704[(2)] = inst_66660);

(statearr_66691_66704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_66692 = [null,null,null,null,null,null,null,null];
(statearr_66692[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_66692[(1)] = (1));

return statearr_66692;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_66680){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66680);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66693){var ex__10801__auto__ = e66693;
var statearr_66694_66705 = state_66680;
(statearr_66694_66705[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66680[(4)]))){
var statearr_66695_66706 = state_66680;
(statearr_66695_66706[(1)] = cljs.core.first((state_66680[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66707 = state_66680;
state_66680 = G__66707;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_66680){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_66680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66696 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66696[(6)] = c__10835__auto__);

return statearr_66696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq66648){
var G__66649 = cljs.core.first(seq66648);
var seq66648__$1 = cljs.core.next(seq66648);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66649,seq66648__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66757 = arguments.length;
var i__4830__auto___66758 = (0);
while(true){
if((i__4830__auto___66758 < len__4829__auto___66757)){
args__4835__auto__.push((arguments[i__4830__auto___66758]));

var G__66759 = (i__4830__auto___66758 + (1));
i__4830__auto___66758 = G__66759;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66740){
var state_val_66741 = (state_66740[(1)]);
if((state_val_66741 === (1))){
var state_66740__$1 = state_66740;
var statearr_66742_66760 = state_66740__$1;
(statearr_66742_66760[(2)] = null);

(statearr_66742_66760[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66741 === (2))){
var _ = (function (){var statearr_66743 = state_66740;
(statearr_66743[(4)] = cljs.core.cons((5),(state_66740[(4)])));

return statearr_66743;
})();
var inst_66716 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66740__$1 = state_66740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66740__$1,(6),inst_66716);
} else {
if((state_val_66741 === (3))){
var inst_66738 = (state_66740[(2)]);
var state_66740__$1 = state_66740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66740__$1,inst_66738);
} else {
if((state_val_66741 === (4))){
var inst_66710 = (state_66740[(2)]);
var state_66740__$1 = state_66740;
var statearr_66745_66761 = state_66740__$1;
(statearr_66745_66761[(2)] = inst_66710);

(statearr_66745_66761[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66741 === (5))){
var _ = (function (){var statearr_66746 = state_66740;
(statearr_66746[(4)] = cljs.core.rest((state_66740[(4)])));

return statearr_66746;
})();
var state_66740__$1 = state_66740;
var ex66744 = (state_66740__$1[(2)]);
var statearr_66747_66762 = state_66740__$1;
(statearr_66747_66762[(5)] = ex66744);


if((ex66744 instanceof Error)){
var statearr_66748_66763 = state_66740__$1;
(statearr_66748_66763[(1)] = (4));

(statearr_66748_66763[(5)] = null);

} else {
throw ex66744;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66741 === (6))){
var inst_66718 = (state_66740[(2)]);
var inst_66719 = fluree.db.util.async.throw_err(inst_66718);
var inst_66720 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_66719);
var inst_66721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66722 = [inst_66719];
var inst_66723 = (new cljs.core.PersistentVector(null,1,(5),inst_66721,inst_66722,null));
var inst_66724 = cljs.core.count(inst_66723);
var inst_66725 = ((9) + inst_66724);
var inst_66726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66727 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66729 = [inst_66719];
var inst_66730 = (new cljs.core.PersistentVector(null,1,(5),inst_66728,inst_66729,null));
var inst_66731 = [">",inst_66730,inst_66720];
var inst_66732 = cljs.core.PersistentHashMap.fromArrays(inst_66727,inst_66731);
var inst_66733 = [inst_66732,inst_66725];
var inst_66734 = (new cljs.core.PersistentVector(null,2,(5),inst_66726,inst_66733,null));
var inst_66735 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66734);
var _ = (function (){var statearr_66749 = state_66740;
(statearr_66749[(4)] = cljs.core.rest((state_66740[(4)])));

return statearr_66749;
})();
var state_66740__$1 = (function (){var statearr_66750 = state_66740;
(statearr_66750[(7)] = inst_66735);

return statearr_66750;
})();
var statearr_66751_66764 = state_66740__$1;
(statearr_66751_66764[(2)] = inst_66720);

(statearr_66751_66764[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_66752 = [null,null,null,null,null,null,null,null];
(statearr_66752[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_66752[(1)] = (1));

return statearr_66752;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_66740){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66740);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66753){var ex__10801__auto__ = e66753;
var statearr_66754_66765 = state_66740;
(statearr_66754_66765[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66740[(4)]))){
var statearr_66755_66766 = state_66740;
(statearr_66755_66766[(1)] = cljs.core.first((state_66740[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66767 = state_66740;
state_66740 = G__66767;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_66740){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_66740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66756 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66756[(6)] = c__10835__auto__);

return statearr_66756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq66708){
var G__66709 = cljs.core.first(seq66708);
var seq66708__$1 = cljs.core.next(seq66708);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66709,seq66708__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66817 = arguments.length;
var i__4830__auto___66818 = (0);
while(true){
if((i__4830__auto___66818 < len__4829__auto___66817)){
args__4835__auto__.push((arguments[i__4830__auto___66818]));

var G__66819 = (i__4830__auto___66818 + (1));
i__4830__auto___66818 = G__66819;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66800){
var state_val_66801 = (state_66800[(1)]);
if((state_val_66801 === (1))){
var state_66800__$1 = state_66800;
var statearr_66802_66820 = state_66800__$1;
(statearr_66802_66820[(2)] = null);

(statearr_66802_66820[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66801 === (2))){
var _ = (function (){var statearr_66803 = state_66800;
(statearr_66803[(4)] = cljs.core.cons((5),(state_66800[(4)])));

return statearr_66803;
})();
var inst_66776 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66800__$1 = state_66800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66800__$1,(6),inst_66776);
} else {
if((state_val_66801 === (3))){
var inst_66798 = (state_66800[(2)]);
var state_66800__$1 = state_66800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66800__$1,inst_66798);
} else {
if((state_val_66801 === (4))){
var inst_66770 = (state_66800[(2)]);
var state_66800__$1 = state_66800;
var statearr_66805_66821 = state_66800__$1;
(statearr_66805_66821[(2)] = inst_66770);

(statearr_66805_66821[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66801 === (5))){
var _ = (function (){var statearr_66806 = state_66800;
(statearr_66806[(4)] = cljs.core.rest((state_66800[(4)])));

return statearr_66806;
})();
var state_66800__$1 = state_66800;
var ex66804 = (state_66800__$1[(2)]);
var statearr_66807_66822 = state_66800__$1;
(statearr_66807_66822[(5)] = ex66804);


if((ex66804 instanceof Error)){
var statearr_66808_66823 = state_66800__$1;
(statearr_66808_66823[(1)] = (4));

(statearr_66808_66823[(5)] = null);

} else {
throw ex66804;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66801 === (6))){
var inst_66778 = (state_66800[(2)]);
var inst_66779 = fluree.db.util.async.throw_err(inst_66778);
var inst_66780 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_66779);
var inst_66781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66782 = [inst_66779];
var inst_66783 = (new cljs.core.PersistentVector(null,1,(5),inst_66781,inst_66782,null));
var inst_66784 = cljs.core.count(inst_66783);
var inst_66785 = ((9) + inst_66784);
var inst_66786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66787 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66789 = [inst_66779];
var inst_66790 = (new cljs.core.PersistentVector(null,1,(5),inst_66788,inst_66789,null));
var inst_66791 = ["<",inst_66790,inst_66780];
var inst_66792 = cljs.core.PersistentHashMap.fromArrays(inst_66787,inst_66791);
var inst_66793 = [inst_66792,inst_66785];
var inst_66794 = (new cljs.core.PersistentVector(null,2,(5),inst_66786,inst_66793,null));
var inst_66795 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66794);
var _ = (function (){var statearr_66809 = state_66800;
(statearr_66809[(4)] = cljs.core.rest((state_66800[(4)])));

return statearr_66809;
})();
var state_66800__$1 = (function (){var statearr_66810 = state_66800;
(statearr_66810[(7)] = inst_66795);

return statearr_66810;
})();
var statearr_66811_66824 = state_66800__$1;
(statearr_66811_66824[(2)] = inst_66780);

(statearr_66811_66824[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_66812 = [null,null,null,null,null,null,null,null];
(statearr_66812[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_66812[(1)] = (1));

return statearr_66812;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_66800){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66800);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66813){var ex__10801__auto__ = e66813;
var statearr_66814_66825 = state_66800;
(statearr_66814_66825[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66800[(4)]))){
var statearr_66815_66826 = state_66800;
(statearr_66815_66826[(1)] = cljs.core.first((state_66800[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66827 = state_66800;
state_66800 = G__66827;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_66800){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_66800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66816 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66816[(6)] = c__10835__auto__);

return statearr_66816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq66768){
var G__66769 = cljs.core.first(seq66768);
var seq66768__$1 = cljs.core.next(seq66768);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66769,seq66768__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66877 = arguments.length;
var i__4830__auto___66878 = (0);
while(true){
if((i__4830__auto___66878 < len__4829__auto___66877)){
args__4835__auto__.push((arguments[i__4830__auto___66878]));

var G__66879 = (i__4830__auto___66878 + (1));
i__4830__auto___66878 = G__66879;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66860){
var state_val_66861 = (state_66860[(1)]);
if((state_val_66861 === (1))){
var state_66860__$1 = state_66860;
var statearr_66862_66880 = state_66860__$1;
(statearr_66862_66880[(2)] = null);

(statearr_66862_66880[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66861 === (2))){
var _ = (function (){var statearr_66863 = state_66860;
(statearr_66863[(4)] = cljs.core.cons((5),(state_66860[(4)])));

return statearr_66863;
})();
var inst_66836 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66860__$1 = state_66860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66860__$1,(6),inst_66836);
} else {
if((state_val_66861 === (3))){
var inst_66858 = (state_66860[(2)]);
var state_66860__$1 = state_66860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66860__$1,inst_66858);
} else {
if((state_val_66861 === (4))){
var inst_66830 = (state_66860[(2)]);
var state_66860__$1 = state_66860;
var statearr_66865_66881 = state_66860__$1;
(statearr_66865_66881[(2)] = inst_66830);

(statearr_66865_66881[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66861 === (5))){
var _ = (function (){var statearr_66866 = state_66860;
(statearr_66866[(4)] = cljs.core.rest((state_66860[(4)])));

return statearr_66866;
})();
var state_66860__$1 = state_66860;
var ex66864 = (state_66860__$1[(2)]);
var statearr_66867_66882 = state_66860__$1;
(statearr_66867_66882[(5)] = ex66864);


if((ex66864 instanceof Error)){
var statearr_66868_66883 = state_66860__$1;
(statearr_66868_66883[(1)] = (4));

(statearr_66868_66883[(5)] = null);

} else {
throw ex66864;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66861 === (6))){
var inst_66838 = (state_66860[(2)]);
var inst_66839 = fluree.db.util.async.throw_err(inst_66838);
var inst_66840 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_66839);
var inst_66841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66842 = [inst_66839];
var inst_66843 = (new cljs.core.PersistentVector(null,1,(5),inst_66841,inst_66842,null));
var inst_66844 = cljs.core.count(inst_66843);
var inst_66845 = ((9) + inst_66844);
var inst_66846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66847 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66849 = [inst_66839];
var inst_66850 = (new cljs.core.PersistentVector(null,1,(5),inst_66848,inst_66849,null));
var inst_66851 = ["<=",inst_66850,inst_66840];
var inst_66852 = cljs.core.PersistentHashMap.fromArrays(inst_66847,inst_66851);
var inst_66853 = [inst_66852,inst_66845];
var inst_66854 = (new cljs.core.PersistentVector(null,2,(5),inst_66846,inst_66853,null));
var inst_66855 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66854);
var _ = (function (){var statearr_66869 = state_66860;
(statearr_66869[(4)] = cljs.core.rest((state_66860[(4)])));

return statearr_66869;
})();
var state_66860__$1 = (function (){var statearr_66870 = state_66860;
(statearr_66870[(7)] = inst_66855);

return statearr_66870;
})();
var statearr_66871_66884 = state_66860__$1;
(statearr_66871_66884[(2)] = inst_66840);

(statearr_66871_66884[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_66872 = [null,null,null,null,null,null,null,null];
(statearr_66872[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_66872[(1)] = (1));

return statearr_66872;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_66860){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66860);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66873){var ex__10801__auto__ = e66873;
var statearr_66874_66885 = state_66860;
(statearr_66874_66885[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66860[(4)]))){
var statearr_66875_66886 = state_66860;
(statearr_66875_66886[(1)] = cljs.core.first((state_66860[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66887 = state_66860;
state_66860 = G__66887;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_66860){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_66860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66876 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66876[(6)] = c__10835__auto__);

return statearr_66876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq66828){
var G__66829 = cljs.core.first(seq66828);
var seq66828__$1 = cljs.core.next(seq66828);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66829,seq66828__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66937 = arguments.length;
var i__4830__auto___66938 = (0);
while(true){
if((i__4830__auto___66938 < len__4829__auto___66937)){
args__4835__auto__.push((arguments[i__4830__auto___66938]));

var G__66939 = (i__4830__auto___66938 + (1));
i__4830__auto___66938 = G__66939;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66920){
var state_val_66921 = (state_66920[(1)]);
if((state_val_66921 === (1))){
var state_66920__$1 = state_66920;
var statearr_66922_66940 = state_66920__$1;
(statearr_66922_66940[(2)] = null);

(statearr_66922_66940[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66921 === (2))){
var _ = (function (){var statearr_66923 = state_66920;
(statearr_66923[(4)] = cljs.core.cons((5),(state_66920[(4)])));

return statearr_66923;
})();
var inst_66896 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66920__$1 = state_66920;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66920__$1,(6),inst_66896);
} else {
if((state_val_66921 === (3))){
var inst_66918 = (state_66920[(2)]);
var state_66920__$1 = state_66920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66920__$1,inst_66918);
} else {
if((state_val_66921 === (4))){
var inst_66890 = (state_66920[(2)]);
var state_66920__$1 = state_66920;
var statearr_66925_66941 = state_66920__$1;
(statearr_66925_66941[(2)] = inst_66890);

(statearr_66925_66941[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66921 === (5))){
var _ = (function (){var statearr_66926 = state_66920;
(statearr_66926[(4)] = cljs.core.rest((state_66920[(4)])));

return statearr_66926;
})();
var state_66920__$1 = state_66920;
var ex66924 = (state_66920__$1[(2)]);
var statearr_66927_66942 = state_66920__$1;
(statearr_66927_66942[(5)] = ex66924);


if((ex66924 instanceof Error)){
var statearr_66928_66943 = state_66920__$1;
(statearr_66928_66943[(1)] = (4));

(statearr_66928_66943[(5)] = null);

} else {
throw ex66924;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66921 === (6))){
var inst_66898 = (state_66920[(2)]);
var inst_66899 = fluree.db.util.async.throw_err(inst_66898);
var inst_66900 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_66899);
var inst_66901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66902 = [inst_66899];
var inst_66903 = (new cljs.core.PersistentVector(null,1,(5),inst_66901,inst_66902,null));
var inst_66904 = cljs.core.count(inst_66903);
var inst_66905 = ((9) + inst_66904);
var inst_66906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66907 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66909 = [inst_66899];
var inst_66910 = (new cljs.core.PersistentVector(null,1,(5),inst_66908,inst_66909,null));
var inst_66911 = [">=",inst_66910,inst_66900];
var inst_66912 = cljs.core.PersistentHashMap.fromArrays(inst_66907,inst_66911);
var inst_66913 = [inst_66912,inst_66905];
var inst_66914 = (new cljs.core.PersistentVector(null,2,(5),inst_66906,inst_66913,null));
var inst_66915 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66914);
var _ = (function (){var statearr_66929 = state_66920;
(statearr_66929[(4)] = cljs.core.rest((state_66920[(4)])));

return statearr_66929;
})();
var state_66920__$1 = (function (){var statearr_66930 = state_66920;
(statearr_66930[(7)] = inst_66915);

return statearr_66930;
})();
var statearr_66931_66944 = state_66920__$1;
(statearr_66931_66944[(2)] = inst_66900);

(statearr_66931_66944[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_66932 = [null,null,null,null,null,null,null,null];
(statearr_66932[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_66932[(1)] = (1));

return statearr_66932;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_66920){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66920);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66933){var ex__10801__auto__ = e66933;
var statearr_66934_66945 = state_66920;
(statearr_66934_66945[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66920[(4)]))){
var statearr_66935_66946 = state_66920;
(statearr_66935_66946[(1)] = cljs.core.first((state_66920[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__66947 = state_66920;
state_66920 = G__66947;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_66920){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_66920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66936 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66936[(6)] = c__10835__auto__);

return statearr_66936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq66888){
var G__66889 = cljs.core.first(seq66888);
var seq66888__$1 = cljs.core.next(seq66888);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66889,seq66888__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66997 = arguments.length;
var i__4830__auto___66998 = (0);
while(true){
if((i__4830__auto___66998 < len__4829__auto___66997)){
args__4835__auto__.push((arguments[i__4830__auto___66998]));

var G__66999 = (i__4830__auto___66998 + (1));
i__4830__auto___66998 = G__66999;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_66980){
var state_val_66981 = (state_66980[(1)]);
if((state_val_66981 === (1))){
var state_66980__$1 = state_66980;
var statearr_66982_67000 = state_66980__$1;
(statearr_66982_67000[(2)] = null);

(statearr_66982_67000[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66981 === (2))){
var _ = (function (){var statearr_66983 = state_66980;
(statearr_66983[(4)] = cljs.core.cons((5),(state_66980[(4)])));

return statearr_66983;
})();
var inst_66956 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66980__$1 = state_66980;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66980__$1,(6),inst_66956);
} else {
if((state_val_66981 === (3))){
var inst_66978 = (state_66980[(2)]);
var state_66980__$1 = state_66980;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66980__$1,inst_66978);
} else {
if((state_val_66981 === (4))){
var inst_66950 = (state_66980[(2)]);
var state_66980__$1 = state_66980;
var statearr_66985_67001 = state_66980__$1;
(statearr_66985_67001[(2)] = inst_66950);

(statearr_66985_67001[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66981 === (5))){
var _ = (function (){var statearr_66986 = state_66980;
(statearr_66986[(4)] = cljs.core.rest((state_66980[(4)])));

return statearr_66986;
})();
var state_66980__$1 = state_66980;
var ex66984 = (state_66980__$1[(2)]);
var statearr_66987_67002 = state_66980__$1;
(statearr_66987_67002[(5)] = ex66984);


if((ex66984 instanceof Error)){
var statearr_66988_67003 = state_66980__$1;
(statearr_66988_67003[(1)] = (4));

(statearr_66988_67003[(5)] = null);

} else {
throw ex66984;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66981 === (6))){
var inst_66958 = (state_66980[(2)]);
var inst_66959 = fluree.db.util.async.throw_err(inst_66958);
var inst_66960 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_66959);
var inst_66961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66962 = [inst_66959];
var inst_66963 = (new cljs.core.PersistentVector(null,1,(5),inst_66961,inst_66962,null));
var inst_66964 = cljs.core.count(inst_66963);
var inst_66965 = ((9) + inst_66964);
var inst_66966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66967 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66969 = [inst_66959];
var inst_66970 = (new cljs.core.PersistentVector(null,1,(5),inst_66968,inst_66969,null));
var inst_66971 = ["not=",inst_66970,inst_66960];
var inst_66972 = cljs.core.PersistentHashMap.fromArrays(inst_66967,inst_66971);
var inst_66973 = [inst_66972,inst_66965];
var inst_66974 = (new cljs.core.PersistentVector(null,2,(5),inst_66966,inst_66973,null));
var inst_66975 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66974);
var _ = (function (){var statearr_66989 = state_66980;
(statearr_66989[(4)] = cljs.core.rest((state_66980[(4)])));

return statearr_66989;
})();
var state_66980__$1 = (function (){var statearr_66990 = state_66980;
(statearr_66990[(7)] = inst_66975);

return statearr_66990;
})();
var statearr_66991_67004 = state_66980__$1;
(statearr_66991_67004[(2)] = inst_66960);

(statearr_66991_67004[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_66992 = [null,null,null,null,null,null,null,null];
(statearr_66992[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_66992[(1)] = (1));

return statearr_66992;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_66980){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_66980);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e66993){var ex__10801__auto__ = e66993;
var statearr_66994_67005 = state_66980;
(statearr_66994_67005[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_66980[(4)]))){
var statearr_66995_67006 = state_66980;
(statearr_66995_67006[(1)] = cljs.core.first((state_66980[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67007 = state_66980;
state_66980 = G__67007;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_66980){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_66980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_66996 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_66996[(6)] = c__10835__auto__);

return statearr_66996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq66948){
var G__66949 = cljs.core.first(seq66948);
var seq66948__$1 = cljs.core.next(seq66948);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66949,seq66948__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___67057 = arguments.length;
var i__4830__auto___67058 = (0);
while(true){
if((i__4830__auto___67058 < len__4829__auto___67057)){
args__4835__auto__.push((arguments[i__4830__auto___67058]));

var G__67059 = (i__4830__auto___67058 + (1));
i__4830__auto___67058 = G__67059;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67040){
var state_val_67041 = (state_67040[(1)]);
if((state_val_67041 === (1))){
var state_67040__$1 = state_67040;
var statearr_67042_67060 = state_67040__$1;
(statearr_67042_67060[(2)] = null);

(statearr_67042_67060[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67041 === (2))){
var _ = (function (){var statearr_67043 = state_67040;
(statearr_67043[(4)] = cljs.core.cons((5),(state_67040[(4)])));

return statearr_67043;
})();
var inst_67016 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67040__$1 = state_67040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67040__$1,(6),inst_67016);
} else {
if((state_val_67041 === (3))){
var inst_67038 = (state_67040[(2)]);
var state_67040__$1 = state_67040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67040__$1,inst_67038);
} else {
if((state_val_67041 === (4))){
var inst_67010 = (state_67040[(2)]);
var state_67040__$1 = state_67040;
var statearr_67045_67061 = state_67040__$1;
(statearr_67045_67061[(2)] = inst_67010);

(statearr_67045_67061[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67041 === (5))){
var _ = (function (){var statearr_67046 = state_67040;
(statearr_67046[(4)] = cljs.core.rest((state_67040[(4)])));

return statearr_67046;
})();
var state_67040__$1 = state_67040;
var ex67044 = (state_67040__$1[(2)]);
var statearr_67047_67062 = state_67040__$1;
(statearr_67047_67062[(5)] = ex67044);


if((ex67044 instanceof Error)){
var statearr_67048_67063 = state_67040__$1;
(statearr_67048_67063[(1)] = (4));

(statearr_67048_67063[(5)] = null);

} else {
throw ex67044;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67041 === (6))){
var inst_67018 = (state_67040[(2)]);
var inst_67019 = fluree.db.util.async.throw_err(inst_67018);
var inst_67020 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_67019);
var inst_67021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67022 = [inst_67019];
var inst_67023 = (new cljs.core.PersistentVector(null,1,(5),inst_67021,inst_67022,null));
var inst_67024 = cljs.core.count(inst_67023);
var inst_67025 = ((9) + inst_67024);
var inst_67026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67027 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67029 = [inst_67019];
var inst_67030 = (new cljs.core.PersistentVector(null,1,(5),inst_67028,inst_67029,null));
var inst_67031 = ["max",inst_67030,inst_67020];
var inst_67032 = cljs.core.PersistentHashMap.fromArrays(inst_67027,inst_67031);
var inst_67033 = [inst_67032,inst_67025];
var inst_67034 = (new cljs.core.PersistentVector(null,2,(5),inst_67026,inst_67033,null));
var inst_67035 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67034);
var _ = (function (){var statearr_67049 = state_67040;
(statearr_67049[(4)] = cljs.core.rest((state_67040[(4)])));

return statearr_67049;
})();
var state_67040__$1 = (function (){var statearr_67050 = state_67040;
(statearr_67050[(7)] = inst_67035);

return statearr_67050;
})();
var statearr_67051_67064 = state_67040__$1;
(statearr_67051_67064[(2)] = inst_67020);

(statearr_67051_67064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67052 = [null,null,null,null,null,null,null,null];
(statearr_67052[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67052[(1)] = (1));

return statearr_67052;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67040){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67040);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67053){var ex__10801__auto__ = e67053;
var statearr_67054_67065 = state_67040;
(statearr_67054_67065[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67040[(4)]))){
var statearr_67055_67066 = state_67040;
(statearr_67055_67066[(1)] = cljs.core.first((state_67040[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67067 = state_67040;
state_67040 = G__67067;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67040){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67056 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67056[(6)] = c__10835__auto__);

return statearr_67056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq67008){
var G__67009 = cljs.core.first(seq67008);
var seq67008__$1 = cljs.core.next(seq67008);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67009,seq67008__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___67117 = arguments.length;
var i__4830__auto___67118 = (0);
while(true){
if((i__4830__auto___67118 < len__4829__auto___67117)){
args__4835__auto__.push((arguments[i__4830__auto___67118]));

var G__67119 = (i__4830__auto___67118 + (1));
i__4830__auto___67118 = G__67119;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67100){
var state_val_67101 = (state_67100[(1)]);
if((state_val_67101 === (1))){
var state_67100__$1 = state_67100;
var statearr_67102_67120 = state_67100__$1;
(statearr_67102_67120[(2)] = null);

(statearr_67102_67120[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67101 === (2))){
var _ = (function (){var statearr_67103 = state_67100;
(statearr_67103[(4)] = cljs.core.cons((5),(state_67100[(4)])));

return statearr_67103;
})();
var inst_67076 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67100__$1 = state_67100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67100__$1,(6),inst_67076);
} else {
if((state_val_67101 === (3))){
var inst_67098 = (state_67100[(2)]);
var state_67100__$1 = state_67100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67100__$1,inst_67098);
} else {
if((state_val_67101 === (4))){
var inst_67070 = (state_67100[(2)]);
var state_67100__$1 = state_67100;
var statearr_67105_67121 = state_67100__$1;
(statearr_67105_67121[(2)] = inst_67070);

(statearr_67105_67121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67101 === (5))){
var _ = (function (){var statearr_67106 = state_67100;
(statearr_67106[(4)] = cljs.core.rest((state_67100[(4)])));

return statearr_67106;
})();
var state_67100__$1 = state_67100;
var ex67104 = (state_67100__$1[(2)]);
var statearr_67107_67122 = state_67100__$1;
(statearr_67107_67122[(5)] = ex67104);


if((ex67104 instanceof Error)){
var statearr_67108_67123 = state_67100__$1;
(statearr_67108_67123[(1)] = (4));

(statearr_67108_67123[(5)] = null);

} else {
throw ex67104;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67101 === (6))){
var inst_67078 = (state_67100[(2)]);
var inst_67079 = fluree.db.util.async.throw_err(inst_67078);
var inst_67080 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_67079);
var inst_67081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67082 = [inst_67079];
var inst_67083 = (new cljs.core.PersistentVector(null,1,(5),inst_67081,inst_67082,null));
var inst_67084 = cljs.core.count(inst_67083);
var inst_67085 = ((9) + inst_67084);
var inst_67086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67087 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67089 = [inst_67079];
var inst_67090 = (new cljs.core.PersistentVector(null,1,(5),inst_67088,inst_67089,null));
var inst_67091 = ["min",inst_67090,inst_67080];
var inst_67092 = cljs.core.PersistentHashMap.fromArrays(inst_67087,inst_67091);
var inst_67093 = [inst_67092,inst_67085];
var inst_67094 = (new cljs.core.PersistentVector(null,2,(5),inst_67086,inst_67093,null));
var inst_67095 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67094);
var _ = (function (){var statearr_67109 = state_67100;
(statearr_67109[(4)] = cljs.core.rest((state_67100[(4)])));

return statearr_67109;
})();
var state_67100__$1 = (function (){var statearr_67110 = state_67100;
(statearr_67110[(7)] = inst_67095);

return statearr_67110;
})();
var statearr_67111_67124 = state_67100__$1;
(statearr_67111_67124[(2)] = inst_67080);

(statearr_67111_67124[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67112 = [null,null,null,null,null,null,null,null];
(statearr_67112[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67112[(1)] = (1));

return statearr_67112;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67100){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67100);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67113){var ex__10801__auto__ = e67113;
var statearr_67114_67125 = state_67100;
(statearr_67114_67125[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67100[(4)]))){
var statearr_67115_67126 = state_67100;
(statearr_67115_67126[(1)] = cljs.core.first((state_67100[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67127 = state_67100;
state_67100 = G__67127;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67100){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67116 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67116[(6)] = c__10835__auto__);

return statearr_67116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq67068){
var G__67069 = cljs.core.first(seq67068);
var seq67068__$1 = cljs.core.next(seq67068);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67069,seq67068__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__67129 = arguments.length;
switch (G__67129) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67174){
var state_val_67175 = (state_67174[(1)]);
if((state_val_67175 === (7))){
var state_67174__$1 = state_67174;
var statearr_67176_67313 = state_67174__$1;
(statearr_67176_67313[(2)] = query_map);

(statearr_67176_67313[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (1))){
var state_67174__$1 = state_67174;
var statearr_67177_67314 = state_67174__$1;
(statearr_67177_67314[(2)] = null);

(statearr_67177_67314[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (4))){
var inst_67130 = (state_67174[(2)]);
var state_67174__$1 = state_67174;
var statearr_67178_67315 = state_67174__$1;
(statearr_67178_67315[(2)] = inst_67130);

(statearr_67178_67315[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (13))){
var inst_67152 = (state_67174[(7)]);
var inst_67156 = (state_67174[(2)]);
var inst_67157 = fluree.db.util.async.throw_err(inst_67156);
var inst_67158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67157,(0),null);
var inst_67159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67157,(1),null);
var inst_67160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67161 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67163 = [inst_67152];
var inst_67164 = (new cljs.core.PersistentVector(null,1,(5),inst_67162,inst_67163,null));
var inst_67165 = ["query",inst_67164,inst_67158];
var inst_67166 = cljs.core.PersistentHashMap.fromArrays(inst_67161,inst_67165);
var inst_67167 = [inst_67166,inst_67159];
var inst_67168 = (new cljs.core.PersistentVector(null,2,(5),inst_67160,inst_67167,null));
var inst_67169 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67168);
var _ = (function (){var statearr_67179 = state_67174;
(statearr_67179[(4)] = cljs.core.rest((state_67174[(4)])));

return statearr_67179;
})();
var state_67174__$1 = (function (){var statearr_67180 = state_67174;
(statearr_67180[(8)] = inst_67169);

return statearr_67180;
})();
var statearr_67181_67316 = state_67174__$1;
(statearr_67181_67316[(2)] = inst_67158);

(statearr_67181_67316[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (6))){
var state_67174__$1 = state_67174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67174__$1,(9),query_map);
} else {
if((state_val_67175 === (3))){
var inst_67172 = (state_67174[(2)]);
var state_67174__$1 = state_67174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67174__$1,inst_67172);
} else {
if((state_val_67175 === (12))){
var inst_67152 = (state_67174[(7)]);
var inst_67152__$1 = (state_67174[(2)]);
var inst_67153 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67154 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_67153,inst_67152__$1);
var state_67174__$1 = (function (){var statearr_67182 = state_67174;
(statearr_67182[(7)] = inst_67152__$1);

return statearr_67182;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67174__$1,(13),inst_67154);
} else {
if((state_val_67175 === (2))){
var _ = (function (){var statearr_67183 = state_67174;
(statearr_67183[(4)] = cljs.core.cons((5),(state_67174[(4)])));

return statearr_67183;
})();
var inst_67139 = fluree.db.util.async.channel_QMARK_(query_map);
var state_67174__$1 = state_67174;
if(inst_67139){
var statearr_67184_67317 = state_67174__$1;
(statearr_67184_67317[(1)] = (6));

} else {
var statearr_67185_67318 = state_67174__$1;
(statearr_67185_67318[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (11))){
var inst_67146 = (state_67174[(9)]);
var state_67174__$1 = state_67174;
var statearr_67187_67319 = state_67174__$1;
(statearr_67187_67319[(2)] = inst_67146);

(statearr_67187_67319[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (9))){
var inst_67142 = (state_67174[(2)]);
var inst_67143 = fluree.db.util.async.throw_err(inst_67142);
var state_67174__$1 = state_67174;
var statearr_67188_67320 = state_67174__$1;
(statearr_67188_67320[(2)] = inst_67143);

(statearr_67188_67320[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (5))){
var _ = (function (){var statearr_67189 = state_67174;
(statearr_67189[(4)] = cljs.core.rest((state_67174[(4)])));

return statearr_67189;
})();
var state_67174__$1 = state_67174;
var ex67186 = (state_67174__$1[(2)]);
var statearr_67190_67321 = state_67174__$1;
(statearr_67190_67321[(5)] = ex67186);


if((ex67186 instanceof Error)){
var statearr_67191_67322 = state_67174__$1;
(statearr_67191_67322[(1)] = (4));

(statearr_67191_67322[(5)] = null);

} else {
throw ex67186;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (10))){
var inst_67146 = (state_67174[(9)]);
var inst_67149 = fluree.db.util.json.parse(inst_67146);
var state_67174__$1 = state_67174;
var statearr_67192_67323 = state_67174__$1;
(statearr_67192_67323[(2)] = inst_67149);

(statearr_67192_67323[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67175 === (8))){
var inst_67146 = (state_67174[(9)]);
var inst_67146__$1 = (state_67174[(2)]);
var inst_67147 = typeof inst_67146__$1 === 'string';
var state_67174__$1 = (function (){var statearr_67193 = state_67174;
(statearr_67193[(9)] = inst_67146__$1);

return statearr_67193;
})();
if(cljs.core.truth_(inst_67147)){
var statearr_67194_67324 = state_67174__$1;
(statearr_67194_67324[(1)] = (10));

} else {
var statearr_67195_67325 = state_67174__$1;
(statearr_67195_67325[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67196 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67196[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67196[(1)] = (1));

return statearr_67196;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67174){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67174);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67197){var ex__10801__auto__ = e67197;
var statearr_67198_67326 = state_67174;
(statearr_67198_67326[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67174[(4)]))){
var statearr_67199_67327 = state_67174;
(statearr_67199_67327[(1)] = cljs.core.first((state_67174[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67328 = state_67174;
state_67174 = G__67328;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67174){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67200 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67200[(6)] = c__10835__auto__);

return statearr_67200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67271){
var state_val_67272 = (state_67271[(1)]);
if((state_val_67272 === (7))){
var state_67271__$1 = state_67271;
var statearr_67273_67329 = state_67271__$1;
(statearr_67273_67329[(2)] = select);

(statearr_67273_67329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (20))){
var inst_67241 = (state_67271[(2)]);
var inst_67242 = fluree.db.util.async.channel_QMARK_(limit);
var state_67271__$1 = (function (){var statearr_67274 = state_67271;
(statearr_67274[(7)] = inst_67241);

return statearr_67274;
})();
if(inst_67242){
var statearr_67275_67330 = state_67271__$1;
(statearr_67275_67330[(1)] = (22));

} else {
var statearr_67276_67331 = state_67271__$1;
(statearr_67276_67331[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (1))){
var state_67271__$1 = state_67271;
var statearr_67277_67332 = state_67271__$1;
(statearr_67277_67332[(2)] = null);

(statearr_67277_67332[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (24))){
var inst_67233 = (state_67271[(8)]);
var inst_67241 = (state_67271[(7)]);
var inst_67217 = (state_67271[(9)]);
var inst_67225 = (state_67271[(10)]);
var inst_67249 = (state_67271[(2)]);
var inst_67250 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67251 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_67250,inst_67217,inst_67225,inst_67233,inst_67241,inst_67249);
var state_67271__$1 = state_67271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67271__$1,(26),inst_67251);
} else {
if((state_val_67272 === (4))){
var inst_67201 = (state_67271[(2)]);
var state_67271__$1 = state_67271;
var statearr_67278_67333 = state_67271__$1;
(statearr_67278_67333[(2)] = inst_67201);

(statearr_67278_67333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (15))){
var state_67271__$1 = state_67271;
var statearr_67279_67334 = state_67271__$1;
(statearr_67279_67334[(2)] = where);

(statearr_67279_67334[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (21))){
var inst_67237 = (state_67271[(2)]);
var inst_67238 = fluree.db.util.async.throw_err(inst_67237);
var state_67271__$1 = state_67271;
var statearr_67280_67335 = state_67271__$1;
(statearr_67280_67335[(2)] = inst_67238);

(statearr_67280_67335[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (13))){
var inst_67221 = (state_67271[(2)]);
var inst_67222 = fluree.db.util.async.throw_err(inst_67221);
var state_67271__$1 = state_67271;
var statearr_67281_67336 = state_67271__$1;
(statearr_67281_67336[(2)] = inst_67222);

(statearr_67281_67336[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (22))){
var state_67271__$1 = state_67271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67271__$1,(25),limit);
} else {
if((state_val_67272 === (6))){
var state_67271__$1 = state_67271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67271__$1,(9),select);
} else {
if((state_val_67272 === (25))){
var inst_67245 = (state_67271[(2)]);
var inst_67246 = fluree.db.util.async.throw_err(inst_67245);
var state_67271__$1 = state_67271;
var statearr_67282_67337 = state_67271__$1;
(statearr_67282_67337[(2)] = inst_67246);

(statearr_67282_67337[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (17))){
var inst_67229 = (state_67271[(2)]);
var inst_67230 = fluree.db.util.async.throw_err(inst_67229);
var state_67271__$1 = state_67271;
var statearr_67283_67338 = state_67271__$1;
(statearr_67283_67338[(2)] = inst_67230);

(statearr_67283_67338[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (3))){
var inst_67269 = (state_67271[(2)]);
var state_67271__$1 = state_67271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67271__$1,inst_67269);
} else {
if((state_val_67272 === (12))){
var inst_67225 = (state_67271[(2)]);
var inst_67226 = fluree.db.util.async.channel_QMARK_(where);
var state_67271__$1 = (function (){var statearr_67284 = state_67271;
(statearr_67284[(10)] = inst_67225);

return statearr_67284;
})();
if(inst_67226){
var statearr_67285_67339 = state_67271__$1;
(statearr_67285_67339[(1)] = (14));

} else {
var statearr_67286_67340 = state_67271__$1;
(statearr_67286_67340[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (2))){
var _ = (function (){var statearr_67287 = state_67271;
(statearr_67287[(4)] = cljs.core.cons((5),(state_67271[(4)])));

return statearr_67287;
})();
var inst_67210 = fluree.db.util.async.channel_QMARK_(select);
var state_67271__$1 = state_67271;
if(inst_67210){
var statearr_67288_67341 = state_67271__$1;
(statearr_67288_67341[(1)] = (6));

} else {
var statearr_67289_67342 = state_67271__$1;
(statearr_67289_67342[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (23))){
var state_67271__$1 = state_67271;
var statearr_67290_67343 = state_67271__$1;
(statearr_67290_67343[(2)] = limit);

(statearr_67290_67343[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (19))){
var state_67271__$1 = state_67271;
var statearr_67291_67344 = state_67271__$1;
(statearr_67291_67344[(2)] = block);

(statearr_67291_67344[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (11))){
var state_67271__$1 = state_67271;
var statearr_67293_67345 = state_67271__$1;
(statearr_67293_67345[(2)] = from);

(statearr_67293_67345[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (9))){
var inst_67213 = (state_67271[(2)]);
var inst_67214 = fluree.db.util.async.throw_err(inst_67213);
var state_67271__$1 = state_67271;
var statearr_67294_67346 = state_67271__$1;
(statearr_67294_67346[(2)] = inst_67214);

(statearr_67294_67346[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (5))){
var _ = (function (){var statearr_67295 = state_67271;
(statearr_67295[(4)] = cljs.core.rest((state_67271[(4)])));

return statearr_67295;
})();
var state_67271__$1 = state_67271;
var ex67292 = (state_67271__$1[(2)]);
var statearr_67296_67347 = state_67271__$1;
(statearr_67296_67347[(5)] = ex67292);


if((ex67292 instanceof Error)){
var statearr_67297_67348 = state_67271__$1;
(statearr_67297_67348[(1)] = (4));

(statearr_67297_67348[(5)] = null);

} else {
throw ex67292;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (14))){
var state_67271__$1 = state_67271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67271__$1,(17),where);
} else {
if((state_val_67272 === (26))){
var inst_67233 = (state_67271[(8)]);
var inst_67241 = (state_67271[(7)]);
var inst_67217 = (state_67271[(9)]);
var inst_67225 = (state_67271[(10)]);
var inst_67253 = (state_67271[(2)]);
var inst_67254 = fluree.db.util.async.throw_err(inst_67253);
var inst_67255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67254,(0),null);
var inst_67256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67254,(1),null);
var inst_67257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67258 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67260 = [inst_67217,inst_67225,inst_67233,inst_67241];
var inst_67261 = (new cljs.core.PersistentVector(null,4,(5),inst_67259,inst_67260,null));
var inst_67262 = ["query",inst_67261,inst_67255];
var inst_67263 = cljs.core.PersistentHashMap.fromArrays(inst_67258,inst_67262);
var inst_67264 = [inst_67263,inst_67256];
var inst_67265 = (new cljs.core.PersistentVector(null,2,(5),inst_67257,inst_67264,null));
var inst_67266 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67265);
var _ = (function (){var statearr_67298 = state_67271;
(statearr_67298[(4)] = cljs.core.rest((state_67271[(4)])));

return statearr_67298;
})();
var state_67271__$1 = (function (){var statearr_67299 = state_67271;
(statearr_67299[(11)] = inst_67266);

return statearr_67299;
})();
var statearr_67300_67349 = state_67271__$1;
(statearr_67300_67349[(2)] = inst_67255);

(statearr_67300_67349[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (16))){
var inst_67233 = (state_67271[(2)]);
var inst_67234 = fluree.db.util.async.channel_QMARK_(block);
var state_67271__$1 = (function (){var statearr_67301 = state_67271;
(statearr_67301[(8)] = inst_67233);

return statearr_67301;
})();
if(inst_67234){
var statearr_67302_67350 = state_67271__$1;
(statearr_67302_67350[(1)] = (18));

} else {
var statearr_67303_67351 = state_67271__$1;
(statearr_67303_67351[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67272 === (10))){
var state_67271__$1 = state_67271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67271__$1,(13),from);
} else {
if((state_val_67272 === (18))){
var state_67271__$1 = state_67271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67271__$1,(21),block);
} else {
if((state_val_67272 === (8))){
var inst_67217 = (state_67271[(2)]);
var inst_67218 = fluree.db.util.async.channel_QMARK_(from);
var state_67271__$1 = (function (){var statearr_67304 = state_67271;
(statearr_67304[(9)] = inst_67217);

return statearr_67304;
})();
if(inst_67218){
var statearr_67305_67352 = state_67271__$1;
(statearr_67305_67352[(1)] = (10));

} else {
var statearr_67306_67353 = state_67271__$1;
(statearr_67306_67353[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67307 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67307[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67307[(1)] = (1));

return statearr_67307;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67271){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67271);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67308){var ex__10801__auto__ = e67308;
var statearr_67309_67354 = state_67271;
(statearr_67309_67354[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67271[(4)]))){
var statearr_67310_67355 = state_67271;
(statearr_67310_67355[(1)] = cljs.core.first((state_67271[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67356 = state_67271;
state_67271 = G__67356;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67271){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67311 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67311[(6)] = c__10835__auto__);

return statearr_67311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67412){
var state_val_67413 = (state_67412[(1)]);
if((state_val_67413 === (7))){
var state_67412__$1 = state_67412;
var statearr_67414_67445 = state_67412__$1;
(statearr_67414_67445[(2)] = startSubject);

(statearr_67414_67445[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (1))){
var state_67412__$1 = state_67412;
var statearr_67415_67446 = state_67412__$1;
(statearr_67415_67446[(2)] = null);

(statearr_67415_67446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (4))){
var inst_67357 = (state_67412[(2)]);
var state_67412__$1 = state_67412;
var statearr_67416_67447 = state_67412__$1;
(statearr_67416_67447[(2)] = inst_67357);

(statearr_67416_67447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (15))){
var inst_67389 = (state_67412[(2)]);
var inst_67390 = fluree.db.util.async.throw_err(inst_67389);
var inst_67391 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67390,(0),null);
var inst_67392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67390,(1),null);
var inst_67393 = cljs.core.empty_QMARK_(inst_67391);
var state_67412__$1 = (function (){var statearr_67417 = state_67412;
(statearr_67417[(7)] = inst_67392);

return statearr_67417;
})();
if(inst_67393){
var statearr_67418_67448 = state_67412__$1;
(statearr_67418_67448[(1)] = (16));

} else {
var statearr_67419_67449 = state_67412__$1;
(statearr_67419_67449[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (13))){
var inst_67377 = (state_67412[(8)]);
var inst_67385 = (state_67412[(9)]);
var inst_67373 = (state_67412[(10)]);
var inst_67385__$1 = (state_67412[(2)]);
var inst_67386 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67387 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_67386,inst_67373,inst_67377,inst_67385__$1);
var state_67412__$1 = (function (){var statearr_67420 = state_67412;
(statearr_67420[(9)] = inst_67385__$1);

return statearr_67420;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67412__$1,(15),inst_67387);
} else {
if((state_val_67413 === (6))){
var state_67412__$1 = state_67412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67412__$1,(9),startSubject);
} else {
if((state_val_67413 === (17))){
var state_67412__$1 = state_67412;
var statearr_67421_67450 = state_67412__$1;
(statearr_67421_67450[(2)] = true);

(statearr_67421_67450[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (3))){
var inst_67410 = (state_67412[(2)]);
var state_67412__$1 = state_67412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67412__$1,inst_67410);
} else {
if((state_val_67413 === (12))){
var state_67412__$1 = state_67412;
var statearr_67422_67451 = state_67412__$1;
(statearr_67422_67451[(2)] = endSubject);

(statearr_67422_67451[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (2))){
var _ = (function (){var statearr_67423 = state_67412;
(statearr_67423[(4)] = cljs.core.cons((5),(state_67412[(4)])));

return statearr_67423;
})();
var inst_67366 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_67412__$1 = state_67412;
if(inst_67366){
var statearr_67424_67452 = state_67412__$1;
(statearr_67424_67452[(1)] = (6));

} else {
var statearr_67425_67453 = state_67412__$1;
(statearr_67425_67453[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (11))){
var state_67412__$1 = state_67412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67412__$1,(14),endSubject);
} else {
if((state_val_67413 === (9))){
var inst_67369 = (state_67412[(2)]);
var inst_67370 = fluree.db.util.async.throw_err(inst_67369);
var state_67412__$1 = state_67412;
var statearr_67427_67454 = state_67412__$1;
(statearr_67427_67454[(2)] = inst_67370);

(statearr_67427_67454[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (5))){
var _ = (function (){var statearr_67428 = state_67412;
(statearr_67428[(4)] = cljs.core.rest((state_67412[(4)])));

return statearr_67428;
})();
var state_67412__$1 = state_67412;
var ex67426 = (state_67412__$1[(2)]);
var statearr_67429_67455 = state_67412__$1;
(statearr_67429_67455[(5)] = ex67426);


if((ex67426 instanceof Error)){
var statearr_67430_67456 = state_67412__$1;
(statearr_67430_67456[(1)] = (4));

(statearr_67430_67456[(5)] = null);

} else {
throw ex67426;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (14))){
var inst_67381 = (state_67412[(2)]);
var inst_67382 = fluree.db.util.async.throw_err(inst_67381);
var state_67412__$1 = state_67412;
var statearr_67431_67457 = state_67412__$1;
(statearr_67431_67457[(2)] = inst_67382);

(statearr_67431_67457[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (16))){
var state_67412__$1 = state_67412;
var statearr_67432_67458 = state_67412__$1;
(statearr_67432_67458[(2)] = false);

(statearr_67432_67458[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (10))){
var inst_67376 = (state_67412[(2)]);
var inst_67377 = fluree.db.util.async.throw_err(inst_67376);
var inst_67378 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_67412__$1 = (function (){var statearr_67433 = state_67412;
(statearr_67433[(8)] = inst_67377);

return statearr_67433;
})();
if(inst_67378){
var statearr_67434_67459 = state_67412__$1;
(statearr_67434_67459[(1)] = (11));

} else {
var statearr_67435_67460 = state_67412__$1;
(statearr_67435_67460[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (18))){
var inst_67377 = (state_67412[(8)]);
var inst_67385 = (state_67412[(9)]);
var inst_67373 = (state_67412[(10)]);
var inst_67392 = (state_67412[(7)]);
var inst_67397 = (state_67412[(2)]);
var inst_67398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67399 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67401 = [inst_67373,inst_67377,inst_67385];
var inst_67402 = (new cljs.core.PersistentVector(null,3,(5),inst_67400,inst_67401,null));
var inst_67403 = ["relationship?",inst_67402,inst_67397];
var inst_67404 = cljs.core.PersistentHashMap.fromArrays(inst_67399,inst_67403);
var inst_67405 = [inst_67404,inst_67392];
var inst_67406 = (new cljs.core.PersistentVector(null,2,(5),inst_67398,inst_67405,null));
var inst_67407 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67406);
var _ = (function (){var statearr_67436 = state_67412;
(statearr_67436[(4)] = cljs.core.rest((state_67412[(4)])));

return statearr_67436;
})();
var state_67412__$1 = (function (){var statearr_67437 = state_67412;
(statearr_67437[(11)] = inst_67407);

return statearr_67437;
})();
var statearr_67438_67461 = state_67412__$1;
(statearr_67438_67461[(2)] = inst_67397);

(statearr_67438_67461[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67413 === (8))){
var inst_67373 = (state_67412[(2)]);
var inst_67374 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_67412__$1 = (function (){var statearr_67439 = state_67412;
(statearr_67439[(10)] = inst_67373);

return statearr_67439;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67412__$1,(10),inst_67374);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto____0 = (function (){
var statearr_67440 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67440[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto__);

(statearr_67440[(1)] = (1));

return statearr_67440;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto____1 = (function (state_67412){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67412);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67441){var ex__10801__auto__ = e67441;
var statearr_67442_67462 = state_67412;
(statearr_67442_67462[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67412[(4)]))){
var statearr_67443_67463 = state_67412;
(statearr_67443_67463[(1)] = cljs.core.first((state_67412[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67464 = state_67412;
state_67412 = G__67464;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto__ = function(state_67412){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto____1.call(this,state_67412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67444 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67444[(6)] = c__10835__auto__);

return statearr_67444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67501){
var state_val_67502 = (state_67501[(1)]);
if((state_val_67502 === (7))){
var state_67501__$1 = state_67501;
var statearr_67503_67523 = state_67501__$1;
(statearr_67503_67523[(2)] = pred_name);

(statearr_67503_67523[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67502 === (1))){
var state_67501__$1 = state_67501;
var statearr_67504_67524 = state_67501__$1;
(statearr_67504_67524[(2)] = null);

(statearr_67504_67524[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67502 === (4))){
var inst_67465 = (state_67501[(2)]);
var state_67501__$1 = state_67501;
var statearr_67505_67525 = state_67501__$1;
(statearr_67505_67525[(2)] = inst_67465);

(statearr_67505_67525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67502 === (6))){
var state_67501__$1 = state_67501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67501__$1,(9),pred_name);
} else {
if((state_val_67502 === (3))){
var inst_67499 = (state_67501[(2)]);
var state_67501__$1 = state_67501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67501__$1,inst_67499);
} else {
if((state_val_67502 === (2))){
var _ = (function (){var statearr_67507 = state_67501;
(statearr_67507[(4)] = cljs.core.cons((5),(state_67501[(4)])));

return statearr_67507;
})();
var inst_67474 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_67501__$1 = state_67501;
if(inst_67474){
var statearr_67508_67526 = state_67501__$1;
(statearr_67508_67526[(1)] = (6));

} else {
var statearr_67509_67527 = state_67501__$1;
(statearr_67509_67527[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67502 === (9))){
var inst_67477 = (state_67501[(2)]);
var inst_67478 = fluree.db.util.async.throw_err(inst_67477);
var state_67501__$1 = state_67501;
var statearr_67510_67528 = state_67501__$1;
(statearr_67510_67528[(2)] = inst_67478);

(statearr_67510_67528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67502 === (5))){
var _ = (function (){var statearr_67511 = state_67501;
(statearr_67511[(4)] = cljs.core.rest((state_67501[(4)])));

return statearr_67511;
})();
var state_67501__$1 = state_67501;
var ex67506 = (state_67501__$1[(2)]);
var statearr_67512_67529 = state_67501__$1;
(statearr_67512_67529[(5)] = ex67506);


if((ex67506 instanceof Error)){
var statearr_67513_67530 = state_67501__$1;
(statearr_67513_67530[(1)] = (4));

(statearr_67513_67530[(5)] = null);

} else {
throw ex67506;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67502 === (10))){
var inst_67481 = (state_67501[(7)]);
var inst_67485 = (state_67501[(2)]);
var inst_67486 = fluree.db.util.async.throw_err(inst_67485);
var inst_67487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67486,(0),null);
var inst_67488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67486,(1),null);
var inst_67489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67490 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67491 = ["max-pred-val",inst_67481,inst_67487];
var inst_67492 = cljs.core.PersistentHashMap.fromArrays(inst_67490,inst_67491);
var inst_67493 = (inst_67488 + (10));
var inst_67494 = [inst_67492,inst_67493];
var inst_67495 = (new cljs.core.PersistentVector(null,2,(5),inst_67489,inst_67494,null));
var inst_67496 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67495);
var _ = (function (){var statearr_67514 = state_67501;
(statearr_67514[(4)] = cljs.core.rest((state_67501[(4)])));

return statearr_67514;
})();
var state_67501__$1 = (function (){var statearr_67515 = state_67501;
(statearr_67515[(8)] = inst_67496);

return statearr_67515;
})();
var statearr_67516_67531 = state_67501__$1;
(statearr_67516_67531[(2)] = inst_67487);

(statearr_67516_67531[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67502 === (8))){
var inst_67481 = (state_67501[(7)]);
var inst_67481__$1 = (state_67501[(2)]);
var inst_67482 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67483 = fluree.db.dbfunctions.internal.max_pred_val(inst_67482,inst_67481__$1,null);
var state_67501__$1 = (function (){var statearr_67517 = state_67501;
(statearr_67517[(7)] = inst_67481__$1);

return statearr_67517;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67501__$1,(10),inst_67483);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto____0 = (function (){
var statearr_67518 = [null,null,null,null,null,null,null,null,null];
(statearr_67518[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto__);

(statearr_67518[(1)] = (1));

return statearr_67518;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto____1 = (function (state_67501){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67501);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67519){var ex__10801__auto__ = e67519;
var statearr_67520_67532 = state_67501;
(statearr_67520_67532[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67501[(4)]))){
var statearr_67521_67533 = state_67501;
(statearr_67521_67533[(1)] = cljs.core.first((state_67501[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67534 = state_67501;
state_67501 = G__67534;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto__ = function(state_67501){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto____1.call(this,state_67501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67522 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67522[(6)] = c__10835__auto__);

return statearr_67522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67561){
var state_val_67562 = (state_67561[(1)]);
if((state_val_67562 === (7))){
var state_67561__$1 = state_67561;
var statearr_67563_67582 = state_67561__$1;
(statearr_67563_67582[(2)] = n);

(statearr_67563_67582[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67562 === (1))){
var state_67561__$1 = state_67561;
var statearr_67564_67583 = state_67561__$1;
(statearr_67564_67583[(2)] = null);

(statearr_67564_67583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67562 === (4))){
var inst_67535 = (state_67561[(2)]);
var state_67561__$1 = state_67561;
var statearr_67565_67584 = state_67561__$1;
(statearr_67565_67584[(2)] = inst_67535);

(statearr_67565_67584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67562 === (6))){
var state_67561__$1 = state_67561;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67561__$1,(9),n);
} else {
if((state_val_67562 === (3))){
var inst_67559 = (state_67561[(2)]);
var state_67561__$1 = state_67561;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67561__$1,inst_67559);
} else {
if((state_val_67562 === (2))){
var _ = (function (){var statearr_67567 = state_67561;
(statearr_67567[(4)] = cljs.core.cons((5),(state_67561[(4)])));

return statearr_67567;
})();
var inst_67541 = fluree.db.util.async.channel_QMARK_(n);
var state_67561__$1 = state_67561;
if(inst_67541){
var statearr_67568_67585 = state_67561__$1;
(statearr_67568_67585[(1)] = (6));

} else {
var statearr_67569_67586 = state_67561__$1;
(statearr_67569_67586[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67562 === (9))){
var inst_67544 = (state_67561[(2)]);
var inst_67545 = fluree.db.util.async.throw_err(inst_67544);
var state_67561__$1 = state_67561;
var statearr_67570_67587 = state_67561__$1;
(statearr_67570_67587[(2)] = inst_67545);

(statearr_67570_67587[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67562 === (5))){
var _ = (function (){var statearr_67571 = state_67561;
(statearr_67571[(4)] = cljs.core.rest((state_67561[(4)])));

return statearr_67571;
})();
var state_67561__$1 = state_67561;
var ex67566 = (state_67561__$1[(2)]);
var statearr_67572_67588 = state_67561__$1;
(statearr_67572_67588[(5)] = ex67566);


if((ex67566 instanceof Error)){
var statearr_67573_67589 = state_67561__$1;
(statearr_67573_67589[(1)] = (4));

(statearr_67573_67589[(5)] = null);

} else {
throw ex67566;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67562 === (8))){
var inst_67548 = (state_67561[(2)]);
var inst_67549 = fluree.db.dbfunctions.internal.inc(inst_67548);
var inst_67550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67551 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67552 = ["inc",inst_67548,inst_67549];
var inst_67553 = cljs.core.PersistentHashMap.fromArrays(inst_67551,inst_67552);
var inst_67554 = [inst_67553,(10)];
var inst_67555 = (new cljs.core.PersistentVector(null,2,(5),inst_67550,inst_67554,null));
var inst_67556 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67555);
var _ = (function (){var statearr_67574 = state_67561;
(statearr_67574[(4)] = cljs.core.rest((state_67561[(4)])));

return statearr_67574;
})();
var state_67561__$1 = (function (){var statearr_67575 = state_67561;
(statearr_67575[(7)] = inst_67556);

return statearr_67575;
})();
var statearr_67576_67590 = state_67561__$1;
(statearr_67576_67590[(2)] = inst_67549);

(statearr_67576_67590[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto____0 = (function (){
var statearr_67577 = [null,null,null,null,null,null,null,null];
(statearr_67577[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto__);

(statearr_67577[(1)] = (1));

return statearr_67577;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto____1 = (function (state_67561){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67561);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67578){var ex__10801__auto__ = e67578;
var statearr_67579_67591 = state_67561;
(statearr_67579_67591[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67561[(4)]))){
var statearr_67580_67592 = state_67561;
(statearr_67580_67592[(1)] = cljs.core.first((state_67561[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67593 = state_67561;
state_67561 = G__67593;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto__ = function(state_67561){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto____1.call(this,state_67561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67581 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67581[(6)] = c__10835__auto__);

return statearr_67581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67620){
var state_val_67621 = (state_67620[(1)]);
if((state_val_67621 === (7))){
var state_67620__$1 = state_67620;
var statearr_67622_67641 = state_67620__$1;
(statearr_67622_67641[(2)] = n);

(statearr_67622_67641[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67621 === (1))){
var state_67620__$1 = state_67620;
var statearr_67623_67642 = state_67620__$1;
(statearr_67623_67642[(2)] = null);

(statearr_67623_67642[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67621 === (4))){
var inst_67594 = (state_67620[(2)]);
var state_67620__$1 = state_67620;
var statearr_67624_67643 = state_67620__$1;
(statearr_67624_67643[(2)] = inst_67594);

(statearr_67624_67643[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67621 === (6))){
var state_67620__$1 = state_67620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67620__$1,(9),n);
} else {
if((state_val_67621 === (3))){
var inst_67618 = (state_67620[(2)]);
var state_67620__$1 = state_67620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67620__$1,inst_67618);
} else {
if((state_val_67621 === (2))){
var _ = (function (){var statearr_67626 = state_67620;
(statearr_67626[(4)] = cljs.core.cons((5),(state_67620[(4)])));

return statearr_67626;
})();
var inst_67600 = fluree.db.util.async.channel_QMARK_(n);
var state_67620__$1 = state_67620;
if(inst_67600){
var statearr_67627_67644 = state_67620__$1;
(statearr_67627_67644[(1)] = (6));

} else {
var statearr_67628_67645 = state_67620__$1;
(statearr_67628_67645[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67621 === (9))){
var inst_67603 = (state_67620[(2)]);
var inst_67604 = fluree.db.util.async.throw_err(inst_67603);
var state_67620__$1 = state_67620;
var statearr_67629_67646 = state_67620__$1;
(statearr_67629_67646[(2)] = inst_67604);

(statearr_67629_67646[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67621 === (5))){
var _ = (function (){var statearr_67630 = state_67620;
(statearr_67630[(4)] = cljs.core.rest((state_67620[(4)])));

return statearr_67630;
})();
var state_67620__$1 = state_67620;
var ex67625 = (state_67620__$1[(2)]);
var statearr_67631_67647 = state_67620__$1;
(statearr_67631_67647[(5)] = ex67625);


if((ex67625 instanceof Error)){
var statearr_67632_67648 = state_67620__$1;
(statearr_67632_67648[(1)] = (4));

(statearr_67632_67648[(5)] = null);

} else {
throw ex67625;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67621 === (8))){
var inst_67607 = (state_67620[(2)]);
var inst_67608 = fluree.db.dbfunctions.internal.dec(inst_67607);
var inst_67609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67610 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67611 = ["dec",inst_67607,inst_67608];
var inst_67612 = cljs.core.PersistentHashMap.fromArrays(inst_67610,inst_67611);
var inst_67613 = [inst_67612,(10)];
var inst_67614 = (new cljs.core.PersistentVector(null,2,(5),inst_67609,inst_67613,null));
var inst_67615 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67614);
var _ = (function (){var statearr_67633 = state_67620;
(statearr_67633[(4)] = cljs.core.rest((state_67620[(4)])));

return statearr_67633;
})();
var state_67620__$1 = (function (){var statearr_67634 = state_67620;
(statearr_67634[(7)] = inst_67615);

return statearr_67634;
})();
var statearr_67635_67649 = state_67620__$1;
(statearr_67635_67649[(2)] = inst_67608);

(statearr_67635_67649[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto____0 = (function (){
var statearr_67636 = [null,null,null,null,null,null,null,null];
(statearr_67636[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto__);

(statearr_67636[(1)] = (1));

return statearr_67636;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto____1 = (function (state_67620){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67620);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67637){var ex__10801__auto__ = e67637;
var statearr_67638_67650 = state_67620;
(statearr_67638_67650[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67620[(4)]))){
var statearr_67639_67651 = state_67620;
(statearr_67639_67651[(1)] = cljs.core.first((state_67620[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67652 = state_67620;
state_67620 = G__67652;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto__ = function(state_67620){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto____1.call(this,state_67620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67640 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67640[(6)] = c__10835__auto__);

return statearr_67640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___67702 = arguments.length;
var i__4830__auto___67703 = (0);
while(true){
if((i__4830__auto___67703 < len__4829__auto___67702)){
args__4835__auto__.push((arguments[i__4830__auto___67703]));

var G__67704 = (i__4830__auto___67703 + (1));
i__4830__auto___67703 = G__67704;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67685){
var state_val_67686 = (state_67685[(1)]);
if((state_val_67686 === (1))){
var state_67685__$1 = state_67685;
var statearr_67687_67705 = state_67685__$1;
(statearr_67687_67705[(2)] = null);

(statearr_67687_67705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67686 === (2))){
var _ = (function (){var statearr_67688 = state_67685;
(statearr_67688[(4)] = cljs.core.cons((5),(state_67685[(4)])));

return statearr_67688;
})();
var inst_67661 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67685__$1 = state_67685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67685__$1,(6),inst_67661);
} else {
if((state_val_67686 === (3))){
var inst_67683 = (state_67685[(2)]);
var state_67685__$1 = state_67685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67685__$1,inst_67683);
} else {
if((state_val_67686 === (4))){
var inst_67655 = (state_67685[(2)]);
var state_67685__$1 = state_67685;
var statearr_67690_67706 = state_67685__$1;
(statearr_67690_67706[(2)] = inst_67655);

(statearr_67690_67706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67686 === (5))){
var _ = (function (){var statearr_67691 = state_67685;
(statearr_67691[(4)] = cljs.core.rest((state_67685[(4)])));

return statearr_67691;
})();
var state_67685__$1 = state_67685;
var ex67689 = (state_67685__$1[(2)]);
var statearr_67692_67707 = state_67685__$1;
(statearr_67692_67707[(5)] = ex67689);


if((ex67689 instanceof Error)){
var statearr_67693_67708 = state_67685__$1;
(statearr_67693_67708[(1)] = (4));

(statearr_67693_67708[(5)] = null);

} else {
throw ex67689;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67686 === (6))){
var inst_67663 = (state_67685[(2)]);
var inst_67664 = fluree.db.util.async.throw_err(inst_67663);
var inst_67665 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_67664);
var inst_67666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67667 = [inst_67664];
var inst_67668 = (new cljs.core.PersistentVector(null,1,(5),inst_67666,inst_67667,null));
var inst_67669 = cljs.core.count(inst_67668);
var inst_67670 = ((9) + inst_67669);
var inst_67671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67672 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67674 = [inst_67664];
var inst_67675 = (new cljs.core.PersistentVector(null,1,(5),inst_67673,inst_67674,null));
var inst_67676 = ["+",inst_67675,inst_67665];
var inst_67677 = cljs.core.PersistentHashMap.fromArrays(inst_67672,inst_67676);
var inst_67678 = [inst_67677,inst_67670];
var inst_67679 = (new cljs.core.PersistentVector(null,2,(5),inst_67671,inst_67678,null));
var inst_67680 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67679);
var _ = (function (){var statearr_67694 = state_67685;
(statearr_67694[(4)] = cljs.core.rest((state_67685[(4)])));

return statearr_67694;
})();
var state_67685__$1 = (function (){var statearr_67695 = state_67685;
(statearr_67695[(7)] = inst_67680);

return statearr_67695;
})();
var statearr_67696_67709 = state_67685__$1;
(statearr_67696_67709[(2)] = inst_67665);

(statearr_67696_67709[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67697 = [null,null,null,null,null,null,null,null];
(statearr_67697[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67697[(1)] = (1));

return statearr_67697;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67685){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67685);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67698){var ex__10801__auto__ = e67698;
var statearr_67699_67710 = state_67685;
(statearr_67699_67710[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67685[(4)]))){
var statearr_67700_67711 = state_67685;
(statearr_67700_67711[(1)] = cljs.core.first((state_67685[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67712 = state_67685;
state_67685 = G__67712;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67685){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67701 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67701[(6)] = c__10835__auto__);

return statearr_67701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq67653){
var G__67654 = cljs.core.first(seq67653);
var seq67653__$1 = cljs.core.next(seq67653);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67654,seq67653__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___67762 = arguments.length;
var i__4830__auto___67763 = (0);
while(true){
if((i__4830__auto___67763 < len__4829__auto___67762)){
args__4835__auto__.push((arguments[i__4830__auto___67763]));

var G__67764 = (i__4830__auto___67763 + (1));
i__4830__auto___67763 = G__67764;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67745){
var state_val_67746 = (state_67745[(1)]);
if((state_val_67746 === (1))){
var state_67745__$1 = state_67745;
var statearr_67747_67765 = state_67745__$1;
(statearr_67747_67765[(2)] = null);

(statearr_67747_67765[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67746 === (2))){
var _ = (function (){var statearr_67748 = state_67745;
(statearr_67748[(4)] = cljs.core.cons((5),(state_67745[(4)])));

return statearr_67748;
})();
var inst_67721 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67745__$1 = state_67745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67745__$1,(6),inst_67721);
} else {
if((state_val_67746 === (3))){
var inst_67743 = (state_67745[(2)]);
var state_67745__$1 = state_67745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67745__$1,inst_67743);
} else {
if((state_val_67746 === (4))){
var inst_67715 = (state_67745[(2)]);
var state_67745__$1 = state_67745;
var statearr_67750_67766 = state_67745__$1;
(statearr_67750_67766[(2)] = inst_67715);

(statearr_67750_67766[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67746 === (5))){
var _ = (function (){var statearr_67751 = state_67745;
(statearr_67751[(4)] = cljs.core.rest((state_67745[(4)])));

return statearr_67751;
})();
var state_67745__$1 = state_67745;
var ex67749 = (state_67745__$1[(2)]);
var statearr_67752_67767 = state_67745__$1;
(statearr_67752_67767[(5)] = ex67749);


if((ex67749 instanceof Error)){
var statearr_67753_67768 = state_67745__$1;
(statearr_67753_67768[(1)] = (4));

(statearr_67753_67768[(5)] = null);

} else {
throw ex67749;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67746 === (6))){
var inst_67723 = (state_67745[(2)]);
var inst_67724 = fluree.db.util.async.throw_err(inst_67723);
var inst_67725 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_67724);
var inst_67726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67727 = [inst_67724];
var inst_67728 = (new cljs.core.PersistentVector(null,1,(5),inst_67726,inst_67727,null));
var inst_67729 = cljs.core.count(inst_67728);
var inst_67730 = ((9) + inst_67729);
var inst_67731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67732 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67734 = [inst_67724];
var inst_67735 = (new cljs.core.PersistentVector(null,1,(5),inst_67733,inst_67734,null));
var inst_67736 = ["-",inst_67735,inst_67725];
var inst_67737 = cljs.core.PersistentHashMap.fromArrays(inst_67732,inst_67736);
var inst_67738 = [inst_67737,inst_67730];
var inst_67739 = (new cljs.core.PersistentVector(null,2,(5),inst_67731,inst_67738,null));
var inst_67740 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67739);
var _ = (function (){var statearr_67754 = state_67745;
(statearr_67754[(4)] = cljs.core.rest((state_67745[(4)])));

return statearr_67754;
})();
var state_67745__$1 = (function (){var statearr_67755 = state_67745;
(statearr_67755[(7)] = inst_67740);

return statearr_67755;
})();
var statearr_67756_67769 = state_67745__$1;
(statearr_67756_67769[(2)] = inst_67725);

(statearr_67756_67769[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67757 = [null,null,null,null,null,null,null,null];
(statearr_67757[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67757[(1)] = (1));

return statearr_67757;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67745){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67745);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67758){var ex__10801__auto__ = e67758;
var statearr_67759_67770 = state_67745;
(statearr_67759_67770[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67745[(4)]))){
var statearr_67760_67771 = state_67745;
(statearr_67760_67771[(1)] = cljs.core.first((state_67745[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67772 = state_67745;
state_67745 = G__67772;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67745){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67761 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67761[(6)] = c__10835__auto__);

return statearr_67761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq67713){
var G__67714 = cljs.core.first(seq67713);
var seq67713__$1 = cljs.core.next(seq67713);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67714,seq67713__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___67822 = arguments.length;
var i__4830__auto___67823 = (0);
while(true){
if((i__4830__auto___67823 < len__4829__auto___67822)){
args__4835__auto__.push((arguments[i__4830__auto___67823]));

var G__67824 = (i__4830__auto___67823 + (1));
i__4830__auto___67823 = G__67824;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67805){
var state_val_67806 = (state_67805[(1)]);
if((state_val_67806 === (1))){
var state_67805__$1 = state_67805;
var statearr_67807_67825 = state_67805__$1;
(statearr_67807_67825[(2)] = null);

(statearr_67807_67825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67806 === (2))){
var _ = (function (){var statearr_67808 = state_67805;
(statearr_67808[(4)] = cljs.core.cons((5),(state_67805[(4)])));

return statearr_67808;
})();
var inst_67781 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67805__$1 = state_67805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67805__$1,(6),inst_67781);
} else {
if((state_val_67806 === (3))){
var inst_67803 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67805__$1,inst_67803);
} else {
if((state_val_67806 === (4))){
var inst_67775 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
var statearr_67810_67826 = state_67805__$1;
(statearr_67810_67826[(2)] = inst_67775);

(statearr_67810_67826[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67806 === (5))){
var _ = (function (){var statearr_67811 = state_67805;
(statearr_67811[(4)] = cljs.core.rest((state_67805[(4)])));

return statearr_67811;
})();
var state_67805__$1 = state_67805;
var ex67809 = (state_67805__$1[(2)]);
var statearr_67812_67827 = state_67805__$1;
(statearr_67812_67827[(5)] = ex67809);


if((ex67809 instanceof Error)){
var statearr_67813_67828 = state_67805__$1;
(statearr_67813_67828[(1)] = (4));

(statearr_67813_67828[(5)] = null);

} else {
throw ex67809;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67806 === (6))){
var inst_67783 = (state_67805[(2)]);
var inst_67784 = fluree.db.util.async.throw_err(inst_67783);
var inst_67785 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_67784);
var inst_67786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67787 = [inst_67784];
var inst_67788 = (new cljs.core.PersistentVector(null,1,(5),inst_67786,inst_67787,null));
var inst_67789 = cljs.core.count(inst_67788);
var inst_67790 = ((9) + inst_67789);
var inst_67791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67792 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67794 = [inst_67784];
var inst_67795 = (new cljs.core.PersistentVector(null,1,(5),inst_67793,inst_67794,null));
var inst_67796 = ["*",inst_67795,inst_67785];
var inst_67797 = cljs.core.PersistentHashMap.fromArrays(inst_67792,inst_67796);
var inst_67798 = [inst_67797,inst_67790];
var inst_67799 = (new cljs.core.PersistentVector(null,2,(5),inst_67791,inst_67798,null));
var inst_67800 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67799);
var _ = (function (){var statearr_67814 = state_67805;
(statearr_67814[(4)] = cljs.core.rest((state_67805[(4)])));

return statearr_67814;
})();
var state_67805__$1 = (function (){var statearr_67815 = state_67805;
(statearr_67815[(7)] = inst_67800);

return statearr_67815;
})();
var statearr_67816_67829 = state_67805__$1;
(statearr_67816_67829[(2)] = inst_67785);

(statearr_67816_67829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67817 = [null,null,null,null,null,null,null,null];
(statearr_67817[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67817[(1)] = (1));

return statearr_67817;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67805){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67805);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67818){var ex__10801__auto__ = e67818;
var statearr_67819_67830 = state_67805;
(statearr_67819_67830[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67805[(4)]))){
var statearr_67820_67831 = state_67805;
(statearr_67820_67831[(1)] = cljs.core.first((state_67805[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67832 = state_67805;
state_67805 = G__67832;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67805){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67821 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67821[(6)] = c__10835__auto__);

return statearr_67821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq67773){
var G__67774 = cljs.core.first(seq67773);
var seq67773__$1 = cljs.core.next(seq67773);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67774,seq67773__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___67882 = arguments.length;
var i__4830__auto___67883 = (0);
while(true){
if((i__4830__auto___67883 < len__4829__auto___67882)){
args__4835__auto__.push((arguments[i__4830__auto___67883]));

var G__67884 = (i__4830__auto___67883 + (1));
i__4830__auto___67883 = G__67884;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67865){
var state_val_67866 = (state_67865[(1)]);
if((state_val_67866 === (1))){
var state_67865__$1 = state_67865;
var statearr_67867_67885 = state_67865__$1;
(statearr_67867_67885[(2)] = null);

(statearr_67867_67885[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67866 === (2))){
var _ = (function (){var statearr_67868 = state_67865;
(statearr_67868[(4)] = cljs.core.cons((5),(state_67865[(4)])));

return statearr_67868;
})();
var inst_67841 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67865__$1 = state_67865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67865__$1,(6),inst_67841);
} else {
if((state_val_67866 === (3))){
var inst_67863 = (state_67865[(2)]);
var state_67865__$1 = state_67865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67865__$1,inst_67863);
} else {
if((state_val_67866 === (4))){
var inst_67835 = (state_67865[(2)]);
var state_67865__$1 = state_67865;
var statearr_67870_67886 = state_67865__$1;
(statearr_67870_67886[(2)] = inst_67835);

(statearr_67870_67886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67866 === (5))){
var _ = (function (){var statearr_67871 = state_67865;
(statearr_67871[(4)] = cljs.core.rest((state_67865[(4)])));

return statearr_67871;
})();
var state_67865__$1 = state_67865;
var ex67869 = (state_67865__$1[(2)]);
var statearr_67872_67887 = state_67865__$1;
(statearr_67872_67887[(5)] = ex67869);


if((ex67869 instanceof Error)){
var statearr_67873_67888 = state_67865__$1;
(statearr_67873_67888[(1)] = (4));

(statearr_67873_67888[(5)] = null);

} else {
throw ex67869;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67866 === (6))){
var inst_67843 = (state_67865[(2)]);
var inst_67844 = fluree.db.util.async.throw_err(inst_67843);
var inst_67845 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_67844);
var inst_67846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67847 = [inst_67844];
var inst_67848 = (new cljs.core.PersistentVector(null,1,(5),inst_67846,inst_67847,null));
var inst_67849 = cljs.core.count(inst_67848);
var inst_67850 = ((9) + inst_67849);
var inst_67851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67852 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67854 = [inst_67844];
var inst_67855 = (new cljs.core.PersistentVector(null,1,(5),inst_67853,inst_67854,null));
var inst_67856 = ["/",inst_67855,inst_67845];
var inst_67857 = cljs.core.PersistentHashMap.fromArrays(inst_67852,inst_67856);
var inst_67858 = [inst_67857,inst_67850];
var inst_67859 = (new cljs.core.PersistentVector(null,2,(5),inst_67851,inst_67858,null));
var inst_67860 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67859);
var _ = (function (){var statearr_67874 = state_67865;
(statearr_67874[(4)] = cljs.core.rest((state_67865[(4)])));

return statearr_67874;
})();
var state_67865__$1 = (function (){var statearr_67875 = state_67865;
(statearr_67875[(7)] = inst_67860);

return statearr_67875;
})();
var statearr_67876_67889 = state_67865__$1;
(statearr_67876_67889[(2)] = inst_67845);

(statearr_67876_67889[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_67877 = [null,null,null,null,null,null,null,null];
(statearr_67877[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_67877[(1)] = (1));

return statearr_67877;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_67865){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67865);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67878){var ex__10801__auto__ = e67878;
var statearr_67879_67890 = state_67865;
(statearr_67879_67890[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67865[(4)]))){
var statearr_67880_67891 = state_67865;
(statearr_67880_67891[(1)] = cljs.core.first((state_67865[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67892 = state_67865;
state_67865 = G__67892;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_67865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_67865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67881 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67881[(6)] = c__10835__auto__);

return statearr_67881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq67833){
var G__67834 = cljs.core.first(seq67833);
var seq67833__$1 = cljs.core.next(seq67833);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67834,seq67833__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_67930){
var state_val_67931 = (state_67930[(1)]);
if((state_val_67931 === (7))){
var state_67930__$1 = state_67930;
var statearr_67932_67956 = state_67930__$1;
(statearr_67932_67956[(2)] = n);

(statearr_67932_67956[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (1))){
var state_67930__$1 = state_67930;
var statearr_67933_67957 = state_67930__$1;
(statearr_67933_67957[(2)] = null);

(statearr_67933_67957[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (4))){
var inst_67893 = (state_67930[(2)]);
var state_67930__$1 = state_67930;
var statearr_67934_67958 = state_67930__$1;
(statearr_67934_67958[(2)] = inst_67893);

(statearr_67934_67958[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (13))){
var inst_67910 = (state_67930[(2)]);
var inst_67911 = fluree.db.util.async.throw_err(inst_67910);
var state_67930__$1 = state_67930;
var statearr_67935_67959 = state_67930__$1;
(statearr_67935_67959[(2)] = inst_67911);

(statearr_67935_67959[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (6))){
var state_67930__$1 = state_67930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67930__$1,(9),n);
} else {
if((state_val_67931 === (3))){
var inst_67928 = (state_67930[(2)]);
var state_67930__$1 = state_67930;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67930__$1,inst_67928);
} else {
if((state_val_67931 === (12))){
var inst_67906 = (state_67930[(7)]);
var inst_67914 = (state_67930[(2)]);
var inst_67915 = fluree.db.dbfunctions.internal.quot(inst_67906,inst_67914);
var inst_67916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67917 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67919 = [inst_67906,inst_67914];
var inst_67920 = (new cljs.core.PersistentVector(null,2,(5),inst_67918,inst_67919,null));
var inst_67921 = ["quot",inst_67920,inst_67915];
var inst_67922 = cljs.core.PersistentHashMap.fromArrays(inst_67917,inst_67921);
var inst_67923 = [inst_67922,(2)];
var inst_67924 = (new cljs.core.PersistentVector(null,2,(5),inst_67916,inst_67923,null));
var inst_67925 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67924);
var _ = (function (){var statearr_67936 = state_67930;
(statearr_67936[(4)] = cljs.core.rest((state_67930[(4)])));

return statearr_67936;
})();
var state_67930__$1 = (function (){var statearr_67937 = state_67930;
(statearr_67937[(8)] = inst_67925);

return statearr_67937;
})();
var statearr_67938_67960 = state_67930__$1;
(statearr_67938_67960[(2)] = inst_67915);

(statearr_67938_67960[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (2))){
var _ = (function (){var statearr_67939 = state_67930;
(statearr_67939[(4)] = cljs.core.cons((5),(state_67930[(4)])));

return statearr_67939;
})();
var inst_67899 = fluree.db.util.async.channel_QMARK_(n);
var state_67930__$1 = state_67930;
if(inst_67899){
var statearr_67940_67961 = state_67930__$1;
(statearr_67940_67961[(1)] = (6));

} else {
var statearr_67941_67962 = state_67930__$1;
(statearr_67941_67962[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (11))){
var state_67930__$1 = state_67930;
var statearr_67943_67963 = state_67930__$1;
(statearr_67943_67963[(2)] = d);

(statearr_67943_67963[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (9))){
var inst_67902 = (state_67930[(2)]);
var inst_67903 = fluree.db.util.async.throw_err(inst_67902);
var state_67930__$1 = state_67930;
var statearr_67944_67964 = state_67930__$1;
(statearr_67944_67964[(2)] = inst_67903);

(statearr_67944_67964[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (5))){
var _ = (function (){var statearr_67945 = state_67930;
(statearr_67945[(4)] = cljs.core.rest((state_67930[(4)])));

return statearr_67945;
})();
var state_67930__$1 = state_67930;
var ex67942 = (state_67930__$1[(2)]);
var statearr_67946_67965 = state_67930__$1;
(statearr_67946_67965[(5)] = ex67942);


if((ex67942 instanceof Error)){
var statearr_67947_67966 = state_67930__$1;
(statearr_67947_67966[(1)] = (4));

(statearr_67947_67966[(5)] = null);

} else {
throw ex67942;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67931 === (10))){
var state_67930__$1 = state_67930;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67930__$1,(13),d);
} else {
if((state_val_67931 === (8))){
var inst_67906 = (state_67930[(2)]);
var inst_67907 = fluree.db.util.async.channel_QMARK_(d);
var state_67930__$1 = (function (){var statearr_67948 = state_67930;
(statearr_67948[(7)] = inst_67906);

return statearr_67948;
})();
if(inst_67907){
var statearr_67949_67967 = state_67930__$1;
(statearr_67949_67967[(1)] = (10));

} else {
var statearr_67950_67968 = state_67930__$1;
(statearr_67950_67968[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto____0 = (function (){
var statearr_67951 = [null,null,null,null,null,null,null,null,null];
(statearr_67951[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto__);

(statearr_67951[(1)] = (1));

return statearr_67951;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto____1 = (function (state_67930){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_67930);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e67952){var ex__10801__auto__ = e67952;
var statearr_67953_67969 = state_67930;
(statearr_67953_67969[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_67930[(4)]))){
var statearr_67954_67970 = state_67930;
(statearr_67954_67970[(1)] = cljs.core.first((state_67930[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__67971 = state_67930;
state_67930 = G__67971;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto__ = function(state_67930){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto____1.call(this,state_67930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_67955 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_67955[(6)] = c__10835__auto__);

return statearr_67955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68009){
var state_val_68010 = (state_68009[(1)]);
if((state_val_68010 === (7))){
var state_68009__$1 = state_68009;
var statearr_68011_68035 = state_68009__$1;
(statearr_68011_68035[(2)] = n);

(statearr_68011_68035[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (1))){
var state_68009__$1 = state_68009;
var statearr_68012_68036 = state_68009__$1;
(statearr_68012_68036[(2)] = null);

(statearr_68012_68036[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (4))){
var inst_67972 = (state_68009[(2)]);
var state_68009__$1 = state_68009;
var statearr_68013_68037 = state_68009__$1;
(statearr_68013_68037[(2)] = inst_67972);

(statearr_68013_68037[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (13))){
var inst_67989 = (state_68009[(2)]);
var inst_67990 = fluree.db.util.async.throw_err(inst_67989);
var state_68009__$1 = state_68009;
var statearr_68014_68038 = state_68009__$1;
(statearr_68014_68038[(2)] = inst_67990);

(statearr_68014_68038[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (6))){
var state_68009__$1 = state_68009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68009__$1,(9),n);
} else {
if((state_val_68010 === (3))){
var inst_68007 = (state_68009[(2)]);
var state_68009__$1 = state_68009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68009__$1,inst_68007);
} else {
if((state_val_68010 === (12))){
var inst_67985 = (state_68009[(7)]);
var inst_67993 = (state_68009[(2)]);
var inst_67994 = fluree.db.dbfunctions.internal.mod(inst_67985,inst_67993);
var inst_67995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67996 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67998 = [inst_67985,inst_67993];
var inst_67999 = (new cljs.core.PersistentVector(null,2,(5),inst_67997,inst_67998,null));
var inst_68000 = ["mod",inst_67999,inst_67994];
var inst_68001 = cljs.core.PersistentHashMap.fromArrays(inst_67996,inst_68000);
var inst_68002 = [inst_68001,(2)];
var inst_68003 = (new cljs.core.PersistentVector(null,2,(5),inst_67995,inst_68002,null));
var inst_68004 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68003);
var _ = (function (){var statearr_68015 = state_68009;
(statearr_68015[(4)] = cljs.core.rest((state_68009[(4)])));

return statearr_68015;
})();
var state_68009__$1 = (function (){var statearr_68016 = state_68009;
(statearr_68016[(8)] = inst_68004);

return statearr_68016;
})();
var statearr_68017_68039 = state_68009__$1;
(statearr_68017_68039[(2)] = inst_67994);

(statearr_68017_68039[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (2))){
var _ = (function (){var statearr_68018 = state_68009;
(statearr_68018[(4)] = cljs.core.cons((5),(state_68009[(4)])));

return statearr_68018;
})();
var inst_67978 = fluree.db.util.async.channel_QMARK_(n);
var state_68009__$1 = state_68009;
if(inst_67978){
var statearr_68019_68040 = state_68009__$1;
(statearr_68019_68040[(1)] = (6));

} else {
var statearr_68020_68041 = state_68009__$1;
(statearr_68020_68041[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (11))){
var state_68009__$1 = state_68009;
var statearr_68022_68042 = state_68009__$1;
(statearr_68022_68042[(2)] = d);

(statearr_68022_68042[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (9))){
var inst_67981 = (state_68009[(2)]);
var inst_67982 = fluree.db.util.async.throw_err(inst_67981);
var state_68009__$1 = state_68009;
var statearr_68023_68043 = state_68009__$1;
(statearr_68023_68043[(2)] = inst_67982);

(statearr_68023_68043[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (5))){
var _ = (function (){var statearr_68024 = state_68009;
(statearr_68024[(4)] = cljs.core.rest((state_68009[(4)])));

return statearr_68024;
})();
var state_68009__$1 = state_68009;
var ex68021 = (state_68009__$1[(2)]);
var statearr_68025_68044 = state_68009__$1;
(statearr_68025_68044[(5)] = ex68021);


if((ex68021 instanceof Error)){
var statearr_68026_68045 = state_68009__$1;
(statearr_68026_68045[(1)] = (4));

(statearr_68026_68045[(5)] = null);

} else {
throw ex68021;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68010 === (10))){
var state_68009__$1 = state_68009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68009__$1,(13),d);
} else {
if((state_val_68010 === (8))){
var inst_67985 = (state_68009[(2)]);
var inst_67986 = fluree.db.util.async.channel_QMARK_(d);
var state_68009__$1 = (function (){var statearr_68027 = state_68009;
(statearr_68027[(7)] = inst_67985);

return statearr_68027;
})();
if(inst_67986){
var statearr_68028_68046 = state_68009__$1;
(statearr_68028_68046[(1)] = (10));

} else {
var statearr_68029_68047 = state_68009__$1;
(statearr_68029_68047[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto____0 = (function (){
var statearr_68030 = [null,null,null,null,null,null,null,null,null];
(statearr_68030[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto__);

(statearr_68030[(1)] = (1));

return statearr_68030;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto____1 = (function (state_68009){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68009);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68031){var ex__10801__auto__ = e68031;
var statearr_68032_68048 = state_68009;
(statearr_68032_68048[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68009[(4)]))){
var statearr_68033_68049 = state_68009;
(statearr_68033_68049[(1)] = cljs.core.first((state_68009[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68050 = state_68009;
state_68009 = G__68050;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto__ = function(state_68009){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto____1.call(this,state_68009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68034 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68034[(6)] = c__10835__auto__);

return statearr_68034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68088){
var state_val_68089 = (state_68088[(1)]);
if((state_val_68089 === (7))){
var state_68088__$1 = state_68088;
var statearr_68090_68114 = state_68088__$1;
(statearr_68090_68114[(2)] = n);

(statearr_68090_68114[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (1))){
var state_68088__$1 = state_68088;
var statearr_68091_68115 = state_68088__$1;
(statearr_68091_68115[(2)] = null);

(statearr_68091_68115[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (4))){
var inst_68051 = (state_68088[(2)]);
var state_68088__$1 = state_68088;
var statearr_68092_68116 = state_68088__$1;
(statearr_68092_68116[(2)] = inst_68051);

(statearr_68092_68116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (13))){
var inst_68068 = (state_68088[(2)]);
var inst_68069 = fluree.db.util.async.throw_err(inst_68068);
var state_68088__$1 = state_68088;
var statearr_68093_68117 = state_68088__$1;
(statearr_68093_68117[(2)] = inst_68069);

(statearr_68093_68117[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (6))){
var state_68088__$1 = state_68088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68088__$1,(9),n);
} else {
if((state_val_68089 === (3))){
var inst_68086 = (state_68088[(2)]);
var state_68088__$1 = state_68088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68088__$1,inst_68086);
} else {
if((state_val_68089 === (12))){
var inst_68064 = (state_68088[(7)]);
var inst_68072 = (state_68088[(2)]);
var inst_68073 = fluree.db.dbfunctions.internal.rem(inst_68064,inst_68072);
var inst_68074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68075 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68077 = [inst_68064,inst_68072];
var inst_68078 = (new cljs.core.PersistentVector(null,2,(5),inst_68076,inst_68077,null));
var inst_68079 = ["rem",inst_68078,inst_68073];
var inst_68080 = cljs.core.PersistentHashMap.fromArrays(inst_68075,inst_68079);
var inst_68081 = [inst_68080,(2)];
var inst_68082 = (new cljs.core.PersistentVector(null,2,(5),inst_68074,inst_68081,null));
var inst_68083 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68082);
var _ = (function (){var statearr_68094 = state_68088;
(statearr_68094[(4)] = cljs.core.rest((state_68088[(4)])));

return statearr_68094;
})();
var state_68088__$1 = (function (){var statearr_68095 = state_68088;
(statearr_68095[(8)] = inst_68083);

return statearr_68095;
})();
var statearr_68096_68118 = state_68088__$1;
(statearr_68096_68118[(2)] = inst_68073);

(statearr_68096_68118[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (2))){
var _ = (function (){var statearr_68097 = state_68088;
(statearr_68097[(4)] = cljs.core.cons((5),(state_68088[(4)])));

return statearr_68097;
})();
var inst_68057 = fluree.db.util.async.channel_QMARK_(n);
var state_68088__$1 = state_68088;
if(inst_68057){
var statearr_68098_68119 = state_68088__$1;
(statearr_68098_68119[(1)] = (6));

} else {
var statearr_68099_68120 = state_68088__$1;
(statearr_68099_68120[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (11))){
var state_68088__$1 = state_68088;
var statearr_68101_68121 = state_68088__$1;
(statearr_68101_68121[(2)] = d);

(statearr_68101_68121[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (9))){
var inst_68060 = (state_68088[(2)]);
var inst_68061 = fluree.db.util.async.throw_err(inst_68060);
var state_68088__$1 = state_68088;
var statearr_68102_68122 = state_68088__$1;
(statearr_68102_68122[(2)] = inst_68061);

(statearr_68102_68122[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (5))){
var _ = (function (){var statearr_68103 = state_68088;
(statearr_68103[(4)] = cljs.core.rest((state_68088[(4)])));

return statearr_68103;
})();
var state_68088__$1 = state_68088;
var ex68100 = (state_68088__$1[(2)]);
var statearr_68104_68123 = state_68088__$1;
(statearr_68104_68123[(5)] = ex68100);


if((ex68100 instanceof Error)){
var statearr_68105_68124 = state_68088__$1;
(statearr_68105_68124[(1)] = (4));

(statearr_68105_68124[(5)] = null);

} else {
throw ex68100;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68089 === (10))){
var state_68088__$1 = state_68088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68088__$1,(13),d);
} else {
if((state_val_68089 === (8))){
var inst_68064 = (state_68088[(2)]);
var inst_68065 = fluree.db.util.async.channel_QMARK_(d);
var state_68088__$1 = (function (){var statearr_68106 = state_68088;
(statearr_68106[(7)] = inst_68064);

return statearr_68106;
})();
if(inst_68065){
var statearr_68107_68125 = state_68088__$1;
(statearr_68107_68125[(1)] = (10));

} else {
var statearr_68108_68126 = state_68088__$1;
(statearr_68108_68126[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto____0 = (function (){
var statearr_68109 = [null,null,null,null,null,null,null,null,null];
(statearr_68109[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto__);

(statearr_68109[(1)] = (1));

return statearr_68109;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto____1 = (function (state_68088){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68088);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68110){var ex__10801__auto__ = e68110;
var statearr_68111_68127 = state_68088;
(statearr_68111_68127[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68088[(4)]))){
var statearr_68112_68128 = state_68088;
(statearr_68112_68128[(1)] = cljs.core.first((state_68088[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68129 = state_68088;
state_68088 = G__68129;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto__ = function(state_68088){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto____1.call(this,state_68088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68113 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68113[(6)] = c__10835__auto__);

return statearr_68113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68156){
var state_val_68157 = (state_68156[(1)]);
if((state_val_68157 === (7))){
var state_68156__$1 = state_68156;
var statearr_68158_68177 = state_68156__$1;
(statearr_68158_68177[(2)] = x);

(statearr_68158_68177[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68157 === (1))){
var state_68156__$1 = state_68156;
var statearr_68159_68178 = state_68156__$1;
(statearr_68159_68178[(2)] = null);

(statearr_68159_68178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68157 === (4))){
var inst_68130 = (state_68156[(2)]);
var state_68156__$1 = state_68156;
var statearr_68160_68179 = state_68156__$1;
(statearr_68160_68179[(2)] = inst_68130);

(statearr_68160_68179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68157 === (6))){
var state_68156__$1 = state_68156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68156__$1,(9),x);
} else {
if((state_val_68157 === (3))){
var inst_68154 = (state_68156[(2)]);
var state_68156__$1 = state_68156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68156__$1,inst_68154);
} else {
if((state_val_68157 === (2))){
var _ = (function (){var statearr_68162 = state_68156;
(statearr_68162[(4)] = cljs.core.cons((5),(state_68156[(4)])));

return statearr_68162;
})();
var inst_68136 = fluree.db.util.async.channel_QMARK_(x);
var state_68156__$1 = state_68156;
if(inst_68136){
var statearr_68163_68180 = state_68156__$1;
(statearr_68163_68180[(1)] = (6));

} else {
var statearr_68164_68181 = state_68156__$1;
(statearr_68164_68181[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68157 === (9))){
var inst_68139 = (state_68156[(2)]);
var inst_68140 = fluree.db.util.async.throw_err(inst_68139);
var state_68156__$1 = state_68156;
var statearr_68165_68182 = state_68156__$1;
(statearr_68165_68182[(2)] = inst_68140);

(statearr_68165_68182[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68157 === (5))){
var _ = (function (){var statearr_68166 = state_68156;
(statearr_68166[(4)] = cljs.core.rest((state_68156[(4)])));

return statearr_68166;
})();
var state_68156__$1 = state_68156;
var ex68161 = (state_68156__$1[(2)]);
var statearr_68167_68183 = state_68156__$1;
(statearr_68167_68183[(5)] = ex68161);


if((ex68161 instanceof Error)){
var statearr_68168_68184 = state_68156__$1;
(statearr_68168_68184[(1)] = (4));

(statearr_68168_68184[(5)] = null);

} else {
throw ex68161;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68157 === (8))){
var inst_68143 = (state_68156[(2)]);
var inst_68144 = fluree.db.dbfunctions.internal.boolean$(inst_68143);
var inst_68145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68146 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68147 = ["boolean",inst_68143,inst_68144];
var inst_68148 = cljs.core.PersistentHashMap.fromArrays(inst_68146,inst_68147);
var inst_68149 = [inst_68148,(10)];
var inst_68150 = (new cljs.core.PersistentVector(null,2,(5),inst_68145,inst_68149,null));
var inst_68151 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68150);
var _ = (function (){var statearr_68169 = state_68156;
(statearr_68169[(4)] = cljs.core.rest((state_68156[(4)])));

return statearr_68169;
})();
var state_68156__$1 = (function (){var statearr_68170 = state_68156;
(statearr_68170[(7)] = inst_68151);

return statearr_68170;
})();
var statearr_68171_68185 = state_68156__$1;
(statearr_68171_68185[(2)] = inst_68144);

(statearr_68171_68185[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto____0 = (function (){
var statearr_68172 = [null,null,null,null,null,null,null,null];
(statearr_68172[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto__);

(statearr_68172[(1)] = (1));

return statearr_68172;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto____1 = (function (state_68156){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68156);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68173){var ex__10801__auto__ = e68173;
var statearr_68174_68186 = state_68156;
(statearr_68174_68186[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68156[(4)]))){
var statearr_68175_68187 = state_68156;
(statearr_68175_68187[(1)] = cljs.core.first((state_68156[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68188 = state_68156;
state_68156 = G__68188;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto__ = function(state_68156){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto____1.call(this,state_68156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68176 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68176[(6)] = c__10835__auto__);

return statearr_68176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68226){
var state_val_68227 = (state_68226[(1)]);
if((state_val_68227 === (7))){
var state_68226__$1 = state_68226;
var statearr_68228_68252 = state_68226__$1;
(statearr_68228_68252[(2)] = pattern);

(statearr_68228_68252[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (1))){
var state_68226__$1 = state_68226;
var statearr_68229_68253 = state_68226__$1;
(statearr_68229_68253[(2)] = null);

(statearr_68229_68253[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (4))){
var inst_68189 = (state_68226[(2)]);
var state_68226__$1 = state_68226;
var statearr_68230_68254 = state_68226__$1;
(statearr_68230_68254[(2)] = inst_68189);

(statearr_68230_68254[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (13))){
var inst_68206 = (state_68226[(2)]);
var inst_68207 = fluree.db.util.async.throw_err(inst_68206);
var state_68226__$1 = state_68226;
var statearr_68231_68255 = state_68226__$1;
(statearr_68231_68255[(2)] = inst_68207);

(statearr_68231_68255[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (6))){
var state_68226__$1 = state_68226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68226__$1,(9),pattern);
} else {
if((state_val_68227 === (3))){
var inst_68224 = (state_68226[(2)]);
var state_68226__$1 = state_68226;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68226__$1,inst_68224);
} else {
if((state_val_68227 === (12))){
var inst_68202 = (state_68226[(7)]);
var inst_68210 = (state_68226[(2)]);
var inst_68211 = fluree.db.dbfunctions.internal.re_find(inst_68202,inst_68210);
var inst_68212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68213 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68215 = [inst_68202,inst_68210];
var inst_68216 = (new cljs.core.PersistentVector(null,2,(5),inst_68214,inst_68215,null));
var inst_68217 = ["re-find",inst_68216,inst_68211];
var inst_68218 = cljs.core.PersistentHashMap.fromArrays(inst_68213,inst_68217);
var inst_68219 = [inst_68218,(10)];
var inst_68220 = (new cljs.core.PersistentVector(null,2,(5),inst_68212,inst_68219,null));
var inst_68221 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68220);
var _ = (function (){var statearr_68232 = state_68226;
(statearr_68232[(4)] = cljs.core.rest((state_68226[(4)])));

return statearr_68232;
})();
var state_68226__$1 = (function (){var statearr_68233 = state_68226;
(statearr_68233[(8)] = inst_68221);

return statearr_68233;
})();
var statearr_68234_68256 = state_68226__$1;
(statearr_68234_68256[(2)] = inst_68211);

(statearr_68234_68256[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (2))){
var _ = (function (){var statearr_68235 = state_68226;
(statearr_68235[(4)] = cljs.core.cons((5),(state_68226[(4)])));

return statearr_68235;
})();
var inst_68195 = fluree.db.util.async.channel_QMARK_(pattern);
var state_68226__$1 = state_68226;
if(inst_68195){
var statearr_68236_68257 = state_68226__$1;
(statearr_68236_68257[(1)] = (6));

} else {
var statearr_68237_68258 = state_68226__$1;
(statearr_68237_68258[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (11))){
var state_68226__$1 = state_68226;
var statearr_68239_68259 = state_68226__$1;
(statearr_68239_68259[(2)] = string);

(statearr_68239_68259[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (9))){
var inst_68198 = (state_68226[(2)]);
var inst_68199 = fluree.db.util.async.throw_err(inst_68198);
var state_68226__$1 = state_68226;
var statearr_68240_68260 = state_68226__$1;
(statearr_68240_68260[(2)] = inst_68199);

(statearr_68240_68260[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (5))){
var _ = (function (){var statearr_68241 = state_68226;
(statearr_68241[(4)] = cljs.core.rest((state_68226[(4)])));

return statearr_68241;
})();
var state_68226__$1 = state_68226;
var ex68238 = (state_68226__$1[(2)]);
var statearr_68242_68261 = state_68226__$1;
(statearr_68242_68261[(5)] = ex68238);


if((ex68238 instanceof Error)){
var statearr_68243_68262 = state_68226__$1;
(statearr_68243_68262[(1)] = (4));

(statearr_68243_68262[(5)] = null);

} else {
throw ex68238;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68227 === (10))){
var state_68226__$1 = state_68226;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68226__$1,(13),string);
} else {
if((state_val_68227 === (8))){
var inst_68202 = (state_68226[(2)]);
var inst_68203 = fluree.db.util.async.channel_QMARK_(string);
var state_68226__$1 = (function (){var statearr_68244 = state_68226;
(statearr_68244[(7)] = inst_68202);

return statearr_68244;
})();
if(inst_68203){
var statearr_68245_68263 = state_68226__$1;
(statearr_68245_68263[(1)] = (10));

} else {
var statearr_68246_68264 = state_68226__$1;
(statearr_68246_68264[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto____0 = (function (){
var statearr_68247 = [null,null,null,null,null,null,null,null,null];
(statearr_68247[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto__);

(statearr_68247[(1)] = (1));

return statearr_68247;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto____1 = (function (state_68226){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68226);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68248){var ex__10801__auto__ = e68248;
var statearr_68249_68265 = state_68226;
(statearr_68249_68265[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68226[(4)]))){
var statearr_68250_68266 = state_68226;
(statearr_68250_68266[(1)] = cljs.core.first((state_68226[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68267 = state_68226;
state_68226 = G__68267;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto__ = function(state_68226){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto____1.call(this,state_68226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68251 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68251[(6)] = c__10835__auto__);

return statearr_68251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68294){
var state_val_68295 = (state_68294[(1)]);
if((state_val_68295 === (7))){
var state_68294__$1 = state_68294;
var statearr_68296_68315 = state_68294__$1;
(statearr_68296_68315[(2)] = email);

(statearr_68296_68315[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68295 === (1))){
var state_68294__$1 = state_68294;
var statearr_68297_68316 = state_68294__$1;
(statearr_68297_68316[(2)] = null);

(statearr_68297_68316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68295 === (4))){
var inst_68268 = (state_68294[(2)]);
var state_68294__$1 = state_68294;
var statearr_68298_68317 = state_68294__$1;
(statearr_68298_68317[(2)] = inst_68268);

(statearr_68298_68317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68295 === (6))){
var state_68294__$1 = state_68294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68294__$1,(9),email);
} else {
if((state_val_68295 === (3))){
var inst_68292 = (state_68294[(2)]);
var state_68294__$1 = state_68294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68294__$1,inst_68292);
} else {
if((state_val_68295 === (2))){
var _ = (function (){var statearr_68300 = state_68294;
(statearr_68300[(4)] = cljs.core.cons((5),(state_68294[(4)])));

return statearr_68300;
})();
var inst_68274 = fluree.db.util.async.channel_QMARK_(email);
var state_68294__$1 = state_68294;
if(inst_68274){
var statearr_68301_68318 = state_68294__$1;
(statearr_68301_68318[(1)] = (6));

} else {
var statearr_68302_68319 = state_68294__$1;
(statearr_68302_68319[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68295 === (9))){
var inst_68277 = (state_68294[(2)]);
var inst_68278 = fluree.db.util.async.throw_err(inst_68277);
var state_68294__$1 = state_68294;
var statearr_68303_68320 = state_68294__$1;
(statearr_68303_68320[(2)] = inst_68278);

(statearr_68303_68320[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68295 === (5))){
var _ = (function (){var statearr_68304 = state_68294;
(statearr_68304[(4)] = cljs.core.rest((state_68294[(4)])));

return statearr_68304;
})();
var state_68294__$1 = state_68294;
var ex68299 = (state_68294__$1[(2)]);
var statearr_68305_68321 = state_68294__$1;
(statearr_68305_68321[(5)] = ex68299);


if((ex68299 instanceof Error)){
var statearr_68306_68322 = state_68294__$1;
(statearr_68306_68322[(1)] = (4));

(statearr_68306_68322[(5)] = null);

} else {
throw ex68299;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68295 === (8))){
var inst_68281 = (state_68294[(2)]);
var inst_68282 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_68281);
var inst_68283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68284 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68285 = ["re-find",inst_68281,inst_68282];
var inst_68286 = cljs.core.PersistentHashMap.fromArrays(inst_68284,inst_68285);
var inst_68287 = [inst_68286,(10)];
var inst_68288 = (new cljs.core.PersistentVector(null,2,(5),inst_68283,inst_68287,null));
var inst_68289 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68288);
var _ = (function (){var statearr_68307 = state_68294;
(statearr_68307[(4)] = cljs.core.rest((state_68294[(4)])));

return statearr_68307;
})();
var state_68294__$1 = (function (){var statearr_68308 = state_68294;
(statearr_68308[(7)] = inst_68289);

return statearr_68308;
})();
var statearr_68309_68323 = state_68294__$1;
(statearr_68309_68323[(2)] = inst_68282);

(statearr_68309_68323[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto____0 = (function (){
var statearr_68310 = [null,null,null,null,null,null,null,null];
(statearr_68310[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto__);

(statearr_68310[(1)] = (1));

return statearr_68310;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto____1 = (function (state_68294){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68294);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68311){var ex__10801__auto__ = e68311;
var statearr_68312_68324 = state_68294;
(statearr_68312_68324[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68294[(4)]))){
var statearr_68313_68325 = state_68294;
(statearr_68313_68325[(1)] = cljs.core.first((state_68294[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68326 = state_68294;
state_68294 = G__68326;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto__ = function(state_68294){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto____1.call(this,state_68294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68314 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68314[(6)] = c__10835__auto__);

return statearr_68314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68373){
var state_val_68374 = (state_68373[(1)]);
if((state_val_68374 === (7))){
var inst_68343 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68373__$1 = state_68373;
if(cljs.core.truth_(inst_68343)){
var statearr_68375_68402 = state_68373__$1;
(statearr_68375_68402[(1)] = (9));

} else {
var statearr_68376_68403 = state_68373__$1;
(statearr_68376_68403[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (1))){
var state_68373__$1 = state_68373;
var statearr_68377_68404 = state_68373__$1;
(statearr_68377_68404[(2)] = null);

(statearr_68377_68404[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (4))){
var inst_68327 = (state_68373[(2)]);
var state_68373__$1 = state_68373;
var statearr_68378_68405 = state_68373__$1;
(statearr_68378_68405[(2)] = inst_68327);

(statearr_68378_68405[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (15))){
var inst_68354 = (state_68373[(2)]);
var state_68373__$1 = state_68373;
var statearr_68379_68406 = state_68373__$1;
(statearr_68379_68406[(2)] = inst_68354);

(statearr_68379_68406[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (13))){
var inst_68351 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_68373__$1 = state_68373;
var statearr_68380_68407 = state_68373__$1;
(statearr_68380_68407[(2)] = inst_68351);

(statearr_68380_68407[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (6))){
var inst_68338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68339 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_68340 = [inst_68339,(0)];
var inst_68341 = (new cljs.core.PersistentVector(null,2,(5),inst_68338,inst_68340,null));
var state_68373__$1 = state_68373;
var statearr_68381_68408 = state_68373__$1;
(statearr_68381_68408[(2)] = inst_68341);

(statearr_68381_68408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (3))){
var inst_68371 = (state_68373[(2)]);
var state_68373__$1 = state_68373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68373__$1,inst_68371);
} else {
if((state_val_68374 === (12))){
var inst_68347 = (state_68373[(2)]);
var inst_68348 = fluree.db.util.async.throw_err(inst_68347);
var state_68373__$1 = state_68373;
var statearr_68382_68409 = state_68373__$1;
(statearr_68382_68409[(2)] = inst_68348);

(statearr_68382_68409[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (2))){
var _ = (function (){var statearr_68383 = state_68373;
(statearr_68383[(4)] = cljs.core.cons((5),(state_68373[(4)])));

return statearr_68383;
})();
var inst_68336 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68373__$1 = state_68373;
if(cljs.core.truth_(inst_68336)){
var statearr_68384_68410 = state_68373__$1;
(statearr_68384_68410[(1)] = (6));

} else {
var statearr_68385_68411 = state_68373__$1;
(statearr_68385_68411[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (11))){
var inst_68356 = (state_68373[(2)]);
var state_68373__$1 = state_68373;
var statearr_68387_68412 = state_68373__$1;
(statearr_68387_68412[(2)] = inst_68356);

(statearr_68387_68412[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (9))){
var inst_68345 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_68373__$1 = state_68373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68373__$1,(12),inst_68345);
} else {
if((state_val_68374 === (5))){
var _ = (function (){var statearr_68388 = state_68373;
(statearr_68388[(4)] = cljs.core.rest((state_68373[(4)])));

return statearr_68388;
})();
var state_68373__$1 = state_68373;
var ex68386 = (state_68373__$1[(2)]);
var statearr_68389_68413 = state_68373__$1;
(statearr_68389_68413[(5)] = ex68386);


if((ex68386 instanceof Error)){
var statearr_68390_68414 = state_68373__$1;
(statearr_68390_68414[(1)] = (4));

(statearr_68390_68414[(5)] = null);

} else {
throw ex68386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (14))){
var state_68373__$1 = state_68373;
var statearr_68391_68415 = state_68373__$1;
(statearr_68391_68415[(2)] = null);

(statearr_68391_68415[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (10))){
var state_68373__$1 = state_68373;
var statearr_68392_68416 = state_68373__$1;
(statearr_68392_68416[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_68374 === (8))){
var inst_68358 = (state_68373[(2)]);
var inst_68359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68358,(0),null);
var inst_68360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68358,(1),null);
var inst_68361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68362 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68363 = ["?user_id","?ctx",inst_68359];
var inst_68364 = cljs.core.PersistentHashMap.fromArrays(inst_68362,inst_68363);
var inst_68365 = ((10) + inst_68360);
var inst_68366 = [inst_68364,inst_68365];
var inst_68367 = (new cljs.core.PersistentVector(null,2,(5),inst_68361,inst_68366,null));
var inst_68368 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68367);
var _ = (function (){var statearr_68394 = state_68373;
(statearr_68394[(4)] = cljs.core.rest((state_68373[(4)])));

return statearr_68394;
})();
var state_68373__$1 = (function (){var statearr_68395 = state_68373;
(statearr_68395[(7)] = inst_68368);

return statearr_68395;
})();
var statearr_68396_68417 = state_68373__$1;
(statearr_68396_68417[(2)] = inst_68359);

(statearr_68396_68417[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto____0 = (function (){
var statearr_68397 = [null,null,null,null,null,null,null,null];
(statearr_68397[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto__);

(statearr_68397[(1)] = (1));

return statearr_68397;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto____1 = (function (state_68373){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68373);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68398){var ex__10801__auto__ = e68398;
var statearr_68399_68418 = state_68373;
(statearr_68399_68418[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68373[(4)]))){
var statearr_68400_68419 = state_68373;
(statearr_68400_68419[(1)] = cljs.core.first((state_68373[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68420 = state_68373;
state_68373 = G__68420;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto__ = function(state_68373){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto____1.call(this,state_68373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68401 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68401[(6)] = c__10835__auto__);

return statearr_68401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68448){
var state_val_68449 = (state_68448[(1)]);
if((state_val_68449 === (7))){
var inst_68441 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_68448__$1 = state_68448;
var statearr_68450_68469 = state_68448__$1;
(statearr_68450_68469[(2)] = inst_68441);

(statearr_68450_68469[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68449 === (1))){
var state_68448__$1 = state_68448;
var statearr_68451_68470 = state_68448__$1;
(statearr_68451_68470[(2)] = null);

(statearr_68451_68470[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68449 === (4))){
var inst_68421 = (state_68448[(2)]);
var state_68448__$1 = state_68448;
var statearr_68452_68471 = state_68448__$1;
(statearr_68452_68471[(2)] = inst_68421);

(statearr_68452_68471[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68449 === (6))){
var inst_68429 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_68448__$1 = state_68448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68448__$1,(9),inst_68429);
} else {
if((state_val_68449 === (3))){
var inst_68446 = (state_68448[(2)]);
var state_68448__$1 = state_68448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68448__$1,inst_68446);
} else {
if((state_val_68449 === (2))){
var _ = (function (){var statearr_68454 = state_68448;
(statearr_68454[(4)] = cljs.core.cons((5),(state_68448[(4)])));

return statearr_68454;
})();
var inst_68427 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68448__$1 = state_68448;
if(cljs.core.truth_(inst_68427)){
var statearr_68455_68472 = state_68448__$1;
(statearr_68455_68472[(1)] = (6));

} else {
var statearr_68456_68473 = state_68448__$1;
(statearr_68456_68473[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68449 === (9))){
var inst_68431 = (state_68448[(2)]);
var inst_68432 = fluree.db.util.async.throw_err(inst_68431);
var inst_68433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68434 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68435 = ["?auth_id","?ctx",inst_68432];
var inst_68436 = cljs.core.PersistentHashMap.fromArrays(inst_68434,inst_68435);
var inst_68437 = [inst_68436,(10)];
var inst_68438 = (new cljs.core.PersistentVector(null,2,(5),inst_68433,inst_68437,null));
var inst_68439 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68438);
var state_68448__$1 = (function (){var statearr_68457 = state_68448;
(statearr_68457[(7)] = inst_68439);

return statearr_68457;
})();
var statearr_68458_68474 = state_68448__$1;
(statearr_68458_68474[(2)] = inst_68432);

(statearr_68458_68474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68449 === (5))){
var _ = (function (){var statearr_68459 = state_68448;
(statearr_68459[(4)] = cljs.core.rest((state_68448[(4)])));

return statearr_68459;
})();
var state_68448__$1 = state_68448;
var ex68453 = (state_68448__$1[(2)]);
var statearr_68460_68475 = state_68448__$1;
(statearr_68460_68475[(5)] = ex68453);


if((ex68453 instanceof Error)){
var statearr_68461_68476 = state_68448__$1;
(statearr_68461_68476[(1)] = (4));

(statearr_68461_68476[(5)] = null);

} else {
throw ex68453;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68449 === (8))){
var inst_68443 = (state_68448[(2)]);
var _ = (function (){var statearr_68462 = state_68448;
(statearr_68462[(4)] = cljs.core.rest((state_68448[(4)])));

return statearr_68462;
})();
var state_68448__$1 = state_68448;
var statearr_68463_68477 = state_68448__$1;
(statearr_68463_68477[(2)] = inst_68443);

(statearr_68463_68477[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto____0 = (function (){
var statearr_68464 = [null,null,null,null,null,null,null,null];
(statearr_68464[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto__);

(statearr_68464[(1)] = (1));

return statearr_68464;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto____1 = (function (state_68448){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68448);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68465){var ex__10801__auto__ = e68465;
var statearr_68466_68478 = state_68448;
(statearr_68466_68478[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68448[(4)]))){
var statearr_68467_68479 = state_68448;
(statearr_68467_68479[(1)] = cljs.core.first((state_68448[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68480 = state_68448;
state_68448 = G__68480;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto__ = function(state_68448){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto____1.call(this,state_68448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68468 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68468[(6)] = c__10835__auto__);

return statearr_68468;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__68482 = arguments.length;
switch (G__68482) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68524){
var state_val_68525 = (state_68524[(1)]);
if((state_val_68525 === (7))){
var state_68524__$1 = state_68524;
var statearr_68526_68556 = state_68524__$1;
(statearr_68526_68556[(2)] = seed);

(statearr_68526_68556[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (1))){
var state_68524__$1 = state_68524;
var statearr_68527_68557 = state_68524__$1;
(statearr_68527_68557[(2)] = null);

(statearr_68527_68557[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (4))){
var inst_68483 = (state_68524[(2)]);
var state_68524__$1 = state_68524;
var statearr_68528_68558 = state_68524__$1;
(statearr_68528_68558[(2)] = inst_68483);

(statearr_68528_68558[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (15))){
var state_68524__$1 = state_68524;
var statearr_68529_68559 = state_68524__$1;
(statearr_68529_68559[(2)] = (10));

(statearr_68529_68559[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (13))){
var inst_68500 = (state_68524[(2)]);
var inst_68501 = fluree.db.util.async.throw_err(inst_68500);
var state_68524__$1 = state_68524;
var statearr_68530_68560 = state_68524__$1;
(statearr_68530_68560[(2)] = inst_68501);

(statearr_68530_68560[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (6))){
var state_68524__$1 = state_68524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68524__$1,(9),seed);
} else {
if((state_val_68525 === (3))){
var inst_68522 = (state_68524[(2)]);
var state_68524__$1 = state_68524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68524__$1,inst_68522);
} else {
if((state_val_68525 === (12))){
var inst_68504 = (state_68524[(7)]);
var inst_68504__$1 = (state_68524[(2)]);
var state_68524__$1 = (function (){var statearr_68531 = state_68524;
(statearr_68531[(7)] = inst_68504__$1);

return statearr_68531;
})();
if(cljs.core.truth_(inst_68504__$1)){
var statearr_68532_68561 = state_68524__$1;
(statearr_68532_68561[(1)] = (14));

} else {
var statearr_68533_68562 = state_68524__$1;
(statearr_68533_68562[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (2))){
var _ = (function (){var statearr_68534 = state_68524;
(statearr_68534[(4)] = cljs.core.cons((5),(state_68524[(4)])));

return statearr_68534;
})();
var inst_68489 = fluree.db.util.async.channel_QMARK_(seed);
var state_68524__$1 = state_68524;
if(inst_68489){
var statearr_68535_68563 = state_68524__$1;
(statearr_68535_68563[(1)] = (6));

} else {
var statearr_68536_68564 = state_68524__$1;
(statearr_68536_68564[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (11))){
var state_68524__$1 = state_68524;
var statearr_68538_68565 = state_68524__$1;
(statearr_68538_68565[(2)] = max);

(statearr_68538_68565[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (9))){
var inst_68492 = (state_68524[(2)]);
var inst_68493 = fluree.db.util.async.throw_err(inst_68492);
var state_68524__$1 = state_68524;
var statearr_68539_68566 = state_68524__$1;
(statearr_68539_68566[(2)] = inst_68493);

(statearr_68539_68566[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (5))){
var _ = (function (){var statearr_68540 = state_68524;
(statearr_68540[(4)] = cljs.core.rest((state_68524[(4)])));

return statearr_68540;
})();
var state_68524__$1 = state_68524;
var ex68537 = (state_68524__$1[(2)]);
var statearr_68541_68567 = state_68524__$1;
(statearr_68541_68567[(5)] = ex68537);


if((ex68537 instanceof Error)){
var statearr_68542_68568 = state_68524__$1;
(statearr_68542_68568[(1)] = (4));

(statearr_68542_68568[(5)] = null);

} else {
throw ex68537;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (14))){
var inst_68504 = (state_68524[(7)]);
var state_68524__$1 = state_68524;
var statearr_68543_68569 = state_68524__$1;
(statearr_68543_68569[(2)] = inst_68504);

(statearr_68543_68569[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (16))){
var inst_68496 = (state_68524[(8)]);
var inst_68508 = (state_68524[(2)]);
var inst_68509 = fluree.db.dbfunctions.internal.rand(inst_68496,inst_68508);
var inst_68510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68511 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68513 = [max,seed];
var inst_68514 = (new cljs.core.PersistentVector(null,2,(5),inst_68512,inst_68513,null));
var inst_68515 = ["rand",inst_68514,inst_68509];
var inst_68516 = cljs.core.PersistentHashMap.fromArrays(inst_68511,inst_68515);
var inst_68517 = [inst_68516,(10)];
var inst_68518 = (new cljs.core.PersistentVector(null,2,(5),inst_68510,inst_68517,null));
var inst_68519 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68518);
var _ = (function (){var statearr_68544 = state_68524;
(statearr_68544[(4)] = cljs.core.rest((state_68524[(4)])));

return statearr_68544;
})();
var state_68524__$1 = (function (){var statearr_68545 = state_68524;
(statearr_68545[(9)] = inst_68519);

return statearr_68545;
})();
var statearr_68546_68570 = state_68524__$1;
(statearr_68546_68570[(2)] = inst_68509);

(statearr_68546_68570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68525 === (10))){
var state_68524__$1 = state_68524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68524__$1,(13),max);
} else {
if((state_val_68525 === (8))){
var inst_68496 = (state_68524[(2)]);
var inst_68497 = fluree.db.util.async.channel_QMARK_(max);
var state_68524__$1 = (function (){var statearr_68547 = state_68524;
(statearr_68547[(8)] = inst_68496);

return statearr_68547;
})();
if(inst_68497){
var statearr_68548_68571 = state_68524__$1;
(statearr_68548_68571[(1)] = (10));

} else {
var statearr_68549_68572 = state_68524__$1;
(statearr_68549_68572[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10798__auto____0 = (function (){
var statearr_68550 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68550[(0)] = fluree$db$dbfunctions$fns$state_machine__10798__auto__);

(statearr_68550[(1)] = (1));

return statearr_68550;
});
var fluree$db$dbfunctions$fns$state_machine__10798__auto____1 = (function (state_68524){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68524);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68551){var ex__10801__auto__ = e68551;
var statearr_68552_68573 = state_68524;
(statearr_68552_68573[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68524[(4)]))){
var statearr_68553_68574 = state_68524;
(statearr_68553_68574[(1)] = cljs.core.first((state_68524[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68575 = state_68524;
state_68524 = G__68575;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10798__auto__ = function(state_68524){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10798__auto____1.call(this,state_68524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68554 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68554[(6)] = c__10835__auto__);

return statearr_68554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68596){
var state_val_68597 = (state_68596[(1)]);
if((state_val_68597 === (1))){
var state_68596__$1 = state_68596;
var statearr_68598_68613 = state_68596__$1;
(statearr_68598_68613[(2)] = null);

(statearr_68598_68613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68597 === (2))){
var _ = (function (){var statearr_68599 = state_68596;
(statearr_68599[(4)] = cljs.core.cons((5),(state_68596[(4)])));

return statearr_68599;
})();
var inst_68582 = fluree.db.util.core.random_uuid();
var inst_68583 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68582);
var inst_68584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68585 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68586 = cljs.core.PersistentVector.EMPTY;
var inst_68587 = ["uuid",inst_68586,inst_68583];
var inst_68588 = cljs.core.PersistentHashMap.fromArrays(inst_68585,inst_68587);
var inst_68589 = [inst_68588,(10)];
var inst_68590 = (new cljs.core.PersistentVector(null,2,(5),inst_68584,inst_68589,null));
var inst_68591 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68590);
var ___$1 = (function (){var statearr_68600 = state_68596;
(statearr_68600[(4)] = cljs.core.rest((state_68596[(4)])));

return statearr_68600;
})();
var state_68596__$1 = (function (){var statearr_68601 = state_68596;
(statearr_68601[(7)] = inst_68591);

return statearr_68601;
})();
var statearr_68602_68614 = state_68596__$1;
(statearr_68602_68614[(2)] = inst_68583);

(statearr_68602_68614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68597 === (3))){
var inst_68594 = (state_68596[(2)]);
var state_68596__$1 = state_68596;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68596__$1,inst_68594);
} else {
if((state_val_68597 === (4))){
var inst_68576 = (state_68596[(2)]);
var state_68596__$1 = state_68596;
var statearr_68604_68615 = state_68596__$1;
(statearr_68604_68615[(2)] = inst_68576);

(statearr_68604_68615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68597 === (5))){
var _ = (function (){var statearr_68605 = state_68596;
(statearr_68605[(4)] = cljs.core.rest((state_68596[(4)])));

return statearr_68605;
})();
var state_68596__$1 = state_68596;
var ex68603 = (state_68596__$1[(2)]);
var statearr_68606_68616 = state_68596__$1;
(statearr_68606_68616[(5)] = ex68603);


if((ex68603 instanceof Error)){
var statearr_68607_68617 = state_68596__$1;
(statearr_68607_68617[(1)] = (4));

(statearr_68607_68617[(5)] = null);

} else {
throw ex68603;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto____0 = (function (){
var statearr_68608 = [null,null,null,null,null,null,null,null];
(statearr_68608[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto__);

(statearr_68608[(1)] = (1));

return statearr_68608;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto____1 = (function (state_68596){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68596);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68609){var ex__10801__auto__ = e68609;
var statearr_68610_68618 = state_68596;
(statearr_68610_68618[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68596[(4)]))){
var statearr_68611_68619 = state_68596;
(statearr_68611_68619[(1)] = cljs.core.first((state_68596[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68620 = state_68596;
state_68596 = G__68620;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto__ = function(state_68596){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto____1.call(this,state_68596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68612 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68612[(6)] = c__10835__auto__);

return statearr_68612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68650){
var state_val_68651 = (state_68650[(1)]);
if((state_val_68651 === (7))){
var state_68650__$1 = state_68650;
var statearr_68652_68671 = state_68650__$1;
(statearr_68652_68671[(2)] = num);

(statearr_68652_68671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68651 === (1))){
var state_68650__$1 = state_68650;
var statearr_68653_68672 = state_68650__$1;
(statearr_68653_68672[(2)] = null);

(statearr_68653_68672[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68651 === (4))){
var inst_68621 = (state_68650[(2)]);
var state_68650__$1 = state_68650;
var statearr_68654_68673 = state_68650__$1;
(statearr_68654_68673[(2)] = inst_68621);

(statearr_68654_68673[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68651 === (6))){
var state_68650__$1 = state_68650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68650__$1,(9),num);
} else {
if((state_val_68651 === (3))){
var inst_68648 = (state_68650[(2)]);
var state_68650__$1 = state_68650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68650__$1,inst_68648);
} else {
if((state_val_68651 === (2))){
var _ = (function (){var statearr_68656 = state_68650;
(statearr_68656[(4)] = cljs.core.cons((5),(state_68650[(4)])));

return statearr_68656;
})();
var inst_68627 = fluree.db.util.async.channel_QMARK_(num);
var state_68650__$1 = state_68650;
if(inst_68627){
var statearr_68657_68674 = state_68650__$1;
(statearr_68657_68674[(1)] = (6));

} else {
var statearr_68658_68675 = state_68650__$1;
(statearr_68658_68675[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68651 === (9))){
var inst_68630 = (state_68650[(2)]);
var inst_68631 = fluree.db.util.async.throw_err(inst_68630);
var state_68650__$1 = state_68650;
var statearr_68659_68676 = state_68650__$1;
(statearr_68659_68676[(2)] = inst_68631);

(statearr_68659_68676[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68651 === (5))){
var _ = (function (){var statearr_68660 = state_68650;
(statearr_68660[(4)] = cljs.core.rest((state_68650[(4)])));

return statearr_68660;
})();
var state_68650__$1 = state_68650;
var ex68655 = (state_68650__$1[(2)]);
var statearr_68661_68677 = state_68650__$1;
(statearr_68661_68677[(5)] = ex68655);


if((ex68655 instanceof Error)){
var statearr_68662_68678 = state_68650__$1;
(statearr_68662_68678[(1)] = (4));

(statearr_68662_68678[(5)] = null);

} else {
throw ex68655;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68651 === (8))){
var inst_68634 = (state_68650[(2)]);
var inst_68635 = fluree.db.dbfunctions.internal.ceil(inst_68634);
var inst_68636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68637 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68639 = [fluree.db.dbfunctions.fns.ceil];
var inst_68640 = (new cljs.core.PersistentVector(null,1,(5),inst_68638,inst_68639,null));
var inst_68641 = ["",inst_68640,inst_68635];
var inst_68642 = cljs.core.PersistentHashMap.fromArrays(inst_68637,inst_68641);
var inst_68643 = [inst_68642,(10)];
var inst_68644 = (new cljs.core.PersistentVector(null,2,(5),inst_68636,inst_68643,null));
var inst_68645 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68644);
var _ = (function (){var statearr_68663 = state_68650;
(statearr_68663[(4)] = cljs.core.rest((state_68650[(4)])));

return statearr_68663;
})();
var state_68650__$1 = (function (){var statearr_68664 = state_68650;
(statearr_68664[(7)] = inst_68645);

return statearr_68664;
})();
var statearr_68665_68679 = state_68650__$1;
(statearr_68665_68679[(2)] = inst_68635);

(statearr_68665_68679[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto____0 = (function (){
var statearr_68666 = [null,null,null,null,null,null,null,null];
(statearr_68666[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto__);

(statearr_68666[(1)] = (1));

return statearr_68666;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto____1 = (function (state_68650){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68650);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68667){var ex__10801__auto__ = e68667;
var statearr_68668_68680 = state_68650;
(statearr_68668_68680[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68650[(4)]))){
var statearr_68669_68681 = state_68650;
(statearr_68669_68681[(1)] = cljs.core.first((state_68650[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68682 = state_68650;
state_68650 = G__68682;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto__ = function(state_68650){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto____1.call(this,state_68650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68670 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68670[(6)] = c__10835__auto__);

return statearr_68670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68712){
var state_val_68713 = (state_68712[(1)]);
if((state_val_68713 === (7))){
var state_68712__$1 = state_68712;
var statearr_68714_68733 = state_68712__$1;
(statearr_68714_68733[(2)] = num);

(statearr_68714_68733[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68713 === (1))){
var state_68712__$1 = state_68712;
var statearr_68715_68734 = state_68712__$1;
(statearr_68715_68734[(2)] = null);

(statearr_68715_68734[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68713 === (4))){
var inst_68683 = (state_68712[(2)]);
var state_68712__$1 = state_68712;
var statearr_68716_68735 = state_68712__$1;
(statearr_68716_68735[(2)] = inst_68683);

(statearr_68716_68735[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68713 === (6))){
var state_68712__$1 = state_68712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68712__$1,(9),num);
} else {
if((state_val_68713 === (3))){
var inst_68710 = (state_68712[(2)]);
var state_68712__$1 = state_68712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68712__$1,inst_68710);
} else {
if((state_val_68713 === (2))){
var _ = (function (){var statearr_68718 = state_68712;
(statearr_68718[(4)] = cljs.core.cons((5),(state_68712[(4)])));

return statearr_68718;
})();
var inst_68689 = fluree.db.util.async.channel_QMARK_(num);
var state_68712__$1 = state_68712;
if(inst_68689){
var statearr_68719_68736 = state_68712__$1;
(statearr_68719_68736[(1)] = (6));

} else {
var statearr_68720_68737 = state_68712__$1;
(statearr_68720_68737[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68713 === (9))){
var inst_68692 = (state_68712[(2)]);
var inst_68693 = fluree.db.util.async.throw_err(inst_68692);
var state_68712__$1 = state_68712;
var statearr_68721_68738 = state_68712__$1;
(statearr_68721_68738[(2)] = inst_68693);

(statearr_68721_68738[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68713 === (5))){
var _ = (function (){var statearr_68722 = state_68712;
(statearr_68722[(4)] = cljs.core.rest((state_68712[(4)])));

return statearr_68722;
})();
var state_68712__$1 = state_68712;
var ex68717 = (state_68712__$1[(2)]);
var statearr_68723_68739 = state_68712__$1;
(statearr_68723_68739[(5)] = ex68717);


if((ex68717 instanceof Error)){
var statearr_68724_68740 = state_68712__$1;
(statearr_68724_68740[(1)] = (4));

(statearr_68724_68740[(5)] = null);

} else {
throw ex68717;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68713 === (8))){
var inst_68696 = (state_68712[(2)]);
var inst_68697 = fluree.db.dbfunctions.internal.floor(inst_68696);
var inst_68698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68699 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68701 = [fluree.db.dbfunctions.fns.floor];
var inst_68702 = (new cljs.core.PersistentVector(null,1,(5),inst_68700,inst_68701,null));
var inst_68703 = ["",inst_68702,inst_68697];
var inst_68704 = cljs.core.PersistentHashMap.fromArrays(inst_68699,inst_68703);
var inst_68705 = [inst_68704,(10)];
var inst_68706 = (new cljs.core.PersistentVector(null,2,(5),inst_68698,inst_68705,null));
var inst_68707 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68706);
var _ = (function (){var statearr_68725 = state_68712;
(statearr_68725[(4)] = cljs.core.rest((state_68712[(4)])));

return statearr_68725;
})();
var state_68712__$1 = (function (){var statearr_68726 = state_68712;
(statearr_68726[(7)] = inst_68707);

return statearr_68726;
})();
var statearr_68727_68741 = state_68712__$1;
(statearr_68727_68741[(2)] = inst_68697);

(statearr_68727_68741[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto____0 = (function (){
var statearr_68728 = [null,null,null,null,null,null,null,null];
(statearr_68728[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto__);

(statearr_68728[(1)] = (1));

return statearr_68728;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto____1 = (function (state_68712){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68712);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68729){var ex__10801__auto__ = e68729;
var statearr_68730_68742 = state_68712;
(statearr_68730_68742[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68712[(4)]))){
var statearr_68731_68743 = state_68712;
(statearr_68731_68743[(1)] = cljs.core.first((state_68712[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68744 = state_68712;
state_68712 = G__68744;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto__ = function(state_68712){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto____1.call(this,state_68712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68732 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68732[(6)] = c__10835__auto__);

return statearr_68732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_68769){
var state_val_68770 = (state_68769[(1)]);
if((state_val_68770 === (1))){
var state_68769__$1 = state_68769;
var statearr_68771_68786 = state_68769__$1;
(statearr_68771_68786[(2)] = null);

(statearr_68771_68786[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68770 === (2))){
var _ = (function (){var statearr_68772 = state_68769;
(statearr_68772[(4)] = cljs.core.cons((5),(state_68769[(4)])));

return statearr_68772;
})();
var inst_68751 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_68769__$1 = state_68769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68769__$1,(6),inst_68751);
} else {
if((state_val_68770 === (3))){
var inst_68767 = (state_68769[(2)]);
var state_68769__$1 = state_68769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68769__$1,inst_68767);
} else {
if((state_val_68770 === (4))){
var inst_68745 = (state_68769[(2)]);
var state_68769__$1 = state_68769;
var statearr_68774_68787 = state_68769__$1;
(statearr_68774_68787[(2)] = inst_68745);

(statearr_68774_68787[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68770 === (5))){
var _ = (function (){var statearr_68775 = state_68769;
(statearr_68775[(4)] = cljs.core.rest((state_68769[(4)])));

return statearr_68775;
})();
var state_68769__$1 = state_68769;
var ex68773 = (state_68769__$1[(2)]);
var statearr_68776_68788 = state_68769__$1;
(statearr_68776_68788[(5)] = ex68773);


if((ex68773 instanceof Error)){
var statearr_68777_68789 = state_68769__$1;
(statearr_68777_68789[(1)] = (4));

(statearr_68777_68789[(5)] = null);

} else {
throw ex68773;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68770 === (6))){
var inst_68753 = (state_68769[(2)]);
var inst_68754 = fluree.db.util.async.throw_err(inst_68753);
var inst_68755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68756 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68758 = [compare_val,new_val];
var inst_68759 = (new cljs.core.PersistentVector(null,2,(5),inst_68757,inst_68758,null));
var inst_68760 = ["",inst_68759,inst_68754];
var inst_68761 = cljs.core.PersistentHashMap.fromArrays(inst_68756,inst_68760);
var inst_68762 = [inst_68761,(10)];
var inst_68763 = (new cljs.core.PersistentVector(null,2,(5),inst_68755,inst_68762,null));
var inst_68764 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68763);
var _ = (function (){var statearr_68778 = state_68769;
(statearr_68778[(4)] = cljs.core.rest((state_68769[(4)])));

return statearr_68778;
})();
var state_68769__$1 = (function (){var statearr_68779 = state_68769;
(statearr_68779[(7)] = inst_68764);

return statearr_68779;
})();
var statearr_68780_68790 = state_68769__$1;
(statearr_68780_68790[(2)] = inst_68754);

(statearr_68780_68790[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto____0 = (function (){
var statearr_68781 = [null,null,null,null,null,null,null,null];
(statearr_68781[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto__);

(statearr_68781[(1)] = (1));

return statearr_68781;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto____1 = (function (state_68769){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_68769);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e68782){var ex__10801__auto__ = e68782;
var statearr_68783_68791 = state_68769;
(statearr_68783_68791[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_68769[(4)]))){
var statearr_68784_68792 = state_68769;
(statearr_68784_68792[(1)] = cljs.core.first((state_68769[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__68793 = state_68769;
state_68769 = G__68793;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto__ = function(state_68769){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto____1.call(this,state_68769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_68785 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_68785[(6)] = c__10835__auto__);

return statearr_68785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
