// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__65657_65826 = cljs.core.seq(servers);
var chunk__65658_65827 = null;
var count__65659_65828 = (0);
var i__65660_65829 = (0);
while(true){
if((i__65660_65829 < count__65659_65828)){
var server_65830 = chunk__65658_65827.cljs$core$IIndexed$_nth$arity$2(null,i__65660_65829);
var healthcheck_uri_65831 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_65830),"/fdb/health"].join('');
var resp_chan_65832 = fluree.db.util.xhttp.post_json(healthcheck_uri_65831,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__10878__auto___65833 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65833,healthcheck_uri_65831,resp_chan_65832,server_65830){
return (function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = ((function (seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65833,healthcheck_uri_65831,resp_chan_65832,server_65830){
return (function (state_65721){
var state_val_65722 = (state_65721[(1)]);
if((state_val_65722 === (1))){
var state_65721__$1 = state_65721;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65721__$1,(2),resp_chan_65832);
} else {
if((state_val_65722 === (2))){
var inst_65710 = (state_65721[(7)]);
var inst_65710__$1 = (state_65721[(2)]);
var inst_65711 = fluree.db.util.core.exception_QMARK_(inst_65710__$1);
var state_65721__$1 = (function (){var statearr_65723 = state_65721;
(statearr_65723[(7)] = inst_65710__$1);

return statearr_65723;
})();
if(inst_65711){
var statearr_65724_65834 = state_65721__$1;
(statearr_65724_65834[(1)] = (3));

} else {
var statearr_65725_65835 = state_65721__$1;
(statearr_65725_65835[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65722 === (3))){
var inst_65710 = (state_65721[(7)]);
var inst_65713 = cljs.core.ex_message(inst_65710);
var inst_65714 = cljs.core.ex_data(inst_65710);
var inst_65715 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_65713,inst_65714], 0));
var state_65721__$1 = state_65721;
var statearr_65726_65836 = state_65721__$1;
(statearr_65726_65836[(2)] = inst_65715);

(statearr_65726_65836[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65722 === (4))){
var inst_65717 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_65830);
var state_65721__$1 = state_65721;
var statearr_65727_65837 = state_65721__$1;
(statearr_65727_65837[(2)] = inst_65717);

(statearr_65727_65837[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65722 === (5))){
var inst_65719 = (state_65721[(2)]);
var state_65721__$1 = state_65721;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65721__$1,inst_65719);
} else {
return null;
}
}
}
}
}
});})(seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65833,healthcheck_uri_65831,resp_chan_65832,server_65830))
;
return ((function (seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,switch__10840__auto__,c__10878__auto___65833,healthcheck_uri_65831,resp_chan_65832,server_65830){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0 = (function (){
var statearr_65728 = [null,null,null,null,null,null,null,null];
(statearr_65728[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__);

(statearr_65728[(1)] = (1));

return statearr_65728;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1 = (function (state_65721){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65721);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65729){var ex__10844__auto__ = e65729;
var statearr_65730_65838 = state_65721;
(statearr_65730_65838[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65721[(4)]))){
var statearr_65731_65839 = state_65721;
(statearr_65731_65839[(1)] = cljs.core.first((state_65721[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65840 = state_65721;
state_65721 = G__65840;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__ = function(state_65721){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1.call(this,state_65721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__;
})()
;})(seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,switch__10840__auto__,c__10878__auto___65833,healthcheck_uri_65831,resp_chan_65832,server_65830))
})();
var state__10880__auto__ = (function (){var statearr_65732 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65732[(6)] = c__10878__auto___65833);

return statearr_65732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
});})(seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65833,healthcheck_uri_65831,resp_chan_65832,server_65830))
);



var G__65841 = seq__65657_65826;
var G__65842 = chunk__65658_65827;
var G__65843 = count__65659_65828;
var G__65844 = (i__65660_65829 + (1));
seq__65657_65826 = G__65841;
chunk__65658_65827 = G__65842;
count__65659_65828 = G__65843;
i__65660_65829 = G__65844;
continue;
} else {
var temp__5753__auto___65845 = cljs.core.seq(seq__65657_65826);
if(temp__5753__auto___65845){
var seq__65657_65846__$1 = temp__5753__auto___65845;
if(cljs.core.chunked_seq_QMARK_(seq__65657_65846__$1)){
var c__4649__auto___65847 = cljs.core.chunk_first(seq__65657_65846__$1);
var G__65848 = cljs.core.chunk_rest(seq__65657_65846__$1);
var G__65849 = c__4649__auto___65847;
var G__65850 = cljs.core.count(c__4649__auto___65847);
var G__65851 = (0);
seq__65657_65826 = G__65848;
chunk__65658_65827 = G__65849;
count__65659_65828 = G__65850;
i__65660_65829 = G__65851;
continue;
} else {
var server_65852 = cljs.core.first(seq__65657_65846__$1);
var healthcheck_uri_65853 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_65852),"/fdb/health"].join('');
var resp_chan_65854 = fluree.db.util.xhttp.post_json(healthcheck_uri_65853,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__10878__auto___65855 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65855,healthcheck_uri_65853,resp_chan_65854,server_65852,seq__65657_65846__$1,temp__5753__auto___65845){
return (function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = ((function (seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65855,healthcheck_uri_65853,resp_chan_65854,server_65852,seq__65657_65846__$1,temp__5753__auto___65845){
return (function (state_65745){
var state_val_65746 = (state_65745[(1)]);
if((state_val_65746 === (1))){
var state_65745__$1 = state_65745;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65745__$1,(2),resp_chan_65854);
} else {
if((state_val_65746 === (2))){
var inst_65734 = (state_65745[(7)]);
var inst_65734__$1 = (state_65745[(2)]);
var inst_65735 = fluree.db.util.core.exception_QMARK_(inst_65734__$1);
var state_65745__$1 = (function (){var statearr_65747 = state_65745;
(statearr_65747[(7)] = inst_65734__$1);

return statearr_65747;
})();
if(inst_65735){
var statearr_65748_65856 = state_65745__$1;
(statearr_65748_65856[(1)] = (3));

} else {
var statearr_65749_65857 = state_65745__$1;
(statearr_65749_65857[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65746 === (3))){
var inst_65734 = (state_65745[(7)]);
var inst_65737 = cljs.core.ex_message(inst_65734);
var inst_65738 = cljs.core.ex_data(inst_65734);
var inst_65739 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_65737,inst_65738], 0));
var state_65745__$1 = state_65745;
var statearr_65750_65858 = state_65745__$1;
(statearr_65750_65858[(2)] = inst_65739);

(statearr_65750_65858[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65746 === (4))){
var inst_65741 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_65852);
var state_65745__$1 = state_65745;
var statearr_65751_65859 = state_65745__$1;
(statearr_65751_65859[(2)] = inst_65741);

(statearr_65751_65859[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65746 === (5))){
var inst_65743 = (state_65745[(2)]);
var state_65745__$1 = state_65745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65745__$1,inst_65743);
} else {
return null;
}
}
}
}
}
});})(seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65855,healthcheck_uri_65853,resp_chan_65854,server_65852,seq__65657_65846__$1,temp__5753__auto___65845))
;
return ((function (seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,switch__10840__auto__,c__10878__auto___65855,healthcheck_uri_65853,resp_chan_65854,server_65852,seq__65657_65846__$1,temp__5753__auto___65845){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0 = (function (){
var statearr_65752 = [null,null,null,null,null,null,null,null];
(statearr_65752[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__);

(statearr_65752[(1)] = (1));

return statearr_65752;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1 = (function (state_65745){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65745);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65753){var ex__10844__auto__ = e65753;
var statearr_65754_65860 = state_65745;
(statearr_65754_65860[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65745[(4)]))){
var statearr_65755_65861 = state_65745;
(statearr_65755_65861[(1)] = cljs.core.first((state_65745[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65862 = state_65745;
state_65745 = G__65862;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__ = function(state_65745){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1.call(this,state_65745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__;
})()
;})(seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,switch__10840__auto__,c__10878__auto___65855,healthcheck_uri_65853,resp_chan_65854,server_65852,seq__65657_65846__$1,temp__5753__auto___65845))
})();
var state__10880__auto__ = (function (){var statearr_65756 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65756[(6)] = c__10878__auto___65855);

return statearr_65756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
});})(seq__65657_65826,chunk__65658_65827,count__65659_65828,i__65660_65829,c__10878__auto___65855,healthcheck_uri_65853,resp_chan_65854,server_65852,seq__65657_65846__$1,temp__5753__auto___65845))
);



var G__65863 = cljs.core.next(seq__65657_65846__$1);
var G__65864 = null;
var G__65865 = (0);
var G__65866 = (0);
seq__65657_65826 = G__65863;
chunk__65658_65827 = G__65864;
count__65659_65828 = G__65865;
i__65660_65829 = G__65866;
continue;
}
} else {
}
}
break;
}

var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65800){
var state_val_65801 = (state_65800[(1)]);
if((state_val_65801 === (7))){
var inst_65772 = (state_65800[(7)]);
var inst_65779 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65772,cljs.core.cst$kw$default);
var state_65800__$1 = state_65800;
if(inst_65779){
var statearr_65802_65867 = state_65800__$1;
(statearr_65802_65867[(1)] = (9));

} else {
var statearr_65803_65868 = state_65800__$1;
(statearr_65803_65868[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (1))){
var inst_65764 = (state_65800[(8)]);
var inst_65765 = (state_65800[(9)]);
var inst_65764__$1 = promise_chan;
var inst_65765__$1 = cljs.core.async.timeout((60000));
var inst_65766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65767 = [inst_65764__$1,inst_65765__$1];
var inst_65768 = (new cljs.core.PersistentVector(null,2,(5),inst_65766,inst_65767,null));
var state_65800__$1 = (function (){var statearr_65804 = state_65800;
(statearr_65804[(8)] = inst_65764__$1);

(statearr_65804[(9)] = inst_65765__$1);

return statearr_65804;
})();
return cljs.core.async.ioc_alts_BANG_(state_65800__$1,(2),inst_65768);
} else {
if((state_val_65801 === (4))){
var inst_65772 = (state_65800[(7)]);
var inst_65765 = (state_65800[(9)]);
var inst_65776 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65772,inst_65765);
var state_65800__$1 = state_65800;
if(inst_65776){
var statearr_65805_65869 = state_65800__$1;
(statearr_65805_65869[(1)] = (6));

} else {
var statearr_65806_65870 = state_65800__$1;
(statearr_65806_65870[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (13))){
var state_65800__$1 = state_65800;
var statearr_65807_65871 = state_65800__$1;
(statearr_65807_65871[(2)] = null);

(statearr_65807_65871[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (6))){
var state_65800__$1 = state_65800;
var statearr_65808_65872 = state_65800__$1;
(statearr_65808_65872[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_65808_65872[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (3))){
var state_65800__$1 = state_65800;
var statearr_65809_65873 = state_65800__$1;
(statearr_65809_65873[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_65809_65873[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (12))){
var inst_65790 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_65791 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_65792 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_65793 = cljs.core.PersistentHashMap.fromArrays(inst_65791,inst_65792);
var inst_65794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_65793);
var inst_65795 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_65794);
var state_65800__$1 = (function (){var statearr_65810 = state_65800;
(statearr_65810[(10)] = inst_65790);

return statearr_65810;
})();
var statearr_65811_65874 = state_65800__$1;
(statearr_65811_65874[(2)] = inst_65795);

(statearr_65811_65874[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (2))){
var inst_65772 = (state_65800[(7)]);
var inst_65764 = (state_65800[(8)]);
var inst_65770 = (state_65800[(2)]);
var inst_65771 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65770,(0),null);
var inst_65772__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65770,(1),null);
var inst_65773 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65772__$1,inst_65764);
var state_65800__$1 = (function (){var statearr_65812 = state_65800;
(statearr_65812[(7)] = inst_65772__$1);

(statearr_65812[(11)] = inst_65771);

return statearr_65812;
})();
if(inst_65773){
var statearr_65813_65875 = state_65800__$1;
(statearr_65813_65875[(1)] = (3));

} else {
var statearr_65814_65876 = state_65800__$1;
(statearr_65814_65876[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (11))){
var inst_65783 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
var statearr_65815_65877 = state_65800__$1;
(statearr_65815_65877[(2)] = inst_65783);

(statearr_65815_65877[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (9))){
var inst_65771 = (state_65800[(11)]);
var state_65800__$1 = state_65800;
var statearr_65816_65878 = state_65800__$1;
(statearr_65816_65878[(2)] = inst_65771);

(statearr_65816_65878[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (5))){
var inst_65787 = (state_65800[(2)]);
var inst_65788 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_65787);
var state_65800__$1 = state_65800;
if(inst_65788){
var statearr_65817_65879 = state_65800__$1;
(statearr_65817_65879[(1)] = (12));

} else {
var statearr_65818_65880 = state_65800__$1;
(statearr_65818_65880[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (14))){
var inst_65798 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65800__$1,inst_65798);
} else {
if((state_val_65801 === (10))){
var state_65800__$1 = state_65800;
var statearr_65819_65881 = state_65800__$1;
(statearr_65819_65881[(2)] = null);

(statearr_65819_65881[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65801 === (8))){
var inst_65785 = (state_65800[(2)]);
var state_65800__$1 = state_65800;
var statearr_65820_65882 = state_65800__$1;
(statearr_65820_65882[(2)] = inst_65785);

(statearr_65820_65882[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0 = (function (){
var statearr_65821 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65821[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__);

(statearr_65821[(1)] = (1));

return statearr_65821;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1 = (function (state_65800){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65800);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65822){var ex__10844__auto__ = e65822;
var statearr_65823_65883 = state_65800;
(statearr_65823_65883[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65800[(4)]))){
var statearr_65824_65884 = state_65800;
(statearr_65824_65884[(1)] = cljs.core.first((state_65800[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65885 = state_65800;
state_65800 = G__65885;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__ = function(state_65800){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1.call(this,state_65800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65825 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65825[(6)] = c__10878__auto__);

return statearr_65825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65929){
var state_val_65930 = (state_65929[(1)]);
if((state_val_65930 === (7))){
var state_65929__$1 = state_65929;
var statearr_65931_65957 = state_65929__$1;
(statearr_65931_65957[(2)] = null);

(statearr_65931_65957[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (1))){
var state_65929__$1 = state_65929;
var statearr_65932_65958 = state_65929__$1;
(statearr_65932_65958[(2)] = null);

(statearr_65932_65958[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (4))){
var inst_65886 = (state_65929[(2)]);
var state_65929__$1 = state_65929;
var statearr_65933_65959 = state_65929__$1;
(statearr_65933_65959[(2)] = inst_65886);

(statearr_65933_65959[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (6))){
var inst_65908 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_65929__$1 = state_65929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65929__$1,(9),inst_65908);
} else {
if((state_val_65930 === (3))){
var inst_65927 = (state_65929[(2)]);
var state_65929__$1 = state_65929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65929__$1,inst_65927);
} else {
if((state_val_65930 === (12))){
var inst_65921 = (state_65929[(2)]);
var state_65929__$1 = state_65929;
var statearr_65934_65960 = state_65929__$1;
(statearr_65934_65960[(2)] = inst_65921);

(statearr_65934_65960[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (2))){
var inst_65897 = (state_65929[(7)]);
var inst_65902 = (state_65929[(8)]);
var inst_65892 = (state_65929[(9)]);
var _ = (function (){var statearr_65935 = state_65929;
(statearr_65935[(4)] = cljs.core.cons((5),(state_65929[(4)])));

return statearr_65935;
})();
var inst_65892__$1 = fluree.db.util.core.random_uuid();
var inst_65893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65894 = [conn_id,cljs.core.cst$kw$ws];
var inst_65895 = (new cljs.core.PersistentVector(null,2,(5),inst_65893,inst_65894,null));
var inst_65896 = (function (){var lock_id = inst_65892__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_65897__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_65895,inst_65896);
var inst_65898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65899 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_65900 = (new cljs.core.PersistentVector(null,3,(5),inst_65898,inst_65899,null));
var inst_65901 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_65897__$1,inst_65900);
var inst_65902__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65892__$1,inst_65901);
var inst_65903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65904 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_65905 = (new cljs.core.PersistentVector(null,3,(5),inst_65903,inst_65904,null));
var inst_65906 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_65897__$1,inst_65905);
var state_65929__$1 = (function (){var statearr_65936 = state_65929;
(statearr_65936[(10)] = inst_65906);

(statearr_65936[(7)] = inst_65897__$1);

(statearr_65936[(8)] = inst_65902__$1);

(statearr_65936[(9)] = inst_65892__$1);

return statearr_65936;
})();
if(inst_65902__$1){
var statearr_65937_65961 = state_65929__$1;
(statearr_65937_65961[(1)] = (6));

} else {
var statearr_65938_65962 = state_65929__$1;
(statearr_65938_65962[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (11))){
var inst_65906 = (state_65929[(10)]);
var inst_65912 = (state_65929[(11)]);
var inst_65913 = (state_65929[(12)]);
var inst_65919 = fluree.db.util.xhttp.try_socket(inst_65912,sub_chan,pub_chan,inst_65906,(60000),inst_65913);
var state_65929__$1 = state_65929;
var statearr_65940_65963 = state_65929__$1;
(statearr_65940_65963[(2)] = inst_65919);

(statearr_65940_65963[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (9))){
var inst_65906 = (state_65929[(10)]);
var inst_65897 = (state_65929[(7)]);
var inst_65902 = (state_65929[(8)]);
var inst_65910 = (state_65929[(13)]);
var inst_65892 = (state_65929[(9)]);
var inst_65912 = (state_65929[(11)]);
var inst_65910__$1 = (state_65929[(2)]);
var inst_65911 = clojure.string.replace(inst_65910__$1,"http","ws");
var inst_65912__$1 = [inst_65911,"/fdb/ws"].join('');
var inst_65913 = (function (){var lock_id = inst_65892;
var state = inst_65897;
var have_lock_QMARK_ = inst_65902;
var resp_chan = inst_65906;
var healthy_server = inst_65910__$1;
var ws_url = inst_65912__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_65914 = fluree.db.util.core.exception_QMARK_(inst_65910__$1);
var state_65929__$1 = (function (){var statearr_65941 = state_65929;
(statearr_65941[(13)] = inst_65910__$1);

(statearr_65941[(11)] = inst_65912__$1);

(statearr_65941[(12)] = inst_65913);

return statearr_65941;
})();
if(inst_65914){
var statearr_65942_65964 = state_65929__$1;
(statearr_65942_65964[(1)] = (10));

} else {
var statearr_65943_65965 = state_65929__$1;
(statearr_65943_65965[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (5))){
var _ = (function (){var statearr_65944 = state_65929;
(statearr_65944[(4)] = cljs.core.rest((state_65929[(4)])));

return statearr_65944;
})();
var state_65929__$1 = state_65929;
var ex65939 = (state_65929__$1[(2)]);
var statearr_65945_65966 = state_65929__$1;
(statearr_65945_65966[(5)] = ex65939);


if((ex65939 instanceof Error)){
var statearr_65946_65967 = state_65929__$1;
(statearr_65946_65967[(1)] = (4));

(statearr_65946_65967[(5)] = null);

} else {
throw ex65939;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (10))){
var inst_65906 = (state_65929[(10)]);
var inst_65910 = (state_65929[(13)]);
var inst_65916 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_65917 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_65906,inst_65910);
var state_65929__$1 = (function (){var statearr_65947 = state_65929;
(statearr_65947[(14)] = inst_65916);

return statearr_65947;
})();
var statearr_65948_65968 = state_65929__$1;
(statearr_65948_65968[(2)] = inst_65917);

(statearr_65948_65968[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65930 === (8))){
var inst_65906 = (state_65929[(10)]);
var inst_65924 = (state_65929[(2)]);
var _ = (function (){var statearr_65949 = state_65929;
(statearr_65949[(4)] = cljs.core.rest((state_65929[(4)])));

return statearr_65949;
})();
var state_65929__$1 = (function (){var statearr_65950 = state_65929;
(statearr_65950[(15)] = inst_65924);

return statearr_65950;
})();
var statearr_65951_65969 = state_65929__$1;
(statearr_65951_65969[(2)] = inst_65906);

(statearr_65951_65969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__10841__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__10841__auto____0 = (function (){
var statearr_65952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65952[(0)] = fluree$db$connection$establish_socket_$_state_machine__10841__auto__);

(statearr_65952[(1)] = (1));

return statearr_65952;
});
var fluree$db$connection$establish_socket_$_state_machine__10841__auto____1 = (function (state_65929){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65929);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65953){var ex__10844__auto__ = e65953;
var statearr_65954_65970 = state_65929;
(statearr_65954_65970[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65929[(4)]))){
var statearr_65955_65971 = state_65929;
(statearr_65955_65971[(1)] = cljs.core.first((state_65929[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65972 = state_65929;
state_65929 = G__65972;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__10841__auto__ = function(state_65929){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__10841__auto____1.call(this,state_65929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__10841__auto____0;
fluree$db$connection$establish_socket_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__10841__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65956 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65956[(6)] = c__10878__auto__);

return statearr_65956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k65974,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__65978 = k65974;
var G__65978__$1 = (((G__65978 instanceof cljs.core.Keyword))?G__65978.fqn:null);
switch (G__65978__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k65974,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__65979){
var vec__65980 = p__65979;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65980,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65980,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__65973){
var self__ = this;
var G__65973__$1 = this;
return (new cljs.core.RecordIter((0),G__65973__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__65983 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__65983(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this65975,other65976){
var self__ = this;
var this65975__$1 = this;
return (((!((other65976 == null)))) && ((((this65975__$1.constructor === other65976.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.id,other65976.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.servers,other65976.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.state,other65976.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.req_chan,other65976.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.sub_chan,other65976.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.pub_chan,other65976.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.storage_read,other65976.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.storage_write,other65976.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.object_cache,other65976.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.parallelism,other65976.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.serializer,other65976.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.default_network,other65976.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.transactor_QMARK_,other65976.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.publish,other65976.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.transact_handler,other65976.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.tx_private_key,other65976.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.tx_key_id,other65976.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.meta,other65976.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.add_listener,other65976.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.remove_listener,other65976.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.close,other65976.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this65975__$1.__extmap,other65976.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k65974){
var self__ = this;
var this__4479__auto____$1 = this;
var G__65984 = k65974;
var G__65984__$1 = (((G__65984 instanceof cljs.core.Keyword))?G__65984.fqn:null);
switch (G__65984__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k65974);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__65973){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__65985 = cljs.core.keyword_identical_QMARK_;
var expr__65986 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__65988 = cljs.core.cst$kw$id;
var G__65989 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__65988,G__65989) : pred__65985.call(null,G__65988,G__65989));
})())){
return (new fluree.db.connection.Connection(G__65973,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__65990 = cljs.core.cst$kw$servers;
var G__65991 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__65990,G__65991) : pred__65985.call(null,G__65990,G__65991));
})())){
return (new fluree.db.connection.Connection(self__.id,G__65973,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__65992 = cljs.core.cst$kw$state;
var G__65993 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__65992,G__65993) : pred__65985.call(null,G__65992,G__65993));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__65973,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__65994 = cljs.core.cst$kw$req_DASH_chan;
var G__65995 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__65994,G__65995) : pred__65985.call(null,G__65994,G__65995));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__65973,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__65996 = cljs.core.cst$kw$sub_DASH_chan;
var G__65997 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__65996,G__65997) : pred__65985.call(null,G__65996,G__65997));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__65973,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__65998 = cljs.core.cst$kw$pub_DASH_chan;
var G__65999 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__65998,G__65999) : pred__65985.call(null,G__65998,G__65999));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__65973,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66000 = cljs.core.cst$kw$storage_DASH_read;
var G__66001 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66000,G__66001) : pred__65985.call(null,G__66000,G__66001));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__65973,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66002 = cljs.core.cst$kw$storage_DASH_write;
var G__66003 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66002,G__66003) : pred__65985.call(null,G__66002,G__66003));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__65973,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66004 = cljs.core.cst$kw$object_DASH_cache;
var G__66005 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66004,G__66005) : pred__65985.call(null,G__66004,G__66005));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__65973,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66006 = cljs.core.cst$kw$parallelism;
var G__66007 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66006,G__66007) : pred__65985.call(null,G__66006,G__66007));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__65973,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66008 = cljs.core.cst$kw$serializer;
var G__66009 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66008,G__66009) : pred__65985.call(null,G__66008,G__66009));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__65973,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66010 = cljs.core.cst$kw$default_DASH_network;
var G__66011 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66010,G__66011) : pred__65985.call(null,G__66010,G__66011));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__65973,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66012 = cljs.core.cst$kw$transactor_QMARK_;
var G__66013 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66012,G__66013) : pred__65985.call(null,G__66012,G__66013));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__65973,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66014 = cljs.core.cst$kw$publish;
var G__66015 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66014,G__66015) : pred__65985.call(null,G__66014,G__66015));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__65973,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66016 = cljs.core.cst$kw$transact_DASH_handler;
var G__66017 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66016,G__66017) : pred__65985.call(null,G__66016,G__66017));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__65973,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66018 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__66019 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66018,G__66019) : pred__65985.call(null,G__66018,G__66019));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__65973,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66020 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__66021 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66020,G__66021) : pred__65985.call(null,G__66020,G__66021));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__65973,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66022 = cljs.core.cst$kw$meta;
var G__66023 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66022,G__66023) : pred__65985.call(null,G__66022,G__66023));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__65973,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66024 = cljs.core.cst$kw$add_DASH_listener;
var G__66025 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66024,G__66025) : pred__65985.call(null,G__66024,G__66025));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__65973,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66026 = cljs.core.cst$kw$remove_DASH_listener;
var G__66027 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66026,G__66027) : pred__65985.call(null,G__66026,G__66027));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__65973,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__66028 = cljs.core.cst$kw$close;
var G__66029 = expr__65986;
return (pred__65985.cljs$core$IFn$_invoke$arity$2 ? pred__65985.cljs$core$IFn$_invoke$arity$2(G__66028,G__66029) : pred__65985.call(null,G__66028,G__66029));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__65973,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__65973),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__65973){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__65973,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__65977){
var extmap__4512__auto__ = (function (){var G__66030 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__65977,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__65977)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__66030);
} else {
return G__66030;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__65977),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__65977),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__66036 = servers_STAR_;
var vec__66037 = G__66036;
var seq__66038 = cljs.core.seq(vec__66037);
var first__66039 = cljs.core.first(seq__66038);
var seq__66038__$1 = cljs.core.next(seq__66038);
var server = first__66039;
var r = seq__66038__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__66036__$1 = G__66036;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__66043 = G__66036__$1;
var seq__66044 = cljs.core.seq(vec__66043);
var first__66045 = cljs.core.first(seq__66044);
var seq__66044__$1 = cljs.core.next(seq__66044);
var server__$1 = first__66045;
var r__$1 = seq__66044__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__66046 = r__$1;
var G__66047 = is_https_QMARK_;
var G__66048 = result_STAR_;
G__66036__$1 = G__66046;
https_QMARK___$1 = G__66047;
result__$1 = G__66048;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__66049 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__66049 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__66049);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66078){
var state_val_66079 = (state_66078[(1)]);
if((state_val_66079 === (7))){
var inst_66064 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66065 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66066 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66067 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66068 = fluree.db.connection.establish_socket(inst_66064,inst_66065,inst_66066,inst_66067);
var state_66078__$1 = state_66078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66078__$1,(9),inst_66068);
} else {
if((state_val_66079 === (1))){
var state_66078__$1 = state_66078;
var statearr_66080_66099 = state_66078__$1;
(statearr_66080_66099[(2)] = null);

(statearr_66080_66099[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66079 === (4))){
var inst_66050 = (state_66078[(2)]);
var state_66078__$1 = state_66078;
var statearr_66081_66100 = state_66078__$1;
(statearr_66081_66100[(2)] = inst_66050);

(statearr_66081_66100[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66079 === (6))){
var inst_66061 = (state_66078[(7)]);
var state_66078__$1 = state_66078;
var statearr_66082_66101 = state_66078__$1;
(statearr_66082_66101[(2)] = inst_66061);

(statearr_66082_66101[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66079 === (3))){
var inst_66076 = (state_66078[(2)]);
var state_66078__$1 = state_66078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66078__$1,inst_66076);
} else {
if((state_val_66079 === (2))){
var inst_66061 = (state_66078[(7)]);
var _ = (function (){var statearr_66084 = state_66078;
(statearr_66084[(4)] = cljs.core.cons((5),(state_66078[(4)])));

return statearr_66084;
})();
var inst_66056 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_66057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66058 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66059 = [inst_66058,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_66060 = (new cljs.core.PersistentVector(null,3,(5),inst_66057,inst_66059,null));
var inst_66061__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_66056,inst_66060);
var state_66078__$1 = (function (){var statearr_66085 = state_66078;
(statearr_66085[(7)] = inst_66061__$1);

return statearr_66085;
})();
if(cljs.core.truth_(inst_66061__$1)){
var statearr_66086_66102 = state_66078__$1;
(statearr_66086_66102[(1)] = (6));

} else {
var statearr_66087_66103 = state_66078__$1;
(statearr_66087_66103[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66079 === (9))){
var inst_66070 = (state_66078[(2)]);
var inst_66071 = fluree.db.util.async.throw_err(inst_66070);
var state_66078__$1 = state_66078;
var statearr_66088_66104 = state_66078__$1;
(statearr_66088_66104[(2)] = inst_66071);

(statearr_66088_66104[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66079 === (5))){
var _ = (function (){var statearr_66089 = state_66078;
(statearr_66089[(4)] = cljs.core.rest((state_66078[(4)])));

return statearr_66089;
})();
var state_66078__$1 = state_66078;
var ex66083 = (state_66078__$1[(2)]);
var statearr_66090_66105 = state_66078__$1;
(statearr_66090_66105[(5)] = ex66083);


if((ex66083 instanceof Error)){
var statearr_66091_66106 = state_66078__$1;
(statearr_66091_66106[(1)] = (4));

(statearr_66091_66106[(5)] = null);

} else {
throw ex66083;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66079 === (8))){
var inst_66073 = (state_66078[(2)]);
var _ = (function (){var statearr_66092 = state_66078;
(statearr_66092[(4)] = cljs.core.rest((state_66078[(4)])));

return statearr_66092;
})();
var state_66078__$1 = state_66078;
var statearr_66093_66107 = state_66078__$1;
(statearr_66093_66107[(2)] = inst_66073);

(statearr_66093_66107[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__10841__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__10841__auto____0 = (function (){
var statearr_66094 = [null,null,null,null,null,null,null,null];
(statearr_66094[(0)] = fluree$db$connection$get_socket_$_state_machine__10841__auto__);

(statearr_66094[(1)] = (1));

return statearr_66094;
});
var fluree$db$connection$get_socket_$_state_machine__10841__auto____1 = (function (state_66078){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66078);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66095){var ex__10844__auto__ = e66095;
var statearr_66096_66108 = state_66078;
(statearr_66096_66108[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66078[(4)]))){
var statearr_66097_66109 = state_66078;
(statearr_66097_66109[(1)] = cljs.core.first((state_66078[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66110 = state_66078;
state_66078 = G__66110;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__10841__auto__ = function(state_66078){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__10841__auto____1.call(this,state_66078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__10841__auto____0;
fluree$db$connection$get_socket_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__10841__auto____1;
return fluree$db$connection$get_socket_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66098 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66098[(6)] = c__10878__auto__);

return statearr_66098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e66111){var e = e66111;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66238){
var state_val_66239 = (state_66238[(1)]);
if((state_val_66239 === (7))){
var inst_66234 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
var statearr_66241_66311 = state_66238__$1;
(statearr_66241_66311[(2)] = inst_66234);

(statearr_66241_66311[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (20))){
var _ = (function (){var statearr_66242 = state_66238;
(statearr_66242[(4)] = cljs.core.rest((state_66238[(4)])));

return statearr_66242;
})();
var state_66238__$1 = state_66238;
var ex66240 = (state_66238__$1[(2)]);
var statearr_66243_66312 = state_66238__$1;
(statearr_66243_66312[(5)] = ex66240);


var statearr_66244_66313 = state_66238__$1;
(statearr_66244_66313[(1)] = (10));

(statearr_66244_66313[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (27))){
var inst_66226 = (state_66238[(2)]);
var _ = (function (){var statearr_66245 = state_66238;
(statearr_66245[(4)] = cljs.core.rest((state_66238[(4)])));

return statearr_66245;
})();
var state_66238__$1 = state_66238;
var statearr_66246_66314 = state_66238__$1;
(statearr_66246_66314[(2)] = inst_66226);

(statearr_66246_66314[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (1))){
var inst_66113 = (0);
var state_66238__$1 = (function (){var statearr_66247 = state_66238;
(statearr_66247[(7)] = inst_66113);

return statearr_66247;
})();
var statearr_66248_66315 = state_66238__$1;
(statearr_66248_66315[(2)] = null);

(statearr_66248_66315[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (24))){
var inst_66204 = (state_66238[(8)]);
var inst_66204__$1 = (state_66238[(2)]);
var inst_66205 = inst_66204__$1 === true;
var state_66238__$1 = (function (){var statearr_66249 = state_66238;
(statearr_66249[(8)] = inst_66204__$1);

return statearr_66249;
})();
if(cljs.core.truth_(inst_66205)){
var statearr_66250_66316 = state_66238__$1;
(statearr_66250_66316[(1)] = (25));

} else {
var statearr_66251_66317 = state_66238__$1;
(statearr_66251_66317[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (4))){
var inst_66116 = (state_66238[(9)]);
var inst_66116__$1 = (state_66238[(2)]);
var state_66238__$1 = (function (){var statearr_66252 = state_66238;
(statearr_66252[(9)] = inst_66116__$1);

return statearr_66252;
})();
if(cljs.core.truth_(inst_66116__$1)){
var statearr_66253_66318 = state_66238__$1;
(statearr_66253_66318[(1)] = (5));

} else {
var statearr_66254_66319 = state_66238__$1;
(statearr_66254_66319[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (15))){
var inst_66129 = (state_66238[(10)]);
var state_66238__$1 = state_66238;
var statearr_66255_66320 = state_66238__$1;
(statearr_66255_66320[(2)] = inst_66129);

(statearr_66255_66320[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (21))){
var inst_66161 = (state_66238[(11)]);
var inst_66153 = (state_66238[(12)]);
var inst_66156 = (state_66238[(13)]);
var inst_66155 = (state_66238[(14)]);
var inst_66116 = (state_66238[(9)]);
var inst_66113 = (state_66238[(7)]);
var inst_66154 = (state_66238[(15)]);
var inst_66152 = (state_66238[(16)]);
var inst_66160 = (state_66238[(17)]);
var inst_66157 = (state_66238[(18)]);
var inst_66163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66164 = [cljs.core.cst$kw$pending_DASH_req,inst_66160];
var inst_66165 = (new cljs.core.PersistentVector(null,2,(5),inst_66163,inst_66164,null));
var inst_66166 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_66165,inst_66155);
var inst_66193 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_66194 = (function (){var resp_chan = inst_66155;
var timeout = inst_66161;
var i = inst_66113;
var data = inst_66154;
var _ = inst_66152;
var req_id = inst_66160;
var operation = inst_66153;
var msg = inst_66116;
var map__66151 = inst_66157;
var c__10878__auto____$1 = inst_66193;
var vec__66148 = inst_66116;
var opts = inst_66156;
return (function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66191){
var state_val_66192 = (state_66191[(1)]);
if((state_val_66192 === (1))){
var inst_66170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66171 = cljs.core.async.timeout(timeout);
var inst_66172 = [resp_chan,inst_66171];
var inst_66173 = (new cljs.core.PersistentVector(null,2,(5),inst_66170,inst_66172,null));
var state_66191__$1 = state_66191;
return cljs.core.async.ioc_alts_BANG_(state_66191__$1,(2),inst_66173);
} else {
if((state_val_66192 === (2))){
var inst_66176 = (state_66191[(7)]);
var inst_66175 = (state_66191[(2)]);
var inst_66176__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66175,(0),null);
var inst_66177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66175,(1),null);
var inst_66178 = (function (){var vec__66167 = inst_66175;
var resp = inst_66176__$1;
var c = inst_66177;
return (function (p1__66112_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__66112_SHARP_,req_id);
});
})();
var inst_66179 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_66178);
var inst_66180 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66177,resp_chan);
var state_66191__$1 = (function (){var statearr_66256 = state_66191;
(statearr_66256[(8)] = inst_66179);

(statearr_66256[(7)] = inst_66176__$1);

return statearr_66256;
})();
if(inst_66180){
var statearr_66257_66321 = state_66191__$1;
(statearr_66257_66321[(1)] = (3));

} else {
var statearr_66258_66322 = state_66191__$1;
(statearr_66258_66322[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66192 === (3))){
var inst_66176 = (state_66191[(7)]);
var state_66191__$1 = state_66191;
var statearr_66259_66323 = state_66191__$1;
(statearr_66259_66323[(2)] = inst_66176);

(statearr_66259_66323[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66192 === (4))){
var inst_66183 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_66184 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_66185 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_66186 = cljs.core.PersistentHashMap.fromArrays(inst_66184,inst_66185);
var inst_66187 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66183,inst_66186);
var state_66191__$1 = state_66191;
var statearr_66260_66324 = state_66191__$1;
(statearr_66260_66324[(2)] = inst_66187);

(statearr_66260_66324[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66192 === (5))){
var inst_66189 = (state_66191[(2)]);
var state_66191__$1 = state_66191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66191__$1,inst_66189);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10841__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10841__auto____0 = (function (){
var statearr_66261 = [null,null,null,null,null,null,null,null,null];
(statearr_66261[(0)] = fluree$db$connection$msg_producer_$_state_machine__10841__auto__);

(statearr_66261[(1)] = (1));

return statearr_66261;
});
var fluree$db$connection$msg_producer_$_state_machine__10841__auto____1 = (function (state_66191){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66191);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66262){var ex__10844__auto__ = e66262;
var statearr_66263_66325 = state_66191;
(statearr_66263_66325[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66191[(4)]))){
var statearr_66264_66326 = state_66191;
(statearr_66264_66326[(1)] = cljs.core.first((state_66191[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66327 = state_66191;
state_66191 = G__66327;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10841__auto__ = function(state_66191){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10841__auto____1.call(this,state_66191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10841__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10841__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66265 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66265[(6)] = c__10878__auto____$1);

return statearr_66265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
});
})();
var inst_66195 = cljs.core.async.impl.dispatch.run(inst_66194);
var state_66238__$1 = (function (){var statearr_66266 = state_66238;
(statearr_66266[(19)] = inst_66195);

(statearr_66266[(20)] = inst_66166);

return statearr_66266;
})();
var statearr_66267_66328 = state_66238__$1;
(statearr_66267_66328[(2)] = inst_66193);

(statearr_66267_66328[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (31))){
var inst_66214 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_66238__$1 = state_66238;
var statearr_66268_66329 = state_66238__$1;
(statearr_66268_66329[(2)] = inst_66214);

(statearr_66268_66329[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (32))){
var state_66238__$1 = state_66238;
var statearr_66269_66330 = state_66238__$1;
(statearr_66269_66330[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (33))){
var inst_66222 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
var statearr_66271_66331 = state_66238__$1;
(statearr_66271_66331[(2)] = inst_66222);

(statearr_66271_66331[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (13))){
var inst_66129 = (state_66238[(10)]);
var inst_66126 = (state_66238[(2)]);
var inst_66127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66126,(0),null);
var inst_66128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66126,(1),null);
var inst_66129__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66126,(2),null);
var state_66238__$1 = (function (){var statearr_66272 = state_66238;
(statearr_66272[(21)] = inst_66127);

(statearr_66272[(22)] = inst_66128);

(statearr_66272[(10)] = inst_66129__$1);

return statearr_66272;
})();
if(cljs.core.truth_(inst_66129__$1)){
var statearr_66273_66332 = state_66238__$1;
(statearr_66273_66332[(1)] = (14));

} else {
var statearr_66274_66333 = state_66238__$1;
(statearr_66274_66333[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (22))){
var state_66238__$1 = state_66238;
var statearr_66275_66334 = state_66238__$1;
(statearr_66275_66334[(2)] = null);

(statearr_66275_66334[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (36))){
var inst_66220 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
var statearr_66276_66335 = state_66238__$1;
(statearr_66276_66335[(2)] = inst_66220);

(statearr_66276_66335[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (29))){
var inst_66204 = (state_66238[(8)]);
var inst_66212 = (inst_66204 == null);
var state_66238__$1 = state_66238;
if(cljs.core.truth_(inst_66212)){
var statearr_66277_66336 = state_66238__$1;
(statearr_66277_66336[(1)] = (31));

} else {
var statearr_66278_66337 = state_66238__$1;
(statearr_66278_66337[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (6))){
var state_66238__$1 = state_66238;
var statearr_66279_66338 = state_66238__$1;
(statearr_66279_66338[(2)] = null);

(statearr_66279_66338[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (28))){
var inst_66204 = (state_66238[(8)]);
var inst_66210 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66204,"Error processing message in producer."], 0));
var state_66238__$1 = state_66238;
var statearr_66280_66339 = state_66238__$1;
(statearr_66280_66339[(2)] = inst_66210);

(statearr_66280_66339[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (25))){
var state_66238__$1 = state_66238;
var statearr_66281_66340 = state_66238__$1;
(statearr_66281_66340[(2)] = null);

(statearr_66281_66340[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (34))){
var inst_66204 = (state_66238[(8)]);
var inst_66217 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_66204], 0));
var state_66238__$1 = state_66238;
var statearr_66282_66341 = state_66238__$1;
(statearr_66282_66341[(2)] = inst_66217);

(statearr_66282_66341[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (17))){
var inst_66129 = (state_66238[(10)]);
var inst_66118 = (state_66238[(23)]);
var inst_66136 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_66129,inst_66118);
var state_66238__$1 = state_66238;
var statearr_66283_66342 = state_66238__$1;
(statearr_66283_66342[(2)] = inst_66136);

(statearr_66283_66342[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (3))){
var inst_66236 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66238__$1,inst_66236);
} else {
if((state_val_66239 === (12))){
var state_66238__$1 = state_66238;
var statearr_66284_66343 = state_66238__$1;
(statearr_66284_66343[(2)] = null);

(statearr_66284_66343[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (2))){
var state_66238__$1 = state_66238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66238__$1,(4),req_chan);
} else {
if((state_val_66239 === (23))){
var inst_66153 = (state_66238[(12)]);
var inst_66154 = (state_66238[(15)]);
var inst_66160 = (state_66238[(17)]);
var inst_66198 = (state_66238[(2)]);
var inst_66199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66200 = [inst_66153,inst_66160,inst_66154];
var inst_66201 = (new cljs.core.PersistentVector(null,3,(5),inst_66199,inst_66200,null));
var inst_66202 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_66201) : publish_fn.call(null,conn,inst_66201));
var state_66238__$1 = (function (){var statearr_66285 = state_66238;
(statearr_66285[(24)] = inst_66198);

return statearr_66285;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66238__$1,(24),inst_66202);
} else {
if((state_val_66239 === (35))){
var state_66238__$1 = state_66238;
var statearr_66286_66344 = state_66238__$1;
(statearr_66286_66344[(2)] = null);

(statearr_66286_66344[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (19))){
var inst_66142 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
var statearr_66287_66345 = state_66238__$1;
(statearr_66287_66345[(2)] = inst_66142);

(statearr_66287_66345[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (11))){
var inst_66116 = (state_66238[(9)]);
var state_66238__$1 = state_66238;
var statearr_66288_66346 = state_66238__$1;
(statearr_66288_66346[(2)] = inst_66116);

(statearr_66288_66346[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (9))){
var inst_66113 = (state_66238[(7)]);
var inst_66229 = (state_66238[(2)]);
var inst_66230 = (inst_66113 + (1));
var inst_66113__$1 = inst_66230;
var state_66238__$1 = (function (){var statearr_66289 = state_66238;
(statearr_66289[(7)] = inst_66113__$1);

(statearr_66289[(25)] = inst_66229);

return statearr_66289;
})();
var statearr_66290_66347 = state_66238__$1;
(statearr_66290_66347[(2)] = null);

(statearr_66290_66347[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (5))){
var state_66238__$1 = state_66238;
var statearr_66291_66348 = state_66238__$1;
(statearr_66291_66348[(2)] = null);

(statearr_66291_66348[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (14))){
var inst_66129 = (state_66238[(10)]);
var inst_66131 = fluree.db.util.async.channel_QMARK_(inst_66129);
var state_66238__$1 = state_66238;
var statearr_66292_66349 = state_66238__$1;
(statearr_66292_66349[(2)] = inst_66131);

(statearr_66292_66349[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (26))){
var inst_66204 = (state_66238[(8)]);
var inst_66208 = fluree.db.util.core.exception_QMARK_(inst_66204);
var state_66238__$1 = state_66238;
if(inst_66208){
var statearr_66293_66350 = state_66238__$1;
(statearr_66293_66350[(1)] = (28));

} else {
var statearr_66294_66351 = state_66238__$1;
(statearr_66294_66351[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (16))){
var inst_66134 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
if(cljs.core.truth_(inst_66134)){
var statearr_66295_66352 = state_66238__$1;
(statearr_66295_66352[(1)] = (17));

} else {
var statearr_66296_66353 = state_66238__$1;
(statearr_66296_66353[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (30))){
var inst_66224 = (state_66238[(2)]);
var state_66238__$1 = state_66238;
var statearr_66297_66354 = state_66238__$1;
(statearr_66297_66354[(2)] = inst_66224);

(statearr_66297_66354[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (10))){
var inst_66116 = (state_66238[(9)]);
var inst_66118 = (state_66238[(2)]);
var inst_66122 = cljs.core.sequential_QMARK_(inst_66116);
var state_66238__$1 = (function (){var statearr_66298 = state_66238;
(statearr_66298[(23)] = inst_66118);

return statearr_66298;
})();
if(inst_66122){
var statearr_66299_66355 = state_66238__$1;
(statearr_66299_66355[(1)] = (11));

} else {
var statearr_66300_66356 = state_66238__$1;
(statearr_66300_66356[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (18))){
var inst_66116 = (state_66238[(9)]);
var inst_66118 = (state_66238[(23)]);
var inst_66138 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66116], 0));
var inst_66139 = ["Error processing ledger request, no valid return channel: ",inst_66138].join('');
var inst_66140 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66118,inst_66139], 0));
var state_66238__$1 = state_66238;
var statearr_66301_66357 = state_66238__$1;
(statearr_66301_66357[(2)] = inst_66140);

(statearr_66301_66357[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66239 === (8))){
var inst_66156 = (state_66238[(13)]);
var inst_66155 = (state_66238[(14)]);
var inst_66116 = (state_66238[(9)]);
var inst_66157 = (state_66238[(18)]);
var _ = (function (){var statearr_66302 = state_66238;
(statearr_66302[(4)] = cljs.core.cons((20),(state_66238[(4)])));

return statearr_66302;
})();
var inst_66152 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_66116], 0));
var inst_66153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66116,(0),null);
var inst_66154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66116,(1),null);
var inst_66155__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66116,(2),null);
var inst_66156__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66116,(3),null);
var inst_66157__$1 = cljs.core.__destructure_map(inst_66156__$1);
var inst_66158 = fluree.db.util.core.random_uuid();
var inst_66159 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66158);
var inst_66160 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66157__$1,cljs.core.cst$kw$req_DASH_id,inst_66159);
var inst_66161 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66157__$1,cljs.core.cst$kw$timeout,(60000));
var state_66238__$1 = (function (){var statearr_66303 = state_66238;
(statearr_66303[(11)] = inst_66161);

(statearr_66303[(12)] = inst_66153);

(statearr_66303[(13)] = inst_66156__$1);

(statearr_66303[(14)] = inst_66155__$1);

(statearr_66303[(15)] = inst_66154);

(statearr_66303[(16)] = inst_66152);

(statearr_66303[(17)] = inst_66160);

(statearr_66303[(18)] = inst_66157__$1);

return statearr_66303;
})();
if(cljs.core.truth_(inst_66155__$1)){
var statearr_66304_66358 = state_66238__$1;
(statearr_66304_66358[(1)] = (21));

} else {
var statearr_66305_66359 = state_66238__$1;
(statearr_66305_66359[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__10841__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__10841__auto____0 = (function (){
var statearr_66306 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66306[(0)] = fluree$db$connection$msg_producer_$_state_machine__10841__auto__);

(statearr_66306[(1)] = (1));

return statearr_66306;
});
var fluree$db$connection$msg_producer_$_state_machine__10841__auto____1 = (function (state_66238){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66238);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66307){var ex__10844__auto__ = e66307;
var statearr_66308_66360 = state_66238;
(statearr_66308_66360[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66238[(4)]))){
var statearr_66309_66361 = state_66238;
(statearr_66309_66361[(1)] = cljs.core.first((state_66238[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66362 = state_66238;
state_66238 = G__66362;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__10841__auto__ = function(state_66238){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__10841__auto____1.call(this,state_66238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__10841__auto____0;
fluree$db$connection$msg_producer_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__10841__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66310 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66310[(6)] = c__10878__auto__);

return statearr_66310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__66363 = conn;
var map__66363__$1 = cljs.core.__destructure_map(map__66363);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66363__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66445){
var state_val_66446 = (state_66445[(1)]);
if((state_val_66446 === (7))){
var inst_66441 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66447_66498 = state_66445__$1;
(statearr_66447_66498[(2)] = inst_66441);

(statearr_66447_66498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (20))){
var inst_66382 = (state_66445[(7)]);
var inst_66396 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_66397 = [inst_66382];
var inst_66398 = cljs.core.PersistentHashMap.fromArrays(inst_66396,inst_66397);
var inst_66399 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_66398], 0));
var state_66445__$1 = state_66445;
var statearr_66448_66499 = state_66445__$1;
(statearr_66448_66499[(2)] = inst_66399);

(statearr_66448_66499[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (27))){
var state_66445__$1 = state_66445;
var statearr_66449_66500 = state_66445__$1;
(statearr_66449_66500[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (1))){
var inst_66364 = (0);
var state_66445__$1 = (function (){var statearr_66451 = state_66445;
(statearr_66451[(8)] = inst_66364);

return statearr_66451;
})();
var statearr_66452_66501 = state_66445__$1;
(statearr_66452_66501[(2)] = null);

(statearr_66452_66501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (24))){
var inst_66375 = (state_66445[(9)]);
var inst_66424 = fluree.db.util.core.exception_QMARK_(inst_66375);
var state_66445__$1 = state_66445;
if(inst_66424){
var statearr_66453_66502 = state_66445__$1;
(statearr_66453_66502[(1)] = (26));

} else {
var statearr_66454_66503 = state_66445__$1;
(statearr_66454_66503[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (4))){
var inst_66369 = (state_66445[(10)]);
var inst_66374 = (state_66445[(2)]);
var inst_66375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66374,(0),null);
var inst_66376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66374,(1),null);
var inst_66377 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66376,inst_66369);
var state_66445__$1 = (function (){var statearr_66455 = state_66445;
(statearr_66455[(9)] = inst_66375);

return statearr_66455;
})();
if(inst_66377){
var statearr_66456_66504 = state_66445__$1;
(statearr_66456_66504[(1)] = (5));

} else {
var statearr_66457_66505 = state_66445__$1;
(statearr_66457_66505[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (15))){
var inst_66382 = (state_66445[(7)]);
var inst_66391 = typeof inst_66382 === 'string';
var state_66445__$1 = state_66445;
if(cljs.core.truth_(inst_66391)){
var statearr_66458_66506 = state_66445__$1;
(statearr_66458_66506[(1)] = (17));

} else {
var statearr_66459_66507 = state_66445__$1;
(statearr_66459_66507[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (21))){
var state_66445__$1 = state_66445;
var statearr_66460_66508 = state_66445__$1;
(statearr_66460_66508[(2)] = null);

(statearr_66460_66508[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (31))){
var inst_66435 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66461_66509 = state_66445__$1;
(statearr_66461_66509[(2)] = inst_66435);

(statearr_66461_66509[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (13))){
var inst_66408 = (state_66445[(2)]);
var inst_66409 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66410 = fluree.db.connection.close_websocket(inst_66409);
var inst_66411 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66412 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_66411);
var state_66445__$1 = (function (){var statearr_66462 = state_66445;
(statearr_66462[(11)] = inst_66410);

(statearr_66462[(12)] = inst_66408);

return statearr_66462;
})();
var statearr_66463_66510 = state_66445__$1;
(statearr_66463_66510[(2)] = inst_66412);

(statearr_66463_66510[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (22))){
var inst_66402 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66464_66511 = state_66445__$1;
(statearr_66464_66511[(2)] = inst_66402);

(statearr_66464_66511[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (29))){
var inst_66375 = (state_66445[(9)]);
var inst_66430 = fluree.db.util.json.parse(inst_66375);
var inst_66431 = fluree.db.conn_events.process_events(conn,inst_66430);
var inst_66364 = (0);
var state_66445__$1 = (function (){var statearr_66465 = state_66445;
(statearr_66465[(8)] = inst_66364);

(statearr_66465[(13)] = inst_66431);

return statearr_66465;
})();
var statearr_66466_66512 = state_66445__$1;
(statearr_66466_66512[(2)] = null);

(statearr_66466_66512[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (6))){
var inst_66375 = (state_66445[(9)]);
var inst_66420 = (inst_66375 == null);
var state_66445__$1 = state_66445;
if(cljs.core.truth_(inst_66420)){
var statearr_66467_66513 = state_66445__$1;
(statearr_66467_66513[(1)] = (23));

} else {
var statearr_66468_66514 = state_66445__$1;
(statearr_66468_66514[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (28))){
var inst_66437 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66469_66515 = state_66445__$1;
(statearr_66469_66515[(2)] = inst_66437);

(statearr_66469_66515[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (25))){
var inst_66439 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66470_66516 = state_66445__$1;
(statearr_66470_66516[(2)] = inst_66439);

(statearr_66470_66516[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (17))){
var inst_66382 = (state_66445[(7)]);
var inst_66393 = cljs.core.eval(inst_66382);
var state_66445__$1 = state_66445;
var statearr_66471_66517 = state_66445__$1;
(statearr_66471_66517[(2)] = inst_66393);

(statearr_66471_66517[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (3))){
var inst_66443 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66445__$1,inst_66443);
} else {
if((state_val_66446 === (12))){
var inst_66382 = (state_66445[(7)]);
var inst_66387 = cljs.core.fn_QMARK_(inst_66382);
var state_66445__$1 = state_66445;
if(inst_66387){
var statearr_66472_66518 = state_66445__$1;
(statearr_66472_66518[(1)] = (14));

} else {
var statearr_66473_66519 = state_66445__$1;
(statearr_66473_66519[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (2))){
var inst_66369 = (state_66445[(10)]);
var inst_66369__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_66370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66371 = [sub_chan,inst_66369__$1];
var inst_66372 = (new cljs.core.PersistentVector(null,2,(5),inst_66370,inst_66371,null));
var state_66445__$1 = (function (){var statearr_66474 = state_66445;
(statearr_66474[(10)] = inst_66369__$1);

return statearr_66474;
})();
return cljs.core.async.ioc_alts_BANG_(state_66445__$1,(4),inst_66372);
} else {
if((state_val_66446 === (23))){
var inst_66422 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_66445__$1 = state_66445;
var statearr_66475_66520 = state_66445__$1;
(statearr_66475_66520[(2)] = inst_66422);

(statearr_66475_66520[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (19))){
var inst_66404 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66476_66521 = state_66445__$1;
(statearr_66476_66521[(2)] = inst_66404);

(statearr_66476_66521[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (11))){
var inst_66385 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_66445__$1 = state_66445;
var statearr_66477_66522 = state_66445__$1;
(statearr_66477_66522[(2)] = inst_66385);

(statearr_66477_66522[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (9))){
var inst_66364 = (state_66445[(8)]);
var inst_66414 = fluree.db.connection.ping_transactor(conn);
var inst_66415 = (inst_66364 + (1));
var inst_66364__$1 = inst_66415;
var state_66445__$1 = (function (){var statearr_66478 = state_66445;
(statearr_66478[(14)] = inst_66414);

(statearr_66478[(8)] = inst_66364__$1);

return statearr_66478;
})();
var statearr_66479_66523 = state_66445__$1;
(statearr_66479_66523[(2)] = null);

(statearr_66479_66523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (5))){
var inst_66364 = (state_66445[(8)]);
var inst_66379 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_66364);
var state_66445__$1 = state_66445;
if(inst_66379){
var statearr_66480_66524 = state_66445__$1;
(statearr_66480_66524[(1)] = (8));

} else {
var statearr_66481_66525 = state_66445__$1;
(statearr_66481_66525[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (14))){
var inst_66382 = (state_66445[(7)]);
var inst_66389 = (inst_66382.cljs$core$IFn$_invoke$arity$0 ? inst_66382.cljs$core$IFn$_invoke$arity$0() : inst_66382.call(null));
var state_66445__$1 = state_66445;
var statearr_66482_66526 = state_66445__$1;
(statearr_66482_66526[(2)] = inst_66389);

(statearr_66482_66526[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (26))){
var inst_66375 = (state_66445[(9)]);
var inst_66426 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66375], 0));
var inst_66364 = (0);
var state_66445__$1 = (function (){var statearr_66483 = state_66445;
(statearr_66483[(15)] = inst_66426);

(statearr_66483[(8)] = inst_66364);

return statearr_66483;
})();
var statearr_66484_66527 = state_66445__$1;
(statearr_66484_66527[(2)] = null);

(statearr_66484_66527[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (16))){
var inst_66406 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66485_66528 = state_66445__$1;
(statearr_66485_66528[(2)] = inst_66406);

(statearr_66485_66528[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (30))){
var state_66445__$1 = state_66445;
var statearr_66486_66529 = state_66445__$1;
(statearr_66486_66529[(2)] = null);

(statearr_66486_66529[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (10))){
var inst_66418 = (state_66445[(2)]);
var state_66445__$1 = state_66445;
var statearr_66487_66530 = state_66445__$1;
(statearr_66487_66530[(2)] = inst_66418);

(statearr_66487_66530[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (18))){
var state_66445__$1 = state_66445;
var statearr_66488_66531 = state_66445__$1;
(statearr_66488_66531[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_66446 === (8))){
var inst_66382 = (state_66445[(7)]);
var inst_66381 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_66382__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66383 = (inst_66382__$1 == null);
var state_66445__$1 = (function (){var statearr_66490 = state_66445;
(statearr_66490[(16)] = inst_66381);

(statearr_66490[(7)] = inst_66382__$1);

return statearr_66490;
})();
if(cljs.core.truth_(inst_66383)){
var statearr_66491_66532 = state_66445__$1;
(statearr_66491_66532[(1)] = (11));

} else {
var statearr_66492_66533 = state_66445__$1;
(statearr_66492_66533[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__10841__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__10841__auto____0 = (function (){
var statearr_66493 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66493[(0)] = fluree$db$connection$msg_consumer_$_state_machine__10841__auto__);

(statearr_66493[(1)] = (1));

return statearr_66493;
});
var fluree$db$connection$msg_consumer_$_state_machine__10841__auto____1 = (function (state_66445){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66445);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66494){var ex__10844__auto__ = e66494;
var statearr_66495_66534 = state_66445;
(statearr_66495_66534[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66445[(4)]))){
var statearr_66496_66535 = state_66445;
(statearr_66496_66535[(1)] = cljs.core.first((state_66445[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66536 = state_66445;
state_66445 = G__66536;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__10841__auto__ = function(state_66445){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__10841__auto____1.call(this,state_66445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__10841__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__10841__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66497 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66497[(6)] = c__10878__auto__);

return statearr_66497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__66538 = arguments.length;
switch (G__66538) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__66539 = opts;
var map__66539__$1 = cljs.core.__destructure_map(map__66539);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66539__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66539__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66591){
var state_val_66592 = (state_66591[(1)]);
if((state_val_66592 === (7))){
var inst_66549 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_66550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66551 = [conn_id,cljs.core.cst$kw$token];
var inst_66552 = (new cljs.core.PersistentVector(null,2,(5),inst_66550,inst_66551,null));
var inst_66553 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_66549,inst_66552);
var state_66591__$1 = state_66591;
var statearr_66593_66624 = state_66591__$1;
(statearr_66593_66624[(2)] = inst_66553);

(statearr_66593_66624[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (1))){
var state_66591__$1 = state_66591;
var statearr_66594_66625 = state_66591__$1;
(statearr_66594_66625[(2)] = null);

(statearr_66594_66625[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (4))){
var inst_66540 = (state_66591[(2)]);
var state_66591__$1 = state_66591;
var statearr_66595_66626 = state_66591__$1;
(statearr_66595_66626[(2)] = inst_66540);

(statearr_66595_66626[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (15))){
var inst_66560 = (state_66591[(7)]);
var inst_66579 = (state_66591[(2)]);
var inst_66580 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_66581 = [(5000),inst_66579,cljs.core.cst$kw$text];
var inst_66582 = cljs.core.PersistentHashMap.fromArrays(inst_66580,inst_66581);
var inst_66583 = fluree.db.util.xhttp.get(inst_66560,inst_66582);
var state_66591__$1 = state_66591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66591__$1,(16),inst_66583);
} else {
if((state_val_66592 === (13))){
var inst_66570 = (state_66591[(8)]);
var inst_66560 = (state_66591[(7)]);
var inst_66572 = [cljs.core.cst$kw$headers];
var inst_66573 = [inst_66570];
var inst_66574 = cljs.core.PersistentHashMap.fromArrays(inst_66572,inst_66573);
var inst_66575 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_66560,inst_66574,private$);
var inst_66576 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_66575);
var state_66591__$1 = state_66591;
var statearr_66596_66627 = state_66591__$1;
(statearr_66596_66627[(2)] = inst_66576);

(statearr_66596_66627[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (6))){
var inst_66546 = (state_66591[(9)]);
var state_66591__$1 = state_66591;
var statearr_66597_66628 = state_66591__$1;
(statearr_66597_66628[(2)] = inst_66546);

(statearr_66597_66628[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (3))){
var inst_66589 = (state_66591[(2)]);
var state_66591__$1 = state_66591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66591__$1,inst_66589);
} else {
if((state_val_66592 === (12))){
var inst_66570 = (state_66591[(2)]);
var state_66591__$1 = (function (){var statearr_66598 = state_66591;
(statearr_66598[(8)] = inst_66570);

return statearr_66598;
})();
if(cljs.core.truth_(private$)){
var statearr_66599_66629 = state_66591__$1;
(statearr_66599_66629[(1)] = (13));

} else {
var statearr_66600_66630 = state_66591__$1;
(statearr_66600_66630[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (2))){
var inst_66546 = (state_66591[(9)]);
var _ = (function (){var statearr_66601 = state_66591;
(statearr_66601[(4)] = cljs.core.cons((5),(state_66591[(4)])));

return statearr_66601;
})();
var inst_66546__$1 = jwt;
var state_66591__$1 = (function (){var statearr_66602 = state_66591;
(statearr_66602[(9)] = inst_66546__$1);

return statearr_66602;
})();
if(cljs.core.truth_(inst_66546__$1)){
var statearr_66603_66631 = state_66591__$1;
(statearr_66603_66631[(1)] = (6));

} else {
var statearr_66604_66632 = state_66591__$1;
(statearr_66604_66632[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (11))){
var inst_66564 = (state_66591[(10)]);
var state_66591__$1 = state_66591;
var statearr_66606_66633 = state_66591__$1;
(statearr_66606_66633[(2)] = inst_66564);

(statearr_66606_66633[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (9))){
var inst_66556 = (state_66591[(11)]);
var inst_66555 = (state_66591[(12)]);
var inst_66559 = (state_66591[(2)]);
var inst_66560 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66559),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66556)].join('');
var inst_66562 = ["Accept"];
var inst_66563 = ["application/json"];
var inst_66564 = cljs.core.PersistentHashMap.fromArrays(inst_66562,inst_66563);
var state_66591__$1 = (function (){var statearr_66607 = state_66591;
(statearr_66607[(7)] = inst_66560);

(statearr_66607[(10)] = inst_66564);

return statearr_66607;
})();
if(cljs.core.truth_(inst_66555)){
var statearr_66608_66634 = state_66591__$1;
(statearr_66608_66634[(1)] = (10));

} else {
var statearr_66609_66635 = state_66591__$1;
(statearr_66609_66635[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (5))){
var _ = (function (){var statearr_66610 = state_66591;
(statearr_66610[(4)] = cljs.core.rest((state_66591[(4)])));

return statearr_66610;
})();
var state_66591__$1 = state_66591;
var ex66605 = (state_66591__$1[(2)]);
var statearr_66611_66636 = state_66591__$1;
(statearr_66611_66636[(5)] = ex66605);


if((ex66605 instanceof Error)){
var statearr_66612_66637 = state_66591__$1;
(statearr_66612_66637[(1)] = (4));

(statearr_66612_66637[(5)] = null);

} else {
throw ex66605;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (14))){
var inst_66570 = (state_66591[(8)]);
var state_66591__$1 = state_66591;
var statearr_66613_66638 = state_66591__$1;
(statearr_66613_66638[(2)] = inst_66570);

(statearr_66613_66638[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (16))){
var inst_66585 = (state_66591[(2)]);
var inst_66586 = fluree.db.util.async.throw_err(inst_66585);
var _ = (function (){var statearr_66614 = state_66591;
(statearr_66614[(4)] = cljs.core.rest((state_66591[(4)])));

return statearr_66614;
})();
var state_66591__$1 = state_66591;
var statearr_66615_66639 = state_66591__$1;
(statearr_66615_66639[(2)] = inst_66586);

(statearr_66615_66639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (10))){
var inst_66555 = (state_66591[(12)]);
var inst_66564 = (state_66591[(10)]);
var inst_66566 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66555)].join('');
var inst_66567 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66564,"Authorization",inst_66566);
var state_66591__$1 = state_66591;
var statearr_66616_66640 = state_66591__$1;
(statearr_66616_66640[(2)] = inst_66567);

(statearr_66616_66640[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66592 === (8))){
var inst_66555 = (state_66591[(2)]);
var inst_66556 = clojure.string.replace(k,"_","/");
var inst_66557 = fluree.db.connection.get_server(conn_id,servers);
var state_66591__$1 = (function (){var statearr_66617 = state_66591;
(statearr_66617[(11)] = inst_66556);

(statearr_66617[(12)] = inst_66555);

return statearr_66617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66591__$1,(9),inst_66557);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10841__auto__ = null;
var fluree$db$connection$state_machine__10841__auto____0 = (function (){
var statearr_66618 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66618[(0)] = fluree$db$connection$state_machine__10841__auto__);

(statearr_66618[(1)] = (1));

return statearr_66618;
});
var fluree$db$connection$state_machine__10841__auto____1 = (function (state_66591){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66591);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66619){var ex__10844__auto__ = e66619;
var statearr_66620_66641 = state_66591;
(statearr_66620_66641[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66591[(4)]))){
var statearr_66621_66642 = state_66591;
(statearr_66621_66642[(1)] = cljs.core.first((state_66591[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66643 = state_66591;
state_66591 = G__66643;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10841__auto__ = function(state_66591){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10841__auto____1.call(this,state_66591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10841__auto____0;
fluree$db$connection$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10841__auto____1;
return fluree$db$connection$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66622 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66622[(6)] = c__10878__auto__);

return statearr_66622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__66644_SHARP_){
if(cljs.core.truth_(p1__66644_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__66645_SHARP_){
var or__4223__auto__ = p1__66645_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e66646){var e = e66646;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__66647 = opts;
var map__66647__$1 = cljs.core.__destructure_map(map__66647);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__66647__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66647__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__66648_66649 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__66648_66649.cljs$core$IFn$_invoke$arity$0 ? fexpr__66648_66649.cljs$core$IFn$_invoke$arity$0() : fexpr__66648_66649.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66690 = arguments.length;
var i__4830__auto___66691 = (0);
while(true){
if((i__4830__auto___66691 < len__4829__auto___66690)){
args__4835__auto__.push((arguments[i__4830__auto___66691]));

var G__66692 = (i__4830__auto___66691 + (1));
i__4830__auto___66691 = G__66692;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__66652){
var vec__66653 = p__66652;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66653,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__10878__auto___66693 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66673){
var state_val_66674 = (state_66673[(1)]);
if((state_val_66674 === (1))){
var inst_66656 = fluree.db.connection.get_socket(conn);
var state_66673__$1 = state_66673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66673__$1,(2),inst_66656);
} else {
if((state_val_66674 === (2))){
var inst_66659 = (state_66673[(7)]);
var inst_66658 = (state_66673[(8)]);
var inst_66658__$1 = (state_66673[(2)]);
var inst_66659__$1 = (inst_66658__$1 == null);
var state_66673__$1 = (function (){var statearr_66675 = state_66673;
(statearr_66675[(7)] = inst_66659__$1);

(statearr_66675[(8)] = inst_66658__$1);

return statearr_66675;
})();
if(cljs.core.truth_(inst_66659__$1)){
var statearr_66676_66694 = state_66673__$1;
(statearr_66676_66694[(1)] = (3));

} else {
var statearr_66677_66695 = state_66673__$1;
(statearr_66677_66695[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66674 === (3))){
var inst_66659 = (state_66673[(7)]);
var state_66673__$1 = state_66673;
var statearr_66678_66696 = state_66673__$1;
(statearr_66678_66696[(2)] = inst_66659);

(statearr_66678_66696[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66674 === (4))){
var inst_66658 = (state_66673[(8)]);
var inst_66662 = fluree.db.util.core.exception_QMARK_(inst_66658);
var state_66673__$1 = state_66673;
var statearr_66679_66697 = state_66673__$1;
(statearr_66679_66697[(2)] = inst_66662);

(statearr_66679_66697[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66674 === (5))){
var inst_66664 = (state_66673[(2)]);
var state_66673__$1 = state_66673;
if(cljs.core.truth_(inst_66664)){
var statearr_66680_66698 = state_66673__$1;
(statearr_66680_66698[(1)] = (6));

} else {
var statearr_66681_66699 = state_66673__$1;
(statearr_66681_66699[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66674 === (6))){
var inst_66666 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_66667 = cljs.core.async.close_BANG_(conn);
var state_66673__$1 = (function (){var statearr_66682 = state_66673;
(statearr_66682[(9)] = inst_66666);

return statearr_66682;
})();
var statearr_66683_66700 = state_66673__$1;
(statearr_66683_66700[(2)] = inst_66667);

(statearr_66683_66700[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66674 === (7))){
var inst_66669 = fluree.db.connection.msg_consumer(conn);
var state_66673__$1 = state_66673;
var statearr_66684_66701 = state_66673__$1;
(statearr_66684_66701[(2)] = inst_66669);

(statearr_66684_66701[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66674 === (8))){
var inst_66671 = (state_66673[(2)]);
var state_66673__$1 = state_66673;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66673__$1,inst_66671);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__10841__auto__ = null;
var fluree$db$connection$state_machine__10841__auto____0 = (function (){
var statearr_66685 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66685[(0)] = fluree$db$connection$state_machine__10841__auto__);

(statearr_66685[(1)] = (1));

return statearr_66685;
});
var fluree$db$connection$state_machine__10841__auto____1 = (function (state_66673){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66673);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66686){var ex__10844__auto__ = e66686;
var statearr_66687_66702 = state_66673;
(statearr_66687_66702[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66673[(4)]))){
var statearr_66688_66703 = state_66673;
(statearr_66688_66703[(1)] = cljs.core.first((state_66673[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66704 = state_66673;
state_66673 = G__66704;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$connection$state_machine__10841__auto__ = function(state_66673){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__10841__auto____1.call(this,state_66673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__10841__auto____0;
fluree$db$connection$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__10841__auto____1;
return fluree$db$connection$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66689 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66689[(6)] = c__10878__auto___66693);

return statearr_66689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq66650){
var G__66651 = cljs.core.first(seq66650);
var seq66650__$1 = cljs.core.next(seq66650);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66651,seq66650__$1);
}));

