// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4221__auto__ = typeof value === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4221__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,300,null,300,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,714,null,714,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,230,null,230,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,157,null,157,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,812,null,812,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,521,null,521,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,427,null,427,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,145,null,145,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,388,null,388,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,256,null,256,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,86,null,86,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,726,null,726,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,533,null,533,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,607,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,620,null,620,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,750,null,750,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,98,null,98,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,169,null,169,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,778,null,778,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,696,null,696,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,414,null,414,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,466,null,466,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,788,null,788,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,73,null,73,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,188,null,188,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,568,null,568,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,375,null,375,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,659,null,659,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,453,null,453,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,109,null,109,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,594,null,594,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,506,null,506,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,332,332,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,558,null,558,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,545,null,545,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,800,null,800,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,440,null,440,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,270,null,270,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,121,null,121,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,401,null,401,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,581,null,581,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,762,null,762,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,347,347,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,684,null,684,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,214,null,214,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,58,null,58,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,133,null,133,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,633,null,633,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,201,null,201,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,646,null,646,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,479,null,479,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,288,null,288,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,738,null,738,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,313,null,313,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,243,null,243,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/home/zonotope/code/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,671,null,671,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__67113 = cljs.core.meta(f);
var map__67113__$1 = cljs.core.__destructure_map(map__67113);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67113__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67113__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4221__auto__ = (function (){var G__67115 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__67114 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__67114.cljs$core$IFn$_invoke$arity$1 ? fexpr__67114.cljs$core$IFn$_invoke$arity$1(G__67115) : fexpr__67114.call(null,G__67115));
})();
if(cljs.core.truth_(and__4221__auto__)){
var G__67117 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__67116 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__67116.cljs$core$IFn$_invoke$arity$1 ? fexpr__67116.cljs$core$IFn$_invoke$arity$1(G__67117) : fexpr__67116.call(null,G__67117));
} else {
return and__4221__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__67112_SHARP_){
return (cljs.core.count(p1__67112_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_67202){
var state_val_67203 = (state_67202[(1)]);
if((state_val_67203 === (7))){
var inst_67127 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_67128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67129 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_67130 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_67131 = [fn_name,inst_67129,inst_67130];
var inst_67132 = (new cljs.core.PersistentVector(null,3,(5),inst_67128,inst_67131,null));
var inst_67133 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67127,inst_67132);
var state_67202__$1 = state_67202;
var statearr_67204_67241 = state_67202__$1;
(statearr_67204_67241[(2)] = inst_67133);

(statearr_67204_67241[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (1))){
var state_67202__$1 = state_67202;
var statearr_67205_67242 = state_67202__$1;
(statearr_67205_67242[(2)] = null);

(statearr_67205_67242[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (4))){
var inst_67118 = (state_67202[(2)]);
var state_67202__$1 = state_67202;
var statearr_67206_67243 = state_67202__$1;
(statearr_67206_67243[(2)] = inst_67118);

(statearr_67206_67243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (15))){
var inst_67165 = (state_67202[(7)]);
var inst_67151 = (state_67202[(8)]);
var inst_67163 = (state_67202[(2)]);
var inst_67164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67151,"_fn/params");
var inst_67165__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_67164);
var inst_67166 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67151,"_fn/code");
var inst_67167 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_67166);
var inst_67168 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_67167,funType,inst_67165__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_67167,funType,inst_67165__$1));
var state_67202__$1 = (function (){var statearr_67207 = state_67202;
(statearr_67207[(7)] = inst_67165__$1);

(statearr_67207[(9)] = inst_67163);

return statearr_67207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67202__$1,(16),inst_67168);
} else {
if((state_val_67203 === (13))){
var inst_67154 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_67155 = ["Unknown function: ",inst_67154].join('');
var inst_67156 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_67157 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_67158 = cljs.core.PersistentHashMap.fromArrays(inst_67156,inst_67157);
var inst_67159 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67155,inst_67158);
var inst_67160 = (function(){throw inst_67159})();
var state_67202__$1 = state_67202;
var statearr_67208_67244 = state_67202__$1;
(statearr_67208_67244[(2)] = inst_67160);

(statearr_67208_67244[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (6))){
var state_67202__$1 = state_67202;
var statearr_67209_67245 = state_67202__$1;
(statearr_67209_67245[(2)] = null);

(statearr_67209_67245[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (17))){
var state_67202__$1 = state_67202;
var statearr_67210_67246 = state_67202__$1;
(statearr_67210_67246[(2)] = null);

(statearr_67210_67246[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (3))){
var inst_67200 = (state_67202[(2)]);
var state_67202__$1 = state_67202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67202__$1,inst_67200);
} else {
if((state_val_67203 === (12))){
var inst_67151 = (state_67202[(8)]);
var inst_67150 = (state_67202[(2)]);
var inst_67151__$1 = fluree.db.util.async.throw_err(inst_67150);
var inst_67152 = cljs.core.empty_QMARK_(inst_67151__$1);
var state_67202__$1 = (function (){var statearr_67211 = state_67202;
(statearr_67211[(8)] = inst_67151__$1);

return statearr_67211;
})();
if(inst_67152){
var statearr_67212_67247 = state_67202__$1;
(statearr_67212_67247[(1)] = (13));

} else {
var statearr_67213_67248 = state_67202__$1;
(statearr_67213_67248[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (2))){
var inst_67124 = (state_67202[(10)]);
var _ = (function (){var statearr_67214 = state_67202;
(statearr_67214[(4)] = cljs.core.cons((5),(state_67202[(4)])));

return statearr_67214;
})();
var inst_67124__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_67202__$1 = (function (){var statearr_67215 = state_67202;
(statearr_67215[(10)] = inst_67124__$1);

return statearr_67215;
})();
if(cljs.core.truth_(inst_67124__$1)){
var statearr_67216_67249 = state_67202__$1;
(statearr_67216_67249[(1)] = (6));

} else {
var statearr_67217_67250 = state_67202__$1;
(statearr_67217_67250[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (19))){
var inst_67185 = (state_67202[(11)]);
var inst_67195 = (state_67202[(2)]);
var state_67202__$1 = (function (){var statearr_67218 = state_67202;
(statearr_67218[(12)] = inst_67195);

return statearr_67218;
})();
var statearr_67219_67251 = state_67202__$1;
(statearr_67219_67251[(2)] = inst_67185);

(statearr_67219_67251[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (11))){
var inst_67197 = (state_67202[(2)]);
var _ = (function (){var statearr_67221 = state_67202;
(statearr_67221[(4)] = cljs.core.rest((state_67202[(4)])));

return statearr_67221;
})();
var state_67202__$1 = state_67202;
var statearr_67222_67252 = state_67202__$1;
(statearr_67222_67252[(2)] = inst_67197);

(statearr_67222_67252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (9))){
var inst_67135 = (state_67202[(13)]);
var state_67202__$1 = state_67202;
var statearr_67223_67253 = state_67202__$1;
(statearr_67223_67253[(2)] = inst_67135);

(statearr_67223_67253[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (5))){
var _ = (function (){var statearr_67224 = state_67202;
(statearr_67224[(4)] = cljs.core.rest((state_67202[(4)])));

return statearr_67224;
})();
var state_67202__$1 = state_67202;
var ex67220 = (state_67202__$1[(2)]);
var statearr_67225_67254 = state_67202__$1;
(statearr_67225_67254[(5)] = ex67220);


if((ex67220 instanceof Error)){
var statearr_67226_67255 = state_67202__$1;
(statearr_67226_67255[(1)] = (4));

(statearr_67226_67255[(5)] = null);

} else {
throw ex67220;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (14))){
var state_67202__$1 = state_67202;
var statearr_67227_67256 = state_67202__$1;
(statearr_67227_67256[(2)] = null);

(statearr_67227_67256[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (16))){
var inst_67135 = (state_67202[(13)]);
var inst_67165 = (state_67202[(7)]);
var inst_67124 = (state_67202[(10)]);
var inst_67163 = (state_67202[(9)]);
var inst_67151 = (state_67202[(8)]);
var inst_67147 = (state_67202[(14)]);
var inst_67170 = (state_67202[(2)]);
var inst_67171 = fluree.db.util.async.throw_err(inst_67170);
var inst_67172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67151,"_fn/spec");
var inst_67173 = cljs.core.PersistentVector.EMPTY;
var inst_67174 = cljs.core.cst$sym$_QMARK_ctx;
var inst_67175 = (function (){var forward_time_travel_db_QMARK_ = inst_67124;
var or__4223__auto__ = inst_67135;
var query = inst_67147;
var res = inst_67151;
var _ = inst_67163;
var params = inst_67165;
var code = inst_67171;
var spec = inst_67172;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_67176 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_67175,inst_67165);
var inst_67177 = cljs.core.cons(inst_67174,inst_67176);
var inst_67178 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_67173,inst_67177);
var inst_67179 = fluree.db.dbfunctions.core.build_fn(inst_67178,inst_67171);
var inst_67180 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_67181 = cljs.core.count(inst_67165);
var inst_67182 = [inst_67181];
var inst_67183 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_67182);
var inst_67184 = [inst_67179,inst_67165,inst_67183,false,inst_67172,null];
var inst_67185 = cljs.core.PersistentHashMap.fromArrays(inst_67180,inst_67184);
var state_67202__$1 = (function (){var statearr_67228 = state_67202;
(statearr_67228[(11)] = inst_67185);

return statearr_67228;
})();
if(cljs.core.truth_(inst_67124)){
var statearr_67229_67257 = state_67202__$1;
(statearr_67229_67257[(1)] = (17));

} else {
var statearr_67230_67258 = state_67202__$1;
(statearr_67230_67258[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (10))){
var inst_67147 = (state_67202[(14)]);
var inst_67138 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_67139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67140 = ["_fn/params","_fn/code","_fn/spec"];
var inst_67141 = (new cljs.core.PersistentVector(null,3,(5),inst_67139,inst_67140,null));
var inst_67142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67143 = cljs.core.name(fn_name);
var inst_67144 = ["_fn/name",inst_67143];
var inst_67145 = (new cljs.core.PersistentVector(null,2,(5),inst_67142,inst_67144,null));
var inst_67146 = [inst_67141,inst_67145];
var inst_67147__$1 = cljs.core.PersistentHashMap.fromArrays(inst_67138,inst_67146);
var inst_67148 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_67147__$1);
var state_67202__$1 = (function (){var statearr_67231 = state_67202;
(statearr_67231[(14)] = inst_67147__$1);

return statearr_67231;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67202__$1,(12),inst_67148);
} else {
if((state_val_67203 === (18))){
var inst_67185 = (state_67202[(11)]);
var inst_67188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67189 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_67190 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_67191 = [fn_name,inst_67189,inst_67190];
var inst_67192 = (new cljs.core.PersistentVector(null,3,(5),inst_67188,inst_67191,null));
var inst_67193 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_67192,inst_67185);
var state_67202__$1 = state_67202;
var statearr_67232_67259 = state_67202__$1;
(statearr_67232_67259[(2)] = inst_67193);

(statearr_67232_67259[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67203 === (8))){
var inst_67135 = (state_67202[(13)]);
var inst_67135__$1 = (state_67202[(2)]);
var state_67202__$1 = (function (){var statearr_67233 = state_67202;
(statearr_67233[(13)] = inst_67135__$1);

return statearr_67233;
})();
if(cljs.core.truth_(inst_67135__$1)){
var statearr_67234_67260 = state_67202__$1;
(statearr_67234_67260[(1)] = (9));

} else {
var statearr_67235_67261 = state_67202__$1;
(statearr_67235_67261[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto____0 = (function (){
var statearr_67236 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67236[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto__);

(statearr_67236[(1)] = (1));

return statearr_67236;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto____1 = (function (state_67202){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_67202);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e67237){var ex__10844__auto__ = e67237;
var statearr_67238_67262 = state_67202;
(statearr_67238_67262[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_67202[(4)]))){
var statearr_67239_67263 = state_67202;
(statearr_67239_67263[(1)] = cljs.core.first((state_67202[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__67264 = state_67202;
state_67202 = G__67264;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto__ = function(state_67202){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto____1.call(this,state_67202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_67240 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_67240[(6)] = c__10878__auto__);

return statearr_67240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__67266 = arguments.length;
switch (G__67266) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__67270 = arguments.length;
switch (G__67270) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_67400){
var state_val_67401 = (state_67400[(1)]);
if((state_val_67401 === (7))){
var inst_67395 = (state_67400[(2)]);
var _ = (function (){var statearr_67402 = state_67400;
(statearr_67402[(4)] = cljs.core.rest((state_67400[(4)])));

return statearr_67402;
})();
var state_67400__$1 = state_67400;
var statearr_67403_67483 = state_67400__$1;
(statearr_67403_67483[(2)] = inst_67395);

(statearr_67403_67483[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (20))){
var inst_67309 = (state_67400[(7)]);
var state_67400__$1 = state_67400;
var statearr_67404_67484 = state_67400__$1;
(statearr_67404_67484[(2)] = inst_67309);

(statearr_67404_67484[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (27))){
var inst_67296 = (state_67400[(8)]);
var inst_67322 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_67323 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67296)," used in function.",inst_67322].join('');
var inst_67324 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_67325 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_67326 = cljs.core.PersistentHashMap.fromArrays(inst_67324,inst_67325);
var inst_67327 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67323,inst_67326);
var inst_67328 = (function(){throw inst_67327})();
var state_67400__$1 = state_67400;
var statearr_67405_67485 = state_67400__$1;
(statearr_67405_67485[(2)] = inst_67328);

(statearr_67405_67485[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (1))){
var state_67400__$1 = state_67400;
var statearr_67406_67486 = state_67400__$1;
(statearr_67406_67486[(2)] = null);

(statearr_67406_67486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (24))){
var inst_67319 = (state_67400[(9)]);
var inst_67319__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_67400__$1 = (function (){var statearr_67407 = state_67400;
(statearr_67407[(9)] = inst_67319__$1);

return statearr_67407;
})();
if(inst_67319__$1){
var statearr_67408_67487 = state_67400__$1;
(statearr_67408_67487[(1)] = (26));

} else {
var statearr_67409_67488 = state_67400__$1;
(statearr_67409_67488[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (39))){
var inst_67296 = (state_67400[(8)]);
var inst_67356 = (inst_67296 == null);
var state_67400__$1 = state_67400;
if(cljs.core.truth_(inst_67356)){
var statearr_67410_67489 = state_67400__$1;
(statearr_67410_67489[(1)] = (42));

} else {
var statearr_67411_67490 = state_67400__$1;
(statearr_67411_67490[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (46))){
var state_67400__$1 = state_67400;
var statearr_67412_67491 = state_67400__$1;
(statearr_67412_67491[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (4))){
var inst_67271 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67414_67492 = state_67400__$1;
(statearr_67414_67492[(2)] = inst_67271);

(statearr_67414_67492[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (15))){
var inst_67296 = (state_67400[(8)]);
var inst_67307 = (inst_67296 instanceof cljs.core.Symbol);
var state_67400__$1 = state_67400;
if(cljs.core.truth_(inst_67307)){
var statearr_67415_67493 = state_67400__$1;
(statearr_67415_67493[(1)] = (17));

} else {
var statearr_67416_67494 = state_67400__$1;
(statearr_67416_67494[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (48))){
var inst_67363 = (state_67400[(2)]);
var inst_67364 = fluree.db.util.async.throw_err(inst_67363);
var state_67400__$1 = state_67400;
var statearr_67417_67495 = state_67400__$1;
(statearr_67417_67495[(2)] = inst_67364);

(statearr_67417_67495[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (50))){
var state_67400__$1 = state_67400;
var statearr_67418_67496 = state_67400__$1;
(statearr_67418_67496[(2)] = null);

(statearr_67418_67496[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (21))){
var inst_67316 = (state_67400[(10)]);
var inst_67309 = (state_67400[(7)]);
var inst_67287 = (state_67400[(11)]);
var inst_67290 = (state_67400[(12)]);
var inst_67286 = (state_67400[(13)]);
var inst_67289 = (state_67400[(14)]);
var inst_67284 = (state_67400[(15)]);
var inst_67296 = (state_67400[(8)]);
var inst_67297 = (state_67400[(16)]);
var inst_67312 = [inst_67296];
var inst_67313 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_67312);
var inst_67314 = (function (){var x = inst_67296;
var G__67280 = inst_67289;
var first__67294 = inst_67296;
var r = inst_67297;
var vec__67292 = inst_67289;
var acc = inst_67290;
var first__67283 = inst_67286;
var or__4223__auto__ = inst_67309;
var vec__67281 = inst_67284;
var seq__67293 = inst_67297;
var seq__67282 = inst_67287;
return (function (p1__67268_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__67268_SHARP_);
});
})();
var inst_67315 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_67314,params);
var inst_67316__$1 = cljs.core.some(inst_67313,inst_67315);
var state_67400__$1 = (function (){var statearr_67419 = state_67400;
(statearr_67419[(10)] = inst_67316__$1);

return statearr_67419;
})();
if(cljs.core.truth_(inst_67316__$1)){
var statearr_67420_67497 = state_67400__$1;
(statearr_67420_67497[(1)] = (23));

} else {
var statearr_67421_67498 = state_67400__$1;
(statearr_67421_67498[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (31))){
var inst_67346 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
if(cljs.core.truth_(inst_67346)){
var statearr_67422_67499 = state_67400__$1;
(statearr_67422_67499[(1)] = (35));

} else {
var statearr_67423_67500 = state_67400__$1;
(statearr_67423_67500[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (32))){
var inst_67339 = (state_67400[(17)]);
var state_67400__$1 = state_67400;
var statearr_67424_67501 = state_67400__$1;
(statearr_67424_67501[(2)] = inst_67339);

(statearr_67424_67501[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (40))){
var inst_67381 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67425_67502 = state_67400__$1;
(statearr_67425_67502[(2)] = inst_67381);

(statearr_67425_67502[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (33))){
var inst_67296 = (state_67400[(8)]);
var inst_67342 = (inst_67296 == null);
var state_67400__$1 = state_67400;
var statearr_67426_67503 = state_67400__$1;
(statearr_67426_67503[(2)] = inst_67342);

(statearr_67426_67503[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (13))){
var inst_67290 = (state_67400[(12)]);
var inst_67297 = (state_67400[(16)]);
var inst_67389 = (state_67400[(2)]);
var inst_67390 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_67290,inst_67389);
var inst_67289 = inst_67297;
var inst_67290__$1 = inst_67390;
var state_67400__$1 = (function (){var statearr_67427 = state_67400;
(statearr_67427[(12)] = inst_67290__$1);

(statearr_67427[(14)] = inst_67289);

return statearr_67427;
})();
var statearr_67428_67504 = state_67400__$1;
(statearr_67428_67504[(2)] = null);

(statearr_67428_67504[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (22))){
var inst_67334 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67429_67505 = state_67400__$1;
(statearr_67429_67505[(2)] = inst_67334);

(statearr_67429_67505[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (36))){
var inst_67296 = (state_67400[(8)]);
var inst_67349 = cljs.core.vector_QMARK_(inst_67296);
var state_67400__$1 = state_67400;
if(inst_67349){
var statearr_67430_67506 = state_67400__$1;
(statearr_67430_67506[(1)] = (38));

} else {
var statearr_67431_67507 = state_67400__$1;
(statearr_67431_67507[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (41))){
var inst_67353 = (state_67400[(2)]);
var inst_67354 = fluree.db.util.async.throw_err(inst_67353);
var state_67400__$1 = state_67400;
var statearr_67432_67508 = state_67400__$1;
(statearr_67432_67508[(2)] = inst_67354);

(statearr_67432_67508[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (43))){
var inst_67296 = (state_67400[(8)]);
var inst_67359 = cljs.core.list_QMARK_(inst_67296);
var state_67400__$1 = state_67400;
if(inst_67359){
var statearr_67433_67509 = state_67400__$1;
(statearr_67433_67509[(1)] = (45));

} else {
var statearr_67434_67510 = state_67400__$1;
(statearr_67434_67510[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (29))){
var inst_67336 = (state_67400[(18)]);
var state_67400__$1 = state_67400;
var statearr_67435_67511 = state_67400__$1;
(statearr_67435_67511[(2)] = inst_67336);

(statearr_67435_67511[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (44))){
var inst_67379 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67436_67512 = state_67400__$1;
(statearr_67436_67512[(2)] = inst_67379);

(statearr_67436_67512[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (6))){
var inst_67289 = (state_67400[(14)]);
var inst_67296 = (state_67400[(8)]);
var inst_67295 = cljs.core.seq(inst_67289);
var inst_67296__$1 = cljs.core.first(inst_67295);
var inst_67297 = cljs.core.next(inst_67295);
var inst_67298 = (inst_67296__$1 == null);
var state_67400__$1 = (function (){var statearr_67437 = state_67400;
(statearr_67437[(8)] = inst_67296__$1);

(statearr_67437[(16)] = inst_67297);

return statearr_67437;
})();
if(cljs.core.truth_(inst_67298)){
var statearr_67438_67513 = state_67400__$1;
(statearr_67438_67513[(1)] = (8));

} else {
var statearr_67439_67514 = state_67400__$1;
(statearr_67439_67514[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (28))){
var inst_67330 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67440_67515 = state_67400__$1;
(statearr_67440_67515[(2)] = inst_67330);

(statearr_67440_67515[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (51))){
var inst_67375 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67441_67516 = state_67400__$1;
(statearr_67441_67516[(2)] = inst_67375);

(statearr_67441_67516[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (25))){
var inst_67332 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67442_67517 = state_67400__$1;
(statearr_67442_67517[(2)] = inst_67332);

(statearr_67442_67517[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (34))){
var inst_67344 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67443_67518 = state_67400__$1;
(statearr_67443_67518[(2)] = inst_67344);

(statearr_67443_67518[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (17))){
var inst_67309 = (state_67400[(7)]);
var inst_67296 = (state_67400[(8)]);
var inst_67309__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_67296) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_67296));
var state_67400__$1 = (function (){var statearr_67444 = state_67400;
(statearr_67444[(7)] = inst_67309__$1);

return statearr_67444;
})();
if(cljs.core.truth_(inst_67309__$1)){
var statearr_67445_67519 = state_67400__$1;
(statearr_67445_67519[(1)] = (20));

} else {
var statearr_67446_67520 = state_67400__$1;
(statearr_67446_67520[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (3))){
var inst_67398 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67400__$1,inst_67398);
} else {
if((state_val_67401 === (12))){
var inst_67296 = (state_67400[(8)]);
var inst_67304 = typeof inst_67296 === 'number';
var state_67400__$1 = state_67400;
if(cljs.core.truth_(inst_67304)){
var statearr_67447_67521 = state_67400__$1;
(statearr_67447_67521[(1)] = (14));

} else {
var statearr_67448_67522 = state_67400__$1;
(statearr_67448_67522[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (2))){
var inst_67284 = (state_67400[(15)]);
var _ = (function (){var statearr_67449 = state_67400;
(statearr_67449[(4)] = cljs.core.cons((5),(state_67400[(4)])));

return statearr_67449;
})();
var inst_67284__$1 = vec;
var inst_67285 = cljs.core.seq(inst_67284__$1);
var inst_67286 = cljs.core.first(inst_67285);
var inst_67287 = cljs.core.next(inst_67285);
var inst_67288 = cljs.core.PersistentVector.EMPTY;
var inst_67289 = inst_67284__$1;
var inst_67290 = inst_67288;
var state_67400__$1 = (function (){var statearr_67450 = state_67400;
(statearr_67450[(11)] = inst_67287);

(statearr_67450[(12)] = inst_67290);

(statearr_67450[(13)] = inst_67286);

(statearr_67450[(14)] = inst_67289);

(statearr_67450[(15)] = inst_67284__$1);

return statearr_67450;
})();
var statearr_67451_67523 = state_67400__$1;
(statearr_67451_67523[(2)] = null);

(statearr_67451_67523[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (23))){
var inst_67316 = (state_67400[(10)]);
var state_67400__$1 = state_67400;
var statearr_67452_67524 = state_67400__$1;
(statearr_67452_67524[(2)] = inst_67316);

(statearr_67452_67524[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (47))){
var inst_67377 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67453_67525 = state_67400__$1;
(statearr_67453_67525[(2)] = inst_67377);

(statearr_67453_67525[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (35))){
var inst_67296 = (state_67400[(8)]);
var state_67400__$1 = state_67400;
var statearr_67454_67526 = state_67400__$1;
(statearr_67454_67526[(2)] = inst_67296);

(statearr_67454_67526[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (19))){
var inst_67385 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67455_67527 = state_67400__$1;
(statearr_67455_67527[(2)] = inst_67385);

(statearr_67455_67527[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (11))){
var inst_67296 = (state_67400[(8)]);
var state_67400__$1 = state_67400;
var statearr_67457_67528 = state_67400__$1;
(statearr_67457_67528[(2)] = inst_67296);

(statearr_67457_67528[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (9))){
var inst_67296 = (state_67400[(8)]);
var inst_67301 = typeof inst_67296 === 'string';
var state_67400__$1 = state_67400;
if(cljs.core.truth_(inst_67301)){
var statearr_67458_67529 = state_67400__$1;
(statearr_67458_67529[(1)] = (11));

} else {
var statearr_67459_67530 = state_67400__$1;
(statearr_67459_67530[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (5))){
var _ = (function (){var statearr_67460 = state_67400;
(statearr_67460[(4)] = cljs.core.rest((state_67400[(4)])));

return statearr_67460;
})();
var state_67400__$1 = state_67400;
var ex67456 = (state_67400__$1[(2)]);
var statearr_67461_67531 = state_67400__$1;
(statearr_67461_67531[(5)] = ex67456);


if((ex67456 instanceof Error)){
var statearr_67462_67532 = state_67400__$1;
(statearr_67462_67532[(1)] = (4));

(statearr_67462_67532[(5)] = null);

} else {
throw ex67456;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (14))){
var inst_67296 = (state_67400[(8)]);
var state_67400__$1 = state_67400;
var statearr_67463_67533 = state_67400__$1;
(statearr_67463_67533[(2)] = inst_67296);

(statearr_67463_67533[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (45))){
var inst_67296 = (state_67400[(8)]);
var inst_67361 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_67296,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_67296,funType,params));
var state_67400__$1 = state_67400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67400__$1,(48),inst_67361);
} else {
if((state_val_67401 === (26))){
var inst_67319 = (state_67400[(9)]);
var state_67400__$1 = state_67400;
var statearr_67464_67534 = state_67400__$1;
(statearr_67464_67534[(2)] = inst_67319);

(statearr_67464_67534[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (16))){
var inst_67387 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67465_67535 = state_67400__$1;
(statearr_67465_67535[(2)] = inst_67387);

(statearr_67465_67535[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (38))){
var inst_67296 = (state_67400[(8)]);
var inst_67351 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_67296,funType,params);
var state_67400__$1 = state_67400;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67400__$1,(41),inst_67351);
} else {
if((state_val_67401 === (30))){
var inst_67339 = (state_67400[(17)]);
var inst_67296 = (state_67400[(8)]);
var inst_67339__$1 = inst_67296 === false;
var state_67400__$1 = (function (){var statearr_67466 = state_67400;
(statearr_67466[(17)] = inst_67339__$1);

return statearr_67466;
})();
if(cljs.core.truth_(inst_67339__$1)){
var statearr_67467_67536 = state_67400__$1;
(statearr_67467_67536[(1)] = (32));

} else {
var statearr_67468_67537 = state_67400__$1;
(statearr_67468_67537[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (10))){
var inst_67393 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67469_67538 = state_67400__$1;
(statearr_67469_67538[(2)] = inst_67393);

(statearr_67469_67538[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (18))){
var inst_67296 = (state_67400[(8)]);
var inst_67336 = (state_67400[(18)]);
var inst_67336__$1 = inst_67296 === true;
var state_67400__$1 = (function (){var statearr_67470 = state_67400;
(statearr_67470[(18)] = inst_67336__$1);

return statearr_67470;
})();
if(cljs.core.truth_(inst_67336__$1)){
var statearr_67471_67539 = state_67400__$1;
(statearr_67471_67539[(1)] = (29));

} else {
var statearr_67472_67540 = state_67400__$1;
(statearr_67472_67540[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (42))){
var inst_67296 = (state_67400[(8)]);
var state_67400__$1 = state_67400;
var statearr_67473_67541 = state_67400__$1;
(statearr_67473_67541[(2)] = inst_67296);

(statearr_67473_67541[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (37))){
var inst_67383 = (state_67400[(2)]);
var state_67400__$1 = state_67400;
var statearr_67474_67542 = state_67400__$1;
(statearr_67474_67542[(2)] = inst_67383);

(statearr_67474_67542[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (8))){
var inst_67290 = (state_67400[(12)]);
var state_67400__$1 = state_67400;
var statearr_67475_67543 = state_67400__$1;
(statearr_67475_67543[(2)] = inst_67290);

(statearr_67475_67543[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67401 === (49))){
var inst_67296 = (state_67400[(8)]);
var inst_67367 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67296], 0));
var inst_67368 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_67369 = ["Illegal element (",inst_67367,") in vector: ",inst_67368,"."].join('');
var inst_67370 = cljs.core.PersistentHashMap.EMPTY;
var inst_67371 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67369,inst_67370);
var inst_67372 = (function(){throw inst_67371})();
var state_67400__$1 = state_67400;
var statearr_67476_67544 = state_67400__$1;
(statearr_67476_67544[(2)] = inst_67372);

(statearr_67476_67544[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10841__auto____0 = (function (){
var statearr_67477 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67477[(0)] = fluree$db$dbfunctions$core$state_machine__10841__auto__);

(statearr_67477[(1)] = (1));

return statearr_67477;
});
var fluree$db$dbfunctions$core$state_machine__10841__auto____1 = (function (state_67400){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_67400);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e67478){var ex__10844__auto__ = e67478;
var statearr_67479_67545 = state_67400;
(statearr_67479_67545[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_67400[(4)]))){
var statearr_67480_67546 = state_67400;
(statearr_67480_67546[(1)] = cljs.core.first((state_67400[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__67547 = state_67400;
state_67400 = G__67547;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10841__auto__ = function(state_67400){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10841__auto____1.call(this,state_67400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10841__auto____0;
fluree$db$dbfunctions$core$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10841__auto____1;
return fluree$db$dbfunctions$core$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_67481 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_67481[(6)] = c__10878__auto__);

return statearr_67481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__67550 = arguments.length;
switch (G__67550) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_67714){
var state_val_67715 = (state_67714[(1)]);
if((state_val_67715 === (7))){
var inst_67558 = (state_67714[(7)]);
var inst_67564 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_67558,type);
var state_67714__$1 = state_67714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67714__$1,(9),inst_67564);
} else {
if((state_val_67715 === (59))){
var inst_67607 = (state_67714[(8)]);
var inst_67678 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67607], 0));
var inst_67679 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_67607) : type.call(null,inst_67607));
var inst_67680 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_67681 = ["Illegal element (",inst_67678,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67679),") in function argument: ",inst_67680,"."].join('');
var inst_67682 = cljs.core.PersistentHashMap.EMPTY;
var inst_67683 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67681,inst_67682);
var inst_67684 = (function(){throw inst_67683})();
var state_67714__$1 = state_67714;
var statearr_67716_67811 = state_67714__$1;
(statearr_67716_67811[(2)] = inst_67684);

(statearr_67716_67811[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (20))){
var inst_67613 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
if(cljs.core.truth_(inst_67613)){
var statearr_67717_67812 = state_67714__$1;
(statearr_67717_67812[(1)] = (21));

} else {
var statearr_67718_67813 = state_67714__$1;
(statearr_67718_67813[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (58))){
var inst_67674 = (state_67714[(2)]);
var inst_67675 = fluree.db.util.async.throw_err(inst_67674);
var state_67714__$1 = state_67714;
var statearr_67719_67814 = state_67714__$1;
(statearr_67719_67814[(2)] = inst_67675);

(statearr_67719_67814[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (60))){
var state_67714__$1 = state_67714;
var statearr_67720_67815 = state_67714__$1;
(statearr_67720_67815[(2)] = null);

(statearr_67720_67815[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (27))){
var inst_67619 = (state_67714[(2)]);
var inst_67620 = fluree.db.util.async.throw_err(inst_67619);
var state_67714__$1 = state_67714;
var statearr_67721_67816 = state_67714__$1;
(statearr_67721_67816[(2)] = inst_67620);

(statearr_67721_67816[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (1))){
var state_67714__$1 = state_67714;
var statearr_67722_67817 = state_67714__$1;
(statearr_67722_67817[(2)] = null);

(statearr_67722_67817[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (24))){
var inst_67607 = (state_67714[(8)]);
var inst_67617 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_67607,type,params);
var state_67714__$1 = state_67714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67714__$1,(27),inst_67617);
} else {
if((state_val_67715 === (55))){
var inst_67607 = (state_67714[(8)]);
var inst_67672 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_67607,type,params);
var state_67714__$1 = state_67714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67714__$1,(58),inst_67672);
} else {
if((state_val_67715 === (39))){
var inst_67655 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67723_67818 = state_67714__$1;
(statearr_67723_67818[(2)] = inst_67655);

(statearr_67723_67818[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (46))){
var inst_67657 = (state_67714[(9)]);
var state_67714__$1 = state_67714;
var statearr_67724_67819 = state_67714__$1;
(statearr_67724_67819[(2)] = inst_67657);

(statearr_67724_67819[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (4))){
var inst_67551 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67725_67820 = state_67714__$1;
(statearr_67725_67820[(2)] = inst_67551);

(statearr_67725_67820[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (54))){
var inst_67691 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67726_67821 = state_67714__$1;
(statearr_67726_67821[(2)] = inst_67691);

(statearr_67726_67821[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (15))){
var inst_67559 = (state_67714[(10)]);
var inst_67588 = (state_67714[(2)]);
var inst_67596 = cljs.core.seq(inst_67559);
var inst_67597 = cljs.core.first(inst_67596);
var inst_67598 = cljs.core.next(inst_67596);
var inst_67599 = cljs.core.PersistentVector.EMPTY;
var inst_67600 = inst_67559;
var inst_67601 = inst_67599;
var state_67714__$1 = (function (){var statearr_67727 = state_67714;
(statearr_67727[(11)] = inst_67588);

(statearr_67727[(12)] = inst_67600);

(statearr_67727[(13)] = inst_67601);

(statearr_67727[(14)] = inst_67598);

(statearr_67727[(15)] = inst_67597);

return statearr_67727;
})();
var statearr_67728_67822 = state_67714__$1;
(statearr_67728_67822[(2)] = null);

(statearr_67728_67822[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (48))){
var inst_67667 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
if(cljs.core.truth_(inst_67667)){
var statearr_67729_67823 = state_67714__$1;
(statearr_67729_67823[(1)] = (52));

} else {
var statearr_67730_67824 = state_67714__$1;
(statearr_67730_67824[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (50))){
var inst_67607 = (state_67714[(8)]);
var inst_67663 = (inst_67607 == null);
var state_67714__$1 = state_67714;
var statearr_67731_67825 = state_67714__$1;
(statearr_67731_67825[(2)] = inst_67663);

(statearr_67731_67825[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (21))){
var inst_67607 = (state_67714[(8)]);
var inst_67615 = cljs.core.list_QMARK_(inst_67607);
var state_67714__$1 = state_67714;
if(inst_67615){
var statearr_67732_67826 = state_67714__$1;
(statearr_67732_67826[(1)] = (24));

} else {
var statearr_67733_67827 = state_67714__$1;
(statearr_67733_67827[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (31))){
var inst_67607 = (state_67714[(8)]);
var state_67714__$1 = state_67714;
var statearr_67734_67828 = state_67714__$1;
(statearr_67734_67828[(2)] = inst_67607);

(statearr_67734_67828[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (32))){
var inst_67607 = (state_67714[(8)]);
var inst_67628 = (inst_67607 instanceof cljs.core.Symbol);
var state_67714__$1 = state_67714;
if(cljs.core.truth_(inst_67628)){
var statearr_67735_67829 = state_67714__$1;
(statearr_67735_67829[(1)] = (34));

} else {
var statearr_67736_67830 = state_67714__$1;
(statearr_67736_67830[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (40))){
var inst_67637 = (state_67714[(16)]);
var state_67714__$1 = state_67714;
var statearr_67737_67831 = state_67714__$1;
(statearr_67737_67831[(2)] = inst_67637);

(statearr_67737_67831[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (56))){
var state_67714__$1 = state_67714;
var statearr_67738_67832 = state_67714__$1;
(statearr_67738_67832[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (33))){
var inst_67695 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67740_67833 = state_67714__$1;
(statearr_67740_67833[(2)] = inst_67695);

(statearr_67740_67833[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (13))){
var inst_67558 = (state_67714[(7)]);
var inst_67572 = (state_67714[(17)]);
var inst_67560 = (state_67714[(18)]);
var inst_67582 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67558),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67572),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67560),"."].join('');
var inst_67583 = cljs.core.PersistentHashMap.EMPTY;
var inst_67584 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67582,inst_67583);
var inst_67585 = (function(){throw inst_67584})();
var state_67714__$1 = state_67714;
var statearr_67741_67834 = state_67714__$1;
(statearr_67741_67834[(2)] = inst_67585);

(statearr_67741_67834[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (22))){
var inst_67601 = (state_67714[(13)]);
var state_67714__$1 = state_67714;
var statearr_67742_67835 = state_67714__$1;
(statearr_67742_67835[(2)] = inst_67601);

(statearr_67742_67835[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (36))){
var inst_67693 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67743_67836 = state_67714__$1;
(statearr_67743_67836[(2)] = inst_67693);

(statearr_67743_67836[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (41))){
var inst_67640 = (state_67714[(19)]);
var inst_67640__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_67714__$1 = (function (){var statearr_67744 = state_67714;
(statearr_67744[(19)] = inst_67640__$1);

return statearr_67744;
})();
if(inst_67640__$1){
var statearr_67745_67837 = state_67714__$1;
(statearr_67745_67837[(1)] = (43));

} else {
var statearr_67746_67838 = state_67714__$1;
(statearr_67746_67838[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (43))){
var inst_67640 = (state_67714[(19)]);
var state_67714__$1 = state_67714;
var statearr_67747_67839 = state_67714__$1;
(statearr_67747_67839[(2)] = inst_67640);

(statearr_67747_67839[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (61))){
var inst_67687 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67748_67840 = state_67714__$1;
(statearr_67748_67840[(2)] = inst_67687);

(statearr_67748_67840[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (29))){
var inst_67607 = (state_67714[(8)]);
var inst_67625 = typeof inst_67607 === 'number';
var state_67714__$1 = state_67714;
if(cljs.core.truth_(inst_67625)){
var statearr_67749_67841 = state_67714__$1;
(statearr_67749_67841[(1)] = (31));

} else {
var statearr_67750_67842 = state_67714__$1;
(statearr_67750_67842[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (44))){
var inst_67607 = (state_67714[(8)]);
var inst_67643 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_67644 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67607)," used in function argument: ",inst_67643].join('');
var inst_67645 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_67646 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_67647 = cljs.core.PersistentHashMap.fromArrays(inst_67645,inst_67646);
var inst_67648 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67644,inst_67647);
var inst_67649 = (function(){throw inst_67648})();
var state_67714__$1 = state_67714;
var statearr_67751_67843 = state_67714__$1;
(statearr_67751_67843[(2)] = inst_67649);

(statearr_67751_67843[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (6))){
var inst_67561 = (state_67714[(20)]);
var state_67714__$1 = state_67714;
var statearr_67752_67844 = state_67714__$1;
(statearr_67752_67844[(2)] = inst_67561);

(statearr_67752_67844[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (28))){
var inst_67607 = (state_67714[(8)]);
var state_67714__$1 = state_67714;
var statearr_67753_67845 = state_67714__$1;
(statearr_67753_67845[(2)] = inst_67607);

(statearr_67753_67845[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (51))){
var inst_67665 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67754_67846 = state_67714__$1;
(statearr_67754_67846[(2)] = inst_67665);

(statearr_67754_67846[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (25))){
var inst_67607 = (state_67714[(8)]);
var inst_67622 = typeof inst_67607 === 'string';
var state_67714__$1 = state_67714;
if(cljs.core.truth_(inst_67622)){
var statearr_67755_67847 = state_67714__$1;
(statearr_67755_67847[(1)] = (28));

} else {
var statearr_67756_67848 = state_67714__$1;
(statearr_67756_67848[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (34))){
var inst_67630 = (state_67714[(21)]);
var inst_67607 = (state_67714[(8)]);
var inst_67630__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_67607) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_67607));
var state_67714__$1 = (function (){var statearr_67757 = state_67714;
(statearr_67757[(21)] = inst_67630__$1);

return statearr_67757;
})();
if(cljs.core.truth_(inst_67630__$1)){
var statearr_67758_67849 = state_67714__$1;
(statearr_67758_67849[(1)] = (37));

} else {
var statearr_67759_67850 = state_67714__$1;
(statearr_67759_67850[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (17))){
var inst_67571 = (state_67714[(22)]);
var inst_67706 = (state_67714[(2)]);
var inst_67707 = cljs.core.cst$sym$_QMARK_ctx;
var inst_67708 = cljs.core.cons(inst_67707,inst_67706);
var inst_67709 = cljs.core.cons(inst_67571,inst_67708);
var _ = (function (){var statearr_67760 = state_67714;
(statearr_67760[(4)] = cljs.core.rest((state_67714[(4)])));

return statearr_67760;
})();
var state_67714__$1 = state_67714;
var statearr_67761_67851 = state_67714__$1;
(statearr_67761_67851[(2)] = inst_67709);

(statearr_67761_67851[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (3))){
var inst_67712 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67714__$1,inst_67712);
} else {
if((state_val_67715 === (12))){
var inst_67579 = (state_67714[(2)]);
var inst_67580 = cljs.core.not(inst_67579);
var state_67714__$1 = state_67714;
if(inst_67580){
var statearr_67762_67852 = state_67714__$1;
(statearr_67762_67852[(1)] = (13));

} else {
var statearr_67763_67853 = state_67714__$1;
(statearr_67763_67853[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (2))){
var inst_67561 = (state_67714[(20)]);
var inst_67558 = (state_67714[(7)]);
var inst_67559 = (state_67714[(10)]);
var _ = (function (){var statearr_67764 = state_67714;
(statearr_67764[(4)] = cljs.core.cons((5),(state_67714[(4)])));

return statearr_67764;
})();
var inst_67558__$1 = cljs.core.first(form);
var inst_67559__$1 = cljs.core.rest(form);
var inst_67560 = cljs.core.count(inst_67559__$1);
var inst_67561__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_67558__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_67558__$1));
var state_67714__$1 = (function (){var statearr_67765 = state_67714;
(statearr_67765[(20)] = inst_67561__$1);

(statearr_67765[(7)] = inst_67558__$1);

(statearr_67765[(18)] = inst_67560);

(statearr_67765[(10)] = inst_67559__$1);

return statearr_67765;
})();
if(cljs.core.truth_(inst_67561__$1)){
var statearr_67766_67854 = state_67714__$1;
(statearr_67766_67854[(1)] = (6));

} else {
var statearr_67767_67855 = state_67714__$1;
(statearr_67767_67855[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (23))){
var inst_67704 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67768_67856 = state_67714__$1;
(statearr_67768_67856[(2)] = inst_67704);

(statearr_67768_67856[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (47))){
var inst_67607 = (state_67714[(8)]);
var inst_67660 = (state_67714[(23)]);
var inst_67660__$1 = inst_67607 === false;
var state_67714__$1 = (function (){var statearr_67769 = state_67714;
(statearr_67769[(23)] = inst_67660__$1);

return statearr_67769;
})();
if(cljs.core.truth_(inst_67660__$1)){
var statearr_67770_67857 = state_67714__$1;
(statearr_67770_67857[(1)] = (49));

} else {
var statearr_67771_67858 = state_67714__$1;
(statearr_67771_67858[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (35))){
var inst_67657 = (state_67714[(9)]);
var inst_67607 = (state_67714[(8)]);
var inst_67657__$1 = inst_67607 === true;
var state_67714__$1 = (function (){var statearr_67772 = state_67714;
(statearr_67772[(9)] = inst_67657__$1);

return statearr_67772;
})();
if(cljs.core.truth_(inst_67657__$1)){
var statearr_67773_67859 = state_67714__$1;
(statearr_67773_67859[(1)] = (46));

} else {
var statearr_67774_67860 = state_67714__$1;
(statearr_67774_67860[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (19))){
var inst_67607 = (state_67714[(8)]);
var inst_67611 = inst_67607 === false;
var state_67714__$1 = state_67714;
var statearr_67775_67861 = state_67714__$1;
(statearr_67775_67861[(2)] = inst_67611);

(statearr_67775_67861[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (57))){
var inst_67689 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67776_67862 = state_67714__$1;
(statearr_67776_67862[(2)] = inst_67689);

(statearr_67776_67862[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (11))){
var inst_67572 = (state_67714[(17)]);
var inst_67560 = (state_67714[(18)]);
var inst_67577 = (inst_67572.cljs$core$IFn$_invoke$arity$1 ? inst_67572.cljs$core$IFn$_invoke$arity$1(inst_67560) : inst_67572.call(null,inst_67560));
var state_67714__$1 = state_67714;
var statearr_67778_67863 = state_67714__$1;
(statearr_67778_67863[(2)] = inst_67577);

(statearr_67778_67863[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (9))){
var inst_67566 = (state_67714[(2)]);
var inst_67567 = fluree.db.util.async.throw_err(inst_67566);
var state_67714__$1 = state_67714;
var statearr_67779_67864 = state_67714__$1;
(statearr_67779_67864[(2)] = inst_67567);

(statearr_67779_67864[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (5))){
var _ = (function (){var statearr_67780 = state_67714;
(statearr_67780[(4)] = cljs.core.rest((state_67714[(4)])));

return statearr_67780;
})();
var state_67714__$1 = state_67714;
var ex67777 = (state_67714__$1[(2)]);
var statearr_67781_67865 = state_67714__$1;
(statearr_67781_67865[(5)] = ex67777);


if((ex67777 instanceof Error)){
var statearr_67782_67866 = state_67714__$1;
(statearr_67782_67866[(1)] = (4));

(statearr_67782_67866[(5)] = null);

} else {
throw ex67777;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (14))){
var state_67714__$1 = state_67714;
var statearr_67783_67867 = state_67714__$1;
(statearr_67783_67867[(2)] = null);

(statearr_67783_67867[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (45))){
var inst_67651 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67784_67868 = state_67714__$1;
(statearr_67784_67868[(2)] = inst_67651);

(statearr_67784_67868[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (53))){
var inst_67607 = (state_67714[(8)]);
var inst_67670 = cljs.core.vector_QMARK_(inst_67607);
var state_67714__$1 = state_67714;
if(inst_67670){
var statearr_67785_67869 = state_67714__$1;
(statearr_67785_67869[(1)] = (55));

} else {
var statearr_67786_67870 = state_67714__$1;
(statearr_67786_67870[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (26))){
var inst_67608 = (state_67714[(24)]);
var inst_67601 = (state_67714[(13)]);
var inst_67699 = (state_67714[(2)]);
var inst_67700 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_67601,inst_67699);
var inst_67600 = inst_67608;
var inst_67601__$1 = inst_67700;
var state_67714__$1 = (function (){var statearr_67787 = state_67714;
(statearr_67787[(12)] = inst_67600);

(statearr_67787[(13)] = inst_67601__$1);

return statearr_67787;
})();
var statearr_67788_67871 = state_67714__$1;
(statearr_67788_67871[(2)] = null);

(statearr_67788_67871[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (16))){
var inst_67600 = (state_67714[(12)]);
var inst_67607 = (state_67714[(8)]);
var inst_67606 = cljs.core.seq(inst_67600);
var inst_67607__$1 = cljs.core.first(inst_67606);
var inst_67608 = cljs.core.next(inst_67606);
var state_67714__$1 = (function (){var statearr_67789 = state_67714;
(statearr_67789[(24)] = inst_67608);

(statearr_67789[(8)] = inst_67607__$1);

return statearr_67789;
})();
if(cljs.core.truth_(inst_67607__$1)){
var statearr_67790_67872 = state_67714__$1;
(statearr_67790_67872[(1)] = (18));

} else {
var statearr_67791_67873 = state_67714__$1;
(statearr_67791_67873[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (38))){
var inst_67630 = (state_67714[(21)]);
var inst_67558 = (state_67714[(7)]);
var inst_67571 = (state_67714[(22)]);
var inst_67608 = (state_67714[(24)]);
var inst_67588 = (state_67714[(11)]);
var inst_67574 = (state_67714[(25)]);
var inst_67600 = (state_67714[(12)]);
var inst_67569 = (state_67714[(26)]);
var inst_67601 = (state_67714[(13)]);
var inst_67598 = (state_67714[(14)]);
var inst_67637 = (state_67714[(16)]);
var inst_67573 = (state_67714[(27)]);
var inst_67597 = (state_67714[(15)]);
var inst_67607 = (state_67714[(8)]);
var inst_67572 = (state_67714[(17)]);
var inst_67560 = (state_67714[(18)]);
var inst_67570 = (state_67714[(28)]);
var inst_67559 = (state_67714[(10)]);
var inst_67633 = [inst_67607];
var inst_67634 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_67633);
var inst_67635 = (function (){var arity = inst_67572;
var args_n = inst_67560;
var fn_map = inst_67569;
var first__67605 = inst_67607;
var G__67592 = inst_67600;
var seq__67604 = inst_67608;
var seq__67594 = inst_67598;
var vec__67603 = inst_67600;
var args = inst_67559;
var r = inst_67608;
var _ = inst_67588;
var acc = inst_67601;
var arglist = inst_67573;
var fn_name = inst_67558;
var vec__67593 = inst_67559;
var _AMPERSAND_args_QMARK_ = inst_67574;
var or__4223__auto__ = inst_67630;
var map__67557 = inst_67570;
var arg = inst_67607;
var first__67595 = inst_67597;
var f = inst_67571;
return (function (p1__67548_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__67548_SHARP_);
});
})();
var inst_67636 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_67635,params);
var inst_67637__$1 = cljs.core.some(inst_67634,inst_67636);
var state_67714__$1 = (function (){var statearr_67792 = state_67714;
(statearr_67792[(16)] = inst_67637__$1);

return statearr_67792;
})();
if(cljs.core.truth_(inst_67637__$1)){
var statearr_67793_67874 = state_67714__$1;
(statearr_67793_67874[(1)] = (40));

} else {
var statearr_67794_67875 = state_67714__$1;
(statearr_67794_67875[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (30))){
var inst_67697 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67795_67876 = state_67714__$1;
(statearr_67795_67876[(2)] = inst_67697);

(statearr_67795_67876[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (10))){
var inst_67574 = (state_67714[(25)]);
var state_67714__$1 = state_67714;
var statearr_67796_67877 = state_67714__$1;
(statearr_67796_67877[(2)] = inst_67574);

(statearr_67796_67877[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (18))){
var inst_67607 = (state_67714[(8)]);
var state_67714__$1 = state_67714;
var statearr_67797_67878 = state_67714__$1;
(statearr_67797_67878[(2)] = inst_67607);

(statearr_67797_67878[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (52))){
var inst_67607 = (state_67714[(8)]);
var state_67714__$1 = state_67714;
var statearr_67798_67879 = state_67714__$1;
(statearr_67798_67879[(2)] = inst_67607);

(statearr_67798_67879[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (42))){
var inst_67653 = (state_67714[(2)]);
var state_67714__$1 = state_67714;
var statearr_67799_67880 = state_67714__$1;
(statearr_67799_67880[(2)] = inst_67653);

(statearr_67799_67880[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (37))){
var inst_67630 = (state_67714[(21)]);
var state_67714__$1 = state_67714;
var statearr_67800_67881 = state_67714__$1;
(statearr_67800_67881[(2)] = inst_67630);

(statearr_67800_67881[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (8))){
var inst_67574 = (state_67714[(25)]);
var inst_67569 = (state_67714[(26)]);
var inst_67570 = (state_67714[(28)]);
var inst_67569__$1 = (state_67714[(2)]);
var inst_67570__$1 = cljs.core.__destructure_map(inst_67569__$1);
var inst_67571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67570__$1,cljs.core.cst$kw$f);
var inst_67572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67570__$1,cljs.core.cst$kw$arity);
var inst_67573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67570__$1,cljs.core.cst$kw$arglist);
var inst_67574__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67570__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_67714__$1 = (function (){var statearr_67801 = state_67714;
(statearr_67801[(22)] = inst_67571);

(statearr_67801[(25)] = inst_67574__$1);

(statearr_67801[(26)] = inst_67569__$1);

(statearr_67801[(27)] = inst_67573);

(statearr_67801[(17)] = inst_67572);

(statearr_67801[(28)] = inst_67570__$1);

return statearr_67801;
})();
if(cljs.core.truth_(inst_67574__$1)){
var statearr_67802_67882 = state_67714__$1;
(statearr_67802_67882[(1)] = (10));

} else {
var statearr_67803_67883 = state_67714__$1;
(statearr_67803_67883[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67715 === (49))){
var inst_67660 = (state_67714[(23)]);
var state_67714__$1 = state_67714;
var statearr_67804_67884 = state_67714__$1;
(statearr_67804_67884[(2)] = inst_67660);

(statearr_67804_67884[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10841__auto____0 = (function (){
var statearr_67805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67805[(0)] = fluree$db$dbfunctions$core$state_machine__10841__auto__);

(statearr_67805[(1)] = (1));

return statearr_67805;
});
var fluree$db$dbfunctions$core$state_machine__10841__auto____1 = (function (state_67714){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_67714);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e67806){var ex__10844__auto__ = e67806;
var statearr_67807_67885 = state_67714;
(statearr_67807_67885[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_67714[(4)]))){
var statearr_67808_67886 = state_67714;
(statearr_67808_67886[(1)] = cljs.core.first((state_67714[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__67887 = state_67714;
state_67714 = G__67887;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10841__auto__ = function(state_67714){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10841__auto____1.call(this,state_67714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10841__auto____0;
fluree$db$dbfunctions$core$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10841__auto____1;
return fluree$db$dbfunctions$core$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_67809 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_67809[(6)] = c__10878__auto__);

return statearr_67809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__67889 = arguments.length;
switch (G__67889) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_67971){
var state_val_67972 = (state_67971[(1)]);
if((state_val_67972 === (7))){
var inst_67899 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_67971__$1 = state_67971;
var statearr_67973_68021 = state_67971__$1;
(statearr_67973_68021[(2)] = inst_67899);

(statearr_67973_68021[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (20))){
var inst_67949 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_67971__$1 = state_67971;
var statearr_67974_68022 = state_67971__$1;
(statearr_67974_68022[(2)] = inst_67949);

(statearr_67974_68022[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (1))){
var state_67971__$1 = state_67971;
var statearr_67975_68023 = state_67971__$1;
(statearr_67975_68023[(2)] = null);

(statearr_67975_68023[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (24))){
var inst_67946 = (state_67971[(7)]);
var inst_67955 = cljs.core.eval(inst_67946);
var state_67971__$1 = state_67971;
var statearr_67977_68024 = state_67971__$1;
(statearr_67977_68024[(2)] = inst_67955);

(statearr_67977_68024[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (4))){
var inst_67890 = (state_67971[(2)]);
var state_67971__$1 = state_67971;
var statearr_67978_68025 = state_67971__$1;
(statearr_67978_68025[(2)] = inst_67890);

(statearr_67978_68025[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (15))){
var _ = (function (){var statearr_67979 = state_67971;
(statearr_67979[(4)] = cljs.core.rest((state_67971[(4)])));

return statearr_67979;
})();
var state_67971__$1 = state_67971;
var ex67976 = (state_67971__$1[(2)]);
var statearr_67980_68026 = state_67971__$1;
(statearr_67980_68026[(5)] = ex67976);


var statearr_67981_68027 = state_67971__$1;
(statearr_67981_68027[(1)] = (14));

(statearr_67981_68027[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (21))){
var inst_67947 = (state_67971[(8)]);
var state_67971__$1 = state_67971;
var statearr_67982_68028 = state_67971__$1;
(statearr_67982_68028[(2)] = inst_67947);

(statearr_67982_68028[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (13))){
var inst_67964 = (state_67971[(2)]);
var state_67971__$1 = state_67971;
var statearr_67983_68029 = state_67971__$1;
(statearr_67983_68029[(2)] = inst_67964);

(statearr_67983_68029[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (22))){
var inst_67952 = (state_67971[(2)]);
var state_67971__$1 = state_67971;
if(cljs.core.truth_(inst_67952)){
var statearr_67984_68030 = state_67971__$1;
(statearr_67984_68030[(1)] = (23));

} else {
var statearr_67985_68031 = state_67971__$1;
(statearr_67985_68031[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (6))){
var inst_67896 = (state_67971[(9)]);
var state_67971__$1 = state_67971;
var statearr_67986_68032 = state_67971__$1;
(statearr_67986_68032[(2)] = inst_67896);

(statearr_67986_68032[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (25))){
var inst_67957 = (state_67971[(2)]);
var inst_67958 = [cljs.core.cst$kw$fnstr];
var inst_67959 = [fn_str];
var inst_67960 = cljs.core.PersistentHashMap.fromArrays(inst_67958,inst_67959);
var inst_67961 = cljs.core.with_meta(inst_67957,inst_67960);
var _ = (function (){var statearr_67987 = state_67971;
(statearr_67987[(4)] = cljs.core.rest((state_67971[(4)])));

return statearr_67987;
})();
var state_67971__$1 = state_67971;
var statearr_67988_68033 = state_67971__$1;
(statearr_67988_68033[(2)] = inst_67961);

(statearr_67988_68033[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (17))){
var inst_67922 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_67923 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_67924 = cljs.core.PersistentHashMap.fromArrays(inst_67922,inst_67923);
var inst_67925 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_67924);
var inst_67926 = (function(){throw inst_67925})();
var state_67971__$1 = state_67971;
var statearr_67989_68034 = state_67971__$1;
(statearr_67989_68034[(2)] = inst_67926);

(statearr_67989_68034[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (3))){
var inst_67969 = (state_67971[(2)]);
var state_67971__$1 = state_67971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67971__$1,inst_67969);
} else {
if((state_val_67972 === (12))){
var _ = (function (){var statearr_67990 = state_67971;
(statearr_67990[(4)] = cljs.core.cons((15),(state_67971[(4)])));

return statearr_67990;
})();
var inst_67919 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_67971__$1 = state_67971;
if(cljs.core.truth_(inst_67919)){
var statearr_67991_68035 = state_67971__$1;
(statearr_67991_68035[(1)] = (16));

} else {
var statearr_67992_68036 = state_67971__$1;
(statearr_67992_68036[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (2))){
var inst_67896 = (state_67971[(9)]);
var _ = (function (){var statearr_67993 = state_67971;
(statearr_67993[(4)] = cljs.core.cons((5),(state_67971[(4)])));

return statearr_67993;
})();
var inst_67896__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_67971__$1 = (function (){var statearr_67994 = state_67971;
(statearr_67994[(9)] = inst_67896__$1);

return statearr_67994;
})();
if(inst_67896__$1){
var statearr_67995_68037 = state_67971__$1;
(statearr_67995_68037[(1)] = (6));

} else {
var statearr_67996_68038 = state_67971__$1;
(statearr_67996_68038[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (23))){
var inst_67946 = (state_67971[(7)]);
var state_67971__$1 = state_67971;
var statearr_67997_68039 = state_67971__$1;
(statearr_67997_68039[(2)] = inst_67946);

(statearr_67997_68039[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (19))){
var inst_67947 = (state_67971[(8)]);
var inst_67932 = (state_67971[(2)]);
var inst_67933 = fluree.db.util.async.throw_err(inst_67932);
var inst_67934 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_67935 = (new cljs.core.List(null,inst_67934,null,(1),null));
var inst_67936 = cljs.core.cst$sym$_QMARK_ctx;
var inst_67937 = (new cljs.core.List(null,inst_67936,null,(1),null));
var inst_67938 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_67937);
var inst_67939 = cljs.core.seq(inst_67938);
var inst_67940 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_67939);
var inst_67941 = cljs.core.vec(inst_67940);
var inst_67942 = (new cljs.core.List(null,inst_67941,null,(1),null));
var inst_67943 = (new cljs.core.List(null,inst_67933,null,(1),null));
var inst_67944 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_67935,inst_67942,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67943], 0));
var inst_67945 = cljs.core.seq(inst_67944);
var inst_67946 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_67945);
var inst_67947__$1 = params;
var state_67971__$1 = (function (){var statearr_67998 = state_67971;
(statearr_67998[(8)] = inst_67947__$1);

(statearr_67998[(7)] = inst_67946);

return statearr_67998;
})();
if(cljs.core.truth_(inst_67947__$1)){
var statearr_67999_68040 = state_67971__$1;
(statearr_67999_68040[(1)] = (20));

} else {
var statearr_68000_68041 = state_67971__$1;
(statearr_68000_68041[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (11))){
var inst_67966 = (state_67971[(2)]);
var _ = (function (){var statearr_68002 = state_67971;
(statearr_68002[(4)] = cljs.core.rest((state_67971[(4)])));

return statearr_68002;
})();
var state_67971__$1 = state_67971;
var statearr_68003_68042 = state_67971__$1;
(statearr_68003_68042[(2)] = inst_67966);

(statearr_68003_68042[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (9))){
var inst_67903 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_67904 = fluree.db.dbfunctions.core.true_or_false = inst_67903;
var state_67971__$1 = state_67971;
var statearr_68004_68043 = state_67971__$1;
(statearr_68004_68043[(2)] = inst_67904);

(statearr_68004_68043[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (5))){
var _ = (function (){var statearr_68005 = state_67971;
(statearr_68005[(4)] = cljs.core.rest((state_67971[(4)])));

return statearr_68005;
})();
var state_67971__$1 = state_67971;
var ex68001 = (state_67971__$1[(2)]);
var statearr_68006_68044 = state_67971__$1;
(statearr_68006_68044[(5)] = ex68001);


if((ex68001 instanceof Error)){
var statearr_68007_68045 = state_67971__$1;
(statearr_68007_68045[(1)] = (4));

(statearr_68007_68045[(5)] = null);

} else {
throw ex68001;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (14))){
var inst_67906 = (state_67971[(2)]);
var inst_67907 = (function(){throw inst_67906})();
var inst_67908 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_67909 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_67910 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_67911 = cljs.core.PersistentHashMap.fromArrays(inst_67909,inst_67910);
var inst_67912 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67908,inst_67911);
var inst_67913 = (function(){throw inst_67912})();
var state_67971__$1 = (function (){var statearr_68008 = state_67971;
(statearr_68008[(10)] = inst_67907);

return statearr_68008;
})();
var statearr_68009_68046 = state_67971__$1;
(statearr_68009_68046[(2)] = inst_67913);

(statearr_68009_68046[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (16))){
var state_67971__$1 = state_67971;
var statearr_68010_68047 = state_67971__$1;
(statearr_68010_68047[(2)] = null);

(statearr_68010_68047[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (10))){
var state_67971__$1 = state_67971;
var statearr_68011_68048 = state_67971__$1;
(statearr_68011_68048[(2)] = null);

(statearr_68011_68048[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67972 === (18))){
var inst_67928 = (state_67971[(2)]);
var inst_67929 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_67930 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_67929,type,params);
var state_67971__$1 = (function (){var statearr_68012 = state_67971;
(statearr_68012[(11)] = inst_67928);

return statearr_68012;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67971__$1,(19),inst_67930);
} else {
if((state_val_67972 === (8))){
var inst_67901 = (state_67971[(2)]);
var state_67971__$1 = state_67971;
if(cljs.core.truth_(inst_67901)){
var statearr_68013_68049 = state_67971__$1;
(statearr_68013_68049[(1)] = (9));

} else {
var statearr_68014_68050 = state_67971__$1;
(statearr_68014_68050[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__10841__auto____0 = (function (){
var statearr_68015 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68015[(0)] = fluree$db$dbfunctions$core$state_machine__10841__auto__);

(statearr_68015[(1)] = (1));

return statearr_68015;
});
var fluree$db$dbfunctions$core$state_machine__10841__auto____1 = (function (state_67971){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_67971);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e68016){var ex__10844__auto__ = e68016;
var statearr_68017_68051 = state_67971;
(statearr_68017_68051[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_67971[(4)]))){
var statearr_68018_68052 = state_67971;
(statearr_68018_68052[(1)] = cljs.core.first((state_67971[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__68053 = state_67971;
state_67971 = G__68053;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__10841__auto__ = function(state_67971){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__10841__auto____1.call(this,state_67971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__10841__auto____0;
fluree$db$dbfunctions$core$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__10841__auto____1;
return fluree$db$dbfunctions$core$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_68019 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_68019[(6)] = c__10878__auto__);

return statearr_68019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_68081){
var state_val_68082 = (state_68081[(1)]);
if((state_val_68082 === (7))){
var inst_68068 = (state_68081[(7)]);
var state_68081__$1 = state_68081;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68081__$1,(10),inst_68068);
} else {
if((state_val_68082 === (1))){
var state_68081__$1 = state_68081;
var statearr_68083_68103 = state_68081__$1;
(statearr_68083_68103[(2)] = null);

(statearr_68083_68103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68082 === (4))){
var inst_68054 = (state_68081[(2)]);
var state_68081__$1 = state_68081;
var statearr_68084_68104 = state_68081__$1;
(statearr_68084_68104[(2)] = inst_68054);

(statearr_68084_68104[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68082 === (6))){
var inst_68068 = (state_68081[(7)]);
var inst_68063 = (state_68081[(8)]);
var inst_68066 = (state_68081[(2)]);
var inst_68067 = fluree.db.util.async.throw_err(inst_68066);
var inst_68068__$1 = (inst_68067.cljs$core$IFn$_invoke$arity$1 ? inst_68067.cljs$core$IFn$_invoke$arity$1(inst_68063) : inst_68067.call(null,inst_68063));
var inst_68069 = fluree.db.util.async.channel_QMARK_(inst_68068__$1);
var state_68081__$1 = (function (){var statearr_68085 = state_68081;
(statearr_68085[(7)] = inst_68068__$1);

return statearr_68085;
})();
if(inst_68069){
var statearr_68086_68105 = state_68081__$1;
(statearr_68086_68105[(1)] = (7));

} else {
var statearr_68087_68106 = state_68081__$1;
(statearr_68087_68106[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68082 === (3))){
var inst_68079 = (state_68081[(2)]);
var state_68081__$1 = state_68081;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68081__$1,inst_68079);
} else {
if((state_val_68082 === (2))){
var _ = (function (){var statearr_68089 = state_68081;
(statearr_68089[(4)] = cljs.core.cons((5),(state_68081[(4)])));

return statearr_68089;
})();
var inst_68060 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_68061 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_68062 = [db,block_instant,s,p,auth_id,fuel];
var inst_68063 = cljs.core.PersistentHashMap.fromArrays(inst_68061,inst_68062);
var inst_68064 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_68060,"txn",null);
var state_68081__$1 = (function (){var statearr_68090 = state_68081;
(statearr_68090[(8)] = inst_68063);

return statearr_68090;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68081__$1,(6),inst_68064);
} else {
if((state_val_68082 === (9))){
var inst_68076 = (state_68081[(2)]);
var _ = (function (){var statearr_68091 = state_68081;
(statearr_68091[(4)] = cljs.core.rest((state_68081[(4)])));

return statearr_68091;
})();
var state_68081__$1 = state_68081;
var statearr_68092_68107 = state_68081__$1;
(statearr_68092_68107[(2)] = inst_68076);

(statearr_68092_68107[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68082 === (5))){
var _ = (function (){var statearr_68093 = state_68081;
(statearr_68093[(4)] = cljs.core.rest((state_68081[(4)])));

return statearr_68093;
})();
var state_68081__$1 = state_68081;
var ex68088 = (state_68081__$1[(2)]);
var statearr_68094_68108 = state_68081__$1;
(statearr_68094_68108[(5)] = ex68088);


if((ex68088 instanceof Error)){
var statearr_68095_68109 = state_68081__$1;
(statearr_68095_68109[(1)] = (4));

(statearr_68095_68109[(5)] = null);

} else {
throw ex68088;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68082 === (10))){
var inst_68072 = (state_68081[(2)]);
var inst_68073 = fluree.db.util.async.throw_err(inst_68072);
var state_68081__$1 = state_68081;
var statearr_68096_68110 = state_68081__$1;
(statearr_68096_68110[(2)] = inst_68073);

(statearr_68096_68110[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68082 === (8))){
var inst_68068 = (state_68081[(7)]);
var state_68081__$1 = state_68081;
var statearr_68097_68111 = state_68081__$1;
(statearr_68097_68111[(2)] = inst_68068);

(statearr_68097_68111[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto____0 = (function (){
var statearr_68098 = [null,null,null,null,null,null,null,null,null];
(statearr_68098[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto__);

(statearr_68098[(1)] = (1));

return statearr_68098;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto____1 = (function (state_68081){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_68081);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e68099){var ex__10844__auto__ = e68099;
var statearr_68100_68112 = state_68081;
(statearr_68100_68112[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_68081[(4)]))){
var statearr_68101_68113 = state_68081;
(statearr_68101_68113[(1)] = cljs.core.first((state_68081[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__68114 = state_68081;
state_68081 = G__68114;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto__ = function(state_68081){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto____1.call(this,state_68081);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_68102 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_68102[(6)] = c__10878__auto__);

return statearr_68102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
