// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___63344 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63395){
var state_val_63396 = (state_63395[(1)]);
if((state_val_63396 === (7))){
var inst_63390 = (state_63395[(2)]);
var _ = (function (){var statearr_63397 = state_63395;
(statearr_63397[(4)] = cljs.core.rest((state_63395[(4)])));

return statearr_63397;
})();
var state_63395__$1 = state_63395;
var statearr_63398_63425 = state_63395__$1;
(statearr_63398_63425[(2)] = inst_63390);

(statearr_63398_63425[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (1))){
var state_63395__$1 = state_63395;
var statearr_63399_63426 = state_63395__$1;
(statearr_63399_63426[(2)] = null);

(statearr_63399_63426[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (4))){
var inst_63345 = (state_63395[(2)]);
var state_63395__$1 = state_63395;
var statearr_63400_63427 = state_63395__$1;
(statearr_63400_63427[(2)] = inst_63345);

(statearr_63400_63427[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (13))){
var inst_63386 = (state_63395[(2)]);
var state_63395__$1 = state_63395;
var statearr_63401_63428 = state_63395__$1;
(statearr_63401_63428[(2)] = inst_63386);

(statearr_63401_63428[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (6))){
var inst_63363 = (state_63395[(7)]);
var inst_63370 = (state_63395[(8)]);
var inst_63369 = cljs.core.seq(inst_63363);
var inst_63370__$1 = cljs.core.first(inst_63369);
var inst_63371 = cljs.core.next(inst_63369);
var inst_63372 = cljs.core.not(inst_63370__$1);
var state_63395__$1 = (function (){var statearr_63402 = state_63395;
(statearr_63402[(9)] = inst_63371);

(statearr_63402[(8)] = inst_63370__$1);

return statearr_63402;
})();
if(inst_63372){
var statearr_63403_63429 = state_63395__$1;
(statearr_63403_63429[(1)] = (8));

} else {
var statearr_63404_63430 = state_63395__$1;
(statearr_63404_63430[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (3))){
var inst_63393 = (state_63395[(2)]);
var state_63395__$1 = state_63395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63395__$1,inst_63393);
} else {
if((state_val_63396 === (12))){
var inst_63364 = (state_63395[(10)]);
var inst_63371 = (state_63395[(9)]);
var inst_63370 = (state_63395[(8)]);
var inst_63383 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_63364,inst_63370);
var inst_63363 = inst_63371;
var inst_63364__$1 = inst_63383;
var state_63395__$1 = (function (){var statearr_63405 = state_63395;
(statearr_63405[(10)] = inst_63364__$1);

(statearr_63405[(7)] = inst_63363);

return statearr_63405;
})();
var statearr_63406_63431 = state_63395__$1;
(statearr_63406_63431[(2)] = null);

(statearr_63406_63431[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (2))){
var _ = (function (){var statearr_63407 = state_63395;
(statearr_63407[(4)] = cljs.core.cons((5),(state_63395[(4)])));

return statearr_63407;
})();
var inst_63358 = args;
var inst_63359 = cljs.core.seq(inst_63358);
var inst_63360 = cljs.core.first(inst_63359);
var inst_63361 = cljs.core.next(inst_63359);
var inst_63362 = cljs.core.PersistentVector.EMPTY;
var inst_63363 = inst_63358;
var inst_63364 = inst_63362;
var state_63395__$1 = (function (){var statearr_63408 = state_63395;
(statearr_63408[(10)] = inst_63364);

(statearr_63408[(7)] = inst_63363);

(statearr_63408[(11)] = inst_63360);

(statearr_63408[(12)] = inst_63361);

return statearr_63408;
})();
var statearr_63409_63432 = state_63395__$1;
(statearr_63409_63432[(2)] = null);

(statearr_63409_63432[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (11))){
var inst_63370 = (state_63395[(8)]);
var state_63395__$1 = state_63395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63395__$1,(14),inst_63370);
} else {
if((state_val_63396 === (9))){
var inst_63370 = (state_63395[(8)]);
var inst_63375 = fluree.db.util.async.channel_QMARK_(inst_63370);
var state_63395__$1 = state_63395;
if(inst_63375){
var statearr_63411_63433 = state_63395__$1;
(statearr_63411_63433[(1)] = (11));

} else {
var statearr_63412_63434 = state_63395__$1;
(statearr_63412_63434[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (5))){
var _ = (function (){var statearr_63413 = state_63395;
(statearr_63413[(4)] = cljs.core.rest((state_63395[(4)])));

return statearr_63413;
})();
var state_63395__$1 = state_63395;
var ex63410 = (state_63395__$1[(2)]);
var statearr_63414_63435 = state_63395__$1;
(statearr_63414_63435[(5)] = ex63410);


if((ex63410 instanceof Error)){
var statearr_63415_63436 = state_63395__$1;
(statearr_63415_63436[(1)] = (4));

(statearr_63415_63436[(5)] = null);

} else {
throw ex63410;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (14))){
var inst_63364 = (state_63395[(10)]);
var inst_63371 = (state_63395[(9)]);
var inst_63378 = (state_63395[(2)]);
var inst_63379 = fluree.db.util.async.throw_err(inst_63378);
var inst_63380 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_63364,inst_63379);
var inst_63363 = inst_63371;
var inst_63364__$1 = inst_63380;
var state_63395__$1 = (function (){var statearr_63416 = state_63395;
(statearr_63416[(10)] = inst_63364__$1);

(statearr_63416[(7)] = inst_63363);

return statearr_63416;
})();
var statearr_63417_63437 = state_63395__$1;
(statearr_63417_63437[(2)] = null);

(statearr_63417_63437[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (10))){
var inst_63388 = (state_63395[(2)]);
var state_63395__$1 = state_63395;
var statearr_63418_63438 = state_63395__$1;
(statearr_63418_63438[(2)] = inst_63388);

(statearr_63418_63438[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63396 === (8))){
var inst_63364 = (state_63395[(10)]);
var state_63395__$1 = state_63395;
var statearr_63419_63439 = state_63395__$1;
(statearr_63419_63439[(2)] = inst_63364);

(statearr_63419_63439[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto____0 = (function (){
var statearr_63420 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63420[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto__);

(statearr_63420[(1)] = (1));

return statearr_63420;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto____1 = (function (state_63395){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63395);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63421){var ex__10844__auto__ = e63421;
var statearr_63422_63440 = state_63395;
(statearr_63422_63440[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63395[(4)]))){
var statearr_63423_63441 = state_63395;
(statearr_63423_63441[(1)] = cljs.core.first((state_63395[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63442 = state_63395;
state_63395 = G__63442;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto__ = function(state_63395){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto____1.call(this,state_63395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63424 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63424[(6)] = c__10878__auto__);

return statearr_63424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__63443 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63443,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63443,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63491){
var state_val_63492 = (state_63491[(1)]);
if((state_val_63492 === (7))){
var state_63491__$1 = state_63491;
var statearr_63493_63522 = state_63491__$1;
(statearr_63493_63522[(2)] = coll);

(statearr_63493_63522[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (1))){
var state_63491__$1 = state_63491;
var statearr_63494_63523 = state_63491__$1;
(statearr_63494_63523[(2)] = null);

(statearr_63494_63523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (4))){
var inst_63446 = (state_63491[(2)]);
var state_63491__$1 = state_63491;
var statearr_63495_63524 = state_63491__$1;
(statearr_63495_63524[(2)] = inst_63446);

(statearr_63495_63524[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (15))){
var inst_63465 = (state_63491[(7)]);
var inst_63473 = (state_63491[(2)]);
var inst_63474 = fluree.db.dbfunctions.internal.nth(inst_63465,inst_63473);
var inst_63475 = cljs.core.count(inst_63465);
var inst_63476 = ((9) + inst_63475);
var inst_63477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63478 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63480 = [inst_63465,inst_63473];
var inst_63481 = (new cljs.core.PersistentVector(null,2,(5),inst_63479,inst_63480,null));
var inst_63482 = ["nth",inst_63481,inst_63474];
var inst_63483 = cljs.core.PersistentHashMap.fromArrays(inst_63478,inst_63482);
var inst_63484 = [inst_63483,inst_63476];
var inst_63485 = (new cljs.core.PersistentVector(null,2,(5),inst_63477,inst_63484,null));
var inst_63486 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63485);
var _ = (function (){var statearr_63496 = state_63491;
(statearr_63496[(4)] = cljs.core.rest((state_63491[(4)])));

return statearr_63496;
})();
var state_63491__$1 = (function (){var statearr_63497 = state_63491;
(statearr_63497[(8)] = inst_63486);

return statearr_63497;
})();
var statearr_63498_63525 = state_63491__$1;
(statearr_63498_63525[(2)] = inst_63474);

(statearr_63498_63525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (13))){
var state_63491__$1 = state_63491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63491__$1,(16),key);
} else {
if((state_val_63492 === (6))){
var state_63491__$1 = state_63491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63491__$1,(9),coll);
} else {
if((state_val_63492 === (3))){
var inst_63489 = (state_63491[(2)]);
var state_63491__$1 = state_63491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63491__$1,inst_63489);
} else {
if((state_val_63492 === (12))){
var inst_63465 = (state_63491[(2)]);
var inst_63466 = fluree.db.util.async.channel_QMARK_(key);
var state_63491__$1 = (function (){var statearr_63499 = state_63491;
(statearr_63499[(7)] = inst_63465);

return statearr_63499;
})();
if(inst_63466){
var statearr_63500_63526 = state_63491__$1;
(statearr_63500_63526[(1)] = (13));

} else {
var statearr_63501_63527 = state_63491__$1;
(statearr_63501_63527[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (2))){
var _ = (function (){var statearr_63502 = state_63491;
(statearr_63502[(4)] = cljs.core.cons((5),(state_63491[(4)])));

return statearr_63502;
})();
var inst_63452 = fluree.db.util.async.channel_QMARK_(coll);
var state_63491__$1 = state_63491;
if(inst_63452){
var statearr_63503_63528 = state_63491__$1;
(statearr_63503_63528[(1)] = (6));

} else {
var statearr_63504_63529 = state_63491__$1;
(statearr_63504_63529[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (11))){
var inst_63459 = (state_63491[(9)]);
var state_63491__$1 = state_63491;
var statearr_63506_63530 = state_63491__$1;
(statearr_63506_63530[(2)] = inst_63459);

(statearr_63506_63530[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (9))){
var inst_63455 = (state_63491[(2)]);
var inst_63456 = fluree.db.util.async.throw_err(inst_63455);
var state_63491__$1 = state_63491;
var statearr_63507_63531 = state_63491__$1;
(statearr_63507_63531[(2)] = inst_63456);

(statearr_63507_63531[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (5))){
var _ = (function (){var statearr_63508 = state_63491;
(statearr_63508[(4)] = cljs.core.rest((state_63491[(4)])));

return statearr_63508;
})();
var state_63491__$1 = state_63491;
var ex63505 = (state_63491__$1[(2)]);
var statearr_63509_63532 = state_63491__$1;
(statearr_63509_63532[(5)] = ex63505);


if((ex63505 instanceof Error)){
var statearr_63510_63533 = state_63491__$1;
(statearr_63510_63533[(1)] = (4));

(statearr_63510_63533[(5)] = null);

} else {
throw ex63505;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (14))){
var state_63491__$1 = state_63491;
var statearr_63511_63534 = state_63491__$1;
(statearr_63511_63534[(2)] = key);

(statearr_63511_63534[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (16))){
var inst_63469 = (state_63491[(2)]);
var inst_63470 = fluree.db.util.async.throw_err(inst_63469);
var state_63491__$1 = state_63491;
var statearr_63512_63535 = state_63491__$1;
(statearr_63512_63535[(2)] = inst_63470);

(statearr_63512_63535[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (10))){
var inst_63459 = (state_63491[(9)]);
var inst_63462 = cljs.core.vec(inst_63459);
var state_63491__$1 = state_63491;
var statearr_63513_63536 = state_63491__$1;
(statearr_63513_63536[(2)] = inst_63462);

(statearr_63513_63536[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63492 === (8))){
var inst_63459 = (state_63491[(9)]);
var inst_63459__$1 = (state_63491[(2)]);
var inst_63460 = cljs.core.set_QMARK_(inst_63459__$1);
var state_63491__$1 = (function (){var statearr_63514 = state_63491;
(statearr_63514[(9)] = inst_63459__$1);

return statearr_63514;
})();
if(inst_63460){
var statearr_63515_63537 = state_63491__$1;
(statearr_63515_63537[(1)] = (10));

} else {
var statearr_63516_63538 = state_63491__$1;
(statearr_63516_63538[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto____0 = (function (){
var statearr_63517 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63517[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto__);

(statearr_63517[(1)] = (1));

return statearr_63517;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto____1 = (function (state_63491){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63491);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63518){var ex__10844__auto__ = e63518;
var statearr_63519_63539 = state_63491;
(statearr_63519_63539[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63491[(4)]))){
var statearr_63520_63540 = state_63491;
(statearr_63520_63540[(1)] = cljs.core.first((state_63491[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63541 = state_63491;
state_63491 = G__63541;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto__ = function(state_63491){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto____1.call(this,state_63491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63521 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63521[(6)] = c__10878__auto__);

return statearr_63521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63602){
var state_val_63603 = (state_63602[(1)]);
if((state_val_63603 === (7))){
var state_63602__$1 = state_63602;
var statearr_63604_63638 = state_63602__$1;
(statearr_63604_63638[(2)] = test);

(statearr_63604_63638[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (20))){
var inst_63576 = (state_63602[(2)]);
var inst_63577 = fluree.db.util.async.throw_err(inst_63576);
var state_63602__$1 = state_63602;
var statearr_63605_63639 = state_63602__$1;
(statearr_63605_63639[(2)] = inst_63577);

(statearr_63605_63639[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (1))){
var state_63602__$1 = state_63602;
var statearr_63606_63640 = state_63602__$1;
(statearr_63606_63640[(2)] = null);

(statearr_63606_63640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (4))){
var inst_63542 = (state_63602[(2)]);
var state_63602__$1 = state_63602;
var statearr_63607_63641 = state_63602__$1;
(statearr_63607_63641[(2)] = inst_63542);

(statearr_63607_63641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (15))){
var inst_63560 = (state_63602[(7)]);
var inst_63568 = (state_63602[(2)]);
var inst_63569 = [inst_63568,f];
var inst_63570 = (new cljs.core.PersistentVector(null,2,(5),inst_63560,inst_63569,null));
var state_63602__$1 = state_63602;
var statearr_63608_63642 = state_63602__$1;
(statearr_63608_63642[(2)] = inst_63570);

(statearr_63608_63642[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (13))){
var state_63602__$1 = state_63602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63602__$1,(16),t);
} else {
if((state_val_63603 === (6))){
var state_63602__$1 = state_63602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63602__$1,(9),test);
} else {
if((state_val_63603 === (17))){
var state_63602__$1 = state_63602;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63602__$1,(20),f);
} else {
if((state_val_63603 === (3))){
var inst_63600 = (state_63602[(2)]);
var state_63602__$1 = state_63602;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63602__$1,inst_63600);
} else {
if((state_val_63603 === (12))){
var inst_63558 = (state_63602[(8)]);
var inst_63584 = (state_63602[(2)]);
var inst_63585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63584,(0),null);
var inst_63586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63584,(1),null);
var inst_63587 = fluree.db.dbfunctions.internal.if_else(inst_63558,inst_63585,inst_63586);
var inst_63588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63589 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63591 = [inst_63558,inst_63585,inst_63586];
var inst_63592 = (new cljs.core.PersistentVector(null,3,(5),inst_63590,inst_63591,null));
var inst_63593 = ["if-else",inst_63592,inst_63587];
var inst_63594 = cljs.core.PersistentHashMap.fromArrays(inst_63589,inst_63593);
var inst_63595 = [inst_63594,(10)];
var inst_63596 = (new cljs.core.PersistentVector(null,2,(5),inst_63588,inst_63595,null));
var inst_63597 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63596);
var _ = (function (){var statearr_63609 = state_63602;
(statearr_63609[(4)] = cljs.core.rest((state_63602[(4)])));

return statearr_63609;
})();
var state_63602__$1 = (function (){var statearr_63610 = state_63602;
(statearr_63610[(9)] = inst_63597);

return statearr_63610;
})();
var statearr_63611_63643 = state_63602__$1;
(statearr_63611_63643[(2)] = inst_63587);

(statearr_63611_63643[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (2))){
var _ = (function (){var statearr_63612 = state_63602;
(statearr_63612[(4)] = cljs.core.cons((5),(state_63602[(4)])));

return statearr_63612;
})();
var inst_63551 = fluree.db.util.async.channel_QMARK_(test);
var state_63602__$1 = state_63602;
if(inst_63551){
var statearr_63613_63644 = state_63602__$1;
(statearr_63613_63644[(1)] = (6));

} else {
var statearr_63614_63645 = state_63602__$1;
(statearr_63614_63645[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (19))){
var inst_63572 = (state_63602[(10)]);
var inst_63580 = (state_63602[(2)]);
var inst_63581 = [f,inst_63580];
var inst_63582 = (new cljs.core.PersistentVector(null,2,(5),inst_63572,inst_63581,null));
var state_63602__$1 = state_63602;
var statearr_63615_63646 = state_63602__$1;
(statearr_63615_63646[(2)] = inst_63582);

(statearr_63615_63646[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (11))){
var inst_63572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63573 = fluree.db.util.async.channel_QMARK_(f);
var state_63602__$1 = (function (){var statearr_63617 = state_63602;
(statearr_63617[(10)] = inst_63572);

return statearr_63617;
})();
if(inst_63573){
var statearr_63618_63647 = state_63602__$1;
(statearr_63618_63647[(1)] = (17));

} else {
var statearr_63619_63648 = state_63602__$1;
(statearr_63619_63648[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (9))){
var inst_63554 = (state_63602[(2)]);
var inst_63555 = fluree.db.util.async.throw_err(inst_63554);
var state_63602__$1 = state_63602;
var statearr_63620_63649 = state_63602__$1;
(statearr_63620_63649[(2)] = inst_63555);

(statearr_63620_63649[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (5))){
var _ = (function (){var statearr_63621 = state_63602;
(statearr_63621[(4)] = cljs.core.rest((state_63602[(4)])));

return statearr_63621;
})();
var state_63602__$1 = state_63602;
var ex63616 = (state_63602__$1[(2)]);
var statearr_63622_63650 = state_63602__$1;
(statearr_63622_63650[(5)] = ex63616);


if((ex63616 instanceof Error)){
var statearr_63623_63651 = state_63602__$1;
(statearr_63623_63651[(1)] = (4));

(statearr_63623_63651[(5)] = null);

} else {
throw ex63616;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (14))){
var state_63602__$1 = state_63602;
var statearr_63624_63652 = state_63602__$1;
(statearr_63624_63652[(2)] = t);

(statearr_63624_63652[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (16))){
var inst_63564 = (state_63602[(2)]);
var inst_63565 = fluree.db.util.async.throw_err(inst_63564);
var state_63602__$1 = state_63602;
var statearr_63625_63653 = state_63602__$1;
(statearr_63625_63653[(2)] = inst_63565);

(statearr_63625_63653[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (10))){
var inst_63560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63561 = fluree.db.util.async.channel_QMARK_(t);
var state_63602__$1 = (function (){var statearr_63626 = state_63602;
(statearr_63626[(7)] = inst_63560);

return statearr_63626;
})();
if(inst_63561){
var statearr_63627_63654 = state_63602__$1;
(statearr_63627_63654[(1)] = (13));

} else {
var statearr_63628_63655 = state_63602__$1;
(statearr_63628_63655[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (18))){
var state_63602__$1 = state_63602;
var statearr_63629_63656 = state_63602__$1;
(statearr_63629_63656[(2)] = f);

(statearr_63629_63656[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63603 === (8))){
var inst_63558 = (state_63602[(8)]);
var inst_63558__$1 = (state_63602[(2)]);
var state_63602__$1 = (function (){var statearr_63630 = state_63602;
(statearr_63630[(8)] = inst_63558__$1);

return statearr_63630;
})();
if(cljs.core.truth_(inst_63558__$1)){
var statearr_63631_63657 = state_63602__$1;
(statearr_63631_63657[(1)] = (10));

} else {
var statearr_63632_63658 = state_63602__$1;
(statearr_63632_63658[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto____0 = (function (){
var statearr_63633 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63633[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto__);

(statearr_63633[(1)] = (1));

return statearr_63633;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto____1 = (function (state_63602){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63602);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63634){var ex__10844__auto__ = e63634;
var statearr_63635_63659 = state_63602;
(statearr_63635_63659[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63602[(4)]))){
var statearr_63636_63660 = state_63602;
(statearr_63636_63660[(1)] = cljs.core.first((state_63602[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63661 = state_63602;
state_63602 = G__63661;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto__ = function(state_63602){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto____1.call(this,state_63602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63637 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63637[(6)] = c__10878__auto__);

return statearr_63637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63691){
var state_val_63692 = (state_63691[(1)]);
if((state_val_63692 === (7))){
var state_63691__$1 = state_63691;
var statearr_63693_63712 = state_63691__$1;
(statearr_63693_63712[(2)] = arg);

(statearr_63693_63712[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63692 === (1))){
var state_63691__$1 = state_63691;
var statearr_63694_63713 = state_63691__$1;
(statearr_63694_63713[(2)] = null);

(statearr_63694_63713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63692 === (4))){
var inst_63662 = (state_63691[(2)]);
var state_63691__$1 = state_63691;
var statearr_63695_63714 = state_63691__$1;
(statearr_63695_63714[(2)] = inst_63662);

(statearr_63695_63714[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63692 === (6))){
var state_63691__$1 = state_63691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63691__$1,(9),arg);
} else {
if((state_val_63692 === (3))){
var inst_63689 = (state_63691[(2)]);
var state_63691__$1 = state_63691;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63691__$1,inst_63689);
} else {
if((state_val_63692 === (2))){
var _ = (function (){var statearr_63697 = state_63691;
(statearr_63697[(4)] = cljs.core.cons((5),(state_63691[(4)])));

return statearr_63697;
})();
var inst_63668 = fluree.db.util.async.channel_QMARK_(arg);
var state_63691__$1 = state_63691;
if(inst_63668){
var statearr_63698_63715 = state_63691__$1;
(statearr_63698_63715[(1)] = (6));

} else {
var statearr_63699_63716 = state_63691__$1;
(statearr_63699_63716[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63692 === (9))){
var inst_63671 = (state_63691[(2)]);
var inst_63672 = fluree.db.util.async.throw_err(inst_63671);
var state_63691__$1 = state_63691;
var statearr_63700_63717 = state_63691__$1;
(statearr_63700_63717[(2)] = inst_63672);

(statearr_63700_63717[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63692 === (5))){
var _ = (function (){var statearr_63701 = state_63691;
(statearr_63701[(4)] = cljs.core.rest((state_63691[(4)])));

return statearr_63701;
})();
var state_63691__$1 = state_63691;
var ex63696 = (state_63691__$1[(2)]);
var statearr_63702_63718 = state_63691__$1;
(statearr_63702_63718[(5)] = ex63696);


if((ex63696 instanceof Error)){
var statearr_63703_63719 = state_63691__$1;
(statearr_63703_63719[(1)] = (4));

(statearr_63703_63719[(5)] = null);

} else {
throw ex63696;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63692 === (8))){
var inst_63675 = (state_63691[(2)]);
var inst_63676 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_63675);
var inst_63677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63678 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63680 = [inst_63675];
var inst_63681 = (new cljs.core.PersistentVector(null,1,(5),inst_63679,inst_63680,null));
var inst_63682 = ["nil?",inst_63681,inst_63676];
var inst_63683 = cljs.core.PersistentHashMap.fromArrays(inst_63678,inst_63682);
var inst_63684 = [inst_63683,(10)];
var inst_63685 = (new cljs.core.PersistentVector(null,2,(5),inst_63677,inst_63684,null));
var inst_63686 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63685);
var _ = (function (){var statearr_63704 = state_63691;
(statearr_63704[(4)] = cljs.core.rest((state_63691[(4)])));

return statearr_63704;
})();
var state_63691__$1 = (function (){var statearr_63705 = state_63691;
(statearr_63705[(7)] = inst_63686);

return statearr_63705;
})();
var statearr_63706_63720 = state_63691__$1;
(statearr_63706_63720[(2)] = inst_63676);

(statearr_63706_63720[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto____0 = (function (){
var statearr_63707 = [null,null,null,null,null,null,null,null];
(statearr_63707[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto__);

(statearr_63707[(1)] = (1));

return statearr_63707;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto____1 = (function (state_63691){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63691);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63708){var ex__10844__auto__ = e63708;
var statearr_63709_63721 = state_63691;
(statearr_63709_63721[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63691[(4)]))){
var statearr_63710_63722 = state_63691;
(statearr_63710_63722[(1)] = cljs.core.first((state_63691[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63723 = state_63691;
state_63691 = G__63723;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto__ = function(state_63691){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto____1.call(this,state_63691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63711 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63711[(6)] = c__10878__auto__);

return statearr_63711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63753){
var state_val_63754 = (state_63753[(1)]);
if((state_val_63754 === (7))){
var state_63753__$1 = state_63753;
var statearr_63755_63774 = state_63753__$1;
(statearr_63755_63774[(2)] = arg);

(statearr_63755_63774[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63754 === (1))){
var state_63753__$1 = state_63753;
var statearr_63756_63775 = state_63753__$1;
(statearr_63756_63775[(2)] = null);

(statearr_63756_63775[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63754 === (4))){
var inst_63724 = (state_63753[(2)]);
var state_63753__$1 = state_63753;
var statearr_63757_63776 = state_63753__$1;
(statearr_63757_63776[(2)] = inst_63724);

(statearr_63757_63776[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63754 === (6))){
var state_63753__$1 = state_63753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63753__$1,(9),arg);
} else {
if((state_val_63754 === (3))){
var inst_63751 = (state_63753[(2)]);
var state_63753__$1 = state_63753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63753__$1,inst_63751);
} else {
if((state_val_63754 === (2))){
var _ = (function (){var statearr_63759 = state_63753;
(statearr_63759[(4)] = cljs.core.cons((5),(state_63753[(4)])));

return statearr_63759;
})();
var inst_63730 = fluree.db.util.async.channel_QMARK_(arg);
var state_63753__$1 = state_63753;
if(inst_63730){
var statearr_63760_63777 = state_63753__$1;
(statearr_63760_63777[(1)] = (6));

} else {
var statearr_63761_63778 = state_63753__$1;
(statearr_63761_63778[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63754 === (9))){
var inst_63733 = (state_63753[(2)]);
var inst_63734 = fluree.db.util.async.throw_err(inst_63733);
var state_63753__$1 = state_63753;
var statearr_63762_63779 = state_63753__$1;
(statearr_63762_63779[(2)] = inst_63734);

(statearr_63762_63779[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63754 === (5))){
var _ = (function (){var statearr_63763 = state_63753;
(statearr_63763[(4)] = cljs.core.rest((state_63753[(4)])));

return statearr_63763;
})();
var state_63753__$1 = state_63753;
var ex63758 = (state_63753__$1[(2)]);
var statearr_63764_63780 = state_63753__$1;
(statearr_63764_63780[(5)] = ex63758);


if((ex63758 instanceof Error)){
var statearr_63765_63781 = state_63753__$1;
(statearr_63765_63781[(1)] = (4));

(statearr_63765_63781[(5)] = null);

} else {
throw ex63758;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63754 === (8))){
var inst_63737 = (state_63753[(2)]);
var inst_63738 = fluree.db.dbfunctions.internal.not(inst_63737);
var inst_63739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63740 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63741 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63742 = [inst_63737];
var inst_63743 = (new cljs.core.PersistentVector(null,1,(5),inst_63741,inst_63742,null));
var inst_63744 = ["not?",inst_63743,inst_63738];
var inst_63745 = cljs.core.PersistentHashMap.fromArrays(inst_63740,inst_63744);
var inst_63746 = [inst_63745,(10)];
var inst_63747 = (new cljs.core.PersistentVector(null,2,(5),inst_63739,inst_63746,null));
var inst_63748 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63747);
var _ = (function (){var statearr_63766 = state_63753;
(statearr_63766[(4)] = cljs.core.rest((state_63753[(4)])));

return statearr_63766;
})();
var state_63753__$1 = (function (){var statearr_63767 = state_63753;
(statearr_63767[(7)] = inst_63748);

return statearr_63767;
})();
var statearr_63768_63782 = state_63753__$1;
(statearr_63768_63782[(2)] = inst_63738);

(statearr_63768_63782[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto____0 = (function (){
var statearr_63769 = [null,null,null,null,null,null,null,null];
(statearr_63769[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto__);

(statearr_63769[(1)] = (1));

return statearr_63769;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto____1 = (function (state_63753){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63753);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63770){var ex__10844__auto__ = e63770;
var statearr_63771_63783 = state_63753;
(statearr_63771_63783[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63753[(4)]))){
var statearr_63772_63784 = state_63753;
(statearr_63772_63784[(1)] = cljs.core.first((state_63753[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63785 = state_63753;
state_63753 = G__63785;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto__ = function(state_63753){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto____1.call(this,state_63753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63773 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63773[(6)] = c__10878__auto__);

return statearr_63773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63815){
var state_val_63816 = (state_63815[(1)]);
if((state_val_63816 === (7))){
var state_63815__$1 = state_63815;
var statearr_63817_63836 = state_63815__$1;
(statearr_63817_63836[(2)] = arg);

(statearr_63817_63836[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63816 === (1))){
var state_63815__$1 = state_63815;
var statearr_63818_63837 = state_63815__$1;
(statearr_63818_63837[(2)] = null);

(statearr_63818_63837[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63816 === (4))){
var inst_63786 = (state_63815[(2)]);
var state_63815__$1 = state_63815;
var statearr_63819_63838 = state_63815__$1;
(statearr_63819_63838[(2)] = inst_63786);

(statearr_63819_63838[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63816 === (6))){
var state_63815__$1 = state_63815;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63815__$1,(9),arg);
} else {
if((state_val_63816 === (3))){
var inst_63813 = (state_63815[(2)]);
var state_63815__$1 = state_63815;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63815__$1,inst_63813);
} else {
if((state_val_63816 === (2))){
var _ = (function (){var statearr_63821 = state_63815;
(statearr_63821[(4)] = cljs.core.cons((5),(state_63815[(4)])));

return statearr_63821;
})();
var inst_63792 = fluree.db.util.async.channel_QMARK_(arg);
var state_63815__$1 = state_63815;
if(inst_63792){
var statearr_63822_63839 = state_63815__$1;
(statearr_63822_63839[(1)] = (6));

} else {
var statearr_63823_63840 = state_63815__$1;
(statearr_63823_63840[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63816 === (9))){
var inst_63795 = (state_63815[(2)]);
var inst_63796 = fluree.db.util.async.throw_err(inst_63795);
var state_63815__$1 = state_63815;
var statearr_63824_63841 = state_63815__$1;
(statearr_63824_63841[(2)] = inst_63796);

(statearr_63824_63841[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63816 === (5))){
var _ = (function (){var statearr_63825 = state_63815;
(statearr_63825[(4)] = cljs.core.rest((state_63815[(4)])));

return statearr_63825;
})();
var state_63815__$1 = state_63815;
var ex63820 = (state_63815__$1[(2)]);
var statearr_63826_63842 = state_63815__$1;
(statearr_63826_63842[(5)] = ex63820);


if((ex63820 instanceof Error)){
var statearr_63827_63843 = state_63815__$1;
(statearr_63827_63843[(1)] = (4));

(statearr_63827_63843[(5)] = null);

} else {
throw ex63820;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63816 === (8))){
var inst_63799 = (state_63815[(2)]);
var inst_63800 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_63799);
var inst_63801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63802 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63804 = [inst_63799];
var inst_63805 = (new cljs.core.PersistentVector(null,1,(5),inst_63803,inst_63804,null));
var inst_63806 = ["empty?",inst_63805,inst_63800];
var inst_63807 = cljs.core.PersistentHashMap.fromArrays(inst_63802,inst_63806);
var inst_63808 = [inst_63807,(10)];
var inst_63809 = (new cljs.core.PersistentVector(null,2,(5),inst_63801,inst_63808,null));
var inst_63810 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63809);
var _ = (function (){var statearr_63828 = state_63815;
(statearr_63828[(4)] = cljs.core.rest((state_63815[(4)])));

return statearr_63828;
})();
var state_63815__$1 = (function (){var statearr_63829 = state_63815;
(statearr_63829[(7)] = inst_63810);

return statearr_63829;
})();
var statearr_63830_63844 = state_63815__$1;
(statearr_63830_63844[(2)] = inst_63800);

(statearr_63830_63844[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto____0 = (function (){
var statearr_63831 = [null,null,null,null,null,null,null,null];
(statearr_63831[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto__);

(statearr_63831[(1)] = (1));

return statearr_63831;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto____1 = (function (state_63815){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63815);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63832){var ex__10844__auto__ = e63832;
var statearr_63833_63845 = state_63815;
(statearr_63833_63845[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63815[(4)]))){
var statearr_63834_63846 = state_63815;
(statearr_63834_63846[(1)] = cljs.core.first((state_63815[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63847 = state_63815;
state_63815 = G__63847;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto__ = function(state_63815){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto____1.call(this,state_63815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63835 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63835[(6)] = c__10878__auto__);

return statearr_63835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___63892 = arguments.length;
var i__4830__auto___63893 = (0);
while(true){
if((i__4830__auto___63893 < len__4829__auto___63892)){
args__4835__auto__.push((arguments[i__4830__auto___63893]));

var G__63894 = (i__4830__auto___63893 + (1));
i__4830__auto___63893 = G__63894;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63875){
var state_val_63876 = (state_63875[(1)]);
if((state_val_63876 === (1))){
var state_63875__$1 = state_63875;
var statearr_63877_63895 = state_63875__$1;
(statearr_63877_63895[(2)] = null);

(statearr_63877_63895[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63876 === (2))){
var _ = (function (){var statearr_63878 = state_63875;
(statearr_63878[(4)] = cljs.core.cons((5),(state_63875[(4)])));

return statearr_63878;
})();
var inst_63856 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_63875__$1 = state_63875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63875__$1,(6),inst_63856);
} else {
if((state_val_63876 === (3))){
var inst_63873 = (state_63875[(2)]);
var state_63875__$1 = state_63875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63875__$1,inst_63873);
} else {
if((state_val_63876 === (4))){
var inst_63850 = (state_63875[(2)]);
var state_63875__$1 = state_63875;
var statearr_63880_63896 = state_63875__$1;
(statearr_63880_63896[(2)] = inst_63850);

(statearr_63880_63896[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63876 === (5))){
var _ = (function (){var statearr_63881 = state_63875;
(statearr_63881[(4)] = cljs.core.rest((state_63875[(4)])));

return statearr_63881;
})();
var state_63875__$1 = state_63875;
var ex63879 = (state_63875__$1[(2)]);
var statearr_63882_63897 = state_63875__$1;
(statearr_63882_63897[(5)] = ex63879);


if((ex63879 instanceof Error)){
var statearr_63883_63898 = state_63875__$1;
(statearr_63883_63898[(1)] = (4));

(statearr_63883_63898[(5)] = null);

} else {
throw ex63879;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63876 === (6))){
var inst_63858 = (state_63875[(2)]);
var inst_63859 = fluree.db.util.async.throw_err(inst_63858);
var inst_63860 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_63859);
var inst_63861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63862 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63864 = [inst_63859];
var inst_63865 = (new cljs.core.PersistentVector(null,1,(5),inst_63863,inst_63864,null));
var inst_63866 = ["str",inst_63865,inst_63860];
var inst_63867 = cljs.core.PersistentHashMap.fromArrays(inst_63862,inst_63866);
var inst_63868 = [inst_63867,(10)];
var inst_63869 = (new cljs.core.PersistentVector(null,2,(5),inst_63861,inst_63868,null));
var inst_63870 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63869);
var _ = (function (){var statearr_63884 = state_63875;
(statearr_63884[(4)] = cljs.core.rest((state_63875[(4)])));

return statearr_63884;
})();
var state_63875__$1 = (function (){var statearr_63885 = state_63875;
(statearr_63885[(7)] = inst_63870);

return statearr_63885;
})();
var statearr_63886_63899 = state_63875__$1;
(statearr_63886_63899[(2)] = inst_63860);

(statearr_63886_63899[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_63887 = [null,null,null,null,null,null,null,null];
(statearr_63887[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_63887[(1)] = (1));

return statearr_63887;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_63875){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63875);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63888){var ex__10844__auto__ = e63888;
var statearr_63889_63900 = state_63875;
(statearr_63889_63900[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63875[(4)]))){
var statearr_63890_63901 = state_63875;
(statearr_63890_63901[(1)] = cljs.core.first((state_63875[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63902 = state_63875;
state_63875 = G__63902;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_63875){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_63875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63891 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63891[(6)] = c__10878__auto__);

return statearr_63891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq63848){
var G__63849 = cljs.core.first(seq63848);
var seq63848__$1 = cljs.core.next(seq63848);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63849,seq63848__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63928){
var state_val_63929 = (state_63928[(1)]);
if((state_val_63929 === (1))){
var state_63928__$1 = state_63928;
var statearr_63930_63945 = state_63928__$1;
(statearr_63930_63945[(2)] = null);

(statearr_63930_63945[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63929 === (2))){
var _ = (function (){var statearr_63931 = state_63928;
(statearr_63931[(4)] = cljs.core.cons((5),(state_63928[(4)])));

return statearr_63931;
})();
var inst_63909 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_63928__$1 = state_63928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63928__$1,(6),inst_63909);
} else {
if((state_val_63929 === (3))){
var inst_63926 = (state_63928[(2)]);
var state_63928__$1 = state_63928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63928__$1,inst_63926);
} else {
if((state_val_63929 === (4))){
var inst_63903 = (state_63928[(2)]);
var state_63928__$1 = state_63928;
var statearr_63933_63946 = state_63928__$1;
(statearr_63933_63946[(2)] = inst_63903);

(statearr_63933_63946[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63929 === (5))){
var _ = (function (){var statearr_63934 = state_63928;
(statearr_63934[(4)] = cljs.core.rest((state_63928[(4)])));

return statearr_63934;
})();
var state_63928__$1 = state_63928;
var ex63932 = (state_63928__$1[(2)]);
var statearr_63935_63947 = state_63928__$1;
(statearr_63935_63947[(5)] = ex63932);


if((ex63932 instanceof Error)){
var statearr_63936_63948 = state_63928__$1;
(statearr_63936_63948[(1)] = (4));

(statearr_63936_63948[(5)] = null);

} else {
throw ex63932;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63929 === (6))){
var inst_63911 = (state_63928[(2)]);
var inst_63912 = fluree.db.util.async.throw_err(inst_63911);
var inst_63913 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_63912);
var inst_63914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63915 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63917 = [inst_63912];
var inst_63918 = (new cljs.core.PersistentVector(null,1,(5),inst_63916,inst_63917,null));
var inst_63919 = ["subs",inst_63918,inst_63913];
var inst_63920 = cljs.core.PersistentHashMap.fromArrays(inst_63915,inst_63919);
var inst_63921 = [inst_63920,(30)];
var inst_63922 = (new cljs.core.PersistentVector(null,2,(5),inst_63914,inst_63921,null));
var inst_63923 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63922);
var _ = (function (){var statearr_63937 = state_63928;
(statearr_63937[(4)] = cljs.core.rest((state_63928[(4)])));

return statearr_63937;
})();
var state_63928__$1 = (function (){var statearr_63938 = state_63928;
(statearr_63938[(7)] = inst_63923);

return statearr_63938;
})();
var statearr_63939_63949 = state_63928__$1;
(statearr_63939_63949[(2)] = inst_63913);

(statearr_63939_63949[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto____0 = (function (){
var statearr_63940 = [null,null,null,null,null,null,null,null];
(statearr_63940[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto__);

(statearr_63940[(1)] = (1));

return statearr_63940;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto____1 = (function (state_63928){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63928);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63941){var ex__10844__auto__ = e63941;
var statearr_63942_63950 = state_63928;
(statearr_63942_63950[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63928[(4)]))){
var statearr_63943_63951 = state_63928;
(statearr_63943_63951[(1)] = cljs.core.first((state_63928[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__63952 = state_63928;
state_63928 = G__63952;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto__ = function(state_63928){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto____1.call(this,state_63928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_63944 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_63944[(6)] = c__10878__auto__);

return statearr_63944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_63982){
var state_val_63983 = (state_63982[(1)]);
if((state_val_63983 === (7))){
var state_63982__$1 = state_63982;
var statearr_63984_64003 = state_63982__$1;
(statearr_63984_64003[(2)] = str);

(statearr_63984_64003[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63983 === (1))){
var state_63982__$1 = state_63982;
var statearr_63985_64004 = state_63982__$1;
(statearr_63985_64004[(2)] = null);

(statearr_63985_64004[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63983 === (4))){
var inst_63953 = (state_63982[(2)]);
var state_63982__$1 = state_63982;
var statearr_63986_64005 = state_63982__$1;
(statearr_63986_64005[(2)] = inst_63953);

(statearr_63986_64005[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63983 === (6))){
var state_63982__$1 = state_63982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63982__$1,(9),str);
} else {
if((state_val_63983 === (3))){
var inst_63980 = (state_63982[(2)]);
var state_63982__$1 = state_63982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63982__$1,inst_63980);
} else {
if((state_val_63983 === (2))){
var _ = (function (){var statearr_63988 = state_63982;
(statearr_63988[(4)] = cljs.core.cons((5),(state_63982[(4)])));

return statearr_63988;
})();
var inst_63959 = fluree.db.util.async.channel_QMARK_(str);
var state_63982__$1 = state_63982;
if(inst_63959){
var statearr_63989_64006 = state_63982__$1;
(statearr_63989_64006[(1)] = (6));

} else {
var statearr_63990_64007 = state_63982__$1;
(statearr_63990_64007[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63983 === (9))){
var inst_63962 = (state_63982[(2)]);
var inst_63963 = fluree.db.util.async.throw_err(inst_63962);
var state_63982__$1 = state_63982;
var statearr_63991_64008 = state_63982__$1;
(statearr_63991_64008[(2)] = inst_63963);

(statearr_63991_64008[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_63983 === (5))){
var _ = (function (){var statearr_63992 = state_63982;
(statearr_63992[(4)] = cljs.core.rest((state_63982[(4)])));

return statearr_63992;
})();
var state_63982__$1 = state_63982;
var ex63987 = (state_63982__$1[(2)]);
var statearr_63993_64009 = state_63982__$1;
(statearr_63993_64009[(5)] = ex63987);


if((ex63987 instanceof Error)){
var statearr_63994_64010 = state_63982__$1;
(statearr_63994_64010[(1)] = (4));

(statearr_63994_64010[(5)] = null);

} else {
throw ex63987;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_63983 === (8))){
var inst_63966 = (state_63982[(2)]);
var inst_63967 = fluree.db.dbfunctions.internal.lower_case(inst_63966);
var inst_63968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63969 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_63970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63971 = [inst_63966];
var inst_63972 = (new cljs.core.PersistentVector(null,1,(5),inst_63970,inst_63971,null));
var inst_63973 = ["lower-case",inst_63972,inst_63967];
var inst_63974 = cljs.core.PersistentHashMap.fromArrays(inst_63969,inst_63973);
var inst_63975 = [inst_63974,(10)];
var inst_63976 = (new cljs.core.PersistentVector(null,2,(5),inst_63968,inst_63975,null));
var inst_63977 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_63976);
var _ = (function (){var statearr_63995 = state_63982;
(statearr_63995[(4)] = cljs.core.rest((state_63982[(4)])));

return statearr_63995;
})();
var state_63982__$1 = (function (){var statearr_63996 = state_63982;
(statearr_63996[(7)] = inst_63977);

return statearr_63996;
})();
var statearr_63997_64011 = state_63982__$1;
(statearr_63997_64011[(2)] = inst_63967);

(statearr_63997_64011[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto____0 = (function (){
var statearr_63998 = [null,null,null,null,null,null,null,null];
(statearr_63998[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto__);

(statearr_63998[(1)] = (1));

return statearr_63998;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto____1 = (function (state_63982){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_63982);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e63999){var ex__10844__auto__ = e63999;
var statearr_64000_64012 = state_63982;
(statearr_64000_64012[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_63982[(4)]))){
var statearr_64001_64013 = state_63982;
(statearr_64001_64013[(1)] = cljs.core.first((state_63982[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64014 = state_63982;
state_63982 = G__64014;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto__ = function(state_63982){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto____1.call(this,state_63982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64002 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64002[(6)] = c__10878__auto__);

return statearr_64002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64044){
var state_val_64045 = (state_64044[(1)]);
if((state_val_64045 === (7))){
var state_64044__$1 = state_64044;
var statearr_64046_64065 = state_64044__$1;
(statearr_64046_64065[(2)] = str);

(statearr_64046_64065[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64045 === (1))){
var state_64044__$1 = state_64044;
var statearr_64047_64066 = state_64044__$1;
(statearr_64047_64066[(2)] = null);

(statearr_64047_64066[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64045 === (4))){
var inst_64015 = (state_64044[(2)]);
var state_64044__$1 = state_64044;
var statearr_64048_64067 = state_64044__$1;
(statearr_64048_64067[(2)] = inst_64015);

(statearr_64048_64067[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64045 === (6))){
var state_64044__$1 = state_64044;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64044__$1,(9),str);
} else {
if((state_val_64045 === (3))){
var inst_64042 = (state_64044[(2)]);
var state_64044__$1 = state_64044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64044__$1,inst_64042);
} else {
if((state_val_64045 === (2))){
var _ = (function (){var statearr_64050 = state_64044;
(statearr_64050[(4)] = cljs.core.cons((5),(state_64044[(4)])));

return statearr_64050;
})();
var inst_64021 = fluree.db.util.async.channel_QMARK_(str);
var state_64044__$1 = state_64044;
if(inst_64021){
var statearr_64051_64068 = state_64044__$1;
(statearr_64051_64068[(1)] = (6));

} else {
var statearr_64052_64069 = state_64044__$1;
(statearr_64052_64069[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64045 === (9))){
var inst_64024 = (state_64044[(2)]);
var inst_64025 = fluree.db.util.async.throw_err(inst_64024);
var state_64044__$1 = state_64044;
var statearr_64053_64070 = state_64044__$1;
(statearr_64053_64070[(2)] = inst_64025);

(statearr_64053_64070[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64045 === (5))){
var _ = (function (){var statearr_64054 = state_64044;
(statearr_64054[(4)] = cljs.core.rest((state_64044[(4)])));

return statearr_64054;
})();
var state_64044__$1 = state_64044;
var ex64049 = (state_64044__$1[(2)]);
var statearr_64055_64071 = state_64044__$1;
(statearr_64055_64071[(5)] = ex64049);


if((ex64049 instanceof Error)){
var statearr_64056_64072 = state_64044__$1;
(statearr_64056_64072[(1)] = (4));

(statearr_64056_64072[(5)] = null);

} else {
throw ex64049;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64045 === (8))){
var inst_64028 = (state_64044[(2)]);
var inst_64029 = fluree.db.dbfunctions.internal.upper_case(inst_64028);
var inst_64030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64031 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64033 = [inst_64028];
var inst_64034 = (new cljs.core.PersistentVector(null,1,(5),inst_64032,inst_64033,null));
var inst_64035 = ["upper-case",inst_64034,inst_64029];
var inst_64036 = cljs.core.PersistentHashMap.fromArrays(inst_64031,inst_64035);
var inst_64037 = [inst_64036,(10)];
var inst_64038 = (new cljs.core.PersistentVector(null,2,(5),inst_64030,inst_64037,null));
var inst_64039 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64038);
var _ = (function (){var statearr_64057 = state_64044;
(statearr_64057[(4)] = cljs.core.rest((state_64044[(4)])));

return statearr_64057;
})();
var state_64044__$1 = (function (){var statearr_64058 = state_64044;
(statearr_64058[(7)] = inst_64039);

return statearr_64058;
})();
var statearr_64059_64073 = state_64044__$1;
(statearr_64059_64073[(2)] = inst_64029);

(statearr_64059_64073[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto____0 = (function (){
var statearr_64060 = [null,null,null,null,null,null,null,null];
(statearr_64060[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto__);

(statearr_64060[(1)] = (1));

return statearr_64060;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto____1 = (function (state_64044){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64044);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64061){var ex__10844__auto__ = e64061;
var statearr_64062_64074 = state_64044;
(statearr_64062_64074[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64044[(4)]))){
var statearr_64063_64075 = state_64044;
(statearr_64063_64075[(1)] = cljs.core.first((state_64044[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64076 = state_64044;
state_64044 = G__64076;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto__ = function(state_64044){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto____1.call(this,state_64044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64064 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64064[(6)] = c__10878__auto__);

return statearr_64064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__64078 = arguments.length;
switch (G__64078) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64106){
var state_val_64107 = (state_64106[(1)]);
if((state_val_64107 === (1))){
var state_64106__$1 = state_64106;
var statearr_64108_64124 = state_64106__$1;
(statearr_64108_64124[(2)] = null);

(statearr_64108_64124[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64107 === (2))){
var _ = (function (){var statearr_64109 = state_64106;
(statearr_64109[(4)] = cljs.core.cons((5),(state_64106[(4)])));

return statearr_64109;
})();
var inst_64088 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_64106__$1 = state_64106;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64106__$1,(6),inst_64088);
} else {
if((state_val_64107 === (3))){
var inst_64104 = (state_64106[(2)]);
var state_64106__$1 = state_64106;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64106__$1,inst_64104);
} else {
if((state_val_64107 === (4))){
var inst_64079 = (state_64106[(2)]);
var state_64106__$1 = state_64106;
var statearr_64111_64125 = state_64106__$1;
(statearr_64111_64125[(2)] = inst_64079);

(statearr_64111_64125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64107 === (5))){
var _ = (function (){var statearr_64112 = state_64106;
(statearr_64112[(4)] = cljs.core.rest((state_64106[(4)])));

return statearr_64112;
})();
var state_64106__$1 = state_64106;
var ex64110 = (state_64106__$1[(2)]);
var statearr_64113_64126 = state_64106__$1;
(statearr_64113_64126[(5)] = ex64110);


if((ex64110 instanceof Error)){
var statearr_64114_64127 = state_64106__$1;
(statearr_64114_64127[(1)] = (4));

(statearr_64114_64127[(5)] = null);

} else {
throw ex64110;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64107 === (6))){
var inst_64090 = (state_64106[(2)]);
var inst_64091 = fluree.db.util.async.throw_err(inst_64090);
var inst_64092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64091,(0),null);
var inst_64093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64091,(1),null);
var inst_64094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64095 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64096 = ["?s","?ctx",inst_64092];
var inst_64097 = cljs.core.PersistentHashMap.fromArrays(inst_64095,inst_64096);
var inst_64098 = ((10) + inst_64093);
var inst_64099 = [inst_64097,inst_64098];
var inst_64100 = (new cljs.core.PersistentVector(null,2,(5),inst_64094,inst_64099,null));
var inst_64101 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64100);
var _ = (function (){var statearr_64115 = state_64106;
(statearr_64115[(4)] = cljs.core.rest((state_64106[(4)])));

return statearr_64115;
})();
var state_64106__$1 = (function (){var statearr_64116 = state_64106;
(statearr_64116[(7)] = inst_64101);

return statearr_64116;
})();
var statearr_64117_64128 = state_64106__$1;
(statearr_64117_64128[(2)] = inst_64092);

(statearr_64117_64128[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_64118 = [null,null,null,null,null,null,null,null];
(statearr_64118[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_64118[(1)] = (1));

return statearr_64118;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_64106){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64106);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64119){var ex__10844__auto__ = e64119;
var statearr_64120_64129 = state_64106;
(statearr_64120_64129[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64106[(4)]))){
var statearr_64121_64130 = state_64106;
(statearr_64121_64130[(1)] = cljs.core.first((state_64106[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64131 = state_64106;
state_64106 = G__64131;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_64106){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_64106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64122 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64122[(6)] = c__10878__auto__);

return statearr_64122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__64133 = arguments.length;
switch (G__64133) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64171){
var state_val_64172 = (state_64171[(1)]);
if((state_val_64172 === (7))){
var inst_64164 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_64171__$1 = state_64171;
var statearr_64173_64193 = state_64171__$1;
(statearr_64173_64193[(2)] = inst_64164);

(statearr_64173_64193[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64172 === (1))){
var state_64171__$1 = state_64171;
var statearr_64174_64194 = state_64171__$1;
(statearr_64174_64194[(2)] = null);

(statearr_64174_64194[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64172 === (4))){
var inst_64134 = (state_64171[(2)]);
var state_64171__$1 = state_64171;
var statearr_64175_64195 = state_64171__$1;
(statearr_64175_64195[(2)] = inst_64134);

(statearr_64175_64195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64172 === (6))){
var inst_64145 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_64171__$1 = state_64171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64171__$1,(10),inst_64145);
} else {
if((state_val_64172 === (3))){
var inst_64169 = (state_64171[(2)]);
var state_64171__$1 = state_64171;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64171__$1,inst_64169);
} else {
if((state_val_64172 === (2))){
var _ = (function (){var statearr_64177 = state_64171;
(statearr_64177[(4)] = cljs.core.cons((5),(state_64171[(4)])));

return statearr_64177;
})();
var inst_64140 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64171__$1 = state_64171;
if(cljs.core.truth_(inst_64140)){
var statearr_64178_64196 = state_64171__$1;
(statearr_64178_64196[(1)] = (6));

} else {
var statearr_64179_64197 = state_64171__$1;
(statearr_64179_64197[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64172 === (9))){
var inst_64151 = (state_64171[(2)]);
var inst_64152 = fluree.db.util.async.throw_err(inst_64151);
var inst_64153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64152,(0),null);
var inst_64154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64152,(1),null);
var inst_64155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64156 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64157 = ["?p","?ctx",inst_64153];
var inst_64158 = cljs.core.PersistentHashMap.fromArrays(inst_64156,inst_64157);
var inst_64159 = ((10) + inst_64154);
var inst_64160 = [inst_64158,inst_64159];
var inst_64161 = (new cljs.core.PersistentVector(null,2,(5),inst_64155,inst_64160,null));
var inst_64162 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64161);
var state_64171__$1 = (function (){var statearr_64180 = state_64171;
(statearr_64180[(7)] = inst_64162);

return statearr_64180;
})();
var statearr_64181_64198 = state_64171__$1;
(statearr_64181_64198[(2)] = inst_64153);

(statearr_64181_64198[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64172 === (5))){
var _ = (function (){var statearr_64182 = state_64171;
(statearr_64182[(4)] = cljs.core.rest((state_64171[(4)])));

return statearr_64182;
})();
var state_64171__$1 = state_64171;
var ex64176 = (state_64171__$1[(2)]);
var statearr_64183_64199 = state_64171__$1;
(statearr_64183_64199[(5)] = ex64176);


if((ex64176 instanceof Error)){
var statearr_64184_64200 = state_64171__$1;
(statearr_64184_64200[(1)] = (4));

(statearr_64184_64200[(5)] = null);

} else {
throw ex64176;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64172 === (10))){
var inst_64147 = (state_64171[(2)]);
var inst_64148 = fluree.db.util.async.throw_err(inst_64147);
var inst_64149 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_64148);
var state_64171__$1 = state_64171;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64171__$1,(9),inst_64149);
} else {
if((state_val_64172 === (8))){
var inst_64166 = (state_64171[(2)]);
var _ = (function (){var statearr_64185 = state_64171;
(statearr_64185[(4)] = cljs.core.rest((state_64171[(4)])));

return statearr_64185;
})();
var state_64171__$1 = state_64171;
var statearr_64186_64201 = state_64171__$1;
(statearr_64186_64201[(2)] = inst_64166);

(statearr_64186_64201[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_64187 = [null,null,null,null,null,null,null,null];
(statearr_64187[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_64187[(1)] = (1));

return statearr_64187;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_64171){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64171);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64188){var ex__10844__auto__ = e64188;
var statearr_64189_64202 = state_64171;
(statearr_64189_64202[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64171[(4)]))){
var statearr_64190_64203 = state_64171;
(statearr_64190_64203[(1)] = cljs.core.first((state_64171[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64204 = state_64171;
state_64171 = G__64204;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_64171){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_64171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64191 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64191[(6)] = c__10878__auto__);

return statearr_64191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___64253 = arguments.length;
var i__4830__auto___64254 = (0);
while(true){
if((i__4830__auto___64254 < len__4829__auto___64253)){
args__4835__auto__.push((arguments[i__4830__auto___64254]));

var G__64255 = (i__4830__auto___64254 + (1));
i__4830__auto___64254 = G__64255;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64236){
var state_val_64237 = (state_64236[(1)]);
if((state_val_64237 === (1))){
var state_64236__$1 = state_64236;
var statearr_64238_64256 = state_64236__$1;
(statearr_64238_64256[(2)] = null);

(statearr_64238_64256[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64237 === (2))){
var _ = (function (){var statearr_64239 = state_64236;
(statearr_64239[(4)] = cljs.core.cons((5),(state_64236[(4)])));

return statearr_64239;
})();
var inst_64213 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64236__$1 = state_64236;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64236__$1,(6),inst_64213);
} else {
if((state_val_64237 === (3))){
var inst_64234 = (state_64236[(2)]);
var state_64236__$1 = state_64236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64236__$1,inst_64234);
} else {
if((state_val_64237 === (4))){
var inst_64207 = (state_64236[(2)]);
var state_64236__$1 = state_64236;
var statearr_64241_64257 = state_64236__$1;
(statearr_64241_64257[(2)] = inst_64207);

(statearr_64241_64257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64237 === (5))){
var _ = (function (){var statearr_64242 = state_64236;
(statearr_64242[(4)] = cljs.core.rest((state_64236[(4)])));

return statearr_64242;
})();
var state_64236__$1 = state_64236;
var ex64240 = (state_64236__$1[(2)]);
var statearr_64243_64258 = state_64236__$1;
(statearr_64243_64258[(5)] = ex64240);


if((ex64240 instanceof Error)){
var statearr_64244_64259 = state_64236__$1;
(statearr_64244_64259[(1)] = (4));

(statearr_64244_64259[(5)] = null);

} else {
throw ex64240;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64237 === (6))){
var inst_64215 = (state_64236[(2)]);
var inst_64216 = fluree.db.util.async.throw_err(inst_64215);
var inst_64217 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_64216);
var inst_64218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64219 = [inst_64216];
var inst_64220 = (new cljs.core.PersistentVector(null,1,(5),inst_64218,inst_64219,null));
var inst_64221 = cljs.core.count(inst_64220);
var inst_64222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64223 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64225 = [inst_64216];
var inst_64226 = (new cljs.core.PersistentVector(null,1,(5),inst_64224,inst_64225,null));
var inst_64227 = ["and",inst_64226,inst_64217];
var inst_64228 = cljs.core.PersistentHashMap.fromArrays(inst_64223,inst_64227);
var inst_64229 = [inst_64228,inst_64221];
var inst_64230 = (new cljs.core.PersistentVector(null,2,(5),inst_64222,inst_64229,null));
var inst_64231 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64230);
var _ = (function (){var statearr_64245 = state_64236;
(statearr_64245[(4)] = cljs.core.rest((state_64236[(4)])));

return statearr_64245;
})();
var state_64236__$1 = (function (){var statearr_64246 = state_64236;
(statearr_64246[(7)] = inst_64231);

return statearr_64246;
})();
var statearr_64247_64260 = state_64236__$1;
(statearr_64247_64260[(2)] = inst_64217);

(statearr_64247_64260[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_64248 = [null,null,null,null,null,null,null,null];
(statearr_64248[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_64248[(1)] = (1));

return statearr_64248;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_64236){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64236);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64249){var ex__10844__auto__ = e64249;
var statearr_64250_64261 = state_64236;
(statearr_64250_64261[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64236[(4)]))){
var statearr_64251_64262 = state_64236;
(statearr_64251_64262[(1)] = cljs.core.first((state_64236[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64263 = state_64236;
state_64236 = G__64263;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_64236){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_64236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64252 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64252[(6)] = c__10878__auto__);

return statearr_64252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq64205){
var G__64206 = cljs.core.first(seq64205);
var seq64205__$1 = cljs.core.next(seq64205);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64206,seq64205__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___64312 = arguments.length;
var i__4830__auto___64313 = (0);
while(true){
if((i__4830__auto___64313 < len__4829__auto___64312)){
args__4835__auto__.push((arguments[i__4830__auto___64313]));

var G__64314 = (i__4830__auto___64313 + (1));
i__4830__auto___64313 = G__64314;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64295){
var state_val_64296 = (state_64295[(1)]);
if((state_val_64296 === (1))){
var state_64295__$1 = state_64295;
var statearr_64297_64315 = state_64295__$1;
(statearr_64297_64315[(2)] = null);

(statearr_64297_64315[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64296 === (2))){
var _ = (function (){var statearr_64298 = state_64295;
(statearr_64298[(4)] = cljs.core.cons((5),(state_64295[(4)])));

return statearr_64298;
})();
var inst_64272 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64295__$1 = state_64295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64295__$1,(6),inst_64272);
} else {
if((state_val_64296 === (3))){
var inst_64293 = (state_64295[(2)]);
var state_64295__$1 = state_64295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64295__$1,inst_64293);
} else {
if((state_val_64296 === (4))){
var inst_64266 = (state_64295[(2)]);
var state_64295__$1 = state_64295;
var statearr_64300_64316 = state_64295__$1;
(statearr_64300_64316[(2)] = inst_64266);

(statearr_64300_64316[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64296 === (5))){
var _ = (function (){var statearr_64301 = state_64295;
(statearr_64301[(4)] = cljs.core.rest((state_64295[(4)])));

return statearr_64301;
})();
var state_64295__$1 = state_64295;
var ex64299 = (state_64295__$1[(2)]);
var statearr_64302_64317 = state_64295__$1;
(statearr_64302_64317[(5)] = ex64299);


if((ex64299 instanceof Error)){
var statearr_64303_64318 = state_64295__$1;
(statearr_64303_64318[(1)] = (4));

(statearr_64303_64318[(5)] = null);

} else {
throw ex64299;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64296 === (6))){
var inst_64274 = (state_64295[(2)]);
var inst_64275 = fluree.db.util.async.throw_err(inst_64274);
var inst_64276 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_64275);
var inst_64277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64278 = [inst_64275];
var inst_64279 = (new cljs.core.PersistentVector(null,1,(5),inst_64277,inst_64278,null));
var inst_64280 = cljs.core.count(inst_64279);
var inst_64281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64282 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64284 = [inst_64275];
var inst_64285 = (new cljs.core.PersistentVector(null,1,(5),inst_64283,inst_64284,null));
var inst_64286 = ["or",inst_64285,inst_64276];
var inst_64287 = cljs.core.PersistentHashMap.fromArrays(inst_64282,inst_64286);
var inst_64288 = [inst_64287,inst_64280];
var inst_64289 = (new cljs.core.PersistentVector(null,2,(5),inst_64281,inst_64288,null));
var inst_64290 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64289);
var _ = (function (){var statearr_64304 = state_64295;
(statearr_64304[(4)] = cljs.core.rest((state_64295[(4)])));

return statearr_64304;
})();
var state_64295__$1 = (function (){var statearr_64305 = state_64295;
(statearr_64305[(7)] = inst_64290);

return statearr_64305;
})();
var statearr_64306_64319 = state_64295__$1;
(statearr_64306_64319[(2)] = inst_64276);

(statearr_64306_64319[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_64307 = [null,null,null,null,null,null,null,null];
(statearr_64307[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_64307[(1)] = (1));

return statearr_64307;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_64295){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64295);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64308){var ex__10844__auto__ = e64308;
var statearr_64309_64320 = state_64295;
(statearr_64309_64320[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64295[(4)]))){
var statearr_64310_64321 = state_64295;
(statearr_64310_64321[(1)] = cljs.core.first((state_64295[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64322 = state_64295;
state_64295 = G__64322;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_64295){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_64295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64311 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64311[(6)] = c__10878__auto__);

return statearr_64311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq64264){
var G__64265 = cljs.core.first(seq64264);
var seq64264__$1 = cljs.core.next(seq64264);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64265,seq64264__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64360){
var state_val_64361 = (state_64360[(1)]);
if((state_val_64361 === (7))){
var inst_64336 = fluree.db.util.async.channel_QMARK_(coll);
var state_64360__$1 = state_64360;
if(inst_64336){
var statearr_64362_64385 = state_64360__$1;
(statearr_64362_64385[(1)] = (10));

} else {
var statearr_64363_64386 = state_64360__$1;
(statearr_64363_64386[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (1))){
var state_64360__$1 = state_64360;
var statearr_64364_64387 = state_64360__$1;
(statearr_64364_64387[(2)] = null);

(statearr_64364_64387[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (4))){
var inst_64323 = (state_64360[(2)]);
var state_64360__$1 = state_64360;
var statearr_64365_64388 = state_64360__$1;
(statearr_64365_64388[(2)] = inst_64323);

(statearr_64365_64388[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (13))){
var inst_64339 = (state_64360[(2)]);
var inst_64340 = fluree.db.util.async.throw_err(inst_64339);
var state_64360__$1 = state_64360;
var statearr_64366_64389 = state_64360__$1;
(statearr_64366_64389[(2)] = inst_64340);

(statearr_64366_64389[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (6))){
var inst_64331 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_64360__$1 = state_64360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64360__$1,(9),inst_64331);
} else {
if((state_val_64361 === (3))){
var inst_64358 = (state_64360[(2)]);
var state_64360__$1 = state_64360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64360__$1,inst_64358);
} else {
if((state_val_64361 === (12))){
var inst_64343 = (state_64360[(2)]);
var state_64360__$1 = state_64360;
var statearr_64367_64390 = state_64360__$1;
(statearr_64367_64390[(2)] = inst_64343);

(statearr_64367_64390[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (2))){
var _ = (function (){var statearr_64368 = state_64360;
(statearr_64368[(4)] = cljs.core.cons((5),(state_64360[(4)])));

return statearr_64368;
})();
var inst_64329 = cljs.core.vector_QMARK_(coll);
var state_64360__$1 = state_64360;
if(inst_64329){
var statearr_64369_64391 = state_64360__$1;
(statearr_64369_64391[(1)] = (6));

} else {
var statearr_64370_64392 = state_64360__$1;
(statearr_64370_64392[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (11))){
var state_64360__$1 = state_64360;
var statearr_64372_64393 = state_64360__$1;
(statearr_64372_64393[(2)] = coll);

(statearr_64372_64393[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (9))){
var inst_64333 = (state_64360[(2)]);
var inst_64334 = fluree.db.util.async.throw_err(inst_64333);
var state_64360__$1 = state_64360;
var statearr_64373_64394 = state_64360__$1;
(statearr_64373_64394[(2)] = inst_64334);

(statearr_64373_64394[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (5))){
var _ = (function (){var statearr_64374 = state_64360;
(statearr_64374[(4)] = cljs.core.rest((state_64360[(4)])));

return statearr_64374;
})();
var state_64360__$1 = state_64360;
var ex64371 = (state_64360__$1[(2)]);
var statearr_64375_64395 = state_64360__$1;
(statearr_64375_64395[(5)] = ex64371);


if((ex64371 instanceof Error)){
var statearr_64376_64396 = state_64360__$1;
(statearr_64376_64396[(1)] = (4));

(statearr_64376_64396[(5)] = null);

} else {
throw ex64371;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64361 === (10))){
var state_64360__$1 = state_64360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64360__$1,(13),coll);
} else {
if((state_val_64361 === (8))){
var inst_64345 = (state_64360[(2)]);
var inst_64346 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_64345);
var inst_64347 = cljs.core.count(inst_64346);
var inst_64348 = ((9) + inst_64347);
var inst_64349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64350 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64351 = ["count",inst_64345,inst_64347];
var inst_64352 = cljs.core.PersistentHashMap.fromArrays(inst_64350,inst_64351);
var inst_64353 = [inst_64352,inst_64348];
var inst_64354 = (new cljs.core.PersistentVector(null,2,(5),inst_64349,inst_64353,null));
var inst_64355 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64354);
var _ = (function (){var statearr_64377 = state_64360;
(statearr_64377[(4)] = cljs.core.rest((state_64360[(4)])));

return statearr_64377;
})();
var state_64360__$1 = (function (){var statearr_64378 = state_64360;
(statearr_64378[(7)] = inst_64355);

return statearr_64378;
})();
var statearr_64379_64397 = state_64360__$1;
(statearr_64379_64397[(2)] = inst_64347);

(statearr_64379_64397[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto____0 = (function (){
var statearr_64380 = [null,null,null,null,null,null,null,null];
(statearr_64380[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto__);

(statearr_64380[(1)] = (1));

return statearr_64380;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto____1 = (function (state_64360){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64360);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64381){var ex__10844__auto__ = e64381;
var statearr_64382_64398 = state_64360;
(statearr_64382_64398[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64360[(4)]))){
var statearr_64383_64399 = state_64360;
(statearr_64383_64399[(1)] = cljs.core.first((state_64360[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64400 = state_64360;
state_64360 = G__64400;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto__ = function(state_64360){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto____1.call(this,state_64360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64384 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64384[(6)] = c__10878__auto__);

return statearr_64384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64450){
var state_val_64451 = (state_64450[(1)]);
if((state_val_64451 === (7))){
var state_64450__$1 = state_64450;
var statearr_64452_64485 = state_64450__$1;
(statearr_64452_64485[(2)] = subject);

(statearr_64452_64485[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (1))){
var state_64450__$1 = state_64450;
var statearr_64453_64486 = state_64450__$1;
(statearr_64453_64486[(2)] = null);

(statearr_64453_64486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (4))){
var inst_64401 = (state_64450[(2)]);
var state_64450__$1 = state_64450;
var statearr_64454_64487 = state_64450__$1;
(statearr_64454_64487[(2)] = inst_64401);

(statearr_64454_64487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (15))){
var inst_64414 = (state_64450[(7)]);
var state_64450__$1 = state_64450;
var statearr_64455_64488 = state_64450__$1;
(statearr_64455_64488[(2)] = inst_64414);

(statearr_64455_64488[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (13))){
var inst_64418 = (state_64450[(2)]);
var inst_64419 = fluree.db.util.async.throw_err(inst_64418);
var state_64450__$1 = state_64450;
var statearr_64456_64489 = state_64450__$1;
(statearr_64456_64489[(2)] = inst_64419);

(statearr_64456_64489[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (6))){
var state_64450__$1 = state_64450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64450__$1,(9),subject);
} else {
if((state_val_64451 === (17))){
var inst_64414 = (state_64450[(7)]);
var inst_64428 = cljs.core.first(inst_64414);
var state_64450__$1 = state_64450;
var statearr_64457_64490 = state_64450__$1;
(statearr_64457_64490[(2)] = inst_64428);

(statearr_64457_64490[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (3))){
var inst_64448 = (state_64450[(2)]);
var state_64450__$1 = state_64450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64450__$1,inst_64448);
} else {
if((state_val_64451 === (12))){
var inst_64414 = (state_64450[(7)]);
var inst_64422 = (state_64450[(2)]);
var inst_64423 = cljs.core.vector_QMARK_(inst_64414);
var state_64450__$1 = (function (){var statearr_64458 = state_64450;
(statearr_64458[(8)] = inst_64422);

return statearr_64458;
})();
if(inst_64423){
var statearr_64459_64491 = state_64450__$1;
(statearr_64459_64491[(1)] = (14));

} else {
var statearr_64460_64492 = state_64450__$1;
(statearr_64460_64492[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (2))){
var _ = (function (){var statearr_64461 = state_64450;
(statearr_64461[(4)] = cljs.core.cons((5),(state_64450[(4)])));

return statearr_64461;
})();
var inst_64407 = fluree.db.util.async.channel_QMARK_(subject);
var state_64450__$1 = state_64450;
if(inst_64407){
var statearr_64462_64493 = state_64450__$1;
(statearr_64462_64493[(1)] = (6));

} else {
var statearr_64463_64494 = state_64450__$1;
(statearr_64463_64494[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (19))){
var inst_64431 = (state_64450[(2)]);
var state_64450__$1 = state_64450;
var statearr_64464_64495 = state_64450__$1;
(statearr_64464_64495[(2)] = inst_64431);

(statearr_64464_64495[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (11))){
var state_64450__$1 = state_64450;
var statearr_64466_64496 = state_64450__$1;
(statearr_64466_64496[(2)] = pred);

(statearr_64466_64496[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (9))){
var inst_64410 = (state_64450[(2)]);
var inst_64411 = fluree.db.util.async.throw_err(inst_64410);
var state_64450__$1 = state_64450;
var statearr_64467_64497 = state_64450__$1;
(statearr_64467_64497[(2)] = inst_64411);

(statearr_64467_64497[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (5))){
var _ = (function (){var statearr_64468 = state_64450;
(statearr_64468[(4)] = cljs.core.rest((state_64450[(4)])));

return statearr_64468;
})();
var state_64450__$1 = state_64450;
var ex64465 = (state_64450__$1[(2)]);
var statearr_64469_64498 = state_64450__$1;
(statearr_64469_64498[(5)] = ex64465);


if((ex64465 instanceof Error)){
var statearr_64470_64499 = state_64450__$1;
(statearr_64470_64499[(1)] = (4));

(statearr_64470_64499[(5)] = null);

} else {
throw ex64465;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (14))){
var inst_64414 = (state_64450[(7)]);
var inst_64425 = cljs.core.count(inst_64414);
var inst_64426 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64425);
var state_64450__$1 = state_64450;
if(inst_64426){
var statearr_64471_64500 = state_64450__$1;
(statearr_64471_64500[(1)] = (17));

} else {
var statearr_64472_64501 = state_64450__$1;
(statearr_64472_64501[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (16))){
var inst_64422 = (state_64450[(8)]);
var inst_64414 = (state_64450[(7)]);
var inst_64434 = (state_64450[(2)]);
var inst_64435 = fluree.db.dbfunctions.internal.get(inst_64434,inst_64422);
var inst_64436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64437 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64439 = [inst_64414,inst_64422];
var inst_64440 = (new cljs.core.PersistentVector(null,2,(5),inst_64438,inst_64439,null));
var inst_64441 = ["get",inst_64440,inst_64435];
var inst_64442 = cljs.core.PersistentHashMap.fromArrays(inst_64437,inst_64441);
var inst_64443 = [inst_64442,(10)];
var inst_64444 = (new cljs.core.PersistentVector(null,2,(5),inst_64436,inst_64443,null));
var inst_64445 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64444);
var _ = (function (){var statearr_64473 = state_64450;
(statearr_64473[(4)] = cljs.core.rest((state_64450[(4)])));

return statearr_64473;
})();
var state_64450__$1 = (function (){var statearr_64474 = state_64450;
(statearr_64474[(9)] = inst_64445);

return statearr_64474;
})();
var statearr_64475_64502 = state_64450__$1;
(statearr_64475_64502[(2)] = inst_64435);

(statearr_64475_64502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (10))){
var state_64450__$1 = state_64450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64450__$1,(13),pred);
} else {
if((state_val_64451 === (18))){
var inst_64414 = (state_64450[(7)]);
var state_64450__$1 = state_64450;
var statearr_64476_64503 = state_64450__$1;
(statearr_64476_64503[(2)] = inst_64414);

(statearr_64476_64503[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64451 === (8))){
var inst_64414 = (state_64450[(2)]);
var inst_64415 = fluree.db.util.async.channel_QMARK_(pred);
var state_64450__$1 = (function (){var statearr_64477 = state_64450;
(statearr_64477[(7)] = inst_64414);

return statearr_64477;
})();
if(inst_64415){
var statearr_64478_64504 = state_64450__$1;
(statearr_64478_64504[(1)] = (10));

} else {
var statearr_64479_64505 = state_64450__$1;
(statearr_64479_64505[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto____0 = (function (){
var statearr_64480 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64480[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto__);

(statearr_64480[(1)] = (1));

return statearr_64480;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto____1 = (function (state_64450){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64450);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64481){var ex__10844__auto__ = e64481;
var statearr_64482_64506 = state_64450;
(statearr_64482_64506[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64450[(4)]))){
var statearr_64483_64507 = state_64450;
(statearr_64483_64507[(1)] = cljs.core.first((state_64450[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64508 = state_64450;
state_64450 = G__64508;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto__ = function(state_64450){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto____1.call(this,state_64450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64484 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64484[(6)] = c__10878__auto__);

return statearr_64484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64547){
var state_val_64548 = (state_64547[(1)]);
if((state_val_64548 === (7))){
var inst_64515 = (state_64547[(7)]);
var state_64547__$1 = state_64547;
var statearr_64549_64573 = state_64547__$1;
(statearr_64549_64573[(2)] = inst_64515);

(statearr_64549_64573[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (1))){
var state_64547__$1 = state_64547;
var statearr_64550_64574 = state_64547__$1;
(statearr_64550_64574[(2)] = null);

(statearr_64550_64574[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (4))){
var inst_64509 = (state_64547[(2)]);
var state_64547__$1 = state_64547;
var statearr_64551_64575 = state_64547__$1;
(statearr_64551_64575[(2)] = inst_64509);

(statearr_64551_64575[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (6))){
var inst_64517 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64547__$1 = state_64547;
var statearr_64552_64576 = state_64547__$1;
(statearr_64552_64576[(2)] = inst_64517);

(statearr_64552_64576[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (3))){
var inst_64545 = (state_64547[(2)]);
var state_64547__$1 = state_64547;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64547__$1,inst_64545);
} else {
if((state_val_64548 === (12))){
var inst_64527 = (state_64547[(2)]);
var inst_64528 = fluree.db.util.async.throw_err(inst_64527);
var inst_64529 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64528,(0),null);
var inst_64530 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64528,(1),null);
var inst_64531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64532 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64533 = ["?pO","?ctx",inst_64529];
var inst_64534 = cljs.core.PersistentHashMap.fromArrays(inst_64532,inst_64533);
var inst_64535 = ((10) + inst_64530);
var inst_64536 = [inst_64534,inst_64535];
var inst_64537 = (new cljs.core.PersistentVector(null,2,(5),inst_64531,inst_64536,null));
var inst_64538 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64537);
var state_64547__$1 = (function (){var statearr_64553 = state_64547;
(statearr_64553[(8)] = inst_64538);

return statearr_64553;
})();
var statearr_64554_64577 = state_64547__$1;
(statearr_64554_64577[(2)] = inst_64529);

(statearr_64554_64577[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (2))){
var inst_64515 = (state_64547[(7)]);
var _ = (function (){var statearr_64555 = state_64547;
(statearr_64555[(4)] = cljs.core.cons((5),(state_64547[(4)])));

return statearr_64555;
})();
var inst_64515__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_64547__$1 = (function (){var statearr_64556 = state_64547;
(statearr_64556[(7)] = inst_64515__$1);

return statearr_64556;
})();
if(cljs.core.truth_(inst_64515__$1)){
var statearr_64557_64578 = state_64547__$1;
(statearr_64557_64578[(1)] = (6));

} else {
var statearr_64558_64579 = state_64547__$1;
(statearr_64558_64579[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (11))){
var inst_64542 = (state_64547[(2)]);
var _ = (function (){var statearr_64560 = state_64547;
(statearr_64560[(4)] = cljs.core.rest((state_64547[(4)])));

return statearr_64560;
})();
var state_64547__$1 = state_64547;
var statearr_64561_64580 = state_64547__$1;
(statearr_64561_64580[(2)] = inst_64542);

(statearr_64561_64580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (9))){
var inst_64525 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_64547__$1 = state_64547;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64547__$1,(12),inst_64525);
} else {
if((state_val_64548 === (5))){
var _ = (function (){var statearr_64562 = state_64547;
(statearr_64562[(4)] = cljs.core.rest((state_64547[(4)])));

return statearr_64562;
})();
var state_64547__$1 = state_64547;
var ex64559 = (state_64547__$1[(2)]);
var statearr_64563_64581 = state_64547__$1;
(statearr_64563_64581[(5)] = ex64559);


if((ex64559 instanceof Error)){
var statearr_64564_64582 = state_64547__$1;
(statearr_64564_64582[(1)] = (4));

(statearr_64564_64582[(5)] = null);

} else {
throw ex64559;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (10))){
var inst_64540 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_64547__$1 = state_64547;
var statearr_64565_64583 = state_64547__$1;
(statearr_64565_64583[(2)] = inst_64540);

(statearr_64565_64583[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64548 === (8))){
var inst_64520 = (state_64547[(2)]);
var state_64547__$1 = state_64547;
if(cljs.core.truth_(inst_64520)){
var statearr_64566_64584 = state_64547__$1;
(statearr_64566_64584[(1)] = (9));

} else {
var statearr_64567_64585 = state_64547__$1;
(statearr_64567_64585[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto____0 = (function (){
var statearr_64568 = [null,null,null,null,null,null,null,null,null];
(statearr_64568[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto__);

(statearr_64568[(1)] = (1));

return statearr_64568;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto____1 = (function (state_64547){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64547);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64569){var ex__10844__auto__ = e64569;
var statearr_64570_64586 = state_64547;
(statearr_64570_64586[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64547[(4)]))){
var statearr_64571_64587 = state_64547;
(statearr_64571_64587[(1)] = cljs.core.first((state_64547[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64588 = state_64547;
state_64547 = G__64588;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto__ = function(state_64547){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto____1.call(this,state_64547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64572 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64572[(6)] = c__10878__auto__);

return statearr_64572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64640){
var state_val_64641 = (state_64640[(1)]);
if((state_val_64641 === (7))){
var state_64640__$1 = state_64640;
var statearr_64642_64675 = state_64640__$1;
(statearr_64642_64675[(2)] = subject);

(statearr_64642_64675[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (1))){
var state_64640__$1 = state_64640;
var statearr_64643_64676 = state_64640__$1;
(statearr_64643_64676[(2)] = null);

(statearr_64643_64676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (4))){
var inst_64589 = (state_64640[(2)]);
var state_64640__$1 = state_64640;
var statearr_64644_64677 = state_64640__$1;
(statearr_64644_64677[(2)] = inst_64589);

(statearr_64644_64677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (15))){
var inst_64602 = (state_64640[(7)]);
var state_64640__$1 = state_64640;
var statearr_64645_64678 = state_64640__$1;
(statearr_64645_64678[(2)] = inst_64602);

(statearr_64645_64678[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (13))){
var inst_64606 = (state_64640[(2)]);
var inst_64607 = fluree.db.util.async.throw_err(inst_64606);
var state_64640__$1 = state_64640;
var statearr_64646_64679 = state_64640__$1;
(statearr_64646_64679[(2)] = inst_64607);

(statearr_64646_64679[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (6))){
var state_64640__$1 = state_64640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64640__$1,(9),subject);
} else {
if((state_val_64641 === (17))){
var inst_64602 = (state_64640[(7)]);
var inst_64616 = cljs.core.first(inst_64602);
var state_64640__$1 = state_64640;
var statearr_64647_64680 = state_64640__$1;
(statearr_64647_64680[(2)] = inst_64616);

(statearr_64647_64680[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (3))){
var inst_64638 = (state_64640[(2)]);
var state_64640__$1 = state_64640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64640__$1,inst_64638);
} else {
if((state_val_64641 === (12))){
var inst_64602 = (state_64640[(7)]);
var inst_64610 = (state_64640[(2)]);
var inst_64611 = cljs.core.vector_QMARK_(inst_64602);
var state_64640__$1 = (function (){var statearr_64648 = state_64640;
(statearr_64648[(8)] = inst_64610);

return statearr_64648;
})();
if(inst_64611){
var statearr_64649_64681 = state_64640__$1;
(statearr_64649_64681[(1)] = (14));

} else {
var statearr_64650_64682 = state_64640__$1;
(statearr_64650_64682[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (2))){
var _ = (function (){var statearr_64651 = state_64640;
(statearr_64651[(4)] = cljs.core.cons((5),(state_64640[(4)])));

return statearr_64651;
})();
var inst_64595 = fluree.db.util.async.channel_QMARK_(subject);
var state_64640__$1 = state_64640;
if(inst_64595){
var statearr_64652_64683 = state_64640__$1;
(statearr_64652_64683[(1)] = (6));

} else {
var statearr_64653_64684 = state_64640__$1;
(statearr_64653_64684[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (19))){
var inst_64619 = (state_64640[(2)]);
var state_64640__$1 = state_64640;
var statearr_64654_64685 = state_64640__$1;
(statearr_64654_64685[(2)] = inst_64619);

(statearr_64654_64685[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (11))){
var state_64640__$1 = state_64640;
var statearr_64656_64686 = state_64640__$1;
(statearr_64656_64686[(2)] = path);

(statearr_64656_64686[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (9))){
var inst_64598 = (state_64640[(2)]);
var inst_64599 = fluree.db.util.async.throw_err(inst_64598);
var state_64640__$1 = state_64640;
var statearr_64657_64687 = state_64640__$1;
(statearr_64657_64687[(2)] = inst_64599);

(statearr_64657_64687[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (5))){
var _ = (function (){var statearr_64658 = state_64640;
(statearr_64658[(4)] = cljs.core.rest((state_64640[(4)])));

return statearr_64658;
})();
var state_64640__$1 = state_64640;
var ex64655 = (state_64640__$1[(2)]);
var statearr_64659_64688 = state_64640__$1;
(statearr_64659_64688[(5)] = ex64655);


if((ex64655 instanceof Error)){
var statearr_64660_64689 = state_64640__$1;
(statearr_64660_64689[(1)] = (4));

(statearr_64660_64689[(5)] = null);

} else {
throw ex64655;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (14))){
var inst_64602 = (state_64640[(7)]);
var inst_64613 = cljs.core.count(inst_64602);
var inst_64614 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64613);
var state_64640__$1 = state_64640;
if(inst_64614){
var statearr_64661_64690 = state_64640__$1;
(statearr_64661_64690[(1)] = (17));

} else {
var statearr_64662_64691 = state_64640__$1;
(statearr_64662_64691[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (16))){
var inst_64610 = (state_64640[(8)]);
var inst_64602 = (state_64640[(7)]);
var inst_64622 = (state_64640[(2)]);
var inst_64623 = fluree.db.dbfunctions.internal.get_all(inst_64622,inst_64610);
var inst_64624 = cljs.core.count(inst_64610);
var inst_64625 = ((9) + inst_64624);
var inst_64626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64627 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64629 = [inst_64602,inst_64610];
var inst_64630 = (new cljs.core.PersistentVector(null,2,(5),inst_64628,inst_64629,null));
var inst_64631 = ["get-all",inst_64630,inst_64623];
var inst_64632 = cljs.core.PersistentHashMap.fromArrays(inst_64627,inst_64631);
var inst_64633 = [inst_64632,inst_64625];
var inst_64634 = (new cljs.core.PersistentVector(null,2,(5),inst_64626,inst_64633,null));
var inst_64635 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64634);
var _ = (function (){var statearr_64663 = state_64640;
(statearr_64663[(4)] = cljs.core.rest((state_64640[(4)])));

return statearr_64663;
})();
var state_64640__$1 = (function (){var statearr_64664 = state_64640;
(statearr_64664[(9)] = inst_64635);

return statearr_64664;
})();
var statearr_64665_64692 = state_64640__$1;
(statearr_64665_64692[(2)] = inst_64623);

(statearr_64665_64692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (10))){
var state_64640__$1 = state_64640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64640__$1,(13),path);
} else {
if((state_val_64641 === (18))){
var inst_64602 = (state_64640[(7)]);
var state_64640__$1 = state_64640;
var statearr_64666_64693 = state_64640__$1;
(statearr_64666_64693[(2)] = inst_64602);

(statearr_64666_64693[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64641 === (8))){
var inst_64602 = (state_64640[(2)]);
var inst_64603 = fluree.db.util.async.channel_QMARK_(path);
var state_64640__$1 = (function (){var statearr_64667 = state_64640;
(statearr_64667[(7)] = inst_64602);

return statearr_64667;
})();
if(inst_64603){
var statearr_64668_64694 = state_64640__$1;
(statearr_64668_64694[(1)] = (10));

} else {
var statearr_64669_64695 = state_64640__$1;
(statearr_64669_64695[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto____0 = (function (){
var statearr_64670 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64670[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto__);

(statearr_64670[(1)] = (1));

return statearr_64670;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto____1 = (function (state_64640){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64640);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64671){var ex__10844__auto__ = e64671;
var statearr_64672_64696 = state_64640;
(statearr_64672_64696[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64640[(4)]))){
var statearr_64673_64697 = state_64640;
(statearr_64673_64697[(1)] = cljs.core.first((state_64640[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64698 = state_64640;
state_64640 = G__64698;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto__ = function(state_64640){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto____1.call(this,state_64640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64674 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64674[(6)] = c__10878__auto__);

return statearr_64674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64737){
var state_val_64738 = (state_64737[(1)]);
if((state_val_64738 === (7))){
var state_64737__$1 = state_64737;
var statearr_64739_64763 = state_64737__$1;
(statearr_64739_64763[(2)] = subject);

(statearr_64739_64763[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (1))){
var state_64737__$1 = state_64737;
var statearr_64740_64764 = state_64737__$1;
(statearr_64740_64764[(2)] = null);

(statearr_64740_64764[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (4))){
var inst_64699 = (state_64737[(2)]);
var state_64737__$1 = state_64737;
var statearr_64741_64765 = state_64737__$1;
(statearr_64741_64765[(2)] = inst_64699);

(statearr_64741_64765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (13))){
var inst_64716 = (state_64737[(2)]);
var inst_64717 = fluree.db.util.async.throw_err(inst_64716);
var state_64737__$1 = state_64737;
var statearr_64742_64766 = state_64737__$1;
(statearr_64742_64766[(2)] = inst_64717);

(statearr_64742_64766[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (6))){
var state_64737__$1 = state_64737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64737__$1,(9),subject);
} else {
if((state_val_64738 === (3))){
var inst_64735 = (state_64737[(2)]);
var state_64737__$1 = state_64737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64737__$1,inst_64735);
} else {
if((state_val_64738 === (12))){
var inst_64712 = (state_64737[(7)]);
var inst_64720 = (state_64737[(2)]);
var inst_64721 = fluree.db.dbfunctions.internal.get_in(inst_64712,inst_64720);
var inst_64722 = cljs.core.count(inst_64720);
var inst_64723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64724 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64726 = [inst_64712,inst_64720];
var inst_64727 = (new cljs.core.PersistentVector(null,2,(5),inst_64725,inst_64726,null));
var inst_64728 = ["get-in",inst_64727,inst_64721];
var inst_64729 = cljs.core.PersistentHashMap.fromArrays(inst_64724,inst_64728);
var inst_64730 = [inst_64729,inst_64722];
var inst_64731 = (new cljs.core.PersistentVector(null,2,(5),inst_64723,inst_64730,null));
var inst_64732 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64731);
var _ = (function (){var statearr_64743 = state_64737;
(statearr_64743[(4)] = cljs.core.rest((state_64737[(4)])));

return statearr_64743;
})();
var state_64737__$1 = (function (){var statearr_64744 = state_64737;
(statearr_64744[(8)] = inst_64732);

return statearr_64744;
})();
var statearr_64745_64767 = state_64737__$1;
(statearr_64745_64767[(2)] = inst_64721);

(statearr_64745_64767[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (2))){
var _ = (function (){var statearr_64746 = state_64737;
(statearr_64746[(4)] = cljs.core.cons((5),(state_64737[(4)])));

return statearr_64746;
})();
var inst_64705 = fluree.db.util.async.channel_QMARK_(subject);
var state_64737__$1 = state_64737;
if(inst_64705){
var statearr_64747_64768 = state_64737__$1;
(statearr_64747_64768[(1)] = (6));

} else {
var statearr_64748_64769 = state_64737__$1;
(statearr_64748_64769[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (11))){
var state_64737__$1 = state_64737;
var statearr_64750_64770 = state_64737__$1;
(statearr_64750_64770[(2)] = path);

(statearr_64750_64770[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (9))){
var inst_64708 = (state_64737[(2)]);
var inst_64709 = fluree.db.util.async.throw_err(inst_64708);
var state_64737__$1 = state_64737;
var statearr_64751_64771 = state_64737__$1;
(statearr_64751_64771[(2)] = inst_64709);

(statearr_64751_64771[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (5))){
var _ = (function (){var statearr_64752 = state_64737;
(statearr_64752[(4)] = cljs.core.rest((state_64737[(4)])));

return statearr_64752;
})();
var state_64737__$1 = state_64737;
var ex64749 = (state_64737__$1[(2)]);
var statearr_64753_64772 = state_64737__$1;
(statearr_64753_64772[(5)] = ex64749);


if((ex64749 instanceof Error)){
var statearr_64754_64773 = state_64737__$1;
(statearr_64754_64773[(1)] = (4));

(statearr_64754_64773[(5)] = null);

} else {
throw ex64749;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64738 === (10))){
var state_64737__$1 = state_64737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64737__$1,(13),path);
} else {
if((state_val_64738 === (8))){
var inst_64712 = (state_64737[(2)]);
var inst_64713 = fluree.db.util.async.channel_QMARK_(path);
var state_64737__$1 = (function (){var statearr_64755 = state_64737;
(statearr_64755[(7)] = inst_64712);

return statearr_64755;
})();
if(inst_64713){
var statearr_64756_64774 = state_64737__$1;
(statearr_64756_64774[(1)] = (10));

} else {
var statearr_64757_64775 = state_64737__$1;
(statearr_64757_64775[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto____0 = (function (){
var statearr_64758 = [null,null,null,null,null,null,null,null,null];
(statearr_64758[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto__);

(statearr_64758[(1)] = (1));

return statearr_64758;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto____1 = (function (state_64737){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64737);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64759){var ex__10844__auto__ = e64759;
var statearr_64760_64776 = state_64737;
(statearr_64760_64776[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64737[(4)]))){
var statearr_64761_64777 = state_64737;
(statearr_64761_64777[(1)] = cljs.core.first((state_64737[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64778 = state_64737;
state_64737 = G__64778;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto__ = function(state_64737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto____1.call(this,state_64737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64762 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64762[(6)] = c__10878__auto__);

return statearr_64762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64823){
var state_val_64824 = (state_64823[(1)]);
if((state_val_64824 === (7))){
var state_64823__$1 = state_64823;
var statearr_64825_64854 = state_64823__$1;
(statearr_64825_64854[(2)] = coll);

(statearr_64825_64854[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (1))){
var state_64823__$1 = state_64823;
var statearr_64826_64855 = state_64823__$1;
(statearr_64826_64855[(2)] = null);

(statearr_64826_64855[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (4))){
var inst_64779 = (state_64823[(2)]);
var state_64823__$1 = state_64823;
var statearr_64827_64856 = state_64823__$1;
(statearr_64827_64856[(2)] = inst_64779);

(statearr_64827_64856[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (15))){
var inst_64799 = (state_64823[(7)]);
var inst_64807 = (state_64823[(2)]);
var inst_64808 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_64799,inst_64807);
var inst_64809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64810 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64812 = [inst_64799,inst_64807];
var inst_64813 = (new cljs.core.PersistentVector(null,2,(5),inst_64811,inst_64812,null));
var inst_64814 = ["contains?",inst_64813,inst_64808];
var inst_64815 = cljs.core.PersistentHashMap.fromArrays(inst_64810,inst_64814);
var inst_64816 = [inst_64815,(10)];
var inst_64817 = (new cljs.core.PersistentVector(null,2,(5),inst_64809,inst_64816,null));
var inst_64818 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64817);
var _ = (function (){var statearr_64828 = state_64823;
(statearr_64828[(4)] = cljs.core.rest((state_64823[(4)])));

return statearr_64828;
})();
var state_64823__$1 = (function (){var statearr_64829 = state_64823;
(statearr_64829[(8)] = inst_64818);

return statearr_64829;
})();
var statearr_64830_64857 = state_64823__$1;
(statearr_64830_64857[(2)] = inst_64808);

(statearr_64830_64857[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (13))){
var state_64823__$1 = state_64823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64823__$1,(16),key);
} else {
if((state_val_64824 === (6))){
var state_64823__$1 = state_64823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64823__$1,(9),coll);
} else {
if((state_val_64824 === (3))){
var inst_64821 = (state_64823[(2)]);
var state_64823__$1 = state_64823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64823__$1,inst_64821);
} else {
if((state_val_64824 === (12))){
var inst_64799 = (state_64823[(2)]);
var inst_64800 = fluree.db.util.async.channel_QMARK_(key);
var state_64823__$1 = (function (){var statearr_64831 = state_64823;
(statearr_64831[(7)] = inst_64799);

return statearr_64831;
})();
if(inst_64800){
var statearr_64832_64858 = state_64823__$1;
(statearr_64832_64858[(1)] = (13));

} else {
var statearr_64833_64859 = state_64823__$1;
(statearr_64833_64859[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (2))){
var _ = (function (){var statearr_64834 = state_64823;
(statearr_64834[(4)] = cljs.core.cons((5),(state_64823[(4)])));

return statearr_64834;
})();
var inst_64785 = fluree.db.util.async.channel_QMARK_(coll);
var state_64823__$1 = state_64823;
if(inst_64785){
var statearr_64835_64860 = state_64823__$1;
(statearr_64835_64860[(1)] = (6));

} else {
var statearr_64836_64861 = state_64823__$1;
(statearr_64836_64861[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (11))){
var inst_64792 = (state_64823[(9)]);
var inst_64796 = cljs.core.flatten(inst_64792);
var inst_64797 = cljs.core.set(inst_64796);
var state_64823__$1 = state_64823;
var statearr_64838_64862 = state_64823__$1;
(statearr_64838_64862[(2)] = inst_64797);

(statearr_64838_64862[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (9))){
var inst_64788 = (state_64823[(2)]);
var inst_64789 = fluree.db.util.async.throw_err(inst_64788);
var state_64823__$1 = state_64823;
var statearr_64839_64863 = state_64823__$1;
(statearr_64839_64863[(2)] = inst_64789);

(statearr_64839_64863[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (5))){
var _ = (function (){var statearr_64840 = state_64823;
(statearr_64840[(4)] = cljs.core.rest((state_64823[(4)])));

return statearr_64840;
})();
var state_64823__$1 = state_64823;
var ex64837 = (state_64823__$1[(2)]);
var statearr_64841_64864 = state_64823__$1;
(statearr_64841_64864[(5)] = ex64837);


if((ex64837 instanceof Error)){
var statearr_64842_64865 = state_64823__$1;
(statearr_64842_64865[(1)] = (4));

(statearr_64842_64865[(5)] = null);

} else {
throw ex64837;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (14))){
var state_64823__$1 = state_64823;
var statearr_64843_64866 = state_64823__$1;
(statearr_64843_64866[(2)] = key);

(statearr_64843_64866[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (16))){
var inst_64803 = (state_64823[(2)]);
var inst_64804 = fluree.db.util.async.throw_err(inst_64803);
var state_64823__$1 = state_64823;
var statearr_64844_64867 = state_64823__$1;
(statearr_64844_64867[(2)] = inst_64804);

(statearr_64844_64867[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (10))){
var inst_64792 = (state_64823[(9)]);
var state_64823__$1 = state_64823;
var statearr_64845_64868 = state_64823__$1;
(statearr_64845_64868[(2)] = inst_64792);

(statearr_64845_64868[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64824 === (8))){
var inst_64792 = (state_64823[(9)]);
var inst_64792__$1 = (state_64823[(2)]);
var inst_64793 = cljs.core.set_QMARK_(inst_64792__$1);
var state_64823__$1 = (function (){var statearr_64846 = state_64823;
(statearr_64846[(9)] = inst_64792__$1);

return statearr_64846;
})();
if(inst_64793){
var statearr_64847_64869 = state_64823__$1;
(statearr_64847_64869[(1)] = (10));

} else {
var statearr_64848_64870 = state_64823__$1;
(statearr_64848_64870[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto____0 = (function (){
var statearr_64849 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64849[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto__);

(statearr_64849[(1)] = (1));

return statearr_64849;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto____1 = (function (state_64823){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64823);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64850){var ex__10844__auto__ = e64850;
var statearr_64851_64871 = state_64823;
(statearr_64851_64871[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64823[(4)]))){
var statearr_64852_64872 = state_64823;
(statearr_64852_64872[(1)] = cljs.core.first((state_64823[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64873 = state_64823;
state_64823 = G__64873;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto__ = function(state_64823){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto____1.call(this,state_64823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64853 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64853[(6)] = c__10878__auto__);

return statearr_64853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___64945 = arguments.length;
var i__4830__auto___64946 = (0);
while(true){
if((i__4830__auto___64946 < len__4829__auto___64945)){
args__4835__auto__.push((arguments[i__4830__auto___64946]));

var G__64947 = (i__4830__auto___64946 + (1));
i__4830__auto___64946 = G__64947;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64919){
var state_val_64920 = (state_64919[(1)]);
if((state_val_64920 === (7))){
var inst_64885 = (state_64919[(7)]);
var inst_64889 = cljs.core.first(inst_64885);
var inst_64890 = cljs.core.coll_QMARK_(inst_64889);
var state_64919__$1 = state_64919;
var statearr_64921_64948 = state_64919__$1;
(statearr_64921_64948[(2)] = inst_64890);

(statearr_64921_64948[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (1))){
var state_64919__$1 = state_64919;
var statearr_64922_64949 = state_64919__$1;
(statearr_64922_64949[(2)] = null);

(statearr_64922_64949[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (4))){
var inst_64876 = (state_64919[(2)]);
var state_64919__$1 = state_64919;
var statearr_64923_64950 = state_64919__$1;
(statearr_64923_64950[(2)] = inst_64876);

(statearr_64923_64950[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (6))){
var inst_64885 = (state_64919[(7)]);
var inst_64887 = (state_64919[(8)]);
var inst_64884 = (state_64919[(2)]);
var inst_64885__$1 = fluree.db.util.async.throw_err(inst_64884);
var inst_64886 = cljs.core.count(inst_64885__$1);
var inst_64887__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64886);
var state_64919__$1 = (function (){var statearr_64924 = state_64919;
(statearr_64924[(7)] = inst_64885__$1);

(statearr_64924[(8)] = inst_64887__$1);

return statearr_64924;
})();
if(inst_64887__$1){
var statearr_64925_64951 = state_64919__$1;
(statearr_64925_64951[(1)] = (7));

} else {
var statearr_64926_64952 = state_64919__$1;
(statearr_64926_64952[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (3))){
var inst_64917 = (state_64919[(2)]);
var state_64919__$1 = state_64919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64919__$1,inst_64917);
} else {
if((state_val_64920 === (12))){
var inst_64898 = (state_64919[(2)]);
var inst_64899 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_64898);
var inst_64900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64901 = [inst_64898];
var inst_64902 = (new cljs.core.PersistentVector(null,1,(5),inst_64900,inst_64901,null));
var inst_64903 = cljs.core.count(inst_64902);
var inst_64904 = ((9) + inst_64903);
var inst_64905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64906 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64908 = [inst_64898];
var inst_64909 = (new cljs.core.PersistentVector(null,1,(5),inst_64907,inst_64908,null));
var inst_64910 = ["hash-set",inst_64909,inst_64899];
var inst_64911 = cljs.core.PersistentHashMap.fromArrays(inst_64906,inst_64910);
var inst_64912 = [inst_64911,inst_64904];
var inst_64913 = (new cljs.core.PersistentVector(null,2,(5),inst_64905,inst_64912,null));
var inst_64914 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64913);
var _ = (function (){var statearr_64927 = state_64919;
(statearr_64927[(4)] = cljs.core.rest((state_64919[(4)])));

return statearr_64927;
})();
var state_64919__$1 = (function (){var statearr_64928 = state_64919;
(statearr_64928[(9)] = inst_64914);

return statearr_64928;
})();
var statearr_64929_64953 = state_64919__$1;
(statearr_64929_64953[(2)] = inst_64899);

(statearr_64929_64953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (2))){
var _ = (function (){var statearr_64930 = state_64919;
(statearr_64930[(4)] = cljs.core.cons((5),(state_64919[(4)])));

return statearr_64930;
})();
var inst_64882 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64919__$1 = state_64919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64919__$1,(6),inst_64882);
} else {
if((state_val_64920 === (11))){
var inst_64885 = (state_64919[(7)]);
var state_64919__$1 = state_64919;
var statearr_64932_64954 = state_64919__$1;
(statearr_64932_64954[(2)] = inst_64885);

(statearr_64932_64954[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (9))){
var inst_64893 = (state_64919[(2)]);
var state_64919__$1 = state_64919;
if(cljs.core.truth_(inst_64893)){
var statearr_64933_64955 = state_64919__$1;
(statearr_64933_64955[(1)] = (10));

} else {
var statearr_64934_64956 = state_64919__$1;
(statearr_64934_64956[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (5))){
var _ = (function (){var statearr_64935 = state_64919;
(statearr_64935[(4)] = cljs.core.rest((state_64919[(4)])));

return statearr_64935;
})();
var state_64919__$1 = state_64919;
var ex64931 = (state_64919__$1[(2)]);
var statearr_64936_64957 = state_64919__$1;
(statearr_64936_64957[(5)] = ex64931);


if((ex64931 instanceof Error)){
var statearr_64937_64958 = state_64919__$1;
(statearr_64937_64958[(1)] = (4));

(statearr_64937_64958[(5)] = null);

} else {
throw ex64931;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (10))){
var inst_64885 = (state_64919[(7)]);
var inst_64895 = cljs.core.first(inst_64885);
var state_64919__$1 = state_64919;
var statearr_64938_64959 = state_64919__$1;
(statearr_64938_64959[(2)] = inst_64895);

(statearr_64938_64959[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64920 === (8))){
var inst_64887 = (state_64919[(8)]);
var state_64919__$1 = state_64919;
var statearr_64939_64960 = state_64919__$1;
(statearr_64939_64960[(2)] = inst_64887);

(statearr_64939_64960[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_64940 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64940[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_64940[(1)] = (1));

return statearr_64940;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_64919){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64919);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e64941){var ex__10844__auto__ = e64941;
var statearr_64942_64961 = state_64919;
(statearr_64942_64961[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64919[(4)]))){
var statearr_64943_64962 = state_64919;
(statearr_64943_64962[(1)] = cljs.core.first((state_64919[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__64963 = state_64919;
state_64919 = G__64963;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_64919){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_64919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_64944 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_64944[(6)] = c__10878__auto__);

return statearr_64944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq64874){
var G__64875 = cljs.core.first(seq64874);
var seq64874__$1 = cljs.core.next(seq64874);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64875,seq64874__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65013 = arguments.length;
var i__4830__auto___65014 = (0);
while(true){
if((i__4830__auto___65014 < len__4829__auto___65013)){
args__4835__auto__.push((arguments[i__4830__auto___65014]));

var G__65015 = (i__4830__auto___65014 + (1));
i__4830__auto___65014 = G__65015;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_64996){
var state_val_64997 = (state_64996[(1)]);
if((state_val_64997 === (1))){
var state_64996__$1 = state_64996;
var statearr_64998_65016 = state_64996__$1;
(statearr_64998_65016[(2)] = null);

(statearr_64998_65016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64997 === (2))){
var _ = (function (){var statearr_64999 = state_64996;
(statearr_64999[(4)] = cljs.core.cons((5),(state_64996[(4)])));

return statearr_64999;
})();
var inst_64972 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_64996__$1 = state_64996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64996__$1,(6),inst_64972);
} else {
if((state_val_64997 === (3))){
var inst_64994 = (state_64996[(2)]);
var state_64996__$1 = state_64996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64996__$1,inst_64994);
} else {
if((state_val_64997 === (4))){
var inst_64966 = (state_64996[(2)]);
var state_64996__$1 = state_64996;
var statearr_65001_65017 = state_64996__$1;
(statearr_65001_65017[(2)] = inst_64966);

(statearr_65001_65017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64997 === (5))){
var _ = (function (){var statearr_65002 = state_64996;
(statearr_65002[(4)] = cljs.core.rest((state_64996[(4)])));

return statearr_65002;
})();
var state_64996__$1 = state_64996;
var ex65000 = (state_64996__$1[(2)]);
var statearr_65003_65018 = state_64996__$1;
(statearr_65003_65018[(5)] = ex65000);


if((ex65000 instanceof Error)){
var statearr_65004_65019 = state_64996__$1;
(statearr_65004_65019[(1)] = (4));

(statearr_65004_65019[(5)] = null);

} else {
throw ex65000;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64997 === (6))){
var inst_64974 = (state_64996[(2)]);
var inst_64975 = fluree.db.util.async.throw_err(inst_64974);
var inst_64976 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_64975);
var inst_64977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64978 = [inst_64975];
var inst_64979 = (new cljs.core.PersistentVector(null,1,(5),inst_64977,inst_64978,null));
var inst_64980 = cljs.core.count(inst_64979);
var inst_64981 = ((9) + inst_64980);
var inst_64982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64983 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64985 = [inst_64975];
var inst_64986 = (new cljs.core.PersistentVector(null,1,(5),inst_64984,inst_64985,null));
var inst_64987 = ["==",inst_64986,inst_64976];
var inst_64988 = cljs.core.PersistentHashMap.fromArrays(inst_64983,inst_64987);
var inst_64989 = [inst_64988,inst_64981];
var inst_64990 = (new cljs.core.PersistentVector(null,2,(5),inst_64982,inst_64989,null));
var inst_64991 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64990);
var _ = (function (){var statearr_65005 = state_64996;
(statearr_65005[(4)] = cljs.core.rest((state_64996[(4)])));

return statearr_65005;
})();
var state_64996__$1 = (function (){var statearr_65006 = state_64996;
(statearr_65006[(7)] = inst_64991);

return statearr_65006;
})();
var statearr_65007_65020 = state_64996__$1;
(statearr_65007_65020[(2)] = inst_64976);

(statearr_65007_65020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65008 = [null,null,null,null,null,null,null,null];
(statearr_65008[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65008[(1)] = (1));

return statearr_65008;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_64996){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_64996);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65009){var ex__10844__auto__ = e65009;
var statearr_65010_65021 = state_64996;
(statearr_65010_65021[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_64996[(4)]))){
var statearr_65011_65022 = state_64996;
(statearr_65011_65022[(1)] = cljs.core.first((state_64996[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65023 = state_64996;
state_64996 = G__65023;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_64996){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_64996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65012 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65012[(6)] = c__10878__auto__);

return statearr_65012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq64964){
var G__64965 = cljs.core.first(seq64964);
var seq64964__$1 = cljs.core.next(seq64964);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64965,seq64964__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65073 = arguments.length;
var i__4830__auto___65074 = (0);
while(true){
if((i__4830__auto___65074 < len__4829__auto___65073)){
args__4835__auto__.push((arguments[i__4830__auto___65074]));

var G__65075 = (i__4830__auto___65074 + (1));
i__4830__auto___65074 = G__65075;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65056){
var state_val_65057 = (state_65056[(1)]);
if((state_val_65057 === (1))){
var state_65056__$1 = state_65056;
var statearr_65058_65076 = state_65056__$1;
(statearr_65058_65076[(2)] = null);

(statearr_65058_65076[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65057 === (2))){
var _ = (function (){var statearr_65059 = state_65056;
(statearr_65059[(4)] = cljs.core.cons((5),(state_65056[(4)])));

return statearr_65059;
})();
var inst_65032 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65056__$1 = state_65056;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65056__$1,(6),inst_65032);
} else {
if((state_val_65057 === (3))){
var inst_65054 = (state_65056[(2)]);
var state_65056__$1 = state_65056;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65056__$1,inst_65054);
} else {
if((state_val_65057 === (4))){
var inst_65026 = (state_65056[(2)]);
var state_65056__$1 = state_65056;
var statearr_65061_65077 = state_65056__$1;
(statearr_65061_65077[(2)] = inst_65026);

(statearr_65061_65077[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65057 === (5))){
var _ = (function (){var statearr_65062 = state_65056;
(statearr_65062[(4)] = cljs.core.rest((state_65056[(4)])));

return statearr_65062;
})();
var state_65056__$1 = state_65056;
var ex65060 = (state_65056__$1[(2)]);
var statearr_65063_65078 = state_65056__$1;
(statearr_65063_65078[(5)] = ex65060);


if((ex65060 instanceof Error)){
var statearr_65064_65079 = state_65056__$1;
(statearr_65064_65079[(1)] = (4));

(statearr_65064_65079[(5)] = null);

} else {
throw ex65060;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65057 === (6))){
var inst_65034 = (state_65056[(2)]);
var inst_65035 = fluree.db.util.async.throw_err(inst_65034);
var inst_65036 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_65035);
var inst_65037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65038 = [inst_65035];
var inst_65039 = (new cljs.core.PersistentVector(null,1,(5),inst_65037,inst_65038,null));
var inst_65040 = cljs.core.count(inst_65039);
var inst_65041 = ((9) + inst_65040);
var inst_65042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65043 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65045 = [inst_65035];
var inst_65046 = (new cljs.core.PersistentVector(null,1,(5),inst_65044,inst_65045,null));
var inst_65047 = [">",inst_65046,inst_65036];
var inst_65048 = cljs.core.PersistentHashMap.fromArrays(inst_65043,inst_65047);
var inst_65049 = [inst_65048,inst_65041];
var inst_65050 = (new cljs.core.PersistentVector(null,2,(5),inst_65042,inst_65049,null));
var inst_65051 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65050);
var _ = (function (){var statearr_65065 = state_65056;
(statearr_65065[(4)] = cljs.core.rest((state_65056[(4)])));

return statearr_65065;
})();
var state_65056__$1 = (function (){var statearr_65066 = state_65056;
(statearr_65066[(7)] = inst_65051);

return statearr_65066;
})();
var statearr_65067_65080 = state_65056__$1;
(statearr_65067_65080[(2)] = inst_65036);

(statearr_65067_65080[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65068 = [null,null,null,null,null,null,null,null];
(statearr_65068[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65068[(1)] = (1));

return statearr_65068;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65056){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65056);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65069){var ex__10844__auto__ = e65069;
var statearr_65070_65081 = state_65056;
(statearr_65070_65081[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65056[(4)]))){
var statearr_65071_65082 = state_65056;
(statearr_65071_65082[(1)] = cljs.core.first((state_65056[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65083 = state_65056;
state_65056 = G__65083;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65056){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65072 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65072[(6)] = c__10878__auto__);

return statearr_65072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq65024){
var G__65025 = cljs.core.first(seq65024);
var seq65024__$1 = cljs.core.next(seq65024);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65025,seq65024__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65133 = arguments.length;
var i__4830__auto___65134 = (0);
while(true){
if((i__4830__auto___65134 < len__4829__auto___65133)){
args__4835__auto__.push((arguments[i__4830__auto___65134]));

var G__65135 = (i__4830__auto___65134 + (1));
i__4830__auto___65134 = G__65135;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65116){
var state_val_65117 = (state_65116[(1)]);
if((state_val_65117 === (1))){
var state_65116__$1 = state_65116;
var statearr_65118_65136 = state_65116__$1;
(statearr_65118_65136[(2)] = null);

(statearr_65118_65136[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65117 === (2))){
var _ = (function (){var statearr_65119 = state_65116;
(statearr_65119[(4)] = cljs.core.cons((5),(state_65116[(4)])));

return statearr_65119;
})();
var inst_65092 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65116__$1 = state_65116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65116__$1,(6),inst_65092);
} else {
if((state_val_65117 === (3))){
var inst_65114 = (state_65116[(2)]);
var state_65116__$1 = state_65116;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65116__$1,inst_65114);
} else {
if((state_val_65117 === (4))){
var inst_65086 = (state_65116[(2)]);
var state_65116__$1 = state_65116;
var statearr_65121_65137 = state_65116__$1;
(statearr_65121_65137[(2)] = inst_65086);

(statearr_65121_65137[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65117 === (5))){
var _ = (function (){var statearr_65122 = state_65116;
(statearr_65122[(4)] = cljs.core.rest((state_65116[(4)])));

return statearr_65122;
})();
var state_65116__$1 = state_65116;
var ex65120 = (state_65116__$1[(2)]);
var statearr_65123_65138 = state_65116__$1;
(statearr_65123_65138[(5)] = ex65120);


if((ex65120 instanceof Error)){
var statearr_65124_65139 = state_65116__$1;
(statearr_65124_65139[(1)] = (4));

(statearr_65124_65139[(5)] = null);

} else {
throw ex65120;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65117 === (6))){
var inst_65094 = (state_65116[(2)]);
var inst_65095 = fluree.db.util.async.throw_err(inst_65094);
var inst_65096 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_65095);
var inst_65097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65098 = [inst_65095];
var inst_65099 = (new cljs.core.PersistentVector(null,1,(5),inst_65097,inst_65098,null));
var inst_65100 = cljs.core.count(inst_65099);
var inst_65101 = ((9) + inst_65100);
var inst_65102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65103 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65105 = [inst_65095];
var inst_65106 = (new cljs.core.PersistentVector(null,1,(5),inst_65104,inst_65105,null));
var inst_65107 = ["<",inst_65106,inst_65096];
var inst_65108 = cljs.core.PersistentHashMap.fromArrays(inst_65103,inst_65107);
var inst_65109 = [inst_65108,inst_65101];
var inst_65110 = (new cljs.core.PersistentVector(null,2,(5),inst_65102,inst_65109,null));
var inst_65111 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65110);
var _ = (function (){var statearr_65125 = state_65116;
(statearr_65125[(4)] = cljs.core.rest((state_65116[(4)])));

return statearr_65125;
})();
var state_65116__$1 = (function (){var statearr_65126 = state_65116;
(statearr_65126[(7)] = inst_65111);

return statearr_65126;
})();
var statearr_65127_65140 = state_65116__$1;
(statearr_65127_65140[(2)] = inst_65096);

(statearr_65127_65140[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65128 = [null,null,null,null,null,null,null,null];
(statearr_65128[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65128[(1)] = (1));

return statearr_65128;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65116){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65116);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65129){var ex__10844__auto__ = e65129;
var statearr_65130_65141 = state_65116;
(statearr_65130_65141[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65116[(4)]))){
var statearr_65131_65142 = state_65116;
(statearr_65131_65142[(1)] = cljs.core.first((state_65116[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65143 = state_65116;
state_65116 = G__65143;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65116){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65132 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65132[(6)] = c__10878__auto__);

return statearr_65132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq65084){
var G__65085 = cljs.core.first(seq65084);
var seq65084__$1 = cljs.core.next(seq65084);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65085,seq65084__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65193 = arguments.length;
var i__4830__auto___65194 = (0);
while(true){
if((i__4830__auto___65194 < len__4829__auto___65193)){
args__4835__auto__.push((arguments[i__4830__auto___65194]));

var G__65195 = (i__4830__auto___65194 + (1));
i__4830__auto___65194 = G__65195;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65176){
var state_val_65177 = (state_65176[(1)]);
if((state_val_65177 === (1))){
var state_65176__$1 = state_65176;
var statearr_65178_65196 = state_65176__$1;
(statearr_65178_65196[(2)] = null);

(statearr_65178_65196[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65177 === (2))){
var _ = (function (){var statearr_65179 = state_65176;
(statearr_65179[(4)] = cljs.core.cons((5),(state_65176[(4)])));

return statearr_65179;
})();
var inst_65152 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65176__$1 = state_65176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65176__$1,(6),inst_65152);
} else {
if((state_val_65177 === (3))){
var inst_65174 = (state_65176[(2)]);
var state_65176__$1 = state_65176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65176__$1,inst_65174);
} else {
if((state_val_65177 === (4))){
var inst_65146 = (state_65176[(2)]);
var state_65176__$1 = state_65176;
var statearr_65181_65197 = state_65176__$1;
(statearr_65181_65197[(2)] = inst_65146);

(statearr_65181_65197[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65177 === (5))){
var _ = (function (){var statearr_65182 = state_65176;
(statearr_65182[(4)] = cljs.core.rest((state_65176[(4)])));

return statearr_65182;
})();
var state_65176__$1 = state_65176;
var ex65180 = (state_65176__$1[(2)]);
var statearr_65183_65198 = state_65176__$1;
(statearr_65183_65198[(5)] = ex65180);


if((ex65180 instanceof Error)){
var statearr_65184_65199 = state_65176__$1;
(statearr_65184_65199[(1)] = (4));

(statearr_65184_65199[(5)] = null);

} else {
throw ex65180;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65177 === (6))){
var inst_65154 = (state_65176[(2)]);
var inst_65155 = fluree.db.util.async.throw_err(inst_65154);
var inst_65156 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_65155);
var inst_65157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65158 = [inst_65155];
var inst_65159 = (new cljs.core.PersistentVector(null,1,(5),inst_65157,inst_65158,null));
var inst_65160 = cljs.core.count(inst_65159);
var inst_65161 = ((9) + inst_65160);
var inst_65162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65163 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65165 = [inst_65155];
var inst_65166 = (new cljs.core.PersistentVector(null,1,(5),inst_65164,inst_65165,null));
var inst_65167 = ["<=",inst_65166,inst_65156];
var inst_65168 = cljs.core.PersistentHashMap.fromArrays(inst_65163,inst_65167);
var inst_65169 = [inst_65168,inst_65161];
var inst_65170 = (new cljs.core.PersistentVector(null,2,(5),inst_65162,inst_65169,null));
var inst_65171 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65170);
var _ = (function (){var statearr_65185 = state_65176;
(statearr_65185[(4)] = cljs.core.rest((state_65176[(4)])));

return statearr_65185;
})();
var state_65176__$1 = (function (){var statearr_65186 = state_65176;
(statearr_65186[(7)] = inst_65171);

return statearr_65186;
})();
var statearr_65187_65200 = state_65176__$1;
(statearr_65187_65200[(2)] = inst_65156);

(statearr_65187_65200[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65188 = [null,null,null,null,null,null,null,null];
(statearr_65188[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65188[(1)] = (1));

return statearr_65188;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65176){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65176);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65189){var ex__10844__auto__ = e65189;
var statearr_65190_65201 = state_65176;
(statearr_65190_65201[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65176[(4)]))){
var statearr_65191_65202 = state_65176;
(statearr_65191_65202[(1)] = cljs.core.first((state_65176[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65203 = state_65176;
state_65176 = G__65203;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65176){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65192 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65192[(6)] = c__10878__auto__);

return statearr_65192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq65144){
var G__65145 = cljs.core.first(seq65144);
var seq65144__$1 = cljs.core.next(seq65144);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65145,seq65144__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65253 = arguments.length;
var i__4830__auto___65254 = (0);
while(true){
if((i__4830__auto___65254 < len__4829__auto___65253)){
args__4835__auto__.push((arguments[i__4830__auto___65254]));

var G__65255 = (i__4830__auto___65254 + (1));
i__4830__auto___65254 = G__65255;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65236){
var state_val_65237 = (state_65236[(1)]);
if((state_val_65237 === (1))){
var state_65236__$1 = state_65236;
var statearr_65238_65256 = state_65236__$1;
(statearr_65238_65256[(2)] = null);

(statearr_65238_65256[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65237 === (2))){
var _ = (function (){var statearr_65239 = state_65236;
(statearr_65239[(4)] = cljs.core.cons((5),(state_65236[(4)])));

return statearr_65239;
})();
var inst_65212 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65236__$1 = state_65236;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65236__$1,(6),inst_65212);
} else {
if((state_val_65237 === (3))){
var inst_65234 = (state_65236[(2)]);
var state_65236__$1 = state_65236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65236__$1,inst_65234);
} else {
if((state_val_65237 === (4))){
var inst_65206 = (state_65236[(2)]);
var state_65236__$1 = state_65236;
var statearr_65241_65257 = state_65236__$1;
(statearr_65241_65257[(2)] = inst_65206);

(statearr_65241_65257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65237 === (5))){
var _ = (function (){var statearr_65242 = state_65236;
(statearr_65242[(4)] = cljs.core.rest((state_65236[(4)])));

return statearr_65242;
})();
var state_65236__$1 = state_65236;
var ex65240 = (state_65236__$1[(2)]);
var statearr_65243_65258 = state_65236__$1;
(statearr_65243_65258[(5)] = ex65240);


if((ex65240 instanceof Error)){
var statearr_65244_65259 = state_65236__$1;
(statearr_65244_65259[(1)] = (4));

(statearr_65244_65259[(5)] = null);

} else {
throw ex65240;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65237 === (6))){
var inst_65214 = (state_65236[(2)]);
var inst_65215 = fluree.db.util.async.throw_err(inst_65214);
var inst_65216 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_65215);
var inst_65217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65218 = [inst_65215];
var inst_65219 = (new cljs.core.PersistentVector(null,1,(5),inst_65217,inst_65218,null));
var inst_65220 = cljs.core.count(inst_65219);
var inst_65221 = ((9) + inst_65220);
var inst_65222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65223 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65225 = [inst_65215];
var inst_65226 = (new cljs.core.PersistentVector(null,1,(5),inst_65224,inst_65225,null));
var inst_65227 = [">=",inst_65226,inst_65216];
var inst_65228 = cljs.core.PersistentHashMap.fromArrays(inst_65223,inst_65227);
var inst_65229 = [inst_65228,inst_65221];
var inst_65230 = (new cljs.core.PersistentVector(null,2,(5),inst_65222,inst_65229,null));
var inst_65231 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65230);
var _ = (function (){var statearr_65245 = state_65236;
(statearr_65245[(4)] = cljs.core.rest((state_65236[(4)])));

return statearr_65245;
})();
var state_65236__$1 = (function (){var statearr_65246 = state_65236;
(statearr_65246[(7)] = inst_65231);

return statearr_65246;
})();
var statearr_65247_65260 = state_65236__$1;
(statearr_65247_65260[(2)] = inst_65216);

(statearr_65247_65260[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65248 = [null,null,null,null,null,null,null,null];
(statearr_65248[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65248[(1)] = (1));

return statearr_65248;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65236){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65236);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65249){var ex__10844__auto__ = e65249;
var statearr_65250_65261 = state_65236;
(statearr_65250_65261[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65236[(4)]))){
var statearr_65251_65262 = state_65236;
(statearr_65251_65262[(1)] = cljs.core.first((state_65236[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65263 = state_65236;
state_65236 = G__65263;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65236){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65252 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65252[(6)] = c__10878__auto__);

return statearr_65252;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq65204){
var G__65205 = cljs.core.first(seq65204);
var seq65204__$1 = cljs.core.next(seq65204);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65205,seq65204__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65313 = arguments.length;
var i__4830__auto___65314 = (0);
while(true){
if((i__4830__auto___65314 < len__4829__auto___65313)){
args__4835__auto__.push((arguments[i__4830__auto___65314]));

var G__65315 = (i__4830__auto___65314 + (1));
i__4830__auto___65314 = G__65315;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65296){
var state_val_65297 = (state_65296[(1)]);
if((state_val_65297 === (1))){
var state_65296__$1 = state_65296;
var statearr_65298_65316 = state_65296__$1;
(statearr_65298_65316[(2)] = null);

(statearr_65298_65316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65297 === (2))){
var _ = (function (){var statearr_65299 = state_65296;
(statearr_65299[(4)] = cljs.core.cons((5),(state_65296[(4)])));

return statearr_65299;
})();
var inst_65272 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65296__$1 = state_65296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65296__$1,(6),inst_65272);
} else {
if((state_val_65297 === (3))){
var inst_65294 = (state_65296[(2)]);
var state_65296__$1 = state_65296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65296__$1,inst_65294);
} else {
if((state_val_65297 === (4))){
var inst_65266 = (state_65296[(2)]);
var state_65296__$1 = state_65296;
var statearr_65301_65317 = state_65296__$1;
(statearr_65301_65317[(2)] = inst_65266);

(statearr_65301_65317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65297 === (5))){
var _ = (function (){var statearr_65302 = state_65296;
(statearr_65302[(4)] = cljs.core.rest((state_65296[(4)])));

return statearr_65302;
})();
var state_65296__$1 = state_65296;
var ex65300 = (state_65296__$1[(2)]);
var statearr_65303_65318 = state_65296__$1;
(statearr_65303_65318[(5)] = ex65300);


if((ex65300 instanceof Error)){
var statearr_65304_65319 = state_65296__$1;
(statearr_65304_65319[(1)] = (4));

(statearr_65304_65319[(5)] = null);

} else {
throw ex65300;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65297 === (6))){
var inst_65274 = (state_65296[(2)]);
var inst_65275 = fluree.db.util.async.throw_err(inst_65274);
var inst_65276 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_65275);
var inst_65277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65278 = [inst_65275];
var inst_65279 = (new cljs.core.PersistentVector(null,1,(5),inst_65277,inst_65278,null));
var inst_65280 = cljs.core.count(inst_65279);
var inst_65281 = ((9) + inst_65280);
var inst_65282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65283 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65285 = [inst_65275];
var inst_65286 = (new cljs.core.PersistentVector(null,1,(5),inst_65284,inst_65285,null));
var inst_65287 = ["not=",inst_65286,inst_65276];
var inst_65288 = cljs.core.PersistentHashMap.fromArrays(inst_65283,inst_65287);
var inst_65289 = [inst_65288,inst_65281];
var inst_65290 = (new cljs.core.PersistentVector(null,2,(5),inst_65282,inst_65289,null));
var inst_65291 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65290);
var _ = (function (){var statearr_65305 = state_65296;
(statearr_65305[(4)] = cljs.core.rest((state_65296[(4)])));

return statearr_65305;
})();
var state_65296__$1 = (function (){var statearr_65306 = state_65296;
(statearr_65306[(7)] = inst_65291);

return statearr_65306;
})();
var statearr_65307_65320 = state_65296__$1;
(statearr_65307_65320[(2)] = inst_65276);

(statearr_65307_65320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65308 = [null,null,null,null,null,null,null,null];
(statearr_65308[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65308[(1)] = (1));

return statearr_65308;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65296){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65296);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65309){var ex__10844__auto__ = e65309;
var statearr_65310_65321 = state_65296;
(statearr_65310_65321[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65296[(4)]))){
var statearr_65311_65322 = state_65296;
(statearr_65311_65322[(1)] = cljs.core.first((state_65296[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65323 = state_65296;
state_65296 = G__65323;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65296){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65312 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65312[(6)] = c__10878__auto__);

return statearr_65312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq65264){
var G__65265 = cljs.core.first(seq65264);
var seq65264__$1 = cljs.core.next(seq65264);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65265,seq65264__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65373 = arguments.length;
var i__4830__auto___65374 = (0);
while(true){
if((i__4830__auto___65374 < len__4829__auto___65373)){
args__4835__auto__.push((arguments[i__4830__auto___65374]));

var G__65375 = (i__4830__auto___65374 + (1));
i__4830__auto___65374 = G__65375;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65356){
var state_val_65357 = (state_65356[(1)]);
if((state_val_65357 === (1))){
var state_65356__$1 = state_65356;
var statearr_65358_65376 = state_65356__$1;
(statearr_65358_65376[(2)] = null);

(statearr_65358_65376[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65357 === (2))){
var _ = (function (){var statearr_65359 = state_65356;
(statearr_65359[(4)] = cljs.core.cons((5),(state_65356[(4)])));

return statearr_65359;
})();
var inst_65332 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65356__$1 = state_65356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65356__$1,(6),inst_65332);
} else {
if((state_val_65357 === (3))){
var inst_65354 = (state_65356[(2)]);
var state_65356__$1 = state_65356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65356__$1,inst_65354);
} else {
if((state_val_65357 === (4))){
var inst_65326 = (state_65356[(2)]);
var state_65356__$1 = state_65356;
var statearr_65361_65377 = state_65356__$1;
(statearr_65361_65377[(2)] = inst_65326);

(statearr_65361_65377[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65357 === (5))){
var _ = (function (){var statearr_65362 = state_65356;
(statearr_65362[(4)] = cljs.core.rest((state_65356[(4)])));

return statearr_65362;
})();
var state_65356__$1 = state_65356;
var ex65360 = (state_65356__$1[(2)]);
var statearr_65363_65378 = state_65356__$1;
(statearr_65363_65378[(5)] = ex65360);


if((ex65360 instanceof Error)){
var statearr_65364_65379 = state_65356__$1;
(statearr_65364_65379[(1)] = (4));

(statearr_65364_65379[(5)] = null);

} else {
throw ex65360;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65357 === (6))){
var inst_65334 = (state_65356[(2)]);
var inst_65335 = fluree.db.util.async.throw_err(inst_65334);
var inst_65336 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_65335);
var inst_65337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65338 = [inst_65335];
var inst_65339 = (new cljs.core.PersistentVector(null,1,(5),inst_65337,inst_65338,null));
var inst_65340 = cljs.core.count(inst_65339);
var inst_65341 = ((9) + inst_65340);
var inst_65342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65343 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65345 = [inst_65335];
var inst_65346 = (new cljs.core.PersistentVector(null,1,(5),inst_65344,inst_65345,null));
var inst_65347 = ["max",inst_65346,inst_65336];
var inst_65348 = cljs.core.PersistentHashMap.fromArrays(inst_65343,inst_65347);
var inst_65349 = [inst_65348,inst_65341];
var inst_65350 = (new cljs.core.PersistentVector(null,2,(5),inst_65342,inst_65349,null));
var inst_65351 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65350);
var _ = (function (){var statearr_65365 = state_65356;
(statearr_65365[(4)] = cljs.core.rest((state_65356[(4)])));

return statearr_65365;
})();
var state_65356__$1 = (function (){var statearr_65366 = state_65356;
(statearr_65366[(7)] = inst_65351);

return statearr_65366;
})();
var statearr_65367_65380 = state_65356__$1;
(statearr_65367_65380[(2)] = inst_65336);

(statearr_65367_65380[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65368 = [null,null,null,null,null,null,null,null];
(statearr_65368[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65368[(1)] = (1));

return statearr_65368;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65356){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65356);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65369){var ex__10844__auto__ = e65369;
var statearr_65370_65381 = state_65356;
(statearr_65370_65381[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65356[(4)]))){
var statearr_65371_65382 = state_65356;
(statearr_65371_65382[(1)] = cljs.core.first((state_65356[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65383 = state_65356;
state_65356 = G__65383;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65356){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65372 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65372[(6)] = c__10878__auto__);

return statearr_65372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq65324){
var G__65325 = cljs.core.first(seq65324);
var seq65324__$1 = cljs.core.next(seq65324);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65325,seq65324__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___65433 = arguments.length;
var i__4830__auto___65434 = (0);
while(true){
if((i__4830__auto___65434 < len__4829__auto___65433)){
args__4835__auto__.push((arguments[i__4830__auto___65434]));

var G__65435 = (i__4830__auto___65434 + (1));
i__4830__auto___65434 = G__65435;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65416){
var state_val_65417 = (state_65416[(1)]);
if((state_val_65417 === (1))){
var state_65416__$1 = state_65416;
var statearr_65418_65436 = state_65416__$1;
(statearr_65418_65436[(2)] = null);

(statearr_65418_65436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65417 === (2))){
var _ = (function (){var statearr_65419 = state_65416;
(statearr_65419[(4)] = cljs.core.cons((5),(state_65416[(4)])));

return statearr_65419;
})();
var inst_65392 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65416__$1 = state_65416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65416__$1,(6),inst_65392);
} else {
if((state_val_65417 === (3))){
var inst_65414 = (state_65416[(2)]);
var state_65416__$1 = state_65416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65416__$1,inst_65414);
} else {
if((state_val_65417 === (4))){
var inst_65386 = (state_65416[(2)]);
var state_65416__$1 = state_65416;
var statearr_65421_65437 = state_65416__$1;
(statearr_65421_65437[(2)] = inst_65386);

(statearr_65421_65437[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65417 === (5))){
var _ = (function (){var statearr_65422 = state_65416;
(statearr_65422[(4)] = cljs.core.rest((state_65416[(4)])));

return statearr_65422;
})();
var state_65416__$1 = state_65416;
var ex65420 = (state_65416__$1[(2)]);
var statearr_65423_65438 = state_65416__$1;
(statearr_65423_65438[(5)] = ex65420);


if((ex65420 instanceof Error)){
var statearr_65424_65439 = state_65416__$1;
(statearr_65424_65439[(1)] = (4));

(statearr_65424_65439[(5)] = null);

} else {
throw ex65420;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65417 === (6))){
var inst_65394 = (state_65416[(2)]);
var inst_65395 = fluree.db.util.async.throw_err(inst_65394);
var inst_65396 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_65395);
var inst_65397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65398 = [inst_65395];
var inst_65399 = (new cljs.core.PersistentVector(null,1,(5),inst_65397,inst_65398,null));
var inst_65400 = cljs.core.count(inst_65399);
var inst_65401 = ((9) + inst_65400);
var inst_65402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65403 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65405 = [inst_65395];
var inst_65406 = (new cljs.core.PersistentVector(null,1,(5),inst_65404,inst_65405,null));
var inst_65407 = ["min",inst_65406,inst_65396];
var inst_65408 = cljs.core.PersistentHashMap.fromArrays(inst_65403,inst_65407);
var inst_65409 = [inst_65408,inst_65401];
var inst_65410 = (new cljs.core.PersistentVector(null,2,(5),inst_65402,inst_65409,null));
var inst_65411 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65410);
var _ = (function (){var statearr_65425 = state_65416;
(statearr_65425[(4)] = cljs.core.rest((state_65416[(4)])));

return statearr_65425;
})();
var state_65416__$1 = (function (){var statearr_65426 = state_65416;
(statearr_65426[(7)] = inst_65411);

return statearr_65426;
})();
var statearr_65427_65440 = state_65416__$1;
(statearr_65427_65440[(2)] = inst_65396);

(statearr_65427_65440[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65428 = [null,null,null,null,null,null,null,null];
(statearr_65428[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65428[(1)] = (1));

return statearr_65428;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65416){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65416);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65429){var ex__10844__auto__ = e65429;
var statearr_65430_65441 = state_65416;
(statearr_65430_65441[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65416[(4)]))){
var statearr_65431_65442 = state_65416;
(statearr_65431_65442[(1)] = cljs.core.first((state_65416[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65443 = state_65416;
state_65416 = G__65443;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65416){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65432 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65432[(6)] = c__10878__auto__);

return statearr_65432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq65384){
var G__65385 = cljs.core.first(seq65384);
var seq65384__$1 = cljs.core.next(seq65384);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65385,seq65384__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__65445 = arguments.length;
switch (G__65445) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65490){
var state_val_65491 = (state_65490[(1)]);
if((state_val_65491 === (7))){
var state_65490__$1 = state_65490;
var statearr_65492_65629 = state_65490__$1;
(statearr_65492_65629[(2)] = query_map);

(statearr_65492_65629[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (1))){
var state_65490__$1 = state_65490;
var statearr_65493_65630 = state_65490__$1;
(statearr_65493_65630[(2)] = null);

(statearr_65493_65630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (4))){
var inst_65446 = (state_65490[(2)]);
var state_65490__$1 = state_65490;
var statearr_65494_65631 = state_65490__$1;
(statearr_65494_65631[(2)] = inst_65446);

(statearr_65494_65631[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (13))){
var inst_65468 = (state_65490[(7)]);
var inst_65472 = (state_65490[(2)]);
var inst_65473 = fluree.db.util.async.throw_err(inst_65472);
var inst_65474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65473,(0),null);
var inst_65475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65473,(1),null);
var inst_65476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65477 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65479 = [inst_65468];
var inst_65480 = (new cljs.core.PersistentVector(null,1,(5),inst_65478,inst_65479,null));
var inst_65481 = ["query",inst_65480,inst_65474];
var inst_65482 = cljs.core.PersistentHashMap.fromArrays(inst_65477,inst_65481);
var inst_65483 = [inst_65482,inst_65475];
var inst_65484 = (new cljs.core.PersistentVector(null,2,(5),inst_65476,inst_65483,null));
var inst_65485 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65484);
var _ = (function (){var statearr_65495 = state_65490;
(statearr_65495[(4)] = cljs.core.rest((state_65490[(4)])));

return statearr_65495;
})();
var state_65490__$1 = (function (){var statearr_65496 = state_65490;
(statearr_65496[(8)] = inst_65485);

return statearr_65496;
})();
var statearr_65497_65632 = state_65490__$1;
(statearr_65497_65632[(2)] = inst_65474);

(statearr_65497_65632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (6))){
var state_65490__$1 = state_65490;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65490__$1,(9),query_map);
} else {
if((state_val_65491 === (3))){
var inst_65488 = (state_65490[(2)]);
var state_65490__$1 = state_65490;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65490__$1,inst_65488);
} else {
if((state_val_65491 === (12))){
var inst_65468 = (state_65490[(7)]);
var inst_65468__$1 = (state_65490[(2)]);
var inst_65469 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65470 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_65469,inst_65468__$1);
var state_65490__$1 = (function (){var statearr_65498 = state_65490;
(statearr_65498[(7)] = inst_65468__$1);

return statearr_65498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65490__$1,(13),inst_65470);
} else {
if((state_val_65491 === (2))){
var _ = (function (){var statearr_65499 = state_65490;
(statearr_65499[(4)] = cljs.core.cons((5),(state_65490[(4)])));

return statearr_65499;
})();
var inst_65455 = fluree.db.util.async.channel_QMARK_(query_map);
var state_65490__$1 = state_65490;
if(inst_65455){
var statearr_65500_65633 = state_65490__$1;
(statearr_65500_65633[(1)] = (6));

} else {
var statearr_65501_65634 = state_65490__$1;
(statearr_65501_65634[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (11))){
var inst_65462 = (state_65490[(9)]);
var state_65490__$1 = state_65490;
var statearr_65503_65635 = state_65490__$1;
(statearr_65503_65635[(2)] = inst_65462);

(statearr_65503_65635[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (9))){
var inst_65458 = (state_65490[(2)]);
var inst_65459 = fluree.db.util.async.throw_err(inst_65458);
var state_65490__$1 = state_65490;
var statearr_65504_65636 = state_65490__$1;
(statearr_65504_65636[(2)] = inst_65459);

(statearr_65504_65636[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (5))){
var _ = (function (){var statearr_65505 = state_65490;
(statearr_65505[(4)] = cljs.core.rest((state_65490[(4)])));

return statearr_65505;
})();
var state_65490__$1 = state_65490;
var ex65502 = (state_65490__$1[(2)]);
var statearr_65506_65637 = state_65490__$1;
(statearr_65506_65637[(5)] = ex65502);


if((ex65502 instanceof Error)){
var statearr_65507_65638 = state_65490__$1;
(statearr_65507_65638[(1)] = (4));

(statearr_65507_65638[(5)] = null);

} else {
throw ex65502;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (10))){
var inst_65462 = (state_65490[(9)]);
var inst_65465 = fluree.db.util.json.parse(inst_65462);
var state_65490__$1 = state_65490;
var statearr_65508_65639 = state_65490__$1;
(statearr_65508_65639[(2)] = inst_65465);

(statearr_65508_65639[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65491 === (8))){
var inst_65462 = (state_65490[(9)]);
var inst_65462__$1 = (state_65490[(2)]);
var inst_65463 = typeof inst_65462__$1 === 'string';
var state_65490__$1 = (function (){var statearr_65509 = state_65490;
(statearr_65509[(9)] = inst_65462__$1);

return statearr_65509;
})();
if(cljs.core.truth_(inst_65463)){
var statearr_65510_65640 = state_65490__$1;
(statearr_65510_65640[(1)] = (10));

} else {
var statearr_65511_65641 = state_65490__$1;
(statearr_65511_65641[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65512 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65512[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65512[(1)] = (1));

return statearr_65512;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65490){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65490);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65513){var ex__10844__auto__ = e65513;
var statearr_65514_65642 = state_65490;
(statearr_65514_65642[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65490[(4)]))){
var statearr_65515_65643 = state_65490;
(statearr_65515_65643[(1)] = cljs.core.first((state_65490[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65644 = state_65490;
state_65490 = G__65644;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65490){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65490);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65516 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65516[(6)] = c__10878__auto__);

return statearr_65516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65587){
var state_val_65588 = (state_65587[(1)]);
if((state_val_65588 === (7))){
var state_65587__$1 = state_65587;
var statearr_65589_65645 = state_65587__$1;
(statearr_65589_65645[(2)] = select);

(statearr_65589_65645[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (20))){
var inst_65557 = (state_65587[(2)]);
var inst_65558 = fluree.db.util.async.channel_QMARK_(limit);
var state_65587__$1 = (function (){var statearr_65590 = state_65587;
(statearr_65590[(7)] = inst_65557);

return statearr_65590;
})();
if(inst_65558){
var statearr_65591_65646 = state_65587__$1;
(statearr_65591_65646[(1)] = (22));

} else {
var statearr_65592_65647 = state_65587__$1;
(statearr_65592_65647[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (1))){
var state_65587__$1 = state_65587;
var statearr_65593_65648 = state_65587__$1;
(statearr_65593_65648[(2)] = null);

(statearr_65593_65648[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (24))){
var inst_65557 = (state_65587[(7)]);
var inst_65533 = (state_65587[(8)]);
var inst_65549 = (state_65587[(9)]);
var inst_65541 = (state_65587[(10)]);
var inst_65565 = (state_65587[(2)]);
var inst_65566 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65567 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_65566,inst_65533,inst_65541,inst_65549,inst_65557,inst_65565);
var state_65587__$1 = state_65587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65587__$1,(26),inst_65567);
} else {
if((state_val_65588 === (4))){
var inst_65517 = (state_65587[(2)]);
var state_65587__$1 = state_65587;
var statearr_65594_65649 = state_65587__$1;
(statearr_65594_65649[(2)] = inst_65517);

(statearr_65594_65649[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (15))){
var state_65587__$1 = state_65587;
var statearr_65595_65650 = state_65587__$1;
(statearr_65595_65650[(2)] = where);

(statearr_65595_65650[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (21))){
var inst_65553 = (state_65587[(2)]);
var inst_65554 = fluree.db.util.async.throw_err(inst_65553);
var state_65587__$1 = state_65587;
var statearr_65596_65651 = state_65587__$1;
(statearr_65596_65651[(2)] = inst_65554);

(statearr_65596_65651[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (13))){
var inst_65537 = (state_65587[(2)]);
var inst_65538 = fluree.db.util.async.throw_err(inst_65537);
var state_65587__$1 = state_65587;
var statearr_65597_65652 = state_65587__$1;
(statearr_65597_65652[(2)] = inst_65538);

(statearr_65597_65652[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (22))){
var state_65587__$1 = state_65587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65587__$1,(25),limit);
} else {
if((state_val_65588 === (6))){
var state_65587__$1 = state_65587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65587__$1,(9),select);
} else {
if((state_val_65588 === (25))){
var inst_65561 = (state_65587[(2)]);
var inst_65562 = fluree.db.util.async.throw_err(inst_65561);
var state_65587__$1 = state_65587;
var statearr_65598_65653 = state_65587__$1;
(statearr_65598_65653[(2)] = inst_65562);

(statearr_65598_65653[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (17))){
var inst_65545 = (state_65587[(2)]);
var inst_65546 = fluree.db.util.async.throw_err(inst_65545);
var state_65587__$1 = state_65587;
var statearr_65599_65654 = state_65587__$1;
(statearr_65599_65654[(2)] = inst_65546);

(statearr_65599_65654[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (3))){
var inst_65585 = (state_65587[(2)]);
var state_65587__$1 = state_65587;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65587__$1,inst_65585);
} else {
if((state_val_65588 === (12))){
var inst_65541 = (state_65587[(2)]);
var inst_65542 = fluree.db.util.async.channel_QMARK_(where);
var state_65587__$1 = (function (){var statearr_65600 = state_65587;
(statearr_65600[(10)] = inst_65541);

return statearr_65600;
})();
if(inst_65542){
var statearr_65601_65655 = state_65587__$1;
(statearr_65601_65655[(1)] = (14));

} else {
var statearr_65602_65656 = state_65587__$1;
(statearr_65602_65656[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (2))){
var _ = (function (){var statearr_65603 = state_65587;
(statearr_65603[(4)] = cljs.core.cons((5),(state_65587[(4)])));

return statearr_65603;
})();
var inst_65526 = fluree.db.util.async.channel_QMARK_(select);
var state_65587__$1 = state_65587;
if(inst_65526){
var statearr_65604_65657 = state_65587__$1;
(statearr_65604_65657[(1)] = (6));

} else {
var statearr_65605_65658 = state_65587__$1;
(statearr_65605_65658[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (23))){
var state_65587__$1 = state_65587;
var statearr_65606_65659 = state_65587__$1;
(statearr_65606_65659[(2)] = limit);

(statearr_65606_65659[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (19))){
var state_65587__$1 = state_65587;
var statearr_65607_65660 = state_65587__$1;
(statearr_65607_65660[(2)] = block);

(statearr_65607_65660[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (11))){
var state_65587__$1 = state_65587;
var statearr_65609_65661 = state_65587__$1;
(statearr_65609_65661[(2)] = from);

(statearr_65609_65661[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (9))){
var inst_65529 = (state_65587[(2)]);
var inst_65530 = fluree.db.util.async.throw_err(inst_65529);
var state_65587__$1 = state_65587;
var statearr_65610_65662 = state_65587__$1;
(statearr_65610_65662[(2)] = inst_65530);

(statearr_65610_65662[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (5))){
var _ = (function (){var statearr_65611 = state_65587;
(statearr_65611[(4)] = cljs.core.rest((state_65587[(4)])));

return statearr_65611;
})();
var state_65587__$1 = state_65587;
var ex65608 = (state_65587__$1[(2)]);
var statearr_65612_65663 = state_65587__$1;
(statearr_65612_65663[(5)] = ex65608);


if((ex65608 instanceof Error)){
var statearr_65613_65664 = state_65587__$1;
(statearr_65613_65664[(1)] = (4));

(statearr_65613_65664[(5)] = null);

} else {
throw ex65608;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (14))){
var state_65587__$1 = state_65587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65587__$1,(17),where);
} else {
if((state_val_65588 === (26))){
var inst_65557 = (state_65587[(7)]);
var inst_65533 = (state_65587[(8)]);
var inst_65549 = (state_65587[(9)]);
var inst_65541 = (state_65587[(10)]);
var inst_65569 = (state_65587[(2)]);
var inst_65570 = fluree.db.util.async.throw_err(inst_65569);
var inst_65571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65570,(0),null);
var inst_65572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65570,(1),null);
var inst_65573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65574 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65576 = [inst_65533,inst_65541,inst_65549,inst_65557];
var inst_65577 = (new cljs.core.PersistentVector(null,4,(5),inst_65575,inst_65576,null));
var inst_65578 = ["query",inst_65577,inst_65571];
var inst_65579 = cljs.core.PersistentHashMap.fromArrays(inst_65574,inst_65578);
var inst_65580 = [inst_65579,inst_65572];
var inst_65581 = (new cljs.core.PersistentVector(null,2,(5),inst_65573,inst_65580,null));
var inst_65582 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65581);
var _ = (function (){var statearr_65614 = state_65587;
(statearr_65614[(4)] = cljs.core.rest((state_65587[(4)])));

return statearr_65614;
})();
var state_65587__$1 = (function (){var statearr_65615 = state_65587;
(statearr_65615[(11)] = inst_65582);

return statearr_65615;
})();
var statearr_65616_65665 = state_65587__$1;
(statearr_65616_65665[(2)] = inst_65571);

(statearr_65616_65665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (16))){
var inst_65549 = (state_65587[(2)]);
var inst_65550 = fluree.db.util.async.channel_QMARK_(block);
var state_65587__$1 = (function (){var statearr_65617 = state_65587;
(statearr_65617[(9)] = inst_65549);

return statearr_65617;
})();
if(inst_65550){
var statearr_65618_65666 = state_65587__$1;
(statearr_65618_65666[(1)] = (18));

} else {
var statearr_65619_65667 = state_65587__$1;
(statearr_65619_65667[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65588 === (10))){
var state_65587__$1 = state_65587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65587__$1,(13),from);
} else {
if((state_val_65588 === (18))){
var state_65587__$1 = state_65587;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65587__$1,(21),block);
} else {
if((state_val_65588 === (8))){
var inst_65533 = (state_65587[(2)]);
var inst_65534 = fluree.db.util.async.channel_QMARK_(from);
var state_65587__$1 = (function (){var statearr_65620 = state_65587;
(statearr_65620[(8)] = inst_65533);

return statearr_65620;
})();
if(inst_65534){
var statearr_65621_65668 = state_65587__$1;
(statearr_65621_65668[(1)] = (10));

} else {
var statearr_65622_65669 = state_65587__$1;
(statearr_65622_65669[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_65623 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65623[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_65623[(1)] = (1));

return statearr_65623;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_65587){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65587);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65624){var ex__10844__auto__ = e65624;
var statearr_65625_65670 = state_65587;
(statearr_65625_65670[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65587[(4)]))){
var statearr_65626_65671 = state_65587;
(statearr_65626_65671[(1)] = cljs.core.first((state_65587[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65672 = state_65587;
state_65587 = G__65672;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_65587){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_65587);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65627 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65627[(6)] = c__10878__auto__);

return statearr_65627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65728){
var state_val_65729 = (state_65728[(1)]);
if((state_val_65729 === (7))){
var state_65728__$1 = state_65728;
var statearr_65730_65761 = state_65728__$1;
(statearr_65730_65761[(2)] = startSubject);

(statearr_65730_65761[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (1))){
var state_65728__$1 = state_65728;
var statearr_65731_65762 = state_65728__$1;
(statearr_65731_65762[(2)] = null);

(statearr_65731_65762[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (4))){
var inst_65673 = (state_65728[(2)]);
var state_65728__$1 = state_65728;
var statearr_65732_65763 = state_65728__$1;
(statearr_65732_65763[(2)] = inst_65673);

(statearr_65732_65763[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (15))){
var inst_65705 = (state_65728[(2)]);
var inst_65706 = fluree.db.util.async.throw_err(inst_65705);
var inst_65707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65706,(0),null);
var inst_65708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65706,(1),null);
var inst_65709 = cljs.core.empty_QMARK_(inst_65707);
var state_65728__$1 = (function (){var statearr_65733 = state_65728;
(statearr_65733[(7)] = inst_65708);

return statearr_65733;
})();
if(inst_65709){
var statearr_65734_65764 = state_65728__$1;
(statearr_65734_65764[(1)] = (16));

} else {
var statearr_65735_65765 = state_65728__$1;
(statearr_65735_65765[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (13))){
var inst_65689 = (state_65728[(8)]);
var inst_65701 = (state_65728[(9)]);
var inst_65693 = (state_65728[(10)]);
var inst_65701__$1 = (state_65728[(2)]);
var inst_65702 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65703 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_65702,inst_65689,inst_65693,inst_65701__$1);
var state_65728__$1 = (function (){var statearr_65736 = state_65728;
(statearr_65736[(9)] = inst_65701__$1);

return statearr_65736;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65728__$1,(15),inst_65703);
} else {
if((state_val_65729 === (6))){
var state_65728__$1 = state_65728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65728__$1,(9),startSubject);
} else {
if((state_val_65729 === (17))){
var state_65728__$1 = state_65728;
var statearr_65737_65766 = state_65728__$1;
(statearr_65737_65766[(2)] = true);

(statearr_65737_65766[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (3))){
var inst_65726 = (state_65728[(2)]);
var state_65728__$1 = state_65728;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65728__$1,inst_65726);
} else {
if((state_val_65729 === (12))){
var state_65728__$1 = state_65728;
var statearr_65738_65767 = state_65728__$1;
(statearr_65738_65767[(2)] = endSubject);

(statearr_65738_65767[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (2))){
var _ = (function (){var statearr_65739 = state_65728;
(statearr_65739[(4)] = cljs.core.cons((5),(state_65728[(4)])));

return statearr_65739;
})();
var inst_65682 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_65728__$1 = state_65728;
if(inst_65682){
var statearr_65740_65768 = state_65728__$1;
(statearr_65740_65768[(1)] = (6));

} else {
var statearr_65741_65769 = state_65728__$1;
(statearr_65741_65769[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (11))){
var state_65728__$1 = state_65728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65728__$1,(14),endSubject);
} else {
if((state_val_65729 === (9))){
var inst_65685 = (state_65728[(2)]);
var inst_65686 = fluree.db.util.async.throw_err(inst_65685);
var state_65728__$1 = state_65728;
var statearr_65743_65770 = state_65728__$1;
(statearr_65743_65770[(2)] = inst_65686);

(statearr_65743_65770[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (5))){
var _ = (function (){var statearr_65744 = state_65728;
(statearr_65744[(4)] = cljs.core.rest((state_65728[(4)])));

return statearr_65744;
})();
var state_65728__$1 = state_65728;
var ex65742 = (state_65728__$1[(2)]);
var statearr_65745_65771 = state_65728__$1;
(statearr_65745_65771[(5)] = ex65742);


if((ex65742 instanceof Error)){
var statearr_65746_65772 = state_65728__$1;
(statearr_65746_65772[(1)] = (4));

(statearr_65746_65772[(5)] = null);

} else {
throw ex65742;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (14))){
var inst_65697 = (state_65728[(2)]);
var inst_65698 = fluree.db.util.async.throw_err(inst_65697);
var state_65728__$1 = state_65728;
var statearr_65747_65773 = state_65728__$1;
(statearr_65747_65773[(2)] = inst_65698);

(statearr_65747_65773[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (16))){
var state_65728__$1 = state_65728;
var statearr_65748_65774 = state_65728__$1;
(statearr_65748_65774[(2)] = false);

(statearr_65748_65774[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (10))){
var inst_65692 = (state_65728[(2)]);
var inst_65693 = fluree.db.util.async.throw_err(inst_65692);
var inst_65694 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_65728__$1 = (function (){var statearr_65749 = state_65728;
(statearr_65749[(10)] = inst_65693);

return statearr_65749;
})();
if(inst_65694){
var statearr_65750_65775 = state_65728__$1;
(statearr_65750_65775[(1)] = (11));

} else {
var statearr_65751_65776 = state_65728__$1;
(statearr_65751_65776[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (18))){
var inst_65708 = (state_65728[(7)]);
var inst_65689 = (state_65728[(8)]);
var inst_65701 = (state_65728[(9)]);
var inst_65693 = (state_65728[(10)]);
var inst_65713 = (state_65728[(2)]);
var inst_65714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65715 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65717 = [inst_65689,inst_65693,inst_65701];
var inst_65718 = (new cljs.core.PersistentVector(null,3,(5),inst_65716,inst_65717,null));
var inst_65719 = ["relationship?",inst_65718,inst_65713];
var inst_65720 = cljs.core.PersistentHashMap.fromArrays(inst_65715,inst_65719);
var inst_65721 = [inst_65720,inst_65708];
var inst_65722 = (new cljs.core.PersistentVector(null,2,(5),inst_65714,inst_65721,null));
var inst_65723 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65722);
var _ = (function (){var statearr_65752 = state_65728;
(statearr_65752[(4)] = cljs.core.rest((state_65728[(4)])));

return statearr_65752;
})();
var state_65728__$1 = (function (){var statearr_65753 = state_65728;
(statearr_65753[(11)] = inst_65723);

return statearr_65753;
})();
var statearr_65754_65777 = state_65728__$1;
(statearr_65754_65777[(2)] = inst_65713);

(statearr_65754_65777[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65729 === (8))){
var inst_65689 = (state_65728[(2)]);
var inst_65690 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_65728__$1 = (function (){var statearr_65755 = state_65728;
(statearr_65755[(8)] = inst_65689);

return statearr_65755;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65728__$1,(10),inst_65690);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto____0 = (function (){
var statearr_65756 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65756[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto__);

(statearr_65756[(1)] = (1));

return statearr_65756;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto____1 = (function (state_65728){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65728);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65757){var ex__10844__auto__ = e65757;
var statearr_65758_65778 = state_65728;
(statearr_65758_65778[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65728[(4)]))){
var statearr_65759_65779 = state_65728;
(statearr_65759_65779[(1)] = cljs.core.first((state_65728[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65780 = state_65728;
state_65728 = G__65780;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto__ = function(state_65728){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto____1.call(this,state_65728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65760 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65760[(6)] = c__10878__auto__);

return statearr_65760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65817){
var state_val_65818 = (state_65817[(1)]);
if((state_val_65818 === (7))){
var state_65817__$1 = state_65817;
var statearr_65819_65839 = state_65817__$1;
(statearr_65819_65839[(2)] = pred_name);

(statearr_65819_65839[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65818 === (1))){
var state_65817__$1 = state_65817;
var statearr_65820_65840 = state_65817__$1;
(statearr_65820_65840[(2)] = null);

(statearr_65820_65840[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65818 === (4))){
var inst_65781 = (state_65817[(2)]);
var state_65817__$1 = state_65817;
var statearr_65821_65841 = state_65817__$1;
(statearr_65821_65841[(2)] = inst_65781);

(statearr_65821_65841[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65818 === (6))){
var state_65817__$1 = state_65817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65817__$1,(9),pred_name);
} else {
if((state_val_65818 === (3))){
var inst_65815 = (state_65817[(2)]);
var state_65817__$1 = state_65817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65817__$1,inst_65815);
} else {
if((state_val_65818 === (2))){
var _ = (function (){var statearr_65823 = state_65817;
(statearr_65823[(4)] = cljs.core.cons((5),(state_65817[(4)])));

return statearr_65823;
})();
var inst_65790 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_65817__$1 = state_65817;
if(inst_65790){
var statearr_65824_65842 = state_65817__$1;
(statearr_65824_65842[(1)] = (6));

} else {
var statearr_65825_65843 = state_65817__$1;
(statearr_65825_65843[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65818 === (9))){
var inst_65793 = (state_65817[(2)]);
var inst_65794 = fluree.db.util.async.throw_err(inst_65793);
var state_65817__$1 = state_65817;
var statearr_65826_65844 = state_65817__$1;
(statearr_65826_65844[(2)] = inst_65794);

(statearr_65826_65844[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65818 === (5))){
var _ = (function (){var statearr_65827 = state_65817;
(statearr_65827[(4)] = cljs.core.rest((state_65817[(4)])));

return statearr_65827;
})();
var state_65817__$1 = state_65817;
var ex65822 = (state_65817__$1[(2)]);
var statearr_65828_65845 = state_65817__$1;
(statearr_65828_65845[(5)] = ex65822);


if((ex65822 instanceof Error)){
var statearr_65829_65846 = state_65817__$1;
(statearr_65829_65846[(1)] = (4));

(statearr_65829_65846[(5)] = null);

} else {
throw ex65822;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65818 === (10))){
var inst_65797 = (state_65817[(7)]);
var inst_65801 = (state_65817[(2)]);
var inst_65802 = fluree.db.util.async.throw_err(inst_65801);
var inst_65803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65802,(0),null);
var inst_65804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65802,(1),null);
var inst_65805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65806 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65807 = ["max-pred-val",inst_65797,inst_65803];
var inst_65808 = cljs.core.PersistentHashMap.fromArrays(inst_65806,inst_65807);
var inst_65809 = (inst_65804 + (10));
var inst_65810 = [inst_65808,inst_65809];
var inst_65811 = (new cljs.core.PersistentVector(null,2,(5),inst_65805,inst_65810,null));
var inst_65812 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65811);
var _ = (function (){var statearr_65830 = state_65817;
(statearr_65830[(4)] = cljs.core.rest((state_65817[(4)])));

return statearr_65830;
})();
var state_65817__$1 = (function (){var statearr_65831 = state_65817;
(statearr_65831[(8)] = inst_65812);

return statearr_65831;
})();
var statearr_65832_65847 = state_65817__$1;
(statearr_65832_65847[(2)] = inst_65803);

(statearr_65832_65847[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65818 === (8))){
var inst_65797 = (state_65817[(7)]);
var inst_65797__$1 = (state_65817[(2)]);
var inst_65798 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_65799 = fluree.db.dbfunctions.internal.max_pred_val(inst_65798,inst_65797__$1,null);
var state_65817__$1 = (function (){var statearr_65833 = state_65817;
(statearr_65833[(7)] = inst_65797__$1);

return statearr_65833;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65817__$1,(10),inst_65799);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto____0 = (function (){
var statearr_65834 = [null,null,null,null,null,null,null,null,null];
(statearr_65834[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto__);

(statearr_65834[(1)] = (1));

return statearr_65834;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto____1 = (function (state_65817){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65817);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65835){var ex__10844__auto__ = e65835;
var statearr_65836_65848 = state_65817;
(statearr_65836_65848[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65817[(4)]))){
var statearr_65837_65849 = state_65817;
(statearr_65837_65849[(1)] = cljs.core.first((state_65817[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65850 = state_65817;
state_65817 = G__65850;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto__ = function(state_65817){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto____1.call(this,state_65817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65838 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65838[(6)] = c__10878__auto__);

return statearr_65838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65877){
var state_val_65878 = (state_65877[(1)]);
if((state_val_65878 === (7))){
var state_65877__$1 = state_65877;
var statearr_65879_65898 = state_65877__$1;
(statearr_65879_65898[(2)] = n);

(statearr_65879_65898[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65878 === (1))){
var state_65877__$1 = state_65877;
var statearr_65880_65899 = state_65877__$1;
(statearr_65880_65899[(2)] = null);

(statearr_65880_65899[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65878 === (4))){
var inst_65851 = (state_65877[(2)]);
var state_65877__$1 = state_65877;
var statearr_65881_65900 = state_65877__$1;
(statearr_65881_65900[(2)] = inst_65851);

(statearr_65881_65900[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65878 === (6))){
var state_65877__$1 = state_65877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65877__$1,(9),n);
} else {
if((state_val_65878 === (3))){
var inst_65875 = (state_65877[(2)]);
var state_65877__$1 = state_65877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65877__$1,inst_65875);
} else {
if((state_val_65878 === (2))){
var _ = (function (){var statearr_65883 = state_65877;
(statearr_65883[(4)] = cljs.core.cons((5),(state_65877[(4)])));

return statearr_65883;
})();
var inst_65857 = fluree.db.util.async.channel_QMARK_(n);
var state_65877__$1 = state_65877;
if(inst_65857){
var statearr_65884_65901 = state_65877__$1;
(statearr_65884_65901[(1)] = (6));

} else {
var statearr_65885_65902 = state_65877__$1;
(statearr_65885_65902[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65878 === (9))){
var inst_65860 = (state_65877[(2)]);
var inst_65861 = fluree.db.util.async.throw_err(inst_65860);
var state_65877__$1 = state_65877;
var statearr_65886_65903 = state_65877__$1;
(statearr_65886_65903[(2)] = inst_65861);

(statearr_65886_65903[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65878 === (5))){
var _ = (function (){var statearr_65887 = state_65877;
(statearr_65887[(4)] = cljs.core.rest((state_65877[(4)])));

return statearr_65887;
})();
var state_65877__$1 = state_65877;
var ex65882 = (state_65877__$1[(2)]);
var statearr_65888_65904 = state_65877__$1;
(statearr_65888_65904[(5)] = ex65882);


if((ex65882 instanceof Error)){
var statearr_65889_65905 = state_65877__$1;
(statearr_65889_65905[(1)] = (4));

(statearr_65889_65905[(5)] = null);

} else {
throw ex65882;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65878 === (8))){
var inst_65864 = (state_65877[(2)]);
var inst_65865 = fluree.db.dbfunctions.internal.inc(inst_65864);
var inst_65866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65867 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65868 = ["inc",inst_65864,inst_65865];
var inst_65869 = cljs.core.PersistentHashMap.fromArrays(inst_65867,inst_65868);
var inst_65870 = [inst_65869,(10)];
var inst_65871 = (new cljs.core.PersistentVector(null,2,(5),inst_65866,inst_65870,null));
var inst_65872 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65871);
var _ = (function (){var statearr_65890 = state_65877;
(statearr_65890[(4)] = cljs.core.rest((state_65877[(4)])));

return statearr_65890;
})();
var state_65877__$1 = (function (){var statearr_65891 = state_65877;
(statearr_65891[(7)] = inst_65872);

return statearr_65891;
})();
var statearr_65892_65906 = state_65877__$1;
(statearr_65892_65906[(2)] = inst_65865);

(statearr_65892_65906[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto____0 = (function (){
var statearr_65893 = [null,null,null,null,null,null,null,null];
(statearr_65893[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto__);

(statearr_65893[(1)] = (1));

return statearr_65893;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto____1 = (function (state_65877){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65877);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65894){var ex__10844__auto__ = e65894;
var statearr_65895_65907 = state_65877;
(statearr_65895_65907[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65877[(4)]))){
var statearr_65896_65908 = state_65877;
(statearr_65896_65908[(1)] = cljs.core.first((state_65877[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65909 = state_65877;
state_65877 = G__65909;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto__ = function(state_65877){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto____1.call(this,state_65877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65897 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65897[(6)] = c__10878__auto__);

return statearr_65897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_65936){
var state_val_65937 = (state_65936[(1)]);
if((state_val_65937 === (7))){
var state_65936__$1 = state_65936;
var statearr_65938_65957 = state_65936__$1;
(statearr_65938_65957[(2)] = n);

(statearr_65938_65957[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65937 === (1))){
var state_65936__$1 = state_65936;
var statearr_65939_65958 = state_65936__$1;
(statearr_65939_65958[(2)] = null);

(statearr_65939_65958[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65937 === (4))){
var inst_65910 = (state_65936[(2)]);
var state_65936__$1 = state_65936;
var statearr_65940_65959 = state_65936__$1;
(statearr_65940_65959[(2)] = inst_65910);

(statearr_65940_65959[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65937 === (6))){
var state_65936__$1 = state_65936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65936__$1,(9),n);
} else {
if((state_val_65937 === (3))){
var inst_65934 = (state_65936[(2)]);
var state_65936__$1 = state_65936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65936__$1,inst_65934);
} else {
if((state_val_65937 === (2))){
var _ = (function (){var statearr_65942 = state_65936;
(statearr_65942[(4)] = cljs.core.cons((5),(state_65936[(4)])));

return statearr_65942;
})();
var inst_65916 = fluree.db.util.async.channel_QMARK_(n);
var state_65936__$1 = state_65936;
if(inst_65916){
var statearr_65943_65960 = state_65936__$1;
(statearr_65943_65960[(1)] = (6));

} else {
var statearr_65944_65961 = state_65936__$1;
(statearr_65944_65961[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65937 === (9))){
var inst_65919 = (state_65936[(2)]);
var inst_65920 = fluree.db.util.async.throw_err(inst_65919);
var state_65936__$1 = state_65936;
var statearr_65945_65962 = state_65936__$1;
(statearr_65945_65962[(2)] = inst_65920);

(statearr_65945_65962[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65937 === (5))){
var _ = (function (){var statearr_65946 = state_65936;
(statearr_65946[(4)] = cljs.core.rest((state_65936[(4)])));

return statearr_65946;
})();
var state_65936__$1 = state_65936;
var ex65941 = (state_65936__$1[(2)]);
var statearr_65947_65963 = state_65936__$1;
(statearr_65947_65963[(5)] = ex65941);


if((ex65941 instanceof Error)){
var statearr_65948_65964 = state_65936__$1;
(statearr_65948_65964[(1)] = (4));

(statearr_65948_65964[(5)] = null);

} else {
throw ex65941;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65937 === (8))){
var inst_65923 = (state_65936[(2)]);
var inst_65924 = fluree.db.dbfunctions.internal.dec(inst_65923);
var inst_65925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65926 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65927 = ["dec",inst_65923,inst_65924];
var inst_65928 = cljs.core.PersistentHashMap.fromArrays(inst_65926,inst_65927);
var inst_65929 = [inst_65928,(10)];
var inst_65930 = (new cljs.core.PersistentVector(null,2,(5),inst_65925,inst_65929,null));
var inst_65931 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65930);
var _ = (function (){var statearr_65949 = state_65936;
(statearr_65949[(4)] = cljs.core.rest((state_65936[(4)])));

return statearr_65949;
})();
var state_65936__$1 = (function (){var statearr_65950 = state_65936;
(statearr_65950[(7)] = inst_65931);

return statearr_65950;
})();
var statearr_65951_65965 = state_65936__$1;
(statearr_65951_65965[(2)] = inst_65924);

(statearr_65951_65965[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto____0 = (function (){
var statearr_65952 = [null,null,null,null,null,null,null,null];
(statearr_65952[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto__);

(statearr_65952[(1)] = (1));

return statearr_65952;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto____1 = (function (state_65936){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_65936);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e65953){var ex__10844__auto__ = e65953;
var statearr_65954_65966 = state_65936;
(statearr_65954_65966[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_65936[(4)]))){
var statearr_65955_65967 = state_65936;
(statearr_65955_65967[(1)] = cljs.core.first((state_65936[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__65968 = state_65936;
state_65936 = G__65968;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto__ = function(state_65936){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto____1.call(this,state_65936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_65956 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_65956[(6)] = c__10878__auto__);

return statearr_65956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66018 = arguments.length;
var i__4830__auto___66019 = (0);
while(true){
if((i__4830__auto___66019 < len__4829__auto___66018)){
args__4835__auto__.push((arguments[i__4830__auto___66019]));

var G__66020 = (i__4830__auto___66019 + (1));
i__4830__auto___66019 = G__66020;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66001){
var state_val_66002 = (state_66001[(1)]);
if((state_val_66002 === (1))){
var state_66001__$1 = state_66001;
var statearr_66003_66021 = state_66001__$1;
(statearr_66003_66021[(2)] = null);

(statearr_66003_66021[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66002 === (2))){
var _ = (function (){var statearr_66004 = state_66001;
(statearr_66004[(4)] = cljs.core.cons((5),(state_66001[(4)])));

return statearr_66004;
})();
var inst_65977 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66001__$1 = state_66001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66001__$1,(6),inst_65977);
} else {
if((state_val_66002 === (3))){
var inst_65999 = (state_66001[(2)]);
var state_66001__$1 = state_66001;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66001__$1,inst_65999);
} else {
if((state_val_66002 === (4))){
var inst_65971 = (state_66001[(2)]);
var state_66001__$1 = state_66001;
var statearr_66006_66022 = state_66001__$1;
(statearr_66006_66022[(2)] = inst_65971);

(statearr_66006_66022[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66002 === (5))){
var _ = (function (){var statearr_66007 = state_66001;
(statearr_66007[(4)] = cljs.core.rest((state_66001[(4)])));

return statearr_66007;
})();
var state_66001__$1 = state_66001;
var ex66005 = (state_66001__$1[(2)]);
var statearr_66008_66023 = state_66001__$1;
(statearr_66008_66023[(5)] = ex66005);


if((ex66005 instanceof Error)){
var statearr_66009_66024 = state_66001__$1;
(statearr_66009_66024[(1)] = (4));

(statearr_66009_66024[(5)] = null);

} else {
throw ex66005;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66002 === (6))){
var inst_65979 = (state_66001[(2)]);
var inst_65980 = fluree.db.util.async.throw_err(inst_65979);
var inst_65981 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_65980);
var inst_65982 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65983 = [inst_65980];
var inst_65984 = (new cljs.core.PersistentVector(null,1,(5),inst_65982,inst_65983,null));
var inst_65985 = cljs.core.count(inst_65984);
var inst_65986 = ((9) + inst_65985);
var inst_65987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65988 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65990 = [inst_65980];
var inst_65991 = (new cljs.core.PersistentVector(null,1,(5),inst_65989,inst_65990,null));
var inst_65992 = ["+",inst_65991,inst_65981];
var inst_65993 = cljs.core.PersistentHashMap.fromArrays(inst_65988,inst_65992);
var inst_65994 = [inst_65993,inst_65986];
var inst_65995 = (new cljs.core.PersistentVector(null,2,(5),inst_65987,inst_65994,null));
var inst_65996 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65995);
var _ = (function (){var statearr_66010 = state_66001;
(statearr_66010[(4)] = cljs.core.rest((state_66001[(4)])));

return statearr_66010;
})();
var state_66001__$1 = (function (){var statearr_66011 = state_66001;
(statearr_66011[(7)] = inst_65996);

return statearr_66011;
})();
var statearr_66012_66025 = state_66001__$1;
(statearr_66012_66025[(2)] = inst_65981);

(statearr_66012_66025[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_66013 = [null,null,null,null,null,null,null,null];
(statearr_66013[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_66013[(1)] = (1));

return statearr_66013;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_66001){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66001);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66014){var ex__10844__auto__ = e66014;
var statearr_66015_66026 = state_66001;
(statearr_66015_66026[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66001[(4)]))){
var statearr_66016_66027 = state_66001;
(statearr_66016_66027[(1)] = cljs.core.first((state_66001[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66028 = state_66001;
state_66001 = G__66028;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_66001){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_66001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66017 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66017[(6)] = c__10878__auto__);

return statearr_66017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq65969){
var G__65970 = cljs.core.first(seq65969);
var seq65969__$1 = cljs.core.next(seq65969);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65970,seq65969__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66078 = arguments.length;
var i__4830__auto___66079 = (0);
while(true){
if((i__4830__auto___66079 < len__4829__auto___66078)){
args__4835__auto__.push((arguments[i__4830__auto___66079]));

var G__66080 = (i__4830__auto___66079 + (1));
i__4830__auto___66079 = G__66080;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66061){
var state_val_66062 = (state_66061[(1)]);
if((state_val_66062 === (1))){
var state_66061__$1 = state_66061;
var statearr_66063_66081 = state_66061__$1;
(statearr_66063_66081[(2)] = null);

(statearr_66063_66081[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66062 === (2))){
var _ = (function (){var statearr_66064 = state_66061;
(statearr_66064[(4)] = cljs.core.cons((5),(state_66061[(4)])));

return statearr_66064;
})();
var inst_66037 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66061__$1 = state_66061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66061__$1,(6),inst_66037);
} else {
if((state_val_66062 === (3))){
var inst_66059 = (state_66061[(2)]);
var state_66061__$1 = state_66061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66061__$1,inst_66059);
} else {
if((state_val_66062 === (4))){
var inst_66031 = (state_66061[(2)]);
var state_66061__$1 = state_66061;
var statearr_66066_66082 = state_66061__$1;
(statearr_66066_66082[(2)] = inst_66031);

(statearr_66066_66082[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66062 === (5))){
var _ = (function (){var statearr_66067 = state_66061;
(statearr_66067[(4)] = cljs.core.rest((state_66061[(4)])));

return statearr_66067;
})();
var state_66061__$1 = state_66061;
var ex66065 = (state_66061__$1[(2)]);
var statearr_66068_66083 = state_66061__$1;
(statearr_66068_66083[(5)] = ex66065);


if((ex66065 instanceof Error)){
var statearr_66069_66084 = state_66061__$1;
(statearr_66069_66084[(1)] = (4));

(statearr_66069_66084[(5)] = null);

} else {
throw ex66065;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66062 === (6))){
var inst_66039 = (state_66061[(2)]);
var inst_66040 = fluree.db.util.async.throw_err(inst_66039);
var inst_66041 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_66040);
var inst_66042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66043 = [inst_66040];
var inst_66044 = (new cljs.core.PersistentVector(null,1,(5),inst_66042,inst_66043,null));
var inst_66045 = cljs.core.count(inst_66044);
var inst_66046 = ((9) + inst_66045);
var inst_66047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66048 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66050 = [inst_66040];
var inst_66051 = (new cljs.core.PersistentVector(null,1,(5),inst_66049,inst_66050,null));
var inst_66052 = ["-",inst_66051,inst_66041];
var inst_66053 = cljs.core.PersistentHashMap.fromArrays(inst_66048,inst_66052);
var inst_66054 = [inst_66053,inst_66046];
var inst_66055 = (new cljs.core.PersistentVector(null,2,(5),inst_66047,inst_66054,null));
var inst_66056 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66055);
var _ = (function (){var statearr_66070 = state_66061;
(statearr_66070[(4)] = cljs.core.rest((state_66061[(4)])));

return statearr_66070;
})();
var state_66061__$1 = (function (){var statearr_66071 = state_66061;
(statearr_66071[(7)] = inst_66056);

return statearr_66071;
})();
var statearr_66072_66085 = state_66061__$1;
(statearr_66072_66085[(2)] = inst_66041);

(statearr_66072_66085[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_66073 = [null,null,null,null,null,null,null,null];
(statearr_66073[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_66073[(1)] = (1));

return statearr_66073;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_66061){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66061);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66074){var ex__10844__auto__ = e66074;
var statearr_66075_66086 = state_66061;
(statearr_66075_66086[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66061[(4)]))){
var statearr_66076_66087 = state_66061;
(statearr_66076_66087[(1)] = cljs.core.first((state_66061[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66088 = state_66061;
state_66061 = G__66088;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_66061){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_66061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66077 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66077[(6)] = c__10878__auto__);

return statearr_66077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq66029){
var G__66030 = cljs.core.first(seq66029);
var seq66029__$1 = cljs.core.next(seq66029);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66030,seq66029__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66138 = arguments.length;
var i__4830__auto___66139 = (0);
while(true){
if((i__4830__auto___66139 < len__4829__auto___66138)){
args__4835__auto__.push((arguments[i__4830__auto___66139]));

var G__66140 = (i__4830__auto___66139 + (1));
i__4830__auto___66139 = G__66140;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66121){
var state_val_66122 = (state_66121[(1)]);
if((state_val_66122 === (1))){
var state_66121__$1 = state_66121;
var statearr_66123_66141 = state_66121__$1;
(statearr_66123_66141[(2)] = null);

(statearr_66123_66141[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66122 === (2))){
var _ = (function (){var statearr_66124 = state_66121;
(statearr_66124[(4)] = cljs.core.cons((5),(state_66121[(4)])));

return statearr_66124;
})();
var inst_66097 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66121__$1 = state_66121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66121__$1,(6),inst_66097);
} else {
if((state_val_66122 === (3))){
var inst_66119 = (state_66121[(2)]);
var state_66121__$1 = state_66121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66121__$1,inst_66119);
} else {
if((state_val_66122 === (4))){
var inst_66091 = (state_66121[(2)]);
var state_66121__$1 = state_66121;
var statearr_66126_66142 = state_66121__$1;
(statearr_66126_66142[(2)] = inst_66091);

(statearr_66126_66142[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66122 === (5))){
var _ = (function (){var statearr_66127 = state_66121;
(statearr_66127[(4)] = cljs.core.rest((state_66121[(4)])));

return statearr_66127;
})();
var state_66121__$1 = state_66121;
var ex66125 = (state_66121__$1[(2)]);
var statearr_66128_66143 = state_66121__$1;
(statearr_66128_66143[(5)] = ex66125);


if((ex66125 instanceof Error)){
var statearr_66129_66144 = state_66121__$1;
(statearr_66129_66144[(1)] = (4));

(statearr_66129_66144[(5)] = null);

} else {
throw ex66125;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66122 === (6))){
var inst_66099 = (state_66121[(2)]);
var inst_66100 = fluree.db.util.async.throw_err(inst_66099);
var inst_66101 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_66100);
var inst_66102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66103 = [inst_66100];
var inst_66104 = (new cljs.core.PersistentVector(null,1,(5),inst_66102,inst_66103,null));
var inst_66105 = cljs.core.count(inst_66104);
var inst_66106 = ((9) + inst_66105);
var inst_66107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66108 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66110 = [inst_66100];
var inst_66111 = (new cljs.core.PersistentVector(null,1,(5),inst_66109,inst_66110,null));
var inst_66112 = ["*",inst_66111,inst_66101];
var inst_66113 = cljs.core.PersistentHashMap.fromArrays(inst_66108,inst_66112);
var inst_66114 = [inst_66113,inst_66106];
var inst_66115 = (new cljs.core.PersistentVector(null,2,(5),inst_66107,inst_66114,null));
var inst_66116 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66115);
var _ = (function (){var statearr_66130 = state_66121;
(statearr_66130[(4)] = cljs.core.rest((state_66121[(4)])));

return statearr_66130;
})();
var state_66121__$1 = (function (){var statearr_66131 = state_66121;
(statearr_66131[(7)] = inst_66116);

return statearr_66131;
})();
var statearr_66132_66145 = state_66121__$1;
(statearr_66132_66145[(2)] = inst_66101);

(statearr_66132_66145[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_66133 = [null,null,null,null,null,null,null,null];
(statearr_66133[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_66133[(1)] = (1));

return statearr_66133;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_66121){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66121);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66134){var ex__10844__auto__ = e66134;
var statearr_66135_66146 = state_66121;
(statearr_66135_66146[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66121[(4)]))){
var statearr_66136_66147 = state_66121;
(statearr_66136_66147[(1)] = cljs.core.first((state_66121[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66148 = state_66121;
state_66121 = G__66148;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_66121){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_66121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66137 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66137[(6)] = c__10878__auto__);

return statearr_66137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq66089){
var G__66090 = cljs.core.first(seq66089);
var seq66089__$1 = cljs.core.next(seq66089);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66090,seq66089__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___66198 = arguments.length;
var i__4830__auto___66199 = (0);
while(true){
if((i__4830__auto___66199 < len__4829__auto___66198)){
args__4835__auto__.push((arguments[i__4830__auto___66199]));

var G__66200 = (i__4830__auto___66199 + (1));
i__4830__auto___66199 = G__66200;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66181){
var state_val_66182 = (state_66181[(1)]);
if((state_val_66182 === (1))){
var state_66181__$1 = state_66181;
var statearr_66183_66201 = state_66181__$1;
(statearr_66183_66201[(2)] = null);

(statearr_66183_66201[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66182 === (2))){
var _ = (function (){var statearr_66184 = state_66181;
(statearr_66184[(4)] = cljs.core.cons((5),(state_66181[(4)])));

return statearr_66184;
})();
var inst_66157 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66181__$1 = state_66181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66181__$1,(6),inst_66157);
} else {
if((state_val_66182 === (3))){
var inst_66179 = (state_66181[(2)]);
var state_66181__$1 = state_66181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66181__$1,inst_66179);
} else {
if((state_val_66182 === (4))){
var inst_66151 = (state_66181[(2)]);
var state_66181__$1 = state_66181;
var statearr_66186_66202 = state_66181__$1;
(statearr_66186_66202[(2)] = inst_66151);

(statearr_66186_66202[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66182 === (5))){
var _ = (function (){var statearr_66187 = state_66181;
(statearr_66187[(4)] = cljs.core.rest((state_66181[(4)])));

return statearr_66187;
})();
var state_66181__$1 = state_66181;
var ex66185 = (state_66181__$1[(2)]);
var statearr_66188_66203 = state_66181__$1;
(statearr_66188_66203[(5)] = ex66185);


if((ex66185 instanceof Error)){
var statearr_66189_66204 = state_66181__$1;
(statearr_66189_66204[(1)] = (4));

(statearr_66189_66204[(5)] = null);

} else {
throw ex66185;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66182 === (6))){
var inst_66159 = (state_66181[(2)]);
var inst_66160 = fluree.db.util.async.throw_err(inst_66159);
var inst_66161 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_66160);
var inst_66162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66163 = [inst_66160];
var inst_66164 = (new cljs.core.PersistentVector(null,1,(5),inst_66162,inst_66163,null));
var inst_66165 = cljs.core.count(inst_66164);
var inst_66166 = ((9) + inst_66165);
var inst_66167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66168 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66170 = [inst_66160];
var inst_66171 = (new cljs.core.PersistentVector(null,1,(5),inst_66169,inst_66170,null));
var inst_66172 = ["/",inst_66171,inst_66161];
var inst_66173 = cljs.core.PersistentHashMap.fromArrays(inst_66168,inst_66172);
var inst_66174 = [inst_66173,inst_66166];
var inst_66175 = (new cljs.core.PersistentVector(null,2,(5),inst_66167,inst_66174,null));
var inst_66176 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66175);
var _ = (function (){var statearr_66190 = state_66181;
(statearr_66190[(4)] = cljs.core.rest((state_66181[(4)])));

return statearr_66190;
})();
var state_66181__$1 = (function (){var statearr_66191 = state_66181;
(statearr_66191[(7)] = inst_66176);

return statearr_66191;
})();
var statearr_66192_66205 = state_66181__$1;
(statearr_66192_66205[(2)] = inst_66161);

(statearr_66192_66205[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_66193 = [null,null,null,null,null,null,null,null];
(statearr_66193[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_66193[(1)] = (1));

return statearr_66193;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_66181){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66181);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66194){var ex__10844__auto__ = e66194;
var statearr_66195_66206 = state_66181;
(statearr_66195_66206[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66181[(4)]))){
var statearr_66196_66207 = state_66181;
(statearr_66196_66207[(1)] = cljs.core.first((state_66181[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66208 = state_66181;
state_66181 = G__66208;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_66181){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_66181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66197 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66197[(6)] = c__10878__auto__);

return statearr_66197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq66149){
var G__66150 = cljs.core.first(seq66149);
var seq66149__$1 = cljs.core.next(seq66149);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66150,seq66149__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66246){
var state_val_66247 = (state_66246[(1)]);
if((state_val_66247 === (7))){
var state_66246__$1 = state_66246;
var statearr_66248_66272 = state_66246__$1;
(statearr_66248_66272[(2)] = n);

(statearr_66248_66272[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (1))){
var state_66246__$1 = state_66246;
var statearr_66249_66273 = state_66246__$1;
(statearr_66249_66273[(2)] = null);

(statearr_66249_66273[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (4))){
var inst_66209 = (state_66246[(2)]);
var state_66246__$1 = state_66246;
var statearr_66250_66274 = state_66246__$1;
(statearr_66250_66274[(2)] = inst_66209);

(statearr_66250_66274[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (13))){
var inst_66226 = (state_66246[(2)]);
var inst_66227 = fluree.db.util.async.throw_err(inst_66226);
var state_66246__$1 = state_66246;
var statearr_66251_66275 = state_66246__$1;
(statearr_66251_66275[(2)] = inst_66227);

(statearr_66251_66275[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (6))){
var state_66246__$1 = state_66246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66246__$1,(9),n);
} else {
if((state_val_66247 === (3))){
var inst_66244 = (state_66246[(2)]);
var state_66246__$1 = state_66246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66246__$1,inst_66244);
} else {
if((state_val_66247 === (12))){
var inst_66222 = (state_66246[(7)]);
var inst_66230 = (state_66246[(2)]);
var inst_66231 = fluree.db.dbfunctions.internal.quot(inst_66222,inst_66230);
var inst_66232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66233 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66235 = [inst_66222,inst_66230];
var inst_66236 = (new cljs.core.PersistentVector(null,2,(5),inst_66234,inst_66235,null));
var inst_66237 = ["quot",inst_66236,inst_66231];
var inst_66238 = cljs.core.PersistentHashMap.fromArrays(inst_66233,inst_66237);
var inst_66239 = [inst_66238,(2)];
var inst_66240 = (new cljs.core.PersistentVector(null,2,(5),inst_66232,inst_66239,null));
var inst_66241 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66240);
var _ = (function (){var statearr_66252 = state_66246;
(statearr_66252[(4)] = cljs.core.rest((state_66246[(4)])));

return statearr_66252;
})();
var state_66246__$1 = (function (){var statearr_66253 = state_66246;
(statearr_66253[(8)] = inst_66241);

return statearr_66253;
})();
var statearr_66254_66276 = state_66246__$1;
(statearr_66254_66276[(2)] = inst_66231);

(statearr_66254_66276[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (2))){
var _ = (function (){var statearr_66255 = state_66246;
(statearr_66255[(4)] = cljs.core.cons((5),(state_66246[(4)])));

return statearr_66255;
})();
var inst_66215 = fluree.db.util.async.channel_QMARK_(n);
var state_66246__$1 = state_66246;
if(inst_66215){
var statearr_66256_66277 = state_66246__$1;
(statearr_66256_66277[(1)] = (6));

} else {
var statearr_66257_66278 = state_66246__$1;
(statearr_66257_66278[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (11))){
var state_66246__$1 = state_66246;
var statearr_66259_66279 = state_66246__$1;
(statearr_66259_66279[(2)] = d);

(statearr_66259_66279[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (9))){
var inst_66218 = (state_66246[(2)]);
var inst_66219 = fluree.db.util.async.throw_err(inst_66218);
var state_66246__$1 = state_66246;
var statearr_66260_66280 = state_66246__$1;
(statearr_66260_66280[(2)] = inst_66219);

(statearr_66260_66280[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (5))){
var _ = (function (){var statearr_66261 = state_66246;
(statearr_66261[(4)] = cljs.core.rest((state_66246[(4)])));

return statearr_66261;
})();
var state_66246__$1 = state_66246;
var ex66258 = (state_66246__$1[(2)]);
var statearr_66262_66281 = state_66246__$1;
(statearr_66262_66281[(5)] = ex66258);


if((ex66258 instanceof Error)){
var statearr_66263_66282 = state_66246__$1;
(statearr_66263_66282[(1)] = (4));

(statearr_66263_66282[(5)] = null);

} else {
throw ex66258;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66247 === (10))){
var state_66246__$1 = state_66246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66246__$1,(13),d);
} else {
if((state_val_66247 === (8))){
var inst_66222 = (state_66246[(2)]);
var inst_66223 = fluree.db.util.async.channel_QMARK_(d);
var state_66246__$1 = (function (){var statearr_66264 = state_66246;
(statearr_66264[(7)] = inst_66222);

return statearr_66264;
})();
if(inst_66223){
var statearr_66265_66283 = state_66246__$1;
(statearr_66265_66283[(1)] = (10));

} else {
var statearr_66266_66284 = state_66246__$1;
(statearr_66266_66284[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto____0 = (function (){
var statearr_66267 = [null,null,null,null,null,null,null,null,null];
(statearr_66267[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto__);

(statearr_66267[(1)] = (1));

return statearr_66267;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto____1 = (function (state_66246){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66246);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66268){var ex__10844__auto__ = e66268;
var statearr_66269_66285 = state_66246;
(statearr_66269_66285[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66246[(4)]))){
var statearr_66270_66286 = state_66246;
(statearr_66270_66286[(1)] = cljs.core.first((state_66246[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66287 = state_66246;
state_66246 = G__66287;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto__ = function(state_66246){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto____1.call(this,state_66246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66271 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66271[(6)] = c__10878__auto__);

return statearr_66271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66325){
var state_val_66326 = (state_66325[(1)]);
if((state_val_66326 === (7))){
var state_66325__$1 = state_66325;
var statearr_66327_66351 = state_66325__$1;
(statearr_66327_66351[(2)] = n);

(statearr_66327_66351[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (1))){
var state_66325__$1 = state_66325;
var statearr_66328_66352 = state_66325__$1;
(statearr_66328_66352[(2)] = null);

(statearr_66328_66352[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (4))){
var inst_66288 = (state_66325[(2)]);
var state_66325__$1 = state_66325;
var statearr_66329_66353 = state_66325__$1;
(statearr_66329_66353[(2)] = inst_66288);

(statearr_66329_66353[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (13))){
var inst_66305 = (state_66325[(2)]);
var inst_66306 = fluree.db.util.async.throw_err(inst_66305);
var state_66325__$1 = state_66325;
var statearr_66330_66354 = state_66325__$1;
(statearr_66330_66354[(2)] = inst_66306);

(statearr_66330_66354[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (6))){
var state_66325__$1 = state_66325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66325__$1,(9),n);
} else {
if((state_val_66326 === (3))){
var inst_66323 = (state_66325[(2)]);
var state_66325__$1 = state_66325;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66325__$1,inst_66323);
} else {
if((state_val_66326 === (12))){
var inst_66301 = (state_66325[(7)]);
var inst_66309 = (state_66325[(2)]);
var inst_66310 = fluree.db.dbfunctions.internal.mod(inst_66301,inst_66309);
var inst_66311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66312 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66314 = [inst_66301,inst_66309];
var inst_66315 = (new cljs.core.PersistentVector(null,2,(5),inst_66313,inst_66314,null));
var inst_66316 = ["mod",inst_66315,inst_66310];
var inst_66317 = cljs.core.PersistentHashMap.fromArrays(inst_66312,inst_66316);
var inst_66318 = [inst_66317,(2)];
var inst_66319 = (new cljs.core.PersistentVector(null,2,(5),inst_66311,inst_66318,null));
var inst_66320 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66319);
var _ = (function (){var statearr_66331 = state_66325;
(statearr_66331[(4)] = cljs.core.rest((state_66325[(4)])));

return statearr_66331;
})();
var state_66325__$1 = (function (){var statearr_66332 = state_66325;
(statearr_66332[(8)] = inst_66320);

return statearr_66332;
})();
var statearr_66333_66355 = state_66325__$1;
(statearr_66333_66355[(2)] = inst_66310);

(statearr_66333_66355[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (2))){
var _ = (function (){var statearr_66334 = state_66325;
(statearr_66334[(4)] = cljs.core.cons((5),(state_66325[(4)])));

return statearr_66334;
})();
var inst_66294 = fluree.db.util.async.channel_QMARK_(n);
var state_66325__$1 = state_66325;
if(inst_66294){
var statearr_66335_66356 = state_66325__$1;
(statearr_66335_66356[(1)] = (6));

} else {
var statearr_66336_66357 = state_66325__$1;
(statearr_66336_66357[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (11))){
var state_66325__$1 = state_66325;
var statearr_66338_66358 = state_66325__$1;
(statearr_66338_66358[(2)] = d);

(statearr_66338_66358[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (9))){
var inst_66297 = (state_66325[(2)]);
var inst_66298 = fluree.db.util.async.throw_err(inst_66297);
var state_66325__$1 = state_66325;
var statearr_66339_66359 = state_66325__$1;
(statearr_66339_66359[(2)] = inst_66298);

(statearr_66339_66359[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (5))){
var _ = (function (){var statearr_66340 = state_66325;
(statearr_66340[(4)] = cljs.core.rest((state_66325[(4)])));

return statearr_66340;
})();
var state_66325__$1 = state_66325;
var ex66337 = (state_66325__$1[(2)]);
var statearr_66341_66360 = state_66325__$1;
(statearr_66341_66360[(5)] = ex66337);


if((ex66337 instanceof Error)){
var statearr_66342_66361 = state_66325__$1;
(statearr_66342_66361[(1)] = (4));

(statearr_66342_66361[(5)] = null);

} else {
throw ex66337;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66326 === (10))){
var state_66325__$1 = state_66325;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66325__$1,(13),d);
} else {
if((state_val_66326 === (8))){
var inst_66301 = (state_66325[(2)]);
var inst_66302 = fluree.db.util.async.channel_QMARK_(d);
var state_66325__$1 = (function (){var statearr_66343 = state_66325;
(statearr_66343[(7)] = inst_66301);

return statearr_66343;
})();
if(inst_66302){
var statearr_66344_66362 = state_66325__$1;
(statearr_66344_66362[(1)] = (10));

} else {
var statearr_66345_66363 = state_66325__$1;
(statearr_66345_66363[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto____0 = (function (){
var statearr_66346 = [null,null,null,null,null,null,null,null,null];
(statearr_66346[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto__);

(statearr_66346[(1)] = (1));

return statearr_66346;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto____1 = (function (state_66325){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66325);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66347){var ex__10844__auto__ = e66347;
var statearr_66348_66364 = state_66325;
(statearr_66348_66364[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66325[(4)]))){
var statearr_66349_66365 = state_66325;
(statearr_66349_66365[(1)] = cljs.core.first((state_66325[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66366 = state_66325;
state_66325 = G__66366;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto__ = function(state_66325){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto____1.call(this,state_66325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66350 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66350[(6)] = c__10878__auto__);

return statearr_66350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66404){
var state_val_66405 = (state_66404[(1)]);
if((state_val_66405 === (7))){
var state_66404__$1 = state_66404;
var statearr_66406_66430 = state_66404__$1;
(statearr_66406_66430[(2)] = n);

(statearr_66406_66430[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (1))){
var state_66404__$1 = state_66404;
var statearr_66407_66431 = state_66404__$1;
(statearr_66407_66431[(2)] = null);

(statearr_66407_66431[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (4))){
var inst_66367 = (state_66404[(2)]);
var state_66404__$1 = state_66404;
var statearr_66408_66432 = state_66404__$1;
(statearr_66408_66432[(2)] = inst_66367);

(statearr_66408_66432[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (13))){
var inst_66384 = (state_66404[(2)]);
var inst_66385 = fluree.db.util.async.throw_err(inst_66384);
var state_66404__$1 = state_66404;
var statearr_66409_66433 = state_66404__$1;
(statearr_66409_66433[(2)] = inst_66385);

(statearr_66409_66433[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (6))){
var state_66404__$1 = state_66404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66404__$1,(9),n);
} else {
if((state_val_66405 === (3))){
var inst_66402 = (state_66404[(2)]);
var state_66404__$1 = state_66404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66404__$1,inst_66402);
} else {
if((state_val_66405 === (12))){
var inst_66380 = (state_66404[(7)]);
var inst_66388 = (state_66404[(2)]);
var inst_66389 = fluree.db.dbfunctions.internal.rem(inst_66380,inst_66388);
var inst_66390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66391 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66393 = [inst_66380,inst_66388];
var inst_66394 = (new cljs.core.PersistentVector(null,2,(5),inst_66392,inst_66393,null));
var inst_66395 = ["rem",inst_66394,inst_66389];
var inst_66396 = cljs.core.PersistentHashMap.fromArrays(inst_66391,inst_66395);
var inst_66397 = [inst_66396,(2)];
var inst_66398 = (new cljs.core.PersistentVector(null,2,(5),inst_66390,inst_66397,null));
var inst_66399 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66398);
var _ = (function (){var statearr_66410 = state_66404;
(statearr_66410[(4)] = cljs.core.rest((state_66404[(4)])));

return statearr_66410;
})();
var state_66404__$1 = (function (){var statearr_66411 = state_66404;
(statearr_66411[(8)] = inst_66399);

return statearr_66411;
})();
var statearr_66412_66434 = state_66404__$1;
(statearr_66412_66434[(2)] = inst_66389);

(statearr_66412_66434[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (2))){
var _ = (function (){var statearr_66413 = state_66404;
(statearr_66413[(4)] = cljs.core.cons((5),(state_66404[(4)])));

return statearr_66413;
})();
var inst_66373 = fluree.db.util.async.channel_QMARK_(n);
var state_66404__$1 = state_66404;
if(inst_66373){
var statearr_66414_66435 = state_66404__$1;
(statearr_66414_66435[(1)] = (6));

} else {
var statearr_66415_66436 = state_66404__$1;
(statearr_66415_66436[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (11))){
var state_66404__$1 = state_66404;
var statearr_66417_66437 = state_66404__$1;
(statearr_66417_66437[(2)] = d);

(statearr_66417_66437[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (9))){
var inst_66376 = (state_66404[(2)]);
var inst_66377 = fluree.db.util.async.throw_err(inst_66376);
var state_66404__$1 = state_66404;
var statearr_66418_66438 = state_66404__$1;
(statearr_66418_66438[(2)] = inst_66377);

(statearr_66418_66438[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (5))){
var _ = (function (){var statearr_66419 = state_66404;
(statearr_66419[(4)] = cljs.core.rest((state_66404[(4)])));

return statearr_66419;
})();
var state_66404__$1 = state_66404;
var ex66416 = (state_66404__$1[(2)]);
var statearr_66420_66439 = state_66404__$1;
(statearr_66420_66439[(5)] = ex66416);


if((ex66416 instanceof Error)){
var statearr_66421_66440 = state_66404__$1;
(statearr_66421_66440[(1)] = (4));

(statearr_66421_66440[(5)] = null);

} else {
throw ex66416;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66405 === (10))){
var state_66404__$1 = state_66404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66404__$1,(13),d);
} else {
if((state_val_66405 === (8))){
var inst_66380 = (state_66404[(2)]);
var inst_66381 = fluree.db.util.async.channel_QMARK_(d);
var state_66404__$1 = (function (){var statearr_66422 = state_66404;
(statearr_66422[(7)] = inst_66380);

return statearr_66422;
})();
if(inst_66381){
var statearr_66423_66441 = state_66404__$1;
(statearr_66423_66441[(1)] = (10));

} else {
var statearr_66424_66442 = state_66404__$1;
(statearr_66424_66442[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto____0 = (function (){
var statearr_66425 = [null,null,null,null,null,null,null,null,null];
(statearr_66425[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto__);

(statearr_66425[(1)] = (1));

return statearr_66425;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto____1 = (function (state_66404){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66404);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66426){var ex__10844__auto__ = e66426;
var statearr_66427_66443 = state_66404;
(statearr_66427_66443[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66404[(4)]))){
var statearr_66428_66444 = state_66404;
(statearr_66428_66444[(1)] = cljs.core.first((state_66404[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66445 = state_66404;
state_66404 = G__66445;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto__ = function(state_66404){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto____1.call(this,state_66404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66429 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66429[(6)] = c__10878__auto__);

return statearr_66429;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66472){
var state_val_66473 = (state_66472[(1)]);
if((state_val_66473 === (7))){
var state_66472__$1 = state_66472;
var statearr_66474_66493 = state_66472__$1;
(statearr_66474_66493[(2)] = x);

(statearr_66474_66493[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66473 === (1))){
var state_66472__$1 = state_66472;
var statearr_66475_66494 = state_66472__$1;
(statearr_66475_66494[(2)] = null);

(statearr_66475_66494[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66473 === (4))){
var inst_66446 = (state_66472[(2)]);
var state_66472__$1 = state_66472;
var statearr_66476_66495 = state_66472__$1;
(statearr_66476_66495[(2)] = inst_66446);

(statearr_66476_66495[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66473 === (6))){
var state_66472__$1 = state_66472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66472__$1,(9),x);
} else {
if((state_val_66473 === (3))){
var inst_66470 = (state_66472[(2)]);
var state_66472__$1 = state_66472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66472__$1,inst_66470);
} else {
if((state_val_66473 === (2))){
var _ = (function (){var statearr_66478 = state_66472;
(statearr_66478[(4)] = cljs.core.cons((5),(state_66472[(4)])));

return statearr_66478;
})();
var inst_66452 = fluree.db.util.async.channel_QMARK_(x);
var state_66472__$1 = state_66472;
if(inst_66452){
var statearr_66479_66496 = state_66472__$1;
(statearr_66479_66496[(1)] = (6));

} else {
var statearr_66480_66497 = state_66472__$1;
(statearr_66480_66497[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66473 === (9))){
var inst_66455 = (state_66472[(2)]);
var inst_66456 = fluree.db.util.async.throw_err(inst_66455);
var state_66472__$1 = state_66472;
var statearr_66481_66498 = state_66472__$1;
(statearr_66481_66498[(2)] = inst_66456);

(statearr_66481_66498[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66473 === (5))){
var _ = (function (){var statearr_66482 = state_66472;
(statearr_66482[(4)] = cljs.core.rest((state_66472[(4)])));

return statearr_66482;
})();
var state_66472__$1 = state_66472;
var ex66477 = (state_66472__$1[(2)]);
var statearr_66483_66499 = state_66472__$1;
(statearr_66483_66499[(5)] = ex66477);


if((ex66477 instanceof Error)){
var statearr_66484_66500 = state_66472__$1;
(statearr_66484_66500[(1)] = (4));

(statearr_66484_66500[(5)] = null);

} else {
throw ex66477;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66473 === (8))){
var inst_66459 = (state_66472[(2)]);
var inst_66460 = fluree.db.dbfunctions.internal.boolean$(inst_66459);
var inst_66461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66462 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66463 = ["boolean",inst_66459,inst_66460];
var inst_66464 = cljs.core.PersistentHashMap.fromArrays(inst_66462,inst_66463);
var inst_66465 = [inst_66464,(10)];
var inst_66466 = (new cljs.core.PersistentVector(null,2,(5),inst_66461,inst_66465,null));
var inst_66467 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66466);
var _ = (function (){var statearr_66485 = state_66472;
(statearr_66485[(4)] = cljs.core.rest((state_66472[(4)])));

return statearr_66485;
})();
var state_66472__$1 = (function (){var statearr_66486 = state_66472;
(statearr_66486[(7)] = inst_66467);

return statearr_66486;
})();
var statearr_66487_66501 = state_66472__$1;
(statearr_66487_66501[(2)] = inst_66460);

(statearr_66487_66501[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto____0 = (function (){
var statearr_66488 = [null,null,null,null,null,null,null,null];
(statearr_66488[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto__);

(statearr_66488[(1)] = (1));

return statearr_66488;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto____1 = (function (state_66472){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66472);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66489){var ex__10844__auto__ = e66489;
var statearr_66490_66502 = state_66472;
(statearr_66490_66502[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66472[(4)]))){
var statearr_66491_66503 = state_66472;
(statearr_66491_66503[(1)] = cljs.core.first((state_66472[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66504 = state_66472;
state_66472 = G__66504;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto__ = function(state_66472){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto____1.call(this,state_66472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66492 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66492[(6)] = c__10878__auto__);

return statearr_66492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66542){
var state_val_66543 = (state_66542[(1)]);
if((state_val_66543 === (7))){
var state_66542__$1 = state_66542;
var statearr_66544_66568 = state_66542__$1;
(statearr_66544_66568[(2)] = pattern);

(statearr_66544_66568[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (1))){
var state_66542__$1 = state_66542;
var statearr_66545_66569 = state_66542__$1;
(statearr_66545_66569[(2)] = null);

(statearr_66545_66569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (4))){
var inst_66505 = (state_66542[(2)]);
var state_66542__$1 = state_66542;
var statearr_66546_66570 = state_66542__$1;
(statearr_66546_66570[(2)] = inst_66505);

(statearr_66546_66570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (13))){
var inst_66522 = (state_66542[(2)]);
var inst_66523 = fluree.db.util.async.throw_err(inst_66522);
var state_66542__$1 = state_66542;
var statearr_66547_66571 = state_66542__$1;
(statearr_66547_66571[(2)] = inst_66523);

(statearr_66547_66571[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (6))){
var state_66542__$1 = state_66542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66542__$1,(9),pattern);
} else {
if((state_val_66543 === (3))){
var inst_66540 = (state_66542[(2)]);
var state_66542__$1 = state_66542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66542__$1,inst_66540);
} else {
if((state_val_66543 === (12))){
var inst_66518 = (state_66542[(7)]);
var inst_66526 = (state_66542[(2)]);
var inst_66527 = fluree.db.dbfunctions.internal.re_find(inst_66518,inst_66526);
var inst_66528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66529 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66531 = [inst_66518,inst_66526];
var inst_66532 = (new cljs.core.PersistentVector(null,2,(5),inst_66530,inst_66531,null));
var inst_66533 = ["re-find",inst_66532,inst_66527];
var inst_66534 = cljs.core.PersistentHashMap.fromArrays(inst_66529,inst_66533);
var inst_66535 = [inst_66534,(10)];
var inst_66536 = (new cljs.core.PersistentVector(null,2,(5),inst_66528,inst_66535,null));
var inst_66537 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66536);
var _ = (function (){var statearr_66548 = state_66542;
(statearr_66548[(4)] = cljs.core.rest((state_66542[(4)])));

return statearr_66548;
})();
var state_66542__$1 = (function (){var statearr_66549 = state_66542;
(statearr_66549[(8)] = inst_66537);

return statearr_66549;
})();
var statearr_66550_66572 = state_66542__$1;
(statearr_66550_66572[(2)] = inst_66527);

(statearr_66550_66572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (2))){
var _ = (function (){var statearr_66551 = state_66542;
(statearr_66551[(4)] = cljs.core.cons((5),(state_66542[(4)])));

return statearr_66551;
})();
var inst_66511 = fluree.db.util.async.channel_QMARK_(pattern);
var state_66542__$1 = state_66542;
if(inst_66511){
var statearr_66552_66573 = state_66542__$1;
(statearr_66552_66573[(1)] = (6));

} else {
var statearr_66553_66574 = state_66542__$1;
(statearr_66553_66574[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (11))){
var state_66542__$1 = state_66542;
var statearr_66555_66575 = state_66542__$1;
(statearr_66555_66575[(2)] = string);

(statearr_66555_66575[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (9))){
var inst_66514 = (state_66542[(2)]);
var inst_66515 = fluree.db.util.async.throw_err(inst_66514);
var state_66542__$1 = state_66542;
var statearr_66556_66576 = state_66542__$1;
(statearr_66556_66576[(2)] = inst_66515);

(statearr_66556_66576[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (5))){
var _ = (function (){var statearr_66557 = state_66542;
(statearr_66557[(4)] = cljs.core.rest((state_66542[(4)])));

return statearr_66557;
})();
var state_66542__$1 = state_66542;
var ex66554 = (state_66542__$1[(2)]);
var statearr_66558_66577 = state_66542__$1;
(statearr_66558_66577[(5)] = ex66554);


if((ex66554 instanceof Error)){
var statearr_66559_66578 = state_66542__$1;
(statearr_66559_66578[(1)] = (4));

(statearr_66559_66578[(5)] = null);

} else {
throw ex66554;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66543 === (10))){
var state_66542__$1 = state_66542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66542__$1,(13),string);
} else {
if((state_val_66543 === (8))){
var inst_66518 = (state_66542[(2)]);
var inst_66519 = fluree.db.util.async.channel_QMARK_(string);
var state_66542__$1 = (function (){var statearr_66560 = state_66542;
(statearr_66560[(7)] = inst_66518);

return statearr_66560;
})();
if(inst_66519){
var statearr_66561_66579 = state_66542__$1;
(statearr_66561_66579[(1)] = (10));

} else {
var statearr_66562_66580 = state_66542__$1;
(statearr_66562_66580[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto____0 = (function (){
var statearr_66563 = [null,null,null,null,null,null,null,null,null];
(statearr_66563[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto__);

(statearr_66563[(1)] = (1));

return statearr_66563;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto____1 = (function (state_66542){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66542);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66564){var ex__10844__auto__ = e66564;
var statearr_66565_66581 = state_66542;
(statearr_66565_66581[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66542[(4)]))){
var statearr_66566_66582 = state_66542;
(statearr_66566_66582[(1)] = cljs.core.first((state_66542[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66583 = state_66542;
state_66542 = G__66583;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto__ = function(state_66542){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto____1.call(this,state_66542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66567 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66567[(6)] = c__10878__auto__);

return statearr_66567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66610){
var state_val_66611 = (state_66610[(1)]);
if((state_val_66611 === (7))){
var state_66610__$1 = state_66610;
var statearr_66612_66631 = state_66610__$1;
(statearr_66612_66631[(2)] = email);

(statearr_66612_66631[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66611 === (1))){
var state_66610__$1 = state_66610;
var statearr_66613_66632 = state_66610__$1;
(statearr_66613_66632[(2)] = null);

(statearr_66613_66632[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66611 === (4))){
var inst_66584 = (state_66610[(2)]);
var state_66610__$1 = state_66610;
var statearr_66614_66633 = state_66610__$1;
(statearr_66614_66633[(2)] = inst_66584);

(statearr_66614_66633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66611 === (6))){
var state_66610__$1 = state_66610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66610__$1,(9),email);
} else {
if((state_val_66611 === (3))){
var inst_66608 = (state_66610[(2)]);
var state_66610__$1 = state_66610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66610__$1,inst_66608);
} else {
if((state_val_66611 === (2))){
var _ = (function (){var statearr_66616 = state_66610;
(statearr_66616[(4)] = cljs.core.cons((5),(state_66610[(4)])));

return statearr_66616;
})();
var inst_66590 = fluree.db.util.async.channel_QMARK_(email);
var state_66610__$1 = state_66610;
if(inst_66590){
var statearr_66617_66634 = state_66610__$1;
(statearr_66617_66634[(1)] = (6));

} else {
var statearr_66618_66635 = state_66610__$1;
(statearr_66618_66635[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66611 === (9))){
var inst_66593 = (state_66610[(2)]);
var inst_66594 = fluree.db.util.async.throw_err(inst_66593);
var state_66610__$1 = state_66610;
var statearr_66619_66636 = state_66610__$1;
(statearr_66619_66636[(2)] = inst_66594);

(statearr_66619_66636[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66611 === (5))){
var _ = (function (){var statearr_66620 = state_66610;
(statearr_66620[(4)] = cljs.core.rest((state_66610[(4)])));

return statearr_66620;
})();
var state_66610__$1 = state_66610;
var ex66615 = (state_66610__$1[(2)]);
var statearr_66621_66637 = state_66610__$1;
(statearr_66621_66637[(5)] = ex66615);


if((ex66615 instanceof Error)){
var statearr_66622_66638 = state_66610__$1;
(statearr_66622_66638[(1)] = (4));

(statearr_66622_66638[(5)] = null);

} else {
throw ex66615;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66611 === (8))){
var inst_66597 = (state_66610[(2)]);
var inst_66598 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_66597);
var inst_66599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66600 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66601 = ["re-find",inst_66597,inst_66598];
var inst_66602 = cljs.core.PersistentHashMap.fromArrays(inst_66600,inst_66601);
var inst_66603 = [inst_66602,(10)];
var inst_66604 = (new cljs.core.PersistentVector(null,2,(5),inst_66599,inst_66603,null));
var inst_66605 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66604);
var _ = (function (){var statearr_66623 = state_66610;
(statearr_66623[(4)] = cljs.core.rest((state_66610[(4)])));

return statearr_66623;
})();
var state_66610__$1 = (function (){var statearr_66624 = state_66610;
(statearr_66624[(7)] = inst_66605);

return statearr_66624;
})();
var statearr_66625_66639 = state_66610__$1;
(statearr_66625_66639[(2)] = inst_66598);

(statearr_66625_66639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto____0 = (function (){
var statearr_66626 = [null,null,null,null,null,null,null,null];
(statearr_66626[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto__);

(statearr_66626[(1)] = (1));

return statearr_66626;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto____1 = (function (state_66610){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66610);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66627){var ex__10844__auto__ = e66627;
var statearr_66628_66640 = state_66610;
(statearr_66628_66640[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66610[(4)]))){
var statearr_66629_66641 = state_66610;
(statearr_66629_66641[(1)] = cljs.core.first((state_66610[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66642 = state_66610;
state_66610 = G__66642;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto__ = function(state_66610){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto____1.call(this,state_66610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66630 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66630[(6)] = c__10878__auto__);

return statearr_66630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66689){
var state_val_66690 = (state_66689[(1)]);
if((state_val_66690 === (7))){
var inst_66659 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66689__$1 = state_66689;
if(cljs.core.truth_(inst_66659)){
var statearr_66691_66718 = state_66689__$1;
(statearr_66691_66718[(1)] = (9));

} else {
var statearr_66692_66719 = state_66689__$1;
(statearr_66692_66719[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (1))){
var state_66689__$1 = state_66689;
var statearr_66693_66720 = state_66689__$1;
(statearr_66693_66720[(2)] = null);

(statearr_66693_66720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (4))){
var inst_66643 = (state_66689[(2)]);
var state_66689__$1 = state_66689;
var statearr_66694_66721 = state_66689__$1;
(statearr_66694_66721[(2)] = inst_66643);

(statearr_66694_66721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (15))){
var inst_66670 = (state_66689[(2)]);
var state_66689__$1 = state_66689;
var statearr_66695_66722 = state_66689__$1;
(statearr_66695_66722[(2)] = inst_66670);

(statearr_66695_66722[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (13))){
var inst_66667 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_66689__$1 = state_66689;
var statearr_66696_66723 = state_66689__$1;
(statearr_66696_66723[(2)] = inst_66667);

(statearr_66696_66723[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (6))){
var inst_66654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66655 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66656 = [inst_66655,(0)];
var inst_66657 = (new cljs.core.PersistentVector(null,2,(5),inst_66654,inst_66656,null));
var state_66689__$1 = state_66689;
var statearr_66697_66724 = state_66689__$1;
(statearr_66697_66724[(2)] = inst_66657);

(statearr_66697_66724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (3))){
var inst_66687 = (state_66689[(2)]);
var state_66689__$1 = state_66689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66689__$1,inst_66687);
} else {
if((state_val_66690 === (12))){
var inst_66663 = (state_66689[(2)]);
var inst_66664 = fluree.db.util.async.throw_err(inst_66663);
var state_66689__$1 = state_66689;
var statearr_66698_66725 = state_66689__$1;
(statearr_66698_66725[(2)] = inst_66664);

(statearr_66698_66725[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (2))){
var _ = (function (){var statearr_66699 = state_66689;
(statearr_66699[(4)] = cljs.core.cons((5),(state_66689[(4)])));

return statearr_66699;
})();
var inst_66652 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66689__$1 = state_66689;
if(cljs.core.truth_(inst_66652)){
var statearr_66700_66726 = state_66689__$1;
(statearr_66700_66726[(1)] = (6));

} else {
var statearr_66701_66727 = state_66689__$1;
(statearr_66701_66727[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (11))){
var inst_66672 = (state_66689[(2)]);
var state_66689__$1 = state_66689;
var statearr_66703_66728 = state_66689__$1;
(statearr_66703_66728[(2)] = inst_66672);

(statearr_66703_66728[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (9))){
var inst_66661 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_66689__$1 = state_66689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66689__$1,(12),inst_66661);
} else {
if((state_val_66690 === (5))){
var _ = (function (){var statearr_66704 = state_66689;
(statearr_66704[(4)] = cljs.core.rest((state_66689[(4)])));

return statearr_66704;
})();
var state_66689__$1 = state_66689;
var ex66702 = (state_66689__$1[(2)]);
var statearr_66705_66729 = state_66689__$1;
(statearr_66705_66729[(5)] = ex66702);


if((ex66702 instanceof Error)){
var statearr_66706_66730 = state_66689__$1;
(statearr_66706_66730[(1)] = (4));

(statearr_66706_66730[(5)] = null);

} else {
throw ex66702;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (14))){
var state_66689__$1 = state_66689;
var statearr_66707_66731 = state_66689__$1;
(statearr_66707_66731[(2)] = null);

(statearr_66707_66731[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (10))){
var state_66689__$1 = state_66689;
var statearr_66708_66732 = state_66689__$1;
(statearr_66708_66732[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_66690 === (8))){
var inst_66674 = (state_66689[(2)]);
var inst_66675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66674,(0),null);
var inst_66676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66674,(1),null);
var inst_66677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66678 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66679 = ["?user_id","?ctx",inst_66675];
var inst_66680 = cljs.core.PersistentHashMap.fromArrays(inst_66678,inst_66679);
var inst_66681 = ((10) + inst_66676);
var inst_66682 = [inst_66680,inst_66681];
var inst_66683 = (new cljs.core.PersistentVector(null,2,(5),inst_66677,inst_66682,null));
var inst_66684 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66683);
var _ = (function (){var statearr_66710 = state_66689;
(statearr_66710[(4)] = cljs.core.rest((state_66689[(4)])));

return statearr_66710;
})();
var state_66689__$1 = (function (){var statearr_66711 = state_66689;
(statearr_66711[(7)] = inst_66684);

return statearr_66711;
})();
var statearr_66712_66733 = state_66689__$1;
(statearr_66712_66733[(2)] = inst_66675);

(statearr_66712_66733[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto____0 = (function (){
var statearr_66713 = [null,null,null,null,null,null,null,null];
(statearr_66713[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto__);

(statearr_66713[(1)] = (1));

return statearr_66713;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto____1 = (function (state_66689){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66689);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66714){var ex__10844__auto__ = e66714;
var statearr_66715_66734 = state_66689;
(statearr_66715_66734[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66689[(4)]))){
var statearr_66716_66735 = state_66689;
(statearr_66716_66735[(1)] = cljs.core.first((state_66689[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66736 = state_66689;
state_66689 = G__66736;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto__ = function(state_66689){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto____1.call(this,state_66689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66717 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66717[(6)] = c__10878__auto__);

return statearr_66717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66764){
var state_val_66765 = (state_66764[(1)]);
if((state_val_66765 === (7))){
var inst_66757 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_66764__$1 = state_66764;
var statearr_66766_66785 = state_66764__$1;
(statearr_66766_66785[(2)] = inst_66757);

(statearr_66766_66785[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66765 === (1))){
var state_66764__$1 = state_66764;
var statearr_66767_66786 = state_66764__$1;
(statearr_66767_66786[(2)] = null);

(statearr_66767_66786[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66765 === (4))){
var inst_66737 = (state_66764[(2)]);
var state_66764__$1 = state_66764;
var statearr_66768_66787 = state_66764__$1;
(statearr_66768_66787[(2)] = inst_66737);

(statearr_66768_66787[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66765 === (6))){
var inst_66745 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_66764__$1 = state_66764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66764__$1,(9),inst_66745);
} else {
if((state_val_66765 === (3))){
var inst_66762 = (state_66764[(2)]);
var state_66764__$1 = state_66764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66764__$1,inst_66762);
} else {
if((state_val_66765 === (2))){
var _ = (function (){var statearr_66770 = state_66764;
(statearr_66770[(4)] = cljs.core.cons((5),(state_66764[(4)])));

return statearr_66770;
})();
var inst_66743 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_66764__$1 = state_66764;
if(cljs.core.truth_(inst_66743)){
var statearr_66771_66788 = state_66764__$1;
(statearr_66771_66788[(1)] = (6));

} else {
var statearr_66772_66789 = state_66764__$1;
(statearr_66772_66789[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66765 === (9))){
var inst_66747 = (state_66764[(2)]);
var inst_66748 = fluree.db.util.async.throw_err(inst_66747);
var inst_66749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66750 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66751 = ["?auth_id","?ctx",inst_66748];
var inst_66752 = cljs.core.PersistentHashMap.fromArrays(inst_66750,inst_66751);
var inst_66753 = [inst_66752,(10)];
var inst_66754 = (new cljs.core.PersistentVector(null,2,(5),inst_66749,inst_66753,null));
var inst_66755 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66754);
var state_66764__$1 = (function (){var statearr_66773 = state_66764;
(statearr_66773[(7)] = inst_66755);

return statearr_66773;
})();
var statearr_66774_66790 = state_66764__$1;
(statearr_66774_66790[(2)] = inst_66748);

(statearr_66774_66790[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66765 === (5))){
var _ = (function (){var statearr_66775 = state_66764;
(statearr_66775[(4)] = cljs.core.rest((state_66764[(4)])));

return statearr_66775;
})();
var state_66764__$1 = state_66764;
var ex66769 = (state_66764__$1[(2)]);
var statearr_66776_66791 = state_66764__$1;
(statearr_66776_66791[(5)] = ex66769);


if((ex66769 instanceof Error)){
var statearr_66777_66792 = state_66764__$1;
(statearr_66777_66792[(1)] = (4));

(statearr_66777_66792[(5)] = null);

} else {
throw ex66769;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66765 === (8))){
var inst_66759 = (state_66764[(2)]);
var _ = (function (){var statearr_66778 = state_66764;
(statearr_66778[(4)] = cljs.core.rest((state_66764[(4)])));

return statearr_66778;
})();
var state_66764__$1 = state_66764;
var statearr_66779_66793 = state_66764__$1;
(statearr_66779_66793[(2)] = inst_66759);

(statearr_66779_66793[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto____0 = (function (){
var statearr_66780 = [null,null,null,null,null,null,null,null];
(statearr_66780[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto__);

(statearr_66780[(1)] = (1));

return statearr_66780;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto____1 = (function (state_66764){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66764);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66781){var ex__10844__auto__ = e66781;
var statearr_66782_66794 = state_66764;
(statearr_66782_66794[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66764[(4)]))){
var statearr_66783_66795 = state_66764;
(statearr_66783_66795[(1)] = cljs.core.first((state_66764[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66796 = state_66764;
state_66764 = G__66796;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto__ = function(state_66764){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto____1.call(this,state_66764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66784 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66784[(6)] = c__10878__auto__);

return statearr_66784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__66798 = arguments.length;
switch (G__66798) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66840){
var state_val_66841 = (state_66840[(1)]);
if((state_val_66841 === (7))){
var state_66840__$1 = state_66840;
var statearr_66842_66872 = state_66840__$1;
(statearr_66842_66872[(2)] = seed);

(statearr_66842_66872[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (1))){
var state_66840__$1 = state_66840;
var statearr_66843_66873 = state_66840__$1;
(statearr_66843_66873[(2)] = null);

(statearr_66843_66873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (4))){
var inst_66799 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66844_66874 = state_66840__$1;
(statearr_66844_66874[(2)] = inst_66799);

(statearr_66844_66874[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (15))){
var state_66840__$1 = state_66840;
var statearr_66845_66875 = state_66840__$1;
(statearr_66845_66875[(2)] = (10));

(statearr_66845_66875[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (13))){
var inst_66816 = (state_66840[(2)]);
var inst_66817 = fluree.db.util.async.throw_err(inst_66816);
var state_66840__$1 = state_66840;
var statearr_66846_66876 = state_66840__$1;
(statearr_66846_66876[(2)] = inst_66817);

(statearr_66846_66876[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (6))){
var state_66840__$1 = state_66840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66840__$1,(9),seed);
} else {
if((state_val_66841 === (3))){
var inst_66838 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66840__$1,inst_66838);
} else {
if((state_val_66841 === (12))){
var inst_66820 = (state_66840[(7)]);
var inst_66820__$1 = (state_66840[(2)]);
var state_66840__$1 = (function (){var statearr_66847 = state_66840;
(statearr_66847[(7)] = inst_66820__$1);

return statearr_66847;
})();
if(cljs.core.truth_(inst_66820__$1)){
var statearr_66848_66877 = state_66840__$1;
(statearr_66848_66877[(1)] = (14));

} else {
var statearr_66849_66878 = state_66840__$1;
(statearr_66849_66878[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (2))){
var _ = (function (){var statearr_66850 = state_66840;
(statearr_66850[(4)] = cljs.core.cons((5),(state_66840[(4)])));

return statearr_66850;
})();
var inst_66805 = fluree.db.util.async.channel_QMARK_(seed);
var state_66840__$1 = state_66840;
if(inst_66805){
var statearr_66851_66879 = state_66840__$1;
(statearr_66851_66879[(1)] = (6));

} else {
var statearr_66852_66880 = state_66840__$1;
(statearr_66852_66880[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (11))){
var state_66840__$1 = state_66840;
var statearr_66854_66881 = state_66840__$1;
(statearr_66854_66881[(2)] = max);

(statearr_66854_66881[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (9))){
var inst_66808 = (state_66840[(2)]);
var inst_66809 = fluree.db.util.async.throw_err(inst_66808);
var state_66840__$1 = state_66840;
var statearr_66855_66882 = state_66840__$1;
(statearr_66855_66882[(2)] = inst_66809);

(statearr_66855_66882[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (5))){
var _ = (function (){var statearr_66856 = state_66840;
(statearr_66856[(4)] = cljs.core.rest((state_66840[(4)])));

return statearr_66856;
})();
var state_66840__$1 = state_66840;
var ex66853 = (state_66840__$1[(2)]);
var statearr_66857_66883 = state_66840__$1;
(statearr_66857_66883[(5)] = ex66853);


if((ex66853 instanceof Error)){
var statearr_66858_66884 = state_66840__$1;
(statearr_66858_66884[(1)] = (4));

(statearr_66858_66884[(5)] = null);

} else {
throw ex66853;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (14))){
var inst_66820 = (state_66840[(7)]);
var state_66840__$1 = state_66840;
var statearr_66859_66885 = state_66840__$1;
(statearr_66859_66885[(2)] = inst_66820);

(statearr_66859_66885[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (16))){
var inst_66812 = (state_66840[(8)]);
var inst_66824 = (state_66840[(2)]);
var inst_66825 = fluree.db.dbfunctions.internal.rand(inst_66812,inst_66824);
var inst_66826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66827 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66829 = [max,seed];
var inst_66830 = (new cljs.core.PersistentVector(null,2,(5),inst_66828,inst_66829,null));
var inst_66831 = ["rand",inst_66830,inst_66825];
var inst_66832 = cljs.core.PersistentHashMap.fromArrays(inst_66827,inst_66831);
var inst_66833 = [inst_66832,(10)];
var inst_66834 = (new cljs.core.PersistentVector(null,2,(5),inst_66826,inst_66833,null));
var inst_66835 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66834);
var _ = (function (){var statearr_66860 = state_66840;
(statearr_66860[(4)] = cljs.core.rest((state_66840[(4)])));

return statearr_66860;
})();
var state_66840__$1 = (function (){var statearr_66861 = state_66840;
(statearr_66861[(9)] = inst_66835);

return statearr_66861;
})();
var statearr_66862_66886 = state_66840__$1;
(statearr_66862_66886[(2)] = inst_66825);

(statearr_66862_66886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66841 === (10))){
var state_66840__$1 = state_66840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66840__$1,(13),max);
} else {
if((state_val_66841 === (8))){
var inst_66812 = (state_66840[(2)]);
var inst_66813 = fluree.db.util.async.channel_QMARK_(max);
var state_66840__$1 = (function (){var statearr_66863 = state_66840;
(statearr_66863[(8)] = inst_66812);

return statearr_66863;
})();
if(inst_66813){
var statearr_66864_66887 = state_66840__$1;
(statearr_66864_66887[(1)] = (10));

} else {
var statearr_66865_66888 = state_66840__$1;
(statearr_66865_66888[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10841__auto____0 = (function (){
var statearr_66866 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66866[(0)] = fluree$db$dbfunctions$fns$state_machine__10841__auto__);

(statearr_66866[(1)] = (1));

return statearr_66866;
});
var fluree$db$dbfunctions$fns$state_machine__10841__auto____1 = (function (state_66840){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66840);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66867){var ex__10844__auto__ = e66867;
var statearr_66868_66889 = state_66840;
(statearr_66868_66889[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66840[(4)]))){
var statearr_66869_66890 = state_66840;
(statearr_66869_66890[(1)] = cljs.core.first((state_66840[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66891 = state_66840;
state_66840 = G__66891;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10841__auto__ = function(state_66840){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10841__auto____1.call(this,state_66840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66870 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66870[(6)] = c__10878__auto__);

return statearr_66870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66912){
var state_val_66913 = (state_66912[(1)]);
if((state_val_66913 === (1))){
var state_66912__$1 = state_66912;
var statearr_66914_66929 = state_66912__$1;
(statearr_66914_66929[(2)] = null);

(statearr_66914_66929[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66913 === (2))){
var _ = (function (){var statearr_66915 = state_66912;
(statearr_66915[(4)] = cljs.core.cons((5),(state_66912[(4)])));

return statearr_66915;
})();
var inst_66898 = fluree.db.util.core.random_uuid();
var inst_66899 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66898);
var inst_66900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66901 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66902 = cljs.core.PersistentVector.EMPTY;
var inst_66903 = ["uuid",inst_66902,inst_66899];
var inst_66904 = cljs.core.PersistentHashMap.fromArrays(inst_66901,inst_66903);
var inst_66905 = [inst_66904,(10)];
var inst_66906 = (new cljs.core.PersistentVector(null,2,(5),inst_66900,inst_66905,null));
var inst_66907 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66906);
var ___$1 = (function (){var statearr_66916 = state_66912;
(statearr_66916[(4)] = cljs.core.rest((state_66912[(4)])));

return statearr_66916;
})();
var state_66912__$1 = (function (){var statearr_66917 = state_66912;
(statearr_66917[(7)] = inst_66907);

return statearr_66917;
})();
var statearr_66918_66930 = state_66912__$1;
(statearr_66918_66930[(2)] = inst_66899);

(statearr_66918_66930[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66913 === (3))){
var inst_66910 = (state_66912[(2)]);
var state_66912__$1 = state_66912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66912__$1,inst_66910);
} else {
if((state_val_66913 === (4))){
var inst_66892 = (state_66912[(2)]);
var state_66912__$1 = state_66912;
var statearr_66920_66931 = state_66912__$1;
(statearr_66920_66931[(2)] = inst_66892);

(statearr_66920_66931[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66913 === (5))){
var _ = (function (){var statearr_66921 = state_66912;
(statearr_66921[(4)] = cljs.core.rest((state_66912[(4)])));

return statearr_66921;
})();
var state_66912__$1 = state_66912;
var ex66919 = (state_66912__$1[(2)]);
var statearr_66922_66932 = state_66912__$1;
(statearr_66922_66932[(5)] = ex66919);


if((ex66919 instanceof Error)){
var statearr_66923_66933 = state_66912__$1;
(statearr_66923_66933[(1)] = (4));

(statearr_66923_66933[(5)] = null);

} else {
throw ex66919;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto____0 = (function (){
var statearr_66924 = [null,null,null,null,null,null,null,null];
(statearr_66924[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto__);

(statearr_66924[(1)] = (1));

return statearr_66924;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto____1 = (function (state_66912){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66912);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66925){var ex__10844__auto__ = e66925;
var statearr_66926_66934 = state_66912;
(statearr_66926_66934[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66912[(4)]))){
var statearr_66927_66935 = state_66912;
(statearr_66927_66935[(1)] = cljs.core.first((state_66912[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66936 = state_66912;
state_66912 = G__66936;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto__ = function(state_66912){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto____1.call(this,state_66912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66928 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66928[(6)] = c__10878__auto__);

return statearr_66928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_66966){
var state_val_66967 = (state_66966[(1)]);
if((state_val_66967 === (7))){
var state_66966__$1 = state_66966;
var statearr_66968_66987 = state_66966__$1;
(statearr_66968_66987[(2)] = num);

(statearr_66968_66987[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66967 === (1))){
var state_66966__$1 = state_66966;
var statearr_66969_66988 = state_66966__$1;
(statearr_66969_66988[(2)] = null);

(statearr_66969_66988[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66967 === (4))){
var inst_66937 = (state_66966[(2)]);
var state_66966__$1 = state_66966;
var statearr_66970_66989 = state_66966__$1;
(statearr_66970_66989[(2)] = inst_66937);

(statearr_66970_66989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66967 === (6))){
var state_66966__$1 = state_66966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66966__$1,(9),num);
} else {
if((state_val_66967 === (3))){
var inst_66964 = (state_66966[(2)]);
var state_66966__$1 = state_66966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66966__$1,inst_66964);
} else {
if((state_val_66967 === (2))){
var _ = (function (){var statearr_66972 = state_66966;
(statearr_66972[(4)] = cljs.core.cons((5),(state_66966[(4)])));

return statearr_66972;
})();
var inst_66943 = fluree.db.util.async.channel_QMARK_(num);
var state_66966__$1 = state_66966;
if(inst_66943){
var statearr_66973_66990 = state_66966__$1;
(statearr_66973_66990[(1)] = (6));

} else {
var statearr_66974_66991 = state_66966__$1;
(statearr_66974_66991[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66967 === (9))){
var inst_66946 = (state_66966[(2)]);
var inst_66947 = fluree.db.util.async.throw_err(inst_66946);
var state_66966__$1 = state_66966;
var statearr_66975_66992 = state_66966__$1;
(statearr_66975_66992[(2)] = inst_66947);

(statearr_66975_66992[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66967 === (5))){
var _ = (function (){var statearr_66976 = state_66966;
(statearr_66976[(4)] = cljs.core.rest((state_66966[(4)])));

return statearr_66976;
})();
var state_66966__$1 = state_66966;
var ex66971 = (state_66966__$1[(2)]);
var statearr_66977_66993 = state_66966__$1;
(statearr_66977_66993[(5)] = ex66971);


if((ex66971 instanceof Error)){
var statearr_66978_66994 = state_66966__$1;
(statearr_66978_66994[(1)] = (4));

(statearr_66978_66994[(5)] = null);

} else {
throw ex66971;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66967 === (8))){
var inst_66950 = (state_66966[(2)]);
var inst_66951 = fluree.db.dbfunctions.internal.ceil(inst_66950);
var inst_66952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66953 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66955 = [fluree.db.dbfunctions.fns.ceil];
var inst_66956 = (new cljs.core.PersistentVector(null,1,(5),inst_66954,inst_66955,null));
var inst_66957 = ["",inst_66956,inst_66951];
var inst_66958 = cljs.core.PersistentHashMap.fromArrays(inst_66953,inst_66957);
var inst_66959 = [inst_66958,(10)];
var inst_66960 = (new cljs.core.PersistentVector(null,2,(5),inst_66952,inst_66959,null));
var inst_66961 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66960);
var _ = (function (){var statearr_66979 = state_66966;
(statearr_66979[(4)] = cljs.core.rest((state_66966[(4)])));

return statearr_66979;
})();
var state_66966__$1 = (function (){var statearr_66980 = state_66966;
(statearr_66980[(7)] = inst_66961);

return statearr_66980;
})();
var statearr_66981_66995 = state_66966__$1;
(statearr_66981_66995[(2)] = inst_66951);

(statearr_66981_66995[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto____0 = (function (){
var statearr_66982 = [null,null,null,null,null,null,null,null];
(statearr_66982[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto__);

(statearr_66982[(1)] = (1));

return statearr_66982;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto____1 = (function (state_66966){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_66966);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e66983){var ex__10844__auto__ = e66983;
var statearr_66984_66996 = state_66966;
(statearr_66984_66996[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_66966[(4)]))){
var statearr_66985_66997 = state_66966;
(statearr_66985_66997[(1)] = cljs.core.first((state_66966[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__66998 = state_66966;
state_66966 = G__66998;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto__ = function(state_66966){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto____1.call(this,state_66966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_66986 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_66986[(6)] = c__10878__auto__);

return statearr_66986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_67028){
var state_val_67029 = (state_67028[(1)]);
if((state_val_67029 === (7))){
var state_67028__$1 = state_67028;
var statearr_67030_67049 = state_67028__$1;
(statearr_67030_67049[(2)] = num);

(statearr_67030_67049[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67029 === (1))){
var state_67028__$1 = state_67028;
var statearr_67031_67050 = state_67028__$1;
(statearr_67031_67050[(2)] = null);

(statearr_67031_67050[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67029 === (4))){
var inst_66999 = (state_67028[(2)]);
var state_67028__$1 = state_67028;
var statearr_67032_67051 = state_67028__$1;
(statearr_67032_67051[(2)] = inst_66999);

(statearr_67032_67051[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67029 === (6))){
var state_67028__$1 = state_67028;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67028__$1,(9),num);
} else {
if((state_val_67029 === (3))){
var inst_67026 = (state_67028[(2)]);
var state_67028__$1 = state_67028;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67028__$1,inst_67026);
} else {
if((state_val_67029 === (2))){
var _ = (function (){var statearr_67034 = state_67028;
(statearr_67034[(4)] = cljs.core.cons((5),(state_67028[(4)])));

return statearr_67034;
})();
var inst_67005 = fluree.db.util.async.channel_QMARK_(num);
var state_67028__$1 = state_67028;
if(inst_67005){
var statearr_67035_67052 = state_67028__$1;
(statearr_67035_67052[(1)] = (6));

} else {
var statearr_67036_67053 = state_67028__$1;
(statearr_67036_67053[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67029 === (9))){
var inst_67008 = (state_67028[(2)]);
var inst_67009 = fluree.db.util.async.throw_err(inst_67008);
var state_67028__$1 = state_67028;
var statearr_67037_67054 = state_67028__$1;
(statearr_67037_67054[(2)] = inst_67009);

(statearr_67037_67054[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67029 === (5))){
var _ = (function (){var statearr_67038 = state_67028;
(statearr_67038[(4)] = cljs.core.rest((state_67028[(4)])));

return statearr_67038;
})();
var state_67028__$1 = state_67028;
var ex67033 = (state_67028__$1[(2)]);
var statearr_67039_67055 = state_67028__$1;
(statearr_67039_67055[(5)] = ex67033);


if((ex67033 instanceof Error)){
var statearr_67040_67056 = state_67028__$1;
(statearr_67040_67056[(1)] = (4));

(statearr_67040_67056[(5)] = null);

} else {
throw ex67033;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67029 === (8))){
var inst_67012 = (state_67028[(2)]);
var inst_67013 = fluree.db.dbfunctions.internal.floor(inst_67012);
var inst_67014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67015 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67017 = [fluree.db.dbfunctions.fns.floor];
var inst_67018 = (new cljs.core.PersistentVector(null,1,(5),inst_67016,inst_67017,null));
var inst_67019 = ["",inst_67018,inst_67013];
var inst_67020 = cljs.core.PersistentHashMap.fromArrays(inst_67015,inst_67019);
var inst_67021 = [inst_67020,(10)];
var inst_67022 = (new cljs.core.PersistentVector(null,2,(5),inst_67014,inst_67021,null));
var inst_67023 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67022);
var _ = (function (){var statearr_67041 = state_67028;
(statearr_67041[(4)] = cljs.core.rest((state_67028[(4)])));

return statearr_67041;
})();
var state_67028__$1 = (function (){var statearr_67042 = state_67028;
(statearr_67042[(7)] = inst_67023);

return statearr_67042;
})();
var statearr_67043_67057 = state_67028__$1;
(statearr_67043_67057[(2)] = inst_67013);

(statearr_67043_67057[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto____0 = (function (){
var statearr_67044 = [null,null,null,null,null,null,null,null];
(statearr_67044[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto__);

(statearr_67044[(1)] = (1));

return statearr_67044;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto____1 = (function (state_67028){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_67028);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e67045){var ex__10844__auto__ = e67045;
var statearr_67046_67058 = state_67028;
(statearr_67046_67058[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_67028[(4)]))){
var statearr_67047_67059 = state_67028;
(statearr_67047_67059[(1)] = cljs.core.first((state_67028[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__67060 = state_67028;
state_67028 = G__67060;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto__ = function(state_67028){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto____1.call(this,state_67028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_67048 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_67048[(6)] = c__10878__auto__);

return statearr_67048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_67085){
var state_val_67086 = (state_67085[(1)]);
if((state_val_67086 === (1))){
var state_67085__$1 = state_67085;
var statearr_67087_67102 = state_67085__$1;
(statearr_67087_67102[(2)] = null);

(statearr_67087_67102[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67086 === (2))){
var _ = (function (){var statearr_67088 = state_67085;
(statearr_67088[(4)] = cljs.core.cons((5),(state_67085[(4)])));

return statearr_67088;
})();
var inst_67067 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_67085__$1 = state_67085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67085__$1,(6),inst_67067);
} else {
if((state_val_67086 === (3))){
var inst_67083 = (state_67085[(2)]);
var state_67085__$1 = state_67085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67085__$1,inst_67083);
} else {
if((state_val_67086 === (4))){
var inst_67061 = (state_67085[(2)]);
var state_67085__$1 = state_67085;
var statearr_67090_67103 = state_67085__$1;
(statearr_67090_67103[(2)] = inst_67061);

(statearr_67090_67103[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67086 === (5))){
var _ = (function (){var statearr_67091 = state_67085;
(statearr_67091[(4)] = cljs.core.rest((state_67085[(4)])));

return statearr_67091;
})();
var state_67085__$1 = state_67085;
var ex67089 = (state_67085__$1[(2)]);
var statearr_67092_67104 = state_67085__$1;
(statearr_67092_67104[(5)] = ex67089);


if((ex67089 instanceof Error)){
var statearr_67093_67105 = state_67085__$1;
(statearr_67093_67105[(1)] = (4));

(statearr_67093_67105[(5)] = null);

} else {
throw ex67089;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67086 === (6))){
var inst_67069 = (state_67085[(2)]);
var inst_67070 = fluree.db.util.async.throw_err(inst_67069);
var inst_67071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67072 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67074 = [compare_val,new_val];
var inst_67075 = (new cljs.core.PersistentVector(null,2,(5),inst_67073,inst_67074,null));
var inst_67076 = ["",inst_67075,inst_67070];
var inst_67077 = cljs.core.PersistentHashMap.fromArrays(inst_67072,inst_67076);
var inst_67078 = [inst_67077,(10)];
var inst_67079 = (new cljs.core.PersistentVector(null,2,(5),inst_67071,inst_67078,null));
var inst_67080 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67079);
var _ = (function (){var statearr_67094 = state_67085;
(statearr_67094[(4)] = cljs.core.rest((state_67085[(4)])));

return statearr_67094;
})();
var state_67085__$1 = (function (){var statearr_67095 = state_67085;
(statearr_67095[(7)] = inst_67080);

return statearr_67095;
})();
var statearr_67096_67106 = state_67085__$1;
(statearr_67096_67106[(2)] = inst_67070);

(statearr_67096_67106[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto____0 = (function (){
var statearr_67097 = [null,null,null,null,null,null,null,null];
(statearr_67097[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto__);

(statearr_67097[(1)] = (1));

return statearr_67097;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto____1 = (function (state_67085){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_67085);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e67098){var ex__10844__auto__ = e67098;
var statearr_67099_67107 = state_67085;
(statearr_67099_67107[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_67085[(4)]))){
var statearr_67100_67108 = state_67085;
(statearr_67100_67108[(1)] = cljs.core.first((state_67085[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__67109 = state_67085;
state_67085 = G__67109;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto__ = function(state_67085){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto____1.call(this,state_67085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_67101 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_67101[(6)] = c__10878__auto__);

return statearr_67101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
