// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__33545 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33545,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33545,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33545,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__33548){
var map__33549 = p__33548;
var map__33549__$1 = cljs.core.__destructure_map(map__33549);
var opts = map__33549__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33549__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_33609){
var state_val_33610 = (state_33609[(1)]);
if((state_val_33610 === (7))){
var inst_33580 = cljs.core.not(reindex_QMARK_);
var state_33609__$1 = state_33609;
var statearr_33611_33635 = state_33609__$1;
(statearr_33611_33635[(2)] = inst_33580);

(statearr_33611_33635[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (1))){
var state_33609__$1 = state_33609;
var statearr_33612_33636 = state_33609__$1;
(statearr_33612_33636[(2)] = null);

(statearr_33612_33636[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (4))){
var inst_33550 = (state_33609[(2)]);
var state_33609__$1 = state_33609;
var statearr_33613_33637 = state_33609__$1;
(statearr_33613_33637[(2)] = inst_33550);

(statearr_33613_33637[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (6))){
var inst_33570 = (state_33609[(7)]);
var inst_33578 = (state_33609[(8)]);
var inst_33564 = (state_33609[(9)]);
var inst_33563 = (state_33609[(2)]);
var inst_33564__$1 = fluree.db.util.async.throw_err(inst_33563);
var inst_33565 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_33566 = cljs.core.__destructure_map(inst_33565);
var inst_33567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33566,cljs.core.cst$kw$post);
var inst_33568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33566,cljs.core.cst$kw$size);
var inst_33569 = fluree.db.flake.size_bytes(inst_33564__$1);
var inst_33570__$1 = (inst_33568 + inst_33569);
var inst_33571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33572 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_33573 = (new cljs.core.PersistentVector(null,2,(5),inst_33571,inst_33572,null));
var inst_33574 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_33573);
var inst_33575 = cljs.core.__destructure_map(inst_33574);
var inst_33576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33575,cljs.core.cst$kw$novelty_DASH_min);
var inst_33577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33575,cljs.core.cst$kw$novelty_DASH_max);
var inst_33578__$1 = (inst_33570__$1 > inst_33577);
var state_33609__$1 = (function (){var statearr_33614 = state_33609;
(statearr_33614[(7)] = inst_33570__$1);

(statearr_33614[(8)] = inst_33578__$1);

(statearr_33614[(9)] = inst_33564__$1);

(statearr_33614[(10)] = inst_33567);

(statearr_33614[(11)] = inst_33576);

return statearr_33614;
})();
if(cljs.core.truth_(inst_33578__$1)){
var statearr_33615_33638 = state_33609__$1;
(statearr_33615_33638[(1)] = (7));

} else {
var statearr_33616_33639 = state_33609__$1;
(statearr_33616_33639[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (3))){
var inst_33607 = (state_33609[(2)]);
var state_33609__$1 = state_33609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33609__$1,inst_33607);
} else {
if((state_val_33610 === (12))){
var inst_33570 = (state_33609[(7)]);
var inst_33564 = (state_33609[(9)]);
var inst_33567 = (state_33609[(10)]);
var inst_33593 = (state_33609[(2)]);
var inst_33594 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33567,inst_33564);
var inst_33595 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_33596 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33595,cljs.core.empty);
var inst_33597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33598 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_33599 = (new cljs.core.PersistentVector(null,2,(5),inst_33597,inst_33598,null));
var inst_33600 = cljs.core.assoc_in(db,inst_33599,inst_33594);
var inst_33601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33602 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_33603 = (new cljs.core.PersistentVector(null,2,(5),inst_33601,inst_33602,null));
var inst_33604 = cljs.core.assoc_in(inst_33600,inst_33603,inst_33570);
var _ = (function (){var statearr_33617 = state_33609;
(statearr_33617[(4)] = cljs.core.rest((state_33609[(4)])));

return statearr_33617;
})();
var state_33609__$1 = (function (){var statearr_33618 = state_33609;
(statearr_33618[(12)] = inst_33596);

(statearr_33618[(13)] = inst_33593);

return statearr_33618;
})();
var statearr_33619_33640 = state_33609__$1;
(statearr_33619_33640[(2)] = inst_33604);

(statearr_33619_33640[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (2))){
var _ = (function (){var statearr_33620 = state_33609;
(statearr_33620[(4)] = cljs.core.cons((5),(state_33609[(4)])));

return statearr_33620;
})();
var inst_33558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33559 = [pred_id];
var inst_33560 = (new cljs.core.PersistentVector(null,1,(5),inst_33558,inst_33559,null));
var inst_33561 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_33560);
var state_33609__$1 = state_33609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33609__$1,(6),inst_33561);
} else {
if((state_val_33610 === (11))){
var state_33609__$1 = state_33609;
var statearr_33622_33641 = state_33609__$1;
(statearr_33622_33641[(2)] = null);

(statearr_33622_33641[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (9))){
var inst_33583 = (state_33609[(2)]);
var state_33609__$1 = state_33609;
if(cljs.core.truth_(inst_33583)){
var statearr_33623_33642 = state_33609__$1;
(statearr_33623_33642[(1)] = (10));

} else {
var statearr_33624_33643 = state_33609__$1;
(statearr_33624_33643[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (5))){
var _ = (function (){var statearr_33625 = state_33609;
(statearr_33625[(4)] = cljs.core.rest((state_33609[(4)])));

return statearr_33625;
})();
var state_33609__$1 = state_33609;
var ex33621 = (state_33609__$1[(2)]);
var statearr_33626_33644 = state_33609__$1;
(statearr_33626_33644[(5)] = ex33621);


if((ex33621 instanceof Error)){
var statearr_33627_33645 = state_33609__$1;
(statearr_33627_33645[(1)] = (4));

(statearr_33627_33645[(5)] = null);

} else {
throw ex33621;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (10))){
var inst_33585 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_33586 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_33587 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_33588 = cljs.core.PersistentHashMap.fromArrays(inst_33586,inst_33587);
var inst_33589 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33585,inst_33588);
var inst_33590 = (function(){throw inst_33589})();
var state_33609__$1 = state_33609;
var statearr_33628_33646 = state_33609__$1;
(statearr_33628_33646[(2)] = inst_33590);

(statearr_33628_33646[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33610 === (8))){
var inst_33578 = (state_33609[(8)]);
var state_33609__$1 = state_33609;
var statearr_33629_33647 = state_33609__$1;
(statearr_33629_33647[(2)] = inst_33578);

(statearr_33629_33647[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto____0 = (function (){
var statearr_33630 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33630[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto__);

(statearr_33630[(1)] = (1));

return statearr_33630;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto____1 = (function (state_33609){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_33609);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e33631){var ex__10844__auto__ = e33631;
var statearr_33632_33648 = state_33609;
(statearr_33632_33648[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_33609[(4)]))){
var statearr_33633_33649 = state_33609;
(statearr_33633_33649[(1)] = cljs.core.first((state_33609[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__33650 = state_33609;
state_33609 = G__33650;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto__ = function(state_33609){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto____1.call(this,state_33609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_33634 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_33634[(6)] = c__10878__auto__);

return statearr_33634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__33655 = arguments.length;
switch (G__33655) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_33851){
var state_val_33852 = (state_33851[(1)]);
if((state_val_33852 === (7))){
var state_33851__$1 = state_33851;
var statearr_33853_33921 = state_33851__$1;
(statearr_33853_33921[(2)] = null);

(statearr_33853_33921[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (20))){
var inst_33775 = (state_33851[(7)]);
var inst_33773 = (state_33851[(8)]);
var inst_33693 = (state_33851[(9)]);
var inst_33774 = (state_33851[(10)]);
var inst_33777 = (state_33851[(11)]);
var inst_33776 = (state_33851[(12)]);
var inst_33744 = (state_33851[(13)]);
var inst_33694 = (state_33851[(14)]);
var inst_33787 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_33788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33789 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_33790 = (new cljs.core.PersistentVector(null,2,(5),inst_33788,inst_33789,null));
var inst_33791 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_33744,inst_33790);
var inst_33792 = (inst_33693 + inst_33791);
var inst_33793 = [inst_33773,inst_33774,inst_33775,inst_33776,inst_33792];
var inst_33794 = cljs.core.PersistentHashMap.fromArrays(inst_33787,inst_33793);
var inst_33795 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_33744,cljs.core.cst$kw$ecount,inst_33777,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_33794], 0));
var state_33851__$1 = (function (){var statearr_33854 = state_33851;
(statearr_33854[(15)] = inst_33795);

return statearr_33854;
})();
if(cljs.core.truth_(inst_33694)){
var statearr_33855_33922 = state_33851__$1;
(statearr_33855_33922[(1)] = (23));

} else {
var statearr_33856_33923 = state_33851__$1;
(statearr_33856_33923[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (27))){
var inst_33795 = (state_33851[(15)]);
var state_33851__$1 = state_33851;
var statearr_33857_33924 = state_33851__$1;
(statearr_33857_33924[(2)] = inst_33795);

(statearr_33857_33924[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (1))){
var state_33851__$1 = state_33851;
var statearr_33858_33925 = state_33851__$1;
(statearr_33858_33925[(2)] = null);

(statearr_33858_33925[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (24))){
var inst_33795 = (state_33851[(15)]);
var inst_33798 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_33795);
var inst_33799 = (inst_33798 == null);
var state_33851__$1 = state_33851;
var statearr_33859_33926 = state_33851__$1;
(statearr_33859_33926[(2)] = inst_33799);

(statearr_33859_33926[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (39))){
var inst_33826 = (state_33851[(16)]);
var inst_33827 = (state_33851[(17)]);
var inst_33784 = (state_33851[(18)]);
var inst_33834 = (state_33851[(19)]);
var inst_33825 = (state_33851[(20)]);
var inst_33841 = (state_33851[(2)]);
var inst_33772 = inst_33784;
var inst_33773 = inst_33826;
var inst_33774 = inst_33827;
var inst_33775 = inst_33834;
var inst_33776 = inst_33841;
var inst_33777 = inst_33825;
var state_33851__$1 = (function (){var statearr_33860 = state_33851;
(statearr_33860[(7)] = inst_33775);

(statearr_33860[(8)] = inst_33773);

(statearr_33860[(21)] = inst_33772);

(statearr_33860[(10)] = inst_33774);

(statearr_33860[(11)] = inst_33777);

(statearr_33860[(12)] = inst_33776);

return statearr_33860;
})();
var statearr_33861_33927 = state_33851__$1;
(statearr_33861_33927[(2)] = null);

(statearr_33861_33927[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (4))){
var inst_33656 = (state_33851[(2)]);
var state_33851__$1 = state_33851;
var statearr_33862_33928 = state_33851__$1;
(statearr_33862_33928[(2)] = inst_33656);

(statearr_33862_33928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (15))){
var inst_33716 = (state_33851[(22)]);
var state_33851__$1 = state_33851;
var statearr_33863_33929 = state_33851__$1;
(statearr_33863_33929[(2)] = inst_33716);

(statearr_33863_33929[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (21))){
var inst_33775 = (state_33851[(7)]);
var inst_33663 = (state_33851[(23)]);
var inst_33773 = (state_33851[(8)]);
var inst_33688 = (state_33851[(24)]);
var inst_33693 = (state_33851[(9)]);
var inst_33784 = (state_33851[(18)]);
var inst_33754 = (state_33851[(25)]);
var inst_33783 = (state_33851[(26)]);
var inst_33695 = (state_33851[(27)]);
var inst_33772 = (state_33851[(21)]);
var inst_33678 = (state_33851[(28)]);
var inst_33774 = (state_33851[(10)]);
var inst_33692 = (state_33851[(29)]);
var inst_33703 = (state_33851[(30)]);
var inst_33680 = (state_33851[(31)]);
var inst_33777 = (state_33851[(11)]);
var inst_33697 = (state_33851[(32)]);
var inst_33776 = (state_33851[(12)]);
var inst_33744 = (state_33851[(13)]);
var inst_33753 = (state_33851[(33)]);
var inst_33694 = (state_33851[(14)]);
var inst_33684 = (state_33851[(34)]);
var inst_33822 = inst_33783.s;
var inst_33823 = fluree.db.flake.sid__GT_cid(inst_33822);
var inst_33824 = (function (){var flakes_bytes = inst_33693;
var t = inst_33663;
var seq__33780 = inst_33784;
var vec__33749 = inst_33680;
var first__33751 = inst_33753;
var spot = inst_33773;
var add_flakes = inst_33680;
var root_setting_change_QMARK_ = inst_33695;
var ref_QMARK__map = inst_33692;
var r = inst_33784;
var psot = inst_33774;
var G__33748 = inst_33772;
var add_pred_to_idx_QMARK_ = inst_33703;
var _ = inst_33678;
var cid = inst_33823;
var ecount = inst_33777;
var pred_ecount = inst_33697;
var db_STAR_ = inst_33744;
var schema_change_QMARK_ = inst_33694;
var seq__33750 = inst_33754;
var add_preds = inst_33684;
var opst = inst_33776;
var idx_QMARK__map = inst_33688;
var vec__33779 = inst_33772;
var post = inst_33775;
var first__33781 = inst_33783;
var f = inst_33783;
return (function (p1__33653_SHARP_){
if(cljs.core.truth_(p1__33653_SHARP_)){
var x__4306__auto__ = p1__33653_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_33825 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_33777,inst_33823,inst_33824);
var inst_33826 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33773,inst_33783);
var inst_33827 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33774,inst_33783);
var inst_33828 = inst_33783.p;
var inst_33829 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33688,inst_33828);
var state_33851__$1 = (function (){var statearr_33864 = state_33851;
(statearr_33864[(16)] = inst_33826);

(statearr_33864[(17)] = inst_33827);

(statearr_33864[(20)] = inst_33825);

return statearr_33864;
})();
if(cljs.core.truth_(inst_33829)){
var statearr_33865_33930 = state_33851__$1;
(statearr_33865_33930[(1)] = (34));

} else {
var statearr_33866_33931 = state_33851__$1;
(statearr_33866_33931[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (31))){
var inst_33810 = (state_33851[(35)]);
var state_33851__$1 = state_33851;
var statearr_33867_33932 = state_33851__$1;
(statearr_33867_33932[(2)] = inst_33810);

(statearr_33867_33932[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (32))){
var inst_33820 = (state_33851[(2)]);
var state_33851__$1 = state_33851;
var statearr_33868_33933 = state_33851__$1;
(statearr_33868_33933[(2)] = inst_33820);

(statearr_33868_33933[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (33))){
var inst_33810 = (state_33851[(35)]);
var inst_33815 = (state_33851[(2)]);
var inst_33816 = fluree.db.util.async.throw_err(inst_33815);
var inst_33817 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33810,cljs.core.cst$kw$settings,inst_33816);
var state_33851__$1 = state_33851;
var statearr_33869_33934 = state_33851__$1;
(statearr_33869_33934[(2)] = inst_33817);

(statearr_33869_33934[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (13))){
var inst_33663 = (state_33851[(23)]);
var inst_33693 = (state_33851[(9)]);
var inst_33680 = (state_33851[(31)]);
var inst_33744 = (state_33851[(13)]);
var inst_33734 = (state_33851[(2)]);
var inst_33735 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33734,cljs.core.cst$kw$t,inst_33663);
var inst_33736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33737 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_33738 = (new cljs.core.PersistentVector(null,2,(5),inst_33736,inst_33737,null));
var inst_33739 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_33735,inst_33738,cljs.core._PLUS_,inst_33693);
var inst_33740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33741 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_33742 = (new cljs.core.PersistentVector(null,2,(5),inst_33740,inst_33741,null));
var inst_33743 = cljs.core.count(inst_33680);
var inst_33744__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_33739,inst_33742,cljs.core._PLUS_,inst_33743);
var inst_33752 = cljs.core.seq(inst_33680);
var inst_33753 = cljs.core.first(inst_33752);
var inst_33754 = cljs.core.next(inst_33752);
var inst_33755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33756 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_33757 = (new cljs.core.PersistentVector(null,2,(5),inst_33755,inst_33756,null));
var inst_33758 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_33744__$1,inst_33757);
var inst_33759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33760 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_33761 = (new cljs.core.PersistentVector(null,2,(5),inst_33759,inst_33760,null));
var inst_33762 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_33744__$1,inst_33761);
var inst_33763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33764 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_33765 = (new cljs.core.PersistentVector(null,2,(5),inst_33763,inst_33764,null));
var inst_33766 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_33744__$1,inst_33765);
var inst_33767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33768 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_33769 = (new cljs.core.PersistentVector(null,2,(5),inst_33767,inst_33768,null));
var inst_33770 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_33744__$1,inst_33769);
var inst_33771 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_33772 = inst_33680;
var inst_33773 = inst_33758;
var inst_33774 = inst_33762;
var inst_33775 = inst_33766;
var inst_33776 = inst_33770;
var inst_33777 = inst_33771;
var state_33851__$1 = (function (){var statearr_33870 = state_33851;
(statearr_33870[(7)] = inst_33775);

(statearr_33870[(8)] = inst_33773);

(statearr_33870[(25)] = inst_33754);

(statearr_33870[(21)] = inst_33772);

(statearr_33870[(10)] = inst_33774);

(statearr_33870[(11)] = inst_33777);

(statearr_33870[(12)] = inst_33776);

(statearr_33870[(13)] = inst_33744__$1);

(statearr_33870[(33)] = inst_33753);

return statearr_33870;
})();
var statearr_33871_33935 = state_33851__$1;
(statearr_33871_33935[(2)] = null);

(statearr_33871_33935[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (22))){
var inst_33844 = (state_33851[(2)]);
var state_33851__$1 = state_33851;
var statearr_33872_33936 = state_33851__$1;
(statearr_33872_33936[(2)] = inst_33844);

(statearr_33872_33936[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (36))){
var inst_33783 = (state_33851[(26)]);
var inst_33692 = (state_33851[(29)]);
var inst_33834 = (state_33851[(2)]);
var inst_33835 = inst_33783.p;
var inst_33836 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33692,inst_33835);
var state_33851__$1 = (function (){var statearr_33873 = state_33851;
(statearr_33873[(19)] = inst_33834);

return statearr_33873;
})();
if(cljs.core.truth_(inst_33836)){
var statearr_33874_33937 = state_33851__$1;
(statearr_33874_33937[(1)] = (37));

} else {
var statearr_33875_33938 = state_33851__$1;
(statearr_33875_33938[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (29))){
var inst_33795 = (state_33851[(15)]);
var inst_33805 = (state_33851[(2)]);
var inst_33806 = fluree.db.util.async.throw_err(inst_33805);
var inst_33807 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33795,cljs.core.cst$kw$schema,inst_33806);
var state_33851__$1 = state_33851;
var statearr_33876_33939 = state_33851__$1;
(statearr_33876_33939[(2)] = inst_33807);

(statearr_33876_33939[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (6))){
var inst_33663 = (state_33851[(23)]);
var inst_33668 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_33669 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_33670 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33668)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33669)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33663),"."].join('');
var inst_33671 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33672 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_33673 = cljs.core.PersistentHashMap.fromArrays(inst_33671,inst_33672);
var inst_33674 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33670,inst_33673);
var inst_33675 = (function(){throw inst_33674})();
var state_33851__$1 = state_33851;
var statearr_33877_33940 = state_33851__$1;
(statearr_33877_33940[(2)] = inst_33675);

(statearr_33877_33940[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (28))){
var inst_33695 = (state_33851[(27)]);
var inst_33810 = (state_33851[(2)]);
var state_33851__$1 = (function (){var statearr_33878 = state_33851;
(statearr_33878[(35)] = inst_33810);

return statearr_33878;
})();
if(cljs.core.truth_(inst_33695)){
var statearr_33879_33941 = state_33851__$1;
(statearr_33879_33941[(1)] = (30));

} else {
var statearr_33880_33942 = state_33851__$1;
(statearr_33880_33942[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (25))){
var inst_33801 = (state_33851[(2)]);
var state_33851__$1 = state_33851;
if(cljs.core.truth_(inst_33801)){
var statearr_33881_33943 = state_33851__$1;
(statearr_33881_33943[(1)] = (26));

} else {
var statearr_33882_33944 = state_33851__$1;
(statearr_33882_33944[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (34))){
var inst_33775 = (state_33851[(7)]);
var inst_33783 = (state_33851[(26)]);
var inst_33831 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33775,inst_33783);
var state_33851__$1 = state_33851;
var statearr_33883_33945 = state_33851__$1;
(statearr_33883_33945[(2)] = inst_33831);

(statearr_33883_33945[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (17))){
var inst_33723 = (state_33851[(36)]);
var inst_33727 = (state_33851[(2)]);
var inst_33728 = fluree.db.util.async.throw_err(inst_33727);
var inst_33715 = inst_33723;
var inst_33716 = inst_33728;
var state_33851__$1 = (function (){var statearr_33884 = state_33851;
(statearr_33884[(37)] = inst_33715);

(statearr_33884[(22)] = inst_33716);

return statearr_33884;
})();
var statearr_33885_33946 = state_33851__$1;
(statearr_33885_33946[(2)] = null);

(statearr_33885_33946[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (3))){
var inst_33849 = (state_33851[(2)]);
var state_33851__$1 = state_33851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33851__$1,inst_33849);
} else {
if((state_val_33852 === (12))){
var inst_33722 = (state_33851[(38)]);
var inst_33715 = (state_33851[(37)]);
var inst_33721 = cljs.core.seq(inst_33715);
var inst_33722__$1 = cljs.core.first(inst_33721);
var inst_33723 = cljs.core.next(inst_33721);
var state_33851__$1 = (function (){var statearr_33886 = state_33851;
(statearr_33886[(38)] = inst_33722__$1);

(statearr_33886[(36)] = inst_33723);

return statearr_33886;
})();
if(cljs.core.truth_(inst_33722__$1)){
var statearr_33887_33947 = state_33851__$1;
(statearr_33887_33947[(1)] = (14));

} else {
var statearr_33888_33948 = state_33851__$1;
(statearr_33888_33948[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (2))){
var inst_33663 = (state_33851[(23)]);
var _ = (function (){var statearr_33889 = state_33851;
(statearr_33889[(4)] = cljs.core.cons((5),(state_33851[(4)])));

return statearr_33889;
})();
var inst_33662 = cljs.core.first(flakes);
var inst_33663__$1 = inst_33662.t;
var inst_33664 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_33665 = (inst_33664 - (1));
var inst_33666 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_33663__$1,inst_33665);
var state_33851__$1 = (function (){var statearr_33890 = state_33851;
(statearr_33890[(23)] = inst_33663__$1);

return statearr_33890;
})();
if(inst_33666){
var statearr_33891_33949 = state_33851__$1;
(statearr_33891_33949[(1)] = (6));

} else {
var statearr_33892_33950 = state_33851__$1;
(statearr_33892_33950[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (23))){
var inst_33694 = (state_33851[(14)]);
var state_33851__$1 = state_33851;
var statearr_33893_33951 = state_33851__$1;
(statearr_33893_33951[(2)] = inst_33694);

(statearr_33893_33951[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (35))){
var inst_33775 = (state_33851[(7)]);
var state_33851__$1 = state_33851;
var statearr_33894_33952 = state_33851__$1;
(statearr_33894_33952[(2)] = inst_33775);

(statearr_33894_33952[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (19))){
var inst_33846 = (state_33851[(2)]);
var _ = (function (){var statearr_33895 = state_33851;
(statearr_33895[(4)] = cljs.core.rest((state_33851[(4)])));

return statearr_33895;
})();
var state_33851__$1 = state_33851;
var statearr_33896_33953 = state_33851__$1;
(statearr_33896_33953[(2)] = inst_33846);

(statearr_33896_33953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (11))){
var inst_33703 = (state_33851[(30)]);
var inst_33703__$1 = (state_33851[(2)]);
var inst_33711 = cljs.core.seq(inst_33703__$1);
var inst_33712 = cljs.core.first(inst_33711);
var inst_33713 = cljs.core.next(inst_33711);
var inst_33714 = db;
var inst_33715 = inst_33703__$1;
var inst_33716 = inst_33714;
var state_33851__$1 = (function (){var statearr_33898 = state_33851;
(statearr_33898[(37)] = inst_33715);

(statearr_33898[(22)] = inst_33716);

(statearr_33898[(39)] = inst_33713);

(statearr_33898[(40)] = inst_33712);

(statearr_33898[(30)] = inst_33703__$1);

return statearr_33898;
})();
var statearr_33899_33954 = state_33851__$1;
(statearr_33899_33954[(2)] = null);

(statearr_33899_33954[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (9))){
var inst_33680 = (state_33851[(31)]);
var inst_33697 = (state_33851[(32)]);
var inst_33699 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_33680,inst_33697);
var state_33851__$1 = state_33851;
var statearr_33900_33955 = state_33851__$1;
(statearr_33900_33955[(2)] = inst_33699);

(statearr_33900_33955[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (5))){
var _ = (function (){var statearr_33901 = state_33851;
(statearr_33901[(4)] = cljs.core.rest((state_33851[(4)])));

return statearr_33901;
})();
var state_33851__$1 = state_33851;
var ex33897 = (state_33851__$1[(2)]);
var statearr_33902_33956 = state_33851__$1;
(statearr_33902_33956[(5)] = ex33897);


if((ex33897 instanceof Error)){
var statearr_33903_33957 = state_33851__$1;
(statearr_33903_33957[(1)] = (4));

(statearr_33903_33957[(5)] = null);

} else {
throw ex33897;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (14))){
var inst_33722 = (state_33851[(38)]);
var inst_33716 = (state_33851[(22)]);
var inst_33725 = fluree.db.graphdb.add_predicate_to_idx(inst_33716,inst_33722,opts);
var state_33851__$1 = state_33851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33851__$1,(17),inst_33725);
} else {
if((state_val_33852 === (26))){
var inst_33795 = (state_33851[(15)]);
var inst_33803 = fluree.db.query.schema.schema_map(inst_33795);
var state_33851__$1 = state_33851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33851__$1,(29),inst_33803);
} else {
if((state_val_33852 === (16))){
var inst_33732 = (state_33851[(2)]);
var state_33851__$1 = state_33851;
var statearr_33904_33958 = state_33851__$1;
(statearr_33904_33958[(2)] = inst_33732);

(statearr_33904_33958[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (38))){
var inst_33776 = (state_33851[(12)]);
var state_33851__$1 = state_33851;
var statearr_33905_33959 = state_33851__$1;
(statearr_33905_33959[(2)] = inst_33776);

(statearr_33905_33959[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (30))){
var inst_33810 = (state_33851[(35)]);
var inst_33813 = fluree.db.query.schema.setting_map(inst_33810);
var state_33851__$1 = state_33851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33851__$1,(33),inst_33813);
} else {
if((state_val_33852 === (10))){
var inst_33701 = cljs.core.PersistentVector.EMPTY;
var state_33851__$1 = state_33851;
var statearr_33906_33960 = state_33851__$1;
(statearr_33906_33960[(2)] = inst_33701);

(statearr_33906_33960[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (18))){
var inst_33783 = (state_33851[(26)]);
var inst_33772 = (state_33851[(21)]);
var inst_33782 = cljs.core.seq(inst_33772);
var inst_33783__$1 = cljs.core.first(inst_33782);
var inst_33784 = cljs.core.next(inst_33782);
var inst_33785 = cljs.core.not(inst_33783__$1);
var state_33851__$1 = (function (){var statearr_33907 = state_33851;
(statearr_33907[(18)] = inst_33784);

(statearr_33907[(26)] = inst_33783__$1);

return statearr_33907;
})();
if(inst_33785){
var statearr_33908_33961 = state_33851__$1;
(statearr_33908_33961[(1)] = (20));

} else {
var statearr_33909_33962 = state_33851__$1;
(statearr_33909_33962[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (37))){
var inst_33783 = (state_33851[(26)]);
var inst_33776 = (state_33851[(12)]);
var inst_33838 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33776,inst_33783);
var state_33851__$1 = state_33851;
var statearr_33910_33963 = state_33851__$1;
(statearr_33910_33963[(2)] = inst_33838);

(statearr_33910_33963[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33852 === (8))){
var inst_33663 = (state_33851[(23)]);
var inst_33688 = (state_33851[(24)]);
var inst_33678 = (state_33851[(28)]);
var inst_33680 = (state_33851[(31)]);
var inst_33694 = (state_33851[(14)]);
var inst_33684 = (state_33851[(34)]);
var inst_33678__$1 = (state_33851[(2)]);
var inst_33679 = (function (){var t = inst_33663;
var _ = inst_33678__$1;
return (function (p1__33651_SHARP_){
return cljs.core.not((function (){var G__33911 = p1__33651_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__33911) : fluree.db.graphdb.exclude_predicates.call(null,G__33911));
})());
});
})();
var inst_33680__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_33679,flakes);
var inst_33681 = cljs.core.PersistentHashSet.EMPTY;
var inst_33682 = (function (){var t = inst_33663;
var _ = inst_33678__$1;
var add_flakes = inst_33680__$1;
return (function (p1__33652_SHARP_){
return p1__33652_SHARP_.p;
});
})();
var inst_33683 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33682,inst_33680__$1);
var inst_33684__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33681,inst_33683);
var inst_33685 = cljs.core.PersistentHashMap.EMPTY;
var inst_33686 = (function (){var t = inst_33663;
var _ = inst_33678__$1;
var add_flakes = inst_33680__$1;
var add_preds = inst_33684__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_33687 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33686,inst_33684__$1);
var inst_33688__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33685,inst_33687);
var inst_33689 = cljs.core.PersistentHashMap.EMPTY;
var inst_33690 = (function (){var t = inst_33663;
var _ = inst_33678__$1;
var add_flakes = inst_33680__$1;
var add_preds = inst_33684__$1;
var idx_QMARK__map = inst_33688__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_33691 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33690,inst_33684__$1);
var inst_33692 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33689,inst_33691);
var inst_33693 = fluree.db.flake.size_bytes(inst_33680__$1);
var inst_33694__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_33680__$1);
var inst_33695 = fluree.db.util.schema.setting_change_QMARK_(inst_33680__$1);
var inst_33696 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_33697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33696,(0));
var state_33851__$1 = (function (){var statearr_33912 = state_33851;
(statearr_33912[(24)] = inst_33688__$1);

(statearr_33912[(9)] = inst_33693);

(statearr_33912[(27)] = inst_33695);

(statearr_33912[(28)] = inst_33678__$1);

(statearr_33912[(29)] = inst_33692);

(statearr_33912[(31)] = inst_33680__$1);

(statearr_33912[(32)] = inst_33697);

(statearr_33912[(14)] = inst_33694__$1);

(statearr_33912[(34)] = inst_33684__$1);

return statearr_33912;
})();
if(cljs.core.truth_(inst_33694__$1)){
var statearr_33913_33964 = state_33851__$1;
(statearr_33913_33964[(1)] = (9));

} else {
var statearr_33914_33965 = state_33851__$1;
(statearr_33914_33965[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10841__auto__ = null;
var fluree$db$graphdb$state_machine__10841__auto____0 = (function (){
var statearr_33915 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33915[(0)] = fluree$db$graphdb$state_machine__10841__auto__);

(statearr_33915[(1)] = (1));

return statearr_33915;
});
var fluree$db$graphdb$state_machine__10841__auto____1 = (function (state_33851){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_33851);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e33916){var ex__10844__auto__ = e33916;
var statearr_33917_33966 = state_33851;
(statearr_33917_33966[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_33851[(4)]))){
var statearr_33918_33967 = state_33851;
(statearr_33918_33967[(1)] = cljs.core.first((state_33851[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__33968 = state_33851;
state_33851 = G__33968;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10841__auto__ = function(state_33851){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10841__auto____1.call(this,state_33851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10841__auto____0;
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10841__auto____1;
return fluree$db$graphdb$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_33919 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_33919[(6)] = c__10878__auto__);

return statearr_33919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__33970 = arguments.length;
switch (G__33970) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10878__auto___34117 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34066){
var state_val_34067 = (state_34066[(1)]);
if((state_val_34067 === (7))){
var state_34066__$1 = state_34066;
var statearr_34068_34118 = state_34066__$1;
(statearr_34068_34118[(2)] = null);

(statearr_34068_34118[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (20))){
var inst_34015 = (state_34066[(7)]);
var inst_34016 = (state_34066[(8)]);
var inst_34014 = (state_34066[(9)]);
var inst_34035 = (inst_34014 + (1));
var inst_34036 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34016,cljs.core.cst$kw$t,inst_34035);
var inst_34037 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_34036,inst_34015,opts);
var state_34066__$1 = state_34066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34066__$1,(23),inst_34037);
} else {
if((state_val_34067 === (1))){
var state_34066__$1 = state_34066;
var statearr_34069_34119 = state_34066__$1;
(statearr_34069_34119[(2)] = null);

(statearr_34069_34119[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (24))){
var inst_34040 = (state_34066[(10)]);
var inst_34043 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34040,cljs.core.cst$kw$block,block);
var state_34066__$1 = state_34066;
var statearr_34070_34120 = state_34066__$1;
(statearr_34070_34120[(2)] = inst_34043);

(statearr_34070_34120[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (4))){
var inst_33971 = (state_34066[(2)]);
var inst_33972 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_33971);
var state_34066__$1 = state_34066;
var statearr_34071_34121 = state_34066__$1;
(statearr_34071_34121[(2)] = inst_33972);

(statearr_34071_34121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (15))){
var inst_34022 = (state_34066[(11)]);
var state_34066__$1 = state_34066;
var statearr_34072_34122 = state_34066__$1;
(statearr_34072_34122[(2)] = inst_34022);

(statearr_34072_34122[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (21))){
var state_34066__$1 = state_34066;
var statearr_34073_34123 = state_34066__$1;
(statearr_34073_34123[(2)] = null);

(statearr_34073_34123[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (13))){
var inst_34058 = (state_34066[(2)]);
var inst_34059 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_34058);
var state_34066__$1 = state_34066;
var statearr_34074_34124 = state_34066__$1;
(statearr_34074_34124[(2)] = inst_34059);

(statearr_34074_34124[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (22))){
var inst_34054 = (state_34066[(2)]);
var state_34066__$1 = state_34066;
var statearr_34075_34125 = state_34066__$1;
(statearr_34075_34125[(2)] = inst_34054);

(statearr_34075_34125[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (6))){
var inst_33982 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_33983 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_33984 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33982)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33983)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_33985 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33986 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_33987 = cljs.core.PersistentHashMap.fromArrays(inst_33985,inst_33986);
var inst_33988 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33984,inst_33987);
var inst_33989 = (function(){throw inst_33988})();
var state_34066__$1 = state_34066;
var statearr_34078_34126 = state_34066__$1;
(statearr_34078_34126[(2)] = inst_33989);

(statearr_34078_34126[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (25))){
var inst_34022 = (state_34066[(11)]);
var inst_34023 = (state_34066[(12)]);
var inst_34040 = (state_34066[(10)]);
var inst_34045 = inst_34022.t;
var inst_34046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34047 = [inst_34022];
var inst_34048 = (new cljs.core.PersistentVector(null,1,(5),inst_34046,inst_34047,null));
var inst_34013 = inst_34023;
var inst_34014 = inst_34045;
var inst_34015 = inst_34048;
var inst_34016 = inst_34040;
var state_34066__$1 = (function (){var statearr_34079 = state_34066;
(statearr_34079[(7)] = inst_34015);

(statearr_34079[(8)] = inst_34016);

(statearr_34079[(9)] = inst_34014);

(statearr_34079[(13)] = inst_34013);

return statearr_34079;
})();
var statearr_34080_34127 = state_34066__$1;
(statearr_34080_34127[(2)] = null);

(statearr_34080_34127[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (17))){
var inst_34015 = (state_34066[(7)]);
var inst_34016 = (state_34066[(8)]);
var inst_34014 = (state_34066[(9)]);
var inst_34022 = (state_34066[(11)]);
var inst_34023 = (state_34066[(12)]);
var inst_34031 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34015,inst_34022);
var tmp34076 = inst_34016;
var tmp34077 = inst_34014;
var inst_34013 = inst_34023;
var inst_34014__$1 = tmp34077;
var inst_34015__$1 = inst_34031;
var inst_34016__$1 = tmp34076;
var state_34066__$1 = (function (){var statearr_34081 = state_34066;
(statearr_34081[(7)] = inst_34015__$1);

(statearr_34081[(8)] = inst_34016__$1);

(statearr_34081[(9)] = inst_34014__$1);

(statearr_34081[(13)] = inst_34013);

return statearr_34081;
})();
var statearr_34082_34128 = state_34066__$1;
(statearr_34082_34128[(2)] = null);

(statearr_34082_34128[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (3))){
var inst_34064 = (state_34066[(2)]);
var state_34066__$1 = state_34066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34066__$1,inst_34064);
} else {
if((state_val_34067 === (12))){
var inst_34022 = (state_34066[(11)]);
var inst_34013 = (state_34066[(13)]);
var inst_34021 = cljs.core.seq(inst_34013);
var inst_34022__$1 = cljs.core.first(inst_34021);
var inst_34023 = cljs.core.next(inst_34021);
var state_34066__$1 = (function (){var statearr_34083 = state_34066;
(statearr_34083[(11)] = inst_34022__$1);

(statearr_34083[(12)] = inst_34023);

return statearr_34083;
})();
if(cljs.core.truth_(inst_34022__$1)){
var statearr_34084_34129 = state_34066__$1;
(statearr_34084_34129[(1)] = (14));

} else {
var statearr_34085_34130 = state_34066__$1;
(statearr_34085_34130[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (2))){
var _ = (function (){var statearr_34086 = state_34066;
(statearr_34086[(4)] = cljs.core.cons((5),(state_34066[(4)])));

return statearr_34086;
})();
var inst_33978 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_33979 = (inst_33978 + (1));
var inst_33980 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_33979);
var state_34066__$1 = state_34066;
if(inst_33980){
var statearr_34087_34131 = state_34066__$1;
(statearr_34087_34131[(1)] = (6));

} else {
var statearr_34088_34132 = state_34066__$1;
(statearr_34088_34132[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (23))){
var inst_34022 = (state_34066[(11)]);
var inst_34039 = (state_34066[(2)]);
var inst_34040 = fluree.db.util.async.throw_err(inst_34039);
var inst_34041 = (inst_34022 == null);
var state_34066__$1 = (function (){var statearr_34089 = state_34066;
(statearr_34089[(10)] = inst_34040);

return statearr_34089;
})();
if(cljs.core.truth_(inst_34041)){
var statearr_34090_34133 = state_34066__$1;
(statearr_34090_34133[(1)] = (24));

} else {
var statearr_34091_34134 = state_34066__$1;
(statearr_34091_34134[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (19))){
var inst_34056 = (state_34066[(2)]);
var state_34066__$1 = state_34066;
var statearr_34092_34135 = state_34066__$1;
(statearr_34092_34135[(2)] = inst_34056);

(statearr_34092_34135[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (11))){
var inst_34061 = (state_34066[(2)]);
var _ = (function (){var statearr_34094 = state_34066;
(statearr_34094[(4)] = cljs.core.rest((state_34066[(4)])));

return statearr_34094;
})();
var state_34066__$1 = state_34066;
var statearr_34095_34136 = state_34066__$1;
(statearr_34095_34136[(2)] = inst_34061);

(statearr_34095_34136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (9))){
var inst_33995 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_33996 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_33995);
var state_34066__$1 = state_34066;
var statearr_34096_34137 = state_34066__$1;
(statearr_34096_34137[(2)] = inst_33996);

(statearr_34096_34137[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (5))){
var _ = (function (){var statearr_34097 = state_34066;
(statearr_34097[(4)] = cljs.core.rest((state_34066[(4)])));

return statearr_34097;
})();
var state_34066__$1 = state_34066;
var ex34093 = (state_34066__$1[(2)]);
var statearr_34098_34138 = state_34066__$1;
(statearr_34098_34138[(5)] = ex34093);


var statearr_34099_34139 = state_34066__$1;
(statearr_34099_34139[(1)] = (4));

(statearr_34099_34139[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (14))){
var inst_34014 = (state_34066[(9)]);
var inst_34022 = (state_34066[(11)]);
var inst_34025 = inst_34022.t;
var inst_34026 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34014,inst_34025);
var state_34066__$1 = state_34066;
var statearr_34100_34140 = state_34066__$1;
(statearr_34100_34140[(2)] = inst_34026);

(statearr_34100_34140[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (26))){
var inst_34051 = (state_34066[(2)]);
var state_34066__$1 = state_34066;
var statearr_34101_34141 = state_34066__$1;
(statearr_34101_34141[(2)] = inst_34051);

(statearr_34101_34141[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (16))){
var inst_34029 = (state_34066[(2)]);
var state_34066__$1 = state_34066;
if(cljs.core.truth_(inst_34029)){
var statearr_34102_34142 = state_34066__$1;
(statearr_34102_34142[(1)] = (17));

} else {
var statearr_34103_34143 = state_34066__$1;
(statearr_34103_34143[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (10))){
var inst_33998 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_34006 = cljs.core.seq(inst_33998);
var inst_34007 = cljs.core.first(inst_34006);
var inst_34008 = cljs.core.next(inst_34006);
var inst_34009 = cljs.core.first(inst_33998);
var inst_34010 = inst_34009.t;
var inst_34011 = cljs.core.PersistentVector.EMPTY;
var inst_34012 = db;
var inst_34013 = inst_33998;
var inst_34014 = inst_34010;
var inst_34015 = inst_34011;
var inst_34016 = inst_34012;
var state_34066__$1 = (function (){var statearr_34104 = state_34066;
(statearr_34104[(14)] = inst_34007);

(statearr_34104[(7)] = inst_34015);

(statearr_34104[(8)] = inst_34016);

(statearr_34104[(9)] = inst_34014);

(statearr_34104[(15)] = inst_34008);

(statearr_34104[(13)] = inst_34013);

return statearr_34104;
})();
var statearr_34105_34144 = state_34066__$1;
(statearr_34105_34144[(2)] = null);

(statearr_34105_34144[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (18))){
var state_34066__$1 = state_34066;
var statearr_34106_34145 = state_34066__$1;
(statearr_34106_34145[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34067 === (8))){
var inst_33992 = (state_34066[(2)]);
var inst_33993 = cljs.core.empty_QMARK_(flakes);
var state_34066__$1 = (function (){var statearr_34108 = state_34066;
(statearr_34108[(16)] = inst_33992);

return statearr_34108;
})();
if(inst_33993){
var statearr_34109_34146 = state_34066__$1;
(statearr_34109_34146[(1)] = (9));

} else {
var statearr_34110_34147 = state_34066__$1;
(statearr_34110_34147[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10841__auto__ = null;
var fluree$db$graphdb$state_machine__10841__auto____0 = (function (){
var statearr_34111 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34111[(0)] = fluree$db$graphdb$state_machine__10841__auto__);

(statearr_34111[(1)] = (1));

return statearr_34111;
});
var fluree$db$graphdb$state_machine__10841__auto____1 = (function (state_34066){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34066);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34112){var ex__10844__auto__ = e34112;
var statearr_34113_34148 = state_34066;
(statearr_34113_34148[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34066[(4)]))){
var statearr_34114_34149 = state_34066;
(statearr_34114_34149[(1)] = cljs.core.first((state_34066[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34150 = state_34066;
state_34066 = G__34150;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10841__auto__ = function(state_34066){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10841__auto____1.call(this,state_34066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10841__auto____0;
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10841__auto____1;
return fluree$db$graphdb$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34115 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34115[(6)] = c__10878__auto___34117);

return statearr_34115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34206){
var state_val_34207 = (state_34206[(1)]);
if((state_val_34207 === (7))){
var state_34206__$1 = state_34206;
var statearr_34208_34235 = state_34206__$1;
(statearr_34208_34235[(2)] = tt_id);

(statearr_34208_34235[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (1))){
var state_34206__$1 = state_34206;
var statearr_34209_34236 = state_34206__$1;
(statearr_34209_34236[(2)] = null);

(statearr_34209_34236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (4))){
var inst_34151 = (state_34206[(2)]);
var state_34206__$1 = state_34206;
var statearr_34210_34237 = state_34206__$1;
(statearr_34210_34237[(2)] = inst_34151);

(statearr_34210_34237[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (13))){
var inst_34199 = (state_34206[(2)]);
var state_34206__$1 = state_34206;
var statearr_34211_34238 = state_34206__$1;
(statearr_34211_34238[(2)] = inst_34199);

(statearr_34211_34238[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (6))){
var inst_34159 = fluree.db.util.core.random_uuid();
var state_34206__$1 = state_34206;
var statearr_34212_34239 = state_34206__$1;
(statearr_34212_34239[(2)] = inst_34159);

(statearr_34212_34239[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (3))){
var inst_34204 = (state_34206[(2)]);
var state_34206__$1 = state_34206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34206__$1,inst_34204);
} else {
if((state_val_34207 === (12))){
var inst_34182 = (state_34206[(7)]);
var state_34206__$1 = state_34206;
var statearr_34213_34240 = state_34206__$1;
(statearr_34213_34240[(2)] = inst_34182);

(statearr_34213_34240[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (2))){
var _ = (function (){var statearr_34214 = state_34206;
(statearr_34214[(4)] = cljs.core.cons((5),(state_34206[(4)])));

return statearr_34214;
})();
var inst_34157 = (tt_id == null);
var state_34206__$1 = state_34206;
if(cljs.core.truth_(inst_34157)){
var statearr_34215_34241 = state_34206__$1;
(statearr_34215_34241[(1)] = (6));

} else {
var statearr_34216_34242 = state_34206__$1;
(statearr_34216_34242[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (11))){
var inst_34182 = (state_34206[(7)]);
var inst_34189 = (state_34206[(8)]);
var inst_34192 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_34182,inst_34189);
var state_34206__$1 = state_34206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34206__$1,(14),inst_34192);
} else {
if((state_val_34207 === (9))){
var inst_34183 = (state_34206[(9)]);
var inst_34189 = (state_34206[(8)]);
var inst_34188 = cljs.core.seq(inst_34183);
var inst_34189__$1 = cljs.core.first(inst_34188);
var inst_34190 = cljs.core.next(inst_34188);
var state_34206__$1 = (function (){var statearr_34218 = state_34206;
(statearr_34218[(10)] = inst_34190);

(statearr_34218[(8)] = inst_34189__$1);

return statearr_34218;
})();
if(cljs.core.truth_(inst_34189__$1)){
var statearr_34219_34243 = state_34206__$1;
(statearr_34219_34243[(1)] = (11));

} else {
var statearr_34220_34244 = state_34206__$1;
(statearr_34220_34244[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (5))){
var _ = (function (){var statearr_34221 = state_34206;
(statearr_34221[(4)] = cljs.core.rest((state_34206[(4)])));

return statearr_34221;
})();
var state_34206__$1 = state_34206;
var ex34217 = (state_34206__$1[(2)]);
var statearr_34222_34245 = state_34206__$1;
(statearr_34222_34245[(5)] = ex34217);


if((ex34217 instanceof Error)){
var statearr_34223_34246 = state_34206__$1;
(statearr_34223_34246[(1)] = (4));

(statearr_34223_34246[(5)] = null);

} else {
throw ex34217;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (14))){
var inst_34190 = (state_34206[(10)]);
var inst_34194 = (state_34206[(2)]);
var inst_34195 = fluree.db.util.async.throw_err(inst_34194);
var inst_34182 = inst_34195;
var inst_34183 = inst_34190;
var state_34206__$1 = (function (){var statearr_34224 = state_34206;
(statearr_34224[(9)] = inst_34183);

(statearr_34224[(7)] = inst_34182);

return statearr_34224;
})();
var statearr_34225_34247 = state_34206__$1;
(statearr_34225_34247[(2)] = null);

(statearr_34225_34247[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (10))){
var inst_34201 = (state_34206[(2)]);
var _ = (function (){var statearr_34226 = state_34206;
(statearr_34226[(4)] = cljs.core.rest((state_34206[(4)])));

return statearr_34226;
})();
var state_34206__$1 = state_34206;
var statearr_34227_34248 = state_34206__$1;
(statearr_34227_34248[(2)] = inst_34201);

(statearr_34227_34248[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34207 === (8))){
var inst_34162 = (state_34206[(2)]);
var inst_34163 = (function (){var tt_id_SINGLEQUOTE_ = inst_34162;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_34164 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_34162);
var inst_34165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34166 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_34167 = (new cljs.core.PersistentVector(null,4,(5),inst_34165,inst_34166,null));
var inst_34168 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34163,inst_34164,inst_34167);
var inst_34169 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_34170 = cljs.core.reverse(inst_34169);
var inst_34171 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_34170);
var inst_34179 = cljs.core.seq(inst_34171);
var inst_34180 = cljs.core.first(inst_34179);
var inst_34181 = cljs.core.next(inst_34179);
var inst_34182 = inst_34168;
var inst_34183 = inst_34171;
var state_34206__$1 = (function (){var statearr_34228 = state_34206;
(statearr_34228[(9)] = inst_34183);

(statearr_34228[(11)] = inst_34180);

(statearr_34228[(7)] = inst_34182);

(statearr_34228[(12)] = inst_34181);

return statearr_34228;
})();
var statearr_34229_34249 = state_34206__$1;
(statearr_34229_34249[(2)] = null);

(statearr_34229_34249[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto____0 = (function (){
var statearr_34230 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34230[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto__);

(statearr_34230[(1)] = (1));

return statearr_34230;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto____1 = (function (state_34206){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34206);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34231){var ex__10844__auto__ = e34231;
var statearr_34232_34250 = state_34206;
(statearr_34232_34250[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34206[(4)]))){
var statearr_34233_34251 = state_34206;
(statearr_34233_34251[(1)] = cljs.core.first((state_34206[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34252 = state_34206;
state_34206 = G__34252;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto__ = function(state_34206){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto____1.call(this,state_34206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34234 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34234[(6)] = c__10878__auto__);

return statearr_34234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10878__auto___34439 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34370){
var state_val_34371 = (state_34370[(1)]);
if((state_val_34371 === (7))){
var inst_34280 = (state_34370[(7)]);
var inst_34280__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_34370__$1 = (function (){var statearr_34372 = state_34370;
(statearr_34372[(7)] = inst_34280__$1);

return statearr_34372;
})();
if(inst_34280__$1){
var statearr_34373_34440 = state_34370__$1;
(statearr_34373_34440[(1)] = (13));

} else {
var statearr_34374_34441 = state_34370__$1;
(statearr_34374_34441[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (20))){
var state_34370__$1 = state_34370;
var statearr_34375_34442 = state_34370__$1;
(statearr_34375_34442[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (27))){
var inst_34316 = (state_34370[(8)]);
var inst_34320 = inst_34316.s;
var state_34370__$1 = state_34370;
var statearr_34377_34443 = state_34370__$1;
(statearr_34377_34443[(2)] = inst_34320);

(statearr_34377_34443[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (1))){
var state_34370__$1 = state_34370;
var statearr_34378_34444 = state_34370__$1;
(statearr_34378_34444[(2)] = null);

(statearr_34378_34444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (24))){
var inst_34310 = (state_34370[(9)]);
var inst_34314 = cljs.core.first(inst_34310);
var state_34370__$1 = state_34370;
var statearr_34379_34445 = state_34370__$1;
(statearr_34379_34445[(2)] = inst_34314);

(statearr_34379_34445[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (39))){
var state_34370__$1 = state_34370;
var statearr_34380_34446 = state_34370__$1;
(statearr_34380_34446[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (4))){
var inst_34253 = (state_34370[(2)]);
var inst_34254 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_34255 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34256 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_34257 = cljs.core.PersistentHashMap.fromArrays(inst_34255,inst_34256);
var inst_34258 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_34254,inst_34257,inst_34253);
var inst_34259 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_34258);
var state_34370__$1 = state_34370;
var statearr_34382_34447 = state_34370__$1;
(statearr_34382_34447[(2)] = inst_34259);

(statearr_34382_34447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (15))){
var inst_34287 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
if(cljs.core.truth_(inst_34287)){
var statearr_34383_34448 = state_34370__$1;
(statearr_34383_34448[(1)] = (16));

} else {
var statearr_34384_34449 = state_34370__$1;
(statearr_34384_34449[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (21))){
var inst_34336 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
var statearr_34385_34450 = state_34370__$1;
(statearr_34385_34450[(2)] = inst_34336);

(statearr_34385_34450[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (31))){
var inst_34334 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
var statearr_34386_34451 = state_34370__$1;
(statearr_34386_34451[(2)] = inst_34334);

(statearr_34386_34451[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (32))){
var inst_34340 = (state_34370[(10)]);
var inst_34342 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_34340);
var state_34370__$1 = state_34370;
var statearr_34387_34452 = state_34370__$1;
(statearr_34387_34452[(2)] = inst_34342);

(statearr_34387_34452[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (40))){
var inst_34363 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
var statearr_34388_34453 = state_34370__$1;
(statearr_34388_34453[(2)] = inst_34363);

(statearr_34388_34453[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (33))){
var inst_34344 = (state_34370[(11)]);
var inst_34340 = (state_34370[(10)]);
var inst_34344__$1 = (inst_34340 == null);
var state_34370__$1 = (function (){var statearr_34389 = state_34370;
(statearr_34389[(11)] = inst_34344__$1);

return statearr_34389;
})();
if(cljs.core.truth_(inst_34344__$1)){
var statearr_34390_34454 = state_34370__$1;
(statearr_34390_34454[(1)] = (35));

} else {
var statearr_34391_34455 = state_34370__$1;
(statearr_34391_34455[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (13))){
var inst_34282 = cljs.core.first(ident);
var inst_34283 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_34282);
var inst_34284 = (inst_34283 == null);
var state_34370__$1 = state_34370;
var statearr_34392_34456 = state_34370__$1;
(statearr_34392_34456[(2)] = inst_34284);

(statearr_34392_34456[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (22))){
var inst_34310 = (state_34370[(9)]);
var inst_34309 = (state_34370[(2)]);
var inst_34310__$1 = fluree.db.util.async.throw_err(inst_34309);
var inst_34311 = (inst_34310__$1 == null);
var state_34370__$1 = (function (){var statearr_34393 = state_34370;
(statearr_34393[(9)] = inst_34310__$1);

return statearr_34393;
})();
if(cljs.core.truth_(inst_34311)){
var statearr_34394_34457 = state_34370__$1;
(statearr_34394_34457[(1)] = (23));

} else {
var statearr_34395_34458 = state_34370__$1;
(statearr_34395_34458[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (36))){
var inst_34344 = (state_34370[(11)]);
var state_34370__$1 = state_34370;
var statearr_34396_34459 = state_34370__$1;
(statearr_34396_34459[(2)] = inst_34344);

(statearr_34396_34459[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (41))){
var inst_34358 = cljs.core.async.close_BANG_(return_chan);
var state_34370__$1 = state_34370;
var statearr_34397_34460 = state_34370__$1;
(statearr_34397_34460[(2)] = inst_34358);

(statearr_34397_34460[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (43))){
var inst_34361 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
var statearr_34398_34461 = state_34370__$1;
(statearr_34398_34461[(2)] = inst_34361);

(statearr_34398_34461[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (29))){
var inst_34325 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_34326 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_34325].join('');
var inst_34327 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34328 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_34329 = cljs.core.PersistentHashMap.fromArrays(inst_34327,inst_34328);
var inst_34330 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34326,inst_34329);
var inst_34331 = (function(){throw inst_34330})();
var state_34370__$1 = state_34370;
var statearr_34399_34462 = state_34370__$1;
(statearr_34399_34462[(2)] = inst_34331);

(statearr_34399_34462[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (6))){
var inst_34267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34268 = [ident];
var inst_34269 = (new cljs.core.PersistentVector(null,1,(5),inst_34267,inst_34268,null));
var inst_34270 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34269);
var state_34370__$1 = state_34370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34370__$1,(9),inst_34270);
} else {
if((state_val_34371 === (28))){
var inst_34322 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
var statearr_34400_34463 = state_34370__$1;
(statearr_34400_34463[(2)] = inst_34322);

(statearr_34400_34463[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (25))){
var inst_34316 = (state_34370[(8)]);
var inst_34316__$1 = (state_34370[(2)]);
var inst_34317 = (inst_34316__$1 == null);
var state_34370__$1 = (function (){var statearr_34401 = state_34370;
(statearr_34401[(8)] = inst_34316__$1);

return statearr_34401;
})();
if(cljs.core.truth_(inst_34317)){
var statearr_34402_34464 = state_34370__$1;
(statearr_34402_34464[(1)] = (26));

} else {
var statearr_34403_34465 = state_34370__$1;
(statearr_34403_34465[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (34))){
var inst_34365 = (state_34370[(2)]);
var _ = (function (){var statearr_34404 = state_34370;
(statearr_34404[(4)] = cljs.core.rest((state_34370[(4)])));

return statearr_34404;
})();
var state_34370__$1 = state_34370;
var statearr_34405_34466 = state_34370__$1;
(statearr_34405_34466[(2)] = inst_34365);

(statearr_34405_34466[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (17))){
var inst_34298 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_34370__$1 = state_34370;
if(inst_34298){
var statearr_34406_34467 = state_34370__$1;
(statearr_34406_34467[(1)] = (19));

} else {
var statearr_34407_34468 = state_34370__$1;
(statearr_34407_34468[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (3))){
var inst_34368 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34370__$1,inst_34368);
} else {
if((state_val_34371 === (12))){
var inst_34278 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
var statearr_34408_34469 = state_34370__$1;
(statearr_34408_34469[(2)] = inst_34278);

(statearr_34408_34469[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (2))){
var _ = (function (){var statearr_34409 = state_34370;
(statearr_34409[(4)] = cljs.core.cons((5),(state_34370[(4)])));

return statearr_34409;
})();
var inst_34265 = typeof ident === 'number';
var state_34370__$1 = state_34370;
if(cljs.core.truth_(inst_34265)){
var statearr_34410_34470 = state_34370__$1;
(statearr_34410_34470[(1)] = (6));

} else {
var statearr_34411_34471 = state_34370__$1;
(statearr_34411_34471[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (23))){
var state_34370__$1 = state_34370;
var statearr_34412_34472 = state_34370__$1;
(statearr_34412_34472[(2)] = null);

(statearr_34412_34472[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (35))){
var state_34370__$1 = state_34370;
var statearr_34413_34473 = state_34370__$1;
(statearr_34413_34473[(2)] = strict_QMARK_);

(statearr_34413_34473[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (19))){
var inst_34301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34302 = cljs.core.first(ident);
var inst_34303 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_34302);
var inst_34304 = cljs.core.second(ident);
var inst_34305 = [inst_34303,inst_34304];
var inst_34306 = (new cljs.core.PersistentVector(null,2,(5),inst_34301,inst_34305,null));
var inst_34307 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_34306);
var state_34370__$1 = state_34370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34370__$1,(22),inst_34307);
} else {
if((state_val_34371 === (11))){
var state_34370__$1 = state_34370;
var statearr_34415_34474 = state_34370__$1;
(statearr_34415_34474[(2)] = null);

(statearr_34415_34474[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (9))){
var inst_34272 = (state_34370[(2)]);
var inst_34273 = fluree.db.util.async.throw_err(inst_34272);
var inst_34274 = cljs.core.not_empty(inst_34273);
var state_34370__$1 = state_34370;
if(cljs.core.truth_(inst_34274)){
var statearr_34416_34475 = state_34370__$1;
(statearr_34416_34475[(1)] = (10));

} else {
var statearr_34417_34476 = state_34370__$1;
(statearr_34417_34476[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (5))){
var _ = (function (){var statearr_34418 = state_34370;
(statearr_34418[(4)] = cljs.core.rest((state_34370[(4)])));

return statearr_34418;
})();
var state_34370__$1 = state_34370;
var ex34414 = (state_34370__$1[(2)]);
var statearr_34419_34477 = state_34370__$1;
(statearr_34419_34477[(5)] = ex34414);


var statearr_34420_34478 = state_34370__$1;
(statearr_34420_34478[(1)] = (4));

(statearr_34420_34478[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (14))){
var inst_34280 = (state_34370[(7)]);
var state_34370__$1 = state_34370;
var statearr_34421_34479 = state_34370__$1;
(statearr_34421_34479[(2)] = inst_34280);

(statearr_34421_34479[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (26))){
var state_34370__$1 = state_34370;
var statearr_34422_34480 = state_34370__$1;
(statearr_34422_34480[(2)] = null);

(statearr_34422_34480[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (16))){
var inst_34289 = cljs.core.first(ident);
var inst_34290 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34289], 0));
var inst_34291 = ["Subject ID lookup failed. The predicate ",inst_34290," does not exist."].join('');
var inst_34292 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34293 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_34294 = cljs.core.PersistentHashMap.fromArrays(inst_34292,inst_34293);
var inst_34295 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34291,inst_34294);
var inst_34296 = (function(){throw inst_34295})();
var state_34370__$1 = state_34370;
var statearr_34423_34481 = state_34370__$1;
(statearr_34423_34481[(2)] = inst_34296);

(statearr_34423_34481[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (38))){
var inst_34350 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_34351 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34352 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_34353 = cljs.core.PersistentHashMap.fromArrays(inst_34351,inst_34352);
var inst_34354 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34350,inst_34353);
var inst_34355 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_34354);
var state_34370__$1 = state_34370;
var statearr_34424_34482 = state_34370__$1;
(statearr_34424_34482[(2)] = inst_34355);

(statearr_34424_34482[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (30))){
var state_34370__$1 = state_34370;
var statearr_34425_34483 = state_34370__$1;
(statearr_34425_34483[(2)] = null);

(statearr_34425_34483[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (10))){
var state_34370__$1 = state_34370;
var statearr_34426_34484 = state_34370__$1;
(statearr_34426_34484[(2)] = ident);

(statearr_34426_34484[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (18))){
var inst_34338 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
var statearr_34427_34485 = state_34370__$1;
(statearr_34427_34485[(2)] = inst_34338);

(statearr_34427_34485[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (42))){
var state_34370__$1 = state_34370;
var statearr_34428_34486 = state_34370__$1;
(statearr_34428_34486[(2)] = null);

(statearr_34428_34486[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (37))){
var inst_34348 = (state_34370[(2)]);
var state_34370__$1 = state_34370;
if(cljs.core.truth_(inst_34348)){
var statearr_34429_34487 = state_34370__$1;
(statearr_34429_34487[(1)] = (38));

} else {
var statearr_34430_34488 = state_34370__$1;
(statearr_34430_34488[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34371 === (8))){
var inst_34340 = (state_34370[(10)]);
var inst_34340__$1 = (state_34370[(2)]);
var state_34370__$1 = (function (){var statearr_34431 = state_34370;
(statearr_34431[(10)] = inst_34340__$1);

return statearr_34431;
})();
if(cljs.core.truth_(inst_34340__$1)){
var statearr_34432_34489 = state_34370__$1;
(statearr_34432_34489[(1)] = (32));

} else {
var statearr_34433_34490 = state_34370__$1;
(statearr_34433_34490[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__10841__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__10841__auto____0 = (function (){
var statearr_34434 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34434[(0)] = fluree$db$graphdb$subid_$_state_machine__10841__auto__);

(statearr_34434[(1)] = (1));

return statearr_34434;
});
var fluree$db$graphdb$subid_$_state_machine__10841__auto____1 = (function (state_34370){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34370);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34435){var ex__10844__auto__ = e34435;
var statearr_34436_34491 = state_34370;
(statearr_34436_34491[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34370[(4)]))){
var statearr_34437_34492 = state_34370;
(statearr_34437_34492[(1)] = cljs.core.first((state_34370[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34493 = state_34370;
state_34370 = G__34493;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__10841__auto__ = function(state_34370){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__10841__auto____1.call(this,state_34370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__10841__auto____0;
fluree$db$graphdb$subid_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__10841__auto____1;
return fluree$db$graphdb$subid_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34438 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34438[(6)] = c__10878__auto___34439);

return statearr_34438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k34495,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__34499 = k34495;
var G__34499__$1 = (((G__34499 instanceof cljs.core.Keyword))?G__34499.fqn:null);
switch (G__34499__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34495,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__34500){
var vec__34501 = p__34500;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34501,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34501,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34494){
var self__ = this;
var G__34494__$1 = this;
return (new cljs.core.RecordIter((0),G__34494__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__34504 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__34504(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34496,other34497){
var self__ = this;
var this34496__$1 = this;
return (((!((other34497 == null)))) && ((((this34496__$1.constructor === other34497.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.conn,other34497.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.network,other34497.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.dbid,other34497.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.block,other34497.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.t,other34497.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.tt_id,other34497.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.stats,other34497.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.spot,other34497.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.psot,other34497.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.post,other34497.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.opst,other34497.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.schema,other34497.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.settings,other34497.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.index_configs,other34497.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.schema_cache,other34497.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.novelty,other34497.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.permissions,other34497.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.fork,other34497.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.fork_block,other34497.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.current_db_fn,other34497.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34496__$1.__extmap,other34497.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k34495){
var self__ = this;
var this__4479__auto____$1 = this;
var G__34505 = k34495;
var G__34505__$1 = (((G__34505 instanceof cljs.core.Keyword))?G__34505.fqn:null);
switch (G__34505__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34495);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__34494){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__34506 = cljs.core.keyword_identical_QMARK_;
var expr__34507 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__34509 = cljs.core.cst$kw$conn;
var G__34510 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34509,G__34510) : pred__34506.call(null,G__34509,G__34510));
})())){
return (new fluree.db.graphdb.GraphDb(G__34494,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34511 = cljs.core.cst$kw$network;
var G__34512 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34511,G__34512) : pred__34506.call(null,G__34511,G__34512));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__34494,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34513 = cljs.core.cst$kw$dbid;
var G__34514 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34513,G__34514) : pred__34506.call(null,G__34513,G__34514));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__34494,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34515 = cljs.core.cst$kw$block;
var G__34516 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34515,G__34516) : pred__34506.call(null,G__34515,G__34516));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__34494,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34517 = cljs.core.cst$kw$t;
var G__34518 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34517,G__34518) : pred__34506.call(null,G__34517,G__34518));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__34494,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34519 = cljs.core.cst$kw$tt_DASH_id;
var G__34520 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34519,G__34520) : pred__34506.call(null,G__34519,G__34520));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__34494,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34521 = cljs.core.cst$kw$stats;
var G__34522 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34521,G__34522) : pred__34506.call(null,G__34521,G__34522));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__34494,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34523 = cljs.core.cst$kw$spot;
var G__34524 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34523,G__34524) : pred__34506.call(null,G__34523,G__34524));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__34494,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34525 = cljs.core.cst$kw$psot;
var G__34526 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34525,G__34526) : pred__34506.call(null,G__34525,G__34526));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__34494,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34527 = cljs.core.cst$kw$post;
var G__34528 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34527,G__34528) : pred__34506.call(null,G__34527,G__34528));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__34494,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34529 = cljs.core.cst$kw$opst;
var G__34530 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34529,G__34530) : pred__34506.call(null,G__34529,G__34530));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__34494,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34531 = cljs.core.cst$kw$schema;
var G__34532 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34531,G__34532) : pred__34506.call(null,G__34531,G__34532));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__34494,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34533 = cljs.core.cst$kw$settings;
var G__34534 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34533,G__34534) : pred__34506.call(null,G__34533,G__34534));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__34494,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34535 = cljs.core.cst$kw$index_DASH_configs;
var G__34536 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34535,G__34536) : pred__34506.call(null,G__34535,G__34536));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__34494,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34537 = cljs.core.cst$kw$schema_DASH_cache;
var G__34538 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34537,G__34538) : pred__34506.call(null,G__34537,G__34538));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__34494,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34539 = cljs.core.cst$kw$novelty;
var G__34540 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34539,G__34540) : pred__34506.call(null,G__34539,G__34540));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__34494,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34541 = cljs.core.cst$kw$permissions;
var G__34542 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34541,G__34542) : pred__34506.call(null,G__34541,G__34542));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__34494,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34543 = cljs.core.cst$kw$fork;
var G__34544 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34543,G__34544) : pred__34506.call(null,G__34543,G__34544));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__34494,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34545 = cljs.core.cst$kw$fork_DASH_block;
var G__34546 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34545,G__34546) : pred__34506.call(null,G__34545,G__34546));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__34494,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34547 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__34548 = expr__34507;
return (pred__34506.cljs$core$IFn$_invoke$arity$2 ? pred__34506.cljs$core$IFn$_invoke$arity$2(G__34547,G__34548) : pred__34506.call(null,G__34547,G__34548));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__34494,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__34494),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__34494){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__34494,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34564){
var state_val_34565 = (state_34564[(1)]);
if((state_val_34565 === (1))){
var state_34564__$1 = state_34564;
var statearr_34566_34833 = state_34564__$1;
(statearr_34566_34833[(2)] = null);

(statearr_34566_34833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34565 === (2))){
var _ = (function (){var statearr_34567 = state_34564;
(statearr_34567[(4)] = cljs.core.cons((5),(state_34564[(4)])));

return statearr_34567;
})();
var inst_34555 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_34564__$1 = state_34564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34564__$1,(6),inst_34555);
} else {
if((state_val_34565 === (3))){
var inst_34562 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34564__$1,inst_34562);
} else {
if((state_val_34565 === (4))){
var inst_34549 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
var statearr_34569_34834 = state_34564__$1;
(statearr_34569_34834[(2)] = inst_34549);

(statearr_34569_34834[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34565 === (5))){
var _ = (function (){var statearr_34570 = state_34564;
(statearr_34570[(4)] = cljs.core.rest((state_34564[(4)])));

return statearr_34570;
})();
var state_34564__$1 = state_34564;
var ex34568 = (state_34564__$1[(2)]);
var statearr_34571_34835 = state_34564__$1;
(statearr_34571_34835[(5)] = ex34568);


if((ex34568 instanceof Error)){
var statearr_34572_34836 = state_34564__$1;
(statearr_34572_34836[(1)] = (4));

(statearr_34572_34836[(5)] = null);

} else {
throw ex34568;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34565 === (6))){
var inst_34557 = (state_34564[(2)]);
var inst_34558 = fluree.db.util.async.throw_err(inst_34557);
var inst_34559 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34558,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_34573 = state_34564;
(statearr_34573[(4)] = cljs.core.rest((state_34564[(4)])));

return statearr_34573;
})();
var state_34564__$1 = state_34564;
var statearr_34574_34837 = state_34564__$1;
(statearr_34574_34837[(2)] = inst_34559);

(statearr_34574_34837[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10841__auto__ = null;
var fluree$db$graphdb$state_machine__10841__auto____0 = (function (){
var statearr_34575 = [null,null,null,null,null,null,null];
(statearr_34575[(0)] = fluree$db$graphdb$state_machine__10841__auto__);

(statearr_34575[(1)] = (1));

return statearr_34575;
});
var fluree$db$graphdb$state_machine__10841__auto____1 = (function (state_34564){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34564);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34576){var ex__10844__auto__ = e34576;
var statearr_34577_34838 = state_34564;
(statearr_34577_34838[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34564[(4)]))){
var statearr_34578_34839 = state_34564;
(statearr_34578_34839[(1)] = cljs.core.first((state_34564[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34840 = state_34564;
state_34564 = G__34840;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10841__auto__ = function(state_34564){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10841__auto____1.call(this,state_34564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10841__auto____0;
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10841__auto____1;
return fluree$db$graphdb$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34579 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34579[(6)] = c__10878__auto__);

return statearr_34579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__34580 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__34580.cljs$core$IFn$_invoke$arity$1 ? fexpr__34580.cljs$core$IFn$_invoke$arity$1(property) : fexpr__34580.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__34581 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__34581.cljs$core$IFn$_invoke$arity$1 ? fexpr__34581.cljs$core$IFn$_invoke$arity$1(property) : fexpr__34581.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__34582 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$partition,G__34582);
} else {
return G__34582;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34614){
var state_val_34615 = (state_34614[(1)]);
if((state_val_34615 === (7))){
var state_34614__$1 = state_34614;
var statearr_34616_34841 = state_34614__$1;
(statearr_34616_34841[(2)] = null);

(statearr_34616_34841[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (1))){
var state_34614__$1 = state_34614;
var statearr_34617_34842 = state_34614__$1;
(statearr_34617_34842[(2)] = null);

(statearr_34617_34842[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (4))){
var inst_34583 = (state_34614[(2)]);
var state_34614__$1 = state_34614;
var statearr_34618_34843 = state_34614__$1;
(statearr_34618_34843[(2)] = inst_34583);

(statearr_34618_34843[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (6))){
var inst_34597 = (state_34614[(7)]);
var inst_34596 = (state_34614[(2)]);
var inst_34597__$1 = fluree.db.util.async.throw_err(inst_34596);
var inst_34598 = (inst_34597__$1 == null);
var state_34614__$1 = (function (){var statearr_34619 = state_34614;
(statearr_34619[(7)] = inst_34597__$1);

return statearr_34619;
})();
if(cljs.core.truth_(inst_34598)){
var statearr_34620_34844 = state_34614__$1;
(statearr_34620_34844[(1)] = (7));

} else {
var statearr_34621_34845 = state_34614__$1;
(statearr_34621_34845[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (3))){
var inst_34612 = (state_34614[(2)]);
var state_34614__$1 = state_34614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34614__$1,inst_34612);
} else {
if((state_val_34615 === (12))){
var inst_34609 = (state_34614[(2)]);
var _ = (function (){var statearr_34622 = state_34614;
(statearr_34622[(4)] = cljs.core.rest((state_34614[(4)])));

return statearr_34622;
})();
var state_34614__$1 = state_34614;
var statearr_34623_34846 = state_34614__$1;
(statearr_34623_34846[(2)] = inst_34609);

(statearr_34623_34846[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (2))){
var _ = (function (){var statearr_34624 = state_34614;
(statearr_34624[(4)] = cljs.core.cons((5),(state_34614[(4)])));

return statearr_34624;
})();
var inst_34590 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_34591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34592 = [tag_id,(30)];
var inst_34593 = (new cljs.core.PersistentVector(null,2,(5),inst_34591,inst_34592,null));
var inst_34594 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_34590,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34593);
var state_34614__$1 = state_34614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34614__$1,(6),inst_34594);
} else {
if((state_val_34615 === (11))){
var inst_34603 = (state_34614[(8)]);
var inst_34607 = inst_34603.o;
var state_34614__$1 = state_34614;
var statearr_34626_34847 = state_34614__$1;
(statearr_34626_34847[(2)] = inst_34607);

(statearr_34626_34847[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (9))){
var inst_34603 = (state_34614[(8)]);
var inst_34603__$1 = (state_34614[(2)]);
var inst_34604 = (inst_34603__$1 == null);
var state_34614__$1 = (function (){var statearr_34627 = state_34614;
(statearr_34627[(8)] = inst_34603__$1);

return statearr_34627;
})();
if(cljs.core.truth_(inst_34604)){
var statearr_34628_34848 = state_34614__$1;
(statearr_34628_34848[(1)] = (10));

} else {
var statearr_34629_34849 = state_34614__$1;
(statearr_34629_34849[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (5))){
var _ = (function (){var statearr_34630 = state_34614;
(statearr_34630[(4)] = cljs.core.rest((state_34614[(4)])));

return statearr_34630;
})();
var state_34614__$1 = state_34614;
var ex34625 = (state_34614__$1[(2)]);
var statearr_34631_34850 = state_34614__$1;
(statearr_34631_34850[(5)] = ex34625);


if((ex34625 instanceof Error)){
var statearr_34632_34851 = state_34614__$1;
(statearr_34632_34851[(1)] = (4));

(statearr_34632_34851[(5)] = null);

} else {
throw ex34625;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (10))){
var state_34614__$1 = state_34614;
var statearr_34633_34852 = state_34614__$1;
(statearr_34633_34852[(2)] = null);

(statearr_34633_34852[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34615 === (8))){
var inst_34597 = (state_34614[(7)]);
var inst_34601 = cljs.core.first(inst_34597);
var state_34614__$1 = state_34614;
var statearr_34634_34853 = state_34614__$1;
(statearr_34634_34853[(2)] = inst_34601);

(statearr_34634_34853[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10841__auto__ = null;
var fluree$db$graphdb$state_machine__10841__auto____0 = (function (){
var statearr_34635 = [null,null,null,null,null,null,null,null,null];
(statearr_34635[(0)] = fluree$db$graphdb$state_machine__10841__auto__);

(statearr_34635[(1)] = (1));

return statearr_34635;
});
var fluree$db$graphdb$state_machine__10841__auto____1 = (function (state_34614){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34614);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34636){var ex__10844__auto__ = e34636;
var statearr_34637_34854 = state_34614;
(statearr_34637_34854[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34614[(4)]))){
var statearr_34638_34855 = state_34614;
(statearr_34638_34855[(1)] = cljs.core.first((state_34614[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34856 = state_34614;
state_34614 = G__34856;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10841__auto__ = function(state_34614){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10841__auto____1.call(this,state_34614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10841__auto____0;
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10841__auto____1;
return fluree$db$graphdb$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34639 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34639[(6)] = c__10878__auto__);

return statearr_34639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34675){
var state_val_34676 = (state_34675[(1)]);
if((state_val_34676 === (7))){
var inst_34649 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_34675__$1 = state_34675;
var statearr_34677_34857 = state_34675__$1;
(statearr_34677_34857[(2)] = inst_34649);

(statearr_34677_34857[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (1))){
var state_34675__$1 = state_34675;
var statearr_34678_34858 = state_34675__$1;
(statearr_34678_34858[(2)] = null);

(statearr_34678_34858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (4))){
var inst_34640 = (state_34675[(2)]);
var state_34675__$1 = state_34675;
var statearr_34679_34859 = state_34675__$1;
(statearr_34679_34859[(2)] = inst_34640);

(statearr_34679_34859[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (15))){
var inst_34670 = (state_34675[(2)]);
var _ = (function (){var statearr_34680 = state_34675;
(statearr_34680[(4)] = cljs.core.rest((state_34675[(4)])));

return statearr_34680;
})();
var state_34675__$1 = state_34675;
var statearr_34681_34860 = state_34675__$1;
(statearr_34681_34860[(2)] = inst_34670);

(statearr_34681_34860[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (13))){
var inst_34655 = (state_34675[(7)]);
var inst_34661 = clojure.string.includes_QMARK_(inst_34655,":");
var state_34675__$1 = state_34675;
if(inst_34661){
var statearr_34682_34861 = state_34675__$1;
(statearr_34682_34861[(1)] = (16));

} else {
var statearr_34683_34862 = state_34675__$1;
(statearr_34683_34862[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (6))){
var state_34675__$1 = state_34675;
var statearr_34684_34863 = state_34675__$1;
(statearr_34684_34863[(2)] = pred);

(statearr_34684_34863[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (17))){
var inst_34655 = (state_34675[(7)]);
var state_34675__$1 = state_34675;
var statearr_34685_34864 = state_34675__$1;
(statearr_34685_34864[(2)] = inst_34655);

(statearr_34685_34864[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (3))){
var inst_34673 = (state_34675[(2)]);
var state_34675__$1 = state_34675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34675__$1,inst_34673);
} else {
if((state_val_34676 === (12))){
var inst_34659 = (state_34675[(2)]);
var state_34675__$1 = state_34675;
if(cljs.core.truth_(inst_34659)){
var statearr_34686_34865 = state_34675__$1;
(statearr_34686_34865[(1)] = (13));

} else {
var statearr_34687_34866 = state_34675__$1;
(statearr_34687_34866[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (2))){
var _ = (function (){var statearr_34688 = state_34675;
(statearr_34688[(4)] = cljs.core.cons((5),(state_34675[(4)])));

return statearr_34688;
})();
var inst_34646 = typeof pred === 'string';
var state_34675__$1 = state_34675;
if(cljs.core.truth_(inst_34646)){
var statearr_34689_34867 = state_34675__$1;
(statearr_34689_34867[(1)] = (6));

} else {
var statearr_34690_34868 = state_34675__$1;
(statearr_34690_34868[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (11))){
var inst_34651 = (state_34675[(8)]);
var state_34675__$1 = state_34675;
var statearr_34692_34869 = state_34675__$1;
(statearr_34692_34869[(2)] = inst_34651);

(statearr_34692_34869[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (9))){
var inst_34651 = (state_34675[(8)]);
var inst_34654 = (state_34675[(2)]);
var inst_34655 = fluree.db.util.async.throw_err(inst_34654);
var state_34675__$1 = (function (){var statearr_34693 = state_34675;
(statearr_34693[(7)] = inst_34655);

return statearr_34693;
})();
if(cljs.core.truth_(inst_34651)){
var statearr_34694_34870 = state_34675__$1;
(statearr_34694_34870[(1)] = (10));

} else {
var statearr_34695_34871 = state_34675__$1;
(statearr_34695_34871[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (5))){
var _ = (function (){var statearr_34696 = state_34675;
(statearr_34696[(4)] = cljs.core.rest((state_34675[(4)])));

return statearr_34696;
})();
var state_34675__$1 = state_34675;
var ex34691 = (state_34675__$1[(2)]);
var statearr_34697_34872 = state_34675__$1;
(statearr_34697_34872[(5)] = ex34691);


if((ex34691 instanceof Error)){
var statearr_34698_34873 = state_34675__$1;
(statearr_34698_34873[(1)] = (4));

(statearr_34698_34873[(5)] = null);

} else {
throw ex34691;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (14))){
var state_34675__$1 = state_34675;
var statearr_34699_34874 = state_34675__$1;
(statearr_34699_34874[(2)] = null);

(statearr_34699_34874[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (16))){
var inst_34655 = (state_34675[(7)]);
var inst_34663 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_34655,/:/);
var inst_34664 = cljs.core.second(inst_34663);
var state_34675__$1 = state_34675;
var statearr_34700_34875 = state_34675__$1;
(statearr_34700_34875[(2)] = inst_34664);

(statearr_34700_34875[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (10))){
var inst_34655 = (state_34675[(7)]);
var state_34675__$1 = state_34675;
var statearr_34701_34876 = state_34675__$1;
(statearr_34701_34876[(2)] = inst_34655);

(statearr_34701_34876[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (18))){
var inst_34667 = (state_34675[(2)]);
var state_34675__$1 = state_34675;
var statearr_34702_34877 = state_34675__$1;
(statearr_34702_34877[(2)] = inst_34667);

(statearr_34702_34877[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34676 === (8))){
var inst_34651 = (state_34675[(2)]);
var inst_34652 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_34675__$1 = (function (){var statearr_34703 = state_34675;
(statearr_34703[(8)] = inst_34651);

return statearr_34703;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34675__$1,(9),inst_34652);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10841__auto__ = null;
var fluree$db$graphdb$state_machine__10841__auto____0 = (function (){
var statearr_34704 = [null,null,null,null,null,null,null,null,null];
(statearr_34704[(0)] = fluree$db$graphdb$state_machine__10841__auto__);

(statearr_34704[(1)] = (1));

return statearr_34704;
});
var fluree$db$graphdb$state_machine__10841__auto____1 = (function (state_34675){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34675);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34705){var ex__10844__auto__ = e34705;
var statearr_34706_34878 = state_34675;
(statearr_34706_34878[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34675[(4)]))){
var statearr_34707_34879 = state_34675;
(statearr_34707_34879[(1)] = cljs.core.first((state_34675[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34880 = state_34675;
state_34675 = G__34880;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10841__auto__ = function(state_34675){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10841__auto____1.call(this,state_34675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10841__auto____0;
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10841__auto____1;
return fluree$db$graphdb$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34708 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34708[(6)] = c__10878__auto__);

return statearr_34708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34741){
var state_val_34742 = (state_34741[(1)]);
if((state_val_34742 === (7))){
var state_34741__$1 = state_34741;
var statearr_34743_34881 = state_34741__$1;
(statearr_34743_34881[(2)] = null);

(statearr_34743_34881[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (1))){
var state_34741__$1 = state_34741;
var statearr_34744_34882 = state_34741__$1;
(statearr_34744_34882[(2)] = null);

(statearr_34744_34882[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (4))){
var inst_34709 = (state_34741[(2)]);
var state_34741__$1 = state_34741;
var statearr_34745_34883 = state_34741__$1;
(statearr_34745_34883[(2)] = inst_34709);

(statearr_34745_34883[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (6))){
var inst_34724 = (state_34741[(7)]);
var inst_34723 = (state_34741[(2)]);
var inst_34724__$1 = fluree.db.util.async.throw_err(inst_34723);
var inst_34725 = (inst_34724__$1 == null);
var state_34741__$1 = (function (){var statearr_34746 = state_34741;
(statearr_34746[(7)] = inst_34724__$1);

return statearr_34746;
})();
if(cljs.core.truth_(inst_34725)){
var statearr_34747_34884 = state_34741__$1;
(statearr_34747_34884[(1)] = (7));

} else {
var statearr_34748_34885 = state_34741__$1;
(statearr_34748_34885[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (3))){
var inst_34739 = (state_34741[(2)]);
var state_34741__$1 = state_34741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34741__$1,inst_34739);
} else {
if((state_val_34742 === (12))){
var inst_34736 = (state_34741[(2)]);
var _ = (function (){var statearr_34749 = state_34741;
(statearr_34749[(4)] = cljs.core.rest((state_34741[(4)])));

return statearr_34749;
})();
var state_34741__$1 = state_34741;
var statearr_34750_34886 = state_34741__$1;
(statearr_34750_34886[(2)] = inst_34736);

(statearr_34750_34886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (2))){
var _ = (function (){var statearr_34751 = state_34741;
(statearr_34751[(4)] = cljs.core.cons((5),(state_34741[(4)])));

return statearr_34751;
})();
var inst_34715 = (30);
var inst_34717 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_34718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34719 = [inst_34715,tag_name];
var inst_34720 = (new cljs.core.PersistentVector(null,2,(5),inst_34718,inst_34719,null));
var inst_34721 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_34717,cljs.core.cst$kw$post,cljs.core._EQ_,inst_34720);
var state_34741__$1 = state_34741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34741__$1,(6),inst_34721);
} else {
if((state_val_34742 === (11))){
var inst_34730 = (state_34741[(8)]);
var inst_34734 = inst_34730.s;
var state_34741__$1 = state_34741;
var statearr_34753_34887 = state_34741__$1;
(statearr_34753_34887[(2)] = inst_34734);

(statearr_34753_34887[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (9))){
var inst_34730 = (state_34741[(8)]);
var inst_34730__$1 = (state_34741[(2)]);
var inst_34731 = (inst_34730__$1 == null);
var state_34741__$1 = (function (){var statearr_34754 = state_34741;
(statearr_34754[(8)] = inst_34730__$1);

return statearr_34754;
})();
if(cljs.core.truth_(inst_34731)){
var statearr_34755_34888 = state_34741__$1;
(statearr_34755_34888[(1)] = (10));

} else {
var statearr_34756_34889 = state_34741__$1;
(statearr_34756_34889[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (5))){
var _ = (function (){var statearr_34757 = state_34741;
(statearr_34757[(4)] = cljs.core.rest((state_34741[(4)])));

return statearr_34757;
})();
var state_34741__$1 = state_34741;
var ex34752 = (state_34741__$1[(2)]);
var statearr_34758_34890 = state_34741__$1;
(statearr_34758_34890[(5)] = ex34752);


if((ex34752 instanceof Error)){
var statearr_34759_34891 = state_34741__$1;
(statearr_34759_34891[(1)] = (4));

(statearr_34759_34891[(5)] = null);

} else {
throw ex34752;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (10))){
var state_34741__$1 = state_34741;
var statearr_34760_34892 = state_34741__$1;
(statearr_34760_34892[(2)] = null);

(statearr_34760_34892[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34742 === (8))){
var inst_34724 = (state_34741[(7)]);
var inst_34728 = cljs.core.first(inst_34724);
var state_34741__$1 = state_34741;
var statearr_34761_34893 = state_34741__$1;
(statearr_34761_34893[(2)] = inst_34728);

(statearr_34761_34893[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10841__auto__ = null;
var fluree$db$graphdb$state_machine__10841__auto____0 = (function (){
var statearr_34762 = [null,null,null,null,null,null,null,null,null];
(statearr_34762[(0)] = fluree$db$graphdb$state_machine__10841__auto__);

(statearr_34762[(1)] = (1));

return statearr_34762;
});
var fluree$db$graphdb$state_machine__10841__auto____1 = (function (state_34741){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34741);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34763){var ex__10844__auto__ = e34763;
var statearr_34764_34894 = state_34741;
(statearr_34764_34894[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34741[(4)]))){
var statearr_34765_34895 = state_34741;
(statearr_34765_34895[(1)] = cljs.core.first((state_34741[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34896 = state_34741;
state_34741 = G__34896;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10841__auto__ = function(state_34741){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10841__auto____1.call(this,state_34741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10841__auto____0;
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10841__auto____1;
return fluree$db$graphdb$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34766 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34766[(6)] = c__10878__auto__);

return statearr_34766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_34801){
var state_val_34802 = (state_34801[(1)]);
if((state_val_34802 === (7))){
var inst_34780 = typeof pred === 'string';
var state_34801__$1 = state_34801;
if(cljs.core.truth_(inst_34780)){
var statearr_34803_34897 = state_34801__$1;
(statearr_34803_34897[(1)] = (10));

} else {
var statearr_34804_34898 = state_34801__$1;
(statearr_34804_34898[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (1))){
var state_34801__$1 = state_34801;
var statearr_34805_34899 = state_34801__$1;
(statearr_34805_34899[(2)] = null);

(statearr_34805_34899[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (4))){
var inst_34767 = (state_34801[(2)]);
var state_34801__$1 = state_34801;
var statearr_34806_34900 = state_34801__$1;
(statearr_34806_34900[(2)] = inst_34767);

(statearr_34806_34900[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (15))){
var inst_34794 = (state_34801[(2)]);
var state_34801__$1 = state_34801;
var statearr_34807_34901 = state_34801__$1;
(statearr_34807_34901[(2)] = inst_34794);

(statearr_34807_34901[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (13))){
var inst_34785 = (state_34801[(7)]);
var inst_34787 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34785),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_34788 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_34787);
var state_34801__$1 = state_34801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34801__$1,(16),inst_34788);
} else {
if((state_val_34802 === (6))){
var inst_34775 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_34801__$1 = state_34801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34801__$1,(9),inst_34775);
} else {
if((state_val_34802 === (3))){
var inst_34799 = (state_34801[(2)]);
var state_34801__$1 = state_34801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34801__$1,inst_34799);
} else {
if((state_val_34802 === (12))){
var inst_34785 = (state_34801[(7)]);
var inst_34785__$1 = (state_34801[(2)]);
var state_34801__$1 = (function (){var statearr_34808 = state_34801;
(statearr_34808[(7)] = inst_34785__$1);

return statearr_34808;
})();
if(cljs.core.truth_(inst_34785__$1)){
var statearr_34809_34902 = state_34801__$1;
(statearr_34809_34902[(1)] = (13));

} else {
var statearr_34810_34903 = state_34801__$1;
(statearr_34810_34903[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (2))){
var _ = (function (){var statearr_34811 = state_34801;
(statearr_34811[(4)] = cljs.core.cons((5),(state_34801[(4)])));

return statearr_34811;
})();
var inst_34773 = clojure.string.includes_QMARK_(tag_name,"/");
var state_34801__$1 = state_34801;
if(inst_34773){
var statearr_34812_34904 = state_34801__$1;
(statearr_34812_34904[(1)] = (6));

} else {
var statearr_34813_34905 = state_34801__$1;
(statearr_34813_34905[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (11))){
var inst_34783 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_34801__$1 = state_34801;
var statearr_34815_34906 = state_34801__$1;
(statearr_34815_34906[(2)] = inst_34783);

(statearr_34815_34906[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (9))){
var inst_34777 = (state_34801[(2)]);
var inst_34778 = fluree.db.util.async.throw_err(inst_34777);
var state_34801__$1 = state_34801;
var statearr_34816_34907 = state_34801__$1;
(statearr_34816_34907[(2)] = inst_34778);

(statearr_34816_34907[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (5))){
var _ = (function (){var statearr_34817 = state_34801;
(statearr_34817[(4)] = cljs.core.rest((state_34801[(4)])));

return statearr_34817;
})();
var state_34801__$1 = state_34801;
var ex34814 = (state_34801__$1[(2)]);
var statearr_34818_34908 = state_34801__$1;
(statearr_34818_34908[(5)] = ex34814);


if((ex34814 instanceof Error)){
var statearr_34819_34909 = state_34801__$1;
(statearr_34819_34909[(1)] = (4));

(statearr_34819_34909[(5)] = null);

} else {
throw ex34814;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (14))){
var state_34801__$1 = state_34801;
var statearr_34820_34910 = state_34801__$1;
(statearr_34820_34910[(2)] = null);

(statearr_34820_34910[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (16))){
var inst_34790 = (state_34801[(2)]);
var inst_34791 = fluree.db.util.async.throw_err(inst_34790);
var state_34801__$1 = state_34801;
var statearr_34821_34911 = state_34801__$1;
(statearr_34821_34911[(2)] = inst_34791);

(statearr_34821_34911[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (10))){
var state_34801__$1 = state_34801;
var statearr_34822_34912 = state_34801__$1;
(statearr_34822_34912[(2)] = pred);

(statearr_34822_34912[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34802 === (8))){
var inst_34796 = (state_34801[(2)]);
var _ = (function (){var statearr_34823 = state_34801;
(statearr_34823[(4)] = cljs.core.rest((state_34801[(4)])));

return statearr_34823;
})();
var state_34801__$1 = state_34801;
var statearr_34824_34913 = state_34801__$1;
(statearr_34824_34913[(2)] = inst_34796);

(statearr_34824_34913[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10841__auto__ = null;
var fluree$db$graphdb$state_machine__10841__auto____0 = (function (){
var statearr_34825 = [null,null,null,null,null,null,null,null];
(statearr_34825[(0)] = fluree$db$graphdb$state_machine__10841__auto__);

(statearr_34825[(1)] = (1));

return statearr_34825;
});
var fluree$db$graphdb$state_machine__10841__auto____1 = (function (state_34801){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_34801);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e34826){var ex__10844__auto__ = e34826;
var statearr_34827_34914 = state_34801;
(statearr_34827_34914[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_34801[(4)]))){
var statearr_34828_34915 = state_34801;
(statearr_34828_34915[(1)] = cljs.core.first((state_34801[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__34916 = state_34801;
state_34801 = G__34916;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10841__auto__ = function(state_34801){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10841__auto____1.call(this,state_34801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10841__auto____0;
fluree$db$graphdb$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10841__auto____1;
return fluree$db$graphdb$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_34829 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_34829[(6)] = c__10878__auto__);

return statearr_34829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__34498){
var extmap__4512__auto__ = (function (){var G__34830 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34498,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__34498)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34830);
} else {
return G__34830;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__34498),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__34498),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
