// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k26369,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__26373 = k26369;
var G__26373__$1 = (((G__26373 instanceof cljs.core.Keyword))?G__26373.fqn:null);
switch (G__26373__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26369,else__4475__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__26374){
var vec__26375 = p__26374;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26375,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26375,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26368){
var self__ = this;
var G__26368__$1 = this;
return (new cljs.core.RecordIter((0),G__26368__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__26378 = (function (coll__4469__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__26378(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26370,other26371){
var self__ = this;
var this26370__$1 = this;
return (((!((other26371 == null)))) && ((((this26370__$1.constructor === other26371.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26370__$1.index_type,other26371.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26370__$1.comparator,other26371.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26370__$1.historyComparator,other26371.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26370__$1.__extmap,other26371.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k26369){
var self__ = this;
var this__4479__auto____$1 = this;
var G__26379 = k26369;
var G__26379__$1 = (((G__26379 instanceof cljs.core.Keyword))?G__26379.fqn:null);
switch (G__26379__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26369);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__26368){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__26380 = cljs.core.keyword_identical_QMARK_;
var expr__26381 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__26383 = cljs.core.cst$kw$index_DASH_type;
var G__26384 = expr__26381;
return (pred__26380.cljs$core$IFn$_invoke$arity$2 ? pred__26380.cljs$core$IFn$_invoke$arity$2(G__26383,G__26384) : pred__26380.call(null,G__26383,G__26384));
})())){
return (new fluree.db.index.IndexConfig(G__26368,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26385 = cljs.core.cst$kw$comparator;
var G__26386 = expr__26381;
return (pred__26380.cljs$core$IFn$_invoke$arity$2 ? pred__26380.cljs$core$IFn$_invoke$arity$2(G__26385,G__26386) : pred__26380.call(null,G__26385,G__26386));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__26368,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26387 = cljs.core.cst$kw$historyComparator;
var G__26388 = expr__26381;
return (pred__26380.cljs$core$IFn$_invoke$arity$2 ? pred__26380.cljs$core$IFn$_invoke$arity$2(G__26387,G__26388) : pred__26380.call(null,G__26387,G__26388));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__26368,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__26368),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__26368){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__26368,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__26372){
var extmap__4512__auto__ = (function (){var G__26389 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26372,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__26372)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26389);
} else {
return G__26389;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__26372),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__26372),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__26372),null,cljs.core.not_empty(extmap__4512__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k26393,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__26397 = k26393;
var G__26397__$1 = (((G__26397 instanceof cljs.core.Keyword))?G__26397.fqn:null);
switch (G__26397__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26393,else__4475__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__26398){
var vec__26399 = p__26398;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26399,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26399,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26392){
var self__ = this;
var G__26392__$1 = this;
return (new cljs.core.RecordIter((0),G__26392__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26403){
var state_val_26404 = (state_26403[(1)]);
if((state_val_26404 === (1))){
var state_26403__$1 = state_26403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26403__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__10798__auto__ = null;
var fluree$db$index$state_machine__10798__auto____0 = (function (){
var statearr_26405 = [null,null,null,null,null,null,null];
(statearr_26405[(0)] = fluree$db$index$state_machine__10798__auto__);

(statearr_26405[(1)] = (1));

return statearr_26405;
});
var fluree$db$index$state_machine__10798__auto____1 = (function (state_26403){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26403);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26406){var ex__10801__auto__ = e26406;
var statearr_26407_26519 = state_26403;
(statearr_26407_26519[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26403[(4)]))){
var statearr_26408_26520 = state_26403;
(statearr_26408_26520[(1)] = cljs.core.first((state_26403[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26521 = state_26403;
state_26403 = G__26521;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$index$state_machine__10798__auto__ = function(state_26403){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10798__auto____1.call(this,state_26403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10798__auto____0;
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10798__auto____1;
return fluree$db$index$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26409 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26409[(6)] = c__10835__auto__);

return statearr_26409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26434){
var state_val_26435 = (state_26434[(1)]);
if((state_val_26435 === (7))){
var inst_26416 = (state_26434[(7)]);
var inst_26420 = fluree.db.dbproto._resolve(inst_26416);
var state_26434__$1 = state_26434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26434__$1,(10),inst_26420);
} else {
if((state_val_26435 === (1))){
var state_26434__$1 = state_26434;
var statearr_26436_26522 = state_26434__$1;
(statearr_26436_26522[(2)] = null);

(statearr_26436_26522[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26435 === (4))){
var inst_26410 = (state_26434[(2)]);
var state_26434__$1 = state_26434;
var statearr_26437_26523 = state_26434__$1;
(statearr_26437_26523[(2)] = inst_26410);

(statearr_26437_26523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26435 === (6))){
var inst_26416 = (state_26434[(7)]);
var state_26434__$1 = state_26434;
var statearr_26438_26524 = state_26434__$1;
(statearr_26438_26524[(2)] = inst_26416);

(statearr_26438_26524[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26435 === (3))){
var inst_26432 = (state_26434[(2)]);
var state_26434__$1 = state_26434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26434__$1,inst_26432);
} else {
if((state_val_26435 === (2))){
var inst_26416 = (state_26434[(7)]);
var _ = (function (){var statearr_26440 = state_26434;
(statearr_26440[(4)] = cljs.core.cons((5),(state_26434[(4)])));

return statearr_26440;
})();
var inst_26416__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_26417 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_26416__$1);
var state_26434__$1 = (function (){var statearr_26441 = state_26434;
(statearr_26441[(7)] = inst_26416__$1);

return statearr_26441;
})();
if(cljs.core.truth_(inst_26417)){
var statearr_26442_26525 = state_26434__$1;
(statearr_26442_26525[(1)] = (6));

} else {
var statearr_26443_26526 = state_26434__$1;
(statearr_26443_26526[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26435 === (9))){
var inst_26426 = (state_26434[(2)]);
var inst_26427 = fluree.db.util.async.throw_err(inst_26426);
var state_26434__$1 = state_26434;
var statearr_26444_26527 = state_26434__$1;
(statearr_26444_26527[(2)] = inst_26427);

(statearr_26444_26527[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26435 === (5))){
var _ = (function (){var statearr_26445 = state_26434;
(statearr_26445[(4)] = cljs.core.rest((state_26434[(4)])));

return statearr_26445;
})();
var state_26434__$1 = state_26434;
var ex26439 = (state_26434__$1[(2)]);
var statearr_26446_26528 = state_26434__$1;
(statearr_26446_26528[(5)] = ex26439);


if((ex26439 instanceof Error)){
var statearr_26447_26529 = state_26434__$1;
(statearr_26447_26529[(1)] = (4));

(statearr_26447_26529[(5)] = null);

} else {
throw ex26439;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26435 === (10))){
var inst_26422 = (state_26434[(2)]);
var inst_26423 = fluree.db.util.async.throw_err(inst_26422);
var inst_26424 = fluree.db.dbproto._lookup_leaf(inst_26423,flake);
var state_26434__$1 = state_26434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26434__$1,(9),inst_26424);
} else {
if((state_val_26435 === (8))){
var inst_26429 = (state_26434[(2)]);
var _ = (function (){var statearr_26448 = state_26434;
(statearr_26448[(4)] = cljs.core.rest((state_26434[(4)])));

return statearr_26448;
})();
var state_26434__$1 = state_26434;
var statearr_26449_26530 = state_26434__$1;
(statearr_26449_26530[(2)] = inst_26429);

(statearr_26449_26530[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__10798__auto__ = null;
var fluree$db$index$state_machine__10798__auto____0 = (function (){
var statearr_26450 = [null,null,null,null,null,null,null,null];
(statearr_26450[(0)] = fluree$db$index$state_machine__10798__auto__);

(statearr_26450[(1)] = (1));

return statearr_26450;
});
var fluree$db$index$state_machine__10798__auto____1 = (function (state_26434){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26434);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26451){var ex__10801__auto__ = e26451;
var statearr_26452_26531 = state_26434;
(statearr_26452_26531[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26434[(4)]))){
var statearr_26453_26532 = state_26434;
(statearr_26453_26532[(1)] = cljs.core.first((state_26434[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26533 = state_26434;
state_26434 = G__26533;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$index$state_machine__10798__auto__ = function(state_26434){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10798__auto____1.call(this,state_26434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10798__auto____0;
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10798__auto____1;
return fluree$db$index$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26454 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26454[(6)] = c__10835__auto__);

return statearr_26454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26479){
var state_val_26480 = (state_26479[(1)]);
if((state_val_26480 === (7))){
var inst_26461 = (state_26479[(7)]);
var inst_26465 = fluree.db.dbproto._resolve(inst_26461);
var state_26479__$1 = state_26479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26479__$1,(10),inst_26465);
} else {
if((state_val_26480 === (1))){
var state_26479__$1 = state_26479;
var statearr_26481_26534 = state_26479__$1;
(statearr_26481_26534[(2)] = null);

(statearr_26481_26534[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26480 === (4))){
var inst_26455 = (state_26479[(2)]);
var state_26479__$1 = state_26479;
var statearr_26482_26535 = state_26479__$1;
(statearr_26482_26535[(2)] = inst_26455);

(statearr_26482_26535[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26480 === (6))){
var inst_26461 = (state_26479[(7)]);
var state_26479__$1 = state_26479;
var statearr_26483_26536 = state_26479__$1;
(statearr_26483_26536[(2)] = inst_26461);

(statearr_26483_26536[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26480 === (3))){
var inst_26477 = (state_26479[(2)]);
var state_26479__$1 = state_26479;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26479__$1,inst_26477);
} else {
if((state_val_26480 === (2))){
var inst_26461 = (state_26479[(7)]);
var _ = (function (){var statearr_26485 = state_26479;
(statearr_26485[(4)] = cljs.core.cons((5),(state_26479[(4)])));

return statearr_26485;
})();
var inst_26461__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_26462 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_26461__$1);
var state_26479__$1 = (function (){var statearr_26486 = state_26479;
(statearr_26486[(7)] = inst_26461__$1);

return statearr_26486;
})();
if(cljs.core.truth_(inst_26462)){
var statearr_26487_26537 = state_26479__$1;
(statearr_26487_26537[(1)] = (6));

} else {
var statearr_26488_26538 = state_26479__$1;
(statearr_26488_26538[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26480 === (9))){
var inst_26471 = (state_26479[(2)]);
var inst_26472 = fluree.db.util.async.throw_err(inst_26471);
var state_26479__$1 = state_26479;
var statearr_26489_26539 = state_26479__$1;
(statearr_26489_26539[(2)] = inst_26472);

(statearr_26489_26539[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26480 === (5))){
var _ = (function (){var statearr_26490 = state_26479;
(statearr_26490[(4)] = cljs.core.rest((state_26479[(4)])));

return statearr_26490;
})();
var state_26479__$1 = state_26479;
var ex26484 = (state_26479__$1[(2)]);
var statearr_26491_26540 = state_26479__$1;
(statearr_26491_26540[(5)] = ex26484);


if((ex26484 instanceof Error)){
var statearr_26492_26541 = state_26479__$1;
(statearr_26492_26541[(1)] = (4));

(statearr_26492_26541[(5)] = null);

} else {
throw ex26484;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26480 === (10))){
var inst_26467 = (state_26479[(2)]);
var inst_26468 = fluree.db.util.async.throw_err(inst_26467);
var inst_26469 = fluree.db.dbproto._lookup_leaf_after(inst_26468,flake);
var state_26479__$1 = state_26479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26479__$1,(9),inst_26469);
} else {
if((state_val_26480 === (8))){
var inst_26474 = (state_26479[(2)]);
var _ = (function (){var statearr_26493 = state_26479;
(statearr_26493[(4)] = cljs.core.rest((state_26479[(4)])));

return statearr_26493;
})();
var state_26479__$1 = state_26479;
var statearr_26494_26542 = state_26479__$1;
(statearr_26494_26542[(2)] = inst_26474);

(statearr_26494_26542[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__10798__auto__ = null;
var fluree$db$index$state_machine__10798__auto____0 = (function (){
var statearr_26495 = [null,null,null,null,null,null,null,null];
(statearr_26495[(0)] = fluree$db$index$state_machine__10798__auto__);

(statearr_26495[(1)] = (1));

return statearr_26495;
});
var fluree$db$index$state_machine__10798__auto____1 = (function (state_26479){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26479);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26496){var ex__10801__auto__ = e26496;
var statearr_26497_26543 = state_26479;
(statearr_26497_26543[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26479[(4)]))){
var statearr_26498_26544 = state_26479;
(statearr_26498_26544[(1)] = cljs.core.first((state_26479[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26545 = state_26479;
state_26479 = G__26545;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$index$state_machine__10798__auto__ = function(state_26479){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10798__auto____1.call(this,state_26479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10798__auto____0;
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10798__auto____1;
return fluree$db$index$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26499 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26499[(6)] = c__10835__auto__);

return statearr_26499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__26500 = (function (coll__4469__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__26500(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26394,other26395){
var self__ = this;
var this26394__$1 = this;
return (((!((other26395 == null)))) && ((((this26394__$1.constructor === other26395.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26394__$1.block,other26395.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26394__$1.t,other26395.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26394__$1.rhs,other26395.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26394__$1.children,other26395.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26394__$1.config,other26395.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26394__$1.leftmost_QMARK_,other26395.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26394__$1.__extmap,other26395.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k26393){
var self__ = this;
var this__4479__auto____$1 = this;
var G__26501 = k26393;
var G__26501__$1 = (((G__26501 instanceof cljs.core.Keyword))?G__26501.fqn:null);
switch (G__26501__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26393);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__26392){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__26502 = cljs.core.keyword_identical_QMARK_;
var expr__26503 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__26505 = cljs.core.cst$kw$block;
var G__26506 = expr__26503;
return (pred__26502.cljs$core$IFn$_invoke$arity$2 ? pred__26502.cljs$core$IFn$_invoke$arity$2(G__26505,G__26506) : pred__26502.call(null,G__26505,G__26506));
})())){
return (new fluree.db.index.IndexNode(G__26392,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26507 = cljs.core.cst$kw$t;
var G__26508 = expr__26503;
return (pred__26502.cljs$core$IFn$_invoke$arity$2 ? pred__26502.cljs$core$IFn$_invoke$arity$2(G__26507,G__26508) : pred__26502.call(null,G__26507,G__26508));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__26392,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26509 = cljs.core.cst$kw$rhs;
var G__26510 = expr__26503;
return (pred__26502.cljs$core$IFn$_invoke$arity$2 ? pred__26502.cljs$core$IFn$_invoke$arity$2(G__26509,G__26510) : pred__26502.call(null,G__26509,G__26510));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__26392,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26511 = cljs.core.cst$kw$children;
var G__26512 = expr__26503;
return (pred__26502.cljs$core$IFn$_invoke$arity$2 ? pred__26502.cljs$core$IFn$_invoke$arity$2(G__26511,G__26512) : pred__26502.call(null,G__26511,G__26512));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__26392,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26513 = cljs.core.cst$kw$config;
var G__26514 = expr__26503;
return (pred__26502.cljs$core$IFn$_invoke$arity$2 ? pred__26502.cljs$core$IFn$_invoke$arity$2(G__26513,G__26514) : pred__26502.call(null,G__26513,G__26514));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__26392,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26515 = cljs.core.cst$kw$leftmost_QMARK_;
var G__26516 = expr__26503;
return (pred__26502.cljs$core$IFn$_invoke$arity$2 ? pred__26502.cljs$core$IFn$_invoke$arity$2(G__26515,G__26516) : pred__26502.call(null,G__26515,G__26516));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__26392,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__26392),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__26392){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__26392,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__26396){
var extmap__4512__auto__ = (function (){var G__26517 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26396,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__26396)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26517);
} else {
return G__26517;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__26396),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__26396),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__26396),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__26396),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__26396),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26396),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k26548,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__26552 = k26548;
var G__26552__$1 = (((G__26552 instanceof cljs.core.Keyword))?G__26552.fqn:null);
switch (G__26552__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k26548,else__4475__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__26553){
var vec__26554 = p__26553;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26554,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26554,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26547){
var self__ = this;
var G__26547__$1 = this;
return (new cljs.core.RecordIter((0),G__26547__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26558){
var state_val_26559 = (state_26558[(1)]);
if((state_val_26559 === (1))){
var state_26558__$1 = state_26558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26558__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__10798__auto__ = null;
var fluree$db$index$state_machine__10798__auto____0 = (function (){
var statearr_26560 = [null,null,null,null,null,null,null];
(statearr_26560[(0)] = fluree$db$index$state_machine__10798__auto__);

(statearr_26560[(1)] = (1));

return statearr_26560;
});
var fluree$db$index$state_machine__10798__auto____1 = (function (state_26558){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26558);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26561){var ex__10801__auto__ = e26561;
var statearr_26562_26594 = state_26558;
(statearr_26562_26594[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26558[(4)]))){
var statearr_26563_26595 = state_26558;
(statearr_26563_26595[(1)] = cljs.core.first((state_26558[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26596 = state_26558;
state_26558 = G__26596;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$index$state_machine__10798__auto__ = function(state_26558){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10798__auto____1.call(this,state_26558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10798__auto____0;
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10798__auto____1;
return fluree$db$index$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26564 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26564[(6)] = c__10835__auto__);

return statearr_26564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26570){
var state_val_26571 = (state_26570[(1)]);
if((state_val_26571 === (1))){
var inst_26565 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_26566 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_26567 = cljs.core.PersistentHashMap.fromArrays(inst_26565,inst_26566);
var inst_26568 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_26567);
var state_26570__$1 = state_26570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26570__$1,inst_26568);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__10798__auto__ = null;
var fluree$db$index$state_machine__10798__auto____0 = (function (){
var statearr_26572 = [null,null,null,null,null,null,null];
(statearr_26572[(0)] = fluree$db$index$state_machine__10798__auto__);

(statearr_26572[(1)] = (1));

return statearr_26572;
});
var fluree$db$index$state_machine__10798__auto____1 = (function (state_26570){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26570);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26573){var ex__10801__auto__ = e26573;
var statearr_26574_26597 = state_26570;
(statearr_26574_26597[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26570[(4)]))){
var statearr_26575_26598 = state_26570;
(statearr_26575_26598[(1)] = cljs.core.first((state_26570[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26599 = state_26570;
state_26570 = G__26599;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$index$state_machine__10798__auto__ = function(state_26570){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10798__auto____1.call(this,state_26570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10798__auto____0;
fluree$db$index$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10798__auto____1;
return fluree$db$index$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26576 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26576[(6)] = c__10835__auto__);

return statearr_26576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__26577 = (function (coll__4469__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__26577(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26549,other26550){
var self__ = this;
var this26549__$1 = this;
return (((!((other26550 == null)))) && ((((this26549__$1.constructor === other26550.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26549__$1.block,other26550.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26549__$1.t,other26550.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26549__$1.flakes,other26550.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26549__$1.rhs,other26550.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26549__$1.config,other26550.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this26549__$1.__extmap,other26550.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k26548){
var self__ = this;
var this__4479__auto____$1 = this;
var G__26578 = k26548;
var G__26578__$1 = (((G__26578 instanceof cljs.core.Keyword))?G__26578.fqn:null);
switch (G__26578__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k26548);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__26547){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__26579 = cljs.core.keyword_identical_QMARK_;
var expr__26580 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__26582 = cljs.core.cst$kw$block;
var G__26583 = expr__26580;
return (pred__26579.cljs$core$IFn$_invoke$arity$2 ? pred__26579.cljs$core$IFn$_invoke$arity$2(G__26582,G__26583) : pred__26579.call(null,G__26582,G__26583));
})())){
return (new fluree.db.index.DataNode(G__26547,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26584 = cljs.core.cst$kw$t;
var G__26585 = expr__26580;
return (pred__26579.cljs$core$IFn$_invoke$arity$2 ? pred__26579.cljs$core$IFn$_invoke$arity$2(G__26584,G__26585) : pred__26579.call(null,G__26584,G__26585));
})())){
return (new fluree.db.index.DataNode(self__.block,G__26547,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26586 = cljs.core.cst$kw$flakes;
var G__26587 = expr__26580;
return (pred__26579.cljs$core$IFn$_invoke$arity$2 ? pred__26579.cljs$core$IFn$_invoke$arity$2(G__26586,G__26587) : pred__26579.call(null,G__26586,G__26587));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__26547,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26588 = cljs.core.cst$kw$rhs;
var G__26589 = expr__26580;
return (pred__26579.cljs$core$IFn$_invoke$arity$2 ? pred__26579.cljs$core$IFn$_invoke$arity$2(G__26588,G__26589) : pred__26579.call(null,G__26588,G__26589));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__26547,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__26590 = cljs.core.cst$kw$config;
var G__26591 = expr__26580;
return (pred__26579.cljs$core$IFn$_invoke$arity$2 ? pred__26579.cljs$core$IFn$_invoke$arity$2(G__26590,G__26591) : pred__26579.call(null,G__26590,G__26591));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__26547,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__26547),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__26547){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__26547,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__26551){
var extmap__4512__auto__ = (function (){var G__26592 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__26551,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__26551)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__26592);
} else {
return G__26592;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__26551),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__26551),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__26551),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__26551),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__26551),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
