// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__29670 = arguments.length;
switch (G__29670) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__29672 = null;
var G__29672__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__29672__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__29672__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__29672 = function(result,flake){
switch(arguments.length){
case 0:
return G__29672__0.call(this);
case 1:
return G__29672__1.call(this,result);
case 2:
return G__29672__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__29672.cljs$core$IFn$_invoke$arity$0 = G__29672__0;
G__29672.cljs$core$IFn$_invoke$arity$1 = G__29672__1;
G__29672.cljs$core$IFn$_invoke$arity$2 = G__29672__2;
return G__29672;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__29673 = null;
var G__29673__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__29673__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__29673__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__29673 = function(result,flakes){
switch(arguments.length){
case 0:
return G__29673__0.call(this);
case 1:
return G__29673__1.call(this,result);
case 2:
return G__29673__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__29673.cljs$core$IFn$_invoke$arity$0 = G__29673__0;
G__29673.cljs$core$IFn$_invoke$arity$1 = G__29673__1;
G__29673.cljs$core$IFn$_invoke$arity$2 = G__29673__2;
return G__29673;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__29675 = res;
var G__29675__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__29674_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__29674_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__29675):G__29675);
var G__29675__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__29675__$1):G__29675__$1);
var G__29675__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__29675__$2):G__29675__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__29675__$3);
} else {
return G__29675__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__29677 = arguments.length;
switch (G__29677) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_29976){
var state_val_29977 = (state_29976[(1)]);
if((state_val_29977 === (65))){
var inst_29717 = (state_29976[(7)]);
var inst_29834 = (state_29976[(8)]);
var inst_29827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29828 = cljs.core.deref(cache);
var inst_29829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29830 = flake.o;
var inst_29831 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_29717);
var inst_29832 = [inst_29830,inst_29831];
var inst_29833 = (new cljs.core.PersistentVector(null,2,(5),inst_29829,inst_29832,null));
var inst_29834__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29828,inst_29833);
var state_29976__$1 = (function (){var statearr_29978 = state_29976;
(statearr_29978[(9)] = inst_29827);

(statearr_29978[(8)] = inst_29834__$1);

return statearr_29978;
})();
if(cljs.core.truth_(inst_29834__$1)){
var statearr_29979_30148 = state_29976__$1;
(statearr_29979_30148[(1)] = (68));

} else {
var statearr_29980_30149 = state_29976__$1;
(statearr_29980_30149[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (70))){
var inst_29827 = (state_29976[(9)]);
var inst_29852 = (state_29976[(2)]);
var inst_29853 = [inst_29852,offset_map];
var inst_29854 = (new cljs.core.PersistentVector(null,2,(5),inst_29827,inst_29853,null));
var state_29976__$1 = state_29976;
var statearr_29981_30150 = state_29976__$1;
(statearr_29981_30150[(2)] = inst_29854);

(statearr_29981_30150[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (62))){
var inst_29812 = (state_29976[(10)]);
var inst_29796 = (state_29976[(11)]);
var inst_29717 = (state_29976[(7)]);
var inst_29729 = (state_29976[(12)]);
var inst_29731 = (state_29976[(13)]);
var inst_29702 = (state_29976[(14)]);
var inst_29734 = (state_29976[(15)]);
var inst_29730 = (state_29976[(16)]);
var inst_29732 = (state_29976[(17)]);
var inst_29733 = (state_29976[(18)]);
var inst_29728 = (state_29976[(19)]);
var inst_29688 = (state_29976[(20)]);
var inst_29735 = (state_29976[(21)]);
var inst_29814 = (function (){var p = inst_29735;
var pred_spec__$1 = inst_29702;
var orderBy = inst_29733;
var nested_select_spec = inst_29796;
var multi_QMARK_ = inst_29730;
var limit = inst_29732;
var offset = inst_29734;
var map__29684 = inst_29729;
var k = inst_29728;
var compact_QMARK_ = inst_29688;
var pred_spec_SINGLEQUOTE_ = inst_29717;
var G__29798 = inst_29812;
var ref_QMARK_ = inst_29731;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_29815 = (inst_29814.cljs$core$IFn$_invoke$arity$1 ? inst_29814.cljs$core$IFn$_invoke$arity$1(inst_29812) : inst_29814.call(null,inst_29812));
var state_29976__$1 = state_29976;
var statearr_29982_30151 = state_29976__$1;
(statearr_29982_30151[(2)] = inst_29815);

(statearr_29982_30151[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (74))){
var inst_29861 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29861)){
var statearr_29983_30152 = state_29976__$1;
(statearr_29983_30152[(1)] = (75));

} else {
var statearr_29984_30153 = state_29976__$1;
(statearr_29984_30153[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (7))){
var inst_29689 = (state_29976[(22)]);
var state_29976__$1 = state_29976;
var statearr_29985_30154 = state_29976__$1;
(statearr_29985_30154[(2)] = inst_29689);

(statearr_29985_30154[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (59))){
var inst_29806 = (state_29976[(23)]);
var inst_29808 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_29809 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_29808,inst_29806);
var state_29976__$1 = state_29976;
var statearr_29986_30155 = state_29976__$1;
(statearr_29986_30155[(2)] = inst_29809);

(statearr_29986_30155[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (86))){
var inst_29717 = (state_29976[(7)]);
var inst_29729 = (state_29976[(12)]);
var inst_29731 = (state_29976[(13)]);
var inst_29702 = (state_29976[(14)]);
var inst_29874 = (state_29976[(24)]);
var inst_29734 = (state_29976[(15)]);
var inst_29730 = (state_29976[(16)]);
var inst_29732 = (state_29976[(17)]);
var inst_29733 = (state_29976[(18)]);
var inst_29728 = (state_29976[(19)]);
var inst_29688 = (state_29976[(20)]);
var inst_29735 = (state_29976[(21)]);
var inst_29892 = (state_29976[(25)]);
var inst_29894 = (function (){var p = inst_29735;
var pred_spec__$1 = inst_29702;
var orderBy = inst_29733;
var children = inst_29874;
var multi_QMARK_ = inst_29730;
var limit = inst_29732;
var offset = inst_29734;
var map__29684 = inst_29729;
var G__29886 = inst_29892;
var k = inst_29728;
var compact_QMARK_ = inst_29688;
var pred_spec_SINGLEQUOTE_ = inst_29717;
var ref_QMARK_ = inst_29731;
return (function (n){
var G__29987 = db;
var G__29988 = cache;
var G__29989 = fuel;
var G__29990 = max_fuel;
var G__29991 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$wildcard_QMARK_,true,cljs.core.cst$kw$compact_QMARK_,compact_QMARK_], null);
var G__29992 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__29987,G__29988,G__29989,G__29990,G__29991,G__29992) : fluree.db.query.fql.flakes__GT_res.call(null,G__29987,G__29988,G__29989,G__29990,G__29991,G__29992));
});
})();
var inst_29895 = (inst_29894.cljs$core$IFn$_invoke$arity$1 ? inst_29894.cljs$core$IFn$_invoke$arity$1(inst_29892) : inst_29894.call(null,inst_29892));
var state_29976__$1 = state_29976;
var statearr_29993_30156 = state_29976__$1;
(statearr_29993_30156[(2)] = inst_29895);

(statearr_29993_30156[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (20))){
var inst_29717 = (state_29976[(7)]);
var inst_29729 = (state_29976[(12)]);
var inst_29730 = (state_29976[(16)]);
var inst_29728 = (state_29976[(2)]);
var inst_29729__$1 = cljs.core.__destructure_map(inst_29717);
var inst_29730__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29729__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_29731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29729__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_29732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29729__$1,cljs.core.cst$kw$limit);
var inst_29733 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29729__$1,cljs.core.cst$kw$orderBy);
var inst_29734 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29729__$1,cljs.core.cst$kw$offset);
var inst_29735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29729__$1,cljs.core.cst$kw$p);
var state_29976__$1 = (function (){var statearr_29994 = state_29976;
(statearr_29994[(12)] = inst_29729__$1);

(statearr_29994[(13)] = inst_29731);

(statearr_29994[(15)] = inst_29734);

(statearr_29994[(16)] = inst_29730__$1);

(statearr_29994[(17)] = inst_29732);

(statearr_29994[(18)] = inst_29733);

(statearr_29994[(19)] = inst_29728);

(statearr_29994[(21)] = inst_29735);

return statearr_29994;
})();
if(cljs.core.truth_(inst_29730__$1)){
var statearr_29995_30157 = state_29976__$1;
(statearr_29995_30157[(1)] = (24));

} else {
var statearr_29996_30158 = state_29976__$1;
(statearr_29996_30158[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (72))){
var inst_29717 = (state_29976[(7)]);
var inst_29858 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_29717);
var state_29976__$1 = state_29976;
var statearr_29997_30159 = state_29976__$1;
(statearr_29997_30159[(2)] = inst_29858);

(statearr_29997_30159[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (58))){
var inst_29805 = (state_29976[(2)]);
var inst_29806 = fluree.db.util.async.throw_err(inst_29805);
var state_29976__$1 = (function (){var statearr_29998 = state_29976;
(statearr_29998[(23)] = inst_29806);

return statearr_29998;
})();
if(cljs.core.truth_(fuel)){
var statearr_29999_30160 = state_29976__$1;
(statearr_29999_30160[(1)] = (59));

} else {
var statearr_30000_30161 = state_29976__$1;
(statearr_30000_30161[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (60))){
var inst_29806 = (state_29976[(23)]);
var state_29976__$1 = state_29976;
var statearr_30001_30162 = state_29976__$1;
(statearr_30001_30162[(2)] = inst_29806);

(statearr_30001_30162[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (27))){
var inst_29738 = (state_29976[(26)]);
var inst_29734 = (state_29976[(15)]);
var inst_29738__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_29734);
var state_29976__$1 = (function (){var statearr_30002 = state_29976;
(statearr_30002[(26)] = inst_29738__$1);

return statearr_30002;
})();
if(inst_29738__$1){
var statearr_30003_30163 = state_29976__$1;
(statearr_30003_30163[(1)] = (30));

} else {
var statearr_30004_30164 = state_29976__$1;
(statearr_30004_30164[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (1))){
var state_29976__$1 = state_29976;
var statearr_30005_30165 = state_29976__$1;
(statearr_30005_30165[(2)] = null);

(statearr_30005_30165[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (69))){
var inst_29717 = (state_29976[(7)]);
var inst_29837 = flake.o;
var inst_29838 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_29717);
var inst_29839 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_29837,inst_29838);
var state_29976__$1 = state_29976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29976__$1,(71),inst_29839);
} else {
if((state_val_29977 === (101))){
var inst_29937 = (state_29976[(27)]);
var inst_29728 = (state_29976[(19)]);
var inst_29936 = (state_29976[(28)]);
var inst_29956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29957 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_29728,inst_29936);
var inst_29958 = [inst_29957,inst_29937];
var inst_29959 = (new cljs.core.PersistentVector(null,2,(5),inst_29956,inst_29958,null));
var state_29976__$1 = state_29976;
var statearr_30006_30166 = state_29976__$1;
(statearr_30006_30166[(2)] = inst_29959);

(statearr_30006_30166[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (24))){
var inst_29734 = (state_29976[(15)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29734)){
var statearr_30007_30167 = state_29976__$1;
(statearr_30007_30167[(1)] = (27));

} else {
var statearr_30008_30168 = state_29976__$1;
(statearr_30008_30168[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (102))){
var state_29976__$1 = state_29976;
var statearr_30009_30169 = state_29976__$1;
(statearr_30009_30169[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (55))){
var inst_29717 = (state_29976[(7)]);
var inst_29825 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_29717);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29825)){
var statearr_30011_30170 = state_29976__$1;
(statearr_30011_30170[(1)] = (65));

} else {
var statearr_30012_30171 = state_29976__$1;
(statearr_30012_30171[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (85))){
var inst_29892 = (state_29976[(2)]);
var state_29976__$1 = (function (){var statearr_30013 = state_29976;
(statearr_30013[(25)] = inst_29892);

return statearr_30013;
})();
var statearr_30014_30172 = state_29976__$1;
(statearr_30014_30172[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (39))){
var inst_29733 = (state_29976[(18)]);
var inst_29765 = (state_29976[(29)]);
var inst_29765__$1 = cljs.core.not(inst_29733);
var state_29976__$1 = (function (){var statearr_30016 = state_29976;
(statearr_30016[(29)] = inst_29765__$1);

return statearr_30016;
})();
if(inst_29765__$1){
var statearr_30017_30173 = state_29976__$1;
(statearr_30017_30173[(1)] = (42));

} else {
var statearr_30018_30174 = state_29976__$1;
(statearr_30018_30174[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (88))){
var inst_29898 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29976__$1,(82),inst_29898);
} else {
if((state_val_29977 === (46))){
var inst_29781 = (state_29976[(30)]);
var inst_29781__$1 = cljs.core.not(recur_QMARK_);
var state_29976__$1 = (function (){var statearr_30019 = state_29976;
(statearr_30019[(30)] = inst_29781__$1);

return statearr_30019;
})();
if(inst_29781__$1){
var statearr_30020_30175 = state_29976__$1;
(statearr_30020_30175[(1)] = (48));

} else {
var statearr_30021_30176 = state_29976__$1;
(statearr_30021_30176[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (4))){
var inst_29678 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30022_30177 = state_29976__$1;
(statearr_30022_30177[(2)] = inst_29678);

(statearr_30022_30177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (77))){
var inst_29927 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30023_30178 = state_29976__$1;
(statearr_30023_30178[(2)] = inst_29927);

(statearr_30023_30178[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (106))){
var inst_29967 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30024_30179 = state_29976__$1;
(statearr_30024_30179[(2)] = inst_29967);

(statearr_30024_30179[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (95))){
var inst_29730 = (state_29976[(16)]);
var state_29976__$1 = state_29976;
var statearr_30025_30180 = state_29976__$1;
(statearr_30025_30180[(2)] = inst_29730);

(statearr_30025_30180[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (54))){
var inst_29717 = (state_29976[(7)]);
var inst_29793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29794 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_29795 = (new cljs.core.PersistentVector(null,3,(5),inst_29793,inst_29794,null));
var inst_29796 = cljs.core.select_keys(inst_29717,inst_29795);
var inst_29797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29799 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29800 = flake.o;
var inst_29801 = [inst_29800];
var inst_29802 = (new cljs.core.PersistentVector(null,1,(5),inst_29799,inst_29801,null));
var inst_29803 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29802);
var state_29976__$1 = (function (){var statearr_30026 = state_29976;
(statearr_30026[(31)] = inst_29797);

(statearr_30026[(11)] = inst_29796);

return statearr_30026;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29976__$1,(58),inst_29803);
} else {
if((state_val_29977 === (92))){
var inst_29917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29918 = flake.o;
var inst_29919 = [inst_29918,offset_map];
var inst_29920 = (new cljs.core.PersistentVector(null,2,(5),inst_29917,inst_29919,null));
var state_29976__$1 = state_29976;
var statearr_30027_30181 = state_29976__$1;
(statearr_30027_30181[(2)] = inst_29920);

(statearr_30027_30181[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (104))){
var inst_29937 = (state_29976[(27)]);
var inst_29962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29963 = [acc,inst_29937];
var inst_29964 = (new cljs.core.PersistentVector(null,2,(5),inst_29962,inst_29963,null));
var state_29976__$1 = state_29976;
var statearr_30028_30182 = state_29976__$1;
(statearr_30028_30182[(2)] = inst_29964);

(statearr_30028_30182[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (15))){
var inst_29710 = (state_29976[(32)]);
var inst_29688 = (state_29976[(20)]);
var inst_29714 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29710,cljs.core.cst$kw$compact_QMARK_,inst_29688);
var state_29976__$1 = state_29976;
var statearr_30029_30183 = state_29976__$1;
(statearr_30029_30183[(2)] = inst_29714);

(statearr_30029_30183[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (48))){
var inst_29717 = (state_29976[(7)]);
var inst_29783 = (state_29976[(33)]);
var inst_29783__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_29717);
var state_29976__$1 = (function (){var statearr_30030 = state_29976;
(statearr_30030[(33)] = inst_29783__$1);

return statearr_30030;
})();
if(cljs.core.truth_(inst_29783__$1)){
var statearr_30031_30184 = state_29976__$1;
(statearr_30031_30184[(1)] = (51));

} else {
var statearr_30032_30185 = state_29976__$1;
(statearr_30032_30185[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (50))){
var inst_29791 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29791)){
var statearr_30033_30186 = state_29976__$1;
(statearr_30033_30186[(1)] = (54));

} else {
var statearr_30034_30187 = state_29976__$1;
(statearr_30034_30187[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (75))){
var inst_29717 = (state_29976[(7)]);
var inst_29863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29864 = flake.o;
var inst_29865 = [inst_29864];
var inst_29866 = (new cljs.core.PersistentVector(null,1,(5),inst_29863,inst_29865,null));
var inst_29867 = [cljs.core.cst$kw$limit];
var inst_29868 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_29717);
var inst_29869 = [inst_29868];
var inst_29870 = cljs.core.PersistentHashMap.fromArrays(inst_29867,inst_29869);
var inst_29871 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29866,inst_29870);
var state_29976__$1 = state_29976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29976__$1,(78),inst_29871);
} else {
if((state_val_29977 === (99))){
var inst_29936 = (state_29976[(28)]);
var inst_29953 = (inst_29936 == null);
var inst_29954 = cljs.core.not(inst_29953);
var state_29976__$1 = state_29976;
if(inst_29954){
var statearr_30035_30188 = state_29976__$1;
(statearr_30035_30188[(1)] = (101));

} else {
var statearr_30036_30189 = state_29976__$1;
(statearr_30036_30189[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (21))){
var inst_29721 = (state_29976[(34)]);
var state_29976__$1 = state_29976;
var statearr_30037_30190 = state_29976__$1;
(statearr_30037_30190[(2)] = inst_29721);

(statearr_30037_30190[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (31))){
var inst_29738 = (state_29976[(26)]);
var state_29976__$1 = state_29976;
var statearr_30038_30191 = state_29976__$1;
(statearr_30038_30191[(2)] = inst_29738);

(statearr_30038_30191[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (32))){
var inst_29744 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30039_30192 = state_29976__$1;
(statearr_30039_30192[(2)] = inst_29744);

(statearr_30039_30192[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (40))){
var inst_29730 = (state_29976[(16)]);
var state_29976__$1 = state_29976;
var statearr_30040_30193 = state_29976__$1;
(statearr_30040_30193[(2)] = inst_29730);

(statearr_30040_30193[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (91))){
var inst_29925 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30041_30194 = state_29976__$1;
(statearr_30041_30194[(2)] = inst_29925);

(statearr_30041_30194[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (56))){
var inst_29931 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30042_30195 = state_29976__$1;
(statearr_30042_30195[(2)] = inst_29931);

(statearr_30042_30195[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (33))){
var inst_29735 = (state_29976[(21)]);
var inst_29752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29753 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_29735);
var state_29976__$1 = (function (){var statearr_30043 = state_29976;
(statearr_30043[(35)] = inst_29752);

return statearr_30043;
})();
if(cljs.core.truth_(inst_29753)){
var statearr_30044_30196 = state_29976__$1;
(statearr_30044_30196[(1)] = (36));

} else {
var statearr_30045_30197 = state_29976__$1;
(statearr_30045_30197[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (13))){
var inst_29702 = (state_29976[(14)]);
var state_29976__$1 = state_29976;
var statearr_30046_30198 = state_29976__$1;
(statearr_30046_30198[(2)] = inst_29702);

(statearr_30046_30198[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (22))){
var inst_29717 = (state_29976[(7)]);
var inst_29724 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_29717);
var state_29976__$1 = state_29976;
var statearr_30047_30199 = state_29976__$1;
(statearr_30047_30199[(2)] = inst_29724);

(statearr_30047_30199[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (90))){
var state_29976__$1 = state_29976;
var statearr_30048_30200 = state_29976__$1;
(statearr_30048_30200[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (36))){
var inst_29735 = (state_29976[(21)]);
var inst_29755 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_29735,cljs.core.dec);
var state_29976__$1 = state_29976;
var statearr_30050_30201 = state_29976__$1;
(statearr_30050_30201[(2)] = inst_29755);

(statearr_30050_30201[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (41))){
var inst_29775 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29775)){
var statearr_30051_30202 = state_29976__$1;
(statearr_30051_30202[(1)] = (45));

} else {
var statearr_30052_30203 = state_29976__$1;
(statearr_30052_30203[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (89))){
var inst_29908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29909 = [cljs.core.cst$kw$_id];
var inst_29910 = flake.o;
var inst_29911 = [inst_29910];
var inst_29912 = cljs.core.PersistentHashMap.fromArrays(inst_29909,inst_29911);
var inst_29913 = [inst_29912,offset_map];
var inst_29914 = (new cljs.core.PersistentVector(null,2,(5),inst_29908,inst_29913,null));
var state_29976__$1 = state_29976;
var statearr_30053_30204 = state_29976__$1;
(statearr_30053_30204[(2)] = inst_29914);

(statearr_30053_30204[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (100))){
var inst_29971 = (state_29976[(2)]);
var _ = (function (){var statearr_30054 = state_29976;
(statearr_30054[(4)] = cljs.core.rest((state_29976[(4)])));

return statearr_30054;
})();
var state_29976__$1 = state_29976;
var statearr_30055_30205 = state_29976__$1;
(statearr_30055_30205[(2)] = inst_29971);

(statearr_30055_30205[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (43))){
var inst_29765 = (state_29976[(29)]);
var state_29976__$1 = state_29976;
var statearr_30056_30206 = state_29976__$1;
(statearr_30056_30206[(2)] = inst_29765);

(statearr_30056_30206[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (61))){
var inst_29812 = (state_29976[(2)]);
var state_29976__$1 = (function (){var statearr_30057 = state_29976;
(statearr_30057[(10)] = inst_29812);

return statearr_30057;
})();
var statearr_30058_30207 = state_29976__$1;
(statearr_30058_30207[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (29))){
var inst_29747 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30060_30208 = state_29976__$1;
(statearr_30060_30208[(2)] = inst_29747);

(statearr_30060_30208[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (44))){
var inst_29772 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30061_30209 = state_29976__$1;
(statearr_30061_30209[(2)] = inst_29772);

(statearr_30061_30209[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (93))){
var state_29976__$1 = state_29976;
var statearr_30062_30210 = state_29976__$1;
(statearr_30062_30210[(2)] = null);

(statearr_30062_30210[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (6))){
var inst_29691 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_29692 = (inst_29691 == null);
var state_29976__$1 = state_29976;
var statearr_30063_30211 = state_29976__$1;
(statearr_30063_30211[(2)] = inst_29692);

(statearr_30063_30211[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (28))){
var inst_29734 = (state_29976[(15)]);
var state_29976__$1 = state_29976;
var statearr_30064_30212 = state_29976__$1;
(statearr_30064_30212[(2)] = inst_29734);

(statearr_30064_30212[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (64))){
var inst_29818 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29976__$1,(57),inst_29818);
} else {
if((state_val_29977 === (103))){
var inst_29969 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30065_30213 = state_29976__$1;
(statearr_30065_30213[(2)] = inst_29969);

(statearr_30065_30213[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (51))){
var inst_29783 = (state_29976[(33)]);
var state_29976__$1 = state_29976;
var statearr_30066_30214 = state_29976__$1;
(statearr_30066_30214[(2)] = inst_29783);

(statearr_30066_30214[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (25))){
var inst_29730 = (state_29976[(16)]);
var state_29976__$1 = state_29976;
var statearr_30067_30215 = state_29976__$1;
(statearr_30067_30215[(2)] = inst_29730);

(statearr_30067_30215[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (34))){
var inst_29730 = (state_29976[(16)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29730)){
var statearr_30068_30216 = state_29976__$1;
(statearr_30068_30216[(1)] = (39));

} else {
var statearr_30069_30217 = state_29976__$1;
(statearr_30069_30217[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (17))){
var inst_29717 = (state_29976[(7)]);
var inst_29718 = (state_29976[(36)]);
var inst_29717__$1 = (state_29976[(2)]);
var inst_29718__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_29717__$1);
var state_29976__$1 = (function (){var statearr_30070 = state_29976;
(statearr_30070[(7)] = inst_29717__$1);

(statearr_30070[(36)] = inst_29718__$1);

return statearr_30070;
})();
if(cljs.core.truth_(inst_29718__$1)){
var statearr_30071_30218 = state_29976__$1;
(statearr_30071_30218[(1)] = (18));

} else {
var statearr_30072_30219 = state_29976__$1;
(statearr_30072_30219[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (3))){
var inst_29974 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29976__$1,inst_29974);
} else {
if((state_val_29977 === (12))){
var inst_29702 = (state_29976[(14)]);
var inst_29707 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29702,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_29976__$1 = state_29976;
var statearr_30073_30220 = state_29976__$1;
(statearr_30073_30220[(2)] = inst_29707);

(statearr_30073_30220[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (2))){
var inst_29689 = (state_29976[(22)]);
var _ = (function (){var statearr_30074 = state_29976;
(statearr_30074[(4)] = cljs.core.cons((5),(state_29976[(4)])));

return statearr_30074;
})();
var inst_29688 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_29689__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_29976__$1 = (function (){var statearr_30075 = state_29976;
(statearr_30075[(20)] = inst_29688);

(statearr_30075[(22)] = inst_29689__$1);

return statearr_30075;
})();
if(cljs.core.truth_(inst_29689__$1)){
var statearr_30076_30221 = state_29976__$1;
(statearr_30076_30221[(1)] = (6));

} else {
var statearr_30077_30222 = state_29976__$1;
(statearr_30077_30222[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (66))){
var inst_29856 = (state_29976[(37)]);
var inst_29856__$1 = componentFollow_QMARK_;
var state_29976__$1 = (function (){var statearr_30078 = state_29976;
(statearr_30078[(37)] = inst_29856__$1);

return statearr_30078;
})();
if(cljs.core.truth_(inst_29856__$1)){
var statearr_30079_30223 = state_29976__$1;
(statearr_30079_30223[(1)] = (72));

} else {
var statearr_30080_30224 = state_29976__$1;
(statearr_30080_30224[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (23))){
var inst_29726 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30081_30225 = state_29976__$1;
(statearr_30081_30225[(2)] = inst_29726);

(statearr_30081_30225[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (47))){
var inst_29933 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30082_30226 = state_29976__$1;
(statearr_30082_30226[(2)] = inst_29933);

(statearr_30082_30226[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (35))){
var inst_29939 = (state_29976[(38)]);
var inst_29936 = (state_29976[(28)]);
var inst_29935 = (state_29976[(2)]);
var inst_29936__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29935,(0),null);
var inst_29937 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29935,(1),null);
var inst_29938 = (inst_29936__$1 == null);
var inst_29939__$1 = cljs.core.not(inst_29938);
var state_29976__$1 = (function (){var statearr_30083 = state_29976;
(statearr_30083[(38)] = inst_29939__$1);

(statearr_30083[(27)] = inst_29937);

(statearr_30083[(28)] = inst_29936__$1);

return statearr_30083;
})();
if(inst_29939__$1){
var statearr_30084_30227 = state_29976__$1;
(statearr_30084_30227[(1)] = (95));

} else {
var statearr_30085_30228 = state_29976__$1;
(statearr_30085_30228[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (82))){
var inst_29885 = (state_29976[(39)]);
var inst_29900 = (state_29976[(2)]);
var inst_29901 = fluree.db.util.async.throw_err(inst_29900);
var inst_29902 = [inst_29901,offset_map];
var inst_29903 = (new cljs.core.PersistentVector(null,2,(5),inst_29885,inst_29902,null));
var state_29976__$1 = state_29976;
var statearr_30086_30229 = state_29976__$1;
(statearr_30086_30229[(2)] = inst_29903);

(statearr_30086_30229[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (76))){
var inst_29731 = (state_29976[(13)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29731)){
var statearr_30087_30230 = state_29976__$1;
(statearr_30087_30230[(1)] = (89));

} else {
var statearr_30088_30231 = state_29976__$1;
(statearr_30088_30231[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (97))){
var inst_29943 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29943)){
var statearr_30089_30232 = state_29976__$1;
(statearr_30089_30232[(1)] = (98));

} else {
var statearr_30090_30233 = state_29976__$1;
(statearr_30090_30233[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (19))){
var inst_29717 = (state_29976[(7)]);
var inst_29721 = (state_29976[(34)]);
var inst_29721__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_29717);
var state_29976__$1 = (function (){var statearr_30091 = state_29976;
(statearr_30091[(34)] = inst_29721__$1);

return statearr_30091;
})();
if(cljs.core.truth_(inst_29721__$1)){
var statearr_30092_30234 = state_29976__$1;
(statearr_30092_30234[(1)] = (21));

} else {
var statearr_30093_30235 = state_29976__$1;
(statearr_30093_30235[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (57))){
var inst_29797 = (state_29976[(31)]);
var inst_29820 = (state_29976[(2)]);
var inst_29821 = fluree.db.util.async.throw_err(inst_29820);
var inst_29822 = [inst_29821,offset_map];
var inst_29823 = (new cljs.core.PersistentVector(null,2,(5),inst_29797,inst_29822,null));
var state_29976__$1 = state_29976;
var statearr_30094_30236 = state_29976__$1;
(statearr_30094_30236[(2)] = inst_29823);

(statearr_30094_30236[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (68))){
var inst_29834 = (state_29976[(8)]);
var state_29976__$1 = state_29976;
var statearr_30095_30237 = state_29976__$1;
(statearr_30095_30237[(2)] = inst_29834);

(statearr_30095_30237[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (11))){
var inst_29702 = (state_29976[(14)]);
var inst_29702__$1 = (state_29976[(2)]);
var inst_29704 = cljs.core.contains_QMARK_(inst_29702__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_29705 = (!(inst_29704));
var state_29976__$1 = (function (){var statearr_30097 = state_29976;
(statearr_30097[(14)] = inst_29702__$1);

return statearr_30097;
})();
if(inst_29705){
var statearr_30098_30238 = state_29976__$1;
(statearr_30098_30238[(1)] = (12));

} else {
var statearr_30099_30239 = state_29976__$1;
(statearr_30099_30239[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (9))){
var inst_29697 = flake.p;
var inst_29698 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_29699 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_29697,inst_29698);
var state_29976__$1 = state_29976;
var statearr_30100_30240 = state_29976__$1;
(statearr_30100_30240[(2)] = inst_29699);

(statearr_30100_30240[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (5))){
var _ = (function (){var statearr_30101 = state_29976;
(statearr_30101[(4)] = cljs.core.rest((state_29976[(4)])));

return statearr_30101;
})();
var state_29976__$1 = state_29976;
var ex30096 = (state_29976__$1[(2)]);
var statearr_30102_30241 = state_29976__$1;
(statearr_30102_30241[(5)] = ex30096);


if((ex30096 instanceof Error)){
var statearr_30103_30242 = state_29976__$1;
(statearr_30103_30242[(1)] = (4));

(statearr_30103_30242[(5)] = null);

} else {
throw ex30096;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (83))){
var inst_29874 = (state_29976[(24)]);
var inst_29888 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_29889 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_29888,inst_29874);
var state_29976__$1 = state_29976;
var statearr_30104_30243 = state_29976__$1;
(statearr_30104_30243[(2)] = inst_29889);

(statearr_30104_30243[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (14))){
var inst_29702 = (state_29976[(14)]);
var inst_29710 = (state_29976[(2)]);
var inst_29711 = cljs.core.contains_QMARK_(inst_29702,cljs.core.cst$kw$compact_QMARK_);
var inst_29712 = (!(inst_29711));
var state_29976__$1 = (function (){var statearr_30105 = state_29976;
(statearr_30105[(32)] = inst_29710);

return statearr_30105;
})();
if(inst_29712){
var statearr_30106_30244 = state_29976__$1;
(statearr_30106_30244[(1)] = (15));

} else {
var statearr_30107_30245 = state_29976__$1;
(statearr_30107_30245[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (45))){
var inst_29777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29778 = [null,offset_map];
var inst_29779 = (new cljs.core.PersistentVector(null,2,(5),inst_29777,inst_29778,null));
var state_29976__$1 = state_29976;
var statearr_30108_30246 = state_29976__$1;
(statearr_30108_30246[(2)] = inst_29779);

(statearr_30108_30246[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (53))){
var inst_29788 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30109_30247 = state_29976__$1;
(statearr_30109_30247[(2)] = inst_29788);

(statearr_30109_30247[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (78))){
var inst_29874 = (state_29976[(24)]);
var inst_29873 = (state_29976[(2)]);
var inst_29874__$1 = fluree.db.util.async.throw_err(inst_29873);
var inst_29875 = cljs.core.empty_QMARK_(inst_29874__$1);
var state_29976__$1 = (function (){var statearr_30110 = state_29976;
(statearr_30110[(24)] = inst_29874__$1);

return statearr_30110;
})();
if(inst_29875){
var statearr_30111_30248 = state_29976__$1;
(statearr_30111_30248[(1)] = (79));

} else {
var statearr_30112_30249 = state_29976__$1;
(statearr_30112_30249[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (26))){
var inst_29750 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29750)){
var statearr_30113_30250 = state_29976__$1;
(statearr_30113_30250[(1)] = (33));

} else {
var statearr_30114_30251 = state_29976__$1;
(statearr_30114_30251[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (16))){
var inst_29710 = (state_29976[(32)]);
var state_29976__$1 = state_29976;
var statearr_30115_30252 = state_29976__$1;
(statearr_30115_30252[(2)] = inst_29710);

(statearr_30115_30252[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (81))){
var inst_29905 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30116_30253 = state_29976__$1;
(statearr_30116_30253[(2)] = inst_29905);

(statearr_30116_30253[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (79))){
var inst_29877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29878 = [cljs.core.cst$kw$_id];
var inst_29879 = flake.o;
var inst_29880 = [inst_29879];
var inst_29881 = cljs.core.PersistentHashMap.fromArrays(inst_29878,inst_29880);
var inst_29882 = [inst_29881,offset_map];
var inst_29883 = (new cljs.core.PersistentVector(null,2,(5),inst_29877,inst_29882,null));
var state_29976__$1 = state_29976;
var statearr_30117_30254 = state_29976__$1;
(statearr_30117_30254[(2)] = inst_29883);

(statearr_30117_30254[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (38))){
var inst_29752 = (state_29976[(35)]);
var inst_29760 = (state_29976[(2)]);
var inst_29761 = [null,inst_29760];
var inst_29762 = (new cljs.core.PersistentVector(null,2,(5),inst_29752,inst_29761,null));
var state_29976__$1 = state_29976;
var statearr_30118_30255 = state_29976__$1;
(statearr_30118_30255[(2)] = inst_29762);

(statearr_30118_30255[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (98))){
var inst_29937 = (state_29976[(27)]);
var inst_29728 = (state_29976[(19)]);
var inst_29936 = (state_29976[(28)]);
var inst_29945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29946 = cljs.core.PersistentVector.EMPTY;
var inst_29947 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_29728,inst_29946);
var inst_29948 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_29947,inst_29936);
var inst_29949 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_29728,inst_29948);
var inst_29950 = [inst_29949,inst_29937];
var inst_29951 = (new cljs.core.PersistentVector(null,2,(5),inst_29945,inst_29950,null));
var state_29976__$1 = state_29976;
var statearr_30119_30256 = state_29976__$1;
(statearr_30119_30256[(2)] = inst_29951);

(statearr_30119_30256[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (87))){
var inst_29892 = (state_29976[(25)]);
var state_29976__$1 = state_29976;
var statearr_30120_30257 = state_29976__$1;
(statearr_30120_30257[(2)] = inst_29892);

(statearr_30120_30257[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (30))){
var inst_29735 = (state_29976[(21)]);
var inst_29740 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_29735);
var inst_29741 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_29740);
var state_29976__$1 = state_29976;
var statearr_30121_30258 = state_29976__$1;
(statearr_30121_30258[(2)] = inst_29741);

(statearr_30121_30258[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (73))){
var inst_29856 = (state_29976[(37)]);
var state_29976__$1 = state_29976;
var statearr_30122_30259 = state_29976__$1;
(statearr_30122_30259[(2)] = inst_29856);

(statearr_30122_30259[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (96))){
var inst_29939 = (state_29976[(38)]);
var state_29976__$1 = state_29976;
var statearr_30123_30260 = state_29976__$1;
(statearr_30123_30260[(2)] = inst_29939);

(statearr_30123_30260[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (10))){
var state_29976__$1 = state_29976;
var statearr_30124_30261 = state_29976__$1;
(statearr_30124_30261[(2)] = pred_spec);

(statearr_30124_30261[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (18))){
var inst_29718 = (state_29976[(36)]);
var state_29976__$1 = state_29976;
var statearr_30125_30262 = state_29976__$1;
(statearr_30125_30262[(2)] = inst_29718);

(statearr_30125_30262[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (105))){
var state_29976__$1 = state_29976;
var statearr_30126_30263 = state_29976__$1;
(statearr_30126_30263[(2)] = null);

(statearr_30126_30263[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (52))){
var inst_29717 = (state_29976[(7)]);
var inst_29786 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_29717);
var state_29976__$1 = state_29976;
var statearr_30127_30264 = state_29976__$1;
(statearr_30127_30264[(2)] = inst_29786);

(statearr_30127_30264[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (67))){
var inst_29929 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30128_30265 = state_29976__$1;
(statearr_30128_30265[(2)] = inst_29929);

(statearr_30128_30265[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (71))){
var inst_29717 = (state_29976[(7)]);
var inst_29841 = (state_29976[(2)]);
var inst_29842 = fluree.db.util.async.throw_err(inst_29841);
var inst_29843 = cljs.core._deref(cache);
var inst_29844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29845 = flake.o;
var inst_29846 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_29717);
var inst_29847 = [inst_29845,inst_29846];
var inst_29848 = (new cljs.core.PersistentVector(null,2,(5),inst_29844,inst_29847,null));
var inst_29849 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29843,inst_29848,inst_29842);
var inst_29850 = cljs.core._vreset_BANG_(cache,inst_29849);
var state_29976__$1 = (function (){var statearr_30129 = state_29976;
(statearr_30129[(40)] = inst_29850);

return statearr_30129;
})();
var statearr_30130_30266 = state_29976__$1;
(statearr_30130_30266[(2)] = inst_29842);

(statearr_30130_30266[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (42))){
var inst_29732 = (state_29976[(17)]);
var inst_29728 = (state_29976[(19)]);
var inst_29767 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_29728);
var inst_29768 = cljs.core.count(inst_29767);
var inst_29769 = (inst_29768 >= inst_29732);
var state_29976__$1 = state_29976;
var statearr_30131_30267 = state_29976__$1;
(statearr_30131_30267[(2)] = inst_29769);

(statearr_30131_30267[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (80))){
var inst_29885 = cljs.core.PersistentVector.EMPTY_NODE;
var state_29976__$1 = (function (){var statearr_30132 = state_29976;
(statearr_30132[(39)] = inst_29885);

return statearr_30132;
})();
if(cljs.core.truth_(fuel)){
var statearr_30133_30268 = state_29976__$1;
(statearr_30133_30268[(1)] = (83));

} else {
var statearr_30134_30269 = state_29976__$1;
(statearr_30134_30269[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (37))){
var inst_29734 = (state_29976[(15)]);
var inst_29735 = (state_29976[(21)]);
var inst_29757 = (inst_29734 - (1));
var inst_29758 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_29735,inst_29757);
var state_29976__$1 = state_29976;
var statearr_30135_30270 = state_29976__$1;
(statearr_30135_30270[(2)] = inst_29758);

(statearr_30135_30270[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (63))){
var inst_29812 = (state_29976[(10)]);
var state_29976__$1 = state_29976;
var statearr_30136_30271 = state_29976__$1;
(statearr_30136_30271[(2)] = inst_29812);

(statearr_30136_30271[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (94))){
var inst_29923 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
var statearr_30137_30272 = state_29976__$1;
(statearr_30137_30272[(2)] = inst_29923);

(statearr_30137_30272[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (8))){
var inst_29695 = (state_29976[(2)]);
var state_29976__$1 = state_29976;
if(cljs.core.truth_(inst_29695)){
var statearr_30138_30273 = state_29976__$1;
(statearr_30138_30273[(1)] = (9));

} else {
var statearr_30139_30274 = state_29976__$1;
(statearr_30139_30274[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (49))){
var inst_29781 = (state_29976[(30)]);
var state_29976__$1 = state_29976;
var statearr_30140_30275 = state_29976__$1;
(statearr_30140_30275[(2)] = inst_29781);

(statearr_30140_30275[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29977 === (84))){
var inst_29874 = (state_29976[(24)]);
var state_29976__$1 = state_29976;
var statearr_30141_30276 = state_29976__$1;
(statearr_30141_30276[(2)] = inst_29874);

(statearr_30141_30276[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10841__auto__ = null;
var fluree$db$query$fql$state_machine__10841__auto____0 = (function (){
var statearr_30142 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30142[(0)] = fluree$db$query$fql$state_machine__10841__auto__);

(statearr_30142[(1)] = (1));

return statearr_30142;
});
var fluree$db$query$fql$state_machine__10841__auto____1 = (function (state_29976){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_29976);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e30143){var ex__10844__auto__ = e30143;
var statearr_30144_30277 = state_29976;
(statearr_30144_30277[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_29976[(4)]))){
var statearr_30145_30278 = state_29976;
(statearr_30145_30278[(1)] = cljs.core.first((state_29976[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__30279 = state_29976;
state_29976 = G__30279;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10841__auto__ = function(state_29976){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10841__auto____1.call(this,state_29976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10841__auto____0;
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10841__auto____1;
return fluree$db$query$fql$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_30146 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_30146[(6)] = c__10878__auto__);

return statearr_30146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_30439){
var state_val_30440 = (state_30439[(1)]);
if((state_val_30440 === (7))){
var inst_30434 = (state_30439[(2)]);
var _ = (function (){var statearr_30441 = state_30439;
(statearr_30441[(4)] = cljs.core.rest((state_30439[(4)])));

return statearr_30441;
})();
var state_30439__$1 = state_30439;
var statearr_30442_30524 = state_30439__$1;
(statearr_30442_30524[(2)] = inst_30434);

(statearr_30442_30524[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (20))){
var inst_30361 = (state_30439[(7)]);
var state_30439__$1 = state_30439;
var statearr_30443_30525 = state_30439__$1;
(statearr_30443_30525[(2)] = inst_30361);

(statearr_30443_30525[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (27))){
var inst_30316 = (state_30439[(8)]);
var state_30439__$1 = state_30439;
if(cljs.core.truth_(inst_30316)){
var statearr_30444_30526 = state_30439__$1;
(statearr_30444_30526[(1)] = (29));

} else {
var statearr_30445_30527 = state_30439__$1;
(statearr_30445_30527[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (1))){
var state_30439__$1 = state_30439;
var statearr_30446_30528 = state_30439__$1;
(statearr_30446_30528[(2)] = null);

(statearr_30446_30528[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (24))){
var inst_30317 = (state_30439[(9)]);
var state_30439__$1 = state_30439;
var statearr_30447_30529 = state_30439__$1;
(statearr_30447_30529[(2)] = inst_30317);

(statearr_30447_30529[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (39))){
var inst_30353 = (state_30439[(10)]);
var state_30439__$1 = state_30439;
var statearr_30448_30530 = state_30439__$1;
(statearr_30448_30530[(2)] = inst_30353);

(statearr_30448_30530[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (46))){
var inst_30318 = (state_30439[(11)]);
var state_30439__$1 = state_30439;
var statearr_30449_30531 = state_30439__$1;
(statearr_30449_30531[(2)] = inst_30318);

(statearr_30449_30531[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (4))){
var inst_30280 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
var statearr_30450_30532 = state_30439__$1;
(statearr_30450_30532[(2)] = inst_30280);

(statearr_30450_30532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (15))){
var inst_30329 = (state_30439[(12)]);
var inst_30335 = cljs.core.count(inst_30329);
var inst_30336 = fluree.db.query.fql.add_fuel(fuel,inst_30335,max_fuel);
var state_30439__$1 = state_30439;
var statearr_30451_30533 = state_30439__$1;
(statearr_30451_30533[(2)] = inst_30336);

(statearr_30451_30533[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (48))){
var inst_30420 = (state_30439[(13)]);
var inst_30305 = (state_30439[(14)]);
var inst_30298 = (state_30439[(15)]);
var inst_30428 = (state_30439[(2)]);
var inst_30429 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30298,inst_30428,inst_30420);
var inst_30297 = inst_30305;
var inst_30298__$1 = inst_30429;
var state_30439__$1 = (function (){var statearr_30452 = state_30439;
(statearr_30452[(16)] = inst_30297);

(statearr_30452[(15)] = inst_30298__$1);

return statearr_30452;
})();
var statearr_30453_30534 = state_30439__$1;
(statearr_30453_30534[(2)] = null);

(statearr_30453_30534[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (50))){
var inst_30320 = (state_30439[(17)]);
var state_30439__$1 = state_30439;
var statearr_30454_30535 = state_30439__$1;
(statearr_30454_30535[(2)] = inst_30320);

(statearr_30454_30535[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (21))){
var inst_30317 = (state_30439[(9)]);
var state_30439__$1 = state_30439;
if(cljs.core.truth_(inst_30317)){
var statearr_30456_30536 = state_30439__$1;
(statearr_30456_30536[(1)] = (23));

} else {
var statearr_30457_30537 = state_30439__$1;
(statearr_30457_30537[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (31))){
var inst_30377 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
if(cljs.core.truth_(inst_30377)){
var statearr_30458_30538 = state_30439__$1;
(statearr_30458_30538[(1)] = (32));

} else {
var statearr_30459_30539 = state_30439__$1;
(statearr_30459_30539[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (32))){
var inst_30353 = (state_30439[(10)]);
var inst_30352 = (state_30439[(18)]);
var inst_30360 = (state_30439[(19)]);
var inst_30379 = (inst_30352 + (1));
var tmp30455 = inst_30353;
var inst_30351 = inst_30360;
var inst_30352__$1 = inst_30379;
var inst_30353__$1 = tmp30455;
var state_30439__$1 = (function (){var statearr_30460 = state_30439;
(statearr_30460[(20)] = inst_30351);

(statearr_30460[(10)] = inst_30353__$1);

(statearr_30460[(18)] = inst_30352__$1);

return statearr_30460;
})();
var statearr_30461_30540 = state_30439__$1;
(statearr_30461_30540[(2)] = null);

(statearr_30461_30540[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (40))){
var state_30439__$1 = state_30439;
if(cljs.core.truth_(fuel)){
var statearr_30462_30541 = state_30439__$1;
(statearr_30462_30541[(1)] = (42));

} else {
var statearr_30463_30542 = state_30439__$1;
(statearr_30463_30542[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (33))){
var state_30439__$1 = state_30439;
var statearr_30464_30543 = state_30439__$1;
(statearr_30464_30543[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (13))){
var inst_30329 = (state_30439[(12)]);
var state_30439__$1 = state_30439;
var statearr_30466_30544 = state_30439__$1;
(statearr_30466_30544[(2)] = inst_30329);

(statearr_30466_30544[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (22))){
var inst_30370 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
if(cljs.core.truth_(inst_30370)){
var statearr_30467_30545 = state_30439__$1;
(statearr_30467_30545[(1)] = (26));

} else {
var statearr_30468_30546 = state_30439__$1;
(statearr_30468_30546[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (36))){
var state_30439__$1 = state_30439;
var statearr_30469_30547 = state_30439__$1;
(statearr_30469_30547[(2)] = null);

(statearr_30469_30547[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (41))){
var inst_30352 = (state_30439[(18)]);
var inst_30360 = (state_30439[(19)]);
var inst_30409 = (state_30439[(2)]);
var inst_30410 = (inst_30352 + (1));
var inst_30351 = inst_30360;
var inst_30352__$1 = inst_30410;
var inst_30353 = inst_30409;
var state_30439__$1 = (function (){var statearr_30470 = state_30439;
(statearr_30470[(20)] = inst_30351);

(statearr_30470[(10)] = inst_30353);

(statearr_30470[(18)] = inst_30352__$1);

return statearr_30470;
})();
var statearr_30471_30548 = state_30439__$1;
(statearr_30471_30548[(2)] = null);

(statearr_30471_30548[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (43))){
var state_30439__$1 = state_30439;
var statearr_30472_30549 = state_30439__$1;
(statearr_30472_30549[(2)] = null);

(statearr_30472_30549[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (29))){
var inst_30316 = (state_30439[(8)]);
var inst_30352 = (state_30439[(18)]);
var inst_30374 = (inst_30352 < inst_30316);
var state_30439__$1 = state_30439;
var statearr_30473_30550 = state_30439__$1;
(statearr_30473_30550[(2)] = inst_30374);

(statearr_30473_30550[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (44))){
var inst_30393 = (state_30439[(21)]);
var inst_30389 = (state_30439[(22)]);
var inst_30402 = (state_30439[(2)]);
var inst_30403 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_30393,inst_30389) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_30393,inst_30389));
var state_30439__$1 = (function (){var statearr_30474 = state_30439;
(statearr_30474[(23)] = inst_30402);

return statearr_30474;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30439__$1,(45),inst_30403);
} else {
if((state_val_30440 === (6))){
var inst_30297 = (state_30439[(16)]);
var inst_30304 = (state_30439[(24)]);
var inst_30303 = cljs.core.seq(inst_30297);
var inst_30304__$1 = cljs.core.first(inst_30303);
var inst_30305 = cljs.core.next(inst_30303);
var inst_30306 = cljs.core.not(inst_30304__$1);
var state_30439__$1 = (function (){var statearr_30475 = state_30439;
(statearr_30475[(24)] = inst_30304__$1);

(statearr_30475[(14)] = inst_30305);

return statearr_30475;
})();
if(inst_30306){
var statearr_30476_30551 = state_30439__$1;
(statearr_30476_30551[(1)] = (8));

} else {
var statearr_30477_30552 = state_30439__$1;
(statearr_30477_30552[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (28))){
var inst_30418 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
var statearr_30478_30553 = state_30439__$1;
(statearr_30478_30553[(2)] = inst_30418);

(statearr_30478_30553[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (51))){
var inst_30426 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
var statearr_30479_30554 = state_30439__$1;
(statearr_30479_30554[(2)] = inst_30426);

(statearr_30479_30554[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (25))){
var inst_30368 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
var statearr_30480_30555 = state_30439__$1;
(statearr_30480_30555[(2)] = inst_30368);

(statearr_30480_30555[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (34))){
var inst_30416 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
var statearr_30481_30556 = state_30439__$1;
(statearr_30481_30556[(2)] = inst_30416);

(statearr_30481_30556[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (17))){
var inst_30329 = (state_30439[(12)]);
var inst_30339 = (state_30439[(2)]);
var inst_30347 = cljs.core.seq(inst_30329);
var inst_30348 = cljs.core.first(inst_30347);
var inst_30349 = cljs.core.next(inst_30347);
var inst_30350 = cljs.core.PersistentVector.EMPTY;
var inst_30351 = inst_30329;
var inst_30352 = (0);
var inst_30353 = inst_30350;
var state_30439__$1 = (function (){var statearr_30482 = state_30439;
(statearr_30482[(20)] = inst_30351);

(statearr_30482[(25)] = inst_30339);

(statearr_30482[(26)] = inst_30348);

(statearr_30482[(10)] = inst_30353);

(statearr_30482[(18)] = inst_30352);

(statearr_30482[(27)] = inst_30349);

return statearr_30482;
})();
var statearr_30483_30557 = state_30439__$1;
(statearr_30483_30557[(2)] = null);

(statearr_30483_30557[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (3))){
var inst_30437 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30439__$1,inst_30437);
} else {
if((state_val_30440 === (12))){
var state_30439__$1 = state_30439;
var statearr_30484_30558 = state_30439__$1;
(statearr_30484_30558[(2)] = fuel);

(statearr_30484_30558[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (2))){
var _ = (function (){var statearr_30485 = state_30439;
(statearr_30485[(4)] = cljs.core.cons((5),(state_30439[(4)])));

return statearr_30485;
})();
var inst_30293 = reverse_refs_specs;
var inst_30294 = cljs.core.seq(inst_30293);
var inst_30295 = cljs.core.first(inst_30294);
var inst_30296 = cljs.core.next(inst_30294);
var inst_30297 = inst_30293;
var inst_30298 = null;
var state_30439__$1 = (function (){var statearr_30486 = state_30439;
(statearr_30486[(16)] = inst_30297);

(statearr_30486[(28)] = inst_30296);

(statearr_30486[(29)] = inst_30295);

(statearr_30486[(15)] = inst_30298);

return statearr_30486;
})();
var statearr_30487_30559 = state_30439__$1;
(statearr_30487_30559[(2)] = null);

(statearr_30487_30559[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (23))){
var inst_30317 = (state_30439[(9)]);
var inst_30352 = (state_30439[(18)]);
var inst_30365 = (inst_30352 >= inst_30317);
var state_30439__$1 = state_30439;
var statearr_30488_30560 = state_30439__$1;
(statearr_30488_30560[(2)] = inst_30365);

(statearr_30488_30560[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (47))){
var inst_30319 = (state_30439[(30)]);
var state_30439__$1 = state_30439;
if(cljs.core.truth_(inst_30319)){
var statearr_30489_30561 = state_30439__$1;
(statearr_30489_30561[(1)] = (49));

} else {
var statearr_30490_30562 = state_30439__$1;
(statearr_30490_30562[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (35))){
var inst_30359 = (state_30439[(31)]);
var inst_30383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30384 = [inst_30359];
var inst_30385 = (new cljs.core.PersistentVector(null,1,(5),inst_30383,inst_30384,null));
var inst_30386 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_30385);
var state_30439__$1 = state_30439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30439__$1,(38),inst_30386);
} else {
if((state_val_30440 === (19))){
var inst_30318 = (state_30439[(11)]);
var inst_30420 = (state_30439[(2)]);
var state_30439__$1 = (function (){var statearr_30491 = state_30439;
(statearr_30491[(13)] = inst_30420);

return statearr_30491;
})();
if(cljs.core.truth_(inst_30318)){
var statearr_30492_30563 = state_30439__$1;
(statearr_30492_30563[(1)] = (46));

} else {
var statearr_30493_30564 = state_30439__$1;
(statearr_30493_30564[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (11))){
var inst_30329 = (state_30439[(12)]);
var inst_30326 = (state_30439[(2)]);
var inst_30327 = fluree.db.util.async.throw_err(inst_30326);
var inst_30328 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_30327);
var inst_30329__$1 = cljs.core.not_empty(inst_30328);
var state_30439__$1 = (function (){var statearr_30495 = state_30439;
(statearr_30495[(12)] = inst_30329__$1);

return statearr_30495;
})();
if(cljs.core.truth_(inst_30329__$1)){
var statearr_30496_30565 = state_30439__$1;
(statearr_30496_30565[(1)] = (12));

} else {
var statearr_30497_30566 = state_30439__$1;
(statearr_30497_30566[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (9))){
var inst_30314 = (state_30439[(32)]);
var inst_30304 = (state_30439[(24)]);
var inst_30313 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30304,(0),null);
var inst_30314__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30304,(1),null);
var inst_30315 = cljs.core.__destructure_map(inst_30314__$1);
var inst_30316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30315,cljs.core.cst$kw$offset);
var inst_30317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30315,cljs.core.cst$kw$limit);
var inst_30318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30315,cljs.core.cst$kw$as);
var inst_30319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30315,cljs.core.cst$kw$name);
var inst_30320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30315,cljs.core.cst$kw$p);
var inst_30321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30322 = [subject_id,inst_30313];
var inst_30323 = (new cljs.core.PersistentVector(null,2,(5),inst_30321,inst_30322,null));
var inst_30324 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_30323);
var state_30439__$1 = (function (){var statearr_30498 = state_30439;
(statearr_30498[(32)] = inst_30314__$1);

(statearr_30498[(17)] = inst_30320);

(statearr_30498[(9)] = inst_30317);

(statearr_30498[(8)] = inst_30316);

(statearr_30498[(11)] = inst_30318);

(statearr_30498[(30)] = inst_30319);

return statearr_30498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30439__$1,(11),inst_30324);
} else {
if((state_val_30440 === (5))){
var _ = (function (){var statearr_30499 = state_30439;
(statearr_30499[(4)] = cljs.core.rest((state_30439[(4)])));

return statearr_30499;
})();
var state_30439__$1 = state_30439;
var ex30494 = (state_30439__$1[(2)]);
var statearr_30500_30567 = state_30439__$1;
(statearr_30500_30567[(5)] = ex30494);


if((ex30494 instanceof Error)){
var statearr_30501_30568 = state_30439__$1;
(statearr_30501_30568[(1)] = (4));

(statearr_30501_30568[(5)] = null);

} else {
throw ex30494;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (14))){
var inst_30333 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
if(cljs.core.truth_(inst_30333)){
var statearr_30502_30569 = state_30439__$1;
(statearr_30502_30569[(1)] = (15));

} else {
var statearr_30503_30570 = state_30439__$1;
(statearr_30503_30570[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (45))){
var inst_30353 = (state_30439[(10)]);
var inst_30405 = (state_30439[(2)]);
var inst_30406 = fluree.db.util.async.throw_err(inst_30405);
var inst_30407 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30353,inst_30406);
var state_30439__$1 = state_30439;
var statearr_30504_30571 = state_30439__$1;
(statearr_30504_30571[(2)] = inst_30407);

(statearr_30504_30571[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (26))){
var inst_30353 = (state_30439[(10)]);
var state_30439__$1 = state_30439;
var statearr_30505_30572 = state_30439__$1;
(statearr_30505_30572[(2)] = inst_30353);

(statearr_30505_30572[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (16))){
var state_30439__$1 = state_30439;
var statearr_30506_30573 = state_30439__$1;
(statearr_30506_30573[(2)] = null);

(statearr_30506_30573[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (38))){
var inst_30314 = (state_30439[(32)]);
var inst_30389 = (state_30439[(22)]);
var inst_30388 = (state_30439[(2)]);
var inst_30389__$1 = fluree.db.util.async.throw_err(inst_30388);
var inst_30390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30391 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_30392 = (new cljs.core.PersistentVector(null,4,(5),inst_30390,inst_30391,null));
var inst_30393 = cljs.core.select_keys(inst_30314,inst_30392);
var inst_30394 = cljs.core.empty_QMARK_(inst_30389__$1);
var state_30439__$1 = (function (){var statearr_30507 = state_30439;
(statearr_30507[(21)] = inst_30393);

(statearr_30507[(22)] = inst_30389__$1);

return statearr_30507;
})();
if(inst_30394){
var statearr_30508_30574 = state_30439__$1;
(statearr_30508_30574[(1)] = (39));

} else {
var statearr_30509_30575 = state_30439__$1;
(statearr_30509_30575[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (30))){
var inst_30316 = (state_30439[(8)]);
var state_30439__$1 = state_30439;
var statearr_30510_30576 = state_30439__$1;
(statearr_30510_30576[(2)] = inst_30316);

(statearr_30510_30576[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (10))){
var inst_30432 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
var statearr_30511_30577 = state_30439__$1;
(statearr_30511_30577[(2)] = inst_30432);

(statearr_30511_30577[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (18))){
var inst_30351 = (state_30439[(20)]);
var inst_30359 = (state_30439[(31)]);
var inst_30361 = (state_30439[(7)]);
var inst_30358 = cljs.core.seq(inst_30351);
var inst_30359__$1 = cljs.core.first(inst_30358);
var inst_30360 = cljs.core.next(inst_30358);
var inst_30361__$1 = cljs.core.not(inst_30359__$1);
var state_30439__$1 = (function (){var statearr_30512 = state_30439;
(statearr_30512[(31)] = inst_30359__$1);

(statearr_30512[(7)] = inst_30361__$1);

(statearr_30512[(19)] = inst_30360);

return statearr_30512;
})();
if(inst_30361__$1){
var statearr_30513_30578 = state_30439__$1;
(statearr_30513_30578[(1)] = (20));

} else {
var statearr_30514_30579 = state_30439__$1;
(statearr_30514_30579[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (42))){
var inst_30389 = (state_30439[(22)]);
var inst_30398 = cljs.core.count(inst_30389);
var inst_30399 = fluree.db.query.fql.add_fuel(fuel,inst_30398,max_fuel);
var state_30439__$1 = state_30439;
var statearr_30515_30580 = state_30439__$1;
(statearr_30515_30580[(2)] = inst_30399);

(statearr_30515_30580[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (37))){
var inst_30414 = (state_30439[(2)]);
var state_30439__$1 = state_30439;
var statearr_30516_30581 = state_30439__$1;
(statearr_30516_30581[(2)] = inst_30414);

(statearr_30516_30581[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (8))){
var inst_30298 = (state_30439[(15)]);
var state_30439__$1 = state_30439;
var statearr_30517_30582 = state_30439__$1;
(statearr_30517_30582[(2)] = inst_30298);

(statearr_30517_30582[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30440 === (49))){
var inst_30319 = (state_30439[(30)]);
var state_30439__$1 = state_30439;
var statearr_30518_30583 = state_30439__$1;
(statearr_30518_30583[(2)] = inst_30319);

(statearr_30518_30583[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto____0 = (function (){
var statearr_30519 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30519[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto__);

(statearr_30519[(1)] = (1));

return statearr_30519;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto____1 = (function (state_30439){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_30439);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e30520){var ex__10844__auto__ = e30520;
var statearr_30521_30584 = state_30439;
(statearr_30521_30584[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_30439[(4)]))){
var statearr_30522_30585 = state_30439;
(statearr_30522_30585[(1)] = cljs.core.first((state_30439[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__30586 = state_30439;
state_30439 = G__30586;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto__ = function(state_30439){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto____1.call(this,state_30439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_30523 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_30523[(6)] = c__10878__auto__);

return statearr_30523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__30587 = select_spec;
var map__30587__$1 = cljs.core.__destructure_map(map__30587);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30587__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30587__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_30649){
var state_val_30650 = (state_30649[(1)]);
if((state_val_30650 === (7))){
var inst_30613 = (state_30649[(7)]);
var inst_30615 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_30616 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_30615,inst_30613);
var state_30649__$1 = state_30649;
var statearr_30651_30690 = state_30649__$1;
(statearr_30651_30690[(2)] = inst_30616);

(statearr_30651_30690[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (20))){
var inst_30619 = (state_30649[(8)]);
var inst_30637 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_30638 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_30637,inst_30619) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_30637,inst_30619));
var state_30649__$1 = state_30649;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30649__$1,(22),inst_30638);
} else {
if((state_val_30650 === (1))){
var state_30649__$1 = state_30649;
var statearr_30652_30691 = state_30649__$1;
(statearr_30652_30691[(2)] = null);

(statearr_30652_30691[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (4))){
var inst_30588 = (state_30649[(2)]);
var state_30649__$1 = state_30649;
var statearr_30653_30692 = state_30649__$1;
(statearr_30653_30692[(2)] = inst_30588);

(statearr_30653_30692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (15))){
var inst_30626 = (state_30649[(2)]);
var state_30649__$1 = state_30649;
var statearr_30654_30693 = state_30649__$1;
(statearr_30654_30693[(2)] = inst_30626);

(statearr_30654_30693[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (21))){
var inst_30644 = (state_30649[(2)]);
var _ = (function (){var statearr_30655 = state_30649;
(statearr_30655[(4)] = cljs.core.rest((state_30649[(4)])));

return statearr_30655;
})();
var state_30649__$1 = state_30649;
var statearr_30656_30694 = state_30649__$1;
(statearr_30656_30694[(2)] = inst_30644);

(statearr_30656_30694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (13))){
var inst_30605 = (state_30649[(9)]);
var state_30649__$1 = state_30649;
var statearr_30657_30695 = state_30649__$1;
(statearr_30657_30695[(2)] = inst_30605);

(statearr_30657_30695[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (22))){
var inst_30599 = (state_30649[(10)]);
var inst_30634 = (state_30649[(11)]);
var inst_30640 = (state_30649[(2)]);
var inst_30641 = fluree.db.util.async.throw_err(inst_30640);
var inst_30642 = (inst_30634.cljs$core$IFn$_invoke$arity$3 ? inst_30634.cljs$core$IFn$_invoke$arity$3(acc,inst_30599,inst_30641) : inst_30634.call(null,acc,inst_30599,inst_30641));
var state_30649__$1 = state_30649;
var statearr_30658_30696 = state_30649__$1;
(statearr_30658_30696[(2)] = inst_30642);

(statearr_30658_30696[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (6))){
var inst_30612 = (state_30649[(2)]);
var inst_30613 = fluree.db.util.async.throw_err(inst_30612);
var state_30649__$1 = (function (){var statearr_30659 = state_30649;
(statearr_30659[(7)] = inst_30613);

return statearr_30659;
})();
if(cljs.core.truth_(fuel)){
var statearr_30660_30697 = state_30649__$1;
(statearr_30660_30697[(1)] = (7));

} else {
var statearr_30661_30698 = state_30649__$1;
(statearr_30661_30698[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (17))){
var inst_30605 = (state_30649[(9)]);
var inst_30619 = (state_30649[(8)]);
var inst_30598 = (state_30649[(12)]);
var inst_30597 = (state_30649[(13)]);
var inst_30601 = (state_30649[(14)]);
var inst_30602 = (state_30649[(15)]);
var inst_30628 = (state_30649[(16)]);
var inst_30604 = (state_30649[(17)]);
var inst_30603 = (state_30649[(18)]);
var inst_30599 = (state_30649[(10)]);
var inst_30600 = (state_30649[(19)]);
var inst_30595 = (state_30649[(20)]);
var inst_30632 = (function (){var recur_seen = inst_30601;
var recur_subject = inst_30595;
var sub_flakes = inst_30619;
var seen_QMARK_ = inst_30604;
var map__30594 = inst_30597;
var multi_QMARK_ = inst_30598;
var limit = inst_30603;
var recur_depth = inst_30602;
var as = inst_30599;
var max_depth_QMARK_ = inst_30605;
var recur = inst_30600;
var stop_QMARK_ = inst_30628;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_30649__$1 = state_30649;
var statearr_30662_30699 = state_30649__$1;
(statearr_30662_30699[(2)] = inst_30632);

(statearr_30662_30699[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (3))){
var inst_30647 = (state_30649[(2)]);
var state_30649__$1 = state_30649;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30649__$1,inst_30647);
} else {
if((state_val_30650 === (12))){
var inst_30598 = (state_30649[(12)]);
var inst_30628 = (state_30649[(2)]);
var state_30649__$1 = (function (){var statearr_30663 = state_30649;
(statearr_30663[(16)] = inst_30628);

return statearr_30663;
})();
if(cljs.core.truth_(inst_30598)){
var statearr_30664_30700 = state_30649__$1;
(statearr_30664_30700[(1)] = (16));

} else {
var statearr_30665_30701 = state_30649__$1;
(statearr_30665_30701[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (2))){
var inst_30597 = (state_30649[(13)]);
var inst_30601 = (state_30649[(14)]);
var inst_30602 = (state_30649[(15)]);
var inst_30600 = (state_30649[(19)]);
var inst_30595 = (state_30649[(20)]);
var _ = (function (){var statearr_30666 = state_30649;
(statearr_30666[(4)] = cljs.core.cons((5),(state_30649[(4)])));

return statearr_30666;
})();
var inst_30595__$1 = flake.o;
var inst_30596 = select_spec;
var inst_30597__$1 = cljs.core.__destructure_map(inst_30596);
var inst_30598 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30597__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_30599 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30597__$1,cljs.core.cst$kw$as);
var inst_30600__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30597__$1,cljs.core.cst$kw$recur);
var inst_30601__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30597__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_30602__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30597__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_30603 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30597__$1,cljs.core.cst$kw$limit);
var inst_30604 = cljs.core.contains_QMARK_(inst_30601__$1,inst_30595__$1);
var inst_30605 = (inst_30602__$1 > inst_30600__$1);
var inst_30607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30608 = [inst_30595__$1];
var inst_30609 = (new cljs.core.PersistentVector(null,1,(5),inst_30607,inst_30608,null));
var inst_30610 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_30609);
var state_30649__$1 = (function (){var statearr_30667 = state_30649;
(statearr_30667[(9)] = inst_30605);

(statearr_30667[(12)] = inst_30598);

(statearr_30667[(13)] = inst_30597__$1);

(statearr_30667[(14)] = inst_30601__$1);

(statearr_30667[(15)] = inst_30602__$1);

(statearr_30667[(17)] = inst_30604);

(statearr_30667[(18)] = inst_30603);

(statearr_30667[(10)] = inst_30599);

(statearr_30667[(19)] = inst_30600__$1);

(statearr_30667[(20)] = inst_30595__$1);

return statearr_30667;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30649__$1,(6),inst_30610);
} else {
if((state_val_30650 === (19))){
var state_30649__$1 = state_30649;
var statearr_30668_30702 = state_30649__$1;
(statearr_30668_30702[(2)] = acc);

(statearr_30668_30702[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (11))){
var inst_30605 = (state_30649[(9)]);
var state_30649__$1 = state_30649;
if(cljs.core.truth_(inst_30605)){
var statearr_30670_30703 = state_30649__$1;
(statearr_30670_30703[(1)] = (13));

} else {
var statearr_30671_30704 = state_30649__$1;
(statearr_30671_30704[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (9))){
var inst_30604 = (state_30649[(17)]);
var inst_30619 = (state_30649[(2)]);
var state_30649__$1 = (function (){var statearr_30672 = state_30649;
(statearr_30672[(8)] = inst_30619);

return statearr_30672;
})();
if(cljs.core.truth_(inst_30604)){
var statearr_30673_30705 = state_30649__$1;
(statearr_30673_30705[(1)] = (10));

} else {
var statearr_30674_30706 = state_30649__$1;
(statearr_30674_30706[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (5))){
var _ = (function (){var statearr_30675 = state_30649;
(statearr_30675[(4)] = cljs.core.rest((state_30649[(4)])));

return statearr_30675;
})();
var state_30649__$1 = state_30649;
var ex30669 = (state_30649__$1[(2)]);
var statearr_30676_30707 = state_30649__$1;
(statearr_30676_30707[(5)] = ex30669);


if((ex30669 instanceof Error)){
var statearr_30677_30708 = state_30649__$1;
(statearr_30677_30708[(1)] = (4));

(statearr_30677_30708[(5)] = null);

} else {
throw ex30669;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (14))){
var inst_30619 = (state_30649[(8)]);
var inst_30624 = cljs.core.empty_QMARK_(inst_30619);
var state_30649__$1 = state_30649;
var statearr_30678_30709 = state_30649__$1;
(statearr_30678_30709[(2)] = inst_30624);

(statearr_30678_30709[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (16))){
var inst_30605 = (state_30649[(9)]);
var inst_30619 = (state_30649[(8)]);
var inst_30598 = (state_30649[(12)]);
var inst_30597 = (state_30649[(13)]);
var inst_30601 = (state_30649[(14)]);
var inst_30602 = (state_30649[(15)]);
var inst_30628 = (state_30649[(16)]);
var inst_30604 = (state_30649[(17)]);
var inst_30603 = (state_30649[(18)]);
var inst_30599 = (state_30649[(10)]);
var inst_30600 = (state_30649[(19)]);
var inst_30595 = (state_30649[(20)]);
var inst_30630 = (function (){var recur_seen = inst_30601;
var recur_subject = inst_30595;
var sub_flakes = inst_30619;
var seen_QMARK_ = inst_30604;
var map__30594 = inst_30597;
var multi_QMARK_ = inst_30598;
var limit = inst_30603;
var recur_depth = inst_30602;
var as = inst_30599;
var max_depth_QMARK_ = inst_30605;
var recur = inst_30600;
var stop_QMARK_ = inst_30628;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_30649__$1 = state_30649;
var statearr_30679_30710 = state_30649__$1;
(statearr_30679_30710[(2)] = inst_30630);

(statearr_30679_30710[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (10))){
var inst_30604 = (state_30649[(17)]);
var state_30649__$1 = state_30649;
var statearr_30680_30711 = state_30649__$1;
(statearr_30680_30711[(2)] = inst_30604);

(statearr_30680_30711[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (18))){
var inst_30628 = (state_30649[(16)]);
var inst_30634 = (state_30649[(2)]);
var state_30649__$1 = (function (){var statearr_30681 = state_30649;
(statearr_30681[(11)] = inst_30634);

return statearr_30681;
})();
if(cljs.core.truth_(inst_30628)){
var statearr_30682_30712 = state_30649__$1;
(statearr_30682_30712[(1)] = (19));

} else {
var statearr_30683_30713 = state_30649__$1;
(statearr_30683_30713[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30650 === (8))){
var inst_30613 = (state_30649[(7)]);
var state_30649__$1 = state_30649;
var statearr_30684_30714 = state_30649__$1;
(statearr_30684_30714[(2)] = inst_30613);

(statearr_30684_30714[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto____0 = (function (){
var statearr_30685 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30685[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto__);

(statearr_30685[(1)] = (1));

return statearr_30685;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto____1 = (function (state_30649){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_30649);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e30686){var ex__10844__auto__ = e30686;
var statearr_30687_30715 = state_30649;
(statearr_30687_30715[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_30649[(4)]))){
var statearr_30688_30716 = state_30649;
(statearr_30688_30716[(1)] = cljs.core.first((state_30649[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__30717 = state_30649;
state_30649 = G__30717;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto__ = function(state_30649){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto____1.call(this,state_30649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_30689 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_30689[(6)] = c__10878__auto__);

return statearr_30689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_30895){
var state_val_30896 = (state_30895[(1)]);
if((state_val_30896 === (7))){
var state_30895__$1 = state_30895;
var statearr_30897_30983 = state_30895__$1;
(statearr_30897_30983[(2)] = null);

(statearr_30897_30983[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (20))){
var inst_30756 = cljs.core.PersistentHashMap.EMPTY;
var state_30895__$1 = state_30895;
var statearr_30898_30984 = state_30895__$1;
(statearr_30898_30984[(2)] = inst_30756);

(statearr_30898_30984[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (27))){
var inst_30774 = (state_30895[(7)]);
var inst_30758 = (state_30895[(8)]);
var inst_30744 = (state_30895[(9)]);
var inst_30738 = (state_30895[(10)]);
var inst_30874 = (state_30895[(2)]);
var inst_30875 = (function (){var top_level_subject = inst_30738;
var select_spec = inst_30744;
var base_acc = inst_30758;
var acc_PLUS_refs = inst_30774;
var result = inst_30874;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_30876 = cljs.core.PersistentVector.EMPTY;
var inst_30877 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_30744);
var inst_30878 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_30877);
var inst_30879 = cljs.core.vals(inst_30878);
var inst_30880 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_30744);
var inst_30881 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_30880);
var inst_30882 = cljs.core.vals(inst_30881);
var inst_30883 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_30879,inst_30882);
var inst_30884 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_30875,inst_30876,inst_30883);
var inst_30886 = (function (){var top_level_subject = inst_30738;
var select_spec = inst_30744;
var base_acc = inst_30758;
var acc_PLUS_refs = inst_30774;
var result = inst_30874;
var sort_preds = inst_30884;
return (function (acc,p__30885){
var vec__30899 = p__30885;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30899,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30899,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30899,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30899,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_30887 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_30886,inst_30874,inst_30884);
var state_30895__$1 = state_30895;
var statearr_30902_30985 = state_30895__$1;
(statearr_30902_30985[(2)] = inst_30887);

(statearr_30902_30985[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (1))){
var state_30895__$1 = state_30895;
var statearr_30903_30986 = state_30895__$1;
(statearr_30903_30986[(2)] = null);

(statearr_30903_30986[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (24))){
var inst_30774 = (state_30895[(7)]);
var inst_30774__$1 = (state_30895[(2)]);
var inst_30775 = flakes;
var inst_30776 = cljs.core.PersistentHashMap.EMPTY;
var inst_30777 = inst_30775;
var inst_30778 = inst_30774__$1;
var inst_30779 = inst_30776;
var state_30895__$1 = (function (){var statearr_30904 = state_30895;
(statearr_30904[(11)] = inst_30778);

(statearr_30904[(7)] = inst_30774__$1);

(statearr_30904[(12)] = inst_30777);

(statearr_30904[(13)] = inst_30779);

return statearr_30904;
})();
var statearr_30905_30987 = state_30895__$1;
(statearr_30905_30987[(2)] = null);

(statearr_30905_30987[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (39))){
var inst_30787 = (state_30895[(14)]);
var inst_30778 = (state_30895[(11)]);
var inst_30744 = (state_30895[(9)]);
var inst_30793 = (state_30895[(15)]);
var inst_30822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30823 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_30778,inst_30744,inst_30787,inst_30793,false);
var state_30895__$1 = (function (){var statearr_30906 = state_30895;
(statearr_30906[(16)] = inst_30822);

return statearr_30906;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30895__$1,(42),inst_30823);
} else {
if((state_val_30896 === (46))){
var inst_30787 = (state_30895[(14)]);
var inst_30777 = (state_30895[(12)]);
var inst_30779 = (state_30895[(13)]);
var inst_30840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30841 = [cljs.core.cst$kw$_id];
var inst_30842 = inst_30787.s;
var inst_30843 = [inst_30842];
var inst_30844 = cljs.core.PersistentHashMap.fromArrays(inst_30841,inst_30843);
var inst_30845 = cljs.core.rest(inst_30777);
var inst_30846 = [inst_30844,inst_30845,inst_30779];
var inst_30847 = (new cljs.core.PersistentVector(null,3,(5),inst_30840,inst_30846,null));
var state_30895__$1 = state_30895;
var statearr_30907_30988 = state_30895__$1;
(statearr_30907_30988[(2)] = inst_30847);

(statearr_30907_30988[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (4))){
var inst_30718 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
var statearr_30908_30989 = state_30895__$1;
(statearr_30908_30989[(2)] = inst_30718);

(statearr_30908_30989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (15))){
var inst_30745 = (state_30895[(17)]);
var inst_30744 = (state_30895[(9)]);
var inst_30744__$1 = (state_30895[(2)]);
var inst_30745__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30744__$1);
var state_30895__$1 = (function (){var statearr_30909 = state_30895;
(statearr_30909[(17)] = inst_30745__$1);

(statearr_30909[(9)] = inst_30744__$1);

return statearr_30909;
})();
if(cljs.core.truth_(inst_30745__$1)){
var statearr_30910_30990 = state_30895__$1;
(statearr_30910_30990[(1)] = (16));

} else {
var statearr_30911_30991 = state_30895__$1;
(statearr_30911_30991[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (48))){
var inst_30858 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
var statearr_30912_30992 = state_30895__$1;
(statearr_30912_30992[(2)] = inst_30858);

(statearr_30912_30992[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (50))){
var state_30895__$1 = state_30895;
var statearr_30913_30993 = state_30895__$1;
(statearr_30913_30993[(2)] = null);

(statearr_30913_30993[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (21))){
var inst_30744 = (state_30895[(9)]);
var inst_30758 = (state_30895[(2)]);
var inst_30759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30760 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_30761 = (new cljs.core.PersistentVector(null,2,(5),inst_30759,inst_30760,null));
var inst_30762 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_30744,inst_30761);
var state_30895__$1 = (function (){var statearr_30914 = state_30895;
(statearr_30914[(8)] = inst_30758);

return statearr_30914;
})();
if(cljs.core.truth_(inst_30762)){
var statearr_30915_30994 = state_30895__$1;
(statearr_30915_30994[(1)] = (22));

} else {
var statearr_30916_30995 = state_30895__$1;
(statearr_30916_30995[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (31))){
var inst_30787 = (state_30895[(14)]);
var inst_30778 = (state_30895[(11)]);
var inst_30792 = (state_30895[(18)]);
var inst_30796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30797 = fluree.db.query.fql.flake__GT_recur(db,inst_30787,inst_30792,inst_30778,fuel,max_fuel,cache);
var state_30895__$1 = (function (){var statearr_30917 = state_30895;
(statearr_30917[(19)] = inst_30796);

return statearr_30917;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30895__$1,(34),inst_30797);
} else {
if((state_val_30896 === (32))){
var inst_30792 = (state_30895[(18)]);
var state_30895__$1 = state_30895;
if(cljs.core.truth_(inst_30792)){
var statearr_30918_30996 = state_30895__$1;
(statearr_30918_30996[(1)] = (35));

} else {
var statearr_30919_30997 = state_30895__$1;
(statearr_30919_30997[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (40))){
var inst_30833 = (state_30895[(20)]);
var inst_30744 = (state_30895[(9)]);
var inst_30832 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_30744);
var inst_30833__$1 = cljs.core.empty_QMARK_(inst_30832);
var state_30895__$1 = (function (){var statearr_30920 = state_30895;
(statearr_30920[(20)] = inst_30833__$1);

return statearr_30920;
})();
if(inst_30833__$1){
var statearr_30921_30998 = state_30895__$1;
(statearr_30921_30998[(1)] = (43));

} else {
var statearr_30922_30999 = state_30895__$1;
(statearr_30922_30999[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (33))){
var inst_30787 = (state_30895[(14)]);
var inst_30864 = (state_30895[(2)]);
var inst_30865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30864,(0),null);
var inst_30866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30864,(1),null);
var inst_30867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30864,(2),null);
var inst_30868 = inst_30787.s;
var inst_30869 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_30865,cljs.core.cst$kw$_id,inst_30868);
var inst_30777 = inst_30866;
var inst_30778 = inst_30869;
var inst_30779 = inst_30867;
var state_30895__$1 = (function (){var statearr_30923 = state_30895;
(statearr_30923[(11)] = inst_30778);

(statearr_30923[(12)] = inst_30777);

(statearr_30923[(13)] = inst_30779);

return statearr_30923;
})();
var statearr_30924_31000 = state_30895__$1;
(statearr_30924_31000[(2)] = null);

(statearr_30924_31000[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (13))){
var inst_30738 = (state_30895[(10)]);
var inst_30741 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_30738);
var state_30895__$1 = state_30895;
var statearr_30925_31001 = state_30895__$1;
(statearr_30925_31001[(2)] = inst_30741);

(statearr_30925_31001[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (22))){
var inst_30744 = (state_30895[(9)]);
var inst_30764 = cljs.core.first(flakes);
var inst_30765 = fluree.db.query.fql.s(inst_30764);
var inst_30766 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_30744);
var inst_30767 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_30765,inst_30766);
var state_30895__$1 = state_30895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30895__$1,(25),inst_30767);
} else {
if((state_val_30896 === (36))){
var inst_30744 = (state_30895[(9)]);
var inst_30820 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30744);
var state_30895__$1 = state_30895;
if(cljs.core.truth_(inst_30820)){
var statearr_30926_31002 = state_30895__$1;
(statearr_30926_31002[(1)] = (39));

} else {
var statearr_30927_31003 = state_30895__$1;
(statearr_30927_31003[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (41))){
var inst_30860 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
var statearr_30928_31004 = state_30895__$1;
(statearr_30928_31004[(2)] = inst_30860);

(statearr_30928_31004[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (43))){
var inst_30744 = (state_30895[(9)]);
var inst_30835 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30744);
var state_30895__$1 = state_30895;
var statearr_30929_31005 = state_30895__$1;
(statearr_30929_31005[(2)] = inst_30835);

(statearr_30929_31005[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (29))){
var inst_30787 = (state_30895[(14)]);
var inst_30777 = (state_30895[(12)]);
var inst_30744 = (state_30895[(9)]);
var inst_30792 = (state_30895[(18)]);
var inst_30787__$1 = cljs.core.first(inst_30777);
var inst_30788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30789 = inst_30787__$1.p;
var inst_30790 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_30789];
var inst_30791 = (new cljs.core.PersistentVector(null,3,(5),inst_30788,inst_30790,null));
var inst_30792__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_30744,inst_30791);
var inst_30793 = fluree.db.query.fql.component_follow_QMARK_(inst_30792__$1,inst_30744);
var inst_30794 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_30792__$1);
var state_30895__$1 = (function (){var statearr_30930 = state_30895;
(statearr_30930[(14)] = inst_30787__$1);

(statearr_30930[(18)] = inst_30792__$1);

(statearr_30930[(15)] = inst_30793);

return statearr_30930;
})();
if(cljs.core.truth_(inst_30794)){
var statearr_30931_31006 = state_30895__$1;
(statearr_30931_31006[(1)] = (31));

} else {
var statearr_30932_31007 = state_30895__$1;
(statearr_30932_31007[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (44))){
var inst_30833 = (state_30895[(20)]);
var state_30895__$1 = state_30895;
var statearr_30933_31008 = state_30895__$1;
(statearr_30933_31008[(2)] = inst_30833);

(statearr_30933_31008[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (6))){
var state_30895__$1 = state_30895;
var statearr_30934_31009 = state_30895__$1;
(statearr_30934_31009[(2)] = null);

(statearr_30934_31009[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (28))){
var inst_30778 = (state_30895[(11)]);
var state_30895__$1 = state_30895;
var statearr_30935_31010 = state_30895__$1;
(statearr_30935_31010[(2)] = inst_30778);

(statearr_30935_31010[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (51))){
var inst_30856 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
var statearr_30936_31011 = state_30895__$1;
(statearr_30936_31011[(2)] = inst_30856);

(statearr_30936_31011[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (25))){
var inst_30758 = (state_30895[(8)]);
var inst_30769 = (state_30895[(2)]);
var inst_30770 = fluree.db.util.async.throw_err(inst_30769);
var inst_30771 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_30758,inst_30770], 0));
var state_30895__$1 = state_30895;
var statearr_30937_31012 = state_30895__$1;
(statearr_30937_31012[(2)] = inst_30771);

(statearr_30937_31012[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (34))){
var inst_30777 = (state_30895[(12)]);
var inst_30779 = (state_30895[(13)]);
var inst_30796 = (state_30895[(19)]);
var inst_30799 = (state_30895[(2)]);
var inst_30800 = fluree.db.util.async.throw_err(inst_30799);
var inst_30801 = cljs.core.rest(inst_30777);
var inst_30802 = [inst_30800,inst_30801,inst_30779];
var inst_30803 = (new cljs.core.PersistentVector(null,3,(5),inst_30796,inst_30802,null));
var state_30895__$1 = state_30895;
var statearr_30938_31013 = state_30895__$1;
(statearr_30938_31013[(2)] = inst_30803);

(statearr_30938_31013[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (17))){
var inst_30744 = (state_30895[(9)]);
var inst_30748 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_30744);
var state_30895__$1 = state_30895;
var statearr_30940_31014 = state_30895__$1;
(statearr_30940_31014[(2)] = inst_30748);

(statearr_30940_31014[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (3))){
var inst_30893 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30895__$1,inst_30893);
} else {
if((state_val_30896 === (12))){
var _ = (function (){var statearr_30941 = state_30895;
(statearr_30941[(4)] = cljs.core.rest((state_30895[(4)])));

return statearr_30941;
})();
var state_30895__$1 = state_30895;
var ex30939 = (state_30895__$1[(2)]);
var statearr_30942_31015 = state_30895__$1;
(statearr_30942_31015[(5)] = ex30939);


var statearr_30943_31016 = state_30895__$1;
(statearr_30943_31016[(1)] = (11));

(statearr_30943_31016[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (2))){
var _ = (function (){var statearr_30944 = state_30895;
(statearr_30944[(4)] = cljs.core.cons((5),(state_30895[(4)])));

return statearr_30944;
})();
var inst_30724 = cljs.core.not_empty(flakes);
var state_30895__$1 = state_30895;
if(cljs.core.truth_(inst_30724)){
var statearr_30945_31017 = state_30895__$1;
(statearr_30945_31017[(1)] = (6));

} else {
var statearr_30946_31018 = state_30895__$1;
(statearr_30946_31018[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (23))){
var inst_30758 = (state_30895[(8)]);
var state_30895__$1 = state_30895;
var statearr_30947_31019 = state_30895__$1;
(statearr_30947_31019[(2)] = inst_30758);

(statearr_30947_31019[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (47))){
var state_30895__$1 = state_30895;
var statearr_30948_31020 = state_30895__$1;
(statearr_30948_31020[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (35))){
var inst_30787 = (state_30895[(14)]);
var inst_30778 = (state_30895[(11)]);
var inst_30779 = (state_30895[(13)]);
var inst_30792 = (state_30895[(18)]);
var inst_30793 = (state_30895[(15)]);
var inst_30809 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_30778,inst_30792,inst_30787,inst_30793,false,inst_30779);
var state_30895__$1 = state_30895;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30895__$1,(38),inst_30809);
} else {
if((state_val_30896 === (19))){
var inst_30738 = (state_30895[(10)]);
var inst_30752 = [cljs.core.cst$kw$_id];
var inst_30753 = [inst_30738];
var inst_30754 = cljs.core.PersistentHashMap.fromArrays(inst_30752,inst_30753);
var state_30895__$1 = state_30895;
var statearr_30950_31021 = state_30895__$1;
(statearr_30950_31021[(2)] = inst_30754);

(statearr_30950_31021[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (11))){
var inst_30726 = (state_30895[(2)]);
var inst_30727 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_30726], 0));
var inst_30728 = (function(){throw inst_30726})();
var state_30895__$1 = (function (){var statearr_30952 = state_30895;
(statearr_30952[(21)] = inst_30727);

return statearr_30952;
})();
var statearr_30953_31022 = state_30895__$1;
(statearr_30953_31022[(2)] = inst_30728);

(statearr_30953_31022[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (9))){
var _ = (function (){var statearr_30954 = state_30895;
(statearr_30954[(4)] = cljs.core.cons((12),(state_30895[(4)])));

return statearr_30954;
})();
var inst_30734 = cljs.core.first(flakes);
var inst_30735 = fluree.db.query.fql.s(inst_30734);
var ___$1 = (function (){var statearr_30955 = state_30895;
(statearr_30955[(4)] = cljs.core.rest((state_30895[(4)])));

return statearr_30955;
})();
var state_30895__$1 = state_30895;
var statearr_30956_31023 = state_30895__$1;
(statearr_30956_31023[(2)] = inst_30735);

(statearr_30956_31023[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (5))){
var _ = (function (){var statearr_30957 = state_30895;
(statearr_30957[(4)] = cljs.core.rest((state_30895[(4)])));

return statearr_30957;
})();
var state_30895__$1 = state_30895;
var ex30951 = (state_30895__$1[(2)]);
var statearr_30958_31024 = state_30895__$1;
(statearr_30958_31024[(5)] = ex30951);


if((ex30951 instanceof Error)){
var statearr_30959_31025 = state_30895__$1;
(statearr_30959_31025[(1)] = (4));

(statearr_30959_31025[(5)] = null);

} else {
throw ex30951;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (14))){
var state_30895__$1 = state_30895;
var statearr_30960_31026 = state_30895__$1;
(statearr_30960_31026[(2)] = base_select_spec);

(statearr_30960_31026[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (45))){
var inst_30838 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
if(cljs.core.truth_(inst_30838)){
var statearr_30961_31027 = state_30895__$1;
(statearr_30961_31027[(1)] = (46));

} else {
var statearr_30962_31028 = state_30895__$1;
(statearr_30962_31028[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (26))){
var inst_30777 = (state_30895[(12)]);
var inst_30781 = cljs.core.empty_QMARK_(inst_30777);
var state_30895__$1 = state_30895;
if(inst_30781){
var statearr_30963_31029 = state_30895__$1;
(statearr_30963_31029[(1)] = (28));

} else {
var statearr_30964_31030 = state_30895__$1;
(statearr_30964_31030[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (16))){
var inst_30745 = (state_30895[(17)]);
var state_30895__$1 = state_30895;
var statearr_30965_31031 = state_30895__$1;
(statearr_30965_31031[(2)] = inst_30745);

(statearr_30965_31031[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (38))){
var inst_30777 = (state_30895[(12)]);
var inst_30811 = (state_30895[(2)]);
var inst_30812 = fluree.db.util.async.throw_err(inst_30811);
var inst_30813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30812,(0),null);
var inst_30814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30812,(1),null);
var inst_30815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30816 = cljs.core.rest(inst_30777);
var inst_30817 = [inst_30813,inst_30816,inst_30814];
var inst_30818 = (new cljs.core.PersistentVector(null,3,(5),inst_30815,inst_30817,null));
var state_30895__$1 = state_30895;
var statearr_30966_31032 = state_30895__$1;
(statearr_30966_31032[(2)] = inst_30818);

(statearr_30966_31032[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (30))){
var inst_30872 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
var statearr_30967_31033 = state_30895__$1;
(statearr_30967_31033[(2)] = inst_30872);

(statearr_30967_31033[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (10))){
var inst_30738 = (state_30895[(2)]);
var inst_30739 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_30895__$1 = (function (){var statearr_30968 = state_30895;
(statearr_30968[(10)] = inst_30738);

return statearr_30968;
})();
if(cljs.core.truth_(inst_30739)){
var statearr_30969_31034 = state_30895__$1;
(statearr_30969_31034[(1)] = (13));

} else {
var statearr_30970_31035 = state_30895__$1;
(statearr_30970_31035[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (18))){
var inst_30750 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
if(cljs.core.truth_(inst_30750)){
var statearr_30971_31036 = state_30895__$1;
(statearr_30971_31036[(1)] = (19));

} else {
var statearr_30972_31037 = state_30895__$1;
(statearr_30972_31037[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (42))){
var inst_30777 = (state_30895[(12)]);
var inst_30779 = (state_30895[(13)]);
var inst_30822 = (state_30895[(16)]);
var inst_30825 = (state_30895[(2)]);
var inst_30826 = fluree.db.util.async.throw_err(inst_30825);
var inst_30827 = cljs.core.first(inst_30826);
var inst_30828 = cljs.core.rest(inst_30777);
var inst_30829 = [inst_30827,inst_30828,inst_30779];
var inst_30830 = (new cljs.core.PersistentVector(null,3,(5),inst_30822,inst_30829,null));
var state_30895__$1 = state_30895;
var statearr_30973_31038 = state_30895__$1;
(statearr_30973_31038[(2)] = inst_30830);

(statearr_30973_31038[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (37))){
var inst_30862 = (state_30895[(2)]);
var state_30895__$1 = state_30895;
var statearr_30974_31039 = state_30895__$1;
(statearr_30974_31039[(2)] = inst_30862);

(statearr_30974_31039[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (8))){
var inst_30890 = (state_30895[(2)]);
var _ = (function (){var statearr_30975 = state_30895;
(statearr_30975[(4)] = cljs.core.rest((state_30895[(4)])));

return statearr_30975;
})();
var state_30895__$1 = state_30895;
var statearr_30976_31040 = state_30895__$1;
(statearr_30976_31040[(2)] = inst_30890);

(statearr_30976_31040[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30896 === (49))){
var inst_30778 = (state_30895[(11)]);
var inst_30777 = (state_30895[(12)]);
var inst_30779 = (state_30895[(13)]);
var inst_30850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30851 = cljs.core.rest(inst_30777);
var inst_30852 = [inst_30778,inst_30851,inst_30779];
var inst_30853 = (new cljs.core.PersistentVector(null,3,(5),inst_30850,inst_30852,null));
var state_30895__$1 = state_30895;
var statearr_30977_31041 = state_30895__$1;
(statearr_30977_31041[(2)] = inst_30853);

(statearr_30977_31041[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto____0 = (function (){
var statearr_30978 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30978[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto__);

(statearr_30978[(1)] = (1));

return statearr_30978;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto____1 = (function (state_30895){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_30895);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e30979){var ex__10844__auto__ = e30979;
var statearr_30980_31042 = state_30895;
(statearr_30980_31042[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_30895[(4)]))){
var statearr_30981_31043 = state_30895;
(statearr_30981_31043[(1)] = cljs.core.first((state_30895[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31044 = state_30895;
state_30895 = G__31044;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto__ = function(state_30895){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto____1.call(this,state_30895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_30982 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_30982[(6)] = c__10878__auto__);

return statearr_30982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__31047 = arguments.length;
switch (G__31047) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_31089){
var state_val_31090 = (state_31089[(1)]);
if((state_val_31090 === (7))){
var inst_31055 = (state_31089[(7)]);
var state_31089__$1 = state_31089;
var statearr_31091_31121 = state_31089__$1;
(statearr_31091_31121[(2)] = inst_31055);

(statearr_31091_31121[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (1))){
var state_31089__$1 = state_31089;
var statearr_31092_31122 = state_31089__$1;
(statearr_31092_31122[(2)] = null);

(statearr_31092_31122[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (4))){
var inst_31048 = (state_31089[(2)]);
var state_31089__$1 = state_31089;
var statearr_31093_31123 = state_31089__$1;
(statearr_31093_31123[(2)] = inst_31048);

(statearr_31093_31123[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (15))){
var inst_31083 = (state_31089[(2)]);
var inst_31084 = fluree.db.util.async.throw_err(inst_31083);
var _ = (function (){var statearr_31094 = state_31089;
(statearr_31094[(4)] = cljs.core.rest((state_31089[(4)])));

return statearr_31094;
})();
var state_31089__$1 = state_31089;
var statearr_31095_31124 = state_31089__$1;
(statearr_31095_31124[(2)] = inst_31084);

(statearr_31095_31124[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (13))){
var inst_31067 = (state_31089[(8)]);
var state_31089__$1 = state_31089;
var statearr_31096_31125 = state_31089__$1;
(statearr_31096_31125[(2)] = inst_31067);

(statearr_31096_31125[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (6))){
var inst_31055 = (state_31089[(7)]);
var inst_31057 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_31058 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_31055,inst_31057);
var state_31089__$1 = state_31089;
var statearr_31097_31126 = state_31089__$1;
(statearr_31097_31126[(2)] = inst_31058);

(statearr_31097_31126[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (3))){
var inst_31087 = (state_31089[(2)]);
var state_31089__$1 = state_31089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31089__$1,inst_31087);
} else {
if((state_val_31090 === (12))){
var inst_31067 = (state_31089[(8)]);
var inst_31069 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_31070 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_31067,inst_31069);
var state_31089__$1 = state_31089;
var statearr_31098_31127 = state_31089__$1;
(statearr_31098_31127[(2)] = inst_31070);

(statearr_31098_31127[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (2))){
var _ = (function (){var statearr_31099 = state_31089;
(statearr_31099[(4)] = cljs.core.cons((5),(state_31089[(4)])));

return statearr_31099;
})();
var inst_31055 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_31089__$1 = (function (){var statearr_31100 = state_31089;
(statearr_31100[(7)] = inst_31055);

return statearr_31100;
})();
if(cljs.core.truth_(fuel)){
var statearr_31101_31128 = state_31089__$1;
(statearr_31101_31128[(1)] = (6));

} else {
var statearr_31102_31129 = state_31089__$1;
(statearr_31102_31129[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (11))){
var inst_31067 = (state_31089[(2)]);
var state_31089__$1 = (function (){var statearr_31104 = state_31089;
(statearr_31104[(8)] = inst_31067);

return statearr_31104;
})();
if(cljs.core.truth_(limit)){
var statearr_31105_31130 = state_31089__$1;
(statearr_31105_31130[(1)] = (12));

} else {
var statearr_31106_31131 = state_31089__$1;
(statearr_31106_31131[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (9))){
var inst_31061 = (state_31089[(9)]);
var inst_31063 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_31064 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_31061,inst_31063);
var state_31089__$1 = state_31089;
var statearr_31107_31132 = state_31089__$1;
(statearr_31107_31132[(2)] = inst_31064);

(statearr_31107_31132[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (5))){
var _ = (function (){var statearr_31108 = state_31089;
(statearr_31108[(4)] = cljs.core.rest((state_31089[(4)])));

return statearr_31108;
})();
var state_31089__$1 = state_31089;
var ex31103 = (state_31089__$1[(2)]);
var statearr_31109_31133 = state_31089__$1;
(statearr_31109_31133[(5)] = ex31103);


if((ex31103 instanceof Error)){
var statearr_31110_31134 = state_31089__$1;
(statearr_31110_31134[(1)] = (4));

(statearr_31110_31134[(5)] = null);

} else {
throw ex31103;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (14))){
var inst_31073 = (state_31089[(2)]);
var inst_31074 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_31075 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_31074);
var inst_31076 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_31073,inst_31075);
var inst_31077 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_31076,flakes);
var inst_31078 = cljs.core.PersistentVector.EMPTY;
var inst_31079 = (function (){var xf = inst_31076;
var flakes_by_sub = inst_31077;
return (function (p1__31045_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__31045_SHARP_);
});
})();
var inst_31080 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31079,inst_31077);
var inst_31081 = fluree.db.util.async.merge_into_QMARK_(inst_31078,inst_31080);
var state_31089__$1 = state_31089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31089__$1,(15),inst_31081);
} else {
if((state_val_31090 === (10))){
var inst_31061 = (state_31089[(9)]);
var state_31089__$1 = state_31089;
var statearr_31111_31135 = state_31089__$1;
(statearr_31111_31135[(2)] = inst_31061);

(statearr_31111_31135[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31090 === (8))){
var inst_31061 = (state_31089[(2)]);
var state_31089__$1 = (function (){var statearr_31112 = state_31089;
(statearr_31112[(9)] = inst_31061);

return statearr_31112;
})();
if(cljs.core.truth_(offset)){
var statearr_31113_31136 = state_31089__$1;
(statearr_31113_31136[(1)] = (9));

} else {
var statearr_31114_31137 = state_31089__$1;
(statearr_31114_31137[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10841__auto__ = null;
var fluree$db$query$fql$state_machine__10841__auto____0 = (function (){
var statearr_31115 = [null,null,null,null,null,null,null,null,null,null];
(statearr_31115[(0)] = fluree$db$query$fql$state_machine__10841__auto__);

(statearr_31115[(1)] = (1));

return statearr_31115;
});
var fluree$db$query$fql$state_machine__10841__auto____1 = (function (state_31089){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_31089);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e31116){var ex__10844__auto__ = e31116;
var statearr_31117_31138 = state_31089;
(statearr_31117_31138[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_31089[(4)]))){
var statearr_31118_31139 = state_31089;
(statearr_31118_31139[(1)] = cljs.core.first((state_31089[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31140 = state_31089;
state_31089 = G__31140;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10841__auto__ = function(state_31089){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10841__auto____1.call(this,state_31089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10841__auto____0;
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10841__auto____1;
return fluree$db$query$fql$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_31119 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_31119[(6)] = c__10878__auto__);

return statearr_31119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__31142 = arguments.length;
switch (G__31142) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_31223){
var state_val_31224 = (state_31223[(1)]);
if((state_val_31224 === (7))){
var inst_31218 = (state_31223[(2)]);
var _ = (function (){var statearr_31226 = state_31223;
(statearr_31226[(4)] = cljs.core.rest((state_31223[(4)])));

return statearr_31226;
})();
var state_31223__$1 = state_31223;
var statearr_31227_31274 = state_31223__$1;
(statearr_31227_31274[(2)] = inst_31218);

(statearr_31227_31274[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (20))){
var inst_31162 = (state_31223[(7)]);
var inst_31163 = (state_31223[(8)]);
var inst_31170 = (state_31223[(9)]);
var inst_31191 = (inst_31162 + (1));
var tmp31225 = inst_31163;
var inst_31161 = inst_31170;
var inst_31162__$1 = inst_31191;
var inst_31163__$1 = tmp31225;
var state_31223__$1 = (function (){var statearr_31228 = state_31223;
(statearr_31228[(7)] = inst_31162__$1);

(statearr_31228[(8)] = inst_31163__$1);

(statearr_31228[(10)] = inst_31161);

return statearr_31228;
})();
var statearr_31229_31275 = state_31223__$1;
(statearr_31229_31275[(2)] = null);

(statearr_31229_31275[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (27))){
var inst_31196 = (state_31223[(11)]);
var inst_31202 = (state_31223[(2)]);
var inst_31203 = fluree.db.util.async.throw_err(inst_31202);
var inst_31204 = (inst_31196.cljs$core$IFn$_invoke$arity$1 ? inst_31196.cljs$core$IFn$_invoke$arity$1(inst_31203) : inst_31196.call(null,inst_31203));
var state_31223__$1 = state_31223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31223__$1,(26),inst_31204);
} else {
if((state_val_31224 === (1))){
var state_31223__$1 = state_31223;
var statearr_31230_31276 = state_31223__$1;
(statearr_31230_31276[(2)] = null);

(statearr_31230_31276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (24))){
var state_31223__$1 = state_31223;
var statearr_31231_31277 = state_31223__$1;
(statearr_31231_31277[(2)] = null);

(statearr_31231_31277[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (4))){
var inst_31143 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
var statearr_31232_31278 = state_31223__$1;
(statearr_31232_31278[(2)] = inst_31143);

(statearr_31232_31278[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (15))){
var inst_31184 = (state_31223[(12)]);
var inst_31184__$1 = offset;
var state_31223__$1 = (function (){var statearr_31233 = state_31223;
(statearr_31233[(12)] = inst_31184__$1);

return statearr_31233;
})();
if(cljs.core.truth_(inst_31184__$1)){
var statearr_31234_31279 = state_31223__$1;
(statearr_31234_31279[(1)] = (17));

} else {
var statearr_31235_31280 = state_31223__$1;
(statearr_31235_31280[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (21))){
var state_31223__$1 = state_31223;
var statearr_31236_31281 = state_31223__$1;
(statearr_31236_31281[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (13))){
var inst_31179 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
var statearr_31238_31282 = state_31223__$1;
(statearr_31238_31282[(2)] = inst_31179);

(statearr_31238_31282[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (22))){
var inst_31214 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
var statearr_31239_31283 = state_31223__$1;
(statearr_31239_31283[(2)] = inst_31214);

(statearr_31239_31283[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (6))){
var inst_31169 = (state_31223[(13)]);
var inst_31171 = (state_31223[(14)]);
var inst_31161 = (state_31223[(10)]);
var inst_31168 = cljs.core.seq(inst_31161);
var inst_31169__$1 = cljs.core.first(inst_31168);
var inst_31170 = cljs.core.next(inst_31168);
var inst_31171__$1 = (inst_31169__$1 == null);
var state_31223__$1 = (function (){var statearr_31240 = state_31223;
(statearr_31240[(13)] = inst_31169__$1);

(statearr_31240[(14)] = inst_31171__$1);

(statearr_31240[(9)] = inst_31170);

return statearr_31240;
})();
if(cljs.core.truth_(inst_31171__$1)){
var statearr_31241_31284 = state_31223__$1;
(statearr_31241_31284[(1)] = (8));

} else {
var statearr_31242_31285 = state_31223__$1;
(statearr_31242_31285[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (25))){
var inst_31212 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
var statearr_31243_31286 = state_31223__$1;
(statearr_31243_31286[(2)] = inst_31212);

(statearr_31243_31286[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (17))){
var inst_31162 = (state_31223[(7)]);
var inst_31186 = (inst_31162 < offset);
var state_31223__$1 = state_31223;
var statearr_31244_31287 = state_31223__$1;
(statearr_31244_31287[(2)] = inst_31186);

(statearr_31244_31287[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (3))){
var inst_31221 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31223__$1,inst_31221);
} else {
if((state_val_31224 === (12))){
var inst_31174 = (state_31223[(15)]);
var state_31223__$1 = state_31223;
var statearr_31245_31288 = state_31223__$1;
(statearr_31245_31288[(2)] = inst_31174);

(statearr_31245_31288[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (2))){
var inst_31156 = (state_31223[(16)]);
var _ = (function (){var statearr_31246 = state_31223;
(statearr_31246[(4)] = cljs.core.cons((5),(state_31223[(4)])));

return statearr_31246;
})();
var inst_31156__$1 = subjects;
var inst_31157 = cljs.core.seq(inst_31156__$1);
var inst_31158 = cljs.core.first(inst_31157);
var inst_31159 = cljs.core.next(inst_31157);
var inst_31160 = cljs.core.PersistentVector.EMPTY;
var inst_31161 = inst_31156__$1;
var inst_31162 = (0);
var inst_31163 = inst_31160;
var state_31223__$1 = (function (){var statearr_31247 = state_31223;
(statearr_31247[(7)] = inst_31162);

(statearr_31247[(17)] = inst_31159);

(statearr_31247[(8)] = inst_31163);

(statearr_31247[(18)] = inst_31158);

(statearr_31247[(16)] = inst_31156__$1);

(statearr_31247[(10)] = inst_31161);

return statearr_31247;
})();
var statearr_31248_31289 = state_31223__$1;
(statearr_31248_31289[(2)] = null);

(statearr_31248_31289[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (23))){
var inst_31162 = (state_31223[(7)]);
var inst_31169 = (state_31223[(13)]);
var inst_31159 = (state_31223[(17)]);
var inst_31163 = (state_31223[(8)]);
var inst_31158 = (state_31223[(18)]);
var inst_31156 = (state_31223[(16)]);
var inst_31170 = (state_31223[(9)]);
var inst_31161 = (state_31223[(10)]);
var inst_31195 = (inst_31162 + (1));
var inst_31196 = (function (){var vec__31165 = inst_31161;
var seq__31166 = inst_31170;
var r = inst_31170;
var first__31155 = inst_31158;
var acc = inst_31163;
var n = inst_31162;
var first__31167 = inst_31169;
var s = inst_31169;
var G__31152 = inst_31161;
var vec__31153 = inst_31156;
var seq__31154 = inst_31159;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_31197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31198 = [inst_31169];
var inst_31199 = (new cljs.core.PersistentVector(null,1,(5),inst_31197,inst_31198,null));
var inst_31200 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31199);
var state_31223__$1 = (function (){var statearr_31249 = state_31223;
(statearr_31249[(19)] = inst_31195);

(statearr_31249[(11)] = inst_31196);

return statearr_31249;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31223__$1,(27),inst_31200);
} else {
if((state_val_31224 === (19))){
var inst_31189 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
if(cljs.core.truth_(inst_31189)){
var statearr_31250_31290 = state_31223__$1;
(statearr_31250_31290[(1)] = (20));

} else {
var statearr_31251_31291 = state_31223__$1;
(statearr_31251_31291[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (11))){
var inst_31162 = (state_31223[(7)]);
var inst_31176 = (inst_31162 > limit);
var state_31223__$1 = state_31223;
var statearr_31253_31292 = state_31223__$1;
(statearr_31253_31292[(2)] = inst_31176);

(statearr_31253_31292[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (9))){
var inst_31174 = (state_31223[(15)]);
var inst_31174__$1 = limit;
var state_31223__$1 = (function (){var statearr_31254 = state_31223;
(statearr_31254[(15)] = inst_31174__$1);

return statearr_31254;
})();
if(cljs.core.truth_(inst_31174__$1)){
var statearr_31255_31293 = state_31223__$1;
(statearr_31255_31293[(1)] = (11));

} else {
var statearr_31256_31294 = state_31223__$1;
(statearr_31256_31294[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (5))){
var _ = (function (){var statearr_31257 = state_31223;
(statearr_31257[(4)] = cljs.core.rest((state_31223[(4)])));

return statearr_31257;
})();
var state_31223__$1 = state_31223;
var ex31252 = (state_31223__$1[(2)]);
var statearr_31258_31295 = state_31223__$1;
(statearr_31258_31295[(5)] = ex31252);


if((ex31252 instanceof Error)){
var statearr_31259_31296 = state_31223__$1;
(statearr_31259_31296[(1)] = (4));

(statearr_31259_31296[(5)] = null);

} else {
throw ex31252;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (14))){
var inst_31163 = (state_31223[(8)]);
var state_31223__$1 = state_31223;
var statearr_31260_31297 = state_31223__$1;
(statearr_31260_31297[(2)] = inst_31163);

(statearr_31260_31297[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (26))){
var inst_31195 = (state_31223[(19)]);
var inst_31163 = (state_31223[(8)]);
var inst_31170 = (state_31223[(9)]);
var inst_31206 = (state_31223[(2)]);
var inst_31207 = fluree.db.util.async.throw_err(inst_31206);
var inst_31208 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31163,inst_31207);
var inst_31161 = inst_31170;
var inst_31162 = inst_31195;
var inst_31163__$1 = inst_31208;
var state_31223__$1 = (function (){var statearr_31261 = state_31223;
(statearr_31261[(7)] = inst_31162);

(statearr_31261[(8)] = inst_31163__$1);

(statearr_31261[(10)] = inst_31161);

return statearr_31261;
})();
var statearr_31262_31298 = state_31223__$1;
(statearr_31262_31298[(2)] = null);

(statearr_31262_31298[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (16))){
var inst_31216 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
var statearr_31263_31299 = state_31223__$1;
(statearr_31263_31299[(2)] = inst_31216);

(statearr_31263_31299[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (10))){
var inst_31181 = (state_31223[(2)]);
var state_31223__$1 = state_31223;
if(cljs.core.truth_(inst_31181)){
var statearr_31264_31300 = state_31223__$1;
(statearr_31264_31300[(1)] = (14));

} else {
var statearr_31265_31301 = state_31223__$1;
(statearr_31265_31301[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (18))){
var inst_31184 = (state_31223[(12)]);
var state_31223__$1 = state_31223;
var statearr_31266_31302 = state_31223__$1;
(statearr_31266_31302[(2)] = inst_31184);

(statearr_31266_31302[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31224 === (8))){
var inst_31171 = (state_31223[(14)]);
var state_31223__$1 = state_31223;
var statearr_31267_31303 = state_31223__$1;
(statearr_31267_31303[(2)] = inst_31171);

(statearr_31267_31303[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10841__auto__ = null;
var fluree$db$query$fql$state_machine__10841__auto____0 = (function (){
var statearr_31268 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31268[(0)] = fluree$db$query$fql$state_machine__10841__auto__);

(statearr_31268[(1)] = (1));

return statearr_31268;
});
var fluree$db$query$fql$state_machine__10841__auto____1 = (function (state_31223){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_31223);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e31269){var ex__10844__auto__ = e31269;
var statearr_31270_31304 = state_31223;
(statearr_31270_31304[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_31223[(4)]))){
var statearr_31271_31305 = state_31223;
(statearr_31271_31305[(1)] = cljs.core.first((state_31223[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31306 = state_31223;
state_31223 = G__31306;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10841__auto__ = function(state_31223){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10841__auto____1.call(this,state_31223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10841__auto____0;
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10841__auto____1;
return fluree$db$query$fql$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_31272 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_31272[(6)] = c__10878__auto__);

return statearr_31272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__31308 = arguments.length;
switch (G__31308) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_31499){
var state_val_31500 = (state_31499[(1)]);
if((state_val_31500 === (7))){
var state_31499__$1 = state_31499;
var statearr_31501_31576 = state_31499__$1;
(statearr_31501_31576[(2)] = null);

(statearr_31501_31576[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (20))){
var inst_31349 = (state_31499[(7)]);
var inst_31351 = (state_31499[(8)]);
var inst_31379 = (state_31499[(2)]);
var inst_31380 = fluree.db.util.async.throw_err(inst_31379);
var inst_31381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31382 = [inst_31349];
var inst_31383 = (new cljs.core.PersistentVector(null,1,(5),inst_31381,inst_31382,null));
var inst_31384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31385 = [inst_31349,inst_31351];
var inst_31386 = (new cljs.core.PersistentVector(null,2,(5),inst_31384,inst_31385,null));
var inst_31387 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_31383,cljs.core._LT_,inst_31386);
var state_31499__$1 = (function (){var statearr_31502 = state_31499;
(statearr_31502[(9)] = inst_31380);

return statearr_31502;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31499__$1,(21),inst_31387);
} else {
if((state_val_31500 === (27))){
var inst_31350 = (state_31499[(10)]);
var inst_31368 = (state_31499[(11)]);
var inst_31416 = (inst_31368.cljs$core$IFn$_invoke$arity$2 ? inst_31368.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_31350) : inst_31368.call(null,cljs.core._GT__EQ_,inst_31350));
var state_31499__$1 = state_31499;
if(cljs.core.truth_(inst_31416)){
var statearr_31503_31577 = state_31499__$1;
(statearr_31503_31577[(1)] = (30));

} else {
var statearr_31504_31578 = state_31499__$1;
(statearr_31504_31578[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (1))){
var state_31499__$1 = state_31499;
var statearr_31505_31579 = state_31499__$1;
(statearr_31505_31579[(2)] = null);

(statearr_31505_31579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (24))){
var inst_31465 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31506_31580 = state_31499__$1;
(statearr_31506_31580[(2)] = inst_31465);

(statearr_31506_31580[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (39))){
var inst_31455 = null;
var state_31499__$1 = state_31499;
var statearr_31507_31581 = state_31499__$1;
(statearr_31507_31581[(2)] = inst_31455);

(statearr_31507_31581[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (46))){
var inst_31477 = (state_31499[(12)]);
var state_31499__$1 = state_31499;
var statearr_31508_31582 = state_31499__$1;
(statearr_31508_31582[(2)] = inst_31477);

(statearr_31508_31582[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (4))){
var inst_31309 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31509_31583 = state_31499__$1;
(statearr_31509_31583[(2)] = inst_31309);

(statearr_31509_31583[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (15))){
var state_31499__$1 = state_31499;
var statearr_31510_31584 = state_31499__$1;
(statearr_31510_31584[(2)] = null);

(statearr_31510_31584[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (48))){
var inst_31476 = (state_31499[(13)]);
var state_31499__$1 = state_31499;
var statearr_31511_31585 = state_31499__$1;
(statearr_31511_31585[(2)] = inst_31476);

(statearr_31511_31585[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (50))){
var inst_31487 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31512_31586 = state_31499__$1;
(statearr_31512_31586[(2)] = inst_31487);

(statearr_31512_31586[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (21))){
var inst_31380 = (state_31499[(9)]);
var inst_31389 = (state_31499[(2)]);
var inst_31390 = fluree.db.util.async.throw_err(inst_31389);
var inst_31391 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_31380,inst_31390);
var state_31499__$1 = state_31499;
var statearr_31513_31587 = state_31499__$1;
(statearr_31513_31587[(2)] = inst_31391);

(statearr_31513_31587[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (31))){
var inst_31350 = (state_31499[(10)]);
var inst_31368 = (state_31499[(11)]);
var inst_31429 = (inst_31368.cljs$core$IFn$_invoke$arity$2 ? inst_31368.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_31350) : inst_31368.call(null,cljs.core._LT_,inst_31350));
var state_31499__$1 = state_31499;
if(cljs.core.truth_(inst_31429)){
var statearr_31514_31588 = state_31499__$1;
(statearr_31514_31588[(1)] = (34));

} else {
var statearr_31515_31589 = state_31499__$1;
(statearr_31515_31589[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (32))){
var inst_31461 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31516_31590 = state_31499__$1;
(statearr_31516_31590[(2)] = inst_31461);

(statearr_31516_31590[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (40))){
var inst_31457 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31517_31591 = state_31499__$1;
(statearr_31517_31591[(2)] = inst_31457);

(statearr_31517_31591[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (33))){
var inst_31426 = (state_31499[(2)]);
var inst_31427 = fluree.db.util.async.throw_err(inst_31426);
var state_31499__$1 = state_31499;
var statearr_31518_31592 = state_31499__$1;
(statearr_31518_31592[(2)] = inst_31427);

(statearr_31518_31592[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (13))){
var inst_31489 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31519_31593 = state_31499__$1;
(statearr_31519_31593[(2)] = inst_31489);

(statearr_31519_31593[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (22))){
var inst_31349 = (state_31499[(7)]);
var inst_31351 = (state_31499[(8)]);
var inst_31395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31396 = [inst_31349,inst_31351];
var inst_31397 = (new cljs.core.PersistentVector(null,2,(5),inst_31395,inst_31396,null));
var inst_31398 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_31397);
var state_31499__$1 = state_31499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31499__$1,(25),inst_31398);
} else {
if((state_val_31500 === (36))){
var inst_31459 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31520_31594 = state_31499__$1;
(statearr_31520_31594[(2)] = inst_31459);

(statearr_31520_31594[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (41))){
var inst_31452 = (state_31499[(2)]);
var inst_31453 = fluree.db.util.async.throw_err(inst_31452);
var state_31499__$1 = state_31499;
var statearr_31521_31595 = state_31499__$1;
(statearr_31521_31595[(2)] = inst_31453);

(statearr_31521_31595[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (43))){
var inst_31468 = (state_31499[(14)]);
var inst_31335 = (state_31499[(15)]);
var inst_31469 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31335,inst_31468);
var state_31499__$1 = state_31499;
var statearr_31522_31596 = state_31499__$1;
(statearr_31522_31596[(2)] = inst_31469);

(statearr_31522_31596[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (29))){
var inst_31413 = (state_31499[(2)]);
var inst_31414 = fluree.db.util.async.throw_err(inst_31413);
var state_31499__$1 = state_31499;
var statearr_31523_31597 = state_31499__$1;
(statearr_31523_31597[(2)] = inst_31414);

(statearr_31523_31597[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (44))){
var inst_31468 = (state_31499[(14)]);
var inst_31335 = (state_31499[(15)]);
var inst_31471 = cljs.core.PersistentHashSet.EMPTY;
var inst_31472 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31471,inst_31468);
var inst_31473 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_31335,inst_31472);
var state_31499__$1 = state_31499;
var statearr_31524_31598 = state_31499__$1;
(statearr_31524_31598[(2)] = inst_31473);

(statearr_31524_31598[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (6))){
var inst_31320 = (state_31499[(16)]);
var inst_31330 = cljs.core.seq(inst_31320);
var inst_31331 = cljs.core.first(inst_31330);
var inst_31332 = cljs.core.next(inst_31330);
var inst_31333 = cljs.core.PersistentHashSet.EMPTY;
var inst_31334 = inst_31320;
var inst_31335 = inst_31333;
var state_31499__$1 = (function (){var statearr_31525 = state_31499;
(statearr_31525[(17)] = inst_31334);

(statearr_31525[(18)] = inst_31331);

(statearr_31525[(19)] = inst_31332);

(statearr_31525[(15)] = inst_31335);

return statearr_31525;
})();
var statearr_31526_31599 = state_31499__$1;
(statearr_31526_31599[(2)] = null);

(statearr_31526_31599[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (28))){
var inst_31463 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31527_31600 = state_31499__$1;
(statearr_31527_31600[(2)] = inst_31463);

(statearr_31527_31600[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (25))){
var inst_31400 = (state_31499[(2)]);
var inst_31401 = fluree.db.util.async.throw_err(inst_31400);
var state_31499__$1 = state_31499;
var statearr_31528_31601 = state_31499__$1;
(statearr_31528_31601[(2)] = inst_31401);

(statearr_31528_31601[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (34))){
var inst_31349 = (state_31499[(7)]);
var inst_31351 = (state_31499[(8)]);
var inst_31431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31432 = [inst_31349];
var inst_31433 = (new cljs.core.PersistentVector(null,1,(5),inst_31431,inst_31432,null));
var inst_31434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31435 = [inst_31349,inst_31351];
var inst_31436 = (new cljs.core.PersistentVector(null,2,(5),inst_31434,inst_31435,null));
var inst_31437 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_31433,cljs.core._LT_,inst_31436);
var state_31499__$1 = state_31499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31499__$1,(37),inst_31437);
} else {
if((state_val_31500 === (17))){
var inst_31349 = (state_31499[(7)]);
var inst_31351 = (state_31499[(8)]);
var inst_31371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31372 = [inst_31349,inst_31351];
var inst_31373 = (new cljs.core.PersistentVector(null,2,(5),inst_31371,inst_31372,null));
var inst_31374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31375 = [inst_31349];
var inst_31376 = (new cljs.core.PersistentVector(null,1,(5),inst_31374,inst_31375,null));
var inst_31377 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_31373,cljs.core._LT__EQ_,inst_31376);
var state_31499__$1 = state_31499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31499__$1,(20),inst_31377);
} else {
if((state_val_31500 === (3))){
var inst_31497 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31499__$1,inst_31497);
} else {
if((state_val_31500 === (12))){
var inst_31341 = (state_31499[(20)]);
var inst_31349 = (state_31499[(7)]);
var inst_31349__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31341,(0),null);
var inst_31350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31341,(1),null);
var inst_31351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31341,(2),null);
var inst_31352 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_31349__$1);
var inst_31353 = cljs.core.not(inst_31352);
var state_31499__$1 = (function (){var statearr_31529 = state_31499;
(statearr_31529[(7)] = inst_31349__$1);

(statearr_31529[(10)] = inst_31350);

(statearr_31529[(8)] = inst_31351);

return statearr_31529;
})();
if(inst_31353){
var statearr_31530_31602 = state_31499__$1;
(statearr_31530_31602[(1)] = (14));

} else {
var statearr_31531_31603 = state_31499__$1;
(statearr_31531_31603[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (2))){
var inst_31320 = (state_31499[(16)]);
var _ = (function (){var statearr_31532 = state_31499;
(statearr_31532[(4)] = cljs.core.cons((5),(state_31499[(4)])));

return statearr_31532;
})();
var inst_31318 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_31319 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31318,(0),null);
var inst_31320__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31318,(1),null);
var inst_31321 = cljs.core.not_empty(inst_31320__$1);
var state_31499__$1 = (function (){var statearr_31533 = state_31499;
(statearr_31533[(21)] = inst_31319);

(statearr_31533[(16)] = inst_31320__$1);

return statearr_31533;
})();
if(cljs.core.truth_(inst_31321)){
var statearr_31534_31604 = state_31499__$1;
(statearr_31534_31604[(1)] = (6));

} else {
var statearr_31535_31605 = state_31499__$1;
(statearr_31535_31605[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (23))){
var inst_31350 = (state_31499[(10)]);
var inst_31368 = (state_31499[(11)]);
var inst_31403 = (inst_31368.cljs$core$IFn$_invoke$arity$2 ? inst_31368.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_31350) : inst_31368.call(null,cljs.core._GT_,inst_31350));
var state_31499__$1 = state_31499;
if(cljs.core.truth_(inst_31403)){
var statearr_31536_31606 = state_31499__$1;
(statearr_31536_31606[(1)] = (26));

} else {
var statearr_31537_31607 = state_31499__$1;
(statearr_31537_31607[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (47))){
var inst_31482 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
if(cljs.core.truth_(inst_31482)){
var statearr_31538_31608 = state_31499__$1;
(statearr_31538_31608[(1)] = (48));

} else {
var statearr_31539_31609 = state_31499__$1;
(statearr_31539_31609[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (35))){
var inst_31350 = (state_31499[(10)]);
var inst_31368 = (state_31499[(11)]);
var inst_31442 = (inst_31368.cljs$core$IFn$_invoke$arity$2 ? inst_31368.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_31350) : inst_31368.call(null,cljs.core._LT__EQ_,inst_31350));
var state_31499__$1 = state_31499;
if(cljs.core.truth_(inst_31442)){
var statearr_31540_31610 = state_31499__$1;
(statearr_31540_31610[(1)] = (38));

} else {
var statearr_31541_31611 = state_31499__$1;
(statearr_31541_31611[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (19))){
var inst_31319 = (state_31499[(21)]);
var inst_31467 = (state_31499[(2)]);
var inst_31468 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_31467);
var state_31499__$1 = (function (){var statearr_31542 = state_31499;
(statearr_31542[(14)] = inst_31468);

return statearr_31542;
})();
var G__31543_31612 = inst_31319;
var G__31543_31613__$1 = (((G__31543_31612 instanceof cljs.core.Keyword))?G__31543_31612.fqn:null);
switch (G__31543_31613__$1) {
case "or":
var statearr_31544_31615 = state_31499__$1;
(statearr_31544_31615[(1)] = (43));


break;
case "and":
var statearr_31545_31616 = state_31499__$1;
(statearr_31545_31616[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31543_31613__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (11))){
var inst_31335 = (state_31499[(15)]);
var state_31499__$1 = state_31499;
var statearr_31547_31617 = state_31499__$1;
(statearr_31547_31617[(2)] = inst_31335);

(statearr_31547_31617[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (9))){
var inst_31334 = (state_31499[(17)]);
var inst_31341 = (state_31499[(20)]);
var inst_31340 = cljs.core.seq(inst_31334);
var inst_31341__$1 = cljs.core.first(inst_31340);
var inst_31342 = cljs.core.next(inst_31340);
var inst_31343 = cljs.core.not(inst_31341__$1);
var state_31499__$1 = (function (){var statearr_31548 = state_31499;
(statearr_31548[(20)] = inst_31341__$1);

(statearr_31548[(22)] = inst_31342);

return statearr_31548;
})();
if(inst_31343){
var statearr_31549_31618 = state_31499__$1;
(statearr_31549_31618[(1)] = (11));

} else {
var statearr_31550_31619 = state_31499__$1;
(statearr_31550_31619[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (5))){
var _ = (function (){var statearr_31551 = state_31499;
(statearr_31551[(4)] = cljs.core.rest((state_31499[(4)])));

return statearr_31551;
})();
var state_31499__$1 = state_31499;
var ex31546 = (state_31499__$1[(2)]);
var statearr_31552_31620 = state_31499__$1;
(statearr_31552_31620[(5)] = ex31546);


if((ex31546 instanceof Error)){
var statearr_31553_31621 = state_31499__$1;
(statearr_31553_31621[(1)] = (4));

(statearr_31553_31621[(5)] = null);

} else {
throw ex31546;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (14))){
var inst_31349 = (state_31499[(7)]);
var inst_31355 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31349);
var inst_31356 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31355)].join('');
var inst_31357 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31358 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_31359 = cljs.core.PersistentHashMap.fromArrays(inst_31357,inst_31358);
var inst_31360 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31356,inst_31359);
var inst_31361 = (function(){throw inst_31360})();
var state_31499__$1 = state_31499;
var statearr_31554_31622 = state_31499__$1;
(statearr_31554_31622[(2)] = inst_31361);

(statearr_31554_31622[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (45))){
var inst_31476 = (state_31499[(13)]);
var inst_31479 = cljs.core.empty_QMARK_(inst_31476);
var state_31499__$1 = state_31499;
var statearr_31555_31623 = state_31499__$1;
(statearr_31555_31623[(2)] = inst_31479);

(statearr_31555_31623[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (26))){
var inst_31349 = (state_31499[(7)]);
var inst_31351 = (state_31499[(8)]);
var inst_31405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31406 = [inst_31349,inst_31351];
var inst_31407 = (new cljs.core.PersistentVector(null,2,(5),inst_31405,inst_31406,null));
var inst_31408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31409 = [inst_31349];
var inst_31410 = (new cljs.core.PersistentVector(null,1,(5),inst_31408,inst_31409,null));
var inst_31411 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_31407,cljs.core._LT__EQ_,inst_31410);
var state_31499__$1 = state_31499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31499__$1,(29),inst_31411);
} else {
if((state_val_31500 === (16))){
var inst_31350 = (state_31499[(10)]);
var inst_31368 = (state_31499[(11)]);
var inst_31364 = (state_31499[(2)]);
var inst_31368__$1 = cljs.core.identical_QMARK_;
var inst_31369 = (inst_31368__$1.cljs$core$IFn$_invoke$arity$2 ? inst_31368__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_31350) : inst_31368__$1.call(null,cljs.core.not_EQ_,inst_31350));
var state_31499__$1 = (function (){var statearr_31556 = state_31499;
(statearr_31556[(23)] = inst_31364);

(statearr_31556[(11)] = inst_31368__$1);

return statearr_31556;
})();
if(cljs.core.truth_(inst_31369)){
var statearr_31557_31624 = state_31499__$1;
(statearr_31557_31624[(1)] = (17));

} else {
var statearr_31558_31625 = state_31499__$1;
(statearr_31558_31625[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (38))){
var inst_31349 = (state_31499[(7)]);
var inst_31351 = (state_31499[(8)]);
var inst_31444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31445 = [inst_31349];
var inst_31446 = (new cljs.core.PersistentVector(null,1,(5),inst_31444,inst_31445,null));
var inst_31447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31448 = [inst_31349,inst_31351];
var inst_31449 = (new cljs.core.PersistentVector(null,2,(5),inst_31447,inst_31448,null));
var inst_31450 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_31446,cljs.core._LT__EQ_,inst_31449);
var state_31499__$1 = state_31499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31499__$1,(41),inst_31450);
} else {
if((state_val_31500 === (30))){
var inst_31349 = (state_31499[(7)]);
var inst_31351 = (state_31499[(8)]);
var inst_31418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31419 = [inst_31349,inst_31351];
var inst_31420 = (new cljs.core.PersistentVector(null,2,(5),inst_31418,inst_31419,null));
var inst_31421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31422 = [inst_31349];
var inst_31423 = (new cljs.core.PersistentVector(null,1,(5),inst_31421,inst_31422,null));
var inst_31424 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_31420,cljs.core._LT__EQ_,inst_31423);
var state_31499__$1 = state_31499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31499__$1,(33),inst_31424);
} else {
if((state_val_31500 === (10))){
var inst_31491 = (state_31499[(2)]);
var state_31499__$1 = state_31499;
var statearr_31559_31626 = state_31499__$1;
(statearr_31559_31626[(2)] = inst_31491);

(statearr_31559_31626[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (18))){
var inst_31350 = (state_31499[(10)]);
var inst_31368 = (state_31499[(11)]);
var inst_31393 = (inst_31368.cljs$core$IFn$_invoke$arity$2 ? inst_31368.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_31350) : inst_31368.call(null,cljs.core._EQ_,inst_31350));
var state_31499__$1 = state_31499;
if(cljs.core.truth_(inst_31393)){
var statearr_31560_31627 = state_31499__$1;
(statearr_31560_31627[(1)] = (22));

} else {
var statearr_31561_31628 = state_31499__$1;
(statearr_31561_31628[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (42))){
var inst_31319 = (state_31499[(21)]);
var inst_31477 = (state_31499[(12)]);
var inst_31476 = (state_31499[(2)]);
var inst_31477__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_31319);
var state_31499__$1 = (function (){var statearr_31562 = state_31499;
(statearr_31562[(13)] = inst_31476);

(statearr_31562[(12)] = inst_31477__$1);

return statearr_31562;
})();
if(inst_31477__$1){
var statearr_31563_31629 = state_31499__$1;
(statearr_31563_31629[(1)] = (45));

} else {
var statearr_31564_31630 = state_31499__$1;
(statearr_31564_31630[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (37))){
var inst_31439 = (state_31499[(2)]);
var inst_31440 = fluree.db.util.async.throw_err(inst_31439);
var state_31499__$1 = state_31499;
var statearr_31565_31631 = state_31499__$1;
(statearr_31565_31631[(2)] = inst_31440);

(statearr_31565_31631[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (8))){
var inst_31494 = (state_31499[(2)]);
var _ = (function (){var statearr_31566 = state_31499;
(statearr_31566[(4)] = cljs.core.rest((state_31499[(4)])));

return statearr_31566;
})();
var state_31499__$1 = state_31499;
var statearr_31567_31632 = state_31499__$1;
(statearr_31567_31632[(2)] = inst_31494);

(statearr_31567_31632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31500 === (49))){
var inst_31476 = (state_31499[(13)]);
var inst_31342 = (state_31499[(22)]);
var inst_31334 = inst_31342;
var inst_31335 = inst_31476;
var state_31499__$1 = (function (){var statearr_31568 = state_31499;
(statearr_31568[(17)] = inst_31334);

(statearr_31568[(15)] = inst_31335);

return statearr_31568;
})();
var statearr_31569_31633 = state_31499__$1;
(statearr_31569_31633[(2)] = null);

(statearr_31569_31633[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10841__auto__ = null;
var fluree$db$query$fql$state_machine__10841__auto____0 = (function (){
var statearr_31570 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31570[(0)] = fluree$db$query$fql$state_machine__10841__auto__);

(statearr_31570[(1)] = (1));

return statearr_31570;
});
var fluree$db$query$fql$state_machine__10841__auto____1 = (function (state_31499){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_31499);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e31571){var ex__10844__auto__ = e31571;
var statearr_31572_31634 = state_31499;
(statearr_31572_31634[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_31499[(4)]))){
var statearr_31573_31635 = state_31499;
(statearr_31573_31635[(1)] = cljs.core.first((state_31499[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31636 = state_31499;
state_31499 = G__31636;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10841__auto__ = function(state_31499){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10841__auto____1.call(this,state_31499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10841__auto____0;
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10841__auto____1;
return fluree$db$query$fql$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_31574 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_31574[(6)] = c__10878__auto__);

return statearr_31574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_((function (p1__31637_SHARP_){
return ((typeof p1__31637_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__31637_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__31638_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__31638_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__31642 = vars;
var vec__31643 = G__31642;
var seq__31644 = cljs.core.seq(vec__31643);
var first__31645 = cljs.core.first(seq__31644);
var seq__31644__$1 = cljs.core.next(seq__31644);
var var$ = first__31645;
var r = seq__31644__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__31642__$1 = G__31642;
var all_vars__$1 = all_vars;
while(true){
var vec__31650 = G__31642__$1;
var seq__31651 = cljs.core.seq(vec__31650);
var first__31652 = cljs.core.first(seq__31651);
var seq__31651__$1 = cljs.core.next(seq__31651);
var var$__$1 = first__31652;
var r__$1 = seq__31651__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__31653 = cljs.core.set(all_vars__$2);
return (fexpr__31653.cljs$core$IFn$_invoke$arity$1 ? fexpr__31653.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__31653.call(null,var$__$1));
})())){
var G__31654 = r__$1;
var G__31655 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__31642__$1 = G__31654;
all_vars__$1 = G__31655;
continue;
} else {
var G__31656 = r__$1;
var G__31657 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__31642__$1 = G__31656;
all_vars__$1 = G__31657;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_31692){
var state_val_31693 = (state_31692[(1)]);
if((state_val_31693 === (1))){
var inst_31665 = functionArray;
var inst_31666 = cljs.core.seq(inst_31665);
var inst_31667 = cljs.core.first(inst_31666);
var inst_31668 = cljs.core.next(inst_31666);
var inst_31669 = cljs.core.PersistentVector.EMPTY;
var inst_31670 = inst_31665;
var inst_31671 = inst_31669;
var state_31692__$1 = (function (){var statearr_31694 = state_31692;
(statearr_31694[(7)] = inst_31668);

(statearr_31694[(8)] = inst_31667);

(statearr_31694[(9)] = inst_31670);

(statearr_31694[(10)] = inst_31671);

return statearr_31694;
})();
var statearr_31695_31708 = state_31692__$1;
(statearr_31695_31708[(2)] = null);

(statearr_31695_31708[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31693 === (2))){
var inst_31670 = (state_31692[(9)]);
var inst_31677 = (state_31692[(11)]);
var inst_31676 = cljs.core.seq(inst_31670);
var inst_31677__$1 = cljs.core.first(inst_31676);
var inst_31678 = cljs.core.next(inst_31676);
var state_31692__$1 = (function (){var statearr_31696 = state_31692;
(statearr_31696[(12)] = inst_31678);

(statearr_31696[(11)] = inst_31677__$1);

return statearr_31696;
})();
if(cljs.core.truth_(inst_31677__$1)){
var statearr_31697_31709 = state_31692__$1;
(statearr_31697_31709[(1)] = (4));

} else {
var statearr_31698_31710 = state_31692__$1;
(statearr_31698_31710[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31693 === (3))){
var inst_31690 = (state_31692[(2)]);
var state_31692__$1 = state_31692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31692__$1,inst_31690);
} else {
if((state_val_31693 === (4))){
var inst_31677 = (state_31692[(11)]);
var inst_31680 = (inst_31677.cljs$core$IFn$_invoke$arity$1 ? inst_31677.cljs$core$IFn$_invoke$arity$1(tuple) : inst_31677.call(null,tuple));
var state_31692__$1 = state_31692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31692__$1,(7),inst_31680);
} else {
if((state_val_31693 === (5))){
var inst_31671 = (state_31692[(10)]);
var state_31692__$1 = state_31692;
var statearr_31699_31711 = state_31692__$1;
(statearr_31699_31711[(2)] = inst_31671);

(statearr_31699_31711[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31693 === (6))){
var inst_31688 = (state_31692[(2)]);
var state_31692__$1 = state_31692;
var statearr_31700_31712 = state_31692__$1;
(statearr_31700_31712[(2)] = inst_31688);

(statearr_31700_31712[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31693 === (7))){
var inst_31678 = (state_31692[(12)]);
var inst_31671 = (state_31692[(10)]);
var inst_31682 = (state_31692[(2)]);
var inst_31683 = fluree.db.util.async.throw_err(inst_31682);
var inst_31684 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31671,inst_31683);
var inst_31670 = inst_31678;
var inst_31671__$1 = inst_31684;
var state_31692__$1 = (function (){var statearr_31701 = state_31692;
(statearr_31701[(9)] = inst_31670);

(statearr_31701[(10)] = inst_31671__$1);

return statearr_31701;
})();
var statearr_31702_31713 = state_31692__$1;
(statearr_31702_31713[(2)] = null);

(statearr_31702_31713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__10841__auto____0 = (function (){
var statearr_31703 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31703[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__10841__auto__);

(statearr_31703[(1)] = (1));

return statearr_31703;
});
var fluree$db$query$fql$format_tuple_$_state_machine__10841__auto____1 = (function (state_31692){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_31692);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e31704){var ex__10844__auto__ = e31704;
var statearr_31705_31714 = state_31692;
(statearr_31705_31714[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_31692[(4)]))){
var statearr_31706_31715 = state_31692;
(statearr_31706_31715[(1)] = cljs.core.first((state_31692[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31716 = state_31692;
state_31692 = G__31716;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__10841__auto__ = function(state_31692){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__10841__auto____1.call(this,state_31692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__10841__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__10841__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_31707 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_31707[(6)] = c__10878__auto__);

return statearr_31707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__31717){
var vec__31718 = p__31717;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31718,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31718,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_31732){
var state_val_31733 = (state_31732[(1)]);
if((state_val_31733 === (1))){
var inst_31721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31722 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_31723 = [query_map,_id,query_opts];
var inst_31724 = cljs.core.PersistentHashMap.fromArrays(inst_31722,inst_31723);
var inst_31725 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_31724) : fluree.db.query.fql.query.call(null,db,inst_31724));
var state_31732__$1 = (function (){var statearr_31734 = state_31732;
(statearr_31734[(7)] = inst_31721);

return statearr_31734;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31732__$1,(2),inst_31725);
} else {
if((state_val_31733 === (2))){
var inst_31721 = (state_31732[(7)]);
var inst_31727 = (state_31732[(2)]);
var inst_31728 = fluree.db.util.async.throw_err(inst_31727);
var inst_31729 = [tuple_index,inst_31728];
var inst_31730 = (new cljs.core.PersistentVector(null,2,(5),inst_31721,inst_31729,null));
var state_31732__$1 = state_31732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31732__$1,inst_31730);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__10841__auto____0 = (function (){
var statearr_31735 = [null,null,null,null,null,null,null,null];
(statearr_31735[(0)] = fluree$db$query$fql$expand_map_$_state_machine__10841__auto__);

(statearr_31735[(1)] = (1));

return statearr_31735;
});
var fluree$db$query$fql$expand_map_$_state_machine__10841__auto____1 = (function (state_31732){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_31732);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e31736){var ex__10844__auto__ = e31736;
var statearr_31737_31740 = state_31732;
(statearr_31737_31740[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_31732[(4)]))){
var statearr_31738_31741 = state_31732;
(statearr_31738_31741[(1)] = cljs.core.first((state_31732[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31742 = state_31732;
state_31732 = G__31742;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__10841__auto__ = function(state_31732){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__10841__auto____1.call(this,state_31732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__10841__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__10841__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_31739 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_31739[(6)] = c__10878__auto__);

return statearr_31739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__31743 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31743,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31743,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_31808){
var state_val_31809 = (state_31808[(1)]);
if((state_val_31809 === (7))){
var inst_31803 = (state_31808[(2)]);
var _ = (function (){var statearr_31810 = state_31808;
(statearr_31810[(4)] = cljs.core.rest((state_31808[(4)])));

return statearr_31810;
})();
var state_31808__$1 = state_31808;
var statearr_31811_31902 = state_31808__$1;
(statearr_31811_31902[(2)] = inst_31803);

(statearr_31811_31902[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (20))){
var inst_31794 = (state_31808[(2)]);
var state_31808__$1 = state_31808;
var statearr_31812_31903 = state_31808__$1;
(statearr_31812_31903[(2)] = inst_31794);

(statearr_31812_31903[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (1))){
var state_31808__$1 = state_31808;
var statearr_31813_31904 = state_31808__$1;
(statearr_31813_31904[(2)] = null);

(statearr_31813_31904[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (4))){
var inst_31748 = (state_31808[(2)]);
var state_31808__$1 = state_31808;
var statearr_31814_31905 = state_31808__$1;
(statearr_31814_31905[(2)] = inst_31748);

(statearr_31814_31905[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (15))){
var inst_31768 = (state_31808[(7)]);
var inst_31777 = cljs.core._deref(fuel);
var inst_31778 = cljs.core.second(inst_31768);
var inst_31779 = (inst_31777 + inst_31778);
var inst_31780 = cljs.core._vreset_BANG_(fuel,inst_31779);
var inst_31781 = (inst_31780 > max_fuel);
var state_31808__$1 = state_31808;
if(cljs.core.truth_(inst_31781)){
var statearr_31815_31906 = state_31808__$1;
(statearr_31815_31906[(1)] = (18));

} else {
var statearr_31816_31907 = state_31808__$1;
(statearr_31816_31907[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (13))){
var state_31808__$1 = state_31808;
var statearr_31817_31908 = state_31808__$1;
(statearr_31817_31908[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (6))){
var inst_31756 = (state_31808[(8)]);
var state_31808__$1 = state_31808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31808__$1,(8),inst_31756);
} else {
if((state_val_31809 === (17))){
var inst_31797 = (state_31808[(2)]);
var state_31808__$1 = state_31808;
var statearr_31819_31909 = state_31808__$1;
(statearr_31819_31909[(2)] = inst_31797);

(statearr_31819_31909[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (3))){
var inst_31806 = (state_31808[(2)]);
var state_31808__$1 = state_31808;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31808__$1,inst_31806);
} else {
if((state_val_31809 === (12))){
var inst_31768 = (state_31808[(7)]);
var inst_31757 = (state_31808[(9)]);
var inst_31774 = (inst_31757.cljs$core$IFn$_invoke$arity$0 ? inst_31757.cljs$core$IFn$_invoke$arity$0() : inst_31757.call(null));
var state_31808__$1 = (function (){var statearr_31820 = state_31808;
(statearr_31820[(10)] = inst_31774);

return statearr_31820;
})();
var statearr_31821_31910 = state_31808__$1;
(statearr_31821_31910[(2)] = inst_31768);

(statearr_31821_31910[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (2))){
var inst_31756 = (state_31808[(8)]);
var inst_31757 = (state_31808[(9)]);
var _ = (function (){var statearr_31822 = state_31808;
(statearr_31822[(4)] = cljs.core.cons((5),(state_31808[(4)])));

return statearr_31822;
})();
var inst_31754 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_31755 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_31756__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_31757__$1 = (function (){var expandMaps = inst_31754;
var queue_ch = inst_31755;
var res_ch = inst_31756__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_31758 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_31759 = cljs.core.volatile_BANG_((0));
var inst_31760 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_31758,cljs.core.cst$kw$fuel,inst_31759);
var inst_31761 = (function (){var expandMaps = inst_31754;
var queue_ch = inst_31755;
var res_ch = inst_31756__$1;
var stop_BANG_ = inst_31757__$1;
var opts_STAR_ = inst_31760;
return (function (tuple_res,port){
var c__10878__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_31855){
var state_val_31856 = (state_31855[(1)]);
if((state_val_31856 === (7))){
var state_31855__$1 = state_31855;
var statearr_31857_31911 = state_31855__$1;
(statearr_31857_31911[(2)] = tuple_res);

(statearr_31857_31911[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31856 === (1))){
var state_31855__$1 = state_31855;
var statearr_31858_31912 = state_31855__$1;
(statearr_31858_31912[(2)] = null);

(statearr_31858_31912[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31856 === (4))){
var inst_31823 = (state_31855[(2)]);
var inst_31824 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_31823);
var inst_31825 = cljs.core.async.close_BANG_(port);
var state_31855__$1 = (function (){var statearr_31859 = state_31855;
(statearr_31859[(7)] = inst_31824);

return statearr_31859;
})();
var statearr_31860_31913 = state_31855__$1;
(statearr_31860_31913[(2)] = inst_31825);

(statearr_31860_31913[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31856 === (6))){
var inst_31832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31833 = [tuple_res];
var inst_31834 = (new cljs.core.PersistentVector(null,1,(5),inst_31832,inst_31833,null));
var state_31855__$1 = state_31855;
var statearr_31861_31914 = state_31855__$1;
(statearr_31861_31914[(2)] = inst_31834);

(statearr_31861_31914[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31856 === (3))){
var inst_31853 = (state_31855[(2)]);
var state_31855__$1 = state_31855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31855__$1,inst_31853);
} else {
if((state_val_31856 === (2))){
var ___$1 = (function (){var statearr_31863 = state_31855;
(statearr_31863[(4)] = cljs.core.cons((5),(state_31855[(4)])));

return statearr_31863;
})();
var state_31855__$1 = state_31855;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_31864_31915 = state_31855__$1;
(statearr_31864_31915[(1)] = (6));

} else {
var statearr_31865_31916 = state_31855__$1;
(statearr_31865_31916[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31856 === (9))){
var inst_31839 = (state_31855[(8)]);
var inst_31837 = (state_31855[(9)]);
var inst_31846 = (state_31855[(2)]);
var inst_31847 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_31837,inst_31846);
var inst_31848 = (inst_31839.cljs$core$IFn$_invoke$arity$1 ? inst_31839.cljs$core$IFn$_invoke$arity$1(inst_31847) : inst_31839.call(null,inst_31847));
var inst_31849 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_31848);
var inst_31850 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_31866 = state_31855;
(statearr_31866[(4)] = cljs.core.rest((state_31855[(4)])));

return statearr_31866;
})();
var state_31855__$1 = (function (){var statearr_31867 = state_31855;
(statearr_31867[(10)] = inst_31849);

return statearr_31867;
})();
var statearr_31868_31917 = state_31855__$1;
(statearr_31868_31917[(2)] = inst_31850);

(statearr_31868_31917[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31856 === (5))){
var ___$1 = (function (){var statearr_31869 = state_31855;
(statearr_31869[(4)] = cljs.core.rest((state_31855[(4)])));

return statearr_31869;
})();
var state_31855__$1 = state_31855;
var ex31862 = (state_31855__$1[(2)]);
var statearr_31870_31918 = state_31855__$1;
(statearr_31870_31918[(5)] = ex31862);


var statearr_31871_31919 = state_31855__$1;
(statearr_31871_31919[(1)] = (4));

(statearr_31871_31919[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31856 === (8))){
var inst_31837 = (state_31855[(9)]);
var inst_31837__$1 = (state_31855[(2)]);
var inst_31838 = cljs.core.volatile_BANG_((0));
var inst_31839 = (function (){var tuple_res_SINGLEQUOTE_ = inst_31837__$1;
var query_fuel = inst_31838;
return (function (p1__31747_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__31747_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31747_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_31840 = cljs.core.PersistentVector.EMPTY;
var inst_31841 = (function (){var tuple_res_SINGLEQUOTE_ = inst_31837__$1;
var query_fuel = inst_31838;
return (function (p1__31746_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__31746_SHARP_);
});
})();
var inst_31842 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_31841,expandMaps);
var inst_31843 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_31842);
var inst_31844 = cljs.core.async.into(inst_31840,inst_31843);
var state_31855__$1 = (function (){var statearr_31872 = state_31855;
(statearr_31872[(8)] = inst_31839);

(statearr_31872[(9)] = inst_31837__$1);

return statearr_31872;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31855__$1,(9),inst_31844);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____0 = (function (){
var statearr_31873 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31873[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__);

(statearr_31873[(1)] = (1));

return statearr_31873;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____1 = (function (state_31855){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_31855);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e31874){var ex__10844__auto__ = e31874;
var statearr_31875_31920 = state_31855;
(statearr_31875_31920[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_31855[(4)]))){
var statearr_31876_31921 = state_31855;
(statearr_31876_31921[(1)] = cljs.core.first((state_31855[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31922 = state_31855;
state_31855 = G__31922;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__ = function(state_31855){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____1.call(this,state_31855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_31877 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_31877[(6)] = c__10878__auto____$1);

return statearr_31877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto____$1;
});
})();
var inst_31762 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31755,tuples_res);
var inst_31763 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_31756__$1,inst_31761,inst_31755);
var inst_31764 = cljs.core.PersistentVector.EMPTY;
var inst_31765 = inst_31764;
var state_31808__$1 = (function (){var statearr_31878 = state_31808;
(statearr_31878[(8)] = inst_31756__$1);

(statearr_31878[(11)] = inst_31763);

(statearr_31878[(9)] = inst_31757__$1);

(statearr_31878[(12)] = inst_31762);

(statearr_31878[(13)] = inst_31765);

return statearr_31878;
})();
var statearr_31879_31923 = state_31808__$1;
(statearr_31879_31923[(2)] = null);

(statearr_31879_31923[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (19))){
var inst_31768 = (state_31808[(7)]);
var inst_31765 = (state_31808[(13)]);
var inst_31790 = cljs.core.first(inst_31768);
var inst_31791 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_31765,inst_31790);
var inst_31765__$1 = inst_31791;
var state_31808__$1 = (function (){var statearr_31880 = state_31808;
(statearr_31880[(13)] = inst_31765__$1);

return statearr_31880;
})();
var statearr_31881_31924 = state_31808__$1;
(statearr_31881_31924[(2)] = null);

(statearr_31881_31924[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (11))){
var inst_31801 = (state_31808[(2)]);
var state_31808__$1 = state_31808;
var statearr_31883_31925 = state_31808__$1;
(statearr_31883_31925[(2)] = inst_31801);

(statearr_31883_31925[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (9))){
var inst_31765 = (state_31808[(13)]);
var state_31808__$1 = state_31808;
var statearr_31884_31926 = state_31808__$1;
(statearr_31884_31926[(2)] = inst_31765);

(statearr_31884_31926[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (5))){
var _ = (function (){var statearr_31885 = state_31808;
(statearr_31885[(4)] = cljs.core.rest((state_31808[(4)])));

return statearr_31885;
})();
var state_31808__$1 = state_31808;
var ex31882 = (state_31808__$1[(2)]);
var statearr_31886_31927 = state_31808__$1;
(statearr_31886_31927[(5)] = ex31882);


if((ex31882 instanceof Error)){
var statearr_31887_31928 = state_31808__$1;
(statearr_31887_31928[(1)] = (4));

(statearr_31887_31928[(5)] = null);

} else {
throw ex31882;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (14))){
var inst_31799 = (state_31808[(2)]);
var state_31808__$1 = state_31808;
var statearr_31888_31929 = state_31808__$1;
(statearr_31888_31929[(2)] = inst_31799);

(statearr_31888_31929[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (16))){
var state_31808__$1 = state_31808;
var statearr_31889_31930 = state_31808__$1;
(statearr_31889_31930[(2)] = null);

(statearr_31889_31930[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (10))){
var inst_31768 = (state_31808[(7)]);
var inst_31772 = fluree.db.util.core.exception_QMARK_(inst_31768);
var state_31808__$1 = state_31808;
if(inst_31772){
var statearr_31890_31931 = state_31808__$1;
(statearr_31890_31931[(1)] = (12));

} else {
var statearr_31891_31932 = state_31808__$1;
(statearr_31891_31932[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (18))){
var inst_31757 = (state_31808[(9)]);
var inst_31783 = (inst_31757.cljs$core$IFn$_invoke$arity$0 ? inst_31757.cljs$core$IFn$_invoke$arity$0() : inst_31757.call(null));
var inst_31784 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_31785 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_31786 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_31787 = cljs.core.PersistentHashMap.fromArrays(inst_31785,inst_31786);
var inst_31788 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31784,inst_31787);
var state_31808__$1 = (function (){var statearr_31892 = state_31808;
(statearr_31892[(14)] = inst_31783);

return statearr_31892;
})();
var statearr_31893_31933 = state_31808__$1;
(statearr_31893_31933[(2)] = inst_31788);

(statearr_31893_31933[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31809 === (8))){
var inst_31768 = (state_31808[(7)]);
var inst_31768__$1 = (state_31808[(2)]);
var inst_31769 = (inst_31768__$1 == null);
var state_31808__$1 = (function (){var statearr_31894 = state_31808;
(statearr_31894[(7)] = inst_31768__$1);

return statearr_31894;
})();
if(cljs.core.truth_(inst_31769)){
var statearr_31895_31934 = state_31808__$1;
(statearr_31895_31934[(1)] = (9));

} else {
var statearr_31896_31935 = state_31808__$1;
(statearr_31896_31935[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____0 = (function (){
var statearr_31897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31897[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__);

(statearr_31897[(1)] = (1));

return statearr_31897;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____1 = (function (state_31808){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_31808);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e31898){var ex__10844__auto__ = e31898;
var statearr_31899_31936 = state_31808;
(statearr_31899_31936[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_31808[(4)]))){
var statearr_31900_31937 = state_31808;
(statearr_31900_31937[(1)] = cljs.core.first((state_31808[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__31938 = state_31808;
state_31808 = G__31938;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__ = function(state_31808){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____1.call(this,state_31808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_31901 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_31901[(6)] = c__10878__auto__);

return statearr_31901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__31939 = select;
var map__31939__$1 = cljs.core.__destructure_map(map__31939);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31939__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31939__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31939__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__31942 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31942,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31942,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31942,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__31940_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__31940_SHARP_,compare_idx));
}):(function (p1__31941_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__31941_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__31947 = arguments.length;
switch (G__31947) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__31948,p__31949,group_limit,opts){
var map__31950 = p__31948;
var map__31950__$1 = cljs.core.__destructure_map(map__31950);
var res = map__31950__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31950__$1,cljs.core.cst$kw$vars);
var map__31951 = p__31949;
var map__31951__$1 = cljs.core.__destructure_map(map__31951);
var select_spec = map__31951__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31951__$1,cljs.core.cst$kw$groupBy);
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_32088){
var state_val_32089 = (state_32088[(1)]);
if((state_val_32089 === (7))){
var inst_31958 = (state_32088[(7)]);
var state_32088__$1 = state_32088;
var statearr_32090_32192 = state_32088__$1;
(statearr_32090_32192[(2)] = inst_31958);

(statearr_32090_32192[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (59))){
var inst_32081 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
var statearr_32091_32193 = state_32088__$1;
(statearr_32091_32193[(2)] = inst_32081);

(statearr_32091_32193[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (20))){
var inst_31997 = (state_32088[(8)]);
var inst_31994 = (state_32088[(9)]);
var inst_31993 = (state_32088[(2)]);
var inst_31994__$1 = cljs.core.__destructure_map(inst_31993);
var inst_31995 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31994__$1,cljs.core.cst$kw$headers);
var inst_31996 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31994__$1,cljs.core.cst$kw$tuples);
var inst_31997__$1 = offset;
var state_32088__$1 = (function (){var statearr_32092 = state_32088;
(statearr_32092[(8)] = inst_31997__$1);

(statearr_32092[(10)] = inst_31996);

(statearr_32092[(11)] = inst_31995);

(statearr_32092[(9)] = inst_31994__$1);

return statearr_32092;
})();
if(cljs.core.truth_(inst_31997__$1)){
var statearr_32093_32194 = state_32088__$1;
(statearr_32093_32194[(1)] = (21));

} else {
var statearr_32094_32195 = state_32088__$1;
(statearr_32094_32195[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (58))){
var inst_32073 = (state_32088[(12)]);
var state_32088__$1 = state_32088;
var statearr_32095_32196 = state_32088__$1;
(statearr_32095_32196[(2)] = inst_32073);

(statearr_32095_32196[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (60))){
var inst_32077 = (state_32088[(2)]);
var inst_32078 = fluree.db.util.async.throw_err(inst_32077);
var state_32088__$1 = state_32088;
var statearr_32096_32197 = state_32088__$1;
(statearr_32096_32197[(2)] = inst_32078);

(statearr_32096_32197[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (27))){
var inst_32009 = cljs.core.not(inVector_QMARK_);
var state_32088__$1 = state_32088;
var statearr_32097_32198 = state_32088__$1;
(statearr_32097_32198[(2)] = inst_32009);

(statearr_32097_32198[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (1))){
var state_32088__$1 = state_32088;
var statearr_32098_32199 = state_32088__$1;
(statearr_32098_32199[(2)] = null);

(statearr_32098_32199[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (24))){
var state_32088__$1 = state_32088;
var statearr_32099_32200 = state_32088__$1;
(statearr_32099_32200[(2)] = offset);

(statearr_32099_32200[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (55))){
var inst_32067 = (state_32088[(13)]);
var state_32088__$1 = state_32088;
var statearr_32100_32201 = state_32088__$1;
(statearr_32100_32201[(2)] = inst_32067);

(statearr_32100_32201[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (39))){
var inst_32035 = (state_32088[(14)]);
var inst_32037 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_32038 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32035,inst_32037);
var state_32088__$1 = state_32088;
var statearr_32101_32202 = state_32088__$1;
(statearr_32101_32202[(2)] = inst_32038);

(statearr_32101_32202[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (46))){
var inst_32047 = (state_32088[(15)]);
var state_32088__$1 = state_32088;
var statearr_32102_32203 = state_32088__$1;
(statearr_32102_32203[(2)] = inst_32047);

(statearr_32102_32203[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (4))){
var inst_31952 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
var statearr_32103_32204 = state_32088__$1;
(statearr_32103_32204[(2)] = inst_31952);

(statearr_32103_32204[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (54))){
var inst_32067 = (state_32088[(13)]);
var inst_32061 = (state_32088[(16)]);
var inst_32069 = cljs.core.PersistentVector.EMPTY;
var inst_32070 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_32069,inst_32061,inst_32067);
var state_32088__$1 = state_32088;
var statearr_32104_32205 = state_32088__$1;
(statearr_32104_32205[(2)] = inst_32070);

(statearr_32104_32205[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (15))){
var inst_31979 = (state_32088[(17)]);
var inst_31981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31982 = [inst_31979];
var inst_31983 = (new cljs.core.PersistentVector(null,1,(5),inst_31981,inst_31982,null));
var state_32088__$1 = state_32088;
var statearr_32105_32206 = state_32088__$1;
(statearr_32105_32206[(2)] = inst_31983);

(statearr_32105_32206[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (48))){
var inst_31996 = (state_32088[(10)]);
var inst_32012 = (state_32088[(18)]);
var inst_32017 = (state_32088[(19)]);
var inst_31995 = (state_32088[(11)]);
var inst_32006 = (state_32088[(20)]);
var inst_31994 = (state_32088[(9)]);
var inst_32053 = (state_32088[(21)]);
var inst_32055 = (function (){var map__31988 = inst_31994;
var headers = inst_31995;
var tuples = inst_31996;
var offset_SINGLEQUOTE_ = inst_32006;
var single_result_QMARK_ = inst_32012;
var pp_keys = inst_32017;
var G__32018 = inst_32053;
return (function (p1__31945_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__31945_SHARP_);
});
})();
var inst_32056 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_32055);
var inst_32057 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32053,inst_32056);
var state_32088__$1 = state_32088;
var statearr_32106_32207 = state_32088__$1;
(statearr_32106_32207[(2)] = inst_32057);

(statearr_32106_32207[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (50))){
var inst_32060 = (state_32088[(2)]);
var inst_32061 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_32060);
var state_32088__$1 = (function (){var statearr_32107 = state_32088;
(statearr_32107[(16)] = inst_32061);

return statearr_32107;
})();
if(cljs.core.truth_(orderBy)){
var statearr_32108_32208 = state_32088__$1;
(statearr_32108_32208[(1)] = (51));

} else {
var statearr_32109_32209 = state_32088__$1;
(statearr_32109_32209[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (21))){
var inst_31999 = cljs.core.not(groupBy);
var state_32088__$1 = state_32088;
var statearr_32110_32210 = state_32088__$1;
(statearr_32110_32210[(2)] = inst_31999);

(statearr_32110_32210[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (31))){
var state_32088__$1 = state_32088;
var statearr_32111_32211 = state_32088__$1;
(statearr_32111_32211[(2)] = null);

(statearr_32111_32211[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (32))){
var inst_32012 = (state_32088[(18)]);
var inst_31995 = (state_32088[(11)]);
var inst_32017 = (state_32088[(2)]);
var inst_32019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32020 = fluree.db.query.fql.select_tuples_fn(inst_31995,vars,select);
var inst_32021 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_32020);
var inst_32022 = [inst_32021];
var inst_32023 = (new cljs.core.PersistentVector(null,1,(5),inst_32019,inst_32022,null));
var state_32088__$1 = (function (){var statearr_32112 = state_32088;
(statearr_32112[(19)] = inst_32017);

(statearr_32112[(22)] = inst_32023);

return statearr_32112;
})();
if(cljs.core.truth_(inst_32012)){
var statearr_32113_32212 = state_32088__$1;
(statearr_32113_32212[(1)] = (33));

} else {
var statearr_32114_32213 = state_32088__$1;
(statearr_32114_32213[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (40))){
var inst_32035 = (state_32088[(14)]);
var state_32088__$1 = state_32088;
var statearr_32115_32214 = state_32088__$1;
(statearr_32115_32214[(2)] = inst_32035);

(statearr_32115_32214[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (56))){
var inst_32073 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32116 = state_32088;
(statearr_32116[(12)] = inst_32073);

return statearr_32116;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_32117_32215 = state_32088__$1;
(statearr_32117_32215[(1)] = (57));

} else {
var statearr_32118_32216 = state_32088__$1;
(statearr_32118_32216[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (33))){
var inst_32023 = (state_32088[(22)]);
var inst_32025 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_32026 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32023,inst_32025);
var state_32088__$1 = state_32088;
var statearr_32119_32217 = state_32088__$1;
(statearr_32119_32217[(2)] = inst_32026);

(statearr_32119_32217[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (13))){
var inst_31968 = (state_32088[(23)]);
var state_32088__$1 = state_32088;
var statearr_32120_32218 = state_32088__$1;
(statearr_32120_32218[(2)] = inst_31968);

(statearr_32120_32218[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (22))){
var inst_31997 = (state_32088[(8)]);
var state_32088__$1 = state_32088;
var statearr_32121_32219 = state_32088__$1;
(statearr_32121_32219[(2)] = inst_31997);

(statearr_32121_32219[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (36))){
var inst_32029 = (state_32088[(24)]);
var inst_32031 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_32032 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32029,inst_32031);
var state_32088__$1 = state_32088;
var statearr_32122_32220 = state_32088__$1;
(statearr_32122_32220[(2)] = inst_32032);

(statearr_32122_32220[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (41))){
var inst_32006 = (state_32088[(20)]);
var inst_32041 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32123 = state_32088;
(statearr_32123[(25)] = inst_32041);

return statearr_32123;
})();
if(cljs.core.truth_(inst_32006)){
var statearr_32124_32221 = state_32088__$1;
(statearr_32124_32221[(1)] = (42));

} else {
var statearr_32125_32222 = state_32088__$1;
(statearr_32125_32222[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (43))){
var inst_32041 = (state_32088[(25)]);
var state_32088__$1 = state_32088;
var statearr_32126_32223 = state_32088__$1;
(statearr_32126_32223[(2)] = inst_32041);

(statearr_32126_32223[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (29))){
var inst_32012 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32127 = state_32088;
(statearr_32127[(18)] = inst_32012);

return statearr_32127;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_32128_32224 = state_32088__$1;
(statearr_32128_32224[(1)] = (30));

} else {
var statearr_32129_32225 = state_32088__$1;
(statearr_32129_32225[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (44))){
var inst_32047 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32130 = state_32088;
(statearr_32130[(15)] = inst_32047);

return statearr_32130;
})();
if(cljs.core.truth_(group_limit)){
var statearr_32131_32226 = state_32088__$1;
(statearr_32131_32226[(1)] = (45));

} else {
var statearr_32132_32227 = state_32088__$1;
(statearr_32132_32227[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (6))){
var inst_31960 = cljs.core.count(select);
var inst_31961 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_31960);
var state_32088__$1 = state_32088;
var statearr_32133_32228 = state_32088__$1;
(statearr_32133_32228[(2)] = inst_31961);

(statearr_32133_32228[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (28))){
var inst_32007 = (state_32088[(26)]);
var state_32088__$1 = state_32088;
var statearr_32134_32229 = state_32088__$1;
(statearr_32134_32229[(2)] = inst_32007);

(statearr_32134_32229[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (51))){
var inst_31996 = (state_32088[(10)]);
var inst_31995 = (state_32088[(11)]);
var inst_32064 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_31995,orderBy,inst_31996);
var state_32088__$1 = state_32088;
var statearr_32135_32230 = state_32088__$1;
(statearr_32135_32230[(2)] = inst_32064);

(statearr_32135_32230[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (25))){
var state_32088__$1 = state_32088;
var statearr_32136_32231 = state_32088__$1;
(statearr_32136_32231[(2)] = null);

(statearr_32136_32231[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (34))){
var inst_32023 = (state_32088[(22)]);
var state_32088__$1 = state_32088;
var statearr_32137_32232 = state_32088__$1;
(statearr_32137_32232[(2)] = inst_32023);

(statearr_32137_32232[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (17))){
var inst_31986 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
var statearr_32138_32233 = state_32088__$1;
(statearr_32138_32233[(2)] = inst_31986);

(statearr_32138_32233[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (3))){
var inst_32086 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32088__$1,inst_32086);
} else {
if((state_val_32089 === (12))){
var inst_31968 = (state_32088[(23)]);
var inst_31970 = cljs.core.first(select);
var inst_31971 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_31970);
var inst_31972 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31971);
var inst_31973 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_31972,(1));
var inst_31974 = [inst_31973];
var inst_31975 = [inst_31968];
var inst_31976 = cljs.core.PersistentHashMap.fromArrays(inst_31974,inst_31975);
var state_32088__$1 = state_32088;
var statearr_32139_32234 = state_32088__$1;
(statearr_32139_32234[(2)] = inst_31976);

(statearr_32139_32234[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (2))){
var inst_31958 = (state_32088[(7)]);
var _ = (function (){var statearr_32140 = state_32088;
(statearr_32140[(4)] = cljs.core.cons((5),(state_32088[(4)])));

return statearr_32140;
})();
var inst_31958__$1 = aggregates;
var state_32088__$1 = (function (){var statearr_32141 = state_32088;
(statearr_32141[(7)] = inst_31958__$1);

return statearr_32141;
})();
if(cljs.core.truth_(inst_31958__$1)){
var statearr_32142_32235 = state_32088__$1;
(statearr_32142_32235[(1)] = (6));

} else {
var statearr_32143_32236 = state_32088__$1;
(statearr_32143_32236[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (23))){
var inst_32002 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
if(cljs.core.truth_(inst_32002)){
var statearr_32144_32237 = state_32088__$1;
(statearr_32144_32237[(1)] = (24));

} else {
var statearr_32145_32238 = state_32088__$1;
(statearr_32145_32238[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (47))){
var inst_32053 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32146 = state_32088;
(statearr_32146[(21)] = inst_32053);

return statearr_32146;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_32147_32239 = state_32088__$1;
(statearr_32147_32239[(1)] = (48));

} else {
var statearr_32148_32240 = state_32088__$1;
(statearr_32148_32240[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (35))){
var inst_32029 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32149 = state_32088;
(statearr_32149[(24)] = inst_32029);

return statearr_32149;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_32150_32241 = state_32088__$1;
(statearr_32150_32241[(1)] = (36));

} else {
var statearr_32151_32242 = state_32088__$1;
(statearr_32151_32242[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (19))){
var state_32088__$1 = state_32088;
var statearr_32152_32243 = state_32088__$1;
(statearr_32152_32243[(2)] = res);

(statearr_32152_32243[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (57))){
var inst_32012 = (state_32088[(18)]);
var inst_32017 = (state_32088[(19)]);
var inst_32073 = (state_32088[(12)]);
var inst_32075 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_32017,inst_32012,db,fuel,max_fuel,opts,(8),inst_32073);
var state_32088__$1 = state_32088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32088__$1,(60),inst_32075);
} else {
if((state_val_32089 === (11))){
var inst_32083 = (state_32088[(2)]);
var _ = (function (){var statearr_32154 = state_32088;
(statearr_32154[(4)] = cljs.core.rest((state_32088[(4)])));

return statearr_32154;
})();
var state_32088__$1 = state_32088;
var statearr_32155_32244 = state_32088__$1;
(statearr_32155_32244[(2)] = inst_32083);

(statearr_32155_32244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (9))){
var inst_31966 = cljs.core.first(aggregates);
var inst_31967 = fluree.db.query.analytical.calculate_aggregate(res,inst_31966);
var inst_31968 = cljs.core.second(inst_31967);
var state_32088__$1 = (function (){var statearr_32156 = state_32088;
(statearr_32156[(23)] = inst_31968);

return statearr_32156;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_32157_32245 = state_32088__$1;
(statearr_32157_32245[(1)] = (12));

} else {
var statearr_32158_32246 = state_32088__$1;
(statearr_32158_32246[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (5))){
var _ = (function (){var statearr_32159 = state_32088;
(statearr_32159[(4)] = cljs.core.rest((state_32088[(4)])));

return statearr_32159;
})();
var state_32088__$1 = state_32088;
var ex32153 = (state_32088__$1[(2)]);
var statearr_32160_32247 = state_32088__$1;
(statearr_32160_32247[(5)] = ex32153);


if((ex32153 instanceof Error)){
var statearr_32161_32248 = state_32088__$1;
(statearr_32161_32248[(1)] = (4));

(statearr_32161_32248[(5)] = null);

} else {
throw ex32153;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (14))){
var inst_31979 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32162 = state_32088;
(statearr_32162[(17)] = inst_31979);

return statearr_32162;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_32163_32249 = state_32088__$1;
(statearr_32163_32249[(1)] = (15));

} else {
var statearr_32164_32250 = state_32088__$1;
(statearr_32164_32250[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (45))){
var inst_32047 = (state_32088[(15)]);
var inst_32049 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_32050 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32047,inst_32049);
var state_32088__$1 = state_32088;
var statearr_32165_32251 = state_32088__$1;
(statearr_32165_32251[(2)] = inst_32050);

(statearr_32165_32251[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (53))){
var inst_32067 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32166 = state_32088;
(statearr_32166[(13)] = inst_32067);

return statearr_32166;
})();
var statearr_32167_32252 = state_32088__$1;
(statearr_32167_32252[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (26))){
var inst_32007 = (state_32088[(26)]);
var inst_32006 = (state_32088[(2)]);
var inst_32007__$1 = cljs.core.not(prettyPrint);
var state_32088__$1 = (function (){var statearr_32169 = state_32088;
(statearr_32169[(26)] = inst_32007__$1);

(statearr_32169[(20)] = inst_32006);

return statearr_32169;
})();
if(inst_32007__$1){
var statearr_32170_32253 = state_32088__$1;
(statearr_32170_32253[(1)] = (27));

} else {
var statearr_32171_32254 = state_32088__$1;
(statearr_32171_32254[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (16))){
var inst_31979 = (state_32088[(17)]);
var state_32088__$1 = state_32088;
var statearr_32172_32255 = state_32088__$1;
(statearr_32172_32255[(2)] = inst_31979);

(statearr_32172_32255[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (38))){
var inst_32035 = (state_32088[(2)]);
var state_32088__$1 = (function (){var statearr_32173 = state_32088;
(statearr_32173[(14)] = inst_32035);

return statearr_32173;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_32174_32256 = state_32088__$1;
(statearr_32174_32256[(1)] = (39));

} else {
var statearr_32175_32257 = state_32088__$1;
(statearr_32175_32257[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (30))){
var inst_32014 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_32088__$1 = state_32088;
var statearr_32176_32258 = state_32088__$1;
(statearr_32176_32258[(2)] = inst_32014);

(statearr_32176_32258[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (10))){
var state_32088__$1 = state_32088;
if(cljs.core.truth_(aggregates)){
var statearr_32177_32259 = state_32088__$1;
(statearr_32177_32259[(1)] = (18));

} else {
var statearr_32178_32260 = state_32088__$1;
(statearr_32178_32260[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (18))){
var inst_31990 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_32088__$1 = state_32088;
var statearr_32179_32261 = state_32088__$1;
(statearr_32179_32261[(2)] = inst_31990);

(statearr_32179_32261[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (52))){
var inst_31996 = (state_32088[(10)]);
var state_32088__$1 = state_32088;
var statearr_32180_32262 = state_32088__$1;
(statearr_32180_32262[(2)] = inst_31996);

(statearr_32180_32262[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (42))){
var inst_32041 = (state_32088[(25)]);
var inst_32006 = (state_32088[(20)]);
var inst_32043 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_32006);
var inst_32044 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32041,inst_32043);
var state_32088__$1 = state_32088;
var statearr_32181_32263 = state_32088__$1;
(statearr_32181_32263[(2)] = inst_32044);

(statearr_32181_32263[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (37))){
var inst_32029 = (state_32088[(24)]);
var state_32088__$1 = state_32088;
var statearr_32182_32264 = state_32088__$1;
(statearr_32182_32264[(2)] = inst_32029);

(statearr_32182_32264[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (8))){
var inst_31964 = (state_32088[(2)]);
var state_32088__$1 = state_32088;
if(cljs.core.truth_(inst_31964)){
var statearr_32183_32265 = state_32088__$1;
(statearr_32183_32265[(1)] = (9));

} else {
var statearr_32184_32266 = state_32088__$1;
(statearr_32184_32266[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32089 === (49))){
var inst_32053 = (state_32088[(21)]);
var state_32088__$1 = state_32088;
var statearr_32185_32267 = state_32088__$1;
(statearr_32185_32267[(2)] = inst_32053);

(statearr_32185_32267[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10841__auto__ = null;
var fluree$db$query$fql$state_machine__10841__auto____0 = (function (){
var statearr_32186 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32186[(0)] = fluree$db$query$fql$state_machine__10841__auto__);

(statearr_32186[(1)] = (1));

return statearr_32186;
});
var fluree$db$query$fql$state_machine__10841__auto____1 = (function (state_32088){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_32088);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e32187){var ex__10844__auto__ = e32187;
var statearr_32188_32268 = state_32088;
(statearr_32188_32268[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_32088[(4)]))){
var statearr_32189_32269 = state_32088;
(statearr_32189_32269[(1)] = cljs.core.first((state_32088[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__32270 = state_32088;
state_32088 = G__32270;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10841__auto__ = function(state_32088){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10841__auto____1.call(this,state_32088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10841__auto____0;
fluree$db$query$fql$state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10841__auto____1;
return fluree$db$query$fql$state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_32190 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_32190[(6)] = c__10878__auto__);

return statearr_32190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__32273,groupBy){
var map__32274 = p__32273;
var map__32274__$1 = cljs.core.__destructure_map(map__32274);
var res = map__32274__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32274__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32274__$1,cljs.core.cst$kw$tuples);
var vec__32275 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32275,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32275,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32271_SHARP_){
return fluree.db.util.core.index_of(headers,p1__32271_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32272_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__32272_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__32278 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32278,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32278,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__32281,p__32282,opts){
var map__32283 = p__32281;
var map__32283__$1 = cljs.core.__destructure_map(map__32283);
var res = map__32283__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32283__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32283__$1,cljs.core.cst$kw$vars);
var map__32284 = p__32282;
var map__32284__$1 = cljs.core.__destructure_map(map__32284);
var select_spec = map__32284__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32284__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32284__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32284__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32284__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32284__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32284__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32284__$1,cljs.core.cst$kw$offset);
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_32502){
var state_val_32503 = (state_32502[(1)]);
if((state_val_32503 === (65))){
var inst_32415 = (state_32502[(7)]);
var inst_32443 = cljs.core.empty_QMARK_(inst_32415);
var state_32502__$1 = state_32502;
var statearr_32504_32637 = state_32502__$1;
(statearr_32504_32637[(2)] = inst_32443);

(statearr_32504_32637[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (70))){
var state_32502__$1 = state_32502;
var statearr_32505_32638 = state_32502__$1;
(statearr_32505_32638[(2)] = (1));

(statearr_32505_32638[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (62))){
var state_32502__$1 = state_32502;
var statearr_32506_32639 = state_32502__$1;
(statearr_32506_32639[(2)] = null);

(statearr_32506_32639[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (74))){
var state_32502__$1 = state_32502;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_32507_32640 = state_32502__$1;
(statearr_32507_32640[(1)] = (77));

} else {
var statearr_32508_32641 = state_32502__$1;
(statearr_32508_32641[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (7))){
var state_32502__$1 = state_32502;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_32509_32642 = state_32502__$1;
(statearr_32509_32642[(1)] = (70));

} else {
var statearr_32510_32643 = state_32502__$1;
(statearr_32510_32643[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (59))){
var state_32502__$1 = state_32502;
var statearr_32511_32644 = state_32502__$1;
(statearr_32511_32644[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (20))){
var state_32502__$1 = state_32502;
var statearr_32513_32645 = state_32502__$1;
(statearr_32513_32645[(2)] = (0));

(statearr_32513_32645[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (72))){
var inst_32469 = (state_32502[(2)]);
var inst_32470 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_32469,opts);
var state_32502__$1 = state_32502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32502__$1,(73),inst_32470);
} else {
if((state_val_32503 === (58))){
var inst_32353 = (state_32502[(8)]);
var inst_32427 = (inst_32353 - (1));
var state_32502__$1 = state_32502;
var statearr_32514_32646 = state_32502__$1;
(statearr_32514_32646[(2)] = inst_32427);

(statearr_32514_32646[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (60))){
var inst_32437 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32515_32647 = state_32502__$1;
(statearr_32515_32647[(2)] = inst_32437);

(statearr_32515_32647[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (27))){
var inst_32352 = (state_32502[(9)]);
var inst_32376 = (inst_32352 < (1));
var state_32502__$1 = state_32502;
var statearr_32516_32648 = state_32502__$1;
(statearr_32516_32648[(2)] = inst_32376);

(statearr_32516_32648[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (1))){
var state_32502__$1 = state_32502;
var statearr_32517_32649 = state_32502__$1;
(statearr_32517_32649[(2)] = null);

(statearr_32517_32649[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (69))){
var inst_32422 = (state_32502[(10)]);
var inst_32367 = (state_32502[(11)]);
var inst_32439 = (state_32502[(12)]);
var inst_32364 = (state_32502[(13)]);
var inst_32450 = (state_32502[(2)]);
var inst_32350 = inst_32364;
var inst_32351 = inst_32367;
var inst_32352 = inst_32422;
var inst_32353 = inst_32439;
var inst_32354 = inst_32450;
var state_32502__$1 = (function (){var statearr_32518 = state_32502;
(statearr_32518[(14)] = inst_32350);

(statearr_32518[(15)] = inst_32351);

(statearr_32518[(9)] = inst_32352);

(statearr_32518[(8)] = inst_32353);

(statearr_32518[(16)] = inst_32354);

return statearr_32518;
})();
var statearr_32519_32650 = state_32502__$1;
(statearr_32519_32650[(2)] = null);

(statearr_32519_32650[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (24))){
var inst_32354 = (state_32502[(16)]);
var state_32502__$1 = state_32502;
var statearr_32520_32651 = state_32502__$1;
(statearr_32520_32651[(2)] = inst_32354);

(statearr_32520_32651[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (55))){
var state_32502__$1 = state_32502;
var statearr_32521_32652 = state_32502__$1;
(statearr_32521_32652[(2)] = (0));

(statearr_32521_32652[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (85))){
var inst_32491 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32522_32653 = state_32502__$1;
(statearr_32522_32653[(2)] = inst_32491);

(statearr_32522_32653[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (39))){
var inst_32371 = (state_32502[(17)]);
var inst_32394 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_32395 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_32396 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_32371,inst_32394,inst_32395);
var state_32502__$1 = state_32502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32502__$1,(42),inst_32396);
} else {
if((state_val_32503 === (46))){
var inst_32352 = (state_32502[(9)]);
var inst_32407 = ((0) < inst_32352);
var state_32502__$1 = state_32502;
var statearr_32523_32654 = state_32502__$1;
(statearr_32523_32654[(2)] = inst_32407);

(statearr_32523_32654[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (4))){
var inst_32285 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32524_32655 = state_32502__$1;
(statearr_32524_32655[(2)] = inst_32285);

(statearr_32524_32655[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (77))){
var inst_32473 = (state_32502[(18)]);
var inst_32478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32479 = [inst_32473];
var inst_32480 = (new cljs.core.PersistentVector(null,1,(5),inst_32478,inst_32479,null));
var state_32502__$1 = state_32502;
var statearr_32525_32656 = state_32502__$1;
(statearr_32525_32656[(2)] = inst_32480);

(statearr_32525_32656[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (54))){
var inst_32353 = (state_32502[(8)]);
var inst_32422 = (state_32502[(2)]);
var inst_32423 = (inst_32353 <= (0));
var state_32502__$1 = (function (){var statearr_32526 = state_32502;
(statearr_32526[(10)] = inst_32422);

return statearr_32526;
})();
if(cljs.core.truth_(inst_32423)){
var statearr_32527_32657 = state_32502__$1;
(statearr_32527_32657[(1)] = (55));

} else {
var statearr_32528_32658 = state_32502__$1;
(statearr_32528_32658[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (15))){
var inst_32303 = (state_32502[(19)]);
var inst_32311 = (state_32502[(2)]);
var inst_32312 = fluree.db.util.async.throw_err(inst_32311);
var inst_32313 = [inst_32303];
var inst_32314 = [inst_32312];
var inst_32315 = cljs.core.PersistentHashMap.fromArrays(inst_32313,inst_32314);
var state_32502__$1 = state_32502;
var statearr_32529_32659 = state_32502__$1;
(statearr_32529_32659[(2)] = inst_32315);

(statearr_32529_32659[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (48))){
var inst_32410 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
if(cljs.core.truth_(inst_32410)){
var statearr_32530_32660 = state_32502__$1;
(statearr_32530_32660[(1)] = (49));

} else {
var statearr_32531_32661 = state_32502__$1;
(statearr_32531_32661[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (50))){
var inst_32405 = (state_32502[(20)]);
var state_32502__$1 = state_32502;
var statearr_32532_32662 = state_32502__$1;
(statearr_32532_32662[(2)] = inst_32405);

(statearr_32532_32662[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (75))){
var state_32502__$1 = state_32502;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_32533_32663 = state_32502__$1;
(statearr_32533_32663[(1)] = (80));

} else {
var statearr_32534_32664 = state_32502__$1;
(statearr_32534_32664[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (21))){
var inst_32331 = (state_32502[(21)]);
var inst_32335 = (state_32502[(22)]);
var inst_32343 = (state_32502[(23)]);
var inst_32348 = (state_32502[(2)]);
var inst_32349 = cljs.core.PersistentHashMap.EMPTY;
var inst_32350 = inst_32331;
var inst_32351 = inst_32335;
var inst_32352 = inst_32343;
var inst_32353 = inst_32348;
var inst_32354 = inst_32349;
var state_32502__$1 = (function (){var statearr_32535 = state_32502;
(statearr_32535[(14)] = inst_32350);

(statearr_32535[(15)] = inst_32351);

(statearr_32535[(9)] = inst_32352);

(statearr_32535[(8)] = inst_32353);

(statearr_32535[(16)] = inst_32354);

return statearr_32535;
})();
var statearr_32536_32665 = state_32502__$1;
(statearr_32536_32665[(2)] = null);

(statearr_32536_32665[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (31))){
var inst_32368 = (state_32502[(24)]);
var inst_32353 = (state_32502[(8)]);
var inst_32382 = (inst_32353 >= inst_32368);
var state_32502__$1 = state_32502;
if(cljs.core.truth_(inst_32382)){
var statearr_32537_32666 = state_32502__$1;
(statearr_32537_32666[(1)] = (33));

} else {
var statearr_32538_32667 = state_32502__$1;
(statearr_32538_32667[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (32))){
var inst_32458 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32539_32668 = state_32502__$1;
(statearr_32539_32668[(2)] = inst_32458);

(statearr_32539_32668[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (40))){
var state_32502__$1 = state_32502;
var statearr_32540_32669 = state_32502__$1;
(statearr_32540_32669[(2)] = null);

(statearr_32540_32669[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (56))){
var state_32502__$1 = state_32502;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_32541_32670 = state_32502__$1;
(statearr_32541_32670[(1)] = (58));

} else {
var statearr_32542_32671 = state_32502__$1;
(statearr_32542_32671[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (33))){
var state_32502__$1 = state_32502;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_32543_32672 = state_32502__$1;
(statearr_32543_32672[(1)] = (36));

} else {
var statearr_32544_32673 = state_32502__$1;
(statearr_32544_32673[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (13))){
var inst_32331 = (state_32502[(21)]);
var inst_32300 = (state_32502[(25)]);
var inst_32335 = (state_32502[(22)]);
var inst_32331__$1 = cljs.core.keys(inst_32300);
var inst_32332 = cljs.core.seq(inst_32331__$1);
var inst_32333 = cljs.core.first(inst_32332);
var inst_32334 = cljs.core.next(inst_32332);
var inst_32335__$1 = cljs.core.vals(inst_32300);
var inst_32336 = cljs.core.seq(inst_32335__$1);
var inst_32337 = cljs.core.first(inst_32336);
var inst_32338 = cljs.core.next(inst_32336);
var inst_32339 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_32502__$1 = (function (){var statearr_32545 = state_32502;
(statearr_32545[(21)] = inst_32331__$1);

(statearr_32545[(26)] = inst_32337);

(statearr_32545[(22)] = inst_32335__$1);

(statearr_32545[(27)] = inst_32333);

(statearr_32545[(28)] = inst_32334);

(statearr_32545[(29)] = inst_32338);

return statearr_32545;
})();
if(inst_32339){
var statearr_32546_32674 = state_32502__$1;
(statearr_32546_32674[(1)] = (16));

} else {
var statearr_32547_32675 = state_32502__$1;
(statearr_32547_32675[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (22))){
var inst_32350 = (state_32502[(14)]);
var inst_32351 = (state_32502[(15)]);
var inst_32362 = cljs.core.seq(inst_32350);
var inst_32363 = cljs.core.first(inst_32362);
var inst_32364 = cljs.core.next(inst_32362);
var inst_32365 = cljs.core.seq(inst_32351);
var inst_32366 = cljs.core.first(inst_32365);
var inst_32367 = cljs.core.next(inst_32365);
var inst_32368 = cljs.core.count(inst_32366);
var inst_32369 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_32370 = [headers,vars,inst_32366];
var inst_32371 = cljs.core.PersistentHashMap.fromArrays(inst_32369,inst_32370);
var inst_32372 = (inst_32366 == null);
var state_32502__$1 = (function (){var statearr_32548 = state_32502;
(statearr_32548[(24)] = inst_32368);

(statearr_32548[(30)] = inst_32363);

(statearr_32548[(11)] = inst_32367);

(statearr_32548[(13)] = inst_32364);

(statearr_32548[(17)] = inst_32371);

return statearr_32548;
})();
if(cljs.core.truth_(inst_32372)){
var statearr_32549_32676 = state_32502__$1;
(statearr_32549_32676[(1)] = (24));

} else {
var statearr_32550_32677 = state_32502__$1;
(statearr_32550_32677[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (36))){
var inst_32353 = (state_32502[(8)]);
var inst_32385 = (inst_32353 - (1));
var state_32502__$1 = state_32502;
var statearr_32551_32678 = state_32502__$1;
(statearr_32551_32678[(2)] = inst_32385);

(statearr_32551_32678[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (41))){
var inst_32454 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32552_32679 = state_32502__$1;
(statearr_32552_32679[(2)] = inst_32454);

(statearr_32552_32679[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (43))){
var inst_32399 = (state_32502[(31)]);
var inst_32353 = (state_32502[(8)]);
var inst_32402 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_32353,inst_32399);
var state_32502__$1 = state_32502;
var statearr_32553_32680 = state_32502__$1;
(statearr_32553_32680[(2)] = inst_32402);

(statearr_32553_32680[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (61))){
var inst_32368 = (state_32502[(24)]);
var inst_32415 = (state_32502[(7)]);
var inst_32353 = (state_32502[(8)]);
var inst_32430 = cljs.core.count(inst_32415);
var inst_32431 = (inst_32368 - inst_32430);
var inst_32432 = (inst_32353 - inst_32431);
var state_32502__$1 = state_32502;
var statearr_32554_32681 = state_32502__$1;
(statearr_32554_32681[(2)] = inst_32432);

(statearr_32554_32681[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (29))){
var inst_32379 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
if(cljs.core.truth_(inst_32379)){
var statearr_32555_32682 = state_32502__$1;
(statearr_32555_32682[(1)] = (30));

} else {
var statearr_32556_32683 = state_32502__$1;
(statearr_32556_32683[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (44))){
var inst_32399 = (state_32502[(31)]);
var state_32502__$1 = state_32502;
var statearr_32557_32684 = state_32502__$1;
(statearr_32557_32684[(2)] = inst_32399);

(statearr_32557_32684[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (6))){
var inst_32292 = (state_32502[(32)]);
var inst_32292__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_32294 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_32502__$1 = (function (){var statearr_32558 = state_32502;
(statearr_32558[(33)] = inst_32294);

(statearr_32558[(32)] = inst_32292__$1);

return statearr_32558;
})();
if(cljs.core.truth_(inst_32292__$1)){
var statearr_32559_32685 = state_32502__$1;
(statearr_32559_32685[(1)] = (9));

} else {
var statearr_32560_32686 = state_32502__$1;
(statearr_32560_32686[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (28))){
var inst_32352 = (state_32502[(9)]);
var state_32502__$1 = state_32502;
var statearr_32561_32687 = state_32502__$1;
(statearr_32561_32687[(2)] = inst_32352);

(statearr_32561_32687[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (64))){
var inst_32440 = (state_32502[(34)]);
var state_32502__$1 = state_32502;
var statearr_32562_32688 = state_32502__$1;
(statearr_32562_32688[(2)] = inst_32440);

(statearr_32562_32688[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (51))){
var inst_32352 = (state_32502[(9)]);
var inst_32415 = (state_32502[(2)]);
var inst_32416 = (inst_32352 == null);
var state_32502__$1 = (function (){var statearr_32563 = state_32502;
(statearr_32563[(7)] = inst_32415);

return statearr_32563;
})();
if(cljs.core.truth_(inst_32416)){
var statearr_32564_32689 = state_32502__$1;
(statearr_32564_32689[(1)] = (52));

} else {
var statearr_32565_32690 = state_32502__$1;
(statearr_32565_32690[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (25))){
var inst_32352 = (state_32502[(9)]);
var state_32502__$1 = state_32502;
if(cljs.core.truth_(inst_32352)){
var statearr_32566_32691 = state_32502__$1;
(statearr_32566_32691[(1)] = (27));

} else {
var statearr_32567_32692 = state_32502__$1;
(statearr_32567_32692[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (34))){
var state_32502__$1 = state_32502;
var statearr_32568_32693 = state_32502__$1;
(statearr_32568_32693[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (17))){
var state_32502__$1 = state_32502;
var statearr_32570_32694 = state_32502__$1;
(statearr_32570_32694[(2)] = limit);

(statearr_32570_32694[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (3))){
var inst_32500 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32502__$1,inst_32500);
} else {
if((state_val_32503 === (12))){
var inst_32300 = (state_32502[(25)]);
var inst_32302 = cljs.core.keys(inst_32300);
var inst_32303 = cljs.core.first(inst_32302);
var inst_32304 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_32305 = cljs.core.vals(inst_32300);
var inst_32306 = cljs.core.first(inst_32305);
var inst_32307 = [headers,vars,inst_32306];
var inst_32308 = cljs.core.PersistentHashMap.fromArrays(inst_32304,inst_32307);
var inst_32309 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_32308,select_spec,limit,opts);
var state_32502__$1 = (function (){var statearr_32571 = state_32502;
(statearr_32571[(19)] = inst_32303);

return statearr_32571;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32502__$1,(15),inst_32309);
} else {
if((state_val_32503 === (2))){
var _ = (function (){var statearr_32572 = state_32502;
(statearr_32572[(4)] = cljs.core.cons((5),(state_32502[(4)])));

return statearr_32572;
})();
var state_32502__$1 = state_32502;
if(cljs.core.truth_(groupBy)){
var statearr_32573_32695 = state_32502__$1;
(statearr_32573_32695[(1)] = (6));

} else {
var statearr_32574_32696 = state_32502__$1;
(statearr_32574_32696[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (66))){
var inst_32445 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
if(cljs.core.truth_(inst_32445)){
var statearr_32575_32697 = state_32502__$1;
(statearr_32575_32697[(1)] = (67));

} else {
var statearr_32576_32698 = state_32502__$1;
(statearr_32576_32698[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (23))){
var inst_32462 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32577_32699 = state_32502__$1;
(statearr_32577_32699[(2)] = inst_32462);

(statearr_32577_32699[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (47))){
var inst_32352 = (state_32502[(9)]);
var state_32502__$1 = state_32502;
var statearr_32578_32700 = state_32502__$1;
(statearr_32578_32700[(2)] = inst_32352);

(statearr_32578_32700[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (35))){
var inst_32456 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32579_32701 = state_32502__$1;
(statearr_32579_32701[(2)] = inst_32456);

(statearr_32579_32701[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (82))){
var inst_32493 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32580_32702 = state_32502__$1;
(statearr_32580_32702[(2)] = inst_32493);

(statearr_32580_32702[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (76))){
var inst_32495 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32581_32703 = state_32502__$1;
(statearr_32581_32703[(2)] = inst_32495);

(statearr_32581_32703[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (19))){
var inst_32344 = (state_32502[(35)]);
var state_32502__$1 = state_32502;
var statearr_32582_32704 = state_32502__$1;
(statearr_32582_32704[(2)] = inst_32344);

(statearr_32582_32704[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (57))){
var inst_32440 = (state_32502[(34)]);
var inst_32415 = (state_32502[(7)]);
var inst_32439 = (state_32502[(2)]);
var inst_32440__$1 = (inst_32415 == null);
var state_32502__$1 = (function (){var statearr_32583 = state_32502;
(statearr_32583[(34)] = inst_32440__$1);

(statearr_32583[(12)] = inst_32439);

return statearr_32583;
})();
if(cljs.core.truth_(inst_32440__$1)){
var statearr_32584_32705 = state_32502__$1;
(statearr_32584_32705[(1)] = (64));

} else {
var statearr_32585_32706 = state_32502__$1;
(statearr_32585_32706[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (68))){
var inst_32363 = (state_32502[(30)]);
var inst_32415 = (state_32502[(7)]);
var inst_32354 = (state_32502[(16)]);
var inst_32448 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32354,inst_32363,inst_32415);
var state_32502__$1 = state_32502;
var statearr_32586_32707 = state_32502__$1;
(statearr_32586_32707[(2)] = inst_32448);

(statearr_32586_32707[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (11))){
var inst_32300 = (state_32502[(2)]);
var state_32502__$1 = (function (){var statearr_32588 = state_32502;
(statearr_32588[(25)] = inst_32300);

return statearr_32588;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_32589_32708 = state_32502__$1;
(statearr_32589_32708[(1)] = (12));

} else {
var statearr_32590_32709 = state_32502__$1;
(statearr_32590_32709[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (9))){
var inst_32294 = (state_32502[(33)]);
var inst_32292 = (state_32502[(32)]);
var inst_32296 = cljs.core.sorted_map_by(inst_32292);
var inst_32297 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32296,inst_32294);
var state_32502__$1 = state_32502;
var statearr_32591_32710 = state_32502__$1;
(statearr_32591_32710[(2)] = inst_32297);

(statearr_32591_32710[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (5))){
var _ = (function (){var statearr_32592 = state_32502;
(statearr_32592[(4)] = cljs.core.rest((state_32502[(4)])));

return statearr_32592;
})();
var state_32502__$1 = state_32502;
var ex32587 = (state_32502__$1[(2)]);
var statearr_32593_32711 = state_32502__$1;
(statearr_32593_32711[(5)] = ex32587);


if((ex32587 instanceof Error)){
var statearr_32594_32712 = state_32502__$1;
(statearr_32594_32712[(1)] = (4));

(statearr_32594_32712[(5)] = null);

} else {
throw ex32587;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (83))){
var inst_32473 = (state_32502[(18)]);
var state_32502__$1 = state_32502;
var statearr_32595_32713 = state_32502__$1;
(statearr_32595_32713[(2)] = inst_32473);

(statearr_32595_32713[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (14))){
var inst_32464 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32596_32714 = state_32502__$1;
(statearr_32596_32714[(2)] = inst_32464);

(statearr_32596_32714[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (45))){
var inst_32352 = (state_32502[(9)]);
var inst_32405 = (state_32502[(2)]);
var state_32502__$1 = (function (){var statearr_32597 = state_32502;
(statearr_32597[(20)] = inst_32405);

return statearr_32597;
})();
if(cljs.core.truth_(inst_32352)){
var statearr_32598_32715 = state_32502__$1;
(statearr_32598_32715[(1)] = (46));

} else {
var statearr_32599_32716 = state_32502__$1;
(statearr_32599_32716[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (53))){
var inst_32352 = (state_32502[(9)]);
var inst_32415 = (state_32502[(7)]);
var inst_32419 = cljs.core.count(inst_32415);
var inst_32420 = (inst_32352 - inst_32419);
var state_32502__$1 = state_32502;
var statearr_32600_32717 = state_32502__$1;
(statearr_32600_32717[(2)] = inst_32420);

(statearr_32600_32717[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (78))){
var inst_32473 = (state_32502[(18)]);
var state_32502__$1 = state_32502;
var statearr_32601_32718 = state_32502__$1;
(statearr_32601_32718[(2)] = inst_32473);

(statearr_32601_32718[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (26))){
var inst_32460 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32602_32719 = state_32502__$1;
(statearr_32602_32719[(2)] = inst_32460);

(statearr_32602_32719[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (16))){
var state_32502__$1 = state_32502;
var statearr_32603_32720 = state_32502__$1;
(statearr_32603_32720[(2)] = null);

(statearr_32603_32720[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (81))){
var state_32502__$1 = state_32502;
var statearr_32606_32721 = state_32502__$1;
(statearr_32606_32721[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (79))){
var inst_32483 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32608_32722 = state_32502__$1;
(statearr_32608_32722[(2)] = inst_32483);

(statearr_32608_32722[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (38))){
var inst_32352 = (state_32502[(9)]);
var inst_32367 = (state_32502[(11)]);
var inst_32354 = (state_32502[(16)]);
var inst_32364 = (state_32502[(13)]);
var inst_32389 = (state_32502[(2)]);
var tmp32604 = inst_32352;
var tmp32605 = inst_32354;
var inst_32350 = inst_32364;
var inst_32351 = inst_32367;
var inst_32352__$1 = tmp32604;
var inst_32353 = inst_32389;
var inst_32354__$1 = tmp32605;
var state_32502__$1 = (function (){var statearr_32609 = state_32502;
(statearr_32609[(14)] = inst_32350);

(statearr_32609[(15)] = inst_32351);

(statearr_32609[(9)] = inst_32352__$1);

(statearr_32609[(8)] = inst_32353);

(statearr_32609[(16)] = inst_32354__$1);

return statearr_32609;
})();
var statearr_32610_32723 = state_32502__$1;
(statearr_32610_32723[(2)] = null);

(statearr_32610_32723[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (30))){
var inst_32354 = (state_32502[(16)]);
var state_32502__$1 = state_32502;
var statearr_32611_32724 = state_32502__$1;
(statearr_32611_32724[(2)] = inst_32354);

(statearr_32611_32724[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (73))){
var inst_32473 = (state_32502[(18)]);
var inst_32472 = (state_32502[(2)]);
var inst_32473__$1 = fluree.db.util.async.throw_err(inst_32472);
var inst_32474 = cljs.core.coll_QMARK_(inst_32473__$1);
var inst_32475 = (!(inst_32474));
var state_32502__$1 = (function (){var statearr_32612 = state_32502;
(statearr_32612[(18)] = inst_32473__$1);

return statearr_32612;
})();
if(inst_32475){
var statearr_32613_32725 = state_32502__$1;
(statearr_32613_32725[(1)] = (74));

} else {
var statearr_32614_32726 = state_32502__$1;
(statearr_32614_32726[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (10))){
var inst_32294 = (state_32502[(33)]);
var state_32502__$1 = state_32502;
var statearr_32615_32727 = state_32502__$1;
(statearr_32615_32727[(2)] = inst_32294);

(statearr_32615_32727[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (18))){
var inst_32344 = (state_32502[(35)]);
var inst_32343 = (state_32502[(2)]);
var inst_32344__$1 = offset;
var state_32502__$1 = (function (){var statearr_32616 = state_32502;
(statearr_32616[(35)] = inst_32344__$1);

(statearr_32616[(23)] = inst_32343);

return statearr_32616;
})();
if(cljs.core.truth_(inst_32344__$1)){
var statearr_32617_32728 = state_32502__$1;
(statearr_32617_32728[(1)] = (19));

} else {
var statearr_32618_32729 = state_32502__$1;
(statearr_32618_32729[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (52))){
var state_32502__$1 = state_32502;
var statearr_32619_32730 = state_32502__$1;
(statearr_32619_32730[(2)] = null);

(statearr_32619_32730[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (67))){
var inst_32354 = (state_32502[(16)]);
var state_32502__$1 = state_32502;
var statearr_32620_32731 = state_32502__$1;
(statearr_32620_32731[(2)] = inst_32354);

(statearr_32620_32731[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (71))){
var state_32502__$1 = state_32502;
var statearr_32621_32732 = state_32502__$1;
(statearr_32621_32732[(2)] = limit);

(statearr_32621_32732[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (42))){
var inst_32353 = (state_32502[(8)]);
var inst_32398 = (state_32502[(2)]);
var inst_32399 = fluree.db.util.async.throw_err(inst_32398);
var inst_32400 = ((0) < inst_32353);
var state_32502__$1 = (function (){var statearr_32622 = state_32502;
(statearr_32622[(31)] = inst_32399);

return statearr_32622;
})();
if(cljs.core.truth_(inst_32400)){
var statearr_32623_32733 = state_32502__$1;
(statearr_32623_32733[(1)] = (43));

} else {
var statearr_32624_32734 = state_32502__$1;
(statearr_32624_32734[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (80))){
var inst_32473 = (state_32502[(18)]);
var inst_32486 = cljs.core.first(inst_32473);
var state_32502__$1 = state_32502;
var statearr_32625_32735 = state_32502__$1;
(statearr_32625_32735[(2)] = inst_32486);

(statearr_32625_32735[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (37))){
var inst_32368 = (state_32502[(24)]);
var inst_32353 = (state_32502[(8)]);
var inst_32387 = (inst_32353 - inst_32368);
var state_32502__$1 = state_32502;
var statearr_32626_32736 = state_32502__$1;
(statearr_32626_32736[(2)] = inst_32387);

(statearr_32626_32736[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (63))){
var inst_32435 = (state_32502[(2)]);
var state_32502__$1 = state_32502;
var statearr_32627_32737 = state_32502__$1;
(statearr_32627_32737[(2)] = inst_32435);

(statearr_32627_32737[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (8))){
var inst_32497 = (state_32502[(2)]);
var _ = (function (){var statearr_32628 = state_32502;
(statearr_32628[(4)] = cljs.core.rest((state_32502[(4)])));

return statearr_32628;
})();
var state_32502__$1 = state_32502;
var statearr_32629_32738 = state_32502__$1;
(statearr_32629_32738[(2)] = inst_32497);

(statearr_32629_32738[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (49))){
var inst_32352 = (state_32502[(9)]);
var inst_32405 = (state_32502[(20)]);
var inst_32412 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_32352,inst_32405);
var state_32502__$1 = state_32502;
var statearr_32630_32739 = state_32502__$1;
(statearr_32630_32739[(2)] = inst_32412);

(statearr_32630_32739[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32503 === (84))){
var state_32502__$1 = state_32502;
var statearr_32631_32740 = state_32502__$1;
(statearr_32631_32740[(2)] = null);

(statearr_32631_32740[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto____0 = (function (){
var statearr_32632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32632[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto__);

(statearr_32632[(1)] = (1));

return statearr_32632;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto____1 = (function (state_32502){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_32502);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e32633){var ex__10844__auto__ = e32633;
var statearr_32634_32741 = state_32502;
(statearr_32634_32741[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_32502[(4)]))){
var statearr_32635_32742 = state_32502;
(statearr_32635_32742[(1)] = cljs.core.first((state_32502[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__32743 = state_32502;
state_32502 = G__32743;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto__ = function(state_32502){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto____1.call(this,state_32502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_32636 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_32636[(6)] = c__10878__auto__);

return statearr_32636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__32746,opts){
var map__32747 = p__32746;
var map__32747__$1 = cljs.core.__destructure_map(map__32747);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32747__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__32744_SHARP_){
return cljs.core.contains_QMARK_(p1__32744_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__32745_SHARP_){
return cljs.core.contains_QMARK_(p1__32745_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4221__auto__){
var G__32749 = cljs.core.first(orderBy);
var fexpr__32748 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__32748.cljs$core$IFn$_invoke$arity$1 ? fexpr__32748.cljs$core$IFn$_invoke$arity$1(G__32749) : fexpr__32748.call(null,G__32749));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4223__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4223__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__32750,p__32751){
var map__32752 = p__32750;
var map__32752__$1 = cljs.core.__destructure_map(map__32752);
var query_map = map__32752__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32752__$1,cljs.core.cst$kw$construct);
var map__32753 = p__32751;
var map__32753__$1 = cljs.core.__destructure_map(map__32753);
var where_result = map__32753__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32753__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32753__$1,cljs.core.cst$kw$tuples);
var vec__32754 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32754,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32754,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32754,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_32787){
var state_val_32788 = (state_32787[(1)]);
if((state_val_32788 === (7))){
var inst_32766 = (state_32787[(7)]);
var state_32787__$1 = state_32787;
var statearr_32789_32812 = state_32787__$1;
(statearr_32789_32812[(2)] = inst_32766);

(statearr_32789_32812[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (1))){
var state_32787__$1 = state_32787;
var statearr_32790_32813 = state_32787__$1;
(statearr_32790_32813[(2)] = null);

(statearr_32790_32813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (4))){
var inst_32757 = (state_32787[(2)]);
var state_32787__$1 = state_32787;
var statearr_32791_32814 = state_32787__$1;
(statearr_32791_32814[(2)] = inst_32757);

(statearr_32791_32814[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (13))){
var inst_32776 = (state_32787[(2)]);
var inst_32777 = fluree.db.util.async.throw_err(inst_32776);
var state_32787__$1 = state_32787;
var statearr_32792_32815 = state_32787__$1;
(statearr_32792_32815[(2)] = inst_32777);

(statearr_32792_32815[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (6))){
var inst_32766 = (state_32787[(7)]);
var inst_32765 = (state_32787[(2)]);
var inst_32766__$1 = fluree.db.util.async.throw_err(inst_32765);
var inst_32767 = fluree.db.util.core.exception_QMARK_(inst_32766__$1);
var state_32787__$1 = (function (){var statearr_32793 = state_32787;
(statearr_32793[(7)] = inst_32766__$1);

return statearr_32793;
})();
if(inst_32767){
var statearr_32794_32816 = state_32787__$1;
(statearr_32794_32816[(1)] = (7));

} else {
var statearr_32795_32817 = state_32787__$1;
(statearr_32795_32817[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (3))){
var inst_32785 = (state_32787[(2)]);
var state_32787__$1 = state_32787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32787__$1,inst_32785);
} else {
if((state_val_32788 === (12))){
var inst_32780 = (state_32787[(2)]);
var state_32787__$1 = state_32787;
var statearr_32796_32818 = state_32787__$1;
(statearr_32796_32818[(2)] = inst_32780);

(statearr_32796_32818[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (2))){
var _ = (function (){var statearr_32797 = state_32787;
(statearr_32797[(4)] = cljs.core.cons((5),(state_32787[(4)])));

return statearr_32797;
})();
var inst_32763 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_32787__$1 = state_32787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32787__$1,(6),inst_32763);
} else {
if((state_val_32788 === (11))){
var state_32787__$1 = state_32787;
var statearr_32799_32819 = state_32787__$1;
(statearr_32799_32819[(2)] = null);

(statearr_32799_32819[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (9))){
var inst_32782 = (state_32787[(2)]);
var _ = (function (){var statearr_32800 = state_32787;
(statearr_32800[(4)] = cljs.core.rest((state_32787[(4)])));

return statearr_32800;
})();
var state_32787__$1 = state_32787;
var statearr_32801_32820 = state_32787__$1;
(statearr_32801_32820[(2)] = inst_32782);

(statearr_32801_32820[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (5))){
var _ = (function (){var statearr_32802 = state_32787;
(statearr_32802[(4)] = cljs.core.rest((state_32787[(4)])));

return statearr_32802;
})();
var state_32787__$1 = state_32787;
var ex32798 = (state_32787__$1[(2)]);
var statearr_32803_32821 = state_32787__$1;
(statearr_32803_32821[(5)] = ex32798);


if((ex32798 instanceof Error)){
var statearr_32804_32822 = state_32787__$1;
(statearr_32804_32822[(1)] = (4));

(statearr_32804_32822[(5)] = null);

} else {
throw ex32798;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32788 === (10))){
var inst_32766 = (state_32787[(7)]);
var inst_32771 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_32766);
var inst_32772 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_32766);
var inst_32773 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_32771,inst_32772,query_map,opts);
var inst_32774 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_32766,inst_32773,opts);
var state_32787__$1 = state_32787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32787__$1,(13),inst_32774);
} else {
if((state_val_32788 === (8))){
var state_32787__$1 = state_32787;
var statearr_32805_32823 = state_32787__$1;
(statearr_32805_32823[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto____0 = (function (){
var statearr_32807 = [null,null,null,null,null,null,null,null];
(statearr_32807[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto__);

(statearr_32807[(1)] = (1));

return statearr_32807;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto____1 = (function (state_32787){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_32787);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e32808){var ex__10844__auto__ = e32808;
var statearr_32809_32824 = state_32787;
(statearr_32809_32824[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_32787[(4)]))){
var statearr_32810_32825 = state_32787;
(statearr_32810_32825[(1)] = cljs.core.first((state_32787[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__32826 = state_32787;
state_32787 = G__32826;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto__ = function(state_32787){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto____1.call(this,state_32787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_32811 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_32811[(6)] = c__10878__auto__);

return statearr_32811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__32827 = query_map;
var map__32827__$1 = cljs.core.__destructure_map(map__32827);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32827__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__32828 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__32828,cljs.core.cst$kw$limit,(1));
} else {
return G__32828;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__10878__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10879__auto__ = (function (){var switch__10840__auto__ = (function (state_33187){
var state_val_33188 = (state_33187[(1)]);
if((state_val_33188 === (121))){
var inst_33148 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33189_33384 = state_33187__$1;
(statearr_33189_33384[(2)] = inst_33148);

(statearr_33189_33384[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (65))){
var inst_33021 = typeof from === 'string';
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_33021)){
var statearr_33190_33385 = state_33187__$1;
(statearr_33190_33385[(1)] = (72));

} else {
var statearr_33191_33386 = state_33187__$1;
(statearr_33191_33386[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (70))){
var inst_32890 = (state_33187[(7)]);
var inst_32892 = (state_33187[(8)]);
var inst_33014 = (state_33187[(2)]);
var inst_33015 = fluree.db.util.async.throw_err(inst_33014);
var inst_33016 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_32892,fuel,max_fuel,inst_32890,inst_33015);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(71),inst_33016);
} else {
if((state_val_33188 === (62))){
var inst_32994 = (state_33187[(9)]);
var state_33187__$1 = state_33187;
var statearr_33192_33387 = state_33187__$1;
(statearr_33192_33387[(2)] = inst_32994);

(statearr_33192_33387[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (74))){
var inst_33154 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33193_33388 = state_33187__$1;
(statearr_33193_33388[(2)] = inst_33154);

(statearr_33193_33388[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (110))){
var inst_33087 = (state_33187[(10)]);
var state_33187__$1 = state_33187;
var statearr_33194_33389 = state_33187__$1;
(statearr_33194_33389[(2)] = inst_33087);

(statearr_33194_33389[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (130))){
var inst_33174 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33195_33390 = state_33187__$1;
(statearr_33195_33390[(2)] = inst_33174);

(statearr_33195_33390[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (128))){
var inst_33165 = (state_33187[(11)]);
var inst_33170 = fluree.db.util.core.exception_QMARK_(inst_33165);
var inst_33171 = (!(inst_33170));
var state_33187__$1 = state_33187;
var statearr_33196_33391 = state_33187__$1;
(statearr_33196_33391[(2)] = inst_33171);

(statearr_33196_33391[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (7))){
var inst_32860 = (state_33187[(12)]);
var inst_32860__$1 = selectOne;
var state_33187__$1 = (function (){var statearr_33197 = state_33187;
(statearr_33197[(12)] = inst_32860__$1);

return statearr_33197;
})();
if(cljs.core.truth_(inst_32860__$1)){
var statearr_33198_33392 = state_33187__$1;
(statearr_33198_33392[(1)] = (9));

} else {
var statearr_33199_33393 = state_33187__$1;
(statearr_33199_33393[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (59))){
var inst_32890 = (state_33187[(7)]);
var inst_32892 = (state_33187[(8)]);
var inst_32972 = (state_33187[(13)]);
var inst_32880 = (state_33187[(14)]);
var inst_32986 = (state_33187[(2)]);
var inst_32987 = fluree.db.util.async.throw_err(inst_32986);
var inst_32988 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_32972,inst_32987);
var inst_32989 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_32892,fuel,max_fuel,inst_32890,inst_32988,inst_32880);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(60),inst_32989);
} else {
if((state_val_33188 === (86))){
var inst_32890 = (state_33187[(7)]);
var inst_32882 = (state_33187[(15)]);
var inst_32892 = (state_33187[(8)]);
var inst_32880 = (state_33187[(14)]);
var inst_33054 = (state_33187[(2)]);
var inst_33055 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_32892,fuel,max_fuel,inst_32890,inst_33054,inst_32880,inst_32882);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(87),inst_33055);
} else {
if((state_val_33188 === (20))){
var inst_32924 = (state_33187[(2)]);
var inst_32925 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32924,(0),null);
var inst_32926 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32924,(1),null);
var inst_32927 = typeof where === 'string';
var state_33187__$1 = (function (){var statearr_33200 = state_33187;
(statearr_33200[(16)] = inst_32925);

(statearr_33200[(17)] = inst_32926);

return statearr_33200;
})();
if(cljs.core.truth_(inst_32927)){
var statearr_33201_33394 = state_33187__$1;
(statearr_33201_33394[(1)] = (30));

} else {
var statearr_33202_33395 = state_33187__$1;
(statearr_33202_33395[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (72))){
var inst_32879 = (state_33187[(18)]);
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_32879)){
var statearr_33203_33396 = state_33187__$1;
(statearr_33203_33396[(1)] = (75));

} else {
var statearr_33204_33397 = state_33187__$1;
(statearr_33204_33397[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (58))){
var inst_32980 = (state_33187[(2)]);
var inst_32981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32982 = [from];
var inst_32983 = (new cljs.core.PersistentVector(null,1,(5),inst_32981,inst_32982,null));
var inst_32984 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_32983,inst_32980);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(59),inst_32984);
} else {
if((state_val_33188 === (60))){
var inst_32991 = (state_33187[(2)]);
var inst_32992 = fluree.db.util.async.throw_err(inst_32991);
var state_33187__$1 = state_33187;
var statearr_33205_33398 = state_33187__$1;
(statearr_33205_33398[(2)] = inst_32992);

(statearr_33205_33398[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (27))){
var inst_32909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32910 = [null,null];
var inst_32911 = (new cljs.core.PersistentVector(null,2,(5),inst_32909,inst_32910,null));
var state_33187__$1 = state_33187;
var statearr_33206_33399 = state_33187__$1;
(statearr_33206_33399[(2)] = inst_32911);

(statearr_33206_33399[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (1))){
var state_33187__$1 = state_33187;
var statearr_33207_33400 = state_33187__$1;
(statearr_33207_33400[(2)] = null);

(statearr_33207_33400[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (69))){
var inst_33011 = (state_33187[(2)]);
var inst_33012 = fluree.db.query.range._block_or_tx_collection(db,inst_33011);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(70),inst_33012);
} else {
if((state_val_33188 === (101))){
var inst_33121 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33208_33401 = state_33187__$1;
(statearr_33208_33401[(2)] = inst_33121);

(statearr_33208_33401[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (24))){
var inst_32879 = (state_33187[(18)]);
var inst_32904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32905 = [inst_32879,"ASC"];
var inst_32906 = (new cljs.core.PersistentVector(null,2,(5),inst_32904,inst_32905,null));
var state_33187__$1 = state_33187;
var statearr_33209_33402 = state_33187__$1;
(statearr_33209_33402[(2)] = inst_32906);

(statearr_33209_33402[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (102))){
var inst_33093 = (state_33187[(19)]);
var state_33187__$1 = state_33187;
var statearr_33210_33403 = state_33187__$1;
(statearr_33210_33403[(2)] = inst_33093);

(statearr_33210_33403[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (55))){
var inst_32879 = (state_33187[(18)]);
var inst_32972 = (state_33187[(2)]);
var state_33187__$1 = (function (){var statearr_33211 = state_33187;
(statearr_33211[(13)] = inst_32972);

return statearr_33211;
})();
if(cljs.core.truth_(inst_32879)){
var statearr_33212_33404 = state_33187__$1;
(statearr_33212_33404[(1)] = (56));

} else {
var statearr_33213_33405 = state_33187__$1;
(statearr_33213_33405[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (85))){
var inst_33046 = (state_33187[(20)]);
var inst_33050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33051 = [inst_33046];
var inst_33052 = (new cljs.core.PersistentVector(null,1,(5),inst_33050,inst_33051,null));
var state_33187__$1 = state_33187;
var statearr_33214_33406 = state_33187__$1;
(statearr_33214_33406[(2)] = inst_33052);

(statearr_33214_33406[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (39))){
var inst_32880 = (state_33187[(14)]);
var state_33187__$1 = state_33187;
var statearr_33215_33407 = state_33187__$1;
(statearr_33215_33407[(2)] = inst_32880);

(statearr_33215_33407[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (88))){
var inst_33060 = cljs.core._deref(fuel);
var inst_33061 = (inst_33060 + (1));
var inst_33062 = cljs.core._vreset_BANG_(fuel,inst_33061);
var state_33187__$1 = state_33187;
var statearr_33216_33408 = state_33187__$1;
(statearr_33216_33408[(2)] = inst_33062);

(statearr_33216_33408[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (46))){
var inst_32957 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_32957)){
var statearr_33217_33409 = state_33187__$1;
(statearr_33217_33409[(1)] = (47));

} else {
var statearr_33218_33410 = state_33187__$1;
(statearr_33218_33410[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (4))){
var inst_32847 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33219_33411 = state_33187__$1;
(statearr_33219_33411[(2)] = inst_32847);

(statearr_33219_33411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (77))){
var inst_33030 = (state_33187[(2)]);
var inst_33031 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_33030);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(78),inst_33031);
} else {
if((state_val_33188 === (106))){
var state_33187__$1 = state_33187;
var statearr_33220_33412 = state_33187__$1;
(statearr_33220_33412[(2)] = null);

(statearr_33220_33412[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (119))){
var inst_33140 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_33141 = ["Invalid 'from' in query:",inst_33140].join('');
var inst_33142 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33143 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33144 = cljs.core.PersistentHashMap.fromArrays(inst_33142,inst_33143);
var inst_33145 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33141,inst_33144);
var state_33187__$1 = state_33187;
var statearr_33221_33413 = state_33187__$1;
(statearr_33221_33413[(2)] = inst_33145);

(statearr_33221_33413[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (95))){
var state_33187__$1 = state_33187;
var statearr_33222_33414 = state_33187__$1;
(statearr_33222_33414[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (54))){
var inst_32966 = (state_33187[(21)]);
var state_33187__$1 = state_33187;
var statearr_33224_33415 = state_33187__$1;
(statearr_33224_33415[(2)] = inst_32966);

(statearr_33224_33415[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (92))){
var inst_33067 = (state_33187[(22)]);
var state_33187__$1 = state_33187;
var statearr_33225_33416 = state_33187__$1;
(statearr_33225_33416[(2)] = inst_33067);

(statearr_33225_33416[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (104))){
var inst_33113 = (state_33187[(23)]);
var inst_33113__$1 = (state_33187[(2)]);
var state_33187__$1 = (function (){var statearr_33226 = state_33187;
(statearr_33226[(23)] = inst_33113__$1);

return statearr_33226;
})();
if(cljs.core.truth_(inst_33113__$1)){
var statearr_33227_33417 = state_33187__$1;
(statearr_33227_33417[(1)] = (109));

} else {
var statearr_33228_33418 = state_33187__$1;
(statearr_33228_33418[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (15))){
var inst_32881 = (state_33187[(24)]);
var inst_32883 = (state_33187[(25)]);
var inst_32887 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32883,cljs.core.cst$kw$componentFollow_QMARK_,inst_32881);
var state_33187__$1 = state_33187;
var statearr_33229_33419 = state_33187__$1;
(statearr_33229_33419[(2)] = inst_32887);

(statearr_33229_33419[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (48))){
var inst_32994 = (state_33187[(9)]);
var inst_32994__$1 = typeof from === 'string';
var state_33187__$1 = (function (){var statearr_33230 = state_33187;
(statearr_33230[(9)] = inst_32994__$1);

return statearr_33230;
})();
if(cljs.core.truth_(inst_32994__$1)){
var statearr_33231_33420 = state_33187__$1;
(statearr_33231_33420[(1)] = (61));

} else {
var statearr_33232_33421 = state_33187__$1;
(statearr_33232_33421[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (50))){
var inst_32960 = (state_33187[(26)]);
var inst_32962 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_32963 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_32960,inst_32962);
var state_33187__$1 = state_33187;
var statearr_33233_33422 = state_33187__$1;
(statearr_33233_33422[(2)] = inst_32963);

(statearr_33233_33422[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (116))){
var state_33187__$1 = state_33187;
var statearr_33234_33423 = state_33187__$1;
(statearr_33234_33423[(2)] = null);

(statearr_33234_33423[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (75))){
var inst_33024 = cljs.core.PersistentHashMap.EMPTY;
var state_33187__$1 = state_33187;
var statearr_33235_33424 = state_33187__$1;
(statearr_33235_33424[(2)] = inst_33024);

(statearr_33235_33424[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (99))){
var inst_33087 = (state_33187[(10)]);
var state_33187__$1 = state_33187;
var statearr_33236_33425 = state_33187__$1;
(statearr_33236_33425[(2)] = inst_33087);

(statearr_33236_33425[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (21))){
var inst_32879 = (state_33187[(18)]);
var inst_32896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32897 = cljs.core.second(inst_32879);
var inst_32898 = cljs.core.first(inst_32879);
var inst_32899 = [inst_32897,inst_32898];
var inst_32900 = (new cljs.core.PersistentVector(null,2,(5),inst_32896,inst_32899,null));
var state_33187__$1 = state_33187;
var statearr_33237_33426 = state_33187__$1;
(statearr_33237_33426[(2)] = inst_32900);

(statearr_33237_33426[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (31))){
var inst_32951 = (state_33187[(27)]);
var inst_32951__$1 = typeof from === 'string';
var state_33187__$1 = (function (){var statearr_33238 = state_33187;
(statearr_33238[(27)] = inst_32951__$1);

return statearr_33238;
})();
if(cljs.core.truth_(inst_32951__$1)){
var statearr_33239_33427 = state_33187__$1;
(statearr_33239_33427[(1)] = (44));

} else {
var statearr_33240_33428 = state_33187__$1;
(statearr_33240_33428[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (113))){
var state_33187__$1 = state_33187;
var statearr_33241_33429 = state_33187__$1;
(statearr_33241_33429[(2)] = null);

(statearr_33241_33429[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (32))){
var inst_32925 = (state_33187[(16)]);
var inst_33160 = (state_33187[(2)]);
var state_33187__$1 = (function (){var statearr_33242 = state_33187;
(statearr_33242[(28)] = inst_33160);

return statearr_33242;
})();
if(cljs.core.truth_(inst_32925)){
var statearr_33243_33430 = state_33187__$1;
(statearr_33243_33430[(1)] = (122));

} else {
var statearr_33244_33431 = state_33187__$1;
(statearr_33244_33431[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (40))){
var inst_32879 = (state_33187[(18)]);
var inst_32941 = (state_33187[(2)]);
var state_33187__$1 = (function (){var statearr_33245 = state_33187;
(statearr_33245[(29)] = inst_32941);

return statearr_33245;
})();
if(cljs.core.truth_(inst_32879)){
var statearr_33246_33432 = state_33187__$1;
(statearr_33246_33432[(1)] = (41));

} else {
var statearr_33247_33433 = state_33187__$1;
(statearr_33247_33433[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (129))){
var inst_33168 = (state_33187[(30)]);
var state_33187__$1 = state_33187;
var statearr_33248_33434 = state_33187__$1;
(statearr_33248_33434[(2)] = inst_33168);

(statearr_33248_33434[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (91))){
var inst_33069 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_33187__$1 = state_33187;
var statearr_33249_33435 = state_33187__$1;
(statearr_33249_33435[(2)] = inst_33069);

(statearr_33249_33435[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (117))){
var inst_32882 = (state_33187[(15)]);
var state_33187__$1 = state_33187;
var statearr_33250_33436 = state_33187__$1;
(statearr_33250_33436[(2)] = inst_32882);

(statearr_33250_33436[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (108))){
var inst_33110 = (state_33187[(2)]);
var inst_33111 = fluree.db.util.async.throw_err(inst_33110);
var state_33187__$1 = state_33187;
var statearr_33251_33437 = state_33187__$1;
(statearr_33251_33437[(2)] = inst_33111);

(statearr_33251_33437[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (56))){
var inst_32974 = cljs.core.PersistentHashMap.EMPTY;
var state_33187__$1 = state_33187;
var statearr_33252_33438 = state_33187__$1;
(statearr_33252_33438[(2)] = inst_32974);

(statearr_33252_33438[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (33))){
var state_33187__$1 = state_33187;
var statearr_33253_33439 = state_33187__$1;
(statearr_33253_33439[(2)] = from);

(statearr_33253_33439[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (13))){
var inst_32866 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32867 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_32868 = cljs.core.PersistentHashMap.fromArrays(inst_32866,inst_32867);
var inst_32869 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_32868);
var inst_32870 = (function(){throw inst_32869})();
var state_33187__$1 = state_33187;
var statearr_33254_33440 = state_33187__$1;
(statearr_33254_33440[(2)] = inst_32870);

(statearr_33254_33440[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (22))){
var inst_32879 = (state_33187[(18)]);
var inst_32902 = typeof inst_32879 === 'string';
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_32902)){
var statearr_33255_33441 = state_33187__$1;
(statearr_33255_33441[(1)] = (24));

} else {
var statearr_33256_33442 = state_33187__$1;
(statearr_33256_33442[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (90))){
var inst_33058 = (state_33187[(31)]);
var inst_33065 = (state_33187[(2)]);
var state_33187__$1 = (function (){var statearr_33257 = state_33187;
(statearr_33257[(32)] = inst_33065);

return statearr_33257;
})();
var statearr_33258_33443 = state_33187__$1;
(statearr_33258_33443[(2)] = inst_33058);

(statearr_33258_33443[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (109))){
var inst_33087 = (state_33187[(10)]);
var inst_33113 = (state_33187[(23)]);
var inst_33115 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33087,inst_33113);
var state_33187__$1 = state_33187;
var statearr_33259_33444 = state_33187__$1;
(statearr_33259_33444[(2)] = inst_33115);

(statearr_33259_33444[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (36))){
var inst_32879 = (state_33187[(18)]);
var inst_32936 = (state_33187[(2)]);
var inst_32937 = fluree.db.util.async.throw_err(inst_32936);
var state_33187__$1 = (function (){var statearr_33260 = state_33187;
(statearr_33260[(33)] = inst_32937);

return statearr_33260;
})();
if(cljs.core.truth_(inst_32879)){
var statearr_33261_33445 = state_33187__$1;
(statearr_33261_33445[(1)] = (38));

} else {
var statearr_33262_33446 = state_33187__$1;
(statearr_33262_33446[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (41))){
var state_33187__$1 = state_33187;
var statearr_33263_33447 = state_33187__$1;
(statearr_33263_33447[(2)] = null);

(statearr_33263_33447[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (118))){
var inst_32890 = (state_33187[(7)]);
var inst_32892 = (state_33187[(8)]);
var inst_33125 = (state_33187[(34)]);
var inst_33129 = (state_33187[(35)]);
var inst_33133 = (state_33187[(2)]);
var inst_33134 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_32892,fuel,max_fuel,inst_32890,inst_33125,inst_33129,inst_33133);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(112),inst_33134);
} else {
if((state_val_33188 === (89))){
var state_33187__$1 = state_33187;
var statearr_33264_33448 = state_33187__$1;
(statearr_33264_33448[(2)] = null);

(statearr_33264_33448[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (100))){
var inst_33093 = (state_33187[(19)]);
var inst_33098 = cljs.core.int_QMARK_(inst_33093);
var state_33187__$1 = state_33187;
if(inst_33098){
var statearr_33265_33449 = state_33187__$1;
(statearr_33265_33449[(1)] = (102));

} else {
var statearr_33266_33450 = state_33187__$1;
(statearr_33266_33450[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (131))){
var inst_33165 = (state_33187[(11)]);
var inst_33179 = cljs.core.first(inst_33165);
var state_33187__$1 = state_33187;
var statearr_33267_33451 = state_33187__$1;
(statearr_33267_33451[(2)] = inst_33179);

(statearr_33267_33451[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (122))){
var inst_32882 = (state_33187[(15)]);
var inst_32925 = (state_33187[(16)]);
var inst_32926 = (state_33187[(17)]);
var inst_33160 = (state_33187[(28)]);
var inst_32880 = (state_33187[(14)]);
var inst_33162 = fluree.db.query.fql.sort_offset_and_limit_res(inst_32925,inst_32926,inst_32882,inst_32880,inst_33160);
var state_33187__$1 = state_33187;
var statearr_33268_33452 = state_33187__$1;
(statearr_33268_33452[(2)] = inst_33162);

(statearr_33268_33452[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (43))){
var inst_32941 = (state_33187[(29)]);
var inst_32890 = (state_33187[(7)]);
var inst_32892 = (state_33187[(8)]);
var inst_32937 = (state_33187[(33)]);
var inst_32945 = (state_33187[(2)]);
var inst_32946 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_32892,fuel,max_fuel,inst_32890,inst_32937,inst_32941,inst_32945);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(37),inst_32946);
} else {
if((state_val_33188 === (61))){
var inst_32996 = ["_tx",null,"_block",null];
var inst_32997 = (new cljs.core.PersistentArrayMap(null,2,inst_32996,null));
var inst_32998 = (new cljs.core.PersistentHashSet(null,inst_32997,null));
var inst_32999 = (inst_32998.cljs$core$IFn$_invoke$arity$1 ? inst_32998.cljs$core$IFn$_invoke$arity$1(from) : inst_32998.call(null,from));
var state_33187__$1 = state_33187;
var statearr_33269_33453 = state_33187__$1;
(statearr_33269_33453[(2)] = inst_32999);

(statearr_33269_33453[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (29))){
var inst_32914 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33270_33454 = state_33187__$1;
(statearr_33270_33454[(2)] = inst_32914);

(statearr_33270_33454[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (44))){
var inst_32953 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_32954 = clojure.string.includes_QMARK_(inst_32953,"/");
var state_33187__$1 = state_33187;
var statearr_33271_33455 = state_33187__$1;
(statearr_33271_33455[(2)] = inst_32954);

(statearr_33271_33455[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (93))){
var inst_33072 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_33072)){
var statearr_33272_33456 = state_33187__$1;
(statearr_33272_33456[(1)] = (94));

} else {
var statearr_33273_33457 = state_33187__$1;
(statearr_33273_33457[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (6))){
var inst_32857 = (state_33187[(36)]);
var state_33187__$1 = state_33187;
var statearr_33274_33458 = state_33187__$1;
(statearr_33274_33458[(2)] = inst_32857);

(statearr_33274_33458[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (111))){
var inst_33094 = (state_33187[(37)]);
var inst_33118 = (state_33187[(2)]);
var inst_33086 = inst_33094;
var inst_33087 = inst_33118;
var state_33187__$1 = (function (){var statearr_33275 = state_33187;
(statearr_33275[(38)] = inst_33086);

(statearr_33275[(10)] = inst_33087);

return statearr_33275;
})();
var statearr_33276_33459 = state_33187__$1;
(statearr_33276_33459[(2)] = null);

(statearr_33276_33459[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (28))){
var state_33187__$1 = state_33187;
var statearr_33277_33460 = state_33187__$1;
(statearr_33277_33460[(2)] = null);

(statearr_33277_33460[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (64))){
var inst_32879 = (state_33187[(18)]);
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_32879)){
var statearr_33278_33461 = state_33187__$1;
(statearr_33278_33461[(1)] = (67));

} else {
var statearr_33279_33462 = state_33187__$1;
(statearr_33279_33462[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (103))){
var state_33187__$1 = state_33187;
if(cljs.core.truth_(fuel)){
var statearr_33280_33463 = state_33187__$1;
(statearr_33280_33463[(1)] = (105));

} else {
var statearr_33281_33464 = state_33187__$1;
(statearr_33281_33464[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (51))){
var inst_32960 = (state_33187[(26)]);
var state_33187__$1 = state_33187;
var statearr_33282_33465 = state_33187__$1;
(statearr_33282_33465[(2)] = inst_32960);

(statearr_33282_33465[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (25))){
var state_33187__$1 = state_33187;
var statearr_33283_33466 = state_33187__$1;
(statearr_33283_33466[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (34))){
var state_33187__$1 = state_33187;
var statearr_33285_33467 = state_33187__$1;
(statearr_33285_33467[(2)] = null);

(statearr_33285_33467[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (125))){
var inst_33165 = (state_33187[(11)]);
var inst_33168 = (state_33187[(30)]);
var inst_33168__$1 = cljs.core.coll_QMARK_(inst_33165);
var state_33187__$1 = (function (){var statearr_33286 = state_33187;
(statearr_33286[(30)] = inst_33168__$1);

return statearr_33286;
})();
if(inst_33168__$1){
var statearr_33287_33468 = state_33187__$1;
(statearr_33287_33468[(1)] = (128));

} else {
var statearr_33288_33469 = state_33187__$1;
(statearr_33288_33469[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (17))){
var inst_32879 = (state_33187[(18)]);
var inst_32890 = (state_33187[(2)]);
var inst_32891 = cljs.core.PersistentHashMap.EMPTY;
var inst_32892 = cljs.core.volatile_BANG_(inst_32891);
var state_33187__$1 = (function (){var statearr_33289 = state_33187;
(statearr_33289[(7)] = inst_32890);

(statearr_33289[(8)] = inst_32892);

return statearr_33289;
})();
if(cljs.core.truth_(inst_32879)){
var statearr_33290_33470 = state_33187__$1;
(statearr_33290_33470[(1)] = (18));

} else {
var statearr_33291_33471 = state_33187__$1;
(statearr_33291_33471[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (3))){
var inst_33185 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33187__$1,inst_33185);
} else {
if((state_val_33188 === (12))){
var inst_32863 = (state_33187[(39)]);
var state_33187__$1 = state_33187;
var statearr_33292_33472 = state_33187__$1;
(statearr_33292_33472[(2)] = inst_32863);

(statearr_33292_33472[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (2))){
var inst_32857 = (state_33187[(36)]);
var _ = (function (){var statearr_33293 = state_33187;
(statearr_33293[(4)] = cljs.core.cons((5),(state_33187[(4)])));

return statearr_33293;
})();
var inst_32857__$1 = select;
var state_33187__$1 = (function (){var statearr_33294 = state_33187;
(statearr_33294[(36)] = inst_32857__$1);

return statearr_33294;
})();
if(cljs.core.truth_(inst_32857__$1)){
var statearr_33295_33473 = state_33187__$1;
(statearr_33295_33473[(1)] = (6));

} else {
var statearr_33296_33474 = state_33187__$1;
(statearr_33296_33474[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (66))){
var inst_33156 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33297_33475 = state_33187__$1;
(statearr_33297_33475[(2)] = inst_33156);

(statearr_33297_33475[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (107))){
var inst_33093 = (state_33187[(19)]);
var inst_33107 = (state_33187[(2)]);
var inst_33108 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_33093,false);
var state_33187__$1 = (function (){var statearr_33298 = state_33187;
(statearr_33298[(40)] = inst_33107);

return statearr_33298;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(108),inst_33108);
} else {
if((state_val_33188 === (23))){
var inst_32918 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33299_33476 = state_33187__$1;
(statearr_33299_33476[(2)] = inst_32918);

(statearr_33299_33476[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (47))){
var inst_32960 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_33187__$1 = (function (){var statearr_33300 = state_33187;
(statearr_33300[(26)] = inst_32960);

return statearr_33300;
})();
if(cljs.core.truth_(fuel)){
var statearr_33301_33477 = state_33187__$1;
(statearr_33301_33477[(1)] = (50));

} else {
var statearr_33302_33478 = state_33187__$1;
(statearr_33302_33478[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (35))){
var inst_32933 = (state_33187[(2)]);
var inst_32934 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_32933);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(36),inst_32934);
} else {
if((state_val_33188 === (127))){
var inst_33177 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_33177)){
var statearr_33303_33479 = state_33187__$1;
(statearr_33303_33479[(1)] = (131));

} else {
var statearr_33304_33480 = state_33187__$1;
(statearr_33304_33480[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (82))){
var inst_33152 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33305_33481 = state_33187__$1;
(statearr_33305_33481[(2)] = inst_33152);

(statearr_33305_33481[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (76))){
var inst_32882 = (state_33187[(15)]);
var inst_32880 = (state_33187[(14)]);
var inst_33026 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_33027 = [inst_32880,inst_32882];
var inst_33028 = cljs.core.PersistentHashMap.fromArrays(inst_33026,inst_33027);
var state_33187__$1 = state_33187;
var statearr_33306_33482 = state_33187__$1;
(statearr_33306_33482[(2)] = inst_33028);

(statearr_33306_33482[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (97))){
var inst_33086 = (state_33187[(38)]);
var inst_33093 = (state_33187[(19)]);
var inst_33092 = cljs.core.seq(inst_33086);
var inst_33093__$1 = cljs.core.first(inst_33092);
var inst_33094 = cljs.core.next(inst_33092);
var inst_33095 = cljs.core.not(inst_33093__$1);
var state_33187__$1 = (function (){var statearr_33307 = state_33187;
(statearr_33307[(19)] = inst_33093__$1);

(statearr_33307[(37)] = inst_33094);

return statearr_33307;
})();
if(inst_33095){
var statearr_33308_33483 = state_33187__$1;
(statearr_33308_33483[(1)] = (99));

} else {
var statearr_33309_33484 = state_33187__$1;
(statearr_33309_33484[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (19))){
var inst_32920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32921 = [null,null];
var inst_32922 = (new cljs.core.PersistentVector(null,2,(5),inst_32920,inst_32921,null));
var state_33187__$1 = state_33187;
var statearr_33310_33485 = state_33187__$1;
(statearr_33310_33485[(2)] = inst_32922);

(statearr_33310_33485[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (57))){
var inst_32882 = (state_33187[(15)]);
var inst_32880 = (state_33187[(14)]);
var inst_32976 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_32977 = [inst_32880,inst_32882];
var inst_32978 = cljs.core.PersistentHashMap.fromArrays(inst_32976,inst_32977);
var state_33187__$1 = state_33187;
var statearr_33311_33486 = state_33187__$1;
(statearr_33311_33486[(2)] = inst_32978);

(statearr_33311_33486[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (68))){
var inst_32882 = (state_33187[(15)]);
var inst_32880 = (state_33187[(14)]);
var inst_33007 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_33008 = [inst_32880,inst_32882];
var inst_33009 = cljs.core.PersistentHashMap.fromArrays(inst_33007,inst_33008);
var state_33187__$1 = state_33187;
var statearr_33312_33487 = state_33187__$1;
(statearr_33312_33487[(2)] = inst_33009);

(statearr_33312_33487[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (11))){
var inst_32874 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33313_33488 = state_33187__$1;
(statearr_33313_33488[(2)] = inst_32874);

(statearr_33313_33488[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (115))){
var inst_32879 = (state_33187[(18)]);
var inst_33129 = (state_33187[(2)]);
var state_33187__$1 = (function (){var statearr_33315 = state_33187;
(statearr_33315[(35)] = inst_33129);

return statearr_33315;
})();
if(cljs.core.truth_(inst_32879)){
var statearr_33316_33489 = state_33187__$1;
(statearr_33316_33489[(1)] = (116));

} else {
var statearr_33317_33490 = state_33187__$1;
(statearr_33317_33490[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (9))){
var inst_32860 = (state_33187[(12)]);
var state_33187__$1 = state_33187;
var statearr_33318_33491 = state_33187__$1;
(statearr_33318_33491[(2)] = inst_32860);

(statearr_33318_33491[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (5))){
var _ = (function (){var statearr_33319 = state_33187;
(statearr_33319[(4)] = cljs.core.rest((state_33187[(4)])));

return statearr_33319;
})();
var state_33187__$1 = state_33187;
var ex33314 = (state_33187__$1[(2)]);
var statearr_33320_33492 = state_33187__$1;
(statearr_33320_33492[(5)] = ex33314);


if((ex33314 instanceof Error)){
var statearr_33321_33493 = state_33187__$1;
(statearr_33321_33493[(1)] = (4));

(statearr_33321_33493[(5)] = null);

} else {
throw ex33314;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (112))){
var inst_33136 = (state_33187[(2)]);
var inst_33137 = fluree.db.util.async.throw_err(inst_33136);
var state_33187__$1 = state_33187;
var statearr_33322_33494 = state_33187__$1;
(statearr_33322_33494[(2)] = inst_33137);

(statearr_33322_33494[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (83))){
var inst_33046 = (state_33187[(20)]);
var inst_33045 = (state_33187[(2)]);
var inst_33046__$1 = fluree.db.util.async.throw_err(inst_33045);
var inst_33047 = (inst_33046__$1 == null);
var state_33187__$1 = (function (){var statearr_33323 = state_33187;
(statearr_33323[(20)] = inst_33046__$1);

return statearr_33323;
})();
if(cljs.core.truth_(inst_33047)){
var statearr_33324_33495 = state_33187__$1;
(statearr_33324_33495[(1)] = (84));

} else {
var statearr_33325_33496 = state_33187__$1;
(statearr_33325_33496[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (14))){
var inst_32872 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33326_33497 = state_33187__$1;
(statearr_33326_33497[(2)] = inst_32872);

(statearr_33326_33497[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (45))){
var inst_32951 = (state_33187[(27)]);
var state_33187__$1 = state_33187;
var statearr_33327_33498 = state_33187__$1;
(statearr_33327_33498[(2)] = inst_32951);

(statearr_33327_33498[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (53))){
var inst_32966 = (state_33187[(21)]);
var inst_32968 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_32969 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_32966,inst_32968);
var state_33187__$1 = state_33187;
var statearr_33328_33499 = state_33187__$1;
(statearr_33328_33499[(2)] = inst_32969);

(statearr_33328_33499[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (78))){
var inst_32890 = (state_33187[(7)]);
var inst_32892 = (state_33187[(8)]);
var inst_33033 = (state_33187[(2)]);
var inst_33034 = fluree.db.util.async.throw_err(inst_33033);
var inst_33035 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_32892,fuel,max_fuel,inst_32890,inst_33034);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(79),inst_33035);
} else {
if((state_val_33188 === (132))){
var inst_33165 = (state_33187[(11)]);
var state_33187__$1 = state_33187;
var statearr_33329_33500 = state_33187__$1;
(statearr_33329_33500[(2)] = inst_33165);

(statearr_33329_33500[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (26))){
var inst_32916 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33330_33501 = state_33187__$1;
(statearr_33330_33501[(2)] = inst_32916);

(statearr_33330_33501[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (123))){
var inst_33160 = (state_33187[(28)]);
var state_33187__$1 = state_33187;
var statearr_33331_33502 = state_33187__$1;
(statearr_33331_33502[(2)] = inst_33160);

(statearr_33331_33502[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (16))){
var inst_32883 = (state_33187[(25)]);
var state_33187__$1 = state_33187;
var statearr_33332_33503 = state_33187__$1;
(statearr_33332_33503[(2)] = inst_32883);

(statearr_33332_33503[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (133))){
var inst_33182 = (state_33187[(2)]);
var _ = (function (){var statearr_33333 = state_33187;
(statearr_33333[(4)] = cljs.core.rest((state_33187[(4)])));

return statearr_33333;
})();
var state_33187__$1 = state_33187;
var statearr_33334_33504 = state_33187__$1;
(statearr_33334_33504[(2)] = inst_33182);

(statearr_33334_33504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (81))){
var inst_33067 = (state_33187[(22)]);
var inst_33067__$1 = cljs.core.sequential_QMARK_(from);
var state_33187__$1 = (function (){var statearr_33335 = state_33187;
(statearr_33335[(22)] = inst_33067__$1);

return statearr_33335;
})();
if(inst_33067__$1){
var statearr_33336_33505 = state_33187__$1;
(statearr_33336_33505[(1)] = (91));

} else {
var statearr_33337_33506 = state_33187__$1;
(statearr_33337_33506[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (120))){
var state_33187__$1 = state_33187;
var statearr_33338_33507 = state_33187__$1;
(statearr_33338_33507[(2)] = null);

(statearr_33338_33507[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (79))){
var inst_33037 = (state_33187[(2)]);
var inst_33038 = fluree.db.util.async.throw_err(inst_33037);
var state_33187__$1 = state_33187;
var statearr_33339_33508 = state_33187__$1;
(statearr_33339_33508[(2)] = inst_33038);

(statearr_33339_33508[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (38))){
var state_33187__$1 = state_33187;
var statearr_33340_33509 = state_33187__$1;
(statearr_33340_33509[(2)] = null);

(statearr_33340_33509[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (126))){
var inst_33166 = (state_33187[(41)]);
var state_33187__$1 = state_33187;
var statearr_33341_33510 = state_33187__$1;
(statearr_33341_33510[(2)] = inst_33166);

(statearr_33341_33510[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (98))){
var inst_32879 = (state_33187[(18)]);
var inst_33123 = (state_33187[(2)]);
var inst_33124 = cljs.core.PersistentVector.EMPTY;
var inst_33125 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33124,inst_33123);
var state_33187__$1 = (function (){var statearr_33342 = state_33187;
(statearr_33342[(34)] = inst_33125);

return statearr_33342;
})();
if(cljs.core.truth_(inst_32879)){
var statearr_33343_33511 = state_33187__$1;
(statearr_33343_33511[(1)] = (113));

} else {
var statearr_33344_33512 = state_33187__$1;
(statearr_33344_33512[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (124))){
var inst_33166 = (state_33187[(41)]);
var inst_33165 = (state_33187[(2)]);
var inst_33166__$1 = selectOne;
var state_33187__$1 = (function (){var statearr_33345 = state_33187;
(statearr_33345[(11)] = inst_33165);

(statearr_33345[(41)] = inst_33166__$1);

return statearr_33345;
})();
if(cljs.core.truth_(inst_33166__$1)){
var statearr_33346_33513 = state_33187__$1;
(statearr_33346_33513[(1)] = (125));

} else {
var statearr_33347_33514 = state_33187__$1;
(statearr_33347_33514[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (87))){
var inst_33057 = (state_33187[(2)]);
var inst_33058 = fluree.db.util.async.throw_err(inst_33057);
var state_33187__$1 = (function (){var statearr_33348 = state_33187;
(statearr_33348[(31)] = inst_33058);

return statearr_33348;
})();
if(cljs.core.truth_(fuel)){
var statearr_33349_33515 = state_33187__$1;
(statearr_33349_33515[(1)] = (88));

} else {
var statearr_33350_33516 = state_33187__$1;
(statearr_33350_33516[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (30))){
var inst_32929 = typeof from === 'string';
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_32929)){
var statearr_33351_33517 = state_33187__$1;
(statearr_33351_33517[(1)] = (33));

} else {
var statearr_33352_33518 = state_33187__$1;
(statearr_33352_33518[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (73))){
var inst_33040 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_33187__$1 = state_33187;
if(inst_33040){
var statearr_33353_33519 = state_33187__$1;
(statearr_33353_33519[(1)] = (80));

} else {
var statearr_33354_33520 = state_33187__$1;
(statearr_33354_33520[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (96))){
var inst_33150 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33355_33521 = state_33187__$1;
(statearr_33355_33521[(2)] = inst_33150);

(statearr_33355_33521[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (10))){
var inst_32863 = (state_33187[(39)]);
var inst_32863__$1 = selectDistinct;
var state_33187__$1 = (function (){var statearr_33356 = state_33187;
(statearr_33356[(39)] = inst_32863__$1);

return statearr_33356;
})();
if(cljs.core.truth_(inst_32863__$1)){
var statearr_33357_33522 = state_33187__$1;
(statearr_33357_33522[(1)] = (12));

} else {
var statearr_33358_33523 = state_33187__$1;
(statearr_33358_33523[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (18))){
var inst_32879 = (state_33187[(18)]);
var inst_32894 = cljs.core.vector_QMARK_(inst_32879);
var state_33187__$1 = state_33187;
if(inst_32894){
var statearr_33359_33524 = state_33187__$1;
(statearr_33359_33524[(1)] = (21));

} else {
var statearr_33360_33525 = state_33187__$1;
(statearr_33360_33525[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (105))){
var inst_33102 = cljs.core._deref(fuel);
var inst_33103 = (inst_33102 + (1));
var inst_33104 = cljs.core._vreset_BANG_(fuel,inst_33103);
var state_33187__$1 = state_33187;
var statearr_33361_33526 = state_33187__$1;
(statearr_33361_33526[(2)] = inst_33104);

(statearr_33361_33526[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (52))){
var inst_32966 = (state_33187[(2)]);
var state_33187__$1 = (function (){var statearr_33362 = state_33187;
(statearr_33362[(21)] = inst_32966);

return statearr_33362;
})();
var statearr_33363_33527 = state_33187__$1;
(statearr_33363_33527[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (114))){
var inst_32880 = (state_33187[(14)]);
var state_33187__$1 = state_33187;
var statearr_33365_33528 = state_33187__$1;
(statearr_33365_33528[(2)] = inst_32880);

(statearr_33365_33528[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (67))){
var inst_33005 = cljs.core.PersistentHashMap.EMPTY;
var state_33187__$1 = state_33187;
var statearr_33366_33529 = state_33187__$1;
(statearr_33366_33529[(2)] = inst_33005);

(statearr_33366_33529[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (71))){
var inst_33018 = (state_33187[(2)]);
var inst_33019 = fluree.db.util.async.throw_err(inst_33018);
var state_33187__$1 = state_33187;
var statearr_33367_33530 = state_33187__$1;
(statearr_33367_33530[(2)] = inst_33019);

(statearr_33367_33530[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (42))){
var inst_32882 = (state_33187[(15)]);
var state_33187__$1 = state_33187;
var statearr_33368_33531 = state_33187__$1;
(statearr_33368_33531[(2)] = inst_32882);

(statearr_33368_33531[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (80))){
var inst_33043 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_33187__$1 = state_33187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33187__$1,(83),inst_33043);
} else {
if((state_val_33188 === (37))){
var inst_32948 = (state_33187[(2)]);
var inst_32949 = fluree.db.util.async.throw_err(inst_32948);
var state_33187__$1 = state_33187;
var statearr_33369_33532 = state_33187__$1;
(statearr_33369_33532[(2)] = inst_32949);

(statearr_33369_33532[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (63))){
var inst_33002 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
if(cljs.core.truth_(inst_33002)){
var statearr_33370_33533 = state_33187__$1;
(statearr_33370_33533[(1)] = (64));

} else {
var statearr_33371_33534 = state_33187__$1;
(statearr_33371_33534[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (94))){
var inst_33081 = from;
var inst_33082 = cljs.core.seq(inst_33081);
var inst_33083 = cljs.core.first(inst_33082);
var inst_33084 = cljs.core.next(inst_33082);
var inst_33085 = cljs.core.PersistentVector.EMPTY;
var inst_33086 = inst_33081;
var inst_33087 = inst_33085;
var state_33187__$1 = (function (){var statearr_33372 = state_33187;
(statearr_33372[(38)] = inst_33086);

(statearr_33372[(42)] = inst_33083);

(statearr_33372[(10)] = inst_33087);

(statearr_33372[(43)] = inst_33084);

return statearr_33372;
})();
var statearr_33373_33535 = state_33187__$1;
(statearr_33373_33535[(2)] = null);

(statearr_33373_33535[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (8))){
var inst_32881 = (state_33187[(24)]);
var inst_32876 = (state_33187[(2)]);
var inst_32877 = opts_SINGLEQUOTE_;
var inst_32878 = cljs.core.__destructure_map(inst_32877);
var inst_32879 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32878,cljs.core.cst$kw$orderBy);
var inst_32880 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32878,cljs.core.cst$kw$limit);
var inst_32881__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32878,cljs.core.cst$kw$component);
var inst_32882 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32878,cljs.core.cst$kw$offset);
var inst_32883 = fluree.db.query.fql_parser.parse_db(db,inst_32876,opts_SINGLEQUOTE_);
var inst_32884 = (inst_32881__$1 == null);
var inst_32885 = cljs.core.not(inst_32884);
var state_33187__$1 = (function (){var statearr_33374 = state_33187;
(statearr_33374[(15)] = inst_32882);

(statearr_33374[(18)] = inst_32879);

(statearr_33374[(24)] = inst_32881__$1);

(statearr_33374[(25)] = inst_32883);

(statearr_33374[(14)] = inst_32880);

return statearr_33374;
})();
if(inst_32885){
var statearr_33375_33536 = state_33187__$1;
(statearr_33375_33536[(1)] = (15));

} else {
var statearr_33376_33537 = state_33187__$1;
(statearr_33376_33537[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (49))){
var inst_33158 = (state_33187[(2)]);
var state_33187__$1 = state_33187;
var statearr_33377_33538 = state_33187__$1;
(statearr_33377_33538[(2)] = inst_33158);

(statearr_33377_33538[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33188 === (84))){
var state_33187__$1 = state_33187;
var statearr_33378_33539 = state_33187__$1;
(statearr_33378_33539[(2)] = null);

(statearr_33378_33539[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__10841__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__10841__auto____0 = (function (){
var statearr_33379 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33379[(0)] = fluree$db$query$fql$query_$_state_machine__10841__auto__);

(statearr_33379[(1)] = (1));

return statearr_33379;
});
var fluree$db$query$fql$query_$_state_machine__10841__auto____1 = (function (state_33187){
while(true){
var ret_value__10842__auto__ = (function (){try{while(true){
var result__10843__auto__ = switch__10840__auto__(state_33187);
if(cljs.core.keyword_identical_QMARK_(result__10843__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10843__auto__;
}
break;
}
}catch (e33380){var ex__10844__auto__ = e33380;
var statearr_33381_33540 = state_33187;
(statearr_33381_33540[(2)] = ex__10844__auto__);


if(cljs.core.seq((state_33187[(4)]))){
var statearr_33382_33541 = state_33187;
(statearr_33382_33541[(1)] = cljs.core.first((state_33187[(4)])));

} else {
throw ex__10844__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10842__auto__,cljs.core.cst$kw$recur)){
var G__33542 = state_33187;
state_33187 = G__33542;
continue;
} else {
return ret_value__10842__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__10841__auto__ = function(state_33187){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__10841__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__10841__auto____1.call(this,state_33187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__10841__auto____0;
fluree$db$query$fql$query_$_state_machine__10841__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__10841__auto____1;
return fluree$db$query$fql$query_$_state_machine__10841__auto__;
})()
})();
var state__10880__auto__ = (function (){var statearr_33383 = (f__10879__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10879__auto__.cljs$core$IFn$_invoke$arity$0() : f__10879__auto__.call(null));
(statearr_33383[(6)] = c__10878__auto__);

return statearr_33383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10880__auto__);
}));

return c__10878__auto__;
}

});
