// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_25203){
var state_val_25204 = (state_25203[(1)]);
if((state_val_25204 === (1))){
var state_25203__$1 = state_25203;
var statearr_25205_25219 = state_25203__$1;
(statearr_25205_25219[(2)] = null);

(statearr_25205_25219[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25204 === (2))){
var _ = (function (){var statearr_25206 = state_25203;
(statearr_25206[(4)] = cljs.core.cons((5),(state_25203[(4)])));

return statearr_25206;
})();
var inst_25194 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_25203__$1 = state_25203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25203__$1,(6),inst_25194);
} else {
if((state_val_25204 === (3))){
var inst_25201 = (state_25203[(2)]);
var state_25203__$1 = state_25203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25203__$1,inst_25201);
} else {
if((state_val_25204 === (4))){
var inst_25188 = (state_25203[(2)]);
var state_25203__$1 = state_25203;
var statearr_25208_25220 = state_25203__$1;
(statearr_25208_25220[(2)] = inst_25188);

(statearr_25208_25220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25204 === (5))){
var _ = (function (){var statearr_25209 = state_25203;
(statearr_25209[(4)] = cljs.core.rest((state_25203[(4)])));

return statearr_25209;
})();
var state_25203__$1 = state_25203;
var ex25207 = (state_25203__$1[(2)]);
var statearr_25210_25221 = state_25203__$1;
(statearr_25210_25221[(5)] = ex25207);


if((ex25207 instanceof Error)){
var statearr_25211_25222 = state_25203__$1;
(statearr_25211_25222[(1)] = (4));

(statearr_25211_25222[(5)] = null);

} else {
throw ex25207;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25204 === (6))){
var inst_25196 = (state_25203[(2)]);
var inst_25197 = fluree.db.util.async.throw_err(inst_25196);
var inst_25198 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_25197);
var _ = (function (){var statearr_25212 = state_25203;
(statearr_25212[(4)] = cljs.core.rest((state_25203[(4)])));

return statearr_25212;
})();
var state_25203__$1 = state_25203;
var statearr_25213_25223 = state_25203__$1;
(statearr_25213_25223[(2)] = inst_25198);

(statearr_25213_25223[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto____0 = (function (){
var statearr_25214 = [null,null,null,null,null,null,null];
(statearr_25214[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto__);

(statearr_25214[(1)] = (1));

return statearr_25214;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto____1 = (function (state_25203){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_25203);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e25215){var ex__10801__auto__ = e25215;
var statearr_25216_25224 = state_25203;
(statearr_25216_25224[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_25203[(4)]))){
var statearr_25217_25225 = state_25203;
(statearr_25217_25225[(1)] = cljs.core.first((state_25203[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__25226 = state_25203;
state_25203 = G__25226;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto__ = function(state_25203){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto____1.call(this,state_25203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_25218 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_25218[(6)] = c__10835__auto__);

return statearr_25218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_25258){
var state_val_25259 = (state_25258[(1)]);
if((state_val_25259 === (7))){
var inst_25242 = (state_25258[(7)]);
var inst_25244 = cljs.core.empty_QMARK_(inst_25242);
var inst_25245 = (!(inst_25244));
var state_25258__$1 = state_25258;
var statearr_25260_25284 = state_25258__$1;
(statearr_25260_25284[(2)] = inst_25245);

(statearr_25260_25284[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (1))){
var state_25258__$1 = state_25258;
var statearr_25261_25285 = state_25258__$1;
(statearr_25261_25285[(2)] = null);

(statearr_25261_25285[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (4))){
var inst_25228 = (state_25258[(2)]);
var state_25258__$1 = state_25258;
var statearr_25262_25286 = state_25258__$1;
(statearr_25262_25286[(2)] = inst_25228);

(statearr_25262_25286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (6))){
var inst_25242 = (state_25258[(7)]);
var inst_25234 = (state_25258[(8)]);
var inst_25240 = (state_25258[(2)]);
var inst_25241 = fluree.db.util.async.throw_err(inst_25240);
var inst_25242__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_25234,inst_25241);
var state_25258__$1 = (function (){var statearr_25263 = state_25258;
(statearr_25263[(7)] = inst_25242__$1);

return statearr_25263;
})();
if(cljs.core.truth_(inst_25242__$1)){
var statearr_25264_25287 = state_25258__$1;
(statearr_25264_25287[(1)] = (7));

} else {
var statearr_25265_25288 = state_25258__$1;
(statearr_25265_25288[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (3))){
var inst_25256 = (state_25258[(2)]);
var state_25258__$1 = state_25258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25258__$1,inst_25256);
} else {
if((state_val_25259 === (12))){
var inst_25253 = (state_25258[(2)]);
var _ = (function (){var statearr_25266 = state_25258;
(statearr_25266[(4)] = cljs.core.rest((state_25258[(4)])));

return statearr_25266;
})();
var state_25258__$1 = state_25258;
var statearr_25267_25289 = state_25258__$1;
(statearr_25267_25289[(2)] = inst_25253);

(statearr_25267_25289[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (2))){
var _ = (function (){var statearr_25268 = state_25258;
(statearr_25268[(4)] = cljs.core.cons((5),(state_25258[(4)])));

return statearr_25268;
})();
var inst_25234 = (function (){return (function (p1__25227_SHARP_){
return p1__25227_SHARP_.o;
});
})();
var inst_25235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25236 = [pred_id];
var inst_25237 = (new cljs.core.PersistentVector(null,1,(5),inst_25235,inst_25236,null));
var inst_25238 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_25237);
var state_25258__$1 = (function (){var statearr_25269 = state_25258;
(statearr_25269[(8)] = inst_25234);

return statearr_25269;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25258__$1,(6),inst_25238);
} else {
if((state_val_25259 === (11))){
var state_25258__$1 = state_25258;
var statearr_25271_25290 = state_25258__$1;
(statearr_25271_25290[(2)] = true);

(statearr_25271_25290[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (9))){
var inst_25248 = (state_25258[(2)]);
var state_25258__$1 = state_25258;
if(cljs.core.truth_(inst_25248)){
var statearr_25272_25291 = state_25258__$1;
(statearr_25272_25291[(1)] = (10));

} else {
var statearr_25273_25292 = state_25258__$1;
(statearr_25273_25292[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (5))){
var _ = (function (){var statearr_25274 = state_25258;
(statearr_25274[(4)] = cljs.core.rest((state_25258[(4)])));

return statearr_25274;
})();
var state_25258__$1 = state_25258;
var ex25270 = (state_25258__$1[(2)]);
var statearr_25275_25293 = state_25258__$1;
(statearr_25275_25293[(5)] = ex25270);


if((ex25270 instanceof Error)){
var statearr_25276_25294 = state_25258__$1;
(statearr_25276_25294[(1)] = (4));

(statearr_25276_25294[(5)] = null);

} else {
throw ex25270;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (10))){
var inst_25242 = (state_25258[(7)]);
var inst_25250 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_25242);
var state_25258__$1 = state_25258;
var statearr_25277_25295 = state_25258__$1;
(statearr_25277_25295[(2)] = inst_25250);

(statearr_25277_25295[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25259 === (8))){
var inst_25242 = (state_25258[(7)]);
var state_25258__$1 = state_25258;
var statearr_25278_25296 = state_25258__$1;
(statearr_25278_25296[(2)] = inst_25242);

(statearr_25278_25296[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto____0 = (function (){
var statearr_25279 = [null,null,null,null,null,null,null,null,null];
(statearr_25279[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto__);

(statearr_25279[(1)] = (1));

return statearr_25279;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto____1 = (function (state_25258){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_25258);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e25280){var ex__10801__auto__ = e25280;
var statearr_25281_25297 = state_25258;
(statearr_25281_25297[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_25258[(4)]))){
var statearr_25282_25298 = state_25258;
(statearr_25282_25298[(1)] = cljs.core.first((state_25258[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__25299 = state_25258;
state_25258 = G__25299;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto__ = function(state_25258){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto____1.call(this,state_25258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_25283 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_25283[(6)] = c__10835__auto__);

return statearr_25283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_25380){
var state_val_25381 = (state_25380[(1)]);
if((state_val_25381 === (7))){
var state_25380__$1 = state_25380;
var statearr_25382_25420 = state_25380__$1;
(statearr_25382_25420[(2)] = flakes);

(statearr_25382_25420[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (20))){
var inst_25337 = (state_25380[(7)]);
var inst_25370 = (state_25380[(2)]);
var inst_25329 = inst_25337;
var inst_25330 = inst_25370;
var state_25380__$1 = (function (){var statearr_25383 = state_25380;
(statearr_25383[(8)] = inst_25329);

(statearr_25383[(9)] = inst_25330);

return statearr_25383;
})();
var statearr_25384_25421 = state_25380__$1;
(statearr_25384_25421[(2)] = null);

(statearr_25384_25421[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (1))){
var state_25380__$1 = state_25380;
var statearr_25385_25422 = state_25380__$1;
(statearr_25385_25422[(2)] = null);

(statearr_25385_25422[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (4))){
var inst_25302 = (state_25380[(2)]);
var state_25380__$1 = state_25380;
var statearr_25386_25423 = state_25380__$1;
(statearr_25386_25423[(2)] = inst_25302);

(statearr_25386_25423[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (15))){
var inst_25336 = (state_25380[(10)]);
var inst_25354 = inst_25336.o;
var state_25380__$1 = state_25380;
var statearr_25387_25424 = state_25380__$1;
(statearr_25387_25424[(2)] = inst_25354);

(statearr_25387_25424[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (13))){
var inst_25373 = (state_25380[(2)]);
var state_25380__$1 = state_25380;
var statearr_25388_25425 = state_25380__$1;
(statearr_25388_25425[(2)] = inst_25373);

(statearr_25388_25425[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (6))){
var inst_25309 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_25380__$1 = state_25380;
var statearr_25389_25426 = state_25380__$1;
(statearr_25389_25426[(2)] = inst_25309);

(statearr_25389_25426[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (17))){
var inst_25351 = (state_25380[(2)]);
var inst_25352 = fluree.db.util.async.throw_err(inst_25351);
var state_25380__$1 = state_25380;
var statearr_25390_25427 = state_25380__$1;
(statearr_25390_25427[(2)] = inst_25352);

(statearr_25390_25427[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (3))){
var inst_25378 = (state_25380[(2)]);
var state_25380__$1 = state_25380;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25380__$1,inst_25378);
} else {
if((state_val_25381 === (12))){
var inst_25343 = (state_25380[(11)]);
var inst_25336 = (state_25380[(10)]);
var inst_25341 = inst_25336.p;
var inst_25342 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_25341);
var inst_25343__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_25342);
var inst_25344 = inst_25336.op;
var inst_25345 = inst_25344 === false;
var inst_25346 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_25343__$1);
var state_25380__$1 = (function (){var statearr_25391 = state_25380;
(statearr_25391[(11)] = inst_25343__$1);

(statearr_25391[(12)] = inst_25345);

return statearr_25391;
})();
if(inst_25346){
var statearr_25392_25428 = state_25380__$1;
(statearr_25392_25428[(1)] = (14));

} else {
var statearr_25393_25429 = state_25380__$1;
(statearr_25393_25429[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (2))){
var _ = (function (){var statearr_25394 = state_25380;
(statearr_25394[(4)] = cljs.core.cons((5),(state_25380[(4)])));

return statearr_25394;
})();
var state_25380__$1 = state_25380;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_25395_25430 = state_25380__$1;
(statearr_25395_25430[(1)] = (6));

} else {
var statearr_25396_25431 = state_25380__$1;
(statearr_25396_25431[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (19))){
var inst_25343 = (state_25380[(11)]);
var inst_25336 = (state_25380[(10)]);
var inst_25356 = (state_25380[(13)]);
var inst_25330 = (state_25380[(9)]);
var inst_25364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25365 = inst_25336.s;
var inst_25366 = [inst_25365,inst_25343,cljs.core.cst$kw$new];
var inst_25367 = (new cljs.core.PersistentVector(null,3,(5),inst_25364,inst_25366,null));
var inst_25368 = cljs.core.assoc_in(inst_25330,inst_25367,inst_25356);
var state_25380__$1 = state_25380;
var statearr_25397_25432 = state_25380__$1;
(statearr_25397_25432[(2)] = inst_25368);

(statearr_25397_25432[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (11))){
var inst_25330 = (state_25380[(9)]);
var state_25380__$1 = state_25380;
var statearr_25399_25433 = state_25380__$1;
(statearr_25399_25433[(2)] = inst_25330);

(statearr_25399_25433[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (9))){
var inst_25336 = (state_25380[(10)]);
var inst_25329 = (state_25380[(8)]);
var inst_25335 = cljs.core.seq(inst_25329);
var inst_25336__$1 = cljs.core.first(inst_25335);
var inst_25337 = cljs.core.next(inst_25335);
var inst_25338 = cljs.core.not(inst_25336__$1);
var state_25380__$1 = (function (){var statearr_25400 = state_25380;
(statearr_25400[(10)] = inst_25336__$1);

(statearr_25400[(7)] = inst_25337);

return statearr_25400;
})();
if(inst_25338){
var statearr_25401_25434 = state_25380__$1;
(statearr_25401_25434[(1)] = (11));

} else {
var statearr_25402_25435 = state_25380__$1;
(statearr_25402_25435[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (5))){
var _ = (function (){var statearr_25403 = state_25380;
(statearr_25403[(4)] = cljs.core.rest((state_25380[(4)])));

return statearr_25403;
})();
var state_25380__$1 = state_25380;
var ex25398 = (state_25380__$1[(2)]);
var statearr_25404_25436 = state_25380__$1;
(statearr_25404_25436[(5)] = ex25398);


if((ex25398 instanceof Error)){
var statearr_25405_25437 = state_25380__$1;
(statearr_25405_25437[(1)] = (4));

(statearr_25405_25437[(5)] = null);

} else {
throw ex25398;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (14))){
var inst_25336 = (state_25380[(10)]);
var inst_25348 = inst_25336.o;
var inst_25349 = fluree.db.query.schema.convert_type_to_kw(inst_25348,db);
var state_25380__$1 = state_25380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25380__$1,(17),inst_25349);
} else {
if((state_val_25381 === (16))){
var inst_25345 = (state_25380[(12)]);
var inst_25356 = (state_25380[(2)]);
var state_25380__$1 = (function (){var statearr_25406 = state_25380;
(statearr_25406[(13)] = inst_25356);

return statearr_25406;
})();
if(cljs.core.truth_(inst_25345)){
var statearr_25407_25438 = state_25380__$1;
(statearr_25407_25438[(1)] = (18));

} else {
var statearr_25408_25439 = state_25380__$1;
(statearr_25408_25439[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (10))){
var inst_25375 = (state_25380[(2)]);
var _ = (function (){var statearr_25409 = state_25380;
(statearr_25409[(4)] = cljs.core.rest((state_25380[(4)])));

return statearr_25409;
})();
var state_25380__$1 = state_25380;
var statearr_25410_25440 = state_25380__$1;
(statearr_25410_25440[(2)] = inst_25375);

(statearr_25410_25440[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (18))){
var inst_25343 = (state_25380[(11)]);
var inst_25336 = (state_25380[(10)]);
var inst_25356 = (state_25380[(13)]);
var inst_25330 = (state_25380[(9)]);
var inst_25358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25359 = inst_25336.s;
var inst_25360 = [inst_25359,inst_25343,cljs.core.cst$kw$old];
var inst_25361 = (new cljs.core.PersistentVector(null,3,(5),inst_25358,inst_25360,null));
var inst_25362 = cljs.core.assoc_in(inst_25330,inst_25361,inst_25356);
var state_25380__$1 = state_25380;
var statearr_25411_25441 = state_25380__$1;
(statearr_25411_25441[(2)] = inst_25362);

(statearr_25411_25441[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25381 === (8))){
var inst_25312 = (state_25380[(2)]);
var inst_25313 = cljs.core.PersistentHashSet.EMPTY;
var inst_25314 = cljs.core.vals(tempids);
var inst_25315 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25313,inst_25314);
var inst_25316 = (function (){var pred_flakes = inst_25312;
var is_new_QMARK_ = inst_25315;
return (function (p1__25300_SHARP_,p2__25301_SHARP_){
return cljs.core.assoc_in(p1__25300_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__25301_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__25412 = p2__25301_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25412) : is_new_QMARK_.call(null,G__25412));
})()));
});
})();
var inst_25317 = cljs.core.PersistentHashMap.EMPTY;
var inst_25318 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_25316,inst_25317,inst_25312);
var inst_25326 = cljs.core.seq(inst_25312);
var inst_25327 = cljs.core.first(inst_25326);
var inst_25328 = cljs.core.next(inst_25326);
var inst_25329 = inst_25312;
var inst_25330 = inst_25318;
var state_25380__$1 = (function (){var statearr_25413 = state_25380;
(statearr_25413[(8)] = inst_25329);

(statearr_25413[(9)] = inst_25330);

(statearr_25413[(14)] = inst_25327);

(statearr_25413[(15)] = inst_25328);

return statearr_25413;
})();
var statearr_25414_25442 = state_25380__$1;
(statearr_25414_25442[(2)] = null);

(statearr_25414_25442[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto____0 = (function (){
var statearr_25415 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25415[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto__);

(statearr_25415[(1)] = (1));

return statearr_25415;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto____1 = (function (state_25380){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_25380);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e25416){var ex__10801__auto__ = e25416;
var statearr_25417_25443 = state_25380;
(statearr_25417_25443[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_25380[(4)]))){
var statearr_25418_25444 = state_25380;
(statearr_25418_25444[(1)] = cljs.core.first((state_25380[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__25445 = state_25380;
state_25380 = G__25445;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto__ = function(state_25380){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto____1.call(this,state_25380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_25419 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_25419[(6)] = c__10835__auto__);

return statearr_25419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__25447 = arguments.length;
switch (G__25447) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__25450 = arguments.length;
switch (G__25450) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_25762){
var state_val_25763 = (state_25762[(1)]);
if((state_val_25763 === (121))){
var inst_25717 = (state_25762[(7)]);
var state_25762__$1 = state_25762;
var statearr_25764_25957 = state_25762__$1;
(statearr_25764_25957[(2)] = inst_25717);

(statearr_25764_25957[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (65))){
var inst_25616 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25616)){
var statearr_25765_25958 = state_25762__$1;
(statearr_25765_25958[(1)] = (66));

} else {
var statearr_25766_25959 = state_25762__$1;
(statearr_25766_25959[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (70))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25626 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_25627 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_25626,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,3,inst_25626,null));
var inst_25628 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25627,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25627,null));
var inst_25629 = (inst_25628.cljs$core$IFn$_invoke$arity$1 ? inst_25628.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25628.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25629)){
var statearr_25767_25960 = state_25762__$1;
(statearr_25767_25960[(1)] = (72));

} else {
var statearr_25768_25961 = state_25762__$1;
(statearr_25768_25961[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (62))){
var inst_25606 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25769_25962 = state_25762__$1;
(statearr_25769_25962[(2)] = inst_25606);

(statearr_25769_25962[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (74))){
var inst_25712 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25770_25963 = state_25762__$1;
(statearr_25770_25963[(2)] = inst_25712);

(statearr_25770_25963[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (110))){
var inst_25739 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25739)){
var statearr_25771_25964 = state_25762__$1;
(statearr_25771_25964[(1)] = (117));

} else {
var statearr_25772_25965 = state_25762__$1;
(statearr_25772_25965[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (7))){
var inst_25757 = (state_25762[(2)]);
var _ = (function (){var statearr_25773 = state_25762;
(statearr_25773[(4)] = cljs.core.rest((state_25762[(4)])));

return statearr_25773;
})();
var state_25762__$1 = state_25762;
var statearr_25774_25966 = state_25762__$1;
(statearr_25774_25966[(2)] = inst_25757);

(statearr_25774_25966[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (59))){
var inst_25490 = (state_25762[(10)]);
var inst_25610 = (state_25762[(11)]);
var inst_25609 = (state_25762[(2)]);
var inst_25610__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_25490);
var state_25762__$1 = (function (){var statearr_25775 = state_25762;
(statearr_25775[(12)] = inst_25609);

(statearr_25775[(11)] = inst_25610__$1);

return statearr_25775;
})();
if(cljs.core.truth_(inst_25610__$1)){
var statearr_25776_25967 = state_25762__$1;
(statearr_25776_25967[(1)] = (63));

} else {
var statearr_25777_25968 = state_25762__$1;
(statearr_25777_25968[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (86))){
var inst_25652 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25778_25969 = state_25762__$1;
(statearr_25778_25969[(2)] = inst_25652);

(statearr_25778_25969[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (20))){
var inst_25516 = (state_25762[(13)]);
var inst_25490 = (state_25762[(10)]);
var inst_25516__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_25490);
var state_25762__$1 = (function (){var statearr_25779 = state_25762;
(statearr_25779[(13)] = inst_25516__$1);

return statearr_25779;
})();
if(cljs.core.truth_(inst_25516__$1)){
var statearr_25780_25970 = state_25762__$1;
(statearr_25780_25970[(1)] = (23));

} else {
var statearr_25781_25971 = state_25762__$1;
(statearr_25781_25971[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (72))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25631 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25782_25972 = state_25762__$1;
(statearr_25782_25972[(2)] = inst_25631);

(statearr_25782_25972[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (58))){
var inst_25571 = (state_25762[(14)]);
var state_25762__$1 = state_25762;
var statearr_25783_25973 = state_25762__$1;
(statearr_25783_25973[(2)] = inst_25571);

(statearr_25783_25973[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (60))){
var inst_25478 = (state_25762[(15)]);
var inst_25489 = (state_25762[(16)]);
var inst_25597 = fluree.db.dbproto._p_prop(inst_25478,cljs.core.cst$kw$name,inst_25489);
var inst_25598 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25597)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_25599 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_25600 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_25601 = cljs.core.PersistentHashMap.fromArrays(inst_25599,inst_25600);
var inst_25602 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25598,inst_25601);
var inst_25603 = (function(){throw inst_25602})();
var state_25762__$1 = state_25762;
var statearr_25784_25974 = state_25762__$1;
(statearr_25784_25974[(2)] = inst_25603);

(statearr_25784_25974[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (27))){
var inst_25519 = (state_25762[(17)]);
var state_25762__$1 = state_25762;
var statearr_25785_25975 = state_25762__$1;
(statearr_25785_25975[(2)] = inst_25519);

(statearr_25785_25975[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (1))){
var state_25762__$1 = state_25762;
var statearr_25786_25976 = state_25762__$1;
(statearr_25786_25976[(2)] = null);

(statearr_25786_25976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (69))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25787_25977 = state_25762__$1;
(statearr_25787_25977[(2)] = inst_25609);

(statearr_25787_25977[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (101))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25690 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25788_25978 = state_25762__$1;
(statearr_25788_25978[(2)] = inst_25690);

(statearr_25788_25978[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (24))){
var inst_25516 = (state_25762[(13)]);
var state_25762__$1 = state_25762;
var statearr_25789_25979 = state_25762__$1;
(statearr_25789_25979[(2)] = inst_25516);

(statearr_25789_25979[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (102))){
var inst_25692 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25790_25980 = state_25762__$1;
(statearr_25790_25980[(2)] = inst_25692);

(statearr_25790_25980[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (55))){
var inst_25588 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25791_25981 = state_25762__$1;
(statearr_25791_25981[(2)] = inst_25588);

(statearr_25791_25981[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (85))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25650 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25792_25982 = state_25762__$1;
(statearr_25792_25982[(2)] = inst_25650);

(statearr_25792_25982[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (39))){
var inst_25553 = (state_25762[(18)]);
var state_25762__$1 = state_25762;
var statearr_25793_25983 = state_25762__$1;
(statearr_25793_25983[(2)] = inst_25553);

(statearr_25793_25983[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (88))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25794_25984 = state_25762__$1;
(statearr_25794_25984[(2)] = inst_25609);

(statearr_25794_25984[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (46))){
var inst_25490 = (state_25762[(10)]);
var inst_25572 = (state_25762[(19)]);
var inst_25571 = (state_25762[(2)]);
var inst_25572__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_25490);
var state_25762__$1 = (function (){var statearr_25795 = state_25762;
(statearr_25795[(14)] = inst_25571);

(statearr_25795[(19)] = inst_25572__$1);

return statearr_25795;
})();
if(cljs.core.truth_(inst_25572__$1)){
var statearr_25796_25985 = state_25762__$1;
(statearr_25796_25985[(1)] = (47));

} else {
var statearr_25797_25986 = state_25762__$1;
(statearr_25797_25986[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (4))){
var inst_25451 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25798_25987 = state_25762__$1;
(statearr_25798_25987[(2)] = inst_25451);

(statearr_25798_25987[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (77))){
var inst_25710 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25799_25988 = state_25762__$1;
(statearr_25799_25988[(2)] = inst_25710);

(statearr_25799_25988[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (106))){
var inst_25702 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25800_25989 = state_25762__$1;
(statearr_25800_25989[(2)] = inst_25702);

(statearr_25800_25989[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (119))){
var inst_25488 = (state_25762[(20)]);
var inst_25752 = (state_25762[(2)]);
var inst_25477 = inst_25488;
var inst_25478 = inst_25752;
var state_25762__$1 = (function (){var statearr_25801 = state_25762;
(statearr_25801[(15)] = inst_25478);

(statearr_25801[(21)] = inst_25477);

return statearr_25801;
})();
var statearr_25802_25990 = state_25762__$1;
(statearr_25802_25990[(2)] = null);

(statearr_25802_25990[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (95))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25674 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_25675 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_25674,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,5,inst_25674,null));
var inst_25676 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25675,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25675,null));
var inst_25677 = (inst_25676.cljs$core$IFn$_invoke$arity$1 ? inst_25676.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25676.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25677)){
var statearr_25803_25991 = state_25762__$1;
(statearr_25803_25991[(1)] = (96));

} else {
var statearr_25804_25992 = state_25762__$1;
(statearr_25804_25992[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (54))){
var inst_25579 = (state_25762[(22)]);
var state_25762__$1 = state_25762;
var statearr_25805_25993 = state_25762__$1;
(statearr_25805_25993[(2)] = inst_25579);

(statearr_25805_25993[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (92))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25806_25994 = state_25762__$1;
(statearr_25806_25994[(2)] = inst_25609);

(statearr_25806_25994[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (104))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25807_25995 = state_25762__$1;
(statearr_25807_25995[(2)] = inst_25609);

(statearr_25807_25995[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (15))){
var inst_25498 = (state_25762[(23)]);
var state_25762__$1 = state_25762;
var statearr_25808_25996 = state_25762__$1;
(statearr_25808_25996[(2)] = inst_25498);

(statearr_25808_25996[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (48))){
var inst_25572 = (state_25762[(19)]);
var state_25762__$1 = state_25762;
var statearr_25809_25997 = state_25762__$1;
(statearr_25809_25997[(2)] = inst_25572);

(statearr_25809_25997[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (50))){
var inst_25490 = (state_25762[(10)]);
var inst_25579 = (state_25762[(22)]);
var inst_25577 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25578 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_25577);
var inst_25579__$1 = inst_25578 === true;
var state_25762__$1 = (function (){var statearr_25810 = state_25762;
(statearr_25810[(22)] = inst_25579__$1);

return statearr_25810;
})();
if(cljs.core.truth_(inst_25579__$1)){
var statearr_25811_25998 = state_25762__$1;
(statearr_25811_25998[(1)] = (53));

} else {
var statearr_25812_25999 = state_25762__$1;
(statearr_25812_25999[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (116))){
var inst_25733 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25813_26000 = state_25762__$1;
(statearr_25813_26000[(2)] = inst_25733);

(statearr_25813_26000[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (75))){
var inst_25622 = (state_25762[(8)]);
var state_25762__$1 = state_25762;
var G__25814_26001 = inst_25622;
var G__25814_26002__$1 = (((G__25814_26001 instanceof cljs.core.Keyword))?G__25814_26001.fqn:null);
switch (G__25814_26002__$1) {
case "long":
var statearr_25815_26004 = state_25762__$1;
(statearr_25815_26004[(1)] = (79));


break;
case "bigint":
var statearr_25816_26005 = state_25762__$1;
(statearr_25816_26005[(1)] = (83));


break;
case "double":
var statearr_25817_26006 = state_25762__$1;
(statearr_25817_26006[(1)] = (87));


break;
case "float":
var statearr_25818_26007 = state_25762__$1;
(statearr_25818_26007[(1)] = (91));


break;
case "bigdec":
var statearr_25819_26008 = state_25762__$1;
(statearr_25819_26008[(1)] = (95));


break;
case "string":
var statearr_25820_26009 = state_25762__$1;
(statearr_25820_26009[(1)] = (99));


break;
case "instant":
var statearr_25821_26010 = state_25762__$1;
(statearr_25821_26010[(1)] = (103));


break;
default:
var statearr_25822_26011 = state_25762__$1;
(statearr_25822_26011[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (99))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25684 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_25685 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_25684,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,5,inst_25684,null));
var inst_25686 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25685,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25685,null));
var inst_25687 = (inst_25686.cljs$core$IFn$_invoke$arity$1 ? inst_25686.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25686.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25687)){
var statearr_25823_26012 = state_25762__$1;
(statearr_25823_26012[(1)] = (100));

} else {
var statearr_25824_26013 = state_25762__$1;
(statearr_25824_26013[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (21))){
var inst_25514 = (state_25762[(24)]);
var state_25762__$1 = state_25762;
var statearr_25825_26014 = state_25762__$1;
(statearr_25825_26014[(2)] = inst_25514);

(statearr_25825_26014[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (31))){
var inst_25530 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25826_26015 = state_25762__$1;
(statearr_25826_26015[(2)] = inst_25530);

(statearr_25826_26015[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (113))){
var inst_25736 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25827_26016 = state_25762__$1;
(statearr_25827_26016[(2)] = inst_25736);

(statearr_25827_26016[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (32))){
var state_25762__$1 = state_25762;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_25828_26017 = state_25762__$1;
(statearr_25828_26017[(1)] = (35));

} else {
var statearr_25829_26018 = state_25762__$1;
(statearr_25829_26018[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (40))){
var inst_25566 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25566)){
var statearr_25830_26019 = state_25762__$1;
(statearr_25830_26019[(1)] = (44));

} else {
var statearr_25831_26020 = state_25762__$1;
(statearr_25831_26020[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (91))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25664 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_25665 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_25664,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,3,inst_25664,null));
var inst_25666 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25665,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25665,null));
var inst_25667 = (inst_25666.cljs$core$IFn$_invoke$arity$1 ? inst_25666.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25666.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25667)){
var statearr_25832_26021 = state_25762__$1;
(statearr_25832_26021[(1)] = (92));

} else {
var statearr_25833_26022 = state_25762__$1;
(statearr_25833_26022[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (117))){
var state_25762__$1 = state_25762;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_25834_26023 = state_25762__$1;
(statearr_25834_26023[(1)] = (120));

} else {
var statearr_25835_26024 = state_25762__$1;
(statearr_25835_26024[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (108))){
var inst_25490 = (state_25762[(10)]);
var inst_25721 = (state_25762[(25)]);
var inst_25721__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_25490);
var state_25762__$1 = (function (){var statearr_25836 = state_25762;
(statearr_25836[(25)] = inst_25721__$1);

return statearr_25836;
})();
if(cljs.core.truth_(inst_25721__$1)){
var statearr_25837_26025 = state_25762__$1;
(statearr_25837_26025[(1)] = (111));

} else {
var statearr_25838_26026 = state_25762__$1;
(statearr_25838_26026[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (56))){
var inst_25583 = (state_25762[(2)]);
var inst_25584 = fluree.db.util.async.throw_err(inst_25583);
var inst_25585 = cljs.core.not(inst_25584);
var state_25762__$1 = state_25762;
var statearr_25839_26027 = state_25762__$1;
(statearr_25839_26027[(2)] = inst_25585);

(statearr_25839_26027[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (33))){
var inst_25513 = (state_25762[(26)]);
var state_25762__$1 = state_25762;
var statearr_25840_26028 = state_25762__$1;
(statearr_25840_26028[(2)] = inst_25513);

(statearr_25840_26028[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (13))){
var inst_25508 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25508)){
var statearr_25841_26029 = state_25762__$1;
(statearr_25841_26029[(1)] = (17));

} else {
var statearr_25842_26030 = state_25762__$1;
(statearr_25842_26030[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (22))){
var inst_25539 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25539)){
var statearr_25843_26031 = state_25762__$1;
(statearr_25843_26031[(1)] = (32));

} else {
var statearr_25844_26032 = state_25762__$1;
(statearr_25844_26032[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (90))){
var inst_25662 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25845_26033 = state_25762__$1;
(statearr_25845_26033[(2)] = inst_25662);

(statearr_25845_26033[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (109))){
var inst_25719 = (state_25762[(27)]);
var state_25762__$1 = state_25762;
var statearr_25846_26034 = state_25762__$1;
(statearr_25846_26034[(2)] = inst_25719);

(statearr_25846_26034[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (36))){
var inst_25513 = (state_25762[(26)]);
var state_25762__$1 = state_25762;
var statearr_25847_26035 = state_25762__$1;
(statearr_25847_26035[(2)] = inst_25513);

(statearr_25847_26035[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (41))){
var inst_25490 = (state_25762[(10)]);
var inst_25558 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25559 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_25558);
var inst_25560 = inst_25559 === true;
var state_25762__$1 = state_25762;
var statearr_25848_26036 = state_25762__$1;
(statearr_25848_26036[(2)] = inst_25560);

(statearr_25848_26036[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (118))){
var inst_25717 = (state_25762[(7)]);
var state_25762__$1 = state_25762;
var statearr_25849_26037 = state_25762__$1;
(statearr_25849_26037[(2)] = inst_25717);

(statearr_25849_26037[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (89))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25660 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25850_26038 = state_25762__$1;
(statearr_25850_26038[(2)] = inst_25660);

(statearr_25850_26038[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (100))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25851_26039 = state_25762__$1;
(statearr_25851_26039[(2)] = inst_25609);

(statearr_25851_26039[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (122))){
var inst_25749 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25852_26040 = state_25762__$1;
(statearr_25852_26040[(2)] = inst_25749);

(statearr_25852_26040[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (43))){
var inst_25563 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25853_26041 = state_25762__$1;
(statearr_25853_26041[(2)] = inst_25563);

(statearr_25853_26041[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (61))){
var inst_25571 = (state_25762[(14)]);
var state_25762__$1 = state_25762;
var statearr_25854_26042 = state_25762__$1;
(statearr_25854_26042[(2)] = inst_25571);

(statearr_25854_26042[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (29))){
var inst_25490 = (state_25762[(10)]);
var inst_25525 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25526 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_25525);
var inst_25527 = inst_25526 === true;
var state_25762__$1 = state_25762;
var statearr_25855_26043 = state_25762__$1;
(statearr_25855_26043[(2)] = inst_25527);

(statearr_25855_26043[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (44))){
var inst_25552 = (state_25762[(28)]);
var inst_25568 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_25552,"a component","a non-component",throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25856_26044 = state_25762__$1;
(statearr_25856_26044[(2)] = inst_25568);

(statearr_25856_26044[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (93))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25670 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25857_26045 = state_25762__$1;
(statearr_25857_26045[(2)] = inst_25670);

(statearr_25857_26045[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (6))){
var inst_25477 = (state_25762[(21)]);
var inst_25489 = (state_25762[(16)]);
var inst_25486 = cljs.core.seq(inst_25477);
var inst_25487 = cljs.core.first(inst_25486);
var inst_25488 = cljs.core.next(inst_25486);
var inst_25489__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25487,(0),null);
var inst_25490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25487,(1),null);
var inst_25491 = cljs.core.not(inst_25489__$1);
var state_25762__$1 = (function (){var statearr_25858 = state_25762;
(statearr_25858[(10)] = inst_25490);

(statearr_25858[(16)] = inst_25489__$1);

(statearr_25858[(20)] = inst_25488);

return statearr_25858;
})();
if(inst_25491){
var statearr_25859_26046 = state_25762__$1;
(statearr_25859_26046[(1)] = (8));

} else {
var statearr_25860_26047 = state_25762__$1;
(statearr_25860_26047[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (111))){
var inst_25725 = (state_25762[(29)]);
var inst_25490 = (state_25762[(10)]);
var inst_25723 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25724 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_25723);
var inst_25725__$1 = inst_25724 === true;
var state_25762__$1 = (function (){var statearr_25861 = state_25762;
(statearr_25861[(29)] = inst_25725__$1);

return statearr_25861;
})();
if(cljs.core.truth_(inst_25725__$1)){
var statearr_25862_26048 = state_25762__$1;
(statearr_25862_26048[(1)] = (114));

} else {
var statearr_25863_26049 = state_25762__$1;
(statearr_25863_26049[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (28))){
var inst_25533 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25864_26050 = state_25762__$1;
(statearr_25864_26050[(2)] = inst_25533);

(statearr_25864_26050[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (64))){
var inst_25610 = (state_25762[(11)]);
var state_25762__$1 = state_25762;
var statearr_25865_26051 = state_25762__$1;
(statearr_25865_26051[(2)] = inst_25610);

(statearr_25865_26051[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (103))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25694 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_25695 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_25694,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,2,inst_25694,null));
var inst_25696 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25695,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25695,null));
var inst_25697 = (inst_25696.cljs$core$IFn$_invoke$arity$1 ? inst_25696.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25696.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25697)){
var statearr_25866_26052 = state_25762__$1;
(statearr_25866_26052[(1)] = (104));

} else {
var statearr_25867_26053 = state_25762__$1;
(statearr_25867_26053[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (51))){
var inst_25575 = (state_25762[(30)]);
var state_25762__$1 = state_25762;
var statearr_25868_26054 = state_25762__$1;
(statearr_25868_26054[(2)] = inst_25575);

(statearr_25868_26054[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (25))){
var inst_25536 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25869_26055 = state_25762__$1;
(statearr_25869_26055[(2)] = inst_25536);

(statearr_25869_26055[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (34))){
var inst_25490 = (state_25762[(10)]);
var inst_25553 = (state_25762[(18)]);
var inst_25552 = (state_25762[(2)]);
var inst_25553__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_25490);
var state_25762__$1 = (function (){var statearr_25870 = state_25762;
(statearr_25870[(18)] = inst_25553__$1);

(statearr_25870[(28)] = inst_25552);

return statearr_25870;
})();
if(cljs.core.truth_(inst_25553__$1)){
var statearr_25871_26056 = state_25762__$1;
(statearr_25871_26056[(1)] = (38));

} else {
var statearr_25872_26057 = state_25762__$1;
(statearr_25872_26057[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (17))){
var inst_25478 = (state_25762[(15)]);
var inst_25510 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_25478,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25873_26058 = state_25762__$1;
(statearr_25873_26058[(2)] = inst_25510);

(statearr_25873_26058[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (3))){
var inst_25760 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25762__$1,inst_25760);
} else {
if((state_val_25763 === (12))){
var inst_25494 = (state_25762[(31)]);
var state_25762__$1 = state_25762;
var statearr_25874_26059 = state_25762__$1;
(statearr_25874_26059[(2)] = inst_25494);

(statearr_25874_26059[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (2))){
var _ = (function (){var statearr_25875 = state_25762;
(statearr_25875[(4)] = cljs.core.cons((5),(state_25762[(4)])));

return statearr_25875;
})();
var inst_25470 = pred_changes;
var inst_25471 = cljs.core.seq(inst_25470);
var inst_25472 = cljs.core.first(inst_25471);
var inst_25473 = cljs.core.next(inst_25471);
var inst_25474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25472,(0),null);
var inst_25475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25472,(1),null);
var inst_25476 = db;
var inst_25477 = inst_25470;
var inst_25478 = inst_25476;
var state_25762__$1 = (function (){var statearr_25876 = state_25762;
(statearr_25876[(15)] = inst_25478);

(statearr_25876[(21)] = inst_25477);

(statearr_25876[(32)] = inst_25475);

(statearr_25876[(33)] = inst_25474);

(statearr_25876[(34)] = inst_25473);

return statearr_25876;
})();
var statearr_25877_26060 = state_25762__$1;
(statearr_25877_26060[(2)] = null);

(statearr_25877_26060[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (66))){
var inst_25622 = (state_25762[(8)]);
var inst_25490 = (state_25762[(10)]);
var inst_25621 = (state_25762[(9)]);
var inst_25619 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25620 = cljs.core.__destructure_map(inst_25619);
var inst_25621__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25620,cljs.core.cst$kw$old);
var inst_25622__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25620,cljs.core.cst$kw$new);
var inst_25623 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_25622__$1,inst_25621__$1);
var state_25762__$1 = (function (){var statearr_25878 = state_25762;
(statearr_25878[(8)] = inst_25622__$1);

(statearr_25878[(9)] = inst_25621__$1);

return statearr_25878;
})();
if(inst_25623){
var statearr_25879_26061 = state_25762__$1;
(statearr_25879_26061[(1)] = (69));

} else {
var statearr_25880_26062 = state_25762__$1;
(statearr_25880_26062[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (107))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25704 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25881_26063 = state_25762__$1;
(statearr_25881_26063[(2)] = inst_25704);

(statearr_25881_26063[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (23))){
var inst_25490 = (state_25762[(10)]);
var inst_25519 = (state_25762[(17)]);
var inst_25518 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25519__$1 = inst_25518 === true;
var state_25762__$1 = (function (){var statearr_25882 = state_25762;
(statearr_25882[(17)] = inst_25519__$1);

return statearr_25882;
})();
if(cljs.core.truth_(inst_25519__$1)){
var statearr_25883_26064 = state_25762__$1;
(statearr_25883_26064[(1)] = (26));

} else {
var statearr_25884_26065 = state_25762__$1;
(statearr_25884_26065[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (47))){
var inst_25575 = (state_25762[(30)]);
var inst_25490 = (state_25762[(10)]);
var inst_25574 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25575__$1 = cljs.core.not(inst_25574);
var state_25762__$1 = (function (){var statearr_25885 = state_25762;
(statearr_25885[(30)] = inst_25575__$1);

return statearr_25885;
})();
if(inst_25575__$1){
var statearr_25886_26066 = state_25762__$1;
(statearr_25886_26066[(1)] = (50));

} else {
var statearr_25887_26067 = state_25762__$1;
(statearr_25887_26067[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (35))){
var inst_25542 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_25543 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_25544 = cljs.core.PersistentHashMap.fromArrays(inst_25542,inst_25543);
var inst_25545 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_25544);
var inst_25546 = (function(){throw inst_25545})();
var state_25762__$1 = state_25762;
var statearr_25888_26068 = state_25762__$1;
(statearr_25888_26068[(2)] = inst_25546);

(statearr_25888_26068[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (82))){
var inst_25642 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25889_26069 = state_25762__$1;
(statearr_25889_26069[(2)] = inst_25642);

(statearr_25889_26069[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (76))){
var state_25762__$1 = state_25762;
var statearr_25890_26070 = state_25762__$1;
(statearr_25890_26070[(2)] = null);

(statearr_25890_26070[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (97))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25680 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25891_26071 = state_25762__$1;
(statearr_25891_26071[(2)] = inst_25680);

(statearr_25891_26071[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (19))){
var inst_25490 = (state_25762[(10)]);
var inst_25514 = (state_25762[(24)]);
var inst_25513 = (state_25762[(2)]);
var inst_25514__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_25490);
var state_25762__$1 = (function (){var statearr_25892 = state_25762;
(statearr_25892[(26)] = inst_25513);

(statearr_25892[(24)] = inst_25514__$1);

return statearr_25892;
})();
if(cljs.core.truth_(inst_25514__$1)){
var statearr_25893_26072 = state_25762__$1;
(statearr_25893_26072[(1)] = (20));

} else {
var statearr_25894_26073 = state_25762__$1;
(statearr_25894_26073[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (57))){
var state_25762__$1 = state_25762;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_25895_26074 = state_25762__$1;
(statearr_25895_26074[(1)] = (60));

} else {
var statearr_25896_26075 = state_25762__$1;
(statearr_25896_26075[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (68))){
var inst_25719 = (state_25762[(27)]);
var inst_25490 = (state_25762[(10)]);
var inst_25717 = (state_25762[(2)]);
var inst_25718 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25719__$1 = inst_25718 === true;
var state_25762__$1 = (function (){var statearr_25897 = state_25762;
(statearr_25897[(27)] = inst_25719__$1);

(statearr_25897[(7)] = inst_25717);

return statearr_25897;
})();
if(cljs.core.truth_(inst_25719__$1)){
var statearr_25898_26076 = state_25762__$1;
(statearr_25898_26076[(1)] = (108));

} else {
var statearr_25899_26077 = state_25762__$1;
(statearr_25899_26077[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (11))){
var inst_25490 = (state_25762[(10)]);
var inst_25498 = (state_25762[(23)]);
var inst_25496 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25497 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_25496);
var inst_25498__$1 = inst_25497 === false;
var state_25762__$1 = (function (){var statearr_25900 = state_25762;
(statearr_25900[(23)] = inst_25498__$1);

return statearr_25900;
})();
if(cljs.core.truth_(inst_25498__$1)){
var statearr_25901_26078 = state_25762__$1;
(statearr_25901_26078[(1)] = (14));

} else {
var statearr_25902_26079 = state_25762__$1;
(statearr_25902_26079[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (115))){
var inst_25725 = (state_25762[(29)]);
var state_25762__$1 = state_25762;
var statearr_25904_26080 = state_25762__$1;
(statearr_25904_26080[(2)] = inst_25725);

(statearr_25904_26080[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (9))){
var inst_25494 = (state_25762[(31)]);
var inst_25490 = (state_25762[(10)]);
var inst_25494__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_25490);
var state_25762__$1 = (function (){var statearr_25905 = state_25762;
(statearr_25905[(31)] = inst_25494__$1);

return statearr_25905;
})();
if(cljs.core.truth_(inst_25494__$1)){
var statearr_25906_26081 = state_25762__$1;
(statearr_25906_26081[(1)] = (11));

} else {
var statearr_25907_26082 = state_25762__$1;
(statearr_25907_26082[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (5))){
var _ = (function (){var statearr_25908 = state_25762;
(statearr_25908[(4)] = cljs.core.rest((state_25762[(4)])));

return statearr_25908;
})();
var state_25762__$1 = state_25762;
var ex25903 = (state_25762__$1[(2)]);
var statearr_25909_26083 = state_25762__$1;
(statearr_25909_26083[(5)] = ex25903);


if((ex25903 instanceof Error)){
var statearr_25910_26084 = state_25762__$1;
(statearr_25910_26084[(1)] = (4));

(statearr_25910_26084[(5)] = null);

} else {
throw ex25903;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (112))){
var inst_25721 = (state_25762[(25)]);
var state_25762__$1 = state_25762;
var statearr_25911_26085 = state_25762__$1;
(statearr_25911_26085[(2)] = inst_25721);

(statearr_25911_26085[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (83))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25644 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_25645 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_25644,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,3,inst_25644,null));
var inst_25646 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25645,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25645,null));
var inst_25647 = (inst_25646.cljs$core$IFn$_invoke$arity$1 ? inst_25646.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25646.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25647)){
var statearr_25912_26086 = state_25762__$1;
(statearr_25912_26086[(1)] = (84));

} else {
var statearr_25913_26087 = state_25762__$1;
(statearr_25913_26087[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (14))){
var inst_25490 = (state_25762[(10)]);
var inst_25500 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25501 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_25500);
var inst_25502 = inst_25501 === true;
var state_25762__$1 = state_25762;
var statearr_25914_26088 = state_25762__$1;
(statearr_25914_26088[(2)] = inst_25502);

(statearr_25914_26088[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (45))){
var inst_25552 = (state_25762[(28)]);
var state_25762__$1 = state_25762;
var statearr_25915_26089 = state_25762__$1;
(statearr_25915_26089[(2)] = inst_25552);

(statearr_25915_26089[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (53))){
var inst_25478 = (state_25762[(15)]);
var inst_25489 = (state_25762[(16)]);
var inst_25581 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_25478,inst_25489);
var state_25762__$1 = state_25762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25762__$1,(56),inst_25581);
} else {
if((state_val_25763 === (78))){
var inst_25707 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25916_26090 = state_25762__$1;
(statearr_25916_26090[(2)] = inst_25707);

(statearr_25916_26090[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (26))){
var inst_25523 = (state_25762[(35)]);
var inst_25490 = (state_25762[(10)]);
var inst_25521 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25522 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_25521);
var inst_25523__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_25522);
var state_25762__$1 = (function (){var statearr_25917 = state_25762;
(statearr_25917[(35)] = inst_25523__$1);

return statearr_25917;
})();
if(inst_25523__$1){
var statearr_25918_26091 = state_25762__$1;
(statearr_25918_26091[(1)] = (29));

} else {
var statearr_25919_26092 = state_25762__$1;
(statearr_25919_26092[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (16))){
var inst_25505 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25920_26093 = state_25762__$1;
(statearr_25920_26093[(2)] = inst_25505);

(statearr_25920_26093[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (81))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25640 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25921_26094 = state_25762__$1;
(statearr_25921_26094[(2)] = inst_25640);

(statearr_25921_26094[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (120))){
var inst_25742 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_25743 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_25744 = cljs.core.PersistentHashMap.fromArrays(inst_25742,inst_25743);
var inst_25745 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_25744);
var inst_25746 = (function(){throw inst_25745})();
var state_25762__$1 = state_25762;
var statearr_25922_26095 = state_25762__$1;
(statearr_25922_26095[(2)] = inst_25746);

(statearr_25922_26095[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (79))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25634 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_25635 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_25634,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,2,inst_25634,null));
var inst_25636 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25635,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25635,null));
var inst_25637 = (inst_25636.cljs$core$IFn$_invoke$arity$1 ? inst_25636.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25636.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25637)){
var statearr_25923_26096 = state_25762__$1;
(statearr_25923_26096[(1)] = (80));

} else {
var statearr_25924_26097 = state_25762__$1;
(statearr_25924_26097[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (38))){
var inst_25490 = (state_25762[(10)]);
var inst_25556 = (state_25762[(36)]);
var inst_25555 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25556__$1 = cljs.core.not(inst_25555);
var state_25762__$1 = (function (){var statearr_25925 = state_25762;
(statearr_25925[(36)] = inst_25556__$1);

return statearr_25925;
})();
if(inst_25556__$1){
var statearr_25926_26098 = state_25762__$1;
(statearr_25926_26098[(1)] = (41));

} else {
var statearr_25927_26099 = state_25762__$1;
(statearr_25927_26099[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (98))){
var inst_25682 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25928_26100 = state_25762__$1;
(statearr_25928_26100[(2)] = inst_25682);

(statearr_25928_26100[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (87))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25654 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_25655 = (inst_25622.cljs$core$IFn$_invoke$arity$5 ? inst_25622.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_25654,null) : inst_25622.call(null,cljs.core.PersistentArrayMap,null,3,inst_25654,null));
var inst_25656 = (inst_25622.cljs$core$IFn$_invoke$arity$4 ? inst_25622.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_25655,null) : inst_25622.call(null,cljs.core.PersistentHashSet,null,inst_25655,null));
var inst_25657 = (inst_25656.cljs$core$IFn$_invoke$arity$1 ? inst_25656.cljs$core$IFn$_invoke$arity$1(inst_25621) : inst_25656.call(null,inst_25621));
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25657)){
var statearr_25929_26101 = state_25762__$1;
(statearr_25929_26101[(1)] = (88));

} else {
var statearr_25930_26102 = state_25762__$1;
(statearr_25930_26102[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (30))){
var inst_25523 = (state_25762[(35)]);
var state_25762__$1 = state_25762;
var statearr_25931_26103 = state_25762__$1;
(statearr_25931_26103[(2)] = inst_25523);

(statearr_25931_26103[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (73))){
var state_25762__$1 = state_25762;
var statearr_25932_26104 = state_25762__$1;
(statearr_25932_26104[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (96))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25934_26105 = state_25762__$1;
(statearr_25934_26105[(2)] = inst_25609);

(statearr_25934_26105[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (10))){
var inst_25755 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25935_26106 = state_25762__$1;
(statearr_25935_26106[(2)] = inst_25755);

(statearr_25935_26106[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (18))){
var inst_25478 = (state_25762[(15)]);
var state_25762__$1 = state_25762;
var statearr_25936_26107 = state_25762__$1;
(statearr_25936_26107[(2)] = inst_25478);

(statearr_25936_26107[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (105))){
var inst_25622 = (state_25762[(8)]);
var inst_25621 = (state_25762[(9)]);
var inst_25700 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_25621,inst_25622,throw_QMARK_);
var state_25762__$1 = state_25762;
var statearr_25937_26108 = state_25762__$1;
(statearr_25937_26108[(2)] = inst_25700);

(statearr_25937_26108[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (52))){
var inst_25591 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25938_26109 = state_25762__$1;
(statearr_25938_26109[(2)] = inst_25591);

(statearr_25938_26109[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (114))){
var inst_25490 = (state_25762[(10)]);
var inst_25727 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25728 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_25727);
var inst_25729 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_25728);
var inst_25730 = (!(inst_25729));
var state_25762__$1 = state_25762;
var statearr_25939_26110 = state_25762__$1;
(statearr_25939_26110[(2)] = inst_25730);

(statearr_25939_26110[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (67))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25940_26111 = state_25762__$1;
(statearr_25940_26111[(2)] = inst_25609);

(statearr_25940_26111[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (71))){
var inst_25714 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25941_26112 = state_25762__$1;
(statearr_25941_26112[(2)] = inst_25714);

(statearr_25941_26112[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (42))){
var inst_25556 = (state_25762[(36)]);
var state_25762__$1 = state_25762;
var statearr_25942_26113 = state_25762__$1;
(statearr_25942_26113[(2)] = inst_25556);

(statearr_25942_26113[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (80))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25943_26114 = state_25762__$1;
(statearr_25943_26114[(2)] = inst_25609);

(statearr_25943_26114[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (37))){
var inst_25549 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25944_26115 = state_25762__$1;
(statearr_25944_26115[(2)] = inst_25549);

(statearr_25944_26115[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (63))){
var inst_25490 = (state_25762[(10)]);
var inst_25612 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_25490);
var inst_25613 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_25612);
var state_25762__$1 = state_25762;
var statearr_25945_26116 = state_25762__$1;
(statearr_25945_26116[(2)] = inst_25613);

(statearr_25945_26116[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (94))){
var inst_25672 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
var statearr_25946_26117 = state_25762__$1;
(statearr_25946_26117[(2)] = inst_25672);

(statearr_25946_26117[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (8))){
var inst_25478 = (state_25762[(15)]);
var state_25762__$1 = state_25762;
var statearr_25947_26118 = state_25762__$1;
(statearr_25947_26118[(2)] = inst_25478);

(statearr_25947_26118[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (49))){
var inst_25594 = (state_25762[(2)]);
var state_25762__$1 = state_25762;
if(cljs.core.truth_(inst_25594)){
var statearr_25948_26119 = state_25762__$1;
(statearr_25948_26119[(1)] = (57));

} else {
var statearr_25949_26120 = state_25762__$1;
(statearr_25949_26120[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25763 === (84))){
var inst_25609 = (state_25762[(12)]);
var state_25762__$1 = state_25762;
var statearr_25950_26121 = state_25762__$1;
(statearr_25950_26121[(2)] = inst_25609);

(statearr_25950_26121[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10798__auto__ = null;
var fluree$db$query$schema$state_machine__10798__auto____0 = (function (){
var statearr_25951 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25951[(0)] = fluree$db$query$schema$state_machine__10798__auto__);

(statearr_25951[(1)] = (1));

return statearr_25951;
});
var fluree$db$query$schema$state_machine__10798__auto____1 = (function (state_25762){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_25762);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e25952){var ex__10801__auto__ = e25952;
var statearr_25953_26122 = state_25762;
(statearr_25953_26122[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_25762[(4)]))){
var statearr_25954_26123 = state_25762;
(statearr_25954_26123[(1)] = cljs.core.first((state_25762[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26124 = state_25762;
state_25762 = G__26124;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10798__auto__ = function(state_25762){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10798__auto____1.call(this,state_25762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10798__auto____0;
fluree$db$query$schema$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10798__auto____1;
return fluree$db$query$schema$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_25955 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_25955[(6)] = c__10835__auto__);

return statearr_25955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__26126 = arguments.length;
switch (G__26126) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26150){
var state_val_26151 = (state_26150[(1)]);
if((state_val_26151 === (7))){
var state_26150__$1 = state_26150;
var statearr_26152_26172 = state_26150__$1;
(statearr_26152_26172[(2)] = db);

(statearr_26152_26172[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26151 === (1))){
var state_26150__$1 = state_26150;
var statearr_26153_26173 = state_26150__$1;
(statearr_26153_26173[(2)] = null);

(statearr_26153_26173[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26151 === (4))){
var inst_26127 = (state_26150[(2)]);
var state_26150__$1 = state_26150;
var statearr_26154_26174 = state_26150__$1;
(statearr_26154_26174[(2)] = inst_26127);

(statearr_26154_26174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26151 === (6))){
var inst_26136 = (state_26150[(7)]);
var inst_26135 = (state_26150[(2)]);
var inst_26136__$1 = fluree.db.util.async.throw_err(inst_26135);
var inst_26137 = cljs.core.empty_QMARK_(inst_26136__$1);
var state_26150__$1 = (function (){var statearr_26155 = state_26150;
(statearr_26155[(7)] = inst_26136__$1);

return statearr_26155;
})();
if(inst_26137){
var statearr_26156_26175 = state_26150__$1;
(statearr_26156_26175[(1)] = (7));

} else {
var statearr_26157_26176 = state_26150__$1;
(statearr_26157_26176[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26151 === (3))){
var inst_26148 = (state_26150[(2)]);
var state_26150__$1 = state_26150;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26150__$1,inst_26148);
} else {
if((state_val_26151 === (2))){
var _ = (function (){var statearr_26159 = state_26150;
(statearr_26159[(4)] = cljs.core.cons((5),(state_26150[(4)])));

return statearr_26159;
})();
var inst_26133 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_26150__$1 = state_26150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26150__$1,(6),inst_26133);
} else {
if((state_val_26151 === (9))){
var inst_26145 = (state_26150[(2)]);
var _ = (function (){var statearr_26160 = state_26150;
(statearr_26160[(4)] = cljs.core.rest((state_26150[(4)])));

return statearr_26160;
})();
var state_26150__$1 = state_26150;
var statearr_26161_26177 = state_26150__$1;
(statearr_26161_26177[(2)] = inst_26145);

(statearr_26161_26177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26151 === (5))){
var _ = (function (){var statearr_26162 = state_26150;
(statearr_26162[(4)] = cljs.core.rest((state_26150[(4)])));

return statearr_26162;
})();
var state_26150__$1 = state_26150;
var ex26158 = (state_26150__$1[(2)]);
var statearr_26163_26178 = state_26150__$1;
(statearr_26163_26178[(5)] = ex26158);


if((ex26158 instanceof Error)){
var statearr_26164_26179 = state_26150__$1;
(statearr_26164_26179[(1)] = (4));

(statearr_26164_26179[(5)] = null);

} else {
throw ex26158;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26151 === (10))){
var inst_26142 = (state_26150[(2)]);
var inst_26143 = fluree.db.util.async.throw_err(inst_26142);
var state_26150__$1 = state_26150;
var statearr_26165_26180 = state_26150__$1;
(statearr_26165_26180[(2)] = inst_26143);

(statearr_26165_26180[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26151 === (8))){
var inst_26136 = (state_26150[(7)]);
var inst_26140 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_26136,db,true);
var state_26150__$1 = state_26150;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26150__$1,(10),inst_26140);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10798__auto__ = null;
var fluree$db$query$schema$state_machine__10798__auto____0 = (function (){
var statearr_26166 = [null,null,null,null,null,null,null,null];
(statearr_26166[(0)] = fluree$db$query$schema$state_machine__10798__auto__);

(statearr_26166[(1)] = (1));

return statearr_26166;
});
var fluree$db$query$schema$state_machine__10798__auto____1 = (function (state_26150){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26150);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26167){var ex__10801__auto__ = e26167;
var statearr_26168_26181 = state_26150;
(statearr_26168_26181[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26150[(4)]))){
var statearr_26169_26182 = state_26150;
(statearr_26169_26182[(1)] = cljs.core.first((state_26150[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26183 = state_26150;
state_26150 = G__26183;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10798__auto__ = function(state_26150){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10798__auto____1.call(this,state_26150);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10798__auto____0;
fluree$db$query$schema$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10798__auto____1;
return fluree$db$query$schema$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26170 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26170[(6)] = c__10835__auto__);

return statearr_26170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__26185 = arguments.length;
switch (G__26185) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__26187 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26187,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26187,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26187,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4221__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4221__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__26190_SHARP_,p2__26191_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26190_SHARP_,p2__26191_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__26192_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,p1__26192_SHARP_.p)){
return p1__26192_SHARP_.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26258){
var state_val_26259 = (state_26258[(1)]);
if((state_val_26259 === (1))){
var state_26258__$1 = state_26258;
var statearr_26260_26278 = state_26258__$1;
(statearr_26260_26278[(2)] = null);

(statearr_26260_26278[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26259 === (2))){
var _ = (function (){var statearr_26261 = state_26258;
(statearr_26261[(4)] = cljs.core.cons((5),(state_26258[(4)])));

return statearr_26261;
})();
var inst_26210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26211 = fluree.db.flake.max_subject_id((1));
var inst_26212 = [inst_26211];
var inst_26213 = (new cljs.core.PersistentVector(null,1,(5),inst_26210,inst_26212,null));
var inst_26214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26215 = [(0)];
var inst_26216 = (new cljs.core.PersistentVector(null,1,(5),inst_26214,inst_26215,null));
var inst_26217 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_26213,cljs.core._LT__EQ_,inst_26216);
var state_26258__$1 = state_26258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26258__$1,(6),inst_26217);
} else {
if((state_val_26259 === (3))){
var inst_26256 = (state_26258[(2)]);
var state_26258__$1 = state_26258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26258__$1,inst_26256);
} else {
if((state_val_26259 === (4))){
var inst_26198 = (state_26258[(2)]);
var state_26258__$1 = state_26258;
var statearr_26263_26279 = state_26258__$1;
(statearr_26263_26279[(2)] = inst_26198);

(statearr_26263_26279[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26259 === (5))){
var _ = (function (){var statearr_26264 = state_26258;
(statearr_26264[(4)] = cljs.core.rest((state_26258[(4)])));

return statearr_26264;
})();
var state_26258__$1 = state_26258;
var ex26262 = (state_26258__$1[(2)]);
var statearr_26265_26280 = state_26258__$1;
(statearr_26265_26280[(5)] = ex26262);


if((ex26262 instanceof Error)){
var statearr_26266_26281 = state_26258__$1;
(statearr_26266_26281[(1)] = (4));

(statearr_26266_26281[(5)] = null);

} else {
throw ex26262;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26259 === (6))){
var inst_26219 = (state_26258[(2)]);
var inst_26220 = fluree.db.util.async.throw_err(inst_26219);
var inst_26221 = (function (){var schema_flakes = inst_26220;
return (function (p1__26193_SHARP_){
return (p1__26193_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_26222 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_26221,inst_26220);
var inst_26223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26222,(0),null);
var inst_26224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26222,(1),null);
var inst_26225 = (function (){var schema_flakes = inst_26220;
var vec__26204 = inst_26222;
var collection_flakes = inst_26223;
var predicate_flakes = inst_26224;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__26195_SHARP_,p2__26196_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__26195_SHARP_,p2__26196_SHARP_.p,p2__26196_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_26226 = [(-1),"_tx"];
var inst_26227 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_26228 = ["_tx",(-1),(-1),(-1),null,null];
var inst_26229 = cljs.core.PersistentHashMap.fromArrays(inst_26227,inst_26228);
var inst_26230 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_26231 = ["_tx",(-1),(-1),(-1),null,null];
var inst_26232 = cljs.core.PersistentHashMap.fromArrays(inst_26230,inst_26231);
var inst_26233 = [inst_26229,inst_26232];
var inst_26234 = cljs.core.PersistentHashMap.fromArrays(inst_26226,inst_26233);
var inst_26235 = (function (){var schema_flakes = inst_26220;
var vec__26204 = inst_26222;
var collection_flakes = inst_26223;
var predicate_flakes = inst_26224;
return (function (p1__26194_SHARP_){
return p1__26194_SHARP_.s;
});
})();
var inst_26236 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_26235,inst_26223);
var inst_26237 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26225,inst_26234,inst_26236);
var inst_26239 = (function (){var schema_flakes = inst_26220;
var vec__26204 = inst_26222;
var collection_flakes = inst_26223;
var predicate_flakes = inst_26224;
var coll = inst_26237;
return (function (p__26238,pred_flakes){
var vec__26267 = p__26238;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26267,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26267,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__26270 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__26270.cljs$core$IFn$_invoke$arity$1 ? fexpr__26270.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__26270.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4223__auto__ = ref_QMARK_;
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_26240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26241 = cljs.core.PersistentHashMap.EMPTY;
var inst_26242 = cljs.core.PersistentHashSet.EMPTY;
var inst_26243 = [inst_26241,inst_26242];
var inst_26244 = (new cljs.core.PersistentVector(null,2,(5),inst_26240,inst_26243,null));
var inst_26245 = (function (){var schema_flakes = inst_26220;
var vec__26204 = inst_26222;
var collection_flakes = inst_26223;
var predicate_flakes = inst_26224;
var coll = inst_26237;
return (function (p1__26197_SHARP_){
return p1__26197_SHARP_.s;
});
})();
var inst_26246 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_26245,inst_26224);
var inst_26247 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26239,inst_26244,inst_26246);
var inst_26248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26247,(0),null);
var inst_26249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26247,(1),null);
var inst_26250 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_26251 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_26252 = [inst_26251,inst_26237,inst_26248,inst_26249];
var inst_26253 = cljs.core.PersistentHashMap.fromArrays(inst_26250,inst_26252);
var _ = (function (){var statearr_26271 = state_26258;
(statearr_26271[(4)] = cljs.core.rest((state_26258[(4)])));

return statearr_26271;
})();
var state_26258__$1 = state_26258;
var statearr_26272_26282 = state_26258__$1;
(statearr_26272_26282[(2)] = inst_26253);

(statearr_26272_26282[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__10798__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__10798__auto____0 = (function (){
var statearr_26273 = [null,null,null,null,null,null,null];
(statearr_26273[(0)] = fluree$db$query$schema$schema_map_$_state_machine__10798__auto__);

(statearr_26273[(1)] = (1));

return statearr_26273;
});
var fluree$db$query$schema$schema_map_$_state_machine__10798__auto____1 = (function (state_26258){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26258);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26274){var ex__10801__auto__ = e26274;
var statearr_26275_26283 = state_26258;
(statearr_26275_26283[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26258[(4)]))){
var statearr_26276_26284 = state_26258;
(statearr_26276_26284[(1)] = cljs.core.first((state_26258[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26285 = state_26258;
state_26258 = G__26285;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__10798__auto__ = function(state_26258){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__10798__auto____1.call(this,state_26258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__10798__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__10798__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26277 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26277[(6)] = c__10835__auto__);

return statearr_26277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26327){
var state_val_26328 = (state_26327[(1)]);
if((state_val_26328 === (7))){
var inst_26310 = (state_26327[(2)]);
var inst_26311 = fluree.db.query.schema.flake__GT_pred_map(inst_26310);
var inst_26312 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_26313 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26311,(114));
var inst_26314 = cljs.core.boolean$(inst_26313);
var inst_26315 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26311,(110));
var inst_26316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26311,(117));
var inst_26317 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_26316);
var inst_26318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26311,(111));
var inst_26319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26311,(115));
var inst_26320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26311,(112));
var inst_26321 = [inst_26314,inst_26315,inst_26317,inst_26318,inst_26319,inst_26320];
var inst_26322 = cljs.core.PersistentHashMap.fromArrays(inst_26312,inst_26321);
var _ = (function (){var statearr_26329 = state_26327;
(statearr_26329[(4)] = cljs.core.rest((state_26327[(4)])));

return statearr_26329;
})();
var state_26327__$1 = state_26327;
var statearr_26330_26353 = state_26327__$1;
(statearr_26330_26353[(2)] = inst_26322);

(statearr_26330_26353[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26328 === (1))){
var state_26327__$1 = state_26327;
var statearr_26331_26354 = state_26327__$1;
(statearr_26331_26354[(2)] = null);

(statearr_26331_26354[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26328 === (4))){
var inst_26286 = (state_26327[(2)]);
var state_26327__$1 = state_26327;
var statearr_26332_26355 = state_26327__$1;
(statearr_26332_26355[(2)] = inst_26286);

(statearr_26332_26355[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26328 === (6))){
var _ = (function (){var statearr_26333 = state_26327;
(statearr_26333[(4)] = cljs.core.cons((9),(state_26327[(4)])));

return statearr_26333;
})();
var inst_26298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26300 = ["_setting/id","root"];
var inst_26301 = (new cljs.core.PersistentVector(null,2,(5),inst_26299,inst_26300,null));
var inst_26302 = [inst_26301];
var inst_26303 = (new cljs.core.PersistentVector(null,1,(5),inst_26298,inst_26302,null));
var inst_26304 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_26303);
var state_26327__$1 = state_26327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26327__$1,(10),inst_26304);
} else {
if((state_val_26328 === (3))){
var inst_26325 = (state_26327[(2)]);
var state_26327__$1 = state_26327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26327__$1,inst_26325);
} else {
if((state_val_26328 === (2))){
var _ = (function (){var statearr_26336 = state_26327;
(statearr_26336[(4)] = cljs.core.cons((5),(state_26327[(4)])));

return statearr_26336;
})();
var state_26327__$1 = state_26327;
var statearr_26337_26356 = state_26327__$1;
(statearr_26337_26356[(2)] = null);

(statearr_26337_26356[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26328 === (9))){
var _ = (function (){var statearr_26338 = state_26327;
(statearr_26338[(4)] = cljs.core.rest((state_26327[(4)])));

return statearr_26338;
})();
var state_26327__$1 = state_26327;
var ex26334 = (state_26327__$1[(2)]);
var statearr_26339_26357 = state_26327__$1;
(statearr_26339_26357[(5)] = ex26334);


var statearr_26340_26358 = state_26327__$1;
(statearr_26340_26358[(1)] = (8));

(statearr_26340_26358[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26328 === (5))){
var _ = (function (){var statearr_26341 = state_26327;
(statearr_26341[(4)] = cljs.core.rest((state_26327[(4)])));

return statearr_26341;
})();
var state_26327__$1 = state_26327;
var ex26335 = (state_26327__$1[(2)]);
var statearr_26342_26359 = state_26327__$1;
(statearr_26342_26359[(5)] = ex26335);


if((ex26335 instanceof Error)){
var statearr_26343_26360 = state_26327__$1;
(statearr_26343_26360[(1)] = (4));

(statearr_26343_26360[(5)] = null);

} else {
throw ex26335;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26328 === (10))){
var inst_26306 = (state_26327[(2)]);
var inst_26307 = fluree.db.util.async.throw_err(inst_26306);
var _ = (function (){var statearr_26344 = state_26327;
(statearr_26344[(4)] = cljs.core.rest((state_26327[(4)])));

return statearr_26344;
})();
var state_26327__$1 = state_26327;
var statearr_26345_26361 = state_26327__$1;
(statearr_26345_26361[(2)] = inst_26307);

(statearr_26345_26361[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26328 === (8))){
var inst_26292 = (state_26327[(2)]);
var state_26327__$1 = (function (){var statearr_26346 = state_26327;
(statearr_26346[(7)] = inst_26292);

return statearr_26346;
})();
var statearr_26347_26362 = state_26327__$1;
(statearr_26347_26362[(2)] = null);

(statearr_26347_26362[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__10798__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__10798__auto____0 = (function (){
var statearr_26348 = [null,null,null,null,null,null,null,null];
(statearr_26348[(0)] = fluree$db$query$schema$setting_map_$_state_machine__10798__auto__);

(statearr_26348[(1)] = (1));

return statearr_26348;
});
var fluree$db$query$schema$setting_map_$_state_machine__10798__auto____1 = (function (state_26327){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26327);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26349){var ex__10801__auto__ = e26349;
var statearr_26350_26363 = state_26327;
(statearr_26350_26363[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26327[(4)]))){
var statearr_26351_26364 = state_26327;
(statearr_26351_26364[(1)] = cljs.core.first((state_26327[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26365 = state_26327;
state_26327 = G__26365;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__10798__auto__ = function(state_26327){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__10798__auto____1.call(this,state_26327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__10798__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__10798__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26352 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26352[(6)] = c__10835__auto__);

return statearr_26352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
