// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26624){
var state_val_26625 = (state_26624[(1)]);
if((state_val_26625 === (7))){
var inst_26613 = (state_26624[(7)]);
var inst_26615 = fluree.db.storage.core.serde(conn);
var inst_26616 = fluree.db.serde.protocol._deserialize_block(inst_26615,inst_26613);
var state_26624__$1 = state_26624;
var statearr_26626_26645 = state_26624__$1;
(statearr_26626_26645[(2)] = inst_26616);

(statearr_26626_26645[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26625 === (1))){
var state_26624__$1 = state_26624;
var statearr_26627_26646 = state_26624__$1;
(statearr_26627_26646[(2)] = null);

(statearr_26627_26646[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26625 === (4))){
var inst_26603 = (state_26624[(2)]);
var state_26624__$1 = state_26624;
var statearr_26628_26647 = state_26624__$1;
(statearr_26628_26647[(2)] = inst_26603);

(statearr_26628_26647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26625 === (6))){
var inst_26613 = (state_26624[(7)]);
var inst_26612 = (state_26624[(2)]);
var inst_26613__$1 = fluree.db.util.async.throw_err(inst_26612);
var state_26624__$1 = (function (){var statearr_26629 = state_26624;
(statearr_26629[(7)] = inst_26613__$1);

return statearr_26629;
})();
if(cljs.core.truth_(inst_26613__$1)){
var statearr_26630_26648 = state_26624__$1;
(statearr_26630_26648[(1)] = (7));

} else {
var statearr_26631_26649 = state_26624__$1;
(statearr_26631_26649[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26625 === (3))){
var inst_26622 = (state_26624[(2)]);
var state_26624__$1 = state_26624;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26624__$1,inst_26622);
} else {
if((state_val_26625 === (2))){
var _ = (function (){var statearr_26633 = state_26624;
(statearr_26633[(4)] = cljs.core.cons((5),(state_26624[(4)])));

return statearr_26633;
})();
var inst_26609 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_26610 = fluree.db.storage.core.storage_read(conn,inst_26609);
var state_26624__$1 = state_26624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26624__$1,(6),inst_26610);
} else {
if((state_val_26625 === (9))){
var inst_26619 = (state_26624[(2)]);
var _ = (function (){var statearr_26634 = state_26624;
(statearr_26634[(4)] = cljs.core.rest((state_26624[(4)])));

return statearr_26634;
})();
var state_26624__$1 = state_26624;
var statearr_26635_26650 = state_26624__$1;
(statearr_26635_26650[(2)] = inst_26619);

(statearr_26635_26650[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26625 === (5))){
var _ = (function (){var statearr_26636 = state_26624;
(statearr_26636[(4)] = cljs.core.rest((state_26624[(4)])));

return statearr_26636;
})();
var state_26624__$1 = state_26624;
var ex26632 = (state_26624__$1[(2)]);
var statearr_26637_26651 = state_26624__$1;
(statearr_26637_26651[(5)] = ex26632);


if((ex26632 instanceof Error)){
var statearr_26638_26652 = state_26624__$1;
(statearr_26638_26652[(1)] = (4));

(statearr_26638_26652[(5)] = null);

} else {
throw ex26632;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26625 === (8))){
var state_26624__$1 = state_26624;
var statearr_26639_26653 = state_26624__$1;
(statearr_26639_26653[(2)] = null);

(statearr_26639_26653[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__10798__auto____0 = (function (){
var statearr_26640 = [null,null,null,null,null,null,null,null];
(statearr_26640[(0)] = fluree$db$storage$core$read_block_$_state_machine__10798__auto__);

(statearr_26640[(1)] = (1));

return statearr_26640;
});
var fluree$db$storage$core$read_block_$_state_machine__10798__auto____1 = (function (state_26624){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26624);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26641){var ex__10801__auto__ = e26641;
var statearr_26642_26654 = state_26624;
(statearr_26642_26654[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26624[(4)]))){
var statearr_26643_26655 = state_26624;
(statearr_26643_26655[(1)] = cljs.core.first((state_26624[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26656 = state_26624;
state_26624 = G__26656;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__10798__auto__ = function(state_26624){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__10798__auto____1.call(this,state_26624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__10798__auto____0;
fluree$db$storage$core$read_block_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__10798__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26644 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26644[(6)] = c__10835__auto__);

return statearr_26644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26679){
var state_val_26680 = (state_26679[(1)]);
if((state_val_26680 === (7))){
var inst_26668 = (state_26679[(7)]);
var inst_26670 = fluree.db.storage.core.serde(conn);
var inst_26671 = fluree.db.serde.protocol._deserialize_block(inst_26670,inst_26668);
var state_26679__$1 = state_26679;
var statearr_26681_26700 = state_26679__$1;
(statearr_26681_26700[(2)] = inst_26671);

(statearr_26681_26700[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26680 === (1))){
var state_26679__$1 = state_26679;
var statearr_26682_26701 = state_26679__$1;
(statearr_26682_26701[(2)] = null);

(statearr_26682_26701[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26680 === (4))){
var inst_26657 = (state_26679[(2)]);
var state_26679__$1 = state_26679;
var statearr_26683_26702 = state_26679__$1;
(statearr_26683_26702[(2)] = inst_26657);

(statearr_26683_26702[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26680 === (6))){
var inst_26668 = (state_26679[(7)]);
var inst_26667 = (state_26679[(2)]);
var inst_26668__$1 = fluree.db.util.async.throw_err(inst_26667);
var state_26679__$1 = (function (){var statearr_26684 = state_26679;
(statearr_26684[(7)] = inst_26668__$1);

return statearr_26684;
})();
if(cljs.core.truth_(inst_26668__$1)){
var statearr_26685_26703 = state_26679__$1;
(statearr_26685_26703[(1)] = (7));

} else {
var statearr_26686_26704 = state_26679__$1;
(statearr_26686_26704[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26680 === (3))){
var inst_26677 = (state_26679[(2)]);
var state_26679__$1 = state_26679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26679__$1,inst_26677);
} else {
if((state_val_26680 === (2))){
var _ = (function (){var statearr_26688 = state_26679;
(statearr_26688[(4)] = cljs.core.cons((5),(state_26679[(4)])));

return statearr_26688;
})();
var inst_26663 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_26664 = [inst_26663,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_26665 = fluree.db.storage.core.storage_read(conn,inst_26664);
var state_26679__$1 = state_26679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26679__$1,(6),inst_26665);
} else {
if((state_val_26680 === (9))){
var inst_26674 = (state_26679[(2)]);
var _ = (function (){var statearr_26689 = state_26679;
(statearr_26689[(4)] = cljs.core.rest((state_26679[(4)])));

return statearr_26689;
})();
var state_26679__$1 = state_26679;
var statearr_26690_26705 = state_26679__$1;
(statearr_26690_26705[(2)] = inst_26674);

(statearr_26690_26705[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26680 === (5))){
var _ = (function (){var statearr_26691 = state_26679;
(statearr_26691[(4)] = cljs.core.rest((state_26679[(4)])));

return statearr_26691;
})();
var state_26679__$1 = state_26679;
var ex26687 = (state_26679__$1[(2)]);
var statearr_26692_26706 = state_26679__$1;
(statearr_26692_26706[(5)] = ex26687);


if((ex26687 instanceof Error)){
var statearr_26693_26707 = state_26679__$1;
(statearr_26693_26707[(1)] = (4));

(statearr_26693_26707[(5)] = null);

} else {
throw ex26687;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26680 === (8))){
var state_26679__$1 = state_26679;
var statearr_26694_26708 = state_26679__$1;
(statearr_26694_26708[(2)] = null);

(statearr_26694_26708[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__10798__auto____0 = (function (){
var statearr_26695 = [null,null,null,null,null,null,null,null];
(statearr_26695[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__10798__auto__);

(statearr_26695[(1)] = (1));

return statearr_26695;
});
var fluree$db$storage$core$read_block_version_$_state_machine__10798__auto____1 = (function (state_26679){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26679);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26696){var ex__10801__auto__ = e26696;
var statearr_26697_26709 = state_26679;
(statearr_26697_26709[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26679[(4)]))){
var statearr_26698_26710 = state_26679;
(statearr_26698_26710[(1)] = cljs.core.first((state_26679[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26711 = state_26679;
state_26679 = G__26711;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__10798__auto__ = function(state_26679){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__10798__auto____1.call(this,state_26679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__10798__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__10798__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26699 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26699[(6)] = c__10835__auto__);

return statearr_26699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26735){
var state_val_26736 = (state_26735[(1)]);
if((state_val_26736 === (1))){
var state_26735__$1 = state_26735;
var statearr_26737_26751 = state_26735__$1;
(statearr_26737_26751[(2)] = null);

(statearr_26737_26751[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26736 === (2))){
var _ = (function (){var statearr_26738 = state_26735;
(statearr_26738[(4)] = cljs.core.cons((5),(state_26735[(4)])));

return statearr_26738;
})();
var inst_26718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26719 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_26720 = (new cljs.core.PersistentVector(null,3,(5),inst_26718,inst_26719,null));
var inst_26721 = cljs.core.select_keys(block_data,inst_26720);
var inst_26722 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_26721);
var inst_26723 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_26722);
var inst_26724 = [inst_26723,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_26725 = fluree.db.storage.core.serde(conn);
var inst_26726 = fluree.db.serde.protocol._serialize_block(inst_26725,inst_26721);
var inst_26727 = fluree.db.storage.core.storage_write(conn,inst_26724,inst_26726);
var state_26735__$1 = state_26735;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26735__$1,(6),inst_26727);
} else {
if((state_val_26736 === (3))){
var inst_26733 = (state_26735[(2)]);
var state_26735__$1 = state_26735;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26735__$1,inst_26733);
} else {
if((state_val_26736 === (4))){
var inst_26712 = (state_26735[(2)]);
var state_26735__$1 = state_26735;
var statearr_26740_26752 = state_26735__$1;
(statearr_26740_26752[(2)] = inst_26712);

(statearr_26740_26752[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26736 === (5))){
var _ = (function (){var statearr_26741 = state_26735;
(statearr_26741[(4)] = cljs.core.rest((state_26735[(4)])));

return statearr_26741;
})();
var state_26735__$1 = state_26735;
var ex26739 = (state_26735__$1[(2)]);
var statearr_26742_26753 = state_26735__$1;
(statearr_26742_26753[(5)] = ex26739);


if((ex26739 instanceof Error)){
var statearr_26743_26754 = state_26735__$1;
(statearr_26743_26754[(1)] = (4));

(statearr_26743_26754[(5)] = null);

} else {
throw ex26739;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26736 === (6))){
var inst_26729 = (state_26735[(2)]);
var inst_26730 = fluree.db.util.async.throw_err(inst_26729);
var _ = (function (){var statearr_26744 = state_26735;
(statearr_26744[(4)] = cljs.core.rest((state_26735[(4)])));

return statearr_26744;
})();
var state_26735__$1 = state_26735;
var statearr_26745_26755 = state_26735__$1;
(statearr_26745_26755[(2)] = inst_26730);

(statearr_26745_26755[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__10798__auto____0 = (function (){
var statearr_26746 = [null,null,null,null,null,null,null];
(statearr_26746[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__10798__auto__);

(statearr_26746[(1)] = (1));

return statearr_26746;
});
var fluree$db$storage$core$write_block_version_$_state_machine__10798__auto____1 = (function (state_26735){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26735);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26747){var ex__10801__auto__ = e26747;
var statearr_26748_26756 = state_26735;
(statearr_26748_26756[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26735[(4)]))){
var statearr_26749_26757 = state_26735;
(statearr_26749_26757[(1)] = cljs.core.first((state_26735[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26758 = state_26735;
state_26735 = G__26758;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__10798__auto__ = function(state_26735){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__10798__auto____1.call(this,state_26735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__10798__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__10798__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26750 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26750[(6)] = c__10835__auto__);

return statearr_26750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26781){
var state_val_26782 = (state_26781[(1)]);
if((state_val_26782 === (1))){
var state_26781__$1 = state_26781;
var statearr_26783_26797 = state_26781__$1;
(statearr_26783_26797[(2)] = null);

(statearr_26783_26797[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26782 === (2))){
var _ = (function (){var statearr_26784 = state_26781;
(statearr_26784[(4)] = cljs.core.cons((5),(state_26781[(4)])));

return statearr_26784;
})();
var inst_26765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26766 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_26767 = (new cljs.core.PersistentVector(null,3,(5),inst_26765,inst_26766,null));
var inst_26768 = cljs.core.select_keys(block_data,inst_26767);
var inst_26769 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_26768);
var inst_26770 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_26769);
var inst_26771 = fluree.db.storage.core.serde(conn);
var inst_26772 = fluree.db.serde.protocol._serialize_block(inst_26771,inst_26768);
var inst_26773 = fluree.db.storage.core.storage_write(conn,inst_26770,inst_26772);
var state_26781__$1 = state_26781;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26781__$1,(6),inst_26773);
} else {
if((state_val_26782 === (3))){
var inst_26779 = (state_26781[(2)]);
var state_26781__$1 = state_26781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26781__$1,inst_26779);
} else {
if((state_val_26782 === (4))){
var inst_26759 = (state_26781[(2)]);
var state_26781__$1 = state_26781;
var statearr_26786_26798 = state_26781__$1;
(statearr_26786_26798[(2)] = inst_26759);

(statearr_26786_26798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26782 === (5))){
var _ = (function (){var statearr_26787 = state_26781;
(statearr_26787[(4)] = cljs.core.rest((state_26781[(4)])));

return statearr_26787;
})();
var state_26781__$1 = state_26781;
var ex26785 = (state_26781__$1[(2)]);
var statearr_26788_26799 = state_26781__$1;
(statearr_26788_26799[(5)] = ex26785);


if((ex26785 instanceof Error)){
var statearr_26789_26800 = state_26781__$1;
(statearr_26789_26800[(1)] = (4));

(statearr_26789_26800[(5)] = null);

} else {
throw ex26785;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26782 === (6))){
var inst_26775 = (state_26781[(2)]);
var inst_26776 = fluree.db.util.async.throw_err(inst_26775);
var _ = (function (){var statearr_26790 = state_26781;
(statearr_26790[(4)] = cljs.core.rest((state_26781[(4)])));

return statearr_26790;
})();
var state_26781__$1 = state_26781;
var statearr_26791_26801 = state_26781__$1;
(statearr_26791_26801[(2)] = inst_26776);

(statearr_26791_26801[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__10798__auto____0 = (function (){
var statearr_26792 = [null,null,null,null,null,null,null];
(statearr_26792[(0)] = fluree$db$storage$core$write_block_$_state_machine__10798__auto__);

(statearr_26792[(1)] = (1));

return statearr_26792;
});
var fluree$db$storage$core$write_block_$_state_machine__10798__auto____1 = (function (state_26781){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26781);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26793){var ex__10801__auto__ = e26793;
var statearr_26794_26802 = state_26781;
(statearr_26794_26802[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26781[(4)]))){
var statearr_26795_26803 = state_26781;
(statearr_26795_26803[(1)] = cljs.core.first((state_26781[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26804 = state_26781;
state_26781 = G__26804;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__10798__auto__ = function(state_26781){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__10798__auto____1.call(this,state_26781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__10798__auto____0;
fluree$db$storage$core$write_block_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__10798__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26796 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26796[(6)] = c__10835__auto__);

return statearr_26796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26824){
var state_val_26825 = (state_26824[(1)]);
if((state_val_26825 === (1))){
var state_26824__$1 = state_26824;
var statearr_26826_26840 = state_26824__$1;
(statearr_26826_26840[(2)] = null);

(statearr_26826_26840[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26825 === (2))){
var _ = (function (){var statearr_26827 = state_26824;
(statearr_26827[(4)] = cljs.core.cons((5),(state_26824[(4)])));

return statearr_26827;
})();
var inst_26811 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_26812 = [history,next_his_key];
var inst_26813 = cljs.core.PersistentHashMap.fromArrays(inst_26811,inst_26812);
var inst_26814 = fluree.db.storage.core.serde(conn);
var inst_26815 = fluree.db.serde.protocol._serialize_leaf(inst_26814,inst_26813);
var inst_26816 = fluree.db.storage.core.storage_write(conn,his_key,inst_26815);
var state_26824__$1 = state_26824;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26824__$1,(6),inst_26816);
} else {
if((state_val_26825 === (3))){
var inst_26822 = (state_26824[(2)]);
var state_26824__$1 = state_26824;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26824__$1,inst_26822);
} else {
if((state_val_26825 === (4))){
var inst_26805 = (state_26824[(2)]);
var state_26824__$1 = state_26824;
var statearr_26829_26841 = state_26824__$1;
(statearr_26829_26841[(2)] = inst_26805);

(statearr_26829_26841[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26825 === (5))){
var _ = (function (){var statearr_26830 = state_26824;
(statearr_26830[(4)] = cljs.core.rest((state_26824[(4)])));

return statearr_26830;
})();
var state_26824__$1 = state_26824;
var ex26828 = (state_26824__$1[(2)]);
var statearr_26831_26842 = state_26824__$1;
(statearr_26831_26842[(5)] = ex26828);


if((ex26828 instanceof Error)){
var statearr_26832_26843 = state_26824__$1;
(statearr_26832_26843[(1)] = (4));

(statearr_26832_26843[(5)] = null);

} else {
throw ex26828;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26825 === (6))){
var inst_26818 = (state_26824[(2)]);
var inst_26819 = fluree.db.util.async.throw_err(inst_26818);
var _ = (function (){var statearr_26833 = state_26824;
(statearr_26833[(4)] = cljs.core.rest((state_26824[(4)])));

return statearr_26833;
})();
var state_26824__$1 = state_26824;
var statearr_26834_26844 = state_26824__$1;
(statearr_26834_26844[(2)] = inst_26819);

(statearr_26834_26844[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__10798__auto____0 = (function (){
var statearr_26835 = [null,null,null,null,null,null,null];
(statearr_26835[(0)] = fluree$db$storage$core$write_history_$_state_machine__10798__auto__);

(statearr_26835[(1)] = (1));

return statearr_26835;
});
var fluree$db$storage$core$write_history_$_state_machine__10798__auto____1 = (function (state_26824){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26824);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26836){var ex__10801__auto__ = e26836;
var statearr_26837_26845 = state_26824;
(statearr_26837_26845[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26824[(4)]))){
var statearr_26838_26846 = state_26824;
(statearr_26838_26846[(1)] = cljs.core.first((state_26824[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26847 = state_26824;
state_26824 = G__26847;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__10798__auto__ = function(state_26824){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__10798__auto____1.call(this,state_26824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__10798__auto____0;
fluree$db$storage$core$write_history_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__10798__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26839 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26839[(6)] = c__10835__auto__);

return statearr_26839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26873){
var state_val_26874 = (state_26873[(1)]);
if((state_val_26874 === (1))){
var state_26873__$1 = state_26873;
var statearr_26875_26892 = state_26873__$1;
(statearr_26875_26892[(2)] = null);

(statearr_26875_26892[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26874 === (2))){
var inst_26854 = (state_26873[(7)]);
var _ = (function (){var statearr_26876 = state_26873;
(statearr_26876[(4)] = cljs.core.cons((5),(state_26873[(4)])));

return statearr_26876;
})();
var inst_26854__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_26855 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26854__$1),"-his"].join('');
var inst_26856 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_26857 = [flakes,inst_26855];
var inst_26858 = cljs.core.PersistentHashMap.fromArrays(inst_26856,inst_26857);
var inst_26859 = fluree.db.storage.core.serde(conn);
var inst_26860 = fluree.db.serde.protocol._serialize_leaf(inst_26859,inst_26858);
var inst_26861 = fluree.db.storage.core.write_history(conn,history,inst_26855,null);
var inst_26862 = fluree.db.storage.core.storage_write(conn,inst_26854__$1,inst_26860);
var state_26873__$1 = (function (){var statearr_26877 = state_26873;
(statearr_26877[(8)] = inst_26862);

(statearr_26877[(7)] = inst_26854__$1);

return statearr_26877;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26873__$1,(6),inst_26861);
} else {
if((state_val_26874 === (3))){
var inst_26871 = (state_26873[(2)]);
var state_26873__$1 = state_26873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26873__$1,inst_26871);
} else {
if((state_val_26874 === (4))){
var inst_26848 = (state_26873[(2)]);
var state_26873__$1 = state_26873;
var statearr_26879_26893 = state_26873__$1;
(statearr_26879_26893[(2)] = inst_26848);

(statearr_26879_26893[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26874 === (5))){
var _ = (function (){var statearr_26880 = state_26873;
(statearr_26880[(4)] = cljs.core.rest((state_26873[(4)])));

return statearr_26880;
})();
var state_26873__$1 = state_26873;
var ex26878 = (state_26873__$1[(2)]);
var statearr_26881_26894 = state_26873__$1;
(statearr_26881_26894[(5)] = ex26878);


if((ex26878 instanceof Error)){
var statearr_26882_26895 = state_26873__$1;
(statearr_26882_26895[(1)] = (4));

(statearr_26882_26895[(5)] = null);

} else {
throw ex26878;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26874 === (6))){
var inst_26862 = (state_26873[(8)]);
var inst_26864 = (state_26873[(2)]);
var inst_26865 = fluree.db.util.async.throw_err(inst_26864);
var state_26873__$1 = (function (){var statearr_26883 = state_26873;
(statearr_26883[(9)] = inst_26865);

return statearr_26883;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26873__$1,(7),inst_26862);
} else {
if((state_val_26874 === (7))){
var inst_26854 = (state_26873[(7)]);
var inst_26867 = (state_26873[(2)]);
var inst_26868 = fluree.db.util.async.throw_err(inst_26867);
var _ = (function (){var statearr_26884 = state_26873;
(statearr_26884[(4)] = cljs.core.rest((state_26873[(4)])));

return statearr_26884;
})();
var state_26873__$1 = (function (){var statearr_26885 = state_26873;
(statearr_26885[(10)] = inst_26868);

return statearr_26885;
})();
var statearr_26886_26896 = state_26873__$1;
(statearr_26886_26896[(2)] = inst_26854);

(statearr_26886_26896[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__10798__auto____0 = (function (){
var statearr_26887 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26887[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__10798__auto__);

(statearr_26887[(1)] = (1));

return statearr_26887;
});
var fluree$db$storage$core$write_leaf_$_state_machine__10798__auto____1 = (function (state_26873){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26873);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26888){var ex__10801__auto__ = e26888;
var statearr_26889_26897 = state_26873;
(statearr_26889_26897[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26873[(4)]))){
var statearr_26890_26898 = state_26873;
(statearr_26890_26898[(1)] = cljs.core.first((state_26873[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26899 = state_26873;
state_26873 = G__26899;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__10798__auto__ = function(state_26873){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__10798__auto____1.call(this,state_26873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__10798__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__10798__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26891 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26891[(6)] = c__10835__auto__);

return statearr_26891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26916){
var state_val_26917 = (state_26916[(1)]);
if((state_val_26917 === (1))){
var state_26916__$1 = state_26916;
var statearr_26918_26933 = state_26916__$1;
(statearr_26918_26933[(2)] = null);

(statearr_26918_26933[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26917 === (2))){
var _ = (function (){var statearr_26919 = state_26916;
(statearr_26919[(4)] = cljs.core.cons((5),(state_26916[(4)])));

return statearr_26919;
})();
var inst_26906 = fluree.db.storage.core.serde(conn);
var inst_26907 = fluree.db.serde.protocol._serialize_branch(inst_26906,data);
var inst_26908 = fluree.db.storage.core.storage_write(conn,key,inst_26907);
var state_26916__$1 = state_26916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26916__$1,(6),inst_26908);
} else {
if((state_val_26917 === (3))){
var inst_26914 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26916__$1,inst_26914);
} else {
if((state_val_26917 === (4))){
var inst_26900 = (state_26916[(2)]);
var state_26916__$1 = state_26916;
var statearr_26921_26934 = state_26916__$1;
(statearr_26921_26934[(2)] = inst_26900);

(statearr_26921_26934[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26917 === (5))){
var _ = (function (){var statearr_26922 = state_26916;
(statearr_26922[(4)] = cljs.core.rest((state_26916[(4)])));

return statearr_26922;
})();
var state_26916__$1 = state_26916;
var ex26920 = (state_26916__$1[(2)]);
var statearr_26923_26935 = state_26916__$1;
(statearr_26923_26935[(5)] = ex26920);


if((ex26920 instanceof Error)){
var statearr_26924_26936 = state_26916__$1;
(statearr_26924_26936[(1)] = (4));

(statearr_26924_26936[(5)] = null);

} else {
throw ex26920;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26917 === (6))){
var inst_26910 = (state_26916[(2)]);
var inst_26911 = fluree.db.util.async.throw_err(inst_26910);
var _ = (function (){var statearr_26925 = state_26916;
(statearr_26925[(4)] = cljs.core.rest((state_26916[(4)])));

return statearr_26925;
})();
var state_26916__$1 = (function (){var statearr_26926 = state_26916;
(statearr_26926[(7)] = inst_26911);

return statearr_26926;
})();
var statearr_26927_26937 = state_26916__$1;
(statearr_26927_26937[(2)] = key);

(statearr_26927_26937[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto____0 = (function (){
var statearr_26928 = [null,null,null,null,null,null,null,null];
(statearr_26928[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto__);

(statearr_26928[(1)] = (1));

return statearr_26928;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto____1 = (function (state_26916){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26916);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26929){var ex__10801__auto__ = e26929;
var statearr_26930_26938 = state_26916;
(statearr_26930_26938[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26916[(4)]))){
var statearr_26931_26939 = state_26916;
(statearr_26931_26939[(1)] = cljs.core.first((state_26916[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26940 = state_26916;
state_26916 = G__26940;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto__ = function(state_26916){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto____1.call(this,state_26916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26932 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26932[(6)] = c__10835__auto__);

return statearr_26932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__26941_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__26941_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__26942){
var map__26943 = p__26942;
var map__26943__$1 = cljs.core.__destructure_map(map__26943);
var progress = map__26943__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26943__$1,cljs.core.cst$kw$garbage);
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_26971){
var state_val_26972 = (state_26971[(1)]);
if((state_val_26972 === (1))){
var state_26971__$1 = state_26971;
var statearr_26973_26989 = state_26971__$1;
(statearr_26973_26989[(2)] = null);

(statearr_26973_26989[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26972 === (2))){
var inst_26957 = (state_26971[(7)]);
var _ = (function (){var statearr_26974 = state_26971;
(statearr_26974[(4)] = cljs.core.cons((5),(state_26971[(4)])));

return statearr_26974;
})();
var inst_26951 = db;
var inst_26952 = cljs.core.__destructure_map(inst_26951);
var inst_26953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26952,cljs.core.cst$kw$conn);
var inst_26954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26952,cljs.core.cst$kw$network);
var inst_26955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26952,cljs.core.cst$kw$dbid);
var inst_26956 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26952,cljs.core.cst$kw$block);
var inst_26957__$1 = fluree.db.storage.core.ledger_garbage_key(inst_26954,inst_26955,inst_26956);
var inst_26958 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_26959 = [inst_26955,inst_26956,garbage];
var inst_26960 = cljs.core.PersistentHashMap.fromArrays(inst_26958,inst_26959);
var inst_26961 = fluree.db.storage.core.serde(inst_26953);
var inst_26962 = fluree.db.serde.protocol._serialize_garbage(inst_26961,inst_26960);
var inst_26963 = fluree.db.storage.core.storage_write(inst_26953,inst_26957__$1,inst_26962);
var state_26971__$1 = (function (){var statearr_26975 = state_26971;
(statearr_26975[(7)] = inst_26957__$1);

return statearr_26975;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26971__$1,(6),inst_26963);
} else {
if((state_val_26972 === (3))){
var inst_26969 = (state_26971[(2)]);
var state_26971__$1 = state_26971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26971__$1,inst_26969);
} else {
if((state_val_26972 === (4))){
var inst_26944 = (state_26971[(2)]);
var state_26971__$1 = state_26971;
var statearr_26977_26990 = state_26971__$1;
(statearr_26977_26990[(2)] = inst_26944);

(statearr_26977_26990[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26972 === (5))){
var _ = (function (){var statearr_26978 = state_26971;
(statearr_26978[(4)] = cljs.core.rest((state_26971[(4)])));

return statearr_26978;
})();
var state_26971__$1 = state_26971;
var ex26976 = (state_26971__$1[(2)]);
var statearr_26979_26991 = state_26971__$1;
(statearr_26979_26991[(5)] = ex26976);


if((ex26976 instanceof Error)){
var statearr_26980_26992 = state_26971__$1;
(statearr_26980_26992[(1)] = (4));

(statearr_26980_26992[(5)] = null);

} else {
throw ex26976;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26972 === (6))){
var inst_26957 = (state_26971[(7)]);
var inst_26965 = (state_26971[(2)]);
var inst_26966 = fluree.db.util.async.throw_err(inst_26965);
var _ = (function (){var statearr_26981 = state_26971;
(statearr_26981[(4)] = cljs.core.rest((state_26971[(4)])));

return statearr_26981;
})();
var state_26971__$1 = (function (){var statearr_26982 = state_26971;
(statearr_26982[(8)] = inst_26966);

return statearr_26982;
})();
var statearr_26983_26993 = state_26971__$1;
(statearr_26983_26993[(2)] = inst_26957);

(statearr_26983_26993[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__10798__auto____0 = (function (){
var statearr_26984 = [null,null,null,null,null,null,null,null,null];
(statearr_26984[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__10798__auto__);

(statearr_26984[(1)] = (1));

return statearr_26984;
});
var fluree$db$storage$core$write_garbage_$_state_machine__10798__auto____1 = (function (state_26971){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_26971);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e26985){var ex__10801__auto__ = e26985;
var statearr_26986_26994 = state_26971;
(statearr_26986_26994[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_26971[(4)]))){
var statearr_26987_26995 = state_26971;
(statearr_26987_26995[(1)] = cljs.core.first((state_26971[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__26996 = state_26971;
state_26971 = G__26996;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__10798__auto__ = function(state_26971){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__10798__auto____1.call(this,state_26971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__10798__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__10798__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_26988 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_26988[(6)] = c__10835__auto__);

return statearr_26988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__26998 = arguments.length;
switch (G__26998) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27054){
var state_val_27055 = (state_27054[(1)]);
if((state_val_27055 === (7))){
var state_27054__$1 = state_27054;
var statearr_27056_27082 = state_27054__$1;
(statearr_27056_27082[(2)] = (0));

(statearr_27056_27082[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (1))){
var state_27054__$1 = state_27054;
var statearr_27057_27083 = state_27054__$1;
(statearr_27057_27083[(2)] = null);

(statearr_27057_27083[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (4))){
var inst_26999 = (state_27054[(2)]);
var state_27054__$1 = state_27054;
var statearr_27058_27084 = state_27054__$1;
(statearr_27058_27084[(2)] = inst_26999);

(statearr_27058_27084[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (6))){
var inst_27024 = (state_27054[(7)]);
var state_27054__$1 = state_27054;
var statearr_27059_27085 = state_27054__$1;
(statearr_27059_27085[(2)] = inst_27024);

(statearr_27059_27085[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (3))){
var inst_27052 = (state_27054[(2)]);
var state_27054__$1 = state_27054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27054__$1,inst_27052);
} else {
if((state_val_27055 === (12))){
var inst_27021 = (state_27054[(8)]);
var inst_27048 = (state_27054[(2)]);
var inst_27049 = fluree.db.util.async.throw_err(inst_27048);
var _ = (function (){var statearr_27060 = state_27054;
(statearr_27060[(4)] = cljs.core.rest((state_27054[(4)])));

return statearr_27060;
})();
var state_27054__$1 = (function (){var statearr_27061 = state_27054;
(statearr_27061[(9)] = inst_27049);

return statearr_27061;
})();
var statearr_27062_27086 = state_27054__$1;
(statearr_27062_27086[(2)] = inst_27021);

(statearr_27062_27086[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (2))){
var inst_27012 = (state_27054[(10)]);
var inst_27014 = (state_27054[(11)]);
var inst_27016 = (state_27054[(12)]);
var inst_27024 = (state_27054[(7)]);
var _ = (function (){var statearr_27063 = state_27054;
(statearr_27063[(4)] = cljs.core.cons((5),(state_27054[(4)])));

return statearr_27063;
})();
var inst_27006 = db;
var inst_27007 = cljs.core.__destructure_map(inst_27006);
var inst_27008 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$network);
var inst_27009 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$t);
var inst_27010 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$fork);
var inst_27011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$spot);
var inst_27012__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$stats);
var inst_27013 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$conn);
var inst_27014__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$block);
var inst_27015 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$psot);
var inst_27016__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$dbid);
var inst_27017 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$ecount);
var inst_27018 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$opst);
var inst_27019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$fork_DASH_block);
var inst_27020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27007,cljs.core.cst$kw$post);
var inst_27021 = fluree.db.storage.core.ledger_root_key(inst_27008,inst_27016__$1,inst_27014__$1);
var inst_27022 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_27023 = fluree.db.storage.core.child_data(inst_27015);
var inst_27024__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_27012__$1);
var state_27054__$1 = (function (){var statearr_27064 = state_27054;
(statearr_27064[(10)] = inst_27012__$1);

(statearr_27064[(13)] = inst_27018);

(statearr_27064[(14)] = inst_27010);

(statearr_27064[(15)] = inst_27023);

(statearr_27064[(16)] = inst_27013);

(statearr_27064[(17)] = inst_27011);

(statearr_27064[(11)] = inst_27014__$1);

(statearr_27064[(18)] = inst_27019);

(statearr_27064[(12)] = inst_27016__$1);

(statearr_27064[(8)] = inst_27021);

(statearr_27064[(7)] = inst_27024__$1);

(statearr_27064[(19)] = inst_27017);

(statearr_27064[(20)] = inst_27009);

(statearr_27064[(21)] = inst_27022);

(statearr_27064[(22)] = inst_27020);

return statearr_27064;
})();
if(cljs.core.truth_(inst_27024__$1)){
var statearr_27065_27087 = state_27054__$1;
(statearr_27065_27087[(1)] = (6));

} else {
var statearr_27066_27088 = state_27054__$1;
(statearr_27066_27088[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (11))){
var inst_27012 = (state_27054[(10)]);
var inst_27018 = (state_27054[(13)]);
var inst_27010 = (state_27054[(14)]);
var inst_27023 = (state_27054[(15)]);
var inst_27013 = (state_27054[(16)]);
var inst_27028 = (state_27054[(23)]);
var inst_27011 = (state_27054[(17)]);
var inst_27014 = (state_27054[(11)]);
var inst_27019 = (state_27054[(18)]);
var inst_27016 = (state_27054[(12)]);
var inst_27021 = (state_27054[(8)]);
var inst_27009 = (state_27054[(20)]);
var inst_27022 = (state_27054[(21)]);
var inst_27020 = (state_27054[(22)]);
var inst_27033 = (state_27054[(2)]);
var inst_27034 = fluree.db.storage.core.child_data(inst_27018);
var inst_27035 = fluree.db.storage.core.child_data(inst_27020);
var inst_27036 = fluree.db.util.core.current_time_millis();
var inst_27037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27038 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_27039 = (new cljs.core.PersistentVector(null,2,(5),inst_27037,inst_27038,null));
var inst_27040 = cljs.core.select_keys(inst_27012,inst_27039);
var inst_27041 = fluree.db.storage.core.child_data(inst_27011);
var inst_27042 = [inst_27014,inst_27023,inst_27016,inst_27028,inst_27033,inst_27034,inst_27035,inst_27009,inst_27036,inst_27010,inst_27019,inst_27040,inst_27041];
var inst_27043 = cljs.core.PersistentHashMap.fromArrays(inst_27022,inst_27042);
var inst_27044 = fluree.db.storage.core.serde(inst_27013);
var inst_27045 = fluree.db.serde.protocol._serialize_db_root(inst_27044,inst_27043);
var inst_27046 = fluree.db.storage.core.storage_write(inst_27013,inst_27021,inst_27045);
var state_27054__$1 = state_27054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27054__$1,(12),inst_27046);
} else {
if((state_val_27055 === (9))){
var inst_27029 = (state_27054[(24)]);
var state_27054__$1 = state_27054;
var statearr_27068_27089 = state_27054__$1;
(statearr_27068_27089[(2)] = inst_27029);

(statearr_27068_27089[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (5))){
var _ = (function (){var statearr_27069 = state_27054;
(statearr_27069[(4)] = cljs.core.rest((state_27054[(4)])));

return statearr_27069;
})();
var state_27054__$1 = state_27054;
var ex27067 = (state_27054__$1[(2)]);
var statearr_27070_27090 = state_27054__$1;
(statearr_27070_27090[(5)] = ex27067);


if((ex27067 instanceof Error)){
var statearr_27071_27091 = state_27054__$1;
(statearr_27071_27091[(1)] = (4));

(statearr_27071_27091[(5)] = null);

} else {
throw ex27067;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (10))){
var inst_27017 = (state_27054[(19)]);
var state_27054__$1 = state_27054;
var statearr_27072_27092 = state_27054__$1;
(statearr_27072_27092[(2)] = inst_27017);

(statearr_27072_27092[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27055 === (8))){
var inst_27029 = (state_27054[(24)]);
var inst_27028 = (state_27054[(2)]);
var inst_27029__$1 = custom_ecount;
var state_27054__$1 = (function (){var statearr_27073 = state_27054;
(statearr_27073[(23)] = inst_27028);

(statearr_27073[(24)] = inst_27029__$1);

return statearr_27073;
})();
if(cljs.core.truth_(inst_27029__$1)){
var statearr_27074_27093 = state_27054__$1;
(statearr_27074_27093[(1)] = (9));

} else {
var statearr_27075_27094 = state_27054__$1;
(statearr_27075_27094[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10798__auto__ = null;
var fluree$db$storage$core$state_machine__10798__auto____0 = (function (){
var statearr_27076 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27076[(0)] = fluree$db$storage$core$state_machine__10798__auto__);

(statearr_27076[(1)] = (1));

return statearr_27076;
});
var fluree$db$storage$core$state_machine__10798__auto____1 = (function (state_27054){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27054);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27077){var ex__10801__auto__ = e27077;
var statearr_27078_27095 = state_27054;
(statearr_27078_27095[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27054[(4)]))){
var statearr_27079_27096 = state_27054;
(statearr_27079_27096[(1)] = cljs.core.first((state_27054[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27097 = state_27054;
state_27054 = G__27097;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10798__auto__ = function(state_27054){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10798__auto____1.call(this,state_27054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10798__auto____0;
fluree$db$storage$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10798__auto____1;
return fluree$db$storage$core$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27080 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27080[(6)] = c__10835__auto__);

return statearr_27080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10835__auto___27156 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27130){
var state_val_27131 = (state_27130[(1)]);
if((state_val_27131 === (7))){
var inst_27110 = (state_27130[(7)]);
var state_27130__$1 = state_27130;
var statearr_27132_27157 = state_27130__$1;
(statearr_27132_27157[(2)] = inst_27110);

(statearr_27132_27157[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (1))){
var state_27130__$1 = state_27130;
var statearr_27133_27158 = state_27130__$1;
(statearr_27133_27158[(2)] = null);

(statearr_27133_27158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (4))){
var inst_27098 = (state_27130[(2)]);
var inst_27099 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_27100 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_27098);
var inst_27101 = cljs.core.async.close_BANG_(return_ch);
var state_27130__$1 = (function (){var statearr_27134 = state_27130;
(statearr_27134[(8)] = inst_27099);

(statearr_27134[(9)] = inst_27100);

return statearr_27134;
})();
var statearr_27135_27159 = state_27130__$1;
(statearr_27135_27159[(2)] = inst_27101);

(statearr_27135_27159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (6))){
var inst_27109 = (state_27130[(10)]);
var inst_27110 = (state_27130[(7)]);
var inst_27109__$1 = (state_27130[(2)]);
var inst_27110__$1 = (inst_27109__$1 == null);
var state_27130__$1 = (function (){var statearr_27136 = state_27130;
(statearr_27136[(10)] = inst_27109__$1);

(statearr_27136[(7)] = inst_27110__$1);

return statearr_27136;
})();
if(cljs.core.truth_(inst_27110__$1)){
var statearr_27137_27160 = state_27130__$1;
(statearr_27137_27160[(1)] = (7));

} else {
var statearr_27138_27161 = state_27130__$1;
(statearr_27138_27161[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (3))){
var inst_27128 = (state_27130[(2)]);
var state_27130__$1 = state_27130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27130__$1,inst_27128);
} else {
if((state_val_27131 === (12))){
var inst_27125 = (state_27130[(2)]);
var _ = (function (){var statearr_27139 = state_27130;
(statearr_27139[(4)] = cljs.core.rest((state_27130[(4)])));

return statearr_27139;
})();
var state_27130__$1 = state_27130;
var statearr_27140_27162 = state_27130__$1;
(statearr_27140_27162[(2)] = inst_27125);

(statearr_27140_27162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (2))){
var _ = (function (){var statearr_27141 = state_27130;
(statearr_27141[(4)] = cljs.core.cons((5),(state_27130[(4)])));

return statearr_27141;
})();
var inst_27107 = fluree.db.storage.core.storage_read(conn,key);
var state_27130__$1 = state_27130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27130__$1,(6),inst_27107);
} else {
if((state_val_27131 === (11))){
var inst_27109 = (state_27130[(10)]);
var inst_27119 = fluree.db.storage.core.serde(conn);
var inst_27120 = fluree.db.serde.protocol._deserialize_leaf(inst_27119,inst_27109);
var inst_27121 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_27120);
var inst_27122 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_27121);
var inst_27123 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_27122);
var state_27130__$1 = state_27130;
var statearr_27143_27163 = state_27130__$1;
(statearr_27143_27163[(2)] = inst_27123);

(statearr_27143_27163[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (9))){
var inst_27115 = (state_27130[(2)]);
var state_27130__$1 = state_27130;
if(cljs.core.truth_(inst_27115)){
var statearr_27144_27164 = state_27130__$1;
(statearr_27144_27164[(1)] = (10));

} else {
var statearr_27145_27165 = state_27130__$1;
(statearr_27145_27165[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (5))){
var _ = (function (){var statearr_27146 = state_27130;
(statearr_27146[(4)] = cljs.core.rest((state_27130[(4)])));

return statearr_27146;
})();
var state_27130__$1 = state_27130;
var ex27142 = (state_27130__$1[(2)]);
var statearr_27147_27166 = state_27130__$1;
(statearr_27147_27166[(5)] = ex27142);


var statearr_27148_27167 = state_27130__$1;
(statearr_27148_27167[(1)] = (4));

(statearr_27148_27167[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (10))){
var inst_27117 = cljs.core.async.close_BANG_(return_ch);
var state_27130__$1 = state_27130;
var statearr_27149_27168 = state_27130__$1;
(statearr_27149_27168[(2)] = inst_27117);

(statearr_27149_27168[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27131 === (8))){
var inst_27109 = (state_27130[(10)]);
var inst_27113 = (inst_27109 instanceof Error);
var state_27130__$1 = state_27130;
var statearr_27150_27169 = state_27130__$1;
(statearr_27150_27169[(2)] = inst_27113);

(statearr_27150_27169[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__10798__auto____0 = (function (){
var statearr_27151 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27151[(0)] = fluree$db$storage$core$reify_history_$_state_machine__10798__auto__);

(statearr_27151[(1)] = (1));

return statearr_27151;
});
var fluree$db$storage$core$reify_history_$_state_machine__10798__auto____1 = (function (state_27130){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27130);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27152){var ex__10801__auto__ = e27152;
var statearr_27153_27170 = state_27130;
(statearr_27153_27170[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27130[(4)]))){
var statearr_27154_27171 = state_27130;
(statearr_27154_27171[(1)] = cljs.core.first((state_27130[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27172 = state_27130;
state_27130 = G__27172;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__10798__auto__ = function(state_27130){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__10798__auto____1.call(this,state_27130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__10798__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__10798__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27155 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27155[(6)] = c__10835__auto___27156);

return statearr_27155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__27174 = arguments.length;
switch (G__27174) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4221__auto__ = (rhs == null);
if(and__4221__auto__){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10835__auto___27286 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27237){
var state_val_27238 = (state_27237[(1)]);
if((state_val_27238 === (7))){
var state_27237__$1 = state_27237;
var statearr_27239_27287 = state_27237__$1;
(statearr_27239_27287[(2)] = cljs.core.cst$kw$novelty);

(statearr_27239_27287[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (20))){
var inst_27216 = cljs.core.PersistentVector.EMPTY;
var state_27237__$1 = state_27237;
var statearr_27240_27288 = state_27237__$1;
(statearr_27240_27288[(2)] = inst_27216);

(statearr_27240_27288[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (1))){
var state_27237__$1 = state_27237;
var statearr_27241_27289 = state_27237__$1;
(statearr_27241_27289[(2)] = null);

(statearr_27241_27289[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (24))){
var state_27237__$1 = state_27237;
var statearr_27242_27290 = state_27237__$1;
(statearr_27242_27290[(2)] = null);

(statearr_27242_27290[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (4))){
var inst_27177 = (state_27237[(2)]);
var inst_27178 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_27179 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_27177);
var inst_27180 = cljs.core.async.close_BANG_(result_ch);
var state_27237__$1 = (function (){var statearr_27243 = state_27237;
(statearr_27243[(7)] = inst_27179);

(statearr_27243[(8)] = inst_27178);

return statearr_27243;
})();
var statearr_27244_27291 = state_27237__$1;
(statearr_27244_27291[(2)] = inst_27180);

(statearr_27244_27291[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (15))){
var inst_27202 = (state_27237[(2)]);
var state_27237__$1 = state_27237;
var statearr_27245_27292 = state_27237__$1;
(statearr_27245_27292[(2)] = inst_27202);

(statearr_27245_27292[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (21))){
var inst_27189 = (state_27237[(9)]);
var inst_27191 = (state_27237[(10)]);
var inst_27190 = (state_27237[(11)]);
var inst_27219 = (state_27237[(12)]);
var inst_27206 = (state_27237[(13)]);
var inst_27226 = (state_27237[(2)]);
var inst_27227 = (function (){var base_node = inst_27189;
var first_flake = inst_27190;
var node_t = inst_27191;
var source = inst_27206;
var coll = inst_27219;
var conj_QMARK_ = inst_27226;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__27247 = f.p;
var fexpr__27246 = (function (){var or__4223__auto__ = remove_preds;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__27246.cljs$core$IFn$_invoke$arity$1 ? fexpr__27246.cljs$core$IFn$_invoke$arity$1(G__27247) : fexpr__27246.call(null,G__27247));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_27228 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_27189);
var inst_27229 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27227,inst_27228,inst_27219);
var inst_27230 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_27229);
var inst_27231 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27189,cljs.core.cst$kw$flakes,inst_27230);
var inst_27232 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_27231);
var _ = (function (){var statearr_27248 = state_27237;
(statearr_27248[(4)] = cljs.core.rest((state_27237[(4)])));

return statearr_27248;
})();
var state_27237__$1 = state_27237;
var statearr_27249_27293 = state_27237__$1;
(statearr_27249_27293[(2)] = inst_27232);

(statearr_27249_27293[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (13))){
var state_27237__$1 = state_27237;
var statearr_27250_27294 = state_27237__$1;
(statearr_27250_27294[(2)] = cljs.core.cst$kw$none);

(statearr_27250_27294[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (22))){
var inst_27189 = (state_27237[(9)]);
var inst_27191 = (state_27237[(10)]);
var inst_27190 = (state_27237[(11)]);
var inst_27219 = (state_27237[(12)]);
var inst_27206 = (state_27237[(13)]);
var inst_27220 = (function (){var base_node = inst_27189;
var first_flake = inst_27190;
var node_t = inst_27191;
var source = inst_27206;
var coll = inst_27219;
return (function (f){
return f.op === true;
});
})();
var state_27237__$1 = state_27237;
var statearr_27251_27295 = state_27237__$1;
(statearr_27251_27295[(2)] = inst_27220);

(statearr_27251_27295[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (6))){
var inst_27189 = (state_27237[(9)]);
var inst_27191 = (state_27237[(10)]);
var inst_27188 = (state_27237[(2)]);
var inst_27189__$1 = fluree.db.util.async.throw_err(inst_27188);
var inst_27190 = fluree.db.dbproto._first_flake(inst_27189__$1);
var inst_27191__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_27189__$1);
var inst_27192 = (inst_27191__$1 > t);
var state_27237__$1 = (function (){var statearr_27252 = state_27237;
(statearr_27252[(9)] = inst_27189__$1);

(statearr_27252[(10)] = inst_27191__$1);

(statearr_27252[(11)] = inst_27190);

return statearr_27252;
})();
if(cljs.core.truth_(inst_27192)){
var statearr_27253_27296 = state_27237__$1;
(statearr_27253_27296[(1)] = (7));

} else {
var statearr_27254_27297 = state_27237__$1;
(statearr_27254_27297[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (17))){
var inst_27190 = (state_27237[(11)]);
var inst_27207 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_27190,rhs,leftmost_QMARK_,t);
var state_27237__$1 = state_27237;
var statearr_27255_27298 = state_27237__$1;
(statearr_27255_27298[(2)] = inst_27207);

(statearr_27255_27298[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (3))){
var inst_27235 = (state_27237[(2)]);
var state_27237__$1 = state_27237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27237__$1,inst_27235);
} else {
if((state_val_27238 === (12))){
var inst_27204 = (state_27237[(2)]);
var state_27237__$1 = state_27237;
var statearr_27256_27299 = state_27237__$1;
(statearr_27256_27299[(2)] = inst_27204);

(statearr_27256_27299[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (2))){
var _ = (function (){var statearr_27257 = state_27237;
(statearr_27257[(4)] = cljs.core.cons((5),(state_27237[(4)])));

return statearr_27257;
})();
var inst_27186 = fluree.db.dbproto._resolve(node);
var state_27237__$1 = state_27237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27237__$1,(6),inst_27186);
} else {
if((state_val_27238 === (23))){
var inst_27189 = (state_27237[(9)]);
var inst_27191 = (state_27237[(10)]);
var inst_27190 = (state_27237[(11)]);
var inst_27219 = (state_27237[(12)]);
var inst_27206 = (state_27237[(13)]);
var inst_27222 = (function (){var base_node = inst_27189;
var first_flake = inst_27190;
var node_t = inst_27191;
var source = inst_27206;
var coll = inst_27219;
return (function (f){
return f.op === false;
});
})();
var state_27237__$1 = state_27237;
var statearr_27258_27300 = state_27237__$1;
(statearr_27258_27300[(2)] = inst_27222);

(statearr_27258_27300[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (19))){
var inst_27209 = (state_27237[(14)]);
var inst_27212 = (state_27237[(2)]);
var inst_27213 = fluree.db.util.async.throw_err(inst_27212);
var inst_27214 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_27209,inst_27213);
var state_27237__$1 = state_27237;
var statearr_27259_27301 = state_27237__$1;
(statearr_27259_27301[(2)] = inst_27214);

(statearr_27259_27301[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (11))){
var inst_27191 = (state_27237[(10)]);
var inst_27198 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27191,t);
var state_27237__$1 = state_27237;
if(inst_27198){
var statearr_27261_27302 = state_27237__$1;
(statearr_27261_27302[(1)] = (13));

} else {
var statearr_27262_27303 = state_27237__$1;
(statearr_27262_27303[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (9))){
var inst_27206 = (state_27237[(13)]);
var inst_27206__$1 = (state_27237[(2)]);
var state_27237__$1 = (function (){var statearr_27263 = state_27237;
(statearr_27263[(13)] = inst_27206__$1);

return statearr_27263;
})();
var G__27264_27304 = inst_27206__$1;
var G__27264_27305__$1 = (((G__27264_27304 instanceof cljs.core.Keyword))?G__27264_27304.fqn:null);
switch (G__27264_27305__$1) {
case "novelty":
var statearr_27265_27307 = state_27237__$1;
(statearr_27265_27307[(1)] = (17));


break;
case "history":
var statearr_27266_27308 = state_27237__$1;
(statearr_27266_27308[(1)] = (18));


break;
case "none":
var statearr_27267_27309 = state_27237__$1;
(statearr_27267_27309[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27264_27305__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (5))){
var _ = (function (){var statearr_27268 = state_27237;
(statearr_27268[(4)] = cljs.core.rest((state_27237[(4)])));

return statearr_27268;
})();
var state_27237__$1 = state_27237;
var ex27260 = (state_27237__$1[(2)]);
var statearr_27269_27310 = state_27237__$1;
(statearr_27269_27310[(5)] = ex27260);


var statearr_27270_27311 = state_27237__$1;
(statearr_27270_27311[(1)] = (4));

(statearr_27270_27311[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (14))){
var state_27237__$1 = state_27237;
var statearr_27271_27312 = state_27237__$1;
(statearr_27271_27312[(2)] = null);

(statearr_27271_27312[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (16))){
var inst_27206 = (state_27237[(13)]);
var inst_27219 = (state_27237[(2)]);
var state_27237__$1 = (function (){var statearr_27272 = state_27237;
(statearr_27272[(12)] = inst_27219);

return statearr_27272;
})();
var G__27273_27313 = inst_27206;
var G__27273_27314__$1 = (((G__27273_27313 instanceof cljs.core.Keyword))?G__27273_27313.fqn:null);
switch (G__27273_27314__$1) {
case "novelty":
var statearr_27274_27316 = state_27237__$1;
(statearr_27274_27316[(1)] = (22));


break;
case "history":
var statearr_27275_27317 = state_27237__$1;
(statearr_27275_27317[(1)] = (23));


break;
case "none":
var statearr_27276_27318 = state_27237__$1;
(statearr_27276_27318[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27273_27314__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (10))){
var state_27237__$1 = state_27237;
var statearr_27277_27319 = state_27237__$1;
(statearr_27277_27319[(2)] = cljs.core.cst$kw$history);

(statearr_27277_27319[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27238 === (18))){
var inst_27189 = (state_27237[(9)]);
var inst_27191 = (state_27237[(10)]);
var inst_27190 = (state_27237[(11)]);
var inst_27206 = (state_27237[(13)]);
var inst_27209 = (function (){var base_node = inst_27189;
var first_flake = inst_27190;
var node_t = inst_27191;
var source = inst_27206;
return (function (p1__27176_SHARP_){
return (p1__27176_SHARP_.t <= t);
});
})();
var inst_27210 = fluree.db.dbproto._resolve_history(node);
var state_27237__$1 = (function (){var statearr_27278 = state_27237;
(statearr_27278[(14)] = inst_27209);

return statearr_27278;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27237__$1,(19),inst_27210);
} else {
if((state_val_27238 === (8))){
var inst_27191 = (state_27237[(10)]);
var inst_27195 = (inst_27191 < t);
var state_27237__$1 = state_27237;
if(cljs.core.truth_(inst_27195)){
var statearr_27279_27320 = state_27237__$1;
(statearr_27279_27320[(1)] = (10));

} else {
var statearr_27280_27321 = state_27237__$1;
(statearr_27280_27321[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__10798__auto____0 = (function (){
var statearr_27281 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27281[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__10798__auto__);

(statearr_27281[(1)] = (1));

return statearr_27281;
});
var fluree$db$storage$core$resolve_t_$_state_machine__10798__auto____1 = (function (state_27237){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27237);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27282){var ex__10801__auto__ = e27282;
var statearr_27283_27322 = state_27237;
(statearr_27283_27322[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27237[(4)]))){
var statearr_27284_27323 = state_27237;
(statearr_27284_27323[(1)] = cljs.core.first((state_27237[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27324 = state_27237;
state_27237 = G__27324;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__10798__auto__ = function(state_27237){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__10798__auto____1.call(this,state_27237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__10798__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__10798__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27285 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27285[(6)] = c__10835__auto___27286);

return statearr_27285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27384){
var state_val_27385 = (state_27384[(1)]);
if((state_val_27385 === (7))){
var inst_27335 = (state_27384[(7)]);
var inst_27339 = (inst_27335 <= from_t);
var state_27384__$1 = state_27384;
var statearr_27386_27426 = state_27384__$1;
(statearr_27386_27426[(2)] = inst_27339);

(statearr_27386_27426[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (20))){
var inst_27369 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_27370 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27369)].join('');
var inst_27371 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_27372 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_27373 = cljs.core.PersistentHashMap.fromArrays(inst_27371,inst_27372);
var inst_27374 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27370,inst_27373);
var inst_27375 = (function(){throw inst_27374})();
var state_27384__$1 = state_27384;
var statearr_27387_27427 = state_27384__$1;
(statearr_27387_27427[(2)] = inst_27375);

(statearr_27387_27427[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (1))){
var state_27384__$1 = state_27384;
var statearr_27388_27428 = state_27384__$1;
(statearr_27388_27428[(2)] = null);

(statearr_27388_27428[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (4))){
var inst_27327 = (state_27384[(2)]);
var inst_27328 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27327], 0));
var inst_27329 = (function(){throw inst_27327})();
var state_27384__$1 = (function (){var statearr_27389 = state_27384;
(statearr_27389[(8)] = inst_27328);

return statearr_27389;
})();
var statearr_27390_27429 = state_27384__$1;
(statearr_27390_27429[(2)] = inst_27329);

(statearr_27390_27429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (15))){
var inst_27354 = (state_27384[(2)]);
var state_27384__$1 = (function (){var statearr_27391 = state_27384;
(statearr_27391[(9)] = inst_27354);

return statearr_27391;
})();
if(cljs.core.truth_(from_t)){
var statearr_27392_27430 = state_27384__$1;
(statearr_27392_27430[(1)] = (16));

} else {
var statearr_27393_27431 = state_27384__$1;
(statearr_27393_27431[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (21))){
var inst_27365 = (state_27384[(10)]);
var inst_27363 = (state_27384[(11)]);
var inst_27364 = (state_27384[(12)]);
var inst_27377 = (state_27384[(2)]);
var inst_27378 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_27364,inst_27365,leftmost_QMARK_,to_t);
var inst_27379 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27378,inst_27363);
var _ = (function (){var statearr_27394 = state_27384;
(statearr_27394[(4)] = cljs.core.rest((state_27384[(4)])));

return statearr_27394;
})();
var state_27384__$1 = (function (){var statearr_27395 = state_27384;
(statearr_27395[(13)] = inst_27377);

return statearr_27395;
})();
var statearr_27396_27432 = state_27384__$1;
(statearr_27396_27432[(2)] = inst_27379);

(statearr_27396_27432[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (13))){
var inst_27335 = (state_27384[(7)]);
var inst_27347 = (state_27384[(14)]);
var inst_27350 = (function (){var node_t = inst_27335;
var G__27343 = inst_27347;
return (function (p1__27325_SHARP_){
return (p1__27325_SHARP_.t < to_t);
});
})();
var inst_27351 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_27350,inst_27347);
var state_27384__$1 = state_27384;
var statearr_27397_27433 = state_27384__$1;
(statearr_27397_27433[(2)] = inst_27351);

(statearr_27397_27433[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (6))){
var inst_27336 = (state_27384[(15)]);
var state_27384__$1 = state_27384;
var statearr_27398_27434 = state_27384__$1;
(statearr_27398_27434[(2)] = inst_27336);

(statearr_27398_27434[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (17))){
var inst_27354 = (state_27384[(9)]);
var state_27384__$1 = state_27384;
var statearr_27399_27435 = state_27384__$1;
(statearr_27399_27435[(2)] = inst_27354);

(statearr_27399_27435[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (3))){
var inst_27382 = (state_27384[(2)]);
var state_27384__$1 = state_27384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27384__$1,inst_27382);
} else {
if((state_val_27385 === (12))){
var inst_27335 = (state_27384[(7)]);
var inst_27346 = (state_27384[(2)]);
var inst_27347 = fluree.db.util.async.throw_err(inst_27346);
var inst_27348 = (to_t > inst_27335);
var state_27384__$1 = (function (){var statearr_27400 = state_27384;
(statearr_27400[(14)] = inst_27347);

return statearr_27400;
})();
if(cljs.core.truth_(inst_27348)){
var statearr_27401_27436 = state_27384__$1;
(statearr_27401_27436[(1)] = (13));

} else {
var statearr_27402_27437 = state_27384__$1;
(statearr_27402_27437[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (2))){
var inst_27336 = (state_27384[(15)]);
var _ = (function (){var statearr_27403 = state_27384;
(statearr_27403[(4)] = cljs.core.cons((5),(state_27384[(4)])));

return statearr_27403;
})();
var inst_27335 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_27336__$1 = (from_t == null);
var state_27384__$1 = (function (){var statearr_27404 = state_27384;
(statearr_27404[(7)] = inst_27335);

(statearr_27404[(15)] = inst_27336__$1);

return statearr_27404;
})();
if(cljs.core.truth_(inst_27336__$1)){
var statearr_27405_27438 = state_27384__$1;
(statearr_27405_27438[(1)] = (6));

} else {
var statearr_27406_27439 = state_27384__$1;
(statearr_27406_27439[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (19))){
var state_27384__$1 = state_27384;
var statearr_27407_27440 = state_27384__$1;
(statearr_27407_27440[(2)] = null);

(statearr_27407_27440[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (11))){
var inst_27363 = (state_27384[(2)]);
var inst_27364 = fluree.db.dbproto._first_flake(node);
var inst_27365 = fluree.db.dbproto._rhs(node);
var inst_27366 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_27384__$1 = (function (){var statearr_27409 = state_27384;
(statearr_27409[(10)] = inst_27365);

(statearr_27409[(11)] = inst_27363);

(statearr_27409[(12)] = inst_27364);

return statearr_27409;
})();
if(cljs.core.truth_(inst_27366)){
var statearr_27410_27441 = state_27384__$1;
(statearr_27410_27441[(1)] = (19));

} else {
var statearr_27411_27442 = state_27384__$1;
(statearr_27411_27442[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (9))){
var inst_27344 = fluree.db.dbproto._resolve_history(node);
var state_27384__$1 = state_27384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27384__$1,(12),inst_27344);
} else {
if((state_val_27385 === (5))){
var _ = (function (){var statearr_27412 = state_27384;
(statearr_27412[(4)] = cljs.core.rest((state_27384[(4)])));

return statearr_27412;
})();
var state_27384__$1 = state_27384;
var ex27408 = (state_27384__$1[(2)]);
var statearr_27413_27443 = state_27384__$1;
(statearr_27413_27443[(5)] = ex27408);


var statearr_27414_27444 = state_27384__$1;
(statearr_27414_27444[(1)] = (4));

(statearr_27414_27444[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (14))){
var inst_27347 = (state_27384[(14)]);
var state_27384__$1 = state_27384;
var statearr_27415_27445 = state_27384__$1;
(statearr_27415_27445[(2)] = inst_27347);

(statearr_27415_27445[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (16))){
var inst_27335 = (state_27384[(7)]);
var inst_27354 = (state_27384[(9)]);
var inst_27356 = (function (){var node_t = inst_27335;
var G__27343 = inst_27354;
return (function (p1__27326_SHARP_){
return (p1__27326_SHARP_.t <= from_t);
});
})();
var inst_27357 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_27356,inst_27354);
var state_27384__$1 = state_27384;
var statearr_27416_27446 = state_27384__$1;
(statearr_27416_27446[(2)] = inst_27357);

(statearr_27416_27446[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (10))){
var state_27384__$1 = state_27384;
var statearr_27417_27447 = state_27384__$1;
(statearr_27417_27447[(2)] = null);

(statearr_27417_27447[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (18))){
var inst_27360 = (state_27384[(2)]);
var state_27384__$1 = state_27384;
var statearr_27418_27448 = state_27384__$1;
(statearr_27418_27448[(2)] = inst_27360);

(statearr_27418_27448[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27385 === (8))){
var inst_27341 = (state_27384[(2)]);
var state_27384__$1 = state_27384;
if(cljs.core.truth_(inst_27341)){
var statearr_27419_27449 = state_27384__$1;
(statearr_27419_27449[(1)] = (9));

} else {
var statearr_27420_27450 = state_27384__$1;
(statearr_27420_27450[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto____0 = (function (){
var statearr_27421 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27421[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto__);

(statearr_27421[(1)] = (1));

return statearr_27421;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto____1 = (function (state_27384){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27384);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27422){var ex__10801__auto__ = e27422;
var statearr_27423_27451 = state_27384;
(statearr_27423_27451[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27384[(4)]))){
var statearr_27424_27452 = state_27384;
(statearr_27424_27452[(1)] = cljs.core.first((state_27384[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27453 = state_27384;
state_27384 = G__27453;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto__ = function(state_27384){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto____1.call(this,state_27384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27425 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27425[(6)] = c__10835__auto__);

return statearr_27425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4223__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__27454_27464 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__27455_27465 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27454_27464,G__27455_27465) : object_cache.call(null,G__27454_27464,G__27455_27465));

var G__27456 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__27457 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__27458 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__27459 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27458,G__27459) : object_cache.call(null,G__27458,G__27459));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27456,G__27457) : object_cache.call(null,G__27456,G__27457));
} else {
var G__27460 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__27461 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__27462 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__27463 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27462,G__27463) : object_cache.call(null,G__27462,G__27463));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27460,G__27461) : object_cache.call(null,G__27460,G__27461));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27486){
var state_val_27487 = (state_27486[(1)]);
if((state_val_27487 === (7))){
var state_27486__$1 = state_27486;
var statearr_27488_27508 = state_27486__$1;
(statearr_27488_27508[(2)] = null);

(statearr_27488_27508[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27487 === (1))){
var state_27486__$1 = state_27486;
var statearr_27489_27509 = state_27486__$1;
(statearr_27489_27509[(2)] = null);

(statearr_27489_27509[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27487 === (4))){
var inst_27466 = (state_27486[(2)]);
var state_27486__$1 = state_27486;
var statearr_27490_27510 = state_27486__$1;
(statearr_27490_27510[(2)] = inst_27466);

(statearr_27490_27510[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27487 === (6))){
var inst_27472 = (state_27486[(7)]);
var inst_27474 = fluree.db.storage.core.serde(conn);
var state_27486__$1 = (function (){var statearr_27491 = state_27486;
(statearr_27491[(8)] = inst_27474);

return statearr_27491;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27486__$1,(9),inst_27472);
} else {
if((state_val_27487 === (3))){
var inst_27484 = (state_27486[(2)]);
var state_27486__$1 = state_27486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27486__$1,inst_27484);
} else {
if((state_val_27487 === (2))){
var inst_27472 = (state_27486[(7)]);
var _ = (function (){var statearr_27493 = state_27486;
(statearr_27493[(4)] = cljs.core.cons((5),(state_27486[(4)])));

return statearr_27493;
})();
var inst_27472__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_27486__$1 = (function (){var statearr_27494 = state_27486;
(statearr_27494[(7)] = inst_27472__$1);

return statearr_27494;
})();
if(cljs.core.truth_(inst_27472__$1)){
var statearr_27495_27511 = state_27486__$1;
(statearr_27495_27511[(1)] = (6));

} else {
var statearr_27496_27512 = state_27486__$1;
(statearr_27496_27512[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27487 === (9))){
var inst_27474 = (state_27486[(8)]);
var inst_27476 = (state_27486[(2)]);
var inst_27477 = fluree.db.util.async.throw_err(inst_27476);
var inst_27478 = fluree.db.serde.protocol._deserialize_branch(inst_27474,inst_27477);
var state_27486__$1 = state_27486;
var statearr_27497_27513 = state_27486__$1;
(statearr_27497_27513[(2)] = inst_27478);

(statearr_27497_27513[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27487 === (5))){
var _ = (function (){var statearr_27498 = state_27486;
(statearr_27498[(4)] = cljs.core.rest((state_27486[(4)])));

return statearr_27498;
})();
var state_27486__$1 = state_27486;
var ex27492 = (state_27486__$1[(2)]);
var statearr_27499_27514 = state_27486__$1;
(statearr_27499_27514[(5)] = ex27492);


if((ex27492 instanceof Error)){
var statearr_27500_27515 = state_27486__$1;
(statearr_27500_27515[(1)] = (4));

(statearr_27500_27515[(5)] = null);

} else {
throw ex27492;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27487 === (8))){
var inst_27481 = (state_27486[(2)]);
var _ = (function (){var statearr_27501 = state_27486;
(statearr_27501[(4)] = cljs.core.rest((state_27486[(4)])));

return statearr_27501;
})();
var state_27486__$1 = state_27486;
var statearr_27502_27516 = state_27486__$1;
(statearr_27502_27516[(2)] = inst_27481);

(statearr_27502_27516[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__10798__auto____0 = (function (){
var statearr_27503 = [null,null,null,null,null,null,null,null,null];
(statearr_27503[(0)] = fluree$db$storage$core$read_branch_$_state_machine__10798__auto__);

(statearr_27503[(1)] = (1));

return statearr_27503;
});
var fluree$db$storage$core$read_branch_$_state_machine__10798__auto____1 = (function (state_27486){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27486);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27504){var ex__10801__auto__ = e27504;
var statearr_27505_27517 = state_27486;
(statearr_27505_27517[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27486[(4)]))){
var statearr_27506_27518 = state_27486;
(statearr_27506_27518[(1)] = cljs.core.first((state_27486[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27519 = state_27486;
state_27486 = G__27519;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__10798__auto__ = function(state_27486){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__10798__auto____1.call(this,state_27486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__10798__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__10798__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27507 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27507[(6)] = c__10835__auto__);

return statearr_27507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10835__auto___27598 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27570){
var state_val_27571 = (state_27570[(1)]);
if((state_val_27571 === (7))){
var inst_27537 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_27538 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_27539 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_27540 = cljs.core.PersistentHashMap.fromArrays(inst_27538,inst_27539);
var inst_27541 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27537,inst_27540);
var inst_27542 = (function(){throw inst_27541})();
var state_27570__$1 = state_27570;
var statearr_27572_27599 = state_27570__$1;
(statearr_27572_27599[(2)] = inst_27542);

(statearr_27572_27599[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (1))){
var state_27570__$1 = state_27570;
var statearr_27573_27600 = state_27570__$1;
(statearr_27573_27600[(2)] = null);

(statearr_27573_27600[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (4))){
var inst_27520 = (state_27570[(2)]);
var inst_27521 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_27522 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_27520);
var inst_27523 = cljs.core.async.close_BANG_(return_ch);
var state_27570__$1 = (function (){var statearr_27574 = state_27570;
(statearr_27574[(7)] = inst_27522);

(statearr_27574[(8)] = inst_27521);

return statearr_27574;
})();
var statearr_27575_27601 = state_27570__$1;
(statearr_27575_27601[(2)] = inst_27523);

(statearr_27575_27601[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (6))){
var inst_27534 = (state_27570[(9)]);
var inst_27533 = (state_27570[(2)]);
var inst_27534__$1 = fluree.db.util.async.throw_err(inst_27533);
var inst_27535 = (inst_27534__$1 == null);
var state_27570__$1 = (function (){var statearr_27576 = state_27570;
(statearr_27576[(9)] = inst_27534__$1);

return statearr_27576;
})();
if(cljs.core.truth_(inst_27535)){
var statearr_27577_27602 = state_27570__$1;
(statearr_27577_27602[(1)] = (7));

} else {
var statearr_27578_27603 = state_27570__$1;
(statearr_27578_27603[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (3))){
var inst_27568 = (state_27570[(2)]);
var state_27570__$1 = state_27570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27570__$1,inst_27568);
} else {
if((state_val_27571 === (12))){
var inst_27534 = (state_27570[(9)]);
var inst_27551 = (state_27570[(2)]);
var inst_27552 = cljs.core.__destructure_map(inst_27534);
var inst_27553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27552,cljs.core.cst$kw$children);
var inst_27554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27552,cljs.core.cst$kw$rhs);
var inst_27555 = config;
var inst_27556 = cljs.core.__destructure_map(inst_27555);
var inst_27557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27556,cljs.core.cst$kw$comparator);
var inst_27559 = (function (){var data = inst_27534;
var _ = inst_27551;
var map__27529 = inst_27552;
var children = inst_27553;
var rhs = inst_27554;
var map__27530 = inst_27556;
var comparator = inst_27557;
return (function (idx,p__27558){
var map__27579 = p__27558;
var map__27579__$1 = cljs.core.__destructure_map(map__27579);
var child = map__27579__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27579__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27579__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27579__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27579__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27579__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4221__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (idx === (0));
} else {
return and__4221__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_27560 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_27559,inst_27553);
var inst_27561 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_27560);
var inst_27562 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_27561,inst_27560);
var inst_27563 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_27557,inst_27562);
var inst_27564 = fluree.db.index.__GT_IndexNode(block,t,inst_27554,inst_27563,config,leftmost_QMARK_);
var inst_27565 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_27564);
var _ = (function (){var statearr_27580 = state_27570;
(statearr_27580[(4)] = cljs.core.rest((state_27570[(4)])));

return statearr_27580;
})();
var state_27570__$1 = state_27570;
var statearr_27581_27604 = state_27570__$1;
(statearr_27581_27604[(2)] = inst_27565);

(statearr_27581_27604[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (2))){
var _ = (function (){var statearr_27582 = state_27570;
(statearr_27582[(4)] = cljs.core.cons((5),(state_27570[(4)])));

return statearr_27582;
})();
var inst_27531 = fluree.db.storage.core.read_branch(conn,key);
var state_27570__$1 = state_27570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27570__$1,(6),inst_27531);
} else {
if((state_val_27571 === (11))){
var state_27570__$1 = state_27570;
var statearr_27584_27605 = state_27570__$1;
(statearr_27584_27605[(2)] = null);

(statearr_27584_27605[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (9))){
var inst_27534 = (state_27570[(9)]);
var inst_27545 = (state_27570[(2)]);
var inst_27546 = fluree.db.util.core.exception_QMARK_(inst_27534);
var state_27570__$1 = (function (){var statearr_27585 = state_27570;
(statearr_27585[(10)] = inst_27545);

return statearr_27585;
})();
if(inst_27546){
var statearr_27586_27606 = state_27570__$1;
(statearr_27586_27606[(1)] = (10));

} else {
var statearr_27587_27607 = state_27570__$1;
(statearr_27587_27607[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (5))){
var _ = (function (){var statearr_27588 = state_27570;
(statearr_27588[(4)] = cljs.core.rest((state_27570[(4)])));

return statearr_27588;
})();
var state_27570__$1 = state_27570;
var ex27583 = (state_27570__$1[(2)]);
var statearr_27589_27608 = state_27570__$1;
(statearr_27589_27608[(5)] = ex27583);


var statearr_27590_27609 = state_27570__$1;
(statearr_27590_27609[(1)] = (4));

(statearr_27590_27609[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (10))){
var inst_27534 = (state_27570[(9)]);
var inst_27548 = (function(){throw inst_27534})();
var state_27570__$1 = state_27570;
var statearr_27591_27610 = state_27570__$1;
(statearr_27591_27610[(2)] = inst_27548);

(statearr_27591_27610[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27571 === (8))){
var state_27570__$1 = state_27570;
var statearr_27592_27611 = state_27570__$1;
(statearr_27592_27611[(2)] = null);

(statearr_27592_27611[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__10798__auto____0 = (function (){
var statearr_27593 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27593[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__10798__auto__);

(statearr_27593[(1)] = (1));

return statearr_27593;
});
var fluree$db$storage$core$reify_branch_$_state_machine__10798__auto____1 = (function (state_27570){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27570);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27594){var ex__10801__auto__ = e27594;
var statearr_27595_27612 = state_27570;
(statearr_27595_27612[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27570[(4)]))){
var statearr_27596_27613 = state_27570;
(statearr_27596_27613[(1)] = cljs.core.first((state_27570[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27614 = state_27570;
state_27570 = G__27614;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__10798__auto__ = function(state_27570){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__10798__auto____1.call(this,state_27570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__10798__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__10798__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27597 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27597[(6)] = c__10835__auto___27598);

return statearr_27597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27635){
var state_val_27636 = (state_27635[(1)]);
if((state_val_27636 === (7))){
var state_27635__$1 = state_27635;
var statearr_27637_27657 = state_27635__$1;
(statearr_27637_27657[(2)] = null);

(statearr_27637_27657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27636 === (1))){
var state_27635__$1 = state_27635;
var statearr_27638_27658 = state_27635__$1;
(statearr_27638_27658[(2)] = null);

(statearr_27638_27658[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27636 === (4))){
var inst_27615 = (state_27635[(2)]);
var state_27635__$1 = state_27635;
var statearr_27639_27659 = state_27635__$1;
(statearr_27639_27659[(2)] = inst_27615);

(statearr_27639_27659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27636 === (6))){
var inst_27621 = (state_27635[(7)]);
var inst_27623 = fluree.db.storage.core.serde(conn);
var state_27635__$1 = (function (){var statearr_27640 = state_27635;
(statearr_27640[(8)] = inst_27623);

return statearr_27640;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27635__$1,(9),inst_27621);
} else {
if((state_val_27636 === (3))){
var inst_27633 = (state_27635[(2)]);
var state_27635__$1 = state_27635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27635__$1,inst_27633);
} else {
if((state_val_27636 === (2))){
var inst_27621 = (state_27635[(7)]);
var _ = (function (){var statearr_27642 = state_27635;
(statearr_27642[(4)] = cljs.core.cons((5),(state_27635[(4)])));

return statearr_27642;
})();
var inst_27621__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_27635__$1 = (function (){var statearr_27643 = state_27635;
(statearr_27643[(7)] = inst_27621__$1);

return statearr_27643;
})();
if(cljs.core.truth_(inst_27621__$1)){
var statearr_27644_27660 = state_27635__$1;
(statearr_27644_27660[(1)] = (6));

} else {
var statearr_27645_27661 = state_27635__$1;
(statearr_27645_27661[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27636 === (9))){
var inst_27623 = (state_27635[(8)]);
var inst_27625 = (state_27635[(2)]);
var inst_27626 = fluree.db.util.async.throw_err(inst_27625);
var inst_27627 = fluree.db.serde.protocol._deserialize_leaf(inst_27623,inst_27626);
var state_27635__$1 = state_27635;
var statearr_27646_27662 = state_27635__$1;
(statearr_27646_27662[(2)] = inst_27627);

(statearr_27646_27662[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27636 === (5))){
var _ = (function (){var statearr_27647 = state_27635;
(statearr_27647[(4)] = cljs.core.rest((state_27635[(4)])));

return statearr_27647;
})();
var state_27635__$1 = state_27635;
var ex27641 = (state_27635__$1[(2)]);
var statearr_27648_27663 = state_27635__$1;
(statearr_27648_27663[(5)] = ex27641);


if((ex27641 instanceof Error)){
var statearr_27649_27664 = state_27635__$1;
(statearr_27649_27664[(1)] = (4));

(statearr_27649_27664[(5)] = null);

} else {
throw ex27641;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27636 === (8))){
var inst_27630 = (state_27635[(2)]);
var _ = (function (){var statearr_27650 = state_27635;
(statearr_27650[(4)] = cljs.core.rest((state_27635[(4)])));

return statearr_27650;
})();
var state_27635__$1 = state_27635;
var statearr_27651_27665 = state_27635__$1;
(statearr_27651_27665[(2)] = inst_27630);

(statearr_27651_27665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__10798__auto____0 = (function (){
var statearr_27652 = [null,null,null,null,null,null,null,null,null];
(statearr_27652[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__10798__auto__);

(statearr_27652[(1)] = (1));

return statearr_27652;
});
var fluree$db$storage$core$read_leaf_$_state_machine__10798__auto____1 = (function (state_27635){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27635);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27653){var ex__10801__auto__ = e27653;
var statearr_27654_27666 = state_27635;
(statearr_27654_27666[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27635[(4)]))){
var statearr_27655_27667 = state_27635;
(statearr_27655_27667[(1)] = cljs.core.first((state_27635[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27668 = state_27635;
state_27635 = G__27668;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__10798__auto__ = function(state_27635){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__10798__auto____1.call(this,state_27635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__10798__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__10798__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27656 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27656[(6)] = c__10835__auto__);

return statearr_27656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10835__auto___27741 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27713){
var state_val_27714 = (state_27713[(1)]);
if((state_val_27714 === (7))){
var inst_27685 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_27686 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_27687 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_27688 = cljs.core.PersistentHashMap.fromArrays(inst_27686,inst_27687);
var inst_27689 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27685,inst_27688);
var inst_27690 = (function(){throw inst_27689})();
var state_27713__$1 = state_27713;
var statearr_27715_27742 = state_27713__$1;
(statearr_27715_27742[(2)] = inst_27690);

(statearr_27715_27742[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (1))){
var state_27713__$1 = state_27713;
var statearr_27716_27743 = state_27713__$1;
(statearr_27716_27743[(2)] = null);

(statearr_27716_27743[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (4))){
var inst_27669 = (state_27713[(2)]);
var inst_27670 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_27671 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_27669);
var inst_27672 = cljs.core.async.close_BANG_(return_ch);
var state_27713__$1 = (function (){var statearr_27717 = state_27713;
(statearr_27717[(7)] = inst_27670);

(statearr_27717[(8)] = inst_27671);

return statearr_27717;
})();
var statearr_27718_27744 = state_27713__$1;
(statearr_27718_27744[(2)] = inst_27672);

(statearr_27718_27744[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (6))){
var inst_27682 = (state_27713[(9)]);
var inst_27682__$1 = (state_27713[(2)]);
var inst_27683 = (inst_27682__$1 == null);
var state_27713__$1 = (function (){var statearr_27719 = state_27713;
(statearr_27719[(9)] = inst_27682__$1);

return statearr_27719;
})();
if(cljs.core.truth_(inst_27683)){
var statearr_27720_27745 = state_27713__$1;
(statearr_27720_27745[(1)] = (7));

} else {
var statearr_27721_27746 = state_27713__$1;
(statearr_27721_27746[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (3))){
var inst_27711 = (state_27713[(2)]);
var state_27713__$1 = state_27713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27713__$1,inst_27711);
} else {
if((state_val_27714 === (12))){
var inst_27682 = (state_27713[(9)]);
var inst_27699 = (state_27713[(2)]);
var inst_27700 = cljs.core.__destructure_map(inst_27682);
var inst_27701 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27700,cljs.core.cst$kw$flakes);
var inst_27702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27700,cljs.core.cst$kw$his);
var inst_27703 = config;
var inst_27704 = cljs.core.__destructure_map(inst_27703);
var inst_27705 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27704,cljs.core.cst$kw$comparator);
var inst_27706 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_27705,inst_27701);
var inst_27707 = fluree.db.index.data_node(block,t,inst_27706,rhs,config);
var inst_27708 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_27707);
var _ = (function (){var statearr_27722 = state_27713;
(statearr_27722[(4)] = cljs.core.rest((state_27713[(4)])));

return statearr_27722;
})();
var state_27713__$1 = (function (){var statearr_27723 = state_27713;
(statearr_27723[(10)] = inst_27702);

(statearr_27723[(11)] = inst_27699);

return statearr_27723;
})();
var statearr_27724_27747 = state_27713__$1;
(statearr_27724_27747[(2)] = inst_27708);

(statearr_27724_27747[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (2))){
var _ = (function (){var statearr_27725 = state_27713;
(statearr_27725[(4)] = cljs.core.cons((5),(state_27713[(4)])));

return statearr_27725;
})();
var inst_27680 = fluree.db.storage.core.read_leaf(conn,key);
var state_27713__$1 = state_27713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27713__$1,(6),inst_27680);
} else {
if((state_val_27714 === (11))){
var state_27713__$1 = state_27713;
var statearr_27727_27748 = state_27713__$1;
(statearr_27727_27748[(2)] = null);

(statearr_27727_27748[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (9))){
var inst_27682 = (state_27713[(9)]);
var inst_27693 = (state_27713[(2)]);
var inst_27694 = fluree.db.util.core.exception_QMARK_(inst_27682);
var state_27713__$1 = (function (){var statearr_27728 = state_27713;
(statearr_27728[(12)] = inst_27693);

return statearr_27728;
})();
if(inst_27694){
var statearr_27729_27749 = state_27713__$1;
(statearr_27729_27749[(1)] = (10));

} else {
var statearr_27730_27750 = state_27713__$1;
(statearr_27730_27750[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (5))){
var _ = (function (){var statearr_27731 = state_27713;
(statearr_27731[(4)] = cljs.core.rest((state_27713[(4)])));

return statearr_27731;
})();
var state_27713__$1 = state_27713;
var ex27726 = (state_27713__$1[(2)]);
var statearr_27732_27751 = state_27713__$1;
(statearr_27732_27751[(5)] = ex27726);


var statearr_27733_27752 = state_27713__$1;
(statearr_27733_27752[(1)] = (4));

(statearr_27733_27752[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (10))){
var inst_27682 = (state_27713[(9)]);
var inst_27696 = (function(){throw inst_27682})();
var state_27713__$1 = state_27713;
var statearr_27734_27753 = state_27713__$1;
(statearr_27734_27753[(2)] = inst_27696);

(statearr_27734_27753[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27714 === (8))){
var state_27713__$1 = state_27713;
var statearr_27735_27754 = state_27713__$1;
(statearr_27735_27754[(2)] = null);

(statearr_27735_27754[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto____0 = (function (){
var statearr_27736 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27736[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto__);

(statearr_27736[(1)] = (1));

return statearr_27736;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto____1 = (function (state_27713){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27713);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27737){var ex__10801__auto__ = e27737;
var statearr_27738_27755 = state_27713;
(statearr_27738_27755[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27713[(4)]))){
var statearr_27739_27756 = state_27713;
(statearr_27739_27756[(1)] = cljs.core.first((state_27713[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27757 = state_27713;
state_27713 = G__27757;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto__ = function(state_27713){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto____1.call(this,state_27713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27740 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27740[(6)] = c__10835__auto___27741);

return statearr_27740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k27759,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__27763 = k27759;
var G__27763__$1 = (((G__27763 instanceof cljs.core.Keyword))?G__27763.fqn:null);
switch (G__27763__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27759,else__4475__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__27764){
var vec__27765 = p__27764;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27765,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27765,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27758){
var self__ = this;
var G__27758__$1 = this;
return (new cljs.core.RecordIter((0),G__27758__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__27768 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__27769 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__27770 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__27771 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27770,G__27771) : object_cache.call(null,G__27770,G__27771));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__27772 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__27773 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27772,G__27773) : object_cache.call(null,G__27772,G__27773));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27768,G__27769) : object_cache.call(null,G__27768,G__27769));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__27774 = history_id;
var G__27775 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__27774,G__27775) : object_cache.call(null,G__27774,G__27775));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__27776 = (function (coll__4469__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__27776(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27760,other27761){
var self__ = this;
var this27760__$1 = this;
return (((!((other27761 == null)))) && ((((this27760__$1.constructor === other27761.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.conn,other27761.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.config,other27761.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.network,other27761.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.dbid,other27761.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.id,other27761.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.leaf,other27761.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.first,other27761.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.rhs,other27761.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.size,other27761.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.block,other27761.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.t,other27761.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.tt_id,other27761.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.leftmost_QMARK_,other27761.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.tempid,other27761.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27760__$1.__extmap,other27761.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k27759){
var self__ = this;
var this__4479__auto____$1 = this;
var G__27777 = k27759;
var G__27777__$1 = (((G__27777 instanceof cljs.core.Keyword))?G__27777.fqn:null);
switch (G__27777__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27759);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__27758){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__27778 = cljs.core.keyword_identical_QMARK_;
var expr__27779 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__27781 = cljs.core.cst$kw$conn;
var G__27782 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27781,G__27782) : pred__27778.call(null,G__27781,G__27782));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__27758,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27783 = cljs.core.cst$kw$config;
var G__27784 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27783,G__27784) : pred__27778.call(null,G__27783,G__27784));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__27758,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27785 = cljs.core.cst$kw$network;
var G__27786 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27785,G__27786) : pred__27778.call(null,G__27785,G__27786));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__27758,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27787 = cljs.core.cst$kw$dbid;
var G__27788 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27787,G__27788) : pred__27778.call(null,G__27787,G__27788));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__27758,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27789 = cljs.core.cst$kw$id;
var G__27790 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27789,G__27790) : pred__27778.call(null,G__27789,G__27790));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__27758,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27791 = cljs.core.cst$kw$leaf;
var G__27792 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27791,G__27792) : pred__27778.call(null,G__27791,G__27792));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__27758,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27793 = cljs.core.cst$kw$first;
var G__27794 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27793,G__27794) : pred__27778.call(null,G__27793,G__27794));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__27758,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27795 = cljs.core.cst$kw$rhs;
var G__27796 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27795,G__27796) : pred__27778.call(null,G__27795,G__27796));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__27758,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27797 = cljs.core.cst$kw$size;
var G__27798 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27797,G__27798) : pred__27778.call(null,G__27797,G__27798));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__27758,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27799 = cljs.core.cst$kw$block;
var G__27800 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27799,G__27800) : pred__27778.call(null,G__27799,G__27800));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__27758,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27801 = cljs.core.cst$kw$t;
var G__27802 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27801,G__27802) : pred__27778.call(null,G__27801,G__27802));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__27758,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27803 = cljs.core.cst$kw$tt_DASH_id;
var G__27804 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27803,G__27804) : pred__27778.call(null,G__27803,G__27804));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__27758,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27805 = cljs.core.cst$kw$leftmost_QMARK_;
var G__27806 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27805,G__27806) : pred__27778.call(null,G__27805,G__27806));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__27758,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27807 = cljs.core.cst$kw$tempid;
var G__27808 = expr__27779;
return (pred__27778.cljs$core$IFn$_invoke$arity$2 ? pred__27778.cljs$core$IFn$_invoke$arity$2(G__27807,G__27808) : pred__27778.call(null,G__27807,G__27808));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__27758,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__27758),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__27758){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__27758,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__27762){
var extmap__4512__auto__ = (function (){var G__27809 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27762,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__27762)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27809);
} else {
return G__27809;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27762),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__27762),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__27812 = blank_db;
var map__27812__$1 = cljs.core.__destructure_map(map__27812);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27812__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27812__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27812__$1,cljs.core.cst$kw$index_DASH_configs);
var map__27813 = root_data;
var map__27813__$1 = cljs.core.__destructure_map(map__27813);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27813__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27813__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27813__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27813__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27835){
var state_val_27836 = (state_27835[(1)]);
if((state_val_27836 === (7))){
var state_27835__$1 = state_27835;
var statearr_27837_27857 = state_27835__$1;
(statearr_27837_27857[(2)] = null);

(statearr_27837_27857[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27836 === (1))){
var state_27835__$1 = state_27835;
var statearr_27838_27858 = state_27835__$1;
(statearr_27838_27858[(2)] = null);

(statearr_27838_27858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27836 === (4))){
var inst_27814 = (state_27835[(2)]);
var state_27835__$1 = state_27835;
var statearr_27839_27859 = state_27835__$1;
(statearr_27839_27859[(2)] = inst_27814);

(statearr_27839_27859[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27836 === (6))){
var inst_27821 = (state_27835[(7)]);
var inst_27823 = fluree.db.storage.core.serde(conn);
var state_27835__$1 = (function (){var statearr_27840 = state_27835;
(statearr_27840[(8)] = inst_27823);

return statearr_27840;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27835__$1,(9),inst_27821);
} else {
if((state_val_27836 === (3))){
var inst_27833 = (state_27835[(2)]);
var state_27835__$1 = state_27835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27835__$1,inst_27833);
} else {
if((state_val_27836 === (2))){
var inst_27821 = (state_27835[(7)]);
var _ = (function (){var statearr_27842 = state_27835;
(statearr_27842[(4)] = cljs.core.cons((5),(state_27835[(4)])));

return statearr_27842;
})();
var inst_27820 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_27821__$1 = fluree.db.storage.core.storage_read(conn,inst_27820);
var state_27835__$1 = (function (){var statearr_27843 = state_27835;
(statearr_27843[(7)] = inst_27821__$1);

return statearr_27843;
})();
if(cljs.core.truth_(inst_27821__$1)){
var statearr_27844_27860 = state_27835__$1;
(statearr_27844_27860[(1)] = (6));

} else {
var statearr_27845_27861 = state_27835__$1;
(statearr_27845_27861[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27836 === (9))){
var inst_27823 = (state_27835[(8)]);
var inst_27825 = (state_27835[(2)]);
var inst_27826 = fluree.db.util.async.throw_err(inst_27825);
var inst_27827 = fluree.db.serde.protocol._deserialize_garbage(inst_27823,inst_27826);
var state_27835__$1 = state_27835;
var statearr_27846_27862 = state_27835__$1;
(statearr_27846_27862[(2)] = inst_27827);

(statearr_27846_27862[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27836 === (5))){
var _ = (function (){var statearr_27847 = state_27835;
(statearr_27847[(4)] = cljs.core.rest((state_27835[(4)])));

return statearr_27847;
})();
var state_27835__$1 = state_27835;
var ex27841 = (state_27835__$1[(2)]);
var statearr_27848_27863 = state_27835__$1;
(statearr_27848_27863[(5)] = ex27841);


if((ex27841 instanceof Error)){
var statearr_27849_27864 = state_27835__$1;
(statearr_27849_27864[(1)] = (4));

(statearr_27849_27864[(5)] = null);

} else {
throw ex27841;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27836 === (8))){
var inst_27830 = (state_27835[(2)]);
var _ = (function (){var statearr_27850 = state_27835;
(statearr_27850[(4)] = cljs.core.rest((state_27835[(4)])));

return statearr_27850;
})();
var state_27835__$1 = state_27835;
var statearr_27851_27865 = state_27835__$1;
(statearr_27851_27865[(2)] = inst_27830);

(statearr_27851_27865[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__10798__auto____0 = (function (){
var statearr_27852 = [null,null,null,null,null,null,null,null,null];
(statearr_27852[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__10798__auto__);

(statearr_27852[(1)] = (1));

return statearr_27852;
});
var fluree$db$storage$core$read_garbage_$_state_machine__10798__auto____1 = (function (state_27835){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27835);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27853){var ex__10801__auto__ = e27853;
var statearr_27854_27866 = state_27835;
(statearr_27854_27866[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27835[(4)]))){
var statearr_27855_27867 = state_27835;
(statearr_27855_27867[(1)] = cljs.core.first((state_27835[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27868 = state_27835;
state_27835 = G__27868;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__10798__auto__ = function(state_27835){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__10798__auto____1.call(this,state_27835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__10798__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__10798__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27856 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27856[(6)] = c__10835__auto__);

return statearr_27856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27890){
var state_val_27891 = (state_27890[(1)]);
if((state_val_27891 === (7))){
var state_27890__$1 = state_27890;
var statearr_27892_27912 = state_27890__$1;
(statearr_27892_27912[(2)] = null);

(statearr_27892_27912[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27891 === (1))){
var state_27890__$1 = state_27890;
var statearr_27893_27913 = state_27890__$1;
(statearr_27893_27913[(2)] = null);

(statearr_27893_27913[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27891 === (4))){
var inst_27869 = (state_27890[(2)]);
var state_27890__$1 = state_27890;
var statearr_27894_27914 = state_27890__$1;
(statearr_27894_27914[(2)] = inst_27869);

(statearr_27894_27914[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27891 === (6))){
var inst_27876 = (state_27890[(7)]);
var inst_27878 = fluree.db.storage.core.serde(conn);
var state_27890__$1 = (function (){var statearr_27895 = state_27890;
(statearr_27895[(8)] = inst_27878);

return statearr_27895;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27890__$1,(9),inst_27876);
} else {
if((state_val_27891 === (3))){
var inst_27888 = (state_27890[(2)]);
var state_27890__$1 = state_27890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27890__$1,inst_27888);
} else {
if((state_val_27891 === (2))){
var inst_27876 = (state_27890[(7)]);
var _ = (function (){var statearr_27897 = state_27890;
(statearr_27897[(4)] = cljs.core.cons((5),(state_27890[(4)])));

return statearr_27897;
})();
var inst_27875 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_27876__$1 = fluree.db.storage.core.storage_read(conn,inst_27875);
var state_27890__$1 = (function (){var statearr_27898 = state_27890;
(statearr_27898[(7)] = inst_27876__$1);

return statearr_27898;
})();
if(cljs.core.truth_(inst_27876__$1)){
var statearr_27899_27915 = state_27890__$1;
(statearr_27899_27915[(1)] = (6));

} else {
var statearr_27900_27916 = state_27890__$1;
(statearr_27900_27916[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27891 === (9))){
var inst_27878 = (state_27890[(8)]);
var inst_27880 = (state_27890[(2)]);
var inst_27881 = fluree.db.util.async.throw_err(inst_27880);
var inst_27882 = fluree.db.serde.protocol._deserialize_db_root(inst_27878,inst_27881);
var state_27890__$1 = state_27890;
var statearr_27901_27917 = state_27890__$1;
(statearr_27901_27917[(2)] = inst_27882);

(statearr_27901_27917[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27891 === (5))){
var _ = (function (){var statearr_27902 = state_27890;
(statearr_27902[(4)] = cljs.core.rest((state_27890[(4)])));

return statearr_27902;
})();
var state_27890__$1 = state_27890;
var ex27896 = (state_27890__$1[(2)]);
var statearr_27903_27918 = state_27890__$1;
(statearr_27903_27918[(5)] = ex27896);


if((ex27896 instanceof Error)){
var statearr_27904_27919 = state_27890__$1;
(statearr_27904_27919[(1)] = (4));

(statearr_27904_27919[(5)] = null);

} else {
throw ex27896;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27891 === (8))){
var inst_27885 = (state_27890[(2)]);
var _ = (function (){var statearr_27905 = state_27890;
(statearr_27905[(4)] = cljs.core.rest((state_27890[(4)])));

return statearr_27905;
})();
var state_27890__$1 = state_27890;
var statearr_27906_27920 = state_27890__$1;
(statearr_27906_27920[(2)] = inst_27885);

(statearr_27906_27920[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__10798__auto____0 = (function (){
var statearr_27907 = [null,null,null,null,null,null,null,null,null];
(statearr_27907[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__10798__auto__);

(statearr_27907[(1)] = (1));

return statearr_27907;
});
var fluree$db$storage$core$read_db_root_$_state_machine__10798__auto____1 = (function (state_27890){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27890);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27908){var ex__10801__auto__ = e27908;
var statearr_27909_27921 = state_27890;
(statearr_27909_27921[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27890[(4)]))){
var statearr_27910_27922 = state_27890;
(statearr_27910_27922[(1)] = cljs.core.first((state_27890[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27923 = state_27890;
state_27890 = G__27923;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__10798__auto__ = function(state_27890){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__10798__auto____1.call(this,state_27890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__10798__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__10798__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27911 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27911[(6)] = c__10835__auto__);

return statearr_27911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_27959){
var state_val_27960 = (state_27959[(1)]);
if((state_val_27960 === (7))){
var inst_27933 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_27934 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_27935 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_27936 = cljs.core.PersistentHashMap.fromArrays(inst_27934,inst_27935);
var inst_27937 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27933,inst_27936);
var inst_27938 = (function(){throw inst_27937})();
var state_27959__$1 = state_27959;
var statearr_27961_27983 = state_27959__$1;
(statearr_27961_27983[(2)] = inst_27938);

(statearr_27961_27983[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27960 === (1))){
var state_27959__$1 = state_27959;
var statearr_27962_27984 = state_27959__$1;
(statearr_27962_27984[(2)] = null);

(statearr_27962_27984[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27960 === (4))){
var inst_27924 = (state_27959[(2)]);
var state_27959__$1 = state_27959;
var statearr_27963_27985 = state_27959__$1;
(statearr_27963_27985[(2)] = inst_27924);

(statearr_27963_27985[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27960 === (6))){
var state_27959__$1 = state_27959;
var statearr_27964_27986 = state_27959__$1;
(statearr_27964_27986[(2)] = null);

(statearr_27964_27986[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27960 === (3))){
var inst_27957 = (state_27959[(2)]);
var state_27959__$1 = state_27959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27959__$1,inst_27957);
} else {
if((state_val_27960 === (2))){
var inst_27930 = (state_27959[(7)]);
var _ = (function (){var statearr_27965 = state_27959;
(statearr_27965[(4)] = cljs.core.cons((5),(state_27959[(4)])));

return statearr_27965;
})();
var inst_27930__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_27959__$1 = (function (){var statearr_27966 = state_27959;
(statearr_27966[(7)] = inst_27930__$1);

return statearr_27966;
})();
if(cljs.core.truth_(inst_27930__$1)){
var statearr_27967_27987 = state_27959__$1;
(statearr_27967_27987[(1)] = (6));

} else {
var statearr_27968_27988 = state_27959__$1;
(statearr_27968_27988[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27960 === (11))){
var inst_27949 = (state_27959[(8)]);
var inst_27952 = (state_27959[(2)]);
var inst_27953 = fluree.db.util.async.throw_err(inst_27952);
var inst_27954 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27949,cljs.core.cst$kw$settings,inst_27953);
var _ = (function (){var statearr_27970 = state_27959;
(statearr_27970[(4)] = cljs.core.rest((state_27959[(4)])));

return statearr_27970;
})();
var state_27959__$1 = state_27959;
var statearr_27971_27989 = state_27959__$1;
(statearr_27971_27989[(2)] = inst_27954);

(statearr_27971_27989[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27960 === (9))){
var inst_27944 = (state_27959[(9)]);
var inst_27942 = (state_27959[(2)]);
var inst_27943 = fluree.db.util.async.throw_err(inst_27942);
var inst_27944__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_27943);
var inst_27945 = fluree.db.query.schema.schema_map(inst_27944__$1);
var state_27959__$1 = (function (){var statearr_27972 = state_27959;
(statearr_27972[(9)] = inst_27944__$1);

return statearr_27972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27959__$1,(10),inst_27945);
} else {
if((state_val_27960 === (5))){
var _ = (function (){var statearr_27973 = state_27959;
(statearr_27973[(4)] = cljs.core.rest((state_27959[(4)])));

return statearr_27973;
})();
var state_27959__$1 = state_27959;
var ex27969 = (state_27959__$1[(2)]);
var statearr_27974_27990 = state_27959__$1;
(statearr_27974_27990[(5)] = ex27969);


if((ex27969 instanceof Error)){
var statearr_27975_27991 = state_27959__$1;
(statearr_27975_27991[(1)] = (4));

(statearr_27975_27991[(5)] = null);

} else {
throw ex27969;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27960 === (10))){
var inst_27949 = (state_27959[(8)]);
var inst_27944 = (state_27959[(9)]);
var inst_27947 = (state_27959[(2)]);
var inst_27948 = fluree.db.util.async.throw_err(inst_27947);
var inst_27949__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27944,cljs.core.cst$kw$schema,inst_27948);
var inst_27950 = fluree.db.query.schema.setting_map(inst_27949__$1);
var state_27959__$1 = (function (){var statearr_27976 = state_27959;
(statearr_27976[(8)] = inst_27949__$1);

return statearr_27976;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27959__$1,(11),inst_27950);
} else {
if((state_val_27960 === (8))){
var inst_27930 = (state_27959[(7)]);
var inst_27940 = (state_27959[(2)]);
var state_27959__$1 = (function (){var statearr_27977 = state_27959;
(statearr_27977[(10)] = inst_27940);

return statearr_27977;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27959__$1,(9),inst_27930);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__10798__auto____0 = (function (){
var statearr_27978 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27978[(0)] = fluree$db$storage$core$reify_db_$_state_machine__10798__auto__);

(statearr_27978[(1)] = (1));

return statearr_27978;
});
var fluree$db$storage$core$reify_db_$_state_machine__10798__auto____1 = (function (state_27959){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_27959);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e27979){var ex__10801__auto__ = e27979;
var statearr_27980_27992 = state_27959;
(statearr_27980_27992[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_27959[(4)]))){
var statearr_27981_27993 = state_27959;
(statearr_27981_27993[(1)] = cljs.core.first((state_27959[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__27994 = state_27959;
state_27959 = G__27994;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__10798__auto__ = function(state_27959){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__10798__auto____1.call(this,state_27959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__10798__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__10798__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_27982 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_27982[(6)] = c__10835__auto__);

return statearr_27982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__27996 = arguments.length;
switch (G__27996) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_28049){
var state_val_28050 = (state_28049[(1)]);
if((state_val_28050 === (7))){
var inst_28006 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_28007 = (new Error(inst_28006));
var inst_28008 = (function(){throw inst_28007})();
var state_28049__$1 = state_28049;
var statearr_28051_28091 = state_28049__$1;
(statearr_28051_28091[(2)] = inst_28008);

(statearr_28051_28091[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (20))){
var inst_28040 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
var statearr_28052_28092 = state_28049__$1;
(statearr_28052_28092[(2)] = inst_28040);

(statearr_28052_28092[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (1))){
var state_28049__$1 = state_28049;
var statearr_28053_28093 = state_28049__$1;
(statearr_28053_28093[(2)] = null);

(statearr_28053_28093[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (4))){
var inst_27997 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
var statearr_28054_28094 = state_28049__$1;
(statearr_28054_28094[(2)] = inst_27997);

(statearr_28054_28094[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (15))){
var inst_28015 = (state_28049[(7)]);
var state_28049__$1 = state_28049;
var statearr_28055_28095 = state_28049__$1;
(statearr_28055_28095[(2)] = inst_28015);

(statearr_28055_28095[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (21))){
var inst_28019 = (state_28049[(8)]);
var inst_28015 = (state_28049[(7)]);
var inst_28014 = (state_28049[(9)]);
var inst_28033 = (inst_28014 + (1));
var inst_28034 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_28015,inst_28019);
var inst_28014__$1 = inst_28033;
var inst_28015__$1 = inst_28034;
var state_28049__$1 = (function (){var statearr_28056 = state_28049;
(statearr_28056[(7)] = inst_28015__$1);

(statearr_28056[(9)] = inst_28014__$1);

return statearr_28056;
})();
var statearr_28057_28096 = state_28049__$1;
(statearr_28057_28096[(2)] = null);

(statearr_28057_28096[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (13))){
var inst_28019 = (state_28049[(8)]);
var inst_28023 = (inst_28019 instanceof Error);
var state_28049__$1 = state_28049;
var statearr_28058_28097 = state_28049__$1;
(statearr_28058_28097[(2)] = inst_28023);

(statearr_28058_28097[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (22))){
var state_28049__$1 = state_28049;
var statearr_28059_28098 = state_28049__$1;
(statearr_28059_28098[(2)] = null);

(statearr_28059_28098[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (6))){
var state_28049__$1 = state_28049;
var statearr_28060_28099 = state_28049__$1;
(statearr_28060_28099[(2)] = null);

(statearr_28060_28099[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (17))){
var inst_28042 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
var statearr_28061_28100 = state_28049__$1;
(statearr_28061_28100[(2)] = inst_28042);

(statearr_28061_28100[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (3))){
var inst_28047 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28049__$1,inst_28047);
} else {
if((state_val_28050 === (12))){
var inst_28020 = (state_28049[(10)]);
var state_28049__$1 = state_28049;
var statearr_28062_28101 = state_28049__$1;
(statearr_28062_28101[(2)] = inst_28020);

(statearr_28062_28101[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (2))){
var _ = (function (){var statearr_28063 = state_28049;
(statearr_28063[(4)] = cljs.core.cons((5),(state_28049[(4)])));

return statearr_28063;
})();
var inst_28003 = (end >= start);
var state_28049__$1 = state_28049;
if(cljs.core.truth_(inst_28003)){
var statearr_28064_28102 = state_28049__$1;
(statearr_28064_28102[(1)] = (6));

} else {
var statearr_28065_28103 = state_28049__$1;
(statearr_28065_28103[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (23))){
var inst_28038 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
var statearr_28066_28104 = state_28049__$1;
(statearr_28066_28104[(2)] = inst_28038);

(statearr_28066_28104[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (19))){
var state_28049__$1 = state_28049;
var statearr_28067_28105 = state_28049__$1;
(statearr_28067_28105[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (11))){
var inst_28019 = (state_28049[(8)]);
var inst_28020 = (state_28049[(10)]);
var inst_28019__$1 = (state_28049[(2)]);
var inst_28020__$1 = (inst_28019__$1 == null);
var state_28049__$1 = (function (){var statearr_28070 = state_28049;
(statearr_28070[(8)] = inst_28019__$1);

(statearr_28070[(10)] = inst_28020__$1);

return statearr_28070;
})();
if(cljs.core.truth_(inst_28020__$1)){
var statearr_28071_28106 = state_28049__$1;
(statearr_28071_28106[(1)] = (12));

} else {
var statearr_28072_28107 = state_28049__$1;
(statearr_28072_28107[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (9))){
var inst_28014 = (state_28049[(9)]);
var inst_28017 = fluree.db.storage.core.read_block(conn,network,dbid,inst_28014);
var state_28049__$1 = state_28049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28049__$1,(11),inst_28017);
} else {
if((state_val_28050 === (5))){
var _ = (function (){var statearr_28073 = state_28049;
(statearr_28073[(4)] = cljs.core.rest((state_28049[(4)])));

return statearr_28073;
})();
var state_28049__$1 = state_28049;
var ex28069 = (state_28049__$1[(2)]);
var statearr_28074_28108 = state_28049__$1;
(statearr_28074_28108[(5)] = ex28069);


if((ex28069 instanceof Error)){
var statearr_28075_28109 = state_28049__$1;
(statearr_28075_28109[(1)] = (4));

(statearr_28075_28109[(5)] = null);

} else {
throw ex28069;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (14))){
var inst_28025 = (state_28049[(2)]);
var state_28049__$1 = state_28049;
if(cljs.core.truth_(inst_28025)){
var statearr_28076_28110 = state_28049__$1;
(statearr_28076_28110[(1)] = (15));

} else {
var statearr_28077_28111 = state_28049__$1;
(statearr_28077_28111[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (16))){
var inst_28014 = (state_28049[(9)]);
var inst_28028 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28014,end);
var state_28049__$1 = state_28049;
if(inst_28028){
var statearr_28078_28112 = state_28049__$1;
(statearr_28078_28112[(1)] = (18));

} else {
var statearr_28079_28113 = state_28049__$1;
(statearr_28079_28113[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (10))){
var inst_28044 = (state_28049[(2)]);
var _ = (function (){var statearr_28080 = state_28049;
(statearr_28080[(4)] = cljs.core.rest((state_28049[(4)])));

return statearr_28080;
})();
var state_28049__$1 = state_28049;
var statearr_28081_28114 = state_28049__$1;
(statearr_28081_28114[(2)] = inst_28044);

(statearr_28081_28114[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (18))){
var inst_28019 = (state_28049[(8)]);
var inst_28015 = (state_28049[(7)]);
var inst_28030 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_28015,inst_28019);
var state_28049__$1 = state_28049;
var statearr_28082_28115 = state_28049__$1;
(statearr_28082_28115[(2)] = inst_28030);

(statearr_28082_28115[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28050 === (8))){
var inst_28010 = (state_28049[(2)]);
var inst_28011 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_28012 = start;
var inst_28013 = cljs.core.PersistentVector.EMPTY;
var inst_28014 = inst_28012;
var inst_28015 = inst_28013;
var state_28049__$1 = (function (){var statearr_28083 = state_28049;
(statearr_28083[(11)] = inst_28011);

(statearr_28083[(12)] = inst_28010);

(statearr_28083[(7)] = inst_28015);

(statearr_28083[(9)] = inst_28014);

return statearr_28083;
})();
var statearr_28084_28116 = state_28049__$1;
(statearr_28084_28116[(2)] = null);

(statearr_28084_28116[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__10798__auto__ = null;
var fluree$db$storage$core$state_machine__10798__auto____0 = (function (){
var statearr_28085 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28085[(0)] = fluree$db$storage$core$state_machine__10798__auto__);

(statearr_28085[(1)] = (1));

return statearr_28085;
});
var fluree$db$storage$core$state_machine__10798__auto____1 = (function (state_28049){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_28049);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e28086){var ex__10801__auto__ = e28086;
var statearr_28087_28117 = state_28049;
(statearr_28087_28117[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_28049[(4)]))){
var statearr_28088_28118 = state_28049;
(statearr_28088_28118[(1)] = cljs.core.first((state_28049[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__28119 = state_28049;
state_28049 = G__28119;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__10798__auto__ = function(state_28049){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__10798__auto____1.call(this,state_28049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__10798__auto____0;
fluree$db$storage$core$state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__10798__auto____1;
return fluree$db$storage$core$state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_28089 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_28089[(6)] = c__10835__auto__);

return statearr_28089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__10835__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10836__auto__ = (function (){var switch__10797__auto__ = (function (state_28135){
var state_val_28136 = (state_28135[(1)]);
if((state_val_28136 === (1))){
var state_28135__$1 = state_28135;
var statearr_28137_28151 = state_28135__$1;
(statearr_28137_28151[(2)] = null);

(statearr_28137_28151[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28136 === (2))){
var _ = (function (){var statearr_28138 = state_28135;
(statearr_28138[(4)] = cljs.core.cons((5),(state_28135[(4)])));

return statearr_28138;
})();
var inst_28126 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_28135__$1 = state_28135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28135__$1,(6),inst_28126);
} else {
if((state_val_28136 === (3))){
var inst_28133 = (state_28135[(2)]);
var state_28135__$1 = state_28135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28135__$1,inst_28133);
} else {
if((state_val_28136 === (4))){
var inst_28120 = (state_28135[(2)]);
var state_28135__$1 = state_28135;
var statearr_28140_28152 = state_28135__$1;
(statearr_28140_28152[(2)] = inst_28120);

(statearr_28140_28152[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28136 === (5))){
var _ = (function (){var statearr_28141 = state_28135;
(statearr_28141[(4)] = cljs.core.rest((state_28135[(4)])));

return statearr_28141;
})();
var state_28135__$1 = state_28135;
var ex28139 = (state_28135__$1[(2)]);
var statearr_28142_28153 = state_28135__$1;
(statearr_28142_28153[(5)] = ex28139);


if((ex28139 instanceof Error)){
var statearr_28143_28154 = state_28135__$1;
(statearr_28143_28154[(1)] = (4));

(statearr_28143_28154[(5)] = null);

} else {
throw ex28139;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28136 === (6))){
var inst_28128 = (state_28135[(2)]);
var inst_28129 = fluree.db.util.async.throw_err(inst_28128);
var inst_28130 = cljs.core.first(inst_28129);
var _ = (function (){var statearr_28144 = state_28135;
(statearr_28144[(4)] = cljs.core.rest((state_28135[(4)])));

return statearr_28144;
})();
var state_28135__$1 = state_28135;
var statearr_28145_28155 = state_28135__$1;
(statearr_28145_28155[(2)] = inst_28130);

(statearr_28145_28155[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__10798__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__10798__auto____0 = (function (){
var statearr_28146 = [null,null,null,null,null,null,null];
(statearr_28146[(0)] = fluree$db$storage$core$block_$_state_machine__10798__auto__);

(statearr_28146[(1)] = (1));

return statearr_28146;
});
var fluree$db$storage$core$block_$_state_machine__10798__auto____1 = (function (state_28135){
while(true){
var ret_value__10799__auto__ = (function (){try{while(true){
var result__10800__auto__ = switch__10797__auto__(state_28135);
if(cljs.core.keyword_identical_QMARK_(result__10800__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10800__auto__;
}
break;
}
}catch (e28147){var ex__10801__auto__ = e28147;
var statearr_28148_28156 = state_28135;
(statearr_28148_28156[(2)] = ex__10801__auto__);


if(cljs.core.seq((state_28135[(4)]))){
var statearr_28149_28157 = state_28135;
(statearr_28149_28157[(1)] = cljs.core.first((state_28135[(4)])));

} else {
throw ex__10801__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10799__auto__,cljs.core.cst$kw$recur)){
var G__28158 = state_28135;
state_28135 = G__28158;
continue;
} else {
return ret_value__10799__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__10798__auto__ = function(state_28135){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__10798__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__10798__auto____1.call(this,state_28135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__10798__auto____0;
fluree$db$storage$core$block_$_state_machine__10798__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__10798__auto____1;
return fluree$db$storage$core$block_$_state_machine__10798__auto__;
})()
})();
var state__10837__auto__ = (function (){var statearr_28150 = (f__10836__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10836__auto__.cljs$core$IFn$_invoke$arity$0() : f__10836__auto__.call(null));
(statearr_28150[(6)] = c__10835__auto__);

return statearr_28150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10837__auto__);
}));

return c__10835__auto__;
});
