// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__6706 = s;
var map__6706__$1 = cljs.core.__destructure_map(map__6706);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6706__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6706__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__6708 = info;
var map__6709 = G__6708;
var map__6709__$1 = cljs.core.__destructure_map(map__6709);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6709__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__6708__$1 = G__6708;
while(true){
var d__$2 = d__$1;
var map__6711 = G__6708__$1;
var map__6711__$1 = cljs.core.__destructure_map(map__6711);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6711__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__6712 = (d__$2 + (1));
var G__6713 = shadow__$1;
d__$1 = G__6712;
G__6708__$1 = G__6713;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__6714){
var map__6715 = p__6714;
var map__6715__$1 = cljs.core.__destructure_map(map__6715);
var name_var = map__6715__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6715__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6715__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__6716 = info;
var map__6716__$1 = cljs.core.__destructure_map(map__6716);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6716__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6716__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__6717 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__6717) : cljs.compiler.munge.call(null,G__6717));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__6719 = arguments.length;
switch (G__6719) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__6720 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11639,11639,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__6720.cljs$core$IFn$_invoke$arity$1 ? fexpr__6720.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__6720.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__6722 = cp;
switch (G__6722) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__6724_6728 = cljs.core.seq(s);
var chunk__6725_6729 = null;
var count__6726_6730 = (0);
var i__6727_6731 = (0);
while(true){
if((i__6727_6731 < count__6726_6730)){
var c_6732 = chunk__6725_6729.cljs$core$IIndexed$_nth$arity$2(null,i__6727_6731);
sb.append(cljs.compiler.escape_char(c_6732));


var G__6733 = seq__6724_6728;
var G__6734 = chunk__6725_6729;
var G__6735 = count__6726_6730;
var G__6736 = (i__6727_6731 + (1));
seq__6724_6728 = G__6733;
chunk__6725_6729 = G__6734;
count__6726_6730 = G__6735;
i__6727_6731 = G__6736;
continue;
} else {
var temp__5753__auto___6737 = cljs.core.seq(seq__6724_6728);
if(temp__5753__auto___6737){
var seq__6724_6738__$1 = temp__5753__auto___6737;
if(cljs.core.chunked_seq_QMARK_(seq__6724_6738__$1)){
var c__4649__auto___6739 = cljs.core.chunk_first(seq__6724_6738__$1);
var G__6740 = cljs.core.chunk_rest(seq__6724_6738__$1);
var G__6741 = c__4649__auto___6739;
var G__6742 = cljs.core.count(c__4649__auto___6739);
var G__6743 = (0);
seq__6724_6728 = G__6740;
chunk__6725_6729 = G__6741;
count__6726_6730 = G__6742;
i__6727_6731 = G__6743;
continue;
} else {
var c_6744 = cljs.core.first(seq__6724_6738__$1);
sb.append(cljs.compiler.escape_char(c_6744));


var G__6745 = cljs.core.next(seq__6724_6738__$1);
var G__6746 = null;
var G__6747 = (0);
var G__6748 = (0);
seq__6724_6728 = G__6745;
chunk__6725_6729 = G__6746;
count__6726_6730 = G__6747;
i__6727_6731 = G__6748;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6749 = cljs.core.get_global_hierarchy;
return (fexpr__6749.cljs$core$IFn$_invoke$arity$0 ? fexpr__6749.cljs$core$IFn$_invoke$arity$0() : fexpr__6749.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__6750_6755 = ast;
var map__6750_6756__$1 = cljs.core.__destructure_map(map__6750_6755);
var env_6757 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6750_6756__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_6757))){
var map__6751_6758 = env_6757;
var map__6751_6759__$1 = cljs.core.__destructure_map(map__6751_6758);
var line_6760 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6751_6759__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_6761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6751_6759__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__6752 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__6754 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__6753 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__6753.cljs$core$IFn$_invoke$arity$1 ? fexpr__6753.cljs$core$IFn$_invoke$arity$1(G__6754) : fexpr__6753.call(null,G__6754));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__6752,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__6752;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_6760 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_6761)?(column_6761 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__6770 = arguments.length;
switch (G__6770) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___6777 = arguments.length;
var i__4830__auto___6778 = (0);
while(true){
if((i__4830__auto___6778 < len__4829__auto___6777)){
args_arr__4850__auto__.push((arguments[i__4830__auto___6778]));

var G__6779 = (i__4830__auto___6778 + (1));
i__4830__auto___6778 = G__6779;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_6780 = (function (){var G__6771 = a;
if((!(typeof a === 'string'))){
return G__6771.toString();
} else {
return G__6771;
}
})();
var temp__5757__auto___6781 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___6781 == null)){
} else {
var sm_data_6782 = temp__5757__auto___6781;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_6782,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__6762_SHARP_){
return (p1__6762_SHARP_ + s_6780.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_6780], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6772 = cljs.core.seq(xs);
var chunk__6773 = null;
var count__6774 = (0);
var i__6775 = (0);
while(true){
if((i__6775 < count__6774)){
var x = chunk__6773.cljs$core$IIndexed$_nth$arity$2(null,i__6775);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6783 = seq__6772;
var G__6784 = chunk__6773;
var G__6785 = count__6774;
var G__6786 = (i__6775 + (1));
seq__6772 = G__6783;
chunk__6773 = G__6784;
count__6774 = G__6785;
i__6775 = G__6786;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__6772);
if(temp__5753__auto__){
var seq__6772__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__6772__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__6772__$1);
var G__6787 = cljs.core.chunk_rest(seq__6772__$1);
var G__6788 = c__4649__auto__;
var G__6789 = cljs.core.count(c__4649__auto__);
var G__6790 = (0);
seq__6772 = G__6787;
chunk__6773 = G__6788;
count__6774 = G__6789;
i__6775 = G__6790;
continue;
} else {
var x = cljs.core.first(seq__6772__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__6791 = cljs.core.next(seq__6772__$1);
var G__6792 = null;
var G__6793 = (0);
var G__6794 = (0);
seq__6772 = G__6791;
chunk__6773 = G__6792;
count__6774 = G__6793;
i__6775 = G__6794;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq6764){
var G__6765 = cljs.core.first(seq6764);
var seq6764__$1 = cljs.core.next(seq6764);
var G__6766 = cljs.core.first(seq6764__$1);
var seq6764__$2 = cljs.core.next(seq6764__$1);
var G__6767 = cljs.core.first(seq6764__$2);
var seq6764__$3 = cljs.core.next(seq6764__$2);
var G__6768 = cljs.core.first(seq6764__$3);
var seq6764__$4 = cljs.core.next(seq6764__$3);
var G__6769 = cljs.core.first(seq6764__$4);
var seq6764__$5 = cljs.core.next(seq6764__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6765,G__6766,G__6767,G__6768,G__6769,seq6764__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__6795){
var map__6796 = p__6795;
var map__6796__$1 = cljs.core.__destructure_map(map__6796);
var m = map__6796__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6796__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6804 = arguments.length;
switch (G__6804) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___6810 = arguments.length;
var i__4830__auto___6811 = (0);
while(true){
if((i__4830__auto___6811 < len__4829__auto___6810)){
args_arr__4850__auto__.push((arguments[i__4830__auto___6811]));

var G__6812 = (i__4830__auto___6811 + (1));
i__4830__auto___6811 = G__6812;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__6805_6813 = cljs.core.seq(xs);
var chunk__6806_6814 = null;
var count__6807_6815 = (0);
var i__6808_6816 = (0);
while(true){
if((i__6808_6816 < count__6807_6815)){
var x_6817 = chunk__6806_6814.cljs$core$IIndexed$_nth$arity$2(null,i__6808_6816);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6817);


var G__6818 = seq__6805_6813;
var G__6819 = chunk__6806_6814;
var G__6820 = count__6807_6815;
var G__6821 = (i__6808_6816 + (1));
seq__6805_6813 = G__6818;
chunk__6806_6814 = G__6819;
count__6807_6815 = G__6820;
i__6808_6816 = G__6821;
continue;
} else {
var temp__5753__auto___6822 = cljs.core.seq(seq__6805_6813);
if(temp__5753__auto___6822){
var seq__6805_6823__$1 = temp__5753__auto___6822;
if(cljs.core.chunked_seq_QMARK_(seq__6805_6823__$1)){
var c__4649__auto___6824 = cljs.core.chunk_first(seq__6805_6823__$1);
var G__6825 = cljs.core.chunk_rest(seq__6805_6823__$1);
var G__6826 = c__4649__auto___6824;
var G__6827 = cljs.core.count(c__4649__auto___6824);
var G__6828 = (0);
seq__6805_6813 = G__6825;
chunk__6806_6814 = G__6826;
count__6807_6815 = G__6827;
i__6808_6816 = G__6828;
continue;
} else {
var x_6829 = cljs.core.first(seq__6805_6823__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_6829);


var G__6830 = cljs.core.next(seq__6805_6823__$1);
var G__6831 = null;
var G__6832 = (0);
var G__6833 = (0);
seq__6805_6813 = G__6830;
chunk__6806_6814 = G__6831;
count__6807_6815 = G__6832;
i__6808_6816 = G__6833;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq6798){
var G__6799 = cljs.core.first(seq6798);
var seq6798__$1 = cljs.core.next(seq6798);
var G__6800 = cljs.core.first(seq6798__$1);
var seq6798__$2 = cljs.core.next(seq6798__$1);
var G__6801 = cljs.core.first(seq6798__$2);
var seq6798__$3 = cljs.core.next(seq6798__$2);
var G__6802 = cljs.core.first(seq6798__$3);
var seq6798__$4 = cljs.core.next(seq6798__$3);
var G__6803 = cljs.core.first(seq6798__$4);
var seq6798__$5 = cljs.core.next(seq6798__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6799,G__6800,G__6801,G__6802,G__6803,seq6798__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6834_6838 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6835_6839 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6836_6840 = true;
var _STAR_print_fn_STAR__temp_val__6837_6841 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6836_6840);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6837_6841);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6835_6839);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6834_6838);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__6842 = cljs.core.get_global_hierarchy;
return (fexpr__6842.cljs$core$IFn$_invoke$arity$0 ? fexpr__6842.cljs$core$IFn$_invoke$arity$0() : fexpr__6842.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__6843 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6843,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6843,(1),null);
var G__6846 = ns;
var G__6847 = name;
var G__6848 = (function (){
var G__6849 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__6849) : cljs.compiler.emit_constant.call(null,G__6849));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__6846,G__6847,G__6848) : cljs.compiler.emit_record_value.call(null,G__6846,G__6847,G__6848));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__6850 = cljs.core.keys(x);
var G__6851 = cljs.core.vals(x);
var G__6852 = cljs.compiler.emit_constants_comma_sep;
var G__6853 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__6850,G__6851,G__6852,G__6853) : cljs.compiler.emit_map.call(null,G__6850,G__6851,G__6852,G__6853));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__6854 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__6855 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__6854,G__6855) : cljs.compiler.emit_with_meta.call(null,G__6854,G__6855));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__6856 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6856,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6856,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6856,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__6859 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__6859) : x.call(null,G__6859));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__6860 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__6860) : x.call(null,G__6860));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__6862 = items;
var G__6863 = (function (p1__6861_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__6861_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__6862,G__6863) : cljs.compiler.emit_js_object.call(null,G__6862,G__6863));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6865){
var map__6866 = p__6865;
var map__6866__$1 = cljs.core.__destructure_map(map__6866);
var ast = map__6866__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6866__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6866__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6866__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5751__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6867 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__6867__$1 = cljs.core.__destructure_map(map__6867);
var cenv = map__6867__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6867__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4223__auto__ = js_module_name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6868 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4221__auto__ = (function (){var G__6869 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__6869) : cljs.compiler.es5_GT__EQ_.call(null,G__6869));
})();
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4221__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__6868,cljs.analyzer.es5_allowed);
} else {
return G__6868;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4223__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__6870 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__6870,reserved);
} else {
return G__6870;
}
})();
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__6871_6872 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6871_6873__$1 = (((G__6871_6872 instanceof cljs.core.Keyword))?G__6871_6872.fqn:null);
switch (G__6871_6873__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4221__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6875){
var map__6876 = p__6875;
var map__6876__$1 = cljs.core.__destructure_map(map__6876);
var arg = map__6876__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6876__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6876__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6876__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6876__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6877 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6877__$1 = cljs.core.__destructure_map(map__6877);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6877__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6878){
var map__6879 = p__6878;
var map__6879__$1 = cljs.core.__destructure_map(map__6879);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6879__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6879__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6879__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__6880_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6880_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__6881 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6881) : comma_sep.call(null,G__6881));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__6882 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6882) : comma_sep.call(null,G__6882));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6883){
var map__6884 = p__6883;
var map__6884__$1 = cljs.core.__destructure_map(map__6884);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6884__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6884__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6884__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6885){
var map__6886 = p__6885;
var map__6886__$1 = cljs.core.__destructure_map(map__6886);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6886__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6886__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__6887_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6887_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__6888 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__6888) : comma_sep.call(null,G__6888));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6889){
var map__6890 = p__6889;
var map__6890__$1 = cljs.core.__destructure_map(map__6890);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6890__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6890__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___6913 = cljs.core.seq(items);
if(temp__5753__auto___6913){
var items_6914__$1 = temp__5753__auto___6913;
var vec__6891_6915 = items_6914__$1;
var seq__6892_6916 = cljs.core.seq(vec__6891_6915);
var first__6893_6917 = cljs.core.first(seq__6892_6916);
var seq__6892_6918__$1 = cljs.core.next(seq__6892_6916);
var vec__6894_6919 = first__6893_6917;
var k_6920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6894_6919,(0),null);
var v_6921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6894_6919,(1),null);
var r_6922 = seq__6892_6918__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_6920),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_6921) : emit_js_object_val.call(null,v_6921)));

var seq__6897_6923 = cljs.core.seq(r_6922);
var chunk__6898_6924 = null;
var count__6899_6925 = (0);
var i__6900_6926 = (0);
while(true){
if((i__6900_6926 < count__6899_6925)){
var vec__6907_6927 = chunk__6898_6924.cljs$core$IIndexed$_nth$arity$2(null,i__6900_6926);
var k_6928__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6907_6927,(0),null);
var v_6929__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6907_6927,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_6928__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_6929__$1) : emit_js_object_val.call(null,v_6929__$1)));


var G__6930 = seq__6897_6923;
var G__6931 = chunk__6898_6924;
var G__6932 = count__6899_6925;
var G__6933 = (i__6900_6926 + (1));
seq__6897_6923 = G__6930;
chunk__6898_6924 = G__6931;
count__6899_6925 = G__6932;
i__6900_6926 = G__6933;
continue;
} else {
var temp__5753__auto___6934__$1 = cljs.core.seq(seq__6897_6923);
if(temp__5753__auto___6934__$1){
var seq__6897_6935__$1 = temp__5753__auto___6934__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6897_6935__$1)){
var c__4649__auto___6936 = cljs.core.chunk_first(seq__6897_6935__$1);
var G__6937 = cljs.core.chunk_rest(seq__6897_6935__$1);
var G__6938 = c__4649__auto___6936;
var G__6939 = cljs.core.count(c__4649__auto___6936);
var G__6940 = (0);
seq__6897_6923 = G__6937;
chunk__6898_6924 = G__6938;
count__6899_6925 = G__6939;
i__6900_6926 = G__6940;
continue;
} else {
var vec__6910_6941 = cljs.core.first(seq__6897_6935__$1);
var k_6942__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6910_6941,(0),null);
var v_6943__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6910_6941,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_6942__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_6943__$1) : emit_js_object_val.call(null,v_6943__$1)));


var G__6944 = cljs.core.next(seq__6897_6935__$1);
var G__6945 = null;
var G__6946 = (0);
var G__6947 = (0);
seq__6897_6923 = G__6944;
chunk__6898_6924 = G__6945;
count__6899_6925 = G__6946;
i__6900_6926 = G__6947;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__6948){
var map__6949 = p__6948;
var map__6949__$1 = cljs.core.__destructure_map(map__6949);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6949__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6949__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6949__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__6950){
var map__6951 = p__6950;
var map__6951__$1 = cljs.core.__destructure_map(map__6951);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6951__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6951__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__6952){
var map__6953 = p__6952;
var map__6953__$1 = cljs.core.__destructure_map(map__6953);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6953__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__6954){
var map__6955 = p__6954;
var map__6955__$1 = cljs.core.__destructure_map(map__6955);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6955__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6955__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__6956 = cljs.analyzer.unwrap_quote(expr);
var map__6956__$1 = cljs.core.__destructure_map(map__6956);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6956__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6956__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6956__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842));
if(and__4221__auto__){
var and__4221__auto____$1 = form;
if(cljs.core.truth_(and__4221__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__6957 = cljs.analyzer.unwrap_quote(expr);
var map__6957__$1 = cljs.core.__destructure_map(map__6957);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6957__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6957__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6957__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4223__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4223__auto__ = (function (){var fexpr__6958 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__6958.cljs$core$IFn$_invoke$arity$1 ? fexpr__6958.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__6958.call(null,tag));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__6959){
var map__6960 = p__6959;
var map__6960__$1 = cljs.core.__destructure_map(map__6960);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6960__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6960__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6960__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6960__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6960__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4223__auto__ = unchecked;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__6961){
var map__6962 = p__6961;
var map__6962__$1 = cljs.core.__destructure_map(map__6962);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6962__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__6963_6991 = cljs.core.seq(nodes);
var chunk__6964_6992 = null;
var count__6965_6993 = (0);
var i__6966_6994 = (0);
while(true){
if((i__6966_6994 < count__6965_6993)){
var map__6979_6995 = chunk__6964_6992.cljs$core$IIndexed$_nth$arity$2(null,i__6966_6994);
var map__6979_6996__$1 = cljs.core.__destructure_map(map__6979_6995);
var ts_6997 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6979_6996__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6980_6998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6979_6996__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6980_6999__$1 = cljs.core.__destructure_map(map__6980_6998);
var then_7000 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6980_6999__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6981_7001 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_6997));
var chunk__6982_7002 = null;
var count__6983_7003 = (0);
var i__6984_7004 = (0);
while(true){
if((i__6984_7004 < count__6983_7003)){
var test_7005 = chunk__6982_7002.cljs$core$IIndexed$_nth$arity$2(null,i__6984_7004);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7005,":");


var G__7006 = seq__6981_7001;
var G__7007 = chunk__6982_7002;
var G__7008 = count__6983_7003;
var G__7009 = (i__6984_7004 + (1));
seq__6981_7001 = G__7006;
chunk__6982_7002 = G__7007;
count__6983_7003 = G__7008;
i__6984_7004 = G__7009;
continue;
} else {
var temp__5753__auto___7010 = cljs.core.seq(seq__6981_7001);
if(temp__5753__auto___7010){
var seq__6981_7011__$1 = temp__5753__auto___7010;
if(cljs.core.chunked_seq_QMARK_(seq__6981_7011__$1)){
var c__4649__auto___7012 = cljs.core.chunk_first(seq__6981_7011__$1);
var G__7013 = cljs.core.chunk_rest(seq__6981_7011__$1);
var G__7014 = c__4649__auto___7012;
var G__7015 = cljs.core.count(c__4649__auto___7012);
var G__7016 = (0);
seq__6981_7001 = G__7013;
chunk__6982_7002 = G__7014;
count__6983_7003 = G__7015;
i__6984_7004 = G__7016;
continue;
} else {
var test_7017 = cljs.core.first(seq__6981_7011__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7017,":");


var G__7018 = cljs.core.next(seq__6981_7011__$1);
var G__7019 = null;
var G__7020 = (0);
var G__7021 = (0);
seq__6981_7001 = G__7018;
chunk__6982_7002 = G__7019;
count__6983_7003 = G__7020;
i__6984_7004 = G__7021;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7000);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7000);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7022 = seq__6963_6991;
var G__7023 = chunk__6964_6992;
var G__7024 = count__6965_6993;
var G__7025 = (i__6966_6994 + (1));
seq__6963_6991 = G__7022;
chunk__6964_6992 = G__7023;
count__6965_6993 = G__7024;
i__6966_6994 = G__7025;
continue;
} else {
var temp__5753__auto___7026 = cljs.core.seq(seq__6963_6991);
if(temp__5753__auto___7026){
var seq__6963_7027__$1 = temp__5753__auto___7026;
if(cljs.core.chunked_seq_QMARK_(seq__6963_7027__$1)){
var c__4649__auto___7028 = cljs.core.chunk_first(seq__6963_7027__$1);
var G__7029 = cljs.core.chunk_rest(seq__6963_7027__$1);
var G__7030 = c__4649__auto___7028;
var G__7031 = cljs.core.count(c__4649__auto___7028);
var G__7032 = (0);
seq__6963_6991 = G__7029;
chunk__6964_6992 = G__7030;
count__6965_6993 = G__7031;
i__6966_6994 = G__7032;
continue;
} else {
var map__6985_7033 = cljs.core.first(seq__6963_7027__$1);
var map__6985_7034__$1 = cljs.core.__destructure_map(map__6985_7033);
var ts_7035 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6985_7034__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6986_7036 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6985_7034__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6986_7037__$1 = cljs.core.__destructure_map(map__6986_7036);
var then_7038 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6986_7037__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6987_7039 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_7035));
var chunk__6988_7040 = null;
var count__6989_7041 = (0);
var i__6990_7042 = (0);
while(true){
if((i__6990_7042 < count__6989_7041)){
var test_7043 = chunk__6988_7040.cljs$core$IIndexed$_nth$arity$2(null,i__6990_7042);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7043,":");


var G__7044 = seq__6987_7039;
var G__7045 = chunk__6988_7040;
var G__7046 = count__6989_7041;
var G__7047 = (i__6990_7042 + (1));
seq__6987_7039 = G__7044;
chunk__6988_7040 = G__7045;
count__6989_7041 = G__7046;
i__6990_7042 = G__7047;
continue;
} else {
var temp__5753__auto___7048__$1 = cljs.core.seq(seq__6987_7039);
if(temp__5753__auto___7048__$1){
var seq__6987_7049__$1 = temp__5753__auto___7048__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6987_7049__$1)){
var c__4649__auto___7050 = cljs.core.chunk_first(seq__6987_7049__$1);
var G__7051 = cljs.core.chunk_rest(seq__6987_7049__$1);
var G__7052 = c__4649__auto___7050;
var G__7053 = cljs.core.count(c__4649__auto___7050);
var G__7054 = (0);
seq__6987_7039 = G__7051;
chunk__6988_7040 = G__7052;
count__6989_7041 = G__7053;
i__6990_7042 = G__7054;
continue;
} else {
var test_7055 = cljs.core.first(seq__6987_7049__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_7055,":");


var G__7056 = cljs.core.next(seq__6987_7049__$1);
var G__7057 = null;
var G__7058 = (0);
var G__7059 = (0);
seq__6987_7039 = G__7056;
chunk__6988_7040 = G__7057;
count__6989_7041 = G__7058;
i__6990_7042 = G__7059;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_7038);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_7038);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__7060 = cljs.core.next(seq__6963_7027__$1);
var G__7061 = null;
var G__7062 = (0);
var G__7063 = (0);
seq__6963_6991 = G__7060;
chunk__6964_6992 = G__7061;
count__6965_6993 = G__7062;
i__6966_6994 = G__7063;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__7064){
var map__7065 = p__7064;
var map__7065__$1 = cljs.core.__destructure_map(map__7065);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7065__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7065__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7069 = env;
var G__7070 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7069,G__7070) : cljs.compiler.resolve_type.call(null,G__7069,G__7070));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__7071 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7071,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7071,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__7066_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__7066_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__7066_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__7074 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__7074,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__7074;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__7077 = env;
var G__7078 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__7077,G__7078) : cljs.compiler.resolve_type.call(null,G__7077,G__7078));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7079_SHARP_){
return cljs.compiler.resolve_type(env,p1__7079_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__7080 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7081 = cljs.core.seq(vec__7080);
var first__7082 = cljs.core.first(seq__7081);
var seq__7081__$1 = cljs.core.next(seq__7081);
var p = first__7082;
var first__7082__$1 = cljs.core.first(seq__7081__$1);
var seq__7081__$2 = cljs.core.next(seq__7081__$1);
var ts = first__7082__$1;
var first__7082__$2 = cljs.core.first(seq__7081__$2);
var seq__7081__$3 = cljs.core.next(seq__7081__$2);
var n = first__7082__$2;
var xs = seq__7081__$3;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__7083 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__7084 = cljs.core.seq(vec__7083);
var first__7085 = cljs.core.first(seq__7084);
var seq__7084__$1 = cljs.core.next(seq__7084);
var p = first__7085;
var first__7085__$1 = cljs.core.first(seq__7084__$1);
var seq__7084__$2 = cljs.core.next(seq__7084__$1);
var ts = first__7085__$1;
var xs = seq__7084__$2;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__7087 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__7086 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__7086.cljs$core$IFn$_invoke$arity$1 ? fexpr__7086.cljs$core$IFn$_invoke$arity$1(G__7087) : fexpr__7086.call(null,G__7087));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__7090 = arguments.length;
switch (G__7090) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__7098 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7088_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__7088_SHARP_);
} else {
return p1__7088_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__7099 = cljs.core.seq(vec__7098);
var first__7100 = cljs.core.first(seq__7099);
var seq__7099__$1 = cljs.core.next(seq__7099);
var x = first__7100;
var ys = seq__7099__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__7101 = cljs.core.seq(ys);
var chunk__7102 = null;
var count__7103 = (0);
var i__7104 = (0);
while(true){
if((i__7104 < count__7103)){
var next_line = chunk__7102.cljs$core$IIndexed$_nth$arity$2(null,i__7104);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7110 = seq__7101;
var G__7111 = chunk__7102;
var G__7112 = count__7103;
var G__7113 = (i__7104 + (1));
seq__7101 = G__7110;
chunk__7102 = G__7111;
count__7103 = G__7112;
i__7104 = G__7113;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7101);
if(temp__5753__auto__){
var seq__7101__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7101__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__7101__$1);
var G__7114 = cljs.core.chunk_rest(seq__7101__$1);
var G__7115 = c__4649__auto__;
var G__7116 = cljs.core.count(c__4649__auto__);
var G__7117 = (0);
seq__7101 = G__7114;
chunk__7102 = G__7115;
count__7103 = G__7116;
i__7104 = G__7117;
continue;
} else {
var next_line = cljs.core.first(seq__7101__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__7118 = cljs.core.next(seq__7101__$1);
var G__7119 = null;
var G__7120 = (0);
var G__7121 = (0);
seq__7101 = G__7118;
chunk__7102 = G__7119;
count__7103 = G__7120;
i__7104 = G__7121;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__7105_7122 = cljs.core.seq(docs__$2);
var chunk__7106_7123 = null;
var count__7107_7124 = (0);
var i__7108_7125 = (0);
while(true){
if((i__7108_7125 < count__7107_7124)){
var e_7126 = chunk__7106_7123.cljs$core$IIndexed$_nth$arity$2(null,i__7108_7125);
if(cljs.core.truth_(e_7126)){
print_comment_lines(e_7126);
} else {
}


var G__7127 = seq__7105_7122;
var G__7128 = chunk__7106_7123;
var G__7129 = count__7107_7124;
var G__7130 = (i__7108_7125 + (1));
seq__7105_7122 = G__7127;
chunk__7106_7123 = G__7128;
count__7107_7124 = G__7129;
i__7108_7125 = G__7130;
continue;
} else {
var temp__5753__auto___7131 = cljs.core.seq(seq__7105_7122);
if(temp__5753__auto___7131){
var seq__7105_7132__$1 = temp__5753__auto___7131;
if(cljs.core.chunked_seq_QMARK_(seq__7105_7132__$1)){
var c__4649__auto___7133 = cljs.core.chunk_first(seq__7105_7132__$1);
var G__7134 = cljs.core.chunk_rest(seq__7105_7132__$1);
var G__7135 = c__4649__auto___7133;
var G__7136 = cljs.core.count(c__4649__auto___7133);
var G__7137 = (0);
seq__7105_7122 = G__7134;
chunk__7106_7123 = G__7135;
count__7107_7124 = G__7136;
i__7108_7125 = G__7137;
continue;
} else {
var e_7138 = cljs.core.first(seq__7105_7132__$1);
if(cljs.core.truth_(e_7138)){
print_comment_lines(e_7138);
} else {
}


var G__7139 = cljs.core.next(seq__7105_7132__$1);
var G__7140 = null;
var G__7141 = (0);
var G__7142 = (0);
seq__7105_7122 = G__7139;
chunk__7106_7123 = G__7140;
count__7107_7124 = G__7141;
i__7108_7125 = G__7142;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4221__auto__ = cljs.core.some((function (p1__7144_SHARP_){
return goog.string.startsWith(p1__7144_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = opts;
if(cljs.core.truth_(and__4221__auto____$1)){
var and__4221__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478));
if(and__4221__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4221__auto____$2;
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__7145){
var map__7146 = p__7145;
var map__7146__$1 = cljs.core.__destructure_map(map__7146);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7146__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4223__auto__ = init;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
return test;
} else {
return and__4221__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__7147){
var map__7148 = p__7147;
var map__7148__$1 = cljs.core.__destructure_map(map__7148);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7148__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7148__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7148__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__7149_7173 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__7150_7174 = null;
var count__7151_7175 = (0);
var i__7152_7176 = (0);
while(true){
if((i__7152_7176 < count__7151_7175)){
var vec__7159_7177 = chunk__7150_7174.cljs$core$IIndexed$_nth$arity$2(null,i__7152_7176);
var i_7178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7159_7177,(0),null);
var param_7179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7159_7177,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7179);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7180 = seq__7149_7173;
var G__7181 = chunk__7150_7174;
var G__7182 = count__7151_7175;
var G__7183 = (i__7152_7176 + (1));
seq__7149_7173 = G__7180;
chunk__7150_7174 = G__7181;
count__7151_7175 = G__7182;
i__7152_7176 = G__7183;
continue;
} else {
var temp__5753__auto___7184 = cljs.core.seq(seq__7149_7173);
if(temp__5753__auto___7184){
var seq__7149_7185__$1 = temp__5753__auto___7184;
if(cljs.core.chunked_seq_QMARK_(seq__7149_7185__$1)){
var c__4649__auto___7186 = cljs.core.chunk_first(seq__7149_7185__$1);
var G__7187 = cljs.core.chunk_rest(seq__7149_7185__$1);
var G__7188 = c__4649__auto___7186;
var G__7189 = cljs.core.count(c__4649__auto___7186);
var G__7190 = (0);
seq__7149_7173 = G__7187;
chunk__7150_7174 = G__7188;
count__7151_7175 = G__7189;
i__7152_7176 = G__7190;
continue;
} else {
var vec__7162_7191 = cljs.core.first(seq__7149_7185__$1);
var i_7192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7162_7191,(0),null);
var param_7193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7162_7191,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_7193);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__7194 = cljs.core.next(seq__7149_7185__$1);
var G__7195 = null;
var G__7196 = (0);
var G__7197 = (0);
seq__7149_7173 = G__7194;
chunk__7150_7174 = G__7195;
count__7151_7175 = G__7196;
i__7152_7176 = G__7197;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7165_7198 = cljs.core.seq(params);
var chunk__7166_7199 = null;
var count__7167_7200 = (0);
var i__7168_7201 = (0);
while(true){
if((i__7168_7201 < count__7167_7200)){
var param_7202 = chunk__7166_7199.cljs$core$IIndexed$_nth$arity$2(null,i__7168_7201);
cljs.compiler.emit(param_7202);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7202,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7203 = seq__7165_7198;
var G__7204 = chunk__7166_7199;
var G__7205 = count__7167_7200;
var G__7206 = (i__7168_7201 + (1));
seq__7165_7198 = G__7203;
chunk__7166_7199 = G__7204;
count__7167_7200 = G__7205;
i__7168_7201 = G__7206;
continue;
} else {
var temp__5753__auto___7207 = cljs.core.seq(seq__7165_7198);
if(temp__5753__auto___7207){
var seq__7165_7208__$1 = temp__5753__auto___7207;
if(cljs.core.chunked_seq_QMARK_(seq__7165_7208__$1)){
var c__4649__auto___7209 = cljs.core.chunk_first(seq__7165_7208__$1);
var G__7210 = cljs.core.chunk_rest(seq__7165_7208__$1);
var G__7211 = c__4649__auto___7209;
var G__7212 = cljs.core.count(c__4649__auto___7209);
var G__7213 = (0);
seq__7165_7198 = G__7210;
chunk__7166_7199 = G__7211;
count__7167_7200 = G__7212;
i__7168_7201 = G__7213;
continue;
} else {
var param_7214 = cljs.core.first(seq__7165_7208__$1);
cljs.compiler.emit(param_7214);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7214,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7215 = cljs.core.next(seq__7165_7208__$1);
var G__7216 = null;
var G__7217 = (0);
var G__7218 = (0);
seq__7165_7198 = G__7215;
chunk__7166_7199 = G__7216;
count__7167_7200 = G__7217;
i__7168_7201 = G__7218;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__7169_7219 = cljs.core.seq(params);
var chunk__7170_7220 = null;
var count__7171_7221 = (0);
var i__7172_7222 = (0);
while(true){
if((i__7172_7222 < count__7171_7221)){
var param_7223 = chunk__7170_7220.cljs$core$IIndexed$_nth$arity$2(null,i__7172_7222);
cljs.compiler.emit(param_7223);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7223,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7224 = seq__7169_7219;
var G__7225 = chunk__7170_7220;
var G__7226 = count__7171_7221;
var G__7227 = (i__7172_7222 + (1));
seq__7169_7219 = G__7224;
chunk__7170_7220 = G__7225;
count__7171_7221 = G__7226;
i__7172_7222 = G__7227;
continue;
} else {
var temp__5753__auto___7228 = cljs.core.seq(seq__7169_7219);
if(temp__5753__auto___7228){
var seq__7169_7229__$1 = temp__5753__auto___7228;
if(cljs.core.chunked_seq_QMARK_(seq__7169_7229__$1)){
var c__4649__auto___7230 = cljs.core.chunk_first(seq__7169_7229__$1);
var G__7231 = cljs.core.chunk_rest(seq__7169_7229__$1);
var G__7232 = c__4649__auto___7230;
var G__7233 = cljs.core.count(c__4649__auto___7230);
var G__7234 = (0);
seq__7169_7219 = G__7231;
chunk__7170_7220 = G__7232;
count__7171_7221 = G__7233;
i__7172_7222 = G__7234;
continue;
} else {
var param_7235 = cljs.core.first(seq__7169_7229__$1);
cljs.compiler.emit(param_7235);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7235,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7236 = cljs.core.next(seq__7169_7229__$1);
var G__7237 = null;
var G__7238 = (0);
var G__7239 = (0);
seq__7169_7219 = G__7236;
chunk__7170_7220 = G__7237;
count__7171_7221 = G__7238;
i__7172_7222 = G__7239;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__7240 = cljs.core.seq(params);
var chunk__7241 = null;
var count__7242 = (0);
var i__7243 = (0);
while(true){
if((i__7243 < count__7242)){
var param = chunk__7241.cljs$core$IIndexed$_nth$arity$2(null,i__7243);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7244 = seq__7240;
var G__7245 = chunk__7241;
var G__7246 = count__7242;
var G__7247 = (i__7243 + (1));
seq__7240 = G__7244;
chunk__7241 = G__7245;
count__7242 = G__7246;
i__7243 = G__7247;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7240);
if(temp__5753__auto__){
var seq__7240__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7240__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__7240__$1);
var G__7248 = cljs.core.chunk_rest(seq__7240__$1);
var G__7249 = c__4649__auto__;
var G__7250 = cljs.core.count(c__4649__auto__);
var G__7251 = (0);
seq__7240 = G__7248;
chunk__7241 = G__7249;
count__7242 = G__7250;
i__7243 = G__7251;
continue;
} else {
var param = cljs.core.first(seq__7240__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7252 = cljs.core.next(seq__7240__$1);
var G__7253 = null;
var G__7254 = (0);
var G__7255 = (0);
seq__7240 = G__7252;
chunk__7241 = G__7253;
count__7242 = G__7254;
i__7243 = G__7255;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__7256){
var map__7257 = p__7256;
var map__7257__$1 = cljs.core.__destructure_map(map__7257);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7257__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7257__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7257__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7257__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7257__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7257__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__7258){
var map__7259 = p__7258;
var map__7259__$1 = cljs.core.__destructure_map(map__7259);
var f = map__7259__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7259__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_7268__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7269 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7268__$1);
var delegate_name_7270 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7269),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_7270," = function (");

var seq__7260_7271 = cljs.core.seq(params);
var chunk__7261_7272 = null;
var count__7262_7273 = (0);
var i__7263_7274 = (0);
while(true){
if((i__7263_7274 < count__7262_7273)){
var param_7275 = chunk__7261_7272.cljs$core$IIndexed$_nth$arity$2(null,i__7263_7274);
cljs.compiler.emit(param_7275);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7275,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7276 = seq__7260_7271;
var G__7277 = chunk__7261_7272;
var G__7278 = count__7262_7273;
var G__7279 = (i__7263_7274 + (1));
seq__7260_7271 = G__7276;
chunk__7261_7272 = G__7277;
count__7262_7273 = G__7278;
i__7263_7274 = G__7279;
continue;
} else {
var temp__5753__auto___7280 = cljs.core.seq(seq__7260_7271);
if(temp__5753__auto___7280){
var seq__7260_7281__$1 = temp__5753__auto___7280;
if(cljs.core.chunked_seq_QMARK_(seq__7260_7281__$1)){
var c__4649__auto___7282 = cljs.core.chunk_first(seq__7260_7281__$1);
var G__7283 = cljs.core.chunk_rest(seq__7260_7281__$1);
var G__7284 = c__4649__auto___7282;
var G__7285 = cljs.core.count(c__4649__auto___7282);
var G__7286 = (0);
seq__7260_7271 = G__7283;
chunk__7261_7272 = G__7284;
count__7262_7273 = G__7285;
i__7263_7274 = G__7286;
continue;
} else {
var param_7287 = cljs.core.first(seq__7260_7281__$1);
cljs.compiler.emit(param_7287);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7287,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7288 = cljs.core.next(seq__7260_7281__$1);
var G__7289 = null;
var G__7290 = (0);
var G__7291 = (0);
seq__7260_7271 = G__7288;
chunk__7261_7272 = G__7289;
count__7262_7273 = G__7290;
i__7263_7274 = G__7291;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_7269," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_7292 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_7292,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_7270,".call(this,");

var seq__7264_7293 = cljs.core.seq(params);
var chunk__7265_7294 = null;
var count__7266_7295 = (0);
var i__7267_7296 = (0);
while(true){
if((i__7267_7296 < count__7266_7295)){
var param_7297 = chunk__7265_7294.cljs$core$IIndexed$_nth$arity$2(null,i__7267_7296);
cljs.compiler.emit(param_7297);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7297,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7298 = seq__7264_7293;
var G__7299 = chunk__7265_7294;
var G__7300 = count__7266_7295;
var G__7301 = (i__7267_7296 + (1));
seq__7264_7293 = G__7298;
chunk__7265_7294 = G__7299;
count__7266_7295 = G__7300;
i__7267_7296 = G__7301;
continue;
} else {
var temp__5753__auto___7302 = cljs.core.seq(seq__7264_7293);
if(temp__5753__auto___7302){
var seq__7264_7303__$1 = temp__5753__auto___7302;
if(cljs.core.chunked_seq_QMARK_(seq__7264_7303__$1)){
var c__4649__auto___7304 = cljs.core.chunk_first(seq__7264_7303__$1);
var G__7305 = cljs.core.chunk_rest(seq__7264_7303__$1);
var G__7306 = c__4649__auto___7304;
var G__7307 = cljs.core.count(c__4649__auto___7304);
var G__7308 = (0);
seq__7264_7293 = G__7305;
chunk__7265_7294 = G__7306;
count__7266_7295 = G__7307;
i__7267_7296 = G__7308;
continue;
} else {
var param_7309 = cljs.core.first(seq__7264_7303__$1);
cljs.compiler.emit(param_7309);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_7309,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__7310 = cljs.core.next(seq__7264_7303__$1);
var G__7311 = null;
var G__7312 = (0);
var G__7313 = (0);
seq__7264_7293 = G__7310;
chunk__7265_7294 = G__7311;
count__7266_7295 = G__7312;
i__7267_7296 = G__7313;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7269,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_7269,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_7268__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7269,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_7270,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7269,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__7317){
var map__7318 = p__7317;
var map__7318__$1 = cljs.core.__destructure_map(map__7318);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7318__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__7314_SHARP_){
var and__4221__auto__ = p1__7314_SHARP_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__7314_SHARP_));
} else {
return and__4221__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4223__auto__ = in_loop;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_7370__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_7371 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_7370__$1);
var maxparams_7372 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_7373 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_7371),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_7374 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__7315_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__7315_SHARP_)));
}),cljs.core.seq(mmap_7373));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_7371," = null;");

var seq__7319_7375 = cljs.core.seq(ms_7374);
var chunk__7320_7376 = null;
var count__7321_7377 = (0);
var i__7322_7378 = (0);
while(true){
if((i__7322_7378 < count__7321_7377)){
var vec__7329_7379 = chunk__7320_7376.cljs$core$IIndexed$_nth$arity$2(null,i__7322_7378);
var n_7380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7329_7379,(0),null);
var meth_7381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7329_7379,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7380," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7381))){
cljs.compiler.emit_variadic_fn_method(meth_7381);
} else {
cljs.compiler.emit_fn_method(meth_7381);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7382 = seq__7319_7375;
var G__7383 = chunk__7320_7376;
var G__7384 = count__7321_7377;
var G__7385 = (i__7322_7378 + (1));
seq__7319_7375 = G__7382;
chunk__7320_7376 = G__7383;
count__7321_7377 = G__7384;
i__7322_7378 = G__7385;
continue;
} else {
var temp__5753__auto___7386 = cljs.core.seq(seq__7319_7375);
if(temp__5753__auto___7386){
var seq__7319_7387__$1 = temp__5753__auto___7386;
if(cljs.core.chunked_seq_QMARK_(seq__7319_7387__$1)){
var c__4649__auto___7388 = cljs.core.chunk_first(seq__7319_7387__$1);
var G__7389 = cljs.core.chunk_rest(seq__7319_7387__$1);
var G__7390 = c__4649__auto___7388;
var G__7391 = cljs.core.count(c__4649__auto___7388);
var G__7392 = (0);
seq__7319_7375 = G__7389;
chunk__7320_7376 = G__7390;
count__7321_7377 = G__7391;
i__7322_7378 = G__7392;
continue;
} else {
var vec__7332_7393 = cljs.core.first(seq__7319_7387__$1);
var n_7394 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7332_7393,(0),null);
var meth_7395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7332_7393,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_7394," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7395))){
cljs.compiler.emit_variadic_fn_method(meth_7395);
} else {
cljs.compiler.emit_fn_method(meth_7395);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__7396 = cljs.core.next(seq__7319_7387__$1);
var G__7397 = null;
var G__7398 = (0);
var G__7399 = (0);
seq__7319_7375 = G__7396;
chunk__7320_7376 = G__7397;
count__7321_7377 = G__7398;
i__7322_7378 = G__7399;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7371," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_7372),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_7372)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_7372));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__7335_7400 = cljs.core.seq(ms_7374);
var chunk__7336_7401 = null;
var count__7337_7402 = (0);
var i__7338_7403 = (0);
while(true){
if((i__7338_7403 < count__7337_7402)){
var vec__7345_7404 = chunk__7336_7401.cljs$core$IIndexed$_nth$arity$2(null,i__7338_7403);
var n_7405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7345_7404,(0),null);
var meth_7406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7345_7404,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7406))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7407 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7407," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7408 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7407," = new cljs.core.IndexedSeq(",a_7408,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7405,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7372)),(((cljs.core.count(maxparams_7372) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7407,");"], 0));
} else {
var pcnt_7409 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7406));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7409,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7405,".call(this",(((pcnt_7409 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7409,maxparams_7372)),null,(1),null)),(2),null))),");");
}


var G__7410 = seq__7335_7400;
var G__7411 = chunk__7336_7401;
var G__7412 = count__7337_7402;
var G__7413 = (i__7338_7403 + (1));
seq__7335_7400 = G__7410;
chunk__7336_7401 = G__7411;
count__7337_7402 = G__7412;
i__7338_7403 = G__7413;
continue;
} else {
var temp__5753__auto___7414 = cljs.core.seq(seq__7335_7400);
if(temp__5753__auto___7414){
var seq__7335_7415__$1 = temp__5753__auto___7414;
if(cljs.core.chunked_seq_QMARK_(seq__7335_7415__$1)){
var c__4649__auto___7416 = cljs.core.chunk_first(seq__7335_7415__$1);
var G__7417 = cljs.core.chunk_rest(seq__7335_7415__$1);
var G__7418 = c__4649__auto___7416;
var G__7419 = cljs.core.count(c__4649__auto___7416);
var G__7420 = (0);
seq__7335_7400 = G__7417;
chunk__7336_7401 = G__7418;
count__7337_7402 = G__7419;
i__7338_7403 = G__7420;
continue;
} else {
var vec__7348_7421 = cljs.core.first(seq__7335_7415__$1);
var n_7422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7348_7421,(0),null);
var meth_7423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7348_7421,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7423))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_7424 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_7424," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_7425 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_7424," = new cljs.core.IndexedSeq(",a_7425,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_7422,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_7372)),(((cljs.core.count(maxparams_7372) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_7424,");"], 0));
} else {
var pcnt_7426 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7423));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_7426,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_7422,".call(this",(((pcnt_7426 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_7426,maxparams_7372)),null,(1),null)),(2),null))),");");
}


var G__7427 = cljs.core.next(seq__7335_7415__$1);
var G__7428 = null;
var G__7429 = (0);
var G__7430 = (0);
seq__7335_7400 = G__7427;
chunk__7336_7401 = G__7428;
count__7337_7402 = G__7429;
i__7338_7403 = G__7430;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_7431 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_7374)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_7431,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7371,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7371,".cljs$lang$applyTo = ",cljs.core.some((function (p1__7316_SHARP_){
var vec__7351 = p1__7316_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7351,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7351,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_7374),".cljs$lang$applyTo;");
} else {
}

var seq__7354_7432 = cljs.core.seq(ms_7374);
var chunk__7355_7433 = null;
var count__7356_7434 = (0);
var i__7357_7435 = (0);
while(true){
if((i__7357_7435 < count__7356_7434)){
var vec__7364_7436 = chunk__7355_7433.cljs$core$IIndexed$_nth$arity$2(null,i__7357_7435);
var n_7437 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7364_7436,(0),null);
var meth_7438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7364_7436,(1),null);
var c_7439 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7438));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7438))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7371,".cljs$core$IFn$_invoke$arity$variadic = ",n_7437,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7371,".cljs$core$IFn$_invoke$arity$",c_7439," = ",n_7437,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7440 = seq__7354_7432;
var G__7441 = chunk__7355_7433;
var G__7442 = count__7356_7434;
var G__7443 = (i__7357_7435 + (1));
seq__7354_7432 = G__7440;
chunk__7355_7433 = G__7441;
count__7356_7434 = G__7442;
i__7357_7435 = G__7443;
continue;
} else {
var temp__5753__auto___7444 = cljs.core.seq(seq__7354_7432);
if(temp__5753__auto___7444){
var seq__7354_7445__$1 = temp__5753__auto___7444;
if(cljs.core.chunked_seq_QMARK_(seq__7354_7445__$1)){
var c__4649__auto___7446 = cljs.core.chunk_first(seq__7354_7445__$1);
var G__7447 = cljs.core.chunk_rest(seq__7354_7445__$1);
var G__7448 = c__4649__auto___7446;
var G__7449 = cljs.core.count(c__4649__auto___7446);
var G__7450 = (0);
seq__7354_7432 = G__7447;
chunk__7355_7433 = G__7448;
count__7356_7434 = G__7449;
i__7357_7435 = G__7450;
continue;
} else {
var vec__7367_7451 = cljs.core.first(seq__7354_7445__$1);
var n_7452 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7367_7451,(0),null);
var meth_7453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7367_7451,(1),null);
var c_7454 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_7453));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_7453))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_7371,".cljs$core$IFn$_invoke$arity$variadic = ",n_7452,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_7371,".cljs$core$IFn$_invoke$arity$",c_7454," = ",n_7452,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__7455 = cljs.core.next(seq__7354_7445__$1);
var G__7456 = null;
var G__7457 = (0);
var G__7458 = (0);
seq__7354_7432 = G__7455;
chunk__7355_7433 = G__7456;
count__7356_7434 = G__7457;
i__7357_7435 = G__7458;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_7371,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__7459){
var map__7460 = p__7459;
var map__7460__$1 = cljs.core.__destructure_map(map__7460);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7460__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7460__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7460__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7461_7465 = cljs.core.seq(statements);
var chunk__7462_7466 = null;
var count__7463_7467 = (0);
var i__7464_7468 = (0);
while(true){
if((i__7464_7468 < count__7463_7467)){
var s_7469 = chunk__7462_7466.cljs$core$IIndexed$_nth$arity$2(null,i__7464_7468);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7469);


var G__7470 = seq__7461_7465;
var G__7471 = chunk__7462_7466;
var G__7472 = count__7463_7467;
var G__7473 = (i__7464_7468 + (1));
seq__7461_7465 = G__7470;
chunk__7462_7466 = G__7471;
count__7463_7467 = G__7472;
i__7464_7468 = G__7473;
continue;
} else {
var temp__5753__auto___7474 = cljs.core.seq(seq__7461_7465);
if(temp__5753__auto___7474){
var seq__7461_7475__$1 = temp__5753__auto___7474;
if(cljs.core.chunked_seq_QMARK_(seq__7461_7475__$1)){
var c__4649__auto___7476 = cljs.core.chunk_first(seq__7461_7475__$1);
var G__7477 = cljs.core.chunk_rest(seq__7461_7475__$1);
var G__7478 = c__4649__auto___7476;
var G__7479 = cljs.core.count(c__4649__auto___7476);
var G__7480 = (0);
seq__7461_7465 = G__7477;
chunk__7462_7466 = G__7478;
count__7463_7467 = G__7479;
i__7464_7468 = G__7480;
continue;
} else {
var s_7481 = cljs.core.first(seq__7461_7475__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_7481);


var G__7482 = cljs.core.next(seq__7461_7475__$1);
var G__7483 = null;
var G__7484 = (0);
var G__7485 = (0);
seq__7461_7465 = G__7482;
chunk__7462_7466 = G__7483;
count__7463_7467 = G__7484;
i__7464_7468 = G__7485;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__7486){
var map__7487 = p__7486;
var map__7487__$1 = cljs.core.__destructure_map(map__7487);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7487__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7487__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7487__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7487__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7487__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__7488,is_loop){
var map__7489 = p__7488;
var map__7489__$1 = cljs.core.__destructure_map(map__7489);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7489__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7489__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7489__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__7490_7500 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__7491_7501 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__7491_7501);

try{var seq__7492_7502 = cljs.core.seq(bindings);
var chunk__7493_7503 = null;
var count__7494_7504 = (0);
var i__7495_7505 = (0);
while(true){
if((i__7495_7505 < count__7494_7504)){
var map__7498_7506 = chunk__7493_7503.cljs$core$IIndexed$_nth$arity$2(null,i__7495_7505);
var map__7498_7507__$1 = cljs.core.__destructure_map(map__7498_7506);
var binding_7508 = map__7498_7507__$1;
var init_7509 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7498_7507__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7508);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7509,";");


var G__7510 = seq__7492_7502;
var G__7511 = chunk__7493_7503;
var G__7512 = count__7494_7504;
var G__7513 = (i__7495_7505 + (1));
seq__7492_7502 = G__7510;
chunk__7493_7503 = G__7511;
count__7494_7504 = G__7512;
i__7495_7505 = G__7513;
continue;
} else {
var temp__5753__auto___7514 = cljs.core.seq(seq__7492_7502);
if(temp__5753__auto___7514){
var seq__7492_7515__$1 = temp__5753__auto___7514;
if(cljs.core.chunked_seq_QMARK_(seq__7492_7515__$1)){
var c__4649__auto___7516 = cljs.core.chunk_first(seq__7492_7515__$1);
var G__7517 = cljs.core.chunk_rest(seq__7492_7515__$1);
var G__7518 = c__4649__auto___7516;
var G__7519 = cljs.core.count(c__4649__auto___7516);
var G__7520 = (0);
seq__7492_7502 = G__7517;
chunk__7493_7503 = G__7518;
count__7494_7504 = G__7519;
i__7495_7505 = G__7520;
continue;
} else {
var map__7499_7521 = cljs.core.first(seq__7492_7515__$1);
var map__7499_7522__$1 = cljs.core.__destructure_map(map__7499_7521);
var binding_7523 = map__7499_7522__$1;
var init_7524 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7499_7522__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_7523);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_7524,";");


var G__7525 = cljs.core.next(seq__7492_7515__$1);
var G__7526 = null;
var G__7527 = (0);
var G__7528 = (0);
seq__7492_7502 = G__7525;
chunk__7493_7503 = G__7526;
count__7494_7504 = G__7527;
i__7495_7505 = G__7528;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__7490_7500);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__7529){
var map__7530 = p__7529;
var map__7530__$1 = cljs.core.__destructure_map(map__7530);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7530__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7530__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7530__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4706__auto___7531 = cljs.core.count(exprs);
var i_7532 = (0);
while(true){
if((i_7532 < n__4706__auto___7531)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7532) : temps.call(null,i_7532))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_7532) : exprs.call(null,i_7532)),";");

var G__7533 = (i_7532 + (1));
i_7532 = G__7533;
continue;
} else {
}
break;
}

var n__4706__auto___7534 = cljs.core.count(exprs);
var i_7535 = (0);
while(true){
if((i_7535 < n__4706__auto___7534)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_7535) : params.call(null,i_7535)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_7535) : temps.call(null,i_7535)),";");

var G__7536 = (i_7535 + (1));
i_7535 = G__7536;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__7537){
var map__7538 = p__7537;
var map__7538__$1 = cljs.core.__destructure_map(map__7538);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7538__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7538__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7538__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__7539_7547 = cljs.core.seq(bindings);
var chunk__7540_7548 = null;
var count__7541_7549 = (0);
var i__7542_7550 = (0);
while(true){
if((i__7542_7550 < count__7541_7549)){
var map__7545_7551 = chunk__7540_7548.cljs$core$IIndexed$_nth$arity$2(null,i__7542_7550);
var map__7545_7552__$1 = cljs.core.__destructure_map(map__7545_7551);
var binding_7553 = map__7545_7552__$1;
var init_7554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7545_7552__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7553)," = ",init_7554,";");


var G__7555 = seq__7539_7547;
var G__7556 = chunk__7540_7548;
var G__7557 = count__7541_7549;
var G__7558 = (i__7542_7550 + (1));
seq__7539_7547 = G__7555;
chunk__7540_7548 = G__7556;
count__7541_7549 = G__7557;
i__7542_7550 = G__7558;
continue;
} else {
var temp__5753__auto___7559 = cljs.core.seq(seq__7539_7547);
if(temp__5753__auto___7559){
var seq__7539_7560__$1 = temp__5753__auto___7559;
if(cljs.core.chunked_seq_QMARK_(seq__7539_7560__$1)){
var c__4649__auto___7561 = cljs.core.chunk_first(seq__7539_7560__$1);
var G__7562 = cljs.core.chunk_rest(seq__7539_7560__$1);
var G__7563 = c__4649__auto___7561;
var G__7564 = cljs.core.count(c__4649__auto___7561);
var G__7565 = (0);
seq__7539_7547 = G__7562;
chunk__7540_7548 = G__7563;
count__7541_7549 = G__7564;
i__7542_7550 = G__7565;
continue;
} else {
var map__7546_7566 = cljs.core.first(seq__7539_7560__$1);
var map__7546_7567__$1 = cljs.core.__destructure_map(map__7546_7566);
var binding_7568 = map__7546_7567__$1;
var init_7569 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7546_7567__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_7568)," = ",init_7569,";");


var G__7570 = cljs.core.next(seq__7539_7560__$1);
var G__7571 = null;
var G__7572 = (0);
var G__7573 = (0);
seq__7539_7547 = G__7570;
chunk__7540_7548 = G__7571;
count__7541_7549 = G__7572;
i__7542_7550 = G__7573;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__7576){
var map__7577 = p__7576;
var map__7577__$1 = cljs.core.__destructure_map(map__7577);
var expr = map__7577__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7577__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7577__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7577__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info));
if(and__4221__auto____$1){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4221__auto__ = protocol;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = tag;
if(cljs.core.truth_(and__4221__auto____$1)){
var or__4223__auto__ = (function (){var and__4221__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto____$2)){
var and__4221__auto____$3 = protocol;
if(cljs.core.truth_(and__4221__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4221__auto____$3;
}
} else {
return and__4221__auto____$2;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto____$2 = (function (){var or__4223__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4221__auto____$2)){
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
var and__4221__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4221__auto____$3){
var and__4221__auto____$4 = cljs.core.not((function (){var fexpr__7581 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__7581.cljs$core$IFn$_invoke$arity$1 ? fexpr__7581.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__7581.call(null,tag));
})());
if(and__4221__auto____$4){
var temp__5753__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4221__auto____$4;
}
} else {
return and__4221__auto____$3;
}
}
} else {
return and__4221__auto____$2;
}
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__7582 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__7582.cljs$core$IFn$_invoke$arity$1 ? fexpr__7582.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__7582.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__7578 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (arity > mfa);
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7574_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7574_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__7575_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__7575_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7578,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7578,(1),null);
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_7585 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_7585,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_7586 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_7586,args)),(((mfa_7586 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_7586,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var G__7584 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__7583 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__7583.cljs$core$IFn$_invoke$arity$1 ? fexpr__7583.cljs$core$IFn$_invoke$arity$1(G__7584) : fexpr__7583.call(null,G__7584));
} else {
return and__4221__auto__;
}
})())){
var fprop_7587 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7587," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7587,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_7587," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_7587,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__7588){
var map__7589 = p__7588;
var map__7589__$1 = cljs.core.__destructure_map(map__7589);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7589__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7589__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7589__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__7590){
var map__7591 = p__7590;
var map__7591__$1 = cljs.core.__destructure_map(map__7591);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7591__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7591__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7591__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7592_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7592_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__7593 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7593,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7593,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__7596 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__7596__$1 = cljs.core.__destructure_map(map__7596);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7596__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7596__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__7597 = options;
var map__7597__$1 = cljs.core.__destructure_map(map__7597);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7597__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7597__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7597__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__7598 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__7601 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__7601__$1 = cljs.core.__destructure_map(map__7601);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7601__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7601__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7598,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7598,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__7602_7630 = cljs.core.seq(libs_to_load);
var chunk__7603_7631 = null;
var count__7604_7632 = (0);
var i__7605_7633 = (0);
while(true){
if((i__7605_7633 < count__7604_7632)){
var lib_7634 = chunk__7603_7631.cljs$core$IIndexed$_nth$arity$2(null,i__7605_7633);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7634)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7634),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7634),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7634),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7634),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7634,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7634),"');");
}

}
}
}


var G__7635 = seq__7602_7630;
var G__7636 = chunk__7603_7631;
var G__7637 = count__7604_7632;
var G__7638 = (i__7605_7633 + (1));
seq__7602_7630 = G__7635;
chunk__7603_7631 = G__7636;
count__7604_7632 = G__7637;
i__7605_7633 = G__7638;
continue;
} else {
var temp__5753__auto___7639 = cljs.core.seq(seq__7602_7630);
if(temp__5753__auto___7639){
var seq__7602_7640__$1 = temp__5753__auto___7639;
if(cljs.core.chunked_seq_QMARK_(seq__7602_7640__$1)){
var c__4649__auto___7641 = cljs.core.chunk_first(seq__7602_7640__$1);
var G__7642 = cljs.core.chunk_rest(seq__7602_7640__$1);
var G__7643 = c__4649__auto___7641;
var G__7644 = cljs.core.count(c__4649__auto___7641);
var G__7645 = (0);
seq__7602_7630 = G__7642;
chunk__7603_7631 = G__7643;
count__7604_7632 = G__7644;
i__7605_7633 = G__7645;
continue;
} else {
var lib_7646 = cljs.core.first(seq__7602_7640__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_7646)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7646),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7646),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_7646),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7646),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_7646,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_7646),"');");
}

}
}
}


var G__7647 = cljs.core.next(seq__7602_7640__$1);
var G__7648 = null;
var G__7649 = (0);
var G__7650 = (0);
seq__7602_7630 = G__7647;
chunk__7603_7631 = G__7648;
count__7604_7632 = G__7649;
i__7605_7633 = G__7650;
continue;
}
} else {
}
}
break;
}

var seq__7606_7651 = cljs.core.seq(node_libs);
var chunk__7607_7652 = null;
var count__7608_7653 = (0);
var i__7609_7654 = (0);
while(true){
if((i__7609_7654 < count__7608_7653)){
var lib_7655 = chunk__7607_7652.cljs$core$IIndexed$_nth$arity$2(null,i__7609_7654);
var vec__7616_7656 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7655);
var lib_SINGLEQUOTE__7657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7616_7656,(0),null);
var sublib_7658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7616_7656,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7655)," = require('",lib_SINGLEQUOTE__7657,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7658),";"], 0));


var G__7659 = seq__7606_7651;
var G__7660 = chunk__7607_7652;
var G__7661 = count__7608_7653;
var G__7662 = (i__7609_7654 + (1));
seq__7606_7651 = G__7659;
chunk__7607_7652 = G__7660;
count__7608_7653 = G__7661;
i__7609_7654 = G__7662;
continue;
} else {
var temp__5753__auto___7663 = cljs.core.seq(seq__7606_7651);
if(temp__5753__auto___7663){
var seq__7606_7664__$1 = temp__5753__auto___7663;
if(cljs.core.chunked_seq_QMARK_(seq__7606_7664__$1)){
var c__4649__auto___7665 = cljs.core.chunk_first(seq__7606_7664__$1);
var G__7666 = cljs.core.chunk_rest(seq__7606_7664__$1);
var G__7667 = c__4649__auto___7665;
var G__7668 = cljs.core.count(c__4649__auto___7665);
var G__7669 = (0);
seq__7606_7651 = G__7666;
chunk__7607_7652 = G__7667;
count__7608_7653 = G__7668;
i__7609_7654 = G__7669;
continue;
} else {
var lib_7670 = cljs.core.first(seq__7606_7664__$1);
var vec__7619_7671 = cljs.analyzer.lib_AMPERSAND_sublib(lib_7670);
var lib_SINGLEQUOTE__7672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7619_7671,(0),null);
var sublib_7673 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7619_7671,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_7670)," = require('",lib_SINGLEQUOTE__7672,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_7673),";"], 0));


var G__7674 = cljs.core.next(seq__7606_7664__$1);
var G__7675 = null;
var G__7676 = (0);
var G__7677 = (0);
seq__7606_7651 = G__7674;
chunk__7607_7652 = G__7675;
count__7608_7653 = G__7676;
i__7609_7654 = G__7677;
continue;
}
} else {
}
}
break;
}

var seq__7622_7678 = cljs.core.seq(global_exports_libs);
var chunk__7623_7679 = null;
var count__7624_7680 = (0);
var i__7625_7681 = (0);
while(true){
if((i__7625_7681 < count__7624_7680)){
var lib_7682 = chunk__7623_7679.cljs$core$IIndexed$_nth$arity$2(null,i__7625_7681);
var map__7628_7683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7682))));
var map__7628_7684__$1 = cljs.core.__destructure_map(map__7628_7683);
var global_exports_7685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7628_7684__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7685,lib_7682);


var G__7686 = seq__7622_7678;
var G__7687 = chunk__7623_7679;
var G__7688 = count__7624_7680;
var G__7689 = (i__7625_7681 + (1));
seq__7622_7678 = G__7686;
chunk__7623_7679 = G__7687;
count__7624_7680 = G__7688;
i__7625_7681 = G__7689;
continue;
} else {
var temp__5753__auto___7690 = cljs.core.seq(seq__7622_7678);
if(temp__5753__auto___7690){
var seq__7622_7691__$1 = temp__5753__auto___7690;
if(cljs.core.chunked_seq_QMARK_(seq__7622_7691__$1)){
var c__4649__auto___7692 = cljs.core.chunk_first(seq__7622_7691__$1);
var G__7693 = cljs.core.chunk_rest(seq__7622_7691__$1);
var G__7694 = c__4649__auto___7692;
var G__7695 = cljs.core.count(c__4649__auto___7692);
var G__7696 = (0);
seq__7622_7678 = G__7693;
chunk__7623_7679 = G__7694;
count__7624_7680 = G__7695;
i__7625_7681 = G__7696;
continue;
} else {
var lib_7697 = cljs.core.first(seq__7622_7691__$1);
var map__7629_7698 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_7697))));
var map__7629_7699__$1 = cljs.core.__destructure_map(map__7629_7698);
var global_exports_7700 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7629_7699__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_7700,lib_7697);


var G__7701 = cljs.core.next(seq__7622_7691__$1);
var G__7702 = null;
var G__7703 = (0);
var G__7704 = (0);
seq__7622_7678 = G__7701;
chunk__7623_7679 = G__7702;
count__7624_7680 = G__7703;
i__7625_7681 = G__7704;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__7705){
var map__7706 = p__7705;
var map__7706__$1 = cljs.core.__destructure_map(map__7706);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7706__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7706__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7706__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7706__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7706__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7706__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7706__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__7707){
var map__7708 = p__7707;
var map__7708__$1 = cljs.core.__destructure_map(map__7708);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7708__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7708__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7708__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7708__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7708__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7708__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7708__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__7709){
var map__7710 = p__7709;
var map__7710__$1 = cljs.core.__destructure_map(map__7710);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7710__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7710__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7710__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7710__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7710__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7711_7735 = cljs.core.seq(protocols);
var chunk__7712_7736 = null;
var count__7713_7737 = (0);
var i__7714_7738 = (0);
while(true){
if((i__7714_7738 < count__7713_7737)){
var protocol_7739 = chunk__7712_7736.cljs$core$IIndexed$_nth$arity$2(null,i__7714_7738);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7739)),"}");


var G__7740 = seq__7711_7735;
var G__7741 = chunk__7712_7736;
var G__7742 = count__7713_7737;
var G__7743 = (i__7714_7738 + (1));
seq__7711_7735 = G__7740;
chunk__7712_7736 = G__7741;
count__7713_7737 = G__7742;
i__7714_7738 = G__7743;
continue;
} else {
var temp__5753__auto___7744 = cljs.core.seq(seq__7711_7735);
if(temp__5753__auto___7744){
var seq__7711_7745__$1 = temp__5753__auto___7744;
if(cljs.core.chunked_seq_QMARK_(seq__7711_7745__$1)){
var c__4649__auto___7746 = cljs.core.chunk_first(seq__7711_7745__$1);
var G__7747 = cljs.core.chunk_rest(seq__7711_7745__$1);
var G__7748 = c__4649__auto___7746;
var G__7749 = cljs.core.count(c__4649__auto___7746);
var G__7750 = (0);
seq__7711_7735 = G__7747;
chunk__7712_7736 = G__7748;
count__7713_7737 = G__7749;
i__7714_7738 = G__7750;
continue;
} else {
var protocol_7751 = cljs.core.first(seq__7711_7745__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7751)),"}");


var G__7752 = cljs.core.next(seq__7711_7745__$1);
var G__7753 = null;
var G__7754 = (0);
var G__7755 = (0);
seq__7711_7735 = G__7752;
chunk__7712_7736 = G__7753;
count__7713_7737 = G__7754;
i__7714_7738 = G__7755;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7715_7756 = cljs.core.seq(fields__$1);
var chunk__7716_7757 = null;
var count__7717_7758 = (0);
var i__7718_7759 = (0);
while(true){
if((i__7718_7759 < count__7717_7758)){
var fld_7760 = chunk__7716_7757.cljs$core$IIndexed$_nth$arity$2(null,i__7718_7759);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7760," = ",fld_7760,";");


var G__7761 = seq__7715_7756;
var G__7762 = chunk__7716_7757;
var G__7763 = count__7717_7758;
var G__7764 = (i__7718_7759 + (1));
seq__7715_7756 = G__7761;
chunk__7716_7757 = G__7762;
count__7717_7758 = G__7763;
i__7718_7759 = G__7764;
continue;
} else {
var temp__5753__auto___7765 = cljs.core.seq(seq__7715_7756);
if(temp__5753__auto___7765){
var seq__7715_7766__$1 = temp__5753__auto___7765;
if(cljs.core.chunked_seq_QMARK_(seq__7715_7766__$1)){
var c__4649__auto___7767 = cljs.core.chunk_first(seq__7715_7766__$1);
var G__7768 = cljs.core.chunk_rest(seq__7715_7766__$1);
var G__7769 = c__4649__auto___7767;
var G__7770 = cljs.core.count(c__4649__auto___7767);
var G__7771 = (0);
seq__7715_7756 = G__7768;
chunk__7716_7757 = G__7769;
count__7717_7758 = G__7770;
i__7718_7759 = G__7771;
continue;
} else {
var fld_7772 = cljs.core.first(seq__7715_7766__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7772," = ",fld_7772,";");


var G__7773 = cljs.core.next(seq__7715_7766__$1);
var G__7774 = null;
var G__7775 = (0);
var G__7776 = (0);
seq__7715_7756 = G__7773;
chunk__7716_7757 = G__7774;
count__7717_7758 = G__7775;
i__7718_7759 = G__7776;
continue;
}
} else {
}
}
break;
}

var seq__7719_7777 = cljs.core.seq(pmasks);
var chunk__7720_7778 = null;
var count__7721_7779 = (0);
var i__7722_7780 = (0);
while(true){
if((i__7722_7780 < count__7721_7779)){
var vec__7729_7781 = chunk__7720_7778.cljs$core$IIndexed$_nth$arity$2(null,i__7722_7780);
var pno_7782 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7729_7781,(0),null);
var pmask_7783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7729_7781,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7782,"$ = ",pmask_7783,";");


var G__7784 = seq__7719_7777;
var G__7785 = chunk__7720_7778;
var G__7786 = count__7721_7779;
var G__7787 = (i__7722_7780 + (1));
seq__7719_7777 = G__7784;
chunk__7720_7778 = G__7785;
count__7721_7779 = G__7786;
i__7722_7780 = G__7787;
continue;
} else {
var temp__5753__auto___7788 = cljs.core.seq(seq__7719_7777);
if(temp__5753__auto___7788){
var seq__7719_7789__$1 = temp__5753__auto___7788;
if(cljs.core.chunked_seq_QMARK_(seq__7719_7789__$1)){
var c__4649__auto___7790 = cljs.core.chunk_first(seq__7719_7789__$1);
var G__7791 = cljs.core.chunk_rest(seq__7719_7789__$1);
var G__7792 = c__4649__auto___7790;
var G__7793 = cljs.core.count(c__4649__auto___7790);
var G__7794 = (0);
seq__7719_7777 = G__7791;
chunk__7720_7778 = G__7792;
count__7721_7779 = G__7793;
i__7722_7780 = G__7794;
continue;
} else {
var vec__7732_7795 = cljs.core.first(seq__7719_7789__$1);
var pno_7796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7732_7795,(0),null);
var pmask_7797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7732_7795,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7796,"$ = ",pmask_7797,";");


var G__7798 = cljs.core.next(seq__7719_7789__$1);
var G__7799 = null;
var G__7800 = (0);
var G__7801 = (0);
seq__7719_7777 = G__7798;
chunk__7720_7778 = G__7799;
count__7721_7779 = G__7800;
i__7722_7780 = G__7801;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7802){
var map__7803 = p__7802;
var map__7803__$1 = cljs.core.__destructure_map(map__7803);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7803__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7803__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7803__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7803__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7803__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__7804_7828 = cljs.core.seq(protocols);
var chunk__7805_7829 = null;
var count__7806_7830 = (0);
var i__7807_7831 = (0);
while(true){
if((i__7807_7831 < count__7806_7830)){
var protocol_7832 = chunk__7805_7829.cljs$core$IIndexed$_nth$arity$2(null,i__7807_7831);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7832)),"}");


var G__7833 = seq__7804_7828;
var G__7834 = chunk__7805_7829;
var G__7835 = count__7806_7830;
var G__7836 = (i__7807_7831 + (1));
seq__7804_7828 = G__7833;
chunk__7805_7829 = G__7834;
count__7806_7830 = G__7835;
i__7807_7831 = G__7836;
continue;
} else {
var temp__5753__auto___7837 = cljs.core.seq(seq__7804_7828);
if(temp__5753__auto___7837){
var seq__7804_7838__$1 = temp__5753__auto___7837;
if(cljs.core.chunked_seq_QMARK_(seq__7804_7838__$1)){
var c__4649__auto___7839 = cljs.core.chunk_first(seq__7804_7838__$1);
var G__7840 = cljs.core.chunk_rest(seq__7804_7838__$1);
var G__7841 = c__4649__auto___7839;
var G__7842 = cljs.core.count(c__4649__auto___7839);
var G__7843 = (0);
seq__7804_7828 = G__7840;
chunk__7805_7829 = G__7841;
count__7806_7830 = G__7842;
i__7807_7831 = G__7843;
continue;
} else {
var protocol_7844 = cljs.core.first(seq__7804_7838__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7844)),"}");


var G__7845 = cljs.core.next(seq__7804_7838__$1);
var G__7846 = null;
var G__7847 = (0);
var G__7848 = (0);
seq__7804_7828 = G__7845;
chunk__7805_7829 = G__7846;
count__7806_7830 = G__7847;
i__7807_7831 = G__7848;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__7808_7849 = cljs.core.seq(fields__$1);
var chunk__7809_7850 = null;
var count__7810_7851 = (0);
var i__7811_7852 = (0);
while(true){
if((i__7811_7852 < count__7810_7851)){
var fld_7853 = chunk__7809_7850.cljs$core$IIndexed$_nth$arity$2(null,i__7811_7852);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7853," = ",fld_7853,";");


var G__7854 = seq__7808_7849;
var G__7855 = chunk__7809_7850;
var G__7856 = count__7810_7851;
var G__7857 = (i__7811_7852 + (1));
seq__7808_7849 = G__7854;
chunk__7809_7850 = G__7855;
count__7810_7851 = G__7856;
i__7811_7852 = G__7857;
continue;
} else {
var temp__5753__auto___7858 = cljs.core.seq(seq__7808_7849);
if(temp__5753__auto___7858){
var seq__7808_7859__$1 = temp__5753__auto___7858;
if(cljs.core.chunked_seq_QMARK_(seq__7808_7859__$1)){
var c__4649__auto___7860 = cljs.core.chunk_first(seq__7808_7859__$1);
var G__7861 = cljs.core.chunk_rest(seq__7808_7859__$1);
var G__7862 = c__4649__auto___7860;
var G__7863 = cljs.core.count(c__4649__auto___7860);
var G__7864 = (0);
seq__7808_7849 = G__7861;
chunk__7809_7850 = G__7862;
count__7810_7851 = G__7863;
i__7811_7852 = G__7864;
continue;
} else {
var fld_7865 = cljs.core.first(seq__7808_7859__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_7865," = ",fld_7865,";");


var G__7866 = cljs.core.next(seq__7808_7859__$1);
var G__7867 = null;
var G__7868 = (0);
var G__7869 = (0);
seq__7808_7849 = G__7866;
chunk__7809_7850 = G__7867;
count__7810_7851 = G__7868;
i__7811_7852 = G__7869;
continue;
}
} else {
}
}
break;
}

var seq__7812_7870 = cljs.core.seq(pmasks);
var chunk__7813_7871 = null;
var count__7814_7872 = (0);
var i__7815_7873 = (0);
while(true){
if((i__7815_7873 < count__7814_7872)){
var vec__7822_7874 = chunk__7813_7871.cljs$core$IIndexed$_nth$arity$2(null,i__7815_7873);
var pno_7875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7822_7874,(0),null);
var pmask_7876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7822_7874,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7875,"$ = ",pmask_7876,";");


var G__7877 = seq__7812_7870;
var G__7878 = chunk__7813_7871;
var G__7879 = count__7814_7872;
var G__7880 = (i__7815_7873 + (1));
seq__7812_7870 = G__7877;
chunk__7813_7871 = G__7878;
count__7814_7872 = G__7879;
i__7815_7873 = G__7880;
continue;
} else {
var temp__5753__auto___7881 = cljs.core.seq(seq__7812_7870);
if(temp__5753__auto___7881){
var seq__7812_7882__$1 = temp__5753__auto___7881;
if(cljs.core.chunked_seq_QMARK_(seq__7812_7882__$1)){
var c__4649__auto___7883 = cljs.core.chunk_first(seq__7812_7882__$1);
var G__7884 = cljs.core.chunk_rest(seq__7812_7882__$1);
var G__7885 = c__4649__auto___7883;
var G__7886 = cljs.core.count(c__4649__auto___7883);
var G__7887 = (0);
seq__7812_7870 = G__7884;
chunk__7813_7871 = G__7885;
count__7814_7872 = G__7886;
i__7815_7873 = G__7887;
continue;
} else {
var vec__7825_7888 = cljs.core.first(seq__7812_7882__$1);
var pno_7889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7825_7888,(0),null);
var pmask_7890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7825_7888,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_7889,"$ = ",pmask_7890,";");


var G__7891 = cljs.core.next(seq__7812_7882__$1);
var G__7892 = null;
var G__7893 = (0);
var G__7894 = (0);
seq__7812_7870 = G__7891;
chunk__7813_7871 = G__7892;
count__7814_7872 = G__7893;
i__7815_7873 = G__7894;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__7895){
var map__7896 = p__7895;
var map__7896__$1 = cljs.core.__destructure_map(map__7896);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7896__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7896__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7896__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7896__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7896__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__7897){
var map__7898 = p__7897;
var map__7898__$1 = cljs.core.__destructure_map(map__7898);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7898__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7898__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7898__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7898__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7898__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4221__auto__ = code;
if(cljs.core.truth_(and__4221__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4221__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__6698__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__6698__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__7903 = cljs.core.seq(table);
var chunk__7904 = null;
var count__7905 = (0);
var i__7906 = (0);
while(true){
if((i__7906 < count__7905)){
var vec__7913 = chunk__7904.cljs$core$IIndexed$_nth$arity$2(null,i__7906);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7913,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7913,(1),null);
var ns_7919 = cljs.core.namespace(sym);
var name_7920 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__7921 = seq__7903;
var G__7922 = chunk__7904;
var G__7923 = count__7905;
var G__7924 = (i__7906 + (1));
seq__7903 = G__7921;
chunk__7904 = G__7922;
count__7905 = G__7923;
i__7906 = G__7924;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7903);
if(temp__5753__auto__){
var seq__7903__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7903__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__7903__$1);
var G__7925 = cljs.core.chunk_rest(seq__7903__$1);
var G__7926 = c__4649__auto__;
var G__7927 = cljs.core.count(c__4649__auto__);
var G__7928 = (0);
seq__7903 = G__7925;
chunk__7904 = G__7926;
count__7905 = G__7927;
i__7906 = G__7928;
continue;
} else {
var vec__7916 = cljs.core.first(seq__7903__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7916,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7916,(1),null);
var ns_7929 = cljs.core.namespace(sym);
var name_7930 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__7931 = cljs.core.next(seq__7903__$1);
var G__7932 = null;
var G__7933 = (0);
var G__7934 = (0);
seq__7903 = G__7931;
chunk__7904 = G__7932;
count__7905 = G__7933;
i__7906 = G__7934;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__7936 = arguments.length;
switch (G__7936) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_7941 = cljs.core.first(ks);
var vec__7937_7942 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_7941);
var top_7943 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7937_7942,(0),null);
var prefix_SINGLEQUOTE__7944 = vec__7937_7942;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_7941)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__7944) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_7943)) || (cljs.core.contains_QMARK_(known_externs,top_7943)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__7944)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_7943);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__7944)),";");
}
} else {
}

var m_7945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_7941);
if(cljs.core.empty_QMARK_(m_7945)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__7944,m_7945,top_level,known_externs);
}

var G__7946 = cljs.core.next(ks);
ks = G__7946;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

