// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__64692 = arguments.length;
switch (G__64692) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___64731 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64713){
var state_val_64714 = (state_64713[(1)]);
if((state_val_64714 === (1))){
var state_64713__$1 = state_64713;
var statearr_64715_64732 = state_64713__$1;
(statearr_64715_64732[(2)] = null);

(statearr_64715_64732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64714 === (2))){
var _ = (function (){var statearr_64716 = state_64713;
(statearr_64716[(4)] = cljs.core.cons((5),(state_64713[(4)])));

return statearr_64716;
})();
var inst_64699 = fluree.db.session.db(conn,ledger,null);
var state_64713__$1 = state_64713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64713__$1,(7),inst_64699);
} else {
if((state_val_64714 === (3))){
var inst_64709 = (state_64713[(2)]);
var inst_64710 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64709);
var inst_64711 = cljs.core.async.close_BANG_(pc);
var state_64713__$1 = (function (){var statearr_64718 = state_64713;
(statearr_64718[(7)] = inst_64710);

return statearr_64718;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64713__$1,inst_64711);
} else {
if((state_val_64714 === (4))){
var inst_64693 = (state_64713[(2)]);
var state_64713__$1 = state_64713;
var statearr_64719_64733 = state_64713__$1;
(statearr_64719_64733[(2)] = inst_64693);

(statearr_64719_64733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64714 === (5))){
var _ = (function (){var statearr_64720 = state_64713;
(statearr_64720[(4)] = cljs.core.rest((state_64713[(4)])));

return statearr_64720;
})();
var state_64713__$1 = state_64713;
var ex64717 = (state_64713__$1[(2)]);
var statearr_64721_64734 = state_64713__$1;
(statearr_64721_64734[(5)] = ex64717);


var statearr_64722_64735 = state_64713__$1;
(statearr_64722_64735[(1)] = (4));

(statearr_64722_64735[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64714 === (6))){
var inst_64705 = (state_64713[(2)]);
var inst_64706 = fluree.db.util.async.throw_err(inst_64705);
var _ = (function (){var statearr_64723 = state_64713;
(statearr_64723[(4)] = cljs.core.rest((state_64713[(4)])));

return statearr_64723;
})();
var state_64713__$1 = state_64713;
var statearr_64724_64736 = state_64713__$1;
(statearr_64724_64736[(2)] = inst_64706);

(statearr_64724_64736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64714 === (7))){
var inst_64701 = (state_64713[(2)]);
var inst_64702 = fluree.db.util.async.throw_err(inst_64701);
var inst_64703 = fluree.db.time_travel.as_of_block(inst_64702,block);
var state_64713__$1 = state_64713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64713__$1,(6),inst_64703);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2733__auto__ = null;
var fluree$db$api$ledger$state_machine__2733__auto____0 = (function (){
var statearr_64725 = [null,null,null,null,null,null,null,null];
(statearr_64725[(0)] = fluree$db$api$ledger$state_machine__2733__auto__);

(statearr_64725[(1)] = (1));

return statearr_64725;
});
var fluree$db$api$ledger$state_machine__2733__auto____1 = (function (state_64713){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64713);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64726){var ex__2736__auto__ = e64726;
var statearr_64727_64737 = state_64713;
(statearr_64727_64737[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64713[(4)]))){
var statearr_64728_64738 = state_64713;
(statearr_64728_64738[(1)] = cljs.core.first((state_64713[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64739 = state_64713;
state_64713 = G__64739;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2733__auto__ = function(state_64713){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2733__auto____1.call(this,state_64713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2733__auto____0;
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2733__auto____1;
return fluree$db$api$ledger$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64729 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64729[(6)] = c__2755__auto___64731);

return statearr_64729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64780){
var state_val_64781 = (state_64780[(1)]);
if((state_val_64781 === (7))){
var inst_64749 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64780__$1 = state_64780;
if(inst_64749){
var statearr_64782_64813 = state_64780__$1;
(statearr_64782_64813[(1)] = (9));

} else {
var statearr_64783_64814 = state_64780__$1;
(statearr_64783_64814[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (1))){
var state_64780__$1 = state_64780;
var statearr_64784_64815 = state_64780__$1;
(statearr_64784_64815[(2)] = null);

(statearr_64784_64815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (4))){
var inst_64740 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
var statearr_64785_64816 = state_64780__$1;
(statearr_64785_64816[(2)] = inst_64740);

(statearr_64785_64816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (15))){
var inst_64757 = (state_64780[(7)]);
var inst_64756 = (state_64780[(2)]);
var inst_64757__$1 = fluree.db.util.async.throw_err(inst_64756);
var state_64780__$1 = (function (){var statearr_64786 = state_64780;
(statearr_64786[(7)] = inst_64757__$1);

return statearr_64786;
})();
if(cljs.core.truth_(inst_64757__$1)){
var statearr_64787_64817 = state_64780__$1;
(statearr_64787_64817[(1)] = (16));

} else {
var statearr_64788_64818 = state_64780__$1;
(statearr_64788_64818[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (13))){
var state_64780__$1 = state_64780;
var statearr_64789_64819 = state_64780__$1;
(statearr_64789_64819[(2)] = null);

(statearr_64789_64819[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (6))){
var state_64780__$1 = state_64780;
var statearr_64790_64820 = state_64780__$1;
(statearr_64790_64820[(2)] = db);

(statearr_64790_64820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (17))){
var inst_64761 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64762 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64763 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64764 = cljs.core.PersistentHashMap.fromArrays(inst_64762,inst_64763);
var inst_64765 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64761,inst_64764);
var inst_64766 = (function(){throw inst_64765})();
var state_64780__$1 = state_64780;
var statearr_64791_64821 = state_64780__$1;
(statearr_64791_64821[(2)] = inst_64766);

(statearr_64791_64821[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (3))){
var inst_64778 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64780__$1,inst_64778);
} else {
if((state_val_64781 === (12))){
var inst_64754 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64780__$1 = state_64780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64780__$1,(15),inst_64754);
} else {
if((state_val_64781 === (2))){
var _ = (function (){var statearr_64792 = state_64780;
(statearr_64792[(4)] = cljs.core.cons((5),(state_64780[(4)])));

return statearr_64792;
})();
var inst_64746 = cljs.core.not(auth);
var state_64780__$1 = state_64780;
if(inst_64746){
var statearr_64793_64822 = state_64780__$1;
(statearr_64793_64822[(1)] = (6));

} else {
var statearr_64794_64823 = state_64780__$1;
(statearr_64794_64823[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (11))){
var inst_64773 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
var statearr_64796_64824 = state_64780__$1;
(statearr_64796_64824[(2)] = inst_64773);

(statearr_64796_64824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (9))){
var inst_64751 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_64780__$1 = state_64780;
var statearr_64797_64825 = state_64780__$1;
(statearr_64797_64825[(2)] = inst_64751);

(statearr_64797_64825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (5))){
var _ = (function (){var statearr_64798 = state_64780;
(statearr_64798[(4)] = cljs.core.rest((state_64780[(4)])));

return statearr_64798;
})();
var state_64780__$1 = state_64780;
var ex64795 = (state_64780__$1[(2)]);
var statearr_64799_64826 = state_64780__$1;
(statearr_64799_64826[(5)] = ex64795);


if((ex64795 instanceof Error)){
var statearr_64800_64827 = state_64780__$1;
(statearr_64800_64827[(1)] = (4));

(statearr_64800_64827[(5)] = null);

} else {
throw ex64795;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (14))){
var inst_64771 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
var statearr_64801_64828 = state_64780__$1;
(statearr_64801_64828[(2)] = inst_64771);

(statearr_64801_64828[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (16))){
var inst_64757 = (state_64780[(7)]);
var inst_64759 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64757);
var state_64780__$1 = state_64780;
var statearr_64802_64829 = state_64780__$1;
(statearr_64802_64829[(2)] = inst_64759);

(statearr_64802_64829[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (10))){
var state_64780__$1 = state_64780;
var statearr_64803_64830 = state_64780__$1;
(statearr_64803_64830[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (18))){
var inst_64768 = (state_64780[(2)]);
var state_64780__$1 = state_64780;
var statearr_64805_64831 = state_64780__$1;
(statearr_64805_64831[(2)] = inst_64768);

(statearr_64805_64831[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64781 === (8))){
var inst_64775 = (state_64780[(2)]);
var _ = (function (){var statearr_64806 = state_64780;
(statearr_64806[(4)] = cljs.core.rest((state_64780[(4)])));

return statearr_64806;
})();
var state_64780__$1 = state_64780;
var statearr_64807_64832 = state_64780__$1;
(statearr_64807_64832[(2)] = inst_64775);

(statearr_64807_64832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0 = (function (){
var statearr_64808 = [null,null,null,null,null,null,null,null];
(statearr_64808[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__);

(statearr_64808[(1)] = (1));

return statearr_64808;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1 = (function (state_64780){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64780);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64809){var ex__2736__auto__ = e64809;
var statearr_64810_64833 = state_64780;
(statearr_64810_64833[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64780[(4)]))){
var statearr_64811_64834 = state_64780;
(statearr_64811_64834[(1)] = cljs.core.first((state_64780[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64835 = state_64780;
state_64780 = G__64835;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__ = function(state_64780){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1.call(this,state_64780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64812 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64812[(6)] = c__2755__auto__);

return statearr_64812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64899){
var state_val_64900 = (state_64899[(1)]);
if((state_val_64900 === (7))){
var inst_64845 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64899__$1 = state_64899;
if(inst_64845){
var statearr_64901_64950 = state_64899__$1;
(statearr_64901_64950[(1)] = (9));

} else {
var statearr_64902_64951 = state_64899__$1;
(statearr_64902_64951[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (20))){
var inst_64869 = (state_64899[(7)]);
var state_64899__$1 = state_64899;
if(cljs.core.truth_(inst_64869)){
var statearr_64903_64952 = state_64899__$1;
(statearr_64903_64952[(1)] = (22));

} else {
var statearr_64904_64953 = state_64899__$1;
(statearr_64904_64953[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (27))){
var state_64899__$1 = state_64899;
var statearr_64905_64954 = state_64899__$1;
(statearr_64905_64954[(2)] = null);

(statearr_64905_64954[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (1))){
var state_64899__$1 = state_64899;
var statearr_64906_64955 = state_64899__$1;
(statearr_64906_64955[(2)] = null);

(statearr_64906_64955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (24))){
var inst_64883 = (state_64899[(2)]);
var state_64899__$1 = state_64899;
var statearr_64907_64956 = state_64899__$1;
(statearr_64907_64956[(2)] = inst_64883);

(statearr_64907_64956[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (4))){
var inst_64836 = (state_64899[(2)]);
var state_64899__$1 = state_64899;
var statearr_64908_64957 = state_64899__$1;
(statearr_64908_64957[(2)] = inst_64836);

(statearr_64908_64957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (15))){
var inst_64852 = (state_64899[(8)]);
var inst_64851 = (state_64899[(2)]);
var inst_64852__$1 = fluree.db.util.async.throw_err(inst_64851);
var state_64899__$1 = (function (){var statearr_64909 = state_64899;
(statearr_64909[(8)] = inst_64852__$1);

return statearr_64909;
})();
if(cljs.core.truth_(inst_64852__$1)){
var statearr_64910_64958 = state_64899__$1;
(statearr_64910_64958[(1)] = (16));

} else {
var statearr_64911_64959 = state_64899__$1;
(statearr_64911_64959[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (21))){
var inst_64885 = (state_64899[(9)]);
var inst_64885__$1 = (state_64899[(2)]);
var state_64899__$1 = (function (){var statearr_64912 = state_64899;
(statearr_64912[(9)] = inst_64885__$1);

return statearr_64912;
})();
if(cljs.core.truth_(inst_64885__$1)){
var statearr_64913_64960 = state_64899__$1;
(statearr_64913_64960[(1)] = (29));

} else {
var statearr_64914_64961 = state_64899__$1;
(statearr_64914_64961[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (31))){
var inst_64869 = (state_64899[(7)]);
var inst_64885 = (state_64899[(9)]);
var inst_64893 = (state_64899[(2)]);
var inst_64894 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64869,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_64885,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_64893], 0));
var _ = (function (){var statearr_64915 = state_64899;
(statearr_64915[(4)] = cljs.core.rest((state_64899[(4)])));

return statearr_64915;
})();
var state_64899__$1 = state_64899;
var statearr_64916_64962 = state_64899__$1;
(statearr_64916_64962[(2)] = inst_64894);

(statearr_64916_64962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (32))){
var inst_64889 = (state_64899[(2)]);
var inst_64890 = fluree.db.util.async.throw_err(inst_64889);
var state_64899__$1 = state_64899;
var statearr_64917_64963 = state_64899__$1;
(statearr_64917_64963[(2)] = inst_64890);

(statearr_64917_64963[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (13))){
var state_64899__$1 = state_64899;
var statearr_64918_64964 = state_64899__$1;
(statearr_64918_64964[(2)] = null);

(statearr_64918_64964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (22))){
var inst_64869 = (state_64899[(7)]);
var inst_64873 = fluree.db.auth.roles(db,inst_64869);
var state_64899__$1 = state_64899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64899__$1,(25),inst_64873);
} else {
if((state_val_64900 === (29))){
var inst_64885 = (state_64899[(9)]);
var inst_64887 = fluree.db.permissions.permission_map(db,inst_64885,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64899__$1 = state_64899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64899__$1,(32),inst_64887);
} else {
if((state_val_64900 === (6))){
var state_64899__$1 = state_64899;
var statearr_64919_64965 = state_64899__$1;
(statearr_64919_64965[(2)] = null);

(statearr_64919_64965[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (28))){
var inst_64881 = (state_64899[(2)]);
var state_64899__$1 = state_64899;
var statearr_64920_64966 = state_64899__$1;
(statearr_64920_64966[(2)] = inst_64881);

(statearr_64920_64966[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (25))){
var inst_64875 = (state_64899[(2)]);
var inst_64876 = fluree.db.util.async.throw_err(inst_64875);
var state_64899__$1 = state_64899;
var statearr_64921_64967 = state_64899__$1;
(statearr_64921_64967[(2)] = inst_64876);

(statearr_64921_64967[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (17))){
var inst_64855 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64856 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64857 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64858 = cljs.core.PersistentHashMap.fromArrays(inst_64856,inst_64857);
var inst_64859 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64855,inst_64858);
var inst_64860 = (function(){throw inst_64859})();
var state_64899__$1 = state_64899;
var statearr_64922_64968 = state_64899__$1;
(statearr_64922_64968[(2)] = inst_64860);

(statearr_64922_64968[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (3))){
var inst_64897 = (state_64899[(2)]);
var state_64899__$1 = state_64899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64899__$1,inst_64897);
} else {
if((state_val_64900 === (12))){
var inst_64849 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64899__$1 = state_64899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64899__$1,(15),inst_64849);
} else {
if((state_val_64900 === (2))){
var _ = (function (){var statearr_64923 = state_64899;
(statearr_64923[(4)] = cljs.core.cons((5),(state_64899[(4)])));

return statearr_64923;
})();
var inst_64842 = (auth == null);
var state_64899__$1 = state_64899;
if(cljs.core.truth_(inst_64842)){
var statearr_64924_64969 = state_64899__$1;
(statearr_64924_64969[(1)] = (6));

} else {
var statearr_64925_64970 = state_64899__$1;
(statearr_64925_64970[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (23))){
var state_64899__$1 = state_64899;
var statearr_64926_64971 = state_64899__$1;
(statearr_64926_64971[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (19))){
var state_64899__$1 = state_64899;
var statearr_64928_64972 = state_64899__$1;
(statearr_64928_64972[(2)] = roles);

(statearr_64928_64972[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (11))){
var inst_64867 = (state_64899[(2)]);
var state_64899__$1 = state_64899;
var statearr_64930_64973 = state_64899__$1;
(statearr_64930_64973[(2)] = inst_64867);

(statearr_64930_64973[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (9))){
var state_64899__$1 = state_64899;
var statearr_64931_64974 = state_64899__$1;
(statearr_64931_64974[(2)] = (0));

(statearr_64931_64974[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (5))){
var _ = (function (){var statearr_64932 = state_64899;
(statearr_64932[(4)] = cljs.core.rest((state_64899[(4)])));

return statearr_64932;
})();
var state_64899__$1 = state_64899;
var ex64929 = (state_64899__$1[(2)]);
var statearr_64933_64975 = state_64899__$1;
(statearr_64933_64975[(5)] = ex64929);


if((ex64929 instanceof Error)){
var statearr_64934_64976 = state_64899__$1;
(statearr_64934_64976[(1)] = (4));

(statearr_64934_64976[(5)] = null);

} else {
throw ex64929;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (14))){
var inst_64865 = (state_64899[(2)]);
var state_64899__$1 = state_64899;
var statearr_64935_64977 = state_64899__$1;
(statearr_64935_64977[(2)] = inst_64865);

(statearr_64935_64977[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (26))){
var state_64899__$1 = state_64899;
var statearr_64936_64978 = state_64899__$1;
(statearr_64936_64978[(2)] = null);

(statearr_64936_64978[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (16))){
var inst_64852 = (state_64899[(8)]);
var state_64899__$1 = state_64899;
var statearr_64937_64979 = state_64899__$1;
(statearr_64937_64979[(2)] = inst_64852);

(statearr_64937_64979[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (30))){
var state_64899__$1 = state_64899;
var statearr_64938_64980 = state_64899__$1;
(statearr_64938_64980[(2)] = null);

(statearr_64938_64980[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (10))){
var state_64899__$1 = state_64899;
if(cljs.core.truth_(auth)){
var statearr_64939_64981 = state_64899__$1;
(statearr_64939_64981[(1)] = (12));

} else {
var statearr_64940_64982 = state_64899__$1;
(statearr_64940_64982[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (18))){
var inst_64862 = (state_64899[(2)]);
var state_64899__$1 = state_64899;
var statearr_64941_64983 = state_64899__$1;
(statearr_64941_64983[(2)] = inst_64862);

(statearr_64941_64983[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64900 === (8))){
var inst_64869 = (state_64899[(2)]);
var state_64899__$1 = (function (){var statearr_64942 = state_64899;
(statearr_64942[(7)] = inst_64869);

return statearr_64942;
})();
if(cljs.core.truth_(roles)){
var statearr_64943_64984 = state_64899__$1;
(statearr_64943_64984[(1)] = (19));

} else {
var statearr_64944_64985 = state_64899__$1;
(statearr_64944_64985[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0 = (function (){
var statearr_64945 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64945[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__);

(statearr_64945[(1)] = (1));

return statearr_64945;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1 = (function (state_64899){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64899);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64946){var ex__2736__auto__ = e64946;
var statearr_64947_64986 = state_64899;
(statearr_64947_64986[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64899[(4)]))){
var statearr_64948_64987 = state_64899;
(statearr_64948_64987[(1)] = cljs.core.first((state_64899[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64988 = state_64899;
state_64899 = G__64988;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__ = function(state_64899){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1.call(this,state_64899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_64949 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_64949[(6)] = c__2755__auto__);

return statearr_64949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__64989 = db;
var map__64989__$1 = cljs.core.__destructure_map(map__64989);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64989__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64989__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64989__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_64996){
var state_val_64997 = (state_64996[(1)]);
if((state_val_64997 === (1))){
var inst_64990 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64991 = fluree.db.session.db(conn,inst_64990,null);
var state_64996__$1 = state_64996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64996__$1,(2),inst_64991);
} else {
if((state_val_64997 === (2))){
var inst_64993 = (state_64996[(2)]);
var inst_64994 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64993);
var state_64996__$1 = state_64996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64996__$1,inst_64994);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0 = (function (){
var statearr_64998 = [null,null,null,null,null,null,null];
(statearr_64998[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__);

(statearr_64998[(1)] = (1));

return statearr_64998;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1 = (function (state_64996){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_64996);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e64999){var ex__2736__auto__ = e64999;
var statearr_65000_65027 = state_64996;
(statearr_65000_65027[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_64996[(4)]))){
var statearr_65001_65028 = state_64996;
(statearr_65001_65028[(1)] = cljs.core.first((state_64996[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65029 = state_64996;
state_64996 = G__65029;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = function(state_64996){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1.call(this,state_64996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65002 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65002[(6)] = c__2755__auto__);

return statearr_65002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65015){
var state_val_65016 = (state_65015[(1)]);
if((state_val_65016 === (1))){
var inst_65003 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_65004 = fluree.db.session.db(conn,inst_65003,null);
var state_65015__$1 = state_65015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65015__$1,(2),inst_65004);
} else {
if((state_val_65016 === (2))){
var inst_65006 = (state_65015[(7)]);
var inst_65006__$1 = (state_65015[(2)]);
var inst_65007 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65006__$1);
var inst_65008 = newer_block_QMARK_(inst_65007);
var state_65015__$1 = (function (){var statearr_65017 = state_65015;
(statearr_65017[(7)] = inst_65006__$1);

return statearr_65017;
})();
if(inst_65008){
var statearr_65018_65030 = state_65015__$1;
(statearr_65018_65030[(1)] = (3));

} else {
var statearr_65019_65031 = state_65015__$1;
(statearr_65019_65031[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (3))){
var inst_65006 = (state_65015[(7)]);
var inst_65010 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_65006);
var state_65015__$1 = state_65015;
var statearr_65020_65032 = state_65015__$1;
(statearr_65020_65032[(2)] = inst_65010);

(statearr_65020_65032[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (4))){
var state_65015__$1 = state_65015;
var statearr_65021_65033 = state_65015__$1;
(statearr_65021_65033[(2)] = null);

(statearr_65021_65033[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (5))){
var inst_65013 = (state_65015[(2)]);
var state_65015__$1 = state_65015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65015__$1,inst_65013);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0 = (function (){
var statearr_65022 = [null,null,null,null,null,null,null,null];
(statearr_65022[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__);

(statearr_65022[(1)] = (1));

return statearr_65022;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1 = (function (state_65015){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65015);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65023){var ex__2736__auto__ = e65023;
var statearr_65024_65034 = state_65015;
(statearr_65024_65034[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65015[(4)]))){
var statearr_65025_65035 = state_65015;
(statearr_65025_65035[(1)] = cljs.core.first((state_65015[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65036 = state_65015;
state_65015 = G__65036;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__ = function(state_65015){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1.call(this,state_65015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65026 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65026[(6)] = c__2755__auto__);

return statearr_65026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__65037 = db;
var map__65037__$1 = cljs.core.__destructure_map(map__65037);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65037__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65037__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65037__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4309__auto__ = syncTimeout;
var y__4310__auto__ = (120000);
return ((x__4309__auto__ < y__4310__auto__) ? x__4309__auto__ : y__4310__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2755__auto___65113 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65087){
var state_val_65088 = (state_65087[(1)]);
if((state_val_65088 === (7))){
var inst_65053 = (state_65087[(7)]);
var inst_65064 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65053,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_65087__$1 = state_65087;
if(inst_65064){
var statearr_65089_65114 = state_65087__$1;
(statearr_65089_65114[(1)] = (9));

} else {
var statearr_65090_65115 = state_65087__$1;
(statearr_65090_65115[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (1))){
var inst_65038 = (state_65087[(8)]);
var inst_65046 = (state_65087[(9)]);
var inst_65038__$1 = cljs.core.async.timeout(timeout);
var inst_65046__$1 = res_port;
var inst_65047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65048 = [inst_65038__$1,inst_65046__$1];
var inst_65049 = (new cljs.core.PersistentVector(null,2,(5),inst_65047,inst_65048,null));
var state_65087__$1 = (function (){var statearr_65091 = state_65087;
(statearr_65091[(8)] = inst_65038__$1);

(statearr_65091[(9)] = inst_65046__$1);

return statearr_65091;
})();
return cljs.core.async.ioc_alts_BANG_(state_65087__$1,(2),inst_65049);
} else {
if((state_val_65088 === (4))){
var inst_65053 = (state_65087[(7)]);
var inst_65046 = (state_65087[(9)]);
var inst_65057 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65053,inst_65046);
var state_65087__$1 = state_65087;
if(inst_65057){
var statearr_65092_65116 = state_65087__$1;
(statearr_65092_65116[(1)] = (6));

} else {
var statearr_65093_65117 = state_65087__$1;
(statearr_65093_65117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (13))){
var inst_65072 = (state_65087[(10)]);
var inst_65083 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65072);
var state_65087__$1 = state_65087;
var statearr_65094_65118 = state_65087__$1;
(statearr_65094_65118[(2)] = inst_65083);

(statearr_65094_65118[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (6))){
var inst_65051 = (state_65087[(11)]);
var inst_65062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65051,(0),null);
var state_65087__$1 = state_65087;
var statearr_65095_65119 = state_65087__$1;
(statearr_65095_65119[(2)] = inst_65062);

(statearr_65095_65119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (3))){
var state_65087__$1 = state_65087;
var statearr_65096_65120 = state_65087__$1;
(statearr_65096_65120[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_65096_65120[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (12))){
var inst_65076 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_65077 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65078 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_65079 = cljs.core.PersistentHashMap.fromArrays(inst_65077,inst_65078);
var inst_65080 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65076,inst_65079);
var inst_65081 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65080);
var state_65087__$1 = state_65087;
var statearr_65097_65121 = state_65087__$1;
(statearr_65097_65121[(2)] = inst_65081);

(statearr_65097_65121[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (2))){
var inst_65053 = (state_65087[(7)]);
var inst_65051 = (state_65087[(11)]);
var inst_65038 = (state_65087[(8)]);
var inst_65051__$1 = (state_65087[(2)]);
var inst_65052 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65051__$1,(0),null);
var inst_65053__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65051__$1,(1),null);
var inst_65054 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65053__$1,inst_65038);
var state_65087__$1 = (function (){var statearr_65098 = state_65087;
(statearr_65098[(7)] = inst_65053__$1);

(statearr_65098[(11)] = inst_65051__$1);

(statearr_65098[(12)] = inst_65052);

return statearr_65098;
})();
if(inst_65054){
var statearr_65099_65122 = state_65087__$1;
(statearr_65099_65122[(1)] = (3));

} else {
var statearr_65100_65123 = state_65087__$1;
(statearr_65100_65123[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (11))){
var inst_65068 = (state_65087[(2)]);
var state_65087__$1 = state_65087;
var statearr_65101_65124 = state_65087__$1;
(statearr_65101_65124[(2)] = inst_65068);

(statearr_65101_65124[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (9))){
var inst_65052 = (state_65087[(12)]);
var state_65087__$1 = state_65087;
var statearr_65102_65125 = state_65087__$1;
(statearr_65102_65125[(2)] = inst_65052);

(statearr_65102_65125[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (5))){
var inst_65072 = (state_65087[(10)]);
var inst_65072__$1 = (state_65087[(2)]);
var inst_65073 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_65074 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_65072__$1);
var state_65087__$1 = (function (){var statearr_65103 = state_65087;
(statearr_65103[(13)] = inst_65073);

(statearr_65103[(10)] = inst_65072__$1);

return statearr_65103;
})();
if(inst_65074){
var statearr_65104_65126 = state_65087__$1;
(statearr_65104_65126[(1)] = (12));

} else {
var statearr_65105_65127 = state_65087__$1;
(statearr_65105_65127[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (14))){
var inst_65085 = (state_65087[(2)]);
var state_65087__$1 = state_65087;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65087__$1,inst_65085);
} else {
if((state_val_65088 === (10))){
var state_65087__$1 = state_65087;
var statearr_65106_65128 = state_65087__$1;
(statearr_65106_65128[(2)] = null);

(statearr_65106_65128[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65088 === (8))){
var inst_65070 = (state_65087[(2)]);
var state_65087__$1 = state_65087;
var statearr_65107_65129 = state_65087__$1;
(statearr_65107_65129[(2)] = inst_65070);

(statearr_65107_65129[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0 = (function (){
var statearr_65108 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65108[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__);

(statearr_65108[(1)] = (1));

return statearr_65108;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1 = (function (state_65087){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65087);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65109){var ex__2736__auto__ = e65109;
var statearr_65110_65130 = state_65087;
(statearr_65110_65130[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65087[(4)]))){
var statearr_65111_65131 = state_65087;
(statearr_65111_65131[(1)] = cljs.core.first((state_65087[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65132 = state_65087;
state_65087 = G__65132;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__ = function(state_65087){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1.call(this,state_65087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65112 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65112[(6)] = c__2755__auto___65113);

return statearr_65112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__65134 = arguments.length;
switch (G__65134) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__65135){
var map__65136 = p__65135;
var map__65136__$1 = cljs.core.__destructure_map(map__65136);
var opts = map__65136__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65136__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65136__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65136__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65136__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65136__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2755__auto___65225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_65187){
var state_val_65188 = (state_65187[(1)]);
if((state_val_65188 === (7))){
var inst_65149 = (state_65187[(7)]);
var inst_65151 = fluree.db.api.ledger.syncTo_db(inst_65149,syncTo,syncTimeout);
var state_65187__$1 = state_65187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65187__$1,(10),inst_65151);
} else {
if((state_val_65188 === (20))){
var inst_65173 = (state_65187[(8)]);
var state_65187__$1 = state_65187;
var statearr_65189_65226 = state_65187__$1;
(statearr_65189_65226[(2)] = inst_65173);

(statearr_65189_65226[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (1))){
var state_65187__$1 = state_65187;
var statearr_65190_65227 = state_65187__$1;
(statearr_65190_65227[(2)] = null);

(statearr_65190_65227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (4))){
var inst_65137 = (state_65187[(2)]);
var inst_65138 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65137);
var inst_65139 = cljs.core.async.close_BANG_(pc);
var state_65187__$1 = (function (){var statearr_65191 = state_65187;
(statearr_65191[(9)] = inst_65138);

return statearr_65191;
})();
var statearr_65192_65228 = state_65187__$1;
(statearr_65192_65228[(2)] = inst_65139);

(statearr_65192_65228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (15))){
var inst_65165 = (state_65187[(10)]);
var inst_65167 = fluree.db.api.ledger.add_db_permissions(inst_65165,auth,roles);
var state_65187__$1 = state_65187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65187__$1,(18),inst_65167);
} else {
if((state_val_65188 === (21))){
var inst_65181 = (state_65187[(2)]);
var inst_65182 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65181);
var _ = (function (){var statearr_65193 = state_65187;
(statearr_65193[(4)] = cljs.core.rest((state_65187[(4)])));

return statearr_65193;
})();
var state_65187__$1 = state_65187;
var statearr_65194_65229 = state_65187__$1;
(statearr_65194_65229[(2)] = inst_65182);

(statearr_65194_65229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (13))){
var inst_65165 = (state_65187[(2)]);
var state_65187__$1 = (function (){var statearr_65195 = state_65187;
(statearr_65195[(10)] = inst_65165);

return statearr_65195;
})();
if(cljs.core.truth_(roles)){
var statearr_65196_65230 = state_65187__$1;
(statearr_65196_65230[(1)] = (15));

} else {
var statearr_65197_65231 = state_65187__$1;
(statearr_65197_65231[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (22))){
var inst_65177 = (state_65187[(2)]);
var inst_65178 = fluree.db.util.async.throw_err(inst_65177);
var state_65187__$1 = state_65187;
var statearr_65198_65232 = state_65187__$1;
(statearr_65198_65232[(2)] = inst_65178);

(statearr_65198_65232[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (6))){
var inst_65148 = (state_65187[(2)]);
var inst_65149 = fluree.db.util.async.throw_err(inst_65148);
var state_65187__$1 = (function (){var statearr_65199 = state_65187;
(statearr_65199[(7)] = inst_65149);

return statearr_65199;
})();
if(cljs.core.truth_(syncTo)){
var statearr_65200_65233 = state_65187__$1;
(statearr_65200_65233[(1)] = (7));

} else {
var statearr_65201_65234 = state_65187__$1;
(statearr_65201_65234[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (17))){
var inst_65173 = (state_65187[(2)]);
var state_65187__$1 = (function (){var statearr_65202 = state_65187;
(statearr_65202[(8)] = inst_65173);

return statearr_65202;
})();
if(cljs.core.truth_(auth)){
var statearr_65203_65235 = state_65187__$1;
(statearr_65203_65235[(1)] = (19));

} else {
var statearr_65204_65236 = state_65187__$1;
(statearr_65204_65236[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (3))){
var inst_65185 = (state_65187[(2)]);
var state_65187__$1 = state_65187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65187__$1,inst_65185);
} else {
if((state_val_65188 === (12))){
var inst_65157 = (state_65187[(11)]);
var state_65187__$1 = state_65187;
var statearr_65205_65237 = state_65187__$1;
(statearr_65205_65237[(2)] = inst_65157);

(statearr_65205_65237[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (2))){
var _ = (function (){var statearr_65206 = state_65187;
(statearr_65206[(4)] = cljs.core.cons((5),(state_65187[(4)])));

return statearr_65206;
})();
var inst_65146 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_65187__$1 = state_65187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65187__$1,(6),inst_65146);
} else {
if((state_val_65188 === (19))){
var inst_65173 = (state_65187[(8)]);
var inst_65175 = fluree.db.api.ledger.add_db_permissions(inst_65173,auth,roles);
var state_65187__$1 = state_65187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65187__$1,(22),inst_65175);
} else {
if((state_val_65188 === (11))){
var inst_65157 = (state_65187[(11)]);
var inst_65159 = fluree.db.time_travel.as_of_block(inst_65157,block);
var state_65187__$1 = state_65187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65187__$1,(14),inst_65159);
} else {
if((state_val_65188 === (9))){
var inst_65157 = (state_65187[(2)]);
var state_65187__$1 = (function (){var statearr_65208 = state_65187;
(statearr_65208[(11)] = inst_65157);

return statearr_65208;
})();
if(cljs.core.truth_(block)){
var statearr_65209_65238 = state_65187__$1;
(statearr_65209_65238[(1)] = (11));

} else {
var statearr_65210_65239 = state_65187__$1;
(statearr_65210_65239[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (5))){
var _ = (function (){var statearr_65211 = state_65187;
(statearr_65211[(4)] = cljs.core.rest((state_65187[(4)])));

return statearr_65211;
})();
var state_65187__$1 = state_65187;
var ex65207 = (state_65187__$1[(2)]);
var statearr_65212_65240 = state_65187__$1;
(statearr_65212_65240[(5)] = ex65207);


var statearr_65213_65241 = state_65187__$1;
(statearr_65213_65241[(1)] = (4));

(statearr_65213_65241[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (14))){
var inst_65161 = (state_65187[(2)]);
var inst_65162 = fluree.db.util.async.throw_err(inst_65161);
var state_65187__$1 = state_65187;
var statearr_65214_65242 = state_65187__$1;
(statearr_65214_65242[(2)] = inst_65162);

(statearr_65214_65242[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (16))){
var inst_65165 = (state_65187[(10)]);
var state_65187__$1 = state_65187;
var statearr_65215_65243 = state_65187__$1;
(statearr_65215_65243[(2)] = inst_65165);

(statearr_65215_65243[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (10))){
var inst_65153 = (state_65187[(2)]);
var inst_65154 = fluree.db.util.async.throw_err(inst_65153);
var state_65187__$1 = state_65187;
var statearr_65216_65244 = state_65187__$1;
(statearr_65216_65244[(2)] = inst_65154);

(statearr_65216_65244[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (18))){
var inst_65169 = (state_65187[(2)]);
var inst_65170 = fluree.db.util.async.throw_err(inst_65169);
var state_65187__$1 = state_65187;
var statearr_65217_65245 = state_65187__$1;
(statearr_65217_65245[(2)] = inst_65170);

(statearr_65217_65245[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65188 === (8))){
var inst_65149 = (state_65187[(7)]);
var state_65187__$1 = state_65187;
var statearr_65218_65246 = state_65187__$1;
(statearr_65218_65246[(2)] = inst_65149);

(statearr_65218_65246[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2733__auto__ = null;
var fluree$db$api$ledger$state_machine__2733__auto____0 = (function (){
var statearr_65219 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65219[(0)] = fluree$db$api$ledger$state_machine__2733__auto__);

(statearr_65219[(1)] = (1));

return statearr_65219;
});
var fluree$db$api$ledger$state_machine__2733__auto____1 = (function (state_65187){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_65187);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e65220){var ex__2736__auto__ = e65220;
var statearr_65221_65247 = state_65187;
(statearr_65221_65247[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_65187[(4)]))){
var statearr_65222_65248 = state_65187;
(statearr_65222_65248[(1)] = cljs.core.first((state_65187[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65249 = state_65187;
state_65187 = G__65249;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2733__auto__ = function(state_65187){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2733__auto____1.call(this,state_65187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2733__auto____0;
fluree$db$api$ledger$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2733__auto____1;
return fluree$db$api$ledger$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_65223 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_65223[(6)] = c__2755__auto___65225);

return statearr_65223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

