// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__58786 = arguments.length;
switch (G__58786) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___58934 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_58873){
var state_val_58874 = (state_58873[(1)]);
if((state_val_58874 === (7))){
var inst_58804 = (state_58873[(7)]);
var inst_58807 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_58804);
var state_58873__$1 = state_58873;
var statearr_58875_58935 = state_58873__$1;
(statearr_58875_58935[(2)] = inst_58807);

(statearr_58875_58935[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (20))){
var inst_58799 = (state_58873[(8)]);
var inst_58828 = (state_58873[(9)]);
var inst_58832 = fluree.db.auth.roles(inst_58799,inst_58828);
var state_58873__$1 = state_58873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58873__$1,(23),inst_58832);
} else {
if((state_val_58874 === (27))){
var inst_58799 = (state_58873[(8)]);
var inst_58847 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_58848 = fluree.db.time_travel.as_of_block(inst_58799,inst_58847);
var state_58873__$1 = state_58873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58873__$1,(30),inst_58848);
} else {
if((state_val_58874 === (1))){
var state_58873__$1 = state_58873;
var statearr_58876_58936 = state_58873__$1;
(statearr_58876_58936[(2)] = null);

(statearr_58876_58936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (24))){
var inst_58840 = (state_58873[(10)]);
var inst_58799 = (state_58873[(8)]);
var inst_58842 = fluree.db.permissions.permission_map(inst_58799,inst_58840,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_58873__$1 = state_58873;
var statearr_58877_58937 = state_58873__$1;
(statearr_58877_58937[(2)] = inst_58842);

(statearr_58877_58937[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (4))){
var inst_58787 = (state_58873[(2)]);
var inst_58788 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_58787);
var inst_58789 = cljs.core.async.close_BANG_(pc);
var state_58873__$1 = (function (){var statearr_58878 = state_58873;
(statearr_58878[(11)] = inst_58788);

return statearr_58878;
})();
var statearr_58879_58938 = state_58873__$1;
(statearr_58879_58938[(2)] = inst_58789);

(statearr_58879_58938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (15))){
var inst_58804 = (state_58873[(7)]);
var inst_58818 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_58804)," unknown."].join('');
var inst_58819 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_58820 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_58821 = cljs.core.PersistentHashMap.fromArrays(inst_58819,inst_58820);
var inst_58822 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_58818,inst_58821);
var inst_58823 = (function(){throw inst_58822})();
var state_58873__$1 = state_58873;
var statearr_58880_58939 = state_58873__$1;
(statearr_58880_58939[(2)] = inst_58823);

(statearr_58880_58939[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (21))){
var state_58873__$1 = state_58873;
var statearr_58881_58940 = state_58873__$1;
(statearr_58881_58940[(2)] = null);

(statearr_58881_58940[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (31))){
var inst_58854 = (state_58873[(12)]);
var inst_58804 = (state_58873[(7)]);
var inst_58856 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_58854,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_58804);
var state_58873__$1 = state_58873;
var statearr_58882_58941 = state_58873__$1;
(statearr_58882_58941[(2)] = inst_58856);

(statearr_58882_58941[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (32))){
var inst_58854 = (state_58873[(12)]);
var state_58873__$1 = state_58873;
var statearr_58883_58942 = state_58873__$1;
(statearr_58883_58942[(2)] = inst_58854);

(statearr_58883_58942[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (33))){
var inst_58840 = (state_58873[(10)]);
var inst_58859 = (state_58873[(2)]);
var state_58873__$1 = (function (){var statearr_58884 = state_58873;
(statearr_58884[(13)] = inst_58859);

return statearr_58884;
})();
if(cljs.core.truth_(inst_58840)){
var statearr_58885_58943 = state_58873__$1;
(statearr_58885_58943[(1)] = (34));

} else {
var statearr_58886_58944 = state_58873__$1;
(statearr_58886_58944[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (13))){
var inst_58815 = (state_58873[(14)]);
var inst_58814 = (state_58873[(2)]);
var inst_58815__$1 = fluree.db.util.async.throw_err(inst_58814);
var state_58873__$1 = (function (){var statearr_58887 = state_58873;
(statearr_58887[(14)] = inst_58815__$1);

return statearr_58887;
})();
if(cljs.core.truth_(inst_58815__$1)){
var statearr_58888_58945 = state_58873__$1;
(statearr_58888_58945[(1)] = (14));

} else {
var statearr_58889_58946 = state_58873__$1;
(statearr_58889_58946[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (22))){
var inst_58838 = (state_58873[(2)]);
var state_58873__$1 = state_58873;
var statearr_58890_58947 = state_58873__$1;
(statearr_58890_58947[(2)] = inst_58838);

(statearr_58890_58947[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (36))){
var inst_58867 = (state_58873[(2)]);
var inst_58868 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_58867);
var _ = (function (){var statearr_58891 = state_58873;
(statearr_58891[(4)] = cljs.core.rest((state_58873[(4)])));

return statearr_58891;
})();
var state_58873__$1 = state_58873;
var statearr_58892_58948 = state_58873__$1;
(statearr_58892_58948[(2)] = inst_58868);

(statearr_58892_58948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (29))){
var inst_58804 = (state_58873[(7)]);
var inst_58854 = (state_58873[(2)]);
var state_58873__$1 = (function (){var statearr_58893 = state_58873;
(statearr_58893[(12)] = inst_58854);

return statearr_58893;
})();
if(cljs.core.truth_(inst_58804)){
var statearr_58894_58949 = state_58873__$1;
(statearr_58894_58949[(1)] = (31));

} else {
var statearr_58895_58950 = state_58873__$1;
(statearr_58895_58950[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (6))){
var inst_58804 = (state_58873[(7)]);
var inst_58798 = (state_58873[(2)]);
var inst_58799 = fluree.db.util.async.throw_err(inst_58798);
var inst_58800 = opts;
var inst_58801 = cljs.core.__destructure_map(inst_58800);
var inst_58802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58801,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_58803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58801,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_58804__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58801,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_58805 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_58801,new cljs.core.Keyword(null,"block","block",664686210));
var state_58873__$1 = (function (){var statearr_58896 = state_58873;
(statearr_58896[(8)] = inst_58799);

(statearr_58896[(15)] = inst_58802);

(statearr_58896[(16)] = inst_58803);

(statearr_58896[(7)] = inst_58804__$1);

(statearr_58896[(17)] = inst_58805);

return statearr_58896;
})();
if(cljs.core.truth_(inst_58804__$1)){
var statearr_58897_58951 = state_58873__$1;
(statearr_58897_58951[(1)] = (7));

} else {
var statearr_58898_58952 = state_58873__$1;
(statearr_58898_58952[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (28))){
var inst_58799 = (state_58873[(8)]);
var state_58873__$1 = state_58873;
var statearr_58899_58953 = state_58873__$1;
(statearr_58899_58953[(2)] = inst_58799);

(statearr_58899_58953[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (25))){
var state_58873__$1 = state_58873;
var statearr_58900_58954 = state_58873__$1;
(statearr_58900_58954[(2)] = null);

(statearr_58900_58954[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (34))){
var inst_58845 = (state_58873[(18)]);
var state_58873__$1 = state_58873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58873__$1,(37),inst_58845);
} else {
if((state_val_58874 === (17))){
var inst_58802 = (state_58873[(15)]);
var state_58873__$1 = state_58873;
var statearr_58901_58955 = state_58873__$1;
(statearr_58901_58955[(2)] = inst_58802);

(statearr_58901_58955[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (3))){
var inst_58871 = (state_58873[(2)]);
var state_58873__$1 = state_58873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_58873__$1,inst_58871);
} else {
if((state_val_58874 === (12))){
var inst_58802 = (state_58873[(15)]);
var inst_58828 = (state_58873[(2)]);
var state_58873__$1 = (function (){var statearr_58902 = state_58873;
(statearr_58902[(9)] = inst_58828);

return statearr_58902;
})();
if(cljs.core.truth_(inst_58802)){
var statearr_58903_58956 = state_58873__$1;
(statearr_58903_58956[(1)] = (17));

} else {
var statearr_58904_58957 = state_58873__$1;
(statearr_58904_58957[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (2))){
var _ = (function (){var statearr_58905 = state_58873;
(statearr_58905[(4)] = cljs.core.cons((5),(state_58873[(4)])));

return statearr_58905;
})();
var inst_58796 = fluree.db.session.db(conn,ledger,null);
var state_58873__$1 = state_58873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58873__$1,(6),inst_58796);
} else {
if((state_val_58874 === (23))){
var inst_58834 = (state_58873[(2)]);
var inst_58835 = fluree.db.util.async.throw_err(inst_58834);
var state_58873__$1 = state_58873;
var statearr_58906_58958 = state_58873__$1;
(statearr_58906_58958[(2)] = inst_58835);

(statearr_58906_58958[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (35))){
var inst_58859 = (state_58873[(13)]);
var state_58873__$1 = state_58873;
var statearr_58907_58959 = state_58873__$1;
(statearr_58907_58959[(2)] = inst_58859);

(statearr_58907_58959[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (19))){
var inst_58840 = (state_58873[(10)]);
var inst_58840__$1 = (state_58873[(2)]);
var state_58873__$1 = (function (){var statearr_58908 = state_58873;
(statearr_58908[(10)] = inst_58840__$1);

return statearr_58908;
})();
if(cljs.core.truth_(inst_58840__$1)){
var statearr_58909_58960 = state_58873__$1;
(statearr_58909_58960[(1)] = (24));

} else {
var statearr_58910_58961 = state_58873__$1;
(statearr_58910_58961[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (11))){
var state_58873__$1 = state_58873;
var statearr_58912_58962 = state_58873__$1;
(statearr_58912_58962[(2)] = null);

(statearr_58912_58962[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (9))){
var inst_58810 = (state_58873[(2)]);
var state_58873__$1 = state_58873;
if(cljs.core.truth_(inst_58810)){
var statearr_58913_58963 = state_58873__$1;
(statearr_58913_58963[(1)] = (10));

} else {
var statearr_58914_58964 = state_58873__$1;
(statearr_58914_58964[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (5))){
var _ = (function (){var statearr_58915 = state_58873;
(statearr_58915[(4)] = cljs.core.rest((state_58873[(4)])));

return statearr_58915;
})();
var state_58873__$1 = state_58873;
var ex58911 = (state_58873__$1[(2)]);
var statearr_58916_58965 = state_58873__$1;
(statearr_58916_58965[(5)] = ex58911);


var statearr_58917_58966 = state_58873__$1;
(statearr_58917_58966[(1)] = (4));

(statearr_58917_58966[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (14))){
var inst_58815 = (state_58873[(14)]);
var state_58873__$1 = state_58873;
var statearr_58918_58967 = state_58873__$1;
(statearr_58918_58967[(2)] = inst_58815);

(statearr_58918_58967[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (26))){
var inst_58805 = (state_58873[(17)]);
var inst_58845 = (state_58873[(2)]);
var state_58873__$1 = (function (){var statearr_58919 = state_58873;
(statearr_58919[(18)] = inst_58845);

return statearr_58919;
})();
if(cljs.core.truth_(inst_58805)){
var statearr_58920_58968 = state_58873__$1;
(statearr_58920_58968[(1)] = (27));

} else {
var statearr_58921_58969 = state_58873__$1;
(statearr_58921_58969[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (16))){
var inst_58825 = (state_58873[(2)]);
var state_58873__$1 = state_58873;
var statearr_58922_58970 = state_58873__$1;
(statearr_58922_58970[(2)] = inst_58825);

(statearr_58922_58970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (30))){
var inst_58850 = (state_58873[(2)]);
var inst_58851 = fluree.db.util.async.throw_err(inst_58850);
var state_58873__$1 = state_58873;
var statearr_58923_58971 = state_58873__$1;
(statearr_58923_58971[(2)] = inst_58851);

(statearr_58923_58971[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (10))){
var inst_58799 = (state_58873[(8)]);
var inst_58804 = (state_58873[(7)]);
var inst_58812 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_58799,inst_58804);
var state_58873__$1 = state_58873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_58873__$1,(13),inst_58812);
} else {
if((state_val_58874 === (18))){
var inst_58828 = (state_58873[(9)]);
var state_58873__$1 = state_58873;
if(cljs.core.truth_(inst_58828)){
var statearr_58924_58972 = state_58873__$1;
(statearr_58924_58972[(1)] = (20));

} else {
var statearr_58925_58973 = state_58873__$1;
(statearr_58925_58973[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (37))){
var inst_58859 = (state_58873[(13)]);
var inst_58862 = (state_58873[(2)]);
var inst_58863 = fluree.db.util.async.throw_err(inst_58862);
var inst_58864 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_58859,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_58863);
var state_58873__$1 = state_58873;
var statearr_58926_58974 = state_58873__$1;
(statearr_58926_58974[(2)] = inst_58864);

(statearr_58926_58974[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58874 === (8))){
var inst_58804 = (state_58873[(7)]);
var state_58873__$1 = state_58873;
var statearr_58927_58975 = state_58873__$1;
(statearr_58927_58975[(2)] = inst_58804);

(statearr_58927_58975[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2733__auto__ = null;
var fluree$db$api$query$state_machine__2733__auto____0 = (function (){
var statearr_58928 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_58928[(0)] = fluree$db$api$query$state_machine__2733__auto__);

(statearr_58928[(1)] = (1));

return statearr_58928;
});
var fluree$db$api$query$state_machine__2733__auto____1 = (function (state_58873){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_58873);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e58929){var ex__2736__auto__ = e58929;
var statearr_58930_58976 = state_58873;
(statearr_58930_58976[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_58873[(4)]))){
var statearr_58931_58977 = state_58873;
(statearr_58931_58977[(1)] = cljs.core.first((state_58873[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58978 = state_58873;
state_58873 = G__58978;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2733__auto__ = function(state_58873){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2733__auto____1.call(this,state_58873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2733__auto____0;
fluree$db$api$query$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2733__auto____1;
return fluree$db$api$query$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_58932 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_58932[(6)] = c__2755__auto___58934);

return statearr_58932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_59119){
var state_val_59120 = (state_59119[(1)]);
if((state_val_59120 === (7))){
var inst_58999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59000 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59001 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59002 = [inst_59000,inst_59001];
var inst_59003 = (new cljs.core.PersistentVector(null,2,(5),inst_58999,inst_59002,null));
var state_59119__$1 = state_59119;
var statearr_59121_59191 = state_59119__$1;
(statearr_59121_59191[(2)] = inst_59003);

(statearr_59121_59191[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (20))){
var inst_59029 = (state_59119[(7)]);
var state_59119__$1 = state_59119;
var statearr_59122_59192 = state_59119__$1;
(statearr_59122_59192[(2)] = inst_59029);

(statearr_59122_59192[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (27))){
var state_59119__$1 = state_59119;
var statearr_59123_59193 = state_59119__$1;
(statearr_59123_59193[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (1))){
var state_59119__$1 = state_59119;
var statearr_59125_59194 = state_59119__$1;
(statearr_59125_59194[(2)] = null);

(statearr_59125_59194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (24))){
var inst_59028 = (state_59119[(8)]);
var state_59119__$1 = state_59119;
if(cljs.core.truth_(inst_59028)){
var statearr_59126_59195 = state_59119__$1;
(statearr_59126_59195[(1)] = (26));

} else {
var statearr_59127_59196 = state_59119__$1;
(statearr_59127_59196[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (39))){
var inst_59074 = (state_59119[(9)]);
var inst_59075 = (state_59119[(10)]);
var inst_59100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59101 = [inst_59074,inst_59075];
var inst_59102 = (new cljs.core.PersistentVector(null,2,(5),inst_59100,inst_59101,null));
var state_59119__$1 = state_59119;
var statearr_59128_59197 = state_59119__$1;
(statearr_59128_59197[(2)] = inst_59102);

(statearr_59128_59197[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (4))){
var inst_58979 = (state_59119[(2)]);
var state_59119__$1 = state_59119;
var statearr_59129_59198 = state_59119__$1;
(statearr_59129_59198[(2)] = inst_58979);

(statearr_59129_59198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (15))){
var inst_59008 = (state_59119[(11)]);
var inst_59013 = (state_59119[(12)]);
var inst_59022 = (state_59119[(2)]);
var inst_59023 = [inst_59013,inst_59022];
var inst_59024 = (new cljs.core.PersistentVector(null,2,(5),inst_59008,inst_59023,null));
var state_59119__$1 = state_59119;
var statearr_59130_59199 = state_59119__$1;
(statearr_59130_59199[(2)] = inst_59024);

(statearr_59130_59199[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (21))){
var inst_59028 = (state_59119[(8)]);
var state_59119__$1 = state_59119;
var statearr_59131_59200 = state_59119__$1;
(statearr_59131_59200[(2)] = inst_59028);

(statearr_59131_59200[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (31))){
var inst_59069 = (state_59119[(2)]);
var state_59119__$1 = state_59119;
var statearr_59132_59201 = state_59119__$1;
(statearr_59132_59201[(2)] = inst_59069);

(statearr_59132_59201[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (32))){
var inst_59075 = (state_59119[(10)]);
var inst_59078 = cljs.core.pos_int_QMARK_(inst_59075);
var state_59119__$1 = state_59119;
var statearr_59133_59202 = state_59119__$1;
(statearr_59133_59202[(2)] = inst_59078);

(statearr_59133_59202[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (40))){
var inst_59106 = (state_59119[(13)]);
var inst_59030 = (state_59119[(14)]);
var inst_59104 = (state_59119[(2)]);
var inst_59105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59104,(0),null);
var inst_59106__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59104,(1),null);
var inst_59107 = (inst_59106__$1 > inst_59030);
var state_59119__$1 = (function (){var statearr_59134 = state_59119;
(statearr_59134[(13)] = inst_59106__$1);

(statearr_59134[(15)] = inst_59105);

return statearr_59134;
})();
if(cljs.core.truth_(inst_59107)){
var statearr_59135_59203 = state_59119__$1;
(statearr_59135_59203[(1)] = (41));

} else {
var statearr_59136_59204 = state_59119__$1;
(statearr_59136_59204[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (33))){
var inst_59076 = (state_59119[(16)]);
var state_59119__$1 = state_59119;
var statearr_59137_59205 = state_59119__$1;
(statearr_59137_59205[(2)] = inst_59076);

(statearr_59137_59205[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (13))){
var inst_59014 = (state_59119[(17)]);
var inst_59016 = fluree.db.time_travel.block_to_int_format(db,inst_59014);
var state_59119__$1 = state_59119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59119__$1,(16),inst_59016);
} else {
if((state_val_59120 === (22))){
var inst_59047 = (state_59119[(2)]);
var state_59119__$1 = state_59119;
if(cljs.core.truth_(inst_59047)){
var statearr_59138_59206 = state_59119__$1;
(statearr_59138_59206[(1)] = (23));

} else {
var statearr_59139_59207 = state_59119__$1;
(statearr_59139_59207[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (36))){
var state_59119__$1 = state_59119;
var statearr_59140_59208 = state_59119__$1;
(statearr_59140_59208[(2)] = null);

(statearr_59140_59208[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (41))){
var inst_59030 = (state_59119[(14)]);
var state_59119__$1 = state_59119;
var statearr_59141_59209 = state_59119__$1;
(statearr_59141_59209[(2)] = inst_59030);

(statearr_59141_59209[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (43))){
var inst_59105 = (state_59119[(15)]);
var inst_59111 = (state_59119[(2)]);
var inst_59112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59113 = [inst_59105,inst_59111];
var inst_59114 = (new cljs.core.PersistentVector(null,2,(5),inst_59112,inst_59113,null));
var _ = (function (){var statearr_59142 = state_59119;
(statearr_59142[(4)] = cljs.core.rest((state_59119[(4)])));

return statearr_59142;
})();
var state_59119__$1 = state_59119;
var statearr_59143_59210 = state_59119__$1;
(statearr_59143_59210[(2)] = inst_59114);

(statearr_59143_59210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (29))){
var inst_59005 = (state_59119[(18)]);
var inst_59060 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59005], 0));
var inst_59061 = ["Invalid block range provided: ",inst_59060].join('');
var inst_59062 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59063 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59064 = cljs.core.PersistentHashMap.fromArrays(inst_59062,inst_59063);
var inst_59065 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59061,inst_59064);
var inst_59066 = (function(){throw inst_59065})();
var state_59119__$1 = state_59119;
var statearr_59144_59211 = state_59119__$1;
(statearr_59144_59211[(2)] = inst_59066);

(statearr_59144_59211[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (6))){
var inst_58997 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59119__$1 = state_59119;
var statearr_59145_59212 = state_59119__$1;
(statearr_59145_59212[(2)] = inst_58997);

(statearr_59145_59212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (28))){
var inst_59071 = (state_59119[(2)]);
var state_59119__$1 = state_59119;
var statearr_59146_59213 = state_59119__$1;
(statearr_59146_59213[(2)] = inst_59071);

(statearr_59146_59213[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (25))){
var inst_59076 = (state_59119[(16)]);
var inst_59074 = (state_59119[(9)]);
var inst_59073 = (state_59119[(2)]);
var inst_59074__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59073,(0),null);
var inst_59075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59073,(1),null);
var inst_59076__$1 = cljs.core.pos_int_QMARK_(inst_59074__$1);
var state_59119__$1 = (function (){var statearr_59147 = state_59119;
(statearr_59147[(16)] = inst_59076__$1);

(statearr_59147[(9)] = inst_59074__$1);

(statearr_59147[(10)] = inst_59075);

return statearr_59147;
})();
if(inst_59076__$1){
var statearr_59148_59214 = state_59119__$1;
(statearr_59148_59214[(1)] = (32));

} else {
var statearr_59149_59215 = state_59119__$1;
(statearr_59149_59215[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (34))){
var inst_59081 = (state_59119[(2)]);
var inst_59082 = cljs.core.not(inst_59081);
var state_59119__$1 = state_59119;
if(inst_59082){
var statearr_59150_59216 = state_59119__$1;
(statearr_59150_59216[(1)] = (35));

} else {
var statearr_59151_59217 = state_59119__$1;
(statearr_59151_59217[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (17))){
var inst_59028 = (state_59119[(8)]);
var inst_59030 = (state_59119[(14)]);
var inst_59033 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59028], 0));
var inst_59034 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59030], 0));
var inst_59035 = ["Start block is out of range for this ledger. Start block provided: ",inst_59033,". Database block: ",inst_59034].join('');
var inst_59036 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59037 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59038 = cljs.core.PersistentHashMap.fromArrays(inst_59036,inst_59037);
var inst_59039 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59035,inst_59038);
var inst_59040 = (function(){throw inst_59039})();
var state_59119__$1 = state_59119;
var statearr_59152_59218 = state_59119__$1;
(statearr_59152_59218[(2)] = inst_59040);

(statearr_59152_59218[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (3))){
var inst_59117 = (state_59119[(2)]);
var state_59119__$1 = state_59119;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59119__$1,inst_59117);
} else {
if((state_val_59120 === (12))){
var inst_59014 = (state_59119[(17)]);
var inst_59005 = (state_59119[(18)]);
var inst_59012 = (state_59119[(2)]);
var inst_59013 = fluree.db.util.async.throw_err(inst_59012);
var inst_59014__$1 = cljs.core.second(inst_59005);
var state_59119__$1 = (function (){var statearr_59153 = state_59119;
(statearr_59153[(17)] = inst_59014__$1);

(statearr_59153[(12)] = inst_59013);

return statearr_59153;
})();
if(cljs.core.truth_(inst_59014__$1)){
var statearr_59154_59219 = state_59119__$1;
(statearr_59154_59219[(1)] = (13));

} else {
var statearr_59155_59220 = state_59119__$1;
(statearr_59155_59220[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (2))){
var _ = (function (){var statearr_59156 = state_59119;
(statearr_59156[(4)] = cljs.core.cons((5),(state_59119[(4)])));

return statearr_59156;
})();
var inst_58994 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_58995 = cljs.core.sequential_QMARK_(inst_58994);
var state_59119__$1 = state_59119;
if(inst_58995){
var statearr_59157_59221 = state_59119__$1;
(statearr_59157_59221[(1)] = (6));

} else {
var statearr_59158_59222 = state_59119__$1;
(statearr_59158_59222[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (23))){
var inst_59029 = (state_59119[(7)]);
var inst_59028 = (state_59119[(8)]);
var inst_59049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59050 = [inst_59028,inst_59029];
var inst_59051 = (new cljs.core.PersistentVector(null,2,(5),inst_59049,inst_59050,null));
var state_59119__$1 = state_59119;
var statearr_59159_59223 = state_59119__$1;
(statearr_59159_59223[(2)] = inst_59051);

(statearr_59159_59223[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (35))){
var inst_59005 = (state_59119[(18)]);
var inst_59084 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59005], 0));
var inst_59085 = ["Invalid block range provided: ",inst_59084].join('');
var inst_59086 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59087 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59088 = cljs.core.PersistentHashMap.fromArrays(inst_59086,inst_59087);
var inst_59089 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59085,inst_59088);
var inst_59090 = (function(){throw inst_59089})();
var state_59119__$1 = state_59119;
var statearr_59160_59224 = state_59119__$1;
(statearr_59160_59224[(2)] = inst_59090);

(statearr_59160_59224[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (19))){
var inst_59028 = (state_59119[(8)]);
var inst_59043 = (state_59119[(2)]);
var state_59119__$1 = (function (){var statearr_59161 = state_59119;
(statearr_59161[(19)] = inst_59043);

return statearr_59161;
})();
if(cljs.core.truth_(inst_59028)){
var statearr_59162_59225 = state_59119__$1;
(statearr_59162_59225[(1)] = (20));

} else {
var statearr_59163_59226 = state_59119__$1;
(statearr_59163_59226[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (11))){
var inst_59028 = (state_59119[(8)]);
var inst_59030 = (state_59119[(14)]);
var inst_59027 = (state_59119[(2)]);
var inst_59028__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59027,(0),null);
var inst_59029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59027,(1),null);
var inst_59030__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59031 = (inst_59028__$1 > inst_59030__$1);
var state_59119__$1 = (function (){var statearr_59165 = state_59119;
(statearr_59165[(7)] = inst_59029);

(statearr_59165[(8)] = inst_59028__$1);

(statearr_59165[(14)] = inst_59030__$1);

return statearr_59165;
})();
if(cljs.core.truth_(inst_59031)){
var statearr_59166_59227 = state_59119__$1;
(statearr_59166_59227[(1)] = (17));

} else {
var statearr_59167_59228 = state_59119__$1;
(statearr_59167_59228[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (9))){
var inst_59005 = (state_59119[(18)]);
var inst_59008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59009 = cljs.core.first(inst_59005);
var inst_59010 = fluree.db.time_travel.block_to_int_format(db,inst_59009);
var state_59119__$1 = (function (){var statearr_59168 = state_59119;
(statearr_59168[(11)] = inst_59008);

return statearr_59168;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59119__$1,(12),inst_59010);
} else {
if((state_val_59120 === (5))){
var _ = (function (){var statearr_59169 = state_59119;
(statearr_59169[(4)] = cljs.core.rest((state_59119[(4)])));

return statearr_59169;
})();
var state_59119__$1 = state_59119;
var ex59164 = (state_59119__$1[(2)]);
var statearr_59170_59229 = state_59119__$1;
(statearr_59170_59229[(5)] = ex59164);


if((ex59164 instanceof Error)){
var statearr_59171_59230 = state_59119__$1;
(statearr_59171_59230[(1)] = (4));

(statearr_59171_59230[(5)] = null);

} else {
throw ex59164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (14))){
var state_59119__$1 = state_59119;
var statearr_59172_59231 = state_59119__$1;
(statearr_59172_59231[(2)] = null);

(statearr_59172_59231[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (26))){
var inst_59028 = (state_59119[(8)]);
var inst_59054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59055 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59056 = [inst_59028,inst_59055];
var inst_59057 = (new cljs.core.PersistentVector(null,2,(5),inst_59054,inst_59056,null));
var state_59119__$1 = state_59119;
var statearr_59173_59232 = state_59119__$1;
(statearr_59173_59232[(2)] = inst_59057);

(statearr_59173_59232[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (16))){
var inst_59018 = (state_59119[(2)]);
var inst_59019 = fluree.db.util.async.throw_err(inst_59018);
var state_59119__$1 = state_59119;
var statearr_59174_59233 = state_59119__$1;
(statearr_59174_59233[(2)] = inst_59019);

(statearr_59174_59233[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (38))){
var inst_59074 = (state_59119[(9)]);
var inst_59075 = (state_59119[(10)]);
var inst_59096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59097 = [inst_59075,inst_59074];
var inst_59098 = (new cljs.core.PersistentVector(null,2,(5),inst_59096,inst_59097,null));
var state_59119__$1 = state_59119;
var statearr_59175_59234 = state_59119__$1;
(statearr_59175_59234[(2)] = inst_59098);

(statearr_59175_59234[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (30))){
var state_59119__$1 = state_59119;
var statearr_59176_59235 = state_59119__$1;
(statearr_59176_59235[(2)] = null);

(statearr_59176_59235[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (10))){
var inst_59005 = (state_59119[(18)]);
var state_59119__$1 = state_59119;
var statearr_59177_59236 = state_59119__$1;
(statearr_59177_59236[(2)] = inst_59005);

(statearr_59177_59236[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (18))){
var state_59119__$1 = state_59119;
var statearr_59178_59237 = state_59119__$1;
(statearr_59178_59237[(2)] = null);

(statearr_59178_59237[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (42))){
var inst_59106 = (state_59119[(13)]);
var state_59119__$1 = state_59119;
var statearr_59179_59238 = state_59119__$1;
(statearr_59179_59238[(2)] = inst_59106);

(statearr_59179_59238[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (37))){
var inst_59074 = (state_59119[(9)]);
var inst_59075 = (state_59119[(10)]);
var inst_59093 = (state_59119[(2)]);
var inst_59094 = (inst_59075 < inst_59074);
var state_59119__$1 = (function (){var statearr_59180 = state_59119;
(statearr_59180[(20)] = inst_59093);

return statearr_59180;
})();
if(cljs.core.truth_(inst_59094)){
var statearr_59181_59239 = state_59119__$1;
(statearr_59181_59239[(1)] = (38));

} else {
var statearr_59182_59240 = state_59119__$1;
(statearr_59182_59240[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59120 === (8))){
var inst_59005 = (state_59119[(18)]);
var inst_59005__$1 = (state_59119[(2)]);
var inst_59006 = cljs.core.some(cljs.core.string_QMARK_,inst_59005__$1);
var state_59119__$1 = (function (){var statearr_59183 = state_59119;
(statearr_59183[(18)] = inst_59005__$1);

return statearr_59183;
})();
if(cljs.core.truth_(inst_59006)){
var statearr_59184_59241 = state_59119__$1;
(statearr_59184_59241[(1)] = (9));

} else {
var statearr_59185_59242 = state_59119__$1;
(statearr_59185_59242[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____0 = (function (){
var statearr_59186 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59186[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__);

(statearr_59186[(1)] = (1));

return statearr_59186;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____1 = (function (state_59119){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_59119);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e59187){var ex__2736__auto__ = e59187;
var statearr_59188_59243 = state_59119;
(statearr_59188_59243[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_59119[(4)]))){
var statearr_59189_59244 = state_59119;
(statearr_59189_59244[(1)] = cljs.core.first((state_59119[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59245 = state_59119;
state_59119 = G__59245;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__ = function(state_59119){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____1.call(this,state_59119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_59190 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_59190[(6)] = c__2755__auto__);

return statearr_59190;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_59395){
var state_val_59396 = (state_59395[(1)]);
if((state_val_59396 === (7))){
var inst_59307 = (state_59395[(2)]);
var inst_59308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59307,(0),null);
var inst_59309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59307,(1),null);
var inst_59317 = cljs.core.vals(inst_59309);
var inst_59318 = cljs.core.seq(inst_59317);
var inst_59319 = cljs.core.first(inst_59318);
var inst_59320 = cljs.core.next(inst_59318);
var inst_59321 = cljs.core.PersistentVector.EMPTY;
var inst_59322 = inst_59317;
var inst_59323 = inst_59321;
var state_59395__$1 = (function (){var statearr_59397 = state_59395;
(statearr_59397[(7)] = inst_59322);

(statearr_59397[(8)] = inst_59319);

(statearr_59397[(9)] = inst_59308);

(statearr_59397[(10)] = inst_59323);

(statearr_59397[(11)] = inst_59320);

return statearr_59397;
})();
var statearr_59398_59451 = state_59395__$1;
(statearr_59398_59451[(2)] = null);

(statearr_59398_59451[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (20))){
var inst_59329 = (state_59395[(12)]);
var inst_59334 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59335 = cljs.core.PersistentHashMap.EMPTY;
var inst_59336 = [true,inst_59335];
var inst_59337 = cljs.core.PersistentHashMap.fromArrays(inst_59334,inst_59336);
var inst_59338 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59337,inst_59329);
var state_59395__$1 = state_59395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59395__$1,(22),inst_59338);
} else {
if((state_val_59396 === (27))){
var inst_59383 = (state_59395[(2)]);
var state_59395__$1 = state_59395;
var statearr_59399_59452 = state_59395__$1;
(statearr_59399_59452[(2)] = inst_59383);

(statearr_59399_59452[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (1))){
var state_59395__$1 = state_59395;
var statearr_59400_59453 = state_59395__$1;
(statearr_59400_59453[(2)] = null);

(statearr_59400_59453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (24))){
var inst_59347 = (state_59395[(13)]);
var inst_59385 = (state_59395[(2)]);
var inst_59386 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_59387 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59388 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59389 = [inst_59387,inst_59388,inst_59347,inst_59385];
var inst_59390 = cljs.core.PersistentHashMap.fromArrays(inst_59386,inst_59389);
var _ = (function (){var statearr_59402 = state_59395;
(statearr_59402[(4)] = cljs.core.rest((state_59395[(4)])));

return statearr_59402;
})();
var state_59395__$1 = state_59395;
var statearr_59403_59454 = state_59395__$1;
(statearr_59403_59454[(2)] = inst_59390);

(statearr_59403_59454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (4))){
var inst_59248 = (state_59395[(2)]);
var state_59395__$1 = state_59395;
var statearr_59404_59455 = state_59395__$1;
(statearr_59404_59455[(2)] = inst_59248);

(statearr_59404_59455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (15))){
var inst_59288 = (state_59395[(14)]);
var inst_59264 = (state_59395[(15)]);
var inst_59267 = (state_59395[(16)]);
var inst_59293 = (state_59395[(17)]);
var inst_59278 = (state_59395[(18)]);
var inst_59279 = (state_59395[(19)]);
var inst_59286 = (state_59395[(20)]);
var inst_59266 = (state_59395[(21)]);
var inst_59272 = (state_59395[(22)]);
var inst_59271 = (state_59395[(23)]);
var inst_59270 = (state_59395[(24)]);
var inst_59299 = (function (){var first__59263 = inst_59266;
var subject = inst_59286;
var flake = inst_59278;
var r = inst_59279;
var asserted_subjects = inst_59271;
var flake_SINGLEQUOTE_ = inst_59293;
var retracted_subjects = inst_59272;
var vec__59261 = inst_59264;
var seq__59262 = inst_59267;
var asserted_QMARK_ = inst_59288;
var G__59260 = inst_59270;
var vec__59274 = inst_59270;
var seq__59275 = inst_59279;
var first__59276 = inst_59278;
return (function (p1__59247_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59247_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59300 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59272,inst_59286,inst_59299);
var tmp59401 = inst_59271;
var inst_59270__$1 = inst_59279;
var inst_59271__$1 = tmp59401;
var inst_59272__$1 = inst_59300;
var state_59395__$1 = (function (){var statearr_59405 = state_59395;
(statearr_59405[(22)] = inst_59272__$1);

(statearr_59405[(23)] = inst_59271__$1);

(statearr_59405[(24)] = inst_59270__$1);

return statearr_59405;
})();
var statearr_59406_59456 = state_59395__$1;
(statearr_59406_59456[(2)] = null);

(statearr_59406_59456[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (21))){
var inst_59345 = (state_59395[(2)]);
var state_59395__$1 = state_59395;
var statearr_59407_59457 = state_59395__$1;
(statearr_59407_59457[(2)] = inst_59345);

(statearr_59407_59457[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (13))){
var inst_59288 = (state_59395[(14)]);
var inst_59293 = (state_59395[(2)]);
var state_59395__$1 = (function (){var statearr_59408 = state_59395;
(statearr_59408[(17)] = inst_59293);

return statearr_59408;
})();
if(cljs.core.truth_(inst_59288)){
var statearr_59409_59458 = state_59395__$1;
(statearr_59409_59458[(1)] = (14));

} else {
var statearr_59410_59459 = state_59395__$1;
(statearr_59410_59459[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (22))){
var inst_59330 = (state_59395[(25)]);
var inst_59323 = (state_59395[(10)]);
var inst_59340 = (state_59395[(2)]);
var inst_59341 = fluree.db.util.async.throw_err(inst_59340);
var inst_59342 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59323,inst_59341);
var inst_59322 = inst_59330;
var inst_59323__$1 = inst_59342;
var state_59395__$1 = (function (){var statearr_59411 = state_59395;
(statearr_59411[(7)] = inst_59322);

(statearr_59411[(10)] = inst_59323__$1);

return statearr_59411;
})();
var statearr_59412_59460 = state_59395__$1;
(statearr_59412_59460[(2)] = null);

(statearr_59412_59460[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (6))){
var inst_59278 = (state_59395[(18)]);
var inst_59270 = (state_59395[(24)]);
var inst_59277 = cljs.core.seq(inst_59270);
var inst_59278__$1 = cljs.core.first(inst_59277);
var inst_59279 = cljs.core.next(inst_59277);
var inst_59280 = cljs.core.not(inst_59278__$1);
var state_59395__$1 = (function (){var statearr_59413 = state_59395;
(statearr_59413[(18)] = inst_59278__$1);

(statearr_59413[(19)] = inst_59279);

return statearr_59413;
})();
if(inst_59280){
var statearr_59414_59461 = state_59395__$1;
(statearr_59414_59461[(1)] = (8));

} else {
var statearr_59415_59462 = state_59395__$1;
(statearr_59415_59462[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (28))){
var inst_59368 = (state_59395[(26)]);
var inst_59361 = (state_59395[(27)]);
var inst_59378 = (state_59395[(2)]);
var inst_59379 = fluree.db.util.async.throw_err(inst_59378);
var inst_59380 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59361,inst_59379);
var inst_59360 = inst_59368;
var inst_59361__$1 = inst_59380;
var state_59395__$1 = (function (){var statearr_59416 = state_59395;
(statearr_59416[(27)] = inst_59361__$1);

(statearr_59416[(28)] = inst_59360);

return statearr_59416;
})();
var statearr_59417_59463 = state_59395__$1;
(statearr_59417_59463[(2)] = null);

(statearr_59417_59463[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (25))){
var inst_59361 = (state_59395[(27)]);
var state_59395__$1 = state_59395;
var statearr_59418_59464 = state_59395__$1;
(statearr_59418_59464[(2)] = inst_59361);

(statearr_59418_59464[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (17))){
var inst_59322 = (state_59395[(7)]);
var inst_59329 = (state_59395[(12)]);
var inst_59328 = cljs.core.seq(inst_59322);
var inst_59329__$1 = cljs.core.first(inst_59328);
var inst_59330 = cljs.core.next(inst_59328);
var inst_59331 = cljs.core.not(inst_59329__$1);
var state_59395__$1 = (function (){var statearr_59419 = state_59395;
(statearr_59419[(25)] = inst_59330);

(statearr_59419[(12)] = inst_59329__$1);

return statearr_59419;
})();
if(inst_59331){
var statearr_59420_59465 = state_59395__$1;
(statearr_59420_59465[(1)] = (19));

} else {
var statearr_59421_59466 = state_59395__$1;
(statearr_59421_59466[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (3))){
var inst_59393 = (state_59395[(2)]);
var state_59395__$1 = state_59395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59395__$1,inst_59393);
} else {
if((state_val_59396 === (12))){
var inst_59278 = (state_59395[(18)]);
var inst_59291 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_59278);
var state_59395__$1 = state_59395;
var statearr_59422_59467 = state_59395__$1;
(statearr_59422_59467[(2)] = inst_59291);

(statearr_59422_59467[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (2))){
var inst_59264 = (state_59395[(15)]);
var _ = (function (){var statearr_59423 = state_59395;
(statearr_59423[(4)] = cljs.core.cons((5),(state_59395[(4)])));

return statearr_59423;
})();
var inst_59264__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59265 = cljs.core.seq(inst_59264__$1);
var inst_59266 = cljs.core.first(inst_59265);
var inst_59267 = cljs.core.next(inst_59265);
var inst_59268 = cljs.core.PersistentHashMap.EMPTY;
var inst_59269 = cljs.core.PersistentHashMap.EMPTY;
var inst_59270 = inst_59264__$1;
var inst_59271 = inst_59268;
var inst_59272 = inst_59269;
var state_59395__$1 = (function (){var statearr_59424 = state_59395;
(statearr_59424[(15)] = inst_59264__$1);

(statearr_59424[(16)] = inst_59267);

(statearr_59424[(21)] = inst_59266);

(statearr_59424[(22)] = inst_59272);

(statearr_59424[(23)] = inst_59271);

(statearr_59424[(24)] = inst_59270);

return statearr_59424;
})();
var statearr_59425_59468 = state_59395__$1;
(statearr_59425_59468[(2)] = null);

(statearr_59425_59468[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (23))){
var inst_59367 = (state_59395[(29)]);
var inst_59360 = (state_59395[(28)]);
var inst_59366 = cljs.core.seq(inst_59360);
var inst_59367__$1 = cljs.core.first(inst_59366);
var inst_59368 = cljs.core.next(inst_59366);
var inst_59369 = cljs.core.not(inst_59367__$1);
var state_59395__$1 = (function (){var statearr_59426 = state_59395;
(statearr_59426[(29)] = inst_59367__$1);

(statearr_59426[(26)] = inst_59368);

return statearr_59426;
})();
if(inst_59369){
var statearr_59427_59469 = state_59395__$1;
(statearr_59427_59469[(1)] = (25));

} else {
var statearr_59428_59470 = state_59395__$1;
(statearr_59428_59470[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (19))){
var inst_59323 = (state_59395[(10)]);
var state_59395__$1 = state_59395;
var statearr_59429_59471 = state_59395__$1;
(statearr_59429_59471[(2)] = inst_59323);

(statearr_59429_59471[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (11))){
var inst_59278 = (state_59395[(18)]);
var state_59395__$1 = state_59395;
var statearr_59431_59472 = state_59395__$1;
(statearr_59431_59472[(2)] = inst_59278);

(statearr_59431_59472[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (9))){
var inst_59288 = (state_59395[(14)]);
var inst_59278 = (state_59395[(18)]);
var inst_59286 = inst_59278.s;
var inst_59287 = inst_59278.op;
var inst_59288__$1 = inst_59287 === true;
var state_59395__$1 = (function (){var statearr_59433 = state_59395;
(statearr_59433[(14)] = inst_59288__$1);

(statearr_59433[(20)] = inst_59286);

return statearr_59433;
})();
if(cljs.core.truth_(inst_59288__$1)){
var statearr_59434_59473 = state_59395__$1;
(statearr_59434_59473[(1)] = (11));

} else {
var statearr_59435_59474 = state_59395__$1;
(statearr_59435_59474[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (5))){
var _ = (function (){var statearr_59436 = state_59395;
(statearr_59436[(4)] = cljs.core.rest((state_59395[(4)])));

return statearr_59436;
})();
var state_59395__$1 = state_59395;
var ex59430 = (state_59395__$1[(2)]);
var statearr_59437_59475 = state_59395__$1;
(statearr_59437_59475[(5)] = ex59430);


if((ex59430 instanceof Error)){
var statearr_59438_59476 = state_59395__$1;
(statearr_59438_59476[(1)] = (4));

(statearr_59438_59476[(5)] = null);

} else {
throw ex59430;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (14))){
var inst_59288 = (state_59395[(14)]);
var inst_59264 = (state_59395[(15)]);
var inst_59267 = (state_59395[(16)]);
var inst_59293 = (state_59395[(17)]);
var inst_59278 = (state_59395[(18)]);
var inst_59279 = (state_59395[(19)]);
var inst_59286 = (state_59395[(20)]);
var inst_59266 = (state_59395[(21)]);
var inst_59272 = (state_59395[(22)]);
var inst_59271 = (state_59395[(23)]);
var inst_59270 = (state_59395[(24)]);
var inst_59295 = (function (){var first__59263 = inst_59266;
var subject = inst_59286;
var flake = inst_59278;
var r = inst_59279;
var asserted_subjects = inst_59271;
var flake_SINGLEQUOTE_ = inst_59293;
var retracted_subjects = inst_59272;
var vec__59261 = inst_59264;
var seq__59262 = inst_59267;
var asserted_QMARK_ = inst_59288;
var G__59260 = inst_59270;
var vec__59274 = inst_59270;
var seq__59275 = inst_59279;
var first__59276 = inst_59278;
return (function (p1__59246_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59246_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59296 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59271,inst_59286,inst_59295);
var tmp59432 = inst_59272;
var inst_59270__$1 = inst_59279;
var inst_59271__$1 = inst_59296;
var inst_59272__$1 = tmp59432;
var state_59395__$1 = (function (){var statearr_59439 = state_59395;
(statearr_59439[(22)] = inst_59272__$1);

(statearr_59439[(23)] = inst_59271__$1);

(statearr_59439[(24)] = inst_59270__$1);

return statearr_59439;
})();
var statearr_59440_59477 = state_59395__$1;
(statearr_59440_59477[(2)] = null);

(statearr_59440_59477[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (26))){
var inst_59367 = (state_59395[(29)]);
var inst_59372 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59373 = cljs.core.PersistentHashMap.EMPTY;
var inst_59374 = [true,inst_59373];
var inst_59375 = cljs.core.PersistentHashMap.fromArrays(inst_59372,inst_59374);
var inst_59376 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59375,inst_59367);
var state_59395__$1 = state_59395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59395__$1,(28),inst_59376);
} else {
if((state_val_59396 === (16))){
var inst_59303 = (state_59395[(2)]);
var state_59395__$1 = state_59395;
var statearr_59441_59478 = state_59395__$1;
(statearr_59441_59478[(2)] = inst_59303);

(statearr_59441_59478[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (10))){
var inst_59305 = (state_59395[(2)]);
var state_59395__$1 = state_59395;
var statearr_59442_59479 = state_59395__$1;
(statearr_59442_59479[(2)] = inst_59305);

(statearr_59442_59479[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (18))){
var inst_59308 = (state_59395[(9)]);
var inst_59347 = (state_59395[(2)]);
var inst_59355 = cljs.core.vals(inst_59308);
var inst_59356 = cljs.core.seq(inst_59355);
var inst_59357 = cljs.core.first(inst_59356);
var inst_59358 = cljs.core.next(inst_59356);
var inst_59359 = cljs.core.PersistentVector.EMPTY;
var inst_59360 = inst_59355;
var inst_59361 = inst_59359;
var state_59395__$1 = (function (){var statearr_59443 = state_59395;
(statearr_59443[(13)] = inst_59347);

(statearr_59443[(27)] = inst_59361);

(statearr_59443[(30)] = inst_59357);

(statearr_59443[(31)] = inst_59358);

(statearr_59443[(28)] = inst_59360);

return statearr_59443;
})();
var statearr_59444_59480 = state_59395__$1;
(statearr_59444_59480[(2)] = null);

(statearr_59444_59480[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59396 === (8))){
var inst_59272 = (state_59395[(22)]);
var inst_59271 = (state_59395[(23)]);
var inst_59282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59283 = [inst_59271,inst_59272];
var inst_59284 = (new cljs.core.PersistentVector(null,2,(5),inst_59282,inst_59283,null));
var state_59395__$1 = state_59395;
var statearr_59445_59481 = state_59395__$1;
(statearr_59445_59481[(2)] = inst_59284);

(statearr_59445_59481[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_59446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59446[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__);

(statearr_59446[(1)] = (1));

return statearr_59446;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____1 = (function (state_59395){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_59395);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e59447){var ex__2736__auto__ = e59447;
var statearr_59448_59482 = state_59395;
(statearr_59448_59482[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_59395[(4)]))){
var statearr_59449_59483 = state_59395;
(statearr_59449_59483[(1)] = cljs.core.first((state_59395[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59484 = state_59395;
state_59395 = G__59484;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__ = function(state_59395){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____1.call(this,state_59395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_59450 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_59450[(6)] = c__2755__auto__);

return statearr_59450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_59516){
var state_val_59517 = (state_59516[(1)]);
if((state_val_59517 === (1))){
var inst_59485 = cljs.core.volatile_BANG_((0));
var inst_59486 = cljs.core.PersistentHashMap.EMPTY;
var inst_59487 = cljs.core.volatile_BANG_(inst_59486);
var inst_59488 = cljs.core.first(resp);
var inst_59489 = cljs.core.rest(resp);
var inst_59490 = cljs.core.PersistentVector.EMPTY;
var inst_59491 = inst_59485;
var inst_59492 = inst_59487;
var inst_59493 = inst_59488;
var inst_59494 = inst_59489;
var inst_59495 = inst_59490;
var state_59516__$1 = (function (){var statearr_59518 = state_59516;
(statearr_59518[(7)] = inst_59491);

(statearr_59518[(8)] = inst_59494);

(statearr_59518[(9)] = inst_59492);

(statearr_59518[(10)] = inst_59495);

(statearr_59518[(11)] = inst_59493);

return statearr_59518;
})();
var statearr_59519_59534 = state_59516__$1;
(statearr_59519_59534[(2)] = null);

(statearr_59519_59534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59517 === (2))){
var inst_59491 = (state_59516[(7)]);
var inst_59492 = (state_59516[(9)]);
var inst_59493 = (state_59516[(11)]);
var inst_59497 = fluree.db.api.query.format_block_resp_pretty(db,inst_59493,inst_59492,inst_59491);
var state_59516__$1 = state_59516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59516__$1,(4),inst_59497);
} else {
if((state_val_59517 === (3))){
var inst_59514 = (state_59516[(2)]);
var state_59516__$1 = state_59516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59516__$1,inst_59514);
} else {
if((state_val_59517 === (4))){
var inst_59494 = (state_59516[(8)]);
var inst_59495 = (state_59516[(10)]);
var inst_59499 = (state_59516[(2)]);
var inst_59500 = fluree.db.util.async.throw_err(inst_59499);
var inst_59501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59502 = [inst_59500];
var inst_59503 = (new cljs.core.PersistentVector(null,1,(5),inst_59501,inst_59502,null));
var inst_59504 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_59495,inst_59503);
var inst_59505 = cljs.core.first(inst_59494);
var state_59516__$1 = (function (){var statearr_59522 = state_59516;
(statearr_59522[(12)] = inst_59504);

return statearr_59522;
})();
if(cljs.core.truth_(inst_59505)){
var statearr_59523_59535 = state_59516__$1;
(statearr_59523_59535[(1)] = (5));

} else {
var statearr_59524_59536 = state_59516__$1;
(statearr_59524_59536[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59517 === (5))){
var inst_59491 = (state_59516[(7)]);
var inst_59494 = (state_59516[(8)]);
var inst_59492 = (state_59516[(9)]);
var inst_59504 = (state_59516[(12)]);
var inst_59507 = cljs.core.first(inst_59494);
var inst_59508 = cljs.core.rest(inst_59494);
var tmp59520 = inst_59491;
var tmp59521 = inst_59492;
var inst_59491__$1 = tmp59520;
var inst_59492__$1 = tmp59521;
var inst_59493 = inst_59507;
var inst_59494__$1 = inst_59508;
var inst_59495 = inst_59504;
var state_59516__$1 = (function (){var statearr_59525 = state_59516;
(statearr_59525[(7)] = inst_59491__$1);

(statearr_59525[(8)] = inst_59494__$1);

(statearr_59525[(9)] = inst_59492__$1);

(statearr_59525[(10)] = inst_59495);

(statearr_59525[(11)] = inst_59493);

return statearr_59525;
})();
var statearr_59526_59537 = state_59516__$1;
(statearr_59526_59537[(2)] = null);

(statearr_59526_59537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59517 === (6))){
var inst_59504 = (state_59516[(12)]);
var state_59516__$1 = state_59516;
var statearr_59527_59538 = state_59516__$1;
(statearr_59527_59538[(2)] = inst_59504);

(statearr_59527_59538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59517 === (7))){
var inst_59512 = (state_59516[(2)]);
var state_59516__$1 = state_59516;
var statearr_59528_59539 = state_59516__$1;
(statearr_59528_59539[(2)] = inst_59512);

(statearr_59528_59539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____0 = (function (){
var statearr_59529 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59529[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__);

(statearr_59529[(1)] = (1));

return statearr_59529;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____1 = (function (state_59516){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_59516);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e59530){var ex__2736__auto__ = e59530;
var statearr_59531_59540 = state_59516;
(statearr_59531_59540[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_59516[(4)]))){
var statearr_59532_59541 = state_59516;
(statearr_59532_59541[(1)] = cljs.core.first((state_59516[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59542 = state_59516;
state_59516 = G__59542;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__ = function(state_59516){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____1.call(this,state_59516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_59533 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_59533[(6)] = c__2755__auto__);

return statearr_59533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__59545 = arguments.length;
switch (G__59545) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__59547){
var map__59548 = p__59547;
var map__59548__$1 = cljs.core.__destructure_map(map__59548);
var query = map__59548__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59548__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_59633){
var state_val_59634 = (state_59633[(1)]);
if((state_val_59634 === (7))){
var inst_59559 = (state_59633[(7)]);
var inst_59563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59564 = ["_auth/id",inst_59559];
var inst_59565 = (new cljs.core.PersistentVector(null,2,(5),inst_59563,inst_59564,null));
var state_59633__$1 = state_59633;
var statearr_59635_59679 = state_59633__$1;
(statearr_59635_59679[(2)] = inst_59565);

(statearr_59635_59679[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (20))){
var inst_59613 = (state_59633[(2)]);
var inst_59614 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_59633__$1 = (function (){var statearr_59636 = state_59633;
(statearr_59636[(8)] = inst_59613);

return statearr_59636;
})();
if(cljs.core.truth_(inst_59614)){
var statearr_59637_59680 = state_59633__$1;
(statearr_59637_59680[(1)] = (22));

} else {
var statearr_59638_59681 = state_59633__$1;
(statearr_59638_59681[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (27))){
var inst_59560 = (state_59633[(9)]);
var inst_59616 = (state_59633[(10)]);
var inst_59622 = (state_59633[(2)]);
var inst_59623 = fluree.db.api.query.response_time_formatted(inst_59560);
var inst_59624 = [(200),inst_59622,(100),inst_59623];
var inst_59625 = cljs.core.PersistentHashMap.fromArrays(inst_59616,inst_59624);
var state_59633__$1 = state_59633;
var statearr_59639_59682 = state_59633__$1;
(statearr_59639_59682[(2)] = inst_59625);

(statearr_59639_59682[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (1))){
var state_59633__$1 = state_59633;
var statearr_59640_59683 = state_59633__$1;
(statearr_59640_59683[(2)] = null);

(statearr_59640_59683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (24))){
var inst_59628 = (state_59633[(2)]);
var _ = (function (){var statearr_59641 = state_59633;
(statearr_59641[(4)] = cljs.core.rest((state_59633[(4)])));

return statearr_59641;
})();
var state_59633__$1 = state_59633;
var statearr_59642_59684 = state_59633__$1;
(statearr_59642_59684[(2)] = inst_59628);

(statearr_59642_59684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (4))){
var inst_59549 = (state_59633[(2)]);
var state_59633__$1 = state_59633;
var statearr_59643_59685 = state_59633__$1;
(statearr_59643_59685[(2)] = inst_59549);

(statearr_59643_59685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (15))){
var inst_59600 = (state_59633[(11)]);
var state_59633__$1 = state_59633;
var statearr_59644_59686 = state_59633__$1;
(statearr_59644_59686[(2)] = inst_59600);

(statearr_59644_59686[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (21))){
var inst_59609 = (state_59633[(2)]);
var inst_59610 = fluree.db.util.async.throw_err(inst_59609);
var state_59633__$1 = state_59633;
var statearr_59645_59687 = state_59633__$1;
(statearr_59645_59687[(2)] = inst_59610);

(statearr_59645_59687[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (13))){
var inst_59600 = (state_59633[(11)]);
var inst_59558 = (state_59633[(12)]);
var inst_59599 = (state_59633[(2)]);
var inst_59600__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_59558);
var state_59633__$1 = (function (){var statearr_59646 = state_59633;
(statearr_59646[(13)] = inst_59599);

(statearr_59646[(11)] = inst_59600__$1);

return statearr_59646;
})();
if(cljs.core.truth_(inst_59600__$1)){
var statearr_59647_59688 = state_59633__$1;
(statearr_59647_59688[(1)] = (15));

} else {
var statearr_59648_59689 = state_59633__$1;
(statearr_59648_59689[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (22))){
var inst_59613 = (state_59633[(8)]);
var inst_59616 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_59617 = cljs.core.sequential_QMARK_(inst_59613);
var state_59633__$1 = (function (){var statearr_59649 = state_59633;
(statearr_59649[(10)] = inst_59616);

return statearr_59649;
})();
if(inst_59617){
var statearr_59650_59690 = state_59633__$1;
(statearr_59650_59690[(1)] = (25));

} else {
var statearr_59651_59691 = state_59633__$1;
(statearr_59651_59691[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (6))){
var inst_59574 = (state_59633[(14)]);
var inst_59558 = (state_59633[(12)]);
var inst_59573 = (state_59633[(2)]);
var inst_59574__$1 = fluree.db.util.async.throw_err(inst_59573);
var inst_59575 = fluree.db.api.query.resolve_block_range(inst_59574__$1,inst_59558);
var state_59633__$1 = (function (){var statearr_59652 = state_59633;
(statearr_59652[(14)] = inst_59574__$1);

return statearr_59652;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59633__$1,(10),inst_59575);
} else {
if((state_val_59634 === (25))){
var inst_59613 = (state_59633[(8)]);
var inst_59619 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_59613);
var state_59633__$1 = state_59633;
var statearr_59653_59692 = state_59633__$1;
(statearr_59653_59692[(2)] = inst_59619);

(statearr_59653_59692[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (17))){
var inst_59605 = (state_59633[(2)]);
var state_59633__$1 = state_59633;
if(cljs.core.truth_(inst_59605)){
var statearr_59654_59693 = state_59633__$1;
(statearr_59654_59693[(1)] = (18));

} else {
var statearr_59655_59694 = state_59633__$1;
(statearr_59655_59694[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (3))){
var inst_59631 = (state_59633[(2)]);
var state_59633__$1 = state_59633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59633__$1,inst_59631);
} else {
if((state_val_59634 === (12))){
var inst_59558 = (state_59633[(12)]);
var inst_59591 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59558], 0));
var inst_59592 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_59591].join('');
var inst_59593 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59594 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59595 = cljs.core.PersistentHashMap.fromArrays(inst_59593,inst_59594);
var inst_59596 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59592,inst_59595);
var inst_59597 = (function(){throw inst_59596})();
var state_59633__$1 = state_59633;
var statearr_59656_59695 = state_59633__$1;
(statearr_59656_59695[(2)] = inst_59597);

(statearr_59656_59695[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (2))){
var inst_59559 = (state_59633[(7)]);
var _ = (function (){var statearr_59657 = state_59633;
(statearr_59657[(4)] = cljs.core.cons((5),(state_59633[(4)])));

return statearr_59657;
})();
var inst_59558 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_59559__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59560 = fluree.db.util.core.current_time_millis();
var inst_59561 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_59633__$1 = (function (){var statearr_59658 = state_59633;
(statearr_59658[(9)] = inst_59560);

(statearr_59658[(15)] = inst_59561);

(statearr_59658[(7)] = inst_59559__$1);

(statearr_59658[(12)] = inst_59558);

return statearr_59658;
})();
if(cljs.core.truth_(inst_59559__$1)){
var statearr_59659_59696 = state_59633__$1;
(statearr_59659_59696[(1)] = (7));

} else {
var statearr_59660_59697 = state_59633__$1;
(statearr_59660_59697[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (23))){
var inst_59613 = (state_59633[(8)]);
var state_59633__$1 = state_59633;
var statearr_59661_59698 = state_59633__$1;
(statearr_59661_59698[(2)] = inst_59613);

(statearr_59661_59698[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (19))){
var inst_59599 = (state_59633[(13)]);
var state_59633__$1 = state_59633;
var statearr_59662_59699 = state_59633__$1;
(statearr_59662_59699[(2)] = inst_59599);

(statearr_59662_59699[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (11))){
var inst_59580 = (state_59633[(16)]);
var inst_59579 = (state_59633[(17)]);
var inst_59574 = (state_59633[(14)]);
var inst_59586 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_59574,inst_59579,inst_59580,opts);
var state_59633__$1 = state_59633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59633__$1,(14),inst_59586);
} else {
if((state_val_59634 === (9))){
var inst_59561 = (state_59633[(15)]);
var inst_59568 = (state_59633[(2)]);
var inst_59569 = [inst_59568];
var inst_59570 = cljs.core.PersistentHashMap.fromArrays(inst_59561,inst_59569);
var inst_59571 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_59570);
var state_59633__$1 = state_59633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59633__$1,(6),inst_59571);
} else {
if((state_val_59634 === (5))){
var _ = (function (){var statearr_59664 = state_59633;
(statearr_59664[(4)] = cljs.core.rest((state_59633[(4)])));

return statearr_59664;
})();
var state_59633__$1 = state_59633;
var ex59663 = (state_59633__$1[(2)]);
var statearr_59665_59700 = state_59633__$1;
(statearr_59665_59700[(5)] = ex59663);


if((ex59663 instanceof Error)){
var statearr_59666_59701 = state_59633__$1;
(statearr_59666_59701[(1)] = (4));

(statearr_59666_59701[(5)] = null);

} else {
throw ex59663;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (14))){
var inst_59588 = (state_59633[(2)]);
var inst_59589 = fluree.db.util.async.throw_err(inst_59588);
var state_59633__$1 = state_59633;
var statearr_59667_59702 = state_59633__$1;
(statearr_59667_59702[(2)] = inst_59589);

(statearr_59667_59702[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (26))){
var inst_59613 = (state_59633[(8)]);
var state_59633__$1 = state_59633;
var statearr_59668_59703 = state_59633__$1;
(statearr_59668_59703[(2)] = inst_59613);

(statearr_59668_59703[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (16))){
var inst_59558 = (state_59633[(12)]);
var inst_59603 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_59558);
var state_59633__$1 = state_59633;
var statearr_59669_59704 = state_59633__$1;
(statearr_59669_59704[(2)] = inst_59603);

(statearr_59669_59704[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (10))){
var inst_59558 = (state_59633[(12)]);
var inst_59577 = (state_59633[(2)]);
var inst_59578 = fluree.db.util.async.throw_err(inst_59577);
var inst_59579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59578,(0),null);
var inst_59580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59578,(1),null);
var inst_59581 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_59582 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_59558,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_59583 = cljs.core.keys(inst_59582);
var inst_59584 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_59581,inst_59583);
var state_59633__$1 = (function (){var statearr_59670 = state_59633;
(statearr_59670[(16)] = inst_59580);

(statearr_59670[(17)] = inst_59579);

return statearr_59670;
})();
if(inst_59584){
var statearr_59671_59705 = state_59633__$1;
(statearr_59671_59705[(1)] = (11));

} else {
var statearr_59672_59706 = state_59633__$1;
(statearr_59672_59706[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59634 === (18))){
var inst_59599 = (state_59633[(13)]);
var inst_59574 = (state_59633[(14)]);
var inst_59607 = fluree.db.api.query.format_blocks_resp_pretty(inst_59574,inst_59599);
var state_59633__$1 = state_59633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59633__$1,(21),inst_59607);
} else {
if((state_val_59634 === (8))){
var state_59633__$1 = state_59633;
var statearr_59673_59707 = state_59633__$1;
(statearr_59673_59707[(2)] = null);

(statearr_59673_59707[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_59674 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59674[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2733__auto__);

(statearr_59674[(1)] = (1));

return statearr_59674;
});
var fluree$db$api$query$block_query_async_$_state_machine__2733__auto____1 = (function (state_59633){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_59633);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e59675){var ex__2736__auto__ = e59675;
var statearr_59676_59708 = state_59633;
(statearr_59676_59708[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_59633[(4)]))){
var statearr_59677_59709 = state_59633;
(statearr_59677_59709[(1)] = cljs.core.first((state_59633[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59710 = state_59633;
state_59633 = G__59710;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2733__auto__ = function(state_59633){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2733__auto____1.call(this,state_59633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_59678 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_59678[(6)] = c__2755__auto__);

return statearr_59678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__59711 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59711,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59711,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59711,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59711,(3),null);
var vec__59714 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59714,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59714,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__59717 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59717,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59717,(1),null);
var or__4223__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4835__auto__ = [];
var len__4829__auto___59721 = arguments.length;
var i__4830__auto___59722 = (0);
while(true){
if((i__4830__auto___59722 < len__4829__auto___59721)){
args__4835__auto__.push((arguments[i__4830__auto___59722]));

var G__59723 = (i__4830__auto___59722 + (1));
i__4830__auto___59722 = G__59723;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq59720){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq59720));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_59919){
var state_val_59920 = (state_59919[(1)]);
if((state_val_59920 === (7))){
var inst_59846 = (state_59919[(7)]);
var inst_59839 = (state_59919[(8)]);
var inst_59845 = cljs.core.seq(inst_59839);
var inst_59846__$1 = cljs.core.first(inst_59845);
var inst_59847 = cljs.core.next(inst_59845);
var state_59919__$1 = (function (){var statearr_59921 = state_59919;
(statearr_59921[(9)] = inst_59847);

(statearr_59921[(7)] = inst_59846__$1);

return statearr_59921;
})();
if(cljs.core.truth_(inst_59846__$1)){
var statearr_59922_60022 = state_59919__$1;
(statearr_59922_60022[(1)] = (9));

} else {
var statearr_59923_60023 = state_59919__$1;
(statearr_59923_60023[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (20))){
var inst_59909 = (state_59919[(2)]);
var state_59919__$1 = state_59919;
var statearr_59924_60024 = state_59919__$1;
(statearr_59924_60024[(2)] = inst_59909);

(statearr_59924_60024[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (27))){
var inst_59885 = (state_59919[(10)]);
var inst_59867 = (state_59919[(11)]);
var inst_59864 = (state_59919[(12)]);
var inst_59887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59888 = [inst_59867,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_59889 = (new cljs.core.PersistentVector(null,2,(5),inst_59887,inst_59888,null));
var inst_59890 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_59885,inst_59889,fluree.db.api.query.min_safe,inst_59864);
var state_59919__$1 = state_59919;
var statearr_59925_60025 = state_59919__$1;
(statearr_59925_60025[(2)] = inst_59890);

(statearr_59925_60025[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (1))){
var state_59919__$1 = state_59919;
var statearr_59926_60026 = state_59919__$1;
(statearr_59926_60026[(2)] = null);

(statearr_59926_60026[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (24))){
var inst_59877 = (state_59919[(13)]);
var inst_59846 = (state_59919[(7)]);
var inst_59867 = (state_59919[(11)]);
var inst_59879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59880 = [inst_59867,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_59881 = (new cljs.core.PersistentVector(null,2,(5),inst_59879,inst_59880,null));
var inst_59882 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_59877,inst_59881,cljs.core.conj,inst_59846);
var state_59919__$1 = state_59919;
var statearr_59928_60027 = state_59919__$1;
(statearr_59928_60027[(2)] = inst_59882);

(statearr_59928_60027[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (4))){
var inst_59725 = (state_59919[(2)]);
var state_59919__$1 = state_59919;
var statearr_59929_60028 = state_59919__$1;
(statearr_59929_60028[(2)] = inst_59725);

(statearr_59929_60028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (15))){
var inst_59847 = (state_59919[(9)]);
var inst_59840 = (state_59919[(14)]);
var tmp59927 = inst_59840;
var inst_59839 = inst_59847;
var inst_59840__$1 = tmp59927;
var state_59919__$1 = (function (){var statearr_59930 = state_59919;
(statearr_59930[(14)] = inst_59840__$1);

(statearr_59930[(8)] = inst_59839);

return statearr_59930;
})();
var statearr_59931_60029 = state_59919__$1;
(statearr_59931_60029[(2)] = null);

(statearr_59931_60029[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (21))){
var inst_59840 = (state_59919[(14)]);
var inst_59867 = (state_59919[(11)]);
var inst_59871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59872 = [inst_59867,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_59873 = (new cljs.core.PersistentVector(null,2,(5),inst_59871,inst_59872,null));
var inst_59874 = cljs.core.assoc_in(inst_59840,inst_59873,inst_59867);
var state_59919__$1 = state_59919;
var statearr_59932_60030 = state_59919__$1;
(statearr_59932_60030[(2)] = inst_59874);

(statearr_59932_60030[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (31))){
var inst_59893 = (state_59919[(15)]);
var state_59919__$1 = state_59919;
var statearr_59933_60031 = state_59919__$1;
(statearr_59933_60031[(2)] = inst_59893);

(statearr_59933_60031[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (32))){
var inst_59847 = (state_59919[(9)]);
var inst_59901 = (state_59919[(2)]);
var inst_59839 = inst_59847;
var inst_59840 = inst_59901;
var state_59919__$1 = (function (){var statearr_59934 = state_59919;
(statearr_59934[(14)] = inst_59840);

(statearr_59934[(8)] = inst_59839);

return statearr_59934;
})();
var statearr_59935_60032 = state_59919__$1;
(statearr_59935_60032[(2)] = null);

(statearr_59935_60032[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (33))){
var inst_59840 = (state_59919[(14)]);
var state_59919__$1 = state_59919;
var statearr_59936_60033 = state_59919__$1;
(statearr_59936_60033[(2)] = inst_59840);

(statearr_59936_60033[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (13))){
var inst_59849 = (state_59919[(16)]);
var state_59919__$1 = state_59919;
var statearr_59937_60034 = state_59919__$1;
(statearr_59937_60034[(2)] = inst_59849);

(statearr_59937_60034[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (22))){
var inst_59840 = (state_59919[(14)]);
var state_59919__$1 = state_59919;
var statearr_59938_60035 = state_59919__$1;
(statearr_59938_60035[(2)] = inst_59840);

(statearr_59938_60035[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (29))){
var inst_59893 = (state_59919[(2)]);
var state_59919__$1 = (function (){var statearr_59939 = state_59919;
(statearr_59939[(15)] = inst_59893);

return statearr_59939;
})();
if(cljs.core.truth_(show_auth)){
var statearr_59940_60036 = state_59919__$1;
(statearr_59940_60036[(1)] = (30));

} else {
var statearr_59941_60037 = state_59919__$1;
(statearr_59941_60037[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (6))){
var inst_59825 = (state_59919[(2)]);
var inst_59826 = fluree.db.util.async.throw_err(inst_59825);
var inst_59834 = resp;
var inst_59835 = cljs.core.seq(inst_59834);
var inst_59836 = cljs.core.first(inst_59835);
var inst_59837 = cljs.core.next(inst_59835);
var inst_59838 = cljs.core.PersistentHashMap.EMPTY;
var inst_59839 = inst_59834;
var inst_59840 = inst_59838;
var state_59919__$1 = (function (){var statearr_59942 = state_59919;
(statearr_59942[(17)] = inst_59837);

(statearr_59942[(18)] = inst_59836);

(statearr_59942[(14)] = inst_59840);

(statearr_59942[(19)] = inst_59826);

(statearr_59942[(8)] = inst_59839);

return statearr_59942;
})();
var statearr_59943_60038 = state_59919__$1;
(statearr_59943_60038[(2)] = null);

(statearr_59943_60038[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (28))){
var inst_59885 = (state_59919[(10)]);
var state_59919__$1 = state_59919;
var statearr_59944_60039 = state_59919__$1;
(statearr_59944_60039[(2)] = inst_59885);

(statearr_59944_60039[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (25))){
var inst_59877 = (state_59919[(13)]);
var state_59919__$1 = state_59919;
var statearr_59945_60040 = state_59919__$1;
(statearr_59945_60040[(2)] = inst_59877);

(statearr_59945_60040[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (34))){
var state_59919__$1 = state_59919;
var statearr_59946_60041 = state_59919__$1;
(statearr_59946_60041[(2)] = null);

(statearr_59946_60041[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (17))){
var inst_59911 = (state_59919[(2)]);
var state_59919__$1 = state_59919;
var statearr_59947_60042 = state_59919__$1;
(statearr_59947_60042[(2)] = inst_59911);

(statearr_59947_60042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (3))){
var inst_59917 = (state_59919[(2)]);
var state_59919__$1 = state_59919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59919__$1,inst_59917);
} else {
if((state_val_59920 === (12))){
var inst_59846 = (state_59919[(7)]);
var inst_59826 = (state_59919[(19)]);
var inst_59851 = fluree.db.api.query.auth_match(auth,inst_59826,inst_59846);
var inst_59852 = cljs.core.not(inst_59851);
var state_59919__$1 = state_59919;
var statearr_59948_60043 = state_59919__$1;
(statearr_59948_60043[(2)] = inst_59852);

(statearr_59948_60043[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (2))){
var _ = (function (){var statearr_59949 = state_59919;
(statearr_59949[(4)] = cljs.core.cons((5),(state_59919[(4)])));

return statearr_59949;
})();
var inst_59731 = (function (){return (function (p1__59724_SHARP_){
return p1__59724_SHARP_.t;
});
})();
var inst_59732 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_59731,resp);
var inst_59733 = cljs.core.set(inst_59732);
var inst_59821 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_59822 = (function (){var ts = inst_59733;
var c__2755__auto____$1 = inst_59821;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_59819){
var state_val_59820 = (state_59819[(1)]);
if((state_val_59820 === (7))){
var inst_59753 = (state_59819[(7)]);
var inst_59765 = (state_59819[(8)]);
var inst_59747 = (state_59819[(9)]);
var inst_59759 = (state_59819[(10)]);
var inst_59758 = (state_59819[(2)]);
var inst_59759__$1 = fluree.db.util.async.throw_err(inst_59758);
var inst_59761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59762 = [inst_59753,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_59763 = (new cljs.core.PersistentVector(null,2,(5),inst_59761,inst_59762,null));
var inst_59764 = cljs.core.assoc_in(inst_59747,inst_59763,inst_59759__$1);
var inst_59765__$1 = auth;
var state_59819__$1 = (function (){var statearr_59950 = state_59819;
(statearr_59950[(11)] = inst_59764);

(statearr_59950[(8)] = inst_59765__$1);

(statearr_59950[(10)] = inst_59759__$1);

return statearr_59950;
})();
if(cljs.core.truth_(inst_59765__$1)){
var statearr_59951_60044 = state_59819__$1;
(statearr_59951_60044[(1)] = (8));

} else {
var statearr_59952_60045 = state_59819__$1;
(statearr_59952_60045[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (1))){
var inst_59741 = (state_59819[(12)]);
var inst_59741__$1 = ts;
var inst_59742 = cljs.core.seq(inst_59741__$1);
var inst_59743 = cljs.core.first(inst_59742);
var inst_59744 = cljs.core.next(inst_59742);
var inst_59745 = cljs.core.PersistentHashMap.EMPTY;
var inst_59746 = inst_59741__$1;
var inst_59747 = inst_59745;
var state_59819__$1 = (function (){var statearr_59953 = state_59819;
(statearr_59953[(13)] = inst_59744);

(statearr_59953[(9)] = inst_59747);

(statearr_59953[(14)] = inst_59746);

(statearr_59953[(15)] = inst_59743);

(statearr_59953[(12)] = inst_59741__$1);

return statearr_59953;
})();
var statearr_59954_60046 = state_59819__$1;
(statearr_59954_60046[(2)] = null);

(statearr_59954_60046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (4))){
var inst_59753 = (state_59819[(7)]);
var inst_59756 = fluree.db.time_travel.non_border_t_to_block(db,inst_59753);
var state_59819__$1 = state_59819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59819__$1,(7),inst_59756);
} else {
if((state_val_59820 === (13))){
var inst_59754 = (state_59819[(16)]);
var inst_59811 = (state_59819[(2)]);
var inst_59746 = inst_59754;
var inst_59747 = inst_59811;
var state_59819__$1 = (function (){var statearr_59955 = state_59819;
(statearr_59955[(9)] = inst_59747);

(statearr_59955[(14)] = inst_59746);

return statearr_59955;
})();
var statearr_59956_60047 = state_59819__$1;
(statearr_59956_60047[(2)] = null);

(statearr_59956_60047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (6))){
var inst_59815 = (state_59819[(2)]);
var state_59819__$1 = state_59819;
var statearr_59957_60048 = state_59819__$1;
(statearr_59957_60048[(2)] = inst_59815);

(statearr_59957_60048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (3))){
var inst_59817 = (state_59819[(2)]);
var state_59819__$1 = state_59819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59819__$1,inst_59817);
} else {
if((state_val_59820 === (12))){
var inst_59764 = (state_59819[(11)]);
var state_59819__$1 = state_59819;
var statearr_59958_60049 = state_59819__$1;
(statearr_59958_60049[(2)] = inst_59764);

(statearr_59958_60049[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (2))){
var inst_59753 = (state_59819[(7)]);
var inst_59746 = (state_59819[(14)]);
var inst_59752 = cljs.core.seq(inst_59746);
var inst_59753__$1 = cljs.core.first(inst_59752);
var inst_59754 = cljs.core.next(inst_59752);
var state_59819__$1 = (function (){var statearr_59959 = state_59819;
(statearr_59959[(16)] = inst_59754);

(statearr_59959[(7)] = inst_59753__$1);

return statearr_59959;
})();
if(cljs.core.truth_(inst_59753__$1)){
var statearr_59960_60050 = state_59819__$1;
(statearr_59960_60050[(1)] = (4));

} else {
var statearr_59961_60051 = state_59819__$1;
(statearr_59961_60051[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (11))){
var inst_59754 = (state_59819[(16)]);
var inst_59744 = (state_59819[(13)]);
var inst_59753 = (state_59819[(7)]);
var inst_59764 = (state_59819[(11)]);
var inst_59747 = (state_59819[(9)]);
var inst_59746 = (state_59819[(14)]);
var inst_59743 = (state_59819[(15)]);
var inst_59759 = (state_59819[(10)]);
var inst_59741 = (state_59819[(12)]);
var inst_59771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59772 = [inst_59753,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_59773 = (new cljs.core.PersistentVector(null,2,(5),inst_59771,inst_59772,null));
var inst_59786 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_59787 = (function (){var t = inst_59753;
var first__59740 = inst_59743;
var seq__59750 = inst_59754;
var seq__59739 = inst_59744;
var block = inst_59759;
var r = inst_59754;
var G__59737 = inst_59746;
var c__2755__auto____$2 = inst_59786;
var acc = inst_59747;
var first__59751 = inst_59753;
var vec__59738 = inst_59741;
var vec__59749 = inst_59746;
var G__59760 = inst_59764;
return (function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_59784){
var state_val_59785 = (state_59784[(1)]);
if((state_val_59785 === (1))){
var state_59784__$1 = state_59784;
var statearr_59962_60052 = state_59784__$1;
(statearr_59962_60052[(2)] = null);

(statearr_59962_60052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59785 === (2))){
var ___$1 = (function (){var statearr_59963 = state_59784;
(statearr_59963[(4)] = cljs.core.cons((5),(state_59784[(4)])));

return statearr_59963;
})();
var ___$2 = (function (){var statearr_59964 = state_59784;
(statearr_59964[(4)] = cljs.core.rest((state_59784[(4)])));

return statearr_59964;
})();
var state_59784__$1 = state_59784;
var statearr_59965_60053 = state_59784__$1;
(statearr_59965_60053[(2)] = db);

(statearr_59965_60053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59785 === (3))){
var inst_59782 = (state_59784[(2)]);
var state_59784__$1 = state_59784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59784__$1,inst_59782);
} else {
if((state_val_59785 === (4))){
var inst_59774 = (state_59784[(2)]);
var state_59784__$1 = state_59784;
var statearr_59967_60054 = state_59784__$1;
(statearr_59967_60054[(2)] = inst_59774);

(statearr_59967_60054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59785 === (5))){
var ___$1 = (function (){var statearr_59968 = state_59784;
(statearr_59968[(4)] = cljs.core.rest((state_59784[(4)])));

return statearr_59968;
})();
var state_59784__$1 = state_59784;
var ex59966 = (state_59784__$1[(2)]);
var statearr_59969_60055 = state_59784__$1;
(statearr_59969_60055[(5)] = ex59966);


if((ex59966 instanceof Error)){
var statearr_59970_60056 = state_59784__$1;
(statearr_59970_60056[(1)] = (4));

(statearr_59970_60056[(5)] = null);

} else {
throw ex59966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_59971 = [null,null,null,null,null,null,null];
(statearr_59971[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__);

(statearr_59971[(1)] = (1));

return statearr_59971;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1 = (function (state_59784){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_59784);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e59972){var ex__2736__auto__ = e59972;
var statearr_59973_60057 = state_59784;
(statearr_59973_60057[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_59784[(4)]))){
var statearr_59974_60058 = state_59784;
(statearr_59974_60058[(1)] = cljs.core.first((state_59784[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60059 = state_59784;
state_59784 = G__60059;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = function(state_59784){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1.call(this,state_59784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_59975 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_59975[(6)] = c__2755__auto____$2);

return statearr_59975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_59788 = cljs.core.async.impl.dispatch.run(inst_59787);
var inst_59789 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_59790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59791 = ["?auth","?id"];
var inst_59792 = (new cljs.core.PersistentVector(null,2,(5),inst_59790,inst_59791,null));
var inst_59793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59795 = [inst_59753,"_tx/auth","?auth"];
var inst_59796 = (new cljs.core.PersistentVector(null,3,(5),inst_59794,inst_59795,null));
var inst_59797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59798 = ["?auth","_auth/id","?id"];
var inst_59799 = (new cljs.core.PersistentVector(null,3,(5),inst_59797,inst_59798,null));
var inst_59800 = [inst_59796,inst_59799];
var inst_59801 = (new cljs.core.PersistentVector(null,2,(5),inst_59793,inst_59800,null));
var inst_59802 = [inst_59792,inst_59801];
var inst_59803 = cljs.core.PersistentHashMap.fromArrays(inst_59789,inst_59802);
var inst_59804 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_59786,inst_59803) : fluree.db.api.query.query_async.call(null,inst_59786,inst_59803));
var state_59819__$1 = (function (){var statearr_59976 = state_59819;
(statearr_59976[(17)] = inst_59773);

(statearr_59976[(18)] = inst_59788);

return statearr_59976;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59819__$1,(14),inst_59804);
} else {
if((state_val_59820 === (9))){
var state_59819__$1 = state_59819;
var statearr_59977_60060 = state_59819__$1;
(statearr_59977_60060[(2)] = show_auth);

(statearr_59977_60060[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (5))){
var inst_59747 = (state_59819[(9)]);
var state_59819__$1 = state_59819;
var statearr_59978_60061 = state_59819__$1;
(statearr_59978_60061[(2)] = inst_59747);

(statearr_59978_60061[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (14))){
var inst_59764 = (state_59819[(11)]);
var inst_59773 = (state_59819[(17)]);
var inst_59806 = (state_59819[(2)]);
var inst_59807 = fluree.db.util.async.throw_err(inst_59806);
var inst_59808 = cljs.core.assoc_in(inst_59764,inst_59773,inst_59807);
var state_59819__$1 = state_59819;
var statearr_59979_60062 = state_59819__$1;
(statearr_59979_60062[(2)] = inst_59808);

(statearr_59979_60062[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (10))){
var inst_59769 = (state_59819[(2)]);
var state_59819__$1 = state_59819;
if(cljs.core.truth_(inst_59769)){
var statearr_59980_60063 = state_59819__$1;
(statearr_59980_60063[(1)] = (11));

} else {
var statearr_59981_60064 = state_59819__$1;
(statearr_59981_60064[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59820 === (8))){
var inst_59765 = (state_59819[(8)]);
var state_59819__$1 = state_59819;
var statearr_59982_60065 = state_59819__$1;
(statearr_59982_60065[(2)] = inst_59765);

(statearr_59982_60065[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_59983 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59983[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__);

(statearr_59983[(1)] = (1));

return statearr_59983;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1 = (function (state_59819){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_59819);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e59984){var ex__2736__auto__ = e59984;
var statearr_59985_60066 = state_59819;
(statearr_59985_60066[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_59819[(4)]))){
var statearr_59986_60067 = state_59819;
(statearr_59986_60067[(1)] = cljs.core.first((state_59819[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60068 = state_59819;
state_59819 = G__60068;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = function(state_59819){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1.call(this,state_59819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_59987 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_59987[(6)] = c__2755__auto____$1);

return statearr_59987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
});
})();
var inst_59823 = cljs.core.async.impl.dispatch.run(inst_59822);
var state_59919__$1 = (function (){var statearr_59988 = state_59919;
(statearr_59988[(20)] = inst_59823);

return statearr_59988;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59919__$1,(6),inst_59821);
} else {
if((state_val_59920 === (23))){
var inst_59877 = (state_59919[(2)]);
var state_59919__$1 = (function (){var statearr_59989 = state_59919;
(statearr_59989[(13)] = inst_59877);

return statearr_59989;
})();
var statearr_59990_60069 = state_59919__$1;
(statearr_59990_60069[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (35))){
var inst_59907 = (state_59919[(2)]);
var state_59919__$1 = state_59919;
var statearr_59992_60070 = state_59919__$1;
(statearr_59992_60070[(2)] = inst_59907);

(statearr_59992_60070[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (19))){
var state_59919__$1 = state_59919;
var statearr_59993_60071 = state_59919__$1;
(statearr_59993_60071[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (11))){
var inst_59858 = (state_59919[(2)]);
var state_59919__$1 = state_59919;
if(cljs.core.truth_(inst_59858)){
var statearr_59996_60072 = state_59919__$1;
(statearr_59996_60072[(1)] = (15));

} else {
var statearr_59997_60073 = state_59919__$1;
(statearr_59997_60073[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (9))){
var inst_59849 = (state_59919[(16)]);
var inst_59849__$1 = auth;
var state_59919__$1 = (function (){var statearr_59998 = state_59919;
(statearr_59998[(16)] = inst_59849__$1);

return statearr_59998;
})();
if(cljs.core.truth_(inst_59849__$1)){
var statearr_59999_60074 = state_59919__$1;
(statearr_59999_60074[(1)] = (12));

} else {
var statearr_60000_60075 = state_59919__$1;
(statearr_60000_60075[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (5))){
var _ = (function (){var statearr_60001 = state_59919;
(statearr_60001[(4)] = cljs.core.rest((state_59919[(4)])));

return statearr_60001;
})();
var state_59919__$1 = state_59919;
var ex59995 = (state_59919__$1[(2)]);
var statearr_60002_60076 = state_59919__$1;
(statearr_60002_60076[(5)] = ex59995);


if((ex59995 instanceof Error)){
var statearr_60003_60077 = state_59919__$1;
(statearr_60003_60077[(1)] = (4));

(statearr_60003_60077[(5)] = null);

} else {
throw ex59995;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (14))){
var inst_59855 = (state_59919[(2)]);
var state_59919__$1 = state_59919;
var statearr_60004_60078 = state_59919__$1;
(statearr_60004_60078[(2)] = inst_59855);

(statearr_60004_60078[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (26))){
var inst_59885 = (state_59919[(2)]);
var state_59919__$1 = (function (){var statearr_60005 = state_59919;
(statearr_60005[(10)] = inst_59885);

return statearr_60005;
})();
var statearr_60006_60079 = state_59919__$1;
(statearr_60006_60079[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (16))){
var inst_59846 = (state_59919[(7)]);
var state_59919__$1 = state_59919;
if(cljs.core.truth_(inst_59846)){
var statearr_60008_60080 = state_59919__$1;
(statearr_60008_60080[(1)] = (18));

} else {
var statearr_60009_60081 = state_59919__$1;
(statearr_60009_60081[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (30))){
var inst_59893 = (state_59919[(15)]);
var inst_59868 = (state_59919[(21)]);
var inst_59867 = (state_59919[(11)]);
var inst_59895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59896 = [inst_59867,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_59897 = (new cljs.core.PersistentVector(null,2,(5),inst_59895,inst_59896,null));
var inst_59898 = cljs.core.assoc_in(inst_59893,inst_59897,inst_59868);
var state_59919__$1 = state_59919;
var statearr_60010_60082 = state_59919__$1;
(statearr_60010_60082[(2)] = inst_59898);

(statearr_60010_60082[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (10))){
var inst_59846 = (state_59919[(7)]);
var state_59919__$1 = state_59919;
var statearr_60011_60083 = state_59919__$1;
(statearr_60011_60083[(2)] = inst_59846);

(statearr_60011_60083[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (18))){
var inst_59846 = (state_59919[(7)]);
var inst_59826 = (state_59919[(19)]);
var inst_59864 = (state_59919[(12)]);
var inst_59864__$1 = inst_59846.t;
var inst_59865 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59826,inst_59864__$1);
var inst_59866 = cljs.core.__destructure_map(inst_59865);
var inst_59867 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59866,new cljs.core.Keyword(null,"block","block",664686210));
var inst_59868 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59866,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_59919__$1 = (function (){var statearr_60012 = state_59919;
(statearr_60012[(21)] = inst_59868);

(statearr_60012[(11)] = inst_59867);

(statearr_60012[(12)] = inst_59864__$1);

return statearr_60012;
})();
var statearr_60013_60084 = state_59919__$1;
(statearr_60013_60084[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59920 === (8))){
var inst_59913 = (state_59919[(2)]);
var inst_59914 = cljs.core.vals(inst_59913);
var _ = (function (){var statearr_60015 = state_59919;
(statearr_60015[(4)] = cljs.core.rest((state_59919[(4)])));

return statearr_60015;
})();
var state_59919__$1 = state_59919;
var statearr_60016_60085 = state_59919__$1;
(statearr_60016_60085[(2)] = inst_59914);

(statearr_60016_60085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0 = (function (){
var statearr_60017 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60017[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__);

(statearr_60017[(1)] = (1));

return statearr_60017;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1 = (function (state_59919){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_59919);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60018){var ex__2736__auto__ = e60018;
var statearr_60019_60086 = state_59919;
(statearr_60019_60086[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_59919[(4)]))){
var statearr_60020_60087 = state_59919;
(statearr_60020_60087[(1)] = cljs.core.first((state_59919[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60088 = state_59919;
state_59919 = G__60088;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__ = function(state_59919){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1.call(this,state_59919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2733__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60021 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60021[(6)] = c__2755__auto__);

return statearr_60021;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_60215){
var state_val_60216 = (state_60215[(1)]);
if((state_val_60216 === (7))){
var inst_60111 = (state_60215[(7)]);
var inst_60113 = fluree.db.api.query.resolve_block_range(inst_60111,query_map);
var state_60215__$1 = state_60215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60215__$1,(10),inst_60113);
} else {
if((state_val_60216 === (20))){
var inst_60140 = (state_60215[(2)]);
var inst_60141 = fluree.db.util.async.throw_err(inst_60140);
var inst_60142 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60141);
var inst_60143 = (inst_60142 - (1));
var state_60215__$1 = state_60215;
var statearr_60217_60280 = state_60215__$1;
(statearr_60217_60280[(2)] = inst_60143);

(statearr_60217_60280[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (27))){
var state_60215__$1 = state_60215;
var statearr_60218_60281 = state_60215__$1;
(statearr_60218_60281[(2)] = null);

(statearr_60218_60281[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (1))){
var state_60215__$1 = state_60215;
var statearr_60219_60282 = state_60215__$1;
(statearr_60219_60282[(2)] = null);

(statearr_60219_60282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (24))){
var inst_60150 = (state_60215[(2)]);
var inst_60151 = fluree.db.util.async.throw_err(inst_60150);
var inst_60152 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60151);
var state_60215__$1 = state_60215;
var statearr_60220_60283 = state_60215__$1;
(statearr_60220_60283[(2)] = inst_60152);

(statearr_60220_60283[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (39))){
var inst_60187 = (state_60215[(2)]);
var inst_60188 = fluree.db.util.async.throw_err(inst_60187);
var state_60215__$1 = state_60215;
var statearr_60221_60284 = state_60215__$1;
(statearr_60221_60284[(2)] = inst_60188);

(statearr_60221_60284[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (4))){
var inst_60089 = (state_60215[(2)]);
var state_60215__$1 = state_60215;
var statearr_60222_60285 = state_60215__$1;
(statearr_60222_60285[(2)] = inst_60089);

(statearr_60222_60285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (15))){
var inst_60120 = (state_60215[(8)]);
var state_60215__$1 = state_60215;
var statearr_60223_60286 = state_60215__$1;
(statearr_60223_60286[(2)] = inst_60120);

(statearr_60223_60286[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (21))){
var inst_60111 = (state_60215[(7)]);
var inst_60121 = (state_60215[(9)]);
var inst_60148 = fluree.db.time_travel.as_of_block(inst_60111,inst_60121);
var state_60215__$1 = state_60215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60215__$1,(24),inst_60148);
} else {
if((state_val_60216 === (31))){
var inst_60105 = (state_60215[(10)]);
var state_60215__$1 = state_60215;
var statearr_60224_60287 = state_60215__$1;
(statearr_60224_60287[(2)] = inst_60105);

(statearr_60224_60287[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (32))){
var inst_60171 = (state_60215[(11)]);
var inst_60111 = (state_60215[(7)]);
var inst_60166 = (state_60215[(12)]);
var inst_60175 = (state_60215[(2)]);
var inst_60176 = fluree.db.api.query.format_history_resp(inst_60111,inst_60166,inst_60171,inst_60175);
var state_60215__$1 = state_60215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60215__$1,(29),inst_60176);
} else {
if((state_val_60216 === (40))){
var inst_60166 = (state_60215[(12)]);
var inst_60192 = (state_60215[(13)]);
var inst_60194 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_60195 = cljs.core.count(inst_60166);
var inst_60196 = [inst_60192,inst_60195,(200)];
var inst_60197 = cljs.core.PersistentHashMap.fromArrays(inst_60194,inst_60196);
var state_60215__$1 = state_60215;
var statearr_60225_60288 = state_60215__$1;
(statearr_60225_60288[(2)] = inst_60197);

(statearr_60225_60288[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (33))){
var inst_60104 = (state_60215[(14)]);
var state_60215__$1 = state_60215;
var statearr_60226_60289 = state_60215__$1;
(statearr_60226_60289[(2)] = inst_60104);

(statearr_60226_60289[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (13))){
var inst_60210 = (state_60215[(2)]);
var _ = (function (){var statearr_60227 = state_60215;
(statearr_60227[(4)] = cljs.core.rest((state_60215[(4)])));

return statearr_60227;
})();
var state_60215__$1 = state_60215;
var statearr_60228_60290 = state_60215__$1;
(statearr_60228_60290[(2)] = inst_60210);

(statearr_60228_60290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (22))){
var inst_60111 = (state_60215[(7)]);
var inst_60154 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60111);
var state_60215__$1 = state_60215;
var statearr_60229_60291 = state_60215__$1;
(statearr_60229_60291[(2)] = inst_60154);

(statearr_60229_60291[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (36))){
var inst_60111 = (state_60215[(7)]);
var inst_60179 = (state_60215[(15)]);
var inst_60185 = fluree.db.api.query.format_blocks_resp_pretty(inst_60111,inst_60179);
var state_60215__$1 = state_60215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60215__$1,(39),inst_60185);
} else {
if((state_val_60216 === (41))){
var inst_60192 = (state_60215[(13)]);
var state_60215__$1 = state_60215;
var statearr_60230_60292 = state_60215__$1;
(statearr_60230_60292[(2)] = inst_60192);

(statearr_60230_60292[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (29))){
var inst_60104 = (state_60215[(14)]);
var inst_60178 = (state_60215[(2)]);
var inst_60179 = fluree.db.util.async.throw_err(inst_60178);
var state_60215__$1 = (function (){var statearr_60231 = state_60215;
(statearr_60231[(15)] = inst_60179);

return statearr_60231;
})();
if(cljs.core.truth_(inst_60104)){
var statearr_60232_60293 = state_60215__$1;
(statearr_60232_60293[(1)] = (33));

} else {
var statearr_60233_60294 = state_60215__$1;
(statearr_60233_60294[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (6))){
var inst_60101 = (state_60215[(16)]);
var inst_60110 = (state_60215[(2)]);
var inst_60111 = fluree.db.util.async.throw_err(inst_60110);
var state_60215__$1 = (function (){var statearr_60234 = state_60215;
(statearr_60234[(7)] = inst_60111);

return statearr_60234;
})();
if(cljs.core.truth_(inst_60101)){
var statearr_60235_60295 = state_60215__$1;
(statearr_60235_60295[(1)] = (7));

} else {
var statearr_60236_60296 = state_60215__$1;
(statearr_60236_60296[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (28))){
var inst_60106 = (state_60215[(17)]);
var inst_60171 = (state_60215[(2)]);
var state_60215__$1 = (function (){var statearr_60237 = state_60215;
(statearr_60237[(11)] = inst_60171);

return statearr_60237;
})();
if(cljs.core.truth_(inst_60106)){
var statearr_60238_60297 = state_60215__$1;
(statearr_60238_60297[(1)] = (30));

} else {
var statearr_60239_60298 = state_60215__$1;
(statearr_60239_60298[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (25))){
var inst_60107 = (state_60215[(18)]);
var inst_60165 = (state_60215[(2)]);
var inst_60166 = fluree.db.util.async.throw_err(inst_60165);
var state_60215__$1 = (function (){var statearr_60240 = state_60215;
(statearr_60240[(12)] = inst_60166);

return statearr_60240;
})();
if(cljs.core.truth_(inst_60107)){
var statearr_60241_60299 = state_60215__$1;
(statearr_60241_60299[(1)] = (26));

} else {
var statearr_60242_60300 = state_60215__$1;
(statearr_60242_60300[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (34))){
var inst_60103 = (state_60215[(19)]);
var state_60215__$1 = state_60215;
var statearr_60243_60301 = state_60215__$1;
(statearr_60243_60301[(2)] = inst_60103);

(statearr_60243_60301[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (17))){
var inst_60111 = (state_60215[(7)]);
var inst_60120 = (state_60215[(8)]);
var inst_60137 = (inst_60120 - (1));
var inst_60138 = fluree.db.time_travel.as_of_block(inst_60111,inst_60137);
var state_60215__$1 = state_60215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60215__$1,(20),inst_60138);
} else {
if((state_val_60216 === (3))){
var inst_60213 = (state_60215[(2)]);
var state_60215__$1 = state_60215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60215__$1,inst_60213);
} else {
if((state_val_60216 === (12))){
var inst_60202 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_60203 = ["History query not properly formatted. Provided ",inst_60202].join('');
var inst_60204 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60205 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60206 = cljs.core.PersistentHashMap.fromArrays(inst_60204,inst_60205);
var inst_60207 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60203,inst_60206);
var inst_60208 = (function(){throw inst_60207})();
var state_60215__$1 = state_60215;
var statearr_60244_60302 = state_60215__$1;
(statearr_60244_60302[(2)] = inst_60208);

(statearr_60244_60302[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (2))){
var _ = (function (){var statearr_60245 = state_60215;
(statearr_60245[(4)] = cljs.core.cons((5),(state_60215[(4)])));

return statearr_60245;
})();
var inst_60099 = query_map;
var inst_60100 = cljs.core.__destructure_map(inst_60099);
var inst_60101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60108 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60100,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_60215__$1 = (function (){var statearr_60246 = state_60215;
(statearr_60246[(19)] = inst_60103);

(statearr_60246[(16)] = inst_60101);

(statearr_60246[(14)] = inst_60104);

(statearr_60246[(20)] = inst_60102);

(statearr_60246[(21)] = inst_60108);

(statearr_60246[(10)] = inst_60105);

(statearr_60246[(18)] = inst_60107);

(statearr_60246[(17)] = inst_60106);

return statearr_60246;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60215__$1,(6),sources);
} else {
if((state_val_60216 === (23))){
var inst_60111 = (state_60215[(7)]);
var inst_60102 = (state_60215[(20)]);
var inst_60146 = (state_60215[(22)]);
var inst_60156 = (state_60215[(2)]);
var inst_60157 = fluree.db.api.query.get_history_pattern(inst_60102);
var inst_60158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60157,(0),null);
var inst_60159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60157,(1),null);
var inst_60160 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60161 = [inst_60146,inst_60156];
var inst_60162 = cljs.core.PersistentHashMap.fromArrays(inst_60160,inst_60161);
var inst_60163 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_60111,inst_60159,cljs.core._EQ_,inst_60158,inst_60162);
var state_60215__$1 = state_60215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60215__$1,(25),inst_60163);
} else {
if((state_val_60216 === (35))){
var inst_60183 = (state_60215[(2)]);
var state_60215__$1 = state_60215;
if(cljs.core.truth_(inst_60183)){
var statearr_60247_60303 = state_60215__$1;
(statearr_60247_60303[(1)] = (36));

} else {
var statearr_60248_60304 = state_60215__$1;
(statearr_60248_60304[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (19))){
var inst_60121 = (state_60215[(9)]);
var inst_60146 = (state_60215[(2)]);
var state_60215__$1 = (function (){var statearr_60249 = state_60215;
(statearr_60249[(22)] = inst_60146);

return statearr_60249;
})();
if(cljs.core.truth_(inst_60121)){
var statearr_60250_60305 = state_60215__$1;
(statearr_60250_60305[(1)] = (21));

} else {
var statearr_60251_60306 = state_60215__$1;
(statearr_60251_60306[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (11))){
var inst_60120 = (state_60215[(8)]);
var inst_60108 = (state_60215[(21)]);
var inst_60130 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60108);
var state_60215__$1 = (function (){var statearr_60253 = state_60215;
(statearr_60253[(23)] = inst_60130);

return statearr_60253;
})();
if(cljs.core.truth_(inst_60120)){
var statearr_60254_60307 = state_60215__$1;
(statearr_60254_60307[(1)] = (14));

} else {
var statearr_60255_60308 = state_60215__$1;
(statearr_60255_60308[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (9))){
var inst_60119 = (state_60215[(2)]);
var inst_60120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60119,(0),null);
var inst_60121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60119,(1),null);
var inst_60122 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60123 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_60124 = cljs.core.keys(inst_60123);
var inst_60125 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60122,inst_60124);
var state_60215__$1 = (function (){var statearr_60256 = state_60215;
(statearr_60256[(9)] = inst_60121);

(statearr_60256[(8)] = inst_60120);

return statearr_60256;
})();
if(inst_60125){
var statearr_60257_60309 = state_60215__$1;
(statearr_60257_60309[(1)] = (11));

} else {
var statearr_60258_60310 = state_60215__$1;
(statearr_60258_60310[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (5))){
var _ = (function (){var statearr_60259 = state_60215;
(statearr_60259[(4)] = cljs.core.rest((state_60215[(4)])));

return statearr_60259;
})();
var state_60215__$1 = state_60215;
var ex60252 = (state_60215__$1[(2)]);
var statearr_60260_60311 = state_60215__$1;
(statearr_60260_60311[(5)] = ex60252);


if((ex60252 instanceof Error)){
var statearr_60261_60312 = state_60215__$1;
(statearr_60261_60312[(1)] = (4));

(statearr_60261_60312[(5)] = null);

} else {
throw ex60252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (14))){
var inst_60120 = (state_60215[(8)]);
var inst_60132 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_60120);
var state_60215__$1 = state_60215;
var statearr_60262_60313 = state_60215__$1;
(statearr_60262_60313[(2)] = inst_60132);

(statearr_60262_60313[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (26))){
var inst_60107 = (state_60215[(18)]);
var inst_60168 = cljs.core.set(inst_60107);
var state_60215__$1 = state_60215;
var statearr_60263_60314 = state_60215__$1;
(statearr_60263_60314[(2)] = inst_60168);

(statearr_60263_60314[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (16))){
var inst_60135 = (state_60215[(2)]);
var state_60215__$1 = state_60215;
if(cljs.core.truth_(inst_60135)){
var statearr_60264_60315 = state_60215__$1;
(statearr_60264_60315[(1)] = (17));

} else {
var statearr_60265_60316 = state_60215__$1;
(statearr_60265_60316[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (38))){
var inst_60130 = (state_60215[(23)]);
var inst_60192 = (state_60215[(2)]);
var state_60215__$1 = (function (){var statearr_60266 = state_60215;
(statearr_60266[(13)] = inst_60192);

return statearr_60266;
})();
if(cljs.core.truth_(inst_60130)){
var statearr_60267_60317 = state_60215__$1;
(statearr_60267_60317[(1)] = (40));

} else {
var statearr_60268_60318 = state_60215__$1;
(statearr_60268_60318[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (30))){
var inst_60106 = (state_60215[(17)]);
var state_60215__$1 = state_60215;
var statearr_60269_60319 = state_60215__$1;
(statearr_60269_60319[(2)] = inst_60106);

(statearr_60269_60319[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (10))){
var inst_60115 = (state_60215[(2)]);
var inst_60116 = fluree.db.util.async.throw_err(inst_60115);
var state_60215__$1 = state_60215;
var statearr_60270_60320 = state_60215__$1;
(statearr_60270_60320[(2)] = inst_60116);

(statearr_60270_60320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (18))){
var state_60215__$1 = state_60215;
var statearr_60271_60321 = state_60215__$1;
(statearr_60271_60321[(2)] = (-1));

(statearr_60271_60321[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (42))){
var inst_60200 = (state_60215[(2)]);
var state_60215__$1 = state_60215;
var statearr_60272_60322 = state_60215__$1;
(statearr_60272_60322[(2)] = inst_60200);

(statearr_60272_60322[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (37))){
var inst_60179 = (state_60215[(15)]);
var inst_60190 = fluree.db.api.query.block_Flakes__GT_vector(inst_60179);
var state_60215__$1 = state_60215;
var statearr_60273_60323 = state_60215__$1;
(statearr_60273_60323[(2)] = inst_60190);

(statearr_60273_60323[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60216 === (8))){
var state_60215__$1 = state_60215;
var statearr_60274_60324 = state_60215__$1;
(statearr_60274_60324[(2)] = null);

(statearr_60274_60324[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_60275 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60275[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2733__auto__);

(statearr_60275[(1)] = (1));

return statearr_60275;
});
var fluree$db$api$query$history_query_async_$_state_machine__2733__auto____1 = (function (state_60215){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_60215);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60276){var ex__2736__auto__ = e60276;
var statearr_60277_60325 = state_60215;
(statearr_60277_60325[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_60215[(4)]))){
var statearr_60278_60326 = state_60215;
(statearr_60278_60326[(1)] = cljs.core.first((state_60215[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60327 = state_60215;
state_60215 = G__60327;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2733__auto__ = function(state_60215){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2733__auto____1.call(this,state_60215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60279 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60279[(6)] = c__2755__auto__);

return statearr_60279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_60460){
var state_val_60461 = (state_60460[(1)]);
if((state_val_60461 === (7))){
var inst_60357 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_60358 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_60357].join('');
var inst_60359 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60360 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60361 = cljs.core.PersistentHashMap.fromArrays(inst_60359,inst_60360);
var inst_60362 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60358,inst_60361);
var inst_60363 = (function(){throw inst_60362})();
var state_60460__$1 = state_60460;
var statearr_60462_60541 = state_60460__$1;
(statearr_60462_60541[(2)] = inst_60363);

(statearr_60462_60541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (20))){
var inst_60395 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
if(cljs.core.truth_(inst_60395)){
var statearr_60463_60542 = state_60460__$1;
(statearr_60463_60542[(1)] = (21));

} else {
var statearr_60464_60543 = state_60460__$1;
(statearr_60464_60543[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (27))){
var inst_60339 = (state_60460[(7)]);
var state_60460__$1 = state_60460;
var statearr_60465_60544 = state_60460__$1;
(statearr_60465_60544[(2)] = inst_60339);

(statearr_60465_60544[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (1))){
var state_60460__$1 = state_60460;
var statearr_60466_60545 = state_60460__$1;
(statearr_60466_60545[(2)] = null);

(statearr_60466_60545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (24))){
var inst_60401 = (state_60460[(8)]);
var state_60460__$1 = state_60460;
var statearr_60467_60546 = state_60460__$1;
(statearr_60467_60546[(2)] = inst_60401);

(statearr_60467_60546[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (39))){
var inst_60345 = (state_60460[(9)]);
var state_60460__$1 = state_60460;
if(cljs.core.truth_(inst_60345)){
var statearr_60468_60547 = state_60460__$1;
(statearr_60468_60547[(1)] = (42));

} else {
var statearr_60469_60548 = state_60460__$1;
(statearr_60469_60548[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (46))){
var inst_60433 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60434 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60435 = cljs.core.PersistentHashMap.fromArrays(inst_60433,inst_60434);
var inst_60436 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_60435);
var inst_60437 = (function(){throw inst_60436})();
var state_60460__$1 = state_60460;
var statearr_60470_60549 = state_60460__$1;
(statearr_60470_60549[(2)] = inst_60437);

(statearr_60470_60549[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (4))){
var inst_60329 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
var statearr_60471_60550 = state_60460__$1;
(statearr_60471_60550[(2)] = inst_60329);

(statearr_60471_60550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (15))){
var inst_60342 = (state_60460[(10)]);
var inst_60380 = (state_60460[(11)]);
var inst_60382 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_60380);
var inst_60383 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_60380);
var inst_60384 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_60380);
var inst_60385 = fluree.db.api.query.get_sources(inst_60382,inst_60383,inst_60384,inst_60342);
var state_60460__$1 = state_60460;
var statearr_60472_60551 = state_60460__$1;
(statearr_60472_60551[(2)] = inst_60385);

(statearr_60472_60551[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (48))){
var inst_60390 = (state_60460[(12)]);
var inst_60444 = (state_60460[(2)]);
var inst_60445 = fluree.db.util.async.throw_err(inst_60444);
var state_60460__$1 = (function (){var statearr_60473 = state_60460;
(statearr_60473[(13)] = inst_60445);

return statearr_60473;
})();
if(cljs.core.truth_(inst_60390)){
var statearr_60474_60552 = state_60460__$1;
(statearr_60474_60552[(1)] = (49));

} else {
var statearr_60475_60553 = state_60460__$1;
(statearr_60475_60553[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (50))){
var inst_60445 = (state_60460[(13)]);
var state_60460__$1 = state_60460;
var statearr_60476_60554 = state_60460__$1;
(statearr_60476_60554[(2)] = inst_60445);

(statearr_60476_60554[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (21))){
var inst_60397 = cljs.core.volatile_BANG_((0));
var state_60460__$1 = state_60460;
var statearr_60477_60555 = state_60460__$1;
(statearr_60477_60555[(2)] = inst_60397);

(statearr_60477_60555[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (31))){
var inst_60343 = (state_60460[(14)]);
var state_60460__$1 = state_60460;
if(cljs.core.truth_(inst_60343)){
var statearr_60478_60556 = state_60460__$1;
(statearr_60478_60556[(1)] = (33));

} else {
var statearr_60479_60557 = state_60460__$1;
(statearr_60479_60557[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (32))){
var inst_60420 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
var statearr_60480_60558 = state_60460__$1;
(statearr_60480_60558[(2)] = inst_60420);

(statearr_60480_60558[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (40))){
var inst_60422 = (state_60460[(15)]);
var state_60460__$1 = state_60460;
var statearr_60481_60559 = state_60460__$1;
(statearr_60481_60559[(2)] = inst_60422);

(statearr_60481_60559[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (33))){
var inst_60343 = (state_60460[(14)]);
var state_60460__$1 = state_60460;
var statearr_60482_60560 = state_60460__$1;
(statearr_60482_60560[(2)] = inst_60343);

(statearr_60482_60560[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (13))){
var inst_60340 = (state_60460[(16)]);
var inst_60369 = (state_60460[(2)]);
var inst_60370 = fluree.db.util.async.throw_err(inst_60369);
var inst_60371 = fluree.db.time_travel.as_of_block(inst_60370,inst_60340);
var state_60460__$1 = state_60460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60460__$1,(12),inst_60371);
} else {
if((state_val_60461 === (22))){
var state_60460__$1 = state_60460;
var statearr_60483_60561 = state_60460__$1;
(statearr_60483_60561[(2)] = null);

(statearr_60483_60561[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (36))){
var inst_60347 = (state_60460[(17)]);
var state_60460__$1 = state_60460;
var statearr_60484_60562 = state_60460__$1;
(statearr_60484_60562[(2)] = inst_60347);

(statearr_60484_60562[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (41))){
var inst_60430 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
if(cljs.core.truth_(inst_60430)){
var statearr_60485_60563 = state_60460__$1;
(statearr_60485_60563[(1)] = (45));

} else {
var statearr_60486_60564 = state_60460__$1;
(statearr_60486_60564[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (43))){
var inst_60341 = (state_60460[(18)]);
var state_60460__$1 = state_60460;
var statearr_60487_60565 = state_60460__$1;
(statearr_60487_60565[(2)] = inst_60341);

(statearr_60487_60565[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (29))){
var inst_60422 = (state_60460[(15)]);
var inst_60422__$1 = (state_60460[(2)]);
var state_60460__$1 = (function (){var statearr_60488 = state_60460;
(statearr_60488[(15)] = inst_60422__$1);

return statearr_60488;
})();
if(cljs.core.truth_(inst_60422__$1)){
var statearr_60489_60566 = state_60460__$1;
(statearr_60489_60566[(1)] = (39));

} else {
var statearr_60490_60567 = state_60460__$1;
(statearr_60490_60567[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (44))){
var inst_60427 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
var statearr_60491_60568 = state_60460__$1;
(statearr_60491_60568[(2)] = inst_60427);

(statearr_60491_60568[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (6))){
var state_60460__$1 = state_60460;
var statearr_60492_60569 = state_60460__$1;
(statearr_60492_60569[(2)] = null);

(statearr_60492_60569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (28))){
var inst_60344 = (state_60460[(19)]);
var state_60460__$1 = state_60460;
if(cljs.core.truth_(inst_60344)){
var statearr_60493_60570 = state_60460__$1;
(statearr_60493_60570[(1)] = (30));

} else {
var statearr_60494_60571 = state_60460__$1;
(statearr_60494_60571[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (51))){
var inst_60455 = (state_60460[(2)]);
var _ = (function (){var statearr_60495 = state_60460;
(statearr_60495[(4)] = cljs.core.rest((state_60460[(4)])));

return statearr_60495;
})();
var state_60460__$1 = state_60460;
var statearr_60496_60572 = state_60460__$1;
(statearr_60496_60572[(2)] = inst_60455);

(statearr_60496_60572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (25))){
var state_60460__$1 = state_60460;
var statearr_60497_60573 = state_60460__$1;
(statearr_60497_60573[(2)] = (1000000));

(statearr_60497_60573[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (34))){
var inst_60347 = (state_60460[(17)]);
var state_60460__$1 = state_60460;
if(cljs.core.truth_(inst_60347)){
var statearr_60498_60574 = state_60460__$1;
(statearr_60498_60574[(1)] = (36));

} else {
var statearr_60499_60575 = state_60460__$1;
(statearr_60499_60575[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (17))){
var inst_60391 = (state_60460[(20)]);
var inst_60346 = (state_60460[(21)]);
var inst_60389 = (state_60460[(2)]);
var inst_60390 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60346);
var inst_60391__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60346);
var state_60460__$1 = (function (){var statearr_60500 = state_60460;
(statearr_60500[(20)] = inst_60391__$1);

(statearr_60500[(12)] = inst_60390);

(statearr_60500[(22)] = inst_60389);

return statearr_60500;
})();
if(cljs.core.truth_(inst_60391__$1)){
var statearr_60501_60576 = state_60460__$1;
(statearr_60501_60576[(1)] = (18));

} else {
var statearr_60502_60577 = state_60460__$1;
(statearr_60502_60577[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (3))){
var inst_60458 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60460__$1,inst_60458);
} else {
if((state_val_60461 === (12))){
var inst_60373 = (state_60460[(2)]);
var inst_60374 = fluree.db.util.async.throw_err(inst_60373);
var state_60460__$1 = state_60460;
var statearr_60503_60578 = state_60460__$1;
(statearr_60503_60578[(2)] = inst_60374);

(statearr_60503_60578[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (2))){
var inst_60339 = (state_60460[(7)]);
var inst_60338 = (state_60460[(23)]);
var inst_60347 = (state_60460[(17)]);
var inst_60344 = (state_60460[(19)]);
var inst_60343 = (state_60460[(14)]);
var inst_60342 = (state_60460[(10)]);
var inst_60346 = (state_60460[(21)]);
var inst_60341 = (state_60460[(18)]);
var inst_60345 = (state_60460[(9)]);
var inst_60340 = (state_60460[(16)]);
var _ = (function (){var statearr_60504 = state_60460;
(statearr_60504[(4)] = cljs.core.cons((5),(state_60460[(4)])));

return statearr_60504;
})();
var inst_60336 = flureeQL;
var inst_60337 = cljs.core.__destructure_map(inst_60336);
var inst_60338__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_60339__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_60340__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60341__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_60342__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_60343__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_60344__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_60345__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_60346__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60347__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60337,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_60348 = (function (){var construct = inst_60338__$1;
var select = inst_60339__$1;
var block = inst_60340__$1;
var where = inst_60341__$1;
var prefixes = inst_60342__$1;
var selectDistinct = inst_60343__$1;
var selectOne = inst_60344__$1;
var from = inst_60345__$1;
var map__60335 = inst_60337;
var opts = inst_60346__$1;
var selectReduced = inst_60347__$1;
return (function (p1__60328_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__60328_SHARP_);
});
})();
var inst_60349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60350 = [inst_60339__$1,inst_60344__$1,inst_60343__$1,inst_60347__$1];
var inst_60351 = (new cljs.core.PersistentVector(null,4,(5),inst_60349,inst_60350,null));
var inst_60352 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_60351);
var inst_60353 = cljs.core.count(inst_60352);
var inst_60354 = (inst_60348.cljs$core$IFn$_invoke$arity$1 ? inst_60348.cljs$core$IFn$_invoke$arity$1(inst_60353) : inst_60348.call(null,inst_60353));
var state_60460__$1 = (function (){var statearr_60505 = state_60460;
(statearr_60505[(7)] = inst_60339__$1);

(statearr_60505[(23)] = inst_60338__$1);

(statearr_60505[(17)] = inst_60347__$1);

(statearr_60505[(19)] = inst_60344__$1);

(statearr_60505[(14)] = inst_60343__$1);

(statearr_60505[(10)] = inst_60342__$1);

(statearr_60505[(21)] = inst_60346__$1);

(statearr_60505[(18)] = inst_60341__$1);

(statearr_60505[(9)] = inst_60345__$1);

(statearr_60505[(16)] = inst_60340__$1);

return statearr_60505;
})();
if(cljs.core.truth_(inst_60354)){
var statearr_60506_60579 = state_60460__$1;
(statearr_60506_60579[(1)] = (6));

} else {
var statearr_60507_60580 = state_60460__$1;
(statearr_60507_60580[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (23))){
var inst_60346 = (state_60460[(21)]);
var inst_60401 = (state_60460[(8)]);
var inst_60400 = (state_60460[(2)]);
var inst_60401__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60346);
var state_60460__$1 = (function (){var statearr_60508 = state_60460;
(statearr_60508[(8)] = inst_60401__$1);

(statearr_60508[(24)] = inst_60400);

return statearr_60508;
})();
if(cljs.core.truth_(inst_60401__$1)){
var statearr_60509_60581 = state_60460__$1;
(statearr_60509_60581[(1)] = (24));

} else {
var statearr_60510_60582 = state_60460__$1;
(statearr_60510_60582[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (47))){
var inst_60406 = (state_60460[(25)]);
var inst_60380 = (state_60460[(11)]);
var inst_60439 = (state_60460[(2)]);
var inst_60440 = fluree.db.util.core.current_time_millis();
var inst_60441 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_60406);
var inst_60442 = fluree.db.query.fql.query(inst_60380,inst_60441);
var state_60460__$1 = (function (){var statearr_60511 = state_60460;
(statearr_60511[(26)] = inst_60439);

(statearr_60511[(27)] = inst_60440);

return statearr_60511;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60460__$1,(48),inst_60442);
} else {
if((state_val_60461 === (35))){
var inst_60418 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
var statearr_60512_60583 = state_60460__$1;
(statearr_60512_60583[(2)] = inst_60418);

(statearr_60512_60583[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (19))){
var inst_60390 = (state_60460[(12)]);
var state_60460__$1 = state_60460;
var statearr_60513_60584 = state_60460__$1;
(statearr_60513_60584[(2)] = inst_60390);

(statearr_60513_60584[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (11))){
var inst_60342 = (state_60460[(10)]);
var inst_60380 = (state_60460[(2)]);
var state_60460__$1 = (function (){var statearr_60515 = state_60460;
(statearr_60515[(11)] = inst_60380);

return statearr_60515;
})();
if(cljs.core.truth_(inst_60342)){
var statearr_60516_60585 = state_60460__$1;
(statearr_60516_60585[(1)] = (15));

} else {
var statearr_60517_60586 = state_60460__$1;
(statearr_60517_60586[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (9))){
var inst_60366 = (state_60460[(28)]);
var state_60460__$1 = state_60460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60460__$1,(13),inst_60366);
} else {
if((state_val_60461 === (5))){
var _ = (function (){var statearr_60518 = state_60460;
(statearr_60518[(4)] = cljs.core.rest((state_60460[(4)])));

return statearr_60518;
})();
var state_60460__$1 = state_60460;
var ex60514 = (state_60460__$1[(2)]);
var statearr_60519_60587 = state_60460__$1;
(statearr_60519_60587[(5)] = ex60514);


if((ex60514 instanceof Error)){
var statearr_60520_60588 = state_60460__$1;
(statearr_60520_60588[(1)] = (4));

(statearr_60520_60588[(5)] = null);

} else {
throw ex60514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (14))){
var inst_60377 = (state_60460[(2)]);
var inst_60378 = fluree.db.util.async.throw_err(inst_60377);
var state_60460__$1 = state_60460;
var statearr_60521_60589 = state_60460__$1;
(statearr_60521_60589[(2)] = inst_60378);

(statearr_60521_60589[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (45))){
var state_60460__$1 = state_60460;
var statearr_60522_60590 = state_60460__$1;
(statearr_60522_60590[(2)] = null);

(statearr_60522_60590[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (26))){
var inst_60339 = (state_60460[(7)]);
var inst_60346 = (state_60460[(21)]);
var inst_60400 = (state_60460[(24)]);
var inst_60389 = (state_60460[(22)]);
var inst_60405 = (state_60460[(2)]);
var inst_60406 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_60346,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_60389,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_60405,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_60400], 0));
var state_60460__$1 = (function (){var statearr_60523 = state_60460;
(statearr_60523[(25)] = inst_60406);

return statearr_60523;
})();
if(cljs.core.truth_(inst_60339)){
var statearr_60524_60591 = state_60460__$1;
(statearr_60524_60591[(1)] = (27));

} else {
var statearr_60525_60592 = state_60460__$1;
(statearr_60525_60592[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (16))){
var inst_60387 = cljs.core.PersistentHashMap.EMPTY;
var state_60460__$1 = state_60460;
var statearr_60526_60593 = state_60460__$1;
(statearr_60526_60593[(2)] = inst_60387);

(statearr_60526_60593[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (38))){
var inst_60416 = (state_60460[(2)]);
var state_60460__$1 = state_60460;
var statearr_60527_60594 = state_60460__$1;
(statearr_60527_60594[(2)] = inst_60416);

(statearr_60527_60594[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (30))){
var inst_60344 = (state_60460[(19)]);
var state_60460__$1 = state_60460;
var statearr_60528_60595 = state_60460__$1;
(statearr_60528_60595[(2)] = inst_60344);

(statearr_60528_60595[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (10))){
var inst_60366 = (state_60460[(28)]);
var state_60460__$1 = state_60460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60460__$1,(14),inst_60366);
} else {
if((state_val_60461 === (18))){
var inst_60391 = (state_60460[(20)]);
var state_60460__$1 = state_60460;
var statearr_60529_60596 = state_60460__$1;
(statearr_60529_60596[(2)] = inst_60391);

(statearr_60529_60596[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (42))){
var inst_60345 = (state_60460[(9)]);
var state_60460__$1 = state_60460;
var statearr_60530_60597 = state_60460__$1;
(statearr_60530_60597[(2)] = inst_60345);

(statearr_60530_60597[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (37))){
var inst_60338 = (state_60460[(23)]);
var state_60460__$1 = state_60460;
var statearr_60531_60598 = state_60460__$1;
(statearr_60531_60598[(2)] = inst_60338);

(statearr_60531_60598[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (8))){
var inst_60340 = (state_60460[(16)]);
var inst_60365 = (state_60460[(2)]);
var inst_60366 = sources;
var state_60460__$1 = (function (){var statearr_60532 = state_60460;
(statearr_60532[(29)] = inst_60365);

(statearr_60532[(28)] = inst_60366);

return statearr_60532;
})();
if(cljs.core.truth_(inst_60340)){
var statearr_60533_60599 = state_60460__$1;
(statearr_60533_60599[(1)] = (9));

} else {
var statearr_60534_60600 = state_60460__$1;
(statearr_60534_60600[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60461 === (49))){
var inst_60445 = (state_60460[(13)]);
var inst_60400 = (state_60460[(24)]);
var inst_60440 = (state_60460[(27)]);
var inst_60380 = (state_60460[(11)]);
var inst_60447 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60448 = cljs.core.deref(inst_60400);
var inst_60449 = fluree.db.api.query.response_time_formatted(inst_60440);
var inst_60450 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_60380);
var inst_60451 = [(200),inst_60445,inst_60448,inst_60449,inst_60450];
var inst_60452 = cljs.core.PersistentHashMap.fromArrays(inst_60447,inst_60451);
var state_60460__$1 = state_60460;
var statearr_60535_60601 = state_60460__$1;
(statearr_60535_60601[(2)] = inst_60452);

(statearr_60535_60601[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_60536 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60536[(0)] = fluree$db$api$query$query_async_$_state_machine__2733__auto__);

(statearr_60536[(1)] = (1));

return statearr_60536;
});
var fluree$db$api$query$query_async_$_state_machine__2733__auto____1 = (function (state_60460){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_60460);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60537){var ex__2736__auto__ = e60537;
var statearr_60538_60602 = state_60460;
(statearr_60538_60602[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_60460[(4)]))){
var statearr_60539_60603 = state_60460;
(statearr_60539_60603[(1)] = cljs.core.first((state_60460[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60604 = state_60460;
state_60460 = G__60604;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2733__auto__ = function(state_60460){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2733__auto____1.call(this,state_60460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60540 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60540[(6)] = c__2755__auto__);

return statearr_60540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_60745){
var state_val_60746 = (state_60745[(1)]);
if((state_val_60746 === (7))){
var inst_60740 = (state_60745[(2)]);
var _ = (function (){var statearr_60747 = state_60745;
(statearr_60747[(4)] = cljs.core.rest((state_60745[(4)])));

return statearr_60747;
})();
var state_60745__$1 = state_60745;
var statearr_60748_60824 = state_60745__$1;
(statearr_60748_60824[(2)] = inst_60740);

(statearr_60748_60824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (20))){
var inst_60712 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60749_60825 = state_60745__$1;
(statearr_60749_60825[(2)] = inst_60712);

(statearr_60749_60825[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (27))){
var inst_60692 = (state_60745[(7)]);
var state_60745__$1 = state_60745;
var statearr_60750_60826 = state_60745__$1;
(statearr_60750_60826[(2)] = inst_60692);

(statearr_60750_60826[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (1))){
var state_60745__$1 = state_60745;
var statearr_60751_60827 = state_60745__$1;
(statearr_60751_60827[(2)] = null);

(statearr_60751_60827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (24))){
var inst_60689 = (state_60745[(8)]);
var state_60745__$1 = state_60745;
var statearr_60752_60828 = state_60745__$1;
(statearr_60752_60828[(2)] = inst_60689);

(statearr_60752_60828[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (39))){
var inst_60679 = (state_60745[(9)]);
var inst_60657 = (state_60745[(10)]);
var inst_60646 = (state_60745[(11)]);
var inst_60723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60724 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_60657];
var inst_60725 = (new cljs.core.PersistentVector(null,2,(5),inst_60723,inst_60724,null));
var inst_60726 = cljs.core.assoc_in(inst_60646,inst_60725,inst_60679);
var state_60745__$1 = state_60745;
var statearr_60753_60829 = state_60745__$1;
(statearr_60753_60829[(2)] = inst_60726);

(statearr_60753_60829[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (4))){
var inst_60605 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60754_60830 = state_60745__$1;
(statearr_60754_60830[(2)] = inst_60605);

(statearr_60754_60830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (15))){
var inst_60679 = (state_60745[(9)]);
var inst_60644 = (state_60745[(12)]);
var inst_60682 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_60679);
var inst_60683 = (inst_60644 == null);
var state_60745__$1 = (function (){var statearr_60755 = state_60745;
(statearr_60755[(13)] = inst_60682);

return statearr_60755;
})();
if(cljs.core.truth_(inst_60683)){
var statearr_60756_60831 = state_60745__$1;
(statearr_60756_60831[(1)] = (18));

} else {
var statearr_60757_60832 = state_60745__$1;
(statearr_60757_60832[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (21))){
var inst_60682 = (state_60745[(13)]);
var state_60745__$1 = state_60745;
var statearr_60758_60833 = state_60745__$1;
(statearr_60758_60833[(2)] = inst_60682);

(statearr_60758_60833[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (31))){
var state_60745__$1 = state_60745;
var statearr_60759_60834 = state_60745__$1;
(statearr_60759_60834[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (32))){
var inst_60708 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60761_60835 = state_60745__$1;
(statearr_60761_60835[(2)] = inst_60708);

(statearr_60761_60835[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (40))){
var inst_60677 = (state_60745[(14)]);
var state_60745__$1 = state_60745;
if(cljs.core.truth_(inst_60677)){
var statearr_60762_60836 = state_60745__$1;
(statearr_60762_60836[(1)] = (42));

} else {
var statearr_60763_60837 = state_60745__$1;
(statearr_60763_60837[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (33))){
var inst_60644 = (state_60745[(12)]);
var inst_60682 = (state_60745[(13)]);
var inst_60703 = ((inst_60682 > inst_60644) ? inst_60682 : inst_60644);
var state_60745__$1 = state_60745;
var statearr_60764_60838 = state_60745__$1;
(statearr_60764_60838[(2)] = inst_60703);

(statearr_60764_60838[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (13))){
var inst_60668 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60765_60839 = state_60745__$1;
(statearr_60765_60839[(2)] = inst_60668);

(statearr_60765_60839[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (22))){
var inst_60682 = (state_60745[(13)]);
var inst_60689 = (state_60745[(8)]);
var inst_60689__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_60682);
var state_60745__$1 = (function (){var statearr_60766 = state_60745;
(statearr_60766[(8)] = inst_60689__$1);

return statearr_60766;
})();
if(inst_60689__$1){
var statearr_60767_60840 = state_60745__$1;
(statearr_60767_60840[(1)] = (24));

} else {
var statearr_60768_60841 = state_60745__$1;
(statearr_60768_60841[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (36))){
var inst_60679 = (state_60745[(9)]);
var inst_60645 = (state_60745[(15)]);
var inst_60717 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_60679,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_60718 = (inst_60645 + inst_60717);
var state_60745__$1 = state_60745;
var statearr_60769_60842 = state_60745__$1;
(statearr_60769_60842[(2)] = inst_60718);

(statearr_60769_60842[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (41))){
var inst_60715 = (state_60745[(16)]);
var inst_60721 = (state_60745[(17)]);
var inst_60656 = (state_60745[(18)]);
var inst_60735 = (state_60745[(2)]);
var inst_60643 = inst_60656;
var inst_60644 = inst_60715;
var inst_60645 = inst_60721;
var inst_60646 = inst_60735;
var state_60745__$1 = (function (){var statearr_60770 = state_60745;
(statearr_60770[(12)] = inst_60644);

(statearr_60770[(11)] = inst_60646);

(statearr_60770[(15)] = inst_60645);

(statearr_60770[(19)] = inst_60643);

return statearr_60770;
})();
var statearr_60771_60843 = state_60745__$1;
(statearr_60771_60843[(2)] = null);

(statearr_60771_60843[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (43))){
var inst_60679 = (state_60745[(9)]);
var state_60745__$1 = state_60745;
var statearr_60772_60844 = state_60745__$1;
(statearr_60772_60844[(2)] = inst_60679);

(statearr_60772_60844[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (29))){
var inst_60697 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60773_60845 = state_60745__$1;
(statearr_60773_60845[(2)] = inst_60697);

(statearr_60773_60845[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (44))){
var inst_60657 = (state_60745[(10)]);
var inst_60646 = (state_60745[(11)]);
var inst_60732 = (state_60745[(2)]);
var inst_60733 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60646,inst_60657,inst_60732);
var state_60745__$1 = state_60745;
var statearr_60774_60846 = state_60745__$1;
(statearr_60774_60846[(2)] = inst_60733);

(statearr_60774_60846[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (6))){
var inst_60658 = (state_60745[(20)]);
var inst_60643 = (state_60745[(19)]);
var inst_60654 = cljs.core.seq(inst_60643);
var inst_60655 = cljs.core.first(inst_60654);
var inst_60656 = cljs.core.next(inst_60654);
var inst_60657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60655,(0),null);
var inst_60658__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60655,(1),null);
var inst_60659 = (inst_60658__$1 == null);
var state_60745__$1 = (function (){var statearr_60775 = state_60745;
(statearr_60775[(10)] = inst_60657);

(statearr_60775[(20)] = inst_60658__$1);

(statearr_60775[(18)] = inst_60656);

return statearr_60775;
})();
if(cljs.core.truth_(inst_60659)){
var statearr_60776_60847 = state_60745__$1;
(statearr_60776_60847[(1)] = (8));

} else {
var statearr_60777_60848 = state_60745__$1;
(statearr_60777_60848[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (28))){
var inst_60644 = (state_60745[(12)]);
var inst_60695 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_60644);
var state_60745__$1 = state_60745;
var statearr_60778_60849 = state_60745__$1;
(statearr_60778_60849[(2)] = inst_60695);

(statearr_60778_60849[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (25))){
var inst_60692 = (state_60745[(7)]);
var inst_60644 = (state_60745[(12)]);
var inst_60692__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_60644);
var state_60745__$1 = (function (){var statearr_60779 = state_60745;
(statearr_60779[(7)] = inst_60692__$1);

return statearr_60779;
})();
if(inst_60692__$1){
var statearr_60780_60850 = state_60745__$1;
(statearr_60780_60850[(1)] = (27));

} else {
var statearr_60781_60851 = state_60745__$1;
(statearr_60781_60851[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (34))){
var state_60745__$1 = state_60745;
var statearr_60782_60852 = state_60745__$1;
(statearr_60782_60852[(2)] = null);

(statearr_60782_60852[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (17))){
var inst_60676 = (state_60745[(21)]);
var inst_60715 = (state_60745[(2)]);
var state_60745__$1 = (function (){var statearr_60783 = state_60745;
(statearr_60783[(16)] = inst_60715);

return statearr_60783;
})();
if(cljs.core.truth_(inst_60676)){
var statearr_60784_60853 = state_60745__$1;
(statearr_60784_60853[(1)] = (36));

} else {
var statearr_60785_60854 = state_60745__$1;
(statearr_60785_60854[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (3))){
var inst_60743 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60745__$1,inst_60743);
} else {
if((state_val_60746 === (12))){
var inst_60646 = (state_60745[(11)]);
var state_60745__$1 = state_60745;
var statearr_60786_60855 = state_60745__$1;
(statearr_60786_60855[(2)] = inst_60646);

(statearr_60786_60855[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (2))){
var inst_60620 = (state_60745[(22)]);
var inst_60615 = (state_60745[(23)]);
var inst_60619 = (state_60745[(24)]);
var _ = (function (){var statearr_60787 = state_60745;
(statearr_60787[(4)] = cljs.core.cons((5),(state_60745[(4)])));

return statearr_60787;
})();
var inst_60611 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_60612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60613 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_60614 = (new cljs.core.PersistentVector(null,2,(5),inst_60612,inst_60613,null));
var inst_60615__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_60614);
var inst_60616 = (function (){var global_block = inst_60611;
var global_meta_QMARK_ = inst_60615__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4223__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4221__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4221__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_60617 = cljs.core.PersistentHashMap.EMPTY;
var inst_60618 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_60619__$1 = cljs.core.reduce_kv(inst_60616,inst_60617,inst_60618);
var inst_60620__$1 = fluree.db.util.core.current_time_millis();
var inst_60622 = (function (){var global_block = inst_60611;
var global_meta_QMARK_ = inst_60615__$1;
var queries = inst_60619__$1;
var start_time = inst_60620__$1;
return (function (p__60621){
var vec__60788 = p__60621;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60788,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60788,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_60623 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_60622,inst_60619__$1);
var inst_60637 = cljs.core.seq(inst_60623);
var inst_60638 = cljs.core.first(inst_60637);
var inst_60639 = cljs.core.next(inst_60637);
var inst_60640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60638,(0),null);
var inst_60641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60638,(1),null);
var inst_60642 = cljs.core.PersistentHashMap.EMPTY;
var inst_60643 = inst_60623;
var inst_60644 = null;
var inst_60645 = (0);
var inst_60646 = inst_60642;
var state_60745__$1 = (function (){var statearr_60791 = state_60745;
(statearr_60791[(25)] = inst_60640);

(statearr_60791[(12)] = inst_60644);

(statearr_60791[(22)] = inst_60620__$1);

(statearr_60791[(23)] = inst_60615__$1);

(statearr_60791[(11)] = inst_60646);

(statearr_60791[(26)] = inst_60639);

(statearr_60791[(27)] = inst_60641);

(statearr_60791[(24)] = inst_60619__$1);

(statearr_60791[(15)] = inst_60645);

(statearr_60791[(19)] = inst_60643);

return statearr_60791;
})();
var statearr_60792_60856 = state_60745__$1;
(statearr_60792_60856[(2)] = null);

(statearr_60792_60856[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (23))){
var inst_60710 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60793_60857 = state_60745__$1;
(statearr_60793_60857[(2)] = inst_60710);

(statearr_60793_60857[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (35))){
var inst_60706 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60794_60858 = state_60745__$1;
(statearr_60794_60858[(2)] = inst_60706);

(statearr_60794_60858[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (19))){
var inst_60644 = (state_60745[(12)]);
var inst_60682 = (state_60745[(13)]);
var inst_60686 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60644,inst_60682);
var state_60745__$1 = state_60745;
if(inst_60686){
var statearr_60795_60859 = state_60745__$1;
(statearr_60795_60859[(1)] = (21));

} else {
var statearr_60796_60860 = state_60745__$1;
(statearr_60796_60860[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (11))){
var inst_60644 = (state_60745[(12)]);
var inst_60620 = (state_60745[(22)]);
var inst_60646 = (state_60745[(11)]);
var inst_60645 = (state_60745[(15)]);
var inst_60662 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60663 = fluree.db.api.query.response_time_formatted(inst_60620);
var inst_60664 = [inst_60646,inst_60645,inst_60644,inst_60663];
var inst_60665 = cljs.core.PersistentHashMap.fromArrays(inst_60662,inst_60664);
var state_60745__$1 = state_60745;
var statearr_60798_60861 = state_60745__$1;
(statearr_60798_60861[(2)] = inst_60665);

(statearr_60798_60861[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (9))){
var inst_60657 = (state_60745[(10)]);
var inst_60658 = (state_60745[(20)]);
var inst_60619 = (state_60745[(24)]);
var inst_60671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60672 = [inst_60657,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_60673 = (new cljs.core.PersistentVector(null,2,(5),inst_60671,inst_60672,null));
var inst_60674 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_60619,inst_60673);
var inst_60675 = cljs.core.__destructure_map(inst_60674);
var inst_60676 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60675,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_60677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60675,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_60745__$1 = (function (){var statearr_60799 = state_60745;
(statearr_60799[(21)] = inst_60676);

(statearr_60799[(14)] = inst_60677);

return statearr_60799;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60745__$1,(14),inst_60658);
} else {
if((state_val_60746 === (5))){
var _ = (function (){var statearr_60800 = state_60745;
(statearr_60800[(4)] = cljs.core.rest((state_60745[(4)])));

return statearr_60800;
})();
var state_60745__$1 = state_60745;
var ex60797 = (state_60745__$1[(2)]);
var statearr_60801_60862 = state_60745__$1;
(statearr_60801_60862[(5)] = ex60797);


var statearr_60802_60863 = state_60745__$1;
(statearr_60802_60863[(1)] = (4));

(statearr_60802_60863[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (14))){
var inst_60679 = (state_60745[(9)]);
var inst_60676 = (state_60745[(21)]);
var inst_60679__$1 = (state_60745[(2)]);
var inst_60680 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_60679__$1);
var state_60745__$1 = (function (){var statearr_60803 = state_60745;
(statearr_60803[(9)] = inst_60679__$1);

(statearr_60803[(28)] = inst_60680);

return statearr_60803;
})();
if(cljs.core.truth_(inst_60676)){
var statearr_60804_60864 = state_60745__$1;
(statearr_60804_60864[(1)] = (15));

} else {
var statearr_60805_60865 = state_60745__$1;
(statearr_60805_60865[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (26))){
var inst_60699 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
if(cljs.core.truth_(inst_60699)){
var statearr_60806_60866 = state_60745__$1;
(statearr_60806_60866[(1)] = (30));

} else {
var statearr_60807_60867 = state_60745__$1;
(statearr_60807_60867[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (16))){
var state_60745__$1 = state_60745;
var statearr_60808_60868 = state_60745__$1;
(statearr_60808_60868[(2)] = null);

(statearr_60808_60868[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (38))){
var inst_60680 = (state_60745[(28)]);
var inst_60721 = (state_60745[(2)]);
var state_60745__$1 = (function (){var statearr_60809 = state_60745;
(statearr_60809[(17)] = inst_60721);

return statearr_60809;
})();
if(cljs.core.truth_(inst_60680)){
var statearr_60810_60869 = state_60745__$1;
(statearr_60810_60869[(1)] = (39));

} else {
var statearr_60811_60870 = state_60745__$1;
(statearr_60811_60870[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (30))){
var state_60745__$1 = state_60745;
var statearr_60812_60871 = state_60745__$1;
(statearr_60812_60871[(2)] = (207));

(statearr_60812_60871[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (10))){
var inst_60738 = (state_60745[(2)]);
var state_60745__$1 = state_60745;
var statearr_60813_60872 = state_60745__$1;
(statearr_60813_60872[(2)] = inst_60738);

(statearr_60813_60872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (18))){
var inst_60682 = (state_60745[(13)]);
var state_60745__$1 = state_60745;
var statearr_60814_60873 = state_60745__$1;
(statearr_60814_60873[(2)] = inst_60682);

(statearr_60814_60873[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (42))){
var inst_60679 = (state_60745[(9)]);
var inst_60729 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_60679);
var state_60745__$1 = state_60745;
var statearr_60815_60874 = state_60745__$1;
(statearr_60815_60874[(2)] = inst_60729);

(statearr_60815_60874[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (37))){
var state_60745__$1 = state_60745;
var statearr_60816_60875 = state_60745__$1;
(statearr_60816_60875[(2)] = null);

(statearr_60816_60875[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60746 === (8))){
var inst_60615 = (state_60745[(23)]);
var state_60745__$1 = state_60745;
if(cljs.core.truth_(inst_60615)){
var statearr_60817_60876 = state_60745__$1;
(statearr_60817_60876[(1)] = (11));

} else {
var statearr_60818_60877 = state_60745__$1;
(statearr_60818_60877[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____0 = (function (){
var statearr_60819 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60819[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__);

(statearr_60819[(1)] = (1));

return statearr_60819;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____1 = (function (state_60745){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_60745);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e60820){var ex__2736__auto__ = e60820;
var statearr_60821_60878 = state_60745;
(statearr_60821_60878[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_60745[(4)]))){
var statearr_60822_60879 = state_60745;
(statearr_60822_60879[(1)] = cljs.core.first((state_60745[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60880 = state_60745;
state_60745 = G__60880;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__ = function(state_60745){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____1.call(this,state_60745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2733__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_60823 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_60823[(6)] = c__2755__auto__);

return statearr_60823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__60881 = query_type;
var G__60881__$1 = (((G__60881 instanceof cljs.core.Keyword))?G__60881.fqn:null);
switch (G__60881__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__60881__$1)].join('')));

}
});
