// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62176 = arguments.length;
switch (G__62176) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62218){
var state_val_62219 = (state_62218[(1)]);
if((state_val_62219 === (7))){
var inst_62188 = typeof user === 'string';
var state_62218__$1 = state_62218;
if(cljs.core.truth_(inst_62188)){
var statearr_62220_62249 = state_62218__$1;
(statearr_62220_62249[(1)] = (9));

} else {
var statearr_62221_62250 = state_62218__$1;
(statearr_62221_62250[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (1))){
var state_62218__$1 = state_62218;
var statearr_62222_62251 = state_62218__$1;
(statearr_62222_62251[(2)] = null);

(statearr_62222_62251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (4))){
var inst_62177 = (state_62218[(2)]);
var inst_62178 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62177], 0));
var inst_62179 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62177) : reject.call(null,inst_62177));
var state_62218__$1 = (function (){var statearr_62223 = state_62218;
(statearr_62223[(7)] = inst_62178);

return statearr_62223;
})();
var statearr_62224_62252 = state_62218__$1;
(statearr_62224_62252[(2)] = inst_62179);

(statearr_62224_62252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (15))){
var inst_62207 = (state_62218[(2)]);
var inst_62208 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62207);
var inst_62209 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62210 = cljs.core.constantly(inst_62208);
var inst_62211 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62209,inst_62210);
var inst_62212 = fluree.db.connection.add_token(conn,inst_62208);
var inst_62213 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_62207) : resolve.call(null,inst_62207));
var _ = (function (){var statearr_62225 = state_62218;
(statearr_62225[(4)] = cljs.core.rest((state_62218[(4)])));

return statearr_62225;
})();
var state_62218__$1 = (function (){var statearr_62226 = state_62218;
(statearr_62226[(8)] = inst_62212);

(statearr_62226[(9)] = inst_62211);

return statearr_62226;
})();
var statearr_62227_62253 = state_62218__$1;
(statearr_62227_62253[(2)] = inst_62213);

(statearr_62227_62253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (13))){
var state_62218__$1 = state_62218;
var statearr_62228_62254 = state_62218__$1;
(statearr_62228_62254[(2)] = null);

(statearr_62228_62254[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (6))){
var state_62218__$1 = state_62218;
var statearr_62229_62255 = state_62218__$1;
(statearr_62229_62255[(2)] = user);

(statearr_62229_62255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (3))){
var inst_62216 = (state_62218[(2)]);
var state_62218__$1 = state_62218;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62218__$1,inst_62216);
} else {
if((state_val_62219 === (12))){
var state_62218__$1 = state_62218;
var statearr_62230_62256 = state_62218__$1;
(statearr_62230_62256[(2)] = user);

(statearr_62230_62256[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (2))){
var _ = (function (){var statearr_62231 = state_62218;
(statearr_62231[(4)] = cljs.core.cons((5),(state_62218[(4)])));

return statearr_62231;
})();
var inst_62185 = typeof user === 'number';
var state_62218__$1 = state_62218;
if(cljs.core.truth_(inst_62185)){
var statearr_62232_62257 = state_62218__$1;
(statearr_62232_62257[(1)] = (6));

} else {
var statearr_62233_62258 = state_62218__$1;
(statearr_62233_62258[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (11))){
var inst_62199 = (state_62218[(2)]);
var state_62218__$1 = state_62218;
var statearr_62235_62259 = state_62218__$1;
(statearr_62235_62259[(2)] = inst_62199);

(statearr_62235_62259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (9))){
var inst_62190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62191 = ["_user/username",user];
var inst_62192 = (new cljs.core.PersistentVector(null,2,(5),inst_62190,inst_62191,null));
var state_62218__$1 = state_62218;
var statearr_62236_62260 = state_62218__$1;
(statearr_62236_62260[(2)] = inst_62192);

(statearr_62236_62260[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (5))){
var _ = (function (){var statearr_62237 = state_62218;
(statearr_62237[(4)] = cljs.core.rest((state_62218[(4)])));

return statearr_62237;
})();
var state_62218__$1 = state_62218;
var ex62234 = (state_62218__$1[(2)]);
var statearr_62238_62261 = state_62218__$1;
(statearr_62238_62261[(5)] = ex62234);


var statearr_62239_62262 = state_62218__$1;
(statearr_62239_62262[(1)] = (4));

(statearr_62239_62262[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (14))){
var inst_62197 = (state_62218[(2)]);
var state_62218__$1 = state_62218;
var statearr_62240_62263 = state_62218__$1;
(statearr_62240_62263[(2)] = inst_62197);

(statearr_62240_62263[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (10))){
var state_62218__$1 = state_62218;
var statearr_62241_62264 = state_62218__$1;
(statearr_62241_62264[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62219 === (8))){
var inst_62201 = (state_62218[(2)]);
var inst_62202 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62203 = [account,inst_62201,password,expireSeconds,syncTo];
var inst_62204 = cljs.core.PersistentHashMap.fromArrays(inst_62202,inst_62203);
var inst_62205 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62204);
var state_62218__$1 = state_62218;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62218__$1,(15),inst_62205);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_62243 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62243[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_62243[(1)] = (1));

return statearr_62243;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_62218){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62218);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62244){var ex__2736__auto__ = e62244;
var statearr_62245_62265 = state_62218;
(statearr_62245_62265[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62218[(4)]))){
var statearr_62246_62266 = state_62218;
(statearr_62246_62266[(1)] = cljs.core.first((state_62218[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62267 = state_62218;
state_62218 = G__62267;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_62218){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_62218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62247 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62247[(6)] = c__2755__auto__);

return statearr_62247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__62269 = arguments.length;
switch (G__62269) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62278){
var state_val_62279 = (state_62278[(1)]);
if((state_val_62279 === (1))){
var inst_62270 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62272 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_62273 = (new cljs.core.PersistentVector(null,4,(5),inst_62271,inst_62272,null));
var inst_62274 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62270,inst_62273);
var inst_62275 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__62280 = cljs.core.seq(cljs.core.keys(x));
var chunk__62281 = null;
var count__62282 = (0);
var i__62283 = (0);
while(true){
if((i__62283 < count__62282)){
var k = chunk__62281.cljs$core$IIndexed$_nth$arity$2(null,i__62283);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62291 = seq__62280;
var G__62292 = chunk__62281;
var G__62293 = count__62282;
var G__62294 = (i__62283 + (1));
seq__62280 = G__62291;
chunk__62281 = G__62292;
count__62282 = G__62293;
i__62283 = G__62294;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__62280);
if(temp__5753__auto__){
var seq__62280__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__62280__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__62280__$1);
var G__62295 = cljs.core.chunk_rest(seq__62280__$1);
var G__62296 = c__4649__auto__;
var G__62297 = cljs.core.count(c__4649__auto__);
var G__62298 = (0);
seq__62280 = G__62295;
chunk__62281 = G__62296;
count__62282 = G__62297;
i__62283 = G__62298;
continue;
} else {
var k = cljs.core.first(seq__62280__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__62299 = cljs.core.next(seq__62280__$1);
var G__62300 = null;
var G__62301 = (0);
var G__62302 = (0);
seq__62280 = G__62299;
chunk__62281 = G__62300;
count__62282 = G__62301;
i__62283 = G__62302;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_62276 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_62275);
var state_62278__$1 = (function (){var statearr_62284 = state_62278;
(statearr_62284[(7)] = inst_62274);

return statearr_62284;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_62278__$1,inst_62276);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_62285 = [null,null,null,null,null,null,null,null];
(statearr_62285[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_62285[(1)] = (1));

return statearr_62285;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_62278){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62278);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62286){var ex__2736__auto__ = e62286;
var statearr_62287_62303 = state_62278;
(statearr_62287_62303[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62278[(4)]))){
var statearr_62288_62304 = state_62278;
(statearr_62288_62304[(1)] = cljs.core.first((state_62278[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62305 = state_62278;
state_62278 = G__62305;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_62278){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_62278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62289 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62289[(6)] = c__2755__auto__);

return statearr_62289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__62307 = arguments.length;
switch (G__62307) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62341){
var state_val_62342 = (state_62341[(1)]);
if((state_val_62342 === (1))){
var state_62341__$1 = state_62341;
var statearr_62343_62364 = state_62341__$1;
(statearr_62343_62364[(2)] = null);

(statearr_62343_62364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62342 === (2))){
var _ = (function (){var statearr_62344 = state_62341;
(statearr_62344[(4)] = cljs.core.cons((5),(state_62341[(4)])));

return statearr_62344;
})();
var inst_62316 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_62317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62318 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_62319 = (new cljs.core.PersistentVector(null,1,(5),inst_62317,inst_62318,null));
var inst_62320 = cljs.core.PersistentHashMap.EMPTY;
var inst_62321 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62320);
var inst_62322 = cljs.core.assoc_in(inst_62316,inst_62319,inst_62321);
var inst_62323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62324 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62325 = (new cljs.core.PersistentVector(null,1,(5),inst_62323,inst_62324,null));
var inst_62326 = cljs.core.PersistentHashMap.EMPTY;
var inst_62327 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_62326);
var inst_62328 = cljs.core.assoc_in(inst_62322,inst_62325,inst_62327);
var inst_62329 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62330 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_62328);
var inst_62331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62332 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_62329,null];
var inst_62333 = (new cljs.core.PersistentVector(null,4,(5),inst_62331,inst_62332,null));
var inst_62334 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62330,inst_62333);
var inst_62335 = (function (){var conn = inst_62328;
var pc = inst_62329;
return (function (x){
if((x == null)){
} else {
var seq__62345_62365 = cljs.core.seq(cljs.core.keys(x));
var chunk__62346_62366 = null;
var count__62347_62367 = (0);
var i__62348_62368 = (0);
while(true){
if((i__62348_62368 < count__62347_62367)){
var k_62369 = chunk__62346_62366.cljs$core$IIndexed$_nth$arity$2(null,i__62348_62368);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62369], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62369,null));


var G__62370 = seq__62345_62365;
var G__62371 = chunk__62346_62366;
var G__62372 = count__62347_62367;
var G__62373 = (i__62348_62368 + (1));
seq__62345_62365 = G__62370;
chunk__62346_62366 = G__62371;
count__62347_62367 = G__62372;
i__62348_62368 = G__62373;
continue;
} else {
var temp__5753__auto___62374 = cljs.core.seq(seq__62345_62365);
if(temp__5753__auto___62374){
var seq__62345_62375__$1 = temp__5753__auto___62374;
if(cljs.core.chunked_seq_QMARK_(seq__62345_62375__$1)){
var c__4649__auto___62376 = cljs.core.chunk_first(seq__62345_62375__$1);
var G__62377 = cljs.core.chunk_rest(seq__62345_62375__$1);
var G__62378 = c__4649__auto___62376;
var G__62379 = cljs.core.count(c__4649__auto___62376);
var G__62380 = (0);
seq__62345_62365 = G__62377;
chunk__62346_62366 = G__62378;
count__62347_62367 = G__62379;
i__62348_62368 = G__62380;
continue;
} else {
var k_62381 = cljs.core.first(seq__62345_62375__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62381], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_62381,null));


var G__62382 = cljs.core.next(seq__62345_62375__$1);
var G__62383 = null;
var G__62384 = (0);
var G__62385 = (0);
seq__62345_62365 = G__62382;
chunk__62346_62366 = G__62383;
count__62347_62367 = G__62384;
i__62348_62368 = G__62385;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_62336 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62329,inst_62335);
var ___$1 = (function (){var statearr_62349 = state_62341;
(statearr_62349[(4)] = cljs.core.rest((state_62341[(4)])));

return statearr_62349;
})();
var state_62341__$1 = (function (){var statearr_62350 = state_62341;
(statearr_62350[(7)] = inst_62334);

return statearr_62350;
})();
var statearr_62351_62386 = state_62341__$1;
(statearr_62351_62386[(2)] = inst_62336);

(statearr_62351_62386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62342 === (3))){
var inst_62339 = (state_62341[(2)]);
var state_62341__$1 = state_62341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62341__$1,inst_62339);
} else {
if((state_val_62342 === (4))){
var inst_62308 = (state_62341[(2)]);
var inst_62309 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62308], 0));
var inst_62310 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62308) : reject.call(null,inst_62308));
var state_62341__$1 = (function (){var statearr_62353 = state_62341;
(statearr_62353[(8)] = inst_62309);

return statearr_62353;
})();
var statearr_62354_62387 = state_62341__$1;
(statearr_62354_62387[(2)] = inst_62310);

(statearr_62354_62387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62342 === (5))){
var _ = (function (){var statearr_62355 = state_62341;
(statearr_62355[(4)] = cljs.core.rest((state_62341[(4)])));

return statearr_62355;
})();
var state_62341__$1 = state_62341;
var ex62352 = (state_62341__$1[(2)]);
var statearr_62356_62388 = state_62341__$1;
(statearr_62356_62388[(5)] = ex62352);


var statearr_62357_62389 = state_62341__$1;
(statearr_62357_62389[(1)] = (4));

(statearr_62357_62389[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_62358 = [null,null,null,null,null,null,null,null,null];
(statearr_62358[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_62358[(1)] = (1));

return statearr_62358;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_62341){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62341);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62359){var ex__2736__auto__ = e62359;
var statearr_62360_62390 = state_62341;
(statearr_62360_62390[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62341[(4)]))){
var statearr_62361_62391 = state_62341;
(statearr_62361_62391[(1)] = cljs.core.first((state_62341[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62392 = state_62341;
state_62341 = G__62392;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_62341){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_62341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62362 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62362[(6)] = c__2755__auto__);

return statearr_62362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__62394 = arguments.length;
switch (G__62394) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__62396 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62396,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62396,(1),null);
var cb_STAR_ = (function (header,data){
var G__62399 = cljs.core.clj__GT_js(header);
var G__62400 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__62399,G__62400) : callback.call(null,G__62399,G__62400));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__62401 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62401,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62401,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62454){
var state_val_62455 = (state_62454[(1)]);
if((state_val_62455 === (7))){
var inst_62415 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62416 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62417 = cljs.core.PersistentHashMap.fromArrays(inst_62415,inst_62416);
var inst_62418 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62417);
var inst_62419 = (function(){throw inst_62418})();
var state_62454__$1 = state_62454;
var statearr_62456_62488 = state_62454__$1;
(statearr_62456_62488[(2)] = inst_62419);

(statearr_62456_62488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (1))){
var state_62454__$1 = state_62454;
var statearr_62457_62489 = state_62454__$1;
(statearr_62457_62489[(2)] = null);

(statearr_62457_62489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (4))){
var inst_62404 = (state_62454[(2)]);
var inst_62405 = cljs.core.clj__GT_js(inst_62404);
var inst_62406 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62405) : reject.call(null,inst_62405));
var state_62454__$1 = state_62454;
var statearr_62458_62490 = state_62454__$1;
(statearr_62458_62490[(2)] = inst_62406);

(statearr_62458_62490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (13))){
var inst_62433 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62434 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62435 = cljs.core.PersistentHashMap.fromArrays(inst_62433,inst_62434);
var inst_62436 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_62435);
var inst_62437 = (function(){throw inst_62436})();
var state_62454__$1 = state_62454;
var statearr_62459_62491 = state_62454__$1;
(statearr_62459_62491[(2)] = inst_62437);

(statearr_62459_62491[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (6))){
var state_62454__$1 = state_62454;
var statearr_62460_62492 = state_62454__$1;
(statearr_62460_62492[(2)] = null);

(statearr_62460_62492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (3))){
var inst_62452 = (state_62454[(2)]);
var state_62454__$1 = state_62454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62454__$1,inst_62452);
} else {
if((state_val_62455 === (12))){
var state_62454__$1 = state_62454;
var statearr_62461_62493 = state_62454__$1;
(statearr_62461_62493[(2)] = null);

(statearr_62461_62493[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (2))){
var _ = (function (){var statearr_62462 = state_62454;
(statearr_62462[(4)] = cljs.core.cons((5),(state_62454[(4)])));

return statearr_62462;
})();
var inst_62412 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62454__$1 = state_62454;
if(cljs.core.truth_(inst_62412)){
var statearr_62463_62494 = state_62454__$1;
(statearr_62463_62494[(1)] = (6));

} else {
var statearr_62464_62495 = state_62454__$1;
(statearr_62464_62495[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (11))){
var inst_62430 = (state_62454[(2)]);
var state_62454__$1 = (function (){var statearr_62466 = state_62454;
(statearr_62466[(7)] = inst_62430);

return statearr_62466;
})();
if(cljs.core.truth_(password)){
var statearr_62467_62496 = state_62454__$1;
(statearr_62467_62496[(1)] = (12));

} else {
var statearr_62468_62497 = state_62454__$1;
(statearr_62468_62497[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (9))){
var state_62454__$1 = state_62454;
var statearr_62469_62498 = state_62454__$1;
(statearr_62469_62498[(2)] = null);

(statearr_62469_62498[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (5))){
var _ = (function (){var statearr_62470 = state_62454;
(statearr_62470[(4)] = cljs.core.rest((state_62454[(4)])));

return statearr_62470;
})();
var state_62454__$1 = state_62454;
var ex62465 = (state_62454__$1[(2)]);
var statearr_62471_62499 = state_62454__$1;
(statearr_62471_62499[(5)] = ex62465);


var statearr_62472_62500 = state_62454__$1;
(statearr_62472_62500[(1)] = (4));

(statearr_62472_62500[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (14))){
var inst_62439 = (state_62454[(2)]);
var inst_62440 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_62441 = fluree.db.util.core.without_nils(inst_62440);
var inst_62442 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62443 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62445 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_62441,inst_62442,null];
var inst_62446 = (new cljs.core.PersistentVector(null,4,(5),inst_62444,inst_62445,null));
var inst_62447 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62443,inst_62446);
var inst_62448 = (function (){var _ = inst_62439;
var data = inst_62441;
var pc = inst_62442;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62473 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62473) : reject.call(null,G__62473));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62474 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62474) : reject.call(null,G__62474));
} else {
var G__62475 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62475) : resolve.call(null,G__62475));

}
}
});
})();
var inst_62449 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62442,inst_62448);
var _ = (function (){var statearr_62476 = state_62454;
(statearr_62476[(4)] = cljs.core.rest((state_62454[(4)])));

return statearr_62476;
})();
var state_62454__$1 = (function (){var statearr_62477 = state_62454;
(statearr_62477[(8)] = inst_62447);

return statearr_62477;
})();
var statearr_62478_62501 = state_62454__$1;
(statearr_62478_62501[(2)] = inst_62449);

(statearr_62478_62501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (10))){
var inst_62424 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62425 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62426 = cljs.core.PersistentHashMap.fromArrays(inst_62424,inst_62425);
var inst_62427 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_62426);
var inst_62428 = (function(){throw inst_62427})();
var state_62454__$1 = state_62454;
var statearr_62479_62502 = state_62454__$1;
(statearr_62479_62502[(2)] = inst_62428);

(statearr_62479_62502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62455 === (8))){
var inst_62421 = (state_62454[(2)]);
var state_62454__$1 = (function (){var statearr_62480 = state_62454;
(statearr_62480[(9)] = inst_62421);

return statearr_62480;
})();
if(cljs.core.truth_(ledger)){
var statearr_62481_62503 = state_62454__$1;
(statearr_62481_62503[(1)] = (9));

} else {
var statearr_62482_62504 = state_62454__$1;
(statearr_62482_62504[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0 = (function (){
var statearr_62483 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62483[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2733__auto__);

(statearr_62483[(1)] = (1));

return statearr_62483;
});
var fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1 = (function (state_62454){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62454);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62484){var ex__2736__auto__ = e62484;
var statearr_62485_62505 = state_62454;
(statearr_62485_62505[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62454[(4)]))){
var statearr_62486_62506 = state_62454;
(statearr_62486_62506[(1)] = cljs.core.first((state_62454[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62507 = state_62454;
state_62454 = G__62507;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__ = function(state_62454){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1.call(this,state_62454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2733__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2733__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62487 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62487[(6)] = c__2755__auto__);

return statearr_62487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__62509 = arguments.length;
switch (G__62509) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62576){
var state_val_62577 = (state_62576[(1)]);
if((state_val_62577 === (7))){
var inst_62521 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62522 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62523 = cljs.core.PersistentHashMap.fromArrays(inst_62521,inst_62522);
var inst_62524 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62523);
var inst_62525 = (function(){throw inst_62524})();
var state_62576__$1 = state_62576;
var statearr_62578_62620 = state_62576__$1;
(statearr_62578_62620[(2)] = inst_62525);

(statearr_62578_62620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (20))){
var inst_62559 = (state_62576[(2)]);
var inst_62560 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62561 = [ledger,password,user,auth,expire];
var inst_62562 = cljs.core.PersistentHashMap.fromArrays(inst_62560,inst_62561);
var inst_62563 = fluree.db.util.core.without_nils(inst_62562);
var inst_62564 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62565 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62567 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_62563,inst_62564,null];
var inst_62568 = (new cljs.core.PersistentVector(null,4,(5),inst_62566,inst_62567,null));
var inst_62569 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62565,inst_62568);
var inst_62570 = (function (){var _ = inst_62559;
var data = inst_62563;
var pc = inst_62564;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62579 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62579) : reject.call(null,G__62579));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__62580 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62580) : reject.call(null,G__62580));
} else {
fluree.db.connection.add_token(conn,result);

var G__62581 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62581) : resolve.call(null,G__62581));

}
}
});
})();
var inst_62571 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62564,inst_62570);
var _ = (function (){var statearr_62582 = state_62576;
(statearr_62582[(4)] = cljs.core.rest((state_62576[(4)])));

return statearr_62582;
})();
var state_62576__$1 = (function (){var statearr_62583 = state_62576;
(statearr_62583[(7)] = inst_62569);

return statearr_62583;
})();
var statearr_62584_62621 = state_62576__$1;
(statearr_62584_62621[(2)] = inst_62571);

(statearr_62584_62621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (1))){
var state_62576__$1 = state_62576;
var statearr_62585_62622 = state_62576__$1;
(statearr_62585_62622[(2)] = null);

(statearr_62585_62622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (4))){
var inst_62510 = (state_62576[(2)]);
var inst_62511 = cljs.core.clj__GT_js(inst_62510);
var inst_62512 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62511) : reject.call(null,inst_62511));
var state_62576__$1 = state_62576;
var statearr_62586_62623 = state_62576__$1;
(statearr_62586_62623[(2)] = inst_62512);

(statearr_62586_62623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (15))){
var inst_62546 = (state_62576[(8)]);
var state_62576__$1 = state_62576;
var statearr_62587_62624 = state_62576__$1;
(statearr_62587_62624[(2)] = inst_62546);

(statearr_62587_62624[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (13))){
var inst_62539 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62540 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62541 = cljs.core.PersistentHashMap.fromArrays(inst_62539,inst_62540);
var inst_62542 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_62541);
var inst_62543 = (function(){throw inst_62542})();
var state_62576__$1 = state_62576;
var statearr_62588_62625 = state_62576__$1;
(statearr_62588_62625[(2)] = inst_62543);

(statearr_62588_62625[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (6))){
var state_62576__$1 = state_62576;
var statearr_62589_62626 = state_62576__$1;
(statearr_62589_62626[(2)] = null);

(statearr_62589_62626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (17))){
var inst_62550 = (state_62576[(2)]);
var state_62576__$1 = state_62576;
if(cljs.core.truth_(inst_62550)){
var statearr_62590_62627 = state_62576__$1;
(statearr_62590_62627[(1)] = (18));

} else {
var statearr_62591_62628 = state_62576__$1;
(statearr_62591_62628[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (3))){
var inst_62574 = (state_62576[(2)]);
var state_62576__$1 = state_62576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62576__$1,inst_62574);
} else {
if((state_val_62577 === (12))){
var state_62576__$1 = state_62576;
var statearr_62592_62629 = state_62576__$1;
(statearr_62592_62629[(2)] = null);

(statearr_62592_62629[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (2))){
var _ = (function (){var statearr_62593 = state_62576;
(statearr_62593[(4)] = cljs.core.cons((5),(state_62576[(4)])));

return statearr_62593;
})();
var inst_62518 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62576__$1 = state_62576;
if(cljs.core.truth_(inst_62518)){
var statearr_62594_62630 = state_62576__$1;
(statearr_62594_62630[(1)] = (6));

} else {
var statearr_62595_62631 = state_62576__$1;
(statearr_62595_62631[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (19))){
var inst_62553 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62554 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62555 = cljs.core.PersistentHashMap.fromArrays(inst_62553,inst_62554);
var inst_62556 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_62555);
var inst_62557 = (function(){throw inst_62556})();
var state_62576__$1 = state_62576;
var statearr_62596_62632 = state_62576__$1;
(statearr_62596_62632[(2)] = inst_62557);

(statearr_62596_62632[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (11))){
var inst_62536 = (state_62576[(2)]);
var state_62576__$1 = (function (){var statearr_62598 = state_62576;
(statearr_62598[(9)] = inst_62536);

return statearr_62598;
})();
if(cljs.core.truth_(password)){
var statearr_62599_62633 = state_62576__$1;
(statearr_62599_62633[(1)] = (12));

} else {
var statearr_62600_62634 = state_62576__$1;
(statearr_62600_62634[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (9))){
var state_62576__$1 = state_62576;
var statearr_62601_62635 = state_62576__$1;
(statearr_62601_62635[(2)] = null);

(statearr_62601_62635[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (5))){
var _ = (function (){var statearr_62602 = state_62576;
(statearr_62602[(4)] = cljs.core.rest((state_62576[(4)])));

return statearr_62602;
})();
var state_62576__$1 = state_62576;
var ex62597 = (state_62576__$1[(2)]);
var statearr_62603_62636 = state_62576__$1;
(statearr_62603_62636[(5)] = ex62597);


var statearr_62604_62637 = state_62576__$1;
(statearr_62604_62637[(1)] = (4));

(statearr_62604_62637[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (14))){
var inst_62546 = (state_62576[(8)]);
var inst_62545 = (state_62576[(2)]);
var inst_62546__$1 = user;
var state_62576__$1 = (function (){var statearr_62605 = state_62576;
(statearr_62605[(8)] = inst_62546__$1);

(statearr_62605[(10)] = inst_62545);

return statearr_62605;
})();
if(cljs.core.truth_(inst_62546__$1)){
var statearr_62606_62638 = state_62576__$1;
(statearr_62606_62638[(1)] = (15));

} else {
var statearr_62607_62639 = state_62576__$1;
(statearr_62607_62639[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (16))){
var state_62576__$1 = state_62576;
var statearr_62608_62640 = state_62576__$1;
(statearr_62608_62640[(2)] = auth);

(statearr_62608_62640[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (10))){
var inst_62530 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62531 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62532 = cljs.core.PersistentHashMap.fromArrays(inst_62530,inst_62531);
var inst_62533 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_62532);
var inst_62534 = (function(){throw inst_62533})();
var state_62576__$1 = state_62576;
var statearr_62609_62641 = state_62576__$1;
(statearr_62609_62641[(2)] = inst_62534);

(statearr_62609_62641[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (18))){
var state_62576__$1 = state_62576;
var statearr_62610_62642 = state_62576__$1;
(statearr_62610_62642[(2)] = null);

(statearr_62610_62642[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62577 === (8))){
var inst_62527 = (state_62576[(2)]);
var state_62576__$1 = (function (){var statearr_62611 = state_62576;
(statearr_62611[(11)] = inst_62527);

return statearr_62611;
})();
if(cljs.core.truth_(ledger)){
var statearr_62612_62643 = state_62576__$1;
(statearr_62612_62643[(1)] = (9));

} else {
var statearr_62613_62644 = state_62576__$1;
(statearr_62613_62644[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_62614 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62614[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_62614[(1)] = (1));

return statearr_62614;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_62576){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62576);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62615){var ex__2736__auto__ = e62615;
var statearr_62616_62645 = state_62576;
(statearr_62616_62645[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62576[(4)]))){
var statearr_62617_62646 = state_62576;
(statearr_62617_62646[(1)] = cljs.core.first((state_62576[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62647 = state_62576;
state_62576 = G__62647;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_62576){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_62576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62618 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62618[(6)] = c__2755__auto__);

return statearr_62618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__62649 = arguments.length;
switch (G__62649) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_62684){
var state_val_62685 = (state_62684[(1)]);
if((state_val_62685 === (1))){
var state_62684__$1 = state_62684;
var statearr_62686_62708 = state_62684__$1;
(statearr_62686_62708[(2)] = null);

(statearr_62686_62708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62685 === (2))){
var _ = (function (){var statearr_62687 = state_62684;
(statearr_62687[(4)] = cljs.core.cons((5),(state_62684[(4)])));

return statearr_62687;
})();
var inst_62658 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_62684__$1 = state_62684;
if(cljs.core.truth_(inst_62658)){
var statearr_62688_62709 = state_62684__$1;
(statearr_62688_62709[(1)] = (6));

} else {
var statearr_62689_62710 = state_62684__$1;
(statearr_62689_62710[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62685 === (3))){
var inst_62682 = (state_62684[(2)]);
var state_62684__$1 = state_62684;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62684__$1,inst_62682);
} else {
if((state_val_62685 === (4))){
var inst_62650 = (state_62684[(2)]);
var inst_62651 = cljs.core.clj__GT_js(inst_62650);
var inst_62652 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_62651) : reject.call(null,inst_62651));
var state_62684__$1 = state_62684;
var statearr_62691_62711 = state_62684__$1;
(statearr_62691_62711[(2)] = inst_62652);

(statearr_62691_62711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62685 === (5))){
var _ = (function (){var statearr_62692 = state_62684;
(statearr_62692[(4)] = cljs.core.rest((state_62684[(4)])));

return statearr_62692;
})();
var state_62684__$1 = state_62684;
var ex62690 = (state_62684__$1[(2)]);
var statearr_62693_62712 = state_62684__$1;
(statearr_62693_62712[(5)] = ex62690);


var statearr_62694_62713 = state_62684__$1;
(statearr_62694_62713[(1)] = (4));

(statearr_62694_62713[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62685 === (6))){
var state_62684__$1 = state_62684;
var statearr_62695_62714 = state_62684__$1;
(statearr_62695_62714[(2)] = null);

(statearr_62695_62714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62685 === (7))){
var inst_62661 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62662 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62663 = cljs.core.PersistentHashMap.fromArrays(inst_62661,inst_62662);
var inst_62664 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_62663);
var inst_62665 = (function(){throw inst_62664})();
var state_62684__$1 = state_62684;
var statearr_62696_62715 = state_62684__$1;
(statearr_62696_62715[(2)] = inst_62665);

(statearr_62696_62715[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62685 === (8))){
var inst_62667 = (state_62684[(2)]);
var inst_62668 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62669 = [jwt,expire];
var inst_62670 = cljs.core.PersistentHashMap.fromArrays(inst_62668,inst_62669);
var inst_62671 = fluree.db.util.core.without_nils(inst_62670);
var inst_62672 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_62673 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62675 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_62671,inst_62672,null];
var inst_62676 = (new cljs.core.PersistentVector(null,4,(5),inst_62674,inst_62675,null));
var inst_62677 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62673,inst_62676);
var inst_62678 = (function (){var _ = inst_62667;
var data = inst_62671;
var pc = inst_62672;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__62697 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__62697) : reject.call(null,G__62697));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__62698 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__62698) : resolve.call(null,G__62698));

}
});
})();
var inst_62679 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_62672,inst_62678);
var _ = (function (){var statearr_62699 = state_62684;
(statearr_62699[(4)] = cljs.core.rest((state_62684[(4)])));

return statearr_62699;
})();
var state_62684__$1 = (function (){var statearr_62700 = state_62684;
(statearr_62700[(7)] = inst_62677);

return statearr_62700;
})();
var statearr_62701_62716 = state_62684__$1;
(statearr_62701_62716[(2)] = inst_62679);

(statearr_62701_62716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2733__auto__ = null;
var fluree$db$connection_js$state_machine__2733__auto____0 = (function (){
var statearr_62702 = [null,null,null,null,null,null,null,null];
(statearr_62702[(0)] = fluree$db$connection_js$state_machine__2733__auto__);

(statearr_62702[(1)] = (1));

return statearr_62702;
});
var fluree$db$connection_js$state_machine__2733__auto____1 = (function (state_62684){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_62684);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e62703){var ex__2736__auto__ = e62703;
var statearr_62704_62717 = state_62684;
(statearr_62704_62717[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_62684[(4)]))){
var statearr_62705_62718 = state_62684;
(statearr_62705_62718[(1)] = cljs.core.first((state_62684[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62719 = state_62684;
state_62684 = G__62719;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2733__auto__ = function(state_62684){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2733__auto____1.call(this,state_62684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2733__auto____0;
fluree$db$connection_js$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2733__auto____1;
return fluree$db$connection_js$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_62706 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_62706[(6)] = c__2755__auto__);

return statearr_62706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

