// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___52631 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_52682){
var state_val_52683 = (state_52682[(1)]);
if((state_val_52683 === (7))){
var inst_52677 = (state_52682[(2)]);
var _ = (function (){var statearr_52684 = state_52682;
(statearr_52684[(4)] = cljs.core.rest((state_52682[(4)])));

return statearr_52684;
})();
var state_52682__$1 = state_52682;
var statearr_52685_52712 = state_52682__$1;
(statearr_52685_52712[(2)] = inst_52677);

(statearr_52685_52712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (1))){
var state_52682__$1 = state_52682;
var statearr_52686_52713 = state_52682__$1;
(statearr_52686_52713[(2)] = null);

(statearr_52686_52713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (4))){
var inst_52632 = (state_52682[(2)]);
var state_52682__$1 = state_52682;
var statearr_52687_52714 = state_52682__$1;
(statearr_52687_52714[(2)] = inst_52632);

(statearr_52687_52714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (13))){
var inst_52673 = (state_52682[(2)]);
var state_52682__$1 = state_52682;
var statearr_52688_52715 = state_52682__$1;
(statearr_52688_52715[(2)] = inst_52673);

(statearr_52688_52715[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (6))){
var inst_52650 = (state_52682[(7)]);
var inst_52657 = (state_52682[(8)]);
var inst_52656 = cljs.core.seq(inst_52650);
var inst_52657__$1 = cljs.core.first(inst_52656);
var inst_52658 = cljs.core.next(inst_52656);
var inst_52659 = cljs.core.not(inst_52657__$1);
var state_52682__$1 = (function (){var statearr_52689 = state_52682;
(statearr_52689[(8)] = inst_52657__$1);

(statearr_52689[(9)] = inst_52658);

return statearr_52689;
})();
if(inst_52659){
var statearr_52690_52716 = state_52682__$1;
(statearr_52690_52716[(1)] = (8));

} else {
var statearr_52691_52717 = state_52682__$1;
(statearr_52691_52717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (3))){
var inst_52680 = (state_52682[(2)]);
var state_52682__$1 = state_52682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52682__$1,inst_52680);
} else {
if((state_val_52683 === (12))){
var inst_52651 = (state_52682[(10)]);
var inst_52657 = (state_52682[(8)]);
var inst_52658 = (state_52682[(9)]);
var inst_52670 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_52651,inst_52657);
var inst_52650 = inst_52658;
var inst_52651__$1 = inst_52670;
var state_52682__$1 = (function (){var statearr_52692 = state_52682;
(statearr_52692[(10)] = inst_52651__$1);

(statearr_52692[(7)] = inst_52650);

return statearr_52692;
})();
var statearr_52693_52718 = state_52682__$1;
(statearr_52693_52718[(2)] = null);

(statearr_52693_52718[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (2))){
var _ = (function (){var statearr_52694 = state_52682;
(statearr_52694[(4)] = cljs.core.cons((5),(state_52682[(4)])));

return statearr_52694;
})();
var inst_52645 = args;
var inst_52646 = cljs.core.seq(inst_52645);
var inst_52647 = cljs.core.first(inst_52646);
var inst_52648 = cljs.core.next(inst_52646);
var inst_52649 = cljs.core.PersistentVector.EMPTY;
var inst_52650 = inst_52645;
var inst_52651 = inst_52649;
var state_52682__$1 = (function (){var statearr_52695 = state_52682;
(statearr_52695[(10)] = inst_52651);

(statearr_52695[(7)] = inst_52650);

(statearr_52695[(11)] = inst_52648);

(statearr_52695[(12)] = inst_52647);

return statearr_52695;
})();
var statearr_52696_52719 = state_52682__$1;
(statearr_52696_52719[(2)] = null);

(statearr_52696_52719[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (11))){
var inst_52657 = (state_52682[(8)]);
var state_52682__$1 = state_52682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52682__$1,(14),inst_52657);
} else {
if((state_val_52683 === (9))){
var inst_52657 = (state_52682[(8)]);
var inst_52662 = fluree.db.util.async.channel_QMARK_(inst_52657);
var state_52682__$1 = state_52682;
if(inst_52662){
var statearr_52698_52720 = state_52682__$1;
(statearr_52698_52720[(1)] = (11));

} else {
var statearr_52699_52721 = state_52682__$1;
(statearr_52699_52721[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (5))){
var _ = (function (){var statearr_52700 = state_52682;
(statearr_52700[(4)] = cljs.core.rest((state_52682[(4)])));

return statearr_52700;
})();
var state_52682__$1 = state_52682;
var ex52697 = (state_52682__$1[(2)]);
var statearr_52701_52722 = state_52682__$1;
(statearr_52701_52722[(5)] = ex52697);


if((ex52697 instanceof Error)){
var statearr_52702_52723 = state_52682__$1;
(statearr_52702_52723[(1)] = (4));

(statearr_52702_52723[(5)] = null);

} else {
throw ex52697;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (14))){
var inst_52651 = (state_52682[(10)]);
var inst_52658 = (state_52682[(9)]);
var inst_52665 = (state_52682[(2)]);
var inst_52666 = fluree.db.util.async.throw_err(inst_52665);
var inst_52667 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_52651,inst_52666);
var inst_52650 = inst_52658;
var inst_52651__$1 = inst_52667;
var state_52682__$1 = (function (){var statearr_52703 = state_52682;
(statearr_52703[(10)] = inst_52651__$1);

(statearr_52703[(7)] = inst_52650);

return statearr_52703;
})();
var statearr_52704_52724 = state_52682__$1;
(statearr_52704_52724[(2)] = null);

(statearr_52704_52724[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (10))){
var inst_52675 = (state_52682[(2)]);
var state_52682__$1 = state_52682;
var statearr_52705_52725 = state_52682__$1;
(statearr_52705_52725[(2)] = inst_52675);

(statearr_52705_52725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52683 === (8))){
var inst_52651 = (state_52682[(10)]);
var state_52682__$1 = state_52682;
var statearr_52706_52726 = state_52682__$1;
(statearr_52706_52726[(2)] = inst_52651);

(statearr_52706_52726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____0 = (function (){
var statearr_52707 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52707[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__);

(statearr_52707[(1)] = (1));

return statearr_52707;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____1 = (function (state_52682){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_52682);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e52708){var ex__2736__auto__ = e52708;
var statearr_52709_52727 = state_52682;
(statearr_52709_52727[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_52682[(4)]))){
var statearr_52710_52728 = state_52682;
(statearr_52710_52728[(1)] = cljs.core.first((state_52682[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52729 = state_52682;
state_52682 = G__52729;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__ = function(state_52682){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____1.call(this,state_52682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_52711 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_52711[(6)] = c__2755__auto__);

return statearr_52711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__52730 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52730,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52730,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_52778){
var state_val_52779 = (state_52778[(1)]);
if((state_val_52779 === (7))){
var state_52778__$1 = state_52778;
var statearr_52780_52809 = state_52778__$1;
(statearr_52780_52809[(2)] = coll);

(statearr_52780_52809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (1))){
var state_52778__$1 = state_52778;
var statearr_52781_52810 = state_52778__$1;
(statearr_52781_52810[(2)] = null);

(statearr_52781_52810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (4))){
var inst_52733 = (state_52778[(2)]);
var state_52778__$1 = state_52778;
var statearr_52782_52811 = state_52778__$1;
(statearr_52782_52811[(2)] = inst_52733);

(statearr_52782_52811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (15))){
var inst_52752 = (state_52778[(7)]);
var inst_52760 = (state_52778[(2)]);
var inst_52761 = fluree.db.dbfunctions.internal.nth(inst_52752,inst_52760);
var inst_52762 = cljs.core.count(inst_52752);
var inst_52763 = ((9) + inst_52762);
var inst_52764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52765 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_52766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52767 = [inst_52752,inst_52760];
var inst_52768 = (new cljs.core.PersistentVector(null,2,(5),inst_52766,inst_52767,null));
var inst_52769 = ["nth",inst_52768,inst_52761];
var inst_52770 = cljs.core.PersistentHashMap.fromArrays(inst_52765,inst_52769);
var inst_52771 = [inst_52770,inst_52763];
var inst_52772 = (new cljs.core.PersistentVector(null,2,(5),inst_52764,inst_52771,null));
var inst_52773 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_52772);
var _ = (function (){var statearr_52783 = state_52778;
(statearr_52783[(4)] = cljs.core.rest((state_52778[(4)])));

return statearr_52783;
})();
var state_52778__$1 = (function (){var statearr_52784 = state_52778;
(statearr_52784[(8)] = inst_52773);

return statearr_52784;
})();
var statearr_52785_52812 = state_52778__$1;
(statearr_52785_52812[(2)] = inst_52761);

(statearr_52785_52812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (13))){
var state_52778__$1 = state_52778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52778__$1,(16),key);
} else {
if((state_val_52779 === (6))){
var state_52778__$1 = state_52778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52778__$1,(9),coll);
} else {
if((state_val_52779 === (3))){
var inst_52776 = (state_52778[(2)]);
var state_52778__$1 = state_52778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52778__$1,inst_52776);
} else {
if((state_val_52779 === (12))){
var inst_52752 = (state_52778[(2)]);
var inst_52753 = fluree.db.util.async.channel_QMARK_(key);
var state_52778__$1 = (function (){var statearr_52786 = state_52778;
(statearr_52786[(7)] = inst_52752);

return statearr_52786;
})();
if(inst_52753){
var statearr_52787_52813 = state_52778__$1;
(statearr_52787_52813[(1)] = (13));

} else {
var statearr_52788_52814 = state_52778__$1;
(statearr_52788_52814[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (2))){
var _ = (function (){var statearr_52789 = state_52778;
(statearr_52789[(4)] = cljs.core.cons((5),(state_52778[(4)])));

return statearr_52789;
})();
var inst_52739 = fluree.db.util.async.channel_QMARK_(coll);
var state_52778__$1 = state_52778;
if(inst_52739){
var statearr_52790_52815 = state_52778__$1;
(statearr_52790_52815[(1)] = (6));

} else {
var statearr_52791_52816 = state_52778__$1;
(statearr_52791_52816[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (11))){
var inst_52746 = (state_52778[(9)]);
var state_52778__$1 = state_52778;
var statearr_52793_52817 = state_52778__$1;
(statearr_52793_52817[(2)] = inst_52746);

(statearr_52793_52817[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (9))){
var inst_52742 = (state_52778[(2)]);
var inst_52743 = fluree.db.util.async.throw_err(inst_52742);
var state_52778__$1 = state_52778;
var statearr_52794_52818 = state_52778__$1;
(statearr_52794_52818[(2)] = inst_52743);

(statearr_52794_52818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (5))){
var _ = (function (){var statearr_52795 = state_52778;
(statearr_52795[(4)] = cljs.core.rest((state_52778[(4)])));

return statearr_52795;
})();
var state_52778__$1 = state_52778;
var ex52792 = (state_52778__$1[(2)]);
var statearr_52796_52819 = state_52778__$1;
(statearr_52796_52819[(5)] = ex52792);


if((ex52792 instanceof Error)){
var statearr_52797_52820 = state_52778__$1;
(statearr_52797_52820[(1)] = (4));

(statearr_52797_52820[(5)] = null);

} else {
throw ex52792;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (14))){
var state_52778__$1 = state_52778;
var statearr_52798_52821 = state_52778__$1;
(statearr_52798_52821[(2)] = key);

(statearr_52798_52821[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (16))){
var inst_52756 = (state_52778[(2)]);
var inst_52757 = fluree.db.util.async.throw_err(inst_52756);
var state_52778__$1 = state_52778;
var statearr_52799_52822 = state_52778__$1;
(statearr_52799_52822[(2)] = inst_52757);

(statearr_52799_52822[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (10))){
var inst_52746 = (state_52778[(9)]);
var inst_52749 = cljs.core.vec(inst_52746);
var state_52778__$1 = state_52778;
var statearr_52800_52823 = state_52778__$1;
(statearr_52800_52823[(2)] = inst_52749);

(statearr_52800_52823[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52779 === (8))){
var inst_52746 = (state_52778[(9)]);
var inst_52746__$1 = (state_52778[(2)]);
var inst_52747 = cljs.core.set_QMARK_(inst_52746__$1);
var state_52778__$1 = (function (){var statearr_52801 = state_52778;
(statearr_52801[(9)] = inst_52746__$1);

return statearr_52801;
})();
if(inst_52747){
var statearr_52802_52824 = state_52778__$1;
(statearr_52802_52824[(1)] = (10));

} else {
var statearr_52803_52825 = state_52778__$1;
(statearr_52803_52825[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____0 = (function (){
var statearr_52804 = [null,null,null,null,null,null,null,null,null,null];
(statearr_52804[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__);

(statearr_52804[(1)] = (1));

return statearr_52804;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____1 = (function (state_52778){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_52778);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e52805){var ex__2736__auto__ = e52805;
var statearr_52806_52826 = state_52778;
(statearr_52806_52826[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_52778[(4)]))){
var statearr_52807_52827 = state_52778;
(statearr_52807_52827[(1)] = cljs.core.first((state_52778[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52828 = state_52778;
state_52778 = G__52828;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__ = function(state_52778){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____1.call(this,state_52778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_52808 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_52808[(6)] = c__2755__auto__);

return statearr_52808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_52889){
var state_val_52890 = (state_52889[(1)]);
if((state_val_52890 === (7))){
var state_52889__$1 = state_52889;
var statearr_52891_52925 = state_52889__$1;
(statearr_52891_52925[(2)] = test);

(statearr_52891_52925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (20))){
var inst_52863 = (state_52889[(2)]);
var inst_52864 = fluree.db.util.async.throw_err(inst_52863);
var state_52889__$1 = state_52889;
var statearr_52892_52926 = state_52889__$1;
(statearr_52892_52926[(2)] = inst_52864);

(statearr_52892_52926[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (1))){
var state_52889__$1 = state_52889;
var statearr_52893_52927 = state_52889__$1;
(statearr_52893_52927[(2)] = null);

(statearr_52893_52927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (4))){
var inst_52829 = (state_52889[(2)]);
var state_52889__$1 = state_52889;
var statearr_52894_52928 = state_52889__$1;
(statearr_52894_52928[(2)] = inst_52829);

(statearr_52894_52928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (15))){
var inst_52847 = (state_52889[(7)]);
var inst_52855 = (state_52889[(2)]);
var inst_52856 = [inst_52855,f];
var inst_52857 = (new cljs.core.PersistentVector(null,2,(5),inst_52847,inst_52856,null));
var state_52889__$1 = state_52889;
var statearr_52895_52929 = state_52889__$1;
(statearr_52895_52929[(2)] = inst_52857);

(statearr_52895_52929[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (13))){
var state_52889__$1 = state_52889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52889__$1,(16),t);
} else {
if((state_val_52890 === (6))){
var state_52889__$1 = state_52889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52889__$1,(9),test);
} else {
if((state_val_52890 === (17))){
var state_52889__$1 = state_52889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52889__$1,(20),f);
} else {
if((state_val_52890 === (3))){
var inst_52887 = (state_52889[(2)]);
var state_52889__$1 = state_52889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52889__$1,inst_52887);
} else {
if((state_val_52890 === (12))){
var inst_52845 = (state_52889[(8)]);
var inst_52871 = (state_52889[(2)]);
var inst_52872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52871,(0),null);
var inst_52873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_52871,(1),null);
var inst_52874 = fluree.db.dbfunctions.internal.if_else(inst_52845,inst_52872,inst_52873);
var inst_52875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52876 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_52877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52878 = [inst_52845,inst_52872,inst_52873];
var inst_52879 = (new cljs.core.PersistentVector(null,3,(5),inst_52877,inst_52878,null));
var inst_52880 = ["if-else",inst_52879,inst_52874];
var inst_52881 = cljs.core.PersistentHashMap.fromArrays(inst_52876,inst_52880);
var inst_52882 = [inst_52881,(10)];
var inst_52883 = (new cljs.core.PersistentVector(null,2,(5),inst_52875,inst_52882,null));
var inst_52884 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_52883);
var _ = (function (){var statearr_52896 = state_52889;
(statearr_52896[(4)] = cljs.core.rest((state_52889[(4)])));

return statearr_52896;
})();
var state_52889__$1 = (function (){var statearr_52897 = state_52889;
(statearr_52897[(9)] = inst_52884);

return statearr_52897;
})();
var statearr_52898_52930 = state_52889__$1;
(statearr_52898_52930[(2)] = inst_52874);

(statearr_52898_52930[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (2))){
var _ = (function (){var statearr_52899 = state_52889;
(statearr_52899[(4)] = cljs.core.cons((5),(state_52889[(4)])));

return statearr_52899;
})();
var inst_52838 = fluree.db.util.async.channel_QMARK_(test);
var state_52889__$1 = state_52889;
if(inst_52838){
var statearr_52900_52931 = state_52889__$1;
(statearr_52900_52931[(1)] = (6));

} else {
var statearr_52901_52932 = state_52889__$1;
(statearr_52901_52932[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (19))){
var inst_52859 = (state_52889[(10)]);
var inst_52867 = (state_52889[(2)]);
var inst_52868 = [f,inst_52867];
var inst_52869 = (new cljs.core.PersistentVector(null,2,(5),inst_52859,inst_52868,null));
var state_52889__$1 = state_52889;
var statearr_52902_52933 = state_52889__$1;
(statearr_52902_52933[(2)] = inst_52869);

(statearr_52902_52933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (11))){
var inst_52859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52860 = fluree.db.util.async.channel_QMARK_(f);
var state_52889__$1 = (function (){var statearr_52904 = state_52889;
(statearr_52904[(10)] = inst_52859);

return statearr_52904;
})();
if(inst_52860){
var statearr_52905_52934 = state_52889__$1;
(statearr_52905_52934[(1)] = (17));

} else {
var statearr_52906_52935 = state_52889__$1;
(statearr_52906_52935[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (9))){
var inst_52841 = (state_52889[(2)]);
var inst_52842 = fluree.db.util.async.throw_err(inst_52841);
var state_52889__$1 = state_52889;
var statearr_52907_52936 = state_52889__$1;
(statearr_52907_52936[(2)] = inst_52842);

(statearr_52907_52936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (5))){
var _ = (function (){var statearr_52908 = state_52889;
(statearr_52908[(4)] = cljs.core.rest((state_52889[(4)])));

return statearr_52908;
})();
var state_52889__$1 = state_52889;
var ex52903 = (state_52889__$1[(2)]);
var statearr_52909_52937 = state_52889__$1;
(statearr_52909_52937[(5)] = ex52903);


if((ex52903 instanceof Error)){
var statearr_52910_52938 = state_52889__$1;
(statearr_52910_52938[(1)] = (4));

(statearr_52910_52938[(5)] = null);

} else {
throw ex52903;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (14))){
var state_52889__$1 = state_52889;
var statearr_52911_52939 = state_52889__$1;
(statearr_52911_52939[(2)] = t);

(statearr_52911_52939[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (16))){
var inst_52851 = (state_52889[(2)]);
var inst_52852 = fluree.db.util.async.throw_err(inst_52851);
var state_52889__$1 = state_52889;
var statearr_52912_52940 = state_52889__$1;
(statearr_52912_52940[(2)] = inst_52852);

(statearr_52912_52940[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (10))){
var inst_52847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52848 = fluree.db.util.async.channel_QMARK_(t);
var state_52889__$1 = (function (){var statearr_52913 = state_52889;
(statearr_52913[(7)] = inst_52847);

return statearr_52913;
})();
if(inst_52848){
var statearr_52914_52941 = state_52889__$1;
(statearr_52914_52941[(1)] = (13));

} else {
var statearr_52915_52942 = state_52889__$1;
(statearr_52915_52942[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (18))){
var state_52889__$1 = state_52889;
var statearr_52916_52943 = state_52889__$1;
(statearr_52916_52943[(2)] = f);

(statearr_52916_52943[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52890 === (8))){
var inst_52845 = (state_52889[(8)]);
var inst_52845__$1 = (state_52889[(2)]);
var state_52889__$1 = (function (){var statearr_52917 = state_52889;
(statearr_52917[(8)] = inst_52845__$1);

return statearr_52917;
})();
if(cljs.core.truth_(inst_52845__$1)){
var statearr_52918_52944 = state_52889__$1;
(statearr_52918_52944[(1)] = (10));

} else {
var statearr_52919_52945 = state_52889__$1;
(statearr_52919_52945[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____0 = (function (){
var statearr_52920 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_52920[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__);

(statearr_52920[(1)] = (1));

return statearr_52920;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____1 = (function (state_52889){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_52889);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e52921){var ex__2736__auto__ = e52921;
var statearr_52922_52946 = state_52889;
(statearr_52922_52946[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_52889[(4)]))){
var statearr_52923_52947 = state_52889;
(statearr_52923_52947[(1)] = cljs.core.first((state_52889[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52948 = state_52889;
state_52889 = G__52948;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__ = function(state_52889){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____1.call(this,state_52889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_52924 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_52924[(6)] = c__2755__auto__);

return statearr_52924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_52978){
var state_val_52979 = (state_52978[(1)]);
if((state_val_52979 === (7))){
var state_52978__$1 = state_52978;
var statearr_52980_52999 = state_52978__$1;
(statearr_52980_52999[(2)] = arg);

(statearr_52980_52999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52979 === (1))){
var state_52978__$1 = state_52978;
var statearr_52981_53000 = state_52978__$1;
(statearr_52981_53000[(2)] = null);

(statearr_52981_53000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52979 === (4))){
var inst_52949 = (state_52978[(2)]);
var state_52978__$1 = state_52978;
var statearr_52982_53001 = state_52978__$1;
(statearr_52982_53001[(2)] = inst_52949);

(statearr_52982_53001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52979 === (6))){
var state_52978__$1 = state_52978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52978__$1,(9),arg);
} else {
if((state_val_52979 === (3))){
var inst_52976 = (state_52978[(2)]);
var state_52978__$1 = state_52978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52978__$1,inst_52976);
} else {
if((state_val_52979 === (2))){
var _ = (function (){var statearr_52984 = state_52978;
(statearr_52984[(4)] = cljs.core.cons((5),(state_52978[(4)])));

return statearr_52984;
})();
var inst_52955 = fluree.db.util.async.channel_QMARK_(arg);
var state_52978__$1 = state_52978;
if(inst_52955){
var statearr_52985_53002 = state_52978__$1;
(statearr_52985_53002[(1)] = (6));

} else {
var statearr_52986_53003 = state_52978__$1;
(statearr_52986_53003[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52979 === (9))){
var inst_52958 = (state_52978[(2)]);
var inst_52959 = fluree.db.util.async.throw_err(inst_52958);
var state_52978__$1 = state_52978;
var statearr_52987_53004 = state_52978__$1;
(statearr_52987_53004[(2)] = inst_52959);

(statearr_52987_53004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52979 === (5))){
var _ = (function (){var statearr_52988 = state_52978;
(statearr_52988[(4)] = cljs.core.rest((state_52978[(4)])));

return statearr_52988;
})();
var state_52978__$1 = state_52978;
var ex52983 = (state_52978__$1[(2)]);
var statearr_52989_53005 = state_52978__$1;
(statearr_52989_53005[(5)] = ex52983);


if((ex52983 instanceof Error)){
var statearr_52990_53006 = state_52978__$1;
(statearr_52990_53006[(1)] = (4));

(statearr_52990_53006[(5)] = null);

} else {
throw ex52983;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52979 === (8))){
var inst_52962 = (state_52978[(2)]);
var inst_52963 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_52962);
var inst_52964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52965 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_52966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52967 = [inst_52962];
var inst_52968 = (new cljs.core.PersistentVector(null,1,(5),inst_52966,inst_52967,null));
var inst_52969 = ["nil?",inst_52968,inst_52963];
var inst_52970 = cljs.core.PersistentHashMap.fromArrays(inst_52965,inst_52969);
var inst_52971 = [inst_52970,(10)];
var inst_52972 = (new cljs.core.PersistentVector(null,2,(5),inst_52964,inst_52971,null));
var inst_52973 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_52972);
var _ = (function (){var statearr_52991 = state_52978;
(statearr_52991[(4)] = cljs.core.rest((state_52978[(4)])));

return statearr_52991;
})();
var state_52978__$1 = (function (){var statearr_52992 = state_52978;
(statearr_52992[(7)] = inst_52973);

return statearr_52992;
})();
var statearr_52993_53007 = state_52978__$1;
(statearr_52993_53007[(2)] = inst_52963);

(statearr_52993_53007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_52994 = [null,null,null,null,null,null,null,null];
(statearr_52994[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__);

(statearr_52994[(1)] = (1));

return statearr_52994;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____1 = (function (state_52978){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_52978);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e52995){var ex__2736__auto__ = e52995;
var statearr_52996_53008 = state_52978;
(statearr_52996_53008[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_52978[(4)]))){
var statearr_52997_53009 = state_52978;
(statearr_52997_53009[(1)] = cljs.core.first((state_52978[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53010 = state_52978;
state_52978 = G__53010;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__ = function(state_52978){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____1.call(this,state_52978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_52998 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_52998[(6)] = c__2755__auto__);

return statearr_52998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53040){
var state_val_53041 = (state_53040[(1)]);
if((state_val_53041 === (7))){
var state_53040__$1 = state_53040;
var statearr_53042_53061 = state_53040__$1;
(statearr_53042_53061[(2)] = arg);

(statearr_53042_53061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53041 === (1))){
var state_53040__$1 = state_53040;
var statearr_53043_53062 = state_53040__$1;
(statearr_53043_53062[(2)] = null);

(statearr_53043_53062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53041 === (4))){
var inst_53011 = (state_53040[(2)]);
var state_53040__$1 = state_53040;
var statearr_53044_53063 = state_53040__$1;
(statearr_53044_53063[(2)] = inst_53011);

(statearr_53044_53063[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53041 === (6))){
var state_53040__$1 = state_53040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53040__$1,(9),arg);
} else {
if((state_val_53041 === (3))){
var inst_53038 = (state_53040[(2)]);
var state_53040__$1 = state_53040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53040__$1,inst_53038);
} else {
if((state_val_53041 === (2))){
var _ = (function (){var statearr_53046 = state_53040;
(statearr_53046[(4)] = cljs.core.cons((5),(state_53040[(4)])));

return statearr_53046;
})();
var inst_53017 = fluree.db.util.async.channel_QMARK_(arg);
var state_53040__$1 = state_53040;
if(inst_53017){
var statearr_53047_53064 = state_53040__$1;
(statearr_53047_53064[(1)] = (6));

} else {
var statearr_53048_53065 = state_53040__$1;
(statearr_53048_53065[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53041 === (9))){
var inst_53020 = (state_53040[(2)]);
var inst_53021 = fluree.db.util.async.throw_err(inst_53020);
var state_53040__$1 = state_53040;
var statearr_53049_53066 = state_53040__$1;
(statearr_53049_53066[(2)] = inst_53021);

(statearr_53049_53066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53041 === (5))){
var _ = (function (){var statearr_53050 = state_53040;
(statearr_53050[(4)] = cljs.core.rest((state_53040[(4)])));

return statearr_53050;
})();
var state_53040__$1 = state_53040;
var ex53045 = (state_53040__$1[(2)]);
var statearr_53051_53067 = state_53040__$1;
(statearr_53051_53067[(5)] = ex53045);


if((ex53045 instanceof Error)){
var statearr_53052_53068 = state_53040__$1;
(statearr_53052_53068[(1)] = (4));

(statearr_53052_53068[(5)] = null);

} else {
throw ex53045;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53041 === (8))){
var inst_53024 = (state_53040[(2)]);
var inst_53025 = fluree.db.dbfunctions.internal.not(inst_53024);
var inst_53026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53027 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53029 = [inst_53024];
var inst_53030 = (new cljs.core.PersistentVector(null,1,(5),inst_53028,inst_53029,null));
var inst_53031 = ["not?",inst_53030,inst_53025];
var inst_53032 = cljs.core.PersistentHashMap.fromArrays(inst_53027,inst_53031);
var inst_53033 = [inst_53032,(10)];
var inst_53034 = (new cljs.core.PersistentVector(null,2,(5),inst_53026,inst_53033,null));
var inst_53035 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53034);
var _ = (function (){var statearr_53053 = state_53040;
(statearr_53053[(4)] = cljs.core.rest((state_53040[(4)])));

return statearr_53053;
})();
var state_53040__$1 = (function (){var statearr_53054 = state_53040;
(statearr_53054[(7)] = inst_53035);

return statearr_53054;
})();
var statearr_53055_53069 = state_53040__$1;
(statearr_53055_53069[(2)] = inst_53025);

(statearr_53055_53069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____0 = (function (){
var statearr_53056 = [null,null,null,null,null,null,null,null];
(statearr_53056[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__);

(statearr_53056[(1)] = (1));

return statearr_53056;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____1 = (function (state_53040){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53040);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53057){var ex__2736__auto__ = e53057;
var statearr_53058_53070 = state_53040;
(statearr_53058_53070[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53040[(4)]))){
var statearr_53059_53071 = state_53040;
(statearr_53059_53071[(1)] = cljs.core.first((state_53040[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53072 = state_53040;
state_53040 = G__53072;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__ = function(state_53040){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____1.call(this,state_53040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53060 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53060[(6)] = c__2755__auto__);

return statearr_53060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53102){
var state_val_53103 = (state_53102[(1)]);
if((state_val_53103 === (7))){
var state_53102__$1 = state_53102;
var statearr_53104_53123 = state_53102__$1;
(statearr_53104_53123[(2)] = arg);

(statearr_53104_53123[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53103 === (1))){
var state_53102__$1 = state_53102;
var statearr_53105_53124 = state_53102__$1;
(statearr_53105_53124[(2)] = null);

(statearr_53105_53124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53103 === (4))){
var inst_53073 = (state_53102[(2)]);
var state_53102__$1 = state_53102;
var statearr_53106_53125 = state_53102__$1;
(statearr_53106_53125[(2)] = inst_53073);

(statearr_53106_53125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53103 === (6))){
var state_53102__$1 = state_53102;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53102__$1,(9),arg);
} else {
if((state_val_53103 === (3))){
var inst_53100 = (state_53102[(2)]);
var state_53102__$1 = state_53102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53102__$1,inst_53100);
} else {
if((state_val_53103 === (2))){
var _ = (function (){var statearr_53108 = state_53102;
(statearr_53108[(4)] = cljs.core.cons((5),(state_53102[(4)])));

return statearr_53108;
})();
var inst_53079 = fluree.db.util.async.channel_QMARK_(arg);
var state_53102__$1 = state_53102;
if(inst_53079){
var statearr_53109_53126 = state_53102__$1;
(statearr_53109_53126[(1)] = (6));

} else {
var statearr_53110_53127 = state_53102__$1;
(statearr_53110_53127[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53103 === (9))){
var inst_53082 = (state_53102[(2)]);
var inst_53083 = fluree.db.util.async.throw_err(inst_53082);
var state_53102__$1 = state_53102;
var statearr_53111_53128 = state_53102__$1;
(statearr_53111_53128[(2)] = inst_53083);

(statearr_53111_53128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53103 === (5))){
var _ = (function (){var statearr_53112 = state_53102;
(statearr_53112[(4)] = cljs.core.rest((state_53102[(4)])));

return statearr_53112;
})();
var state_53102__$1 = state_53102;
var ex53107 = (state_53102__$1[(2)]);
var statearr_53113_53129 = state_53102__$1;
(statearr_53113_53129[(5)] = ex53107);


if((ex53107 instanceof Error)){
var statearr_53114_53130 = state_53102__$1;
(statearr_53114_53130[(1)] = (4));

(statearr_53114_53130[(5)] = null);

} else {
throw ex53107;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53103 === (8))){
var inst_53086 = (state_53102[(2)]);
var inst_53087 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_53086);
var inst_53088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53089 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53091 = [inst_53086];
var inst_53092 = (new cljs.core.PersistentVector(null,1,(5),inst_53090,inst_53091,null));
var inst_53093 = ["empty?",inst_53092,inst_53087];
var inst_53094 = cljs.core.PersistentHashMap.fromArrays(inst_53089,inst_53093);
var inst_53095 = [inst_53094,(10)];
var inst_53096 = (new cljs.core.PersistentVector(null,2,(5),inst_53088,inst_53095,null));
var inst_53097 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53096);
var _ = (function (){var statearr_53115 = state_53102;
(statearr_53115[(4)] = cljs.core.rest((state_53102[(4)])));

return statearr_53115;
})();
var state_53102__$1 = (function (){var statearr_53116 = state_53102;
(statearr_53116[(7)] = inst_53097);

return statearr_53116;
})();
var statearr_53117_53131 = state_53102__$1;
(statearr_53117_53131[(2)] = inst_53087);

(statearr_53117_53131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_53118 = [null,null,null,null,null,null,null,null];
(statearr_53118[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__);

(statearr_53118[(1)] = (1));

return statearr_53118;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____1 = (function (state_53102){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53102);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53119){var ex__2736__auto__ = e53119;
var statearr_53120_53132 = state_53102;
(statearr_53120_53132[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53102[(4)]))){
var statearr_53121_53133 = state_53102;
(statearr_53121_53133[(1)] = cljs.core.first((state_53102[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53134 = state_53102;
state_53102 = G__53134;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__ = function(state_53102){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____1.call(this,state_53102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53122 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53122[(6)] = c__2755__auto__);

return statearr_53122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___53179 = arguments.length;
var i__4830__auto___53180 = (0);
while(true){
if((i__4830__auto___53180 < len__4829__auto___53179)){
args__4835__auto__.push((arguments[i__4830__auto___53180]));

var G__53181 = (i__4830__auto___53180 + (1));
i__4830__auto___53180 = G__53181;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53162){
var state_val_53163 = (state_53162[(1)]);
if((state_val_53163 === (1))){
var state_53162__$1 = state_53162;
var statearr_53164_53182 = state_53162__$1;
(statearr_53164_53182[(2)] = null);

(statearr_53164_53182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53163 === (2))){
var _ = (function (){var statearr_53165 = state_53162;
(statearr_53165[(4)] = cljs.core.cons((5),(state_53162[(4)])));

return statearr_53165;
})();
var inst_53143 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53162__$1 = state_53162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53162__$1,(6),inst_53143);
} else {
if((state_val_53163 === (3))){
var inst_53160 = (state_53162[(2)]);
var state_53162__$1 = state_53162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53162__$1,inst_53160);
} else {
if((state_val_53163 === (4))){
var inst_53137 = (state_53162[(2)]);
var state_53162__$1 = state_53162;
var statearr_53167_53183 = state_53162__$1;
(statearr_53167_53183[(2)] = inst_53137);

(statearr_53167_53183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53163 === (5))){
var _ = (function (){var statearr_53168 = state_53162;
(statearr_53168[(4)] = cljs.core.rest((state_53162[(4)])));

return statearr_53168;
})();
var state_53162__$1 = state_53162;
var ex53166 = (state_53162__$1[(2)]);
var statearr_53169_53184 = state_53162__$1;
(statearr_53169_53184[(5)] = ex53166);


if((ex53166 instanceof Error)){
var statearr_53170_53185 = state_53162__$1;
(statearr_53170_53185[(1)] = (4));

(statearr_53170_53185[(5)] = null);

} else {
throw ex53166;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53163 === (6))){
var inst_53145 = (state_53162[(2)]);
var inst_53146 = fluree.db.util.async.throw_err(inst_53145);
var inst_53147 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_53146);
var inst_53148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53149 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53151 = [inst_53146];
var inst_53152 = (new cljs.core.PersistentVector(null,1,(5),inst_53150,inst_53151,null));
var inst_53153 = ["str",inst_53152,inst_53147];
var inst_53154 = cljs.core.PersistentHashMap.fromArrays(inst_53149,inst_53153);
var inst_53155 = [inst_53154,(10)];
var inst_53156 = (new cljs.core.PersistentVector(null,2,(5),inst_53148,inst_53155,null));
var inst_53157 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53156);
var _ = (function (){var statearr_53171 = state_53162;
(statearr_53171[(4)] = cljs.core.rest((state_53162[(4)])));

return statearr_53171;
})();
var state_53162__$1 = (function (){var statearr_53172 = state_53162;
(statearr_53172[(7)] = inst_53157);

return statearr_53172;
})();
var statearr_53173_53186 = state_53162__$1;
(statearr_53173_53186[(2)] = inst_53147);

(statearr_53173_53186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_53174 = [null,null,null,null,null,null,null,null];
(statearr_53174[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_53174[(1)] = (1));

return statearr_53174;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_53162){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53162);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53175){var ex__2736__auto__ = e53175;
var statearr_53176_53187 = state_53162;
(statearr_53176_53187[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53162[(4)]))){
var statearr_53177_53188 = state_53162;
(statearr_53177_53188[(1)] = cljs.core.first((state_53162[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53189 = state_53162;
state_53162 = G__53189;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_53162){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_53162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53178 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53178[(6)] = c__2755__auto__);

return statearr_53178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53135){
var G__53136 = cljs.core.first(seq53135);
var seq53135__$1 = cljs.core.next(seq53135);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53136,seq53135__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53215){
var state_val_53216 = (state_53215[(1)]);
if((state_val_53216 === (1))){
var state_53215__$1 = state_53215;
var statearr_53217_53232 = state_53215__$1;
(statearr_53217_53232[(2)] = null);

(statearr_53217_53232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53216 === (2))){
var _ = (function (){var statearr_53218 = state_53215;
(statearr_53218[(4)] = cljs.core.cons((5),(state_53215[(4)])));

return statearr_53218;
})();
var inst_53196 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53215__$1 = state_53215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53215__$1,(6),inst_53196);
} else {
if((state_val_53216 === (3))){
var inst_53213 = (state_53215[(2)]);
var state_53215__$1 = state_53215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53215__$1,inst_53213);
} else {
if((state_val_53216 === (4))){
var inst_53190 = (state_53215[(2)]);
var state_53215__$1 = state_53215;
var statearr_53220_53233 = state_53215__$1;
(statearr_53220_53233[(2)] = inst_53190);

(statearr_53220_53233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53216 === (5))){
var _ = (function (){var statearr_53221 = state_53215;
(statearr_53221[(4)] = cljs.core.rest((state_53215[(4)])));

return statearr_53221;
})();
var state_53215__$1 = state_53215;
var ex53219 = (state_53215__$1[(2)]);
var statearr_53222_53234 = state_53215__$1;
(statearr_53222_53234[(5)] = ex53219);


if((ex53219 instanceof Error)){
var statearr_53223_53235 = state_53215__$1;
(statearr_53223_53235[(1)] = (4));

(statearr_53223_53235[(5)] = null);

} else {
throw ex53219;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53216 === (6))){
var inst_53198 = (state_53215[(2)]);
var inst_53199 = fluree.db.util.async.throw_err(inst_53198);
var inst_53200 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_53199);
var inst_53201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53202 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53204 = [inst_53199];
var inst_53205 = (new cljs.core.PersistentVector(null,1,(5),inst_53203,inst_53204,null));
var inst_53206 = ["subs",inst_53205,inst_53200];
var inst_53207 = cljs.core.PersistentHashMap.fromArrays(inst_53202,inst_53206);
var inst_53208 = [inst_53207,(30)];
var inst_53209 = (new cljs.core.PersistentVector(null,2,(5),inst_53201,inst_53208,null));
var inst_53210 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53209);
var _ = (function (){var statearr_53224 = state_53215;
(statearr_53224[(4)] = cljs.core.rest((state_53215[(4)])));

return statearr_53224;
})();
var state_53215__$1 = (function (){var statearr_53225 = state_53215;
(statearr_53225[(7)] = inst_53210);

return statearr_53225;
})();
var statearr_53226_53236 = state_53215__$1;
(statearr_53226_53236[(2)] = inst_53200);

(statearr_53226_53236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____0 = (function (){
var statearr_53227 = [null,null,null,null,null,null,null,null];
(statearr_53227[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__);

(statearr_53227[(1)] = (1));

return statearr_53227;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____1 = (function (state_53215){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53215);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53228){var ex__2736__auto__ = e53228;
var statearr_53229_53237 = state_53215;
(statearr_53229_53237[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53215[(4)]))){
var statearr_53230_53238 = state_53215;
(statearr_53230_53238[(1)] = cljs.core.first((state_53215[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53239 = state_53215;
state_53215 = G__53239;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__ = function(state_53215){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____1.call(this,state_53215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53231 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53231[(6)] = c__2755__auto__);

return statearr_53231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53269){
var state_val_53270 = (state_53269[(1)]);
if((state_val_53270 === (7))){
var state_53269__$1 = state_53269;
var statearr_53271_53290 = state_53269__$1;
(statearr_53271_53290[(2)] = str);

(statearr_53271_53290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53270 === (1))){
var state_53269__$1 = state_53269;
var statearr_53272_53291 = state_53269__$1;
(statearr_53272_53291[(2)] = null);

(statearr_53272_53291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53270 === (4))){
var inst_53240 = (state_53269[(2)]);
var state_53269__$1 = state_53269;
var statearr_53273_53292 = state_53269__$1;
(statearr_53273_53292[(2)] = inst_53240);

(statearr_53273_53292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53270 === (6))){
var state_53269__$1 = state_53269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53269__$1,(9),str);
} else {
if((state_val_53270 === (3))){
var inst_53267 = (state_53269[(2)]);
var state_53269__$1 = state_53269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53269__$1,inst_53267);
} else {
if((state_val_53270 === (2))){
var _ = (function (){var statearr_53275 = state_53269;
(statearr_53275[(4)] = cljs.core.cons((5),(state_53269[(4)])));

return statearr_53275;
})();
var inst_53246 = fluree.db.util.async.channel_QMARK_(str);
var state_53269__$1 = state_53269;
if(inst_53246){
var statearr_53276_53293 = state_53269__$1;
(statearr_53276_53293[(1)] = (6));

} else {
var statearr_53277_53294 = state_53269__$1;
(statearr_53277_53294[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53270 === (9))){
var inst_53249 = (state_53269[(2)]);
var inst_53250 = fluree.db.util.async.throw_err(inst_53249);
var state_53269__$1 = state_53269;
var statearr_53278_53295 = state_53269__$1;
(statearr_53278_53295[(2)] = inst_53250);

(statearr_53278_53295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53270 === (5))){
var _ = (function (){var statearr_53279 = state_53269;
(statearr_53279[(4)] = cljs.core.rest((state_53269[(4)])));

return statearr_53279;
})();
var state_53269__$1 = state_53269;
var ex53274 = (state_53269__$1[(2)]);
var statearr_53280_53296 = state_53269__$1;
(statearr_53280_53296[(5)] = ex53274);


if((ex53274 instanceof Error)){
var statearr_53281_53297 = state_53269__$1;
(statearr_53281_53297[(1)] = (4));

(statearr_53281_53297[(5)] = null);

} else {
throw ex53274;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53270 === (8))){
var inst_53253 = (state_53269[(2)]);
var inst_53254 = fluree.db.dbfunctions.internal.lower_case(inst_53253);
var inst_53255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53256 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53258 = [inst_53253];
var inst_53259 = (new cljs.core.PersistentVector(null,1,(5),inst_53257,inst_53258,null));
var inst_53260 = ["lower-case",inst_53259,inst_53254];
var inst_53261 = cljs.core.PersistentHashMap.fromArrays(inst_53256,inst_53260);
var inst_53262 = [inst_53261,(10)];
var inst_53263 = (new cljs.core.PersistentVector(null,2,(5),inst_53255,inst_53262,null));
var inst_53264 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53263);
var _ = (function (){var statearr_53282 = state_53269;
(statearr_53282[(4)] = cljs.core.rest((state_53269[(4)])));

return statearr_53282;
})();
var state_53269__$1 = (function (){var statearr_53283 = state_53269;
(statearr_53283[(7)] = inst_53264);

return statearr_53283;
})();
var statearr_53284_53298 = state_53269__$1;
(statearr_53284_53298[(2)] = inst_53254);

(statearr_53284_53298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____0 = (function (){
var statearr_53285 = [null,null,null,null,null,null,null,null];
(statearr_53285[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__);

(statearr_53285[(1)] = (1));

return statearr_53285;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____1 = (function (state_53269){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53269);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53286){var ex__2736__auto__ = e53286;
var statearr_53287_53299 = state_53269;
(statearr_53287_53299[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53269[(4)]))){
var statearr_53288_53300 = state_53269;
(statearr_53288_53300[(1)] = cljs.core.first((state_53269[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53301 = state_53269;
state_53269 = G__53301;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__ = function(state_53269){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____1.call(this,state_53269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53289 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53289[(6)] = c__2755__auto__);

return statearr_53289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53331){
var state_val_53332 = (state_53331[(1)]);
if((state_val_53332 === (7))){
var state_53331__$1 = state_53331;
var statearr_53333_53352 = state_53331__$1;
(statearr_53333_53352[(2)] = str);

(statearr_53333_53352[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53332 === (1))){
var state_53331__$1 = state_53331;
var statearr_53334_53353 = state_53331__$1;
(statearr_53334_53353[(2)] = null);

(statearr_53334_53353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53332 === (4))){
var inst_53302 = (state_53331[(2)]);
var state_53331__$1 = state_53331;
var statearr_53335_53354 = state_53331__$1;
(statearr_53335_53354[(2)] = inst_53302);

(statearr_53335_53354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53332 === (6))){
var state_53331__$1 = state_53331;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53331__$1,(9),str);
} else {
if((state_val_53332 === (3))){
var inst_53329 = (state_53331[(2)]);
var state_53331__$1 = state_53331;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53331__$1,inst_53329);
} else {
if((state_val_53332 === (2))){
var _ = (function (){var statearr_53337 = state_53331;
(statearr_53337[(4)] = cljs.core.cons((5),(state_53331[(4)])));

return statearr_53337;
})();
var inst_53308 = fluree.db.util.async.channel_QMARK_(str);
var state_53331__$1 = state_53331;
if(inst_53308){
var statearr_53338_53355 = state_53331__$1;
(statearr_53338_53355[(1)] = (6));

} else {
var statearr_53339_53356 = state_53331__$1;
(statearr_53339_53356[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53332 === (9))){
var inst_53311 = (state_53331[(2)]);
var inst_53312 = fluree.db.util.async.throw_err(inst_53311);
var state_53331__$1 = state_53331;
var statearr_53340_53357 = state_53331__$1;
(statearr_53340_53357[(2)] = inst_53312);

(statearr_53340_53357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53332 === (5))){
var _ = (function (){var statearr_53341 = state_53331;
(statearr_53341[(4)] = cljs.core.rest((state_53331[(4)])));

return statearr_53341;
})();
var state_53331__$1 = state_53331;
var ex53336 = (state_53331__$1[(2)]);
var statearr_53342_53358 = state_53331__$1;
(statearr_53342_53358[(5)] = ex53336);


if((ex53336 instanceof Error)){
var statearr_53343_53359 = state_53331__$1;
(statearr_53343_53359[(1)] = (4));

(statearr_53343_53359[(5)] = null);

} else {
throw ex53336;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53332 === (8))){
var inst_53315 = (state_53331[(2)]);
var inst_53316 = fluree.db.dbfunctions.internal.upper_case(inst_53315);
var inst_53317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53318 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53320 = [inst_53315];
var inst_53321 = (new cljs.core.PersistentVector(null,1,(5),inst_53319,inst_53320,null));
var inst_53322 = ["upper-case",inst_53321,inst_53316];
var inst_53323 = cljs.core.PersistentHashMap.fromArrays(inst_53318,inst_53322);
var inst_53324 = [inst_53323,(10)];
var inst_53325 = (new cljs.core.PersistentVector(null,2,(5),inst_53317,inst_53324,null));
var inst_53326 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53325);
var _ = (function (){var statearr_53344 = state_53331;
(statearr_53344[(4)] = cljs.core.rest((state_53331[(4)])));

return statearr_53344;
})();
var state_53331__$1 = (function (){var statearr_53345 = state_53331;
(statearr_53345[(7)] = inst_53326);

return statearr_53345;
})();
var statearr_53346_53360 = state_53331__$1;
(statearr_53346_53360[(2)] = inst_53316);

(statearr_53346_53360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____0 = (function (){
var statearr_53347 = [null,null,null,null,null,null,null,null];
(statearr_53347[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__);

(statearr_53347[(1)] = (1));

return statearr_53347;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____1 = (function (state_53331){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53331);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53348){var ex__2736__auto__ = e53348;
var statearr_53349_53361 = state_53331;
(statearr_53349_53361[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53331[(4)]))){
var statearr_53350_53362 = state_53331;
(statearr_53350_53362[(1)] = cljs.core.first((state_53331[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53363 = state_53331;
state_53331 = G__53363;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__ = function(state_53331){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____1.call(this,state_53331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53351 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53351[(6)] = c__2755__auto__);

return statearr_53351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53365 = arguments.length;
switch (G__53365) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53393){
var state_val_53394 = (state_53393[(1)]);
if((state_val_53394 === (1))){
var state_53393__$1 = state_53393;
var statearr_53395_53411 = state_53393__$1;
(statearr_53395_53411[(2)] = null);

(statearr_53395_53411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53394 === (2))){
var _ = (function (){var statearr_53396 = state_53393;
(statearr_53396[(4)] = cljs.core.cons((5),(state_53393[(4)])));

return statearr_53396;
})();
var inst_53375 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_53393__$1 = state_53393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53393__$1,(6),inst_53375);
} else {
if((state_val_53394 === (3))){
var inst_53391 = (state_53393[(2)]);
var state_53393__$1 = state_53393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53393__$1,inst_53391);
} else {
if((state_val_53394 === (4))){
var inst_53366 = (state_53393[(2)]);
var state_53393__$1 = state_53393;
var statearr_53398_53412 = state_53393__$1;
(statearr_53398_53412[(2)] = inst_53366);

(statearr_53398_53412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53394 === (5))){
var _ = (function (){var statearr_53399 = state_53393;
(statearr_53399[(4)] = cljs.core.rest((state_53393[(4)])));

return statearr_53399;
})();
var state_53393__$1 = state_53393;
var ex53397 = (state_53393__$1[(2)]);
var statearr_53400_53413 = state_53393__$1;
(statearr_53400_53413[(5)] = ex53397);


if((ex53397 instanceof Error)){
var statearr_53401_53414 = state_53393__$1;
(statearr_53401_53414[(1)] = (4));

(statearr_53401_53414[(5)] = null);

} else {
throw ex53397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53394 === (6))){
var inst_53377 = (state_53393[(2)]);
var inst_53378 = fluree.db.util.async.throw_err(inst_53377);
var inst_53379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53378,(0),null);
var inst_53380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53378,(1),null);
var inst_53381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53382 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53383 = ["?s","?ctx",inst_53379];
var inst_53384 = cljs.core.PersistentHashMap.fromArrays(inst_53382,inst_53383);
var inst_53385 = ((10) + inst_53380);
var inst_53386 = [inst_53384,inst_53385];
var inst_53387 = (new cljs.core.PersistentVector(null,2,(5),inst_53381,inst_53386,null));
var inst_53388 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53387);
var _ = (function (){var statearr_53402 = state_53393;
(statearr_53402[(4)] = cljs.core.rest((state_53393[(4)])));

return statearr_53402;
})();
var state_53393__$1 = (function (){var statearr_53403 = state_53393;
(statearr_53403[(7)] = inst_53388);

return statearr_53403;
})();
var statearr_53404_53415 = state_53393__$1;
(statearr_53404_53415[(2)] = inst_53379);

(statearr_53404_53415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_53405 = [null,null,null,null,null,null,null,null];
(statearr_53405[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_53405[(1)] = (1));

return statearr_53405;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_53393){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53393);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53406){var ex__2736__auto__ = e53406;
var statearr_53407_53416 = state_53393;
(statearr_53407_53416[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53393[(4)]))){
var statearr_53408_53417 = state_53393;
(statearr_53408_53417[(1)] = cljs.core.first((state_53393[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53418 = state_53393;
state_53393 = G__53418;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_53393){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_53393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53409 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53409[(6)] = c__2755__auto__);

return statearr_53409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53420 = arguments.length;
switch (G__53420) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53458){
var state_val_53459 = (state_53458[(1)]);
if((state_val_53459 === (7))){
var inst_53451 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_53458__$1 = state_53458;
var statearr_53460_53480 = state_53458__$1;
(statearr_53460_53480[(2)] = inst_53451);

(statearr_53460_53480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53459 === (1))){
var state_53458__$1 = state_53458;
var statearr_53461_53481 = state_53458__$1;
(statearr_53461_53481[(2)] = null);

(statearr_53461_53481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53459 === (4))){
var inst_53421 = (state_53458[(2)]);
var state_53458__$1 = state_53458;
var statearr_53462_53482 = state_53458__$1;
(statearr_53462_53482[(2)] = inst_53421);

(statearr_53462_53482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53459 === (6))){
var inst_53432 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_53458__$1 = state_53458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53458__$1,(10),inst_53432);
} else {
if((state_val_53459 === (3))){
var inst_53456 = (state_53458[(2)]);
var state_53458__$1 = state_53458;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53458__$1,inst_53456);
} else {
if((state_val_53459 === (2))){
var _ = (function (){var statearr_53464 = state_53458;
(statearr_53464[(4)] = cljs.core.cons((5),(state_53458[(4)])));

return statearr_53464;
})();
var inst_53427 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53458__$1 = state_53458;
if(cljs.core.truth_(inst_53427)){
var statearr_53465_53483 = state_53458__$1;
(statearr_53465_53483[(1)] = (6));

} else {
var statearr_53466_53484 = state_53458__$1;
(statearr_53466_53484[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53459 === (9))){
var inst_53438 = (state_53458[(2)]);
var inst_53439 = fluree.db.util.async.throw_err(inst_53438);
var inst_53440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53439,(0),null);
var inst_53441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53439,(1),null);
var inst_53442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53443 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53444 = ["?p","?ctx",inst_53440];
var inst_53445 = cljs.core.PersistentHashMap.fromArrays(inst_53443,inst_53444);
var inst_53446 = ((10) + inst_53441);
var inst_53447 = [inst_53445,inst_53446];
var inst_53448 = (new cljs.core.PersistentVector(null,2,(5),inst_53442,inst_53447,null));
var inst_53449 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53448);
var state_53458__$1 = (function (){var statearr_53467 = state_53458;
(statearr_53467[(7)] = inst_53449);

return statearr_53467;
})();
var statearr_53468_53485 = state_53458__$1;
(statearr_53468_53485[(2)] = inst_53440);

(statearr_53468_53485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53459 === (5))){
var _ = (function (){var statearr_53469 = state_53458;
(statearr_53469[(4)] = cljs.core.rest((state_53458[(4)])));

return statearr_53469;
})();
var state_53458__$1 = state_53458;
var ex53463 = (state_53458__$1[(2)]);
var statearr_53470_53486 = state_53458__$1;
(statearr_53470_53486[(5)] = ex53463);


if((ex53463 instanceof Error)){
var statearr_53471_53487 = state_53458__$1;
(statearr_53471_53487[(1)] = (4));

(statearr_53471_53487[(5)] = null);

} else {
throw ex53463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53459 === (10))){
var inst_53434 = (state_53458[(2)]);
var inst_53435 = fluree.db.util.async.throw_err(inst_53434);
var inst_53436 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_53435);
var state_53458__$1 = state_53458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53458__$1,(9),inst_53436);
} else {
if((state_val_53459 === (8))){
var inst_53453 = (state_53458[(2)]);
var _ = (function (){var statearr_53472 = state_53458;
(statearr_53472[(4)] = cljs.core.rest((state_53458[(4)])));

return statearr_53472;
})();
var state_53458__$1 = state_53458;
var statearr_53473_53488 = state_53458__$1;
(statearr_53473_53488[(2)] = inst_53453);

(statearr_53473_53488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_53474 = [null,null,null,null,null,null,null,null];
(statearr_53474[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_53474[(1)] = (1));

return statearr_53474;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_53458){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53458);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53475){var ex__2736__auto__ = e53475;
var statearr_53476_53489 = state_53458;
(statearr_53476_53489[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53458[(4)]))){
var statearr_53477_53490 = state_53458;
(statearr_53477_53490[(1)] = cljs.core.first((state_53458[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53491 = state_53458;
state_53458 = G__53491;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_53458){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_53458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53478 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53478[(6)] = c__2755__auto__);

return statearr_53478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___53540 = arguments.length;
var i__4830__auto___53541 = (0);
while(true){
if((i__4830__auto___53541 < len__4829__auto___53540)){
args__4835__auto__.push((arguments[i__4830__auto___53541]));

var G__53542 = (i__4830__auto___53541 + (1));
i__4830__auto___53541 = G__53542;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53523){
var state_val_53524 = (state_53523[(1)]);
if((state_val_53524 === (1))){
var state_53523__$1 = state_53523;
var statearr_53525_53543 = state_53523__$1;
(statearr_53525_53543[(2)] = null);

(statearr_53525_53543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53524 === (2))){
var _ = (function (){var statearr_53526 = state_53523;
(statearr_53526[(4)] = cljs.core.cons((5),(state_53523[(4)])));

return statearr_53526;
})();
var inst_53500 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53523__$1 = state_53523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53523__$1,(6),inst_53500);
} else {
if((state_val_53524 === (3))){
var inst_53521 = (state_53523[(2)]);
var state_53523__$1 = state_53523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53523__$1,inst_53521);
} else {
if((state_val_53524 === (4))){
var inst_53494 = (state_53523[(2)]);
var state_53523__$1 = state_53523;
var statearr_53528_53544 = state_53523__$1;
(statearr_53528_53544[(2)] = inst_53494);

(statearr_53528_53544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53524 === (5))){
var _ = (function (){var statearr_53529 = state_53523;
(statearr_53529[(4)] = cljs.core.rest((state_53523[(4)])));

return statearr_53529;
})();
var state_53523__$1 = state_53523;
var ex53527 = (state_53523__$1[(2)]);
var statearr_53530_53545 = state_53523__$1;
(statearr_53530_53545[(5)] = ex53527);


if((ex53527 instanceof Error)){
var statearr_53531_53546 = state_53523__$1;
(statearr_53531_53546[(1)] = (4));

(statearr_53531_53546[(5)] = null);

} else {
throw ex53527;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53524 === (6))){
var inst_53502 = (state_53523[(2)]);
var inst_53503 = fluree.db.util.async.throw_err(inst_53502);
var inst_53504 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_53503);
var inst_53505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53506 = [inst_53503];
var inst_53507 = (new cljs.core.PersistentVector(null,1,(5),inst_53505,inst_53506,null));
var inst_53508 = cljs.core.count(inst_53507);
var inst_53509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53510 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53512 = [inst_53503];
var inst_53513 = (new cljs.core.PersistentVector(null,1,(5),inst_53511,inst_53512,null));
var inst_53514 = ["and",inst_53513,inst_53504];
var inst_53515 = cljs.core.PersistentHashMap.fromArrays(inst_53510,inst_53514);
var inst_53516 = [inst_53515,inst_53508];
var inst_53517 = (new cljs.core.PersistentVector(null,2,(5),inst_53509,inst_53516,null));
var inst_53518 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53517);
var _ = (function (){var statearr_53532 = state_53523;
(statearr_53532[(4)] = cljs.core.rest((state_53523[(4)])));

return statearr_53532;
})();
var state_53523__$1 = (function (){var statearr_53533 = state_53523;
(statearr_53533[(7)] = inst_53518);

return statearr_53533;
})();
var statearr_53534_53547 = state_53523__$1;
(statearr_53534_53547[(2)] = inst_53504);

(statearr_53534_53547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_53535 = [null,null,null,null,null,null,null,null];
(statearr_53535[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_53535[(1)] = (1));

return statearr_53535;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_53523){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53523);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53536){var ex__2736__auto__ = e53536;
var statearr_53537_53548 = state_53523;
(statearr_53537_53548[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53523[(4)]))){
var statearr_53538_53549 = state_53523;
(statearr_53538_53549[(1)] = cljs.core.first((state_53523[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53550 = state_53523;
state_53523 = G__53550;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_53523){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_53523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53539 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53539[(6)] = c__2755__auto__);

return statearr_53539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq53492){
var G__53493 = cljs.core.first(seq53492);
var seq53492__$1 = cljs.core.next(seq53492);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53493,seq53492__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___53599 = arguments.length;
var i__4830__auto___53600 = (0);
while(true){
if((i__4830__auto___53600 < len__4829__auto___53599)){
args__4835__auto__.push((arguments[i__4830__auto___53600]));

var G__53601 = (i__4830__auto___53600 + (1));
i__4830__auto___53600 = G__53601;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53582){
var state_val_53583 = (state_53582[(1)]);
if((state_val_53583 === (1))){
var state_53582__$1 = state_53582;
var statearr_53584_53602 = state_53582__$1;
(statearr_53584_53602[(2)] = null);

(statearr_53584_53602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53583 === (2))){
var _ = (function (){var statearr_53585 = state_53582;
(statearr_53585[(4)] = cljs.core.cons((5),(state_53582[(4)])));

return statearr_53585;
})();
var inst_53559 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53582__$1 = state_53582;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53582__$1,(6),inst_53559);
} else {
if((state_val_53583 === (3))){
var inst_53580 = (state_53582[(2)]);
var state_53582__$1 = state_53582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53582__$1,inst_53580);
} else {
if((state_val_53583 === (4))){
var inst_53553 = (state_53582[(2)]);
var state_53582__$1 = state_53582;
var statearr_53587_53603 = state_53582__$1;
(statearr_53587_53603[(2)] = inst_53553);

(statearr_53587_53603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53583 === (5))){
var _ = (function (){var statearr_53588 = state_53582;
(statearr_53588[(4)] = cljs.core.rest((state_53582[(4)])));

return statearr_53588;
})();
var state_53582__$1 = state_53582;
var ex53586 = (state_53582__$1[(2)]);
var statearr_53589_53604 = state_53582__$1;
(statearr_53589_53604[(5)] = ex53586);


if((ex53586 instanceof Error)){
var statearr_53590_53605 = state_53582__$1;
(statearr_53590_53605[(1)] = (4));

(statearr_53590_53605[(5)] = null);

} else {
throw ex53586;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53583 === (6))){
var inst_53561 = (state_53582[(2)]);
var inst_53562 = fluree.db.util.async.throw_err(inst_53561);
var inst_53563 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_53562);
var inst_53564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53565 = [inst_53562];
var inst_53566 = (new cljs.core.PersistentVector(null,1,(5),inst_53564,inst_53565,null));
var inst_53567 = cljs.core.count(inst_53566);
var inst_53568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53569 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53571 = [inst_53562];
var inst_53572 = (new cljs.core.PersistentVector(null,1,(5),inst_53570,inst_53571,null));
var inst_53573 = ["or",inst_53572,inst_53563];
var inst_53574 = cljs.core.PersistentHashMap.fromArrays(inst_53569,inst_53573);
var inst_53575 = [inst_53574,inst_53567];
var inst_53576 = (new cljs.core.PersistentVector(null,2,(5),inst_53568,inst_53575,null));
var inst_53577 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53576);
var _ = (function (){var statearr_53591 = state_53582;
(statearr_53591[(4)] = cljs.core.rest((state_53582[(4)])));

return statearr_53591;
})();
var state_53582__$1 = (function (){var statearr_53592 = state_53582;
(statearr_53592[(7)] = inst_53577);

return statearr_53592;
})();
var statearr_53593_53606 = state_53582__$1;
(statearr_53593_53606[(2)] = inst_53563);

(statearr_53593_53606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_53594 = [null,null,null,null,null,null,null,null];
(statearr_53594[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_53594[(1)] = (1));

return statearr_53594;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_53582){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53582);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53595){var ex__2736__auto__ = e53595;
var statearr_53596_53607 = state_53582;
(statearr_53596_53607[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53582[(4)]))){
var statearr_53597_53608 = state_53582;
(statearr_53597_53608[(1)] = cljs.core.first((state_53582[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53609 = state_53582;
state_53582 = G__53609;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_53582){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_53582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53598 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53598[(6)] = c__2755__auto__);

return statearr_53598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq53551){
var G__53552 = cljs.core.first(seq53551);
var seq53551__$1 = cljs.core.next(seq53551);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53552,seq53551__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53647){
var state_val_53648 = (state_53647[(1)]);
if((state_val_53648 === (7))){
var inst_53623 = fluree.db.util.async.channel_QMARK_(coll);
var state_53647__$1 = state_53647;
if(inst_53623){
var statearr_53649_53672 = state_53647__$1;
(statearr_53649_53672[(1)] = (10));

} else {
var statearr_53650_53673 = state_53647__$1;
(statearr_53650_53673[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (1))){
var state_53647__$1 = state_53647;
var statearr_53651_53674 = state_53647__$1;
(statearr_53651_53674[(2)] = null);

(statearr_53651_53674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (4))){
var inst_53610 = (state_53647[(2)]);
var state_53647__$1 = state_53647;
var statearr_53652_53675 = state_53647__$1;
(statearr_53652_53675[(2)] = inst_53610);

(statearr_53652_53675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (13))){
var inst_53626 = (state_53647[(2)]);
var inst_53627 = fluree.db.util.async.throw_err(inst_53626);
var state_53647__$1 = state_53647;
var statearr_53653_53676 = state_53647__$1;
(statearr_53653_53676[(2)] = inst_53627);

(statearr_53653_53676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (6))){
var inst_53618 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_53647__$1 = state_53647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53647__$1,(9),inst_53618);
} else {
if((state_val_53648 === (3))){
var inst_53645 = (state_53647[(2)]);
var state_53647__$1 = state_53647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53647__$1,inst_53645);
} else {
if((state_val_53648 === (12))){
var inst_53630 = (state_53647[(2)]);
var state_53647__$1 = state_53647;
var statearr_53654_53677 = state_53647__$1;
(statearr_53654_53677[(2)] = inst_53630);

(statearr_53654_53677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (2))){
var _ = (function (){var statearr_53655 = state_53647;
(statearr_53655[(4)] = cljs.core.cons((5),(state_53647[(4)])));

return statearr_53655;
})();
var inst_53616 = cljs.core.vector_QMARK_(coll);
var state_53647__$1 = state_53647;
if(inst_53616){
var statearr_53656_53678 = state_53647__$1;
(statearr_53656_53678[(1)] = (6));

} else {
var statearr_53657_53679 = state_53647__$1;
(statearr_53657_53679[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (11))){
var state_53647__$1 = state_53647;
var statearr_53659_53680 = state_53647__$1;
(statearr_53659_53680[(2)] = coll);

(statearr_53659_53680[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (9))){
var inst_53620 = (state_53647[(2)]);
var inst_53621 = fluree.db.util.async.throw_err(inst_53620);
var state_53647__$1 = state_53647;
var statearr_53660_53681 = state_53647__$1;
(statearr_53660_53681[(2)] = inst_53621);

(statearr_53660_53681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (5))){
var _ = (function (){var statearr_53661 = state_53647;
(statearr_53661[(4)] = cljs.core.rest((state_53647[(4)])));

return statearr_53661;
})();
var state_53647__$1 = state_53647;
var ex53658 = (state_53647__$1[(2)]);
var statearr_53662_53682 = state_53647__$1;
(statearr_53662_53682[(5)] = ex53658);


if((ex53658 instanceof Error)){
var statearr_53663_53683 = state_53647__$1;
(statearr_53663_53683[(1)] = (4));

(statearr_53663_53683[(5)] = null);

} else {
throw ex53658;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53648 === (10))){
var state_53647__$1 = state_53647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53647__$1,(13),coll);
} else {
if((state_val_53648 === (8))){
var inst_53632 = (state_53647[(2)]);
var inst_53633 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_53632);
var inst_53634 = cljs.core.count(inst_53633);
var inst_53635 = ((9) + inst_53634);
var inst_53636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53637 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53638 = ["count",inst_53632,inst_53634];
var inst_53639 = cljs.core.PersistentHashMap.fromArrays(inst_53637,inst_53638);
var inst_53640 = [inst_53639,inst_53635];
var inst_53641 = (new cljs.core.PersistentVector(null,2,(5),inst_53636,inst_53640,null));
var inst_53642 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53641);
var _ = (function (){var statearr_53664 = state_53647;
(statearr_53664[(4)] = cljs.core.rest((state_53647[(4)])));

return statearr_53664;
})();
var state_53647__$1 = (function (){var statearr_53665 = state_53647;
(statearr_53665[(7)] = inst_53642);

return statearr_53665;
})();
var statearr_53666_53684 = state_53647__$1;
(statearr_53666_53684[(2)] = inst_53634);

(statearr_53666_53684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____0 = (function (){
var statearr_53667 = [null,null,null,null,null,null,null,null];
(statearr_53667[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__);

(statearr_53667[(1)] = (1));

return statearr_53667;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____1 = (function (state_53647){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53647);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53668){var ex__2736__auto__ = e53668;
var statearr_53669_53685 = state_53647;
(statearr_53669_53685[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53647[(4)]))){
var statearr_53670_53686 = state_53647;
(statearr_53670_53686[(1)] = cljs.core.first((state_53647[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53687 = state_53647;
state_53647 = G__53687;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__ = function(state_53647){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____1.call(this,state_53647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53671 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53671[(6)] = c__2755__auto__);

return statearr_53671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53737){
var state_val_53738 = (state_53737[(1)]);
if((state_val_53738 === (7))){
var state_53737__$1 = state_53737;
var statearr_53739_53772 = state_53737__$1;
(statearr_53739_53772[(2)] = subject);

(statearr_53739_53772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (1))){
var state_53737__$1 = state_53737;
var statearr_53740_53773 = state_53737__$1;
(statearr_53740_53773[(2)] = null);

(statearr_53740_53773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (4))){
var inst_53688 = (state_53737[(2)]);
var state_53737__$1 = state_53737;
var statearr_53741_53774 = state_53737__$1;
(statearr_53741_53774[(2)] = inst_53688);

(statearr_53741_53774[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (15))){
var inst_53701 = (state_53737[(7)]);
var state_53737__$1 = state_53737;
var statearr_53742_53775 = state_53737__$1;
(statearr_53742_53775[(2)] = inst_53701);

(statearr_53742_53775[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (13))){
var inst_53705 = (state_53737[(2)]);
var inst_53706 = fluree.db.util.async.throw_err(inst_53705);
var state_53737__$1 = state_53737;
var statearr_53743_53776 = state_53737__$1;
(statearr_53743_53776[(2)] = inst_53706);

(statearr_53743_53776[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (6))){
var state_53737__$1 = state_53737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53737__$1,(9),subject);
} else {
if((state_val_53738 === (17))){
var inst_53701 = (state_53737[(7)]);
var inst_53715 = cljs.core.first(inst_53701);
var state_53737__$1 = state_53737;
var statearr_53744_53777 = state_53737__$1;
(statearr_53744_53777[(2)] = inst_53715);

(statearr_53744_53777[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (3))){
var inst_53735 = (state_53737[(2)]);
var state_53737__$1 = state_53737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53737__$1,inst_53735);
} else {
if((state_val_53738 === (12))){
var inst_53701 = (state_53737[(7)]);
var inst_53709 = (state_53737[(2)]);
var inst_53710 = cljs.core.vector_QMARK_(inst_53701);
var state_53737__$1 = (function (){var statearr_53745 = state_53737;
(statearr_53745[(8)] = inst_53709);

return statearr_53745;
})();
if(inst_53710){
var statearr_53746_53778 = state_53737__$1;
(statearr_53746_53778[(1)] = (14));

} else {
var statearr_53747_53779 = state_53737__$1;
(statearr_53747_53779[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (2))){
var _ = (function (){var statearr_53748 = state_53737;
(statearr_53748[(4)] = cljs.core.cons((5),(state_53737[(4)])));

return statearr_53748;
})();
var inst_53694 = fluree.db.util.async.channel_QMARK_(subject);
var state_53737__$1 = state_53737;
if(inst_53694){
var statearr_53749_53780 = state_53737__$1;
(statearr_53749_53780[(1)] = (6));

} else {
var statearr_53750_53781 = state_53737__$1;
(statearr_53750_53781[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (19))){
var inst_53718 = (state_53737[(2)]);
var state_53737__$1 = state_53737;
var statearr_53751_53782 = state_53737__$1;
(statearr_53751_53782[(2)] = inst_53718);

(statearr_53751_53782[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (11))){
var state_53737__$1 = state_53737;
var statearr_53753_53783 = state_53737__$1;
(statearr_53753_53783[(2)] = pred);

(statearr_53753_53783[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (9))){
var inst_53697 = (state_53737[(2)]);
var inst_53698 = fluree.db.util.async.throw_err(inst_53697);
var state_53737__$1 = state_53737;
var statearr_53754_53784 = state_53737__$1;
(statearr_53754_53784[(2)] = inst_53698);

(statearr_53754_53784[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (5))){
var _ = (function (){var statearr_53755 = state_53737;
(statearr_53755[(4)] = cljs.core.rest((state_53737[(4)])));

return statearr_53755;
})();
var state_53737__$1 = state_53737;
var ex53752 = (state_53737__$1[(2)]);
var statearr_53756_53785 = state_53737__$1;
(statearr_53756_53785[(5)] = ex53752);


if((ex53752 instanceof Error)){
var statearr_53757_53786 = state_53737__$1;
(statearr_53757_53786[(1)] = (4));

(statearr_53757_53786[(5)] = null);

} else {
throw ex53752;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (14))){
var inst_53701 = (state_53737[(7)]);
var inst_53712 = cljs.core.count(inst_53701);
var inst_53713 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_53712);
var state_53737__$1 = state_53737;
if(inst_53713){
var statearr_53758_53787 = state_53737__$1;
(statearr_53758_53787[(1)] = (17));

} else {
var statearr_53759_53788 = state_53737__$1;
(statearr_53759_53788[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (16))){
var inst_53701 = (state_53737[(7)]);
var inst_53709 = (state_53737[(8)]);
var inst_53721 = (state_53737[(2)]);
var inst_53722 = fluree.db.dbfunctions.internal.get(inst_53721,inst_53709);
var inst_53723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53724 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53726 = [inst_53701,inst_53709];
var inst_53727 = (new cljs.core.PersistentVector(null,2,(5),inst_53725,inst_53726,null));
var inst_53728 = ["get",inst_53727,inst_53722];
var inst_53729 = cljs.core.PersistentHashMap.fromArrays(inst_53724,inst_53728);
var inst_53730 = [inst_53729,(10)];
var inst_53731 = (new cljs.core.PersistentVector(null,2,(5),inst_53723,inst_53730,null));
var inst_53732 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53731);
var _ = (function (){var statearr_53760 = state_53737;
(statearr_53760[(4)] = cljs.core.rest((state_53737[(4)])));

return statearr_53760;
})();
var state_53737__$1 = (function (){var statearr_53761 = state_53737;
(statearr_53761[(9)] = inst_53732);

return statearr_53761;
})();
var statearr_53762_53789 = state_53737__$1;
(statearr_53762_53789[(2)] = inst_53722);

(statearr_53762_53789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (10))){
var state_53737__$1 = state_53737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53737__$1,(13),pred);
} else {
if((state_val_53738 === (18))){
var inst_53701 = (state_53737[(7)]);
var state_53737__$1 = state_53737;
var statearr_53763_53790 = state_53737__$1;
(statearr_53763_53790[(2)] = inst_53701);

(statearr_53763_53790[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53738 === (8))){
var inst_53701 = (state_53737[(2)]);
var inst_53702 = fluree.db.util.async.channel_QMARK_(pred);
var state_53737__$1 = (function (){var statearr_53764 = state_53737;
(statearr_53764[(7)] = inst_53701);

return statearr_53764;
})();
if(inst_53702){
var statearr_53765_53791 = state_53737__$1;
(statearr_53765_53791[(1)] = (10));

} else {
var statearr_53766_53792 = state_53737__$1;
(statearr_53766_53792[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____0 = (function (){
var statearr_53767 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53767[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__);

(statearr_53767[(1)] = (1));

return statearr_53767;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____1 = (function (state_53737){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53737);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53768){var ex__2736__auto__ = e53768;
var statearr_53769_53793 = state_53737;
(statearr_53769_53793[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53737[(4)]))){
var statearr_53770_53794 = state_53737;
(statearr_53770_53794[(1)] = cljs.core.first((state_53737[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53795 = state_53737;
state_53737 = G__53795;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__ = function(state_53737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____1.call(this,state_53737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53771 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53771[(6)] = c__2755__auto__);

return statearr_53771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53834){
var state_val_53835 = (state_53834[(1)]);
if((state_val_53835 === (7))){
var inst_53802 = (state_53834[(7)]);
var state_53834__$1 = state_53834;
var statearr_53836_53860 = state_53834__$1;
(statearr_53836_53860[(2)] = inst_53802);

(statearr_53836_53860[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (1))){
var state_53834__$1 = state_53834;
var statearr_53837_53861 = state_53834__$1;
(statearr_53837_53861[(2)] = null);

(statearr_53837_53861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (4))){
var inst_53796 = (state_53834[(2)]);
var state_53834__$1 = state_53834;
var statearr_53838_53862 = state_53834__$1;
(statearr_53838_53862[(2)] = inst_53796);

(statearr_53838_53862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (6))){
var inst_53804 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53834__$1 = state_53834;
var statearr_53839_53863 = state_53834__$1;
(statearr_53839_53863[(2)] = inst_53804);

(statearr_53839_53863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (3))){
var inst_53832 = (state_53834[(2)]);
var state_53834__$1 = state_53834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53834__$1,inst_53832);
} else {
if((state_val_53835 === (12))){
var inst_53814 = (state_53834[(2)]);
var inst_53815 = fluree.db.util.async.throw_err(inst_53814);
var inst_53816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53815,(0),null);
var inst_53817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53815,(1),null);
var inst_53818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53819 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53820 = ["?pO","?ctx",inst_53816];
var inst_53821 = cljs.core.PersistentHashMap.fromArrays(inst_53819,inst_53820);
var inst_53822 = ((10) + inst_53817);
var inst_53823 = [inst_53821,inst_53822];
var inst_53824 = (new cljs.core.PersistentVector(null,2,(5),inst_53818,inst_53823,null));
var inst_53825 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53824);
var state_53834__$1 = (function (){var statearr_53840 = state_53834;
(statearr_53840[(8)] = inst_53825);

return statearr_53840;
})();
var statearr_53841_53864 = state_53834__$1;
(statearr_53841_53864[(2)] = inst_53816);

(statearr_53841_53864[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (2))){
var inst_53802 = (state_53834[(7)]);
var _ = (function (){var statearr_53842 = state_53834;
(statearr_53842[(4)] = cljs.core.cons((5),(state_53834[(4)])));

return statearr_53842;
})();
var inst_53802__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53834__$1 = (function (){var statearr_53843 = state_53834;
(statearr_53843[(7)] = inst_53802__$1);

return statearr_53843;
})();
if(cljs.core.truth_(inst_53802__$1)){
var statearr_53844_53865 = state_53834__$1;
(statearr_53844_53865[(1)] = (6));

} else {
var statearr_53845_53866 = state_53834__$1;
(statearr_53845_53866[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (11))){
var inst_53829 = (state_53834[(2)]);
var _ = (function (){var statearr_53847 = state_53834;
(statearr_53847[(4)] = cljs.core.rest((state_53834[(4)])));

return statearr_53847;
})();
var state_53834__$1 = state_53834;
var statearr_53848_53867 = state_53834__$1;
(statearr_53848_53867[(2)] = inst_53829);

(statearr_53848_53867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (9))){
var inst_53812 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_53834__$1 = state_53834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53834__$1,(12),inst_53812);
} else {
if((state_val_53835 === (5))){
var _ = (function (){var statearr_53849 = state_53834;
(statearr_53849[(4)] = cljs.core.rest((state_53834[(4)])));

return statearr_53849;
})();
var state_53834__$1 = state_53834;
var ex53846 = (state_53834__$1[(2)]);
var statearr_53850_53868 = state_53834__$1;
(statearr_53850_53868[(5)] = ex53846);


if((ex53846 instanceof Error)){
var statearr_53851_53869 = state_53834__$1;
(statearr_53851_53869[(1)] = (4));

(statearr_53851_53869[(5)] = null);

} else {
throw ex53846;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (10))){
var inst_53827 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_53834__$1 = state_53834;
var statearr_53852_53870 = state_53834__$1;
(statearr_53852_53870[(2)] = inst_53827);

(statearr_53852_53870[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53835 === (8))){
var inst_53807 = (state_53834[(2)]);
var state_53834__$1 = state_53834;
if(cljs.core.truth_(inst_53807)){
var statearr_53853_53871 = state_53834__$1;
(statearr_53853_53871[(1)] = (9));

} else {
var statearr_53854_53872 = state_53834__$1;
(statearr_53854_53872[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____0 = (function (){
var statearr_53855 = [null,null,null,null,null,null,null,null,null];
(statearr_53855[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__);

(statearr_53855[(1)] = (1));

return statearr_53855;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____1 = (function (state_53834){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53834);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53856){var ex__2736__auto__ = e53856;
var statearr_53857_53873 = state_53834;
(statearr_53857_53873[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53834[(4)]))){
var statearr_53858_53874 = state_53834;
(statearr_53858_53874[(1)] = cljs.core.first((state_53834[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53875 = state_53834;
state_53834 = G__53875;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__ = function(state_53834){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____1.call(this,state_53834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53859 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53859[(6)] = c__2755__auto__);

return statearr_53859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_53927){
var state_val_53928 = (state_53927[(1)]);
if((state_val_53928 === (7))){
var state_53927__$1 = state_53927;
var statearr_53929_53962 = state_53927__$1;
(statearr_53929_53962[(2)] = subject);

(statearr_53929_53962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (1))){
var state_53927__$1 = state_53927;
var statearr_53930_53963 = state_53927__$1;
(statearr_53930_53963[(2)] = null);

(statearr_53930_53963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (4))){
var inst_53876 = (state_53927[(2)]);
var state_53927__$1 = state_53927;
var statearr_53931_53964 = state_53927__$1;
(statearr_53931_53964[(2)] = inst_53876);

(statearr_53931_53964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (15))){
var inst_53889 = (state_53927[(7)]);
var state_53927__$1 = state_53927;
var statearr_53932_53965 = state_53927__$1;
(statearr_53932_53965[(2)] = inst_53889);

(statearr_53932_53965[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (13))){
var inst_53893 = (state_53927[(2)]);
var inst_53894 = fluree.db.util.async.throw_err(inst_53893);
var state_53927__$1 = state_53927;
var statearr_53933_53966 = state_53927__$1;
(statearr_53933_53966[(2)] = inst_53894);

(statearr_53933_53966[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (6))){
var state_53927__$1 = state_53927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53927__$1,(9),subject);
} else {
if((state_val_53928 === (17))){
var inst_53889 = (state_53927[(7)]);
var inst_53903 = cljs.core.first(inst_53889);
var state_53927__$1 = state_53927;
var statearr_53934_53967 = state_53927__$1;
(statearr_53934_53967[(2)] = inst_53903);

(statearr_53934_53967[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (3))){
var inst_53925 = (state_53927[(2)]);
var state_53927__$1 = state_53927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53927__$1,inst_53925);
} else {
if((state_val_53928 === (12))){
var inst_53889 = (state_53927[(7)]);
var inst_53897 = (state_53927[(2)]);
var inst_53898 = cljs.core.vector_QMARK_(inst_53889);
var state_53927__$1 = (function (){var statearr_53935 = state_53927;
(statearr_53935[(8)] = inst_53897);

return statearr_53935;
})();
if(inst_53898){
var statearr_53936_53968 = state_53927__$1;
(statearr_53936_53968[(1)] = (14));

} else {
var statearr_53937_53969 = state_53927__$1;
(statearr_53937_53969[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (2))){
var _ = (function (){var statearr_53938 = state_53927;
(statearr_53938[(4)] = cljs.core.cons((5),(state_53927[(4)])));

return statearr_53938;
})();
var inst_53882 = fluree.db.util.async.channel_QMARK_(subject);
var state_53927__$1 = state_53927;
if(inst_53882){
var statearr_53939_53970 = state_53927__$1;
(statearr_53939_53970[(1)] = (6));

} else {
var statearr_53940_53971 = state_53927__$1;
(statearr_53940_53971[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (19))){
var inst_53906 = (state_53927[(2)]);
var state_53927__$1 = state_53927;
var statearr_53941_53972 = state_53927__$1;
(statearr_53941_53972[(2)] = inst_53906);

(statearr_53941_53972[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (11))){
var state_53927__$1 = state_53927;
var statearr_53943_53973 = state_53927__$1;
(statearr_53943_53973[(2)] = path);

(statearr_53943_53973[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (9))){
var inst_53885 = (state_53927[(2)]);
var inst_53886 = fluree.db.util.async.throw_err(inst_53885);
var state_53927__$1 = state_53927;
var statearr_53944_53974 = state_53927__$1;
(statearr_53944_53974[(2)] = inst_53886);

(statearr_53944_53974[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (5))){
var _ = (function (){var statearr_53945 = state_53927;
(statearr_53945[(4)] = cljs.core.rest((state_53927[(4)])));

return statearr_53945;
})();
var state_53927__$1 = state_53927;
var ex53942 = (state_53927__$1[(2)]);
var statearr_53946_53975 = state_53927__$1;
(statearr_53946_53975[(5)] = ex53942);


if((ex53942 instanceof Error)){
var statearr_53947_53976 = state_53927__$1;
(statearr_53947_53976[(1)] = (4));

(statearr_53947_53976[(5)] = null);

} else {
throw ex53942;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (14))){
var inst_53889 = (state_53927[(7)]);
var inst_53900 = cljs.core.count(inst_53889);
var inst_53901 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_53900);
var state_53927__$1 = state_53927;
if(inst_53901){
var statearr_53948_53977 = state_53927__$1;
(statearr_53948_53977[(1)] = (17));

} else {
var statearr_53949_53978 = state_53927__$1;
(statearr_53949_53978[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (16))){
var inst_53897 = (state_53927[(8)]);
var inst_53889 = (state_53927[(7)]);
var inst_53909 = (state_53927[(2)]);
var inst_53910 = fluree.db.dbfunctions.internal.get_all(inst_53909,inst_53897);
var inst_53911 = cljs.core.count(inst_53897);
var inst_53912 = ((9) + inst_53911);
var inst_53913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53914 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53916 = [inst_53889,inst_53897];
var inst_53917 = (new cljs.core.PersistentVector(null,2,(5),inst_53915,inst_53916,null));
var inst_53918 = ["get-all",inst_53917,inst_53910];
var inst_53919 = cljs.core.PersistentHashMap.fromArrays(inst_53914,inst_53918);
var inst_53920 = [inst_53919,inst_53912];
var inst_53921 = (new cljs.core.PersistentVector(null,2,(5),inst_53913,inst_53920,null));
var inst_53922 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53921);
var _ = (function (){var statearr_53950 = state_53927;
(statearr_53950[(4)] = cljs.core.rest((state_53927[(4)])));

return statearr_53950;
})();
var state_53927__$1 = (function (){var statearr_53951 = state_53927;
(statearr_53951[(9)] = inst_53922);

return statearr_53951;
})();
var statearr_53952_53979 = state_53927__$1;
(statearr_53952_53979[(2)] = inst_53910);

(statearr_53952_53979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (10))){
var state_53927__$1 = state_53927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53927__$1,(13),path);
} else {
if((state_val_53928 === (18))){
var inst_53889 = (state_53927[(7)]);
var state_53927__$1 = state_53927;
var statearr_53953_53980 = state_53927__$1;
(statearr_53953_53980[(2)] = inst_53889);

(statearr_53953_53980[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53928 === (8))){
var inst_53889 = (state_53927[(2)]);
var inst_53890 = fluree.db.util.async.channel_QMARK_(path);
var state_53927__$1 = (function (){var statearr_53954 = state_53927;
(statearr_53954[(7)] = inst_53889);

return statearr_53954;
})();
if(inst_53890){
var statearr_53955_53981 = state_53927__$1;
(statearr_53955_53981[(1)] = (10));

} else {
var statearr_53956_53982 = state_53927__$1;
(statearr_53956_53982[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____0 = (function (){
var statearr_53957 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53957[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__);

(statearr_53957[(1)] = (1));

return statearr_53957;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____1 = (function (state_53927){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_53927);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e53958){var ex__2736__auto__ = e53958;
var statearr_53959_53983 = state_53927;
(statearr_53959_53983[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_53927[(4)]))){
var statearr_53960_53984 = state_53927;
(statearr_53960_53984[(1)] = cljs.core.first((state_53927[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53985 = state_53927;
state_53927 = G__53985;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__ = function(state_53927){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____1.call(this,state_53927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_53961 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_53961[(6)] = c__2755__auto__);

return statearr_53961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54024){
var state_val_54025 = (state_54024[(1)]);
if((state_val_54025 === (7))){
var state_54024__$1 = state_54024;
var statearr_54026_54050 = state_54024__$1;
(statearr_54026_54050[(2)] = subject);

(statearr_54026_54050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (1))){
var state_54024__$1 = state_54024;
var statearr_54027_54051 = state_54024__$1;
(statearr_54027_54051[(2)] = null);

(statearr_54027_54051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (4))){
var inst_53986 = (state_54024[(2)]);
var state_54024__$1 = state_54024;
var statearr_54028_54052 = state_54024__$1;
(statearr_54028_54052[(2)] = inst_53986);

(statearr_54028_54052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (13))){
var inst_54003 = (state_54024[(2)]);
var inst_54004 = fluree.db.util.async.throw_err(inst_54003);
var state_54024__$1 = state_54024;
var statearr_54029_54053 = state_54024__$1;
(statearr_54029_54053[(2)] = inst_54004);

(statearr_54029_54053[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (6))){
var state_54024__$1 = state_54024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54024__$1,(9),subject);
} else {
if((state_val_54025 === (3))){
var inst_54022 = (state_54024[(2)]);
var state_54024__$1 = state_54024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54024__$1,inst_54022);
} else {
if((state_val_54025 === (12))){
var inst_53999 = (state_54024[(7)]);
var inst_54007 = (state_54024[(2)]);
var inst_54008 = fluree.db.dbfunctions.internal.get_in(inst_53999,inst_54007);
var inst_54009 = cljs.core.count(inst_54007);
var inst_54010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54011 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54013 = [inst_53999,inst_54007];
var inst_54014 = (new cljs.core.PersistentVector(null,2,(5),inst_54012,inst_54013,null));
var inst_54015 = ["get-in",inst_54014,inst_54008];
var inst_54016 = cljs.core.PersistentHashMap.fromArrays(inst_54011,inst_54015);
var inst_54017 = [inst_54016,inst_54009];
var inst_54018 = (new cljs.core.PersistentVector(null,2,(5),inst_54010,inst_54017,null));
var inst_54019 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54018);
var _ = (function (){var statearr_54030 = state_54024;
(statearr_54030[(4)] = cljs.core.rest((state_54024[(4)])));

return statearr_54030;
})();
var state_54024__$1 = (function (){var statearr_54031 = state_54024;
(statearr_54031[(8)] = inst_54019);

return statearr_54031;
})();
var statearr_54032_54054 = state_54024__$1;
(statearr_54032_54054[(2)] = inst_54008);

(statearr_54032_54054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (2))){
var _ = (function (){var statearr_54033 = state_54024;
(statearr_54033[(4)] = cljs.core.cons((5),(state_54024[(4)])));

return statearr_54033;
})();
var inst_53992 = fluree.db.util.async.channel_QMARK_(subject);
var state_54024__$1 = state_54024;
if(inst_53992){
var statearr_54034_54055 = state_54024__$1;
(statearr_54034_54055[(1)] = (6));

} else {
var statearr_54035_54056 = state_54024__$1;
(statearr_54035_54056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (11))){
var state_54024__$1 = state_54024;
var statearr_54037_54057 = state_54024__$1;
(statearr_54037_54057[(2)] = path);

(statearr_54037_54057[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (9))){
var inst_53995 = (state_54024[(2)]);
var inst_53996 = fluree.db.util.async.throw_err(inst_53995);
var state_54024__$1 = state_54024;
var statearr_54038_54058 = state_54024__$1;
(statearr_54038_54058[(2)] = inst_53996);

(statearr_54038_54058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (5))){
var _ = (function (){var statearr_54039 = state_54024;
(statearr_54039[(4)] = cljs.core.rest((state_54024[(4)])));

return statearr_54039;
})();
var state_54024__$1 = state_54024;
var ex54036 = (state_54024__$1[(2)]);
var statearr_54040_54059 = state_54024__$1;
(statearr_54040_54059[(5)] = ex54036);


if((ex54036 instanceof Error)){
var statearr_54041_54060 = state_54024__$1;
(statearr_54041_54060[(1)] = (4));

(statearr_54041_54060[(5)] = null);

} else {
throw ex54036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54025 === (10))){
var state_54024__$1 = state_54024;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54024__$1,(13),path);
} else {
if((state_val_54025 === (8))){
var inst_53999 = (state_54024[(2)]);
var inst_54000 = fluree.db.util.async.channel_QMARK_(path);
var state_54024__$1 = (function (){var statearr_54042 = state_54024;
(statearr_54042[(7)] = inst_53999);

return statearr_54042;
})();
if(inst_54000){
var statearr_54043_54061 = state_54024__$1;
(statearr_54043_54061[(1)] = (10));

} else {
var statearr_54044_54062 = state_54024__$1;
(statearr_54044_54062[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____0 = (function (){
var statearr_54045 = [null,null,null,null,null,null,null,null,null];
(statearr_54045[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__);

(statearr_54045[(1)] = (1));

return statearr_54045;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____1 = (function (state_54024){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54024);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54046){var ex__2736__auto__ = e54046;
var statearr_54047_54063 = state_54024;
(statearr_54047_54063[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54024[(4)]))){
var statearr_54048_54064 = state_54024;
(statearr_54048_54064[(1)] = cljs.core.first((state_54024[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54065 = state_54024;
state_54024 = G__54065;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__ = function(state_54024){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____1.call(this,state_54024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54049 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54049[(6)] = c__2755__auto__);

return statearr_54049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54110){
var state_val_54111 = (state_54110[(1)]);
if((state_val_54111 === (7))){
var state_54110__$1 = state_54110;
var statearr_54112_54141 = state_54110__$1;
(statearr_54112_54141[(2)] = coll);

(statearr_54112_54141[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (1))){
var state_54110__$1 = state_54110;
var statearr_54113_54142 = state_54110__$1;
(statearr_54113_54142[(2)] = null);

(statearr_54113_54142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (4))){
var inst_54066 = (state_54110[(2)]);
var state_54110__$1 = state_54110;
var statearr_54114_54143 = state_54110__$1;
(statearr_54114_54143[(2)] = inst_54066);

(statearr_54114_54143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (15))){
var inst_54086 = (state_54110[(7)]);
var inst_54094 = (state_54110[(2)]);
var inst_54095 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_54086,inst_54094);
var inst_54096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54097 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54099 = [inst_54086,inst_54094];
var inst_54100 = (new cljs.core.PersistentVector(null,2,(5),inst_54098,inst_54099,null));
var inst_54101 = ["contains?",inst_54100,inst_54095];
var inst_54102 = cljs.core.PersistentHashMap.fromArrays(inst_54097,inst_54101);
var inst_54103 = [inst_54102,(10)];
var inst_54104 = (new cljs.core.PersistentVector(null,2,(5),inst_54096,inst_54103,null));
var inst_54105 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54104);
var _ = (function (){var statearr_54115 = state_54110;
(statearr_54115[(4)] = cljs.core.rest((state_54110[(4)])));

return statearr_54115;
})();
var state_54110__$1 = (function (){var statearr_54116 = state_54110;
(statearr_54116[(8)] = inst_54105);

return statearr_54116;
})();
var statearr_54117_54144 = state_54110__$1;
(statearr_54117_54144[(2)] = inst_54095);

(statearr_54117_54144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (13))){
var state_54110__$1 = state_54110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54110__$1,(16),key);
} else {
if((state_val_54111 === (6))){
var state_54110__$1 = state_54110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54110__$1,(9),coll);
} else {
if((state_val_54111 === (3))){
var inst_54108 = (state_54110[(2)]);
var state_54110__$1 = state_54110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54110__$1,inst_54108);
} else {
if((state_val_54111 === (12))){
var inst_54086 = (state_54110[(2)]);
var inst_54087 = fluree.db.util.async.channel_QMARK_(key);
var state_54110__$1 = (function (){var statearr_54118 = state_54110;
(statearr_54118[(7)] = inst_54086);

return statearr_54118;
})();
if(inst_54087){
var statearr_54119_54145 = state_54110__$1;
(statearr_54119_54145[(1)] = (13));

} else {
var statearr_54120_54146 = state_54110__$1;
(statearr_54120_54146[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (2))){
var _ = (function (){var statearr_54121 = state_54110;
(statearr_54121[(4)] = cljs.core.cons((5),(state_54110[(4)])));

return statearr_54121;
})();
var inst_54072 = fluree.db.util.async.channel_QMARK_(coll);
var state_54110__$1 = state_54110;
if(inst_54072){
var statearr_54122_54147 = state_54110__$1;
(statearr_54122_54147[(1)] = (6));

} else {
var statearr_54123_54148 = state_54110__$1;
(statearr_54123_54148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (11))){
var inst_54079 = (state_54110[(9)]);
var inst_54083 = cljs.core.flatten(inst_54079);
var inst_54084 = cljs.core.set(inst_54083);
var state_54110__$1 = state_54110;
var statearr_54125_54149 = state_54110__$1;
(statearr_54125_54149[(2)] = inst_54084);

(statearr_54125_54149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (9))){
var inst_54075 = (state_54110[(2)]);
var inst_54076 = fluree.db.util.async.throw_err(inst_54075);
var state_54110__$1 = state_54110;
var statearr_54126_54150 = state_54110__$1;
(statearr_54126_54150[(2)] = inst_54076);

(statearr_54126_54150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (5))){
var _ = (function (){var statearr_54127 = state_54110;
(statearr_54127[(4)] = cljs.core.rest((state_54110[(4)])));

return statearr_54127;
})();
var state_54110__$1 = state_54110;
var ex54124 = (state_54110__$1[(2)]);
var statearr_54128_54151 = state_54110__$1;
(statearr_54128_54151[(5)] = ex54124);


if((ex54124 instanceof Error)){
var statearr_54129_54152 = state_54110__$1;
(statearr_54129_54152[(1)] = (4));

(statearr_54129_54152[(5)] = null);

} else {
throw ex54124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (14))){
var state_54110__$1 = state_54110;
var statearr_54130_54153 = state_54110__$1;
(statearr_54130_54153[(2)] = key);

(statearr_54130_54153[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (16))){
var inst_54090 = (state_54110[(2)]);
var inst_54091 = fluree.db.util.async.throw_err(inst_54090);
var state_54110__$1 = state_54110;
var statearr_54131_54154 = state_54110__$1;
(statearr_54131_54154[(2)] = inst_54091);

(statearr_54131_54154[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (10))){
var inst_54079 = (state_54110[(9)]);
var state_54110__$1 = state_54110;
var statearr_54132_54155 = state_54110__$1;
(statearr_54132_54155[(2)] = inst_54079);

(statearr_54132_54155[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54111 === (8))){
var inst_54079 = (state_54110[(9)]);
var inst_54079__$1 = (state_54110[(2)]);
var inst_54080 = cljs.core.set_QMARK_(inst_54079__$1);
var state_54110__$1 = (function (){var statearr_54133 = state_54110;
(statearr_54133[(9)] = inst_54079__$1);

return statearr_54133;
})();
if(inst_54080){
var statearr_54134_54156 = state_54110__$1;
(statearr_54134_54156[(1)] = (10));

} else {
var statearr_54135_54157 = state_54110__$1;
(statearr_54135_54157[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_54136 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54136[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__);

(statearr_54136[(1)] = (1));

return statearr_54136;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____1 = (function (state_54110){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54110);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54137){var ex__2736__auto__ = e54137;
var statearr_54138_54158 = state_54110;
(statearr_54138_54158[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54110[(4)]))){
var statearr_54139_54159 = state_54110;
(statearr_54139_54159[(1)] = cljs.core.first((state_54110[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54160 = state_54110;
state_54110 = G__54160;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__ = function(state_54110){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____1.call(this,state_54110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54140 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54140[(6)] = c__2755__auto__);

return statearr_54140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54232 = arguments.length;
var i__4830__auto___54233 = (0);
while(true){
if((i__4830__auto___54233 < len__4829__auto___54232)){
args__4835__auto__.push((arguments[i__4830__auto___54233]));

var G__54234 = (i__4830__auto___54233 + (1));
i__4830__auto___54233 = G__54234;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54206){
var state_val_54207 = (state_54206[(1)]);
if((state_val_54207 === (7))){
var inst_54172 = (state_54206[(7)]);
var inst_54176 = cljs.core.first(inst_54172);
var inst_54177 = cljs.core.coll_QMARK_(inst_54176);
var state_54206__$1 = state_54206;
var statearr_54208_54235 = state_54206__$1;
(statearr_54208_54235[(2)] = inst_54177);

(statearr_54208_54235[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (1))){
var state_54206__$1 = state_54206;
var statearr_54209_54236 = state_54206__$1;
(statearr_54209_54236[(2)] = null);

(statearr_54209_54236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (4))){
var inst_54163 = (state_54206[(2)]);
var state_54206__$1 = state_54206;
var statearr_54210_54237 = state_54206__$1;
(statearr_54210_54237[(2)] = inst_54163);

(statearr_54210_54237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (6))){
var inst_54174 = (state_54206[(8)]);
var inst_54172 = (state_54206[(7)]);
var inst_54171 = (state_54206[(2)]);
var inst_54172__$1 = fluree.db.util.async.throw_err(inst_54171);
var inst_54173 = cljs.core.count(inst_54172__$1);
var inst_54174__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54173);
var state_54206__$1 = (function (){var statearr_54211 = state_54206;
(statearr_54211[(8)] = inst_54174__$1);

(statearr_54211[(7)] = inst_54172__$1);

return statearr_54211;
})();
if(inst_54174__$1){
var statearr_54212_54238 = state_54206__$1;
(statearr_54212_54238[(1)] = (7));

} else {
var statearr_54213_54239 = state_54206__$1;
(statearr_54213_54239[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (3))){
var inst_54204 = (state_54206[(2)]);
var state_54206__$1 = state_54206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54206__$1,inst_54204);
} else {
if((state_val_54207 === (12))){
var inst_54185 = (state_54206[(2)]);
var inst_54186 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_54185);
var inst_54187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54188 = [inst_54185];
var inst_54189 = (new cljs.core.PersistentVector(null,1,(5),inst_54187,inst_54188,null));
var inst_54190 = cljs.core.count(inst_54189);
var inst_54191 = ((9) + inst_54190);
var inst_54192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54193 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54195 = [inst_54185];
var inst_54196 = (new cljs.core.PersistentVector(null,1,(5),inst_54194,inst_54195,null));
var inst_54197 = ["hash-set",inst_54196,inst_54186];
var inst_54198 = cljs.core.PersistentHashMap.fromArrays(inst_54193,inst_54197);
var inst_54199 = [inst_54198,inst_54191];
var inst_54200 = (new cljs.core.PersistentVector(null,2,(5),inst_54192,inst_54199,null));
var inst_54201 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54200);
var _ = (function (){var statearr_54214 = state_54206;
(statearr_54214[(4)] = cljs.core.rest((state_54206[(4)])));

return statearr_54214;
})();
var state_54206__$1 = (function (){var statearr_54215 = state_54206;
(statearr_54215[(9)] = inst_54201);

return statearr_54215;
})();
var statearr_54216_54240 = state_54206__$1;
(statearr_54216_54240[(2)] = inst_54186);

(statearr_54216_54240[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (2))){
var _ = (function (){var statearr_54217 = state_54206;
(statearr_54217[(4)] = cljs.core.cons((5),(state_54206[(4)])));

return statearr_54217;
})();
var inst_54169 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54206__$1 = state_54206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54206__$1,(6),inst_54169);
} else {
if((state_val_54207 === (11))){
var inst_54172 = (state_54206[(7)]);
var state_54206__$1 = state_54206;
var statearr_54219_54241 = state_54206__$1;
(statearr_54219_54241[(2)] = inst_54172);

(statearr_54219_54241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (9))){
var inst_54180 = (state_54206[(2)]);
var state_54206__$1 = state_54206;
if(cljs.core.truth_(inst_54180)){
var statearr_54220_54242 = state_54206__$1;
(statearr_54220_54242[(1)] = (10));

} else {
var statearr_54221_54243 = state_54206__$1;
(statearr_54221_54243[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (5))){
var _ = (function (){var statearr_54222 = state_54206;
(statearr_54222[(4)] = cljs.core.rest((state_54206[(4)])));

return statearr_54222;
})();
var state_54206__$1 = state_54206;
var ex54218 = (state_54206__$1[(2)]);
var statearr_54223_54244 = state_54206__$1;
(statearr_54223_54244[(5)] = ex54218);


if((ex54218 instanceof Error)){
var statearr_54224_54245 = state_54206__$1;
(statearr_54224_54245[(1)] = (4));

(statearr_54224_54245[(5)] = null);

} else {
throw ex54218;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (10))){
var inst_54172 = (state_54206[(7)]);
var inst_54182 = cljs.core.first(inst_54172);
var state_54206__$1 = state_54206;
var statearr_54225_54246 = state_54206__$1;
(statearr_54225_54246[(2)] = inst_54182);

(statearr_54225_54246[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54207 === (8))){
var inst_54174 = (state_54206[(8)]);
var state_54206__$1 = state_54206;
var statearr_54226_54247 = state_54206__$1;
(statearr_54226_54247[(2)] = inst_54174);

(statearr_54226_54247[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54227 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54227[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54227[(1)] = (1));

return statearr_54227;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54206){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54206);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54228){var ex__2736__auto__ = e54228;
var statearr_54229_54248 = state_54206;
(statearr_54229_54248[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54206[(4)]))){
var statearr_54230_54249 = state_54206;
(statearr_54230_54249[(1)] = cljs.core.first((state_54206[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54250 = state_54206;
state_54206 = G__54250;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54206){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54231 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54231[(6)] = c__2755__auto__);

return statearr_54231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54161){
var G__54162 = cljs.core.first(seq54161);
var seq54161__$1 = cljs.core.next(seq54161);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54162,seq54161__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54300 = arguments.length;
var i__4830__auto___54301 = (0);
while(true){
if((i__4830__auto___54301 < len__4829__auto___54300)){
args__4835__auto__.push((arguments[i__4830__auto___54301]));

var G__54302 = (i__4830__auto___54301 + (1));
i__4830__auto___54301 = G__54302;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54283){
var state_val_54284 = (state_54283[(1)]);
if((state_val_54284 === (1))){
var state_54283__$1 = state_54283;
var statearr_54285_54303 = state_54283__$1;
(statearr_54285_54303[(2)] = null);

(statearr_54285_54303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54284 === (2))){
var _ = (function (){var statearr_54286 = state_54283;
(statearr_54286[(4)] = cljs.core.cons((5),(state_54283[(4)])));

return statearr_54286;
})();
var inst_54259 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54283__$1 = state_54283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54283__$1,(6),inst_54259);
} else {
if((state_val_54284 === (3))){
var inst_54281 = (state_54283[(2)]);
var state_54283__$1 = state_54283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54283__$1,inst_54281);
} else {
if((state_val_54284 === (4))){
var inst_54253 = (state_54283[(2)]);
var state_54283__$1 = state_54283;
var statearr_54288_54304 = state_54283__$1;
(statearr_54288_54304[(2)] = inst_54253);

(statearr_54288_54304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54284 === (5))){
var _ = (function (){var statearr_54289 = state_54283;
(statearr_54289[(4)] = cljs.core.rest((state_54283[(4)])));

return statearr_54289;
})();
var state_54283__$1 = state_54283;
var ex54287 = (state_54283__$1[(2)]);
var statearr_54290_54305 = state_54283__$1;
(statearr_54290_54305[(5)] = ex54287);


if((ex54287 instanceof Error)){
var statearr_54291_54306 = state_54283__$1;
(statearr_54291_54306[(1)] = (4));

(statearr_54291_54306[(5)] = null);

} else {
throw ex54287;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54284 === (6))){
var inst_54261 = (state_54283[(2)]);
var inst_54262 = fluree.db.util.async.throw_err(inst_54261);
var inst_54263 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_54262);
var inst_54264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54265 = [inst_54262];
var inst_54266 = (new cljs.core.PersistentVector(null,1,(5),inst_54264,inst_54265,null));
var inst_54267 = cljs.core.count(inst_54266);
var inst_54268 = ((9) + inst_54267);
var inst_54269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54270 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54272 = [inst_54262];
var inst_54273 = (new cljs.core.PersistentVector(null,1,(5),inst_54271,inst_54272,null));
var inst_54274 = ["==",inst_54273,inst_54263];
var inst_54275 = cljs.core.PersistentHashMap.fromArrays(inst_54270,inst_54274);
var inst_54276 = [inst_54275,inst_54268];
var inst_54277 = (new cljs.core.PersistentVector(null,2,(5),inst_54269,inst_54276,null));
var inst_54278 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54277);
var _ = (function (){var statearr_54292 = state_54283;
(statearr_54292[(4)] = cljs.core.rest((state_54283[(4)])));

return statearr_54292;
})();
var state_54283__$1 = (function (){var statearr_54293 = state_54283;
(statearr_54293[(7)] = inst_54278);

return statearr_54293;
})();
var statearr_54294_54307 = state_54283__$1;
(statearr_54294_54307[(2)] = inst_54263);

(statearr_54294_54307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54295 = [null,null,null,null,null,null,null,null];
(statearr_54295[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54295[(1)] = (1));

return statearr_54295;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54283){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54283);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54296){var ex__2736__auto__ = e54296;
var statearr_54297_54308 = state_54283;
(statearr_54297_54308[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54283[(4)]))){
var statearr_54298_54309 = state_54283;
(statearr_54298_54309[(1)] = cljs.core.first((state_54283[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54310 = state_54283;
state_54283 = G__54310;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54283){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54299 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54299[(6)] = c__2755__auto__);

return statearr_54299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54251){
var G__54252 = cljs.core.first(seq54251);
var seq54251__$1 = cljs.core.next(seq54251);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54252,seq54251__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54360 = arguments.length;
var i__4830__auto___54361 = (0);
while(true){
if((i__4830__auto___54361 < len__4829__auto___54360)){
args__4835__auto__.push((arguments[i__4830__auto___54361]));

var G__54362 = (i__4830__auto___54361 + (1));
i__4830__auto___54361 = G__54362;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54343){
var state_val_54344 = (state_54343[(1)]);
if((state_val_54344 === (1))){
var state_54343__$1 = state_54343;
var statearr_54345_54363 = state_54343__$1;
(statearr_54345_54363[(2)] = null);

(statearr_54345_54363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54344 === (2))){
var _ = (function (){var statearr_54346 = state_54343;
(statearr_54346[(4)] = cljs.core.cons((5),(state_54343[(4)])));

return statearr_54346;
})();
var inst_54319 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54343__$1 = state_54343;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54343__$1,(6),inst_54319);
} else {
if((state_val_54344 === (3))){
var inst_54341 = (state_54343[(2)]);
var state_54343__$1 = state_54343;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54343__$1,inst_54341);
} else {
if((state_val_54344 === (4))){
var inst_54313 = (state_54343[(2)]);
var state_54343__$1 = state_54343;
var statearr_54348_54364 = state_54343__$1;
(statearr_54348_54364[(2)] = inst_54313);

(statearr_54348_54364[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54344 === (5))){
var _ = (function (){var statearr_54349 = state_54343;
(statearr_54349[(4)] = cljs.core.rest((state_54343[(4)])));

return statearr_54349;
})();
var state_54343__$1 = state_54343;
var ex54347 = (state_54343__$1[(2)]);
var statearr_54350_54365 = state_54343__$1;
(statearr_54350_54365[(5)] = ex54347);


if((ex54347 instanceof Error)){
var statearr_54351_54366 = state_54343__$1;
(statearr_54351_54366[(1)] = (4));

(statearr_54351_54366[(5)] = null);

} else {
throw ex54347;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54344 === (6))){
var inst_54321 = (state_54343[(2)]);
var inst_54322 = fluree.db.util.async.throw_err(inst_54321);
var inst_54323 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_54322);
var inst_54324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54325 = [inst_54322];
var inst_54326 = (new cljs.core.PersistentVector(null,1,(5),inst_54324,inst_54325,null));
var inst_54327 = cljs.core.count(inst_54326);
var inst_54328 = ((9) + inst_54327);
var inst_54329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54330 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54332 = [inst_54322];
var inst_54333 = (new cljs.core.PersistentVector(null,1,(5),inst_54331,inst_54332,null));
var inst_54334 = [">",inst_54333,inst_54323];
var inst_54335 = cljs.core.PersistentHashMap.fromArrays(inst_54330,inst_54334);
var inst_54336 = [inst_54335,inst_54328];
var inst_54337 = (new cljs.core.PersistentVector(null,2,(5),inst_54329,inst_54336,null));
var inst_54338 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54337);
var _ = (function (){var statearr_54352 = state_54343;
(statearr_54352[(4)] = cljs.core.rest((state_54343[(4)])));

return statearr_54352;
})();
var state_54343__$1 = (function (){var statearr_54353 = state_54343;
(statearr_54353[(7)] = inst_54338);

return statearr_54353;
})();
var statearr_54354_54367 = state_54343__$1;
(statearr_54354_54367[(2)] = inst_54323);

(statearr_54354_54367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54355 = [null,null,null,null,null,null,null,null];
(statearr_54355[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54355[(1)] = (1));

return statearr_54355;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54343){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54343);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54356){var ex__2736__auto__ = e54356;
var statearr_54357_54368 = state_54343;
(statearr_54357_54368[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54343[(4)]))){
var statearr_54358_54369 = state_54343;
(statearr_54358_54369[(1)] = cljs.core.first((state_54343[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54370 = state_54343;
state_54343 = G__54370;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54343){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54359 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54359[(6)] = c__2755__auto__);

return statearr_54359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54311){
var G__54312 = cljs.core.first(seq54311);
var seq54311__$1 = cljs.core.next(seq54311);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54312,seq54311__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54420 = arguments.length;
var i__4830__auto___54421 = (0);
while(true){
if((i__4830__auto___54421 < len__4829__auto___54420)){
args__4835__auto__.push((arguments[i__4830__auto___54421]));

var G__54422 = (i__4830__auto___54421 + (1));
i__4830__auto___54421 = G__54422;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54403){
var state_val_54404 = (state_54403[(1)]);
if((state_val_54404 === (1))){
var state_54403__$1 = state_54403;
var statearr_54405_54423 = state_54403__$1;
(statearr_54405_54423[(2)] = null);

(statearr_54405_54423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (2))){
var _ = (function (){var statearr_54406 = state_54403;
(statearr_54406[(4)] = cljs.core.cons((5),(state_54403[(4)])));

return statearr_54406;
})();
var inst_54379 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54403__$1 = state_54403;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54403__$1,(6),inst_54379);
} else {
if((state_val_54404 === (3))){
var inst_54401 = (state_54403[(2)]);
var state_54403__$1 = state_54403;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54403__$1,inst_54401);
} else {
if((state_val_54404 === (4))){
var inst_54373 = (state_54403[(2)]);
var state_54403__$1 = state_54403;
var statearr_54408_54424 = state_54403__$1;
(statearr_54408_54424[(2)] = inst_54373);

(statearr_54408_54424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (5))){
var _ = (function (){var statearr_54409 = state_54403;
(statearr_54409[(4)] = cljs.core.rest((state_54403[(4)])));

return statearr_54409;
})();
var state_54403__$1 = state_54403;
var ex54407 = (state_54403__$1[(2)]);
var statearr_54410_54425 = state_54403__$1;
(statearr_54410_54425[(5)] = ex54407);


if((ex54407 instanceof Error)){
var statearr_54411_54426 = state_54403__$1;
(statearr_54411_54426[(1)] = (4));

(statearr_54411_54426[(5)] = null);

} else {
throw ex54407;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54404 === (6))){
var inst_54381 = (state_54403[(2)]);
var inst_54382 = fluree.db.util.async.throw_err(inst_54381);
var inst_54383 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_54382);
var inst_54384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54385 = [inst_54382];
var inst_54386 = (new cljs.core.PersistentVector(null,1,(5),inst_54384,inst_54385,null));
var inst_54387 = cljs.core.count(inst_54386);
var inst_54388 = ((9) + inst_54387);
var inst_54389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54390 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54392 = [inst_54382];
var inst_54393 = (new cljs.core.PersistentVector(null,1,(5),inst_54391,inst_54392,null));
var inst_54394 = ["<",inst_54393,inst_54383];
var inst_54395 = cljs.core.PersistentHashMap.fromArrays(inst_54390,inst_54394);
var inst_54396 = [inst_54395,inst_54388];
var inst_54397 = (new cljs.core.PersistentVector(null,2,(5),inst_54389,inst_54396,null));
var inst_54398 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54397);
var _ = (function (){var statearr_54412 = state_54403;
(statearr_54412[(4)] = cljs.core.rest((state_54403[(4)])));

return statearr_54412;
})();
var state_54403__$1 = (function (){var statearr_54413 = state_54403;
(statearr_54413[(7)] = inst_54398);

return statearr_54413;
})();
var statearr_54414_54427 = state_54403__$1;
(statearr_54414_54427[(2)] = inst_54383);

(statearr_54414_54427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54415 = [null,null,null,null,null,null,null,null];
(statearr_54415[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54415[(1)] = (1));

return statearr_54415;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54403){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54403);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54416){var ex__2736__auto__ = e54416;
var statearr_54417_54428 = state_54403;
(statearr_54417_54428[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54403[(4)]))){
var statearr_54418_54429 = state_54403;
(statearr_54418_54429[(1)] = cljs.core.first((state_54403[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54430 = state_54403;
state_54403 = G__54430;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54403){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54419 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54419[(6)] = c__2755__auto__);

return statearr_54419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54371){
var G__54372 = cljs.core.first(seq54371);
var seq54371__$1 = cljs.core.next(seq54371);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54372,seq54371__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54480 = arguments.length;
var i__4830__auto___54481 = (0);
while(true){
if((i__4830__auto___54481 < len__4829__auto___54480)){
args__4835__auto__.push((arguments[i__4830__auto___54481]));

var G__54482 = (i__4830__auto___54481 + (1));
i__4830__auto___54481 = G__54482;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54463){
var state_val_54464 = (state_54463[(1)]);
if((state_val_54464 === (1))){
var state_54463__$1 = state_54463;
var statearr_54465_54483 = state_54463__$1;
(statearr_54465_54483[(2)] = null);

(statearr_54465_54483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54464 === (2))){
var _ = (function (){var statearr_54466 = state_54463;
(statearr_54466[(4)] = cljs.core.cons((5),(state_54463[(4)])));

return statearr_54466;
})();
var inst_54439 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54463__$1 = state_54463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54463__$1,(6),inst_54439);
} else {
if((state_val_54464 === (3))){
var inst_54461 = (state_54463[(2)]);
var state_54463__$1 = state_54463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54463__$1,inst_54461);
} else {
if((state_val_54464 === (4))){
var inst_54433 = (state_54463[(2)]);
var state_54463__$1 = state_54463;
var statearr_54468_54484 = state_54463__$1;
(statearr_54468_54484[(2)] = inst_54433);

(statearr_54468_54484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54464 === (5))){
var _ = (function (){var statearr_54469 = state_54463;
(statearr_54469[(4)] = cljs.core.rest((state_54463[(4)])));

return statearr_54469;
})();
var state_54463__$1 = state_54463;
var ex54467 = (state_54463__$1[(2)]);
var statearr_54470_54485 = state_54463__$1;
(statearr_54470_54485[(5)] = ex54467);


if((ex54467 instanceof Error)){
var statearr_54471_54486 = state_54463__$1;
(statearr_54471_54486[(1)] = (4));

(statearr_54471_54486[(5)] = null);

} else {
throw ex54467;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54464 === (6))){
var inst_54441 = (state_54463[(2)]);
var inst_54442 = fluree.db.util.async.throw_err(inst_54441);
var inst_54443 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_54442);
var inst_54444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54445 = [inst_54442];
var inst_54446 = (new cljs.core.PersistentVector(null,1,(5),inst_54444,inst_54445,null));
var inst_54447 = cljs.core.count(inst_54446);
var inst_54448 = ((9) + inst_54447);
var inst_54449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54450 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54452 = [inst_54442];
var inst_54453 = (new cljs.core.PersistentVector(null,1,(5),inst_54451,inst_54452,null));
var inst_54454 = ["<=",inst_54453,inst_54443];
var inst_54455 = cljs.core.PersistentHashMap.fromArrays(inst_54450,inst_54454);
var inst_54456 = [inst_54455,inst_54448];
var inst_54457 = (new cljs.core.PersistentVector(null,2,(5),inst_54449,inst_54456,null));
var inst_54458 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54457);
var _ = (function (){var statearr_54472 = state_54463;
(statearr_54472[(4)] = cljs.core.rest((state_54463[(4)])));

return statearr_54472;
})();
var state_54463__$1 = (function (){var statearr_54473 = state_54463;
(statearr_54473[(7)] = inst_54458);

return statearr_54473;
})();
var statearr_54474_54487 = state_54463__$1;
(statearr_54474_54487[(2)] = inst_54443);

(statearr_54474_54487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54475 = [null,null,null,null,null,null,null,null];
(statearr_54475[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54475[(1)] = (1));

return statearr_54475;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54463){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54463);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54476){var ex__2736__auto__ = e54476;
var statearr_54477_54488 = state_54463;
(statearr_54477_54488[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54463[(4)]))){
var statearr_54478_54489 = state_54463;
(statearr_54478_54489[(1)] = cljs.core.first((state_54463[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54490 = state_54463;
state_54463 = G__54490;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54463){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54479 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54479[(6)] = c__2755__auto__);

return statearr_54479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq54431){
var G__54432 = cljs.core.first(seq54431);
var seq54431__$1 = cljs.core.next(seq54431);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54432,seq54431__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54540 = arguments.length;
var i__4830__auto___54541 = (0);
while(true){
if((i__4830__auto___54541 < len__4829__auto___54540)){
args__4835__auto__.push((arguments[i__4830__auto___54541]));

var G__54542 = (i__4830__auto___54541 + (1));
i__4830__auto___54541 = G__54542;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54523){
var state_val_54524 = (state_54523[(1)]);
if((state_val_54524 === (1))){
var state_54523__$1 = state_54523;
var statearr_54525_54543 = state_54523__$1;
(statearr_54525_54543[(2)] = null);

(statearr_54525_54543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54524 === (2))){
var _ = (function (){var statearr_54526 = state_54523;
(statearr_54526[(4)] = cljs.core.cons((5),(state_54523[(4)])));

return statearr_54526;
})();
var inst_54499 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54523__$1 = state_54523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54523__$1,(6),inst_54499);
} else {
if((state_val_54524 === (3))){
var inst_54521 = (state_54523[(2)]);
var state_54523__$1 = state_54523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54523__$1,inst_54521);
} else {
if((state_val_54524 === (4))){
var inst_54493 = (state_54523[(2)]);
var state_54523__$1 = state_54523;
var statearr_54528_54544 = state_54523__$1;
(statearr_54528_54544[(2)] = inst_54493);

(statearr_54528_54544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54524 === (5))){
var _ = (function (){var statearr_54529 = state_54523;
(statearr_54529[(4)] = cljs.core.rest((state_54523[(4)])));

return statearr_54529;
})();
var state_54523__$1 = state_54523;
var ex54527 = (state_54523__$1[(2)]);
var statearr_54530_54545 = state_54523__$1;
(statearr_54530_54545[(5)] = ex54527);


if((ex54527 instanceof Error)){
var statearr_54531_54546 = state_54523__$1;
(statearr_54531_54546[(1)] = (4));

(statearr_54531_54546[(5)] = null);

} else {
throw ex54527;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54524 === (6))){
var inst_54501 = (state_54523[(2)]);
var inst_54502 = fluree.db.util.async.throw_err(inst_54501);
var inst_54503 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_54502);
var inst_54504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54505 = [inst_54502];
var inst_54506 = (new cljs.core.PersistentVector(null,1,(5),inst_54504,inst_54505,null));
var inst_54507 = cljs.core.count(inst_54506);
var inst_54508 = ((9) + inst_54507);
var inst_54509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54510 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54512 = [inst_54502];
var inst_54513 = (new cljs.core.PersistentVector(null,1,(5),inst_54511,inst_54512,null));
var inst_54514 = [">=",inst_54513,inst_54503];
var inst_54515 = cljs.core.PersistentHashMap.fromArrays(inst_54510,inst_54514);
var inst_54516 = [inst_54515,inst_54508];
var inst_54517 = (new cljs.core.PersistentVector(null,2,(5),inst_54509,inst_54516,null));
var inst_54518 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54517);
var _ = (function (){var statearr_54532 = state_54523;
(statearr_54532[(4)] = cljs.core.rest((state_54523[(4)])));

return statearr_54532;
})();
var state_54523__$1 = (function (){var statearr_54533 = state_54523;
(statearr_54533[(7)] = inst_54518);

return statearr_54533;
})();
var statearr_54534_54547 = state_54523__$1;
(statearr_54534_54547[(2)] = inst_54503);

(statearr_54534_54547[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54535 = [null,null,null,null,null,null,null,null];
(statearr_54535[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54535[(1)] = (1));

return statearr_54535;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54523){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54523);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54536){var ex__2736__auto__ = e54536;
var statearr_54537_54548 = state_54523;
(statearr_54537_54548[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54523[(4)]))){
var statearr_54538_54549 = state_54523;
(statearr_54538_54549[(1)] = cljs.core.first((state_54523[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54550 = state_54523;
state_54523 = G__54550;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54523){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54539 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54539[(6)] = c__2755__auto__);

return statearr_54539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq54491){
var G__54492 = cljs.core.first(seq54491);
var seq54491__$1 = cljs.core.next(seq54491);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54492,seq54491__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54600 = arguments.length;
var i__4830__auto___54601 = (0);
while(true){
if((i__4830__auto___54601 < len__4829__auto___54600)){
args__4835__auto__.push((arguments[i__4830__auto___54601]));

var G__54602 = (i__4830__auto___54601 + (1));
i__4830__auto___54601 = G__54602;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54583){
var state_val_54584 = (state_54583[(1)]);
if((state_val_54584 === (1))){
var state_54583__$1 = state_54583;
var statearr_54585_54603 = state_54583__$1;
(statearr_54585_54603[(2)] = null);

(statearr_54585_54603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54584 === (2))){
var _ = (function (){var statearr_54586 = state_54583;
(statearr_54586[(4)] = cljs.core.cons((5),(state_54583[(4)])));

return statearr_54586;
})();
var inst_54559 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54583__$1 = state_54583;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54583__$1,(6),inst_54559);
} else {
if((state_val_54584 === (3))){
var inst_54581 = (state_54583[(2)]);
var state_54583__$1 = state_54583;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54583__$1,inst_54581);
} else {
if((state_val_54584 === (4))){
var inst_54553 = (state_54583[(2)]);
var state_54583__$1 = state_54583;
var statearr_54588_54604 = state_54583__$1;
(statearr_54588_54604[(2)] = inst_54553);

(statearr_54588_54604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54584 === (5))){
var _ = (function (){var statearr_54589 = state_54583;
(statearr_54589[(4)] = cljs.core.rest((state_54583[(4)])));

return statearr_54589;
})();
var state_54583__$1 = state_54583;
var ex54587 = (state_54583__$1[(2)]);
var statearr_54590_54605 = state_54583__$1;
(statearr_54590_54605[(5)] = ex54587);


if((ex54587 instanceof Error)){
var statearr_54591_54606 = state_54583__$1;
(statearr_54591_54606[(1)] = (4));

(statearr_54591_54606[(5)] = null);

} else {
throw ex54587;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54584 === (6))){
var inst_54561 = (state_54583[(2)]);
var inst_54562 = fluree.db.util.async.throw_err(inst_54561);
var inst_54563 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_54562);
var inst_54564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54565 = [inst_54562];
var inst_54566 = (new cljs.core.PersistentVector(null,1,(5),inst_54564,inst_54565,null));
var inst_54567 = cljs.core.count(inst_54566);
var inst_54568 = ((9) + inst_54567);
var inst_54569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54570 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54572 = [inst_54562];
var inst_54573 = (new cljs.core.PersistentVector(null,1,(5),inst_54571,inst_54572,null));
var inst_54574 = ["not=",inst_54573,inst_54563];
var inst_54575 = cljs.core.PersistentHashMap.fromArrays(inst_54570,inst_54574);
var inst_54576 = [inst_54575,inst_54568];
var inst_54577 = (new cljs.core.PersistentVector(null,2,(5),inst_54569,inst_54576,null));
var inst_54578 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54577);
var _ = (function (){var statearr_54592 = state_54583;
(statearr_54592[(4)] = cljs.core.rest((state_54583[(4)])));

return statearr_54592;
})();
var state_54583__$1 = (function (){var statearr_54593 = state_54583;
(statearr_54593[(7)] = inst_54578);

return statearr_54593;
})();
var statearr_54594_54607 = state_54583__$1;
(statearr_54594_54607[(2)] = inst_54563);

(statearr_54594_54607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54595 = [null,null,null,null,null,null,null,null];
(statearr_54595[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54595[(1)] = (1));

return statearr_54595;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54583){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54583);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54596){var ex__2736__auto__ = e54596;
var statearr_54597_54608 = state_54583;
(statearr_54597_54608[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54583[(4)]))){
var statearr_54598_54609 = state_54583;
(statearr_54598_54609[(1)] = cljs.core.first((state_54583[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54610 = state_54583;
state_54583 = G__54610;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54583){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54599 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54599[(6)] = c__2755__auto__);

return statearr_54599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq54551){
var G__54552 = cljs.core.first(seq54551);
var seq54551__$1 = cljs.core.next(seq54551);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54552,seq54551__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54660 = arguments.length;
var i__4830__auto___54661 = (0);
while(true){
if((i__4830__auto___54661 < len__4829__auto___54660)){
args__4835__auto__.push((arguments[i__4830__auto___54661]));

var G__54662 = (i__4830__auto___54661 + (1));
i__4830__auto___54661 = G__54662;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54643){
var state_val_54644 = (state_54643[(1)]);
if((state_val_54644 === (1))){
var state_54643__$1 = state_54643;
var statearr_54645_54663 = state_54643__$1;
(statearr_54645_54663[(2)] = null);

(statearr_54645_54663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (2))){
var _ = (function (){var statearr_54646 = state_54643;
(statearr_54646[(4)] = cljs.core.cons((5),(state_54643[(4)])));

return statearr_54646;
})();
var inst_54619 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54643__$1 = state_54643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54643__$1,(6),inst_54619);
} else {
if((state_val_54644 === (3))){
var inst_54641 = (state_54643[(2)]);
var state_54643__$1 = state_54643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54643__$1,inst_54641);
} else {
if((state_val_54644 === (4))){
var inst_54613 = (state_54643[(2)]);
var state_54643__$1 = state_54643;
var statearr_54648_54664 = state_54643__$1;
(statearr_54648_54664[(2)] = inst_54613);

(statearr_54648_54664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (5))){
var _ = (function (){var statearr_54649 = state_54643;
(statearr_54649[(4)] = cljs.core.rest((state_54643[(4)])));

return statearr_54649;
})();
var state_54643__$1 = state_54643;
var ex54647 = (state_54643__$1[(2)]);
var statearr_54650_54665 = state_54643__$1;
(statearr_54650_54665[(5)] = ex54647);


if((ex54647 instanceof Error)){
var statearr_54651_54666 = state_54643__$1;
(statearr_54651_54666[(1)] = (4));

(statearr_54651_54666[(5)] = null);

} else {
throw ex54647;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54644 === (6))){
var inst_54621 = (state_54643[(2)]);
var inst_54622 = fluree.db.util.async.throw_err(inst_54621);
var inst_54623 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_54622);
var inst_54624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54625 = [inst_54622];
var inst_54626 = (new cljs.core.PersistentVector(null,1,(5),inst_54624,inst_54625,null));
var inst_54627 = cljs.core.count(inst_54626);
var inst_54628 = ((9) + inst_54627);
var inst_54629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54630 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54632 = [inst_54622];
var inst_54633 = (new cljs.core.PersistentVector(null,1,(5),inst_54631,inst_54632,null));
var inst_54634 = ["max",inst_54633,inst_54623];
var inst_54635 = cljs.core.PersistentHashMap.fromArrays(inst_54630,inst_54634);
var inst_54636 = [inst_54635,inst_54628];
var inst_54637 = (new cljs.core.PersistentVector(null,2,(5),inst_54629,inst_54636,null));
var inst_54638 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54637);
var _ = (function (){var statearr_54652 = state_54643;
(statearr_54652[(4)] = cljs.core.rest((state_54643[(4)])));

return statearr_54652;
})();
var state_54643__$1 = (function (){var statearr_54653 = state_54643;
(statearr_54653[(7)] = inst_54638);

return statearr_54653;
})();
var statearr_54654_54667 = state_54643__$1;
(statearr_54654_54667[(2)] = inst_54623);

(statearr_54654_54667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54655 = [null,null,null,null,null,null,null,null];
(statearr_54655[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54655[(1)] = (1));

return statearr_54655;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54643){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54643);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54656){var ex__2736__auto__ = e54656;
var statearr_54657_54668 = state_54643;
(statearr_54657_54668[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54643[(4)]))){
var statearr_54658_54669 = state_54643;
(statearr_54658_54669[(1)] = cljs.core.first((state_54643[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54670 = state_54643;
state_54643 = G__54670;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54643){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54659 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54659[(6)] = c__2755__auto__);

return statearr_54659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq54611){
var G__54612 = cljs.core.first(seq54611);
var seq54611__$1 = cljs.core.next(seq54611);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54612,seq54611__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___54720 = arguments.length;
var i__4830__auto___54721 = (0);
while(true){
if((i__4830__auto___54721 < len__4829__auto___54720)){
args__4835__auto__.push((arguments[i__4830__auto___54721]));

var G__54722 = (i__4830__auto___54721 + (1));
i__4830__auto___54721 = G__54722;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54703){
var state_val_54704 = (state_54703[(1)]);
if((state_val_54704 === (1))){
var state_54703__$1 = state_54703;
var statearr_54705_54723 = state_54703__$1;
(statearr_54705_54723[(2)] = null);

(statearr_54705_54723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54704 === (2))){
var _ = (function (){var statearr_54706 = state_54703;
(statearr_54706[(4)] = cljs.core.cons((5),(state_54703[(4)])));

return statearr_54706;
})();
var inst_54679 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54703__$1 = state_54703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54703__$1,(6),inst_54679);
} else {
if((state_val_54704 === (3))){
var inst_54701 = (state_54703[(2)]);
var state_54703__$1 = state_54703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54703__$1,inst_54701);
} else {
if((state_val_54704 === (4))){
var inst_54673 = (state_54703[(2)]);
var state_54703__$1 = state_54703;
var statearr_54708_54724 = state_54703__$1;
(statearr_54708_54724[(2)] = inst_54673);

(statearr_54708_54724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54704 === (5))){
var _ = (function (){var statearr_54709 = state_54703;
(statearr_54709[(4)] = cljs.core.rest((state_54703[(4)])));

return statearr_54709;
})();
var state_54703__$1 = state_54703;
var ex54707 = (state_54703__$1[(2)]);
var statearr_54710_54725 = state_54703__$1;
(statearr_54710_54725[(5)] = ex54707);


if((ex54707 instanceof Error)){
var statearr_54711_54726 = state_54703__$1;
(statearr_54711_54726[(1)] = (4));

(statearr_54711_54726[(5)] = null);

} else {
throw ex54707;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54704 === (6))){
var inst_54681 = (state_54703[(2)]);
var inst_54682 = fluree.db.util.async.throw_err(inst_54681);
var inst_54683 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_54682);
var inst_54684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54685 = [inst_54682];
var inst_54686 = (new cljs.core.PersistentVector(null,1,(5),inst_54684,inst_54685,null));
var inst_54687 = cljs.core.count(inst_54686);
var inst_54688 = ((9) + inst_54687);
var inst_54689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54690 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54691 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54692 = [inst_54682];
var inst_54693 = (new cljs.core.PersistentVector(null,1,(5),inst_54691,inst_54692,null));
var inst_54694 = ["min",inst_54693,inst_54683];
var inst_54695 = cljs.core.PersistentHashMap.fromArrays(inst_54690,inst_54694);
var inst_54696 = [inst_54695,inst_54688];
var inst_54697 = (new cljs.core.PersistentVector(null,2,(5),inst_54689,inst_54696,null));
var inst_54698 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54697);
var _ = (function (){var statearr_54712 = state_54703;
(statearr_54712[(4)] = cljs.core.rest((state_54703[(4)])));

return statearr_54712;
})();
var state_54703__$1 = (function (){var statearr_54713 = state_54703;
(statearr_54713[(7)] = inst_54698);

return statearr_54713;
})();
var statearr_54714_54727 = state_54703__$1;
(statearr_54714_54727[(2)] = inst_54683);

(statearr_54714_54727[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54715 = [null,null,null,null,null,null,null,null];
(statearr_54715[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54715[(1)] = (1));

return statearr_54715;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54703){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54703);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54716){var ex__2736__auto__ = e54716;
var statearr_54717_54728 = state_54703;
(statearr_54717_54728[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54703[(4)]))){
var statearr_54718_54729 = state_54703;
(statearr_54718_54729[(1)] = cljs.core.first((state_54703[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54730 = state_54703;
state_54703 = G__54730;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54703){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54719 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54719[(6)] = c__2755__auto__);

return statearr_54719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq54671){
var G__54672 = cljs.core.first(seq54671);
var seq54671__$1 = cljs.core.next(seq54671);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54672,seq54671__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__54732 = arguments.length;
switch (G__54732) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54777){
var state_val_54778 = (state_54777[(1)]);
if((state_val_54778 === (7))){
var state_54777__$1 = state_54777;
var statearr_54779_54916 = state_54777__$1;
(statearr_54779_54916[(2)] = query_map);

(statearr_54779_54916[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (1))){
var state_54777__$1 = state_54777;
var statearr_54780_54917 = state_54777__$1;
(statearr_54780_54917[(2)] = null);

(statearr_54780_54917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (4))){
var inst_54733 = (state_54777[(2)]);
var state_54777__$1 = state_54777;
var statearr_54781_54918 = state_54777__$1;
(statearr_54781_54918[(2)] = inst_54733);

(statearr_54781_54918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (13))){
var inst_54755 = (state_54777[(7)]);
var inst_54759 = (state_54777[(2)]);
var inst_54760 = fluree.db.util.async.throw_err(inst_54759);
var inst_54761 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54760,(0),null);
var inst_54762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54760,(1),null);
var inst_54763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54764 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54766 = [inst_54755];
var inst_54767 = (new cljs.core.PersistentVector(null,1,(5),inst_54765,inst_54766,null));
var inst_54768 = ["query",inst_54767,inst_54761];
var inst_54769 = cljs.core.PersistentHashMap.fromArrays(inst_54764,inst_54768);
var inst_54770 = [inst_54769,inst_54762];
var inst_54771 = (new cljs.core.PersistentVector(null,2,(5),inst_54763,inst_54770,null));
var inst_54772 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54771);
var _ = (function (){var statearr_54782 = state_54777;
(statearr_54782[(4)] = cljs.core.rest((state_54777[(4)])));

return statearr_54782;
})();
var state_54777__$1 = (function (){var statearr_54783 = state_54777;
(statearr_54783[(8)] = inst_54772);

return statearr_54783;
})();
var statearr_54784_54919 = state_54777__$1;
(statearr_54784_54919[(2)] = inst_54761);

(statearr_54784_54919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (6))){
var state_54777__$1 = state_54777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54777__$1,(9),query_map);
} else {
if((state_val_54778 === (3))){
var inst_54775 = (state_54777[(2)]);
var state_54777__$1 = state_54777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54777__$1,inst_54775);
} else {
if((state_val_54778 === (12))){
var inst_54755 = (state_54777[(7)]);
var inst_54755__$1 = (state_54777[(2)]);
var inst_54756 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_54757 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_54756,inst_54755__$1);
var state_54777__$1 = (function (){var statearr_54785 = state_54777;
(statearr_54785[(7)] = inst_54755__$1);

return statearr_54785;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54777__$1,(13),inst_54757);
} else {
if((state_val_54778 === (2))){
var _ = (function (){var statearr_54786 = state_54777;
(statearr_54786[(4)] = cljs.core.cons((5),(state_54777[(4)])));

return statearr_54786;
})();
var inst_54742 = fluree.db.util.async.channel_QMARK_(query_map);
var state_54777__$1 = state_54777;
if(inst_54742){
var statearr_54787_54920 = state_54777__$1;
(statearr_54787_54920[(1)] = (6));

} else {
var statearr_54788_54921 = state_54777__$1;
(statearr_54788_54921[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (11))){
var inst_54749 = (state_54777[(9)]);
var state_54777__$1 = state_54777;
var statearr_54790_54922 = state_54777__$1;
(statearr_54790_54922[(2)] = inst_54749);

(statearr_54790_54922[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (9))){
var inst_54745 = (state_54777[(2)]);
var inst_54746 = fluree.db.util.async.throw_err(inst_54745);
var state_54777__$1 = state_54777;
var statearr_54791_54923 = state_54777__$1;
(statearr_54791_54923[(2)] = inst_54746);

(statearr_54791_54923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (5))){
var _ = (function (){var statearr_54792 = state_54777;
(statearr_54792[(4)] = cljs.core.rest((state_54777[(4)])));

return statearr_54792;
})();
var state_54777__$1 = state_54777;
var ex54789 = (state_54777__$1[(2)]);
var statearr_54793_54924 = state_54777__$1;
(statearr_54793_54924[(5)] = ex54789);


if((ex54789 instanceof Error)){
var statearr_54794_54925 = state_54777__$1;
(statearr_54794_54925[(1)] = (4));

(statearr_54794_54925[(5)] = null);

} else {
throw ex54789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (10))){
var inst_54749 = (state_54777[(9)]);
var inst_54752 = fluree.db.util.json.parse(inst_54749);
var state_54777__$1 = state_54777;
var statearr_54795_54926 = state_54777__$1;
(statearr_54795_54926[(2)] = inst_54752);

(statearr_54795_54926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54778 === (8))){
var inst_54749 = (state_54777[(9)]);
var inst_54749__$1 = (state_54777[(2)]);
var inst_54750 = typeof inst_54749__$1 === 'string';
var state_54777__$1 = (function (){var statearr_54796 = state_54777;
(statearr_54796[(9)] = inst_54749__$1);

return statearr_54796;
})();
if(cljs.core.truth_(inst_54750)){
var statearr_54797_54927 = state_54777__$1;
(statearr_54797_54927[(1)] = (10));

} else {
var statearr_54798_54928 = state_54777__$1;
(statearr_54798_54928[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54799 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54799[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54799[(1)] = (1));

return statearr_54799;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54777){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54777);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54800){var ex__2736__auto__ = e54800;
var statearr_54801_54929 = state_54777;
(statearr_54801_54929[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54777[(4)]))){
var statearr_54802_54930 = state_54777;
(statearr_54802_54930[(1)] = cljs.core.first((state_54777[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54931 = state_54777;
state_54777 = G__54931;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54777){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54803 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54803[(6)] = c__2755__auto__);

return statearr_54803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_54874){
var state_val_54875 = (state_54874[(1)]);
if((state_val_54875 === (7))){
var state_54874__$1 = state_54874;
var statearr_54876_54932 = state_54874__$1;
(statearr_54876_54932[(2)] = select);

(statearr_54876_54932[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (20))){
var inst_54844 = (state_54874[(2)]);
var inst_54845 = fluree.db.util.async.channel_QMARK_(limit);
var state_54874__$1 = (function (){var statearr_54877 = state_54874;
(statearr_54877[(7)] = inst_54844);

return statearr_54877;
})();
if(inst_54845){
var statearr_54878_54933 = state_54874__$1;
(statearr_54878_54933[(1)] = (22));

} else {
var statearr_54879_54934 = state_54874__$1;
(statearr_54879_54934[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (1))){
var state_54874__$1 = state_54874;
var statearr_54880_54935 = state_54874__$1;
(statearr_54880_54935[(2)] = null);

(statearr_54880_54935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (24))){
var inst_54828 = (state_54874[(8)]);
var inst_54836 = (state_54874[(9)]);
var inst_54820 = (state_54874[(10)]);
var inst_54844 = (state_54874[(7)]);
var inst_54852 = (state_54874[(2)]);
var inst_54853 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_54854 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_54853,inst_54820,inst_54828,inst_54836,inst_54844,inst_54852);
var state_54874__$1 = state_54874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54874__$1,(26),inst_54854);
} else {
if((state_val_54875 === (4))){
var inst_54804 = (state_54874[(2)]);
var state_54874__$1 = state_54874;
var statearr_54881_54936 = state_54874__$1;
(statearr_54881_54936[(2)] = inst_54804);

(statearr_54881_54936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (15))){
var state_54874__$1 = state_54874;
var statearr_54882_54937 = state_54874__$1;
(statearr_54882_54937[(2)] = where);

(statearr_54882_54937[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (21))){
var inst_54840 = (state_54874[(2)]);
var inst_54841 = fluree.db.util.async.throw_err(inst_54840);
var state_54874__$1 = state_54874;
var statearr_54883_54938 = state_54874__$1;
(statearr_54883_54938[(2)] = inst_54841);

(statearr_54883_54938[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (13))){
var inst_54824 = (state_54874[(2)]);
var inst_54825 = fluree.db.util.async.throw_err(inst_54824);
var state_54874__$1 = state_54874;
var statearr_54884_54939 = state_54874__$1;
(statearr_54884_54939[(2)] = inst_54825);

(statearr_54884_54939[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (22))){
var state_54874__$1 = state_54874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54874__$1,(25),limit);
} else {
if((state_val_54875 === (6))){
var state_54874__$1 = state_54874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54874__$1,(9),select);
} else {
if((state_val_54875 === (25))){
var inst_54848 = (state_54874[(2)]);
var inst_54849 = fluree.db.util.async.throw_err(inst_54848);
var state_54874__$1 = state_54874;
var statearr_54885_54940 = state_54874__$1;
(statearr_54885_54940[(2)] = inst_54849);

(statearr_54885_54940[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (17))){
var inst_54832 = (state_54874[(2)]);
var inst_54833 = fluree.db.util.async.throw_err(inst_54832);
var state_54874__$1 = state_54874;
var statearr_54886_54941 = state_54874__$1;
(statearr_54886_54941[(2)] = inst_54833);

(statearr_54886_54941[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (3))){
var inst_54872 = (state_54874[(2)]);
var state_54874__$1 = state_54874;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54874__$1,inst_54872);
} else {
if((state_val_54875 === (12))){
var inst_54828 = (state_54874[(2)]);
var inst_54829 = fluree.db.util.async.channel_QMARK_(where);
var state_54874__$1 = (function (){var statearr_54887 = state_54874;
(statearr_54887[(8)] = inst_54828);

return statearr_54887;
})();
if(inst_54829){
var statearr_54888_54942 = state_54874__$1;
(statearr_54888_54942[(1)] = (14));

} else {
var statearr_54889_54943 = state_54874__$1;
(statearr_54889_54943[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (2))){
var _ = (function (){var statearr_54890 = state_54874;
(statearr_54890[(4)] = cljs.core.cons((5),(state_54874[(4)])));

return statearr_54890;
})();
var inst_54813 = fluree.db.util.async.channel_QMARK_(select);
var state_54874__$1 = state_54874;
if(inst_54813){
var statearr_54891_54944 = state_54874__$1;
(statearr_54891_54944[(1)] = (6));

} else {
var statearr_54892_54945 = state_54874__$1;
(statearr_54892_54945[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (23))){
var state_54874__$1 = state_54874;
var statearr_54893_54946 = state_54874__$1;
(statearr_54893_54946[(2)] = limit);

(statearr_54893_54946[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (19))){
var state_54874__$1 = state_54874;
var statearr_54894_54947 = state_54874__$1;
(statearr_54894_54947[(2)] = block);

(statearr_54894_54947[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (11))){
var state_54874__$1 = state_54874;
var statearr_54896_54948 = state_54874__$1;
(statearr_54896_54948[(2)] = from);

(statearr_54896_54948[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (9))){
var inst_54816 = (state_54874[(2)]);
var inst_54817 = fluree.db.util.async.throw_err(inst_54816);
var state_54874__$1 = state_54874;
var statearr_54897_54949 = state_54874__$1;
(statearr_54897_54949[(2)] = inst_54817);

(statearr_54897_54949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (5))){
var _ = (function (){var statearr_54898 = state_54874;
(statearr_54898[(4)] = cljs.core.rest((state_54874[(4)])));

return statearr_54898;
})();
var state_54874__$1 = state_54874;
var ex54895 = (state_54874__$1[(2)]);
var statearr_54899_54950 = state_54874__$1;
(statearr_54899_54950[(5)] = ex54895);


if((ex54895 instanceof Error)){
var statearr_54900_54951 = state_54874__$1;
(statearr_54900_54951[(1)] = (4));

(statearr_54900_54951[(5)] = null);

} else {
throw ex54895;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (14))){
var state_54874__$1 = state_54874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54874__$1,(17),where);
} else {
if((state_val_54875 === (26))){
var inst_54828 = (state_54874[(8)]);
var inst_54836 = (state_54874[(9)]);
var inst_54820 = (state_54874[(10)]);
var inst_54844 = (state_54874[(7)]);
var inst_54856 = (state_54874[(2)]);
var inst_54857 = fluree.db.util.async.throw_err(inst_54856);
var inst_54858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54857,(0),null);
var inst_54859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54857,(1),null);
var inst_54860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54861 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54863 = [inst_54820,inst_54828,inst_54836,inst_54844];
var inst_54864 = (new cljs.core.PersistentVector(null,4,(5),inst_54862,inst_54863,null));
var inst_54865 = ["query",inst_54864,inst_54858];
var inst_54866 = cljs.core.PersistentHashMap.fromArrays(inst_54861,inst_54865);
var inst_54867 = [inst_54866,inst_54859];
var inst_54868 = (new cljs.core.PersistentVector(null,2,(5),inst_54860,inst_54867,null));
var inst_54869 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54868);
var _ = (function (){var statearr_54901 = state_54874;
(statearr_54901[(4)] = cljs.core.rest((state_54874[(4)])));

return statearr_54901;
})();
var state_54874__$1 = (function (){var statearr_54902 = state_54874;
(statearr_54902[(11)] = inst_54869);

return statearr_54902;
})();
var statearr_54903_54952 = state_54874__$1;
(statearr_54903_54952[(2)] = inst_54858);

(statearr_54903_54952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (16))){
var inst_54836 = (state_54874[(2)]);
var inst_54837 = fluree.db.util.async.channel_QMARK_(block);
var state_54874__$1 = (function (){var statearr_54904 = state_54874;
(statearr_54904[(9)] = inst_54836);

return statearr_54904;
})();
if(inst_54837){
var statearr_54905_54953 = state_54874__$1;
(statearr_54905_54953[(1)] = (18));

} else {
var statearr_54906_54954 = state_54874__$1;
(statearr_54906_54954[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54875 === (10))){
var state_54874__$1 = state_54874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54874__$1,(13),from);
} else {
if((state_val_54875 === (18))){
var state_54874__$1 = state_54874;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54874__$1,(21),block);
} else {
if((state_val_54875 === (8))){
var inst_54820 = (state_54874[(2)]);
var inst_54821 = fluree.db.util.async.channel_QMARK_(from);
var state_54874__$1 = (function (){var statearr_54907 = state_54874;
(statearr_54907[(10)] = inst_54820);

return statearr_54907;
})();
if(inst_54821){
var statearr_54908_54955 = state_54874__$1;
(statearr_54908_54955[(1)] = (10));

} else {
var statearr_54909_54956 = state_54874__$1;
(statearr_54909_54956[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_54910 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54910[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_54910[(1)] = (1));

return statearr_54910;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_54874){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_54874);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e54911){var ex__2736__auto__ = e54911;
var statearr_54912_54957 = state_54874;
(statearr_54912_54957[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_54874[(4)]))){
var statearr_54913_54958 = state_54874;
(statearr_54913_54958[(1)] = cljs.core.first((state_54874[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54959 = state_54874;
state_54874 = G__54959;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_54874){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_54874);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_54914 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_54914[(6)] = c__2755__auto__);

return statearr_54914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55015){
var state_val_55016 = (state_55015[(1)]);
if((state_val_55016 === (7))){
var state_55015__$1 = state_55015;
var statearr_55017_55048 = state_55015__$1;
(statearr_55017_55048[(2)] = startSubject);

(statearr_55017_55048[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (1))){
var state_55015__$1 = state_55015;
var statearr_55018_55049 = state_55015__$1;
(statearr_55018_55049[(2)] = null);

(statearr_55018_55049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (4))){
var inst_54960 = (state_55015[(2)]);
var state_55015__$1 = state_55015;
var statearr_55019_55050 = state_55015__$1;
(statearr_55019_55050[(2)] = inst_54960);

(statearr_55019_55050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (15))){
var inst_54992 = (state_55015[(2)]);
var inst_54993 = fluree.db.util.async.throw_err(inst_54992);
var inst_54994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54993,(0),null);
var inst_54995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54993,(1),null);
var inst_54996 = cljs.core.empty_QMARK_(inst_54994);
var state_55015__$1 = (function (){var statearr_55020 = state_55015;
(statearr_55020[(7)] = inst_54995);

return statearr_55020;
})();
if(inst_54996){
var statearr_55021_55051 = state_55015__$1;
(statearr_55021_55051[(1)] = (16));

} else {
var statearr_55022_55052 = state_55015__$1;
(statearr_55022_55052[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (13))){
var inst_54988 = (state_55015[(8)]);
var inst_54976 = (state_55015[(9)]);
var inst_54980 = (state_55015[(10)]);
var inst_54988__$1 = (state_55015[(2)]);
var inst_54989 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_54990 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_54989,inst_54976,inst_54980,inst_54988__$1);
var state_55015__$1 = (function (){var statearr_55023 = state_55015;
(statearr_55023[(8)] = inst_54988__$1);

return statearr_55023;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55015__$1,(15),inst_54990);
} else {
if((state_val_55016 === (6))){
var state_55015__$1 = state_55015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55015__$1,(9),startSubject);
} else {
if((state_val_55016 === (17))){
var state_55015__$1 = state_55015;
var statearr_55024_55053 = state_55015__$1;
(statearr_55024_55053[(2)] = true);

(statearr_55024_55053[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (3))){
var inst_55013 = (state_55015[(2)]);
var state_55015__$1 = state_55015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55015__$1,inst_55013);
} else {
if((state_val_55016 === (12))){
var state_55015__$1 = state_55015;
var statearr_55025_55054 = state_55015__$1;
(statearr_55025_55054[(2)] = endSubject);

(statearr_55025_55054[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (2))){
var _ = (function (){var statearr_55026 = state_55015;
(statearr_55026[(4)] = cljs.core.cons((5),(state_55015[(4)])));

return statearr_55026;
})();
var inst_54969 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_55015__$1 = state_55015;
if(inst_54969){
var statearr_55027_55055 = state_55015__$1;
(statearr_55027_55055[(1)] = (6));

} else {
var statearr_55028_55056 = state_55015__$1;
(statearr_55028_55056[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (11))){
var state_55015__$1 = state_55015;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55015__$1,(14),endSubject);
} else {
if((state_val_55016 === (9))){
var inst_54972 = (state_55015[(2)]);
var inst_54973 = fluree.db.util.async.throw_err(inst_54972);
var state_55015__$1 = state_55015;
var statearr_55030_55057 = state_55015__$1;
(statearr_55030_55057[(2)] = inst_54973);

(statearr_55030_55057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (5))){
var _ = (function (){var statearr_55031 = state_55015;
(statearr_55031[(4)] = cljs.core.rest((state_55015[(4)])));

return statearr_55031;
})();
var state_55015__$1 = state_55015;
var ex55029 = (state_55015__$1[(2)]);
var statearr_55032_55058 = state_55015__$1;
(statearr_55032_55058[(5)] = ex55029);


if((ex55029 instanceof Error)){
var statearr_55033_55059 = state_55015__$1;
(statearr_55033_55059[(1)] = (4));

(statearr_55033_55059[(5)] = null);

} else {
throw ex55029;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (14))){
var inst_54984 = (state_55015[(2)]);
var inst_54985 = fluree.db.util.async.throw_err(inst_54984);
var state_55015__$1 = state_55015;
var statearr_55034_55060 = state_55015__$1;
(statearr_55034_55060[(2)] = inst_54985);

(statearr_55034_55060[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (16))){
var state_55015__$1 = state_55015;
var statearr_55035_55061 = state_55015__$1;
(statearr_55035_55061[(2)] = false);

(statearr_55035_55061[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (10))){
var inst_54979 = (state_55015[(2)]);
var inst_54980 = fluree.db.util.async.throw_err(inst_54979);
var inst_54981 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_55015__$1 = (function (){var statearr_55036 = state_55015;
(statearr_55036[(10)] = inst_54980);

return statearr_55036;
})();
if(inst_54981){
var statearr_55037_55062 = state_55015__$1;
(statearr_55037_55062[(1)] = (11));

} else {
var statearr_55038_55063 = state_55015__$1;
(statearr_55038_55063[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (18))){
var inst_54988 = (state_55015[(8)]);
var inst_54976 = (state_55015[(9)]);
var inst_54995 = (state_55015[(7)]);
var inst_54980 = (state_55015[(10)]);
var inst_55000 = (state_55015[(2)]);
var inst_55001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55002 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55004 = [inst_54976,inst_54980,inst_54988];
var inst_55005 = (new cljs.core.PersistentVector(null,3,(5),inst_55003,inst_55004,null));
var inst_55006 = ["relationship?",inst_55005,inst_55000];
var inst_55007 = cljs.core.PersistentHashMap.fromArrays(inst_55002,inst_55006);
var inst_55008 = [inst_55007,inst_54995];
var inst_55009 = (new cljs.core.PersistentVector(null,2,(5),inst_55001,inst_55008,null));
var inst_55010 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55009);
var _ = (function (){var statearr_55039 = state_55015;
(statearr_55039[(4)] = cljs.core.rest((state_55015[(4)])));

return statearr_55039;
})();
var state_55015__$1 = (function (){var statearr_55040 = state_55015;
(statearr_55040[(11)] = inst_55010);

return statearr_55040;
})();
var statearr_55041_55064 = state_55015__$1;
(statearr_55041_55064[(2)] = inst_55000);

(statearr_55041_55064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55016 === (8))){
var inst_54976 = (state_55015[(2)]);
var inst_54977 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_55015__$1 = (function (){var statearr_55042 = state_55015;
(statearr_55042[(9)] = inst_54976);

return statearr_55042;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55015__$1,(10),inst_54977);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_55043 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55043[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__);

(statearr_55043[(1)] = (1));

return statearr_55043;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____1 = (function (state_55015){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55015);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55044){var ex__2736__auto__ = e55044;
var statearr_55045_55065 = state_55015;
(statearr_55045_55065[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55015[(4)]))){
var statearr_55046_55066 = state_55015;
(statearr_55046_55066[(1)] = cljs.core.first((state_55015[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55067 = state_55015;
state_55015 = G__55067;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__ = function(state_55015){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____1.call(this,state_55015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55047 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55047[(6)] = c__2755__auto__);

return statearr_55047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55104){
var state_val_55105 = (state_55104[(1)]);
if((state_val_55105 === (7))){
var state_55104__$1 = state_55104;
var statearr_55106_55126 = state_55104__$1;
(statearr_55106_55126[(2)] = pred_name);

(statearr_55106_55126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (1))){
var state_55104__$1 = state_55104;
var statearr_55107_55127 = state_55104__$1;
(statearr_55107_55127[(2)] = null);

(statearr_55107_55127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (4))){
var inst_55068 = (state_55104[(2)]);
var state_55104__$1 = state_55104;
var statearr_55108_55128 = state_55104__$1;
(statearr_55108_55128[(2)] = inst_55068);

(statearr_55108_55128[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (6))){
var state_55104__$1 = state_55104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55104__$1,(9),pred_name);
} else {
if((state_val_55105 === (3))){
var inst_55102 = (state_55104[(2)]);
var state_55104__$1 = state_55104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55104__$1,inst_55102);
} else {
if((state_val_55105 === (2))){
var _ = (function (){var statearr_55110 = state_55104;
(statearr_55110[(4)] = cljs.core.cons((5),(state_55104[(4)])));

return statearr_55110;
})();
var inst_55077 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_55104__$1 = state_55104;
if(inst_55077){
var statearr_55111_55129 = state_55104__$1;
(statearr_55111_55129[(1)] = (6));

} else {
var statearr_55112_55130 = state_55104__$1;
(statearr_55112_55130[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (9))){
var inst_55080 = (state_55104[(2)]);
var inst_55081 = fluree.db.util.async.throw_err(inst_55080);
var state_55104__$1 = state_55104;
var statearr_55113_55131 = state_55104__$1;
(statearr_55113_55131[(2)] = inst_55081);

(statearr_55113_55131[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (5))){
var _ = (function (){var statearr_55114 = state_55104;
(statearr_55114[(4)] = cljs.core.rest((state_55104[(4)])));

return statearr_55114;
})();
var state_55104__$1 = state_55104;
var ex55109 = (state_55104__$1[(2)]);
var statearr_55115_55132 = state_55104__$1;
(statearr_55115_55132[(5)] = ex55109);


if((ex55109 instanceof Error)){
var statearr_55116_55133 = state_55104__$1;
(statearr_55116_55133[(1)] = (4));

(statearr_55116_55133[(5)] = null);

} else {
throw ex55109;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (10))){
var inst_55084 = (state_55104[(7)]);
var inst_55088 = (state_55104[(2)]);
var inst_55089 = fluree.db.util.async.throw_err(inst_55088);
var inst_55090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55089,(0),null);
var inst_55091 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55089,(1),null);
var inst_55092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55093 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55094 = ["max-pred-val",inst_55084,inst_55090];
var inst_55095 = cljs.core.PersistentHashMap.fromArrays(inst_55093,inst_55094);
var inst_55096 = (inst_55091 + (10));
var inst_55097 = [inst_55095,inst_55096];
var inst_55098 = (new cljs.core.PersistentVector(null,2,(5),inst_55092,inst_55097,null));
var inst_55099 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55098);
var _ = (function (){var statearr_55117 = state_55104;
(statearr_55117[(4)] = cljs.core.rest((state_55104[(4)])));

return statearr_55117;
})();
var state_55104__$1 = (function (){var statearr_55118 = state_55104;
(statearr_55118[(8)] = inst_55099);

return statearr_55118;
})();
var statearr_55119_55134 = state_55104__$1;
(statearr_55119_55134[(2)] = inst_55090);

(statearr_55119_55134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55105 === (8))){
var inst_55084 = (state_55104[(7)]);
var inst_55084__$1 = (state_55104[(2)]);
var inst_55085 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55086 = fluree.db.dbfunctions.internal.max_pred_val(inst_55085,inst_55084__$1,null);
var state_55104__$1 = (function (){var statearr_55120 = state_55104;
(statearr_55120[(7)] = inst_55084__$1);

return statearr_55120;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55104__$1,(10),inst_55086);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____0 = (function (){
var statearr_55121 = [null,null,null,null,null,null,null,null,null];
(statearr_55121[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__);

(statearr_55121[(1)] = (1));

return statearr_55121;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____1 = (function (state_55104){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55104);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55122){var ex__2736__auto__ = e55122;
var statearr_55123_55135 = state_55104;
(statearr_55123_55135[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55104[(4)]))){
var statearr_55124_55136 = state_55104;
(statearr_55124_55136[(1)] = cljs.core.first((state_55104[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55137 = state_55104;
state_55104 = G__55137;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__ = function(state_55104){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____1.call(this,state_55104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55125 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55125[(6)] = c__2755__auto__);

return statearr_55125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55164){
var state_val_55165 = (state_55164[(1)]);
if((state_val_55165 === (7))){
var state_55164__$1 = state_55164;
var statearr_55166_55185 = state_55164__$1;
(statearr_55166_55185[(2)] = n);

(statearr_55166_55185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55165 === (1))){
var state_55164__$1 = state_55164;
var statearr_55167_55186 = state_55164__$1;
(statearr_55167_55186[(2)] = null);

(statearr_55167_55186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55165 === (4))){
var inst_55138 = (state_55164[(2)]);
var state_55164__$1 = state_55164;
var statearr_55168_55187 = state_55164__$1;
(statearr_55168_55187[(2)] = inst_55138);

(statearr_55168_55187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55165 === (6))){
var state_55164__$1 = state_55164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55164__$1,(9),n);
} else {
if((state_val_55165 === (3))){
var inst_55162 = (state_55164[(2)]);
var state_55164__$1 = state_55164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55164__$1,inst_55162);
} else {
if((state_val_55165 === (2))){
var _ = (function (){var statearr_55170 = state_55164;
(statearr_55170[(4)] = cljs.core.cons((5),(state_55164[(4)])));

return statearr_55170;
})();
var inst_55144 = fluree.db.util.async.channel_QMARK_(n);
var state_55164__$1 = state_55164;
if(inst_55144){
var statearr_55171_55188 = state_55164__$1;
(statearr_55171_55188[(1)] = (6));

} else {
var statearr_55172_55189 = state_55164__$1;
(statearr_55172_55189[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55165 === (9))){
var inst_55147 = (state_55164[(2)]);
var inst_55148 = fluree.db.util.async.throw_err(inst_55147);
var state_55164__$1 = state_55164;
var statearr_55173_55190 = state_55164__$1;
(statearr_55173_55190[(2)] = inst_55148);

(statearr_55173_55190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55165 === (5))){
var _ = (function (){var statearr_55174 = state_55164;
(statearr_55174[(4)] = cljs.core.rest((state_55164[(4)])));

return statearr_55174;
})();
var state_55164__$1 = state_55164;
var ex55169 = (state_55164__$1[(2)]);
var statearr_55175_55191 = state_55164__$1;
(statearr_55175_55191[(5)] = ex55169);


if((ex55169 instanceof Error)){
var statearr_55176_55192 = state_55164__$1;
(statearr_55176_55192[(1)] = (4));

(statearr_55176_55192[(5)] = null);

} else {
throw ex55169;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55165 === (8))){
var inst_55151 = (state_55164[(2)]);
var inst_55152 = fluree.db.dbfunctions.internal.inc(inst_55151);
var inst_55153 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55154 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55155 = ["inc",inst_55151,inst_55152];
var inst_55156 = cljs.core.PersistentHashMap.fromArrays(inst_55154,inst_55155);
var inst_55157 = [inst_55156,(10)];
var inst_55158 = (new cljs.core.PersistentVector(null,2,(5),inst_55153,inst_55157,null));
var inst_55159 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55158);
var _ = (function (){var statearr_55177 = state_55164;
(statearr_55177[(4)] = cljs.core.rest((state_55164[(4)])));

return statearr_55177;
})();
var state_55164__$1 = (function (){var statearr_55178 = state_55164;
(statearr_55178[(7)] = inst_55159);

return statearr_55178;
})();
var statearr_55179_55193 = state_55164__$1;
(statearr_55179_55193[(2)] = inst_55152);

(statearr_55179_55193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____0 = (function (){
var statearr_55180 = [null,null,null,null,null,null,null,null];
(statearr_55180[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__);

(statearr_55180[(1)] = (1));

return statearr_55180;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____1 = (function (state_55164){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55164);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55181){var ex__2736__auto__ = e55181;
var statearr_55182_55194 = state_55164;
(statearr_55182_55194[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55164[(4)]))){
var statearr_55183_55195 = state_55164;
(statearr_55183_55195[(1)] = cljs.core.first((state_55164[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55196 = state_55164;
state_55164 = G__55196;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__ = function(state_55164){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____1.call(this,state_55164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55184 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55184[(6)] = c__2755__auto__);

return statearr_55184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55223){
var state_val_55224 = (state_55223[(1)]);
if((state_val_55224 === (7))){
var state_55223__$1 = state_55223;
var statearr_55225_55244 = state_55223__$1;
(statearr_55225_55244[(2)] = n);

(statearr_55225_55244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55224 === (1))){
var state_55223__$1 = state_55223;
var statearr_55226_55245 = state_55223__$1;
(statearr_55226_55245[(2)] = null);

(statearr_55226_55245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55224 === (4))){
var inst_55197 = (state_55223[(2)]);
var state_55223__$1 = state_55223;
var statearr_55227_55246 = state_55223__$1;
(statearr_55227_55246[(2)] = inst_55197);

(statearr_55227_55246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55224 === (6))){
var state_55223__$1 = state_55223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55223__$1,(9),n);
} else {
if((state_val_55224 === (3))){
var inst_55221 = (state_55223[(2)]);
var state_55223__$1 = state_55223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55223__$1,inst_55221);
} else {
if((state_val_55224 === (2))){
var _ = (function (){var statearr_55229 = state_55223;
(statearr_55229[(4)] = cljs.core.cons((5),(state_55223[(4)])));

return statearr_55229;
})();
var inst_55203 = fluree.db.util.async.channel_QMARK_(n);
var state_55223__$1 = state_55223;
if(inst_55203){
var statearr_55230_55247 = state_55223__$1;
(statearr_55230_55247[(1)] = (6));

} else {
var statearr_55231_55248 = state_55223__$1;
(statearr_55231_55248[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55224 === (9))){
var inst_55206 = (state_55223[(2)]);
var inst_55207 = fluree.db.util.async.throw_err(inst_55206);
var state_55223__$1 = state_55223;
var statearr_55232_55249 = state_55223__$1;
(statearr_55232_55249[(2)] = inst_55207);

(statearr_55232_55249[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55224 === (5))){
var _ = (function (){var statearr_55233 = state_55223;
(statearr_55233[(4)] = cljs.core.rest((state_55223[(4)])));

return statearr_55233;
})();
var state_55223__$1 = state_55223;
var ex55228 = (state_55223__$1[(2)]);
var statearr_55234_55250 = state_55223__$1;
(statearr_55234_55250[(5)] = ex55228);


if((ex55228 instanceof Error)){
var statearr_55235_55251 = state_55223__$1;
(statearr_55235_55251[(1)] = (4));

(statearr_55235_55251[(5)] = null);

} else {
throw ex55228;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55224 === (8))){
var inst_55210 = (state_55223[(2)]);
var inst_55211 = fluree.db.dbfunctions.internal.dec(inst_55210);
var inst_55212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55213 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55214 = ["dec",inst_55210,inst_55211];
var inst_55215 = cljs.core.PersistentHashMap.fromArrays(inst_55213,inst_55214);
var inst_55216 = [inst_55215,(10)];
var inst_55217 = (new cljs.core.PersistentVector(null,2,(5),inst_55212,inst_55216,null));
var inst_55218 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55217);
var _ = (function (){var statearr_55236 = state_55223;
(statearr_55236[(4)] = cljs.core.rest((state_55223[(4)])));

return statearr_55236;
})();
var state_55223__$1 = (function (){var statearr_55237 = state_55223;
(statearr_55237[(7)] = inst_55218);

return statearr_55237;
})();
var statearr_55238_55252 = state_55223__$1;
(statearr_55238_55252[(2)] = inst_55211);

(statearr_55238_55252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____0 = (function (){
var statearr_55239 = [null,null,null,null,null,null,null,null];
(statearr_55239[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__);

(statearr_55239[(1)] = (1));

return statearr_55239;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____1 = (function (state_55223){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55223);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55240){var ex__2736__auto__ = e55240;
var statearr_55241_55253 = state_55223;
(statearr_55241_55253[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55223[(4)]))){
var statearr_55242_55254 = state_55223;
(statearr_55242_55254[(1)] = cljs.core.first((state_55223[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55255 = state_55223;
state_55223 = G__55255;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__ = function(state_55223){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____1.call(this,state_55223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55243 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55243[(6)] = c__2755__auto__);

return statearr_55243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55305 = arguments.length;
var i__4830__auto___55306 = (0);
while(true){
if((i__4830__auto___55306 < len__4829__auto___55305)){
args__4835__auto__.push((arguments[i__4830__auto___55306]));

var G__55307 = (i__4830__auto___55306 + (1));
i__4830__auto___55306 = G__55307;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55288){
var state_val_55289 = (state_55288[(1)]);
if((state_val_55289 === (1))){
var state_55288__$1 = state_55288;
var statearr_55290_55308 = state_55288__$1;
(statearr_55290_55308[(2)] = null);

(statearr_55290_55308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (2))){
var _ = (function (){var statearr_55291 = state_55288;
(statearr_55291[(4)] = cljs.core.cons((5),(state_55288[(4)])));

return statearr_55291;
})();
var inst_55264 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55288__$1 = state_55288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55288__$1,(6),inst_55264);
} else {
if((state_val_55289 === (3))){
var inst_55286 = (state_55288[(2)]);
var state_55288__$1 = state_55288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55288__$1,inst_55286);
} else {
if((state_val_55289 === (4))){
var inst_55258 = (state_55288[(2)]);
var state_55288__$1 = state_55288;
var statearr_55293_55309 = state_55288__$1;
(statearr_55293_55309[(2)] = inst_55258);

(statearr_55293_55309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (5))){
var _ = (function (){var statearr_55294 = state_55288;
(statearr_55294[(4)] = cljs.core.rest((state_55288[(4)])));

return statearr_55294;
})();
var state_55288__$1 = state_55288;
var ex55292 = (state_55288__$1[(2)]);
var statearr_55295_55310 = state_55288__$1;
(statearr_55295_55310[(5)] = ex55292);


if((ex55292 instanceof Error)){
var statearr_55296_55311 = state_55288__$1;
(statearr_55296_55311[(1)] = (4));

(statearr_55296_55311[(5)] = null);

} else {
throw ex55292;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55289 === (6))){
var inst_55266 = (state_55288[(2)]);
var inst_55267 = fluree.db.util.async.throw_err(inst_55266);
var inst_55268 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_55267);
var inst_55269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55270 = [inst_55267];
var inst_55271 = (new cljs.core.PersistentVector(null,1,(5),inst_55269,inst_55270,null));
var inst_55272 = cljs.core.count(inst_55271);
var inst_55273 = ((9) + inst_55272);
var inst_55274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55275 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55277 = [inst_55267];
var inst_55278 = (new cljs.core.PersistentVector(null,1,(5),inst_55276,inst_55277,null));
var inst_55279 = ["+",inst_55278,inst_55268];
var inst_55280 = cljs.core.PersistentHashMap.fromArrays(inst_55275,inst_55279);
var inst_55281 = [inst_55280,inst_55273];
var inst_55282 = (new cljs.core.PersistentVector(null,2,(5),inst_55274,inst_55281,null));
var inst_55283 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55282);
var _ = (function (){var statearr_55297 = state_55288;
(statearr_55297[(4)] = cljs.core.rest((state_55288[(4)])));

return statearr_55297;
})();
var state_55288__$1 = (function (){var statearr_55298 = state_55288;
(statearr_55298[(7)] = inst_55283);

return statearr_55298;
})();
var statearr_55299_55312 = state_55288__$1;
(statearr_55299_55312[(2)] = inst_55268);

(statearr_55299_55312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55300 = [null,null,null,null,null,null,null,null];
(statearr_55300[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55300[(1)] = (1));

return statearr_55300;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55288){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55288);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55301){var ex__2736__auto__ = e55301;
var statearr_55302_55313 = state_55288;
(statearr_55302_55313[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55288[(4)]))){
var statearr_55303_55314 = state_55288;
(statearr_55303_55314[(1)] = cljs.core.first((state_55288[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55315 = state_55288;
state_55288 = G__55315;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55288){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55304 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55304[(6)] = c__2755__auto__);

return statearr_55304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55256){
var G__55257 = cljs.core.first(seq55256);
var seq55256__$1 = cljs.core.next(seq55256);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55257,seq55256__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55365 = arguments.length;
var i__4830__auto___55366 = (0);
while(true){
if((i__4830__auto___55366 < len__4829__auto___55365)){
args__4835__auto__.push((arguments[i__4830__auto___55366]));

var G__55367 = (i__4830__auto___55366 + (1));
i__4830__auto___55366 = G__55367;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55348){
var state_val_55349 = (state_55348[(1)]);
if((state_val_55349 === (1))){
var state_55348__$1 = state_55348;
var statearr_55350_55368 = state_55348__$1;
(statearr_55350_55368[(2)] = null);

(statearr_55350_55368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55349 === (2))){
var _ = (function (){var statearr_55351 = state_55348;
(statearr_55351[(4)] = cljs.core.cons((5),(state_55348[(4)])));

return statearr_55351;
})();
var inst_55324 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55348__$1 = state_55348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55348__$1,(6),inst_55324);
} else {
if((state_val_55349 === (3))){
var inst_55346 = (state_55348[(2)]);
var state_55348__$1 = state_55348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55348__$1,inst_55346);
} else {
if((state_val_55349 === (4))){
var inst_55318 = (state_55348[(2)]);
var state_55348__$1 = state_55348;
var statearr_55353_55369 = state_55348__$1;
(statearr_55353_55369[(2)] = inst_55318);

(statearr_55353_55369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55349 === (5))){
var _ = (function (){var statearr_55354 = state_55348;
(statearr_55354[(4)] = cljs.core.rest((state_55348[(4)])));

return statearr_55354;
})();
var state_55348__$1 = state_55348;
var ex55352 = (state_55348__$1[(2)]);
var statearr_55355_55370 = state_55348__$1;
(statearr_55355_55370[(5)] = ex55352);


if((ex55352 instanceof Error)){
var statearr_55356_55371 = state_55348__$1;
(statearr_55356_55371[(1)] = (4));

(statearr_55356_55371[(5)] = null);

} else {
throw ex55352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55349 === (6))){
var inst_55326 = (state_55348[(2)]);
var inst_55327 = fluree.db.util.async.throw_err(inst_55326);
var inst_55328 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_55327);
var inst_55329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55330 = [inst_55327];
var inst_55331 = (new cljs.core.PersistentVector(null,1,(5),inst_55329,inst_55330,null));
var inst_55332 = cljs.core.count(inst_55331);
var inst_55333 = ((9) + inst_55332);
var inst_55334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55335 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55337 = [inst_55327];
var inst_55338 = (new cljs.core.PersistentVector(null,1,(5),inst_55336,inst_55337,null));
var inst_55339 = ["-",inst_55338,inst_55328];
var inst_55340 = cljs.core.PersistentHashMap.fromArrays(inst_55335,inst_55339);
var inst_55341 = [inst_55340,inst_55333];
var inst_55342 = (new cljs.core.PersistentVector(null,2,(5),inst_55334,inst_55341,null));
var inst_55343 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55342);
var _ = (function (){var statearr_55357 = state_55348;
(statearr_55357[(4)] = cljs.core.rest((state_55348[(4)])));

return statearr_55357;
})();
var state_55348__$1 = (function (){var statearr_55358 = state_55348;
(statearr_55358[(7)] = inst_55343);

return statearr_55358;
})();
var statearr_55359_55372 = state_55348__$1;
(statearr_55359_55372[(2)] = inst_55328);

(statearr_55359_55372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55360 = [null,null,null,null,null,null,null,null];
(statearr_55360[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55360[(1)] = (1));

return statearr_55360;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55348){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55348);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55361){var ex__2736__auto__ = e55361;
var statearr_55362_55373 = state_55348;
(statearr_55362_55373[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55348[(4)]))){
var statearr_55363_55374 = state_55348;
(statearr_55363_55374[(1)] = cljs.core.first((state_55348[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55375 = state_55348;
state_55348 = G__55375;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55348){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55364 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55364[(6)] = c__2755__auto__);

return statearr_55364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55316){
var G__55317 = cljs.core.first(seq55316);
var seq55316__$1 = cljs.core.next(seq55316);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55317,seq55316__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55425 = arguments.length;
var i__4830__auto___55426 = (0);
while(true){
if((i__4830__auto___55426 < len__4829__auto___55425)){
args__4835__auto__.push((arguments[i__4830__auto___55426]));

var G__55427 = (i__4830__auto___55426 + (1));
i__4830__auto___55426 = G__55427;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55408){
var state_val_55409 = (state_55408[(1)]);
if((state_val_55409 === (1))){
var state_55408__$1 = state_55408;
var statearr_55410_55428 = state_55408__$1;
(statearr_55410_55428[(2)] = null);

(statearr_55410_55428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55409 === (2))){
var _ = (function (){var statearr_55411 = state_55408;
(statearr_55411[(4)] = cljs.core.cons((5),(state_55408[(4)])));

return statearr_55411;
})();
var inst_55384 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55408__$1 = state_55408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55408__$1,(6),inst_55384);
} else {
if((state_val_55409 === (3))){
var inst_55406 = (state_55408[(2)]);
var state_55408__$1 = state_55408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55408__$1,inst_55406);
} else {
if((state_val_55409 === (4))){
var inst_55378 = (state_55408[(2)]);
var state_55408__$1 = state_55408;
var statearr_55413_55429 = state_55408__$1;
(statearr_55413_55429[(2)] = inst_55378);

(statearr_55413_55429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55409 === (5))){
var _ = (function (){var statearr_55414 = state_55408;
(statearr_55414[(4)] = cljs.core.rest((state_55408[(4)])));

return statearr_55414;
})();
var state_55408__$1 = state_55408;
var ex55412 = (state_55408__$1[(2)]);
var statearr_55415_55430 = state_55408__$1;
(statearr_55415_55430[(5)] = ex55412);


if((ex55412 instanceof Error)){
var statearr_55416_55431 = state_55408__$1;
(statearr_55416_55431[(1)] = (4));

(statearr_55416_55431[(5)] = null);

} else {
throw ex55412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55409 === (6))){
var inst_55386 = (state_55408[(2)]);
var inst_55387 = fluree.db.util.async.throw_err(inst_55386);
var inst_55388 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_55387);
var inst_55389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55390 = [inst_55387];
var inst_55391 = (new cljs.core.PersistentVector(null,1,(5),inst_55389,inst_55390,null));
var inst_55392 = cljs.core.count(inst_55391);
var inst_55393 = ((9) + inst_55392);
var inst_55394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55395 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55397 = [inst_55387];
var inst_55398 = (new cljs.core.PersistentVector(null,1,(5),inst_55396,inst_55397,null));
var inst_55399 = ["*",inst_55398,inst_55388];
var inst_55400 = cljs.core.PersistentHashMap.fromArrays(inst_55395,inst_55399);
var inst_55401 = [inst_55400,inst_55393];
var inst_55402 = (new cljs.core.PersistentVector(null,2,(5),inst_55394,inst_55401,null));
var inst_55403 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55402);
var _ = (function (){var statearr_55417 = state_55408;
(statearr_55417[(4)] = cljs.core.rest((state_55408[(4)])));

return statearr_55417;
})();
var state_55408__$1 = (function (){var statearr_55418 = state_55408;
(statearr_55418[(7)] = inst_55403);

return statearr_55418;
})();
var statearr_55419_55432 = state_55408__$1;
(statearr_55419_55432[(2)] = inst_55388);

(statearr_55419_55432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55420 = [null,null,null,null,null,null,null,null];
(statearr_55420[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55420[(1)] = (1));

return statearr_55420;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55408){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55408);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55421){var ex__2736__auto__ = e55421;
var statearr_55422_55433 = state_55408;
(statearr_55422_55433[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55408[(4)]))){
var statearr_55423_55434 = state_55408;
(statearr_55423_55434[(1)] = cljs.core.first((state_55408[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55435 = state_55408;
state_55408 = G__55435;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55408){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55424 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55424[(6)] = c__2755__auto__);

return statearr_55424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55376){
var G__55377 = cljs.core.first(seq55376);
var seq55376__$1 = cljs.core.next(seq55376);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55377,seq55376__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55485 = arguments.length;
var i__4830__auto___55486 = (0);
while(true){
if((i__4830__auto___55486 < len__4829__auto___55485)){
args__4835__auto__.push((arguments[i__4830__auto___55486]));

var G__55487 = (i__4830__auto___55486 + (1));
i__4830__auto___55486 = G__55487;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55468){
var state_val_55469 = (state_55468[(1)]);
if((state_val_55469 === (1))){
var state_55468__$1 = state_55468;
var statearr_55470_55488 = state_55468__$1;
(statearr_55470_55488[(2)] = null);

(statearr_55470_55488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (2))){
var _ = (function (){var statearr_55471 = state_55468;
(statearr_55471[(4)] = cljs.core.cons((5),(state_55468[(4)])));

return statearr_55471;
})();
var inst_55444 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55468__$1 = state_55468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55468__$1,(6),inst_55444);
} else {
if((state_val_55469 === (3))){
var inst_55466 = (state_55468[(2)]);
var state_55468__$1 = state_55468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55468__$1,inst_55466);
} else {
if((state_val_55469 === (4))){
var inst_55438 = (state_55468[(2)]);
var state_55468__$1 = state_55468;
var statearr_55473_55489 = state_55468__$1;
(statearr_55473_55489[(2)] = inst_55438);

(statearr_55473_55489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (5))){
var _ = (function (){var statearr_55474 = state_55468;
(statearr_55474[(4)] = cljs.core.rest((state_55468[(4)])));

return statearr_55474;
})();
var state_55468__$1 = state_55468;
var ex55472 = (state_55468__$1[(2)]);
var statearr_55475_55490 = state_55468__$1;
(statearr_55475_55490[(5)] = ex55472);


if((ex55472 instanceof Error)){
var statearr_55476_55491 = state_55468__$1;
(statearr_55476_55491[(1)] = (4));

(statearr_55476_55491[(5)] = null);

} else {
throw ex55472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55469 === (6))){
var inst_55446 = (state_55468[(2)]);
var inst_55447 = fluree.db.util.async.throw_err(inst_55446);
var inst_55448 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_55447);
var inst_55449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55450 = [inst_55447];
var inst_55451 = (new cljs.core.PersistentVector(null,1,(5),inst_55449,inst_55450,null));
var inst_55452 = cljs.core.count(inst_55451);
var inst_55453 = ((9) + inst_55452);
var inst_55454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55455 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55457 = [inst_55447];
var inst_55458 = (new cljs.core.PersistentVector(null,1,(5),inst_55456,inst_55457,null));
var inst_55459 = ["/",inst_55458,inst_55448];
var inst_55460 = cljs.core.PersistentHashMap.fromArrays(inst_55455,inst_55459);
var inst_55461 = [inst_55460,inst_55453];
var inst_55462 = (new cljs.core.PersistentVector(null,2,(5),inst_55454,inst_55461,null));
var inst_55463 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55462);
var _ = (function (){var statearr_55477 = state_55468;
(statearr_55477[(4)] = cljs.core.rest((state_55468[(4)])));

return statearr_55477;
})();
var state_55468__$1 = (function (){var statearr_55478 = state_55468;
(statearr_55478[(7)] = inst_55463);

return statearr_55478;
})();
var statearr_55479_55492 = state_55468__$1;
(statearr_55479_55492[(2)] = inst_55448);

(statearr_55479_55492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_55480 = [null,null,null,null,null,null,null,null];
(statearr_55480[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_55480[(1)] = (1));

return statearr_55480;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_55468){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55468);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55481){var ex__2736__auto__ = e55481;
var statearr_55482_55493 = state_55468;
(statearr_55482_55493[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55468[(4)]))){
var statearr_55483_55494 = state_55468;
(statearr_55483_55494[(1)] = cljs.core.first((state_55468[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55495 = state_55468;
state_55468 = G__55495;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_55468){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_55468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55484 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55484[(6)] = c__2755__auto__);

return statearr_55484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq55436){
var G__55437 = cljs.core.first(seq55436);
var seq55436__$1 = cljs.core.next(seq55436);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55437,seq55436__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55533){
var state_val_55534 = (state_55533[(1)]);
if((state_val_55534 === (7))){
var state_55533__$1 = state_55533;
var statearr_55535_55559 = state_55533__$1;
(statearr_55535_55559[(2)] = n);

(statearr_55535_55559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (1))){
var state_55533__$1 = state_55533;
var statearr_55536_55560 = state_55533__$1;
(statearr_55536_55560[(2)] = null);

(statearr_55536_55560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (4))){
var inst_55496 = (state_55533[(2)]);
var state_55533__$1 = state_55533;
var statearr_55537_55561 = state_55533__$1;
(statearr_55537_55561[(2)] = inst_55496);

(statearr_55537_55561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (13))){
var inst_55513 = (state_55533[(2)]);
var inst_55514 = fluree.db.util.async.throw_err(inst_55513);
var state_55533__$1 = state_55533;
var statearr_55538_55562 = state_55533__$1;
(statearr_55538_55562[(2)] = inst_55514);

(statearr_55538_55562[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (6))){
var state_55533__$1 = state_55533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55533__$1,(9),n);
} else {
if((state_val_55534 === (3))){
var inst_55531 = (state_55533[(2)]);
var state_55533__$1 = state_55533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55533__$1,inst_55531);
} else {
if((state_val_55534 === (12))){
var inst_55509 = (state_55533[(7)]);
var inst_55517 = (state_55533[(2)]);
var inst_55518 = fluree.db.dbfunctions.internal.quot(inst_55509,inst_55517);
var inst_55519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55520 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55522 = [inst_55509,inst_55517];
var inst_55523 = (new cljs.core.PersistentVector(null,2,(5),inst_55521,inst_55522,null));
var inst_55524 = ["quot",inst_55523,inst_55518];
var inst_55525 = cljs.core.PersistentHashMap.fromArrays(inst_55520,inst_55524);
var inst_55526 = [inst_55525,(2)];
var inst_55527 = (new cljs.core.PersistentVector(null,2,(5),inst_55519,inst_55526,null));
var inst_55528 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55527);
var _ = (function (){var statearr_55539 = state_55533;
(statearr_55539[(4)] = cljs.core.rest((state_55533[(4)])));

return statearr_55539;
})();
var state_55533__$1 = (function (){var statearr_55540 = state_55533;
(statearr_55540[(8)] = inst_55528);

return statearr_55540;
})();
var statearr_55541_55563 = state_55533__$1;
(statearr_55541_55563[(2)] = inst_55518);

(statearr_55541_55563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (2))){
var _ = (function (){var statearr_55542 = state_55533;
(statearr_55542[(4)] = cljs.core.cons((5),(state_55533[(4)])));

return statearr_55542;
})();
var inst_55502 = fluree.db.util.async.channel_QMARK_(n);
var state_55533__$1 = state_55533;
if(inst_55502){
var statearr_55543_55564 = state_55533__$1;
(statearr_55543_55564[(1)] = (6));

} else {
var statearr_55544_55565 = state_55533__$1;
(statearr_55544_55565[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (11))){
var state_55533__$1 = state_55533;
var statearr_55546_55566 = state_55533__$1;
(statearr_55546_55566[(2)] = d);

(statearr_55546_55566[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (9))){
var inst_55505 = (state_55533[(2)]);
var inst_55506 = fluree.db.util.async.throw_err(inst_55505);
var state_55533__$1 = state_55533;
var statearr_55547_55567 = state_55533__$1;
(statearr_55547_55567[(2)] = inst_55506);

(statearr_55547_55567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (5))){
var _ = (function (){var statearr_55548 = state_55533;
(statearr_55548[(4)] = cljs.core.rest((state_55533[(4)])));

return statearr_55548;
})();
var state_55533__$1 = state_55533;
var ex55545 = (state_55533__$1[(2)]);
var statearr_55549_55568 = state_55533__$1;
(statearr_55549_55568[(5)] = ex55545);


if((ex55545 instanceof Error)){
var statearr_55550_55569 = state_55533__$1;
(statearr_55550_55569[(1)] = (4));

(statearr_55550_55569[(5)] = null);

} else {
throw ex55545;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55534 === (10))){
var state_55533__$1 = state_55533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55533__$1,(13),d);
} else {
if((state_val_55534 === (8))){
var inst_55509 = (state_55533[(2)]);
var inst_55510 = fluree.db.util.async.channel_QMARK_(d);
var state_55533__$1 = (function (){var statearr_55551 = state_55533;
(statearr_55551[(7)] = inst_55509);

return statearr_55551;
})();
if(inst_55510){
var statearr_55552_55570 = state_55533__$1;
(statearr_55552_55570[(1)] = (10));

} else {
var statearr_55553_55571 = state_55533__$1;
(statearr_55553_55571[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____0 = (function (){
var statearr_55554 = [null,null,null,null,null,null,null,null,null];
(statearr_55554[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__);

(statearr_55554[(1)] = (1));

return statearr_55554;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____1 = (function (state_55533){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55533);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55555){var ex__2736__auto__ = e55555;
var statearr_55556_55572 = state_55533;
(statearr_55556_55572[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55533[(4)]))){
var statearr_55557_55573 = state_55533;
(statearr_55557_55573[(1)] = cljs.core.first((state_55533[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55574 = state_55533;
state_55533 = G__55574;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__ = function(state_55533){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____1.call(this,state_55533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55558 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55558[(6)] = c__2755__auto__);

return statearr_55558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55612){
var state_val_55613 = (state_55612[(1)]);
if((state_val_55613 === (7))){
var state_55612__$1 = state_55612;
var statearr_55614_55638 = state_55612__$1;
(statearr_55614_55638[(2)] = n);

(statearr_55614_55638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (1))){
var state_55612__$1 = state_55612;
var statearr_55615_55639 = state_55612__$1;
(statearr_55615_55639[(2)] = null);

(statearr_55615_55639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (4))){
var inst_55575 = (state_55612[(2)]);
var state_55612__$1 = state_55612;
var statearr_55616_55640 = state_55612__$1;
(statearr_55616_55640[(2)] = inst_55575);

(statearr_55616_55640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (13))){
var inst_55592 = (state_55612[(2)]);
var inst_55593 = fluree.db.util.async.throw_err(inst_55592);
var state_55612__$1 = state_55612;
var statearr_55617_55641 = state_55612__$1;
(statearr_55617_55641[(2)] = inst_55593);

(statearr_55617_55641[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (6))){
var state_55612__$1 = state_55612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55612__$1,(9),n);
} else {
if((state_val_55613 === (3))){
var inst_55610 = (state_55612[(2)]);
var state_55612__$1 = state_55612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55612__$1,inst_55610);
} else {
if((state_val_55613 === (12))){
var inst_55588 = (state_55612[(7)]);
var inst_55596 = (state_55612[(2)]);
var inst_55597 = fluree.db.dbfunctions.internal.mod(inst_55588,inst_55596);
var inst_55598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55599 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55601 = [inst_55588,inst_55596];
var inst_55602 = (new cljs.core.PersistentVector(null,2,(5),inst_55600,inst_55601,null));
var inst_55603 = ["mod",inst_55602,inst_55597];
var inst_55604 = cljs.core.PersistentHashMap.fromArrays(inst_55599,inst_55603);
var inst_55605 = [inst_55604,(2)];
var inst_55606 = (new cljs.core.PersistentVector(null,2,(5),inst_55598,inst_55605,null));
var inst_55607 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55606);
var _ = (function (){var statearr_55618 = state_55612;
(statearr_55618[(4)] = cljs.core.rest((state_55612[(4)])));

return statearr_55618;
})();
var state_55612__$1 = (function (){var statearr_55619 = state_55612;
(statearr_55619[(8)] = inst_55607);

return statearr_55619;
})();
var statearr_55620_55642 = state_55612__$1;
(statearr_55620_55642[(2)] = inst_55597);

(statearr_55620_55642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (2))){
var _ = (function (){var statearr_55621 = state_55612;
(statearr_55621[(4)] = cljs.core.cons((5),(state_55612[(4)])));

return statearr_55621;
})();
var inst_55581 = fluree.db.util.async.channel_QMARK_(n);
var state_55612__$1 = state_55612;
if(inst_55581){
var statearr_55622_55643 = state_55612__$1;
(statearr_55622_55643[(1)] = (6));

} else {
var statearr_55623_55644 = state_55612__$1;
(statearr_55623_55644[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (11))){
var state_55612__$1 = state_55612;
var statearr_55625_55645 = state_55612__$1;
(statearr_55625_55645[(2)] = d);

(statearr_55625_55645[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (9))){
var inst_55584 = (state_55612[(2)]);
var inst_55585 = fluree.db.util.async.throw_err(inst_55584);
var state_55612__$1 = state_55612;
var statearr_55626_55646 = state_55612__$1;
(statearr_55626_55646[(2)] = inst_55585);

(statearr_55626_55646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (5))){
var _ = (function (){var statearr_55627 = state_55612;
(statearr_55627[(4)] = cljs.core.rest((state_55612[(4)])));

return statearr_55627;
})();
var state_55612__$1 = state_55612;
var ex55624 = (state_55612__$1[(2)]);
var statearr_55628_55647 = state_55612__$1;
(statearr_55628_55647[(5)] = ex55624);


if((ex55624 instanceof Error)){
var statearr_55629_55648 = state_55612__$1;
(statearr_55629_55648[(1)] = (4));

(statearr_55629_55648[(5)] = null);

} else {
throw ex55624;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (10))){
var state_55612__$1 = state_55612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55612__$1,(13),d);
} else {
if((state_val_55613 === (8))){
var inst_55588 = (state_55612[(2)]);
var inst_55589 = fluree.db.util.async.channel_QMARK_(d);
var state_55612__$1 = (function (){var statearr_55630 = state_55612;
(statearr_55630[(7)] = inst_55588);

return statearr_55630;
})();
if(inst_55589){
var statearr_55631_55649 = state_55612__$1;
(statearr_55631_55649[(1)] = (10));

} else {
var statearr_55632_55650 = state_55612__$1;
(statearr_55632_55650[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____0 = (function (){
var statearr_55633 = [null,null,null,null,null,null,null,null,null];
(statearr_55633[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__);

(statearr_55633[(1)] = (1));

return statearr_55633;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____1 = (function (state_55612){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55612);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55634){var ex__2736__auto__ = e55634;
var statearr_55635_55651 = state_55612;
(statearr_55635_55651[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55612[(4)]))){
var statearr_55636_55652 = state_55612;
(statearr_55636_55652[(1)] = cljs.core.first((state_55612[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55653 = state_55612;
state_55612 = G__55653;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__ = function(state_55612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____1.call(this,state_55612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55637 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55637[(6)] = c__2755__auto__);

return statearr_55637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55691){
var state_val_55692 = (state_55691[(1)]);
if((state_val_55692 === (7))){
var state_55691__$1 = state_55691;
var statearr_55693_55717 = state_55691__$1;
(statearr_55693_55717[(2)] = n);

(statearr_55693_55717[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (1))){
var state_55691__$1 = state_55691;
var statearr_55694_55718 = state_55691__$1;
(statearr_55694_55718[(2)] = null);

(statearr_55694_55718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (4))){
var inst_55654 = (state_55691[(2)]);
var state_55691__$1 = state_55691;
var statearr_55695_55719 = state_55691__$1;
(statearr_55695_55719[(2)] = inst_55654);

(statearr_55695_55719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (13))){
var inst_55671 = (state_55691[(2)]);
var inst_55672 = fluree.db.util.async.throw_err(inst_55671);
var state_55691__$1 = state_55691;
var statearr_55696_55720 = state_55691__$1;
(statearr_55696_55720[(2)] = inst_55672);

(statearr_55696_55720[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (6))){
var state_55691__$1 = state_55691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55691__$1,(9),n);
} else {
if((state_val_55692 === (3))){
var inst_55689 = (state_55691[(2)]);
var state_55691__$1 = state_55691;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55691__$1,inst_55689);
} else {
if((state_val_55692 === (12))){
var inst_55667 = (state_55691[(7)]);
var inst_55675 = (state_55691[(2)]);
var inst_55676 = fluree.db.dbfunctions.internal.rem(inst_55667,inst_55675);
var inst_55677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55678 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55680 = [inst_55667,inst_55675];
var inst_55681 = (new cljs.core.PersistentVector(null,2,(5),inst_55679,inst_55680,null));
var inst_55682 = ["rem",inst_55681,inst_55676];
var inst_55683 = cljs.core.PersistentHashMap.fromArrays(inst_55678,inst_55682);
var inst_55684 = [inst_55683,(2)];
var inst_55685 = (new cljs.core.PersistentVector(null,2,(5),inst_55677,inst_55684,null));
var inst_55686 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55685);
var _ = (function (){var statearr_55697 = state_55691;
(statearr_55697[(4)] = cljs.core.rest((state_55691[(4)])));

return statearr_55697;
})();
var state_55691__$1 = (function (){var statearr_55698 = state_55691;
(statearr_55698[(8)] = inst_55686);

return statearr_55698;
})();
var statearr_55699_55721 = state_55691__$1;
(statearr_55699_55721[(2)] = inst_55676);

(statearr_55699_55721[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (2))){
var _ = (function (){var statearr_55700 = state_55691;
(statearr_55700[(4)] = cljs.core.cons((5),(state_55691[(4)])));

return statearr_55700;
})();
var inst_55660 = fluree.db.util.async.channel_QMARK_(n);
var state_55691__$1 = state_55691;
if(inst_55660){
var statearr_55701_55722 = state_55691__$1;
(statearr_55701_55722[(1)] = (6));

} else {
var statearr_55702_55723 = state_55691__$1;
(statearr_55702_55723[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (11))){
var state_55691__$1 = state_55691;
var statearr_55704_55724 = state_55691__$1;
(statearr_55704_55724[(2)] = d);

(statearr_55704_55724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (9))){
var inst_55663 = (state_55691[(2)]);
var inst_55664 = fluree.db.util.async.throw_err(inst_55663);
var state_55691__$1 = state_55691;
var statearr_55705_55725 = state_55691__$1;
(statearr_55705_55725[(2)] = inst_55664);

(statearr_55705_55725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (5))){
var _ = (function (){var statearr_55706 = state_55691;
(statearr_55706[(4)] = cljs.core.rest((state_55691[(4)])));

return statearr_55706;
})();
var state_55691__$1 = state_55691;
var ex55703 = (state_55691__$1[(2)]);
var statearr_55707_55726 = state_55691__$1;
(statearr_55707_55726[(5)] = ex55703);


if((ex55703 instanceof Error)){
var statearr_55708_55727 = state_55691__$1;
(statearr_55708_55727[(1)] = (4));

(statearr_55708_55727[(5)] = null);

} else {
throw ex55703;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (10))){
var state_55691__$1 = state_55691;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55691__$1,(13),d);
} else {
if((state_val_55692 === (8))){
var inst_55667 = (state_55691[(2)]);
var inst_55668 = fluree.db.util.async.channel_QMARK_(d);
var state_55691__$1 = (function (){var statearr_55709 = state_55691;
(statearr_55709[(7)] = inst_55667);

return statearr_55709;
})();
if(inst_55668){
var statearr_55710_55728 = state_55691__$1;
(statearr_55710_55728[(1)] = (10));

} else {
var statearr_55711_55729 = state_55691__$1;
(statearr_55711_55729[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____0 = (function (){
var statearr_55712 = [null,null,null,null,null,null,null,null,null];
(statearr_55712[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__);

(statearr_55712[(1)] = (1));

return statearr_55712;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____1 = (function (state_55691){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55691);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55713){var ex__2736__auto__ = e55713;
var statearr_55714_55730 = state_55691;
(statearr_55714_55730[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55691[(4)]))){
var statearr_55715_55731 = state_55691;
(statearr_55715_55731[(1)] = cljs.core.first((state_55691[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55732 = state_55691;
state_55691 = G__55732;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__ = function(state_55691){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____1.call(this,state_55691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55716 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55716[(6)] = c__2755__auto__);

return statearr_55716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55759){
var state_val_55760 = (state_55759[(1)]);
if((state_val_55760 === (7))){
var state_55759__$1 = state_55759;
var statearr_55761_55780 = state_55759__$1;
(statearr_55761_55780[(2)] = x);

(statearr_55761_55780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55760 === (1))){
var state_55759__$1 = state_55759;
var statearr_55762_55781 = state_55759__$1;
(statearr_55762_55781[(2)] = null);

(statearr_55762_55781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55760 === (4))){
var inst_55733 = (state_55759[(2)]);
var state_55759__$1 = state_55759;
var statearr_55763_55782 = state_55759__$1;
(statearr_55763_55782[(2)] = inst_55733);

(statearr_55763_55782[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55760 === (6))){
var state_55759__$1 = state_55759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55759__$1,(9),x);
} else {
if((state_val_55760 === (3))){
var inst_55757 = (state_55759[(2)]);
var state_55759__$1 = state_55759;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55759__$1,inst_55757);
} else {
if((state_val_55760 === (2))){
var _ = (function (){var statearr_55765 = state_55759;
(statearr_55765[(4)] = cljs.core.cons((5),(state_55759[(4)])));

return statearr_55765;
})();
var inst_55739 = fluree.db.util.async.channel_QMARK_(x);
var state_55759__$1 = state_55759;
if(inst_55739){
var statearr_55766_55783 = state_55759__$1;
(statearr_55766_55783[(1)] = (6));

} else {
var statearr_55767_55784 = state_55759__$1;
(statearr_55767_55784[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55760 === (9))){
var inst_55742 = (state_55759[(2)]);
var inst_55743 = fluree.db.util.async.throw_err(inst_55742);
var state_55759__$1 = state_55759;
var statearr_55768_55785 = state_55759__$1;
(statearr_55768_55785[(2)] = inst_55743);

(statearr_55768_55785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55760 === (5))){
var _ = (function (){var statearr_55769 = state_55759;
(statearr_55769[(4)] = cljs.core.rest((state_55759[(4)])));

return statearr_55769;
})();
var state_55759__$1 = state_55759;
var ex55764 = (state_55759__$1[(2)]);
var statearr_55770_55786 = state_55759__$1;
(statearr_55770_55786[(5)] = ex55764);


if((ex55764 instanceof Error)){
var statearr_55771_55787 = state_55759__$1;
(statearr_55771_55787[(1)] = (4));

(statearr_55771_55787[(5)] = null);

} else {
throw ex55764;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55760 === (8))){
var inst_55746 = (state_55759[(2)]);
var inst_55747 = fluree.db.dbfunctions.internal.boolean$(inst_55746);
var inst_55748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55749 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55750 = ["boolean",inst_55746,inst_55747];
var inst_55751 = cljs.core.PersistentHashMap.fromArrays(inst_55749,inst_55750);
var inst_55752 = [inst_55751,(10)];
var inst_55753 = (new cljs.core.PersistentVector(null,2,(5),inst_55748,inst_55752,null));
var inst_55754 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55753);
var _ = (function (){var statearr_55772 = state_55759;
(statearr_55772[(4)] = cljs.core.rest((state_55759[(4)])));

return statearr_55772;
})();
var state_55759__$1 = (function (){var statearr_55773 = state_55759;
(statearr_55773[(7)] = inst_55754);

return statearr_55773;
})();
var statearr_55774_55788 = state_55759__$1;
(statearr_55774_55788[(2)] = inst_55747);

(statearr_55774_55788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____0 = (function (){
var statearr_55775 = [null,null,null,null,null,null,null,null];
(statearr_55775[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__);

(statearr_55775[(1)] = (1));

return statearr_55775;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____1 = (function (state_55759){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55759);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55776){var ex__2736__auto__ = e55776;
var statearr_55777_55789 = state_55759;
(statearr_55777_55789[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55759[(4)]))){
var statearr_55778_55790 = state_55759;
(statearr_55778_55790[(1)] = cljs.core.first((state_55759[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55791 = state_55759;
state_55759 = G__55791;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__ = function(state_55759){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____1.call(this,state_55759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55779 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55779[(6)] = c__2755__auto__);

return statearr_55779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55829){
var state_val_55830 = (state_55829[(1)]);
if((state_val_55830 === (7))){
var state_55829__$1 = state_55829;
var statearr_55831_55855 = state_55829__$1;
(statearr_55831_55855[(2)] = pattern);

(statearr_55831_55855[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (1))){
var state_55829__$1 = state_55829;
var statearr_55832_55856 = state_55829__$1;
(statearr_55832_55856[(2)] = null);

(statearr_55832_55856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (4))){
var inst_55792 = (state_55829[(2)]);
var state_55829__$1 = state_55829;
var statearr_55833_55857 = state_55829__$1;
(statearr_55833_55857[(2)] = inst_55792);

(statearr_55833_55857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (13))){
var inst_55809 = (state_55829[(2)]);
var inst_55810 = fluree.db.util.async.throw_err(inst_55809);
var state_55829__$1 = state_55829;
var statearr_55834_55858 = state_55829__$1;
(statearr_55834_55858[(2)] = inst_55810);

(statearr_55834_55858[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (6))){
var state_55829__$1 = state_55829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55829__$1,(9),pattern);
} else {
if((state_val_55830 === (3))){
var inst_55827 = (state_55829[(2)]);
var state_55829__$1 = state_55829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55829__$1,inst_55827);
} else {
if((state_val_55830 === (12))){
var inst_55805 = (state_55829[(7)]);
var inst_55813 = (state_55829[(2)]);
var inst_55814 = fluree.db.dbfunctions.internal.re_find(inst_55805,inst_55813);
var inst_55815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55816 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55818 = [inst_55805,inst_55813];
var inst_55819 = (new cljs.core.PersistentVector(null,2,(5),inst_55817,inst_55818,null));
var inst_55820 = ["re-find",inst_55819,inst_55814];
var inst_55821 = cljs.core.PersistentHashMap.fromArrays(inst_55816,inst_55820);
var inst_55822 = [inst_55821,(10)];
var inst_55823 = (new cljs.core.PersistentVector(null,2,(5),inst_55815,inst_55822,null));
var inst_55824 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55823);
var _ = (function (){var statearr_55835 = state_55829;
(statearr_55835[(4)] = cljs.core.rest((state_55829[(4)])));

return statearr_55835;
})();
var state_55829__$1 = (function (){var statearr_55836 = state_55829;
(statearr_55836[(8)] = inst_55824);

return statearr_55836;
})();
var statearr_55837_55859 = state_55829__$1;
(statearr_55837_55859[(2)] = inst_55814);

(statearr_55837_55859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (2))){
var _ = (function (){var statearr_55838 = state_55829;
(statearr_55838[(4)] = cljs.core.cons((5),(state_55829[(4)])));

return statearr_55838;
})();
var inst_55798 = fluree.db.util.async.channel_QMARK_(pattern);
var state_55829__$1 = state_55829;
if(inst_55798){
var statearr_55839_55860 = state_55829__$1;
(statearr_55839_55860[(1)] = (6));

} else {
var statearr_55840_55861 = state_55829__$1;
(statearr_55840_55861[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (11))){
var state_55829__$1 = state_55829;
var statearr_55842_55862 = state_55829__$1;
(statearr_55842_55862[(2)] = string);

(statearr_55842_55862[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (9))){
var inst_55801 = (state_55829[(2)]);
var inst_55802 = fluree.db.util.async.throw_err(inst_55801);
var state_55829__$1 = state_55829;
var statearr_55843_55863 = state_55829__$1;
(statearr_55843_55863[(2)] = inst_55802);

(statearr_55843_55863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (5))){
var _ = (function (){var statearr_55844 = state_55829;
(statearr_55844[(4)] = cljs.core.rest((state_55829[(4)])));

return statearr_55844;
})();
var state_55829__$1 = state_55829;
var ex55841 = (state_55829__$1[(2)]);
var statearr_55845_55864 = state_55829__$1;
(statearr_55845_55864[(5)] = ex55841);


if((ex55841 instanceof Error)){
var statearr_55846_55865 = state_55829__$1;
(statearr_55846_55865[(1)] = (4));

(statearr_55846_55865[(5)] = null);

} else {
throw ex55841;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55830 === (10))){
var state_55829__$1 = state_55829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55829__$1,(13),string);
} else {
if((state_val_55830 === (8))){
var inst_55805 = (state_55829[(2)]);
var inst_55806 = fluree.db.util.async.channel_QMARK_(string);
var state_55829__$1 = (function (){var statearr_55847 = state_55829;
(statearr_55847[(7)] = inst_55805);

return statearr_55847;
})();
if(inst_55806){
var statearr_55848_55866 = state_55829__$1;
(statearr_55848_55866[(1)] = (10));

} else {
var statearr_55849_55867 = state_55829__$1;
(statearr_55849_55867[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____0 = (function (){
var statearr_55850 = [null,null,null,null,null,null,null,null,null];
(statearr_55850[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__);

(statearr_55850[(1)] = (1));

return statearr_55850;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____1 = (function (state_55829){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55829);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55851){var ex__2736__auto__ = e55851;
var statearr_55852_55868 = state_55829;
(statearr_55852_55868[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55829[(4)]))){
var statearr_55853_55869 = state_55829;
(statearr_55853_55869[(1)] = cljs.core.first((state_55829[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55870 = state_55829;
state_55829 = G__55870;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__ = function(state_55829){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____1.call(this,state_55829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55854 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55854[(6)] = c__2755__auto__);

return statearr_55854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55897){
var state_val_55898 = (state_55897[(1)]);
if((state_val_55898 === (7))){
var state_55897__$1 = state_55897;
var statearr_55899_55918 = state_55897__$1;
(statearr_55899_55918[(2)] = email);

(statearr_55899_55918[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (1))){
var state_55897__$1 = state_55897;
var statearr_55900_55919 = state_55897__$1;
(statearr_55900_55919[(2)] = null);

(statearr_55900_55919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (4))){
var inst_55871 = (state_55897[(2)]);
var state_55897__$1 = state_55897;
var statearr_55901_55920 = state_55897__$1;
(statearr_55901_55920[(2)] = inst_55871);

(statearr_55901_55920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (6))){
var state_55897__$1 = state_55897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55897__$1,(9),email);
} else {
if((state_val_55898 === (3))){
var inst_55895 = (state_55897[(2)]);
var state_55897__$1 = state_55897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55897__$1,inst_55895);
} else {
if((state_val_55898 === (2))){
var _ = (function (){var statearr_55903 = state_55897;
(statearr_55903[(4)] = cljs.core.cons((5),(state_55897[(4)])));

return statearr_55903;
})();
var inst_55877 = fluree.db.util.async.channel_QMARK_(email);
var state_55897__$1 = state_55897;
if(inst_55877){
var statearr_55904_55921 = state_55897__$1;
(statearr_55904_55921[(1)] = (6));

} else {
var statearr_55905_55922 = state_55897__$1;
(statearr_55905_55922[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (9))){
var inst_55880 = (state_55897[(2)]);
var inst_55881 = fluree.db.util.async.throw_err(inst_55880);
var state_55897__$1 = state_55897;
var statearr_55906_55923 = state_55897__$1;
(statearr_55906_55923[(2)] = inst_55881);

(statearr_55906_55923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (5))){
var _ = (function (){var statearr_55907 = state_55897;
(statearr_55907[(4)] = cljs.core.rest((state_55897[(4)])));

return statearr_55907;
})();
var state_55897__$1 = state_55897;
var ex55902 = (state_55897__$1[(2)]);
var statearr_55908_55924 = state_55897__$1;
(statearr_55908_55924[(5)] = ex55902);


if((ex55902 instanceof Error)){
var statearr_55909_55925 = state_55897__$1;
(statearr_55909_55925[(1)] = (4));

(statearr_55909_55925[(5)] = null);

} else {
throw ex55902;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55898 === (8))){
var inst_55884 = (state_55897[(2)]);
var inst_55885 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_55884);
var inst_55886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55887 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55888 = ["re-find",inst_55884,inst_55885];
var inst_55889 = cljs.core.PersistentHashMap.fromArrays(inst_55887,inst_55888);
var inst_55890 = [inst_55889,(10)];
var inst_55891 = (new cljs.core.PersistentVector(null,2,(5),inst_55886,inst_55890,null));
var inst_55892 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55891);
var _ = (function (){var statearr_55910 = state_55897;
(statearr_55910[(4)] = cljs.core.rest((state_55897[(4)])));

return statearr_55910;
})();
var state_55897__$1 = (function (){var statearr_55911 = state_55897;
(statearr_55911[(7)] = inst_55892);

return statearr_55911;
})();
var statearr_55912_55926 = state_55897__$1;
(statearr_55912_55926[(2)] = inst_55885);

(statearr_55912_55926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_55913 = [null,null,null,null,null,null,null,null];
(statearr_55913[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__);

(statearr_55913[(1)] = (1));

return statearr_55913;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____1 = (function (state_55897){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55897);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e55914){var ex__2736__auto__ = e55914;
var statearr_55915_55927 = state_55897;
(statearr_55915_55927[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55897[(4)]))){
var statearr_55916_55928 = state_55897;
(statearr_55916_55928[(1)] = cljs.core.first((state_55897[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55929 = state_55897;
state_55897 = G__55929;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__ = function(state_55897){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____1.call(this,state_55897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_55917 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_55917[(6)] = c__2755__auto__);

return statearr_55917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_55976){
var state_val_55977 = (state_55976[(1)]);
if((state_val_55977 === (7))){
var inst_55946 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55976__$1 = state_55976;
if(cljs.core.truth_(inst_55946)){
var statearr_55978_56005 = state_55976__$1;
(statearr_55978_56005[(1)] = (9));

} else {
var statearr_55979_56006 = state_55976__$1;
(statearr_55979_56006[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (1))){
var state_55976__$1 = state_55976;
var statearr_55980_56007 = state_55976__$1;
(statearr_55980_56007[(2)] = null);

(statearr_55980_56007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (4))){
var inst_55930 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
var statearr_55981_56008 = state_55976__$1;
(statearr_55981_56008[(2)] = inst_55930);

(statearr_55981_56008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (15))){
var inst_55957 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
var statearr_55982_56009 = state_55976__$1;
(statearr_55982_56009[(2)] = inst_55957);

(statearr_55982_56009[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (13))){
var inst_55954 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_55976__$1 = state_55976;
var statearr_55983_56010 = state_55976__$1;
(statearr_55983_56010[(2)] = inst_55954);

(statearr_55983_56010[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (6))){
var inst_55941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55942 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55943 = [inst_55942,(0)];
var inst_55944 = (new cljs.core.PersistentVector(null,2,(5),inst_55941,inst_55943,null));
var state_55976__$1 = state_55976;
var statearr_55984_56011 = state_55976__$1;
(statearr_55984_56011[(2)] = inst_55944);

(statearr_55984_56011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (3))){
var inst_55974 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55976__$1,inst_55974);
} else {
if((state_val_55977 === (12))){
var inst_55950 = (state_55976[(2)]);
var inst_55951 = fluree.db.util.async.throw_err(inst_55950);
var state_55976__$1 = state_55976;
var statearr_55985_56012 = state_55976__$1;
(statearr_55985_56012[(2)] = inst_55951);

(statearr_55985_56012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (2))){
var _ = (function (){var statearr_55986 = state_55976;
(statearr_55986[(4)] = cljs.core.cons((5),(state_55976[(4)])));

return statearr_55986;
})();
var inst_55939 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55976__$1 = state_55976;
if(cljs.core.truth_(inst_55939)){
var statearr_55987_56013 = state_55976__$1;
(statearr_55987_56013[(1)] = (6));

} else {
var statearr_55988_56014 = state_55976__$1;
(statearr_55988_56014[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (11))){
var inst_55959 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
var statearr_55990_56015 = state_55976__$1;
(statearr_55990_56015[(2)] = inst_55959);

(statearr_55990_56015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (9))){
var inst_55948 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55976__$1,(12),inst_55948);
} else {
if((state_val_55977 === (5))){
var _ = (function (){var statearr_55991 = state_55976;
(statearr_55991[(4)] = cljs.core.rest((state_55976[(4)])));

return statearr_55991;
})();
var state_55976__$1 = state_55976;
var ex55989 = (state_55976__$1[(2)]);
var statearr_55992_56016 = state_55976__$1;
(statearr_55992_56016[(5)] = ex55989);


if((ex55989 instanceof Error)){
var statearr_55993_56017 = state_55976__$1;
(statearr_55993_56017[(1)] = (4));

(statearr_55993_56017[(5)] = null);

} else {
throw ex55989;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (14))){
var state_55976__$1 = state_55976;
var statearr_55994_56018 = state_55976__$1;
(statearr_55994_56018[(2)] = null);

(statearr_55994_56018[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (10))){
var state_55976__$1 = state_55976;
var statearr_55995_56019 = state_55976__$1;
(statearr_55995_56019[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (8))){
var inst_55961 = (state_55976[(2)]);
var inst_55962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55961,(0),null);
var inst_55963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55961,(1),null);
var inst_55964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55965 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55966 = ["?user_id","?ctx",inst_55962];
var inst_55967 = cljs.core.PersistentHashMap.fromArrays(inst_55965,inst_55966);
var inst_55968 = ((10) + inst_55963);
var inst_55969 = [inst_55967,inst_55968];
var inst_55970 = (new cljs.core.PersistentVector(null,2,(5),inst_55964,inst_55969,null));
var inst_55971 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55970);
var _ = (function (){var statearr_55997 = state_55976;
(statearr_55997[(4)] = cljs.core.rest((state_55976[(4)])));

return statearr_55997;
})();
var state_55976__$1 = (function (){var statearr_55998 = state_55976;
(statearr_55998[(7)] = inst_55971);

return statearr_55998;
})();
var statearr_55999_56020 = state_55976__$1;
(statearr_55999_56020[(2)] = inst_55962);

(statearr_55999_56020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____0 = (function (){
var statearr_56000 = [null,null,null,null,null,null,null,null];
(statearr_56000[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__);

(statearr_56000[(1)] = (1));

return statearr_56000;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____1 = (function (state_55976){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_55976);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56001){var ex__2736__auto__ = e56001;
var statearr_56002_56021 = state_55976;
(statearr_56002_56021[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_55976[(4)]))){
var statearr_56003_56022 = state_55976;
(statearr_56003_56022[(1)] = cljs.core.first((state_55976[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56023 = state_55976;
state_55976 = G__56023;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__ = function(state_55976){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____1.call(this,state_55976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56004 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56004[(6)] = c__2755__auto__);

return statearr_56004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56051){
var state_val_56052 = (state_56051[(1)]);
if((state_val_56052 === (7))){
var inst_56044 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56051__$1 = state_56051;
var statearr_56053_56072 = state_56051__$1;
(statearr_56053_56072[(2)] = inst_56044);

(statearr_56053_56072[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (1))){
var state_56051__$1 = state_56051;
var statearr_56054_56073 = state_56051__$1;
(statearr_56054_56073[(2)] = null);

(statearr_56054_56073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (4))){
var inst_56024 = (state_56051[(2)]);
var state_56051__$1 = state_56051;
var statearr_56055_56074 = state_56051__$1;
(statearr_56055_56074[(2)] = inst_56024);

(statearr_56055_56074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (6))){
var inst_56032 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56051__$1,(9),inst_56032);
} else {
if((state_val_56052 === (3))){
var inst_56049 = (state_56051[(2)]);
var state_56051__$1 = state_56051;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56051__$1,inst_56049);
} else {
if((state_val_56052 === (2))){
var _ = (function (){var statearr_56057 = state_56051;
(statearr_56057[(4)] = cljs.core.cons((5),(state_56051[(4)])));

return statearr_56057;
})();
var inst_56030 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56051__$1 = state_56051;
if(cljs.core.truth_(inst_56030)){
var statearr_56058_56075 = state_56051__$1;
(statearr_56058_56075[(1)] = (6));

} else {
var statearr_56059_56076 = state_56051__$1;
(statearr_56059_56076[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (9))){
var inst_56034 = (state_56051[(2)]);
var inst_56035 = fluree.db.util.async.throw_err(inst_56034);
var inst_56036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56037 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56038 = ["?auth_id","?ctx",inst_56035];
var inst_56039 = cljs.core.PersistentHashMap.fromArrays(inst_56037,inst_56038);
var inst_56040 = [inst_56039,(10)];
var inst_56041 = (new cljs.core.PersistentVector(null,2,(5),inst_56036,inst_56040,null));
var inst_56042 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56041);
var state_56051__$1 = (function (){var statearr_56060 = state_56051;
(statearr_56060[(7)] = inst_56042);

return statearr_56060;
})();
var statearr_56061_56077 = state_56051__$1;
(statearr_56061_56077[(2)] = inst_56035);

(statearr_56061_56077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (5))){
var _ = (function (){var statearr_56062 = state_56051;
(statearr_56062[(4)] = cljs.core.rest((state_56051[(4)])));

return statearr_56062;
})();
var state_56051__$1 = state_56051;
var ex56056 = (state_56051__$1[(2)]);
var statearr_56063_56078 = state_56051__$1;
(statearr_56063_56078[(5)] = ex56056);


if((ex56056 instanceof Error)){
var statearr_56064_56079 = state_56051__$1;
(statearr_56064_56079[(1)] = (4));

(statearr_56064_56079[(5)] = null);

} else {
throw ex56056;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56052 === (8))){
var inst_56046 = (state_56051[(2)]);
var _ = (function (){var statearr_56065 = state_56051;
(statearr_56065[(4)] = cljs.core.rest((state_56051[(4)])));

return statearr_56065;
})();
var state_56051__$1 = state_56051;
var statearr_56066_56080 = state_56051__$1;
(statearr_56066_56080[(2)] = inst_56046);

(statearr_56066_56080[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____0 = (function (){
var statearr_56067 = [null,null,null,null,null,null,null,null];
(statearr_56067[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__);

(statearr_56067[(1)] = (1));

return statearr_56067;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____1 = (function (state_56051){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56051);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56068){var ex__2736__auto__ = e56068;
var statearr_56069_56081 = state_56051;
(statearr_56069_56081[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56051[(4)]))){
var statearr_56070_56082 = state_56051;
(statearr_56070_56082[(1)] = cljs.core.first((state_56051[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56083 = state_56051;
state_56051 = G__56083;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__ = function(state_56051){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____1.call(this,state_56051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56071 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56071[(6)] = c__2755__auto__);

return statearr_56071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56085 = arguments.length;
switch (G__56085) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56127){
var state_val_56128 = (state_56127[(1)]);
if((state_val_56128 === (7))){
var state_56127__$1 = state_56127;
var statearr_56129_56159 = state_56127__$1;
(statearr_56129_56159[(2)] = seed);

(statearr_56129_56159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (1))){
var state_56127__$1 = state_56127;
var statearr_56130_56160 = state_56127__$1;
(statearr_56130_56160[(2)] = null);

(statearr_56130_56160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (4))){
var inst_56086 = (state_56127[(2)]);
var state_56127__$1 = state_56127;
var statearr_56131_56161 = state_56127__$1;
(statearr_56131_56161[(2)] = inst_56086);

(statearr_56131_56161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (15))){
var state_56127__$1 = state_56127;
var statearr_56132_56162 = state_56127__$1;
(statearr_56132_56162[(2)] = (10));

(statearr_56132_56162[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (13))){
var inst_56103 = (state_56127[(2)]);
var inst_56104 = fluree.db.util.async.throw_err(inst_56103);
var state_56127__$1 = state_56127;
var statearr_56133_56163 = state_56127__$1;
(statearr_56133_56163[(2)] = inst_56104);

(statearr_56133_56163[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (6))){
var state_56127__$1 = state_56127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56127__$1,(9),seed);
} else {
if((state_val_56128 === (3))){
var inst_56125 = (state_56127[(2)]);
var state_56127__$1 = state_56127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56127__$1,inst_56125);
} else {
if((state_val_56128 === (12))){
var inst_56107 = (state_56127[(7)]);
var inst_56107__$1 = (state_56127[(2)]);
var state_56127__$1 = (function (){var statearr_56134 = state_56127;
(statearr_56134[(7)] = inst_56107__$1);

return statearr_56134;
})();
if(cljs.core.truth_(inst_56107__$1)){
var statearr_56135_56164 = state_56127__$1;
(statearr_56135_56164[(1)] = (14));

} else {
var statearr_56136_56165 = state_56127__$1;
(statearr_56136_56165[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (2))){
var _ = (function (){var statearr_56137 = state_56127;
(statearr_56137[(4)] = cljs.core.cons((5),(state_56127[(4)])));

return statearr_56137;
})();
var inst_56092 = fluree.db.util.async.channel_QMARK_(seed);
var state_56127__$1 = state_56127;
if(inst_56092){
var statearr_56138_56166 = state_56127__$1;
(statearr_56138_56166[(1)] = (6));

} else {
var statearr_56139_56167 = state_56127__$1;
(statearr_56139_56167[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (11))){
var state_56127__$1 = state_56127;
var statearr_56141_56168 = state_56127__$1;
(statearr_56141_56168[(2)] = max);

(statearr_56141_56168[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (9))){
var inst_56095 = (state_56127[(2)]);
var inst_56096 = fluree.db.util.async.throw_err(inst_56095);
var state_56127__$1 = state_56127;
var statearr_56142_56169 = state_56127__$1;
(statearr_56142_56169[(2)] = inst_56096);

(statearr_56142_56169[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (5))){
var _ = (function (){var statearr_56143 = state_56127;
(statearr_56143[(4)] = cljs.core.rest((state_56127[(4)])));

return statearr_56143;
})();
var state_56127__$1 = state_56127;
var ex56140 = (state_56127__$1[(2)]);
var statearr_56144_56170 = state_56127__$1;
(statearr_56144_56170[(5)] = ex56140);


if((ex56140 instanceof Error)){
var statearr_56145_56171 = state_56127__$1;
(statearr_56145_56171[(1)] = (4));

(statearr_56145_56171[(5)] = null);

} else {
throw ex56140;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (14))){
var inst_56107 = (state_56127[(7)]);
var state_56127__$1 = state_56127;
var statearr_56146_56172 = state_56127__$1;
(statearr_56146_56172[(2)] = inst_56107);

(statearr_56146_56172[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (16))){
var inst_56099 = (state_56127[(8)]);
var inst_56111 = (state_56127[(2)]);
var inst_56112 = fluree.db.dbfunctions.internal.rand(inst_56099,inst_56111);
var inst_56113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56114 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56116 = [max,seed];
var inst_56117 = (new cljs.core.PersistentVector(null,2,(5),inst_56115,inst_56116,null));
var inst_56118 = ["rand",inst_56117,inst_56112];
var inst_56119 = cljs.core.PersistentHashMap.fromArrays(inst_56114,inst_56118);
var inst_56120 = [inst_56119,(10)];
var inst_56121 = (new cljs.core.PersistentVector(null,2,(5),inst_56113,inst_56120,null));
var inst_56122 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56121);
var _ = (function (){var statearr_56147 = state_56127;
(statearr_56147[(4)] = cljs.core.rest((state_56127[(4)])));

return statearr_56147;
})();
var state_56127__$1 = (function (){var statearr_56148 = state_56127;
(statearr_56148[(9)] = inst_56122);

return statearr_56148;
})();
var statearr_56149_56173 = state_56127__$1;
(statearr_56149_56173[(2)] = inst_56112);

(statearr_56149_56173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56128 === (10))){
var state_56127__$1 = state_56127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56127__$1,(13),max);
} else {
if((state_val_56128 === (8))){
var inst_56099 = (state_56127[(2)]);
var inst_56100 = fluree.db.util.async.channel_QMARK_(max);
var state_56127__$1 = (function (){var statearr_56150 = state_56127;
(statearr_56150[(8)] = inst_56099);

return statearr_56150;
})();
if(inst_56100){
var statearr_56151_56174 = state_56127__$1;
(statearr_56151_56174[(1)] = (10));

} else {
var statearr_56152_56175 = state_56127__$1;
(statearr_56152_56175[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2733__auto____0 = (function (){
var statearr_56153 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56153[(0)] = fluree$db$dbfunctions$fns$state_machine__2733__auto__);

(statearr_56153[(1)] = (1));

return statearr_56153;
});
var fluree$db$dbfunctions$fns$state_machine__2733__auto____1 = (function (state_56127){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56127);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56154){var ex__2736__auto__ = e56154;
var statearr_56155_56176 = state_56127;
(statearr_56155_56176[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56127[(4)]))){
var statearr_56156_56177 = state_56127;
(statearr_56156_56177[(1)] = cljs.core.first((state_56127[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56178 = state_56127;
state_56127 = G__56178;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2733__auto__ = function(state_56127){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2733__auto____1.call(this,state_56127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56157 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56157[(6)] = c__2755__auto__);

return statearr_56157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56199){
var state_val_56200 = (state_56199[(1)]);
if((state_val_56200 === (1))){
var state_56199__$1 = state_56199;
var statearr_56201_56216 = state_56199__$1;
(statearr_56201_56216[(2)] = null);

(statearr_56201_56216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (2))){
var _ = (function (){var statearr_56202 = state_56199;
(statearr_56202[(4)] = cljs.core.cons((5),(state_56199[(4)])));

return statearr_56202;
})();
var inst_56185 = fluree.db.util.core.random_uuid();
var inst_56186 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56185);
var inst_56187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56188 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56189 = cljs.core.PersistentVector.EMPTY;
var inst_56190 = ["uuid",inst_56189,inst_56186];
var inst_56191 = cljs.core.PersistentHashMap.fromArrays(inst_56188,inst_56190);
var inst_56192 = [inst_56191,(10)];
var inst_56193 = (new cljs.core.PersistentVector(null,2,(5),inst_56187,inst_56192,null));
var inst_56194 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56193);
var ___$1 = (function (){var statearr_56203 = state_56199;
(statearr_56203[(4)] = cljs.core.rest((state_56199[(4)])));

return statearr_56203;
})();
var state_56199__$1 = (function (){var statearr_56204 = state_56199;
(statearr_56204[(7)] = inst_56194);

return statearr_56204;
})();
var statearr_56205_56217 = state_56199__$1;
(statearr_56205_56217[(2)] = inst_56186);

(statearr_56205_56217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (3))){
var inst_56197 = (state_56199[(2)]);
var state_56199__$1 = state_56199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56199__$1,inst_56197);
} else {
if((state_val_56200 === (4))){
var inst_56179 = (state_56199[(2)]);
var state_56199__$1 = state_56199;
var statearr_56207_56218 = state_56199__$1;
(statearr_56207_56218[(2)] = inst_56179);

(statearr_56207_56218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (5))){
var _ = (function (){var statearr_56208 = state_56199;
(statearr_56208[(4)] = cljs.core.rest((state_56199[(4)])));

return statearr_56208;
})();
var state_56199__$1 = state_56199;
var ex56206 = (state_56199__$1[(2)]);
var statearr_56209_56219 = state_56199__$1;
(statearr_56209_56219[(5)] = ex56206);


if((ex56206 instanceof Error)){
var statearr_56210_56220 = state_56199__$1;
(statearr_56210_56220[(1)] = (4));

(statearr_56210_56220[(5)] = null);

} else {
throw ex56206;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____0 = (function (){
var statearr_56211 = [null,null,null,null,null,null,null,null];
(statearr_56211[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__);

(statearr_56211[(1)] = (1));

return statearr_56211;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____1 = (function (state_56199){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56199);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56212){var ex__2736__auto__ = e56212;
var statearr_56213_56221 = state_56199;
(statearr_56213_56221[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56199[(4)]))){
var statearr_56214_56222 = state_56199;
(statearr_56214_56222[(1)] = cljs.core.first((state_56199[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56223 = state_56199;
state_56199 = G__56223;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__ = function(state_56199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____1.call(this,state_56199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56215 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56215[(6)] = c__2755__auto__);

return statearr_56215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56253){
var state_val_56254 = (state_56253[(1)]);
if((state_val_56254 === (7))){
var state_56253__$1 = state_56253;
var statearr_56255_56274 = state_56253__$1;
(statearr_56255_56274[(2)] = num);

(statearr_56255_56274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (1))){
var state_56253__$1 = state_56253;
var statearr_56256_56275 = state_56253__$1;
(statearr_56256_56275[(2)] = null);

(statearr_56256_56275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (4))){
var inst_56224 = (state_56253[(2)]);
var state_56253__$1 = state_56253;
var statearr_56257_56276 = state_56253__$1;
(statearr_56257_56276[(2)] = inst_56224);

(statearr_56257_56276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (6))){
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56253__$1,(9),num);
} else {
if((state_val_56254 === (3))){
var inst_56251 = (state_56253[(2)]);
var state_56253__$1 = state_56253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56253__$1,inst_56251);
} else {
if((state_val_56254 === (2))){
var _ = (function (){var statearr_56259 = state_56253;
(statearr_56259[(4)] = cljs.core.cons((5),(state_56253[(4)])));

return statearr_56259;
})();
var inst_56230 = fluree.db.util.async.channel_QMARK_(num);
var state_56253__$1 = state_56253;
if(inst_56230){
var statearr_56260_56277 = state_56253__$1;
(statearr_56260_56277[(1)] = (6));

} else {
var statearr_56261_56278 = state_56253__$1;
(statearr_56261_56278[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (9))){
var inst_56233 = (state_56253[(2)]);
var inst_56234 = fluree.db.util.async.throw_err(inst_56233);
var state_56253__$1 = state_56253;
var statearr_56262_56279 = state_56253__$1;
(statearr_56262_56279[(2)] = inst_56234);

(statearr_56262_56279[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (5))){
var _ = (function (){var statearr_56263 = state_56253;
(statearr_56263[(4)] = cljs.core.rest((state_56253[(4)])));

return statearr_56263;
})();
var state_56253__$1 = state_56253;
var ex56258 = (state_56253__$1[(2)]);
var statearr_56264_56280 = state_56253__$1;
(statearr_56264_56280[(5)] = ex56258);


if((ex56258 instanceof Error)){
var statearr_56265_56281 = state_56253__$1;
(statearr_56265_56281[(1)] = (4));

(statearr_56265_56281[(5)] = null);

} else {
throw ex56258;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56254 === (8))){
var inst_56237 = (state_56253[(2)]);
var inst_56238 = fluree.db.dbfunctions.internal.ceil(inst_56237);
var inst_56239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56240 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56242 = [fluree.db.dbfunctions.fns.ceil];
var inst_56243 = (new cljs.core.PersistentVector(null,1,(5),inst_56241,inst_56242,null));
var inst_56244 = ["",inst_56243,inst_56238];
var inst_56245 = cljs.core.PersistentHashMap.fromArrays(inst_56240,inst_56244);
var inst_56246 = [inst_56245,(10)];
var inst_56247 = (new cljs.core.PersistentVector(null,2,(5),inst_56239,inst_56246,null));
var inst_56248 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56247);
var _ = (function (){var statearr_56266 = state_56253;
(statearr_56266[(4)] = cljs.core.rest((state_56253[(4)])));

return statearr_56266;
})();
var state_56253__$1 = (function (){var statearr_56267 = state_56253;
(statearr_56267[(7)] = inst_56248);

return statearr_56267;
})();
var statearr_56268_56282 = state_56253__$1;
(statearr_56268_56282[(2)] = inst_56238);

(statearr_56268_56282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____0 = (function (){
var statearr_56269 = [null,null,null,null,null,null,null,null];
(statearr_56269[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__);

(statearr_56269[(1)] = (1));

return statearr_56269;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____1 = (function (state_56253){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56253);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56270){var ex__2736__auto__ = e56270;
var statearr_56271_56283 = state_56253;
(statearr_56271_56283[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56253[(4)]))){
var statearr_56272_56284 = state_56253;
(statearr_56272_56284[(1)] = cljs.core.first((state_56253[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56285 = state_56253;
state_56253 = G__56285;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__ = function(state_56253){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____1.call(this,state_56253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56273 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56273[(6)] = c__2755__auto__);

return statearr_56273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56315){
var state_val_56316 = (state_56315[(1)]);
if((state_val_56316 === (7))){
var state_56315__$1 = state_56315;
var statearr_56317_56336 = state_56315__$1;
(statearr_56317_56336[(2)] = num);

(statearr_56317_56336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56316 === (1))){
var state_56315__$1 = state_56315;
var statearr_56318_56337 = state_56315__$1;
(statearr_56318_56337[(2)] = null);

(statearr_56318_56337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56316 === (4))){
var inst_56286 = (state_56315[(2)]);
var state_56315__$1 = state_56315;
var statearr_56319_56338 = state_56315__$1;
(statearr_56319_56338[(2)] = inst_56286);

(statearr_56319_56338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56316 === (6))){
var state_56315__$1 = state_56315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56315__$1,(9),num);
} else {
if((state_val_56316 === (3))){
var inst_56313 = (state_56315[(2)]);
var state_56315__$1 = state_56315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56315__$1,inst_56313);
} else {
if((state_val_56316 === (2))){
var _ = (function (){var statearr_56321 = state_56315;
(statearr_56321[(4)] = cljs.core.cons((5),(state_56315[(4)])));

return statearr_56321;
})();
var inst_56292 = fluree.db.util.async.channel_QMARK_(num);
var state_56315__$1 = state_56315;
if(inst_56292){
var statearr_56322_56339 = state_56315__$1;
(statearr_56322_56339[(1)] = (6));

} else {
var statearr_56323_56340 = state_56315__$1;
(statearr_56323_56340[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56316 === (9))){
var inst_56295 = (state_56315[(2)]);
var inst_56296 = fluree.db.util.async.throw_err(inst_56295);
var state_56315__$1 = state_56315;
var statearr_56324_56341 = state_56315__$1;
(statearr_56324_56341[(2)] = inst_56296);

(statearr_56324_56341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56316 === (5))){
var _ = (function (){var statearr_56325 = state_56315;
(statearr_56325[(4)] = cljs.core.rest((state_56315[(4)])));

return statearr_56325;
})();
var state_56315__$1 = state_56315;
var ex56320 = (state_56315__$1[(2)]);
var statearr_56326_56342 = state_56315__$1;
(statearr_56326_56342[(5)] = ex56320);


if((ex56320 instanceof Error)){
var statearr_56327_56343 = state_56315__$1;
(statearr_56327_56343[(1)] = (4));

(statearr_56327_56343[(5)] = null);

} else {
throw ex56320;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56316 === (8))){
var inst_56299 = (state_56315[(2)]);
var inst_56300 = fluree.db.dbfunctions.internal.floor(inst_56299);
var inst_56301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56302 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56304 = [fluree.db.dbfunctions.fns.floor];
var inst_56305 = (new cljs.core.PersistentVector(null,1,(5),inst_56303,inst_56304,null));
var inst_56306 = ["",inst_56305,inst_56300];
var inst_56307 = cljs.core.PersistentHashMap.fromArrays(inst_56302,inst_56306);
var inst_56308 = [inst_56307,(10)];
var inst_56309 = (new cljs.core.PersistentVector(null,2,(5),inst_56301,inst_56308,null));
var inst_56310 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56309);
var _ = (function (){var statearr_56328 = state_56315;
(statearr_56328[(4)] = cljs.core.rest((state_56315[(4)])));

return statearr_56328;
})();
var state_56315__$1 = (function (){var statearr_56329 = state_56315;
(statearr_56329[(7)] = inst_56310);

return statearr_56329;
})();
var statearr_56330_56344 = state_56315__$1;
(statearr_56330_56344[(2)] = inst_56300);

(statearr_56330_56344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____0 = (function (){
var statearr_56331 = [null,null,null,null,null,null,null,null];
(statearr_56331[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__);

(statearr_56331[(1)] = (1));

return statearr_56331;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____1 = (function (state_56315){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56315);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56332){var ex__2736__auto__ = e56332;
var statearr_56333_56345 = state_56315;
(statearr_56333_56345[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56315[(4)]))){
var statearr_56334_56346 = state_56315;
(statearr_56334_56346[(1)] = cljs.core.first((state_56315[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56347 = state_56315;
state_56315 = G__56347;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__ = function(state_56315){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____1.call(this,state_56315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56335 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56335[(6)] = c__2755__auto__);

return statearr_56335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_56372){
var state_val_56373 = (state_56372[(1)]);
if((state_val_56373 === (1))){
var state_56372__$1 = state_56372;
var statearr_56374_56389 = state_56372__$1;
(statearr_56374_56389[(2)] = null);

(statearr_56374_56389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56373 === (2))){
var _ = (function (){var statearr_56375 = state_56372;
(statearr_56375[(4)] = cljs.core.cons((5),(state_56372[(4)])));

return statearr_56375;
})();
var inst_56354 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_56372__$1 = state_56372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56372__$1,(6),inst_56354);
} else {
if((state_val_56373 === (3))){
var inst_56370 = (state_56372[(2)]);
var state_56372__$1 = state_56372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56372__$1,inst_56370);
} else {
if((state_val_56373 === (4))){
var inst_56348 = (state_56372[(2)]);
var state_56372__$1 = state_56372;
var statearr_56377_56390 = state_56372__$1;
(statearr_56377_56390[(2)] = inst_56348);

(statearr_56377_56390[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56373 === (5))){
var _ = (function (){var statearr_56378 = state_56372;
(statearr_56378[(4)] = cljs.core.rest((state_56372[(4)])));

return statearr_56378;
})();
var state_56372__$1 = state_56372;
var ex56376 = (state_56372__$1[(2)]);
var statearr_56379_56391 = state_56372__$1;
(statearr_56379_56391[(5)] = ex56376);


if((ex56376 instanceof Error)){
var statearr_56380_56392 = state_56372__$1;
(statearr_56380_56392[(1)] = (4));

(statearr_56380_56392[(5)] = null);

} else {
throw ex56376;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56373 === (6))){
var inst_56356 = (state_56372[(2)]);
var inst_56357 = fluree.db.util.async.throw_err(inst_56356);
var inst_56358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56359 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56361 = [compare_val,new_val];
var inst_56362 = (new cljs.core.PersistentVector(null,2,(5),inst_56360,inst_56361,null));
var inst_56363 = ["",inst_56362,inst_56357];
var inst_56364 = cljs.core.PersistentHashMap.fromArrays(inst_56359,inst_56363);
var inst_56365 = [inst_56364,(10)];
var inst_56366 = (new cljs.core.PersistentVector(null,2,(5),inst_56358,inst_56365,null));
var inst_56367 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56366);
var _ = (function (){var statearr_56381 = state_56372;
(statearr_56381[(4)] = cljs.core.rest((state_56372[(4)])));

return statearr_56381;
})();
var state_56372__$1 = (function (){var statearr_56382 = state_56372;
(statearr_56382[(7)] = inst_56367);

return statearr_56382;
})();
var statearr_56383_56393 = state_56372__$1;
(statearr_56383_56393[(2)] = inst_56357);

(statearr_56383_56393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____0 = (function (){
var statearr_56384 = [null,null,null,null,null,null,null,null];
(statearr_56384[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__);

(statearr_56384[(1)] = (1));

return statearr_56384;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____1 = (function (state_56372){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_56372);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e56385){var ex__2736__auto__ = e56385;
var statearr_56386_56394 = state_56372;
(statearr_56386_56394[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_56372[(4)]))){
var statearr_56387_56395 = state_56372;
(statearr_56387_56395[(1)] = cljs.core.first((state_56372[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56396 = state_56372;
state_56372 = G__56396;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__ = function(state_56372){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____1.call(this,state_56372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_56388 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_56388[(6)] = c__2755__auto__);

return statearr_56388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
