// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28462 = arguments.length;
var i__4830__auto___28463 = (0);
while(true){
if((i__4830__auto___28463 < len__4829__auto___28462)){
args__4835__auto__.push((arguments[i__4830__auto___28463]));

var G__28464 = (i__4830__auto___28463 + (1));
i__4830__auto___28463 = G__28464;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return (fluree.db.dbfunctions.internal.format.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.internal.format.cljs$core$IFn$_invoke$arity$4("Error in database function: %s: %s. Provided: %s",function_name,err_msg,args_SINGLEQUOTE_) : fluree.db.dbfunctions.internal.format.call(null,"Error in database function: %s: %s. Provided: %s",function_name,err_msg,args_SINGLEQUOTE_));
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28459){
var G__28460 = cljs.core.first(seq28459);
var seq28459__$1 = cljs.core.next(seq28459);
var G__28461 = cljs.core.first(seq28459__$1);
var seq28459__$2 = cljs.core.next(seq28459__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28460,G__28461,seq28459__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28465){var e = e28465;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28466){var e = e28466;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28467){var e = e28467;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28468){var e = e28468;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28469){var e = e28469;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28472 = arguments.length;
var i__4830__auto___28473 = (0);
while(true){
if((i__4830__auto___28473 < len__4829__auto___28472)){
args__4835__auto__.push((arguments[i__4830__auto___28473]));

var G__28474 = (i__4830__auto___28473 + (1));
i__4830__auto___28473 = G__28474;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28471){var e = e28471;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28470){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28470));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28477 = arguments.length;
var i__4830__auto___28478 = (0);
while(true){
if((i__4830__auto___28478 < len__4829__auto___28477)){
args__4835__auto__.push((arguments[i__4830__auto___28478]));

var G__28479 = (i__4830__auto___28478 + (1));
i__4830__auto___28478 = G__28479;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28476){var e = e28476;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28475){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28475));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28480){var e = e28480;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28483 = arguments.length;
var i__4830__auto___28484 = (0);
while(true){
if((i__4830__auto___28484 < len__4829__auto___28483)){
args__4835__auto__.push((arguments[i__4830__auto___28484]));

var G__28485 = (i__4830__auto___28484 + (1));
i__4830__auto___28484 = G__28485;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28482){var e = e28482;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28481){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28481));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28488 = arguments.length;
var i__4830__auto___28489 = (0);
while(true){
if((i__4830__auto___28489 < len__4829__auto___28488)){
args__4835__auto__.push((arguments[i__4830__auto___28489]));

var G__28490 = (i__4830__auto___28489 + (1));
i__4830__auto___28489 = G__28490;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28487){var e = e28487;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28486){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28486));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28491){var e = e28491;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28492){var e = e28492;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28495 = arguments.length;
var i__4830__auto___28496 = (0);
while(true){
if((i__4830__auto___28496 < len__4829__auto___28495)){
args__4835__auto__.push((arguments[i__4830__auto___28496]));

var G__28497 = (i__4830__auto___28496 + (1));
i__4830__auto___28496 = G__28497;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28494){var e = e28494;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28493){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28493));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28500 = arguments.length;
var i__4830__auto___28501 = (0);
while(true){
if((i__4830__auto___28501 < len__4829__auto___28500)){
args__4835__auto__.push((arguments[i__4830__auto___28501]));

var G__28502 = (i__4830__auto___28501 + (1));
i__4830__auto___28501 = G__28502;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28499){var e = e28499;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28498){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28498));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28505 = arguments.length;
var i__4830__auto___28506 = (0);
while(true){
if((i__4830__auto___28506 < len__4829__auto___28505)){
args__4835__auto__.push((arguments[i__4830__auto___28506]));

var G__28507 = (i__4830__auto___28506 + (1));
i__4830__auto___28506 = G__28507;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28504){var e = e28504;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28503){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28503));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28510 = arguments.length;
var i__4830__auto___28511 = (0);
while(true){
if((i__4830__auto___28511 < len__4829__auto___28510)){
args__4835__auto__.push((arguments[i__4830__auto___28511]));

var G__28512 = (i__4830__auto___28511 + (1));
i__4830__auto___28511 = G__28512;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28509){var e = e28509;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28508){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28508));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28515 = arguments.length;
var i__4830__auto___28516 = (0);
while(true){
if((i__4830__auto___28516 < len__4829__auto___28515)){
args__4835__auto__.push((arguments[i__4830__auto___28516]));

var G__28517 = (i__4830__auto___28516 + (1));
i__4830__auto___28516 = G__28517;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28514){var e = e28514;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28513){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28513));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28520 = arguments.length;
var i__4830__auto___28521 = (0);
while(true){
if((i__4830__auto___28521 < len__4829__auto___28520)){
args__4835__auto__.push((arguments[i__4830__auto___28521]));

var G__28522 = (i__4830__auto___28521 + (1));
i__4830__auto___28521 = G__28522;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28519){var e = e28519;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28518){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28518));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28525 = arguments.length;
var i__4830__auto___28526 = (0);
while(true){
if((i__4830__auto___28526 < len__4829__auto___28525)){
args__4835__auto__.push((arguments[i__4830__auto___28526]));

var G__28527 = (i__4830__auto___28526 + (1));
i__4830__auto___28526 = G__28527;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28524){var e = e28524;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28523){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28523));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28529 = arguments.length;
switch (G__28529) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28557){
var state_val_28558 = (state_28557[(1)]);
if((state_val_28558 === (7))){
var inst_28542 = (state_28557[(7)]);
var inst_28545 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28542,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28557__$1 = state_28557;
var statearr_28559_28645 = state_28557__$1;
(statearr_28559_28645[(2)] = inst_28545);

(statearr_28559_28645[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28558 === (1))){
var state_28557__$1 = state_28557;
var statearr_28560_28646 = state_28557__$1;
(statearr_28560_28646[(2)] = null);

(statearr_28560_28646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28558 === (4))){
var inst_28530 = (state_28557[(2)]);
var state_28557__$1 = state_28557;
var statearr_28561_28647 = state_28557__$1;
(statearr_28561_28647[(2)] = inst_28530);

(statearr_28561_28647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28558 === (6))){
var inst_28542 = (state_28557[(7)]);
var inst_28542__$1 = (state_28557[(2)]);
var inst_28543 = fluree.db.util.core.exception_QMARK_(inst_28542__$1);
var state_28557__$1 = (function (){var statearr_28562 = state_28557;
(statearr_28562[(7)] = inst_28542__$1);

return statearr_28562;
})();
if(inst_28543){
var statearr_28563_28648 = state_28557__$1;
(statearr_28563_28648[(1)] = (7));

} else {
var statearr_28564_28649 = state_28557__$1;
(statearr_28564_28649[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28558 === (3))){
var inst_28555 = (state_28557[(2)]);
var state_28557__$1 = state_28557;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28557__$1,inst_28555);
} else {
if((state_val_28558 === (2))){
var inst_28536 = (state_28557[(8)]);
var _ = (function (){var statearr_28566 = state_28557;
(statearr_28566[(4)] = cljs.core.cons((5),(state_28557[(4)])));

return statearr_28566;
})();
var inst_28536__$1 = cljs.core.volatile_BANG_((0));
var inst_28537 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28538 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28537,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28536__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28539 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28538);
var inst_28540 = fluree.db.query.fql.query(db,inst_28539);
var state_28557__$1 = (function (){var statearr_28567 = state_28557;
(statearr_28567[(8)] = inst_28536__$1);

return statearr_28567;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28557__$1,(6),inst_28540);
} else {
if((state_val_28558 === (9))){
var inst_28552 = (state_28557[(2)]);
var _ = (function (){var statearr_28568 = state_28557;
(statearr_28568[(4)] = cljs.core.rest((state_28557[(4)])));

return statearr_28568;
})();
var state_28557__$1 = state_28557;
var statearr_28569_28650 = state_28557__$1;
(statearr_28569_28650[(2)] = inst_28552);

(statearr_28569_28650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28558 === (5))){
var _ = (function (){var statearr_28570 = state_28557;
(statearr_28570[(4)] = cljs.core.rest((state_28557[(4)])));

return statearr_28570;
})();
var state_28557__$1 = state_28557;
var ex28565 = (state_28557__$1[(2)]);
var statearr_28571_28651 = state_28557__$1;
(statearr_28571_28651[(5)] = ex28565);


if((ex28565 instanceof Error)){
var statearr_28572_28652 = state_28557__$1;
(statearr_28572_28652[(1)] = (4));

(statearr_28572_28652[(5)] = null);

} else {
throw ex28565;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28558 === (8))){
var inst_28542 = (state_28557[(7)]);
var inst_28536 = (state_28557[(8)]);
var inst_28547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28548 = cljs.core.deref(inst_28536);
var inst_28549 = [inst_28542,inst_28548];
var inst_28550 = (new cljs.core.PersistentVector(null,2,(5),inst_28547,inst_28549,null));
var state_28557__$1 = state_28557;
var statearr_28573_28653 = state_28557__$1;
(statearr_28573_28653[(2)] = inst_28550);

(statearr_28573_28653[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_28574 = [null,null,null,null,null,null,null,null,null];
(statearr_28574[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_28574[(1)] = (1));

return statearr_28574;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_28557){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28557);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28575){var ex__2736__auto__ = e28575;
var statearr_28576_28654 = state_28557;
(statearr_28576_28654[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28557[(4)]))){
var statearr_28577_28655 = state_28557;
(statearr_28577_28655[(1)] = cljs.core.first((state_28557[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28656 = state_28557;
state_28557 = G__28656;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_28557){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_28557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28578 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28578[(6)] = c__2755__auto__);

return statearr_28578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28623){
var state_val_28624 = (state_28623[(1)]);
if((state_val_28624 === (7))){
var inst_28609 = (state_28623[(2)]);
var inst_28610 = fluree.db.query.fql.query(db,inst_28609);
var state_28623__$1 = state_28623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28623__$1,(8),inst_28610);
} else {
if((state_val_28624 === (1))){
var inst_28579 = typeof select === 'string';
var state_28623__$1 = state_28623;
if(cljs.core.truth_(inst_28579)){
var statearr_28625_28657 = state_28623__$1;
(statearr_28625_28657[(1)] = (2));

} else {
var statearr_28626_28658 = state_28623__$1;
(statearr_28626_28658[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (4))){
var inst_28592 = (state_28623[(7)]);
var inst_28585 = (state_28623[(8)]);
var inst_28584 = (state_28623[(2)]);
var inst_28585__$1 = cljs.core.volatile_BANG_((0));
var inst_28586 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28587 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28588 = [inst_28585__$1,(100000)];
var inst_28589 = cljs.core.PersistentHashMap.fromArrays(inst_28587,inst_28588);
var inst_28590 = [inst_28584,from,where,block,limit,inst_28589];
var inst_28591 = cljs.core.PersistentHashMap.fromArrays(inst_28586,inst_28590);
var inst_28592__$1 = fluree.db.util.core.without_nils(inst_28591);
var inst_28593 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28592__$1);
var inst_28594 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28592__$1);
var inst_28595 = cljs.core.first(inst_28594);
var inst_28596 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28595], 0));
var inst_28597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28596);
var inst_28598 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28592__$1);
var inst_28599 = cljs.core.last(inst_28598);
var inst_28600 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28599], 0));
var inst_28601 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28600);
var inst_28602 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28593,inst_28597,inst_28601], 0));
var state_28623__$1 = (function (){var statearr_28627 = state_28623;
(statearr_28627[(7)] = inst_28592__$1);

(statearr_28627[(8)] = inst_28585__$1);

return statearr_28627;
})();
if(cljs.core.truth_(inst_28602)){
var statearr_28628_28659 = state_28623__$1;
(statearr_28628_28659[(1)] = (5));

} else {
var statearr_28629_28660 = state_28623__$1;
(statearr_28629_28660[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (6))){
var inst_28592 = (state_28623[(7)]);
var state_28623__$1 = state_28623;
var statearr_28630_28661 = state_28623__$1;
(statearr_28630_28661[(2)] = inst_28592);

(statearr_28630_28661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (3))){
var state_28623__$1 = state_28623;
var statearr_28631_28662 = state_28623__$1;
(statearr_28631_28662[(2)] = select);

(statearr_28631_28662[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (2))){
var inst_28581 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28623__$1 = state_28623;
var statearr_28632_28663 = state_28623__$1;
(statearr_28632_28663[(2)] = inst_28581);

(statearr_28632_28663[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (11))){
var inst_28621 = (state_28623[(2)]);
var state_28623__$1 = state_28623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28623__$1,inst_28621);
} else {
if((state_val_28624 === (9))){
var inst_28612 = (state_28623[(9)]);
var state_28623__$1 = state_28623;
var statearr_28633_28664 = state_28623__$1;
(statearr_28633_28664[(2)] = inst_28612);

(statearr_28633_28664[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (5))){
var inst_28592 = (state_28623[(7)]);
var inst_28604 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28592);
var inst_28605 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28604);
var inst_28606 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28592,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28605);
var state_28623__$1 = state_28623;
var statearr_28634_28665 = state_28623__$1;
(statearr_28634_28665[(2)] = inst_28606);

(statearr_28634_28665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (10))){
var inst_28612 = (state_28623[(9)]);
var inst_28585 = (state_28623[(8)]);
var inst_28616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28617 = cljs.core.deref(inst_28585);
var inst_28618 = [inst_28612,inst_28617];
var inst_28619 = (new cljs.core.PersistentVector(null,2,(5),inst_28616,inst_28618,null));
var state_28623__$1 = state_28623;
var statearr_28635_28666 = state_28623__$1;
(statearr_28635_28666[(2)] = inst_28619);

(statearr_28635_28666[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28624 === (8))){
var inst_28612 = (state_28623[(9)]);
var inst_28612__$1 = (state_28623[(2)]);
var inst_28613 = fluree.db.util.core.exception_QMARK_(inst_28612__$1);
var state_28623__$1 = (function (){var statearr_28636 = state_28623;
(statearr_28636[(9)] = inst_28612__$1);

return statearr_28636;
})();
if(inst_28613){
var statearr_28637_28667 = state_28623__$1;
(statearr_28637_28667[(1)] = (9));

} else {
var statearr_28638_28668 = state_28623__$1;
(statearr_28638_28668[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_28639 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28639[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_28639[(1)] = (1));

return statearr_28639;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_28623){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28623);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28640){var ex__2736__auto__ = e28640;
var statearr_28641_28669 = state_28623;
(statearr_28641_28669[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28623[(4)]))){
var statearr_28642_28670 = state_28623;
(statearr_28642_28670[(1)] = cljs.core.first((state_28623[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28671 = state_28623;
state_28623 = G__28671;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_28623){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_28623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28643 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28643[(6)] = c__2755__auto__);

return statearr_28643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28675 = path;
var vec__28676 = G__28675;
var seq__28677 = cljs.core.seq(vec__28676);
var first__28678 = cljs.core.first(seq__28677);
var seq__28677__$1 = cljs.core.next(seq__28677);
var var$ = first__28678;
var r = seq__28677__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28675__$1 = G__28675;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28682 = G__28675__$1;
var seq__28683 = cljs.core.seq(vec__28682);
var first__28684 = cljs.core.first(seq__28683);
var seq__28683__$1 = cljs.core.next(seq__28683);
var var$__$1 = first__28684;
var r__$1 = seq__28683__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28685 = r__$1;
var G__28686 = n__$2;
var G__28687 = next_clauses;
G__28675__$1 = G__28685;
n__$1 = G__28686;
where_clauses__$1 = G__28687;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28688 = r__$1;
var G__28689 = next_n;
var G__28690 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28675__$1 = G__28688;
n__$1 = G__28689;
where_clauses__$1 = G__28690;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28727){
var state_val_28728 = (state_28727[(1)]);
if((state_val_28728 === (7))){
var inst_28700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28701 = [path];
var inst_28702 = (new cljs.core.PersistentVector(null,1,(5),inst_28700,inst_28701,null));
var state_28727__$1 = state_28727;
var statearr_28729_28757 = state_28727__$1;
(statearr_28729_28757[(2)] = inst_28702);

(statearr_28729_28757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (1))){
var state_28727__$1 = state_28727;
var statearr_28730_28758 = state_28727__$1;
(statearr_28730_28758[(2)] = null);

(statearr_28730_28758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (4))){
var inst_28691 = (state_28727[(2)]);
var state_28727__$1 = state_28727;
var statearr_28731_28759 = state_28727__$1;
(statearr_28731_28759[(2)] = inst_28691);

(statearr_28731_28759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (13))){
var inst_28718 = (state_28727[(2)]);
var inst_28719 = fluree.db.util.async.throw_err(inst_28718);
var _ = (function (){var statearr_28732 = state_28727;
(statearr_28732[(4)] = cljs.core.rest((state_28727[(4)])));

return statearr_28732;
})();
var state_28727__$1 = state_28727;
var statearr_28733_28760 = state_28727__$1;
(statearr_28733_28760[(2)] = inst_28719);

(statearr_28733_28760[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (6))){
var state_28727__$1 = state_28727;
var statearr_28735_28761 = state_28727__$1;
(statearr_28735_28761[(2)] = path);

(statearr_28735_28761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (3))){
var inst_28725 = (state_28727[(2)]);
var state_28727__$1 = state_28727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28727__$1,inst_28725);
} else {
if((state_val_28728 === (12))){
var _ = (function (){var statearr_28736 = state_28727;
(statearr_28736[(4)] = cljs.core.rest((state_28727[(4)])));

return statearr_28736;
})();
var state_28727__$1 = state_28727;
var ex28734 = (state_28727__$1[(2)]);
var statearr_28737_28762 = state_28727__$1;
(statearr_28737_28762[(5)] = ex28734);


var statearr_28738_28763 = state_28727__$1;
(statearr_28738_28763[(1)] = (11));

(statearr_28738_28763[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (2))){
var _ = (function (){var statearr_28739 = state_28727;
(statearr_28739[(4)] = cljs.core.cons((5),(state_28727[(4)])));

return statearr_28739;
})();
var inst_28697 = cljs.core.vector_QMARK_(path);
var state_28727__$1 = state_28727;
if(inst_28697){
var statearr_28740_28764 = state_28727__$1;
(statearr_28740_28764[(1)] = (6));

} else {
var statearr_28741_28765 = state_28727__$1;
(statearr_28741_28765[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (11))){
var inst_28704 = (state_28727[(7)]);
var inst_28709 = (state_28727[(2)]);
var inst_28710 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28709,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28704,endSubject], 0));
var state_28727__$1 = state_28727;
var statearr_28743_28766 = state_28727__$1;
(statearr_28743_28766[(2)] = inst_28710);

(statearr_28743_28766[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (9))){
var inst_28708 = (state_28727[(8)]);
var _ = (function (){var statearr_28744 = state_28727;
(statearr_28744[(4)] = cljs.core.cons((12),(state_28727[(4)])));

return statearr_28744;
})();
var inst_28716 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28708);
var state_28727__$1 = state_28727;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28727__$1,(13),inst_28716);
} else {
if((state_val_28728 === (5))){
var _ = (function (){var statearr_28745 = state_28727;
(statearr_28745[(4)] = cljs.core.rest((state_28727[(4)])));

return statearr_28745;
})();
var state_28727__$1 = state_28727;
var ex28742 = (state_28727__$1[(2)]);
var statearr_28746_28767 = state_28727__$1;
(statearr_28746_28767[(5)] = ex28742);


if((ex28742 instanceof Error)){
var statearr_28747_28768 = state_28727__$1;
(statearr_28747_28768[(1)] = (4));

(statearr_28747_28768[(5)] = null);

} else {
throw ex28742;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (10))){
var inst_28722 = (state_28727[(2)]);
var _ = (function (){var statearr_28748 = state_28727;
(statearr_28748[(4)] = cljs.core.rest((state_28727[(4)])));

return statearr_28748;
})();
var state_28727__$1 = state_28727;
var statearr_28749_28769 = state_28727__$1;
(statearr_28749_28769[(2)] = inst_28722);

(statearr_28749_28769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28728 === (8))){
var inst_28704 = (state_28727[(7)]);
var inst_28704__$1 = (state_28727[(2)]);
var inst_28705 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28704__$1,endSubject);
var inst_28706 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28707 = ["?var1",inst_28705];
var inst_28708 = cljs.core.PersistentHashMap.fromArrays(inst_28706,inst_28707);
var state_28727__$1 = (function (){var statearr_28750 = state_28727;
(statearr_28750[(7)] = inst_28704__$1);

(statearr_28750[(8)] = inst_28708);

return statearr_28750;
})();
var statearr_28751_28770 = state_28727__$1;
(statearr_28751_28770[(2)] = null);

(statearr_28751_28770[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_28752 = [null,null,null,null,null,null,null,null,null];
(statearr_28752[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__);

(statearr_28752[(1)] = (1));

return statearr_28752;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____1 = (function (state_28727){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28727);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28753){var ex__2736__auto__ = e28753;
var statearr_28754_28771 = state_28727;
(statearr_28754_28771[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28727[(4)]))){
var statearr_28755_28772 = state_28727;
(statearr_28755_28772[(1)] = cljs.core.first((state_28727[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28773 = state_28727;
state_28727 = G__28773;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__ = function(state_28727){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____1.call(this,state_28727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28756 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28756[(6)] = c__2755__auto__);

return statearr_28756;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28774){var e = e28774;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28775){var e = e28775;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28776){var e = e28776;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28777){var e = e28777;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28780 = arguments.length;
var i__4830__auto___28781 = (0);
while(true){
if((i__4830__auto___28781 < len__4829__auto___28780)){
args__4835__auto__.push((arguments[i__4830__auto___28781]));

var G__28782 = (i__4830__auto___28781 + (1));
i__4830__auto___28781 = G__28782;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28779){var e = e28779;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28778){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28778));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28785 = arguments.length;
var i__4830__auto___28786 = (0);
while(true){
if((i__4830__auto___28786 < len__4829__auto___28785)){
args__4835__auto__.push((arguments[i__4830__auto___28786]));

var G__28787 = (i__4830__auto___28786 + (1));
i__4830__auto___28786 = G__28787;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28784){var e = e28784;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28783){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28783));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28790 = arguments.length;
var i__4830__auto___28791 = (0);
while(true){
if((i__4830__auto___28791 < len__4829__auto___28790)){
args__4835__auto__.push((arguments[i__4830__auto___28791]));

var G__28792 = (i__4830__auto___28791 + (1));
i__4830__auto___28791 = G__28792;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28789){var e = e28789;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28788){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28788));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28795 = arguments.length;
var i__4830__auto___28796 = (0);
while(true){
if((i__4830__auto___28796 < len__4829__auto___28795)){
args__4835__auto__.push((arguments[i__4830__auto___28796]));

var G__28797 = (i__4830__auto___28796 + (1));
i__4830__auto___28796 = G__28797;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28794){var e = e28794;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28793){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28793));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28798){var e = e28798;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28799){var e = e28799;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28800){var e = e28800;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28801){var e = e28801;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28802){var e = e28802;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28808 = path;
var vec__28809 = G__28808;
var seq__28810 = cljs.core.seq(vec__28809);
var first__28811 = cljs.core.first(seq__28810);
var seq__28810__$1 = cljs.core.next(seq__28810);
var pred = first__28811;
var r = seq__28810__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28808__$1 = G__28808;
var subjects__$1 = subjects;
while(true){
var vec__28815 = G__28808__$1;
var seq__28816 = cljs.core.seq(vec__28815);
var first__28817 = cljs.core.first(seq__28816);
var seq__28816__$1 = cljs.core.next(seq__28816);
var pred__$1 = first__28817;
var r__$1 = seq__28816__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28808__$1,subjects__$1,vec__28815,seq__28816,first__28817,seq__28816__$1,pred__$1,r__$1,subjects__$2,G__28808,vec__28809,seq__28810,first__28811,seq__28810__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28808__$1,subjects__$1,vec__28815,seq__28816,first__28817,seq__28816__$1,pred__$1,r__$1,subjects__$2,G__28808,vec__28809,seq__28810,first__28811,seq__28810__$1,pred,r,subjects){
return (function (p1__28803_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28803_SHARP_,pred__$1);
});})(G__28808__$1,subjects__$1,vec__28815,seq__28816,first__28817,seq__28816__$1,pred__$1,r__$1,subjects__$2,G__28808,vec__28809,seq__28810,first__28811,seq__28810__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28808__$1,subjects__$1,vec__28815,seq__28816,first__28817,seq__28816__$1,pred__$1,r__$1,subjects__$2,G__28808,vec__28809,seq__28810,first__28811,seq__28810__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__28818 = r__$1;
var G__28819 = next_subjects;
G__28808__$1 = G__28818;
subjects__$1 = G__28819;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28804){var e = e28804;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28820){var e = e28820;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e28821){var e = e28821;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28824 = arguments.length;
var i__4830__auto___28825 = (0);
while(true){
if((i__4830__auto___28825 < len__4829__auto___28824)){
args__4835__auto__.push((arguments[i__4830__auto___28825]));

var G__28826 = (i__4830__auto___28825 + (1));
i__4830__auto___28825 = G__28826;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28823){var e = e28823;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28822){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28822));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28827){var e = e28827;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___28830 = arguments.length;
var i__4830__auto___28831 = (0);
while(true){
if((i__4830__auto___28831 < len__4829__auto___28830)){
args__4835__auto__.push((arguments[i__4830__auto___28831]));

var G__28832 = (i__4830__auto___28831 + (1));
i__4830__auto___28831 = G__28832;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28829){var e = e28829;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28828){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28828));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28833){var e = e28833;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28890){
var state_val_28891 = (state_28890[(1)]);
if((state_val_28891 === (7))){
var inst_28836 = (state_28890[(2)]);
var state_28890__$1 = state_28890;
var statearr_28892_28926 = state_28890__$1;
(statearr_28892_28926[(2)] = inst_28836);

(statearr_28892_28926[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (1))){
var state_28890__$1 = state_28890;
var statearr_28893_28927 = state_28890__$1;
(statearr_28893_28927[(2)] = null);

(statearr_28893_28927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (4))){
var inst_28835 = (state_28890[(2)]);
var state_28890__$1 = (function (){var statearr_28894 = state_28890;
(statearr_28894[(7)] = inst_28835);

return statearr_28894;
})();
var statearr_28895_28928 = state_28890__$1;
(statearr_28895_28928[(2)] = null);

(statearr_28895_28928[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (15))){
var inst_28870 = (state_28890[(8)]);
var inst_28871 = (state_28890[(9)]);
var inst_28873 = (state_28890[(10)]);
var inst_28858 = (state_28890[(11)]);
var inst_28861 = (state_28890[(12)]);
var inst_28860 = (state_28890[(13)]);
var inst_28877 = (function (){var db = inst_28858;
var prevT = inst_28860;
var db_SINGLEQUOTE_ = inst_28861;
var prev_vals = inst_28870;
var fuel = inst_28871;
var G__28872 = inst_28873;
return (function (p1__28834_SHARP_){
var f = p1__28834_SHARP_;
return f.o;
});
})();
var inst_28878 = (inst_28877.cljs$core$IFn$_invoke$arity$1 ? inst_28877.cljs$core$IFn$_invoke$arity$1(inst_28873) : inst_28877.call(null,inst_28873));
var state_28890__$1 = state_28890;
var statearr_28896_28929 = state_28890__$1;
(statearr_28896_28929[(2)] = inst_28878);

(statearr_28896_28929[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (13))){
var inst_28870 = (state_28890[(8)]);
var inst_28873 = (state_28890[(10)]);
var inst_28869 = (state_28890[(2)]);
var inst_28870__$1 = fluree.db.util.async.throw_err(inst_28869);
var inst_28871 = fluree.db.dbfunctions.internal.count(inst_28870__$1);
var inst_28873__$1 = cljs.core.first(inst_28870__$1);
var inst_28874 = (inst_28873__$1 == null);
var state_28890__$1 = (function (){var statearr_28897 = state_28890;
(statearr_28897[(8)] = inst_28870__$1);

(statearr_28897[(9)] = inst_28871);

(statearr_28897[(10)] = inst_28873__$1);

return statearr_28897;
})();
if(cljs.core.truth_(inst_28874)){
var statearr_28898_28930 = state_28890__$1;
(statearr_28898_28930[(1)] = (14));

} else {
var statearr_28899_28931 = state_28890__$1;
(statearr_28899_28931[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (6))){
var inst_28845 = (state_28890[(2)]);
var state_28890__$1 = state_28890;
var statearr_28900_28932 = state_28890__$1;
(statearr_28900_28932[(2)] = inst_28845);

(statearr_28900_28932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (3))){
var inst_28888 = (state_28890[(2)]);
var state_28890__$1 = state_28890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28890__$1,inst_28888);
} else {
if((state_val_28891 === (12))){
var inst_28885 = (state_28890[(2)]);
var _ = (function (){var statearr_28901 = state_28890;
(statearr_28901[(4)] = cljs.core.rest((state_28890[(4)])));

return statearr_28901;
})();
var state_28890__$1 = state_28890;
var statearr_28902_28933 = state_28890__$1;
(statearr_28902_28933[(2)] = inst_28885);

(statearr_28902_28933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (2))){
var _ = (function (){var statearr_28904 = state_28890;
(statearr_28904[(4)] = cljs.core.cons((9),(state_28890[(4)])));

return statearr_28904;
})();
var inst_28851 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28852 = typeof inst_28851 === 'string';
var state_28890__$1 = state_28890;
if(cljs.core.truth_(inst_28852)){
var statearr_28905_28934 = state_28890__$1;
(statearr_28905_28934[(1)] = (10));

} else {
var statearr_28906_28935 = state_28890__$1;
(statearr_28906_28935[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (11))){
var inst_28858 = (state_28890[(11)]);
var inst_28861 = (state_28890[(12)]);
var inst_28860 = (state_28890[(13)]);
var inst_28858__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28859 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28858__$1);
var inst_28860__$1 = fluree.db.dbfunctions.internal.inc(inst_28859);
var inst_28861__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28858__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28860__$1);
var inst_28862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28863 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28864 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28865 = [inst_28863,inst_28864];
var inst_28866 = (new cljs.core.PersistentVector(null,2,(5),inst_28862,inst_28865,null));
var inst_28867 = fluree.db.dbproto._search(inst_28861__$1,inst_28866);
var state_28890__$1 = (function (){var statearr_28907 = state_28890;
(statearr_28907[(11)] = inst_28858__$1);

(statearr_28907[(12)] = inst_28861__$1);

(statearr_28907[(13)] = inst_28860__$1);

return statearr_28907;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28890__$1,(13),inst_28867);
} else {
if((state_val_28891 === (9))){
var _ = (function (){var statearr_28908 = state_28890;
(statearr_28908[(4)] = cljs.core.rest((state_28890[(4)])));

return statearr_28908;
})();
var state_28890__$1 = state_28890;
var ex28903 = (state_28890__$1[(2)]);
var statearr_28909_28936 = state_28890__$1;
(statearr_28909_28936[(5)] = ex28903);


var statearr_28910_28937 = state_28890__$1;
(statearr_28910_28937[(1)] = (4));

(statearr_28910_28937[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (5))){
var inst_28835 = (state_28890[(7)]);
var _ = (function (){var statearr_28911 = state_28890;
(statearr_28911[(4)] = cljs.core.cons((8),(state_28890[(4)])));

return statearr_28911;
})();
var inst_28842 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28835,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_28912 = state_28890;
(statearr_28912[(4)] = cljs.core.rest((state_28890[(4)])));

return statearr_28912;
})();
var state_28890__$1 = state_28890;
var statearr_28913_28938 = state_28890__$1;
(statearr_28913_28938[(2)] = inst_28842);

(statearr_28913_28938[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (14))){
var state_28890__$1 = state_28890;
var statearr_28914_28939 = state_28890__$1;
(statearr_28914_28939[(2)] = null);

(statearr_28914_28939[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (16))){
var inst_28871 = (state_28890[(9)]);
var inst_28880 = (state_28890[(2)]);
var inst_28881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28882 = [inst_28880,inst_28871];
var inst_28883 = (new cljs.core.PersistentVector(null,2,(5),inst_28881,inst_28882,null));
var state_28890__$1 = state_28890;
var statearr_28916_28940 = state_28890__$1;
(statearr_28916_28940[(2)] = inst_28883);

(statearr_28916_28940[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (10))){
var inst_28854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28855 = [null,(0)];
var inst_28856 = (new cljs.core.PersistentVector(null,2,(5),inst_28854,inst_28855,null));
var state_28890__$1 = state_28890;
var statearr_28917_28941 = state_28890__$1;
(statearr_28917_28941[(2)] = inst_28856);

(statearr_28917_28941[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28891 === (8))){
var _ = (function (){var statearr_28918 = state_28890;
(statearr_28918[(4)] = cljs.core.rest((state_28890[(4)])));

return statearr_28918;
})();
var state_28890__$1 = state_28890;
var ex28915 = (state_28890__$1[(2)]);
var statearr_28919_28942 = state_28890__$1;
(statearr_28919_28942[(5)] = ex28915);


var statearr_28920_28943 = state_28890__$1;
(statearr_28920_28943[(1)] = (7));

(statearr_28920_28943[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____0 = (function (){
var statearr_28921 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28921[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__);

(statearr_28921[(1)] = (1));

return statearr_28921;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____1 = (function (state_28890){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28890);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e28922){var ex__2736__auto__ = e28922;
var statearr_28923_28944 = state_28890;
(statearr_28923_28944[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28890[(4)]))){
var statearr_28924_28945 = state_28890;
(statearr_28924_28945[(1)] = cljs.core.first((state_28890[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28946 = state_28890;
state_28890 = G__28946;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__ = function(state_28890){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____1.call(this,state_28890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_28925 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_28925[(6)] = c__2755__auto__);

return statearr_28925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_28998){
var state_val_28999 = (state_28998[(1)]);
if((state_val_28999 === (7))){
var inst_28948 = (state_28998[(2)]);
var state_28998__$1 = state_28998;
var statearr_29000_29029 = state_28998__$1;
(statearr_29000_29029[(2)] = inst_28948);

(statearr_29000_29029[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (1))){
var state_28998__$1 = state_28998;
var statearr_29001_29030 = state_28998__$1;
(statearr_29001_29030[(2)] = null);

(statearr_29001_29030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (4))){
var inst_28947 = (state_28998[(2)]);
var state_28998__$1 = (function (){var statearr_29002 = state_28998;
(statearr_29002[(7)] = inst_28947);

return statearr_29002;
})();
var statearr_29003_29031 = state_28998__$1;
(statearr_29003_29031[(2)] = null);

(statearr_29003_29031[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (13))){
var inst_28993 = (state_28998[(2)]);
var _ = (function (){var statearr_29004 = state_28998;
(statearr_29004[(4)] = cljs.core.rest((state_28998[(4)])));

return statearr_29004;
})();
var state_28998__$1 = state_28998;
var statearr_29005_29032 = state_28998__$1;
(statearr_29005_29032[(2)] = inst_28993);

(statearr_29005_29032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (6))){
var inst_28957 = (state_28998[(2)]);
var state_28998__$1 = state_28998;
var statearr_29006_29033 = state_28998__$1;
(statearr_29006_29033[(2)] = inst_28957);

(statearr_29006_29033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (3))){
var inst_28996 = (state_28998[(2)]);
var state_28998__$1 = state_28998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28998__$1,inst_28996);
} else {
if((state_val_28999 === (12))){
var inst_28980 = (state_28998[(8)]);
var inst_28989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28990 = [null,inst_28980];
var inst_28991 = (new cljs.core.PersistentVector(null,2,(5),inst_28989,inst_28990,null));
var state_28998__$1 = state_28998;
var statearr_29007_29034 = state_28998__$1;
(statearr_29007_29034[(2)] = inst_28991);

(statearr_29007_29034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (2))){
var _ = (function (){var statearr_29009 = state_28998;
(statearr_29009[(4)] = cljs.core.cons((9),(state_28998[(4)])));

return statearr_29009;
})();
var inst_28966 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28969 = [null,pred_name,"?o"];
var inst_28970 = (new cljs.core.PersistentVector(null,3,(5),inst_28968,inst_28969,null));
var inst_28971 = [inst_28970];
var inst_28972 = (new cljs.core.PersistentVector(null,1,(5),inst_28967,inst_28971,null));
var inst_28973 = ["?o",inst_28972,opts];
var inst_28974 = cljs.core.PersistentHashMap.fromArrays(inst_28966,inst_28973);
var inst_28975 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28974);
var state_28998__$1 = state_28998;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28998__$1,(10),inst_28975);
} else {
if((state_val_28999 === (11))){
var inst_28980 = (state_28998[(8)]);
var inst_28979 = (state_28998[(9)]);
var inst_28984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28985 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_28979);
var inst_28986 = [inst_28985,inst_28980];
var inst_28987 = (new cljs.core.PersistentVector(null,2,(5),inst_28984,inst_28986,null));
var state_28998__$1 = state_28998;
var statearr_29010_29035 = state_28998__$1;
(statearr_29010_29035[(2)] = inst_28987);

(statearr_29010_29035[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (9))){
var _ = (function (){var statearr_29011 = state_28998;
(statearr_29011[(4)] = cljs.core.rest((state_28998[(4)])));

return statearr_29011;
})();
var state_28998__$1 = state_28998;
var ex29008 = (state_28998__$1[(2)]);
var statearr_29012_29036 = state_28998__$1;
(statearr_29012_29036[(5)] = ex29008);


var statearr_29013_29037 = state_28998__$1;
(statearr_29013_29037[(1)] = (4));

(statearr_29013_29037[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (5))){
var inst_28947 = (state_28998[(7)]);
var _ = (function (){var statearr_29015 = state_28998;
(statearr_29015[(4)] = cljs.core.cons((8),(state_28998[(4)])));

return statearr_29015;
})();
var inst_28954 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28947,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_29016 = state_28998;
(statearr_29016[(4)] = cljs.core.rest((state_28998[(4)])));

return statearr_29016;
})();
var state_28998__$1 = state_28998;
var statearr_29017_29038 = state_28998__$1;
(statearr_29017_29038[(2)] = inst_28954);

(statearr_29017_29038[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (10))){
var inst_28979 = (state_28998[(9)]);
var inst_28977 = (state_28998[(2)]);
var inst_28978 = fluree.db.util.async.throw_err(inst_28977);
var inst_28979__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28978,(0),null);
var inst_28980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28978,(1),null);
var inst_28981 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_28979__$1);
var inst_28982 = cljs.core.not(inst_28981);
var state_28998__$1 = (function (){var statearr_29018 = state_28998;
(statearr_29018[(8)] = inst_28980);

(statearr_29018[(9)] = inst_28979__$1);

return statearr_29018;
})();
if(inst_28982){
var statearr_29019_29039 = state_28998__$1;
(statearr_29019_29039[(1)] = (11));

} else {
var statearr_29020_29040 = state_28998__$1;
(statearr_29020_29040[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28999 === (8))){
var _ = (function (){var statearr_29021 = state_28998;
(statearr_29021[(4)] = cljs.core.rest((state_28998[(4)])));

return statearr_29021;
})();
var state_28998__$1 = state_28998;
var ex29014 = (state_28998__$1[(2)]);
var statearr_29022_29041 = state_28998__$1;
(statearr_29022_29041[(5)] = ex29014);


var statearr_29023_29042 = state_28998__$1;
(statearr_29023_29042[(1)] = (7));

(statearr_29023_29042[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____0 = (function (){
var statearr_29024 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29024[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__);

(statearr_29024[(1)] = (1));

return statearr_29024;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____1 = (function (state_28998){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_28998);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29025){var ex__2736__auto__ = e29025;
var statearr_29026_29043 = state_28998;
(statearr_29026_29043[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_28998[(4)]))){
var statearr_29027_29044 = state_28998;
(statearr_29027_29044[(1)] = cljs.core.first((state_28998[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29045 = state_28998;
state_28998 = G__29045;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__ = function(state_28998){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____1.call(this,state_28998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29028 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29028[(6)] = c__2755__auto__);

return statearr_29028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e29046){var e = e29046;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29048 = arguments.length;
switch (G__29048) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29118){
var state_val_29119 = (state_29118[(1)]);
if((state_val_29119 === (7))){
var inst_29050 = (state_29118[(2)]);
var state_29118__$1 = state_29118;
var statearr_29120_29164 = state_29118__$1;
(statearr_29120_29164[(2)] = inst_29050);

(statearr_29120_29164[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (20))){
var inst_29094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29095 = ["*"];
var inst_29096 = (new cljs.core.PersistentVector(null,1,(5),inst_29094,inst_29095,null));
var state_29118__$1 = state_29118;
var statearr_29121_29165 = state_29118__$1;
(statearr_29121_29165[(2)] = inst_29096);

(statearr_29121_29165[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (1))){
var state_29118__$1 = state_29118;
var statearr_29122_29166 = state_29118__$1;
(statearr_29122_29166[(2)] = null);

(statearr_29122_29166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (4))){
var inst_29049 = (state_29118[(2)]);
var state_29118__$1 = (function (){var statearr_29123 = state_29118;
(statearr_29123[(7)] = inst_29049);

return statearr_29123;
})();
var statearr_29124_29167 = state_29118__$1;
(statearr_29124_29167[(2)] = null);

(statearr_29124_29167[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (15))){
var inst_29113 = (state_29118[(2)]);
var _ = (function (){var statearr_29125 = state_29118;
(statearr_29125[(4)] = cljs.core.rest((state_29118[(4)])));

return statearr_29125;
})();
var state_29118__$1 = state_29118;
var statearr_29126_29168 = state_29118__$1;
(statearr_29126_29168[(2)] = inst_29113);

(statearr_29126_29168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (21))){
var inst_29084 = (state_29118[(8)]);
var inst_29077 = (state_29118[(9)]);
var inst_29098 = (state_29118[(2)]);
var inst_29099 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29100 = cljs.core.PersistentHashMap.EMPTY;
var inst_29101 = [inst_29098,inst_29084,inst_29100];
var inst_29102 = cljs.core.PersistentHashMap.fromArrays(inst_29099,inst_29101);
var inst_29103 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29077,inst_29102);
var state_29118__$1 = state_29118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29118__$1,(22),inst_29103);
} else {
if((state_val_29119 === (13))){
var inst_29072 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29118__$1 = state_29118;
var statearr_29127_29169 = state_29118__$1;
(statearr_29127_29169[(2)] = inst_29072);

(statearr_29127_29169[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (22))){
var inst_29105 = (state_29118[(2)]);
var inst_29106 = fluree.db.util.async.throw_err(inst_29105);
var inst_29107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29106,(0),null);
var inst_29108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29106,(1),null);
var inst_29109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29110 = [inst_29107,inst_29108];
var inst_29111 = (new cljs.core.PersistentVector(null,2,(5),inst_29109,inst_29110,null));
var state_29118__$1 = state_29118;
var statearr_29128_29170 = state_29118__$1;
(statearr_29128_29170[(2)] = inst_29111);

(statearr_29128_29170[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (6))){
var inst_29059 = (state_29118[(2)]);
var state_29118__$1 = state_29118;
var statearr_29129_29171 = state_29118__$1;
(statearr_29129_29171[(2)] = inst_29059);

(statearr_29129_29171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (17))){
var inst_29081 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29082 = fluree.db.dbfunctions.internal.get(inst_29081,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29118__$1 = state_29118;
var statearr_29130_29172 = state_29118__$1;
(statearr_29130_29172[(2)] = inst_29082);

(statearr_29130_29172[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (3))){
var inst_29116 = (state_29118[(2)]);
var state_29118__$1 = state_29118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29118__$1,inst_29116);
} else {
if((state_val_29119 === (12))){
var inst_29070 = (state_29118[(2)]);
var state_29118__$1 = state_29118;
if(cljs.core.truth_(inst_29070)){
var statearr_29131_29173 = state_29118__$1;
(statearr_29131_29173[(1)] = (13));

} else {
var statearr_29132_29174 = state_29118__$1;
(statearr_29132_29174[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (2))){
var inst_29065 = (state_29118[(10)]);
var _ = (function (){var statearr_29133 = state_29118;
(statearr_29133[(4)] = cljs.core.cons((9),(state_29118[(4)])));

return statearr_29133;
})();
var inst_29065__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29118__$1 = (function (){var statearr_29134 = state_29118;
(statearr_29134[(10)] = inst_29065__$1);

return statearr_29134;
})();
if(cljs.core.truth_(inst_29065__$1)){
var statearr_29135_29175 = state_29118__$1;
(statearr_29135_29175[(1)] = (10));

} else {
var statearr_29136_29176 = state_29118__$1;
(statearr_29136_29176[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (19))){
var inst_29086 = cljs.core.PersistentVector.EMPTY;
var inst_29087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29088 = ["*"];
var inst_29089 = (new cljs.core.PersistentVector(null,1,(5),inst_29087,inst_29088,null));
var inst_29090 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29091 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29089,inst_29090);
var inst_29092 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29086,inst_29091);
var state_29118__$1 = state_29118;
var statearr_29138_29177 = state_29118__$1;
(statearr_29138_29177[(2)] = inst_29092);

(statearr_29138_29177[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (11))){
var inst_29065 = (state_29118[(10)]);
var state_29118__$1 = state_29118;
var statearr_29139_29178 = state_29118__$1;
(statearr_29139_29178[(2)] = inst_29065);

(statearr_29139_29178[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (9))){
var _ = (function (){var statearr_29140 = state_29118;
(statearr_29140[(4)] = cljs.core.rest((state_29118[(4)])));

return statearr_29140;
})();
var state_29118__$1 = state_29118;
var ex29137 = (state_29118__$1[(2)]);
var statearr_29141_29179 = state_29118__$1;
(statearr_29141_29179[(5)] = ex29137);


var statearr_29142_29180 = state_29118__$1;
(statearr_29142_29180[(1)] = (4));

(statearr_29142_29180[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (5))){
var inst_29049 = (state_29118[(7)]);
var _ = (function (){var statearr_29143 = state_29118;
(statearr_29143[(4)] = cljs.core.cons((8),(state_29118[(4)])));

return statearr_29143;
})();
var inst_29056 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29049,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29144 = state_29118;
(statearr_29144[(4)] = cljs.core.rest((state_29118[(4)])));

return statearr_29144;
})();
var state_29118__$1 = state_29118;
var statearr_29145_29181 = state_29118__$1;
(statearr_29145_29181[(2)] = inst_29056);

(statearr_29145_29181[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (14))){
var inst_29078 = (state_29118[(11)]);
var inst_29077 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29078__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29118__$1 = (function (){var statearr_29146 = state_29118;
(statearr_29146[(11)] = inst_29078__$1);

(statearr_29146[(9)] = inst_29077);

return statearr_29146;
})();
if(cljs.core.truth_(inst_29078__$1)){
var statearr_29147_29182 = state_29118__$1;
(statearr_29147_29182[(1)] = (16));

} else {
var statearr_29148_29183 = state_29118__$1;
(statearr_29148_29183[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (16))){
var inst_29078 = (state_29118[(11)]);
var state_29118__$1 = state_29118;
var statearr_29149_29184 = state_29118__$1;
(statearr_29149_29184[(2)] = inst_29078);

(statearr_29149_29184[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (10))){
var inst_29067 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29118__$1 = state_29118;
var statearr_29151_29185 = state_29118__$1;
(statearr_29151_29185[(2)] = inst_29067);

(statearr_29151_29185[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (18))){
var inst_29084 = (state_29118[(2)]);
var state_29118__$1 = (function (){var statearr_29152 = state_29118;
(statearr_29152[(8)] = inst_29084);

return statearr_29152;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29153_29186 = state_29118__$1;
(statearr_29153_29186[(1)] = (19));

} else {
var statearr_29154_29187 = state_29118__$1;
(statearr_29154_29187[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29119 === (8))){
var _ = (function (){var statearr_29155 = state_29118;
(statearr_29155[(4)] = cljs.core.rest((state_29118[(4)])));

return statearr_29155;
})();
var state_29118__$1 = state_29118;
var ex29150 = (state_29118__$1[(2)]);
var statearr_29156_29188 = state_29118__$1;
(statearr_29156_29188[(5)] = ex29150);


var statearr_29157_29189 = state_29118__$1;
(statearr_29157_29189[(1)] = (7));

(statearr_29157_29189[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_29158 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29158[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_29158[(1)] = (1));

return statearr_29158;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_29118){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29118);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29159){var ex__2736__auto__ = e29159;
var statearr_29160_29190 = state_29118;
(statearr_29160_29190[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29118[(4)]))){
var statearr_29161_29191 = state_29118;
(statearr_29161_29191[(1)] = cljs.core.first((state_29118[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29192 = state_29118;
state_29118 = G__29192;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_29118){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_29118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29162 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29162[(6)] = c__2755__auto__);

return statearr_29162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29194 = arguments.length;
switch (G__29194) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29238){
var state_val_29239 = (state_29238[(1)]);
if((state_val_29239 === (7))){
var inst_29216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29217 = ["*"];
var inst_29218 = (new cljs.core.PersistentVector(null,1,(5),inst_29216,inst_29217,null));
var state_29238__$1 = state_29238;
var statearr_29240_29260 = state_29238__$1;
(statearr_29240_29260[(2)] = inst_29218);

(statearr_29240_29260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (1))){
var state_29238__$1 = state_29238;
var statearr_29241_29261 = state_29238__$1;
(statearr_29241_29261[(2)] = null);

(statearr_29241_29261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (4))){
var inst_29195 = (state_29238[(2)]);
var inst_29196 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29195,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29238__$1 = state_29238;
var statearr_29242_29262 = state_29238__$1;
(statearr_29242_29262[(2)] = inst_29196);

(statearr_29242_29262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (6))){
var inst_29208 = cljs.core.PersistentVector.EMPTY;
var inst_29209 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29210 = ["*"];
var inst_29211 = (new cljs.core.PersistentVector(null,1,(5),inst_29209,inst_29210,null));
var inst_29212 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29213 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29211,inst_29212);
var inst_29214 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29208,inst_29213);
var state_29238__$1 = state_29238;
var statearr_29243_29263 = state_29238__$1;
(statearr_29243_29263[(2)] = inst_29214);

(statearr_29243_29263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (3))){
var inst_29236 = (state_29238[(2)]);
var state_29238__$1 = state_29238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29238__$1,inst_29236);
} else {
if((state_val_29239 === (2))){
var _ = (function (){var statearr_29245 = state_29238;
(statearr_29245[(4)] = cljs.core.cons((5),(state_29238[(4)])));

return statearr_29245;
})();
var inst_29205 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29206 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29238__$1 = (function (){var statearr_29246 = state_29238;
(statearr_29246[(7)] = inst_29206);

(statearr_29246[(8)] = inst_29205);

return statearr_29246;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29247_29264 = state_29238__$1;
(statearr_29247_29264[(1)] = (6));

} else {
var statearr_29248_29265 = state_29238__$1;
(statearr_29248_29265[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (9))){
var inst_29227 = (state_29238[(2)]);
var inst_29228 = fluree.db.util.async.throw_err(inst_29227);
var inst_29229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29228,(0),null);
var inst_29230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29228,(1),null);
var inst_29231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29232 = [inst_29229,inst_29230];
var inst_29233 = (new cljs.core.PersistentVector(null,2,(5),inst_29231,inst_29232,null));
var _ = (function (){var statearr_29249 = state_29238;
(statearr_29249[(4)] = cljs.core.rest((state_29238[(4)])));

return statearr_29249;
})();
var state_29238__$1 = state_29238;
var statearr_29250_29266 = state_29238__$1;
(statearr_29250_29266[(2)] = inst_29233);

(statearr_29250_29266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (5))){
var _ = (function (){var statearr_29251 = state_29238;
(statearr_29251[(4)] = cljs.core.rest((state_29238[(4)])));

return statearr_29251;
})();
var state_29238__$1 = state_29238;
var ex29244 = (state_29238__$1[(2)]);
var statearr_29252_29267 = state_29238__$1;
(statearr_29252_29267[(5)] = ex29244);


var statearr_29253_29268 = state_29238__$1;
(statearr_29253_29268[(1)] = (4));

(statearr_29253_29268[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29239 === (8))){
var inst_29206 = (state_29238[(7)]);
var inst_29205 = (state_29238[(8)]);
var inst_29220 = (state_29238[(2)]);
var inst_29221 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29222 = cljs.core.PersistentHashMap.EMPTY;
var inst_29223 = [inst_29220,inst_29206,inst_29222];
var inst_29224 = cljs.core.PersistentHashMap.fromArrays(inst_29221,inst_29223);
var inst_29225 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29205,inst_29224);
var state_29238__$1 = state_29238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29238__$1,(9),inst_29225);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2733__auto____0 = (function (){
var statearr_29254 = [null,null,null,null,null,null,null,null,null];
(statearr_29254[(0)] = fluree$db$dbfunctions$internal$state_machine__2733__auto__);

(statearr_29254[(1)] = (1));

return statearr_29254;
});
var fluree$db$dbfunctions$internal$state_machine__2733__auto____1 = (function (state_29238){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29238);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29255){var ex__2736__auto__ = e29255;
var statearr_29256_29269 = state_29238;
(statearr_29256_29269[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29238[(4)]))){
var statearr_29257_29270 = state_29238;
(statearr_29257_29270[(1)] = cljs.core.first((state_29238[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29271 = state_29238;
state_29238 = G__29271;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2733__auto__ = function(state_29238){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2733__auto____1.call(this,state_29238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29258 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29258[(6)] = c__2755__auto__);

return statearr_29258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29315){
var state_val_29316 = (state_29315[(1)]);
if((state_val_29316 === (1))){
var state_29315__$1 = state_29315;
var statearr_29317_29331 = state_29315__$1;
(statearr_29317_29331[(2)] = null);

(statearr_29317_29331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29316 === (2))){
var _ = (function (){var statearr_29318 = state_29315;
(statearr_29318[(4)] = cljs.core.cons((5),(state_29315[(4)])));

return statearr_29318;
})();
var inst_29282 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29284 = ["_user/_auth"];
var inst_29285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29286 = ["*"];
var inst_29287 = (new cljs.core.PersistentVector(null,1,(5),inst_29285,inst_29286,null));
var inst_29288 = [inst_29287];
var inst_29289 = cljs.core.PersistentHashMap.fromArrays(inst_29284,inst_29288);
var inst_29290 = [inst_29289];
var inst_29291 = (new cljs.core.PersistentVector(null,1,(5),inst_29283,inst_29290,null));
var inst_29292 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29293 = cljs.core.PersistentHashMap.EMPTY;
var inst_29294 = [inst_29291,inst_29292,inst_29293];
var inst_29295 = cljs.core.PersistentHashMap.fromArrays(inst_29282,inst_29294);
var inst_29296 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29297 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29296,inst_29295);
var state_29315__$1 = state_29315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29315__$1,(6),inst_29297);
} else {
if((state_val_29316 === (3))){
var inst_29313 = (state_29315[(2)]);
var state_29315__$1 = state_29315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29315__$1,inst_29313);
} else {
if((state_val_29316 === (4))){
var inst_29272 = (state_29315[(2)]);
var inst_29273 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29272,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29315__$1 = state_29315;
var statearr_29320_29332 = state_29315__$1;
(statearr_29320_29332[(2)] = inst_29273);

(statearr_29320_29332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29316 === (5))){
var _ = (function (){var statearr_29321 = state_29315;
(statearr_29321[(4)] = cljs.core.rest((state_29315[(4)])));

return statearr_29321;
})();
var state_29315__$1 = state_29315;
var ex29319 = (state_29315__$1[(2)]);
var statearr_29322_29333 = state_29315__$1;
(statearr_29322_29333[(5)] = ex29319);


var statearr_29323_29334 = state_29315__$1;
(statearr_29323_29334[(1)] = (4));

(statearr_29323_29334[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29316 === (6))){
var inst_29299 = (state_29315[(2)]);
var inst_29300 = fluree.db.util.async.throw_err(inst_29299);
var inst_29301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29300,(0),null);
var inst_29302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29300,(1),null);
var inst_29303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29304 = ["_user/_auth","_id"];
var inst_29305 = (new cljs.core.PersistentVector(null,2,(5),inst_29303,inst_29304,null));
var inst_29306 = fluree.db.dbfunctions.internal.get_in(inst_29301,inst_29305);
var inst_29307 = cljs.core.first(inst_29306);
var inst_29308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29309 = [inst_29307,inst_29302];
var inst_29310 = (new cljs.core.PersistentVector(null,2,(5),inst_29308,inst_29309,null));
var _ = (function (){var statearr_29324 = state_29315;
(statearr_29324[(4)] = cljs.core.rest((state_29315[(4)])));

return statearr_29324;
})();
var state_29315__$1 = state_29315;
var statearr_29325_29335 = state_29315__$1;
(statearr_29325_29335[(2)] = inst_29310);

(statearr_29325_29335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____0 = (function (){
var statearr_29326 = [null,null,null,null,null,null,null];
(statearr_29326[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__);

(statearr_29326[(1)] = (1));

return statearr_29326;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____1 = (function (state_29315){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29315);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29327){var ex__2736__auto__ = e29327;
var statearr_29328_29336 = state_29315;
(statearr_29328_29336[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29315[(4)]))){
var statearr_29329_29337 = state_29315;
(statearr_29329_29337[(1)] = cljs.core.first((state_29315[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29338 = state_29315;
state_29315 = G__29338;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__ = function(state_29315){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____1.call(this,state_29315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29330 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29330[(6)] = c__2755__auto__);

return statearr_29330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29355){
var state_val_29356 = (state_29355[(1)]);
if((state_val_29356 === (1))){
var state_29355__$1 = state_29355;
var statearr_29357_29371 = state_29355__$1;
(statearr_29357_29371[(2)] = null);

(statearr_29357_29371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29356 === (2))){
var _ = (function (){var statearr_29358 = state_29355;
(statearr_29358[(4)] = cljs.core.cons((5),(state_29355[(4)])));

return statearr_29358;
})();
var inst_29345 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29346 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29347 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29346,inst_29345);
var state_29355__$1 = state_29355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29355__$1,(6),inst_29347);
} else {
if((state_val_29356 === (3))){
var inst_29353 = (state_29355[(2)]);
var state_29355__$1 = state_29355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29355__$1,inst_29353);
} else {
if((state_val_29356 === (4))){
var inst_29339 = (state_29355[(2)]);
var state_29355__$1 = state_29355;
var statearr_29360_29372 = state_29355__$1;
(statearr_29360_29372[(2)] = inst_29339);

(statearr_29360_29372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29356 === (5))){
var _ = (function (){var statearr_29361 = state_29355;
(statearr_29361[(4)] = cljs.core.rest((state_29355[(4)])));

return statearr_29361;
})();
var state_29355__$1 = state_29355;
var ex29359 = (state_29355__$1[(2)]);
var statearr_29362_29373 = state_29355__$1;
(statearr_29362_29373[(5)] = ex29359);


if((ex29359 instanceof Error)){
var statearr_29363_29374 = state_29355__$1;
(statearr_29363_29374[(1)] = (4));

(statearr_29363_29374[(5)] = null);

} else {
throw ex29359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29356 === (6))){
var inst_29349 = (state_29355[(2)]);
var inst_29350 = fluree.db.util.async.throw_err(inst_29349);
var _ = (function (){var statearr_29364 = state_29355;
(statearr_29364[(4)] = cljs.core.rest((state_29355[(4)])));

return statearr_29364;
})();
var state_29355__$1 = state_29355;
var statearr_29365_29375 = state_29355__$1;
(statearr_29365_29375[(2)] = inst_29350);

(statearr_29365_29375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____0 = (function (){
var statearr_29366 = [null,null,null,null,null,null,null];
(statearr_29366[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__);

(statearr_29366[(1)] = (1));

return statearr_29366;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____1 = (function (state_29355){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29355);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29367){var ex__2736__auto__ = e29367;
var statearr_29368_29376 = state_29355;
(statearr_29368_29376[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29355[(4)]))){
var statearr_29369_29377 = state_29355;
(statearr_29369_29377[(1)] = cljs.core.first((state_29355[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29378 = state_29355;
state_29355 = G__29378;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__ = function(state_29355){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____1.call(this,state_29355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29370 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29370[(6)] = c__2755__auto__);

return statearr_29370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29379_SHARP_){
return p1__29379_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29380_SHARP_){
return p1__29380_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29381){var e = e29381;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29382_SHARP_){
return p1__29382_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29383_SHARP_){
return p1__29383_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29384){var e = e29384;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29386 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29386);
})() | (0));
return num;
}catch (e29385){var e = e29385;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_29466){
var state_val_29467 = (state_29466[(1)]);
if((state_val_29467 === (7))){
var inst_29405 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29406 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29407 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29408 = cljs.core.PersistentHashMap.fromArrays(inst_29406,inst_29407);
var inst_29409 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29405,inst_29408);
var inst_29410 = (function(){throw inst_29409})();
var state_29466__$1 = state_29466;
var statearr_29468_29503 = state_29466__$1;
(statearr_29468_29503[(2)] = inst_29410);

(statearr_29468_29503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (1))){
var state_29466__$1 = state_29466;
var statearr_29469_29504 = state_29466__$1;
(statearr_29469_29504[(2)] = null);

(statearr_29469_29504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (4))){
var inst_29387 = (state_29466[(2)]);
var state_29466__$1 = state_29466;
var statearr_29470_29505 = state_29466__$1;
(statearr_29470_29505[(2)] = inst_29387);

(statearr_29470_29505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (15))){
var inst_29450 = (state_29466[(7)]);
var inst_29446 = (state_29466[(2)]);
var inst_29447 = fluree.db.util.async.throw_err(inst_29446);
var inst_29448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29447,(0),null);
var inst_29449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29447,(1),null);
var inst_29450__$1 = cljs.core.first(inst_29448);
var inst_29451 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29450__$1,compare_val);
var state_29466__$1 = (function (){var statearr_29471 = state_29466;
(statearr_29471[(8)] = inst_29449);

(statearr_29471[(7)] = inst_29450__$1);

return statearr_29471;
})();
if(inst_29451){
var statearr_29472_29506 = state_29466__$1;
(statearr_29472_29506[(1)] = (16));

} else {
var statearr_29473_29507 = state_29466__$1;
(statearr_29473_29507[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (13))){
var state_29466__$1 = state_29466;
var statearr_29474_29508 = state_29466__$1;
(statearr_29474_29508[(2)] = null);

(statearr_29474_29508[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (6))){
var state_29466__$1 = state_29466;
var statearr_29475_29509 = state_29466__$1;
(statearr_29475_29509[(2)] = null);

(statearr_29475_29509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (17))){
var inst_29450 = (state_29466[(7)]);
var inst_29454 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29450)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29455 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29456 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29457 = cljs.core.PersistentHashMap.fromArrays(inst_29455,inst_29456);
var inst_29458 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29454,inst_29457);
var inst_29459 = (function(){throw inst_29458})();
var state_29466__$1 = state_29466;
var statearr_29476_29510 = state_29466__$1;
(statearr_29476_29510[(2)] = inst_29459);

(statearr_29476_29510[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (3))){
var inst_29464 = (state_29466[(2)]);
var state_29466__$1 = state_29466;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29466__$1,inst_29464);
} else {
if((state_val_29467 === (12))){
var inst_29402 = (state_29466[(9)]);
var inst_29425 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29402], 0));
var inst_29426 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29427 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29428 = cljs.core.PersistentHashMap.fromArrays(inst_29426,inst_29427);
var inst_29429 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29425,inst_29428);
var inst_29430 = (function(){throw inst_29429})();
var state_29466__$1 = state_29466;
var statearr_29477_29511 = state_29466__$1;
(statearr_29477_29511[(2)] = inst_29430);

(statearr_29477_29511[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (2))){
var inst_29400 = (state_29466[(10)]);
var inst_29399 = (state_29466[(11)]);
var inst_29401 = (state_29466[(12)]);
var _ = (function (){var statearr_29478 = state_29466;
(statearr_29478[(4)] = cljs.core.cons((5),(state_29466[(4)])));

return statearr_29478;
})();
var inst_29397 = _QMARK_ctx;
var inst_29398 = cljs.core.__destructure_map(inst_29397);
var inst_29399__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29398,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29400__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29398,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29401__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29398,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29402 = fluree.db.dbproto._p_prop(inst_29401__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29400__$1);
var state_29466__$1 = (function (){var statearr_29479 = state_29466;
(statearr_29479[(10)] = inst_29400__$1);

(statearr_29479[(11)] = inst_29399__$1);

(statearr_29479[(12)] = inst_29401__$1);

(statearr_29479[(9)] = inst_29402);

return statearr_29479;
})();
if(cljs.core.truth_(inst_29399__$1)){
var statearr_29480_29512 = state_29466__$1;
(statearr_29480_29512[(1)] = (6));

} else {
var statearr_29481_29513 = state_29466__$1;
(statearr_29481_29513[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (11))){
var inst_29400 = (state_29466[(10)]);
var inst_29401 = (state_29466[(12)]);
var inst_29422 = (state_29466[(2)]);
var inst_29423 = fluree.db.dbproto._p_prop(inst_29401,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29400);
var state_29466__$1 = (function (){var statearr_29483 = state_29466;
(statearr_29483[(13)] = inst_29422);

return statearr_29483;
})();
if(cljs.core.truth_(inst_29423)){
var statearr_29484_29514 = state_29466__$1;
(statearr_29484_29514[(1)] = (12));

} else {
var statearr_29485_29515 = state_29466__$1;
(statearr_29485_29515[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (9))){
var state_29466__$1 = state_29466;
var statearr_29486_29516 = state_29466__$1;
(statearr_29486_29516[(2)] = null);

(statearr_29486_29516[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (5))){
var _ = (function (){var statearr_29487 = state_29466;
(statearr_29487[(4)] = cljs.core.rest((state_29466[(4)])));

return statearr_29487;
})();
var state_29466__$1 = state_29466;
var ex29482 = (state_29466__$1[(2)]);
var statearr_29488_29517 = state_29466__$1;
(statearr_29488_29517[(5)] = ex29482);


if((ex29482 instanceof Error)){
var statearr_29489_29518 = state_29466__$1;
(statearr_29489_29518[(1)] = (4));

(statearr_29489_29518[(5)] = null);

} else {
throw ex29482;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (14))){
var inst_29399 = (state_29466[(11)]);
var inst_29401 = (state_29466[(12)]);
var inst_29402 = (state_29466[(9)]);
var inst_29433 = (state_29466[(2)]);
var inst_29434 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29437 = [inst_29399,inst_29402,"?current-val"];
var inst_29438 = (new cljs.core.PersistentVector(null,3,(5),inst_29436,inst_29437,null));
var inst_29439 = [inst_29438];
var inst_29440 = (new cljs.core.PersistentVector(null,1,(5),inst_29435,inst_29439,null));
var inst_29441 = cljs.core.PersistentHashMap.EMPTY;
var inst_29442 = ["?current-val",inst_29440,inst_29441];
var inst_29443 = cljs.core.PersistentHashMap.fromArrays(inst_29434,inst_29442);
var inst_29444 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29401,inst_29443);
var state_29466__$1 = (function (){var statearr_29490 = state_29466;
(statearr_29490[(14)] = inst_29433);

return statearr_29490;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29466__$1,(15),inst_29444);
} else {
if((state_val_29467 === (16))){
var state_29466__$1 = state_29466;
var statearr_29491_29519 = state_29466__$1;
(statearr_29491_29519[(2)] = new_val);

(statearr_29491_29519[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (10))){
var inst_29415 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29416 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29417 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29418 = cljs.core.PersistentHashMap.fromArrays(inst_29416,inst_29417);
var inst_29419 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29415,inst_29418);
var inst_29420 = (function(){throw inst_29419})();
var state_29466__$1 = state_29466;
var statearr_29492_29520 = state_29466__$1;
(statearr_29492_29520[(2)] = inst_29420);

(statearr_29492_29520[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (18))){
var inst_29461 = (state_29466[(2)]);
var _ = (function (){var statearr_29493 = state_29466;
(statearr_29493[(4)] = cljs.core.rest((state_29466[(4)])));

return statearr_29493;
})();
var state_29466__$1 = state_29466;
var statearr_29494_29521 = state_29466__$1;
(statearr_29494_29521[(2)] = inst_29461);

(statearr_29494_29521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29467 === (8))){
var inst_29402 = (state_29466[(9)]);
var inst_29412 = (state_29466[(2)]);
var state_29466__$1 = (function (){var statearr_29495 = state_29466;
(statearr_29495[(15)] = inst_29412);

return statearr_29495;
})();
if(cljs.core.truth_(inst_29402)){
var statearr_29496_29522 = state_29466__$1;
(statearr_29496_29522[(1)] = (9));

} else {
var statearr_29497_29523 = state_29466__$1;
(statearr_29497_29523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____0 = (function (){
var statearr_29498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29498[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__);

(statearr_29498[(1)] = (1));

return statearr_29498;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____1 = (function (state_29466){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_29466);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e29499){var ex__2736__auto__ = e29499;
var statearr_29500_29524 = state_29466;
(statearr_29500_29524[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_29466[(4)]))){
var statearr_29501_29525 = state_29466;
(statearr_29501_29525[(1)] = cljs.core.first((state_29466[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29526 = state_29466;
state_29466 = G__29526;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__ = function(state_29466){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____1.call(this,state_29466);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_29502 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_29502[(6)] = c__2755__auto__);

return statearr_29502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
