// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26317 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26317,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26317,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26317,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26320){
var map__26321 = p__26320;
var map__26321__$1 = cljs.core.__destructure_map(map__26321);
var opts = map__26321__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26321__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26381){
var state_val_26382 = (state_26381[(1)]);
if((state_val_26382 === (7))){
var inst_26352 = cljs.core.not(reindex_QMARK_);
var state_26381__$1 = state_26381;
var statearr_26383_26407 = state_26381__$1;
(statearr_26383_26407[(2)] = inst_26352);

(statearr_26383_26407[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (1))){
var state_26381__$1 = state_26381;
var statearr_26384_26408 = state_26381__$1;
(statearr_26384_26408[(2)] = null);

(statearr_26384_26408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (4))){
var inst_26322 = (state_26381[(2)]);
var state_26381__$1 = state_26381;
var statearr_26385_26409 = state_26381__$1;
(statearr_26385_26409[(2)] = inst_26322);

(statearr_26385_26409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (6))){
var inst_26342 = (state_26381[(7)]);
var inst_26350 = (state_26381[(8)]);
var inst_26336 = (state_26381[(9)]);
var inst_26335 = (state_26381[(2)]);
var inst_26336__$1 = fluree.db.util.async.throw_err(inst_26335);
var inst_26337 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26338 = cljs.core.__destructure_map(inst_26337);
var inst_26339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26338,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26338,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26341 = fluree.db.flake.size_bytes(inst_26336__$1);
var inst_26342__$1 = (inst_26340 + inst_26341);
var inst_26343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26344 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26345 = (new cljs.core.PersistentVector(null,2,(5),inst_26343,inst_26344,null));
var inst_26346 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26345);
var inst_26347 = cljs.core.__destructure_map(inst_26346);
var inst_26348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26347,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26349 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26347,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26350__$1 = (inst_26342__$1 > inst_26349);
var state_26381__$1 = (function (){var statearr_26386 = state_26381;
(statearr_26386[(10)] = inst_26348);

(statearr_26386[(7)] = inst_26342__$1);

(statearr_26386[(8)] = inst_26350__$1);

(statearr_26386[(9)] = inst_26336__$1);

(statearr_26386[(11)] = inst_26339);

return statearr_26386;
})();
if(cljs.core.truth_(inst_26350__$1)){
var statearr_26387_26410 = state_26381__$1;
(statearr_26387_26410[(1)] = (7));

} else {
var statearr_26388_26411 = state_26381__$1;
(statearr_26388_26411[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (3))){
var inst_26379 = (state_26381[(2)]);
var state_26381__$1 = state_26381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26381__$1,inst_26379);
} else {
if((state_val_26382 === (12))){
var inst_26342 = (state_26381[(7)]);
var inst_26336 = (state_26381[(9)]);
var inst_26339 = (state_26381[(11)]);
var inst_26365 = (state_26381[(2)]);
var inst_26366 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26339,inst_26336);
var inst_26367 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26368 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_26367,cljs.core.empty);
var inst_26369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26370 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26371 = (new cljs.core.PersistentVector(null,2,(5),inst_26369,inst_26370,null));
var inst_26372 = cljs.core.assoc_in(db,inst_26371,inst_26366);
var inst_26373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26374 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26375 = (new cljs.core.PersistentVector(null,2,(5),inst_26373,inst_26374,null));
var inst_26376 = cljs.core.assoc_in(inst_26372,inst_26375,inst_26342);
var _ = (function (){var statearr_26389 = state_26381;
(statearr_26389[(4)] = cljs.core.rest((state_26381[(4)])));

return statearr_26389;
})();
var state_26381__$1 = (function (){var statearr_26390 = state_26381;
(statearr_26390[(12)] = inst_26368);

(statearr_26390[(13)] = inst_26365);

return statearr_26390;
})();
var statearr_26391_26412 = state_26381__$1;
(statearr_26391_26412[(2)] = inst_26376);

(statearr_26391_26412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (2))){
var _ = (function (){var statearr_26392 = state_26381;
(statearr_26392[(4)] = cljs.core.cons((5),(state_26381[(4)])));

return statearr_26392;
})();
var inst_26330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26331 = [pred_id];
var inst_26332 = (new cljs.core.PersistentVector(null,1,(5),inst_26330,inst_26331,null));
var inst_26333 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26332);
var state_26381__$1 = state_26381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26381__$1,(6),inst_26333);
} else {
if((state_val_26382 === (11))){
var state_26381__$1 = state_26381;
var statearr_26394_26413 = state_26381__$1;
(statearr_26394_26413[(2)] = null);

(statearr_26394_26413[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (9))){
var inst_26355 = (state_26381[(2)]);
var state_26381__$1 = state_26381;
if(cljs.core.truth_(inst_26355)){
var statearr_26395_26414 = state_26381__$1;
(statearr_26395_26414[(1)] = (10));

} else {
var statearr_26396_26415 = state_26381__$1;
(statearr_26396_26415[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (5))){
var _ = (function (){var statearr_26397 = state_26381;
(statearr_26397[(4)] = cljs.core.rest((state_26381[(4)])));

return statearr_26397;
})();
var state_26381__$1 = state_26381;
var ex26393 = (state_26381__$1[(2)]);
var statearr_26398_26416 = state_26381__$1;
(statearr_26398_26416[(5)] = ex26393);


if((ex26393 instanceof Error)){
var statearr_26399_26417 = state_26381__$1;
(statearr_26399_26417[(1)] = (4));

(statearr_26399_26417[(5)] = null);

} else {
throw ex26393;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (10))){
var inst_26357 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26358 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26359 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26360 = cljs.core.PersistentHashMap.fromArrays(inst_26358,inst_26359);
var inst_26361 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26357,inst_26360);
var inst_26362 = (function(){throw inst_26361})();
var state_26381__$1 = state_26381;
var statearr_26400_26418 = state_26381__$1;
(statearr_26400_26418[(2)] = inst_26362);

(statearr_26400_26418[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26382 === (8))){
var inst_26350 = (state_26381[(8)]);
var state_26381__$1 = state_26381;
var statearr_26401_26419 = state_26381__$1;
(statearr_26401_26419[(2)] = inst_26350);

(statearr_26401_26419[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____0 = (function (){
var statearr_26402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26402[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__);

(statearr_26402[(1)] = (1));

return statearr_26402;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____1 = (function (state_26381){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26381);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26403){var ex__2736__auto__ = e26403;
var statearr_26404_26420 = state_26381;
(statearr_26404_26420[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26381[(4)]))){
var statearr_26405_26421 = state_26381;
(statearr_26405_26421[(1)] = cljs.core.first((state_26381[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26422 = state_26381;
state_26381 = G__26422;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__ = function(state_26381){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____1.call(this,state_26381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26406 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26406[(6)] = c__2755__auto__);

return statearr_26406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26427 = arguments.length;
switch (G__26427) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26623){
var state_val_26624 = (state_26623[(1)]);
if((state_val_26624 === (7))){
var state_26623__$1 = state_26623;
var statearr_26625_26693 = state_26623__$1;
(statearr_26625_26693[(2)] = null);

(statearr_26625_26693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (20))){
var inst_26466 = (state_26623[(7)]);
var inst_26545 = (state_26623[(8)]);
var inst_26547 = (state_26623[(9)]);
var inst_26516 = (state_26623[(10)]);
var inst_26549 = (state_26623[(11)]);
var inst_26548 = (state_26623[(12)]);
var inst_26465 = (state_26623[(13)]);
var inst_26546 = (state_26623[(14)]);
var inst_26559 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26561 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26562 = (new cljs.core.PersistentVector(null,2,(5),inst_26560,inst_26561,null));
var inst_26563 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26516,inst_26562);
var inst_26564 = (inst_26465 + inst_26563);
var inst_26565 = [inst_26545,inst_26546,inst_26547,inst_26548,inst_26564];
var inst_26566 = cljs.core.PersistentHashMap.fromArrays(inst_26559,inst_26565);
var inst_26567 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26516,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26549,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26566], 0));
var state_26623__$1 = (function (){var statearr_26626 = state_26623;
(statearr_26626[(15)] = inst_26567);

return statearr_26626;
})();
if(cljs.core.truth_(inst_26466)){
var statearr_26627_26694 = state_26623__$1;
(statearr_26627_26694[(1)] = (23));

} else {
var statearr_26628_26695 = state_26623__$1;
(statearr_26628_26695[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (27))){
var inst_26567 = (state_26623[(15)]);
var state_26623__$1 = state_26623;
var statearr_26629_26696 = state_26623__$1;
(statearr_26629_26696[(2)] = inst_26567);

(statearr_26629_26696[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (1))){
var state_26623__$1 = state_26623;
var statearr_26630_26697 = state_26623__$1;
(statearr_26630_26697[(2)] = null);

(statearr_26630_26697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (24))){
var inst_26567 = (state_26623[(15)]);
var inst_26570 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26567);
var inst_26571 = (inst_26570 == null);
var state_26623__$1 = state_26623;
var statearr_26631_26698 = state_26623__$1;
(statearr_26631_26698[(2)] = inst_26571);

(statearr_26631_26698[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (39))){
var inst_26606 = (state_26623[(16)]);
var inst_26556 = (state_26623[(17)]);
var inst_26598 = (state_26623[(18)]);
var inst_26597 = (state_26623[(19)]);
var inst_26599 = (state_26623[(20)]);
var inst_26613 = (state_26623[(2)]);
var inst_26544 = inst_26556;
var inst_26545 = inst_26598;
var inst_26546 = inst_26599;
var inst_26547 = inst_26606;
var inst_26548 = inst_26613;
var inst_26549 = inst_26597;
var state_26623__$1 = (function (){var statearr_26632 = state_26623;
(statearr_26632[(21)] = inst_26544);

(statearr_26632[(8)] = inst_26545);

(statearr_26632[(9)] = inst_26547);

(statearr_26632[(11)] = inst_26549);

(statearr_26632[(12)] = inst_26548);

(statearr_26632[(14)] = inst_26546);

return statearr_26632;
})();
var statearr_26633_26699 = state_26623__$1;
(statearr_26633_26699[(2)] = null);

(statearr_26633_26699[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (4))){
var inst_26428 = (state_26623[(2)]);
var state_26623__$1 = state_26623;
var statearr_26634_26700 = state_26623__$1;
(statearr_26634_26700[(2)] = inst_26428);

(statearr_26634_26700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (15))){
var inst_26488 = (state_26623[(22)]);
var state_26623__$1 = state_26623;
var statearr_26635_26701 = state_26623__$1;
(statearr_26635_26701[(2)] = inst_26488);

(statearr_26635_26701[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (21))){
var inst_26469 = (state_26623[(23)]);
var inst_26460 = (state_26623[(24)]);
var inst_26464 = (state_26623[(25)]);
var inst_26450 = (state_26623[(26)]);
var inst_26556 = (state_26623[(17)]);
var inst_26525 = (state_26623[(27)]);
var inst_26526 = (state_26623[(28)]);
var inst_26544 = (state_26623[(21)]);
var inst_26466 = (state_26623[(7)]);
var inst_26545 = (state_26623[(8)]);
var inst_26475 = (state_26623[(29)]);
var inst_26555 = (state_26623[(30)]);
var inst_26547 = (state_26623[(9)]);
var inst_26456 = (state_26623[(31)]);
var inst_26452 = (state_26623[(32)]);
var inst_26516 = (state_26623[(10)]);
var inst_26435 = (state_26623[(33)]);
var inst_26549 = (state_26623[(11)]);
var inst_26548 = (state_26623[(12)]);
var inst_26467 = (state_26623[(34)]);
var inst_26465 = (state_26623[(13)]);
var inst_26546 = (state_26623[(14)]);
var inst_26594 = inst_26555.s;
var inst_26595 = fluree.db.flake.sid__GT_cid(inst_26594);
var inst_26596 = (function (){var flakes_bytes = inst_26465;
var t = inst_26435;
var spot = inst_26545;
var add_flakes = inst_26452;
var first__26553 = inst_26555;
var root_setting_change_QMARK_ = inst_26467;
var G__26520 = inst_26544;
var vec__26521 = inst_26452;
var ref_QMARK__map = inst_26464;
var r = inst_26556;
var psot = inst_26546;
var add_pred_to_idx_QMARK_ = inst_26475;
var _ = inst_26450;
var cid = inst_26595;
var ecount = inst_26549;
var vec__26551 = inst_26544;
var pred_ecount = inst_26469;
var seq__26522 = inst_26526;
var first__26523 = inst_26525;
var db_STAR_ = inst_26516;
var schema_change_QMARK_ = inst_26466;
var add_preds = inst_26456;
var opst = inst_26548;
var idx_QMARK__map = inst_26460;
var seq__26552 = inst_26556;
var post = inst_26547;
var f = inst_26555;
return (function (p1__26425_SHARP_){
if(cljs.core.truth_(p1__26425_SHARP_)){
var x__4306__auto__ = p1__26425_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_26597 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26549,inst_26595,inst_26596);
var inst_26598 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26545,inst_26555);
var inst_26599 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26546,inst_26555);
var inst_26600 = inst_26555.p;
var inst_26601 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26460,inst_26600);
var state_26623__$1 = (function (){var statearr_26636 = state_26623;
(statearr_26636[(18)] = inst_26598);

(statearr_26636[(19)] = inst_26597);

(statearr_26636[(20)] = inst_26599);

return statearr_26636;
})();
if(cljs.core.truth_(inst_26601)){
var statearr_26637_26702 = state_26623__$1;
(statearr_26637_26702[(1)] = (34));

} else {
var statearr_26638_26703 = state_26623__$1;
(statearr_26638_26703[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (31))){
var inst_26582 = (state_26623[(35)]);
var state_26623__$1 = state_26623;
var statearr_26639_26704 = state_26623__$1;
(statearr_26639_26704[(2)] = inst_26582);

(statearr_26639_26704[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (32))){
var inst_26592 = (state_26623[(2)]);
var state_26623__$1 = state_26623;
var statearr_26640_26705 = state_26623__$1;
(statearr_26640_26705[(2)] = inst_26592);

(statearr_26640_26705[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (33))){
var inst_26582 = (state_26623[(35)]);
var inst_26587 = (state_26623[(2)]);
var inst_26588 = fluree.db.util.async.throw_err(inst_26587);
var inst_26589 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26582,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26588);
var state_26623__$1 = state_26623;
var statearr_26641_26706 = state_26623__$1;
(statearr_26641_26706[(2)] = inst_26589);

(statearr_26641_26706[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (13))){
var inst_26452 = (state_26623[(32)]);
var inst_26516 = (state_26623[(10)]);
var inst_26435 = (state_26623[(33)]);
var inst_26465 = (state_26623[(13)]);
var inst_26506 = (state_26623[(2)]);
var inst_26507 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26506,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26435);
var inst_26508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26509 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26510 = (new cljs.core.PersistentVector(null,2,(5),inst_26508,inst_26509,null));
var inst_26511 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26507,inst_26510,cljs.core._PLUS_,inst_26465);
var inst_26512 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26513 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26514 = (new cljs.core.PersistentVector(null,2,(5),inst_26512,inst_26513,null));
var inst_26515 = cljs.core.count(inst_26452);
var inst_26516__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26511,inst_26514,cljs.core._PLUS_,inst_26515);
var inst_26524 = cljs.core.seq(inst_26452);
var inst_26525 = cljs.core.first(inst_26524);
var inst_26526 = cljs.core.next(inst_26524);
var inst_26527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26528 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26529 = (new cljs.core.PersistentVector(null,2,(5),inst_26527,inst_26528,null));
var inst_26530 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26516__$1,inst_26529);
var inst_26531 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26532 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26533 = (new cljs.core.PersistentVector(null,2,(5),inst_26531,inst_26532,null));
var inst_26534 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26516__$1,inst_26533);
var inst_26535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26536 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26537 = (new cljs.core.PersistentVector(null,2,(5),inst_26535,inst_26536,null));
var inst_26538 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26516__$1,inst_26537);
var inst_26539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26540 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26541 = (new cljs.core.PersistentVector(null,2,(5),inst_26539,inst_26540,null));
var inst_26542 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26516__$1,inst_26541);
var inst_26543 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26544 = inst_26452;
var inst_26545 = inst_26530;
var inst_26546 = inst_26534;
var inst_26547 = inst_26538;
var inst_26548 = inst_26542;
var inst_26549 = inst_26543;
var state_26623__$1 = (function (){var statearr_26642 = state_26623;
(statearr_26642[(27)] = inst_26525);

(statearr_26642[(28)] = inst_26526);

(statearr_26642[(21)] = inst_26544);

(statearr_26642[(8)] = inst_26545);

(statearr_26642[(9)] = inst_26547);

(statearr_26642[(10)] = inst_26516__$1);

(statearr_26642[(11)] = inst_26549);

(statearr_26642[(12)] = inst_26548);

(statearr_26642[(14)] = inst_26546);

return statearr_26642;
})();
var statearr_26643_26707 = state_26623__$1;
(statearr_26643_26707[(2)] = null);

(statearr_26643_26707[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (22))){
var inst_26616 = (state_26623[(2)]);
var state_26623__$1 = state_26623;
var statearr_26644_26708 = state_26623__$1;
(statearr_26644_26708[(2)] = inst_26616);

(statearr_26644_26708[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (36))){
var inst_26464 = (state_26623[(25)]);
var inst_26555 = (state_26623[(30)]);
var inst_26606 = (state_26623[(2)]);
var inst_26607 = inst_26555.p;
var inst_26608 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26464,inst_26607);
var state_26623__$1 = (function (){var statearr_26645 = state_26623;
(statearr_26645[(16)] = inst_26606);

return statearr_26645;
})();
if(cljs.core.truth_(inst_26608)){
var statearr_26646_26709 = state_26623__$1;
(statearr_26646_26709[(1)] = (37));

} else {
var statearr_26647_26710 = state_26623__$1;
(statearr_26647_26710[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (29))){
var inst_26567 = (state_26623[(15)]);
var inst_26577 = (state_26623[(2)]);
var inst_26578 = fluree.db.util.async.throw_err(inst_26577);
var inst_26579 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26567,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26578);
var state_26623__$1 = state_26623;
var statearr_26648_26711 = state_26623__$1;
(statearr_26648_26711[(2)] = inst_26579);

(statearr_26648_26711[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (6))){
var inst_26435 = (state_26623[(33)]);
var inst_26440 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26441 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26442 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26440)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26441)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26435),"."].join('');
var inst_26443 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26444 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26445 = cljs.core.PersistentHashMap.fromArrays(inst_26443,inst_26444);
var inst_26446 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26442,inst_26445);
var inst_26447 = (function(){throw inst_26446})();
var state_26623__$1 = state_26623;
var statearr_26649_26712 = state_26623__$1;
(statearr_26649_26712[(2)] = inst_26447);

(statearr_26649_26712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (28))){
var inst_26467 = (state_26623[(34)]);
var inst_26582 = (state_26623[(2)]);
var state_26623__$1 = (function (){var statearr_26650 = state_26623;
(statearr_26650[(35)] = inst_26582);

return statearr_26650;
})();
if(cljs.core.truth_(inst_26467)){
var statearr_26651_26713 = state_26623__$1;
(statearr_26651_26713[(1)] = (30));

} else {
var statearr_26652_26714 = state_26623__$1;
(statearr_26652_26714[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (25))){
var inst_26573 = (state_26623[(2)]);
var state_26623__$1 = state_26623;
if(cljs.core.truth_(inst_26573)){
var statearr_26653_26715 = state_26623__$1;
(statearr_26653_26715[(1)] = (26));

} else {
var statearr_26654_26716 = state_26623__$1;
(statearr_26654_26716[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (34))){
var inst_26555 = (state_26623[(30)]);
var inst_26547 = (state_26623[(9)]);
var inst_26603 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26547,inst_26555);
var state_26623__$1 = state_26623;
var statearr_26655_26717 = state_26623__$1;
(statearr_26655_26717[(2)] = inst_26603);

(statearr_26655_26717[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (17))){
var inst_26495 = (state_26623[(36)]);
var inst_26499 = (state_26623[(2)]);
var inst_26500 = fluree.db.util.async.throw_err(inst_26499);
var inst_26487 = inst_26495;
var inst_26488 = inst_26500;
var state_26623__$1 = (function (){var statearr_26656 = state_26623;
(statearr_26656[(37)] = inst_26487);

(statearr_26656[(22)] = inst_26488);

return statearr_26656;
})();
var statearr_26657_26718 = state_26623__$1;
(statearr_26657_26718[(2)] = null);

(statearr_26657_26718[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (3))){
var inst_26621 = (state_26623[(2)]);
var state_26623__$1 = state_26623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26623__$1,inst_26621);
} else {
if((state_val_26624 === (12))){
var inst_26487 = (state_26623[(37)]);
var inst_26494 = (state_26623[(38)]);
var inst_26493 = cljs.core.seq(inst_26487);
var inst_26494__$1 = cljs.core.first(inst_26493);
var inst_26495 = cljs.core.next(inst_26493);
var state_26623__$1 = (function (){var statearr_26658 = state_26623;
(statearr_26658[(36)] = inst_26495);

(statearr_26658[(38)] = inst_26494__$1);

return statearr_26658;
})();
if(cljs.core.truth_(inst_26494__$1)){
var statearr_26659_26719 = state_26623__$1;
(statearr_26659_26719[(1)] = (14));

} else {
var statearr_26660_26720 = state_26623__$1;
(statearr_26660_26720[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (2))){
var inst_26435 = (state_26623[(33)]);
var _ = (function (){var statearr_26661 = state_26623;
(statearr_26661[(4)] = cljs.core.cons((5),(state_26623[(4)])));

return statearr_26661;
})();
var inst_26434 = cljs.core.first(flakes);
var inst_26435__$1 = inst_26434.t;
var inst_26436 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26437 = (inst_26436 - (1));
var inst_26438 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26435__$1,inst_26437);
var state_26623__$1 = (function (){var statearr_26662 = state_26623;
(statearr_26662[(33)] = inst_26435__$1);

return statearr_26662;
})();
if(inst_26438){
var statearr_26663_26721 = state_26623__$1;
(statearr_26663_26721[(1)] = (6));

} else {
var statearr_26664_26722 = state_26623__$1;
(statearr_26664_26722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (23))){
var inst_26466 = (state_26623[(7)]);
var state_26623__$1 = state_26623;
var statearr_26665_26723 = state_26623__$1;
(statearr_26665_26723[(2)] = inst_26466);

(statearr_26665_26723[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (35))){
var inst_26547 = (state_26623[(9)]);
var state_26623__$1 = state_26623;
var statearr_26666_26724 = state_26623__$1;
(statearr_26666_26724[(2)] = inst_26547);

(statearr_26666_26724[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (19))){
var inst_26618 = (state_26623[(2)]);
var _ = (function (){var statearr_26667 = state_26623;
(statearr_26667[(4)] = cljs.core.rest((state_26623[(4)])));

return statearr_26667;
})();
var state_26623__$1 = state_26623;
var statearr_26668_26725 = state_26623__$1;
(statearr_26668_26725[(2)] = inst_26618);

(statearr_26668_26725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (11))){
var inst_26475 = (state_26623[(29)]);
var inst_26475__$1 = (state_26623[(2)]);
var inst_26483 = cljs.core.seq(inst_26475__$1);
var inst_26484 = cljs.core.first(inst_26483);
var inst_26485 = cljs.core.next(inst_26483);
var inst_26486 = db;
var inst_26487 = inst_26475__$1;
var inst_26488 = inst_26486;
var state_26623__$1 = (function (){var statearr_26670 = state_26623;
(statearr_26670[(37)] = inst_26487);

(statearr_26670[(39)] = inst_26485);

(statearr_26670[(40)] = inst_26484);

(statearr_26670[(29)] = inst_26475__$1);

(statearr_26670[(22)] = inst_26488);

return statearr_26670;
})();
var statearr_26671_26726 = state_26623__$1;
(statearr_26671_26726[(2)] = null);

(statearr_26671_26726[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (9))){
var inst_26469 = (state_26623[(23)]);
var inst_26452 = (state_26623[(32)]);
var inst_26471 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26452,inst_26469);
var state_26623__$1 = state_26623;
var statearr_26672_26727 = state_26623__$1;
(statearr_26672_26727[(2)] = inst_26471);

(statearr_26672_26727[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (5))){
var _ = (function (){var statearr_26673 = state_26623;
(statearr_26673[(4)] = cljs.core.rest((state_26623[(4)])));

return statearr_26673;
})();
var state_26623__$1 = state_26623;
var ex26669 = (state_26623__$1[(2)]);
var statearr_26674_26728 = state_26623__$1;
(statearr_26674_26728[(5)] = ex26669);


if((ex26669 instanceof Error)){
var statearr_26675_26729 = state_26623__$1;
(statearr_26675_26729[(1)] = (4));

(statearr_26675_26729[(5)] = null);

} else {
throw ex26669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (14))){
var inst_26494 = (state_26623[(38)]);
var inst_26488 = (state_26623[(22)]);
var inst_26497 = fluree.db.graphdb.add_predicate_to_idx(inst_26488,inst_26494,opts);
var state_26623__$1 = state_26623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26623__$1,(17),inst_26497);
} else {
if((state_val_26624 === (26))){
var inst_26567 = (state_26623[(15)]);
var inst_26575 = fluree.db.query.schema.schema_map(inst_26567);
var state_26623__$1 = state_26623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26623__$1,(29),inst_26575);
} else {
if((state_val_26624 === (16))){
var inst_26504 = (state_26623[(2)]);
var state_26623__$1 = state_26623;
var statearr_26676_26730 = state_26623__$1;
(statearr_26676_26730[(2)] = inst_26504);

(statearr_26676_26730[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (38))){
var inst_26548 = (state_26623[(12)]);
var state_26623__$1 = state_26623;
var statearr_26677_26731 = state_26623__$1;
(statearr_26677_26731[(2)] = inst_26548);

(statearr_26677_26731[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (30))){
var inst_26582 = (state_26623[(35)]);
var inst_26585 = fluree.db.query.schema.setting_map(inst_26582);
var state_26623__$1 = state_26623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26623__$1,(33),inst_26585);
} else {
if((state_val_26624 === (10))){
var inst_26473 = cljs.core.PersistentVector.EMPTY;
var state_26623__$1 = state_26623;
var statearr_26678_26732 = state_26623__$1;
(statearr_26678_26732[(2)] = inst_26473);

(statearr_26678_26732[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (18))){
var inst_26544 = (state_26623[(21)]);
var inst_26555 = (state_26623[(30)]);
var inst_26554 = cljs.core.seq(inst_26544);
var inst_26555__$1 = cljs.core.first(inst_26554);
var inst_26556 = cljs.core.next(inst_26554);
var inst_26557 = cljs.core.not(inst_26555__$1);
var state_26623__$1 = (function (){var statearr_26679 = state_26623;
(statearr_26679[(17)] = inst_26556);

(statearr_26679[(30)] = inst_26555__$1);

return statearr_26679;
})();
if(inst_26557){
var statearr_26680_26733 = state_26623__$1;
(statearr_26680_26733[(1)] = (20));

} else {
var statearr_26681_26734 = state_26623__$1;
(statearr_26681_26734[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (37))){
var inst_26555 = (state_26623[(30)]);
var inst_26548 = (state_26623[(12)]);
var inst_26610 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26548,inst_26555);
var state_26623__$1 = state_26623;
var statearr_26682_26735 = state_26623__$1;
(statearr_26682_26735[(2)] = inst_26610);

(statearr_26682_26735[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26624 === (8))){
var inst_26460 = (state_26623[(24)]);
var inst_26450 = (state_26623[(26)]);
var inst_26466 = (state_26623[(7)]);
var inst_26456 = (state_26623[(31)]);
var inst_26452 = (state_26623[(32)]);
var inst_26435 = (state_26623[(33)]);
var inst_26450__$1 = (state_26623[(2)]);
var inst_26451 = (function (){var t = inst_26435;
var _ = inst_26450__$1;
return (function (p1__26423_SHARP_){
return cljs.core.not((function (){var G__26683 = p1__26423_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__26683) : fluree.db.graphdb.exclude_predicates.call(null,G__26683));
})());
});
})();
var inst_26452__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26451,flakes);
var inst_26453 = cljs.core.PersistentHashSet.EMPTY;
var inst_26454 = (function (){var t = inst_26435;
var _ = inst_26450__$1;
var add_flakes = inst_26452__$1;
return (function (p1__26424_SHARP_){
return p1__26424_SHARP_.p;
});
})();
var inst_26455 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26454,inst_26452__$1);
var inst_26456__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26453,inst_26455);
var inst_26457 = cljs.core.PersistentHashMap.EMPTY;
var inst_26458 = (function (){var t = inst_26435;
var _ = inst_26450__$1;
var add_flakes = inst_26452__$1;
var add_preds = inst_26456__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26459 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26458,inst_26456__$1);
var inst_26460__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26457,inst_26459);
var inst_26461 = cljs.core.PersistentHashMap.EMPTY;
var inst_26462 = (function (){var t = inst_26435;
var _ = inst_26450__$1;
var add_flakes = inst_26452__$1;
var add_preds = inst_26456__$1;
var idx_QMARK__map = inst_26460__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26463 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26462,inst_26456__$1);
var inst_26464 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26461,inst_26463);
var inst_26465 = fluree.db.flake.size_bytes(inst_26452__$1);
var inst_26466__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_26452__$1);
var inst_26467 = fluree.db.util.schema.setting_change_QMARK_(inst_26452__$1);
var inst_26468 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26469 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26468,(0));
var state_26623__$1 = (function (){var statearr_26684 = state_26623;
(statearr_26684[(23)] = inst_26469);

(statearr_26684[(24)] = inst_26460__$1);

(statearr_26684[(25)] = inst_26464);

(statearr_26684[(26)] = inst_26450__$1);

(statearr_26684[(7)] = inst_26466__$1);

(statearr_26684[(31)] = inst_26456__$1);

(statearr_26684[(32)] = inst_26452__$1);

(statearr_26684[(34)] = inst_26467);

(statearr_26684[(13)] = inst_26465);

return statearr_26684;
})();
if(cljs.core.truth_(inst_26466__$1)){
var statearr_26685_26736 = state_26623__$1;
(statearr_26685_26736[(1)] = (9));

} else {
var statearr_26686_26737 = state_26623__$1;
(statearr_26686_26737[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_26687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26687[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_26687[(1)] = (1));

return statearr_26687;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_26623){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26623);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26688){var ex__2736__auto__ = e26688;
var statearr_26689_26738 = state_26623;
(statearr_26689_26738[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26623[(4)]))){
var statearr_26690_26739 = state_26623;
(statearr_26690_26739[(1)] = cljs.core.first((state_26623[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26740 = state_26623;
state_26623 = G__26740;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_26623){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_26623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26691 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26691[(6)] = c__2755__auto__);

return statearr_26691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26742 = arguments.length;
switch (G__26742) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___26889 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26838){
var state_val_26839 = (state_26838[(1)]);
if((state_val_26839 === (7))){
var state_26838__$1 = state_26838;
var statearr_26840_26890 = state_26838__$1;
(statearr_26840_26890[(2)] = null);

(statearr_26840_26890[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (20))){
var inst_26787 = (state_26838[(7)]);
var inst_26786 = (state_26838[(8)]);
var inst_26788 = (state_26838[(9)]);
var inst_26807 = (inst_26786 + (1));
var inst_26808 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26788,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26807);
var inst_26809 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_26808,inst_26787,opts);
var state_26838__$1 = state_26838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26838__$1,(23),inst_26809);
} else {
if((state_val_26839 === (1))){
var state_26838__$1 = state_26838;
var statearr_26841_26891 = state_26838__$1;
(statearr_26841_26891[(2)] = null);

(statearr_26841_26891[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (24))){
var inst_26812 = (state_26838[(10)]);
var inst_26815 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26812,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26838__$1 = state_26838;
var statearr_26842_26892 = state_26838__$1;
(statearr_26842_26892[(2)] = inst_26815);

(statearr_26842_26892[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (4))){
var inst_26743 = (state_26838[(2)]);
var inst_26744 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26743);
var state_26838__$1 = state_26838;
var statearr_26843_26893 = state_26838__$1;
(statearr_26843_26893[(2)] = inst_26744);

(statearr_26843_26893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (15))){
var inst_26794 = (state_26838[(11)]);
var state_26838__$1 = state_26838;
var statearr_26844_26894 = state_26838__$1;
(statearr_26844_26894[(2)] = inst_26794);

(statearr_26844_26894[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (21))){
var state_26838__$1 = state_26838;
var statearr_26845_26895 = state_26838__$1;
(statearr_26845_26895[(2)] = null);

(statearr_26845_26895[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (13))){
var inst_26830 = (state_26838[(2)]);
var inst_26831 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26830);
var state_26838__$1 = state_26838;
var statearr_26846_26896 = state_26838__$1;
(statearr_26846_26896[(2)] = inst_26831);

(statearr_26846_26896[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (22))){
var inst_26826 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
var statearr_26847_26897 = state_26838__$1;
(statearr_26847_26897[(2)] = inst_26826);

(statearr_26847_26897[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (6))){
var inst_26754 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26755 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26756 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26754)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26755)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26757 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26758 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26759 = cljs.core.PersistentHashMap.fromArrays(inst_26757,inst_26758);
var inst_26760 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26756,inst_26759);
var inst_26761 = (function(){throw inst_26760})();
var state_26838__$1 = state_26838;
var statearr_26850_26898 = state_26838__$1;
(statearr_26850_26898[(2)] = inst_26761);

(statearr_26850_26898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (25))){
var inst_26795 = (state_26838[(12)]);
var inst_26812 = (state_26838[(10)]);
var inst_26794 = (state_26838[(11)]);
var inst_26817 = inst_26794.t;
var inst_26818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26819 = [inst_26794];
var inst_26820 = (new cljs.core.PersistentVector(null,1,(5),inst_26818,inst_26819,null));
var inst_26785 = inst_26795;
var inst_26786 = inst_26817;
var inst_26787 = inst_26820;
var inst_26788 = inst_26812;
var state_26838__$1 = (function (){var statearr_26851 = state_26838;
(statearr_26851[(7)] = inst_26787);

(statearr_26851[(8)] = inst_26786);

(statearr_26851[(9)] = inst_26788);

(statearr_26851[(13)] = inst_26785);

return statearr_26851;
})();
var statearr_26852_26899 = state_26838__$1;
(statearr_26852_26899[(2)] = null);

(statearr_26852_26899[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (17))){
var inst_26787 = (state_26838[(7)]);
var inst_26795 = (state_26838[(12)]);
var inst_26786 = (state_26838[(8)]);
var inst_26788 = (state_26838[(9)]);
var inst_26794 = (state_26838[(11)]);
var inst_26803 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26787,inst_26794);
var tmp26848 = inst_26786;
var tmp26849 = inst_26788;
var inst_26785 = inst_26795;
var inst_26786__$1 = tmp26848;
var inst_26787__$1 = inst_26803;
var inst_26788__$1 = tmp26849;
var state_26838__$1 = (function (){var statearr_26853 = state_26838;
(statearr_26853[(7)] = inst_26787__$1);

(statearr_26853[(8)] = inst_26786__$1);

(statearr_26853[(9)] = inst_26788__$1);

(statearr_26853[(13)] = inst_26785);

return statearr_26853;
})();
var statearr_26854_26900 = state_26838__$1;
(statearr_26854_26900[(2)] = null);

(statearr_26854_26900[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (3))){
var inst_26836 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26838__$1,inst_26836);
} else {
if((state_val_26839 === (12))){
var inst_26785 = (state_26838[(13)]);
var inst_26794 = (state_26838[(11)]);
var inst_26793 = cljs.core.seq(inst_26785);
var inst_26794__$1 = cljs.core.first(inst_26793);
var inst_26795 = cljs.core.next(inst_26793);
var state_26838__$1 = (function (){var statearr_26855 = state_26838;
(statearr_26855[(12)] = inst_26795);

(statearr_26855[(11)] = inst_26794__$1);

return statearr_26855;
})();
if(cljs.core.truth_(inst_26794__$1)){
var statearr_26856_26901 = state_26838__$1;
(statearr_26856_26901[(1)] = (14));

} else {
var statearr_26857_26902 = state_26838__$1;
(statearr_26857_26902[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (2))){
var _ = (function (){var statearr_26858 = state_26838;
(statearr_26858[(4)] = cljs.core.cons((5),(state_26838[(4)])));

return statearr_26858;
})();
var inst_26750 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26751 = (inst_26750 + (1));
var inst_26752 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26751);
var state_26838__$1 = state_26838;
if(inst_26752){
var statearr_26859_26903 = state_26838__$1;
(statearr_26859_26903[(1)] = (6));

} else {
var statearr_26860_26904 = state_26838__$1;
(statearr_26860_26904[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (23))){
var inst_26794 = (state_26838[(11)]);
var inst_26811 = (state_26838[(2)]);
var inst_26812 = fluree.db.util.async.throw_err(inst_26811);
var inst_26813 = (inst_26794 == null);
var state_26838__$1 = (function (){var statearr_26861 = state_26838;
(statearr_26861[(10)] = inst_26812);

return statearr_26861;
})();
if(cljs.core.truth_(inst_26813)){
var statearr_26862_26905 = state_26838__$1;
(statearr_26862_26905[(1)] = (24));

} else {
var statearr_26863_26906 = state_26838__$1;
(statearr_26863_26906[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (19))){
var inst_26828 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
var statearr_26864_26907 = state_26838__$1;
(statearr_26864_26907[(2)] = inst_26828);

(statearr_26864_26907[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (11))){
var inst_26833 = (state_26838[(2)]);
var _ = (function (){var statearr_26866 = state_26838;
(statearr_26866[(4)] = cljs.core.rest((state_26838[(4)])));

return statearr_26866;
})();
var state_26838__$1 = state_26838;
var statearr_26867_26908 = state_26838__$1;
(statearr_26867_26908[(2)] = inst_26833);

(statearr_26867_26908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (9))){
var inst_26767 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26768 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26767);
var state_26838__$1 = state_26838;
var statearr_26868_26909 = state_26838__$1;
(statearr_26868_26909[(2)] = inst_26768);

(statearr_26868_26909[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (5))){
var _ = (function (){var statearr_26869 = state_26838;
(statearr_26869[(4)] = cljs.core.rest((state_26838[(4)])));

return statearr_26869;
})();
var state_26838__$1 = state_26838;
var ex26865 = (state_26838__$1[(2)]);
var statearr_26870_26910 = state_26838__$1;
(statearr_26870_26910[(5)] = ex26865);


var statearr_26871_26911 = state_26838__$1;
(statearr_26871_26911[(1)] = (4));

(statearr_26871_26911[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (14))){
var inst_26786 = (state_26838[(8)]);
var inst_26794 = (state_26838[(11)]);
var inst_26797 = inst_26794.t;
var inst_26798 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26786,inst_26797);
var state_26838__$1 = state_26838;
var statearr_26872_26912 = state_26838__$1;
(statearr_26872_26912[(2)] = inst_26798);

(statearr_26872_26912[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (26))){
var inst_26823 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
var statearr_26873_26913 = state_26838__$1;
(statearr_26873_26913[(2)] = inst_26823);

(statearr_26873_26913[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (16))){
var inst_26801 = (state_26838[(2)]);
var state_26838__$1 = state_26838;
if(cljs.core.truth_(inst_26801)){
var statearr_26874_26914 = state_26838__$1;
(statearr_26874_26914[(1)] = (17));

} else {
var statearr_26875_26915 = state_26838__$1;
(statearr_26875_26915[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (10))){
var inst_26770 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26771 = cljs.core.first(inst_26770);
var inst_26779 = cljs.core.seq(inst_26770);
var inst_26780 = cljs.core.first(inst_26779);
var inst_26781 = cljs.core.next(inst_26779);
var inst_26782 = inst_26771.t;
var inst_26783 = cljs.core.PersistentVector.EMPTY;
var inst_26784 = db;
var inst_26785 = inst_26770;
var inst_26786 = inst_26782;
var inst_26787 = inst_26783;
var inst_26788 = inst_26784;
var state_26838__$1 = (function (){var statearr_26876 = state_26838;
(statearr_26876[(14)] = inst_26780);

(statearr_26876[(7)] = inst_26787);

(statearr_26876[(15)] = inst_26781);

(statearr_26876[(8)] = inst_26786);

(statearr_26876[(9)] = inst_26788);

(statearr_26876[(13)] = inst_26785);

return statearr_26876;
})();
var statearr_26877_26916 = state_26838__$1;
(statearr_26877_26916[(2)] = null);

(statearr_26877_26916[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (18))){
var state_26838__$1 = state_26838;
var statearr_26878_26917 = state_26838__$1;
(statearr_26878_26917[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26839 === (8))){
var inst_26764 = (state_26838[(2)]);
var inst_26765 = cljs.core.empty_QMARK_(flakes);
var state_26838__$1 = (function (){var statearr_26880 = state_26838;
(statearr_26880[(16)] = inst_26764);

return statearr_26880;
})();
if(inst_26765){
var statearr_26881_26918 = state_26838__$1;
(statearr_26881_26918[(1)] = (9));

} else {
var statearr_26882_26919 = state_26838__$1;
(statearr_26882_26919[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_26883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26883[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_26883[(1)] = (1));

return statearr_26883;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_26838){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26838);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26884){var ex__2736__auto__ = e26884;
var statearr_26885_26920 = state_26838;
(statearr_26885_26920[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26838[(4)]))){
var statearr_26886_26921 = state_26838;
(statearr_26886_26921[(1)] = cljs.core.first((state_26838[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26922 = state_26838;
state_26838 = G__26922;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_26838){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_26838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26887 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26887[(6)] = c__2755__auto___26889);

return statearr_26887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_26978){
var state_val_26979 = (state_26978[(1)]);
if((state_val_26979 === (7))){
var state_26978__$1 = state_26978;
var statearr_26980_27007 = state_26978__$1;
(statearr_26980_27007[(2)] = tt_id);

(statearr_26980_27007[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (1))){
var state_26978__$1 = state_26978;
var statearr_26981_27008 = state_26978__$1;
(statearr_26981_27008[(2)] = null);

(statearr_26981_27008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (4))){
var inst_26923 = (state_26978[(2)]);
var state_26978__$1 = state_26978;
var statearr_26982_27009 = state_26978__$1;
(statearr_26982_27009[(2)] = inst_26923);

(statearr_26982_27009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (13))){
var inst_26971 = (state_26978[(2)]);
var state_26978__$1 = state_26978;
var statearr_26983_27010 = state_26978__$1;
(statearr_26983_27010[(2)] = inst_26971);

(statearr_26983_27010[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (6))){
var inst_26931 = fluree.db.util.core.random_uuid();
var state_26978__$1 = state_26978;
var statearr_26984_27011 = state_26978__$1;
(statearr_26984_27011[(2)] = inst_26931);

(statearr_26984_27011[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (3))){
var inst_26976 = (state_26978[(2)]);
var state_26978__$1 = state_26978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26978__$1,inst_26976);
} else {
if((state_val_26979 === (12))){
var inst_26954 = (state_26978[(7)]);
var state_26978__$1 = state_26978;
var statearr_26985_27012 = state_26978__$1;
(statearr_26985_27012[(2)] = inst_26954);

(statearr_26985_27012[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (2))){
var _ = (function (){var statearr_26986 = state_26978;
(statearr_26986[(4)] = cljs.core.cons((5),(state_26978[(4)])));

return statearr_26986;
})();
var inst_26929 = (tt_id == null);
var state_26978__$1 = state_26978;
if(cljs.core.truth_(inst_26929)){
var statearr_26987_27013 = state_26978__$1;
(statearr_26987_27013[(1)] = (6));

} else {
var statearr_26988_27014 = state_26978__$1;
(statearr_26988_27014[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (11))){
var inst_26954 = (state_26978[(7)]);
var inst_26961 = (state_26978[(8)]);
var inst_26964 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_26954,inst_26961);
var state_26978__$1 = state_26978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26978__$1,(14),inst_26964);
} else {
if((state_val_26979 === (9))){
var inst_26955 = (state_26978[(9)]);
var inst_26961 = (state_26978[(8)]);
var inst_26960 = cljs.core.seq(inst_26955);
var inst_26961__$1 = cljs.core.first(inst_26960);
var inst_26962 = cljs.core.next(inst_26960);
var state_26978__$1 = (function (){var statearr_26990 = state_26978;
(statearr_26990[(10)] = inst_26962);

(statearr_26990[(8)] = inst_26961__$1);

return statearr_26990;
})();
if(cljs.core.truth_(inst_26961__$1)){
var statearr_26991_27015 = state_26978__$1;
(statearr_26991_27015[(1)] = (11));

} else {
var statearr_26992_27016 = state_26978__$1;
(statearr_26992_27016[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (5))){
var _ = (function (){var statearr_26993 = state_26978;
(statearr_26993[(4)] = cljs.core.rest((state_26978[(4)])));

return statearr_26993;
})();
var state_26978__$1 = state_26978;
var ex26989 = (state_26978__$1[(2)]);
var statearr_26994_27017 = state_26978__$1;
(statearr_26994_27017[(5)] = ex26989);


if((ex26989 instanceof Error)){
var statearr_26995_27018 = state_26978__$1;
(statearr_26995_27018[(1)] = (4));

(statearr_26995_27018[(5)] = null);

} else {
throw ex26989;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (14))){
var inst_26962 = (state_26978[(10)]);
var inst_26966 = (state_26978[(2)]);
var inst_26967 = fluree.db.util.async.throw_err(inst_26966);
var inst_26954 = inst_26967;
var inst_26955 = inst_26962;
var state_26978__$1 = (function (){var statearr_26996 = state_26978;
(statearr_26996[(7)] = inst_26954);

(statearr_26996[(9)] = inst_26955);

return statearr_26996;
})();
var statearr_26997_27019 = state_26978__$1;
(statearr_26997_27019[(2)] = null);

(statearr_26997_27019[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (10))){
var inst_26973 = (state_26978[(2)]);
var _ = (function (){var statearr_26998 = state_26978;
(statearr_26998[(4)] = cljs.core.rest((state_26978[(4)])));

return statearr_26998;
})();
var state_26978__$1 = state_26978;
var statearr_26999_27020 = state_26978__$1;
(statearr_26999_27020[(2)] = inst_26973);

(statearr_26999_27020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26979 === (8))){
var inst_26934 = (state_26978[(2)]);
var inst_26935 = (function (){var tt_id_SINGLEQUOTE_ = inst_26934;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26936 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26934);
var inst_26937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26938 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26939 = (new cljs.core.PersistentVector(null,4,(5),inst_26937,inst_26938,null));
var inst_26940 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26935,inst_26936,inst_26939);
var inst_26941 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26942 = cljs.core.reverse(inst_26941);
var inst_26943 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26942);
var inst_26951 = cljs.core.seq(inst_26943);
var inst_26952 = cljs.core.first(inst_26951);
var inst_26953 = cljs.core.next(inst_26951);
var inst_26954 = inst_26940;
var inst_26955 = inst_26943;
var state_26978__$1 = (function (){var statearr_27000 = state_26978;
(statearr_27000[(11)] = inst_26952);

(statearr_27000[(7)] = inst_26954);

(statearr_27000[(9)] = inst_26955);

(statearr_27000[(12)] = inst_26953);

return statearr_27000;
})();
var statearr_27001_27021 = state_26978__$1;
(statearr_27001_27021[(2)] = null);

(statearr_27001_27021[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____0 = (function (){
var statearr_27002 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27002[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__);

(statearr_27002[(1)] = (1));

return statearr_27002;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____1 = (function (state_26978){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_26978);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27003){var ex__2736__auto__ = e27003;
var statearr_27004_27022 = state_26978;
(statearr_27004_27022[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_26978[(4)]))){
var statearr_27005_27023 = state_26978;
(statearr_27005_27023[(1)] = cljs.core.first((state_26978[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27024 = state_26978;
state_26978 = G__27024;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__ = function(state_26978){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____1.call(this,state_26978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27006 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27006[(6)] = c__2755__auto__);

return statearr_27006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___27211 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27142){
var state_val_27143 = (state_27142[(1)]);
if((state_val_27143 === (7))){
var inst_27052 = (state_27142[(7)]);
var inst_27052__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27142__$1 = (function (){var statearr_27144 = state_27142;
(statearr_27144[(7)] = inst_27052__$1);

return statearr_27144;
})();
if(inst_27052__$1){
var statearr_27145_27212 = state_27142__$1;
(statearr_27145_27212[(1)] = (13));

} else {
var statearr_27146_27213 = state_27142__$1;
(statearr_27146_27213[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (20))){
var state_27142__$1 = state_27142;
var statearr_27147_27214 = state_27142__$1;
(statearr_27147_27214[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (27))){
var inst_27088 = (state_27142[(8)]);
var inst_27092 = inst_27088.s;
var state_27142__$1 = state_27142;
var statearr_27149_27215 = state_27142__$1;
(statearr_27149_27215[(2)] = inst_27092);

(statearr_27149_27215[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (1))){
var state_27142__$1 = state_27142;
var statearr_27150_27216 = state_27142__$1;
(statearr_27150_27216[(2)] = null);

(statearr_27150_27216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (24))){
var inst_27082 = (state_27142[(9)]);
var inst_27086 = cljs.core.first(inst_27082);
var state_27142__$1 = state_27142;
var statearr_27151_27217 = state_27142__$1;
(statearr_27151_27217[(2)] = inst_27086);

(statearr_27151_27217[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (39))){
var state_27142__$1 = state_27142;
var statearr_27152_27218 = state_27142__$1;
(statearr_27152_27218[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (4))){
var inst_27025 = (state_27142[(2)]);
var inst_27026 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27027 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27028 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27029 = cljs.core.PersistentHashMap.fromArrays(inst_27027,inst_27028);
var inst_27030 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_27026,inst_27029,inst_27025);
var inst_27031 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27030);
var state_27142__$1 = state_27142;
var statearr_27154_27219 = state_27142__$1;
(statearr_27154_27219[(2)] = inst_27031);

(statearr_27154_27219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (15))){
var inst_27059 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
if(cljs.core.truth_(inst_27059)){
var statearr_27155_27220 = state_27142__$1;
(statearr_27155_27220[(1)] = (16));

} else {
var statearr_27156_27221 = state_27142__$1;
(statearr_27156_27221[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (21))){
var inst_27108 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27157_27222 = state_27142__$1;
(statearr_27157_27222[(2)] = inst_27108);

(statearr_27157_27222[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (31))){
var inst_27106 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27158_27223 = state_27142__$1;
(statearr_27158_27223[(2)] = inst_27106);

(statearr_27158_27223[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (32))){
var inst_27112 = (state_27142[(10)]);
var inst_27114 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27112);
var state_27142__$1 = state_27142;
var statearr_27159_27224 = state_27142__$1;
(statearr_27159_27224[(2)] = inst_27114);

(statearr_27159_27224[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (40))){
var inst_27135 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27160_27225 = state_27142__$1;
(statearr_27160_27225[(2)] = inst_27135);

(statearr_27160_27225[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (33))){
var inst_27116 = (state_27142[(11)]);
var inst_27112 = (state_27142[(10)]);
var inst_27116__$1 = (inst_27112 == null);
var state_27142__$1 = (function (){var statearr_27161 = state_27142;
(statearr_27161[(11)] = inst_27116__$1);

return statearr_27161;
})();
if(cljs.core.truth_(inst_27116__$1)){
var statearr_27162_27226 = state_27142__$1;
(statearr_27162_27226[(1)] = (35));

} else {
var statearr_27163_27227 = state_27142__$1;
(statearr_27163_27227[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (13))){
var inst_27054 = cljs.core.first(ident);
var inst_27055 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27054);
var inst_27056 = (inst_27055 == null);
var state_27142__$1 = state_27142;
var statearr_27164_27228 = state_27142__$1;
(statearr_27164_27228[(2)] = inst_27056);

(statearr_27164_27228[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (22))){
var inst_27082 = (state_27142[(9)]);
var inst_27081 = (state_27142[(2)]);
var inst_27082__$1 = fluree.db.util.async.throw_err(inst_27081);
var inst_27083 = (inst_27082__$1 == null);
var state_27142__$1 = (function (){var statearr_27165 = state_27142;
(statearr_27165[(9)] = inst_27082__$1);

return statearr_27165;
})();
if(cljs.core.truth_(inst_27083)){
var statearr_27166_27229 = state_27142__$1;
(statearr_27166_27229[(1)] = (23));

} else {
var statearr_27167_27230 = state_27142__$1;
(statearr_27167_27230[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (36))){
var inst_27116 = (state_27142[(11)]);
var state_27142__$1 = state_27142;
var statearr_27168_27231 = state_27142__$1;
(statearr_27168_27231[(2)] = inst_27116);

(statearr_27168_27231[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (41))){
var inst_27130 = cljs.core.async.close_BANG_(return_chan);
var state_27142__$1 = state_27142;
var statearr_27169_27232 = state_27142__$1;
(statearr_27169_27232[(2)] = inst_27130);

(statearr_27169_27232[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (43))){
var inst_27133 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27170_27233 = state_27142__$1;
(statearr_27170_27233[(2)] = inst_27133);

(statearr_27170_27233[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (29))){
var inst_27097 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_27098 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27097].join('');
var inst_27099 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27100 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27101 = cljs.core.PersistentHashMap.fromArrays(inst_27099,inst_27100);
var inst_27102 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27098,inst_27101);
var inst_27103 = (function(){throw inst_27102})();
var state_27142__$1 = state_27142;
var statearr_27171_27234 = state_27142__$1;
(statearr_27171_27234[(2)] = inst_27103);

(statearr_27171_27234[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (6))){
var inst_27039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27040 = [ident];
var inst_27041 = (new cljs.core.PersistentVector(null,1,(5),inst_27039,inst_27040,null));
var inst_27042 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27041);
var state_27142__$1 = state_27142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27142__$1,(9),inst_27042);
} else {
if((state_val_27143 === (28))){
var inst_27094 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27172_27235 = state_27142__$1;
(statearr_27172_27235[(2)] = inst_27094);

(statearr_27172_27235[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (25))){
var inst_27088 = (state_27142[(8)]);
var inst_27088__$1 = (state_27142[(2)]);
var inst_27089 = (inst_27088__$1 == null);
var state_27142__$1 = (function (){var statearr_27173 = state_27142;
(statearr_27173[(8)] = inst_27088__$1);

return statearr_27173;
})();
if(cljs.core.truth_(inst_27089)){
var statearr_27174_27236 = state_27142__$1;
(statearr_27174_27236[(1)] = (26));

} else {
var statearr_27175_27237 = state_27142__$1;
(statearr_27175_27237[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (34))){
var inst_27137 = (state_27142[(2)]);
var _ = (function (){var statearr_27176 = state_27142;
(statearr_27176[(4)] = cljs.core.rest((state_27142[(4)])));

return statearr_27176;
})();
var state_27142__$1 = state_27142;
var statearr_27177_27238 = state_27142__$1;
(statearr_27177_27238[(2)] = inst_27137);

(statearr_27177_27238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (17))){
var inst_27070 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_27142__$1 = state_27142;
if(inst_27070){
var statearr_27178_27239 = state_27142__$1;
(statearr_27178_27239[(1)] = (19));

} else {
var statearr_27179_27240 = state_27142__$1;
(statearr_27179_27240[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (3))){
var inst_27140 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27142__$1,inst_27140);
} else {
if((state_val_27143 === (12))){
var inst_27050 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27180_27241 = state_27142__$1;
(statearr_27180_27241[(2)] = inst_27050);

(statearr_27180_27241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (2))){
var _ = (function (){var statearr_27181 = state_27142;
(statearr_27181[(4)] = cljs.core.cons((5),(state_27142[(4)])));

return statearr_27181;
})();
var inst_27037 = typeof ident === 'number';
var state_27142__$1 = state_27142;
if(cljs.core.truth_(inst_27037)){
var statearr_27182_27242 = state_27142__$1;
(statearr_27182_27242[(1)] = (6));

} else {
var statearr_27183_27243 = state_27142__$1;
(statearr_27183_27243[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (23))){
var state_27142__$1 = state_27142;
var statearr_27184_27244 = state_27142__$1;
(statearr_27184_27244[(2)] = null);

(statearr_27184_27244[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (35))){
var state_27142__$1 = state_27142;
var statearr_27185_27245 = state_27142__$1;
(statearr_27185_27245[(2)] = strict_QMARK_);

(statearr_27185_27245[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (19))){
var inst_27073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27074 = cljs.core.first(ident);
var inst_27075 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27074);
var inst_27076 = cljs.core.second(ident);
var inst_27077 = [inst_27075,inst_27076];
var inst_27078 = (new cljs.core.PersistentVector(null,2,(5),inst_27073,inst_27077,null));
var inst_27079 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27078);
var state_27142__$1 = state_27142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27142__$1,(22),inst_27079);
} else {
if((state_val_27143 === (11))){
var state_27142__$1 = state_27142;
var statearr_27187_27246 = state_27142__$1;
(statearr_27187_27246[(2)] = null);

(statearr_27187_27246[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (9))){
var inst_27044 = (state_27142[(2)]);
var inst_27045 = fluree.db.util.async.throw_err(inst_27044);
var inst_27046 = cljs.core.not_empty(inst_27045);
var state_27142__$1 = state_27142;
if(cljs.core.truth_(inst_27046)){
var statearr_27188_27247 = state_27142__$1;
(statearr_27188_27247[(1)] = (10));

} else {
var statearr_27189_27248 = state_27142__$1;
(statearr_27189_27248[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (5))){
var _ = (function (){var statearr_27190 = state_27142;
(statearr_27190[(4)] = cljs.core.rest((state_27142[(4)])));

return statearr_27190;
})();
var state_27142__$1 = state_27142;
var ex27186 = (state_27142__$1[(2)]);
var statearr_27191_27249 = state_27142__$1;
(statearr_27191_27249[(5)] = ex27186);


var statearr_27192_27250 = state_27142__$1;
(statearr_27192_27250[(1)] = (4));

(statearr_27192_27250[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (14))){
var inst_27052 = (state_27142[(7)]);
var state_27142__$1 = state_27142;
var statearr_27193_27251 = state_27142__$1;
(statearr_27193_27251[(2)] = inst_27052);

(statearr_27193_27251[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (26))){
var state_27142__$1 = state_27142;
var statearr_27194_27252 = state_27142__$1;
(statearr_27194_27252[(2)] = null);

(statearr_27194_27252[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (16))){
var inst_27061 = cljs.core.first(ident);
var inst_27062 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_27061], 0));
var inst_27063 = ["Subject ID lookup failed. The predicate ",inst_27062," does not exist."].join('');
var inst_27064 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27065 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27066 = cljs.core.PersistentHashMap.fromArrays(inst_27064,inst_27065);
var inst_27067 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27063,inst_27066);
var inst_27068 = (function(){throw inst_27067})();
var state_27142__$1 = state_27142;
var statearr_27195_27253 = state_27142__$1;
(statearr_27195_27253[(2)] = inst_27068);

(statearr_27195_27253[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (38))){
var inst_27122 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27123 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27124 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27125 = cljs.core.PersistentHashMap.fromArrays(inst_27123,inst_27124);
var inst_27126 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27122,inst_27125);
var inst_27127 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_27126);
var state_27142__$1 = state_27142;
var statearr_27196_27254 = state_27142__$1;
(statearr_27196_27254[(2)] = inst_27127);

(statearr_27196_27254[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (30))){
var state_27142__$1 = state_27142;
var statearr_27197_27255 = state_27142__$1;
(statearr_27197_27255[(2)] = null);

(statearr_27197_27255[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (10))){
var state_27142__$1 = state_27142;
var statearr_27198_27256 = state_27142__$1;
(statearr_27198_27256[(2)] = ident);

(statearr_27198_27256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (18))){
var inst_27110 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
var statearr_27199_27257 = state_27142__$1;
(statearr_27199_27257[(2)] = inst_27110);

(statearr_27199_27257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (42))){
var state_27142__$1 = state_27142;
var statearr_27200_27258 = state_27142__$1;
(statearr_27200_27258[(2)] = null);

(statearr_27200_27258[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (37))){
var inst_27120 = (state_27142[(2)]);
var state_27142__$1 = state_27142;
if(cljs.core.truth_(inst_27120)){
var statearr_27201_27259 = state_27142__$1;
(statearr_27201_27259[(1)] = (38));

} else {
var statearr_27202_27260 = state_27142__$1;
(statearr_27202_27260[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27143 === (8))){
var inst_27112 = (state_27142[(10)]);
var inst_27112__$1 = (state_27142[(2)]);
var state_27142__$1 = (function (){var statearr_27203 = state_27142;
(statearr_27203[(10)] = inst_27112__$1);

return statearr_27203;
})();
if(cljs.core.truth_(inst_27112__$1)){
var statearr_27204_27261 = state_27142__$1;
(statearr_27204_27261[(1)] = (32));

} else {
var statearr_27205_27262 = state_27142__$1;
(statearr_27205_27262[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2733__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2733__auto____0 = (function (){
var statearr_27206 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27206[(0)] = fluree$db$graphdb$subid_$_state_machine__2733__auto__);

(statearr_27206[(1)] = (1));

return statearr_27206;
});
var fluree$db$graphdb$subid_$_state_machine__2733__auto____1 = (function (state_27142){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27142);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27207){var ex__2736__auto__ = e27207;
var statearr_27208_27263 = state_27142;
(statearr_27208_27263[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27142[(4)]))){
var statearr_27209_27264 = state_27142;
(statearr_27209_27264[(1)] = cljs.core.first((state_27142[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27265 = state_27142;
state_27142 = G__27265;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2733__auto__ = function(state_27142){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2733__auto____1.call(this,state_27142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2733__auto____0;
fluree$db$graphdb$subid_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2733__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27210 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27210[(6)] = c__2755__auto___27211);

return statearr_27210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k27267,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__27271 = k27267;
var G__27271__$1 = (((G__27271 instanceof cljs.core.Keyword))?G__27271.fqn:null);
switch (G__27271__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27267,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__27272){
var vec__27273 = p__27272;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27273,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27273,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27266){
var self__ = this;
var G__27266__$1 = this;
return (new cljs.core.RecordIter((0),G__27266__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__27276 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__27276(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27268,other27269){
var self__ = this;
var this27268__$1 = this;
return (((!((other27269 == null)))) && ((((this27268__$1.constructor === other27269.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.conn,other27269.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.network,other27269.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.dbid,other27269.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.block,other27269.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.t,other27269.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.tt_id,other27269.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.stats,other27269.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.spot,other27269.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.psot,other27269.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.post,other27269.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.opst,other27269.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.schema,other27269.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.settings,other27269.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.index_configs,other27269.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.schema_cache,other27269.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.novelty,other27269.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.permissions,other27269.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.fork,other27269.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.fork_block,other27269.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.current_db_fn,other27269.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27268__$1.__extmap,other27269.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k27267){
var self__ = this;
var this__4479__auto____$1 = this;
var G__27277 = k27267;
var G__27277__$1 = (((G__27277 instanceof cljs.core.Keyword))?G__27277.fqn:null);
switch (G__27277__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27267);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__27266){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__27278 = cljs.core.keyword_identical_QMARK_;
var expr__27279 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__27281 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27282 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27281,G__27282) : pred__27278.call(null,G__27281,G__27282));
})())){
return (new fluree.db.graphdb.GraphDb(G__27266,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27283 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27284 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27283,G__27284) : pred__27278.call(null,G__27283,G__27284));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27266,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27285 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__27286 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27285,G__27286) : pred__27278.call(null,G__27285,G__27286));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27266,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27287 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27288 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27287,G__27288) : pred__27278.call(null,G__27287,G__27288));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27266,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27289 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27290 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27289,G__27290) : pred__27278.call(null,G__27289,G__27290));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27266,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27291 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27292 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27291,G__27292) : pred__27278.call(null,G__27291,G__27292));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27266,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27293 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27294 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27293,G__27294) : pred__27278.call(null,G__27293,G__27294));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27266,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27295 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27296 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27295,G__27296) : pred__27278.call(null,G__27295,G__27296));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27266,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27297 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27298 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27297,G__27298) : pred__27278.call(null,G__27297,G__27298));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27266,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27299 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27300 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27299,G__27300) : pred__27278.call(null,G__27299,G__27300));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27266,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27301 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27302 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27301,G__27302) : pred__27278.call(null,G__27301,G__27302));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27266,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27303 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27304 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27303,G__27304) : pred__27278.call(null,G__27303,G__27304));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27266,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27305 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27306 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27305,G__27306) : pred__27278.call(null,G__27305,G__27306));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27266,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27307 = new cljs.core.Keyword(null,"index-configs","index-configs",1053959280);
var G__27308 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27307,G__27308) : pred__27278.call(null,G__27307,G__27308));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27266,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27309 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27310 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27309,G__27310) : pred__27278.call(null,G__27309,G__27310));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27266,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27311 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27312 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27311,G__27312) : pred__27278.call(null,G__27311,G__27312));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27266,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27313 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27314 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27313,G__27314) : pred__27278.call(null,G__27313,G__27314));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27266,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27315 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27316 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27315,G__27316) : pred__27278.call(null,G__27315,G__27316));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27266,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27317 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27318 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27317,G__27318) : pred__27278.call(null,G__27317,G__27318));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27266,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27319 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27320 = expr__27279;
return (pred__27278.cljs$core$IFn$_invoke$arity$2 ? pred__27278.cljs$core$IFn$_invoke$arity$2(G__27319,G__27320) : pred__27278.call(null,G__27319,G__27320));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27266,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__27266),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__27266){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27266,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27336){
var state_val_27337 = (state_27336[(1)]);
if((state_val_27337 === (1))){
var state_27336__$1 = state_27336;
var statearr_27338_27605 = state_27336__$1;
(statearr_27338_27605[(2)] = null);

(statearr_27338_27605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27337 === (2))){
var _ = (function (){var statearr_27339 = state_27336;
(statearr_27339[(4)] = cljs.core.cons((5),(state_27336[(4)])));

return statearr_27339;
})();
var inst_27327 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_27336__$1 = state_27336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27336__$1,(6),inst_27327);
} else {
if((state_val_27337 === (3))){
var inst_27334 = (state_27336[(2)]);
var state_27336__$1 = state_27336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27336__$1,inst_27334);
} else {
if((state_val_27337 === (4))){
var inst_27321 = (state_27336[(2)]);
var state_27336__$1 = state_27336;
var statearr_27341_27606 = state_27336__$1;
(statearr_27341_27606[(2)] = inst_27321);

(statearr_27341_27606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27337 === (5))){
var _ = (function (){var statearr_27342 = state_27336;
(statearr_27342[(4)] = cljs.core.rest((state_27336[(4)])));

return statearr_27342;
})();
var state_27336__$1 = state_27336;
var ex27340 = (state_27336__$1[(2)]);
var statearr_27343_27607 = state_27336__$1;
(statearr_27343_27607[(5)] = ex27340);


if((ex27340 instanceof Error)){
var statearr_27344_27608 = state_27336__$1;
(statearr_27344_27608[(1)] = (4));

(statearr_27344_27608[(5)] = null);

} else {
throw ex27340;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27337 === (6))){
var inst_27329 = (state_27336[(2)]);
var inst_27330 = fluree.db.util.async.throw_err(inst_27329);
var inst_27331 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_27330,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_27345 = state_27336;
(statearr_27345[(4)] = cljs.core.rest((state_27336[(4)])));

return statearr_27345;
})();
var state_27336__$1 = state_27336;
var statearr_27346_27609 = state_27336__$1;
(statearr_27346_27609[(2)] = inst_27331);

(statearr_27346_27609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27347 = [null,null,null,null,null,null,null];
(statearr_27347[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27347[(1)] = (1));

return statearr_27347;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27336){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27336);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27348){var ex__2736__auto__ = e27348;
var statearr_27349_27610 = state_27336;
(statearr_27349_27610[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27336[(4)]))){
var statearr_27350_27611 = state_27336;
(statearr_27350_27611[(1)] = cljs.core.first((state_27336[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27612 = state_27336;
state_27336 = G__27612;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27336){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27351 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27351[(6)] = c__2755__auto__);

return statearr_27351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27352 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__27352.cljs$core$IFn$_invoke$arity$1 ? fexpr__27352.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27352.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__27353 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__27353.cljs$core$IFn$_invoke$arity$1 ? fexpr__27353.cljs$core$IFn$_invoke$arity$1(property) : fexpr__27353.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27354 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27354);
} else {
return G__27354;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27386){
var state_val_27387 = (state_27386[(1)]);
if((state_val_27387 === (7))){
var state_27386__$1 = state_27386;
var statearr_27388_27613 = state_27386__$1;
(statearr_27388_27613[(2)] = null);

(statearr_27388_27613[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (1))){
var state_27386__$1 = state_27386;
var statearr_27389_27614 = state_27386__$1;
(statearr_27389_27614[(2)] = null);

(statearr_27389_27614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (4))){
var inst_27355 = (state_27386[(2)]);
var state_27386__$1 = state_27386;
var statearr_27390_27615 = state_27386__$1;
(statearr_27390_27615[(2)] = inst_27355);

(statearr_27390_27615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (6))){
var inst_27369 = (state_27386[(7)]);
var inst_27368 = (state_27386[(2)]);
var inst_27369__$1 = fluree.db.util.async.throw_err(inst_27368);
var inst_27370 = (inst_27369__$1 == null);
var state_27386__$1 = (function (){var statearr_27391 = state_27386;
(statearr_27391[(7)] = inst_27369__$1);

return statearr_27391;
})();
if(cljs.core.truth_(inst_27370)){
var statearr_27392_27616 = state_27386__$1;
(statearr_27392_27616[(1)] = (7));

} else {
var statearr_27393_27617 = state_27386__$1;
(statearr_27393_27617[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (3))){
var inst_27384 = (state_27386[(2)]);
var state_27386__$1 = state_27386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27386__$1,inst_27384);
} else {
if((state_val_27387 === (12))){
var inst_27381 = (state_27386[(2)]);
var _ = (function (){var statearr_27394 = state_27386;
(statearr_27394[(4)] = cljs.core.rest((state_27386[(4)])));

return statearr_27394;
})();
var state_27386__$1 = state_27386;
var statearr_27395_27618 = state_27386__$1;
(statearr_27395_27618[(2)] = inst_27381);

(statearr_27395_27618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (2))){
var _ = (function (){var statearr_27396 = state_27386;
(statearr_27396[(4)] = cljs.core.cons((5),(state_27386[(4)])));

return statearr_27396;
})();
var inst_27362 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27364 = [tag_id,(30)];
var inst_27365 = (new cljs.core.PersistentVector(null,2,(5),inst_27363,inst_27364,null));
var inst_27366 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27362,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27365);
var state_27386__$1 = state_27386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27386__$1,(6),inst_27366);
} else {
if((state_val_27387 === (11))){
var inst_27375 = (state_27386[(8)]);
var inst_27379 = inst_27375.o;
var state_27386__$1 = state_27386;
var statearr_27398_27619 = state_27386__$1;
(statearr_27398_27619[(2)] = inst_27379);

(statearr_27398_27619[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (9))){
var inst_27375 = (state_27386[(8)]);
var inst_27375__$1 = (state_27386[(2)]);
var inst_27376 = (inst_27375__$1 == null);
var state_27386__$1 = (function (){var statearr_27399 = state_27386;
(statearr_27399[(8)] = inst_27375__$1);

return statearr_27399;
})();
if(cljs.core.truth_(inst_27376)){
var statearr_27400_27620 = state_27386__$1;
(statearr_27400_27620[(1)] = (10));

} else {
var statearr_27401_27621 = state_27386__$1;
(statearr_27401_27621[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (5))){
var _ = (function (){var statearr_27402 = state_27386;
(statearr_27402[(4)] = cljs.core.rest((state_27386[(4)])));

return statearr_27402;
})();
var state_27386__$1 = state_27386;
var ex27397 = (state_27386__$1[(2)]);
var statearr_27403_27622 = state_27386__$1;
(statearr_27403_27622[(5)] = ex27397);


if((ex27397 instanceof Error)){
var statearr_27404_27623 = state_27386__$1;
(statearr_27404_27623[(1)] = (4));

(statearr_27404_27623[(5)] = null);

} else {
throw ex27397;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (10))){
var state_27386__$1 = state_27386;
var statearr_27405_27624 = state_27386__$1;
(statearr_27405_27624[(2)] = null);

(statearr_27405_27624[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27387 === (8))){
var inst_27369 = (state_27386[(7)]);
var inst_27373 = cljs.core.first(inst_27369);
var state_27386__$1 = state_27386;
var statearr_27406_27625 = state_27386__$1;
(statearr_27406_27625[(2)] = inst_27373);

(statearr_27406_27625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27407 = [null,null,null,null,null,null,null,null,null];
(statearr_27407[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27407[(1)] = (1));

return statearr_27407;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27386){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27386);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27408){var ex__2736__auto__ = e27408;
var statearr_27409_27626 = state_27386;
(statearr_27409_27626[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27386[(4)]))){
var statearr_27410_27627 = state_27386;
(statearr_27410_27627[(1)] = cljs.core.first((state_27386[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27628 = state_27386;
state_27386 = G__27628;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27386){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27411 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27411[(6)] = c__2755__auto__);

return statearr_27411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27447){
var state_val_27448 = (state_27447[(1)]);
if((state_val_27448 === (7))){
var inst_27421 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27447__$1 = state_27447;
var statearr_27449_27629 = state_27447__$1;
(statearr_27449_27629[(2)] = inst_27421);

(statearr_27449_27629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (1))){
var state_27447__$1 = state_27447;
var statearr_27450_27630 = state_27447__$1;
(statearr_27450_27630[(2)] = null);

(statearr_27450_27630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (4))){
var inst_27412 = (state_27447[(2)]);
var state_27447__$1 = state_27447;
var statearr_27451_27631 = state_27447__$1;
(statearr_27451_27631[(2)] = inst_27412);

(statearr_27451_27631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (15))){
var inst_27442 = (state_27447[(2)]);
var _ = (function (){var statearr_27452 = state_27447;
(statearr_27452[(4)] = cljs.core.rest((state_27447[(4)])));

return statearr_27452;
})();
var state_27447__$1 = state_27447;
var statearr_27453_27632 = state_27447__$1;
(statearr_27453_27632[(2)] = inst_27442);

(statearr_27453_27632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (13))){
var inst_27427 = (state_27447[(7)]);
var inst_27433 = clojure.string.includes_QMARK_(inst_27427,":");
var state_27447__$1 = state_27447;
if(inst_27433){
var statearr_27454_27633 = state_27447__$1;
(statearr_27454_27633[(1)] = (16));

} else {
var statearr_27455_27634 = state_27447__$1;
(statearr_27455_27634[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (6))){
var state_27447__$1 = state_27447;
var statearr_27456_27635 = state_27447__$1;
(statearr_27456_27635[(2)] = pred);

(statearr_27456_27635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (17))){
var inst_27427 = (state_27447[(7)]);
var state_27447__$1 = state_27447;
var statearr_27457_27636 = state_27447__$1;
(statearr_27457_27636[(2)] = inst_27427);

(statearr_27457_27636[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (3))){
var inst_27445 = (state_27447[(2)]);
var state_27447__$1 = state_27447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27447__$1,inst_27445);
} else {
if((state_val_27448 === (12))){
var inst_27431 = (state_27447[(2)]);
var state_27447__$1 = state_27447;
if(cljs.core.truth_(inst_27431)){
var statearr_27458_27637 = state_27447__$1;
(statearr_27458_27637[(1)] = (13));

} else {
var statearr_27459_27638 = state_27447__$1;
(statearr_27459_27638[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (2))){
var _ = (function (){var statearr_27460 = state_27447;
(statearr_27460[(4)] = cljs.core.cons((5),(state_27447[(4)])));

return statearr_27460;
})();
var inst_27418 = typeof pred === 'string';
var state_27447__$1 = state_27447;
if(cljs.core.truth_(inst_27418)){
var statearr_27461_27639 = state_27447__$1;
(statearr_27461_27639[(1)] = (6));

} else {
var statearr_27462_27640 = state_27447__$1;
(statearr_27462_27640[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (11))){
var inst_27423 = (state_27447[(8)]);
var state_27447__$1 = state_27447;
var statearr_27464_27641 = state_27447__$1;
(statearr_27464_27641[(2)] = inst_27423);

(statearr_27464_27641[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (9))){
var inst_27423 = (state_27447[(8)]);
var inst_27426 = (state_27447[(2)]);
var inst_27427 = fluree.db.util.async.throw_err(inst_27426);
var state_27447__$1 = (function (){var statearr_27465 = state_27447;
(statearr_27465[(7)] = inst_27427);

return statearr_27465;
})();
if(cljs.core.truth_(inst_27423)){
var statearr_27466_27642 = state_27447__$1;
(statearr_27466_27642[(1)] = (10));

} else {
var statearr_27467_27643 = state_27447__$1;
(statearr_27467_27643[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (5))){
var _ = (function (){var statearr_27468 = state_27447;
(statearr_27468[(4)] = cljs.core.rest((state_27447[(4)])));

return statearr_27468;
})();
var state_27447__$1 = state_27447;
var ex27463 = (state_27447__$1[(2)]);
var statearr_27469_27644 = state_27447__$1;
(statearr_27469_27644[(5)] = ex27463);


if((ex27463 instanceof Error)){
var statearr_27470_27645 = state_27447__$1;
(statearr_27470_27645[(1)] = (4));

(statearr_27470_27645[(5)] = null);

} else {
throw ex27463;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (14))){
var state_27447__$1 = state_27447;
var statearr_27471_27646 = state_27447__$1;
(statearr_27471_27646[(2)] = null);

(statearr_27471_27646[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (16))){
var inst_27427 = (state_27447[(7)]);
var inst_27435 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_27427,/:/);
var inst_27436 = cljs.core.second(inst_27435);
var state_27447__$1 = state_27447;
var statearr_27472_27647 = state_27447__$1;
(statearr_27472_27647[(2)] = inst_27436);

(statearr_27472_27647[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (10))){
var inst_27427 = (state_27447[(7)]);
var state_27447__$1 = state_27447;
var statearr_27473_27648 = state_27447__$1;
(statearr_27473_27648[(2)] = inst_27427);

(statearr_27473_27648[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (18))){
var inst_27439 = (state_27447[(2)]);
var state_27447__$1 = state_27447;
var statearr_27474_27649 = state_27447__$1;
(statearr_27474_27649[(2)] = inst_27439);

(statearr_27474_27649[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27448 === (8))){
var inst_27423 = (state_27447[(2)]);
var inst_27424 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_27447__$1 = (function (){var statearr_27475 = state_27447;
(statearr_27475[(8)] = inst_27423);

return statearr_27475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27447__$1,(9),inst_27424);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27476 = [null,null,null,null,null,null,null,null,null];
(statearr_27476[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27476[(1)] = (1));

return statearr_27476;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27447){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27447);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27477){var ex__2736__auto__ = e27477;
var statearr_27478_27650 = state_27447;
(statearr_27478_27650[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27447[(4)]))){
var statearr_27479_27651 = state_27447;
(statearr_27479_27651[(1)] = cljs.core.first((state_27447[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27652 = state_27447;
state_27447 = G__27652;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27447){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27480 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27480[(6)] = c__2755__auto__);

return statearr_27480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27513){
var state_val_27514 = (state_27513[(1)]);
if((state_val_27514 === (7))){
var state_27513__$1 = state_27513;
var statearr_27515_27653 = state_27513__$1;
(statearr_27515_27653[(2)] = null);

(statearr_27515_27653[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (1))){
var state_27513__$1 = state_27513;
var statearr_27516_27654 = state_27513__$1;
(statearr_27516_27654[(2)] = null);

(statearr_27516_27654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (4))){
var inst_27481 = (state_27513[(2)]);
var state_27513__$1 = state_27513;
var statearr_27517_27655 = state_27513__$1;
(statearr_27517_27655[(2)] = inst_27481);

(statearr_27517_27655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (6))){
var inst_27496 = (state_27513[(7)]);
var inst_27495 = (state_27513[(2)]);
var inst_27496__$1 = fluree.db.util.async.throw_err(inst_27495);
var inst_27497 = (inst_27496__$1 == null);
var state_27513__$1 = (function (){var statearr_27518 = state_27513;
(statearr_27518[(7)] = inst_27496__$1);

return statearr_27518;
})();
if(cljs.core.truth_(inst_27497)){
var statearr_27519_27656 = state_27513__$1;
(statearr_27519_27656[(1)] = (7));

} else {
var statearr_27520_27657 = state_27513__$1;
(statearr_27520_27657[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (3))){
var inst_27511 = (state_27513[(2)]);
var state_27513__$1 = state_27513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27513__$1,inst_27511);
} else {
if((state_val_27514 === (12))){
var inst_27508 = (state_27513[(2)]);
var _ = (function (){var statearr_27521 = state_27513;
(statearr_27521[(4)] = cljs.core.rest((state_27513[(4)])));

return statearr_27521;
})();
var state_27513__$1 = state_27513;
var statearr_27522_27658 = state_27513__$1;
(statearr_27522_27658[(2)] = inst_27508);

(statearr_27522_27658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (2))){
var _ = (function (){var statearr_27523 = state_27513;
(statearr_27523[(4)] = cljs.core.cons((5),(state_27513[(4)])));

return statearr_27523;
})();
var inst_27487 = (30);
var inst_27489 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_27490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27491 = [inst_27487,tag_name];
var inst_27492 = (new cljs.core.PersistentVector(null,2,(5),inst_27490,inst_27491,null));
var inst_27493 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27489,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27492);
var state_27513__$1 = state_27513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27513__$1,(6),inst_27493);
} else {
if((state_val_27514 === (11))){
var inst_27502 = (state_27513[(8)]);
var inst_27506 = inst_27502.s;
var state_27513__$1 = state_27513;
var statearr_27525_27659 = state_27513__$1;
(statearr_27525_27659[(2)] = inst_27506);

(statearr_27525_27659[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (9))){
var inst_27502 = (state_27513[(8)]);
var inst_27502__$1 = (state_27513[(2)]);
var inst_27503 = (inst_27502__$1 == null);
var state_27513__$1 = (function (){var statearr_27526 = state_27513;
(statearr_27526[(8)] = inst_27502__$1);

return statearr_27526;
})();
if(cljs.core.truth_(inst_27503)){
var statearr_27527_27660 = state_27513__$1;
(statearr_27527_27660[(1)] = (10));

} else {
var statearr_27528_27661 = state_27513__$1;
(statearr_27528_27661[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (5))){
var _ = (function (){var statearr_27529 = state_27513;
(statearr_27529[(4)] = cljs.core.rest((state_27513[(4)])));

return statearr_27529;
})();
var state_27513__$1 = state_27513;
var ex27524 = (state_27513__$1[(2)]);
var statearr_27530_27662 = state_27513__$1;
(statearr_27530_27662[(5)] = ex27524);


if((ex27524 instanceof Error)){
var statearr_27531_27663 = state_27513__$1;
(statearr_27531_27663[(1)] = (4));

(statearr_27531_27663[(5)] = null);

} else {
throw ex27524;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (10))){
var state_27513__$1 = state_27513;
var statearr_27532_27664 = state_27513__$1;
(statearr_27532_27664[(2)] = null);

(statearr_27532_27664[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27514 === (8))){
var inst_27496 = (state_27513[(7)]);
var inst_27500 = cljs.core.first(inst_27496);
var state_27513__$1 = state_27513;
var statearr_27533_27665 = state_27513__$1;
(statearr_27533_27665[(2)] = inst_27500);

(statearr_27533_27665[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27534 = [null,null,null,null,null,null,null,null,null];
(statearr_27534[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27534[(1)] = (1));

return statearr_27534;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27513){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27513);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27535){var ex__2736__auto__ = e27535;
var statearr_27536_27666 = state_27513;
(statearr_27536_27666[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27513[(4)]))){
var statearr_27537_27667 = state_27513;
(statearr_27537_27667[(1)] = cljs.core.first((state_27513[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27668 = state_27513;
state_27513 = G__27668;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27513){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27538 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27538[(6)] = c__2755__auto__);

return statearr_27538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_27573){
var state_val_27574 = (state_27573[(1)]);
if((state_val_27574 === (7))){
var inst_27552 = typeof pred === 'string';
var state_27573__$1 = state_27573;
if(cljs.core.truth_(inst_27552)){
var statearr_27575_27669 = state_27573__$1;
(statearr_27575_27669[(1)] = (10));

} else {
var statearr_27576_27670 = state_27573__$1;
(statearr_27576_27670[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (1))){
var state_27573__$1 = state_27573;
var statearr_27577_27671 = state_27573__$1;
(statearr_27577_27671[(2)] = null);

(statearr_27577_27671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (4))){
var inst_27539 = (state_27573[(2)]);
var state_27573__$1 = state_27573;
var statearr_27578_27672 = state_27573__$1;
(statearr_27578_27672[(2)] = inst_27539);

(statearr_27578_27672[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (15))){
var inst_27566 = (state_27573[(2)]);
var state_27573__$1 = state_27573;
var statearr_27579_27673 = state_27573__$1;
(statearr_27579_27673[(2)] = inst_27566);

(statearr_27579_27673[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (13))){
var inst_27557 = (state_27573[(7)]);
var inst_27559 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27557),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27560 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_27559);
var state_27573__$1 = state_27573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27573__$1,(16),inst_27560);
} else {
if((state_val_27574 === (6))){
var inst_27547 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_27573__$1 = state_27573;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27573__$1,(9),inst_27547);
} else {
if((state_val_27574 === (3))){
var inst_27571 = (state_27573[(2)]);
var state_27573__$1 = state_27573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27573__$1,inst_27571);
} else {
if((state_val_27574 === (12))){
var inst_27557 = (state_27573[(7)]);
var inst_27557__$1 = (state_27573[(2)]);
var state_27573__$1 = (function (){var statearr_27580 = state_27573;
(statearr_27580[(7)] = inst_27557__$1);

return statearr_27580;
})();
if(cljs.core.truth_(inst_27557__$1)){
var statearr_27581_27674 = state_27573__$1;
(statearr_27581_27674[(1)] = (13));

} else {
var statearr_27582_27675 = state_27573__$1;
(statearr_27582_27675[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (2))){
var _ = (function (){var statearr_27583 = state_27573;
(statearr_27583[(4)] = cljs.core.cons((5),(state_27573[(4)])));

return statearr_27583;
})();
var inst_27545 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27573__$1 = state_27573;
if(inst_27545){
var statearr_27584_27676 = state_27573__$1;
(statearr_27584_27676[(1)] = (6));

} else {
var statearr_27585_27677 = state_27573__$1;
(statearr_27585_27677[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (11))){
var inst_27555 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27573__$1 = state_27573;
var statearr_27587_27678 = state_27573__$1;
(statearr_27587_27678[(2)] = inst_27555);

(statearr_27587_27678[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (9))){
var inst_27549 = (state_27573[(2)]);
var inst_27550 = fluree.db.util.async.throw_err(inst_27549);
var state_27573__$1 = state_27573;
var statearr_27588_27679 = state_27573__$1;
(statearr_27588_27679[(2)] = inst_27550);

(statearr_27588_27679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (5))){
var _ = (function (){var statearr_27589 = state_27573;
(statearr_27589[(4)] = cljs.core.rest((state_27573[(4)])));

return statearr_27589;
})();
var state_27573__$1 = state_27573;
var ex27586 = (state_27573__$1[(2)]);
var statearr_27590_27680 = state_27573__$1;
(statearr_27590_27680[(5)] = ex27586);


if((ex27586 instanceof Error)){
var statearr_27591_27681 = state_27573__$1;
(statearr_27591_27681[(1)] = (4));

(statearr_27591_27681[(5)] = null);

} else {
throw ex27586;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (14))){
var state_27573__$1 = state_27573;
var statearr_27592_27682 = state_27573__$1;
(statearr_27592_27682[(2)] = null);

(statearr_27592_27682[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (16))){
var inst_27562 = (state_27573[(2)]);
var inst_27563 = fluree.db.util.async.throw_err(inst_27562);
var state_27573__$1 = state_27573;
var statearr_27593_27683 = state_27573__$1;
(statearr_27593_27683[(2)] = inst_27563);

(statearr_27593_27683[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (10))){
var state_27573__$1 = state_27573;
var statearr_27594_27684 = state_27573__$1;
(statearr_27594_27684[(2)] = pred);

(statearr_27594_27684[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27574 === (8))){
var inst_27568 = (state_27573[(2)]);
var _ = (function (){var statearr_27595 = state_27573;
(statearr_27595[(4)] = cljs.core.rest((state_27573[(4)])));

return statearr_27595;
})();
var state_27573__$1 = state_27573;
var statearr_27596_27685 = state_27573__$1;
(statearr_27596_27685[(2)] = inst_27568);

(statearr_27596_27685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2733__auto__ = null;
var fluree$db$graphdb$state_machine__2733__auto____0 = (function (){
var statearr_27597 = [null,null,null,null,null,null,null,null];
(statearr_27597[(0)] = fluree$db$graphdb$state_machine__2733__auto__);

(statearr_27597[(1)] = (1));

return statearr_27597;
});
var fluree$db$graphdb$state_machine__2733__auto____1 = (function (state_27573){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_27573);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e27598){var ex__2736__auto__ = e27598;
var statearr_27599_27686 = state_27573;
(statearr_27599_27686[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_27573[(4)]))){
var statearr_27600_27687 = state_27573;
(statearr_27600_27687[(1)] = cljs.core.first((state_27573[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27688 = state_27573;
state_27573 = G__27688;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2733__auto__ = function(state_27573){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2733__auto____1.call(this,state_27573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2733__auto____0;
fluree$db$graphdb$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2733__auto____1;
return fluree$db$graphdb$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_27601 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_27601[(6)] = c__2755__auto__);

return statearr_27601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27270){
var extmap__4512__auto__ = (function (){var G__27602 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27270,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27270)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27602);
} else {
return G__27602;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27270),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27270),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
