// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18803 = arguments.length;
switch (G__18803) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18806 = arguments.length;
switch (G__18806) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___18859 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18837){
var state_val_18838 = (state_18837[(1)]);
if((state_val_18838 === (1))){
var state_18837__$1 = state_18837;
var statearr_18839_18860 = state_18837__$1;
(statearr_18839_18860[(2)] = null);

(statearr_18839_18860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18838 === (2))){
var _ = (function (){var statearr_18840 = state_18837;
(statearr_18840[(4)] = cljs.core.cons((5),(state_18837[(4)])));

return statearr_18840;
})();
var inst_18814 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_18837__$1 = state_18837;
if(cljs.core.truth_(inst_18814)){
var statearr_18841_18861 = state_18837__$1;
(statearr_18841_18861[(1)] = (6));

} else {
var statearr_18842_18862 = state_18837__$1;
(statearr_18842_18862[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18838 === (3))){
var inst_18835 = (state_18837[(2)]);
var state_18837__$1 = state_18837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18837__$1,inst_18835);
} else {
if((state_val_18838 === (4))){
var inst_18807 = (state_18837[(2)]);
var inst_18808 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_18807);
var state_18837__$1 = state_18837;
var statearr_18844_18863 = state_18837__$1;
(statearr_18844_18863[(2)] = inst_18808);

(statearr_18844_18863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18838 === (5))){
var _ = (function (){var statearr_18845 = state_18837;
(statearr_18845[(4)] = cljs.core.rest((state_18837[(4)])));

return statearr_18845;
})();
var state_18837__$1 = state_18837;
var ex18843 = (state_18837__$1[(2)]);
var statearr_18846_18864 = state_18837__$1;
(statearr_18846_18864[(5)] = ex18843);


var statearr_18847_18865 = state_18837__$1;
(statearr_18847_18865[(1)] = (4));

(statearr_18847_18865[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18838 === (6))){
var inst_18816 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18817 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18818 = cljs.core.PersistentHashMap.fromArrays(inst_18816,inst_18817);
var inst_18819 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_18818);
var inst_18820 = (function(){throw inst_18819})();
var state_18837__$1 = state_18837;
var statearr_18848_18866 = state_18837__$1;
(statearr_18848_18866[(2)] = inst_18820);

(statearr_18848_18866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18838 === (7))){
var inst_18822 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18824 = [operation,data,pc,opts];
var inst_18825 = (new cljs.core.PersistentVector(null,4,(5),inst_18823,inst_18824,null));
var inst_18826 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18822,inst_18825);
var inst_18827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18828 = [operation,data,pc,opts];
var inst_18829 = (new cljs.core.PersistentVector(null,4,(5),inst_18827,inst_18828,null));
var inst_18830 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_18829], 0));
var state_18837__$1 = (function (){var statearr_18849 = state_18837;
(statearr_18849[(7)] = inst_18826);

return statearr_18849;
})();
var statearr_18850_18867 = state_18837__$1;
(statearr_18850_18867[(2)] = inst_18830);

(statearr_18850_18867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18838 === (8))){
var inst_18832 = (state_18837[(2)]);
var _ = (function (){var statearr_18851 = state_18837;
(statearr_18851[(4)] = cljs.core.rest((state_18837[(4)])));

return statearr_18851;
})();
var state_18837__$1 = state_18837;
var statearr_18852_18868 = state_18837__$1;
(statearr_18852_18868[(2)] = inst_18832);

(statearr_18852_18868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2733__auto__ = null;
var fluree$db$operations$state_machine__2733__auto____0 = (function (){
var statearr_18853 = [null,null,null,null,null,null,null,null];
(statearr_18853[(0)] = fluree$db$operations$state_machine__2733__auto__);

(statearr_18853[(1)] = (1));

return statearr_18853;
});
var fluree$db$operations$state_machine__2733__auto____1 = (function (state_18837){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18837);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18854){var ex__2736__auto__ = e18854;
var statearr_18855_18869 = state_18837;
(statearr_18855_18869[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18837[(4)]))){
var statearr_18856_18870 = state_18837;
(statearr_18856_18870[(1)] = cljs.core.first((state_18837[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18871 = state_18837;
state_18837 = G__18871;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2733__auto__ = function(state_18837){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2733__auto____1.call(this,state_18837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2733__auto____0;
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2733__auto____1;
return fluree$db$operations$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18857 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18857[(6)] = c__2755__auto___18859);

return statearr_18857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18873 = arguments.length;
switch (G__18873) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18874){
var map__18875 = p__18874;
var map__18875__$1 = cljs.core.__destructure_map(map__18875);
var opts = map__18875__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18875__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18876 = session;
var map__18876__$1 = cljs.core.__destructure_map(map__18876);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18876__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18876__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18876__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4835__auto__ = [];
var len__4829__auto___18903 = arguments.length;
var i__4830__auto___18904 = (0);
while(true){
if((i__4830__auto___18904 < len__4829__auto___18903)){
args__4835__auto__.push((arguments[i__4830__auto___18904]));

var G__18905 = (i__4830__auto___18904 + (1));
i__4830__auto___18904 = G__18905;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18880){
var vec__18881 = p__18880;
var map__18884 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18881,(0),null);
var map__18884__$1 = cljs.core.__destructure_map(map__18884);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18884__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18884__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18881;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_18896){
var state_val_18897 = (state_18896[(1)]);
if((state_val_18897 === (1))){
var inst_18886 = session;
var inst_18887 = cljs.core.__destructure_map(inst_18886);
var inst_18888 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18887,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18887,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18887,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18891 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18892 = [inst_18888,inst_18889,toBlock,toTime];
var inst_18893 = cljs.core.PersistentHashMap.fromArrays(inst_18891,inst_18892);
var inst_18894 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_18890,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18893);
var state_18896__$1 = state_18896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18896__$1,inst_18894);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2733__auto__ = null;
var fluree$db$operations$state_machine__2733__auto____0 = (function (){
var statearr_18898 = [null,null,null,null,null,null,null];
(statearr_18898[(0)] = fluree$db$operations$state_machine__2733__auto__);

(statearr_18898[(1)] = (1));

return statearr_18898;
});
var fluree$db$operations$state_machine__2733__auto____1 = (function (state_18896){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_18896);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e18899){var ex__2736__auto__ = e18899;
var statearr_18900_18906 = state_18896;
(statearr_18900_18906[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_18896[(4)]))){
var statearr_18901_18907 = state_18896;
(statearr_18901_18907[(1)] = cljs.core.first((state_18896[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18908 = state_18896;
state_18896 = G__18908;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2733__auto__ = function(state_18896){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2733__auto____1.call(this,state_18896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2733__auto____0;
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2733__auto____1;
return fluree$db$operations$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_18902 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_18902[(6)] = c__2755__auto__);

return statearr_18902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18878){
var G__18879 = cljs.core.first(seq18878);
var seq18878__$1 = cljs.core.next(seq18878);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18879,seq18878__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18909 = session;
var map__18909__$1 = cljs.core.__destructure_map(map__18909);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18909__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18909__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18909__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18911 = arguments.length;
switch (G__18911) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18912 = opts;
var map__18912__$1 = cljs.core.__destructure_map(map__18912);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18912__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18912__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4223__auto__ = auth;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
