// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22152 = arguments.length;
switch (G__22152) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__22153 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__22153) : f.call(null,G__22153));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__22154 = cljs.core._deref(vol);
var G__22155 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22154,G__22155) : f.call(null,G__22154,G__22155));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__22156 = cljs.core._deref(vol);
var G__22157 = arg1;
var G__22158 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__22156,G__22157,G__22158) : f.call(null,G__22156,G__22157,G__22158));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__22159 = cljs.core._deref(vol);
var G__22160 = arg1;
var G__22161 = arg2;
var G__22162 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__22159,G__22160,G__22161,G__22162) : f.call(null,G__22159,G__22160,G__22161,G__22162));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22165 = arguments.length;
switch (G__22165) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22167 = null;
var G__22167__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22167__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22167__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22167 = function(result,flake){
switch(arguments.length){
case 0:
return G__22167__0.call(this);
case 1:
return G__22167__1.call(this,result);
case 2:
return G__22167__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22167.cljs$core$IFn$_invoke$arity$0 = G__22167__0;
G__22167.cljs$core$IFn$_invoke$arity$1 = G__22167__1;
G__22167.cljs$core$IFn$_invoke$arity$2 = G__22167__2;
return G__22167;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22168 = null;
var G__22168__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22168__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22168__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22168 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22168__0.call(this);
case 1:
return G__22168__1.call(this,result);
case 2:
return G__22168__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22168.cljs$core$IFn$_invoke$arity$0 = G__22168__0;
G__22168.cljs$core$IFn$_invoke$arity$1 = G__22168__1;
G__22168.cljs$core$IFn$_invoke$arity$2 = G__22168__2;
return G__22168;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22170 = res;
var G__22170__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22169_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22169_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22170):G__22170);
var G__22170__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22170__$1):G__22170__$1);
var G__22170__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22170__$2):G__22170__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22170__$3);
} else {
return G__22170__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22174 = arguments.length;
switch (G__22174) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_22546){
var state_val_22547 = (state_22546[(1)]);
if((state_val_22547 === (65))){
var inst_22328 = (state_22546[(2)]);
var inst_22329 = fluree.db.util.async.throw_err(inst_22328);
var state_22546__$1 = (function (){var statearr_22548 = state_22546;
(statearr_22548[(7)] = inst_22329);

return statearr_22548;
})();
if(cljs.core.truth_(fuel)){
var statearr_22549_22734 = state_22546__$1;
(statearr_22549_22734[(1)] = (66));

} else {
var statearr_22550_22735 = state_22546__$1;
(statearr_22550_22735[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (70))){
var inst_22352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22360 = flakes;
var inst_22361 = cljs.core.seq(inst_22360);
var inst_22362 = cljs.core.first(inst_22361);
var inst_22363 = cljs.core.next(inst_22361);
var inst_22364 = cljs.core.PersistentVector.EMPTY;
var inst_22365 = inst_22360;
var inst_22366 = inst_22364;
var state_22546__$1 = (function (){var statearr_22551 = state_22546;
(statearr_22551[(8)] = inst_22363);

(statearr_22551[(9)] = inst_22362);

(statearr_22551[(10)] = inst_22365);

(statearr_22551[(11)] = inst_22366);

(statearr_22551[(12)] = inst_22352);

return statearr_22551;
})();
var statearr_22552_22736 = state_22546__$1;
(statearr_22552_22736[(2)] = null);

(statearr_22552_22736[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (62))){
var inst_22319 = (state_22546[(13)]);
var inst_22322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22323 = inst_22319.o;
var inst_22324 = [inst_22323];
var inst_22325 = (new cljs.core.PersistentVector(null,1,(5),inst_22322,inst_22324,null));
var inst_22326 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22325);
var state_22546__$1 = state_22546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22546__$1,(65),inst_22326);
} else {
if((state_val_22547 === (74))){
var inst_22352 = (state_22546[(12)]);
var inst_22408 = (state_22546[(2)]);
var inst_22409 = [inst_22408,offset_map];
var inst_22410 = (new cljs.core.PersistentVector(null,2,(5),inst_22352,inst_22409,null));
var state_22546__$1 = state_22546;
var statearr_22553_22737 = state_22546__$1;
(statearr_22553_22737[(2)] = inst_22410);

(statearr_22553_22737[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (110))){
var inst_22516 = (state_22546[(14)]);
var inst_22519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22520 = [acc,inst_22516];
var inst_22521 = (new cljs.core.PersistentVector(null,2,(5),inst_22519,inst_22520,null));
var state_22546__$1 = state_22546;
var statearr_22554_22738 = state_22546__$1;
(statearr_22554_22738[(2)] = inst_22521);

(statearr_22554_22738[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (7))){
var inst_22186 = (state_22546[(15)]);
var state_22546__$1 = state_22546;
var statearr_22555_22739 = state_22546__$1;
(statearr_22555_22739[(2)] = inst_22186);

(statearr_22555_22739[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (59))){
var inst_22510 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22556_22740 = state_22546__$1;
(statearr_22556_22740[(2)] = inst_22510);

(statearr_22556_22740[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (86))){
var inst_22412 = (state_22546[(16)]);
var state_22546__$1 = state_22546;
var statearr_22557_22741 = state_22546__$1;
(statearr_22557_22741[(2)] = inst_22412);

(statearr_22557_22741[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (20))){
var inst_22227 = (state_22546[(17)]);
var inst_22228 = (state_22546[(18)]);
var inst_22215 = (state_22546[(19)]);
var inst_22226 = (state_22546[(2)]);
var inst_22227__$1 = cljs.core.__destructure_map(inst_22215);
var inst_22228__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22227__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22229 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22227__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22230 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22227__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22231 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22227__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22227__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22227__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22546__$1 = (function (){var statearr_22558 = state_22546;
(statearr_22558[(20)] = inst_22230);

(statearr_22558[(17)] = inst_22227__$1);

(statearr_22558[(21)] = inst_22232);

(statearr_22558[(22)] = inst_22231);

(statearr_22558[(18)] = inst_22228__$1);

(statearr_22558[(23)] = inst_22229);

(statearr_22558[(24)] = inst_22233);

(statearr_22558[(25)] = inst_22226);

return statearr_22558;
})();
if(cljs.core.truth_(inst_22228__$1)){
var statearr_22559_22742 = state_22546__$1;
(statearr_22559_22742[(1)] = (24));

} else {
var statearr_22560_22743 = state_22546__$1;
(statearr_22560_22743[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (72))){
var inst_22508 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22561_22744 = state_22546__$1;
(statearr_22561_22744[(2)] = inst_22508);

(statearr_22561_22744[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (58))){
var inst_22215 = (state_22546[(19)]);
var inst_22350 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22215);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22350)){
var statearr_22562_22745 = state_22546__$1;
(statearr_22562_22745[(1)] = (70));

} else {
var statearr_22563_22746 = state_22546__$1;
(statearr_22563_22746[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (60))){
var inst_22319 = (state_22546[(13)]);
var inst_22312 = (state_22546[(26)]);
var inst_22318 = cljs.core.seq(inst_22312);
var inst_22319__$1 = cljs.core.first(inst_22318);
var inst_22320 = cljs.core.next(inst_22318);
var state_22546__$1 = (function (){var statearr_22564 = state_22546;
(statearr_22564[(27)] = inst_22320);

(statearr_22564[(13)] = inst_22319__$1);

return statearr_22564;
})();
if(cljs.core.truth_(inst_22319__$1)){
var statearr_22565_22747 = state_22546__$1;
(statearr_22565_22747[(1)] = (62));

} else {
var statearr_22566_22748 = state_22546__$1;
(statearr_22566_22748[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (27))){
var inst_22232 = (state_22546[(21)]);
var inst_22236 = (state_22546[(28)]);
var inst_22236__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22232);
var state_22546__$1 = (function (){var statearr_22567 = state_22546;
(statearr_22567[(28)] = inst_22236__$1);

return statearr_22567;
})();
if(inst_22236__$1){
var statearr_22568_22749 = state_22546__$1;
(statearr_22568_22749[(1)] = (30));

} else {
var statearr_22569_22750 = state_22546__$1;
(statearr_22569_22750[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (1))){
var state_22546__$1 = state_22546;
var statearr_22570_22751 = state_22546__$1;
(statearr_22570_22751[(2)] = null);

(statearr_22570_22751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (69))){
var inst_22320 = (state_22546[(27)]);
var inst_22313 = (state_22546[(29)]);
var inst_22338 = (state_22546[(2)]);
var inst_22339 = fluree.db.util.async.throw_err(inst_22338);
var inst_22340 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22313,inst_22339);
var inst_22312 = inst_22320;
var inst_22313__$1 = inst_22340;
var state_22546__$1 = (function (){var statearr_22571 = state_22546;
(statearr_22571[(26)] = inst_22312);

(statearr_22571[(29)] = inst_22313__$1);

return statearr_22571;
})();
var statearr_22572_22752 = state_22546__$1;
(statearr_22572_22752[(2)] = null);

(statearr_22572_22752[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (101))){
var inst_22453 = (state_22546[(30)]);
var inst_22473 = cljs.core.count(inst_22453);
var inst_22474 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22473);
var state_22546__$1 = state_22546;
var statearr_22573_22753 = state_22546__$1;
(statearr_22573_22753[(2)] = inst_22474);

(statearr_22573_22753[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (24))){
var inst_22232 = (state_22546[(21)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22232)){
var statearr_22574_22754 = state_22546__$1;
(statearr_22574_22754[(1)] = (27));

} else {
var statearr_22575_22755 = state_22546__$1;
(statearr_22575_22755[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (102))){
var state_22546__$1 = state_22546;
var statearr_22576_22756 = state_22546__$1;
(statearr_22576_22756[(2)] = null);

(statearr_22576_22756[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (55))){
var inst_22215 = (state_22546[(19)]);
var inst_22288 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22215);
var state_22546__$1 = state_22546;
var statearr_22577_22757 = state_22546__$1;
(statearr_22577_22757[(2)] = inst_22288);

(statearr_22577_22757[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (85))){
var inst_22215 = (state_22546[(19)]);
var inst_22414 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22215);
var state_22546__$1 = state_22546;
var statearr_22578_22758 = state_22546__$1;
(statearr_22578_22758[(2)] = inst_22414);

(statearr_22578_22758[(1)] = (87));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (39))){
var inst_22231 = (state_22546[(22)]);
var inst_22263 = (state_22546[(31)]);
var inst_22263__$1 = cljs.core.not(inst_22231);
var state_22546__$1 = (function (){var statearr_22579 = state_22546;
(statearr_22579[(31)] = inst_22263__$1);

return statearr_22579;
})();
if(inst_22263__$1){
var statearr_22580_22759 = state_22546__$1;
(statearr_22580_22759[(1)] = (42));

} else {
var statearr_22581_22760 = state_22546__$1;
(statearr_22581_22760[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (88))){
var inst_22419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22427 = flakes;
var inst_22428 = cljs.core.seq(inst_22427);
var inst_22429 = cljs.core.first(inst_22428);
var inst_22430 = cljs.core.next(inst_22428);
var inst_22431 = cljs.core.PersistentVector.EMPTY;
var inst_22432 = inst_22427;
var inst_22433 = inst_22431;
var state_22546__$1 = (function (){var statearr_22582 = state_22546;
(statearr_22582[(32)] = inst_22419);

(statearr_22582[(33)] = inst_22430);

(statearr_22582[(34)] = inst_22429);

(statearr_22582[(35)] = inst_22432);

(statearr_22582[(36)] = inst_22433);

return statearr_22582;
})();
var statearr_22583_22761 = state_22546__$1;
(statearr_22583_22761[(2)] = null);

(statearr_22583_22761[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (46))){
var inst_22230 = (state_22546[(20)]);
var state_22546__$1 = state_22546;
var statearr_22584_22762 = state_22546__$1;
(statearr_22584_22762[(2)] = inst_22230);

(statearr_22584_22762[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (4))){
var inst_22175 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22585_22763 = state_22546__$1;
(statearr_22585_22763[(2)] = inst_22175);

(statearr_22585_22763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (77))){
var inst_22406 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22586_22764 = state_22546__$1;
(statearr_22586_22764[(2)] = inst_22406);

(statearr_22586_22764[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (106))){
var inst_22504 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22587_22765 = state_22546__$1;
(statearr_22587_22765[(2)] = inst_22504);

(statearr_22587_22765[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (95))){
var inst_22481 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22588_22766 = state_22546__$1;
(statearr_22588_22766[(2)] = inst_22481);

(statearr_22588_22766[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (54))){
var inst_22285 = (state_22546[(37)]);
var state_22546__$1 = state_22546;
var statearr_22589_22767 = state_22546__$1;
(statearr_22589_22767[(2)] = inst_22285);

(statearr_22589_22767[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (92))){
var inst_22419 = (state_22546[(32)]);
var inst_22483 = (state_22546[(2)]);
var inst_22484 = [inst_22483,offset_map];
var inst_22485 = (new cljs.core.PersistentVector(null,2,(5),inst_22419,inst_22484,null));
var state_22546__$1 = state_22546;
var statearr_22590_22768 = state_22546__$1;
(statearr_22590_22768[(2)] = inst_22485);

(statearr_22590_22768[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (104))){
var inst_22230 = (state_22546[(20)]);
var inst_22227 = (state_22546[(17)]);
var inst_22232 = (state_22546[(21)]);
var inst_22231 = (state_22546[(22)]);
var inst_22185 = (state_22546[(38)]);
var inst_22228 = (state_22546[(18)]);
var inst_22200 = (state_22546[(39)]);
var inst_22229 = (state_22546[(23)]);
var inst_22233 = (state_22546[(24)]);
var inst_22215 = (state_22546[(19)]);
var inst_22226 = (state_22546[(25)]);
var inst_22488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22489 = (function (){var map__22181 = inst_22227;
var p = inst_22233;
var pred_spec__$1 = inst_22200;
var orderBy = inst_22231;
var multi_QMARK_ = inst_22228;
var limit = inst_22230;
var offset = inst_22232;
var k = inst_22226;
var compact_QMARK_ = inst_22185;
var pred_spec_SINGLEQUOTE_ = inst_22215;
var ref_QMARK_ = inst_22229;
return (function (p1__22171_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22171_SHARP_.o]);
});
})();
var inst_22490 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22489,flakes);
var inst_22491 = [inst_22490,offset_map];
var inst_22492 = (new cljs.core.PersistentVector(null,2,(5),inst_22488,inst_22491,null));
var state_22546__$1 = state_22546;
var statearr_22591_22769 = state_22546__$1;
(statearr_22591_22769[(2)] = inst_22492);

(statearr_22591_22769[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (15))){
var inst_22185 = (state_22546[(38)]);
var inst_22208 = (state_22546[(40)]);
var inst_22212 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22208,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22185);
var state_22546__$1 = state_22546;
var statearr_22592_22770 = state_22546__$1;
(statearr_22592_22770[(2)] = inst_22212);

(statearr_22592_22770[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (48))){
var inst_22279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22280 = [null,offset_map];
var inst_22281 = (new cljs.core.PersistentVector(null,2,(5),inst_22279,inst_22280,null));
var state_22546__$1 = state_22546;
var statearr_22593_22771 = state_22546__$1;
(statearr_22593_22771[(2)] = inst_22281);

(statearr_22593_22771[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (50))){
var inst_22512 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22594_22772 = state_22546__$1;
(statearr_22594_22772[(2)] = inst_22512);

(statearr_22594_22772[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (116))){
var inst_22515 = (state_22546[(41)]);
var inst_22516 = (state_22546[(14)]);
var inst_22226 = (state_22546[(25)]);
var inst_22530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22531 = cljs.core.first(inst_22515);
var inst_22532 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22226,inst_22531);
var inst_22533 = [inst_22532,inst_22516];
var inst_22534 = (new cljs.core.PersistentVector(null,2,(5),inst_22530,inst_22533,null));
var state_22546__$1 = state_22546;
var statearr_22595_22773 = state_22546__$1;
(statearr_22595_22773[(2)] = inst_22534);

(statearr_22595_22773[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (75))){
var inst_22381 = (state_22546[(42)]);
var inst_22215 = (state_22546[(19)]);
var inst_22372 = (state_22546[(43)]);
var inst_22375 = cljs.core.deref(cache);
var inst_22376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22377 = inst_22372.o;
var inst_22378 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22215);
var inst_22379 = [inst_22377,inst_22378];
var inst_22380 = (new cljs.core.PersistentVector(null,2,(5),inst_22376,inst_22379,null));
var inst_22381__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22375,inst_22380);
var state_22546__$1 = (function (){var statearr_22596 = state_22546;
(statearr_22596[(42)] = inst_22381__$1);

return statearr_22596;
})();
if(cljs.core.truth_(inst_22381__$1)){
var statearr_22597_22774 = state_22546__$1;
(statearr_22597_22774[(1)] = (78));

} else {
var statearr_22598_22775 = state_22546__$1;
(statearr_22598_22775[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (99))){
var inst_22471 = (state_22546[(2)]);
var state_22546__$1 = (function (){var statearr_22599 = state_22546;
(statearr_22599[(44)] = inst_22471);

return statearr_22599;
})();
if(cljs.core.truth_(fuel)){
var statearr_22600_22776 = state_22546__$1;
(statearr_22600_22776[(1)] = (101));

} else {
var statearr_22601_22777 = state_22546__$1;
(statearr_22601_22777[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (21))){
var inst_22219 = (state_22546[(45)]);
var state_22546__$1 = state_22546;
var statearr_22602_22778 = state_22546__$1;
(statearr_22602_22778[(2)] = inst_22219);

(statearr_22602_22778[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (31))){
var inst_22236 = (state_22546[(28)]);
var state_22546__$1 = state_22546;
var statearr_22603_22779 = state_22546__$1;
(statearr_22603_22779[(2)] = inst_22236);

(statearr_22603_22779[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (113))){
var inst_22515 = (state_22546[(41)]);
var inst_22516 = (state_22546[(14)]);
var inst_22226 = (state_22546[(25)]);
var inst_22524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22525 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22226,inst_22515);
var inst_22526 = [inst_22525,inst_22516];
var inst_22527 = (new cljs.core.PersistentVector(null,2,(5),inst_22524,inst_22526,null));
var state_22546__$1 = state_22546;
var statearr_22604_22780 = state_22546__$1;
(statearr_22604_22780[(2)] = inst_22527);

(statearr_22604_22780[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (32))){
var inst_22242 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22605_22781 = state_22546__$1;
(statearr_22605_22781[(2)] = inst_22242);

(statearr_22605_22781[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (40))){
var inst_22228 = (state_22546[(18)]);
var state_22546__$1 = state_22546;
var statearr_22606_22782 = state_22546__$1;
(statearr_22606_22782[(2)] = inst_22228);

(statearr_22606_22782[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (91))){
var inst_22439 = (state_22546[(46)]);
var inst_22432 = (state_22546[(35)]);
var inst_22438 = cljs.core.seq(inst_22432);
var inst_22439__$1 = cljs.core.first(inst_22438);
var inst_22440 = cljs.core.next(inst_22438);
var state_22546__$1 = (function (){var statearr_22607 = state_22546;
(statearr_22607[(46)] = inst_22439__$1);

(statearr_22607[(47)] = inst_22440);

return statearr_22607;
})();
if(cljs.core.truth_(inst_22439__$1)){
var statearr_22608_22783 = state_22546__$1;
(statearr_22608_22783[(1)] = (93));

} else {
var statearr_22609_22784 = state_22546__$1;
(statearr_22609_22784[(1)] = (94));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (117))){
var state_22546__$1 = state_22546;
var statearr_22610_22785 = state_22546__$1;
(statearr_22610_22785[(2)] = null);

(statearr_22610_22785[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (108))){
var state_22546__$1 = state_22546;
var statearr_22611_22786 = state_22546__$1;
(statearr_22611_22786[(2)] = null);

(statearr_22611_22786[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (56))){
var inst_22290 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22612_22787 = state_22546__$1;
(statearr_22612_22787[(2)] = inst_22290);

(statearr_22612_22787[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (33))){
var inst_22233 = (state_22546[(24)]);
var inst_22250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22233);
var state_22546__$1 = (function (){var statearr_22613 = state_22546;
(statearr_22613[(48)] = inst_22250);

return statearr_22613;
})();
if(cljs.core.truth_(inst_22251)){
var statearr_22614_22788 = state_22546__$1;
(statearr_22614_22788[(1)] = (36));

} else {
var statearr_22615_22789 = state_22546__$1;
(statearr_22615_22789[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (13))){
var inst_22200 = (state_22546[(39)]);
var state_22546__$1 = state_22546;
var statearr_22616_22790 = state_22546__$1;
(statearr_22616_22790[(2)] = inst_22200);

(statearr_22616_22790[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (22))){
var inst_22215 = (state_22546[(19)]);
var inst_22222 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22215);
var state_22546__$1 = state_22546;
var statearr_22617_22791 = state_22546__$1;
(statearr_22617_22791[(2)] = inst_22222);

(statearr_22617_22791[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (90))){
var inst_22506 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22618_22792 = state_22546__$1;
(statearr_22618_22792[(2)] = inst_22506);

(statearr_22618_22792[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (109))){
var inst_22502 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22619_22793 = state_22546__$1;
(statearr_22619_22793[(2)] = inst_22502);

(statearr_22619_22793[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (36))){
var inst_22233 = (state_22546[(24)]);
var inst_22253 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22233,cljs.core.dec);
var state_22546__$1 = state_22546;
var statearr_22620_22794 = state_22546__$1;
(statearr_22620_22794[(2)] = inst_22253);

(statearr_22620_22794[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (41))){
var inst_22277 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22277)){
var statearr_22621_22795 = state_22546__$1;
(statearr_22621_22795[(1)] = (48));

} else {
var statearr_22622_22796 = state_22546__$1;
(statearr_22622_22796[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (118))){
var inst_22537 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22623_22797 = state_22546__$1;
(statearr_22623_22797[(2)] = inst_22537);

(statearr_22623_22797[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (89))){
var inst_22229 = (state_22546[(23)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22229)){
var statearr_22624_22798 = state_22546__$1;
(statearr_22624_22798[(1)] = (104));

} else {
var statearr_22625_22799 = state_22546__$1;
(statearr_22625_22799[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (100))){
var inst_22433 = (state_22546[(36)]);
var inst_22467 = (state_22546[(2)]);
var inst_22468 = fluree.db.util.async.throw_err(inst_22467);
var inst_22469 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22433,inst_22468);
var state_22546__$1 = state_22546;
var statearr_22626_22800 = state_22546__$1;
(statearr_22626_22800[(2)] = inst_22469);

(statearr_22626_22800[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (43))){
var inst_22263 = (state_22546[(31)]);
var state_22546__$1 = state_22546;
var statearr_22627_22801 = state_22546__$1;
(statearr_22627_22801[(2)] = inst_22263);

(statearr_22627_22801[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (61))){
var inst_22299 = (state_22546[(49)]);
var inst_22346 = (state_22546[(2)]);
var inst_22347 = [inst_22346,offset_map];
var inst_22348 = (new cljs.core.PersistentVector(null,2,(5),inst_22299,inst_22347,null));
var state_22546__$1 = state_22546;
var statearr_22628_22802 = state_22546__$1;
(statearr_22628_22802[(2)] = inst_22348);

(statearr_22628_22802[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (29))){
var inst_22245 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22629_22803 = state_22546__$1;
(statearr_22629_22803[(2)] = inst_22245);

(statearr_22629_22803[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (44))){
var inst_22274 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22630_22804 = state_22546__$1;
(statearr_22630_22804[(2)] = inst_22274);

(statearr_22630_22804[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (93))){
var inst_22439 = (state_22546[(46)]);
var inst_22215 = (state_22546[(19)]);
var inst_22442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22443 = inst_22439.o;
var inst_22444 = [inst_22443];
var inst_22445 = (new cljs.core.PersistentVector(null,1,(5),inst_22442,inst_22444,null));
var inst_22446 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22447 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22215);
var inst_22448 = [inst_22447];
var inst_22449 = cljs.core.PersistentHashMap.fromArrays(inst_22446,inst_22448);
var inst_22450 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22445,inst_22449);
var state_22546__$1 = state_22546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22546__$1,(96),inst_22450);
} else {
if((state_val_22547 === (6))){
var inst_22188 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22189 = (inst_22188 == null);
var state_22546__$1 = state_22546;
var statearr_22631_22805 = state_22546__$1;
(statearr_22631_22805[(2)] = inst_22189);

(statearr_22631_22805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (111))){
var inst_22228 = (state_22546[(18)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22228)){
var statearr_22632_22806 = state_22546__$1;
(statearr_22632_22806[(1)] = (113));

} else {
var statearr_22633_22807 = state_22546__$1;
(statearr_22633_22807[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (28))){
var inst_22232 = (state_22546[(21)]);
var state_22546__$1 = state_22546;
var statearr_22634_22808 = state_22546__$1;
(statearr_22634_22808[(2)] = inst_22232);

(statearr_22634_22808[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (64))){
var inst_22344 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22635_22809 = state_22546__$1;
(statearr_22635_22809[(2)] = inst_22344);

(statearr_22635_22809[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (103))){
var inst_22471 = (state_22546[(44)]);
var inst_22440 = (state_22546[(47)]);
var inst_22477 = (state_22546[(2)]);
var inst_22432 = inst_22440;
var inst_22433 = inst_22471;
var state_22546__$1 = (function (){var statearr_22636 = state_22546;
(statearr_22636[(50)] = inst_22477);

(statearr_22636[(35)] = inst_22432);

(statearr_22636[(36)] = inst_22433);

return statearr_22636;
})();
var statearr_22637_22810 = state_22546__$1;
(statearr_22637_22810[(2)] = null);

(statearr_22637_22810[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (51))){
var inst_22285 = (state_22546[(37)]);
var inst_22215 = (state_22546[(19)]);
var inst_22285__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22215);
var state_22546__$1 = (function (){var statearr_22638 = state_22546;
(statearr_22638[(37)] = inst_22285__$1);

return statearr_22638;
})();
if(cljs.core.truth_(inst_22285__$1)){
var statearr_22639_22811 = state_22546__$1;
(statearr_22639_22811[(1)] = (54));

} else {
var statearr_22640_22812 = state_22546__$1;
(statearr_22640_22812[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (25))){
var inst_22228 = (state_22546[(18)]);
var state_22546__$1 = state_22546;
var statearr_22641_22813 = state_22546__$1;
(statearr_22641_22813[(2)] = inst_22228);

(statearr_22641_22813[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (34))){
var inst_22228 = (state_22546[(18)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22228)){
var statearr_22642_22814 = state_22546__$1;
(statearr_22642_22814[(1)] = (39));

} else {
var statearr_22643_22815 = state_22546__$1;
(statearr_22643_22815[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (17))){
var inst_22215 = (state_22546[(19)]);
var inst_22216 = (state_22546[(51)]);
var inst_22215__$1 = (state_22546[(2)]);
var inst_22216__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22215__$1);
var state_22546__$1 = (function (){var statearr_22644 = state_22546;
(statearr_22644[(19)] = inst_22215__$1);

(statearr_22644[(51)] = inst_22216__$1);

return statearr_22644;
})();
if(cljs.core.truth_(inst_22216__$1)){
var statearr_22645_22816 = state_22546__$1;
(statearr_22645_22816[(1)] = (18));

} else {
var statearr_22646_22817 = state_22546__$1;
(statearr_22646_22817[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (3))){
var inst_22544 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22546__$1,inst_22544);
} else {
if((state_val_22547 === (12))){
var inst_22200 = (state_22546[(39)]);
var inst_22205 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22200,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22546__$1 = state_22546;
var statearr_22647_22818 = state_22546__$1;
(statearr_22647_22818[(2)] = inst_22205);

(statearr_22647_22818[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (2))){
var inst_22186 = (state_22546[(15)]);
var _ = (function (){var statearr_22648 = state_22546;
(statearr_22648[(4)] = cljs.core.cons((5),(state_22546[(4)])));

return statearr_22648;
})();
var inst_22185 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22186__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22546__$1 = (function (){var statearr_22649 = state_22546;
(statearr_22649[(38)] = inst_22185);

(statearr_22649[(15)] = inst_22186__$1);

return statearr_22649;
})();
if(cljs.core.truth_(inst_22186__$1)){
var statearr_22650_22819 = state_22546__$1;
(statearr_22650_22819[(1)] = (6));

} else {
var statearr_22651_22820 = state_22546__$1;
(statearr_22651_22820[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (66))){
var inst_22329 = (state_22546[(7)]);
var inst_22331 = cljs.core.count(inst_22329);
var inst_22332 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22331);
var state_22546__$1 = state_22546;
var statearr_22652_22821 = state_22546__$1;
(statearr_22652_22821[(2)] = inst_22332);

(statearr_22652_22821[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (107))){
var inst_22230 = (state_22546[(20)]);
var inst_22227 = (state_22546[(17)]);
var inst_22232 = (state_22546[(21)]);
var inst_22231 = (state_22546[(22)]);
var inst_22185 = (state_22546[(38)]);
var inst_22228 = (state_22546[(18)]);
var inst_22200 = (state_22546[(39)]);
var inst_22229 = (state_22546[(23)]);
var inst_22233 = (state_22546[(24)]);
var inst_22215 = (state_22546[(19)]);
var inst_22226 = (state_22546[(25)]);
var inst_22495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22496 = (function (){var map__22181 = inst_22227;
var p = inst_22233;
var pred_spec__$1 = inst_22200;
var orderBy = inst_22231;
var multi_QMARK_ = inst_22228;
var limit = inst_22230;
var offset = inst_22232;
var k = inst_22226;
var compact_QMARK_ = inst_22185;
var pred_spec_SINGLEQUOTE_ = inst_22215;
var ref_QMARK_ = inst_22229;
return (function (p1__22172_SHARP_){
return p1__22172_SHARP_.o;
});
})();
var inst_22497 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22496,flakes);
var inst_22498 = [inst_22497,offset_map];
var inst_22499 = (new cljs.core.PersistentVector(null,2,(5),inst_22495,inst_22498,null));
var state_22546__$1 = state_22546;
var statearr_22653_22822 = state_22546__$1;
(statearr_22653_22822[(2)] = inst_22499);

(statearr_22653_22822[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (23))){
var inst_22224 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22654_22823 = state_22546__$1;
(statearr_22654_22823[(2)] = inst_22224);

(statearr_22654_22823[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (47))){
var inst_22271 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22655_22824 = state_22546__$1;
(statearr_22655_22824[(2)] = inst_22271);

(statearr_22655_22824[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (35))){
var inst_22515 = (state_22546[(41)]);
var inst_22514 = (state_22546[(2)]);
var inst_22515__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22514,(0),null);
var inst_22516 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22514,(1),null);
var inst_22517 = cljs.core.empty_QMARK_(inst_22515__$1);
var state_22546__$1 = (function (){var statearr_22656 = state_22546;
(statearr_22656[(41)] = inst_22515__$1);

(statearr_22656[(14)] = inst_22516);

return statearr_22656;
})();
if(inst_22517){
var statearr_22657_22825 = state_22546__$1;
(statearr_22657_22825[(1)] = (110));

} else {
var statearr_22658_22826 = state_22546__$1;
(statearr_22658_22826[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (82))){
var inst_22397 = (state_22546[(52)]);
var inst_22366 = (state_22546[(11)]);
var inst_22399 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22366,inst_22397);
var state_22546__$1 = state_22546;
var statearr_22659_22827 = state_22546__$1;
(statearr_22659_22827[(2)] = inst_22399);

(statearr_22659_22827[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (76))){
var inst_22366 = (state_22546[(11)]);
var state_22546__$1 = state_22546;
var statearr_22660_22828 = state_22546__$1;
(statearr_22660_22828[(2)] = inst_22366);

(statearr_22660_22828[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (97))){
var inst_22439 = (state_22546[(46)]);
var inst_22433 = (state_22546[(36)]);
var inst_22456 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22457 = inst_22439.o;
var inst_22458 = [inst_22457];
var inst_22459 = cljs.core.PersistentHashMap.fromArrays(inst_22456,inst_22458);
var inst_22460 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22433,inst_22459);
var state_22546__$1 = state_22546;
var statearr_22661_22829 = state_22546__$1;
(statearr_22661_22829[(2)] = inst_22460);

(statearr_22661_22829[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (19))){
var inst_22219 = (state_22546[(45)]);
var inst_22215 = (state_22546[(19)]);
var inst_22219__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22215);
var state_22546__$1 = (function (){var statearr_22662 = state_22546;
(statearr_22662[(45)] = inst_22219__$1);

return statearr_22662;
})();
if(cljs.core.truth_(inst_22219__$1)){
var statearr_22663_22830 = state_22546__$1;
(statearr_22663_22830[(1)] = (21));

} else {
var statearr_22664_22831 = state_22546__$1;
(statearr_22664_22831[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (57))){
var inst_22215 = (state_22546[(19)]);
var inst_22295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22296 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22297 = (new cljs.core.PersistentVector(null,3,(5),inst_22295,inst_22296,null));
var inst_22298 = cljs.core.select_keys(inst_22215,inst_22297);
var inst_22299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22307 = flakes;
var inst_22308 = cljs.core.seq(inst_22307);
var inst_22309 = cljs.core.first(inst_22308);
var inst_22310 = cljs.core.next(inst_22308);
var inst_22311 = cljs.core.PersistentVector.EMPTY;
var inst_22312 = inst_22307;
var inst_22313 = inst_22311;
var state_22546__$1 = (function (){var statearr_22665 = state_22546;
(statearr_22665[(53)] = inst_22309);

(statearr_22665[(54)] = inst_22310);

(statearr_22665[(49)] = inst_22299);

(statearr_22665[(26)] = inst_22312);

(statearr_22665[(29)] = inst_22313);

(statearr_22665[(55)] = inst_22298);

return statearr_22665;
})();
var statearr_22666_22832 = state_22546__$1;
(statearr_22666_22832[(2)] = null);

(statearr_22666_22832[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (68))){
var inst_22329 = (state_22546[(7)]);
var inst_22298 = (state_22546[(55)]);
var inst_22335 = (state_22546[(2)]);
var inst_22336 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22298,inst_22329) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22298,inst_22329));
var state_22546__$1 = (function (){var statearr_22667 = state_22546;
(statearr_22667[(56)] = inst_22335);

return statearr_22667;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22546__$1,(69),inst_22336);
} else {
if((state_val_22547 === (11))){
var inst_22200 = (state_22546[(39)]);
var inst_22200__$1 = (state_22546[(2)]);
var inst_22202 = cljs.core.contains_QMARK_(inst_22200__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22203 = (!(inst_22202));
var state_22546__$1 = (function (){var statearr_22668 = state_22546;
(statearr_22668[(39)] = inst_22200__$1);

return statearr_22668;
})();
if(inst_22203){
var statearr_22669_22833 = state_22546__$1;
(statearr_22669_22833[(1)] = (12));

} else {
var statearr_22670_22834 = state_22546__$1;
(statearr_22670_22834[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (115))){
var inst_22539 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
var statearr_22672_22835 = state_22546__$1;
(statearr_22672_22835[(2)] = inst_22539);

(statearr_22672_22835[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (9))){
var inst_22194 = cljs.core.first(flakes);
var inst_22195 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22194);
var inst_22196 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22197 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22195,inst_22196);
var state_22546__$1 = state_22546;
var statearr_22673_22836 = state_22546__$1;
(statearr_22673_22836[(2)] = inst_22197);

(statearr_22673_22836[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (5))){
var _ = (function (){var statearr_22674 = state_22546;
(statearr_22674[(4)] = cljs.core.rest((state_22546[(4)])));

return statearr_22674;
})();
var state_22546__$1 = state_22546;
var ex22671 = (state_22546__$1[(2)]);
var statearr_22675_22837 = state_22546__$1;
(statearr_22675_22837[(5)] = ex22671);


if((ex22671 instanceof Error)){
var statearr_22676_22838 = state_22546__$1;
(statearr_22676_22838[(1)] = (4));

(statearr_22676_22838[(5)] = null);

} else {
throw ex22671;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (112))){
var inst_22541 = (state_22546[(2)]);
var _ = (function (){var statearr_22677 = state_22546;
(statearr_22677[(4)] = cljs.core.rest((state_22546[(4)])));

return statearr_22677;
})();
var state_22546__$1 = state_22546;
var statearr_22678_22839 = state_22546__$1;
(statearr_22678_22839[(2)] = inst_22541);

(statearr_22678_22839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (83))){
var inst_22366 = (state_22546[(11)]);
var state_22546__$1 = state_22546;
var statearr_22679_22840 = state_22546__$1;
(statearr_22679_22840[(2)] = inst_22366);

(statearr_22679_22840[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (14))){
var inst_22200 = (state_22546[(39)]);
var inst_22208 = (state_22546[(2)]);
var inst_22209 = cljs.core.contains_QMARK_(inst_22200,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22210 = (!(inst_22209));
var state_22546__$1 = (function (){var statearr_22680 = state_22546;
(statearr_22680[(40)] = inst_22208);

return statearr_22680;
})();
if(inst_22210){
var statearr_22681_22841 = state_22546__$1;
(statearr_22681_22841[(1)] = (15));

} else {
var statearr_22682_22842 = state_22546__$1;
(statearr_22682_22842[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (45))){
var inst_22230 = (state_22546[(20)]);
var inst_22226 = (state_22546[(25)]);
var inst_22266 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22226);
var inst_22267 = cljs.core.count(inst_22266);
var inst_22268 = (inst_22267 >= inst_22230);
var state_22546__$1 = state_22546;
var statearr_22683_22843 = state_22546__$1;
(statearr_22683_22843[(2)] = inst_22268);

(statearr_22683_22843[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (53))){
var inst_22293 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22293)){
var statearr_22684_22844 = state_22546__$1;
(statearr_22684_22844[(1)] = (57));

} else {
var statearr_22685_22845 = state_22546__$1;
(statearr_22685_22845[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (78))){
var inst_22381 = (state_22546[(42)]);
var state_22546__$1 = state_22546;
var statearr_22686_22846 = state_22546__$1;
(statearr_22686_22846[(2)] = inst_22381);

(statearr_22686_22846[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (26))){
var inst_22248 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22248)){
var statearr_22687_22847 = state_22546__$1;
(statearr_22687_22847[(1)] = (33));

} else {
var statearr_22688_22848 = state_22546__$1;
(statearr_22688_22848[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (16))){
var inst_22208 = (state_22546[(40)]);
var state_22546__$1 = state_22546;
var statearr_22689_22849 = state_22546__$1;
(statearr_22689_22849[(2)] = inst_22208);

(statearr_22689_22849[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (81))){
var inst_22215 = (state_22546[(19)]);
var inst_22372 = (state_22546[(43)]);
var inst_22388 = (state_22546[(2)]);
var inst_22389 = fluree.db.util.async.throw_err(inst_22388);
var inst_22390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22391 = inst_22372.o;
var inst_22392 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22215);
var inst_22393 = [inst_22391,inst_22392];
var inst_22394 = (new cljs.core.PersistentVector(null,2,(5),inst_22390,inst_22393,null));
var inst_22395 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_22394,inst_22389);
var state_22546__$1 = (function (){var statearr_22690 = state_22546;
(statearr_22690[(57)] = inst_22395);

return statearr_22690;
})();
var statearr_22691_22850 = state_22546__$1;
(statearr_22691_22850[(2)] = inst_22389);

(statearr_22691_22850[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (79))){
var inst_22215 = (state_22546[(19)]);
var inst_22372 = (state_22546[(43)]);
var inst_22384 = inst_22372.o;
var inst_22385 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22215);
var inst_22386 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22384,inst_22385);
var state_22546__$1 = state_22546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22546__$1,(81),inst_22386);
} else {
if((state_val_22547 === (38))){
var inst_22250 = (state_22546[(48)]);
var inst_22258 = (state_22546[(2)]);
var inst_22259 = [null,inst_22258];
var inst_22260 = (new cljs.core.PersistentVector(null,2,(5),inst_22250,inst_22259,null));
var state_22546__$1 = state_22546;
var statearr_22692_22851 = state_22546__$1;
(statearr_22692_22851[(2)] = inst_22260);

(statearr_22692_22851[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (98))){
var inst_22453 = (state_22546[(30)]);
var inst_22185 = (state_22546[(38)]);
var inst_22462 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22463 = [true,inst_22185];
var inst_22464 = cljs.core.PersistentHashMap.fromArrays(inst_22462,inst_22463);
var inst_22465 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22464,inst_22453) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22464,inst_22453));
var state_22546__$1 = state_22546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22546__$1,(100),inst_22465);
} else {
if((state_val_22547 === (87))){
var inst_22417 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22417)){
var statearr_22693_22852 = state_22546__$1;
(statearr_22693_22852[(1)] = (88));

} else {
var statearr_22694_22853 = state_22546__$1;
(statearr_22694_22853[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (30))){
var inst_22233 = (state_22546[(24)]);
var inst_22238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22233);
var inst_22239 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22238);
var state_22546__$1 = state_22546;
var statearr_22695_22854 = state_22546__$1;
(statearr_22695_22854[(2)] = inst_22239);

(statearr_22695_22854[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (73))){
var inst_22365 = (state_22546[(10)]);
var inst_22372 = (state_22546[(43)]);
var inst_22371 = cljs.core.seq(inst_22365);
var inst_22372__$1 = cljs.core.first(inst_22371);
var inst_22373 = cljs.core.next(inst_22371);
var state_22546__$1 = (function (){var statearr_22696 = state_22546;
(statearr_22696[(58)] = inst_22373);

(statearr_22696[(43)] = inst_22372__$1);

return statearr_22696;
})();
if(cljs.core.truth_(inst_22372__$1)){
var statearr_22697_22855 = state_22546__$1;
(statearr_22697_22855[(1)] = (75));

} else {
var statearr_22698_22856 = state_22546__$1;
(statearr_22698_22856[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (96))){
var inst_22453 = (state_22546[(30)]);
var inst_22452 = (state_22546[(2)]);
var inst_22453__$1 = fluree.db.util.async.throw_err(inst_22452);
var inst_22454 = cljs.core.empty_QMARK_(inst_22453__$1);
var state_22546__$1 = (function (){var statearr_22699 = state_22546;
(statearr_22699[(30)] = inst_22453__$1);

return statearr_22699;
})();
if(inst_22454){
var statearr_22700_22857 = state_22546__$1;
(statearr_22700_22857[(1)] = (97));

} else {
var statearr_22701_22858 = state_22546__$1;
(statearr_22701_22858[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (10))){
var state_22546__$1 = state_22546;
var statearr_22702_22859 = state_22546__$1;
(statearr_22702_22859[(2)] = pred_spec);

(statearr_22702_22859[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (18))){
var inst_22216 = (state_22546[(51)]);
var state_22546__$1 = state_22546;
var statearr_22703_22860 = state_22546__$1;
(statearr_22703_22860[(2)] = inst_22216);

(statearr_22703_22860[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (105))){
var state_22546__$1 = state_22546;
var statearr_22704_22861 = state_22546__$1;
(statearr_22704_22861[(1)] = (107));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (52))){
var inst_22283 = (state_22546[(59)]);
var state_22546__$1 = state_22546;
var statearr_22706_22862 = state_22546__$1;
(statearr_22706_22862[(2)] = inst_22283);

(statearr_22706_22862[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (114))){
var state_22546__$1 = state_22546;
var statearr_22707_22863 = state_22546__$1;
(statearr_22707_22863[(1)] = (116));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (67))){
var state_22546__$1 = state_22546;
var statearr_22709_22864 = state_22546__$1;
(statearr_22709_22864[(2)] = null);

(statearr_22709_22864[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (71))){
var inst_22412 = (state_22546[(16)]);
var inst_22412__$1 = componentFollow_QMARK_;
var state_22546__$1 = (function (){var statearr_22710 = state_22546;
(statearr_22710[(16)] = inst_22412__$1);

return statearr_22710;
})();
if(cljs.core.truth_(inst_22412__$1)){
var statearr_22711_22865 = state_22546__$1;
(statearr_22711_22865[(1)] = (85));

} else {
var statearr_22712_22866 = state_22546__$1;
(statearr_22712_22866[(1)] = (86));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (42))){
var inst_22230 = (state_22546[(20)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22230)){
var statearr_22713_22867 = state_22546__$1;
(statearr_22713_22867[(1)] = (45));

} else {
var statearr_22714_22868 = state_22546__$1;
(statearr_22714_22868[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (80))){
var inst_22397 = (state_22546[(52)]);
var inst_22397__$1 = (state_22546[(2)]);
var state_22546__$1 = (function (){var statearr_22715 = state_22546;
(statearr_22715[(52)] = inst_22397__$1);

return statearr_22715;
})();
if(cljs.core.truth_(inst_22397__$1)){
var statearr_22716_22869 = state_22546__$1;
(statearr_22716_22869[(1)] = (82));

} else {
var statearr_22717_22870 = state_22546__$1;
(statearr_22717_22870[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (37))){
var inst_22232 = (state_22546[(21)]);
var inst_22233 = (state_22546[(24)]);
var inst_22255 = (inst_22232 - (1));
var inst_22256 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22233,inst_22255);
var state_22546__$1 = state_22546;
var statearr_22718_22871 = state_22546__$1;
(statearr_22718_22871[(2)] = inst_22256);

(statearr_22718_22871[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (63))){
var inst_22313 = (state_22546[(29)]);
var state_22546__$1 = state_22546;
var statearr_22719_22872 = state_22546__$1;
(statearr_22719_22872[(2)] = inst_22313);

(statearr_22719_22872[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (94))){
var inst_22433 = (state_22546[(36)]);
var state_22546__$1 = state_22546;
var statearr_22720_22873 = state_22546__$1;
(statearr_22720_22873[(2)] = inst_22433);

(statearr_22720_22873[(1)] = (95));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (8))){
var inst_22192 = (state_22546[(2)]);
var state_22546__$1 = state_22546;
if(cljs.core.truth_(inst_22192)){
var statearr_22721_22874 = state_22546__$1;
(statearr_22721_22874[(1)] = (9));

} else {
var statearr_22722_22875 = state_22546__$1;
(statearr_22722_22875[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (49))){
var inst_22283 = (state_22546[(59)]);
var inst_22283__$1 = cljs.core.not(recur_QMARK_);
var state_22546__$1 = (function (){var statearr_22723 = state_22546;
(statearr_22723[(59)] = inst_22283__$1);

return statearr_22723;
})();
if(inst_22283__$1){
var statearr_22724_22876 = state_22546__$1;
(statearr_22724_22876[(1)] = (51));

} else {
var statearr_22725_22877 = state_22546__$1;
(statearr_22725_22877[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22547 === (84))){
var inst_22373 = (state_22546[(58)]);
var inst_22402 = (state_22546[(2)]);
var inst_22365 = inst_22373;
var inst_22366 = inst_22402;
var state_22546__$1 = (function (){var statearr_22726 = state_22546;
(statearr_22726[(10)] = inst_22365);

(statearr_22726[(11)] = inst_22366);

return statearr_22726;
})();
var statearr_22727_22878 = state_22546__$1;
(statearr_22727_22878[(2)] = null);

(statearr_22727_22878[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_22728 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22728[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_22728[(1)] = (1));

return statearr_22728;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_22546){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_22546);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e22729){var ex__2736__auto__ = e22729;
var statearr_22730_22879 = state_22546;
(statearr_22730_22879[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_22546[(4)]))){
var statearr_22731_22880 = state_22546;
(statearr_22731_22880[(1)] = cljs.core.first((state_22546[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22881 = state_22546;
state_22546 = G__22881;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_22546){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_22546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_22732 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_22732[(6)] = c__2755__auto__);

return statearr_22732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23041){
var state_val_23042 = (state_23041[(1)]);
if((state_val_23042 === (7))){
var inst_23036 = (state_23041[(2)]);
var _ = (function (){var statearr_23043 = state_23041;
(statearr_23043[(4)] = cljs.core.rest((state_23041[(4)])));

return statearr_23043;
})();
var state_23041__$1 = state_23041;
var statearr_23044_23126 = state_23041__$1;
(statearr_23044_23126[(2)] = inst_23036);

(statearr_23044_23126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (20))){
var inst_22963 = (state_23041[(7)]);
var state_23041__$1 = state_23041;
var statearr_23045_23127 = state_23041__$1;
(statearr_23045_23127[(2)] = inst_22963);

(statearr_23045_23127[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (27))){
var inst_22918 = (state_23041[(8)]);
var state_23041__$1 = state_23041;
if(cljs.core.truth_(inst_22918)){
var statearr_23046_23128 = state_23041__$1;
(statearr_23046_23128[(1)] = (29));

} else {
var statearr_23047_23129 = state_23041__$1;
(statearr_23047_23129[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (1))){
var state_23041__$1 = state_23041;
var statearr_23048_23130 = state_23041__$1;
(statearr_23048_23130[(2)] = null);

(statearr_23048_23130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (24))){
var inst_22919 = (state_23041[(9)]);
var state_23041__$1 = state_23041;
var statearr_23049_23131 = state_23041__$1;
(statearr_23049_23131[(2)] = inst_22919);

(statearr_23049_23131[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (39))){
var inst_22955 = (state_23041[(10)]);
var state_23041__$1 = state_23041;
var statearr_23050_23132 = state_23041__$1;
(statearr_23050_23132[(2)] = inst_22955);

(statearr_23050_23132[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (46))){
var inst_22920 = (state_23041[(11)]);
var state_23041__$1 = state_23041;
var statearr_23051_23133 = state_23041__$1;
(statearr_23051_23133[(2)] = inst_22920);

(statearr_23051_23133[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (4))){
var inst_22882 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
var statearr_23052_23134 = state_23041__$1;
(statearr_23052_23134[(2)] = inst_22882);

(statearr_23052_23134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (15))){
var inst_22931 = (state_23041[(12)]);
var inst_22937 = cljs.core.count(inst_22931);
var inst_22938 = fluree.db.query.fql.add_fuel(fuel,inst_22937,max_fuel);
var state_23041__$1 = state_23041;
var statearr_23053_23135 = state_23041__$1;
(statearr_23053_23135[(2)] = inst_22938);

(statearr_23053_23135[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (48))){
var inst_22907 = (state_23041[(13)]);
var inst_22900 = (state_23041[(14)]);
var inst_23022 = (state_23041[(15)]);
var inst_23030 = (state_23041[(2)]);
var inst_23031 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22900,inst_23030,inst_23022);
var inst_22899 = inst_22907;
var inst_22900__$1 = inst_23031;
var state_23041__$1 = (function (){var statearr_23054 = state_23041;
(statearr_23054[(14)] = inst_22900__$1);

(statearr_23054[(16)] = inst_22899);

return statearr_23054;
})();
var statearr_23055_23136 = state_23041__$1;
(statearr_23055_23136[(2)] = null);

(statearr_23055_23136[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (50))){
var inst_22922 = (state_23041[(17)]);
var state_23041__$1 = state_23041;
var statearr_23056_23137 = state_23041__$1;
(statearr_23056_23137[(2)] = inst_22922);

(statearr_23056_23137[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (21))){
var inst_22919 = (state_23041[(9)]);
var state_23041__$1 = state_23041;
if(cljs.core.truth_(inst_22919)){
var statearr_23058_23138 = state_23041__$1;
(statearr_23058_23138[(1)] = (23));

} else {
var statearr_23059_23139 = state_23041__$1;
(statearr_23059_23139[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (31))){
var inst_22979 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
if(cljs.core.truth_(inst_22979)){
var statearr_23060_23140 = state_23041__$1;
(statearr_23060_23140[(1)] = (32));

} else {
var statearr_23061_23141 = state_23041__$1;
(statearr_23061_23141[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (32))){
var inst_22954 = (state_23041[(18)]);
var inst_22955 = (state_23041[(10)]);
var inst_22962 = (state_23041[(19)]);
var inst_22981 = (inst_22954 + (1));
var tmp23057 = inst_22955;
var inst_22953 = inst_22962;
var inst_22954__$1 = inst_22981;
var inst_22955__$1 = tmp23057;
var state_23041__$1 = (function (){var statearr_23062 = state_23041;
(statearr_23062[(18)] = inst_22954__$1);

(statearr_23062[(10)] = inst_22955__$1);

(statearr_23062[(20)] = inst_22953);

return statearr_23062;
})();
var statearr_23063_23142 = state_23041__$1;
(statearr_23063_23142[(2)] = null);

(statearr_23063_23142[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (40))){
var state_23041__$1 = state_23041;
if(cljs.core.truth_(fuel)){
var statearr_23064_23143 = state_23041__$1;
(statearr_23064_23143[(1)] = (42));

} else {
var statearr_23065_23144 = state_23041__$1;
(statearr_23065_23144[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (33))){
var state_23041__$1 = state_23041;
var statearr_23066_23145 = state_23041__$1;
(statearr_23066_23145[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (13))){
var inst_22931 = (state_23041[(12)]);
var state_23041__$1 = state_23041;
var statearr_23068_23146 = state_23041__$1;
(statearr_23068_23146[(2)] = inst_22931);

(statearr_23068_23146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (22))){
var inst_22972 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
if(cljs.core.truth_(inst_22972)){
var statearr_23069_23147 = state_23041__$1;
(statearr_23069_23147[(1)] = (26));

} else {
var statearr_23070_23148 = state_23041__$1;
(statearr_23070_23148[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (36))){
var state_23041__$1 = state_23041;
var statearr_23071_23149 = state_23041__$1;
(statearr_23071_23149[(2)] = null);

(statearr_23071_23149[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (41))){
var inst_22954 = (state_23041[(18)]);
var inst_22962 = (state_23041[(19)]);
var inst_23011 = (state_23041[(2)]);
var inst_23012 = (inst_22954 + (1));
var inst_22953 = inst_22962;
var inst_22954__$1 = inst_23012;
var inst_22955 = inst_23011;
var state_23041__$1 = (function (){var statearr_23072 = state_23041;
(statearr_23072[(18)] = inst_22954__$1);

(statearr_23072[(10)] = inst_22955);

(statearr_23072[(20)] = inst_22953);

return statearr_23072;
})();
var statearr_23073_23150 = state_23041__$1;
(statearr_23073_23150[(2)] = null);

(statearr_23073_23150[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (43))){
var state_23041__$1 = state_23041;
var statearr_23074_23151 = state_23041__$1;
(statearr_23074_23151[(2)] = null);

(statearr_23074_23151[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (29))){
var inst_22954 = (state_23041[(18)]);
var inst_22918 = (state_23041[(8)]);
var inst_22976 = (inst_22954 < inst_22918);
var state_23041__$1 = state_23041;
var statearr_23075_23152 = state_23041__$1;
(statearr_23075_23152[(2)] = inst_22976);

(statearr_23075_23152[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (44))){
var inst_22995 = (state_23041[(21)]);
var inst_22991 = (state_23041[(22)]);
var inst_23004 = (state_23041[(2)]);
var inst_23005 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22995,inst_22991) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22995,inst_22991));
var state_23041__$1 = (function (){var statearr_23076 = state_23041;
(statearr_23076[(23)] = inst_23004);

return statearr_23076;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23041__$1,(45),inst_23005);
} else {
if((state_val_23042 === (6))){
var inst_22899 = (state_23041[(16)]);
var inst_22906 = (state_23041[(24)]);
var inst_22905 = cljs.core.seq(inst_22899);
var inst_22906__$1 = cljs.core.first(inst_22905);
var inst_22907 = cljs.core.next(inst_22905);
var inst_22908 = cljs.core.not(inst_22906__$1);
var state_23041__$1 = (function (){var statearr_23077 = state_23041;
(statearr_23077[(13)] = inst_22907);

(statearr_23077[(24)] = inst_22906__$1);

return statearr_23077;
})();
if(inst_22908){
var statearr_23078_23153 = state_23041__$1;
(statearr_23078_23153[(1)] = (8));

} else {
var statearr_23079_23154 = state_23041__$1;
(statearr_23079_23154[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (28))){
var inst_23020 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
var statearr_23080_23155 = state_23041__$1;
(statearr_23080_23155[(2)] = inst_23020);

(statearr_23080_23155[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (51))){
var inst_23028 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
var statearr_23081_23156 = state_23041__$1;
(statearr_23081_23156[(2)] = inst_23028);

(statearr_23081_23156[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (25))){
var inst_22970 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
var statearr_23082_23157 = state_23041__$1;
(statearr_23082_23157[(2)] = inst_22970);

(statearr_23082_23157[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (34))){
var inst_23018 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
var statearr_23083_23158 = state_23041__$1;
(statearr_23083_23158[(2)] = inst_23018);

(statearr_23083_23158[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (17))){
var inst_22931 = (state_23041[(12)]);
var inst_22941 = (state_23041[(2)]);
var inst_22949 = cljs.core.seq(inst_22931);
var inst_22950 = cljs.core.first(inst_22949);
var inst_22951 = cljs.core.next(inst_22949);
var inst_22952 = cljs.core.PersistentVector.EMPTY;
var inst_22953 = inst_22931;
var inst_22954 = (0);
var inst_22955 = inst_22952;
var state_23041__$1 = (function (){var statearr_23084 = state_23041;
(statearr_23084[(18)] = inst_22954);

(statearr_23084[(25)] = inst_22951);

(statearr_23084[(10)] = inst_22955);

(statearr_23084[(26)] = inst_22941);

(statearr_23084[(27)] = inst_22950);

(statearr_23084[(20)] = inst_22953);

return statearr_23084;
})();
var statearr_23085_23159 = state_23041__$1;
(statearr_23085_23159[(2)] = null);

(statearr_23085_23159[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (3))){
var inst_23039 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23041__$1,inst_23039);
} else {
if((state_val_23042 === (12))){
var state_23041__$1 = state_23041;
var statearr_23086_23160 = state_23041__$1;
(statearr_23086_23160[(2)] = fuel);

(statearr_23086_23160[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (2))){
var _ = (function (){var statearr_23087 = state_23041;
(statearr_23087[(4)] = cljs.core.cons((5),(state_23041[(4)])));

return statearr_23087;
})();
var inst_22895 = reverse_refs_specs;
var inst_22896 = cljs.core.seq(inst_22895);
var inst_22897 = cljs.core.first(inst_22896);
var inst_22898 = cljs.core.next(inst_22896);
var inst_22899 = inst_22895;
var inst_22900 = null;
var state_23041__$1 = (function (){var statearr_23088 = state_23041;
(statearr_23088[(14)] = inst_22900);

(statearr_23088[(16)] = inst_22899);

(statearr_23088[(28)] = inst_22897);

(statearr_23088[(29)] = inst_22898);

return statearr_23088;
})();
var statearr_23089_23161 = state_23041__$1;
(statearr_23089_23161[(2)] = null);

(statearr_23089_23161[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (23))){
var inst_22954 = (state_23041[(18)]);
var inst_22919 = (state_23041[(9)]);
var inst_22967 = (inst_22954 >= inst_22919);
var state_23041__$1 = state_23041;
var statearr_23090_23162 = state_23041__$1;
(statearr_23090_23162[(2)] = inst_22967);

(statearr_23090_23162[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (47))){
var inst_22921 = (state_23041[(30)]);
var state_23041__$1 = state_23041;
if(cljs.core.truth_(inst_22921)){
var statearr_23091_23163 = state_23041__$1;
(statearr_23091_23163[(1)] = (49));

} else {
var statearr_23092_23164 = state_23041__$1;
(statearr_23092_23164[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (35))){
var inst_22961 = (state_23041[(31)]);
var inst_22985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22986 = [inst_22961];
var inst_22987 = (new cljs.core.PersistentVector(null,1,(5),inst_22985,inst_22986,null));
var inst_22988 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22987);
var state_23041__$1 = state_23041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23041__$1,(38),inst_22988);
} else {
if((state_val_23042 === (19))){
var inst_22920 = (state_23041[(11)]);
var inst_23022 = (state_23041[(2)]);
var state_23041__$1 = (function (){var statearr_23093 = state_23041;
(statearr_23093[(15)] = inst_23022);

return statearr_23093;
})();
if(cljs.core.truth_(inst_22920)){
var statearr_23094_23165 = state_23041__$1;
(statearr_23094_23165[(1)] = (46));

} else {
var statearr_23095_23166 = state_23041__$1;
(statearr_23095_23166[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (11))){
var inst_22931 = (state_23041[(12)]);
var inst_22928 = (state_23041[(2)]);
var inst_22929 = fluree.db.util.async.throw_err(inst_22928);
var inst_22930 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_22929);
var inst_22931__$1 = cljs.core.not_empty(inst_22930);
var state_23041__$1 = (function (){var statearr_23097 = state_23041;
(statearr_23097[(12)] = inst_22931__$1);

return statearr_23097;
})();
if(cljs.core.truth_(inst_22931__$1)){
var statearr_23098_23167 = state_23041__$1;
(statearr_23098_23167[(1)] = (12));

} else {
var statearr_23099_23168 = state_23041__$1;
(statearr_23099_23168[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (9))){
var inst_22916 = (state_23041[(32)]);
var inst_22906 = (state_23041[(24)]);
var inst_22915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22906,(0),null);
var inst_22916__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22906,(1),null);
var inst_22917 = cljs.core.__destructure_map(inst_22916__$1);
var inst_22918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22917,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22917,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22917,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22917,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22917,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22924 = [subject_id,inst_22915];
var inst_22925 = (new cljs.core.PersistentVector(null,2,(5),inst_22923,inst_22924,null));
var inst_22926 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22925);
var state_23041__$1 = (function (){var statearr_23100 = state_23041;
(statearr_23100[(9)] = inst_22919);

(statearr_23100[(30)] = inst_22921);

(statearr_23100[(8)] = inst_22918);

(statearr_23100[(32)] = inst_22916__$1);

(statearr_23100[(11)] = inst_22920);

(statearr_23100[(17)] = inst_22922);

return statearr_23100;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23041__$1,(11),inst_22926);
} else {
if((state_val_23042 === (5))){
var _ = (function (){var statearr_23101 = state_23041;
(statearr_23101[(4)] = cljs.core.rest((state_23041[(4)])));

return statearr_23101;
})();
var state_23041__$1 = state_23041;
var ex23096 = (state_23041__$1[(2)]);
var statearr_23102_23169 = state_23041__$1;
(statearr_23102_23169[(5)] = ex23096);


if((ex23096 instanceof Error)){
var statearr_23103_23170 = state_23041__$1;
(statearr_23103_23170[(1)] = (4));

(statearr_23103_23170[(5)] = null);

} else {
throw ex23096;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (14))){
var inst_22935 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
if(cljs.core.truth_(inst_22935)){
var statearr_23104_23171 = state_23041__$1;
(statearr_23104_23171[(1)] = (15));

} else {
var statearr_23105_23172 = state_23041__$1;
(statearr_23105_23172[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (45))){
var inst_22955 = (state_23041[(10)]);
var inst_23007 = (state_23041[(2)]);
var inst_23008 = fluree.db.util.async.throw_err(inst_23007);
var inst_23009 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22955,inst_23008);
var state_23041__$1 = state_23041;
var statearr_23106_23173 = state_23041__$1;
(statearr_23106_23173[(2)] = inst_23009);

(statearr_23106_23173[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (26))){
var inst_22955 = (state_23041[(10)]);
var state_23041__$1 = state_23041;
var statearr_23107_23174 = state_23041__$1;
(statearr_23107_23174[(2)] = inst_22955);

(statearr_23107_23174[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (16))){
var state_23041__$1 = state_23041;
var statearr_23108_23175 = state_23041__$1;
(statearr_23108_23175[(2)] = null);

(statearr_23108_23175[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (38))){
var inst_22991 = (state_23041[(22)]);
var inst_22916 = (state_23041[(32)]);
var inst_22990 = (state_23041[(2)]);
var inst_22991__$1 = fluree.db.util.async.throw_err(inst_22990);
var inst_22992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22993 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22994 = (new cljs.core.PersistentVector(null,4,(5),inst_22992,inst_22993,null));
var inst_22995 = cljs.core.select_keys(inst_22916,inst_22994);
var inst_22996 = cljs.core.empty_QMARK_(inst_22991__$1);
var state_23041__$1 = (function (){var statearr_23109 = state_23041;
(statearr_23109[(21)] = inst_22995);

(statearr_23109[(22)] = inst_22991__$1);

return statearr_23109;
})();
if(inst_22996){
var statearr_23110_23176 = state_23041__$1;
(statearr_23110_23176[(1)] = (39));

} else {
var statearr_23111_23177 = state_23041__$1;
(statearr_23111_23177[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (30))){
var inst_22918 = (state_23041[(8)]);
var state_23041__$1 = state_23041;
var statearr_23112_23178 = state_23041__$1;
(statearr_23112_23178[(2)] = inst_22918);

(statearr_23112_23178[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (10))){
var inst_23034 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
var statearr_23113_23179 = state_23041__$1;
(statearr_23113_23179[(2)] = inst_23034);

(statearr_23113_23179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (18))){
var inst_22961 = (state_23041[(31)]);
var inst_22963 = (state_23041[(7)]);
var inst_22953 = (state_23041[(20)]);
var inst_22960 = cljs.core.seq(inst_22953);
var inst_22961__$1 = cljs.core.first(inst_22960);
var inst_22962 = cljs.core.next(inst_22960);
var inst_22963__$1 = cljs.core.not(inst_22961__$1);
var state_23041__$1 = (function (){var statearr_23114 = state_23041;
(statearr_23114[(31)] = inst_22961__$1);

(statearr_23114[(7)] = inst_22963__$1);

(statearr_23114[(19)] = inst_22962);

return statearr_23114;
})();
if(inst_22963__$1){
var statearr_23115_23180 = state_23041__$1;
(statearr_23115_23180[(1)] = (20));

} else {
var statearr_23116_23181 = state_23041__$1;
(statearr_23116_23181[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (42))){
var inst_22991 = (state_23041[(22)]);
var inst_23000 = cljs.core.count(inst_22991);
var inst_23001 = fluree.db.query.fql.add_fuel(fuel,inst_23000,max_fuel);
var state_23041__$1 = state_23041;
var statearr_23117_23182 = state_23041__$1;
(statearr_23117_23182[(2)] = inst_23001);

(statearr_23117_23182[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (37))){
var inst_23016 = (state_23041[(2)]);
var state_23041__$1 = state_23041;
var statearr_23118_23183 = state_23041__$1;
(statearr_23118_23183[(2)] = inst_23016);

(statearr_23118_23183[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (8))){
var inst_22900 = (state_23041[(14)]);
var state_23041__$1 = state_23041;
var statearr_23119_23184 = state_23041__$1;
(statearr_23119_23184[(2)] = inst_22900);

(statearr_23119_23184[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23042 === (49))){
var inst_22921 = (state_23041[(30)]);
var state_23041__$1 = state_23041;
var statearr_23120_23185 = state_23041__$1;
(statearr_23120_23185[(2)] = inst_22921);

(statearr_23120_23185[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____0 = (function (){
var statearr_23121 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23121[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__);

(statearr_23121[(1)] = (1));

return statearr_23121;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____1 = (function (state_23041){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23041);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23122){var ex__2736__auto__ = e23122;
var statearr_23123_23186 = state_23041;
(statearr_23123_23186[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23041[(4)]))){
var statearr_23124_23187 = state_23041;
(statearr_23124_23187[(1)] = cljs.core.first((state_23041[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23188 = state_23041;
state_23041 = G__23188;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__ = function(state_23041){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____1.call(this,state_23041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23125 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23125[(6)] = c__2755__auto__);

return statearr_23125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23189 = select_spec;
var map__23189__$1 = cljs.core.__destructure_map(map__23189);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23189__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23189__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23303){
var state_val_23304 = (state_23303[(1)]);
if((state_val_23304 === (7))){
var inst_23215 = flakes;
var inst_23216 = cljs.core.seq(inst_23215);
var inst_23217 = cljs.core.first(inst_23216);
var inst_23218 = cljs.core.next(inst_23216);
var inst_23219 = cljs.core.PersistentVector.EMPTY;
var inst_23220 = inst_23215;
var inst_23221 = (0);
var inst_23222 = inst_23219;
var state_23303__$1 = (function (){var statearr_23305 = state_23303;
(statearr_23305[(7)] = inst_23217);

(statearr_23305[(8)] = inst_23222);

(statearr_23305[(9)] = inst_23220);

(statearr_23305[(10)] = inst_23221);

(statearr_23305[(11)] = inst_23218);

return statearr_23305;
})();
var statearr_23306_23372 = state_23303__$1;
(statearr_23306_23372[(2)] = null);

(statearr_23306_23372[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (20))){
var state_23303__$1 = state_23303;
var statearr_23307_23373 = state_23303__$1;
(statearr_23307_23373[(2)] = results);

(statearr_23307_23373[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (27))){
var state_23303__$1 = state_23303;
var statearr_23308_23374 = state_23303__$1;
(statearr_23308_23374[(2)] = null);

(statearr_23308_23374[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (1))){
var state_23303__$1 = state_23303;
var statearr_23309_23375 = state_23303__$1;
(statearr_23309_23375[(2)] = null);

(statearr_23309_23375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (24))){
var state_23303__$1 = state_23303;
var statearr_23310_23376 = state_23303__$1;
(statearr_23310_23376[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (39))){
var inst_23222 = (state_23303[(8)]);
var inst_23284 = (state_23303[(12)]);
var inst_23229 = (state_23303[(13)]);
var inst_23287 = (state_23303[(2)]);
var inst_23288 = fluree.db.util.async.throw_err(inst_23287);
var inst_23289 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23222,inst_23288);
var inst_23220 = inst_23229;
var inst_23221 = inst_23284;
var inst_23222__$1 = inst_23289;
var state_23303__$1 = (function (){var statearr_23312 = state_23303;
(statearr_23312[(8)] = inst_23222__$1);

(statearr_23312[(9)] = inst_23220);

(statearr_23312[(10)] = inst_23221);

return statearr_23312;
})();
var statearr_23313_23377 = state_23303__$1;
(statearr_23313_23377[(2)] = null);

(statearr_23313_23377[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (4))){
var inst_23190 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23314_23378 = state_23303__$1;
(statearr_23314_23378[(2)] = inst_23190);

(statearr_23314_23378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (15))){
var inst_23203 = (state_23303[(14)]);
var state_23303__$1 = state_23303;
var statearr_23315_23379 = state_23303__$1;
(statearr_23315_23379[(2)] = inst_23203);

(statearr_23315_23379[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (21))){
var inst_23199 = (state_23303[(15)]);
var state_23303__$1 = state_23303;
if(cljs.core.truth_(inst_23199)){
var statearr_23316_23380 = state_23303__$1;
(statearr_23316_23380[(1)] = (23));

} else {
var statearr_23317_23381 = state_23303__$1;
(statearr_23317_23381[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (31))){
var inst_23267 = (state_23303[(16)]);
var state_23303__$1 = state_23303;
var statearr_23318_23382 = state_23303__$1;
(statearr_23318_23382[(2)] = inst_23267);

(statearr_23318_23382[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (32))){
var inst_23259 = (state_23303[(17)]);
var inst_23273 = (state_23303[(2)]);
var state_23303__$1 = (function (){var statearr_23319 = state_23303;
(statearr_23319[(18)] = inst_23273);

return statearr_23319;
})();
if(cljs.core.truth_(inst_23259)){
var statearr_23320_23383 = state_23303__$1;
(statearr_23320_23383[(1)] = (33));

} else {
var statearr_23321_23384 = state_23303__$1;
(statearr_23321_23384[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (33))){
var inst_23259 = (state_23303[(17)]);
var state_23303__$1 = state_23303;
var statearr_23322_23385 = state_23303__$1;
(statearr_23322_23385[(2)] = inst_23259);

(statearr_23322_23385[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (13))){
var inst_23239 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
if(cljs.core.truth_(inst_23239)){
var statearr_23324_23386 = state_23303__$1;
(statearr_23324_23386[(1)] = (17));

} else {
var statearr_23325_23387 = state_23303__$1;
(statearr_23325_23387[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (22))){
var inst_23256 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23326_23388 = state_23303__$1;
(statearr_23326_23388[(2)] = inst_23256);

(statearr_23326_23388[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (36))){
var inst_23222 = (state_23303[(8)]);
var inst_23221 = (state_23303[(10)]);
var inst_23229 = (state_23303[(13)]);
var inst_23281 = (inst_23221 + (1));
var tmp23323 = inst_23222;
var inst_23220 = inst_23229;
var inst_23221__$1 = inst_23281;
var inst_23222__$1 = tmp23323;
var state_23303__$1 = (function (){var statearr_23327 = state_23303;
(statearr_23327[(8)] = inst_23222__$1);

(statearr_23327[(9)] = inst_23220);

(statearr_23327[(10)] = inst_23221__$1);

return statearr_23327;
})();
var statearr_23328_23389 = state_23303__$1;
(statearr_23328_23389[(2)] = null);

(statearr_23328_23389[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (29))){
var inst_23266 = (state_23303[(2)]);
var inst_23267 = fluree.db.util.async.throw_err(inst_23266);
var state_23303__$1 = (function (){var statearr_23329 = state_23303;
(statearr_23329[(16)] = inst_23267);

return statearr_23329;
})();
if(cljs.core.truth_(fuel)){
var statearr_23330_23390 = state_23303__$1;
(statearr_23330_23390[(1)] = (30));

} else {
var statearr_23331_23391 = state_23303__$1;
(statearr_23331_23391[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (6))){
var state_23303__$1 = state_23303;
var statearr_23332_23392 = state_23303__$1;
(statearr_23332_23392[(2)] = results);

(statearr_23332_23392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (28))){
var inst_23252 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23333_23393 = state_23303__$1;
(statearr_23333_23393[(2)] = inst_23252);

(statearr_23333_23393[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (25))){
var inst_23254 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23334_23394 = state_23303__$1;
(statearr_23334_23394[(2)] = inst_23254);

(statearr_23334_23394[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (34))){
var inst_23273 = (state_23303[(18)]);
var inst_23276 = cljs.core.empty_QMARK_(inst_23273);
var state_23303__$1 = state_23303;
var statearr_23335_23395 = state_23303__$1;
(statearr_23335_23395[(2)] = inst_23276);

(statearr_23335_23395[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (17))){
var inst_23222 = (state_23303[(8)]);
var inst_23241 = cljs.core.empty_QMARK_(inst_23222);
var state_23303__$1 = state_23303;
if(inst_23241){
var statearr_23336_23396 = state_23303__$1;
(statearr_23336_23396[(1)] = (20));

} else {
var statearr_23337_23397 = state_23303__$1;
(statearr_23337_23397[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (3))){
var inst_23301 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23303__$1,inst_23301);
} else {
if((state_val_23304 === (12))){
var inst_23203 = (state_23303[(14)]);
var state_23303__$1 = state_23303;
if(cljs.core.truth_(inst_23203)){
var statearr_23338_23398 = state_23303__$1;
(statearr_23338_23398[(1)] = (14));

} else {
var statearr_23339_23399 = state_23303__$1;
(statearr_23339_23399[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (2))){
var _ = (function (){var statearr_23340 = state_23303;
(statearr_23340[(4)] = cljs.core.cons((5),(state_23303[(4)])));

return statearr_23340;
})();
var inst_23197 = select_spec;
var inst_23198 = cljs.core.__destructure_map(inst_23197);
var inst_23199 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23198,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23200 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23198,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23198,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23198,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23203 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23198,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23204 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23205 = (inst_23202 > inst_23204);
var state_23303__$1 = (function (){var statearr_23341 = state_23303;
(statearr_23341[(19)] = inst_23200);

(statearr_23341[(15)] = inst_23199);

(statearr_23341[(20)] = inst_23201);

(statearr_23341[(14)] = inst_23203);

return statearr_23341;
})();
if(cljs.core.truth_(inst_23205)){
var statearr_23342_23400 = state_23303__$1;
(statearr_23342_23400[(1)] = (6));

} else {
var statearr_23343_23401 = state_23303__$1;
(statearr_23343_23401[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (23))){
var inst_23200 = (state_23303[(19)]);
var inst_23222 = (state_23303[(8)]);
var inst_23245 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23200,inst_23222);
var state_23303__$1 = state_23303;
var statearr_23344_23402 = state_23303__$1;
(statearr_23344_23402[(2)] = inst_23245);

(statearr_23344_23402[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (35))){
var inst_23228 = (state_23303[(21)]);
var inst_23278 = (state_23303[(2)]);
var inst_23279 = fluree.db.query.fql.recur_select_spec(select_spec,inst_23228);
var state_23303__$1 = (function (){var statearr_23345 = state_23303;
(statearr_23345[(22)] = inst_23279);

return statearr_23345;
})();
if(cljs.core.truth_(inst_23278)){
var statearr_23346_23403 = state_23303__$1;
(statearr_23346_23403[(1)] = (36));

} else {
var statearr_23347_23404 = state_23303__$1;
(statearr_23347_23404[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (19))){
var inst_23294 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23348_23405 = state_23303__$1;
(statearr_23348_23405[(2)] = inst_23294);

(statearr_23348_23405[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (11))){
var inst_23230 = (state_23303[(23)]);
var state_23303__$1 = state_23303;
var statearr_23350_23406 = state_23303__$1;
(statearr_23350_23406[(2)] = inst_23230);

(statearr_23350_23406[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (9))){
var inst_23230 = (state_23303[(23)]);
var inst_23228 = (state_23303[(21)]);
var inst_23220 = (state_23303[(9)]);
var inst_23227 = cljs.core.seq(inst_23220);
var inst_23228__$1 = cljs.core.first(inst_23227);
var inst_23229 = cljs.core.next(inst_23227);
var inst_23230__$1 = cljs.core.not(inst_23228__$1);
var state_23303__$1 = (function (){var statearr_23351 = state_23303;
(statearr_23351[(23)] = inst_23230__$1);

(statearr_23351[(21)] = inst_23228__$1);

(statearr_23351[(13)] = inst_23229);

return statearr_23351;
})();
if(inst_23230__$1){
var statearr_23352_23407 = state_23303__$1;
(statearr_23352_23407[(1)] = (11));

} else {
var statearr_23353_23408 = state_23303__$1;
(statearr_23353_23408[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (5))){
var _ = (function (){var statearr_23354 = state_23303;
(statearr_23354[(4)] = cljs.core.rest((state_23303[(4)])));

return statearr_23354;
})();
var state_23303__$1 = state_23303;
var ex23349 = (state_23303__$1[(2)]);
var statearr_23355_23409 = state_23303__$1;
(statearr_23355_23409[(5)] = ex23349);


if((ex23349 instanceof Error)){
var statearr_23356_23410 = state_23303__$1;
(statearr_23356_23410[(1)] = (4));

(statearr_23356_23410[(5)] = null);

} else {
throw ex23349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (14))){
var inst_23221 = (state_23303[(10)]);
var inst_23203 = (state_23303[(14)]);
var inst_23234 = (inst_23221 < inst_23203);
var state_23303__$1 = state_23303;
var statearr_23357_23411 = state_23303__$1;
(statearr_23357_23411[(2)] = inst_23234);

(statearr_23357_23411[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (26))){
var inst_23200 = (state_23303[(19)]);
var inst_23222 = (state_23303[(8)]);
var inst_23248 = cljs.core.first(inst_23222);
var inst_23249 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23200,inst_23248);
var state_23303__$1 = state_23303;
var statearr_23358_23412 = state_23303__$1;
(statearr_23358_23412[(2)] = inst_23249);

(statearr_23358_23412[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (16))){
var inst_23237 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23359_23413 = state_23303__$1;
(statearr_23359_23413[(2)] = inst_23237);

(statearr_23359_23413[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (38))){
var inst_23292 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23360_23414 = state_23303__$1;
(statearr_23360_23414[(2)] = inst_23292);

(statearr_23360_23414[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (30))){
var inst_23267 = (state_23303[(16)]);
var inst_23269 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_23270 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23269,inst_23267);
var state_23303__$1 = state_23303;
var statearr_23361_23415 = state_23303__$1;
(statearr_23361_23415[(2)] = inst_23270);

(statearr_23361_23415[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (10))){
var inst_23296 = (state_23303[(2)]);
var state_23303__$1 = state_23303;
var statearr_23362_23416 = state_23303__$1;
(statearr_23362_23416[(2)] = inst_23296);

(statearr_23362_23416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23304 === (18))){
var inst_23228 = (state_23303[(21)]);
var inst_23201 = (state_23303[(20)]);
var inst_23258 = inst_23228.o;
var inst_23259 = cljs.core.contains_QMARK_(inst_23201,inst_23258);
var inst_23261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23262 = [inst_23258];
var inst_23263 = (new cljs.core.PersistentVector(null,1,(5),inst_23261,inst_23262,null));
var inst_23264 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23263);
var state_23303__$1 = (function (){var statearr_23363 = state_23303;
(statearr_23363[(17)] = inst_23259);

return statearr_23363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23303__$1,(29),inst_23264);
} else {
if((state_val_23304 === (37))){
var inst_23273 = (state_23303[(18)]);
var inst_23221 = (state_23303[(10)]);
var inst_23279 = (state_23303[(22)]);
var inst_23284 = (inst_23221 + (1));
var inst_23285 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23279,inst_23273) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23279,inst_23273));
var state_23303__$1 = (function (){var statearr_23364 = state_23303;
(statearr_23364[(12)] = inst_23284);

return statearr_23364;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23303__$1,(39),inst_23285);
} else {
if((state_val_23304 === (8))){
var inst_23298 = (state_23303[(2)]);
var _ = (function (){var statearr_23365 = state_23303;
(statearr_23365[(4)] = cljs.core.rest((state_23303[(4)])));

return statearr_23365;
})();
var state_23303__$1 = state_23303;
var statearr_23366_23417 = state_23303__$1;
(statearr_23366_23417[(2)] = inst_23298);

(statearr_23366_23417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____0 = (function (){
var statearr_23367 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23367[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__);

(statearr_23367[(1)] = (1));

return statearr_23367;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____1 = (function (state_23303){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23303);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23368){var ex__2736__auto__ = e23368;
var statearr_23369_23418 = state_23303;
(statearr_23369_23418[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23303[(4)]))){
var statearr_23370_23419 = state_23303;
(statearr_23370_23419[(1)] = cljs.core.first((state_23303[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23420 = state_23303;
state_23303 = G__23420;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__ = function(state_23303){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____1.call(this,state_23303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23371 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23371[(6)] = c__2755__auto__);

return statearr_23371;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23601){
var state_val_23602 = (state_23601[(1)]);
if((state_val_23602 === (7))){
var state_23601__$1 = state_23601;
var statearr_23603_23689 = state_23601__$1;
(statearr_23603_23689[(2)] = null);

(statearr_23603_23689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (20))){
var inst_23459 = cljs.core.PersistentHashMap.EMPTY;
var state_23601__$1 = state_23601;
var statearr_23604_23690 = state_23601__$1;
(statearr_23604_23690[(2)] = inst_23459);

(statearr_23604_23690[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (27))){
var inst_23477 = (state_23601[(7)]);
var inst_23461 = (state_23601[(8)]);
var inst_23441 = (state_23601[(9)]);
var inst_23447 = (state_23601[(10)]);
var inst_23580 = (state_23601[(2)]);
var inst_23581 = (function (){var top_level_subject = inst_23441;
var select_spec = inst_23447;
var base_acc = inst_23461;
var acc_PLUS_refs = inst_23477;
var result = inst_23580;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23582 = cljs.core.PersistentVector.EMPTY;
var inst_23583 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23447);
var inst_23584 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23583);
var inst_23585 = cljs.core.vals(inst_23584);
var inst_23586 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23447);
var inst_23587 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23586);
var inst_23588 = cljs.core.vals(inst_23587);
var inst_23589 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23585,inst_23588);
var inst_23590 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23581,inst_23582,inst_23589);
var inst_23592 = (function (){var top_level_subject = inst_23441;
var select_spec = inst_23447;
var base_acc = inst_23461;
var acc_PLUS_refs = inst_23477;
var result = inst_23580;
var sort_preds = inst_23590;
return (function (acc,p__23591){
var vec__23605 = p__23591;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23605,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23605,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23605,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23605,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23593 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23592,inst_23580,inst_23590);
var state_23601__$1 = state_23601;
var statearr_23608_23691 = state_23601__$1;
(statearr_23608_23691[(2)] = inst_23593);

(statearr_23608_23691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (1))){
var state_23601__$1 = state_23601;
var statearr_23609_23692 = state_23601__$1;
(statearr_23609_23692[(2)] = null);

(statearr_23609_23692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (24))){
var inst_23477 = (state_23601[(7)]);
var inst_23477__$1 = (state_23601[(2)]);
var inst_23478 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23479 = cljs.core.PersistentHashMap.EMPTY;
var inst_23480 = inst_23478;
var inst_23481 = inst_23477__$1;
var inst_23482 = inst_23479;
var state_23601__$1 = (function (){var statearr_23610 = state_23601;
(statearr_23610[(11)] = inst_23480);

(statearr_23610[(12)] = inst_23482);

(statearr_23610[(13)] = inst_23481);

(statearr_23610[(7)] = inst_23477__$1);

return statearr_23610;
})();
var statearr_23611_23693 = state_23601__$1;
(statearr_23611_23693[(2)] = null);

(statearr_23611_23693[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (39))){
var inst_23497 = (state_23601[(14)]);
var inst_23481 = (state_23601[(13)]);
var inst_23490 = (state_23601[(15)]);
var inst_23447 = (state_23601[(10)]);
var inst_23526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23527 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23481,inst_23447,inst_23490,inst_23497,false);
var state_23601__$1 = (function (){var statearr_23612 = state_23601;
(statearr_23612[(16)] = inst_23526);

return statearr_23612;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23601__$1,(42),inst_23527);
} else {
if((state_val_23602 === (46))){
var inst_23480 = (state_23601[(11)]);
var inst_23482 = (state_23601[(12)]);
var inst_23490 = (state_23601[(15)]);
var inst_23544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23545 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23546 = cljs.core.first(inst_23490);
var inst_23547 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23546);
var inst_23548 = [inst_23547];
var inst_23549 = cljs.core.PersistentHashMap.fromArrays(inst_23545,inst_23548);
var inst_23550 = cljs.core.rest(inst_23480);
var inst_23551 = [inst_23549,inst_23550,inst_23482];
var inst_23552 = (new cljs.core.PersistentVector(null,3,(5),inst_23544,inst_23551,null));
var state_23601__$1 = state_23601;
var statearr_23613_23694 = state_23601__$1;
(statearr_23613_23694[(2)] = inst_23552);

(statearr_23613_23694[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (4))){
var inst_23421 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23614_23695 = state_23601__$1;
(statearr_23614_23695[(2)] = inst_23421);

(statearr_23614_23695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (15))){
var inst_23448 = (state_23601[(17)]);
var inst_23447 = (state_23601[(10)]);
var inst_23447__$1 = (state_23601[(2)]);
var inst_23448__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23447__$1);
var state_23601__$1 = (function (){var statearr_23615 = state_23601;
(statearr_23615[(17)] = inst_23448__$1);

(statearr_23615[(10)] = inst_23447__$1);

return statearr_23615;
})();
if(cljs.core.truth_(inst_23448__$1)){
var statearr_23616_23696 = state_23601__$1;
(statearr_23616_23696[(1)] = (16));

} else {
var statearr_23617_23697 = state_23601__$1;
(statearr_23617_23697[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (48))){
var inst_23563 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23618_23698 = state_23601__$1;
(statearr_23618_23698[(2)] = inst_23563);

(statearr_23618_23698[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (50))){
var state_23601__$1 = state_23601;
var statearr_23619_23699 = state_23601__$1;
(statearr_23619_23699[(2)] = null);

(statearr_23619_23699[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (21))){
var inst_23447 = (state_23601[(10)]);
var inst_23461 = (state_23601[(2)]);
var inst_23462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23463 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23464 = (new cljs.core.PersistentVector(null,2,(5),inst_23462,inst_23463,null));
var inst_23465 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23447,inst_23464);
var state_23601__$1 = (function (){var statearr_23620 = state_23601;
(statearr_23620[(8)] = inst_23461);

return statearr_23620;
})();
if(cljs.core.truth_(inst_23465)){
var statearr_23621_23700 = state_23601__$1;
(statearr_23621_23700[(1)] = (22));

} else {
var statearr_23622_23701 = state_23601__$1;
(statearr_23622_23701[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (31))){
var inst_23481 = (state_23601[(13)]);
var inst_23496 = (state_23601[(18)]);
var inst_23490 = (state_23601[(15)]);
var inst_23500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23501 = fluree.db.query.fql.flake__GT_recur(db,inst_23490,inst_23496,inst_23481,fuel,max_fuel,cache);
var state_23601__$1 = (function (){var statearr_23623 = state_23601;
(statearr_23623[(19)] = inst_23500);

return statearr_23623;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23601__$1,(34),inst_23501);
} else {
if((state_val_23602 === (32))){
var inst_23496 = (state_23601[(18)]);
var state_23601__$1 = state_23601;
if(cljs.core.truth_(inst_23496)){
var statearr_23624_23702 = state_23601__$1;
(statearr_23624_23702[(1)] = (35));

} else {
var statearr_23625_23703 = state_23601__$1;
(statearr_23625_23703[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (40))){
var inst_23537 = (state_23601[(20)]);
var inst_23447 = (state_23601[(10)]);
var inst_23536 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23447);
var inst_23537__$1 = cljs.core.empty_QMARK_(inst_23536);
var state_23601__$1 = (function (){var statearr_23626 = state_23601;
(statearr_23626[(20)] = inst_23537__$1);

return statearr_23626;
})();
if(inst_23537__$1){
var statearr_23627_23704 = state_23601__$1;
(statearr_23627_23704[(1)] = (43));

} else {
var statearr_23628_23705 = state_23601__$1;
(statearr_23628_23705[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (33))){
var inst_23490 = (state_23601[(15)]);
var inst_23569 = (state_23601[(2)]);
var inst_23570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23569,(0),null);
var inst_23571 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23569,(1),null);
var inst_23572 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23569,(2),null);
var inst_23573 = cljs.core.first(inst_23490);
var inst_23574 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23573);
var inst_23575 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23570,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23574);
var inst_23480 = inst_23571;
var inst_23481 = inst_23575;
var inst_23482 = inst_23572;
var state_23601__$1 = (function (){var statearr_23629 = state_23601;
(statearr_23629[(11)] = inst_23480);

(statearr_23629[(12)] = inst_23482);

(statearr_23629[(13)] = inst_23481);

return statearr_23629;
})();
var statearr_23630_23706 = state_23601__$1;
(statearr_23630_23706[(2)] = null);

(statearr_23630_23706[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (13))){
var inst_23441 = (state_23601[(9)]);
var inst_23444 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_23441);
var state_23601__$1 = state_23601;
var statearr_23631_23707 = state_23601__$1;
(statearr_23631_23707[(2)] = inst_23444);

(statearr_23631_23707[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (22))){
var inst_23447 = (state_23601[(10)]);
var inst_23467 = cljs.core.first(flakes);
var inst_23468 = fluree.db.query.fql.s(inst_23467);
var inst_23469 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23447);
var inst_23470 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23468,inst_23469);
var state_23601__$1 = state_23601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23601__$1,(25),inst_23470);
} else {
if((state_val_23602 === (36))){
var inst_23447 = (state_23601[(10)]);
var inst_23524 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23447);
var state_23601__$1 = state_23601;
if(cljs.core.truth_(inst_23524)){
var statearr_23632_23708 = state_23601__$1;
(statearr_23632_23708[(1)] = (39));

} else {
var statearr_23633_23709 = state_23601__$1;
(statearr_23633_23709[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (41))){
var inst_23565 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23634_23710 = state_23601__$1;
(statearr_23634_23710[(2)] = inst_23565);

(statearr_23634_23710[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (43))){
var inst_23447 = (state_23601[(10)]);
var inst_23539 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23447);
var state_23601__$1 = state_23601;
var statearr_23635_23711 = state_23601__$1;
(statearr_23635_23711[(2)] = inst_23539);

(statearr_23635_23711[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (29))){
var inst_23480 = (state_23601[(11)]);
var inst_23496 = (state_23601[(18)]);
var inst_23490 = (state_23601[(15)]);
var inst_23447 = (state_23601[(10)]);
var inst_23490__$1 = cljs.core.first(inst_23480);
var inst_23491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23492 = cljs.core.first(inst_23490__$1);
var inst_23493 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23492);
var inst_23494 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23493];
var inst_23495 = (new cljs.core.PersistentVector(null,3,(5),inst_23491,inst_23494,null));
var inst_23496__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23447,inst_23495);
var inst_23497 = fluree.db.query.fql.component_follow_QMARK_(inst_23496__$1,inst_23447);
var inst_23498 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23496__$1);
var state_23601__$1 = (function (){var statearr_23636 = state_23601;
(statearr_23636[(14)] = inst_23497);

(statearr_23636[(18)] = inst_23496__$1);

(statearr_23636[(15)] = inst_23490__$1);

return statearr_23636;
})();
if(cljs.core.truth_(inst_23498)){
var statearr_23637_23712 = state_23601__$1;
(statearr_23637_23712[(1)] = (31));

} else {
var statearr_23638_23713 = state_23601__$1;
(statearr_23638_23713[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (44))){
var inst_23537 = (state_23601[(20)]);
var state_23601__$1 = state_23601;
var statearr_23639_23714 = state_23601__$1;
(statearr_23639_23714[(2)] = inst_23537);

(statearr_23639_23714[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (6))){
var state_23601__$1 = state_23601;
var statearr_23640_23715 = state_23601__$1;
(statearr_23640_23715[(2)] = null);

(statearr_23640_23715[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (28))){
var inst_23481 = (state_23601[(13)]);
var state_23601__$1 = state_23601;
var statearr_23641_23716 = state_23601__$1;
(statearr_23641_23716[(2)] = inst_23481);

(statearr_23641_23716[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (51))){
var inst_23561 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23642_23717 = state_23601__$1;
(statearr_23642_23717[(2)] = inst_23561);

(statearr_23642_23717[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (25))){
var inst_23461 = (state_23601[(8)]);
var inst_23472 = (state_23601[(2)]);
var inst_23473 = fluree.db.util.async.throw_err(inst_23472);
var inst_23474 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23461,inst_23473], 0));
var state_23601__$1 = state_23601;
var statearr_23643_23718 = state_23601__$1;
(statearr_23643_23718[(2)] = inst_23474);

(statearr_23643_23718[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (34))){
var inst_23480 = (state_23601[(11)]);
var inst_23482 = (state_23601[(12)]);
var inst_23500 = (state_23601[(19)]);
var inst_23503 = (state_23601[(2)]);
var inst_23504 = fluree.db.util.async.throw_err(inst_23503);
var inst_23505 = cljs.core.rest(inst_23480);
var inst_23506 = [inst_23504,inst_23505,inst_23482];
var inst_23507 = (new cljs.core.PersistentVector(null,3,(5),inst_23500,inst_23506,null));
var state_23601__$1 = state_23601;
var statearr_23644_23719 = state_23601__$1;
(statearr_23644_23719[(2)] = inst_23507);

(statearr_23644_23719[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (17))){
var inst_23447 = (state_23601[(10)]);
var inst_23451 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23447);
var state_23601__$1 = state_23601;
var statearr_23646_23720 = state_23601__$1;
(statearr_23646_23720[(2)] = inst_23451);

(statearr_23646_23720[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (3))){
var inst_23599 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23601__$1,inst_23599);
} else {
if((state_val_23602 === (12))){
var _ = (function (){var statearr_23647 = state_23601;
(statearr_23647[(4)] = cljs.core.rest((state_23601[(4)])));

return statearr_23647;
})();
var state_23601__$1 = state_23601;
var ex23645 = (state_23601__$1[(2)]);
var statearr_23648_23721 = state_23601__$1;
(statearr_23648_23721[(5)] = ex23645);


var statearr_23649_23722 = state_23601__$1;
(statearr_23649_23722[(1)] = (11));

(statearr_23649_23722[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (2))){
var _ = (function (){var statearr_23650 = state_23601;
(statearr_23650[(4)] = cljs.core.cons((5),(state_23601[(4)])));

return statearr_23650;
})();
var inst_23427 = cljs.core.not_empty(flakes);
var state_23601__$1 = state_23601;
if(cljs.core.truth_(inst_23427)){
var statearr_23651_23723 = state_23601__$1;
(statearr_23651_23723[(1)] = (6));

} else {
var statearr_23652_23724 = state_23601__$1;
(statearr_23652_23724[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (23))){
var inst_23461 = (state_23601[(8)]);
var state_23601__$1 = state_23601;
var statearr_23653_23725 = state_23601__$1;
(statearr_23653_23725[(2)] = inst_23461);

(statearr_23653_23725[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (47))){
var state_23601__$1 = state_23601;
var statearr_23654_23726 = state_23601__$1;
(statearr_23654_23726[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (35))){
var inst_23497 = (state_23601[(14)]);
var inst_23482 = (state_23601[(12)]);
var inst_23481 = (state_23601[(13)]);
var inst_23496 = (state_23601[(18)]);
var inst_23490 = (state_23601[(15)]);
var inst_23513 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23481,inst_23496,inst_23490,inst_23497,false,inst_23482);
var state_23601__$1 = state_23601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23601__$1,(38),inst_23513);
} else {
if((state_val_23602 === (19))){
var inst_23441 = (state_23601[(9)]);
var inst_23455 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23456 = [inst_23441];
var inst_23457 = cljs.core.PersistentHashMap.fromArrays(inst_23455,inst_23456);
var state_23601__$1 = state_23601;
var statearr_23656_23727 = state_23601__$1;
(statearr_23656_23727[(2)] = inst_23457);

(statearr_23656_23727[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (11))){
var inst_23429 = (state_23601[(2)]);
var inst_23430 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23429], 0));
var inst_23431 = (function(){throw inst_23429})();
var state_23601__$1 = (function (){var statearr_23658 = state_23601;
(statearr_23658[(21)] = inst_23430);

return statearr_23658;
})();
var statearr_23659_23728 = state_23601__$1;
(statearr_23659_23728[(2)] = inst_23431);

(statearr_23659_23728[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (9))){
var _ = (function (){var statearr_23660 = state_23601;
(statearr_23660[(4)] = cljs.core.cons((12),(state_23601[(4)])));

return statearr_23660;
})();
var inst_23437 = cljs.core.first(flakes);
var inst_23438 = fluree.db.query.fql.s(inst_23437);
var ___$1 = (function (){var statearr_23661 = state_23601;
(statearr_23661[(4)] = cljs.core.rest((state_23601[(4)])));

return statearr_23661;
})();
var state_23601__$1 = state_23601;
var statearr_23662_23729 = state_23601__$1;
(statearr_23662_23729[(2)] = inst_23438);

(statearr_23662_23729[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (5))){
var _ = (function (){var statearr_23663 = state_23601;
(statearr_23663[(4)] = cljs.core.rest((state_23601[(4)])));

return statearr_23663;
})();
var state_23601__$1 = state_23601;
var ex23657 = (state_23601__$1[(2)]);
var statearr_23664_23730 = state_23601__$1;
(statearr_23664_23730[(5)] = ex23657);


if((ex23657 instanceof Error)){
var statearr_23665_23731 = state_23601__$1;
(statearr_23665_23731[(1)] = (4));

(statearr_23665_23731[(5)] = null);

} else {
throw ex23657;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (14))){
var state_23601__$1 = state_23601;
var statearr_23666_23732 = state_23601__$1;
(statearr_23666_23732[(2)] = base_select_spec);

(statearr_23666_23732[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (45))){
var inst_23542 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
if(cljs.core.truth_(inst_23542)){
var statearr_23667_23733 = state_23601__$1;
(statearr_23667_23733[(1)] = (46));

} else {
var statearr_23668_23734 = state_23601__$1;
(statearr_23668_23734[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (26))){
var inst_23480 = (state_23601[(11)]);
var inst_23484 = cljs.core.empty_QMARK_(inst_23480);
var state_23601__$1 = state_23601;
if(inst_23484){
var statearr_23669_23735 = state_23601__$1;
(statearr_23669_23735[(1)] = (28));

} else {
var statearr_23670_23736 = state_23601__$1;
(statearr_23670_23736[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (16))){
var inst_23448 = (state_23601[(17)]);
var state_23601__$1 = state_23601;
var statearr_23671_23737 = state_23601__$1;
(statearr_23671_23737[(2)] = inst_23448);

(statearr_23671_23737[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (38))){
var inst_23480 = (state_23601[(11)]);
var inst_23515 = (state_23601[(2)]);
var inst_23516 = fluree.db.util.async.throw_err(inst_23515);
var inst_23517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23516,(0),null);
var inst_23518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23516,(1),null);
var inst_23519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23520 = cljs.core.rest(inst_23480);
var inst_23521 = [inst_23517,inst_23520,inst_23518];
var inst_23522 = (new cljs.core.PersistentVector(null,3,(5),inst_23519,inst_23521,null));
var state_23601__$1 = state_23601;
var statearr_23672_23738 = state_23601__$1;
(statearr_23672_23738[(2)] = inst_23522);

(statearr_23672_23738[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (30))){
var inst_23578 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23673_23739 = state_23601__$1;
(statearr_23673_23739[(2)] = inst_23578);

(statearr_23673_23739[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (10))){
var inst_23441 = (state_23601[(2)]);
var inst_23442 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_23601__$1 = (function (){var statearr_23674 = state_23601;
(statearr_23674[(9)] = inst_23441);

return statearr_23674;
})();
if(cljs.core.truth_(inst_23442)){
var statearr_23675_23740 = state_23601__$1;
(statearr_23675_23740[(1)] = (13));

} else {
var statearr_23676_23741 = state_23601__$1;
(statearr_23676_23741[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (18))){
var inst_23453 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
if(cljs.core.truth_(inst_23453)){
var statearr_23677_23742 = state_23601__$1;
(statearr_23677_23742[(1)] = (19));

} else {
var statearr_23678_23743 = state_23601__$1;
(statearr_23678_23743[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (42))){
var inst_23480 = (state_23601[(11)]);
var inst_23482 = (state_23601[(12)]);
var inst_23526 = (state_23601[(16)]);
var inst_23529 = (state_23601[(2)]);
var inst_23530 = fluree.db.util.async.throw_err(inst_23529);
var inst_23531 = cljs.core.first(inst_23530);
var inst_23532 = cljs.core.rest(inst_23480);
var inst_23533 = [inst_23531,inst_23532,inst_23482];
var inst_23534 = (new cljs.core.PersistentVector(null,3,(5),inst_23526,inst_23533,null));
var state_23601__$1 = state_23601;
var statearr_23679_23744 = state_23601__$1;
(statearr_23679_23744[(2)] = inst_23534);

(statearr_23679_23744[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (37))){
var inst_23567 = (state_23601[(2)]);
var state_23601__$1 = state_23601;
var statearr_23680_23745 = state_23601__$1;
(statearr_23680_23745[(2)] = inst_23567);

(statearr_23680_23745[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (8))){
var inst_23596 = (state_23601[(2)]);
var _ = (function (){var statearr_23681 = state_23601;
(statearr_23681[(4)] = cljs.core.rest((state_23601[(4)])));

return statearr_23681;
})();
var state_23601__$1 = state_23601;
var statearr_23682_23746 = state_23601__$1;
(statearr_23682_23746[(2)] = inst_23596);

(statearr_23682_23746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23602 === (49))){
var inst_23480 = (state_23601[(11)]);
var inst_23482 = (state_23601[(12)]);
var inst_23481 = (state_23601[(13)]);
var inst_23555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23556 = cljs.core.rest(inst_23480);
var inst_23557 = [inst_23481,inst_23556,inst_23482];
var inst_23558 = (new cljs.core.PersistentVector(null,3,(5),inst_23555,inst_23557,null));
var state_23601__$1 = state_23601;
var statearr_23683_23747 = state_23601__$1;
(statearr_23683_23747[(2)] = inst_23558);

(statearr_23683_23747[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____0 = (function (){
var statearr_23684 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23684[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__);

(statearr_23684[(1)] = (1));

return statearr_23684;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____1 = (function (state_23601){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23601);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23685){var ex__2736__auto__ = e23685;
var statearr_23686_23748 = state_23601;
(statearr_23686_23748[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23601[(4)]))){
var statearr_23687_23749 = state_23601;
(statearr_23687_23749[(1)] = cljs.core.first((state_23601[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23750 = state_23601;
state_23601 = G__23750;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__ = function(state_23601){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____1.call(this,state_23601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23688 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23688[(6)] = c__2755__auto__);

return statearr_23688;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23753 = arguments.length;
switch (G__23753) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23795){
var state_val_23796 = (state_23795[(1)]);
if((state_val_23796 === (7))){
var inst_23761 = (state_23795[(7)]);
var state_23795__$1 = state_23795;
var statearr_23797_23827 = state_23795__$1;
(statearr_23797_23827[(2)] = inst_23761);

(statearr_23797_23827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (1))){
var state_23795__$1 = state_23795;
var statearr_23798_23828 = state_23795__$1;
(statearr_23798_23828[(2)] = null);

(statearr_23798_23828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (4))){
var inst_23754 = (state_23795[(2)]);
var state_23795__$1 = state_23795;
var statearr_23799_23829 = state_23795__$1;
(statearr_23799_23829[(2)] = inst_23754);

(statearr_23799_23829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (15))){
var inst_23789 = (state_23795[(2)]);
var inst_23790 = fluree.db.util.async.throw_err(inst_23789);
var _ = (function (){var statearr_23800 = state_23795;
(statearr_23800[(4)] = cljs.core.rest((state_23795[(4)])));

return statearr_23800;
})();
var state_23795__$1 = state_23795;
var statearr_23801_23830 = state_23795__$1;
(statearr_23801_23830[(2)] = inst_23790);

(statearr_23801_23830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (13))){
var inst_23773 = (state_23795[(8)]);
var state_23795__$1 = state_23795;
var statearr_23802_23831 = state_23795__$1;
(statearr_23802_23831[(2)] = inst_23773);

(statearr_23802_23831[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (6))){
var inst_23761 = (state_23795[(7)]);
var inst_23763 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23764 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23761,inst_23763);
var state_23795__$1 = state_23795;
var statearr_23803_23832 = state_23795__$1;
(statearr_23803_23832[(2)] = inst_23764);

(statearr_23803_23832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (3))){
var inst_23793 = (state_23795[(2)]);
var state_23795__$1 = state_23795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23795__$1,inst_23793);
} else {
if((state_val_23796 === (12))){
var inst_23773 = (state_23795[(8)]);
var inst_23775 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23776 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23773,inst_23775);
var state_23795__$1 = state_23795;
var statearr_23804_23833 = state_23795__$1;
(statearr_23804_23833[(2)] = inst_23776);

(statearr_23804_23833[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (2))){
var _ = (function (){var statearr_23805 = state_23795;
(statearr_23805[(4)] = cljs.core.cons((5),(state_23795[(4)])));

return statearr_23805;
})();
var inst_23761 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23795__$1 = (function (){var statearr_23806 = state_23795;
(statearr_23806[(7)] = inst_23761);

return statearr_23806;
})();
if(cljs.core.truth_(fuel)){
var statearr_23807_23834 = state_23795__$1;
(statearr_23807_23834[(1)] = (6));

} else {
var statearr_23808_23835 = state_23795__$1;
(statearr_23808_23835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (11))){
var inst_23773 = (state_23795[(2)]);
var state_23795__$1 = (function (){var statearr_23810 = state_23795;
(statearr_23810[(8)] = inst_23773);

return statearr_23810;
})();
if(cljs.core.truth_(limit)){
var statearr_23811_23836 = state_23795__$1;
(statearr_23811_23836[(1)] = (12));

} else {
var statearr_23812_23837 = state_23795__$1;
(statearr_23812_23837[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (9))){
var inst_23767 = (state_23795[(9)]);
var inst_23769 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23770 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23767,inst_23769);
var state_23795__$1 = state_23795;
var statearr_23813_23838 = state_23795__$1;
(statearr_23813_23838[(2)] = inst_23770);

(statearr_23813_23838[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (5))){
var _ = (function (){var statearr_23814 = state_23795;
(statearr_23814[(4)] = cljs.core.rest((state_23795[(4)])));

return statearr_23814;
})();
var state_23795__$1 = state_23795;
var ex23809 = (state_23795__$1[(2)]);
var statearr_23815_23839 = state_23795__$1;
(statearr_23815_23839[(5)] = ex23809);


if((ex23809 instanceof Error)){
var statearr_23816_23840 = state_23795__$1;
(statearr_23816_23840[(1)] = (4));

(statearr_23816_23840[(5)] = null);

} else {
throw ex23809;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (14))){
var inst_23779 = (state_23795[(2)]);
var inst_23780 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_23781 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23780);
var inst_23782 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23779,inst_23781);
var inst_23783 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23782,flakes);
var inst_23784 = cljs.core.PersistentVector.EMPTY;
var inst_23785 = (function (){var xf = inst_23782;
var flakes_by_sub = inst_23783;
return (function (p1__23751_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23751_SHARP_);
});
})();
var inst_23786 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23785,inst_23783);
var inst_23787 = fluree.db.util.async.merge_into_QMARK_(inst_23784,inst_23786);
var state_23795__$1 = state_23795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23795__$1,(15),inst_23787);
} else {
if((state_val_23796 === (10))){
var inst_23767 = (state_23795[(9)]);
var state_23795__$1 = state_23795;
var statearr_23817_23841 = state_23795__$1;
(statearr_23817_23841[(2)] = inst_23767);

(statearr_23817_23841[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23796 === (8))){
var inst_23767 = (state_23795[(2)]);
var state_23795__$1 = (function (){var statearr_23818 = state_23795;
(statearr_23818[(9)] = inst_23767);

return statearr_23818;
})();
if(cljs.core.truth_(offset)){
var statearr_23819_23842 = state_23795__$1;
(statearr_23819_23842[(1)] = (9));

} else {
var statearr_23820_23843 = state_23795__$1;
(statearr_23820_23843[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_23821 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23821[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_23821[(1)] = (1));

return statearr_23821;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_23795){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23795);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23822){var ex__2736__auto__ = e23822;
var statearr_23823_23844 = state_23795;
(statearr_23823_23844[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23795[(4)]))){
var statearr_23824_23845 = state_23795;
(statearr_23824_23845[(1)] = cljs.core.first((state_23795[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23846 = state_23795;
state_23795 = G__23846;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_23795){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_23795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23825 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23825[(6)] = c__2755__auto__);

return statearr_23825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23848 = arguments.length;
switch (G__23848) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23934){
var state_val_23935 = (state_23934[(1)]);
if((state_val_23935 === (7))){
var inst_23929 = (state_23934[(2)]);
var _ = (function (){var statearr_23937 = state_23934;
(statearr_23937[(4)] = cljs.core.rest((state_23934[(4)])));

return statearr_23937;
})();
var state_23934__$1 = state_23934;
var statearr_23938_23990 = state_23934__$1;
(statearr_23938_23990[(2)] = inst_23929);

(statearr_23938_23990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (20))){
var inst_23868 = (state_23934[(7)]);
var inst_23869 = (state_23934[(8)]);
var inst_23876 = (state_23934[(9)]);
var inst_23897 = (inst_23868 + (1));
var tmp23936 = inst_23869;
var inst_23867 = inst_23876;
var inst_23868__$1 = inst_23897;
var inst_23869__$1 = tmp23936;
var state_23934__$1 = (function (){var statearr_23939 = state_23934;
(statearr_23939[(7)] = inst_23868__$1);

(statearr_23939[(10)] = inst_23867);

(statearr_23939[(8)] = inst_23869__$1);

return statearr_23939;
})();
var statearr_23940_23991 = state_23934__$1;
(statearr_23940_23991[(2)] = null);

(statearr_23940_23991[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (27))){
var inst_23907 = (state_23934[(11)]);
var inst_23909 = cljs.core.count(inst_23907);
var inst_23910 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_23909);
var state_23934__$1 = state_23934;
var statearr_23941_23992 = state_23934__$1;
(statearr_23941_23992[(2)] = inst_23910);

(statearr_23941_23992[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (1))){
var state_23934__$1 = state_23934;
var statearr_23942_23993 = state_23934__$1;
(statearr_23942_23993[(2)] = null);

(statearr_23942_23993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (24))){
var state_23934__$1 = state_23934;
var statearr_23943_23994 = state_23934__$1;
(statearr_23943_23994[(2)] = null);

(statearr_23943_23994[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (4))){
var inst_23849 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
var statearr_23944_23995 = state_23934__$1;
(statearr_23944_23995[(2)] = inst_23849);

(statearr_23944_23995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (15))){
var inst_23890 = (state_23934[(12)]);
var inst_23890__$1 = offset;
var state_23934__$1 = (function (){var statearr_23945 = state_23934;
(statearr_23945[(12)] = inst_23890__$1);

return statearr_23945;
})();
if(cljs.core.truth_(inst_23890__$1)){
var statearr_23946_23996 = state_23934__$1;
(statearr_23946_23996[(1)] = (17));

} else {
var statearr_23947_23997 = state_23934__$1;
(statearr_23947_23997[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (21))){
var state_23934__$1 = state_23934;
var statearr_23948_23998 = state_23934__$1;
(statearr_23948_23998[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (13))){
var inst_23885 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
var statearr_23950_23999 = state_23934__$1;
(statearr_23950_23999[(2)] = inst_23885);

(statearr_23950_23999[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (22))){
var inst_23925 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
var statearr_23951_24000 = state_23934__$1;
(statearr_23951_24000[(2)] = inst_23925);

(statearr_23951_24000[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (29))){
var inst_23907 = (state_23934[(11)]);
var inst_23868 = (state_23934[(7)]);
var inst_23913 = (state_23934[(2)]);
var inst_23914 = (inst_23868 + (1));
var inst_23915 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_23907);
var state_23934__$1 = (function (){var statearr_23952 = state_23934;
(statearr_23952[(13)] = inst_23914);

(statearr_23952[(14)] = inst_23913);

return statearr_23952;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23934__$1,(30),inst_23915);
} else {
if((state_val_23935 === (6))){
var inst_23877 = (state_23934[(15)]);
var inst_23867 = (state_23934[(10)]);
var inst_23875 = (state_23934[(16)]);
var inst_23874 = cljs.core.seq(inst_23867);
var inst_23875__$1 = cljs.core.first(inst_23874);
var inst_23876 = cljs.core.next(inst_23874);
var inst_23877__$1 = (inst_23875__$1 == null);
var state_23934__$1 = (function (){var statearr_23953 = state_23934;
(statearr_23953[(15)] = inst_23877__$1);

(statearr_23953[(16)] = inst_23875__$1);

(statearr_23953[(9)] = inst_23876);

return statearr_23953;
})();
if(cljs.core.truth_(inst_23877__$1)){
var statearr_23954_24001 = state_23934__$1;
(statearr_23954_24001[(1)] = (8));

} else {
var statearr_23955_24002 = state_23934__$1;
(statearr_23955_24002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (28))){
var state_23934__$1 = state_23934;
var statearr_23956_24003 = state_23934__$1;
(statearr_23956_24003[(2)] = null);

(statearr_23956_24003[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (25))){
var inst_23923 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
var statearr_23957_24004 = state_23934__$1;
(statearr_23957_24004[(2)] = inst_23923);

(statearr_23957_24004[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (17))){
var inst_23868 = (state_23934[(7)]);
var inst_23892 = (inst_23868 < offset);
var state_23934__$1 = state_23934;
var statearr_23958_24005 = state_23934__$1;
(statearr_23958_24005[(2)] = inst_23892);

(statearr_23958_24005[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (3))){
var inst_23932 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23934__$1,inst_23932);
} else {
if((state_val_23935 === (12))){
var inst_23880 = (state_23934[(17)]);
var state_23934__$1 = state_23934;
var statearr_23959_24006 = state_23934__$1;
(statearr_23959_24006[(2)] = inst_23880);

(statearr_23959_24006[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (2))){
var _ = (function (){var statearr_23960 = state_23934;
(statearr_23960[(4)] = cljs.core.cons((5),(state_23934[(4)])));

return statearr_23960;
})();
var inst_23862 = subjects;
var inst_23863 = cljs.core.seq(inst_23862);
var inst_23864 = cljs.core.first(inst_23863);
var inst_23865 = cljs.core.next(inst_23863);
var inst_23866 = cljs.core.PersistentVector.EMPTY;
var inst_23867 = inst_23862;
var inst_23868 = (0);
var inst_23869 = inst_23866;
var state_23934__$1 = (function (){var statearr_23961 = state_23934;
(statearr_23961[(7)] = inst_23868);

(statearr_23961[(18)] = inst_23865);

(statearr_23961[(19)] = inst_23864);

(statearr_23961[(10)] = inst_23867);

(statearr_23961[(8)] = inst_23869);

return statearr_23961;
})();
var statearr_23962_24007 = state_23934__$1;
(statearr_23962_24007[(2)] = null);

(statearr_23962_24007[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (23))){
var inst_23875 = (state_23934[(16)]);
var inst_23901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23902 = [inst_23875];
var inst_23903 = (new cljs.core.PersistentVector(null,1,(5),inst_23901,inst_23902,null));
var inst_23904 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23903);
var state_23934__$1 = state_23934;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23934__$1,(26),inst_23904);
} else {
if((state_val_23935 === (19))){
var inst_23895 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
if(cljs.core.truth_(inst_23895)){
var statearr_23963_24008 = state_23934__$1;
(statearr_23963_24008[(1)] = (20));

} else {
var statearr_23964_24009 = state_23934__$1;
(statearr_23964_24009[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (11))){
var inst_23868 = (state_23934[(7)]);
var inst_23882 = (inst_23868 > limit);
var state_23934__$1 = state_23934;
var statearr_23966_24010 = state_23934__$1;
(statearr_23966_24010[(2)] = inst_23882);

(statearr_23966_24010[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (9))){
var inst_23880 = (state_23934[(17)]);
var inst_23880__$1 = limit;
var state_23934__$1 = (function (){var statearr_23967 = state_23934;
(statearr_23967[(17)] = inst_23880__$1);

return statearr_23967;
})();
if(cljs.core.truth_(inst_23880__$1)){
var statearr_23968_24011 = state_23934__$1;
(statearr_23968_24011[(1)] = (11));

} else {
var statearr_23969_24012 = state_23934__$1;
(statearr_23969_24012[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (5))){
var _ = (function (){var statearr_23970 = state_23934;
(statearr_23970[(4)] = cljs.core.rest((state_23934[(4)])));

return statearr_23970;
})();
var state_23934__$1 = state_23934;
var ex23965 = (state_23934__$1[(2)]);
var statearr_23971_24013 = state_23934__$1;
(statearr_23971_24013[(5)] = ex23965);


if((ex23965 instanceof Error)){
var statearr_23972_24014 = state_23934__$1;
(statearr_23972_24014[(1)] = (4));

(statearr_23972_24014[(5)] = null);

} else {
throw ex23965;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (14))){
var inst_23869 = (state_23934[(8)]);
var state_23934__$1 = state_23934;
var statearr_23973_24015 = state_23934__$1;
(statearr_23973_24015[(2)] = inst_23869);

(statearr_23973_24015[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (26))){
var inst_23906 = (state_23934[(2)]);
var inst_23907 = fluree.db.util.async.throw_err(inst_23906);
var state_23934__$1 = (function (){var statearr_23974 = state_23934;
(statearr_23974[(11)] = inst_23907);

return statearr_23974;
})();
if(cljs.core.truth_(fuel)){
var statearr_23975_24016 = state_23934__$1;
(statearr_23975_24016[(1)] = (27));

} else {
var statearr_23976_24017 = state_23934__$1;
(statearr_23976_24017[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (16))){
var inst_23927 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
var statearr_23977_24018 = state_23934__$1;
(statearr_23977_24018[(2)] = inst_23927);

(statearr_23977_24018[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (30))){
var inst_23914 = (state_23934[(13)]);
var inst_23869 = (state_23934[(8)]);
var inst_23876 = (state_23934[(9)]);
var inst_23917 = (state_23934[(2)]);
var inst_23918 = fluree.db.util.async.throw_err(inst_23917);
var inst_23919 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23869,inst_23918);
var inst_23867 = inst_23876;
var inst_23868 = inst_23914;
var inst_23869__$1 = inst_23919;
var state_23934__$1 = (function (){var statearr_23978 = state_23934;
(statearr_23978[(7)] = inst_23868);

(statearr_23978[(10)] = inst_23867);

(statearr_23978[(8)] = inst_23869__$1);

return statearr_23978;
})();
var statearr_23979_24019 = state_23934__$1;
(statearr_23979_24019[(2)] = null);

(statearr_23979_24019[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (10))){
var inst_23887 = (state_23934[(2)]);
var state_23934__$1 = state_23934;
if(cljs.core.truth_(inst_23887)){
var statearr_23980_24020 = state_23934__$1;
(statearr_23980_24020[(1)] = (14));

} else {
var statearr_23981_24021 = state_23934__$1;
(statearr_23981_24021[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (18))){
var inst_23890 = (state_23934[(12)]);
var state_23934__$1 = state_23934;
var statearr_23982_24022 = state_23934__$1;
(statearr_23982_24022[(2)] = inst_23890);

(statearr_23982_24022[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23935 === (8))){
var inst_23877 = (state_23934[(15)]);
var state_23934__$1 = state_23934;
var statearr_23983_24023 = state_23934__$1;
(statearr_23983_24023[(2)] = inst_23877);

(statearr_23983_24023[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_23984 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23984[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_23984[(1)] = (1));

return statearr_23984;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_23934){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23934);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23985){var ex__2736__auto__ = e23985;
var statearr_23986_24024 = state_23934;
(statearr_23986_24024[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23934[(4)]))){
var statearr_23987_24025 = state_23934;
(statearr_23987_24025[(1)] = cljs.core.first((state_23934[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24026 = state_23934;
state_23934 = G__24026;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_23934){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_23934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23988 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23988[(6)] = c__2755__auto__);

return statearr_23988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24028 = arguments.length;
switch (G__24028) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24219){
var state_val_24220 = (state_24219[(1)]);
if((state_val_24220 === (7))){
var state_24219__$1 = state_24219;
var statearr_24221_24296 = state_24219__$1;
(statearr_24221_24296[(2)] = null);

(statearr_24221_24296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (20))){
var inst_24071 = (state_24219[(7)]);
var inst_24069 = (state_24219[(8)]);
var inst_24099 = (state_24219[(2)]);
var inst_24100 = fluree.db.util.async.throw_err(inst_24099);
var inst_24101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24102 = [inst_24069];
var inst_24103 = (new cljs.core.PersistentVector(null,1,(5),inst_24101,inst_24102,null));
var inst_24104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24105 = [inst_24069,inst_24071];
var inst_24106 = (new cljs.core.PersistentVector(null,2,(5),inst_24104,inst_24105,null));
var inst_24107 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24103,cljs.core._LT_,inst_24106);
var state_24219__$1 = (function (){var statearr_24222 = state_24219;
(statearr_24222[(9)] = inst_24100);

return statearr_24222;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24219__$1,(21),inst_24107);
} else {
if((state_val_24220 === (27))){
var inst_24070 = (state_24219[(10)]);
var inst_24088 = (state_24219[(11)]);
var inst_24136 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_24070) : inst_24088.call(null,cljs.core._GT__EQ_,inst_24070));
var state_24219__$1 = state_24219;
if(cljs.core.truth_(inst_24136)){
var statearr_24223_24297 = state_24219__$1;
(statearr_24223_24297[(1)] = (30));

} else {
var statearr_24224_24298 = state_24219__$1;
(statearr_24224_24298[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (1))){
var state_24219__$1 = state_24219;
var statearr_24225_24299 = state_24219__$1;
(statearr_24225_24299[(2)] = null);

(statearr_24225_24299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (24))){
var inst_24185 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24226_24300 = state_24219__$1;
(statearr_24226_24300[(2)] = inst_24185);

(statearr_24226_24300[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (39))){
var inst_24175 = null;
var state_24219__$1 = state_24219;
var statearr_24227_24301 = state_24219__$1;
(statearr_24227_24301[(2)] = inst_24175);

(statearr_24227_24301[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (46))){
var inst_24197 = (state_24219[(12)]);
var state_24219__$1 = state_24219;
var statearr_24228_24302 = state_24219__$1;
(statearr_24228_24302[(2)] = inst_24197);

(statearr_24228_24302[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (4))){
var inst_24029 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24229_24303 = state_24219__$1;
(statearr_24229_24303[(2)] = inst_24029);

(statearr_24229_24303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (15))){
var state_24219__$1 = state_24219;
var statearr_24230_24304 = state_24219__$1;
(statearr_24230_24304[(2)] = null);

(statearr_24230_24304[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (48))){
var inst_24196 = (state_24219[(13)]);
var state_24219__$1 = state_24219;
var statearr_24231_24305 = state_24219__$1;
(statearr_24231_24305[(2)] = inst_24196);

(statearr_24231_24305[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (50))){
var inst_24207 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24232_24306 = state_24219__$1;
(statearr_24232_24306[(2)] = inst_24207);

(statearr_24232_24306[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (21))){
var inst_24100 = (state_24219[(9)]);
var inst_24109 = (state_24219[(2)]);
var inst_24110 = fluree.db.util.async.throw_err(inst_24109);
var inst_24111 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24100,inst_24110);
var state_24219__$1 = state_24219;
var statearr_24233_24307 = state_24219__$1;
(statearr_24233_24307[(2)] = inst_24111);

(statearr_24233_24307[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (31))){
var inst_24070 = (state_24219[(10)]);
var inst_24088 = (state_24219[(11)]);
var inst_24149 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_24070) : inst_24088.call(null,cljs.core._LT_,inst_24070));
var state_24219__$1 = state_24219;
if(cljs.core.truth_(inst_24149)){
var statearr_24234_24308 = state_24219__$1;
(statearr_24234_24308[(1)] = (34));

} else {
var statearr_24235_24309 = state_24219__$1;
(statearr_24235_24309[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (32))){
var inst_24181 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24236_24310 = state_24219__$1;
(statearr_24236_24310[(2)] = inst_24181);

(statearr_24236_24310[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (40))){
var inst_24177 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24237_24311 = state_24219__$1;
(statearr_24237_24311[(2)] = inst_24177);

(statearr_24237_24311[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (33))){
var inst_24146 = (state_24219[(2)]);
var inst_24147 = fluree.db.util.async.throw_err(inst_24146);
var state_24219__$1 = state_24219;
var statearr_24238_24312 = state_24219__$1;
(statearr_24238_24312[(2)] = inst_24147);

(statearr_24238_24312[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (13))){
var inst_24209 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24239_24313 = state_24219__$1;
(statearr_24239_24313[(2)] = inst_24209);

(statearr_24239_24313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (22))){
var inst_24071 = (state_24219[(7)]);
var inst_24069 = (state_24219[(8)]);
var inst_24115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24116 = [inst_24069,inst_24071];
var inst_24117 = (new cljs.core.PersistentVector(null,2,(5),inst_24115,inst_24116,null));
var inst_24118 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24117);
var state_24219__$1 = state_24219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24219__$1,(25),inst_24118);
} else {
if((state_val_24220 === (36))){
var inst_24179 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24240_24314 = state_24219__$1;
(statearr_24240_24314[(2)] = inst_24179);

(statearr_24240_24314[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (41))){
var inst_24172 = (state_24219[(2)]);
var inst_24173 = fluree.db.util.async.throw_err(inst_24172);
var state_24219__$1 = state_24219;
var statearr_24241_24315 = state_24219__$1;
(statearr_24241_24315[(2)] = inst_24173);

(statearr_24241_24315[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (43))){
var inst_24188 = (state_24219[(14)]);
var inst_24055 = (state_24219[(15)]);
var inst_24189 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24055,inst_24188);
var state_24219__$1 = state_24219;
var statearr_24242_24316 = state_24219__$1;
(statearr_24242_24316[(2)] = inst_24189);

(statearr_24242_24316[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (29))){
var inst_24133 = (state_24219[(2)]);
var inst_24134 = fluree.db.util.async.throw_err(inst_24133);
var state_24219__$1 = state_24219;
var statearr_24243_24317 = state_24219__$1;
(statearr_24243_24317[(2)] = inst_24134);

(statearr_24243_24317[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (44))){
var inst_24188 = (state_24219[(14)]);
var inst_24055 = (state_24219[(15)]);
var inst_24191 = cljs.core.PersistentHashSet.EMPTY;
var inst_24192 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24191,inst_24188);
var inst_24193 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24055,inst_24192);
var state_24219__$1 = state_24219;
var statearr_24244_24318 = state_24219__$1;
(statearr_24244_24318[(2)] = inst_24193);

(statearr_24244_24318[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (6))){
var inst_24040 = (state_24219[(16)]);
var inst_24050 = cljs.core.seq(inst_24040);
var inst_24051 = cljs.core.first(inst_24050);
var inst_24052 = cljs.core.next(inst_24050);
var inst_24053 = cljs.core.PersistentHashSet.EMPTY;
var inst_24054 = inst_24040;
var inst_24055 = inst_24053;
var state_24219__$1 = (function (){var statearr_24245 = state_24219;
(statearr_24245[(17)] = inst_24052);

(statearr_24245[(18)] = inst_24051);

(statearr_24245[(15)] = inst_24055);

(statearr_24245[(19)] = inst_24054);

return statearr_24245;
})();
var statearr_24246_24319 = state_24219__$1;
(statearr_24246_24319[(2)] = null);

(statearr_24246_24319[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (28))){
var inst_24183 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24247_24320 = state_24219__$1;
(statearr_24247_24320[(2)] = inst_24183);

(statearr_24247_24320[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (25))){
var inst_24120 = (state_24219[(2)]);
var inst_24121 = fluree.db.util.async.throw_err(inst_24120);
var state_24219__$1 = state_24219;
var statearr_24248_24321 = state_24219__$1;
(statearr_24248_24321[(2)] = inst_24121);

(statearr_24248_24321[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (34))){
var inst_24071 = (state_24219[(7)]);
var inst_24069 = (state_24219[(8)]);
var inst_24151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24152 = [inst_24069];
var inst_24153 = (new cljs.core.PersistentVector(null,1,(5),inst_24151,inst_24152,null));
var inst_24154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24155 = [inst_24069,inst_24071];
var inst_24156 = (new cljs.core.PersistentVector(null,2,(5),inst_24154,inst_24155,null));
var inst_24157 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24153,cljs.core._LT_,inst_24156);
var state_24219__$1 = state_24219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24219__$1,(37),inst_24157);
} else {
if((state_val_24220 === (17))){
var inst_24071 = (state_24219[(7)]);
var inst_24069 = (state_24219[(8)]);
var inst_24091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24092 = [inst_24069,inst_24071];
var inst_24093 = (new cljs.core.PersistentVector(null,2,(5),inst_24091,inst_24092,null));
var inst_24094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24095 = [inst_24069];
var inst_24096 = (new cljs.core.PersistentVector(null,1,(5),inst_24094,inst_24095,null));
var inst_24097 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24093,cljs.core._LT__EQ_,inst_24096);
var state_24219__$1 = state_24219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24219__$1,(20),inst_24097);
} else {
if((state_val_24220 === (3))){
var inst_24217 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24219__$1,inst_24217);
} else {
if((state_val_24220 === (12))){
var inst_24069 = (state_24219[(8)]);
var inst_24061 = (state_24219[(20)]);
var inst_24069__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24061,(0),null);
var inst_24070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24061,(1),null);
var inst_24071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24061,(2),null);
var inst_24072 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_24069__$1);
var inst_24073 = cljs.core.not(inst_24072);
var state_24219__$1 = (function (){var statearr_24249 = state_24219;
(statearr_24249[(7)] = inst_24071);

(statearr_24249[(8)] = inst_24069__$1);

(statearr_24249[(10)] = inst_24070);

return statearr_24249;
})();
if(inst_24073){
var statearr_24250_24322 = state_24219__$1;
(statearr_24250_24322[(1)] = (14));

} else {
var statearr_24251_24323 = state_24219__$1;
(statearr_24251_24323[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (2))){
var inst_24040 = (state_24219[(16)]);
var _ = (function (){var statearr_24252 = state_24219;
(statearr_24252[(4)] = cljs.core.cons((5),(state_24219[(4)])));

return statearr_24252;
})();
var inst_24038 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_24039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24038,(0),null);
var inst_24040__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24038,(1),null);
var inst_24041 = cljs.core.not_empty(inst_24040__$1);
var state_24219__$1 = (function (){var statearr_24253 = state_24219;
(statearr_24253[(16)] = inst_24040__$1);

(statearr_24253[(21)] = inst_24039);

return statearr_24253;
})();
if(cljs.core.truth_(inst_24041)){
var statearr_24254_24324 = state_24219__$1;
(statearr_24254_24324[(1)] = (6));

} else {
var statearr_24255_24325 = state_24219__$1;
(statearr_24255_24325[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (23))){
var inst_24070 = (state_24219[(10)]);
var inst_24088 = (state_24219[(11)]);
var inst_24123 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_24070) : inst_24088.call(null,cljs.core._GT_,inst_24070));
var state_24219__$1 = state_24219;
if(cljs.core.truth_(inst_24123)){
var statearr_24256_24326 = state_24219__$1;
(statearr_24256_24326[(1)] = (26));

} else {
var statearr_24257_24327 = state_24219__$1;
(statearr_24257_24327[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (47))){
var inst_24202 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
if(cljs.core.truth_(inst_24202)){
var statearr_24258_24328 = state_24219__$1;
(statearr_24258_24328[(1)] = (48));

} else {
var statearr_24259_24329 = state_24219__$1;
(statearr_24259_24329[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (35))){
var inst_24070 = (state_24219[(10)]);
var inst_24088 = (state_24219[(11)]);
var inst_24162 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_24070) : inst_24088.call(null,cljs.core._LT__EQ_,inst_24070));
var state_24219__$1 = state_24219;
if(cljs.core.truth_(inst_24162)){
var statearr_24260_24330 = state_24219__$1;
(statearr_24260_24330[(1)] = (38));

} else {
var statearr_24261_24331 = state_24219__$1;
(statearr_24261_24331[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (19))){
var inst_24039 = (state_24219[(21)]);
var inst_24187 = (state_24219[(2)]);
var inst_24188 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_24187);
var state_24219__$1 = (function (){var statearr_24262 = state_24219;
(statearr_24262[(14)] = inst_24188);

return statearr_24262;
})();
var G__24263_24332 = inst_24039;
var G__24263_24333__$1 = (((G__24263_24332 instanceof cljs.core.Keyword))?G__24263_24332.fqn:null);
switch (G__24263_24333__$1) {
case "or":
var statearr_24264_24335 = state_24219__$1;
(statearr_24264_24335[(1)] = (43));


break;
case "and":
var statearr_24265_24336 = state_24219__$1;
(statearr_24265_24336[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24263_24333__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (11))){
var inst_24055 = (state_24219[(15)]);
var state_24219__$1 = state_24219;
var statearr_24267_24337 = state_24219__$1;
(statearr_24267_24337[(2)] = inst_24055);

(statearr_24267_24337[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (9))){
var inst_24061 = (state_24219[(20)]);
var inst_24054 = (state_24219[(19)]);
var inst_24060 = cljs.core.seq(inst_24054);
var inst_24061__$1 = cljs.core.first(inst_24060);
var inst_24062 = cljs.core.next(inst_24060);
var inst_24063 = cljs.core.not(inst_24061__$1);
var state_24219__$1 = (function (){var statearr_24268 = state_24219;
(statearr_24268[(22)] = inst_24062);

(statearr_24268[(20)] = inst_24061__$1);

return statearr_24268;
})();
if(inst_24063){
var statearr_24269_24338 = state_24219__$1;
(statearr_24269_24338[(1)] = (11));

} else {
var statearr_24270_24339 = state_24219__$1;
(statearr_24270_24339[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (5))){
var _ = (function (){var statearr_24271 = state_24219;
(statearr_24271[(4)] = cljs.core.rest((state_24219[(4)])));

return statearr_24271;
})();
var state_24219__$1 = state_24219;
var ex24266 = (state_24219__$1[(2)]);
var statearr_24272_24340 = state_24219__$1;
(statearr_24272_24340[(5)] = ex24266);


if((ex24266 instanceof Error)){
var statearr_24273_24341 = state_24219__$1;
(statearr_24273_24341[(1)] = (4));

(statearr_24273_24341[(5)] = null);

} else {
throw ex24266;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (14))){
var inst_24069 = (state_24219[(8)]);
var inst_24075 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24069);
var inst_24076 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24075)].join('');
var inst_24077 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24078 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24079 = cljs.core.PersistentHashMap.fromArrays(inst_24077,inst_24078);
var inst_24080 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24076,inst_24079);
var inst_24081 = (function(){throw inst_24080})();
var state_24219__$1 = state_24219;
var statearr_24274_24342 = state_24219__$1;
(statearr_24274_24342[(2)] = inst_24081);

(statearr_24274_24342[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (45))){
var inst_24196 = (state_24219[(13)]);
var inst_24199 = cljs.core.empty_QMARK_(inst_24196);
var state_24219__$1 = state_24219;
var statearr_24275_24343 = state_24219__$1;
(statearr_24275_24343[(2)] = inst_24199);

(statearr_24275_24343[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (26))){
var inst_24071 = (state_24219[(7)]);
var inst_24069 = (state_24219[(8)]);
var inst_24125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24126 = [inst_24069,inst_24071];
var inst_24127 = (new cljs.core.PersistentVector(null,2,(5),inst_24125,inst_24126,null));
var inst_24128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24129 = [inst_24069];
var inst_24130 = (new cljs.core.PersistentVector(null,1,(5),inst_24128,inst_24129,null));
var inst_24131 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24127,cljs.core._LT__EQ_,inst_24130);
var state_24219__$1 = state_24219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24219__$1,(29),inst_24131);
} else {
if((state_val_24220 === (16))){
var inst_24070 = (state_24219[(10)]);
var inst_24088 = (state_24219[(11)]);
var inst_24084 = (state_24219[(2)]);
var inst_24088__$1 = cljs.core.identical_QMARK_;
var inst_24089 = (inst_24088__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24088__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_24070) : inst_24088__$1.call(null,cljs.core.not_EQ_,inst_24070));
var state_24219__$1 = (function (){var statearr_24276 = state_24219;
(statearr_24276[(23)] = inst_24084);

(statearr_24276[(11)] = inst_24088__$1);

return statearr_24276;
})();
if(cljs.core.truth_(inst_24089)){
var statearr_24277_24344 = state_24219__$1;
(statearr_24277_24344[(1)] = (17));

} else {
var statearr_24278_24345 = state_24219__$1;
(statearr_24278_24345[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (38))){
var inst_24071 = (state_24219[(7)]);
var inst_24069 = (state_24219[(8)]);
var inst_24164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24165 = [inst_24069];
var inst_24166 = (new cljs.core.PersistentVector(null,1,(5),inst_24164,inst_24165,null));
var inst_24167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24168 = [inst_24069,inst_24071];
var inst_24169 = (new cljs.core.PersistentVector(null,2,(5),inst_24167,inst_24168,null));
var inst_24170 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24166,cljs.core._LT__EQ_,inst_24169);
var state_24219__$1 = state_24219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24219__$1,(41),inst_24170);
} else {
if((state_val_24220 === (30))){
var inst_24071 = (state_24219[(7)]);
var inst_24069 = (state_24219[(8)]);
var inst_24138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24139 = [inst_24069,inst_24071];
var inst_24140 = (new cljs.core.PersistentVector(null,2,(5),inst_24138,inst_24139,null));
var inst_24141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24142 = [inst_24069];
var inst_24143 = (new cljs.core.PersistentVector(null,1,(5),inst_24141,inst_24142,null));
var inst_24144 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24140,cljs.core._LT__EQ_,inst_24143);
var state_24219__$1 = state_24219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24219__$1,(33),inst_24144);
} else {
if((state_val_24220 === (10))){
var inst_24211 = (state_24219[(2)]);
var state_24219__$1 = state_24219;
var statearr_24279_24346 = state_24219__$1;
(statearr_24279_24346[(2)] = inst_24211);

(statearr_24279_24346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (18))){
var inst_24070 = (state_24219[(10)]);
var inst_24088 = (state_24219[(11)]);
var inst_24113 = (inst_24088.cljs$core$IFn$_invoke$arity$2 ? inst_24088.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_24070) : inst_24088.call(null,cljs.core._EQ_,inst_24070));
var state_24219__$1 = state_24219;
if(cljs.core.truth_(inst_24113)){
var statearr_24280_24347 = state_24219__$1;
(statearr_24280_24347[(1)] = (22));

} else {
var statearr_24281_24348 = state_24219__$1;
(statearr_24281_24348[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (42))){
var inst_24197 = (state_24219[(12)]);
var inst_24039 = (state_24219[(21)]);
var inst_24196 = (state_24219[(2)]);
var inst_24197__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24039);
var state_24219__$1 = (function (){var statearr_24282 = state_24219;
(statearr_24282[(13)] = inst_24196);

(statearr_24282[(12)] = inst_24197__$1);

return statearr_24282;
})();
if(inst_24197__$1){
var statearr_24283_24349 = state_24219__$1;
(statearr_24283_24349[(1)] = (45));

} else {
var statearr_24284_24350 = state_24219__$1;
(statearr_24284_24350[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (37))){
var inst_24159 = (state_24219[(2)]);
var inst_24160 = fluree.db.util.async.throw_err(inst_24159);
var state_24219__$1 = state_24219;
var statearr_24285_24351 = state_24219__$1;
(statearr_24285_24351[(2)] = inst_24160);

(statearr_24285_24351[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (8))){
var inst_24214 = (state_24219[(2)]);
var _ = (function (){var statearr_24286 = state_24219;
(statearr_24286[(4)] = cljs.core.rest((state_24219[(4)])));

return statearr_24286;
})();
var state_24219__$1 = state_24219;
var statearr_24287_24352 = state_24219__$1;
(statearr_24287_24352[(2)] = inst_24214);

(statearr_24287_24352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24220 === (49))){
var inst_24196 = (state_24219[(13)]);
var inst_24062 = (state_24219[(22)]);
var inst_24054 = inst_24062;
var inst_24055 = inst_24196;
var state_24219__$1 = (function (){var statearr_24288 = state_24219;
(statearr_24288[(15)] = inst_24055);

(statearr_24288[(19)] = inst_24054);

return statearr_24288;
})();
var statearr_24289_24353 = state_24219__$1;
(statearr_24289_24353[(2)] = null);

(statearr_24289_24353[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_24290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24290[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_24290[(1)] = (1));

return statearr_24290;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_24219){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24219);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24291){var ex__2736__auto__ = e24291;
var statearr_24292_24354 = state_24219;
(statearr_24292_24354[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24219[(4)]))){
var statearr_24293_24355 = state_24219;
(statearr_24293_24355[(1)] = cljs.core.first((state_24219[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24356 = state_24219;
state_24219 = G__24356;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_24219){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_24219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24294 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24294[(6)] = c__2755__auto__);

return statearr_24294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_((function (p1__24357_SHARP_){
return ((typeof p1__24357_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__24357_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24358_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24358_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24362 = vars;
var vec__24363 = G__24362;
var seq__24364 = cljs.core.seq(vec__24363);
var first__24365 = cljs.core.first(seq__24364);
var seq__24364__$1 = cljs.core.next(seq__24364);
var var$ = first__24365;
var r = seq__24364__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24362__$1 = G__24362;
var all_vars__$1 = all_vars;
while(true){
var vec__24370 = G__24362__$1;
var seq__24371 = cljs.core.seq(vec__24370);
var first__24372 = cljs.core.first(seq__24371);
var seq__24371__$1 = cljs.core.next(seq__24371);
var var$__$1 = first__24372;
var r__$1 = seq__24371__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24373 = cljs.core.set(all_vars__$2);
return (fexpr__24373.cljs$core$IFn$_invoke$arity$1 ? fexpr__24373.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24373.call(null,var$__$1));
})())){
var G__24374 = r__$1;
var G__24375 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24362__$1 = G__24374;
all_vars__$1 = G__24375;
continue;
} else {
var G__24376 = r__$1;
var G__24377 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24362__$1 = G__24376;
all_vars__$1 = G__24377;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24412){
var state_val_24413 = (state_24412[(1)]);
if((state_val_24413 === (1))){
var inst_24385 = functionArray;
var inst_24386 = cljs.core.seq(inst_24385);
var inst_24387 = cljs.core.first(inst_24386);
var inst_24388 = cljs.core.next(inst_24386);
var inst_24389 = cljs.core.PersistentVector.EMPTY;
var inst_24390 = inst_24385;
var inst_24391 = inst_24389;
var state_24412__$1 = (function (){var statearr_24414 = state_24412;
(statearr_24414[(7)] = inst_24388);

(statearr_24414[(8)] = inst_24387);

(statearr_24414[(9)] = inst_24391);

(statearr_24414[(10)] = inst_24390);

return statearr_24414;
})();
var statearr_24415_24428 = state_24412__$1;
(statearr_24415_24428[(2)] = null);

(statearr_24415_24428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24413 === (2))){
var inst_24397 = (state_24412[(11)]);
var inst_24390 = (state_24412[(10)]);
var inst_24396 = cljs.core.seq(inst_24390);
var inst_24397__$1 = cljs.core.first(inst_24396);
var inst_24398 = cljs.core.next(inst_24396);
var state_24412__$1 = (function (){var statearr_24416 = state_24412;
(statearr_24416[(11)] = inst_24397__$1);

(statearr_24416[(12)] = inst_24398);

return statearr_24416;
})();
if(cljs.core.truth_(inst_24397__$1)){
var statearr_24417_24429 = state_24412__$1;
(statearr_24417_24429[(1)] = (4));

} else {
var statearr_24418_24430 = state_24412__$1;
(statearr_24418_24430[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24413 === (3))){
var inst_24410 = (state_24412[(2)]);
var state_24412__$1 = state_24412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24412__$1,inst_24410);
} else {
if((state_val_24413 === (4))){
var inst_24397 = (state_24412[(11)]);
var inst_24400 = (inst_24397.cljs$core$IFn$_invoke$arity$1 ? inst_24397.cljs$core$IFn$_invoke$arity$1(tuple) : inst_24397.call(null,tuple));
var state_24412__$1 = state_24412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24412__$1,(7),inst_24400);
} else {
if((state_val_24413 === (5))){
var inst_24391 = (state_24412[(9)]);
var state_24412__$1 = state_24412;
var statearr_24419_24431 = state_24412__$1;
(statearr_24419_24431[(2)] = inst_24391);

(statearr_24419_24431[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24413 === (6))){
var inst_24408 = (state_24412[(2)]);
var state_24412__$1 = state_24412;
var statearr_24420_24432 = state_24412__$1;
(statearr_24420_24432[(2)] = inst_24408);

(statearr_24420_24432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24413 === (7))){
var inst_24398 = (state_24412[(12)]);
var inst_24391 = (state_24412[(9)]);
var inst_24402 = (state_24412[(2)]);
var inst_24403 = fluree.db.util.async.throw_err(inst_24402);
var inst_24404 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24391,inst_24403);
var inst_24390 = inst_24398;
var inst_24391__$1 = inst_24404;
var state_24412__$1 = (function (){var statearr_24421 = state_24412;
(statearr_24421[(9)] = inst_24391__$1);

(statearr_24421[(10)] = inst_24390);

return statearr_24421;
})();
var statearr_24422_24433 = state_24412__$1;
(statearr_24422_24433[(2)] = null);

(statearr_24422_24433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____0 = (function (){
var statearr_24423 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24423[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__);

(statearr_24423[(1)] = (1));

return statearr_24423;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____1 = (function (state_24412){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24412);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24424){var ex__2736__auto__ = e24424;
var statearr_24425_24434 = state_24412;
(statearr_24425_24434[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24412[(4)]))){
var statearr_24426_24435 = state_24412;
(statearr_24426_24435[(1)] = cljs.core.first((state_24412[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24436 = state_24412;
state_24412 = G__24436;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__ = function(state_24412){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____1.call(this,state_24412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24427 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24427[(6)] = c__2755__auto__);

return statearr_24427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24437){
var vec__24438 = p__24437;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24438,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24438,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24452){
var state_val_24453 = (state_24452[(1)]);
if((state_val_24453 === (1))){
var inst_24441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24442 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24443 = [query_map,_id,query_opts];
var inst_24444 = cljs.core.PersistentHashMap.fromArrays(inst_24442,inst_24443);
var inst_24445 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24444) : fluree.db.query.fql.query.call(null,db,inst_24444));
var state_24452__$1 = (function (){var statearr_24454 = state_24452;
(statearr_24454[(7)] = inst_24441);

return statearr_24454;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24452__$1,(2),inst_24445);
} else {
if((state_val_24453 === (2))){
var inst_24441 = (state_24452[(7)]);
var inst_24447 = (state_24452[(2)]);
var inst_24448 = fluree.db.util.async.throw_err(inst_24447);
var inst_24449 = [tuple_index,inst_24448];
var inst_24450 = (new cljs.core.PersistentVector(null,2,(5),inst_24441,inst_24449,null));
var state_24452__$1 = state_24452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24452__$1,inst_24450);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2733__auto____0 = (function (){
var statearr_24455 = [null,null,null,null,null,null,null,null];
(statearr_24455[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2733__auto__);

(statearr_24455[(1)] = (1));

return statearr_24455;
});
var fluree$db$query$fql$expand_map_$_state_machine__2733__auto____1 = (function (state_24452){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24452);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24456){var ex__2736__auto__ = e24456;
var statearr_24457_24460 = state_24452;
(statearr_24457_24460[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24452[(4)]))){
var statearr_24458_24461 = state_24452;
(statearr_24458_24461[(1)] = cljs.core.first((state_24452[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24462 = state_24452;
state_24452 = G__24462;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2733__auto__ = function(state_24452){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2733__auto____1.call(this,state_24452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2733__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2733__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24459 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24459[(6)] = c__2755__auto__);

return statearr_24459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24463 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24463,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24463,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24526){
var state_val_24527 = (state_24526[(1)]);
if((state_val_24527 === (7))){
var inst_24521 = (state_24526[(2)]);
var _ = (function (){var statearr_24528 = state_24526;
(statearr_24528[(4)] = cljs.core.rest((state_24526[(4)])));

return statearr_24528;
})();
var state_24526__$1 = state_24526;
var statearr_24529_24620 = state_24526__$1;
(statearr_24529_24620[(2)] = inst_24521);

(statearr_24529_24620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (20))){
var inst_24512 = (state_24526[(2)]);
var state_24526__$1 = state_24526;
var statearr_24530_24621 = state_24526__$1;
(statearr_24530_24621[(2)] = inst_24512);

(statearr_24530_24621[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (1))){
var state_24526__$1 = state_24526;
var statearr_24531_24622 = state_24526__$1;
(statearr_24531_24622[(2)] = null);

(statearr_24531_24622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (4))){
var inst_24468 = (state_24526[(2)]);
var state_24526__$1 = state_24526;
var statearr_24532_24623 = state_24526__$1;
(statearr_24532_24623[(2)] = inst_24468);

(statearr_24532_24623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (15))){
var inst_24488 = (state_24526[(7)]);
var inst_24497 = cljs.core.second(inst_24488);
var inst_24498 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24497);
var inst_24499 = (inst_24498 > max_fuel);
var state_24526__$1 = state_24526;
if(cljs.core.truth_(inst_24499)){
var statearr_24533_24624 = state_24526__$1;
(statearr_24533_24624[(1)] = (18));

} else {
var statearr_24534_24625 = state_24526__$1;
(statearr_24534_24625[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (13))){
var state_24526__$1 = state_24526;
var statearr_24535_24626 = state_24526__$1;
(statearr_24535_24626[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (6))){
var inst_24476 = (state_24526[(8)]);
var state_24526__$1 = state_24526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24526__$1,(8),inst_24476);
} else {
if((state_val_24527 === (17))){
var inst_24515 = (state_24526[(2)]);
var state_24526__$1 = state_24526;
var statearr_24537_24627 = state_24526__$1;
(statearr_24537_24627[(2)] = inst_24515);

(statearr_24537_24627[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (3))){
var inst_24524 = (state_24526[(2)]);
var state_24526__$1 = state_24526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24526__$1,inst_24524);
} else {
if((state_val_24527 === (12))){
var inst_24477 = (state_24526[(9)]);
var inst_24488 = (state_24526[(7)]);
var inst_24494 = (inst_24477.cljs$core$IFn$_invoke$arity$0 ? inst_24477.cljs$core$IFn$_invoke$arity$0() : inst_24477.call(null));
var state_24526__$1 = (function (){var statearr_24538 = state_24526;
(statearr_24538[(10)] = inst_24494);

return statearr_24538;
})();
var statearr_24539_24628 = state_24526__$1;
(statearr_24539_24628[(2)] = inst_24488);

(statearr_24539_24628[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (2))){
var inst_24477 = (state_24526[(9)]);
var inst_24476 = (state_24526[(8)]);
var _ = (function (){var statearr_24540 = state_24526;
(statearr_24540[(4)] = cljs.core.cons((5),(state_24526[(4)])));

return statearr_24540;
})();
var inst_24474 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24475 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24476__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24477__$1 = (function (){var expandMaps = inst_24474;
var queue_ch = inst_24475;
var res_ch = inst_24476__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24478 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24479 = cljs.core.volatile_BANG_((0));
var inst_24480 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24478,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24479);
var inst_24481 = (function (){var expandMaps = inst_24474;
var queue_ch = inst_24475;
var res_ch = inst_24476__$1;
var stop_BANG_ = inst_24477__$1;
var opts_STAR_ = inst_24480;
return (function (tuple_res,port){
var c__2755__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24573){
var state_val_24574 = (state_24573[(1)]);
if((state_val_24574 === (7))){
var state_24573__$1 = state_24573;
var statearr_24575_24629 = state_24573__$1;
(statearr_24575_24629[(2)] = tuple_res);

(statearr_24575_24629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24574 === (1))){
var state_24573__$1 = state_24573;
var statearr_24576_24630 = state_24573__$1;
(statearr_24576_24630[(2)] = null);

(statearr_24576_24630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24574 === (4))){
var inst_24541 = (state_24573[(2)]);
var inst_24542 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24541);
var inst_24543 = cljs.core.async.close_BANG_(port);
var state_24573__$1 = (function (){var statearr_24577 = state_24573;
(statearr_24577[(7)] = inst_24542);

return statearr_24577;
})();
var statearr_24578_24631 = state_24573__$1;
(statearr_24578_24631[(2)] = inst_24543);

(statearr_24578_24631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24574 === (6))){
var inst_24550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24551 = [tuple_res];
var inst_24552 = (new cljs.core.PersistentVector(null,1,(5),inst_24550,inst_24551,null));
var state_24573__$1 = state_24573;
var statearr_24579_24632 = state_24573__$1;
(statearr_24579_24632[(2)] = inst_24552);

(statearr_24579_24632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24574 === (3))){
var inst_24571 = (state_24573[(2)]);
var state_24573__$1 = state_24573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24573__$1,inst_24571);
} else {
if((state_val_24574 === (2))){
var ___$1 = (function (){var statearr_24581 = state_24573;
(statearr_24581[(4)] = cljs.core.cons((5),(state_24573[(4)])));

return statearr_24581;
})();
var state_24573__$1 = state_24573;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24582_24633 = state_24573__$1;
(statearr_24582_24633[(1)] = (6));

} else {
var statearr_24583_24634 = state_24573__$1;
(statearr_24583_24634[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24574 === (9))){
var inst_24557 = (state_24573[(8)]);
var inst_24555 = (state_24573[(9)]);
var inst_24564 = (state_24573[(2)]);
var inst_24565 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24555,inst_24564);
var inst_24566 = (inst_24557.cljs$core$IFn$_invoke$arity$1 ? inst_24557.cljs$core$IFn$_invoke$arity$1(inst_24565) : inst_24557.call(null,inst_24565));
var inst_24567 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24566);
var inst_24568 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24584 = state_24573;
(statearr_24584[(4)] = cljs.core.rest((state_24573[(4)])));

return statearr_24584;
})();
var state_24573__$1 = (function (){var statearr_24585 = state_24573;
(statearr_24585[(10)] = inst_24567);

return statearr_24585;
})();
var statearr_24586_24635 = state_24573__$1;
(statearr_24586_24635[(2)] = inst_24568);

(statearr_24586_24635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24574 === (5))){
var ___$1 = (function (){var statearr_24587 = state_24573;
(statearr_24587[(4)] = cljs.core.rest((state_24573[(4)])));

return statearr_24587;
})();
var state_24573__$1 = state_24573;
var ex24580 = (state_24573__$1[(2)]);
var statearr_24588_24636 = state_24573__$1;
(statearr_24588_24636[(5)] = ex24580);


var statearr_24589_24637 = state_24573__$1;
(statearr_24589_24637[(1)] = (4));

(statearr_24589_24637[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24574 === (8))){
var inst_24555 = (state_24573[(9)]);
var inst_24555__$1 = (state_24573[(2)]);
var inst_24556 = cljs.core.volatile_BANG_((0));
var inst_24557 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24555__$1;
var query_fuel = inst_24556;
return (function (p1__24467_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24467_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24467_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24558 = cljs.core.PersistentVector.EMPTY;
var inst_24559 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24555__$1;
var query_fuel = inst_24556;
return (function (p1__24466_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24466_SHARP_);
});
})();
var inst_24560 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24559,expandMaps);
var inst_24561 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24560);
var inst_24562 = cljs.core.async.into(inst_24558,inst_24561);
var state_24573__$1 = (function (){var statearr_24590 = state_24573;
(statearr_24590[(8)] = inst_24557);

(statearr_24590[(9)] = inst_24555__$1);

return statearr_24590;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24573__$1,(9),inst_24562);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0 = (function (){
var statearr_24591 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24591[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__);

(statearr_24591[(1)] = (1));

return statearr_24591;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1 = (function (state_24573){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24573);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24592){var ex__2736__auto__ = e24592;
var statearr_24593_24638 = state_24573;
(statearr_24593_24638[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24573[(4)]))){
var statearr_24594_24639 = state_24573;
(statearr_24594_24639[(1)] = cljs.core.first((state_24573[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24640 = state_24573;
state_24573 = G__24640;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = function(state_24573){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1.call(this,state_24573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24595 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24595[(6)] = c__2755__auto____$1);

return statearr_24595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto____$1;
});
})();
var inst_24482 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24475,tuples_res);
var inst_24483 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24476__$1,inst_24481,inst_24475);
var inst_24484 = cljs.core.PersistentVector.EMPTY;
var inst_24485 = inst_24484;
var state_24526__$1 = (function (){var statearr_24596 = state_24526;
(statearr_24596[(11)] = inst_24483);

(statearr_24596[(12)] = inst_24482);

(statearr_24596[(9)] = inst_24477__$1);

(statearr_24596[(8)] = inst_24476__$1);

(statearr_24596[(13)] = inst_24485);

return statearr_24596;
})();
var statearr_24597_24641 = state_24526__$1;
(statearr_24597_24641[(2)] = null);

(statearr_24597_24641[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (19))){
var inst_24485 = (state_24526[(13)]);
var inst_24488 = (state_24526[(7)]);
var inst_24508 = cljs.core.first(inst_24488);
var inst_24509 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24485,inst_24508);
var inst_24485__$1 = inst_24509;
var state_24526__$1 = (function (){var statearr_24598 = state_24526;
(statearr_24598[(13)] = inst_24485__$1);

return statearr_24598;
})();
var statearr_24599_24642 = state_24526__$1;
(statearr_24599_24642[(2)] = null);

(statearr_24599_24642[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (11))){
var inst_24519 = (state_24526[(2)]);
var state_24526__$1 = state_24526;
var statearr_24601_24643 = state_24526__$1;
(statearr_24601_24643[(2)] = inst_24519);

(statearr_24601_24643[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (9))){
var inst_24485 = (state_24526[(13)]);
var state_24526__$1 = state_24526;
var statearr_24602_24644 = state_24526__$1;
(statearr_24602_24644[(2)] = inst_24485);

(statearr_24602_24644[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (5))){
var _ = (function (){var statearr_24603 = state_24526;
(statearr_24603[(4)] = cljs.core.rest((state_24526[(4)])));

return statearr_24603;
})();
var state_24526__$1 = state_24526;
var ex24600 = (state_24526__$1[(2)]);
var statearr_24604_24645 = state_24526__$1;
(statearr_24604_24645[(5)] = ex24600);


if((ex24600 instanceof Error)){
var statearr_24605_24646 = state_24526__$1;
(statearr_24605_24646[(1)] = (4));

(statearr_24605_24646[(5)] = null);

} else {
throw ex24600;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (14))){
var inst_24517 = (state_24526[(2)]);
var state_24526__$1 = state_24526;
var statearr_24606_24647 = state_24526__$1;
(statearr_24606_24647[(2)] = inst_24517);

(statearr_24606_24647[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (16))){
var state_24526__$1 = state_24526;
var statearr_24607_24648 = state_24526__$1;
(statearr_24607_24648[(2)] = null);

(statearr_24607_24648[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (10))){
var inst_24488 = (state_24526[(7)]);
var inst_24492 = fluree.db.util.core.exception_QMARK_(inst_24488);
var state_24526__$1 = state_24526;
if(inst_24492){
var statearr_24608_24649 = state_24526__$1;
(statearr_24608_24649[(1)] = (12));

} else {
var statearr_24609_24650 = state_24526__$1;
(statearr_24609_24650[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (18))){
var inst_24477 = (state_24526[(9)]);
var inst_24501 = (inst_24477.cljs$core$IFn$_invoke$arity$0 ? inst_24477.cljs$core$IFn$_invoke$arity$0() : inst_24477.call(null));
var inst_24502 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24503 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24504 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24505 = cljs.core.PersistentHashMap.fromArrays(inst_24503,inst_24504);
var inst_24506 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24502,inst_24505);
var state_24526__$1 = (function (){var statearr_24610 = state_24526;
(statearr_24610[(14)] = inst_24501);

return statearr_24610;
})();
var statearr_24611_24651 = state_24526__$1;
(statearr_24611_24651[(2)] = inst_24506);

(statearr_24611_24651[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24527 === (8))){
var inst_24488 = (state_24526[(7)]);
var inst_24488__$1 = (state_24526[(2)]);
var inst_24489 = (inst_24488__$1 == null);
var state_24526__$1 = (function (){var statearr_24612 = state_24526;
(statearr_24612[(7)] = inst_24488__$1);

return statearr_24612;
})();
if(cljs.core.truth_(inst_24489)){
var statearr_24613_24652 = state_24526__$1;
(statearr_24613_24652[(1)] = (9));

} else {
var statearr_24614_24653 = state_24526__$1;
(statearr_24614_24653[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0 = (function (){
var statearr_24615 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24615[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__);

(statearr_24615[(1)] = (1));

return statearr_24615;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1 = (function (state_24526){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24526);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24616){var ex__2736__auto__ = e24616;
var statearr_24617_24654 = state_24526;
(statearr_24617_24654[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24526[(4)]))){
var statearr_24618_24655 = state_24526;
(statearr_24618_24655[(1)] = cljs.core.first((state_24526[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24656 = state_24526;
state_24526 = G__24656;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = function(state_24526){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1.call(this,state_24526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24619 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24619[(6)] = c__2755__auto__);

return statearr_24619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24657 = select;
var map__24657__$1 = cljs.core.__destructure_map(map__24657);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24657__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24657__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24657__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24660 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24660,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24660,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24660,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24658_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24658_SHARP_,compare_idx));
}):(function (p1__24659_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24659_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24665 = arguments.length;
switch (G__24665) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24666,p__24667,group_limit,opts){
var map__24668 = p__24666;
var map__24668__$1 = cljs.core.__destructure_map(map__24668);
var res = map__24668__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24668__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24669 = p__24667;
var map__24669__$1 = cljs.core.__destructure_map(map__24669);
var select_spec = map__24669__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24669__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24806){
var state_val_24807 = (state_24806[(1)]);
if((state_val_24807 === (7))){
var inst_24676 = (state_24806[(7)]);
var state_24806__$1 = state_24806;
var statearr_24808_24910 = state_24806__$1;
(statearr_24808_24910[(2)] = inst_24676);

(statearr_24808_24910[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (59))){
var inst_24799 = (state_24806[(2)]);
var state_24806__$1 = state_24806;
var statearr_24809_24911 = state_24806__$1;
(statearr_24809_24911[(2)] = inst_24799);

(statearr_24809_24911[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (20))){
var inst_24715 = (state_24806[(8)]);
var inst_24712 = (state_24806[(9)]);
var inst_24711 = (state_24806[(2)]);
var inst_24712__$1 = cljs.core.__destructure_map(inst_24711);
var inst_24713 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24712__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24714 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24712__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24715__$1 = offset;
var state_24806__$1 = (function (){var statearr_24810 = state_24806;
(statearr_24810[(10)] = inst_24713);

(statearr_24810[(8)] = inst_24715__$1);

(statearr_24810[(9)] = inst_24712__$1);

(statearr_24810[(11)] = inst_24714);

return statearr_24810;
})();
if(cljs.core.truth_(inst_24715__$1)){
var statearr_24811_24912 = state_24806__$1;
(statearr_24811_24912[(1)] = (21));

} else {
var statearr_24812_24913 = state_24806__$1;
(statearr_24812_24913[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (58))){
var inst_24791 = (state_24806[(12)]);
var state_24806__$1 = state_24806;
var statearr_24813_24914 = state_24806__$1;
(statearr_24813_24914[(2)] = inst_24791);

(statearr_24813_24914[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (60))){
var inst_24795 = (state_24806[(2)]);
var inst_24796 = fluree.db.util.async.throw_err(inst_24795);
var state_24806__$1 = state_24806;
var statearr_24814_24915 = state_24806__$1;
(statearr_24814_24915[(2)] = inst_24796);

(statearr_24814_24915[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (27))){
var inst_24727 = cljs.core.not(inVector_QMARK_);
var state_24806__$1 = state_24806;
var statearr_24815_24916 = state_24806__$1;
(statearr_24815_24916[(2)] = inst_24727);

(statearr_24815_24916[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (1))){
var state_24806__$1 = state_24806;
var statearr_24816_24917 = state_24806__$1;
(statearr_24816_24917[(2)] = null);

(statearr_24816_24917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (24))){
var state_24806__$1 = state_24806;
var statearr_24817_24918 = state_24806__$1;
(statearr_24817_24918[(2)] = offset);

(statearr_24817_24918[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (55))){
var inst_24785 = (state_24806[(13)]);
var state_24806__$1 = state_24806;
var statearr_24818_24919 = state_24806__$1;
(statearr_24818_24919[(2)] = inst_24785);

(statearr_24818_24919[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (39))){
var inst_24753 = (state_24806[(14)]);
var inst_24755 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_24756 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24753,inst_24755);
var state_24806__$1 = state_24806;
var statearr_24819_24920 = state_24806__$1;
(statearr_24819_24920[(2)] = inst_24756);

(statearr_24819_24920[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (46))){
var inst_24765 = (state_24806[(15)]);
var state_24806__$1 = state_24806;
var statearr_24820_24921 = state_24806__$1;
(statearr_24820_24921[(2)] = inst_24765);

(statearr_24820_24921[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (4))){
var inst_24670 = (state_24806[(2)]);
var state_24806__$1 = state_24806;
var statearr_24821_24922 = state_24806__$1;
(statearr_24821_24922[(2)] = inst_24670);

(statearr_24821_24922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (54))){
var inst_24785 = (state_24806[(13)]);
var inst_24779 = (state_24806[(16)]);
var inst_24787 = cljs.core.PersistentVector.EMPTY;
var inst_24788 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_24787,inst_24779,inst_24785);
var state_24806__$1 = state_24806;
var statearr_24822_24923 = state_24806__$1;
(statearr_24822_24923[(2)] = inst_24788);

(statearr_24822_24923[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (15))){
var inst_24697 = (state_24806[(17)]);
var inst_24699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24700 = [inst_24697];
var inst_24701 = (new cljs.core.PersistentVector(null,1,(5),inst_24699,inst_24700,null));
var state_24806__$1 = state_24806;
var statearr_24823_24924 = state_24806__$1;
(statearr_24823_24924[(2)] = inst_24701);

(statearr_24823_24924[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (48))){
var inst_24724 = (state_24806[(18)]);
var inst_24713 = (state_24806[(10)]);
var inst_24735 = (state_24806[(19)]);
var inst_24771 = (state_24806[(20)]);
var inst_24712 = (state_24806[(9)]);
var inst_24730 = (state_24806[(21)]);
var inst_24714 = (state_24806[(11)]);
var inst_24773 = (function (){var map__24706 = inst_24712;
var headers = inst_24713;
var tuples = inst_24714;
var offset_SINGLEQUOTE_ = inst_24724;
var single_result_QMARK_ = inst_24730;
var pp_keys = inst_24735;
var G__24736 = inst_24771;
return (function (p1__24663_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24663_SHARP_);
});
})();
var inst_24774 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24773);
var inst_24775 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24771,inst_24774);
var state_24806__$1 = state_24806;
var statearr_24824_24925 = state_24806__$1;
(statearr_24824_24925[(2)] = inst_24775);

(statearr_24824_24925[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (50))){
var inst_24778 = (state_24806[(2)]);
var inst_24779 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_24778);
var state_24806__$1 = (function (){var statearr_24825 = state_24806;
(statearr_24825[(16)] = inst_24779);

return statearr_24825;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24826_24926 = state_24806__$1;
(statearr_24826_24926[(1)] = (51));

} else {
var statearr_24827_24927 = state_24806__$1;
(statearr_24827_24927[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (21))){
var inst_24717 = cljs.core.not(groupBy);
var state_24806__$1 = state_24806;
var statearr_24828_24928 = state_24806__$1;
(statearr_24828_24928[(2)] = inst_24717);

(statearr_24828_24928[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (31))){
var state_24806__$1 = state_24806;
var statearr_24829_24929 = state_24806__$1;
(statearr_24829_24929[(2)] = null);

(statearr_24829_24929[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (32))){
var inst_24713 = (state_24806[(10)]);
var inst_24730 = (state_24806[(21)]);
var inst_24735 = (state_24806[(2)]);
var inst_24737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24738 = fluree.db.query.fql.select_tuples_fn(inst_24713,vars,select);
var inst_24739 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24738);
var inst_24740 = [inst_24739];
var inst_24741 = (new cljs.core.PersistentVector(null,1,(5),inst_24737,inst_24740,null));
var state_24806__$1 = (function (){var statearr_24830 = state_24806;
(statearr_24830[(22)] = inst_24741);

(statearr_24830[(19)] = inst_24735);

return statearr_24830;
})();
if(cljs.core.truth_(inst_24730)){
var statearr_24831_24930 = state_24806__$1;
(statearr_24831_24930[(1)] = (33));

} else {
var statearr_24832_24931 = state_24806__$1;
(statearr_24832_24931[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (40))){
var inst_24753 = (state_24806[(14)]);
var state_24806__$1 = state_24806;
var statearr_24833_24932 = state_24806__$1;
(statearr_24833_24932[(2)] = inst_24753);

(statearr_24833_24932[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (56))){
var inst_24791 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24834 = state_24806;
(statearr_24834[(12)] = inst_24791);

return statearr_24834;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24835_24933 = state_24806__$1;
(statearr_24835_24933[(1)] = (57));

} else {
var statearr_24836_24934 = state_24806__$1;
(statearr_24836_24934[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (33))){
var inst_24741 = (state_24806[(22)]);
var inst_24743 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_24744 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24741,inst_24743);
var state_24806__$1 = state_24806;
var statearr_24837_24935 = state_24806__$1;
(statearr_24837_24935[(2)] = inst_24744);

(statearr_24837_24935[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (13))){
var inst_24686 = (state_24806[(23)]);
var state_24806__$1 = state_24806;
var statearr_24838_24936 = state_24806__$1;
(statearr_24838_24936[(2)] = inst_24686);

(statearr_24838_24936[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (22))){
var inst_24715 = (state_24806[(8)]);
var state_24806__$1 = state_24806;
var statearr_24839_24937 = state_24806__$1;
(statearr_24839_24937[(2)] = inst_24715);

(statearr_24839_24937[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (36))){
var inst_24747 = (state_24806[(24)]);
var inst_24749 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_24750 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24747,inst_24749);
var state_24806__$1 = state_24806;
var statearr_24840_24938 = state_24806__$1;
(statearr_24840_24938[(2)] = inst_24750);

(statearr_24840_24938[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (41))){
var inst_24724 = (state_24806[(18)]);
var inst_24759 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24841 = state_24806;
(statearr_24841[(25)] = inst_24759);

return statearr_24841;
})();
if(cljs.core.truth_(inst_24724)){
var statearr_24842_24939 = state_24806__$1;
(statearr_24842_24939[(1)] = (42));

} else {
var statearr_24843_24940 = state_24806__$1;
(statearr_24843_24940[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (43))){
var inst_24759 = (state_24806[(25)]);
var state_24806__$1 = state_24806;
var statearr_24844_24941 = state_24806__$1;
(statearr_24844_24941[(2)] = inst_24759);

(statearr_24844_24941[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (29))){
var inst_24730 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24845 = state_24806;
(statearr_24845[(21)] = inst_24730);

return statearr_24845;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24846_24942 = state_24806__$1;
(statearr_24846_24942[(1)] = (30));

} else {
var statearr_24847_24943 = state_24806__$1;
(statearr_24847_24943[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (44))){
var inst_24765 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24848 = state_24806;
(statearr_24848[(15)] = inst_24765);

return statearr_24848;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24849_24944 = state_24806__$1;
(statearr_24849_24944[(1)] = (45));

} else {
var statearr_24850_24945 = state_24806__$1;
(statearr_24850_24945[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (6))){
var inst_24678 = cljs.core.count(select);
var inst_24679 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24678);
var state_24806__$1 = state_24806;
var statearr_24851_24946 = state_24806__$1;
(statearr_24851_24946[(2)] = inst_24679);

(statearr_24851_24946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (28))){
var inst_24725 = (state_24806[(26)]);
var state_24806__$1 = state_24806;
var statearr_24852_24947 = state_24806__$1;
(statearr_24852_24947[(2)] = inst_24725);

(statearr_24852_24947[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (51))){
var inst_24713 = (state_24806[(10)]);
var inst_24714 = (state_24806[(11)]);
var inst_24782 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_24713,orderBy,inst_24714);
var state_24806__$1 = state_24806;
var statearr_24853_24948 = state_24806__$1;
(statearr_24853_24948[(2)] = inst_24782);

(statearr_24853_24948[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (25))){
var state_24806__$1 = state_24806;
var statearr_24854_24949 = state_24806__$1;
(statearr_24854_24949[(2)] = null);

(statearr_24854_24949[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (34))){
var inst_24741 = (state_24806[(22)]);
var state_24806__$1 = state_24806;
var statearr_24855_24950 = state_24806__$1;
(statearr_24855_24950[(2)] = inst_24741);

(statearr_24855_24950[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (17))){
var inst_24704 = (state_24806[(2)]);
var state_24806__$1 = state_24806;
var statearr_24856_24951 = state_24806__$1;
(statearr_24856_24951[(2)] = inst_24704);

(statearr_24856_24951[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (3))){
var inst_24804 = (state_24806[(2)]);
var state_24806__$1 = state_24806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24806__$1,inst_24804);
} else {
if((state_val_24807 === (12))){
var inst_24686 = (state_24806[(23)]);
var inst_24688 = cljs.core.first(select);
var inst_24689 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24688);
var inst_24690 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24689);
var inst_24691 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24690,(1));
var inst_24692 = [inst_24691];
var inst_24693 = [inst_24686];
var inst_24694 = cljs.core.PersistentHashMap.fromArrays(inst_24692,inst_24693);
var state_24806__$1 = state_24806;
var statearr_24857_24952 = state_24806__$1;
(statearr_24857_24952[(2)] = inst_24694);

(statearr_24857_24952[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (2))){
var inst_24676 = (state_24806[(7)]);
var _ = (function (){var statearr_24858 = state_24806;
(statearr_24858[(4)] = cljs.core.cons((5),(state_24806[(4)])));

return statearr_24858;
})();
var inst_24676__$1 = aggregates;
var state_24806__$1 = (function (){var statearr_24859 = state_24806;
(statearr_24859[(7)] = inst_24676__$1);

return statearr_24859;
})();
if(cljs.core.truth_(inst_24676__$1)){
var statearr_24860_24953 = state_24806__$1;
(statearr_24860_24953[(1)] = (6));

} else {
var statearr_24861_24954 = state_24806__$1;
(statearr_24861_24954[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (23))){
var inst_24720 = (state_24806[(2)]);
var state_24806__$1 = state_24806;
if(cljs.core.truth_(inst_24720)){
var statearr_24862_24955 = state_24806__$1;
(statearr_24862_24955[(1)] = (24));

} else {
var statearr_24863_24956 = state_24806__$1;
(statearr_24863_24956[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (47))){
var inst_24771 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24864 = state_24806;
(statearr_24864[(20)] = inst_24771);

return statearr_24864;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24865_24957 = state_24806__$1;
(statearr_24865_24957[(1)] = (48));

} else {
var statearr_24866_24958 = state_24806__$1;
(statearr_24866_24958[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (35))){
var inst_24747 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24867 = state_24806;
(statearr_24867[(24)] = inst_24747);

return statearr_24867;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24868_24959 = state_24806__$1;
(statearr_24868_24959[(1)] = (36));

} else {
var statearr_24869_24960 = state_24806__$1;
(statearr_24869_24960[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (19))){
var state_24806__$1 = state_24806;
var statearr_24870_24961 = state_24806__$1;
(statearr_24870_24961[(2)] = res);

(statearr_24870_24961[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (57))){
var inst_24735 = (state_24806[(19)]);
var inst_24791 = (state_24806[(12)]);
var inst_24730 = (state_24806[(21)]);
var inst_24793 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_24735,inst_24730,db,fuel,max_fuel,opts,(8),inst_24791);
var state_24806__$1 = state_24806;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24806__$1,(60),inst_24793);
} else {
if((state_val_24807 === (11))){
var inst_24801 = (state_24806[(2)]);
var _ = (function (){var statearr_24872 = state_24806;
(statearr_24872[(4)] = cljs.core.rest((state_24806[(4)])));

return statearr_24872;
})();
var state_24806__$1 = state_24806;
var statearr_24873_24962 = state_24806__$1;
(statearr_24873_24962[(2)] = inst_24801);

(statearr_24873_24962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (9))){
var inst_24684 = cljs.core.first(aggregates);
var inst_24685 = fluree.db.query.analytical.calculate_aggregate(res,inst_24684);
var inst_24686 = cljs.core.second(inst_24685);
var state_24806__$1 = (function (){var statearr_24874 = state_24806;
(statearr_24874[(23)] = inst_24686);

return statearr_24874;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24875_24963 = state_24806__$1;
(statearr_24875_24963[(1)] = (12));

} else {
var statearr_24876_24964 = state_24806__$1;
(statearr_24876_24964[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (5))){
var _ = (function (){var statearr_24877 = state_24806;
(statearr_24877[(4)] = cljs.core.rest((state_24806[(4)])));

return statearr_24877;
})();
var state_24806__$1 = state_24806;
var ex24871 = (state_24806__$1[(2)]);
var statearr_24878_24965 = state_24806__$1;
(statearr_24878_24965[(5)] = ex24871);


if((ex24871 instanceof Error)){
var statearr_24879_24966 = state_24806__$1;
(statearr_24879_24966[(1)] = (4));

(statearr_24879_24966[(5)] = null);

} else {
throw ex24871;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (14))){
var inst_24697 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24880 = state_24806;
(statearr_24880[(17)] = inst_24697);

return statearr_24880;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24881_24967 = state_24806__$1;
(statearr_24881_24967[(1)] = (15));

} else {
var statearr_24882_24968 = state_24806__$1;
(statearr_24882_24968[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (45))){
var inst_24765 = (state_24806[(15)]);
var inst_24767 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_24768 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24765,inst_24767);
var state_24806__$1 = state_24806;
var statearr_24883_24969 = state_24806__$1;
(statearr_24883_24969[(2)] = inst_24768);

(statearr_24883_24969[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (53))){
var inst_24785 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24884 = state_24806;
(statearr_24884[(13)] = inst_24785);

return statearr_24884;
})();
var statearr_24885_24970 = state_24806__$1;
(statearr_24885_24970[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (26))){
var inst_24725 = (state_24806[(26)]);
var inst_24724 = (state_24806[(2)]);
var inst_24725__$1 = cljs.core.not(prettyPrint);
var state_24806__$1 = (function (){var statearr_24887 = state_24806;
(statearr_24887[(18)] = inst_24724);

(statearr_24887[(26)] = inst_24725__$1);

return statearr_24887;
})();
if(inst_24725__$1){
var statearr_24888_24971 = state_24806__$1;
(statearr_24888_24971[(1)] = (27));

} else {
var statearr_24889_24972 = state_24806__$1;
(statearr_24889_24972[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (16))){
var inst_24697 = (state_24806[(17)]);
var state_24806__$1 = state_24806;
var statearr_24890_24973 = state_24806__$1;
(statearr_24890_24973[(2)] = inst_24697);

(statearr_24890_24973[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (38))){
var inst_24753 = (state_24806[(2)]);
var state_24806__$1 = (function (){var statearr_24891 = state_24806;
(statearr_24891[(14)] = inst_24753);

return statearr_24891;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24892_24974 = state_24806__$1;
(statearr_24892_24974[(1)] = (39));

} else {
var statearr_24893_24975 = state_24806__$1;
(statearr_24893_24975[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (30))){
var inst_24732 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_24806__$1 = state_24806;
var statearr_24894_24976 = state_24806__$1;
(statearr_24894_24976[(2)] = inst_24732);

(statearr_24894_24976[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (10))){
var state_24806__$1 = state_24806;
if(cljs.core.truth_(aggregates)){
var statearr_24895_24977 = state_24806__$1;
(statearr_24895_24977[(1)] = (18));

} else {
var statearr_24896_24978 = state_24806__$1;
(statearr_24896_24978[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (18))){
var inst_24708 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_24806__$1 = state_24806;
var statearr_24897_24979 = state_24806__$1;
(statearr_24897_24979[(2)] = inst_24708);

(statearr_24897_24979[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (52))){
var inst_24714 = (state_24806[(11)]);
var state_24806__$1 = state_24806;
var statearr_24898_24980 = state_24806__$1;
(statearr_24898_24980[(2)] = inst_24714);

(statearr_24898_24980[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (42))){
var inst_24724 = (state_24806[(18)]);
var inst_24759 = (state_24806[(25)]);
var inst_24761 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_24724);
var inst_24762 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24759,inst_24761);
var state_24806__$1 = state_24806;
var statearr_24899_24981 = state_24806__$1;
(statearr_24899_24981[(2)] = inst_24762);

(statearr_24899_24981[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (37))){
var inst_24747 = (state_24806[(24)]);
var state_24806__$1 = state_24806;
var statearr_24900_24982 = state_24806__$1;
(statearr_24900_24982[(2)] = inst_24747);

(statearr_24900_24982[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (8))){
var inst_24682 = (state_24806[(2)]);
var state_24806__$1 = state_24806;
if(cljs.core.truth_(inst_24682)){
var statearr_24901_24983 = state_24806__$1;
(statearr_24901_24983[(1)] = (9));

} else {
var statearr_24902_24984 = state_24806__$1;
(statearr_24902_24984[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24807 === (49))){
var inst_24771 = (state_24806[(20)]);
var state_24806__$1 = state_24806;
var statearr_24903_24985 = state_24806__$1;
(statearr_24903_24985[(2)] = inst_24771);

(statearr_24903_24985[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_24904 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24904[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_24904[(1)] = (1));

return statearr_24904;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_24806){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24806);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24905){var ex__2736__auto__ = e24905;
var statearr_24906_24986 = state_24806;
(statearr_24906_24986[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24806[(4)]))){
var statearr_24907_24987 = state_24806;
(statearr_24907_24987[(1)] = cljs.core.first((state_24806[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24988 = state_24806;
state_24806 = G__24988;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_24806){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_24806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24908 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24908[(6)] = c__2755__auto__);

return statearr_24908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24991,groupBy){
var map__24992 = p__24991;
var map__24992__$1 = cljs.core.__destructure_map(map__24992);
var res = map__24992__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24992__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24992__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24993 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24993,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24993,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24989_SHARP_){
return fluree.db.util.core.index_of(headers,p1__24989_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24990_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__24990_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__24996 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24996,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24996,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__24999,p__25000,opts){
var map__25001 = p__24999;
var map__25001__$1 = cljs.core.__destructure_map(map__25001);
var res = map__25001__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25001__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25001__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25002 = p__25000;
var map__25002__$1 = cljs.core.__destructure_map(map__25002);
var select_spec = map__25002__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25002__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25002__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25002__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25002__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25002__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25002__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25002__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_25244){
var state_val_25245 = (state_25244[(1)]);
if((state_val_25245 === (65))){
var state_25244__$1 = state_25244;
var statearr_25246_25397 = state_25244__$1;
(statearr_25246_25397[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (70))){
var inst_25165 = (state_25244[(7)]);
var state_25244__$1 = state_25244;
var statearr_25248_25398 = state_25244__$1;
(statearr_25248_25398[(2)] = inst_25165);

(statearr_25248_25398[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (62))){
var state_25244__$1 = state_25244;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25249_25399 = state_25244__$1;
(statearr_25249_25399[(1)] = (64));

} else {
var statearr_25250_25400 = state_25244__$1;
(statearr_25250_25400[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (74))){
var inst_25081 = (state_25244[(8)]);
var inst_25140 = (state_25244[(9)]);
var inst_25072 = (state_25244[(10)]);
var inst_25173 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25072,inst_25081,inst_25140);
var state_25244__$1 = state_25244;
var statearr_25251_25401 = state_25244__$1;
(statearr_25251_25401[(2)] = inst_25173);

(statearr_25251_25401[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (7))){
var state_25244__$1 = state_25244;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25252_25402 = state_25244__$1;
(statearr_25252_25402[(1)] = (82));

} else {
var statearr_25253_25403 = state_25244__$1;
(statearr_25253_25403[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (59))){
var inst_25140 = (state_25244[(9)]);
var inst_25070 = (state_25244[(11)]);
var inst_25144 = cljs.core.count(inst_25140);
var inst_25145 = (inst_25070 - inst_25144);
var state_25244__$1 = state_25244;
var statearr_25254_25404 = state_25244__$1;
(statearr_25254_25404[(2)] = inst_25145);

(statearr_25254_25404[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (86))){
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25255_25405 = state_25244__$1;
(statearr_25255_25405[(1)] = (89));

} else {
var statearr_25256_25406 = state_25244__$1;
(statearr_25256_25406[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (20))){
var state_25244__$1 = state_25244;
var statearr_25257_25407 = state_25244__$1;
(statearr_25257_25407[(2)] = (0));

(statearr_25257_25407[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (72))){
var inst_25170 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25170)){
var statearr_25258_25408 = state_25244__$1;
(statearr_25258_25408[(1)] = (73));

} else {
var statearr_25259_25409 = state_25244__$1;
(statearr_25259_25409[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (58))){
var state_25244__$1 = state_25244;
var statearr_25260_25410 = state_25244__$1;
(statearr_25260_25410[(2)] = null);

(statearr_25260_25410[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (60))){
var inst_25071 = (state_25244[(12)]);
var inst_25147 = (state_25244[(2)]);
var inst_25148 = (inst_25071 <= (0));
var state_25244__$1 = (function (){var statearr_25261 = state_25244;
(statearr_25261[(13)] = inst_25147);

return statearr_25261;
})();
if(cljs.core.truth_(inst_25148)){
var statearr_25262_25411 = state_25244__$1;
(statearr_25262_25411[(1)] = (61));

} else {
var statearr_25263_25412 = state_25244__$1;
(statearr_25263_25412[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (27))){
var inst_25070 = (state_25244[(11)]);
var inst_25094 = (inst_25070 < (1));
var state_25244__$1 = state_25244;
var statearr_25264_25413 = state_25244__$1;
(statearr_25264_25413[(2)] = inst_25094);

(statearr_25264_25413[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (1))){
var state_25244__$1 = state_25244;
var statearr_25265_25414 = state_25244__$1;
(statearr_25265_25414[(2)] = null);

(statearr_25265_25414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (69))){
var inst_25160 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25266_25415 = state_25244__$1;
(statearr_25266_25415[(2)] = inst_25160);

(statearr_25266_25415[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (24))){
var inst_25072 = (state_25244[(10)]);
var state_25244__$1 = state_25244;
var statearr_25267_25416 = state_25244__$1;
(statearr_25267_25416[(2)] = inst_25072);

(statearr_25267_25416[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (55))){
var inst_25130 = (state_25244[(14)]);
var inst_25070 = (state_25244[(11)]);
var inst_25137 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25070,inst_25130);
var state_25244__$1 = state_25244;
var statearr_25268_25417 = state_25244__$1;
(statearr_25268_25417[(2)] = inst_25137);

(statearr_25268_25417[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (85))){
var inst_25215 = (state_25244[(15)]);
var inst_25214 = (state_25244[(2)]);
var inst_25215__$1 = fluree.db.util.async.throw_err(inst_25214);
var inst_25216 = cljs.core.coll_QMARK_(inst_25215__$1);
var inst_25217 = (!(inst_25216));
var state_25244__$1 = (function (){var statearr_25269 = state_25244;
(statearr_25269[(15)] = inst_25215__$1);

return statearr_25269;
})();
if(inst_25217){
var statearr_25270_25418 = state_25244__$1;
(statearr_25270_25418[(1)] = (86));

} else {
var statearr_25271_25419 = state_25244__$1;
(statearr_25271_25419[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (39))){
var inst_25089 = (state_25244[(16)]);
var inst_25111 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25112 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25113 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25089,inst_25111,inst_25112);
var state_25244__$1 = state_25244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25244__$1,(42),inst_25113);
} else {
if((state_val_25245 === (88))){
var inst_25237 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25272_25420 = state_25244__$1;
(statearr_25272_25420[(2)] = inst_25237);

(statearr_25272_25420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (46))){
var inst_25071 = (state_25244[(12)]);
var inst_25125 = ((0) < inst_25071);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25125)){
var statearr_25273_25421 = state_25244__$1;
(statearr_25273_25421[(1)] = (49));

} else {
var statearr_25274_25422 = state_25244__$1;
(statearr_25274_25422[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (4))){
var inst_25003 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25275_25423 = state_25244__$1;
(statearr_25275_25423[(2)] = inst_25003);

(statearr_25275_25423[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (77))){
var inst_25070 = (state_25244[(11)]);
var inst_25181 = (inst_25070 - (1));
var state_25244__$1 = state_25244;
var statearr_25276_25424 = state_25244__$1;
(statearr_25276_25424[(2)] = inst_25181);

(statearr_25276_25424[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (95))){
var inst_25215 = (state_25244[(15)]);
var state_25244__$1 = state_25244;
var statearr_25277_25425 = state_25244__$1;
(statearr_25277_25425[(2)] = inst_25215);

(statearr_25277_25425[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (54))){
var inst_25135 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25135)){
var statearr_25278_25426 = state_25244__$1;
(statearr_25278_25426[(1)] = (55));

} else {
var statearr_25279_25427 = state_25244__$1;
(statearr_25279_25427[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (92))){
var inst_25215 = (state_25244[(15)]);
var inst_25228 = cljs.core.first(inst_25215);
var state_25244__$1 = state_25244;
var statearr_25280_25428 = state_25244__$1;
(statearr_25280_25428[(2)] = inst_25228);

(statearr_25280_25428[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (15))){
var inst_25021 = (state_25244[(17)]);
var inst_25029 = (state_25244[(2)]);
var inst_25030 = fluree.db.util.async.throw_err(inst_25029);
var inst_25031 = [inst_25021];
var inst_25032 = [inst_25030];
var inst_25033 = cljs.core.PersistentHashMap.fromArrays(inst_25031,inst_25032);
var state_25244__$1 = state_25244;
var statearr_25281_25429 = state_25244__$1;
(statearr_25281_25429[(2)] = inst_25033);

(statearr_25281_25429[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (48))){
var inst_25193 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25282_25430 = state_25244__$1;
(statearr_25282_25430[(2)] = inst_25193);

(statearr_25282_25430[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (50))){
var inst_25116 = (state_25244[(18)]);
var state_25244__$1 = state_25244;
var statearr_25283_25431 = state_25244__$1;
(statearr_25283_25431[(2)] = inst_25116);

(statearr_25283_25431[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (75))){
var inst_25164 = (state_25244[(19)]);
var inst_25085 = (state_25244[(20)]);
var inst_25147 = (state_25244[(13)]);
var inst_25082 = (state_25244[(21)]);
var inst_25175 = (state_25244[(2)]);
var inst_25068 = inst_25082;
var inst_25069 = inst_25085;
var inst_25070 = inst_25147;
var inst_25071 = inst_25164;
var inst_25072 = inst_25175;
var state_25244__$1 = (function (){var statearr_25284 = state_25244;
(statearr_25284[(12)] = inst_25071);

(statearr_25284[(22)] = inst_25069);

(statearr_25284[(23)] = inst_25068);

(statearr_25284[(10)] = inst_25072);

(statearr_25284[(11)] = inst_25070);

return statearr_25284;
})();
var statearr_25285_25432 = state_25244__$1;
(statearr_25285_25432[(2)] = null);

(statearr_25285_25432[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (21))){
var inst_25049 = (state_25244[(24)]);
var inst_25053 = (state_25244[(25)]);
var inst_25061 = (state_25244[(26)]);
var inst_25066 = (state_25244[(2)]);
var inst_25067 = cljs.core.PersistentHashMap.EMPTY;
var inst_25068 = inst_25049;
var inst_25069 = inst_25053;
var inst_25070 = inst_25061;
var inst_25071 = inst_25066;
var inst_25072 = inst_25067;
var state_25244__$1 = (function (){var statearr_25286 = state_25244;
(statearr_25286[(12)] = inst_25071);

(statearr_25286[(22)] = inst_25069);

(statearr_25286[(23)] = inst_25068);

(statearr_25286[(10)] = inst_25072);

(statearr_25286[(11)] = inst_25070);

return statearr_25286;
})();
var statearr_25287_25433 = state_25244__$1;
(statearr_25287_25433[(2)] = null);

(statearr_25287_25433[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (31))){
var inst_25071 = (state_25244[(12)]);
var inst_25086 = (state_25244[(27)]);
var inst_25100 = (inst_25071 >= inst_25086);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25100)){
var statearr_25288_25434 = state_25244__$1;
(statearr_25288_25434[(1)] = (33));

} else {
var statearr_25289_25435 = state_25244__$1;
(statearr_25289_25435[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (32))){
var inst_25200 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25290_25436 = state_25244__$1;
(statearr_25290_25436[(2)] = inst_25200);

(statearr_25290_25436[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (40))){
var state_25244__$1 = state_25244;
var statearr_25291_25437 = state_25244__$1;
(statearr_25291_25437[(2)] = null);

(statearr_25291_25437[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (91))){
var inst_25225 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25292_25438 = state_25244__$1;
(statearr_25292_25438[(2)] = inst_25225);

(statearr_25292_25438[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (56))){
var inst_25130 = (state_25244[(14)]);
var state_25244__$1 = state_25244;
var statearr_25293_25439 = state_25244__$1;
(statearr_25293_25439[(2)] = inst_25130);

(statearr_25293_25439[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (33))){
var state_25244__$1 = state_25244;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25294_25440 = state_25244__$1;
(statearr_25294_25440[(1)] = (36));

} else {
var statearr_25295_25441 = state_25244__$1;
(statearr_25295_25441[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (13))){
var inst_25018 = (state_25244[(28)]);
var inst_25049 = (state_25244[(24)]);
var inst_25053 = (state_25244[(25)]);
var inst_25049__$1 = cljs.core.keys(inst_25018);
var inst_25050 = cljs.core.seq(inst_25049__$1);
var inst_25051 = cljs.core.first(inst_25050);
var inst_25052 = cljs.core.next(inst_25050);
var inst_25053__$1 = cljs.core.vals(inst_25018);
var inst_25054 = cljs.core.seq(inst_25053__$1);
var inst_25055 = cljs.core.first(inst_25054);
var inst_25056 = cljs.core.next(inst_25054);
var inst_25057 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_25244__$1 = (function (){var statearr_25296 = state_25244;
(statearr_25296[(24)] = inst_25049__$1);

(statearr_25296[(25)] = inst_25053__$1);

(statearr_25296[(29)] = inst_25051);

(statearr_25296[(30)] = inst_25052);

(statearr_25296[(31)] = inst_25055);

(statearr_25296[(32)] = inst_25056);

return statearr_25296;
})();
if(inst_25057){
var statearr_25297_25442 = state_25244__$1;
(statearr_25297_25442[(1)] = (16));

} else {
var statearr_25298_25443 = state_25244__$1;
(statearr_25298_25443[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (22))){
var inst_25069 = (state_25244[(22)]);
var inst_25068 = (state_25244[(23)]);
var inst_25080 = cljs.core.seq(inst_25068);
var inst_25081 = cljs.core.first(inst_25080);
var inst_25082 = cljs.core.next(inst_25080);
var inst_25083 = cljs.core.seq(inst_25069);
var inst_25084 = cljs.core.first(inst_25083);
var inst_25085 = cljs.core.next(inst_25083);
var inst_25086 = cljs.core.count(inst_25084);
var inst_25087 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25088 = [headers,vars,inst_25084];
var inst_25089 = cljs.core.PersistentHashMap.fromArrays(inst_25087,inst_25088);
var inst_25090 = (inst_25084 == null);
var state_25244__$1 = (function (){var statearr_25299 = state_25244;
(statearr_25299[(8)] = inst_25081);

(statearr_25299[(20)] = inst_25085);

(statearr_25299[(27)] = inst_25086);

(statearr_25299[(21)] = inst_25082);

(statearr_25299[(16)] = inst_25089);

return statearr_25299;
})();
if(cljs.core.truth_(inst_25090)){
var statearr_25300_25444 = state_25244__$1;
(statearr_25300_25444[(1)] = (24));

} else {
var statearr_25301_25445 = state_25244__$1;
(statearr_25301_25445[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (90))){
var inst_25215 = (state_25244[(15)]);
var state_25244__$1 = state_25244;
var statearr_25302_25446 = state_25244__$1;
(statearr_25302_25446[(2)] = inst_25215);

(statearr_25302_25446[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (36))){
var inst_25071 = (state_25244[(12)]);
var inst_25103 = (inst_25071 - (1));
var state_25244__$1 = state_25244;
var statearr_25303_25447 = state_25244__$1;
(statearr_25303_25447[(2)] = inst_25103);

(statearr_25303_25447[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (41))){
var inst_25196 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25304_25448 = state_25244__$1;
(statearr_25304_25448[(2)] = inst_25196);

(statearr_25304_25448[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (89))){
var inst_25215 = (state_25244[(15)]);
var inst_25220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25221 = [inst_25215];
var inst_25222 = (new cljs.core.PersistentVector(null,1,(5),inst_25220,inst_25221,null));
var state_25244__$1 = state_25244;
var statearr_25305_25449 = state_25244__$1;
(statearr_25305_25449[(2)] = inst_25222);

(statearr_25305_25449[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (43))){
var inst_25116 = (state_25244[(18)]);
var inst_25119 = cljs.core.seq(inst_25116);
var state_25244__$1 = state_25244;
var statearr_25306_25450 = state_25244__$1;
(statearr_25306_25450[(2)] = inst_25119);

(statearr_25306_25450[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (61))){
var state_25244__$1 = state_25244;
var statearr_25307_25451 = state_25244__$1;
(statearr_25307_25451[(2)] = (0));

(statearr_25307_25451[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (29))){
var inst_25097 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25097)){
var statearr_25308_25452 = state_25244__$1;
(statearr_25308_25452[(1)] = (30));

} else {
var statearr_25309_25453 = state_25244__$1;
(statearr_25309_25453[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (44))){
var inst_25117 = (state_25244[(33)]);
var state_25244__$1 = state_25244;
var statearr_25310_25454 = state_25244__$1;
(statearr_25310_25454[(2)] = inst_25117);

(statearr_25310_25454[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (93))){
var state_25244__$1 = state_25244;
var statearr_25311_25455 = state_25244__$1;
(statearr_25311_25455[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (6))){
var inst_25010 = (state_25244[(34)]);
var inst_25010__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25012 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25244__$1 = (function (){var statearr_25313 = state_25244;
(statearr_25313[(34)] = inst_25010__$1);

(statearr_25313[(35)] = inst_25012);

return statearr_25313;
})();
if(cljs.core.truth_(inst_25010__$1)){
var statearr_25314_25456 = state_25244__$1;
(statearr_25314_25456[(1)] = (9));

} else {
var statearr_25315_25457 = state_25244__$1;
(statearr_25315_25457[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (28))){
var inst_25070 = (state_25244[(11)]);
var state_25244__$1 = state_25244;
var statearr_25316_25458 = state_25244__$1;
(statearr_25316_25458[(2)] = inst_25070);

(statearr_25316_25458[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (64))){
var inst_25071 = (state_25244[(12)]);
var inst_25152 = (inst_25071 - (1));
var state_25244__$1 = state_25244;
var statearr_25317_25459 = state_25244__$1;
(statearr_25317_25459[(2)] = inst_25152);

(statearr_25317_25459[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (51))){
var inst_25070 = (state_25244[(11)]);
var inst_25130 = (state_25244[(2)]);
var state_25244__$1 = (function (){var statearr_25318 = state_25244;
(statearr_25318[(14)] = inst_25130);

return statearr_25318;
})();
if(cljs.core.truth_(inst_25070)){
var statearr_25319_25460 = state_25244__$1;
(statearr_25319_25460[(1)] = (52));

} else {
var statearr_25320_25461 = state_25244__$1;
(statearr_25320_25461[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (25))){
var inst_25070 = (state_25244[(11)]);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25070)){
var statearr_25321_25462 = state_25244__$1;
(statearr_25321_25462[(1)] = (27));

} else {
var statearr_25322_25463 = state_25244__$1;
(statearr_25322_25463[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (34))){
var state_25244__$1 = state_25244;
var statearr_25323_25464 = state_25244__$1;
(statearr_25323_25464[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (17))){
var state_25244__$1 = state_25244;
var statearr_25325_25465 = state_25244__$1;
(statearr_25325_25465[(2)] = limit);

(statearr_25325_25465[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (3))){
var inst_25242 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25244__$1,inst_25242);
} else {
if((state_val_25245 === (12))){
var inst_25018 = (state_25244[(28)]);
var inst_25020 = cljs.core.keys(inst_25018);
var inst_25021 = cljs.core.first(inst_25020);
var inst_25022 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25023 = cljs.core.vals(inst_25018);
var inst_25024 = cljs.core.first(inst_25023);
var inst_25025 = [headers,vars,inst_25024];
var inst_25026 = cljs.core.PersistentHashMap.fromArrays(inst_25022,inst_25025);
var inst_25027 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_25026,select_spec,limit,opts);
var state_25244__$1 = (function (){var statearr_25326 = state_25244;
(statearr_25326[(17)] = inst_25021);

return statearr_25326;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25244__$1,(15),inst_25027);
} else {
if((state_val_25245 === (2))){
var _ = (function (){var statearr_25327 = state_25244;
(statearr_25327[(4)] = cljs.core.cons((5),(state_25244[(4)])));

return statearr_25327;
})();
var state_25244__$1 = state_25244;
if(cljs.core.truth_(groupBy)){
var statearr_25328_25466 = state_25244__$1;
(statearr_25328_25466[(1)] = (6));

} else {
var statearr_25329_25467 = state_25244__$1;
(statearr_25329_25467[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (66))){
var inst_25162 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25330_25468 = state_25244__$1;
(statearr_25330_25468[(2)] = inst_25162);

(statearr_25330_25468[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (23))){
var inst_25204 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25331_25469 = state_25244__$1;
(statearr_25331_25469[(2)] = inst_25204);

(statearr_25331_25469[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (47))){
var inst_25070 = (state_25244[(11)]);
var inst_25178 = (inst_25070 == null);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25178)){
var statearr_25332_25470 = state_25244__$1;
(statearr_25332_25470[(1)] = (76));

} else {
var statearr_25333_25471 = state_25244__$1;
(statearr_25333_25471[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (35))){
var inst_25198 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25334_25472 = state_25244__$1;
(statearr_25334_25472[(2)] = inst_25198);

(statearr_25334_25472[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (82))){
var state_25244__$1 = state_25244;
var statearr_25335_25473 = state_25244__$1;
(statearr_25335_25473[(2)] = (1));

(statearr_25335_25473[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (76))){
var state_25244__$1 = state_25244;
var statearr_25336_25474 = state_25244__$1;
(statearr_25336_25474[(2)] = null);

(statearr_25336_25474[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (97))){
var inst_25233 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25337_25475 = state_25244__$1;
(statearr_25337_25475[(2)] = inst_25233);

(statearr_25337_25475[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (19))){
var inst_25062 = (state_25244[(36)]);
var state_25244__$1 = state_25244;
var statearr_25338_25476 = state_25244__$1;
(statearr_25338_25476[(2)] = inst_25062);

(statearr_25338_25476[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (57))){
var inst_25070 = (state_25244[(11)]);
var inst_25140 = (state_25244[(2)]);
var inst_25141 = (inst_25070 == null);
var state_25244__$1 = (function (){var statearr_25339 = state_25244;
(statearr_25339[(9)] = inst_25140);

return statearr_25339;
})();
if(cljs.core.truth_(inst_25141)){
var statearr_25340_25477 = state_25244__$1;
(statearr_25340_25477[(1)] = (58));

} else {
var statearr_25341_25478 = state_25244__$1;
(statearr_25341_25478[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (68))){
var state_25244__$1 = state_25244;
var statearr_25342_25479 = state_25244__$1;
(statearr_25342_25479[(2)] = null);

(statearr_25342_25479[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (11))){
var inst_25018 = (state_25244[(2)]);
var state_25244__$1 = (function (){var statearr_25344 = state_25244;
(statearr_25344[(28)] = inst_25018);

return statearr_25344;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25345_25480 = state_25244__$1;
(statearr_25345_25480[(1)] = (12));

} else {
var statearr_25346_25481 = state_25244__$1;
(statearr_25346_25481[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (9))){
var inst_25010 = (state_25244[(34)]);
var inst_25012 = (state_25244[(35)]);
var inst_25014 = cljs.core.sorted_map_by(inst_25010);
var inst_25015 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25014,inst_25012);
var state_25244__$1 = state_25244;
var statearr_25347_25482 = state_25244__$1;
(statearr_25347_25482[(2)] = inst_25015);

(statearr_25347_25482[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (5))){
var _ = (function (){var statearr_25348 = state_25244;
(statearr_25348[(4)] = cljs.core.rest((state_25244[(4)])));

return statearr_25348;
})();
var state_25244__$1 = state_25244;
var ex25343 = (state_25244__$1[(2)]);
var statearr_25349_25483 = state_25244__$1;
(statearr_25349_25483[(5)] = ex25343);


if((ex25343 instanceof Error)){
var statearr_25350_25484 = state_25244__$1;
(statearr_25350_25484[(1)] = (4));

(statearr_25350_25484[(5)] = null);

} else {
throw ex25343;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (83))){
var state_25244__$1 = state_25244;
var statearr_25351_25485 = state_25244__$1;
(statearr_25351_25485[(2)] = limit);

(statearr_25351_25485[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (14))){
var inst_25206 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25352_25486 = state_25244__$1;
(statearr_25352_25486[(2)] = inst_25206);

(statearr_25352_25486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (45))){
var inst_25122 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
if(cljs.core.truth_(inst_25122)){
var statearr_25353_25487 = state_25244__$1;
(statearr_25353_25487[(1)] = (46));

} else {
var statearr_25354_25488 = state_25244__$1;
(statearr_25354_25488[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (53))){
var inst_25070 = (state_25244[(11)]);
var state_25244__$1 = state_25244;
var statearr_25355_25489 = state_25244__$1;
(statearr_25355_25489[(2)] = inst_25070);

(statearr_25355_25489[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (78))){
var inst_25071 = (state_25244[(12)]);
var inst_25183 = (state_25244[(2)]);
var inst_25184 = (inst_25071 <= (0));
var state_25244__$1 = (function (){var statearr_25356 = state_25244;
(statearr_25356[(37)] = inst_25183);

return statearr_25356;
})();
if(cljs.core.truth_(inst_25184)){
var statearr_25357_25490 = state_25244__$1;
(statearr_25357_25490[(1)] = (79));

} else {
var statearr_25358_25491 = state_25244__$1;
(statearr_25358_25491[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (26))){
var inst_25202 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25359_25492 = state_25244__$1;
(statearr_25359_25492[(2)] = inst_25202);

(statearr_25359_25492[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (16))){
var state_25244__$1 = state_25244;
var statearr_25360_25493 = state_25244__$1;
(statearr_25360_25493[(2)] = null);

(statearr_25360_25493[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (81))){
var inst_25116 = (state_25244[(18)]);
var inst_25081 = (state_25244[(8)]);
var inst_25085 = (state_25244[(20)]);
var inst_25072 = (state_25244[(10)]);
var inst_25183 = (state_25244[(37)]);
var inst_25082 = (state_25244[(21)]);
var inst_25189 = (state_25244[(2)]);
var inst_25190 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25072,inst_25081,inst_25116);
var inst_25068 = inst_25082;
var inst_25069 = inst_25085;
var inst_25070 = inst_25183;
var inst_25071 = inst_25189;
var inst_25072__$1 = inst_25190;
var state_25244__$1 = (function (){var statearr_25363 = state_25244;
(statearr_25363[(12)] = inst_25071);

(statearr_25363[(22)] = inst_25069);

(statearr_25363[(23)] = inst_25068);

(statearr_25363[(10)] = inst_25072__$1);

(statearr_25363[(11)] = inst_25070);

return statearr_25363;
})();
var statearr_25364_25494 = state_25244__$1;
(statearr_25364_25494[(2)] = null);

(statearr_25364_25494[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (79))){
var state_25244__$1 = state_25244;
var statearr_25365_25495 = state_25244__$1;
(statearr_25365_25495[(2)] = (0));

(statearr_25365_25495[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (38))){
var inst_25085 = (state_25244[(20)]);
var inst_25072 = (state_25244[(10)]);
var inst_25082 = (state_25244[(21)]);
var inst_25070 = (state_25244[(11)]);
var inst_25107 = (state_25244[(2)]);
var tmp25361 = inst_25072;
var tmp25362 = inst_25070;
var inst_25068 = inst_25082;
var inst_25069 = inst_25085;
var inst_25070__$1 = tmp25362;
var inst_25071 = inst_25107;
var inst_25072__$1 = tmp25361;
var state_25244__$1 = (function (){var statearr_25366 = state_25244;
(statearr_25366[(12)] = inst_25071);

(statearr_25366[(22)] = inst_25069);

(statearr_25366[(23)] = inst_25068);

(statearr_25366[(10)] = inst_25072__$1);

(statearr_25366[(11)] = inst_25070__$1);

return statearr_25366;
})();
var statearr_25367_25496 = state_25244__$1;
(statearr_25367_25496[(2)] = null);

(statearr_25367_25496[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (87))){
var state_25244__$1 = state_25244;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25368_25497 = state_25244__$1;
(statearr_25368_25497[(1)] = (92));

} else {
var statearr_25369_25498 = state_25244__$1;
(statearr_25369_25498[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (30))){
var inst_25072 = (state_25244[(10)]);
var state_25244__$1 = state_25244;
var statearr_25370_25499 = state_25244__$1;
(statearr_25370_25499[(2)] = inst_25072);

(statearr_25370_25499[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (73))){
var inst_25072 = (state_25244[(10)]);
var state_25244__$1 = state_25244;
var statearr_25371_25500 = state_25244__$1;
(statearr_25371_25500[(2)] = inst_25072);

(statearr_25371_25500[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (96))){
var state_25244__$1 = state_25244;
var statearr_25372_25501 = state_25244__$1;
(statearr_25372_25501[(2)] = null);

(statearr_25372_25501[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (10))){
var inst_25012 = (state_25244[(35)]);
var state_25244__$1 = state_25244;
var statearr_25373_25502 = state_25244__$1;
(statearr_25373_25502[(2)] = inst_25012);

(statearr_25373_25502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (18))){
var inst_25062 = (state_25244[(36)]);
var inst_25061 = (state_25244[(2)]);
var inst_25062__$1 = offset;
var state_25244__$1 = (function (){var statearr_25374 = state_25244;
(statearr_25374[(36)] = inst_25062__$1);

(statearr_25374[(26)] = inst_25061);

return statearr_25374;
})();
if(cljs.core.truth_(inst_25062__$1)){
var statearr_25375_25503 = state_25244__$1;
(statearr_25375_25503[(1)] = (19));

} else {
var statearr_25376_25504 = state_25244__$1;
(statearr_25376_25504[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (52))){
var inst_25070 = (state_25244[(11)]);
var inst_25132 = ((0) < inst_25070);
var state_25244__$1 = state_25244;
var statearr_25377_25505 = state_25244__$1;
(statearr_25377_25505[(2)] = inst_25132);

(statearr_25377_25505[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (67))){
var inst_25071 = (state_25244[(12)]);
var inst_25140 = (state_25244[(9)]);
var inst_25086 = (state_25244[(27)]);
var inst_25155 = cljs.core.count(inst_25140);
var inst_25156 = (inst_25086 - inst_25155);
var inst_25157 = (inst_25071 - inst_25156);
var state_25244__$1 = state_25244;
var statearr_25378_25506 = state_25244__$1;
(statearr_25378_25506[(2)] = inst_25157);

(statearr_25378_25506[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (71))){
var inst_25140 = (state_25244[(9)]);
var inst_25168 = cljs.core.empty_QMARK_(inst_25140);
var state_25244__$1 = state_25244;
var statearr_25379_25507 = state_25244__$1;
(statearr_25379_25507[(2)] = inst_25168);

(statearr_25379_25507[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (42))){
var inst_25116 = (state_25244[(18)]);
var inst_25117 = (state_25244[(33)]);
var inst_25115 = (state_25244[(2)]);
var inst_25116__$1 = fluree.db.util.async.throw_err(inst_25115);
var inst_25117__$1 = cljs.core.coll_QMARK_(inst_25116__$1);
var state_25244__$1 = (function (){var statearr_25380 = state_25244;
(statearr_25380[(18)] = inst_25116__$1);

(statearr_25380[(33)] = inst_25117__$1);

return statearr_25380;
})();
if(inst_25117__$1){
var statearr_25381_25508 = state_25244__$1;
(statearr_25381_25508[(1)] = (43));

} else {
var statearr_25382_25509 = state_25244__$1;
(statearr_25382_25509[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (80))){
var inst_25071 = (state_25244[(12)]);
var inst_25187 = (inst_25071 - (1));
var state_25244__$1 = state_25244;
var statearr_25383_25510 = state_25244__$1;
(statearr_25383_25510[(2)] = inst_25187);

(statearr_25383_25510[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (37))){
var inst_25071 = (state_25244[(12)]);
var inst_25086 = (state_25244[(27)]);
var inst_25105 = (inst_25071 - inst_25086);
var state_25244__$1 = state_25244;
var statearr_25384_25511 = state_25244__$1;
(statearr_25384_25511[(2)] = inst_25105);

(statearr_25384_25511[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (63))){
var inst_25165 = (state_25244[(7)]);
var inst_25140 = (state_25244[(9)]);
var inst_25164 = (state_25244[(2)]);
var inst_25165__$1 = (inst_25140 == null);
var state_25244__$1 = (function (){var statearr_25385 = state_25244;
(statearr_25385[(7)] = inst_25165__$1);

(statearr_25385[(19)] = inst_25164);

return statearr_25385;
})();
if(cljs.core.truth_(inst_25165__$1)){
var statearr_25386_25512 = state_25244__$1;
(statearr_25386_25512[(1)] = (70));

} else {
var statearr_25387_25513 = state_25244__$1;
(statearr_25387_25513[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (94))){
var inst_25235 = (state_25244[(2)]);
var state_25244__$1 = state_25244;
var statearr_25388_25514 = state_25244__$1;
(statearr_25388_25514[(2)] = inst_25235);

(statearr_25388_25514[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (8))){
var inst_25239 = (state_25244[(2)]);
var _ = (function (){var statearr_25389 = state_25244;
(statearr_25389[(4)] = cljs.core.rest((state_25244[(4)])));

return statearr_25389;
})();
var state_25244__$1 = state_25244;
var statearr_25390_25515 = state_25244__$1;
(statearr_25390_25515[(2)] = inst_25239);

(statearr_25390_25515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (49))){
var inst_25071 = (state_25244[(12)]);
var inst_25116 = (state_25244[(18)]);
var inst_25127 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_25071,inst_25116);
var state_25244__$1 = state_25244;
var statearr_25391_25516 = state_25244__$1;
(statearr_25391_25516[(2)] = inst_25127);

(statearr_25391_25516[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25245 === (84))){
var inst_25211 = (state_25244[(2)]);
var inst_25212 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25211,opts);
var state_25244__$1 = state_25244;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25244__$1,(85),inst_25212);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____0 = (function (){
var statearr_25392 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25392[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__);

(statearr_25392[(1)] = (1));

return statearr_25392;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____1 = (function (state_25244){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_25244);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e25393){var ex__2736__auto__ = e25393;
var statearr_25394_25517 = state_25244;
(statearr_25394_25517[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_25244[(4)]))){
var statearr_25395_25518 = state_25244;
(statearr_25395_25518[(1)] = cljs.core.first((state_25244[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25519 = state_25244;
state_25244 = G__25519;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__ = function(state_25244){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____1.call(this,state_25244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_25396 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_25396[(6)] = c__2755__auto__);

return statearr_25396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25522,opts){
var map__25523 = p__25522;
var map__25523__$1 = cljs.core.__destructure_map(map__25523);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25523__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25523__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25523__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25523__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25520_SHARP_){
return cljs.core.contains_QMARK_(p1__25520_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__25521_SHARP_){
return cljs.core.contains_QMARK_(p1__25521_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4221__auto__){
var G__25525 = cljs.core.first(orderBy);
var fexpr__25524 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__25524.cljs$core$IFn$_invoke$arity$1 ? fexpr__25524.cljs$core$IFn$_invoke$arity$1(G__25525) : fexpr__25524.call(null,G__25525));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25526,p__25527){
var map__25528 = p__25526;
var map__25528__$1 = cljs.core.__destructure_map(map__25528);
var query_map = map__25528__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25528__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25529 = p__25527;
var map__25529__$1 = cljs.core.__destructure_map(map__25529);
var where_result = map__25529__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25529__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25529__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25530 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25530,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25530,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25530,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_25563){
var state_val_25564 = (state_25563[(1)]);
if((state_val_25564 === (7))){
var inst_25542 = (state_25563[(7)]);
var state_25563__$1 = state_25563;
var statearr_25565_25588 = state_25563__$1;
(statearr_25565_25588[(2)] = inst_25542);

(statearr_25565_25588[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (1))){
var state_25563__$1 = state_25563;
var statearr_25566_25589 = state_25563__$1;
(statearr_25566_25589[(2)] = null);

(statearr_25566_25589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (4))){
var inst_25533 = (state_25563[(2)]);
var state_25563__$1 = state_25563;
var statearr_25567_25590 = state_25563__$1;
(statearr_25567_25590[(2)] = inst_25533);

(statearr_25567_25590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (13))){
var inst_25552 = (state_25563[(2)]);
var inst_25553 = fluree.db.util.async.throw_err(inst_25552);
var state_25563__$1 = state_25563;
var statearr_25568_25591 = state_25563__$1;
(statearr_25568_25591[(2)] = inst_25553);

(statearr_25568_25591[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (6))){
var inst_25542 = (state_25563[(7)]);
var inst_25541 = (state_25563[(2)]);
var inst_25542__$1 = fluree.db.util.async.throw_err(inst_25541);
var inst_25543 = fluree.db.util.core.exception_QMARK_(inst_25542__$1);
var state_25563__$1 = (function (){var statearr_25569 = state_25563;
(statearr_25569[(7)] = inst_25542__$1);

return statearr_25569;
})();
if(inst_25543){
var statearr_25570_25592 = state_25563__$1;
(statearr_25570_25592[(1)] = (7));

} else {
var statearr_25571_25593 = state_25563__$1;
(statearr_25571_25593[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (3))){
var inst_25561 = (state_25563[(2)]);
var state_25563__$1 = state_25563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25563__$1,inst_25561);
} else {
if((state_val_25564 === (12))){
var inst_25556 = (state_25563[(2)]);
var state_25563__$1 = state_25563;
var statearr_25572_25594 = state_25563__$1;
(statearr_25572_25594[(2)] = inst_25556);

(statearr_25572_25594[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (2))){
var _ = (function (){var statearr_25573 = state_25563;
(statearr_25573[(4)] = cljs.core.cons((5),(state_25563[(4)])));

return statearr_25573;
})();
var inst_25539 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_25563__$1 = state_25563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25563__$1,(6),inst_25539);
} else {
if((state_val_25564 === (11))){
var state_25563__$1 = state_25563;
var statearr_25575_25595 = state_25563__$1;
(statearr_25575_25595[(2)] = null);

(statearr_25575_25595[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (9))){
var inst_25558 = (state_25563[(2)]);
var _ = (function (){var statearr_25576 = state_25563;
(statearr_25576[(4)] = cljs.core.rest((state_25563[(4)])));

return statearr_25576;
})();
var state_25563__$1 = state_25563;
var statearr_25577_25596 = state_25563__$1;
(statearr_25577_25596[(2)] = inst_25558);

(statearr_25577_25596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (5))){
var _ = (function (){var statearr_25578 = state_25563;
(statearr_25578[(4)] = cljs.core.rest((state_25563[(4)])));

return statearr_25578;
})();
var state_25563__$1 = state_25563;
var ex25574 = (state_25563__$1[(2)]);
var statearr_25579_25597 = state_25563__$1;
(statearr_25579_25597[(5)] = ex25574);


if((ex25574 instanceof Error)){
var statearr_25580_25598 = state_25563__$1;
(statearr_25580_25598[(1)] = (4));

(statearr_25580_25598[(5)] = null);

} else {
throw ex25574;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25564 === (10))){
var inst_25542 = (state_25563[(7)]);
var inst_25547 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25542);
var inst_25548 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25542);
var inst_25549 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_25547,inst_25548,query_map,opts);
var inst_25550 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_25542,inst_25549,opts);
var state_25563__$1 = state_25563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25563__$1,(13),inst_25550);
} else {
if((state_val_25564 === (8))){
var state_25563__$1 = state_25563;
var statearr_25581_25599 = state_25563__$1;
(statearr_25581_25599[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____0 = (function (){
var statearr_25583 = [null,null,null,null,null,null,null,null];
(statearr_25583[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__);

(statearr_25583[(1)] = (1));

return statearr_25583;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____1 = (function (state_25563){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_25563);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e25584){var ex__2736__auto__ = e25584;
var statearr_25585_25600 = state_25563;
(statearr_25585_25600[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_25563[(4)]))){
var statearr_25586_25601 = state_25563;
(statearr_25586_25601[(1)] = cljs.core.first((state_25563[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25602 = state_25563;
state_25563 = G__25602;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__ = function(state_25563){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____1.call(this,state_25563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_25587 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_25587[(6)] = c__2755__auto__);

return statearr_25587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__25603 = query_map;
var map__25603__$1 = cljs.core.__destructure_map(map__25603);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25603__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25604 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25604,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25604;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_25959){
var state_val_25960 = (state_25959[(1)]);
if((state_val_25960 === (121))){
var inst_25920 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_25961_26156 = state_25959__$1;
(statearr_25961_26156[(2)] = inst_25920);

(statearr_25961_26156[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (65))){
var inst_25797 = typeof from === 'string';
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25797)){
var statearr_25962_26157 = state_25959__$1;
(statearr_25962_26157[(1)] = (72));

} else {
var statearr_25963_26158 = state_25959__$1;
(statearr_25963_26158[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (70))){
var inst_25668 = (state_25959[(7)]);
var inst_25666 = (state_25959[(8)]);
var inst_25790 = (state_25959[(2)]);
var inst_25791 = fluree.db.util.async.throw_err(inst_25790);
var inst_25792 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25668,fuel,max_fuel,inst_25666,inst_25791);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(71),inst_25792);
} else {
if((state_val_25960 === (62))){
var inst_25770 = (state_25959[(9)]);
var state_25959__$1 = state_25959;
var statearr_25964_26159 = state_25959__$1;
(statearr_25964_26159[(2)] = inst_25770);

(statearr_25964_26159[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (74))){
var inst_25926 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_25965_26160 = state_25959__$1;
(statearr_25965_26160[(2)] = inst_25926);

(statearr_25965_26160[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (110))){
var inst_25861 = (state_25959[(10)]);
var state_25959__$1 = state_25959;
var statearr_25966_26161 = state_25959__$1;
(statearr_25966_26161[(2)] = inst_25861);

(statearr_25966_26161[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (130))){
var inst_25946 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_25967_26162 = state_25959__$1;
(statearr_25967_26162[(2)] = inst_25946);

(statearr_25967_26162[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (128))){
var inst_25937 = (state_25959[(11)]);
var inst_25942 = fluree.db.util.core.exception_QMARK_(inst_25937);
var inst_25943 = (!(inst_25942));
var state_25959__$1 = state_25959;
var statearr_25968_26163 = state_25959__$1;
(statearr_25968_26163[(2)] = inst_25943);

(statearr_25968_26163[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (7))){
var inst_25636 = (state_25959[(12)]);
var inst_25636__$1 = selectOne;
var state_25959__$1 = (function (){var statearr_25969 = state_25959;
(statearr_25969[(12)] = inst_25636__$1);

return statearr_25969;
})();
if(cljs.core.truth_(inst_25636__$1)){
var statearr_25970_26164 = state_25959__$1;
(statearr_25970_26164[(1)] = (9));

} else {
var statearr_25971_26165 = state_25959__$1;
(statearr_25971_26165[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (59))){
var inst_25748 = (state_25959[(13)]);
var inst_25668 = (state_25959[(7)]);
var inst_25666 = (state_25959[(8)]);
var inst_25656 = (state_25959[(14)]);
var inst_25762 = (state_25959[(2)]);
var inst_25763 = fluree.db.util.async.throw_err(inst_25762);
var inst_25764 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_25748,inst_25763);
var inst_25765 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_25668,fuel,max_fuel,inst_25666,inst_25764,inst_25656);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(60),inst_25765);
} else {
if((state_val_25960 === (86))){
var inst_25658 = (state_25959[(15)]);
var inst_25668 = (state_25959[(7)]);
var inst_25666 = (state_25959[(8)]);
var inst_25656 = (state_25959[(14)]);
var inst_25830 = (state_25959[(2)]);
var inst_25831 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25668,fuel,max_fuel,inst_25666,inst_25830,inst_25656,inst_25658);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(87),inst_25831);
} else {
if((state_val_25960 === (20))){
var inst_25700 = (state_25959[(2)]);
var inst_25701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25700,(0),null);
var inst_25702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25700,(1),null);
var inst_25703 = typeof where === 'string';
var state_25959__$1 = (function (){var statearr_25972 = state_25959;
(statearr_25972[(16)] = inst_25701);

(statearr_25972[(17)] = inst_25702);

return statearr_25972;
})();
if(cljs.core.truth_(inst_25703)){
var statearr_25973_26166 = state_25959__$1;
(statearr_25973_26166[(1)] = (30));

} else {
var statearr_25974_26167 = state_25959__$1;
(statearr_25974_26167[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (72))){
var inst_25655 = (state_25959[(18)]);
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25655)){
var statearr_25975_26168 = state_25959__$1;
(statearr_25975_26168[(1)] = (75));

} else {
var statearr_25976_26169 = state_25959__$1;
(statearr_25976_26169[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (58))){
var inst_25756 = (state_25959[(2)]);
var inst_25757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25758 = [from];
var inst_25759 = (new cljs.core.PersistentVector(null,1,(5),inst_25757,inst_25758,null));
var inst_25760 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25759,inst_25756);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(59),inst_25760);
} else {
if((state_val_25960 === (60))){
var inst_25767 = (state_25959[(2)]);
var inst_25768 = fluree.db.util.async.throw_err(inst_25767);
var state_25959__$1 = state_25959;
var statearr_25977_26170 = state_25959__$1;
(statearr_25977_26170[(2)] = inst_25768);

(statearr_25977_26170[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (27))){
var inst_25685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25686 = [null,null];
var inst_25687 = (new cljs.core.PersistentVector(null,2,(5),inst_25685,inst_25686,null));
var state_25959__$1 = state_25959;
var statearr_25978_26171 = state_25959__$1;
(statearr_25978_26171[(2)] = inst_25687);

(statearr_25978_26171[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (1))){
var state_25959__$1 = state_25959;
var statearr_25979_26172 = state_25959__$1;
(statearr_25979_26172[(2)] = null);

(statearr_25979_26172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (69))){
var inst_25787 = (state_25959[(2)]);
var inst_25788 = fluree.db.query.range._block_or_tx_collection(db,inst_25787);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(70),inst_25788);
} else {
if((state_val_25960 === (101))){
var inst_25893 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_25980_26173 = state_25959__$1;
(statearr_25980_26173[(2)] = inst_25893);

(statearr_25980_26173[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (24))){
var inst_25655 = (state_25959[(18)]);
var inst_25680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25681 = [inst_25655,"ASC"];
var inst_25682 = (new cljs.core.PersistentVector(null,2,(5),inst_25680,inst_25681,null));
var state_25959__$1 = state_25959;
var statearr_25981_26174 = state_25959__$1;
(statearr_25981_26174[(2)] = inst_25682);

(statearr_25981_26174[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (102))){
var inst_25867 = (state_25959[(19)]);
var state_25959__$1 = state_25959;
var statearr_25982_26175 = state_25959__$1;
(statearr_25982_26175[(2)] = inst_25867);

(statearr_25982_26175[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (55))){
var inst_25655 = (state_25959[(18)]);
var inst_25748 = (state_25959[(2)]);
var state_25959__$1 = (function (){var statearr_25983 = state_25959;
(statearr_25983[(13)] = inst_25748);

return statearr_25983;
})();
if(cljs.core.truth_(inst_25655)){
var statearr_25984_26176 = state_25959__$1;
(statearr_25984_26176[(1)] = (56));

} else {
var statearr_25985_26177 = state_25959__$1;
(statearr_25985_26177[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (85))){
var inst_25822 = (state_25959[(20)]);
var inst_25826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25827 = [inst_25822];
var inst_25828 = (new cljs.core.PersistentVector(null,1,(5),inst_25826,inst_25827,null));
var state_25959__$1 = state_25959;
var statearr_25986_26178 = state_25959__$1;
(statearr_25986_26178[(2)] = inst_25828);

(statearr_25986_26178[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (39))){
var inst_25656 = (state_25959[(14)]);
var state_25959__$1 = state_25959;
var statearr_25987_26179 = state_25959__$1;
(statearr_25987_26179[(2)] = inst_25656);

(statearr_25987_26179[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (88))){
var inst_25836 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_25959__$1 = state_25959;
var statearr_25988_26180 = state_25959__$1;
(statearr_25988_26180[(2)] = inst_25836);

(statearr_25988_26180[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (46))){
var inst_25733 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25733)){
var statearr_25989_26181 = state_25959__$1;
(statearr_25989_26181[(1)] = (47));

} else {
var statearr_25990_26182 = state_25959__$1;
(statearr_25990_26182[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (4))){
var inst_25623 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_25991_26183 = state_25959__$1;
(statearr_25991_26183[(2)] = inst_25623);

(statearr_25991_26183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (77))){
var inst_25806 = (state_25959[(2)]);
var inst_25807 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_25806);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(78),inst_25807);
} else {
if((state_val_25960 === (106))){
var state_25959__$1 = state_25959;
var statearr_25992_26184 = state_25959__$1;
(statearr_25992_26184[(2)] = null);

(statearr_25992_26184[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (119))){
var inst_25912 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_25913 = ["Invalid 'from' in query:",inst_25912].join('');
var inst_25914 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25915 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25916 = cljs.core.PersistentHashMap.fromArrays(inst_25914,inst_25915);
var inst_25917 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25913,inst_25916);
var state_25959__$1 = state_25959;
var statearr_25993_26185 = state_25959__$1;
(statearr_25993_26185[(2)] = inst_25917);

(statearr_25993_26185[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (95))){
var state_25959__$1 = state_25959;
var statearr_25994_26186 = state_25959__$1;
(statearr_25994_26186[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (54))){
var inst_25742 = (state_25959[(21)]);
var state_25959__$1 = state_25959;
var statearr_25996_26187 = state_25959__$1;
(statearr_25996_26187[(2)] = inst_25742);

(statearr_25996_26187[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (92))){
var inst_25841 = (state_25959[(22)]);
var state_25959__$1 = state_25959;
var statearr_25997_26188 = state_25959__$1;
(statearr_25997_26188[(2)] = inst_25841);

(statearr_25997_26188[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (104))){
var inst_25885 = (state_25959[(23)]);
var inst_25885__$1 = (state_25959[(2)]);
var state_25959__$1 = (function (){var statearr_25998 = state_25959;
(statearr_25998[(23)] = inst_25885__$1);

return statearr_25998;
})();
if(cljs.core.truth_(inst_25885__$1)){
var statearr_25999_26189 = state_25959__$1;
(statearr_25999_26189[(1)] = (109));

} else {
var statearr_26000_26190 = state_25959__$1;
(statearr_26000_26190[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (15))){
var inst_25657 = (state_25959[(24)]);
var inst_25659 = (state_25959[(25)]);
var inst_25663 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25659,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25657);
var state_25959__$1 = state_25959;
var statearr_26001_26191 = state_25959__$1;
(statearr_26001_26191[(2)] = inst_25663);

(statearr_26001_26191[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (48))){
var inst_25770 = (state_25959[(9)]);
var inst_25770__$1 = typeof from === 'string';
var state_25959__$1 = (function (){var statearr_26002 = state_25959;
(statearr_26002[(9)] = inst_25770__$1);

return statearr_26002;
})();
if(cljs.core.truth_(inst_25770__$1)){
var statearr_26003_26192 = state_25959__$1;
(statearr_26003_26192[(1)] = (61));

} else {
var statearr_26004_26193 = state_25959__$1;
(statearr_26004_26193[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (50))){
var inst_25736 = (state_25959[(26)]);
var inst_25738 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_25739 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25736,inst_25738);
var state_25959__$1 = state_25959;
var statearr_26005_26194 = state_25959__$1;
(statearr_26005_26194[(2)] = inst_25739);

(statearr_26005_26194[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (116))){
var state_25959__$1 = state_25959;
var statearr_26006_26195 = state_25959__$1;
(statearr_26006_26195[(2)] = null);

(statearr_26006_26195[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (75))){
var inst_25800 = cljs.core.PersistentHashMap.EMPTY;
var state_25959__$1 = state_25959;
var statearr_26007_26196 = state_25959__$1;
(statearr_26007_26196[(2)] = inst_25800);

(statearr_26007_26196[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (99))){
var inst_25861 = (state_25959[(10)]);
var state_25959__$1 = state_25959;
var statearr_26008_26197 = state_25959__$1;
(statearr_26008_26197[(2)] = inst_25861);

(statearr_26008_26197[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (21))){
var inst_25655 = (state_25959[(18)]);
var inst_25672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25673 = cljs.core.second(inst_25655);
var inst_25674 = cljs.core.first(inst_25655);
var inst_25675 = [inst_25673,inst_25674];
var inst_25676 = (new cljs.core.PersistentVector(null,2,(5),inst_25672,inst_25675,null));
var state_25959__$1 = state_25959;
var statearr_26009_26198 = state_25959__$1;
(statearr_26009_26198[(2)] = inst_25676);

(statearr_26009_26198[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (31))){
var inst_25727 = (state_25959[(27)]);
var inst_25727__$1 = typeof from === 'string';
var state_25959__$1 = (function (){var statearr_26010 = state_25959;
(statearr_26010[(27)] = inst_25727__$1);

return statearr_26010;
})();
if(cljs.core.truth_(inst_25727__$1)){
var statearr_26011_26199 = state_25959__$1;
(statearr_26011_26199[(1)] = (44));

} else {
var statearr_26012_26200 = state_25959__$1;
(statearr_26012_26200[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (113))){
var state_25959__$1 = state_25959;
var statearr_26013_26201 = state_25959__$1;
(statearr_26013_26201[(2)] = null);

(statearr_26013_26201[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (32))){
var inst_25701 = (state_25959[(16)]);
var inst_25932 = (state_25959[(2)]);
var state_25959__$1 = (function (){var statearr_26014 = state_25959;
(statearr_26014[(28)] = inst_25932);

return statearr_26014;
})();
if(cljs.core.truth_(inst_25701)){
var statearr_26015_26202 = state_25959__$1;
(statearr_26015_26202[(1)] = (122));

} else {
var statearr_26016_26203 = state_25959__$1;
(statearr_26016_26203[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (40))){
var inst_25655 = (state_25959[(18)]);
var inst_25717 = (state_25959[(2)]);
var state_25959__$1 = (function (){var statearr_26017 = state_25959;
(statearr_26017[(29)] = inst_25717);

return statearr_26017;
})();
if(cljs.core.truth_(inst_25655)){
var statearr_26018_26204 = state_25959__$1;
(statearr_26018_26204[(1)] = (41));

} else {
var statearr_26019_26205 = state_25959__$1;
(statearr_26019_26205[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (129))){
var inst_25940 = (state_25959[(30)]);
var state_25959__$1 = state_25959;
var statearr_26020_26206 = state_25959__$1;
(statearr_26020_26206[(2)] = inst_25940);

(statearr_26020_26206[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (91))){
var inst_25843 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_25959__$1 = state_25959;
var statearr_26021_26207 = state_25959__$1;
(statearr_26021_26207[(2)] = inst_25843);

(statearr_26021_26207[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (117))){
var inst_25658 = (state_25959[(15)]);
var state_25959__$1 = state_25959;
var statearr_26022_26208 = state_25959__$1;
(statearr_26022_26208[(2)] = inst_25658);

(statearr_26022_26208[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (108))){
var inst_25882 = (state_25959[(2)]);
var inst_25883 = fluree.db.util.async.throw_err(inst_25882);
var state_25959__$1 = state_25959;
var statearr_26023_26209 = state_25959__$1;
(statearr_26023_26209[(2)] = inst_25883);

(statearr_26023_26209[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (56))){
var inst_25750 = cljs.core.PersistentHashMap.EMPTY;
var state_25959__$1 = state_25959;
var statearr_26024_26210 = state_25959__$1;
(statearr_26024_26210[(2)] = inst_25750);

(statearr_26024_26210[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (33))){
var state_25959__$1 = state_25959;
var statearr_26025_26211 = state_25959__$1;
(statearr_26025_26211[(2)] = from);

(statearr_26025_26211[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (13))){
var inst_25642 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25643 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25644 = cljs.core.PersistentHashMap.fromArrays(inst_25642,inst_25643);
var inst_25645 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_25644);
var inst_25646 = (function(){throw inst_25645})();
var state_25959__$1 = state_25959;
var statearr_26026_26212 = state_25959__$1;
(statearr_26026_26212[(2)] = inst_25646);

(statearr_26026_26212[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (22))){
var inst_25655 = (state_25959[(18)]);
var inst_25678 = typeof inst_25655 === 'string';
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25678)){
var statearr_26027_26213 = state_25959__$1;
(statearr_26027_26213[(1)] = (24));

} else {
var statearr_26028_26214 = state_25959__$1;
(statearr_26028_26214[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (90))){
var inst_25834 = (state_25959[(31)]);
var inst_25839 = (state_25959[(2)]);
var state_25959__$1 = (function (){var statearr_26029 = state_25959;
(statearr_26029[(32)] = inst_25839);

return statearr_26029;
})();
var statearr_26030_26215 = state_25959__$1;
(statearr_26030_26215[(2)] = inst_25834);

(statearr_26030_26215[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (109))){
var inst_25885 = (state_25959[(23)]);
var inst_25861 = (state_25959[(10)]);
var inst_25887 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25861,inst_25885);
var state_25959__$1 = state_25959;
var statearr_26031_26216 = state_25959__$1;
(statearr_26031_26216[(2)] = inst_25887);

(statearr_26031_26216[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (36))){
var inst_25655 = (state_25959[(18)]);
var inst_25712 = (state_25959[(2)]);
var inst_25713 = fluree.db.util.async.throw_err(inst_25712);
var state_25959__$1 = (function (){var statearr_26032 = state_25959;
(statearr_26032[(33)] = inst_25713);

return statearr_26032;
})();
if(cljs.core.truth_(inst_25655)){
var statearr_26033_26217 = state_25959__$1;
(statearr_26033_26217[(1)] = (38));

} else {
var statearr_26034_26218 = state_25959__$1;
(statearr_26034_26218[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (41))){
var state_25959__$1 = state_25959;
var statearr_26035_26219 = state_25959__$1;
(statearr_26035_26219[(2)] = null);

(statearr_26035_26219[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (118))){
var inst_25897 = (state_25959[(34)]);
var inst_25668 = (state_25959[(7)]);
var inst_25901 = (state_25959[(35)]);
var inst_25666 = (state_25959[(8)]);
var inst_25905 = (state_25959[(2)]);
var inst_25906 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25668,fuel,max_fuel,inst_25666,inst_25897,inst_25901,inst_25905);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(112),inst_25906);
} else {
if((state_val_25960 === (89))){
var state_25959__$1 = state_25959;
var statearr_26036_26220 = state_25959__$1;
(statearr_26036_26220[(2)] = null);

(statearr_26036_26220[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (100))){
var inst_25867 = (state_25959[(19)]);
var inst_25872 = cljs.core.int_QMARK_(inst_25867);
var state_25959__$1 = state_25959;
if(inst_25872){
var statearr_26037_26221 = state_25959__$1;
(statearr_26037_26221[(1)] = (102));

} else {
var statearr_26038_26222 = state_25959__$1;
(statearr_26038_26222[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (131))){
var inst_25937 = (state_25959[(11)]);
var inst_25951 = cljs.core.first(inst_25937);
var state_25959__$1 = state_25959;
var statearr_26039_26223 = state_25959__$1;
(statearr_26039_26223[(2)] = inst_25951);

(statearr_26039_26223[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (122))){
var inst_25932 = (state_25959[(28)]);
var inst_25701 = (state_25959[(16)]);
var inst_25658 = (state_25959[(15)]);
var inst_25702 = (state_25959[(17)]);
var inst_25656 = (state_25959[(14)]);
var inst_25934 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25701,inst_25702,inst_25658,inst_25656,inst_25932);
var state_25959__$1 = state_25959;
var statearr_26040_26224 = state_25959__$1;
(statearr_26040_26224[(2)] = inst_25934);

(statearr_26040_26224[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (43))){
var inst_25713 = (state_25959[(33)]);
var inst_25668 = (state_25959[(7)]);
var inst_25717 = (state_25959[(29)]);
var inst_25666 = (state_25959[(8)]);
var inst_25721 = (state_25959[(2)]);
var inst_25722 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25668,fuel,max_fuel,inst_25666,inst_25713,inst_25717,inst_25721);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(37),inst_25722);
} else {
if((state_val_25960 === (61))){
var inst_25772 = ["_tx",null,"_block",null];
var inst_25773 = (new cljs.core.PersistentArrayMap(null,2,inst_25772,null));
var inst_25774 = (new cljs.core.PersistentHashSet(null,inst_25773,null));
var inst_25775 = (inst_25774.cljs$core$IFn$_invoke$arity$1 ? inst_25774.cljs$core$IFn$_invoke$arity$1(from) : inst_25774.call(null,from));
var state_25959__$1 = state_25959;
var statearr_26041_26225 = state_25959__$1;
(statearr_26041_26225[(2)] = inst_25775);

(statearr_26041_26225[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (29))){
var inst_25690 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26042_26226 = state_25959__$1;
(statearr_26042_26226[(2)] = inst_25690);

(statearr_26042_26226[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (44))){
var inst_25729 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25730 = clojure.string.includes_QMARK_(inst_25729,"/");
var state_25959__$1 = state_25959;
var statearr_26043_26227 = state_25959__$1;
(statearr_26043_26227[(2)] = inst_25730);

(statearr_26043_26227[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (93))){
var inst_25846 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25846)){
var statearr_26044_26228 = state_25959__$1;
(statearr_26044_26228[(1)] = (94));

} else {
var statearr_26045_26229 = state_25959__$1;
(statearr_26045_26229[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (6))){
var inst_25633 = (state_25959[(36)]);
var state_25959__$1 = state_25959;
var statearr_26046_26230 = state_25959__$1;
(statearr_26046_26230[(2)] = inst_25633);

(statearr_26046_26230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (111))){
var inst_25868 = (state_25959[(37)]);
var inst_25890 = (state_25959[(2)]);
var inst_25860 = inst_25868;
var inst_25861 = inst_25890;
var state_25959__$1 = (function (){var statearr_26047 = state_25959;
(statearr_26047[(38)] = inst_25860);

(statearr_26047[(10)] = inst_25861);

return statearr_26047;
})();
var statearr_26048_26231 = state_25959__$1;
(statearr_26048_26231[(2)] = null);

(statearr_26048_26231[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (28))){
var state_25959__$1 = state_25959;
var statearr_26049_26232 = state_25959__$1;
(statearr_26049_26232[(2)] = null);

(statearr_26049_26232[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (64))){
var inst_25655 = (state_25959[(18)]);
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25655)){
var statearr_26050_26233 = state_25959__$1;
(statearr_26050_26233[(1)] = (67));

} else {
var statearr_26051_26234 = state_25959__$1;
(statearr_26051_26234[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (103))){
var state_25959__$1 = state_25959;
if(cljs.core.truth_(fuel)){
var statearr_26052_26235 = state_25959__$1;
(statearr_26052_26235[(1)] = (105));

} else {
var statearr_26053_26236 = state_25959__$1;
(statearr_26053_26236[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (51))){
var inst_25736 = (state_25959[(26)]);
var state_25959__$1 = state_25959;
var statearr_26054_26237 = state_25959__$1;
(statearr_26054_26237[(2)] = inst_25736);

(statearr_26054_26237[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (25))){
var state_25959__$1 = state_25959;
var statearr_26055_26238 = state_25959__$1;
(statearr_26055_26238[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (34))){
var state_25959__$1 = state_25959;
var statearr_26057_26239 = state_25959__$1;
(statearr_26057_26239[(2)] = null);

(statearr_26057_26239[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (125))){
var inst_25937 = (state_25959[(11)]);
var inst_25940 = (state_25959[(30)]);
var inst_25940__$1 = cljs.core.coll_QMARK_(inst_25937);
var state_25959__$1 = (function (){var statearr_26058 = state_25959;
(statearr_26058[(30)] = inst_25940__$1);

return statearr_26058;
})();
if(inst_25940__$1){
var statearr_26059_26240 = state_25959__$1;
(statearr_26059_26240[(1)] = (128));

} else {
var statearr_26060_26241 = state_25959__$1;
(statearr_26060_26241[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (17))){
var inst_25655 = (state_25959[(18)]);
var inst_25666 = (state_25959[(2)]);
var inst_25667 = cljs.core.PersistentHashMap.EMPTY;
var inst_25668 = cljs.core.volatile_BANG_(inst_25667);
var state_25959__$1 = (function (){var statearr_26061 = state_25959;
(statearr_26061[(7)] = inst_25668);

(statearr_26061[(8)] = inst_25666);

return statearr_26061;
})();
if(cljs.core.truth_(inst_25655)){
var statearr_26062_26242 = state_25959__$1;
(statearr_26062_26242[(1)] = (18));

} else {
var statearr_26063_26243 = state_25959__$1;
(statearr_26063_26243[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (3))){
var inst_25957 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25959__$1,inst_25957);
} else {
if((state_val_25960 === (12))){
var inst_25639 = (state_25959[(39)]);
var state_25959__$1 = state_25959;
var statearr_26064_26244 = state_25959__$1;
(statearr_26064_26244[(2)] = inst_25639);

(statearr_26064_26244[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (2))){
var inst_25633 = (state_25959[(36)]);
var _ = (function (){var statearr_26065 = state_25959;
(statearr_26065[(4)] = cljs.core.cons((5),(state_25959[(4)])));

return statearr_26065;
})();
var inst_25633__$1 = select;
var state_25959__$1 = (function (){var statearr_26066 = state_25959;
(statearr_26066[(36)] = inst_25633__$1);

return statearr_26066;
})();
if(cljs.core.truth_(inst_25633__$1)){
var statearr_26067_26245 = state_25959__$1;
(statearr_26067_26245[(1)] = (6));

} else {
var statearr_26068_26246 = state_25959__$1;
(statearr_26068_26246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (66))){
var inst_25928 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26069_26247 = state_25959__$1;
(statearr_26069_26247[(2)] = inst_25928);

(statearr_26069_26247[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (107))){
var inst_25867 = (state_25959[(19)]);
var inst_25879 = (state_25959[(2)]);
var inst_25880 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_25867,false);
var state_25959__$1 = (function (){var statearr_26070 = state_25959;
(statearr_26070[(40)] = inst_25879);

return statearr_26070;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(108),inst_25880);
} else {
if((state_val_25960 === (23))){
var inst_25694 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26071_26248 = state_25959__$1;
(statearr_26071_26248[(2)] = inst_25694);

(statearr_26071_26248[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (47))){
var inst_25736 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_25959__$1 = (function (){var statearr_26072 = state_25959;
(statearr_26072[(26)] = inst_25736);

return statearr_26072;
})();
if(cljs.core.truth_(fuel)){
var statearr_26073_26249 = state_25959__$1;
(statearr_26073_26249[(1)] = (50));

} else {
var statearr_26074_26250 = state_25959__$1;
(statearr_26074_26250[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (35))){
var inst_25709 = (state_25959[(2)]);
var inst_25710 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_25709);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(36),inst_25710);
} else {
if((state_val_25960 === (127))){
var inst_25949 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25949)){
var statearr_26075_26251 = state_25959__$1;
(statearr_26075_26251[(1)] = (131));

} else {
var statearr_26076_26252 = state_25959__$1;
(statearr_26076_26252[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (82))){
var inst_25924 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26077_26253 = state_25959__$1;
(statearr_26077_26253[(2)] = inst_25924);

(statearr_26077_26253[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (76))){
var inst_25658 = (state_25959[(15)]);
var inst_25656 = (state_25959[(14)]);
var inst_25802 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25803 = [inst_25656,inst_25658];
var inst_25804 = cljs.core.PersistentHashMap.fromArrays(inst_25802,inst_25803);
var state_25959__$1 = state_25959;
var statearr_26078_26254 = state_25959__$1;
(statearr_26078_26254[(2)] = inst_25804);

(statearr_26078_26254[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (97))){
var inst_25867 = (state_25959[(19)]);
var inst_25860 = (state_25959[(38)]);
var inst_25866 = cljs.core.seq(inst_25860);
var inst_25867__$1 = cljs.core.first(inst_25866);
var inst_25868 = cljs.core.next(inst_25866);
var inst_25869 = cljs.core.not(inst_25867__$1);
var state_25959__$1 = (function (){var statearr_26079 = state_25959;
(statearr_26079[(37)] = inst_25868);

(statearr_26079[(19)] = inst_25867__$1);

return statearr_26079;
})();
if(inst_25869){
var statearr_26080_26255 = state_25959__$1;
(statearr_26080_26255[(1)] = (99));

} else {
var statearr_26081_26256 = state_25959__$1;
(statearr_26081_26256[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (19))){
var inst_25696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25697 = [null,null];
var inst_25698 = (new cljs.core.PersistentVector(null,2,(5),inst_25696,inst_25697,null));
var state_25959__$1 = state_25959;
var statearr_26082_26257 = state_25959__$1;
(statearr_26082_26257[(2)] = inst_25698);

(statearr_26082_26257[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (57))){
var inst_25658 = (state_25959[(15)]);
var inst_25656 = (state_25959[(14)]);
var inst_25752 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25753 = [inst_25656,inst_25658];
var inst_25754 = cljs.core.PersistentHashMap.fromArrays(inst_25752,inst_25753);
var state_25959__$1 = state_25959;
var statearr_26083_26258 = state_25959__$1;
(statearr_26083_26258[(2)] = inst_25754);

(statearr_26083_26258[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (68))){
var inst_25658 = (state_25959[(15)]);
var inst_25656 = (state_25959[(14)]);
var inst_25783 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25784 = [inst_25656,inst_25658];
var inst_25785 = cljs.core.PersistentHashMap.fromArrays(inst_25783,inst_25784);
var state_25959__$1 = state_25959;
var statearr_26084_26259 = state_25959__$1;
(statearr_26084_26259[(2)] = inst_25785);

(statearr_26084_26259[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (11))){
var inst_25650 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26085_26260 = state_25959__$1;
(statearr_26085_26260[(2)] = inst_25650);

(statearr_26085_26260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (115))){
var inst_25655 = (state_25959[(18)]);
var inst_25901 = (state_25959[(2)]);
var state_25959__$1 = (function (){var statearr_26087 = state_25959;
(statearr_26087[(35)] = inst_25901);

return statearr_26087;
})();
if(cljs.core.truth_(inst_25655)){
var statearr_26088_26261 = state_25959__$1;
(statearr_26088_26261[(1)] = (116));

} else {
var statearr_26089_26262 = state_25959__$1;
(statearr_26089_26262[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (9))){
var inst_25636 = (state_25959[(12)]);
var state_25959__$1 = state_25959;
var statearr_26090_26263 = state_25959__$1;
(statearr_26090_26263[(2)] = inst_25636);

(statearr_26090_26263[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (5))){
var _ = (function (){var statearr_26091 = state_25959;
(statearr_26091[(4)] = cljs.core.rest((state_25959[(4)])));

return statearr_26091;
})();
var state_25959__$1 = state_25959;
var ex26086 = (state_25959__$1[(2)]);
var statearr_26092_26264 = state_25959__$1;
(statearr_26092_26264[(5)] = ex26086);


if((ex26086 instanceof Error)){
var statearr_26093_26265 = state_25959__$1;
(statearr_26093_26265[(1)] = (4));

(statearr_26093_26265[(5)] = null);

} else {
throw ex26086;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (112))){
var inst_25908 = (state_25959[(2)]);
var inst_25909 = fluree.db.util.async.throw_err(inst_25908);
var state_25959__$1 = state_25959;
var statearr_26094_26266 = state_25959__$1;
(statearr_26094_26266[(2)] = inst_25909);

(statearr_26094_26266[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (83))){
var inst_25822 = (state_25959[(20)]);
var inst_25821 = (state_25959[(2)]);
var inst_25822__$1 = fluree.db.util.async.throw_err(inst_25821);
var inst_25823 = (inst_25822__$1 == null);
var state_25959__$1 = (function (){var statearr_26095 = state_25959;
(statearr_26095[(20)] = inst_25822__$1);

return statearr_26095;
})();
if(cljs.core.truth_(inst_25823)){
var statearr_26096_26267 = state_25959__$1;
(statearr_26096_26267[(1)] = (84));

} else {
var statearr_26097_26268 = state_25959__$1;
(statearr_26097_26268[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (14))){
var inst_25648 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26098_26269 = state_25959__$1;
(statearr_26098_26269[(2)] = inst_25648);

(statearr_26098_26269[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (45))){
var inst_25727 = (state_25959[(27)]);
var state_25959__$1 = state_25959;
var statearr_26099_26270 = state_25959__$1;
(statearr_26099_26270[(2)] = inst_25727);

(statearr_26099_26270[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (53))){
var inst_25742 = (state_25959[(21)]);
var inst_25744 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25745 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25742,inst_25744);
var state_25959__$1 = state_25959;
var statearr_26100_26271 = state_25959__$1;
(statearr_26100_26271[(2)] = inst_25745);

(statearr_26100_26271[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (78))){
var inst_25668 = (state_25959[(7)]);
var inst_25666 = (state_25959[(8)]);
var inst_25809 = (state_25959[(2)]);
var inst_25810 = fluree.db.util.async.throw_err(inst_25809);
var inst_25811 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25668,fuel,max_fuel,inst_25666,inst_25810);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(79),inst_25811);
} else {
if((state_val_25960 === (132))){
var inst_25937 = (state_25959[(11)]);
var state_25959__$1 = state_25959;
var statearr_26101_26272 = state_25959__$1;
(statearr_26101_26272[(2)] = inst_25937);

(statearr_26101_26272[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (26))){
var inst_25692 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26102_26273 = state_25959__$1;
(statearr_26102_26273[(2)] = inst_25692);

(statearr_26102_26273[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (123))){
var inst_25932 = (state_25959[(28)]);
var state_25959__$1 = state_25959;
var statearr_26103_26274 = state_25959__$1;
(statearr_26103_26274[(2)] = inst_25932);

(statearr_26103_26274[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (16))){
var inst_25659 = (state_25959[(25)]);
var state_25959__$1 = state_25959;
var statearr_26104_26275 = state_25959__$1;
(statearr_26104_26275[(2)] = inst_25659);

(statearr_26104_26275[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (133))){
var inst_25954 = (state_25959[(2)]);
var _ = (function (){var statearr_26105 = state_25959;
(statearr_26105[(4)] = cljs.core.rest((state_25959[(4)])));

return statearr_26105;
})();
var state_25959__$1 = state_25959;
var statearr_26106_26276 = state_25959__$1;
(statearr_26106_26276[(2)] = inst_25954);

(statearr_26106_26276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (81))){
var inst_25841 = (state_25959[(22)]);
var inst_25841__$1 = cljs.core.sequential_QMARK_(from);
var state_25959__$1 = (function (){var statearr_26107 = state_25959;
(statearr_26107[(22)] = inst_25841__$1);

return statearr_26107;
})();
if(inst_25841__$1){
var statearr_26108_26277 = state_25959__$1;
(statearr_26108_26277[(1)] = (91));

} else {
var statearr_26109_26278 = state_25959__$1;
(statearr_26109_26278[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (120))){
var state_25959__$1 = state_25959;
var statearr_26110_26279 = state_25959__$1;
(statearr_26110_26279[(2)] = null);

(statearr_26110_26279[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (79))){
var inst_25813 = (state_25959[(2)]);
var inst_25814 = fluree.db.util.async.throw_err(inst_25813);
var state_25959__$1 = state_25959;
var statearr_26111_26280 = state_25959__$1;
(statearr_26111_26280[(2)] = inst_25814);

(statearr_26111_26280[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (38))){
var state_25959__$1 = state_25959;
var statearr_26112_26281 = state_25959__$1;
(statearr_26112_26281[(2)] = null);

(statearr_26112_26281[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (126))){
var inst_25938 = (state_25959[(41)]);
var state_25959__$1 = state_25959;
var statearr_26113_26282 = state_25959__$1;
(statearr_26113_26282[(2)] = inst_25938);

(statearr_26113_26282[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (98))){
var inst_25655 = (state_25959[(18)]);
var inst_25895 = (state_25959[(2)]);
var inst_25896 = cljs.core.PersistentVector.EMPTY;
var inst_25897 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25896,inst_25895);
var state_25959__$1 = (function (){var statearr_26114 = state_25959;
(statearr_26114[(34)] = inst_25897);

return statearr_26114;
})();
if(cljs.core.truth_(inst_25655)){
var statearr_26115_26283 = state_25959__$1;
(statearr_26115_26283[(1)] = (113));

} else {
var statearr_26116_26284 = state_25959__$1;
(statearr_26116_26284[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (124))){
var inst_25938 = (state_25959[(41)]);
var inst_25937 = (state_25959[(2)]);
var inst_25938__$1 = selectOne;
var state_25959__$1 = (function (){var statearr_26117 = state_25959;
(statearr_26117[(11)] = inst_25937);

(statearr_26117[(41)] = inst_25938__$1);

return statearr_26117;
})();
if(cljs.core.truth_(inst_25938__$1)){
var statearr_26118_26285 = state_25959__$1;
(statearr_26118_26285[(1)] = (125));

} else {
var statearr_26119_26286 = state_25959__$1;
(statearr_26119_26286[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (87))){
var inst_25833 = (state_25959[(2)]);
var inst_25834 = fluree.db.util.async.throw_err(inst_25833);
var state_25959__$1 = (function (){var statearr_26120 = state_25959;
(statearr_26120[(31)] = inst_25834);

return statearr_26120;
})();
if(cljs.core.truth_(fuel)){
var statearr_26121_26287 = state_25959__$1;
(statearr_26121_26287[(1)] = (88));

} else {
var statearr_26122_26288 = state_25959__$1;
(statearr_26122_26288[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (30))){
var inst_25705 = typeof from === 'string';
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25705)){
var statearr_26123_26289 = state_25959__$1;
(statearr_26123_26289[(1)] = (33));

} else {
var statearr_26124_26290 = state_25959__$1;
(statearr_26124_26290[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (73))){
var inst_25816 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_25959__$1 = state_25959;
if(inst_25816){
var statearr_26125_26291 = state_25959__$1;
(statearr_26125_26291[(1)] = (80));

} else {
var statearr_26126_26292 = state_25959__$1;
(statearr_26126_26292[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (96))){
var inst_25922 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26127_26293 = state_25959__$1;
(statearr_26127_26293[(2)] = inst_25922);

(statearr_26127_26293[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (10))){
var inst_25639 = (state_25959[(39)]);
var inst_25639__$1 = selectDistinct;
var state_25959__$1 = (function (){var statearr_26128 = state_25959;
(statearr_26128[(39)] = inst_25639__$1);

return statearr_26128;
})();
if(cljs.core.truth_(inst_25639__$1)){
var statearr_26129_26294 = state_25959__$1;
(statearr_26129_26294[(1)] = (12));

} else {
var statearr_26130_26295 = state_25959__$1;
(statearr_26130_26295[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (18))){
var inst_25655 = (state_25959[(18)]);
var inst_25670 = cljs.core.vector_QMARK_(inst_25655);
var state_25959__$1 = state_25959;
if(inst_25670){
var statearr_26131_26296 = state_25959__$1;
(statearr_26131_26296[(1)] = (21));

} else {
var statearr_26132_26297 = state_25959__$1;
(statearr_26132_26297[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (105))){
var inst_25876 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_25959__$1 = state_25959;
var statearr_26133_26298 = state_25959__$1;
(statearr_26133_26298[(2)] = inst_25876);

(statearr_26133_26298[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (52))){
var inst_25742 = (state_25959[(2)]);
var state_25959__$1 = (function (){var statearr_26134 = state_25959;
(statearr_26134[(21)] = inst_25742);

return statearr_26134;
})();
var statearr_26135_26299 = state_25959__$1;
(statearr_26135_26299[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (114))){
var inst_25656 = (state_25959[(14)]);
var state_25959__$1 = state_25959;
var statearr_26137_26300 = state_25959__$1;
(statearr_26137_26300[(2)] = inst_25656);

(statearr_26137_26300[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (67))){
var inst_25781 = cljs.core.PersistentHashMap.EMPTY;
var state_25959__$1 = state_25959;
var statearr_26138_26301 = state_25959__$1;
(statearr_26138_26301[(2)] = inst_25781);

(statearr_26138_26301[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (71))){
var inst_25794 = (state_25959[(2)]);
var inst_25795 = fluree.db.util.async.throw_err(inst_25794);
var state_25959__$1 = state_25959;
var statearr_26139_26302 = state_25959__$1;
(statearr_26139_26302[(2)] = inst_25795);

(statearr_26139_26302[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (42))){
var inst_25658 = (state_25959[(15)]);
var state_25959__$1 = state_25959;
var statearr_26140_26303 = state_25959__$1;
(statearr_26140_26303[(2)] = inst_25658);

(statearr_26140_26303[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (80))){
var inst_25819 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_25959__$1 = state_25959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25959__$1,(83),inst_25819);
} else {
if((state_val_25960 === (37))){
var inst_25724 = (state_25959[(2)]);
var inst_25725 = fluree.db.util.async.throw_err(inst_25724);
var state_25959__$1 = state_25959;
var statearr_26141_26304 = state_25959__$1;
(statearr_26141_26304[(2)] = inst_25725);

(statearr_26141_26304[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (63))){
var inst_25778 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
if(cljs.core.truth_(inst_25778)){
var statearr_26142_26305 = state_25959__$1;
(statearr_26142_26305[(1)] = (64));

} else {
var statearr_26143_26306 = state_25959__$1;
(statearr_26143_26306[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (94))){
var inst_25855 = from;
var inst_25856 = cljs.core.seq(inst_25855);
var inst_25857 = cljs.core.first(inst_25856);
var inst_25858 = cljs.core.next(inst_25856);
var inst_25859 = cljs.core.PersistentVector.EMPTY;
var inst_25860 = inst_25855;
var inst_25861 = inst_25859;
var state_25959__$1 = (function (){var statearr_26144 = state_25959;
(statearr_26144[(42)] = inst_25858);

(statearr_26144[(43)] = inst_25857);

(statearr_26144[(38)] = inst_25860);

(statearr_26144[(10)] = inst_25861);

return statearr_26144;
})();
var statearr_26145_26307 = state_25959__$1;
(statearr_26145_26307[(2)] = null);

(statearr_26145_26307[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (8))){
var inst_25657 = (state_25959[(24)]);
var inst_25652 = (state_25959[(2)]);
var inst_25653 = opts_SINGLEQUOTE_;
var inst_25654 = cljs.core.__destructure_map(inst_25653);
var inst_25655 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25654,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25656 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25654,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25657__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25654,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25654,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25659 = fluree.db.query.fql_parser.parse_db(db,inst_25652,opts_SINGLEQUOTE_);
var inst_25660 = (inst_25657__$1 == null);
var inst_25661 = cljs.core.not(inst_25660);
var state_25959__$1 = (function (){var statearr_26146 = state_25959;
(statearr_26146[(15)] = inst_25658);

(statearr_26146[(24)] = inst_25657__$1);

(statearr_26146[(18)] = inst_25655);

(statearr_26146[(25)] = inst_25659);

(statearr_26146[(14)] = inst_25656);

return statearr_26146;
})();
if(inst_25661){
var statearr_26147_26308 = state_25959__$1;
(statearr_26147_26308[(1)] = (15));

} else {
var statearr_26148_26309 = state_25959__$1;
(statearr_26148_26309[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (49))){
var inst_25930 = (state_25959[(2)]);
var state_25959__$1 = state_25959;
var statearr_26149_26310 = state_25959__$1;
(statearr_26149_26310[(2)] = inst_25930);

(statearr_26149_26310[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25960 === (84))){
var state_25959__$1 = state_25959;
var statearr_26150_26311 = state_25959__$1;
(statearr_26150_26311[(2)] = null);

(statearr_26150_26311[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2733__auto____0 = (function (){
var statearr_26151 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26151[(0)] = fluree$db$query$fql$query_$_state_machine__2733__auto__);

(statearr_26151[(1)] = (1));

return statearr_26151;
});
var fluree$db$query$fql$query_$_state_machine__2733__auto____1 = (function (state_25959){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_25959);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26152){var ex__2736__auto__ = e26152;
var statearr_26153_26312 = state_25959;
(statearr_26153_26312[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_25959[(4)]))){
var statearr_26154_26313 = state_25959;
(statearr_26154_26313[(1)] = cljs.core.first((state_25959[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26314 = state_25959;
state_25959 = G__26314;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2733__auto__ = function(state_25959){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2733__auto____1.call(this,state_25959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2733__auto____0;
fluree$db$query$fql$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2733__auto____1;
return fluree$db$query$fql$query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26155 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26155[(6)] = c__2755__auto__);

return statearr_26155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}

});
