// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13765 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13765,(5),null);
var G__13768 = idx;
var G__13768__$1 = (((G__13768 instanceof cljs.core.Keyword))?G__13768.fqn:null);
switch (G__13768__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13768__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13770 = idx;
var G__13770__$1 = (((G__13770 instanceof cljs.core.Keyword))?G__13770.fqn:null);
switch (G__13770__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13770__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13772 = idx;
var G__13772__$1 = (((G__13772 instanceof cljs.core.Keyword))?G__13772.fqn:null);
switch (G__13772__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13772__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13775 = arguments.length;
switch (G__13775) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13776 = (function (){var pred__13779 = cljs.core.identical_QMARK_;
var expr__13780 = test;
if(cljs.core.truth_((pred__13779.cljs$core$IFn$_invoke$arity$2 ? pred__13779.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13780) : pred__13779.call(null,cljs.core._EQ_,expr__13780)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13779.cljs$core$IFn$_invoke$arity$2 ? pred__13779.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13780) : pred__13779.call(null,cljs.core._LT_,expr__13780)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13779.cljs$core$IFn$_invoke$arity$2 ? pred__13779.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13780) : pred__13779.call(null,cljs.core._LT__EQ_,expr__13780)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13779.cljs$core$IFn$_invoke$arity$2 ? pred__13779.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13780) : pred__13779.call(null,cljs.core._GT_,expr__13780)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13779.cljs$core$IFn$_invoke$arity$2 ? pred__13779.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13780) : pred__13779.call(null,cljs.core._GT__EQ_,expr__13780)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13780)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13776,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13776,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13776,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13776,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_14019){
var state_val_14020 = (state_14019[(1)]);
if((state_val_14020 === (65))){
var inst_13990 = (state_14019[(7)]);
var inst_13934 = (state_14019[(8)]);
var inst_13990__$1 = (state_14019[(2)]);
var inst_13991 = cljs.core.count(inst_13990__$1);
var state_14019__$1 = (function (){var statearr_14021 = state_14019;
(statearr_14021[(7)] = inst_13990__$1);

(statearr_14021[(9)] = inst_13991);

return statearr_14021;
})();
if(cljs.core.truth_(inst_13934)){
var statearr_14022_14159 = state_14019__$1;
(statearr_14022_14159[(1)] = (81));

} else {
var statearr_14023_14160 = state_14019__$1;
(statearr_14023_14160[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (70))){
var inst_13965 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
if(cljs.core.truth_(inst_13965)){
var statearr_14024_14161 = state_14019__$1;
(statearr_14024_14161[(1)] = (71));

} else {
var statearr_14025_14162 = state_14019__$1;
(statearr_14025_14162[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (62))){
var inst_13904 = (state_14019[(10)]);
var inst_13918 = (state_14019[(11)]);
var inst_13933 = (state_14019[(2)]);
var inst_13934 = fluree.db.dbproto._rhs(inst_13918);
var state_14019__$1 = (function (){var statearr_14026 = state_14019;
(statearr_14026[(8)] = inst_13934);

(statearr_14026[(12)] = inst_13933);

return statearr_14026;
})();
if(cljs.core.truth_(inst_13904)){
var statearr_14027_14163 = state_14019__$1;
(statearr_14027_14163[(1)] = (63));

} else {
var statearr_14028_14164 = state_14019__$1;
(statearr_14028_14164[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (74))){
var inst_13958 = (state_14019[(13)]);
var inst_13972 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_13958);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(77),inst_13972);
} else {
if((state_val_14020 === (7))){
var inst_13795 = (state_14019[(14)]);
var state_14019__$1 = state_14019;
var statearr_14029_14165 = state_14019__$1;
(statearr_14029_14165[(2)] = inst_13795);

(statearr_14029_14165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (59))){
var inst_13880 = (state_14019[(15)]);
var inst_13881 = (state_14019[(16)]);
var inst_13925 = (state_14019[(17)]);
var inst_13924 = (state_14019[(2)]);
var inst_13925__$1 = fluree.db.util.async.throw_err(inst_13924);
var inst_13926 = fluree.db.flake.subrange(inst_13925__$1,start_test,inst_13880,end_test,inst_13881);
var inst_13927 = fluree.db.query.range.value_with_nil_pred(idx,inst_13880,inst_13881);
var state_14019__$1 = (function (){var statearr_14030 = state_14019;
(statearr_14030[(18)] = inst_13926);

(statearr_14030[(17)] = inst_13925__$1);

return statearr_14030;
})();
if(inst_13927){
var statearr_14031_14166 = state_14019__$1;
(statearr_14031_14166[(1)] = (60));

} else {
var statearr_14032_14167 = state_14019__$1;
(statearr_14032_14167[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (86))){
var inst_13999 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14033_14168 = state_14019__$1;
(statearr_14033_14168[(2)] = inst_13999);

(statearr_14033_14168[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (20))){
var inst_13844 = (state_14019[(19)]);
var inst_13796 = (state_14019[(20)]);
var inst_13843 = (state_14019[(2)]);
var inst_13844__$1 = (inst_13796 == null);
var state_14019__$1 = (function (){var statearr_14034 = state_14019;
(statearr_14034[(19)] = inst_13844__$1);

(statearr_14034[(21)] = inst_13843);

return statearr_14034;
})();
if(cljs.core.truth_(inst_13844__$1)){
var statearr_14035_14169 = state_14019__$1;
(statearr_14035_14169[(1)] = (22));

} else {
var statearr_14036_14170 = state_14019__$1;
(statearr_14036_14170[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (72))){
var inst_13951 = (state_14019[(22)]);
var inst_13969 = (inst_13951 + (1));
var inst_13970 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14019__$1 = (function (){var statearr_14037 = state_14019;
(statearr_14037[(23)] = inst_13969);

return statearr_14037;
})();
if(cljs.core.truth_(inst_13970)){
var statearr_14038_14171 = state_14019__$1;
(statearr_14038_14171[(1)] = (74));

} else {
var statearr_14039_14172 = state_14019__$1;
(statearr_14039_14172[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (58))){
var inst_14014 = (state_14019[(2)]);
var _ = (function (){var statearr_14040 = state_14019;
(statearr_14040[(4)] = cljs.core.rest((state_14019[(4)])));

return statearr_14040;
})();
var state_14019__$1 = state_14019;
var statearr_14041_14173 = state_14019__$1;
(statearr_14041_14173[(2)] = inst_14014);

(statearr_14041_14173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (60))){
var inst_13805 = (state_14019[(24)]);
var inst_13801 = (state_14019[(25)]);
var inst_13794 = (state_14019[(26)]);
var inst_13880 = (state_14019[(15)]);
var inst_13904 = (state_14019[(10)]);
var inst_13926 = (state_14019[(18)]);
var inst_13887 = (state_14019[(27)]);
var inst_13834 = (state_14019[(28)]);
var inst_13798 = (state_14019[(29)]);
var inst_13919 = (state_14019[(30)]);
var inst_13879 = (state_14019[(31)]);
var inst_13799 = (state_14019[(32)]);
var inst_13825 = (state_14019[(33)]);
var inst_13897 = (state_14019[(34)]);
var inst_13881 = (state_14019[(16)]);
var inst_13886 = (state_14019[(35)]);
var inst_13891 = (state_14019[(36)]);
var inst_13852 = (state_14019[(37)]);
var inst_13918 = (state_14019[(11)]);
var inst_13908 = (state_14019[(38)]);
var inst_13816 = (state_14019[(39)]);
var inst_13861 = (state_14019[(40)]);
var inst_13925 = (state_14019[(17)]);
var inst_13913 = (state_14019[(41)]);
var inst_13870 = (state_14019[(42)]);
var inst_13898 = (state_14019[(43)]);
var inst_13806 = (state_14019[(44)]);
var inst_13920 = (state_14019[(45)]);
var inst_13843 = (state_14019[(21)]);
var inst_13929 = (function (){var no_filter_QMARK_ = inst_13904;
var next_node = inst_13918;
var flakes = inst_13925;
var s1 = inst_13816;
var o2 = inst_13843;
var t1 = inst_13798;
var i = inst_13919;
var m1 = inst_13870;
var root_node = inst_13913;
var to_t = inst_13898;
var s2 = inst_13825;
var p2 = inst_13861;
var permissions = inst_13887;
var limit = inst_13886;
var start_flake = inst_13880;
var acc = inst_13920;
var t2 = inst_13805;
var op1 = inst_13799;
var o1 = inst_13834;
var end_flake = inst_13881;
var base_result = inst_13926;
var p1 = inst_13852;
var vec__13788 = inst_13794;
var vec__13791 = inst_13801;
var idx_compare = inst_13891;
var op2 = inst_13806;
var from_t = inst_13897;
var m2 = inst_13879;
var novelty = inst_13908;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_13930 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_13929,inst_13926,inst_13926);
var state_14019__$1 = state_14019;
var statearr_14042_14174 = state_14019__$1;
(statearr_14042_14174[(2)] = inst_13930);

(statearr_14042_14174[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (27))){
var inst_13853 = (state_14019[(46)]);
var inst_13803 = (state_14019[(47)]);
var inst_13852 = (state_14019[(2)]);
var inst_13853__$1 = (inst_13803 == null);
var state_14019__$1 = (function (){var statearr_14043 = state_14019;
(statearr_14043[(46)] = inst_13853__$1);

(statearr_14043[(37)] = inst_13852);

return statearr_14043;
})();
if(cljs.core.truth_(inst_13853__$1)){
var statearr_14044_14175 = state_14019__$1;
(statearr_14044_14175[(1)] = (28));

} else {
var statearr_14045_14176 = state_14019__$1;
(statearr_14045_14176[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (1))){
var state_14019__$1 = state_14019;
var statearr_14046_14177 = state_14019__$1;
(statearr_14046_14177[(2)] = null);

(statearr_14046_14177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (69))){
var inst_13886 = (state_14019[(35)]);
var inst_13951 = (state_14019[(22)]);
var inst_13963 = (inst_13951 > inst_13886);
var state_14019__$1 = state_14019;
var statearr_14047_14178 = state_14019__$1;
(statearr_14047_14178[(2)] = inst_13963);

(statearr_14047_14178[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (24))){
var inst_13848 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
if(cljs.core.truth_(inst_13848)){
var statearr_14048_14179 = state_14019__$1;
(statearr_14048_14179[(1)] = (25));

} else {
var statearr_14049_14180 = state_14019__$1;
(statearr_14049_14180[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (55))){
var inst_13880 = (state_14019[(15)]);
var inst_13913 = (state_14019[(41)]);
var inst_13912 = (state_14019[(2)]);
var inst_13913__$1 = fluree.db.util.async.throw_err(inst_13912);
var inst_13914 = fluree.db.dbproto._lookup_leaf(inst_13913__$1,inst_13880);
var state_14019__$1 = (function (){var statearr_14050 = state_14019;
(statearr_14050[(41)] = inst_13913__$1);

return statearr_14050;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(56),inst_13914);
} else {
if((state_val_14020 === (85))){
var inst_13994 = (state_14019[(48)]);
var state_14019__$1 = state_14019;
var statearr_14051_14181 = state_14019__$1;
(statearr_14051_14181[(2)] = inst_13994);

(statearr_14051_14181[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (39))){
var inst_13868 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14052_14182 = state_14019__$1;
(statearr_14052_14182[(2)] = inst_13868);

(statearr_14052_14182[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (88))){
var inst_13934 = (state_14019[(8)]);
var inst_13913 = (state_14019[(41)]);
var inst_14006 = fluree.db.dbproto._lookup_leaf(inst_13913,inst_13934);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(90),inst_14006);
} else {
if((state_val_14020 === (46))){
var inst_13882 = (state_14019[(49)]);
var state_14019__$1 = state_14019;
var statearr_14053_14183 = state_14019__$1;
(statearr_14053_14183[(2)] = inst_13882);

(statearr_14053_14183[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (4))){
var inst_13782 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14054_14184 = state_14019__$1;
(statearr_14054_14184[(2)] = inst_13782);

(statearr_14054_14184[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (77))){
var inst_13974 = (state_14019[(2)]);
var inst_13975 = fluree.db.util.async.throw_err(inst_13974);
var state_14019__$1 = state_14019;
if(cljs.core.truth_(inst_13975)){
var statearr_14055_14185 = state_14019__$1;
(statearr_14055_14185[(1)] = (78));

} else {
var statearr_14056_14186 = state_14019__$1;
(statearr_14056_14186[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (54))){
var inst_13904 = (state_14019[(2)]);
var inst_13905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13906 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13907 = (new cljs.core.PersistentVector(null,2,(5),inst_13905,inst_13906,null));
var inst_13908 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13907);
var inst_13909 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_13910 = fluree.db.dbproto._resolve(inst_13909);
var state_14019__$1 = (function (){var statearr_14057 = state_14019;
(statearr_14057[(10)] = inst_13904);

(statearr_14057[(38)] = inst_13908);

return statearr_14057;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(55),inst_13910);
} else {
if((state_val_14020 === (15))){
var inst_13797 = (state_14019[(50)]);
var state_14019__$1 = state_14019;
var statearr_14058_14187 = state_14019__$1;
(statearr_14058_14187[(2)] = inst_13797);

(statearr_14058_14187[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (48))){
var inst_13892 = (state_14019[(51)]);
var inst_13886 = (state_14019[(2)]);
var inst_13887 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13889 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13890 = (new cljs.core.PersistentVector(null,3,(5),inst_13888,inst_13889,null));
var inst_13891 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13890);
var inst_13892__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_14019__$1 = (function (){var statearr_14059 = state_14019;
(statearr_14059[(27)] = inst_13887);

(statearr_14059[(51)] = inst_13892__$1);

(statearr_14059[(35)] = inst_13886);

(statearr_14059[(36)] = inst_13891);

return statearr_14059;
})();
if(cljs.core.truth_(inst_13892__$1)){
var statearr_14060_14188 = state_14019__$1;
(statearr_14060_14188[(1)] = (49));

} else {
var statearr_14061_14189 = state_14019__$1;
(statearr_14061_14189[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (50))){
var inst_13895 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_14019__$1 = state_14019;
var statearr_14062_14190 = state_14019__$1;
(statearr_14062_14190[(2)] = inst_13895);

(statearr_14062_14190[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (75))){
var inst_13952 = (state_14019[(52)]);
var state_14019__$1 = state_14019;
var statearr_14063_14191 = state_14019__$1;
(statearr_14063_14191[(2)] = inst_13952);

(statearr_14063_14191[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (21))){
var inst_13839 = (state_14019[(2)]);
var inst_13840 = fluree.db.util.async.throw_err(inst_13839);
var state_14019__$1 = state_14019;
var statearr_14064_14192 = state_14019__$1;
(statearr_14064_14192[(2)] = inst_13840);

(statearr_14064_14192[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (31))){
var state_14019__$1 = state_14019;
var statearr_14065_14193 = state_14019__$1;
(statearr_14065_14193[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14065_14193[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (32))){
var inst_13803 = (state_14019[(47)]);
var state_14019__$1 = state_14019;
var statearr_14066_14194 = state_14019__$1;
(statearr_14066_14194[(2)] = inst_13803);

(statearr_14066_14194[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (40))){
var inst_13807 = (state_14019[(53)]);
var state_14019__$1 = state_14019;
var statearr_14067_14195 = state_14019__$1;
(statearr_14067_14195[(2)] = inst_13807);

(statearr_14067_14195[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (56))){
var inst_13916 = (state_14019[(2)]);
var inst_13917 = fluree.db.util.async.throw_err(inst_13916);
var inst_13918 = inst_13917;
var inst_13919 = (0);
var inst_13920 = null;
var state_14019__$1 = (function (){var statearr_14068 = state_14019;
(statearr_14068[(30)] = inst_13919);

(statearr_14068[(11)] = inst_13918);

(statearr_14068[(45)] = inst_13920);

return statearr_14068;
})();
var statearr_14069_14196 = state_14019__$1;
(statearr_14069_14196[(2)] = null);

(statearr_14069_14196[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (33))){
var inst_13800 = (state_14019[(54)]);
var inst_13861 = (state_14019[(2)]);
var state_14019__$1 = (function (){var statearr_14070 = state_14019;
(statearr_14070[(40)] = inst_13861);

return statearr_14070;
})();
if(cljs.core.truth_(inst_13800)){
var statearr_14071_14197 = state_14019__$1;
(statearr_14071_14197[(1)] = (34));

} else {
var statearr_14072_14198 = state_14019__$1;
(statearr_14072_14198[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (13))){
var inst_13821 = (state_14019[(2)]);
var inst_13822 = fluree.db.util.async.throw_err(inst_13821);
var state_14019__$1 = state_14019;
var statearr_14073_14199 = state_14019__$1;
(statearr_14073_14199[(2)] = inst_13822);

(statearr_14073_14199[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (22))){
var inst_13834 = (state_14019[(28)]);
var state_14019__$1 = state_14019;
var statearr_14074_14200 = state_14019__$1;
(statearr_14074_14200[(2)] = inst_13834);

(statearr_14074_14200[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (90))){
var inst_13990 = (state_14019[(7)]);
var inst_13991 = (state_14019[(9)]);
var inst_14008 = (state_14019[(2)]);
var inst_14009 = fluree.db.util.async.throw_err(inst_14008);
var inst_13918 = inst_14009;
var inst_13919 = inst_13991;
var inst_13920 = inst_13990;
var state_14019__$1 = (function (){var statearr_14075 = state_14019;
(statearr_14075[(30)] = inst_13919);

(statearr_14075[(11)] = inst_13918);

(statearr_14075[(45)] = inst_13920);

return statearr_14075;
})();
var statearr_14076_14201 = state_14019__$1;
(statearr_14076_14201[(2)] = null);

(statearr_14076_14201[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (36))){
var inst_13807 = (state_14019[(53)]);
var inst_13870 = (state_14019[(2)]);
var state_14019__$1 = (function (){var statearr_14077 = state_14019;
(statearr_14077[(42)] = inst_13870);

return statearr_14077;
})();
if(cljs.core.truth_(inst_13807)){
var statearr_14078_14202 = state_14019__$1;
(statearr_14078_14202[(1)] = (40));

} else {
var statearr_14079_14203 = state_14019__$1;
(statearr_14079_14203[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (41))){
var inst_13873 = (cljs.core._LT__EQ_ === end_test);
var state_14019__$1 = state_14019;
if(cljs.core.truth_(inst_13873)){
var statearr_14080_14204 = state_14019__$1;
(statearr_14080_14204[(1)] = (43));

} else {
var statearr_14081_14205 = state_14019__$1;
(statearr_14081_14205[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (89))){
var inst_14012 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14082_14206 = state_14019__$1;
(statearr_14082_14206[(2)] = inst_14012);

(statearr_14082_14206[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (43))){
var state_14019__$1 = state_14019;
var statearr_14083_14207 = state_14019__$1;
(statearr_14083_14207[(2)] = (2147483647));

(statearr_14083_14207[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (61))){
var inst_13926 = (state_14019[(18)]);
var state_14019__$1 = state_14019;
var statearr_14084_14208 = state_14019__$1;
(statearr_14084_14208[(2)] = inst_13926);

(statearr_14084_14208[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (29))){
var inst_13853 = (state_14019[(46)]);
var state_14019__$1 = state_14019;
var statearr_14085_14209 = state_14019__$1;
(statearr_14085_14209[(2)] = inst_13853);

(statearr_14085_14209[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (44))){
var state_14019__$1 = state_14019;
var statearr_14086_14210 = state_14019__$1;
(statearr_14086_14210[(2)] = fluree.db.util.core.min_integer);

(statearr_14086_14210[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (6))){
var inst_13795 = (state_14019[(14)]);
var inst_13810 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13795);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(9),inst_13810);
} else {
if((state_val_14020 === (28))){
var inst_13843 = (state_14019[(21)]);
var state_14019__$1 = state_14019;
var statearr_14087_14211 = state_14019__$1;
(statearr_14087_14211[(2)] = inst_13843);

(statearr_14087_14211[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (64))){
var inst_13919 = (state_14019[(30)]);
var inst_13933 = (state_14019[(12)]);
var inst_13947 = cljs.core.seq(inst_13933);
var inst_13948 = cljs.core.first(inst_13947);
var inst_13949 = cljs.core.next(inst_13947);
var inst_13950 = inst_13933;
var inst_13951 = inst_13919;
var inst_13952 = inst_13933;
var state_14019__$1 = (function (){var statearr_14088 = state_14019;
(statearr_14088[(52)] = inst_13952);

(statearr_14088[(55)] = inst_13949);

(statearr_14088[(56)] = inst_13948);

(statearr_14088[(57)] = inst_13950);

(statearr_14088[(22)] = inst_13951);

return statearr_14088;
})();
var statearr_14089_14212 = state_14019__$1;
(statearr_14089_14212[(2)] = null);

(statearr_14089_14212[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (51))){
var inst_13897 = (state_14019[(2)]);
var inst_13898 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13899 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14019__$1 = (function (){var statearr_14090 = state_14019;
(statearr_14090[(34)] = inst_13897);

(statearr_14090[(43)] = inst_13898);

return statearr_14090;
})();
if(cljs.core.truth_(inst_13899)){
var statearr_14091_14213 = state_14019__$1;
(statearr_14091_14213[(1)] = (52));

} else {
var statearr_14092_14214 = state_14019__$1;
(statearr_14092_14214[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (25))){
var state_14019__$1 = state_14019;
var statearr_14093_14215 = state_14019__$1;
(statearr_14093_14215[(2)] = (-1));

(statearr_14093_14215[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (34))){
var inst_13800 = (state_14019[(54)]);
var state_14019__$1 = state_14019;
var statearr_14094_14216 = state_14019__$1;
(statearr_14094_14216[(2)] = inst_13800);

(statearr_14094_14216[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (17))){
var inst_13830 = (state_14019[(2)]);
var inst_13831 = fluree.db.util.async.throw_err(inst_13830);
var state_14019__$1 = state_14019;
var statearr_14095_14217 = state_14019__$1;
(statearr_14095_14217[(2)] = inst_13831);

(statearr_14095_14217[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (3))){
var inst_14017 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14019__$1,inst_14017);
} else {
if((state_val_14020 === (12))){
var inst_13797 = (state_14019[(50)]);
var inst_13825 = (state_14019[(2)]);
var inst_13826 = fluree.db.util.core.pred_ident_QMARK_(inst_13797);
var state_14019__$1 = (function (){var statearr_14096 = state_14019;
(statearr_14096[(33)] = inst_13825);

return statearr_14096;
})();
if(inst_13826){
var statearr_14097_14218 = state_14019__$1;
(statearr_14097_14218[(1)] = (14));

} else {
var statearr_14098_14219 = state_14019__$1;
(statearr_14098_14219[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (2))){
var inst_13801 = (state_14019[(25)]);
var inst_13794 = (state_14019[(26)]);
var inst_13795 = (state_14019[(14)]);
var _ = (function (){var statearr_14099 = state_14019;
(statearr_14099[(4)] = cljs.core.cons((5),(state_14019[(4)])));

return statearr_14099;
})();
var inst_13794__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13795__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13794__$1,(0),null);
var inst_13796 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13794__$1,(1),null);
var inst_13797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13794__$1,(2),null);
var inst_13798 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13794__$1,(3),null);
var inst_13799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13794__$1,(4),null);
var inst_13800 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13794__$1,(5),null);
var inst_13801__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13802 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13801__$1,(0),null);
var inst_13803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13801__$1,(1),null);
var inst_13804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13801__$1,(2),null);
var inst_13805 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13801__$1,(3),null);
var inst_13806 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13801__$1,(4),null);
var inst_13807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13801__$1,(5),null);
var inst_13808 = fluree.db.util.core.pred_ident_QMARK_(inst_13795__$1);
var state_14019__$1 = (function (){var statearr_14100 = state_14019;
(statearr_14100[(24)] = inst_13805);

(statearr_14100[(25)] = inst_13801__$1);

(statearr_14100[(50)] = inst_13797);

(statearr_14100[(26)] = inst_13794__$1);

(statearr_14100[(58)] = inst_13802);

(statearr_14100[(14)] = inst_13795__$1);

(statearr_14100[(29)] = inst_13798);

(statearr_14100[(32)] = inst_13799);

(statearr_14100[(47)] = inst_13803);

(statearr_14100[(54)] = inst_13800);

(statearr_14100[(59)] = inst_13804);

(statearr_14100[(20)] = inst_13796);

(statearr_14100[(53)] = inst_13807);

(statearr_14100[(44)] = inst_13806);

return statearr_14100;
})();
if(inst_13808){
var statearr_14101_14220 = state_14019__$1;
(statearr_14101_14220[(1)] = (6));

} else {
var statearr_14102_14221 = state_14019__$1;
(statearr_14102_14221[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (66))){
var inst_13960 = (state_14019[(60)]);
var inst_13958 = (state_14019[(13)]);
var inst_13950 = (state_14019[(57)]);
var inst_13957 = cljs.core.seq(inst_13950);
var inst_13958__$1 = cljs.core.first(inst_13957);
var inst_13959 = cljs.core.next(inst_13957);
var inst_13960__$1 = (inst_13958__$1 == null);
var state_14019__$1 = (function (){var statearr_14103 = state_14019;
(statearr_14103[(60)] = inst_13960__$1);

(statearr_14103[(13)] = inst_13958__$1);

(statearr_14103[(61)] = inst_13959);

return statearr_14103;
})();
if(cljs.core.truth_(inst_13960__$1)){
var statearr_14104_14222 = state_14019__$1;
(statearr_14104_14222[(1)] = (68));

} else {
var statearr_14105_14223 = state_14019__$1;
(statearr_14105_14223[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (23))){
var inst_13844 = (state_14019[(19)]);
var state_14019__$1 = state_14019;
var statearr_14106_14224 = state_14019__$1;
(statearr_14106_14224[(2)] = inst_13844);

(statearr_14106_14224[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (47))){
var state_14019__$1 = state_14019;
var statearr_14107_14225 = state_14019__$1;
(statearr_14107_14225[(2)] = fluree.db.util.core.max_long);

(statearr_14107_14225[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (35))){
var inst_13864 = (cljs.core._GT__EQ_ === start_test);
var state_14019__$1 = state_14019;
if(cljs.core.truth_(inst_13864)){
var statearr_14108_14226 = state_14019__$1;
(statearr_14108_14226[(1)] = (37));

} else {
var statearr_14109_14227 = state_14019__$1;
(statearr_14109_14227[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (82))){
var inst_13934 = (state_14019[(8)]);
var state_14019__$1 = state_14019;
var statearr_14110_14228 = state_14019__$1;
(statearr_14110_14228[(2)] = inst_13934);

(statearr_14110_14228[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (76))){
var inst_13969 = (state_14019[(23)]);
var inst_13959 = (state_14019[(61)]);
var inst_13983 = (state_14019[(2)]);
var inst_13950 = inst_13959;
var inst_13951 = inst_13969;
var inst_13952 = inst_13983;
var state_14019__$1 = (function (){var statearr_14111 = state_14019;
(statearr_14111[(52)] = inst_13952);

(statearr_14111[(57)] = inst_13950);

(statearr_14111[(22)] = inst_13951);

return statearr_14111;
})();
var statearr_14112_14229 = state_14019__$1;
(statearr_14112_14229[(2)] = null);

(statearr_14112_14229[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (19))){
var inst_13804 = (state_14019[(59)]);
var state_14019__$1 = state_14019;
var statearr_14113_14230 = state_14019__$1;
(statearr_14113_14230[(2)] = inst_13804);

(statearr_14113_14230[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (57))){
var inst_13897 = (state_14019[(34)]);
var inst_13918 = (state_14019[(11)]);
var inst_13908 = (state_14019[(38)]);
var inst_13898 = (state_14019[(43)]);
var inst_13922 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_13918,inst_13897,inst_13898,inst_13908);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(59),inst_13922);
} else {
if((state_val_14020 === (68))){
var inst_13960 = (state_14019[(60)]);
var state_14019__$1 = state_14019;
var statearr_14114_14231 = state_14019__$1;
(statearr_14114_14231[(2)] = inst_13960);

(statearr_14114_14231[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (11))){
var inst_13802 = (state_14019[(58)]);
var state_14019__$1 = state_14019;
var statearr_14116_14232 = state_14019__$1;
(statearr_14116_14232[(2)] = inst_13802);

(statearr_14116_14232[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (9))){
var inst_13812 = (state_14019[(2)]);
var inst_13813 = fluree.db.util.async.throw_err(inst_13812);
var state_14019__$1 = state_14019;
var statearr_14117_14233 = state_14019__$1;
(statearr_14117_14233[(2)] = inst_13813);

(statearr_14117_14233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (5))){
var _ = (function (){var statearr_14118 = state_14019;
(statearr_14118[(4)] = cljs.core.rest((state_14019[(4)])));

return statearr_14118;
})();
var state_14019__$1 = state_14019;
var ex14115 = (state_14019__$1[(2)]);
var statearr_14119_14234 = state_14019__$1;
(statearr_14119_14234[(5)] = ex14115);


if((ex14115 instanceof Error)){
var statearr_14120_14235 = state_14019__$1;
(statearr_14120_14235[(1)] = (4));

(statearr_14120_14235[(5)] = null);

} else {
throw ex14115;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (83))){
var inst_14002 = (state_14019[(2)]);
var inst_14003 = cljs.core.not(inst_14002);
var state_14019__$1 = state_14019;
if(inst_14003){
var statearr_14121_14236 = state_14019__$1;
(statearr_14121_14236[(1)] = (87));

} else {
var statearr_14122_14237 = state_14019__$1;
(statearr_14122_14237[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (14))){
var inst_13797 = (state_14019[(50)]);
var inst_13828 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13797);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(17),inst_13828);
} else {
if((state_val_14020 === (45))){
var inst_13877 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14123_14238 = state_14019__$1;
(statearr_14123_14238[(2)] = inst_13877);

(statearr_14123_14238[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (53))){
var state_14019__$1 = state_14019;
var statearr_14124_14239 = state_14019__$1;
(statearr_14124_14239[(2)] = true);

(statearr_14124_14239[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (78))){
var inst_13952 = (state_14019[(52)]);
var state_14019__$1 = state_14019;
var statearr_14125_14240 = state_14019__$1;
(statearr_14125_14240[(2)] = inst_13952);

(statearr_14125_14240[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (26))){
var inst_13796 = (state_14019[(20)]);
var state_14019__$1 = state_14019;
var statearr_14126_14241 = state_14019__$1;
(statearr_14126_14241[(2)] = inst_13796);

(statearr_14126_14241[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (16))){
var inst_13804 = (state_14019[(59)]);
var inst_13834 = (state_14019[(2)]);
var inst_13835 = fluree.db.util.core.pred_ident_QMARK_(inst_13804);
var state_14019__$1 = (function (){var statearr_14127 = state_14019;
(statearr_14127[(28)] = inst_13834);

return statearr_14127;
})();
if(inst_13835){
var statearr_14128_14242 = state_14019__$1;
(statearr_14128_14242[(1)] = (18));

} else {
var statearr_14129_14243 = state_14019__$1;
(statearr_14129_14243[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (81))){
var inst_13994 = (state_14019[(48)]);
var inst_13881 = (state_14019[(16)]);
var inst_13891 = (state_14019[(36)]);
var inst_13934 = (state_14019[(8)]);
var inst_13993 = (inst_13891.cljs$core$IFn$_invoke$arity$2 ? inst_13891.cljs$core$IFn$_invoke$arity$2(inst_13934,inst_13881) : inst_13891.call(null,inst_13934,inst_13881));
var inst_13994__$1 = (inst_13993 < (0));
var state_14019__$1 = (function (){var statearr_14130 = state_14019;
(statearr_14130[(48)] = inst_13994__$1);

return statearr_14130;
})();
if(cljs.core.truth_(inst_13994__$1)){
var statearr_14131_14244 = state_14019__$1;
(statearr_14131_14244[(1)] = (84));

} else {
var statearr_14132_14245 = state_14019__$1;
(statearr_14132_14245[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (79))){
var inst_13952 = (state_14019[(52)]);
var inst_13958 = (state_14019[(13)]);
var inst_13978 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_13952,inst_13958);
var state_14019__$1 = state_14019;
var statearr_14133_14246 = state_14019__$1;
(statearr_14133_14246[(2)] = inst_13978);

(statearr_14133_14246[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (38))){
var state_14019__$1 = state_14019;
var statearr_14134_14247 = state_14019__$1;
(statearr_14134_14247[(2)] = (2147483647));

(statearr_14134_14247[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (87))){
var inst_13990 = (state_14019[(7)]);
var state_14019__$1 = state_14019;
var statearr_14135_14248 = state_14019__$1;
(statearr_14135_14248[(2)] = inst_13990);

(statearr_14135_14248[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (30))){
var inst_13857 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
if(cljs.core.truth_(inst_13857)){
var statearr_14136_14249 = state_14019__$1;
(statearr_14136_14249[(1)] = (31));

} else {
var statearr_14137_14250 = state_14019__$1;
(statearr_14137_14250[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (73))){
var inst_13986 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14138_14251 = state_14019__$1;
(statearr_14138_14251[(2)] = inst_13986);

(statearr_14138_14251[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (10))){
var inst_13802 = (state_14019[(58)]);
var inst_13819 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13802);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(13),inst_13819);
} else {
if((state_val_14020 === (18))){
var inst_13804 = (state_14019[(59)]);
var inst_13837 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13804);
var state_14019__$1 = state_14019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14019__$1,(21),inst_13837);
} else {
if((state_val_14020 === (52))){
var inst_13887 = (state_14019[(27)]);
var inst_13825 = (state_14019[(33)]);
var inst_13852 = (state_14019[(37)]);
var inst_13816 = (state_14019[(39)]);
var inst_13861 = (state_14019[(40)]);
var inst_13901 = fluree.db.permissions_validate.no_filter_QMARK_(inst_13887,inst_13816,inst_13825,inst_13852,inst_13861);
var state_14019__$1 = state_14019;
var statearr_14139_14252 = state_14019__$1;
(statearr_14139_14252[(2)] = inst_13901);

(statearr_14139_14252[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (67))){
var inst_13988 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14140_14253 = state_14019__$1;
(statearr_14140_14253[(2)] = inst_13988);

(statearr_14140_14253[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (71))){
var inst_13952 = (state_14019[(52)]);
var inst_13920 = (state_14019[(45)]);
var inst_13967 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13952,inst_13920);
var state_14019__$1 = state_14019;
var statearr_14141_14254 = state_14019__$1;
(statearr_14141_14254[(2)] = inst_13967);

(statearr_14141_14254[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (42))){
var inst_13805 = (state_14019[(24)]);
var inst_13882 = (state_14019[(49)]);
var inst_13834 = (state_14019[(28)]);
var inst_13798 = (state_14019[(29)]);
var inst_13879 = (state_14019[(31)]);
var inst_13799 = (state_14019[(32)]);
var inst_13825 = (state_14019[(33)]);
var inst_13852 = (state_14019[(37)]);
var inst_13816 = (state_14019[(39)]);
var inst_13861 = (state_14019[(40)]);
var inst_13870 = (state_14019[(42)]);
var inst_13806 = (state_14019[(44)]);
var inst_13843 = (state_14019[(21)]);
var inst_13879__$1 = (state_14019[(2)]);
var inst_13880 = fluree.db.flake.__GT_Flake(inst_13816,inst_13852,inst_13834,inst_13798,inst_13799,inst_13870);
var inst_13881 = fluree.db.flake.__GT_Flake(inst_13825,inst_13861,inst_13843,inst_13805,inst_13806,inst_13879__$1);
var inst_13882__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_14019__$1 = (function (){var statearr_14142 = state_14019;
(statearr_14142[(15)] = inst_13880);

(statearr_14142[(49)] = inst_13882__$1);

(statearr_14142[(31)] = inst_13879__$1);

(statearr_14142[(16)] = inst_13881);

return statearr_14142;
})();
if(cljs.core.truth_(inst_13882__$1)){
var statearr_14143_14255 = state_14019__$1;
(statearr_14143_14255[(1)] = (46));

} else {
var statearr_14144_14256 = state_14019__$1;
(statearr_14144_14256[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (80))){
var inst_13980 = (state_14019[(2)]);
var state_14019__$1 = state_14019;
var statearr_14145_14257 = state_14019__$1;
(statearr_14145_14257[(2)] = inst_13980);

(statearr_14145_14257[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (37))){
var state_14019__$1 = state_14019;
var statearr_14146_14258 = state_14019__$1;
(statearr_14146_14258[(2)] = fluree.db.util.core.min_integer);

(statearr_14146_14258[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (63))){
var inst_13919 = (state_14019[(30)]);
var inst_13886 = (state_14019[(35)]);
var inst_13920 = (state_14019[(45)]);
var inst_13933 = (state_14019[(12)]);
var inst_13936 = (inst_13886 - inst_13919);
var inst_13937 = fluree.db.flake.take(inst_13936,inst_13933);
var inst_13938 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13937,inst_13920);
var state_14019__$1 = state_14019;
var statearr_14147_14259 = state_14019__$1;
(statearr_14147_14259[(2)] = inst_13938);

(statearr_14147_14259[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (8))){
var inst_13802 = (state_14019[(58)]);
var inst_13816 = (state_14019[(2)]);
var inst_13817 = fluree.db.util.core.pred_ident_QMARK_(inst_13802);
var state_14019__$1 = (function (){var statearr_14148 = state_14019;
(statearr_14148[(39)] = inst_13816);

return statearr_14148;
})();
if(inst_13817){
var statearr_14149_14260 = state_14019__$1;
(statearr_14149_14260[(1)] = (10));

} else {
var statearr_14150_14261 = state_14019__$1;
(statearr_14150_14261[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (49))){
var inst_13892 = (state_14019[(51)]);
var state_14019__$1 = state_14019;
var statearr_14151_14262 = state_14019__$1;
(statearr_14151_14262[(2)] = inst_13892);

(statearr_14151_14262[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14020 === (84))){
var inst_13886 = (state_14019[(35)]);
var inst_13991 = (state_14019[(9)]);
var inst_13996 = (inst_13991 < inst_13886);
var state_14019__$1 = state_14019;
var statearr_14152_14263 = state_14019__$1;
(statearr_14152_14263[(2)] = inst_13996);

(statearr_14152_14263[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_14153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14153[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_14153[(1)] = (1));

return statearr_14153;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_14019){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_14019);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e14154){var ex__2736__auto__ = e14154;
var statearr_14155_14264 = state_14019;
(statearr_14155_14264[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_14019[(4)]))){
var statearr_14156_14265 = state_14019;
(statearr_14156_14265[(1)] = cljs.core.first((state_14019[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14266 = state_14019;
state_14019 = G__14266;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_14019){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_14019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_14157 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_14157[(6)] = c__2755__auto__);

return statearr_14157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_14341){
var state_val_14342 = (state_14341[(1)]);
if((state_val_14342 === (7))){
var inst_14336 = (state_14341[(2)]);
var _ = (function (){var statearr_14343 = state_14341;
(statearr_14343[(4)] = cljs.core.rest((state_14341[(4)])));

return statearr_14343;
})();
var state_14341__$1 = state_14341;
var statearr_14344_14384 = state_14341__$1;
(statearr_14344_14384[(2)] = inst_14336);

(statearr_14344_14384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (20))){
var inst_14318 = (state_14341[(2)]);
var inst_14319 = fluree.db.util.async.throw_err(inst_14318);
var state_14341__$1 = state_14341;
var statearr_14345_14385 = state_14341__$1;
(statearr_14345_14385[(2)] = inst_14319);

(statearr_14345_14385[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (1))){
var state_14341__$1 = state_14341;
var statearr_14346_14386 = state_14341__$1;
(statearr_14346_14386[(2)] = null);

(statearr_14346_14386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (4))){
var inst_14267 = (state_14341[(2)]);
var state_14341__$1 = state_14341;
var statearr_14347_14387 = state_14341__$1;
(statearr_14347_14387[(2)] = inst_14267);

(statearr_14347_14387[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (15))){
var inst_14314 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14341__$1 = state_14341;
if(cljs.core.truth_(inst_14314)){
var statearr_14348_14388 = state_14341__$1;
(statearr_14348_14388[(1)] = (17));

} else {
var statearr_14349_14389 = state_14341__$1;
(statearr_14349_14389[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (21))){
var state_14341__$1 = state_14341;
var statearr_14350_14390 = state_14341__$1;
(statearr_14350_14390[(2)] = (0));

(statearr_14350_14390[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (13))){
var inst_14306 = (state_14341[(2)]);
var state_14341__$1 = state_14341;
var statearr_14351_14391 = state_14341__$1;
(statearr_14351_14391[(2)] = inst_14306);

(statearr_14351_14391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (22))){
var state_14341__$1 = state_14341;
var statearr_14352_14392 = state_14341__$1;
(statearr_14352_14392[(2)] = (1));

(statearr_14352_14392[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (6))){
var inst_14298 = (state_14341[(7)]);
var inst_14287 = (state_14341[(8)]);
var inst_14296 = (state_14341[(9)]);
var inst_14295 = cljs.core.seq(inst_14287);
var inst_14296__$1 = cljs.core.first(inst_14295);
var inst_14297 = cljs.core.next(inst_14295);
var inst_14298__$1 = (inst_14296__$1 == null);
var state_14341__$1 = (function (){var statearr_14353 = state_14341;
(statearr_14353[(7)] = inst_14298__$1);

(statearr_14353[(9)] = inst_14296__$1);

(statearr_14353[(10)] = inst_14297);

return statearr_14353;
})();
if(cljs.core.truth_(inst_14298__$1)){
var statearr_14354_14393 = state_14341__$1;
(statearr_14354_14393[(1)] = (8));

} else {
var statearr_14355_14394 = state_14341__$1;
(statearr_14355_14394[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (17))){
var inst_14296 = (state_14341[(9)]);
var inst_14316 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_14296);
var state_14341__$1 = state_14341;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14341__$1,(20),inst_14316);
} else {
if((state_val_14342 === (3))){
var inst_14339 = (state_14341[(2)]);
var state_14341__$1 = state_14341;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14341__$1,inst_14339);
} else {
if((state_val_14342 === (12))){
var inst_14289 = (state_14341[(11)]);
var inst_14304 = (inst_14289 >= subject_limit);
var state_14341__$1 = state_14341;
var statearr_14356_14395 = state_14341__$1;
(statearr_14356_14395[(2)] = inst_14304);

(statearr_14356_14395[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (2))){
var _ = (function (){var statearr_14357 = state_14341;
(statearr_14357[(4)] = cljs.core.cons((5),(state_14341[(4)])));

return statearr_14357;
})();
var inst_14280 = subject_groups;
var inst_14281 = cljs.core.seq(inst_14280);
var inst_14282 = cljs.core.first(inst_14281);
var inst_14283 = cljs.core.next(inst_14281);
var inst_14284 = flake_start;
var inst_14285 = subject_start;
var inst_14286 = cljs.core.PersistentVector.EMPTY;
var inst_14287 = inst_14280;
var inst_14288 = inst_14284;
var inst_14289 = inst_14285;
var inst_14290 = inst_14286;
var state_14341__$1 = (function (){var statearr_14358 = state_14341;
(statearr_14358[(12)] = inst_14282);

(statearr_14358[(11)] = inst_14289);

(statearr_14358[(13)] = inst_14283);

(statearr_14358[(8)] = inst_14287);

(statearr_14358[(14)] = inst_14290);

(statearr_14358[(15)] = inst_14288);

return statearr_14358;
})();
var statearr_14359_14396 = state_14341__$1;
(statearr_14359_14396[(2)] = null);

(statearr_14359_14396[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (23))){
var inst_14322 = (state_14341[(16)]);
var inst_14323 = (state_14341[(17)]);
var inst_14289 = (state_14341[(11)]);
var inst_14297 = (state_14341[(10)]);
var inst_14290 = (state_14341[(14)]);
var inst_14288 = (state_14341[(15)]);
var inst_14328 = (state_14341[(2)]);
var inst_14329 = (inst_14288 + inst_14323);
var inst_14330 = (inst_14289 + inst_14328);
var inst_14331 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14290,inst_14322);
var inst_14287 = inst_14297;
var inst_14288__$1 = inst_14329;
var inst_14289__$1 = inst_14330;
var inst_14290__$1 = inst_14331;
var state_14341__$1 = (function (){var statearr_14360 = state_14341;
(statearr_14360[(11)] = inst_14289__$1);

(statearr_14360[(8)] = inst_14287);

(statearr_14360[(14)] = inst_14290__$1);

(statearr_14360[(15)] = inst_14288__$1);

return statearr_14360;
})();
var statearr_14361_14397 = state_14341__$1;
(statearr_14361_14397[(2)] = null);

(statearr_14361_14397[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (19))){
var inst_14322 = (state_14341[(16)]);
var inst_14323 = (state_14341[(17)]);
var inst_14322__$1 = (state_14341[(2)]);
var inst_14323__$1 = cljs.core.count(inst_14322__$1);
var inst_14324 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14323__$1);
var state_14341__$1 = (function (){var statearr_14362 = state_14341;
(statearr_14362[(16)] = inst_14322__$1);

(statearr_14362[(17)] = inst_14323__$1);

return statearr_14362;
})();
if(inst_14324){
var statearr_14363_14398 = state_14341__$1;
(statearr_14363_14398[(1)] = (21));

} else {
var statearr_14364_14399 = state_14341__$1;
(statearr_14364_14399[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (11))){
var inst_14301 = (state_14341[(18)]);
var state_14341__$1 = state_14341;
var statearr_14366_14400 = state_14341__$1;
(statearr_14366_14400[(2)] = inst_14301);

(statearr_14366_14400[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (9))){
var inst_14301 = (state_14341[(18)]);
var inst_14288 = (state_14341[(15)]);
var inst_14301__$1 = (inst_14288 >= flake_limit);
var state_14341__$1 = (function (){var statearr_14367 = state_14341;
(statearr_14367[(18)] = inst_14301__$1);

return statearr_14367;
})();
if(cljs.core.truth_(inst_14301__$1)){
var statearr_14368_14401 = state_14341__$1;
(statearr_14368_14401[(1)] = (11));

} else {
var statearr_14369_14402 = state_14341__$1;
(statearr_14369_14402[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (5))){
var _ = (function (){var statearr_14370 = state_14341;
(statearr_14370[(4)] = cljs.core.rest((state_14341[(4)])));

return statearr_14370;
})();
var state_14341__$1 = state_14341;
var ex14365 = (state_14341__$1[(2)]);
var statearr_14371_14403 = state_14341__$1;
(statearr_14371_14403[(5)] = ex14365);


if((ex14365 instanceof Error)){
var statearr_14372_14404 = state_14341__$1;
(statearr_14372_14404[(1)] = (4));

(statearr_14372_14404[(5)] = null);

} else {
throw ex14365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (14))){
var inst_14289 = (state_14341[(11)]);
var inst_14290 = (state_14341[(14)]);
var inst_14288 = (state_14341[(15)]);
var inst_14310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14311 = [inst_14288,inst_14289,inst_14290];
var inst_14312 = (new cljs.core.PersistentVector(null,3,(5),inst_14310,inst_14311,null));
var state_14341__$1 = state_14341;
var statearr_14373_14405 = state_14341__$1;
(statearr_14373_14405[(2)] = inst_14312);

(statearr_14373_14405[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (16))){
var inst_14334 = (state_14341[(2)]);
var state_14341__$1 = state_14341;
var statearr_14374_14406 = state_14341__$1;
(statearr_14374_14406[(2)] = inst_14334);

(statearr_14374_14406[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (10))){
var inst_14308 = (state_14341[(2)]);
var state_14341__$1 = state_14341;
if(cljs.core.truth_(inst_14308)){
var statearr_14375_14407 = state_14341__$1;
(statearr_14375_14407[(1)] = (14));

} else {
var statearr_14376_14408 = state_14341__$1;
(statearr_14376_14408[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (18))){
var inst_14296 = (state_14341[(9)]);
var state_14341__$1 = state_14341;
var statearr_14377_14409 = state_14341__$1;
(statearr_14377_14409[(2)] = inst_14296);

(statearr_14377_14409[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14342 === (8))){
var inst_14298 = (state_14341[(7)]);
var state_14341__$1 = state_14341;
var statearr_14378_14410 = state_14341__$1;
(statearr_14378_14410[(2)] = inst_14298);

(statearr_14378_14410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____0 = (function (){
var statearr_14379 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14379[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__);

(statearr_14379[(1)] = (1));

return statearr_14379;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____1 = (function (state_14341){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_14341);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e14380){var ex__2736__auto__ = e14380;
var statearr_14381_14411 = state_14341;
(statearr_14381_14411[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_14341[(4)]))){
var statearr_14382_14412 = state_14341;
(statearr_14382_14412[(1)] = cljs.core.first((state_14341[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14413 = state_14341;
state_14341 = G__14413;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__ = function(state_14341){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____1.call(this,state_14341);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_14383 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_14383[(6)] = c__2755__auto__);

return statearr_14383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_14459){
var state_val_14460 = (state_14459[(1)]);
if((state_val_14460 === (7))){
var state_14459__$1 = state_14459;
var statearr_14461_14499 = state_14459__$1;
(statearr_14461_14499[(2)] = null);

(statearr_14461_14499[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (20))){
var inst_14445 = (state_14459[(2)]);
var inst_14446 = fluree.db.util.async.throw_err(inst_14445);
var inst_14424 = inst_14446;
var state_14459__$1 = (function (){var statearr_14462 = state_14459;
(statearr_14462[(7)] = inst_14424);

return statearr_14462;
})();
var statearr_14463_14500 = state_14459__$1;
(statearr_14463_14500[(2)] = null);

(statearr_14463_14500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (1))){
var state_14459__$1 = state_14459;
var statearr_14464_14501 = state_14459__$1;
(statearr_14464_14501[(2)] = null);

(statearr_14464_14501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (4))){
var inst_14414 = (state_14459[(2)]);
var state_14459__$1 = state_14459;
var statearr_14465_14502 = state_14459__$1;
(statearr_14465_14502[(2)] = inst_14414);

(statearr_14465_14502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (15))){
var inst_14424 = (state_14459[(7)]);
var inst_14441 = (state_14459[(8)]);
var inst_14441__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14424);
var state_14459__$1 = (function (){var statearr_14466 = state_14459;
(statearr_14466[(8)] = inst_14441__$1);

return statearr_14466;
})();
if(cljs.core.truth_(inst_14441__$1)){
var statearr_14467_14503 = state_14459__$1;
(statearr_14467_14503[(1)] = (17));

} else {
var statearr_14468_14504 = state_14459__$1;
(statearr_14468_14504[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (13))){
var inst_14434 = (state_14459[(2)]);
var inst_14435 = fluree.db.util.async.throw_err(inst_14434);
var _ = (function (){var statearr_14469 = state_14459;
(statearr_14469[(4)] = cljs.core.rest((state_14459[(4)])));

return statearr_14469;
})();
var state_14459__$1 = state_14459;
var statearr_14470_14505 = state_14459__$1;
(statearr_14470_14505[(2)] = inst_14435);

(statearr_14470_14505[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (6))){
var inst_14422 = (state_14459[(2)]);
var inst_14423 = fluree.db.util.async.throw_err(inst_14422);
var inst_14424 = inst_14423;
var state_14459__$1 = (function (){var statearr_14471 = state_14459;
(statearr_14471[(7)] = inst_14424);

return statearr_14471;
})();
var statearr_14472_14506 = state_14459__$1;
(statearr_14472_14506[(2)] = null);

(statearr_14472_14506[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (17))){
var inst_14441 = (state_14459[(8)]);
var inst_14443 = fluree.db.dbproto._lookup_leaf(root_node,inst_14441);
var state_14459__$1 = state_14459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14459__$1,(20),inst_14443);
} else {
if((state_val_14460 === (3))){
var inst_14457 = (state_14459[(2)]);
var state_14459__$1 = state_14459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14459__$1,inst_14457);
} else {
if((state_val_14460 === (12))){
var _ = (function (){var statearr_14474 = state_14459;
(statearr_14474[(4)] = cljs.core.rest((state_14459[(4)])));

return statearr_14474;
})();
var state_14459__$1 = state_14459;
var ex14473 = (state_14459__$1[(2)]);
var statearr_14475_14507 = state_14459__$1;
(statearr_14475_14507[(5)] = ex14473);


var statearr_14476_14508 = state_14459__$1;
(statearr_14476_14508[(1)] = (11));

(statearr_14476_14508[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (2))){
var _ = (function (){var statearr_14477 = state_14459;
(statearr_14477[(4)] = cljs.core.cons((5),(state_14459[(4)])));

return statearr_14477;
})();
var inst_14420 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_14459__$1 = state_14459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14459__$1,(6),inst_14420);
} else {
if((state_val_14460 === (19))){
var inst_14450 = (state_14459[(2)]);
var state_14459__$1 = state_14459;
var statearr_14478_14509 = state_14459__$1;
(statearr_14478_14509[(2)] = inst_14450);

(statearr_14478_14509[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (11))){
var inst_14426 = (state_14459[(2)]);
var state_14459__$1 = (function (){var statearr_14480 = state_14459;
(statearr_14480[(9)] = inst_14426);

return statearr_14480;
})();
var statearr_14481_14510 = state_14459__$1;
(statearr_14481_14510[(2)] = null);

(statearr_14481_14510[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (9))){
var inst_14424 = (state_14459[(7)]);
var _ = (function (){var statearr_14482 = state_14459;
(statearr_14482[(4)] = cljs.core.cons((12),(state_14459[(4)])));

return statearr_14482;
})();
var inst_14432 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_14424,t,novelty,fast_forward_db_QMARK_);
var state_14459__$1 = state_14459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14459__$1,(13),inst_14432);
} else {
if((state_val_14460 === (5))){
var _ = (function (){var statearr_14483 = state_14459;
(statearr_14483[(4)] = cljs.core.rest((state_14459[(4)])));

return statearr_14483;
})();
var state_14459__$1 = state_14459;
var ex14479 = (state_14459__$1[(2)]);
var statearr_14484_14511 = state_14459__$1;
(statearr_14484_14511[(5)] = ex14479);


if((ex14479 instanceof Error)){
var statearr_14485_14512 = state_14459__$1;
(statearr_14485_14512[(1)] = (4));

(statearr_14485_14512[(5)] = null);

} else {
throw ex14479;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (14))){
var inst_14438 = (state_14459[(10)]);
var state_14459__$1 = state_14459;
var statearr_14486_14513 = state_14459__$1;
(statearr_14486_14513[(2)] = inst_14438);

(statearr_14486_14513[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (16))){
var inst_14452 = (state_14459[(2)]);
var state_14459__$1 = state_14459;
var statearr_14487_14514 = state_14459__$1;
(statearr_14487_14514[(2)] = inst_14452);

(statearr_14487_14514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (10))){
var inst_14438 = (state_14459[(10)]);
var inst_14438__$1 = (state_14459[(2)]);
var state_14459__$1 = (function (){var statearr_14488 = state_14459;
(statearr_14488[(10)] = inst_14438__$1);

return statearr_14488;
})();
if(cljs.core.truth_(inst_14438__$1)){
var statearr_14489_14515 = state_14459__$1;
(statearr_14489_14515[(1)] = (14));

} else {
var statearr_14490_14516 = state_14459__$1;
(statearr_14490_14516[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (18))){
var state_14459__$1 = state_14459;
var statearr_14491_14517 = state_14459__$1;
(statearr_14491_14517[(2)] = null);

(statearr_14491_14517[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14460 === (8))){
var inst_14454 = (state_14459[(2)]);
var _ = (function (){var statearr_14492 = state_14459;
(statearr_14492[(4)] = cljs.core.rest((state_14459[(4)])));

return statearr_14492;
})();
var state_14459__$1 = state_14459;
var statearr_14493_14518 = state_14459__$1;
(statearr_14493_14518[(2)] = inst_14454);

(statearr_14493_14518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____0 = (function (){
var statearr_14494 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14494[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__);

(statearr_14494[(1)] = (1));

return statearr_14494;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____1 = (function (state_14459){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_14459);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e14495){var ex__2736__auto__ = e14495;
var statearr_14496_14519 = state_14459;
(statearr_14496_14519[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_14459[(4)]))){
var statearr_14497_14520 = state_14459;
(statearr_14497_14520[(1)] = cljs.core.first((state_14459[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14521 = state_14459;
state_14459 = G__14521;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__ = function(state_14459){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____1.call(this,state_14459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_14498 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_14498[(6)] = c__2755__auto__);

return statearr_14498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14528 = arguments.length;
switch (G__14528) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14529 = (function (){var pred__14532 = cljs.core.identical_QMARK_;
var expr__14533 = test;
if(cljs.core.truth_((pred__14532.cljs$core$IFn$_invoke$arity$2 ? pred__14532.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14533) : pred__14532.call(null,cljs.core._EQ_,expr__14533)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14532.cljs$core$IFn$_invoke$arity$2 ? pred__14532.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14533) : pred__14532.call(null,cljs.core._LT_,expr__14533)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14532.cljs$core$IFn$_invoke$arity$2 ? pred__14532.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14533) : pred__14532.call(null,cljs.core._LT__EQ_,expr__14533)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14532.cljs$core$IFn$_invoke$arity$2 ? pred__14532.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14533) : pred__14532.call(null,cljs.core._GT_,expr__14533)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14532.cljs$core$IFn$_invoke$arity$2 ? pred__14532.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14533) : pred__14532.call(null,cljs.core._GT__EQ_,expr__14533)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14533)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14529,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_14905){
var state_val_14906 = (state_14905[(1)]);
if((state_val_14906 === (121))){
var inst_14861 = (state_14905[(7)]);
var state_14905__$1 = state_14905;
var statearr_14907_15103 = state_14905__$1;
(statearr_14907_15103[(2)] = inst_14861);

(statearr_14907_15103[(1)] = (123));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (65))){
var inst_14713 = (state_14905[(8)]);
var inst_14719 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_14908 = state_14905;
(statearr_14908[(9)] = inst_14719);

return statearr_14908;
})();
if(cljs.core.truth_(inst_14713)){
var statearr_14909_15104 = state_14905__$1;
(statearr_14909_15104[(1)] = (66));

} else {
var statearr_14910_15105 = state_14905__$1;
(statearr_14910_15105[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (70))){
var inst_14897 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14911_15106 = state_14905__$1;
(statearr_14911_15106[(2)] = inst_14897);

(statearr_14911_15106[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (62))){
var inst_14712 = (state_14905[(2)]);
var inst_14713 = fluree.db.util.async.throw_err(inst_14712);
var inst_14714 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_14905__$1 = (function (){var statearr_14912 = state_14905;
(statearr_14912[(8)] = inst_14713);

return statearr_14912;
})();
if(cljs.core.truth_(inst_14714)){
var statearr_14913_15107 = state_14905__$1;
(statearr_14913_15107[(1)] = (63));

} else {
var statearr_14914_15108 = state_14905__$1;
(statearr_14914_15108[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (74))){
var inst_14624 = (state_14905[(10)]);
var inst_14562 = (state_14905[(11)]);
var inst_14627 = (state_14905[(12)]);
var inst_14636 = (state_14905[(13)]);
var inst_14699 = (state_14905[(14)]);
var inst_14560 = (state_14905[(15)]);
var inst_14725 = (state_14905[(16)]);
var inst_14724 = (state_14905[(17)]);
var inst_14623 = (state_14905[(18)]);
var inst_14740 = (state_14905[(19)]);
var inst_14709 = (state_14905[(20)]);
var inst_14722 = (state_14905[(21)]);
var inst_14726 = (state_14905[(22)]);
var inst_14703 = (state_14905[(23)]);
var inst_14683 = (state_14905[(24)]);
var inst_14559 = (state_14905[(25)]);
var inst_14645 = (state_14905[(26)]);
var inst_14672 = (state_14905[(27)]);
var inst_14567 = (state_14905[(28)]);
var inst_14693 = (state_14905[(29)]);
var inst_14681 = (state_14905[(30)]);
var inst_14723 = (state_14905[(31)]);
var inst_14571 = (state_14905[(32)]);
var inst_14713 = (state_14905[(8)]);
var inst_14685 = (state_14905[(33)]);
var inst_14654 = (state_14905[(34)]);
var inst_14692 = (state_14905[(35)]);
var inst_14663 = (state_14905[(36)]);
var inst_14698 = (state_14905[(37)]);
var inst_14682 = (state_14905[(38)]);
var inst_14572 = (state_14905[(39)]);
var inst_14686 = (state_14905[(40)]);
var inst_14704 = (state_14905[(41)]);
var inst_14555 = (state_14905[(42)]);
var inst_14732 = (state_14905[(43)]);
var inst_14719 = (state_14905[(9)]);
var inst_14591 = (state_14905[(44)]);
var inst_14566 = (state_14905[(45)]);
var inst_14582 = (state_14905[(46)]);
var inst_14570 = (state_14905[(47)]);
var inst_14694 = (state_14905[(48)]);
var inst_14742 = (function (){var no_filter_QMARK_ = inst_14719;
var t = inst_14699;
var max_limit_QMARK_ = inst_14693;
var next_node = inst_14722;
var fast_forward_db_QMARK_ = inst_14704;
var s1 = inst_14582;
var o2 = inst_14645;
var t1 = inst_14559;
var predicate_fn = inst_14572;
var i = inst_14724;
var map__14554 = inst_14685;
var m1 = inst_14672;
var root_node = inst_14709;
var s2 = inst_14591;
var vec__14548 = inst_14623;
var p2 = inst_14663;
var permissions = inst_14694;
var limit = inst_14692;
var start_flake = inst_14682;
var flake_limit = inst_14686;
var offset = inst_14723;
var acc = inst_14726;
var t2 = inst_14566;
var op1 = inst_14560;
var o1 = inst_14636;
var vec__14544 = inst_14562;
var end_flake = inst_14683;
var base_result = inst_14732;
var s = inst_14725;
var node_start = inst_14713;
var p1 = inst_14654;
var subject_fn = inst_14571;
var object_fn = inst_14627;
var idx_compare = inst_14698;
var G__14733 = inst_14740;
var map__14547 = inst_14570;
var op2 = inst_14567;
var m2 = inst_14681;
var vec__14541 = inst_14555;
var vec__14551 = inst_14624;
var novelty = inst_14703;
return (function (p1__14523_SHARP_){
var G__14915 = p1__14523_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14915) : subject_fn.call(null,G__14915));
});
})();
var inst_14743 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14742,inst_14740);
var state_14905__$1 = state_14905;
var statearr_14916_15109 = state_14905__$1;
(statearr_14916_15109[(2)] = inst_14743);

(statearr_14916_15109[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (110))){
var inst_14874 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14917_15110 = state_14905__$1;
(statearr_14917_15110[(2)] = inst_14874);

(statearr_14917_15110[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (7))){
var inst_14556 = (state_14905[(49)]);
var state_14905__$1 = state_14905;
var statearr_14918_15111 = state_14905__$1;
(statearr_14918_15111[(2)] = inst_14556);

(statearr_14918_15111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (59))){
var state_14905__$1 = state_14905;
var statearr_14919_15112 = state_14905__$1;
(statearr_14919_15112[(2)] = fluree.db.util.core.max_long);

(statearr_14919_15112[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (86))){
var inst_14719 = (state_14905[(9)]);
var state_14905__$1 = state_14905;
var statearr_14920_15113 = state_14905__$1;
(statearr_14920_15113[(2)] = inst_14719);

(statearr_14920_15113[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (20))){
var state_14905__$1 = state_14905;
var statearr_14921_15114 = state_14905__$1;
(statearr_14921_15114[(2)] = null);

(statearr_14921_15114[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (72))){
var inst_14732 = (state_14905[(43)]);
var state_14905__$1 = state_14905;
var statearr_14922_15115 = state_14905__$1;
(statearr_14922_15115[(2)] = inst_14732);

(statearr_14922_15115[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (58))){
var inst_14687 = (state_14905[(50)]);
var state_14905__$1 = state_14905;
var statearr_14923_15116 = state_14905__$1;
(statearr_14923_15116[(2)] = inst_14687);

(statearr_14923_15116[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (60))){
var inst_14692 = (state_14905[(35)]);
var inst_14692__$1 = (state_14905[(2)]);
var inst_14693 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14692__$1,fluree.db.util.core.max_long);
var inst_14694 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14696 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14697 = (new cljs.core.PersistentVector(null,3,(5),inst_14695,inst_14696,null));
var inst_14698 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14697);
var inst_14699 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14701 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14702 = (new cljs.core.PersistentVector(null,2,(5),inst_14700,inst_14701,null));
var inst_14703 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14702);
var inst_14704 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14705 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14706 = fluree.db.dbproto._resolve(inst_14705);
var state_14905__$1 = (function (){var statearr_14924 = state_14905;
(statearr_14924[(14)] = inst_14699);

(statearr_14924[(23)] = inst_14703);

(statearr_14924[(29)] = inst_14693);

(statearr_14924[(35)] = inst_14692__$1);

(statearr_14924[(37)] = inst_14698);

(statearr_14924[(41)] = inst_14704);

(statearr_14924[(48)] = inst_14694);

return statearr_14924;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(61),inst_14706);
} else {
if((state_val_14906 === (27))){
var inst_14625 = (state_14905[(51)]);
var state_14905__$1 = state_14905;
var statearr_14925_15117 = state_14905__$1;
(statearr_14925_15117[(2)] = inst_14625);

(statearr_14925_15117[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (1))){
var state_14905__$1 = state_14905;
var statearr_14926_15118 = state_14905__$1;
(statearr_14926_15118[(2)] = null);

(statearr_14926_15118[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (69))){
var inst_14722 = (state_14905[(21)]);
var inst_14683 = (state_14905[(24)]);
var inst_14682 = (state_14905[(38)]);
var inst_14731 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14722);
var inst_14732 = fluree.db.flake.subrange(inst_14731,start_test,inst_14682,end_test,inst_14683);
var inst_14734 = fluree.db.query.range.value_with_nil_pred(idx,inst_14682,inst_14683);
var state_14905__$1 = (function (){var statearr_14927 = state_14905;
(statearr_14927[(43)] = inst_14732);

return statearr_14927;
})();
if(inst_14734){
var statearr_14928_15119 = state_14905__$1;
(statearr_14928_15119[(1)] = (71));

} else {
var statearr_14929_15120 = state_14905__$1;
(statearr_14929_15120[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (101))){
var inst_14820 = (state_14905[(52)]);
var inst_14819 = (state_14905[(53)]);
var inst_14686 = (state_14905[(40)]);
var inst_14818 = (state_14905[(54)]);
var inst_14823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14824 = (inst_14820 - inst_14686);
var inst_14825 = (inst_14819 - inst_14824);
var inst_14826 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14825,inst_14818);
var inst_14827 = [inst_14686,inst_14826];
var inst_14828 = (new cljs.core.PersistentVector(null,2,(5),inst_14823,inst_14827,null));
var state_14905__$1 = state_14905;
var statearr_14930_15121 = state_14905__$1;
(statearr_14930_15121[(2)] = inst_14828);

(statearr_14930_15121[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (24))){
var inst_14568 = (state_14905[(55)]);
var inst_14562 = (state_14905[(11)]);
var inst_14565 = (state_14905[(56)]);
var inst_14560 = (state_14905[(15)]);
var inst_14558 = (state_14905[(57)]);
var inst_14561 = (state_14905[(58)]);
var inst_14557 = (state_14905[(59)]);
var inst_14564 = (state_14905[(60)]);
var inst_14559 = (state_14905[(25)]);
var inst_14567 = (state_14905[(28)]);
var inst_14571 = (state_14905[(32)]);
var inst_14572 = (state_14905[(39)]);
var inst_14555 = (state_14905[(42)]);
var inst_14605 = (state_14905[(61)]);
var inst_14591 = (state_14905[(44)]);
var inst_14566 = (state_14905[(45)]);
var inst_14582 = (state_14905[(46)]);
var inst_14570 = (state_14905[(47)]);
var inst_14573 = (state_14905[(62)]);
var inst_14615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14617 = [null,null];
var inst_14618 = (new cljs.core.PersistentVector(null,2,(5),inst_14616,inst_14617,null));
var inst_14619 = (function (){var bool = inst_14605;
var s1 = inst_14582;
var o2 = inst_14565;
var t1 = inst_14559;
var predicate_fn = inst_14572;
var m1 = inst_14561;
var s2 = inst_14591;
var p2 = inst_14564;
var t2 = inst_14566;
var op1 = inst_14560;
var o1 = inst_14558;
var vec__14544 = inst_14562;
var p1 = inst_14557;
var subject_fn = inst_14571;
var object_fn = inst_14573;
var map__14547 = inst_14570;
var op2 = inst_14567;
var m2 = inst_14568;
var vec__14541 = inst_14555;
var temp__5755__auto__ = inst_14605;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_14620 = [inst_14618,inst_14619];
var inst_14621 = (new cljs.core.PersistentVector(null,2,(5),inst_14615,inst_14620,null));
var state_14905__$1 = state_14905;
var statearr_14931_15122 = state_14905__$1;
(statearr_14931_15122[(2)] = inst_14621);

(statearr_14931_15122[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (102))){
var inst_14820 = (state_14905[(52)]);
var inst_14818 = (state_14905[(54)]);
var inst_14830 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14831 = [inst_14820,inst_14818];
var inst_14832 = (new cljs.core.PersistentVector(null,2,(5),inst_14830,inst_14831,null));
var state_14905__$1 = state_14905;
var statearr_14932_15123 = state_14905__$1;
(statearr_14932_15123[(2)] = inst_14832);

(statearr_14932_15123[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (55))){
var state_14905__$1 = state_14905;
var statearr_14933_15124 = state_14905__$1;
(statearr_14933_15124[(2)] = (2147483647));

(statearr_14933_15124[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (85))){
var inst_14768 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
if(cljs.core.truth_(inst_14768)){
var statearr_14934_15125 = state_14905__$1;
(statearr_14934_15125[(1)] = (89));

} else {
var statearr_14935_15126 = state_14905__$1;
(statearr_14935_15126[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (39))){
var inst_14564 = (state_14905[(60)]);
var inst_14655 = (state_14905[(63)]);
var inst_14654 = (state_14905[(2)]);
var inst_14655__$1 = (inst_14564 == null);
var state_14905__$1 = (function (){var statearr_14936 = state_14905;
(statearr_14936[(34)] = inst_14654);

(statearr_14936[(63)] = inst_14655__$1);

return statearr_14936;
})();
if(cljs.core.truth_(inst_14655__$1)){
var statearr_14937_15127 = state_14905__$1;
(statearr_14937_15127[(1)] = (40));

} else {
var statearr_14938_15128 = state_14905__$1;
(statearr_14938_15128[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (88))){
var inst_14765 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14939_15129 = state_14905__$1;
(statearr_14939_15129[(2)] = inst_14765);

(statearr_14939_15129[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (46))){
var inst_14561 = (state_14905[(58)]);
var state_14905__$1 = state_14905;
var statearr_14940_15130 = state_14905__$1;
(statearr_14940_15130[(2)] = inst_14561);

(statearr_14940_15130[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (4))){
var inst_14535 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14941_15131 = state_14905__$1;
(statearr_14941_15131[(2)] = inst_14535);

(statearr_14941_15131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (77))){
var inst_14624 = (state_14905[(10)]);
var inst_14562 = (state_14905[(11)]);
var inst_14627 = (state_14905[(12)]);
var inst_14636 = (state_14905[(13)]);
var inst_14699 = (state_14905[(14)]);
var inst_14560 = (state_14905[(15)]);
var inst_14725 = (state_14905[(16)]);
var inst_14746 = (state_14905[(64)]);
var inst_14724 = (state_14905[(17)]);
var inst_14623 = (state_14905[(18)]);
var inst_14709 = (state_14905[(20)]);
var inst_14722 = (state_14905[(21)]);
var inst_14726 = (state_14905[(22)]);
var inst_14703 = (state_14905[(23)]);
var inst_14683 = (state_14905[(24)]);
var inst_14559 = (state_14905[(25)]);
var inst_14645 = (state_14905[(26)]);
var inst_14672 = (state_14905[(27)]);
var inst_14567 = (state_14905[(28)]);
var inst_14693 = (state_14905[(29)]);
var inst_14681 = (state_14905[(30)]);
var inst_14723 = (state_14905[(31)]);
var inst_14571 = (state_14905[(32)]);
var inst_14713 = (state_14905[(8)]);
var inst_14685 = (state_14905[(33)]);
var inst_14654 = (state_14905[(34)]);
var inst_14692 = (state_14905[(35)]);
var inst_14663 = (state_14905[(36)]);
var inst_14698 = (state_14905[(37)]);
var inst_14682 = (state_14905[(38)]);
var inst_14572 = (state_14905[(39)]);
var inst_14686 = (state_14905[(40)]);
var inst_14704 = (state_14905[(41)]);
var inst_14555 = (state_14905[(42)]);
var inst_14732 = (state_14905[(43)]);
var inst_14719 = (state_14905[(9)]);
var inst_14591 = (state_14905[(44)]);
var inst_14566 = (state_14905[(45)]);
var inst_14582 = (state_14905[(46)]);
var inst_14570 = (state_14905[(47)]);
var inst_14694 = (state_14905[(48)]);
var inst_14748 = (function (){var no_filter_QMARK_ = inst_14719;
var t = inst_14699;
var max_limit_QMARK_ = inst_14693;
var next_node = inst_14722;
var fast_forward_db_QMARK_ = inst_14704;
var s1 = inst_14582;
var o2 = inst_14645;
var t1 = inst_14559;
var predicate_fn = inst_14572;
var i = inst_14724;
var map__14554 = inst_14685;
var m1 = inst_14672;
var root_node = inst_14709;
var s2 = inst_14591;
var vec__14548 = inst_14623;
var p2 = inst_14663;
var permissions = inst_14694;
var limit = inst_14692;
var start_flake = inst_14682;
var flake_limit = inst_14686;
var offset = inst_14723;
var acc = inst_14726;
var t2 = inst_14566;
var op1 = inst_14560;
var o1 = inst_14636;
var vec__14544 = inst_14562;
var end_flake = inst_14683;
var base_result = inst_14732;
var s = inst_14725;
var node_start = inst_14713;
var p1 = inst_14654;
var subject_fn = inst_14571;
var object_fn = inst_14627;
var idx_compare = inst_14698;
var G__14733 = inst_14746;
var map__14547 = inst_14570;
var op2 = inst_14567;
var m2 = inst_14681;
var vec__14541 = inst_14555;
var vec__14551 = inst_14624;
var novelty = inst_14703;
return (function (p1__14524_SHARP_){
var G__14942 = p1__14524_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14942) : predicate_fn.call(null,G__14942));
});
})();
var inst_14749 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14748,inst_14746);
var state_14905__$1 = state_14905;
var statearr_14943_15132 = state_14905__$1;
(statearr_14943_15132[(2)] = inst_14749);

(statearr_14943_15132[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (106))){
var inst_14759 = (state_14905[(65)]);
var state_14905__$1 = state_14905;
var statearr_14944_15133 = state_14905__$1;
(statearr_14944_15133[(2)] = inst_14759);

(statearr_14944_15133[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (119))){
var inst_14877 = (state_14905[(66)]);
var state_14905__$1 = state_14905;
var statearr_14945_15134 = state_14905__$1;
(statearr_14945_15134[(2)] = inst_14877);

(statearr_14945_15134[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (95))){
var inst_14792 = (state_14905[(67)]);
var inst_14725 = (state_14905[(16)]);
var inst_14801 = (state_14905[(68)]);
var inst_14802 = (state_14905[(69)]);
var inst_14692 = (state_14905[(35)]);
var inst_14800 = (state_14905[(70)]);
var inst_14800__$1 = cljs.core.count(inst_14792);
var inst_14801__$1 = (inst_14725 + inst_14800__$1);
var inst_14802__$1 = (inst_14801__$1 - inst_14692);
var inst_14803 = cljs.core.pos_int_QMARK_(inst_14802__$1);
var state_14905__$1 = (function (){var statearr_14946 = state_14905;
(statearr_14946[(68)] = inst_14801__$1);

(statearr_14946[(69)] = inst_14802__$1);

(statearr_14946[(70)] = inst_14800__$1);

return statearr_14946;
})();
if(inst_14803){
var statearr_14947_15135 = state_14905__$1;
(statearr_14947_15135[(1)] = (98));

} else {
var statearr_14948_15136 = state_14905__$1;
(statearr_14948_15136[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (54))){
var inst_14636 = (state_14905[(13)]);
var inst_14560 = (state_14905[(15)]);
var inst_14559 = (state_14905[(25)]);
var inst_14645 = (state_14905[(26)]);
var inst_14672 = (state_14905[(27)]);
var inst_14567 = (state_14905[(28)]);
var inst_14681 = (state_14905[(30)]);
var inst_14687 = (state_14905[(50)]);
var inst_14685 = (state_14905[(33)]);
var inst_14654 = (state_14905[(34)]);
var inst_14663 = (state_14905[(36)]);
var inst_14591 = (state_14905[(44)]);
var inst_14566 = (state_14905[(45)]);
var inst_14582 = (state_14905[(46)]);
var inst_14681__$1 = (state_14905[(2)]);
var inst_14682 = fluree.db.flake.__GT_Flake(inst_14582,inst_14654,inst_14636,inst_14559,inst_14560,inst_14672);
var inst_14683 = fluree.db.flake.__GT_Flake(inst_14591,inst_14663,inst_14645,inst_14566,inst_14567,inst_14681__$1);
var inst_14684 = opts;
var inst_14685__$1 = cljs.core.__destructure_map(inst_14684);
var inst_14686 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14685__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14687__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14685__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14688 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14685__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14905__$1 = (function (){var statearr_14949 = state_14905;
(statearr_14949[(71)] = inst_14688);

(statearr_14949[(24)] = inst_14683);

(statearr_14949[(30)] = inst_14681__$1);

(statearr_14949[(50)] = inst_14687__$1);

(statearr_14949[(33)] = inst_14685__$1);

(statearr_14949[(38)] = inst_14682);

(statearr_14949[(40)] = inst_14686);

return statearr_14949;
})();
if(cljs.core.truth_(inst_14687__$1)){
var statearr_14950_15137 = state_14905__$1;
(statearr_14950_15137[(1)] = (58));

} else {
var statearr_14951_15138 = state_14905__$1;
(statearr_14951_15138[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (92))){
var inst_14781 = (state_14905[(72)]);
var inst_14725 = (state_14905[(16)]);
var inst_14724 = (state_14905[(17)]);
var inst_14726 = (state_14905[(22)]);
var inst_14723 = (state_14905[(31)]);
var inst_14784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14785 = (inst_14723 - inst_14781);
var inst_14786 = [inst_14785,inst_14724,inst_14725,inst_14726];
var inst_14787 = (new cljs.core.PersistentVector(null,4,(5),inst_14784,inst_14786,null));
var state_14905__$1 = state_14905;
var statearr_14952_15139 = state_14905__$1;
(statearr_14952_15139[(2)] = inst_14787);

(statearr_14952_15139[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (104))){
var inst_14843 = (state_14905[(2)]);
var inst_14844 = fluree.db.util.async.throw_err(inst_14843);
var state_14905__$1 = state_14905;
var statearr_14953_15140 = state_14905__$1;
(statearr_14953_15140[(2)] = inst_14844);

(statearr_14953_15140[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (15))){
var inst_14565 = (state_14905[(56)]);
var inst_14595 = cljs.core.boolean_QMARK_(inst_14565);
var state_14905__$1 = state_14905;
if(inst_14595){
var statearr_14954_15141 = state_14905__$1;
(statearr_14954_15141[(1)] = (17));

} else {
var statearr_14955_15142 = state_14905__$1;
(statearr_14955_15142[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (48))){
var inst_14568 = (state_14905[(55)]);
var inst_14672 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_14956 = state_14905;
(statearr_14956[(27)] = inst_14672);

return statearr_14956;
})();
if(cljs.core.truth_(inst_14568)){
var statearr_14957_15143 = state_14905__$1;
(statearr_14957_15143[(1)] = (52));

} else {
var statearr_14958_15144 = state_14905__$1;
(statearr_14958_15144[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (50))){
var state_14905__$1 = state_14905;
var statearr_14959_15145 = state_14905__$1;
(statearr_14959_15145[(2)] = (2147483647));

(statearr_14959_15145[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (116))){
var inst_14877 = (state_14905[(66)]);
var inst_14885 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_14960 = state_14905;
(statearr_14960[(73)] = inst_14885);

return statearr_14960;
})();
if(cljs.core.truth_(inst_14877)){
var statearr_14961_15146 = state_14905__$1;
(statearr_14961_15146[(1)] = (118));

} else {
var statearr_14962_15147 = state_14905__$1;
(statearr_14962_15147[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (75))){
var inst_14740 = (state_14905[(19)]);
var state_14905__$1 = state_14905;
var statearr_14963_15148 = state_14905__$1;
(statearr_14963_15148[(2)] = inst_14740);

(statearr_14963_15148[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (99))){
var inst_14801 = (state_14905[(68)]);
var inst_14810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14811 = [inst_14801,inst_14801];
var inst_14812 = (new cljs.core.PersistentVector(null,2,(5),inst_14810,inst_14811,null));
var state_14905__$1 = state_14905;
var statearr_14964_15149 = state_14905__$1;
(statearr_14964_15149[(2)] = inst_14812);

(statearr_14964_15149[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (21))){
var state_14905__$1 = state_14905;
var statearr_14965_15150 = state_14905__$1;
(statearr_14965_15150[(2)] = null);

(statearr_14965_15150[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (31))){
var inst_14626 = (state_14905[(74)]);
var state_14905__$1 = state_14905;
var statearr_14966_15151 = state_14905__$1;
(statearr_14966_15151[(2)] = inst_14626);

(statearr_14966_15151[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (113))){
var inst_14871 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14967_15152 = state_14905__$1;
(statearr_14967_15152[(2)] = inst_14871);

(statearr_14967_15152[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (32))){
var inst_14646 = (state_14905[(75)]);
var inst_14557 = (state_14905[(59)]);
var inst_14645 = (state_14905[(2)]);
var inst_14646__$1 = (inst_14557 == null);
var state_14905__$1 = (function (){var statearr_14968 = state_14905;
(statearr_14968[(75)] = inst_14646__$1);

(statearr_14968[(26)] = inst_14645);

return statearr_14968;
})();
if(cljs.core.truth_(inst_14646__$1)){
var statearr_14969_15153 = state_14905__$1;
(statearr_14969_15153[(1)] = (34));

} else {
var statearr_14970_15154 = state_14905__$1;
(statearr_14970_15154[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (40))){
var inst_14645 = (state_14905[(26)]);
var state_14905__$1 = state_14905;
var statearr_14971_15155 = state_14905__$1;
(statearr_14971_15155[(2)] = inst_14645);

(statearr_14971_15155[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (91))){
var inst_14759 = (state_14905[(65)]);
var inst_14857 = (state_14905[(2)]);
var inst_14858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14857,(0),null);
var inst_14859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14857,(1),null);
var inst_14860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14857,(2),null);
var inst_14861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14857,(3),null);
var state_14905__$1 = (function (){var statearr_14972 = state_14905;
(statearr_14972[(76)] = inst_14858);

(statearr_14972[(7)] = inst_14861);

(statearr_14972[(77)] = inst_14860);

(statearr_14972[(78)] = inst_14859);

return statearr_14972;
})();
if(cljs.core.truth_(inst_14759)){
var statearr_14973_15156 = state_14905__$1;
(statearr_14973_15156[(1)] = (105));

} else {
var statearr_14974_15157 = state_14905__$1;
(statearr_14974_15157[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (117))){
var inst_14881 = (state_14905[(2)]);
var inst_14882 = fluree.db.util.async.throw_err(inst_14881);
var state_14905__$1 = state_14905;
var statearr_14975_15158 = state_14905__$1;
(statearr_14975_15158[(2)] = inst_14882);

(statearr_14975_15158[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (108))){
var inst_14866 = (state_14905[(79)]);
var inst_14686 = (state_14905[(40)]);
var inst_14859 = (state_14905[(78)]);
var inst_14866__$1 = (inst_14859 < inst_14686);
var state_14905__$1 = (function (){var statearr_14976 = state_14905;
(statearr_14976[(79)] = inst_14866__$1);

return statearr_14976;
})();
if(cljs.core.truth_(inst_14866__$1)){
var statearr_14977_15159 = state_14905__$1;
(statearr_14977_15159[(1)] = (111));

} else {
var statearr_14978_15160 = state_14905__$1;
(statearr_14978_15160[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (56))){
var state_14905__$1 = state_14905;
var statearr_14979_15161 = state_14905__$1;
(statearr_14979_15161[(2)] = fluree.db.util.core.min_integer);

(statearr_14979_15161[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (33))){
var inst_14641 = (state_14905[(2)]);
var inst_14642 = fluree.db.util.async.throw_err(inst_14641);
var state_14905__$1 = state_14905;
var statearr_14980_15162 = state_14905__$1;
(statearr_14980_15162[(2)] = inst_14642);

(statearr_14980_15162[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (13))){
var inst_14587 = (state_14905[(2)]);
var inst_14588 = fluree.db.util.async.throw_err(inst_14587);
var state_14905__$1 = state_14905;
var statearr_14981_15163 = state_14905__$1;
(statearr_14981_15163[(2)] = inst_14588);

(statearr_14981_15163[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (22))){
var inst_14601 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_14982_15164 = state_14905__$1;
(statearr_14982_15164[(2)] = inst_14601);

(statearr_14982_15164[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (90))){
var inst_14624 = (state_14905[(10)]);
var inst_14562 = (state_14905[(11)]);
var inst_14781 = (state_14905[(72)]);
var inst_14627 = (state_14905[(12)]);
var inst_14636 = (state_14905[(13)]);
var inst_14699 = (state_14905[(14)]);
var inst_14560 = (state_14905[(15)]);
var inst_14725 = (state_14905[(16)]);
var inst_14724 = (state_14905[(17)]);
var inst_14623 = (state_14905[(18)]);
var inst_14709 = (state_14905[(20)]);
var inst_14722 = (state_14905[(21)]);
var inst_14726 = (state_14905[(22)]);
var inst_14703 = (state_14905[(23)]);
var inst_14683 = (state_14905[(24)]);
var inst_14759 = (state_14905[(65)]);
var inst_14559 = (state_14905[(25)]);
var inst_14645 = (state_14905[(26)]);
var inst_14672 = (state_14905[(27)]);
var inst_14567 = (state_14905[(28)]);
var inst_14693 = (state_14905[(29)]);
var inst_14681 = (state_14905[(30)]);
var inst_14723 = (state_14905[(31)]);
var inst_14571 = (state_14905[(32)]);
var inst_14713 = (state_14905[(8)]);
var inst_14685 = (state_14905[(33)]);
var inst_14654 = (state_14905[(34)]);
var inst_14692 = (state_14905[(35)]);
var inst_14663 = (state_14905[(36)]);
var inst_14698 = (state_14905[(37)]);
var inst_14682 = (state_14905[(38)]);
var inst_14572 = (state_14905[(39)]);
var inst_14686 = (state_14905[(40)]);
var inst_14704 = (state_14905[(41)]);
var inst_14780 = (state_14905[(80)]);
var inst_14555 = (state_14905[(42)]);
var inst_14732 = (state_14905[(43)]);
var inst_14758 = (state_14905[(81)]);
var inst_14719 = (state_14905[(9)]);
var inst_14591 = (state_14905[(44)]);
var inst_14566 = (state_14905[(45)]);
var inst_14582 = (state_14905[(46)]);
var inst_14570 = (state_14905[(47)]);
var inst_14694 = (state_14905[(48)]);
var inst_14779 = (function (){var no_filter_QMARK_ = inst_14719;
var base_result_SINGLEQUOTE_ = inst_14758;
var t = inst_14699;
var max_limit_QMARK_ = inst_14693;
var next_node = inst_14722;
var fast_forward_db_QMARK_ = inst_14704;
var s1 = inst_14582;
var o2 = inst_14645;
var t1 = inst_14559;
var predicate_fn = inst_14572;
var i = inst_14724;
var rhs = inst_14759;
var map__14554 = inst_14685;
var m1 = inst_14672;
var root_node = inst_14709;
var s2 = inst_14591;
var vec__14548 = inst_14623;
var p2 = inst_14663;
var permissions = inst_14694;
var limit = inst_14692;
var start_flake = inst_14682;
var flake_limit = inst_14686;
var offset = inst_14723;
var acc = inst_14726;
var t2 = inst_14566;
var op1 = inst_14560;
var o1 = inst_14636;
var vec__14544 = inst_14562;
var end_flake = inst_14683;
var base_result = inst_14732;
var s = inst_14725;
var node_start = inst_14713;
var p1 = inst_14654;
var subject_fn = inst_14571;
var object_fn = inst_14627;
var idx_compare = inst_14698;
var map__14547 = inst_14570;
var op2 = inst_14567;
var m2 = inst_14681;
var vec__14541 = inst_14555;
var vec__14551 = inst_14624;
var novelty = inst_14703;
return (function (p1__14526_SHARP_){
return p1__14526_SHARP_.s;
});
})();
var inst_14780__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_14779,inst_14758);
var inst_14781__$1 = cljs.core.count(inst_14780__$1);
var inst_14782 = (inst_14723 > inst_14781__$1);
var state_14905__$1 = (function (){var statearr_14983 = state_14905;
(statearr_14983[(72)] = inst_14781__$1);

(statearr_14983[(80)] = inst_14780__$1);

return statearr_14983;
})();
if(cljs.core.truth_(inst_14782)){
var statearr_14984_15165 = state_14905__$1;
(statearr_14984_15165[(1)] = (92));

} else {
var statearr_14985_15166 = state_14905__$1;
(statearr_14985_15166[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (109))){
var inst_14864 = (state_14905[(82)]);
var state_14905__$1 = state_14905;
var statearr_14986_15167 = state_14905__$1;
(statearr_14986_15167[(2)] = inst_14864);

(statearr_14986_15167[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (36))){
var inst_14650 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
if(cljs.core.truth_(inst_14650)){
var statearr_14987_15168 = state_14905__$1;
(statearr_14987_15168[(1)] = (37));

} else {
var statearr_14988_15169 = state_14905__$1;
(statearr_14988_15169[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (41))){
var inst_14655 = (state_14905[(63)]);
var state_14905__$1 = state_14905;
var statearr_14989_15170 = state_14905__$1;
(statearr_14989_15170[(2)] = inst_14655);

(statearr_14989_15170[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (118))){
var inst_14885 = (state_14905[(73)]);
var state_14905__$1 = state_14905;
var statearr_14990_15171 = state_14905__$1;
(statearr_14990_15171[(2)] = inst_14885);

(statearr_14990_15171[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (89))){
var inst_14725 = (state_14905[(16)]);
var inst_14724 = (state_14905[(17)]);
var inst_14726 = (state_14905[(22)]);
var inst_14686 = (state_14905[(40)]);
var inst_14758 = (state_14905[(81)]);
var inst_14770 = cljs.core.count(inst_14758);
var inst_14771 = (inst_14686 - inst_14724);
var inst_14772 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14771,inst_14758);
var inst_14773 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14726,inst_14772);
var inst_14774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14775 = (inst_14724 + inst_14770);
var inst_14776 = [(0),inst_14775,inst_14725,inst_14773];
var inst_14777 = (new cljs.core.PersistentVector(null,4,(5),inst_14774,inst_14776,null));
var state_14905__$1 = state_14905;
var statearr_14991_15172 = state_14905__$1;
(statearr_14991_15172[(2)] = inst_14777);

(statearr_14991_15172[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (100))){
var inst_14820 = (state_14905[(52)]);
var inst_14792 = (state_14905[(67)]);
var inst_14819 = (state_14905[(53)]);
var inst_14724 = (state_14905[(17)]);
var inst_14686 = (state_14905[(40)]);
var inst_14818 = (state_14905[(54)]);
var inst_14814 = (state_14905[(2)]);
var inst_14815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14814,(0),null);
var inst_14816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14814,(1),null);
var inst_14817 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14816,inst_14792);
var inst_14818__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_14817);
var inst_14819__$1 = cljs.core.count(inst_14818__$1);
var inst_14820__$1 = (inst_14724 + inst_14819__$1);
var inst_14821 = (inst_14820__$1 > inst_14686);
var state_14905__$1 = (function (){var statearr_14992 = state_14905;
(statearr_14992[(52)] = inst_14820__$1);

(statearr_14992[(53)] = inst_14819__$1);

(statearr_14992[(83)] = inst_14815);

(statearr_14992[(54)] = inst_14818__$1);

return statearr_14992;
})();
if(cljs.core.truth_(inst_14821)){
var statearr_14993_15173 = state_14905__$1;
(statearr_14993_15173[(1)] = (101));

} else {
var statearr_14994_15174 = state_14905__$1;
(statearr_14994_15174[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (122))){
var inst_14858 = (state_14905[(76)]);
var inst_14861 = (state_14905[(7)]);
var inst_14860 = (state_14905[(77)]);
var inst_14885 = (state_14905[(73)]);
var inst_14859 = (state_14905[(78)]);
var inst_14722 = inst_14885;
var inst_14723 = inst_14858;
var inst_14724 = inst_14859;
var inst_14725 = inst_14860;
var inst_14726 = inst_14861;
var state_14905__$1 = (function (){var statearr_14995 = state_14905;
(statearr_14995[(16)] = inst_14725);

(statearr_14995[(17)] = inst_14724);

(statearr_14995[(21)] = inst_14722);

(statearr_14995[(22)] = inst_14726);

(statearr_14995[(31)] = inst_14723);

return statearr_14995;
})();
var statearr_14996_15175 = state_14905__$1;
(statearr_14996_15175[(2)] = null);

(statearr_14996_15175[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (43))){
var state_14905__$1 = state_14905;
var statearr_14997_15176 = state_14905__$1;
(statearr_14997_15176[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14997_15176[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (61))){
var inst_14699 = (state_14905[(14)]);
var inst_14709 = (state_14905[(20)]);
var inst_14703 = (state_14905[(23)]);
var inst_14682 = (state_14905[(38)]);
var inst_14704 = (state_14905[(41)]);
var inst_14708 = (state_14905[(2)]);
var inst_14709__$1 = fluree.db.util.async.throw_err(inst_14708);
var inst_14710 = fluree.db.query.range.find_next_valid_node(inst_14709__$1,inst_14682,inst_14699,inst_14703,inst_14704);
var state_14905__$1 = (function (){var statearr_14998 = state_14905;
(statearr_14998[(20)] = inst_14709__$1);

return statearr_14998;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(62),inst_14710);
} else {
if((state_val_14906 === (29))){
var inst_14632 = (state_14905[(2)]);
var inst_14633 = fluree.db.util.async.throw_err(inst_14632);
var state_14905__$1 = state_14905;
var statearr_14999_15177 = state_14905__$1;
(statearr_14999_15177[(2)] = inst_14633);

(statearr_14999_15177[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (44))){
var inst_14564 = (state_14905[(60)]);
var state_14905__$1 = state_14905;
var statearr_15000_15178 = state_14905__$1;
(statearr_15000_15178[(2)] = inst_14564);

(statearr_15000_15178[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (93))){
var inst_14723 = (state_14905[(31)]);
var inst_14780 = (state_14905[(80)]);
var inst_14719 = (state_14905[(9)]);
var inst_14792 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_14723,inst_14780);
var state_14905__$1 = (function (){var statearr_15001 = state_14905;
(statearr_15001[(67)] = inst_14792);

return statearr_15001;
})();
if(cljs.core.truth_(inst_14719)){
var statearr_15002_15179 = state_14905__$1;
(statearr_15002_15179[(1)] = (95));

} else {
var statearr_15003_15180 = state_14905__$1;
(statearr_15003_15180[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (6))){
var inst_14556 = (state_14905[(49)]);
var inst_14576 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14556);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(9),inst_14576);
} else {
if((state_val_14906 === (111))){
var inst_14692 = (state_14905[(35)]);
var inst_14860 = (state_14905[(77)]);
var inst_14868 = (inst_14860 < inst_14692);
var state_14905__$1 = state_14905;
var statearr_15004_15181 = state_14905__$1;
(statearr_15004_15181[(2)] = inst_14868);

(statearr_15004_15181[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (28))){
var inst_14626 = (state_14905[(74)]);
var inst_14636 = (state_14905[(2)]);
var inst_14637 = fluree.db.util.core.pred_ident_QMARK_(inst_14626);
var state_14905__$1 = (function (){var statearr_15005 = state_14905;
(statearr_15005[(13)] = inst_14636);

return statearr_15005;
})();
if(inst_14637){
var statearr_15006_15182 = state_14905__$1;
(statearr_15006_15182[(1)] = (30));

} else {
var statearr_15007_15183 = state_14905__$1;
(statearr_15007_15183[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (64))){
var state_14905__$1 = state_14905;
var statearr_15008_15184 = state_14905__$1;
(statearr_15008_15184[(2)] = true);

(statearr_15008_15184[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (103))){
var inst_14815 = (state_14905[(83)]);
var inst_14834 = (state_14905[(2)]);
var inst_14835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14834,(0),null);
var inst_14836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14834,(1),null);
var inst_14837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14838 = [inst_14835,inst_14815,inst_14836];
var inst_14839 = (new cljs.core.PersistentVector(null,3,(5),inst_14837,inst_14838,null));
var state_14905__$1 = state_14905;
var statearr_15009_15185 = state_14905__$1;
(statearr_15009_15185[(2)] = inst_14839);

(statearr_15009_15185[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (51))){
var inst_14670 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_15010_15186 = state_14905__$1;
(statearr_15010_15186[(2)] = inst_14670);

(statearr_15010_15186[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (25))){
var inst_14624 = (state_14905[(10)]);
var inst_14623 = (state_14905[(18)]);
var inst_14625 = (state_14905[(51)]);
var inst_14623__$1 = (state_14905[(2)]);
var inst_14624__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14623__$1,(0),null);
var inst_14625__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14624__$1,(0),null);
var inst_14626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14624__$1,(1),null);
var inst_14627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14623__$1,(1),null);
var inst_14628 = fluree.db.util.core.pred_ident_QMARK_(inst_14625__$1);
var state_14905__$1 = (function (){var statearr_15011 = state_14905;
(statearr_15011[(10)] = inst_14624__$1);

(statearr_15011[(12)] = inst_14627);

(statearr_15011[(74)] = inst_14626);

(statearr_15011[(18)] = inst_14623__$1);

(statearr_15011[(51)] = inst_14625__$1);

return statearr_15011;
})();
if(inst_14628){
var statearr_15012_15187 = state_14905__$1;
(statearr_15012_15187[(1)] = (26));

} else {
var statearr_15013_15188 = state_14905__$1;
(statearr_15013_15188[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (34))){
var inst_14636 = (state_14905[(13)]);
var state_14905__$1 = state_14905;
var statearr_15014_15189 = state_14905__$1;
(statearr_15014_15189[(2)] = inst_14636);

(statearr_15014_15189[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (17))){
var inst_14565 = (state_14905[(56)]);
var state_14905__$1 = state_14905;
var statearr_15015_15190 = state_14905__$1;
(statearr_15015_15190[(2)] = inst_14565);

(statearr_15015_15190[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (3))){
var inst_14903 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14905__$1,inst_14903);
} else {
if((state_val_14906 === (12))){
var inst_14558 = (state_14905[(57)]);
var inst_14591 = (state_14905[(2)]);
var inst_14592 = cljs.core.boolean_QMARK_(inst_14558);
var state_14905__$1 = (function (){var statearr_15016 = state_14905;
(statearr_15016[(44)] = inst_14591);

return statearr_15016;
})();
if(inst_14592){
var statearr_15017_15191 = state_14905__$1;
(statearr_15017_15191[(1)] = (14));

} else {
var statearr_15018_15192 = state_14905__$1;
(statearr_15018_15192[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (2))){
var inst_14562 = (state_14905[(11)]);
var inst_14556 = (state_14905[(49)]);
var inst_14555 = (state_14905[(42)]);
var inst_14570 = (state_14905[(47)]);
var _ = (function (){var statearr_15019 = state_14905;
(statearr_15019[(4)] = cljs.core.cons((5),(state_14905[(4)])));

return statearr_15019;
})();
var inst_14555__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14556__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14555__$1,(0),null);
var inst_14557 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14555__$1,(1),null);
var inst_14558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14555__$1,(2),null);
var inst_14559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14555__$1,(3),null);
var inst_14560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14555__$1,(4),null);
var inst_14561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14555__$1,(5),null);
var inst_14562__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14562__$1,(0),null);
var inst_14564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14562__$1,(1),null);
var inst_14565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14562__$1,(2),null);
var inst_14566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14562__$1,(3),null);
var inst_14567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14562__$1,(4),null);
var inst_14568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14562__$1,(5),null);
var inst_14569 = opts;
var inst_14570__$1 = cljs.core.__destructure_map(inst_14569);
var inst_14571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14570__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14570__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14570__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14574 = fluree.db.util.core.pred_ident_QMARK_(inst_14556__$1);
var state_14905__$1 = (function (){var statearr_15020 = state_14905;
(statearr_15020[(55)] = inst_14568);

(statearr_15020[(11)] = inst_14562__$1);

(statearr_15020[(56)] = inst_14565);

(statearr_15020[(15)] = inst_14560);

(statearr_15020[(57)] = inst_14558);

(statearr_15020[(58)] = inst_14561);

(statearr_15020[(59)] = inst_14557);

(statearr_15020[(60)] = inst_14564);

(statearr_15020[(25)] = inst_14559);

(statearr_15020[(28)] = inst_14567);

(statearr_15020[(84)] = inst_14563);

(statearr_15020[(32)] = inst_14571);

(statearr_15020[(49)] = inst_14556__$1);

(statearr_15020[(39)] = inst_14572);

(statearr_15020[(42)] = inst_14555__$1);

(statearr_15020[(45)] = inst_14566);

(statearr_15020[(47)] = inst_14570__$1);

(statearr_15020[(62)] = inst_14573);

return statearr_15020;
})();
if(inst_14574){
var statearr_15021_15193 = state_14905__$1;
(statearr_15021_15193[(1)] = (6));

} else {
var statearr_15022_15194 = state_14905__$1;
(statearr_15022_15194[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (66))){
var inst_14688 = (state_14905[(71)]);
var inst_14713 = (state_14905[(8)]);
var inst_14721 = cljs.core.PersistentVector.EMPTY;
var inst_14722 = inst_14713;
var inst_14723 = inst_14688;
var inst_14724 = (0);
var inst_14725 = (0);
var inst_14726 = inst_14721;
var state_14905__$1 = (function (){var statearr_15023 = state_14905;
(statearr_15023[(16)] = inst_14725);

(statearr_15023[(17)] = inst_14724);

(statearr_15023[(21)] = inst_14722);

(statearr_15023[(22)] = inst_14726);

(statearr_15023[(31)] = inst_14723);

return statearr_15023;
})();
var statearr_15024_15195 = state_14905__$1;
(statearr_15024_15195[(2)] = null);

(statearr_15024_15195[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (107))){
var inst_14877 = (state_14905[(66)]);
var inst_14877__$1 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_15025 = state_14905;
(statearr_15025[(66)] = inst_14877__$1);

return statearr_15025;
})();
if(cljs.core.truth_(inst_14877__$1)){
var statearr_15026_15196 = state_14905__$1;
(statearr_15026_15196[(1)] = (114));

} else {
var statearr_15027_15197 = state_14905__$1;
(statearr_15027_15197[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (23))){
var inst_14565 = (state_14905[(56)]);
var inst_14558 = (state_14905[(57)]);
var inst_14573 = (state_14905[(62)]);
var inst_14608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14610 = [inst_14558,inst_14565];
var inst_14611 = (new cljs.core.PersistentVector(null,2,(5),inst_14609,inst_14610,null));
var inst_14612 = [inst_14611,inst_14573];
var inst_14613 = (new cljs.core.PersistentVector(null,2,(5),inst_14608,inst_14612,null));
var state_14905__$1 = state_14905;
var statearr_15028_15198 = state_14905__$1;
(statearr_15028_15198[(2)] = inst_14613);

(statearr_15028_15198[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (47))){
var inst_14666 = (cljs.core._GT__EQ_ === start_test);
var state_14905__$1 = state_14905;
if(cljs.core.truth_(inst_14666)){
var statearr_15029_15199 = state_14905__$1;
(statearr_15029_15199[(1)] = (49));

} else {
var statearr_15030_15200 = state_14905__$1;
(statearr_15030_15200[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (35))){
var inst_14646 = (state_14905[(75)]);
var state_14905__$1 = state_14905;
var statearr_15031_15201 = state_14905__$1;
(statearr_15031_15201[(2)] = inst_14646);

(statearr_15031_15201[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (82))){
var inst_14722 = (state_14905[(21)]);
var inst_14693 = (state_14905[(29)]);
var inst_14758 = (state_14905[(2)]);
var inst_14759 = fluree.db.dbproto._rhs(inst_14722);
var state_14905__$1 = (function (){var statearr_15032 = state_14905;
(statearr_15032[(65)] = inst_14759);

(statearr_15032[(81)] = inst_14758);

return statearr_15032;
})();
if(cljs.core.truth_(inst_14693)){
var statearr_15033_15202 = state_14905__$1;
(statearr_15033_15202[(1)] = (83));

} else {
var statearr_15034_15203 = state_14905__$1;
(statearr_15034_15203[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (76))){
var inst_14572 = (state_14905[(39)]);
var inst_14746 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_15035 = state_14905;
(statearr_15035[(64)] = inst_14746);

return statearr_15035;
})();
if(cljs.core.truth_(inst_14572)){
var statearr_15036_15204 = state_14905__$1;
(statearr_15036_15204[(1)] = (77));

} else {
var statearr_15037_15205 = state_14905__$1;
(statearr_15037_15205[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (97))){
var inst_14726 = (state_14905[(22)]);
var inst_14846 = (state_14905[(2)]);
var inst_14847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14846,(0),null);
var inst_14848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14846,(1),null);
var inst_14849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14846,(2),null);
var inst_14850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14851 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14726,inst_14849);
var inst_14852 = [(0),inst_14847,inst_14848,inst_14851];
var inst_14853 = (new cljs.core.PersistentVector(null,4,(5),inst_14850,inst_14852,null));
var state_14905__$1 = state_14905;
var statearr_15038_15206 = state_14905__$1;
(statearr_15038_15206[(2)] = inst_14853);

(statearr_15038_15206[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (19))){
var inst_14603 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_15039_15207 = state_14905__$1;
(statearr_15039_15207[(2)] = inst_14603);

(statearr_15039_15207[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (57))){
var inst_14679 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_15040_15208 = state_14905__$1;
(statearr_15040_15208[(2)] = inst_14679);

(statearr_15040_15208[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (68))){
var inst_14900 = (state_14905[(2)]);
var _ = (function (){var statearr_15041 = state_14905;
(statearr_15041[(4)] = cljs.core.rest((state_14905[(4)])));

return statearr_15041;
})();
var state_14905__$1 = state_14905;
var statearr_15042_15209 = state_14905__$1;
(statearr_15042_15209[(2)] = inst_14900);

(statearr_15042_15209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (11))){
var inst_14563 = (state_14905[(84)]);
var state_14905__$1 = state_14905;
var statearr_15043_15210 = state_14905__$1;
(statearr_15043_15210[(2)] = inst_14563);

(statearr_15043_15210[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (115))){
var state_14905__$1 = state_14905;
var statearr_15045_15211 = state_14905__$1;
(statearr_15045_15211[(2)] = null);

(statearr_15045_15211[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (9))){
var inst_14578 = (state_14905[(2)]);
var inst_14579 = fluree.db.util.async.throw_err(inst_14578);
var state_14905__$1 = state_14905;
var statearr_15046_15212 = state_14905__$1;
(statearr_15046_15212[(2)] = inst_14579);

(statearr_15046_15212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (5))){
var _ = (function (){var statearr_15047 = state_14905;
(statearr_15047[(4)] = cljs.core.rest((state_14905[(4)])));

return statearr_15047;
})();
var state_14905__$1 = state_14905;
var ex15044 = (state_14905__$1[(2)]);
var statearr_15048_15213 = state_14905__$1;
(statearr_15048_15213[(5)] = ex15044);


if((ex15044 instanceof Error)){
var statearr_15049_15214 = state_14905__$1;
(statearr_15049_15214[(1)] = (4));

(statearr_15049_15214[(5)] = null);

} else {
throw ex15044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (112))){
var inst_14866 = (state_14905[(79)]);
var state_14905__$1 = state_14905;
var statearr_15050_15215 = state_14905__$1;
(statearr_15050_15215[(2)] = inst_14866);

(statearr_15050_15215[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (83))){
var inst_14761 = (state_14905[(85)]);
var inst_14723 = (state_14905[(31)]);
var inst_14761__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14723);
var state_14905__$1 = (function (){var statearr_15051 = state_14905;
(statearr_15051[(85)] = inst_14761__$1);

return statearr_15051;
})();
if(inst_14761__$1){
var statearr_15052_15216 = state_14905__$1;
(statearr_15052_15216[(1)] = (86));

} else {
var statearr_15053_15217 = state_14905__$1;
(statearr_15053_15217[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (14))){
var inst_14558 = (state_14905[(57)]);
var state_14905__$1 = state_14905;
var statearr_15054_15218 = state_14905__$1;
(statearr_15054_15218[(2)] = inst_14558);

(statearr_15054_15218[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (45))){
var inst_14561 = (state_14905[(58)]);
var inst_14663 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_15055 = state_14905;
(statearr_15055[(36)] = inst_14663);

return statearr_15055;
})();
if(cljs.core.truth_(inst_14561)){
var statearr_15056_15219 = state_14905__$1;
(statearr_15056_15219[(1)] = (46));

} else {
var statearr_15057_15220 = state_14905__$1;
(statearr_15057_15220[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (53))){
var inst_14675 = (cljs.core._LT__EQ_ === end_test);
var state_14905__$1 = state_14905;
if(cljs.core.truth_(inst_14675)){
var statearr_15058_15221 = state_14905__$1;
(statearr_15058_15221[(1)] = (55));

} else {
var statearr_15059_15222 = state_14905__$1;
(statearr_15059_15222[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (78))){
var inst_14746 = (state_14905[(64)]);
var state_14905__$1 = state_14905;
var statearr_15060_15223 = state_14905__$1;
(statearr_15060_15223[(2)] = inst_14746);

(statearr_15060_15223[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (26))){
var inst_14625 = (state_14905[(51)]);
var inst_14630 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14625);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(29),inst_14630);
} else {
if((state_val_14906 === (123))){
var inst_14895 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_15061_15224 = state_14905__$1;
(statearr_15061_15224[(2)] = inst_14895);

(statearr_15061_15224[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (16))){
var inst_14605 = (state_14905[(61)]);
var inst_14605__$1 = (state_14905[(2)]);
var inst_14606 = (inst_14605__$1 == null);
var state_14905__$1 = (function (){var statearr_15062 = state_14905;
(statearr_15062[(61)] = inst_14605__$1);

return statearr_15062;
})();
if(cljs.core.truth_(inst_14606)){
var statearr_15063_15225 = state_14905__$1;
(statearr_15063_15225[(1)] = (23));

} else {
var statearr_15064_15226 = state_14905__$1;
(statearr_15064_15226[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (81))){
var inst_14752 = (state_14905[(86)]);
var state_14905__$1 = state_14905;
var statearr_15065_15227 = state_14905__$1;
(statearr_15065_15227[(2)] = inst_14752);

(statearr_15065_15227[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (120))){
var inst_14889 = (state_14905[(2)]);
var inst_14890 = cljs.core.not(inst_14889);
var state_14905__$1 = state_14905;
if(inst_14890){
var statearr_15066_15228 = state_14905__$1;
(statearr_15066_15228[(1)] = (121));

} else {
var statearr_15067_15229 = state_14905__$1;
(statearr_15067_15229[(1)] = (122));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (79))){
var inst_14627 = (state_14905[(12)]);
var inst_14752 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_15068 = state_14905;
(statearr_15068[(86)] = inst_14752);

return statearr_15068;
})();
if(cljs.core.truth_(inst_14627)){
var statearr_15069_15230 = state_14905__$1;
(statearr_15069_15230[(1)] = (80));

} else {
var statearr_15070_15231 = state_14905__$1;
(statearr_15070_15231[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (38))){
var inst_14557 = (state_14905[(59)]);
var state_14905__$1 = state_14905;
var statearr_15071_15232 = state_14905__$1;
(statearr_15071_15232[(2)] = inst_14557);

(statearr_15071_15232[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (98))){
var inst_14802 = (state_14905[(69)]);
var inst_14692 = (state_14905[(35)]);
var inst_14800 = (state_14905[(70)]);
var inst_14805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14806 = (inst_14800 - inst_14802);
var inst_14807 = [inst_14692,inst_14806];
var inst_14808 = (new cljs.core.PersistentVector(null,2,(5),inst_14805,inst_14807,null));
var state_14905__$1 = state_14905;
var statearr_15072_15233 = state_14905__$1;
(statearr_15072_15233[(2)] = inst_14808);

(statearr_15072_15233[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (87))){
var inst_14761 = (state_14905[(85)]);
var state_14905__$1 = state_14905;
var statearr_15073_15234 = state_14905__$1;
(statearr_15073_15234[(2)] = inst_14761);

(statearr_15073_15234[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (30))){
var inst_14626 = (state_14905[(74)]);
var inst_14639 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14626);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(33),inst_14639);
} else {
if((state_val_14906 === (73))){
var inst_14571 = (state_14905[(32)]);
var inst_14740 = (state_14905[(2)]);
var state_14905__$1 = (function (){var statearr_15074 = state_14905;
(statearr_15074[(19)] = inst_14740);

return statearr_15074;
})();
if(cljs.core.truth_(inst_14571)){
var statearr_15075_15235 = state_14905__$1;
(statearr_15075_15235[(1)] = (74));

} else {
var statearr_15076_15236 = state_14905__$1;
(statearr_15076_15236[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (96))){
var inst_14792 = (state_14905[(67)]);
var inst_14725 = (state_14905[(16)]);
var inst_14724 = (state_14905[(17)]);
var inst_14692 = (state_14905[(35)]);
var inst_14686 = (state_14905[(40)]);
var inst_14841 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_14792,inst_14724,inst_14725,inst_14686,inst_14692);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(104),inst_14841);
} else {
if((state_val_14906 === (10))){
var inst_14563 = (state_14905[(84)]);
var inst_14585 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14563);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(13),inst_14585);
} else {
if((state_val_14906 === (18))){
var state_14905__$1 = state_14905;
var statearr_15077_15237 = state_14905__$1;
(statearr_15077_15237[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (105))){
var inst_14864 = (state_14905[(82)]);
var inst_14683 = (state_14905[(24)]);
var inst_14759 = (state_14905[(65)]);
var inst_14698 = (state_14905[(37)]);
var inst_14863 = (inst_14698.cljs$core$IFn$_invoke$arity$2 ? inst_14698.cljs$core$IFn$_invoke$arity$2(inst_14759,inst_14683) : inst_14698.call(null,inst_14759,inst_14683));
var inst_14864__$1 = (inst_14863 < (0));
var state_14905__$1 = (function (){var statearr_15079 = state_14905;
(statearr_15079[(82)] = inst_14864__$1);

return statearr_15079;
})();
if(cljs.core.truth_(inst_14864__$1)){
var statearr_15080_15238 = state_14905__$1;
(statearr_15080_15238[(1)] = (108));

} else {
var statearr_15081_15239 = state_14905__$1;
(statearr_15081_15239[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (52))){
var inst_14568 = (state_14905[(55)]);
var state_14905__$1 = state_14905;
var statearr_15082_15240 = state_14905__$1;
(statearr_15082_15240[(2)] = inst_14568);

(statearr_15082_15240[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (114))){
var inst_14699 = (state_14905[(14)]);
var inst_14709 = (state_14905[(20)]);
var inst_14703 = (state_14905[(23)]);
var inst_14759 = (state_14905[(65)]);
var inst_14704 = (state_14905[(41)]);
var inst_14879 = fluree.db.query.range.find_next_valid_node(inst_14709,inst_14759,inst_14699,inst_14703,inst_14704);
var state_14905__$1 = state_14905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14905__$1,(117),inst_14879);
} else {
if((state_val_14906 === (67))){
var state_14905__$1 = state_14905;
var statearr_15083_15241 = state_14905__$1;
(statearr_15083_15241[(2)] = null);

(statearr_15083_15241[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (71))){
var inst_14624 = (state_14905[(10)]);
var inst_14562 = (state_14905[(11)]);
var inst_14627 = (state_14905[(12)]);
var inst_14636 = (state_14905[(13)]);
var inst_14699 = (state_14905[(14)]);
var inst_14560 = (state_14905[(15)]);
var inst_14725 = (state_14905[(16)]);
var inst_14724 = (state_14905[(17)]);
var inst_14623 = (state_14905[(18)]);
var inst_14709 = (state_14905[(20)]);
var inst_14722 = (state_14905[(21)]);
var inst_14726 = (state_14905[(22)]);
var inst_14703 = (state_14905[(23)]);
var inst_14683 = (state_14905[(24)]);
var inst_14559 = (state_14905[(25)]);
var inst_14645 = (state_14905[(26)]);
var inst_14672 = (state_14905[(27)]);
var inst_14567 = (state_14905[(28)]);
var inst_14693 = (state_14905[(29)]);
var inst_14681 = (state_14905[(30)]);
var inst_14723 = (state_14905[(31)]);
var inst_14571 = (state_14905[(32)]);
var inst_14713 = (state_14905[(8)]);
var inst_14685 = (state_14905[(33)]);
var inst_14654 = (state_14905[(34)]);
var inst_14692 = (state_14905[(35)]);
var inst_14663 = (state_14905[(36)]);
var inst_14698 = (state_14905[(37)]);
var inst_14682 = (state_14905[(38)]);
var inst_14572 = (state_14905[(39)]);
var inst_14686 = (state_14905[(40)]);
var inst_14704 = (state_14905[(41)]);
var inst_14555 = (state_14905[(42)]);
var inst_14732 = (state_14905[(43)]);
var inst_14719 = (state_14905[(9)]);
var inst_14591 = (state_14905[(44)]);
var inst_14566 = (state_14905[(45)]);
var inst_14582 = (state_14905[(46)]);
var inst_14570 = (state_14905[(47)]);
var inst_14694 = (state_14905[(48)]);
var inst_14736 = (function (){var no_filter_QMARK_ = inst_14719;
var t = inst_14699;
var max_limit_QMARK_ = inst_14693;
var next_node = inst_14722;
var fast_forward_db_QMARK_ = inst_14704;
var s1 = inst_14582;
var o2 = inst_14645;
var t1 = inst_14559;
var predicate_fn = inst_14572;
var i = inst_14724;
var map__14554 = inst_14685;
var m1 = inst_14672;
var root_node = inst_14709;
var s2 = inst_14591;
var vec__14548 = inst_14623;
var p2 = inst_14663;
var permissions = inst_14694;
var limit = inst_14692;
var start_flake = inst_14682;
var flake_limit = inst_14686;
var offset = inst_14723;
var acc = inst_14726;
var t2 = inst_14566;
var op1 = inst_14560;
var o1 = inst_14636;
var vec__14544 = inst_14562;
var end_flake = inst_14683;
var base_result = inst_14732;
var s = inst_14725;
var node_start = inst_14713;
var p1 = inst_14654;
var subject_fn = inst_14571;
var object_fn = inst_14627;
var idx_compare = inst_14698;
var G__14733 = inst_14732;
var map__14547 = inst_14570;
var op2 = inst_14567;
var m2 = inst_14681;
var vec__14541 = inst_14555;
var vec__14551 = inst_14624;
var novelty = inst_14703;
return (function (p1__14522_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__14522_SHARP_.o,start_flake.o);
});
})();
var inst_14737 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14736,inst_14732);
var state_14905__$1 = state_14905;
var statearr_15084_15242 = state_14905__$1;
(statearr_15084_15242[(2)] = inst_14737);

(statearr_15084_15242[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (42))){
var inst_14659 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
if(cljs.core.truth_(inst_14659)){
var statearr_15085_15243 = state_14905__$1;
(statearr_15085_15243[(1)] = (43));

} else {
var statearr_15086_15244 = state_14905__$1;
(statearr_15086_15244[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (80))){
var inst_14624 = (state_14905[(10)]);
var inst_14562 = (state_14905[(11)]);
var inst_14627 = (state_14905[(12)]);
var inst_14636 = (state_14905[(13)]);
var inst_14699 = (state_14905[(14)]);
var inst_14560 = (state_14905[(15)]);
var inst_14725 = (state_14905[(16)]);
var inst_14724 = (state_14905[(17)]);
var inst_14623 = (state_14905[(18)]);
var inst_14709 = (state_14905[(20)]);
var inst_14722 = (state_14905[(21)]);
var inst_14726 = (state_14905[(22)]);
var inst_14703 = (state_14905[(23)]);
var inst_14683 = (state_14905[(24)]);
var inst_14559 = (state_14905[(25)]);
var inst_14645 = (state_14905[(26)]);
var inst_14672 = (state_14905[(27)]);
var inst_14567 = (state_14905[(28)]);
var inst_14693 = (state_14905[(29)]);
var inst_14681 = (state_14905[(30)]);
var inst_14723 = (state_14905[(31)]);
var inst_14571 = (state_14905[(32)]);
var inst_14713 = (state_14905[(8)]);
var inst_14685 = (state_14905[(33)]);
var inst_14654 = (state_14905[(34)]);
var inst_14692 = (state_14905[(35)]);
var inst_14663 = (state_14905[(36)]);
var inst_14698 = (state_14905[(37)]);
var inst_14752 = (state_14905[(86)]);
var inst_14682 = (state_14905[(38)]);
var inst_14572 = (state_14905[(39)]);
var inst_14686 = (state_14905[(40)]);
var inst_14704 = (state_14905[(41)]);
var inst_14555 = (state_14905[(42)]);
var inst_14732 = (state_14905[(43)]);
var inst_14719 = (state_14905[(9)]);
var inst_14591 = (state_14905[(44)]);
var inst_14566 = (state_14905[(45)]);
var inst_14582 = (state_14905[(46)]);
var inst_14570 = (state_14905[(47)]);
var inst_14694 = (state_14905[(48)]);
var inst_14754 = (function (){var no_filter_QMARK_ = inst_14719;
var t = inst_14699;
var max_limit_QMARK_ = inst_14693;
var next_node = inst_14722;
var fast_forward_db_QMARK_ = inst_14704;
var s1 = inst_14582;
var o2 = inst_14645;
var t1 = inst_14559;
var predicate_fn = inst_14572;
var i = inst_14724;
var map__14554 = inst_14685;
var m1 = inst_14672;
var root_node = inst_14709;
var s2 = inst_14591;
var vec__14548 = inst_14623;
var p2 = inst_14663;
var permissions = inst_14694;
var limit = inst_14692;
var start_flake = inst_14682;
var flake_limit = inst_14686;
var offset = inst_14723;
var acc = inst_14726;
var t2 = inst_14566;
var op1 = inst_14560;
var o1 = inst_14636;
var vec__14544 = inst_14562;
var end_flake = inst_14683;
var base_result = inst_14732;
var s = inst_14725;
var node_start = inst_14713;
var p1 = inst_14654;
var subject_fn = inst_14571;
var object_fn = inst_14627;
var idx_compare = inst_14698;
var G__14733 = inst_14752;
var map__14547 = inst_14570;
var op2 = inst_14567;
var m2 = inst_14681;
var vec__14541 = inst_14555;
var vec__14551 = inst_14624;
var novelty = inst_14703;
return (function (p1__14525_SHARP_){
var G__15087 = p1__14525_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__15087) : object_fn.call(null,G__15087));
});
})();
var inst_14755 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14754,inst_14752);
var state_14905__$1 = state_14905;
var statearr_15088_15245 = state_14905__$1;
(statearr_15088_15245[(2)] = inst_14755);

(statearr_15088_15245[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (37))){
var state_14905__$1 = state_14905;
var statearr_15089_15246 = state_14905__$1;
(statearr_15089_15246[(2)] = (-1));

(statearr_15089_15246[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (63))){
var inst_14654 = (state_14905[(34)]);
var inst_14663 = (state_14905[(36)]);
var inst_14591 = (state_14905[(44)]);
var inst_14582 = (state_14905[(46)]);
var inst_14694 = (state_14905[(48)]);
var inst_14716 = fluree.db.permissions_validate.no_filter_QMARK_(inst_14694,inst_14582,inst_14591,inst_14654,inst_14663);
var state_14905__$1 = state_14905;
var statearr_15090_15247 = state_14905__$1;
(statearr_15090_15247[(2)] = inst_14716);

(statearr_15090_15247[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (94))){
var inst_14855 = (state_14905[(2)]);
var state_14905__$1 = state_14905;
var statearr_15091_15248 = state_14905__$1;
(statearr_15091_15248[(2)] = inst_14855);

(statearr_15091_15248[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (8))){
var inst_14563 = (state_14905[(84)]);
var inst_14582 = (state_14905[(2)]);
var inst_14583 = fluree.db.util.core.pred_ident_QMARK_(inst_14563);
var state_14905__$1 = (function (){var statearr_15092 = state_14905;
(statearr_15092[(46)] = inst_14582);

return statearr_15092;
})();
if(inst_14583){
var statearr_15093_15249 = state_14905__$1;
(statearr_15093_15249[(1)] = (10));

} else {
var statearr_15094_15250 = state_14905__$1;
(statearr_15094_15250[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (49))){
var state_14905__$1 = state_14905;
var statearr_15095_15251 = state_14905__$1;
(statearr_15095_15251[(2)] = fluree.db.util.core.min_integer);

(statearr_15095_15251[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14906 === (84))){
var inst_14693 = (state_14905[(29)]);
var state_14905__$1 = state_14905;
var statearr_15096_15252 = state_14905__$1;
(statearr_15096_15252[(2)] = inst_14693);

(statearr_15096_15252[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_15097 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15097[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_15097[(1)] = (1));

return statearr_15097;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_14905){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_14905);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15098){var ex__2736__auto__ = e15098;
var statearr_15099_15253 = state_14905;
(statearr_15099_15253[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_14905[(4)]))){
var statearr_15100_15254 = state_14905;
(statearr_15100_15254[(1)] = cljs.core.first((state_14905[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15255 = state_14905;
state_14905 = G__15255;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_14905){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_14905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15101 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15101[(6)] = c__2755__auto__);

return statearr_15101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15311){
var state_val_15312 = (state_15311[(1)]);
if((state_val_15312 === (7))){
var inst_15275 = (state_15311[(7)]);
var inst_15285 = (state_15311[(8)]);
var inst_15283 = fluree.db.flake.Flake__GT_parts(inst_15275);
var inst_15284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15283,(0),null);
var inst_15285__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15283,(1),null);
var inst_15286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15283,(2),null);
var inst_15287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15283,(3),null);
var inst_15288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15283,(4),null);
var inst_15289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15283,(5),null);
var inst_15290 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15286,inst_15285__$1);
var state_15311__$1 = (function (){var statearr_15313 = state_15311;
(statearr_15313[(9)] = inst_15289);

(statearr_15313[(10)] = inst_15288);

(statearr_15313[(8)] = inst_15285__$1);

(statearr_15313[(11)] = inst_15284);

(statearr_15313[(12)] = inst_15287);

return statearr_15313;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15311__$1,(10),inst_15290);
} else {
if((state_val_15312 === (1))){
var inst_15263 = flakes;
var inst_15264 = cljs.core.seq(inst_15263);
var inst_15265 = cljs.core.first(inst_15264);
var inst_15266 = cljs.core.next(inst_15264);
var inst_15267 = cljs.core.PersistentVector.EMPTY;
var inst_15268 = inst_15263;
var inst_15269 = inst_15267;
var state_15311__$1 = (function (){var statearr_15314 = state_15311;
(statearr_15314[(13)] = inst_15265);

(statearr_15314[(14)] = inst_15266);

(statearr_15314[(15)] = inst_15268);

(statearr_15314[(16)] = inst_15269);

return statearr_15314;
})();
var statearr_15315_15333 = state_15311__$1;
(statearr_15315_15333[(2)] = null);

(statearr_15315_15333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15312 === (4))){
var inst_15275 = (state_15311[(7)]);
var inst_15278 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15275);
var state_15311__$1 = state_15311;
if(inst_15278){
var statearr_15316_15334 = state_15311__$1;
(statearr_15316_15334[(1)] = (7));

} else {
var statearr_15317_15335 = state_15311__$1;
(statearr_15317_15335[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15312 === (6))){
var inst_15307 = (state_15311[(2)]);
var state_15311__$1 = state_15311;
var statearr_15318_15336 = state_15311__$1;
(statearr_15318_15336[(2)] = inst_15307);

(statearr_15318_15336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15312 === (3))){
var inst_15309 = (state_15311[(2)]);
var state_15311__$1 = state_15311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15311__$1,inst_15309);
} else {
if((state_val_15312 === (2))){
var inst_15275 = (state_15311[(7)]);
var inst_15268 = (state_15311[(15)]);
var inst_15274 = cljs.core.seq(inst_15268);
var inst_15275__$1 = cljs.core.first(inst_15274);
var inst_15276 = cljs.core.next(inst_15274);
var state_15311__$1 = (function (){var statearr_15319 = state_15311;
(statearr_15319[(7)] = inst_15275__$1);

(statearr_15319[(17)] = inst_15276);

return statearr_15319;
})();
if(cljs.core.truth_(inst_15275__$1)){
var statearr_15320_15337 = state_15311__$1;
(statearr_15320_15337[(1)] = (4));

} else {
var statearr_15321_15338 = state_15311__$1;
(statearr_15321_15338[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15312 === (9))){
var inst_15304 = (state_15311[(2)]);
var state_15311__$1 = state_15311;
var statearr_15322_15339 = state_15311__$1;
(statearr_15322_15339[(2)] = inst_15304);

(statearr_15322_15339[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15312 === (5))){
var inst_15269 = (state_15311[(16)]);
var state_15311__$1 = state_15311;
var statearr_15323_15340 = state_15311__$1;
(statearr_15323_15340[(2)] = inst_15269);

(statearr_15323_15340[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15312 === (10))){
var inst_15289 = (state_15311[(9)]);
var inst_15288 = (state_15311[(10)]);
var inst_15276 = (state_15311[(17)]);
var inst_15285 = (state_15311[(8)]);
var inst_15269 = (state_15311[(16)]);
var inst_15284 = (state_15311[(11)]);
var inst_15287 = (state_15311[(12)]);
var inst_15292 = (state_15311[(2)]);
var inst_15293 = fluree.db.util.async.throw_err(inst_15292);
var inst_15294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15295 = [inst_15284,inst_15285,inst_15293,inst_15287,inst_15288,inst_15289];
var inst_15296 = (new cljs.core.PersistentVector(null,6,(5),inst_15294,inst_15295,null));
var inst_15297 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15296);
var inst_15298 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15269,inst_15297);
var inst_15268 = inst_15276;
var inst_15269__$1 = inst_15298;
var state_15311__$1 = (function (){var statearr_15324 = state_15311;
(statearr_15324[(15)] = inst_15268);

(statearr_15324[(16)] = inst_15269__$1);

return statearr_15324;
})();
var statearr_15325_15341 = state_15311__$1;
(statearr_15325_15341[(2)] = null);

(statearr_15325_15341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15312 === (8))){
var inst_15275 = (state_15311[(7)]);
var inst_15276 = (state_15311[(17)]);
var inst_15269 = (state_15311[(16)]);
var inst_15301 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15269,inst_15275);
var inst_15268 = inst_15276;
var inst_15269__$1 = inst_15301;
var state_15311__$1 = (function (){var statearr_15326 = state_15311;
(statearr_15326[(15)] = inst_15268);

(statearr_15326[(16)] = inst_15269__$1);

return statearr_15326;
})();
var statearr_15327_15342 = state_15311__$1;
(statearr_15327_15342[(2)] = null);

(statearr_15327_15342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____0 = (function (){
var statearr_15328 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15328[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__);

(statearr_15328[(1)] = (1));

return statearr_15328;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____1 = (function (state_15311){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15311);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15329){var ex__2736__auto__ = e15329;
var statearr_15330_15343 = state_15311;
(statearr_15330_15343[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15311[(4)]))){
var statearr_15331_15344 = state_15311;
(statearr_15331_15344[(1)] = cljs.core.first((state_15311[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15345 = state_15311;
state_15311 = G__15345;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__ = function(state_15311){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____1.call(this,state_15311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15332 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15332[(6)] = c__2755__auto__);

return statearr_15332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15347 = arguments.length;
switch (G__15347) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15517){
var state_val_15518 = (state_15517[(1)]);
if((state_val_15518 === (65))){
var state_15517__$1 = state_15517;
var statearr_15519_15619 = state_15517__$1;
(statearr_15519_15619[(2)] = null);

(statearr_15519_15619[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (70))){
var inst_15512 = (state_15517[(2)]);
var _ = (function (){var statearr_15520 = state_15517;
(statearr_15520[(4)] = cljs.core.rest((state_15517[(4)])));

return statearr_15520;
})();
var state_15517__$1 = state_15517;
var statearr_15521_15620 = state_15517__$1;
(statearr_15521_15620[(2)] = inst_15512);

(statearr_15521_15620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (62))){
var inst_15498 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15522_15621 = state_15517__$1;
(statearr_15522_15621[(2)] = inst_15498);

(statearr_15522_15621[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (7))){
var state_15517__$1 = state_15517;
var statearr_15523_15622 = state_15517__$1;
(statearr_15523_15622[(2)] = false);

(statearr_15523_15622[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (59))){
var inst_15472 = (state_15517[(2)]);
var inst_15473 = fluree.db.util.async.throw_err(inst_15472);
var state_15517__$1 = state_15517;
var statearr_15524_15623 = state_15517__$1;
(statearr_15524_15623[(2)] = inst_15473);

(statearr_15524_15623[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (20))){
var state_15517__$1 = state_15517;
var statearr_15525_15624 = state_15517__$1;
(statearr_15525_15624[(2)] = null);

(statearr_15525_15624[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (58))){
var inst_15462 = (state_15517[(2)]);
var inst_15463 = fluree.db.util.async.throw_err(inst_15462);
var inst_15464 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_15463);
var state_15517__$1 = state_15517;
var statearr_15526_15625 = state_15517__$1;
(statearr_15526_15625[(2)] = inst_15464);

(statearr_15526_15625[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (60))){
var inst_15398 = (state_15517[(7)]);
var inst_15361 = (state_15517[(8)]);
var inst_15358 = (state_15517[(9)]);
var inst_15359 = (state_15517[(10)]);
var inst_15478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15479 = [inst_15359,inst_15358,inst_15398,inst_15361];
var inst_15480 = (new cljs.core.PersistentVector(null,4,(5),inst_15478,inst_15479,null));
var inst_15481 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15480,opts);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(63),inst_15481);
} else {
if((state_val_15518 === (27))){
var inst_15409 = (state_15517[(11)]);
var inst_15398 = (state_15517[(7)]);
var inst_15409__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15398);
var state_15517__$1 = (function (){var statearr_15527 = state_15517;
(statearr_15527[(11)] = inst_15409__$1);

return statearr_15527;
})();
if(inst_15409__$1){
var statearr_15528_15626 = state_15517__$1;
(statearr_15528_15626[(1)] = (30));

} else {
var statearr_15529_15627 = state_15517__$1;
(statearr_15529_15627[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (1))){
var state_15517__$1 = state_15517;
var statearr_15530_15628 = state_15517__$1;
(statearr_15530_15628[(2)] = null);

(statearr_15530_15628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (69))){
var inst_15504 = (state_15517[(12)]);
var state_15517__$1 = state_15517;
var statearr_15531_15629 = state_15517__$1;
(statearr_15531_15629[(2)] = inst_15504);

(statearr_15531_15629[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (24))){
var inst_15359 = (state_15517[(10)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15359)){
var statearr_15532_15630 = state_15517__$1;
(statearr_15532_15630[(1)] = (27));

} else {
var statearr_15533_15631 = state_15517__$1;
(statearr_15533_15631[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (55))){
var inst_15398 = (state_15517[(7)]);
var inst_15456 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15457 = [inst_15398];
var inst_15458 = (new cljs.core.PersistentVector(null,1,(5),inst_15456,inst_15457,null));
var inst_15459 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
var inst_15460 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15458,inst_15459);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(58),inst_15460);
} else {
if((state_val_15518 === (39))){
var inst_15429 = (state_15517[(2)]);
var inst_15430 = fluree.db.util.async.throw_err(inst_15429);
var state_15517__$1 = state_15517;
var statearr_15534_15632 = state_15517__$1;
(statearr_15534_15632[(2)] = inst_15430);

(statearr_15534_15632[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (46))){
var inst_15442 = (state_15517[(13)]);
var inst_15442__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15517__$1 = (function (){var statearr_15535 = state_15517;
(statearr_15535[(13)] = inst_15442__$1);

return statearr_15535;
})();
if(cljs.core.truth_(inst_15442__$1)){
var statearr_15536_15633 = state_15517__$1;
(statearr_15536_15633[(1)] = (49));

} else {
var statearr_15537_15634 = state_15517__$1;
(statearr_15537_15634[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (4))){
var inst_15348 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15538_15635 = state_15517__$1;
(statearr_15538_15635[(2)] = inst_15348);

(statearr_15538_15635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (54))){
var inst_15454 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15454)){
var statearr_15539_15636 = state_15517__$1;
(statearr_15539_15636[(1)] = (55));

} else {
var statearr_15540_15637 = state_15517__$1;
(statearr_15540_15637[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (15))){
var inst_15360 = (state_15517[(14)]);
var inst_15379 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15360);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(18),inst_15379);
} else {
if((state_val_15518 === (48))){
var inst_15500 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15541_15638 = state_15517__$1;
(statearr_15541_15638[(2)] = inst_15500);

(statearr_15541_15638[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (50))){
var inst_15442 = (state_15517[(13)]);
var inst_15398 = (state_15517[(7)]);
var inst_15361 = (state_15517[(8)]);
var inst_15362 = (state_15517[(15)]);
var inst_15357 = (state_15517[(16)]);
var inst_15368 = (state_15517[(17)]);
var inst_15373 = (state_15517[(18)]);
var inst_15358 = (state_15517[(9)]);
var inst_15359 = (state_15517[(10)]);
var inst_15446 = (function (){var t = inst_15361;
var p = inst_15359;
var idx_predicate_QMARK_ = inst_15362;
var vec__15354 = inst_15357;
var o = inst_15398;
var tag_predicate_QMARK_ = inst_15368;
var temp__5751__auto__ = inst_15442;
var s = inst_15358;
var o_coerce_QMARK_ = inst_15373;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15517__$1 = state_15517;
var statearr_15542_15639 = state_15517__$1;
(statearr_15542_15639[(2)] = inst_15446);

(statearr_15542_15639[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (21))){
var inst_15394 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15543_15640 = state_15517__$1;
(statearr_15543_15640[(2)] = inst_15394);

(statearr_15543_15640[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (31))){
var inst_15409 = (state_15517[(11)]);
var state_15517__$1 = state_15517;
var statearr_15544_15641 = state_15517__$1;
(statearr_15544_15641[(2)] = inst_15409);

(statearr_15544_15641[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (32))){
var inst_15419 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15545_15642 = state_15517__$1;
(statearr_15545_15642[(2)] = inst_15419);

(statearr_15545_15642[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (40))){
var inst_15362 = (state_15517[(15)]);
var inst_15433 = (state_15517[(19)]);
var inst_15433__$1 = cljs.core.not(inst_15362);
var state_15517__$1 = (function (){var statearr_15546 = state_15517;
(statearr_15546[(19)] = inst_15433__$1);

return statearr_15546;
})();
if(inst_15433__$1){
var statearr_15547_15643 = state_15517__$1;
(statearr_15547_15643[(1)] = (43));

} else {
var statearr_15548_15644 = state_15517__$1;
(statearr_15548_15644[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (56))){
var inst_15361 = (state_15517[(8)]);
var inst_15448 = (state_15517[(20)]);
var inst_15358 = (state_15517[(9)]);
var inst_15359 = (state_15517[(10)]);
var inst_15466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15467 = [inst_15359,inst_15358,null,inst_15361];
var inst_15468 = (new cljs.core.PersistentVector(null,4,(5),inst_15466,inst_15467,null));
var inst_15469 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15448);
var inst_15470 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15468,inst_15469);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(59),inst_15470);
} else {
if((state_val_15518 === (33))){
var inst_15398 = (state_15517[(7)]);
var inst_15412 = cljs.core.fn_QMARK_(inst_15398);
var inst_15413 = (!(inst_15412));
var state_15517__$1 = state_15517;
var statearr_15549_15645 = state_15517__$1;
(statearr_15549_15645[(2)] = inst_15413);

(statearr_15549_15645[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (13))){
var inst_15360 = (state_15517[(14)]);
var inst_15377 = fluree.db.query.range.tag_string_QMARK_(inst_15360);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15377)){
var statearr_15550_15646 = state_15517__$1;
(statearr_15550_15646[(1)] = (15));

} else {
var statearr_15551_15647 = state_15517__$1;
(statearr_15551_15647[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (22))){
var inst_15390 = (state_15517[(2)]);
var inst_15391 = fluree.db.util.async.throw_err(inst_15390);
var state_15517__$1 = state_15517;
var statearr_15552_15648 = state_15517__$1;
(statearr_15552_15648[(2)] = inst_15391);

(statearr_15552_15648[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (36))){
var inst_15398 = (state_15517[(7)]);
var inst_15361 = (state_15517[(8)]);
var inst_15358 = (state_15517[(9)]);
var inst_15359 = (state_15517[(10)]);
var inst_15424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15425 = [inst_15359,inst_15398,inst_15358,inst_15361];
var inst_15426 = (new cljs.core.PersistentVector(null,4,(5),inst_15424,inst_15425,null));
var inst_15427 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15426,opts);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(39),inst_15427);
} else {
if((state_val_15518 === (41))){
var inst_15359 = (state_15517[(10)]);
var state_15517__$1 = state_15517;
var statearr_15553_15649 = state_15517__$1;
(statearr_15553_15649[(2)] = inst_15359);

(statearr_15553_15649[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (43))){
var inst_15398 = (state_15517[(7)]);
var state_15517__$1 = state_15517;
var statearr_15554_15650 = state_15517__$1;
(statearr_15554_15650[(2)] = inst_15398);

(statearr_15554_15650[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (61))){
var inst_15398 = (state_15517[(7)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15398)){
var statearr_15555_15651 = state_15517__$1;
(statearr_15555_15651[(1)] = (64));

} else {
var statearr_15556_15652 = state_15517__$1;
(statearr_15556_15652[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (29))){
var inst_15422 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15422)){
var statearr_15557_15653 = state_15517__$1;
(statearr_15557_15653[(1)] = (36));

} else {
var statearr_15558_15654 = state_15517__$1;
(statearr_15558_15654[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (44))){
var inst_15433 = (state_15517[(19)]);
var state_15517__$1 = state_15517;
var statearr_15559_15655 = state_15517__$1;
(statearr_15559_15655[(2)] = inst_15433);

(statearr_15559_15655[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (6))){
var inst_15359 = (state_15517[(10)]);
var inst_15364 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15359);
var inst_15365 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15364);
var state_15517__$1 = state_15517;
var statearr_15560_15656 = state_15517__$1;
(statearr_15560_15656[(2)] = inst_15365);

(statearr_15560_15656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (28))){
var inst_15359 = (state_15517[(10)]);
var state_15517__$1 = state_15517;
var statearr_15561_15657 = state_15517__$1;
(statearr_15561_15657[(2)] = inst_15359);

(statearr_15561_15657[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (64))){
var inst_15398 = (state_15517[(7)]);
var inst_15361 = (state_15517[(8)]);
var inst_15358 = (state_15517[(9)]);
var inst_15359 = (state_15517[(10)]);
var inst_15487 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15488 = [inst_15398,inst_15359,inst_15358,inst_15361];
var inst_15489 = (new cljs.core.PersistentVector(null,4,(5),inst_15487,inst_15488,null));
var inst_15490 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15489,opts);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(67),inst_15490);
} else {
if((state_val_15518 === (51))){
var inst_15449 = (state_15517[(21)]);
var inst_15359 = (state_15517[(10)]);
var inst_15448 = (state_15517[(2)]);
var inst_15449__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_15359);
var state_15517__$1 = (function (){var statearr_15562 = state_15517;
(statearr_15562[(21)] = inst_15449__$1);

(statearr_15562[(20)] = inst_15448);

return statearr_15562;
})();
if(inst_15449__$1){
var statearr_15563_15658 = state_15517__$1;
(statearr_15563_15658[(1)] = (52));

} else {
var statearr_15564_15659 = state_15517__$1;
(statearr_15564_15659[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (25))){
var inst_15368 = (state_15517[(17)]);
var inst_15504 = (state_15517[(2)]);
var state_15517__$1 = (function (){var statearr_15565 = state_15517;
(statearr_15565[(12)] = inst_15504);

return statearr_15565;
})();
if(cljs.core.truth_(inst_15368)){
var statearr_15566_15660 = state_15517__$1;
(statearr_15566_15660[(1)] = (68));

} else {
var statearr_15567_15661 = state_15517__$1;
(statearr_15567_15661[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (34))){
var inst_15362 = (state_15517[(15)]);
var state_15517__$1 = state_15517;
var statearr_15568_15662 = state_15517__$1;
(statearr_15568_15662[(2)] = inst_15362);

(statearr_15568_15662[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (17))){
var inst_15396 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15569_15663 = state_15517__$1;
(statearr_15569_15663[(2)] = inst_15396);

(statearr_15569_15663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (3))){
var inst_15515 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15517__$1,inst_15515);
} else {
if((state_val_15518 === (12))){
var inst_15360 = (state_15517[(14)]);
var state_15517__$1 = state_15517;
var statearr_15570_15664 = state_15517__$1;
(statearr_15570_15664[(2)] = inst_15360);

(statearr_15570_15664[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (2))){
var inst_15357 = (state_15517[(16)]);
var inst_15359 = (state_15517[(10)]);
var _ = (function (){var statearr_15571 = state_15517;
(statearr_15571[(4)] = cljs.core.cons((5),(state_15517[(4)])));

return statearr_15571;
})();
var inst_15357__$1 = fparts;
var inst_15358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15357__$1,(0),null);
var inst_15359__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15357__$1,(1),null);
var inst_15360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15357__$1,(2),null);
var inst_15361 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15357__$1,(3),null);
var inst_15362 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15359__$1);
var state_15517__$1 = (function (){var statearr_15572 = state_15517;
(statearr_15572[(8)] = inst_15361);

(statearr_15572[(15)] = inst_15362);

(statearr_15572[(16)] = inst_15357__$1);

(statearr_15572[(9)] = inst_15358);

(statearr_15572[(14)] = inst_15360);

(statearr_15572[(10)] = inst_15359__$1);

return statearr_15572;
})();
if(cljs.core.truth_(inst_15359__$1)){
var statearr_15573_15665 = state_15517__$1;
(statearr_15573_15665[(1)] = (6));

} else {
var statearr_15574_15666 = state_15517__$1;
(statearr_15574_15666[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (66))){
var inst_15496 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15575_15667 = state_15517__$1;
(statearr_15575_15667[(2)] = inst_15496);

(statearr_15575_15667[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (23))){
var inst_15398 = (state_15517[(7)]);
var inst_15361 = (state_15517[(8)]);
var inst_15358 = (state_15517[(9)]);
var inst_15359 = (state_15517[(10)]);
var inst_15400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15401 = [inst_15358,inst_15359,inst_15398,inst_15361];
var inst_15402 = (new cljs.core.PersistentVector(null,4,(5),inst_15400,inst_15401,null));
var inst_15403 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15402,opts);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(26),inst_15403);
} else {
if((state_val_15518 === (47))){
var inst_15359 = (state_15517[(10)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15359)){
var statearr_15576_15668 = state_15517__$1;
(statearr_15576_15668[(1)] = (60));

} else {
var statearr_15577_15669 = state_15517__$1;
(statearr_15577_15669[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (35))){
var inst_15416 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15578_15670 = state_15517__$1;
(statearr_15578_15670[(2)] = inst_15416);

(statearr_15578_15670[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (19))){
var inst_15360 = (state_15517[(14)]);
var inst_15359 = (state_15517[(10)]);
var inst_15386 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15359);
var inst_15387 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15386),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15360)].join('');
var inst_15388 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15387);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(22),inst_15388);
} else {
if((state_val_15518 === (57))){
var inst_15475 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15579_15671 = state_15517__$1;
(statearr_15579_15671[(2)] = inst_15475);

(statearr_15579_15671[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (68))){
var inst_15504 = (state_15517[(12)]);
var inst_15506 = fluree.db.query.range.coerce_tag_flakes(db,inst_15504);
var state_15517__$1 = state_15517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15517__$1,(71),inst_15506);
} else {
if((state_val_15518 === (11))){
var inst_15373 = (state_15517[(18)]);
var inst_15373__$1 = (state_15517[(2)]);
var inst_15374 = cljs.core.not(inst_15373__$1);
var state_15517__$1 = (function (){var statearr_15581 = state_15517;
(statearr_15581[(18)] = inst_15373__$1);

return statearr_15581;
})();
if(inst_15374){
var statearr_15582_15672 = state_15517__$1;
(statearr_15582_15672[(1)] = (12));

} else {
var statearr_15583_15673 = state_15517__$1;
(statearr_15583_15673[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (9))){
var inst_15360 = (state_15517[(14)]);
var inst_15370 = typeof inst_15360 === 'string';
var state_15517__$1 = state_15517;
var statearr_15584_15674 = state_15517__$1;
(statearr_15584_15674[(2)] = inst_15370);

(statearr_15584_15674[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (5))){
var _ = (function (){var statearr_15585 = state_15517;
(statearr_15585[(4)] = cljs.core.rest((state_15517[(4)])));

return statearr_15585;
})();
var state_15517__$1 = state_15517;
var ex15580 = (state_15517__$1[(2)]);
var statearr_15586_15675 = state_15517__$1;
(statearr_15586_15675[(5)] = ex15580);


if((ex15580 instanceof Error)){
var statearr_15587_15676 = state_15517__$1;
(statearr_15587_15676[(1)] = (4));

(statearr_15587_15676[(5)] = null);

} else {
throw ex15580;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (14))){
var inst_15358 = (state_15517[(9)]);
var inst_15398 = (state_15517[(2)]);
var state_15517__$1 = (function (){var statearr_15588 = state_15517;
(statearr_15588[(7)] = inst_15398);

return statearr_15588;
})();
if(cljs.core.truth_(inst_15358)){
var statearr_15589_15677 = state_15517__$1;
(statearr_15589_15677[(1)] = (23));

} else {
var statearr_15590_15678 = state_15517__$1;
(statearr_15590_15678[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (45))){
var inst_15437 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15591_15679 = state_15517__$1;
(statearr_15591_15679[(2)] = inst_15437);

(statearr_15591_15679[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (53))){
var inst_15449 = (state_15517[(21)]);
var state_15517__$1 = state_15517;
var statearr_15592_15680 = state_15517__$1;
(statearr_15592_15680[(2)] = inst_15449);

(statearr_15592_15680[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (26))){
var inst_15405 = (state_15517[(2)]);
var inst_15406 = fluree.db.util.async.throw_err(inst_15405);
var state_15517__$1 = state_15517;
var statearr_15593_15681 = state_15517__$1;
(statearr_15593_15681[(2)] = inst_15406);

(statearr_15593_15681[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (16))){
var inst_15360 = (state_15517[(14)]);
var inst_15384 = typeof inst_15360 === 'string';
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15384)){
var statearr_15594_15682 = state_15517__$1;
(statearr_15594_15682[(1)] = (19));

} else {
var statearr_15595_15683 = state_15517__$1;
(statearr_15595_15683[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (38))){
var inst_15502 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
var statearr_15596_15684 = state_15517__$1;
(statearr_15596_15684[(2)] = inst_15502);

(statearr_15596_15684[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (30))){
var inst_15362 = (state_15517[(15)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15362)){
var statearr_15597_15685 = state_15517__$1;
(statearr_15597_15685[(1)] = (33));

} else {
var statearr_15598_15686 = state_15517__$1;
(statearr_15598_15686[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (10))){
var inst_15368 = (state_15517[(17)]);
var state_15517__$1 = state_15517;
var statearr_15599_15687 = state_15517__$1;
(statearr_15599_15687[(2)] = inst_15368);

(statearr_15599_15687[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (18))){
var inst_15381 = (state_15517[(2)]);
var inst_15382 = fluree.db.util.async.throw_err(inst_15381);
var state_15517__$1 = state_15517;
var statearr_15600_15688 = state_15517__$1;
(statearr_15600_15688[(2)] = inst_15382);

(statearr_15600_15688[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (52))){
var inst_15398 = (state_15517[(7)]);
var inst_15451 = cljs.core.int_QMARK_(inst_15398);
var state_15517__$1 = state_15517;
var statearr_15601_15689 = state_15517__$1;
(statearr_15601_15689[(2)] = inst_15451);

(statearr_15601_15689[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (67))){
var inst_15492 = (state_15517[(2)]);
var inst_15493 = fluree.db.util.async.throw_err(inst_15492);
var state_15517__$1 = state_15517;
var statearr_15602_15690 = state_15517__$1;
(statearr_15602_15690[(2)] = inst_15493);

(statearr_15602_15690[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (71))){
var inst_15508 = (state_15517[(2)]);
var inst_15509 = fluree.db.util.async.throw_err(inst_15508);
var state_15517__$1 = state_15517;
var statearr_15603_15691 = state_15517__$1;
(statearr_15603_15691[(2)] = inst_15509);

(statearr_15603_15691[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (42))){
var inst_15440 = (state_15517[(2)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15440)){
var statearr_15604_15692 = state_15517__$1;
(statearr_15604_15692[(1)] = (46));

} else {
var statearr_15605_15693 = state_15517__$1;
(statearr_15605_15693[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (37))){
var inst_15359 = (state_15517[(10)]);
var state_15517__$1 = state_15517;
if(cljs.core.truth_(inst_15359)){
var statearr_15606_15694 = state_15517__$1;
(statearr_15606_15694[(1)] = (40));

} else {
var statearr_15607_15695 = state_15517__$1;
(statearr_15607_15695[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (63))){
var inst_15483 = (state_15517[(2)]);
var inst_15484 = fluree.db.util.async.throw_err(inst_15483);
var state_15517__$1 = state_15517;
var statearr_15608_15696 = state_15517__$1;
(statearr_15608_15696[(2)] = inst_15484);

(statearr_15608_15696[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (8))){
var inst_15368 = (state_15517[(17)]);
var inst_15368__$1 = (state_15517[(2)]);
var state_15517__$1 = (function (){var statearr_15609 = state_15517;
(statearr_15609[(17)] = inst_15368__$1);

return statearr_15609;
})();
if(cljs.core.truth_(inst_15368__$1)){
var statearr_15610_15697 = state_15517__$1;
(statearr_15610_15697[(1)] = (9));

} else {
var statearr_15611_15698 = state_15517__$1;
(statearr_15611_15698[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15518 === (49))){
var inst_15442 = (state_15517[(13)]);
var inst_15398 = (state_15517[(7)]);
var inst_15361 = (state_15517[(8)]);
var inst_15362 = (state_15517[(15)]);
var inst_15357 = (state_15517[(16)]);
var inst_15368 = (state_15517[(17)]);
var inst_15373 = (state_15517[(18)]);
var inst_15358 = (state_15517[(9)]);
var inst_15359 = (state_15517[(10)]);
var inst_15444 = (function (){var obj_fn = inst_15442;
var t = inst_15361;
var p = inst_15359;
var idx_predicate_QMARK_ = inst_15362;
var vec__15354 = inst_15357;
var o = inst_15398;
var tag_predicate_QMARK_ = inst_15368;
var temp__5751__auto__ = inst_15442;
var s = inst_15358;
var o_coerce_QMARK_ = inst_15373;
return (function (x){
var and__4221__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4221__auto__;
}
});
})();
var state_15517__$1 = state_15517;
var statearr_15612_15699 = state_15517__$1;
(statearr_15612_15699[(2)] = inst_15444);

(statearr_15612_15699[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_15613 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15613[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_15613[(1)] = (1));

return statearr_15613;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_15517){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15517);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15614){var ex__2736__auto__ = e15614;
var statearr_15615_15700 = state_15517;
(statearr_15615_15700[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15517[(4)]))){
var statearr_15616_15701 = state_15517;
(statearr_15616_15701[(1)] = cljs.core.first((state_15517[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15702 = state_15517;
state_15517 = G__15702;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_15517){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_15517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15617 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15617[(6)] = c__2755__auto__);

return statearr_15617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15704 = arguments.length;
switch (G__15704) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_15739){
var state_val_15740 = (state_15739[(1)]);
if((state_val_15740 === (7))){
var inst_15726 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15727 = ["Invalid collection name: ",inst_15726].join('');
var inst_15728 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15729 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15730 = cljs.core.PersistentHashMap.fromArrays(inst_15728,inst_15729);
var inst_15731 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15727,inst_15730);
var inst_15732 = (function(){throw inst_15731})();
var state_15739__$1 = state_15739;
var statearr_15741_15761 = state_15739__$1;
(statearr_15741_15761[(2)] = inst_15732);

(statearr_15741_15761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15740 === (1))){
var state_15739__$1 = state_15739;
var statearr_15742_15762 = state_15739__$1;
(statearr_15742_15762[(2)] = null);

(statearr_15742_15762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15740 === (4))){
var inst_15705 = (state_15739[(2)]);
var state_15739__$1 = state_15739;
var statearr_15743_15763 = state_15739__$1;
(statearr_15743_15763[(2)] = inst_15705);

(statearr_15743_15763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15740 === (6))){
var inst_15711 = (state_15739[(7)]);
var inst_15713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15714 = fluree.db.flake.max_subject_id(inst_15711);
var inst_15715 = [inst_15714];
var inst_15716 = (new cljs.core.PersistentVector(null,1,(5),inst_15713,inst_15715,null));
var inst_15717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15718 = fluree.db.flake.min_subject_id(inst_15711);
var inst_15719 = [inst_15718];
var inst_15720 = (new cljs.core.PersistentVector(null,1,(5),inst_15717,inst_15719,null));
var inst_15721 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15716,cljs.core._LT__EQ_,inst_15720,opts);
var state_15739__$1 = state_15739;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15739__$1,(9),inst_15721);
} else {
if((state_val_15740 === (3))){
var inst_15737 = (state_15739[(2)]);
var state_15739__$1 = state_15739;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15739__$1,inst_15737);
} else {
if((state_val_15740 === (2))){
var inst_15711 = (state_15739[(7)]);
var _ = (function (){var statearr_15745 = state_15739;
(statearr_15745[(4)] = cljs.core.cons((5),(state_15739[(4)])));

return statearr_15745;
})();
var inst_15711__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),name);
var state_15739__$1 = (function (){var statearr_15746 = state_15739;
(statearr_15746[(7)] = inst_15711__$1);

return statearr_15746;
})();
if(cljs.core.truth_(inst_15711__$1)){
var statearr_15747_15764 = state_15739__$1;
(statearr_15747_15764[(1)] = (6));

} else {
var statearr_15748_15765 = state_15739__$1;
(statearr_15748_15765[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15740 === (9))){
var inst_15723 = (state_15739[(2)]);
var inst_15724 = fluree.db.util.async.throw_err(inst_15723);
var state_15739__$1 = state_15739;
var statearr_15749_15766 = state_15739__$1;
(statearr_15749_15766[(2)] = inst_15724);

(statearr_15749_15766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15740 === (5))){
var _ = (function (){var statearr_15750 = state_15739;
(statearr_15750[(4)] = cljs.core.rest((state_15739[(4)])));

return statearr_15750;
})();
var state_15739__$1 = state_15739;
var ex15744 = (state_15739__$1[(2)]);
var statearr_15751_15767 = state_15739__$1;
(statearr_15751_15767[(5)] = ex15744);


var statearr_15752_15768 = state_15739__$1;
(statearr_15752_15768[(1)] = (4));

(statearr_15752_15768[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15740 === (8))){
var inst_15734 = (state_15739[(2)]);
var _ = (function (){var statearr_15753 = state_15739;
(statearr_15753[(4)] = cljs.core.rest((state_15739[(4)])));

return statearr_15753;
})();
var state_15739__$1 = state_15739;
var statearr_15754_15769 = state_15739__$1;
(statearr_15754_15769[(2)] = inst_15734);

(statearr_15754_15769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2733__auto__ = null;
var fluree$db$query$range$state_machine__2733__auto____0 = (function (){
var statearr_15755 = [null,null,null,null,null,null,null,null];
(statearr_15755[(0)] = fluree$db$query$range$state_machine__2733__auto__);

(statearr_15755[(1)] = (1));

return statearr_15755;
});
var fluree$db$query$range$state_machine__2733__auto____1 = (function (state_15739){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_15739);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e15756){var ex__2736__auto__ = e15756;
var statearr_15757_15770 = state_15739;
(statearr_15757_15770[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_15739[(4)]))){
var statearr_15758_15771 = state_15739;
(statearr_15758_15771[(1)] = cljs.core.first((state_15739[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15772 = state_15739;
state_15739 = G__15772;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2733__auto__ = function(state_15739){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2733__auto____1.call(this,state_15739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2733__auto____0;
fluree$db$query$range$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2733__auto____1;
return fluree$db$query$range$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_15759 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_15759[(6)] = c__2755__auto__);

return statearr_15759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15776 = flakes;
var vec__15777 = G__15776;
var seq__15778 = cljs.core.seq(vec__15777);
var first__15779 = cljs.core.first(seq__15778);
var seq__15778__$1 = cljs.core.next(seq__15778);
var flake_SINGLEQUOTE_ = first__15779;
var r = seq__15778__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15776__$1 = G__15776;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15785 = G__15776__$1;
var seq__15786 = cljs.core.seq(vec__15785);
var first__15787 = cljs.core.first(seq__15786);
var seq__15786__$1 = cljs.core.next(seq__15786);
var flake_SINGLEQUOTE___$1 = first__15787;
var r__$1 = seq__15786__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15789){var e = e15789;
return null;
}})();
var map__15788 = cmd_map;
var map__15788__$1 = cljs.core.__destructure_map(map__15788);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15788__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15790 = r__$1;
var G__15791 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15776__$1 = G__15790;
result_STAR___$1 = G__15791;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15800 = blocks;
var vec__15801 = G__15800;
var seq__15802 = cljs.core.seq(vec__15801);
var first__15803 = cljs.core.first(seq__15802);
var seq__15802__$1 = cljs.core.next(seq__15802);
var block_SINGLEQUOTE_ = first__15803;
var r = seq__15802__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15800__$1 = G__15800;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15808 = G__15800__$1;
var seq__15809 = cljs.core.seq(vec__15808);
var first__15810 = cljs.core.first(seq__15809);
var seq__15809__$1 = cljs.core.next(seq__15809);
var block_SINGLEQUOTE___$1 = first__15810;
var r__$1 = seq__15809__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15811 = block_SINGLEQUOTE___$1;
var map__15811__$1 = cljs.core.__destructure_map(map__15811);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15811__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15811__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15811__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15792_SHARP_){
var f = p1__15792_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15793_SHARP_){
var f = p1__15793_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,hash,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15794_SHARP_){
var f = p1__15794_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,hash,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,hash,instant,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15795_SHARP_){
var f = p1__15795_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,hash,instant,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15796_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15796_SHARP_.p,(106));
});})(G__15800__$1,result_STAR___$1,map__15811,map__15811__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15808,seq__15809,first__15810,seq__15809__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15800,vec__15801,seq__15802,first__15803,seq__15802__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15812 = r__$1;
var G__15813 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15800__$1 = G__15812;
result_STAR___$1 = G__15813;
continue;
}
break;
}
});
