// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4223__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_11476){
var state_val_11477 = (state_11476[(1)]);
if((state_val_11477 === (7))){
var inst_11471 = (state_11476[(2)]);
var _ = (function (){var statearr_11478 = state_11476;
(statearr_11478[(4)] = cljs.core.rest((state_11476[(4)])));

return statearr_11478;
})();
var state_11476__$1 = state_11476;
var statearr_11479_11501 = state_11476__$1;
(statearr_11479_11501[(2)] = inst_11471);

(statearr_11479_11501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (1))){
var state_11476__$1 = state_11476;
var statearr_11480_11502 = state_11476__$1;
(statearr_11480_11502[(2)] = null);

(statearr_11480_11502[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (4))){
var inst_11433 = (state_11476[(2)]);
var state_11476__$1 = state_11476;
var statearr_11481_11503 = state_11476__$1;
(statearr_11481_11503[(2)] = inst_11433);

(statearr_11481_11503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (6))){
var inst_11458 = (state_11476[(7)]);
var inst_11451 = (state_11476[(8)]);
var inst_11457 = cljs.core.seq(inst_11451);
var inst_11458__$1 = cljs.core.first(inst_11457);
var inst_11459 = cljs.core.next(inst_11457);
var inst_11460 = cljs.core.not(inst_11458__$1);
var state_11476__$1 = (function (){var statearr_11482 = state_11476;
(statearr_11482[(9)] = inst_11459);

(statearr_11482[(7)] = inst_11458__$1);

return statearr_11482;
})();
if(inst_11460){
var statearr_11483_11504 = state_11476__$1;
(statearr_11483_11504[(1)] = (8));

} else {
var statearr_11484_11505 = state_11476__$1;
(statearr_11484_11505[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (3))){
var inst_11474 = (state_11476[(2)]);
var state_11476__$1 = state_11476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11476__$1,inst_11474);
} else {
if((state_val_11477 === (2))){
var _ = (function (){var statearr_11485 = state_11476;
(statearr_11485[(4)] = cljs.core.cons((5),(state_11476[(4)])));

return statearr_11485;
})();
var inst_11446 = chs;
var inst_11447 = cljs.core.seq(inst_11446);
var inst_11448 = cljs.core.first(inst_11447);
var inst_11449 = cljs.core.next(inst_11447);
var inst_11450 = coll;
var inst_11451 = inst_11446;
var inst_11452 = inst_11450;
var state_11476__$1 = (function (){var statearr_11486 = state_11476;
(statearr_11486[(10)] = inst_11449);

(statearr_11486[(11)] = inst_11452);

(statearr_11486[(12)] = inst_11448);

(statearr_11486[(8)] = inst_11451);

return statearr_11486;
})();
var statearr_11487_11506 = state_11476__$1;
(statearr_11487_11506[(2)] = null);

(statearr_11487_11506[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (11))){
var inst_11452 = (state_11476[(11)]);
var inst_11459 = (state_11476[(9)]);
var inst_11464 = (state_11476[(2)]);
var inst_11465 = fluree.db.util.async.throw_err(inst_11464);
var inst_11466 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11452,inst_11465);
var inst_11451 = inst_11459;
var inst_11452__$1 = inst_11466;
var state_11476__$1 = (function (){var statearr_11489 = state_11476;
(statearr_11489[(11)] = inst_11452__$1);

(statearr_11489[(8)] = inst_11451);

return statearr_11489;
})();
var statearr_11490_11507 = state_11476__$1;
(statearr_11490_11507[(2)] = null);

(statearr_11490_11507[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (9))){
var inst_11458 = (state_11476[(7)]);
var state_11476__$1 = state_11476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11476__$1,(11),inst_11458);
} else {
if((state_val_11477 === (5))){
var _ = (function (){var statearr_11491 = state_11476;
(statearr_11491[(4)] = cljs.core.rest((state_11476[(4)])));

return statearr_11491;
})();
var state_11476__$1 = state_11476;
var ex11488 = (state_11476__$1[(2)]);
var statearr_11492_11508 = state_11476__$1;
(statearr_11492_11508[(5)] = ex11488);


var statearr_11493_11509 = state_11476__$1;
(statearr_11493_11509[(1)] = (4));

(statearr_11493_11509[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (10))){
var inst_11469 = (state_11476[(2)]);
var state_11476__$1 = state_11476;
var statearr_11494_11510 = state_11476__$1;
(statearr_11494_11510[(2)] = inst_11469);

(statearr_11494_11510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (8))){
var inst_11452 = (state_11476[(11)]);
var state_11476__$1 = state_11476;
var statearr_11495_11511 = state_11476__$1;
(statearr_11495_11511[(2)] = inst_11452);

(statearr_11495_11511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_11496 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11496[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__);

(statearr_11496[(1)] = (1));

return statearr_11496;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____1 = (function (state_11476){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_11476);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e11497){var ex__2736__auto__ = e11497;
var statearr_11498_11512 = state_11476;
(statearr_11498_11512[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_11476[(4)]))){
var statearr_11499_11513 = state_11476;
(statearr_11499_11513[(1)] = cljs.core.first((state_11476[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11514 = state_11476;
state_11476 = G__11514;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__ = function(state_11476){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____1.call(this,state_11476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_11500 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_11500[(6)] = c__2755__auto__);

return statearr_11500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_11540){
var state_val_11541 = (state_11540[(1)]);
if((state_val_11541 === (7))){
var inst_11535 = (state_11540[(2)]);
var _ = (function (){var statearr_11542 = state_11540;
(statearr_11542[(4)] = cljs.core.rest((state_11540[(4)])));

return statearr_11542;
})();
var state_11540__$1 = state_11540;
var statearr_11543_11565 = state_11540__$1;
(statearr_11543_11565[(2)] = inst_11535);

(statearr_11543_11565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (1))){
var state_11540__$1 = state_11540;
var statearr_11544_11566 = state_11540__$1;
(statearr_11544_11566[(2)] = null);

(statearr_11544_11566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (4))){
var inst_11515 = (state_11540[(2)]);
var state_11540__$1 = state_11540;
var statearr_11545_11567 = state_11540__$1;
(statearr_11545_11567[(2)] = inst_11515);

(statearr_11545_11567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (6))){
var state_11540__$1 = state_11540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_11540__$1,(8),chan);
} else {
if((state_val_11541 === (3))){
var inst_11538 = (state_11540[(2)]);
var state_11540__$1 = state_11540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_11540__$1,inst_11538);
} else {
if((state_val_11541 === (2))){
var _ = (function (){var statearr_11546 = state_11540;
(statearr_11546[(4)] = cljs.core.cons((5),(state_11540[(4)])));

return statearr_11546;
})();
var inst_11521 = coll;
var inst_11522 = inst_11521;
var state_11540__$1 = (function (){var statearr_11547 = state_11540;
(statearr_11547[(7)] = inst_11522);

return statearr_11547;
})();
var statearr_11548_11568 = state_11540__$1;
(statearr_11548_11568[(2)] = null);

(statearr_11548_11568[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (11))){
var inst_11533 = (state_11540[(2)]);
var state_11540__$1 = state_11540;
var statearr_11550_11569 = state_11540__$1;
(statearr_11550_11569[(2)] = inst_11533);

(statearr_11550_11569[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (9))){
var inst_11522 = (state_11540[(7)]);
var state_11540__$1 = state_11540;
var statearr_11551_11570 = state_11540__$1;
(statearr_11551_11570[(2)] = inst_11522);

(statearr_11551_11570[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (5))){
var _ = (function (){var statearr_11552 = state_11540;
(statearr_11552[(4)] = cljs.core.rest((state_11540[(4)])));

return statearr_11552;
})();
var state_11540__$1 = state_11540;
var ex11549 = (state_11540__$1[(2)]);
var statearr_11553_11571 = state_11540__$1;
(statearr_11553_11571[(5)] = ex11549);


var statearr_11554_11572 = state_11540__$1;
(statearr_11554_11572[(1)] = (4));

(statearr_11554_11572[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (10))){
var inst_11526 = (state_11540[(8)]);
var inst_11522 = (state_11540[(7)]);
var inst_11530 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_11522,inst_11526);
var inst_11522__$1 = inst_11530;
var state_11540__$1 = (function (){var statearr_11555 = state_11540;
(statearr_11555[(7)] = inst_11522__$1);

return statearr_11555;
})();
var statearr_11556_11573 = state_11540__$1;
(statearr_11556_11573[(2)] = null);

(statearr_11556_11573[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11541 === (8))){
var inst_11526 = (state_11540[(8)]);
var inst_11525 = (state_11540[(2)]);
var inst_11526__$1 = fluree.db.util.async.throw_err(inst_11525);
var inst_11527 = (inst_11526__$1 == null);
var state_11540__$1 = (function (){var statearr_11557 = state_11540;
(statearr_11557[(8)] = inst_11526__$1);

return statearr_11557;
})();
if(cljs.core.truth_(inst_11527)){
var statearr_11558_11574 = state_11540__$1;
(statearr_11558_11574[(1)] = (9));

} else {
var statearr_11559_11575 = state_11540__$1;
(statearr_11559_11575[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____0 = (function (){
var statearr_11560 = [null,null,null,null,null,null,null,null,null];
(statearr_11560[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__);

(statearr_11560[(1)] = (1));

return statearr_11560;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____1 = (function (state_11540){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_11540);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e11561){var ex__2736__auto__ = e11561;
var statearr_11562_11576 = state_11540;
(statearr_11562_11576[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_11540[(4)]))){
var statearr_11563_11577 = state_11540;
(statearr_11563_11577[(1)] = cljs.core.first((state_11540[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11578 = state_11540;
state_11540 = G__11578;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__ = function(state_11540){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____1.call(this,state_11540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2733__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_11564 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_11564[(6)] = c__2755__auto__);

return statearr_11564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
